(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    105530,       3894]*)
(*NotebookOutlinePosition[    110164,       4046]*)
(*  CellTagsIndexPosition[    109421,       4019]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 7",
    FontSize->18],
  "\nFactoring and Irreducibility"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.7"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.8.7"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.9.7"],

Cell["\<\
Before working on this lab, you should be familiar with polynomial \
arithmetic over integral domains. No previous labs need to be completed prior \
to attempting this lab.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.10.7"],

Cell["\<\
The goal of this lab is to introduce some of the tools available \
for polynomial factorization over a variety of rings.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Introduction to factoring and irreducibility"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.11.7"],

Cell["\<\
To get started, we read in the package that provides some of the \
functionality needed for this lab.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
In this lab we consider how to factor polynomials. From high school \
math, you should already have a sense of what this means, but now we will \
make the definition more formal. For example, suppose you were asked if you \
could factor the following polynomial.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f, x]\), 
    \(f = x\^2 - 3\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Would you answer \[OpenCurlyDoubleQuote]No,\[CloseCurlyDoubleQuote] since \
3 is not a perfect square, so this is not a difference of two squares? Or \
would you answer \[OpenCurlyDoubleQuote]Yes,\[CloseCurlyDoubleQuote] since \
one can factor this as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x - \@3)\)\ \((x + \@3)\)\)]],
  StyleBox[
  "? Actually, it is a poorly worded question. We will learn how we should \
ask it.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We consider polynomials from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D[x]\)]],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[
  " is an integral domain. This means that the coefficients of the \
polynomials in the indeterminate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" come from the integral domain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[". Given any nonconstant polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D[x]\)]],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", degree(",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(f(x))\) > 0\)]],
  StyleBox["), we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["irreducible ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["if whenever we write ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(g(x)\)\ \(h(x)\)\)]],
  StyleBox[" (with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  StyleBox[" from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D[x]\)]],
  StyleBox[") we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  StyleBox[" a unit in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D[x]\)]],
  StyleBox[". In other words, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[
  " cannot be factored except when one of the factors is a unit in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D[x]\)]],
  StyleBox[". When a nonconstant polynomial is not irreducible, we call it ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[", or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["factored",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[". Note that frequently the domain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[" is a field.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Thus, in our original question we should have asked if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" was irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  StyleBox[" (the rationals) or if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" was irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\)]],
  StyleBox[
  " (the reals) or over some other integral domain. In other words, we need \
to specify the ring from which our coefficients come.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - 3\)]],
  StyleBox[
  " is irreducible or reducible over the integers, rationals, reals, and \
complex numbers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\^2 - 6\)]],
  StyleBox[
  " is irreducible or reducible over the integers, rationals, reals, and \
complex numbers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\^2 + 6\)]],
  StyleBox[
  " is irreducible or reducible over the integers, rationals, reals, and \
complex numbers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Some techniques on testing the irreducibility of polynomials "
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.7"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.4.1 Polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontVariations->{"CompatibilityType"->"Subscript"}],
  "\[LongDash]",
  StyleBox["Theorem 1",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.8.7"],

Cell[TextData[{
  StyleBox["Suppose we consider the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 4  x\^3 + 3  x\^2 - 2  x + 1\)]],
  StyleBox[" over the field ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  StyleBox[" for some prime ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" is reducible, then there exists ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  StyleBox[" from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p[x]\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(g(x)\)\ \(h(x)\)\)]],
  StyleBox[" and neither ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  StyleBox[" nor ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  StyleBox[
  " is a unit. Consequently, these two polynomials must have degrees 1 and 2 \
(or 2 and 1), since the sum of their degrees must be 3. But then the linear \
factor, whose form is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a  x + b\)]],
  StyleBox[", has a zero, namely ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(-a\^\(-1\)\)\ b\)]],
  StyleBox[". Consequently, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[
  " also has a zero. Therefore, all we have to do is look for the zeros of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[
  ". This can be summarized in the following theorem; you will probably find \
the theorem in your text. (Note that this argument works whether the field is \
finite or infinite.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[": Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be a field. A polynomial of degree 2 or 3 over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" if and only if it has a zero in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s pursue the irreducibility of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 4  x\^3 + 3  x\^2 - 2  x + 1\)]],
  StyleBox[" over some finite field ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  StyleBox[
  ". In this case, the task is particularly simple, since all we need to do \
is check to see if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" has a zero over the field. Here is how we might proceed for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = 3\)]],
  StyleBox[". First we define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f = Poly[Z[3], 4\ x\^3 + 3\ x\^2 - 2\ x + 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we map ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " over the entire domain of the field."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[PolynomialEvaluation[f, #1]&, {0, 1, 2}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Thus we see that 1 is a zero for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[". (Why 1? Look at the set over which we mapped ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[".) Consequently, by the theorem, we know that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" is reducible, you should be able to find ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = \(g(x)\)\ \(h(x)\)\)]],
  StyleBox[". Do so.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x) = 7  x\^3 + 13  x\^2 + 2  x + 7\)]],
  StyleBox[". Starting with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = 2\)]],
  StyleBox[", find the first prime ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" for which ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.4.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\^3\  + \ 3  x\^2\  - \ 1\)]],
  " over \[DoubleStruckCapitalQ] \[LongDash] Rational Root Theorem"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.9.7"],

Cell[TextData[{
  "Consider the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`f = 2  x\^3 + 3  x\^2 - 1\)]],
  " over the rationals, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f, x]\), 
    \(f = 2\ x\^3 + 3\ x\^2 - 1\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Since this is a cubic, we could use Theorem 1. However, since the rationals \
are an infinite field, we don\[CloseCurlyQuote]t want to look for zeros by \
brute force (i.e., test every element to see if it is a zero), so we \
introduce another tool, designed specifically for finding rational zeros: the \
Rational Root Theorem."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Rational Root Theorem",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[": Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(f \((x)\) = 
            \(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + 
              \[CenterEllipsis] + \(a\_2\) x\^2 + \(a\_1\) x + a\_0\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is a polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ][x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" (with ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["n",
            FontColor->RGBColor[0, 0, 1]]], TraditionalForm]]],
  StyleBox[" not zero). If ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" are relatively prime and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`f(r\/s) = 0\)],
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(r | a\_0\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(s | a\_n\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note what this says. If we have a rational zero of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\/s\)]],
  StyleBox[", then the numerator ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[
  " must divide the constant term of the polynomial and the denominator ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[
  " must divide the leading coefficient. This reduces the search for a root \
from an infinite set to a finite number of possibilities. (Why does this lead \
to a finite list?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For our polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f = 2  x\^3 + 3  x\^2 - 1\)]],
  StyleBox[", we are looking for integers ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" divides ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  StyleBox[" (thus ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]1\)\)]],
  StyleBox[") and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" divides 2 (thus ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]1\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]2\)\)]],
  StyleBox["). Hence, the list of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["candidates",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " for rational roots is as follows. (Do you agree with this list?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(possibleRationalRoots = {1, \(-1\), 1\/2, \(-\(1\/2\)\)}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we just need to test ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " at each of these and look for a zero."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f /. {x \[Rule] possibleRationalRoots}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "In this case, both ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " and 1/2 are zeros for ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". We can now express ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " in factored form."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is reducible, you should be able to find ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f = \(g(x)\) \(h(x)\)\)]],
  StyleBox[
  ". In fact, factor it completely into linear terms. (You should already \
know two of them.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Given the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`4  x\^5 + 3  x\^3 - 8  x\^2 + 7  x - 6\)]],
  StyleBox[", what are the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["possible",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" rational roots to try? Do any of these work?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.4.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`x\^4\  - \ 2  x\^3\  - \ 7\ x\^2\  - \ \(11\/3\) x\  - \ 4\/3\)]],
  " over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  " \[LongDash] Mod ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " Irreducibility Test"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.10.7"],

Cell[TextData[{
  "First we define ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " to be a polynomial we wish to factor."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f, x]\), 
    \(f = x\^4 - 2\ x\^3 - 7\ x\^2 - \(11\/3\) x - 4\/3\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Since we need our polynomial to have integer coefficients (look at the \
formulation of the Rational Root Theorem), we multiply ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " by 3 to get a new polynomial over \[DoubleStruckCapitalZ]. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[g]\), 
    \(g = Expand[3\ f]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "If we find that ",
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  " can be factored into a product ",
  Cell[BoxData[
      \(TraditionalForm\`\(h(x)\)\ \(k(x)\)\)]],
  ", we will then have a factorization of ",
  Cell[BoxData[
      \(TraditionalForm\`f(x) : 3\^\(-1\)\ \(h(x)\)\ \(g(x)\)\)]],
  ". Note that ",
  Cell[BoxData[
      \(TraditionalForm\`g(x)\)]],
  " is a quartic, so it does not satisfy the hypotheses of Theorem 1. \
However, if we can find a linear factor, then the remaining factor will be \
cubic and we can complete the process with the cubic (if we are looking for a \
complete factorization, not just trying to determine reducibility). If we \
cannot find a linear factor, it still may be factorable into two quadratic \
polynomials. (Why?)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
We will approach the problem first with the Rational Root Theorem \
and then introduce another technique.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Using the Rational Root Theorem", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.10.8.7"],

Cell[TextData[{
  StyleBox["First we determine all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["possible",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" rational roots (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", form the list of candidates).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(possibleRationalRoots = {1, \(-1\), 1\/3, \(-\(1\/3\)\), 2, \(-2\), 
        2\/3, \(-\(2\/3\)\), 4, \(-4\), 4\/3, \(-\(4\/3\)\)}\n (*\ 
      Do\ you\ agree\ with\ this\ \(list?\)\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we evaluate ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " at each possible root."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g /. {x \[Rule] possibleRationalRoots}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This indicates that 4 is a zero. Therefore, we need to find the quotient \
of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x - 4\)]],
  ". (Note that since 4 is a zero, ",
  Cell[BoxData[
      \(TraditionalForm\`x - 4\)]],
  " is a factor.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g2 = PolynomialQuotient[g, x - 4, x]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
This is our new polynomial to pursue. Continuing with the Rational \
Root Theorem, let us continue factoring it.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(possibleRationalRoots = {1, \(-1\), 1\/3, \(-\(1\/3\)\)}\n (*\ 
      Do\ you\ agree\ with\ this\ \(list?\)\ *) \)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(g2 /. {x \[Rule] possibleRationalRoots}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We see that none of these are zeros. Hence ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " is factored as ",
  Cell[BoxData[
      \(TraditionalForm\`\((x - 4)\)\ \((3  x\^3 + 6  x\^2 + 3  x + 1)\)\)]],
  ", so ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is factored as ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(3\^\(-1\)\) \((x - 4)\)\ \((3  x\^3 + 6  x\^2 + 3  x + 1)\)\)]],
  ". Thus ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is reducible."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Note: There is a function to determine the list of candidates, \
though usually it is fairly easy to create the list by hand.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RationalRootCandidates[g]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Using the Mod p Irreducibility Test", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.10.9.7"],

Cell[TextData[{
  "Even though we have seen that ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is not irreducible (i.e., it is reducible), let us continue with a \
general approach to testing a polynomial using the Mod ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " Irreducibility Test. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Mod ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          FontWeight->"Bold",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" Irreducibility Test",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[": Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be a prime and suppose that ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[
  " is a polynomial over \[DoubleStruckCapitalZ] (the integers) with ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        RowBox[{\(deg \((f \((x)\))\)\), 
          StyleBox["\[GreaterEqual]",
            FontFamily->"Courier"], "1"}], TraditionalForm]],
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(h \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be the polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ]\_p[x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  " ",
  StyleBox["obtained from ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ][x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" by reducing all the coefficients of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" modulo ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[". If the degree of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(h \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" equals the degree of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" and if ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(h \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ]\_p\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["\[DoubleStruckCapitalQ]",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" (the rationals).",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We still need the ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " we defined above."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we wish to reduce this modulo some prime. (Although the built-in \
function ",
  StyleBox["PolynomialMod",
    FontFamily->"Courier"],
  " could be used here\[LongDash]specifically, ",
  StyleBox["PolynomialMod[g, 2]",
    FontFamily->"Courier"],
  "\[LongDash]we use another approach that is more general.) Try 2 and call \
this new polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["g2",
            FontSlant->"Italic"], "."}], TraditionalForm]]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g2 = Poly[Z[2], g]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "It may be clear that this is reducible (since ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a factor), but for the record, this is how we can check for zeros."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[PolynomialEvaluation[g2, #1]&, Elements[Z[2]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We see that 0 is a zero and hence ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a factor. This does ",
  StyleBox["not",
    FontSlant->"Italic"],
  " give us any indication of a factor in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ][x]\)]],
  ", nor does it imply that ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " is reducible over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ][x]\)]],
  " (though in this case we know it is reducible from our work with the \
Rational Root Theorem). For the sake of argument, let us try a few other \
primes."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(g3 = Poly[Z[3], g]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Note that the theorem does not apply when reducing mod 3. \
(Why?)\
\>", "Text"],

Cell[BoxData[{
    \(g5\  = \ Poly[Z[5], \ g]\), 
    \(Map[PolynomialEvaluation[g5, \ #]&, \ Elements[Z[5]]]\)}], "Input"],

Cell["You can try any other prime modulus with the following.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p\  = \ Input["\<Enter a prime\>"]; \n
    If[PrimeQ[p], 
      \ {"\<prime = \>"<>ToString[p]<>"\<:\>", \ gp\  = \ Poly[Z[p], \ g], \ 
        If[Degree[gp]\  == \ 4, \ 
          Map[PolynomialEvaluation[gp, \ #]&, \ Elements[Z[p]]], \ 
          "\<does not apply\>"]}, \ Print["\<You didn't enter a prime.\>"]]
      \)], "Input"],

Cell[TextData[{
  StyleBox[
  "We see that every time we get at least one factor, and hence the \
polynomial is not irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  StyleBox[". When using the Mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[
  " Irreducibility Test, we either continue with more primes, hoping to \
strike gold, or we begin to think that it is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  StyleBox[" and try another test (such as the Rational Root Test).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.4.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^4\  - \ 3  x\^2\  + \ 2  x\  + \ 1\)]],
  " over \[DoubleStruckCapitalQ] \[LongDash] How to handle quartics"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.11.7"],

Cell[TextData[
"First let\[CloseCurlyQuote]s define our next polynomial."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(h = x\^4 - 3\ x\^2 + 2\ x + 1\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Now let\[CloseCurlyQuote]s look for a linear factor. We can try the Mod 2 \
Irreducibility Test."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(h2\  = \ Poly[Z[2], \ h]\), 
    \(Map[PolynomialEvaluation[h2, \ #]&, \ {0, \ 1}]\)}], "Input"],

Cell[TextData[{
  StyleBox["This shows that the polynomial reduced mod 2, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["h2",
          FontSlant->"Italic"], TraditionalForm]]],
  ",",
  StyleBox[" has no linear factors over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  StyleBox[
  ", but this does not make it irreducible. What about quadratic factors over \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  StyleBox[
  "? Could one of these be a factor? What are the irreducible quadratics in ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2[x]\)]],
  StyleBox[
  "? There are only 4 quadratics, so we can investigate them quite easily.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(quads = 
      \(Table[x\^2 + a\ x + b, {a, 0, 1}, {b, 0, 1}] // Flatten\) // 
        Map[Poly[Z[2], \ #]&, \ #]&\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "It\[CloseCurlyQuote]s obvious that the first and third polynomials in this \
list have ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " as a factor, so we need to investigate only the second and fourth. First \
we try the second factor."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[PolynomialEvaluation[quads[\([2]\)], \ #]&, \ {0, \ 1}]\)], "Input"],

Cell[TextData[{
  "The second factor has a zero, namely 1. (This is not surprising; in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm
      \`x\^2 + 1 = 
        \(x\^2 - 1 = 
          \(\((x - 1)\)\ \((x + 1)\) = \((x - 1)\)\ \((x - 1)\)\)\)\)]],
  ".)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[PolynomialEvaluation[quads[\([4]\)], \ #]&, \ {0, \ 1}]\)], "Input"],

Cell[TextData[{
  StyleBox["From this, we can see that the only irreducible quadratic in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2[x]\)]],
  StyleBox[" is the fourth candidate, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + x + 1\)]],
  StyleBox[". Recall that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["h2",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[
  " is our original polynomial, reduced modulo 2. We want to know if this is \
divisible by the irreducible quadratic. We use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["PolynomialDivision",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function, which returns the quotient and remainder when given two \
polynomials.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(q = quads\[LeftDoubleBracket]4\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialDivision[h2, q]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We see that ",
  Cell[BoxData[
      FormBox[
        StyleBox["h2",
          FontSlant->"Italic"], TraditionalForm]]],
  " is the square of ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(q\ q == h2\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "These two steps show that there are two quadratic factors, so this \
polynomial is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  StyleBox[". Hence, we need to try a new prime since we ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["cannot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" make any conclusion about reducibility over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  StyleBox[" when we know that we have reducibility over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_p\)]],
  StyleBox[". Next we try ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = 3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(h3\  = \ Poly[Z[3], \ h]\), 
    \(Map[PolynomialEvaluation[h3, \ #]&, \ {0, \ 1, \ 2}]\)}], "Input"],

Cell[TextData[{
  "This also yields a reducible polynomial (since we have a zero). Try again \
with ",
  Cell[BoxData[
      \(TraditionalForm\`p = 5\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(h5\  = \ Poly[Z[5], \ h]\), 
    \(Map[PolynomialEvaluation[h5, \ #]&, \ {0, \ 1, \ 2, \ 3, \ 4}]\)}], 
  "Input"],

Cell[TextData[{
  StyleBox[
  "We can see that at least there are no linear factors, but now we have to \
consider quadratic ones. Below, with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = 5\)]],
  ",",
  StyleBox[
  " we use the \[OpenCurlyDoubleQuote]brute force\[CloseCurlyDoubleQuote] \
method used with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = 2\)]],
  StyleBox[". Here, we create all possible ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["monic",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" quadratic polynomials over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  StyleBox[
  ". (To be monic, the leading coefficient is the unity of the ring, 1. You \
may wonder, and rightly so, why we need to consider only monic polynomials. \
Look in your text for an answer or ask your professor if you can",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t find out why.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Before computing the list of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["possible",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " monic quadratics, count how many there will be. How many? How did you \
arrive at your result?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(quads = 
      \(Table[x\^2 + a\ x + b, {a, 0, 4}, {b, 0, 4}] // Flatten\) // \n\t
        Map[Poly[Z[5], \ #]&, \ #]&\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["With each of these quadratics, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s divide ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        StyleBox["h5",
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox[" by the candidate and look at the remainder on division.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[PolynomialRemainder[h5, \ #]&, \ quads]\)], "Input"],

Cell[TextData[{
  "Observing that there are no remainders consisting of the 0 polynomial, we \
see that there are no quadratic factors. Therefore, since ",
  Cell[BoxData[
      FormBox[
        StyleBox["h5",
          FontSlant->"Italic"], TraditionalForm]]],
  " has no linear factors and no quadratic factors, it is irreducible. Then, \
by the Mod 5 Irreducibility Test, ",
  Cell[BoxData[
      \(TraditionalForm\`h(x)\)]],
  " is also irreducible over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.4.5 ",
  Cell[BoxData[
      \(TraditionalForm\`2  x\^4 - 2  x\^3 - 17  x\^2 + 25  x - 7\)]],
  " over \[DoubleStruckCapitalZ] \[LongDash]Theorem 2"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.12.7"],

Cell[TextData[
"In this case, we wish to know whether a polynomial is factorable over \
\[DoubleStruckCapitalZ], the integers. Consider the following theorem, which \
may be of use."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ][x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["\[DoubleStruckCapitalQ]",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[", then it is reducible over \[DoubleStruckCapitalZ].",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  " be defined as follows."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[f, x]\), 
    \(f = x\^4 + 2\ x\^3 + 3\ x\^2 + 6\ x + 9\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Give as complete a factorization for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[
  " as possible. Is it reducible over \[DoubleStruckCapitalZ]? Why or why \
not? Hint: Use the Rational Root Theorem to look for zeros. If there are \
quadratic factors, they must look like ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x\^2 + a  x + c)\)\ \((x\^2 + b  x + d)\)\)]],
  StyleBox[". Since the middle coefficients of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" are relatively small and all positive, it is reasonable to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["guess",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c = \(d = 3\)\)]],
  StyleBox[" so that if it factors into two quadratics, it looks like ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((x\^2 + a  x + 3)\)\ \((x\^2 + b  x + 3)\)\)]],
  StyleBox[". Try expanding this product and comparing coefficients.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.4.6 ",
  Cell[BoxData[
      \(TraditionalForm
      \`3  x\^8\  - \ 4  x\^6\  + \ 8  x\^5\  - \ 10  x\  + \ 6\)]],
  " over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  " \[LongDash] Eisenstein\[CloseCurlyQuote]s Criterion"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.13.7"],

Cell["First we define our polynomial.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(f = 3\ x\^8 - 4\ x\^6 + 8\ x\^5 - 10\ x + 6\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Perhaps we should think about this one from another perspective at \
first. Suppose we graph this over some domain.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Plot[f, {x, \(-3\), 3}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
It looks as if the interesting part of the function occurs in a \
smaller domain.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Plot[f, {x, \(-1.65\), 1.1}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What does the graph say about the number of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["real",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " zeros? What does it say about the number of rational zeros? Considering \
the graph and the degree of the polynomial, what does it say about the number \
of pure complex (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", nonreal) zeros?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Consider the following.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[h]\), 
    \(h\  = \ Poly[Z[5], \ f]\), 
    \(Map[PolynomialEvaluation[h, \ #]&, \ Elements[Z[5]]]\)}], "Input"],

Cell["\<\
This indicates that there are no linear factors. There could, \
however, be quadratic, cubic or quartic factors. If there was a cubic factor, \
there could also be a quintic or another cubic and a quadratic. It could get \
quite complicated. Fortunately, for some very special polynomials whose \
coefficients behave in a particular fashion, there is a theorem that can be \
used to determine irreducibility.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Eisenstein",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "\[CloseCurlyQuote]",
  StyleBox["s Criterion",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm
      \`f(x) = \(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + 
          \[CenterEllipsis] + \(a\_2\) x\^2 + \(a\_1\) x + a\_0\)]],
  StyleBox[" be a polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][x]\)]],
  StyleBox[" (with ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[" not zero). If there is a prime ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["does",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" divide the leading coefficient ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[" but ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["does",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" divide every other coefficient, and we also have ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`p\^2\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" dividing ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`a\_0\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " again."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(f\), 
    \(CoefficientList[f, x]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that the prime ",
  Cell[BoxData[
      \(TraditionalForm\`p = 2\)]],
  " does indeed divide every coefficient except the leading 3 and that ",
  Cell[BoxData[
      \(TraditionalForm\`p\^2 = 4\)]],
  " does not divide 6. Therefore, by Eisenstein\[CloseCurlyQuote]s Criterion, \
",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " is irreducible. Although Eisenstein\[CloseCurlyQuote]s Criterion is \
fairly easy to implement by hand, the following will walk you through the \
steps."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(EisensteinsCriterionQ[f, Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.4.7 ",
  Cell[BoxData[
      \(TraditionalForm\`x\^4\  + \ 4\)]],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]]
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.14.7"],

Cell[TextData[{
  StyleBox["We now consider a polynomial over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontVariations->{"CompatibilityType"->"Subscript"}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[p]\), 
    \(p = Poly[Z[7], \ x\^4 + 4]\), 
    \(Map[PolynomialEvaluation[p, \ #]&, \ Elements[Z[7]]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This code defines the polynomial and then shows that there is no zero for \
the polynomial over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[". Since we are interested in determining irreducibility over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[", we cannot use the Mod ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[
  " Irreducibility Test. (Why?) Having no zero indicates that there is no \
linear factor (and hence no corresponding irreducible cubic). There is still \
the possibility of two irreducible quadratic factors. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s check this out. We assume that we have two quadratic factors.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[a, b, c, d, e, f]\), 
    \(PossibleFactors = {a\ x\^2 + b\ x + c, d\ x\^2 + e\ x + f}\)}], "Input",\

  AspectRatioFixed->True],

Cell["Here is the product of these factors.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(prod\  = \ Apply[Times, \ PossibleFactors]\), 
    \(Expand[prod]\)}], "Input"],

Cell[TextData[{
  "We know that ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " are nonzero and hence invertible. (If either was zero, they would not be \
quadratics.) We can factor out both of them and assume that they are equal to \
1."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(a = \(d = 1\); \)\), 
    \(t = Expand[prod]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s look at our original polynomial and compare it to ",
  
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " with identical factors of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " collected together."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p\), 
    \(Collect[t, x]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that we need ",
  Cell[BoxData[
      \(TraditionalForm\`c  f = 4\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c\ e + b\ f = 0\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c + b\ e + f = 0\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b + e = 0\)]],
  ". Additionally, we want the modulus to be 7."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(equations = {c\ f == 4, c\ e + b\ f == 0, c + b\ e + f == 0, 
        b + e == 0, Modulus == 7}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["How can we get the constant term of 4? What are the values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox["? We know that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2*2 = 4\)]],
  StyleBox[". Is there any other possibility? Yes. Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[" is a field, there are 5 other possibilities (such as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3*6 = 4\)]],
  StyleBox[
  "). One way to see all of them is to look at the multiplication table for ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(MultiplicationTable[Z[7], Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The unordered pairs that have a product of 4 (mod 7) are ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{4, 1}\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{2, 2}\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{3, 6}\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{5, 5}\)]],
  StyleBox[
  ". We now solve the system of equations arising from each possibility of \
values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" having a product of 4. Notice that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rest[equations]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" represents a list of all but the first equation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["equations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". First we test when we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c = 4\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f = 1\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(s1 = Solve[Rest[equations] /. {c \[Rule] 4, f \[Rule] 1}, {e, b}]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "There is no solution for this case. Next we try ",
  Cell[BoxData[
      \(TraditionalForm\`c = 2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`f = 2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(s2 = Solve[Rest[equations] /. {c \[Rule] 2, f \[Rule] 2}, {e, b}]\)], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
Here we get two solutions, although we will see that they are \
really the same.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Given that we now already know our polynomial is reducible, why might we \
want to consider the cases where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c = 5\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f = 5\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c = 3\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f = 6\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider the remaining two cases. First we consider \
",
  Cell[BoxData[
      \(TraditionalForm\`c = 3\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`f = 6\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(s3 = Solve[Rest[equations] /. {c \[Rule] 3, f \[Rule] 6}, {e, b}]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Again, there is no solution in this case. Finally, we try ",
  Cell[BoxData[
      \(TraditionalForm\`c = 5\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`f = 5\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(s4 = Solve[Rest[equations] /. {c \[Rule] 5, f \[Rule] 5}, {e, b}]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Again, no solution. Let\[CloseCurlyQuote]s return to the second case. The \
first solution is "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(s2\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Here are the results of the possible factors for these values of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`e\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PossibleFactors /. {b \[Rule] 5, c \[Rule] 2, e \[Rule] 2, f \[Rule] 2}
        \)], "Input",
  AspectRatioFixed->True],

Cell["The second solution:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(s2\[LeftDoubleBracket]2\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->True],

Cell["We repeat the process used with the second solution.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PossibleFactors /. {b \[Rule] 2, c \[Rule] 2, e \[Rule] 5, f \[Rule] 2}
        \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Therefore, there really is only one solution. The difference in our two \
results is the ordering of the two factors. In conclusion, we see that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[" is reducible over the field ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->12,
    FontVariations->{"CompatibilityType"->"Subscript"}],
  StyleBox["in exactly one way: into two quadratics.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.4.8 ",
  Cell[BoxData[
      \(TraditionalForm\`x\^4\  - \ 2  x\^3\  + \ x\^2\  + \ 1\)]],
  " over \[DoubleStruckCapitalR]"
}], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.15.7"],

Cell["\<\
This situation is a little different because we are considering \
factoring a polynomial over the reals.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[p]\), 
    \(p = x\^4 - 2\ x\^3 + x\^2 + 1\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "First we consider rational factorizations. The Rational Root Test \
indicates that the only possibilities for zeros are ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PlusMinus]1\)\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p /. x \[Rule] {1, \(-1\)}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This indicates that there are no linear factors over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  ". How about the mod ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " test?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(h\  = \ Poly[Z[2], \ p]\), 
    \(Map[PolynomialEvaluation[h, \ #]&, \ Elements[Z[2]]]\)}], "Input"],

Cell[TextData[{
  "This also shows that there are no linear factors (no surprise), but what \
about quadratic factors? We have already seen in section 7.4.4 that the only \
irreducible quadratic factor for ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + x + 1\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Poly[Z[2], Expand[\((x\^2 + x + 1)\)\ \((x\^2 + x + 1)\)]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This shows that ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " is reducible mod 2, but unfortunately, it does not address the question \
about reducibility in \[DoubleStruckCapitalQ]. We could continue with another \
prime, but this will at best indicate irreducibility over \
\[DoubleStruckCapitalQ] and will not address the irreducibility over \
\[DoubleStruckCapitalR] at all. Let\[CloseCurlyQuote]s try some other \
approaches."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["First attempt", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.15.8.7"],

Cell["\<\
We use some techniques from calculus: determining the derivative \
and setting it equal to zero to find possible relative extrema.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(dp = D[p, x]\), 
    \(dzeros = Solve[dp == 0]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we evaluate ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " at the zeros."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p /. dzeros\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This indicates that we have two relative minima at the value 1 and a \
relative maximum at the value ",
  Cell[BoxData[
      \(TraditionalForm\`17\/16\)]],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why can we make this conclusion?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Why does this tell us that this polynomial has no linear factors?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Second attempt", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.15.9.7"],

Cell["Perhaps we should plot it!", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Plot[p, {x, \(-2\), 2}, PlotRange \[Rule] {0, 3}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The graph seems to indicate that there are no real zeros, since the \
function does not cross the ",
  Cell[BoxData[
      FormBox["x", TraditionalForm]]],
  "-axis."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(NSolve[p == 0]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
This confirms that the solutions are complex and thus nonreal. \
Hence, there are no linear factors.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine whether we can write ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["p", TraditionalForm]]],
  StyleBox[
  " as a product of two irreducible quadratic factors over the reals. \
Caution: This takes a little bit of work.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "More polynomials for practice"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.13.7"],

Cell["\<\
Consider the following collection of polynomials over various \
fields. In each case, determine whether the polynomial is reducible or \
irreducible over the stated field. When reducible, factor it as completely as \
possible. In each case, state the theorem(s) you use and show your work. Some \
are fairly easy, while others may take some work. For your convenience, all \
the theorems used in this lab are collected together in a list in section \
7.6.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^3 + x\^2 + x + 1\)]],
  StyleBox[" over \[DoubleStruckCapitalQ]",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^4 + x\^2 - 6\)]],
  StyleBox[" over \[DoubleStruckCapitalQ]",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`4  x\^3 + 3  x\^2 + x + 1\)]],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`25  x\^5 - 9  x\^4 + 3  x\^2 - 12\)]],
  StyleBox[" over \[DoubleStruckCapitalQ]",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q20",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^4 - 3  x\^3 + 2  x\^2 + 4  x - 1\)]],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Toolbox of theorems"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.14.7"],

Cell[TextData[{
  StyleBox["Theorem 1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[": Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be a field. A polynomial of degree 2 or 3 over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" if and only if it has a zero in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["F",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Rational Root Theorem",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[": Suppose ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[
          \(f \((x)\) = 
            \(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + 
              \[CenterEllipsis] + \(a\_2\) x\^2 + \(a\_1\) x + a\_0\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is a polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ][x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" (with ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["a",
            FontColor->RGBColor[0, 0, 1]], 
          StyleBox["n",
            FontColor->RGBColor[0, 0, 1]]], TraditionalForm]]],
  StyleBox[" not zero). If ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["r",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["s",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" are relatively prime and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`f(r\/s)\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(r | a\_0\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(s | a\_n\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell[TextData[{
  StyleBox["Mod ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["p",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" Irreducibility Test",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[": Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be a prime and suppose that ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[
  " is a polynomial over \[DoubleStruckCapitalZ] (the integers) with degree \
greater than or equal to 1. Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(h \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be the polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ]\_p[x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  " ",
  StyleBox["obtained from ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ][x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" by reducing all the coefficients of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" modulo ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["p",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[". If the degree of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(h \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" equals the degree of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" and if ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(h \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ]\_p\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["\[DoubleStruckCapitalQ]",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" (the rationals).",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" be in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\[DoubleStruckCapitalZ][x]\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox[\(f \((x)\)\),
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[" is reducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      FormBox[
        StyleBox["\[DoubleStruckCapitalQ]",
          FontColor->RGBColor[0, 0, 1]], TraditionalForm]]],
  StyleBox[", then it is reducible over \[DoubleStruckCapitalZ].",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Eisenstein",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "\[CloseCurlyQuote]",
  StyleBox["s Criterion",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm
      \`f(x) = \(a\_n\) x\^n + \(a\_\(n - 1\)\) x\^\(n - 1\) + 
          \[CenterEllipsis] + \(a\_1\) x + a\_0\)]],
  " ",
  StyleBox["be a polynomial in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][x]\)]],
  StyleBox[" (with ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[" not zero). If there is a prime ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["does",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" divide the leading coefficient ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[", but ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["does",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" divide every other coefficient, and we also have ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`p\^2\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" dividing ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`a\_0\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`f(x)\)]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontColor->RGBColor[0, 0, 1]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.7 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Final perspective"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.15.7"],

Cell[TextData[{
  "We have been purposely avoiding a very powerful built-in function of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that does much of the work shown in this lab in one swoop."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[x\^4 - 2\ x\^3 - 7\ x\^2 - \(11\ x\)\/3 - 4\/3]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[2\ x\^3 + 3\ x\^2 - 1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[x\^4 - 3\ x\^2 + 2\ x + 1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[x\^4 + 4, Modulus \[Rule] 7]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Isn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "t this disgusting? All the sweat and blood, not to mention the joy, is \
removed by this powerful function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Factor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ModpIrreducibilityQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" may be illustrative as well.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ModpIrreducibilityQ[x\^4 - 3\ x\^2 + 2\ x + 1, Mode \[Rule] Textual]
      \)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(ModpIrreducibilityQ[12 + 5\ x + 8\ x\^2 + 11\ x\^3 + 3\ x\^4, 
      Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[12 + 5\ x + 8\ x\^2 + 11\ x\^3 + 3\ x\^4, Modulus \[Rule] 11]
      \)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(RationalRootTheorem[6\ x\^3 - 5\ x\^2 - 7\ x + 4]\), 
    \(Factor[6\ x\^3 - 5\ x\^2 - 7\ x + 4]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q21",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Evaluate the following input cell. What is a reasonable conjecture based \
on your observations? Can you prove it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[{Prime[n], Factor[x\^4 + 1, Modulus \[Rule] Prime[n]]}, {n, 1, 
          25}]]\)], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.8 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.16.7"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Poly\)\)], "Input"],

Cell[BoxData[
    \(\(?PolynomialEvaluation\)\)], "Input"],

Cell[BoxData[
    \(\(?Expand\)\)], "Input"],

Cell[BoxData[
    \(\(?PolynomialQuotient\)\)], "Input"],

Cell[BoxData[
    \(\(?RationalRootCandidates\)\)], "Input"],

Cell[BoxData[
    \(\(?Elements\)\)], "Input"],

Cell[BoxData[
    \(\(?Table\)\)], "Input"],

Cell[BoxData[
    \(\(?Map\)\)], "Input"],

Cell[BoxData[
    \(\(?Flatten\)\)], "Input"],

Cell[BoxData[
    \(\(?PolynomialDivision\)\)], "Input"],

Cell[BoxData[
    \(\(?PolynomialRemainder\)\)], "Input"],

Cell[BoxData[
    \(\(?Plot\)\)], "Input"],

Cell[BoxData[
    \(\(?EisensteinsCriterionQ\)\)], "Input"],

Cell[BoxData[
    \(\(?Apply\)\)], "Input"],

Cell[BoxData[
    \(\(?Collect\)\)], "Input"],

Cell[BoxData[
    \(\(?Modulus\)\)], "Input"],

Cell[BoxData[
    \(\(?MultiplicationTable\)\)], "Input"],

Cell[BoxData[
    \(\(?Solve\)\)], "Input"],

Cell[BoxData[
    \(\(?Rest\)\)], "Input"],

Cell[BoxData[
    \(\(?NSolve\)\)], "Input"],

Cell[BoxData[
    \(\(?Factor\)\)], "Input"],

Cell[BoxData[
    \(\(?ModpIrreducibilityQ\)\)], "Input"],

Cell[BoxData[
    \(\(?RationalRootTheorem\)\)], "Input"],

Cell[BoxData[
    \(\(?Prime\)\)], "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{632, 436},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingStartingPageNumber->49,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@Aj[S0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:7.7"->{
    Cell[2382, 76, 176, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:7.7"]},
  "a:7.8.7"->{
    Cell[2583, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.8.7"]},
  "a:7.9.7"->{
    Cell[6950, 234, 191, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.9.7"]},
  "a:7.10.7"->{
    Cell[7425, 255, 184, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.10.7"]},
  "a:7.11.7"->{
    Cell[7841, 275, 223, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.11.7"]},
  "a:7.12.7"->{
    Cell[15653, 566, 240, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.12.7"]},
  "a:7.12.8.7"->{
    Cell[15918, 578, 489, 17, 56, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.8.7"]},
  "a:7.12.9.7"->{
    Cell[25099, 918, 325, 10, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.9.7"]},
  "a:7.12.10.7"->{
    Cell[33584, 1228, 475, 17, 50, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.10.7"]},
  "a:7.12.10.8.7"->{
    Cell[35868, 1308, 133, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:7.12.10.8.7"]},
  "a:7.12.10.9.7"->{
    Cell[38828, 1423, 137, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:7.12.10.9.7"]},
  "a:7.12.11.7"->{
    Cell[47391, 1718, 335, 10, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.11.7"]},
  "a:7.12.12.7"->{
    Cell[56935, 2058, 262, 8, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.12.7"]},
  "a:7.12.13.7"->{
    Cell[60717, 2189, 368, 12, 30, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.13.7"]},
  "a:7.12.14.7"->{
    Cell[67676, 2441, 325, 12, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.14.7"]},
  "a:7.12.15.7"->{
    Cell[78925, 2869, 238, 8, 46, "Subsection",
      Evaluatable->False,
      CellTags->"a:7.12.15.7"]},
  "a:7.12.15.8.7"->{
    Cell[81293, 2955, 115, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:7.12.15.8.7"]},
  "a:7.12.15.9.7"->{
    Cell[82991, 3031, 116, 3, 28, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:7.12.15.9.7"]},
  "a:7.13.7"->{
    Cell[84467, 3093, 208, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.13.7"]},
  "a:7.14.7"->{
    Cell[87804, 3227, 198, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.14.7"]},
  "a:7.15.7"->{
    Cell[100565, 3675, 196, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.15.7"]},
  "a:7.16.7"->{
    Cell[103545, 3793, 371, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.16.7"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:7.7", 106720, 3927},
  {"a:7.8.7", 106828, 3931},
  {"a:7.9.7", 106941, 3935},
  {"a:7.10.7", 107055, 3939},
  {"a:7.11.7", 107170, 3943},
  {"a:7.12.7", 107285, 3947},
  {"a:7.12.8.7", 107403, 3951},
  {"a:7.12.9.7", 107527, 3955},
  {"a:7.12.10.7", 107652, 3959},
  {"a:7.12.10.8.7", 107781, 3963},
  {"a:7.12.10.9.7", 107914, 3967},
  {"a:7.12.11.7", 108045, 3971},
  {"a:7.12.12.7", 108172, 3975},
  {"a:7.12.13.7", 108298, 3979},
  {"a:7.12.14.7", 108425, 3983},
  {"a:7.12.15.7", 108552, 3987},
  {"a:7.12.15.8.7", 108680, 3991},
  {"a:7.12.15.9.7", 108813, 3995},
  {"a:7.13.7", 108941, 3999},
  {"a:7.14.7", 109058, 4003},
  {"a:7.15.7", 109175, 4007},
  {"a:7.16.7", 109293, 4011}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 176, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:7.7"],

Cell[CellGroupData[{
Cell[2583, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.8.7"],
Cell[2909, 100, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3760, 124, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5130, 166, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5282, 171, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5904, 193, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6596, 219, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6950, 234, 191, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.9.7"],
Cell[7144, 244, 244, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7425, 255, 184, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.10.7"],
Cell[7612, 265, 192, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7841, 275, 223, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.11.7"],
Cell[8067, 285, 173, 5, 33, "Text",
  Evaluatable->False],
Cell[8243, 292, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[8417, 298, 334, 7, 71, "Text",
  Evaluatable->False],
Cell[8754, 307, 95, 3, 45, "Input"],
Cell[8852, 312, 624, 17, 71, "Text",
  Evaluatable->False],
Cell[9479, 331, 3563, 131, 147, "Text",
  Evaluatable->False],
Cell[13045, 464, 903, 28, 71, "Text",
  Evaluatable->False],
Cell[13951, 494, 474, 17, 67, "Question",
  Evaluatable->False],
Cell[14428, 513, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[14505, 517, 477, 17, 67, "Question",
  Evaluatable->False],
Cell[14985, 536, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[15062, 540, 477, 17, 67, "Question",
  Evaluatable->False],
Cell[15542, 559, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[15653, 566, 240, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.12.7"],

Cell[CellGroupData[{
Cell[15918, 578, 489, 17, 56, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.8.7"],
Cell[16410, 597, 2533, 83, 166, "Text",
  Evaluatable->False],
Cell[18946, 682, 1282, 44, 53, "Text",
  Evaluatable->False],
Cell[20231, 728, 1112, 37, 71, "Text",
  Evaluatable->False],
Cell[21346, 767, 103, 2, 31, "Input"],
Cell[21452, 771, 183, 7, 33, "Text",
  Evaluatable->False],
Cell[21638, 780, 103, 2, 27, "Input"],
Cell[21744, 784, 777, 26, 52, "Text",
  Evaluatable->False],
Cell[22524, 812, 811, 30, 67, "Question",
  Evaluatable->False],
Cell[23338, 844, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23415, 848, 522, 20, 48, "Question",
  Evaluatable->False],
Cell[23940, 870, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[24017, 874, 968, 35, 67, "Question",
  Evaluatable->False],
Cell[24988, 911, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[25099, 918, 325, 10, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.9.7"],
Cell[25427, 930, 280, 10, 33, "Text",
  Evaluatable->False],
Cell[25710, 942, 108, 3, 45, "Input"],
Cell[25821, 947, 403, 7, 90, "Text",
  Evaluatable->False],
Cell[26227, 956, 2418, 81, 55, "Text",
  Evaluatable->False],
Cell[28648, 1039, 822, 25, 92, "Text",
  Evaluatable->False],
Cell[29473, 1066, 1630, 59, 71, "Text",
  Evaluatable->False],
Cell[31106, 1127, 115, 2, 42, "Input"],
Cell[31224, 1131, 197, 7, 33, "Text",
  Evaluatable->False],
Cell[31424, 1140, 97, 2, 27, "Input"],
Cell[31524, 1144, 328, 13, 33, "Text",
  Evaluatable->False],
Cell[31855, 1159, 890, 32, 67, "Question",
  Evaluatable->False],
Cell[32748, 1193, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32825, 1197, 645, 22, 67, "Question",
  Evaluatable->False],
Cell[33473, 1221, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[33584, 1228, 475, 17, 50, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.10.7"],
Cell[34062, 1247, 188, 7, 33, "Text",
  Evaluatable->False],
Cell[34253, 1256, 132, 3, 60, "Input"],
Cell[34388, 1261, 322, 8, 52, "Text",
  Evaluatable->False],
Cell[34713, 1271, 96, 3, 43, "Input"],
Cell[34812, 1276, 851, 21, 128, "Text",
  Evaluatable->False],
Cell[35666, 1299, 177, 5, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[35868, 1308, 133, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:7.12.10.8.7"],
Cell[36004, 1313, 460, 17, 33, "Text",
  Evaluatable->False],
Cell[36467, 1332, 248, 4, 78, "Input"],
Cell[36718, 1338, 173, 7, 33, "Text",
  Evaluatable->False],
Cell[36894, 1347, 97, 2, 27, "Input"],
Cell[36994, 1351, 379, 14, 52, "Text",
  Evaluatable->False],
Cell[37376, 1367, 95, 2, 27, "Input"],
Cell[37474, 1371, 184, 5, 52, "Text",
  Evaluatable->False],
Cell[37661, 1378, 175, 3, 60, "Input"],
Cell[37839, 1383, 98, 2, 27, "Input"],
Cell[37940, 1387, 564, 20, 52, "Text",
  Evaluatable->False],
Cell[38507, 1409, 197, 5, 52, "Text",
  Evaluatable->False],
Cell[38707, 1416, 84, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[38828, 1423, 137, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:7.12.10.9.7"],
Cell[38968, 1428, 365, 11, 52, "Text",
  Evaluatable->False],
Cell[39336, 1441, 4433, 146, 91, "Text",
  Evaluatable->False],
Cell[43772, 1589, 170, 7, 33, "Text",
  Evaluatable->False],
Cell[43945, 1598, 60, 2, 27, "Input"],
Cell[44008, 1602, 563, 17, 71, "Text",
  Evaluatable->False],
Cell[44574, 1621, 77, 2, 27, "Input"],
Cell[44654, 1625, 250, 7, 52, "Text",
  Evaluatable->False],
Cell[44907, 1634, 109, 2, 27, "Input"],
Cell[45019, 1638, 690, 21, 90, "Text",
  Evaluatable->False],
Cell[45712, 1661, 77, 2, 27, "Input"],
Cell[45792, 1665, 90, 3, 33, "Text"],
Cell[45885, 1670, 123, 2, 43, "Input"],
Cell[46011, 1674, 119, 2, 33, "Text",
  Evaluatable->False],
Cell[46133, 1678, 354, 7, 91, "Input"],
Cell[46490, 1687, 852, 25, 90, "Text",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[47391, 1718, 335, 10, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.11.7"],
Cell[47729, 1730, 131, 3, 33, "Text",
  Evaluatable->False],
Cell[47863, 1735, 88, 2, 29, "Input"],
Cell[47954, 1739, 171, 4, 33, "Text",
  Evaluatable->False],
Cell[48128, 1745, 117, 2, 43, "Input"],
Cell[48248, 1749, 1058, 34, 90, "Text",
  Evaluatable->False],
Cell[49309, 1785, 173, 4, 48, "Input"],
Cell[49485, 1791, 322, 9, 52, "Text",
  Evaluatable->False],
Cell[49810, 1802, 92, 1, 27, "Input"],
Cell[49905, 1805, 391, 13, 52, "Text",
  Evaluatable->False],
Cell[50299, 1820, 92, 1, 27, "Input"],
Cell[50394, 1823, 1083, 34, 90, "Text",
  Evaluatable->False],
Cell[51480, 1859, 110, 2, 27, "Input"],
Cell[51593, 1863, 84, 2, 27, "Input"],
Cell[51680, 1867, 277, 12, 33, "Text",
  Evaluatable->False],
Cell[51960, 1881, 69, 2, 27, "Input"],
Cell[52032, 1885, 1100, 35, 71, "Text",
  Evaluatable->False],
Cell[53135, 1922, 122, 2, 43, "Input"],
Cell[53260, 1926, 220, 8, 33, "Text",
  Evaluatable->False],
Cell[53483, 1936, 135, 3, 43, "Input"],
Cell[53621, 1941, 1291, 40, 109, "Text",
  Evaluatable->False],
Cell[54915, 1983, 538, 19, 67, "Question",
  Evaluatable->False],
Cell[55456, 2004, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[55533, 2008, 177, 4, 48, "Input"],
Cell[55713, 2014, 507, 17, 52, "Text",
  Evaluatable->False],
Cell[56223, 2033, 76, 1, 27, "Input"],
Cell[56302, 2036, 596, 17, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[56935, 2058, 262, 8, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.12.7"],
Cell[57200, 2068, 240, 5, 52, "Text",
  Evaluatable->False],
Cell[57443, 2075, 1333, 44, 34, "Text",
  Evaluatable->False],
Cell[58779, 2121, 164, 7, 33, "Text",
  Evaluatable->False],
Cell[58946, 2130, 122, 3, 45, "Input"],
Cell[59071, 2135, 1532, 45, 143, "Question",
  Evaluatable->False],
Cell[60606, 2182, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[60717, 2189, 368, 12, 30, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.13.7"],
Cell[61088, 2203, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[61186, 2207, 102, 2, 29, "Input"],
Cell[61291, 2211, 187, 5, 52, "Text",
  Evaluatable->False],
Cell[61481, 2218, 88, 2, 27, "Input"],
Cell[61572, 2222, 153, 5, 33, "Text",
  Evaluatable->False],
Cell[61728, 2229, 93, 2, 27, "Input"],
Cell[61824, 2233, 722, 24, 86, "Question",
  Evaluatable->False],
Cell[62549, 2259, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[62626, 2263, 87, 2, 33, "Text",
  Evaluatable->False],
Cell[62716, 2267, 140, 3, 59, "Input"],
Cell[62859, 2272, 480, 9, 109, "Text",
  Evaluatable->False],
Cell[63342, 2283, 3327, 117, 91, "Text",
  Evaluatable->False],
Cell[66672, 2402, 188, 7, 33, "Text",
  Evaluatable->False],
Cell[66863, 2411, 94, 3, 43, "Input"],
Cell[66960, 2416, 571, 16, 90, "Text",
  Evaluatable->False],
Cell[67534, 2434, 105, 2, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[67676, 2441, 325, 12, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.14.7"],
Cell[68004, 2455, 374, 12, 43, "Text",
  Evaluatable->False],
Cell[68381, 2469, 169, 4, 64, "Input"],
Cell[68553, 2475, 1091, 30, 109, "Text",
  Evaluatable->False],
Cell[69647, 2507, 155, 4, 47, "Input"],
Cell[69805, 2513, 101, 2, 33, "Text",
  Evaluatable->False],
Cell[69909, 2517, 100, 2, 43, "Input"],
Cell[70012, 2521, 364, 12, 52, "Text",
  Evaluatable->False],
Cell[70379, 2535, 107, 3, 43, "Input"],
Cell[70489, 2540, 311, 11, 52, "Text",
  Evaluatable->False],
Cell[70803, 2553, 86, 3, 43, "Input"],
Cell[70892, 2558, 411, 16, 52, "Text",
  Evaluatable->False],
Cell[71306, 2576, 154, 3, 27, "Input"],
Cell[71463, 2581, 1164, 38, 71, "Text",
  Evaluatable->False],
Cell[72630, 2621, 111, 2, 27, "Input"],
Cell[72744, 2625, 1731, 62, 90, "Text",
  Evaluatable->False],
Cell[74478, 2689, 127, 3, 27, "Input"],
Cell[74608, 2694, 250, 10, 33, "Text",
  Evaluatable->False],
Cell[74861, 2706, 127, 3, 27, "Input"],
Cell[74991, 2711, 152, 5, 33, "Text",
  Evaluatable->False],
Cell[75146, 2718, 849, 32, 67, "Question",
  Evaluatable->False],
Cell[75998, 2752, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[76075, 2756, 279, 11, 33, "Text",
  Evaluatable->False],
Cell[76357, 2769, 127, 3, 27, "Input"],
Cell[76487, 2774, 260, 10, 33, "Text",
  Evaluatable->False],
Cell[76750, 2786, 127, 3, 27, "Input"],
Cell[76880, 2791, 169, 4, 33, "Text",
  Evaluatable->False],
Cell[77052, 2797, 103, 2, 27, "Input"],
Cell[77158, 2801, 372, 16, 33, "Text",
  Evaluatable->False],
Cell[77533, 2819, 139, 3, 27, "Input"],
Cell[77675, 2824, 84, 2, 33, "Text",
  Evaluatable->False],
Cell[77762, 2828, 103, 2, 27, "Input"],
Cell[77868, 2832, 116, 2, 33, "Text",
  Evaluatable->False],
Cell[77987, 2836, 139, 3, 27, "Input"],
Cell[78129, 2841, 759, 23, 76, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[78925, 2869, 238, 8, 46, "Subsection",
  Evaluatable->False,
  CellTags->"a:7.12.15.7"],
Cell[79166, 2879, 176, 5, 33, "Text",
  Evaluatable->False],
Cell[79345, 2886, 109, 3, 45, "Input"],
Cell[79457, 2891, 271, 8, 52, "Text",
  Evaluatable->False],
Cell[79731, 2901, 85, 2, 27, "Input"],
Cell[79819, 2905, 289, 10, 33, "Text",
  Evaluatable->False],
Cell[80111, 2917, 121, 2, 43, "Input"],
Cell[80235, 2921, 391, 12, 52, "Text",
  Evaluatable->False],
Cell[80629, 2935, 117, 2, 31, "Input"],
Cell[80749, 2939, 519, 12, 90, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[81293, 2955, 115, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:7.12.15.8.7"],
Cell[81411, 2960, 202, 5, 52, "Text",
  Evaluatable->False],
Cell[81616, 2967, 107, 3, 43, "Input"],
Cell[81726, 2972, 164, 7, 33, "Text",
  Evaluatable->False],
Cell[81893, 2981, 70, 2, 27, "Input"],
Cell[81966, 2985, 242, 8, 55, "Text",
  Evaluatable->False],
Cell[82211, 2995, 275, 10, 48, "Question",
  Evaluatable->False],
Cell[82489, 3007, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[82566, 3011, 311, 11, 48, "Question",
  Evaluatable->False],
Cell[82880, 3024, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[82991, 3031, 116, 3, 28, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:7.12.15.9.7"],
Cell[83110, 3036, 90, 2, 33, "Text",
  Evaluatable->False],
Cell[83203, 3040, 114, 2, 27, "Input"],
Cell[83320, 3044, 245, 8, 52, "Text",
  Evaluatable->False],
Cell[83568, 3054, 73, 2, 27, "Input"],
Cell[83644, 3058, 172, 5, 33, "Text",
  Evaluatable->False],
Cell[83819, 3065, 510, 17, 67, "Question",
  Evaluatable->False],
Cell[84332, 3084, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[84467, 3093, 208, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.13.7"],
Cell[84678, 3103, 527, 10, 109, "Text",
  Evaluatable->False],
Cell[85208, 3115, 406, 15, 48, "Question",
  Evaluatable->False],
Cell[85617, 3132, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[85694, 3136, 402, 15, 48, "Question",
  Evaluatable->False],
Cell[86099, 3153, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[86176, 3157, 462, 17, 48, "Question",
  Evaluatable->False],
Cell[86641, 3176, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[86718, 3180, 420, 15, 48, "Question",
  Evaluatable->False],
Cell[87141, 3197, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[87218, 3201, 472, 17, 48, "Question",
  Evaluatable->False],
Cell[87693, 3220, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[87804, 3227, 198, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.14.7"],
Cell[88005, 3237, 1282, 44, 53, "Text",
  Evaluatable->False],
Cell[89290, 3283, 2412, 81, 55, "Text",
  Evaluatable->False],
Cell[91705, 3366, 4166, 138, 91, "Text",
  Evaluatable->False],
Cell[95874, 3506, 1333, 44, 34, "Text",
  Evaluatable->False],
Cell[97210, 3552, 3318, 118, 72, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[100565, 3675, 196, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.15.7"],
Cell[100764, 3685, 266, 7, 52, "Text",
  Evaluatable->False],
Cell[101033, 3694, 113, 2, 42, "Input"],
Cell[101149, 3698, 88, 2, 31, "Input"],
Cell[101240, 3702, 92, 2, 31, "Input"],
Cell[101335, 3706, 94, 2, 31, "Input"],
Cell[101432, 3710, 517, 19, 52, "Text",
  Evaluatable->False],
Cell[101952, 3731, 366, 13, 33, "Text",
  Evaluatable->False],
Cell[102321, 3746, 134, 3, 31, "Input"],
Cell[102458, 3751, 149, 3, 31, "Input"],
Cell[102610, 3756, 134, 3, 31, "Input"],
Cell[102747, 3761, 157, 3, 51, "Input"],
Cell[102907, 3766, 360, 12, 67, "Question",
  Evaluatable->False],
Cell[103270, 3780, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[103347, 3784, 161, 4, 49, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[103545, 3793, 371, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.16.7"],
Cell[103919, 3809, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[104264, 3820, 42, 1, 27, "Input"],
Cell[104309, 3823, 58, 1, 27, "Input"],
Cell[104370, 3826, 44, 1, 27, "Input"],
Cell[104417, 3829, 56, 1, 27, "Input"],
Cell[104476, 3832, 60, 1, 27, "Input"],
Cell[104539, 3835, 46, 1, 27, "Input"],
Cell[104588, 3838, 43, 1, 27, "Input"],
Cell[104634, 3841, 41, 1, 27, "Input"],
Cell[104678, 3844, 45, 1, 27, "Input"],
Cell[104726, 3847, 56, 1, 27, "Input"],
Cell[104785, 3850, 57, 1, 27, "Input"],
Cell[104845, 3853, 42, 1, 27, "Input"],
Cell[104890, 3856, 59, 1, 27, "Input"],
Cell[104952, 3859, 43, 1, 27, "Input"],
Cell[104998, 3862, 45, 1, 27, "Input"],
Cell[105046, 3865, 45, 1, 27, "Input"],
Cell[105094, 3868, 57, 1, 27, "Input"],
Cell[105154, 3871, 43, 1, 27, "Input"],
Cell[105200, 3874, 42, 1, 27, "Input"],
Cell[105245, 3877, 44, 1, 27, "Input"],
Cell[105292, 3880, 44, 1, 27, "Input"],
Cell[105339, 3883, 57, 1, 27, "Input"],
Cell[105399, 3886, 57, 1, 27, "Input"],
Cell[105459, 3889, 43, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

