(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     45344,       1617]*)
(*NotebookOutlinePosition[     47688,       1697]*)
(*  CellTagsIndexPosition[     47414,       1684]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->GrayLevel[0]],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 8",
    FontSize->18],
  "\nRoots of Unity"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.8"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.9.8"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.10.8"],

Cell["\<\
No other lab needs to be completed before attempting this lab. \
However, experience with cyclic groups (see Group Lab 6) may prove \
beneficial.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.11.8"],

Cell[TextData[{
  "The main goal of this lab is to become familiar with the ",
  StyleBox["roots of unity",
    FontSlant->"Italic"],
  ", the roots of polynomials of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Introduction"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.12.8"],

Cell[TextData[{
  "This whole lab focuses on the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  " (for a positive integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ") or factors thereof. This is a fairly simple polynomial. You first saw ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 - 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 - 1\)]],
  " in first-year algebra."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Quick! Do you remember how to factor ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^3 - 1\)]],
  StyleBox[" (over \[DoubleStruckCapitalQ])? How is it done?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["You can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to check your answer to question 1.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[x]\), 
    \(Factor[x\^3 - 1]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Was your answer correct? What about other values of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "? Let\[CloseCurlyQuote]s make a table."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[Factor[x\^n - 1], {n, 1, 17}], 
      TableSpacing \[Rule] {0.5, 0}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What observations can you make from this table?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Modify the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Table",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " command to get a listing of values from 18 to some higher value. Do your \
observations still hold? Do you have any new ones or modifications?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s look at ",
  Cell[BoxData[
      \(TraditionalForm\`x\^63 - 1\)]],
  " and consider some questions regarding it."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Factor[x\^63 - 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"What things might be of interest? Consider the following list, for starters. \
\n\n\t1. How many factors are there? \n\t2. What coefficients are used? \n\t\
3. What is the highest degree of any factor?\n\t4. What is the list of all \
the degrees that occur among the factors?",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Factor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " command easily factors this polynomial, but what is returned is just the \
product of all the factors with no way of accessing the pieces of the \
factorization. The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FactorList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" gives us a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["list",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of the factors, so we can access them.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FactorList[x\^63 - 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note that this function returns pairs of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            RowBox[{"g", "(", "x", ")"}], ",", "m"}], "}"}], 
        TraditionalForm]]],
  ",",
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"g", "(", "x", ")"}], TraditionalForm]]],
  StyleBox[" is a factor of the polynomial and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["m", TraditionalForm]]],
  StyleBox[" is an integer. This integer represents the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["multiplicity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " of the factor. This is just a fancy term for expressing how many times a \
factor occurs in the factorization. For an example, the following should \
illustrate the concept of multiplicity.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FactorList[
        Expand[\((x - 3)\)\^4\ \((x + 1)\)\ \((x + 2)\)\^3\ x\^8]] // 
      TraditionalForm\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "To get at just the polynomial factors, we need to transpose the list so \
that the factors are in the first row rather than the first column. (Version \
3 of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " introduces {1, 1} into the factor list; since we are not interested in \
it, we drop this term.) We can then ask for the first row. Here is our result \
for the polynomial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", "63"], "-", "1"}], TraditionalForm]]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(factors = Drop[First[Transpose[FactorList[x\^63 - 1]]], 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Now we can pursue some of the questions in the list. The first question \
was to count the number of factors. For ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", "63"], "-", "1"}], TraditionalForm]]],
  StyleBox[
  ", of course, we can simply step through and count, but we want to look for \
a way of doing this in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". What we really want to know is how many elements there are in the list ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["factors",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", which can be measured by the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Length",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Length[factors]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The second question concerned the coefficients. The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CoefficientList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" does exactly what we want.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CoefficientList[factors, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "It may be of interest to remove any duplicates and not distinguish from \
which factor the values were obtained. The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Flatten",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function puts all these factors into one list.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Flatten[CoefficientList[factors, x]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Now we use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Union",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function, which sorts the factors and removes any duplicates.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Union[Flatten[CoefficientList[factors, x]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Questions 3 and 4 deal with the degree of the factors, namely the highest \
degree of all the factors and the degree of each factor. The latter can be \
easily arrived at with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exponent",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Exponent[factors, x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Once we have this list, it is easy to find the maximum by applying the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Max",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Exponent[factors, \ x] // Max\)], "Input"],

Cell[TextData[
"Let\[CloseCurlyQuote]s put all these steps into one function."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolyInfo[x^\((n_Integer)\)?Positive\  - \ 1]\  := \ 
      \(PolyInfo[x^n\  - \ 1]\  = \ \n
        Module[{factors, \ exps}, \ \n\t
          factors\  = \ Drop[First[Transpose[FactorList[x^n\  - \ 1]]], \ 1]; 
          \ \n\ \ exps\  = \ Exponent[factors, \ x]; \ \n\ 
          \ {n, \ Length[factors], \ 
            Union[Flatten[CoefficientList[factors, \ x]]], \ Max[exps], \ 
            Union[exps]}]\)\)], "Input"],

Cell["Here is a test of this function.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FactorList[x\^12 - 1]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolyInfo[x\^12 - 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that the information is in the form {",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", # factors, coefficients used, highest degree, all degrees}. Here is a \
table showing some results."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[PolyInfo[x\^n - 1], {n, 2, 37}], TableDepth \[Rule] 2, 
      TableSpacing \[Rule] {0.5, 1}, 
      TableHeadings 
        \[Rule] {
          None, {"\<n\>", "\<#fac\>", "\<coefs\>", "\<max deg\>", 
            "\<degrees\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". In question 2 of the list, you were asked what observations you could \
make from what you had seen. Do you have any additions, corrections, or \
comments? Make some conjectures. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Change the range of values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox[" in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Table",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " command to test your conjectures with more data. In particular, make sure \
you test your conjectures with values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox[" that exceed 100 (examples to consider might be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"n", "=", "210"}], TraditionalForm]]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"n", "=", "165"}], TraditionalForm]]],
  StyleBox["). (Hint: If testing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"n", "=", "210"}], TraditionalForm]]],
  StyleBox[", do not test from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"n", "=", "2"}], TraditionalForm]]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"n", "=", "210"}], TraditionalForm]]],
  StyleBox[", but use a smaller range, centered at 210.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the relationship between ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " and ",
  StyleBox["the number of factors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What is the relationship between the degrees of the factors and the \
highest degree among the factors?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What conclusion(s) can you draw about the highest degree of a factor of \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", "n"], "-", "1"}], TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "A closer look\[LongDash]graphically"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.13.8"],

Cell[TextData[{
  "For the moment, we focus on ",
  Cell[BoxData[
      \(TraditionalForm\`x\^6 - 1\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(factors = Rest[First[Transpose[FactorList[x\^6 - 1]]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "As we have seen, zeros are intimately related to factors. The first two \
factors have the zeros 1 and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  StyleBox[
  " associated with them. What about the last two factors? What are the \
zeros? Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s check out the second quadratic factor (the fourth factor in the list) by \
using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Solve",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" command.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(solns = 
      Solve[factors\[LeftDoubleBracket]4\[RightDoubleBracket] == 0]\)], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
These are complex zeros (though they may not look like it). What \
are the real and imaginary parts of these zeros?\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Map[{Re[#], \ Im[#]}&, \ x\  /. \ solns]\)], "Input"],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". These numbers, in pairs, should look familiar. To what are they related \
or where have you seen them before? Find the zeros for the third factor and \
find the real and imaginary parts as above. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Look again at the factorization of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SuperscriptBox["x", "6"], "-", "1"}], TraditionalForm]]],
  StyleBox[
  ". The first two factors (together) yielded two zeros and the last two \
factors had two zeros each, yielding a total of six zeros. Graph (not \
necessarily with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ") these six zeros in the complex plane, using the vertical axis as the \
imaginary axis and the horizontal for the real axis. In other words, the \
complex number ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"a", "+", 
          RowBox[{"b", "i"}]}], TraditionalForm]]],
  StyleBox[" is to be mapped to the point ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{"a", ",", "b"}], ")"}], TraditionalForm]]],
  StyleBox[
  " in the plane. Can you give a precise description of the resulting graph?",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Perhaps it may be worth looking at the zeros of other polynomials. Here we \
use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Solve",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" command on several others.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Solve[x\^8 - 1 == 0]\), 
    \(Solve[x\^10 - 1 == 0]\), 
    \(Solve[x\^16 - 1 == 0]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Since the exact answers may not be so informative, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["NSolve",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" instead, resulting in approximate decimal answers.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(NSolve[x\^8 - 1 == 0]\), 
    \(NSolve[x\^10 - 1 == 0]\), 
    \(NSolve[x\^16 - 1 == 0]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s plot the zeros of this last equation. First we need \
our list of zeros."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(zeros = x /. NSolve[x\^16 - 1 == 0]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Next we need to convert each zero to its real and imaginary part and make \
them ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " graphics-type points. Finally, we graph them. Do not concern yourself \
with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" details.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Show[
      Graphics[{RGBColor[0, 0, 1], PointSize[0.025], 
          \((Point[{Re[#1], Im[#1]}]&)\)/@zeros}], Axes \[Rule] True, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "This sure looks beautiful! Note, however, that this graph has ",
  StyleBox["not",
    FontSlant->"Italic"],
  " considered the individual factors in the factorization of the polynomial \
",
  Cell[BoxData[
      \(TraditionalForm\`x\^16 - 1\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Rest[FactorList[x\^16 - 1]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "How do the plotted zeros relate to the individual factors just given? What \
we would like to do is find the zeros for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["each",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " factor and then plot them so that we can discriminate them from each \
other. We need to slightly modify the code and write a function that can take \
any positive integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" as input and output a graph of the zeros of the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["th roots of unity, colored by factor. (Again, don",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t concern yourself with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" details.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(RootsOfUnityZeros[n_Integer?Positive]\  := \ \n\t
      Module[{factors\  = \ 
            First[Transpose[Drop[FactorList[x^n\  - \ 1], \ 1]]], \ zeros, 
          len, pts, sizedpts, \ width\  = \ 1.2, \ p\  = \ Cyclotomic[n, x]}, 
        \ \nfactors\  = \ Join[Complement[factors, \ {p}], {p}]; \n
        zeros\  = \ x\  /. \ Map[NSolve[#\  == \ 0]&, \ factors]; \n
        len\  = \ Length[zeros]; \n
        pts\  = \ Map[Map[Point[{Re[#], Im[#]}]&, #]&, \ zeros, 2]; \n
        sizedpts\  = \ 
          Transpose[{
              Table[{Hue[i/len], PointSize[0.015\  + \ \n\ti*0.008]}, {i, 
                  len}], pts}]; \n
        Show[Graphics[Map[Flatten, sizedpts]], \ Axes\  \[Rule] \ True, \n\t
          AspectRatio\  \[Rule] \ Automatic, \ 
          PlotRange\  \[Rule] 
            \ {{\(-width\), width}, \n\t{\(-width\), width}}, \ 
          PlotLabel\  \[Rule] \ "\<n = \>"<>ToString[n]]]\n (*\ 
      no\ output\  - \ just\ a\ definition\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try this on a few examples. Depending on the memory of your ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " Front End, you may want to expand or narrow the range of values in the \
following loop by adjusting the values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["lowk",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["highk",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". (Note: You may wish to delete all previous graphics cells before \
continuing, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "if you are getting low on memory",
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(lowk = 4; \)\), 
    \(\(highk = 11; \)\), 
    \(Do[RootsOfUnityZeros[k], {k, lowk, highk}]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
In each graph, dots of the same color come from the same \
factor.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What observations can you make from these graphs?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do you see any groups (or a ring) lurking behind the scenes?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["When we find the roots of the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1\)]],
  StyleBox[", we are finding the solutions (zeros) to the equation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n - 1 = 0\)]],
  StyleBox[" or, more simply, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^n = 1\)]],
  StyleBox[". In other words, we are finding all the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["th roots of 1, the unity, hence, the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["nth roots of unity.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" Since 1 is always a solution, starting with 1 let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s number the roots and work counterclockwise, labeling the first with 0. \
(You might ask yourself why we start counting/labeling with 0.) Following is \
the modified code to reflect the numbering/counting scheme.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RootsOfUnityZeros[n_Integer?Positive, \ powers]\  := \ \n\t
      Module[{factors\  = \ 
            First[Transpose[Drop[FactorList[x^n\  - \ 1], \ 1]]], \ zeros, 
          len, pts, sizedpts, \ width\  = \ 1.3, \ p\  = \ Cyclotomic[n, x]}, 
        \ \nfactors\  = \ Join[Complement[factors, {p}], {p}]; \n
        zeros\  = \ x\  /. \ Map[NSolve[#\  == \ 0]&, \ factors]; \n
        len\  = \ Length[zeros]; \n
        pts\  = \ Map[Map[Point[{Re[#], Im[#]}]&, #]&, \ zeros, 2]; \n
        sizedpts\  = \ 
          Transpose[{
              Table[{Hue[i/len], PointSize[0.015\  + \ \n\ti*0.008]}, {i, 
                  len}], pts}]; \n
        Show[Graphics[{
              Map[Flatten, sizedpts], {RGBColor[0, 0, 1], 
                Table[Text[i, \ 1.2 {Cos[i/n\ 2  Pi], Sin[i/n\ 2  Pi]}], {i, 
                    0, n\  - \ 1}]}}], \ Axes\  \[Rule] \ True, \ 
          AspectRatio\  \[Rule] \ Automatic, \ 
          PlotRange\  \[Rule] \ {{\(-width\), width}, \ {\(-width\), width}}, 
          \ PlotLabel\  \[Rule] \ "\<n = \>"<>ToString[n]]]\)], "Input"],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s try it out. ",
  StyleBox[
  "(Note: You again may wish to delete all previous graphics cells before \
continuing, if you are getting low on memory.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\( (*\ 
      adjust\ lowk\ and/or\ highk\ depending\ on\ memory\ considerations\ *) 
      \nlowk\  = \ 4; \nhighk\  = \ 11; \n
    Do[RootsOfUnityZeros[k, \ powers], \ {k, \ lowk, \ highk}]\)\)], "Input"],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". You should be seeing two distinct groups. Can you name them? Do you now \
know why we started counting at 0?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Instead of simply labeling the points 0 through ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  ", let\[CloseCurlyQuote]s use these numbers but divide them by ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", which is the number of roots (and the degree of the polynomial). Here we \
slightly modify the code again to reflect this change."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RootsOfUnityZeros[n_Integer?Positive, \ fractions]\  := \ \n\t
      Module[{factors\  = \ 
            First[Transpose[Drop[FactorList[x^n\  - \ 1], 1]]], \ zeros, len, 
          pts, sizedpts, \ width\  = \ 1.3, \ p\  = \ Cyclotomic[n, x]}, \ \n
        factors\  = \ Join[Complement[factors, {p}], {p}]; \n
        zeros\  = \ x\  /. \ Map[NSolve[#\  == \ 0]&, \ factors]; \n
        len\  = \ Length[zeros]; \n
        pts\  = \ Map[Map[Point[{Re[#], Im[#]}]&, #]&, \ zeros, 2]; \n
        sizedpts\  = \ 
          Transpose[{
              Table[{Hue[i/len], PointSize[0.015\  + \ i*0.008]}, {i, len}], 
              pts}]; \nShow[
          Graphics[{
              Map[Flatten, sizedpts], {RGBColor[0, 0, 1], \ 
                Table[Text[InputForm[i/n], \ 
                    1.2 {Cos[i/n\ 2  Pi], Sin[i/n\ 2  Pi]}], {i, 0, 
                    n\  - \ 1}]}}], \ Axes\  \[Rule] \ True, \ 
          AspectRatio\  \[Rule] \ Automatic, \ 
          PlotRange\  \[Rule] \ {{\(-width\), width}, \ {\(-width\), width}}, 
          \ PlotLabel\  \[Rule] \ "\<n = \>"<>ToString[n]]]\)], "Input"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s try it one more time.",
  StyleBox[
  " (Note: You again may wish to delete all previous graphics cells before \
continuing, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "if you are getting low on memory",
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\( (*\ 
      adjust\ lowk\ and/or\ highk\ depending\ on\ memory\ considerations\ *) 
      \nlowk\  = \ 4; \nhighk\  = \ 11; \n
    Do[RootsOfUnityZeros[k, \ fractions], \ {k, \ lowk, \ highk}]\)\)], 
  "Input"],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Can you find any connections between the fractions used and the colors \
of the dots to which they correspond? (You may wish to try another range of \
values.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Another look\[LongDash]algebraically"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.14.8"],

Cell[TextData[{
  StyleBox["In section 8.3 we used the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FactorList",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " but often had to manipulate it to get just the list of factors. Since we \
wish to do this often, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s write a function to do it for us.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FactorsOfUnity[n_Integer?Positive] := 
      First[Transpose[Rest[FactorList[x\^n - 1]]]]\)], "Input",
  AspectRatioFixed->True],

Cell["Here is how it works.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FactorsOfUnity[4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try a few others."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Map[FactorsOfUnity, \ {2, \ 4, \ 8, \ 16, \ 32}] // ColumnForm\n (*\ 
      here\ n\  = \ 2, \ 4, \ 8, \ 16, \ 32\ *) \)\)], "Input"],

Cell[BoxData[
    \(Map[FactorsOfUnity, \ {3, \ 6, \ 18, \ 36}] // ColumnForm\)], "Input"],

Cell[BoxData[
    \(Map[FactorsOfUnity, \ {5, \ 20}] // ColumnForm\)], "Input"],

Cell[BoxData[
    \(Map[FactorsOfUnity, \ {14, \ 28}] // ColumnForm\)], "Input"],

Cell[BoxData[
    \(Map[FactorsOfUnity, \ {3, \ 6, \ 12, \ 24}] // ColumnForm\)], "Input"],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Look at the relationship(s) between the numbers ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["FactorsOfUnity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is acting on and the results of the factorizations given. What \
conjectures or conclusions can you make? Can you give any explanations for \
your conclusions?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Note: Some of the ideas for this lab came from chapter 17 of ",
  StyleBox["Exploring Mathematics with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by Theodore W. Gray and Jerry Glynn (Addison-Wesley, 1991)."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["8.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:8.15.8"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Factor", "Input",
  AspectRatioFixed->True],

Cell["?Table", "Input",
  AspectRatioFixed->True],

Cell["?FactorList", "Input",
  AspectRatioFixed->True],

Cell["?Length", "Input",
  AspectRatioFixed->True],

Cell["?CoefficientList", "Input",
  AspectRatioFixed->True],

Cell["?Flatten", "Input",
  AspectRatioFixed->True],

Cell["?Union", "Input",
  AspectRatioFixed->True],

Cell["?Exponent", "Input",
  AspectRatioFixed->True],

Cell["?Solve", "Input",
  AspectRatioFixed->True],

Cell["?NSolve", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
ScreenStyleEnvironment->"Working",
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 431},
WindowMargins->{{1, Automatic}, {Automatic, 2}},
PrintingStartingPageNumber->65,
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:8.8"->{
    Cell[2409, 77, 162, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:8.8"]},
  "a:8.9.8"->{
    Cell[2596, 88, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.9.8"]},
  "a:8.10.8"->{
    Cell[6963, 235, 192, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:8.10.8"]},
  "a:8.11.8"->{
    Cell[7412, 256, 184, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.11.8"]},
  "a:8.12.8"->{
    Cell[7935, 281, 191, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.12.8"]},
  "a:8.13.8"->{
    Cell[24158, 885, 214, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.13.8"]},
  "a:8.14.8"->{
    Cell[41276, 1455, 215, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.14.8"]},
  "a:8.15.8"->{
    Cell[44057, 1558, 371, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:8.15.8"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:8.8", 46487, 1648},
  {"a:8.9.8", 46595, 1652},
  {"a:8.10.8", 46709, 1656},
  {"a:8.11.8", 46824, 1660},
  {"a:8.12.8", 46939, 1664},
  {"a:8.13.8", 47054, 1668},
  {"a:8.14.8", 47170, 1672},
  {"a:8.15.8", 47287, 1676}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 102, 3, 47, "Answer",
  Evaluatable->False],
Cell[1814, 54, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2409, 77, 162, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:8.8"],

Cell[CellGroupData[{
Cell[2596, 88, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.9.8"],
Cell[2922, 101, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3773, 125, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5143, 167, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5295, 172, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5917, 194, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6609, 220, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6963, 235, 192, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:8.10.8"],
Cell[7158, 245, 217, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7412, 256, 184, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.11.8"],
Cell[7599, 266, 299, 10, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7935, 281, 191, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.12.8"],
Cell[8129, 291, 483, 16, 52, "Text",
  Evaluatable->False],
Cell[8615, 309, 450, 15, 48, "Question",
  Evaluatable->False],
Cell[9068, 326, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[9145, 330, 362, 13, 33, "Text",
  Evaluatable->False],
Cell[9510, 345, 96, 3, 47, "Input"],
Cell[9609, 350, 224, 7, 33, "Text",
  Evaluatable->False],
Cell[9836, 359, 143, 3, 27, "Input"],
Cell[9982, 364, 289, 10, 48, "Question",
  Evaluatable->False],
Cell[10274, 376, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[10351, 380, 567, 19, 67, "Question",
  Evaluatable->False],
Cell[10921, 401, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[10998, 405, 215, 7, 33, "Text",
  Evaluatable->False],
Cell[11216, 414, 76, 2, 31, "Input"],
Cell[11295, 418, 408, 8, 128, "Text",
  Evaluatable->False],
Cell[11706, 428, 883, 30, 71, "Text",
  Evaluatable->False],
Cell[12592, 460, 80, 2, 31, "Input"],
Cell[12675, 464, 1161, 37, 90, "Text",
  Evaluatable->False],
Cell[13839, 503, 163, 4, 31, "Input"],
Cell[14005, 509, 593, 16, 90, "Text",
  Evaluatable->False],
Cell[14601, 527, 117, 2, 31, "Input"],
Cell[14721, 531, 1180, 40, 90, "Text",
  Evaluatable->False],
Cell[15904, 573, 74, 2, 27, "Input"],
Cell[15981, 577, 408, 13, 52, "Text",
  Evaluatable->False],
Cell[16392, 592, 86, 2, 27, "Input"],
Cell[16481, 596, 479, 15, 52, "Text",
  Evaluatable->False],
Cell[16963, 613, 95, 2, 27, "Input"],
Cell[17061, 617, 387, 13, 33, "Text",
  Evaluatable->False],
Cell[17451, 632, 102, 2, 27, "Input"],
Cell[17556, 636, 506, 16, 52, "Text",
  Evaluatable->False],
Cell[18065, 654, 79, 2, 27, "Input"],
Cell[18147, 658, 392, 14, 33, "Text",
  Evaluatable->False],
Cell[18542, 674, 62, 1, 27, "Input"],
Cell[18607, 677, 136, 3, 33, "Text",
  Evaluatable->False],
Cell[18746, 682, 445, 8, 107, "Input"],
Cell[19194, 692, 96, 2, 33, "Text",
  Evaluatable->False],
Cell[19293, 696, 80, 2, 31, "Input"],
Cell[19376, 700, 78, 2, 31, "Input"],
Cell[19457, 704, 277, 8, 52, "Text",
  Evaluatable->False],
Cell[19737, 714, 305, 7, 59, "Input"],
Cell[20045, 723, 424, 13, 67, "Question",
  Evaluatable->False],
Cell[20472, 738, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20549, 742, 1724, 59, 105, "Question",
  Evaluatable->False],
Cell[22276, 803, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22353, 807, 551, 21, 48, "Question",
  Evaluatable->False],
Cell[22907, 830, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22984, 834, 348, 12, 67, "Question",
  Evaluatable->False],
Cell[23335, 848, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23412, 852, 632, 24, 48, "Question",
  Evaluatable->False],
Cell[24047, 878, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[24158, 885, 214, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.13.8"],
Cell[24375, 895, 170, 7, 33, "Text",
  Evaluatable->False],
Cell[24548, 904, 113, 2, 31, "Input"],
Cell[24664, 908, 812, 28, 71, "Text",
  Evaluatable->False],
Cell[25479, 938, 138, 4, 27, "Input"],
Cell[25620, 944, 187, 5, 52, "Text",
  Evaluatable->False],
Cell[25810, 951, 73, 1, 27, "Input"],
Cell[25886, 954, 441, 13, 86, "Question",
  Evaluatable->False],
Cell[26330, 969, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26407, 973, 1436, 46, 143, "Question",
  Evaluatable->False],
Cell[27846, 1021, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[27923, 1025, 425, 15, 52, "Text",
  Evaluatable->False],
Cell[28351, 1042, 145, 4, 71, "Input"],
Cell[28499, 1048, 514, 17, 52, "Text",
  Evaluatable->False],
Cell[29016, 1067, 148, 4, 71, "Input"],
Cell[29167, 1073, 170, 4, 33, "Text",
  Evaluatable->False],
Cell[29340, 1079, 94, 2, 31, "Input"],
Cell[29437, 1083, 664, 24, 71, "Text",
  Evaluatable->False],
Cell[30104, 1109, 232, 5, 59, "Input"],
Cell[30339, 1116, 331, 11, 52, "Text",
  Evaluatable->False],
Cell[30673, 1129, 86, 2, 31, "Input"],
Cell[30762, 1133, 1237, 39, 109, "Text",
  Evaluatable->False],
Cell[32002, 1174, 1004, 18, 219, "Input"],
Cell[33009, 1194, 1122, 39, 90, "Text",
  Evaluatable->False],
Cell[34134, 1235, 155, 4, 59, "Input"],
Cell[34292, 1241, 90, 3, 33, "Text"],
Cell[34385, 1246, 292, 10, 48, "Question",
  Evaluatable->False],
Cell[34680, 1258, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[34757, 1262, 303, 10, 48, "Question",
  Evaluatable->False],
Cell[35063, 1274, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[35140, 1278, 1361, 40, 128, "Text",
  Evaluatable->False],
Cell[36504, 1320, 1089, 19, 235, "Input"],
Cell[37596, 1341, 309, 9, 52, "Text",
  Evaluatable->False],
Cell[37908, 1352, 226, 4, 75, "Input"],
Cell[38137, 1358, 354, 12, 67, "Question",
  Evaluatable->False],
Cell[38494, 1372, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[38571, 1376, 433, 11, 71, "Text",
  Evaluatable->False],
Cell[39007, 1389, 1120, 20, 251, "Input"],
Cell[40130, 1411, 389, 13, 52, "Text",
  Evaluatable->False],
Cell[40522, 1426, 232, 5, 75, "Input"],
Cell[40757, 1433, 405, 13, 67, "Question",
  Evaluatable->False],
Cell[41165, 1448, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[41276, 1455, 215, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.14.8"],
Cell[41494, 1465, 583, 19, 52, "Text",
  Evaluatable->False],
Cell[42080, 1486, 148, 3, 43, "Input"],
Cell[42231, 1491, 85, 2, 33, "Text",
  Evaluatable->False],
Cell[42319, 1495, 76, 2, 27, "Input"],
Cell[42398, 1499, 114, 2, 33, "Text",
  Evaluatable->False],
Cell[42515, 1503, 155, 2, 43, "Input"],
Cell[42673, 1507, 90, 1, 27, "Input"],
Cell[42766, 1510, 79, 1, 27, "Input"],
Cell[42848, 1513, 80, 1, 27, "Input"],
Cell[42931, 1516, 90, 1, 27, "Input"],
Cell[43024, 1519, 631, 20, 86, "Question",
  Evaluatable->False],
Cell[43658, 1541, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[43735, 1545, 285, 8, 52, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[44057, 1558, 371, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:8.15.8"],
Cell[44431, 1574, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[44776, 1585, 50, 1, 27, "Input"],
Cell[44829, 1588, 49, 1, 27, "Input"],
Cell[44881, 1591, 54, 1, 27, "Input"],
Cell[44938, 1594, 50, 1, 27, "Input"],
Cell[44991, 1597, 59, 1, 27, "Input"],
Cell[45053, 1600, 51, 1, 27, "Input"],
Cell[45107, 1603, 49, 1, 27, "Input"],
Cell[45159, 1606, 52, 1, 27, "Input"],
Cell[45214, 1609, 49, 1, 27, "Input"],
Cell[45266, 1612, 50, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

