(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     52956,       1960]*)
(*NotebookOutlinePosition[     55359,       2041]*)
(*  CellTagsIndexPosition[     55068,       2028]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True,
  FontColor->GrayLevel[0]],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 11",
    FontSize->18],
  "\nQuadratic Field Extensions"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.11"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.12.11"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.13.11"],

Cell[TextData[{
  "To complete this lab, you should be familiar with the construction of \
quotient rings of the ring of polynomials over a field ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ". You should also be familiar with irreducible polynomials over a field. \
This lab does not presume any other prior knowledge of field extensions. \
Doing Ring Lab 10 first would be helpful, but it is not necessary."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.14.11"],

Cell["\<\
The goal of this lab is to provide some experience in working with \
quadratic field extensions to make the general study of finite field \
extensions easier to understand.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "The general problem"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.15.11"],

Cell[TextData[{
  StyleBox[
  "Not every polynomial with real coefficients has real roots; the simplest \
example is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x) = x\^2 + 1\)]],
  StyleBox[". To find the roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[
  ", we extend the real numbers to the complex numbers. That is, we construct \
a field that contains the real numbers but also includes some new elements \
that are roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[
  ". This process of extending a field can be used to find roots of any \
nonconstant polynomial over any field. When the polynomial is quadratic, the \
smallest extension containing a root of this polynomial takes on a simple \
form.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The general problem we will consider is to find the roots of a quadratic \
polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(p(x) = \ a  x\^2\) + b  x + c\)]],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" are elements of a field ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[", with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a \[NotEqual] 0\)]],
  StyleBox[". Recall that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" is a root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(t) = 0\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Prove that if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" has one root in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[
  ", then it also has a second root (possibly identical to the first) in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The case when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" has its two roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" is not very interesting. Therefore, consider the case where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" has no roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox["; that is, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[
  ". Suppose we have a \[OpenCurlyDoubleQuote]larger\[CloseCurlyDoubleQuote] \
field that contains ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" and also contains a root, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[", of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x) = a  x\^2 + b  x + c\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Prove that all positive powers of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" can be written in the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\ z + t\)]],
  ",",
  StyleBox[" where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" are elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[". Hint: Start with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\^2\)]],
  StyleBox[" and then proceed by induction.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The result expressed in question 2 tells us exactly what the elements of \
the smallest extension field look like. A few loose ends may need to be tied \
together, but you should be able to see that this new field, a quadratic \
extension of ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ", is"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`F[z] = {s  z + t | s, t \[Element] F}\)]],
  ","
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell["where", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm
    \`\(\((s  z + t)\) + \((s'\ z + t')\) = \((s + s')\)\ z + \((t + t')\)\ 
      \)\)]]], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell["and", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((s\ z + t)\)\ \((s'\ z + t')\) = r\ z + u\)]]], 
  "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "for some ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  ". How do we get the result ",
  Cell[BoxData[
      \(TraditionalForm\`r\ z + u\)]],
  "? This calculation is described in Ring Lab 10, so here we just review the \
process. First think of ",
  Cell[BoxData[
      \(TraditionalForm\`\((s\ z + t)\)\ \((s'\ z + t')\)\)]],
  " simply as a product of two polynomials. We expand this product into a \
quadratic and then divide by ",
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  ". The remainder from this division is our product, ",
  Cell[BoxData[
      \(TraditionalForm\`r\ z + u\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["As an example, suppose that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" is the field of rational numbers, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x) = x\^2 - x - 1\)]],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`W\)]],
  StyleBox[" is a root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(p(x), \)\)]],
  StyleBox[" the product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2\ W + 5\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3\ W - 7\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ][W]\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`7\ W - 29\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[W]\), 
    \(PolynomialRemainder[\((2\ W + 5)\)\ \((3\ W - 7)\), W\^2 - W - 1, W]
      \)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". In the quadratic extension of the rational numbers that contains ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`W\)]],
  StyleBox[", determine the values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`W\^n\)]],
  StyleBox[", for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n = 2, 3, 4, 5, 6, 7\)]],
  StyleBox[
  ". Can you identify a pattern? An example of how to calculate the value of \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`W\^3\)]],
  " follows."
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PolynomialRemainder[W\^3, W\^2 - W - 1, W]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Alternatively, we can ask ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to find the real roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[x]\), 
    \(Solve[x\^2 - x - 1 == 0, x]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We select the first root provided and call it ",
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  ". Are ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ][w]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ][W]\)]],
  " the same? Not really, but they are isomorphic. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(w = x /. First[Solve[x\^2 - x - 1 == 0, x]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we can verify that the product ",
  Cell[BoxData[
      \(TraditionalForm\`\((2\ w + 5)\)\ \((3\ w - 7)\)\)]],
  " is consistent with the product computed involving ",
  Cell[BoxData[
      \(TraditionalForm\`W\)]],
  "\[CloseCurlyQuote]s. To compare ",
  Cell[BoxData[
      \(TraditionalForm\`\((2\ w + 5)\)\ \((3\ w - 7)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\(-29\) + 7\ w\)]],
  ", we need to expand both sides. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Expand[\((2\ w + 5)\)\ \((3\ w - 7)\)] == Expand[\(-29\) + 7\ w]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". The isomorphism hinted at would map ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a + b\ W\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a + b\ w\)]],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  StyleBox[" is the first root given to us by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Solve",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Could we have used the second root? If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`W\)]],
  StyleBox[" maps into the second root, what would map into ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.4 An extension of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleStruckCapitalZ]\_3\ \)\)]],
  StyleBox["using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.16.11"],

Cell[TextData[{
  StyleBox["To continue we read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code needed for the rest of the lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Consider the polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x) = x\^2 + x + 2\)]],
  StyleBox[" over the integers modulo 3, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["Verify that none of the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{0, 1, 2}\)]],
  StyleBox[", are roots of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  "."
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[" Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The extension of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[" that contains a root ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" can be generated with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["QuotientRing",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (see Ring Lab 10). We shorten the name of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3[z]\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = Poly[Z[3], x\^2 + x + 2]\), 
    \(V = QuotientRing[Z[3], p]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["When you work with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[
  ", be aware of the form of its elements. They all appear as ordinary \
polynomial expressions, but in fact their internal form is more complicated. \
We have to use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " function to create them. For example, consider the third element in the \
list, appearing as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(third = \(Elements[V]\)\[LeftDoubleBracket]3\[RightDoubleBracket]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Is this simply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox["? In other words, can we just use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox[" in place of it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(2\ x === third\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["No. They have different internal forms. For instance, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" is",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FullForm[2\ x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["which is just the product of 2 and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[", as we think of it in ordinary usage. The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" internal form for the third element in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox[", is quite different.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FullForm[third]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This form is significantly more complicated. The reason is that it \
represents a formal polynomial whose underlying ring is embedded in the \
structure, as well as several other pieces of data. (Purely optional: This \
data structure has the head ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra`RingExtensions`Private`poly",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " with two arguments. The first is a list with four arguments and the \
second is the list of coefficients, starting with the constant term, then \
linear, and so on. The arguments in the first list consist of the underlying \
ring (in internal form), whether we should view the polynomial from right to \
left or left to right, the indeterminate that should be used, and finally \
whether the coefficients are numeric or not. Thankfully, the user does not \
need to worry about these details.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Therefore, to use the third element, we either pick it off the list of \
elements, as we did earlier or we create it anew with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function. In this case, this polynomial can be obtained by",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(newthird = Poly[Z[3], 2\ x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "It is important that all polynomials are created in this fashion when they \
are over a ring besides the integers, rationals, reals, or complex numbers. \
Note that this is now identical to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["third",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(newthird === third\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["What is more important is the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["mathematical",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" concept of what this ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2  x\)]],
  StyleBox[
  " represents. You can just think of it as an abstract element in a new \
ring, or you can think of it as the coset representative of the coset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`2  x + \[LeftAngleBracket]x\^2 + x + 2\[RightAngleBracket]\)]],
  StyleBox[", since this element really comes from the quotient ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_3[x]/
        \[LeftAngleBracket]x\^2 + x + 2\[RightAngleBracket]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["What have we done so far? Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s recap for a moment. We have a polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = x\^2 + x + 2\)]],
  StyleBox[" that does not have any roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". We formed the quotient ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_3[x]/
        \[LeftAngleBracket]x\^2 + x + 2\[RightAngleBracket]\)]],
  StyleBox[" and called it ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[". We also know (from Ring Lab 10) that this ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" contains a root (call it ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[") of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[", as well as containing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[" itself. (How does it contain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox["?) We therefore also call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" by the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3[z]\)]],
  StyleBox[". To verify that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" (whatever it turns out to be) is a root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[", we need to represent ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "\[CloseCurlyQuote]",
  StyleBox["s coefficients as elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[". In other words, we can think of a new ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[", call it ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pV",
    FontSlant->"Italic"],
  StyleBox[", whose coefficients 1, 1, and 2 are constant polynomials in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[". We also want the multiplication ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x*x\)]],
  StyleBox[" that yields ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  StyleBox[" to be taking place in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[". Hence, we have a new polynomial function as follows.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(pV[y_] := 
      \(Multiplication[V]\)[y, y] + y + 
        Poly[Z[3], 2, Indeterminate \[Rule] x]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The constant term 2 in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" is reflected by using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly[Z[3], 2, Indeterminate ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" x]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". The use of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Indeterminate ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" x",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is just for consistency. Since constants do not use an indeterminate, \
adding this option indicates that we are viewing this polynomial in the \
indeterminate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We have stated that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" is a root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" (or of this new version of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pV",
    FontSlant->"Italic"],
  StyleBox["), but what is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[
  "? We know we have a root if, when we evaluate a polynomial, we get 0. \
Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" is supposed to be found in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" (and we already know that one third of the elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" can be dismissed as candidates",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  StyleBox["why?), we should perhaps map our new polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pV",
    FontSlant->"Italic"],
  StyleBox[" over our elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[" and look for 0 (i.e., ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Poly[Z[3], 0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(valuesOfpV\  = \ Map[pV, \ Elements[V]]\)], "Input"],

Cell[TextData[{
  "We obtain 0 twice. What values of ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " yielded the zeros? Let\[CloseCurlyQuote]s look at ",
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  " again."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Elements[V]\)], "Input",
  AspectRatioFixed->True],

Cell["Combining and transposing,", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[{Elements[V], \ valuesOfpV}] // 
      TableForm[#, \ 
          TableHeadings\  \[Rule] 
            \ {None, \ {"\<v \[Element] V\>", \ "\<pV[v]\n\>"}}]&\)], "Input"],

Cell[TextData[{
  "makes it clear that our candidates for ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " are the elements (polynomials) ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`2  x + 2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The formation and evaluation of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["pV",
    FontSlant->"Italic"],
  StyleBox[" is not particularly pleasant. There is a function called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["EvaluationInExtension",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" that can do these tasks. Here is how it works.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?EvaluationInExtension\)\)], "Input"],

Cell[BoxData[
    \(EvaluationInExtension[V, ModulusPolynomial[V], Poly[Z[3], x]]\)], 
  "Input",
  AspectRatioFixed->True],

Cell["We can also give it a list of elements to evaluate.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(EvaluationInExtension[V, ModulusPolynomial[V], Elements[V]]\)], "Input",\

  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q = x\^2 + 2  x + 2\)]],
  StyleBox[" over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". Show that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[". Calculate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["V2 = QuotientRing[Z[3], q]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". Find a zero for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["V2",
            FontSlant->"Italic"], "."}], TraditionalForm]]]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Recall that to compute a product in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[", such as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\^2 = \((x)\)\ \((x)\)\)]],
  StyleBox[", we can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Multiplication[V]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Multiplication[V]\)[Poly[Z[3], x], Poly[Z[3], x]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For higher powers, it may be easier to use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ElementToPower",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\ \(?ElementToPower\)\)\)], "Input"],

Cell[BoxData[
    \(ElementToPower[V, Poly[Z[3], x], 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Compute more powers of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\^2\), x\^3,  ... , x\^9 ... )\)\)]],
  StyleBox[" until you can identify a pattern. (Hint: Using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Table",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ElementToPower",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is the cleanest way of doing this.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If we consider another irreducible quadratic polynomial over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[
  ", will we need a further extension, or will our original extension contain \
the second irreducible",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s roots? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Verify that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q(x) = x\^2 + 1\)]],
  StyleBox[" has no roots in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  StyleBox[" but has both its roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`V\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Theorems motivated from this lab"
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.17.11"],

Cell["\<\
The calculations we have performed here suggest several theorems. \
To prove the theorems, there are many details that need to be shown. However, \
the examples in this lab certainly show that the theorems are plausible. \
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". We state these theorems with a few key words left for you to fill in.\n\n\
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Theorem 1. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`E = F[z]\)]],
  StyleBox[" is a quadratic extension of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" containing a root ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[" is the second root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[", then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F[z]\)]],
  StyleBox[" is ________________________ to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F[y]\)]],
  StyleBox[".\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Theorem 2. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`w\)]],
  StyleBox[" is a real root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x) = x\^2 + x + 1\)]],
  StyleBox[", then for each positive integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", \n",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`w\^n = a\_n + \(b\_n\) w\)]],
  ", ",
  StyleBox["where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\_n\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\_n\)]],
  StyleBox[" are consecutive ___________________.\n\t\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Theorem 3. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" is a finite field and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F[z]\)]],
  StyleBox[" is a quadratic extension of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[", then the set of nonzero elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F[z]\)]],
  StyleBox[" with multiplication is a _______ group of order ______ and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" is a __________ of the group.\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Theorem 4. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox["If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" is a finite field, a quadratic polynomial ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" is irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  ",",
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[" is a root of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(x)\)]],
  StyleBox[" in an extension ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`E\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[", then every ___________ polynomial over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  StyleBox[" has its roots in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`F[z]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Note: These theorems can all be generalized in several directions, \
so the theorem in your text may not match them exactly. \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["11.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:11.18.11"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?PolynomialRemainder", "Input",
  AspectRatioFixed->True],

Cell["?Solve", "Input",
  AspectRatioFixed->True],

Cell["?Expand", "Input",
  AspectRatioFixed->True],

Cell["?Poly", "Input",
  AspectRatioFixed->True],

Cell["?QuotientRing", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell["?FullForm", "Input",
  AspectRatioFixed->True],

Cell["?Indeterminate", "Input",
  AspectRatioFixed->True],

Cell["?Multiplication", "Input",
  AspectRatioFixed->True],

Cell["?Transpose", "Input",
  AspectRatioFixed->True],

Cell["?EvaluationInExtension", "Input",
  AspectRatioFixed->True],

Cell["?ElementToPower", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{634, 435},
WindowMargins->{{2, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, 6},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:11.11"->{
    Cell[2409, 77, 177, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:11.11"]},
  "a:11.12.11"->{
    Cell[2611, 88, 327, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:11.12.11"]},
  "a:11.13.11"->{
    Cell[6982, 235, 195, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.13.11"]},
  "a:11.14.11"->{
    Cell[7694, 260, 187, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.14.11"]},
  "a:11.15.11"->{
    Cell[8165, 281, 201, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.15.11"]},
  "a:11.16.11"->{
    Cell[21806, 800, 449, 16, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.16.11"]},
  "a:11.17.11"->{
    Cell[45559, 1672, 214, 8, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.17.11"]},
  "a:11.18.11"->{
    Cell[51512, 1895, 374, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:11.18.11"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:11.11", 54108, 1992},
  {"a:11.12.11", 54221, 1996},
  {"a:11.13.11", 54340, 2000},
  {"a:11.14.11", 54459, 2004},
  {"a:11.15.11", 54578, 2008},
  {"a:11.16.11", 54697, 2012},
  {"a:11.17.11", 54818, 2016},
  {"a:11.18.11", 54939, 2020}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 102, 3, 47, "Answer",
  Evaluatable->False],
Cell[1814, 54, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2409, 77, 177, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:11.11"],

Cell[CellGroupData[{
Cell[2611, 88, 327, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:11.12.11"],
Cell[2941, 101, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3792, 125, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5162, 167, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5314, 172, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5936, 194, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6628, 220, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6982, 235, 195, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.13.11"],
Cell[7180, 245, 477, 10, 90, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7694, 260, 187, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.14.11"],
Cell[7884, 270, 244, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8165, 281, 201, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.15.11"],
Cell[8369, 291, 1031, 30, 128, "Text",
  Evaluatable->False],
Cell[9403, 323, 1411, 53, 71, "Text",
  Evaluatable->False],
Cell[10817, 378, 698, 26, 67, "Question",
  Evaluatable->False],
Cell[11518, 406, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[11595, 410, 1498, 53, 71, "Text",
  Evaluatable->False],
Cell[13096, 465, 1096, 41, 67, "Question",
  Evaluatable->False],
Cell[14195, 508, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[14272, 512, 380, 10, 71, "Text",
  Evaluatable->False],
Cell[14655, 524, 190, 7, 33, "Text",
  Evaluatable->False],
Cell[14848, 533, 69, 2, 33, "Text",
  Evaluatable->False],
Cell[14920, 537, 222, 6, 29, "Text",
  Evaluatable->False],
Cell[15145, 545, 67, 2, 33, "Text",
  Evaluatable->False],
Cell[15215, 549, 184, 5, 29, "Text",
  Evaluatable->False],
Cell[15402, 556, 748, 24, 90, "Text",
  Evaluatable->False],
Cell[16153, 582, 1401, 51, 52, "Text",
  Evaluatable->False],
Cell[17557, 635, 155, 4, 47, "Input"],
Cell[17715, 641, 857, 31, 86, "Question",
  Evaluatable->False],
Cell[18575, 674, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[18652, 678, 101, 2, 31, "Input"],
Cell[18756, 682, 488, 18, 33, "Text",
  Evaluatable->False],
Cell[19247, 702, 107, 3, 47, "Input"],
Cell[19357, 707, 397, 13, 52, "Text",
  Evaluatable->False],
Cell[19757, 722, 102, 2, 31, "Input"],
Cell[19862, 726, 522, 16, 52, "Text",
  Evaluatable->False],
Cell[20387, 744, 126, 3, 27, "Input"],
Cell[20516, 749, 1176, 42, 86, "Question",
  Evaluatable->False],
Cell[21695, 793, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[21806, 800, 449, 16, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.16.11"],
Cell[22258, 818, 378, 13, 33, "Text",
  Evaluatable->False],
Cell[22639, 833, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[22813, 839, 471, 16, 33, "Text",
  Evaluatable->False],
Cell[23287, 857, 618, 23, 48, "Question",
  Evaluatable->False],
Cell[23908, 882, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[23986, 886, 1067, 38, 52, "Text",
  Evaluatable->False],
Cell[25056, 926, 125, 3, 48, "Input"],
Cell[25184, 931, 832, 28, 71, "Text",
  Evaluatable->False],
Cell[26019, 961, 127, 3, 27, "Input"],
Cell[26149, 966, 445, 16, 33, "Text",
  Evaluatable->False],
Cell[26597, 984, 73, 2, 27, "Input"],
Cell[26673, 988, 494, 18, 33, "Text",
  Evaluatable->False],
Cell[27170, 1008, 73, 2, 27, "Input"],
Cell[27246, 1012, 806, 28, 52, "Text",
  Evaluatable->False],
Cell[28055, 1042, 74, 2, 27, "Input"],
Cell[28132, 1046, 1095, 24, 185, "Text",
  Evaluatable->False],
Cell[29230, 1072, 502, 15, 52, "Text",
  Evaluatable->False],
Cell[29735, 1089, 86, 2, 27, "Input"],
Cell[29824, 1093, 504, 16, 52, "Text",
  Evaluatable->False],
Cell[30331, 1111, 77, 2, 27, "Input"],
Cell[30411, 1115, 1081, 33, 71, "Text",
  Evaluatable->False],
Cell[31495, 1150, 3575, 118, 166, "Text",
  Evaluatable->False],
Cell[35073, 1270, 157, 4, 27, "Input"],
Cell[35233, 1276, 1261, 45, 71, "Text",
  Evaluatable->False],
Cell[36497, 1323, 1923, 69, 109, "Text",
  Evaluatable->False],
Cell[38423, 1394, 72, 1, 27, "Input"],
Cell[38498, 1397, 280, 10, 33, "Text",
  Evaluatable->False],
Cell[38781, 1409, 70, 2, 27, "Input"],
Cell[38854, 1413, 90, 2, 33, "Text",
  Evaluatable->False],
Cell[38947, 1417, 198, 4, 43, "Input"],
Cell[39148, 1423, 326, 13, 33, "Text",
  Evaluatable->False],
Cell[39477, 1438, 574, 18, 52, "Text",
  Evaluatable->False],
Cell[40054, 1458, 59, 1, 27, "Input"],
Cell[40116, 1461, 123, 3, 27, "Input"],
Cell[40242, 1466, 115, 2, 33, "Text",
  Evaluatable->False],
Cell[40360, 1470, 120, 3, 27, "Input"],
Cell[40483, 1475, 1290, 47, 67, "Question",
  Evaluatable->False],
Cell[41776, 1524, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41853, 1528, 636, 23, 33, "Text",
  Evaluatable->False],
Cell[42492, 1553, 110, 2, 27, "Input"],
Cell[42605, 1557, 376, 13, 33, "Text",
  Evaluatable->False],
Cell[42984, 1572, 58, 1, 27, "Input"],
Cell[43045, 1575, 94, 2, 27, "Input"],
Cell[43142, 1579, 983, 34, 67, "Question",
  Evaluatable->False],
Cell[44128, 1615, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[44205, 1619, 547, 17, 52, "Text",
  Evaluatable->False],
Cell[44755, 1638, 690, 25, 48, "Question",
  Evaluatable->False],
Cell[45448, 1665, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[45559, 1672, 214, 8, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.17.11"],
Cell[45776, 1682, 295, 7, 71, "Text",
  Evaluatable->False],
Cell[46074, 1691, 5201, 192, 318, "Question",
  Evaluatable->False],
Cell[51278, 1885, 197, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[51512, 1895, 374, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:11.18.11"],
Cell[51889, 1911, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[52234, 1922, 63, 1, 27, "Input"],
Cell[52300, 1925, 49, 1, 27, "Input"],
Cell[52352, 1928, 50, 1, 27, "Input"],
Cell[52405, 1931, 48, 1, 27, "Input"],
Cell[52456, 1934, 56, 1, 27, "Input"],
Cell[52515, 1937, 52, 1, 27, "Input"],
Cell[52570, 1940, 52, 1, 27, "Input"],
Cell[52625, 1943, 57, 1, 27, "Input"],
Cell[52685, 1946, 58, 1, 27, "Input"],
Cell[52746, 1949, 53, 1, 27, "Input"],
Cell[52802, 1952, 65, 1, 27, "Input"],
Cell[52870, 1955, 58, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

