(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     73571,       2703]*)
(*NotebookOutlinePosition[     76037,       2786]*)
(*  CellTagsIndexPosition[     75684,       2771]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Ring Lab 12",
    FontSize->18],
  "\nFactoring in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]]
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:12.12"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.13.12"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Prerequisites"
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.14.12"],

Cell[TextData[{
  "You should have an elementary understanding of divisors and factoring with \
integers. It may also be helpful to be familiar with the ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  "."
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Goals"
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.15.12"],

Cell[TextData[{
  "The goal of this lab is to explore the notion of factoring numbers in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]]],
  " for various integers ",
  Cell[BoxData[
      FormBox["d", TraditionalForm]]],
  ". In particular, we want to see when this factorization is unique (in some \
sense) and when it is not."
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Introduction to divisibility"
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.16.12"],

Cell["\<\
To work on this lab, we load the packages that define the needed \
functionality.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Ring]; \)\)}], "Input",
  InitializationCell->True],

Cell[TextData[{
  "This lab focuses on a particular class of rings that are extensions of the \
integers. Let ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " be a fixed integer and consider the set ",
  Cell[BoxData[
      \(TraditionalForm
      \`{r + s \@ d | r, s \[Element] \[DoubleStruckCapitalZ]}\)]],
  ". We denote this set by ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  ". If ",
  Cell[BoxData[
      \(TraditionalForm\`d = 2\)]],
  ", the following illustrates a subset of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  ", when we restrict ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`{\(-2\), \(-1\),  ... , \ 3}\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Adjoin[Range[\(-2\), 3], \@2]\)], "Input"],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the result of letting ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"d", "=", "4"}], TraditionalForm]]],
  StyleBox["? In other words, what does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["4"], "]"}], TraditionalForm]]],
  StyleBox[" look like? What about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["9"], "]"}], TraditionalForm]]],
  StyleBox["? What about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["16"], "]"}], TraditionalForm]]],
  StyleBox["? Can you think of any restrictions on ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["d", TraditionalForm]]],
  StyleBox[" that we may wish to impose?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Note that when we let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`d = \(-1\)\)]],
  StyleBox[", we obtain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-1\)]\)]],
  StyleBox[", the Gaussian integers; it is frequently denoted ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Throughout the rest of the lab, we assume that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[" is an integral domain. If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" are two elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[", with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" nonzero, we say that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["divides",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" (or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["factor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[") if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s = r\ t\)]],
  StyleBox[" for some ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[". When ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" divides ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  ", it",
  StyleBox[" is denoted ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r | s\)]],
  StyleBox[" and we say that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["divisor",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[". Note that the units of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[" are those elements that are divisors of the unity of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For each ring given, determine whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r | s\)]],
  StyleBox[". If yes, indicate the value of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s = r\ t\)]],
  StyleBox[".\n\ta. In \[DoubleStruckCapitalZ], is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`5 | 15\)]],
  StyleBox["?\n\tb. In \[DoubleStruckCapitalZ], is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`15 | 5\)]],
  StyleBox["? \n\tc. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@3]\)]],
  StyleBox[", is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((2 + \@3)\) | \((\(-7\) - 6\ \@3)\)\)]],
  StyleBox["?\n\td. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@3]\)]],
  StyleBox[", is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((4 - 5\ \@3)\) | \((\(-7\) - 6\ \@3)\)\)]],
  StyleBox["?\n\te. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  StyleBox[", is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3 | 9\)]],
  StyleBox["?\n\tf. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  StyleBox[", is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((2 + \(\@\(-5\))\) | 9\)\)]],
  StyleBox["?\n\tg. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  StyleBox[", is it the case that (",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2 - \(\@\(-5\))\) | 9\)]],
  StyleBox["?\n\th. What is the product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2 + \@\(-5\)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`2 - \@\(-5\)\)]],
  StyleBox["?\n\ti. In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  StyleBox[", is it the case that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3 | \((2 + \(\@\(-5\))\)\)\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["r", TraditionalForm]]],
  StyleBox[" is a unit in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["D", TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["x", TraditionalForm]]],
  StyleBox[" is any other element, what can you say about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"r", "|", "x"}], TraditionalForm]]],
  StyleBox["? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox[
  "When we are working with (ordinary) integers, it is fairly easy to know \
when ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["r", TraditionalForm]]],
  StyleBox[" divides ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["s", TraditionalForm]]],
  StyleBox[". Essentially, we want to know if the quotient ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        FractionBox["s", "r"], TraditionalForm]]],
  " ",
  StyleBox["is an integer. We can define a function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DividesQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" by using this approach.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(DividesQ[6, 18]\), 
    \(DividesQ[6, 16]\)}], "Input"],

Cell[BoxData[
    \(\(?DividesQ\)\)], "Input"],

Cell[TextData[{
  StyleBox["When we work over the ring ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]]],
  StyleBox[", we extend this function by adding the option ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Radical ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" d",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". The following shows that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"1", "+", 
          SqrtBox["2"]}], TraditionalForm]]],
  StyleBox[" is a unit in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["2"], "]"}], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(DividesQ[1 + \@2, 1, Radical \[Rule] 2]\)], "Input"],

Cell[TextData[{
  "This result indicates that there is an element ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`\((1 + \@2)\)\ t = 1\)]],
  ". What is ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  "? Let\[CloseCurlyQuote]s perform the division."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(1\/\(1 + \@2\)\)], "Input"],

Cell[BoxData[
    \(Simplify[%]\)], "Input"],

Cell[TextData[{
  StyleBox["Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Simplify",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" does not return an element in the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"a", "+", 
          RowBox[{"b", " ", 
            SqrtBox["2"]}]}], TraditionalForm]]],
  StyleBox[", so we need to turn to another function.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdDivide[1, 1 + \@2]\)], "Input"],

Cell[TextData[{
  "We see that ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is indeed an element in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.4 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Associates, irreducibility, and norms"
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.17.12"],

Cell[TextData[{
  StyleBox[
  "We need to introduce (or review) some definitions. Given elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[", we say that they are ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["associates",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" if there is a unit ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r = s\ u\)]],
  StyleBox[". A nonzero element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[" is called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["irreducible",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" is not a unit, and whenever ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r = b\ c\)]],
  StyleBox[" (for elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox["), then ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" is a unit. (In other words, the only divisors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[" are units and associates of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q4",
    FontWeight->"Bold"],
  ".\ta. What are the associates of 5 over the integers? \n\tb. What are the \
associates of 5 over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  "? \n\tc. Are ",
  Cell[BoxData[
      \(TraditionalForm\`3 + 4\ \@2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`5 - \@2\)]],
  " associates over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  "?"
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". \ta. Is 5 irreducible over the integers? Why or why not?\n\tb. Is 6 \
irreducible over the integers? Why or why not?\n\tc. Is 5 irreducible over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][i]\)]],
  StyleBox["? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZdAssociatesQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" can confirm whether a pair of numbers are associates over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(?ZdAssociatesQ\)\)], "Input"],

Cell[BoxData[
    \(ZdAssociatesQ[2, 3 + 4\ \@2, 5 - \@2]\)], "Input"],

Cell[TextData[{
  StyleBox["For negative ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["d", TraditionalForm]]],
  StyleBox[", the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZdIrreducibleQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " specifies whether an element is irreducible. (The problem is more \
difficult to answer for positive ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["d", TraditionalForm]]],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdIrreducibleQ[\(-1\), 5]\)], "Input"],

Cell[TextData[{
  StyleBox[
  "Since 5 is not irreducible, we should be able to factor this over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", "i", "]"}], 
        TraditionalForm]]],
  StyleBox[", the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["GaussianIntegers",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(FactorInteger[5, GaussianIntegers \[Rule] True]\)], "Input"],

Cell[TextData[{
  StyleBox["The last idea introduced in this section is the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["norm",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" function. We define the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`N\)]],
  StyleBox[": ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" {nonnegative integers} by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`N(a + b\ \@d) = \(\(| a\)\^2 - d  b\^2 | \)\)]],
  StyleBox[
  ". (Note: Some authors prefer a slightly different definition.) In ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", we use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZdNorm",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to compute the norm. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider some examples over ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@5]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False],

Cell[BoxData[
    \(examples = Adjoin[{\(-1\), 0, 1, 2}, \@5]\)], "Input"],

Cell[BoxData[
    \(Map[{#, \ ZdNorm[#]}&, \ examples] // 
      TableForm[#, \ 
          TableHeadings\  \[Rule] \ \n\t{None, \ {"\<x\>", \ "\<N(x)\n\>"}}, 
          \ TableSpacing\  \[Rule] \ {0.5, \ 3}]&\)], "Input"],

Cell[TextData[{
  "There are four important properties about the norm function that should be \
observed; check your text for details.\n\n\t1. ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = 0\)]],
  " if and only if ",
  Cell[BoxData[
      \(TraditionalForm\`x = 0\)]],
  ",\n\t2. ",
  Cell[BoxData[
      \(TraditionalForm\`N(x  y) = \(N(x)\) \(N(y)\)\)]],
  " for all ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ",\n\t3. ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = 1\)]],
  " if and only if ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a unit, and\n\t4. If ",
  Cell[BoxData[
      \(TraditionalForm\`N(x)\)]],
  " is prime (in \[DoubleStruckCapitalZ]), then ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is irreducible in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". In the list of examples of elements from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@5]\)]],
  StyleBox[
  ", which are units and which can be readily seen as being irreducible?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Consider ",
  Cell[BoxData[
      \(TraditionalForm\`x = 2 + 3\ \@\(-6\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2 - 3\ \@\(-6\)\)]],
  " as elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-6\)]\)]],
  ". Let\[CloseCurlyQuote]s verify property 2."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(x = 2 + 3\ \@\(-6\)\), 
    \(y = 2 - 3\ \@\(-6\)\), 
    \(ZdNorm[x\ y] === ZdNorm[x]\ ZdNorm[y]\)}], "Input"],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x = 1 + 3\ \@\(-5\)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y = 1 - 3\ \@\(-5\)\)]],
  StyleBox[". Verify that property 2 is true with these values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[". Repeat using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x = 2\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y = 23\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox[
  "Be careful how you read property 4; the converse is not true, in general. \
For example, with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x = 1 + 3\ \@\(-5\)\)]],
  StyleBox[", used in question 7, the norm of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" is 46, which is composite.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdNorm[1 + 3\ \@\(-5\)]\)], "Input"],

Cell[TextData[{
  StyleBox["This does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" imply that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" irreducible! In fact, in section 12.6, we show that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" is indeed irreducible.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Units in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]]]
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.18.12"],

Cell[TextData[{
  "Recall from the third property of the norm function that ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a unit if and only if ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = 1\)]],
  ". Can we use this tact to determine the units of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  "? Let ",
  Cell[BoxData[
      \(TraditionalForm\`x = a + b\ \@d\)]],
  " be an element in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  ". Then ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = \(\(| a\)\^2 - d\ b\^2 | \)\)]],
  ". First, let\[CloseCurlyQuote]s consider the case where ",
  Cell[BoxData[
      \(TraditionalForm\`d < \(-1\)\)]],
  " and let ",
  Cell[BoxData[
      \(TraditionalForm\`k = \(-d\)\)]],
  ". Then we have ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = a\^2 + k\ b\^2\)]],
  ", with ",
  Cell[BoxData[
      \(TraditionalForm\`k > 1\)]],
  ". Since ",
  Cell[BoxData[
      \(TraditionalForm\`k > 1\)]],
  " and we are assuming that ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = 1\)]],
  " (since we want ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " to be a unit), then we must have ",
  Cell[BoxData[
      \(TraditionalForm\`b = 0\)]],
  ", for otherwise ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\^2 + k\ b\^2 \[GreaterEqual] k\) > 1\)]],
  ". Therefore, ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 = 1\)]],
  ", so the only units are 1 and ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  "."
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s consider a geometric argument for the same \
question. To be specific, suppose we consider ",
  Cell[BoxData[
      \(TraditionalForm\`k = 2\)]],
  " (i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`d = \(-2\)\)]],
  "). What we are really considering is whether there are integral solutions \
to the equation ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 + 2  b\^2 = 1\)]],
  ". But this is just the equation of an ellipse, so let\[CloseCurlyQuote]s \
look at its graph. We need to first read in a package that allows us to plot \
equations implicitly."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Needs["\<Graphics`ImplicitPlot`\>"]\)], "Input"],

Cell["Here we plot the ellipse determined by this equation.", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Clear[a, b]\), 
    \(\(gr1 = 
      ImplicitPlot[a\^2 + 2\ b\^2 == 1, {a, \(-2\), 2}, 
        AspectRatio \[Rule] Automatic, 
        PlotRange \[Rule] {{\(-2\), 2}, {\(-1\), 1}}]; \)\)}], "Input"],

Cell["\<\
Next we graph a backdrop for our ellipse, consisting of points with \
integer coordinates in the neighborhood of the ellipse.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(gr2 = 
      IntegerLatticeGrid[{\(-2\), 2}, {\(-1\), 1}, 
        PlotStyle \[Rule] {PointSize[0.025], RGBColor[0, 0, 1]}, 
        AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell["Putting them together results in the following.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(Show[{gr2, gr1}, AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  "It should be clear that the only points with integer coordinates that lie \
on the ellipse occur where ",
  Cell[BoxData[
      FormBox[
        RowBox[{"a", "=", "1"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"b", "=", "0"}], TraditionalForm]]],
  " and where ",
  Cell[BoxData[
      FormBox[
        RowBox[{"a", "=", 
          RowBox[{"-", "1"}]}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"b", "=", "0"}], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "This figure illustrates that when ",
  Cell[BoxData[
      \(TraditionalForm\`d = \(-2\)\)]],
  " the only units are 1 and ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  ". What about smaller values of ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  "? Consider the following series of graphics. After evaluating the cell, \
you may wish to double-click on one of the graphics and adjust the animation \
speed by typing 1 through 9 (1 slow, 9 fast)."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(Do[
      ImplicitPlot[a\^2 - d\ b\^2 == 1, {a, \(-2\), 2}, 
        AspectRatio \[Rule] Automatic, 
        PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}, 
        PlotLabel \[Rule] "\<d = \>"<>ToString[d]], {d, \(-3\), \(-15\), 
        \(-2\)}]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What is the conclusion? If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"d", "<", 
          RowBox[{"-", "2"}]}], TraditionalForm]]],
  StyleBox[", how many units are there? What are they? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "What if ",
  Cell[BoxData[
      \(TraditionalForm\`d = \(-1\)\)]],
  "? We then have ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = \(a\^2 - \((\(-1\))\)\ b\^2 = 1\)\)]],
  ", or ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = \(a\^2 + b\^2 = 1\)\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(\(gr1 = 
      ImplicitPlot[a\^2 + b\^2 == 1, {a, \(-2\), 2}, 
        AspectRatio \[Rule] Automatic, 
        PlotRange \[Rule] {{\(-2\), 2}, {\(-2\), 2}}, 
        DisplayFunction \[Rule] Identity]; \)\), 
    \(\(Show[{gr2, gr1}, AspectRatio \[Rule] Automatic, \ 
      DisplayFunction \[Rule] $DisplayFunction]; \)\)}], "Input"],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". When ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"d", "=", 
          RowBox[{"-", "1"}]}], TraditionalForm]]],
  StyleBox[", how many units are there? What are they? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "Next we consider ",
  Cell[BoxData[
      \(TraditionalForm\`d > 1\)]],
  ". When ",
  Cell[BoxData[
      \(TraditionalForm\`d = 2\)]],
  " we have ",
  Cell[BoxData[
      \(TraditionalForm\`N(x) = \(\(\(| a\)\^2 - 2\ b\^2 | \) = 1\)\)]],
  ". Therefore, we need ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 - 2\ b\^2\)]],
  " to have the value 1 or ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  ". This simply gives rise to two hyperbolas, ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 - 2\ b\^2 = 1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 - 2\ b\^2 = \(-1\)\)]],
  ". They are now graphed to gain some geometric insight."
}], "Text",
  ShowShortBoxForm->True,
  Evaluatable->False],

Cell[BoxData[{
    \(\(c = 4; \)\), 
    \(\(gr1 = 
      ImplicitPlot[{a\^2 - 2\ b\^2 == 1, a\^2 - 2\ b\^2 == \(-1\)}, {a, 
          \(-c\), c}, AspectRatio \[Rule] Automatic, 
        PlotStyle 
          \[Rule] {{Thickness[0.02], Green}, {Thickness[0.02], Magenta}}, 
        PlotRange \[Rule] {{\(-c\), c}, {\(-c\), c}}]; \)\)}], "Input"],

Cell[TextData[
"Here is the graph with an integer lattice backdrop (actually, a \
\[OpenCurlyDoubleQuote]foredrop\[CloseCurlyDoubleQuote] this time), showing \
the two together."], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(gr2 = 
      IntegerLatticeGrid[{\(-c\), c}, {\(-c\), c}, 
        PlotStyle \[Rule] {PointSize[0.025], Blue}, 
        AspectRatio \[Rule] Automatic, DisplayFunction \[Rule] Identity]; \n
    Show[{gr1, gr2}, DisplayFunction \[Rule] $DisplayFunction]; \)], "Input"],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Do you \[OpenCurlyDoubleQuote]see\[CloseCurlyDoubleQuote] any units? \
(Remember, we are looking for units in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ][\@2] = {a + b \@ 2 | a, 
          b \[Element] \[DoubleStruckCapitalZ]}\)]],
  StyleBox[
  " that have integer coordinates and must satisfy one of the equations \
giving rise to a hyperbola.) List the ones you see. Use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZdUnitQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " if you wish to verify that it is a unit; see the following example.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZdUnitQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " can be used to confirm or deny whether an element is a unit or not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(?ZdUnitQ\)\)], "Input"],

Cell[BoxData[
    \(ZdUnitQ[2, 2 + \@2]\)], "Input"],

Cell[TextData[{
  "Consider the element ",
  Cell[BoxData[
      \(TraditionalForm\`x = 3 + 2\ \@2\)]],
  "; this is a unit in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdUnitQ[2, x = 3 + 2\ \@2]\)], "Input"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is a unit, then any power of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is also a unit. (Appropriate use of properties 2 and 3 is one method of \
verifying this statement.) Let\[CloseCurlyQuote]s examine the powers of this \
element. Here are the first five powers."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(pts1 = Table[Expand[x\^k], {k, 1, 5}]\)], "Input"],

Cell["We can verify that these are indeed units.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Map[ZdUnitQ[2, \ #]&, \ pts1]\)], "Input"],

Cell[TextData[{
  StyleBox[
  "These elements appear to be growing without bound. Here is geometric view \
of what is happening, showing only the parts of the hyperbolas in the first \
quadrant and the powers of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" colored according to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Hue",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (the \[OpenCurlyDoubleQuote]rainbow\[CloseCurlyDoubleQuote]).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(convertPts[lst_] := 
      lst /. {a_ + b_\ \@2 \[RuleDelayed] {a, b}, 
          a_ + \@2 \[RuleDelayed] {a, 1}}\), 
    \(\(pts1 = convertPts[pts1]; \)\), 
    \(\(n = Length[pts1]; \)\), 
    \(\(c = 3400; \)\), 
    \(\(gr1 = 
      ImplicitPlot[{a\^2 - 2\ b\^2 == 1, a\^2 - 2\ b\^2 == \(-1\)}, {a, 0, 
          c}, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {Green, Magenta}, 
        PlotRange \[Rule] {{0, c}, {0, c}}, 
        Epilog \[Rule] 
          Table[{Hue[k\/n], PointSize[0.03], 
              Map[Point, 
                pts1\[LeftDoubleBracket]k\[RightDoubleBracket], {0}]}, {k, 1, 
              n}]]; \)\)}], "Input"],

Cell["Here are the five colors (in order) of the dots plotted.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(Show[
      Graphics[Table[{Hue[i\/5], Rectangle[{i, 0}, {i + 1, 1}]}, {i, 5}]]]; 
    \)\)], "Input"],

Cell[TextData[{
  "(You might ask where the yellow is on the plot.) Let\[CloseCurlyQuote]s \
try another element, ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(-1\) + \@2\)]],
  ", which is also a unit, and its first ten powers."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(ZdUnitQ[2, x = \(-1\) + \@2]\), 
    \(pts2 = Table[Expand[x\^k], {k, 1, 10}]\), 
    \(\((ZdUnitQ[2, #1]&)\)/@pts2\)}], "Input"],

Cell[TextData[{
  "Here is the graph of the hyperbolas with the ten powers of this ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " plotted."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(\(pts2 = convertPts[pts2]; \)\), 
    \(\(n = Length[pts2]; \)\), 
    \(\(c = 3400; \)\), 
    \(\(gr1 = 
      ImplicitPlot[{a\^2 - 2\ b\^2 == 1, a\^2 - 2\ b\^2 == \(-1\)}, {a, 
          \(-c\), c}, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] {Green, Magenta}, 
        PlotRange \[Rule] {{\(-c\), c}, {\(-c\), c}}, 
        Epilog \[Rule] 
          Table[{Hue[k\/n], PointSize[0.03], 
              Map[Point, 
                pts2\[LeftDoubleBracket]k\[RightDoubleBracket], {0}]}, {k, 1, 
              n}]]; \)\)}], "Input"],

Cell[TextData[{
  "As ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " increases in the power ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  ", the points are colored according to the following scheme, where the \
power ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is located in the rectangle."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(Show[
      Graphics[Table[{Hue[i\/10], Rectangle[{i, 0}, {i + 1, 1}], Black, 
            Text[i, {0.5 + i, 0.5}]}, {i, 10}]]]; \)\)], "Input"],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What is fundamentally different between the powers of these two elements \
(",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`3 + 2\ \@2\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) + \@2\)]],
  StyleBox["), as shown by the graphs?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "As can be seen, ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["2"], "]"}], TraditionalForm]]],
  " has an infinite number of units. This is true whenever ",
  Cell[BoxData[
      FormBox[
        RowBox[{"d", ">", "1"}], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.6 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Factoring 46 in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox[
            RowBox[{"-", "5"}]], "]"}], TraditionalForm]]]
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.19.12"],

Cell["\<\
In question 7, we investigated the norm of the following four \
numbers.\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(x = 1 + 3\ \@\(-5\)\), 
    \(y = ZdConjugate[x]\), 
    \(a = 2\), 
    \(b = 23\), 
    \(ZdNorm/@{x, y, a, b}\)}], "Input"],

Cell[TextData[{
  "Note further that ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"x", " ", "y"}], "=", 
          RowBox[{
            RowBox[{"a", " ", "b"}], "=", "46"}]}], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(Expand[x\ y] == 46\)], "Input"],

Cell[TextData[{
  "This expansion shows that ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " are all divisors of 46. Are there any more?"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdDivisors[\(-5\), 46]\)], "Input"],

Cell["We are really only interested in the nontrivial ones.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdDivisors[\(-5\), 46, NonTrivialOnly \[Rule] True]\)], "Input"],

Cell[TextData[{
  "That 46 has only four nontrivial divisors (over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  ") is not significant in itself. If we consider the integer 80, we know \
that it has many divisors as well."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(IntegerDivisors[80, NonTrivialOnly \[Rule] True]\)], "Input"],

Cell[TextData[{
  "We know that 80 can be written as ",
  Cell[BoxData[
      \(TraditionalForm\`2*40\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`4*20\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`5*16\)]],
  ", or ",
  Cell[BoxData[
      \(TraditionalForm\`8*10\)]],
  ", but in each case one or both factors can be further factored (into \
primes) until one obtains the result 2 ",
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  " 2 ",
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  " 2 ",
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  " 2 ",
  Cell[BoxData[
      \(TraditionalForm\`*\)]],
  " 5, or ",
  Cell[BoxData[
      \(TraditionalForm\`2\^4*5\)]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(FactorInteger[80]\)], "Input"],

Cell[TextData[{
  "Except for the order in which these factors are written, or perhaps \
exchanging a factor with its associate, this product is unique. This is a \
result of the Fundamental Theorem of Arithmetic. The question to pursue here \
is whether an analogous situation holds in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  " and other rings. In other words, even though ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((1 + 3\ \@\(-5\))\) \((1 - 3\ \@\(-5\))\) = \(46 = 2*23\)\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  " shows that we have two factorizations that appear different, we want to \
make sure that we have factored 46 into irreducibles. Also, we want to see if \
",
  Cell[BoxData[
      \(TraditionalForm\`1 + 3\ \@\(-5\)\)]],
  " is possibly an associate of 2 or 23 and if ",
  Cell[BoxData[
      \(TraditionalForm\`1 - 3\ \@\(-5\)\)]],
  " is an associate of the other. Thus, we have two steps to take."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "1. Determine whether 2, 23, ",
  Cell[BoxData[
      \(TraditionalForm\`1 + 3\ \@\(-5\)\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`1 - 3\ \@\(-5\)\)]],
  " satisfy our definition of being irreducible.\n2. Determine if any of ",
  Cell[BoxData[
      \(TraditionalForm\`{2, 23}\)]],
  " are associates with any of ",
  Cell[BoxData[
      \(TraditionalForm\`{1 + 3\ \@\(-5\), 1 - 3\ \@\(-5\)}\)]],
  "."
}], "Text",
  CellMargins->{{48, 36}, {Inherited, Inherited}},
  Evaluatable->False],

Cell[TextData[{
  "Recall that for ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " to be irreducible over an integral domain ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  ", it must be nonzero, not a unit, and if we ever have ",
  Cell[BoxData[
      \(TraditionalForm\`s\ t = r\)]],
  " (for ",
  Cell[BoxData[
      \(TraditionalForm\`s, t \[Element] D\)]],
  "), we must have either ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " a unit. Clearly none of the four are zero, and when we calculated their \
norms we observed that none had norm 1, so they are not units. First let\
\[CloseCurlyQuote]s consider 2 and show that it is irreducible. Its norm is \
four."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdNorm[2]\)], "Input"],

Cell[TextData[{
  "Therefore, if ",
  Cell[BoxData[
      \(TraditionalForm\`2 = s\ t\)]],
  " for some ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`D = \[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  ", then ",
  Cell[BoxData[
      \(TraditionalForm\`N(s)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`N(t) = 4\)]],
  ", by the second property of norms. To show that 2 is irreducible, we need \
to show that either ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is a unit and consequently has norm 1 (by the third property). Therefore, \
since the divisors of 4 are ",
  Cell[BoxData[
      \(TraditionalForm\`{1, 2, 4}\)]],
  ", we want to show that we cannot have ",
  Cell[BoxData[
      \(TraditionalForm\`N(s) = \(N(t) = 2\)\)]],
  ", and then we will know that 2 is irreducible."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why do we need to show only that we cannot have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`N(s) = 2\)]],
  StyleBox[" to show that 2 is irreducible?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[TextData[{
  "If we let ",
  Cell[BoxData[
      \(TraditionalForm\`s = a + b\ \@\(-5\)\)]],
  ", then we see that ",
  Cell[BoxData[
      \(TraditionalForm\`N(s) = a\^2 + 5\ b\^2\)]],
  ". For ",
  Cell[BoxData[
      \(TraditionalForm\`N(s) = 2\)]],
  ", we must have integral coordinates for a point somewhere on the ellipse ",
  
  Cell[BoxData[
      \(TraditionalForm\`a\^2 + 5\ b\^2 = 2\)]],
  ". Inspecting this algebraically, clearly if ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " is not zero, then the left-hand side is already at least 5, which is not \
possible (since we still have to add ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`5\ b\^2\)]],
  ", while the right-hand side is 2). Geometrically, we can see this as \
follows."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdPossibleNorms[\(-5\), 2, Mode \[Rule] Visual]\)], "Input"],

Cell[TextData[{
  StyleBox["This function shows the ellipse ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\^2 + 5\ b\^2 = 2\)]],
  StyleBox[
  ", as well as showing all points whose norm is less than or equal to 2 (and \
the output is a list of all norms that are possible that are less than or \
equal to 2). We can also just use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ZdPossibleNormQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdPossibleNormQ[\(-5\), 2]\)], "Input"],

Cell[TextData[{
  StyleBox[
  "Now we know that 2 is indeed an irreducible element. Next we attack 23 and \
investigate whether it is irreducible. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s assume that it is not irreducible and see if we can find a \
contradiction. Therefore ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`23 = s\ t\)]],
  StyleBox[", where ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" are in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  StyleBox[". Consequently, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`N(23) = \(N(s)\)\ \(N(t)\)\)]],
  ",",
  StyleBox[" and we need to find elements ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" whose norm is a divisor of the norm of 23. Not that we need ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " to help us in this case (the arithmetic is easy), but to illustrate the \
general idea, we want to look for the nontrivial divisors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`23\^2\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(IntegerDivisors[ZdNorm[23], NonTrivialOnly \[Rule] True]\)], "Input"],

Cell[TextData[{
  "The only possible divisor is 23, so both ",
  Cell[BoxData[
      FormBox[
        RowBox[{"N", "(", "s", ")"}], TraditionalForm]]],
  " and ",
  Cell[BoxData[
      FormBox[
        RowBox[{"N", "(", "t", ")"}], TraditionalForm]]],
  " must be 23. Is it possible to have this norm in the ring ",
  Cell[BoxData[
      FormBox[
        RowBox[{"D", "=", 
          RowBox[{"\[DoubleStruckCapitalZ]", "[", 
            SqrtBox[
              RowBox[{"-", "5"}]], "]"}]}], TraditionalForm]]],
  "?"
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdPossibleNormQ[\(-5\), 23]\)], "Input"],

Cell[TextData[
"Let\[CloseCurlyQuote]s \[OpenCurlyDoubleQuote]see\[CloseCurlyDoubleQuote] \
why not."], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdPossibleNorms[\(-5\), 23, Mode \[Rule] Visual]\)], "Input"],

Cell[TextData[{
  "The value 23 is not obtainable as a norm, and therefore there are no ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`N(s) = \(N(t) = 23\)\)]],
  ", so either ",
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  " or ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " is a unit and 23 is irreducible."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "There are two elements left to check for irreducibility, ",
  Cell[BoxData[
      \(TraditionalForm\`1 + 3\ \@\(-5\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`1 - 3\ \@\(-5\)\)]],
  ". We proceed in the same manner."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(IntegerDivisors[ZdNorm[1 + 3\ \@\(-5\)], NonTrivialOnly \[Rule] True]
      \), 
    \(IntegerDivisors[ZdNorm[1 - 3\ \@\(-5\)], NonTrivialOnly \[Rule] True]
      \)}], "Input"],

Cell[TextData[{
  "Since the only possible nontrivial divisors of the norms are 2 and 23, and \
we have seen that neither of these norms is possible, we know that both the \
elements ",
  Cell[BoxData[
      \(TraditionalForm\`1 + 3\ \@\(-5\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`1 - 3\ \@\(-5\)\)]],
  " are irreducible."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Here is an optional question. Define the function \[Nu] by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Nu](x)\)]],
  StyleBox[" is the number of norm values possible in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  StyleBox[" that are less than or equal to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[". Determine ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Nu](100)\)]],
  ".",
  StyleBox[" How much larger is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Nu](200)\)]],
  StyleBox[" than ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Nu](100)\)]],
  StyleBox[
  "? (In other words, compare the number of possible norm values from 1 to \
100 in contrast to the number of possible norm values from 101 to 200.) How \
does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Nu](300)\)]],
  StyleBox[" compare to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[Nu](200)\)]],
  StyleBox[
  "? Is there a monotonic pattern? You may wish to use the following to help \
you, with the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Length",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function to measure the output. (Eliminate the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mode ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" Visual",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " option if the graphics take too long\[LongDash]they are not needed for \
the count.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False],

Cell[BoxData[
    \(ZdPossibleNorms[\(-5\), 100, Mode \[Rule] Visual]\)], "Input"],

Cell[TextData[{
  "We have shown that the four divisors of 46 are all irreducible. Next we \
want to know if any of ",
  Cell[BoxData[
      \(TraditionalForm\`{2, 23}\)]],
  " are associates with ",
  Cell[BoxData[
      \(TraditionalForm\`{1 + 3\ \@\(-5\), 1 - 3\ \@\(-5\)}\)]],
  ", step 2 in our outline. Recall that for 2 to be an associate of ",
  Cell[BoxData[
      \(TraditionalForm\`1 + 3\ \@\(-5\)\)]],
  ", it must have a unit ",
  Cell[BoxData[
      \(TraditionalForm\`u\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`2 = u*\((1 + 3\ \@\(-5\))\)\)]],
  ". If so, then ",
  Cell[BoxData[
      \(TraditionalForm\`N(2) = \(N(u)\)\ \(N(1 + 3\ \@\(-5\))\)\)]],
  ", or ",
  Cell[BoxData[
      \(TraditionalForm\`4 = 1*46\)]],
  ", which is clearly not possible. The following shows that no possible \
arrangement (matching across the two sets) for pairing up associates will be \
fruitful."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(Map[ZdNorm, {2, 23}]\), 
    \(Map[ZdNorm, {1 + 3\ \@\(-5\), 1 - 3\ \@\(-5\)}]\)}], "Input"],

Cell["\<\
(Note that checking for associates could have also been done as \
follows.)\
\>", "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(ZdAssociatesQ[\(-5\), 2, 1 + 3\ \@\(-5\)]\), 
    \(ZdAssociatesQ[\(-5\), 23, 1 + 3\ \@\(-5\)]\)}], "Input"],

Cell[TextData[{
  "What is the conclusion? In ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  " we have ",
  Cell[BoxData[
      \(TraditionalForm\`46 = 2*23\)]],
  " and",
  " ",
  Cell[BoxData[
      \(TraditionalForm
      \`46 = \((1 + 3\ \@\(-5\))\)*\((1 - 3\ \@\(-5\))\)\)]],
  ". These four divisors are all irreducible and the two factorizations do \
not involve associates (as would ",
  Cell[BoxData[
      \(TraditionalForm\`46 = 2*23\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`46 = \((\(-2\))\)*\((\(-23\))\)\)]],
  "). Consequently, we have two distinct, unrelated factorizations of the \
number 46. This verifies that ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  " is ",
  StyleBox["not",
    FontSlant->"Italic"],
  " a Unique Factorization Domain (UFD)."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Historical note",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[": There was a short time in the nineteenth century when Fermat",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s Last Theorem was considered to have been proven, but there was a flaw in \
the proof. This flaw, discovered by Kummar, traced back to an assumption that \
factorization was unique in rings such as ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.7 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "Is ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox[
            RowBox[{"-", "6"}]], "]"}], TraditionalForm]]],
  " a UFD?"
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.20.12"],

Cell[TextData[{
  "Since we have shown that ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  " is not a UFD (Unique Factorization Domain), we may wonder about other \
related rings. Let\[CloseCurlyQuote]s consider a neighbor (in some sense), ",
  Cell[BoxData[
      \(TraditionalForm\`D = \[DoubleStruckCapitalZ][\@\(-6\)]\)]],
  ". To show that ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " is not a UFD, we need to find an element ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`D\)]],
  " that has two distinct factorizations. Since we may want to \
\[OpenCurlyDoubleQuote]automate\[CloseCurlyDoubleQuote] the process, we label \
each step along the way with variables to hold the values, so we can readily \
try other rings."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  "In this example, we are using ",
  Cell[BoxData[
      FormBox[
        RowBox[{"d", "=", 
          RowBox[{"-", "6"}]}], TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(d = \(-6\)\)], "Input"],

Cell[TextData[
"Let\[CloseCurlyQuote]s pick two random\[LongDash]but not too \
large\[LongDash]coefficients."], "Text",
  Evaluatable->False],

Cell[BoxData[
    \({a, b} = Table[Random[Integer, {1, 5}], {2}]\)], "Input"],

Cell[TextData[{
  "We use these values to form ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " and let ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " be its conjugate."
}], "Text",
  Evaluatable->False],

Cell[BoxData[{
    \(x = a + b\ \@d\), 
    \(y = ZdConjugate[x]\)}], "Input"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      FormBox["z", TraditionalForm]]],
  " be their product."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(z = Expand[x\ y]\)], "Input"],

Cell[TextData[{
  StyleBox["We use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["nrm",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for the norm of this product.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(nrm = ZdNorm[z]\)], "Input"],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s take a look at all the divisors of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(\(ZdDivisors[d, z, DivisorsComplete \[Rule] True]\n\)\)], "Input"],

Cell["We can view these divisors by pairing up associates.", "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdDivisors[d, z, Combine \[Rule] Associates, 
      DivisorsComplete \[Rule] True]\)], "Input"],

Cell[TextData[{
  "We can also pair up the divisors so that the product of each pair is ",
  Cell[BoxData[
      FormBox["z", TraditionalForm]]],
  "."
}], "Text",
  Evaluatable->False],

Cell[BoxData[
    \(ZdDivisors[d, z, Combine \[Rule] Products, 
      DivisorsComplete \[Rule] True]\)], "Input"],

Cell[TextData[{
  "From here, we should look for two pairs whose product is ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", all divisors are irreducible, and none is an associate of the others."
}], "Text",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Find two pairs that satisfy these conditions. If there are not two \
pairs, go back and generate a new ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["x", TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox["y", TraditionalForm]]],
  StyleBox[" and see if two pairs arise that satisfy these conditions. ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False],

Cell["Answer: ", "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["12.8 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  CellTags->"a:12.21.12"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Adjoin", "Input"],

Cell["?DividesQ", "Input"],

Cell["?Radical", "Input"],

Cell["?ZdDivide", "Input"],

Cell["?ZdAssociatesQ", "Input"],

Cell["?ZdIrreducibleQ", "Input"],

Cell["?FactorInteger", "Input"],

Cell["?GaussianIntegers", "Input"],

Cell["?ZdNorm", "Input"],

Cell["?ImplicitPlot", "Input"],

Cell["?IntegerLatticeGrid", "Input"],

Cell["?ZdUnitQ", "Input"],

Cell["?ZdConjugate", "Input"],

Cell["?ZdDivisors", "Input"],

Cell["?NonTrivialOnly", "Input"],

Cell[BoxData[
    \(\(?IntegerDivisors\)\)], "Input"],

Cell["?ZdPossibleNorms", "Input"],

Cell["?ZdPossibleNormQ", "Input"],

Cell["?Combine", "Input"],

Cell["?Associates", "Input"],

Cell["?Products", "Input"]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
InitializationCellLoading->True,
WindowSize->{627, 427},
WindowMargins->{{7, Automatic}, {Automatic, 6}},
ShowGroupOpenCloseIcon->True,
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:12.12"->{
    Cell[2382, 76, 239, 9, 105, "Title",
      Evaluatable->False,
      CellTags->"a:12.12"]},
  "a:12.13.12"->{
    Cell[2646, 89, 301, 10, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.13.12"]},
  "a:12.14.12"->{
    Cell[6991, 235, 169, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:12.14.12"]},
  "a:12.15.12"->{
    Cell[7475, 256, 161, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:12.15.12"]},
  "a:12.16.12"->{
    Cell[8123, 282, 184, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:12.16.12"]},
  "a:12.17.12"->{
    Cell[22385, 817, 193, 7, 55, "Section",
      Evaluatable->False,
      CellTags->"a:12.17.12"]},
  "a:12.18.12"->{
    Cell[35023, 1301, 296, 11, 65, "Section",
      Evaluatable->False,
      CellTags->"a:12.18.12"]},
  "a:12.19.12"->{
    Cell[49903, 1819, 331, 12, 65, "Section",
      Evaluatable->False,
      CellTags->"a:12.19.12"]},
  "a:12.20.12"->{
    Cell[67684, 2454, 331, 13, 45, "Section",
      Evaluatable->False,
      CellTags->"a:12.20.12"]},
  "a:12.21.12"->{
    Cell[72156, 2632, 348, 13, 35, "Section",
      Evaluatable->False,
      CellTags->"a:12.21.12"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:12.12", 74479, 2727},
  {"a:12.13.12", 74593, 2731},
  {"a:12.14.12", 74712, 2735},
  {"a:12.15.12", 74831, 2739},
  {"a:12.16.12", 74950, 2743},
  {"a:12.17.12", 75069, 2747},
  {"a:12.18.12", 75189, 2751},
  {"a:12.19.12", 75311, 2755},
  {"a:12.20.12", 75433, 2759},
  {"a:12.21.12", 75555, 2763}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 239, 9, 105, "Title",
  Evaluatable->False,
  CellTags->"a:12.12"],

Cell[CellGroupData[{
Cell[2646, 89, 301, 10, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.13.12"],
Cell[2950, 101, 848, 22, 109, "Text",
  Evaluatable->False],
Cell[3801, 125, 1367, 40, 109, "Text",
  Evaluatable->False],
Cell[5171, 167, 149, 3, 33, "Text",
  Evaluatable->False],
Cell[5323, 172, 619, 20, 90, "Text",
  Evaluatable->False],
Cell[5945, 194, 689, 24, 90, "Text",
  Evaluatable->False],
Cell[6637, 220, 317, 10, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[6991, 235, 169, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:12.14.12"],
Cell[7163, 244, 275, 7, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7475, 256, 161, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:12.15.12"],
Cell[7639, 265, 447, 12, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8123, 282, 184, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:12.16.12"],
Cell[8310, 291, 127, 4, 33, "Text",
  Evaluatable->False],
Cell[8440, 297, 145, 3, 43, "Input",
  InitializationCell->True],
Cell[8588, 302, 861, 29, 71, "Text",
  Evaluatable->False],
Cell[9452, 333, 62, 1, 33, "Input"],
Cell[9517, 336, 1250, 41, 86, "Question",
  Evaluatable->False],
Cell[10770, 379, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[10821, 382, 615, 20, 52, "Text",
  Evaluatable->False],
Cell[11439, 404, 3144, 122, 90, "Text",
  Evaluatable->False],
Cell[14586, 528, 3225, 104, 238, "Question",
  Evaluatable->False],
Cell[17814, 634, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[17865, 637, 827, 30, 67, "Question",
  Evaluatable->False],
Cell[18695, 669, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[18746, 672, 892, 31, 73, "Text",
  Evaluatable->False],
Cell[19641, 705, 76, 2, 43, "Input"],
Cell[19720, 709, 46, 1, 27, "Input"],
Cell[19769, 712, 1120, 39, 52, "Text",
  Evaluatable->False],
Cell[20892, 753, 72, 1, 33, "Input"],
Cell[20967, 756, 434, 15, 52, "Text",
  Evaluatable->False],
Cell[21404, 773, 47, 1, 47, "Input"],
Cell[21454, 776, 44, 1, 27, "Input"],
Cell[21501, 779, 583, 20, 52, "Text",
  Evaluatable->False],
Cell[22087, 801, 53, 1, 33, "Input"],
Cell[22143, 804, 205, 8, 33, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[22385, 817, 193, 7, 55, "Section",
  Evaluatable->False,
  CellTags->"a:12.17.12"],
Cell[22581, 826, 2766, 105, 90, "Text",
  Evaluatable->False],
Cell[25350, 933, 516, 18, 86, "Question",
  Evaluatable->False],
Cell[25869, 953, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[25920, 956, 522, 16, 86, "Question",
  Evaluatable->False],
Cell[26445, 974, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[26496, 977, 564, 19, 52, "Text",
  Evaluatable->False],
Cell[27063, 998, 51, 1, 27, "Input"],
Cell[27117, 1001, 70, 1, 33, "Input"],
Cell[27190, 1004, 674, 24, 52, "Text",
  Evaluatable->False],
Cell[27867, 1030, 58, 1, 27, "Input"],
Cell[27928, 1033, 559, 20, 33, "Text",
  Evaluatable->False],
Cell[28490, 1055, 80, 1, 27, "Input"],
Cell[28573, 1058, 1677, 57, 90, "Text",
  Evaluatable->False],
Cell[30253, 1117, 74, 1, 33, "Input"],
Cell[30330, 1120, 221, 4, 43, "Input"],
Cell[30554, 1126, 944, 34, 147, "Text",
  Evaluatable->False],
Cell[31501, 1162, 472, 15, 67, "Question",
  Evaluatable->False],
Cell[31976, 1179, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[32027, 1182, 357, 12, 33, "Text",
  Evaluatable->False],
Cell[32387, 1196, 132, 3, 68, "Input"],
Cell[32522, 1201, 1046, 39, 67, "Question",
  Evaluatable->False],
Cell[33571, 1242, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[33622, 1245, 524, 17, 52, "Text",
  Evaluatable->False],
Cell[34149, 1264, 56, 1, 33, "Input"],
Cell[34208, 1267, 778, 29, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[35023, 1301, 296, 11, 65, "Section",
  Evaluatable->False,
  CellTags->"a:12.18.12"],
Cell[35322, 1314, 1607, 55, 128, "Text",
  Evaluatable->False],
Cell[36932, 1371, 635, 16, 90, "Text",
  Evaluatable->False],
Cell[37570, 1389, 68, 1, 27, "Input"],
Cell[37641, 1392, 91, 1, 33, "Text",
  Evaluatable->False],
Cell[37735, 1395, 220, 5, 66, "Input"],
Cell[37958, 1402, 171, 4, 52, "Text",
  Evaluatable->False],
Cell[38132, 1408, 202, 4, 59, "Input"],
Cell[38337, 1414, 85, 1, 33, "Text",
  Evaluatable->False],
Cell[38425, 1417, 86, 1, 27, "Input"],
Cell[38514, 1420, 565, 21, 52, "Text",
  Evaluatable->False],
Cell[39082, 1443, 519, 14, 90, "Text",
  Evaluatable->False],
Cell[39604, 1459, 285, 6, 69, "Input"],
Cell[39892, 1467, 484, 16, 67, "Question",
  Evaluatable->False],
Cell[40379, 1485, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[40430, 1488, 318, 12, 33, "Text",
  Evaluatable->False],
Cell[40751, 1502, 353, 7, 83, "Input"],
Cell[41107, 1511, 462, 16, 48, "Question",
  Evaluatable->False],
Cell[41572, 1529, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[41623, 1532, 745, 25, 71, "Text",
  Evaluatable->False],
Cell[42371, 1559, 344, 7, 102, "Input"],
Cell[42718, 1568, 210, 4, 52, "Text",
  Evaluatable->False],
Cell[42931, 1574, 286, 5, 75, "Input"],
Cell[43220, 1581, 932, 28, 105, "Question",
  Evaluatable->False],
Cell[44155, 1611, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[44206, 1614, 370, 13, 33, "Text",
  Evaluatable->False],
Cell[44579, 1629, 45, 1, 27, "Input"],
Cell[44627, 1632, 52, 1, 33, "Input"],
Cell[44682, 1635, 244, 9, 33, "Text",
  Evaluatable->False],
Cell[44929, 1646, 59, 1, 33, "Input"],
Cell[44991, 1649, 392, 11, 71, "Text",
  Evaluatable->False],
Cell[45386, 1662, 70, 1, 31, "Input"],
Cell[45459, 1665, 80, 1, 33, "Text",
  Evaluatable->False],
Cell[45542, 1668, 62, 1, 27, "Input"],
Cell[45607, 1671, 666, 20, 71, "Text",
  Evaluatable->False],
Cell[46276, 1693, 675, 16, 170, "Input"],
Cell[46954, 1711, 94, 1, 33, "Text",
  Evaluatable->False],
Cell[47051, 1714, 124, 3, 62, "Input"],
Cell[47178, 1719, 267, 7, 52, "Text",
  Evaluatable->False],
Cell[47448, 1728, 150, 3, 71, "Input"],
Cell[47601, 1733, 181, 6, 33, "Text",
  Evaluatable->False],
Cell[47785, 1741, 566, 13, 148, "Input"],
Cell[48354, 1756, 353, 13, 52, "Text",
  Evaluatable->False],
Cell[48710, 1771, 166, 3, 81, "Input"],
Cell[48879, 1776, 579, 21, 67, "Question",
  Evaluatable->False],
Cell[49461, 1799, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[49512, 1802, 354, 12, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[49903, 1819, 331, 12, 65, "Section",
  Evaluatable->False,
  CellTags->"a:12.19.12"],
Cell[50237, 1833, 118, 4, 33, "Text",
  Evaluatable->False],
Cell[50358, 1839, 147, 5, 96, "Input"],
Cell[50508, 1846, 259, 10, 33, "Text",
  Evaluatable->False],
Cell[50770, 1858, 51, 1, 27, "Input"],
Cell[50824, 1861, 350, 15, 33, "Text",
  Evaluatable->False],
Cell[51177, 1878, 55, 1, 27, "Input"],
Cell[51235, 1881, 91, 1, 33, "Text",
  Evaluatable->False],
Cell[51329, 1884, 84, 1, 27, "Input"],
Cell[51416, 1887, 295, 7, 52, "Text",
  Evaluatable->False],
Cell[51714, 1896, 81, 1, 27, "Input"],
Cell[51798, 1899, 727, 31, 71, "Text",
  Evaluatable->False],
Cell[52528, 1932, 50, 1, 27, "Input"],
Cell[52581, 1935, 1061, 24, 147, "Text",
  Evaluatable->False],
Cell[53645, 1961, 521, 16, 71, "Text",
  Evaluatable->False],
Cell[54169, 1979, 779, 24, 90, "Text",
  Evaluatable->False],
Cell[54951, 2005, 42, 1, 27, "Input"],
Cell[54996, 2008, 1003, 35, 90, "Text",
  Evaluatable->False],
Cell[56002, 2045, 419, 14, 48, "Question",
  Evaluatable->False],
Cell[56424, 2061, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[56475, 2064, 854, 27, 109, "Text",
  Evaluatable->False],
Cell[57332, 2093, 80, 1, 27, "Input"],
Cell[57415, 2096, 663, 20, 71, "Text",
  Evaluatable->False],
Cell[58081, 2118, 59, 1, 27, "Input"],
Cell[58143, 2121, 1838, 63, 128, "Text",
  Evaluatable->False],
Cell[59984, 2186, 89, 1, 27, "Input"],
Cell[60076, 2189, 549, 18, 52, "Text",
  Evaluatable->False],
Cell[60628, 2209, 60, 1, 27, "Input"],
Cell[60691, 2212, 133, 3, 33, "Text",
  Evaluatable->False],
Cell[60827, 2217, 81, 1, 27, "Input"],
Cell[60911, 2220, 477, 18, 52, "Text",
  Evaluatable->False],
Cell[61391, 2240, 284, 9, 52, "Text",
  Evaluatable->False],
Cell[61678, 2251, 198, 4, 56, "Input"],
Cell[61879, 2257, 376, 11, 71, "Text",
  Evaluatable->False],
Cell[62258, 2270, 2297, 77, 162, "Question",
  Evaluatable->False],
Cell[64558, 2349, 48, 1, 47, "Answer",
  Evaluatable->False],
Cell[64609, 2352, 82, 1, 27, "Input"],
Cell[64694, 2355, 951, 27, 109, "Text",
  Evaluatable->False],
Cell[65648, 2384, 113, 2, 49, "Input"],
Cell[65764, 2388, 121, 4, 33, "Text",
  Evaluatable->False],
Cell[65888, 2394, 129, 2, 56, "Input"],
Cell[66020, 2398, 895, 28, 109, "Text",
  Evaluatable->False],
Cell[66918, 2428, 729, 21, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[67684, 2454, 331, 13, 45, "Section",
  Evaluatable->False,
  CellTags->"a:12.20.12"],
Cell[68018, 2469, 863, 22, 109, "Text",
  Evaluatable->False],
Cell[68884, 2493, 201, 8, 33, "Text",
  Evaluatable->False],
Cell[69088, 2503, 43, 1, 27, "Input"],
Cell[69134, 2506, 141, 3, 33, "Text",
  Evaluatable->False],
Cell[69278, 2511, 77, 1, 27, "Input"],
Cell[69358, 2514, 217, 9, 33, "Text",
  Evaluatable->False],
Cell[69578, 2525, 78, 2, 48, "Input"],
Cell[69659, 2529, 137, 6, 33, "Text",
  Evaluatable->False],
Cell[69799, 2537, 49, 1, 27, "Input"],
Cell[69851, 2540, 319, 12, 33, "Text",
  Evaluatable->False],
Cell[70173, 2554, 48, 1, 27, "Input"],
Cell[70224, 2557, 365, 14, 33, "Text",
  Evaluatable->False],
Cell[70592, 2573, 86, 1, 43, "Input"],
Cell[70681, 2576, 90, 1, 33, "Text",
  Evaluatable->False],
Cell[70774, 2579, 115, 2, 27, "Input"],
Cell[70892, 2583, 185, 6, 33, "Text",
  Evaluatable->False],
Cell[71080, 2591, 113, 2, 27, "Input"],
Cell[71196, 2595, 236, 6, 52, "Text",
  Evaluatable->False],
Cell[71435, 2603, 633, 21, 67, "Question",
  Evaluatable->False],
Cell[72071, 2626, 48, 1, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[72156, 2632, 348, 13, 35, "Section",
  Evaluatable->False,
  CellTags->"a:12.21.12"],
Cell[72507, 2647, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[72852, 2658, 24, 0, 27, "Input"],
Cell[72879, 2660, 26, 0, 27, "Input"],
Cell[72908, 2662, 25, 0, 27, "Input"],
Cell[72936, 2664, 26, 0, 27, "Input"],
Cell[72965, 2666, 31, 0, 27, "Input"],
Cell[72999, 2668, 32, 0, 27, "Input"],
Cell[73034, 2670, 31, 0, 27, "Input"],
Cell[73068, 2672, 34, 0, 27, "Input"],
Cell[73105, 2674, 24, 0, 27, "Input"],
Cell[73132, 2676, 30, 0, 27, "Input"],
Cell[73165, 2678, 36, 0, 27, "Input"],
Cell[73204, 2680, 25, 0, 27, "Input"],
Cell[73232, 2682, 29, 0, 27, "Input"],
Cell[73264, 2684, 28, 0, 27, "Input"],
Cell[73295, 2686, 32, 0, 27, "Input"],
Cell[73330, 2688, 53, 1, 27, "Input"],
Cell[73386, 2691, 33, 0, 27, "Input"],
Cell[73422, 2693, 33, 0, 27, "Input"],
Cell[73458, 2695, 25, 0, 27, "Input"],
Cell[73486, 2697, 28, 0, 27, "Input"],
Cell[73517, 2699, 26, 0, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

