(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

(* :Title:  AbstractAlgebra`Ringoids *)

(* :Context: AbstractAlgebra`Ringoids` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)



incomingStructure = DefaultStructure;

BeginPackage["AbstractAlgebra`Ringoids`",
{"AbstractAlgebra`Core`",
"Graphics`Graphics`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];

Off[AppendTo::rvalue];

BooleanRing::usage = "BooleanRing[n] constructs the Boolean Ring
consisting of the set of subsets of {1, 2, ..., n} with the operations
symmetric difference and intersection. BooleanRing[B] constructs the
ring with subsets of the list B.";

FormRingoidByTable::usage = "FormRingoidByTable[list, additiontab,
multiplicationtab, opts] is a command for generating a Ringoid
consisting of the elements in list and governed by the operations
implicit in the Cayley tables additiontab and multiplicationtab. The
options for opts can be: WideElements, IsARing, RingoidDescription,
RingoidName, FormatOperator, FormatElements, MaxElementsToList, KeyForm,
and CayleyForm. See each of these individually for more information.";

LatticeRing::usage = "LatticeRing[n] returns the Ringoid of divisors of
n with LCM/GCD for addition and GCD for multiplication.";

TrivialZR::usage = "TrivialZR[n] returns the ring of integers mod n with
mod n addition but a multiplication with all products being zero.";

(* Dot::DimErr="Dimensions of parameters to Dot fail to match.";*)

FormRingoid::diffels = "In forming a Ringoid in this fashion, the list
of elements in the first Groupoid, `1`, must match those in the second
Groupoid, `2`.";

FormRingoid::size = "The index for this structure needs to be less than `1`,
which `2` is not.";

Begin["`Private`"];

GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]

FormRingoid[G1_?GroupoidQ, G2_?GroupoidQ, opts___?OptionQ] :=
	If[SameSetQ[Elements[G1], Elements[G2]],
		FormRingoid[Elements[G1], Operation[G1], Operation[G2], 
			opts],
		Message[FormRingoid::diffels, Elements[G1], Elements[G2]]]

FormRingoidByTable[list_List,additiontab_List, multiplicationtab_List,
		opsymbols_List:{"+","*"}, opts___?OptionQ] :=
	Module[{R,wideq,ringq,genset,rngdesc,rngnm,optional,formop,
	formels,maxshow,keyForm,cayleyForm, ei, add, mult},
		wideq = WideElements/.Flatten[{opts, Options[FormRingoid]}];
		ei = AbstractAlgebra`Core`Private`ExtraInformation/.Flatten[{opts, 
			Options[AbstractAlgebra`Core`Private`FormRingoidExtra]}];
		ringq = IsARing/.Flatten[{opts, Options[FormRingoid]}];
		rngdesc = RingoidDescription/.Flatten[{opts, Options[FormRingoid]}];
		rngnm = RingoidName/.Flatten[{opts, Options[FormRingoid]}];
		formop = FormatOperator/.Flatten[{opts, Options[FormRingoid]}];
		keyForm = KeyForm/.Flatten[{opts, Options[FormRingoid]}];
		cayleyForm = CayleyForm/.Flatten[{opts, Options[FormRingoid]}];
		formels = FormatElements/.Flatten[{opts, Options[FormRingoid]}];
		maxshow = MaxElementsToList/.Flatten[{opts, Options[FormRingoid]}];
		add = (additiontab[[#1//Position[list,#]&//First,
    	#2//Position[list,#]&//First]]//Flatten//First)&;
    mult = (multiplicationtab[[#1//Position[list,#]&//First,
			#2//Position[list,#]&//First]]//Flatten//First)&;
		AppendTo[ei, {opts}];
		R = AbstractAlgebra`Core`Private`ringoid[list, add, mult, ei];
		AbstractAlgebra`Core`Private`FormatOpQ[R] = formop;
		AbstractAlgebra`Core`Private`FormatElsQ[R] = If[Length[list] > maxshow, True, formels];
		AbstractAlgebra`Core`Private`WideElementsQ[R] = wideq;
		KeyForm[R] = keyForm;
		CayleyForm[R] = cayleyForm;
		If[ringq,ringQ[R] = ringq];
		RingoidDescription[R] = rngdesc;
		RingoidName[R] = If[rngnm === "", "TheRing", rngnm];
		If[AbstractAlgebra`Core`Private`untestedQ[RingInfo[R]],
			RingInfo[R] = {};
			If[rngnm =!= "", AppendTo[RingInfo[R],rngnm]];
			If[rngdesc =!= "", AppendTo[RingInfo[R],rngdesc]];
			];
		(* start tracking info about groupoid if not yet started *)
		PlusSymbol[R] = opsymbols[[1]];
		TimesSymbol[R] = opsymbols[[2]];
		R]
(* note that the R created is a ringoid not Ringoid *)

Options[TrivialZR] = {};

TrivialZR[n_/;(n >= 2)] := TrivialZR[n] = Module[{R},
	R = FormRingoid[Range[0, n-1], Mod[#1 + #2,n]&, 0&, {"+","0"},
		RingoidName -> "Trivial["<>ToString[n]<>"]", RingoidDescription -> 
		"the trivial Ring mod "<>ToString[n]];
	R]

BooleanRing[n_Integer?NonNegative/;n<=6] := BooleanRing[n]=
   FormRingoid[Range[2^n,2^(n+1)-1]//
          Map[IntegerDigits[#,2]&,#]&//
          Map[Rest,#]&//
          Map[(Range[1,n]*#)&,#]&//
          Map[Select[#,(#>0)&]&,#]&,
          Union[Complement[#1,#2],Complement[#2,#1]]&,
          Intersection[#1,#2]&,
          RingoidName -> "Bool["<>ToString[n]<>"]",
          RingoidDescription -> "the boolean Ring on {1,...,"<>ToString[n]<>"}",
          WideElements->True]

BooleanRing[n_Integer?NonNegative] := (Message[FormRingoid::size, 7, n]; $Failed)

BooleanRing[B_List] := BooleanRing[B] =
				FormRingoid[Elements[BooleanRing[Length[B]]//
           MapAt[(#/.Inner[Rule,Range[1,Length[B]],Sort[B],List])&,
                  #,1]&],
           Union[Complement[#1,#2],Complement[#2,#1]]&,
          Intersection[#1,#2]&,
          RingoidName -> "Bool["<>ToString[B]<>"]",
          RingoidDescription -> "Boolean Ring on "<>ToString[Sort[B]],
          WideElements->True]      
                      
LatticeRing[n_/;(n>=2)] := FormRingoid[Divisors[n],
	(LCM[#1,#2]/GCD[#1,#2])&, GCD[#1,#2]&, RingoidName -> 
	"Lattice["<>ToString[n]<>"]", RingoidDescription -> 
	"the lattice Ring of divisors of "<>ToString[n]];

End[];

EndPackage[];

DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];