(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8524,        242]*)
(*NotebookOutlinePosition[     10606,        308]*)
(*  CellTagsIndexPosition[     10535,        302]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Editable->True,
  Deletable->True,
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[StyleBox["PLEASE READ",
  FontSize->18]], "Title",
  Editable->True,
  Deletable->True,
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.1"],

Cell["\<\
This document gives instructions on how to place the files for your \
system.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Version 2.2 Windows users:", "Section"],

Cell["\<\
Copy the directory entitled Abstract into the Packages directory of \
Mathematica 2.2. The GrpLabs directory contains all of the group labs and can \
be placed where convenient; the labs have initialization cells that will \
locate the necessary packages. Similarly, place the RngLabs directory in a \
convenient location. You are strongly encouraged to consider version 3.0 or \
higher. This will give access to palettes and documentation in the Help \
Browser.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Version 2.2 Macintosh and other Notebook interface users:", "Section"],

Cell["\<\
Copy the directory entitled AbstractAlgebra into the Packages \
directory of Mathematica 2.2. The GroupLabs directory contains all of the \
group labs and can be placed where convenient; the labs have initialization \
cells that will locate the necessary packages. Similarly, place the RingLabs \
directory in a convenient location. You are strongly encouraged to consider \
version 3.0 or higher. This will give access to palettes and documentation in \
the Help Browser.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Version 3.0 and higher users:", "Section"],

Cell[TextData[{
  "From the CD, or from the web site (http://www.central.edu/eaam.html), find \
the files appropriate for version 3.0 or higher. Note that these files work \
equally well on Macintosh, Unix or Windows platforms. The files are located \
on the CD in such a way to imitate the layout of the main ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory. Here is a schematic of what is on the CD and on the web page \
(except the CD uses initial lower-case directory names to avoid an accidental \
overwrite). Note that the AddOns and Configuration directories are inside the \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3.0 Files directory.\n\nAddOns \n    Applications \n        \
AbstractAlgebra \n            package files (.m files) \n            \
Documentation \n                English \n                    documentation \
files \n            GroupLabs \n                group lab notebooks from EAAM \
\n            Kernel \n                init.m (Master.m copied here and \
renamed to init.m) \n            Palettes \n                palette files \
from EAAM \n                palette files for general distribution \n         \
   RingLabs  \n                ring lab notebooks from EAAM \nConfiguration \n\
    FrontEnd \n        StyleSheets \n            EAAM.nb (needed if labs \
moved from the AbstractAlgebra) \n        Palettes \n            \
AbstractAlgebraPalette.nb (can also be found via the Help Browser) \n         \
   \nOne can simply place the entire AbstractAlgebra directory into the \
AddOns/Application directory and begin. Optionally, it may be convenient to \
copy the AbstractAlgebraPalette.nb and EAAM.nb files to the specified \
locations, particularly if you will be moving the labs to another location. \
Upon opening Mathematica, choose Rebuild Help Index from the Help menu; this \
will enable the Help Browser (via the AddOns button) to be aware of the help \
files accompanying AbstractAlgebra."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Parting words", "Section"],

Cell[TextData[{
  "If you have any problem with installation, first double-check the \
instructions given and study the directory schematic. If you still have \
problems, contact us by giving all relevant details and error messages.\n\n\
Thank you for your interest in ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  ". We are continuing to provide additional features in both the packages \
and in terms of palettes, as well as providing a number of other resources \
available on our web site. Please contact this for updates and additional \
information. This site is ",
  StyleBox["at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  " and is also mirrored at",
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text"],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{628, 433},
WindowMargins->{{74, Automatic}, {44, Automatic}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 1 Using symmetry to uncover a group", FontSlant -> "Italic"], 
          "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@BbcP000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:1.1"->{
    Cell[2341, 74, 170, 6, 69, "Title",
      Evaluatable->False,
      CellTags->"a:1.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:1.1", 10417, 294}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 607, 21, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2341, 74, 170, 6, 69, "Title",
  Evaluatable->False,
  CellTags->"a:1.1"],
Cell[2514, 82, 101, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[2640, 89, 45, 0, 55, "Section"],
Cell[2688, 91, 486, 8, 109, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[3211, 104, 76, 0, 35, "Section"],
Cell[3290, 106, 496, 8, 109, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[3823, 119, 48, 0, 35, "Section"],
Cell[3874, 121, 1993, 31, 698, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[5904, 157, 32, 0, 35, "Section"],
Cell[5939, 159, 1191, 29, 185, "Text"],
Cell[7133, 190, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[7781, 213, 715, 25, 90, "Text",
  Evaluatable->False]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

