(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`GroupProperties` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 0. Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`GroupProperties *)

(* :Context: AbstractAlgebra`GroupProperties` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 1. Startup AbstractAlgebra`GroupProperties
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`GroupProperties`",
	{"AbstractAlgebra`Core`", "Graphics`Graphics`","Utilities`FilterOptions`",
	"Graphics`Colors`"}];

Off[General::spell,General::spell1];
SetOptions[Graphics,AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2. Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
Center::usage = "Center[G] returns the center of the group G. This is
identical to GroupCenter. The standard (built-in) usage still exists:
Center is used to specify alignment in printforms such as ColumnForm and
TableForm.";

Centralizer::usage = "Centralizer[G, g] returns the centralizer of g in
the group G. Centralizer[G, H] returns the centralizer of the subgroup H
in the group G.";

Commutator::usage = "Commutator[G, x, y] returns the commutator
xyx^(-1)y^(-1) in the Groupoid G.";

Commutators::usage = "Commutators[G] returns the complete set of
commutators in the Groupoid G.";

CommutatorSubgroup::usage = "CommutatorSubgroup[G] returns the
commutator subgroup of the Groupoid G generated by the commutators of
G.";

ConjugacyClass::usage = "ConjugacyClass[G, h] returns the conjugacy
class of the element h in G.";

Conjugate::usage = "Conjugate[G, h, x] returns the element x h x^(-1) in
the Groupoid G. Additionally, Conjugate[G, H, x] returns the set x H
x^(-1) for the subgroup H of the group G. The standard (built-in) usage
still exists: Conjugate[z] gives the complex conjugate of the complex
number z. (Note that Listable has been turned off.)";

CyclicGenerators::usage = "CyclicGenerators[G] returns a list of
elements that are generators for the cyclic group G.";

CyclicQ::usage = "CyclicQ[G] returns True if the Groupoid G is cyclic,
and False otherwise.";

CyclicSubgroups::usage = "CyclicSubgroups[G] returns a list of subgroups
of the group G which are cyclic.";

ElementConjugate::usage = "ElementConjugate[G, h, x] returns the element
x h x^(-1) in the Groupoid G.";

EqualGroupoidQ::usage = "EqualGroupoidQ[G1, G2] returns True if G1 and G2
can be considered equal as groupoids, and False otherwise.";

GroupCenter::usage = "GroupCenter[G] returns the center of the group G.
This is identical to Center.";

GroupExponent::usage = "GroupExponent[G] returns the smallest positive
integer n such that g^n is the identity for all elements g in the
Groupoid G.";

Normalizer::usage = "Normalizer[G, H] returns the normalizer of the
subgroup H in G.";

OrderOfAllElements::usage = "OrderOfAllElements[G] returns a list of the
orders of each element in the Groupoid G in the form {element, order}.";

OrderOfElement::usage = "OrderOfElement[G, g] returns the order of the
element g in the Groupoid G.";

Orders::usage = "Orders[G] returns a list of the
orders of each element in the Groupoid G in the form {element, order}.
Orders[G, list] works similarly, where list is a list of elements from
the Groupoid G.";

SubgroupConjugate::usage = "SubgroupConjugate[G, H, x] returns the set x
H x^(-1) for the subgroup H of the Groupoid G.";

SubgroupIntersection::usage = "SubgroupIntersection[G, H, K] returns the
subGroupoid of G which is the intersection of subgroups H and K.";

SubgroupJoin::usage = "SubgroupJoin[G, H, K] returns the subGroupoid of
G generated by the elements in the subgroups H and K.";

Subgroupoid::usage = "Subgroupoid[G, H] creates the Groupoid with the
elements from the list H (assumed to be elements from G) and the
operation from the Groupoid G. Subgroupoid[G,{H1, H2}] or
Subgroupoid[{G, H1}, {G, H2}] can be used if there are 2 (or more)
subsets H.";

SubgroupProduct::usage = "SubgroupProduct[G, H, K] returns the
subGroupoid (of G) HK = {hk | h in H, k in K} for subgroups H and K.";

Subgroups::usage = "Subgroups[G] returns a list of all the subgroups of
the group G. Warning: this may take a long time for high order
(non-cyclic) groups!";

SubgroupUnion::usage = "SubgroupUnion[G, H, K] returns the subGroupoid
of G which is the union of subgroups H and K.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.4 Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)

Group::notcyclic = "The group `1` is not a cyclic group.";

Groupoid::fail = "In applying this function, it has to act on a
Groupoid. Check to be sure `1` has been properly formed using
FormGroupoid or GenerateGroupoid.";

Conjugate::fail = "For ElementConjugate, both `1` and `2` need to
be elements of the group, while for SubgroupConjugate `1` needs to
be a subgroup and `2` an element.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.5 Begin private section
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 16. Constructing groupoids
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
16.1
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 21. Working with elements
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
21.4 GroupExponent of a group
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Options[GroupExponent] = {Mode -> Computational};

GroupExponent[G_?GroupoidQ, opts___?OptionQ] := 
		Module[{id,tocheck = Elements[G],n,max=1,maxord=1,
		pow,tmp,powers = {1},mymode,sc,exp},
	mymode = Mode/.Flatten[{opts, Options[GroupExponent]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	id = GroupIdentity[G];
	maxord = 1;
	max = Length[tmp=tocheck];
	tocheck = Complement[tocheck,{id}];
	n = Length[tocheck];
	While[max > maxord && n > 0, 
		pow = 2;
		While[ElementToPower[G,First[tocheck],pow] =!= id,
			pow ++];
		maxord = Max[maxord, pow];
		AppendTo[powers, pow];
		tocheck = Rest[tocheck];
		n --;
	];
	maxord = Apply[LCM,Union[powers]];
	If[{id} === Union[Table[ElementToPower[G,tmp[[i]],maxord],
		{i,Length[tmp]}]],exp = maxord,Print["HELP"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",GroupExponent,
		mymode,exp, {Null}, {G,exp,opts},{Null},{Null},sc]
]

Options[GroupExponentVisual]={DisplayFunction -> $DisplayFunction};
			
GroupExponentVisual[G_, exp_, opts___] := 
	Module[{n,ords,colors,subgroups,
		els = Elements[G],f, subrules,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[GroupExponentVisual]}]},
	n = Length[els];
	subgroups = Map[Elements[AbstractAlgebra`Joint`SubgroupGenerated[G,#]]&,els];
	subrules = If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		Map[Reverse,AbstractAlgebra`Core`Private`MakeSubstitutionRules[G,els,"g"]],
		Table[Rule[els[[i]],els[[i]]],{i,n}]];
	f[el_,{x_,y_}] := 
		{BackgroundColors[[Position[els,el,1]//Flatten//First]],
		Rectangle[{x, y}, {x+1, y+1}],Black,Text[ToString[el/.subrules], 
		{x+.5,y+.5}]};
	ords = Map[Length,subgroups];
	subgroups = Map[Flatten[Table[#,{exp/Length[#]}],1]&,subgroups];
	rects = MapIndexed[f,subgroups,{2}];
	lines = Join[Table[Line[{{i,1},{i,exp+1}}],{i,n+1}],
		Table[Line[{{1,i},{n+1,i}}],{i,exp+1}]];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[els,
		AbstractAlgebra`Core`Private`StructureName[G],G, KeyForm[G]]];
	Show[Graphics[{rects,lines,Table[Text[i,{.5,.5+i}],{i,1,exp}],
		Table[Text[els[[i]]/.subrules,{.5+i,.5}],{i,1,n}],
		Text["elements",{(n+2)/2,0}],
		Text["powers",{0,(exp+2)/2},{-1,0},{0,-1}]}],
		showopts, DisplayFunction -> df]
]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 30. Subgroups
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.1 Subgroupoid
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[Subgroupoid]={Mode -> Computational};

Subgroupoid[G_?GroupoidQ, many:{_List..}] := Map[Subgroupoid[G,#]&, 
	many]/; Apply[And,Map[SubsetQ[#, Elements[G]]&,many]]

Subgroupoid[G_?GroupoidQ, many:{_List..}, Mode -> mode_] := 
		AbstractAlgebra`Core`Private`handleSimple2Multiple[Subgroupoid,G,many,mode,
			{}] /; Apply[And,Map[SubsetQ[#,Elements[G]]&,many]]

Subgroupoid[G_?GroupoidQ, H_List, opts___?OptionQ] := 
	If[SubsetQ[H, Elements[G]],
		If[ProperSubsetQ[H,Elements[G]],
		Module[{mymode,sub,Hoid,sc},
	mymode = Mode/.Flatten[{opts, Options[Subgroupoid]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	(*sub = SubgroupQ[H,G];*)
	Hoid = FormGroupoid[H, Operation[G],OperatorSymbol[G],
		AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",Subgroupoid,mymode,Hoid,{G,H},
			{G,H,opts},{G,H,sub,opts},{Null},sc]], G],
	Message[MemberQ::elmnts, H, AbstractAlgebra`Core`Private`StructureName[G]]; $Failed] 
	
Subgroupoid[G_?GroupoidQ,many:{_List..}] :=
	Subgroupoid[G,many, Mode -> (Mode/.Options[Subgroupoid])
	](*/; Apply[And,Map[SubsetQ[#,Elements[G]]&,many]]*)
	
Subgroupoid[G_?GroupoidQ,many:{_List..},Mode -> mode_] := 
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
		AbstractAlgebra`Core`Private`handleSimple2Multiple[Subgroupoid,G,many,mode,
			{}] (*/; Apply[And,Map[SubsetQ[#,Elements[G]]&,many]]*))

Subgroupoid[many:{_List..}] :=
	Subgroupoid[many, Mode -> (Mode/.Options[Subgroupoid])]
		
Subgroupoid[many:{_List..},Mode -> mode_] :=
	AbstractAlgebra`Core`Private`handlePairedMultiple[Subgroupoid,Map[First,many],
		Map[Rest,many], mode]
	
SubgroupoidVisual[G_,H_,opts___] := AbstractAlgebra`Core`Private`SubgroupQVisual[G,H,opts]

SubgroupoidVisual2[G_,H_,sub_,opts___] := AbstractAlgebra`Core`Private`SubgroupQVisual2[G,H,sub,opts]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.3 Subgroup intersection
:[font = input; initialization; preserveAspect; endGroup]
*)
(* add Textual and Visual - for the latter consider two calls
to SubgroupQVisual (each subgroup) and then one for the 
intersection also *)

SubgroupIntersection[G_?GroupoidQ, H_?GroupoidQ, K_?GroupoidQ] :=
	If[Operation[G] === Operation[H] === Operation[K],
		SubgroupIntersection[G, Elements[H], Elements[K]],
		Message[Operation::fail]; $Failed]

SubgroupIntersection[G_?GroupoidQ, H_List, K_List] := 
		Module[{op = Operation[G], ok = True, els = Elements[G], new =
			Intersection[H, K]},
	If[SubsetQ[H,els], ok = True, 
		ok = False;
		Message[MemberQ::elmnts, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubsetQ[K,els], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::elmnts, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[H,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[K,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[ok,
		If[ProperSubsetQ[new,els],
			FormGroupoid[new, op, OperatorSymbol[G], 
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G], $Failed]];

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.4 Subgroup union
:[font = input; initialization; preserveAspect; endGroup]
*)
SubgroupUnion[G_?GroupoidQ, H_?GroupoidQ, K_?GroupoidQ] :=
	If[Operation[G] === Operation[H] === Operation[K],
		SubgroupUnion[G, Elements[H], Elements[K]],
		Message[Operation::fail]; $Failed]
		
SubgroupUnion[G_?GroupoidQ, H_List, K_List] := 
		Module[{op = Operation[G], ok = True, els = Elements[G], new = Union[H,K]},
	If[SubsetQ[H,els], ok = True, 
		ok = False;
		Message[MemberQ::elmnts, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubsetQ[K,els], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::elmnts, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[H,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[K,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[ok,
		If[ProperSubsetQ[new,els],
			FormGroupoid[new, op, OperatorSymbol[G], 
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G], $Failed]];

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.5 Subgroup product
:[font = input; initialization; preserveAspect; endGroup]
*)
SubgroupProduct[G_?GroupoidQ, H_?GroupoidQ, K_?GroupoidQ] :=
	If[Operation[G] === Operation[H] === Operation[K],
		SubgroupProduct[G, Elements[H], Elements[K]],
		Message[Operation::fail]; $Failed]

SubgroupProduct[G_?GroupoidQ, H_List, K_List] := 
		Module[{op = Operation[G], ok = True, els = Elements[G], new},
	new = Union[CloseSets[H,K,op]];
	If[SubsetQ[H,els], ok = True, 
		ok = False;
		Message[MemberQ::elmnts, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubsetQ[K,els], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::elmnts, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[H,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[K,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[ok,
		If[ProperSubsetQ[new,els],
			FormGroupoid[new, op, OperatorSymbol[G], 
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G], $Failed]];
		
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.7 Subgroup join
:[font = input; initialization; preserveAspect; endGroup]
*)
SubgroupJoin[G_?GroupoidQ, H_?GroupoidQ, K_?GroupoidQ] :=
	If[Operation[G] === Operation[H] === Operation[K],
		SubgroupJoin[G, Elements[H], Elements[K]],
		Message[Operation::fail]; $Failed]

SubgroupJoin[G_?GroupoidQ, H_List, K_List] := 
		Module[{op = Operation[G], ok = True, els = Elements[G], new, 
			old = AbstractAlgebra`Core`Private`GatherGroupoidOptions[G]},
	If[SubsetQ[H,els], ok = True, 
		ok = False;
		Message[MemberQ::elmnts, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubsetQ[K,els], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::elmnts, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[H,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, H, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[SubgroupQ[K,G], ok = ok && True, 
		ok = ok && False;
		Message[MemberQ::sbgrp, K, AbstractAlgebra`Core`Private`StructureName[G]]];
	If[ok,
		new = GenerateGroupoid[Join[H, K],Operation[G]];
		If[ProperSubsetQ[Elements[new],els],
			FormGroupoid[Elements[new], op, OperatorSymbol[G], 
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			FormGroupoid[Elements[new], op, OperatorSymbol[G], old]], $Failed]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.8 Subgroups
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Subgroups[G_?CyclicQ] := Module[{n = Size[G], orders, g, subs},
	orders = Complement[Divisors[n], {1,n}];
	g = First[CyclicGenerators[G]];
	subs = Map[FormGroupoid[#, Operation[G], OperatorSymbol[G], 
		AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]]&,
		Map[Sort, Prepend[Map[Elements@AbstractAlgebra`Joint`SubgroupGenerated[G,
			ElementToPower[G, g, #]]&,
		orders], {GroupIdentity[G]}]]];
	Append[subs, G]]
	
Subgroups[G_?GroupoidQ] := 
		Module[{els=Elements[G],Hsets,subgroups,divs,id,lengths,n},
	id = GroupIdentity[G];
	els = Complement[els,{id}];
	n = Length[els] + 1;
	lengths = Complement[Divisors[n],{1,n}]-1; (* account for missing identity *)
	Hsets = Flatten[Table[KSubsets[els,lengths[[i]]],{i,Length[lengths]}],1];
	Hsets = Map[Join[#,{id}]&,Hsets];
	subgroups = Select[Hsets,SubgroupQ[#,G]&];
	subgroups = Select[subgroups,Length[#] < Size[G]&];
	Append[Map[FormGroupoid[#, Operation[G], OperatorSymbol[G], 
		AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]]&,
		Prepend[Map[Sort,subgroups],{id}]], G]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 32. Order of an Element
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[OrderOfElement]={Mode -> Computational};

FilterArgument[func_, G_?GroupoidQ, arg_] :=
	If[ElementQ[arg, G], func[G, arg],
		If[Head[arg] === List && ElementsQ[arg, G], Map[func[G, #]&, arg],
			Message[MemberQ::elsbst, arg, AbstractAlgebra`Core`Private`StructureName[G]]; $Failed]]

FilterArgument[func_, G_?GroupoidQ, arg_, Mode -> mode_] :=
	If[ElementQ[arg,G], func[G, arg, Mode -> mode],
		If[Head[arg] === List && ElementsQ[arg, G],
			AbstractAlgebra`Core`Private`handleSimple2Multiple[func,G,arg,mode,{}],
			Message[MemberQ::elsbst, arg, AbstractAlgebra`Core`Private`StructureName[G]]; $Failed]]
	
FilterArgument[func_, G_?GroupoidQ, arg_, opts__?OptionQ] :=
	If[ElementQ[arg, G], func[G, arg, opts],
		If[Head[arg] === List && ElementsQ[arg, G], 
			Map[func[G, #]&, arg, opts],
			Message[MemberQ::elsbst, arg, AbstractAlgebra`Core`Private`StructureName[G]]; $Failed]]
	
OrderOfElement[G_?GroupoidQ, g_] := OrderOfElement[G, g] = 
	FilterArgument[OrderOfElementWk, G, g]
	
OrderOfElementWk[G_?GroupoidQ, g_] :=  Module[{id, ord},
	If[Not[ElementQ[g,G]],
		Message[MemberQ::elmnt, g, AbstractAlgebra`Core`Private`StructureName[G]];$Failed,
		If[AbstractAlgebra`Joint`Private`ClosedQAndIdentityQ[G],
			id = GroupIdentity[G];
			ord=Length[Elements[G]];
			If[g===id, 1,
				Length[FixedPointList[Operation[G][g,#]&,g,ord,
 					SameTest ->((#2===id)&)]]//If[#==ord+1,$Failed,#]&], $Failed]]]

OrderOfElement[G_?GroupoidQ, g_, opts__?OptionQ] := 
	FilterArgument[OrderOfElementWk, G, g, opts]
	
OrderOfElementWk[G_?GroupoidQ,g_,opts___?OptionQ] := 
		Module[{mymode,sc},
	mymode = Mode/.Flatten[{opts, Options[OrderOfElement]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",
		OrderOfElement,mymode,OrderOfElement[G,g],{G,g},
			{G,g,opts},{Null},{Null},sc]]
	
OrderOfElement[G_?GroupoidQ,many_List]/; SubsetQ[many,Elements[G]] :=
	Map[OrderOfElement[G,#]&, many] 
	
OrderOfElement[G_?GroupoidQ, many_List, Mode -> mode_] := 
		AbstractAlgebra`Core`Private`handleSimple2Multiple[OrderOfElement,G,many,mode,
			{}] /; SubsetQ[many,Elements[G]]

OrderOfElement[many:{_List..}] :=
	OrderOfElement[many, Mode -> 
		(Mode/.Options[OrderOfElement])]
		
OrderOfElement[many:{_List..},Mode -> mode_] :=
	AbstractAlgebra`Core`Private`handlePairedMultiple[OrderOfElement,Map[First,many],
		Map[Rest,many], mode]
		
OrderOfElement[G_?GroupoidQ,g_,opts___?OptionQ]/; !MemberQ[Elements[G],g] := 
		(Message[MemberQ::elmnt,g,AbstractAlgebra`Core`Private`StructureName[G]]; $Failed)
		
OrderOfElement[G_?GroupoidQ,g_,opts___?OptionQ]/; !MemberQ[Elements[G],g] :=
	(Message[MemberQ::elmnt,g,AbstractAlgebra`Core`Private`StructureName[G]]; $Failed)
	
OrderOfElement[G_,g_,opts___?OptionQ] :=
	(Message[Groupoid::fail,AbstractAlgebra`Core`Private`StructureName[G]]; $Failed)

OrderOfElementTextual[G_,g_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, OrderOfElementTextualGD[G]; OrderOfElementTextualLI[G,g],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			OrderOfElementTextualGD[G]; OrderOfElementTextualLI[G,g];AbstractAlgebra`Core`Private`firstPassQ = False,
			OrderOfElementTextualLI[G,g]]]

OrderOfElementTextualGD[_] := Print["Given an element g in a Groupoid G, the order
	of the element is the minimum (positive) integer n such that g^n (repeated use of
	group operation) is the identity element."<>If[$VersionNumber < 3, "\n"," "]]

OrderOfElementTextualLI[G_,g_] := (Print[StringJoin["In this case,
	the order of ",ToString[g]," is ",ToString[OrderOfElement[G,g]],
	". The table below shows the increasing powers (multiples) until the identity is reached. (Form
	is {n, g^n}.)",If[$VersionNumber < 3, "\n"," "]]];
	Print[ToString[Transpose[{Range[1,OrderOfElement[G,g]],
		AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[g,G]}]]<>
		If[$VersionNumber < 3, "\n"," "]];)

Options[OrderOfElementVisual]={DisplayFunction -> $DisplayFunction};

OrderOfElementVisual[G_,g_,opts___] :=
	With[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[OrderOfElementVisual]}]},
	Show[AbstractAlgebra`Joint`Private`SubgroupGeneratedVisual2[G,g, 
		DisplayFunction -> Identity],showopts,
		DisplayFunction -> df]]

Unprotect[Order];

AbstractAlgebra`Core`Private`groupoid /:
	Order[G_AbstractAlgebra`Core`Private`groupoid, g_, 
	opts___?OptionQ] := OrderOfElement[G, g, opts];
	
Order[many_?MatrixQ, opts___?OptionQ] := OrderOfElement[many,opts];

Protect[Order];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 33. Order of all Elements
:[font = input; initialization; preserveAspect; endGroup]
*)
Orders[G_?GroupoidQ, opts___?OptionQ] := OrderOfAllElements[G, opts]

Orders[many:{_?GroupoidQ..}, opts___?OptionQ] :=
	OrderOfAllElements[many, opts]

Orders[G_?GroupoidQ, many_, opts___?OptionQ] :=
	If[SubsetQ[many,Elements[G]], 
		Transpose[{many, OrderOfElement[G, many, opts]}],
		If[ElementQ[many, G], 
			{many, OrderOfElement[G, many, opts]},
			$Failed]]
			
Orders[many:{_List..}] :=
	Map[Orders, many]
		
Orders[many:{_List..},Mode -> Textual] :=
	Map[Orders[#,,Mode -> Textual]&, many]

Orders[many:{_List..},Mode -> mode_] :=
	AbstractAlgebra`Core`Private`handlePairedMultiple[OrderOfElement,Map[First,many],
		Map[Rest,many], mode]

Options[OrderOfAllElements]={Mode -> Computational};

OrderOfAllElements[G_?GroupoidQ] := OrderOfAllElements[G] = 
	Transpose[{Elements[G],
		Map[Length[AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[#,G]]&,
			Elements[G]]}]

OrderOfAllElements[G_?GroupoidQ, opts___?OptionQ] := Module[{mymode,
		orders,sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[OrderOfAllElements]}];
	orders = OrderOfAllElements[G];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",
		OrderOfAllElements,mymode,orders,{G,orders},
			{G,opts},{G,opts},{Null},sc]]

OrderOfAllElements[many:{_?GroupoidQ..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[OrderOfAllElements, many, mode])
		
OrderOfAllElements[many:{_?GroupoidQ..}] :=
	OrderOfAllElements[many, Mode -> (Mode/.Options[OrderOfAllElements])]
	
OrderOfAllElementsComputational[G_] := (
	Transpose[{Elements[G],
		Map[Length[AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[#,G]]&,
			Elements[G]]}])

OrderOfAllElementsTextual[G_,orders_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, OrderOfAllElementsTextualGD[G];
		OrderOfAllElementsTextualLI[G,orders],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			OrderOfAllElementsTextualGD[G]; 
			OrderOfAllElementsTextualLI[G,orders];AbstractAlgebra`Core`Private`firstPassQ = False,
			OrderOfAllElementsTextualLI[G,orders]]]

OrderOfAllElementsTextualGD[_] := Print["Given a Groupoid G, we can consider the order
	of all the elements in the group. See 'OrderOfElement' for
	details about this. The table below illustrates each element
	and its order."<>If[$VersionNumber > 2.5,"","\n"]]

OrderOfAllElementsTextualLI[G_,orders_] := (Print[TableForm[
		orders,	(*TableAlignments->{Bottom, Center},*)
		TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0],3}, TableDepth -> 2,
		TableHeadings->{None,{"element",
			If[$VersionNumber > 2.5, "order\n","order\n"]}}]];
		If[$VersionNumber < 3, Print[" "]];)

Options[OrderOfAllElementsVisual]={DisplayFunction -> $DisplayFunction};

OrderOfAllElementsVisual[G_,opts___] := Module[{
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[OrderOfAllElementsVisual]}]},
	Show[CyclicSubgroups[G,Mode -> Visual, DisplayFunction -> 
		Identity, Output -> Graphics],
		showopts,DisplayFunction -> df]]

Options[OrderOfAllElementsVisual2]={DisplayFunction -> $DisplayFunction};

OrderOfAllElementsVisual2[G_,opts___] := Module[{len,gr,
		i, ga,El = Elements[G],
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[OrderOfAllElementsVisual2]}]},
	len = Length[El];
	Do[gr[i] = OrderOfElement[G,El[[i]],Mode -> Visual,
		Output -> Graphics, DisplayFunction -> Identity],{i,len}];
	ga = Partition[Array[gr,len],3];
	If[Mod[len,3]==1,AppendTo[ga,{gr[len],
		Graphics[{White,Point[{0,0}]}],
		Graphics[{White,Point[{0,0}]}]}]];
	If[Mod[len,3]==2,AppendTo[ga,{gr[len-1],gr[len],
		Graphics[{White,Point[{0,0}]}]}]];
	Show[GraphicsArray[ga],showopts,DisplayFunction -> df]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 33.5 Commutators
:[font = input; initialization; preserveAspect; endGroup]
*)
abelianQ[G_?GroupoidQ] := abelianQ[G] = Module[{
		t = AbstractAlgebra`Core`Private`makeTable[G,Elements[G]]},
	t === Transpose[t]]
	
Options[Commutator]={Mode -> Computational};

Commutator[G_?abelianQ, x_, y_]/; SubsetQ[{x,y},Elements[G]] := GroupIdentity[G]

Commutator[G_?GroupoidQ, x_, y_]/; SubsetQ[{x,y},Elements[G]] := 
	Operation[G][Operation[G][x,y],LeftInverse[G,Operation[G][y,x]]]

Commutator[G_?GroupoidQ, x_, y_, opts___?OptionQ]/; SubsetQ[{x,y},Elements[G]] := 
	Module[{mymode, comm,
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[Commutator]}];
	comm = CommutatorComputational[G,x,y];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",Commutator,mymode,comm,{Null},
		{Null},{Null},{Null},sc]]

CommutatorComputational[G_,x_,y_] := Module[{op = 
		Operation[G]},
	op[LeftInverse[G,op[y,x]],op[x,y]]]

Commutator[G_?GroupoidQ, x_, y_]/; !SubsetQ[{x,y},Elements[G]] :=
(Message[MemberQ::elmnts,{x,y},AbstractAlgebra`Core`Private`StructureName[G]]; $Failed)

Options[Commutators] = {Mode -> Computational};

Commutators[G_?abelianQ] := {GroupIdentity[G]}

Commutators[G_?GroupoidQ, opts___?OptionQ] := 
	Module[{mymode, comm,
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[Commutator]}];
	comm = CommutatorsComputational[G];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",Commutators,mymode,comm,{Null},
		{G,opts},{Null},{Null},sc]]

CommutatorsComputational[G_] := Module[{els=Elements[G],x,y,n},
	n = Length[els];
	Flatten[Table[CommutatorComputational[G,els[[x]],
		els[[y]]], {x,1,n},{y,1,n}],1]//Union];

Options[CommutatorsVisual] = {DisplayFunction -> $DisplayFunction};

CommutatorsVisual[G_,opts___?OptionQ] := 
	Module[{els = Elements[G], rects,keyRects, crects,
		gColoredRects, gText, gLines, comms,n,reducedcomms,
		moretext,lev,rulelist, tab,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[CommutatorsVisual]}]},
	n = Length[els];
	tab = Flatten[Table[{Commutator[G,els[[i]], els[[j]]],{els[[i]], els[[j]]}},{i,n},
		{j,n}],1];
	reducedcomms = Union[First[Transpose[tab]]];
	lev = Length[reducedcomms];
	rulelist = Table[Rule[reducedcomms[[i]],
		AbstractAlgebra`Core`Private`myColorList[[i]]],{i,lev}];
	keyRects = Join[Table[{AbstractAlgebra`Core`Private`myColorList[[i]],
		Rectangle[{0, -i}, {1, -i+1}]},{i,lev}],
		Transpose[{Table[AbstractAlgebra`Core`Private`myColorList[[i]],{i,lev}],
			AbstractAlgebra`Core`Private`headingsRectanglesForSublist[els,reducedcomms]}]];
	moretext = Table[Text[ToString[reducedcomms[[i]]//KeyForm[G]],
		{1.5,-i+.5},{-1,0}],{i,lev}];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		moretext = Join[moretext, Table[Text[AbstractAlgebra`Core`Private`genericSublist[els, 
		reducedcomms][[i]],{-0.4,-i+.5}],{i,lev}]]];
	{gLines, gText,rects} = AbstractAlgebra`Core`Private`basicCayley[G,els,
		ShowBodyText -> False, CayleyForm -> CayleyForm[G]];
	crects = AbstractAlgebra`Core`Private`ColorTableSquares[G,els,
		Last[Transpose[tab]], First[Transpose[tab]]/.rulelist];
	gColoredRects = Show[Graphics[{crects,keyRects,moretext},
		DisplayFunction -> Identity]];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[els,AbstractAlgebra`Core`Private`StructureName[G],G, KeyForm[G]]];
	Show[{gColoredRects, gLines, gText},showopts,
		DisplayFunction -> df]
	]

Options[CommutatorSubgroup]={Mode -> Computational};

CommutatorSubgroup[G_?GroupoidQ,opts___?OptionQ] := 
		Module[{mymode,commsub,
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[CommutatorSubgroup]}];
	commsub = CommutatorSubgroupComputational[G];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",
		CommutatorSubgroup,mymode,commsub,{Null},
		{G,Elements[commsub],opts},{Null},{Null},sc]]
	
CommutatorSubgroupComputational[G_]:= Module[{sub},
	sub = GenerateGroupoid[CommutatorsComputational[G],Operation[G]];
	If[ProperSubsetQ[sub = Elements[sub], Elements[G]],
			FormGroupoid[sub, Operation[G], OperatorSymbol[G],
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G]]

Options[CommutatorSubgroupVisual] = {DisplayFunction -> $DisplayFunction};

CommutatorSubgroupVisual[G_,sub_,opts___?OptionQ]:= Module[{
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[CommutatorSubgroupVisual]}]},
	Show[SubgroupQ[sub,G,Mode -> Visual, DisplayFunction -> Identity,
		Output -> Graphics],
		showopts, DisplayFunction -> df]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 36. Cyclicity of a group
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[CyclicQ]={Mode -> Computational};

CyclicQ[G_?GroupoidQ] := CyclicQ[G] = Module[{done = False, sub,
		els = Elements[G], len,cyc, i=1},
	len = Length[els];
	While[Not[done],
		sub = AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[els[[i]],G];
		If[sub===$Failed, done = True; cyc = $Failed,
			cyc = (Union[sub] === Union[els]);
			done = (i == len) || cyc;
			i++]];
	{cyclicQ[G], generator[G]} = {cyc,els[[i-1]]};
	cyc]
	
CyclicQ[G_?GroupoidQ,opts___?OptionQ] := Module[{done = False, sub,
		els = Elements[G], len,cyc, i,mymode,sc},
	mymode = Mode/.Flatten[{opts, Options[CyclicQ]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	len = Length[els];
	i = 1;
	While[Not[done],
		sub = AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[els[[i]],G];
		cyc = Union[sub] === Union[els];
		done = (i == len) || cyc;
		i++];
	{cyclicQ[G], generator[G]} = {cyc,els[[i-1]]};
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",CyclicQ,mymode,cyc,{G,generator[G]},
			{G,opts},{Null},{Null},sc]
	]
	
CyclicQ[many:{_?GroupoidQ..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[CyclicQ, many, mode])
		
CyclicQ[many:{_?GroupoidQ..}] :=
	CyclicQ[many, Mode -> (Mode/.Options[CyclicQ])]
		
CyclicQTextual[G_,gen_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, CyclicQTextualGD[G]; CyclicQTextualLI[G,gen],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			CyclicQTextualGD[G]; CyclicQTextualLI[G,gen];AbstractAlgebra`Core`Private`firstPassQ = False,
			CyclicQTextualLI[G,gen]]]

CyclicQTextualGD[_] := Print["A Groupoid G is said to be cyclic
if there exists an element g in G such that for all h in G
there exists an integer n such that h = g^n."]

CyclicQTextualLI[G_,gen_] := (If[$VersionNumber < 2.5, Print[" "]];
	Print[StringJoin["In this case, ",
		AbstractAlgebra`Core`Private`theGroupName[G],If[cyclicQ[G],StringJoin[" is indeed cyclic,
being generated by ",ToString[gen],"."]," is
		NOT cyclic."]]])

Options[CyclicQVisual]={DisplayFunction -> $DisplayFunction};

CyclicQVisual[G_,opts___] :=
	With[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[CyclicQVisual]}]},
	If[cyclicQ[G],g=generator[G];
		Show[AbstractAlgebra`Joint`Private`SubgroupGeneratedVisual2[G,g,
			DisplayFunction -> Identity],showopts,
			DisplayFunction -> df],
		(*else *) Show[CyclicSubgroupsVisual[G,
			CyclicSubgroupsWork[G],DisplayFunction -> Identity],showopts,
			DisplayFunction -> df]]]

showAllGenerations[G_] :=
	Module[{els = Elements[G],op= Operation[G],opsy=OperatorSymbol[G],
		len,inlen,heldlist,i,nS,g,rects, x,pos,n,poslist,
		coloredRects, max = -1,gColoredRects={}, gText, 
		gLines,huerects={},huetext={},list,ggColoredRects},
	{ gLines, gText,rects} = AbstractAlgebra`Core`Private`basicCayley[G,els, CayleyForm -> CayleyForm[G]];
	n = Length[els];
	Do[
		g = els[[i]];
		list = AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[g,G];
		inlen = Length[list];
		max = Max[max,inlen];
		pos = Position[els,g,1]//Flatten;
		coloredRects=AbstractAlgebra`Joint`Private`coloredSquares[g,G,list,inlen];
		If[max == inlen,Do[AppendTo[huerects, {Hue[(i-1)/inlen],
			Rectangle[{i-1,-2},{i,-1}]}],{i, inlen}]];
		AppendTo[gColoredRects, {coloredRects}], {i,n}];
		AppendTo[gColoredRects, {huerects}];
	ggColoredRects = Show[Graphics[gColoredRects,DisplayFunction->Identity]];
	Show[{ ggColoredRects, gLines,gText},
		DisplayFunction -> Identity(*,PlotRange -> All*)]
		]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 37. Cyclic subgroups of a group
:[font = input; initialization; preserveAspect; endGroup]
*)
CyclicSubgroupsWork[G_] := 
	Map[AbstractAlgebra`Joint`Private`SubgroupGeneratedWork[#,G]&,Elements[G]]

Options[CyclicSubgroups]={Mode -> Computational};

CyclicSubgroups[G_?GroupoidQ, opts___?OptionQ] := 
	Module[{mymode,out,sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts],
		subs, temp},
	mymode = Mode/.Flatten[{opts, Options[CyclicSubgroups]}];
	subs = Union[Map[Union,temp = CyclicSubgroupsWork[G]]];
	subs = If[CyclicQ[G], Drop[subs, -1], subs];
	out = Map[FormGroupoid[#, Operation[G], OperatorSymbol[G], 
		AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]]&,
		subs];
	If[CyclicQ[G], AppendTo[out, G]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",
		CyclicSubgroups,mymode,out,{G,temp},
			{G,temp,opts},{Null},{Null},sc]]

CyclicSubgroupsTextual[G_,sg_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, CyclicSubgroupsTextualGD[G]; 
		CyclicSubgroupsTextualLI[G,sg],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			CyclicSubgroupsTextualGD[G]; 
			CyclicSubgroupsTextualLI[G,sg];AbstractAlgebra`Core`Private`firstPassQ = False,
			CyclicSubgroupsTextualLI[G,sg]]]

CyclicSubgroupsTextualGD[_] := 
Print["Given a group G, we can find all the cyclic
subgroups by taking all the elements g in G and determining
<g>. Below is the list of the cyclic subgroups determined by
calculating <g> for each element serially. The output
gives the list with no duplicates, as well as sorted.\n"]

CyclicSubgroupsTextualLI[G_,sg_] := Module[{temp1, 
	temp2,diff},
temp = Map[Sort,sg]//Union;
Print[ColumnForm[sg]];Print[" "]]

Options[CyclicSubgroupsVisual]={DisplayFunction -> $DisplayFunction};

CyclicSubgroupsVisual[G_,sg_,opts___] := Module[{els=Elements[G],
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[CyclicSubgroupsVisual]}],
		len,i,rects,n,coloredRects, gText, 
		gLines,huerects,huetext,test},
	{gLines,gText, rects} = AbstractAlgebra`Core`Private`basicCayley[G,els, CayleyForm -> CayleyForm[G]];
	len = Length[els];
	test = Transpose[{els,sg}];
	coloredRects=Map[AbstractAlgebra`Joint`Private`coloredSquares[#[[1]],G,#[[2]],
		len]&,test]//Flatten[#,1]&;
	huerects = Table[{Hue[(i-1)/len],
		Rectangle[{i-1,-2},{i,-1}]},{i, len}];
	huetext = Table[Text[Range[len][[i]],{i-.5,-0.6},{0,0}],
		{i, len}];
	AppendTo[huetext, Text["n",{-0.5,-0.6}]];
	AppendTo[huetext, Text["g^n",{-0.5,-1.5}]];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[els,AbstractAlgebra`Core`Private`StructureName[G],G, KeyForm[G]]];
	Show[{Graphics[{coloredRects,huerects,huetext}],gLines,gText},
		showopts,DisplayFunction -> df]
	]
	
CyclicSubgroups[many:{_?GroupoidQ..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; 
	AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[CyclicSubgroups, many, mode])
		
CyclicSubgroups[many:{_?GroupoidQ..}] :=
	CyclicSubgroups[many, Mode -> (Mode/.Options[CyclicSubgroups])]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 38. Cyclic Generators of a Group
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[CyclicGenerators]={Mode -> Computational};

CyclicGenerators[G_?GroupoidQ,opts___?OptionQ] := 
	Module[{mymode, 	els = Elements[G],list,temp,
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[CyclicGenerators]}];
	temp = CyclicSubgroupsWork[G];
	list = Map[First,Select[temp,
		(Length[els]==Length[#])&]];
	If[list ==={}, Message[Group::notcyclic,
		AbstractAlgebra`Core`Private`StructureName[G]]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",
		CyclicGenerators,mymode,list,{G,temp},
			{G,temp,opts},{Null},{Null},sc]]

CyclicGeneratorsTextual[G_,sg_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, CyclicGeneratorsTextualGD[G]; 
		CyclicSubgroupsTextualLI[G,sg],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			CyclicGeneratorsTextualGD[G]; 
			CyclicSubgroupsTextualLI[G,sg];AbstractAlgebra`Core`Private`firstPassQ = False,
			CyclicSubgroupsTextualLI[G,sg]]]

CyclicGeneratorsTextualGD[_] := 
Print["Given a group G, we can find all the generators
of the group by taking all the elements g in G and determining
<g> and determine when <g> = G. Below is the list of the cyclic subgroups determined by
calculating <g> for each element serially. The output
gives the list of elements which generated the whole group.\n"]

Options[CyclicGeneratorsVisual]={DisplayFunction -> $DisplayFunction};

CyclicGeneratorsVisual[G_,sg_,opts___] :=
	CyclicSubgroupsVisual[G,sg,opts]

CyclicGenerators[many:{_?GroupoidQ..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; 
	AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[CyclicGenerators, many, mode])
		
CyclicGenerators[many:{_?GroupoidQ..}] :=
	CyclicGenerators[many, Mode -> (Mode/.Options[CyclicGenerators])]

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 39. Centralizer of an Element of a Group
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[Centralizer]={Mode -> Computational};

Centralizer[G_?GroupoidQ, g_, opts___?OptionQ] := 
	Module[{mymode, els = Elements[G],cent, centels, op = Operation[G],
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[Centralizer]}];
	centels = Select[els, op[#,g]===op[g,#]&];
	cent = If[ProperSubsetQ[centels, els],
			FormGroupoid[centels, Operation[G], OperatorSymbol[G],
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",Centralizer,
	mymode,cent,{G,g,Elements[cent]},	{Null},{Null},{Null},sc]]
	
CentralizerTextual[G_,g_,cent_] := 
	Print[StringJoin["Given an element g in a group G, we define
	the centralizer of g in G as the set of all elements in G
	which commute with g. In other words, it is the set {h in G |
	g h = h g}. In this case, the centralizer of ",
	ToString[g], " in ", AbstractAlgebra`Core`Private`StructureName[G], " is the set \n", 
	ToString[cent]]];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 40. Center of a group
:[font = input; initialization; preserveAspect; endGroup]
*)
Unprotect[Center];

AbstractAlgebra`Core`Private`groupoid /: 
	Center[G_AbstractAlgebra`Core`Private`groupoid, opts___?OptionQ] := 
	GroupCenter[G, opts];

Protect[Center];

Options[GroupCenter] = {Mode -> Computational};
	
CommuteWithAllQ[G_?GroupoidQ, el_] := 
	(Elements[Centralizer[G,el]]//Union) === (Elements[G]//Union)
		
GroupCenter[G_?GroupoidQ, opts___?OptionQ] := Module[{mymode,
		list, els = Elements[G],ct, cent,
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[GroupCenter]}];
	ct = AbstractAlgebra`Core`Private`makeTable[G,els];
	cent = MapThread[SameQ, {ct,Transpose[ct]},2]//
  	{Apply[And,#,1],Apply[And,Transpose[#],1]}&//
    MapThread[And,#]&//
    Select[Transpose[{#,Domain[G]}],First[#]&]&//
    Transpose//Last;
  If[ProperSubsetQ[cent,els],
			FormGroupoid[cent, Operation[G], OperatorSymbol[G],
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",GroupCenter,
		mymode,cent,{Null},	{Null},{Null},{Null},sc]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 41. Centralizer of a subgroup
:[font = input; initialization; preserveAspect; endGroup]
*)
commutesWithH[x_, H_List, op_] :=
	Map[op[x, #]&, H] === Map[op[#, x]&, H]

Centralizer[G_?GroupoidQ, H_List] := Module[{els = Elements[G], op =
		Operation[G], cent},
	cent = Select[els, commutesWithH[#, H, op]&];
	If[ProperSubsetQ[cent,els],
			FormGroupoid[cent, op, OperatorSymbol[G],
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G]]

Centralizer[G_?GroupoidQ, H_?GroupoidQ] :=
	If[Operation[G] === Operation[H],
		Centralizer[G, Elements[H]],
		Message[Operation::fail]; $Failed]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 42. Conjugacy topics
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
42.1 ElementConjugate
:[font = input; initialization; preserveAspect; endGroup]
*)
Unprotect[Conjugate];

Attributes[Conjugate] = {}; (* Note: removed Listable *)

AbstractAlgebra`Core`Private`groupoid /: 
	Conjugate[G_AbstractAlgebra`Core`Private`groupoid, h_, x_, opts___?OptionQ] := 
		Module[{rh, rx},
	{rh, rx} = Map[TensorRank, {h, x}];
	If[rh === rx, ElementConjugate[G, h, x, opts],
		If[rh === rx + 1, SubgroupConjugate[G, h, x, opts],
		Message[Conjugate::fail,h,x]; $Failed]]]

Protect[Conjugate];

Options[ElementConjugate]={Mode -> Computational};

ElementConjugate[G_?GroupoidQ, h_, x_, opts___?OptionQ] := 
	Module[{mymode, con, op = Operation[G],
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[ElementConjugate]}];
If[ElementQ[h,G] && ElementQ[x,G],
	con = op[op[x,h],GroupInverse[G,x]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",ElementConjugate,mymode,con,{Null},
			{Null},{Null},{Null},sc],
If[!ElementQ[h,G],Message[MemberQ::elmnt,h,AbstractAlgebra`Core`Private`StructureName[G]]];
If[!ElementQ[x,G],Message[MemberQ::elmnt,x,AbstractAlgebra`Core`Private`StructureName[G]]]; $Failed]]

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
42.2 SubgroupConjugate
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[SubgroupConjugate]={Mode -> Computational};

SubgroupConjugate[G_?GroupoidQ,H_List,x_,opts___?OptionQ] := 
	Module[{mymode,con, 
		op = Operation[G],out,
		sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[SubgroupConjugate]}];
If[SubgroupQ[H,G] && ElementQ[x,G],
	con = Map[op[op[x,#],GroupInverse[G,x]]&,H];
	con = If[ProperSubsetQ[con, Elements[G]],
			FormGroupoid[con, op, OperatorSymbol[G], 
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			G];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties",
		SubgroupConjugate,mymode,con,{Null},
			{Null},{Null},{Null},sc],
	If[!SubgroupQ[H,G],
		Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]]];
	If[!ElementQ[x,G],Message[MemberQ::elmnt,x,AbstractAlgebra`Core`Private`StructureName[G]]]]]
	
SubgroupConjugate[G_?GroupoidQ, H_?GroupoidQ, x_, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		SubgroupConjugate[G, Elements[H], x, opts],
		Message[Operation::fail]; $Failed]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
42.3 ConjugacyClass
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[ConjugacyClass] = {Mode -> Computational};

ConjugacyClass[G_?GroupoidQ,h_,opts___?OptionQ] := 
	Module[{mymode, els = Elements[G],con, 
		op = Operation[G],out,sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[ConjugacyClass]}];
If[ElementQ[h,G],
	con = Map[(op[op[#,h],GroupInverse[G,#]])&,els]//Union;
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties", ConjugacyClass, mymode,con,{Null},
			{Null},{Null},{Null},sc],
If[!ElementQ[h,G],Message[MemberQ::elmnt,h,AbstractAlgebra`Core`Private`StructureName[G]]]]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
42.4 Normalizer
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Options[Normalizer]={Mode -> Computational};

Normalizer[G_?GroupoidQ, H_List, opts___?OptionQ] := 
	Module[{mymode, els = Elements[G],norm={}, 
		op = Operation[G],out,sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[Normalizer]}];
If[SubgroupQ[H,G],
	Do[If[H===SubgroupConjugate[G,H,els[[i]]],
		AppendTo[norm,els[[i]]]],{i,Length[els]}];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`GroupProperties", Normalizer, mymode,norm,{Null},
			{Null},{Null},{Null},sc],
If[!ElementQ[h,G],Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]]]]]

Normalizer[G_?GroupoidQ, H_?GroupoidQ, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		Normalizer[G, Elements[H], opts],
		Message[Operation::fail]; $Failed]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 47. Other
:[font = input; initialization; preserveAspect; endGroup]
*)
EqualGroupoidQ[G1_?GroupoidQ, G2_?GroupoidQ] := Module[{els1, els2},
	Sort[els1 = Elements[G1]] === Sort[els2 = Elements[G2]] &&
	CayleyTable[ReorderGroupoid[G1, els1]] === CayleyTable[ReorderGroupoid[G2, els2]]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 99. Wrap up AbstractAlgebra`GroupProperties
:[font = input; initialization; preserveAspect]
*)
End[];

EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
