(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Joint` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 0. Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`Joint *)

(* :Context: AbstractAlgebra`Joint` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 1. Startup Joint
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Joint`", 
{"AbstractAlgebra`Core`", "Graphics`Colors`",
"Graphics`Arrow`", "Utilities`FilterOptions`"}];

Off[General::spell,General::spell1];
SetOptions[Graphics, AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";

(* Off[Dot::dotsh];*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2. Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
AbelianQ::usage = "AbelianQ[G] returns True if the Groupoid G is
Abelian (commutative), and False otherwise. This is identical to
CommutativeQ[G].";

Canonical::usage = "Canonical is a value for the Representatives 
option for the QuotientGroup (and QuotientRing) function. This value
causes QuotientGroup to use the 'first' element in the coset.";

CommutativeQ::usage = "CommutativeQ[S] returns True if the structure S
is commutative, and False otherwise. When S is a group, this is
identical to AbelianQ[S]. When used with rings, one has the option
Operation, which can take on the values Addition, Multiplication
or Both.";

CosetLists::usage = "CosetLists is a value for the Form option of
QuotientGroup and QuotientRing. With this option, the output is a list
of the cosets in list form.";

CosetToList::usage = "CosetToList[G, coset] returns the coset
(represented as a list) in the quotient group/ring corresponding to
the coset represented in the form g + NS or NS + g (or g NS or NS g).";

Cosets::usage = "Cosets is a value for the Form option of
QuotientGroup and QuotientRing. This causes the elements to be written
as cosets of the form gNS, g + NS, NSg, or NS + g, depending on other
options, where NS represents the normal subgroup (or ideal for
rings).";

DirectProduct::usage = "DirectProduct[S1, S2] returns the direct
product of the structured sets (Groupoids or Ringoids) S1 and S2. (Any
number of arguments can be used.)";

DirectSum::usage = "DirectSum[S1, S2] returns the direct sum of the
structured sets (Groupoids or Ringoids) S1 and S2. (Any number of
arguments can be used.)";

DisguiseGroupoid::usage = "DisguiseGroupoid[G] returns the Groupoid
G with the elements of G replaced with the strings 'a', 'b', etc. The
purpose is to present a generic group without any indication of the form
of the elements or operation. DisguiseGroupoid[G, rules] does the same
except that rules is a list of Rules which specify how the matching
should occur. Adding the option Randomize -> True will randomize
the original elements before the rules are assigned; the default for
this option is False.";

DisguiseRingoid::usage="DisguiseRingoid[R] returns the Ringoid R
with the elements of R replaced with the strings 'a', 'b', etc. The
purpose is to present a generic ring without any indication of the form
of the elements or operation. Adding the option Randomize ->
True will randomize the original elements in the Ringoid; the default
for this option is False. One can also add one's own mapping rules, as in
DisguiseGroupoid.";

ElementToCoset::usage = "ElementToCoset[Q, el], assuming Q is the quotient
group G/N and el is an element in G, this returns the coset containing el.";

FactorGroup::usage = "FactorGroup[G, N, opts] is equivalent to
QuotientGroup[G, N, opts]; see this function for further details.";

Index::usage = "Index[G, H] returns the index of the subgroup H in the
group G.";

LeftCoset::usage = "LeftCoset[G, H, g] returns the left coset gH (or g
+ H) when given the element g from G and the subgroup H of G.
G is assumed to be either a Groupoid or Ringoid (for
which H needs to be a subring).";

LeftCosets::usage = "LeftCosets[G, H] returns the set of cosets of the
subgroup (or subring) H in the Groupoid (or Ringoid) G.";

NS::usage = "NS is a symbol for Input and Output to represent whatever
Normal Subgroup is in use at the time.";

NonCommutingPairs::usage = "NonCommutingPairs[G] returns the pairs of
elements in the Groupoid G that do not commute.";

NormalQ::usage = "NormalQ[H, G] returns True if H is a normal subgroup
of G, and False otherwise.";

QuotientGroup::usage = "QuotientGroup[G, N] returns the quotient group
formed by the group G and the normal subgroup N. Options for this
function are Form and Representatives. Form can have the
value Cosets (default) which returns the elements in coset form g + NS
or g NS where NS is a symbol representing the Normal Subgroup. The
value CosetLists returns the quotient group as a list of all the
cosets in list form. Alternatively, one can use Form ->
Representatives and then only the representatives of the cosets will
be returned. The default list of representatives uses the 'smallest'
element in the coset and is indicated by Representatives -> Canonical;
if you wish to change this list, use Representatives -> list, where
list is a list of one element from each coset, or use Representatives
-> Random to have these representatives randomly chosen. This can be
used also if one has Form -> Cosets. By default, left cosets are used.";

Representatives::usage = "Representatives is a value for the Form
option of QuotientGroup and QuotientRing. This causes the elements to
be written as representatives of the cosets. 
Representatives is also an option for QuotientGroup
and QuotientRing. It can take values Canonical (default), Random, or
{g1, g2,...} where the gi's are representatives from the cosets. The
Canonical option uses the 'first' element in the coset, while the
Random chooses one randomly.";

RightCoset::usage = "RightCoset[G, H, g] returns the right coset Hg
(or H + g) when given the element g from G and the subgroup H of G. If
your use of right coset means the set gH (g + H), then use the option
G is assumed to be either a Groupoid or Ringoid.";

RightCosets::usage = "RightCosets[G, H] returns a list of the cosets
of the subgroup (or subring) H in the Groupoid (or Ringoid) G.";

RightToLeft::usage = "RightToLeft is a value for the ProductOrder option
of MultiplyPermutations and MultiplyCycles, as well for the
PowersIncrease option for Poly (in Rings). When ProductOrder is set to
this value, then MultiplyPermutations[p2,p1] will be computed by taking
p1 followed by p2. For the use in Poly, see PowersIncrease.";

SubgroupGenerated::usage = "SubgroupGenerated[G, g] returns the
subgroup generated by the element g in the group G. Options include
Mode -> Visual2 (as well as the other modes). When using the Visual
mode, Output -> GraphicsArray causes the graphics to be placed in
array form, rather than being presented serially.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.4 Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
CosetToList::illformed = "The coset `1` is ill-formed.";

DirectProduct::ArgErr="Direct Product called with incorrect arguments.";

GenerateGroupoid::size = "The size of the set generated thus far exceeds
the current value of `1` given by the option SizeLimit. (The elements
generated thus far are shown below.)";

QuotientGroup::NS = "This quotient group uses NS to represent the normal
subgroup `1` that you specified. Use CosetToList to convert this coset
representation to a list of elements.";

QuotientGroup::badrep = "Your choice of `1` for representatives is a bad
representation. Make sure you have only one from each coset.";

QuotientGroup::replngth = "Your choice of representatives is not of the
correct length. There should be `1` elements.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.5 Begin private section
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 12. Misc.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
general
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 19. Direct product
:[font = input; initialization; preserveAspect; endGroup]
*)
DirectSum[R_?GroupoidQ, Rs__]:= Module[{factorsAreGroups,numgrps = Length[{R,Rs}]},
  If[Apply[And,Map[GroupoidQ,{R, Rs}]],
  	factorsAreGroups = Apply[And,Map[GroupQ,{R, Rs}]];
    FormGroupoid[Distribute[Elements/@{R,Rs},List],
    	MapThread[(#1[#2,#3])&, {Operation/@{R,Rs},#1,#2}]&,
    	GroupoidName -> Apply[StringJoin,Transpose[{Map[AbstractAlgebra`Core`Private`StructureName,{R,Rs}],
		Table[" + ",{numgrps}]}]//Flatten//Drop[#,-1]&],
    	MaxElementsToList -> 25,
    	WideElements -> True, IsAGroup -> If[factorsAreGroups, True, False]],
  Message[DirectProduct::ArgErr]]]

DirectProduct[R_?GroupoidQ, Rs__]:= Module[{factorsAreGroups,numgrps = Length[{R,Rs}]},
  If[Apply[And,Map[GroupoidQ,{R, Rs}]],
  	factorsAreGroups = Apply[And,Map[GroupQ,{R, Rs}]];
    FormGroupoid[Distribute[Elements/@{R,Rs},List],
    	MapThread[(#1[#2,#3])&, {Operation/@{R,Rs},#1,#2}]&,
    	GroupoidName -> Apply[StringJoin,Transpose[{Map[AbstractAlgebra`Core`Private`StructureName,{R,Rs}],
		Table[" x ",{numgrps}]}]//Flatten//Drop[#,-1]&],
    	MaxElementsToList -> 25,
    	WideElements -> True, IsAGroup -> If[factorsAreGroups, True, False]],
  Message[DirectProduct::ArgErr]]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 34. AbelianQ
:[font = input; initialization; preserveAspect; endGroup]
*)
CommutativeQ[G_?GroupoidQ] := AbelianQ[G]

CommutativeQ[G_?GroupoidQ,opts__?OptionQ] := AbelianQ[G, opts]

CommutativeQ[many:{_?GroupoidQ..}] := Map[AbelianQ, many]

CommutativeQ[many:{_?GroupoidQ..}, Mode -> mode_] :=
	AbstractAlgebra`Core`Private`handleSimpleMultiple[AbelianQ, many, mode]
	
Options[AbelianQ]={Mode -> Computational};
		
AbelianQ[G_?GroupoidQ] := AbelianQ[G] = Module[{
		t = AbstractAlgebra`Core`Private`makeTable[G,Elements[G]]},
	t === Transpose[t]]
	
AbelianQ[G_?GroupoidQ,opts__?OptionQ] := Module[{mymode,
		t = AbstractAlgebra`Core`Private`makeTable[G,Elements[G]],sc = 
		FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[AbelianQ]}];
	AbelianQ[G] = t === Transpose[t];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint",
		AbelianQ,mymode,AbelianQ[G],{G},
		{G,opts},{Null},{Null},sc]]
	
Options[AbelianQVisual]={DisplayFunction -> $DisplayFunction};

AbelianQVisual[G_,opts___?OptionQ] := Module[{g1,g2,g3,nc,
	showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[AbelianQVisual]}]},
	{g1,g2,g3} = AbstractAlgebra`Core`Private`basicCayley[G,Elements[G], CayleyForm -> CayleyForm[G]];
	nc = NonCommutingPairs[G];
	nc = Join[nc, Map[Reverse,nc]]//Union;
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[Elements[G],
		AbstractAlgebra`Core`Private`StructureName[G],
		G, KeyForm[G]]];
	Show[{Graphics[{{White,g3},MakeAbelianQLines[G],If[nc =!= {}, 
		AbstractAlgebra`Core`Private`ColorTableSquares[G,Elements[G],
			nc,RGBColor[1,0,0]], Point[{0,0}]]}],g2,g1},
		showopts, DisplayFunction -> df]]

MakeAbelianQLines[G_] := Module[{n = Length[Elements[G]],lines},
	lines = {Yellow,AbsoluteThickness[3], Line[{{0,n},{n,0}}]};
	Join[lines,Table[Line[{{0,i},{n-i,n}}], {i,n-2,0,-1}],
Table[Line[{{i,0},{n,n-i}}], {i,n-2}]]
]

AbelianQ[many:{_?GroupoidQ..}] :=
	Map[AbelianQ, many]
		
AbelianQ[many:{_?GroupoidQ..}, Mode -> mode_] :=
	AbstractAlgebra`Core`Private`handleSimpleMultiple[AbelianQ, many, mode]
		
AbelianQ[many:{_?GroupoidQ..}, Mode -> mode_,opts___?OptionQ] :=
	AbstractAlgebra`Core`Private`handleSimpleMultiple[AbelianQ, many, mode,{opts}]
		
AbelianQ[many:{_?GroupoidQ..}] :=
	AbelianQ[many, Mode -> (Mode/.Options[AbelianQ])]

NonCommutingPairs[G_?GroupoidQ] := Module[{els = Elements[G], n, i,j, 
		op = Operation[G],a,b},
	n = Length[els];
	Select[Flatten[Table[{x = els[[i]], y = els[[j]], op[x,y] === op[y,x]},
		{i, 1, n}, {j, i, n}], 1],#[[3]]===False&]/.{a_,b_,False} -> {a,b}]

AbelianQTextual[G_] := Module[{S = NonCommutingPairs[G],x, 
	y,i,j,	op = Operation[G]},
	Print["We say that a group(oid) G is Abelian
	(or commutative) if for all g and h in G we have g*h = h*g (with the
	operation *). "<>If[S==={}, "All elements commute in this case",
		"The following pairs do NOT commute:\n"]];
	Print[TableForm[Flatten[Table[x = S[[i]]; y = S[[j]];
		{x, y, op[x,y], op[y,x], op[x,y] === op[y,x]},
		{i, Length[S]}, {j,i,Length[S]}],1],
		(* TableAlignments -> {Center, Center},*)
		TableHeadings->{None,
			{"x","y","x y", "y x","commute?\n"}},
		TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0],2},
		TableDepth -> 2]];
	If[S=!={},Print[" "]];
		]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 35. Subgroup Generated by an Element
:[font = input; initialization; preserveAspect; endGroup]
*)
ClosedQAndIdentityQ[G_?GroupoidQ] :=
	If[HasIdentityQ[G],
		If[ClosedQ[G], True,
			Message[Group::fail, AbstractAlgebra`Core`Private`StructureName[G]]; False],
		Message[Group::fail, AbstractAlgebra`Core`Private`StructureName[G]]; False]

SubgroupGeneratedWork[g_,G_] := Module[{id},
	If[Not[ElementQ[g,G]],
		Message[MemberQ::elmnt, g, AbstractAlgebra`Core`Private`StructureName[G]];$Failed,
		If[ClosedQAndIdentityQ[G],
			id = GroupIdentity[G];
			If[g===id,
				{g},
				FixedPointList[Operation[G][g,#]&,g, Length[Elements[G]],
				SameTest ->(#2===id&)]//If[Last[#]=!=id, Message[Group::noord,
					g, AbstractAlgebra`Core`Private`StructureName[G]]; $Failed,#]&], $Failed]]]

Options[SubgroupGenerated]={Mode -> Computational, Output -> Computational};

SubgroupGenerated[G_?GroupoidQ, g_] := SubgroupGenerated[G,g] = Module[{sg},
	sg = SubgroupGeneratedWork[g,G];
	If[sg =!= $Failed,
		If[ProperSubsetQ[sg, Elements[G]],
			FormGroupoid[sg, Operation[G], OperatorSymbol[G],
				AbstractAlgebra`Core`Private`GatherSubGroupoidOptions[G]],
			FormGroupoid[sg, Operation[G], OperatorSymbol[G],
				AbstractAlgebra`Core`Private`GatherGroupoidOptions[G]]], $Failed]]
		
SubgroupGenerated[G_?GroupoidQ,g_, opts__?OptionQ] := 
		Module[{list,	ok, mymode, output, sc = 
			FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[SubgroupGenerated]}];
	output = Output/.Flatten[{opts, Options[SubgroupGenerated]}];
	list = SubgroupGenerated[G,g];
	ok = (list =!= $Failed);
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint",
		SubgroupGenerated,mymode,list, 
		{g, G,ok},{g, G,ok, output},{G, g},{Null},sc]]

SubgroupGeneratedTextual[g_,G_,ok_] := 
	Module[{opsy = OperatorSymbol[G], list,inlen,nS,len,heldlist,
		nlist,S=Elements[G],op= Operation[G]},
	If[ok,
	list = SubgroupGeneratedWork[g,G];
	Print[StringJoin["The group ",AbstractAlgebra`Core`Private`StructureName[G], " has the
	subgroup <",ToString[g],"> given as"]];
	If[$VersionNumber < 2.5, Print[" "]];
	len = Length[list];
	heldlist = makeHeldList[g,G,len];
	nlist = Map[KeyForm[G], NestList[(op[g,#])&,g,len-1]];
	Print[TableForm[Transpose[{Range[len],heldlist,nlist}],
		TableHeadings->{None,{"index",Switch[opsy,
			"+","multiples",_,"powers"],
			"simplified\n"}}, (*TableAlignments->{Center, Center},*)
		TableSpacing -> {If[$VersionNumber > 2.5, 0.5, 0], 7}]];
	If[$VersionNumber < 2.5, Print[" "]];
	Print[TableForm[{UnionNoSort[list],Union[list]},
		TableHeadings->{{"as generated:","sorted:"},None},
		TableAlignments->{Bottom,Center},
		TableSpacing -> {0,2}]];
	If[$VersionNumber < 2.5, Print[" "]];]]

SubgroupGeneratedVisual[g_,G_,ok_, output_] := 
	Module[{i,n,m,pos,ds,allpos,newcrds,thelines,orderlist,
		growPtsGr = {},growLblGr = {},nwlist,genpos, wide, els2,
		op = Operation[G],S = Elements[G],heldlist,genlist, gr},
If[ok,
	genlist = SubgroupGeneratedWork[g,G];
	If[wide=AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[S,
			AbstractAlgebra`Core`Private`StructureName[G],G, KeyForm[G], "g"]];
	m = Length[genlist];
	heldlist = makeHeldList[g,G,m];
	n = Length[S];
	genpos = Map[Position[S,#,1]&,genlist]//Flatten;
	ds = .05/m;
	newcrds = Part[AbstractAlgebra`Core`Private`ngonCoordsC[n],genpos];
	thelines = {};
	allpos ={};
	orderlist = {genlist,Take[heldlist,Length[genlist]]}//
		Transpose//Sort//Transpose//Last;
	If[wide, els2 = Map[ElementToKey[G,#]&,S];
		heldlist = Table["("<>ElementToKey[G,g]<>")^"<>ToString[k],
			{k,1,Length[heldlist]}], els2 = S];
	nwlist = heldlist;
	pos = First[genpos];
	AppendTo[growPtsGr, AbstractAlgebra`Core`Private`ngonDot[pos,n,Red,.03]];
	AppendTo[growLblGr, AbstractAlgebra`Core`Private`ptLabeling[newcrds[[1]],
		nwlist[[1]]//AbstractAlgebra`Core`Private`OutStdForm]];
	gr[1] = Show[{AbstractAlgebra`Core`Private`modCircle[n],
			AbstractAlgebra`Core`Private`LabelingNgon[els2, els2,
			AbstractAlgebra`Core`Private`insideLabelFactor, If[wide,SequenceForm,
				KeyForm[G]]],
			growPtsGr, growLblGr}, PlotRange->{{-1.5,1.5},{-1.5,1.5}}, DisplayFunction -> Identity];
	Do[If[i>1,AppendTo[thelines,
		Line[{newcrds[[i]],newcrds[[i-1]]}]]];
		If[i==m,AppendTo[thelines,
		Line[{newcrds[[1]],newcrds[[m]]}]]];
		pos = genpos[[i]];
		AppendTo[growPtsGr,AbstractAlgebra`Core`Private`ngonDot[pos,
			n,Red,.03 +(i-1)ds]];
		AppendTo[growLblGr, AbstractAlgebra`Core`Private`ptLabeling[newcrds[[i]],
			nwlist[[i]]//AbstractAlgebra`Core`Private`OutStdForm]];
		gr[i] = Show[{AbstractAlgebra`Core`Private`modCircle[n],
			AbstractAlgebra`Core`Private`LabelingNgon[els2, els2,
			AbstractAlgebra`Core`Private`insideLabelFactor, If[wide,SequenceForm,
				KeyForm[G]]],
			If[i>1,Graphics[{Brown,thelines}]],
			growPtsGr,growLblGr},PlotRange->{{-1.5,1.5},{-1.5,1.5}}, DisplayFunction -> Identity]
		,{i,2,m}];
		If[output === GraphicsArray,
			Show[GraphicsArray[AbstractAlgebra`Core`Private`makeGA[gr,m]], 
			DisplayFunction -> $DisplayFunction],
			Do[Show[gr[i], DisplayFunction -> $DisplayFunction], {i,m}]
			];
	]]

makeHeldList[g_,G_,n_] := Module[{opsy = OperatorSymbol[G]},
	Switch[opsy,"+",
		Map[StringJoin[ToString[#],"*",ToString[g]]&,Range[n]],
			_,
		Map[StringJoin["(",ToString[KeyForm[G][g]],")","^",ToString[#]]&,Range[n]]]
	]

Options[SubgroupGeneratedVisual2]={DisplayFunction -> $DisplayFunction};

SubgroupGeneratedVisual2[G_, g_, opts___?OptionQ] :=
	Module[{els=Elements[G], inlen,heldlist,i,rects, pos,n,
		coloredRects, gColoredRects, gText, gLines,huerects,huetext,list,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[SubgroupGeneratedVisual2]}]},
	list = SubgroupGeneratedWork[g,G];
	inlen = Length[list];
	n = Length[els];
	heldlist = makeHeldList[g,G,inlen];
	{gLines, gText, rects} = AbstractAlgebra`Core`Private`basicCayley[G,els, CayleyForm -> CayleyForm[G]];
	pos = Position[els,g]//Flatten;
	coloredRects=coloredSquares[g,G,list,inlen];
	huerects = Table[{Hue[(i-1)/inlen],
		Rectangle[{i-1,-2},{i,-1}]},{i, inlen}];
	huetext = Table[Text[Range[inlen][[i]],{i-.5,-0.6},{0,0}],
		{i, inlen}];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		list = list/.AbstractAlgebra`Core`Private`MakeSubstitutionRules[G,els,"g"]];
	huetext = Join[huetext, Table[Text[ElementToKey[G,list[[i]]],{i-.5,-1.5},
		{0,0}],{i, inlen}]];
	AppendTo[huetext, Text["n",{-0.5,-0.6}]];
	AppendTo[huetext, Text["g^n",{-0.5,-1.5}]];
	gColoredRects = Show[Graphics[{{GrayLevel[.8],
		Rectangle[{-1,n-First[pos]},{0,n-First[pos]+1}]}, 
		coloredRects,huerects,huetext},DisplayFunction -> Identity]];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[els,AbstractAlgebra`Core`Private`StructureName[G],G, KeyForm[G]]];
	Show[{gColoredRects, gText, gLines},
		showopts, DisplayFunction -> df]
		]

coloredSquares[g_,G_,list_,n_] := Module[{pos, x, coloredRects={},
		S = Elements[G],poslist,i,lenlist, 
		tab = AbstractAlgebra`Core`Private`makeTable[G, Elements[G]]},
	pos = Select[Position[S,g],Length[#]==1&]//Flatten;
	lenlist = Length[list];
	poslist = Map[Select[Position[tab[[pos]],#],Length[#]==2&]&,list]/.
		{{1,x_}}:>x;
	row = Flatten[AbstractAlgebra`Core`Private`basicCayley[G,S][[3]][[pos]],1];
	Do[AppendTo[coloredRects, {Hue[(i-1)/n],
		row[[poslist[[i]]]]}],{i, lenlist}];
	Flatten[coloredRects]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 50. Cosets and related topics
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
50.1 finding a left or right coset
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[LeftCoset] = {Mode -> Computational};

Options[LeftCosetPrivate] = {LeftMeans -> ElementOnLeft};

LeftCoset[G_?GroupoidQ, H_?GroupoidQ, g_, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		LeftCoset[G, Elements[H], g, opts],
		Message[Operation::fail]; $Failed]

LeftCoset[G_?GroupoidQ,H_List, g_] := 
	If[!ElementQ[g,G] || !SubgroupQ[H,G], 
		HandleCosetErrors[LeftCoset,G,H,g],
		If[(LeftMeans/.Flatten[{Options[LeftCosetPrivate]}])===ElementOnLeft,
			Map[Operation[G][g,#]&,H],Map[Operation[G][#,g]&,H]]]
	
LeftCoset[G_?GroupoidQ,H_List, g_, LeftMeans -> lm_] := 
	If[!ElementQ[g,G] || !SubgroupQ[H,G], 
		HandleCosetErrors[LeftCoset,G,H,g],
		If[lm===ElementOnLeft,
			Map[Operation[G][g,#]&,H],Map[Operation[G][#,g]&,H]]]
	
LeftCoset[G_?GroupoidQ,H_List, g_,opts___?OptionQ] := 
		Module[{lm,mymode,sc,lc},
	lm = LeftMeans/.Flatten[{opts, Options[LeftCosetPrivate]}];
	mymode = Mode/.Flatten[{opts, Options[LeftCoset]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	If[!ElementQ[g,G] || !SubgroupQ[H,G], 
		HandleCosetErrors[LeftCoset,G,H,g],
		lc = If[lm===ElementOnLeft,
			Map[Operation[G][g,#]&,H],Map[Operation[G][#,g]&,H]];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint",
			LeftCoset,mymode,lc,{G,H,lc,g},
			{G,H,lc,g,opts},{Null},{Null},sc]]]
	
Options[RightCoset]={Mode -> Computational};

RightCoset[G_?GroupoidQ, H_?GroupoidQ, g_, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		RightCoset[G, Elements[H], g, opts],
		Message[Operation::fail]; $Failed]

RightCoset[G_?GroupoidQ,H_List, g_] := 
	If[!ElementQ[g,G] || !SubgroupQ[H,G], 
		HandleCosetErrors[RightCoset,G,H,g],
		If[(LeftMeans/.Flatten[{Options[LeftCosetPrivate]}])===ElementOnLeft,
			Map[Operation[G][#,g]&,H],Map[Operation[G][g,#]&,H]]]

RightCoset[G_?GroupoidQ,H_List, g_, LeftMeans -> lm_] := 
	If[!ElementQ[g,G] || !SubgroupQ[H,G], 
		HandleCosetErrors[RightCoset,G,H,g],
		If[lm===ElementOnLeft,
			Map[Operation[G][#,g]&,H],Map[Operation[G][g,#]&,H]]]

RightCoset[G_?GroupoidQ,H_List, g_, opts___?OptionQ] := 
		Module[{lm,mymode,sc,lc},
	lm = LeftMeans/.Flatten[{opts, Options[LeftCosetPrivate]}];
	mymode = Mode/.Flatten[{opts, Options[LeftCoset]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	If[!ElementQ[g,G] || !SubgroupQ[H,G], 
		HandleCosetErrors[RightCoset,G,H,g],
		lc = If[lm===ElementOnLeft,
			Map[Operation[G][#,g]&,H],Map[Operation[G][g,#]&,H]];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint",
			RightCoset,mymode,lc,{G,H,lc,g},
			{G,H,lc,g,opts},{Null},{Null},sc]]];

HandleCosetErrors[f_,G_,H_,g_] :=
(If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]]];
If[!ElementQ[g,G], Message[MemberQ::elmnt,g,AbstractAlgebra`Core`Private`StructureName[G]]];$Failed)

LeftCosetTextual[G_,H_,gH_,g_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, CosetTextualGD[G, Left]; 
		LeftCosetTextualLI[G,H,gH,g],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			CosetTextualGD[G, Left]; LeftCosetTextualLI[G,H,gH,g];
				AbstractAlgebra`Core`Private`firstPassQ = False,
			LeftCosetTextualLI[G,H,gH,g]]]

CosetTextualGD[_, side_] := 
	Print["Given an element g in a Groupoid G and a subgroup H
of G, the "<> If[side === Left,"left", "right"]<>" coset of H in G
containing g is the set of all elements "<>If[side === Left,
"gH = {g h | h in H}.", "Hg = {h g | h in H}."]<>If[$VersionNumber < 2.5,"\n"," "]]

LeftCosetTextualLI[G_,H_,gH_,g_] := 
(Print[StringJoin["In this case, the left coset of ",
ToString[H]," in ",AbstractAlgebra`Core`Private`StructureName[G],
" containing ",ToString[g]," is
given by ",ToString[gH],". This can be seen as follows:",
If[$VersionNumber < 2.5,"\n"," "]]];
makeCosetTextList[G,H,g,gH,Left];)

RightCosetTextual[G_,H_,gH_,g_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, CosetTextualGD[G, Right]; 
		RightCosetTextualLI[G,H,gH,g],
		If[AbstractAlgebra`Core`Private`firstPassQ, 
			CosetTextualGD[G, Right]; RightCosetTextualLI[G,H,gH,g];
				AbstractAlgebra`Core`Private`firstPassQ = False,
			RightCosetTextualLI[G,H,gH,g]]]

RightCosetTextualLI[G_,H_,Hg_,g_] := 
(Print[StringJoin["In this case, the right coset of ",
ToString[H]," in ",AbstractAlgebra`Core`Private`StructureName[G],
" containing ",ToString[g]," is
given by ",ToString[Hg],". This can be seen as follows:",
If[$VersionNumber < 2.5,"\n"," "]]];
makeCosetTextList[G,H,g,Hg,Right];)

makeCosetTextList[G_,H_,g_,gH_,side_] := 
	Switch[OperatorSymbol[G],"+",
		Switch[side,Left,
			Print[StringJoin[ToString[g]," + ",ToString[H]]];
			Print[StringJoin["= ",
				ToString[Map[StringJoin[ToString[g]," + ",
				ToString[#]]&,H]]]];
			Print[StringJoin["= ",ToString[gH]]],Right,
			Print[StringJoin[ToString[H]," + ",ToString[g]]];
			Print[StringJoin["= ",
				ToString[Map[StringJoin[ToString[#]," + ",
				ToString[g]]&,H]]]];
			Print[StringJoin["= ",ToString[gH]]]],
			_,
		Switch[side,Left,
			Print[StringJoin[ToString[g]," * ",ToString[H]]];
			Print[StringJoin["= ",
				ToString[Map[StringJoin[ToString[g]," * ",
				ToString[#]]&,H]]]];
			Print[StringJoin["= ",ToString[gH]]],Right,
			Print[StringJoin[ToString[H]," * ",ToString[g]]];
			Print[StringJoin["= ",
				ToString[Map[StringJoin[ToString[#]," * ",
				ToString[g]]&,H]]]];
			Print[StringJoin["= ",ToString[gH]]]]
		]
		
GroupoidElementsRows[S_,w_]:=
	Module[{n = Length[S], h,rects,lines,text},
	h = n/w;
	rects = Table[Rectangle[{i-1, j-1}, {i, j}],{j,h,1,-1},{i,w}];
	lines =	Join[Table[Line[{{0,j},{w,j}}],{j,0,h}],
		Table[Line[{{i,0},{i,h}}],{i,0,w}]];
	text = MapThread[Text[#1, #2]&,
		{S,Flatten[Table[{i-.5,j-.5},{j,h,1,-1},{i,w}],1]}];
	{rects,lines,text}
]

CosetVisual[G_,H_,gH_,side_] := 
		Module[{els,w,h,n,rects,lines,text,lc,pos,crects},
	lc = If[side===Left,LeftCosets[G,H],RightCosets[G,H]];
	pos = Position[Map[Sort,lc],Sort[gH]]//Flatten//First;
	els = lc//Flatten[#,1]&;
	n = Length[els];
	w = Length[H];
	h = n/w;
	{rects,lines,text} = GroupoidElementsRows[els,w];
	crects = If[Sort[H]===Sort[gH],
		{Magenta,rects[[1]],Cyan,Table[Rectangle[{i-1,h-1},{i,h-.5}],{i,w}]},
		{Magenta,rects[[1]],Cyan,rects[[pos]]}];
	Graphics[{crects,RGBColor[1,1,1],Rectangle[{-1,h-1},{0,h}],
	Rectangle[{w,h-1},{w+1,h}],	RGBColor[0,0,0],lines,text,
		{Magenta,Rectangle[{0, -0.5}, {1, -0.1}]},
		{Cyan,Rectangle[{0, -1.0}, {1, -0.6}]},
		Text["subgroup",{1.1,-0.3},{-1,0}],
		Text["coset",{1.1,-0.8},{-1,0}]}]
]

Options[LeftCosetVisual]={DisplayFunction -> $DisplayFunction};

LeftCosetVisual[G_,H_,gH_,g_,opts___] := 
	Module[{h, n = Length[Elements[G]],w = Length[H],
		cv = CosetVisual[G,H,gH,Left],
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[LeftCosetVisual]}],
		pos = Position[Map[Sort,LeftCosets[G,H]],Sort[gH]]//Flatten//First,dy},
	h = n/w;
	dy = If[Sort[H]===Sort[gH],.3, .5];
	Show[{cv,Graphics[
		{Text[StringJoin[ToString[g]," ",OperatorSymbol[G]],{-.25,h-.5},{1,0}],
		Blue,Line[{{w+.1,h-dy},{w+.5,h-dy},{w+.5,h-pos+dy}}],
		Arrow[{w+.5,h-pos+dy},{w+.1,h-pos+dy},HeadCenter->.2]}]},showopts,
		DisplayFunction -> df]]

Options[RightCosetVisual]={DisplayFunction -> $DisplayFunction};

RightCosetVisual[G_,H_,gH_,g_,opts___] := 
	Module[{h, n = Length[Elements[G]],w = Length[H],
		cv = CosetVisual[G,H,gH,Right],
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[RightCosetVisual]}],
		pos = Position[Map[Sort,LeftCosets[G,H]],Sort[gH]]//Flatten//First,dy},
	h = n/w;
	dy = If[Sort[H]===Sort[gH],.3, .5];
	Show[{cv,Graphics[
		{Text[StringJoin[OperatorSymbol[G]," ",ToString[g]],{w+.25,h-.5},{-1,0}],
		Blue,Line[{{-.1,h-dy},{-.5,h-dy},{-.5,h-pos+dy}}],
		Arrow[{-.5,h-pos+dy},{-.1,h-pos+dy},HeadCenter->.2]}]},showopts,
		DisplayFunction -> df]]

FindCosetPosition[cl_,co_] :=
	(Position[Flatten[cl,1],First[co]]//Flatten//First)/
		Length[co]//Ceiling 
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
50.2 finding all left or right cosets
:[font = input; initialization; preserveAspect; endGroup]
*)
Cosets[G_?GroupoidQ,H_List,side_] := Module[{op = Operation[G],
	findcoset},
	findcoset[{els_,cosetlist_,mside_}] := 
			Module[{temp,g,cs = cosetlist},
		temp = Fold[DeleteCases[#1, #2]&,els,Last[cs]];
		If[temp=!={}, g = First[temp];
			AppendTo[cs,Map[If[mside===Left,op[g,#]&,
				op[#,g]&],H]]];
		{temp,cs,side}];
	FixedPoint[findcoset,{Elements[G],{H},side}][[2]]
]
 
Options[LeftCosets]={Mode -> Computational};

LeftCosets[G_?GroupoidQ, H_?GroupoidQ, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		LeftCosets[G, Elements[H], opts],
		Message[Operation::fail]; $Failed]

LeftCosets[G_?GroupoidQ, H_List] := LeftCosets[G,H] =
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]];$Failed,
		If[(LeftMeans/.Flatten[{Options[LeftCosetPrivate]}])===ElementOnLeft,
			Cosets[G,H,Left],Cosets[G,H,Right]]]

LeftCosets[G_?GroupoidQ, H_List, LeftMeans -> lm_] :=
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]];$Failed,
		If[lm===ElementOnLeft,
			Cosets[G,H,Left],Cosets[G,H,Right]]]

LeftCosets[G_?GroupoidQ,H_List, opts___?OptionQ] := 
		Module[{lm,mymode,sc,lc},
	lm = LeftMeans/.Flatten[{opts, Options[LeftCosetPrivate]}];
	mymode = Mode/.Flatten[{opts, Options[LeftCosets]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]],
		lc = If[lm===ElementOnLeft,Cosets[G,H,Left],Cosets[G,H,Right]];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint", 
		LeftCosets,mymode,lc,{G,H,lc},
			{G,H,lc,opts},{Null},{Null},sc]]]

LeftCosetsTextual[G_,H_,gH_] := BothCosetsTextual[G,H,gH]
		
RightCosetsTextual[G_,H_,gH_] := BothCosetsTextual[G,H,gH]
	
BothCosetsTextual[G_,H_,cl_] :=
	(Print[StringJoin["Given the group ",AbstractAlgebra`Core`Private`StructureName[G],
	" and subgroup ",ToString[H],", the following is the 
	list of cosets:\n"]];
If[$VersionNumber < 2.5,
	Do[Print[ToString[cl[[i]]]], {i,Length[cl]}],
	TableForm[cl, TableDepth -> 1]];)

LeftCosetsVisual[G_,H_,gH_,opts___] := BothCosetsVisual[G,H,gH,opts]
		
RightCosetsVisual[G_,H_,gH_,opts___] := BothCosetsVisual[G,H,gH,opts]
		
Options[BothCosetsVisual]={DisplayFunction -> $DisplayFunction};

BothCosetsVisual[G_,H_,cl_,opts___] := 
		Module[{ind = Length[cl],gLines, gText, rects, crects,table,
			els = Flatten[cl,1],headings,len,coloredRects,hsz = Length[H],
			rl,
			showopts = FilterOptions[Graphics,opts],
			df = DisplayFunction/.Flatten[{opts, Options[BothCosetsVisual]}]},
	{gLines, gText, rects} = AbstractAlgebra`Core`Private`basicCayley[G,els, CayleyForm -> CayleyForm[G]]; 
	len = Length[els];
	rl = MapThread[Rule[BackgroundColors[[#1]],BackgroundColors[[#2]]]&,
		{Range[len],Table[i,{i,ind},{hsz}]//Flatten}];
	table = AbstractAlgebra`Core`Private`makeTable[G,els];
	coloredRects = Table[{Part[BackgroundColors,i],
		Map[rects[[#[[1]],#[[2]]]]&, Select[Position[table,
		Part[els,i]],(Length[#]==2)&]]},{i, len}];
	headings = Table[{Part[BackgroundColors,i],
			Rectangle[{i-1, len}, {i, len+1}]},{i,len}];
	headings = Join[headings,Table[{Part[BackgroundColors,i],
			Rectangle[{-1, len-i}, {0, len-i+1}]},{i,len}]];
	crects = {coloredRects,headings};
	Do[crects = crects/.rl[[Range[(i-1)*hsz+1,i*hsz]]],{i,ind}];
	If[AbstractAlgebra`Core`Private`WideElementsQ[G],
		AbstractAlgebra`Core`Private`PrintCayleyKey[els,AbstractAlgebra`Core`Private`StructureName[G],G, KeyForm[G]]];
	Show[{Graphics[crects],gLines, gText},showopts,
		DisplayFunction -> df]
]

Options[RightCosets]={Mode -> Computational};

RightCosets[G_?GroupoidQ, H_?GroupoidQ, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		RightCosets[G, Elements[H], opts],
		Message[Operation::fail]; $Failed]

RightCosets[G_?GroupoidQ,H_List] := RightCosets[G, H] =
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]];$Failed,
		If[(LeftMeans/.Flatten[{Options[LeftCosetPrivate]}])===ElementOnLeft,
		Cosets[G,H,Right],Cosets[G,H,Left]]]

RightCosets[G_?GroupoidQ,H_List, LeftMeans -> lm_] := 
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]];$Failed,
		If[lm===ElementOnLeft,
		Cosets[G,H,Right],Cosets[G,H,Left]]]

RightCosets[G_?GroupoidQ,H_List, opts___?OptionQ] := 
		Module[{lm,mymode,sc,lc},
	lm = LeftMeans/.Flatten[{opts, Options[LeftCosetPrivate]}];
	mymode = Mode/.Flatten[{opts, Options[RightCosets]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]],
		lc = If[lm===ElementOnLeft,Cosets[G,H,Right],Cosets[G,H,Left]];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint",
		RightCosets,mymode,lc,{G,H,lc},
			{G,H,lc,opts},{Null},{Null},sc]
]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
50.3 normal subgroups, factor and quotient groups
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Options[Index]={Mode -> Computational};

Index[G_?GroupoidQ, H_?GroupoidQ, opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		Index[G, Elements[H], opts],
		Message[Operation::fail]; $Failed]

Index[G_?GroupoidQ, H_List, opts___?OptionQ] := Module[{mymode,sc,index},
	mymode = Mode/.Flatten[{opts, Options[RightCosets]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	If[!SubgroupQ[H,G], Message[MemberQ::sbgrp,H,AbstractAlgebra`Core`Private`StructureName[G]],
		index = Length[Elements[G]]/Length[H];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Joint",
		Index,mymode,index,{G,H,index},
			{G,H,opts},{Null},{Null},sc]]]

IndexTextual[G_,H_,index_] := 
	If[!AbstractAlgebra`Core`Private`multipleQ, IndexTextualGD[G]; 
		IndexTextualLI[G,H,index],
		If[AbstractAlgebra`Core`Private`a, 
			IndexTextualGD[G]; IndexTextualLI[G,H,index];
			AbstractAlgebra`Core`Private`firstPassQ = False,
			IndexTextualLI[G,H,index]]]
			
IndexTextual[G_,H_,index_] := 
Print[StringJoin["Given a subgroup H of a group G, we say the index
of the subgroup H in G is the number of left (or right) cosets of H
in G."]]

IndexTextualGD[_] := 
Print["Given a subgroup H of a group G, we say the index
of the subgroup H in G is the number of left (or right) cosets of H
in G."]

Options[IndexVisual]={DisplayFunction -> $DisplayFunction};

IndexVisual[G_,H_,opts___] := 
		Module[{els,w,h,n,rects,lines,text,lc,pos,crects,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[IndexVisual]}]},
	lc = LeftCosets[G,H];
	els = lc//Flatten[#,1]&;
	n = Length[els];
	w = Length[H];
	h = n/w;
	{rects,lines,text} = GroupoidElementsRows[els,w];
	crects = Table[{Hue[i/h],rects[[i]]},{i,h}];
	Show[Graphics[{crects,RGBColor[0,0,0],lines,text}],showopts,
		DisplayFunction -> df]
]

NormalQ[N_?GroupoidQ, G_?GroupoidQ,  opts___?OptionQ] := 
	If[Operation[G] === Operation[N],
		NormalQ[Elements[N], G,  opts],
		Message[Operation::fail]; False]
		
NormalQ[N_List, G_?GroupoidQ] := NormalQ[N,G] =
	If[!SubgroupQ[N,G], Message[MemberQ::sbgrp,N,AbstractAlgebra`Core`Private`StructureName[G]]; False,
		Apply[And,Map[Union[LeftCoset[G,N,#]]===
			Union[RightCoset[G,N,#]]&,Elements[G]]]]
		
(* for a visual - use SubgroupQVisual2 if good - not sure
if not normal *)

goodrepresentation[G_,N_,reps_,cosets_] := 
	Module[{id,ok,idcoset,cl = Length[Elements[G]]/Length[N]},
	ok = Length[reps]===cl;
	If[ok,
		idcoset = First[cosets];
		ok = Fold[DeleteCases[#1,{x___,#2,y___}]&,cosets,reps]==={};
		If[!ok,Message[QuotientGroup::badrep,reps];{ok,{999}},
		(*{ok,Intersection[idcoset,reps]}],*)
		{ok,{GroupIdentity[G]}}],
	Message[QuotientGroup::replngth,cl];	
	{ok,{999}}]
]

ElementToCoset[Q_?GroupoidQ, el_] := 
	Module[{G, type, form, cosets, reps, coset, rep,opsymb},
	G = AbstractAlgebra`Joint`Private`numerator /. Q[[3,5]];
	opsymb = OperatorSymbol[G];
	If[ElementQ[el,G],
		form = formused /. Q[[3,5]];
		cosets = cosetlist /. Q[[3,5]];
		reps = cosetreps /. Q[[3,5]];
		coset = Flatten[Select[cosets, MemberQ[#, el]&],1];
		rep = First[Flatten[Select[reps,MemberQ[coset,#]&],1]];
		coset = Switch[form,
			CosetLists, coset,
			Representatives, rep,
			Cosets, If[opsymb === "+", acoset[rep,NS],
				mcoset[rep,NS]]],
		Message[MemberQ::elmnt, el, 
			AbstractAlgebra`Core`Private`StructureName[G]]; $Failed]]
	
FactorGroup[args___] := QuotientGroup[args]

Options[QuotientGroup]={Mode -> Computational, 
	Form -> Cosets, Representatives -> Canonical};
	
Options[QuotientGroupExtra]={ShowMessage -> True};

QuotientGroup[G_?GroupoidQ, N_?GroupoidQ, opts___?OptionQ] := 
	If[Operation[G] === Operation[N],
		QuotientGroup[G, Elements[N], opts],
		Message[Operation::fail]; $Failed]
	
MessageCount[QuotientGroup,NS] = 0;

QuotientGroup[G_?GroupoidQ, N_List, opts___?OptionQ] := QuotientGroup[G, N, opts] =
	Module[{cosets,reps,mymode,sc,form,repmethod,QG,els,lm,
		opsy=OperatorSymbol[G],id,ok=True,rands, sm},
If[NormalQ[N,G],
	mymode = Mode/.Flatten[{opts, Options[QuotientGroup]}];
	form = Form/.Flatten[{opts, Options[QuotientGroup]}];
	sm = ShowMessage/.Flatten[{opts, Options[QuotientGroupExtra]}] &&
		MessageCount[QuotientGroup,NS] < 5;
	repmethod = Representatives/.Flatten[{opts, Options[QuotientGroup]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	cosets = LeftCosets[G,Sort[N]];
	If[repmethod===Canonical,
		reps = Map[First,cosets];
		id = GroupIdentity[G], (*else *)
		If[repmethod === Random,
			rands = Table[Random[Integer,{1,Length[cosets[[1]]]}],
				{Length[cosets]}];
			reps = MapThread[Part,{cosets,rands}]; 
			id = GroupIdentity[G], (*else *)
			reps = repmethod;
			{ok,{id}} = goodrepresentation[G,N,reps,cosets]]];
If[ok,
	If[form===Cosets,
		If[opsy==="+", 
			Format[acoset[id,NS]] := HoldForm[NS];
			Format[acoset[NS,id]] := HoldForm[NS],
			Format[mcoset[id,NS]] := HoldForm[NS];
			Format[mcoset[NS,id]] := HoldForm[NS]];
		Format[acoset[a_,NS]] := HoldForm[a + NS];
		Format[acoset[NS,a_]] := HoldForm[NS + a];
		Format[mcoset[a_,NS]] := HoldForm[a * NS];
		Format[mcoset[NS,a_]] := HoldForm[NS * a]];
	If[form===Representatives,
		QG = FormGroupoid[reps, QGRepProd[G,cosets,#1,#2,reps]&,OperatorSymbol[G],
			GroupoidName -> AbstractAlgebra`Core`Private`StructureName[G]<>"/NS", IsAGroup -> True,
			AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{Identity[G]},
			{},{},{cosetlist -> cosets, cosetreps -> reps, numerator -> G, formused -> form}}],
		If[form===CosetLists,
			QG = FormGroupoid[cosets, QGListProd[G,cosets,#1,#2,reps]&,OperatorSymbol[G],
				GroupoidName -> AbstractAlgebra`Core`Private`StructureName[G]<>"/NS", WideElements -> True,
				IsAGroup -> True,
				AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{N},{},{},
				{cosetlist -> cosets, cosetreps -> reps, numerator -> G, formused -> form}}],
			If[opsy==="+",
				els = Map[acoset[# , NS]&,reps];
				QG = FormGroupoid[els, QGCosetSum[G,cosets,#1,#2,reps]&,OperatorSymbol[G],
					WideElements -> True,KeyForm -> OutputForm, IsAGroup -> True,
					GroupoidName -> AbstractAlgebra`Core`Private`StructureName[G]<>"/NS",
					AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{N},{},{},
					{cosetlist -> cosets, cosetreps -> reps, numerator -> G, formused -> form}}],
				els = Map[mcoset[# , NS]&,reps];
				QG = FormGroupoid[els, QGCosetProd[G,cosets,#1,#2,reps]&,OperatorSymbol[G],
					WideElements -> True,KeyForm -> OutputForm,
					GroupoidName -> AbstractAlgebra`Core`Private`StructureName[G]<>"/NS", IsAGroup -> True,
					AbstractAlgebra`Core`Private`ExtraInformation -> {{True},{NS},{},{},
					{cosetlist -> cosets, cosetreps -> reps, numerator -> G, formused -> form}}]];
		If[sm,MessageCount[QuotientGroup,NS]++; Message[QuotientGroup::NS,N]]];
		];
	normalG[QG] = NS[Apply[Sequence,N]];
	QG, $Failed],
Message[Group::notnorm,N,GroupoidName[G]];$Failed]]

(* consider a visual mode with two side-by-side Cayley tables,
one using LeftCosetsVisual and the other the Cayley Table of
quotient *)

CosetToList[G_?GroupoidQ, acoset[a_, NS]] := 
	Select[cosetlist /. G[[3,5]], MemberQ[#, a]&]//First
	
CosetToList[G_?GroupoidQ, mcoset[a_, NS]] := 
	Select[cosetlist /. G[[3,5]], MemberQ[#, a]&]//First

CosetToList[G_?GroupoidQ, acoset[NS, a_]] := 
	Select[cosetlist /. G[[3,5]], MemberQ[#, a]&]//First

CosetToList[G_?GroupoidQ, mcoset[NS, a_]] := 
	Select[cosetlist /. G[[3,5]], MemberQ[#, a]&]//First

CosetToList[G_?GroupoidQ, coset_] := Module[{rep, a, opsy =
		OperatorSymbol[G], lc, ok},
	rep = Switch[Head[coset],
		Symbol, If[coset===NS, If[opsy === "+", 0, 1], Null],
		Plus, If[opsy === "+", coset /. a_ + NS :> a, Null],
		Times, If[opsy =!= "+", coset /. a_ NS :> a, Null],
		_, Null];
	lc = cosetlist /. G[[3,5]];
	ok = MemberQ[Flatten[lc, 1], rep];
	If[ok, 	Select[lc, MemberQ[#,rep]&]//First,
		Message[CosetToList::illformed, coset]; $Failed]]

QGRepProd[G_,cosets_,g_,h_,reps_] := 
		Module[{op = Operation[G],Gprod,coset,prod},
	Gprod = op[g,h];
	coset = Select[cosets, MemberQ[#,Gprod]&]//First;
	prod = Select[reps,MemberQ[coset,#]&]//First]

QGListProd[G_,cosets_, gl_List,hl_List,reps_] := Module[{pr},
	pr = QGRepProd[G, cosets, First[gl], First[hl],reps];
	Select[cosets, MemberQ[#,pr]&]//First]
	
findcosetproduct[G_,cosets_,g_,h_,reps_] := 
		Module[{coset},
coset = Select[cosets, MemberQ[#,Operation[G][g,h]]&]//First;
Select[reps,MemberQ[coset,#]&]//First]

QGCosetSum[G_,cosets_,(a_:id) + NS,(b_:id)+ NS,reps_] := 
		Module[{g,h,gi = GroupIdentity[G]},
	{g,h} = {a,b}/. id -> gi;
	acoset[findcosetproduct[G,cosets,g,h,reps], NS]]

QGCosetSum[G_,cosets_,NS + (a_:id),NS + (b_:id),reps_] := 
		Module[{g,h,gi = GroupIdentity[G]},
	{g,h} = {a,b}/. id -> gi;
	acoset[findcosetproduct[G,cosets,g,h,reps], NS]]

QGCosetSum[G_,cosets_,acoset[a_ ,NS],acoset[b_,NS],reps_] := 
		acoset[findcosetproduct[G,cosets,a,b,reps], NS]

QGCosetSum[G_,cosets_,acoset[NS,a_],acoset[NS,b_],reps_] := 
		acoset[findcosetproduct[G,cosets,a,b,reps], NS]

QGCosetProd[G_,cosets_,(a_:id) * NS,(b_:id)* NS,reps_] := 
		Module[{g,h,gi = GroupIdentity[G]},
	{g,h} = {a,b}/. id -> gi;
	mcoset[findcosetproduct[G,cosets,g,h,reps], NS]]

QGCosetProd[G_,cosets_,NS * (a_:id),NS * (b_:id),reps_] := 
		Module[{g,h,gi = GroupIdentity[G]},
	{g,h} = {a,b}/. id -> gi;
	mcoset[findcosetproduct[G,cosets,g,h,reps], NS]]

QGCosetProd[G_,cosets_,mcoset[NS,a_],mcoset[NS,b_],reps_] := 
	mcoset[findcosetproduct[G,cosets,a,b,reps], NS]
		
QGCosetProd[G_,cosets_,mcoset[a_,NS],mcoset[b_,NS],reps_] := 
	mcoset[findcosetproduct[G,cosets,a,b,reps], NS]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 Disguising
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 DisguiseGroupoid
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[DisguiseGroupoid] = {Randomize -> False};

DisguiseGroupoid[G_?GroupoidQ, rules:{_Rule..},opts___?OptionQ] :=
	Module[{mymode,scramble,els = Elements[G]},
mymode = Mode/.Flatten[{opts, Options[DisguiseGroupoid]}];
scramble = Randomize/.Flatten[{opts, Options[DisguiseGroupoid]}];
els = If[scramble,Randomize[els],els];
FormGroupoid[els/.rules,
	GenericOperation[G,rules,#1,#2]&, GroupoidName -> "???"]
]

DisguiseGroupoid[G_?GroupoidQ,opts___?OptionQ] := 
	DisguiseGroupoid[G,GenericRules[If[
	Randomize/.Flatten[{opts, Options[DisguiseGroupoid]}],
	Randomize[Elements[G]],Elements[G]]],opts]

GenericOperation[G_?GroupoidQ,rules:{_Rule..},g_,h_] :=
	Module[{op = Operation[G], a, b},
{a,b} = Map[First,Flatten[Map[Position[rules,#]&,{g,h}],1]];
op[rules[[a,1]],rules[[b,1]]]/.rules
]

GenericRules[els_List] := 
	If[Length[els] < 27, MapThread[Rule,{els,
		Map[FromCharacterCode,Range[97,Length[els]+96]]}]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 DisguiseRingoid
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DisguiseRingoid[R_?RingoidQ, opts___]:=
	Module[{AG=DisguiseGroupoid[AGroupoid[R],opts]},
		FormRingoid[Elements[AG], Operation[AG], 
			Operation[DisguiseGroupoid[MGroupoid[R], opts]],
    	RingoidName -> "???"]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 99. Wrap up Joint
:[font = input; initialization; preserveAspect]
*)
End[];

Protect[NS];

EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
