(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 3. Is this a group?
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should have already seen the definition of a group and be familiar with the basic group properties: being closed, identity, inverse, and associativity (and commutativity).
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
Given a set of elements, and some operation on the elements, will this form a group? This lab will explore a number of pairs consisting of a set and an operation. A Cayley table for the set and operation is presented and the user is asked which of the defining properties of a group hold for this pair.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
3.3 When do we have a group?
:[font = text; inactive; preserveAspect]
We know that before we can call a set with an operation a group, it must satisfy certain properties. Namely, the set must be closed under the operation, there must be an identity element, each element must have an inverse and the operation needs to be associative. Our goal is to determine which, if any, of the above properties hold when presented a set with an operation. Before we begin, we need to read in the necessary code used in this lab:
;[s]
11:0,0;58,1;63,0;125,1;131,0;170,1;178,0;214,1;221,0;252,1;263,0;447,-1;
2:6,16,12,Times,0,14,0,0,0;5,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect]
When you evaluate ShowOne[Lab3] to obtain the first problem, you will be shown something similar to what is given below:
;[s]
3:0,0;18,1;31,0;121,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; inactive; Cclosed; preserveAspect; rightWrapOffset = 540; startGroup]
ShowOne[Lab3] (* DON'T evaluate - just open up *)
:[font = print; inactive; locked; preserveAspect; rightWrapOffset = 540]
The alleged group consists of the set of elements
{4, 0, 1, 3, 2}
 and the operator is myPower. This is case number 15. Below is the
 Cayley table for this alleged group.
:[font = postscript; PostScript; formatAsPostScript; output; inactive; locked; preserveAspect; rightWrapOffset = 540; pictureLeft = 34; pictureWidth = 265; pictureHeight = 287; endGroup]
%!
%%Creator: Mathematica
%%AspectRatio: 1.085 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0274206 0.15873 [
[ 0 0 0 0 ]
[ 1 1.085 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 1.085 L
0 1.085 L
closepath
clip
newpath
p
p
p
p
1 1 0 r
p
.5 .66234 m
.5 .82107 L
.65873 .82107 L
.65873 .66234 L
F
P
P
p
1 .753 .796 r
p
.18254 .66234 m
.18254 .82107 L
.34127 .82107 L
.34127 .66234 L
F
.5 .50361 m
.5 .66234 L
.65873 .66234 L
.65873 .50361 L
F
P
P
p
1 .5 0 r
p
.81746 .66234 m
.81746 .82107 L
.97619 .82107 L
.97619 .66234 L
F
.81746 .50361 m
.81746 .66234 L
.97619 .66234 L
.97619 .50361 L
F
.18254 .34488 m
.18254 .50361 L
.34127 .50361 L
.34127 .34488 L
F
.34127 .34488 m
.34127 .50361 L
.5 .50361 L
.5 .34488 L
F
.5 .34488 m
.5 .50361 L
.65873 .50361 L
.65873 .34488 L
F
.65873 .34488 m
.65873 .50361 L
.81746 .50361 L
.81746 .34488 L
F
.81746 .34488 m
.81746 .50361 L
.97619 .50361 L
.97619 .34488 L
F
.81746 .18615 m
.81746 .34488 L
.97619 .34488 L
.97619 .18615 L
F
P
P
p
.74 .99 .79 r
p
.5 .18615 m
.5 .34488 L
.65873 .34488 L
.65873 .18615 L
F
P
P
p
.678 .847 .902 r
p
.18254 .02742 m
.18254 .18615 L
.34127 .18615 L
.34127 .02742 L
F
.34127 .02742 m
.34127 .18615 L
.5 .18615 L
.5 .02742 L
F
.5 .02742 m
.5 .18615 L
.65873 .18615 L
.65873 .02742 L
F
.65873 .02742 m
.65873 .18615 L
.81746 .18615 L
.81746 .02742 L
F
P
P
P
p
p
1 1 0 r
.18254 .82107 m
.18254 .9798 L
.34127 .9798 L
.34127 .82107 L
F
P
p
1 .753 .796 r
.34127 .82107 m
.34127 .9798 L
.5 .9798 L
.5 .82107 L
F
P
p
1 .5 0 r
.5 .82107 m
.5 .9798 L
.65873 .9798 L
.65873 .82107 L
F
P
p
.74 .99 .79 r
.65873 .82107 m
.65873 .9798 L
.81746 .9798 L
.81746 .82107 L
F
P
p
.678 .847 .902 r
.81746 .82107 m
.81746 .9798 L
.97619 .9798 L
.97619 .82107 L
F
P
p
1 1 0 r
.02381 .66234 m
.02381 .82107 L
.18254 .82107 L
.18254 .66234 L
F
P
p
1 .753 .796 r
.02381 .50361 m
.02381 .66234 L
.18254 .66234 L
.18254 .50361 L
F
P
p
1 .5 0 r
.02381 .34488 m
.02381 .50361 L
.18254 .50361 L
.18254 .34488 L
F
P
p
.74 .99 .79 r
.02381 .18615 m
.02381 .34488 L
.18254 .34488 L
.18254 .18615 L
F
P
p
.678 .847 .902 r
.02381 .02742 m
.02381 .18615 L
.18254 .18615 L
.18254 .02742 L
F
P
P
P
p
p
1 1 1 r
.008 w
.18095 .02583 Mdot
P
p
p
1 Mabswid
.02381 .02742 m
.02381 .9798 L
s
.02381 .02742 m
.97619 .02742 L
s
.02381 .18615 m
.97619 .18615 L
s
.02381 .34488 m
.97619 .34488 L
s
.02381 .50361 m
.97619 .50361 L
s
.02381 .66234 m
.97619 .66234 L
s
.02381 .82107 m
.97619 .82107 L
s
.02381 .9798 m
.97619 .9798 L
s
.18254 .02742 m
.18254 .9798 L
s
.34127 .02742 m
.34127 .9798 L
s
.5 .02742 m
.5 .9798 L
s
.65873 .02742 m
.65873 .9798 L
s
.81746 .02742 m
.81746 .9798 L
s
.97619 .02742 m
.97619 .9798 L
s
P
P
p
2.6 Mabswid
.18254 .02742 m
.18254 .9798 L
s
.02381 .82107 m
.97619 .82107 L
s
P
P
p
p
[(4)] .2619 .74171 0 0 Mshowa
[(16)] .42063 .74171 0 0 Mshowa
[(2)] .57937 .74171 0 0 Mshowa
[(8)] .7381 .74171 0 0 Mshowa
[(1)] .89683 .74171 0 0 Mshowa
[(16)] .2619 .58298 0 0 Mshowa
[(256)] .42063 .58298 0 0 Mshowa
[(4)] .57937 .58298 0 0 Mshowa
[(64)] .7381 .58298 0 0 Mshowa
[(1)] .89683 .58298 0 0 Mshowa
[(1)] .2619 .42425 0 0 Mshowa
[(1)] .42063 .42425 0 0 Mshowa
[(1)] .57937 .42425 0 0 Mshowa
[(1)] .7381 .42425 0 0 Mshowa
[(1)] .89683 .42425 0 0 Mshowa
[(9)] .2619 .26552 0 0 Mshowa
[(81)] .42063 .26552 0 0 Mshowa
[(3)] .57937 .26552 0 0 Mshowa
[(27)] .7381 .26552 0 0 Mshowa
[(1)] .89683 .26552 0 0 Mshowa
[(0)] .2619 .10679 0 0 Mshowa
[(0)] .42063 .10679 0 0 Mshowa
[(0)] .57937 .10679 0 0 Mshowa
[(0)] .7381 .10679 0 0 Mshowa
[(Ind)] .89683 .10679 0 0 Mshowa
P
p
[(2)] .10317 .74171 0 0 Mshowa
[(4)] .10317 .58298 0 0 Mshowa
[(1)] .10317 .42425 0 0 Mshowa
[(3)] .10317 .26552 0 0 Mshowa
[(0)] .10317 .10679 0 0 Mshowa
P
p
[(2)] .2619 .90044 0 0 Mshowa
[(4)] .42063 .90044 0 0 Mshowa
[(1)] .57937 .90044 0 0 Mshowa
[(3)] .7381 .90044 0 0 Mshowa
[(0)] .89683 .90044 0 0 Mshowa
P
p
P
[(^)] .10317 .90044 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd

:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Note that the Cayley table may have the elements (in the headings) in a different order than stated in the written description. (Before making the table, they are randomized---for this lab only.) The properties of closure, identity and inverses should be readily observable from this Cayley table. Associativity is a little more difficult. We will use a function that randomly tests for associativity, testing 25 triples by default. Since what is shown above is identified as "case number 15", the argument to our function is LG[15] (for Lab Groupoid number 15.). Evaluate the cell below.
;[s]
3:0,0;526,1;532,0;589,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 540]
RandomAssociativeQ[LG[15]]
:[font = text; inactive; preserveAspect]
If you wish to change the number of tests, add this number as the second argument as shown below:
:[font = input; preserveAspect; rightWrapOffset = 540; endGroup]
RandomAssociativeQ[LG[15], 30]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.4 Now your turn
:[font = special3; inactive; preserveAspect]
Q1. Use ShowOne[Lab3] to bring up an alleged group. With careful examination of the Cayley table, you should be able to answer the following. (First, indicate the "case number" of the alleged group.)

(a) Determine if the set is closed under the given operation; if so, why is it, and if not, why not. 

(b) Determine if there is an identity element; if so, state it, and if not, why not. 

(c) Determine the inverse of each element, for those where one exists. 

(d) Use the associativity test to make a conjecture whether the operation is associative or not. (Remember to specify the particular case number in the argument of LG[].)

(e) Although not a required property to be a group, determine if this operation is commutative.

(f) Finally, determine whether the set with the operation is indeed a group. (Guess, if you are not fully convinced about the associativity.)
;[s]
4:0,1;2,0;8,2;21,0;875,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ShowOne[Lab3]
;[s]
4:0,1;7,0;8,1;12,0;14,-1;
2:2,12,10,Courier,1,12,0,0,0;2,12,9,Times,1,12,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q2. Repeat the instructions from Question 1. (Again, indicate the "case number" of the alleged group for this question.)
;[s]
2:0,1;2,0;121,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect]
ShowOne[Lab3]
;[s]
4:0,1;7,0;8,1;12,0;14,-1;
2:2,12,10,Courier,1,12,0,0,0;2,12,9,Times,1,12,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q3. Repeat the instructions from Question 1. (Again, indicate the "case number" of the alleged group for this question.)
;[s]
2:0,1;3,0;121,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect]
ShowOne[Lab3]
;[s]
4:0,1;7,0;8,1;12,0;14,-1;
2:2,12,10,Courier,1,12,0,0,0;2,12,9,Times,1,12,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q4. Repeat the instructions from Question 1. (Again, indicate the "case number" of the alleged group for this question.)
;[s]
2:0,1;2,0;121,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect]
ShowOne[Lab3]
;[s]
4:0,1;7,0;8,1;12,0;14,-1;
2:2,12,10,Courier,1,12,0,0,0;2,12,9,Times,1,12,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.5 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?ShowOne
:[font = input; preserveAspect; endGroup; endGroup]
?RandomAssociativeQ
^*)
