(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 8. Isomorphisms
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should be familiar with the basic properties of groups to be able to compare the various pairs of groups that you will be asked to examine. No previous labs are necessary.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab explores the notion of isomorphisms. First we define an isomorphism and then we see how one can be constructed. Next, we explore when two groups are isomorphic.
;[s]
3:0,0;65,1;76,0;170,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.3 What is an isomorphism?
:[font = text; inactive; preserveAspect]
Before beginning, we read in the necessary code for this lab:
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect]
Let's consider two groups, G1 and G2 as defined below.
:[font = input; preserveAspect]
G1 = U[10]
G2 = Z[4]
:[font = text; inactive; preserveAspect]
An important question in abstract algebra (and in mathematics in general) is "When are two objects the 'same' by some appropriate measurement?". In this case, are groups G1 and G2 the same? Clearly they have different elements and different operations, so they are not identical. They do, however, both have 4 elements and in this way they are the same. Therefore, we can construct a one-to-one, onto function (bijection) from G1 to G2. In fact, there are 24 different ways of setting up such functions.
:[font = special3; inactive; preserveAspect]
Q1. Explain how one comes up with 24 different bijections from G1 to G2. How many functions (bijections or not) from G1 to G2?
;[s]
2:0,1;2,0;127,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
If we only consider the number of elements (four in each, in our case), we ignore a large portion of the richness of groups. When we only consider this, the operation is being ignored altogether. Since each group has a special element, the identity, it may be reasonable to want to match these up.
;[s]
3:0,0;24,1;30,0;298,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
GroupIdentity[G1]
GroupIdentity[G2]
:[font = text; inactive; preserveAspect]
Thus, if we want to define a function f : G1 -> G2 that somehow illustrates "sameness," we might want to define f(1) = 0.
;[s]
3:0,0;45,1;47,0;122,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[f]
f[1] = 0
:[font = special3; inactive; preserveAspect]
Q2. With this assumption, how many different bijections are there from G1 to G2?
;[s]
2:0,1;2,0;81,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
We need three more matches to make a bijection. Consider the element 3 in G1. To what should it be mapped? Is there any special property related to 3 that should also exist with the element in G2 to which it will be mapped? What about the order of 3?
:[font = input; preserveAspect]
OrderOfElement[G1, 3]
:[font = text; inactive; preserveAspect]
It would seem reasonable to want to map this to an element in G2 of the same order. What are the orders of the elements in G2?
:[font = input; preserveAspect]
OrderOfAllElements[G2]
:[font = text; inactive; preserveAspect]
If the output is not clear, ask about the function:
:[font = input; preserveAspect]
?OrderOfAllElements
:[font = text; inactive; preserveAspect]
So we see that the two elements 1 and 3 in G2 both have order 4. (Of course, you may have already known this, but this illustrates a general process one might take.) Suppose that we map 3 in G1 to 1 in G2.
:[font = input; preserveAspect]
f[3] = 1
:[font = special3; inactive; preserveAspect]
Q3. With this assumption, now how many different bijections are there from G1 to G2?
;[s]
4:0,1;2,0;26,2;30,0;85,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Since we are mapping 3 to 1, it might be reasonable to map the inverse of 3 in G1 to the inverse of 1 in G2. (Again, you should already know the results of the following, but this illustrates a general procedure.)
:[font = input; preserveAspect]
GroupInverse[G1, 3]
GroupInverse[G2, 1]
:[font = text; inactive; preserveAspect]
So we will map 7 in G1 to 3 in G2:
:[font = input; preserveAspect]
f[7] = 3
:[font = text; inactive; preserveAspect]
Since |g| = |g^(-1)|, we know that the orders in this assignment match. The two remaining elements are put together by default:
:[font = input; preserveAspect]
f[9] = 2
:[font = text; inactive; preserveAspect]
Do the orders match in this case?
:[font = input; preserveAspect]
OrderOfElement[G1, 9]
OrderOfElement[G2, 2]
:[font = text; inactive; preserveAspect]
Indeed. If all we care about is whether orders match up, we are done and we might call these two groups the same. 

There might be other issues to consider, however. In G1, when we multiply 7 by 9 we get 3:
:[font = input; preserveAspect]
op1 = Operation[G1];
op1[7, 9]
:[font = text; inactive; preserveAspect]
Let's review our definition of f:
:[font = input; preserveAspect]
?f
:[font = text; inactive; preserveAspect]
We see that 7 is mapped to 3 and 9 is mapped to 2. What happens if we add 3 (the image of 7) and 2 (the image of 9) in G2? Surely we get 1.
:[font = input; preserveAspect]
op2 = Operation[G2];
op2[3, 2]
:[font = text; inactive; preserveAspect]
More importantly, observe that 1 = 3 + 2 = f(7) + f(9) but also 1 = f(3) = f(7 * 9). In other words, 
;[s]
3:0,0;79,1;81,0;102,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
f(7 * 9) = f(7) + f(9).
;[s]
3:0,0;4,1;6,0;24,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect]
Note that on the left-hand side, the operation inside the parentheses is taking place inside G1 (the domain of f), while the operation on the right-hand side is taking place inside G2. In this case, we say f is "operation preserving" for the elements 7 and 9. What about other pairs? We can make a table and check all possibilities:
:[font = input; preserveAspect]
els = Elements[G1]
Table[f[op1[Part[els, i], Part[els, j]]] == 
	op2[f[Part[els, i]], f[Part[els, j]]], {i, 4}, {j, 4}]
:[font = text; inactive; preserveAspect]
Or if you want to see more details:
:[font = input; preserveAspect]
ListOperationPreservingElements[f, G1, G2]
:[font = text; inactive; preserveAspect]
This shows that the function f is operation preserving for all the elements in G1. This is when algebraists are satisfied with calling two groups G1 and G2 the same: there exists a bijection f : G1 -> G2 that is operation-preserving in the sense that 
;[s]
3:0,0;198,1;200,0;252,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
f(x * y) = f(x) * f(y)
;[s]
5:0,0;4,1;5,0;16,1;17,0;23,-1;
2:3,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect]
for all elements x and y in G1 (with the understanding that on the left-hand side the operation taking place between x and y is the operation in G1 and the operation taking place on the right-hand side between f(x) and f(y) is taking place in G2). In such a case, the two groups are said to be isomorphic and the defining function f is said to be an isomorphism.
;[s]
4:0,0;294,1;304,0;349,1;363,-1;
2:2,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q4. Change G1 to U[8] and determine if U[8] and Z[4] are isomorphic. If so, provide the isomorphism; if not, indicate why not. (Clear[f] before beginning.)
;[s]
4:0,1;2,0;128,2;136,0;156,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.4 Creating Morphoids
:[font = text; inactive; preserveAspect]
In previous labs, we have used a structure called a Groupoid when we to worked with groups. Now we use a structure called a Morphoid to work with morphisms, including homomorphisms and isomorphisms. Recall from the previous section that an isomorphism f between two groups is a bijective (one-to-one and onto) mapping such that f(x * y) = f(x) * f(y) for all elements x and y in the domain. If we relax the condition that f is bijective, and only require the "operation-preserving" part, we have a homomorphism. A Morphoid is a structure that has the potential of being a homomorphism (and therefore potentially also an isomorphism).

Recall that our function f was defined as follows:
;[s]
13:0,0;52,3;60,0;124,3;132,0;332,1;333,0;344,1;345,0;498,2;511,0;514,3;522,0;686,-1;
4:7,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;1,16,12,Times,2,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[f];
f[1] = 0;
f[3] = 1;
f[7] = 3;
f[9] = 2;
:[font = text; inactive; preserveAspect]
We can use FormMorphoid to create a Morphoid based on f.
;[s]
5:0,0;11,1;23,0;36,1;44,0;57,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
func1 = FormMorphoid[f, U[10], Z[4]]
:[font = text; inactive; preserveAspect]
Alternatively we can set up a list of rules that are equivalent to f.
:[font = input; preserveAspect]
rules = Map[Rule[#, f[#]]&, Elements[U[10]]]
:[font = text; inactive; preserveAspect]
The FormMorphoid function can also handle a list of rules to create a Morphoid.
;[s]
5:0,0;4,1;16,0;70,1;78,0;80,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
func1alt = FormMorphoid[rules, U[10], Z[4]]
:[font = text; inactive; preserveAspect]
The two Morphoids func1 and func1alt appear to be different, but they are really the same. Morphoids can be defined either by a list of rules or a function. If the underlying correspondences between the elements of the Groupoids are the same, the Morphoids are considered to be equal.
;[s]
13:0,0;8,1;17,0;18,1;23,0;28,1;36,0;91,1;100,0;219,1;228,0;247,1;256,0;285,-1;
2:7,16,12,Times,0,14,0,0,0;6,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
EqualMorphoidQ[func1, func1alt]
:[font = text; inactive; preserveAspect]
We already know (from above) that func1 is an isomorphism. Let's set this knowledge aside for the moment (for the sake of learning how to use some of the available tools in situations where we don't know if we have an isomorphism). What we want to know is whether, for any given pair of elements in G1, the operations are preserved?

First we will take a specific pair, 9 and 3.
;[s]
3:0,0;34,1;39,0;379,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
PreservesQ[func1, {9, 3}, Mode -> Visual]
:[font = text; inactive; preserveAspect]
In this case, we see that f(9 * 3) does equal f(9) + f(3), since 9 * 3 is 7 in G1 and the image of 7 is 3, which happens to be the sum of 2 (the image of 9) and 1 (the image of 3). Note that the operation in G1 is multiplication (hence, *), whereas it is addition in G2 (and so + is used).

Let's pick two random elements and check out whether the operations of G1 and G2 are preserved under the Morphoid func1 (based on f).
;[s]
5:0,0;396,1;404,0;405,1;410,0;425,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
{g, h} = RandomElements[G1, 2]
PreservesQ[func1, {g, h}, Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q5. Run the two lines of code again several times. Did you find any case where the operations were not preserved? Why or why not?
;[s]
4:0,1;2,0;99,2;103,0;130,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Note that PreservesQ is used when one wishes to explore whether a function is operation preserving for a particular pair of elements. More generally, we are interested in doing this for all possible pairs. The function MorphismQ does this for us. Here we use it in the Visual mode; pairs that are preserved are colored at their point of intersection in the table.
;[s]
11:0,0;10,2;20,0;105,1;115,0;186,1;189,0;219,2;228,0;269,2;275,0;364,-1;
3:6,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
MorphismQ[func1, Mode -> Visual]
:[font = text; inactive; preserveAspect]
One can also check to see if func1 is an isomorphism, besides being a homomorphism:
;[s]
3:0,0;29,1;34,0;84,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
IsomorphismQ[func1]
:[font = text; inactive; preserveAspect]
In case one begins to think that having a homomorphism happens naturally, let's take a look at an example where not all the elements preserve the operation. Below we define a Morphoid func2 that has Z[4] as its domain and Z[5] for its codomain and the rule to get from the domain to the codomain is to take an element from Z[4], add 1, and then reduce this result mod 5.
;[s]
3:0,0;175,1;189,0;371,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
func2 = FormMorphoid[Mod[# + 1, 5]&, Z[4], Z[5]]
:[font = text; inactive; preserveAspect]
Now let's check out which elements preserve the operations:
:[font = input; preserveAspect]
MorphismQ[func2, Mode -> Visual]
:[font = text; inactive; preserveAspect]
We see that some do and some do not. In particular, since the entry at the intersection of the row headed by 1 and column headed by 2 is not colored, func2 is not operation-preserving for the pair (1,2). Let's look at this in detail.
;[s]
3:0,0;150,1;155,0;234,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
PreservesQ[func2, {1, 2}, Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q6. Explain in your own words how and why this failed. Why did the operations not get preserved?
;[s]
2:0,1;2,0;97,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
As you work with homomorphisms in greater detail, you will learn about the kernel and the image of a homomorphism. For the two Morphoids created above, we illustrate how to obtain the kernel and image.
;[s]
3:0,0;127,1;136,0;202,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
K1 = Kernel[func1]
I1 = Image[func1]
:[font = input; preserveAspect]
K2 = Kernel[func2]
I2 = Image[func2]
:[font = text; inactive; preserveAspect]
The operations of these Groupoids are
;[s]
3:0,0;24,1;33,0;38,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[Operation, {K1, I1, K2, I2}]
:[font = special3; inactive; preserveAspect]
Q7. Which of these four (the two kernels and the two images) are groups? Justify your answer.
;[s]
2:0,1;2,0;94,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.5 Seeing isomorphisms
:[font = text; inactive; preserveAspect]
Often, by looking at appropriate data, one can almost literally "see" an isomorphism at hand. Here we look at some examples.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
8.5.1 example 1
:[font = text; inactive; preserveAspect]
Consider the example with which we first started:
:[font = input; preserveAspect]
G1 = U[10]
G2 = Z[4]
:[font = text; inactive; preserveAspect]
Let's look at the Cayley tables of these two groups:
:[font = input; preserveAspect]
CayleyTable[{G1, G2}, Mode -> Visual];
:[font = text; inactive; preserveAspect]
Above we showed that these two groups were isomorphic. Wouldn't one think, then, that their Cayley tables should be identical? Think about why they are not. 

Perhaps if we ordered the elements in the second table in the order corresponding to the first (via our isomorphism), we might obtain different results:
:[font = input; preserveAspect]
CayleyTable[{{G1}, {G2, TheSet -> {0, 1, 3, 2}}}, 
	Mode -> Visual];
	(* note that each group, with its options, needs to
	be in its own list *)
:[font = text; inactive; preserveAspect; endGroup]
This looks better. Now the isomorphism is clear.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
8.5.2 example 2
:[font = text; inactive; preserveAspect]
We will now consider U[10] and another group of order 4:
:[font = input; preserveAspect]
G1 = U[10]
G2 = U[12]
:[font = text; inactive; preserveAspect]
Are these two isomorphic?
:[font = input; preserveAspect]
CayleyTable[{G1, G2}, Mode -> Visual];
:[font = text; inactive; preserveAspect]
Certainly the two tables do not look alike, but we know that this does not necessarily mean that the two groups are not isomorphic. Below we rearrange the elements of U[10].
:[font = input; preserveAspect]
CayleyTable[{{G1, TheSet -> {1, 9, 3, 7}}, {G2}}, 
	Mode -> Visual];
	(* note that each group, with its options, needs to
	be in its own list *)
:[font = special3; inactive; preserveAspect]
Q8. Try other arrangements for the elements in U[10] until you show the two groups are isomorphic or conclude that they are not isomorphic. If they are isomorphic, describe how the isomorphism map works; if they are not isomorphic, explain why not.
;[s]
2:0,1;2,0;249,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
8.5.3 example 3
:[font = text; inactive; preserveAspect]
We now consider the group D2 and its Cayley table.
;[s]
3:0,0;27,1;28,0;51,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
G1 = Dihedral[2]

CayleyTable[G1, Mode -> Visual];
:[font = text; inactive; preserveAspect]
We have seen several other groups of order four. Find one that is isomorphic to D2. Define it below and then show the Cayley tables side by side.
;[s]
3:0,0;81,1;82,0;146,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
G2 = (* <--- fill in your group here *)
;[s]
3:0,0;5,1;39,0;40,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,10,Courier,1,12,0,0,65535;
:[font = input; preserveAspect]
(* make sure G2 has been defined above before preceding *)
CayleyTable[{G1, G2}, Mode -> Visual]
:[font = text; inactive; preserveAspect]
If the elements in G2 are not arranged to properly reflect the isomorphism, do so below.
:[font = input; preserveAspect]
CayleyTable[{{G1},
  {G2, TheSet->{(* fill in the ordered set here *)}}}, 
	Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q9. What is the other group to which Dihedral[2] is isomorphic and what are the details of the isomorphism? (Specify which elements are mapped to which.)
;[s]
2:0,1;2,0;154,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
8.5.4 example 4
:[font = text; inactive; preserveAspect]
Below are several groups of order 6.
:[font = input; preserveAspect]
SL22 = FormGroupoid[{{{0, 1}, {1, 0}}, {{0, 1}, {1, 1}}, 
	{{1, 0}, {0, 1}}, {{1, 0}, {1, 1}}, {{1, 1}, {0, 1}}, 
	{{1, 1}, {1, 0}}}, Mod[#1.#2, 2]&, WideElements -> True,
	GroupoidName -> "SL[2, 2]"];
	(* two-by-two matrices with entries from Z[2] and determinant 1*)

G1 = U[9]
G2 = Z[6]
G3 = Symmetric[3]
G4 = Dihedral[3]
G5 = SL22 
G6 = DirectSum[Z[2], Z[3]] (* pairs {x, y} with x from Z[2] and
	y from Z[3] - operation is done component-wise *)
:[font = text; inactive; preserveAspect]
Are any of these isomorphic to one another? Below are some tools that you may wish to employ:
:[font = input; preserveAspect]
CayleyTable[{G1, G2, G3, G4, G5, G6}, Mode -> Visual];
(* after evaluating this, you may wish to enlarge the 
graphic by selecting it and then dragging from a corner *)
:[font = input; preserveAspect]
AbelianQ[{G1, G2, G3, G4, G5, G6}]
:[font = input; preserveAspect]
CyclicQ[{G1, G2, G3, G4, G5, G6}]
:[font = input; preserveAspect]
OrderOfAllElements[{G1, G2, G3, G4, G5, G6}]//TableForm[#, 
	TableDepth -> 1]&
:[font = input; preserveAspect]
OrderOfAllElements[{G1, G2, G3, G4, G5, G6}, Mode ->Textual];
:[font = input; preserveAspect]
?GroupCenter
:[font = input; preserveAspect]
Map[GroupCenter, {G1, G2, G3, G4, G5, G6}]//ColumnForm
:[font = input; preserveAspect]
?CommutatorSubgroup
:[font = input; preserveAspect]
Map[Elements[CommutatorSubgroup[#]]&,
	{G1, G2, G3, G4, G5, G6}]//ColumnForm
:[font = special3; inactive; preserveAspect]
Q10. If groups H1 and H2 are isomorphic, we denote this by H1  H2. For every pair (Gi, Gj) of groups in {G1, G2, G3, G4, G5, G6}, determine whether Gi  Gj. Note: there are "six-choose-two" such pairs to consider.
;[s]
2:0,1;3,0;215,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q11. You probably found that D3 was isomorphic to at least one of the other groups. Below, we use the variable otherGroup to denote the group you had in mind; change G4 to the group you have in mind and evaluate the following cell. You will now see the list of elements in your chosen group. Between the {} on the right-hand side of orderedElementsOfOtherGroup, place the elements of your chosen group matched up according to the elements of D3. After double-checking your ordering, evaluate the cell and the cell that defines the rules for this isomorphism, as well as the Morphoid f itself. Now use the tools illustrated above and verify that f is indeed an isomorphism (assuming you correctly found an isomorphic group).
;[s]
12:0,1;3,0;30,2;31,0;111,3;121,0;333,3;360,0;443,2;444,0;574,3;582,0;724,-1;
4:6,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,24,16,Times,64,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
otherGroup = G4
Elements[otherGroup]
Elements[Dihedral[3]]
:[font = input; preserveAspect]
orderedElementsOfOtherGroup = {}
:[font = input; preserveAspect]
rules = Transpose[{Elements[Dihedral[3]],
	orderedElementsOfOtherGroup}]/.{x_, y_} -> Rule[x, y]
	
f = FormMorphoid[rules, Dihedral[3], otherGroup]
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Consider the set H = {1, Rot, Rot^2}, which is a subgroup of Dihedral[3]. What is the image of H under f? (You may wish to use the line below.) Is this also a subgroup of the image of Dihedral[3]?
;[s]
2:0,1;3,0;202,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect; endGroup; endGroup]
Image[f, {1, Rot, Rot^2}]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
8.6 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?GroupIdentity
:[font = input; preserveAspect]
?OrderOfElement
:[font = input; preserveAspect]
?OrderOfAllElements
:[font = input; preserveAspect]
?GroupInverse
:[font = input; preserveAspect]
?Operation
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?FormMorphoid
:[font = input; preserveAspect]
?EqualMorphoidQ
:[font = input; preserveAspect]
?PreservesQ
:[font = input; preserveAspect]
?RandomElements
:[font = input; preserveAspect]
?MorphismQ
:[font = input; preserveAspect]
?IsomorphismQ
:[font = input; preserveAspect]
?Kernel
:[font = input; preserveAspect]
?Image
:[font = input; preserveAspect]
?CayleyTable
:[font = input; preserveAspect]
?TheSet
:[font = input; preserveAspect]
?Symmetric
:[font = input; preserveAspect]
?DirectSum
:[font = input; preserveAspect]
?AbelianQ
:[font = input; preserveAspect]
?CyclicQ
:[font = input; preserveAspect]
?GroupCenter
:[font = input; preserveAspect]
?CommutatorSubgroup
:[font = input; preserveAspect]
?ToRules
:[font = input; preserveAspect; endGroup; endGroup]
?InnerAutomorphismGroup
^*)
