(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 12. Normality and factor groups
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
Before attempting this lab you should complete Group Lab 11 (on cosets). 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
After defining a normal subgroup, we try to make some sense of finding an operation to act on cosets. This leads to the development of the quotient or factor group. We conclude by illustrating why normality is important in constructing the factor group.
;[s]
7:0,0;17,1;23,0;139,1;147,0;151,1;157,0;254,-1;
2:4,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.3 Normal subgroups
:[font = text; inactive; preserveAspect]
Suppose we start out, as we did in the last lab, with the dihedral group of order 8, D4. (First, we read in the code needed for this lab.)
;[s]
3:0,0;86,1;87,0;139,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect]
G = Dihedral[4]
:[font = text; inactive; preserveAspect]
Now consider a subgroup of G, say H = {1, Rot^2}, consisting of the identity and the 180 degree rotation.
:[font = input; preserveAspect]
H = {1, Rot^2}
:[font = text; inactive; preserveAspect]
In the last lab we saw that on some occasions a left coset was the same as a right coset. Will this happen in this case? Below is a table consisting of a column of the elements of G, followed by the elements in the left and right cosets of H in G containing g.
:[font = input; preserveAspect]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableDepth -> 2, TableHeadings -> {None, {"g",
	"gH", "Hg\n"}}, TableSpacing -> {0, 1}]
:[font = special3; inactive; preserveAspect]
Q1. Would you say that every left coset gH is equal to the right coset Hg? Why or why not?
;[s]
2:0,1;2,0;91,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider another example. Suppose we have G = U40.
;[s]
3:0,0;47,1;49,0;51,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
G = U[40]
:[font = text; inactive; preserveAspect]
Let H be the subgroup <13>.
:[font = input; preserveAspect]
H = SubgroupGenerated[G, 13]
:[font = text; inactive; preserveAspect]
Let's check out the left cosets gH and right cosets Hg (same g). This time we will let Mathematica do the checking of equality. (You might note that we sort the two cosets before comparing for equality. Why is this done?)
;[s]
3:0,0;87,1;98,0;222,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #],
	Sort[LeftCoset[G, H, #]] === Sort[RightCoset[G, H, #]]}&,
	Elements[G]], TableDepth -> 2, TableHeadings -> {None, {"g",
	"gH", "Hg", "= ?\n"}}, TableSpacing -> {0, 2}]
:[font = text; inactive; preserveAspect]
We repeat this with G = S3 and H = <{1, 3, 2}>.
;[s]
3:0,0;25,1;26,0;48,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect]
G = Symmetric[3]
H = SubgroupGenerated[G, {1, 3, 2}]
:[font = input; preserveAspect]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #],
	Sort[LeftCoset[G, H, #]] === Sort[RightCoset[G, H, #]]}&,
	Elements[G]], TableDepth -> 2, TableHeadings -> {None, {"g",
	"gH", "Hg", "= ?\n"}}, TableSpacing -> {0, 2}]
:[font = text; inactive; preserveAspect]
Here we note that four of the left cosets are not equal to their corresponding right cosets. So we have evidence that equality of left and right cosets is not a general property for all groups or subgroups. This leads to a definition: given a subgroup H of a group G, if gH = Hg for all g in G, we say H is a normal subgroup of G. We can use the function NormalQ to test for normality of a subgroup:
;[s]
7:0,0;155,1;158,0;309,1;315,0;355,2;362,0;400,-1;
3:4,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
NormalQ[H, G]
:[font = text; inactive; preserveAspect]
Note that if we change H to a different subgroup of G we may obtain normality:
:[font = input; preserveAspect]
NormalQ[SubgroupGenerated[G, {2, 3, 1}], G]
:[font = text; inactive; preserveAspect]
Furthermore, note the index of this subgroup in G (i.e., the number of cosets):
;[s]
3:0,0;22,1;27,0;80,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Index[G, SubgroupGenerated[G, {2, 3, 1}]]
:[font = text; inactive; preserveAspect]
An exercise in group theory is to show that any subgroup H whose index in G is 2 will always be normal in G.

Let's try some other groups.
:[font = input; preserveAspect]
NormalQ[{0, 4}, Z[8]]
NormalQ[SubgroupGenerated[U[52], 15], U[52]]
NormalQ[SubgroupGenerated[Dihedral[4], Ref], Dihedral[4]]
:[font = special3; inactive; preserveAspect]
Q2. Suppose G is an Abelian group. What can you say about the normality of any subgroup H of G? Why?
;[s]
2:0,1;2,0;101,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q3. Suppose G is the direct product of Z[5] and U[6]. Let H = <(2, 5)>. Is H normal in G? Give an answer and justification and then check using Mathematica (recalling that DirectProduct is used to obtain the desired direct product).
;[s]
6:0,1;2,0;144,2;155,0;172,3;185,0;233,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.4 Making a new group
:[font = text; inactive; preserveAspect]
Let's consider the group G = Z[8] and H = {0, 4} and investigate the cosets that arise:
:[font = input; preserveAspect]
G = Z[8]
H = {0, 4}
:[font = text; inactive; preserveAspect]
Consider the following four cosets. (Recall that the coset gH is written g + H when the group is written additively.)
:[font = input; preserveAspect]
0 + H
1 + H
2 + H
3 + H
(* if you think Mathematica knows what it is doing here,
understanding cosets, you are mistaken - try 5 + H *)
;[s]
3:0,0;40,1;51,0;135,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,10,Courier,3,12,0,0,0;
:[font = special3; inactive; preserveAspect]
Q4. Why are these the only cosets considered? In other words, why aren't both left cosets and right cosets considered? Additionally, what about the cosets 4 + H, 5 + H, 6 + H and 7 + H?
;[s]
2:0,1;2,0;186,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Suppose we consider these four cosets and think about a way in which we might combine (operate on) any two of these. What might it mean to add two cosets, say 2 + H and 3 + H? As alluded to above, Mathematica doesn't really (yet) know how to add these cosets:
;[s]
3:0,0;197,1;208,0;260,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
(2 + H)
(3 + H)
(2 + H) + (3 + H)
Mod[(2 + H) + (3 + H), 8]
:[font = text; inactive; preserveAspect]
Even reducing these mod 8 is not right. What might it mean to "add" {2, 6} and {3, 7}? Suppose we try all possible sums, and then reduce mod 8: {2 + 3, 2 + 7, 6 + 3, 6 + 7}.
:[font = input; preserveAspect]
{2 + 3, 2 + 7, 6 + 3, 6 + 7}
:[font = text; inactive; preserveAspect]
Reduce mod 8:
:[font = input; preserveAspect]
Mod[%, 8]
:[font = text; inactive; preserveAspect]
Reduce by removing duplicates:
:[font = input; preserveAspect]
Union[%]
:[font = text; inactive; preserveAspect]
Note that this is really 5 + H (as well as 1 + H). Note also that 2 + 3 = 5. Since 2 + H could have been written as 6 + H, one might wonder if interchanging these would affect how we "add" these cosets. As will likely be proved in your class, it does not.

In fact, given any group G and any normal subgroup N of G, the set of all (left) cosets {gN | g in G} forms a group under the operation (gN)(hN) = (gh)N (shown multiplicatively here -- additively it would be written (g + N) + (h + N) = (g + h) + N). This new group is called the factor group of G by H, or the quotient group of G by H. This is frequently denoted G/H.
;[s]
5:0,0;536,1;548,0;567,1;581,0;625,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
FactorGroup[G, H]
QuotientGroup[G, H]
:[font = input; preserveAspect]
?QuotientGroup
:[font = special3; inactive; preserveAspect]
Q5. Try adding a few of these cosets (as elements of the factor group). On scratch paper, you may wish to make the Cayley table for the group G/H. To what group is this isomorphic?
;[s]
2:0,1;2,0;181,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.5 Factor groups
:[font = text; inactive; preserveAspect]
Maybe you thought about making the Cayley table with Mathematica. (If not, why not?) Let's do so.
;[s]
3:0,0;53,1;64,0;98,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
G = Z[8];
H = {0, 4};

CayleyTable[FactorGroup[G, H]]
:[font = text; inactive; preserveAspect]
Of course, there is also the pretty version:
:[font = input; preserveAspect]
gr1 = CayleyTable[FactorGroup[G, H], Mode -> Visual, 
	Output -> Graphics];
:[font = text; inactive; preserveAspect]
Observe that the elements in the above group are the left cosets of H = {0, 4} in Z8. Just as a reminder, here they are:
;[s]
3:0,0;83,1;84,0;121,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
LeftCosets[G, H]
:[font = special3; inactive; preserveAspect]
Q6. To what group is Z8/{0, 4} isomorphic?
;[s]
3:0,0;22,1;23,0;43,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Here is a visual way of seeing how these cosets interact with each other.
:[font = input; preserveAspect]
gr2 = LeftCosets[G, H, Mode -> Visual, 
	Output -> Graphics];
:[font = text; inactive; preserveAspect]
Putting these two graphics together, we obtain the following:
:[font = input; preserveAspect]
Show[GraphicsArray[{gr1, gr2}]];
:[font = special3; inactive; preserveAspect]
Q7. What observations can you make from considering these two tables? Include an accounting of the coloring of both tables and the "blocking" (colored by "chunks") in the second table.
;[s]
2:0,1;2,0;185,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Recall that the subgroup H = <{1, 3, 2}> is not normal in S3.
;[s]
5:0,0;44,2;47,0;59,1;60,0;62,-1;
3:3,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
NormalQ[SubgroupGenerated[S[3], {1, 3, 2}], S[3]]
:[font = text; inactive; preserveAspect]
How do the left cosets interact in this case?
:[font = input; preserveAspect]
LeftCosets[S[3], SubgroupGenerated[S[3], {1, 3, 2}], 
	Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q8. Before one can form the factor group, the subgroup must be normal. What goes wrong when the subgroup is not normal? Consider the above visualization and answer this question. Focus, in particular, on the last four columns and try to determine why the coloration does not occur in square blocks there. Give specific explanations for the coloring in these last four columns.
;[s]
2:0,1;2,0;377,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Next, we consider the same group and subgroup, but consider the right cosets.
:[font = input; preserveAspect]
RightCosets[S[3], SubgroupGenerated[S[3], {1, 3, 2}], 
	Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q9. Explain why the last four rows occur as they do. Provide explicit details.
;[s]
2:0,1;2,0;79,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q10. Determine another subgroup H of some group G that is not normal in G. Define these below. Now consider the left and right cosets visually, using the cell below your definitions.
;[s]
2:0,1;3,0;183,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
G =  (* <- define your group here *)
H =  (* <- define your subgroup here *)
NormalQ[H, G]
;[s]
5:0,0;5,1;37,0;42,1;77,0;91,-1;
2:3,12,10,Courier,1,12,0,0,0;2,12,10,Courier,1,12,0,0,65535;
:[font = input; preserveAspect]
LeftCosets[G, H, Mode -> Visual]
RightCosets[G, H, Mode -> Visual]
:[font = text; inactive; preserveAspect]
Now let's consider two more examples of normal subgroups and the corresponding products of cosets.
:[font = input; preserveAspect]
G = U[16]
H = SubgroupGenerated[G, 3]
NormalQ[H, G]
;[s]
5:0,0;9,1;10,0;37,1;38,0;52,-1;
2:3,12,10,Courier,1,12,0,0,0;2,12,10,Courier,1,12,0,0,65535;
:[font = input; preserveAspect]
LeftCosets[G, H, Mode -> Visual]
:[font = input; preserveAspect]
G = Z[6]
H = {0, 3}
NormalQ[H, G]
;[s]
5:0,0;8,1;9,0;19,1;20,0;34,-1;
2:3,12,10,Courier,1,12,0,0,0;2,12,10,Courier,1,12,0,0,65535;
:[font = input; preserveAspect]
LeftCosets[G, H, Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q11. For these normal subgroups, why did we only look at the visual representation of the left cosets (and not the right cosets)?
;[s]
2:0,1;3,0;130,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q12. Make a summary statement regarding why normality is a requirement for a quotient group to be a coherent, well-defined structure.
;[s]
2:0,1;3,0;134,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
12.6 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Dihedral
:[font = input; preserveAspect]
?U
:[font = input; preserveAspect]
?LeftCoset
:[font = input; preserveAspect]
?RightCoset
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?SubgroupGenerated
:[font = input; preserveAspect]
?Symmetric
:[font = input; preserveAspect]
?NormalQ
:[font = input; preserveAspect]
?Index
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?Mod
:[font = input; preserveAspect]
?Union
:[font = input; preserveAspect]
?FactorGroup
:[font = input; preserveAspect]
?QuotientGroup
:[font = input; preserveAspect]
?CayleyTable
:[font = input; preserveAspect]
?LeftCosets
:[font = input; preserveAspect]
?Output
:[font = input; preserveAspect]
?RightCosets
:[font = input; preserveAspect; endGroup; endGroup]
?GraphicsArray
^*)
