(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 13. Group homomorphisms
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
It is presumed that the reader is familiar with isomorphisms (Group Lab 8) and cosets (Group Lab 11).
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab explores the concept of group homomorphisms. The ultimate goal is for the reader to understand the relationship between the domain, kernel and image of a homomorphism through the Fundamental Theorem of Group Homomorphisms. 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.3 What is a group homomorphism?
:[font = text; inactive; preserveAspect]
A Note on Terminology: The terms homomorphism and morphism are used synonymously in algebra. Since the former is somewhat more prevalent in textbooks, we will use it here, but in the interest of using shorter names where possible, we use the latter in our Mathematica code.
;[s]
8:0,0;22,1;33,2;46,1;50,2;58,1;256,2;267,1;274,-1;
3:1,16,12,Times,1,14,0,0,0;4,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
A homomorphism from a group (G, *) into a group (H, #) is a function from G into H that preserves the operations between the two groups (* and # respectively). That is, if f is a homomorphism, then for all values of x and y in G,
;[s]
7:0,0;2,2;14,0;32,1;33,0;137,1;138,0;230,-1;
3:4,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect; center]
f(x * y) = f(x) # f(y).
;[s]
3:0,0;4,1;5,0;24,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect]
You should be familiar with the one-to-one, onto variety of these functions, called isomorphisms. Recall that the existence of an isomorphism between two groups establishes that the two groups are "equal" in an algebraic sense. The automorphisms on a group (isomorphisms from a group to itself) help us to categorize groups. Homomorphisms provide us with yet another tool in exploring groups. 

Before continuing, we first read in the code that will be used in this lab.
;[s]
3:0,0;84,1;96,0;471,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect]
To review the notion of preserving an operation, we will start by looking at two functions from the group of integers modulo 12 (Z12) into the group of integers modulo 6 (Z6). Again we use objects called Morphoids and the function FormMorphoid to create them. The first function adds 3 to each element of Z12 and then takes the residue modulo 6 (reduces it mod 6). The second adds 6 before taking the residue modulo 6. 												
;[s]
11:0,0;130,2;132,0;172,2;173,0;204,1;213,0;231,1;243,0;306,2;308,0;432,-1;
3:6,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;3,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
f = FormMorphoid[Mod[# + 3, 6]&, Z[12], Z[6]]
:[font = input; preserveAspect]
g = FormMorphoid[Mod[# + 6, 6]&, Z[12], Z[6]]
:[font = text; inactive; preserveAspect]
Next, we see if either function preserves the operations between the two groups for a specific pair of elements, say 5 and 9. We will use the Visual Mode of PreservesQ to help visualize the process.

First, f:
;[s]
3:0,0;142,1;167,0;210,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
PreservesQ[f, {5, 9}, Mode -> Visual]
:[font = text; inactive; preserveAspect]
The operations are not preserved: f(5 + 9)  f(5) + f(9). So, with this single example, we see that f is not a homomorphism.

Now we look at g. Note: the visual mode displays the name of any function generically as f, but here g is the function we are examining.
;[s]
2:0,0;144,1;263,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
PreservesQ[g, {5, 9}, Mode -> Visual]
:[font = text; inactive; preserveAspect]
For the pair (5, 9), g acts like a homomorphism. Does g satisfy this property for all pairs in Z[12]? We can use MorphismQ to test all pairs. 
;[s]
3:0,0;113,1;122,0;143,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
MorphismQ[g, Mode -> Visual]
:[font = text; inactive; preserveAspect]
If g is replaced with f in the cell above, an opposite color pattern would result.
;[s]
5:0,0;3,1;4,0;22,1;23,0;83,-1;
2:3,16,12,Times,0,14,0,0,0;2,13,9,Times,0,12,0,0,0;
:[font = special3; inactive; preserveAspect]
Q1. There is a simpler way to define g than the function we used. Can you describe it?
;[s]
2:0,1;2,0;87,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.4 The kernel and image
:[font = text; inactive; preserveAspect]
The kernel and image of a homomorphism are special subsets worthy of consideration, the kernel being a subset of the domain and the image a subset of the codomain.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
13.4.1 The kernel
:[font = text; inactive; preserveAspect]
The kernel of a group homomorphism is the set of elements in the domain that map onto the identity of the codomain. Recall that g (defined above) is a homomorphism.
:[font = input; preserveAspect]
Kernel[g]
:[font = text; inactive; preserveAspect]
The Kernel function returns a Groupoid, which we know by now does not in itself imply it is a group (or a subgroup of the domain)
;[s]
5:0,0;4,1;10,0;30,1;38,0;130,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q2. In this case, is the kernel a group (i.e., a subgroup of Z12)?
;[s]
4:0,1;2,0;62,2;64,0;67,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = text; inactive; preserveAspect]
Let's look at some more kernels. Consider the following Morphoids.
;[s]
3:0,0;56,1;65,0;67,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
f2 = FormMorphoid[Mod[#, 5]&, Z[10], Z[5]]
f3 = FormMorphoid[Mod[#, 2]&, Z[10], Z[2]]
f4 = FormMorphoid[2 -> 1, U[25], Z[20]]
f5 = FormMorphoid[2 -> 2, U[25], Z[20]]
f6 = FormMorphoid[Mod[#, 3]&, Z[10], Z[5]]
:[font = text; inactive; preserveAspect]
Let's determine which of these are homomorphisms and compute the kernels:
:[font = input; preserveAspect]
Map[MorphismQ, {f2, f3, f4, f5, f6}]
:[font = input; preserveAspect]
Map[Kernel, {f2, f3, f4, f5, f6}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q3. For which of these five functions is the kernel a group (i.e., a subgroup of the domain)?
;[s]
2:0,1;2,0;94,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q4. If h is a homomorphism and a and b are in K = Kernel[h], explain why a * b must also be in K. (In other words, show K is closed.) Note: closure of a (nonempty) subset of a finite group implies that it is a subgroup.
;[s]
4:0,1;2,0;75,2;76,0;220,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = text; inactive; preserveAspect]
The Mathematica function Kernel acts on any Morphoid. If the codomain has an identity, it will return a Groupoid (returning $Failed otherwise). Recall that f was not a homomorphism.
;[s]
11:0,0;4,1;15,0;25,2;31,0;44,2;52,0;104,2;112,0;124,2;131,0;182,-1;
3:6,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Kernel[f]
ClosedQ[%]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q5. True or false: If f is a Morphoid from some group G into some group H and Kernel[f] is a subgroup of the G, then f is a homomorphism. (See the hint at end of the section, if needed.)
;[s]
4:0,1;2,0;29,2;37,0;187,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = text; inactive; preserveAspect; groupLikeInput]
In some sense, the size of the kernel indicates how much the domain is "reduced" when a homomorphism is applied to it.
:[font = subsubsection; inactive; Cclosed; preserveAspect; groupLikeInput; startGroup]
Hint
:[font = text; inactive; preserveAspect; groupLikeInput; endGroup; endGroup]
Consider G = H = Z[3] and the function that squares its input (mod 3).
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
13.4.2 The image
:[font = text; inactive; preserveAspect]
The image of a homomorphism is the range of the function, and this is a subset of the codomain. We want to know when this subset is a subgroup. For our first homomorphism, g, the image is the whole codomain, and so it is clearly a subgroup. This is a very common situation.
:[font = input; preserveAspect]
Image[g]
:[font = text; inactive; preserveAspect]
Consider the five Morphoids defined above in the kernel section, in addition to f defined at the outset; are the images subgroups of the codomain?
;[s]
3:0,0;18,1;27,0;147,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
{f, f2, f3, f4, f5, f6}//ColumnForm
:[font = input; preserveAspect]
Map[Image, {f, f2, f3, f4, f5, f6}]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q6. Which of these images are subgroups of the given codomain?
;[s]
2:0,1;2,0;63,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q7. Suppose  is a function from the group G into the group H. Consider the following two statements: (i) If  is a homomorphism, then the image of  is a subgroup of H, and (ii) If the image of  is a subgroup of H, then  is a homomorphism. Determine if these statements are true or false. If true, give a proof; if false, provide an example of a Morphoid that demonstrates it is false.
;[s]
4:0,1;2,0;349,2;357,0;389,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.5 Properties that are preserved by homomorphisms
:[font = text; inactive; preserveAspect]
The following results are proven in many abstract algebra texts and so we will simply report them and give a few illustrations.

Homomorphism preservation properties

Let f be a homomorphism from G into H.

(1) f(the identity of G) = the identity of H.
(2) f(x-1) = f(x)-1 for all x in G.
(3) If S is a subgroup of G, then f(S) = {f(s) : s in S} is a subgroup of H.

We will use one homomorphism to illustrate these three properties, mapping the integers modulo 16 into the fourth roots of unity.
;[s]
9:0,0;129,1;167,0;206,1;207,0;260,2;262,0;270,2;272,0;497,-1;
3:5,16,12,Times,0,14,0,0,0;2,16,12,Times,1,14,0,0,0;2,24,16,Times,32,14,0,0,0;
:[font = input; preserveAspect]
G = Z[16]
H = RootsOfUnity[4, Mode -> Visual]
:[font = text; inactive; preserveAspect]
The visual form of RootsOfUnity[4] is given to illustrate that this group is the set of complex numbers (on the unit circle) that satisfy the equation x^4 = 1.
;[s]
3:0,0;19,1;34,0;160,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
The Morphoid will map each integer to that power of i, so that x -> i^x.
;[s]
3:0,0;4,1;12,0;73,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[f];
f = FormMorphoid[(I^#)&, G, H]
:[font = text; inactive; preserveAspect]
The identities here are 0 and 1, respectively. Therefore, by property (1), the element 0 in G should be mapped to the element 1 in H.
:[font = input; preserveAspect]
f[0] == 1
:[font = text; inactive; preserveAspect]
Notice below how the equation is much more explicit in Mathematica than in property (2) above. To test the property we need to specify the groups in which each inversion is taking place. We pick a random element x out of the domain and then test property (2).
;[s]
3:0,0;55,1;66,0;260,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
x = RandomElement[G]
f[GroupInverse[G, x]] == GroupInverse[H, f[x]]
:[font = text; inactive; preserveAspect]
Let's generate a few more examples and place them in a table. The third and fifth columns should match if our Morphoid is a morphism.
;[s]
3:0,0;110,1;118,0;134,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
TableForm[Table[x = RandomElement[G];
	xinv = GroupInverse[G, x];
	fxinv = f[xinv];
	fx = f[x];
	invfx = GroupInverse[H, f[x]];
	{x, xinv, fxinv, fx, invfx}, {10}],
	TableHeadings -> {None, {"x", "x^(-1)", "f(x^(-1))",
		"f(x)", "(f(x))^-1\n"}}]
:[font = text; inactive; preserveAspect]
For property (3), note that the even elements of Z[16] are a subgroup of G.
:[font = input; preserveAspect]
Y = Range[0, 15, 2]
SubgroupQ[Y, G]
:[font = text; inactive; preserveAspect]
Now consider its image:
:[font = input; preserveAspect]
W = Union[Map[f, Y]]
SubgroupQ[W, H]
:[font = text; inactive; preserveAspect]
This too is a subgroup.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q8. Recall the Morphoid f5 defined above (and given below). Verify that these three properties hold for this morphism.
;[s]
4:0,1;2,0;15,2;23,0;119,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = input; preserveAspect; endGroup]
f5 = FormMorphoid[2 -> 2, U[25], Z[20]]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.6 The kernel is normal
:[font = text; inactive; preserveAspect]
The kernel of a homomorphism is not just an ordinary subgroup: it is always a normal subgroup. One proof of this statement is based on the definition of a normal subgroup:
:[font = text; inactive; preserveAspect; center]
H is a normal subgroup of G	if and only if	g-1 h g is in H for all h in H and g in G.
;[s]
6:0,0;44,2;46,1;47,0;48,1;49,0;86,-1;
3:3,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = text; inactive; preserveAspect]
In other words, every conjugate of an element of H is also in H. (Recall that g-1 h g, for some g in G, is a conjugate of h.)
;[s]
6:0,0;79,2;81,1;82,0;83,1;84,0;126,-1;
3:3,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q9. Verify that if f is a homomorphism and k is in K = Kernel[f], then any conjugate of k is also in K.
;[s]
2:0,1;2,0;104,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = text; inactive; preserveAspect]
Since every subgroup of an Abelian group is normal---do you know why?---we need to consider a non-Abelian group to illustrate this last result. Consider the cyclic subgroup generated by Ref in D3.
;[s]
5:0,0;186,1;189,0;194,2;195,0;197,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
H = SubgroupGenerated[Dihedral[3], Ref]
:[font = text; inactive; preserveAspect]
We can choose g to be any element of the group -- here we pick Rot and look at its conjugates.
;[s]
3:0,0;63,1;66,0;95,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[Conjugate[Dihedral[3], #, Rot]&, Elements[H]]
:[font = text; inactive; preserveAspect]
Our result shows that H is not a normal subgroup. (Why?) This also implies something that we can not easily illustrate: H is not the kernel of any homomorphism with domain D3. 

Let's see what kernels we can get from homomorphisms on D3. Suppose that we consider the exponent of the symbol Rot in any element of D3. Recall the elements of D3:
;[s]
13:0,0;173,3;174,0;204,1;207,0;235,3;236,0;290,2;293,0;313,3;314,0;340,3;341,0;343,-1;
4:7,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;4,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
Elements[Dihedral[3]]
:[font = text; inactive; preserveAspect]
Clearly the exponent is an integer in {0, 1, 2}, so let's consider this as a Morphoid into Z3. The Mathematica expression here is a bit complicated because the elements in D3 involve the function NonCommutativeMultiply.
;[s]
11:0,0;77,2;85,0;92,3;93,0;99,1;110,0;173,3;174,0;196,2;218,0;220,-1;
4:6,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
xifunction = Exponent[#/.{NonCommutativeMultiply -> Times},
	Rot]&
:[font = text; inactive; preserveAspect]
We put the Morphoid into rules-form to make it easier to read.
;[s]
3:0,0;11,1;19,0;63,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
xi = FormMorphoid[xifunction, Dihedral[3], Z[3]]//ToRules
:[font = text; inactive; preserveAspect]
Now consider the kernel.
:[font = input; preserveAspect]
Kernel[xi]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q10. Since the kernel of xi is {1, Ref}, what immediate conclusion should we draw regarding xi? You might want to use PreservesQ or MorphismQ to verify your answer.
;[s]
6:0,1;3,0;118,2;128,0;132,2;141,0;165,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542]
Answer: 
:[font = text; inactive; preserveAspect]
Let's do the same as above, but with the exponent of Ref:
;[s]
3:0,0;53,1;56,0;58,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
taufunction = Exponent[#/.{NonCommutativeMultiply -> Times},
	Ref]&
:[font = input; preserveAspect]
tau = FormMorphoid[taufunction, Dihedral[3], Z[2]]//ToRules
:[font = text; inactive; preserveAspect]
We get a different kernel here:
:[font = input; preserveAspect]
K = Kernel[tau]
:[font = text; inactive; preserveAspect]
Is the kernel normal? We can use the function NormalQ.
;[s]
3:0,0;46,1;53,0;55,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
NormalQ[K, Dihedral[3]]
:[font = text; inactive; preserveAspect]
Alternatively, we can ask whether tau is a homomorphism.
:[font = input; preserveAspect]
MorphismQ[tau]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 540]
Q11. Explain why checking the value of MorphismQ[tau] gives us more information than does NormalQ[K, Dihedral[3]]. 
;[s]
6:0,1;3,0;39,2;53,0;90,2;113,0;116,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 542; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.7 The First Homomorphism Theorem
:[font = text; inactive; preserveAspect]
Recall that normality is exactly the condition on a subgroup required in order for its left (or right) cosets to form a group. If f is a homomorphism from G into H with kernel K, we will examine the quotient group G/K. We start with our most recent example.
:[font = input; preserveAspect]
Q = QuotientGroup[Dihedral[3], K]
:[font = text; inactive; preserveAspect]
The quotient group has just two elements and so it clearly must be isomorphic to Z[2], which happens to be the image of tau. Let's formally establish this fact by creating an isomorphism between G/Kernel[tau] and Image[tau].
;[s]
5:0,0;195,1;208,0;213,1;223,0;225,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
FormMorphoidSetup[Q, Image[tau]]
:[font = text; inactive; preserveAspect]
We want to map the identity of the domain to the identity of the codomain, so we define the Morphoid by position using the list {1, 2} to indicate that the first element of Q goes to the first element of Image[tau] and the second to the second.
;[s]
5:0,0;92,1;100,0;204,1;209,0;245,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
theta = FormMorphoid[{1, 2}, Q, Image[tau]]
:[font = input; preserveAspect]
IsomorphismQ[theta]
:[font = text; inactive; preserveAspect]
The isomorphism that we've just created is not coincidental. It follows from the following theorem. 

The Fundamental Homomorphism Theorem Let f be a group homomorphism from G into H with kernel K and image f(G). Then f(G) is isomorphic to G/K, an isomorphism between these two groups being psi: G/K -> f(G) defined by psi(aK) = f(a). 

In the example we computed above, notice how the coset RefNS is mapped to tau[Ref] = 1, while NS = 1NS is mapped to tau[1] = 0.

Virtually every abstract algebra text has a proof of this theorem, or some slight variation of the theorem. For example, one popular text starts with the assumption that f is onto (and so f(G) = H). The proof is still essentially the same. We close this section by illustrating the theorem with two more examples.
;[s]
13:0,0;102,1;139,0;392,2;397,0;411,2;419,0;431,2;433,0;436,2;439,0;453,2;459,0;780,-1;
3:7,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;5,15,11,Courier,0,14,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
13.7.1 Example 2
:[font = text; inactive; preserveAspect]
Consider the direct product Z[5] x Z[5] and map each pair (a, b) into 4a + 3b (mod 5) in Z[5].
:[font = input; preserveAspect]
G = DirectProduct[Z[5], Z[5]]
:[font = input; preserveAspect]
alpha = FormMorphoid[(Mod[Plus@@({4, 3}.#), 5])&, G, Z[5]]
:[font = text; inactive; preserveAspect]
It may not be obvious whether alpha is a homomorphism, so we verify that it is.
:[font = input; preserveAspect]
MorphismQ[alpha]
:[font = text; inactive; preserveAspect]
We compute the kernel and image. 
:[font = input; preserveAspect]
K = Kernel[alpha]
:[font = input; preserveAspect]
Image[alpha]
:[font = text; inactive; preserveAspect]
Notice that alpha is onto, so we can establish an isomorphism between G/K and Z[5].
:[font = input; preserveAspect]
Q2 = QuotientGroup[G, K]
:[font = input; preserveAspect]
gamma = FormMorphoid[alpha[First[#]]&, Q2, Image[alpha]]
:[font = input; preserveAspect]
IsomorphismQ[gamma]
:[font = special3; inactive; preserveAspect]
Q12. Let G = DirectProduct[Z[4], Z[4]] and K = {{0,0}, {0,2}, {2,0}, {2,2}}. To what group is G/K isomorphic? To prove your answer, find a homomorphism from G into some other group that has K as its kernel. 
;[s]
7:0,1;3,0;9,3;38,2;39,0;43,3;75,0;208,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,13,10,Courier,0,12,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
13.7.2 Example 3
:[font = text; inactive; preserveAspect]
In this example, we map the divisors of 42 into the divisors of 30 with the function GCD[#, 30]&. We form the Morphoid between the MixedDivisors Groupoids based on these sets.
;[s]
9:0,0;85,1;96,0;110,1;118,0;131,1;144,0;145,1;154,0;176,-1;
2:5,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?MixedDivisors
:[font = input; preserveAspect]
eta = FormMorphoid[GCD[#, 30]&, MixedDivisors[42], 
	MixedDivisors[30]]
:[font = text; inactive; preserveAspect]
The kernel will be the divisors of 42 that are relatively prime to 30.
:[font = input; preserveAspect]
K = Kernel[eta]
:[font = text; inactive; preserveAspect]
Not every divisor of 30 is in the range, so eta is not onto.
:[font = input; preserveAspect]
Image[eta]
:[font = text; inactive; preserveAspect]
The Fundamental Homomorphism Theorem tells us that the image is isomorphic to the following quotient group.
:[font = input; preserveAspect]
Q3 = QuotientGroup[MixedDivisors[42], K]
:[font = text; inactive; preserveAspect]
The isomorphism we define maps each of these cosets to the image under eta of its first element.
:[font = input; preserveAspect]
theta = FormMorphoid[eta[First[#]]&, Q3, Image[eta]]
:[font = input; preserveAspect]
IsomorphismQ[theta]
:[font = text; inactive; preserveAspect]
Again, our result is not a surprise.

The Fundamental Homomorphism Theorem is occasionally called the First Homomorphism Theorem. You might wonder about a Second Homomorphism Theorem. There is one, and it is often called the "Diamond Homomorphism Theorem." There is also a Third (Zassenhauss' Theorem). These theorems are stated and proved in many introductory abstract algebra books.
:[font = special3; inactive; preserveAspect]
Q13. A square-free integer is an integer that has no square divisors other than 1. For example, 42 and 30 are square-free, while 50 is not. MixedDivisors[m] is a group if and only if m is square-free. As a general rule, if m and n are both square-free integers and we map MixedDivisors[m] into MixedDivisors[n] with the function GCD[#, n]&, what will be the kernel and range of this morphism? 
;[s]
12:0,1;3,0;7,2;27,0;140,3;156,0;272,3;288,0;294,3;310,0;329,3;339,0;394,-1;
4:6,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.8 The alternating group - parity as a morphism
:[font = text; inactive; preserveAspect]
We have seen that every permutation is either odd or even. Now we will think of this classification as a Morphoid mapping Sn into the group {1, -1} with multiplication, which we call IntegerUnits. Here we will work with n = 4.
;[s]
7:0,0;105,2;113,0;123,1;124,0;183,2;195,0;227,-1;
3:4,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
sign = FormMorphoid[Parity, Symmetric[4], IntegerUnits]
:[font = text; inactive; preserveAspect]
This happens to be a significant morphism for any n.
:[font = input; preserveAspect]
MorphismQ[sign]
(* may take some time *)
:[font = text; inactive; preserveAspect]
The kernel is quite significant here. 
:[font = input; preserveAspect]
Kernel[sign]
:[font = special3; inactive; preserveAspect]
Q15. Describe the elements of the kernel in terms of their parity.
;[s]
2:0,1;3,0;67,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
The kernel, which happens to be a normal subgroup of S4, is called the alternating group of degree 4, or A4. This group can be accessed directly without morphisms using Alternating.
;[s]
9:0,0;54,3;55,0;71,1;88,0;106,3;107,0;169,2;180,0;182,-1;
4:5,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
?Alternating
:[font = input; preserveAspect]
Alternating[4]
:[font = text; inactive; preserveAspect; endGroup]
There are many interesting properties of the alternating groups that you can read about in your text.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.9 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?FormMorphoid
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?PreservesQ
:[font = input; preserveAspect]
?Visual
:[font = input; preserveAspect]
?MorphismQ
:[font = input; preserveAspect]
?Kernel
:[font = input; preserveAspect]
?U
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?Image
:[font = input; preserveAspect]
?ClosedQ
:[font = input; preserveAspect]
?RootsOfUnity
:[font = input; preserveAspect]
?RandomElement
:[font = input; preserveAspect]
?GroupInverse
:[font = input; preserveAspect]
?Range
:[font = input; preserveAspect]
?SubgroupQ
:[font = input; preserveAspect]
?Dihedral
:[font = input; preserveAspect]
?SubgroupGenerated
:[font = input; preserveAspect]
?InnerAutomorphism
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?Exponent
:[font = input; preserveAspect]
?NormalQ
:[font = input; preserveAspect]
?QuotientGroup
:[font = input; preserveAspect]
?FormMorphoidSetup
:[font = input; preserveAspect]
?IsomorphismQ
:[font = input; preserveAspect]
?DirectProduct
:[font = input; preserveAspect]
?MixedDivisors
:[font = input; preserveAspect]
?Parity
:[font = input; preserveAspect]
?Symmetric
:[font = input; preserveAspect]
?IntegerUnits
:[font = input; preserveAspect; endGroup; endGroup]
?Alternating
^*)
