(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Group Lab 14: Rotational groups of regular polyhedra
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
14.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
14.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should know how a group can be generated from a set of elements and a binary operation. You should also be familiar with Euler angles (see the Rotations Lab on the CD for a review) and group actions.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
14.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to show how to generate the rotational groups of polyhedra.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
14.3 Example - the Tetrahedron
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
14.3.1 Statement of the problem, first rotation
:[font = text; inactive; preserveAspect]
First, let's read in the packages and definitions that we will need for this lab. 
:[font = input; initialization; preserveAspect; height = 79]
*)
Needs["Graphics`Polyhedra`"];
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
Needs["Geometry`Rotations`"];
Needs["Graphics`Shapes`"];
Needs["NumberTheory`Recognize`"];

wireFrame::usage="wireFrame[polyhedron] draws a labeled wireframe
picture of the polyhedron.";
 
wireFrame[obj_]:=Graphics3D[
  Map[Text[ToString[#],Vertices[obj][[#]]]&,
        Range[1,Length[Vertices[obj]]]]]//
        Show[{WireFrame[obj[]],#},DefaultFont->{"Times",36}]&;

Exact::usage="Exact[x_Real] converts x to an exact number involving
integers and roots (square and cube roots only).";

Exact=Module[{x,t},
   If[Abs[#]<=0.00000001,
         0,
         ((x=#)//Recognize[x,3,t]&//Solve[#==0,t]&//(t/.#)&//
           Select[#,(Abs[x-N[#]]<=0.000001)&]&//First)]]&;

ActionOn::usage="ActionOn[obj, g] is the 3D-graphics object obtained
when rotation matrix g acts on 3D-graphics object obj. This is accomplished
by multiplying every triple of numbers appearing in obj by g.";

ActionOn[obj_,g_]:=
 obj/.{{a_,b_,c_}/;And@@NumberQ/@{a,b,c}:>g.{a,b,c}};

disp::usage="disp[obj] displays list of 3D graphics primitives
in a standard display mode.";

disp=Show[Graphics3D[#],PlotRange->{{-2,2},{-2,2},{-2,2}}]& ;

Compare::usage="Compare[obj, g] displays the 3D-graphics objects
obj and ActionOn[obj, g] side by side.";

Compare=Show[GraphicsArray[
         {Graphics3D[#1,PlotRange->{{-2,2},{-2,2},{-2,2}}],
          Graphics3D[ActionOn[#1,#2],PlotRange->{{-2,2},{-2,2},{-2,2}}]}]]& ;


(*
:[font = text; inactive; preserveAspect]
Consider the tetrahedron.
:[font = input; preserveAspect]
object = Tetrahedron[];
object//disp
:[font = text; inactive; preserveAspect]
We will be examining certain rotation matrices that act on graphics objects like the Tetrahedron. The function ActionOn will be used extensively in this lab.
;[s]
5:0,0;85,1;96,0;111,1;119,0;158,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?ActionOn
:[font = text; inactive; preserveAspect]
We want to consider the rotations that make up the so-called rotational group of the tetrahedron, specifically the ones that rotate a tetrahedron so that it occupies the same space as the original object. We can use the function Compare to visually confirm whether a rotation is in the rotation group.
;[s]
3:0,0;229,1;236,0;302,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?Compare
:[font = text; inactive; preserveAspect]
Here is an example of a rotation that we will not want to consider, because the matrix clearly does not return the object to its original position. 
:[font = input; preserveAspect]
Compare[object, RotationMatrix3D[Pi/6, Pi/4, Pi/8]]
:[font = text; inactive; preserveAspect]
One example of an element in the rotational group of this tetrahedron is RotationMatrix3D[2Pi/3, 0, 0]. The specific Euler angles that describe this matrix are dependent on the position of the tetrahedron. One of the faces of our object lies on a plane that is parallel to the x-y plane and so a 2/3 rotation about the z-axis is in the rotation group. Also, it is important to note that the tetrahedron needs to be centered about the origin. All polyhedra in the standard Mathematica package Polyhedra.m are centered about the origin.
;[s]
7:0,0;73,2;102,0;473,1;484,0;493,2;504,0;536,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
r1 = RotationMatrix3D[2Pi/3, 0, 0];
r1//MatrixForm
:[font = input; preserveAspect; endGroup]
Compare[object, r1]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
14.3.2 Generation of more rotations
:[font = text; inactive; preserveAspect]
It is not too difficult to identify r1 as a member of the rotational group, but how do we identify more complicated rotations? One way is by multiplying rotations. Given any set of rotations, we can generate a group.
;[s]
3:0,0;36,1;38,0;217,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
G1 = GenerateGroupoid[{r1}, Simplify[#1.#2]&]
:[font = text; inactive; preserveAspect]
This is a cyclic subgroup of order three. 
:[font = input; preserveAspect]
Order[G1]
:[font = special3; inactive; preserveAspect]
Q1. Is this the whole rotation group? Based on the fact that the faces of a tetrahedron are four identical equilateral triangles, how many elements would you expect to find in its rotational group?
;[s]
2:0,1;2,0;198,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
14.3.3 Procedure for finding more complicated rotations
:[font = text; inactive; preserveAspect]
Although it may be clear that there are more elements, it is probably not obvious what the other rotation matrices are. At this point, we outline a systematic process to find these matrices.

Let's look at a labeled wire-frame picture of the object.
:[font = input; preserveAspect]
?wireFrame
:[font = input; preserveAspect]
wireFrame[Tetrahedron];
:[font = text; inactive; preserveAspect]
The first rotation that we identified, r1, maps the (ordered) face {1, 3, 4} into the face {1, 2, 3} and by applying it again, into {1, 4, 2}. Now suppose that we want to map, for example, {1, 3, 4} into {4, 3, 2}. Let R be the unknown matrix.
;[s]
5:0,0;39,1;41,0;219,1;220,0;244,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
R = Array[r, {3, 3}]
:[font = text; inactive; preserveAspect]
Before setting up a system of equations to solve for the rotation matrix, we need to take the vertex coordinates given in the Mathematica Polyhedra package and make them exact. For this we use the function Exact. This function is not very sophisticated, but it will work for the kinds of numbers that we will use.
;[s]
9:0,0;126,1;137,0;138,2;147,0;170,1;175,0;206,2;211,0;314,-1;
3:5,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
?Exact
:[font = text; inactive; preserveAspect]
Here are the vertices given in the package.
:[font = input; preserveAspect]
Vertices[Tetrahedron]
:[font = text; inactive; preserveAspect]
The following are exact values.
:[font = input; preserveAspect]
Xvertices = Map[Exact, Vertices[Tetrahedron], {2}]
:[font = text; inactive; preserveAspect]
Although a system can be generated more efficiently, here we write it out a bit more descriptively.
:[font = input; preserveAspect]
sys = 
{R.Xvertices[[1]]==Xvertices[[4]]  (* vertex 1 maps to vertex 4 *),
R.Xvertices[[3]]==Xvertices[[3]]  (* vertex 3 maps to vertex 3 *),
R.Xvertices[[4]]==Xvertices[[2]]  (* vertex 4 maps to vertex 2 *)}
:[font = text; inactive; preserveAspect]
Now we solve the system, use the rules to get values for R, pick out the one and only solution and, finally, simplify the solution.
;[s]
3:0,0;57,1;58,0;132,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
r2 = (R /. Solve[sys, Flatten[R]])//First//Simplify
:[font = text; inactive; preserveAspect]
Now the moment of truth: is r2 in the rotational group?
;[s]
3:0,0;28,1;30,0;56,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Compare[object, r2]
:[font = text; inactive; preserveAspect]
This is the rotation matrix that we were looking for. It would be nice to know the values of phi, theta and psi that produce r2.
;[s]
3:0,0;125,1;127,0;129,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q2. Determining Euler Angles from a Rotation Matrix:
Determine the values of phi, theta and psi for which RotationMatrix3D[phi, theta, psi] is equal to r2. Hint: To equate two matrices, A and B, and convert to a list of equations, you can use code something like (A == B)//Thread[#]&//Map[Thread[#]&,#]&//Flatten.
;[s]
17:0,1;2,0;77,2;80,0;82,2;87,0;92,2;95,0;106,2;139,0;152,2;155,0;186,2;187,0;192,2;193,0;263,2;314,-1;
3:8,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;8,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now that we have two distinct rotations of the tetrahedron, we might be able to generate a larger group.
:[font = input; preserveAspect; endGroup]
G2 = GenerateGroupoid[{r1, r2}, Simplify[#1.#2]&];
Order[G2]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
14.3.4 Verification that we have the complete rotational group
:[font = text; inactive; preserveAspect]
This should be the whole group for which we are searching. Now, to demonstrate how the group generates all the rotations, we mark one face and a vertex of the tetrahedron. 
:[font = input; preserveAspect]
markedFace = object[[2]]//
         {#,
         RGBColor[0.022, 0.688, 0.717],
         Thickness[0.01],
         Line[{Apply[Plus, object[[2, 1]]]/3, 1.1 #[[1,1]]}],
         RGBColor[0.701, 0.038, 0.038],
         PointSize[0.03],
         Point[1.1 #[[1, 1]]]}&//disp;
:[font = text; inactive; preserveAspect]
First, we look at the individual effects of each group element on this face. You may want to enlarge the graphic that you get here.
:[font = input; preserveAspect]
Map[ActionOn[markedFace, #]&, First[G2]]//
	Partition[#, 4]&//GraphicsArray//Show;
:[font = text; inactive; preserveAspect]
Taken together, we get a single tetrahedron with three marks on each face. 
:[font = input; preserveAspect; endGroup; endGroup]
Map[ActionOn[markedFace, #]&, First[G2]]//Show;

:[font = section; inactive; Cclosed; preserveAspect; startGroup]
14.4 Further exercises
:[font = special3; inactive; preserveAspect]
Q3. Rotational Group of the Cube:
(a) How many elements would you expect to find in the group of rotations of the cube?
(b) Generate the group of rotations of Cube[] that is contained in the Polyhedra package. 
;[s]
6:0,1;2,0;159,2;165,0;191,2;200,0;211,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
wireFrame[Cube];
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q4. Rotational Group of the Icosahedron:
(a) How many elements would you expect to find in the group of rotations of the icosahedron?
(b) Generate the group of rotations of Icosahedron[] that is contained in the Polyhedra package. 
;[s]
6:0,1;3,0;173,2;186,0;212,2;221,0;232,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
wireFrame[Icosahedron];
(*Enlarge the graphic if it's too small *)
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q5. Rotational Groups of the Octahedron and Dodecahedron:
The octahedron is the dual of the cube. If each face of the cube is replaced with a point at its center and points that are derived from adjacent faces are connected, then the wire frame of an octahedron will appear. Explain why the rotational group of the octahedron should be isomorphic to that of the cube. The icosahedron and dodecahedron pair up in the same way.
;[s]
2:0,1;2,0;426,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q6. The cuboctahedron can be formed by taking a cube and slicing its six corners off so that the exposed triangular faces just barely meet at one point. It can also be created in the same way starting with an octahedron, thus its name. Determine the number of elements in the rotational group of the cuboctahedron. Is it isomorphic to a group that you've already seen?
;[s]
2:0,1;2,0;369,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
(* This cell must be evaluated to add
 Cuboctahedron to the Polyhedra list *)
AppendTo[Polyhedra, Cuboctahedron];
Cuboctahedron[Graphics`Polyhedra`Private`opts___] := 
  Polyhedron[Cuboctahedron, Graphics`Polyhedra`Private`opts][[1]]
Vertices[Cuboctahedron]^=
Map[N,{{0, -2^(-1/2), -2^(-1/2)}, {0, -2^(-1/2), 2^(-1/2)}, 
 {0, 2^(-1/2), -2^(-1/2)}, {0, 2^(-1/2), 2^(-1/2)}, 
 {-2^(-1/2), 0, -2^(-1/2)}, {-2^(-1/2), 0, 2^(-1/2)}, 
 {-2^(-1/2), -2^(-1/2), 0}, {-2^(-1/2), 2^(-1/2), 0}, 
 {2^(-1/2), 0, -2^(-1/2)}, {2^(-1/2), 0, 2^(-1/2)}, 
 {2^(-1/2), -2^(-1/2), 0}, {2^(-1/2), 2^(-1/2), 0}}, {2}];
Faces[Cuboctahedron]^={{2, 6, 7}, {2, 6, 4, 10}, {2, 10, 11},
{2, 11, 1, 7}, {11, 10, 12, 9}, {6, 8, 5, 7}, {4, 6, 8}, {3, 5, 8},
{1, 5, 3, 9}, {4, 8, 3, 12}, {4, 10, 12}, {1, 11, 9}, {1, 5, 7}, {3, 9, 12}};
(*
:[font = input; preserveAspect]
wireFrame[Cuboctahedron];
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q7. Why should the method of finding rotation matrices used above work? Let T be a triangle in three dimensional real space whose vertices are linearly independent. Prove that if R is a three by three matrix with the property that the triangle R.T (i.e., Dot[R,T]) is congruent to T, then R is a rotation matrix.
;[s]
14:0,1;3,0;76,2;77,0;179,2;180,0;244,2;247,0;255,2;263,0;281,2;282,0;289,2;290,0;313,-1;
3:7,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;6,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
14.5 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?Tetrahedron
:[font = input; preserveAspect]
?Polyhedra
:[font = input; preserveAspect]
?Vertices
:[font = input; preserveAspect]
?RotationMatrix3D
:[font = input; preserveAspect]
?GenerateGroupoid
:[font = input; preserveAspect]
?Order
:[font = input; preserveAspect; endGroup; endGroup]
?Solve
^*)
