(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 3. An ideal part of rings
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
Before attempting this lab, you should have completed Ring Lab 1. You should also be familiar with cosets of normal subgroups.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to develop the concept of an ideal through examples, leading one to discover some of the properties of ideals. Quotient rings are also introduced through the examples.
;[s]
3:0,0;53,1;58,0;192,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.3 What is the ideal part of a ring?
:[font = text; inactive; preserveAspect]
We begin by reading in a package that provides the functionality needed for the lab.
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect]
Let's consider a subset of the integers, Z. 
:[font = input; preserveAspect]
H = Table[i, {i, -40, 40, 5}]
:[font = text; inactive; preserveAspect]
Since we are working on a finite machine, we can only show finite subsets of Z. Imagine, however, that H extends infinitely (in both directions) with the same pattern.
:[font = special3; inactive; preserveAspect]
Q1. Once H is extended as stated, is H a ring? Is it a subring of Z? How do you verify this?
;[s]
2:0,1;2,0;93,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Now consider multiplying every element in the (extended) set H by an element in Z, say 3.
:[font = input; preserveAspect]
M = 3 H
:[font = text; inactive; preserveAspect]
Of course, this only shows a finite part. Are these products in the (extended) set H?
:[font = input; preserveAspect]
Intersection[M, H]
:[font = input; preserveAspect]
H
:[font = text; inactive; preserveAspect]
Certainly some of the elements are in the original subset H. Let's use Mathematica to enlarge our H.
;[s]
3:0,0;71,1;82,0;101,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
H = Table[i, {i, -150, 150, 5}]
SubsetQ[M, H]
:[font = text; inactive; preserveAspect]
By enlarging H (following the given pattern), we see that M = 3 H is a subset of H.
:[font = special3; inactive; preserveAspect]
Q2. M was determined by multiplying by 3 on the left of every element in H. We then found that M was a subset of (the enlarged) H. Is there anything special about 3? Could this work for other integers? Does the multiplication need to occur on the left? Justify your answers.
;[s]
2:0,1;2,0;275,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q3. Consider the M we found by multiplying H by 3. Actually, consider the extended M found by multiplying the extended H by 3. In other words, consider 3 <5>. Is this a ring? Is this a subring of Z? Is this a subring of (the extended) H (i.e., <5>)?
;[s]
2:0,1;2,0;250,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Let's try another subset of the integers:
:[font = input; preserveAspect]
P = Table[i, {i, -49, 50, 5}]
:[font = special3; inactive; preserveAspect]
Q4. What happens if we multiply P on the left by 3? Call this result M (as before). What is the intersection of M and P? Adopt the notation that EX means the infinite, extended version of the finite X. (This notation will be used below as well, so take note.) What can you say about the intersection of EM and EP? Try to prove your result.
;[s]
2:0,1;2,0;340,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q5. What makes P different from H? How do they differ in their properties?
;[s]
2:0,1;2,0;75,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Consider another subset.
:[font = input; preserveAspect]
K = Table[i, {i, -48, 50, 3}]
:[font = special3; inactive; preserveAspect]
Q6. Let M be the result of multiplying K by some integer q. Answer the kinds of questions that were asked in the questions above regarding sets H and P.
;[s]
2:0,1;2,0;153,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Hopefully, above you made the observation that EP and EH are both cosets in the group Z/EH, with EP = 1 + <5> while EH = <5>. (For the moment, think of Z/EH as a group and not a ring.)
:[font = text; inactive; preserveAspect]
Let's take a look at one more example.
:[font = input; preserveAspect]
R = Z[12]
els = Elements[R]
:[font = text; inactive; preserveAspect]
Now consider two subsets of the elements of R.
:[font = input; preserveAspect]
NR = {0, 3, 6, 9}
H = {0, 5, 7}
:[font = text; inactive; preserveAspect]
What happens if we multiply the set NR and the set H by an element r in R? Suppose we use r = 5.
:[font = input; preserveAspect]
5 NR
5 H
:[font = text; inactive; preserveAspect]
Whoops! We need to remember that the multiplication really has to be taking place mod 12.
:[font = input; preserveAspect]
Mod[5 NR, 12]
Mod[5 H, 12]
:[font = text; inactive; preserveAspect]
Now repeat this for all elements r in R:
:[font = input; preserveAspect]
TableForm[Map[{#, Mod[# NR, 12]}&, els], TableDepth -> 2, 
	TableHeadings -> {None, {"k", "k*{0,3,6,9}\n\n"}}]
	(* working with NR *)
:[font = input; preserveAspect]
TableForm[Map[{#, Mod[# H, 12]}&, els], TableDepth -> 2, 
	TableHeadings -> {None, {"k", "k*{0,3,6,9}\n\n"}}]
	(* working with H *)
:[font = special3; inactive; preserveAspect]
Q7. Consider the sets NR and H and let r be any element in R. What can you say about the sets r NR and r H? What difference(s) between NR and H cause the results shown above?
;[s]
2:0,1;2,0;175,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
3.3.1 The definition:
:[font = text; inactive; preserveAspect]
Given a ring R and a subring J of the ring R, we call J a (two-sided) ideal of R if for every element r in R and for every element x in J we have both r x and x r in J.
;[s]
3:0,0;70,1;75,0;169,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q8. Describe the examples of ideals that we have seen thus far.
;[s]
2:0,1;2,0;64,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
3.3.2 Another ring
:[font = text; inactive; preserveAspect]
Consider the ring of two-by-two matrices with entries from Z[2]. 
:[font = input; preserveAspect]
M = Mat[Z[2], {2, 2}]
:[font = text; inactive; preserveAspect]
You can count the elements; there are 16.
:[font = input; preserveAspect]
Elements[M]
Length[Elements[M]]
:[font = text; inactive; preserveAspect]
As defined above, although M is a ring, it is not a Ringoid in Mathematica. Let's make it one.
;[s]
5:0,0;52,2;59,0;63,1;74,0;95,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
R = ToRingoid[Mat[Z[2], 2]]
:[font = text; inactive; preserveAspect]
Consider two subsets of R:
:[font = input; preserveAspect]
H = {{{1, 0}, {0, 1}}, {{0, 0},{0, 0}}, {{1, 0}, {0, 0}}, 
	{{0, 0}, {0, 1}}};

MatrixForm[H]
:[font = input; preserveAspect]
K = {{{1, 0}, {0, 1}}, {{0, 0}, {0, 0}}, {{1, 0}, {0, 0}}, 
	{{0, 0}, {0, 1}}, {{0, 0}, {1, 0}}, {{1, 0}, {1, 0}}, 
	{{0, 0}, {1, 1}}, {{1, 0}, {1, 1}}};

MatrixForm[K]
:[font = text; inactive; preserveAspect]
You can verify by hand, or check the following, that these are indeed subrings of R.
:[font = input; preserveAspect]
SubringQ[H, R]
(* may take a little time *)
:[font = input; preserveAspect]
SubringQ[K, R]
(* may take a little time *)
:[font = text; inactive; preserveAspect]
Are H and K ideals? We need to pick an element in R and multiply it by an element in H (or K) and see if we land back in H (or K). For example, let M1 be the following matrix in R.
:[font = input; preserveAspect]
(M1 = {{1, 1}, {0, 0}})//MatrixForm
:[font = text; inactive; preserveAspect]
What happens if we try multiplying as we did earlier?
:[font = input; preserveAspect]
M1 H
:[font = special3; inactive; preserveAspect]
Q9. This is a Mathematica question, not an algebraic one--answer it if you can. What went wrong?
;[s]
4:0,1;2,0;14,2;25,0;97,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Recall that the multiplication of R can be obtained as follows.
:[font = input; preserveAspect]
op = Multiplication[R];
(* no output is given *)
:[font = text; inactive; preserveAspect]
We can Map the operation op, with M1 as one of the operands, across the whole set H.
;[s]
5:0,0;7,1;10,0;25,1;27,0;85,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[op[M1, #]&, H]
:[font = text; inactive; preserveAspect]
Is it true that M1 * N1 is in H for every element N1 in H? If not, what does this say about H being an ideal? If so, what does this say about H being an ideal?
:[font = special3; inactive; preserveAspect]
Q10. Is H an ideal? What about K?
;[s]
2:0,1;3,0;34,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Note that both H and K are normal subgroups of the additive group of R:
:[font = input; preserveAspect; endGroup; endGroup]
NormalQ[H, AdditiveGroupoid[R]]
NormalQ[K, AdditiveGroupoid[R]]
(* may take some time *)
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.4 Ideals factor into other ring properties
:[font = text; inactive; preserveAspect]
Consider the ring R and subset B as defined below:
:[font = input; preserveAspect]
R = Z[15]
B = {0, 3, 6, 9, 12}
:[font = text; inactive; preserveAspect]
Observe that B is an ideal of R.
:[font = input; preserveAspect]
IdealQ[B, R]
:[font = text; inactive; preserveAspect]
We know that B is a normal subgroup of R when we view R as an additive group. Therefore, the quotient group R/B makes sense and we can talk about the cosets as elements. Each coset has the form x + B where x is an element of R. We already know how to add cosets: (x + B) + (y + B) = x + y + B. Can we form a product with these cosets? How about multiplying x + B times y + B to yield x y + B? We need to verify that this is a valid, well-defined operation, which we leave to your text and/or classroom. With this, we can form the quotient ring (also known as the factor ring) R/B.
;[s]
5:0,0;529,1;543,0;562,1;574,0;581,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
QR = QuotientRing[R, B]
:[font = text; inactive; preserveAspect]
Here is an example of how the multiplication works:
:[font = input; preserveAspect]
Multiplication[QR][2 + NS, 2 + NS]
:[font = text; inactive; preserveAspect]
Consider the Cayley tables of this quotient ring.
:[font = input; preserveAspect]
CayleyTables[QR, Mode -> Visual]
:[font = special3; inactive; preserveAspect]
Q11. To what ring is this quotient ring isomorphic?
;[s]
2:0,1;3,0;52,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
3.4 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect]
?Table
:[font = input; preserveAspect]
?Intersection
:[font = input; preserveAspect]
?SubsetQ
:[font = input; preserveAspect]
?Union
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?Mod
:[font = input; preserveAspect]
?Z
:[font = input; preserveAspect]
?Mat
:[font = input; preserveAspect]
?Length
:[font = input; preserveAspect]
?FormGroupoid
:[font = input; preserveAspect]
?FormRingoid
:[font = input; preserveAspect]
?SubringQ
:[font = input; preserveAspect]
?Multiplication
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?NormalQ
:[font = input; preserveAspect]
?IdealQ
:[font = input; preserveAspect]
?QuotientRing
:[font = input; preserveAspect; endGroup; endGroup]
?CayleyTables
^*)
