(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 4. What does Z[i]/<a+bi> look like?
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
Prior to working on this lab, you should be familiar with the term ideal through discussions in class or from Ring Lab 3: An ideal part of rings. One should also be familiar with an integral domain, field, and the characteristic of a ring.
;[s]
3:0,0;67,1;72,0;240,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 504; startGroup]
4.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to explore the quotient structure of the Gaussian integers modulo an ideal generated by an arbitrary Gaussian integer.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.3 First example
:[font = text; inactive; preserveAspect]
To work on this lab, we need to load the necessary packages.
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect]
Consider the problem of investigating the ideal J = <2 + 2i> in the Gaussian integers, Z[i]. In particular, what does the quotient ring Z[i]/<2 + 2i> look like?

First, recall that the set of Gaussian integers is the set {a + b i | a, b in Z}. This forms a lattice in the plane:
:[font = input; preserveAspect]
gr = IntegerLatticeGrid[{-6, 6}, {-6, 6}, 
	AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect]
Now consider the ideal generated by z = 2 + 2i.
:[font = input; preserveAspect]
z = 2 + 2 I
:[font = text; inactive; preserveAspect]
What elements are in this ideal? We know, by definition, that all elements of the form r z (where r is in Z[i]) are in this ideal. Suppose we consider r to be an (ordinary) integer and multiply this by z. We might as well try a number of integers at a time.
:[font = input; preserveAspect]
someMultipliers = Table[k, {k, -3, 3}]
:[font = input; preserveAspect]
idealList = someMultipliers z
:[font = text; inactive; preserveAspect]
Let's plot these on our lattice. To use ListPlot, we need to convert these complex numbers to ordered pairs.
;[s]
3:0,0;40,1;48,0;109,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
plotOfIdeals = ListPlot[Map[ComplexToPoint, idealList],
	PlotStyle -> {PointSize[0.030], RGBColor[1, 0, 0]},
	DisplayFunction -> Identity];
	
Show[{gr, plotOfIdeals}];
:[font = text; inactive; preserveAspect]
What other multiples should we consider? We could multiply by multiples of i.
:[font = input; preserveAspect]
addToIdealList = Table[k I, {k, -3, 3}] z
:[font = input; preserveAspect]
idealList = Join[idealList, addToIdealList]
:[font = text; inactive; preserveAspect]
Now look at the set of multiples that we have so far.
:[font = input; preserveAspect]
plotOfIdeals = ListPlot[Map[ComplexToPoint, idealList],
	PlotStyle -> {PointSize[0.030], RGBColor[1, 0, 0]},
	AspectRatio -> Automatic,
	DisplayFunction -> Identity];
	
Show[{gr, plotOfIdeals}];
:[font = text; inactive; preserveAspect]
To make sense of this picture, recall that multiplying a complex number by i has the effect of increasing the argument of the complex number (the angle between it and the positive x-axis) by 90 degrees. This explains why the original diagonal is rotated to give us the pattern above.

There are still quite a few elements in the ideal that reside in this rectangle that are not being shown. Perhaps we should multiply all the complex numbers in this grid by z, and then plot all the products that are still within the grid.
:[font = input; preserveAspect]
g = 6; (* our grid window is 6 by 6 *)

pts = Table[{i, j},{i, -g, g}, {j, -g, g}]//Flatten[#, 1]&; 
(* find all integer lattice points in this window *)

cpts = Map[Apply[Complex, #]&, pts]; 
(* convert to the corresponding complex numbers *)

idealList = Intersection[cpts, z cpts] 
(* calculate the product of z times all the points 
determined in cpts and then keeps those still
within the grid (thus the Intersection) *)
:[font = text; inactive; preserveAspect]
Here is the new plot.
:[font = input; preserveAspect]
plotOfIdeals = ListPlot[Map[ComplexToPoint, idealList],
	PlotStyle -> {PointSize[0.030], RGBColor[1, 0, 0]},
	AspectRatio -> Automatic, DisplayFunction -> Identity];
			
Show[{gr, plotOfIdeals}];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q1. We now see all the elements in J = <2+2i> that are within the window shown. How many elements are there in Z[i]/J? In other words, how many other cosets do you think there are (and then add 1 to account for J)? Note that in the code above, the variable pts records the lattice points and the variable idealList records the members of J, so perhaps these may be useful in helping to answer this question. What do you think is the size of Z[i]/J? Why?
;[s]
6:0,1;2,0;257,2;260,0;305,2;314,0;454,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Let's refer to the list of points in idealList by a different variable so that we can more efficiently do the bookkeeping as we try finding the other cosets. Suppose we use J[0].
;[s]
5:0,0;37,1;46,0;173,1;177,0;179,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Clear[J]
J[0] = idealList
:[font = text; inactive; preserveAspect]
Now we need to find the other cosets. We will be adding elements to the ideal, as opposed to multiplying, to generate the other cosets. Since we have defined J to be J[0], and we know all cosets are of the form r + J, finding another coset will not be too difficult. We just need to pick another ring element and add it to the elements in J[0]. Which ring element should we add? 

Since we clearly want to pick one that is not already in J, we may need to look at our picture again.
;[s]
7:0,0;49,1;55,0;166,2;170,0;339,2;343,0;483,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Show[{gr, plotOfIdeals}];
:[font = text; inactive; preserveAspect]
How about using 1?
:[font = input; preserveAspect]
J[1] = 1 + J[0] 
(* this conveniently adds 1 to every element in J[0] -
This works well since we are dealing with complex numbers.
Equivalently, one could use J[1] = Map[(# + 1)&, J[0]] *)
:[font = text; inactive; preserveAspect]
This returns all the elements of J[0] with 1 added to them. In other words, we are building (part of) another coset. Here is a graph showing what we have so far.
;[s]
3:0,0;33,1;37,0;162,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
cosetPlot[2] = ListPlot[Map[ComplexToPoint, J[1]],
	PlotStyle -> {PointSize[0.030], Hue[1/9]}, 
	AspectRatio -> Automatic, DisplayFunction -> Identity];
			
Show[{gr, plotOfIdeals, cosetPlot[2]}];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q2. How does this graph reflect that J[1] = 1 + J[0]?
;[s]
4:0,1;2,0;37,2;52,0;54,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q3. Do you want to modify your guess regarding how many cosets there will be? What is your current response?
;[s]
2:0,1;3,0;109,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Let's pick another element to help find another coset. Additionally, let's begin to automate our process by using the variable index to keep track of the count of the cosets.

Suppose we choose 2 for our new element.
;[s]
3:0,0;127,1;132,0;217,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
newElement = 2  (* place the element here *)
index = 2 			(* use index to record the current count *)
J[index] = newElement + J[0]
(* now calculate the new J[index] by adding newElement *)
:[font = text; inactive; preserveAspect]
We now have calculated our third coset, J[2]. (Recall that the first was J[0] and the second was J[1].) Now let's show a graph of our current situation.
;[s]
7:0,0;40,1;44,0;73,1;77,0;97,1;101,0;153,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
cosetPlot[index + 1] = ListPlot[Map[ComplexToPoint, J[index]],
	PlotStyle -> {PointSize[0.030], Hue[index/9]}, 
	AspectRatio -> Automatic, DisplayFunction -> Identity];
	
Show[Join[{gr, plotOfIdeals}, Table[cosetPlot[k + 1], {k, 1, index}]]];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q4. Do you want to modify your guess regarding how many cosets there will be? What is your current response?
;[s]
2:0,1;3,0;109,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q5. By choosing a value for newElement, step through the code below until you have found all the cosets. A suggestion for choosing newElement: pick an uncolored point that is "closest" to the x-axis (where you measure the distance by the absolute value of the angle from the x-axis to the point), but also within a circle of radius |2 + 2i| = 22. Keep track of your elements.
;[s]
6:0,1;3,0;28,2;38,0;131,2;141,0;377,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
newElement = (* <---- enter new elements here - use I not i *)

index += 1   (* index is automatically updated for you *)

J[index] = newElement + J[0]

cosetPlot[index + 1] = ListPlot[Map[ComplexToPoint, J[index]],
		PlotStyle -> {PointSize[0.030], Hue[index/9]}, 
		AspectRatio -> Automatic, DisplayFunction -> Identity];
		
Show[Join[{gr, plotOfIdeals}, Table[cosetPlot[k + 1], {k, 1, index}]]];
;[s]
5:0,0;13,1;63,0;77,1;121,0;399,-1;
2:3,12,10,Courier,1,12,0,0,0;2,12,10,Courier,1,12,0,0,65535;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q6. How many cosets are there? List them.
;[s]
2:0,1;3,0;42,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
4.3.1 What ring is it?
:[font = text; inactive; preserveAspect]
Now that you have found your cosets, let's explore what ring this quotient Z[i]/<2 + 2 i> might be. Since each coset can have one of many different names (or representatives, in the sense that 2 + <5> and 7 + <5> are the same cosets in Z/<5>, but use different representatives), we should first agree on what names to use, so that we can use the same language. (Technically, this is not necessary, but it will be convenient.) Therefore, here is one choice.
:[font = input; preserveAspect]
cosetReps = {0, 1, 2, 2 - I, 2 + I, 1 - I, 1 + I, 1 - 2 I}

cosetRepsPlot = ListPlot[Map[ComplexToPoint, cosetReps],
	PlotStyle -> {PointSize[0.030], Hue[0]}, 
	AspectRatio -> Automatic, DisplayFunction -> Identity];
	
Show[{gr, cosetRepsPlot,
	Graphics[Circle[{0, 0}, Abs[2 + 2I]]]}];
:[font = text; inactive; preserveAspect]
Here is another choice, with a different visualization. We will use this choice.
:[font = input; preserveAspect]
QuotientRing[Z[I], 2 + 2I, Mode -> Visual, 
	Form -> Representatives]
:[font = text; inactive; preserveAspect]
The representatives are the elements listed in this Ringoid. Additionally, these elements can be found within and on the bold square. In general, the corners of the square are different representatives of the same coset. Also, any element that appears on a side of a square will have a second representative of the same coset on the opposite side of the square.
;[s]
3:0,0;52,1;59,0;362,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q7. There are more Gaussian integers within or on this bold square than there are coset representations in this quotient ring. Which ones are not included in the quotient ring? How are these "extras" related to those in the quotient ring?
;[s]
2:0,1;4,0;239,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q8. Give an explanation for the role that the collection of squares is playing. In particular, address how the other squares relate to the bold one.
;[s]
2:0,1;4,0;149,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Since we have found all the cosets, we should consider how to add and multiply these cosets. We know that if we add the cosets 4 + 5i + J and 8 + 9i + J, we get 12 + 14i + J. Similarly, the product is -13 + 76i + J. (Double check each of these calculations.) We would, however, like to have these represented by elements of the form z + J, where z is a representative in our quotient ring. First, let's look at another version of the quotient ring, where the elements are given in the form z + J.
:[font = input; preserveAspect]
QR = QuotientRing[Z[I], 2 + 2I]
:[font = text; inactive; preserveAspect]
Now we can look at the sum and product.
:[font = input; preserveAspect]
Addition[QR][4 + 5I + J, 8 + 9I + J]
Multiplication[QR][4 + 5I + J, 8 + 9I + J]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q9. From these computations, we see that (4 + 5i + J) + (8 + 9i + J) = 2 + J and (4 + 5i + J) * (8 + 9i + J) = 3 + J. Why is this the case? Look again at the plot given above in the visualization of the quotient ring.

(i) First, find the representatives in the bold square for both 4 + 5i + J and 8 + 9i + J. (The second one may take a little ingenuity with this graph, but you can do it.) 

(ii) Now, add and multiply (by hand) these two representatives. What are these results (before reducing mod <2 + 2i>)?

(iii) Finally, reduce these mod <2 + 2i> so you can find the corresponding representative in the bold square. Are you convinced of these results?
;[s]
2:0,1;4,0;659,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
By looking at the Cayley table, we should be able to answer some questions regarding this ring. (You may wish to enlarge the graphics so you can view them better.)
:[font = input; preserveAspect]
CayleyTables[QR, Mode -> Visual];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q10. Is QR a field? Why or why not? Is J = <2 + 2i> a maximal ideal? Why or why not?
;[s]
2:0,1;5,0;85,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q11. Is QR an integral domain? Why or why not? Is J = <2 + 2i> a prime ideal? Why or why not?
;[s]
2:0,1;5,0;94,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q12. What is the characteristic of QR?
;[s]
2:0,1;5,0;39,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q13. Since the additive group of this ring has order eight, what are the candidates for a group that is isomorphic to this? In other words, what are the groups of order eight?
;[s]
2:0,1;5,0;176,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q14. Which one is this? What group is isomorphic to the additive group of this ring?
;[s]
2:0,1;5,0;85,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.4 A second example
:[font = text; inactive; preserveAspect]
Suppose we now let J = <3 + i> and consider the quotient ring Z[i]/J. As before, let's view this visually as well.
:[font = input; preserveAspect]
QuotientRing[Z[I], 3 + I, Mode -> Visual]
:[font = text; inactive; preserveAspect]
Try the following to see how this graphic image is built up in stages. (Note: the following cell uses a lot of memory; you may wish to delete previous graphics cells first.)
:[font = input; preserveAspect]
QuotientRing[Z[I], 3 + I, Mode -> Visual, Staged -> All];
:[font = text; inactive; preserveAspect]
You can now double-click on any one of the cells and animate the graphics. The speed can be controlled by typing a number from 1 to 9 (1 slow, 9 fast). If you want to see just one stage at a time, the following is an alternative. (If you have limited memory, you may wish to first clear the graphics just generated.)
:[font = input; preserveAspect]
QuotientRing[Z[I], 3 + I, Mode -> Visual, Staged -> True];
:[font = text; inactive; preserveAspect]
Now use NextStage to advance (or PreviousStage, if you wish to reverse):
;[s]
5:0,0;8,1;17,0;33,1;47,0;73,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
NextStage[QuotientRing]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q15. How many cosets are there?
;[s]
2:0,1;5,0;32,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q16. What can you say about this quotient ring? What is the size? Is it a field? Is it an integral domain?
;[s]
2:0,1;5,0;107,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Below are some Gaussian integers. You may recall that the absolute value of a complex number a + bi is the length of the vector starting at the origin and terminating at the point (a, b), having the value (a^2 + b^2)^(1/2).
:[font = input; preserveAspect]
someTestCases = {2 + I, 2, 3 + I, 3 + 2I, 2I, 4 - 3I, 7-I}
:[font = input; preserveAspect]
TableForm[Map[{#, Abs[#], Size[QuotientRing[Z[I], #, Form ->
	Representatives]]}&, someTestCases], TableHeadings -> 
	{None, {"z", "|z|", "|Z[i]/<z>|\n"}}]
:[font = text; inactive; preserveAspect]
The output consists of a complex number z, the absolute value of z, followed by the size of the quotient ring formed by Z[i]/<z> (i.e., the number of cosets).
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q17. Can you make a conjecture regarding the sizes measured above?
;[s]
2:0,1;5,0;67,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q18. Try to prove your conjecture.
;[s]
2:0,1;5,0;35,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q19. Which of the above do you think are fields? Integral domains? 
;[s]
2:0,1;5,0;68,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
You may be interested in trying the following.
:[font = input; preserveAspect]
Map[{#, PrimeQ[#, GaussianIntegers -> True]}&, someTestCases]
:[font = input; preserveAspect; endGroup]
Map[QuotientRing[Z[I], #, Form -> Representatives, 
	Mode -> Visual]&, someTestCases];
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
4.5 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect]
?IntegerLatticeGrid
:[font = input; preserveAspect]
?ListPlot
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?ComplexToPoint
:[font = input; preserveAspect]
?Show
:[font = input; preserveAspect]
?Table
:[font = input; preserveAspect]
?QuotientRing
:[font = input; preserveAspect]
?Form
:[font = input; preserveAspect]
?Representatives
:[font = input; preserveAspect]
?Cosets
:[font = input; preserveAspect]
?Addition
:[font = input; preserveAspect]
?Multiplication
:[font = input; preserveAspect]
?CayleyTables
:[font = input; preserveAspect]
?Staged
:[font = input; preserveAspect]
?PrimeQ
:[font = input; preserveAspect; endGroup; endGroup]
?GaussianIntegers
^*)
