(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 7. Factoring and irreducibility
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;51,1;62,0;63,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
Before working on this lab, you should be familiar with polynomial arithmetic over integral domains. No previous labs need to be completed prior to attempting this lab.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to introduce some of the tools available for polynomial factorization over a variety of rings.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.3 An introduction to factoring and irreducibility
:[font = text; inactive; preserveAspect]
To get started, let's read in the package that provides some of the functionality needed for this lab.
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect]
In this lab we will be considering how to factor polynomials. From high school, you should already have a sense what this means, but now we will make the definition more formal. For example, suppose you were asked if you could factor the following polynomial:
:[font = input; preserveAspect]
Clear[f, x]
f = x^2 - 3
:[font = text; inactive; preserveAspect]
Some might answer "No" since 3 is not a perfect square, and so this is not a difference of two squares. Others may answer "Yes" since one can factor this as (x - 3)(x + 3). Who is right? 

Actually, it is a poorly worded question. We will learn how we should ask it.

We will consider polynomials from D[x], where D is an integral domain. This means that the coefficients of the polynomials in the indeterminant x come from the integral domain D. Given any nonconstant polynomial f(x) in D[x] (i.e., degree(f(x)) > 0), we call f(x) irreducible if whenever we write f(x) = g(x) h(x) (with g(x) and h(x) from D[x]) we have g(x) or h(x) a unit in D[x]. In other words, f(x) cannot be factored except when one of the factors is a unit in D[x]. When a nonconstant polynomial is not irreducible, we call it reducible over D, or factored over D. Note that frequently the domain D is a field.

Thus, in our original question we should have asked if f was irreducible over Q (the rationals) or if f was irreducible over R (the reals) or over some other integral domain. In other words, we need to specify the ring from which our coefficients come.
;[s]
7:0,0;534,1;546,0;803,1;819,0;824,1;832,0;1141,-1;
2:4,16,12,Times,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q1. Determine whether x^2 - 3 is irreducible or reducible over the integers, rationals, reals, and complex numbers.
;[s]
2:0,1;2,0;116,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q2. Determine whether 2x^2 - 6 is irreducible or reducible over the integers, rationals, reals, and complex numbers.
;[s]
2:0,1;2,0;117,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q3. Determine whether 2x^2 + 6 is irreducible or reducible over the integers, rationals, reals, and complex numbers.
;[s]
2:0,1;2,0;117,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.4 Some techniques on testing the irreducibility of polynomials 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.1 Polynomials over Zp -- Theorem 1
;[s]
4:0,0;24,2;25,1;26,0;39,-1;
3:2,16,12,Times,1,14,0,0,0;1,24,16,Times,65,14,0,0,0;1,21,13,Times,65,12,0,0,0;
:[font = text; inactive; preserveAspect]
Suppose we consider the polynomial f(x) = 4x^3 + 3x^2 - 2x + 1 over the field Zp for some prime p. If f(x) is reducible, then there exists g(x) and h(x) from Zp[x] such that f(x) = g(x) h(x) and neither g(x) nor h(x) is a unit. Consequently, these two polynomials must have degrees 1 and 2 (or 2 and 1), since the sum of their degrees must be 3. But then the linear factor, whose form is a x + b, has a zero, namely -a-1b. Consequently, f(x) also has a zero. Therefore, all we have to do is look for the zeros of f. This can be summarized in the following theorem; you will likely find the theorem in your text. (Note that the above argument works whether the field is finite or infinite.)
;[s]
7:0,0;79,2;80,0;159,1;160,0;418,3;420,0;690,-1;
4:4,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = text; inactive; preserveAspect]
Theorem 1: Let F be a field. A polynomial of degree 2 or 3 over F is reducible over F if and only if it has a zero in F.
;[s]
2:0,2;9,1;121,-1;
3:0,16,12,Times,0,14,0,0,0;1,16,12,Times,0,14,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Let's pursue the irreducibility of f(x) = 4x^3 + 3x^2 - 2x + 1 over some finite field Zp. In this case, the task is particularly simple since all we need to do is check to see if f has a zero over the field. Here is how we might proceed for p = 3. First, we define f.
;[s]
3:0,0;87,1;88,0;268,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
f = Poly[Z[3], 4x^3 + 3x^2 - 2x + 1]
:[font = text; inactive; preserveAspect]
Next, we map f over the entire domain of the field.
:[font = input; preserveAspect]
Map[PolynomialEvaluation[f, #]&, {0, 1, 2}]
:[font = text; inactive; preserveAspect]
Thus, we see that 1 is a zero for f. (Why 1? Look at the set over which we mapped f.) Consequently, by the theorem, we know that f is reducible over Z3.
;[s]
3:0,0;150,1;151,0;153,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q4. Since f(x) is reducible, you should be able to find g(x) and h(x) such that f(x) = g(x) h(x). Do so.
;[s]
2:0,1;2,0;105,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q5. Is f(x) reducible over Z7?
;[s]
4:0,1;2,0;28,2;29,0;31,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q6. Consider f(x) = 7x^3 + 13x^2 + 2x + 7. Starting with p = 2, find the first prime p for which f(x) is reducible over Zp.
;[s]
4:0,1;2,0;121,2;122,0;124,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.2 2x^3 + 3x^2 - 1 over Q -- Rational Root Theorem
:[font = text; inactive; preserveAspect]
Consider the polynomial f = 2x^3 + 3x^2 - 1 over the rationals, Q.
:[font = input; preserveAspect]
Clear[f, x]
f = 2x^3 + 3x^2 - 1
:[font = text; inactive; preserveAspect]
Since this is a cubic, we can use the theorem indicated above. However, since the rationals are an infinite field, we don't want to look for zeros by brute force (i.e., test every element to see if it is a zero). We will introduce another tool, designed specifically for finding rational zeros: the Rational Root Theorem.
:[font = text; inactive; preserveAspect]
Rational Root Theorem: Suppose f(x) = anxn + an-1xn-1 +  + a1x + a0 is a polynomial in Z[x] (with an not zero). If r and s are relatively prime and f(r/s) = 0, then r | a0 and s | an.
;[s]
20:0,6;21,1;39,2;40,1;41,3;42,1;46,4;49,1;50,5;53,1;61,4;62,1;67,4;68,1;100,2;101,1;171,4;172,1;182,2;183,1;185,-1;
7:0,16,12,Times,0,14,0,0,0;10,16,12,Times,0,14,0,0,65535;3,24,16,Times,64,14,0,0,65535;1,24,16,Times,32,14,0,0,65535;4,21,13,Times,64,12,0,0,65535;1,21,13,Times,32,12,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Note what this says: if we have a rational zero of the form r/s, then the numerator r must divide the constant term of the polynomial and the denominator s must divide the leading coefficient. This reduces the search for a root from an infinite set to a finite number of possibilities. (Why does this lead to a finite list?)

For our polynomial f = 2x^3 + 3x^2 - 1, we are looking for integers r and s such that r divides -1 (thus, 1) and s divides 2 (thus 1, 2). Hence, the list of candidates for rational roots is as follows. (Do you agree with this list?)
;[s]
3:0,0;486,1;496,0;562,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
possibleRationalRoots = {1, -1, 1/2, -1/2}
:[font = text; inactive; preserveAspect]
Now, we just need to test f at each of these and look for a zero.
:[font = input; preserveAspect]
f /. {x -> possibleRationalRoots}
:[font = text; inactive; preserveAspect]
In this case, both -1 and 1/2 are zeros for f. We can now express f in factored form.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q7. Since f is reducible, you should be able to find g(x) and h(x) such that f = g(x) h(x). In fact, factor it completely into linear terms. (You should already know two of them.)
;[s]
2:0,1;2,0;180,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q8. Given the polynomial 4x^5 + 3x^3 - 8x^2 + 7x - 6, what are the possible rational roots to try? Do any of these work?
;[s]
4:0,1;2,0;67,2;75,0;121,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.3 x^4 - 2x^3 - 7x^2 - 11/3x - 4/3 over Q -- Mod p Irreducibility Test
:[font = text; inactive; preserveAspect]
First define f to be a polynomial that we wish to factor.
:[font = input; preserveAspect]
Clear[f, x]
f = x^4 - 2x^3 - 7x^2 - 11/3 x - 4/3
:[font = text; inactive; preserveAspect]
Since we need our polynomial to have integer coefficients (look at the formulation of the Rational Root Theorem), we multiply f by 3 to get a new polynomial over Z. 
:[font = input; preserveAspect]
Clear[g]
g = Expand[3 f]
:[font = text; inactive; preserveAspect]
If we find that g(x) can be factored into a product h(x) k(x), we will then have a factorization of f(x): 3^(-1) h(x) g(x). Note that g(x) is a quartic, so it does not satisfy the hypotheses of Theorem 1. However, if we can find a linear factor, then the remaining factor will be cubic and we can complete the process with the cubic (if we are looking for a complete factorization, not just trying to determine reducibility). If we cannot find a linear factor, it still may be factorable into two quadratic polynomials. (Why?)

We will approach the problem first with the Rational Root Theorem and then introduce another technique.
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
using the Rational Root Theorem
:[font = text; inactive; preserveAspect]
First we determine all possible rational roots (i.e., form the list of candidates).
;[s]
3:0,0;23,1;31,0;84,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
possibleRationalRoots = 
{1, -1, 1/3, -1/3, 2, -2, 2/3, -2/3, 4, -4, 4/3, -4/3}
(* do you agree with this list? *)
:[font = text; inactive; preserveAspect]
Now we evaluate g at each of these.
:[font = input; preserveAspect]
g /. {x -> possibleRationalRoots}
:[font = text; inactive; preserveAspect]
This indicates that 4 is a zero.Therefore, we need to find the quotient of g and x - 4. (Note that since 4 is a zero, x - 4 is a factor.)
:[font = input; preserveAspect]
g2 = PolynomialQuotient[g, x - 4, x]
:[font = text; inactive; preserveAspect]
This is our new polynomial to pursue. Continuing with the Rational Root Theorem, let us continue factoring it.
:[font = input; preserveAspect]
possibleRationalRoots = {1, -1, 1/3, -1/3} 
(* do you agree with this list? *)
:[font = input; preserveAspect]
g2 /. {x -> possibleRationalRoots}
:[font = text; inactive; preserveAspect]
We see that none of these are zeros and hence g is factored as 
(x-4) (3x^3 + 6x^2 + 3x + 1) and so f is factored as 3^(-1) (x-4) (3x^3 + 6x^2 + 3x + 1). Thus, f is reducible.
:[font = text; inactive; preserveAspect]
Note: there is a function to determine the list of candidates, though usually it is fairly easy to create the list by hand.
:[font = input; preserveAspect; endGroup]
RationalRootCandidates[g]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
using the Mod p Irreducibility Test
:[font = text; inactive; preserveAspect]
Even though we can see above that f is not irreducible (i.e., it is reducible), let us continue with a general approach of how we can test a polynomial using the Mod p Irreducibility Test. 
:[font = text; inactive; preserveAspect]
Mod p Irreducibility Test: Let p be a prime and suppose that f(x) is a polynomial over Z (the integers) with degree greater than or equal to 1. Let h(x) be the polynomial in Zp[x] obtained from f(x) in Z[x] by reducing all the coefficients of f(x) modulo p. If the degree of h(x) equals the degree of f(x) and if h(x) is irreducible over Zp, then f(x) is irreducible over Q (the rationals).
;[s]
6:0,2;25,1;175,3;176,1;339,3;340,1;391,-1;
4:0,16,12,Times,0,14,0,0,0;3,16,12,Times,0,14,0,0,65535;1,16,12,Times,1,14,0,0,65535;2,21,13,Times,64,12,0,0,65535;
:[font = text; inactive; preserveAspect]
We still need the g we defined above.
:[font = input; preserveAspect]
g
:[font = text; inactive; preserveAspect]
Now we wish to reduce this modulo some prime. (Although the built-in function PolynomialMod could be used here---specifically, PolynomialMod[g, 2]---we use another approach that is more general.) Try 2 and call this new polynomial g2.
;[s]
5:0,0;78,1;91,0;127,1;146,0;235,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
g2 = Poly[Z[2], g]
:[font = text; inactive; preserveAspect]
It may be clear that this is reducible (since x is a factor), but for the record, this is how we can check for zeros.
:[font = input; preserveAspect]
Map[PolynomialEvaluation[g2, #]&, Elements[Z[2]]]
:[font = text; inactive; preserveAspect]
We see that 0 is a zero and hence x is a factor. This does not give us any indication of a factor in Q[x], nor does it imply that g is reducible over Q[x] (though in this case we know it is reducible from our work above with the Rational Root Theorem).

For the sake of argument, let us try a few other primes.
;[s]
3:0,0;59,1;62,0;311,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
g3 = Poly[Z[3], g]
:[font = text; inactive; preserveAspect]
Note that the theorem does not apply when reducing mod 3. (Why?)
:[font = input; preserveAspect]
g5 = Poly[Z[5], g]
Map[PolynomialEvaluation[g5, #]&, Elements[Z[5]]]
:[font = text; inactive; preserveAspect]
You can try any other prime modulus with the following:
:[font = input; preserveAspect]
p = Input["Enter a prime"];
If[PrimeQ[p], {"prime: "<>ToString[p], gp = Poly[Z[p], g],
	If[Degree[gp] == 4, Map[PolynomialEvaluation[gp, #]&, 
	Elements[Z[p]]], "does not apply"]},
	Print["You didn't enter a prime."]]
:[font = text; inactive; preserveAspect; endGroup; endGroup]
We see that every time we get at least one factor, and hence the polynomial is not irreducible over Zp. When using the Mod p Irreducibility Test, we either continue with more primes, hoping to strike gold, or we begin to think that it is reducible over Q and try another test (such as the Rational Root Test).
;[s]
3:0,0;101,1;102,0;310,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.4 x^4 - 3x^2 + 2x + 1 over Q --how to handle quartics
:[font = text; inactive; preserveAspect]
First, let's define our next polynomial.
:[font = input; preserveAspect]
h = x^4 - 3x^2 + 2x + 1
:[font = text; inactive; preserveAspect]
Now, let's look for a linear factor. We can try the Mod 2 Irreducibility Test.
:[font = input; preserveAspect]
h2 = Poly[Z[2], h]
Map[PolynomialEvaluation[h2, #]&, {0, 1}]
:[font = text; inactive; preserveAspect]
This shows that the polynomial reduced mod 2, h2, has no linear factors over Z2, but this does not make it irreducible. What about quadratic factors over Z2? Could one of these be a factor? What are the irreducible quadratics in Z2[x]? There are only 4 quadratics, so we can investigate these quite easily.
;[s]
7:0,0;78,1;79,0;155,1;156,0;230,1;231,0;307,-1;
2:4,16,12,Times,0,14,0,0,0;3,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
quads = Table[x^2 + a x + b, {a, 0, 1}, 
	{b, 0, 1}]//Flatten//Map[Poly[Z[2], #]&, #]&
:[font = text; inactive; preserveAspect]
It's obvious that the first and third polynomials in this list have x as a factor, so we only need to investigate the second and fourth. First, we try the second factor.
:[font = input; preserveAspect]
Map[PolynomialEvaluation[quads[[2]], #]&, {0, 1}]
:[font = text; inactive; preserveAspect]
The second factor has a zero, namely 1. (This is not surprising; in Z2 x^2 + 1 = x^2 - 1 = (x - 1)(x + 1) = (x - 1)(x - 1).)
;[s]
3:0,0;69,1;70,0;125,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
Map[PolynomialEvaluation[quads[[4]], #]&, {0, 1}]
:[font = text; inactive; preserveAspect]
From this, we can see that the only irreducible quadratic in Z2[x] is the fourth candidate, x^2 + x + 1. Recall that h2 is our original polynomial, reduced modulo 2. We want to know if this is divisible by this irreducible quadratic. We will use the PolynomialDivision function, which returns the quotient and remainder when given two polynomials.
;[s]
5:0,0;62,1;63,0;250,2;268,0;348,-1;
3:3,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
q = quads[[4]]
:[font = input; preserveAspect]
PolynomialDivision[h2, q]
:[font = text; inactive; preserveAspect]
We see that h2 is the square of q.
:[font = input; preserveAspect]
q q == h2
:[font = text; inactive; preserveAspect]
The above two steps show that there are two quadratic factors and so this polynomial is reducible over Z2. Hence, we need to try a new prime since we can not make any conclusion about reducibility over Q when we know that we have reducibility over Zp. Next, we try p = 3.
;[s]
9:0,0;36,2;39,0;104,1;105,0;154,2;157,0;249,1;250,0;272,-1;
3:5,16,12,Times,0,14,0,0,0;2,24,16,Times,64,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
h3 = Poly[Z[3], h]
Map[PolynomialEvaluation[h3, #]&, {0, 1, 2}]
:[font = text; inactive; preserveAspect]
This also yields a reducible polynomial (since we have a zero). Try again with p = 5.
:[font = input; preserveAspect]
h5 = Poly[Z[5], h]
Map[PolynomialEvaluation[h5, #]&, {0, 1, 2, 3, 4}]
:[font = text; inactive; preserveAspect]
We can see that at least there are no linear factors, but now we have to consider quadratic ones. Below we use the "brute force" method used above with p = 2. Here, we create all possible monic quadratic polynomials over Z[5]. (To be monic, the leading coefficient is the unity of the ring, 1. You may wonder, and rightly so, why we only need to consider monic polynomials. Look in your text for an answer and ask your professor if you can't find out why.)
;[s]
3:0,0;188,1;193,0;457,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q9. Before computing the list of possible monic quadratics, count how many there will be. How many? How did you arrive at your result?
;[s]
4:0,1;2,0;33,2;41,0;135,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
quads = 
	Table[x^2 + a x + b, {a, 0, 4}, {b, 0, 4}]//Flatten//
	Map[Poly[Z[5], #]&, #]&
:[font = text; inactive; preserveAspect]
With each of these quadratics, let's divide h5 by the candidate and look at the remainder upon division.
;[s]
3:0,0;44,1;46,0;105,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Map[PolynomialRemainder[h5, #]&, quads]
:[font = text; inactive; preserveAspect; endGroup]
Observing that there are no remainders consisting of the 0 polynomial, we see that there are no quadratic factors. Therefore, since h5 has no linear factors and no quadratic factors, it is irreducible. Then, by the Mod 5 Irreducibility Test, h(x) is also irreducible over Q.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.5 2x^4 - 2x^3 - 17x^2 + 25x - 7 over Z -- Theorem 2
:[font = text; inactive; preserveAspect]
In this case, we wish to know whether a polynomial is factorable over Z, the integers. Consider the following theorem, which may be of use.
:[font = text; inactive; preserveAspect]
Theorem 2. Let f(x) be in Z[x]. If f(x) is reducible over Q, then it is reducible over Z.
;[s]
2:0,2;9,1;90,-1;
3:0,16,12,Times,0,14,0,0,0;1,16,12,Times,0,14,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Let f(x) be defined as follows:
:[font = input; preserveAspect]
Clear[f, x]
f = x^4 + 2x^3 + 3x^2 + 6x + 9
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q10. Give as complete a factorization for f(x) as possible. Is it reducible over Z? Why or why not? Hint: use the Rational Root Theorem to look for zeros. If there are quadratic factors, they must look like (x^2 + a x + c) (x^2 + b x + d). Since the middle coefficients of f are relatively small and all positive, it is reasonable to guess that c = d = 3, so that if it factors into two quadratics, it looks like (x^2 + a x + 3) (x^2 + b x + 3). Try expanding this product and comparing coefficients.
;[s]
4:0,1;3,0;334,2;339,0;501,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.6 3x^8 - 4x^6 + 8x^5 - 10x + 6 over Q --Eisenstein's Criterion
:[font = text; inactive; preserveAspect]
First, we define our polynomial.
:[font = input; preserveAspect]
f = 3x^8 - 4x^6 + 8x^5 - 10x + 6
:[font = text; inactive; preserveAspect]
Perhaps we should think about this one from another perspective at first. Suppose we graph this over some domain.
:[font = input; preserveAspect]
Plot[f, {x, -3, 3}];
:[font = text; inactive; preserveAspect]
It looks as if the interesting part of the function occurs in a smaller domain.
:[font = input; preserveAspect]
Plot[f, {x, -1.65, 1.1}];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q11. What does the graph say about the number of real zeros? What does it say about the number of rational zeros? Considering the graph and the degree of the polynomial, what does it say about the number of pure complex (i.e., non-real) zeros?
;[s]
4:0,1;3,0;49,2;53,0;244,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Consider the following:
:[font = input; preserveAspect]
Clear[h]
h = Poly[Z[5], f]
Map[PolynomialEvaluation[h, #]&, Elements[Z[5]]]
:[font = text; inactive; preserveAspect]
This indicates that there are no linear factors. There could, however, be quadratic factors. Or cubic. Or quartic. If there was a cubic factor, there could also be a quintic or another cubic and a quadratic. This could get quite complicated. Fortunately, for some very special polynomials whose coefficients behave in a particular fashion, there is a theorem that can be used to determine irreducibility.
:[font = text; inactive; preserveAspect; fontColorBlue = 65535]
Eisenstein's Criterion. Let f(x) = anxn + an-1xn-1 +  + a1x + a0 be a polynomial in Z[x] (with an not zero). If there is a prime p such that p does not divide the leading coefficient an, but does divide every other coefficient, and we also have p2 not dividing a0, then f(x) is irreducible over Q.
;[s]
28:0,5;22,0;36,1;37,0;38,2;39,0;43,3;46,0;47,4;50,0;58,3;59,0;64,3;65,0;97,1;98,0;149,6;152,0;185,1;186,0;192,6;196,0;247,4;248,0;249,6;252,0;263,3;264,0;299,-1;
7:14,16,12,Times,0,14,0,0,65535;3,24,16,Times,64,14,0,0,65535;1,24,16,Times,32,14,0,0,65535;4,21,13,Times,64,12,0,0,65535;2,21,13,Times,32,12,0,0,65535;1,16,12,Times,1,14,0,0,65535;3,16,12,Times,2,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Let's consider our polynomial again:
:[font = input; preserveAspect]
f
CoefficientList[f, x]
:[font = text; inactive; preserveAspect]
Note that the prime p = 2 does indeed divide every coefficient except the leading 3 and that p^2 = 4 does not divide 6. Therefore, by Eisenstein's Criterion, f is irreducible. Although Eisenstein's Criterion is fairly easy to implement by hand, the following will walk you through the steps.
:[font = input; preserveAspect; endGroup]
EisensteinsCriterionQ[f, Mode -> Textual]
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.7 x^4 + 4 over Z7
;[s]
2:0,0;20,1;22,-1;
2:1,16,12,Times,1,14,0,0,0;1,21,13,Times,65,12,0,0,0;
:[font = text; inactive; preserveAspect]
We now consider a polynomial over Z7.
;[s]
3:0,0;35,2;36,1;38,-1;
3:1,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
Clear[p]
p = Poly[Z[7], x^4 + 4]
Map[PolynomialEvaluation[p, #]&, Elements[Z[7]]]
:[font = text; inactive; preserveAspect]
This defines the polynomial and then shows that there is no zero for the polynomial over Z7. Since we are interested in determining irreducibility over Z7, we can not use the Mod p Irreducibility Test. (Why?) Having no zero indicates that there is no linear factor (and hence no corresponding irreducible cubic). There is still the possibility of two irreducible quadratic factors. Let's check this out. We will assume that we have two quadratic factors.
;[s]
5:0,0;90,1;91,0;153,1;154,0;455,-1;
2:3,16,12,Times,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
Clear[a, b, c, d, e, f]
PossibleFactors = {a x^2 + b x + c, d x^2 + e x + f}
:[font = text; inactive; preserveAspect]
Here is the product of these factors.
:[font = input; preserveAspect]
prod = Apply[Times, PossibleFactors]
Expand[prod]
:[font = text; inactive; preserveAspect]
We know that a and d are nonzero and hence invertible. (If either was zero, these would not be quadratics.) We can factor out both of these and assume that they are equal to 1.
:[font = input; preserveAspect]
a = d = 1;
t = Expand[prod]
:[font = text; inactive; preserveAspect]
Let's look at our original polynomial and compare it to t with identical factors of x collected together.
:[font = input; preserveAspect]
p
Collect[t, x]
:[font = text; inactive; preserveAspect]
Note that we need c f = 4, c e + b f = 0, c + b e + f = 0 and b + e = 0. Additionally, we want the modulus to be 7.
:[font = input; preserveAspect]
equations = {c f == 4, c e + b f == 0, c + b e + f == 0,
	b + e == 0, Modulus == 7}
:[font = text; inactive; preserveAspect]
How can we get the constant term of 4? What are the values for c and f? We know that 2*2 = 4. Is there any other possibility? Yes. Since Z7 is a field, there are 5 other possibilities (such as 3*6 = 4). One way to see all of them is to look at the multiplication table for Z[7].
;[s]
3:0,0;138,1;139,0;279,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
MultiplicationTable[Z[7], Mode -> Visual];
:[font = text; inactive; preserveAspect]
The unordered pairs that have a product of 4 (mod 7) are {4, 1}, {2, 2}, {3, 6}, and {5, 5}. We will now solve the system of equations arising from each possibility of values for c and f having a product of 4. Notice that Rest[equations] represents a list of all but the first equation in equations. First we test when we have c = 4 and f = 1.
;[s]
5:0,0;222,1;237,0;289,1;298,0;344,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
s1 = Solve[Rest[equations] /. {c -> 4, f -> 1}, {e, b}]
:[font = text; inactive; preserveAspect]
There is no solution for this case. Next, we try c = 2 and f = 2.
:[font = input; preserveAspect]
s2 = Solve[Rest[equations] /. {c -> 2, f -> 2}, {e, b}]
:[font = text; inactive; preserveAspect]
Here we get two solutions, although we will see that they are really the same.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q12. Given that we now already know our polynomial is reducible, why might we want to consider the cases where c = 5 and f = 5 or c = 6 and f = 3?
;[s]
2:0,1;3,0;147,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Let's consider the remaining two cases. Next we consider c = 3 and f = 6.
:[font = input; preserveAspect]
s3 = Solve[Rest[equations] /. {c -> 3, f -> 6}, {e, b}]
:[font = text; inactive; preserveAspect]
Again, there is no solution in this case. Finally, we try c = 5 and f = 5.
:[font = input; preserveAspect]
s4 = Solve[Rest[equations] /. {c -> 5, f -> 5}, {e, b}]
:[font = text; inactive; preserveAspect]
Again, no solution. Let's return to the second case. The first solution is 
:[font = input; preserveAspect]
s2[[1]]
:[font = text; inactive; preserveAspect]
The value of -2 for b is equivalent to 5 in Z[7]. Here are the results of the possible factors for these values of b, c, e, and f.
:[font = input; preserveAspect]
PossibleFactors /. {b -> 5, c -> 2, e -> 2, f -> 2}
:[font = text; inactive; preserveAspect]
The second solution:
:[font = input; preserveAspect]
s2[[2]]
:[font = text; inactive; preserveAspect]
We repeat the process used with the second solution:
:[font = input; preserveAspect]
PossibleFactors /. {b -> 2, c -> 2, e -> 5, f -> 2}
:[font = text; inactive; preserveAspect; endGroup]
Therefore, there really is only one solution. The difference in our two results is the ordering of the two factors. In conclusion, we see that f is reducible over the field Z7 in exactly one way: into two quadratics.
;[s]
3:0,0;174,1;176,0;217,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
7.4.8 x^4 - 2x^3 + x^2 + 1 over R
:[font = text; inactive; preserveAspect]
This situation is a little different because we are considering factoring a polynomial over the reals.
:[font = input; preserveAspect]
Clear[p]
p = x^4 - 2x^3 + x^2 + 1
:[font = text; inactive; preserveAspect]
First we consider rational factorizations. The Rational Root Test indicates that the only possibilities for zeros are 1.
:[font = input; preserveAspect]
p /. x -> {1, -1}
:[font = text; inactive; preserveAspect]
This indicates that there are no linear factors over Q. How about the mod p test?
:[font = input; preserveAspect]
h = Poly[Z[2], p]
Map[PolynomialEvaluation[h, #]&, Elements[Z[2]]]
:[font = text; inactive; preserveAspect]
This also shows that there are no linear factors (no surprise), but what about quadratic factors. We have already seen in a previous section that the only irreducible quadratic factor for h is x^2 + x +1.
:[font = input; preserveAspect]
Poly[Z[2], Expand[(x^2+x+1)(x^2+x+1)]]
:[font = text; inactive; preserveAspect]
This shows that our h is reducible mod 2, but unfortunately, it does not address the question about reducibility in Q. 

We could continue with another prime, but this will at best indicate irreducibility over Q and will not address the irreducibility over the reals at all. Let's try some non-algebraic approaches.
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
first attempt
:[font = text; inactive; preserveAspect]
We will use some techniques from calculus: determine the derivative and set it equal to zero to find possible relative extrema.
:[font = input; preserveAspect]
dp = D[p, x]
dzeros = Solve[dp == 0]
:[font = text; inactive; preserveAspect]
Now we evaluate p at the zeros.
:[font = input; preserveAspect]
p /. dzeros
:[font = text; inactive; preserveAspect]
This indicates that we have two relative minima at the value 1 and a relative maximum at the value 17/16. 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q13. Why can we make this conclusion?
;[s]
2:0,1;3,0;38,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q14. Why does this tell us this polynomial has no linear factors?
;[s]
2:0,1;3,0;66,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
second attempt
:[font = text; inactive; preserveAspect]
Perhaps we should plot it!
:[font = input; preserveAspect]
Plot[p, {x, -2, 2}, PlotRange -> {0, 3}];
:[font = text; inactive; preserveAspect]
This seems to indicate that there are no real zeros, since the function does not cross the x-axis.
:[font = input; preserveAspect]
NSolve[p == 0]
:[font = text; inactive; preserveAspect]
This confirms that the solutions are complex and thus non-real. Hence, there are no linear factors.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q15. Determine if one can write p as a product of two irreducible quadratic factors over the reals. Caution: this takes a little bit of work.
;[s]
2:0,1;3,0;142,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.5 More polynomials for practice
:[font = text; inactive; preserveAspect]
Consider the following collection of polynomials over various fields. In each case, determine if the polynomial is reducible or irreducible over the stated field. When reducible, factor it as completely as possible. In each case, state the theorem(s) used and show your work. Some will be fairly easy, while others may take some work.

For your convenience, the list of all the theorems used in this lab are collected together in the next section.
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q16. x^3 + x^2 + x + 1 over Q
;[s]
2:0,1;3,0;30,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q17. x^4 + x^2 - 6 over Q
;[s]
2:0,1;3,0;26,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q18. 4x^3 + 3x^2 + x + 1 over Z5
;[s]
4:0,1;3,0;31,2;32,0;33,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q19. 25x^5 - 9x^4 + 3x^2 - 12 over Q
;[s]
2:0,1;3,0;37,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q20. x^4 - 3x^3 + 2x^2 + 4x - 1 over Z5
;[s]
3:0,1;3,0;38,2;40,-1;
3:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.6 Toolbox of theorems
:[font = text; inactive; preserveAspect]
Theorem 1: Let F be a field. A polynomial of degree 2 or 3 over F is reducible over F if and only if it has a zero in F.
;[s]
2:0,2;9,1;121,-1;
3:0,16,12,Times,0,14,0,0,0;1,16,12,Times,0,14,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Rational Root Theorem: Suppose f(x) = anxn + an-1xn-1 +  + a1x + a0 is a polynomial in Z[x] (with an not zero). If r and s are relatively prime and f(r/s) = 0, then r|a0 and s|an.
;[s]
21:0,6;21,1;39,2;40,1;41,3;42,1;46,4;49,1;50,5;53,1;61,4;62,1;67,4;68,1;100,2;101,1;169,4;170,1;178,2;179,1;180,0;181,-1;
7:1,16,12,Times,0,14,0,0,0;10,16,12,Times,0,14,0,0,65535;3,24,16,Times,64,14,0,0,65535;1,24,16,Times,32,14,0,0,65535;4,21,13,Times,64,12,0,0,65535;1,21,13,Times,32,12,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Mod p Irreducibility Test: Let p be a prime and suppose that f(x) is a polynomial over Z (the integers) with degree greater than or equal to 1. Let h(x) be the polynomial in Zp[x] obtained from f(x) in Z[x] by reducing all the coefficients of f(x) modulo p. If the degree of h(x) equals the degree of f(x) and if h(x) is irreducible over Zp, then f(x) is irreducible over Q (the rationals).
;[s]
6:0,3;25,1;175,2;176,1;339,2;340,1;391,-1;
4:0,16,12,Times,0,14,0,0,0;3,16,12,Times,0,14,0,0,65535;2,24,16,Times,64,14,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect]
Theorem 2. Let f(x) be in Z[x]. If f(x) is reducible over Q, then it is reducible over Z.
;[s]
2:0,2;9,1;90,-1;
3:0,16,12,Times,0,14,0,0,0;1,16,12,Times,0,14,0,0,65535;1,16,12,Times,1,14,0,0,65535;
:[font = text; inactive; preserveAspect; fontColorBlue = 65535; endGroup]
Eisenstein's Criterion. Let f(x) = anxn + an-1xn-1 +  + a1x + a0 be a polynomial in Z[x] (with an not zero). If there is a prime p such that p does not divide the leading coefficient an, but does divide every other coefficient, and we also have p2 not dividing a0, then f(x) is irreducible over Q.
;[s]
28:0,5;22,0;36,1;37,0;38,2;39,0;43,3;46,0;47,4;50,0;58,3;59,0;64,3;65,0;97,1;98,0;149,6;152,0;185,1;186,0;192,6;196,0;247,4;248,0;249,6;252,0;263,3;264,0;299,-1;
7:14,16,12,Times,0,14,0,0,65535;3,24,16,Times,64,14,0,0,65535;1,24,16,Times,32,14,0,0,65535;4,21,13,Times,64,12,0,0,65535;2,21,13,Times,32,12,0,0,65535;1,16,12,Times,1,14,0,0,65535;3,16,12,Times,2,14,0,0,65535;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.7 A final perspective
:[font = text; inactive; preserveAspect]
We have been purposely avoiding a very powerful built-in function of Mathematica that does much of the work shown above in one swoop. The following should illustrate this.
:[font = input; preserveAspect]
Factor[x^4 - 2x^3 - 7x^2 - 11/3 x - 4/3]
:[font = input; preserveAspect]
Factor[2x^3 + 3x^2 -1]
:[font = input; preserveAspect]
Factor[x^4 - 3x^2 + 2x + 1]
(* note that echoing back indicates the irreducibility over Q*)
:[font = input; preserveAspect]
Factor[x^4 + 4, Modulus -> 7]
:[font = text; inactive; preserveAspect]
Isn't this disgusting! All the sweat and blood, not to mention the joy, is removed by this powerful function Factor.
;[s]
3:0,0;109,1;115,0;117,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
The function ModpIrreducibilityQ may be illustrative as well.
;[s]
3:0,0;13,1;32,0;62,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
ModpIrreducibilityQ[x^4 - 3x^2 + 2x + 1, Mode -> Textual]
:[font = input; preserveAspect]
ModpIrreducibilityQ[12 + 5x + 8x^2 + 11x^3 + 3x^4, 
	Mode -> Textual]
:[font = input; preserveAspect]
Factor[12 + 5x + 8x^2 + 11x^3 + 3x^4, Modulus -> 11]
:[font = input; preserveAspect]
RationalRootTheorem[6x^3 - 5x^2 - 7x + 4]
Factor[6x^3 - 5x^2 - 7x + 4]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 504]
Q21. Evaluate the following input cell. What is a reasonable conjecture based on your observations? Can you prove it?
;[s]
2:0,1;3,0;118,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect; endGroup]
Table[{Prime[n],Factor[x^4 + 1, Modulus -> Prime[n]]},
	{n,1,25}]//TableForm
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
7.8 Mathematica commands used in this lab
;[s]
3:0,0;4,1;15,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect]
?Poly
:[font = input; preserveAspect]
?PolynomialEvaluation
:[font = input; preserveAspect]
?Expand
:[font = input; preserveAspect]
?PolynomialQuotient
:[font = input; preserveAspect]
?RationalRootCandidates
:[font = input; preserveAspect]
?Elements
:[font = input; preserveAspect]
?Table
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?Flatten
:[font = input; preserveAspect]
?PolynomialDivision
:[font = input; preserveAspect]
?PolynomialRemainder
:[font = input; preserveAspect]
?Plot
:[font = input; preserveAspect]
?EisensteinsCriterionQ
:[font = input; preserveAspect]
?Apply
:[font = input; preserveAspect]
?Collect
:[font = input; preserveAspect]
?Modulus
:[font = input; preserveAspect]
?MultiplicationTable
:[font = input; preserveAspect]
?Solve
:[font = input; preserveAspect]
?Rest
:[font = input; preserveAspect]
?NSolve
:[font = input; preserveAspect]
?Factor
:[font = input; preserveAspect]
?ModpIrreducibilityQ
:[font = input; preserveAspect]
?RationalRootTheorem
:[font = input; preserveAspect]
?Prime
:[font = input; preserveAspect; endGroup; endGroup]

^*)
