(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; fontColorBlue = 0]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
Ring Lab 10. Quotient rings of polynomials
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
10.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
10.1 Prerequisites
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
To complete this lab, you should be familiar with the ring of polynomials over a field, the division property for polynomials over a field, and the definitions of homomorphism, kernel, and ideal. Finally, you should be familiar with the First Isomorphism Theorem for ring homomorphisms (Ring Lab 5). 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
10.2 Goals for this lab
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Extensions of finite fields are generally motivated by the need to solve polynomial equations. These extensions are actually quite concrete in the sense that they arise from quotient rings, where the ideal from which cosets are formed is the kernel of a familiar homomorphism. In this case, the homomorphism is the remainder function for division by a fixed polynomial (the modulus). In this lab we will introduce quotient rings, and in Ring Lab 11 we will explore how they are used to construct roots of polynomials.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.3 Polynomials over a field
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
First, we read in the necessary Mathematica code that we will need for this lab.
;[s]
3:0,0;32,1;43,0;81,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Given any field, F, we will ultimately want to be able to solve any polynomial equation over it. For example, F might be the integers modulo 3.
:[font = input; initialization; preserveAspect]
*)
F = Z[3]
(*
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
It is clear, by simple hand-evaluation of m(x) = x2 + x + 2, that none of the elements of F are roots of m(x). This can also be done using just the built-in Mathematica functions. First, define the function:
;[s]
5:0,0;50,1;51,0;157,2;168,0;208,-1;
3:3,16,12,Times,0,14,0,0,0;1,24,16,Times,32,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
Clear[m1, x]
m1[x_] := x^2 + x + 2
(* we call it m1 here because we will use m below *)
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Then evaluate the function at each element in F:
:[font = input; preserveAspect; rightWrapOffset = 521]
{m1[0], m1[1], m1[2]}
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
For larger fields, it may be easier to do this another way:
:[font = input; preserveAspect; rightWrapOffset = 521]
Map[m1, Elements[F]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Reducing mod 3 (recall what ring we are in), we get:
:[font = input; preserveAspect; rightWrapOffset = 521]
Mod[%, 3]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q1. Why does this show that m(x) does not have any roots in F?
;[s]
2:0,1;2,0;63,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
One can also use the functions built into the packages that were read in. First, define the polynomial over F using the Poly function.
;[s]
3:0,0;120,1;124,0;135,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
m = Poly[F, x^2 + x + 2]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Then use the PolynomialEvaluation function on the domain elements.
;[s]
3:0,0;13,1;33,0;67,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
Map[PolynomialEvaluation[m, #]&, Elements[F]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q2. Does the polynomial m(x) - 1 (which is really m(x) + 2) have any roots in F?
;[s]
2:0,1;2,0;81,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
We conclude that the field F does not contain the roots of m(x). In this lab we will concentrate on the construction of a field that will contain the roots of m(x). In the next lab we will discuss the factorization of m(x) in this new field, along with other issues involving finite field extensions. 

We will use V to denote the smallest extension of F that contains all the roots of m(x). The first step in constructing V is to consider the whole ring of polynomials over F.
;[s]
3:0,0;34,1;37,0;478,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
P = PolynomialsOver[F]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q3. In the packages that these labs are based upon, a Ringoid has three arguments: the list of elements, the addition function, and the multiplication function. Why isn't P a Ringoid in this sense? Is P a ring?
;[s]
8:0,1;2,0;54,2;61,0;171,2;172,0;175,2;182,0;211,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.4 A Homomorphism based on PolynomialRemainder
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
The homomorphism, theta, that we consider below depends on m(x). If the definition of m(x) is altered, a different homomorphism and, at least superficially, a different extension will be constructed. Generally, the smallest degree that we consider for the polynomial function m(x) is two, as we have in this example.
;[s]
3:0,0;18,1;23,0;317,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
The function theta takes any polynomial in P and returns the polynomial that is the remainder upon division by m(x) (our polynomial x^2 + x + 2). 
;[s]
3:0,0;13,1;18,0;147,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
theta = PolynomialRemainder[P, #, m]&
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
You may wish to remind yourself how the function PolynomialRemainder works:
;[s]
3:0,0;49,1;68,0;76,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
?PolynomialRemainder
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
For a quick test of theta, let's apply it to m and also to m + 1 = x^2 + x . (Think about the answer before evaluating.)
;[s]
3:0,0;20,1;25,0;121,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
theta[m]
theta[Poly[F, x^2 + x]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q4. (a) What happens when we apply theta to m * x + 2 = x^3 + x^2 + 2x + 2? Think about it and then calculate it.

(b) What happens when we apply theta to m * (x + 2) + x? Think about it and then calculate it.
;[s]
6:0,1;2,0;35,2;40,0;146,2;151,0;210,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
The division property of polynomials over a field assures us that the remainder (the value of our function theta) will have its degree less than the divisor's degree. So in our examples, the remainders are all linear polynomials. To illustrate this with a computation, we take some of the elements of P, the ones of degree three or less, and map the PolynomialRemainder function theta over them. Note: if your computer is relatively slow, you may want to change the expression below to SomePolynomials = PolynomialsUpToDegreeN[F, 2], generating only polynomials of degree two or less.
;[s]
11:0,0;107,2;112,0;277,1;281,0;350,2;369,0;379,2;384,0;486,2;532,0;585,-1;
3:6,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;4,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
SomePolynomials = PolynomialsUpToDegreeN[F, 3]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Next, we map theta over this list. Duplicate images are removed and we can verify by examination that all nine linear polynomials over Z3 are in this list.
;[s]
5:0,0;13,1;18,0;136,2;137,0;156,-1;
3:3,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
thetaRange = Map[theta, SomePolynomials]//Union
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q5. Why are there 9 possible remainders? If m(x) were a cubic polynomial (instead of a quadratic), how many different elements would be in the range of theta? (In other words, how many different remainders would there be if m(x) were a cubic?)
;[s]
4:0,1;2,0;152,2;157,0;244,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's review what we have done. Since the set of all polynomials over F (which we call P) is infinite in size, we can not apply our function theta to the whole of P. So we took a finite subset of P (SomePolynomials -- those of degree less than four) and applied theta to this subset, to get a sense of how theta worked. The result over this set is the set we called thetaRange. We now rename this set linPolys, which is the set of linear polynomials over F.
;[s]
13:0,0;141,1;146,0;199,1;214,0;262,1;267,0;306,1;311,0;366,1;376,0;401,1;409,0;458,-1;
2:7,16,12,Times,0,14,0,0,0;6,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
linPolys = thetaRange
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
By considering theta as a function from P into the linear polynomials (linPolys), we want to establish theta as a homomorphism. For theta to be a homomorphism, more fundamental than showing the operations are preserved, we need to make sure that both the domain and codomain are rings. The domain is clearly a ring -- it is the ring of polynomials over Z3. It is not so clear that the set of remainders, linPolys, is also a ring. How should addition and multiplication be defined? 
;[s]
13:0,0;15,2;20,0;71,2;79,0;103,2;108,0;132,2;137,0;354,1;355,0;404,2;412,0;482,-1;
3:7,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;5,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q6. Consider the set of remainders from division by m(x), linPolys. Why can't the usual polynomial multiplication be used on linPolys to form a ring?
;[s]
6:0,1;2,0;58,2;66,0;125,2;133,0;150,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer 
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
The First Homomorphism Theorem gives us a clue how to operate in linPolys. This is because the range is isomorphic to P/K, where K is the kernel of theta. Recall that given an isomorphism f: R -> S, the inverse map (which exists, since f is a bijection), f-1: S -> R, is also an isomorphism. We want to consider this inverse isomorphism, the function that maps an element g in linPolys to the coset g + K in P/K. 

Here are the elements of K that come from the list SomePolynomials. Note that these are obtained by selecting those whose image under theta is the zero of P.
;[s]
13:0,0;65,2;73,0;148,2;153,0;256,1;258,0;377,2;385,0;466,2;481,0;549,2;554,0;573,-1;
3:7,16,12,Times,0,14,0,0,0;1,21,13,Times,32,12,0,0,0;5,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
partialK = Select[SomePolynomials, (theta[#] == Zero[P])&]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q7. What do these polynomials all have in common? For a hint, take one of these polynomials over F (remember, they were all formed with Poly) and try the PolynomialDivision function on it with of m(x). (See below.)
;[s]
6:0,1;2,0;136,2;140,0;154,2;172,0;215,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer 
:[font = input; preserveAspect; rightWrapOffset = 521]
?PolynomialDivision
:[font = input; preserveAspect; rightWrapOffset = 521]
p = partialK[[1]] (* take the first element, for starters *)
PolynomialDivision[p, m]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's take a pair of elements from P and form two cosets from them. We select polynomials that are also in linPolys so that the sum and product of their cosets will give us a hint at how addition and multiplication are defined in linPolys.
;[s]
5:0,0;107,1;115,0;230,1;238,0;240,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
p = Poly[F, x + 1]
q = Poly[F, 2x + 1]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Since K is infinite (you should ask yourself why this is true), we can not form the full coset p + K, but we can form a portion of p + K by using partialK.
;[s]
3:0,0;146,1;154,0;156,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
pCoset = Map[Addition[P][p, #]&, partialK]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
We do the same for q + K.
:[font = input; preserveAspect; rightWrapOffset = 521]
qCoset = Map[Addition[P][q, #]&, partialK]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
We add the two cosets by adding arbitrary representatives of pcoset and qcoset. There are many possibilities here, but the easiest pair to add is p and q.
;[s]
5:0,0;61,1;67,0;72,1;78,0;155,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
sum = Addition[P][p, q]
theta[sum]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Now we pick random representatives and go through the same process.
:[font = input; preserveAspect; rightWrapOffset = 521]
Print["Rep. from pCoset: ",pRep = RandomElement[pCoset]]
Print["Rep. from qCoset: ",qRep = RandomElement[qCoset]]
Print["Sum in P: ",sum = Addition[P][pRep, qRep]]
Print["Image of this sum under theta: ",theta[sum]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q8. Consider three more pairs of representatives from pCoset and from qCoset by evaluating the above cell three more times. What do you observe?
;[s]
6:0,1;2,0;54,2;60,0;70,2;76,0;145,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q9. By changing Addition to Multiplication (see below), multiply several random pairs of representatives as in the previous exercise. What do you observe? Do the same using p and q as representatives.
;[s]
6:0,1;2,0;16,2;24,0;28,2;42,0;201,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = input; preserveAspect; rightWrapOffset = 521]
Print["Rep. from pCoset: ",pRep = RandomElement[pCoset]]
Print["Rep. from qCoset: ",qRep = RandomElement[qCoset]]
Print["Product in P: ",prod = Multiplication[P][pRep, qRep]]
Print["Image of this product under theta: ",theta[prod]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
It can be proven that the observations that you (hopefully) made above are not coincidence. It is reasonable to consider the sum of p and q is 2 and their product is an "obvious value." The general definitions of the operations on linPolys are based on these observations.
;[s]
3:0,0;231,1;239,0;273,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.5 Defining a Quotient Ring of Polynomials
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
For any polynomial m = Poly[R, anxn + an-1xn-1 +  + a2x2 + a1x + a0], with each ai in some Ringoid R with unity, the expression QuotientRing[R, m] generates a quotient ring of R with modulus m. The elements of the ring are the polynomials of degree less than the degree of m. With m and F defined above, we define V to be the quotient ring of F mod m:
;[s]
29:0,0;23,6;27,0;32,2;33,0;34,3;35,0;39,2;42,0;43,3;46,0;49,4;50,0;54,2;55,0;56,3;57,0;61,2;62,0;67,2;68,0;82,1;83,0;92,6;99,0;129,6;147,0;184,5;191,0;353,-1;
7:15,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;5,21,13,Times,64,12,0,0,0;3,21,13,Times,32,12,0,0,0;1,24,16,Times,32,14,0,0,0;1,16,12,Times,2,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
V = QuotientRing[F, m]
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.5.1 Addition
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Addition in V is simply addition of polynomials. 
:[font = input; preserveAspect; rightWrapOffset = 521]
{p, q} = {Poly[F, 2x+1], Poly[F, 2x]}
:[font = input; preserveAspect; rightWrapOffset = 521]
Addition[V][p, q]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Let's try this addition with a few random pairs.
:[font = input; preserveAspect; rightWrapOffset = 521]
{p, q} = RandomElements[V, 2]
Addition[V][p, q]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q10. Why is V closed under the usual addition of polynomials?
;[s]
2:0,1;3,0;62,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.5.2 Multiplication
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Multiplication in V is much like multiplication on the integers mod n. To multiply polynomials p and q, you perform the usual multiplication (as in P) and then divide by the modulus, retaining the remainder for the value of the product. In other words, you apply theta to the product. For example,
;[s]
3:0,0;263,1;268,0;298,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
p = Poly[F, x + 1]
q = Poly[F, x+ 2]
r = Multiplication[P][p, q]
:[font = input; preserveAspect; rightWrapOffset = 521]
theta[r]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
This last result, of course, can also be done as follows:
:[font = input; preserveAspect; rightWrapOffset = 521]
Multiplication[V][p, q]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Remember, theta[r] is computed by dividing the product, r, by m and then returning the remainder. The complete division result, quotient and remainder, is given by PolynomialDivision. (However, only the remainder is used for the product in V.)
;[s]
5:0,0;10,1;18,0;164,1;182,0;244,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
PolynomialDivision[P, r, m, Mode -> Textual]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q11. Compute the following in V:
			(a)			 (2x + 1) + (x + 2)
			(b)			x x= x2 
			(c)			x x x x = x4 
			(d)				x x x x x x x x = x8
			(e) The multiplicative inverse of 2x + 1.
;[s]
8:0,1;3,0;77,2;78,0;100,2;101,0;132,2;136,0;179,-1;
3:4,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,24,16,Times,32,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.6 The PolynomialRemainder function theta is indeed a homomorphism
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Now that we have established the operations on V, we can verify that theta is indeed a homomorphism. Here we will only verify that the homomorphism properties are true for a pair of random degree 3 elements in P.
;[s]
3:0,0;69,1;74,0;213,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
{p, q} = Table[RandomElement[P,3], {2}]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
First the addition property:
:[font = input; preserveAspect; rightWrapOffset = 521]
theta[ Addition[P][p, q] ] == Addition[V][theta[p], theta[q]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
and then the multiplication property:
:[font = input; preserveAspect; rightWrapOffset = 521]
theta[ Multiplication[P][p, q] ] == Multiplication[V][theta[p], theta[q]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q12. Repeat the above steps several times. Are you convinced that theta is a homomorphism? Why?
;[s]
4:0,1;3,0;66,2;71,0;96,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q13. Suppose that the definition of multiplication on V was defined to be Multiplication[V][p, q] = 0 for all p and q (with no change to the addition). Would theta still be a homomorphism? 
;[s]
6:0,1;3,0;74,2;101,0;158,2;163,0;190,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.7 Is V a field?
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
You probably have seen a theorem that states that the range or image of a (commutative) ring under a homomorphism is a (commutative) ring. Therefore, V is a commutative ring. To show that it is also a field, we need to verify that it has a unity and that every nonzero element has an inverse. 
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q14. Does V have a unity? If so, what is it and why is it the unity? 
;[s]
2:0,1;3,0;70,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q15. While we are at it, does V have a zero? If so, what is it and why is it the zero? 
;[s]
2:0,1;3,0;88,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Therefore, we know that V has most of the field properties. The multiplication table for V can answer the question regarding multiplicative inverses.
:[font = input; preserveAspect; rightWrapOffset = 521]
MultiplicationTable[V, Mode -> Visual];
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q16. Is V a field? On what do you base your conclusion?
;[s]
2:0,1;3,0;56,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 521; startGroup]
10.8 Is V what we claimed?
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Recall that at the outset we claimed we would find a field (and call it V) that would be the smallest field containing all the roots of m(x) = x^2 + x + 2. We have defined V above, but we have not yet shown that it contains any roots of m.

It is also true that we were able to do addition and multiplication in V. So then we should be able to take any element in V, square it, add this to itself, and then add the constant polynomial 2 to this result. In other words, one should be able to do arithmetic in this field.

Next, we define a function f that does what we indicated in the previous paragraph:
:[font = input; preserveAspect; rightWrapOffset = 521]
Clear[f, y]
f[y_] := Multiplication[V][y, y] + y + Poly[F, 2, 
	Indeterminate -> x]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q17. What connection is there between the polynomial function m = x^2 + x + 2 defined at the outset and f defined above? Justify your answer.
;[s]
2:0,1;3,0;142,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Now we want to evaluate f at each of the elements in V. In other words, we want to Map f over V. We form pairs of the form {x, f[x]} so we can see the domain elements that create the range elements.
;[s]
5:0,0;83,1;86,0;123,1;132,0;199,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
Map[{#, f[#]}&, Elements[V]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 521]
Note that two elements, Poly[F, x] and Poly[F, 2x + 2] yield zero.
;[s]
5:0,0;24,1;34,0;39,1;54,0;67,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 521]
root1 = Poly[F, x]
root2 = Poly[F, 2x + 2]
:[font = input; preserveAspect; rightWrapOffset = 521]
f[root1]
f[root2]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 521]
Q18. Does the V we created have all the roots of m? Could m have more than two roots over V? (Remember that V is an integral domain, since it is a field.) Is it possible that a smaller field contains these roots? Justify your answers.
;[s]
2:0,1;3,0;235,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 521; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
10.9 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
?Z
:[font = input; preserveAspect; rightWrapOffset = 522]
?Elements
:[font = input; preserveAspect; rightWrapOffset = 522]
?Mod
:[font = input; preserveAspect; rightWrapOffset = 522]
?Poly
:[font = input; preserveAspect; rightWrapOffset = 522]
?PolynomialEvaluation
:[font = input; preserveAspect; rightWrapOffset = 522]
?PolynomialsOver
:[font = input; preserveAspect; rightWrapOffset = 522]
?PolynomialRemainder
:[font = input; preserveAspect; rightWrapOffset = 522]
?PolynomialsUpToDegreeN
:[font = input; preserveAspect; rightWrapOffset = 522]
?Map
:[font = input; preserveAspect; rightWrapOffset = 522]
?Select
:[font = input; preserveAspect; rightWrapOffset = 522]
?PolynomialDivision
:[font = input; preserveAspect; rightWrapOffset = 522]
?Addition
:[font = input; preserveAspect; rightWrapOffset = 522]
?Multiplication
:[font = input; preserveAspect; rightWrapOffset = 522]
?RandomElement
:[font = input; preserveAspect; rightWrapOffset = 522]
?RandomElements
:[font = input; preserveAspect; rightWrapOffset = 522]
?QuotientRing
:[font = input; preserveAspect; rightWrapOffset = 522]
?MultiplicationTable
:[font = input; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
?Indeterminate
^*)
