(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; fontColorBlue = 0]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
Ring Lab 11. Quadratic field extensions
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
11.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
3:0,0;52,1;63,0;64,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.1 Prerequisites
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
To complete this lab, you should be familiar with the construction of quotient rings of the ring of polynomials over a field F. You should also be familiar with irreducible polynomials over a field. This lab does not presume any other prior knowledge of field extensions. Doing Ring Lab 10 would be helpful, but not necessary.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.2 Goals of this Lab
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
The goal of this lab is to provide some experience in working with quadratic field extensions in order to make the general study of finite field extensions easier to understand.
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.3 The general problem
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Not every polynomial with real coefficients has real roots; the simplest example is p(x) = x2 + 1. To find the roots of p(x), we extend the real numbers to the complex numbers. That is, we construct a field that contains the real numbers but also includes some new elements that are roots of p(x). This process of extending a field can be employed to find roots of any nonconstant polynomial over any field. When the polynomial is quadratic, the smallest extension containing a root of this polynomial takes on a simple form.

The general problem we will consider is to find the roots of a quadratic polynomial p(x)=ax2 + b x + c, where a, b, and c are elements of a field F, with a  0. Recall that t is a root of p(x) if p(t) = 0. 
;[s]
5:0,0;92,1;93,0;621,1;622,0;737,-1;
2:3,16,12,Times,0,14,0,0,0;2,21,13,Times,32,12,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q1. Prove that if p(x) has one root in F, then it will also have a second root (possibly identical to the first) in F.
;[s]
2:0,1;2,0;119,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The case when p(x) has its two roots in F is not very interesting. Therefore, consider the case where p(x) has no roots in F; that is, p(x) is irreducible over F. Suppose we have a "larger" field that contains F and also contains a root, z, of p(x) = ax2 + bx + c. 
;[s]
3:0,0;253,1;254,0;266,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,32,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q2. Prove that all positive powers of z can be written in the form s z + t where s and t are elements of F. Hint: start with z2 and then proceed by induction.
;[s]
4:0,1;2,0;126,2;127,0;159,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The result expressed in question 2 tells us exactly what the elements of the smallest extension field look like. A few loose ends may need to be tied together, but you should be able to see that this new field, a quadratic extension of F, is
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 522]
F[z]= {s z + t | s, t in F}
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
where 
					
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 522]
(s z + t) + (s' z + t') = (s + s')z + (t + t') 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
and
:[font = text; inactive; preserveAspect; center; rightWrapOffset = 522]
(s z + t)(s' z + t') = r z + u. 
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
How do we get the product r z + u? This calculation was described in Ring Lab 10, so here we will just review the process.

First think of (s z + t) (s' z + t') simply as a product of two polynomials. We expand this product into a quadratic and then divide by p(x). The remainder from this division is our product, r z + u.
:[font = subsection; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.3.1 Example
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Suppose that F is the field of rational numbers, Q, and p(x) = x2 - x - 1. If W is a root of p(x), the product of 2W + 5 and 3W/ - 7 in Q[W] is 7W/ - 29. 
;[s]
3:0,0;64,1;65,0;155,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[W]
PolynomialRemainder[(2W + 5) (3W - 7), W^2 - W - 1, W]
;[s]
3:0,0;49,1;62,0;64,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q3. In the quadratic extension of the rational numbers that contains W, determine the values of Wn, for n = 2, 3, 4, 5, 6, 7. Can you identify a pattern? An example of how to calculate the value of W3 is given below.
;[s]
6:0,1;2,0;97,2;98,0;199,2;200,0;217,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,21,13,Times,32,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer
:[font = input; preserveAspect; rightWrapOffset = 522]
PolynomialRemainder[W^3, W^2 - W - 1, W]
;[s]
3:0,0;26,1;39,0;41,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Alternatively, we can ask Mathematica to find the real roots of p(x). 
;[s]
3:0,0;26,1;37,0;71,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[x]
Solve[x^2 - x - 1 == 0, x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We select the first root that is provided and call it w. Are Q[w] and Q[W] the same? Not really, but they are isomorphic. 
:[font = input; preserveAspect; rightWrapOffset = 522]
w = x /. (Solve[x^2 - x - 1 == 0, x]//First)
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Now we can verify that the product (2w + 5) (3w - 7) is consistent with the product computed above involving W's. To compare (2w + 5) (3w - 7) and -29 + 7w, we need to expand both sides. 
:[font = input; preserveAspect; rightWrapOffset = 522]
Expand[(2w + 5)(3w - 7)] == Expand[-29 + 7w]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q4. The isomorphism hinted at above would map a + bW to a + bw, where w is the first root given to us by Solve. Could we have used the second root? If W maps into the second root, what would map into w?
;[s]
4:0,1;2,0;105,2;110,0;203,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.4 An extension of Z3 using Mathematica
;[s]
4:0,0;22,1;23,0;30,2;42,-1;
3:2,19,14,Times,1,18,0,0,0;1,21,13,Times,65,12,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Let's continue by reading in the Mathematica code needed for the rest of this lab:
;[s]
3:0,0;33,1;44,0;83,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Consider the polynomial p(x) = x2 + x + 2 over the integers modulo 3, Z3.
;[s]
5:0,0;32,1;33,0;71,2;72,0;74,-1;
3:3,16,12,Times,0,14,0,0,0;1,21,13,Times,32,12,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q5. Verify that none of the elements in Z3, {0, 1, 2}, are roots of p(x)
;[s]
4:0,1;4,0;41,2;42,0;73,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
 Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The extension of Z3 that contains a root z of p(x) can be generated with QuotientRing (see Ring Lab 10). We will shorten the name of Z3[z] to V.
;[s]
7:0,0;18,2;19,0;73,1;85,0;134,2;135,0;145,-1;
3:4,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[x]
p = Poly[Z[3], x^2 + x + 2]
V = QuotientRing[Z[3], p]

:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
When you work with V, be aware of the form of its elements. They all appear as ordinary polynomial expressions, but in fact their internal form is more complicated. We have to use the Poly function to create these. For example, consider the third element in the list, appearing as 2x. Let's get the third element and look at it.
;[s]
5:0,0;184,1;188,0;281,1;283,0;329,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
third = Elements[V][[3]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Is this simply 2x? In other words, can we just use 2x in place of this?
;[s]
5:0,0;15,1;17,0;51,1;53,0;72,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
2x === third
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
No. They have different internal forms. For instance, 2x, to Mathematica is
;[s]
3:0,0;61,1;72,0;76,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FullForm[2x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
which is just the product of 2 and x, as we think of it in ordinary usage. The Mathematica internal form for the third element in V, 2x, is quite different:
;[s]
5:0,0;79,1;90,0;133,2;135,0;157,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
FullForm[third]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
This is significantly more complicated. The reason is that this represents a formal polynomial whose underlying ring is embedded in the structure, as well as several other pieces of data. (Purely optional: this data structure has the head AbstractAlgebra`RingExtensions`Private`poly with two arguments. The first is a list with four sub-arguments and the second is the list of coefficients, starting with the constant term, then linear and so on. The arguments in the first list consist of the underlying ring (in internal form), whether we should view the polynomial from right to left or left to right, the indeterminate that should be used, and finally whether the coefficients are numeric or not. Thankfully, the user does not need to worry about these details.)

Therefore, to use this third element, one either picks it off the list of elements, as done above, or creates it anew with the Poly function. In this case, this polynomial can be obtained by
;[s]
5:0,0;239,1;282,0;895,1;899,0;959,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
newthird = Poly[Z[3], 2x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
It is important that all polynomials are created in this fashion when they are over a ring besides the integers, rationals, reals or complex numbers. Note that this is now identical to third:
;[s]
3:0,0;185,1;190,0;192,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
newthird === third
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
What is more important is the mathematical concept of what this 2x represents. On the one hand, you can just think of it as an abstract element in a new ring, or you can think of it as the coset representative of the coset 2x + <x^2 + x + 2>, since this element really comes from the quotient ring Z3[x]/<x^2 + x + 2>.
;[s]
5:0,0;30,1;42,0;299,2;300,0;319,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
What have we done so far? Let's recap for a moment. We have a polynomial p = x^2 + x + 2 that does not have any roots in Z3. We formed the quotient ring Z3[x]/<x^2 + x + 2> and called it V. We also know (from Ring Lab 10) that this V contains a root (call it z) of p in it, as well as containing Z3 itself. (How does it contain Z3?) We therefore also call V by the name Z3[z]. To verify that z (whatever it turns out to be) is a root of p, we need to represent p's coefficients as elements of V. In other words, we can think of a new p, call it pV, whose coefficients 1, 1, and 2 are constant polynomials in V. We also want the multiplication x * x that yields x^2 to be taking place in V. Hence, we have a new polynomial function as follows:
;[s]
11:0,0;122,1;123,0;154,2;155,0;297,1;298,0;329,1;330,0;371,2;372,0;743,-1;
3:6,16,12,Times,0,14,0,0,0;3,24,16,Times,64,14,0,0,0;2,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Clear[y]
pV[y_] := Multiplication[V][y, y] + y + 
	Poly[Z[3], 2,Indeterminate -> x]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The constant term 2 in p is reflected by using Poly[Z[3], 2, Indeterminate -> x]. (The use of Indeterminate -> x is just for consistency. Since constants do not use an indeterminate, adding this indicates that we are thinking of this as a polynomial in the indeterminate x.)

We have stated that z is a root of p (or of this new version of p, pV), but what is z? We know we have a root if, when we evaluate a polynomial, we get 0. Since z is supposed to be found in V (and we already know that one third of these elements can be dismissed as candidates ---why?), we should perhaps map our new polynomial pV over our elements in V and look for 0 (i.e., Poly[Z[3], 0]).
;[s]
7:0,0;47,1;80,0;94,1;112,0;652,1;665,0;668,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
valuesOfpV = Map[pV, Elements[V]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
We obtain 0 twice. What values of V yielded these? Let's look at V again.
:[font = input; preserveAspect; rightWrapOffset = 522]
Elements[V]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Combining and transposing,
:[font = input; preserveAspect; rightWrapOffset = 522]
Transpose[{Elements[V], valuesOfpV}]//TableForm[#, TableHeadings ->
	{None, {"v in V", "pV[v]\n"}}]&
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
makes it clear that our candidates for z are the elements (polynomials) x and 2x + 2.
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The formation of pV is not particularly pleasant. There is a function called EvaluationInExtension that can do this. Here is how it works.
;[s]
3:0,0;77,1;98,0;139,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
?EvaluationInExtension
:[font = input; preserveAspect; rightWrapOffset = 522]
EvaluationInExtension[V, ModulusPolynomial[V], Poly[Z[3], x]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
One can also give it a list of elements to evaluate:
:[font = input; preserveAspect; rightWrapOffset = 522]
EvaluationInExtension[V, ModulusPolynomial[V], Elements[V]]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q6. Let q = x^2 + 2x + 2 over Z[3]. Show that q is irreducible over Z[3]. Calculate V2 = QuotientRing[Z[3], q]. Find a zero for q in V2.
;[s]
4:0,1;2,0;84,2;110,0;137,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
Recall that to compute a product in V, such as x^2 = (x)(x), you can use Multiplication[V].
;[s]
3:0,0;73,1;90,0;92,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
Multiplication[V][Poly[Z[3], x], Poly[Z[3], x]]
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
For higher powers, it may be easier to use the ElementToPower function:
;[s]
3:0,0;47,1;61,0;72,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
?ElementToPower
:[font = input; preserveAspect; rightWrapOffset = 522]
ElementToPower[V, Poly[Z[3], x], 2]
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q7. Compute more powers of x (x^2, x^3,..., x^9...) until you can identify a pattern. (Hint: using the Table function with ElementToPower is the cleanest way of doing this.)
;[s]
6:0,1;2,0;103,2;108,0;123,2;137,0;174,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522]
Answer
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
If we consider another irreducible quadratic polynomial over Z3, will we need a further extension, or will our original extension contain the second irreducible's roots? 

;[s]
3:0,0;62,1;63,0;172,-1;
2:2,16,12,Times,0,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q8. Verify that q(x) = x2 + 1 has no roots in the Z3, but has both its roots in V.
;[s]
6:0,1;2,0;24,2;25,0;51,3;52,0;83,-1;
4:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,24,16,Times,32,14,0,0,0;1,24,16,Times,64,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Answer
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.5 Theorems that are motivated from this lab.
:[font = text; inactive; preserveAspect; rightWrapOffset = 522]
The calculations that we have performed here suggest several theorems. To prove the theorems, there are many details that need to be shown(). However, the examples in this lab certainly show that the theorems are plausible. 

:[font = special3; inactive; preserveAspect; rightWrapOffset = 522]
Q9. We state these theorems with a few key words left for you to fill in.

Theorem 1. If p(x) is irreducible over F, E = F[z] is a quadratic extension of F containing a root z of p(x), and y is the second root of p(x), then F[z] is ________________________ to F[y].

Theorem 2. If w is a real root of p(x) = x2 + x + 1, then for each positive integer n, 
wn = an + bn w,	where an and bn are consecutive ___________________.
	
Theorem 3. If F is a finite field and F[z] is a quadratic extension of F, then the set of nonzero elements of F[z] with multiplication is a _______ group of order ______	 and z is a __________ of the group.																							
	
Theorem 4. If F is a finite field, a quadratic polynomial p(x) is irreducible over F and z is a root of p(x) in an extension E of F, then every ___________ polynomial over F has its roots in F[z].
;[s]
22:0,1;2,0;75,1;86,0;267,1;278,0;309,2;310,0;356,2;357,0;361,3;362,0;366,3;367,0;378,3;379,0;385,3;386,0;426,1;437,0;658,1;669,0;855,-1;
4:11,16,12,Times,0,14,0,0,0;5,16,12,Times,1,14,0,0,0;2,24,16,Times,32,14,0,0,0;4,24,16,Times,64,14,0,0,0;
:[font = text; inactive; preserveAspect; rightWrapOffset = 522; endGroup]
Note:	these theorems can all be generalized in several directions, so the theorem in your text may not match these exactly. 
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 522; startGroup]
11.6 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect; rightWrapOffset = 522]
?PolynomialRemainder
:[font = input; preserveAspect; rightWrapOffset = 522]
?Solve
:[font = input; preserveAspect; rightWrapOffset = 522]
?Expand
:[font = input; preserveAspect; rightWrapOffset = 522]
?Poly
:[font = input; preserveAspect; rightWrapOffset = 522]
?QuotientRing
:[font = input; preserveAspect; rightWrapOffset = 522]
?Elements
:[font = input; preserveAspect; rightWrapOffset = 522]
?FullForm
:[font = input; preserveAspect; rightWrapOffset = 522]
?Indeterminate
:[font = input; preserveAspect; rightWrapOffset = 522]
?Multiplication
:[font = input; preserveAspect; rightWrapOffset = 522]
?Transpose
:[font = input; preserveAspect; rightWrapOffset = 522]
?EvaluationInExtension
:[font = input; preserveAspect; rightWrapOffset = 522; endGroup; endGroup]
?ElementToPower
^*)
