(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; startGroup]
Ring Lab 13. Finite fields
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
2:0,0;52,1;64,-1;
2:1,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
3:0,0;31,1;78,0;79,-1;
2:2,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
To complete this lab, you should be familiar with the construction of a quotient ring of a ring of polynomials over a field F, as described in Ring Lab 10. You should also be familiar with Morphoids of rings.
;[s]
3:0,0;189,1;198,0;209,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; rightWrapOffset = 504; startGroup]
13.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
The goal of this lab is to introduce some of the properties of finite fields. Until now, we have mostly explored the general situation of polynomials over a ringoid mod an arbitrary polynomial. Now we assume that the base ringoid is a field and the polynomial is irreducible over that field. These assumptions are made easier to enforce by using the FiniteFields package in AbstractAlgebra.
;[s]
5:0,0;350,1;362,0;374,1;389,0;391,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.3 Creation of finite fields
:[font = text; inactive; preserveAspect]
First, we make sure that the AbstractAlgebra packages are available and Rings is the DefaultStructure.
;[s]
7:0,0;29,1;44,0;72,1;77,0;85,1;101,0;103,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; initialization; preserveAspect]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Rings]
(*
:[font = text; inactive; preserveAspect]
The package FiniteFields.m generates finite fields in a fashion similar to how QuotientRing does, but with restrictions on the allowable inputs so that only fields are generated. For example, the ring of polynomials over Z3 mod the polynomial x2 + 2 can be created with QuotientRing. It has 32 = 9 elements.
;[s]
13:0,0;12,1;26,0;79,1;91,0;222,2;223,0;244,3;245,0;270,1;282,0;292,3;293,0;308,-1;
4:7,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;2,21,13,Times,32,12,0,0,0;
:[font = input; preserveAspect]
Clear[x]
R = QuotientRing[Z[3], Poly[Z[3], x^2 + 2]]
:[font = text; inactive; preserveAspect]
As we can see by the result of Inverses, R is not a field.
;[s]
3:0,0;31,1;39,0;59,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Inverses[R, RingOperation -> Multiplication]
:[font = text; inactive; preserveAspect]
This is because the modulus polynomial, x2 +2, can be factored as (x+1)(x+2) over Z3. The built-in function Factor can show this.
;[s]
7:0,0;41,3;42,0;83,2;84,0;108,1;114,0;130,-1;
4:4,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = input; preserveAspect]
Factor[x^2 + 2, Modulus -> 3]
:[font = text; inactive; preserveAspect]
One can also verify this as follows.
:[font = input; preserveAspect]
IrreduciblePolyOverZpQ[Poly[Z[3], x^2 + 2], 3]
:[font = text; inactive; preserveAspect]
The ring R has zero divisors. For example, the product of x + 1 and x + 2 is 0.
:[font = input; preserveAspect]
Multiplication[R][Poly[Z[3], x + 1], Poly[Z[3], x + 2]]
:[font = special3; inactive; preserveAspect]
Q1. Evaluate the cell below, which creates the multiplication table for R. Are there any other zero divisors?
;[s]
2:0,1;2,0;110,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = input; preserveAspect]
MultiplicationTable[R, Mode -> Visual];
:[font = text; inactive; preserveAspect]
In the rest of this lab we can avoid this type of ring by using the GF function. GF[n] returns the Galois field (hence, GF) of order n (if n = pd for some prime p), while GF[n, poly] creates the finite field using the specified irreducible polynomial. Here is a field with nine elements, the same polynomials of degree one or less that are contained in R above, but the multiplication operation is different
;[s]
9:0,0;68,1;70,0;81,1;86,0;144,2;145,0;171,1;182,0;408,-1;
3:5,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;1,24,16,Times,32,14,0,0,0;
:[font = input; preserveAspect]
F1 = GF[9]
:[font = text; inactive; preserveAspect]
In F1, the product of x + 1 and x + 2 is not zero. 
;[s]
3:0,0;41,1;44,0;52,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Multiplication[F1][x + 1, x + 2]
:[font = text; inactive; preserveAspect]
Another advantage to using GF is that the elements of the ringoids that are created are simply ordinary polynomial expressions, as opposed to the more complex structures created with the Poly function.
;[s]
5:0,0;27,1;29,0;187,1;191,0;202,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = text; inactive; preserveAspect]
F1 is a field because its modulus polynomial is irreducible over Z3.
;[s]
3:0,0;66,1;67,0;69,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
FieldIrreducible[F1]
Factor[%, Modulus -> 3]
:[font = text; inactive; preserveAspect]
An alternate irreducible polynomial is also allowed; one simply adds it as a second argument to GF. GF will not allow a reducible polynomial, however.
;[s]
5:0,0;96,1;98,0;100,1;102,0;151,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
GF[9, x^2 + 2]
:[font = text; inactive; preserveAspect]
Here is a valid alternate irreducible polynomial over Z3.
;[s]
3:0,0;55,1;56,0;58,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
F2 = GF[9, x^2 + 2x + 2]
:[font = text; inactive; preserveAspect]
You can check a polynomial to see if it is irreducible with IrreduciblePolyOverZpQ.
;[s]
3:0,0;60,1;82,0;84,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect; endGroup]
Map[IrreduciblePolyOverZpQ[#, 3]&, {x^2 + 2, x^2 +  2x + 2}]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.4 Finite field theorems and illustrations
:[font = text; inactive; preserveAspect]
We will list some of the basic theorems in the theory of finite fields. Your text will likely contain the proofs of them (or they may be exercises). We will illustrate these theorems with examples to give you a better feel for what they say and what their implications are. The first theorem severely restricts the possible size (or order) of a finite field.
:[font = text; inactive; preserveAspect]
Theorem 1. Every finite field is of order pk for some prime p and positive integer k.
;[s]
4:0,2;10,0;43,1;44,0;86,-1;
3:2,16,12,Times,0,14,0,0,0;1,18,12,Times,32,10,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = text; inactive; preserveAspect]
Because of Theorem 1, GF will not accept an order such as 6.
;[s]
3:0,0;22,1;24,0;61,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
GF[6]
:[font = text; inactive; preserveAspect]
For a given order, there is really no variety among fields of that order.
:[font = text; inactive; preserveAspect]
Theorem 2. All finite fields of order pk, p a prime, are isomorphic
;[s]
4:0,2;10,0;39,1;40,0;68,-1;
3:2,16,12,Times,0,14,0,0,0;1,18,12,Times,32,10,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = text; inactive; preserveAspect]
The same field can appear in many different forms and be created in different ways. We illustrate this theorem by generating GF[8] with two different irreducible polynomials over Z2, p1 = x3 + x + 1 and p2 = x3 + x2 + 1. We should be able to create an isomorphism between these fields.
;[s]
11:0,0;125,1;130,0;180,3;181,0;189,2;190,0;209,2;210,0;214,2;215,0;286,-1;
4:6,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;3,21,13,Times,32,12,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = input; preserveAspect]
F3 = GF[8, p1 = x^3 + x + 1]
:[font = input; preserveAspect]
F4 = GF[8, p2 = x^3 + x^2 + 1]
:[font = text; inactive; preserveAspect]
One reasonable guess might be that the identity function is an isomorphism, since the domains are identical.
:[font = input; preserveAspect]
id = FormMorphoid[Identity, F3, F4]
:[font = text; inactive; preserveAspect]
This morphism is certainly one-to-one and onto, but it does not satisfy the morphism property for some pairs. For example, x2 and x, is such a pair. 
;[s]
3:0,0;124,1;125,0;150,-1;
2:2,16,12,Times,0,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = input; preserveAspect]
PreservesQ[id, {x^2, x}, Mode -> Visual]
:[font = text; inactive; preserveAspect]
Another reasonable guess might be that the squaring function that takes each element in F3 to its square (in F4). 
:[font = input; preserveAspect]
theta = FormMorphoid[(ElementToPower[F3, #, 2])&, F3, F4]
:[font = text; inactive; preserveAspect]
This map is one-to-one.
:[font = input; preserveAspect]
OneToOneQ[theta]
:[font = special3; inactive; preserveAspect]
Q2. Is there any need to check whether theta is onto? Why or why not?
;[s]
2:0,1;2,0;70,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
In the end, this attempt fails also. 
:[font = input; preserveAspect]
MorphismQ[theta]
:[font = special3; inactive; preserveAspect]
Q3. Give one concrete example why theta is not a morphism.
;[s]
2:0,1;2,0;59,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
A final attempt begins by looking for the roots of p1 in F3. This is a bit tricky since we need to use the operations of F3 to evaluate a polynomial expression. Here is a function that does this calculation. 
:[font = input; preserveAspect]
evalp1[p_]:= Addition[F3][1, Addition[F3][p, ElementToPower[F3,
	p, 3]]]
:[font = text; inactive; preserveAspect]
Now we evaluate p1 at each element of F3. The first column has an element of F3 and the second is p1 evaluated at the element.
:[font = input; preserveAspect]
Map[{#, evalp1[#]}&, Elements[F3]]//TableForm
:[font = text; inactive; preserveAspect]
We can see that the roots of p1 = x3 + x + 1 are x, x2 and x2 + x. (Why is this the case?) Now consider p2 = x3 + x2 + 1, the irreducible polynomial for F4. Let's see if the roots for p2 are in F3. Again, the function to do the evaluation is a bit messy. 
;[s]
11:0,0;35,1;36,0;53,1;54,0;60,1;61,0;110,1;111,0;115,1;116,0;256,-1;
2:6,16,12,Times,0,14,0,0,0;5,21,13,Times,32,12,0,0,0;
:[font = input; preserveAspect]
evalp2[p_]:= Addition[F3][1, Addition[F3][ElementToPower[F3,
	p, 2], ElementToPower[F3, p, 3]]]
:[font = text; inactive; preserveAspect]
Now we evaluate the modulus polynomial p2 at each element of F3.
:[font = input; preserveAspect]
Map[{#, evalp2[#]}&, Elements[F3]]//TableForm
:[font = text; inactive; preserveAspect]
All three roots of p2 = x3 + x2 + 1 are in F3 also. Notice that they are the roots of p1, with 1 added to each of them. With this observation, we will make an attempt of finding a morphism by generating a function using the rule x -> x + 1. After applying this rule, we simplify the expression. Therefore, the image of x2 will be (x + 1)2, which expands to x2 + 1, since x + x = (1 + 1) x = 0. 
;[s]
13:0,0;25,2;26,0;30,2;31,0;231,1;233,0;320,2;321,0;337,2;338,0;358,2;359,0;395,-1;
3:7,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;5,21,13,Times,32,12,0,0,0;
:[font = special3; inactive; preserveAspect]
Q4. By hand, determine each of the remaining images according to the function that was just described and illustrated.
;[s]
2:0,1;2,0;119,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Now that we have a function in mind to work with, we will use FormMorphoidSetup to determine a position list for forming a Morphoid.
;[s]
5:0,0;62,1;79,0;123,1;131,0;133,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
FormMorphoidSetup[F3, F4];
:[font = text; inactive; preserveAspect]
With the graphic above, you can describe a function using a list such as {a1, a2, ..., a8}. A list of this sort implies that the image of the first entry on the left is the one in position a1 on the right, the image of the second entry on the left is the one in position a2 on the right, and so on. For example, the identity function would be defined by the list {1, 2, 3, 4, 5, 6, 7, 8}. Based on your answer to the previous question, fill in the list corresponding to this attempt at an isomorphism. Evaluate the cell after you have filled in the list.
;[s]
7:0,0;73,1;90,0;189,2;191,0;271,2;273,0;555,-1;
3:4,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
tau = FormMorphoid[{fill this list with an ordering of 1..8 }, 
	F3, F4]
;[s]
4:0,0;20,2;59,1;60,0;73,-1;
3:2,12,10,Courier,1,12,0,0,0;1,12,10,Courier,1,12,65535,0,0;1,12,10,Courier,1,12,0,0,65535;
:[font = text; inactive; preserveAspect]
Your function will be one-to-one and onto if the position list is a permutation of {1, 2, 3, 4, 5, 6, 7, 8}. Now let's see if we have an isomorphism. It should work if you answered question 4 correctly. You should get True for your next output!
;[s]
3:0,0;218,1;222,0;245,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
MorphismQ[tau]
:[font = special3; inactive; preserveAspect]
Q5. It follows from Theorem 2 that the two fields of order 9, F1 and F2 that were generated earlier, are isomorphic. Is the identity function an isomorphism between them? If so, are there more isomorphisms? If not, find at least one isomorphism. 
;[s]
2:0,1;2,0;247,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The nonzero elements of any field form a multiplicative group. In the finite case, the group is particularly simple.
:[font = text; inactive; preserveAspect]
Theorem 3. The multiplicative group of nonzero elements of a finite field is cyclic.
;[s]
2:0,1;10,0;85,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = input; preserveAspect]
G = FormGroupoid[Units[F3], Multiplication[F3]]
:[font = input; preserveAspect]
CyclicQ[G]
:[font = text; inactive; preserveAspect]
The linear monomial term, x in this case, happens to be a generator for GF[n]. To view the powers of x, you can use PowerList. 
;[s]
5:0,0;72,1;77,0;116,1;125,0;128,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
PowerList[F3]//TableForm
:[font = text; inactive; preserveAspect]
Note that this indicates that x6 is x2 + 1. Also, notice that PowerList acts on the whole finite field and will always start with {0, 0}, which is a special case since 0 is not in the group. One could evaluate Rest[PowerList[F3]] to get only the powers of x.
;[s]
9:0,0;31,2;32,0;37,2;38,0;62,1;71,0;210,1;229,0;259,-1;
3:5,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;2,21,13,Times,32,12,0,0,0;
:[font = special3; inactive; preserveAspect]
Q6. To what more common group is G isomorphic? What cyclic groups of order 20 or less are isomorphic to the group of units of some finite field?
;[s]
2:0,1;2,0;145,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The concept of a subfield is similar to that of a subring. A subfield of a field F is a subset of F that is a field, using the operations of F.
:[font = special3; inactive; preserveAspect]
Q7. Find a subfield of GF[16] containing 4 elements. Use Theorem 3 to explain why GF[16] has no subfield of order 8.
;[s]
6:0,1;2,0;23,2;29,0;82,2;88,0;117,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
The previous question generalizes to the following theorem about subfields of a finite field.
:[font = text; inactive; preserveAspect]
Theorem 4. If F is a finite field of order pk, then F has a subfield of order pj if and only if j is a divisor of k.
;[s]
6:0,2;10,0;44,1;45,0;79,1;80,0;117,-1;
3:3,16,12,Times,0,14,0,0,0;2,18,12,Times,32,10,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = text; inactive; preserveAspect]
For example, the field GF[26] has proper subfields of order 2, 22 = 4 and 23 = 8, but not 24 or 25. The only proper subfield of GF[25] has 2 elements.
;[s]
17:0,0;23,1;27,2;28,1;29,0;64,3;66,0;75,3;77,0;91,3;92,0;97,3;98,0;128,1;132,2;133,1;134,0;151,-1;
4:7,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;2,21,14,Courier,32,12,0,0,0;4,21,13,Times,32,12,0,0,0;
:[font = special3; inactive; preserveAspect]
Q8. If p is a prime, what are the divisors of pn - 1? What connection does this have with Theorem 4?
;[s]
4:0,1;2,0;47,2;49,0;101,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504]
Answer: 
:[font = text; inactive; preserveAspect]
Theorem 5. The function f : GF[pn] -> GF[pn] defined by f(a) = ap is an automorphism of GF[pn], called the Frobenius automorphism. 
;[s]
18:0,3;10,0;28,2;32,4;33,2;34,0;38,2;42,4;43,2;44,0;64,5;65,0;88,2;92,4;93,2;94,0;107,1;129,0;132,-1;
6:6,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;6,15,11,Courier,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;3,21,14,Courier,32,12,0,0,0;1,21,13,Times,32,12,0,0,0;
:[font = text; inactive; preserveAspect]
Earlier, we examined a similar function between two versions of GF[23] that were based on different irreducible polynomials and the function was not a morphism. However, the Frobenius automorphism has the same field for both domain and codomain. We can easily create the Frobenius automorphism. The following Morphoid is identical to theta, that is defined above, except that the codomain is changed from F4 to F3. We convert it to the rules format to see the images of each element more easily.
;[s]
7:0,0;64,1;68,2;69,1;70,0;309,1;317,0;496,-1;
3:3,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;1,21,14,Courier,32,12,0,0,0;
:[font = input; preserveAspect]
f = FormMorphoid[(ElementToPower[F3, #, 2])&, F3, F3]//ToRules
:[font = text; inactive; preserveAspect]
The following shows this is an isomorphism.
:[font = input; preserveAspect]
OneToOneQ[f] && MorphismQ[f]
:[font = text; inactive; preserveAspect]
Theorem 6. The group of automorphisms of GF[pn] is the set {f, f2, ..., fn = i} where f is the Frobenius automorphism. 
;[s]
10:0,3;10,0;41,1;45,4;46,1;47,0;64,2;65,0;73,2;74,0;120,-1;
5:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;2,18,12,Times,32,10,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,14,Courier,32,12,0,0,0;
:[font = text; inactive; preserveAspect]
We can create this group of automorphisms easily enough and then look at its table.
:[font = input; preserveAspect]
Aut = GenerateGroupoid[{f}, MorphoidComposition[#1, #2]&,
	WideElements -> True]
:[font = input; preserveAspect]
CayleyTable[Aut, Mode -> Visual, ShowKey -> False];
:[font = special3; inactive; preserveAspect]
Q9. We see that the automorphism group of GF[8] is isomorphic to Z3. What about the automorphism group of GF[16]?  To what is this isomorphic?
;[s]
8:0,2;2,0;42,1;47,0;66,3;67,0;106,1;112,0;143,-1;
4:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,21,13,Times,64,12,0,0,0;
:[font = special2; inactive; preserveAspect; rightWrapOffset = 504; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
13.5 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?QuotientRing
:[font = input; preserveAspect]
?Inverses
:[font = input; preserveAspect]
?ExtensionDegree
:[font = input; preserveAspect]
?FormMorphoid
:[font = input; preserveAspect]
?OneToOneQ
:[font = input; preserveAspect]
?OntoQ
:[font = input; preserveAspect]
?MorphismQ
:[font = input; preserveAspect]
?FormMorphoidSetup
:[font = input; preserveAspect]
?FieldIrreducible
:[font = input; preserveAspect]
?GaloisFieldQ
:[font = input; preserveAspect]
?GF
:[font = input; preserveAspect]
?IrreduciblePolynomial
:[font = input; preserveAspect]
?IrreduciblePolyOverZpQ
:[font = input; preserveAspect]
?PowerList
:[font = input; preserveAspect]
?PrimitivePolynomials
:[font = input; preserveAspect]
?TableOfPowers
:[font = input; preserveAspect; endGroup; endGroup]
?GenerateGroupoid
^*)
