(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Core` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 0. Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`Core *)

(* :Context: AbstractAlgebra`Core` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 1. Startup Core
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Core`",
{"Graphics`Colors`","Graphics`Arrow`","Utilities`FilterOptions`"}];

Off[General::spell,General::spell1];
SetOptions[Graphics, AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2. Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
Addition::usage = "Addition[S] is the addition of the Ringoid S. If S
is a Groupoid, it is simply the Groupoid's operation. Given an
extension Ext of a ring, Addition[Ext] is the addition in this
extension. Addition is also a value for the option Operation that
is used in some ring functions.";

Adjoin::usage = "Adjoin[list, num] returns the elements in list with
num adjoined. If num is already in list, then list is returned. If num
is the nth root of rad, then the set of all 'polynomials' of degree
less than n in the 'indeterminate' rad with coefficients from list is
returned. If num is anything else, the function fails. Adjoin[S, num],
for a structured set S, is equivalent to Adjoin[Elements[S], num].
Adjoin[list, ind, deg] returns the set of polynomials in the
indeterminate ind of degree deg (or less) with coefficients from list.
Adjoin[S, ind, deg], for a structured set S, is equivalent to
Adjoin[Elements[S], ind, deg].";

Any::usage = "Any is a value for the SelectFrom option for
RandomElement and RandomElements. This allows any element to be
returned. Alternatively, one may use NonIdentity (or NonZero or
NonUnity when working with rings).";

AssociativeQ::usage = "AssociativeQ[S] returns True if the structure S
is associative, and False otherwise. When used with rings, one has the
option Operation, which can take on the values Addition,
Multiplication or Both.";

BackgroundColors::usage = "BackgroundColors is a global constant
consisting of a string of colors from the Graphics`Colors` package
that are used for colors in the Cayley table and other similar places.
Although the colors are given in RGBColor format, the default list for
this variable uses the following names of colors:\n {Yellow, Pink,
Orange, Mint, BlueLight, Banana, Green, Brown, Violet, Turquoise,
Gray, Red, Blue, Purple, CadmiumYellow, Maroon, Navy, Salmon,
Aquamarine, Indigo, Lavender, Antique,  Bisque, Burlywood, Eggshell,
Khaki, BlueViolet, CadmiumOrange, CadmiumRedDeep, Cerulean,
Chartreuse, Cyan, DeepPink, EmeraldGreen, GreenDark, Magenta,
OrangeRed, Peacock, SkyBlueDeep, TurquoiseDark, Ultramarine}";

Both::usage = "Both is a value for the Operation option used in
various ring functions.";

CartesianProduct::usage = "CartesianProduct[els1, els2] returns the
Cartesian product of the two sets els1 and els2, as a list of ordered
pairs. CartesianProduct[els1, els2, Partition-> True] partitions the
ordered pairs using the Partition function, cut to the length of els2.
CartesianProduct[listoflists] returns the Cartesian product of the
lists of elements in listoflists.";

CayleyForm::usage = "CayleyForm is an option for CayleyTable (and
functions that form Groupoids or Ringoids) to indicate whether the
elements in the Cayley table should be displayed in InputForm,
OutputForm or some other form. The default value is OutputForm.";

CayleyTable::usage = "CayleyTable[G] returns the Cayley table for the
structure G colored with a different color for each element in G. If
it is desired that Elements[G] be reordered, then CayleyTable[G,
TheSet -> NewOrder] will return a new Cayley table according to the
new ordering of the elements as found in the list NewOrder. When used
with rings, one has the option Operation, which can take on the
values Addition, Multiplication or Both. Other options specific to
CayleyTable (with the default value given in parentheses) are
HeadingsColored (True), ShowOperator (True), ShowName (True),
ShowBodyText (True), ShowSidesText (True), ShowKey (True), VarToUse
('g'), KeyForm (InputForm), and CayleyForm (InputForm).
CayleyTable[{G1,G2,..Gn},opts] returns CayleyTable[G1,opts],
CayleyTable[G2,opts] and so on. Multiple CayleyTables can also be
obtained by using the following variant forms:
CayleyTable[{G1,G2,..Gn}, {opts1, opts2, .. optsn}] (optsi applies to
Gi) and CayleyTable[{{G1, opts1}, {G2, opts2},..{Gn, optsn}}] (optsi
applies to Gi).";

CloseSets::usage = "CloseSets[list1, list2, op] returns a list of all
distinct elements obtained by applying the operation op on the
Cartesian product of list1 and list2]";

ClosedQ::usage = "ClosedQ[S] returns True if the set of elements in
the structure S is closed under its operation, and False otherwise.
Additionally, ClosedQ[S, H] determines whether H is a closed subset of
the structure S. When used with rings, one has the option
Operation, which can take on the values Addition, Multiplication
or Both.";

Closure::usage = "Closure[G, H] returns the subgroup of G generated by
the elements in the set H (assuming H is a subset of G or a Groupoid
whose elements are a subset of G). The option ReportIterations
(defaults to False) indicates whether the result of each iteration is
also returned. The option Staged (defaults to False), applicable if
Mode -> Visual is used, indicates whether or not the graphics are
shown one stage at a time. When set to True, NextStage[Closure]
returns the next iteration and PreviousStage[Closure] returns the
previous iteration. (Adding an integer k as a second parameter to either
NextStage or PreviousStage specifies how many steps to take.)
The option Sort, when set to False (default),
returns the elements in the order they are determined, while when set
to True, returns the elements sorted in the Groupoid.";

ComplementNoSort::usage = "ComplementNoSort[eall, e1, e2, ...] gives
the elements in eall which are not in any of the ei. This is similar
to Complement except the returned values are NOT sorted as they are
with Complement.";

Computational::usage = "Computational is the default setting for the
Mode option for most functions. When Mode -> Computational is set, the
function returns the desired computation with no textual or visual
information given.";

DefaultStructure::usage = "DefaultStructure is a global variable that
has one of two values: Group or Ring. This value indicates what the
default assumption is for various functions that have meanings in both
the Groups and Rings packages. For these functions, this default value
can always be temporarily overridden by using the option Structure ->
Group or Structure -> Ring. This variable can be changed manually or
by using the function SwitchStructureTo.";

Domain::usage = "Domain[f] returns the structure used in the domain of
the Morphoid f. Domain[S] returns the elements in the Groupoid or
Ringoid S; this is equivalent to the function Elements.";

DrawNgon::usage = "DrawNgon[n] draws a regular n-gon (n > 2) with the
vertices labeled with the integers 1 through n.";

ElementQ::usage = "ElementQ[x, S] yields True or False depending on
whether or not x is an element of S, for any structure S.";

Elements::usage = "Elements[S] returns the list of elements contained
in the structured set S (either a Groupoid or Ringoid).
Elements[{S1,S2,..}] returns the elements in each of the structured
sets.";

ElementsQ::usage = "ElementsQ[els, S] yields True or False depending
on whether or not all the items in the list els are elements of the
Structure S.";

ElementToKey::usage = "ElementToKey[G, el] returns the key value used
for el in the Key that is made when the elements in the structure S
are too wide for a graphical image.";
	
ElementToPower::usage = "ElementToPower[G, g, n] returns the nth power
(multiple, in an additive group) of the element g in the structure G,
where n can be any integer).";

Form::usage = "Form is an option when working with the dihedral group
D[n]. By default we have Form -> RotRef. Also possible is Form ->
Permutations. See D for more information. Form is also an option for
QuotientGroup and QuotientRing. Form -> Cosets is the default and
specifies that the elements of the quotient group should appear in
coset form. Form -> Representatives causes the quotient elements to be
represented by a representative from the coset. The option
Representatives can be used to specify these representatives. Form ->
CosetLists is yet another option, where the cosets appear as lists of
elements. Finally, Form is an option for QuaternionGroup; after opening
the Groups package, see this function.";

FormGroupoid::usage = "FormGroupoid[els, op, opsym, opts] is the basic
command for forming a Groupoid consisting of the list els governed by
the operation op. The symbol opsym defaults to '*' if not specified.
The available options for opts are: WideElements, IsAGroup,
Generators, GroupoidDescription, GroupoidName, FormatOperator,
FormatElements, MaxElementsToList, KeyForm, and CayleyForm. See each
of these individually for more information. \n\nIt is strongly recommended to
use this function rather than just wrapping Groupoid around a list and
an operation.";

FormGroupoidByTable::usage = "FormGroupoidByTable[els, tab, opsym,
opts] is a command for generating a Groupoid consisting of the list
els and governed by the operation implicit in the Cayley table tab.
The symbol opsym defaults to '*' unless specified. The available
options for opts are: WideElements, IsAGroup, Generators,
GroupoidDescription, GroupoidName, FormatOperator, FormatElements,
MaxElementsToList, KeyForm, and CayleyForm. See each of these
individually for more information.";

FormRingoid::usage="FormRingoid[list, addition, multiplication,
{plussym, multsymb}, opts] is the basic command for forming a Ringoid
consisting of the list of elements found in list governed by the
operations addition and multiplication. The symbol plussym defaults to
'+' and the multsymb defaults to '*', if not specified. The options
for opts can be: WideElements, IsARing, RingoidDescription, RingoidName,
FormatOperator, FormatElements, MaxElementsToList, KeyForm, and
CayleyForm. See each of these individually for more information.
Alternatively, FormRingoid[AG, MG, opts] forms the Ringoid using the
Groupoid AG for the additive part and the Groupoid MG for the
multiplicative part (assuming the same elements are used).\n\n
It is strongly recommended to use this function rather than just wrapping
Ringoid around a list and the operations.";

FormatElements::usage = "FormatElements is an option for functions
which form Groupoids or Ringoids, whose default value is False. When
set to True, whenever a structured set is displayed, '-elements-' will
be displayed instead of the actual list of elements.";

FormatOperator::usage = "FormatOperator is an option for functions
which form Groupoids or Ringoids, whose default value is True. When
set to True, whenever a structured set is displayed, '-operation-' (or
'-addition-' and '-multiplication-' for Ringoids) will be displayed
instead of the actual definition of the operator(s).";

GaussianIntegers::usage = "GaussianIntegers[n] returns the Ringoid of
Gaussian integers mod n under ordinary complex addition and
multiplication mod n. The use as an option for several built-in
function still works and can be described as follows: GaussianIntegers
is an option for FactorInteger, PrimeQ, Factor and related functions.
With GaussianIntegers -> True, factorization is done over the Gaussian
integers when possible. With GaussianIntegers -> False, factorization
is done over the integers.";

GaussianIntegersAdditive::usage = "GaussianIntegersAdditive[n] returns
the additive Groupoid of Gaussian integers mod n. This is equivalent
to Z[n, I].";

GaussianIntegersMultiplicative::usage =
"GaussianIntegersMultiplicative[n] returns the multiplicative Groupoid
of Gaussian integers mod n. This is equivalent to Zx[n, I].";

GenerateGroupoid::usage = "GenerateGroupoid[gens, op, opsym, opts] is
a command for generating a Groupoid by using the generators in the
list gens governed by the operation op. The symbol opsym defaults to
'*' unless specified. The options for opts can be: WideElements,
IsAGroup, SizeLimit, Generators, GroupoidDescription, GroupoidName,
FormatOperator, FormatElements, MaxElementsToList, KeyForm, and
CayleyForm. See each of these individually for more information.";

GeneratingSet::usage = "GeneratingSet[G] gives a set of generators for
determining G. If {} is returned, this indicates it is not yet known
to Mathematica. The option Generators for FormGroupooid is used to
specify a generating set, as is the first argument for
GenerateGroupoid.";

Generators::usage = "Generators is an option for functions which form
Groupoids, whose default value is {}. Specifying Generators ->
{g1,g2,...} indicates these generators are known to generate this
Groupoid.";

Group::usage = "Group is a value for the Structure option that is used
for several functions, including FormMorphoid Z (including Z[n] and
Z[n, I]).";

GroupIdentity::usage = "GroupIdentity[G] returns the (two-sided)
identity of the Groupoid G, if it exists. If there is no identity, a
message indicates this. HasIdentityQ[G] is similar, except it only
returns True or False regarding the existence of an identity.";

GroupInfo::usage = "GroupInfo[G] returns a list of information
obtained about the Groupoid G which has been gathered by calling
various functions.";

GroupInverse::usage = "GroupInverse[G, g] returns the inverse of g in
G, if it exists, otherwise $Failed.";

GroupQ::usage = "GroupQ[G] returns True if G is a group, and False
otherwise.";

Groupoid::usage = "Groupoid is the 'head' for a pair with the first
component being a set of elements and the second an operation.
Groupoids are one of the basic structures of these packages.";

GroupoidDescription::usage = "GroupoidDescription[G] yields a
description, if available, of the Groupoid G. This can also be set
with the option GroupoidDescription when using the functions
FormGroupoid or GenerateGroupoid. If the empty string is returned
(default value), no description has been given.";

GroupoidName::usage = "GroupoidName[G] yields the name, if given, of
the group G. This can be set with the option GroupoidName in
FormGroupoid and GenerateGroupoid. If the empty string or 'TheGroup'
(default) is returned, no name has been given.";

Groups::usage = "Groups is an acceptable name for the
SwitchStructureTo function.";

HeadingsColored::usage = "HeadingsColored is an option for
CayleyTable. Setting it to True or False determines whether the top
row and left column are colored according to the default coloring of
the elements residing in these positions.";

Identity::usage = "Identity[G] returns the (two-sided) identity of the
structure G, if it exists. If there is no identity, a message
indicates this. For groups, this is identical in functionality to
GroupIdentity[G]. HasIdentityQ[G] is similar, except it only returns True
or False regarding the existence. When used with rings, one has the
option Operation, which can take on the values Addition,
Multiplication or Both and is equivalent to RingIdentity. The standard
(built-in) usage still exists: Identity[expr] gives expr (the identity
operation).";

HasIdentityQ::usage = "HasIdentityQ[S] returns True or False depending on
whether or not the (two-sided) identity (or identities for rings) of
the structure S exists. When used with rings, one has the option
Operation, which can take on the values Addition, Multiplication
or Both. If S is a group, GroupIdentity[S] returns the identity, if
one exists, while for rings, Zero[S] and Unity[S] return the
identities, if they exist.";

Inverse::usage = "Inverse[G, g] returns the inverse of g in G, if it
exists, otherwise $Failed. When used with rings, one has the option
Operation, which can take on the values Addition, Multiplication
or Both. The standard (built-in) usage still exists: Inverse[m] gives
the inverse of a square matrix m.";

InvertibleQ::usage = "InvertibleQ[S, g] returns True if the (two-sided)
inverse of g in the structure S exists, and False otherwise. When used
with rings, one has the option Operation, which can take on the
values Addition, Multiplication or Both.";

Inverses::usage = "Inverses[G] returns a list of ordered pairs of the
form {g, h}. If g has an inverse in G, then h is that element;
otherwise h is 'no inverse'. When used with rings, one has the option
Operation, which can take on the values Addition, Multiplication
or Both.";

HasInversesQ::usage = "HasInversesQ[G] returns True or False depending on
whether all the elements in G have inverses or not. When used with
rings, one has the option Operation, which can take on the values
Addition, Multiplication or Both";

IsAGroup::usage = "IsAGroup is an option for functions which form
Groupoids, whose default value is False. When set to True, the
Groupoid constructed will be assumed to be known as a group.";

IsARing::usage = "IsARing is an option for functions which form
Ringoids, whose default value is False. When set to True, the Ringoid
constructed will be assumed to be known to be a ring.";

KeyToElement::usage = "KeyToElement[S, key] returns the element
corresponding to the value key found in the Key, when the elements
in the structure S are too wide for a graphical image.";

KSubsets::usage = "KSubsets[L, k] returns all subsets of set L
containing exactly k elements, ordered lexicographically. (From
DiscreteMath`Combinatorica`.)";

KeyForm::usage = "KeyForm is an option for CayleyTable (and functions
that form Groupoids or Ringoids) to indicate whether the elements in
the Key of the Cayley table should be displayed in InputForm,
OutputForm or some other form. The default value is InputForm.";

LeftIdentity::usage = "LeftIdentity[G] returns the left identity of
the Groupoid G, if one exists, or $Failed otherwise.";

HasLeftIdentityQ::usage = "HasLeftIdentityQ[G] returns True or False
depending on whether the Groupoid G has a left identity or not. If one
exists, LeftIdentity[G] returns its value.";

LeftInverse::usage = "LeftInverse[G, g] returns the left inverse of g
in G, if it exists, otherwise $Failed.";

LeftInvertibleQ::usage = "LeftInvertibleQ[G, g] returns True if the left
inverse of g in G exists, and False otherwise.";

LeftToRight::usage = "LeftToRight is a value for the ProductOrder option
of MultiplyPermutations and MultiplyCycles, as well for the
PowersIncrease option for Poly (in Rings). When ProductOrder is set to
this value, then MultiplyPermutations[p1,p2] will be computed by taking
p1 followed by p2. For the use in Poly, see PowersIncrease.";

MaxElementsToList::usage = "MaxElementsToList is an option for
functions which form Groupoids or Ringoids, whose default value is 50.
This means that if a structured set has more than 50 elements, it will
default to showing simply {-elements-} instead of the actual list.
Some groups/rings may have lower values.";

Mode::usage = "Mode is an option for many of the functions in these
packages. Standard modes are Computational, Textual and Visual, and
sometimes Visual2. See each of these individually for more
information. The standard (built-in) definition still exists: Mode is
an option to Solve and related functions that specifies in what sense
the equations are to be solved. The possible settings for Mode are
Generic, Modular, and Rational.";

MonoidQ::usage = "MonoidQ[G] returns True if G is a semi-group (closed
binary operation that is associative with an identity), and False
otherwise.";

Multiplication::usage = "Multiplication[R] is the multiplication of
the Ringoid R. Given an extension Ext of a ring, Multiplication[Ext]
is the multiplication in this extension. Multiplication is also a
value for the option Operation that is used in some ring
functions.";

NextStage::usage = "NextStage[func] returns the next stage of an
animation for the function func when Mode is set to Visual.
NextStage[func, k] indicates that k steps forward should be taken. The
functions supporting this include Closure and SubgroupClosure.";

NonAssociatingTriples::usage = "NonAssociatingTriples[G] returns the
triples of elements {a, b, c} in the Groupoid G that do not
associate.";

NonIdentity::usage = "NonIdentity is a value for the SelectFrom option
for RandomElement and RandomElements. This allows any element to be
returned except the identity element, if it exists. Alternatively, one
may use the value Any. Note: for rings, this option excludes both the
zero and unity (if they exist) and other related options are NonUnity
and NonZero.";

Operation::usage = "Operation[G] returns the operation used in the
Groupoid G. Operation is also an option for various ring
functions; possible settings are Addition, Multipication, and Both.";

OperatorSymbol::usage = "OperatorSymbol[G] returns the symbol used for
the operation in the Groupoid G. FormGroupoid and GenerateGroupoid set
this to be * by default.";

Order::usage = "Order[G] returns the cardinality of the set of elements
in the group G. This is identical to the function Size. Order[G, g]
gives the order of the element g in G. This is identical to the function
OrderOfElement. The standard (built-in) definition still exists:
Order[expr1, expr2] gives 1 if expr1 is before expr2 in canonical order,
and -1 if expr1 is after expr2 in canonical order. It gives 0 if expr1
is identical to expr2.";

Ordering::usage = "Ordering[list] gives the permutation that puts the
elements in list in (a canonical) order. If list is a permutation,
this is equivalent to PermutationInverse.";

Output::usage = "Output is an option that can be used when a Visual or
Textual mode is used and determines the form of the output. By default,
the value of the option is Computational, which means that the output
is the normal computation. Alternatively, using Output -> Graphics will
cause the graphics of the Visual mode to be the output (given as
-Graphics-). This is a method of capturing the graphics involved in a
computation instead of the actual computation.";

Partition::usage = "Partition is an option for Cartesian Product.
By default, it is False. When set to True, the list is partitioned
according to the size of the second list. The standard (built-in)
definition still exists: Partition[list, n] partitions list into
non-overlapping sublists of length n. Partition[list, n, d] generates
sublists with offset d. Partition[list, {n1, n2, ...}, {d1, d2, ...}]
partitions successive levels in list into length ni sublists with
offsets di.";

PermutationInverse::usage = "PermutationInverse[perm] gives the
permutation which is the inverse of perm";

PermutationQ::usage = "PermutationQ[e] yields True if e is a list
representing a permutation.";

PlusSymbol::usage="PlusSymbol is an option to FormRingoid to specify
the symbol used for addition in forming a Ringoid. The default is
PlusSymbol->+";

PreviousStage::usage = "PreviousStage[func] returns the previous stage
of an animation for the function func when Mode is set to Visual.
PreviousStage[func, k] indicates that k steps backwards should be taken.
The functions supporting this include Closure and SubgroupClosure.";

ProbableGroupQ::usage = "ProbableGroupQ[G] returns a Boolean value of
True or False depending on whether the tests for a group are valid,
using RandomAssociativeQ instead of AssociativeQ.";

ProperSubsetQ::usage = "ProperSubsetQ[A, B] returns True if A is a
proper subset of B, and False otherwise.";

RandomAssociativeQ::usage = "RandomAssociativeQ[S] returns a Boolean
value of True or False depending on whether the structure S appears to
be associative after 50 random choices of testing a triple of elements
from S. RandomAssociativeQ[S, n] will randomly test n times. When used
with rings, one has the option Operation, which can take on the
values Addition, Multiplication or Both.";

RandomElement::usage = "RandomElement[S] returns a random element from
the Groupoid or Ringoid (or simply list) S. Available options are
SelectFrom -> NonIdentity (this, the default, guarantees that the
identity is not selected for Groupoids and neither the zero nor the
unit is selected for Ringoids), SelectFrom -> NonUnity (which
guarantees the unity is not selected with Ringoids), SelectFrom ->
NonZero (which guarantees the zero is not selected with Ringoids), and
SelectFrom -> Any (which imposes no restrictions). For polynomial
extension rings, the options LowerDegreeOK and Monic are also
available; see these for details (after loading the Rings package).
Additionally, one can obtain a random element from some specialized
sets as follows: RandomElement[Z[Sqrt[p]],max] (for p square-free and
max defaulting to 100) returns a + b Sqrt[p] with both a and b in the
range [-max, max]. One can use p = -1 also, or use equivalently use
Z[I].";

RandomElements::usage = "RandomElements[S, n] returns a set of n
random elements from the Groupoid or Ringoid S. Available options are
SelectFrom -> NonIdentity (this default guarantees that the identity
is not selected for Groupoids and neither the zero nor the unit is
selected for Ringoids), SelectFrom -> NonZero (which guarantees the
zero is not selected with Ringoids), and SelectFrom -> Any (which
imposes no restrictions). Additionally, Replacement -> True will allow
an element to be selected more than once (while set to False will not
allow this). Additionally, one obtain a random element from some
specialized sets as indicated under RandomElement, by adding the final
parameter indicating how many to choose.";

RandomPermutation::usage = "RandomPermutation[n] returns a random
permutation of length n.";

Randomize::usage = "Randomize[list] will randomly permute the elements
in list.";

ReorderGroupoid::usage = "ReorderGroupoid[G, neworder] takes the
Groupoid G and forms a new Groupoid with all the properties of G using
the order of the elements presented in neworder. (Note that
mathematically the result of this and G are identical since groups do
not have an order assumed on the elements. This is simply for the
convenience of using the functions in these packages.)";

Replacement::usage = "Replacement is an option for RandomElement and
RandomElements. The values are True if replacement is to be allowed or
False if not.";

ReportIterations::usage = "ReportIterations is a Boolean option for
Closure. If set to true, all of the iterations of the closing process
will also be shown, in addition to the final result.";

RightIdentity::usage = "RightIdentity[G] returns the right identity of
the Groupoid G, if one exists, or $Failed otherwise.";

HasRightIdentityQ::usage = "HasRightIdentityQ[G] returns True or False
depending on whether the Groupoid G has a right identity or not. If
one exists, RightIdentity[G] returns its value.";

RightInverse::usage = "RightInverse[G, g] returns the right inverse of
g in G, if it exists, otherwise $Failed.";

RightInvertibleQ::usage = "RightInvertibleQ[G, g] returns True if the right
inverse of g in G exists, and False otherwise.";

RightToLeft::usage = "RightToLeft is a value for the ProductOrder option
of MultiplyPermutations and MultiplyCycles, as well for the
PowersIncrease option for Poly (in Rings). When ProductOrder is set to
this value, then MultiplyPermutations[p2,p1] will be computed by taking
p1 followed by p2. For the use in Poly, see PowersIncrease.";

Ring::usage = "Ring is a value for the Structure option that is used
for several functions, including FormMorphoid and Z (including Z[n]
and Z[n, I]).";

RingoidDescription::usage = "RingoidDescription[R] yields a description, if
given, of the ring R. This can be set with the option (of the same
name) RingoidDescription in FormRingoid. If the empty string is returned,
no description has been given.";

RingInfo::usage = "RingInfo[R] returns a list of information obtained
about the Ring(oid) R which has been gathered by calling various
functions.";

Ringoid::usage = "Ringoid is the 'head' for a triple with the first
component a set of elements and the second and third the addition and
multiplication operations. Ringoids are one of the basic structures of
these packages.";

RingoidName::usage = "RingoidName[R] yields the name, if given, of the
group G. This can be set with the option (of the same name)
RingoidName in FormRingoid. If the empty string is returned (or
'TheRing', default), no name has been given.";

Rings::usage = "Rings is an acceptable name for the SwitchStructureTo
function.";

SameSetQ::usage = "SameSetQ[list1, list2] returns True if the sets
list1 and list2 are equal as sets, and False otherwise. Note that this
tests the mathematical equality of two sets and so
SameSetQ[{2,3,1},{1,3,2}] returns True while SameQ[{2,3,1},{1,3,2}]
returns False.";

SelectFrom::usage = "SelectFrom is an option for RandomElement and
RandomElements. For Groups, the values are Any and NonIdentity; the
former allows any element to be returned while the latter will not
return the identity element, if one exists. For Ringoids, NonZero and
NonUnity are also available values.";

SemiGroupQ::usage = "SemiGroupQ[G] returns True if G is a semi-group
(closed binary operation that is associative), and False otherwise.";

ShowBodyText::usage = "ShowBodyText is an option for CayleyTable with
settings True or False depending on whether the text in the body of
the table is to be shown.";

ShowCircle::usage = "ShowCircle[n] creates a unit circle with n points
labeled {0,1,..n-1} starting at (0,1). ShowCircle[n,labels] is similar
except the set labels is used for the labeling.";

ShowFigure::usage = "ShowFigure[n, perm, sym] draws an ngon with
permutation perm applied to the vertices and having Dihedral or Cyclic
symmetry group if sym is D or Z respectively. ShowFigure[perm] will
apply the permutation perm to the vertices of the figure, with the
permutation in list or rule form. Additionally, assuming a figure has
already been drawn, ShowFigure[] will redraw it.";
ShowKey::usage = "ShowKey is an option for CayleyTable with settings
True or False depending on whether the key is shown when the elements
in the set are too wide and a key needs to be used.";

ShowName::usage = "ShowName is an option for CayleyTable with settings
True or False depending on whether the name of the structured set is
to be shown.";

ShowOperator::usage = "ShowOperator is an option for CayleyTable with
settings True or False depending on whether the symbol for the
operation of the structured set is to be shown.";

ShowPermutation::usage = "ShowPermutation[perm] shows a graphics array
of the (predetermined) n-gon (if n>2) 'before' and 'after' the
permutatio perm has been applied. The permutation can be in list form
or rule form. ShowPermutation[n, perm, symtype] combines ShowFigure[n,
IdentityPermutation, symtype] with ShowPermutation[perm].";

ShowSidesText::usage = "ShowSidesText is an option for CayleyTable
with settings True or False depending on whether the text in the top
row and left column (representing the elements of the Groupoid) is to
be shown.";

Size::usage = "Size[S] returns the cardinality of the set of elements
in the structured set S. This is identical to the function Order.";

SizeLimit::usage = "SizeLimit is an option for the GenerateGroupoid
function. By default it is set to 25. When the size of the generated
set exceeds this limit, no further generation will take place.";

SortGroupoid::usage = "SortGroupoid[G] returns the Groupoid with the
elements sorted by the Sort function. Typically, this is already the case.";

Staged::usage = "This is an option for some functions (including
Closure and SubgroupClosure) and can be set to True if an animation is
to be conducted manually using NextStage and PreviousStage, and False
otherwise.";

Structure::usage = "Structure is an option for several functions.
Using Structure -> Group (default in Groups) specifies that this is to
be a group structure, while Structure -> Ring (default in Rings)
specifies that rings are involved. Functions that have this option are
Phi, FormMorphoid and Z.";

SubgroupClosure::usage = "SubgroupClosure[G, H] returns the subgroup
of G generated by the elements in the set H (which is a subset of G).
The option ReportIterations (defaults to False) indicates whether the
result of each iteration is also returned. The option Staged (default
to False), applicable if Mode -> Visual is given, indicates whether or
not the graphics are shown one stage at a time. If set to true,
NextStage[SubgroupClosure] returns the next iteration and
PreviousStage[SubgroupClosure] returns the previous iteration.";

SubgroupQ::usage = "SubgroupQ[H, G] returns True if H is a subgroup of
the group G, and False otherwise. H can be in the form of a list of
elements or a Groupoid consisting of elements of G. Options include
Mode -> Visual2 (as well as the other modes).";

SubsetQ::usage = "SubsetQ[A, B] returns True if A is a subset of B,
and False otherwise.";

SwitchStructureTo::usage = "SwitchStructureTo[structure] sets various
options and definitions so that the given structure is the default.
Acceptable values are Group (or Groups or Groupoid) and Ring (or Rings
or Ringoid).";

TextCayley::usage = "TextCayley[G] returns a simple, text-only version
equivalent of CayleyTable[G, Mode -> Visual].";

Textual::usage = "Mode -> Textual is a common option for many
functions in these packages. Generally, a written description or
definition will be given to help clarify the function/concept being
explored.";

TheSet::usage = "TheSet is an option for the CayleyTable function to
be used to change the order that the elements appear in the
construction of the table. TheSet -> list indicates that Elements[S]
are to be arranged according to the order in list and the Cayley table
is constructed with this ordering. To change the ordering on a more
permanent basis, see ReorderGroupoid, after loading in the Groups
package.";

TimesSymbol::usage ="TimesSymbol is an option to FormRingoid to
specify the symbol used for multiplication in forming a Ringoid. The
default is TimesSymbol->.";

ToPermutation::usage = "ToPermutation[RuleList] returns the
permutation determined by a list of rules. For example, {1->2, 2->1}
becomes {2,1}. Similarly, {{1->2}, {2->1}} becomes {2,1}.
ToPermutation[c, n] rewrites the cycle
c of length <= n as a permutation of length n (or in S[n]).
ToPermutation[c] uses the maximum value appearing in c for n.";

ToRules::usage = "ToRules[f, S] converts the function f
with domain S to a list of rules of the form x -> f[x]. When it is
important to check that the range values belong to a set T, use
ToRules[f, S, T] (which returns $Failed if T does not contain
all the images). S can be a list of values, a Groupoid, or a Ringoid.
ToRules[f], where f is a Morphoid, converts the Morphoid based on a
Function (or Symbol) definition to one based on a Rules definition.
ToRules[perm] converts any permutation (as a list) to a list of rules.
For example, {2,1,3} becomes {1->2, 2->1, 3->3}. The standard
(built-in) usage still exists: ToRules[eqns] takes logical combinations
of equations, in the form generated by Reduce or Roots, and converts
them to a sequence of lists of rules where the sequence corresponds
to Or and the lists correspond to And. {ToRules[eqns]} gives a result of
the form produced by Solve.";

UnionNoSort::usage = "UnionNoSort[list] removes duplicates in list but
does NOT sort list as the Union function does. UnionNoSort[list1,
list2,...] returns a single list with all duplicates removed, but
unsorted. (This also works with other structures besides Lists.)";

VarToUse::usage = "VarToUse is an option for CayleyTable to specify
the generic label for elements in the body of the Cayley table when
the elements are wide and a key (see ShowKey) is used.";

Visual2::usage = "Mode -> Visual2 is an option for some functions in
these packages. Generally, some visual component will be drawn which
is intended to further clarify the meaning of a concept/function.";

Visual::usage = "Mode -> Visual is a common option for many functions
in these packages. Generally, some visual component will be drawn
which is intended to further clarify the meaning of a
concept/function.";

VisualTextShown::usage = "VisualTextShown is a global variable whose
value indicates the number of times any text accompanying a graphic
image should be shown. If multiple graphic images are shown, the text
will never be displayed. For single images, the variable can be set
to Infinity, to always display the text; n, to only show it the first
n times (a particular function is called); or 0, to never show the
text.";

WideElements::usage = "WideElements is an option for functions which
form Groupoids or Ringoids, whose default value is False. When set to
True, any Cayley table will set up a key, under the assumption that
the elements are too wide to fit in the grid of the Cayley table.";

Z::usage = "Z[n] returns the cyclic group of integers mod n under
addition when in the context of groups or the ring of integers mod n
when in the context of rings. The option Structure can be set to Group
or Ring; by default, when either the Groups package is read, it is set
to Group and set to Ring when the Rings package is read. Note that
ZG[args] is equivalent to Z[args, Structure -> Group] while ZR[args]
is equivalent to Z[args, Structure -> Ring]. Z[n, k] returns the group
(or ring) of multiples of k mod n, if k is a divisor of n.
Additionally, Z[n, I] in the Groups package (or Z[n, I, Structure ->
Group] while in the Rings package) returns the additive Gaussian
integers mod n, while Z[n, I] in the Rings package returns the ring of
Gaussian integers mod n.";

ZG::usage = "ZG[n] returns the group of integers mod n with the
operation addition mod n. ZG[n, k] returns the ring of multiples of k
mod n if k is a divisor of n. This is equivalent to Z[n, Structure ->
Group].";

ZR::usage = "ZR[n] returns the ring of integers mod n with operations
addition mod n and multiplication mod n. ZR[n, k] returns the ring of
multiples of k mod n if k is a divisor of n. This is equivalent to
Z[n, Structure -> Ring].";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.4 Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
Adjoin::fail = "The expression `1` needs be an nth root of some number
for this function to work.";

GenerateGroupoid::size = "The size of the set generated thus far exceeds
the current value of `1` given by the option SizeLimit. (The elements
generated thus far are shown below.)";

Group::fail = "The Groupoid `1` fails at least one of the tests for
being a group, which is needed for this function.";

Group::noord = "The element `1` in the Groupoid `2` does have an
order.";

Group::notnorm = "`1` is not a normal subgroup of `2`.";

Groupoid::fail = "In applying this function, it has to act on a
Groupoid. Check to be sure `1` has been properly formed using
FormGroupoid or GenerateGroupoid (or other acceptable means).";

Groupoid::reorderfail = "The elements `2` can not be used to reorder the
elements in `1` since they are not the same list.";

Identity::fail = "`1` does not have an identity.";

Identity::lfail = "`1` does not have a left identity.";

Identity::lmultiple = "`1` has the following left identities: `2`.";

Identity::rfail = "`1` does not have a right identity.";

Identity::rmultiple = "`1` has the following right identities: `2`.";

Inverse::fail = "`1` does not have an inverse in `2`.";

Inverse::noId = "`1` does not have an identity, so the notion of inverse
does not make sense.";

List::lngth = "The two lists are not of the same length.";

MemberQ::elmnt = "`1` is not an element of `2`.";

MemberQ::elmnts = "At least one of `1` is not an element of `2`.";

MemberQ::elsbst = "`1` is neither an element nor a subset of `2`.";

MemberQ::sbgrp = "`1` is not a subgroup of `2`.";

Mode::notavail = "The function `1` does not support the `2` mode.";

Mode::novis = "This function does not support the Visual mode.";

Operation::fail = "The operation of the substructure(s) does not match
that of the parent structure.";

RandomElement::gfail = "Trying to comply with the option SelectFrom ->
`1`, this Groupoid does not have enough elements to still choose a
random element.";

RandomElements::toomany = "You can't ask for `1` random elements when
there are only `2` available.";

RandomElements::toomanyni = "You can't ask for `1` non-identity random
elements when there are only `2` to start with and you don't want the
identity.";

Rule::form = "The list of rules is ill-formed. Each integer from 1 to
`1` should appear exactly once before and after ->.";

TheSet::error = "Some of the elements in `1` do not belong to the set of
elements of this Groupoid. Default value for TheSet, Elements[G], will
be used.";

Groupoid::modd = "The integer `1` does not divide the modulus `2`.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.5 Begin private section
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 3. Core parts
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
global variables/constants
:[font = input; initialization; preserveAspect; endGroup]
*)
Off[Function::slotn]; (* should shut off bug message about problems
with Mod[#1+#2, 5]& *)

If[$VersionNumber >= 3.0, $FormatType = OutputForm];
(* to speed up graphics  in version 3.0 *)

If[$VersionNumber < 3.0, StandardForm = OutputForm];
(* to override above, where needed *)

InStdForm = If[$VersionNumber < 3.0, InputForm, StandardForm];
OutStdForm = If[$VersionNumber < 3.0, OutputForm, StandardForm];

DefaultStructure = Group;

defaultFont = {"Times", 14};

Off[Graphics::optx]; (* only needed for Version 2.2  to handle not
knowing FormatType option to Graphics *)

suppressGraphicsQ = False; (* can remove when all functions converted to ShowModes *)

VisualTextShown = 2; (* how often to show text when Visual mode is used *)

multipleQ = False; (* flag showing whether multiple arguments *)
firstPassQ = True;

BackgroundColors = {Yellow,Pink,Orange,Mint,BlueLight,
	Banana, Green, Brown, Violet,Turquoise,Gray,
	Red, Blue, Purple,CadmiumYellow,Maroon, Navy,Salmon,
	Aquamarine,Indigo,Lavender,Antique,  Bisque,
	Burlywood,Eggshell,Khaki,BlueViolet,CadmiumOrange, CadmiumRedDeep,
	Cerulean,Chartreuse,Cyan,DeepPink,EmeraldGreen,GreenDark,
	Magenta, OrangeRed, Peacock, SkyBlueDeep,TurquoiseDark,Ultramarine};

visualModes = {Visual, Visual2, Visual3};
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
core functions
:[font = input; initialization; preserveAspect; endGroup]
*)
UnionNoSort[lst_] := Apply[Head[lst],Fold[If[MemberQ[#1,#2],#1,Append[#1,#2]]&,
	{First[lst]}, Rest[lst]]]
	
UnionNoSort[first_, rest__] := 
	If[{Head[first]} === Union[Map[Head,{rest}]],
		Apply[Head[first],UnionNoSort[Flatten[Map[Apply[List,#]&,{first, rest}],1]]]]

ComplementNoSort[orig_?VectorQ, remove__?VectorQ] := 
	Fold[DeleteCases, orig, Union[remove]]
	
ComplementNoSort[orig_, remove__] := 
	If[{Head[orig]} === Union[Map[Head,{remove}]],
		Apply[Head[orig],Fold[DeleteCases, Apply[List,orig], 
			Union[Flatten[Map[Apply[List,#]&, {remove}],1]]]]]

CartesianProduct[els1_List,els2_List] :=
	Distribute[{els1,els2},List]
	
CartesianProduct[els1_List,els2_List, Partition-> True] :=
	Partition[CartesianProduct[els1,els2],Length[els2]]

CartesianProduct[els1_List,els2_List, Partition-> False] :=
	CartesianProduct[els1,els2]

CartesianProduct[lists__] :=
	Distribute[List[lists],List]

CloseSets[list1_List,list2_List,op_] := 
	Apply[op,CartesianProduct[list1,list2],{1}]//UnionNoSort
	
gtxQ[n_Integer?Positive, x_Integer] := n > x
gt2Q[n_Integer?Positive] := gtxQ[n,2]
gtyQ[y_Integer?Positive] := (# > y)&
ltyQ[y_Integer?Positive] := (# < y)&

Randomize[S_List]:= 
    Map[S[[#]]&,RandomPermutation[Length[S]]];

showVisTextQ[fn_] := Module[{ok},
	ok = firstPassQ && Which[VisualTextShown === Infinity, True,
		VisualTextShown <= 0, False,
		True, If[Head[visualTextCount[fn]] === visualTextCount,
					visualTextCount[fn] = 1, 
					visualTextCount[fn]++];
			If[visualTextCount[fn] > VisualTextShown,
				False, True]];
	If[multipleQ && firstPassQ, firstPassQ = False];
	ok]

printOtherKey[Els_List] := Module[{fff,rules},
	fff[x_,{n_}] := Rule[ToString[n], x];
	rules = MapIndexed[fff, Els];
	Print[ToString[Join[{Rule["KEY: number",
	"element:"]},rules/.Rule[x_,y_]:> Rule[x,InputForm[y]]]]];
		]

MakeSubstitutionRules[G_, Els_List, lab_String:"g"] := Module[{fff, x, n, out},
	fff[x_,{n_}] := Rule[lab<>ToString[n],x];
	out = MapIndexed[fff, Els];
	KeyRules[G] = out]

KeyToElement[G_, key_] := (If[untestedQ[KeyRules[G]], KeyRules[G] =
	Map[Rule[#,#]&, Elements[G]]];
	If[Head[key]===String, key, ToString[key]] /. KeyRules[G])
	
ElementToKey[G_, el_] := (If[untestedQ[KeyRules[G]], KeyRules[G] =
	Map[Rule[#,#]&, Elements[G]]];
	el /. Map[Reverse,KeyRules[G]])

PrintCayleyKeyQ = True;

PrintCayleyKey[Els_List,name_,G_,form_,lab_String:"g"] := Module[{rules,
		nform},
	nform = If[Head[form] === KeyForm, InputForm, form];
	rules = MakeSubstitutionRules[G,Els, lab];
	If[PrintCayleyKeyQ,
		Print["KEY for "<>ToString[name]<>": label used "<>If[$VersionNumber >2.5,
		"\[Rule]","->"]<>" element:"<>StringRules[rules,nform]],
		PrintCayleyKeyQ = True];
		]

StringRules[rules_, form_] := Module[{lst},
		lst = rules /. Rule[x_,y_] :> Rule[x,ToString[form[y]]];
		If[$VersionNumber < 2.5, ToString[lst],
			lst = lst /. Rule[x_, y_] :> x<>" \[Rule] "<>y;
			lst = "{"<>Table[lst[[i]]<>", ",{i,Length[lst]-1}]<>lst[[Length[lst]]]<>
          "}"]
]
 
genericSublist[els_List, sub_List, lab_:"g"] := 
		Module[{temp},
	temp = Transpose[{els,Table[lab<>ToString[i],
		{i,Length[els]}]}];
	Select[temp, MemberQ[sub,#[[1]]]&]//Transpose//Last
]
(* This is useful for finding the corresponding 'g' labels
for a sublist of a Groupoid whose elements are wide. *)

headingsRectanglesForSublist[els_List, sub_List] := 
		Module[{temp,len = Length[els]},
	temp = Transpose[{els,Table[Rectangle[{i, len},
		{i+1, len+1}],{i,0,len-1}]}];
	Select[temp, MemberQ[sub,#[[1]]]&]//Transpose//Last
]
(* This is useful for finding the rectangles used in the top
headings for a sublist of a Groupoid. *)

SetAttributes[untestedQ, HoldAll];	

untestedQ[thefunction_[args___]] := 
		Head[Evaluate[thefunction[args]]] === thefunction;
(* used to see if a private function has been 'called' 
(actually, whether the array value thefunction[args] has anything
assigned to it or not) *)

ShowModesIterator=0; (* temp for testing *)

Options[ShowModes] = {Output -> Computational};
	
ShowModes[pack_,func_,mymode_,comp_,{textual___},
	{visual___},{visual2___},{visual3___},opts___] := 
		Module[{sc,v,prefix},
sc = Output/.Flatten[{opts, Options[ShowModes]}];
(*ShowModesIterator++;
Print[ToString[func]<>" calling at # "<>ToString[ShowModesIterator]];*)
prefix = pack<>"`Private`";
If[mymode === Textual,
	If[textual=!=Null, 
	ToExpression[StringJoin[prefix,ToString[func],
		"Textual"]][textual],
	Message[Mode::notavail,func,mymode]]];
v = If[MemberQ[visualModes,mymode],
	Switch[mymode,
		Visual,	If[visual===Null,
			Message[Mode::notavail,func,mymode],
			ToExpression[StringJoin[prefix,ToString[func],
				"Visual"]][visual]
			],
		Visual2, If[visual2===Null,
			Message[Mode::notavail,func,mymode],
			ToExpression[StringJoin[prefix,ToString[func],
				"Visual2"]][visual2]],
		Visual3, If[visual3===Null,
			Message[Mode::notavail,func,mymode],
			ToExpression[StringJoin[prefix,ToString[func],
				"Visual3"]][visual3]]]
	];
	If[sc===Computational,comp,v]]
	
SubsetQ[sub_List, main_List] := Module[{i=1,len,ok=True},
	len = Length[sub];
	While[ok && i<=len,
		ok = ok && MemberQ[main,sub[[i]]];
		i++];
	ok]
	
SubsetQ[_, _] := False
	
ProperSubsetQ[sub_List, main_List] := 
	SubsetQ[sub,main] && Union[main] =!= Union[sub]
	
ProperSubsetQ[_, _] := False

SameSetQ[list1_List,list2_List] :=
		SubsetQ[list1,list2] && SubsetQ[list2,list1]
		
SameSetQ[_, _] := False

KSubsets[l_List,0] := { {} }
KSubsets[l_List,1] := Partition[l,1]
KSubsets[l_List,k_Integer?Positive] := {l} /; (k == Length[l])
KSubsets[l_List,k_Integer?Positive] := {}  /; (k > Length[l])
KSubsets[l_List,k_Integer?Positive] :=
	Join[
		Map[(Prepend[#,First[l]])&, KSubsets[Rest[l],k-1]],
		KSubsets[Rest[l],k]
	]
(* KSubsets from Combinatorica *)

ModifiedPartition[els_List, width_Integer?Positive, filler_:""] := 
	Module[{array, rem},
	array = Partition[els, width];
	rem = Mod[Length[els], width];
	If[rem =!= 0, AppendTo[array, Join[Take[els,-rem],
		Table[filler,{width - rem}]]]];
	array]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
functions to handle many cases
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
WhiteSpace = Show[Graphics[{White,Point[{0,0}]}], 
	DisplayFunction -> Identity];
	
ErrorSpace = Show[Graphics[{{Thickness[0.015],RGBColor[1,0,0], Circle[{0,0},1],
	RGBColor[0,0,0], Line[{{-Sqrt[2.0]/2, -Sqrt[2.0]/2},
	{Sqrt[2.0]/2,Sqrt[2]/2}}]}, Text["Graphics Error",{0,-1.15}, {0,0}]}], 
	DisplayFunction -> Identity];
	
handleSimpleMultiple[f_,groupoids_List,mode_] :=
	handleSimpleMultiple[f,groupoids,mode,{}]
				
handleSimpleMultiple[f_,groupoids_?VectorQ,mode_,{opts___?OptionQ}] :=
		Module[{out},
	multipleQ = True; firstPassQ = True;
	If[mode === Computational || mode === Textual,
		out = Map[f[#,opts,Mode -> mode]&,groupoids];
		multipleQ = False; firstPassQ = True;
		out,
		If[MemberQ[visualModes,mode], 
			handleSimpleMultipleVisual[f,groupoids,mode,{opts}]]]]
				
handleSimpleMultiple[f_,args_List,mode_,{opts___?OptionQ}] :=
		Module[{out},
	multipleQ = True; firstPassQ = True;
	If[mode === Computational || mode === Textual,
		out = Map[f[Apply[Sequence,#],opts,Mode -> mode]&,args];
		multipleQ = False; firstPassQ = True;
		out,
		If[MemberQ[visualModes,mode],
			handleSimpleMultipleVisual[f,args,mode,{opts}]]]]

makeGA[g_,n_] := Switch[n, 
	2, Map[If[Head[#]===Graphics,#,ErrorSpace]&, Array[g, n]], 
	3, Map[If[Head[#]===Graphics,#,ErrorSpace]&, Array[g, n]],
	4, Map[If[Head[#]===Graphics,#,ErrorSpace]&, 
		ModifiedPartition[Array[g,n], 2, WhiteSpace], {2}],
	_, Map[If[Head[#]===Graphics,#,ErrorSpace]&, 
		ModifiedPartition[Array[g,n], 3, WhiteSpace], {2}]]
		
handleSimpleMultipleVisual[f_, groupoids_?VectorQ,mode_,{opts___}] := 
	Module[{len,g,ga, ok =  True},
	len = Length[groupoids];
	Check[g[1] = f[groupoids[[1]], Mode -> mode, DisplayFunction -> Identity,
		Output -> Graphics,opts],	ok = False, Mode::notavail];
	If[ok, Do[g[i] = f[groupoids[[i]],
		Mode -> mode,DisplayFunction -> Identity,
		Output -> Graphics,opts],{i,2,len}];
	multipleQ = False; firstPassQ = True;
	ga = makeGA[g, len];
	Show[GraphicsArray[ga],DisplayFunction->$DisplayFunction]];
	Map[f[#,Mode->Computational]&,groupoids]]

handleSimpleMultipleVisual[f_, args_List,mode_,{opts___}] := 
	Module[{len,g,ga, ok = True},
	len = Length[args];
	Check[g[1] = f[Apply[Sequence,args[[1]]], Mode -> mode, DisplayFunction -> Identity,
		Output -> Graphics,opts],	ok = False, Mode::notavail];
	If[ok, Do[g[i] = f[Apply[Sequence,args[[i]]],
		Mode -> mode,DisplayFunction -> Identity,
		Output -> Graphics,opts],{i,2,len}];
	multipleQ = False; firstPassQ = True;
	ga = makeGA[g, len];
	Show[GraphicsArray[ga],DisplayFunction->$DisplayFunction]];
	Map[f[Apply[Sequence,#],Mode->Computational]&,args]]

handlePairedMultiple[f_,many_List, opts_List, mode_] := Module[{temp,
	n},
n = Length[many];
If[Length[opts] =!= n,Message[List::lngth],
	temp = Transpose[{many,opts}];
	temp = Map[{#[[1]],Apply[Sequence,#[[2]]]}&,temp];
	handleSimpleMultiple[f,temp,mode,{}]
]]

handleSimple2Multiple[f_,G_?GroupoidQ, many_List,mode_,{opts___}] :=
		Module[{out},
	multipleQ = True; firstPassQ = True;
	If[mode === Computational || mode === Textual,
		out = Map[f[G,#,opts,Mode -> mode]&,many];
		multipleQ = False; firstPassQ = True;
		out,
		If[mode === Visual || mode === Visual2 || mode === Visual3, 
			Check[handleSimple2MultipleVisual[f,G,many,{opts}, mode],Mode::novis,
			Mode::notavail]]]]

handleSimple2MultipleVisual[f_, G_?GroupoidQ, many_List,{opts___}, mode_] := 
	Module[{len,g,ga, ok = True},
	len = Length[many];
	Check[g[1] = f[G,many[[1]], Mode -> mode, DisplayFunction -> Identity,
		Output -> Graphics,opts],	ok = False, Mode::notavail];
	If[ok, Do[g[i] = f[G,many[[i]],
		Mode -> mode,DisplayFunction -> Identity,
		Output -> Graphics,opts],{i,2,len}];
	multipleQ = False; firstPassQ = True;
	ga = makeGA[g, len];
	Show[GraphicsArray[ga],DisplayFunction->$DisplayFunction]];
	Map[f[G,#,Mode->Computational]&,many]]
	
handleSimple3Multiple[f_,G_?GroupoidQ, many_List,mode_,{opts___}] :=
		Module[{out},
	multipleQ = True; firstPassQ = True;
	If[mode === Computational || mode === Textual,
		out = Map[f[#, G,opts,Mode -> mode]&,many];
		multipleQ = False; firstPassQ = True;
		out,
		If[mode === Visual || mode === Visual2 || mode === Visual3, 
			Check[handleSimple3MultipleVisual[f,G,many,{opts}, mode],Mode::novis,
			Mode::notavail]]]]

handleSimple3MultipleVisual[f_, G_?GroupoidQ, many_List,{opts___}, mode_] := 
	Module[{len,g,ga, ok = True},
	len = Length[many];
	Check[g[1] = f[many[[1]], G, Mode -> mode, DisplayFunction -> Identity,
		Output -> Graphics,opts],	ok = False, Mode::notavail];
	If[ok, Do[g[i] = f[many[[i]],G,
		Mode -> mode,DisplayFunction -> Identity,
		Output -> Graphics,opts],{i,2,len}];
	multipleQ = False; firstPassQ = True;
	ga = makeGA[g, len];
	Show[GraphicsArray[ga],DisplayFunction->$DisplayFunction]];
	Map[f[#,G,Mode->Computational]&,many]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 4. Ngon functions
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
constants
:[font = input; initialization; preserveAspect; endGroup]
*)
insideLabelFactor = 0.75; (* extension factor for inner labeling *)
firstLabelFactor = 1.25; (* extension factor for outer labeling *)
secondLabelFactor = 1.50; (* extension factor for outer labeling *)
thirdLabelFactor = 1.75; (* extension factor for most outer labeling *)

myColorList = {Red, Green, Blue, Yellow, Purple, Orange,
	Turquoise,   Maroon, Navy,Salmon,Aquamarine,
	Violet,Indigo,Lavender,Cyan,DeepPink};

myColorInitials = {"R", "G", "B", "Y", "P", "O", "T", "M",
	"N", "S","A", "V", "I", "L","C", "D"};
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
basic functions
:[font = input; initialization; preserveAspect; endGroup]
*)
ngonCoords[2] = {{2,1},{2,-1},{-2,-1},{-2,1}};
(* special coordinates to make a rectangle and/or Z *)

Ogt2Q[n_Integer?Positive] := n > 2 && OddQ[n]
Egt2Q[n_Integer?Positive] := n > 2 && EvenQ[n]

ngonCoords[n_?Ogt2Q] := 
	ngonCoords[n] =
	Module[{i},
	Table[N[{Sin[2 Pi i/n], Cos[2 Pi i/n]}],
		{i,n}]]
(* coordinates for an ngon such that the "flat" side is
at the "bottom" and point at top; order is such that
we start from the first point AFTER (0,1) and work
clockwise *)

ngonCoords[n_?Egt2Q] := 
	ngonCoords[n] =
	Module[{i},
	Table[N[{Sin[2 Pi i/n - Pi/n], 
		Cos[2 Pi i/n - Pi/n]}],
		{i,n}]]
(* coordinates for an ngon such that a "flat" side is
at the "bottom" and at the "top"; order is such that
we start from the first point AFTER (0,1) and work
clockwise *)

pointsize = 0.045;

ngonColoredDots[n_,perm_?PermutationQ] := 
	ngonColoredDots[n,perm] =
	Module[{num},
	If[n==2,num=4,num=n];
	Graphics[Map[{PointSize[pointsize],
		myColorList[[Part[PermutationInverse[perm],#]]], 
		Point[ngonCoords[n][[#]]]}&, Range[num]]]
	]
(* this simply colors the dots in the order as created
by ngonCoords and then permuted by permutation perm
and then uses colors as found in myColorList *)

ngonGraphics[2,type_] := 
	ngonGraphics[2,type] =
	Module[{l=ngonCoords[2]},
	Which[type === "D",
		Graphics[{Mint, Polygon[l]}],
	type === "Z",
		Graphics[{Mint, Thickness[0.02], 
		Line[{First[l],l[[2]],Last[l],l[[3]]}]}]
	]]
(* creates the basic graphic for a 2-gon, being
either a rectangle ("D") or a Z shape ("Z"). *)

ngonGraphics[n_?gt2Q] := ngonGraphics[n] =
	Module[{i,crds},
	crds = ngonCoords[n];
	Graphics[{{Mint, Polygon[crds]},
		{Black,Line[Append[crds,First[crds]]]}}]
	]
(* creates basic graphic for an ngon *)

ngonLabeling[n_Integer?Positive, perm_?PermutationQ, 
	scale_,labelList_List:{}] := ngonLabeling[n,perm,
		scale,labelList] = 
	Module[{i,num,p,lablst},
		If[n == 2, num = 4, num = n];
		p = PermutationInverse[perm];
		If[labelList === {}, lablst = Range[num],
			lablst = labelList];
		Graphics[Release[Table[Text[lablst[[Part[p,i]]],
			scale*ngonCoords[n][[i]]], {i,num}]]]
	]
(* This creates the labels for the ngon, by default using
the integers 1..n, but alternatively labelList. These are
then permuted by perm. With 1 being the distance from
origin to ngon, scale indicates where labels should
appear.*)

makeExtensions[n_?gt2Q] := makeExtensions[n] =
	Module[{i,mylist,extfact},
		extfact = .05 n;
		mylist=Table[Line[{ngonCoords[n][[i+1]],
			{(1+extfact) ngonCoords[n][[i+1]][[1]] -
			extfact ngonCoords[n][[i]][[1]], 
			(1+extfact) ngonCoords[n][[i+1]][[2]] -
			extfact ngonCoords[n][[i]][[2]]}}],{i,n-1}];
			AppendTo[mylist,
			Line[{ngonCoords[n][[1]],
			{(1+extfact) ngonCoords[n][[1]][[1]] -
			extfact ngonCoords[n][[n]][[1]], 
			(1+extfact) ngonCoords[n][[1]][[2]] -
			extfact ngonCoords[n][[n]][[2]]}}]];
		Graphics[mylist,AspectRatio->Automatic]]
(* this adds "wings" to an ngon so as to destroy any
reflectional symmetry, forcing only rotational symmetry *)
(*
:[font = subsection; inactive; initialization; Cclosed; preserveAspect; startGroup]
drawing them now 
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DrawNgon[n_?gt2Q] := 
	Show[{ngonGraphics[n],ngonLabeling[n,Range[n],
		firstLabelFactor]}]

makeGraphicsForFigure[n_,num_,perm_,third___] :=
	makeGraphicsForFigure[n,num,perm,third] =
	Module[{extra={},type},
		If[n==2,type = third,extra = third];
		{Switch[n, 2, ngonGraphics[2,type],
							_,ngonGraphics[n]],
				ngonLabeling[n,perm,firstLabelFactor,Range[num]],
				(*ngonLabeling[n,perm,secondLabelFactor,
					myColorInitials],*)
				extra,
				ngonColoredDots[n,perm]}
	] (* see showFigure for explanations of 'third' argument *)	

makeFigure[n_Integer?Positive, perm_?PermutationQ, opt___] :=
	Module[{num},
		If[n == 2, num = 4, num = n];
		Show[makeGraphicsForFigure[n,num,perm,opt],
			DisplayFunction -> Identity]]
(* opt would be "Z" or "D" if n = 2; otherwise it can be
an optional graphics image imposed on the rest if n > 2 
Note that this does NOT show it - only make it.*)

showFigure[n_Integer?Positive, perm_?PermutationQ, opt___] :=
	Module[{num},
		If[n == 2, num = 4, num = n];
		Show[makeGraphicsForFigure[n,num,perm,opt]]]
(* opt would be "Z" or "D" if n = 2; otherwise it can be
an optional graphics image imposed on the rest if n > 2 *)

showFigure[n_Integer?Positive, perm_?PermutationByRulesQ, opt___] :=
	showFigure[n, ToPermutation[perm], opt]

ShowFigure[n_Integer?Positive,perm_?PermutationQ,sym___] := 
	(currentFigureData = {n,perm,sym};
	If[n==2, showFigure[n,perm,sym],
		Switch[ToString[sym],
			"D",showFigure[n,perm],
			"Z",showFigure[n,perm,makeExtensions[n]],
			_,showFigure[n,perm,sym]]]);

ShowFigure[perm_?PermutationQ] := Module[{n,sym,myperm},
	If[Head[currentFigureData] =!= List,
		Print["You have not yet created a figure! I am guessing!"];
		Print["Read your directions or try ?ShowFigure."];
		n = 5; sym = "D";myperm = Range[n],
		n = currentFigureData[[1]];
		myperm = perm;
		sym = currentFigureData[[3]]];
	ShowFigure[n,myperm,sym];
	]

ShowFigure[] := 
	If[Head[currentFigureData] =!= List,
		ShowFigure[{1,2}],
		ShowFigure[currentFigureData[[2]]]]

ShowFigure[perm_?PermutationByRulesQ] := 
	ShowFigure[ToPermutation[perm]]

ShowPermutation[perm_?PermutationByRulesQ] := 
	ShowPermutation[ToPermutation[perm]]

ShowPermutation[perm_?PermutationQ] := Module[{n,sym,myperm},
	If[Head[currentFigureData] =!= List,
		Print["You have not yet created a figure! I am guessing!"];
		Print["Read your directions or try ?ShowFigure."];
		n = 5; sym = "D";myperm = Range[n],
		n = currentFigureData[[1]];
		myperm = perm;
		sym = currentFigureData[[3]]];
	If[n==2,
		ShowPermutation[n,myperm,sym],
		If[sym =!= "Z", ShowPermutation[n,myperm],
			ShowPermutation[n,myperm,makeExtensions[n]]]];
	perm
	]

displayTextYet = 0;

ShowPermutation[n_Integer?Positive,perm_?PermutationQ,opt___] :=
	Module[{num,g1,g2},
		If[n == 2, num = 4, num = n];
		g1 = Show[makeGraphicsForFigure[n,num,Range[num],opt],
			DisplayFunction-> Identity,PlotLabel -> "Before"];
		g2 = Show[makeGraphicsForFigure[n,num,perm,opt],
			DisplayFunction-> Identity,PlotLabel -> "After"];
		Show[GraphicsArray[{g1,g2}],DisplayFunction-> 
			$DisplayFunction];
		If[displayTextYet < 3,
			Print["The figure on the left represents the
original figure and the one on the right exhibits the effect of
the transformation determined by the given permutation."];
			displayTextYet++];
		]

ShowPermutation[n_Integer?Positive, perm_?PermutationByRulesQ, opt___]:=
	ShowPermutation[n, ToPermutation[perm], opt]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 6. Functions for unit circles
:[font = input; initialization; preserveAspect; endGroup]
*)
SetAttributes[ngonDot,Listable];

ngonDot[pos_Integer,n_Integer?Positive, theColor_] := 
	ngonDot[pos,n,theColor] = 
		Graphics[{PointSize[0.055], theColor, 
			Point[ngonCoordsC[n][[pos]]]}]
(* produces graphics for a dot on an ngon on unit circle at
position pos with color theColor *)

ngonDot[pos_Integer,n_Integer?Positive, theColor_, theSize_] := 
	ngonDot[pos,n,theColor,theSize] = 
		Graphics[{PointSize[theSize], theColor, 
			Point[ngonCoordsC[n][[pos]]]}]
(* as above but allows specifying the size as well *)

ngonLine[pos_Integer,n_Integer?Positive, theColor_] :=
	ngonLine[pos,n,theColor] =
	Graphics[{theColor,Line[{ngonCoordsC[n][[pos-1]],
		ngonCoordsC[n][[pos]]}]}]
(* is this used? *)

ngonLine[pos1_Integer?Positive,pos2_Integer?Positive, 
		n_Integer?Positive, theColor_] :=
		ngonLine[pos1,pos2,n,theColor] = 
	Graphics[{theColor,Line[{ngonCoordsC[n][[pos1]],
		ngonCoordsC[n][[pos2]]}]}]
(* can this be used? *)

(* modNgonLabeling[n_Integer?Positive] := 
	modNgonLabeling[Range[0,n-1],insideLabelFactor]*)

modNgonLabeling[n_Integer?Positive] := 
	LabelingNgon[Range[0,n-1], Range[0,n-1], insideLabelFactor, InStdForm]
	 	
LabelingNgon[points_List, chosenLabels_List, scale_, form_] := 
	Module[{lst, n = Length[points],pos},
	lst = Table[Text[form[points[[i]]], 
	 	scale ngonCoordsC[n][[i]],{0,0}], {i,n}];
	pos = (Map[Position[points,#]&, chosenLabels]//Flatten);
	Graphics[lst[[pos]], DefaultFont -> defaultFont]]
	
(* modNgonLabeling[Labels_List] := 
	modNgonLabeling[Labels,firstLabelFactor] *)

modNgonLabeling[Labels_List] := 
	LabelingNgon[Labels,Labels, firstLabelFactor, InStdForm]

(* modNgonLabeling[Labels_List,scale_] :=  
	Module[{i,n},
		n = Length[Labels];
		Graphics[Release[Table[Text[StandardForm[Labels[[i]]], 
	 	scale ngonCoordsC[n][[i]],{0,0}], {i,n}]]]
	]*)

modNgonLabeling[Labels_List,scale_] :=  
	LabelingNgon[Labels,Labels, scale, InStdForm]
	
(* places Labels on the unit circle uniformly starting at
(0,1) and proceeding clockwise at location scale times
a unit vector (to circle) *)

AngleList[n_Integer?Positive] :=
Table[k, {k, -3 Pi/2 + 2 Pi/n, Pi/2, 2 Pi/n}]//Reverse

ptLabeling[crd_,lab_] := Graphics[Text[InStdForm[lab],
	firstLabelFactor*crd, {0,0}]]
(* used if a single pt is to be labeled *)

ngonCoordsC[(n_Integer?Positive)] := ngonCoordsC[n] =
	Module[{i},
	Table[N[{Cos[Pi/2 - 2 Pi i/n], Sin[Pi/2 - 2 Pi i/n]}],
		{i,0, n-1 }]]
(* similar to ngonCoords, but this always starts at (0,1) *)

rad = 1.3;

modCircle[n_Integer?Positive, k_Integer?Positive] := 
	{Graphics[{White,Rectangle[{-rad,-rad},{rad,rad}],
	Purple,Circle[{0,0},1]}],
	Map[ngonDot[#,n,Red,0.035]&,Range[n]], 
	Map[ngonDot[#,n,Blue,0.055]&,Table[i, {i, 1, n, k}]]}//Flatten
		
modCircle[n_Integer?Positive] := 
	modCircle[n, Blue, 0.055]

modCircle[n_Integer?Positive, color_] := 
	modCircle[n, color, 0.055]

modCircle[n_Integer?Positive, color_, size_] := 
	{Graphics[{White,Rectangle[{-rad,-rad},{rad,rad}],
	Purple,Circle[{0,0},1]}],
	Map[ngonDot[#,n,color,size]&,Range[n]]}//Flatten
(* make circle with n uniform points dotted *)

modPoint[a_Integer,n_Integer?Positive, theColor_] := 
	modPoint[a,n,theColor] = 
	ngonDot[Mod[a,n]+1,n,theColor]
(* only differs from ngonDot in that we apply mod (n) to a *)

modPoint[a_Integer,n_Integer?Positive, theColor_, size_] := 
	modPoint[a,n,theColor] = 
	ngonDot[Mod[a,n]+1,n,theColor, size]
(* only differs from ngonDot in that we apply mod (n) to a *)

MakeCircle[n_Integer?Positive, k_Integer?Positive, labels_] := 
	Show[{modCircle[n,k], LabelingNgon[labels,labels,insideLabelFactor,InputForm]},
	 DisplayFunction -> Identity, 
		DefaultFont -> defaultFont,
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]

MakeCircle[n_Integer?Positive, k_Integer?Positive, labels_, form_] := 
	Show[{modCircle[n,k], LabelingNgon[labels,labels,insideLabelFactor,form]},
	 DisplayFunction -> Identity, 
		DefaultFont -> defaultFont,
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]
		
MakeCircle[n_Integer?Positive, labels_] := 
	Show[{modCircle[n], LabelingNgon[labels,labels,insideLabelFactor,InputForm]},
	DisplayFunction -> Identity, 
		DefaultFont -> defaultFont,
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]

MakeCircle[n_Integer?Positive, labels_, color_] := 
	Show[{modCircle[n, color], LabelingNgon[labels,labels,insideLabelFactor,InputForm]},
	DisplayFunction -> Identity, 
		DefaultFont -> defaultFont,
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]

MakeCircle[n_Integer?Positive, labels_, color_, form_] := 
	Show[{modCircle[n, color], LabelingNgon[labels,labels,insideLabelFactor,form]},
	DisplayFunction -> Identity, 
		DefaultFont -> defaultFont,
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]
			
ShowCircle[labels_List, form_] :=  
	Show[{modCircle[Length[labels]],
	LabelingNgon[labels, labels, insideLabelFactor, form]},
		DefaultFont -> defaultFont, 
			If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]

ShowCircle[labels_List] := ShowCircle[labels, InputForm]
	
ShowCircle[n_Integer?Positive,labels_] := 
	ShowCircle[labels]

ShowCircle[n_Integer?Positive] := 
	ShowCircle[Range[0,n-1]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 12. Misc.
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
permutation stuff
:[font = input; initialization; preserveAspect; endGroup]
*)
RandomPermutation[n_Integer?Positive] :=
		Map[ #[[2]] &, Sort[Array[{Random[], #} &, n]]]
		(* slightly modified from Permutation package*)
	
RandomPermutation[n_] :=	
	(Message[RandomPermutation::intpm, "RandomPermutation["<>ToString[n]<>"]",1];
	$Failed)
	
PermutationQ[e_] := Module[{t},
	Off[Sort::normal];
	t = TrueQ[Sort[e] == Range[Length[e]]];
	Off[Sort::normal];
	t](* slightly modified from Permutation package*)

Ordering[list_List] :=
   Map[Last, Sort[Transpose[{list, 
   		Range[Length[list]]}]]]
   		
(* The above is from the permutation package from Mathematica *)

PermutationInverse[list_?PermutationQ] := Ordering[list]

PermutationByRulesQ[e_] := Module[{t},
	Off[Part::partd];
	t = Apply[And,Map[(Head[#] === Rule)&,Flatten[e]]];
	On[Part::partd];
	t]

ToPermutation[args__] := 
	ToPermutation[Flatten[{args}]]

ToPermutation[myrule:{_List..}] := 
	ToPermutation[Flatten[myrule]]
(* this assumes the full set of rules is given and then
produces the list form of a permutation *)

ToPermutation[somerules:{_Rule..}] := 
		Module[{listrules = Transpose[somerules/.Rule->List],dom},
	dom = listrules//First;
	If[Apply[Equal,Map[Union,listrules]],
		Transpose[Sort[Join[Map[#->#&,Complement[Range[Max[dom]],dom]],
		somerules]/.(x_Integer -> y_Integer) :> {x,y}]][[2]],
		Message[Rule::form,Length[myrule]];$Failed]]
(* this assumes the full set of rules is given and then
produces the list form of a permutation *)
(*
;[s]
3:0,0;519,1;585,0;1436,-1;
2:2,12,10,Courier,1,12,0,0,0;1,12,9,Times,1,12,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
other stuff
:[font = input; initialization; preserveAspect; endGroup]
*)
SwitchStructureTo[x_] := 
(If[MemberQ[{Group, Groups, Groupoid, Groupoids},x],
	DefaultStructure = Group;
	Options[ClosedQ]={Mode -> Computational, Structure :> DefaultStructure};
	Options[AssociativeQ]={Mode -> Computational, Structure :> DefaultStructure};
	Options[RandomAssociativeQ]={Mode -> Computational, Structure :> DefaultStructure};
	Options[HasIdentityQ]={Mode -> Computational, Structure :> DefaultStructure};
	Options[GroupIdentity]={Mode -> Computational, Structure :> DefaultStructure};
	Options[InvertibleQ]={Mode -> Computational, Structure :> DefaultStructure};
	Options[GroupInverse]={Mode -> Computational, Structure :> DefaultStructure};
	Options[HasInversesQ]={Mode -> Computational, Structure :> DefaultStructure};
	Options[RandomElement]={SelectFrom -> NonIdentity};
	Options[Inverses]={Mode -> Computational, Structure :> DefaultStructure};
	Options[Z]={Mode -> Computational, Structure :> DefaultStructure};,
	If[MemberQ[{Ring, Rings, Ringoid, Ringoids},x],
		DefaultStructure = Ring;
		Options[ClosedQ]={Mode -> Computational, Structure :> DefaultStructure, 
			Operation -> Both};
		Options[AssociativeQ]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[RandomAssociativeQ]={Mode -> Computational, 
			Structure :> DefaultStructure, Operation -> Both};
		Options[HasIdentityQ]={Mode -> Computational, Structure :> DefaultStructure, 
			Operation -> Both};
		Options[GroupIdentity]={Mode -> Computational, Structure :> DefaultStructure};
		Options[InvertibleQ]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[GroupInverse]={Mode -> Computational, Structure :> DefaultStructure};
		Options[HasInversesQ]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[Inverses]={Mode -> Computational, Structure :> DefaultStructure,
			Operation -> Both};
		Options[RandomElement]= {SelectFrom -> AbstractAlgebra`RingProperties`NonZero, 
			AbstractAlgebra`RingProperties`LowerDegreeOK -> False, 
			AbstractAlgebra`RingProperties`Monic -> False, 
			AbstractAlgebra`RingProperties`SelectBaseElementsFrom -> Any};
		Options[Z]={Mode -> Computational, Structure :> DefaultStructure};
		(*AbstractAlgebra`RingProperties`DistributiveQ[ZR[3]];*) (* dummy call to RingProperties *)
		]];x)
		
SwitchStructureTo[Group];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Adjoin
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Adjoin[R_?StructuredSetQ, alpha_Symbol, deg_Integer?Positive] := 
		Adjoin[Elements[R], alpha, deg]

Adjoin[R_List, alpha_Symbol, 0] := R

Adjoin[R_?StructuredSetQ, alpha_Symbol, 0] := Elements[R]
		
Adjoin[R_List, alpha_Symbol, deg_Integer?Positive] := 
		Module[{els = R, k},
	Map[Expand,Map[Dot[Table[alpha^k,{k,0,deg}], #]&, CartesianProduct[
		Sequence@@Table[els,{deg+1}]]]]]
		
Adjoin[R_?StructuredSetQ, num_] := 
		Adjoin[Elements[R], num]

Adjoin[R_List, Times[Complex[0,1], Power[d_?squareFreeQ, Rational[1,2]]]] := 
		Module[{deg,n,x},
	deg = 2;
	Adjoin[R,x,deg-1]/.x -> Sqrt[-d]]

Adjoin[R_List, num_] := 
		Module[{deg,n,x},
	If[MemberQ[R, num], Adjoin[R, x, 0],
		If[Head[num]===Power,
			deg = num/. Power[_,Rational[_,n_]] :> n;
			Adjoin[R,x,deg-1]/.x -> num,
			Message[Adjoin::fail, num]; $Failed]]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 16. Constructing Groupoids and Ringoids
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.1 general information
:[font = input; initialization; preserveAspect; endGroup]
*)
Format[groupoid[list_,op_, ei___]] := 
	If[FormatElsQ[groupoid[list,op, ei]],
		If[FormatOpQ[groupoid[list,op,ei]],
			Groupoid[{"-Elements-"},"-Operation-"],
			Groupoid[{"-Elements-"},op]],
		If[FormatOpQ[groupoid[list,op,ei]],
			Groupoid[list,"-Operation-"],
			Groupoid[list,op]]]
						
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

Format[ringoid[list_,aop_,mop_, ei___]] := 
	If[FormatElsQ[ringoid[list,aop,mop,ei]],
		If[FormatOpQ[ringoid[list,aop,mop,ei]],
			Ringoid[{"-Elements-"},"-Addition-","-Multiplication-"],
			Ringoid[{"-Elements-"},aop,mop]],
		If[FormatOpQ[ringoid[list,aop,mop,ei]],
			Ringoid[list,"-Addition-","-Multiplication-"],
			Ringoid[list,aop,mop]]]
			
RingoidQ[R_] := (Head[R]===Ringoid || Head[R]===ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_ringoid..}] := Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

StructuredSetQ[S_] := GroupoidQ[S] || RingoidQ[S]

StructuredSetQ[S_List] := Map[StructuredSetQ,S]

Elements[S_?StructuredSetQ] := Elements[S] = First[S]

Elements[many_List] := Map[Elements,many]

Domain[S__] := Elements[S]

theGroupName[G_] := If[GroupoidName[G]==="" || untestedQ[GroupoidName[G]],
	"TheGroup", GroupoidName[G]]
	
theRingName[R_] := If[RingoidName[R]==="" || untestedQ[RingoidName[R]],
	"TheRing", RingoidName[R]]	
	
StructureName[S_?GroupoidQ] := theGroupName[S]

StructureName[S_?RingoidQ] := theRingName[S]

Operation[G_?GroupoidQ] := Operation[G] = G[[2]]

Operation[many:{_?GroupoidQ..}] := Map[Operation,many]

Operation[G_?RingoidQ] := Operation[G] = G[[2]]

Addition[G_?GroupoidQ] := Operation[G]

Addition[R_?RingoidQ] := Addition[R] = R[[2]];

Addition[many:{_?StructuredSetQ..}] := Map[Addition,many]

Multiplication[R_?RingoidQ] := Multiplication[R] = R[[3]];

Multiplication[many:{_?RingoidQ..}] := Map[Multiplication,many]
		
ProcessInfo[G_?GroupoidQ,opts___] := Module[{gQ,test},
	gQ = If[!untestedQ[groupQ[G]],groupQ[G],False];
	test = IsAGroup/.{opts};
	If[test || gQ, gQ = True, gQ = False];
	If[gQ, HasIdentityQ[G] = True;
		ClosedQ[G] = True;
		AssociativeQ[G] = True;
		HasInversesQ[G] = True];]
		
ProcessRingInfo[G_?RingoidQ,opts___] := Module[{gQ,test},
	gQ = If[!untestedQ[ringQ[G]],ringQ[G],False];
	test = IsARing/.{opts};
	If[test || gQ, gQ = True, gQ = False];
	If[gQ, HasIdentityQ[G, Operation -> Addition] = True;
		ClosedQ[G, Operation -> Both] = True;
		AssociativeQ[G, Operation -> Both] = True;
		CommutativeQ[G, Operation -> Addition] = True;
		AbstractAlgebra`RingProperties`DistributiveQ[G] = True;
		HasInversesQ[G, Operation -> Addition] = True];]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.2 FormGroupoid
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[FormGroupoid] = {CayleyForm -> OutputForm, FormatElements -> False,
FormatOperator -> True, 
Generators -> {}, GroupoidDescription -> "", GroupoidName -> "TheGroup", 
IsAGroup -> False, KeyForm -> InputForm, MaxElementsToList -> 50, 
WideElements -> False};
	
Options[FormGroupoidExtra] = {ExtraInformation -> {{},{},{},{},{}}};
(* Information that can go here: {{True/False if group or not},
	{identity or Null}, {quick function to
	calculate inverses}, 
	{a minimal generating set for additive group}, {any other extra
	information entered on ad hoc basis for special functions - best
	to use rules here}}
	Finally, in the forming functions, a sixth list includes all options 
	given when formed. *)

GatherGroupoidOptions[G_?GroupoidQ] := Sequence[WideElements -> WideElementsQ[G],
	GroupoidDescription -> GroupoidDescription[G], GroupoidName -> GroupoidName[G],
	FormatOperator -> FormatOpQ[G], FormatElements -> FormatElsQ[G],
	KeyForm -> KeyForm[G], CayleyForm -> CayleyForm[G]]

GatherSubGroupoidOptions[G_?GroupoidQ] := Sequence[WideElements -> WideElementsQ[G],
	GroupoidDescription -> "Subgroupoid of "<> GroupoidDescription[G], 
	GroupoidName -> "sub "<>GroupoidName[G],
	FormatOperator -> FormatOpQ[G], FormatElements -> FormatElsQ[G],
	KeyForm -> KeyForm[G], CayleyForm -> CayleyForm[G]]

FormGroupoid[list_List, op_, opsymb_String:"*", opts___?OptionQ] :=
	Module[{G,wideq,groupq,genset,grpdesc,grpnm,optional,formop,
	formels,maxshow,keyForm,cayleyForm,ei},
		wideq = WideElements/.Flatten[{opts, Options[FormGroupoid]}];
		groupq = IsAGroup/.Flatten[{opts, Options[FormGroupoid]}];
		genset = Generators/.Flatten[{opts, Options[FormGroupoid]}];
		ei = ExtraInformation/.Flatten[{opts, Options[FormGroupoidExtra]}];
		grpdesc = GroupoidDescription/.Flatten[{opts, Options[FormGroupoid]}];
		grpnm = GroupoidName/.Flatten[{opts, Options[FormGroupoid]}];
		formop = FormatOperator/.Flatten[{opts, Options[FormGroupoid]}];
		formels = FormatElements/.Flatten[{opts, Options[FormGroupoid]}];
		keyForm = KeyForm/.Flatten[{opts, Options[FormGroupoid]}];
		cayleyForm = CayleyForm/.Flatten[{opts, Options[FormGroupoid]}];
		maxshow = MaxElementsToList/.Flatten[{opts, Options[FormGroupoid]}];
		AppendTo[ei, {opts}];
		G = groupoid[list, op, ei];
		FormatOpQ[G] = formop;
		FormatElsQ[G] = If[Length[list] > maxshow, True, formels];
		currentGroupoid = G;
		WideElementsQ[G] = wideq;
		KeyForm[G] = keyForm;
		CayleyForm[G] = cayleyForm;
		If[groupq,groupQ[G] = groupq];
		GroupoidDescription[G] = grpdesc;
		GroupoidName[G] = If[grpnm === "", "TheGroup", grpnm];
		GeneratingSet[G] = If[genset === {}, {},
			If[Union[Elements[Closure[G,genset]]]===Union[list],
			genset,{}]];
		If[untestedQ[GroupInfo[G]],
			GroupInfo[G] = {};
			If[grpnm =!= "", AppendTo[GroupInfo[G],grpnm]];
			If[grpdesc =!= "", AppendTo[GroupInfo[G],grpdesc]];
			];
		(* start tracking info about groupoid if not yet started *)
		OperatorSymbol[G] = opsymb;
		ProcessInfo[G,opts];
		G]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.3 FormGroupoidByTable
:[font = input; initialization; preserveAspect; endGroup]
*)
FormGroupoidByTable[list_List,tab_List,opsymb_String:"*",opts___?OptionQ] :=
	Module[{G,op,wideq,groupq,genset,grpdesc,grpnm,maxshow,formop,
			formels,keyForm,cayleyForm, ei},
		wideq = WideElements/.Flatten[{opts, Options[FormGroupoid]}];
		groupq = IsAGroup/.Flatten[{opts, Options[FormGroupoid]}];
		genset = Generators/.Flatten[{opts, Options[FormGroupoid]}];
		ei = ExtraInformation/.Flatten[{opts, Options[FormGroupoidExtra]}];
		grpdesc = GroupoidDescription/.Flatten[{opts, Options[FormGroupoid]}];
		grpnm = GroupoidName/.Flatten[{opts, Options[FormGroupoid]}];
	  formop = FormatOperator/.Flatten[{opts, Options[FormGroupoid]}];
		formels = FormatElements/.Flatten[{opts, Options[FormGroupoid]}];
		keyForm = KeyForm/.Flatten[{opts, Options[FormGroupoid]}];
		cayleyForm = CayleyForm/.Flatten[{opts, Options[FormGroupoid]}];
		maxshow = MaxElementsToList/.Flatten[{opts, Options[FormGroupoid]}];
		op = (tab[[#1//Position[list,#]&//First,
               #2//Position[list,#]&//First]]//
               Flatten//First)&;
    AppendTo[ei, {opts}];
		G = groupoid[list, op, ei];
		FormatOpQ[G] = formop;
		FormatElsQ[G] = If[Length[list] > maxshow, True, formels];
		currentGroupoid = G;
		WideElementsQ[G] = wideq;
		KeyForm[G] = keyForm;
		CayleyForm[G] = cayleyForm;
		GeneratingSet[G] = genset;
		If[groupq,groupQ[G] = groupq];
		GroupoidDescription[G] = grpdesc;
		GroupoidName[G] = If[grpnm === "", "TheGroup", grpnm];
		If[untestedQ[GroupInfo[G]],
			GroupInfo[G] = {};
			If[grpnm =!= "", AppendTo[GroupInfo[G],grpnm]];
			If[grpdesc =!= "", AppendTo[GroupInfo[G],grpdesc]];
			];
		(* start tracking info about groupoid if not yet started *)
		OperatorSymbol[G] = opsymb;
		ProcessInfo[G,opts];
		G]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.5 GenerateGroupoid
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[GenerateGroupoid] := 
	{CayleyForm -> OutputForm, FormatElements -> False, FormatOperator -> True, 
Generators -> {}, GroupoidDescription -> "", GroupoidName -> "TheGroup", 
IsAGroup -> False, KeyForm -> InputForm, MaxElementsToList -> 50, 
SizeLimit -> 25, WideElements -> False};

GenerateGroupoid[generators_List,op_,opsymb_String:"*",opts___?OptionQ]:=
	Module[{n,elem=generators,optable,G,done=False,max, wideq, ei,
		groupq,grpdesc,grpnm,list,maxshow,formels,formop,iter=0,keyForm,cayleyForm},
	max = SizeLimit/.Flatten[{opts, Options[GenerateGroupoid]}];
	wideq = WideElements/.Flatten[{opts, Options[GenerateGroupoid]}];
	groupq = IsAGroup/.Flatten[{opts, Options[GenerateGroupoid]}];
	ei = ExtraInformation/.Flatten[{opts, Options[FormGroupoidExtra]}];
	genset = Generators/.Flatten[{opts, Options[GenerateGroupoid]}];
	grpdesc = GroupoidDescription/.Flatten[{opts, Options[GenerateGroupoid]}];
	grpnm = GroupoidName/.Flatten[{opts, Options[GenerateGroupoid]}];
	formop = FormatOperator/.Flatten[{opts, Options[GenerateGroupoid]}];
	formels = FormatElements/.Flatten[{opts, Options[GenerateGroupoid]}];
	keyForm = KeyForm/.Flatten[{opts, Options[GenerateGroupoid]}];
	cayleyForm = CayleyForm/.Flatten[{opts, Options[GenerateGroupoid]}];
	maxshow = MaxElementsToList/.Flatten[{opts, Options[GenerateGroupoid]}];
	n = Length[elem];
	AppendTo[ei, {opts}];
	While[(Length[elem]<=max) && Not[done],
		(*optable=Apply[op,Table[{elem[[i]],elem[[j]]},
			{i,1,n},{j,1,n}],{2}];
		If[Sort[Union[elem,Flatten[optable,1]]]===Sort[elem],
			list = Sort[elem];*)
		iter++;
		optable=CloseSets[elem,elem,op];
		If[Sort[Union[elem,optable]]===Sort[elem],
			list = Sort[elem];
			G = groupoid[list, op, ei];
			FormatOpQ[G] = formop;
			FormatElsQ[G] = If[Length[list] > maxshow, True, formels];
			GeneratingSet[G] = generators;
			done=True,
		elem=Union[elem,optable]];
		n = Length[elem];
	];(*end of While *)
	If[done,
		If[untestedQ[GroupInfo[G]],
			GroupInfo[G] = {};
			If[grpnm =!= "", AppendTo[GroupInfo[G],grpnm]];
			If[grpdesc =!= "", AppendTo[GroupInfo[G],grpdesc]];
			];
		WideElementsQ[G] = wideq;
		KeyForm[G] = keyForm;
		CayleyForm[G] = cayleyForm;
		If[groupq,groupQ[G] = groupq];
		GroupoidDescription[G] = grpdesc;
		GroupoidName[G] = If[grpnm === "", "TheGroup", grpnm];
		OperatorSymbol[G] = opsymb;
		ProcessInfo[G,opts];
		G,
		(* start tracking info about groupoid if not yet started *)
		(*else*) Message[GenerateGroupoid::size,max];
			elem]];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.8 FormRingoid
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[FormRingoid] = 
{CayleyForm -> OutputForm, FormatElements -> False, FormatOperator -> True, 
 IsARing -> False, KeyForm -> InputForm, MaxElementsToList -> 50, 
 RingoidDescription -> "", RingoidName -> "TheRing", WideElements -> False};

Options[FormRingoidExtra] = {ExtraInformation -> {{},{},{},{},{}}};
(* Information that can go here: {{True/False if ring or not},
	{Zero of Ring or Null, Unity of Ring or Null}, {quick function to
	calculate negations, quick function to calculate mult. inverses}, 
	{a minimal generating set for additive group}, {any other extra
	information entered on ad hoc basis for special functions - best
	to use rules here}}*)

GatherRingoidOptions[G_?RingoidQ] := Sequence[WideElements -> WideElementsQ[G],
	RingoidDescription -> RingoidDescription[G], RingoidName -> RingoidName[G],
	FormatOperator -> FormatOpQ[G], FormatElements -> FormatElsQ[G],
	KeyForm -> KeyForm[G], CayleyForm -> CayleyForm[G]]
	
GatherSubRingoidOptions[G_?RingoidQ] := Sequence[WideElements -> WideElementsQ[G],
	RingoidDescription -> "Subringoid of "<> RingoidDescription[G], 
	RingoidName -> "sub "<>RingoidName[G],
	FormatOperator -> FormatOpQ[G], FormatElements -> FormatElsQ[G],
	KeyForm -> KeyForm[G], CayleyForm -> CayleyForm[G]]

FormRingoid[list_List, addition_, multiplication_,
		opsymbols_List:{"+","*"}, opts___?OptionQ] :=
	Module[{R,wideq,ringq,genset,rngdesc,rngnm,optional,formop,
	formels,maxshow,keyForm,cayleyForm, ei},
		wideq = WideElements/.Flatten[{opts, Options[FormRingoid]}];
		ei = ExtraInformation/.Flatten[{opts, Options[FormRingoidExtra]}];
		ringq = IsARing/.Flatten[{opts, Options[FormRingoid]}];
		rngdesc = RingoidDescription/.Flatten[{opts, Options[FormRingoid]}];
		rngnm = RingoidName/.Flatten[{opts, Options[FormRingoid]}];
		formop = FormatOperator/.Flatten[{opts, Options[FormRingoid]}];
		keyForm = KeyForm/.Flatten[{opts, Options[FormRingoid]}];
		cayleyForm = CayleyForm/.Flatten[{opts, Options[FormRingoid]}];
		formels = FormatElements/.Flatten[{opts, Options[FormRingoid]}];
		maxshow = MaxElementsToList/.Flatten[{opts, Options[FormRingoid]}];
		AppendTo[ei, {opts}];
		R = ringoid[list, addition, multiplication, ei];
		FormatOpQ[R] = formop;
		FormatElsQ[R] = If[Length[list] > maxshow, True, formels];
		WideElementsQ[R] = wideq;
		KeyForm[R] = keyForm;
		CayleyForm[R] = cayleyForm;
		If[ringq,ringQ[R] = ringq];
		RingoidDescription[R] = rngdesc;
		RingoidName[R] = If[rngnm === "", "TheRing", rngnm];
		If[untestedQ[RingInfo[R]],
			RingInfo[R] = {};
			If[rngnm =!= "", AppendTo[RingInfo[R],rngnm]];
			If[rngdesc =!= "", AppendTo[RingInfo[R],rngdesc]];
			];
		(* start tracking info about groupoid if not yet started *)
		PlusSymbol[R] = opsymbols[[1]];
		TimesSymbol[R] = opsymbols[[2]];
		ProcessRingInfo[R,opts];
		R]
(* note that the R created is a ringoid not Ringoid *)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.10 ReorderGroupoid
:[font = input; initialization; preserveAspect; endGroup]
*)
ReorderGroupoid[G_?GroupoidQ, neworder_List] :=
	If[SameSetQ[neworder, Elements[G]],
		FormGroupoid[neworder, Operation[G], OperatorSymbol[G], 
			GatherGroupoidOptions[G]],
		Message[Groupoid::reorderfail, theGroupName[G], neworder]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.12 SortGroupoid
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
SortGroupoid[G_?GroupoidQ] := ReorderGroupoid[G, Sort[Elements[G]]]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 17. Families of Groupoids
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.2 - Z - integers mod n under addition
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[Z]={Mode -> Computational, Structure :> DefaultStructure};

Z[n_Integer?Positive] := If[(Structure/. Options[Z]) === Group,
	ZG[n], ZR[n]];
	
Z[Sqrt[n_Integer?Positive]] := ZSq[n]

Z[Power[n_Integer?Positive, Rational[1,2]]] := ZSq[n]

Z[n_Integer?Positive, Structure -> Group] := ZG[n]

Z[n_Integer?Positive, Structure -> Ring] := ZR[n]

Z[n_Integer?Positive, k_Integer?Positive] := If[(Structure/. Options[Z]) === Group,
	ZG[n,k], ZR[n,k]];
	
Z[n_Integer?Positive,  opts__?OptionQ] := 
	If[(Structure/.Flatten[{opts, Options[Z]}]) === Group,
		ZG[n, opts], ZR[n, opts]];

Z[n_Integer?Positive, k_Integer?Positive, Structure -> Group,
	opts___?OptionQ] := ZG[n, k, opts]
	
Z[n_Integer?Positive, k_Integer?Positive, Structure -> Ring,
	opts___?OptionQ] := ZR[n, k, opts]

Z[n_Integer?Positive, k_Integer?Positive, opts__?OptionQ] := 
	If[(Structure/.Flatten[{opts, Options[Z]}]) === Group,
		ZG[n, k, opts], ZR[n, k, opts]];

Z[n_Integer?Positive, Structure -> Group, opts__?OptionQ] :=
	ZG[n, opts]
	
Z[n_Integer?Positive, Structure -> Ring, opts__?OptionQ] :=
	ZR[n, opts]
	
ZG[n_Integer?Positive] := ZG[n] =
		FormGroupoid[Range[0,n-1], Mod[#1 + #2,n]&,"+",
			IsAGroup -> True, FormatOperator->False, Generators -> {1},
			GroupoidDescription -> "Integers mod n under addition",
			GroupoidName ->StringJoin["Z[",ToString[n],"]"]]

ZG[n_Integer?Positive, opts___?OptionQ] := 
		Module[{mymode,G,sc,st},
	mymode = Mode/.Flatten[{opts, Options[Z]}];
	sc = FilterOptions[ShowModes,opts];
	G = ZG[n];
	ShowModes["AbstractAlgebra`Core",ZG,mymode,G, {n},{n,opts},{Null},{Null},sc]]
	
ZG[n_Integer?Positive, k_Integer?Positive, opts___?OptionQ] :=
		Module[{mymode,G,st,sc},
	mymode = Mode/.Flatten[{opts, Options[Z]}];
	sc = FilterOptions[ShowModes,opts];
	If[Mod[n, k]==0,
		G = FormGroupoid[Range[0,n-1,k], Mod[#1 + #2,n]&,"+",
			IsAGroup -> True,
			FormatOperator->False,
			Generators -> {k},
			GroupoidDescription -> "subgoup of integers mod n under addition",
			GroupoidName ->StringJoin["Z[",ToString[n],",",ToString[k],"]"]];
		ShowModes["AbstractAlgebra`Core",ZG,mymode,G,{n}, 
		{n,k,opts},{Null},{Null},sc],
	Message[Groupoid::modd,k,n]; $Failed]]

Z[many:{_Integer?Positive..}] := Map[Z, many]
	
Z[many:{_Integer?Positive..}, Mode -> mode_] :=
	handleSimpleMultiple[ZG, many, mode]
		
Z[many:{_Integer?Positive..}] :=
	Z[many, Mode -> (Mode/.Options[Z])]

Z[n_Integer, opts___?OptionQ] := (Message[Z::intpm,"Z["<>ToString[n]<>"]",1];$Failed)

Options[ZGVisual]={DisplayFunction -> $DisplayFunction};
			
ZGVisual[n_,k_, opts___?OptionQ] := Module[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[ZGVisual]}], rng = Range[0,n-1], blue},
	(*If[showVisTextQ[ZG], ZGVisualText[n]];*)
	Show[{modCircle[n,k],
		LabelingNgon[rng, blue=Range[0,n-1,k], insideLabelFactor, InputForm](*,
		LabelingNgon[rng, Complement[rng,blue], insideLabelFactor, InputForm]*)},showopts,DisplayFunction -> df]]

ZGVisual[n_,opts___?OptionQ] := Module[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[ZGVisual]}]},
	If[showVisTextQ[ZG], ZGVisualText[n]];
	Show[ZGVisualWork[n],showopts,DisplayFunction -> df]]


ZGVisualWork[n_] := 
	MakeCircle[n, Range[0,n-1]]

ZGVisualText[n_] := 
Print[StringJoin["Think of the elements as the numbers on a (modified) clock,
where we view the last element, ", ToString[n],", as being
equivalent to zero. Addition of two numbers is just like adding
hours on the clock."]]

ZGTextual[n_] := (
Print[StringJoin["This groupoid consists of the elements ",
ToString[Range[0,n-1]],
" with the operation of addition mod ",ToString[n],". The sum of two
elements x and y is given by (x + y) (mod ",ToString[n],"), which means
the remainder of (x + y) upon division by ",ToString[n],
". For example,
(7 + 8) (mod 12) = 3 (mod 12) in the same way that 8 hours after 7:00
is 3:00.\n"]];
	)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.2.5 - Z as a ring
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[ZR] = {};

ZR[n_Integer?Positive, opts___?OptionQ] := ZR[n] = Module[{R=FormRingoid[Range[0,n-1],
  	Mod[#1 + #2,n]&, Mod[#1 #2,n]&, {"+","*"}, RingoidName -> 
  	"Z["<>ToString[n]<>"]", RingoidDescription ->
  	"the ring of integers mod "<>ToString[n], FormatOperator -> False]},
  NegationOf[R, k_] := Mod[n-k,n];
  MultiplicativeInverse[R, k_] := ExtendedGCD[n,k]//If[First[#]==1,Mod[#[[2,2]],n],
    Message[Inverse::fail,k,StructureName[R]];$Failed]&;
  R]; 

ZR[n_Integer?Positive, k_Integer?Positive]/;(Mod[n, k]==0) := ZR[n, k]=
  FormRingoid[Range[0, n-k, k], Mod[#1+#2,n]&, Mod[#1 #2,n]&,
  {"+","*"}, RingoidName-> "Z["<>ToString[n]<>","<>ToString[k]<>"]", 
  RingoidDescription -> "the multiples of "<>ToString[k]<>" mod "<>
  ToString[n], FormatOperator -> False];
  
ZR[n_] := (Message[ZR::intpm,"ZR["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.19 - GaussianIntegers
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
gaussianintegersmodn[n_] := Module[{els = Elements[Z[n]]},
	CartesianProduct[els,els]/.{a_,b_} -> a + b*I]
	
GaussianAddition[x_, y_,n_Integer?Positive] :=
	Complex[Mod[Re[x]+Re[y],n],Mod[Im[x]+Im[y],n]]

GaussianMultiplication[x_, y_,n_Integer?Positive] :=
	Complex[Mod[Re[x] Re[y] - Im[x] Im[y],n],
		Mod[Re[x] Im[y]+Re[y] Im[x],n]]
		
GaussianIntegersAdditive[n_Integer?Positive] := 
	FormGroupoid[gaussianintegersmodn[n],
		GaussianAddition[#1,#2,n]&(*Mod[#1+#2,n]&*),"+",
		FormatOperator -> True, WideElements -> If[n>2, True, False],
		GroupoidName -> "Z["<>ToString[n]<>", I]"]
		
GaussianIntegersMultiplicative[n_Integer?Positive] := 
	FormGroupoid[gaussianintegersmodn[n],
		GaussianMultiplication[#1,#2,n]&(*Mod[#1 #2,n]&*),"*",
		FormatOperator -> True, WideElements -> If[n>2, True, False],
		GroupoidName -> "Zx["<>ToString[n]<>", I]"]		
		
Z[n_Integer?Positive, I] := If[DefaultStructure === Group,
	GaussianIntegersAdditive[n], GaussianIntegers[n]]

Z[n_Integer?Positive, I, Structure -> Group] := 
	GaussianIntegersAdditive[n]
	
Unprotect[GaussianIntegers];

GaussianIntegers[n_Integer?Positive] :=
	FormRingoid[gaussianintegersmodn[n],
	GaussianAddition[#1,#2,n]&, 
	GaussianMultiplication[#1,#2,n]&,(*Mod[#1+#2,n]&, Mod[#1 #2,n]&,*)
	WideElements -> If[n>2, True, False],
	RingoidName -> 
	"Z["<>ToString[n]<>", I]", FormatOperator -> True,
	WideElements -> If[n > 2, True, False]]
	
Protect[GaussianIntegers];

Z[n_Integer?Positive, I, Structure -> Ring] := 
	GaussianIntegers[n]
	
Z[n_, opts___] := If[NumberQ[n] && n =!= I,
	Message[Z::intpm,"Z["<>ToString[n]<>"]",1];$Failed]
		
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 21. Working with elements
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
21.1 Random element(s)
:[font = input; initialization; preserveAspect; endGroup]
*)
randElement[Dom_List]:=
       Dom[[Random[Integer,{1,Length[Dom]}]]]
       
RandomElement[Dom_List] := randElement[Dom]

RandomElements[Dom_List,n_Integer?Positive] := Table[randElement[Dom],{n}]

RandomElements[Dom_List,0] := {}
       
Options[RandomElement]={SelectFrom -> NonIdentity};

RandomElement[G_?GroupoidQ, opts___?OptionQ]:= 
	Module[{P,sel,els=Elements[G]},
	sel=SelectFrom/.Flatten[{opts, Options[RandomElement]}];
    If[sel===NonIdentity,
    	If[(P=Complement[els,{If[HasIdentityQ[G],
    			GroupIdentity[G],{}]}])!={},
            randElement[P],Message[RandomElement::gfail,sel];
            $Failed],randElement[els]]]
     
Options[RandomElements]={SelectFrom -> Any,
	Replacement -> True};
	
RandomElements[G_?GroupoidQ,0,opts___?OptionQ]:= {}

RandomElements[G_?GroupoidQ,n_Integer?Positive,opts___?OptionQ]:= 
	Module[{sel, rep, els=Elements[G], list={}, possible, id, p,s},
	sel=SelectFrom/.Flatten[{opts, Options[RandomElements]}];
	rep=Replacement/.Flatten[{opts, Options[RandomElements]}];
	s = Length[els];
	possible = (n <= s && sel =!= NonIdentity) || rep || 
		(n < s && sel === NonIdentity);
	If[possible,
    	If[rep,
    		(* just find some random elements, replacement ok *)
    		list = Table[RandomElement[G,SelectFrom->sel],{n}],
    		(* replacement not ok *)
    		p = RandomPermutation[s];
    		p = Map[els[[#]]&,p];
				If[n <= s && sel =!= NonIdentity,list = Take[p, n]];
				If[n < s && sel === NonIdentity,
					p = Take[p, n+1];
					id = If[HasIdentityQ[G],
    				GroupIdentity[G],{}];
    			p = DeleteCases[p,id];
    			If[Length[p] == n, list = p, list = Drop[p,1]]
					]
    		]
    	];
    If[!rep,
  		If[n > s, Message[RandomElements::toomany,n,s]];
   		If[n == s && sel === NonIdentity,
   				Message[RandomElements::toomanyni,n,s]]];
    list
    ]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
21.2 ElementQ
:[font = input; initialization; preserveAspect; endGroup]
*)
ElementQ[g_, G_?StructuredSetQ] := MemberQ[Elements[G],g]

ElementsQ[l_, G_?StructuredSetQ] := Apply[And,Map[ElementQ[#, G]&,l]]

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
21.3 element to a power (multiple)
:[font = input; initialization; preserveAspect; endGroup]
*)
ElementToPower[G_?GroupoidQ, g_, n_Integer?Positive] := ElementToPower[G, g, n] =
	If[ElementQ[g,G],
		Fold[Operation[G], g, Evaluate[Table[g,{n-1}]]],
		Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

ElementToPower[G_?GroupoidQ, g_, 0] := ElementToPower[G, g, 0] =
	If[ElementQ[g,G],
		GroupIdentity[G],
		Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

ElementToPower[G_?GroupoidQ, g_, n_Integer?Negative] := ElementToPower[G, g, n] =
	If[ElementQ[g,G],
		Module[{ginv},
			If[InvertibleQ[G, g],
				ginv = GroupInverse[G,g];
				Fold[Operation[G], ginv, Evaluate[Table[ginv,{Abs[n]-1}]]],
				Message[Inverse::fail,g,StructureName[G]]; $Failed]],
		Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

ElementToPower[G_?GroupoidQ, g_, n_Integer, Mode -> Textual] :=
(If[ElementQ[g,G],
Print["To find nth power of an element, when n is positive,
we simply use the group operation on n copies of the element g.
When n is negative, we perform the group operation on n copies
of the element's inverse. When n is 0, we obtain the identity."];
If[n == 0,
	Print["\nIn this case, we simply have the identity."],
	Print["\nIn this case, the following table illustrates the
accumulation of powers.\n"];
Print[TableForm[Table[{i, InputForm[ElementToPower[G, g, i]]}, 
	{i, If[n > 0, 1, -1], n, If[n > 0, 1, -1]}],
	TableHeadings -> {None,{"n", "g^n\n"}}, TableSpacing -> 
	{If[$VersionNumber > 2.5, 0.5, 0], 3}]]];
ElementToPower[G, g, n],
Message[MemberQ::elmnt, g, StructureName[G]]; $Failed])
	
Options[ElementToPower]={DisplayFunction -> $DisplayFunction};

ElementToPower[G_?GroupoidQ, g_, n_Integer?Negative, Mode -> Visual, opts___] :=
ElementToPower[G, GroupInverse[G,g], n, Mode -> Visual, opts] 

ElementToPower[G_?GroupoidQ, g_, n_Integer?Positive, Mode -> Visual, opts___] := 
	If[ElementQ[g,G],
Module[{list,
		temp = Length[Elements[G]],gr1,gr2,
		f,h,m,seccords, rules,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[SubgroupQVisual]}]},
	list =FoldList[Operation[G], g, Evaluate[Table[g,{n-1}]]];
	list = Transpose[{Range[n],list}];
	f[h_,{m_}] := h -> m;
	rules = MapIndexed[f, Elements[G]];
	seccords = list//Transpose//Last;
	seccords = seccords/.rules;
	If[WideElementsQ[G],printOtherKey[Elements[G]]];
	list = Transpose[{list//Transpose//First,seccords}];
	gr1 = ListPlot[list,PlotJoined -> True, 
		DisplayFunction -> Identity];
	gr2 = ListPlot[list,PlotStyle -> {RGBColor[0,0,1],
		PointSize[0.03]}, DisplayFunction -> Identity];
	Show[{gr2,gr1}, showopts, DisplayFunction -> df,
		AxesLabel -> {"power","element"}, Ticks -> 
		If[WideElementsQ[G],
		{Table[i,{i,n}],Table[i,{i,temp}]},{Table[i,{i,n}],
		Table[{i,ToString[Elements[G][[i]]]},{i,1,temp}]}],
		PlotRange -> {{0,n},{0,temp}}, AxesOrigin -> {0,0}]
],
Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
21.4 random stuff
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
squareFreeQ[n_]:= MoebiusMu[n] != 0 (* from Examples`OneLiners *)

rightkindQ[n_] := IntegerQ[n] && Positive[n] && squareFreeQ[n]

ZSq[n_] := re[n]

RandomElement[re[n_], max_:100] :=
If[squareFreeQ[n],
	Random[Integer,{-max,max}] + 
		Random[Integer,{-max,max}] Sqrt[n], $Failed]

RandomElement[Z[Power[n_, Rational[1,2]]],max_:100] := 
	RandomElement[Z[Sqrt[n]], max]

RandomElement[Z[Sqrt[n_Integer?Positive]],max_:100] := 
	If[squareFreeQ[n],
	Random[Integer,{-max,max}] + 
		Random[Integer,{-max,max}] Sqrt[n], $Failed]
	
RandomElement[Z[Sqrt[-1]],max_:100] := 
	Random[Integer,{-max,max}] + 
		Random[Integer,{-max,max}] I
	
RandomElement[Z[I],max_:100] := 
	Random[Integer,{-max,max}] + 
		Random[Integer,{-max,max}] I

RandomElements[Z[Sqrt[(n_Integer?Positive)?squareFreeQ]],max_:100, 
	num_Integer?Positive] := 
	Table[RandomElement[Z[Sqrt[n]],max], {num}]

RandomElement[Z[Sqrt[-1]], max_:100, num_Integer?Positive] := 
	Table[RandomElement[Z[-1], max], {num}]

RandomElements[Z[I], max_:100, num_Integer?Positive] :=
	Table[RandomElement[Z[I], max], {num}]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 22. Cayley Table
:[font = input; initialization; preserveAspect; endGroup]
*)
widthNeeded[Els_List] := 
	(.33333 + Length[Els]*.60385)/25 * 
	Max[Map[Length[Characters[ToString[InputForm[#]]]]&,Els]];
	
deleteSpacesInStrings[s_String] := 
	s//Characters//DeleteCases[#," "]&//StringJoin
	
basicCayley[G_,els_,opts___] := 
	Module[{len, g,gs,widetab,lowLeftPts,i,j, dummy,missing,
		rects, textGraphics, toptext,tableText,oldLL={},
		linesGraphics, widetrans={}, altEls, StrEls,altRls,
		lines = {}, showOp,showName,showBodyText,showKey,varToUse,
		opsym,siderects, toprects, pts,sidetext, tn,
		RuleList,gn,showSidesText,Els=els,cform,
		extracols, wideQ=False,partpos,tab,cayleyForm,keyForm},
	(* first test to make sure Els and Elements[G] are the
	same set, not counting order *)
If[Not[untestedQ[WideElementsQ[G]]],wideQ=WideElementsQ[G],
		If[widthNeeded[Els]>.95,wideQ=True]];
	(* do we know the elements are wide? If not, go find out. *)
varToUse = VarToUse/.Flatten[{opts, Options[CayleyTable]}];
If[(*untestedQ[basiccayley[G,Els,opts]]*) 2 > 1 (* force through for now *),
	showOp = ShowOperator/.Flatten[{opts, Options[CayleyTable]}]; (* show operation symbol? *)
	showName = ShowName/.Flatten[{opts, Options[CayleyTable]}];
	showBodyText = ShowBodyText/.Flatten[{opts, Options[CayleyTable]}];
	showSidesText = ShowSidesText/.Flatten[{opts, Options[CayleyTable]}];
	showKey = ShowKey/.Flatten[{opts, Options[CayleyTable]}];
	tn = TableName/.Flatten[{opts, Options[CayleyTablePrivate]}];
	cform = CayleyForm/.Flatten[{opts, CayleyForm -> CayleyForm[G],Options[CayleyTable]}];
	cayleyForm = If[cform === CayleyForm, CayleyForm[G], cform];
	len = Length[Els];
	gn = If[tn === Default, StructureName[G], tn];
	(* do we know the name of this groupoid? *)
	opsym = If[showOp,If[untestedQ[OperatorSymbol[G]],"*", OperatorSymbol[G]],""];
	(* what is the symbol to denote the operation? *)
	If[wideQ, (* if wide, we have some work to do *)
		gs[i_] := StringJoin[ToString[varToUse],ToString[i]]; (* define substitute symbols *)
		altEls = Table[gs[k],{k,len}];
		RuleList = MapThread[Rule,{Map[dummy,Els,1],altEls}]];
		(* rules for converting the other way - used as Rules below *)
	lowLeftPts=Flatten[Table[{i,j},{j,len-1,0,-1},{i,0,len-1}],1];
	(* get lower-left pts of rectangles for tables *)
	rects = Partition[Map[Rectangle[#,#+1]&,lowLeftPts],len];
	(* matrix of rectangles *)
	pts = Table[{-1,j},{j,0,len}]; (* to make rectangles & text *)
	siderects = Map[Rectangle[#,#+1]&,pts];(* for first operands *)
	sidetext = Map[Text[#[[2]],#[[1]]+.5,{0,0}]&,
		Transpose[{Drop[pts,-1]//Reverse, If[wideQ,Map[cayleyForm,altEls],
		Map[cayleyForm,Els]]}]];
	pts = Table[{j,len},{j,0,len-1}];
	toprects = Map[Rectangle[#,#+1]&,pts];
	toptext = Map[Text[#[[2]],#[[1]]+.5,{0,0}]&,
		Transpose[{pts,If[wideQ,Map[cayleyForm,altEls],Map[cayleyForm,Els]]}]];
	tab = makeTable[G,Els]; (* returns matrix of table *)
	If[wideQ, tab = Map[dummy, tab, {2}];
		tab = tab/.RuleList];
	missing = If[Position[tab, dummy[_]] =!= {},True, False];
	If[$VersionNumber < 2.5, Print[" "]];
	If[missing, tab = tab /. dummy[_] -> "MIA";
		Print["MIA indicates that an element is not in the domain, so it can not
be keyed; see output for actual values."]];
	tableText = Map[Text[#[[2]],#[[1]]+.5,{0,0}]&,
		Transpose[{lowLeftPts,Map[cayleyForm,Flatten[tab,1]]}]];
	textGraphics = Show[Graphics[{If[showBodyText,tableText], 
		If[showSidesText,sidetext],If[showSidesText,toptext],
		{If[showName,Text[gn, {-1,len+1.5},
			{-1,0}]]},
		If[showOp,Text[StandardForm["x "<>opsym<>" y"], {len,len+1.5},
			{1,0}]],
		Text["x",{-.66,len+.33},{0,0}],
		Text["y",{-.25,len+.7},{0,0}]}//DeleteCases[#,Null]&//
			DeleteCases[#,{Null}]&],
		DisplayFunction -> Identity];
	lines = Union[Table[Line[{{i,0},{i,len + 1}}],{i,-1,len}],
		Table[Line[{{-1,i},{len,i}}],{i,0,len+1}]]//Flatten;
	linesGraphics = Show[Graphics[{
		{AbsoluteThickness[1],lines, Line[{{-1,len+1},{0,len}}]},
		{AbsoluteThickness[2.6],Line[{{0,0},{0,len+1}}],
			Line[{{-1,len},{len,len}}]}}],
		DisplayFunction -> Identity];
	basiccayley[G,Els,opts]={linesGraphics,textGraphics,rects}];
	(*If[wideQ,PrintCayleyKey[Els,varToUse]];*)
	basiccayley[G,Els,opts]
	]

Options[CayleyTablePrivate] = {TableName -> Default};

Options[CayleyTable] = 
{CayleyForm -> OutputForm, HeadingsColored -> True, KeyForm -> InputForm, 
Mode -> Computational, ShowBodyText -> True, ShowKey -> True, ShowName -> True, 
ShowOperator -> True, ShowSidesText -> True,
TheSet -> {}, VarToUse -> "g"};

CayleyTable[G_?GroupoidQ, opts___?OptionQ] :=  
	Module[{Els = Elements[G], table, mymode,sc,ElementsToUse},
	mymode = Mode/.Flatten[{opts, Options[CayleyTable]}];
	sc = FilterOptions[ShowModes,opts];
	ElementsToUse = TheSet/.Flatten[{opts, Options[CayleyTable]}];
	If[ElementsToUse =!= {} && Not[SameSetQ[Els,ElementsToUse]], 
		Message[TheSet::error, ElementsToUse]];
	If[ElementsToUse === {} || Not[SameSetQ[Els,ElementsToUse]], ElementsToUse = Els];
	If[untestedQ[cayleyTable[G,ElementsToUse, opts]],
		cayleyTable[G,ElementsToUse, opts] = makeTable[G,ElementsToUse]];
	table = cayleyTable[G,ElementsToUse, opts];
	ShowModes["AbstractAlgebra`Core",CayleyTable,mymode,table,{G,ElementsToUse},
		{G,ElementsToUse,opts},{Null},{Null},sc]
	]
	
CayleyTable[many:{_?GroupoidQ..}] :=
	CayleyTable[many, Mode -> (Mode/.Options[CayleyTable])]
(* if no Mode is specified, go determine default and specify it 
so that the next function can properly be called. *)
	
CayleyTable[many:{_?GroupoidQ..}, Mode -> mode_] := 
		handleSimpleMultiple[CayleyTable,many,mode]
(* if the only option specified is Mode, take this path *)
		
CayleyTable[many:{_?GroupoidQ..}, {opts__?OptionQ}] := 
		CayleyTable[many, {opts}, 
			Mode -> (Mode/.Options[CayleyTable])]
(* if there are options to be applied to each groupoid, and no 
	mode is specified, take this path *)

CayleyTable[many:{_?GroupoidQ..},opts:{_?VectorQ..}] := 
	CayleyTable[many, opts, 
			Mode -> (Mode/.Options[CayleyTable])]
(* if we have a list of groupoids and a list of options, but
no mode specified, take this path *)

CayleyTable[many:{_?GroupoidQ..},opts:{_?VectorQ..},Mode -> mode_] := 
	handlePairedMultiple[CayleyTable,many,opts, mode]
(* if we have a list of groupoids and a list of options, and
the mode is specified, take this path *)

CayleyTable[many:{_?GroupoidQ..}, {opts__?OptionQ}, Mode -> mode_] := 
		handleSimpleMultiple[CayleyTable,many,mode,{opts}]
(* if there are options to be applied to each groupoid, 
	take this path *)
	
CayleyTable[many:{_?GroupoidQ..}, opts__?OptionQ, Mode -> mode_] := 
		handleSimpleMultiple[CayleyTable,many,mode,{opts}]
(* if there are options to be applied to each groupoid, 
	take this path *)


GetMode[lists_List] := Module[{opts, modes},
	opts = Map[Select[#, OptionQ]&, lists];
	modes = Map[Mode/.#&, opts];
	If[MemberQ[modes, Visual], Visual, 
		If[MemberQ[modes, Textual], Textual, Computational]]]
		
CayleyTable[many_List] := 
	CayleyTable[many, 
			Mode -> GetMode[many]]
(* if we have a list of lists of groupoids with options, but
no mode specified, take this path *)

CayleyTable[many_List,Mode -> mode_] := 
	handlePairedMultiple[CayleyTable,Map[First,many],
	Map[Rest,DeleteCases[many, Mode -> _, 2]], mode]
(* if we have a list of lists of groupoids with options, and
the mode is specified, take this path *)

CayleyTable[G_,anything___] := Message[Groupoid::fail,StructureName[G]]

FindSingleton[els_,g_] :=
	Select[Position[els, g],Length[#]==1&]//Flatten
	
ColorTableSquares[G_, els_, pairs_, colors_List] := 
		Module[{poslist,rows,cols,rects,selrects},
	rows = Map[FindSingleton[els,#]&,Transpose[pairs]//First]//Flatten;
	cols = Map[FindSingleton[els,#]&,Transpose[pairs]//Last]//Flatten;
	poslist = Transpose[{rows,cols}];
	rects = basicCayley[G,els][[3]];
	selrects = Map[Part[rects,Apply[Sequence,#]]&,poslist];
	Transpose[{colors,selrects}]]

ColorTableSquares[G_, els_, pairs_, color_RGBColor] := 
	ColorTableSquares[G, els, pairs, Table[color,{Length[pairs]}]]

ColorRowSquares[G_, els_, g_, vals_, colors_List] := 
	ColorTableSquares[G, els, Map[{g,#}&,vals],colors]

ColorRowSquares[G_, els_, g_, vals_, color_RGBColor] :=
	ColorRowSquares[G,els,g,vals,Table[color,{Length[vals]}]]
		
ColorColumnSquares[G_, els_, g_, vals_, colors_List] := 
	ColorTableSquares[G, els, Map[{#,g}&,vals],colors]

ColorColumnSquares[G_, els_, g_, vals_, color_RGBColor] :=
	ColorColumnSquares[G,els,g,vals,Table[color,{Length[vals]}]]
		
ColorTopSquares[G_, els_, vals_, colors_List] := Module[{n = Length[els],pos,rects,x},
	pos = Map[FindSingleton[els,#]&,vals]//Flatten;
	rects = Table[Rectangle[x={pos[[i]]-1,n},x+1],{i, Length[pos]}];
	Transpose[{colors,rects}]]

ColorTopSquares[G_, els_, vals_, color_RGBColor] :=
	ColorTopSquares[G,els,vals,Table[color,{Length[vals]}]]
		
ColorSideSquares[G_, els_, vals_, colors_List] := Module[{n = Length[els],pos,rects,x},
	pos = Map[FindSingleton[els,#]&,vals]//Flatten;
	rects = Table[Rectangle[x={-1,n-pos[[i]]},x+1],{i, Length[pos]}];
	Transpose[{colors,rects}]]

ColorSideSquares[G_, els_, vals_, color_RGBColor] :=
	ColorSideSquares[G,els,vals,Table[color,{Length[vals]}]]
				
CayleyTableVisualWork[G_,ElementsToUse_, opts___] := 
	Module[{len, rects, table, Els = ElementsToUse,
		coloredRects, gColoredRects, gText, headings,
		gLines,headingsColored,},
	headingsColored = HeadingsColored/.Flatten[{opts, Options[CayleyTable]}];
	If[showVisTextQ[CayleyTable],
		Print[StringJoin["For each element, a different color is used.
The entries in the table corresponding to the
elements are then colored and labeled accordingly."]]];
	table = makeTable[G,Els];
	len = Length[Els];
	{gLines, gText, rects} = basicCayley[G,Els,opts]; (* get basic info *)
	coloredRects = Table[{Part[BackgroundColors,i],
		Map[rects[[#[[1]],#[[2]]]]&, Select[Position[table,
		Part[Els,i]],(Length[#]==2)&]]},{i, len}];
(* color the rectangles containing the same element with
the same color *)
	If[headingsColored,
		headings = Join[ColorTopSquares[G,Els,Els,Take[BackgroundColors,len]],
			ColorSideSquares[G,Els,Els, Take[BackgroundColors,len]]],
		headings={White,Point[{-.01,-0.01}]}];
	gColoredRects = Show[Graphics[{coloredRects, headings},
		DisplayFunction -> Identity]];
	{gColoredRects,gLines, gText}
	]

Options[CayleyTableVisual]={DisplayFunction -> $DisplayFunction};

CayleyTableVisual[G_,ElementsToUse_, opts___] :=
	Module[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[CayleyTableVisual]}],
		showKey = ShowKey/.Flatten[{opts, Options[CayleyTable]}],
		vartouse = VarToUse/.Flatten[{opts, Options[CayleyTable]}],
		keyForm = KeyForm/.Flatten[{opts}], kform},
	kform = If[keyForm === KeyForm, KeyForm[G], keyForm];
	If[WideElementsQ[G] && showKey,
		PrintCayleyKey[ElementsToUse,StructureName[G],G, kform, vartouse]];
	Show[CayleyTableVisualWork[G,ElementsToUse,opts],showopts,
		DisplayFunction -> df]]

CayleyTableTextual[G_,ElementsToUse_] := Module[{tab},
	tab = makeTable[G,ElementsToUse];
	Print[StringJoin["The Cayley table for a Groupoid is formed
by taking all the elements of the set (in this case, ",
ToString[InputForm[ElementsToUse]],") and forming a 'multiplication'
table. The entry of the table in position
(i,j) is obtained by using the group operation on the ith
element in the left column and the jth element in the top
row.\n"]];
]

TextCayley[G_?GroupoidQ]:=Module[{table=CayleyTable[G],
		Els = Elements[G],len},
	len = Length[Els];
    table//
       Prepend[#,Table["-",{len}]]&//
       Prepend[#,Els]&//Transpose//
       Prepend[#,Table["|",{2+len}]]&//
       Prepend[#,Join[{" ","-"},Els]]&//
       Transpose//TableForm[#,TableSpacing->{1,1,0,1,0,1}]&
     ]

makeTable[G_,Els_List] := Module[{fake},
	If[SubsetQ[Els, Elements[G]],
		Partition[Distribute[fake[Els,Els],List],
			Length[Els]]/. fake ->(Operation[G])]]
(* calculate table based on the set Els *)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 23. Tests for Group properties
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
23.1 closure
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[ClosedQ]={Mode -> Computational, Structure -> Group};

ClosedQ[G_?GroupoidQ] := ClosedQ[G] = 
		Module[{Els = Elements[G], op = Operation[G],contained = True, i},
	For[i = 1, i <= Length[Els], i++,
		contained = SubsetQ[Map[(op[Els[[i]],#])&,Els],Els];
		If[Not[contained],Break[]]];
	AddGroupInfo[G, contained, "the set is closed under the operation", 
		"the set is not closed under the operation"];
	contained]
		
ClosedQ[G_?GroupoidQ, opts___?OptionQ] :=
	Module[{mymode, struct, sc},
	mymode = Mode/.Flatten[{opts, Options[ClosedQ]}];
	sc = FilterOptions[ShowModes,opts];
	struct = Structure/.Flatten[{opts, Options[ClosedQ]}];
	ShowModes["AbstractAlgebra`Core",ClosedQ,mymode,ClosedQ[G], 
		{G,struct,OperatorSymbol[G]}, 
		{G,ClosedQ[G],opts},{Null},{Null},sc]]
		
ClosedQTextual[G_, st_,symb_] := 
	If[Not[multipleQ], ClosedQTextualGD[G]; ClosedQTextualLI[G,st,symb],
		If[firstPassQ, 
			ClosedQTextualGD[G]; ClosedQTextualLI[G,st,symb];firstPassQ = False,
			ClosedQTextualLI[G,st,symb]]]

ClosedQTextualGD[_] :=
	Print["We say a set S is closed under an
	operation op if whenever we have x and y in S, we also
	have op[x,y] (or x~op~y) in S."];	
	
ClosedQTextualLI[G_, strct_,symb_] := Module[{tab,pos,a,b,prod},
	If[Not[ClosedQ[G]],tab = makeTable[G,Elements[G]];
		pos = First[Position[tab,First[Complement[
			Union[Flatten[tab,1]],Elements[G]]]]];
		prod = tab[[Apply[Sequence,pos]]];
		a = Elements[G][[pos[[1]]]];
		b = Elements[G][[pos[[2]]]]];
	If[$VersionNumber < 2.5, Print[" "]];
	Print[StringJoin["In this case, the ",
	If[strct===Group,"Groupoid ","Ringoid "],
	theGroupName[G]," is ",
	ToString[If[ClosedQ[G],"indeed closed.",
	"NOT closed."]],If[Not[ClosedQ[G]],
	StringJoin[" For example, since ",
	ToString[a]," ",symb," ",ToString[b]," = ",
	ToString[prod]," (which is not in the set), it is clear that it is not closed."],""]]]];

Options[ClosedQVisual]={DisplayFunction -> $DisplayFunction};

ClosedQVisual[G_,closed_,opts___] := 
	Module[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[ClosedQVisual]}]},
	SubgroupQVisual4[G, Elements[G], showopts, DisplayFunction -> df]]

ClosedQ[many:{_?GroupoidQ..}] := Map[ClosedQ, many]
		
ClosedQ[many:{_?GroupoidQ..}, Mode -> mode_,opts___?OptionQ] :=
	handleSimpleMultiple[ClosedQ, many, mode,{opts}]
			
ClosedQ[G_?GroupoidQ,H_List, Mode -> Visual,opts___?OptionQ]:=
	If[ElementsQ[H,G], 
		(* Closure[G, H, Mode -> Visual, Staged-> True,
			Output -> Graphics,opts];*)
		SubgroupQVisual4[G, H, opts, DisplayFunction -> $DisplayFunction];
		ClosedQ[FormGroupoid[H, Operation[G],OperatorSymbol[G]]],
		Message[MemberQ::elmnts, H, StructureName[G]]; False]
	
ClosedQ[G_?GroupoidQ,H_List,opts___?OptionQ]/;ElementsQ[H,G]:=
	ClosedQ[FormGroupoid[H, Operation[G],OperatorSymbol[G]],opts]
	
ClosedQ[G_?GroupoidQ,H_List,opts___?OptionQ]/;Not[ElementsQ[H,G]]:=
	(Message[MemberQ::elmnts,H,StructureName[G]]; $Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
23.2 identity
:[font = input; initialization; preserveAspect; endGroup]
*)
HasLeftIdentityQ[G_?GroupoidQ] := HasLeftIdentityQ[G] =
		Module[{ok,id},
	{ok,id} = LeftIdentityWork[G];
	ok
	]

HasLeftIdentityQ[G_?GroupoidQ, Mode -> Visual, opts___?OptionQ] := 
	(IdentityQVisualWork[G,LeftIdentity[G],leftid,opts]; HasLeftIdentityQ[G])

LeftIdentity[G_?GroupoidQ] := LeftIdentity[G] =
		Module[{ok,id},
	{ok,id} = LeftIdentityWork[G];
	If[ok, id, $Failed]
	]

LeftIdentity[G_?GroupoidQ, Mode -> Visual, opts___?OptionQ] := 
	(IdentityQVisualWork[G,LeftIdentity[G],leftid,opts]; LeftIdentity[G])

LeftIdentityWork[G_] := LeftIdentityWork[G] = Module[{els = Elements[G],index,ok,len},
	If[untestedQ[leftidentity[G]] || untestedQ[leftidentityq[G]],
		index = Position[makeTable[G,els],els]//Flatten;
		ok = (len = Length[index])>=1;
		If[len > 1, Message[Identity::lmultiple,StructureName[G],index]];
		{leftidentityq[G], leftidentity[G]} = If[ok, {ok,els[[First[index]]]},
			{ok,Null}];
		If[Not[ok], Message[Identity::lfail,StructureName[G]]];
		AddGroupInfo[G, ok, StringJoin["the left identity is ", 
			ToString[leftidentity[G]]], "there is no left identity"];
	];
	{leftidentityq[G], leftidentity[G]}
]

HasRightIdentityQ[G_?GroupoidQ] := HasRightIdentityQ[G] =
		Module[{ok,id},
	{ok,id} = RightIdentityWork[G];
	ok
	]

HasRightIdentityQ[G_?GroupoidQ, Mode -> Visual, opts___?OptionQ] := 
	(IdentityQVisualWork[G,RightIdentity[G],rightid,opts]; HasRightIdentityQ[G])

RightIdentity[G_?GroupoidQ] := RightIdentity[G] =
		Module[{ok,id},
	{ok,id} = RightIdentityWork[G];
	If[ok, id, $Failed]
	]
	
RightIdentity[G_?GroupoidQ, Mode -> Visual, opts___?OptionQ] := 
	(IdentityQVisualWork[G,RightIdentity[G],rightid,opts]; RightIdentity[G])

RightIdentityWork[G_] := RightIdentityWork[G] = Module[{els = Elements[G],index,ok,len},
	If[untestedQ[rightidentity[G]] || untestedQ[rightidentityq[G]],
		index = Position[Transpose[makeTable[G,els]],els]//Flatten;
		ok = (len = Length[index])>=1;
		If[len > 1, Message[Identity::rmultiple,StructureName[G],index]];
		{rightidentityq[G], rightidentity[G]} = If[ok, {ok,els[[First[index]]]},
			{ok,Null}];
		If[Not[ok], Message[Identity::rfail,StructureName[G]]];
		AddGroupInfo[G, ok, StringJoin["the right identity is ", 
			ToString[rightidentity[G]]], "there is no right identity"];
	];
	{rightidentityq[G], rightidentity[G]}
]

IdentityWork[G_] :=  IdentityWork[G] = Module[{leftok,rightok,leftid,rightid},
	{leftok,leftid} = LeftIdentityWork[G];
	{rightok,rightid} = RightIdentityWork[G];
	If[Not[leftok] && Not[rightok], Message[Identity::fail,StructureName[G]]];
	{leftok && rightok, If[leftid===rightid,leftid,Null]}
	]

Options[HasIdentityQ]={Mode -> Computational, Structure -> Group};

HasIdentityQ[G_?GroupoidQ] := HasIdentityQ[G] = 
		Module[{ok, id},
	{ok,id} = IdentityWork[G];
	If[ok, GroupIdentity[G] = id];
	AddGroupInfo[G, ok, StringJoin["the identity is ", 
			ToString[id]], "there is no identity"];
	ok]

HasIdentityQ[G_?GroupoidQ, opts___?OptionQ] := 
		Module[{mymode, sc,
		struct = Structure/.Flatten[{opts, Options[HasIdentityQ]}]},
	mymode = Mode/.Flatten[{opts, Options[HasIdentityQ]}];
	sc = FilterOptions[ShowModes,opts];
	ShowModes["AbstractAlgebra`Core",HasIdentityQ,mymode,HasIdentityQ[G], 
		{G,HasIdentityQ[G],struct,OperatorSymbol[G]}, 
		{G,GroupIdentity[G],opts},{Null},{Null},sc]]

HasIdentityQ[many:{_?GroupoidQ..}] := Map[HasIdentityQ, many]

HasIdentityQ[many:{_?GroupoidQ..},Mode -> Visual] := 
	(suppressGraphicsQ = True;
		manyVisual[many])

HasIdentityQ[many:{_?GroupoidQ..}, Mode -> mode_] :=
	handleSimpleMultiple[HasIdentityQ, many, mode]
		
HasIdentityQ[many:{_?GroupoidQ..}, Mode -> mode_,opts___?OptionQ] :=
	handleSimpleMultiple[HasIdentityQ, many, mode,{opts}]
		
manyVisual[many_] := Module[{gr,len,i,vals},
	len = Length[many];
	Do[gr[i]=HasIdentityQ[many[[i]],Mode->Visual,
		Output -> Graphics,
		DisplayFunction ->Identity],{i,len}];
	vals = Table[HasIdentityQ[many[[i]]],
		{i,len}];
	suppressGraphicsQ = False;
	Show[GraphicsArray[Table[{gr[i]},{i,len}]/. 
		{{Null} :> {ErrorSpace}}],
		DisplayFunction -> $DisplayFunction];
	vals]
		
HasIdentityQTextual[G_,ok_,st_,symb_] := 
	If[Not[multipleQ], IdentityQTextualGD[st,symb]; IdentityQTextualLI[G,ok,st],
		If[firstPassQ, 
			IdentityQTextualGD[st,symb]; IdentityQTextualLI[G,ok,st];firstPassQ = False,
			IdentityQTextualLI[G,ok,st]]]

IdentityQTextualGD[Group,"+"] := 
	Print["We say a Groupoid G has an identity e if
for all other elements g in G we have e + g = g + e = g (where + indicates
the operation)."]

IdentityQTextualGD[Group,_] := 
	Print["We say a Groupoid G has an identity e if
for all other elements g in G we have e * g = g * e = g (where * indicates
the operation)."]

IdentityQTextualGD[Ring,"+"] := 
	Print["We say a Ringoid R has an additive identity called 0 if
for all other elements r in R we have 0 + r = r + 0 = r (where + indicates
the operation)."]

IdentityQTextualGD[Ring,"*"] := 
	Print["We say a Ringoid R has an multiplicative identity called 1 if
for all other elements r in R we have 1 * r = r * 1 = r (where * indicates
the operation)."]

IdentityQTextualGD[_,_] := 
	Print["We say a structured set S (such as a Groupoid or Ringoid) has an identity e if
for all other elements g in S we have e*g = g*e = g (where * indicates
the operation)."]

IdentityQTextualLI[G_,ok_,st_] := 
(If[$VersionNumber < 2.5, Print[" "]];
	Print["In this case, "<>theGroupName[G]<>
If[ok," has the identity "<>ToString[GroupIdentity[G]]<>".",
	" has no identity."]])

Options[HasIdentityQVisual]={DisplayFunction -> $DisplayFunction};

HasIdentityQVisual[G_,id_,opts___] := IdentityQVisualWork[G,id,both,opts]

IdentityQVisualWork[G_,id_,side_,opts___] := 
	Module[{els = Elements[G],len, rects, inter, pos,
		coloredRects = {}, gBasicRects, gColoredRects1, gText, 
		gLines, row, column,table, gr1, gr2,
		gColoredRects2,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[HasIdentityQVisual]}]},
	If[HasIdentityQ[G],
	{gLines, gText, rects} = basicCayley[G,els, CayleyForm -> CayleyForm[G]];
	table = makeTable[G,Elements[G]];
	len = Length[els];
	pos = Position[els,id,1]//Flatten//First;
	row = Part[rects, Position[table,els]//Flatten];
	column = Part[Transpose[rects], Position[Transpose[table],
		els]//Flatten];
	inter = Intersection[row//Flatten,column//Flatten];
	gColoredRects1 = Show[Graphics[{
		{Cyan,column}, {Text["red->right identity",{-.9,-.5},{-1,0}]},
		{Cyan,Rectangle[{-1,0},{0,len}]},
		{Red,Rectangle[{pos-1,len},{pos,len+1}]},
		{Cyan,inter}},DisplayFunction -> Identity]];
	gColoredRects2 = Show[Graphics[{{Yellow,row},
		 {Yellow,Rectangle[{0,len},{len,len+1}]},
		 {Text["red->left identity",{-.9,-.5},{-1,0}]},
		{Red,Rectangle[{-1,len - pos},{0,len - pos +1}]},
		{Yellow,inter}},DisplayFunction -> Identity]];
	gr1 = Show[{gColoredRects1, gLines, gText},
		DisplayFunction -> Identity];
	gr2 = Show[{gColoredRects2, gLines, gText},
		DisplayFunction -> Identity];
	If[WideElementsQ[G],
		PrintCayleyKey[els,StructureName[G],G, KeyForm[G]]];
	If[side === leftid, Show[gr2,showopts,
		DisplayFunction -> df],
		If[side === rightid, Show[gr1,showopts,
			DisplayFunction -> df],
			Show[GraphicsArray[{gr2,gr1}],showopts,
			DisplayFunction -> df]]]]]
	
Options[GroupIdentity]={Mode -> Computational, Structure -> Group};

GroupIdentity[G_?GroupoidQ] :=  GroupIdentity[G] =
		Module[{ok, id},
	{ok,id} = IdentityWork[G];
	HasIdentityQ[G] = ok;
	AddGroupInfo[G, ok, StringJoin["the identity is ", 
			ToString[id]], "there is no identity"];
	If[ok, id, $Failed]
	]

GroupIdentity[G_?GroupoidQ,opts___?OptionQ] := 
		Module[{mymode, sc,
		struct = Structure/.Flatten[{opts, Options[GroupIdentity]}]},
	mymode = Mode/.Flatten[{opts, Options[GroupIdentity]}];
	sc = FilterOptions[ShowModes,opts];
	ShowModes["AbstractAlgebra`Core",GroupIdentity,mymode,GroupIdentity[G], 
		{G,HasIdentityQ[G],struct,OperatorSymbol[G]}, 
		{G,GroupIdentity[G],opts},{Null},{Null},sc]]

GroupIdentityTextual[args___] := HasIdentityQTextual[args]

GroupIdentityVisual[args___] := HasIdentityQVisual[args]

GroupIdentity[many:{_?GroupoidQ..}] := Map[GroupIdentity, many]

GroupIdentity[many:{_?GroupoidQ..},Mode -> Visual] := 
	(suppressGraphicsQ = True;
		manyVisual[many])

GroupIdentity[many:{_?GroupoidQ..}, Mode -> mode_] :=
	handleSimpleMultiple[GroupIdentity, many, mode]
		
GroupIdentity[many:{_?GroupoidQ..}, Mode -> mode_,opts___?OptionQ] :=
	handleSimpleMultiple[GroupIdentity, many, mode,{opts}]
			
Unprotect[Identity];

groupoid /: Identity[G_groupoid,opts___?OptionQ] := GroupIdentity[G,opts];

Identity[many:{_?GroupoidQ..},opts___?OptionQ] := GroupIdentity[many,opts];

Protect[Identity];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
23.3 inverses
:[font = input; initialization; preserveAspect; endGroup]
*)
LeftInverseWork[G_,g_] := Module[{pos,els=Elements[G],ok,
		op = Operation[G]},
	If[HasIdentityQ[G],
		pos = Flatten[Position[Map[op[#,g]&,els],GroupIdentity[G],1]];
		ok = If[pos === {}, False,True];
		{ok,If[ok,First[els[[pos]]],$Failed]},
		Message[Inverse::noId,StructureName[G]];{False,$Failed}]]

LeftInvertibleQ[G_?GroupoidQ,g_] := LeftInvertibleQ[G,g] = 
		If[ElementQ[g,G],
		Module[{ok,inv},
	{ok,inv} = LeftInverseWork[G,g];
	LeftInverse[G,g] = inv;
	ok],
	Message[MemberQ::elmnt, g, StructureName[G]]; False]

LeftInvertibleQ[G_?GroupoidQ,many_List] :=
	Map[LeftInvertibleQ[G,#]&, many]/; SubsetQ[many,Elements[G]]

LeftInverse[G_?GroupoidQ,g_] := LeftInverse[G, g] =
		If[ElementQ[g,G],
		Module[{ok,inv},	
	{ok,inv} = LeftInverseWork[G,g];
	LeftInvertibleQ[G,g] = ok;
	If[Not[LeftInvertibleQ[G,g]],Message[Inverse::fail,g,StructureName[G]];
		$Failed, inv]],
	Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

LeftInverse[G_?GroupoidQ,many_List] :=
	Map[LeftInverse[G,#]&, many] /; SubsetQ[many,Elements[G]]

RightInverseWork[G_,g_] := Module[{pos,els=Elements[G],ok,
		op = Operation[G]},
	If[HasIdentityQ[G],
		pos = Flatten[Position[Map[op[g,#]&,els],GroupIdentity[G],1]];
		ok = If[pos === {}, False,True];
		{ok,If[ok,First[els[[pos]]],$Failed]},
		Message[Inverse::noId,StructureName[G]];{False,$Failed}]]

RightInvertibleQ[G_?GroupoidQ,g_] := RightInvertibleQ[G,g] =
	If[ElementQ[g,G],
		Module[{ok,inv},
			{ok,inv} = RightInverseWork[G,g];
			RightInverse[G,g] = inv;
			ok],
	Message[MemberQ::elmnt, g, StructureName[G]]; False]

RightInvertibleQ[G_?GroupoidQ, many_List] :=
	Map[RightInvertibleQ[G,#]&, many] /; SubsetQ[many,Elements[G]]
	
RightInverse[G_?GroupoidQ,g_] := RightInverse[G, g] =
	If[ElementQ[g,G], 
		Module[{ok,inv},
	{ok,inv} = RightInverseWork[G,g];
	RightInvertibleQ[G,g] = ok;
	If[!RightInvertibleQ[G,g],Message[Inverse::fail,g,StructureName[G]]; 
	$Failed, inv]],
	Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

RightInverse[G_?GroupoidQ,many_List] :=
	Map[RightInverse[G,#]&, many]/; SubsetQ[many,Elements[G]]
		
(*InverseWork[G_,g_] :=  
	Module[{leftok,rightok,leftinv,rightinv},
	{leftok,leftinv} = LeftInverseWork[G,g];
	{rightok,rightinv} = RightInverseWork[G,g];
	{leftok && rightok, If[leftinv===rightinv,rightinv,$Failed]}
	]*)

InverseWork[G_,g_] :=  
	Module[{leftok,rightok,leftinv,rightinv},
	{leftok,leftinv} = LeftInverseWork[G,g];
	If[leftok,
		{rightok,rightinv} = RightInverseWork[G,g],
		{rightok, rightinv} = {False, NULL}];
	{leftok && rightok, If[leftinv===rightinv,rightinv,$Failed]}
	]

Options[InvertibleQ] = {Mode -> Computational, Structure -> Group};

InvertibleQ[G_?GroupoidQ,g_] :=  InvertibleQ[G, g] =
		If[ElementQ[g,G], Module[{ok, inv},
	{ok,inv} = InverseWork[G,g];
	GroupInverse[G,g] = inv;
	AddGroupInfo[G, ok, StringJoin["the inverse of ",ToString[g],
		" is ",ToString[inv]], 
		StringJoin["there is no inverse for ",ToString[g]]];
	ok],
	Message[MemberQ::elmnt, g, StructureName[G]]; False]

InvertibleQ[G_?GroupoidQ,g_,opts___?OptionQ] :=  
	If[ElementQ[g,G], Module[{mymode,sc,
		struct = Structure/.Flatten[{opts, Options[InvertibleQ]}]},
	mymode = Mode/.Flatten[{opts, Options[InvertibleQ]}];
	sc = FilterOptions[ShowModes,opts];
	ShowModes["AbstractAlgebra`Core",InvertibleQ,mymode,InvertibleQ[G,g], 
		{G,g,InvertibleQ[G,g],struct,OperatorSymbol[G]}, 
		{G,g,GroupInverse[G,g],InvertibleQ[G,g],opts},{Null},{Null},sc]],
	Message[MemberQ::elmnt, g, StructureName[G]]; False]

InvertibleQ[G_?GroupoidQ,many_List] :=
	Map[InvertibleQ[G,#]&,many]/; SubsetQ[many,Elements[G]]
	
InvertibleQ[G_?GroupoidQ,many_List,Mode -> mode_] := 
	(multipleQ = True; firstPassQ = True;
		handleSimple2Multiple[InvertibleQ,G,many,mode,
			{}] /; SubsetQ[many,Elements[G]])
	
InvertibleQ[G_?GroupoidQ,many_List,Mode -> mode_,opts___?OptionQ] := 
	(multipleQ = True; firstPassQ = True;
		handleSimple2Multiple[InvertibleQ,G,many,mode,
			{opts}] /; SubsetQ[many,Elements[G]])
			
InvertibleQ[many_List] := 
	InvertibleQ[many, 
			Mode -> (Mode/.Options[InvertibleQ])]

InvertibleQ[many_List,Mode -> mode_] := 
	handlePairedMultiple[InvertibleQ,Map[First,many],
	Map[Rest,many], mode]
	
InvertibleQTextual[args___] := InverseTextual[args]

InvertibleQVisual[args___] := InverseVisual[args]

Options[GroupInverse] = {Mode -> Computational, Structure -> Group};

GroupInverse[G_?GroupoidQ,g_] := GroupInverse[G,g] = 
		If[ElementQ[g,G], Module[{ok, inv, temp},
	If[ElementQ[temp = inverseFunction[G][g],G],
		{ok,inv} = {True, temp},
		{ok,inv} = InverseWork[G,g]];
	InvertibleQ[G,g] = ok;
	AddGroupInfo[G, ok, StringJoin["the inverse of ",ToString[g],
		" is ",ToString[inv]], 
		StringJoin["there is no inverse for ",ToString[g]]];
	If[!InvertibleQ[G,g], Message[Inverse::fail,g,StructureName[G]]; $Failed, inv]],
	Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

GroupInverse[G_?GroupoidQ, g_,opts___?OptionQ] :=  
	If[ElementQ[g,G], Module[{ok, mymode, inv, mess1, mess2,sc,temp,
		struct = Structure/.Flatten[{opts, Options[GroupInverse]}]},
	mymode = Mode/.Flatten[{opts, Options[GroupInverse]}];
	sc = FilterOptions[ShowModes,opts];
	ShowModes["AbstractAlgebra`Core",GroupInverse,mymode,GroupInverse[G,g], 
		{G,g,InvertibleQ[G,g],struct,OperatorSymbol[G]}, 
		{G,g,GroupInverse[G,g],InvertibleQ[G,g],opts},{Null},{Null},sc]],
	Message[MemberQ::elmnt, g, StructureName[G]]; $Failed]

GroupInverse[G_?GroupoidQ,many_List] :=
	Map[GroupInverse[G,#]&, many]/; SubsetQ[many,Elements[G]]
	
GroupInverse[G_?GroupoidQ,many_List,Mode -> mode_] := 
	(multipleQ = True; firstPassQ = True;
		handleSimple2Multiple[GroupInverse,G,many,mode,
			{}] /; SubsetQ[many,Elements[G]])

GroupInverse[G_?GroupoidQ,many_List,Mode -> mode_,opts___?OptionQ] := 
	(multipleQ = True; firstPassQ = True;
		handleSimple2Multiple[GroupInverse,G,many,mode,
			{opts}] /; SubsetQ[many,Elements[G]])
	
GroupInverseTextual[args___] := InverseTextual[args]

GroupInverseVisual[args___] := InverseVisual[args]

InverseTextual[G_,g_,ok_,st_,symb_] := 
	If[!multipleQ, InverseTextualGD[st,symb]; 
		InverseTextualLI[G,g,ok],
		If[firstPassQ, 
			InverseTextualGD[st,symb]; InverseTextualLI[G,g,ok];firstPassQ = False,
			InverseTextualLI[G,g,ok]]]

InverseTextualGD[Group,"+"] := 
	Print["Given a Groupoid G, we say an element g in G has
an inverse h if G has an identity e and g + h = h + g = e
(where + indicates the operation)."]

InverseTextualGD[Group,"*"] := 
	Print["Given a Groupoid G, we say an element g in G has
an inverse h if G has an identity e and g * h = h * g = e
(where * indicates the operation)."]

InverseTextualGD[Group,_] := 
	Print["Given a Groupoid G, we say an element g in G has
an inverse h if G has an identity e and g * h = h * g = e
(where * indicates the operation)."]

InverseTextualGD[Ring,"+"] := 
	Print["Given a Ringoid R, we say an element r in R has
an additive inverse s if R has an additive identity 0 and r + s = s + r = 0
(where + indicates the operation)."]

InverseTextualGD[Ring,"*"] := 
	Print["Given a Ringoid R, we say an element r in R has
an multiplicative inverse s if R has an multiplicative identity
1 and r * s = s * r = 1
(where * indicates the operation)."]

InverseTextualGD[_,_] := 
	Print["Given a StructuredSet S (Groupoid or Ringoid), we say an element g in S has
an inverse h if S has an identity e and g*h = h*g = e
(where * indicates the operation)."]

InverseTextualLI[G_,g_,ok_] := (
If[$VersionNumber < 2.5, Print[" "]];
	Print["In this case, "<>ToString[InputForm[g]]<>
If[ok," has "<>ToString[GroupInverse[G,g]]<>" as the inverse.\n",
	" does not have an inverse."]])

Options[InverseVisual]={DisplayFunction -> $DisplayFunction};
		
InverseVisual[G_,g_,ginv_,ok_,opts___] := 
	Module[{els = Elements[G],len, rects,
		table = makeTable[G,Elements[G]],
		coloredRects = {}, gColoredRects, gText, 
		gLines, row, column,pos,posinv,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[InverseVisual]}]},
	If[ok,{gLines,gText,  rects} = basicCayley[G,els, CayleyForm -> CayleyForm[G]];
	len = Length[els];
	pos = Position[els,g]//Flatten//First;
	posinv = Position[els,ginv]//Flatten//First;
	row = Part[rects, pos];
	column = Part[Transpose[rects], posinv];
	inter = Intersection[row//Flatten,column//Flatten];
	gColoredRects = Show[Graphics[{{Cyan,row},{Yellow,column}, 
		{Green,inter},
		{GrayLevel[.6],Rectangle[{-1,len-pos},{0,len-pos+1}]},
		{GrayLevel[.6],Rectangle[{posinv-1,len},{posinv,len+1}]}
		},DisplayFunction -> Identity]];
	If[WideElementsQ[G],
		PrintCayleyKey[els,StructureName[G],G, KeyForm[G]]];
	Show[{gColoredRects, gLines,gText},showopts,
		DisplayFunction -> df], ErrorSpace]
	]

Unprotect[Inverse];

groupoid /: Inverse[G_groupoid, args___] := GroupInverse[G,args]

Protect[Inverse];

inverseList[G_] := inverseList[G] = Module[{els = Elements[G], 
 id, idok, done = False, remaining,g,h,list={},
		op = Operation[G], ok = False, pos},
	id = GroupIdentity[G];
	remaining = els;
	idok = If[id === Null, False, True];
	If[!idok,Message[Inverse::noId,StructureName[G]]];
	While[Not[done] && idok,
		g = First[remaining];
		pos = Flatten[Position[Map[op[#,g]&,remaining],id,1],1];
		ok = If[pos == {}, False,True];
		h = Part[remaining,If[Length[pos]>0,First[pos],
			pos]];
		If[h ==={}, h = "no inverse"];
		AppendTo[list,{g,h,ok}];
		remaining = Complement[remaining,{g,h}];
		done = remaining =={};
	];
	list]

Options[HasInversesQ] = {Mode -> Computational, Structure -> Group};
	
HasInversesQ[G_?GroupoidQ] := HasInversesQ[G] =
		Module[{ok,invlist},
	invlist = inverseList[G];
	If[invlist === {}, ok = False; Inverses[G] = {},
		Inverses[G] = Transpose[Take[Transpose[invlist],2]];
		ok = Apply[And,Transpose[invlist][[3]]]];
	AddGroupInfo[G, ok, "every element has an inverse",
		"there are elements without inverses"];
	ok]
		
HasInversesQ[G_?GroupoidQ,opts___?OptionQ] := 
	Module[{mymode, sc,
	struct = Structure/.Flatten[{opts, Options[HasInversesQ]}]},
	mymode = Mode/.Flatten[{opts, Options[HasInversesQ]}];
	sc = FilterOptions[ShowModes,opts];
	ShowModes["AbstractAlgebra`Core",HasInversesQ,mymode,HasInversesQ[G], 
		{G,HasInversesQ[G],struct,OperatorSymbol[G]},{G,opts},{G, inverseList[G],opts},{Null},sc]]
		
HasInversesQTextual[args___] := InversesTextual[args]

HasInversesQVisual[args___] := InversesVisual[args]

InversesTextual[G_,ok_,st_,symb_] := 
	If[!multipleQ, InverseTextualGD[st,symb]; 
		InversesTextualLI[G,ok,st],
		If[firstPassQ, 
			InverseTextualGD[st,symb]; InversesTextualLI[G,ok,st];firstPassQ = False,
			InversesTextualLI[G,ok,st]]]

InversesTextualLI[G_,ok_,st_] := Module[{invlist},
	invlist = inverseList[G];If[$VersionNumber < 2.5, Print[" "]];
	invlist = If[invlist =!= {}, invlist//Transpose//Take[#,2]&//Transpose, invlist];
	If[invlist =!= {},
		Print["The "<>If[st===Group,"Groupoid ","Ringoid "]<>
		theGroupName[G]<>" "<>
		If[!ok,
			"contains some elements without inverses. For example, "<>
			ToString[Select[invlist,(#[[2]]==="no inverse")&][[1,1]]]<>
			" does NOT have an inverse.",
			"has an inverse for every element."]],
		Print["Since there is no identity, inverses are not possible."]]]

Options[InversesVisual]={DisplayFunction -> $DisplayFunction};
		
InversesVisual[G_,opts___] := 
	Module[{els = Elements[G],len, inter, coords, lines,
		gLines, invlist, pairs,positionInS, bad, loops, regular, wide,
		showopts = FilterOptions[Graphics,opts], ok, els2,
		df = DisplayFunction/.Flatten[{opts, Options[InversesVisual]}]},
ok = HasIdentityQ[G];
If[ok,
	If[wide=WideElementsQ[G],
		PrintCayleyKey[els,StructureName[G],G, KeyForm[G], "g"]];
	invlist = inverseList[G]//Transpose//Take[#,2]&//Transpose;
	bad = Select[invlist,(#[[2]]==="no inverse")&];
	loops = Select[invlist,(#[[1]] === #[[2]])&];
	regular = Complement[invlist,bad];
	positionInS = Flatten[Map[Position[els,#,1]&,Flatten[regular,1],1],2]//
		Partition[#,2]&;
	len = Length[els];
	coords = Map[Part[ngonCoordsC[len],#]&,positionInS];
	lines = Map[Line[{#[[1]],#[[2]]}]&,coords]/.
		Line[{pr_,pr_}] :> Circle[pr*1.08,.07];
	els2 = If[wide, Map[ElementToKey[G, #]&, els], els];
	Off[Graphics::optx];
	Show[{Graphics[{White,If[wide,Rectangle[{-1.6,-1},{1.6,1}],
		Point[{0,0}]]}], modCircle[len],
		LabelingNgon[els2, els2, 1.25, If[wide, SequenceForm, OutStdForm]],
		Graphics[{AbsoluteThickness[2],Brown,lines}]},
		showopts, DisplayFunction -> df, DefaultFont -> defaultFont, 
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]; On[Graphics::optx];,
	Message[Inverse::noId, StructureName[G]]
	]]

Options[InversesVisual2]={DisplayFunction -> $DisplayFunction};
		
InversesVisual2[G_,invl_List,opts___] := Module[{
		invlist = invl,f,rules,temp,t2,gr,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[InversesVisual2]}]},
	invlist=invlist/.{{a_,_,False} -> {{a,Null},{Null,a}},
		{a_,b_,True} -> {{a,b},{b,a}}}//Flatten[#,1]&//
		Union;
	f[g_,{n_}] := g -> n;
	rules = MapIndexed[f, Elements[G]];
	invlist = invlist /. rules /. Null -> 0;
	If[WideElementsQ[G],Print[ToString[Join[{"KEY:: group element"->
		"labeled as:"},rules/.Rule[x_,y_]:> Rule[InputForm[x],y]]]]];
	gr = ListPlot[invlist,AxesOrigin -> {0,0},
		AspectRatio -> Automatic,
		PlotRange -> {{0,temp = Length[Elements[G]]},
		{0,temp}},PlotStyle -> {RGBColor[0,0,1],
		PointSize[0.02]}, Ticks -> If[WideElementsQ[G],
		{t2=Table[i,{i,0,temp}],t2},{t2 = Join[{{0,"X"}},
		Table[{i,ToString[Elements[G][[i]]]},{i,1,temp}]],t2}],
		DisplayFunction -> Identity, AxesLabel -> {"g","g^(-1)"}];
	Show[gr,
		showopts, DisplayFunction -> df]
](* the idea for this came from Dennis Kletzing *)

HasInversesQ[many:{_?GroupoidQ..}] :=
	Map[HasInversesQ, many]
		
HasInversesQ[many:{_?GroupoidQ..}, Mode -> mode_] :=
	handleSimpleMultiple[HasInversesQ, many, mode]
		
HasInversesQ[many:{_?GroupoidQ..}, Mode -> mode_,opts___?OptionQ] :=
	handleSimpleMultiple[HasInversesQ, many, mode,{opts}]
				
Options[Inverses] = {Mode -> Computational, Structure -> Group};
		
Inverses[G_?GroupoidQ] := Inverses[G] =
		Module[{ok, invlist, out},
	invlist = inverseList[G];
	If[invlist === {}, ok = False; out = {},
		out = Transpose[Take[Transpose[invlist],2]];
		ok = Apply[And,Transpose[invlist][[3]]]];
	HasInversesQ[G] = ok;
	AddGroupInfo[G, ok, "every element has an inverse",
		"there are elements without inverses"];
	out]
		
Inverses[G_?GroupoidQ,opts___?OptionQ] := 
	Module[{mymode, sc,
		struct = Structure/.Flatten[{opts, Options[Inverses]}]},
	mymode = Mode/.Flatten[{opts, Options[Inverses]}];
	sc = FilterOptions[ShowModes,opts];
	ShowModes["AbstractAlgebra`Core",Inverses,mymode,Inverses[G], 
		{G,HasInversesQ[G],struct,OperatorSymbol[G]},{G,opts},{G, inverseList[G],opts},{Null},sc]]
		
Inverses[many:{_?GroupoidQ..}] :=	Map[Inverses, many]
		
Inverses[many:{_?GroupoidQ..}, Mode -> mode_] :=
	handleSimpleMultiple[Inverses, many, mode]
		
Inverses[many:{_?GroupoidQ..}, Mode -> mode_,opts___?OptionQ] :=
	handleSimpleMultiple[Inverses, many, mode,{opts}]
		
Inverses[many:{_?GroupoidQ..}] :=
	Inverses[many, Mode -> (Mode/.Options[Inverses])]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
23.4 associative
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[AssociativeQ] = {Mode -> Computational, Structure -> Group,
Output -> Computational};

AssociativeQ[G_?GroupoidQ] := AssociativeQ[G] = 
	Module[{els = Elements[G], op = Operation[G], ok = True, i,j,k, 
		len = Length[G[[1]]], mymode,bad},
	(*Off[Part::partd];*)
	Do[bad = {i,j,k};
		ok = op[els[[i]],op[els[[j]],els[[k]]]] === 
		op[op[els[[i]],els[[j]]],els[[k]]];
		If[!ok,Break[]], {i,1,len},{j,1,len},{k,1,len}];
	(*On[Part::partd];*)
		AddGroupInfo[G, ok, "the operation is associative with these elements",
		"the operation is not associative with these elements"];
	ok]
		
AssociativeQ[G_?GroupoidQ, opts___?OptionQ] := 
	Module[{els = Elements[G], op = Operation[G], output,
		struct = Structure/.Flatten[{opts, Options[AssociativeQ]}],
		sc = FilterOptions[ShowModes,opts], ok = True, i,j,k, 
		len = Length[G[[1]]], mymode,bad={1,1,1}},
	mymode = Mode/.Flatten[{opts, Options[AssociativeQ]}];
	struct = Structure/.Flatten[{opts, Options[AssociativeQ]}];
	output = Output/.Flatten[{opts, Options[AssociativeQ]}];
	ok = AssociativeQ[G];
	AddGroupInfo[G, ok, "the operation is associative with these elements",
		"the operation is not associative with these elements"];
	If[Not[ok],
		Do[bad = {i,j,k};
		ok = op[els[[i]],op[els[[j]],els[[k]]]] === 
		op[op[els[[i]],els[[j]]],els[[k]]];
		If[!ok,Break[]], {i,1,len},{j,1,len},{k,1,len}]];
	ShowModes["AbstractAlgebra`Core",AssociativeQ,mymode,ok, 
		{G,bad,ok}, 
		{G, output},{Null},{Null},sc]]

AssociativeQTextual[G_,bad_,ok_] := 
	If[!multipleQ, AssociativeQTextualGD[G]; 
		AssociativeQTextualLI[G,bad,ok],
		If[firstPassQ, 
			AssociativeQTextualGD[G]; AssociativeQTextualLI[G,bad,ok];firstPassQ = False,
			AssociativeQTextualLI[G,bad,ok]]]

AssociativeQTextualGD[_] := 
Print["Given a StructuredSet S (Groupoid or Ringoid), we say
the operation * is associative
if for every g, h, and k in S we have (g*h)*k = g*(h*k),
where * is the operation."]

AssociativeQTextualLI[G_,bad_,ok_] := 
		Module[{d,e,f,n=Length[Elements[G]],SG = Elements[G],
			op = Operation[G],ops = OperatorSymbol[G],a,b,c},
	{a,b,c} = Map[Part[SG,#]&,bad];
	If[$VersionNumber < 2.5, Print[" "]];
	Print["In this case, "<>theGroupName[G]<>
		If[ok," is associative.",
			" is NOT associative since we have ("<>
			ToString[a]<>ops<>ToString[b]<>")"<>ops<>
			ToString[c]<>" = "<>ToString[op[op[a,b],c]]<>
			", which is not equal to "<>
			ToString[op[a,op[b,c]]]<>" = "<>
			ToString[a]<>ops<>"("<>ToString[b]<>ops<>
			ToString[c]<>")!"]];
	If[$VersionNumber < 2.5, Print[" "]];
	Print[StringJoin["Consider the following table illustrating "<>
	If[ok,"random triples that associate.","triples that do not associate. "]<>
	"Pay attention to the last two columns."]];
	Print[TableForm[If[ok, randomTriples[G, 10],NonAssociatingWork[G]],
		TableSpacing->{If[$VersionNumber > 2.5, 0.5, 0],2}, 
		TableDepth -> 2,
		(*TableAlignments -> {Center, Center},*)
		TableHeadings -> {None,{"i","j","k","(i*j)*k",
		"i*(j*k)\n"}}]]
]

randomTriples[G_?GroupoidQ, k_] := Module[{d, e, f, op = Operation[G]},
	Table[{d = RandomElement[G],e = RandomElement[G],
		f = RandomElement[G], op[op[d,e],f],
		op[d,op[e,f]]},{k}]]

NonAssociatingWork[G_?GroupoidQ] := Module[{d, e, f, op = Operation[G],
	els = Elements[G], n},
	n = Length[els];
	Select[Flatten[Table[{d = els[[i]],e=els[[j]],
		f=els[[k]],op[op[d,e],f],
		op[d,op[e,f]]},{i,n},{j,n},{k,n}],2], #[[4]]=!=#[[5]]&]]
		
NonAssociatingTriples[G_?GroupoidQ] := 
	Map[Take[#,3]&, NonAssociatingWork[G]]
		
AssociativeQVisual[G_?GroupoidQ, output_]:=
	Module[{diskcolor = RGBColor[0.747, 0.885, 0.977], gr,
		black = RGBColor[0.0, 0.0, 0.0],
	  a=RandomElement[G], b=RandomElement[G],
	  c=RandomElement[G], opsymb=OperatorSymbol[G],
	  ptlist1,ptlist2,ptlist3,
	  labellist1,labellist21,labellist22,labellist31,
	  labellist32,seglist1,seglist2,resultstrings,
	  pic1,pic21,pic22,pic31,pic32,toplabel1,toplabel2},
	toplabel1="a "<>OperatorSymbol[G]<>" (b "<>OperatorSymbol[G]<>"  c)";
	toplabel2="(a "<>OperatorSymbol[G]<>" b) "<>OperatorSymbol[G]<>" c";
	ptlist1={{1,0},{3,0},{2,1},{2.5,-1},{3.5,-1},{-1,0},
		{-3,0},{-2,1},{-2.5,-1},{-3.5,-1}};
	labellist1={ToString[a],opsymb,opsymb,ToString[b],
		ToString[c],ToString[c],opsymb,opsymb,ToString[b],
		ToString[a]};
  seglist1={{1,3},{2,3},{4,2},
            {5,2},{6,8},{7,8},{9,7},{10,7}};
 	pic1={Text[toplabel1,{2,2}],Text[toplabel2,{-2,2}],
 		Map[Line[Map[ptlist1[[#]]&,#]]&,seglist1],
 		diskcolor,Map[Disk[#,0.4]&,ptlist1],
		black,Map[Text[labellist1[[#]],
			ptlist1[[#]]]&,Range[1,10]],
    Text["Values for a, b and c selected at random.",{0,-1.5}]};
	ptlist2={{1,0},{3,0},{2,1},{-1,0},{-3,0},{-2,1}};
	labellist21={ToString[a],ToString[ToString[b]<>opsymb<>
		ToString[c]],opsymb,ToString[c],ToString[ToString[a]<>
		opsymb<>ToString[b]],opsymb};
	labellist22={ToString[a],ToString[Operation[G][b,c]],
		opsymb,ToString[c],ToString[Operation[G][a,b]],opsymb};
	seglist2={{1,3},{2,3},{4,6},{5,6}};
	pic21={Text[toplabel1,{2,2}],Text[toplabel2,{-2,2}],
 		Map[Line[Map[ptlist2[[#]]&,#]]&,seglist2],
		diskcolor,Map[Disk[#,0.4]&,ptlist2],
		black,Map[Text[labellist21[[#]],
		ptlist2[[#]]]&,Range[1,6]]};
 	pic22={Text[toplabel1,{2,2}],Text[toplabel2,{-2,2}],
  	Map[Line[Map[ptlist2[[#]]&,#]]&,seglist2],
		diskcolor, Map[Disk[#,0.4]&,ptlist2],black,
		Map[Text[labellist22[[#]],ptlist2[[#]]]&,Range[1,6]]};
	ptlist3={{2,1},{-2,1}};
	labellist31={ToString[a]<>opsymb<>ToString[Operation[G][b,c]],
    ToString[Operation[G][a,b]]<>opsymb<>ToString[c]};
	labellist32={ToString[Operation[G][a,Operation[G][b,c]]],
    ToString[Operation[G][Operation[G][a,b],c]]};
	resultstrings=If[Operation[G][a,Operation[G][b,c]]===
    Operation[G][Operation[G][a,b],c],
    {"The two results are equal.",
    " Associativity is possible."},
    {"The two results are different.",
    "Associativity is violated."}];
	pic31={Text[toplabel1,{2,2}],Text[toplabel2,{-2,2}],
		diskcolor,Map[Disk[#,0.4]&,ptlist3],black,
		Map[Text[labellist31[[#]],ptlist3[[#]]]&,Range[1,2]]};
	pic32={Text[toplabel1,{2,2}],Text[toplabel2,{-2,2}],
		diskcolor,Map[Disk[#,0.4]&,ptlist3],black,
  	Map[Text[labellist32[[#]],ptlist3[[#]]]&,Range[1,2]],
  	Text[First[resultstrings],{0,-1}],
    Text[Last[resultstrings],{0,-1.8}]};
gr[1] = pic1//Graphics;
gr[2] = pic21//Graphics;
gr[3] = pic22//Graphics;
gr[4] = pic31//Graphics;
gr[5] = pic32//Graphics;
If[output === GraphicsArray, Show[GraphicsArray[makeGA[gr,5]]],
gr[1]//Show[#,PlotRange->{{-4,4},{-2,2.5}}]&;
gr[2]//Show[#,PlotRange->{{-4,4},{-2,2.5}}]&;
gr[3]//Show[#,PlotRange->{{-4,4},{-2,2.5}}]&;
gr[4]//Show[#,PlotRange->{{-4,4},{-2,2.5}}]&;
gr[5]//Show[#,PlotRange->{{-4,4},{-2,2.5}}]&]]
	
Options[RandomAssociativeQ] = {Mode -> Computational, Structure -> Group};

RandomAssociativeQ[G_?GroupoidQ, n_:25, opts___?OptionQ] := 
	Module[{els = Elements[G], op = Operation[G],
		sc = FilterOptions[ShowModes,opts],
		struct = Structure/.Flatten[{opts, Options[RandomAssociativeQ]}],
		ok, i,j,k, len = Length[G[[1]]],
		mymode,bad={1,1,1},pr1,pr2,nn},
	mymode = Mode/.Flatten[{opts, Options[RandomAssociativeQ]}];
	nn = If[IntegerQ[n] && Positive[n], n, 25];
	(*Off[Part::partd];*)
	(*If[untestedQ[randomassociativityQ[G]],*)
		Do[{i,j,k} = Table[Random[Integer,{1,len}],{3}];
			bad = {i,j,k};
			pr1 = op[els[[i]],op[els[[j]],els[[k]]]];
			pr2 = op[op[els[[i]],els[[j]]],els[[k]]];
			ok = pr1 === pr2;
			If[!ok,Break[]], {nn}];
	(*On[Part::partd];*)
		randomassociativityQ[G] = ok;
		AddGroupInfo[G, ok, "the operation is probably associative with these elements",
		"the operation is not associative with these elements"];(*,
		ok = randomassociativityQ[G]];*)
	ShowModes["AbstractAlgebra`Core",RandomAssociativeQ,mymode,ok, 
		{G,n}, 
		{G},{Null},{Null},sc]]

RandomAssociativeQTextual[G_,n_] := Module[{prods={},op = Operation[G],i,j,k,
		els = Elements[G], len, pr1, pr2,ok,bad},
	len = Length[els];
	Do[{i,j,k} = Table[Random[Integer,{1,len}],{3}];
			bad = {i,j,k};
			pr1 = op[els[[i]],op[els[[j]],els[[k]]]];
			pr2 = op[op[els[[i]],els[[j]]],els[[k]]];
			ok = pr1 === pr2;
			AppendTo[prods, {i,j,k,pr1,pr2}];
			If[!ok,Break[]], {n}];
	If[!multipleQ, AssociativeQTextualGD[G]; 
		RandomAssociativeQTextualLI[G,bad,ok,prods],
		If[firstPassQ, 
			AssociativeQTextualGD[G]; RandomAssociativeQTextualLI[G,bad,ok,prods];firstPassQ = False,
			RandomAssociativeQTextualLI[G,bad,ok,prods]]]]

RandomAssociativeQTextualLI[G_,bad_,ok_,prods_] := 
		Module[{d,e,f,n=Length[Elements[G]],op = Operation[G],
		ops = OperatorSymbol[G],a,b,c,SG=Elements[G]},
	{a,b,c} = Map[Part[SG,#]&,bad];
	Print["Since this involves "<>ToString[n^3]<>
" comparisons, this function approaches associativity randomly.
In this case, "<>theGroupName[G]<>
		If[ok," appears to be associative.\n",
			" is NOT associative since we have ("<>
			ToString[a]<>ops<>ToString[b]<>")"<>ops<>
			ToString[c]<>" = "<>ToString[op[op[a,b],c]]<>
			", which is not equal to "<>
			ToString[op[a,op[b,c]]]<>" = "<>
			ToString[a]<>ops<>"("<>ToString[b]<>ops<>
			ToString[c]<>")!\n"]];
	Print[StringJoin["Consider the following table.
	The first column is i, the second j, the third is k,
	the fourth is (i*j)*k and the fifth is i*(j*k). 
	Pay attention to the last two columns."]];
	Print[TableForm[Take[prods, 15],TableHeadings->{None,
	{"i","j","k","(i*j)*k" ,"i*(j*k)\n"}},TableDepth -> 2,
	(* TableAlignments->{Center, Center},*)TableSpacing -> 
		{If[$VersionNumber > 2.5, 0.5, 0],2}]]
]

RandomAssociativeQVisual[args___] := AssociativeQVisual[args]

AssociativeQ[many:{_?GroupoidQ..}] := Map[ClosedQ, many]
		
AssociativeQ[many:{_?GroupoidQ..}, Mode -> Textual] :=
	handleSimpleMultiple[AssociativeQ, many, Textual,{}]
	
AssociativeQ[many:{_?GroupoidQ..}, Mode -> Visual, opts___?OptionQ] :=
	Table[AssociativeQ[many[[i]], Mode -> Visual, opts], {i, Length[many]}]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
23.5 group - all Operations
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[GroupQ]={Mode -> Computational};

AddGroupInfo[G_, ok_, mess1_, mess2_, other___] := 
	(If[untestedQ[GroupInfo[G]], GroupInfo[G] = {}];
	If[ok,
		If[!MemberQ[GroupInfo[G],mess1],
			AppendTo[GroupInfo[G],mess1]],
		If[!MemberQ[GroupInfo[G],mess2],
			AppendTo[GroupInfo[G],mess2]]];)

GroupQ[G_?GroupoidQ] := GroupQ[G] = Module[{ok},
	ok = ClosedQ[G];
	If[ok, ok = HasIdentityQ[G]];
	If[ok, ok = HasInversesQ[G]];
	If[ok, ok = AssociativeQ[G]];
	If[untestedQ[GroupInfo[G]], GroupInfo[G] = {}];
	AddGroupInfo[G, ok, "this is a group", "this is NOT a group"];
	ok]
	
GroupQ[G_?GroupoidQ,opts___?OptionQ] := Module[{
	 	mymode, mess1, mess2, out, ok, sc = FilterOptions[ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[GroupQ]}];
	ShowModes["AbstractAlgebra`Core",GroupQ, mymode, GroupQ[G], 
		{G},{G},{Null},{Null},sc]]
		
GroupQ[many:{_?GroupoidQ..}] :=
	Map[GroupQ, many]
			
GroupQ[many:{_?GroupoidQ..}, Mode -> Textual] :=
	handleSimpleMultiple[GroupQ, many, Textual,{}]
	
GroupQ[many:{_?GroupoidQ..}, Mode -> Visual, opts___?OptionQ] :=
	Table[GroupQ[many[[i]], Mode -> Visual, opts], {i, Length[many]}]
	
GroupQTextual[G_] := 
	(ClosedQ[G, Mode -> Textual];
	HasIdentityQ[G, Mode -> Textual];
	HasInversesQ[G, Mode -> Textual];
	AssociativeQ[G, Mode -> Textual])
	
GroupQVisual[G_] := (
	ClosedQ[G,Mode -> Visual];
	HasIdentityQ[G,Mode -> Visual];
	Inverses[G,Mode -> Visual];
	AssociativeQ[G,Mode -> Visual];
	)

Options[ProbableGroupQ]={Mode -> Computational};

ProbableGroupQ[G_?GroupoidQ] := ProbableGroupQ[G] = Module[{ok},
	ok = ClosedQ[G];
	If[ok, ok = HasIdentityQ[G]];
	If[ok, ok = HasInversesQ[G]];
	If[ok, ok = RandomAssociativeQ[G]];
	AddGroupInfo[G, ok, "this is (probably) a group", "this is NOT a group"];
	ok]
	
ProbableGroupQ[G_?GroupoidQ,opts___?OptionQ] := Module[{
	 	mymode, mess1, mess2, out, ok, sc = FilterOptions[ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[ProbableGroupQ]}];
	ShowModes["AbstractAlgebra`Core",ProbableGroupQ, mymode, ProbableGroupQ[G], 
		{G},{G},{Null},{Null},sc]]
	
ProbableGroupQTextual[G_] := 
	(ClosedQ[G, Mode -> Textual];
	HasIdentityQ[G, Mode -> Textual];
	HasInversesQ[G, Mode -> Textual];
	AssociativeQ[G, Mode -> Textual])
	
ProbableGroupQVisual[G_] := (
	ClosedQ[G,Mode -> Visual];
	HasIdentityQ[G,Mode -> Visual];
	Inverses[G,Mode -> Visual];
	RandomAssociativeQ[G,Mode -> Visual])
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
23.6 similar structures
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
SemiGroupQ[G_?GroupoidQ]:= ClosedQ[G] && AssociativeQ[G]

MonoidQ[G_?GroupoidQ] := SemiGroupQ[G] && HasIdentityQ[G]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 30. Subgroup stuff
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.2 SubgroupQ
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[SubgroupQ]={Mode -> Computational};
	
SubgroupQ[many:{_List..}, G_?GroupoidQ] := Map[SubgroupQ[#,G]&, 
	many]/; Apply[And,Map[SubsetQ[#, Elements[G]]&,many]]

SubgroupQ[many:{_List..}, G_?GroupoidQ, Mode -> mode_] := 
		handleSimple3Multiple[SubgroupQ,G, many,mode,
			{}] /; Apply[And,Map[SubsetQ[#,Elements[G]]&,many]]

SubgroupQ[many:{_?GroupoidQ..}, G_?GroupoidQ] := Map[SubgroupQ[#,G]&, 
	many]

SubgroupQ[many:{_?GroupoidQ..}, G_?GroupoidQ, Mode -> mode_] := 
		handleSimple3Multiple[SubgroupQ,G, many,mode,
			{}]

SubgroupQ[many:{_List..}] :=
	SubgroupQ[many, Mode -> (Mode/.Options[SubgroupQ])]
		
SubgroupQ[many:{_List..},Mode -> mode_] :=
	handlePairedMultiple[SubgroupQ,Map[First,many],
		Map[Rest,many], mode]
	
SubgroupQ[H_List, G_?GroupoidQ] := SubgroupQ[H,G] =
	If[GroupQ[G],SubgroupQWork[G,H],
		Message[Group::fail,StructureName[G]];$Failed]
				
SubgroupQ[H_?GroupoidQ, G_?GroupoidQ] := SubgroupQ[H,G] =
	If[Operation[G] === Operation[H],
		If[GroupQ[G],SubgroupQWork[G,Elements[H]],
			Message[Group::fail,StructureName[G]]; False],
		Message[Operation::fail]; False]
				
SubgroupQ[H_List,G_,  opts___?OptionQ] := 
	If[GroupQ[G],SubgroupQWork[G,H,opts],
		Message[Group::fail,StructureName[G]]]
	
SubgroupQ[H_?GroupoidQ, G_?GroupoidQ,  opts___?OptionQ] :=
	If[Operation[G] === Operation[H],
		If[GroupQ[G],SubgroupQWork[G,Elements[H],opts],
			Message[Group::fail,StructureName[G]];$Failed],
		Message[Operation::fail]; False]
					
SubgroupQWork[G_, H_, opts___?OptionQ] := Module[{mymode, ok, GG,
		sc = FilterOptions[ShowModes,opts]},
	mymode = Mode/.Flatten[{opts, Options[SubgroupQ]}];
	GG = FormGroupoid[H, Operation[G], OperatorSymbol[G]];
	If[Not[untestedQ[inverseFunction[G]]], inverseFunction[GG] =
		inverseFunction[G]];
	ok = Length[H] > 0 && SubsetQ[H,Elements[G]] &&
		ClosedQ[GG];
	ShowModes["AbstractAlgebra`Core",SubgroupQ,mymode,ok,{G,H},
			{G,H,opts},{G,H,ok,opts},{Null},sc]]
		
exNotClosed[H_,G_] := Module[{i=1,j=1,done = False,
	len = Length[H],el1,el2,prod},
	While[Not[done],
		el1 = H[[i]];
		el2 = H[[j]];
		prod = Operation[G][el1,el2];
		If[Not[MemberQ[H,prod]],
			done = True,
			i++;
			If[i>len,i=1;j++]
		];
	];
	{el1,el2,prod}]
	(* finds an example to  show not closed *)

SubgroupQTextual[G_,H_] := 
	If[!multipleQ, SubgroupQTextualGD[G]; SubgroupQTextualLI[G,H],
		If[firstPassQ, 
			SubgroupQTextualGD[G];SubgroupQTextualLI[G,H];firstPassQ = False,
			SubgroupQTextualLI[G,H]]]

SubgroupQTextualGD[_] := Print["By definition, we say a set H is a subgroup of the
group G if H is a subset of G and it is itself a group under the operation inherited
from G. For finite groups, as is the case here, one
only needs to show the closure of H under the operation of G
(assuming, of course, that H is nonempty).\n"]

SubgroupQTextualLI[G_,H_] := Module[{trip},
If[SubgroupQ[H,G],
		Print[StringJoin["Since ",ToString[H]," is closed
under the operation of ",theGroupName[G],", then indeed this is
a subgroup.\n"]],
		If[Length[H]>0,
			trip = exNotClosed[H,G];
			Print[StringJoin["Since ",ToString[H]," is NOT closed
(for example, the elements ",ToString[trip[[1]]], " and ",
ToString[trip[[2]]], " have a product (sum) of ",ToString[trip[[3]]],
", which is not in ",ToString[H],"), this is not a subgroup of ",
theGroupName[G],".\n"]],
			Print["Since the set H is empty, it can not be a subgroup.\n"]]
	]]

Options[SubgroupQVisual]={DisplayFunction -> $DisplayFunction};

SubgroupQVisual[G_,H_,opts___?OptionQ] := 
	Module[{els = Elements[G],len, rects, gColoredRects, gText,
		gLines, pos, good, in, out,op = Operation[G], morein,
		moreinpos, showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[SubgroupQVisual]}]},
	len = Length[els];
	els = Join[H,Complement[els,H]];
	(* if this new els is ok, what is below can be simplified *)
	pos = Flatten[Map[Position[els,#,1]&,H]];
	moreinpos =  pos;
	pos = Flatten[Outer[List, pos, pos],1];
	morein = {Yellow,Join[Map[Rectangle[{#-1,len},{#, len+1}]&,moreinpos],
		Map[Rectangle[{-1,len-#},{0, len+1-#}]&,moreinpos]]};
	{gLines, gText,rects} = basicCayley[G,els, CayleyForm -> CayleyForm[G]];
	good = Select[pos, MemberQ[H,Part[els,#[[1]]]~op~Part[els,#[[2]]]]&];
	in = {Yellow, Map[Part[rects,#[[1]],#[[2]]]&,good]};
	out = {Red, Map[Part[rects,#[[1]],#[[2]]]&,Complement[pos,good]]};
	in = {Yellow,Join[in[[2]],morein[[2]]]};
	gColoredRects = Show[Graphics[{in, out},
		DisplayFunction -> Identity]];
	If[showVisTextQ[SubgroupQ1],
Print[StringJoin["All the elements marked with Yellow are
original elements in the set. Those in red are from outside."]]];
If[WideElementsQ[G],
		PrintCayleyKey[els,StructureName[G],G, KeyForm[G]]];
Show[{gColoredRects, gLines,gText},
		showopts,DisplayFunction -> df]]

Cosets[G_?GroupoidQ,H_List,side_] := Module[{op = Operation[G],
	findcoset},
	findcoset[{els_,cosetlist_,mside_}] := 
			Module[{temp,g,cs = cosetlist},
		temp = Fold[DeleteCases[#1, #2]&,els,Last[cs]];
		If[temp=!={}, g = First[temp];
			AppendTo[cs,Map[If[mside===left,op[g,#]&,
				op[#,g]&],H]]];
		{temp,cs,side}];
	FixedPoint[findcoset,{Elements[G],{H},side}][[2]]
]

Options[SubgroupQVisual2]={DisplayFunction -> $DisplayFunction};

SubgroupQVisual2[G_,H_,sub_,opts___?OptionQ] := 
	Module[{S = Elements[G],len, rects, coloredRects, gText, 
		colorfn,i,j,colors, gLines,cosets,newlist,headings,
		op = Operation[G],
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[SubgroupQVisual2]}]},
If[!sub, Message[MemberQ::sbgrp,H,StructureName[G]],
	len = Length[S];
	cosets = Cosets[G,H,left];
	newlist = Flatten[cosets,1];
	{gLines, gText,rects} = 
		basicCayley[G,newlist, CayleyForm -> CayleyForm[G]];
	Do[colorfn[cosets[[1,i]]] = Yellow,{i, Length[H]}];
	Do[colorfn[cosets[[i,j]]] = BackgroundColors[[i]],
		{i, 2, Length[cosets]},{j,Length[H]}];
	colors = Map[colorfn,makeTable[G,newlist],{2}];
	headings = Transpose[{Map[colorfn,newlist],
		Table[Rectangle[{i-1, len}, {i, len+1}],{i,len}]}];
	headings = Join[headings,Transpose[{Map[colorfn,newlist],
		Table[Rectangle[{-1, len-i}, {0, len-i+1}],{i,len}]}]];
	coloredRects = Transpose[{Flatten[colors],Flatten[rects]}];
	If[showVisTextQ[SubgroupQ2],
Print[StringJoin["All the
elements marked with Yellow are elements in the subgroup.
The others are colored according to the various left cosets
of the subgroup in the group."]]];
	Show[{Graphics[{headings, coloredRects}], gLines, gText},
		showopts,DisplayFunction -> df]]]
			
SubgroupQVisual4[G_,H_,opts___] := 
	Module[{S = Elements[G],Gp},
	S = Join[H,Complement[S,H]];
	Gp = FormGroupoid[S, Operation[G], GatherGroupoidOptions[G]];
	SubgroupQVisual[Gp, H, opts, DisplayFunction -> Identity]
	(*SubgroupQ[H,Gp, Mode -> Visual,Output -> Graphics,opts]*)]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 30.6 Subgroup closure
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
Options[Closure] = {Mode -> Computational, ReportIterations ->
	False, Staged -> False, Sort -> False, Output -> Computational};

Closure[G_?GroupoidQ, H_?GroupoidQ, opts___?OptionQ] := 
	If[Operation[G] === Operation[H],
		Closure[G, Elements[H], opts],
		Message[Operation::fail]; $Failed]
		
Closure[G_?GroupoidQ, H_List] := Closure[G, H] = 
	Module[{elem, iterations},
If[SubsetQ[H,Elements[G]],
	{elem, iterations} = ClosureWk[G, H];
	If[ProperSubsetQ[elem,Elements[G]],
		FormGroupoid[elem, Operation[G], OperatorSymbol[G],
			GatherSubGroupoidOptions[G]],
		ReorderGroupoid[G, elem]],
Message[MemberQ::elmnts,H,StructureName[G]]; $Failed]]

ClosureWk[G_, H_] := Module[{op = Operation[G], elem = H,
	optable, done = False, level = 1, els,n, max = Length[Elements[G]]},
	els[1]=H;
	While[(Length[elem]<=max) && Not[done],
		optable=CloseSets[elem,elem,op];
		If[Sort[Union[elem,optable]]===Sort[elem],
			done=True,
			(*else*)
			elem=UnionNoSort[Join[elem,optable]];
			level++;
			els[level] = elem]];(*end of While *)
	{elem, Table[els[k], {k, 1, level}]}]
	
Closure[G_?GroupoidQ,H_List, opts___?OptionQ] :=  
	Module[{mymode,ri=False,st=False,elem, iterations,
		sc = FilterOptions[ShowModes,opts],srt, output},
If[SubsetQ[H,Elements[G]],
	mymode = Mode/.Flatten[{opts, Options[Closure]}];
	srt = Sort/.Flatten[{opts, Options[Closure]}];
	ri = ReportIterations/.Flatten[{opts, Options[Closure]}];
	st = Staged/.Flatten[{opts, Options[Closure]}];
	output = Output/.Flatten[{opts, Options[Closure]}];
	{elem, iterations} = ClosureWk[G, H];
	If[srt, elem = Sort[elem]];
	If[st && mymode === Visual, mymode = Visual2];
	elem = If[ProperSubsetQ[elem, Elements[G]],
		FormGroupoid[elem, Operation[G], OperatorSymbol[G],
			GatherSubGroupoidOptions[G]],
		ReorderGroupoid[G, elem]];
	If[output === GraphicsArray, ClosureArray[G, elem, iterations, opts],
	ShowModes["AbstractAlgebra`Core",Closure,mymode,If[!ri,elem,
			{elem,{Length[iterations],iterations}}],{G},
			{G,iterations,opts},
			{G,iterations,opts},{Null},sc]],
Message[MemberQ::elmnts,H,StructureName[G]];$Failed]]

ClosureVisual2[G_,lst_,opts___] := ClosureVisualStaged[G,lst,opts]

ClosureArray[G_,elem_,lst_,opts___] := Module[{i,n, ga},
	firstPassQ = True;
	Do[If[i > 1, PrintCayleyKeyQ = False];ClosureVisualStagedSlide[i] = 
		SubgroupQVisual4[G,lst[[i]], DisplayFunction -> 
		Identity,opts];
		firstPassQ = False,{i,Length[lst]}];
	firstPassQ = True;
	TotalStages[Closure] = Length[lst];
	ga = makeGA[ClosureVisualStagedSlide,TotalStages[Closure]];
	Show[GraphicsArray[ga],
		DisplayFunction -> $DisplayFunction]
]

ClosureVisualStaged[G_,lst_,opts___] := Module[{i},
	firstPassQ = True;
	Do[If[i > 1, PrintCayleyKeyQ = False];ClosureVisualStagedSlide[i] = 
		SubgroupQVisual4[G,lst[[i]], DisplayFunction -> 
		Identity,opts];
		firstPassQ = False,{i,Length[lst]}];
	firstPassQ = True;
	TotalStages[Closure] = Length[lst];
	CurrentStage[Closure] = 1;
	Show[ClosureVisualStagedSlide[1],
		DisplayFunction -> $DisplayFunction]
]

NextStage[Closure] := (CurrentStage[Closure]++;
	If[CurrentStage[Closure] <= TotalStages[Closure],
		Show[ClosureVisualStagedSlide[CurrentStage[Closure]],
			DisplayFunction -> $DisplayFunction],
		CurrentStage[Closure]=1;
		Show[ClosureVisualStagedSlide[1],
			DisplayFunction -> $DisplayFunction]])

NextStage[Closure,k_Integer?Positive] := (Do[CurrentStage[Closure]++,{k}];
	If[CurrentStage[Closure] <= TotalStages[Closure],
		Show[ClosureVisualStagedSlide[CurrentStage[Closure]],
			DisplayFunction -> $DisplayFunction],
		CurrentStage[Closure]=1];
		Show[ClosureVisualStagedSlide[1],
			DisplayFunction -> $DisplayFunction])
			
PreviousStage[Closure] := (CurrentStage[Closure]--;
	If[CurrentStage[Closure] > 0,
		Show[ClosureVisualStagedSlide[CurrentStage[Closure]],
			DisplayFunction -> $DisplayFunction],
		CurrentStage[Closure]=TotalStages[Closure];
		Show[ClosureVisualStagedSlide[TotalStages[Closure]],
			DisplayFunction -> $DisplayFunction]];)

PreviousStage[Closure,k_Integer?Positive] := (Do[CurrentStage[Closure]--,{k}];
	If[CurrentStage[Closure] > 0,
		Show[ClosureVisualStagedSlide[CurrentStage[Closure]],
			DisplayFunction -> $DisplayFunction],
		CurrentStage[Closure]=TotalStages[Closure];
		Show[ClosureVisualStagedSlide[TotalStages[Closure]],
			DisplayFunction -> $DisplayFunction]];)

PreviousStage[SubgroupClosure] := PreviousStage[Closure]

NextStage[SubgroupClosure] := NextStage[Closure]

ClosureVisual[G_,lst_,opts___] := Module[{i},
	Do[If[i > 1, PrintCayleyKeyQ = False];SubgroupQVisual4[G,lst[[i]],opts, DisplayFunction -> $DisplayFunction],
		{i,Length[lst]}]]

SubgroupClosure[G_?GroupoidQ, H_List, opts___?OptionQ] := 
	Closure[G, H, opts]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 31. Size of a Group
:[font = input; initialization; preserveAspect; endGroup]
*)
Size[G_?StructuredSetQ] := Size[G] = Length[Elements[G]]

Size[G_?StructuredSetQ, Mode -> mode_] := Size[G] = 
	(Message[Mode::notavail, Size, mode]; Length[Elements[G]])

Unprotect[Order];

groupoid /: Order[G_groupoid] := Size[G];

ringoid /: Order[G_ringoid] := Size[G];

groupoid /: Order[G_groupoid, Mode -> mode_] := Size[G, Mode -> mode];

ringoid /: Order[G_ringoid, Mode -> mode_] := Size[G, Mode -> mode];

Order[many:{_groupoid..}] := Map[Size, many]

Order[many:{_ringoid..}] := Map[Size, many]

Protect[Order];

Size[many:{_?StructuredSetQ..}] := Map[Size, many]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 99. Wrap up Core
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
End[];

EndPackage[];
(*
^*)
