(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Groupoids` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 0. Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`Groupoids *)

(* :Context: AbstractAlgebra`Groupoids` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)

(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 1. Startup AbstractAlgebra`Groupoids
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Groupoids`",
	{"AbstractAlgebra`Core`", "Graphics`Graphics`","Utilities`FilterOptions`",
	"Graphics`Colors`"}];

Off[General::spell,General::spell1];
SetOptions[Graphics,AspectRatio->Automatic];
Format[LineBreak[_]] = "";
Format[Indent[_]] = "";
Format[StringBreak[_]] = "";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2. Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
AsIJK::usage = "AsIJK is a value for the Form option for
QuaternionGroup. This specifies that the quaternion group will be
represented by the elements { 1,  I, JJ, KK} (K is a reserved symbol
in version 3 and J is used for rings), with a set of relations governing
these elements.";

AsMatrices::usage = "AsMatrices is a value for the Form option for
QuaternionGroup. This specifies that the quaternion group will be
represented by 2 by 2 matrices. This is the default value.";

AsSymbols::usage = "AsSymbols is a value for the Form option for
QuaternionGroup. This specifies that the quaternion group will be
generated by the symbols {a, b} subject to a set of relations governing
these symbols. In this form, the elements used are given in the form of
Mathematica strings.";

Cyclic::usage = "Cyclic[n] returns the cyclic group of order n with the
default generator 'g'. Cyclic[n, Generator -> gen] returns the same
group but written with generator gen (which could be a string or a
symbol with no value). Cyclic[n, k] returns the Groupoid generated by
g^k.";

CyclicGroup::usage = "CyclicGroup[n] - see Cyclic.";

D::usage = "D[n] returns the dihedral group of index n and order 2n. See
Dihedral for more information. The standard (built-in) usage still
exists: D[f, x] gives the partial derivative of f with respect to x.
D[f, {x, n}] gives the nth partial derivative with respect to x. D[f,
x1, x2, ...] gives a mixed derivative.";

Dihedral::usage = "Dihedral[n] returns the dihedral group of index n and
order 2n. By default, the generators are indicated by Rot (for the
smallest angle of rotation) and Ref (for any reflection). D[n, Form ->
Permutations] uses the permutations corresponding to Rot and Ref; the
default is Form -> RotRef. D[n, RotSym -> newsy1, RefSym -> newsy2] uses
the symbols newsy1 and newsy2 for Rot and Ref respectively. Alternate
names for Dihedral are D and DihedralGroup.";

DihedralGroup::usage = "DihedralGroup[n] - see Dihedral.";

ESG::usage = "ESG[code] is the group corresponding to the one given by
the code 'code' as used in Exploring Small Groups.";

FirstTaker::usage = "FirstTaker[n] returns the Groupoid with elements
{1,2,...n} and the operation that returns the first of the two inputs.";

GaussianUnits::usage = "GaussianUnits returns the Groupoid consisting of
{1,-1, i, -i} under ordinary complex multiplication.";

Generator::usage = "Generator is an option for the Cyclic function,
specifying which symbol should be used for the generator of the group.";

IntegerUnits::usage = "IntegerUnits returns the Groupoid consisting of
{1,-1} under ordinary multiplication.";

JoinDivisors::usage = "JoinDivisors[n] returns the Groupoid consisting
of the divisors of n with operation LCM.";

Klein4::usage = "Klein4 returns the Klein-4 group (Viergruppe).";

MaxTaker::usage = "MaxTaker[n] returns the Groupoid with elements
{1,2,...n} and the operation which returns the maximum of the two
inputs. MaxTaker[m, n] is similar but the elements range over [m, n].";

MeetDivisors::usage = "MeetDivisors[n] returns the Groupoid consisting
of the divisors of n with operation GCD.";

MinTaker::usage = "MinTaker[n] returns the Groupoid with elements
{1,2,...n} and the operation which returns the minimum of the two
inputs. MinTaker[m, n] is similar but the elements range over [m, n].";

MixedDivisors::usage = "MixedDivisors[n] returns the Groupoid consisting
of the divisors of n with operation LCM/GCD.";

PermutationComposition::usage = "PermutationComposition[p2, p1] returns
the product of permutation p1 followed by permutation p2.";

Permutations::usage = "Permutations is an option for Form when working
with the dihedral group. See Dihedral for more information. The standard
(built-in) definition still works: Permutations[list] generates a list
of all possible permutations of the elements in list.";

QuaternionGroup::usage = "QuaternionGroup[] returns the 8 element
Quaternion group. This group can be represented in various forms; the
default is to represent it as 2 by 2 matrices. The option Form controls
what form to use, with the default value being AsMatrices. Other values
are AsIJK and AsSymbols.";

RandomGroupoid::usage = "RandomGroupoid[n, k] returns a random Groupoid
of order n. If k = 1, the Cayley table is a collection of n^2 random
elements from a list of n generic elements; if k = 2, each row is a
permutation of a list of n generic elements; if k = 3, each column is a
permutation of a list of n generic elements.";

Ref::usage = "This is the standard (default) symbol to represent a
reflection when working with the dihedral group D[n].";

RefSym::usage = "When working with dihedral groups, by default we have
RefSym -> Ref. This can be changed to any other symbol to be used to
represent the reflection. See Dihedral for more information.";

RootsOfUnity::usage = "RootsOfUnity[n] returns the Groupoid consisting
of the n complex roots of the equation z^n = 1, under multiplication.";

Rot::usage = "This is the standard (default) symbol to represent the
rotation of the smallest angle when working with the dihedral group
D[n].";

RotRef::usage = "RotRef is an option for Form when working with the
	dihedral group. See Dihedral for more information.";

RotSym::usage = "When working with dihedral groups, by default we have
RotSym -> Rot. This can be changed to any other symbol to be used to
represent the rotation. See Dihedral for more information.";

Trivial::usage = "Trivial returns the trivial Groupoid consisting of
just an identity element.";

TwistedZ::usage = "TwistedZ[n] returns the Groupoid with elements {0, 1,
... n-2} and operation Mod[#1 + #2 + #1 #2, n]&.";

U::usage = "U[n] returns the group of integers mod n which are
relatively prime to n, under multiplication. These elements are also the
units in the ring Z[n]. (In other words, these are the elements that
have inverses in the Groupoid Zx[n].)";

Zx::usage = "Zx[n] returns the Groupoid of integers mod n under
multiplication. Zx[n, k] returns the group of multiples of k mod n, if
k is a divisor of n. Finally, Zx[n, I] returns the Groupoid of the
Gaussian integers under mod n multiplication.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.4 Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
Generator::string = "This function requires the generator to be a string
or an undefined symbol. Your symbol `1` is not a string.";

Klein4::warning = "The elements e, a, b, c are considered strings and
thus need to have double quotes around them when being used.";

QuaternionGroup::JJKK = "(Note that KK is used because K is a reserved
symbol in version 3 of Mathematica and JJ is used because J is reserved
as a generic name for an ideal.)"; 
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 2.5 Begin private section
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 7. Misc.
:[font = input; initialization; preserveAspect; endGroup]
*)
PermutationComposition=Module[{k},
	Map[Function[k,Part[#1,k]],#2]&];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 16. Constructing groupoids
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
16.1
:[font = input; initialization; preserveAspect; endGroup]
*)
GroupoidQ[G_] := (Head[G]===Groupoid || Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

GroupoidQ[many:{_AbstractAlgebra`Core`Private`groupoid..}] := Map[GroupoidQ,many]

GroupoidQ[many:{_Groupoid..}] := Map[GroupoidQ,many]

(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
 16.11 RandomGroupoid
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
RandomGroupoid[n_Integer?Positive, 1] := Module[{els, tab},
	els = Table["g"<>ToString[i], {i, n}];
	tab = Partition[RandomElements[els, n^2],n];
	FormGroupoidByTable[els, tab, GroupoidName -> "Random"]]
	
RandomGroupoid[n_Integer?Positive, 2] := Module[{els, tab},
	els = Table["g"<>ToString[i], {i, n}];
	tab = Table[Randomize[els],{n}];
	FormGroupoidByTable[els, tab, GroupoidName -> "Random"]]
	
RandomGroupoid[n_Integer?Positive, 3] := Module[{els, tab},
	els = Table["g"<>ToString[i], {i, n}];
	tab = Transpose[Table[Randomize[els],{n}]];
	FormGroupoidByTable[els, tab, GroupoidName -> "Random"]]
	
RandomGroupoid[n_Integer?Positive, 4] := 	"Still under
construction."
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 17. Families of groupoids
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.1 - Cyclic group of order n
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[CyclicGroup] = {Mode -> Computational, Generator -> "g"};

CyclicGroup[args___] := Cyclic[args]

Options[Cyclic] = {Mode -> Computational, Generator -> "g"};

SetAttributes[CyclicProd,Listable]

CyclicProd[a_^b_:1,c_^d_:1, order_Integer?Positive] := 
	Which[a===1 && c===1, 1,
		a===1 && c=!=1, c^Mod[d,order],
		a=!=1 && c===1, a^Mod[b,order],
		a=!=1 && c=!=1 && a===c, c^Mod[b+d,order],
		(* note in this case, a = c *)
		True,Print["Nonsense!"]
	];

Cyclic[n_Integer?Positive,opts___?OptionQ] := 
		Module[{mymode,G,gen,sc},
	mymode = Mode/.Flatten[{opts, Options[Cyclic]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	gen = Generator/.Flatten[{opts, Options[Cyclic]}];
	If[Head[gen] =!= String && Head[gen] =!= Symbol,
		Message[Generator::string,gen]; $Failed,
		If[gen === 1 && n > 1, Z[n,opts], (* else - the rest *)
			If[n==1, G = FormGroupoid[{gen},trivProd,"*",
					IsAGroup -> True, Generators -> {gen},
					GroupoidDescription -> "Trivial group expressed multiplicatively",
					GroupoidName ->StringJoin["Cyclic[1]"]],
			G = GenerateGroupoid[{gen},CyclicProd[#1,#2,n]&,
				IsAGroup -> True, Generators -> {gen}, WideElements -> If[n < 9, False, True],
				GroupoidDescription -> "Cyclic group expressed multiplicatively",
				GroupoidName ->StringJoin["Cyclic[",ToString[n],"]"], opts]];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",Cyclic,mymode,G, {n,Elements[G]}, 
			{n,-1, Join[{1,ToString[gen]},
				Table[ToString[gen]<>"^"<>ToString[k],{k,2,n-1}]],
			opts},{Null},{Null},sc]]]]
			
Cyclic[n_Integer?Positive, k_Integer?Positive, opts___?OptionQ] := 
		Module[{mymode,G,gen,sc},
	mymode = Mode/.Flatten[{opts, Options[Cyclic]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	gen = Generator/.Flatten[{opts, Options[Cyclic]}];
	If[Head[gen] =!= String && Head[gen] =!= Symbol,
		Message[Generator::string,gen],
		If[Mod[n, k]==0,
			If[gen === 1 && n > 1, Z[n,opts], (* else - the rest *)
				If[n==1, G = FormGroupoid[{gen},trivProd,"*",
					IsAGroup -> True, Generators -> {gen},
					GroupoidDescription -> "Trivial group expressed multiplicatively",
					GroupoidName ->StringJoin["Cyclic[1]"]],
				G = GenerateGroupoid[{gen^(k)},CyclicProd[#1,#2,n]&,
					IsAGroup -> True, Generators -> {gen},
					GroupoidDescription -> "Cyclic group expressed multiplicatively",
					GroupoidName ->StringJoin["Cyclic[",ToString[n],",",
						ToString[k],"]"], opts]];
		AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",Cyclic,
		mymode,G, {n, Elements[G]}, 
			{n,k, Join[{1,ToString[gen]<>"^"<>ToString[k]},
				Table[ToString[gen]<>"^"<>ToString[k*j],{j,2,(n-1)/k}]],opts},{Null},{Null},sc]],
			Message[Groupoid::modd,k,n]; $Failed]]]
			
CyclicTextual[n_,els_] := 
	(Print["This groupoid consists of the elements"];
	Print[ToString[els]];
	Print[StringJoin["with the operation being multiplication where
the exponents are reduced mod ",ToString[n],".\n"]]);

Options[CyclicVisual]={DisplayFunction -> $DisplayFunction};
			
CyclicVisual[n_, k_, els_, opts___] := 
		Module[{showopts = FilterOptions[Graphics,opts], tempg,
		df = DisplayFunction/.Flatten[{opts, Options[CyclicVisual]}]},
	If[AbstractAlgebra`Core`Private`showVisTextQ[Cyclic],
	Print[StringJoin["Think of the elements as the numbers on a (modified)
clock. The differences, however, are that we will
view the element 1 as being equivalent to twelve and
the other elements as powers of ", ToString[els[[2]]],". Multiplication
of two elements is done by adding the exponents on the
elements, just like adding the hours of a clock.\n"]]];
	Show[If[k == -1, AbstractAlgebra`Core`Private`MakeCircle[n,els, Blue, 
		SequenceForm],
		AbstractAlgebra`Core`Private`MakeCircle[n,k,Map[ToString,els], 
		SequenceForm]],showopts,
			DisplayFunction -> df]]

Cyclic[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[Cyclic, many, mode])
		
Cyclic[many:{_Integer?Positive..}] :=
	Cyclic[many, Mode -> 
		(Mode/.Options[Cyclic])]

Cyclic[n_, opts___] := (Message[Cyclic::intpm,"Cyclic["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.3 - Zx - integers mod n under multiplication
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[Zx] = {Mode -> Computational};

Zx[n_Integer?Positive, k_Integer?Positive, opts___?OptionQ] :=
		Module[{mymode,G,st,sc},
	mymode = Mode/.Flatten[{opts, Options[Zx]}];
	st = Structure/.Flatten[{opts, Options[Zx]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	If[Mod[n, k]==0,
			G = FormGroupoid[Range[0,n-1,k], Mod[#1 #2,n]&,"*",
				FormatOperator->False,
				Generators -> {k},
				GroupoidDescription -> "subset of integers mod n under multiplication",
				GroupoidName ->StringJoin["Zx[",ToString[n],",",ToString[k],"]"]];
			AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",Zx,
				mymode,G,{Null}, 
				{Null},{Null},{Null},sc],
		Message[Groupoid::modd,k,n]; $Failed]]
	
Zx[n_Integer?Positive,opts___?OptionQ] := Module[{mymode,G, sc},
	mymode = Mode/.Flatten[{opts, Options[Zx]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Range[0,n-1], Mod[#1 #2,n]&,
		GroupoidDescription -> "Integers mod n under multiplication",
		FormatOperator->False,
		GroupoidName ->StringJoin["Zx[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",Zx,mymode,G, {n}, {n,opts},{Null},{Null},sc]]
	
ZxTextual[n_] :=
Print[StringJoin["This groupoid consists of the elements ",
ToString[Range[0,n-1]],
" with the operation of multiplication mod ",ToString[n],". The product of two
elements x and y is given by (x*y) (mod ",ToString[n],"), which means
the remainder of (x*y) upon division by ",ToString[n],". For example,
(7*2) (mod 12) = 2 (mod 12) just as 2 shifts of 7 hours would be
14 hours, or 2 hours more than a full clock cycle.\n"]];

Options[ZxVisual]={DisplayFunction -> $DisplayFunction};
			
ZxVisual[n_, opts___] := 
		Module[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[ZxVisual]}]},
	If[AbstractAlgebra`Core`Private`showVisTextQ[Zx],
Print[StringJoin["Think of the elements as the numbers on a (modified)
clock. One main difference, however, is that we will
view the last element, ", ToString[n],", as being
equivalent to zero. Multiplication of two numbers is
just like 'multiplying' hours on the clock.\n"]]];
	Show[AbstractAlgebra`Core`Private`MakeCircle[n,Range[0,n-1], Blue, 
	AbstractAlgebra`Core`Private`OutStdForm],showopts,
			DisplayFunction -> df]]
	
Zx[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[Zx, many, mode])
		
Zx[many:{_Integer?Positive..}] :=
	Zx[many, Mode -> 
		(Mode/.Options[Zx])]

Zx[n_, opts___] := (Message[Zx::intpm,"Zx["<>ToString[n]<>"]",1];$Failed)

Zx[n_Integer?Positive, I] := GaussianIntegersMultiplicative[n]	
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.4 - U - integers mod n relatively prime to n under multiplication
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[U]={Mode -> Computational};

U[n_Integer?Positive] := U[n] = 
	FormGroupoid[Range[0,n-1]//Select[#,(GCD[#,n]==1)&]&,
    	Mod[#1 #2,n]&,
    	FormatOperator->False,IsAGroup -> True,
    	GroupoidDescription -> "Integers less than n and relatively prime to n, 
under multiplication",
		GroupoidName -> StringJoin["U[",ToString[n],"]"]]

U[n_Integer?Positive,opts___?OptionQ] := 
		Module[{mymode, G = U[n], sc},
	mymode = Mode/.Flatten[{opts, Options[U]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",U,mymode,G,
		{n,Elements[G]}, {n,Elements[G],opts},{Null},{Null},sc]]

UTextual[n_,els_] := 
Print[StringJoin["This groupoid consists of the elements ",
ToString[els],
" with the operation of multiplication mod ",ToString[n],". The product of two
elements x and y is given by (x*y) (mod ",ToString[n],"), which means
the remainder of (x*y) upon division by ",ToString[n],". For example,
(7*2) (mod 12) = 2 (mod 12) just as 2 shifts of 7 hours would be
14 hours, or 2 hours more than a full clock cycle.\n
Note that not all of the elements from 0 to ",ToString[n-1]," are included.
In fact, careful examination will reveal that all the elements
in the list are those which are relatively prime to ",ToString[n],
" (i.e., the GCD between the two elements is 1).\n"]];
	
Options[UVisual]={DisplayFunction -> $DisplayFunction};
			
UVisual[n_,els_,opts___] := Module[{g1,g2,
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[UVisual]}]},
	If[AbstractAlgebra`Core`Private`showVisTextQ[U],
Print[StringJoin["Think of the elements as certain numbers on a (modified) clock.
One main difference, however, is that we will
view the last element, ", ToString[n],", as being
equivalent to zero. Multiplication of two numbers is
just like 'multiplying' hours on the clock.
Note: only the blue dots represent elements of the group.\n"]]];
	g1 = {AbstractAlgebra`Core`Private`modCircle[n, Red, 0.040],
	AbstractAlgebra`Core`Private`LabelingNgon[Range[0, n-1],els, 
		AbstractAlgebra`Core`Private`insideLabelFactor, InputForm]};
	g2 = Map[AbstractAlgebra`Core`Private`modPoint[#,n,Blue, 0.055]&,els];
	Show[{g1,g2},showopts, DisplayFunction -> df,DefaultFont -> 
		AbstractAlgebra`Core`Private`defaultFont, 
		If[$VersionNumber > 2.5, FormatType -> StandardForm,
			Ticks -> Automatic (* dummy statement *)]]
	]
	
U[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[U, many, mode])
		
U[many:{_Integer?Positive..}] :=
	U[many, Mode -> (Mode/.Options[U])]

U[n_, opts___?OptionQ] := (Message[U::intpm,"U["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.7 - D - Dihedral group of order 2n
:[font = input; initialization; preserveAspect; endGroup]
*)
Unprotect[D];

D[n_Integer?Positive, opts___?OptionQ] := Dihedral[n,opts]
(*Options[D]={Mode -> Computational,
	Form -> RotRef,
	RotSym -> Rot,
	RefSym -> Ref,
	NonConstants ->{} (* original option from WRI *)};*)

Protect[D];

Options[Dihedral]={Mode -> Computational,
	Form -> RotRef,
	RotSym -> Rot,
	RefSym -> Ref};

Dihedral[n_Integer?Positive, opts___?OptionQ]:= 
	Module[{G,k, mymode, myform(*,myRotSym,myrefsymb*), sc, F},
	mymode = Mode/.Flatten[{opts, Options[Dihedral]}];
	myform = Form/.Flatten[{opts, Options[Dihedral]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	curDform = myform;
	therotsymb = RotSym/.Flatten[{opts, Options[Dihedral]}];
	therefsymb = RefSym/.Flatten[{opts, Options[Dihedral]}];
	If[myform === Permutations,
		If[n == 1, G = FormGroupoid[{{1,2,3,4},{3,4,1,2}},
				PermutationComposition,
				GroupoidDescription -> "Dihedral group - rotations of a 'Z'", WideElements -> True,
				GroupoidName ->"D[1]"],
			If[n == 2, G = FormGroupoid[{{1,2,3,4},{3,4,1,2},{4,3,2,1},
				{2,1,4,3}},
					PermutationComposition,
					GroupoidDescription -> "Dihedral group - rotations and reflections
of a rectangle", WideElements -> True,
					GroupoidName ->"D[2]"],
			G = GenerateGroupoid[Table[k,{k,1,n}]//{RotateLeft[#],
				Reverse[#]}&, PermutationComposition,SizeLimit->2 n,
				IsAGroup -> True,
				GroupoidDescription -> "Dihedral group - reflections and
rotations of a regular n-gon", WideElements -> True,
				GroupoidName ->StringJoin["D[",ToString[n],"]"]]]]];
	If[myform === RotRef,
		If[n==1,G = FormGroupoid[{1,Ref}, DnOperation[#1,#2,1,therotsymb,therefsymb]&,
				GroupoidName->"D[1]"],
			G = GenerateGroupoid[{therotsymb,therefsymb}, 
				DnOperation[#1,#2,n,therotsymb,therefsymb]&,SizeLimit->2 n];
			F = Elements[G];
			G = FormGroupoid[Join[{F[[1]], F[[Range[3,n+1]]],F[[2]],Drop[F,n+1]}//Flatten], 
				DnOperation[#1,#2,n,therotsymb,therefsymb]&,
				GroupoidDescription -> "Dihedral group - reflections and
				rotations of a regular n-gon", Generators -> GeneratingSet[G],
				IsAGroup -> True, WideElements -> True,
				GroupoidName ->StringJoin["D[",ToString[n],"]"]]]];
	If[n > 3, AbstractAlgebra`Core`Private`WideElementsQ[G] = True];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",Dihedral, 
	mymode, G, {n, opts}, {n},{Null},{Null},sc]]

DihedralGroup[args___] := Dihedral[args]

Dihedral[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; 
	AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[Dihedral, many, mode])
		
Dihedral[many:{_Integer?Positive..}] :=
	Dihedral[many, Mode -> (Mode/.Options[Dihedral])]
	
RulesForDn[n_,R_,L_] := {L**R -> (R^(n-1))**L, 
L**(R^a_)-> (R^(n-a))**L,
(R^a_:1) ** (R^b_:1) -> R^(Mod[a+b,n]), 
R^n -> 1, L**L->1,a_**1->a,1**a_->a};

DnOperation[p_,q_,n_,rot_,ref_] :=
	(p)**(q) //. RulesForDn[n,rot,ref]

DihedralTextual[n_] := (
	Print[StringJoin["One way of thinking of the Dihedral group with index ",
ToString[n]," is to consider the regular ",ToString[n],"-gon. The collection
of symmetries for this figure makes up this group, with
the elements being represented ",
If[curDform =!= RotRef,"by the permutations of the
vertices.", "(symbolically) as the elements generated by
the smallest rotation and any reflection.\n"]]];)

DihedralTextual[2] := (
	Print[StringJoin["One way of thinking of the Dihedral group D[2]
is to consider the rectangle. The collection
of symmetries for this figure makes up this group, with
the elements being represented ",
If[curDform =!= RotRef,"by the permutations of the
vertices.", "(symbolically) as the elements generated by
the smallest rotation and any reflection.\n"]]];)

DihedralTextual[1] := (
	Print[StringJoin["One way of thinking of the Dihedral group
D[1] is to consider the 'Z'. The collection
of symmetries for this figure makes up this group, with
the elements being represented ",
If[curDform =!= RotRef,"by the permutations of the
vertices.", "(symbolically) as the elements generated by
the smallest rotation and any reflection.\n"]]];)

Options[DihedralVisual]={DisplayFunction -> $DisplayFunction};
			
DihedralVisual[n_, opts___] :=
	Module[{showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[DihedralVisual]}], gr},
	gr = DihedralVisualWk[n];
	Show[gr, showopts, DisplayFunction -> df]]

DihedralVisualWk[2] := (
If[AbstractAlgebra`Core`Private`showVisTextQ[D2],
Print[StringJoin["The dihedral group D[2] consists of 
all the symmetries
of the rectangle shown below.
Included
in the group are the 2 reflections (horizontally and vertically
through the center),
as well as the 1 rotation of 180 degrees."]];
If[$VersionNumber < 2.5, Print[" "]];
	If[curDform =!= RotRef,
Print["The elements are considered as permutations of the vertices.\n"],
(* else *) 
Print[StringJoin["The elements are considered as follows: 
The rotation of 180
degrees is called ",ToString[therotsymb]," and any one of the
reflections is called ", ToString[therefsymb],". The elements are then
seen as powers of ",ToString[therotsymb]," and products of these powers
and the reflection ",ToString[therefsymb],"."]];
	]];
(*Show[*)AbstractAlgebra`Core`Private`makeFigure[2,Range[4],"D"](*, 
	DisplayFunction -> Identity]*))

DihedralVisualWk[1] := (
If[AbstractAlgebra`Core`Private`showVisTextQ[D1],
Print[StringJoin["The dihedral group D[1] consists of 
all the symmetries
of the 'Z' shown below.
Included
in the group is the 1 rotation of 180 degrees (and the
identity).\n"]];
	If[curDform =!= RotRef,
Print["The elements are considered as permutations of the vertices."],
(* else *) 
Print[StringJoin["The elements are considered as follows: 
The rotation of 180
degrees is called 1 and the identity is called 0."]];
	]If[$VersionNumber < 2.5, Print[" "]]];
Show[AbstractAlgebra`Core`Private`makeFigure[2,Range[4],"Z"], 
	DisplayFunction -> Identity])

DihedralVisualWk[(n_)?EvenQ] := (
If[AbstractAlgebra`Core`Private`showVisTextQ[DE],
Print[StringJoin["The dihedral group D[",ToString[n],"] consists of 
all the symmetries
of the ", ToString[n],"-sided regular polygon shown below.
Included
in the group are the ",ToString[n]," reflections through the lines
connecting the vertices diametrically opposite and through
the lines connecting the midpoints of opposite sides,
as well as the ",ToString[n]," rotations through angles consisting
of multiples of ",ToString[N[360/n]]," degrees (360 divided by the index)."]];
If[$VersionNumber < 2.5, Print[" "]];
	If[curDform =!= RotRef,
Print["The elements are considered as permutations of the vertices."],
(* else *) 
Print[StringJoin["The elements are considered as follows: The rotation of ",
ToString[N[360/n]]," degrees is called ",ToString[therotsymb]," and any one of the
reflections is called ", ToString[therefsymb],". The elements are then
seen as powers of ",ToString[therotsymb]," and products of these powers
and the reflection ",ToString[therefsymb],"."]];
	]If[$VersionNumber < 2.5, Print[" "]]];
(*Show[*)AbstractAlgebra`Core`Private`makeFigure[n,Range[n]](*,
	DisplayFunction -> Identity]*))/;n>2

DihedralVisualWk[(n_)?OddQ] := (
If[AbstractAlgebra`Core`Private`showVisTextQ[DO],
Print[StringJoin["The dihedral group D[",ToString[n],"] consists of all the symmetries
of the ",ToString[n],"-sided regular polygon shown below. Included
in the group are the ",ToString[n]," reflections through the lines
connecting the vertices to the midpoints of opposite sides,
as well as the ",ToString[n]," rotations through angles consisting
of multiples of ",ToString[N[360/n]]," degrees (360 divided by the index)."]];
If[$VersionNumber < 2.5, Print[" "]];
	If[curDform =!= RotRef,
Print["The elements are considered as permutations of the vertices."],
(* else *) 
Print[StringJoin["The elements are considered as follows: The rotation of ",
ToString[N[360/n]]," degrees is called ",ToString[therotsymb]," and any one of the
reflections is called ", ToString[therefsymb],". The elements are then
seen as powers of ",ToString[therotsymb]," and products of these powers
and the reflection ",ToString[therefsymb],"."]];
	];If[$VersionNumber < 2.5, Print[" "]]];
(*Show[*)AbstractAlgebra`Core`Private`makeFigure[n,Range[n]](*,
	DisplayFunction -> Identity]*))/;n>2

Unprotect[D];
D[many:{_Integer..},opts___?OptionQ] := Dihedral[many,opts]
Protect[D];
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.8 - MaxTaker
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[MaxTaker]={Mode -> Computational};

MaxTaker[n_Integer?Positive,opts___?OptionQ] := 
	Module[{mymode,G,sc},
	mymode = Mode/.Flatten[{opts, Options[MaxTaker]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Table[k,{k,1,n}],Max,"*",
		FormatOperator -> False,
		GroupoidDescription -> "Takes the maximum of two inputs.",
		GroupoidName ->StringJoin["MaxTaker[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",MaxTaker,mymode,G, 
		{Elements[G]}, {Null},{Null},{Null},sc]]

MaxTakerTextual[els_] := (
	Print["This groupoid consists of the elements"];
	Print[els];
	Print[StringJoin["with the operation consisting of taking the
	largest of the two inputs.\n"]];)

MaxTaker[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[MaxTaker, many, mode])
		
MaxTaker[many:{_Integer?Positive..}] :=
	MaxTaker[many, Mode -> (Mode/.Options[MaxTaker])]

MaxTaker[n_] := (Message[MaxTaker::intpm,"MaxTaker["<>ToString[n]<>"]",1];$Failed)

MaxTaker[n_, Mode -> mode_] := 
	(Message[MaxTaker::intpm,"MaxTaker["<>ToString[n]<>"]",1];$Failed)

MaxTaker[m_Integer,n_Integer,opts___?OptionQ] := 
	Module[{mymode,G,sc},
	mymode = Mode/.Flatten[{opts, Options[MaxTaker]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Table[k,{k,m,n}],Max,"*",
		FormatOperator -> False,
		GroupoidDescription -> "Takes the maximum of two inputs.",
		GroupoidName ->StringJoin["MaxTaker[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",MaxTaker,mymode,G, 
		{Elements[G]}, 
		{Null},{Null},{Null},sc]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.9 - MinTaker
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[MinTaker]={Mode -> Computational};

MinTaker[n_Integer?Positive,opts___?OptionQ] := Module[{mymode,G,sc},
	mymode = Mode/.Flatten[{opts, Options[MinTaker]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Table[k,{k,1,n}],Min,"*",
		FormatOperator -> False,
		GroupoidDescription -> "Takes the minimum of two inputs.",
		GroupoidName ->StringJoin["MinTaker[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",MinTaker,mymode,
		G, {Elements[G]}, {Null},{Null},{Null},sc]]

MinTakerTextual[els_] := 
	(Print["This groupoid consists of the elements"];
	Print[els];
	Print[StringJoin["with the operation consisting of taking the
	smallest of the two inputs.\n"]];
	)

MinTaker[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[MinTaker, many, mode])
		
MinTaker[many:{_Integer?Positive..}] :=
	MinTaker[many, Mode -> (Mode/.Options[MinTaker])]

MinTaker[n_] := (Message[MinTaker::intpm,"MinTaker["<>ToString[n]<>"]",1];$Failed)

MinTaker[n_, Mode -> mode_] := 
	(Message[MinTaker::intpm,"MinTaker["<>ToString[n]<>"]",1];$Failed)

MinTaker[m_Integer,n_Integer,opts___?OptionQ] := 
	Module[{mymode,G,sc},
	mymode = Mode/.Flatten[{opts, Options[MinTaker]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Table[k,{k,m,n}],Min,"*",
		FormatOperator -> False,
		GroupoidDescription -> "Takes the minimum of two inputs.",
		GroupoidName ->StringJoin["MinTaker[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",MinTaker,mymode,G, {Elements[G]}, 
		{Null},{Null},{Null},sc]]
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.10 - RootsOfUnity
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[RootsOfUnity]={Mode -> Computational};

RootsOfUnity[n_Integer?Positive,opts___?OptionQ] := Module[{mymode, G,sc},
	mymode = Mode/.Flatten[{opts, Options[RootsOfUnity]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Table[Exp[k(2 Pi I)/n],{k,0,n-1}],
    	Exp[I (Arg[#1] + Arg[#2])]&(*Times*), "*", 
    	FormatOperator -> False, IsAGroup -> True,
    	GroupoidDescription -> "Roots of unity - solutions of x^n == 1",
		GroupoidName ->StringJoin["RootsOfUnity[",ToString[n],"]"]];
	If[n>4,AbstractAlgebra`Core`Private`WideElementsQ[G] = True];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",RootsOfUnity,mymode,G, {n}, 
		{n,Elements[G],opts},{Null},{Null},sc]]

Options[RootsOfUnityVisual]={DisplayFunction -> $DisplayFunction};
			
RootsOfUnityVisual[n_,els_,opts___] := Module[{
		showopts = FilterOptions[Graphics,opts],
		df = DisplayFunction/.Flatten[{opts, Options[RootsOfUnityVisual]}]},
	If[AbstractAlgebra`Core`Private`showVisTextQ[RootsOfUnity], 
		RootsOfUnityTextual[n]];
	Show[RootsOfUnityVisualWork[n,els],
		PlotRange -> {{-1.5,1.5},{-1.5,1.5}},
		Axes -> True, Ticks -> {Table[i,{i,-1,1,.5}],
		Table[i,{i,-1,1,.5}]},showopts, DisplayFunction -> df]]

RootsOfUnityVisualWork[n_,els_] := RootsOfUnityVisualWork[n,els] = 
		Module[{pts,txt},
	pts = Map[{Re[#],Im[#]}&,els]//N;
	txt = Table[Text[ToString[els[[i]]], 1.3 pts[[i]]],{i,n}];
	Graphics[{Circle[{0, 0}, 1],Blue,PointSize[0.055],
		Map[Point,pts],Black,txt}]
	]
	
RootsOfUnityTextual[n_] :=
	Print[StringJoin[
"These are the (complex) numbers that are solutions to the equation x^",
ToString[n]," - 1 = 0. The operation is ordinary (complex) multiplication, which in this
case simplifies to adding the arguments (angles relative to the positive x-axis).\n"]]

RootsOfUnity[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[RootsOfUnity, many, mode])
		
RootsOfUnity[many:{_Integer?Positive..}] :=
	RootsOfUnity[many, Mode -> (Mode/.Options[RootsOfUnity])]

RootsOfUnity[n_, opts___] := 
	(Message[RootsOfUnity::intpm,"RootsOfUnity["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.15 - MeetDivisors
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[MeetDivisors]={Mode -> Computational};

MeetDivisors[n_Integer?Positive,opts___?OptionQ]:= Module[{mymode, G, sc},
	mymode = Mode/.Flatten[{opts, Options[MeetDivisors]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Divisors[n],GCD,"GCD", FormatOperator -> False,
    GroupoidDescription -> "Divisors of n, under GCD",
		GroupoidName ->StringJoin["MeetDiv[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",MeetDivisors,mymode,G, {Null}, 
		{Null},{Null},{Null},sc]]
	
MeetDivisors[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[MeetDivisors, many, mode])
		
MeetDivisors[many:{_Integer?Positive..}] :=
	MeetDivisors[many, Mode -> (Mode/.Options[MeetDivisors])]

MeetDivisors[n_, opts___] := 
	(Message[MeetDivisors::intpm,"MeetDivisors["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.16 - JoinDivisors
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[JoinDivisors]={Mode -> Computational};

JoinDivisors[n_Integer?Positive,opts___?OptionQ]:= Module[{mymode, G, sc},
	mymode = Mode/.Flatten[{opts, Options[JoinDivisors]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Divisors[n],LCM, "LCM", FormatOperator -> False,
    GroupoidDescription -> "Divisors of n, under LCM",
		GroupoidName ->StringJoin["JoinDiv[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",JoinDivisors,mymode,G, {Null}, 
		{Null},{Null},{Null},sc]]

JoinDivisors[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[JoinDivisors, many, mode])
		
JoinDivisors[many:{_Integer?Positive..}] :=
	JoinDivisors[many, Mode -> (Mode/.Options[JoinDivisors])]

JoinDivisors[n_, opts___] := 
	(Message[JoinDivisors::intpm,"JoinDivisors["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.17 - MixedDivisors
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[MixedDivisors]={Mode -> Computational};

MixedDivisors[n_Integer?Positive,opts___?OptionQ]:= Module[{mymode, G, sc},
	mymode = Mode/.Flatten[{opts, Options[MixedDivisors]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Divisors[n],(LCM[#1,#2]/GCD[#1,#2])&,"mixed", 
		FormatOperator -> False,
    	GroupoidDescription -> "Divisors of n, under LCM/GCD",
		GroupoidName ->StringJoin["MixedDiv[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",MixedDivisors,mymode,G, {Null}, 
		{Null},{Null},{Null},sc]]

MixedDivisors[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[MixedDivisors, many, mode])
		
MixedDivisors[many:{_Integer?Positive..}] :=
	MixedDivisors[many, Mode -> (Mode/.Options[MixedDivisors])]

MixedDivisors[n_, opts___] := 
		(Message[MixedDivisors::intpm,"MixedDivisors["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.18 - FirstTaker
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[FirstTaker]={Mode -> Computational};

FirstTaker[n_Integer?Positive,opts___?OptionQ]:= Module[{mymode, G, sc},
	mymode = Mode/.Flatten[{opts, Options[FirstTaker]}];
	sc = FilterOptions[AbstractAlgebra`Core`Private`ShowModes,opts];
	G = FormGroupoid[Range[n],First[{#}]&,"*", FormatOperator -> False,
    GroupoidDescription -> "Integers less than n with the operation of 'first come, first served'- i.e.,
    left operand is the output.",
		GroupoidName ->StringJoin["FirstTaker[",ToString[n],"]"]];
	AbstractAlgebra`Core`Private`ShowModes["AbstractAlgebra`Groupoids",FirstTaker,mymode,G, {Null}, 
		{Null},{Null},{Null},sc]]
	
FirstTaker[many:{_Integer?Positive..}, Mode -> mode_] :=
	(AbstractAlgebra`Core`Private`multipleQ = True; AbstractAlgebra`Core`Private`firstPassQ = True;
	AbstractAlgebra`Core`Private`handleSimpleMultiple[FirstTaker, many, mode])
		
FirstTaker[many:{_Integer?Positive..}] :=
	FirstTaker[many, Mode -> (Mode/.Options[FirstTaker])]

FirstTaker[n_, opts___] := 
	(Message[FirstTaker::intpm,"FirstTaker["<>ToString[n]<>"]",1];$Failed)
(*
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
17.19 - TwistedZn
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
TwistedZ[n_Integer?Positive] := TwistedZ[n] = 
	FormGroupoid[Range[0, n-2], Mod[#1 + #2 + #1 #2, n]&, "*",
		GroupoidName -> "TwistedZ["<>ToString[n]<>"]"]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 17.5 Other groupoids
:[font = input; initialization; preserveAspect; endGroup]
*)
Options[QuaternionGroup] = {Form -> AsMatrices};

QuaternionGroup[opts___?OptionQ] := Module[{as},
	as = Form/.Flatten[{opts, Options[QuaternionGroup]}];
	Switch[as, AsMatrices, QuaternionGroupAsMatrices,
		AsIJK, QuaternionGroupAsIJK,
		AsSymbols, QuaternionGroupAsSymbols]]

QuaternionGroupAsMatrices:= GenerateGroupoid[{{{0,1},{-1,0}},{{0,I},{I,0}}}, 
	Dot,WideElements->True,
	GroupoidName -> "QuaternionGroup"]
	
MessageCount[QuaternionGroup,JJKK] = 0;

QuaternionGroupAsIJK := 
	(If[MessageCount[QuaternionGroup,JJKK]++ < 4, Message[QuaternionGroup::JJKK]];
	FormGroupoid[{1,-1, I, -I, Global`JJ, -Global`JJ, 
		Global`KK, -Global`KK}, 
		QuatGroupOp[#1, #2]&, "*",GroupoidName -> "QuaternionGroup"])
	
QuatGroupRules = {1**x_:>x, (-1)**x_:>-x, x_**1:>x, x_**(-1):>-x,
  (-x_)**(x_):>1, (x_)**(-x_) :> 1, (x_)**(x_) :> -1,
  (-x_)**(y_):>-(x**y), (x_)**(-y_):>-(x**y),
	(Global`KK) ** I -> Global`JJ,
  (Global`JJ) ** (Global`KK) -> I,
	I **(Global`JJ) -> (Global`KK),
	(Global`JJ)** I -> -(Global`KK),
	(Global`KK) ** (Global`JJ) -> -I,
	I ** (Global`KK) -> -(Global`JJ),
	(-I)**x_:>-(I**x), (x_)**(-I):>-(x**I) };

QuatGroupOp[x_,y_] := (x**y) //. QuatGroupRules

QuaternionGroupAsSymbols := 
	FormGroupoidByTable[{"e", "a", "a^2", "a^3", "b", "ba", "ba^2", "ba^3"},
		{{"e", "a", "a^2", "a^3", "b", "ba", "ba^2", "ba^3"},
		 {"a", "a^2", "a^3", "e", "ba^3", "b", "ba", "ba^2"},
		 {"a^2", "a^3", "e", "a", "ba^2", "ba^3", "b", "ba"},
		 {"a^3", "e", "a", "a^2", "ba", "ba^2", "ba^3", "b"},
		 {"b", "ba", "ba^2", "ba^3", "a^2", "a^3", "e", "a"},
		 {"ba", "ba^2", "ba^3", "b", "a", "a^2", "a^3", "e"},
		 {"ba^2", "ba^3", "b", "ba", "e", "a", "a^2", "a^3"},
		 {"ba^3", "b", "ba", "ba^2", "a^3", "e", "a", "a^2"}}, 
		 "*",GroupoidName -> "QuaternionGroup"]

trivProd[a_,a_] := a;

Trivial := Trivial = 
	FormGroupoid[{"u"},"u"&, "*",GroupoidName ->"trivial"];

MessageCount[Klein,warning] = 0;

Klein4 := (If[MessageCount[Klein,warning]++ < 4, Message[Klein4::warning]];
	FormGroupoidByTable[{"e","a","b","c"},
	{{"e","a","b","c"},
    {"a","e","c","b"},
    {"b","c","e","a"},
   	{"c","b","a","e"}},
   	GroupoidName -> "Klein4"])

IntegerUnits:= IntegerUnits = FormGroupoid[{1,-1}, Times,
	GroupoidName -> "IntegerUnits", GroupoidDescription -> "the units in Z",
	FormatOperator -> False];

GaussianUnits:= GaussianUnits = FormGroupoid[{1,-1,I,-I},Times,
	GroupoidName -> "GaussianUnits", GroupoidDescription -> "the units in Z[I]",
	FormatOperator -> False];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 17.6 ESG groupoids - names from Exploring Small Groups
:[font = input; initialization; preserveAspect; endGroup]
*)
ESG[0301] := Z[3];
ESG[0401] := Z[4];
ESG[0402] := Dihedral[2];
ESG[0501] := Z[5];
ESG[0601] := Z[6];
ESG[0602] := S[3];
ESG[0701] := Z[7];
ESG[0801] := Z[8];
ESG[0802] := DirectSum[Z[4],Z[2]];
ESG[0803] := DirectSum[Z[2],Z[2],Z[2]];
ESG[0804] := Dihedral[4];
ESG[0805] := QuaternionGroup[Form -> AsIJK];
ESG[0901] := Z[9];
ESG[0902] := DirectSum[Z[3],Z[3]];
ESG[1001] := Z[10];
ESG[1002] := Dihedral[5];
ESG[1101] := Z[11];
ESG[1201] := Z[12];
ESG[1202] := DirectSum[Z[6],Z[2]];
ESG[1203] := Dihedral[6];
ESG[1204] := A[4];
(* ESG[1205] := Q6 Dicyclic *)
ESG[1301] := Z[13];
ESG[1401] := Z[14];
ESG[1402] := Dihedral[7];
ESG[1501] := Z[15];
ESG[1601] := Z[16];
ESG[1602] := DirectSum[Z[8],Z[2]];
ESG[1603] := DirectSum[Z[4],Z[4]];
ESG[1604] := DirectSum[Z[4],Z[2],Z[2]];
ESG[1605] := DirectSum[Z[2],Z[2],Z[2],Z[2]];
ESG[1606] := DirectSum[D[4],Z[2]];
ESG[1607] := DirectSum[QuaternionGroup[Form -> AsIJK],Z[2]];
(*ESG[1608] := Z[16];*)
(*ESG[1609] := Z[16];*)
(*ESG[1610] := Z[16];*)
(*ESG[1611] := Z[16];*)
ESG[1612] := Dihedral[8];
(*ESG[1613] := Z[16];*)
(*ESG[1614] := Z[16];*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
 99. Wrap up AbstractAlgebra`Groupoids
:[font = input; initialization; preserveAspect]
*)
End[];

EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
