(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = subsubtitle; inactive; preserveAspect; rightWrapOffset = 497]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Al Hibbard and Ken Levasseur
;[s]
3:0,0;44,1;73,2;122,-1;
3:1,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; Cclosed; preserveAspect; rightWrapOffset = 497; startGroup]
AbstractAlgebra`Zd` package
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Prelims
:[font = input; initialization; preserveAspect; endGroup]
*)
(* :Title:  AbstractAlgebra`Zd *)

(* :Context: AbstractAlgebra`Zd` *)

(* :Authors: 	Allen C. Hibbard
							hibbarda@central.edu
							http://www.central.edu/homepages/hibbarda/hibbard.html
							 
			 				Kenneth M. Levasseur
			 				Levasseuk@woods.uml.edu
			 				http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)

(* :Package Version: 1.0.0 *)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Startup AbstractAlgebra`Zd
:[font = input; initialization; preserveAspect]
*)
incomingStructure = DefaultStructure;
(*
:[font = input; initialization; preserveAspect; endGroup]
*)
BeginPackage["AbstractAlgebra`Zd`",{"AbstractAlgebra`Core`", 
 "Graphics`Graphics`", "Graphics`ImplicitPlot`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Usage statements
:[font = input; initialization; preserveAspect; endGroup]
*)
Combine::usage = "Combine is an option name for both IntegerDivisors and
ZdDivisors. Its default value is False, which means the divisors are not
grouped in any fashion. Other values are Products, Associates or Negations.";

NonTrivialOnly::usage = "NonTrivialOnly is an option name for both IntegerDivisors and
ZdDivisors. Its default value is False, which means that trivial divisors ( 1 and
 n) are included, but excluded if set to True.";

Products::usage = "Products is a value for the Combine option of IntegerDivisors
and ZdDivisors. With this value, the divisors of n are grouped in pairs {a, b}
such that a*b = n.";

Associates::usage = "Products is a value for the Combine option of IntegerDivisors
and ZdDivisors. With this value, the divisors of n are grouped in pairs {a, b}
such that a and b are associates.";

Negations::usage = "Products is a value for the Combine option of IntegerDivisors
and ZdDivisors. With this value, the divisors of n are grouped in pairs {a, b}
such that a and b are negations.";

DivisorsComplete::usage = "DivisorsComplete is an option for IntegerDivisors
and ZdDivisors. Its default value is False. With this, only one divisor from each
class of associates is given. For integers, this means return the positive divisors.
For Gaussian integers (d = -1), return those in the first quadrant. In all other
cases, include the one that is in the right half-plane (or first quadrant for those on
the imaginary axis) when the number a + b d is considered the ordered pair (a, b).
With the value True, all divisors are included.";

IntegerDivisors::usage = "IntegerDivisors[n, opts] returns the divisors of the integer
n, just as Divisors[n] does. The options are Combine, NonTrivialOnly and DivisorsComplete.
See these for more details.";

DividesQ::usage = "DividesQ[r, s] returns True if the integer s divided by 
the integer r is an integer, and
False otherwise. DividesQ[r, s, Radical -> d] works similarly in Z[Sqrt[d]],
returning True if r | s over this ring, and False otherwise.";

Radical::usage = "Radical is an option for DividesQ that specifies the value
of d when division takes place in Z[Sqrt[d]]. The value for this option
needs to be a square-free integer.";

ValuesHavingGivenNorm::usage = "ValuesHavingGivenNorm[d, nrm], for negative d,
returns the list (possibly empty) of values in Z[Sqrt[d]] that have the norm
value of nrm. For positive d, ValuesHavingGivenNorm[d, nrm, iter] returns
a (partial) list of values having the given norm after iter iterations of
an algorithm to search along the relevant hyperbola. The value for iter defaults
to 50 if omitted. For positive d, the list will be incomplete.";

ZdAssociatesQ::usage = "ZdAssociatesQ[d, a, b] returns True if a and b are
associates over Z[d], and False otherwise.";

ZdCombineAssociates::usage = "ZdCombineAssociates[d, lst] takes the list of elements
lst from Z[Sqrt[d]] and returns a new list of lists, with each new list containing
those elements in lst that are associates with each other.";

ZdConjugate::usage = "ZdConjugate[a + b Sqrt[d]] returns a - b Sqrt[d],
the conjugate in Z[Sqrt[d]].";

ZdDivide::usage = "ZdDivide[x, y] returns the quotient x/y in the form r + s d
when x and y are both in Z[d].";

ZdDividesQ::usage = "ZdDividesQ[d, a, b] is equivalent to
DividesQ[a, b, Radical -> d].";

ZdDivisors::usage = "ZdDivisors[d, x, (opts)], when d is negative, returns all of
the divisors of the number x in Z[Sqrt[d]].
When d is positive, ZdDivisors[d, x, max] returns all divisors of x in Z[Sqrt[d]]
whose norm is less than or equal to the norm of the integer max.
Available options are Combine, NonTrivialOnly and DivisorsComplete.
See these for more details.";

ZdIrreducibleQ::usage = "ZdIrreducibleQ[d, x], for negative d, returns True if x
is an irreducible in Z[Sqrt[d]], and False otherwise.";

ZdNorm::usage = "ZdNorm[x] returns the norm of x as an element in Z[Sqrt[d]]
for some d, which is the value |a^2 - d b^2| when x = a + b d.";

ZdPossibleNorms::usage = "ZdPossibleNorms[d, max], for negative d only,
returns all the norms that can
occur in Z[Sqrt[d]] that are less than or equal to max. This function has
a Visual mode available.";

ZdPossibleNormQ::usage = "ZdPossibleNormQ[d, nrm], for negative d only,
returns True if the value
nrm can occur (is possible) in Z[Sqrt[d]], and False otherwise.";

ZdQ::usage = "ZdQ[x] returns True if x can be viewed as an element in Z[Sqrt[d]]
for some d, and False otherwise.";

ZdUnitQ::usage = If[$VersionNumber < 2.8,
	"ZdUnitQ[d, x] returns True if x is a unit in Z[d], and
False otherwise.", "ZdUnitQ[d, x] returns True if x is a unit in
Z[Sqrt[d]], and
False otherwise."];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Error messages
:[font = input; initialization; preserveAspect; endGroup]
*)
ZdNorm::sqfree = "The number `1` is not square-free, as required for this
function.";

ZdNorm::one = "The number 1 cannot be used as a value for the parameter d
for this function.";

ZdNorm::int = "The number `1` cannot be used as a value for the parameter d
for this function, since it needs to be an integer.";
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Begin private
:[font = input; initialization; preserveAspect; endGroup]
*)
Begin["`Private`"];
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Functions
:[font = input; initialization; preserveAspect; endGroup]
*)
ZdConjugate[c_Complex] := Conjugate[c]
ZdConjugate[c_Integer] := c
ZdConjugate[(a_:0) + (b_:1) Sqrt[c_]] := a - b Sqrt[c]

ZdDivide[a_, b_] := Expand[Expand[a * ZdConjugate[b]]/Expand[b * ZdConjugate[b]]]

ZdDividesQ[d_, a_, b_] := If[ZdOKdQ[d], ZdQ[ZdDivide[b,a]], $Failed]
(* this assumes that both a and b are of the form x + y Sqrt[d] *)

DividesQ[a_Integer, b_Integer] := IntegerQ[b/a]

DividesQ[a_?ZdQ, b_?ZdQ, Radical -> d_] := ZdDividesQ[d, a, b]

ZdOKdQ[d_] := If[Head[d]=!=Integer, Message[ZdNorm::int,d]; False,
	If[d==1, Message[ZdNorm::one]; False,
		If[squareFreeQ[d], True, Message[ZdNorm::sqfree, d]; False]]]

ZdNorm[y_] := Module[{a, b, d, a1, b1, d1, x = Expand[y]},
	{d, a, b} = Switch[Head[x],
		Integer, {1,x,0},
		Complex, {-1, Re[x], Im[x]},
		Times, x /. Times[b1_, Power[d1_, Rational[1,2]]] :> {d1, 0, b1},
		Plus, x /. {Plus[a1_, Times[b1_, Power[d1_, Rational[1,2]]]] :> {d1, a1, b1},
			Plus[a1_, Power[d1_, Rational[1,2]]] :> {d1, a1, 1}},
		Power, x /. Power[d1_, Rational[1,2]] :> {d1, 0, 1}];
	If[d < 0, a^2 + Abs[d] b^2, Abs[a^2 - d b^2]]]

ZdQ[x_] := IntegerQ[x] ||
	(Head[x]===Complex && Head[Re[x]]===Integer && Head[Im[x]]===Integer) ||
	(Head[x]===Power && IntegerQ[x[[1]]] && x[[2]] === Rational[1,2]) || 
	(Head[x]===Times && Head[x[[1]]]===Integer && Head[x[[2,1]]]===Integer &&
		x[[2,2]] === Rational[1,2]) ||
	(Head[x]===Times && Head[x[[1]]]===Complex && Head[Im[x[[1]]]]===Integer &&
		Head[x[[2,1]]]===Integer && x[[2,2]] === Rational[1,2]) ||
	(Head[x]===Plus && Head[x[[1]]]===Integer && Head[x[[2]]]===Power &&
		Head[x[[2,1]]]===Integer && x[[2,2]] === Rational[1,2]) ||
	(Head[x]===Plus && Head[x[[1]]]===Integer && Head[x[[2]]]===Times &&
		Head[x[[2,1]]]===Complex && Head[Im[x[[2,1]]]]===Integer &&
		Head[x[[2,2]]]===Power && Head[x[[2,2,1]]]===Integer && 
		x[[2,2,2]] === Rational[1,2]) ||
	(Head[x]===Plus && Head[x[[1]]]===Integer && Head[x[[2]]]===Times &&
		Head[x[[2,1]]]===Integer && 
		Head[x[[2,2]]]===Power && Head[x[[2,2,1]]]===Integer && 
		x[[2,2,2]] === Rational[1,2])
			
ZdToPoint[ptlst_List] := ptlst /. {Plus[a_Integer:0, Times[Complex[0,b_Integer:1],
	Power[5, Rational[1,2]]]] -> {a , b}, a_Integer -> {a,0},
	Complex[a_, b_] -> {a,b}}
(* convert a list of numbers in Zd to points in the plane 
<{{1,0}, {0,Sqrt[d]}}> *)
	
ZdDivisorCandidates[d_Integer?Negative, num_] := ZdDivisorCandidates[d, num] =
	If[ZdOKdQ[d],
		Module[{nrm = ZdNorm[num], div},
			div = Divisors[nrm];
			Flatten[Map[ValuesHavingGivenNorm[d, #]&, div]]//Union], $Failed]
(* Given d and a number num, this returns candidates for divisors of that number *)

ZdDivisorCandidates[d_Integer?Positive, num_, max_Integer:50] := 
	If[ZdOKdQ[d],
		Module[{nrm = ZdNorm[num], div},
			div = Divisors[nrm];
			Flatten[Map[ValuesHavingGivenNorm[d, #, max]&, div]]//Union], $Failed]
(* Given d and a number num, this returns candidates for divisors of that number *)
	
PositiveZdQ[d_, num_] := 
	If[IntegerQ[num], Positive[num],
		If[d == -1, N[Re[num]]>0 && N[Im[num]] >= 0,
			If[d < -1, If[N[Re[num]]==0, N[Im[num]] > 0, N[Re[num]]>0],
				Positive[First[num /. a_ + b_ Sqrt[d] :> {a, b}]]]]]
			
zdDivisors[-1, num_] := zdDivisors[-1, num] = 
	Apply[Times,CartesianProduct[Divisors[num, 
	GaussianIntegers -> True],{1,-1,I,-I}],{1}]//Sort

zdDivisors[d_?Negative, num_] := zdDivisors[d, num] = If[ZdOKdQ[d], Module[{lst},
	Off[Power::infy, Infinity::indet];
	lst = Select[Map[{#,ZdDividesQ[d, #, num]}&, 
		ZdDivisorCandidates[d, num]],#[[2]]===True&];
	lst = Transpose[lst]//First;
	Off[Power::infy, Infinity::indet];
	lst], $Failed]

CombineByNegations[lst_List] := CombineByNegations[lst] = 
Module[{temp, comb,next, done = False,
	neg, remaining, len},
temp = Sort[lst];
comb = {};
next = First[temp];
remaining = Complement[temp, {next}];
While[Not[done],
	neg = Select[remaining, # == - next &]//Flatten;
	AppendTo[comb, Flatten[{next, neg}]//Sort];
	remaining = Complement[remaining, Flatten[{next, neg}]];
	done = (len = Length[remaining]) < 2;
	If[done,
		If[len==1, AppendTo[comb, remaining]],
		next = First[remaining]];
	];
comb]

CombineByAsociates[d_, mylst_List] := CombineByAsociates[d, mylst] =
		Module[{nlst = {}, work, done = False, assq, add,lst = mylst},
	While[Not[done],
		work = First[lst];
		assq = Map[ZdAssociatesQ[d, #, work]&, Complement[lst, {work}]];
		add = If[Or@@assq === False, {work}, 
			{work,Complement[lst, {work}][[Flatten[Position[assq, 
			True]]]]}//Flatten];
		AppendTo[nlst, add//Sort];
		lst = Complement[lst, add];
		done = lst === {}];
	nlst]
	
CombineByProducts[inlst_List, num_] := CombineByProducts[inlst, num] = 
Module[{nlst = {}, work, done = False, 
	assq, add, temp, lst = inlst},
	While[Not[done],
		work = First[lst];
		assq = Map[Expand[# * work] === num&, temp=Complement[lst,{work}]];
		add = If[Or@@assq === False, If[Expand[work * work]===num, 
			{work, work}, {work}], 
			{work,temp[[First[Flatten[Position[assq, 
			True]]]]]}];
		AppendTo[nlst, add//Sort];
		lst = Complement[lst, add];
		done = lst === {}];
	nlst]

Options[ZdDivisors] = {DivisorsComplete -> False, NonTrivialOnly -> False,
	Combine -> False};

ZdDivisors[d_?Negative, num_, opts___?OptionQ] :=  If[ZdOKdQ[d], 
	Module[{lst,
		dl=DivisorsComplete/.Flatten[{opts, Options[ZdDivisors]}],
		nto=NonTrivialOnly/.Flatten[{opts, Options[ZdDivisors]}],
		comb=Combine/.Flatten[{opts, Options[ZdDivisors]}]},
	lst = zdDivisors[d, num];
	If[nto, lst = Complement[lst, If[d == -1, {1, -1,I,-I, num, -num, num I, -num I},
		{1, -1, num, -num}]]];
	If[dl === False, lst = Select[lst, PositiveZdQ[d, #]&]];
	If[lst =!= {},
		Switch[comb,
			False, lst,
			Products, CombineByProducts[lst, num],
			Associates, CombineByAsociates[d, lst],
			Negations, CombineByNegations[lst]],
		{}]], $Failed]

zdDivisors[d_?Positive, num_, max_Integer?Positive] := zdDivisors[d, num, max] =
	If[ZdOKdQ[d], Module[{lst},
	Off[Power::infy, Infinity::indet];
	lst = Select[Map[{#,ZdDividesQ[d, #, num]}&, 
		ZdDivisorCandidates[d, num, max]],#[[2]]===True&];
	lst = Transpose[lst]//First;
	Off[Power::infy, Infinity::indet];
	lst], $Failed]

ZdDivisors[d_?Positive, num_, max_Integer?Positive, opts___?OptionQ] :=  
If[ZdOKdQ[d], 
	Module[{lst,
		dl=DivisorsComplete/.Flatten[{opts, Options[ZdDivisors]}],
		nto=NonTrivialOnly/.Flatten[{opts, Options[ZdDivisors]}],
		comb=Combine/.Flatten[{opts, Options[ZdDivisors]}]},
	lst = zdDivisors[d, num, max];
	If[nto, lst = Complement[lst, {1, -1, num, -num}]];
	If[dl === False, lst = Select[lst, PositiveZdQ[d, #]&]];
	lst = Switch[comb,
		False, lst,
		Products, CombineByProducts[lst, num],
		Associates, CombineByAsociates[d, lst],
		Negations, CombineByNegations[lst]]], $Failed]

ZdUnitQ[d_?ZdOKdQ, x_] := ZdNorm[x]==1

ZdUnits[-1] := {1, -1, I, -I}

ZdUnits[d_?ZdOKdQ] := If[d < 0, {-1, 1}]

ZdAssociatesQ[d_?ZdOKdQ, a_, b_] := Module[{q},
	q = ZdDivide[a, b];
	If[ZdQ[q],
		ZdUnitQ[d, q],
		q = ZdDivide[b, a];
		If[ZdQ[q],
			ZdUnitQ[d, q],
			False]]]

squareFreeQ[d_]:= 
      If[d < 10^5, Return[MoebiusMu[d] != 0], Print["TOO LARGE under radical"]];

NonTrivialDivisors[n_Integer?Positive] := Complement[Divisors[n], {1,n}]

ZdIrreducibleQ[d_?Negative, x_] := If[ZdOKdQ[d], Module[{nrm,nd},
	nrm = ZdNorm[x];
	If[PrimeQ[nrm], True,
		nd = NonTrivialDivisors[nrm];
		And@@Map[Not[ZdPossibleNormQ[d, #]]&, nd]]], $Failed]
	
ZdCombineAssociates[d_?ZdOKdQ, mylst_List] := CombineByAsociates[d, mylst]

Options[IntegerDivisors] = Flatten[{Options[Divisors],
	DivisorsComplete -> False, 
	NonTrivialOnly -> False, Combine -> False}];

IntegerDivisors[num_Integer, opts___?OptionQ] := 
	Module[{lst,
		dl=DivisorsComplete/.Flatten[{opts, Options[IntegerDivisors]}],
		nto=NonTrivialOnly/.Flatten[{opts, Options[IntegerDivisors]}],
		comb=Combine/.Flatten[{opts, Options[IntegerDivisors]}]},
	lst = Divisors[num];
	If[nto, lst = Complement[lst, {1, -1, num, -num}]];
	If[dl === True, lst = Join[lst, -lst]//Union];
	lst = Switch[comb,
		False, lst,
		Products, CombineByProducts[lst, num],
		Associates, CombineByNegations[lst],
		Negations, CombineByNegations[lst]]]

FirstQuadInterior[d_Integer?Negative, nrm_] := Module[{xmax, ymax, pts, a, b},
	xmax = Floor[Sqrt[nrm]//N];
	ymax = Floor[Sqrt[nrm/Abs[d]]//N];
	pts = Flatten[Table[{a,b}, {a,0,xmax}, {b, 0, ymax}],1];
	Select[pts, ZdNorm[PtToNum[d, #]] <= nrm &]]

PtsToNorm[d_Integer?Negative, pts_List] :=
	Map[First[#]^2 - d Last[#]^2 &, pts]
	
PtsToNorm[d_Integer?Positive, pts_List] :=
	Map[Abs[First[#]^2 - d Last[#]^2] &, pts]
	
PtToNum[d_Integer, pt_List] := First[pt] + Last[pt] Sqrt[d]

AllInterior[d_Integer?Negative, nrm_] := Module[{q1, q2, a, b},
	q1 = FirstQuadInterior[d, nrm];
	q2 = q1 /. {{a_Integer, b_Integer} :> {-a, b}};
	Union[q1, q2, Join[q1, q2] /. {a_Integer, b_Integer} :> {a, -b}]]
	
ZdPossibleNormsVisual[d_Integer?Negative, nrm_] := Module[{pts, nrms, nrmlist,
		n, rules, gpts, gr1, gr2, xmax, a, b},
	pts = AllInterior[d, nrm];
	nrms = PtsToNorm[d, pts];
	nrmlist = Union[nrms];
	n = Length[nrmlist];
	xmax = Floor[Sqrt[nrm]//N] + 1;
	rules = Table[Rule[nrmlist[[i]], Hue[i/n]], {i, n}];
	gpts = Transpose[{nrms /. rules, Map[Point, pts, {1}]}];
	gr1 = Show[Graphics[{PointSize[0.015], gpts}], DisplayFunction -> Identity];
	gr2 = ImplicitPlot[a^2 - d b^2 == nrm, {a, -xmax, xmax},
		DisplayFunction -> Identity];
	Show[{gr1, gr2}, DisplayFunction -> $DisplayFunction, 
		Axes -> True, AspectRatio -> Automatic, Frame -> True];
	nrmlist]
	
ZdPossibleNorms[d_Integer?Negative, nrm_] := 
	PtsToNorm[d, AllInterior[d, nrm]]//Union
		
ZdPossibleNorms[d_Integer?Negative, nrm_, Mode -> Visual] :=
	ZdPossibleNormsVisual[d, nrm]
				
ZdPossibleNormQ[d_Integer?Negative, x_] := If[ZdOKdQ[d], 
	MemberQ[ZdPossibleNorms[d, x],x], $Failed]
		
InsideEllipseQ[d_Integer?Negative, nrm_, pt_List] :=
	First[pt]^2 - d Last[pt]^2 <= nrm

GetNextPoints[d_Integer?Negative, nrm_, last_List] :=
	Module[{a = First[last], b = Last[last], x, y, in = $Failed, 
		out = $Failed, done = True},
x = a - 1;
y = b + 1;
If[InsideEllipseQ[d, nrm, {x,y}], 
	in = {x,y};
	out = {x+1, y},
	done = False;
	While[Not[done],
		If[InsideEllipseQ[d, nrm, {--x,y}],
			done = True;
			in = {x, y};
			out = {x+1, y},
			done = False || x == 0]]];
{in, out}]

NearbyIntegerEllipsePoints[d_Integer?Negative, nrm_] := Module[{pts, pt, x, 
		done = False, in , out, maxy, a, b, inn, outt},
	x = Floor[N[Sqrt[nrm]]];
	pt = {x, 0};
	If[InsideEllipseQ[d, nrm, pt], pts = {pt, {x+1, 0}}, pts = {pt}];
	in = pt;
	maxy = Floor[Sqrt[nrm/Abs[d]]//N];
	done = maxy == 0;
	While[Not[done],
		{inn, outt} = GetNextPoints[d, nrm, in];
		If[inn === $Failed, done = True,
			{in, out} = {inn, outt};
			pts = Join[pts, {in, out}];
			done = maxy == Last[in]]];
	x = First[in];
	pts = Join[pts, Flatten[Table[{{i, maxy}, {i, maxy+1}}, 
		{i, x-1, 0, -1}],1]];
	pts = pts//Union;
	pts = Join[pts, pts/.{a_, b_} :> {-a, b}]//Union;
	Join[pts, pts /. {a_, b_} :> {a, -b}]//Union]

InsideHorHyperbolaQ[d_Integer?Positive, nrm_?Positive, pt_List] :=
	First[pt]^2 - d Last[pt]^2 > nrm
	
InsideVerHyperbolaQ[d_Integer?Positive, nrm_?Negative, pt_List] :=
	First[pt]^2 - d Last[pt]^2 < nrm

OnHyperbolaQ[d_Integer?Positive, nrm_, pt_List] :=
	Abs[First[pt]^2 - d Last[pt]^2] == Abs[nrm]
		
OnNextRowQ[d_Integer?Positive, nrm_Integer?Positive, pt_List] := 
		Module[{a, b, done = False},
	{a, b} = pt;
	b++;
	While[Not[done],
		a++;
		done = InsideHorHyperbolaQ[d, nrm, {a,b}]];
	a--;
	{{a,b}, OnHyperbolaQ[d, nrm, {a,b}]}]

OnNextColumnQ[d_Integer?Positive, nrm_Integer?Negative, pt_List] := 
		Module[{a, b, done = False},
	{a, b} = pt;
	a++;
	While[Not[done],
		b++;
		done = InsideVerHyperbolaQ[d, nrm, {a,b}]];
	b--;
	{{a,b}, OnHyperbolaQ[d, nrm, {a,b}]}]
	
IntegerHyperbolaPoints[d_Integer?Positive, nrm_Integer?Negative, max_Integer:50] := 
	Module[{pts, pt, x, y, done = False, nxtpt, onQ, a, b, it = 0},
	y = Floor[N[Sqrt[Abs[nrm]]]];
	x = 0;
	pt = {x, y};
	it++;
	If[OnHyperbolaQ[d, nrm, pt], pts = {pt}, pts = {}];
	While[Not[done],
		{nxtpt, onQ} = OnNextColumnQ[d, nrm, pt];
		If[onQ, AppendTo[pts, nxtpt]];
		pt = nxtpt;
		done = it++ > max];
	pts = Join[pts, pts/.{a_Integer, b_Integer} :> {-a, b}]//Union;
	Join[pts, pts /. {a_Integer, b_Integer} :> {a, -b}]//Union]
	
IntegerHyperbolaPoints[d_Integer?Positive, nrm_?Positive, max_Integer:50] := 
	Module[{pts, pt, x, y, done = False, nxtpt, onQ, a, b, it = 0},
	x = Floor[N[Sqrt[nrm]]];
	y = 0;
	pt = {x, y};
	it++;
	If[OnHyperbolaQ[d, nrm, pt], pts = {pt}, pts = {}];
	While[Not[done],
		{nxtpt, onQ} = OnNextRowQ[d, nrm, pt];
		If[onQ, AppendTo[pts, nxtpt]];
		pt = nxtpt;
		done = it++ > max];
	pts = Join[pts, pts/.{a_Integer, b_Integer} :> {-a, b}]//Union;
	Join[pts, pts /. {a_Integer, b_Integer} :> {a, -b}]//Union]
	
AllHyperbolaPoints[d_Integer?Positive, nrm_Integer, max_Integer:50] :=
	Union[IntegerHyperbolaPoints[d, nrm, max],IntegerHyperbolaPoints[d, -nrm, max]]
	
PointsWithGivenNorm[d_Integer?Negative, nrm_] := 
	Select[NearbyIntegerEllipsePoints[d, nrm], PtsToNorm[d, {#}] == {nrm}&]

PointsWithGivenNorm[d_Integer?Positive, nrm_, max_Integer:50] := 
	AllHyperbolaPoints[d, nrm, max]
	
QuadOneQ[pt_List] := First[pt] >= 0 && Last[pt] >= 0

QuadFourQ[pt_List] := First[pt] >= 0 && Last[pt] <= 0

RightHalfQ[pt_List] := QuadOneQ[pt] || QuadFourQ[pt]
	
ValuesHavingGivenNorm[d_Integer?Negative, nrm_] :=
	Map[PtToNum[d,#]&, PointsWithGivenNorm[d, nrm]]

ValuesHavingGivenNorm[d_Integer?Positive, nrm_, max_Integer:50] :=
	Map[PtToNum[d,#]&, PointsWithGivenNorm[d, nrm, max]]

ValuesHavingGivenNorm[d_Integer?Negative, nrm_, SkipNegations -> True] :=
	Map[PtToNum[d,#]&, Select[PointsWithGivenNorm[d, nrm], RightHalfQ]]
	
RandomElement[d_Integer, max_] :=
	Random[Integer, {-max, max}] + Random[Integer, {-max, max}] Sqrt[d]
	
RandomElements[d_Integer, max_, n_Integer?Positive] := 
	Table[RandomElement[d, max], {n}]
(*
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
Wrapup AbstractAlgebra`Zd
:[font = input; initialization; preserveAspect]
*)
End[];
EndPackage[];
(*
:[font = input; initialization; preserveAspect; endGroup; endGroup]
*)
DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];
(*
^*)
