(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 5. Subversively grouping our elements
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should be familiar with the definition of a subgroup of a group.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
What constitutes a subgroup? What elements are necessary before a set can be considered a subgroup? What do the subgroups of Z[n] look like? What about the subgroups of U[n)]? What is the probability that a randomly chosen subset of elements from Z[n] will actually be a subgroup? What elements of Z[n] will guarantee closure to the full group? These are some of the questions that will be explored in this lab.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.3 When do we have a subgroup?
:[font = text; inactive; preserveAspect; nohscroll; ]
In Lab 3, we considered when a set with an operation on the set forms a group. In this lab, we consider when a subset of a group is a group in its own right (when using the operation from the parent set). 

First, let's consider a random group Z[n] for n in [6, 20]. To define this group, we need to first read in the Mathematica package that defines Z[n] and the other functions that we will be using.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 20}]
G = Z[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we pick a random integer m, less than n, and then choose this many elements from G and put them in a set that we call H.
:[font = input; preserveAspect; nowordwrap; ]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}]
H = RandomElements[G, m, Replacement -> False]
:[font = text; inactive; preserveAspect; nohscroll; ]
The question we would like to pursue first is whether this set H forms a subgroup of G, and if not, how can we make one with it.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. In this case, is H a subgroup of G? Justify your answer. (Indicate the group G and subset H that were chosen.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now, use the command below to confirm your answer to the previous question.
:[font = input; preserveAspect; nowordwrap; ]
SubgroupQ[H, G]
:[font = text; inactive; preserveAspect; nohscroll; ]
Simply knowing whether it is true or false if H is a subgroup of G is of limited value. We would also like to know how to make H become a subgroup (by adding certain elements, if necessary). Let's look at a Cayley table where we focus on the elements of H.
:[font = input; preserveAspect; nowordwrap; ]
SubgroupQ[H, G, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that the elements colored red are in G, but not in H.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. The presence of red elements (if any) indicates that the set H does not satisfy what property relative to the operation in G?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
What would happen if we modified H to include some (or all) of the elements that were sums of elements in H, but not already in H (namely, the red elements)? In the variable labeled ElementsToAdd, add the elements (between {}) you would like to join to H to see if you can make H a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
ElementsToAdd = {}; (* <- add elements here *)
H = Join[H,ElementsToAdd]//Union
SubgroupQ[H, G, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. By deleting the previous elements in the list ElementsToAdd and replacing them with new ones, keep modifying the above code until you have enlarged H to become a subgroup. You will know that you are done if there are no longer any red elements. (It may be the case that you have enlarged H to become G itself.) What is your subgroup H? (Also, what was your group G?)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try this again:
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 20}];
G = Z[n]
:[font = input; preserveAspect; nowordwrap; ]
m = Random[Integer,{1, Floor[N[Sqrt[n]]]}]
H = RandomElements[G, m, Replacement -> False]
SubgroupQ[H, G, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. As before, keep modifying the code below until you have enlarged H to become a subgroup. What is your subgroup H? (Also, what was your group G and the original H?)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
ElementsToAdd = {}; (* <- add elements here *)
H = Join[H,ElementsToAdd]//Union
SubgroupQ[H, G, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
Once you feel comfortable knowing how to enlarge H to make it a subgroup, we can ask Mathematica to do that part and you can focus on related issues. We call the new subgroup of G formed from the set H the closure of H in G and we can use the Closure command.

Let's try this with a new group.
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 20}];
G = Z[n]
:[font = input; preserveAspect; nowordwrap; ]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}]
H = RandomElements[G, m, Replacement -> False]
:[font = text; inactive; preserveAspect; nohscroll; ]
If all we want is to determine the closure of H, we use the following.
:[font = input; preserveAspect; nowordwrap; ]
Closure[G, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
(Apply SortGroupoid to this result if you want to see the elements ordered.) If we ever want to know what else we can do with a function, it is often useful to ask for information about the function:
:[font = input; preserveAspect; nowordwrap; ]
?Closure
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try a few of these variations.
:[font = input; preserveAspect; nowordwrap; ]
Closure[G, H, ReportIterations -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this returns the closure of H first, followed by the number of iterations, and the results of each iteration.

Let's consider another option:
:[font = input; preserveAspect; nowordwrap; ]
Closure[G, H, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
This simply shows the same information visually. These graphics can now be animated, if desired. (To do so, double-click on one of the graphics and adjust the motion with the arrow keys.)

If one does not want to see all the graphics at once, one can try the following.
:[font = input; preserveAspect; nowordwrap; ]
Closure[G, H, Mode -> Visual, Staged -> True];
:[font = text; inactive; preserveAspect; nohscroll; ]
To see the next stage, evaluate the following.
:[font = input; preserveAspect; nowordwrap; ]
NextStage[Closure];
:[font = text; inactive; preserveAspect; nohscroll; ]
Or to see a previous stage, try
:[font = input; preserveAspect; nowordwrap; ]
PreviousStage[Closure];
:[font = text; inactive; preserveAspect; nohscroll; ]
Either of these last two commands can be repeatedly cycled.

Test yourself one more time; evaluate the following.
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 20}]
G = Z[n]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}]
:[font = input; preserveAspect; nowordwrap; ]
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Mode -> Visual, Staged -> True];
:[font = text; inactive; preserveAspect; nohscroll; ]
You should know which elements need to be added. Now predict which elements will be colored red, if any, in the next iteration. When you think you know, evaluate the following. Keep doing this until you have found the closure of H.
:[font = input; preserveAspect; nowordwrap; ]
NextStage[Closure];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. You may have noticed that sometimes the closure becomes the whole group. There are many questions related to this to think about, some of which we consider in this lab. Here is one with which to start. If we let H(n) be the size of the closure of H at the nth iteration (so H(1) = |H|), how big does H(n) have to become before we can be certain that the closure of H will be all of G? You may wish to evaluate the cell below a number of times to gain some insights.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 30}];
G = Z[n]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}];
:[font = input; preserveAspect; endGroup; nowordwrap; ]
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, ReportIterations -> True]//Last//Last//ColumnForm
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.4 Subgroups of Z[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's pick a random group Z[n], where n is in [6, 30].
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 30}]
G = Z[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
What are the subgroups of this group G = Z[n]? One naive way of exploring this would be to pick a random set of elements and look at the closure, which we have seen always results in a subgroup. If this is repeated enough times, one might find all the subgroups of the group. Let's try this. Evaluate the following 3 to 5 times.
:[font = input; preserveAspect; nowordwrap; ]
m = Random[Integer, {1, Floor[N[Sqrt[n]]]}];
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Sort -> True] 
(* we sort the list to improve readability *)
:[font = text; inactive; preserveAspect; nohscroll; ]
You may notice that the full group is often returned. Suppose we try restricting the number of elements in H to 1 or 2. Try evaluating the following a number of times.
:[font = input; preserveAspect; nowordwrap; ]
m = Random[Integer, {1, 2}];
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Sort -> True]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. What do you think are the subgroups of Z[n] for the n with which you have been working? (Also indicate what n you were given.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's get a new group and try this again.
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {6, 30}]
G = Z[n]
:[font = input; preserveAspect; nowordwrap; ]
m = Random[Integer, {1, 2}];
H = RandomElements[G, m, Replacement -> False]
Closure[G, H, Sort -> True]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. What group did you get this time? What do you think are the subgroups for this group?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.5 P(H < G) for a random subset H of G = Z[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we consider the group Z[12]. Recall that if H is a subgroup of G, we sometimes denote this by H < G. If we choose a random set of elements, H, from the elements of G, what is the probability that H is indeed a subgroup of G (denoted P(H<G))? In this section, we wish to pursue this question (and modifications of it, using other indices n in Z[n]).
:[font = input; preserveAspect; nowordwrap; ]
G = Z[12]
:[font = text; inactive; preserveAspect; nohscroll; ]
First we start with |H| = 1. Evaluate the following to determine the results of randomly choosing one element 30 different times to see if it forms a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
orderOfH = 1;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {30}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Out of the 30 attempts, how many of these yielded a subgroup? What did you expect to happen? What would you expect to happen if 100 people did this experiment and each ran the loop for 1000 times instead of 30? Justify your answer. You should have an answer for P(H < Z[12]) for H = {g} for some g in Z[12].
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we consider the case when |H| = 2. Evaluate the following to determine the results of choosing two elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
orderOfH = 2;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you didn't get a True, try evaluating this cell again (which will not guarantee a True, but may be worth trying, in some cases).
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. How many successes did you have? (That is, how many times did you get True?) Which pair of elements yielded a subgroup, if any? Is there any (other) subset of size two that will (also) be a subgroup? Why or why not? Given a random set H of two elements from Z[12], what do you think is the probability that H will be a subgroup (i.e., P(H < Z[12]))?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we consider the case when |H| = 3. Evaluate the following to determine the results of choosing three elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
orderOfH = 3;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you didn't get a True, try evaluating this cell again. (Again, no guarantee.)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. How many successes did you have? Which triple of elements yielded a subgroup, if any? Is there any (other) subset of size three that will (also) be a subgroup? Why or why not? Given a random set H consisting of three elements of Z[12], what is P(H < Z[12])?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we consider the case when |H| = 4. Evaluate the following to determine the results of choosing four elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
orderOfH = 4;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you didn't get a True, evaluate again until you do, keeping track of how many attempts were made. If you get tired of doing this, and think you know what you should expect, you can quit.
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we consider the case when |H| = 5. Evaluate the following to determine the results of choosing five elements (40 times) to see if the subset forms a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
orderOfH = 5;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Keep trying the above to get True or stop when you think you know what is likely to happen.
:[font = text; inactive; preserveAspect; nohscroll; ]
Keep increasing the order of H and evaluating the cell above until you can answer the following question.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Given G = Z[12], what are the different possible orders of the subgroups of G? Also, how many subgroups are there of each order?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Now suppose we have G = Z[10]. What are the orders of the subgroups of G and how many subgroups are there of each order? Use the cell below if you want to do some experimenting.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
G = Z[10];

orderOfH = 1;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Now suppose we have G = Z[11]. What are the orders of the subgroups of G and how many are there of each order? Use the cell below if you want to do some experimenting.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
G = Z[11];

orderOfH = 1;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Summarize your findings by writing a conjecture about the subgroup structure of Z[n]. How might you prove your answer?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Given G = Z[n], and a subset H of G with |H| = m, what is P(H < G)?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. Look back at the subgroups you found for Z[12]. Starting with the subgroup(s) of order 2 and working up, what can you say about the relationship(s), if any, between the order of the subgroup, the elements of Z[12], and the actual elements in the subgroup?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. Do you think the results summarized in question 14 pertain only to Z[n] or are they valid for other groups (either some or all) as well? Try the following to help you think about this question.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; endGroup; nowordwrap; ]
G = U[20]

orderOfH = 2;
TableForm[Table[{H = RandomElements[G, orderOfH, Replacement
	-> False], SubgroupQ[H, G]}, {40}], TableDepth -> 2, 
	TableHeadings -> {None, {"H", "SubgroupQ[H, G]\n\n"}}]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.6 Necessary elements for full closure
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we focus on the group Z[10] as an example in thinking about the question of what elements must be in a set H to guarantee that we have the closure of H be the entire group.

First we define G.
:[font = input; preserveAspect; nowordwrap; ]
G = Z[10]
:[font = text; inactive; preserveAspect; nohscroll; ]
Then we will look at a table of random sets H with one or two elements, with their closure.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[m = Random[Integer, {1, 2}];
	{H = RandomElements[G, m, Replacement -> False],
		Elements[Closure[G, H, Sort -> True]]}, {25}], 
		TableHeadings -> {None, {"H", "closure of H\n"}}, 
		TableSpacing -> {0, 3}, TableDepth -> 2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. Partition the elements of Z[10] into 3 classes: (1) those whose presence in H cause the closure of H to be the full group, (2) those whose presence in H do NOT cause the closure of H to be the full group, and (3) the remaining elements being ones that you are not sure about their impact.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, consider another example, Z[8].
:[font = input; preserveAspect; nowordwrap; ]
G = Z[8]
TableForm[Table[m = Random[Integer, {1, 2}];
	{H = RandomElements[G, m, Replacement -> False],
		Elements[Closure[G, H, Sort -> True]]}, {25}], 
		TableHeadings -> {None, {"H", "closure of H\n"}}, 
		TableSpacing -> {0, 3}, TableDepth -> 2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q19. Repeat the previous question with the results of Z[8].
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Finally, consider another example, Z[12].
:[font = input; preserveAspect; nowordwrap; ]
G = Z[12] 
ColumnForm[Table[m = Random[Integer, {1, 2}];
	{H = RandomElements[G, m, Replacement -> False],
		Elements[Closure[G, H, Sort -> True]]}, {25}]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q20. Consider the results of the last three examples. If H = {g, h} is a subset of Z[n] and the closure of H is all of Z[n], what can you conclude about the relationship between at least one of g or h and the number n?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.7 Subgroups of U[n]
:[font = text; inactive; preserveAspect; nohscroll; ]
For a quick review of the group U[n], let's view the first 20 groups when n runs from 1 to 20.
:[font = input; preserveAspect; nowordwrap; ]
ColumnForm[Table[{n, Elements[U[n]]}, {n, 1, 20}]]
:[font = text; inactive; preserveAspect; nohscroll; ]
From this it should be clear how many elements are in each group listed here (and if you answered all the questions from the last lab, you perhaps know the order of U[n] as a function of n for any n). What about the subgroups of U[n]? Since we know the trivial subgroup consisting of the identity is always a subgroup, as is the full group, we can ignore these. Therefore, the first group to consider for non-trivial subgroups is U[5]. (Why?) Furthermore, we know that any subgroup must have the identity, so we can be sure that 1 will be in any subgroup.
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at the possible subgroups of U[5] by first considering all the nonidentity elements. (Recall what the complement of a set is, and that 1 is the identity.)
:[font = input; preserveAspect; nowordwrap; ]
els = Complement[Elements[U[5]], {1}]
:[font = text; inactive; preserveAspect; nohscroll; ]
These are the elements from which we need to consider all possible subsets. The function KSubsets (from DiscreteMath`Combinatorica) does this job.
:[font = input; preserveAspect; nowordwrap; ]
?KSubsets
:[font = text; inactive; preserveAspect; nohscroll; ]
We will make a table of all possible subsets of length 1, 2, ... up to one less than the length of els, which is 2 (= 3 - 1) in this case. (We have deleted the identity 1 from els, and we know the full group is a subgroup, so we search for sets of length up to two less than the size of our group.)
:[font = input; preserveAspect; nowordwrap; ]
Table[KSubsets[els, i], {i, Length[els]-1}]
:[font = text; inactive; preserveAspect; nohscroll; ]
There are too many levels of braces, so we remove one layer:
:[font = input; preserveAspect; nowordwrap; ]
Flatten[%, 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we want to join the identity back into each of these. These are now candidates for being (proper) subgroups.
:[font = input; preserveAspect; nowordwrap; ]
Hsets = Map[Join[{1}, #]&, %]
:[font = text; inactive; preserveAspect; nohscroll; ]
The next step is to test each one by mapping the SubgroupQ function on each.
:[font = input; preserveAspect; nowordwrap; ]
subgroups = Map[SubgroupQ[#, U[5]]&, Hsets]
:[font = text; inactive; preserveAspect; nohscroll; ]
It is easier to see which are subgroups if we match up the sets with these results:
:[font = input; preserveAspect; nowordwrap; ]
Transpose[{Hsets, subgroups}]//MatrixForm
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q21. From the above information, what can you say about the order of the element 2? What about 3? What about 4? Do you think U[5] is cyclic or not? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's put all the steps above into one compact function that gives the final output as above.
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[n_Integer?Positive] := 
		Module[{els, Hsets, subgroups},
	els = Complement[Elements[U[n]], {1}];
	Hsets = Flatten[Table[KSubsets[els, i], {i, Length[els]-1}], 1];
	Hsets = Map[Join[#, {1}]&, Hsets];
	subgroups = Map[SubgroupQ[#, U[n]]&, Hsets];
	Transpose[{Hsets, subgroups}]//MatrixForm
] (* There is no output since this is just a definition *)
:[font = text; inactive; preserveAspect; nohscroll; ]
It is time to test it on the next index, n = 6.
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[6]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q22. What happened? Was there a mistake made in the coding? Think about this! Why was there no output?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
What about n = 7?
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[7]
:[font = text; inactive; preserveAspect; nohscroll; ]
We see many False conclusions. Why? Can we be more efficient in our search for subgroups? How many elements are there in U[7]?
:[font = input; preserveAspect; nowordwrap; ]
Elements[U[7]]//Length
:[font = text; inactive; preserveAspect; nohscroll; ]
Perhaps through some previous experiences, either in this lab, a previous lab or class work, you have become aware that if we have a subgroup, its order must be a divisor of the order of the group. This is an important result, called Lagrange's Theorem, which will be proven later.

What are the divisors of 6? It is easy in this case, but here is how Mathematica can be asked.
:[font = input; preserveAspect; nowordwrap; ]
divs = Divisors[6]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's gather all the actual "HSets" which our function generates.
:[font = input; preserveAspect; nowordwrap; ]
temp = FindNontrivialSubgroupsOfUn[7][[1]]//Transpose//First
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we really only have questions about the those of orders 2 and 3 (why?), let's select just those:
:[font = input; preserveAspect; nowordwrap; ]
Select[temp, MemberQ[{2, 3}, Length[#]]&]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we can test just these as subgroups. These last several steps are implemented in a new version of our function, given below.
:[font = input; preserveAspect; nowordwrap; ]
Clear[FindNontrivialSubgroupsOfUn];

FindNontrivialSubgroupsOfUn[n_Integer?Positive] := 
		Module[{els, Hsets, subgroups, divs},
	els = Complement[Elements[U[n]], {1}];
	Hsets = Flatten[Table[KSubsets[els, i], {i, Length[els]-1}], 1];
	Hsets = Map[Join[#, {1}]&, Hsets];
	Hsets = Select[Hsets, MemberQ[Complement[Divisors[Order[U[n]]],
		{1, n}], Length[#]]&];
	subgroups = Map[SubgroupQ[#, U[n]]&, Hsets];
	Transpose[{Hsets, subgroups}]//MatrixForm
] (* There is no output since this is just a definition *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we will try it again.
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[7]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q23. Do you think U[7] is cyclic? Why or why not? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[8]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q24. Do you think U[8] is cyclic? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[9]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q25. Do you think U[9] is cyclic? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[10]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q26. Do you think U[10] is cyclic? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
If you are willing to wait a little while, try the following.
:[font = input; preserveAspect; nowordwrap; ]
FindNontrivialSubgroupsOfUn[11]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q27. Why does this take so long?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
One can also use a more general function that determines the actual subgroups for any (finite) group (given enough time, memory and disk space). Here we try it on U[20]. 
:[font = input; preserveAspect; nowordwrap; ]
Subgroups[U[20]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q28. Do you think U[20] is cyclic? Why or why not?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.8 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?RandomElements
:[font = input; preserveAspect; nowordwrap; ]
?Replacement
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupQ
:[font = input; preserveAspect; nowordwrap; ]
?Mode
:[font = input; preserveAspect; nowordwrap; ]
?Visual
:[font = input; preserveAspect; nowordwrap; ]
?Closure
:[font = input; preserveAspect; nowordwrap; ]
?SortGroupoid
:[font = input; preserveAspect; nowordwrap; ]
?ReportIterations
:[font = input; preserveAspect; nowordwrap; ]
?Staged
:[font = input; preserveAspect; nowordwrap; ]
?NextStage
:[font = input; preserveAspect; nowordwrap; ]
?PreviousStage
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?U
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Subgroups
^*)