(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 9. Automorphisms
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should have completed Group Lab 8.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab continues the exploration of isomorphisms begun in the previous lab. In this lab, we look at a collection of isomorphisms from a group to itself and ask what kind of structure, if any, might be present.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.3 Automorphisms on Zn
:[font = text; inactive; preserveAspect; nohscroll; ]
Before beginning, we read in the necessary code for this lab:
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
In the previous lab we considered questions such as "Is U[12] isomorphic to U[10]?" (or other groups besides U[10]). Consider the group Z[12]. We never asked "Is Z[12] isomorphic to Z[12]?" (i.e., itself). Why not ask this? Is the answer obvious? On the one hand, since isomorphisms indicate that two groups are the "same" in some sense, if two groups are identical (as in this case), we should certainly expect them to be isomorphic. 
:[font = text; inactive; preserveAspect; nohscroll; ]
Indeed, Z[12] is isomorphic to itself. What isomorphism (map) will show this? Try the identity function that takes every element to itself. All the properties hold. Since we are mapping from Z[12] to itself, we call this kind of isomorphism an automorphism. We illustrate the use of the identity function below.
:[font = input; preserveAspect; nowordwrap; ]
f1 = FormMorphoid[#&, Z[12], Z[12]]
IsomorphismQ[f1]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can see the details of this Morphoid by looking at the Rules used in its definition.
:[font = input; preserveAspect; nowordwrap; ]
ToRules[f1]
:[font = text; inactive; preserveAspect; nohscroll; ]
A more important question to ask at this time is whether there are any other automorphisms besides the identity map. We know that we must map 0 to 0. (Why?) What about the element 5? Since it is a generator and has order 12, to what must it be mapped? Clearly it needs to go to another generator, if we wish to preserve orders. So it could be mapped to 1, 5, 7, or 11. 

Let x be any other element of Z[12]. Since 5 is a generator, x = n5 = 5 + 5 + ... + 5 (n summands) for some integer n. To what should we map x? Suppose our function is f. Then,
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
f(x) = f(5 + 5 + ... + 5) = f(5) + f(5) + ... + f(5)
:[font = text; inactive; preserveAspect; nohscroll; ]
with n summands in both instances. This should indicate that once we know to where 5 is mapped, we know where every element is mapped.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Explain this last statement (in such a way that would convince a classmate who may not have heard this yet).
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we know we can send the generator 5 to any one of the four generators, let's make a function for each possibility. Below we use a function called Automorphism that allows us  to specify a rule as a generator and will build the complete morphism from that single piece of information. Asking for more information about a function is always a good idea:
:[font = input; preserveAspect; nowordwrap; ]
?Automorphism
:[font = text; inactive; preserveAspect; nohscroll; ]
We can also get further information by specifying the Textual mode of Automorphism.
:[font = input; preserveAspect; nowordwrap; ]
f2 = Automorphism[Z[12], 5 -> 1, Mode -> Textual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Instead of checking to see if f1 and f2 are morphisms, we can check whether they are isomorphisms directly with IsomorphismQ.
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[f1]
IsomorphismQ[f2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's create our last two automorphisms and check them:
:[font = input; preserveAspect; nowordwrap; ]
f3 = Automorphism[Z[12], 5 -> 7]
IsomorphismQ[f3, Cautious -> True]
:[font = input; preserveAspect; nowordwrap; ]
f4 = Automorphism[Z[12], 5 -> 11]
IsomorphismQ[f4, Cautious -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
We now have four automorphisms. What can we do with these functions? Is this set of four functions anything special? What would happen if we followed one by another (i.e., compose the functions)? In particular, what do we get if we follow f2 by f3?
:[font = text; inactive; preserveAspect; nohscroll; ]
First, define Els to be the elements of the group Z[12] under consideration.
:[font = input; preserveAspect; nowordwrap; ]
Els = Elements[Z[12]]
:[font = text; inactive; preserveAspect; nohscroll; ]
We want the output of f2 to be the input for f3, so let's evaluate f2 at the set Els.
:[font = input; preserveAspect; nowordwrap; ]
f2[Els]
:[font = text; inactive; preserveAspect; nohscroll; ]
This maps f2 over each element in Els. We could also have f2 mapped onto each element by using the Map command:
:[font = input; preserveAspect; nowordwrap; ]
f2Output = Map[f2, Els]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we use this as input for f3:
:[font = input; preserveAspect; nowordwrap; ]
Map[f3, f2Output]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now the question is which function, if any, has this same output (in this order) when mapped over Els? Let's try each one:
:[font = input; preserveAspect; nowordwrap; ]
Map[f1, Els]
Map[f2, Els]
Map[f3, Els]
Map[f4, Els]
:[font = text; inactive; preserveAspect; nohscroll; ]
Great! It matches f4. But what does this mean?
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. What is the relationship, if any, between f2, f3 and f4?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Modify the steps above and determine the result of taking f1 followed by f4. Which function, if any, does this yield?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Where are we going with all of this? What seems to be lurking around the corner (i.e., Mathematica computation)?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we try to automate all of this work above. First, we define our list of automorphisms, but redefine f1 using Automorphism, converting it into a rules-based Morphoid. (This is necessary to form a Groupoid of Morphoids.)
:[font = input; preserveAspect; nowordwrap; ]
f1 = Automorphism[Z[12], 5 -> 5]
automorphisms = {f1, f2, f3, f4}
:[font = text; inactive; preserveAspect; nohscroll; ]
We can operate on these automorphisms with the function MorphoidComposition:
:[font = input; preserveAspect; nowordwrap; ]
?MorphoidComposition
:[font = text; inactive; preserveAspect; nohscroll; ]
If we want to know f4 followed by f3, we use the following. (Notice that the ordering is from right to left.)
:[font = input; preserveAspect; nowordwrap; ]
MorphoidComposition[f3, f4]
:[font = text; inactive; preserveAspect; nohscroll; ]
Or f1 followed by f4:
:[font = input; preserveAspect; nowordwrap; ]
MorphoidComposition[f4, f1]
:[font = text; inactive; preserveAspect; nohscroll; ]
The next question one might ask concerns a Cayley table. First we need to turn this set and operation into a Groupoid. We will call it Automorphisms.
:[font = input; preserveAspect; nowordwrap; ]
Automorphisms = FormGroupoid[automorphisms, 
	MorphoidComposition[#1, #2]&, WideElements->True, 
	KeyForm -> OutputForm]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now, for the moment for which we have all been waiting:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[Automorphisms, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Does this appear to be a group? Why? Is there an identity? If so, what is it; if not, why not? Since this is of order four, to what familiar group is this isomorphic?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
All the work above is automated in the function AutomorphismGroup:
:[font = input; preserveAspect; nowordwrap; ]
?AutomorphismGroup
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's change our modulus from 12 to 10 and see what kind of group we get.
:[font = input; preserveAspect; nowordwrap; ]
G = AutomorphismGroup[Z[10]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now take a look at its Cayley table.
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[G, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. To what familiar group is this isomorphic?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try one more.
:[font = input; preserveAspect; nowordwrap; ]
G = AutomorphismGroup[Z[14]];
CayleyTable[G, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. To what familiar group is this isomorphic?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.4 Inner automorphisms
:[font = text; inactive; preserveAspect; nohscroll; ]
We have seen how we obtain all the automorphisms on a cyclic group. If the group is not cyclic, the question is a bit harder. There are certain automorphisms, however, that are easy to generate for any group. 

Let G be any group and g by any element in G. Consider the function fg : G -> G defined by fg(h) = g h g^(-1). We call g h g^(-1) the conjugate of h by g and the process of applying fg to an element is called conjugation. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. If the group G is Abelian, what happens when we conjugate h by g? What is the map fg in this case?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the group G = Dihedral[4] and let's try conjugating some elements, using the function ElementConjugate.
:[font = input; preserveAspect; nowordwrap; ]
Dihedral[4]
(* recall Rot is the element corresponding to the lowest order
rotation, 90 degrees in this case, and Ref is any reflection.*)
:[font = input; preserveAspect; nowordwrap; ]
?ElementConjugate
:[font = input; preserveAspect; nowordwrap; ]
ElementConjugate[Dihedral[4], Rot^3, Rot]
:[font = input; preserveAspect; nowordwrap; ]
ElementConjugate[Dihedral[4], Ref, Rot]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can speed this up by looking at all the conjugates at once:
:[font = input; preserveAspect; nowordwrap; ]
ConjugatingElement = Rot;
TableForm[Transpose[{Elements[Dihedral[4]],
	Map[ElementConjugate[Dihedral[4], #, ConjugatingElement]&,
	Elements[Dihedral[4]]]}], TableHeadings ->
	{None, {"h", StringJoin["h conjugated by ", 
	ToString[ConjugatingElement], "\n"]}}, TableSpacing ->
		{If[$VersionNumber > 2.5, 0.5, 0], 5}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Which elements didn't get changed when they were conjugated by Rot? Is there anything special about this set?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
What if we conjugate by Ref?
:[font = input; preserveAspect; nowordwrap; ]
ConjugatingElement = Ref;
TableForm[Transpose[{Elements[Dihedral[4]],
	Map[ElementConjugate[Dihedral[4], #, ConjugatingElement]&,
	Elements[Dihedral[4]]]}], TableHeadings ->
	{None, {"h", StringJoin["h conjugated by ", 
	ToString[ConjugatingElement], "\n"]}}, TableSpacing -> 
	{If[$VersionNumber > 2.5, 0.5, 0], 5}]
:[font = text; inactive; preserveAspect; nohscroll; ]
For each element g in a group G, there is a conjugation function fg (that takes an element to its conjugation by g). Note that fg is a function from G to G and therefore a candidate for being an automorphism. In fact, each of these functions is an automorphism and is called an inner automorphism of G induced by g. We can use Mathematica to help us construct these:
:[font = input; preserveAspect; nowordwrap; ]
?InnerAutomorphism
:[font = input; preserveAspect; nowordwrap; ]
Clear[f1]
f1 = InnerAutomorphism[Dihedral[4], Rot^2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at some details of this function. One way of seeing the action is to map f1 onto the elements of the group:
:[font = input; preserveAspect; nowordwrap; ]
Map[f1, Elements[Dihedral[4]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Is f1 really an automorphism?
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[f1]
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we call f2 the inner automorphism induced by Rot^3:
:[font = input; preserveAspect; nowordwrap; ]
f2 = InnerAutomorphism[Dihedral[4], Rot^3]
Map[f2, Elements[Dihedral[4]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since f1 and f2 are functions, it is legitimate to ask about the composition. Will this be another inner automorphism? If so, which one? Perhaps we should try to find all the inner automorphims by mapping the InnerAutomorphism function onto the elements of the group. 
:[font = input; preserveAspect; nowordwrap; ]
funcs = Map[InnerAutomorphism[Dihedral[4], #]&, 
	Elements[Dihedral[4]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
 Now let's map each of these onto the elements of the group to see if any of these functions are the same.
:[font = input; preserveAspect; nowordwrap; ]
images = Map[Map[#, Elements[Dihedral[4]]]&, funcs]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. By looking at this list, would you say that any of these functions are the same? If so, which ones?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Sorting this list, we remove any duplicates:
:[font = input; preserveAspect; nowordwrap; ]
Union[images]
:[font = text; inactive; preserveAspect; nohscroll; ]
At this stage, you should be able to match these up with the original ones obtained, but we put all of this together in one function:
:[font = input; preserveAspect; nowordwrap; ]
G = InnerAutomorphismGroup[Dihedral[4]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The elements of this Groupoid are suppressed until we ask for them.
:[font = input; preserveAspect; nowordwrap; ]
Elements[G]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at the details of the second element.
:[font = input; preserveAspect; nowordwrap; ]
MorphoidRules[Elements[G][[2]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is the Cayley table for this group:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[G, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. You now know about the different groups of order 4. To what (common) group is this isomorphic?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the following groups. 
:[font = input; preserveAspect; nowordwrap; ]
K = InnerAutomorphismGroup[Dihedral[5]];
CayleyTable[K, Mode -> Visual];
:[font = input; preserveAspect; nowordwrap; ]
L = InnerAutomorphismGroup[Dihedral[6]];
CayleyTable[L, Mode -> Visual, ShowKey -> False];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Can you make a conjecture about the inner automorphism group of Dihedral[n]?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
9.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Automorphism
:[font = input; preserveAspect; nowordwrap; ]
?MorphoidComposition
:[font = input; preserveAspect; nowordwrap; ]
?AutomorphismGroup
:[font = input; preserveAspect; nowordwrap; ]
?ElementConjugate
:[font = input; preserveAspect; nowordwrap; ]
?InnerAutomorphism
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?InnerAutomorphismGroup
^*)