(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 12. Normality and factor groups
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Before attempting this lab you should complete Group Lab 11 (on cosets). 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
After defining a normal subgroup, we try to make some sense of finding an operation to act on cosets. This leads to the development of the quotient or factor group. We conclude by illustrating why normality is important in constructing the factor group.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.3 Normal subgroups
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we start out, as we did in the last lab, with the dihedral group of order 8, D[4]. (First, we read in the code needed for this lab.)
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = input; preserveAspect; nowordwrap; ]
G = Dihedral[4]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider a subgroup of G, say H = {1, Rot^2}, consisting of the identity and the 180 degree rotation.
:[font = input; preserveAspect; nowordwrap; ]
H = {1, Rot^2}
:[font = text; inactive; preserveAspect; nohscroll; ]
In the last lab we saw that on some occasions a left coset was the same as a right coset. Will this happen in this case? Below is a table consisting of a column of the elements of G, followed by the elements in the left and right cosets of H in G containing g.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #]}&,
	Elements[G]], TableDepth -> 2, TableHeadings -> {None, {"g",
	"gH", "Hg\n"}}, TableSpacing -> {0, 1}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Would you say that every left coset gH is equal to the right coset Hg? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider another example. Suppose we have G = U[40].
:[font = input; preserveAspect; nowordwrap; ]
G = U[40]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let H be the subgroup <13>.
:[font = input; preserveAspect; nowordwrap; ]
H = SubgroupGenerated[G, 13]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's check out the left cosets gH and right cosets Hg (same g). This time we will let Mathematica do the checking of equality. (You might note that we sort the two cosets before comparing for equality. Why is this done?)
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #],
	Sort[LeftCoset[G, H, #]] === Sort[RightCoset[G, H, #]]}&,
	Elements[G]], TableDepth -> 2, TableHeadings -> {None, {"g",
	"gH", "Hg", "= ?\n"}}, TableSpacing -> {0, 2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
We repeat this with G = S[3] and H = <{1, 3, 2}>.
:[font = input; preserveAspect; nowordwrap; ]
G = Symmetric[3]
H = SubgroupGenerated[G, {1, 3, 2}]
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, LeftCoset[G, H, #], RightCoset[G, H, #],
	Sort[LeftCoset[G, H, #]] === Sort[RightCoset[G, H, #]]}&,
	Elements[G]], TableDepth -> 2, TableHeadings -> {None, {"g",
	"gH", "Hg", "= ?\n"}}, TableSpacing -> {0, 2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here we note that four of the left cosets are not equal to their corresponding right cosets. So we have evidence that equality of left and right cosets is not a general property for all groups or subgroups. This leads to a definition: given a subgroup H of a group G, if gH = Hg for all g in G, we say H is a normal subgroup of G. We can use the function NormalQ to test for normality of a subgroup:
:[font = input; preserveAspect; nowordwrap; ]
NormalQ[H, G]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that if we change H to a different subgroup of G we may obtain normality:
:[font = input; preserveAspect; nowordwrap; ]
NormalQ[SubgroupGenerated[G, {2, 3, 1}], G]
:[font = text; inactive; preserveAspect; nohscroll; ]
Furthermore, note the index of this subgroup in G (i.e., the number of cosets):
:[font = input; preserveAspect; nowordwrap; ]
Index[G, SubgroupGenerated[G, {2, 3, 1}]]
:[font = text; inactive; preserveAspect; nohscroll; ]
An exercise in group theory is to show that any subgroup H whose index in G is 2 will always be normal in G.

Let's try some other groups.
:[font = input; preserveAspect; nowordwrap; ]
NormalQ[{0, 4}, Z[8]]
NormalQ[SubgroupGenerated[U[52], 15], U[52]]
NormalQ[SubgroupGenerated[Dihedral[4], Ref], Dihedral[4]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Suppose G is an Abelian group. What can you say about the normality of any subgroup H of G? Why?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Suppose G is the direct product of Z[5] and U[6]. Let H = <(2, 5)>. Is H normal in G? Give an answer and justification and then check using Mathematica (recalling that DirectProduct is used to obtain the desired direct product).
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.4 Making a new group
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's consider the group G = Z[8] and H = {0, 4} and investigate the cosets that arise:
:[font = input; preserveAspect; nowordwrap; ]
G = Z[8]
H = {0, 4}
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the following four cosets. (Recall that the coset gH is written g + H when the group is written additively.)
:[font = input; preserveAspect; nowordwrap; ]
0 + H
1 + H
2 + H
3 + H
(* if you think Mathematica knows what it is doing here,
understanding cosets, you are mistaken - try 5 + H *)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Why are these the only cosets considered? In other words, why aren't both left cosets and right cosets considered? Additionally, what about the cosets 4 + H, 5 + H, 6 + H and 7 + H?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we consider these four cosets and think about a way in which we might combine (operate on) any two of these. What might it mean to add two cosets, say 2 + H and 3 + H? As alluded to above, Mathematica doesn't really (yet) know how to add these cosets:
:[font = input; preserveAspect; nowordwrap; ]
(2 + H)
(3 + H)
(2 + H) + (3 + H)
Mod[(2 + H) + (3 + H), 8]
:[font = text; inactive; preserveAspect; nohscroll; ]
Even reducing these mod 8 is not right. What might it mean to "add" {2, 6} and {3, 7}? Suppose we try all possible sums, and then reduce mod 8: {2 + 3, 2 + 7, 6 + 3, 6 + 7}.
:[font = input; preserveAspect; nowordwrap; ]
{2 + 3, 2 + 7, 6 + 3, 6 + 7}
:[font = text; inactive; preserveAspect; nohscroll; ]
Reduce mod 8:
:[font = input; preserveAspect; nowordwrap; ]
Mod[%, 8]
:[font = text; inactive; preserveAspect; nohscroll; ]
Reduce by removing duplicates:
:[font = input; preserveAspect; nowordwrap; ]
Union[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this is really 5 + H (as well as 1 + H). Note also that 2 + 3 = 5. Since 2 + H could have been written as 6 + H, one might wonder if interchanging these would affect how we "add" these cosets. As will likely be proved in your class, it does not.

In fact, given any group G and any normal subgroup N of G, the set of all (left) cosets {gN | g in G} forms a group under the operation (gN)(hN) = (gh)N (shown multiplicatively here -- additively it would be written (g + N) + (h + N) = (g + h) + N). This new group is called the factor group of G by H, or the quotient group of G by H. This is frequently denoted G/H.
:[font = input; preserveAspect; nowordwrap; ]
FactorGroup[G, H]
QuotientGroup[G, H]
:[font = input; preserveAspect; nowordwrap; ]
?QuotientGroup
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Try adding a few of these cosets (as elements of the factor group). On scratch paper, you may wish to make the Cayley table for the group G/H. To what group is this isomorphic?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.5 Factor groups
:[font = text; inactive; preserveAspect; nohscroll; ]
Maybe you thought about making the Cayley table with Mathematica. (If not, why not?) Let's do so.
:[font = input; preserveAspect; nowordwrap; ]
G = Z[8];
H = {0, 4};

CayleyTable[FactorGroup[G, H]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Of course, there is also the pretty version:
:[font = input; preserveAspect; nowordwrap; ]
gr1 = CayleyTable[FactorGroup[G, H], Mode -> Visual, 
	Output -> Graphics];
:[font = text; inactive; preserveAspect; nohscroll; ]
Observe that the elements in the above group are the left cosets of H = {0, 4} in Z[8]. Just as a reminder, here they are:
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[G, H]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. To what group is Z[8]/{0, 4} isomorphic?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is a visual way of seeing how these cosets interact with each other.
:[font = input; preserveAspect; nowordwrap; ]
gr2 = LeftCosets[G, H, Mode -> Visual, 
	Output -> Graphics];
:[font = text; inactive; preserveAspect; nohscroll; ]
Putting these two graphics together, we obtain the following:
:[font = input; preserveAspect; nowordwrap; ]
Show[GraphicsArray[{gr1, gr2}]];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. What observations can you make from considering these two tables? Include an accounting of the coloring of both tables and the "blocking" (colored by "chunks") in the second table.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that the subgroup H = <{1, 3, 2}> is not normal in S3.
:[font = input; preserveAspect; nowordwrap; ]
NormalQ[SubgroupGenerated[S[3], {1, 3, 2}], S[3]]
:[font = text; inactive; preserveAspect; nohscroll; ]
How do the left cosets interact in this case?
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[S[3], SubgroupGenerated[S[3], {1, 3, 2}], 
	Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Before one can form the factor group, the subgroup must be normal. What goes wrong when the subgroup is not normal? Consider the above visualization and answer this question. Focus, in particular, on the last four columns and try to determine why the coloration does not occur in square blocks there. Give specific explanations for the coloring in these last four columns.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we consider the same group and subgroup, but consider the right cosets.
:[font = input; preserveAspect; nowordwrap; ]
RightCosets[S[3], SubgroupGenerated[S[3], {1, 3, 2}], 
	Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Explain why the last four rows occur as they do. Provide explicit details.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Determine another subgroup H of some group G that is not normal in G. Define these below. Now consider the left and right cosets visually, using the cell below your definitions.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
G =  (* <- define your group here *)
H =  (* <- define your subgroup here *)
NormalQ[H, G]
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[G, H, Mode -> Visual]
RightCosets[G, H, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's consider two more examples of normal subgroups and the corresponding products of cosets.
:[font = input; preserveAspect; nowordwrap; ]
G = U[16]
H = SubgroupGenerated[G, 3]
NormalQ[H, G]
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[G, H, Mode -> Visual]
:[font = input; preserveAspect; nowordwrap; ]
G = Z[6]
H = {0, 3}
NormalQ[H, G]
:[font = input; preserveAspect; nowordwrap; ]
LeftCosets[G, H, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. For these normal subgroups, why did we only look at the visual representation of the left cosets (and not the right cosets)?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Make a summary statement regarding why normality is a requirement for a quotient group to be a coherent, well-defined structure.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.6 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Dihedral
:[font = input; preserveAspect; nowordwrap; ]
?U
:[font = input; preserveAspect; nowordwrap; ]
?LeftCoset
:[font = input; preserveAspect; nowordwrap; ]
?RightCoset
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupGenerated
:[font = input; preserveAspect; nowordwrap; ]
?Symmetric
:[font = input; preserveAspect; nowordwrap; ]
?NormalQ
:[font = input; preserveAspect; nowordwrap; ]
?Index
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?Mod
:[font = input; preserveAspect; nowordwrap; ]
?Union
:[font = input; preserveAspect; nowordwrap; ]
?FactorGroup
:[font = input; preserveAspect; nowordwrap; ]
?QuotientGroup
:[font = input; preserveAspect; nowordwrap; ]
?CayleyTable
:[font = input; preserveAspect; nowordwrap; ]
?LeftCosets
:[font = input; preserveAspect; nowordwrap; ]
?Output
:[font = input; preserveAspect; nowordwrap; ]
?RightCosets
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?GraphicsArray
^*)