(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Group Lab 13. Group homomorphisms
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
It is presumed that the reader is familiar with isomorphisms (Group Lab 8) and cosets (Group Lab 11).
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab explores the concept of group homomorphisms. The ultimate goal is for the reader to understand the relationship between the domain, kernel and image of a homomorphism through the Fundamental Theorem of Group Homomorphisms. 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.3 What is a group homomorphism?
:[font = text; inactive; preserveAspect; nohscroll; ]
A Note on Terminology: The terms homomorphism and morphism are used synonymously in algebra. Since the former is somewhat more prevalent in textbooks, we will use it here, but in the interest of using shorter names where possible, we use the latter in our Mathematica code.
:[font = text; inactive; preserveAspect; nohscroll; ]
A homomorphism from a group (G, *) into a group (H, #) is a function from G into H that preserves the operations between the two groups (* and # respectively). That is, if f is a homomorphism, then for all values of x and y in G,
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
f(x * y) = f(x) # f(y).
:[font = text; inactive; preserveAspect; nohscroll; ]
You should be familiar with the one-to-one, onto variety of these functions, called isomorphisms. Recall that the existence of an isomorphism between two groups establishes that the two groups are "equal" in an algebraic sense. The automorphisms on a group (isomorphisms from a group to itself) help us to categorize groups. Homomorphisms provide us with yet another tool in exploring groups. 

Before continuing, we first read in the code that will be used in this lab.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Group];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
To review the notion of preserving an operation, we will start by looking at two functions from the group of integers modulo 12 (Z[12]) into the group of integers modulo 6 (Z[6]). Again we use objects called Morphoids and the function FormMorphoid to create them. The first function adds 3 to each element of Z[12] and then takes the residue modulo 6 (reduces it mod 6). The second adds 6 before taking the residue modulo 6. 												
:[font = input; preserveAspect; nowordwrap; ]
f = FormMorphoid[Mod[# + 3, 6]&, Z[12], Z[6]]
:[font = input; preserveAspect; nowordwrap; ]
g = FormMorphoid[Mod[# + 6, 6]&, Z[12], Z[6]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we see if either function preserves the operations between the two groups for a specific pair of elements, say 5 and 9. We will use the Visual Mode of PreservesQ to help visualize the process.

First, f:
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[f, {5, 9}, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
The operations are not preserved: f(5 + 9) is not equal to  f(5) + f(9). So, with this single example, we see that f is not a homomorphism.

Now we look at g. Note: the visual mode displays the name of any function generically as f, but here g is the function we are examining.
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[g, {5, 9}, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
For the pair (5, 9), g acts like a homomorphism. Does g satisfy this property for all pairs in Z[12]? We can use MorphismQ to test all pairs. 
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[g, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
If g is replaced with f in the cell above, an opposite color pattern would result.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. There is a simpler way to define g than the function we used. Can you describe it?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.4 The kernel and image
:[font = text; inactive; preserveAspect; nohscroll; ]
The kernel and image of a homomorphism are special subsets worthy of consideration, the kernel being a subset of the domain and the image a subset of the codomain.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.4.1 The kernel
:[font = text; inactive; preserveAspect; nohscroll; ]
The kernel of a group homomorphism is the set of elements in the domain that map onto the identity of the codomain. Recall that g (defined above) is a homomorphism.
:[font = input; preserveAspect; nowordwrap; ]
Kernel[g]
:[font = text; inactive; preserveAspect; nohscroll; ]
The Kernel function returns a Groupoid, which we know by now does not in itself imply it is a group (or a subgroup of the domain)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. In this case, is the kernel a group (i.e., a subgroup of Z[12])?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's look at some more kernels. Consider the following Morphoids.
:[font = input; preserveAspect; nowordwrap; ]
f2 = FormMorphoid[Mod[#, 5]&, Z[10], Z[5]]
f3 = FormMorphoid[Mod[#, 2]&, Z[10], Z[2]]
f4 = FormMorphoid[2 -> 1, U[25], Z[20]]
f5 = FormMorphoid[2 -> 2, U[25], Z[20]]
f6 = FormMorphoid[Mod[#, 3]&, Z[10], Z[5]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's determine which of these are homomorphisms and compute the kernels:
:[font = input; preserveAspect; nowordwrap; ]
Map[MorphismQ, {f2, f3, f4, f5, f6}]
:[font = input; preserveAspect; nowordwrap; ]
Map[Kernel, {f2, f3, f4, f5, f6}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. For which of these five functions is the kernel a group (i.e., a subgroup of the domain)?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. If h is a homomorphism and a and b are in K = Kernel[h], explain why a * b must also be in K. (In other words, show K is closed.) Note: closure of a (nonempty) subset of a finite group implies that it is a subgroup.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The Mathematica function Kernel acts on any Morphoid. If the codomain has an identity, it will return a Groupoid (returning $Failed otherwise). Recall that f was not a homomorphism.
:[font = input; preserveAspect; nowordwrap; ]
Kernel[f]
ClosedQ[%]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. True or false: If f is a Morphoid from some group G into some group H and Kernel[f] is a subgroup of the G, then f is a homomorphism. (See the hint at end of the section, if needed.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
In some sense, the size of the kernel indicates how much the domain is "reduced" when a homomorphism is applied to it.
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Hint
:[font = text; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Consider G = H = Z[3] and the function that squares its input (mod 3).
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.4.2 The image
:[font = text; inactive; preserveAspect; nohscroll; ]
The image of a homomorphism is the range of the function, and this is a subset of the codomain. We want to know when this subset is a subgroup. For our first homomorphism, g, the image is the whole codomain, and so it is clearly a subgroup. This is a very common situation.
:[font = input; preserveAspect; nowordwrap; ]
Image[g]
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the five Morphoids defined above in the kernel section, in addition to f defined at the outset; are the images subgroups of the codomain?
:[font = input; preserveAspect; nowordwrap; ]
{f, f2, f3, f4, f5, f6}//ColumnForm
:[font = input; preserveAspect; nowordwrap; ]
Map[Image, {f, f2, f3, f4, f5, f6}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Which of these images are subgroups of the given codomain?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Suppose pi is a function from the group G into the group H. Consider the following two statements: (i) If pi is a homomorphism, then the image of pi is a subgroup of H, and (ii) If the image of pi is a subgroup of H, then pi is a homomorphism. Determine if these statements are true or false. If true, give a proof; if false, provide an example of a Morphoid that demonstrates it is false.
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.5 Properties that are preserved by homomorphisms
:[font = text; inactive; preserveAspect; nohscroll; ]
The following results are proven in many abstract algebra texts and so we will simply report them and give a few illustrations.

Homomorphism preservation properties:

Let f be a homomorphism from G into H.

(1) f(the identity of G) = the identity of H.
(2) f(x^(-1)) = f(x)^(-1) for all x in G.
(3) If S is a subgroup of G, then f(S) = {f(s) : s in S} is a subgroup of H.

We will use one homomorphism to illustrate these three properties, mapping the integers modulo 16 into the fourth roots of unity.
:[font = input; preserveAspect; nowordwrap; ]
G = Z[16]
H = RootsOfUnity[4, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
The visual form of RootsOfUnity[4] is given to illustrate that this group is the set of complex numbers (on the unit circle) that satisfy the equation x^4 = 1.
:[font = text; inactive; preserveAspect; nohscroll; ]
The Morphoid will map each integer to that power of i, so that x -> i^x.
:[font = input; preserveAspect; nowordwrap; ]
Clear[f];
f = FormMorphoid[(I^#)&, G, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
The identities here are 0 and 1, respectively. Therefore, by property (1), the element 0 in G should be mapped to the element 1 in H.
:[font = input; preserveAspect; nowordwrap; ]
f[0] == 1
:[font = text; inactive; preserveAspect; nohscroll; ]
Notice below how the equation is much more explicit in Mathematica than in property (2) above. To test the property we need to specify the groups in which each inversion is taking place. We pick a random element x out of the domain and then test property (2).
:[font = input; preserveAspect; nowordwrap; ]
x = RandomElement[G]
f[GroupInverse[G, x]] == GroupInverse[H, f[x]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's generate a few more examples and place them in a table. The third and fifth columns should match if our Morphoid is a morphism.
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[x = RandomElement[G];
	xinv = GroupInverse[G, x];
	fxinv = f[xinv];
	fx = f[x];
	invfx = GroupInverse[H, f[x]];
	{x, xinv, fxinv, fx, invfx}, {10}],
	TableHeadings -> {None, {"x", "x^(-1)", "f(x^(-1))",
		"f(x)", "(f(x))^-1\n"}}]
:[font = text; inactive; preserveAspect; nohscroll; ]
For property (3), note that the even elements of Z[16] are a subgroup of G.
:[font = input; preserveAspect; nowordwrap; ]
Y = Range[0, 15, 2]
SubgroupQ[Y, G]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider its image:
:[font = input; preserveAspect; nowordwrap; ]
W = Union[Map[f, Y]]
SubgroupQ[W, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
This too is a subgroup.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Recall the Morphoid f5 defined above (and given below). Verify that these three properties hold for this morphism.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; endGroup; nowordwrap; ]
f5 = FormMorphoid[2 -> 2, U[25], Z[20]]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.6 The kernel is normal
:[font = text; inactive; preserveAspect; nohscroll; ]
The kernel of a homomorphism is not just an ordinary subgroup: it is always a normal subgroup. One proof of this statement is based on the definition of a normal subgroup:
:[font = text; inactive; preserveAspect; nohscroll; ]
H is a normal subgroup of G	if and only if	g^(-1) h g is in H for all h in H and g in G.
:[font = text; inactive; preserveAspect; nohscroll; ]
In other words, every conjugate of an element of H is also in H. (Recall that g^(-1) h g, for some g in G, is a conjugate of h.)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Verify that if f is a homomorphism and k is in K = Kernel[f], then any conjugate of k is also in K.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Since every subgroup of an Abelian group is normal---do you know why?---we need to consider a non-Abelian group to illustrate this last result. Consider the cyclic subgroup generated by Ref in D[3].
:[font = input; preserveAspect; nowordwrap; ]
H = SubgroupGenerated[Dihedral[3], Ref]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can choose g to be any element of the group -- here we pick Rot and look at its conjugates.
:[font = input; preserveAspect; nowordwrap; ]
Map[Conjugate[Dihedral[3], #, Rot]&, Elements[H]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Our result shows that H is not a normal subgroup. (Why?) This also implies something that we can not easily illustrate: H is not the kernel of any homomorphism with domain D[3]. 

Let's see what kernels we can get from homomorphisms on D[3]. Suppose that we consider the exponent of the symbol Rot in any element of D[3]. Recall the elements of D[3]:
:[font = input; preserveAspect; nowordwrap; ]
Elements[Dihedral[3]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Clearly the exponent is an integer in {0, 1, 2}, so let's consider this as a Morphoid into Z[3]. The Mathematica expression here is a bit complicated because the elements in D[3] involve the function NonCommutativeMultiply.
:[font = input; preserveAspect; nowordwrap; ]
xifunction = Exponent[#/.{NonCommutativeMultiply -> Times},
	Rot]&
:[font = text; inactive; preserveAspect; nohscroll; ]
We put the Morphoid into rules-form to make it easier to read.
:[font = input; preserveAspect; nowordwrap; ]
xi = FormMorphoid[xifunction, Dihedral[3], Z[3]]//ToRules
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider the kernel.
:[font = input; preserveAspect; nowordwrap; ]
Kernel[xi]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Since the kernel of xi is {1, Ref}, what immediate conclusion should we draw regarding xi? You might want to use PreservesQ or MorphismQ to verify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's do the same as above, but with the exponent of Ref:
:[font = input; preserveAspect; nowordwrap; ]
taufunction = Exponent[#/.{NonCommutativeMultiply -> Times},
	Ref]&
:[font = input; preserveAspect; nowordwrap; ]
tau = FormMorphoid[taufunction, Dihedral[3], Z[2]]//ToRules
:[font = text; inactive; preserveAspect; nohscroll; ]
We get a different kernel here:
:[font = input; preserveAspect; nowordwrap; ]
K = Kernel[tau]
:[font = text; inactive; preserveAspect; nohscroll; ]
Is the kernel normal? We can use the function NormalQ.
:[font = input; preserveAspect; nowordwrap; ]
NormalQ[K, Dihedral[3]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Alternatively, we can ask whether tau is a homomorphism.
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[tau]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Explain why checking the value of MorphismQ[tau] gives us more information than does NormalQ[K, Dihedral[3]]. 
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.7 The First Homomorphism Theorem
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that normality is exactly the condition on a subgroup required in order for its left (or right) cosets to form a group. If f is a homomorphism from G into H with kernel K, we will examine the quotient group G/K. We start with our most recent example.
:[font = input; preserveAspect; nowordwrap; ]
Q = QuotientGroup[Dihedral[3], K]
:[font = text; inactive; preserveAspect; nohscroll; ]
The quotient group has just two elements and so it clearly must be isomorphic to Z[2], which happens to be the image of tau. Let's formally establish this fact by creating an isomorphism between G/Kernel[tau] and Image[tau].
:[font = input; preserveAspect; nowordwrap; ]
FormMorphoidSetup[Q, Image[tau]]
:[font = text; inactive; preserveAspect; nohscroll; ]
We want to map the identity of the domain to the identity of the codomain, so we define the Morphoid by position using the list {1, 2} to indicate that the first element of Q goes to the first element of Image[tau] and the second to the second.
:[font = input; preserveAspect; nowordwrap; ]
theta = FormMorphoid[{1, 2}, Q, Image[tau]]
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[theta]
:[font = text; inactive; preserveAspect; nohscroll; ]
The isomorphism that we've just created is not coincidental. It follows from the following theorem. 

The Fundamental Homomorphism Theorem Let f be a group homomorphism from G into H with kernel K and image f(G). Then f(G) is isomorphic to G/K, an isomorphism between these two groups being psi: G/K -> f(G) defined by psi(aK) = f(a). 

In the example we computed above, notice how the coset RefNS is mapped to tau[Ref] = 1, while NS = 1NS is mapped to tau[1] = 0.

Virtually every abstract algebra text has a proof of this theorem, or some slight variation of the theorem. For example, one popular text starts with the assumption that f is onto (and so f(G) = H). The proof is still essentially the same. We close this section by illustrating the theorem with two more examples.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.7.1 Example 2
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the direct product Z[5] x Z[5] and map each pair (a, b) into 4a + 3b (mod 5) in Z[5].
:[font = input; preserveAspect; nowordwrap; ]
G = DirectProduct[Z[5], Z[5]]
:[font = input; preserveAspect; nowordwrap; ]
alpha = FormMorphoid[(Mod[Plus@@({4, 3}.#), 5])&, G, Z[5]]
:[font = text; inactive; preserveAspect; nohscroll; ]
It may not be obvious whether alpha is a homomorphism, so we verify that it is.
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[alpha]
:[font = text; inactive; preserveAspect; nohscroll; ]
We compute the kernel and image. 
:[font = input; preserveAspect; nowordwrap; ]
K = Kernel[alpha]
:[font = input; preserveAspect; nowordwrap; ]
Image[alpha]
:[font = text; inactive; preserveAspect; nohscroll; ]
Notice that alpha is onto, so we can establish an isomorphism between G/K and Z[5].
:[font = input; preserveAspect; nowordwrap; ]
Q2 = QuotientGroup[G, K]
:[font = input; preserveAspect; nowordwrap; ]
gamma = FormMorphoid[alpha[First[#]]&, Q2, Image[alpha]]
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[gamma]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Let G = DirectProduct[Z[4], Z[4]] and K = {{0,0}, {0,2}, {2,0}, {2,2}}. To what group is G/K isomorphic? To prove your answer, find a homomorphism from G into some other group that has K as its kernel. 
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.7.2 Example 3
:[font = text; inactive; preserveAspect; nohscroll; ]
In this example, we map the divisors of 42 into the divisors of 30 with the function GCD[#, 30]&. We form the Morphoid between the MixedDivisors Groupoids based on these sets.
:[font = input; preserveAspect; nowordwrap; ]
?MixedDivisors
:[font = input; preserveAspect; nowordwrap; ]
eta = FormMorphoid[GCD[#, 30]&, MixedDivisors[42], 
	MixedDivisors[30]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The kernel will be the divisors of 42 that are relatively prime to 30.
:[font = input; preserveAspect; nowordwrap; ]
K = Kernel[eta]
:[font = text; inactive; preserveAspect; nohscroll; ]
Not every divisor of 30 is in the range, so eta is not onto.
:[font = input; preserveAspect; nowordwrap; ]
Image[eta]
:[font = text; inactive; preserveAspect; nohscroll; ]
The Fundamental Homomorphism Theorem tells us that the image is isomorphic to the following quotient group.
:[font = input; preserveAspect; nowordwrap; ]
Q3 = QuotientGroup[MixedDivisors[42], K]
:[font = text; inactive; preserveAspect; nohscroll; ]
The isomorphism we define maps each of these cosets to the image under eta of its first element.
:[font = input; preserveAspect; nowordwrap; ]
theta = FormMorphoid[eta[First[#]]&, Q3, Image[eta]]
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[theta]
:[font = text; inactive; preserveAspect; nohscroll; ]
Again, our result is not a surprise.

The Fundamental Homomorphism Theorem is occasionally called the First Homomorphism Theorem. You might wonder about a Second Homomorphism Theorem. There is one, and it is often called the "Diamond Homomorphism Theorem." There is also a Third (Zassenhauss' Theorem). These theorems are stated and proved in many introductory abstract algebra books.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. A square-free integer is an integer that has no square divisors other than 1. For example, 42 and 30 are square-free, while 50 is not. MixedDivisors[m] is a group if and only if m is square-free. As a general rule, if m and n are both square-free integers and we map MixedDivisors[m] into MixedDivisors[n] with the function GCD[#, n]&, what will be the kernel and range of this morphism? 
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.8 The alternating group - parity as a morphism
:[font = text; inactive; preserveAspect; nohscroll; ]
We have seen that every permutation is either odd or even. Now we will think of this classification as a Morphoid mapping Sn into the group {1, -1} with multiplication, which we call IntegerUnits. Here we will work with n = 4.
:[font = input; preserveAspect; nowordwrap; ]
sign = FormMorphoid[Parity, Symmetric[4], IntegerUnits]
:[font = text; inactive; preserveAspect; nohscroll; ]
This happens to be a significant morphism for any n.
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[sign]
(* may take some time *)
:[font = text; inactive; preserveAspect; nohscroll; ]
The kernel is quite significant here. 
:[font = input; preserveAspect; nowordwrap; ]
Kernel[sign]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Describe the elements of the kernel in terms of their parity.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The kernel, which happens to be a normal subgroup of S[4], is called the alternating group of degree 4, or A[4]. This group can be accessed directly without morphisms using Alternating.
:[font = input; preserveAspect; nowordwrap; ]
?Alternating
:[font = input; preserveAspect; nowordwrap; ]
Alternating[4]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
There are many interesting properties of the alternating groups that you can read about in your text.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.9 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?FormMorphoid
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?PreservesQ
:[font = input; preserveAspect; nowordwrap; ]
?Visual
:[font = input; preserveAspect; nowordwrap; ]
?MorphismQ
:[font = input; preserveAspect; nowordwrap; ]
?Kernel
:[font = input; preserveAspect; nowordwrap; ]
?U
:[font = input; preserveAspect; nowordwrap; ]
?Map
:[font = input; preserveAspect; nowordwrap; ]
?Image
:[font = input; preserveAspect; nowordwrap; ]
?ClosedQ
:[font = input; preserveAspect; nowordwrap; ]
?RootsOfUnity
:[font = input; preserveAspect; nowordwrap; ]
?RandomElement
:[font = input; preserveAspect; nowordwrap; ]
?GroupInverse
:[font = input; preserveAspect; nowordwrap; ]
?Range
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupQ
:[font = input; preserveAspect; nowordwrap; ]
?Dihedral
:[font = input; preserveAspect; nowordwrap; ]
?SubgroupGenerated
:[font = input; preserveAspect; nowordwrap; ]
?InnerAutomorphism
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?Exponent
:[font = input; preserveAspect; nowordwrap; ]
?NormalQ
:[font = input; preserveAspect; nowordwrap; ]
?QuotientGroup
:[font = input; preserveAspect; nowordwrap; ]
?FormMorphoidSetup
:[font = input; preserveAspect; nowordwrap; ]
?IsomorphismQ
:[font = input; preserveAspect; nowordwrap; ]
?DirectProduct
:[font = input; preserveAspect; nowordwrap; ]
?MixedDivisors
:[font = input; preserveAspect; nowordwrap; ]
?Parity
:[font = input; preserveAspect; nowordwrap; ]
?Symmetric
:[font = input; preserveAspect; nowordwrap; ]
?IntegerUnits
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Alternating
^*)