(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 1. An introduction to rings and Ringoids
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
There are no prerequisites for this lab, although a brief introduction to the terminology related to rings may be beneficial.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab is intended to introduce the user both to the mathematical concept of the structure of a ring as well as the corresponding Mathematica structure Ringoid. Various properties that a ring must and can have are introduced and the Mathematica commands to explore these properties are illustrated.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.3 Getting started? Begin here
:[font = text; inactive; preserveAspect; nohscroll; ]
In most of the labs in Exploring Abstract Algebra using Mathematica, one needs to first read in extra Mathematica packages necessary to provide the functionality within the lab. This is done using a Needs statement, as below. (Usually, just reading in the AbstractAlgebra`Master` package is done.) Upon opening this notebook you were likely asked "Do you want to automatically evaluate all the initialization cells in the Notebook?". If you answered affirmatively, then you do not need to evaluate the following cell, but it doesn't hurt to do so. If you answered negatively, then you need to evaluate this cell.
:[font = input; initialization; preserveAspect; endGroup; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.4 Ringoids and rings
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider any set and two operations on that set. We will call this structure a Ringoid. An example of a Ringoid is the following:
:[font = input; preserveAspect; nowordwrap; ]
R = FormRingoid[{0, 1, 2}, Mod[#1 + #2, 3]&, Mod[#1 #2, 3]&]
:[font = text; inactive; preserveAspect; nohscroll; ]
We always refer to the first operation of a Ringoid as addition and the second as multiplication. However, there is no restriction on either of the operations. (In other words, there is no implication that the addition could not act like multiplication and the multiplication act like some other type of operation.) One can access these operations as follows:
:[font = input; preserveAspect; nowordwrap; ]
Addition[R]
Multiplication[R]
:[font = text; inactive; preserveAspect; nohscroll; ]
To compute the sum of 2 and 2, as well as the product of 2 and 2, one does as follows:
:[font = input; preserveAspect; nowordwrap; ]
Addition[R][2, 2]
Multiplication[R][2, 2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Will it always be the case that the addition and multiplication return the same value? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The set of elements in a Ringoid is obtained using either of the following methods:
:[font = input; preserveAspect; nowordwrap; ]
Elements[R]
Domain[R]
:[font = text; inactive; preserveAspect; nohscroll; ]
The operations on R are mod three addition and mod three multiplication, with which you may be very well acquainted. The operation tables for any Ringoid may be displayed with the function CayleyTables:
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[R, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
The output of CayleyTables, using the Visual mode, appears in two forms. There are two graphical objects that should resemble tables that appear in an abstract algebra text, and a pair of Mathematica lists representing the tables. If you just want to look at the graphical tables, you need to end the input cell with a semicolon (";") so that the list of list is not displayed. We will often do this from now on. On the other hand, if you are only interested in the output, you may want to drop the Mode -> Visual argument.

There are several types of Ringoids we will consider. Note that the Ringoid we called R above is simply the set of integers mod 3 with the appropriate operations. This can also be obtained by Z[3]. 
:[font = input; preserveAspect; nowordwrap; ]
Z[3]
:[font = text; inactive; preserveAspect; nohscroll; ]
For every integer n, n not equal to 1, Z[n] is the ring with domain {0, 1, . . ., n -1} and operations mod n addition and mod n multiplication. If you used some of the group labs, you may recall that we also use Z[n] for the group consisting of the same set but with just addition mod n. By default, when we work with rings, we will intend Z[n] to refer to the ring. We can always obtain the group as follows:
:[font = input; preserveAspect; nowordwrap; ]
G = Z[3, Structure -> Group]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can change the default understanding of Z[n] to be the group or ring by specifying the options for Z[n]. For example, when reading in the Mathematica code at start up, the equivalent of the following statement was evaluated.
:[font = input; preserveAspect; nowordwrap; ]
SetOptions[Z, Structure -> Ring]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
One could change Ring to Group and then Z[n] would thereafter be understood to be the group instead of the ring. (Note: the SwitchStructureTo function may also be useful.)

We will be using this family of rings extensively in this lab and subsequent labs. Other rings will be introduced as well. 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5 Properties of rings
:[font = text; inactive; preserveAspect; nohscroll; ]
We will be considering some of the properties of a ring. Execute the cell below to be given a random Z[n].
:[font = input; preserveAspect; nowordwrap; ]
n = Random[Integer, {8, 19}]
T = Z[n]
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5.1 Additive properties
:[font = text; inactive; preserveAspect; nohscroll; ]
These first few properties pertain only to the addition. To test these properties, we form the additive Groupoid consisting of the elements and the addition of the Ringoid.
:[font = input; preserveAspect; nowordwrap; ]
?AdditiveGroupoid
:[font = input; preserveAspect; nowordwrap; ]
AG = AdditiveGroupoid[T]
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Addition must be closed
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that a set H is closed under the operation * if g * h is in H for all g and h in H. We can test for this property with the function ClosedQ. We can either check the additive Groupoid or the Ringoid with a restriction on the operation. (Almost all the ring properties are related to group properties of either the additive or multiplicative Groupoid. In each case, one can check the particular Groupoid or check the Ringoid by specifying a value for the Operation option.)
:[font = input; preserveAspect; endGroup; nowordwrap; ]
ClosedQ[AG]
ClosedQ[T, Operation -> Addition]
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Addition must be associative
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that addition is associative if and only if a + (b + c) = (a + b) + c for all values of a, b, and c in the domain. We can test for this property with the function AssociativeQ.
:[font = input; preserveAspect; nowordwrap; ]
AssociativeQ[T, Operation -> Addition]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
For larger Ringoids, this test is quite time-consuming. Use of the function RandomAssociativeQ is advised for these Ringoids. This function tests random triples (a, b, c) for the associative property. If any triple violates the condition, the addition is known to be not associative. If no violation occurs, it is likely that the addition is associative.
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Addition must be commutative
:[font = text; inactive; preserveAspect; nohscroll; ]
Addition is commutative if and only if a + b = b + a for all values of a and b in the domain. You can test for this property with the function AbelianQ or CommutativeQ, but the former only works with Groupoids. (Thus, we can use AbelianQ with the additive Groupoid or use CommutativeQ on the Ringoid.)
:[font = input; preserveAspect; endGroup; nowordwrap; ]
AbelianQ[AG]
CommutativeQ[T, Operation -> Addition]
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Existence of a "zero"
:[font = text; inactive; preserveAspect; nohscroll; ]
The term zero is used for the additive identity of a ring. That is, if z is the zero, then
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
z + r = r + z = r
:[font = text; inactive; preserveAspect; nohscroll; ]
for all r in the ring. To ask whether a zero exists, use the following.
:[font = input; preserveAspect; nowordwrap; ]
HasIdentityQ[T, Operation -> Addition]
:[font = text; inactive; preserveAspect; nohscroll; ]
This test can be performed more directly as follows:
:[font = input; preserveAspect; nowordwrap; ]
HasZeroQ[T]
:[font = text; inactive; preserveAspect; nohscroll; ]
When a Ringoid has a zero, it can be called upon by name.
:[font = input; preserveAspect; nowordwrap; ]
Zero[T]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. What is the zero of Ringoid[{0, 1, 2, 3}, Mod[#1 + #2, 4] & , Mod[#1*#2, 4] & ]?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. What is the zero of Ringoid[{0, 1, 2, 3}, Mod[#1*#2, 4] & , Mod[#1 + #2, 4] & ]?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Additive inverses
:[font = text; inactive; preserveAspect; nohscroll; ]
Assuming a Ringoid has a zero z, we say r is the additive inverse of s if s + r = r + s = z. All elements of a ring must have an additive inverse. The additive inverse of s is referred to as its negation. We can ask whether all elements have an additive inverse.
:[font = input; preserveAspect; nowordwrap; ]
HasInversesQ[T, Operation -> Addition]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can also ask for a list that displays how the elements of the Ringoid pair up as inverses. As long as the addition is associative, it can be proven that no element can have more than one negation. You will find that in some cases an element is its own negation. 
:[font = input; preserveAspect; nowordwrap; ]
Inverses[T, Operation -> Addition]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. How many elements in T are their own negation? (Also, what is your ring T?)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The negation of an individual Ringoid element can be determined using NegationOf.
:[font = input; preserveAspect; nowordwrap; ]
NegationOf[T, 1]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Below, form another random Z[n], named T2. What ring did you get? For each element, determine its negation without Mathematica. Use either Inverses or NegationOf to check your work.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
n = Random[Integer, {5, 12}]
T2 = Z[n]
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5.2 Multiplicative properties
:[font = text; inactive; preserveAspect; nohscroll; ]
We will use MG for the multiplicative Groupoid of the ring T:
:[font = input; preserveAspect; nowordwrap; ]
?MultiplicativeGroupoid
:[font = input; preserveAspect; nowordwrap; ]
MG = MultiplicativeGroupoid[T]
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Multiplication must be closed
:[font = text; inactive; preserveAspect; nohscroll; ]
Not only must the addition be closed, but the multiplication must be as well. As noted above, we can either check the multiplicative Groupoid or the Ringoid and restrict the operation.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
ClosedQ[MG]
ClosedQ[T, Operation -> Multiplication]
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Multiplication must be associative
:[font = text; inactive; preserveAspect; nohscroll; ]
Besides being closed, the multiplication must also be associative.
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
AssociativeQ[T, Operation -> Multiplication]
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5.3 Distributive property
:[font = text; inactive; preserveAspect; nohscroll; ]
There is one property that considers how the addition and multiplication interact: multiplication must be distributive over addition in order for a Ringoid to be a ring. That is, we must have
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
a(b + c) = ab + ac         and         (b + c)a = ba + ca
:[font = text; inactive; preserveAspect; nohscroll; ]
for all values of a, b, and c in the domain of the Ringoid. The function DistributiveQ tests for this property.
:[font = input; preserveAspect; nowordwrap; ]
DistributiveQ[T]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
A function called RandomDistributiveQ, which is similar to RandomAssociativeQ, is also available.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5.4 Is the Ringoid a ring?
:[font = text; inactive; preserveAspect; nohscroll; ]
If all the properties we have tested up to this point are satisfied, then we can call the Ringoid a ring. We can use the function RingQ to perform all of these tests in one statement.
:[font = input; preserveAspect; nowordwrap; ]
RingQ[T]
:[font = text; inactive; preserveAspect; nohscroll; ]
As one works with a Ringoid and is testing various properties, the results are collected and can be retrieved by a function called RingInfo. Here is what we know so far about T.
:[font = input; preserveAspect; nowordwrap; ]
RingInfo[T]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Given any value of n, is Z[n] a ring? Why or why not?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.5.5 "Optional" properties
:[font = text; inactive; preserveAspect; nohscroll; ]
There are additional properties that are frequently satisfied by a ring. We will often look for rings that satisfy some combination of these properties in the future. 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Ring with unity
:[font = text; inactive; preserveAspect; nohscroll; ]
Unity is the term that is used for the multiplicative identity of a ring. That is, if u is the unity, then
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
u r = r u = r
:[font = text; inactive; preserveAspect; nohscroll; ]
for all r in the ring. To determine whether a unity exists, try the following:
:[font = input; preserveAspect; nowordwrap; ]
WithUnityQ[T]
:[font = text; inactive; preserveAspect; nohscroll; ]
If there is a unity, it can be called upon by name.
:[font = input; preserveAspect; nowordwrap; ]
Unity[T]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Does Z[n] have a unity for all values of n? Why or why not? If so, what is it?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Commutative ring
:[font = text; inactive; preserveAspect; nohscroll; ]
A ring is said to be commutative if its multiplication is commutative. (Recall that the addition must be commutative in a ring.)
:[font = input; preserveAspect; nowordwrap; ]
CommutativeQ[T, Operation -> Multiplication]
:[font = text; inactive; preserveAspect; nohscroll; ]
There are several other "optional" properties that we will introduce in the next lab.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Is Z[n] commutative for all values of n? Why or why not?
:[font = special2; inactive; preserveAspect; endGroup; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.6 Additional exercises
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. If k is a divisor of n, we use Z[n, k] to denote the Ringoid whose elements are {0, k, 2k,..., ((n/k)-1)k} with addition being mod n addition and multiplication being mod n multiplication. Is Z[8, 2] a ring? Is it commutative? Is it a ring with unity? Justify your answers.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Is Z[10, 2] a ring? Is it commutative? Is it a ring with unity? Justify your answers.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. What happens if you switch the addition and multiplication in a ring? In other words, if we have a ring R = Ringoid[D, plus, times], then is Ringoid[D, times, plus] ever a ring? Try Z[n, k] for various n and k and see if you can produce such a ring.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Evaluate the following cells. Study the multiplication tables. Can you note any differences or similarities between any of these rings?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[Z[4], Mode -> Visual];
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[Z[5], Mode -> Visual];
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[Z[6], Mode -> Visual];
:[font = input; preserveAspect; endGroup; nowordwrap; ]
CayleyTables[Z[7], Mode -> Visual];
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
1.7 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?SwitchStructureTo
:[font = input; preserveAspect; nowordwrap; ]
?FormRingoid
:[font = input; preserveAspect; nowordwrap; ]
?Addition
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?Domain
:[font = input; preserveAspect; nowordwrap; ]
?CayleyTables
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?Structure
:[font = input; preserveAspect; nowordwrap; ]
?Group
:[font = input; preserveAspect; nowordwrap; ]
?Ring
:[font = input; preserveAspect; nowordwrap; ]
?Random
:[font = input; preserveAspect; nowordwrap; ]
?AdditiveGroupoid
:[font = input; preserveAspect; nowordwrap; ]
?Operation
:[font = input; preserveAspect; nowordwrap; ]
?ClosedQ
:[font = input; preserveAspect; nowordwrap; ]
?AssociativeQ
:[font = input; preserveAspect; nowordwrap; ]
?RandomAssociativeQ
:[font = input; preserveAspect; nowordwrap; ]
?AbelianQ
:[font = input; preserveAspect; nowordwrap; ]
?CommutativeQ
:[font = input; preserveAspect; nowordwrap; ]
?HasIdentityQ
:[font = input; preserveAspect; nowordwrap; ]
?HasZeroQ
:[font = input; preserveAspect; nowordwrap; ]
?Zero
:[font = input; preserveAspect; nowordwrap; ]
?HasInversesQ
:[font = input; preserveAspect; nowordwrap; ]
?Inverses
:[font = input; preserveAspect; nowordwrap; ]
?NegationOf
:[font = input; preserveAspect; nowordwrap; ]
?MultiplicativeGroupoid
:[font = input; preserveAspect; nowordwrap; ]
?DistributiveQ
:[font = input; preserveAspect; nowordwrap; ]
?RandomDistributiveQ
:[font = input; preserveAspect; nowordwrap; ]
?RingQ
:[font = input; preserveAspect; nowordwrap; ]
?RingInfo
:[font = input; preserveAspect; nowordwrap; ]
?WithUnityQ
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Unity
^*)