(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 2. An introduction to rings: part two
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
You should complete Ring Lab 1 before attempting this lab.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goals of this lab are to familiarize you with several important types of rings and to make you aware of how to work with these rings in the context of the AbstractAlgebra packages.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3 Units & zero divisors
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3.1 Units of a ring
:[font = text; inactive; preserveAspect; nohscroll; ]
First, let's read in the code that provides the functionality needed for this lab.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
In a ring with unity, an element that has a multiplicative inverse in the ring is called a unit. The percentage of elements that are units in a ring can vary quite a bit. The unity of a ring is always a unit, and the zero of a ring is never a unit. If all the nonzero elements of a commutative ring with unity are units, the ring is called a field. We will discuss fields at length in a later lab. It is also possible for a ring to have no units other than the unity. 

We will now consider the set of units in a variety of rings.
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Units of Z[8]
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the ring Z[8]. What do the Cayley tables tell us?
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[Z[8], Mode->Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. What is the unity of the ring Z[8]? What are the units of Z[8]? Explain how you obtained your answers.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Boolean rings
:[font = text; inactive; preserveAspect; nohscroll; ]
A Boolean ring consists of the set of all subsets of a given set, combined with the operations symmetric difference for the addition, and intersection for the multiplication. Let's consider an example:
:[font = input; preserveAspect; nowordwrap; ]
R = BooleanRing[{Larry, Moe, Curly}]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is the collection of all subsets of the set {Larry, Moe, Curly}. Note the cardinality of the set.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Suppose that you replaced {Larry, Moe, Curly} with the names of the students in your class. (This would increase the average intelligence of the set by a huge factor.) How many elements would this new Ringoid have? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this Ringoid has a different approach to addition and multiplication. The following will confirm the description given above.
:[font = input; preserveAspect; nowordwrap; ]
Addition[R]
Multiplication[R]
:[font = text; inactive; preserveAspect; nohscroll; ]
The multiplication is simply the intersection of two subsets. The addition, as indicated, is the symmetric difference of two subsets. In case you need a quick review of the symmetric difference, consider the following examples:
:[font = input; preserveAspect; nowordwrap; ]
setA = {2, 3, 4}
setB = {1, 3, 4, 5}
setC = {3, 4}
:[font = input; preserveAspect; nowordwrap; ]
Addition[R][setA, setB]
Addition[R][setA, setC]
:[font = text; inactive; preserveAspect; nohscroll; ]
You should note that the symmetric difference of two sets returns the union of the two sets with the elements in the intersection removed.

Consider the Cayley tables of this ring. After the tables are produced, enlarge them (until you can see them more clearly) by selecting the graphic and then stretching from one of the corners.
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[BooleanRing[{Curly, Moe, Larry}], Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. What is the zero of this ring? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we will focus on the Boolean ring of subsets of {1, 2} and its multiplication table.
:[font = input; preserveAspect; nowordwrap; ]
R1 = BooleanRing[2]
:[font = input; preserveAspect; nowordwrap; ]
MultiplicationTable[R1, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. What is the zero for this ring? Is there a unity for this ring? If so, what is it (and explain how you obtained it); if not, explain why not.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Determine all the units for this ring.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Generalize: determine all the units for the ring BooleanRing[n].
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Gaussian integers mod n
:[font = text; inactive; preserveAspect; nohscroll; ]
The Gaussian integers, Z[i], is defined as the ring whose elements are {a + b i | a, b are in Z} and whose operations are ordinary (complex) addition and multiplication. Note that this is an infinite subring of the complex numbers.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Prove this last statement.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
We can consider a finite variation of Z[i] by reducing the elements modulo some positive integer. Try, for example, 3:
:[font = input; preserveAspect; nowordwrap; ]
R2 = Z[3, I, Structure -> Ring]
:[font = text; inactive; preserveAspect; nohscroll; ]
What can we see in the tables? (Again, enlarge the graphic so it is more visible.)
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[R2, Mode -> Visual];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. What is the zero of this ring?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Is there a unity for this ring? If so, what is it (and explain how you obtained it); if not, explain why not.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Determine all the units for this ring.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Units of a ringoid.
:[font = text; inactive; preserveAspect; nohscroll; ]
There are three basic functions related to units that can be used: UnitQ, Units and MultiplicativeInverse.
:[font = input; preserveAspect; nowordwrap; ]
?UnitQ
:[font = input; preserveAspect; nowordwrap; ]
?Units
:[font = input; preserveAspect; nowordwrap; ]
?MultiplicativeInverse
:[font = text; inactive; preserveAspect; nohscroll; ]
You can test your answer to the last question:
:[font = input; preserveAspect; endGroup; nowordwrap; ]
Units[R2]
:[font = subsubsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
Trivial ring
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the "trivial ring," for which all products are zero: 
:[font = input; preserveAspect; nowordwrap; ]
?TrivialZR
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[TrivialZR[5], Mode -> Visual];
:[font = input; preserveAspect; nowordwrap; ]
UnitQ[TrivialZR[5], 3]
:[font = text; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Since the "trivial ring" has no unity, appropriate messages are given. Observe that 3 does not have a multiplicative inverse.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3.2 Zero divisors of a ring
:[font = text; inactive; preserveAspect; nohscroll; ]
In solving a quadratic equation such as x^2- 3x -10 = 0, we routinely factor the left-hand side to (x - 5)(x + 2) and solve x - 5 = 0 and then x + 2 = 0. We are accustomed to assuming that in order for a product to be zero, one of the factors must be zero. This is an assumption that can not be made in the general theory of rings. Consider the ring of integers modulo 15, Z[15]. As can be seen from the multiplication table, there are many instances where products of nonzero elements of Z[15] are zero.
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[Z[15], Mode -> Visual, Operation -> Multiplication];
:[font = text; inactive; preserveAspect; nohscroll; ]
A zero divisor is a nonzero ring element that can produce a product of zero upon multiplication with another nonzero element. For example, in Z[15], 10 is a zero divisor because its product with 3 is zero.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Determine all the zero divisors for Z[15].
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Determine all the zero divisors for Z[11]. (If you wish, change the 15 to 11 in the CayleyTables command above.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall the two rings with which we worked earlier:
:[font = input; preserveAspect; nowordwrap; ]
R1 = BooleanRing[2]
R2 = Z[3, I, Structure -> Ring]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Determine all the zero divisors of both R1 and R2.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.3.3 Working with zero divisors
:[font = text; inactive; preserveAspect; nohscroll; ]
To work with zero divisors, one can use either of the following functions:
:[font = input; preserveAspect; nowordwrap; ]
?ZeroDivisors
:[font = input; preserveAspect; nowordwrap; ]
?ZeroDivisorQ
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is how one might test one's answer to the questions above:
:[font = input; preserveAspect; nowordwrap; ]
ZeroDivisors[Z[15]]
:[font = input; preserveAspect; nowordwrap; ]
ZeroDivisorQ[Z[15], 8]
ZeroDivisorQ[Z[15], 9]
:[font = text; inactive; preserveAspect; nohscroll; ]
The number of zero divisors can vary substantially from one Ringoid to another.
:[font = input; preserveAspect; nowordwrap; ]
ZeroDivisors[Z[11]]
:[font = input; preserveAspect; nowordwrap; ]
ZeroDivisors[TrivialZR[11]]
:[font = text; inactive; preserveAspect; nohscroll; ]
You may want to check your answers to the previous question.
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
ZeroDivisors[R1]
ZeroDivisors[R2]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.4 Integral domains
:[font = text; inactive; preserveAspect; nohscroll; ]
An integral domain is a commutative ring with unity with no zero divisors. The ring of integers is a prototypical example. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Recall the rings used in this lab thus far. Which are integral domains and which are not? Come up with at least one of each.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.5 Fields
:[font = text; inactive; preserveAspect; nohscroll; ]
A field is a commutative ring with unity with the property that every nonzero element is a unit. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Recall the rings used in this lab thus far. Which are fields and which are not? Come up with at least one of each.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.6 Additional exercises
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. What are the units of Z[20, 5]? What are the zero divisors? 
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[Z[20, 5], Mode -> Visual];
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. Using the functions provided thus far, find a Ringoid that has a unity and this element is the only nonzero element that is not a zero divisor.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. Using the functions provided thus far, find a Ringoid that has a unity and the only non-unit is the zero. Is this ring a field?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q19. True or False? In a commutative ring with unity, the intersection of units and zero divisors is always empty. Prove that your answer is correct.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
To test if a Ringoid is an integral domain or field, there are appropriate functions that can be used (besides testing the parts of the definition). The following illustrates these.
:[font = input; preserveAspect; nowordwrap; ]
IntegralDomainQ[Z[7]]
IntegralDomainQ[BooleanRing[2]]
:[font = input; preserveAspect; endGroup; nowordwrap; ]
FieldQ[Z[7]]
FieldQ[Z[15]]
FieldQ[Z[20, 4]]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
2.7 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?SwitchStructureTo
:[font = input; preserveAspect; nowordwrap; ]
?Ring
:[font = input; preserveAspect; nowordwrap; ]
?CayleyTables
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?Mode
:[font = input; preserveAspect; nowordwrap; ]
?Visual
:[font = input; preserveAspect; nowordwrap; ]
?BooleanRing
:[font = input; preserveAspect; nowordwrap; ]
?Addition
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?MultiplicationTable
:[font = input; preserveAspect; nowordwrap; ]
?Structure
:[font = input; preserveAspect; nowordwrap; ]
?UnitQ
:[font = input; preserveAspect; nowordwrap; ]
?Units
:[font = input; preserveAspect; nowordwrap; ]
?MultiplicativeInverse
:[font = input; preserveAspect; nowordwrap; ]
?TrivialZR
:[font = input; preserveAspect; nowordwrap; ]
?Operation
:[font = input; preserveAspect; nowordwrap; ]
?ZeroDivisors
:[font = input; preserveAspect; nowordwrap; ]
?ZeroDivisorQ
:[font = input; preserveAspect; nowordwrap; ]
?IntegralDomainQ
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?FieldQ
^*)