(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 3. An ideal part of rings
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Before attempting this lab, you should have completed Ring Lab 1. You should also be familiar with cosets of normal subgroups.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to develop the concept of an ideal through examples, leading one to discover some of the properties of ideals. Quotient rings are also introduced through the examples.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.3 What is the ideal part of a ring?
:[font = text; inactive; preserveAspect; nohscroll; ]
We begin by reading in a package that provides the functionality needed for the lab.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's consider a subset of the integers, Z. 
:[font = input; preserveAspect; nowordwrap; ]
H = Table[i, {i, -40, 40, 5}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we are working on a finite machine, we can only show finite subsets of Z. Imagine, however, that H extends infinitely (in both directions) with the same pattern.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Once H is extended as stated, is H a ring? Is it a subring of Z? How doyou verify this?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider multiplying every element in the (extended) set H by an element in Z, say 3.
:[font = input; preserveAspect; nowordwrap; ]
M = 3 H
:[font = text; inactive; preserveAspect; nohscroll; ]
Of course, this only shows a finite part. Are these products in the (extended) set H?
:[font = input; preserveAspect; nowordwrap; ]
Intersection[M, H]
:[font = input; preserveAspect; nowordwrap; ]
H
:[font = text; inactive; preserveAspect; nohscroll; ]
Certainly some of the elements are in the original subset H. Let's use Mathematica to enlarge our H.
:[font = input; preserveAspect; nowordwrap; ]
H = Table[i, {i, -150, 150, 5}]
SubsetQ[M, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
By enlarging H (following the given pattern), we see that M = 3 H is a subset of H.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. M was determined by multiplying by 3 on the left of every element in H. We then found that M was a subset of (the enlarged) H. Is there anything special about 3? Could this work for other integers? Does the multiplication need to occur on the left? Justify your answers.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Consider the M we found by multiplying H by 3. Actually, consider the extended M found by multiplying the extended H by 3. In other words, consider 3 <5>. Is this a ring? Is this a subring of Z? Is this a subring of (the extended) H (i.e., <5>)?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try another subset of the integers:
:[font = input; preserveAspect; nowordwrap; ]
P = Table[i, {i, -49, 50, 5}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. What happens if we multiply P on the left by 3? Call this result M (as before). What is the intersection of M and P? Adopt the notation that EX means the infinite, extended version of the finite X. (This notation will be used below as well, so take note.) What can you say about the intersection of EM and EP? Try to prove your result.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. What makes P different from H? How do they differ in their properties?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider another subset.
:[font = input; preserveAspect; nowordwrap; ]
K = Table[i, {i, -48, 50, 3}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Let M be the result of multiplying K by some integer q. Answer the kinds of questions that were asked in the questions above regarding sets H and P.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Hopefully, above you made the observation that EP and EH are both cosets in the group Z/EH, with EP = 1 + <5> while EH = <5>. (For the moment, think of Z/EH as a group and not a ring.)
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's take a look at one more example.
:[font = input; preserveAspect; nowordwrap; ]
R = Z[12]
els = Elements[R]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider two subsets of the elements of R.
:[font = input; preserveAspect; nowordwrap; ]
NR = {0, 3, 6, 9}
H = {0, 5, 7}
:[font = text; inactive; preserveAspect; nohscroll; ]
What happens if we multiply the set NR and the set H by an element r in R? Suppose we use r = 5.
:[font = input; preserveAspect; nowordwrap; ]
5 NR
5 H
:[font = text; inactive; preserveAspect; nohscroll; ]
Whoops! We need to remember that the multiplication really has to be taking place mod 12.
:[font = input; preserveAspect; nowordwrap; ]
Mod[5 NR, 12]
Mod[5 H, 12]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now repeat this for all elements r in R:
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, Mod[# NR, 12]}&, els], TableDepth -> 2, 
	TableHeadings -> {None, {"k", "k*{0,3,6,9}\n\n"}}]
	(* working with NR *)
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Map[{#, Mod[# H, 12]}&, els], TableDepth -> 2, 
	TableHeadings -> {None, {"k", "k*{0,3,6,9}\n\n"}}]
	(* working with H *)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Consider the sets NR and H and let r be any element in R. What can you say about the sets r NR and r H? What difference(s) between NR and H cause the results shown above?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.3.1 The definition:
:[font = text; inactive; preserveAspect; nohscroll; ]
Given a ring R and a subring J of the ring R, we call J a (two-sided) ideal of R if for every element r in R and for every element x in J we have both r x and x r in J.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Describe the examples of ideals that we have seen thus far.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.3.2 Another ring
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the ring of two-by-two matrices with entries from Z[2]. 
:[font = input; preserveAspect; nowordwrap; ]
M = Mat[Z[2], {2, 2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
You can count the elements; there are 16.
:[font = input; preserveAspect; nowordwrap; ]
Elements[M]
Length[Elements[M]]
:[font = text; inactive; preserveAspect; nohscroll; ]
As defined above, although M is a ring, it is not a Ringoid in Mathematica. Let's make it one.
:[font = input; preserveAspect; nowordwrap; ]
R = ToRingoid[Mat[Z[2], 2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider two subsets of R:
:[font = input; preserveAspect; nowordwrap; ]
H = {{{1, 0}, {0, 1}}, {{0, 0},{0, 0}}, {{1, 0}, {0, 0}}, 
	{{0, 0}, {0, 1}}};

MatrixForm[H]
:[font = input; preserveAspect; nowordwrap; ]
K = {{{1, 0}, {0, 1}}, {{0, 0}, {0, 0}}, {{1, 0}, {0, 0}}, 
	{{0, 0}, {0, 1}}, {{0, 0}, {1, 0}}, {{1, 0}, {1, 0}}, 
	{{0, 0}, {1, 1}}, {{1, 0}, {1, 1}}};

MatrixForm[K]
:[font = text; inactive; preserveAspect; nohscroll; ]
You can verify by hand, or check the following, that these are indeed subrings of R.
:[font = input; preserveAspect; nowordwrap; ]
SubringQ[H, R]
(* may take a little time *)
:[font = input; preserveAspect; nowordwrap; ]
SubringQ[K, R]
(* may take a little time *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Are H and K ideals? We need to pick an element in R and multiply it by an element in H (or K) and see if we land back in H (or K). For example, let M1 be the following matrix in R.
:[font = input; preserveAspect; nowordwrap; ]
(M1 = {{1, 1}, {0, 0}})//MatrixForm
:[font = text; inactive; preserveAspect; nohscroll; ]
What happens if we try multiplying as we did earlier?
:[font = input; preserveAspect; nowordwrap; ]
M1 H
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. This is a Mathematica question, not an algebraic one--answer it if you can. What went wrong?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that the multiplication of R can be obtained as follows.
:[font = input; preserveAspect; nowordwrap; ]
op = Multiplication[R];
(* no output is given *)
:[font = text; inactive; preserveAspect; nohscroll; ]
We can Map the operation op, with M1 as one of the operands, across the whole set H.
:[font = input; preserveAspect; nowordwrap; ]
Map[op[M1, #]&, H]
:[font = text; inactive; preserveAspect; nohscroll; ]
Is it true that M1 * N1 is in H for every element N1 in H? If not, what does this say about H being an ideal? If so, what does this say about H being an ideal?
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Is H an ideal? What about K?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that both H and K are normal subgroups of the additive group of R:
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
NormalQ[H, AdditiveGroupoid[R]]
NormalQ[K, AdditiveGroupoid[R]]
(* may take some time *)
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.4 Ideals factor into other ring properties
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the ring R and subset B as defined below:
:[font = input; preserveAspect; nowordwrap; ]
R = Z[15]
B = {0, 3, 6, 9, 12}
:[font = text; inactive; preserveAspect; nohscroll; ]
Observe that B is an ideal of R.
:[font = input; preserveAspect; nowordwrap; ]
IdealQ[B, R]
:[font = text; inactive; preserveAspect; nohscroll; ]
We know that B is a normal subgroup of R when we view R as an additive group. Therefore, the quotient group R/B makes sense and we can talk about the cosets as elements. Each coset has the form x + B where x is an element of R. We already know how to add cosets: (x + B) + (y + B) = x + y + B. Can we form a product with these cosets? How about multiplying x + B times y + B to yield x y + B? We need to verify that this is a valid, well-defined operation, which we leave to your text and/or classroom. With this, we can form the quotient ring (also known as the factor ring) R/B.
:[font = input; preserveAspect; nowordwrap; ]
QR = QuotientRing[R, B]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is an example of how the multiplication works:
:[font = input; preserveAspect; nowordwrap; ]
Multiplication[QR][2 + NS, 2 + NS]
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the Cayley tables of this quotient ring.
:[font = input; preserveAspect; nowordwrap; ]
CayleyTables[QR, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. To what ring is this quotient ring isomorphic?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
3.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Table
:[font = input; preserveAspect; nowordwrap; ]
?Intersection
:[font = input; preserveAspect; nowordwrap; ]
?SubsetQ
:[font = input; preserveAspect; nowordwrap; ]
?Union
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?Mod
:[font = input; preserveAspect; nowordwrap; ]
?Z
:[font = input; preserveAspect; nowordwrap; ]
?Mat
:[font = input; preserveAspect; nowordwrap; ]
?Length
:[font = input; preserveAspect; nowordwrap; ]
?FormGroupoid
:[font = input; preserveAspect; nowordwrap; ]
?FormRingoid
:[font = input; preserveAspect; nowordwrap; ]
?SubringQ
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?Map
:[font = input; preserveAspect; nowordwrap; ]
?NormalQ
:[font = input; preserveAspect; nowordwrap; ]
?IdealQ
:[font = input; preserveAspect; nowordwrap; ]
?QuotientRing
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?CayleyTables
^*)