(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; backColorRed = 49344; backColorGreen = 49344; backColorBlue = 49344; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 65535; plain; fontName = "Times New Roman"; fontSize = 12; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 5. Ring homomorphisms
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Before you start this lab, you should be familiar with Ringoids and the ideas found in Ring Labs 1 and 2, as well as normal subgroups and ideals.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This lab explores the notion of a ring homomorphism. First we define one, and then we see how one can be constructed. 

This lab is designed to be independent of the group labs on isomorphisms and homomorphisms. If you have done them, you can skip the first section of this lab, except to evaluate the inputs that define Morphoids f, g, and w.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.3 Morphoids on rings
:[font = text; inactive; preserveAspect; nohscroll; ]
A Morphoid is a Mathematica object that consists of either a function or a set of rules followed by two structured sets (Ringoids or Groupoids). The function or rules serve to map each element in the first structured set into the second one. The only principle governing construction of a Morphoid is that an actual (mathematical) function must be defined by the rules or function. To continue, let's read in the Mathematica functions that we will need for this lab.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
The way to create a Morphoid is with the function FormMorphoid. For example, to define the Morphoid from the ring Z[15] into the ring Z[30],where the image of each element x in Z[15] is 2x, we evaluate
:[font = input; preserveAspect; nowordwrap; ]
f = FormMorphoid[2# &, Z[15], Z[30]]
:[font = text; inactive; preserveAspect; nohscroll; ]
If you try to create a Morphoid with an invalid function, it will fail to be created:
:[font = input; preserveAspect; nowordwrap; ]
FormMorphoid[2# &, Z[15], Z[20]]
:[font = text; inactive; preserveAspect; nohscroll; ]
One family of built-in Morphoids is ZMap[m, n], where m and n are positive integers.
:[font = input; preserveAspect; nowordwrap; ]
?ZMap
:[font = input; preserveAspect; nowordwrap; ]
g = ZMap[15, 5, Structure -> Ring]
:[font = text; inactive; preserveAspect; nohscroll; ]
You can get a graphical representation of a Morphoid with the function VisualizeMorphoid (or by using the Visual mode of FormMorphoid).
:[font = input; preserveAspect; nowordwrap; ]
?VisualizeMorphoid
:[font = input; preserveAspect; nowordwrap; ]
VisualizeMorphoid[g, ColorCodomain -> Automatic];
:[font = text; inactive; preserveAspect; nohscroll; ]
Any pair of Ringoids can potentially have a Morphoid connecting them. Here is an example that is defined with a list of rules instead of a function.
:[font = input; preserveAspect; nowordwrap; ]
w = FormMorphoid[{{} -> 0, {1} -> 0, {2} -> 0, {1, 2} -> 1}, 
	BooleanRing[2], Z[2]]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
You may have noticed that depending on how you create a Morphoid, the first argument that appears in the output can vary. Ideally, what appears is the simplest description of the function that defines the Morphoid. As you will see later, the single rule 1->1 defines the Morphoid g (that was defined above), so the rest of the rules that define g do not need to be displayed.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.4 Ring homomorphisms
:[font = text; inactive; preserveAspect; nohscroll; ]
A homomorphism between rings R and T is a function that preserves the operations between the two rings. That is, if f is a homomorphism, then for all values of x and y selected from R,
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
f(x + y) = f(x) + f(y), and
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
f(x * y) = f(x) * f(y).
:[font = text; inactive; preserveAspect; nohscroll; ]
(Note that the operations + and * on the left-hand side occur within R, while those on the right-hand side occur within T.) If f is also one-to-one and onto, then it is an isomorphism. The existence of an isomorphism between two rings establishes them as being "equal" in an algebraic sense.

To review the notion of operation preserving, we will start by looking at the first two Morphoids (f and g) that were defined above, since their domains are the same. For both of them we use the pair of elements {11, 7} and use the function PreservesQ to see if the conditions above are satisfied when x = 11 and y = 17.
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[f, {11, 7}]
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[g, {11, 7}]
:[font = text; inactive; preserveAspect; nohscroll; ]
To see why f does not preserve operations, we can use the Visual mode.
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[f, {11, 7}, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
From this graphical representation of the tests, we see that the addition condition is satisfied, but the multiplication condition fails: f(11 * 7) = 4 but f(11) * f(7) = 8. Therefore, f is not a ring homomorphism. Although g did preserve the operations for the pair {11, 7}, we can not conclude that g is a homomorphism, since the conditions were checked for only one of the 152 = 225 pairs of values that need to be checked. MorphismQ will check them all at once. 
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[g, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. The third Morphoid that was defined in the first section of this lab is also not a homomorphism. Explain why this is the case with a specific example that shows it is not.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.5 The kernel and image
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.5.1 The kernel
:[font = text; inactive; preserveAspect; nohscroll; ]
Since every ring "contains" the additive group consisting of the domain and the addition operation, a ring homomorphism can also be viewed as a group homomorphism. This observation extends to the more general structures of a Morphoid on a Ringoid and a Morphoid on a Groupoid. If you have already studied group homomorphisms, you are aware of the concept of the kernel. In the group setting, the kernel of a homomorphism is the set of elements in the domain that map onto the identity of the codomain. With rings, the additive identity is the zero of the ring. Therefore it is natural to make the following definition: the kernel of a ring homomorphism is the set of elements in the domain that map onto the zero of the codomain.

Our first true ring homomorphism was called g. What is its kernel? The Visual mode of Kernel should clearly illustrate the elements in the kernel.
:[font = input; preserveAspect; nowordwrap; ]
Kernel[g, Mode -> Visual]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. First, review the definition of an ideal. Without making any assumptions about the kernel (except its definition), answer the following questions.

(a) If h is a ring homomorphism and r and s are in K = Kernel[h], explain why r - s must also be in K.

(b) If h is a ring homomorphism and r is in K = Kernel[h] and s is in the domain of h, explain why r s and s r must also be in K.

(c) Properties from (a) and (b) above imply what about the kernel? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Kernel returns a result that is a Ringoid. It is a well-defined Mathematica function, provided the codomain has a zero.
:[font = input; preserveAspect; nowordwrap; ]
f
Kernel[f]
:[font = input; preserveAspect; nowordwrap; ]
w
Kernel[w]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. What conclusions, if any, can be drawn from the observations made in question 2 and the values of Kernel[f] and Kernel[w]? Assume that you do not know whether f or w is a homomorphism.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.5.2 The image
:[font = text; inactive; preserveAspect; nohscroll; ]
The image of a ring homomorphism is the range of the function, but it inherits the operation of the codomain and is also a Ringoid. For our first homomorphism, g, the image is the whole codomain, which is quite common.
:[font = input; preserveAspect; nowordwrap; ]
Image[g]
:[font = text; inactive; preserveAspect; nohscroll; ]
Although a Morphoid that is not a homomorphism can have an image, and that image may also be a subring (as we see with f that we defined above), there is no guarantee that it will be a subring.
:[font = input; preserveAspect; nowordwrap; ]
Image[f]
ClosedQ[%]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. Find an example of a Morphoid of rings for which the image is not a subring of the codomain.
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.6 The kernel is an ideal
:[font = text; inactive; preserveAspect; nohscroll; ]
It was observed at the conclusion of question 2 that the kernel of a ring homomorphism is an ideal of the domain. This closely parallels the situation with groups. The kernel of a group homomorphism is a normal subgroup. Ideals and normal subgroups are precisely the subsets of their respective systems that allow quotient systems of cosets. We will illustrate this situation in the ring case here.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.6.1 Example 1
:[font = text; inactive; preserveAspect; nohscroll; ]
Our first true ring homomorphism was called g. 
:[font = input; preserveAspect; nowordwrap; ]
g

Kernel[g]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can create the quotient ring with QuotientRing.
:[font = input; preserveAspect; nowordwrap; ]
QR = QuotientRing[Z[15], Kernel[g]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The theory that has lead up to this point assures us that QR is a ring.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. To what common ring is QR isomorphic?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Your response to the question above should be implied by the following theorem. (The proof of this appears in nearly every introductory abstract algebra text.)
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.6.2 The First Isomorphism Theorem (for rings)
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Theorem Let f : R -> S be a surjective (onto) homomorphism of rings with kernel K. Then the quotient ring R/K is isomorphic to the image of f, with the isomorphism g : R/K -> f(R) defined by g(a + K) = f(a).
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.6.3 Example 2
:[font = text; inactive; preserveAspect; nohscroll; ]
In our second example, we will define and work with a Morphoid based on a direct product.
:[font = input; preserveAspect; nowordwrap; ]
R = DirectProduct[Z[3], Z[5]]
:[font = text; inactive; preserveAspect; nohscroll; ]
We define a Morphoid from Z[30] into R.
:[font = input; preserveAspect; nowordwrap; ]
beta = FormMorphoid[{Mod[#, 3], Mod[#, 5]}&, Z[30], R]
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[beta]
:[font = input; preserveAspect; nowordwrap; ]
K = Kernel[beta]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Based on the size of the kernel, how many elements should we expect to have in the quotient ring Z[30]/K? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
We can generate the quotient ring to verify your conjecture from the last question.
:[font = input; preserveAspect; nowordwrap; ]
Q2 = QuotientRing[Z[30], Elements[K]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Based on the First Isomorphism Theorem, to what ring is the quotient ring isomorphic?
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.7 One rule Morphoids
:[font = text; inactive; preserveAspect; nohscroll; ]
It was noted earlier that ZMap[15, 5] and similar expressions form Morphoids with a single rule displayed. Internally, the Morphoid is actually defined with a function, but the rule may be somewhat shorter, so for simplicity we display the rule.
:[font = input; preserveAspect; nowordwrap; ]
h = ZMap[4, 2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. (a) Assuming that h is a morphism, which is true, explain how and why the rule 1 -> 1 determines rules for the other elements in Z[4]. (What are the other rules?)

(b) Explain what goes wrong with ZMap[3, 2] and why 1 -> 1 can not define a morphism.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.8 The Chinese Remainder Theorem
:[font = text; inactive; preserveAspect; nohscroll; ]
The image of the homomorphism beta, considered before the last section, was the direct product of Z[3] with Z[5]. This direct product happens to be isomorphic to Z[15]. This follows from the Chinese Remainder Theorem.

Chinese Remainder Theorem. If m1, m2, ..., mr are positive integers such that no two have a common divisor greater than one, then the ring Z[m1m2...mr] is isomorphic to the direct product of the rings Z[m1], Z[m2], ..., and Z[mr].

We will not provide the complete proof of this theorem since it appears in many standard texts. We will, however, describe one approach from a computational point of view, using our previous example.

An isomorphism from Z[15] into Z[3] x Z[5] is easy to construct. We map each element of Z[15] into the pair of remainders upon division by 3 and 5 respectively.
:[font = input; preserveAspect; nowordwrap; ]
theta = FormMorphoid[{Mod[#, 3], Mod[#, 5]}&, Z[15], R]
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[theta]
:[font = text; inactive; preserveAspect; nohscroll; ]
For our specific case, the matter is settled. In the general situation, if we were to define a similar function from Z[m1m2...mr] into the direct product, it is not totally clear that the function would be one-to-one and onto. This can be proven, however, and there is an algorithm that determines the inverse of the function. The inverse, which is not as simple to compute, is available as a function called ChineseRemainderTheorem in the NumberTheory`NumberTheoryFunctions package. Let's load this package and learn about this function.
:[font = input; preserveAspect; nowordwrap; ]
Needs["NumberTheory`NumberTheoryFunctions`"];

?ChineseRemainderTheorem
:[font = text; inactive; preserveAspect; nohscroll; ]
In our example, we might want to know what the inverse image of {2, 3} is; that is, for what integer n is theta[n] equal to {2, 3}. We use {2, 3} for the first argument and {3, 5} for the second, since 3 and 5 are two moduli used to form the codomain of theta.
:[font = input; preserveAspect; nowordwrap; ]
ChineseRemainderTheorem[{2, 3}, {3, 5}]
:[font = text; inactive; preserveAspect; nohscroll; ]
This says that 8 is the smallest integer congruent to 2 mod 3 and also congruent to 3 mod 5. We can easily verify this result.
:[font = input; preserveAspect; nowordwrap; ]
theta[8]
:[font = text; inactive; preserveAspect; nohscroll; ]
The inverse function can be used to create an inverse isomorphism
:[font = input; preserveAspect; nowordwrap; ]
gamma = FormMorphoid[ChineseRemainderTheorem[#, {3, 5}]&, R, Z[15]]
:[font = input; preserveAspect; nowordwrap; ]
IsomorphismQ[gamma]
:[font = text; inactive; preserveAspect; nohscroll; ]
Of course, we should also verify that gamma is really the inverse of theta.
:[font = input; preserveAspect; nowordwrap; ]
MorphoidComposition[theta, gamma]
:[font = input; preserveAspect; nowordwrap; ]
MorphoidComposition[gamma, theta]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. Explain why the last two results verify that these two functions are inverses.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The power of the ChineseRemainderTheorem function may not be clear, since our original function was based on a relatively small set. Here is a question for which the Chinese Remainder Theorem can be employed.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Suppose that Franklin Street Clothing is having a sale. You give x dollars to person A, who then buys as many $19 shirts as possible with the x dollars and then has $3 left over. You also give x dollars to person B, who then buys as many $29 sweat shirts as possible with the x dollars and then has $26 left over. What is the least positive number of dollars that x could be? Explain how the answer to this problem can be obtained using isomorphisms.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
We finish up the lab with a couple of follow-up questions.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. Does the Chinese Remainder Theorem tell us that Z[12] is isomorphic to the direct product of Z[2] and Z[6]? Explain your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Explain, from what we have done in this lab, why the rings Z[30]/{0,15} and Z[15] are isomorphic.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
5.9 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?FormMorphoid
:[font = input; preserveAspect; nowordwrap; ]
?ZMap
:[font = input; preserveAspect; nowordwrap; ]
?Structure
:[font = input; preserveAspect; nowordwrap; ]
?VisualizeMorphoid
:[font = input; preserveAspect; nowordwrap; ]
?Ring
:[font = input; preserveAspect; nowordwrap; ]
?BooleanRing
:[font = input; preserveAspect; nowordwrap; ]
?PreservesQ
:[font = input; preserveAspect; nowordwrap; ]
?MorphismQ
:[font = input; preserveAspect; nowordwrap; ]
?Kernel
:[font = input; preserveAspect; nowordwrap; ]
?Image
:[font = input; preserveAspect; nowordwrap; ]
?ClosedQ
:[font = input; preserveAspect; nowordwrap; ]
?QuotientRing
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?DirectProduct
:[font = input; preserveAspect; nowordwrap; ]
?IsomorphismQ
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?ChineseRemainderTheorem
^*)