(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 6. Polynomial rings
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To work on this lab, you need only a cursory familiarity with Ringoids, mostly just Z[n]. 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to help one discover some of the basic properties of polynomial algebra over a ring, through division and the GCD function. Factorization is discussed in detail in Ring Lab 7.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.3 An introduction to polynomials
:[font = text; inactive; preserveAspect; nohscroll; ]
To get started, let's read in the package that provides the functionality needed for this lab.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the polynomial p = x^2 + 3x - 4. This type of expression has been familiar to you for many years. You should know how to factor this, as well as how to graph y = p.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. How does one factor this? What does the graph of y look like? Try also to get Mathematica to do both of these tasks.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
With the polynomial p, we implicitly considered viewing this as having coefficients coming from the integers (or possibly real numbers). Do we need to confine our coefficients to the integers, rationals, reals or complex numbers? No.

Let R be any commutative ring. We define the ring of polynomials over R in the indeterminate x as the set of all (formal) symbols of the form
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
a_n x^n + a_(n-1) x^(n-1) + ... + a_2 x^2 + a_1 x + a_0
:[font = text; inactive; preserveAspect; nohscroll; ]
where the coefficients ai are from the ring R and n is a nonnegative integer. We denote this ring of polynomials by R[x].

In Mathematica, we can create a ring of polynomials as follows.
:[font = input; preserveAspect; nowordwrap; ]
P = PolynomialsOver[Z[7]]
:[font = text; inactive; preserveAspect; nohscroll; ]
The ring P is the set of all polynomials whose coefficients come from Z[7].
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Why don't we list all the elements? How many are there?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The first thing we need to think about when working with polynomials is to be able to distinguish when two elements are different or the same. Suppose we have a polynomial f(x) of the form
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
a_n x^n + a_(n-1) x^(n-1) + ... + a_2 x^2 + a_1 x + a_0.
:[font = text; inactive; preserveAspect; nohscroll; ]
In this case, if an is not zero, we say f(x) has degree n and we call the coefficient an the leading coefficient. We will say that the two polynomials f(x) and g(x) =
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
b_m x^m + b_(m-1) x^(m-1) + ... + b_2 x^2 + b_1 x + b_0
:[font = text; inactive; preserveAspect; nohscroll; ]
are equal if n = m (i.e., they have the same degree) and if ai = bi for all i <= n. Note that what is important in a polynomial is only the list of coefficients used; the variable (and its powers) act merely as place holders, indicating the position of the coefficients. Thus, in Mathematica, one way we create a polynomial is to simply give the function Poly a sequence of coefficients, prefixed by the ring from which the coefficients come. For example,
:[font = input; preserveAspect; nowordwrap; ]
Clear[x]
p = Poly[Z[7], 6, 1, 0, 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
yields the polynomial 2x^3 + x + 6. In this case, the indeterminate is denoted by x. You can specify some other indeterminate:
:[font = input; preserveAspect; nowordwrap; ]
Clear[y]
p2 = Poly[Z[7], 6, 1, 0, 2, Indeterminate -> y]
:[font = text; inactive; preserveAspect; nohscroll; ]
One can also enter a polynomial directly:
:[font = input; preserveAspect; nowordwrap; ]
p3 = Poly[Z[7], 2x^3 + x + 6]
:[font = text; inactive; preserveAspect; nohscroll; ]
It is important to remember to specify the ring from which the coefficients come. If this is forgotten, the expression will be returned as entered (which is a standard Mathematica means for communicating that the input is unsuitable).
:[font = input; preserveAspect; nowordwrap; ]
p4 = Poly[2x^3 + x + 6]
:[font = text; inactive; preserveAspect; nohscroll; ]
As usual, asking for information about a function is often useful.
:[font = input; preserveAspect; nowordwrap; ]
?Poly
:[font = text; inactive; preserveAspect; nohscroll; ]
In particular, note that if you are accustomed to entering polynomials, as well as viewing them, the way Mathematica returns them, you will feel at home with the default setting of PowersIncrease. On the other hand, if you prefer to have the powers of the polynomial increase from right to left for both input and output, you may wish to use SetOptions and change the default on PowersIncrease. Note how this option works:
:[font = input; preserveAspect; nowordwrap; ]
Poly[Z[5], 1, 2, 3]
Poly[Z[5], 1, 2, 3, PowersIncrease -> RightToLeft]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that both the input method (when just giving a sequence of coefficients) and the output display is governed by this option. Based on the method you prefer, evaluate ONE of the following two cells:
:[font = input; preserveAspect; nowordwrap; ]
SetOptions[Poly, PowersIncrease -> LeftToRight]
(* output will be similar to 1 + 2x + 3x^2 *)
:[font = input; preserveAspect; nowordwrap; ]
SetOptions[Poly, PowersIncrease -> RightToLeft]
(* output will be similar to 3x^2 + 2x + 1 *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the polynomial r as defined below:
:[font = input; preserveAspect; nowordwrap; ]
r = Poly[Z[7], 7x^4 - 4x + 4x^2 + 9]
:[font = text; inactive; preserveAspect; nohscroll; ]
When the base ring is Z[n], polynomials can be entered with coefficients from the integers (positive or negative) and they will be reduced mod n. (This property can be turned off by adding the option FlexibleEntering -> False.)
:[font = text; inactive; preserveAspect; nohscroll; ]
Finally, recall the Boolean ring over {a, b} and consider the following polynomials:
:[font = input; preserveAspect; nowordwrap; ]
Clear[a, b]
R3 = BooleanRing[{a, b}]
:[font = input; preserveAspect; nowordwrap; ]
s1 = Poly[R3, {b}, {a, b}, {}, {b}]
:[font = input; preserveAspect; nowordwrap; ]
s2 = Poly[R3, {c}, {a, b, c}, {y}, {b}]
:[font = text; inactive; preserveAspect; nohscroll; ]
When a polynomial is constructed, the coefficients are checked for membership against the base ring; an error message is given if the polynomial is ill-formed.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Construct a well-formed and an ill-formed third-degree polynomial over Z[10].
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's pick a couple of random polynomials of degree 3. (Recall that P is our extension ring of polynomials over Z[7].)
:[font = input; preserveAspect; nowordwrap; ]
a = RandomElement[P, 3]
b = RandomElement[P, 3]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. List your polynomials. You should have a reasonable guess or idea how to add these two polynomials. Do so (by hand). Also, determine their product.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
In the ring of polynomials, there is a built-in addition and multiplication. Let's define some Mathematica aliases for these functions in our ring of polynomials over Z[7]:
:[font = input; preserveAspect; nowordwrap; ]
add = Addition[P];
mult = Multiplication[P];
(* no output is given *)
:[font = text; inactive; preserveAspect; nohscroll; ]
Now, let's add and multiply a and b (and note that this should check your answers from above):
:[font = input; preserveAspect; nowordwrap; ]
add[a, b]
mult[a, b]
:[font = text; inactive; preserveAspect; nohscroll; ]
Conventional notation works as well:
:[font = input; preserveAspect; nowordwrap; ]
a + b
a b
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. What is the degree of the product of polynomials a and b?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The Degree function will determine the degree of a polynomial.
:[font = input; preserveAspect; nowordwrap; ]
Degree[Poly[Z[8], 4x^2 + 7x - 2]]
:[font = input; preserveAspect; nowordwrap; ]
Degree[a b]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. What are the constant polynomials in P? (These are the polynomials without the indeterminate x.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Does this ring of polynomials over Z[7] have a zero? What about a unity? If you answered yes to either, what are they?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Can one add two polynomials of degree k and obtain a sum of a lower degree? Try the code below once or twice (or more times, if you feel it necessary) and consider the results. If this can not happen, explain why not; if it can, cite circumstances under which it can.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
Print["Let d(p) be the degree of the polynomial p:"];
Table[a = RandomElement[P, 2];
b = RandomElement[P, 2];
{a, b, {Degree[a], Degree[b]}, Degree[a + b]},
	{25}]//TableForm[#, TableHeadings -> 
	{None, {"polynomial a", "polynomial b", "{d(a), d(b)}", "d(a + b)\n"}},
	TableSpacing -> {0, 3}, TableDepth -> 2]&
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. What happens when one multiplies a polynomial of degree 3 with one of degree 2? What is the degree of the product? Try the code below once or twice (or more times, if you feel it necessary) and consider the results. Explain your conclusion.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
Table[a = RandomElement[P, 3];
b = RandomElement[P, 2];
{a, b, Degree[P, Multiplication[P][a, b]]},
	{20}]//TableForm[#, TableHeadings -> 
	{None, {"polynomial a","polynomial b","d(a * b)\n"}},
	TableSpacing -> {0, 3}]&
:[font = text; inactive; preserveAspect; nohscroll; ]
Since P is the ring of all polynomials over Z[7], we can ask about the Zero and Unity of this ring.
:[font = input; preserveAspect; nowordwrap; ]
{z, u} = {Zero[P], Unity[P]}
:[font = text; inactive; preserveAspect; nohscroll; ]
Of course, we need to be careful about how we interpret what we see here. If we ask if z is equal to the number 0 and if u is equal to the number 1, we get the following:
:[font = input; preserveAspect; nowordwrap; ]
z === 0
u === 1
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Explain these results.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's shift gears for a moment and consider polynomials over Z[6] and look at two polynomials and their product in this context.
:[font = input; preserveAspect; nowordwrap; ]
P2 = PolynomialsOver[Z[6]]
a = Poly[Z[6], 3x^3 + x^2 + x + 1]
b = Poly[Z[6], 2x^2 + 5]
a b
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. What can you surmise from this example? Look carefully at the output. Give another example of a similar occurrence in the ring of polynomials over Z[6].
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.4 Divide and conquer
:[font = text; inactive; preserveAspect; nohscroll; ]
The main reason why arithmetic with polynomials is interesting (and so similar to integer arithmetic) is due to the division property. The division property is often referred to as the Division Algorithm in algebra texts.
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's do some quick reviewing of familiar territory before looking at general polynomial rings.
:[font = text; inactive; preserveAspect; nohscroll; ]
When we divide 159 by 13, we seek to find the number of times we can multiply 13 and still remain less than 159. Or in the vernacular, "How many times does 13 go into 159?". In this case, 12 times 13 equals 156, leaving a remainder of 3:
:[font = input; preserveAspect; nowordwrap; ]
159 == 13 12 + 3
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that we have written 159 as the product of an integer times 13 plus a remainder whose value is less than 13.
:[font = text; inactive; preserveAspect; nohscroll; ]
Now consider the polynomials (over the integers)
:[font = input; preserveAspect; nowordwrap; ]
a = x^3 + 5 x^2 - 3x + 8
b = x - 7
:[font = text; inactive; preserveAspect; nohscroll; ]
What do we get when we divide a by b? In other words, can we write a = b q + r for some polynomials q and r? 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. You should know how to do this by hand. Do so and report your results.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Mathematica has some built-in functions to find the quotient and remainder when considering polynomials over the integers (as well as some other standard rings):
:[font = input; preserveAspect; nowordwrap; ]
q = PolynomialQuotient[a, b, x]
r = PolynomialRemainder[a, b, x]
:[font = text; inactive; preserveAspect; nohscroll; ]
Do these work as we suppose?
:[font = input; preserveAspect; nowordwrap; ]
a == b q + r
:[font = text; inactive; preserveAspect; nohscroll; ]
We need to do some coaxing:
:[font = input; preserveAspect; nowordwrap; ]
a == Expand[b q + r]
:[font = text; inactive; preserveAspect; nohscroll; ]
To consider equivalent functionality over arbitrary rings, we need to use the functions built into the packages that were read in at the beginning. In this scenario, we use the function PolynomialDivision. Here, we define polynomials a and b in the ring of polynomials over Z[7].
:[font = input; preserveAspect; nowordwrap; ]
a = Poly[Z[7], x^4 + 5x^2 + 3x + 4]
b = Poly[Z[7], x^2 + 3x + 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Try your hand, using paper and pencil, at determining the quotient and remainder of a divided by b. Confirm your results with the following cell.
:[font = input; preserveAspect; nowordwrap; ]
(* do by hand first *)
{q, r} = PolynomialDivision[a, b]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can test this result by multiplying the quotient q times b, and then adding the remainder r.
:[font = input; preserveAspect; nowordwrap; ]
a == b * q + r
:[font = text; inactive; preserveAspect; nohscroll; ]
Often it's only necessary to know the remainder or the quotient. The built-in functions used above also have extensions in this package.
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialQuotient
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialRemainder
:[font = input; preserveAspect; nowordwrap; ]
PolynomialQuotient[a, b]
PolynomialRemainder[a, b]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's consider another example by changing b to a linear polynomial
:[font = input; preserveAspect; nowordwrap; ]
a = Poly[Z[7], 4x^4 + 3x^3 + 5x^2 + 1]
b = Poly[Z[7], x - 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that x - 3 is the same polynomial as x + 4 in the ring of polynomials over Z[7].
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Use long division to determine the quotient and remainder. Now evaluate the polynomial a at the value 3.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
To evaluate any polynomial, one simply substitutes in the value and computes in the ring. In this case, we reduce mod 7 as we go. Try it. One can also use the following function.
:[font = input; preserveAspect; nowordwrap; ]
PolynomialEvaluation[a, 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now compare this to the following:
:[font = input; preserveAspect; nowordwrap; ]
PolynomialRemainder[a, b]
:[font = text; inactive; preserveAspect; nohscroll; ]
Why did we divide by x - 3 and evaluate at 3? See if you can see why with a couple more examples.

Let's change our b to a different linear polynomial. We divide and examine the remainder:
:[font = input; preserveAspect; nowordwrap; ]
b = Poly[Z[7], x - 2]
PolynomialRemainder[a, b]
:[font = text; inactive; preserveAspect; nohscroll; ]
Also, evaluate a when x is given the value 2.
:[font = input; preserveAspect; nowordwrap; ]
PolynomialEvaluation[a, 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
And again, one more time, over a different ring.
:[font = input; preserveAspect; nowordwrap; ]
a = Poly[Z[13], 4x^4 + 3x^3 + 5x^2 + 1]
b = Poly[Z[13], x + 5]
PolynomialEvaluation[a, 8]
PolynomialRemainder[a, b]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Can you make a conjecture based on the examples above? You may wish to try some other linear polynomials. Note that you need to determine where to evaluate the polynomial and this depends on the linear polynomial. What is this relationship? 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q15. Suppose that a = f(x) and b = x - k. Based on your answer to the previous question, what can you say about the remainder r when we have f(k) = 0? (Consider the example below, if you wish.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
a = Poly[Z[7], x^4 + 2x^3 + 2x^2 + 1]
b = Poly[Z[7], x - 3]
PolynomialEvaluation[a, 3]
PolynomialRemainder[a, b]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q16. In all the examples we have encountered, what is the relationship between the degree of the remainder r and the degree of the divisor b?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now let's fix a polynomial and consider the zeros of the polynomial over various rings Z[n]. By a zero, we mean a value such that the polynomial evaluates to the zero of the base ring (which, in Z[n], is 0). For example, consider the polynomial x^2 + 3x + 2.
:[font = input; preserveAspect; nowordwrap; ]
p = x^2 + 3x + 2
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider finding the zeros for this polynomial over Z[15], Z[17] and Z[37].
:[font = input; preserveAspect; nowordwrap; ]
Zeros[Poly[Z[15], p]]
Zeros[Poly[Z[17], p]]
Zeros[Poly[Z[37], p]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose we consider all Z[k] for k = 2 to k = 11:
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[{k, Zeros[Poly[Z[k], x^2 + 3x + 2]]}, {k, 2, 11}],
	TableHeadings -> {None, {"k", "zeros over Z[k]\n"}},
	TableDepth -> 2, TableSpacing -> {0, 3}]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q17. While several indices k resulted in 4 zeros, most resulted in 2. For those that yielded only 2, is there anything significant about the two zeros? What is the explanation for this?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that finding zeros is a special case of solving an equation set equal to zero:
:[font = input; preserveAspect; nowordwrap; ]
Solve[Poly[Z[11], x^2 + 3x + 2] == 0]
:[font = text; inactive; preserveAspect; nohscroll; ]
Of course, we can also solve equations involving other constants:
:[font = input; preserveAspect; nowordwrap; ]
solns = Solve[Poly[Z[11], x^2 + 3x + 2] == 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can also verify the solutions. (Recall that x + 3 /. {x -> 5} results in 8.)
:[font = input; preserveAspect; nowordwrap; ]
x + 3 /. {x -> 5}
:[font = input; preserveAspect; nowordwrap; ]
Poly[Z[11], x^2 + 3x + 2] /. solns
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's try another polynomial:
:[font = input; preserveAspect; nowordwrap; ]
TableForm[Table[{k, Zeros[Poly[Z[k], 3x^3 + x^2 + 3x + 2]]}, {k, 2, 11}],
	TableHeadings -> {None, {"k", "zeros over Z[k]\n"}},
	TableDepth -> 2, TableSpacing -> {0, 3}]

(* an empty list indicates no zeros *)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q18. By modifying the code above, try another polynomial and/or other rings to see if you can determine a relationship between the (maximum) number of zeros and the index k of the ring Z[k] under consideration.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.4.1 The Euclidean Algorithm
:[font = text; inactive; preserveAspect; nohscroll; ]
The greatest common divisor of two polynomials, a and b, b not zero, can be determined using the fact that if r is the result of PolynomialRemainder[a, b] then gcd(a, b) = gcd(b, r). This is a polynomial extension of what you have already seen with integers. In other words, if a = 24 and b = 40, we know that gcd(a, b) = 8. Below is how we use Mod, which is the integer equivalent to PolynomialRemainder, to implement the Euclidean Algorithm. First, define a and b.
:[font = input; preserveAspect; nowordwrap; ]
a = 40
b = 24
:[font = text; inactive; preserveAspect; nohscroll; ]
Calculate the new values for a and b. Let the new a become the old b and the new b become the remainder upon dividing a by b (Mod[a, b]). Now call these values a and b again.
:[font = input; preserveAspect; nowordwrap; ]
newa = b
newb = Mod[a, b]
{a, b} = {newa, newb}
:[font = text; inactive; preserveAspect; nohscroll; ]
Repeat.
:[font = input; preserveAspect; nowordwrap; ]
newa = b
newb = Mod[a, b]
{a, b} = {newa, newb}
:[font = text; inactive; preserveAspect; nohscroll; ]
Repeat.
:[font = input; preserveAspect; nowordwrap; ]
newa = b
newb = Mod[a, b]
{a, b} = {newa, newb}
:[font = text; inactive; preserveAspect; nohscroll; ]
You are done when the remainder (newb) becomes 0; the gcd is then the last nonzero remainder (b).
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q19. Employ this algorithm by verifying that the gcd of 21 and 13 is 1.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q20. Employ the Euclidean Algorithm for polynomials to determine the gcd of the polynomials x^4 + 2x^3 + 2x^2 + 2 and x^4 + 3x^3 + 3x^2 + 3x + 2, both over Z[5]; see below.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
a = Poly[Z[5], x^4 + 2x^3 + 2x^2 + 2]
b = Poly[Z[5], x^4 + 3x^3 + 3x^2 + 3x + 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
You might find this cell handy:
:[font = input; preserveAspect; endGroup; nowordwrap; ]
newa = b
newb = PolynomialRemainder[a, b]
{a, b} = {newa, newb}
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.4.2 Another approach
:[font = text; inactive; preserveAspect; nohscroll; ]
Algorithms are great things to instruct computers to do. The Euclidean Algorithm has been implemented in the function PolynomialGCD:
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
PolynomialGCD[a, b]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
6.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialsOver
:[font = input; preserveAspect; nowordwrap; ]
?Poly
:[font = input; preserveAspect; nowordwrap; ]
?Indeterminate
:[font = input; preserveAspect; nowordwrap; ]
?PowersIncrease
:[font = input; preserveAspect; nowordwrap; ]
?LeftToRight
:[font = input; preserveAspect; nowordwrap; ]
?Equal
:[font = input; preserveAspect; nowordwrap; ]
?BooleanRing
:[font = input; preserveAspect; nowordwrap; ]
?RandomElement
:[font = input; preserveAspect; nowordwrap; ]
?Addition
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?Degree
:[font = input; preserveAspect; nowordwrap; ]
?Zero
:[font = input; preserveAspect; nowordwrap; ]
?Unity
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialQuotient
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialRemainder
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialDivision
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialEvaluation
:[font = input; preserveAspect; nowordwrap; ]
?Zeros
:[font = input; preserveAspect; nowordwrap; ]
?Solve
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?PolynomialGCD
^*)