(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; backColorRed = 49344; backColorGreen = 49344; backColorBlue = 49344; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 65535; plain; fontName = "Times New Roman"; fontSize = 12; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 11. Quadratic field extensions
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.2 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should be familiar with the construction of quotient rings of the ring of polynomials over a field F. You should also be familiar with irreducible polynomials over a field. This lab does not presume any other prior knowledge of field extensions. Doing Ring Lab 10 would be helpful, but not necessary.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.3 Goals of this Lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to provide some experience in working with quadratic field extensions in order to make the general study of finite field extensions easier to understand.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.4 The general problem
:[font = text; inactive; preserveAspect; nohscroll; ]
Not every polynomial with real coefficients has real roots; the simplest example is p(x) = x^2 + 1. To find the roots of p(x), we extend the real numbers to the complex numbers. That is, we construct a field that contains the real numbers but also includes some new elements that are roots of p(x). This process of extending a field can be employed to find roots of any nonconstant polynomial over any field. When the polynomial is quadratic, the smallest extension containing a root of this polynomial takes on a simple form.

The general problem we will consider is to find the roots of a quadratic polynomial p(x)=ax^2 + bx  + c, where a, b, and c are elements of a field F, with a is not 0. Recall that t is a root of p(x) if p(t) = 0. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Prove that if p(x) has one root in F, then it will also have a second root (possibly identical to the first) in F.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
The case when p(x) has its two roots in F is not very interesting. Therefore, consider the case where p(x) has no roots in F; that is, p(x) is irreducible over F. Suppose we have a "larger" field that contains F and also contains a root, z, of p(x) = ax^2 + bx + c. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Prove that all positive powers of z can be written in the form s z + t where s and t are elements of F. Hint: start with z^2 and then proceed by induction.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
The result expressed in question 2 tells us exactly what the elements of the smallest extension field look like. A few loose ends may need to be tied together, but you should be able to see that this new field, a quadratic extension of F, is
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
F[z]= {s z + t | s, t in F}
:[font = text; inactive; preserveAspect; nohscroll; ]
where 
					
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
(s z + t) + (s' z + t') = (s + s')z + (t + t') 
:[font = text; inactive; preserveAspect; nohscroll; ]
and
:[font = text; inactive; preserveAspect; nohscroll; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; plain; fontName = "Times New Roman"; fontSize = 14; ]
(s z + t)(s' z + t') = r z + u. 
:[font = text; inactive; preserveAspect; nohscroll; ]
How do we get the product r z + u? This calculation was described in Ring Lab 10, so here we will just review the process.

First think of (s z + t) (s' z + t') simply as a product of two polynomials. We expand this product into a quadratic and then divide by p(x). The remainder from this division is our product, r z + u.
:[font = subsection; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.3.1 Example
:[font = text; inactive; preserveAspect; nohscroll; ]
Suppose that F is the field of rational numbers, Q, and p(x) = x^2 - x - 1. If W is a root of p(x), the product of 2W + 5 and 3W - 7 in Q[W] is 7W - 29. 
:[font = input; preserveAspect; nowordwrap; ]
Clear[W]
PolynomialRemainder[(2W + 5) (3W - 7), W^2 - W - 1, W]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. In the quadratic extension of the rational numbers that contains W, determine the values of Wn, for n = 2, 3, 4, 5, 6, 7. Can you identify a pattern? An example of how to calculate the value of W3 is given below.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = input; preserveAspect; nowordwrap; ]
PolynomialRemainder[W^3, W^2 - W - 1, W]
:[font = text; inactive; preserveAspect; nohscroll; ]
Alternatively, we can ask Mathematica to find the real roots of p(x). 
:[font = input; preserveAspect; nowordwrap; ]
Clear[x]
Solve[x^2 - x - 1 == 0, x]
:[font = text; inactive; preserveAspect; nohscroll; ]
We select the first root that is provided and call it w. Are Q[w] and Q[W] the same? Not really, but they are isomorphic. 
:[font = input; preserveAspect; nowordwrap; ]
w = x /. (Solve[x^2 - x - 1 == 0, x]//First)
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we can verify that the product (2w + 5) (3w - 7) is consistent with the product computed above involving W's. To compare (2w + 5) (3w - 7) and -29 + 7w, we need to expand both sides. 
:[font = input; preserveAspect; nowordwrap; ]
Expand[(2w + 5)(3w - 7)] == Expand[-29 + 7w]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. The isomorphism hinted at above would map a + bW to a + bw, where w is the first root given to us by Solve. Could we have used the second root? If W maps into the second root, what would map into w?
:[font = special2; inactive; preserveAspect; endGroup; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.5 An extension of Z[3] using Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's continue by reading in the Mathematica code needed for the rest of this lab:
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the polynomial p(x) = x^2 + x + 2 over the integers modulo 3, Z[3].
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. Verify that none of the elements in Z[3], {0, 1, 2}, are roots of p(x)
:[font = special2; inactive; preserveAspect; nohscroll; ]
 Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
The extension of Z[3] that contains a root z of p(x) can be generated with QuotientRing (see Ring Lab 10). We will shorten the name of Z[3][z] to V.
:[font = input; preserveAspect; nowordwrap; ]
Clear[x]
p = Poly[Z[3], x^2 + x + 2]
V = QuotientRing[Z[3], p]

:[font = text; inactive; preserveAspect; nohscroll; ]
When you work with V, be aware of the form of its elements. They all appear as ordinary polynomial expressions, but in fact their internal form is more complicated. We have to use the Poly function to create these. For example, consider the third element in the list, appearing as 2x. Let's get the third element and look at it.
:[font = input; preserveAspect; nowordwrap; ]
third = Elements[V][[3]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Is this simply 2x? In other words, can we just use 2x in place of this?
:[font = input; preserveAspect; nowordwrap; ]
2x === third
:[font = text; inactive; preserveAspect; nohscroll; ]
No. They have different internal forms. For instance, 2x, to Mathematica is
:[font = input; preserveAspect; nowordwrap; ]
FullForm[2x]
:[font = text; inactive; preserveAspect; nohscroll; ]
which is just the product of 2 and x, as we think of it in ordinary usage. The Mathematica internal form for the third element in V, 2x, is quite different:
:[font = input; preserveAspect; nowordwrap; ]
FullForm[third]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is significantly more complicated. The reason is that this represents a formal polynomial whose underlying ring is embedded in the structure, as well as several other pieces of data. (Purely optional: this data structure has the head AbstractAlgebra`RingExtensions`Private`poly with two arguments. The first is a list with four sub-arguments and the second is the list of coefficients, starting with the constant term, then linear and so on. The arguments in the first list consist of the underlying ring (in internal form), whether we should view the polynomial from right to left or left to right, the indeterminate that should be used, and finally whether the coefficients are numeric or not. Thankfully, the user does not need to worry about these details.)

Therefore, to use this third element, one either picks it off the list of elements, as done above, or creates it anew with the Poly function. In this case, this polynomial can be obtained by
:[font = input; preserveAspect; nowordwrap; ]
newthird = Poly[Z[3], 2x]
:[font = text; inactive; preserveAspect; nohscroll; ]
It is important that all polynomials are created in this fashion when they are over a ring besides the integers, rationals, reals or complex numbers. Note that this is now identical to third:
:[font = input; preserveAspect; nowordwrap; ]
newthird === third
:[font = text; inactive; preserveAspect; nohscroll; ]
What is more important is the mathematical concept of what this 2x represents. On the one hand, you can just think of it as an abstract element in a new ring, or you can think of it as the coset representative of the coset 2x + <x^2 + x + 2>, since this element really comes from the quotient ring Z[3][x]/<x^2 + x + 2>.
:[font = text; inactive; preserveAspect; nohscroll; ]
What have we done so far? Let's recap for a moment. We have a polynomial p = x^2 + x + 2 that does not have any roots in Z[3]. We formed the quotient ring Z[3][x]/<x^2 + x + 2> and called it V. We also know (from Ring Lab 10) that this V contains a root (call it z) of p in it, as well as containing Z[3] itself. (How does it contain Z[3]?) We therefore also call V by the name Z[3][z]. To verify that z (whatever it turns out to be) is a root of p, we need to represent p's coefficients as elements of V. In other words, we can think of a new p, call it pV, whose coefficients 1, 1, and 2 are constant polynomials in V. We also want the multiplication x * x that yields x^2 to be taking place in V. Hence, we have a new polynomial function as follows:
:[font = input; preserveAspect; nowordwrap; ]
Clear[y]
pV[y_] := Multiplication[V][y, y] + y + 
	Poly[Z[3], 2,Indeterminate -> x]
:[font = text; inactive; preserveAspect; nohscroll; ]
The constant term 2 in p is reflected by using Poly[Z[3], 2, Indeterminate -> x]. (The use of Indeterminate -> x is just for consistency. Since constants do not use an indeterminate, adding this indicates that we are thinking of this as a polynomial in the indeterminate x.)

We have stated that z is a root of p (or of this new version of p, pV), but what is z? We know we have a root if, when we evaluate a polynomial, we get 0. Since z is supposed to be found in V (and we already know that one third of these elements can be dismissed as candidates ---why?), we should perhaps map our new polynomial pV over our elements in V and look for 0 (i.e., Poly[Z[3], 0]).
:[font = input; preserveAspect; nowordwrap; ]
valuesOfpV = Map[pV, Elements[V]]
:[font = text; inactive; preserveAspect; nohscroll; ]
We obtain 0 twice. What values of V yielded these? Let's look at V again.
:[font = input; preserveAspect; nowordwrap; ]
Elements[V]
:[font = text; inactive; preserveAspect; nohscroll; ]
Combining and transposing,
:[font = input; preserveAspect; nowordwrap; ]
Transpose[{Elements[V], valuesOfpV}]//TableForm[#, TableHeadings ->
	{None, {"v in V", "pV[v]\n"}}]&
:[font = text; inactive; preserveAspect; nohscroll; ]
makes it clear that our candidates for z are the elements (polynomials) x and 2x + 2.
:[font = text; inactive; preserveAspect; nohscroll; ]
The formation of pV is not particularly pleasant. There is a function called EvaluationInExtension that can do this. Here is how it works.
:[font = input; preserveAspect; nowordwrap; ]
?EvaluationInExtension
:[font = input; preserveAspect; nowordwrap; ]
EvaluationInExtension[V, ModulusPolynomial[V], Poly[Z[3], x]]
:[font = text; inactive; preserveAspect; nohscroll; ]
One can also give it a list of elements to evaluate:
:[font = input; preserveAspect; nowordwrap; ]
EvaluationInExtension[V, ModulusPolynomial[V], Elements[V]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. Let q = x^2 + 2x + 2 over Z[3]. Show that q is irreducible over Z[3]. Calculate V2 = QuotientRing[Z[3], q]. Find a zero for q in V2.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that to compute a product in V, such as x^2 = (x)(x), you can use Multiplication[V].
:[font = input; preserveAspect; nowordwrap; ]
Multiplication[V][Poly[Z[3], x], Poly[Z[3], x]]
:[font = text; inactive; preserveAspect; nohscroll; ]
For higher powers, it may be easier to use the ElementToPower function:
:[font = input; preserveAspect; nowordwrap; ]
?ElementToPower
:[font = input; preserveAspect; nowordwrap; ]
ElementToPower[V, Poly[Z[3], x], 2]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Compute more powers of x (x^2, x^3,..., x^9...) until you can identify a pattern. (Hint: using the Table function with ElementToPower is the cleanest way of doing this.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer
:[font = text; inactive; preserveAspect; nohscroll; ]
If we consider another irreducible quadratic polynomial over Z[3], will we need a further extension, or will our original extension contain the second irreducible's roots? 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. Verify that q(x) = x^2 + 1 has no roots in the Z[3], but has both its roots in V.
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.6 Theorems that are motivated from this lab.
:[font = text; inactive; preserveAspect; nohscroll; ]
The calculations that we have performed here suggest several theorems. To prove the theorems, there are many details that need to be shown(). However, the examples in this lab certainly show that the theorems are plausible. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. We state these theorems with a few key words left for you to fill in.

Theorem 1. If p(x) is irreducible over F, E = F[z] is a quadratic extension of F containing a root z of p(x), and y is the second root of p(x), then F[z] is ________________________ to F[y].

Theorem 2. If w is a real root of p(x) = x^2 + x + 1, then for each positive integer n, w^n = a_n + b_n w,	where a_n and b_n are consecutive ___________________.
	
Theorem 3. If F is a finite field and F[z] is a quadratic extension of F, then the set of nonzero elements of F[z] with multiplication is a _______ group of order ______	 and z is a __________ of the group.																			
Theorem 4. If F is a finite field, a quadratic polynomial p(x) is irreducible over F and z is a root of p(x) in an extension E of F, then every ___________ polynomial over F has its roots in F[z].
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Note: these theorems can all be generalized in several directions, so the theorem in your text may not match these exactly. 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
11.7 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?PolynomialRemainder
:[font = input; preserveAspect; nowordwrap; ]
?Solve
:[font = input; preserveAspect; nowordwrap; ]
?Expand
:[font = input; preserveAspect; nowordwrap; ]
?Poly
:[font = input; preserveAspect; nowordwrap; ]
?QuotientRing
:[font = input; preserveAspect; nowordwrap; ]
?Elements
:[font = input; preserveAspect; nowordwrap; ]
?FullForm
:[font = input; preserveAspect; nowordwrap; ]
?Indeterminate
:[font = input; preserveAspect; nowordwrap; ]
?Multiplication
:[font = input; preserveAspect; nowordwrap; ]
?Transpose
:[font = input; preserveAspect; nowordwrap; ]
?EvaluationInExtension
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?ElementToPower
^*)