(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 12. Factoring in Z[Sqrt[d]]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
One should have an elementary understanding of divisors and factoring with integers. It may also be helpful to be familiar with the ring Z[Sqrt[d]].
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to explore the notion of factoring numbers in Z[Sqrt[d]] for various intergers d. In particular, we want to see when this factorization is unique (in some sense) and when it is not.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.3 An introduction to divisibility
:[font = text; inactive; preserveAspect; nohscroll; ]
To work on this lab, we need to load the packages that define the needed functionality.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Ring];
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab will focus on a particular class of rings that are extensions of the integers. Let d be a fixed integer and consider the set {r + s Sqrt[d] | r, s are integers}. We will denote this set by Z[Sqrt[d]]. If d = 2, the following illustrates a subset of Z[Sqr[2]], when we restrict r and s to {-2, -1, ..., 3}.
:[font = input; preserveAspect; nowordwrap; ]
Adjoin[Range[-2, 3], Sqrt[2]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. What is the result of letting d = 4? In other words, what does Z[Sqrt[4]] look like? What about Z[Sqrt[9]]? What about Z[Sqrt[16]]? Can you think of any conditions on d that we may wish to impose?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that when we let d = -1, we obtain Z[Sqrt[-1]], the Gaussian integers; this is frequently denote Z[i].
:[font = text; inactive; preserveAspect; nohscroll; ]
Throughout the rest of the lab, we assume that D is an integral domain. If r and s are two elements in D, with r nonzero, we say that r divides s (or r is a factor of s) if s = r t for some t in D. When r divides s, this is denoted r | s and we say that r is a divisor of s. Note that the units of D are those elements that are divisors of the unity of D.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. For each ring that is given, determine whether r | s. If yes, indicate the value of t such that s = rt.
(a) In Z, is it the case that 5 | 15?
(b) In Z, is it the case that 15 | 5? 
(c) In Z[Sqrt[3]], is it the case that (2 + Sqrt[3]) | (-7 - 6Sqrt[3])?
(d) In Z[Sqrt[3]], is it the case that (4 - 5Sqrt[3]) | (-7 - 6Sqrt[3])?
(e) In Z[Sqrt[-5]], is it the case that 3 | 9?
(f) In Z[Sqrt[-5]], is it the case that (2 + Sqrt[-5]) | 9?
(g) In Z[Sqrt[-5]], is it the case that (2 - Sqrt[-5]) | 9?
(h) What is the product of 2 + Sqrt[-5] and 2 - Sqrt[-5]?
(i) In Z[Sqrt[-5]], is it the case that 3 | (2 + Sqrt[-5])?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. If r is a unit in D and x is any other element, what can you say about r | x? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
When we are working with (ordinary) integers, it is fairly easy to know when r divides s. Essentially, we want to know if the quotient s/r is an integer. We can define a function DividesQ by using this approach.
:[font = input; preserveAspect; nowordwrap; ]
DividesQ[6, 18]
DividesQ[6, 16]
:[font = input; preserveAspect; nowordwrap; ]
?DividesQ
:[font = text; inactive; preserveAspect; nohscroll; ]
When we work over the ring Z[Sqrt[d]], we extend this function by adding the option Radical -> d. The following shows that 1 + Sqrt[2] is a unit in Z[Sqrt[2]].
:[font = input; preserveAspect; nowordwrap; ]
DividesQ[1 + Sqrt[2], 1, Radical -> 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
This indicates that there is an element t in Z[Sqrt[2]] such that (1 + Sqrt[2]) t = 1. What is t? Let's perform the division.
:[font = input; preserveAspect; nowordwrap; ]
1/(1 + Sqrt[2])
:[font = input; preserveAspect; nowordwrap; ]
Simplify[%]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that Simplify does not return an element in the form a + bSqrt[2], so we need to turn to another function.
:[font = input; preserveAspect; nowordwrap; ]
ZdDivide[1, 1 + Sqrt[2]]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
So we see that t is indeed an element in Z[Sqrt[d]].
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.4 Associates, irreducibility and norms
:[font = text; inactive; preserveAspect; nohscroll; ]
We need to introduce (or review) some definitions. Given elements r and s in D, we say that they are associates if there is a unit u in D such that r = s u. A nonzero element r in D is called irreducible if r is not a unit and whenever r = b c (for elements b and c in D), then b or c is a unit. (In other words, the only divisors of r are units and associates of r.)
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. (a) What are the associates of 5 over the integers? 
(b) What are the associates of 5 over Z[i]? 
(c) Are 3 + 4Sqrt[2] and 5 - Sqrt[2] associates over Z[Sqrt[2]]?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. (a) Is 5 irreducible over the integers? Why or why not?
(b) Is 6 irreducible over the integers? Why or why not?
(c) Is 5 irreducible over Z[i]? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The function ZdAssociatesQ can confirm whether a pair of numbers are associates over Z[Sqrt[d]].
:[font = input; preserveAspect; nowordwrap; ]
?ZdAssociatesQ
:[font = input; preserveAspect; nowordwrap; ]
ZdAssociatesQ[2, 3 + 4 Sqrt[2], 5 - Sqrt[2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
For negative d, the function ZdIrreducibleQ specifies whether an element is irreducible. (The problem is more difficult to answer for positive d.)
:[font = input; preserveAspect; nowordwrap; ]
ZdIrreducibleQ[-1, 5]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since 5 is not irreducible, we should be able to factor this over Z[i], the GaussianIntegers.
:[font = input; preserveAspect; nowordwrap; ]
FactorInteger[5, GaussianIntegers -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
The last idea to introduce in this section is a function called the norm function. We define the function N: Z[Sqrt[d]] -> {nonnegative integers} by N(a + b Sqrt[d]) = |a^2 - d b^2|. (Note: some authors prefer a slightly different definition.) In Mathematica, we use the function ZdNorm to accomplish this. Let's consider some examples over Z[Sqrt[5].
:[font = input; preserveAspect; nowordwrap; ]
examples = Adjoin[{-1, 0, 1, 2}, Sqrt[5]]
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, ZdNorm[#]}&, examples]//TableForm[#, TableHeadings -> 
	{None, {"x", "N(x)\n"}}, TableSpacing -> {0, 4}]&
:[font = text; inactive; preserveAspect; nohscroll; ]
There are four important properties about the norm function that should be observed; check your text for details concerning these.

1. N(x) = 0 if and only if x = 0,
2. N(x y) = N(x) N(y) for all x and y,
3. N(x) = 1 if and only if x is a unit, and
4. If N(x) is prime (in Z), then x is irreducible in Z[Sqrt[d]].
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. In the list of examples of elements from Z[Sqrt[5]] given above, which are units and which can be readily seen as being irreducible?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider x = 2 + 3 Sqrt[-6] and y = 2 - 3 Sqrt[-6] as elements in Z[Sqrt[-6]]. Let's verify property 2 listed above.
:[font = input; preserveAspect; nowordwrap; ]
x = 2 + 3 Sqrt[-6]
y = 2 - 3 Sqrt[-6]
ZdNorm[x y] === ZdNorm[x] ZdNorm[y]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Let x = 1 + 3 Sqrt[-5] and y = 1 - 3 Sqrt[-5]. Verify that property 2 is true with these values of x and y. Repeat this using x = 2 and y = 23.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Be careful how you read property 4; the converse is not true in general. For example, with x = 1 + 3 Sqrt[-5], used in the previous question, the norm of x is 46, which is composite.
:[font = input; preserveAspect; nowordwrap; ]
ZdNorm[1 + 3 Sqrt[-5]]
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
This does not imply that x is not irreducible! In fact, in a subsequent section, we will show that x is indeed irreducible.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.5 Units in Z[Sqrt[d]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall from the third property above that x is a unit if and only if N(x) = 1. Can we use this to determine the units of Z[Sqrt[d]]? Let x = a + b Sqrt[d] be an element in Z[Sqrt[d]]. Then N(x) = |a^2 - d b^2|. First, let's consider the case where d < -1 and let k = -d. Then we have N(x) = a^2 + k b^2, with k > 1. Since k > 1 and we are assuming that N(x) = 1 (since we want x to be a unit), then we must have b = 0, for otherwise a^2 + k b^2 >= k > 1. Therefore, a^2 = 1, and so the only units are 1 and -1.

Let's consider a geometric argument for the same question. To be specific, suppose we consider k = 2 (i.e., d = -2). What we really are considering is whether there are integral solutions to the equation a^2 + 2 b^2 = 1. But this is just the equation of an ellipse, so let's look at its graph. We need to first read in a package that allows us to plot equations implicitly.
:[font = input; preserveAspect; nowordwrap; ]
Needs["Graphics`ImplicitPlot`"]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here, we plot the ellipse determined by this equation.
:[font = input; preserveAspect; nowordwrap; ]
Clear[a, b]
gr1 = ImplicitPlot[a^2 + 2 b^2 == 1, {a, -2, 2}, 
	AspectRatio -> Automatic, PlotRange -> {{-2, 2}, {-2, 2}}];
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we plot a backdrop for our ellipse, consisting of points with integer coordinates in the neighborhood of the ellipse.
:[font = input; preserveAspect; nowordwrap; ]
gr2 = IntegerLatticeGrid[{-2, 2}, {-2, 2}, PlotStyle -> 
	{PointSize[0.025], RGBColor[0, 0, 1]}, AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect; nohscroll; ]
Putting them together results in the following.
:[font = input; preserveAspect; nowordwrap; ]
Show[{gr2, gr1}, AspectRatio -> Automatic];
:[font = text; inactive; preserveAspect; nohscroll; ]
It should be clear that the only points with integer coordinates that lie on the ellipse occur where a = 1 and b = 0 and where a = -1 and b = 0.

This illustrates that when d = -2 the only units are 1 and -1. What about for smaller values of d? Consider the following series of graphics. After evaluating the cell, you may wish to double-click on one of the graphics and adjust the animation speed by typing 1 through 9 (1 slow, 9 fast).
:[font = input; preserveAspect; nowordwrap; ]
Do[ImplicitPlot[a^2 - d b^2 == 1, {a, -2, 2}, 
	AspectRatio -> Automatic,
	PlotRange -> {{-1, 1}, {-1, 1}}, 
	PlotLabel -> "d = "<>ToString[d]], {d, -3, -15, -2}];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. What is the conclusion? If d < -2, how many units are there? What are they? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
What if d = -1? We then have N(x) = a^2 - (-1)b^2 = 1, or a^2 + b^2 = 1.
:[font = input; preserveAspect; nowordwrap; ]
gr1 = ImplicitPlot[a^2 + b^2 == 1, {a, -2, 2}, 
	AspectRatio -> Automatic, PlotRange -> {{-2, 2}, {-2, 2}},
	DisplayFunction -> Identity];
	
Show[{gr2, gr1}, AspectRatio -> Automatic, 
	DisplayFunction -> $DisplayFunction];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. When d = -1, how many units are there? What are they? Justify your answer.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Next, we consider when d > 1.When d = 2 we have  N(x) = |a^2 - 2 b^2| = 1. Therefore, we need a^2 - 2 b^2 to have the value 1 or -1. This simply gives rise to two hyperbolas: a^2 - 2b^2 = 1 and a^2 - 2b^2 = -1. These two are now graphed, to gain some geometric insight.
:[font = input; preserveAspect; nowordwrap; ]
c = 4;
gr1 = ImplicitPlot[{a^2 - 2b^2 == 1, a^2 - 2b^2 == -1}, {a, -c, c}, 
	AspectRatio -> Automatic, PlotStyle -> {{Thickness[0.02], Green}, 
	{Thickness[0.02], Magenta}},
	PlotRange -> {{-c, c}, {-c, c}}];
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is the graph with an integer lattice backdrop (actually, a "foredrop" this time), showing the two together.
:[font = input; preserveAspect; nowordwrap; ]
gr2 = IntegerLatticeGrid[{-c, c}, {-c, c}, PlotStyle -> 
	{PointSize[0.025], Blue}, AspectRatio -> Automatic, 
	DisplayFunction -> Identity];
	
Show[{gr1, gr2}, DisplayFunction -> $DisplayFunction]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q10. Do you "see" any units? (Remember, we are looking for units in Z[Sqrt[2]] = {a + b Sqrt[2] | a, b in Z} which have integer coordinates and must satisfy one of the equations giving rise to a hyperbola.) List those that you see. Use the function ZdUnitQ if you wish to verify that it is a unit; see below for example.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The function ZdUnitQ can be used to confirm or deny whether an element is a unit or not.
:[font = input; preserveAspect; nowordwrap; ]
?ZdUnitQ
:[font = input; preserveAspect; nowordwrap; ]
ZdUnitQ[2, 2 + Sqrt[2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Consider the element x = 3 + 2 Sqrt[2]; this is a unit in Z[Sqrt[2]]:
:[font = input; preserveAspect; nowordwrap; ]
ZdUnitQ[2, x = 3 + 2 Sqrt[2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since x is a unit, then any power of x is also a unit. (Appropriate use of properties 2 and 3 is one way of verifying this.) Let's examine the powers of this element. Here are the first five powers.
:[font = input; preserveAspect; nowordwrap; ]
pts1 = Table[Expand[x^k], {k, 1, 5}]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can verify that these are indeed units.
:[font = input; preserveAspect; nowordwrap; ]
Map[ZdUnitQ[2, #]&, pts1]
:[font = text; inactive; preserveAspect; nohscroll; ]
These elements appear to be growing without bound. Here is geometric view of what is happening, showing only the hyperbolas in the first quadrant, and the powers of x colored according to Hue (the "rainbow").
:[font = input; preserveAspect; nowordwrap; ]
convertPts[lst_] := lst /. {a_ + b_ Sqrt[2] :> {a, b}, a_ + Sqrt[2] :> {a,1}}
pts1 = pts1//convertPts;
n = Length[pts1];
c = 3400;
gr1 = ImplicitPlot[{a^2 - 2b^2 == 1, a^2 - 2b^2 == -1}, {a, 0, c}, 
	AspectRatio -> Automatic, PlotStyle -> {Green, Magenta},
	PlotRange -> {{0, c}, {0, c}}, Epilog -> Table[{Hue[k/n], PointSize[0.03],
	Map[Point, pts1[[k]], {0}]}, {k, 1, n}]];
:[font = text; inactive; preserveAspect; nohscroll; ]
Here are the five colors (in order) of the dots plotted.
:[font = input; preserveAspect; nowordwrap; ]
Show[Graphics[Table[{Hue[i/5], Rectangle[{i, 0},{i + 1, 1}]}, 
	{i, 5}]]];
:[font = text; inactive; preserveAspect; nohscroll; ]
(You might ask where the yellow is on the plot.) Let's try another element, x = -1 + Sqrt[2], which is also a unit, and its first ten powers.
:[font = input; preserveAspect; nowordwrap; ]
ZdUnitQ[2, x = -1 + Sqrt[2]]

pts2 = Table[Expand[x^k], {k, 1, 10}]

Map[ZdUnitQ[2, #]&, pts2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is the graph of the hyperbolas with the 10 powers of this x plotted.
:[font = input; preserveAspect; nowordwrap; ]
pts2 = pts2//convertPts;
n = Length[pts2];
c = 3400;
gr1 = ImplicitPlot[{a^2 - 2b^2 == 1, a^2 - 2b^2 == -1}, {a, -c, c}, 
	AspectRatio -> Automatic, PlotStyle -> {Green, Magenta},
	PlotRange -> {{-c, c}, {-c, c}}, Epilog -> Table[{Hue[k/n], PointSize[0.03],
	Map[Point, pts2[[k]], {0}]}, {k, 1, n}]];
:[font = text; inactive; preserveAspect; nohscroll; ]
As n increased on the power x^n, the point was colored according to the scheme shown below, where the power n is located in the rectangle.
:[font = input; preserveAspect; nowordwrap; ]
Show[Graphics[Table[{Hue[i/10], Rectangle[{i, 0},{i + 1, 1}], Black,
	Text[i, {0.5 + i, .5}]}, {i, 10}]]];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q11. What is fundamentally different between the powers of these two elements (3 + 2Sqrt[2] versus -1 + Sqrt[2]), as shown by the graphs?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
As can be seen, Z[Sqrt[2]] has an infinite number of units. This is true whenever d > 1.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.6 Factoring 46 in Z[Sqrt[-5]]
:[font = text; inactive; preserveAspect; nohscroll; ]
In question 7, we investigated the norm of the following four numbers.
:[font = input; preserveAspect; nowordwrap; ]
x = 1 + 3 Sqrt[-5]
y = ZdConjugate[x]
a = 2
b = 23
Map[ZdNorm, {x, y, a, b}]
:[font = text; inactive; preserveAspect; nohscroll; ]
Note further that x y = a b = 46.
:[font = input; preserveAspect; nowordwrap; ]
Expand[x y] == 46
:[font = text; inactive; preserveAspect; nohscroll; ]
This shows that x, y, a, and b are all divisors of 46. Are there any more?
:[font = input; preserveAspect; nowordwrap; ]
ZdDivisors[-5, 46]
:[font = text; inactive; preserveAspect; nohscroll; ]
We are really only interested in the non-trivial ones:
:[font = input; preserveAspect; nowordwrap; ]
ZdDivisors[-5, 46, NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
That 46 has four non-trivial divisors (over Z[Sqrt[-5]]) is not significant in itself. If we consider the integer 80, we know that it has many divisors as well.
:[font = input; preserveAspect; nowordwrap; ]
IntegerDivisors[80, NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
We know that 80 can be written as 2 * 40, 4 * 20, 5 * 16, or 8 * 10, but in each case one or both factors can be further factored (into primes) until one obtains the result 2 * 2 * 2 * 2 * 5, or 2^4 * 5:
:[font = input; preserveAspect; nowordwrap; ]
FactorInteger[80]
:[font = text; inactive; preserveAspect; nohscroll; ]
Except for the order that these factors are written, or if perhaps some (even number) are traded for their associates (their negatives), this product is unique. This is a result of the Fundamental Theorem of Arithmetic. The question to pursue here is whether an analogous situation holds in Z[Sqrt[-5]], and other rings. In other words, even though (1 + 3 Sqrt[-5]) (1 - 3 Sqrt[-5]) = 46 = 2 * 23 in Z[Sqrt[-5]] shows that we have two factorizations that appear different, we want to make sure that we have factored 46 into irreducibles. Also, we want to see if 1 + 3 Sqrt[-5] is possibly an associate of 2 or 23 and if 1 - 3 Sqrt[-5] is an associate of the other.Thus, we have two steps to take:

1. Determine whether 2, 23, 1 + 3 Sqrt[-5], and 1 - 3 Sqrt[-5] satisfy our definition of being irreducible.

2. Determine if any of {2, 23} are associates with any of {1 + 3 Sqrt[-5], 1 - 3 Sqrt[-5]}.
:[font = text; inactive; preserveAspect; nohscroll; ]
Recall that for r to be irreducible over an integral domain D, it must be nonzero, not a unit, and if we ever have s t = r (for s, t in D), we must have either s or t a unit. Clearly none of these four are zero, and when we calculated their norms we observed that none had norm 1, so they are not units. First, let's consider 2 and show that it is irreducible. Its norm is four.
:[font = input; preserveAspect; nowordwrap; ]
ZdNorm[2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Therefore, if 2 = s t for some s and t in D = Z[Sqrt[-5]], then N(s) N(t) = 4, by the second property of norms. To show that 2 is irreducible, we need to show that either s or t is a unit, and consequently having norm 1 (by the third property). Therefore, since the divisors of 4 are {1, 2, 4}, we want to show that we can not have N(s) = N(t) = 2 and then we will know that 2 is irreducible.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q12. Why do we only need to show that we cannot have N(s) = 2 to show 2 is irreducible?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
If we let s = a + b Sqrt[-5], then we see that N(s) = a^2 + 5 b^2. For N(s) = 2, we must have integral coordinates for a point somewhere on the ellipse a^2 + 5 b^2 = 2. Inspecting this algebraically, clearly if b is not zero, then the left-hand side is already at least 5, which is not possible (since we still have to add a^2 to 5 b^2, while the right-hand side is 2). Geometrically, we can see this below.
:[font = input; preserveAspect; nowordwrap; ]
ZdPossibleNorms[-5, 2, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
This function shows the ellipse with the equation given above, as well as showing all points whose norm is less than or equal to 2 (and the output is a list of all norms that are possible that are less than or equal to 2). We can also just use the function ZdPossibleNormQ as follows:
:[font = input; preserveAspect; nowordwrap; ]
ZdPossibleNormQ[-5, 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we know that 2 is indeed an irreducible element. Next, we attack 23 and investigate whether it is irreducible. Let's assume that it is not irreducible and see if we can find a contradiction. Therefore 23 = s t, where s and t are in D. Consequently, N(23) = N(s) N(t) and we need to find elements s and t whose norm is a divisor of the norm of 23. Not that we need Mathematica to help us in this case (the arithmetic is trivial), but to illustrate the general idea, we want to look for the non-trivial divisors of 23^2.
:[font = input; preserveAspect; nowordwrap; ]
IntegerDivisors[ZdNorm[23], NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
The only possible divisor is 23, so both N(s) and N(t) must be 23. Is it possible to have this norm in the ring D = Z[Sqrt[-5]]?
:[font = input; preserveAspect; nowordwrap; ]
ZdPossibleNormQ[-5, 23]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's "see" why not.
:[font = input; preserveAspect; nowordwrap; ]
ZdPossibleNorms[-5, 23, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
The value 23 is not obtainable as a norm, and therefore there are no s and t such that N(s) = N(t) = 23, so either s or t is a unit, and 23 is irreducible.

There are two elements left to check for irreducibility: 1 + 3 Sqrt[-5] and 1 - 3 Sqrt[-5]. We proceed in the same manner.
:[font = input; preserveAspect; nowordwrap; ]
IntegerDivisors[ZdNorm[1 + 3 Sqrt[-5]], NonTrivialOnly -> True]
IntegerDivisors[ZdNorm[1 - 3 Sqrt[-5]], NonTrivialOnly -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
Since the only possible non-trivial divisors of the norms of these two are 2 and 23, and we have seen that neither of these norms are possible, we know that both of the elements 1 + 3 Sqrt[-5] and 1 - 3 Sqrt[-5] are irreducible.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q13. Here is an optional question. Define the function PN by PN(x) is the number of norms less than or equal to x that are possible in Z[Sqrt[-5]]. What is PN(100)? How much larger is PN(200) than PN(100)? (In other words, are there more or less in the second 100, from 101 to 200, then in the first 100?) How does PN(300) compare to PN(200)? Is there a monotonic pattern? You may wish to use what is below to help you, with the Length function to measure the output. (Eliminate the Mode -> Visual option if the graphics take too long -- they are not needed for the count.)
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
ZdPossibleNorms[-5, 100, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
We have shown that the four divisors of 46 are all irreducible. Next, we want to know if any of {2, 23} are associates with {1 + 3 Sqrt[-5], 1 - 3 Sqrt[-5]}, which was step two in our outline above. Recall that for 2 to be an associate of 1 + 3 Sqrt[-5], it must have a unit u such that 2 = u * 1 + 3 Sqrt[-5]. If so, then N(2) = N(u) N(1 + 3 Sqrt[-5]), or 4 = 1 * 46, which is clearly not possible. The following shows that no possible arrangement (matching across the two sets) for pairing up associates will be fruitful.
:[font = input; preserveAspect; nowordwrap; ]
Map[ZdNorm, {2, 23}]
Map[ZdNorm, {1 + 3 Sqrt[-5], 1 - 3 Sqrt[-5]}]
:[font = text; inactive; preserveAspect; nohscroll; ]
(Note that checking for associates could have also been done as follows.)
:[font = input; preserveAspect; nowordwrap; ]
ZdAssociatesQ[-5, 2, 1 + 3 Sqrt[-5]]
ZdAssociatesQ[-5, 23, 1 + 3 Sqrt[-5]]
:[font = text; inactive; preserveAspect; nohscroll; ]
What is the conclusion? In Z[Sqrt[-5]] we have 46 = 2 * 23 and 46 = (1 + 3 Sqrt[-5]) * (1 - 3 Sqrt[-5]). These four divisors are all irreducible and the two factorizations do not involve associates (as would 46 = 2 * 23 and 46 = (-2) * (-23)). Consequently, we have two distinct, unrelated factorizations of the number 46. This verifies that Z[Sqrt[-5]] is not a Unique Factorization Domain (UFD).
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Historical Note: There was a short time in the nineteenth century when Fermat's Last Theorem was considered to have been proven, but there was a flaw in the proof. This flaw, discovered by Kummar, traced back to an assumption that factorization was unique in rings such as Z[Sqrt[-5]].
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.7 Is Z[Sqrt[-6]] a UFD?
:[font = text; inactive; preserveAspect; nohscroll; ]
Since we have shown that Z[Sqrt[-5]] is not a UFD (Unique Factorization Domain), we may wonder about other related rings. Let's consider a neighbor (in some sense), D = Z[Sqrt[-6]]. To show that D is not a UFD, we need to find an element r in D that has two distinct factorizations. Since we may like to somewhat automate this, we label each step along the way with variables to hold the values, so we can readily try other rings.
:[font = text; inactive; preserveAspect; nohscroll; ]
In this example, we are using d = -6.
:[font = input; preserveAspect; nowordwrap; ]
d = -6
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's pick two random coefficients, but not too large.
:[font = input; preserveAspect; nowordwrap; ]
{a, b} = Table[Random[Integer, {1, 5}], {2}]
:[font = text; inactive; preserveAspect; nohscroll; ]
We use these values to form our x, and let y be its conjugate.
:[font = input; preserveAspect; nowordwrap; ]
x = a + b Sqrt[d]
y = ZdConjugate[x]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let z be their product.
:[font = input; preserveAspect; nowordwrap; ]
z = Expand[x y]
:[font = text; inactive; preserveAspect; nohscroll; ]
We use nrm form the norm of this product.
:[font = input; preserveAspect; nowordwrap; ]
nrm = ZdNorm[z]
:[font = text; inactive; preserveAspect; nohscroll; ]
Let's take a look at all the divisors of z.
:[font = input; preserveAspect; nowordwrap; ]
ZdDivisors[d, z, DivisorsComplete -> True]
(* may take a little time *)
:[font = text; inactive; preserveAspect; nohscroll; ]
We can view these divisors by pairing up associates.
:[font = input; preserveAspect; nowordwrap; ]
ZdDivisors[d, z, Combined -> Associates, DivisorsComplete -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
We can also pair up the divisors so that the product of each pair is z.
:[font = input; preserveAspect; nowordwrap; ]
ZdDivisors[d, z, Combined -> Products, DivisorsComplete -> True]
:[font = text; inactive; preserveAspect; nohscroll; ]
From here, we should look for two pairs whose product is z, all divisors are irreducible and none are associates of the others.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q14. Find two pairs that satisfy these conditions. If there are not two pairs, go back and generate a new x and y and see if two pairs arise that satisfy these conditions. 
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
12.8 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?Adjoin
:[font = input; preserveAspect; nowordwrap; ]
?DividesQ
:[font = input; preserveAspect; nowordwrap; ]
?Radical
:[font = input; preserveAspect; nowordwrap; ]
?ZdDivide
:[font = input; preserveAspect; nowordwrap; ]
?ZdAssociatesQ
:[font = input; preserveAspect; nowordwrap; ]
?ZdIrreducibleQ
:[font = input; preserveAspect; nowordwrap; ]
?FactorInteger
:[font = input; preserveAspect; nowordwrap; ]
?GaussianIntegers
:[font = input; preserveAspect; nowordwrap; ]
?ZdNorm
:[font = input; preserveAspect; nowordwrap; ]
?ImplicitPlot
:[font = input; preserveAspect; nowordwrap; ]
?IntegerLatticeGrid
:[font = input; preserveAspect; nowordwrap; ]
?ZdUnitQ
:[font = input; preserveAspect; nowordwrap; ]
?ZdConjugate
:[font = input; preserveAspect; nowordwrap; ]
?ZdDivisors
:[font = input; preserveAspect; nowordwrap; ]
?NonTrivialOnly
:[font = input; preserveAspect; nowordwrap; ]
?IntegerDivisors
:[font = input; preserveAspect; nowordwrap; ]
?ZdPossibleNorms
:[font = input; preserveAspect; nowordwrap; ]
?ZdPossibleNormQ
:[font = input; preserveAspect; nowordwrap; ]
?Combine
:[font = input; preserveAspect; nowordwrap; ]
?Associates
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?Products
^*)