(*^

::[	frontEndVersion = "Microsoft Windows Mathematica Notebook Front End Version 2.2";
	microsoftWindowsStandardFontEncoding;
	fontset = title, "Times New Roman", 24, L0, center, nohscroll, bold, B65535, cellOutline;
	fontset = subtitle, "Times New Roman", 18, L0, center, nohscroll, bold;
	fontset = subsubtitle, "Times New Roman", 24, L0, center, nohscroll, italic;
	fontset = section, "Times New Roman", 18, L0, nohscroll, bold, grayBox;
	fontset = subsection, "Times New Roman", 14, L0, nohscroll, bold, blackBox;
	fontset = subsubsection, "Times New Roman", 12, L0, nohscroll, bold, whiteBox;
	fontset = text, "Times New Roman", 14, L0, nohscroll;
	fontset = smalltext, "Times New Roman", 10, L0, nohscroll;
	fontset = input, "Courier New", 12, L-5, nowordwrap, bold, b0;
	fontset = output, "Courier New", 12, L-5, nowordwrap;
	fontset = message, "Courier New", 12, L-5, nowordwrap, R65535;
	fontset = print, "Courier New", 12, L-5, nowordwrap;
	fontset = info, "Courier New", 12, L-5, nowordwrap, G65535;
	fontset = postscript, "Courier New", 12, L0, nowordwrap;
	fontset = name, "Arial", 10, L0, nohscroll, italic;
	fontset = header, "Times New Roman", 12, L0;
	fontset = footer, "Times New Roman", 12, L0, center;
	fontset = help, "Times New Roman", 10, L0, nohscroll;
	fontset = clipboard, "Times New Roman", 12, L0, nohscroll;
	fontset = completions, "Times New Roman", 12, L0, nohscroll;
	fontset = graphics, "Courier New", 10, L0, nowordwrap, nohscroll;
	fontset = special1, "Times New Roman", 12, L0, nohscroll, R65535, B65535, r59110, g59110, b59110;
	fontset = special2, "Times New Roman", 12, L0, nohscroll, B65535, r49344, g49344, b49344, blackDot;
	fontset = special3, "Times New Roman", 14, L0, nohscroll, r49344, g49344, b49344, blackDot, cellOutline;
	fontset = special4, "Times New Roman", 12, L0, nohscroll;
	fontset = special5, "Times New Roman", 14, L0, nohscroll, B65535, b0;
	fontset = leftheader, "Times New Roman", 12, L2;
	fontset = leftfooter, "Times New Roman", 12, L2;
	fontset = reserved1, "Courier New", 10, L0, nowordwrap, nohscroll;]
:[font = special2; inactive; preserveAspect; nohscroll; ]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 24; ]
Exploring Abstract Algebra with Mathematica
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 16; ]
Al Hibbard and Ken Levasseur
:[font = subsubtitle; inactive; preserveAspect; nohscroll; center; backColorRed = 65535; backColorGreen = 65535; backColorBlue = 65535; fontColorRed = 0; fontColorGreen = 0; fontColorBlue = 0; italic; fontName = "Times New Roman"; fontSize = 9; ]
 Copyright 1998 by Springer Verlag New York, Inc.
:[font = title; inactive; preserveAspect; startGroup; Cclosed; nohscroll; cellOutline; center; ]
Ring Lab 13. Finite fields
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.0 Note regarding Exploring Abstract Algebra with Mathematica
:[font = text; inactive; preserveAspect; nohscroll; ]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
:[font = text; inactive; preserveAspect; nohscroll; ]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
:[font = text; inactive; preserveAspect; nohscroll; ]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
Last revision: April 25, 1998

 Copyright 1998 Springer Verlag New York, Inc.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
To complete this lab, you should be familiar with the construction of a quotient ring of a ring of polynomials over a field F, as described in Ring Lab 10. You should also be familiar with Morphoids of rings.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup; nohscroll; ]
The goal of this lab is to introduce some of the properties of finite fields. Until now, we have mostly explored the general situation of polynomials over a ringoid mod an arbitrary polynomial. Now we assume that the base ringoid is a field and the polynomial is irreducible over that field. These assumptions are made easier to enforce by using the FiniteFields package in AbstractAlgebra.
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.3 Creation of finite fields
:[font = text; inactive; preserveAspect; nohscroll; ]
First, we make sure that the AbstractAlgebra packages are available and Rings is the DefaultStructure.
:[font = input; initialization; preserveAspect; nowordwrap; ]
*)
Needs["AbstractAlgebra`Master`"];
SwitchStructureTo[Rings]
(*
:[font = text; inactive; preserveAspect; nohscroll; ]
The package FiniteFields.m generates finite fields in a fashion similar to how QuotientRing does, but with restrictions on the allowable inputs so that only fields are generated. For example, the ring of polynomials over Z[3] mod the polynomial x^2 + 2 can be created with QuotientRing. It has 3^2 = 9 elements.
:[font = input; preserveAspect; nowordwrap; ]
Clear[x]
R = QuotientRing[Z[3], Poly[Z[3], x^2 + 2]]
:[font = text; inactive; preserveAspect; nohscroll; ]
As we can see by the result of Inverses, R is not a field.
:[font = input; preserveAspect; nowordwrap; ]
Inverses[R, RingOperation -> Multiplication]
:[font = text; inactive; preserveAspect; nohscroll; ]
This is because the modulus polynomial, x^2 +2, can be factored as (x+1)(x+2) over Z[3]. The built-in function Factor can show this.
:[font = input; preserveAspect; nowordwrap; ]
Factor[x^2 + 2, Modulus -> 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
One can also verify this as follows.
:[font = input; preserveAspect; nowordwrap; ]
IrreduciblePolyOverZpQ[Poly[Z[3], x^2 + 2], 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
The ring R has zero divisors. For example, the product of x + 1 and x + 2 is 0.
:[font = input; preserveAspect; nowordwrap; ]
Multiplication[R][Poly[Z[3], x + 1], Poly[Z[3], x + 2]]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q1. Evaluate the cell below, which creates the multiplication table for R. Are there any other zero divisors?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = input; preserveAspect; nowordwrap; ]
MultiplicationTable[R, Mode -> Visual];
:[font = text; inactive; preserveAspect; nohscroll; ]
In the rest of this lab we can avoid this type of ring by using the GF function. GF[n] returns the Galois field (hence, GF) of order n (if n = p^d for some prime p), while GF[n, poly] creates the finite field using the specified irreducible polynomial. Here is a field with nine elements, the same polynomials of degree one or less that are contained in R above, but the multiplication operation is different
:[font = input; preserveAspect; nowordwrap; ]
F1 = GF[9]
:[font = text; inactive; preserveAspect; nohscroll; ]
In F1, the product of x + 1 and x + 2 is not zero. 
:[font = input; preserveAspect; nowordwrap; ]
Multiplication[F1][x + 1, x + 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Another advantage to using GF is that the elements of the ringoids that are created are simply ordinary polynomial expressions, as opposed to the more complex structures created with the Poly function.
:[font = text; inactive; preserveAspect; nohscroll; ]
F1 is a field because its modulus polynomial is irreducible over Z[3].
:[font = input; preserveAspect; nowordwrap; ]
FieldIrreducible[F1]
Factor[%, Modulus -> 3]
:[font = text; inactive; preserveAspect; nohscroll; ]
An alternate irreducible polynomial is also allowed; one simply adds it as a second argument to GF. GF will not allow a reducible polynomial, however.
:[font = input; preserveAspect; nowordwrap; ]
GF[9, x^2 + 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
Here is a valid alternate irreducible polynomial over Z[3].
:[font = input; preserveAspect; nowordwrap; ]
F2 = GF[9, x^2 + 2x + 2]
:[font = text; inactive; preserveAspect; nohscroll; ]
You can check a polynomial to see if it is irreducible with IrreduciblePolyOverZpQ.
:[font = input; preserveAspect; endGroup; nowordwrap; ]
Map[IrreduciblePolyOverZpQ[#, 3]&, {x^2 + 2, x^2 +  2x + 2}]
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.4 Finite field theorems and illustrations
:[font = text; inactive; preserveAspect; nohscroll; ]
We will list some of the basic theorems in the theory of finite fields. Your text will likely contain the proofs of them (or they may be exercises). We will illustrate these theorems with examples to give you a better feel for what they say and what their implications are. The first theorem severely restricts the possible size (or order) of a finite field.
:[font = text; inactive; preserveAspect; nohscroll; ]
Theorem 1. Every finite field is of order p^k for some prime p and positive integer k.
:[font = text; inactive; preserveAspect; nohscroll; ]
Because of Theorem 1, GF will not accept an order such as 6.
:[font = input; preserveAspect; nowordwrap; ]
GF[6]
:[font = text; inactive; preserveAspect; nohscroll; ]
For a given order, there is really no variety among fields of that order.
:[font = text; inactive; preserveAspect; nohscroll; ]
Theorem 2. All finite fields of order p^k, p a prime, are isomorphic
:[font = text; inactive; preserveAspect; nohscroll; ]
The same field can appear in many different forms and be created in different ways. We illustrate this theorem by generating GF[8] with two different irreducible polynomials over Z[2], p1 = x^3 + x + 1 and p2 = x^3 + x^2 + 1. We should be able to create an isomorphism between these fields.
:[font = input; preserveAspect; nowordwrap; ]
F3 = GF[8, p1 = x^3 + x + 1]
:[font = input; preserveAspect; nowordwrap; ]
F4 = GF[8, p2 = x^3 + x^2 + 1]
:[font = text; inactive; preserveAspect; nohscroll; ]
One reasonable guess might be that the identity function is an isomorphism, since the domains are identical.
:[font = input; preserveAspect; nowordwrap; ]
id = FormMorphoid[Identity, F3, F4]
:[font = text; inactive; preserveAspect; nohscroll; ]
This morphism is certainly one-to-one and onto, but it does not satisfy the morphism property for some pairs. For example, x^2 and x, is such a pair. 
:[font = input; preserveAspect; nowordwrap; ]
PreservesQ[id, {x^2, x}, Mode -> Visual]
:[font = text; inactive; preserveAspect; nohscroll; ]
Another reasonable guess might be that the squaring function that takes each element in F3 to its square (in F4). 
:[font = input; preserveAspect; nowordwrap; ]
theta = FormMorphoid[(ElementToPower[F3, #, 2])&, F3, F4]
:[font = text; inactive; preserveAspect; nohscroll; ]
This map is one-to-one.
:[font = input; preserveAspect; nowordwrap; ]
OneToOneQ[theta]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q2. Is there any need to check whether theta is onto? Why or why not?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
In the end, this attempt fails also. 
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[theta]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q3. Give one concrete example why theta is not a morphism.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
A final attempt begins by looking for the roots of p1 in F3. This is a bit tricky since we need to use the operations of F3 to evaluate a polynomial expression. Here is a function that does this calculation. 
:[font = input; preserveAspect; nowordwrap; ]
evalp1[p_]:= Addition[F3][1, Addition[F3][p, ElementToPower[F3,
	p, 3]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we evaluate p1 at each element of F3. The first column has an element of F3 and the second is p1 evaluated at the element.
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, evalp1[#]}&, Elements[F3]]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
We can see that the roots of p1 = x^3 + x + 1 are x, x^2 and x^2 + x. (Why is this the case?) Now consider p2 = x^3 + x^2 + 1, the irreducible polynomial for F4. Let's see if the roots for p2 are in F3. Again, the function to do the evaluation is a bit messy. 
:[font = input; preserveAspect; nowordwrap; ]
evalp2[p_]:= Addition[F3][1, Addition[F3][ElementToPower[F3,
	p, 2], ElementToPower[F3, p, 3]]]
:[font = text; inactive; preserveAspect; nohscroll; ]
Now we evaluate the modulus polynomial p2 at each element of F3.
:[font = input; preserveAspect; nowordwrap; ]
Map[{#, evalp2[#]}&, Elements[F3]]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
All three roots of p2 = x^3 + x^2 + 1 are in F3 also. Notice that they are the roots of p1, with 1 added to each of them. With this observation, we will make an attempt of finding a morphism by generating a function using the rule x -> x + 1. After applying this rule, we simplify the expression. Therefore, the image of x^2 will be (x + 1)2, which expands to x^2 + 1, since x + x = (1 + 1) x = 0. 
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q4. By hand, determine each of the remaining images according to the function that was just described and illustrated.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Now that we have a function in mind to work with, we will use FormMorphoidSetup to determine a position list for forming a Morphoid.
:[font = input; preserveAspect; nowordwrap; ]
FormMorphoidSetup[F3, F4];
:[font = text; inactive; preserveAspect; nohscroll; ]
With the graphic above, you can describe a function using a list such as {a1, a2, ..., a8}. A list of this sort implies that the image of the first entry on the left is the one in position a1 on the right, the image of the second entry on the left is the one in position a2 on the right, and so on. For example, the identity function would be defined by the list {1, 2, 3, 4, 5, 6, 7, 8}. Based on your answer to the previous question, fill in the list corresponding to this attempt at an isomorphism. Evaluate the cell after you have filled in the list.
:[font = input; preserveAspect; nowordwrap; ]
tau = FormMorphoid[{fill this list with an ordering of 1..8 }, 
	F3, F4]
:[font = text; inactive; preserveAspect; nohscroll; ]
Your function will be one-to-one and onto if the position list is a permutation of {1, 2, 3, 4, 5, 6, 7, 8}. Now let's see if we have an isomorphism. It should work if you answered question 4 correctly. You should get True for your next output!
:[font = input; preserveAspect; nowordwrap; ]
MorphismQ[tau]
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q5. It follows from Theorem 2 that the two fields of order 9, F1 and F2 that were generated earlier, are isomorphic. Is the identity function an isomorphism between them? If so, are there more isomorphisms? If not, find at least one isomorphism. 
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The nonzero elements of any field form a multiplicative group. In the finite case, the group is particularly simple.
:[font = text; inactive; preserveAspect; nohscroll; ]
Theorem 3. The multiplicative group of nonzero elements of a finite field is cyclic.
:[font = input; preserveAspect; nowordwrap; ]
G = FormGroupoid[Units[F3], Multiplication[F3]]
:[font = input; preserveAspect; nowordwrap; ]
CyclicQ[G]
:[font = text; inactive; preserveAspect; nohscroll; ]
The linear monomial term, x in this case, happens to be a generator for GF[n]. To view the powers of x, you can use PowerList. 
:[font = input; preserveAspect; nowordwrap; ]
PowerList[F3]//TableForm
:[font = text; inactive; preserveAspect; nohscroll; ]
Note that this indicates that x^6 is x^2 + 1. Also, notice that PowerList acts on the whole finite field and will always start with {0, 0}, which is a special case since 0 is not in the group. One could evaluate Rest[PowerList[F3]] to get only the powers of x.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q6. To what more common group is G isomorphic? What cyclic groups of order 20 or less are isomorphic to the group of units of some finite field?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The concept of a subfield is similar to that of a subring. A subfield of a field F is a subset of F that is a field, using the operations of F.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q7. Find a subfield of GF[16] containing 4 elements. Use Theorem 3 to explain why GF[16] has no subfield of order 8.
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
The previous question generalizes to the following theorem about subfields of a finite field.
:[font = text; inactive; preserveAspect; nohscroll; ]
Theorem 4. If F is a finite field of order p^k, then F has a subfield of order p^j if and only if j is a divisor of k.
:[font = text; inactive; preserveAspect; nohscroll; ]
For example, the field GF[2^6] has proper subfields of order 2, 2^2 = 4 and 2^3 = 8, but not 2^4 or 2^5. The only proper subfield of GF[2^5] has 2 elements.
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q8. If p is a prime, what are the divisors of p^n - 1? What connection does this have with Theorem 4?
:[font = special2; inactive; preserveAspect; nohscroll; ]
Answer: 
:[font = text; inactive; preserveAspect; nohscroll; ]
Theorem 5. The function f : GF[p^n] -> GF[p^n] defined by f(a) = a^p is an automorphism of GF[p^n], called the Frobenius automorphism. 
:[font = text; inactive; preserveAspect; nohscroll; ]
Earlier, we examined a similar function between two versions of GF[2^3] that were based on different irreducible polynomials and the function was not a morphism. However, the Frobenius automorphism has the same field for both domain and codomain. We can easily create the Frobenius automorphism. The following Morphoid is identical to theta, that is defined above, except that the codomain is changed from F4 to F3. We convert it to the rules format to see the images of each element more easily.
:[font = input; preserveAspect; nowordwrap; ]
f = FormMorphoid[(ElementToPower[F3, #, 2])&, F3, F3]//ToRules
:[font = text; inactive; preserveAspect; nohscroll; ]
The following shows this is an isomorphism.
:[font = input; preserveAspect; nowordwrap; ]
OneToOneQ[f] && MorphismQ[f]
:[font = text; inactive; preserveAspect; nohscroll; ]
Theorem 6. The group of automorphisms of GF[p^n] is the set {f, f^2, ..., f^n = i} where f is the Frobenius automorphism. 
:[font = text; inactive; preserveAspect; nohscroll; ]
We can create this group of automorphisms easily enough and then look at its table.
:[font = input; preserveAspect; nowordwrap; ]
Aut = GenerateGroupoid[{f}, MorphoidComposition[#1, #2]&,
	WideElements -> True]
:[font = input; preserveAspect; nowordwrap; ]
CayleyTable[Aut, Mode -> Visual, ShowKey -> False];
:[font = special3; inactive; preserveAspect; nohscroll; cellOutline; ]
Q9. We see that the automorphism group of GF[8] is isomorphic to Z[3]. What about the automorphism group of GF[16]?  To what is this isomorphic?
:[font = special2; inactive; preserveAspect; endGroup; nohscroll; ]
Answer: 
:[font = section; inactive; preserveAspect; startGroup; Cclosed; nohscroll; ]
13.5 Mathematica commands used in this lab
:[font = text; inactive; preserveAspect; nohscroll; ]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
:[font = input; preserveAspect; nowordwrap; ]
?QuotientRing
:[font = input; preserveAspect; nowordwrap; ]
?Inverses
:[font = input; preserveAspect; nowordwrap; ]
?ExtensionDegree
:[font = input; preserveAspect; nowordwrap; ]
?FormMorphoid
:[font = input; preserveAspect; nowordwrap; ]
?OneToOneQ
:[font = input; preserveAspect; nowordwrap; ]
?OntoQ
:[font = input; preserveAspect; nowordwrap; ]
?MorphismQ
:[font = input; preserveAspect; nowordwrap; ]
?FormMorphoidSetup
:[font = input; preserveAspect; nowordwrap; ]
?FieldIrreducible
:[font = input; preserveAspect; nowordwrap; ]
?GaloisFieldQ
:[font = input; preserveAspect; nowordwrap; ]
?GF
:[font = input; preserveAspect; nowordwrap; ]
?IrreduciblePolynomial
:[font = input; preserveAspect; nowordwrap; ]
?IrreduciblePolyOverZpQ
:[font = input; preserveAspect; nowordwrap; ]
?PowerList
:[font = input; preserveAspect; nowordwrap; ]
?PrimitivePolynomials
:[font = input; preserveAspect; nowordwrap; ]
?TableOfPowers
:[font = input; preserveAspect; endGroup; endGroup; nowordwrap; ]
?GenerateGroupoid
^*)