(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     36198,       1112]*)
(*NotebookOutlinePosition[     37281,       1149]*)
(*  CellTagsIndexPosition[     37237,       1145]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[CellGroupData[{Cell[TextData["Initializations"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"<<Geometry`Rotations`\n<<Ring`\n<<Graphics`Polyhedra`\n<<Graphics`Shapes`\n\
<<NumberTheory`Recognize`\n<<Graphics`Animation`\nActionOn[obj_,g_]:=\n \
obj/.{{a_,b_,c_}/;And@@NumberQ/@{a,b,c}:>g.{a,b,c}};\n\
ActionOn::usage=\"ActionOn[obj,g] is the 3D-graphics object obtained\nwhen \
rotation matrix g acts on 3D-graphics object obj.  This is accomplished\nby \
multiplying every triple of numbers appearing in obj by g.\";\n\
disp=Show[Graphics3D[#],PlotRange->{{-2,2},{-2,2},{-2,2}}]& ;\n\
compare=Show[GraphicsArray[\n         \
{Graphics3D[#1,PlotRange->{{-2,2},{-2,2},{-2,2}}],\n          \
Graphics3D[ActionOn[#1,#2],PlotRange->{{-2,2},{-2,2},{-2,2}}]}]]& ;\n\
compare::usage=\"compare[obj,g] displays the 3D-graphics objects\nobj and \
ActionOn[obj,g] side by side.\";\nexact=If[Abs[#]<=0.00000001,\n         0,\n \
        ((x=#)//Recognize[x,3,t]&//Solve[#==0,t]&//(t/.#)&//\n           \
Select[#,(Abs[x-N[#]]<=0.000001)&]&//First)]&;\nexact::usage=\"exact[x_Real] \
converts x to an exact number involving \nintegers and roots (square and cube \
roots only).\";\n\n"], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Goal"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"To identify the rotation groups of polyhedra and to explore how a limited \
number of faces together with the rotational group can be used to represent a \
polyhedron."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Prerequisite"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Familiarity with Euler angles (see Rotations Lab Appendix for a reveiw) and \
group actions."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Example - the Tetrahedron"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Consider the tetrahedron."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["object=Tetrahedron[];"], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["object//disp"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
Graphics3D[\"<<>>\"]\
\>", 
"\<\
-Graphics3D-\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox[
  "We will be examining certain rotation matrices that act on graphics \
objects like the Tetrahedron.  The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ActionOn",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" will be used extensively in this notebook.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["?ActionOn"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"ActionOn[obj,g] the the 3D-graphics object obtained when rotation matrix g \
acts on 3D-graphics\n  object obj.  This accomplished by multiplying every \
triple of numbers appearing in obj by g."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox[
  "We will want to consider the rotation that make up the so-called \
rotational group of tetrahedron, the ones that result in an tetrahedron that \
occupies the same space as the original object.   We can use the fuction ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["compare",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  " to visually confirm whether a rotation is in the rotation group.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["?compare"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"compare[obj,g] displays the 3D-graphics objects obj and ActionOn[obj,g] side \
by side."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox["Here is an example of a rotation that we ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["won't",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontVariations->{"Underline"->True}],
  StyleBox[" want to consider.  ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["compare[object,RotationMatrix3D[Pi/6,Pi/4,Pi/8]]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
GraphicsArray[\"<<>>\"]\
\>", 
"\<\
-GraphicsArray-\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox[
  "One example of an element in the rotational group of this tetrahedron is ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RotationMatrix3D[2Pi/3,0,0]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontSize->10,
    FontWeight->"Bold"],
  StyleBox[
  ".  The specific Euler angles that describe this matrix are dependent on \
the position of the tetrahedron.  One of its faces lies on a plane that is \
parallel to the x-y plane and so a 2\.ba/3 rotation about the z-axis is in \
the rotation group.  Also, it's important to note that the tetrahedron needs \
to be centered about the origin.  All polyhedra in the standard ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["  package Polyhedra.m are centered about the origin.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["r1=RotationMatrix3D[2Pi/3,0,0];r1//MatrixForm\n"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
MatrixForm[{{-1/2, 3^(1/2)/2, 0}, {-3^(1/2)/2, -1/2, 0}, {0, 0, \
1}}]\
\>", "\<\
  1        Sqrt[3]
-(-)       -------
  2           2       0

-Sqrt[3]     1
--------   -(-)
   2         2        0



0          0          1\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["compare[object,r1]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
GraphicsArray[\"<<>>\"]\
\>", 
"\<\
-GraphicsArray-\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox["It isn't too difficult to identify ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["r1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  " as a member of the rotational group.  But how would we identify more \
complicated rotations?  One way is by multiplying rotations.  Given any set \
of rotations, we can generate a group.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["g1=GenerateGroupoid[{r1},Simplify[#1.#2]&]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
Groupoid[{{{-1/2, -3^(1/2)/2, 0}, {3^(1/2)/2, -1/2, 0}, {0, 0, 1}}, 
 {{-1/2, 3^(1/2)/2, 0}, {-3^(1/2)/2, -1/2, 0}, {0, 0, 1}}, {{1, 0, 0}, {0, 1, \
0}, {0, 0, 1}}},
 Simplify[#1 . #2] & ]\
\>", 
"\<\
              1   -Sqrt[3]       Sqrt[3]    1
Groupoid[{{{-(-), --------, 0}, {-------, -(-), 0}, {0, 0, 1}}, 
              2      2              2       2
     1   Sqrt[3]       -Sqrt[3]    1
 {{-(-), -------, 0}, {--------, -(-), 0}, {0, 0, 1}}, {{1, 0, 0}, {0, 1, 0}, \
{0, 0, 1}}}, 
     2      2             2        2
 Simplify[#1 . #2] & ]\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Order[g1]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
3\
\>", "\<\
3\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[
"This is a cyclic subgroup of order three, not all of the group of rotations. \
\n\nWe can count the number of elements in the rotational group by \
considering the various final positions that any single fixed face of the \
tetrahedron could occupy.  Since there are four identical triangular faces \
and each face can be oriented in three ways, there are 12 rotations of the \
tetrahedron.   It may or may not be obvious to you what other rotation \
matrices are in the desired group.  At this point, we will outline a process \
to find these matrices systematically."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData[
"Graphics3D[\n  {object,\n   \
Map[Text[ToString[#],Vertices[Tetrahedron][[#]]]&,\n        \
Range[1,Length[Vertices[Tetrahedron]]]]\n   }]//\n\
WireFrame//Show[#,DefaultFont->{\"Times\",24}]&"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
Graphics3D[\"<<>>\"]\
\>", 
"\<\
-Graphics3D-\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox["The first rotation (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["r1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  ") that we identified maps the (ordered) face {1, 3, 4} into the face {1,  \
2,  3} and by applying it again into {1, 4, 2}.  Now suppose that we want to \
map {1, 3, 4} into {4, 3, 2}.  Let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["R",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" be the unknown matrix.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["R=Array[r,{3,3}]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{{r[1, 1], r[1, 2], r[1, 3]}, {r[2, 1], r[2, 2], r[2, 3]}, {r[3, 1], \
r[3, 2], r[3, 3]}}\
\>", 
"\<\
{{r[1, 1], r[1, 2], r[1, 3]}, {r[2, 1], r[2, 2], r[2, 3]}, {r[3, 1], \
r[3, 2], r[3, 3]}}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox[
  "Before setting up a system of equations to solve for the rotation matrix, \
we need to take the vertex coordinates given in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  "  Polyhedra package and make them exact.  For this we use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["exact",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["?exact"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"exact[x_Real] converts x to an exact number involving   integers and roots \
(square and cube\n  roots only)."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData["Here are the vertices given in the package."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["Vertices[Tetrahedron]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{{0, 0, 1.732050807568877}, {0, 1.632993161855452, -0.5773502691896259}, \

 {-1.414213562373095, -0.816496580927726, -0.5773502691896259}, 
 {1.414213562373095, -0.816496580927726, -0.5773502691896259}}\
\>", 
"\<\
{{0, 0, 1.73205}, {0, 1.63299, -0.57735}, {-1.41421, -0.816497, \
-0.57735}, 
 {1.41421, -0.816497, -0.57735}}\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData["The following are exact values"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["evertices=Map[exact,Vertices[Tetrahedron],{2}]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{{0, 0, 3^(1/2)}, {0, 2*(2/3)^(1/2), -3^(-1/2)}, {-2^(1/2), \
-(2/3)^(1/2), -3^(-1/2)}, 
 {2^(1/2), -(2/3)^(1/2), -3^(-1/2)}}\
\>", 
"\<\
                             2        1                        2        \
1
{{0, 0, Sqrt[3]}, {0, 2 Sqrt[-], -(-------)}, {-Sqrt[2], -Sqrt[-], \
-(-------)}, 
                             3     Sqrt[3]                     3     Sqrt[3]
                 2        1
 {Sqrt[2], -Sqrt[-], -(-------)}}
                 3     Sqrt[3]\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData[
"Although a system can be generated more efficiently, we write it out here a \
bit more descriptively."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData[
"sys={R.evertices[[1]]==evertices[[4]]   (* vertex 1 maps to vertex 4 *),\n   \
  R.evertices[[3]]==evertices[[3]]   (* vertex 3 maps to vertex 3 *),\n     \
R.evertices[[4]]==evertices[[2]]   (* vertex 4 maps to vertex 2 *)}\n     "], 
  "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{{3^(1/2)*r[1, 3], 3^(1/2)*r[2, 3], 3^(1/2)*r[3, 3]} == {2^(1/2), \
-(2/3)^(1/2), -3^(-1/2)}, 
 {-(2^(1/2)*r[1, 1]) - (2/3)^(1/2)*r[1, 2] - r[1, 3]/3^(1/2), 
 -(2^(1/2)*r[2, 1]) - (2/3)^(1/2)*r[2, 2] - r[2, 3]/3^(1/2), 
 -(2^(1/2)*r[3, 1]) - (2/3)^(1/2)*r[3, 2] - r[3, 3]/3^(1/2)} == 
 {-2^(1/2), -(2/3)^(1/2), -3^(-1/2)}, 
 {2^(1/2)*r[1, 1] - (2/3)^(1/2)*r[1, 2] - r[1, 3]/3^(1/2), 
 2^(1/2)*r[2, 1] - (2/3)^(1/2)*r[2, 2] - r[2, 3]/3^(1/2), 
 2^(1/2)*r[3, 1] - (2/3)^(1/2)*r[3, 2] - r[3, 3]/3^(1/2)} == {0, \
2*(2/3)^(1/2), -3^(-1/2)}}\
\>", 
"\<\
                                                                        \
2        1
{{Sqrt[3] r[1, 3], Sqrt[3] r[2, 3], Sqrt[3] r[3, 3]} == {Sqrt[2], -Sqrt[-], \
-(-------)}, 
                                                                        3     \
Sqrt[3]
                            2            r[1, 3]
 {-(Sqrt[2] r[1, 1]) - Sqrt[-] r[1, 2] - -------, 
                            3            Sqrt[3]
                           2            r[2, 3]
 -(Sqrt[2] r[2, 1]) - Sqrt[-] r[2, 2] - -------, 
                           3            Sqrt[3]
                           2            r[3, 3]                      2        \
1
 -(Sqrt[2] r[3, 1]) - Sqrt[-] r[3, 2] - -------} == {-Sqrt[2], -Sqrt[-], \
-(-------)}, 
                           3            Sqrt[3]                      3     \
Sqrt[3]
                         2            r[1, 3]                         2       \
     r[2, 3]
 {Sqrt[2] r[1, 1] - Sqrt[-] r[1, 2] - -------, Sqrt[2] r[2, 1] - Sqrt[-] r[2, \
2] - -------, 
                         3            Sqrt[3]                         3       \
     Sqrt[3]
                        2            r[3, 3]                2        1
 Sqrt[2] r[3, 1] - Sqrt[-] r[3, 2] - -------} == {0, 2 Sqrt[-], -(-------)}}
                        3            Sqrt[3]                3     \
Sqrt[3]\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["r2=R/.Solve[sys,Flatten[R]]//First//Simplify\n"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{{1/2, 1/(2*3^(1/2)), (2/3)^(1/2)}, {3^(1/2)/2, -1/6, -2^(1/2)/3}, {0, \
(2*2^(1/2))/3, -1/3}}\
\>", 
"\<\
  1      1           2     Sqrt[3]    1   -Sqrt[2]       2 Sqrt[2]    1
{{-, ---------, Sqrt[-]}, {-------, -(-), --------}, {0, ---------, -(-)}}
  2  2 Sqrt[3]       3        2       6      3               3        3\
\>"],
   "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["compare[object,r2]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
GraphicsArray[\"<<>>\"]\
\>", 
"\<\
-GraphicsArray-\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox[
  "This is the rotation matrix that we are looking for.  It would be nice to \
know what the values of phi, theta and psi that produce ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["r2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".  We leave that as an exercise.  ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Now that we have two distinct rotations of the tetrahedron, we might be able \
to generate a larger group."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData[
"g2=GenerateGroupoid[{r1,r2},Simplify[#1.#2]&];\nOrder[g2]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
12\
\>", "\<\
12\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData[
"This should be the whole group that we are searching for.  Now to \
demonstrate how the group generates all rotations, we will start with a \
single marked face of the tetrahedron. "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"markedface=object[[2]]//\n           {#,\n            RGBColor[0.022, 0.688, \
0.717],\n            Thickness[0.01],\n            \
Line[{Apply[Plus,object[[2,1]]]/3, 1.1 #[[1,1]]}],\n            \
RGBColor[0.701, 0.038, 0.038],\n            PointSize[0.03],\n            \
Point[1.1 #[[1,1]]]}&//disp;"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"First we will look at the individual effects of each group element on this \
face."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData[
"Map[ActionOn[markedface,#]&,First[g2]]//\n         Partition[#,4]&//\n       \
  GraphicsArray//Show"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
GraphicsArray[\"<<>>\"]\
\>", 
"\<\
-GraphicsArray-\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData["Taken together, we get a single tetrahedron. "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["Map[ActionOn[markedface,#]&,First[g2]]//Show\n"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
Graphics3D[\"<<>>\"]\
\>", 
"\<\
-Graphics3D-\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Exercises"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["1"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "(a)  How many element would you expect to find in the group of rotations \
of the cube?\n(b)  Generate the group of rotations of the cube that is \
contained in the Polyhedra package,",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" Cube[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".  ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Cube[]//disp;"], "Input",
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["2"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "(a)  How many element would you expect to find in the group of rotations \
of the dodecahedron?\n(b)  Generate the group of rotations of the \
dodecahedron that is contained in the Polyhedra package,",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" Dodecahedron[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".  ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Dodecahedron[]//disp;"], "Input",
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData[
"3.  Rotational Groups of the Octahedron and Icosahedron."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"The octahedron is the dual of the cube.   If each face of the cube is \
replaced with a point at its center and points that are derived from adjacent \
faces are connected then the wire frame of an octahedron will appear.  \
Explain why the roational group of the octahedron should be isomorphic to \
that of the cube.  The dodecahedron and icosahedron pair up in the same \
way."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["4.  The cuboctahedron"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["?Truncate"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Truncate[expr] truncates each edge of each polygon in expr. Truncate[expr, \
ratio] truncates to\n  the specified ratio of the edge length."], "Print",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Cube[]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{Polygon[{{0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, 0.7071067811865475}}], 
 Polygon[{{0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, 0.7071067811865475, -0.7071067811865475}}], 
 Polygon[{{0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, 0.7071067811865475}}], 
 Polygon[{{-0.7071067811865475, 0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, 0.7071067811865475}}], 
 Polygon[{{-0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {-0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, 0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, -0.7071067811865475}}], 
 Polygon[{{-0.7071067811865475, -0.7071067811865475, 0.7071067811865475}, 
 {-0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, -0.7071067811865475}, 
 {0.7071067811865475, -0.7071067811865475, 0.7071067811865475}}]}\
\>", 
"\<\
{Polygon[{{0.707107, 0.707107, 0.707107}, {-0.707107, 0.707107, \
0.707107}, 
 {-0.707107, -0.707107, 0.707107}, {0.707107, -0.707107, 0.707107}}], 
 Polygon[{{0.707107, 0.707107, 0.707107}, {0.707107, -0.707107, 0.707107}, 
 {0.707107, -0.707107, -0.707107}, {0.707107, 0.707107, -0.707107}}], 
 Polygon[{{0.707107, 0.707107, 0.707107}, {0.707107, 0.707107, -0.707107}, 
 {-0.707107, 0.707107, -0.707107}, {-0.707107, 0.707107, 0.707107}}], 
 Polygon[{{-0.707107, 0.707107, 0.707107}, {-0.707107, 0.707107, -0.707107}, 
 {-0.707107, -0.707107, -0.707107}, {-0.707107, -0.707107, 0.707107}}], 
 Polygon[{{-0.707107, -0.707107, -0.707107}, {-0.707107, 0.707107, \
-0.707107}, 
 {0.707107, 0.707107, -0.707107}, {0.707107, -0.707107, -0.707107}}], 
 Polygon[{{-0.707107, -0.707107, 0.707107}, {-0.707107, -0.707107, \
-0.707107}, 
 {0.707107, -0.707107, -0.707107}, {0.707107, -0.707107, 0.707107}}]}\
\>"], 
  "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["Truncate[Tetrahedron[],0.48]"], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Join::heads: Heads Polygon and List at positions 1 and 2 are expected to be \
the same."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Join::heads: Heads Graphics3D and List at positions 1 and 2 are expected to \
be the same."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
Join[Graphics3D[\"<<>>\"], {Polygon[{{-0.6788225099390857, \
-0.3919183588453085, 
 0.6235382907247958}, {-0.7353910524340095, -0.4245782220824176, \
0.5311622476544553}, 
 {-0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {0.7353910524340095, -0.4245782220824176, 0.5311622476544554}, 
 {0.6788225099390857, -0.3919183588453085, 0.6235382907247958}}], 
 Polygon[{{0.6788225099390857, -0.3919183588453085, 0.6235382907247958}, 
 {0.7353910524340095, -0.4245782220824176, 0.5311622476544553}, 
 {0.7353910524340095, 0.3592584956081994, -0.5773502691896259}, 
 {0.6788225099390857, 0.4572380853195268, -0.5773502691896259}, 
 {0., 0.849156444164835, 0.5311622476544554}, {0., 0.7838367176906171, \
0.6235382907247958}}],
 Polygon[{{0.6788225099390857, 0.4572380853195268, -0.5773502691896259}, 
 {0.7353910524340095, 0.3592584956081994, -0.5773502691896259}, 
 {0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {-0.05656854249492383, -0.816496580927726, -0.5773502691896259}, 
 {-0.7353910524340095, 0.3592584956081994, -0.5773502691896259}, 
 {-0.6788225099390857, 0.4572380853195268, -0.5773502691896259}}]}]\
\>", 
"\<\
Join[-Graphics3D-, {Polygon[{{-0.678823, -0.391918, 0.623538}, 
 {-0.735391, -0.424578, 0.531162}, {-0.0565685, -0.816497, -0.57735}, 
 {0.0565685, -0.816497, -0.57735}, {0.735391, -0.424578, 0.531162}, 
 {0.678823, -0.391918, 0.623538}}], Polygon[{{0.678823, -0.391918, 0.623538}, \

 {0.735391, -0.424578, 0.531162}, {0.735391, 0.359258, -0.57735}, 
 {0.678823, 0.457238, -0.57735}, {0., 0.849156, 0.531162}, {0., 0.783837, \
0.623538}}], 
 Polygon[{{0.678823, 0.457238, -0.57735}, {0.735391, 0.359258, -0.57735}, 
 {0.0565685, -0.816497, -0.57735}, {-0.0565685, -0.816497, -0.57735}, 
 {-0.735391, 0.359258, -0.57735}, {-0.678823, 0.457238, -0.57735}}]}]\
\>"], 
  "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["5"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Determine the values of phi, theta and psi for which ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["RotationMatrix3D[phi, theta, psi]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" is equal to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["r2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[
  ".   Hint:  To equate two matrices, A and B,  and convert to a list of \
equations, you can use code something like  ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["(A==B)//Thread[#]&//Map[Thread[#]&,#]&//Flatten",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["solution"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData[
"\nClear[phi,theta,psi]\n\
sys2=(RotationMatrix3D[phi,theta,psi]==r2)//Thread[#]&//Map[Thread[#]&,#]&//\
Flatten"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{Cos[a]*Cos[c] - Cos[b]*Sin[a]*Sin[c] == 1/2, 
 Cos[c]*Sin[a] + Cos[a]*Cos[b]*Sin[c] == 1/(2*3^(1/2)), Sin[b]*Sin[c] == \
(2/3)^(1/2), 
 -(Cos[b]*Cos[c]*Sin[a]) - Cos[a]*Sin[c] == 3^(1/2)/2, 
 Cos[a]*Cos[b]*Cos[c] - Sin[a]*Sin[c] == -1/6, Cos[c]*Sin[b] == -2^(1/2)/3, 
 Sin[a]*Sin[b] == 0, -(Cos[a]*Sin[b]) == (2*2^(1/2))/3, Cos[b] == -1/3}\
\>", 
"\<\
                                         1
{Cos[a] Cos[c] - Cos[b] Sin[a] Sin[c] == -, 
                                         2
                                             1                            2
 Cos[c] Sin[a] + Cos[a] Cos[b] Sin[c] == ---------, Sin[b] Sin[c] == Sqrt[-], \

                                         2 Sqrt[3]                        3
                                            Sqrt[3]
 -(Cos[b] Cos[c] Sin[a]) - Cos[a] Sin[c] == -------, 
                                               2
                                           1                    -Sqrt[2]
 Cos[a] Cos[b] Cos[c] - Sin[a] Sin[c] == -(-), Cos[c] Sin[b] == --------, \
Sin[a] Sin[b] == 0, 
                                           6                       3
                     2 Sqrt[2]              1
 -(Cos[a] Sin[b]) == ---------, Cos[b] == -(-)}
                         3                  3\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData[
"From the last equation, it is clear what theta must equal."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["theta=ArcCos[-1/3]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
ArcCos[-1/3]\
\>", "\<\
         1
ArcCos[-(-)]
         3\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox["Now that theta is known, look at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["sys2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["sys2//Simplify"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{Cos[a]*Cos[c] + (Sin[a]*Sin[c])/3 == 1/2, 
 Cos[c]*Sin[a] - (Cos[a]*Sin[c])/3 == 1/(2*3^(1/2)), (2*2^(1/2)*Sin[c])/3 == \
(2/3)^(1/2), 
 (Cos[c]*Sin[a])/3 - Cos[a]*Sin[c] == 3^(1/2)/2, -(Cos[a]*Cos[c])/3 - \
Sin[a]*Sin[c] == -1/6, 
 (2*2^(1/2)*Cos[c])/3 == -2^(1/2)/3, (2*2^(1/2)*Sin[a])/3 == 0, 
 (-2*2^(1/2)*Cos[a])/3 == (2*2^(1/2))/3, True}\
\>", 
"\<\
                 Sin[a] Sin[c]    1                  Cos[a] Sin[c]       \
 1
{Cos[a] Cos[c] + ------------- == -, Cos[c] Sin[a] - ------------- == \
---------, 
                       3          2                        3          2 \
Sqrt[3]
 2 Sqrt[2] Sin[c]         2   Cos[c] Sin[a]                    Sqrt[3]
 ---------------- == Sqrt[-], ------------- - Cos[a] Sin[c] == -------, 
        3                 3         3                             2
 -(Cos[a] Cos[c])                      1   2 Sqrt[2] Cos[c]    -Sqrt[2]
 ---------------- - Sin[a] Sin[c] == -(-), ---------------- == --------, 
        3                              6          3               3
 2 Sqrt[2] Sin[a]       -2 Sqrt[2] Cos[a]    2 Sqrt[2]
 ---------------- == 0, ----------------- == ---------, True}
        3                       3                3\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[TextData[{
  StyleBox["The eight equations involves only ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["phi",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[" at this point.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{Cell[TextData["Solve[sys2[[8]],Cos[phi]]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{{Cos[a] -> -1}}\
\>", 
"\<\
{{Cos[a] -> -1}}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["phi=ArcCos[-1]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
Pi\
\>", "\<\
Pi\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["sys2"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{-Cos[c] == 1/2, Sin[c]/3 == 1/(2*3^(1/2)), (2*2^(1/2)*Sin[c])/3 == \
(2/3)^(1/2), 
 Sin[c] == 3^(1/2)/2, Cos[c]/3 == -1/6, (2*2^(1/2)*Cos[c])/3 == -2^(1/2)/3, \
True, True, True}\
\>", 
"\<\
            1  Sin[c]        1      2 Sqrt[2] Sin[c]         2           \
  Sqrt[3]
{-Cos[c] == -, ------ == ---------, ---------------- == Sqrt[-], Sin[c] == \
-------, 
            2    3       2 Sqrt[3]         3                 3                \
2
 Cos[c]      1   2 Sqrt[2] Cos[c]    -Sqrt[2]
 ------ == -(-), ---------------- == --------, True, True, True}
   3         6          3               3\
\>"], "Output",
  Evaluatable->False,
  LineSpacing->{0.6, 0},
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["psi=ArcCos[-1/2]"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
(2*Pi)/3\
\>", "\<\
2 Pi
----
 3\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["sys2"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData[
"\<\
{True, True, True, True, True, True, True, True, True}\
\>", 
"\<\
{True, True, True, True, True, True, True, True, True}\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]],

Cell[CellGroupData[{Cell[TextData["{phi,theta,psi}"], "Input",
  AspectRatioFixed->True],

Cell[OutputFormData["\<\
{Pi, ArcCos[-1/3], (2*Pi)/3}\
\>", 
"\<\
              1    2 Pi
{Pi, ArcCos[-(-)], ----}
              3     3\
\>"], "Output",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData[
"6. Why should the method of finding rotation matrices used above work?"], 
  "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let T be a triangle in three dimensional real space whose veritices are \
linearly independent.   Prove that if R is a three by three matrix with the \
property that the triangle R.T is congruent to T then R is a rotation \
matrix."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 509},
WindowMargins->{{76, Automatic}, {15, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 92, 2, 70, "Section",
  Evaluatable->False],
Cell[1826, 55, 1158, 18, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[3016, 75, 81, 2, 70, "Section",
  Evaluatable->False],
Cell[3100, 79, 242, 5, 70, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3374, 86, 89, 2, 70, "Section",
  Evaluatable->False],
Cell[3466, 90, 167, 4, 70, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3665, 96, 102, 2, 70, "Section",
  Evaluatable->False],
Cell[3770, 100, 99, 2, 70, "Text",
  Evaluatable->False],
Cell[3872, 104, 102, 2, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[3997, 108, 65, 1, 70, "Input"],
Cell[4065, 111, 160, 8, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[4237, 121, 497, 16, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4757, 139, 62, 1, 70, "Input"],
Cell[4822, 142, 270, 5, 70, "Print",
  Evaluatable->False]
}, Open  ]],
Cell[5104, 149, 626, 18, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5753, 169, 61, 1, 70, "Input"],
Cell[5817, 172, 163, 4, 70, "Print",
  Evaluatable->False]
}, Open  ]],
Cell[5992, 178, 385, 13, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6400, 193, 101, 1, 70, "Input"],
Cell[6504, 196, 141, 7, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[6657, 205, 1053, 29, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7733, 236, 100, 1, 70, "Input"],
Cell[7836, 239, 317, 18, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[8185, 259, 71, 1, 70, "Input"],
Cell[8259, 262, 141, 7, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[8412, 271, 557, 17, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8992, 290, 95, 1, 70, "Input"],
Cell[9090, 293, 664, 19, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[9786, 314, 62, 1, 70, "Input"],
Cell[9851, 317, 104, 6, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[9967, 325, 643, 10, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10633, 337, 245, 5, 70, "Input"],
Cell[10881, 344, 160, 8, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[11053, 354, 755, 25, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11831, 381, 69, 1, 70, "Input"],
Cell[11903, 384, 282, 10, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[12197, 396, 712, 24, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12932, 422, 59, 1, 70, "Input"],
Cell[12994, 425, 185, 4, 70, "Print",
  Evaluatable->False]
}, Open  ]],
Cell[13191, 431, 117, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13331, 435, 74, 1, 70, "Input"],
Cell[13408, 438, 442, 14, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[13862, 454, 104, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13989, 458, 99, 1, 70, "Input"],
Cell[14091, 461, 582, 18, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[14685, 481, 176, 4, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14884, 487, 288, 5, 70, "Input"],
Cell[15175, 494, 1985, 45, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[17192, 541, 99, 1, 70, "Input"],
Cell[17294, 544, 444, 13, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[17770, 559, 71, 1, 70, "Input"],
Cell[17844, 562, 141, 7, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[17997, 571, 500, 16, 70, "Text",
  Evaluatable->False],
Cell[18500, 589, 181, 4, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18704, 595, 111, 2, 70, "Input"],
Cell[18818, 599, 131, 7, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[18961, 608, 256, 5, 70, "Text",
  Evaluatable->False],
Cell[19220, 615, 356, 6, 70, "Input"],
Cell[19579, 623, 157, 4, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19759, 629, 154, 3, 70, "Input"],
Cell[19916, 634, 141, 7, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[20069, 643, 119, 2, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20211, 647, 99, 1, 70, "Input"],
Cell[20313, 650, 160, 8, 70, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20514, 660, 86, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20623, 664, 81, 2, 70, "Subsection",
  Evaluatable->False],
Cell[20707, 668, 525, 17, 70, "Text",
  Evaluatable->False],
Cell[21235, 687, 66, 1, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21333, 690, 81, 2, 70, "Subsection",
  Evaluatable->False],
Cell[21417, 694, 549, 17, 70, "Text",
  Evaluatable->False],
Cell[21969, 713, 74, 1, 70, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22075, 716, 137, 3, 70, "Subsection",
  Evaluatable->False],
Cell[22215, 721, 454, 8, 70, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[22701, 731, 101, 2, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[22825, 735, 62, 1, 70, "Input"],
Cell[22890, 738, 215, 4, 70, "Print",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[23137, 744, 59, 1, 70, "Input"],
Cell[23199, 747, 2666, 47, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[25897, 796, 81, 1, 70, "Input"],
Cell[25981, 799, 165, 4, 70, "Message",
  Evaluatable->False],
Cell[26149, 805, 168, 4, 70, "Message",
  Evaluatable->False],
Cell[26320, 811, 1996, 39, 70, "Output",
  Evaluatable->False]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28357, 852, 81, 2, 70, "Subsection",
  Evaluatable->False],
Cell[28441, 856, 902, 29, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29366, 887, 91, 2, 70, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29480, 891, 165, 4, 70, "Input"],
Cell[29648, 897, 1365, 29, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[31025, 928, 133, 3, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31181, 933, 71, 1, 70, "Input"],
Cell[31255, 936, 148, 8, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[31415, 946, 367, 14, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[31805, 962, 67, 1, 70, "Input"],
Cell[31875, 965, 1309, 28, 70, "Output",
  Evaluatable->False]
}, Open  ]],
Cell[33196, 995, 381, 14, 70, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[33600, 1011, 78, 1, 70, "Input"],
Cell[33681, 1014, 135, 7, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[33848, 1023, 67, 1, 70, "Input"],
Cell[33918, 1026, 106, 6, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[34056, 1034, 57, 1, 70, "Input"],
Cell[34116, 1037, 714, 20, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[34862, 1059, 69, 1, 70, "Input"],
Cell[34934, 1062, 122, 8, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[35088, 1072, 57, 1, 70, "Input"],
Cell[35148, 1075, 212, 8, 70, "Output",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[35392, 1085, 68, 1, 70, "Input"],
Cell[35463, 1088, 201, 9, 70, "Output",
  Evaluatable->False]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35714, 1099, 154, 4, 70, "Subsection",
  Evaluatable->False],
Cell[35871, 1105, 306, 6, 70, "Text",
  Evaluatable->False]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
