(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26796,       1555]*)
(*NotebookOutlinePosition[     37667,       1856]*)
(*  CellTagsIndexPosition[     36820,       1823]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["6. Appendices", "Title"],

Cell[CellGroupData[{

Cell["6.1 Installation instructions", "Section",
  CellTags->"i:1"],

Cell[CellGroupData[{

Cell["6.1.1 Version 3.0 or higher", "Subsection",
  CellTags->"install3"],

Cell[TextData[{
  "From the CD, or from the web site (",
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  "), find the files appropriate for version 3.0 or higher. (Note that these \
files should work equally well on Macintosh, Unix or Windows platforms.) \
Place the entire ",
  StyleBox["AbstractAlgebra", "MR"],
  " directory into the ",
  StyleBox["Applications", "SR"],
  " directory (in the ",
  StyleBox["AddOns", "SR"],
  " directory in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory). Upon opening ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", choose ",
  StyleBox["Rebuild Help Index", "SR"],
  " from the ",
  StyleBox["Help", "SR"],
  " menu; this will enable the Help Browser to be aware of the help files \
accompanying ",
  StyleBox["AbstractAlgebra", "MR"],
  ". "
}], "Text",
  CellTags->"install3"],

Cell[TextData[{
  "For users of ",
  StyleBox["Exploring Abstract Algebra with Mathematica",
    FontSlant->"Italic"],
  ", there are several extra steps to take. Place the EAAM.nb style sheet in \
the ",
  StyleBox["StyleSheets", "SR"],
  " directory (in the ",
  StyleBox["FrontEnd", "SR"],
  " directory in the ",
  StyleBox["Configuration", "SR"],
  " directory). Similarly, the AbstractAlgebraPalette.nb palette should be \
placed in the ",
  StyleBox["Palettes", "SR"],
  " directory (in the ",
  StyleBox["FrontEnd", "SR"],
  " directory in the ",
  StyleBox["Configuration", "SR"],
  " directory). While the GrpLabs and RngLabs directories can be placed \
wherever convenient, to be accessible from the Help Browser, they should stay \
in the AbstractAlgebra directory. "
}], "Text",
  CellTags->"install3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.1.2 Version 2.x under Windows", "Subsection",
  CellTags->"install2w"],

Cell[TextData[{
  "From the CD, or from the web site (",
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  "), find the files appropriate for version 2.x under Windows. Place the \
entire ",
  StyleBox["AbstractAlgebra", "MR"],
  " directory (called ",
  StyleBox["Abstract", "MR"],
  " to limit the name to 8 characters) into the ",
  StyleBox["Packages", "SR"],
  " directory (in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory). The GrpLabs and RngLabs directories can be placed wherever \
convenient."
}], "Text",
  CellTags->"install2w"]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.1.3 Version 2.x under other platforms", "Subsection",
  CellTags->"install2o"],

Cell[TextData[{
  "From the CD, or from the web site (",
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  "), find the files appropriate for version 2.x under Macintosh or Unix. \
Place the entire ",
  StyleBox["AbstractAlgebra", "MR"],
  " directory into the ",
  StyleBox["Packages", "SR"],
  " directory (in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " directory). The GrpLabs and RngLabs directories can be placed wherever \
convenient."
}], "Text",
  CellTags->"install2o"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2 Version-specific notes", "Section",
  CellTags->"i:2"],

Cell[CellGroupData[{

Cell["6.2.1 Version 3.0 or higher", "Subsection",
  CellTags->"versnts3"],

Cell[TextData[{
  "There are a number of palettes available to complement ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". These can be found in the Palettes directory in the AbstractAlgebra \
directory. See the web site ",
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  " or a subsequent section of this appendix for details. For those who have \
downloaded the ",
  StyleBox["AbstractAlgebra", "MR"],
  " packages, but have not adopted the ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " text, there is a palette on this page that is publicly available ."
}], "Text",
  CellTags->"versnts3"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2.2 Version 2.x under Windows", "Subsection",
  CellTags->"versnts2w"],

Cell[TextData[{
  "As users of version 2.x under Windows are well aware, each cell contains \
only one possible style. Therefore, some of the emphases (italics, bold or \
otherwise) may be lost that are provided in other versions. Additonally, to \
discriminate input cells from text cells, all input cells have been colored \
yellow. (This can be changed by the user, if so inclined.) As you may be \
aware, there are a large number of advantages in upgrading to version 3.x, \
including a number of palettes available that complement ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"versnts2w"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2.3 Version 2.x under other platforms", "Subsection",
  CellTags->"versnts2o"],

Cell[TextData[{
  "As you may be aware, there are a large number of advantages in upgrading \
to version 3.x, including a number of palettes available that complement ",
  StyleBox["Exploring Abstract Algebra with",
    FontSlant->"Italic"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"versnts2o"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["6.3 References", "Section",
  CellTags->{"i:3", "MathematicaRefs"}],

Cell[TextData[{
  "Dornhoff, L. and",
  StyleBox[" ",
    FontSlant->"Italic"],
  "F. Hohn, ",
  StyleBox["Applied Modern Algebra",
    FontSlant->"Italic"],
  ", Macmillan, New York, 1978."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Fraleigh, J., ",
  StyleBox["A First Course in Abstract Algebra",
    FontSlant->"Italic"],
  ", Fifth Edition, Addison-Wesley, Reading, MA, 1994."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Herstein, I., ",
  StyleBox["Topics in Algebra",
    FontSlant->"Italic"],
  ", Second Edition, Wiley, New York, 1975."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Herstein, I., ",
  StyleBox["Abstract Algebra",
    FontSlant->"Italic"],
  ", Third Edition, Prentice-Hall, Upper Saddle River-STATE?, 1990."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Hungerford, T., ",
  StyleBox["Abstract Algebra: An Introduction,",
    FontSlant->"Italic"],
  " Second Edition, Saunders, New York, 1997."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Levasseur, K., \"A Microworld for Elementary Group Theory\", ",
  StyleBox["Mathematica in Education",
    FontSlant->"Italic"],
  ", 3 (Fall, 1994), pp. 5-10."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Lindl, R. and G. Pilz, ",
  StyleBox["Applied Abstract Algebra,",
    FontSlant->"Italic"],
  " Springer-Verlag, New York, 1984."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Lipson, J., ",
  StyleBox["Elements of Algebra & Algebraic Computing,",
    FontSlant->"Italic"],
  " Addison-Wesley, Reading, MA, 1981."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Pinter, C., ",
  StyleBox["A Book of Abstract Algebra,",
    FontSlant->"Italic"],
  " McGraw Hill, New York, 1990."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Rotman, J., ",
  StyleBox["The Theory of Groups,",
    FontSlant->"Italic"],
  " Allyn & Bacon, Boston, 1965."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Sims, C., ",
  StyleBox["Abstract Algebra: a Computational Approach,",
    FontSlant->"Italic"],
  " Wiley, New York, 1984."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Wolfram, S.,  ",
  StyleBox["Mathematica, A System for Doing Mathematics by Computer",
    FontSlant->"Italic"],
  ",  Second Edition, Addison-Wesley, Redwood City, CA, 1991."
}], "Text",
  CellTags->"MathematicaRefs"],

Cell[TextData[{
  "Wolfram, S., ",
  StyleBox[" The Mathematica Book",
    FontSlant->"Italic"],
  ",  Third Edition, Wolfram Media, Champaign, IL, 1997."
}], "Text",
  CellTags->"MathematicaRefs"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.4 Objects in AbstractAlgebra", "Section"],

Cell[CellGroupData[{

Cell["6.4.1 Alphabetically", "Subsection",
  CellTags->{"alpha", "i:4"}],

Cell["\<\
A
AbelianQ
Addition
AdditiveGroupoid
AdditiveToMultiplicative
AddPermToGroup
Adjoin
Adjoint
AGroupoid
Alternating
AlternatingGroup
Annihilator
AntiCommutingMatricesQ
Any
AsIJK
AsMatrices
Associates
AssociativeQ
AsSymbols
Aut
Automorphism
AutomorphismGroup
BackgroundColors
BaseRing
BooleanRing
Both
Canonical
CartesianProduct
Cautious
CayleyForm
CayleyTable
CayleyTables
Centralizer
Characteristic
CInf
ClosedDiffQ
ClosedPlusQ
ClosedQ
ClosedTimesQ
CloseSets
Closure
Codomain
CollectOrders
ColorCodomain
ColorDomain
Combine
Combined
CommutativeQ
Commutator
Commutators
CommutatorSubgroup
CommutingMatricesQ
ComplementNoSort
CompleteGroupQ
ComplexMatrixQ
ComplexToPoint
Computational
ConjugacyClass
CosetLists
Cosets
CosetToList
Cycle
CycleAs
Cyclic
CyclicGenerators
CyclicGroup
CyclicQ
CyclicSubgroups
D1Prod
D2Prod
DefaultOrder
DefaultStructure
DetAdjoint
Diag
DiagonalMatrices
DiagQ
Dihedral
DihedralGroup
DirectProduct
DirectSum
DisguiseGroupoid
DisguiseRingoid
DisjointCyclesQ
DistributiveQ
DividesQ
DivisorsComplete
Domain
DrawNgon
DropPermFromGroup
EisensteinsCriterionQ
ElementConjugate
ElementQ
Elements
ElementsQ
ElementToCoset
ElementToKey
ElementToPower
EqualGroupoidQ
EqualMorphoidQ
ESG
EvaluationInExtension
EvenPermutationQ
ExtendPermutation
ExtensionDegree
ExtensionType
FactorGroup
FactorRing
Fiber
FieldIrreducible
FieldQ
FirstTaker
FixQ
FlexibleEntering
Form
FormatElements
FormatFunction
FormatOperator
FormGroupoid
FormGroupoidByTable
FormGroupoidFromCycles
FormMorphoid
FormMorphoidSetup
FormRingoid
FormRingoidByTable
FromCycles
Func
FuncRing
FunctionForm
FunctionsOver
FuncToRules
GaloisFieldQ
GaussianIntegerQ
GaussianIntegersAdditive
GaussianIntegersMultiplicative
GaussianUnits
GeneralLinear
GeneralLinearGroup
GenerateGroupoid
GeneratingSet
Generator
Generators
GF
GL
GLQ
GoodGroupElementsQ
Group
GroupCenter
GroupExponent
GroupIdentity
GroupInfo
GroupInverse
Groupoid
GroupoidDescription
GroupoidName
GroupQ
Groups
GroupsToConsider
HasIdentityQ
HasInversesQ
HasLeftIdentityQ
HasNegativeQ
HasRightIdentityQ
HasUnityQ
HasZeroQ
HeadingsColored
HermitianQ
HomomorphismQ
IdealQ
IdempotentQ
Idempotents
IgnoreIndeterminate
Image
Ind
Index
IndexLimit
InducedCanonical
InducedIsomorphism
InjectiveQ
Inn
InnerAutomorphism
InnerAutomorphismGroup
IntegerDivisors
IntegerLatticeGrid
IntegerMatrixQ
IntegerUnits
IntegralDomainQ
InverseImage
InverseImages
Inverses
InvertibleQ
IrreduciblePolynomial
IrreduciblePolyOverZpQ
IsAGroup
IsARing
IsomorphismQ
J
JoinDivisors
Kernel
KeyForm
KeyToElement
Klein4
KSubsets
Lab2
Lab3
Lab4
LatticeRing
LeftCoset
LeftCosets
LeftDistributiveQ
LeftIdealQ
LeftIdentity
LeftInverse
LeftInvertibleQ
LeftToRight
LG
ListOperationPreservingElements
LowerDegreeOK
LT
LTD
Mat
MatA
MatM
Matrices
MatricesOver
MatrixConjugate
MatrixDelete
MatrixOperation
MatrixOverQ
MatrixTrace
MatrixType
MaxElementsToList
MaximalIdealQ
MaxTaker
MeetDivisors
MGroupoid
MinTaker
MixedDivisors
ModpIrreducibilityQ
ModulusPolynomial
Monic
MonoidQ
Monomial
MorphismQ
Morphoid
MorphoidComposition
MorphoidFunction
MorphoidRules
MultipleOfElement
Multiplication
MultiplicationTable
MultiplicativeGroupoid
MultiplicativeInverse
MultiplicativeToAdditive
MultiplyCycles
MultiplyPermutations
myDiv
myDivisorSigma
myDot
myMod
myPower
MySymmetryGroup
myZees
NegationOf
Negations
NextStage
NilpotentDegree
NilpotentQ
Nilpotents
NonAssociatingTriples
NonCommutingPairs
NonIdentity
NonTrivialOnly
NonUnity
NonZero
NonZeroMGroupoid
Normalize
Normalizer
NormalQ
NS
OddPermutationQ
OneToOneQ
OntoQ
Operation
OperatorSymbol
Orbit
Ordering
OrderOfAllElements
OrderOfElement
Orders
OrthogonalQ
Output
Parity
PermutationComposition
PermutationGroup
PermutationImage
PermutationInverse
PermutationMatrix
PermutationQ
PermutationToPower
PermuteColoredSquares
PlusSymbol
Poly
PolynomialEvaluation
PolynomialsOfDegreeN
PolynomialsOver
PolynomialsUpToDegreeN
PolyQ
PolyRing
PolyToFunction
PowerList
PowersIncrease
PreservesQ
PreviousStage
PrimeIdealQ
PrimitivePolynomials
PrincipalIdeal
PrintMessage
ProbableGroupQ
ProbableMorphismQ
ProbableRingQ
ProductOrder
Products
ProperSubsetQ
QuaternionGroup
quatOp
QuotientGroup
QuotientRing
Radical
RandomAssociativeQ
RandomColoredSquares
RandomDistributiveQ
RandomElement
RandomElements
RandomGroupoid
Randomize
RandomMatrix
RandomPermutation
RationalMatrixQ
RationalRootCandidates
RationalRootTheorem
RealMatrixQ
ReduceList
Ref
RefSym
ReorderGroupoid
Replacement
ReportIterations
Representatives
RestrictList
RightCoset
RightCosets
RightDistributiveQ
RightIdealQ
RightIdentity
RightInverse
RightInvertibleQ
RightToLeft
Ring
RingExtension
RingInfo
Ringoid
RingoidDescription
RingoidName
RingQ
Rings
RingSolve
RootsOfUnity
Rot
RotRef
RotSym
Rules
S
SamePermutationQ
SameSetQ
SamplePairs
SampleSize
SE
SelectBaseElementsFrom
SelectFrom
SemiGroupQ
Sgn
ShowBodyText
ShowCircle
ShowColoredPermutation
ShowFigure
ShowGroupOrders
ShowKey
ShowName
ShowOne
ShowOperator
ShowPermutation
ShowPossiblePermsAsRules
ShowPossiblePermutations
ShowSidesText
SideBySideMatrices
Size
SizeLimit
SizeOfMatrices
SkewHermitianQ
SkewSymmetricQ
SL
SLQ
SortGroupoid
SpecialLinear
SpecialLinearGroup
Stabilizer
Staged
Structure
SubgroupClosure
SubgroupConjugate
SubgroupGenerated
SubgroupIntersection
SubgroupJoin
Subgroupoid
SubgroupProduct
SubgroupQ
Subgroups
SubgroupUnion
SubringQ
SubsetQ
SurjectiveQ
SwitchStructureTo
Symmetric
SymmetricGroup
SymmetricQ
TableOfPowers
TestFunction
TestPermutationQ
TextCayley
Textual
TheSet
TimesSymbol
ToCycles
ToFunction
ToGroupoid
ToOrdinaryPolynomial
ToPermutation
ToRingoid
ToTranspositions
Trivial
TrivialZR
trivProd
TwistedZ
U
undef
UnionNoSort
UnitaryQ
UnitQ
Units
Unity
UT
UTD
ValuesHavingGivenNorm
VarToUse
Verbal
Visual
Visual2
VisualizeMorphoid
VisualTextShown
WideElements
WithImages
WithUnityQ
Z
ZdAssociatesQ
ZdCombineAssociates
ZdConjugate
ZdDivide
ZdDividesQ
ZdDivisors
ZdIrreducibleQ
ZdNorm
ZdPossibleNormQ
ZdPossibleNorms
ZdQ
ZdUnitQ
Zero
ZeroDivisorQ
ZeroDivisors
Zeros
ZG
ZMap
ZR
Zx\
\>", "Text",
  CellTags->"alpha"]
}, Closed]],

Cell[CellGroupData[{

Cell["6.4.2 By Packages", "Subsection",
  CellTags->{"pack", "i:5"}],

Cell["\<\
This is still in preliminary form. These will be linked to the \
appropriate section of the documentation.\
\>", "Text"],

Cell[CellGroupData[{

Cell["6.4.2.1 Core", "Subsubsection",
  CellTags->{"pack", "Core"}],

Cell["\<\
Addition
Adjoin
Any
AssociativeQ
BackgroundColors
Both
CartesianProduct
CayleyForm
CayleyTable
ClosedQ
CloseSets
Closure
ComplementNoSort
Computational
DefaultStructure
Domain
DrawNgon
ElementQ
Elements
ElementsQ
ElementToKey
ElementToPower
Form
FormatElements
FormatOperator
FormGroupoid
FormGroupoidByTable
FormRingoid
GaussianIntegersAdditive
GaussianIntegersMultiplicative
GenerateGroupoid
GeneratingSet
Generators
Group
GroupIdentity
GroupInfo
GroupInverse
Groupoid
GroupoidDescription
GroupoidName
GroupQ
Groups
HasIdentityQ
HasInversesQ
HasLeftIdentityQ
HasRightIdentityQ
HeadingsColored
Inverses
InvertibleQ
IsAGroup
IsARing
KeyForm
KeyToElement
KSubsets
LeftIdentity
LeftInverse
LeftInvertibleQ
LeftToRight
MaxElementsToList
MonoidQ
Multiplication
NextStage
NonAssociatingTriples
NonIdentity
Operation
OperatorSymbol
Ordering
Output
PermutationInverse
PermutationQ
PlusSymbol
PreviousStage
ProbableGroupQ
ProperSubsetQ
RandomAssociativeQ
RandomElement
RandomElements
Randomize
RandomPermutation
ReorderGroupoid
Replacement
ReportIterations
RightIdentity
RightInverse
RightInvertibleQ
RightToLeft
Ring
RingInfo
Ringoid
RingoidDescription
RingoidName
Rings
SameSetQ
SelectFrom
SemiGroupQ
ShowBodyText
ShowCircle
ShowFigure
ShowKey
ShowName
ShowOperator
ShowPermutation
ShowSidesText
Size
SizeLimit
SortGroupoid
Staged
Structure
SubgroupClosure
SubgroupQ
SubsetQ
SwitchStructureTo
TextCayley
Textual
TheSet
TimesSymbol
ToPermutation
UnionNoSort
VarToUse
Visual
VisualTextShown
Visual2
WideElements
Z
ZG
ZR\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Core"}]
}, Closed]],

Cell[CellGroupData[{

Cell["6.4.2.2 FiniteFields", "Subsubsection",
  CellTags->{"pack", "FiniteFields"}],

Cell["\<\
AdditiveToMultiplicative
ExtensionDegree
FieldIrreducible
GaloisFieldQ
GF
IrreduciblePolynomial
IrreduciblePolyOverZpQ
MultiplicativeToAdditive
PowerList
PrimitivePolynomials
TableOfPowers\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "FiniteFields"}]
}, Closed]],

Cell[CellGroupData[{

Cell["6.4.2.3 Groupoids", "Subsubsection",
  CellTags->{"pack", "Groupoids"}],

Cell["\<\
AsIJK
AsMatrices
AsSymbols
Cyclic
CyclicGroup
Dihedral
DihedralGroup
ESG
FirstTaker
GaussianUnits
Generator
IntegerUnits
JoinDivisors
Klein4
MaxTaker
MeetDivisors
MinTaker
MixedDivisors
PermutationComposition
QuaternionGroup
RandomGroupoid
Ref
RefSym
RootsOfUnity
Rot
RotRef
RotSym
Trivial
TwistedZ
U
Zx\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Groupoids"}]
}, Closed]],

Cell[CellGroupData[{

Cell["6.4.2.4 GroupProperties", "Subsubsection",
  CellTags->{"pack", "GroupProperties"}],

Cell["\<\
Centralizer
Commutator
Commutators
CommutatorSubgroup
ConjugacyClass
CyclicGenerators
CyclicQ
CyclicSubgroups
ElementConjugate
EqualGroupoidQ
GroupCenter
GroupExponent
Normalizer
OrderOfAllElements
OrderOfElement
Orders
SubgroupConjugate
SubgroupIntersection
SubgroupJoin
Subgroupoid
SubgroupProduct
Subgroups
SubgroupUnion\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "GroupProperties"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.5 Joint", "Subsubsection",
  CellTags->{"pack", "Joint"}],

Cell["\<\
AbelianQ
Canonical
CommutativeQ
CosetLists
Cosets
CosetToList
DirectProduct
DirectSum
DisguiseGroupoid
DisguiseRingoid
ElementToCoset
FactorGroup
Index
LeftCoset
LeftCosets
NonCommutingPairs
NormalQ
NS
QuotientGroup
Representatives
RightCoset
RightCosets
SubgroupGenerated\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Joint"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.6 LabCode", "Subsubsection",
  CellTags->{"pack", "LabCode"}],

Cell["\<\
CollectOrders
LG
ListOperationPreservingElements
ShowGroupOrders\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "LabCode"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.7 Matrices", "Subsubsection",
  CellTags->{"pack", "Matrices"}],

Cell["\<\
Adjoint
AntiCommutingMatricesQ
CommutingMatricesQ
ComplexMatrixQ
DetAdjoint
Diag
DiagonalMatrices
DiagQ
GeneralLinear
GeneralLinearGroup
GL
GLQ
HermitianQ
IntegerMatrixQ
LT
LTD
Mat
MatA
MatM
MatricesOver
MatrixConjugate
MatrixDelete
MatrixOperation
MatrixOverQ
MatrixTrace
MatrixType
OrthogonalQ
RandomMatrix
RationalMatrixQ
RealMatrixQ
SizeOfMatrices
SkewHermitianQ
SkewSymmetricQ
SL
SLQ
SpecialLinear
SpecialLinearGroup
SymmetricQ
ToGroupoid
ToRingoid
UnitaryQ
UT
UTD\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Matrices"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.8 Morphisms", "Subsubsection",
  CellTags->{"pack", "Morphisms"}],

Cell["\<\
Aut
Automorphism
AutomorphismGroup
Cautious
Codomain
ColorCodomain
ColorDomain
EqualMorphoidQ
Fiber
FormatFunction
FormMorphoid
FormMorphoidSetup
FunctionForm
HomomorphismQ
Image
InducedCanonical
InducedIsomorphism
InjectiveQ
Inn
InnerAutomorphism
InnerAutomorphismGroup
InverseImage
InverseImages
IsomorphismQ
Kernel
MorphismQ
Morphoid
MorphoidComposition
MorphoidFunction
MorphoidRules
OneToOneQ
OntoQ
PreservesQ
PrintMessage
ProbableMorphismQ
Rules
SamplePairs
SampleSize
Sgn
SurjectiveQ
ToFunction
VisualizeMorphoid
WithImages
ZMap\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Morphisms"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.9 Permutations", "Subsubsection",
  CellTags->{"pack", "Permutations"}],

Cell["\<\
A
AbstractAlgebra`Permutations`A
AbstractAlgebra`Permutations`S
Alternating
AlternatingGroup
Cycle
CycleAs
DefaultOrder
DisjointCyclesQ
EvenPermutationQ
ExtendPermutation
FixQ
FormGroupoidFromCycles
FromCycles
IndexLimit
MultiplyCycles
MultiplyPermutations
Normalize
OddPermutationQ
Orbit
Parity
PermutationGroup
PermutationImage
PermutationMatrix
PermutationToPower
PermuteColoredSquares
ProductOrder
RandomColoredSquares
S
SamePermutationQ
ShowColoredPermutation
SideBySideMatrices
Stabilizer
Symmetric
SymmetricGroup
ToCycles
ToTranspositions\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Permutations"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.10 RingExtensions", "Subsubsection",
  CellTags->{"pack", "RingExtensions"}],

Cell["\<\
BaseRing
EvaluationInExtension
ExtensionType
FlexibleEntering
Func
FuncRing
FunctionsOver
FuncToRules
IgnoreIndeterminate
Matrices
ModulusPolynomial
Monomial
Poly
PolynomialEvaluation
PolynomialsOfDegreeN
PolynomialsOver
PolynomialsUpToDegreeN
PolyQ
PolyRing
PolyToFunction
PowersIncrease
RingExtension
TestFunction
ToOrdinaryPolynomial
Zeros\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "RingExtensions"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.11 Ringoids", "Subsubsection",
  CellTags->{"pack", "Ringoids"}],

Cell["\<\
BooleanRing
FormRingoidByTable
LatticeRing
TrivialZR\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Ringoids"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.12 RingProperties", "Subsubsection",
  CellTags->{"pack", "RingProperties"}],

Cell["\<\
AdditiveGroupoid
AGroupoid
Annihilator
CayleyTables
Characteristic
ClosedDiffQ
ClosedPlusQ
ClosedTimesQ
ComplexToPoint
DistributiveQ
EisensteinsCriterionQ
FactorRing
FieldQ
GaussianIntegerQ
HasNegativeQ
HasUnityQ
HasZeroQ
IdealQ
IdempotentQ
Idempotents
IntegerLatticeGrid
IntegralDomainQ
J
LeftDistributiveQ
LeftIdealQ
LowerDegreeOK
MaximalIdealQ
MGroupoid
ModpIrreducibilityQ
Monic
MultipleOfElement
MultiplicationTable
MultiplicativeGroupoid
MultiplicativeInverse
NegationOf
NilpotentDegree
NilpotentQ
Nilpotents
NonUnity
NonZero
NonZeroMGroupoid
PrimeIdealQ
PrincipalIdeal
ProbableRingQ
QuotientRing
RandomDistributiveQ
RationalRootCandidates
RationalRootTheorem
RightDistributiveQ
RightIdealQ
RingQ
RingSolve
SelectBaseElementsFrom
SubringQ
UnitQ
Units
Unity
WithUnityQ
Zero
ZeroDivisorQ
ZeroDivisors\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "RingProperties"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["6.4.2.13 Zd", "Subsubsection",
  CellTags->{"pack", "Zd"}],

Cell["\<\
Associates
Combine
Combined
DividesQ
DivisorsComplete
IntegerDivisors
Negations
NonTrivialOnly
Products
Radical
ValuesHavingGivenNorm
ZdAssociatesQ
ZdCombineAssociates
ZdConjugate
ZdDivide
ZdDividesQ
ZdDivisors
ZdIrreducibleQ
ZdNorm
ZdPossibleNormQ
ZdPossibleNorms
ZdQ
ZdUnitQ
\
\>", "Text",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->{"pack", "Zd"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.4.3 Objects extended from standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Subsection",
  CellTags->"ext"],

Cell["\<\
Center
Coefficient
CoefficientList
Conjugate
D
Degree
Det
Dot
Equal
Exponent
GaussianIntegers
Identity
IdentityMatrix
InterpolatingPolynomial
Inverse
MatrixPower
Order
Plus
PolynomialDivision
PolynomialGCD
PolynomialLCM
PolynomialQuotient
PolynomialRemainder
ReplaceAll
Solve
Times
ToRules
Variables\
\>", "Text",
  CellTags->"ext"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"AllBrackets",
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{494, 420},
WindowMargins->{{14, Automatic}, {Automatic, 6}},
ShowGroupOpenCloseIcon->True,
TaggingRules:>{"NextIndexingNumber" -> 7, "IndexEntries" -> {{"i:1", 
  "Installation instructions"}, {"i:2", "Version-specific notes"}, {"i:3", 
  "Bibliography"}, {"i:3", "References"}, {"i:6", {
  StyleBox[ "Exploring Abstract Algebra with", FontSlant -> "Italic"], " ", 
  StyleBox[ "Mathematica", FontSlant -> "Italic"]}}, {"i:4", 
  "Objects in AbstractAlgebra", "Alphabetically"}, {"i:5", 
  "Objects in AbstractAlgebra", "by packages"}}},
StyleDefinitions -> "Manual.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "i:1"->{
    Cell[1786, 55, 67, 1, 68, "Section",
      CellTags->"i:1"]},
  "install3"->{
    Cell[1878, 60, 73, 1, 56, "Subsection",
      CellTags->"install3"],
    Cell[1954, 63, 961, 29, 133, "Text",
      CellTags->"install3"],
    Cell[2918, 94, 815, 22, 132, "Text",
      CellTags->"install3"]},
  "install2w"->{
    Cell[3770, 121, 78, 1, 56, "Subsection",
      CellTags->"install2w"],
    Cell[3851, 124, 671, 19, 98, "Text",
      CellTags->"install2w"]},
  "install2o"->{
    Cell[4559, 148, 86, 1, 56, "Subsection",
      CellTags->"install2o"],
    Cell[4648, 151, 601, 17, 81, "Text",
      CellTags->"install2o"]},
  "i:2"->{
    Cell[5298, 174, 64, 1, 42, "Section",
      CellTags->"i:2"]},
  "versnts3"->{
    Cell[5387, 179, 73, 1, 54, "Subsection",
      CellTags->"versnts3"],
    Cell[5463, 182, 880, 24, 114, "Text",
      CellTags->"versnts3"]},
  "versnts2w"->{
    Cell[6380, 211, 78, 1, 28, "Subsection",
      CellTags->"versnts2w"],
    Cell[6461, 214, 712, 15, 128, "Text",
      CellTags->"versnts2w"]},
  "versnts2o"->{
    Cell[7210, 234, 86, 1, 28, "Subsection",
      CellTags->"versnts2o"],
    Cell[7299, 237, 343, 10, 64, "Text",
      CellTags->"versnts2o"]},
  "i:3"->{
    Cell[7691, 253, 73, 1, 42, "Section",
      CellTags->{"i:3", "MathematicaRefs"}]},
  "MathematicaRefs"->{
    Cell[7691, 253, 73, 1, 42, "Section",
      CellTags->{"i:3", "MathematicaRefs"}],
    Cell[7767, 256, 233, 9, 32, "Text",
      CellTags->"MathematicaRefs"],
    Cell[8003, 267, 209, 6, 48, "Text",
      CellTags->"MathematicaRefs"],
    Cell[8215, 275, 181, 6, 32, "Text",
      CellTags->"MathematicaRefs"],
    Cell[8399, 283, 204, 6, 48, "Text",
      CellTags->"MathematicaRefs"],
    Cell[8606, 291, 202, 6, 48, "Text",
      CellTags->"MathematicaRefs"],
    Cell[8811, 299, 222, 6, 50, "Text",
      CellTags->"MathematicaRefs"],
    Cell[9036, 307, 191, 6, 32, "Text",
      CellTags->"MathematicaRefs"],
    Cell[9230, 315, 199, 6, 48, "Text",
      CellTags->"MathematicaRefs"],
    Cell[9432, 323, 178, 6, 32, "Text",
      CellTags->"MathematicaRefs"],
    Cell[9613, 331, 172, 6, 32, "Text",
      CellTags->"MathematicaRefs"],
    Cell[9788, 339, 186, 6, 32, "Text",
      CellTags->"MathematicaRefs"],
    Cell[9977, 347, 237, 6, 48, "Text",
      CellTags->"MathematicaRefs"],
    Cell[10217, 355, 197, 6, 48, "Text",
      CellTags->"MathematicaRefs"]},
  "alpha"->{
    Cell[10525, 370, 72, 1, 54, "Subsection",
      CellTags->{"alpha", "i:4"}],
    Cell[10600, 373, 5996, 485, 11779, "Text",
      CellTags->"alpha"]},
  "i:4"->{
    Cell[10525, 370, 72, 1, 54, "Subsection",
      CellTags->{"alpha", "i:4"}]},
  "pack"->{
    Cell[16633, 863, 68, 1, 28, "Subsection",
      CellTags->{"pack", "i:5"}],
    Cell[16859, 873, 67, 1, 47, "Subsubsection",
      CellTags->{"pack", "Core"}],
    Cell[16929, 876, 1673, 132, 3089, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Core"}],
    Cell[18639, 1013, 83, 1, 27, "Subsubsection",
      CellTags->{"pack", "FiniteFields"}],
    Cell[18725, 1016, 358, 17, 286, "Text",
      InitializationCell->True,
      CellTags->{"pack", "FiniteFields"}],
    Cell[19120, 1038, 77, 1, 27, "Subsubsection",
      CellTags->{"pack", "Groupoids"}],
    Cell[19200, 1041, 470, 37, 774, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Groupoids"}],
    Cell[19707, 1083, 89, 1, 27, "Subsubsection",
      CellTags->{"pack", "GroupProperties"}],
    Cell[19799, 1086, 496, 29, 567, "Text",
      InitializationCell->True,
      CellTags->{"pack", "GroupProperties"}],
    Cell[20332, 1120, 69, 1, 47, "Subsubsection",
      CellTags->{"pack", "Joint"}],
    Cell[20404, 1123, 435, 29, 567, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Joint"}],
    Cell[20876, 1157, 73, 1, 47, "Subsubsection",
      CellTags->{"pack", "LabCode"}],
    Cell[20952, 1160, 229, 10, 104, "Text",
      InitializationCell->True,
      CellTags->{"pack", "LabCode"}],
    Cell[21218, 1175, 75, 1, 47, "Subsubsection",
      CellTags->{"pack", "Matrices"}],
    Cell[21296, 1178, 635, 49, 1054, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Matrices"}],
    Cell[21968, 1232, 77, 1, 47, "Subsubsection",
      CellTags->{"pack", "Morphisms"}],
    Cell[22048, 1235, 702, 50, 1079, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Morphisms"}],
    Cell[22787, 1290, 83, 1, 47, "Subsubsection",
      CellTags->{"pack", "Permutations"}],
    Cell[22873, 1293, 715, 43, 908, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Permutations"}],
    Cell[23625, 1341, 88, 1, 47, "Subsubsection",
      CellTags->{"pack", "RingExtensions"}],
    Cell[23716, 1344, 514, 31, 615, "Text",
      InitializationCell->True,
      CellTags->{"pack", "RingExtensions"}],
    Cell[24267, 1380, 76, 1, 47, "Subsubsection",
      CellTags->{"pack", "Ringoids"}],
    Cell[24346, 1383, 218, 10, 104, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Ringoids"}],
    Cell[24601, 1398, 88, 1, 47, "Subsubsection",
      CellTags->{"pack", "RingProperties"}],
    Cell[24692, 1401, 976, 67, 1493, "Text",
      InitializationCell->True,
      CellTags->{"pack", "RingProperties"}],
    Cell[25705, 1473, 64, 1, 47, "Subsubsection",
      CellTags->{"pack", "Zd"}],
    Cell[25772, 1476, 437, 30, 591, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Zd"}]},
  "i:5"->{
    Cell[16633, 863, 68, 1, 28, "Subsection",
      CellTags->{"pack", "i:5"}]},
  "Core"->{
    Cell[16859, 873, 67, 1, 47, "Subsubsection",
      CellTags->{"pack", "Core"}],
    Cell[16929, 876, 1673, 132, 3089, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Core"}]},
  "FiniteFields"->{
    Cell[18639, 1013, 83, 1, 27, "Subsubsection",
      CellTags->{"pack", "FiniteFields"}],
    Cell[18725, 1016, 358, 17, 286, "Text",
      InitializationCell->True,
      CellTags->{"pack", "FiniteFields"}]},
  "Groupoids"->{
    Cell[19120, 1038, 77, 1, 27, "Subsubsection",
      CellTags->{"pack", "Groupoids"}],
    Cell[19200, 1041, 470, 37, 774, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Groupoids"}]},
  "GroupProperties"->{
    Cell[19707, 1083, 89, 1, 27, "Subsubsection",
      CellTags->{"pack", "GroupProperties"}],
    Cell[19799, 1086, 496, 29, 567, "Text",
      InitializationCell->True,
      CellTags->{"pack", "GroupProperties"}]},
  "Joint"->{
    Cell[20332, 1120, 69, 1, 47, "Subsubsection",
      CellTags->{"pack", "Joint"}],
    Cell[20404, 1123, 435, 29, 567, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Joint"}]},
  "LabCode"->{
    Cell[20876, 1157, 73, 1, 47, "Subsubsection",
      CellTags->{"pack", "LabCode"}],
    Cell[20952, 1160, 229, 10, 104, "Text",
      InitializationCell->True,
      CellTags->{"pack", "LabCode"}]},
  "Matrices"->{
    Cell[21218, 1175, 75, 1, 47, "Subsubsection",
      CellTags->{"pack", "Matrices"}],
    Cell[21296, 1178, 635, 49, 1054, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Matrices"}]},
  "Morphisms"->{
    Cell[21968, 1232, 77, 1, 47, "Subsubsection",
      CellTags->{"pack", "Morphisms"}],
    Cell[22048, 1235, 702, 50, 1079, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Morphisms"}]},
  "Permutations"->{
    Cell[22787, 1290, 83, 1, 47, "Subsubsection",
      CellTags->{"pack", "Permutations"}],
    Cell[22873, 1293, 715, 43, 908, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Permutations"}]},
  "RingExtensions"->{
    Cell[23625, 1341, 88, 1, 47, "Subsubsection",
      CellTags->{"pack", "RingExtensions"}],
    Cell[23716, 1344, 514, 31, 615, "Text",
      InitializationCell->True,
      CellTags->{"pack", "RingExtensions"}]},
  "Ringoids"->{
    Cell[24267, 1380, 76, 1, 47, "Subsubsection",
      CellTags->{"pack", "Ringoids"}],
    Cell[24346, 1383, 218, 10, 104, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Ringoids"}]},
  "RingProperties"->{
    Cell[24601, 1398, 88, 1, 47, "Subsubsection",
      CellTags->{"pack", "RingProperties"}],
    Cell[24692, 1401, 976, 67, 1493, "Text",
      InitializationCell->True,
      CellTags->{"pack", "RingProperties"}]},
  "Zd"->{
    Cell[25705, 1473, 64, 1, 47, "Subsubsection",
      CellTags->{"pack", "Zd"}],
    Cell[25772, 1476, 437, 30, 591, "Text",
      InitializationCell->True,
      CellTags->{"pack", "Zd"}]},
  "ext"->{
    Cell[26258, 1512, 153, 6, 28, "Subsection",
      CellTags->"ext"],
    Cell[26414, 1520, 342, 30, 689, "Text",
      CellTags->"ext"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"i:1", 28197, 1587},
  {"install3", 28279, 1590},
  {"install2w", 28510, 1597},
  {"install2o", 28674, 1602},
  {"i:2", 28832, 1607},
  {"versnts3", 28915, 1610},
  {"versnts2w", 29078, 1615},
  {"versnts2o", 29243, 1620},
  {"i:3", 29401, 1625},
  {"MathematicaRefs", 29512, 1628},
  {"alpha", 30602, 1657},
  {"i:4", 30768, 1662},
  {"pack", 30862, 1665},
  {"i:5", 33640, 1733},
  {"Core", 33733, 1736},
  {"FiniteFields", 33951, 1742},
  {"Groupoids", 34181, 1748},
  {"GroupProperties", 34411, 1754},
  {"Joint", 34643, 1760},
  {"LabCode", 34857, 1766},
  {"Matrices", 35076, 1772},
  {"Morphisms", 35299, 1778},
  {"Permutations", 35527, 1784},
  {"RingExtensions", 35762, 1790},
  {"Ringoids", 35995, 1796},
  {"RingProperties", 36222, 1802},
  {"Zd", 36450, 1808},
  {"ext", 36654, 1814}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 30, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1786, 55, 67, 1, 68, "Section",
  CellTags->"i:1"],

Cell[CellGroupData[{
Cell[1878, 60, 73, 1, 56, "Subsection",
  CellTags->"install3"],
Cell[1954, 63, 961, 29, 133, "Text",
  CellTags->"install3"],
Cell[2918, 94, 815, 22, 132, "Text",
  CellTags->"install3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3770, 121, 78, 1, 56, "Subsection",
  CellTags->"install2w"],
Cell[3851, 124, 671, 19, 98, "Text",
  CellTags->"install2w"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4559, 148, 86, 1, 56, "Subsection",
  CellTags->"install2o"],
Cell[4648, 151, 601, 17, 81, "Text",
  CellTags->"install2o"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[5298, 174, 64, 1, 42, "Section",
  CellTags->"i:2"],

Cell[CellGroupData[{
Cell[5387, 179, 73, 1, 54, "Subsection",
  CellTags->"versnts3"],
Cell[5463, 182, 880, 24, 114, "Text",
  CellTags->"versnts3"]
}, Closed]],

Cell[CellGroupData[{
Cell[6380, 211, 78, 1, 28, "Subsection",
  CellTags->"versnts2w"],
Cell[6461, 214, 712, 15, 128, "Text",
  CellTags->"versnts2w"]
}, Closed]],

Cell[CellGroupData[{
Cell[7210, 234, 86, 1, 28, "Subsection",
  CellTags->"versnts2o"],
Cell[7299, 237, 343, 10, 64, "Text",
  CellTags->"versnts2o"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7691, 253, 73, 1, 42, "Section",
  CellTags->{"i:3", "MathematicaRefs"}],
Cell[7767, 256, 233, 9, 32, "Text",
  CellTags->"MathematicaRefs"],
Cell[8003, 267, 209, 6, 48, "Text",
  CellTags->"MathematicaRefs"],
Cell[8215, 275, 181, 6, 32, "Text",
  CellTags->"MathematicaRefs"],
Cell[8399, 283, 204, 6, 48, "Text",
  CellTags->"MathematicaRefs"],
Cell[8606, 291, 202, 6, 48, "Text",
  CellTags->"MathematicaRefs"],
Cell[8811, 299, 222, 6, 50, "Text",
  CellTags->"MathematicaRefs"],
Cell[9036, 307, 191, 6, 32, "Text",
  CellTags->"MathematicaRefs"],
Cell[9230, 315, 199, 6, 48, "Text",
  CellTags->"MathematicaRefs"],
Cell[9432, 323, 178, 6, 32, "Text",
  CellTags->"MathematicaRefs"],
Cell[9613, 331, 172, 6, 32, "Text",
  CellTags->"MathematicaRefs"],
Cell[9788, 339, 186, 6, 32, "Text",
  CellTags->"MathematicaRefs"],
Cell[9977, 347, 237, 6, 48, "Text",
  CellTags->"MathematicaRefs"],
Cell[10217, 355, 197, 6, 48, "Text",
  CellTags->"MathematicaRefs"]
}, Closed]],

Cell[CellGroupData[{
Cell[10451, 366, 49, 0, 42, "Section"],

Cell[CellGroupData[{
Cell[10525, 370, 72, 1, 54, "Subsection",
  CellTags->{"alpha", "i:4"}],
Cell[10600, 373, 5996, 485, 11779, "Text",
  CellTags->"alpha"]
}, Closed]],

Cell[CellGroupData[{
Cell[16633, 863, 68, 1, 28, "Subsection",
  CellTags->{"pack", "i:5"}],
Cell[16704, 866, 130, 3, 46, "Text"],

Cell[CellGroupData[{
Cell[16859, 873, 67, 1, 47, "Subsubsection",
  CellTags->{"pack", "Core"}],
Cell[16929, 876, 1673, 132, 3089, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Core"}]
}, Closed]],

Cell[CellGroupData[{
Cell[18639, 1013, 83, 1, 27, "Subsubsection",
  CellTags->{"pack", "FiniteFields"}],
Cell[18725, 1016, 358, 17, 286, "Text",
  InitializationCell->True,
  CellTags->{"pack", "FiniteFields"}]
}, Closed]],

Cell[CellGroupData[{
Cell[19120, 1038, 77, 1, 27, "Subsubsection",
  CellTags->{"pack", "Groupoids"}],
Cell[19200, 1041, 470, 37, 774, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Groupoids"}]
}, Closed]],

Cell[CellGroupData[{
Cell[19707, 1083, 89, 1, 27, "Subsubsection",
  CellTags->{"pack", "GroupProperties"}],
Cell[19799, 1086, 496, 29, 567, "Text",
  InitializationCell->True,
  CellTags->{"pack", "GroupProperties"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20332, 1120, 69, 1, 47, "Subsubsection",
  CellTags->{"pack", "Joint"}],
Cell[20404, 1123, 435, 29, 567, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Joint"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20876, 1157, 73, 1, 47, "Subsubsection",
  CellTags->{"pack", "LabCode"}],
Cell[20952, 1160, 229, 10, 104, "Text",
  InitializationCell->True,
  CellTags->{"pack", "LabCode"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21218, 1175, 75, 1, 47, "Subsubsection",
  CellTags->{"pack", "Matrices"}],
Cell[21296, 1178, 635, 49, 1054, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Matrices"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21968, 1232, 77, 1, 47, "Subsubsection",
  CellTags->{"pack", "Morphisms"}],
Cell[22048, 1235, 702, 50, 1079, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Morphisms"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22787, 1290, 83, 1, 47, "Subsubsection",
  CellTags->{"pack", "Permutations"}],
Cell[22873, 1293, 715, 43, 908, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Permutations"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[23625, 1341, 88, 1, 47, "Subsubsection",
  CellTags->{"pack", "RingExtensions"}],
Cell[23716, 1344, 514, 31, 615, "Text",
  InitializationCell->True,
  CellTags->{"pack", "RingExtensions"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24267, 1380, 76, 1, 47, "Subsubsection",
  CellTags->{"pack", "Ringoids"}],
Cell[24346, 1383, 218, 10, 104, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Ringoids"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[24601, 1398, 88, 1, 47, "Subsubsection",
  CellTags->{"pack", "RingProperties"}],
Cell[24692, 1401, 976, 67, 1493, "Text",
  InitializationCell->True,
  CellTags->{"pack", "RingProperties"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25705, 1473, 64, 1, 47, "Subsubsection",
  CellTags->{"pack", "Zd"}],
Cell[25772, 1476, 437, 30, 591, "Text",
  InitializationCell->True,
  CellTags->{"pack", "Zd"}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[26258, 1512, 153, 6, 28, "Subsection",
  CellTags->"ext"],
Cell[26414, 1520, 342, 30, 689, "Text",
  CellTags->"ext"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

