(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    147596,       6677]*)
(*NotebookOutlinePosition[    229040,       9071]*)
(*  CellTagsIndexPosition[    210582,       8544]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["AbstractAlgebra", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[TextData[{
  "AbelianQ",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AbelianQ"],

Cell[TextData[{
  "AdditiveGroupoid",
  ", ",
  ButtonBox["Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AdditiveGroupoid"],

Cell[TextData[{
  "AdditiveToMultiplicative",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:88"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AdditiveToMultiplicative"],

Cell[TextData[{
  "AGroupoid",
  ", ",
  ButtonBox["Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AGroupoid"],

Cell[TextData[{
  "Alternating Group",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Alternating Group"],

Cell[TextData[{
  "Annihilator",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Annihilator"],

Cell[TextData[{
  "Annihilator of a Set",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Annihilator of a Set"],

Cell[TextData[{
  "Aut",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Aut"],

Cell[TextData[{
  "Automorphism",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Automorphism"],

Cell[TextData[{
  "AutomorphismGroup",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AutomorphismGroup"],

Cell[TextData[{
  "Automorphisms",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Automorphisms"],

Cell[TextData[{
  "BackgroundColors",
  ", ",
  ButtonBox["Global variables and options",
    ButtonData:>{"Global variables and options", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BackgroundColors"],

Cell[TextData[{
  "Building Groupoids from Groupoids",
  ", ",
  ButtonBox["Direct products",
    ButtonData:>{"Direct products", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Building Groupoids from Groupoids"],

Cell[TextData[{
  "Building Ringoids from Ringoids",
  ", ",
  ButtonBox["Direct Products",
    ButtonData:>{"Direct Products", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Building Ringoids from Ringoids"],

Cell[TextData[{
  "Built-in Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Built-in Groupoids"],

Cell[TextData[{
  "Built-in Morphoids",
  ", ",
  ButtonBox["Built-in Morphoids",
    ButtonData:>{"Built-in Morphoids", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Built-in Morphoids"],

Cell[TextData[{
  "CartesianProduct",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CartesianProduct"],

Cell[TextData[{
  "CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:27"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyTable"],

Cell[TextData[{
  "Center",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Center"],

Cell[TextData[{
  "Centralizer",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Centralizer"],

Cell[TextData[{
  "ClosedDiffQ",
  ", ",
  ButtonBox["Closure of subsets",
    ButtonData:>{"Closure of subsets", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedDiffQ"],

Cell[TextData[{
  "ClosedPlusQ",
  ", ",
  ButtonBox["Closure of subsets",
    ButtonData:>{"Closure of subsets", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedPlusQ"],

Cell[TextData[{
  "ClosedTimesQ",
  ", ",
  ButtonBox["Closure of subsets",
    ButtonData:>{"Closure of subsets", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedTimesQ"],

Cell[TextData[{
  "CloseSets",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CloseSets"],

Cell[TextData[{
  "Closure",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Closure"],

Cell[TextData[{
  "CollectOrders",
  ", ",
  ButtonBox["A look at some functions in LabCode",
    ButtonData:>{"A look at some functions in LabCode", "i:38"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CollectOrders"],

Cell[TextData[{
  "CommutatorSubgroup",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CommutatorSubgroup"],

Cell[TextData[{
  "ComplementNoSort",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ComplementNoSort"],

Cell[TextData[{
  "ComplexToPoint",
  ", ",
  ButtonBox["Potpourri",
    ButtonData:>{"Potpourri", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ComplexToPoint"],

Cell[TextData[{
  "ConjugacyClass",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ConjugacyClass"],

Cell[TextData[{
  "Conjugate",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Conjugate"],

Cell[TextData[{
  "Cycle operations",
  ", ",
  ButtonBox["Cycle operations",
    ButtonData:>{"Cycle operations", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cycle operations"],

Cell[TextData[{
  "Cycles",
  ", ",
  ButtonBox["Cycles",
    ButtonData:>{"Cycles", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cycles"],

Cell[TextData[{
  "CyclicGenerators",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CyclicGenerators"],

Cell[TextData[{
  "Cyclic Groups",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cyclic Groups"],

Cell[TextData[{
  "CyclicQ",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CyclicQ"],

Cell[TextData[{
  "Cyclic subgroup generation",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cyclic subgroup generation"],

Cell[TextData[{
  "CyclicSubgroups",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CyclicSubgroups"],

Cell[TextData[{
  "DefaultOrder",
  ", ",
  ButtonBox["Global variables and options",
    ButtonData:>{"Global variables and options", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DefaultOrder"],

Cell[TextData[{
  "DefaultStructure",
  ", ",
  ButtonBox["Global variables and options",
    ButtonData:>{"Global variables and options", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DefaultStructure"],

Cell[TextData[{
  "Determinants",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:61"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Determinants"],

Cell[TextData[{
  "DiagonalMatrices",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiagonalMatrices"],

Cell[TextData[{
  "DiagQ",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:57"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DiagQ"],

Cell[TextData[{
  "Dihedral Groups",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dihedral Groups"],

Cell[TextData[{
  "DisguiseGroupoid",
  ", ",
  ButtonBox["Disguising groups and rings",
    ButtonData:>{"Disguising groups and rings", "i:36"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DisguiseGroupoid"],

Cell[TextData[{
  "DisguiseRingoid",
  ", ",
  ButtonBox["Disguising groups and rings",
    ButtonData:>{"Disguising groups and rings", "i:36"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DisguiseRingoid"],

Cell[TextData[{
  "Disguising groups and rings",
  ", ",
  ButtonBox["Disguising groups and rings",
    ButtonData:>{"Disguising groups and rings", "i:35"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Disguising groups and rings"],

Cell[TextData[{
  "DisjointCyclesQ",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DisjointCyclesQ"],

Cell[TextData[{
  "\"Divides\" family of Groupoids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\"Divides\" family of Groupoids"],

Cell[TextData[{
  "Divisibility in Z[Sqrt[d]]",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Divisibility in Z[Sqrt[d]]"],

Cell[TextData[{
  "Division Property of Polynomials",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Division Property of Polynomials"],

Cell[TextData[{
  "DrawNgon",
  ", ",
  ButtonBox["Working with graphics",
    ButtonData:>{"Working with graphics", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DrawNgon"],

Cell[TextData[{
  "EAAM packages",
  ", ",
  ButtonBox["Packages in AbstractAlgebra",
    ButtonData:>{"Packages in AbstractAlgebra", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EAAM packages"],

Cell[TextData[{
  "EisensteinsCriterionQ",
  ", ",
  ButtonBox["Irreducibility of Polynomials",
    ButtonData:>{"Irreducibility of Polynomials", "i:40"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EisensteinsCriterionQ"],

Cell[TextData[{
  "ElementConjugate",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementConjugate"],

Cell[TextData[{
  "ElementToPower",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementToPower"],

Cell[TextData[{
  "EqualMorphiodQ",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EqualMorphiodQ"],

Cell[TextData[{
  "ESG",
  ", ",
  ButtonBox["Potpourri",
    ButtonData:>{"Potpourri", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ESG"],

Cell[TextData[{
  "EvaluationInExtension",
  ", ",
  ButtonBox["Polynomial Quotient Rings",
    ButtonData:>{"Polynomial Quotient Rings", "i:37"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EvaluationInExtension"],

Cell[TextData[{
  "Evaluation of polynomials",
  ", ",
  ButtonBox["Solving Equations, Evaluation",
    ButtonData:>{"Solving Equations, Evaluation", "i:42"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Evaluation of polynomials"],

Cell[TextData[{
  "EvenPermutationQ",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"EvenPermutationQ"],

Cell[TextData[{
  "ExtendPermutation",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExtendPermutation"],

Cell[TextData[{
  "ExtensionDegree",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:86"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExtensionDegree"],

Cell[TextData[{
  "FactorGroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FactorGroup"],

Cell[TextData[{
  "Factor Groups",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Factor Groups"],

Cell[TextData[{
  "FactorRing",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FactorRing"],

Cell[TextData[{
  "Fiber",
  ", ",
  ButtonBox["Kernel, Image, and InverseImage(s)",
    ButtonData:>{"Kernel, Image, and InverseImage(s)", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Fiber"],

Cell[TextData[{
  "FieldIrreducible",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:86"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FieldIrreducible"],

Cell[TextData[{
  "FieldQ",
  ", ",
  ButtonBox["Specialized rings",
    ButtonData:>{"Specialized rings", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FieldQ"],

Cell[TextData[{
  "Finite fields",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:83"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Finite fields"],

Cell[TextData[{
  "FixQ",
  ", ",
  ButtonBox["Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FixQ"],

Cell[TextData[{
  "Formation of EAAM objects",
  ", ",
  ButtonBox["How to form Structures",
    ButtonData:>{"How to form Structures", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Formation of EAAM objects"],

Cell[TextData[{
  "Formation of Morphoids",
  ", ",
  ButtonBox["Forming Morphoids",
    ButtonData:>{"Forming Morphoids", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Formation of Morphoids"],

Cell[TextData[{
  "FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "FormGroupoidByTable",
  ", ",
  ButtonBox["FormGroupoidByTable",
    ButtonData:>{"FormGroupoidByTable", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormGroupoidByTable"],

Cell[TextData[{
  "FormGroupoidFromCycles",
  ", ",
  ButtonBox["FormGroupoidFromCycles and RandomGroupoid",
    ButtonData:>{"FormGroupoidFromCycles and RandomGroupoid", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormGroupoidFromCycles"],

Cell[TextData[{
  "FormMorphoid",
  ", ",
  ButtonBox["Forming Morphoids",
    ButtonData:>{"Forming Morphoids", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormMorphoid"],

Cell[TextData[{
  "FormMorphoidSetup",
  ", ",
  ButtonBox["Forming Morphoids",
    ButtonData:>{"Forming Morphoids", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormMorphoidSetup"],

Cell[TextData[{
  "FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormRingoid"],

Cell[TextData[{
  "FormRingoidByTable",
  ", ",
  ButtonBox["FormRingoidByTable",
    ButtonData:>{"FormRingoidByTable", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormRingoidByTable"],

Cell[TextData[{
  "FromCycles",
  ", ",
  ButtonBox["Cycles",
    ButtonData:>{"Cycles", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FromCycles"],

Cell[TextData[{
  "Func",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:74"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Func"],

Cell[TextData[{
  "Function arithmetic",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:76"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Function arithmetic"],

Cell[TextData[{
  "Functions on a Ringoid",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:73"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Functions on a Ringoid"],

Cell[TextData[{
  "FunctionsOver",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:74"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FunctionsOver"],

Cell[TextData[{
  "FuncToRules",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:75"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FuncToRules"],

Cell[TextData[{
  "GaloisFieldQ",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:86"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaloisFieldQ"],

Cell[TextData[{
  "GaussianIntegerQ",
  ", ",
  ButtonBox["Potpourri",
    ButtonData:>{"Potpourri", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussianIntegerQ"],

Cell[TextData[{
  "Geissinger, L.",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Geissinger, L."],

Cell[TextData[{
  "GeneralLinear",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralLinear"],

Cell[TextData[{
  "GeneralLinearGroup",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneralLinearGroup"],

Cell[TextData[{
  "GenerateGroupoid",
  ", ",
  ButtonBox["GenerateGroupoid",
    ButtonData:>{"GenerateGroupoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GenerateGroupoid"],

Cell[TextData[{
  "GeneratingSet",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GeneratingSet"],

Cell[TextData[{
  "GF",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:84"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GF"],

Cell[TextData[{
  "Global variables and options, ",
  ButtonBox["Global variables and options",
    ButtonData:>{"Global variables and options", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->" Global variables and options"],

Cell[TextData[{
  "GLQ",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:57"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GLQ"],

Cell[TextData[{
  "Graphics Functions",
  ", ",
  ButtonBox["Working with graphics",
    ButtonData:>{"Working with graphics", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Graphics Functions"],

Cell[TextData[{
  "Graphics Output from Visual Mode",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Graphics Output from Visual Mode"],

Cell[TextData[{
  "GroupCenter",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupCenter"],

Cell[TextData[{
  "GroupExponent",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupExponent"],

Cell[TextData[{
  "GroupIdentity",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupIdentity"],

Cell[TextData[{
  "GroupInfo",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupInfo"],

Cell[TextData[{
  "GroupInverse",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupInverse"],

Cell[TextData[{
  "Groupoid Formation",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Groupoid Formation"],

Cell[TextData[{
  "GroupoidName",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupoidName"],

Cell[TextData[{
  "GroupQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupQ"],

Cell[TextData[{
  "Groups of permutations",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Groups of permutations"],

Cell[TextData[{
  "HasIdentityQ",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasIdentityQ"],

Cell[TextData[{
  "HasIdentityQ",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasIdentityQ"],

Cell[TextData[{
  "HasInversesQ",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasInversesQ"],

Cell[TextData[{
  "HasLeftIdentityQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasLeftIdentityQ"],

Cell[TextData[{
  "HasRightIdentityQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasRightIdentityQ"],

Cell[TextData[{
  "HasUnityQ",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasUnityQ"],

Cell[TextData[{
  "HasZeroQ",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasZeroQ"],

Cell[TextData[{
  "HomomorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HomomorphismQ"],

Cell[TextData[{
  "IdealQ",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IdealQ"],

Cell[TextData[{
  "Ideals",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ideals"],

Cell[TextData[{
  "IdempotentQ",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IdempotentQ"],

Cell[TextData[{
  "Idempotents",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Idempotents"],

Cell[TextData[{
  "InducedCanonical",
  ", ",
  ButtonBox["Built-in Morphoids",
    ButtonData:>{"Built-in Morphoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InducedCanonical"],

Cell[TextData[{
  "InducedIsomorphism",
  ", ",
  ButtonBox["Built-in Morphoids",
    ButtonData:>{"Built-in Morphoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InducedIsomorphism"],

Cell[TextData[{
  "Inn",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inn"],

Cell[TextData[{
  "InnerAutomorphism",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InnerAutomorphism"],

Cell[TextData[{
  "InnerAutomorphismGroup",
  ", ",
  ButtonBox["Automorphisms",
    ButtonData:>{"Automorphisms", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InnerAutomorphismGroup"],

Cell[TextData[{
  "IntegerDivisors",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IntegerDivisors"],

Cell[TextData[{
  "IntegerLatticeGrid",
  ", ",
  ButtonBox["Potpourri",
    ButtonData:>{"Potpourri", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IntegerLatticeGrid"],

Cell[TextData[{
  "Integers mod n",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Integers mod n"],

Cell[TextData[{
  "IntegralDomainQ",
  ", ",
  ButtonBox["Specialized rings",
    ButtonData:>{"Specialized rings", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IntegralDomainQ"],

Cell[TextData[{
  "InverseImage",
  ", ",
  ButtonBox["Kernel, Image, and InverseImage(s)",
    ButtonData:>{"Kernel, Image, and InverseImage(s)", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseImage"],

Cell[TextData[{
  "InverseImages",
  ", ",
  ButtonBox["Kernel, Image, and InverseImage(s)",
    ButtonData:>{"Kernel, Image, and InverseImage(s)", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InverseImages"],

Cell[TextData[{
  "Irreducibility of integer-based polynomials",
  ", ",
  ButtonBox["Irreducibility of Polynomials",
    ButtonData:>{"Irreducibility of Polynomials", "i:38"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Irreducibility of integer-based polynomials"],

Cell[TextData[{
  "IrreduciblePolynomial",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:86"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IrreduciblePolynomial"],

Cell[TextData[{
  "IrreduciblePolyOverZpQ",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:86"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IrreduciblePolyOverZpQ"],

Cell[TextData[{
  "IsomorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IsomorphismQ"],

Cell[TextData[{
  "Kernel",
  ", ",
  ButtonBox["Kernel, Image, and InverseImage(s)",
    ButtonData:>{"Kernel, Image, and InverseImage(s)", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Kernel"],

Cell[TextData[{
  "LabCode functions",
  ", ",
  ButtonBox["A look at some functions in LabCode",
    ButtonData:>{"A look at some functions in LabCode", "i:37"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LabCode functions"],

Cell[TextData[{
  "\"Large\" elements and Visual Mode",
  ", ",
  ButtonBox["Visual mode with large elements",
    ButtonData:>{"Visual mode with large elements", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\"Large\" elements and Visual Mode"],

Cell[TextData[{
  "LeftIdealQ",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftIdealQ"],

Cell[TextData[{
  "LeftIdentity",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftIdentity"],

Cell[TextData[{
  "LeftInverse",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftInverse"],

Cell[TextData[{
  "LeftInvertibleQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftInvertibleQ"],

Cell[TextData[{
  "Loading all packages",
  ", ",
  ButtonBox["READ ME FIRST",
    ButtonData:>{"READ ME FIRST", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Loading all packages"],

Cell[TextData[{
  "Mat",
  ", ",
  ButtonBox["MatricesOver",
    ButtonData:>{"MatricesOver", "i:51"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mat"],

Cell[TextData[{
  "MatA",
  ", ",
  ButtonBox["MatricesOver",
    ButtonData:>{"MatricesOver", "i:51"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatA"],

Cell[TextData[{
  "MatM",
  ", ",
  ButtonBox["MatricesOver",
    ButtonData:>{"MatricesOver", "i:51"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatM"],

Cell[TextData[{
  "MatricesOver",
  ", ",
  ButtonBox["MatricesOver",
    ButtonData:>{"MatricesOver", "i:50"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatricesOver"],

Cell[TextData[{
  "Matrices over a ringoid",
  ", ",
  ButtonBox["MatricesOver",
    ButtonData:>{"MatricesOver", "i:49"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrices over a ringoid"],

Cell[TextData[{
  "Matrix arithmetic",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:58"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix arithmetic"],

Cell[TextData[{
  "Matrix Groupoids",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:68"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Groupoids"],

Cell[TextData[{
  "Matrix Inverses",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:61"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Inverses"],

Cell[TextData[{
  "MatrixOperation",
  ", ",
  ButtonBox["Miscellaneous matrix functions",
    ButtonData:>{"Miscellaneous matrix functions", "i:72"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixOperation"],

Cell[TextData[{
  "MatrixOverQ",
  ", ",
  ButtonBox["Miscellaneous matrix functions",
    ButtonData:>{"Miscellaneous matrix functions", "i:72"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixOverQ"],

Cell[TextData[{
  "MatrixPower",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:59"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixPower"],

Cell[TextData[{
  "Matrix Ringoids",
  ", ",
  ButtonBox["Matrix ringoids",
    ButtonData:>{"Matrix ringoids", "i:66"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Ringoids"],

Cell[TextData[{
  "Matrix Sub-extensions",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Sub-extensions"],

Cell[TextData[{
  "MaximalIdealQ",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaximalIdealQ"],

Cell[TextData[{
  "Maximal Ideals",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Maximal Ideals"],

Cell[TextData[{
  "MGroupoid",
  ", ",
  ButtonBox["Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MGroupoid"],

Cell[TextData[{
  "ModpIrreducibilityQ",
  ", ",
  ButtonBox["Irreducibility of Polynomials",
    ButtonData:>{"Irreducibility of Polynomials", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ModpIrreducibilityQ"],

Cell[TextData[{
  "MonoidQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MonoidQ"],

Cell[TextData[{
  "Monomial",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:46"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Monomial"],

Cell[TextData[{
  "MorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MorphismQ"],

Cell[TextData[{
  "MorphoidComposition",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MorphoidComposition"],

Cell[TextData[{
  "MorphoidFunction",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MorphoidFunction"],

Cell[TextData[{
  "MorphoidRules",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MorphoidRules"],

Cell[TextData[{
  "MultipleOfElement",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultipleOfElement"],

Cell[TextData[{
  "MultiplicativeGroupoid",
  ", ",
  ButtonBox["Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplicativeGroupoid"],

Cell[TextData[{
  "MultiplicativeToAdditive",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:88"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplicativeToAdditive"],

Cell[TextData[{
  "MultiplyCycles",
  ", ",
  ButtonBox["Cycle operations",
    ButtonData:>{"Cycle operations", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplyCycles"],

Cell[TextData[{
  "MultiplyPermutations",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplyPermutations"],

Cell[TextData[{
  "Names in a package",
  ", ",
  ButtonBox["Packages in AbstractAlgebra",
    ButtonData:>{"Packages in AbstractAlgebra", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Names in a package"],

Cell[TextData[{
  "NextStage",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NextStage"],

Cell[TextData[{
  "NilpotentDegree",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NilpotentDegree"],

Cell[TextData[{
  "NilpotentQ",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NilpotentQ"],

Cell[TextData[{
  "Nilpotents",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Nilpotents"],

Cell[TextData[{
  "NonAssociatingTriples",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NonAssociatingTriples"],

Cell[TextData[{
  "NonZeroMGroupoid",
  ", ",
  ButtonBox["Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NonZeroMGroupoid"],

Cell[TextData[{
  "Normalizer",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Normalizer"],

Cell[TextData[{
  "NormalQ",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NormalQ"],

Cell[TextData[{
  "OddPermutationQ",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OddPermutationQ"],

Cell[TextData[{
  "Operation-preserving Morphoids",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Operation-preserving Morphoids"],

Cell[TextData[{
  "Operations on Cycles",
  ", ",
  ButtonBox["Cycle operations",
    ButtonData:>{"Cycle operations", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Operations on Cycles"],

Cell[TextData[{
  "Operations on Permutations",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Operations on Permutations"],

Cell[TextData[{
  "OperatorSymbol",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OperatorSymbol"],

Cell[TextData[{
  "Orbit",
  ", ",
  ButtonBox["Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orbit"],

Cell[TextData[{
  "Orbits",
  ", ",
  ButtonBox["Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orbits"],

Cell[TextData[{
  "Ordering",
  ", ",
  ButtonBox["Introduction to Permutations",
    ButtonData:>{"Introduction to Permutations", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ordering"],

Cell[TextData[{
  "Output",
  ", ",
  ButtonBox["Global variables and options",
    ButtonData:>{"Global variables and options", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Output"],

Cell[TextData[{
  "Overview of EAAM",
  ", ",
  ButtonBox["Overview of Structures",
    ButtonData:>{"Overview of Structures", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Overview of EAAM"],

Cell[TextData[{
  "Parity",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Parity"],

Cell[TextData[{
  "Patterns in larger systems",
  ", ",
  ButtonBox["Using Cayley tables ",
    ButtonData:>{"Using Cayley tables ", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Patterns in larger systems"],

Cell[TextData[{
  "PermutationComposition",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationComposition"],

Cell[TextData[{
  "PermutationImage",
  ", ",
  ButtonBox["Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationImage"],

Cell[TextData[{
  "PermutationInverse",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationInverse"],

Cell[TextData[{
  "PermutationMatrix",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationMatrix"],

Cell[TextData[{
  "PermutationQ",
  ", ",
  ButtonBox["Introduction to Permutations",
    ButtonData:>{"Introduction to Permutations", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationQ"],

Cell[TextData[{
  "PermutationToPower",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationToPower"],

Cell[TextData[{
  "PlusSymbol",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PlusSymbol"],

Cell[TextData[{
  "Polynomial Arithmetic",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:27"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomial Arithmetic"],

Cell[TextData[{
  "PolynomialDivision",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialDivision"],

Cell[TextData[{
  "PolynomialEvaluation",
  ", ",
  ButtonBox["Solving Equations, Evaluation",
    ButtonData:>{"Solving Equations, Evaluation", "i:43"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialEvaluation"],

Cell[TextData[{
  "PolynomialGCD",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialGCD"],

Cell[TextData[{
  "Polynomial Interpolation",
  ", ",
  ButtonBox["Polynomial Conversion, Interpolation",
    ButtonData:>{"Polynomial Conversion, Interpolation", "i:81"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomial Interpolation"],

Cell[TextData[{
  "PolynomialLCM",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialLCM"],

Cell[TextData[{
  "PolynomialQuotient",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialQuotient"],

Cell[TextData[{
  "PolynomialRemainder",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialRemainder"],

Cell[TextData[{
  "PolynomialsOfDegreeN",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:47"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialsOfDegreeN"],

Cell[TextData[{
  "Polynomials Over a Ringoid",
  ", ",
  ButtonBox["Forming polynomials",
    ButtonData:>{"Forming polynomials", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomials Over a Ringoid"],

Cell[TextData[{
  "PolynomialsUpToDegreeN",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:47"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolynomialsUpToDegreeN"],

Cell[TextData[{
  "PolyQ",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:46"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolyQ"],

Cell[TextData[{
  "PolyToFunction",
  ", ",
  ButtonBox["Polynomial Conversion, Interpolation",
    ButtonData:>{"Polynomial Conversion, Interpolation", "i:82"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PolyToFunction"],

Cell[TextData[{
  "PowerList",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:87"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PowerList"],

Cell[TextData[{
  "PreservesQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PreservesQ"],

Cell[TextData[{
  "PreviousStage",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PreviousStage"],

Cell[TextData[{
  "PrimeIdealQ",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PrimeIdealQ"],

Cell[TextData[{
  "Prime Ideals",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Prime Ideals"],

Cell[TextData[{
  "PrimitivePolynomials",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:87"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PrimitivePolynomials"],

Cell[TextData[{
  "PrincipalIdeal",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PrincipalIdeal"],

Cell[TextData[{
  "Principal Ideal generated by a Ringoid element",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Principal Ideal generated by a Ringoid element"],

Cell[TextData[{
  "ProbableGroupQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ProbableGroupQ"],

Cell[TextData[{
  "ProbableMorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ProbableMorphismQ"],

Cell[TextData[{
  "ProbableRingQ",
  ", ",
  ButtonBox["RingQ test",
    ButtonData:>{"RingQ test", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ProbableRingQ"],

Cell[TextData[{
  "ProperSubsetQ",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ProperSubsetQ"],

Cell[TextData[{
  "QuaternionGroup",
  ", ",
  ButtonBox["Other groupoids",
    ButtonData:>{"Other groupoids", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QuaternionGroup"],

Cell[TextData[{
  "QuotientGroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QuotientGroup"],

Cell[TextData[{
  "Quotient Groups",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Quotient Groups"],

Cell[TextData[{
  "QuotientRing",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QuotientRing"],

Cell[TextData[{
  "Quotient Rings",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Quotient Rings"],

Cell[TextData[{
  "Quotient rings of polynomials",
  ", ",
  ButtonBox["Polynomial Quotient Rings",
    ButtonData:>{"Polynomial Quotient Rings", "i:35"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Quotient rings of polynomials"],

Cell[TextData[{
  "RandomAssociativeQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomAssociativeQ"],

Cell[TextData[{
  "RandomGroupoid",
  ", ",
  ButtonBox["FormGroupoidFromCycles and RandomGroupoid",
    ButtonData:>{"FormGroupoidFromCycles and RandomGroupoid", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomGroupoid"],

Cell[TextData[{
  "Randomize",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Randomize"],

Cell[TextData[{
  "RandomMatrix",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:53"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomMatrix"],

Cell[TextData[{
  "RandomPermutation",
  ", ",
  ButtonBox["Introduction to Permutations",
    ButtonData:>{"Introduction to Permutations", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomPermutation"],

Cell[TextData[{
  "Random polynomials",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Random polynomials"],

Cell[TextData[{
  "RationalRootCandidates",
  ", ",
  ButtonBox["Irreducibility of Polynomials",
    ButtonData:>{"Irreducibility of Polynomials", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RationalRootCandidates"],

Cell[TextData[{
  "RationalRootTheorem",
  ", ",
  ButtonBox["Irreducibility of Polynomials",
    ButtonData:>{"Irreducibility of Polynomials", "i:39"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RationalRootTheorem"],

Cell[TextData[{
  "ReorderGroupoid",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ReorderGroupoid"],

Cell[TextData[{
  "RightIdealQ",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightIdealQ"],

Cell[TextData[{
  "RightIdentity",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightIdentity"],

Cell[TextData[{
  "RightInverse",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightInverse"],

Cell[TextData[{
  "RightInvertibleQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightInvertibleQ"],

Cell[TextData[{
  "RingInfo",
  ", ",
  ButtonBox["RingQ test",
    ButtonData:>{"RingQ test", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RingInfo"],

Cell[TextData[{
  "RingoidName",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RingoidName"],

Cell[TextData[{
  "RingQ",
  ", ",
  ButtonBox["RingQ test",
    ButtonData:>{"RingQ test", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RingQ"],

Cell[TextData[{
  "SamePermutationQ",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SamePermutationQ"],

Cell[TextData[{
  "SameSetQ",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SameSetQ"],

Cell[TextData[{
  "SemiGroupQ",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SemiGroupQ"],

Cell[TextData[{
  "ShowCircle",
  ", ",
  ButtonBox["Working with graphics",
    ButtonData:>{"Working with graphics", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowCircle"],

Cell[TextData[{
  "ShowColoredPermutation",
  ", ",
  ButtonBox["A look at some functions in LabCode",
    ButtonData:>{"A look at some functions in LabCode", "i:38"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowColoredPermutation"],

Cell[TextData[{
  "ShowFigure",
  ", ",
  ButtonBox["Working with graphics",
    ButtonData:>{"Working with graphics", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowFigure"],

Cell[TextData[{
  "ShowGroupOrders",
  ", ",
  ButtonBox["A look at some functions in LabCode",
    ButtonData:>{"A look at some functions in LabCode", "i:38"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowGroupOrders"],

Cell[TextData[{
  "ShowPermutation",
  ", ",
  ButtonBox["Working with graphics",
    ButtonData:>{"Working with graphics", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowPermutation"],

Cell[TextData[{
  "SizeOfMatrices",
  ", ",
  ButtonBox["Miscellaneous matrix functions",
    ButtonData:>{"Miscellaneous matrix functions", "i:72"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SizeOfMatrices"],

Cell[TextData[{
  "SLQ",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:57"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SLQ"],

Cell[TextData[{
  "Solution of polynomial equations",
  ", ",
  ButtonBox["Solving Equations, Evaluation",
    ButtonData:>{"Solving Equations, Evaluation", "i:42"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Solution of polynomial equations"],

Cell[TextData[{
  "SortGroupoid",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SortGroupoid"],

Cell[TextData[{
  "SpecialLinear",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialLinear"],

Cell[TextData[{
  "SpecialLinearGroup",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SpecialLinearGroup"],

Cell[TextData[{
  "Stabilizer",
  ", ",
  ButtonBox["Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stabilizer"],

Cell[TextData[{
  "Stabilizers",
  ", ",
  ButtonBox["Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Stabilizers"],

Cell[TextData[{
  "Structure of Groupoids",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Structure of Groupoids"],

Cell[TextData[{
  "Structure of Morphoids",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Structure of Morphoids"],

Cell[TextData[{
  "SubgroupClosure",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupClosure"],

Cell[TextData[{
  "SubgroupConjugate",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupConjugate"],

Cell[TextData[{
  "SubgroupGenerated",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupGenerated"],

Cell[TextData[{
  "SubgroupIntersection",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupIntersection"],

Cell[TextData[{
  "SubgroupJoin",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupJoin"],

Cell[TextData[{
  "Subgroupoid",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subgroupoid"],

Cell[TextData[{
  "SubgroupProduct",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupProduct"],

Cell[TextData[{
  "SubgroupQ",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupQ"],

Cell[TextData[{
  "Subgroups",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subgroups"],

Cell[TextData[{
  "SubgroupUnion",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupUnion"],

Cell[TextData[{
  "SubringQ",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubringQ"],

Cell[TextData[{
  "Subrings",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subrings"],

Cell[TextData[{
  "SubsetQ",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubsetQ"],

Cell[TextData[{
  "SwitchStructureTo",
  ", ",
  ButtonBox["Changing the DefaultStructure",
    ButtonData:>{"Changing the DefaultStructure", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SwitchStructureTo"],

Cell[TextData[{
  "TableOfPowers",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:87"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TableOfPowers"],

Cell[TextData[{
  "\"Taker\" family",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"\"Taker\" family"],

Cell[TextData[{
  "TextCayley",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TextCayley"],

Cell[TextData[{
  "TimesSymbol",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TimesSymbol"],

Cell[TextData[{
  "ToCycles",
  ", ",
  ButtonBox["Cycles",
    ButtonData:>{"Cycles", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToCycles"],

Cell[TextData[{
  "ToOrdinaryPolynomial",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:46"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToOrdinaryPolynomial"],

Cell[TextData[{
  "ToPermutation",
  ", ",
  ButtonBox["Representing permutations",
    ButtonData:>{"Representing permutations", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToPermutation"],

Cell[TextData[{
  "ToTranspositions",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToTranspositions"],

Cell[TextData[{
  "Transpositions",
  ", ",
  ButtonBox["Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Transpositions"],

Cell[TextData[{
  "UnionNoSort",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnionNoSort"],

Cell[TextData[{
  "Units",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Units"],

Cell[TextData[{
  "ValuesHavingGivenNorm",
  ", ",
  ButtonBox["Norm-related functions",
    ButtonData:>{"Norm-related functions", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ValuesHavingGivenNorm"],

Cell[TextData[{
  "VisualizeMorphoid",
  ", ",
  ButtonBox["Visualizing Morphoids",
    ButtonData:>{"Visualizing Morphoids", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VisualizeMorphoid"],

Cell[TextData[{
  "VisualTextShown",
  ", ",
  ButtonBox["Global variables and options",
    ButtonData:>{"Global variables and options", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VisualTextShown"],

Cell[TextData[{
  "web page",
  ", ",
  ButtonBox["Introduction to AbstractAlgebra",
    ButtonData:>{"Introduction to AbstractAlgebra", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"web page"],

Cell[TextData[{
  "Working in Z[Sqrt[d]]",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Working in Z[Sqrt[d]]"],

Cell[TextData[{
  "ZdAssociatesQ",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdAssociatesQ"],

Cell[TextData[{
  "ZdCombineAssociates",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:27"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdCombineAssociates"],

Cell[TextData[{
  "ZdConjugate",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdConjugate"],

Cell[TextData[{
  "ZdDivide",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdDivide"],

Cell[TextData[{
  "ZdDividesQ",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdDividesQ"],

Cell[TextData[{
  "ZdDivisors",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdDivisors"],

Cell[TextData[{
  "ZdIrreducibleQ",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdIrreducibleQ"],

Cell[TextData[{
  "ZdNorm",
  ", ",
  ButtonBox["Norm-related functions",
    ButtonData:>{"Norm-related functions", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdNorm"],

Cell[TextData[{
  "ZdPossibleNormQ",
  ", ",
  ButtonBox["Norm-related functions",
    ButtonData:>{"Norm-related functions", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdPossibleNormQ"],

Cell[TextData[{
  "ZdPossibleNorms",
  ", ",
  ButtonBox["Norm-related functions",
    ButtonData:>{"Norm-related functions", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdPossibleNorms"],

Cell[TextData[{
  "ZdQ",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdQ"],

Cell[TextData[{
  "ZdUnitQ",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZdUnitQ"],

Cell[TextData[{
  "ZeroDivisorQ",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroDivisorQ"],

Cell[TextData[{
  "ZeroDivisors",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroDivisors"],

Cell[TextData[{
  StyleBox["Exploring Small Groups",
    FontSlant->"Italic"],
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StyleBox[Exploring Small Groups, FontSlant -> Italic]"],

Cell[TextData[{
  "@",
  ", ",
  "as a short form of MultiplyCycles",
  ", ",
  ButtonBox["Cycle operations",
    ButtonData:>{"Cycle operations", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"@"],

Cell[TextData[{
  "A",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"A"],

Cell[TextData[{
  "Addition",
  ", ",
  "as an operation on polynomials",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Addition"],

Cell[TextData[{
  "Addition",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:77"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Addition"],

Cell[TextData[{
  "Addition",
  ", ",
  "as applied to matrices",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:59"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Addition"],

Cell[TextData[{
  "Addition",
  ", ",
  "as applied to Ringoid extensions",
  ", ",
  ButtonBox["Extension ringoids",
    ButtonData:>{"Extension ringoids", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Addition"],

Cell[TextData[{
  "Addition",
  ", ",
  "in a Ringoid",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Addition"],

Cell[TextData[{
  "Adjoin",
  ", ",
  "as applied to algebraic integers",
  ", ",
  ButtonBox["Adjoin",
    ButtonData:>{"Adjoin", "i:34"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Adjoin"],

Cell[TextData[{
  "All",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"All"],

Cell[TextData[{
  "Alternating",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Alternating"],

Cell[TextData[{
  "AlternatingGroup",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AlternatingGroup"],

Cell[TextData[{
  "Argument flexibility",
  ", ",
  "example",
  ", ",
  ButtonBox["Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Argument flexibility"],

Cell[TextData[{
  "AssociativeQ",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AssociativeQ"],

Cell[TextData[{
  "AssociativeQ",
  ", ",
  "as applied to addition in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AssociativeQ"],

Cell[TextData[{
  "AssociativeQ",
  ", ",
  "as applied to multiplication in a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AssociativeQ"],

Cell[TextData[{
  "AssociativeQ",
  ", ",
  "complexity",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AssociativeQ"],

Cell[TextData[{
  "AssociativeQ",
  ", ",
  "variations",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"AssociativeQ"],

Cell[TextData[{
  "BaseRing",
  ", ",
  "as applied to a polynomial",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:46"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BaseRing"],

Cell[TextData[{
  "BaseRing",
  ", ",
  "as applied to Ringoid extensions",
  ", ",
  ButtonBox["Extension ringoids",
    ButtonData:>{"Extension ringoids", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BaseRing"],

Cell[TextData[{
  "BooleanRing",
  ", ",
  "the family of Ringoids",
  ", ",
  ButtonBox["Other Rings",
    ButtonData:>{"Other Rings", "i:33"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"BooleanRing"],

Cell[TextData[{
  "Canonical Decomposition",
  ", ",
  "of a morphism",
  ", ",
  ButtonBox["Built-in Morphoids",
    ButtonData:>{"Built-in Morphoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Canonical Decomposition"],

Cell[TextData[{
  "CayleyForm",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyForm"],

Cell[TextData[{
  "CayleyForm",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyForm"],

Cell[TextData[{
  "CayleyForm",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyForm"],

Cell[TextData[{
  "CayleyTable",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Using Cayley tables ",
    ButtonData:>{"Using Cayley tables ", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyTable"],

Cell[TextData[{
  "CayleyTable",
  ", ",
  "with Graphics options",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyTable"],

Cell[TextData[{
  "CayleyTable",
  ", ",
  "with \"wide elements\"",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyTable"],

Cell[TextData[{
  "Cayley Tables",
  ", ",
  "of Groupoids",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cayley Tables"],

Cell[TextData[{
  "Cayley Tables",
  ", ",
  "of multiple Groupoids",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:31"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cayley Tables"],

Cell[TextData[{
  "CayleyTables",
  ", ",
  "of a Ringoid",
  ", ",
  ButtonBox["Using Cayley tables ",
    ButtonData:>{"Using Cayley tables ", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CayleyTables"],

Cell[TextData[{
  "Center of a Group",
  ", ",
  "concept",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Center of a Group"],

Cell[TextData[{
  "Centralizer of an element or subgroup",
  ", ",
  "concept",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Centralizer of an element or subgroup"],

Cell[TextData[{
  "Changing Default Values in a Session",
  ", ",
  "example",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Changing Default Values in a Session"],

Cell[TextData[{
  "Characteristic",
  ", ",
  "of a Ringoid",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Characteristic"],

Cell[TextData[{
  "ClosedQ",
  ", ",
  "applied to a subset of a Groupoid",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedQ"],

Cell[TextData[{
  "ClosedQ",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedQ"],

Cell[TextData[{
  "ClosedQ",
  ", ",
  "as applied to multiplication in a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedQ"],

Cell[TextData[{
  "ClosedQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Closure of subsets",
    ButtonData:>{"Closure of subsets", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedQ"],

Cell[TextData[{
  "ClosedQ",
  ", ",
  "as applied to test additive closure in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ClosedQ"],

Cell[TextData[{
  "Closure of subsets",
  ", ",
  "in a Ringoid",
  ", ",
  ButtonBox["Closure of subsets",
    ButtonData:>{"Closure of subsets", "i:27"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Closure of subsets"],

Cell[TextData[{
  "Codomain",
  ", ",
  "of a Morphoid",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Codomain"],

Cell[TextData[{
  "Coefficient",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:45"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Coefficient"],

Cell[TextData[{
  "CoefficientList",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:45"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CoefficientList"],

Cell[TextData[{
  "ColorCodomain",
  ", ",
  "as an option to VisualizeMorphoid",
  ", ",
  ButtonBox["Visualizing Morphoids",
    ButtonData:>{"Visualizing Morphoids", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ColorCodomain"],

Cell[TextData[{
  "ColorDomain",
  ", ",
  "as an option to VisualizeMorphoid",
  ", ",
  ButtonBox["Visualizing Morphoids",
    ButtonData:>{"Visualizing Morphoids", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ColorDomain"],

Cell[TextData[{
  "Combine",
  ", ",
  "as an option with algebraic integers",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Combine"],

Cell[TextData[{
  "CommutativeQ",
  ", ",
  "as applied to addition in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CommutativeQ"],

Cell[TextData[{
  "CommutativeQ",
  ", ",
  "as applied to Groupoids",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CommutativeQ"],

Cell[TextData[{
  "CommutativeQ",
  ", ",
  "as applied to multiplication on a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CommutativeQ"],

Cell[TextData[{
  "Commutator",
  ", ",
  "in a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Commutator"],

Cell[TextData[{
  "Commutators",
  ", ",
  "of a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Commutators"],

Cell[TextData[{
  "Conjugacy Class",
  ", ",
  "concept",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Conjugacy Class"],

Cell[TextData[{
  "Cosets",
  ", ",
  "of a subgroup of a Groupoid",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cosets"],

Cell[TextData[{
  "CosetToList",
  ", ",
  "applied to elements of a quotient group",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CosetToList"],

Cell[TextData[{
  "CosetToList",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CosetToList"],

Cell[TextData[{
  "CycleAs",
  ", ",
  "as an option to ToCycles",
  ", ",
  ButtonBox["Cycles",
    ButtonData:>{"Cycles", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CycleAs"],

Cell[TextData[{
  "Cyclic",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Cyclic"],

Cell[TextData[{
  "CyclicGroup",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"CyclicGroup"],

Cell[TextData[{
  "D",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"D"],

Cell[TextData[{
  "DefaultStructure",
  ", ",
  "how to change",
  ", ",
  ButtonBox["Changing the DefaultStructure",
    ButtonData:>{"Changing the DefaultStructure", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DefaultStructure"],

Cell[TextData[{
  "Degree",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:45"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Degree"],

Cell[TextData[{
  "Det",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:62"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Det"],

Cell[TextData[{
  "Determinants",
  ", ",
  "significance",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:64"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Determinants"],

Cell[TextData[{
  "Determinants",
  ", ",
  "two by two calculation",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:63"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Determinants"],

Cell[TextData[{
  "Diag",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Diag"],

Cell[TextData[{
  "Diag",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Diag"],

Cell[TextData[{
  "Dihedral",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dihedral"],

Cell[TextData[{
  "DihedralGroup",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DihedralGroup"],

Cell[TextData[{
  "DirectProduct",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["Direct products",
    ButtonData:>{"Direct products", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DirectProduct"],

Cell[TextData[{
  "DirectProduct",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Direct Products",
    ButtonData:>{"Direct Products", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DirectProduct"],

Cell[TextData[{
  "Direct Products",
  ", ",
  "of Groupoids",
  ", ",
  ButtonBox["Direct products",
    ButtonData:>{"Direct products", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Direct Products"],

Cell[TextData[{
  "Direct Products",
  ", ",
  "of Ringoids",
  ", ",
  ButtonBox["Direct Products",
    ButtonData:>{"Direct Products", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Direct Products"],

Cell[TextData[{
  "DirectSum",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["Direct products",
    ButtonData:>{"Direct products", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DirectSum"],

Cell[TextData[{
  "DirectSum",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Direct Products",
    ButtonData:>{"Direct Products", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DirectSum"],

Cell[TextData[{
  "Distributive Property",
  ", ",
  "of a Ring",
  ", ",
  ButtonBox["Distributive property",
    ButtonData:>{"Distributive property", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Distributive Property"],

Cell[TextData[{
  "DistributiveQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Distributive property",
    ButtonData:>{"Distributive property", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DistributiveQ"],

Cell[TextData[{
  "DividesQ",
  ", ",
  "as applied to Z[Sqrt[d]]",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DividesQ"],

Cell[TextData[{
  "DividesQ",
  ", ",
  "on integers",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DividesQ"],

Cell[TextData[{
  "Divisibility",
  ", ",
  "Groupoids based on",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Divisibility"],

Cell[TextData[{
  "DivisorsComplete",
  ", ",
  "as an option with algebraic integers",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"DivisorsComplete"],

Cell[TextData[{
  "Domain",
  ", ",
  "as an option to Groupoids",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Domain"],

Cell[TextData[{
  "Domain",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Domain"],

Cell[TextData[{
  "Domain",
  ", ",
  "of a Morphoid",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Domain"],

Cell[TextData[{
  "Dot",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:65"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Dot"],

Cell[TextData[{
  "ElementQ",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementQ"],

Cell[TextData[{
  "ElementQ",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:74"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementQ"],

Cell[TextData[{
  "ElementQ",
  ", ",
  "as applied to matrices",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:53"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementQ"],

Cell[TextData[{
  "ElementQ",
  ", ",
  "as applied to Ringoid extensions",
  ", ",
  ButtonBox["Extension ringoids",
    ButtonData:>{"Extension ringoids", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementQ"],

Cell[TextData[{
  "ElementQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementQ"],

Cell[TextData[{
  "Elements",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Elements"],

Cell[TextData[{
  "Elements",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Elements"],

Cell[TextData[{
  "ElementsQ",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementsQ"],

Cell[TextData[{
  "ElementsQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementsQ"],

Cell[TextData[{
  "ElementToCoset",
  ", ",
  "as applied to elements in a quotient group",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementToCoset"],

Cell[TextData[{
  "ElementToPower",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Testing other properties",
    ButtonData:>{"Testing other properties", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ElementToPower"],

Cell[TextData[{
  "Equal",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:45"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Equal"],

Cell[TextData[{
  "Exponent",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:45"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Exponent"],

Cell[TextData[{
  "Extension Ringoids",
  ", ",
  "overview of types",
  ", ",
  ButtonBox["Extension ringoids",
    ButtonData:>{"Extension ringoids", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Extension Ringoids"],

Cell[TextData[{
  "Extensions of standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " polynomial functions",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:44"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->
  "{Extensions of standard , StyleBox[Mathematica, FontSlant -> Italic],  \
polynomial functions}"],

Cell[TextData[{
  "ExtensionType",
  ", ",
  "as applied to Ringoid extensions",
  ", ",
  ButtonBox["Extension ringoids",
    ButtonData:>{"Extension ringoids", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ExtensionType"],

Cell[TextData[{
  "FirstTaker",
  ", ",
  "the family of Groupids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FirstTaker"],

Cell[TextData[{
  "FlexibleEntering",
  ", ",
  "as an option to Poly",
  ", ",
  ButtonBox["Forming polynomials",
    ButtonData:>{"Forming polynomials", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FlexibleEntering"],

Cell[TextData[{
  "Form",
  ", ",
  "as an option to Dihedral",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Form"],

Cell[TextData[{
  "Form",
  ", ",
  "as an option to QuotientGroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:27"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Form"],

Cell[TextData[{
  "Form",
  ", ",
  "as an option to QuotientRing",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Form"],

Cell[TextData[{
  "FormatElements",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormatElements"],

Cell[TextData[{
  "FormatElements",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormatElements"],

Cell[TextData[{
  "FormatOperator",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormatOperator"],

Cell[TextData[{
  "FormatOperator",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormatOperator"],

Cell[TextData[{
  "FormGroupoid",
  ", ",
  "options",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"FormGroupoid"],

Cell[TextData[{
  "Function arithmetic",
  ", ",
  "definitions",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:79"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Function arithmetic"],

Cell[TextData[{
  "Galois Fields",
  ", ",
  "formation",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:84"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Galois Fields"],

Cell[TextData[{
  "GaussianIntegers",
  ", ",
  "the family of Ringoid",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussianIntegers"],

Cell[TextData[{
  "GaussianIntegersAdditive",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussianIntegersAdditive"],

Cell[TextData[{
  "GaussianIntegersMultiplicative",
  ", ",
  "the family of Groupids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussianIntegersMultiplicative"],

Cell[TextData[{
  "GaussianUnits",
  ", ",
  "the Groupoid",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GaussianUnits"],

Cell[TextData[{
  "Generators",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Generators"],

Cell[TextData[{
  "GL",
  ", ",
  "alternate syntax",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GL"],

Cell[TextData[{
  "GL",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GL"],

Cell[TextData[{
  "GL",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GL"],

Cell[TextData[{
  "Greatest Common Factor",
  ", ",
  "of two polynomials",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:34"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Greatest Common Factor"],

Cell[TextData[{
  "Groupoid",
  ", ",
  "formation",
  ", ",
  ButtonBox["How to form Structures",
    ButtonData:>{"How to form Structures", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Groupoid"],

Cell[TextData[{
  "GroupoidDescription",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"GroupoidDescription"],

Cell[TextData[{
  "Groupoids",
  ", ",
  "created from Ringoids",
  ", ",
  ButtonBox["Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Groupoids"],

Cell[TextData[{
  "Groupoids",
  ", ",
  "Structure",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Groupoids"],

Cell[TextData[{
  "Group Properties",
  ", ",
  "functions to test",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Group Properties"],

Cell[TextData[{
  "HasIdentityQ",
  ", ",
  "as applied to testing for a zero in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasIdentityQ"],

Cell[TextData[{
  "HasIdentityQ",
  ", ",
  "variations",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasIdentityQ"],

Cell[TextData[{
  "HasInversesQ",
  ", ",
  "as applied to negations in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasInversesQ"],

Cell[TextData[{
  "HasInversesQ",
  ", ",
  "variations",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasInversesQ"],

Cell[TextData[{
  "HasNegativeQ",
  ", ",
  "as applies to Ringoids",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasNegativeQ"],

Cell[TextData[{
  "HasZeroQ",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasZeroQ"],

Cell[TextData[{
  "HasZeroQ",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasZeroQ"],

Cell[TextData[{
  "HasZeroQ",
  ", ",
  "as applied to polynomial extensions",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HasZeroQ"],

Cell[TextData[{
  "HeadingsColored",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"HeadingsColored"],

Cell[TextData[{
  "Identity",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Identity"],

Cell[TextData[{
  "IdentityMatrix",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Miscellaneous matrix functions",
    ButtonData:>{"Miscellaneous matrix functions", "i:72"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IdentityMatrix"],

Cell[TextData[{
  "Image",
  ", ",
  "of a Morphoid",
  ", ",
  ButtonBox["Kernel, Image, and InverseImage(s)",
    ButtonData:>{"Kernel, Image, and InverseImage(s)", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Image"],

Cell[TextData[{
  "Indeterminate",
  ", ",
  "as an option to Poly",
  ", ",
  ButtonBox["Forming polynomials",
    ButtonData:>{"Forming polynomials", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Indeterminate"],

Cell[TextData[{
  "Indeterminate",
  ", ",
  "as an option to polynomial lists",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:48"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Indeterminate"],

Cell[TextData[{
  "Index",
  ", ",
  "of a subgroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Index"],

Cell[TextData[{
  "IndexLimit",
  ", ",
  "as an option to Symmetric",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IndexLimit"],

Cell[TextData[{
  "InjectiveQ",
  ", ",
  "as applied to Morphoids",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InjectiveQ"],

Cell[TextData[{
  "IntegerUnits",
  ", ",
  "the Groupoid",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IntegerUnits"],

Cell[TextData[{
  "Internal Form",
  ", ",
  "polynomials",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Internal Form"],

Cell[TextData[{
  "InterpolatingPolynomial",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Polynomial Conversion, Interpolation",
    ButtonData:>{"Polynomial Conversion, Interpolation", "i:82"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InterpolatingPolynomial"],

Cell[TextData[{
  "Inverse",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:62"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverse"],

Cell[TextData[{
  "Inverse",
  ", ",
  "EAAM usage",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverse"],

Cell[TextData[{
  "Inverses",
  ", ",
  "as applied to a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverses"],

Cell[TextData[{
  "Inverses",
  ", ",
  "as applied to Groupids",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverses"],

Cell[TextData[{
  "Inverses",
  ", ",
  "as applied to multiplication in a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverses"],

Cell[TextData[{
  "Inverses",
  ", ",
  "matrix",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:61"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Inverses"],

Cell[TextData[{
  "InvertibleQ",
  ", ",
  "as applied to addition in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InvertibleQ"],

Cell[TextData[{
  "InvertibleQ",
  ", ",
  "as applied to multiplication in a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"InvertibleQ"],

Cell[TextData[{
  "IsAGroup",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IsAGroup"],

Cell[TextData[{
  "IsARing",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"IsARing"],

Cell[TextData[{
  "JoinDivisors",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"JoinDivisors"],

Cell[TextData[{
  "KeyForm",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KeyForm"],

Cell[TextData[{
  "KeyForm",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KeyForm"],

Cell[TextData[{
  "KeyForm",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"KeyForm"],

Cell[TextData[{
  "Klein4",
  ", ",
  "the Groupoid",
  ", ",
  ButtonBox["Other groupoids",
    ButtonData:>{"Other groupoids", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Klein4"],

Cell[TextData[{
  "LatticeRing",
  ", ",
  "the family of Ringoids",
  ", ",
  ButtonBox["Numeric Rings",
    ButtonData:>{"Numeric Rings", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LatticeRing"],

Cell[TextData[{
  "Least Common Multiple",
  ", ",
  "of two polynomials",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:34"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Least Common Multiple"],

Cell[TextData[{
  "LeftCoset",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftCoset"],

Cell[TextData[{
  "LeftCoset",
  ", ",
  "of a subgroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftCoset"],

Cell[TextData[{
  "LeftCosets",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftCosets"],

Cell[TextData[{
  "LeftCosets",
  ", ",
  "of a subgroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftCosets"],

Cell[TextData[{
  "LeftDistributiveQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Distributive property",
    ButtonData:>{"Distributive property", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LeftDistributiveQ"],

Cell[TextData[{
  "ListDensityPlot",
  ", ",
  "as an alternative it CayleyTable",
  ", ",
  ButtonBox["Using Cayley tables ",
    ButtonData:>{"Using Cayley tables ", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ListDensityPlot"],

Cell[TextData[{
  "Lists",
  ", ",
  "functions for working with",
  ", ",
  ButtonBox["Working with lists",
    ButtonData:>{"Working with lists", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Lists"],

Cell[TextData[{
  "LowerDegreeOK",
  ", ",
  "as an option with random polynomials",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LowerDegreeOK"],

Cell[TextData[{
  "LT",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LT"],

Cell[TextData[{
  "LT",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LT"],

Cell[TextData[{
  "LTD",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LTD"],

Cell[TextData[{
  "LTD",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"LTD"],

Cell[TextData[{
  "Matrices",
  ", ",
  "individual",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:52"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrices"],

Cell[TextData[{
  "Matrix Extensions",
  ", ",
  "alternate names and syntax",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Extensions"],

Cell[TextData[{
  "MatrixType",
  ", ",
  "as an option to RandomMatrix",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:56"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MatrixType"],

Cell[TextData[{
  "Matrix Types",
  ", ",
  "testing",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:57"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Matrix Types"],

Cell[TextData[{
  "MaxElementsToList",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaxElementsToList"],

Cell[TextData[{
  "MaxElementsToList",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaxElementsToList"],

Cell[TextData[{
  "MaxTaker",
  ", ",
  "the family of Groupids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MaxTaker"],

Cell[TextData[{
  "MeetDivisors",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MeetDivisors"],

Cell[TextData[{
  "MinTaker",
  ", ",
  "the family of Groupids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MinTaker"],

Cell[TextData[{
  "MixedDivisors",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MixedDivisors"],

Cell[TextData[{
  "Mode",
  ", ",
  "as an option to ClosedQ",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mode"],

Cell[TextData[{
  "Mode",
  ", ",
  "as an option to ring properties functions",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mode"],

Cell[TextData[{
  "Mode",
  ", ",
  "how to use",
  ", ",
  ButtonBox["How to use a Mode",
    ButtonData:>{"How to use a Mode", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Mode"],

Cell[TextData[{
  "ModulusPolynomial",
  ", ",
  "of a polynomial quotient ring",
  ", ",
  ButtonBox["Polynomial Quotient Rings",
    ButtonData:>{"Polynomial Quotient Rings", "i:36"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ModulusPolynomial"],

Cell[TextData[{
  "Monic",
  ", ",
  "as an option with random polynomials",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Monic"],

Cell[TextData[{
  "Morphoid",
  ", ",
  "formation",
  ", ",
  ButtonBox["How to form Structures",
    ButtonData:>{"How to form Structures", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Morphoid"],

Cell[TextData[{
  "Morphoids",
  ", ",
  "concept",
  ", ",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Morphoids"],

Cell[TextData[{
  "Morphoids",
  ", ",
  "formation",
  ", ",
  ButtonBox["Forming Morphoids",
    ButtonData:>{"Forming Morphoids", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Morphoids"],

Cell[TextData[{
  "Morphoids",
  ", ",
  "properties",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Morphoids"],

Cell[TextData[{
  "Morphoids",
  ", ",
  "structure",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Morphoids"],

Cell[TextData[{
  "Morphoids",
  ", ",
  "visualization",
  ", ",
  ButtonBox["Visualizing Morphoids",
    ButtonData:>{"Visualizing Morphoids", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Morphoids"],

Cell[TextData[{
  "Multiplication",
  ", ",
  "as an operation on polynomials",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multiplication"],

Cell[TextData[{
  "Multiplication",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:77"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multiplication"],

Cell[TextData[{
  "Multiplication",
  ", ",
  "as applied to matrices",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:59"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multiplication"],

Cell[TextData[{
  "Multiplication",
  ", ",
  "as applied to Ringoid extensions",
  ", ",
  ButtonBox["Extension ringoids",
    ButtonData:>{"Extension ringoids", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multiplication"],

Cell[TextData[{
  "Multiplication",
  ", ",
  "in a Ringoid",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Multiplication"],

Cell[TextData[{
  "MultiplicationTable",
  ", ",
  "of a Ringoid",
  ", ",
  ButtonBox["Using Cayley tables ",
    ButtonData:>{"Using Cayley tables ", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplicationTable"],

Cell[TextData[{
  "MultiplicativeInverse",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:80"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplicativeInverse"],

Cell[TextData[{
  "MultiplicativeInverse",
  ", ",
  "as applied to matrices",
  ", ",
  ButtonBox["Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "i:62"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"MultiplicativeInverse"],

Cell[TextData[{
  "NegationOf",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NegationOf"],

Cell[TextData[{
  "NegationOf",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NegationOf"],

Cell[TextData[{
  "NegationOf",
  ", ",
  "as applied to polynomial extensions",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NegationOf"],

Cell[TextData[{
  "NegationOf",
  ", ",
  "as applies to Ringoids",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NegationOf"],

Cell[TextData[{
  "NonCommutingPairs",
  ", ",
  "in a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NonCommutingPairs"],

Cell[TextData[{
  "NonTrivialOnly",
  ", ",
  "as an option with algebraic integers",
  ", ",
  ButtonBox["Divisibility",
    ButtonData:>{"Divisibility", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"NonTrivialOnly"],

Cell[TextData[{
  "Normality",
  ", ",
  "of subgroups",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Normality"],

Cell[TextData[{
  "Normalize",
  ", ",
  "as an option to ToCycles",
  ", ",
  ButtonBox["Cycles",
    ButtonData:>{"Cycles", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Normalize"],

Cell[TextData[{
  "Normalizer",
  ", ",
  "concept",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Normalizer"],

Cell[TextData[{
  "Norm-related functions",
  ", ",
  "in Z[Sqrt[d]]",
  ", ",
  ButtonBox["Norm-related functions",
    ButtonData:>{"Norm-related functions", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Norm-related functions"],

Cell[TextData[{
  "OneToOneQ",
  ", ",
  "as applied to Morphoids",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OneToOneQ"],

Cell[TextData[{
  "OntoQ",
  ", ",
  "as applied to Morphoids",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OntoQ"],

Cell[TextData[{
  "Operation",
  ", ",
  "applied to Groupoids",
  ", ",
  ButtonBox["Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Operation"],

Cell[TextData[{
  "Operation",
  ", ",
  "as an option to ring properties functions",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Operation"],

Cell[TextData[{
  "Order",
  ", ",
  "of a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Order"],

Cell[TextData[{
  "OrderOfAllElements",
  ", ",
  "in a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrderOfAllElements"],

Cell[TextData[{
  "OrderOfElement",
  ", ",
  "in a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"OrderOfElement"],

Cell[TextData[{
  "Orders",
  ", ",
  "in a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Orders"],

Cell[TextData[{
  "Packages",
  ", ",
  "EAAM",
  ", ",
  ButtonBox["Packages in AbstractAlgebra",
    ButtonData:>{"Packages in AbstractAlgebra", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Packages"],

Cell[TextData[{
  "Parity",
  ", ",
  "as a Morphoid",
  ", ",
  ButtonBox["Forming Morphoids",
    ButtonData:>{"Forming Morphoids", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Parity"],

Cell[TextData[{
  "PermutationGroup",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PermutationGroup"],

Cell[TextData[{
  "Permutations",
  ", ",
  "operations",
  ", ",
  ButtonBox["Permutation operations",
    ButtonData:>{"Permutation operations", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Permutations"],

Cell[TextData[{
  "Permutations",
  ", ",
  "representations",
  ", ",
  ButtonBox["Representing permutations",
    ButtonData:>{"Representing permutations", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Permutations"],

Cell[TextData[{
  "Permutations and Cycles",
  ", ",
  "working with",
  ", ",
  ButtonBox["Introduction to Permutations",
    ButtonData:>{"Introduction to Permutations", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Permutations and Cycles"],

Cell[TextData[{
  "Poly",
  ", ",
  "as a head for polynomials",
  ", ",
  ButtonBox["Forming polynomials",
    ButtonData:>{"Forming polynomials", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Poly"],

Cell[TextData[{
  "Polynomial Conversion",
  ", ",
  "to functions",
  ", ",
  ButtonBox["Polynomial Conversion, Interpolation",
    ButtonData:>{"Polynomial Conversion, Interpolation", "i:81"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomial Conversion"],

Cell[TextData[{
  "Polynomial Evaluation",
  ", ",
  "in a polynomial quotient ring",
  ", ",
  ButtonBox["Polynomial Quotient Rings",
    ButtonData:>{"Polynomial Quotient Rings", "i:37"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomial Evaluation"],

Cell[TextData[{
  "Polynomials",
  ", ",
  "formation",
  ", ",
  ButtonBox["Forming polynomials",
    ButtonData:>{"Forming polynomials", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomials"],

Cell[TextData[{
  "Polynomials",
  ", ",
  "internal form of a simple polynomial",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:30"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomials"],

Cell[TextData[{
  "Polynomials",
  ", ",
  "random",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Polynomials"],

Cell[TextData[{
  "PowersIncrease",
  ", ",
  "as an option to Poly",
  ", ",
  ButtonBox["Forming polynomials",
    ButtonData:>{"Forming polynomials", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PowersIncrease"],

Cell[TextData[{
  "PrintMessage",
  ", ",
  "as an option to ProbableMorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"PrintMessage"],

Cell[TextData[{
  "ProductOrder",
  ", ",
  "as an option to FormGroupoidFromCycles",
  ", ",
  ButtonBox["FormGroupoidFromCycles and RandomGroupoid",
    ButtonData:>{"FormGroupoidFromCycles and RandomGroupoid", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ProductOrder"],

Cell[TextData[{
  "QuotientRing",
  ", ",
  "as applied to polynomial extensions",
  ", ",
  ButtonBox["Polynomial Quotient Rings",
    ButtonData:>{"Polynomial Quotient Rings", "i:36"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"QuotientRing"],

Cell[TextData[{
  "RandomAssociativeQ",
  ", ",
  "as applied to addition in a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomAssociativeQ"],

Cell[TextData[{
  "RandomAssociativeQ",
  ", ",
  "as applied to multiplication in a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomAssociativeQ"],

Cell[TextData[{
  "RandomDistributiveQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Distributive property",
    ButtonData:>{"Distributive property", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomDistributiveQ"],

Cell[TextData[{
  "RandomElement",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:75"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElement"],

Cell[TextData[{
  "RandomElement",
  ", ",
  "as applied to matrices",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:53"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElement"],

Cell[TextData[{
  "RandomElement",
  ", ",
  "as applied to polynomials",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElement"],

Cell[TextData[{
  "RandomElement",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElement"],

Cell[TextData[{
  "RandomElement",
  ", ",
  "as applied to Z[Sqrt[d]]",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElement"],

Cell[TextData[{
  "RandomElement",
  ", ",
  "from a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElement"],

Cell[TextData[{
  "Random Elements",
  ", ",
  "from various structures",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Random Elements"],

Cell[TextData[{
  "Random Elements",
  ", ",
  "of Ringoids",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Random Elements"],

Cell[TextData[{
  "RandomElements",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Extensions",
    ButtonData:>{"Function Extensions", "i:75"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElements"],

Cell[TextData[{
  "RandomElements",
  ", ",
  "as applied to matrices",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:53"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElements"],

Cell[TextData[{
  "RandomElements",
  ", ",
  "as applied to polynomials",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElements"],

Cell[TextData[{
  "RandomElements",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElements"],

Cell[TextData[{
  "RandomElements",
  ", ",
  "as applied to Z[Sqrt[d]]",
  ", ",
  ButtonBox["Basic functions",
    ButtonData:>{"Basic functions", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElements"],

Cell[TextData[{
  "RandomElements",
  ", ",
  "from a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:1"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RandomElements"],

Cell[TextData[{
  "RefSym",
  ", ",
  "as an option to Dihedral",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RefSym"],

Cell[TextData[{
  "Replacement",
  ", ",
  "as an option to random elements of a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Replacement"],

Cell[TextData[{
  "Replacement",
  ", ",
  "as applied to random elements of a Ringoid",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Replacement"],

Cell[TextData[{
  "ReportIterations",
  ", ",
  "as an option to Closure",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ReportIterations"],

Cell[TextData[{
  "Representatives",
  ", ",
  "as an option to QuotientGroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:27"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Representatives"],

Cell[TextData[{
  "RightCoset",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightCoset"],

Cell[TextData[{
  "RightCoset",
  ", ",
  "of a subgroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:20"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightCoset"],

Cell[TextData[{
  "RightCosets",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightCosets"],

Cell[TextData[{
  "RightCosets",
  ", ",
  "of a subgroup",
  ", ",
  ButtonBox["Quotient groups",
    ButtonData:>{"Quotient groups", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightCosets"],

Cell[TextData[{
  "RightDistributiveQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Distributive property",
    ButtonData:>{"Distributive property", "i:24"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RightDistributiveQ"],

Cell[TextData[{
  "Ringoid",
  ", ",
  "formation",
  ", ",
  ButtonBox["How to form Structures",
    ButtonData:>{"How to form Structures", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ringoid"],

Cell[TextData[{
  "RingoidDescription",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RingoidDescription"],

Cell[TextData[{
  "RingoidName",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RingoidName"],

Cell[TextData[{
  "Ringoids",
  ", ",
  "multiplicative properties",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:19"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ringoids"],

Cell[TextData[{
  "Ring Properties",
  ", ",
  "additive",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Ring Properties"],

Cell[TextData[{
  "RootsOfUnity",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "i:12"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RootsOfUnity"],

Cell[TextData[{
  "RotSym",
  ", ",
  "as an option to Dihedral",
  ", ",
  ButtonBox["Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "i:22"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"RotSym"],

Cell[TextData[{
  "SamplePairs",
  ", ",
  "as an option to ProbableMorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SamplePairs"],

Cell[TextData[{
  "SampleSize",
  ", ",
  "as an option to ProbableMorphismQ",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:18"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SampleSize"],

Cell[TextData[{
  "SelectBaseElementsFrom",
  ", ",
  "as an option for random matrices",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:54"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SelectBaseElementsFrom"],

Cell[TextData[{
  "SelectFrom",
  ", ",
  "as an option for random matrices",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:54"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SelectFrom"],

Cell[TextData[{
  "SelectFrom",
  ", ",
  "as an option to random elements of a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:2"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SelectFrom"],

Cell[TextData[{
  "SelectFrom",
  ", ",
  "as an option with random polynomials",
  ", ",
  ButtonBox["Random polynomials",
    ButtonData:>{"Random polynomials", "i:26"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SelectFrom"],

Cell[TextData[{
  "SelectFrom",
  ", ",
  "as applied to random element of a Ringoid",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SelectFrom"],

Cell[TextData[{
  "ShowBodyText",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowBodyText"],

Cell[TextData[{
  "ShowName",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowName"],

Cell[TextData[{
  "ShowOperator",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowOperator"],

Cell[TextData[{
  "ShowSidesText",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ShowSidesText"],

Cell[TextData[{
  "Size",
  ", ",
  "of a Groupoid",
  ", ",
  ButtonBox["Other group properties",
    ButtonData:>{"Other group properties", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Size"],

Cell[TextData[{
  "SizeLimit",
  ", ",
  "as an option to GenerateGroupoid",
  ", ",
  ButtonBox["GenerateGroupoid",
    ButtonData:>{"GenerateGroupoid", "i:5"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SizeLimit"],

Cell[TextData[{
  "SizeLimit",
  ", ",
  "as an option to polynomial lists",
  ", ",
  ButtonBox["Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "i:48"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SizeLimit"],

Cell[TextData[{
  "SizeLimit",
  ", ",
  "as an option to ToRingoid on matrices",
  ", ",
  ButtonBox["Matrix ringoids",
    ButtonData:>{"Matrix ringoids", "i:67"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SizeLimit"],

Cell[TextData[{
  "SL",
  ", ",
  "alternate syntax",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:71"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SL"],

Cell[TextData[{
  "SL",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SL"],

Cell[TextData[{
  "SL",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SL"],

Cell[TextData[{
  "Solve",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Solving Equations, Evaluation",
    ButtonData:>{"Solving Equations, Evaluation", "i:43"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Solve"],

Cell[TextData[{
  "Sort",
  ", ",
  "as an option to Closure",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Sort"],

Cell[TextData[{
  "Staged",
  ", ",
  "as an option to Closure",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Staged"],

Cell[TextData[{
  "Staged Closure",
  ", ",
  "procedure for usage",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:11"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Staged Closure"],

Cell[TextData[{
  "Structure",
  ", ",
  "as an option to ClosedQ",
  ", ",
  ButtonBox["The four standard functions",
    ButtonData:>{"The four standard functions", "i:15"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Structure"],

Cell[TextData[{
  "Structure",
  ", ",
  "how to change",
  ", ",
  ButtonBox["Changing the DefaultStructure",
    ButtonData:>{"Changing the DefaultStructure", "i:13"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Structure"],

Cell[TextData[{
  "SubgroupGenerated",
  ", ",
  "Visual2 mode",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupGenerated"],

Cell[TextData[{
  "SubgroupQ",
  ", ",
  "syntax explanation",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupQ"],

Cell[TextData[{
  "SubgroupQ",
  ", ",
  "Visual2 mode",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:8"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SubgroupQ"],

Cell[TextData[{
  "Subgroups",
  ", ",
  "combining",
  ", ",
  ButtonBox["Subgroups",
    ButtonData:>{"Subgroups", "i:16"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Subgroups"],

Cell[TextData[{
  "SurjectiveQ",
  ", ",
  "as applied to Morphoids",
  ", ",
  ButtonBox["Properties",
    ButtonData:>{"Properties", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SurjectiveQ"],

Cell[TextData[{
  "Symmetric",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Symmetric"],

Cell[TextData[{
  "SymmetricGroup",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groups of permutations",
    ButtonData:>{"Groups of permutations", "i:14"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"SymmetricGroup"],

Cell[TextData[{
  "TheSet",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TheSet"],

Cell[TextData[{
  "ToFunction",
  ", ",
  "applied to Morphoids",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToFunction"],

Cell[TextData[{
  "ToGroupoid",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:69"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToGroupoid"],

Cell[TextData[{
  "ToRingoid",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix ringoids",
    ButtonData:>{"Matrix ringoids", "i:67"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToRingoid"],

Cell[TextData[{
  "ToRules",
  ", ",
  "as applied to permutations",
  ", ",
  ButtonBox["Representing permutations",
    ButtonData:>{"Representing permutations", "i:9"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToRules"],

Cell[TextData[{
  "ToRules",
  ", ",
  "EAAM usage, applied to Morphoids",
  ", ",
  ButtonBox["The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ToRules"],

Cell[TextData[{
  "Trivial",
  ", ",
  "the Groupoid",
  ", ",
  ButtonBox["Other groupoids",
    ButtonData:>{"Other groupoids", "i:25"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Trivial"],

Cell[TextData[{
  "TrivialZR",
  ", ",
  "the family of Ringoids",
  ", ",
  ButtonBox["Numeric Rings",
    ButtonData:>{"Numeric Rings", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TrivialZR"],

Cell[TextData[{
  "TwistedZ",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"TwistedZ"],

Cell[TextData[{
  "Types of Structures",
  ", ",
  "testing",
  ", ",
  ButtonBox["Related functions",
    ButtonData:>{"Related functions", "i:23"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Types of Structures"],

Cell[TextData[{
  "U",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"U"],

Cell[TextData[{
  "UnitQ",
  ", ",
  "as applied to a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnitQ"],

Cell[TextData[{
  "UnitQ",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnitQ"],

Cell[TextData[{
  "UnitQ",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnitQ"],

Cell[TextData[{
  "Unity",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unity"],

Cell[TextData[{
  "Unity",
  ", ",
  "as applied to polynomial extensions",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unity"],

Cell[TextData[{
  "Unity",
  ", ",
  "of a Ringoid",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Unity"],

Cell[TextData[{
  "UnityQ",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UnityQ"],

Cell[TextData[{
  "UT",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UT"],

Cell[TextData[{
  "UT",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UT"],

Cell[TextData[{
  "UTD",
  ", ",
  "as a matrix sub-extension",
  ", ",
  ButtonBox["Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "i:70"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UTD"],

Cell[TextData[{
  "UTD",
  ", ",
  "as a value of the MatrixType option",
  ", ",
  ButtonBox["Individual matrices",
    ButtonData:>{"Individual matrices", "i:55"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"UTD"],

Cell[TextData[{
  "Variables",
  ", ",
  "EAAM usage for polynomials",
  ", ",
  ButtonBox["Extensions of Stnrd Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", "i:45"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Variables"],

Cell[TextData[{
  "VarToUse",
  ", ",
  "as an option to CayleyTable",
  ", ",
  ButtonBox["Cayley tables",
    ButtonData:>{"Cayley tables", "i:28"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"VarToUse"],

Cell[TextData[{
  "Well-defined Operation",
  ", ",
  "when an operation is not one",
  ", ",
  ButtonBox["Quotient Rings",
    ButtonData:>{"Quotient Rings", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Well-defined Operation"],

Cell[TextData[{
  "WideElements",
  ", ",
  "as an option to FormGroupoid",
  ", ",
  ButtonBox["FormGroupoid",
    ButtonData:>{"FormGroupoid", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WideElements"],

Cell[TextData[{
  "WideElements",
  ", ",
  "as an option to FormRingoid",
  ", ",
  ButtonBox["FormRingoid",
    ButtonData:>{"FormRingoid", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WideElements"],

Cell[TextData[{
  "WithUnityQ",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WithUnityQ"],

Cell[TextData[{
  "WithUnityQ",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WithUnityQ"],

Cell[TextData[{
  "WithUnityQ",
  ", ",
  "as applied to polynomial extensions",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WithUnityQ"],

Cell[TextData[{
  "WithUnityQ",
  ", ",
  "as applied to Ringoids",
  ", ",
  ButtonBox["Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "i:21"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"WithUnityQ"],

Cell[TextData[{
  "Z",
  ", ",
  "functions related to",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:7"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Z"],

Cell[TextData[{
  "Z",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Z"],

Cell[TextData[{
  "Z",
  ", ",
  "the family of Ringoids",
  ", ",
  ButtonBox["Numeric Rings",
    ButtonData:>{"Numeric Rings", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Z"],

Cell[TextData[{
  "Z",
  ", ",
  "Variations",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:4"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Z"],

Cell[TextData[{
  "Zero",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero"],

Cell[TextData[{
  "Zero",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero"],

Cell[TextData[{
  "Zero",
  ", ",
  "as applied to polynomial extensions",
  ", ",
  ButtonBox["Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "i:29"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero"],

Cell[TextData[{
  "Zero",
  ", ",
  "of a Ringoid",
  ", ",
  ButtonBox["Additive properties",
    ButtonData:>{"Additive properties", "i:17"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zero"],

Cell[TextData[{
  "ZeroDivisorQ",
  ", ",
  "as applied to functions over a Ringoid",
  ", ",
  ButtonBox["Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "i:78"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroDivisorQ"],

Cell[TextData[{
  "ZeroDivisorQ",
  ", ",
  "as applied to matrix extensions",
  ", ",
  ButtonBox["Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "i:60"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZeroDivisorQ"],

Cell[TextData[{
  "Zeros",
  ", ",
  "of a polynomial",
  ", ",
  ButtonBox["Solving Equations, Evaluation",
    ButtonData:>{"Solving Equations, Evaluation", "i:43"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zeros"],

Cell[TextData[{
  "ZG",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:3"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZG"],

Cell[TextData[{
  "ZMap",
  ", ",
  "the family of Morphoids",
  ", ",
  ButtonBox["Built-in Morphoids",
    ButtonData:>{"Built-in Morphoids", "i:10"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZMap"],

Cell[TextData[{
  "ZR",
  ", ",
  "the family of Ringoids",
  ", ",
  ButtonBox["Numeric Rings",
    ButtonData:>{"Numeric Rings", "i:32"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"ZR"],

Cell[TextData[{
  "Zx",
  ", ",
  "the family of Groupoids",
  ", ",
  ButtonBox["Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", "i:6"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"Zx"],

Cell[TextData[{
  "Indeterminate",
  ", ",
  "as an option to GF",
  ", ",
  ButtonBox["Finite fields",
    ButtonData:>{"Finite fields", "i:85"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->"StyleBox[Indeterminate, MR]"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{28, Automatic}, {Automatic, 23}},
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1709, 49, 73, 1, 41, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "AbelianQ"->{
    Cell[1785, 52, 194, 7, 23, "Index",
      CellTags->"AbelianQ"]},
  "AdditiveGroupoid"->{
    Cell[1982, 61, 213, 7, 23, "Index",
      CellTags->"AdditiveGroupoid"]},
  "AdditiveToMultiplicative"->{
    Cell[2198, 70, 209, 7, 23, "Index",
      CellTags->"AdditiveToMultiplicative"]},
  "AGroupoid"->{
    Cell[2410, 79, 199, 7, 23, "Index",
      CellTags->"AGroupoid"]},
  "Alternating Group"->{
    Cell[2612, 88, 213, 7, 23, "Index",
      CellTags->"Alternating Group"]},
  "Annihilator"->{
    Cell[2828, 97, 195, 7, 23, "Index",
      CellTags->"Annihilator"]},
  "Annihilator of a Set"->{
    Cell[3026, 106, 213, 7, 23, "Index",
      CellTags->"Annihilator of a Set"]},
  "Aut"->{
    Cell[3242, 115, 167, 7, 23, "Index",
      CellTags->"Aut"]},
  "Automorphism"->{
    Cell[3412, 124, 185, 7, 23, "Index",
      CellTags->"Automorphism"]},
  "AutomorphismGroup"->{
    Cell[3600, 133, 195, 7, 23, "Index",
      CellTags->"AutomorphismGroup"]},
  "Automorphisms"->{
    Cell[3798, 142, 187, 7, 23, "Index",
      CellTags->"Automorphisms"]},
  "BackgroundColors"->{
    Cell[3988, 151, 222, 7, 23, "Index",
      CellTags->"BackgroundColors"]},
  "Building Groupoids from Groupoids"->{
    Cell[4213, 160, 230, 7, 23, "Index",
      CellTags->"Building Groupoids from Groupoids"]},
  "Building Ringoids from Ringoids"->{
    Cell[4446, 169, 226, 7, 23, "Index",
      CellTags->"Building Ringoids from Ringoids"]},
  "Built-in Groupoids"->{
    Cell[4675, 178, 244, 7, 23, "Index",
      CellTags->"Built-in Groupoids"]},
  "Built-in Morphoids"->{
    Cell[4922, 187, 206, 7, 23, "Index",
      CellTags->"Built-in Morphoids"]},
  "CartesianProduct"->{
    Cell[5131, 196, 203, 7, 23, "Index",
      CellTags->"CartesianProduct"]},
  "CayleyTable"->{
    Cell[5337, 205, 183, 7, 23, "Index",
      CellTags->"CayleyTable"],
    Cell[70928, 3088, 232, 9, 23, "Index",
      CellTags->"CayleyTable"],
    Cell[71163, 3099, 218, 9, 23, "Index",
      CellTags->"CayleyTable"],
    Cell[71384, 3110, 219, 9, 23, "Index",
      CellTags->"CayleyTable"]},
  "Center"->{
    Cell[5523, 214, 190, 7, 23, "Index",
      CellTags->"Center"]},
  "Centralizer"->{
    Cell[5716, 223, 200, 7, 23, "Index",
      CellTags->"Centralizer"]},
  "ClosedDiffQ"->{
    Cell[5919, 232, 193, 7, 23, "Index",
      CellTags->"ClosedDiffQ"]},
  "ClosedPlusQ"->{
    Cell[6115, 241, 193, 7, 23, "Index",
      CellTags->"ClosedPlusQ"]},
  "ClosedTimesQ"->{
    Cell[6311, 250, 195, 7, 23, "Index",
      CellTags->"ClosedTimesQ"]},
  "CloseSets"->{
    Cell[6509, 259, 189, 7, 23, "Index",
      CellTags->"CloseSets"]},
  "Closure"->{
    Cell[6701, 268, 166, 7, 23, "Index",
      CellTags->"Closure"]},
  "CollectOrders"->{
    Cell[6870, 277, 231, 7, 23, "Index",
      CellTags->"CollectOrders"]},
  "CommutatorSubgroup"->{
    Cell[7104, 286, 214, 7, 23, "Index",
      CellTags->"CommutatorSubgroup"]},
  "ComplementNoSort"->{
    Cell[7321, 295, 203, 7, 23, "Index",
      CellTags->"ComplementNoSort"]},
  "ComplexToPoint"->{
    Cell[7527, 304, 181, 7, 23, "Index",
      CellTags->"ComplexToPoint"]},
  "ConjugacyClass"->{
    Cell[7711, 313, 206, 7, 23, "Index",
      CellTags->"ConjugacyClass"]},
  "Conjugate"->{
    Cell[7920, 322, 196, 7, 23, "Index",
      CellTags->"Conjugate"]},
  "Cycle operations"->{
    Cell[8119, 331, 199, 7, 23, "Index",
      CellTags->"Cycle operations"]},
  "Cycles"->{
    Cell[8321, 340, 159, 7, 23, "Index",
      CellTags->"Cycles"]},
  "CyclicGenerators"->{
    Cell[8483, 349, 211, 7, 23, "Index",
      CellTags->"CyclicGenerators"]},
  "Cyclic Groups"->{
    Cell[8697, 358, 213, 7, 23, "Index",
      CellTags->"Cyclic Groups"]},
  "CyclicQ"->{
    Cell[8913, 367, 193, 7, 23, "Index",
      CellTags->"CyclicQ"]},
  "Cyclic subgroup generation"->{
    Cell[9109, 376, 205, 7, 23, "Index",
      CellTags->"Cyclic subgroup generation"]},
  "CyclicSubgroups"->{
    Cell[9317, 385, 183, 7, 23, "Index",
      CellTags->"CyclicSubgroups"]},
  "DefaultOrder"->{
    Cell[9503, 394, 214, 7, 23, "Index",
      CellTags->"DefaultOrder"]},
  "DefaultStructure"->{
    Cell[9720, 403, 222, 7, 23, "Index",
      CellTags->"DefaultStructure"],
    Cell[79277, 3473, 252, 9, 23, "Index",
      CellTags->"DefaultStructure"]},
  "Determinants"->{
    Cell[9945, 412, 205, 7, 23, "Index",
      CellTags->"Determinants"],
    Cell[79998, 3506, 231, 9, 23, "Index",
      CellTags->"Determinants"],
    Cell[80232, 3517, 241, 9, 23, "Index",
      CellTags->"Determinants"]},
  "DiagonalMatrices"->{
    Cell[10153, 421, 199, 7, 23, "Index",
      CellTags->"DiagonalMatrices"]},
  "DiagQ"->{
    Cell[10355, 430, 183, 7, 23, "Index",
      CellTags->"DiagQ"]},
  "Dihedral Groups"->{
    Cell[10541, 439, 217, 7, 23, "Index",
      CellTags->"Dihedral Groups"]},
  "DisguiseGroupoid"->{
    Cell[10761, 448, 221, 7, 23, "Index",
      CellTags->"DisguiseGroupoid"]},
  "DisguiseRingoid"->{
    Cell[10985, 457, 219, 7, 23, "Index",
      CellTags->"DisguiseRingoid"]},
  "Disguising groups and rings"->{
    Cell[11207, 466, 243, 7, 23, "Index",
      CellTags->"Disguising groups and rings"]},
  "DisjointCyclesQ"->{
    Cell[11453, 475, 223, 7, 23, "Index",
      CellTags->"DisjointCyclesQ"]},
  "\"Divides\" family of Groupoids"->{
    Cell[11679, 484, 243, 7, 23, "Index",
      CellTags->"\"Divides\" family of Groupoids"]},
  "Divisibility in Z[Sqrt[d]]"->{
    Cell[11925, 493, 211, 7, 23, "Index",
      CellTags->"Divisibility in Z[Sqrt[d]]"]},
  "Division Property of Polynomials"->{
    Cell[12139, 502, 241, 7, 23, "Index",
      CellTags->"Division Property of Polynomials"]},
  "DrawNgon"->{
    Cell[12383, 511, 193, 7, 23, "Index",
      CellTags->"DrawNgon"]},
  "EAAM packages"->{
    Cell[12579, 520, 214, 7, 23, "Index",
      CellTags->"EAAM packages"]},
  "EisensteinsCriterionQ"->{
    Cell[12796, 529, 235, 7, 23, "Index",
      CellTags->"EisensteinsCriterionQ"]},
  "ElementConjugate"->{
    Cell[13034, 538, 210, 7, 23, "Index",
      CellTags->"ElementConjugate"]},
  "ElementToPower"->{
    Cell[13247, 547, 207, 7, 23, "Index",
      CellTags->"ElementToPower"],
    Cell[87368, 3858, 247, 9, 23, "Index",
      CellTags->"ElementToPower"]},
  "EqualMorphiodQ"->{
    Cell[13457, 556, 214, 7, 23, "Index",
      CellTags->"EqualMorphiodQ"]},
  "ESG"->{
    Cell[13674, 565, 159, 7, 23, "Index",
      CellTags->"ESG"]},
  "EvaluationInExtension"->{
    Cell[13836, 574, 227, 7, 23, "Index",
      CellTags->"EvaluationInExtension"]},
  "Evaluation of polynomials"->{
    Cell[14066, 583, 243, 7, 23, "Index",
      CellTags->"Evaluation of polynomials"]},
  "EvenPermutationQ"->{
    Cell[14312, 592, 225, 7, 23, "Index",
      CellTags->"EvenPermutationQ"]},
  "ExtendPermutation"->{
    Cell[14540, 601, 212, 7, 23, "Index",
      CellTags->"ExtendPermutation"]},
  "ExtensionDegree"->{
    Cell[14755, 610, 191, 7, 23, "Index",
      CellTags->"ExtensionDegree"]},
  "FactorGroup"->{
    Cell[14949, 619, 187, 7, 23, "Index",
      CellTags->"FactorGroup"]},
  "Factor Groups"->{
    Cell[15139, 628, 191, 7, 23, "Index",
      CellTags->"Factor Groups"]},
  "FactorRing"->{
    Cell[15333, 637, 183, 7, 23, "Index",
      CellTags->"FactorRing"]},
  "Fiber"->{
    Cell[15519, 646, 213, 7, 23, "Index",
      CellTags->"Fiber"]},
  "FieldIrreducible"->{
    Cell[15735, 655, 193, 7, 23, "Index",
      CellTags->"FieldIrreducible"]},
  "FieldQ"->{
    Cell[15931, 664, 181, 7, 23, "Index",
      CellTags->"FieldQ"]},
  "Finite fields"->{
    Cell[16115, 673, 187, 7, 23, "Index",
      CellTags->"Finite fields"]},
  "FixQ"->{
    Cell[16305, 682, 187, 7, 23, "Index",
      CellTags->"FixQ"]},
  "Formation of EAAM objects"->{
    Cell[16495, 691, 228, 7, 23, "Index",
      CellTags->"Formation of EAAM objects"]},
  "Formation of Morphoids"->{
    Cell[16726, 700, 212, 7, 23, "Index",
      CellTags->"Formation of Morphoids"]},
  "FormGroupoid"->{
    Cell[16941, 709, 182, 7, 23, "Index",
      CellTags->"FormGroupoid"],
    Cell[91080, 4026, 203, 9, 23, "Index",
      CellTags->"FormGroupoid"]},
  "FormGroupoidByTable"->{
    Cell[17126, 718, 210, 7, 23, "Index",
      CellTags->"FormGroupoidByTable"]},
  "FormGroupoidFromCycles"->{
    Cell[17339, 727, 260, 7, 23, "Index",
      CellTags->"FormGroupoidFromCycles"]},
  "FormMorphoid"->{
    Cell[17602, 736, 192, 7, 23, "Index",
      CellTags->"FormMorphoid"]},
  "FormMorphoidSetup"->{
    Cell[17797, 745, 202, 7, 23, "Index",
      CellTags->"FormMorphoidSetup"]},
  "FormRingoid"->{
    Cell[18002, 754, 178, 7, 23, "Index",
      CellTags->"FormRingoid"]},
  "FormRingoidByTable"->{
    Cell[18183, 763, 206, 7, 23, "Index",
      CellTags->"FormRingoidByTable"]},
  "FromCycles"->{
    Cell[18392, 772, 167, 7, 23, "Index",
      CellTags->"FromCycles"]},
  "Func"->{
    Cell[18562, 781, 181, 7, 23, "Index",
      CellTags->"Func"]},
  "Function arithmetic"->{
    Cell[18746, 790, 211, 7, 23, "Index",
      CellTags->"Function arithmetic"],
    Cell[91286, 4037, 236, 9, 23, "Index",
      CellTags->"Function arithmetic"]},
  "Functions on a Ringoid"->{
    Cell[18960, 799, 217, 7, 23, "Index",
      CellTags->"Functions on a Ringoid"]},
  "FunctionsOver"->{
    Cell[19180, 808, 199, 7, 23, "Index",
      CellTags->"FunctionsOver"]},
  "FuncToRules"->{
    Cell[19382, 817, 195, 7, 23, "Index",
      CellTags->"FuncToRules"]},
  "GaloisFieldQ"->{
    Cell[19580, 826, 185, 7, 23, "Index",
      CellTags->"GaloisFieldQ"]},
  "GaussianIntegerQ"->{
    Cell[19768, 835, 185, 7, 23, "Index",
      CellTags->"GaussianIntegerQ"]},
  "Geissinger, L."->{
    Cell[19956, 844, 193, 7, 23, "Index",
      CellTags->"Geissinger, L."]},
  "GeneralLinear"->{
    Cell[20152, 853, 193, 7, 23, "Index",
      CellTags->"GeneralLinear"]},
  "GeneralLinearGroup"->{
    Cell[20348, 862, 203, 7, 23, "Index",
      CellTags->"GeneralLinearGroup"]},
  "GenerateGroupoid"->{
    Cell[20554, 871, 198, 7, 23, "Index",
      CellTags->"GenerateGroupoid"]},
  "GeneratingSet"->{
    Cell[20755, 880, 205, 7, 23, "Index",
      CellTags->"GeneratingSet"]},
  "GF"->{
    Cell[20963, 889, 165, 7, 23, "Index",
      CellTags->"GF"]},
  " Global variables and options"->{
    Cell[21131, 898, 241, 6, 23, "Index",
      CellTags->" Global variables and options"]},
  "GLQ"->{
    Cell[21375, 906, 179, 7, 23, "Index",
      CellTags->"GLQ"]},
  "Graphics Functions"->{
    Cell[21557, 915, 213, 7, 23, "Index",
      CellTags->"Graphics Functions"]},
  "Graphics Output from Visual Mode"->{
    Cell[21773, 924, 229, 7, 23, "Index",
      CellTags->"Graphics Output from Visual Mode"]},
  "GroupCenter"->{
    Cell[22005, 933, 200, 7, 23, "Index",
      CellTags->"GroupCenter"]},
  "GroupExponent"->{
    Cell[22208, 942, 205, 7, 23, "Index",
      CellTags->"GroupExponent"]},
  "GroupIdentity"->{
    Cell[22416, 951, 195, 7, 23, "Index",
      CellTags->"GroupIdentity"]},
  "GroupInfo"->{
    Cell[22614, 960, 187, 7, 23, "Index",
      CellTags->"GroupInfo"]},
  "GroupInverse"->{
    Cell[22804, 969, 193, 7, 23, "Index",
      CellTags->"GroupInverse"]},
  "Groupoid Formation"->{
    Cell[23000, 978, 194, 7, 23, "Index",
      CellTags->"Groupoid Formation"]},
  "GroupoidName"->{
    Cell[23197, 987, 203, 7, 23, "Index",
      CellTags->"GroupoidName"]},
  "GroupQ"->{
    Cell[23403, 996, 181, 7, 23, "Index",
      CellTags->"GroupQ"]},
  "Groups of permutations"->{
    Cell[23587, 1005, 223, 7, 23, "Index",
      CellTags->"Groups of permutations"]},
  "HasIdentityQ"->{
    Cell[23813, 1014, 209, 7, 23, "Index",
      CellTags->"HasIdentityQ"],
    Cell[24025, 1023, 213, 7, 23, "Index",
      CellTags->"HasIdentityQ"],
    Cell[95156, 4213, 256, 9, 23, "Index",
      CellTags->"HasIdentityQ"],
    Cell[95415, 4224, 217, 9, 23, "Index",
      CellTags->"HasIdentityQ"]},
  "HasInversesQ"->{
    Cell[24241, 1032, 213, 7, 23, "Index",
      CellTags->"HasInversesQ"],
    Cell[95635, 4235, 247, 9, 70, "Index",
      CellTags->"HasInversesQ"],
    Cell[95885, 4246, 217, 9, 70, "Index",
      CellTags->"HasInversesQ"]},
  "HasLeftIdentityQ"->{
    Cell[24457, 1041, 201, 7, 23, "Index",
      CellTags->"HasLeftIdentityQ"]},
  "HasRightIdentityQ"->{
    Cell[24661, 1050, 203, 7, 23, "Index",
      CellTags->"HasRightIdentityQ"]},
  "HasUnityQ"->{
    Cell[24867, 1059, 203, 7, 23, "Index",
      CellTags->"HasUnityQ"]},
  "HasZeroQ"->{
    Cell[25073, 1068, 189, 7, 23, "Index",
      CellTags->"HasZeroQ"],
    Cell[96341, 4268, 241, 9, 70, "Index",
      CellTags->"HasZeroQ"],
    Cell[96585, 4279, 230, 9, 70, "Index",
      CellTags->"HasZeroQ"],
    Cell[96818, 4290, 242, 9, 70, "Index",
      CellTags->"HasZeroQ"]},
  "HomomorphismQ"->{
    Cell[25265, 1077, 181, 7, 23, "Index",
      CellTags->"HomomorphismQ"]},
  "IdealQ"->{
    Cell[25449, 1086, 184, 7, 23, "Index",
      CellTags->"IdealQ"]},
  "Ideals"->{
    Cell[25636, 1095, 184, 7, 23, "Index",
      CellTags->"Ideals"]},
  "IdempotentQ"->{
    Cell[25823, 1104, 205, 7, 23, "Index",
      CellTags->"IdempotentQ"]},
  "Idempotents"->{
    Cell[26031, 1113, 205, 7, 23, "Index",
      CellTags->"Idempotents"]},
  "InducedCanonical"->{
    Cell[26239, 1122, 203, 7, 23, "Index",
      CellTags->"InducedCanonical"]},
  "InducedIsomorphism"->{
    Cell[26445, 1131, 207, 7, 23, "Index",
      CellTags->"InducedIsomorphism"]},
  "Inn"->{
    Cell[26655, 1140, 167, 7, 23, "Index",
      CellTags->"Inn"]},
  "InnerAutomorphism"->{
    Cell[26825, 1149, 195, 7, 23, "Index",
      CellTags->"InnerAutomorphism"]},
  "InnerAutomorphismGroup"->{
    Cell[27023, 1158, 205, 7, 23, "Index",
      CellTags->"InnerAutomorphismGroup"]},
  "IntegerDivisors"->{
    Cell[27231, 1167, 189, 7, 23, "Index",
      CellTags->"IntegerDivisors"]},
  "IntegerLatticeGrid"->{
    Cell[27423, 1176, 189, 7, 23, "Index",
      CellTags->"IntegerLatticeGrid"]},
  "Integers mod n"->{
    Cell[27615, 1185, 236, 7, 23, "Index",
      CellTags->"Integers mod n"]},
  "IntegralDomainQ"->{
    Cell[27854, 1194, 199, 7, 23, "Index",
      CellTags->"IntegralDomainQ"]},
  "InverseImage"->{
    Cell[28056, 1203, 227, 7, 23, "Index",
      CellTags->"InverseImage"]},
  "InverseImages"->{
    Cell[28286, 1212, 229, 7, 23, "Index",
      CellTags->"InverseImages"]},
  "Irreducibility of integer-based polynomials"->{
    Cell[28518, 1221, 279, 7, 23, "Index",
      CellTags->"Irreducibility of integer-based polynomials"]},
  "IrreduciblePolynomial"->{
    Cell[28800, 1230, 203, 7, 23, "Index",
      CellTags->"IrreduciblePolynomial"]},
  "IrreduciblePolyOverZpQ"->{
    Cell[29006, 1239, 205, 7, 23, "Index",
      CellTags->"IrreduciblePolyOverZpQ"]},
  "IsomorphismQ"->{
    Cell[29214, 1248, 179, 7, 23, "Index",
      CellTags->"IsomorphismQ"]},
  "Kernel"->{
    Cell[29396, 1257, 215, 7, 23, "Index",
      CellTags->"Kernel"]},
  "LabCode functions"->{
    Cell[29614, 1266, 239, 7, 23, "Index",
      CellTags->"LabCode functions"]},
  "\"Large\" elements and Visual Mode"->{
    Cell[29856, 1275, 265, 7, 23, "Index",
      CellTags->"\"Large\" elements and Visual Mode"]},
  "LeftIdealQ"->{
    Cell[30124, 1284, 192, 7, 23, "Index",
      CellTags->"LeftIdealQ"]},
  "LeftIdentity"->{
    Cell[30319, 1293, 193, 7, 23, "Index",
      CellTags->"LeftIdentity"]},
  "LeftInverse"->{
    Cell[30515, 1302, 191, 7, 23, "Index",
      CellTags->"LeftInverse"]},
  "LeftInvertibleQ"->{
    Cell[30709, 1311, 199, 7, 23, "Index",
      CellTags->"LeftInvertibleQ"]},
  "Loading all packages"->{
    Cell[30911, 1320, 200, 7, 23, "Index",
      CellTags->"Loading all packages"]},
  "Mat"->{
    Cell[31114, 1329, 165, 7, 23, "Index",
      CellTags->"Mat"]},
  "MatA"->{
    Cell[31282, 1338, 167, 7, 23, "Index",
      CellTags->"MatA"]},
  "MatM"->{
    Cell[31452, 1347, 167, 7, 23, "Index",
      CellTags->"MatM"]},
  "MatricesOver"->{
    Cell[31622, 1356, 183, 7, 23, "Index",
      CellTags->"MatricesOver"]},
  "Matrices over a ringoid"->{
    Cell[31808, 1365, 205, 7, 23, "Index",
      CellTags->"Matrices over a ringoid"]},
  "Matrix arithmetic"->{
    Cell[32016, 1374, 203, 7, 23, "Index",
      CellTags->"Matrix arithmetic"]},
  "Matrix Groupoids"->{
    Cell[32222, 1383, 199, 7, 23, "Index",
      CellTags->"Matrix Groupoids"]},
  "Matrix Inverses"->{
    Cell[32424, 1392, 211, 7, 23, "Index",
      CellTags->"Matrix Inverses"]},
  "MatrixOperation"->{
    Cell[32638, 1401, 225, 7, 23, "Index",
      CellTags->"MatrixOperation"]},
  "MatrixOverQ"->{
    Cell[32866, 1410, 217, 7, 23, "Index",
      CellTags->"MatrixOverQ"]},
  "MatrixPower"->{
    Cell[33086, 1419, 191, 7, 23, "Index",
      CellTags->"MatrixPower"]},
  "Matrix Ringoids"->{
    Cell[33280, 1428, 195, 7, 23, "Index",
      CellTags->"Matrix Ringoids"]},
  "Matrix Sub-extensions"->{
    Cell[33478, 1437, 209, 7, 23, "Index",
      CellTags->"Matrix Sub-extensions"]},
  "MaximalIdealQ"->{
    Cell[33690, 1446, 199, 7, 23, "Index",
      CellTags->"MaximalIdealQ"]},
  "Maximal Ideals"->{
    Cell[33892, 1455, 201, 7, 23, "Index",
      CellTags->"Maximal Ideals"]},
  "MGroupoid"->{
    Cell[34096, 1464, 199, 7, 23, "Index",
      CellTags->"MGroupoid"]},
  "ModpIrreducibilityQ"->{
    Cell[34298, 1473, 231, 7, 23, "Index",
      CellTags->"ModpIrreducibilityQ"]},
  "MonoidQ"->{
    Cell[34532, 1482, 183, 7, 23, "Index",
      CellTags->"MonoidQ"]},
  "Monomial"->{
    Cell[34718, 1491, 197, 7, 23, "Index",
      CellTags->"Monomial"]},
  "MorphismQ"->{
    Cell[34918, 1500, 173, 7, 23, "Index",
      CellTags->"MorphismQ"]},
  "MorphoidComposition"->{
    Cell[35094, 1509, 224, 7, 23, "Index",
      CellTags->"MorphoidComposition"]},
  "MorphoidFunction"->{
    Cell[35321, 1518, 218, 7, 23, "Index",
      CellTags->"MorphoidFunction"]},
  "MorphoidRules"->{
    Cell[35542, 1527, 212, 7, 23, "Index",
      CellTags->"MorphoidRules"]},
  "MultipleOfElement"->{
    Cell[35757, 1536, 217, 7, 23, "Index",
      CellTags->"MultipleOfElement"]},
  "MultiplicativeGroupoid"->{
    Cell[35977, 1545, 225, 7, 23, "Index",
      CellTags->"MultiplicativeGroupoid"]},
  "MultiplicativeToAdditive"->{
    Cell[36205, 1554, 209, 7, 23, "Index",
      CellTags->"MultiplicativeToAdditive"]},
  "MultiplyCycles"->{
    Cell[36417, 1563, 195, 7, 23, "Index",
      CellTags->"MultiplyCycles"]},
  "MultiplyPermutations"->{
    Cell[36615, 1572, 218, 7, 23, "Index",
      CellTags->"MultiplyPermutations"]},
  "Names in a package"->{
    Cell[36836, 1581, 224, 7, 23, "Index",
      CellTags->"Names in a package"]},
  "NextStage"->{
    Cell[37063, 1590, 171, 7, 23, "Index",
      CellTags->"NextStage"]},
  "NilpotentDegree"->{
    Cell[37237, 1599, 213, 7, 23, "Index",
      CellTags->"NilpotentDegree"]},
  "NilpotentQ"->{
    Cell[37453, 1608, 203, 7, 23, "Index",
      CellTags->"NilpotentQ"]},
  "Nilpotents"->{
    Cell[37659, 1617, 203, 7, 23, "Index",
      CellTags->"Nilpotents"]},
  "NonAssociatingTriples"->{
    Cell[37865, 1626, 211, 7, 23, "Index",
      CellTags->"NonAssociatingTriples"]},
  "NonZeroMGroupoid"->{
    Cell[38079, 1635, 213, 7, 23, "Index",
      CellTags->"NonZeroMGroupoid"]},
  "Normalizer"->{
    Cell[38295, 1644, 198, 7, 23, "Index",
      CellTags->"Normalizer"],
    Cell[115193, 5159, 219, 9, 15, "Index",
      CellTags->"Normalizer"]},
  "NormalQ"->{
    Cell[38496, 1653, 179, 7, 23, "Index",
      CellTags->"NormalQ"]},
  "OddPermutationQ"->{
    Cell[38678, 1662, 223, 7, 23, "Index",
      CellTags->"OddPermutationQ"]},
  "Operation-preserving Morphoids"->{
    Cell[38904, 1671, 215, 7, 23, "Index",
      CellTags->"Operation-preserving Morphoids"]},
  "Operations on Cycles"->{
    Cell[39122, 1680, 207, 7, 23, "Index",
      CellTags->"Operations on Cycles"]},
  "Operations on Permutations"->{
    Cell[39332, 1689, 230, 7, 23, "Index",
      CellTags->"Operations on Permutations"]},
  "OperatorSymbol"->{
    Cell[39565, 1698, 207, 7, 23, "Index",
      CellTags->"OperatorSymbol"]},
  "Orbit"->{
    Cell[39775, 1707, 189, 7, 23, "Index",
      CellTags->"Orbit"]},
  "Orbits"->{
    Cell[39967, 1716, 191, 7, 23, "Index",
      CellTags->"Orbits"]},
  "Ordering"->{
    Cell[40161, 1725, 206, 7, 23, "Index",
      CellTags->"Ordering"]},
  "Output"->{
    Cell[40370, 1734, 202, 7, 23, "Index",
      CellTags->"Output"]},
  "Overview of EAAM"->{
    Cell[40575, 1743, 210, 7, 23, "Index",
      CellTags->"Overview of EAAM"]},
  "Parity"->{
    Cell[40788, 1752, 205, 7, 23, "Index",
      CellTags->"Parity"],
    Cell[117712, 5280, 207, 9, 15, "Index",
      CellTags->"Parity"]},
  "Patterns in larger systems"->{
    Cell[40996, 1761, 226, 7, 23, "Index",
      CellTags->"Patterns in larger systems"]},
  "PermutationComposition"->{
    Cell[41225, 1770, 222, 7, 23, "Index",
      CellTags->"PermutationComposition"]},
  "PermutationImage"->{
    Cell[41450, 1779, 211, 7, 23, "Index",
      CellTags->"PermutationImage"]},
  "PermutationInverse"->{
    Cell[41664, 1788, 214, 7, 23, "Index",
      CellTags->"PermutationInverse"]},
  "PermutationMatrix"->{
    Cell[41881, 1797, 212, 7, 23, "Index",
      CellTags->"PermutationMatrix"]},
  "PermutationQ"->{
    Cell[42096, 1806, 214, 7, 23, "Index",
      CellTags->"PermutationQ"]},
  "PermutationToPower"->{
    Cell[42313, 1815, 214, 7, 23, "Index",
      CellTags->"PermutationToPower"]},
  "PlusSymbol"->{
    Cell[42530, 1824, 188, 7, 23, "Index",
      CellTags->"PlusSymbol"]},
  "Polynomial Arithmetic"->{
    Cell[42721, 1833, 219, 7, 23, "Index",
      CellTags->"Polynomial Arithmetic"]},
  "PolynomialDivision"->{
    Cell[42943, 1842, 213, 7, 23, "Index",
      CellTags->"PolynomialDivision"]},
  "PolynomialEvaluation"->{
    Cell[43159, 1851, 233, 7, 23, "Index",
      CellTags->"PolynomialEvaluation"]},
  "PolynomialGCD"->{
    Cell[43395, 1860, 203, 7, 23, "Index",
      CellTags->"PolynomialGCD"]},
  "Polynomial Interpolation"->{
    Cell[43601, 1869, 255, 7, 23, "Index",
      CellTags->"Polynomial Interpolation"]},
  "PolynomialLCM"->{
    Cell[43859, 1878, 203, 7, 23, "Index",
      CellTags->"PolynomialLCM"]},
  "PolynomialQuotient"->{
    Cell[44065, 1887, 213, 7, 23, "Index",
      CellTags->"PolynomialQuotient"]},
  "PolynomialRemainder"->{
    Cell[44281, 1896, 215, 7, 23, "Index",
      CellTags->"PolynomialRemainder"]},
  "PolynomialsOfDegreeN"->{
    Cell[44499, 1905, 221, 7, 23, "Index",
      CellTags->"PolynomialsOfDegreeN"]},
  "Polynomials Over a Ringoid"->{
    Cell[44723, 1914, 225, 7, 23, "Index",
      CellTags->"Polynomials Over a Ringoid"]},
  "PolynomialsUpToDegreeN"->{
    Cell[44951, 1923, 225, 7, 23, "Index",
      CellTags->"PolynomialsUpToDegreeN"]},
  "PolyQ"->{
    Cell[45179, 1932, 191, 7, 23, "Index",
      CellTags->"PolyQ"]},
  "PolyToFunction"->{
    Cell[45373, 1941, 235, 7, 23, "Index",
      CellTags->"PolyToFunction"]},
  "PowerList"->{
    Cell[45611, 1950, 179, 7, 23, "Index",
      CellTags->"PowerList"]},
  "PreservesQ"->{
    Cell[45793, 1959, 175, 7, 23, "Index",
      CellTags->"PreservesQ"]},
  "PreviousStage"->{
    Cell[45971, 1968, 179, 7, 23, "Index",
      CellTags->"PreviousStage"]},
  "PrimeIdealQ"->{
    Cell[46153, 1977, 195, 7, 23, "Index",
      CellTags->"PrimeIdealQ"]},
  "Prime Ideals"->{
    Cell[46351, 1986, 197, 7, 23, "Index",
      CellTags->"Prime Ideals"]},
  "PrimitivePolynomials"->{
    Cell[46551, 1995, 201, 7, 23, "Index",
      CellTags->"PrimitivePolynomials"]},
  "PrincipalIdeal"->{
    Cell[46755, 2004, 201, 7, 23, "Index",
      CellTags->"PrincipalIdeal"]},
  "Principal Ideal generated by a Ringoid element"->{
    Cell[46959, 2013, 265, 7, 23, "Index",
      CellTags->"Principal Ideal generated by a Ringoid element"]},
  "ProbableGroupQ"->{
    Cell[47227, 2022, 197, 7, 23, "Index",
      CellTags->"ProbableGroupQ"]},
  "ProbableMorphismQ"->{
    Cell[47427, 2031, 189, 7, 23, "Index",
      CellTags->"ProbableMorphismQ"]},
  "ProbableRingQ"->{
    Cell[47619, 2040, 181, 7, 23, "Index",
      CellTags->"ProbableRingQ"]},
  "ProperSubsetQ"->{
    Cell[47803, 2049, 197, 7, 23, "Index",
      CellTags->"ProperSubsetQ"]},
  "QuaternionGroup"->{
    Cell[48003, 2058, 195, 7, 23, "Index",
      CellTags->"QuaternionGroup"]},
  "QuotientGroup"->{
    Cell[48201, 2067, 191, 7, 23, "Index",
      CellTags->"QuotientGroup"]},
  "Quotient Groups"->{
    Cell[48395, 2076, 195, 7, 23, "Index",
      CellTags->"Quotient Groups"]},
  "QuotientRing"->{
    Cell[48593, 2085, 187, 7, 23, "Index",
      CellTags->"QuotientRing"],
    Cell[121132, 5434, 258, 9, 15, "Index",
      CellTags->"QuotientRing"]},
  "Quotient Rings"->{
    Cell[48783, 2094, 191, 7, 23, "Index",
      CellTags->"Quotient Rings"]},
  "Quotient rings of polynomials"->{
    Cell[48977, 2103, 243, 7, 23, "Index",
      CellTags->"Quotient rings of polynomials"]},
  "RandomAssociativeQ"->{
    Cell[49223, 2112, 205, 7, 23, "Index",
      CellTags->"RandomAssociativeQ"],
    Cell[121393, 5445, 258, 9, 15, "Index",
      CellTags->"RandomAssociativeQ"],
    Cell[121654, 5456, 276, 9, 15, "Index",
      CellTags->"RandomAssociativeQ"]},
  "RandomGroupoid"->{
    Cell[49431, 2121, 244, 7, 23, "Index",
      CellTags->"RandomGroupoid"]},
  "Randomize"->{
    Cell[49678, 2130, 189, 7, 23, "Index",
      CellTags->"Randomize"]},
  "RandomMatrix"->{
    Cell[49870, 2139, 197, 7, 23, "Index",
      CellTags->"RandomMatrix"]},
  "RandomPermutation"->{
    Cell[50070, 2148, 224, 7, 23, "Index",
      CellTags->"RandomPermutation"]},
  "Random polynomials"->{
    Cell[50297, 2157, 207, 7, 23, "Index",
      CellTags->"Random polynomials"]},
  "RationalRootCandidates"->{
    Cell[50507, 2166, 237, 7, 23, "Index",
      CellTags->"RationalRootCandidates"]},
  "RationalRootTheorem"->{
    Cell[50747, 2175, 231, 7, 23, "Index",
      CellTags->"RationalRootTheorem"]},
  "ReorderGroupoid"->{
    Cell[50981, 2184, 209, 7, 23, "Index",
      CellTags->"ReorderGroupoid"]},
  "RightIdealQ"->{
    Cell[51193, 2193, 194, 7, 23, "Index",
      CellTags->"RightIdealQ"]},
  "RightIdentity"->{
    Cell[51390, 2202, 195, 7, 23, "Index",
      CellTags->"RightIdentity"]},
  "RightInverse"->{
    Cell[51588, 2211, 193, 7, 23, "Index",
      CellTags->"RightInverse"]},
  "RightInvertibleQ"->{
    Cell[51784, 2220, 201, 7, 23, "Index",
      CellTags->"RightInvertibleQ"]},
  "RingInfo"->{
    Cell[51988, 2229, 171, 7, 23, "Index",
      CellTags->"RingInfo"]},
  "RingoidName"->{
    Cell[52162, 2238, 190, 7, 23, "Index",
      CellTags->"RingoidName"],
    Cell[128341, 5764, 219, 9, 15, "Index",
      CellTags->"RingoidName"]},
  "RingQ"->{
    Cell[52355, 2247, 165, 7, 23, "Index",
      CellTags->"RingQ"]},
  "SamePermutationQ"->{
    Cell[52523, 2256, 225, 7, 23, "Index",
      CellTags->"SamePermutationQ"]},
  "SameSetQ"->{
    Cell[52751, 2265, 187, 7, 23, "Index",
      CellTags->"SameSetQ"]},
  "SemiGroupQ"->{
    Cell[52941, 2274, 189, 7, 23, "Index",
      CellTags->"SemiGroupQ"]},
  "ShowCircle"->{
    Cell[53133, 2283, 197, 7, 23, "Index",
      CellTags->"ShowCircle"]},
  "ShowColoredPermutation"->{
    Cell[53333, 2292, 249, 7, 23, "Index",
      CellTags->"ShowColoredPermutation"]},
  "ShowFigure"->{
    Cell[53585, 2301, 197, 7, 23, "Index",
      CellTags->"ShowFigure"]},
  "ShowGroupOrders"->{
    Cell[53785, 2310, 235, 7, 23, "Index",
      CellTags->"ShowGroupOrders"]},
  "ShowPermutation"->{
    Cell[54023, 2319, 207, 7, 23, "Index",
      CellTags->"ShowPermutation"]},
  "SizeOfMatrices"->{
    Cell[54233, 2328, 223, 7, 23, "Index",
      CellTags->"SizeOfMatrices"]},
  "SLQ"->{
    Cell[54459, 2337, 179, 7, 23, "Index",
      CellTags->"SLQ"]},
  "Solution of polynomial equations"->{
    Cell[54641, 2346, 257, 7, 23, "Index",
      CellTags->"Solution of polynomial equations"]},
  "SortGroupoid"->{
    Cell[54901, 2355, 203, 7, 23, "Index",
      CellTags->"SortGroupoid"]},
  "SpecialLinear"->{
    Cell[55107, 2364, 193, 7, 23, "Index",
      CellTags->"SpecialLinear"]},
  "SpecialLinearGroup"->{
    Cell[55303, 2373, 203, 7, 23, "Index",
      CellTags->"SpecialLinearGroup"]},
  "Stabilizer"->{
    Cell[55509, 2382, 199, 7, 23, "Index",
      CellTags->"Stabilizer"]},
  "Stabilizers"->{
    Cell[55711, 2391, 201, 7, 23, "Index",
      CellTags->"Stabilizers"]},
  "Structure of Groupoids"->{
    Cell[55915, 2400, 223, 7, 23, "Index",
      CellTags->"Structure of Groupoids"]},
  "Structure of Morphoids"->{
    Cell[56141, 2409, 230, 7, 23, "Index",
      CellTags->"Structure of Morphoids"]},
  "SubgroupClosure"->{
    Cell[56374, 2418, 182, 7, 23, "Index",
      CellTags->"SubgroupClosure"]},
  "SubgroupConjugate"->{
    Cell[56559, 2427, 212, 7, 23, "Index",
      CellTags->"SubgroupConjugate"]},
  "SubgroupGenerated"->{
    Cell[56774, 2436, 187, 7, 23, "Index",
      CellTags->"SubgroupGenerated"],
    Cell[135077, 6083, 213, 9, 15, "Index",
      CellTags->"SubgroupGenerated"]},
  "SubgroupIntersection"->{
    Cell[56964, 2445, 193, 7, 23, "Index",
      CellTags->"SubgroupIntersection"]},
  "SubgroupJoin"->{
    Cell[57160, 2454, 177, 7, 23, "Index",
      CellTags->"SubgroupJoin"]},
  "Subgroupoid"->{
    Cell[57340, 2463, 174, 7, 23, "Index",
      CellTags->"Subgroupoid"]},
  "SubgroupProduct"->{
    Cell[57517, 2472, 183, 7, 23, "Index",
      CellTags->"SubgroupProduct"]},
  "SubgroupQ"->{
    Cell[57703, 2481, 170, 7, 23, "Index",
      CellTags->"SubgroupQ"],
    Cell[135293, 6094, 202, 9, 15, "Index",
      CellTags->"SubgroupQ"],
    Cell[135498, 6105, 196, 9, 15, "Index",
      CellTags->"SubgroupQ"]},
  "Subgroups"->{
    Cell[57876, 2490, 171, 7, 23, "Index",
      CellTags->"Subgroups"],
    Cell[135697, 6116, 194, 9, 15, "Index",
      CellTags->"Subgroups"]},
  "SubgroupUnion"->{
    Cell[58050, 2499, 179, 7, 23, "Index",
      CellTags->"SubgroupUnion"]},
  "SubringQ"->{
    Cell[58232, 2508, 188, 7, 23, "Index",
      CellTags->"SubringQ"]},
  "Subrings"->{
    Cell[58423, 2517, 188, 7, 23, "Index",
      CellTags->"Subrings"]},
  "SubsetQ"->{
    Cell[58614, 2526, 185, 7, 23, "Index",
      CellTags->"SubsetQ"]},
  "SwitchStructureTo"->{
    Cell[58802, 2535, 227, 7, 23, "Index",
      CellTags->"SwitchStructureTo"]},
  "TableOfPowers"->{
    Cell[59032, 2544, 187, 7, 23, "Index",
      CellTags->"TableOfPowers"]},
  "\"Taker\" family"->{
    Cell[59222, 2553, 212, 7, 23, "Index",
      CellTags->"\"Taker\" family"]},
  "TextCayley"->{
    Cell[59437, 2562, 181, 7, 23, "Index",
      CellTags->"TextCayley"]},
  "TimesSymbol"->{
    Cell[59621, 2571, 190, 7, 23, "Index",
      CellTags->"TimesSymbol"]},
  "ToCycles"->{
    Cell[59814, 2580, 163, 7, 23, "Index",
      CellTags->"ToCycles"]},
  "ToOrdinaryPolynomial"->{
    Cell[59980, 2589, 221, 7, 23, "Index",
      CellTags->"ToOrdinaryPolynomial"]},
  "ToPermutation"->{
    Cell[60204, 2598, 210, 7, 23, "Index",
      CellTags->"ToPermutation"]},
  "ToTranspositions"->{
    Cell[60417, 2607, 225, 7, 23, "Index",
      CellTags->"ToTranspositions"]},
  "Transpositions"->{
    Cell[60645, 2616, 221, 7, 23, "Index",
      CellTags->"Transpositions"]},
  "UnionNoSort"->{
    Cell[60869, 2625, 193, 7, 23, "Index",
      CellTags->"UnionNoSort"]},
  "Units"->{
    Cell[61065, 2634, 195, 7, 23, "Index",
      CellTags->"Units"]},
  "ValuesHavingGivenNorm"->{
    Cell[61263, 2643, 221, 7, 23, "Index",
      CellTags->"ValuesHavingGivenNorm"]},
  "VisualizeMorphoid"->{
    Cell[61487, 2652, 211, 7, 23, "Index",
      CellTags->"VisualizeMorphoid"]},
  "VisualTextShown"->{
    Cell[61701, 2661, 220, 7, 23, "Index",
      CellTags->"VisualTextShown"]},
  "web page"->{
    Cell[61924, 2670, 212, 7, 23, "Index",
      CellTags->"web page"]},
  "Working in Z[Sqrt[d]]"->{
    Cell[62139, 2679, 207, 7, 23, "Index",
      CellTags->"Working in Z[Sqrt[d]]"]},
  "ZdAssociatesQ"->{
    Cell[62349, 2688, 191, 7, 23, "Index",
      CellTags->"ZdAssociatesQ"]},
  "ZdCombineAssociates"->{
    Cell[62543, 2697, 197, 7, 23, "Index",
      CellTags->"ZdCombineAssociates"]},
  "ZdConjugate"->{
    Cell[62743, 2706, 187, 7, 23, "Index",
      CellTags->"ZdConjugate"]},
  "ZdDivide"->{
    Cell[62933, 2715, 181, 7, 23, "Index",
      CellTags->"ZdDivide"]},
  "ZdDividesQ"->{
    Cell[63117, 2724, 179, 7, 23, "Index",
      CellTags->"ZdDividesQ"]},
  "ZdDivisors"->{
    Cell[63299, 2733, 179, 7, 23, "Index",
      CellTags->"ZdDivisors"]},
  "ZdIrreducibleQ"->{
    Cell[63481, 2742, 193, 7, 23, "Index",
      CellTags->"ZdIrreducibleQ"]},
  "ZdNorm"->{
    Cell[63677, 2751, 191, 7, 23, "Index",
      CellTags->"ZdNorm"]},
  "ZdPossibleNormQ"->{
    Cell[63871, 2760, 209, 7, 23, "Index",
      CellTags->"ZdPossibleNormQ"]},
  "ZdPossibleNorms"->{
    Cell[64083, 2769, 209, 7, 23, "Index",
      CellTags->"ZdPossibleNorms"]},
  "ZdQ"->{
    Cell[64295, 2778, 171, 7, 23, "Index",
      CellTags->"ZdQ"]},
  "ZdUnitQ"->{
    Cell[64469, 2787, 179, 7, 23, "Index",
      CellTags->"ZdUnitQ"]},
  "ZeroDivisorQ"->{
    Cell[64651, 2796, 209, 7, 23, "Index",
      CellTags->"ZeroDivisorQ"],
    Cell[145704, 6589, 249, 9, 15, "Index",
      CellTags->"ZeroDivisorQ"],
    Cell[145956, 6600, 238, 9, 15, "Index",
      CellTags->"ZeroDivisorQ"]},
  "ZeroDivisors"->{
    Cell[64863, 2805, 209, 7, 23, "Index",
      CellTags->"ZeroDivisors"]},
  "StyleBox[Exploring Small Groups, FontSlant -> Italic]"->{
    Cell[65075, 2814, 275, 8, 24, "Index",
      CellTags->"StyleBox[Exploring Small Groups, FontSlant -> Italic]"]},
  "@"->{
    Cell[65353, 2824, 216, 9, 23, "Index",
      CellTags->"@"]},
  "A"->{
    Cell[65572, 2835, 218, 9, 23, "Index",
      CellTags->"A"]},
  "Addition"->{
    Cell[65793, 2846, 237, 9, 23, "Index",
      CellTags->"Addition"],
    Cell[66033, 2857, 241, 9, 23, "Index",
      CellTags->"Addition"],
    Cell[66277, 2868, 221, 9, 23, "Index",
      CellTags->"Addition"],
    Cell[66501, 2879, 233, 9, 23, "Index",
      CellTags->"Addition"],
    Cell[66737, 2890, 206, 9, 23, "Index",
      CellTags->"Addition"]},
  "Adjoin"->{
    Cell[66946, 2901, 205, 9, 23, "Index",
      CellTags->"Adjoin"]},
  "All"->{
    Cell[67154, 2912, 228, 9, 23, "Index",
      CellTags->"All"]},
  "Alternating"->{
    Cell[67385, 2923, 238, 9, 23, "Index",
      CellTags->"Alternating"]},
  "AlternatingGroup"->{
    Cell[67626, 2934, 248, 9, 23, "Index",
      CellTags->"AlternatingGroup"]},
  "Argument flexibility"->{
    Cell[67877, 2945, 233, 9, 23, "Index",
      CellTags->"Argument flexibility"]},
  "AssociativeQ"->{
    Cell[68113, 2956, 247, 9, 23, "Index",
      CellTags->"AssociativeQ"],
    Cell[68363, 2967, 246, 9, 23, "Index",
      CellTags->"AssociativeQ"],
    Cell[68612, 2978, 264, 9, 23, "Index",
      CellTags->"AssociativeQ"],
    Cell[68879, 2989, 217, 9, 23, "Index",
      CellTags->"AssociativeQ"],
    Cell[69099, 3000, 217, 9, 23, "Index",
      CellTags->"AssociativeQ"]},
  "BaseRing"->{
    Cell[69319, 3011, 237, 9, 23, "Index",
      CellTags->"BaseRing"],
    Cell[69559, 3022, 233, 9, 23, "Index",
      CellTags->"BaseRing"]},
  "BooleanRing"->{
    Cell[69795, 3033, 215, 9, 23, "Index",
      CellTags->"BooleanRing"]},
  "Canonical Decomposition"->{
    Cell[70013, 3044, 244, 9, 23, "Index",
      CellTags->"Canonical Decomposition"]},
  "CayleyForm"->{
    Cell[70260, 3055, 222, 9, 23, "Index",
      CellTags->"CayleyForm"],
    Cell[70485, 3066, 220, 9, 23, "Index",
      CellTags->"CayleyForm"],
    Cell[70708, 3077, 217, 9, 23, "Index",
      CellTags->"CayleyForm"]},
  "Cayley Tables"->{
    Cell[71606, 3121, 213, 9, 23, "Index",
      CellTags->"Cayley Tables"],
    Cell[71822, 3132, 222, 9, 23, "Index",
      CellTags->"Cayley Tables"]},
  "CayleyTables"->{
    Cell[72047, 3143, 224, 9, 23, "Index",
      CellTags->"CayleyTables"]},
  "Center of a Group"->{
    Cell[72274, 3154, 233, 9, 23, "Index",
      CellTags->"Center of a Group"]},
  "Centralizer of an element or subgroup"->{
    Cell[72510, 3165, 273, 9, 23, "Index",
      CellTags->"Centralizer of an element or subgroup"]},
  "Changing Default Values in a Session"->{
    Cell[72786, 3176, 272, 9, 23, "Index",
      CellTags->"Changing Default Values in a Session"]},
  "Characteristic"->{
    Cell[73061, 3187, 237, 9, 23, "Index",
      CellTags->"Characteristic"]},
  "ClosedQ"->{
    Cell[73301, 3198, 230, 9, 23, "Index",
      CellTags->"ClosedQ"],
    Cell[73534, 3209, 237, 9, 23, "Index",
      CellTags->"ClosedQ"],
    Cell[73774, 3220, 254, 9, 23, "Index",
      CellTags->"ClosedQ"],
    Cell[74031, 3231, 221, 9, 23, "Index",
      CellTags->"ClosedQ"],
    Cell[74255, 3242, 249, 9, 23, "Index",
      CellTags->"ClosedQ"]},
  "Closure of subsets"->{
    Cell[74507, 3253, 233, 9, 23, "Index",
      CellTags->"Closure of subsets"]},
  "Codomain"->{
    Cell[74743, 3264, 229, 9, 23, "Index",
      CellTags->"Codomain"]},
  "Coefficient"->{
    Cell[74975, 3275, 259, 9, 23, "Index",
      CellTags->"Coefficient"]},
  "CoefficientList"->{
    Cell[75237, 3286, 267, 9, 23, "Index",
      CellTags->"CoefficientList"]},
  "ColorCodomain"->{
    Cell[75507, 3297, 250, 9, 23, "Index",
      CellTags->"ColorCodomain"]},
  "ColorDomain"->{
    Cell[75760, 3308, 246, 9, 23, "Index",
      CellTags->"ColorDomain"]},
  "Combine"->{
    Cell[76009, 3319, 223, 9, 23, "Index",
      CellTags->"Combine"]},
  "CommutativeQ"->{
    Cell[76235, 3330, 246, 9, 23, "Index",
      CellTags->"CommutativeQ"],
    Cell[76484, 3341, 239, 9, 23, "Index",
      CellTags->"CommutativeQ"],
    Cell[76726, 3352, 264, 9, 23, "Index",
      CellTags->"CommutativeQ"]},
  "Commutator"->{
    Cell[76993, 3363, 225, 9, 23, "Index",
      CellTags->"Commutator"]},
  "Commutators"->{
    Cell[77221, 3374, 227, 9, 23, "Index",
      CellTags->"Commutators"]},
  "Conjugacy Class"->{
    Cell[77451, 3385, 229, 9, 23, "Index",
      CellTags->"Conjugacy Class"]},
  "Cosets"->{
    Cell[77683, 3396, 218, 9, 23, "Index",
      CellTags->"Cosets"]},
  "CosetToList"->{
    Cell[77904, 3407, 240, 9, 23, "Index",
      CellTags->"CosetToList"],
    Cell[78147, 3418, 221, 9, 23, "Index",
      CellTags->"CosetToList"]},
  "CycleAs"->{
    Cell[78371, 3429, 199, 9, 23, "Index",
      CellTags->"CycleAs"]},
  "Cyclic"->{
    Cell[78573, 3440, 236, 9, 23, "Index",
      CellTags->"Cyclic"]},
  "CyclicGroup"->{
    Cell[78812, 3451, 246, 9, 23, "Index",
      CellTags->"CyclicGroup"]},
  "D"->{
    Cell[79061, 3462, 213, 9, 23, "Index",
      CellTags->"D"]},
  "Degree"->{
    Cell[79532, 3484, 249, 9, 23, "Index",
      CellTags->"Degree"]},
  "Det"->{
    Cell[79784, 3495, 211, 9, 23, "Index",
      CellTags->"Det"]},
  "Diag"->{
    Cell[80476, 3528, 214, 9, 23, "Index",
      CellTags->"Diag"],
    Cell[80693, 3539, 230, 9, 23, "Index",
      CellTags->"Diag"]},
  "Dihedral"->{
    Cell[80926, 3550, 240, 9, 23, "Index",
      CellTags->"Dihedral"]},
  "DihedralGroup"->{
    Cell[81169, 3561, 250, 9, 23, "Index",
      CellTags->"DihedralGroup"]},
  "DirectProduct"->{
    Cell[81422, 3572, 224, 9, 23, "Index",
      CellTags->"DirectProduct"],
    Cell[81649, 3583, 226, 9, 23, "Index",
      CellTags->"DirectProduct"]},
  "Direct Products"->{
    Cell[81878, 3594, 220, 9, 23, "Index",
      CellTags->"Direct Products"],
    Cell[82101, 3605, 219, 9, 23, "Index",
      CellTags->"Direct Products"]},
  "DirectSum"->{
    Cell[82323, 3616, 216, 9, 23, "Index",
      CellTags->"DirectSum"],
    Cell[82542, 3627, 218, 9, 23, "Index",
      CellTags->"DirectSum"]},
  "Distributive Property"->{
    Cell[82763, 3638, 242, 9, 23, "Index",
      CellTags->"Distributive Property"]},
  "DistributiveQ"->{
    Cell[83008, 3649, 239, 9, 23, "Index",
      CellTags->"DistributiveQ"]},
  "DividesQ"->{
    Cell[83250, 3660, 213, 9, 23, "Index",
      CellTags->"DividesQ"],
    Cell[83466, 3671, 200, 9, 23, "Index",
      CellTags->"DividesQ"]},
  "Divisibility"->{
    Cell[83669, 3682, 237, 9, 23, "Index",
      CellTags->"Divisibility"]},
  "DivisorsComplete"->{
    Cell[83909, 3693, 241, 9, 23, "Index",
      CellTags->"DivisorsComplete"]},
  "Domain"->{
    Cell[84153, 3704, 230, 9, 23, "Index",
      CellTags->"Domain"],
    Cell[84386, 3715, 212, 9, 23, "Index",
      CellTags->"Domain"],
    Cell[84601, 3726, 225, 9, 23, "Index",
      CellTags->"Domain"]},
  "Dot"->{
    Cell[84829, 3737, 211, 9, 23, "Index",
      CellTags->"Dot"]},
  "ElementQ"->{
    Cell[85043, 3748, 229, 9, 23, "Index",
      CellTags->"ElementQ"],
    Cell[85275, 3759, 241, 9, 23, "Index",
      CellTags->"ElementQ"],
    Cell[85519, 3770, 225, 9, 23, "Index",
      CellTags->"ElementQ"],
    Cell[85747, 3781, 233, 9, 23, "Index",
      CellTags->"ElementQ"],
    Cell[85983, 3792, 220, 9, 23, "Index",
      CellTags->"ElementQ"]},
  "Elements"->{
    Cell[86206, 3803, 229, 9, 23, "Index",
      CellTags->"Elements"],
    Cell[86438, 3814, 216, 9, 23, "Index",
      CellTags->"Elements"]},
  "ElementsQ"->{
    Cell[86657, 3825, 231, 9, 23, "Index",
      CellTags->"ElementsQ"],
    Cell[86891, 3836, 222, 9, 23, "Index",
      CellTags->"ElementsQ"]},
  "ElementToCoset"->{
    Cell[87116, 3847, 249, 9, 23, "Index",
      CellTags->"ElementToCoset"]},
  "Equal"->{
    Cell[87618, 3869, 247, 9, 23, "Index",
      CellTags->"Equal"]},
  "Exponent"->{
    Cell[87868, 3880, 253, 9, 23, "Index",
      CellTags->"Exponent"]},
  "Extension Ringoids"->{
    Cell[88124, 3891, 238, 9, 23, "Index",
      CellTags->"Extension Ringoids"]},
  "{Extensions of standard , StyleBox[Mathematica, FontSlant -> Italic],  \
polynomial functions}"->{
    Cell[88365, 3902, 396, 12, 38, "Index",
      CellTags->
      "{Extensions of standard , StyleBox[Mathematica, FontSlant -> Italic],  \
polynomial functions}"]},
  "ExtensionType"->{
    Cell[88764, 3916, 243, 9, 23, "Index",
      CellTags->"ExtensionType"]},
  "FirstTaker"->{
    Cell[89010, 3927, 236, 9, 23, "Index",
      CellTags->"FirstTaker"]},
  "FlexibleEntering"->{
    Cell[89249, 3938, 239, 9, 23, "Index",
      CellTags->"FlexibleEntering"]},
  "Form"->{
    Cell[89491, 3949, 233, 9, 23, "Index",
      CellTags->"Form"],
    Cell[89727, 3960, 216, 9, 23, "Index",
      CellTags->"Form"],
    Cell[89946, 3971, 213, 9, 23, "Index",
      CellTags->"Form"]},
  "FormatElements"->{
    Cell[90162, 3982, 228, 9, 23, "Index",
      CellTags->"FormatElements"],
    Cell[90393, 3993, 225, 9, 23, "Index",
      CellTags->"FormatElements"]},
  "FormatOperator"->{
    Cell[90621, 4004, 228, 9, 23, "Index",
      CellTags->"FormatOperator"],
    Cell[90852, 4015, 225, 9, 23, "Index",
      CellTags->"FormatOperator"]},
  "Galois Fields"->{
    Cell[91525, 4048, 210, 9, 23, "Index",
      CellTags->"Galois Fields"]},
  "GaussianIntegers"->{
    Cell[91738, 4059, 275, 9, 23, "Index",
      CellTags->"GaussianIntegers"]},
  "GaussianIntegersAdditive"->{
    Cell[92016, 4070, 293, 9, 37, "Index",
      CellTags->"GaussianIntegersAdditive"]},
  "GaussianIntegersMultiplicative"->{
    Cell[92312, 4081, 304, 9, 37, "Index",
      CellTags->"GaussianIntegersMultiplicative"]},
  "GaussianUnits"->{
    Cell[92619, 4092, 233, 9, 23, "Index",
      CellTags->"GaussianUnits"]},
  "Generators"->{
    Cell[92855, 4103, 220, 9, 23, "Index",
      CellTags->"Generators"]},
  "GL"->{
    Cell[93078, 4114, 201, 9, 23, "Index",
      CellTags->"GL"],
    Cell[93282, 4125, 210, 9, 23, "Index",
      CellTags->"GL"],
    Cell[93495, 4136, 226, 9, 23, "Index",
      CellTags->"GL"]},
  "Greatest Common Factor"->{
    Cell[93724, 4147, 253, 9, 23, "Index",
      CellTags->"Greatest Common Factor"]},
  "Groupoid"->{
    Cell[93980, 4158, 217, 9, 23, "Index",
      CellTags->"Groupoid"]},
  "GroupoidDescription"->{
    Cell[94200, 4169, 238, 9, 23, "Index",
      CellTags->"GroupoidDescription"]},
  "Groupoids"->{
    Cell[94441, 4180, 234, 9, 23, "Index",
      CellTags->"Groupoids"],
    Cell[94678, 4191, 220, 9, 23, "Index",
      CellTags->"Groupoids"]},
  "Group Properties"->{
    Cell[94901, 4202, 252, 9, 23, "Index",
      CellTags->"Group Properties"]},
  "HasNegativeQ"->{
    Cell[96105, 4257, 233, 9, 70, "Index",
      CellTags->"HasNegativeQ"]},
  "HeadingsColored"->{
    Cell[97063, 4301, 232, 9, 70, "Index",
      CellTags->"HeadingsColored"]},
  "Identity"->{
    Cell[97298, 4312, 209, 9, 70, "Index",
      CellTags->"Identity"]},
  "IdentityMatrix"->{
    Cell[97510, 4323, 247, 9, 70, "Index",
      CellTags->"IdentityMatrix"]},
  "Image"->{
    Cell[97760, 4334, 240, 9, 70, "Index",
      CellTags->"Image"]},
  "Indeterminate"->{
    Cell[98003, 4345, 233, 9, 70, "Index",
      CellTags->"Indeterminate"],
    Cell[98239, 4356, 253, 9, 70, "Index",
      CellTags->"Indeterminate"]},
  "Index"->{
    Cell[98495, 4367, 202, 9, 70, "Index",
      CellTags->"Index"]},
  "IndexLimit"->{
    Cell[98700, 4378, 238, 9, 70, "Index",
      CellTags->"IndexLimit"]},
  "InjectiveQ"->{
    Cell[98941, 4389, 212, 9, 70, "Index",
      CellTags->"InjectiveQ"]},
  "IntegerUnits"->{
    Cell[99156, 4400, 231, 9, 70, "Index",
      CellTags->"IntegerUnits"]},
  "Internal Form"->{
    Cell[99390, 4411, 228, 9, 70, "Index",
      CellTags->"Internal Form"]},
  "InterpolatingPolynomial"->{
    Cell[99621, 4422, 277, 9, 70, "Index",
      CellTags->"InterpolatingPolynomial"]},
  "Inverse"->{
    Cell[99901, 4433, 219, 9, 70, "Index",
      CellTags->"Inverse"],
    Cell[100123, 4444, 207, 9, 70, "Index",
      CellTags->"Inverse"]},
  "Inverses"->{
    Cell[100333, 4455, 226, 9, 70, "Index",
      CellTags->"Inverses"],
    Cell[100562, 4466, 221, 9, 70, "Index",
      CellTags->"Inverses"],
    Cell[100786, 4477, 256, 9, 70, "Index",
      CellTags->"Inverses"],
    Cell[101045, 4488, 217, 9, 70, "Index",
      CellTags->"Inverses"]},
  "InvertibleQ"->{
    Cell[101265, 4499, 244, 9, 70, "Index",
      CellTags->"InvertibleQ"],
    Cell[101512, 4510, 262, 9, 70, "Index",
      CellTags->"InvertibleQ"]},
  "IsAGroup"->{
    Cell[101777, 4521, 216, 9, 70, "Index",
      CellTags->"IsAGroup"]},
  "IsARing"->{
    Cell[101996, 4532, 211, 9, 70, "Index",
      CellTags->"IsARing"]},
  "JoinDivisors"->{
    Cell[102210, 4543, 242, 9, 70, "Index",
      CellTags->"JoinDivisors"]},
  "KeyForm"->{
    Cell[102455, 4554, 216, 9, 70, "Index",
      CellTags->"KeyForm"],
    Cell[102674, 4565, 214, 9, 70, "Index",
      CellTags->"KeyForm"],
    Cell[102891, 4576, 211, 9, 70, "Index",
      CellTags->"KeyForm"]},
  "Klein4"->{
    Cell[103105, 4587, 203, 9, 70, "Index",
      CellTags->"Klein4"]},
  "LatticeRing"->{
    Cell[103311, 4598, 219, 9, 15, "Index",
      CellTags->"LatticeRing"]},
  "Least Common Multiple"->{
    Cell[103533, 4609, 251, 9, 15, "Index",
      CellTags->"Least Common Multiple"]},
  "LeftCoset"->{
    Cell[103787, 4620, 217, 9, 15, "Index",
      CellTags->"LeftCoset"],
    Cell[104007, 4631, 210, 9, 15, "Index",
      CellTags->"LeftCoset"]},
  "LeftCosets"->{
    Cell[104220, 4642, 219, 9, 15, "Index",
      CellTags->"LeftCosets"],
    Cell[104442, 4653, 212, 9, 15, "Index",
      CellTags->"LeftCosets"]},
  "LeftDistributiveQ"->{
    Cell[104657, 4664, 247, 9, 15, "Index",
      CellTags->"LeftDistributiveQ"]},
  "ListDensityPlot"->{
    Cell[104907, 4675, 250, 9, 15, "Index",
      CellTags->"ListDensityPlot"]},
  "Lists"->{
    Cell[105160, 4686, 221, 9, 15, "Index",
      CellTags->"Lists"]},
  "LowerDegreeOK"->{
    Cell[105384, 4697, 247, 9, 15, "Index",
      CellTags->"LowerDegreeOK"]},
  "LT"->{
    Cell[105634, 4708, 210, 9, 15, "Index",
      CellTags->"LT"],
    Cell[105847, 4719, 226, 9, 15, "Index",
      CellTags->"LT"]},
  "LTD"->{
    Cell[106076, 4730, 212, 9, 15, "Index",
      CellTags->"LTD"],
    Cell[106291, 4741, 228, 9, 15, "Index",
      CellTags->"LTD"]},
  "Matrices"->{
    Cell[106522, 4752, 213, 9, 15, "Index",
      CellTags->"Matrices"]},
  "Matrix Extensions"->{
    Cell[106738, 4763, 241, 9, 15, "Index",
      CellTags->"Matrix Extensions"]},
  "MatrixType"->{
    Cell[106982, 4774, 235, 9, 15, "Index",
      CellTags->"MatrixType"]},
  "Matrix Types"->{
    Cell[107220, 4785, 218, 9, 15, "Index",
      CellTags->"Matrix Types"]},
  "MaxElementsToList"->{
    Cell[107441, 4796, 234, 9, 15, "Index",
      CellTags->"MaxElementsToList"],
    Cell[107678, 4807, 231, 9, 15, "Index",
      CellTags->"MaxElementsToList"]},
  "MaxTaker"->{
    Cell[107912, 4818, 232, 9, 15, "Index",
      CellTags->"MaxTaker"]},
  "MeetDivisors"->{
    Cell[108147, 4829, 242, 9, 15, "Index",
      CellTags->"MeetDivisors"]},
  "MinTaker"->{
    Cell[108392, 4840, 232, 9, 15, "Index",
      CellTags->"MinTaker"]},
  "MixedDivisors"->{
    Cell[108627, 4851, 244, 9, 15, "Index",
      CellTags->"MixedDivisors"]},
  "Mode"->{
    Cell[108874, 4862, 234, 9, 15, "Index",
      CellTags->"Mode"],
    Cell[109111, 4873, 236, 9, 15, "Index",
      CellTags->"Mode"],
    Cell[109350, 4884, 201, 9, 15, "Index",
      CellTags->"Mode"]},
  "ModulusPolynomial"->{
    Cell[109554, 4895, 262, 9, 15, "Index",
      CellTags->"ModulusPolynomial"]},
  "Monic"->{
    Cell[109819, 4906, 231, 9, 15, "Index",
      CellTags->"Monic"]},
  "Morphoid"->{
    Cell[110053, 4917, 218, 9, 15, "Index",
      CellTags->"Morphoid"]},
  "Morphoids"->{
    Cell[110274, 4928, 197, 9, 15, "Index",
      CellTags->"Morphoids"],
    Cell[110474, 4939, 209, 9, 15, "Index",
      CellTags->"Morphoids"],
    Cell[110686, 4950, 197, 9, 15, "Index",
      CellTags->"Morphoids"],
    Cell[110886, 4961, 227, 9, 15, "Index",
      CellTags->"Morphoids"],
    Cell[111116, 4972, 222, 9, 15, "Index",
      CellTags->"Morphoids"]},
  "Multiplication"->{
    Cell[111341, 4983, 249, 9, 15, "Index",
      CellTags->"Multiplication"],
    Cell[111593, 4994, 253, 9, 15, "Index",
      CellTags->"Multiplication"],
    Cell[111849, 5005, 233, 9, 15, "Index",
      CellTags->"Multiplication"],
    Cell[112085, 5016, 245, 9, 15, "Index",
      CellTags->"Multiplication"],
    Cell[112333, 5027, 218, 9, 15, "Index",
      CellTags->"Multiplication"]},
  "MultiplicationTable"->{
    Cell[112554, 5038, 238, 9, 15, "Index",
      CellTags->"MultiplicationTable"]},
  "MultiplicativeInverse"->{
    Cell[112795, 5049, 267, 9, 15, "Index",
      CellTags->"MultiplicativeInverse"],
    Cell[113065, 5060, 259, 9, 15, "Index",
      CellTags->"MultiplicativeInverse"]},
  "NegationOf"->{
    Cell[113327, 5071, 245, 9, 15, "Index",
      CellTags->"NegationOf"],
    Cell[113575, 5082, 234, 9, 15, "Index",
      CellTags->"NegationOf"],
    Cell[113812, 5093, 246, 9, 15, "Index",
      CellTags->"NegationOf"],
    Cell[114061, 5104, 229, 9, 15, "Index",
      CellTags->"NegationOf"]},
  "NonCommutingPairs"->{
    Cell[114293, 5115, 239, 9, 15, "Index",
      CellTags->"NonCommutingPairs"]},
  "NonTrivialOnly"->{
    Cell[114535, 5126, 237, 9, 15, "Index",
      CellTags->"NonTrivialOnly"]},
  "Normality"->{
    Cell[114775, 5137, 209, 9, 15, "Index",
      CellTags->"Normality"]},
  "Normalize"->{
    Cell[114987, 5148, 203, 9, 15, "Index",
      CellTags->"Normalize"]},
  "Norm-related functions"->{
    Cell[115415, 5170, 250, 9, 15, "Index",
      CellTags->"Norm-related functions"]},
  "OneToOneQ"->{
    Cell[115668, 5181, 210, 9, 15, "Index",
      CellTags->"OneToOneQ"]},
  "OntoQ"->{
    Cell[115881, 5192, 202, 9, 15, "Index",
      CellTags->"OntoQ"]},
  "Operation"->{
    Cell[116086, 5203, 231, 9, 15, "Index",
      CellTags->"Operation"],
    Cell[116320, 5214, 246, 9, 15, "Index",
      CellTags->"Operation"]},
  "Order"->{
    Cell[116569, 5225, 215, 9, 15, "Index",
      CellTags->"Order"]},
  "OrderOfAllElements"->{
    Cell[116787, 5236, 241, 9, 15, "Index",
      CellTags->"OrderOfAllElements"]},
  "OrderOfElement"->{
    Cell[117031, 5247, 233, 9, 15, "Index",
      CellTags->"OrderOfElement"]},
  "Orders"->{
    Cell[117267, 5258, 217, 9, 15, "Index",
      CellTags->"Orders"]},
  "Packages"->{
    Cell[117487, 5269, 222, 9, 15, "Index",
      CellTags->"Packages"]},
  "PermutationGroup"->{
    Cell[117922, 5291, 248, 9, 15, "Index",
      CellTags->"PermutationGroup"]},
  "Permutations"->{
    Cell[118173, 5302, 226, 9, 15, "Index",
      CellTags->"Permutations"],
    Cell[118402, 5313, 237, 9, 15, "Index",
      CellTags->"Permutations"]},
  "Permutations and Cycles"->{
    Cell[118642, 5324, 262, 9, 15, "Index",
      CellTags->"Permutations and Cycles"]},
  "Poly"->{
    Cell[118907, 5335, 220, 9, 15, "Index",
      CellTags->"Poly"]},
  "Polynomial Conversion"->{
    Cell[119130, 5346, 275, 9, 15, "Index",
      CellTags->"Polynomial Conversion"]},
  "Polynomial Evaluation"->{
    Cell[119408, 5357, 270, 9, 15, "Index",
      CellTags->"Polynomial Evaluation"]},
  "Polynomials"->{
    Cell[119681, 5368, 218, 9, 15, "Index",
      CellTags->"Polynomials"],
    Cell[119902, 5379, 249, 9, 15, "Index",
      CellTags->"Polynomials"],
    Cell[120154, 5390, 213, 9, 15, "Index",
      CellTags->"Polynomials"]},
  "PowersIncrease"->{
    Cell[120370, 5401, 235, 9, 15, "Index",
      CellTags->"PowersIncrease"]},
  "PrintMessage"->{
    Cell[120608, 5412, 226, 9, 15, "Index",
      CellTags->"PrintMessage"]},
  "ProductOrder"->{
    Cell[120837, 5423, 292, 9, 29, "Index",
      CellTags->"ProductOrder"]},
  "RandomDistributiveQ"->{
    Cell[121933, 5467, 251, 9, 15, "Index",
      CellTags->"RandomDistributiveQ"]},
  "RandomElement"->{
    Cell[122187, 5478, 251, 9, 15, "Index",
      CellTags->"RandomElement"],
    Cell[122441, 5489, 235, 9, 15, "Index",
      CellTags->"RandomElement"],
    Cell[122679, 5500, 236, 9, 15, "Index",
      CellTags->"RandomElement"],
    Cell[122918, 5511, 231, 9, 15, "Index",
      CellTags->"RandomElement"],
    Cell[123152, 5522, 229, 9, 15, "Index",
      CellTags->"RandomElement"],
    Cell[123384, 5533, 233, 9, 15, "Index",
      CellTags->"RandomElement"]},
  "Random Elements"->{
    Cell[123620, 5544, 245, 9, 15, "Index",
      CellTags->"Random Elements"],
    Cell[123868, 5555, 223, 9, 15, "Index",
      CellTags->"Random Elements"]},
  "RandomElements"->{
    Cell[124094, 5566, 253, 9, 15, "Index",
      CellTags->"RandomElements"],
    Cell[124350, 5577, 237, 9, 15, "Index",
      CellTags->"RandomElements"],
    Cell[124590, 5588, 238, 9, 15, "Index",
      CellTags->"RandomElements"],
    Cell[124831, 5599, 233, 9, 15, "Index",
      CellTags->"RandomElements"],
    Cell[125067, 5610, 231, 9, 15, "Index",
      CellTags->"RandomElements"],
    Cell[125301, 5621, 235, 9, 15, "Index",
      CellTags->"RandomElements"]},
  "RefSym"->{
    Cell[125539, 5632, 237, 9, 15, "Index",
      CellTags->"RefSym"]},
  "Replacement"->{
    Cell[125779, 5643, 259, 9, 15, "Index",
      CellTags->"Replacement"],
    Cell[126041, 5654, 247, 9, 15, "Index",
      CellTags->"Replacement"]},
  "ReportIterations"->{
    Cell[126291, 5665, 222, 9, 15, "Index",
      CellTags->"ReportIterations"]},
  "Representatives"->{
    Cell[126516, 5676, 238, 9, 15, "Index",
      CellTags->"Representatives"]},
  "RightCoset"->{
    Cell[126757, 5687, 219, 9, 15, "Index",
      CellTags->"RightCoset"],
    Cell[126979, 5698, 212, 9, 15, "Index",
      CellTags->"RightCoset"]},
  "RightCosets"->{
    Cell[127194, 5709, 221, 9, 15, "Index",
      CellTags->"RightCosets"],
    Cell[127418, 5720, 214, 9, 15, "Index",
      CellTags->"RightCosets"]},
  "RightDistributiveQ"->{
    Cell[127635, 5731, 249, 9, 15, "Index",
      CellTags->"RightDistributiveQ"]},
  "Ringoid"->{
    Cell[127887, 5742, 215, 9, 15, "Index",
      CellTags->"Ringoid"]},
  "RingoidDescription"->{
    Cell[128105, 5753, 233, 9, 15, "Index",
      CellTags->"RingoidDescription"]},
  "Ringoids"->{
    Cell[128563, 5775, 240, 9, 15, "Index",
      CellTags->"Ringoids"]},
  "Ring Properties"->{
    Cell[128806, 5786, 225, 9, 15, "Index",
      CellTags->"Ring Properties"]},
  "RootsOfUnity"->{
    Cell[129034, 5797, 242, 9, 15, "Index",
      CellTags->"RootsOfUnity"]},
  "RotSym"->{
    Cell[129279, 5808, 237, 9, 15, "Index",
      CellTags->"RotSym"]},
  "SamplePairs"->{
    Cell[129519, 5819, 224, 9, 15, "Index",
      CellTags->"SamplePairs"]},
  "SampleSize"->{
    Cell[129746, 5830, 222, 9, 15, "Index",
      CellTags->"SampleSize"]},
  "SelectBaseElementsFrom"->{
    Cell[129971, 5841, 263, 9, 15, "Index",
      CellTags->"SelectBaseElementsFrom"]},
  "SelectFrom"->{
    Cell[130237, 5852, 239, 9, 15, "Index",
      CellTags->"SelectFrom"],
    Cell[130479, 5863, 257, 9, 15, "Index",
      CellTags->"SelectFrom"],
    Cell[130739, 5874, 241, 9, 15, "Index",
      CellTags->"SelectFrom"],
    Cell[130983, 5885, 244, 9, 15, "Index",
      CellTags->"SelectFrom"]},
  "ShowBodyText"->{
    Cell[131230, 5896, 226, 9, 15, "Index",
      CellTags->"ShowBodyText"]},
  "ShowName"->{
    Cell[131459, 5907, 218, 9, 15, "Index",
      CellTags->"ShowName"]},
  "ShowOperator"->{
    Cell[131680, 5918, 226, 9, 15, "Index",
      CellTags->"ShowOperator"]},
  "ShowSidesText"->{
    Cell[131909, 5929, 228, 9, 15, "Index",
      CellTags->"ShowSidesText"]},
  "Size"->{
    Cell[132140, 5940, 213, 9, 15, "Index",
      CellTags->"Size"]},
  "SizeLimit"->{
    Cell[132356, 5951, 230, 9, 15, "Index",
      CellTags->"SizeLimit"],
    Cell[132589, 5962, 245, 9, 15, "Index",
      CellTags->"SizeLimit"],
    Cell[132837, 5973, 234, 9, 15, "Index",
      CellTags->"SizeLimit"]},
  "SL"->{
    Cell[133074, 5984, 201, 9, 15, "Index",
      CellTags->"SL"],
    Cell[133278, 5995, 210, 9, 15, "Index",
      CellTags->"SL"],
    Cell[133491, 6006, 226, 9, 15, "Index",
      CellTags->"SL"]},
  "Solve"->{
    Cell[133720, 6017, 243, 9, 15, "Index",
      CellTags->"Solve"]},
  "Sort"->{
    Cell[133966, 6028, 198, 9, 15, "Index",
      CellTags->"Sort"]},
  "Staged"->{
    Cell[134167, 6039, 202, 9, 15, "Index",
      CellTags->"Staged"]},
  "Staged Closure"->{
    Cell[134372, 6050, 214, 9, 15, "Index",
      CellTags->"Staged Closure"]},
  "Structure"->{
    Cell[134589, 6061, 244, 9, 15, "Index",
      CellTags->"Structure"],
    Cell[134836, 6072, 238, 9, 15, "Index",
      CellTags->"Structure"]},
  "SurjectiveQ"->{
    Cell[135894, 6127, 214, 9, 15, "Index",
      CellTags->"SurjectiveQ"]},
  "Symmetric"->{
    Cell[136111, 6138, 234, 9, 15, "Index",
      CellTags->"Symmetric"]},
  "SymmetricGroup"->{
    Cell[136348, 6149, 244, 9, 15, "Index",
      CellTags->"SymmetricGroup"]},
  "TheSet"->{
    Cell[136595, 6160, 214, 9, 15, "Index",
      CellTags->"TheSet"]},
  "ToFunction"->{
    Cell[136812, 6171, 240, 9, 15, "Index",
      CellTags->"ToFunction"]},
  "ToGroupoid"->{
    Cell[137055, 6182, 232, 9, 15, "Index",
      CellTags->"ToGroupoid"]},
  "ToRingoid"->{
    Cell[137290, 6193, 228, 9, 15, "Index",
      CellTags->"ToRingoid"]},
  "ToRules"->{
    Cell[137521, 6204, 238, 9, 15, "Index",
      CellTags->"ToRules"],
    Cell[137762, 6215, 246, 9, 15, "Index",
      CellTags->"ToRules"]},
  "Trivial"->{
    Cell[138011, 6226, 205, 9, 15, "Index",
      CellTags->"Trivial"]},
  "TrivialZR"->{
    Cell[138219, 6237, 215, 9, 15, "Index",
      CellTags->"TrivialZR"]},
  "TwistedZ"->{
    Cell[138437, 6248, 261, 9, 15, "Index",
      CellTags->"TwistedZ"]},
  "Types of Structures"->{
    Cell[138701, 6259, 228, 9, 15, "Index",
      CellTags->"Types of Structures"]},
  "U"->{
    Cell[138932, 6270, 247, 9, 15, "Index",
      CellTags->"U"]},
  "UnitQ"->{
    Cell[139182, 6281, 232, 9, 15, "Index",
      CellTags->"UnitQ"],
    Cell[139417, 6292, 235, 9, 15, "Index",
      CellTags->"UnitQ"],
    Cell[139655, 6303, 224, 9, 15, "Index",
      CellTags->"UnitQ"]},
  "Unity"->{
    Cell[139882, 6314, 235, 9, 15, "Index",
      CellTags->"Unity"],
    Cell[140120, 6325, 236, 9, 15, "Index",
      CellTags->"Unity"],
    Cell[140359, 6336, 221, 9, 15, "Index",
      CellTags->"Unity"]},
  "UnityQ"->{
    Cell[140583, 6347, 226, 9, 15, "Index",
      CellTags->"UnityQ"]},
  "UT"->{
    Cell[140812, 6358, 210, 9, 15, "Index",
      CellTags->"UT"],
    Cell[141025, 6369, 226, 9, 15, "Index",
      CellTags->"UT"]},
  "UTD"->{
    Cell[141254, 6380, 212, 9, 15, "Index",
      CellTags->"UTD"],
    Cell[141469, 6391, 228, 9, 15, "Index",
      CellTags->"UTD"]},
  "Variables"->{
    Cell[141700, 6402, 255, 9, 15, "Index",
      CellTags->"Variables"]},
  "VarToUse"->{
    Cell[141958, 6413, 218, 9, 15, "Index",
      CellTags->"VarToUse"]},
  "Well-defined Operation"->{
    Cell[142179, 6424, 249, 9, 15, "Index",
      CellTags->"Well-defined Operation"]},
  "WideElements"->{
    Cell[142431, 6435, 224, 9, 15, "Index",
      CellTags->"WideElements"],
    Cell[142658, 6446, 221, 9, 15, "Index",
      CellTags->"WideElements"]},
  "WithUnityQ"->{
    Cell[142882, 6457, 245, 9, 15, "Index",
      CellTags->"WithUnityQ"],
    Cell[143130, 6468, 234, 9, 15, "Index",
      CellTags->"WithUnityQ"],
    Cell[143367, 6479, 246, 9, 15, "Index",
      CellTags->"WithUnityQ"],
    Cell[143616, 6490, 241, 9, 15, "Index",
      CellTags->"WithUnityQ"]},
  "Z"->{
    Cell[143860, 6501, 244, 9, 15, "Index",
      CellTags->"Z"],
    Cell[144107, 6512, 247, 9, 15, "Index",
      CellTags->"Z"],
    Cell[144357, 6523, 199, 9, 15, "Index",
      CellTags->"Z"],
    Cell[144559, 6534, 234, 9, 15, "Index",
      CellTags->"Z"]},
  "Zero"->{
    Cell[144796, 6545, 233, 9, 15, "Index",
      CellTags->"Zero"],
    Cell[145032, 6556, 222, 9, 15, "Index",
      CellTags->"Zero"],
    Cell[145257, 6567, 234, 9, 15, "Index",
      CellTags->"Zero"],
    Cell[145494, 6578, 207, 9, 15, "Index",
      CellTags->"Zero"]},
  "Zeros"->{
    Cell[146197, 6611, 232, 9, 15, "Index",
      CellTags->"Zeros"]},
  "ZG"->{
    Cell[146432, 6622, 249, 9, 15, "Index",
      CellTags->"ZG"]},
  "ZMap"->{
    Cell[146684, 6633, 216, 9, 15, "Index",
      CellTags->"ZMap"]},
  "ZR"->{
    Cell[146903, 6644, 201, 9, 15, "Index",
      CellTags->"ZR"]},
  "Zx"->{
    Cell[147107, 6655, 249, 9, 15, "Index",
      CellTags->"Zx"]},
  "StyleBox[Indeterminate, MR]"->{
    Cell[147359, 6666, 233, 9, 15, "Index",
      CellTags->"StyleBox[Indeterminate, MR]"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 148433, 6698},
  {"AbelianQ", 148535, 6701},
  {"AdditiveGroupoid", 148629, 6704},
  {"AdditiveToMultiplicative", 148739, 6707},
  {"AGroupoid", 148842, 6710},
  {"Alternating Group", 148938, 6713},
  {"Annihilator", 149036, 6716},
  {"Annihilator of a Set", 149137, 6719},
  {"Aut", 149231, 6722},
  {"Automorphism", 149317, 6725},
  {"AutomorphismGroup", 149417, 6728},
  {"Automorphisms", 149518, 6731},
  {"BackgroundColors", 149618, 6734},
  {"Building Groupoids from Groupoids", 149738, 6737},
  {"Building Ringoids from Ringoids", 149873, 6740},
  {"Built-in Groupoids", 149993, 6743},
  {"Built-in Morphoids", 150100, 6746},
  {"CartesianProduct", 150205, 6749},
  {"CayleyTable", 150303, 6752},
  {"Center", 150616, 6761},
  {"Centralizer", 150704, 6764},
  {"ClosedDiffQ", 150797, 6767},
  {"ClosedPlusQ", 150890, 6770},
  {"ClosedTimesQ", 150984, 6773},
  {"CloseSets", 151076, 6776},
  {"Closure", 151163, 6779},
  {"CollectOrders", 151254, 6782},
  {"CommutatorSubgroup", 151356, 6785},
  {"ComplementNoSort", 151461, 6788},
  {"ComplexToPoint", 151562, 6791},
  {"ConjugacyClass", 151661, 6794},
  {"Conjugate", 151755, 6797},
  {"Cycle operations", 151851, 6800},
  {"Cycles", 151944, 6803},
  {"CyclicGenerators", 152037, 6806},
  {"Cyclic Groups", 152137, 6809},
  {"CyclicQ", 152228, 6812},
  {"Cyclic subgroup generation", 152332, 6815},
  {"CyclicSubgroups", 152444, 6818},
  {"DefaultOrder", 152542, 6821},
  {"DefaultStructure", 152641, 6824},
  {"Determinants", 152820, 6829},
  {"DiagonalMatrices", 153071, 6836},
  {"DiagQ", 153164, 6839},
  {"Dihedral Groups", 153256, 6842},
  {"DisguiseGroupoid", 153359, 6845},
  {"DisguiseRingoid", 153462, 6848},
  {"Disguising groups and rings", 153576, 6851},
  {"DisjointCyclesQ", 153690, 6854},
  {"\"Divides\" family of Groupoids", 153808, 6857},
  {"Divisibility in Z[Sqrt[d]]", 153937, 6860},
  {"Division Property of Polynomials", 154067, 6863},
  {"DrawNgon", 154179, 6866},
  {"EAAM packages", 154272, 6869},
  {"EisensteinsCriterionQ", 154378, 6872},
  {"ElementConjugate", 154487, 6875},
  {"ElementToPower", 154589, 6878},
  {"EqualMorphiodQ", 154767, 6883},
  {"ESG", 154856, 6886},
  {"EvaluationInExtension", 154952, 6889},
  {"Evaluation of polynomials", 155070, 6892},
  {"EvenPermutationQ", 155183, 6895},
  {"ExtendPermutation", 155288, 6898},
  {"ExtensionDegree", 155392, 6901},
  {"FactorGroup", 155490, 6904},
  {"Factor Groups", 155586, 6907},
  {"FactorRing", 155681, 6910},
  {"Fiber", 155768, 6913},
  {"FieldIrreducible", 155861, 6916},
  {"FieldQ", 155955, 6919},
  {"Finite fields", 156046, 6922},
  {"FixQ", 156135, 6925},
  {"Formation of EAAM objects", 156236, 6928},
  {"Formation of Morphoids", 156355, 6931},
  {"FormGroupoid", 156461, 6934},
  {"FormGroupoidByTable", 156640, 6939},
  {"FormGroupoidFromCycles", 156753, 6942},
  {"FormMorphoid", 156859, 6945},
  {"FormMorphoidSetup", 156960, 6948},
  {"FormRingoid", 157060, 6951},
  {"FormRingoidByTable", 157161, 6954},
  {"FromCycles", 157261, 6957},
  {"Func", 157347, 6960},
  {"Function arithmetic", 157442, 6963},
  {"Functions on a Ringoid", 157638, 6968},
  {"FunctionsOver", 157745, 6971},
  {"FuncToRules", 157841, 6974},
  {"GaloisFieldQ", 157936, 6977},
  {"GaussianIntegerQ", 158036, 6980},
  {"Geissinger, L.", 158138, 6983},
  {"GeneralLinear", 158237, 6986},
  {"GeneralLinearGroup", 158340, 6989},
  {"GenerateGroupoid", 158446, 6992},
  {"GeneratingSet", 158547, 6995},
  {"GF", 158634, 6998},
  {" Global variables and options", 158737, 7001},
  {"GLQ", 158841, 7004},
  {"Graphics Functions", 158934, 7007},
  {"Graphics Output from Visual Mode", 159056, 7010},
  {"GroupCenter", 159171, 7013},
  {"GroupExponent", 159267, 7016},
  {"GroupIdentity", 159365, 7019},
  {"GroupInfo", 159459, 7022},
  {"GroupInverse", 159552, 7025},
  {"Groupoid Formation", 159654, 7028},
  {"GroupoidName", 159756, 7031},
  {"GroupQ", 159846, 7034},
  {"Groups of permutations", 159946, 7037},
  {"HasIdentityQ", 160053, 7040},
  {"HasInversesQ", 160378, 7049},
  {"HasLeftIdentityQ", 160631, 7056},
  {"HasRightIdentityQ", 160737, 7059},
  {"HasUnityQ", 160836, 7062},
  {"HasZeroQ", 160926, 7065},
  {"HomomorphismQ", 161236, 7074},
  {"IdealQ", 161328, 7077},
  {"Ideals", 161413, 7080},
  {"IdempotentQ", 161503, 7083},
  {"Idempotents", 161598, 7086},
  {"InducedCanonical", 161698, 7089},
  {"InducedIsomorphism", 161805, 7092},
  {"Inn", 161899, 7095},
  {"InnerAutomorphism", 161992, 7098},
  {"InnerAutomorphismGroup", 162104, 7101},
  {"IntegerDivisors", 162214, 7104},
  {"IntegerLatticeGrid", 162320, 7107},
  {"Integers mod n", 162425, 7110},
  {"IntegralDomainQ", 162527, 7113},
  {"InverseImage", 162627, 7116},
  {"InverseImages", 162725, 7119},
  {"Irreducibility of integer-based polynomials", 162854, 7122},
  {"IrreduciblePolynomial", 162991, 7125},
  {"IrreduciblePolyOverZpQ", 163107, 7128},
  {"IsomorphismQ", 163214, 7131},
  {"Kernel", 163305, 7134},
  {"LabCode functions", 163401, 7137},
  {"\"Large\" elements and Visual Mode", 163525, 7140},
  {"LeftIdealQ", 163642, 7143},
  {"LeftIdentity", 163737, 7146},
  {"LeftInverse", 163833, 7149},
  {"LeftInvertibleQ", 163932, 7152},
  {"Loading all packages", 164040, 7155},
  {"Mat", 164136, 7158},
  {"MatA", 164216, 7161},
  {"MatM", 164297, 7164},
  {"MatricesOver", 164386, 7167},
  {"Matrices over a ringoid", 164494, 7170},
  {"Matrix arithmetic", 164607, 7173},
  {"Matrix Groupoids", 164713, 7176},
  {"Matrix Inverses", 164817, 7179},
  {"MatrixOperation", 164920, 7182},
  {"MatrixOverQ", 165019, 7185},
  {"MatrixPower", 165114, 7188},
  {"Matrix Ringoids", 165213, 7191},
  {"Matrix Sub-extensions", 165322, 7194},
  {"MaximalIdealQ", 165429, 7197},
  {"Maximal Ideals", 165529, 7200},
  {"MGroupoid", 165625, 7203},
  {"ModpIrreducibilityQ", 165726, 7206},
  {"MonoidQ", 165825, 7209},
  {"Monomial", 165913, 7212},
  {"MorphismQ", 166003, 7215},
  {"MorphoidComposition", 166104, 7218},
  {"MorphoidFunction", 166212, 7221},
  {"MorphoidRules", 166314, 7224},
  {"MultipleOfElement", 166417, 7227},
  {"MultiplicativeGroupoid", 166529, 7230},
  {"MultiplicativeToAdditive", 166648, 7233},
  {"MultiplyCycles", 166759, 7236},
  {"MultiplyPermutations", 166866, 7239},
  {"Names in a package", 166977, 7242},
  {"NextStage", 167077, 7245},
  {"NilpotentDegree", 167174, 7248},
  {"NilpotentQ", 167272, 7251},
  {"Nilpotents", 167365, 7254},
  {"NonAssociatingTriples", 167469, 7257},
  {"NonZeroMGroupoid", 167579, 7260},
  {"Normalizer", 167678, 7263},
  {"NormalQ", 167843, 7268},
  {"OddPermutationQ", 167938, 7271},
  {"Operation-preserving Morphoids", 168056, 7274},
  {"Operations on Cycles", 168179, 7277},
  {"Operations on Permutations", 168298, 7280},
  {"OperatorSymbol", 168411, 7283},
  {"Orbit", 168503, 7286},
  {"Orbits", 168587, 7289},
  {"Ordering", 168674, 7292},
  {"Output", 168761, 7295},
  {"Overview of EAAM", 168856, 7298},
  {"Parity", 168951, 7301},
  {"Patterns in larger systems", 169127, 7306},
  {"PermutationComposition", 169248, 7309},
  {"PermutationImage", 169359, 7312},
  {"PermutationInverse", 169466, 7315},
  {"PermutationMatrix", 169574, 7318},
  {"PermutationQ", 169676, 7321},
  {"PermutationToPower", 169779, 7324},
  {"PlusSymbol", 169880, 7327},
  {"Polynomial Arithmetic", 169984, 7330},
  {"PolynomialDivision", 170096, 7333},
  {"PolynomialEvaluation", 170207, 7336},
  {"PolynomialGCD", 170313, 7339},
  {"Polynomial Interpolation", 170423, 7342},
  {"PolynomialLCM", 170533, 7345},
  {"PolynomialQuotient", 170637, 7348},
  {"PolynomialRemainder", 170747, 7351},
  {"PolynomialsOfDegreeN", 170859, 7354},
  {"Polynomials Over a Ringoid", 170978, 7357},
  {"PolynomialsUpToDegreeN", 171099, 7360},
  {"PolyQ", 171199, 7363},
  {"PolyToFunction", 171291, 7366},
  {"PowerList", 171387, 7369},
  {"PreservesQ", 171479, 7372},
  {"PreviousStage", 171575, 7375},
  {"PrimeIdealQ", 171672, 7378},
  {"Prime Ideals", 171768, 7381},
  {"PrimitivePolynomials", 171873, 7384},
  {"PrincipalIdeal", 171980, 7387},
  {"Principal Ideal generated by a Ringoid element", 172113, 7390},
  {"ProbableGroupQ", 172246, 7393},
  {"ProbableMorphismQ", 172350, 7396},
  {"ProbableRingQ", 172453, 7399},
  {"ProperSubsetQ", 172552, 7402},
  {"QuaternionGroup", 172653, 7405},
  {"QuotientGroup", 172754, 7408},
  {"Quotient Groups", 172855, 7411},
  {"QuotientRing", 172955, 7414},
  {"Quotient Rings", 173131, 7419},
  {"Quotient rings of polynomials", 173247, 7422},
  {"RandomAssociativeQ", 173367, 7425},
  {"RandomGroupoid", 173638, 7432},
  {"Randomize", 173734, 7435},
  {"RandomMatrix", 173828, 7438},
  {"RandomPermutation", 173930, 7441},
  {"Random polynomials", 174038, 7444},
  {"RationalRootCandidates", 174151, 7447},
  {"RationalRootTheorem", 174265, 7450},
  {"ReorderGroupoid", 174372, 7453},
  {"RightIdealQ", 174471, 7456},
  {"RightIdentity", 174568, 7459},
  {"RightInverse", 174666, 7462},
  {"RightInvertibleQ", 174767, 7465},
  {"RingInfo", 174864, 7468},
  {"RingoidName", 174956, 7471},
  {"RingQ", 175121, 7476},
  {"SamePermutationQ", 175215, 7479},
  {"SameSetQ", 175312, 7482},
  {"SemiGroupQ", 175403, 7485},
  {"ShowCircle", 175496, 7488},
  {"ShowColoredPermutation", 175601, 7491},
  {"ShowFigure", 175706, 7494},
  {"ShowGroupOrders", 175804, 7497},
  {"ShowPermutation", 175907, 7500},
  {"SizeOfMatrices", 176009, 7503},
  {"SLQ", 176099, 7506},
  {"Solution of polynomial equations", 176207, 7509},
  {"SortGroupoid", 176324, 7512},
  {"SpecialLinear", 176422, 7515},
  {"SpecialLinearGroup", 176526, 7518},
  {"Stabilizer", 176627, 7521},
  {"Stabilizers", 176721, 7524},
  {"Structure of Groupoids", 176827, 7527},
  {"Structure of Morphoids", 176944, 7530},
  {"SubgroupClosure", 177054, 7533},
  {"SubgroupConjugate", 177159, 7536},
  {"SubgroupGenerated", 177266, 7539},
  {"SubgroupIntersection", 177458, 7544},
  {"SubgroupJoin", 177563, 7547},
  {"Subgroupoid", 177659, 7550},
  {"SubgroupProduct", 177758, 7553},
  {"SubgroupQ", 177855, 7556},
  {"Subgroups", 178094, 7563},
  {"SubgroupUnion", 178263, 7568},
  {"SubringQ", 178357, 7571},
  {"Subrings", 178446, 7574},
  {"SubsetQ", 178534, 7577},
  {"SwitchStructureTo", 178631, 7580},
  {"TableOfPowers", 178734, 7583},
  {"\"Taker\" family", 178836, 7586},
  {"TextCayley", 178935, 7589},
  {"TimesSymbol", 179029, 7592},
  {"ToCycles", 179121, 7595},
  {"ToOrdinaryPolynomial", 179222, 7598},
  {"ToPermutation", 179328, 7601},
  {"ToTranspositions", 179430, 7604},
  {"Transpositions", 179533, 7607},
  {"UnionNoSort", 179631, 7610},
  {"Units", 179720, 7613},
  {"ValuesHavingGivenNorm", 179819, 7616},
  {"VisualizeMorphoid", 179930, 7619},
  {"VisualTextShown", 180035, 7622},
  {"web page", 180131, 7625},
  {"Working in Z[Sqrt[d]]", 180233, 7628},
  {"ZdAssociatesQ", 180340, 7631},
  {"ZdCombineAssociates", 180445, 7634},
  {"ZdConjugate", 180548, 7637},
  {"ZdDivide", 180640, 7640},
  {"ZdDividesQ", 180731, 7643},
  {"ZdDivisors", 180824, 7646},
  {"ZdIrreducibleQ", 180921, 7649},
  {"ZdNorm", 181014, 7652},
  {"ZdPossibleNormQ", 181108, 7655},
  {"ZdPossibleNorms", 181211, 7658},
  {"ZdQ", 181302, 7661},
  {"ZdUnitQ", 181385, 7664},
  {"ZeroDivisorQ", 181477, 7667},
  {"ZeroDivisors", 181728, 7674},
  {"StyleBox[Exploring Small Groups, FontSlant -> Italic]", 181866, 7677},
  {"@", 181993, 7680},
  {"A", 182068, 7683},
  {"Addition", 182150, 7686},
  {"Adjoin", 182525, 7697},
  {"All", 182607, 7700},
  {"Alternating", 182694, 7703},
  {"AlternatingGroup", 182794, 7706},
  {"Argument flexibility", 182903, 7709},
  {"AssociativeQ", 183008, 7712},
  {"BaseRing", 183405, 7723},
  {"BooleanRing", 183569, 7728},
  {"Canonical Decomposition", 183676, 7731},
  {"CayleyForm", 183782, 7734},
  {"Cayley Tables", 184026, 7741},
  {"CayleyTables", 184201, 7746},
  {"Center of a Group", 184303, 7749},
  {"Centralizer of an element or subgroup", 184430, 7752},
  {"Changing Default Values in a Session", 184576, 7755},
  {"Characteristic", 184699, 7758},
  {"ClosedQ", 184793, 7761},
  {"Closure of subsets", 185175, 7772},
  {"Codomain", 185274, 7775},
  {"Coefficient", 185366, 7778},
  {"CoefficientList", 185465, 7781},
  {"ColorCodomain", 185566, 7784},
  {"ColorDomain", 185663, 7787},
  {"Combine", 185754, 7790},
  {"CommutativeQ", 185846, 7793},
  {"Commutator", 186093, 7800},
  {"Commutators", 186187, 7803},
  {"Conjugacy Class", 186286, 7806},
  {"Cosets", 186380, 7809},
  {"CosetToList", 186470, 7812},
  {"CycleAs", 186636, 7817},
  {"Cyclic", 186722, 7820},
  {"CyclicGroup", 186812, 7823},
  {"D", 186897, 7826},
  {"Degree", 186977, 7829},
  {"Det", 187059, 7832},
  {"Diag", 187139, 7835},
  {"Dihedral", 187292, 7840},
  {"DihedralGroup", 187386, 7843},
  {"DirectProduct", 187485, 7846},
  {"Direct Products", 187663, 7851},
  {"DirectSum", 187839, 7856},
  {"Distributive Property", 188015, 7861},
  {"DistributiveQ", 188122, 7864},
  {"DividesQ", 188216, 7867},
  {"Divisibility", 188381, 7872},
  {"DivisorsComplete", 188482, 7875},
  {"Domain", 188577, 7878},
  {"Dot", 188799, 7885},
  {"ElementQ", 188883, 7888},
  {"Elements", 189260, 7899},
  {"ElementsQ", 189422, 7904},
  {"ElementToCoset", 189591, 7909},
  {"Equal", 189683, 7912},
  {"Exponent", 189769, 7915},
  {"Extension Ringoids", 189868, 7918},
  {"{Extensions of standard , StyleBox[Mathematica, FontSlant -> Italic],  \
polynomial functions}", 190053, 7922},
  {"ExtensionType", 190241, 7927},
  {"FirstTaker", 190337, 7930},
  {"FlexibleEntering", 190436, 7933},
  {"Form", 190529, 7936},
  {"FormatElements", 190756, 7943},
  {"FormatOperator", 190935, 7948},
  {"Galois Fields", 191113, 7953},
  {"GaussianIntegers", 191215, 7956},
  {"GaussianIntegersAdditive", 191328, 7959},
  {"GaussianIntegersMultiplicative", 191455, 7962},
  {"GaussianUnits", 191571, 7965},
  {"Generators", 191667, 7968},
  {"GL", 191752, 7971},
  {"Greatest Common Factor", 191981, 7978},
  {"Groupoid", 192084, 7981},
  {"GroupoidDescription", 192184, 7984},
  {"Groupoids", 192285, 7987},
  {"Group Properties", 192456, 7992},
  {"HasNegativeQ", 192557, 7995},
  {"HeadingsColored", 192657, 7998},
  {"Identity", 192753, 8001},
  {"IdentityMatrix", 192848, 8004},
  {"Image", 192940, 8007},
  {"Indeterminate", 193031, 8010},
  {"Index", 193199, 8015},
  {"IndexLimit", 193287, 8018},
  {"InjectiveQ", 193380, 8021},
  {"IntegerUnits", 193475, 8024},
  {"Internal Form", 193573, 8027},
  {"InterpolatingPolynomial", 193682, 8030},
  {"Inverse", 193785, 8033},
  {"Inverses", 193945, 8038},
  {"InvertibleQ", 194257, 8047},
  {"IsAGroup", 194426, 8052},
  {"IsARing", 194515, 8055},
  {"JoinDivisors", 194608, 8058},
  {"KeyForm", 194701, 8061},
  {"Klein4", 194932, 8068},
  {"LatticeRing", 195023, 8071},
  {"Least Common Multiple", 195129, 8074},
  {"LeftCoset", 195233, 8077},
  {"LeftCosets", 195400, 8082},
  {"LeftDistributiveQ", 195576, 8087},
  {"ListDensityPlot", 195682, 8090},
  {"Lists", 195776, 8093},
  {"LowerDegreeOK", 195868, 8096},
  {"LT", 195957, 8099},
  {"LTD", 196103, 8104},
  {"Matrices", 196256, 8109},
  {"Matrix Extensions", 196355, 8112},
  {"MatrixType", 196456, 8115},
  {"Matrix Types", 196552, 8118},
  {"MaxElementsToList", 196655, 8121},
  {"MaxTaker", 196836, 8126},
  {"MeetDivisors", 196930, 8129},
  {"MinTaker", 197024, 8132},
  {"MixedDivisors", 197119, 8135},
  {"Mode", 197210, 8138},
  {"ModulusPolynomial", 197443, 8145},
  {"Monic", 197539, 8148},
  {"Morphoid", 197626, 8151},
  {"Morphoids", 197717, 8154},
  {"Multiplication", 198110, 8165},
  {"MultiplicationTable", 198533, 8176},
  {"MultiplicativeInverse", 198647, 8179},
  {"NegationOf", 198838, 8184},
  {"NonCommutingPairs", 199164, 8193},
  {"NonTrivialOnly", 199269, 8196},
  {"Normality", 199366, 8199},
  {"Normalize", 199458, 8202},
  {"Norm-related functions", 199563, 8205},
  {"OneToOneQ", 199668, 8208},
  {"OntoQ", 199756, 8211},
  {"Operation", 199844, 8214},
  {"Order", 200006, 8219},
  {"OrderOfAllElements", 200103, 8222},
  {"OrderOfElement", 200209, 8225},
  {"Orders", 200303, 8228},
  {"Packages", 200391, 8231},
  {"PermutationGroup", 200489, 8234},
  {"Permutations", 200591, 8237},
  {"Permutations and Cycles", 200777, 8242},
  {"Poly", 200878, 8245},
  {"Polynomial Conversion", 200977, 8248},
  {"Polynomial Evaluation", 201093, 8251},
  {"Polynomials", 201199, 8254},
  {"PowersIncrease", 201450, 8261},
  {"PrintMessage", 201550, 8264},
  {"ProductOrder", 201648, 8267},
  {"RandomDistributiveQ", 201753, 8270},
  {"RandomElement", 201859, 8273},
  {"Random Elements", 202351, 8286},
  {"RandomElements", 202534, 8291},
  {"RefSym", 203023, 8304},
  {"Replacement", 203114, 8307},
  {"ReportIterations", 203291, 8312},
  {"Representatives", 203396, 8315},
  {"RightCoset", 203495, 8318},
  {"RightCosets", 203665, 8323},
  {"RightDistributiveQ", 203844, 8328},
  {"Ringoid", 203943, 8331},
  {"RingoidDescription", 204042, 8334},
  {"Ringoids", 204142, 8337},
  {"Ring Properties", 204239, 8340},
  {"RootsOfUnity", 204340, 8343},
  {"RotSym", 204432, 8346},
  {"SamplePairs", 204523, 8349},
  {"SampleSize", 204618, 8352},
  {"SelectBaseElementsFrom", 204724, 8355},
  {"SelectFrom", 204830, 8358},
  {"ShowBodyText", 205151, 8367},
  {"ShowName", 205245, 8370},
  {"ShowOperator", 205339, 8373},
  {"ShowSidesText", 205438, 8376},
  {"Size", 205529, 8379},
  {"SizeLimit", 205616, 8382},
  {"SL", 205849, 8389},
  {"Solve", 206064, 8396},
  {"Sort", 206147, 8399},
  {"Staged", 206231, 8402},
  {"Staged Closure", 206325, 8405},
  {"Structure", 206422, 8408},
  {"SurjectiveQ", 206590, 8413},
  {"Symmetric", 206684, 8416},
  {"SymmetricGroup", 206781, 8419},
  {"TheSet", 206875, 8422},
  {"ToFunction", 206965, 8425},
  {"ToGroupoid", 207059, 8428},
  {"ToRingoid", 207152, 8431},
  {"ToRules", 207242, 8434},
  {"Trivial", 207402, 8439},
  {"TrivialZR", 207492, 8442},
  {"TwistedZ", 207583, 8445},
  {"Types of Structures", 207684, 8448},
  {"U", 207778, 8451},
  {"UnitQ", 207858, 8454},
  {"Unity", 208082, 8461},
  {"UnityQ", 208307, 8468},
  {"UT", 208389, 8471},
  {"UTD", 208535, 8476},
  {"Variables", 208689, 8481},
  {"VarToUse", 208780, 8484},
  {"Well-defined Operation", 208884, 8487},
  {"WideElements", 208992, 8490},
  {"WithUnityQ", 209165, 8495},
  {"Z", 209475, 8504},
  {"Zero", 209752, 8513},
  {"Zeros", 210042, 8522},
  {"ZG", 210123, 8525},
  {"ZMap", 210203, 8528},
  {"ZR", 210283, 8531},
  {"Zx", 210361, 8534},
  {"StyleBox[Indeterminate, MR]", 210464, 8537}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 73, 1, 41, "IndexSection",
  CellTags->"MasterIndexHeading"],
Cell[1785, 52, 194, 7, 23, "Index",
  CellTags->"AbelianQ"],
Cell[1982, 61, 213, 7, 23, "Index",
  CellTags->"AdditiveGroupoid"],
Cell[2198, 70, 209, 7, 23, "Index",
  CellTags->"AdditiveToMultiplicative"],
Cell[2410, 79, 199, 7, 23, "Index",
  CellTags->"AGroupoid"],
Cell[2612, 88, 213, 7, 23, "Index",
  CellTags->"Alternating Group"],
Cell[2828, 97, 195, 7, 23, "Index",
  CellTags->"Annihilator"],
Cell[3026, 106, 213, 7, 23, "Index",
  CellTags->"Annihilator of a Set"],
Cell[3242, 115, 167, 7, 23, "Index",
  CellTags->"Aut"],
Cell[3412, 124, 185, 7, 23, "Index",
  CellTags->"Automorphism"],
Cell[3600, 133, 195, 7, 23, "Index",
  CellTags->"AutomorphismGroup"],
Cell[3798, 142, 187, 7, 23, "Index",
  CellTags->"Automorphisms"],
Cell[3988, 151, 222, 7, 23, "Index",
  CellTags->"BackgroundColors"],
Cell[4213, 160, 230, 7, 23, "Index",
  CellTags->"Building Groupoids from Groupoids"],
Cell[4446, 169, 226, 7, 23, "Index",
  CellTags->"Building Ringoids from Ringoids"],
Cell[4675, 178, 244, 7, 23, "Index",
  CellTags->"Built-in Groupoids"],
Cell[4922, 187, 206, 7, 23, "Index",
  CellTags->"Built-in Morphoids"],
Cell[5131, 196, 203, 7, 23, "Index",
  CellTags->"CartesianProduct"],
Cell[5337, 205, 183, 7, 23, "Index",
  CellTags->"CayleyTable"],
Cell[5523, 214, 190, 7, 23, "Index",
  CellTags->"Center"],
Cell[5716, 223, 200, 7, 23, "Index",
  CellTags->"Centralizer"],
Cell[5919, 232, 193, 7, 23, "Index",
  CellTags->"ClosedDiffQ"],
Cell[6115, 241, 193, 7, 23, "Index",
  CellTags->"ClosedPlusQ"],
Cell[6311, 250, 195, 7, 23, "Index",
  CellTags->"ClosedTimesQ"],
Cell[6509, 259, 189, 7, 23, "Index",
  CellTags->"CloseSets"],
Cell[6701, 268, 166, 7, 23, "Index",
  CellTags->"Closure"],
Cell[6870, 277, 231, 7, 23, "Index",
  CellTags->"CollectOrders"],
Cell[7104, 286, 214, 7, 23, "Index",
  CellTags->"CommutatorSubgroup"],
Cell[7321, 295, 203, 7, 23, "Index",
  CellTags->"ComplementNoSort"],
Cell[7527, 304, 181, 7, 23, "Index",
  CellTags->"ComplexToPoint"],
Cell[7711, 313, 206, 7, 23, "Index",
  CellTags->"ConjugacyClass"],
Cell[7920, 322, 196, 7, 23, "Index",
  CellTags->"Conjugate"],
Cell[8119, 331, 199, 7, 23, "Index",
  CellTags->"Cycle operations"],
Cell[8321, 340, 159, 7, 23, "Index",
  CellTags->"Cycles"],
Cell[8483, 349, 211, 7, 23, "Index",
  CellTags->"CyclicGenerators"],
Cell[8697, 358, 213, 7, 23, "Index",
  CellTags->"Cyclic Groups"],
Cell[8913, 367, 193, 7, 23, "Index",
  CellTags->"CyclicQ"],
Cell[9109, 376, 205, 7, 23, "Index",
  CellTags->"Cyclic subgroup generation"],
Cell[9317, 385, 183, 7, 23, "Index",
  CellTags->"CyclicSubgroups"],
Cell[9503, 394, 214, 7, 23, "Index",
  CellTags->"DefaultOrder"],
Cell[9720, 403, 222, 7, 23, "Index",
  CellTags->"DefaultStructure"],
Cell[9945, 412, 205, 7, 23, "Index",
  CellTags->"Determinants"],
Cell[10153, 421, 199, 7, 23, "Index",
  CellTags->"DiagonalMatrices"],
Cell[10355, 430, 183, 7, 23, "Index",
  CellTags->"DiagQ"],
Cell[10541, 439, 217, 7, 23, "Index",
  CellTags->"Dihedral Groups"],
Cell[10761, 448, 221, 7, 23, "Index",
  CellTags->"DisguiseGroupoid"],
Cell[10985, 457, 219, 7, 23, "Index",
  CellTags->"DisguiseRingoid"],
Cell[11207, 466, 243, 7, 23, "Index",
  CellTags->"Disguising groups and rings"],
Cell[11453, 475, 223, 7, 23, "Index",
  CellTags->"DisjointCyclesQ"],
Cell[11679, 484, 243, 7, 23, "Index",
  CellTags->"\"Divides\" family of Groupoids"],
Cell[11925, 493, 211, 7, 23, "Index",
  CellTags->"Divisibility in Z[Sqrt[d]]"],
Cell[12139, 502, 241, 7, 23, "Index",
  CellTags->"Division Property of Polynomials"],
Cell[12383, 511, 193, 7, 23, "Index",
  CellTags->"DrawNgon"],
Cell[12579, 520, 214, 7, 23, "Index",
  CellTags->"EAAM packages"],
Cell[12796, 529, 235, 7, 23, "Index",
  CellTags->"EisensteinsCriterionQ"],
Cell[13034, 538, 210, 7, 23, "Index",
  CellTags->"ElementConjugate"],
Cell[13247, 547, 207, 7, 23, "Index",
  CellTags->"ElementToPower"],
Cell[13457, 556, 214, 7, 23, "Index",
  CellTags->"EqualMorphiodQ"],
Cell[13674, 565, 159, 7, 23, "Index",
  CellTags->"ESG"],
Cell[13836, 574, 227, 7, 23, "Index",
  CellTags->"EvaluationInExtension"],
Cell[14066, 583, 243, 7, 23, "Index",
  CellTags->"Evaluation of polynomials"],
Cell[14312, 592, 225, 7, 23, "Index",
  CellTags->"EvenPermutationQ"],
Cell[14540, 601, 212, 7, 23, "Index",
  CellTags->"ExtendPermutation"],
Cell[14755, 610, 191, 7, 23, "Index",
  CellTags->"ExtensionDegree"],
Cell[14949, 619, 187, 7, 23, "Index",
  CellTags->"FactorGroup"],
Cell[15139, 628, 191, 7, 23, "Index",
  CellTags->"Factor Groups"],
Cell[15333, 637, 183, 7, 23, "Index",
  CellTags->"FactorRing"],
Cell[15519, 646, 213, 7, 23, "Index",
  CellTags->"Fiber"],
Cell[15735, 655, 193, 7, 23, "Index",
  CellTags->"FieldIrreducible"],
Cell[15931, 664, 181, 7, 23, "Index",
  CellTags->"FieldQ"],
Cell[16115, 673, 187, 7, 23, "Index",
  CellTags->"Finite fields"],
Cell[16305, 682, 187, 7, 23, "Index",
  CellTags->"FixQ"],
Cell[16495, 691, 228, 7, 23, "Index",
  CellTags->"Formation of EAAM objects"],
Cell[16726, 700, 212, 7, 23, "Index",
  CellTags->"Formation of Morphoids"],
Cell[16941, 709, 182, 7, 23, "Index",
  CellTags->"FormGroupoid"],
Cell[17126, 718, 210, 7, 23, "Index",
  CellTags->"FormGroupoidByTable"],
Cell[17339, 727, 260, 7, 23, "Index",
  CellTags->"FormGroupoidFromCycles"],
Cell[17602, 736, 192, 7, 23, "Index",
  CellTags->"FormMorphoid"],
Cell[17797, 745, 202, 7, 23, "Index",
  CellTags->"FormMorphoidSetup"],
Cell[18002, 754, 178, 7, 23, "Index",
  CellTags->"FormRingoid"],
Cell[18183, 763, 206, 7, 23, "Index",
  CellTags->"FormRingoidByTable"],
Cell[18392, 772, 167, 7, 23, "Index",
  CellTags->"FromCycles"],
Cell[18562, 781, 181, 7, 23, "Index",
  CellTags->"Func"],
Cell[18746, 790, 211, 7, 23, "Index",
  CellTags->"Function arithmetic"],
Cell[18960, 799, 217, 7, 23, "Index",
  CellTags->"Functions on a Ringoid"],
Cell[19180, 808, 199, 7, 23, "Index",
  CellTags->"FunctionsOver"],
Cell[19382, 817, 195, 7, 23, "Index",
  CellTags->"FuncToRules"],
Cell[19580, 826, 185, 7, 23, "Index",
  CellTags->"GaloisFieldQ"],
Cell[19768, 835, 185, 7, 23, "Index",
  CellTags->"GaussianIntegerQ"],
Cell[19956, 844, 193, 7, 23, "Index",
  CellTags->"Geissinger, L."],
Cell[20152, 853, 193, 7, 23, "Index",
  CellTags->"GeneralLinear"],
Cell[20348, 862, 203, 7, 23, "Index",
  CellTags->"GeneralLinearGroup"],
Cell[20554, 871, 198, 7, 23, "Index",
  CellTags->"GenerateGroupoid"],
Cell[20755, 880, 205, 7, 23, "Index",
  CellTags->"GeneratingSet"],
Cell[20963, 889, 165, 7, 23, "Index",
  CellTags->"GF"],
Cell[21131, 898, 241, 6, 23, "Index",
  CellTags->" Global variables and options"],
Cell[21375, 906, 179, 7, 23, "Index",
  CellTags->"GLQ"],
Cell[21557, 915, 213, 7, 23, "Index",
  CellTags->"Graphics Functions"],
Cell[21773, 924, 229, 7, 23, "Index",
  CellTags->"Graphics Output from Visual Mode"],
Cell[22005, 933, 200, 7, 23, "Index",
  CellTags->"GroupCenter"],
Cell[22208, 942, 205, 7, 23, "Index",
  CellTags->"GroupExponent"],
Cell[22416, 951, 195, 7, 23, "Index",
  CellTags->"GroupIdentity"],
Cell[22614, 960, 187, 7, 23, "Index",
  CellTags->"GroupInfo"],
Cell[22804, 969, 193, 7, 23, "Index",
  CellTags->"GroupInverse"],
Cell[23000, 978, 194, 7, 23, "Index",
  CellTags->"Groupoid Formation"],
Cell[23197, 987, 203, 7, 23, "Index",
  CellTags->"GroupoidName"],
Cell[23403, 996, 181, 7, 23, "Index",
  CellTags->"GroupQ"],
Cell[23587, 1005, 223, 7, 23, "Index",
  CellTags->"Groups of permutations"],
Cell[23813, 1014, 209, 7, 23, "Index",
  CellTags->"HasIdentityQ"],
Cell[24025, 1023, 213, 7, 23, "Index",
  CellTags->"HasIdentityQ"],
Cell[24241, 1032, 213, 7, 23, "Index",
  CellTags->"HasInversesQ"],
Cell[24457, 1041, 201, 7, 23, "Index",
  CellTags->"HasLeftIdentityQ"],
Cell[24661, 1050, 203, 7, 23, "Index",
  CellTags->"HasRightIdentityQ"],
Cell[24867, 1059, 203, 7, 23, "Index",
  CellTags->"HasUnityQ"],
Cell[25073, 1068, 189, 7, 23, "Index",
  CellTags->"HasZeroQ"],
Cell[25265, 1077, 181, 7, 23, "Index",
  CellTags->"HomomorphismQ"],
Cell[25449, 1086, 184, 7, 23, "Index",
  CellTags->"IdealQ"],
Cell[25636, 1095, 184, 7, 23, "Index",
  CellTags->"Ideals"],
Cell[25823, 1104, 205, 7, 23, "Index",
  CellTags->"IdempotentQ"],
Cell[26031, 1113, 205, 7, 23, "Index",
  CellTags->"Idempotents"],
Cell[26239, 1122, 203, 7, 23, "Index",
  CellTags->"InducedCanonical"],
Cell[26445, 1131, 207, 7, 23, "Index",
  CellTags->"InducedIsomorphism"],
Cell[26655, 1140, 167, 7, 23, "Index",
  CellTags->"Inn"],
Cell[26825, 1149, 195, 7, 23, "Index",
  CellTags->"InnerAutomorphism"],
Cell[27023, 1158, 205, 7, 23, "Index",
  CellTags->"InnerAutomorphismGroup"],
Cell[27231, 1167, 189, 7, 23, "Index",
  CellTags->"IntegerDivisors"],
Cell[27423, 1176, 189, 7, 23, "Index",
  CellTags->"IntegerLatticeGrid"],
Cell[27615, 1185, 236, 7, 23, "Index",
  CellTags->"Integers mod n"],
Cell[27854, 1194, 199, 7, 23, "Index",
  CellTags->"IntegralDomainQ"],
Cell[28056, 1203, 227, 7, 23, "Index",
  CellTags->"InverseImage"],
Cell[28286, 1212, 229, 7, 23, "Index",
  CellTags->"InverseImages"],
Cell[28518, 1221, 279, 7, 23, "Index",
  CellTags->"Irreducibility of integer-based polynomials"],
Cell[28800, 1230, 203, 7, 23, "Index",
  CellTags->"IrreduciblePolynomial"],
Cell[29006, 1239, 205, 7, 23, "Index",
  CellTags->"IrreduciblePolyOverZpQ"],
Cell[29214, 1248, 179, 7, 23, "Index",
  CellTags->"IsomorphismQ"],
Cell[29396, 1257, 215, 7, 23, "Index",
  CellTags->"Kernel"],
Cell[29614, 1266, 239, 7, 23, "Index",
  CellTags->"LabCode functions"],
Cell[29856, 1275, 265, 7, 23, "Index",
  CellTags->"\"Large\" elements and Visual Mode"],
Cell[30124, 1284, 192, 7, 23, "Index",
  CellTags->"LeftIdealQ"],
Cell[30319, 1293, 193, 7, 23, "Index",
  CellTags->"LeftIdentity"],
Cell[30515, 1302, 191, 7, 23, "Index",
  CellTags->"LeftInverse"],
Cell[30709, 1311, 199, 7, 23, "Index",
  CellTags->"LeftInvertibleQ"],
Cell[30911, 1320, 200, 7, 23, "Index",
  CellTags->"Loading all packages"],
Cell[31114, 1329, 165, 7, 23, "Index",
  CellTags->"Mat"],
Cell[31282, 1338, 167, 7, 23, "Index",
  CellTags->"MatA"],
Cell[31452, 1347, 167, 7, 23, "Index",
  CellTags->"MatM"],
Cell[31622, 1356, 183, 7, 23, "Index",
  CellTags->"MatricesOver"],
Cell[31808, 1365, 205, 7, 23, "Index",
  CellTags->"Matrices over a ringoid"],
Cell[32016, 1374, 203, 7, 23, "Index",
  CellTags->"Matrix arithmetic"],
Cell[32222, 1383, 199, 7, 23, "Index",
  CellTags->"Matrix Groupoids"],
Cell[32424, 1392, 211, 7, 23, "Index",
  CellTags->"Matrix Inverses"],
Cell[32638, 1401, 225, 7, 23, "Index",
  CellTags->"MatrixOperation"],
Cell[32866, 1410, 217, 7, 23, "Index",
  CellTags->"MatrixOverQ"],
Cell[33086, 1419, 191, 7, 23, "Index",
  CellTags->"MatrixPower"],
Cell[33280, 1428, 195, 7, 23, "Index",
  CellTags->"Matrix Ringoids"],
Cell[33478, 1437, 209, 7, 23, "Index",
  CellTags->"Matrix Sub-extensions"],
Cell[33690, 1446, 199, 7, 23, "Index",
  CellTags->"MaximalIdealQ"],
Cell[33892, 1455, 201, 7, 23, "Index",
  CellTags->"Maximal Ideals"],
Cell[34096, 1464, 199, 7, 23, "Index",
  CellTags->"MGroupoid"],
Cell[34298, 1473, 231, 7, 23, "Index",
  CellTags->"ModpIrreducibilityQ"],
Cell[34532, 1482, 183, 7, 23, "Index",
  CellTags->"MonoidQ"],
Cell[34718, 1491, 197, 7, 23, "Index",
  CellTags->"Monomial"],
Cell[34918, 1500, 173, 7, 23, "Index",
  CellTags->"MorphismQ"],
Cell[35094, 1509, 224, 7, 23, "Index",
  CellTags->"MorphoidComposition"],
Cell[35321, 1518, 218, 7, 23, "Index",
  CellTags->"MorphoidFunction"],
Cell[35542, 1527, 212, 7, 23, "Index",
  CellTags->"MorphoidRules"],
Cell[35757, 1536, 217, 7, 23, "Index",
  CellTags->"MultipleOfElement"],
Cell[35977, 1545, 225, 7, 23, "Index",
  CellTags->"MultiplicativeGroupoid"],
Cell[36205, 1554, 209, 7, 23, "Index",
  CellTags->"MultiplicativeToAdditive"],
Cell[36417, 1563, 195, 7, 23, "Index",
  CellTags->"MultiplyCycles"],
Cell[36615, 1572, 218, 7, 23, "Index",
  CellTags->"MultiplyPermutations"],
Cell[36836, 1581, 224, 7, 23, "Index",
  CellTags->"Names in a package"],
Cell[37063, 1590, 171, 7, 23, "Index",
  CellTags->"NextStage"],
Cell[37237, 1599, 213, 7, 23, "Index",
  CellTags->"NilpotentDegree"],
Cell[37453, 1608, 203, 7, 23, "Index",
  CellTags->"NilpotentQ"],
Cell[37659, 1617, 203, 7, 23, "Index",
  CellTags->"Nilpotents"],
Cell[37865, 1626, 211, 7, 23, "Index",
  CellTags->"NonAssociatingTriples"],
Cell[38079, 1635, 213, 7, 23, "Index",
  CellTags->"NonZeroMGroupoid"],
Cell[38295, 1644, 198, 7, 23, "Index",
  CellTags->"Normalizer"],
Cell[38496, 1653, 179, 7, 23, "Index",
  CellTags->"NormalQ"],
Cell[38678, 1662, 223, 7, 23, "Index",
  CellTags->"OddPermutationQ"],
Cell[38904, 1671, 215, 7, 23, "Index",
  CellTags->"Operation-preserving Morphoids"],
Cell[39122, 1680, 207, 7, 23, "Index",
  CellTags->"Operations on Cycles"],
Cell[39332, 1689, 230, 7, 23, "Index",
  CellTags->"Operations on Permutations"],
Cell[39565, 1698, 207, 7, 23, "Index",
  CellTags->"OperatorSymbol"],
Cell[39775, 1707, 189, 7, 23, "Index",
  CellTags->"Orbit"],
Cell[39967, 1716, 191, 7, 23, "Index",
  CellTags->"Orbits"],
Cell[40161, 1725, 206, 7, 23, "Index",
  CellTags->"Ordering"],
Cell[40370, 1734, 202, 7, 23, "Index",
  CellTags->"Output"],
Cell[40575, 1743, 210, 7, 23, "Index",
  CellTags->"Overview of EAAM"],
Cell[40788, 1752, 205, 7, 23, "Index",
  CellTags->"Parity"],
Cell[40996, 1761, 226, 7, 23, "Index",
  CellTags->"Patterns in larger systems"],
Cell[41225, 1770, 222, 7, 23, "Index",
  CellTags->"PermutationComposition"],
Cell[41450, 1779, 211, 7, 23, "Index",
  CellTags->"PermutationImage"],
Cell[41664, 1788, 214, 7, 23, "Index",
  CellTags->"PermutationInverse"],
Cell[41881, 1797, 212, 7, 23, "Index",
  CellTags->"PermutationMatrix"],
Cell[42096, 1806, 214, 7, 23, "Index",
  CellTags->"PermutationQ"],
Cell[42313, 1815, 214, 7, 23, "Index",
  CellTags->"PermutationToPower"],
Cell[42530, 1824, 188, 7, 23, "Index",
  CellTags->"PlusSymbol"],
Cell[42721, 1833, 219, 7, 23, "Index",
  CellTags->"Polynomial Arithmetic"],
Cell[42943, 1842, 213, 7, 23, "Index",
  CellTags->"PolynomialDivision"],
Cell[43159, 1851, 233, 7, 23, "Index",
  CellTags->"PolynomialEvaluation"],
Cell[43395, 1860, 203, 7, 23, "Index",
  CellTags->"PolynomialGCD"],
Cell[43601, 1869, 255, 7, 23, "Index",
  CellTags->"Polynomial Interpolation"],
Cell[43859, 1878, 203, 7, 23, "Index",
  CellTags->"PolynomialLCM"],
Cell[44065, 1887, 213, 7, 23, "Index",
  CellTags->"PolynomialQuotient"],
Cell[44281, 1896, 215, 7, 23, "Index",
  CellTags->"PolynomialRemainder"],
Cell[44499, 1905, 221, 7, 23, "Index",
  CellTags->"PolynomialsOfDegreeN"],
Cell[44723, 1914, 225, 7, 23, "Index",
  CellTags->"Polynomials Over a Ringoid"],
Cell[44951, 1923, 225, 7, 23, "Index",
  CellTags->"PolynomialsUpToDegreeN"],
Cell[45179, 1932, 191, 7, 23, "Index",
  CellTags->"PolyQ"],
Cell[45373, 1941, 235, 7, 23, "Index",
  CellTags->"PolyToFunction"],
Cell[45611, 1950, 179, 7, 23, "Index",
  CellTags->"PowerList"],
Cell[45793, 1959, 175, 7, 23, "Index",
  CellTags->"PreservesQ"],
Cell[45971, 1968, 179, 7, 23, "Index",
  CellTags->"PreviousStage"],
Cell[46153, 1977, 195, 7, 23, "Index",
  CellTags->"PrimeIdealQ"],
Cell[46351, 1986, 197, 7, 23, "Index",
  CellTags->"Prime Ideals"],
Cell[46551, 1995, 201, 7, 23, "Index",
  CellTags->"PrimitivePolynomials"],
Cell[46755, 2004, 201, 7, 23, "Index",
  CellTags->"PrincipalIdeal"],
Cell[46959, 2013, 265, 7, 23, "Index",
  CellTags->"Principal Ideal generated by a Ringoid element"],
Cell[47227, 2022, 197, 7, 23, "Index",
  CellTags->"ProbableGroupQ"],
Cell[47427, 2031, 189, 7, 23, "Index",
  CellTags->"ProbableMorphismQ"],
Cell[47619, 2040, 181, 7, 23, "Index",
  CellTags->"ProbableRingQ"],
Cell[47803, 2049, 197, 7, 23, "Index",
  CellTags->"ProperSubsetQ"],
Cell[48003, 2058, 195, 7, 23, "Index",
  CellTags->"QuaternionGroup"],
Cell[48201, 2067, 191, 7, 23, "Index",
  CellTags->"QuotientGroup"],
Cell[48395, 2076, 195, 7, 23, "Index",
  CellTags->"Quotient Groups"],
Cell[48593, 2085, 187, 7, 23, "Index",
  CellTags->"QuotientRing"],
Cell[48783, 2094, 191, 7, 23, "Index",
  CellTags->"Quotient Rings"],
Cell[48977, 2103, 243, 7, 23, "Index",
  CellTags->"Quotient rings of polynomials"],
Cell[49223, 2112, 205, 7, 23, "Index",
  CellTags->"RandomAssociativeQ"],
Cell[49431, 2121, 244, 7, 23, "Index",
  CellTags->"RandomGroupoid"],
Cell[49678, 2130, 189, 7, 23, "Index",
  CellTags->"Randomize"],
Cell[49870, 2139, 197, 7, 23, "Index",
  CellTags->"RandomMatrix"],
Cell[50070, 2148, 224, 7, 23, "Index",
  CellTags->"RandomPermutation"],
Cell[50297, 2157, 207, 7, 23, "Index",
  CellTags->"Random polynomials"],
Cell[50507, 2166, 237, 7, 23, "Index",
  CellTags->"RationalRootCandidates"],
Cell[50747, 2175, 231, 7, 23, "Index",
  CellTags->"RationalRootTheorem"],
Cell[50981, 2184, 209, 7, 23, "Index",
  CellTags->"ReorderGroupoid"],
Cell[51193, 2193, 194, 7, 23, "Index",
  CellTags->"RightIdealQ"],
Cell[51390, 2202, 195, 7, 23, "Index",
  CellTags->"RightIdentity"],
Cell[51588, 2211, 193, 7, 23, "Index",
  CellTags->"RightInverse"],
Cell[51784, 2220, 201, 7, 23, "Index",
  CellTags->"RightInvertibleQ"],
Cell[51988, 2229, 171, 7, 23, "Index",
  CellTags->"RingInfo"],
Cell[52162, 2238, 190, 7, 23, "Index",
  CellTags->"RingoidName"],
Cell[52355, 2247, 165, 7, 23, "Index",
  CellTags->"RingQ"],
Cell[52523, 2256, 225, 7, 23, "Index",
  CellTags->"SamePermutationQ"],
Cell[52751, 2265, 187, 7, 23, "Index",
  CellTags->"SameSetQ"],
Cell[52941, 2274, 189, 7, 23, "Index",
  CellTags->"SemiGroupQ"],
Cell[53133, 2283, 197, 7, 23, "Index",
  CellTags->"ShowCircle"],
Cell[53333, 2292, 249, 7, 23, "Index",
  CellTags->"ShowColoredPermutation"],
Cell[53585, 2301, 197, 7, 23, "Index",
  CellTags->"ShowFigure"],
Cell[53785, 2310, 235, 7, 23, "Index",
  CellTags->"ShowGroupOrders"],
Cell[54023, 2319, 207, 7, 23, "Index",
  CellTags->"ShowPermutation"],
Cell[54233, 2328, 223, 7, 23, "Index",
  CellTags->"SizeOfMatrices"],
Cell[54459, 2337, 179, 7, 23, "Index",
  CellTags->"SLQ"],
Cell[54641, 2346, 257, 7, 23, "Index",
  CellTags->"Solution of polynomial equations"],
Cell[54901, 2355, 203, 7, 23, "Index",
  CellTags->"SortGroupoid"],
Cell[55107, 2364, 193, 7, 23, "Index",
  CellTags->"SpecialLinear"],
Cell[55303, 2373, 203, 7, 23, "Index",
  CellTags->"SpecialLinearGroup"],
Cell[55509, 2382, 199, 7, 23, "Index",
  CellTags->"Stabilizer"],
Cell[55711, 2391, 201, 7, 23, "Index",
  CellTags->"Stabilizers"],
Cell[55915, 2400, 223, 7, 23, "Index",
  CellTags->"Structure of Groupoids"],
Cell[56141, 2409, 230, 7, 23, "Index",
  CellTags->"Structure of Morphoids"],
Cell[56374, 2418, 182, 7, 23, "Index",
  CellTags->"SubgroupClosure"],
Cell[56559, 2427, 212, 7, 23, "Index",
  CellTags->"SubgroupConjugate"],
Cell[56774, 2436, 187, 7, 23, "Index",
  CellTags->"SubgroupGenerated"],
Cell[56964, 2445, 193, 7, 23, "Index",
  CellTags->"SubgroupIntersection"],
Cell[57160, 2454, 177, 7, 23, "Index",
  CellTags->"SubgroupJoin"],
Cell[57340, 2463, 174, 7, 23, "Index",
  CellTags->"Subgroupoid"],
Cell[57517, 2472, 183, 7, 23, "Index",
  CellTags->"SubgroupProduct"],
Cell[57703, 2481, 170, 7, 23, "Index",
  CellTags->"SubgroupQ"],
Cell[57876, 2490, 171, 7, 23, "Index",
  CellTags->"Subgroups"],
Cell[58050, 2499, 179, 7, 23, "Index",
  CellTags->"SubgroupUnion"],
Cell[58232, 2508, 188, 7, 23, "Index",
  CellTags->"SubringQ"],
Cell[58423, 2517, 188, 7, 23, "Index",
  CellTags->"Subrings"],
Cell[58614, 2526, 185, 7, 23, "Index",
  CellTags->"SubsetQ"],
Cell[58802, 2535, 227, 7, 23, "Index",
  CellTags->"SwitchStructureTo"],
Cell[59032, 2544, 187, 7, 23, "Index",
  CellTags->"TableOfPowers"],
Cell[59222, 2553, 212, 7, 23, "Index",
  CellTags->"\"Taker\" family"],
Cell[59437, 2562, 181, 7, 23, "Index",
  CellTags->"TextCayley"],
Cell[59621, 2571, 190, 7, 23, "Index",
  CellTags->"TimesSymbol"],
Cell[59814, 2580, 163, 7, 23, "Index",
  CellTags->"ToCycles"],
Cell[59980, 2589, 221, 7, 23, "Index",
  CellTags->"ToOrdinaryPolynomial"],
Cell[60204, 2598, 210, 7, 23, "Index",
  CellTags->"ToPermutation"],
Cell[60417, 2607, 225, 7, 23, "Index",
  CellTags->"ToTranspositions"],
Cell[60645, 2616, 221, 7, 23, "Index",
  CellTags->"Transpositions"],
Cell[60869, 2625, 193, 7, 23, "Index",
  CellTags->"UnionNoSort"],
Cell[61065, 2634, 195, 7, 23, "Index",
  CellTags->"Units"],
Cell[61263, 2643, 221, 7, 23, "Index",
  CellTags->"ValuesHavingGivenNorm"],
Cell[61487, 2652, 211, 7, 23, "Index",
  CellTags->"VisualizeMorphoid"],
Cell[61701, 2661, 220, 7, 23, "Index",
  CellTags->"VisualTextShown"],
Cell[61924, 2670, 212, 7, 23, "Index",
  CellTags->"web page"],
Cell[62139, 2679, 207, 7, 23, "Index",
  CellTags->"Working in Z[Sqrt[d]]"],
Cell[62349, 2688, 191, 7, 23, "Index",
  CellTags->"ZdAssociatesQ"],
Cell[62543, 2697, 197, 7, 23, "Index",
  CellTags->"ZdCombineAssociates"],
Cell[62743, 2706, 187, 7, 23, "Index",
  CellTags->"ZdConjugate"],
Cell[62933, 2715, 181, 7, 23, "Index",
  CellTags->"ZdDivide"],
Cell[63117, 2724, 179, 7, 23, "Index",
  CellTags->"ZdDividesQ"],
Cell[63299, 2733, 179, 7, 23, "Index",
  CellTags->"ZdDivisors"],
Cell[63481, 2742, 193, 7, 23, "Index",
  CellTags->"ZdIrreducibleQ"],
Cell[63677, 2751, 191, 7, 23, "Index",
  CellTags->"ZdNorm"],
Cell[63871, 2760, 209, 7, 23, "Index",
  CellTags->"ZdPossibleNormQ"],
Cell[64083, 2769, 209, 7, 23, "Index",
  CellTags->"ZdPossibleNorms"],
Cell[64295, 2778, 171, 7, 23, "Index",
  CellTags->"ZdQ"],
Cell[64469, 2787, 179, 7, 23, "Index",
  CellTags->"ZdUnitQ"],
Cell[64651, 2796, 209, 7, 23, "Index",
  CellTags->"ZeroDivisorQ"],
Cell[64863, 2805, 209, 7, 23, "Index",
  CellTags->"ZeroDivisors"],
Cell[65075, 2814, 275, 8, 24, "Index",
  CellTags->"StyleBox[Exploring Small Groups, FontSlant -> Italic]"],
Cell[65353, 2824, 216, 9, 23, "Index",
  CellTags->"@"],
Cell[65572, 2835, 218, 9, 23, "Index",
  CellTags->"A"],
Cell[65793, 2846, 237, 9, 23, "Index",
  CellTags->"Addition"],
Cell[66033, 2857, 241, 9, 23, "Index",
  CellTags->"Addition"],
Cell[66277, 2868, 221, 9, 23, "Index",
  CellTags->"Addition"],
Cell[66501, 2879, 233, 9, 23, "Index",
  CellTags->"Addition"],
Cell[66737, 2890, 206, 9, 23, "Index",
  CellTags->"Addition"],
Cell[66946, 2901, 205, 9, 23, "Index",
  CellTags->"Adjoin"],
Cell[67154, 2912, 228, 9, 23, "Index",
  CellTags->"All"],
Cell[67385, 2923, 238, 9, 23, "Index",
  CellTags->"Alternating"],
Cell[67626, 2934, 248, 9, 23, "Index",
  CellTags->"AlternatingGroup"],
Cell[67877, 2945, 233, 9, 23, "Index",
  CellTags->"Argument flexibility"],
Cell[68113, 2956, 247, 9, 23, "Index",
  CellTags->"AssociativeQ"],
Cell[68363, 2967, 246, 9, 23, "Index",
  CellTags->"AssociativeQ"],
Cell[68612, 2978, 264, 9, 23, "Index",
  CellTags->"AssociativeQ"],
Cell[68879, 2989, 217, 9, 23, "Index",
  CellTags->"AssociativeQ"],
Cell[69099, 3000, 217, 9, 23, "Index",
  CellTags->"AssociativeQ"],
Cell[69319, 3011, 237, 9, 23, "Index",
  CellTags->"BaseRing"],
Cell[69559, 3022, 233, 9, 23, "Index",
  CellTags->"BaseRing"],
Cell[69795, 3033, 215, 9, 23, "Index",
  CellTags->"BooleanRing"],
Cell[70013, 3044, 244, 9, 23, "Index",
  CellTags->"Canonical Decomposition"],
Cell[70260, 3055, 222, 9, 23, "Index",
  CellTags->"CayleyForm"],
Cell[70485, 3066, 220, 9, 23, "Index",
  CellTags->"CayleyForm"],
Cell[70708, 3077, 217, 9, 23, "Index",
  CellTags->"CayleyForm"],
Cell[70928, 3088, 232, 9, 23, "Index",
  CellTags->"CayleyTable"],
Cell[71163, 3099, 218, 9, 23, "Index",
  CellTags->"CayleyTable"],
Cell[71384, 3110, 219, 9, 23, "Index",
  CellTags->"CayleyTable"],
Cell[71606, 3121, 213, 9, 23, "Index",
  CellTags->"Cayley Tables"],
Cell[71822, 3132, 222, 9, 23, "Index",
  CellTags->"Cayley Tables"],
Cell[72047, 3143, 224, 9, 23, "Index",
  CellTags->"CayleyTables"],
Cell[72274, 3154, 233, 9, 23, "Index",
  CellTags->"Center of a Group"],
Cell[72510, 3165, 273, 9, 23, "Index",
  CellTags->"Centralizer of an element or subgroup"],
Cell[72786, 3176, 272, 9, 23, "Index",
  CellTags->"Changing Default Values in a Session"],
Cell[73061, 3187, 237, 9, 23, "Index",
  CellTags->"Characteristic"],
Cell[73301, 3198, 230, 9, 23, "Index",
  CellTags->"ClosedQ"],
Cell[73534, 3209, 237, 9, 23, "Index",
  CellTags->"ClosedQ"],
Cell[73774, 3220, 254, 9, 23, "Index",
  CellTags->"ClosedQ"],
Cell[74031, 3231, 221, 9, 23, "Index",
  CellTags->"ClosedQ"],
Cell[74255, 3242, 249, 9, 23, "Index",
  CellTags->"ClosedQ"],
Cell[74507, 3253, 233, 9, 23, "Index",
  CellTags->"Closure of subsets"],
Cell[74743, 3264, 229, 9, 23, "Index",
  CellTags->"Codomain"],
Cell[74975, 3275, 259, 9, 23, "Index",
  CellTags->"Coefficient"],
Cell[75237, 3286, 267, 9, 23, "Index",
  CellTags->"CoefficientList"],
Cell[75507, 3297, 250, 9, 23, "Index",
  CellTags->"ColorCodomain"],
Cell[75760, 3308, 246, 9, 23, "Index",
  CellTags->"ColorDomain"],
Cell[76009, 3319, 223, 9, 23, "Index",
  CellTags->"Combine"],
Cell[76235, 3330, 246, 9, 23, "Index",
  CellTags->"CommutativeQ"],
Cell[76484, 3341, 239, 9, 23, "Index",
  CellTags->"CommutativeQ"],
Cell[76726, 3352, 264, 9, 23, "Index",
  CellTags->"CommutativeQ"],
Cell[76993, 3363, 225, 9, 23, "Index",
  CellTags->"Commutator"],
Cell[77221, 3374, 227, 9, 23, "Index",
  CellTags->"Commutators"],
Cell[77451, 3385, 229, 9, 23, "Index",
  CellTags->"Conjugacy Class"],
Cell[77683, 3396, 218, 9, 23, "Index",
  CellTags->"Cosets"],
Cell[77904, 3407, 240, 9, 23, "Index",
  CellTags->"CosetToList"],
Cell[78147, 3418, 221, 9, 23, "Index",
  CellTags->"CosetToList"],
Cell[78371, 3429, 199, 9, 23, "Index",
  CellTags->"CycleAs"],
Cell[78573, 3440, 236, 9, 23, "Index",
  CellTags->"Cyclic"],
Cell[78812, 3451, 246, 9, 23, "Index",
  CellTags->"CyclicGroup"],
Cell[79061, 3462, 213, 9, 23, "Index",
  CellTags->"D"],
Cell[79277, 3473, 252, 9, 23, "Index",
  CellTags->"DefaultStructure"],
Cell[79532, 3484, 249, 9, 23, "Index",
  CellTags->"Degree"],
Cell[79784, 3495, 211, 9, 23, "Index",
  CellTags->"Det"],
Cell[79998, 3506, 231, 9, 23, "Index",
  CellTags->"Determinants"],
Cell[80232, 3517, 241, 9, 23, "Index",
  CellTags->"Determinants"],
Cell[80476, 3528, 214, 9, 23, "Index",
  CellTags->"Diag"],
Cell[80693, 3539, 230, 9, 23, "Index",
  CellTags->"Diag"],
Cell[80926, 3550, 240, 9, 23, "Index",
  CellTags->"Dihedral"],
Cell[81169, 3561, 250, 9, 23, "Index",
  CellTags->"DihedralGroup"],
Cell[81422, 3572, 224, 9, 23, "Index",
  CellTags->"DirectProduct"],
Cell[81649, 3583, 226, 9, 23, "Index",
  CellTags->"DirectProduct"],
Cell[81878, 3594, 220, 9, 23, "Index",
  CellTags->"Direct Products"],
Cell[82101, 3605, 219, 9, 23, "Index",
  CellTags->"Direct Products"],
Cell[82323, 3616, 216, 9, 23, "Index",
  CellTags->"DirectSum"],
Cell[82542, 3627, 218, 9, 23, "Index",
  CellTags->"DirectSum"],
Cell[82763, 3638, 242, 9, 23, "Index",
  CellTags->"Distributive Property"],
Cell[83008, 3649, 239, 9, 23, "Index",
  CellTags->"DistributiveQ"],
Cell[83250, 3660, 213, 9, 23, "Index",
  CellTags->"DividesQ"],
Cell[83466, 3671, 200, 9, 23, "Index",
  CellTags->"DividesQ"],
Cell[83669, 3682, 237, 9, 23, "Index",
  CellTags->"Divisibility"],
Cell[83909, 3693, 241, 9, 23, "Index",
  CellTags->"DivisorsComplete"],
Cell[84153, 3704, 230, 9, 23, "Index",
  CellTags->"Domain"],
Cell[84386, 3715, 212, 9, 23, "Index",
  CellTags->"Domain"],
Cell[84601, 3726, 225, 9, 23, "Index",
  CellTags->"Domain"],
Cell[84829, 3737, 211, 9, 23, "Index",
  CellTags->"Dot"],
Cell[85043, 3748, 229, 9, 23, "Index",
  CellTags->"ElementQ"],
Cell[85275, 3759, 241, 9, 23, "Index",
  CellTags->"ElementQ"],
Cell[85519, 3770, 225, 9, 23, "Index",
  CellTags->"ElementQ"],
Cell[85747, 3781, 233, 9, 23, "Index",
  CellTags->"ElementQ"],
Cell[85983, 3792, 220, 9, 23, "Index",
  CellTags->"ElementQ"],
Cell[86206, 3803, 229, 9, 23, "Index",
  CellTags->"Elements"],
Cell[86438, 3814, 216, 9, 23, "Index",
  CellTags->"Elements"],
Cell[86657, 3825, 231, 9, 23, "Index",
  CellTags->"ElementsQ"],
Cell[86891, 3836, 222, 9, 23, "Index",
  CellTags->"ElementsQ"],
Cell[87116, 3847, 249, 9, 23, "Index",
  CellTags->"ElementToCoset"],
Cell[87368, 3858, 247, 9, 23, "Index",
  CellTags->"ElementToPower"],
Cell[87618, 3869, 247, 9, 23, "Index",
  CellTags->"Equal"],
Cell[87868, 3880, 253, 9, 23, "Index",
  CellTags->"Exponent"],
Cell[88124, 3891, 238, 9, 23, "Index",
  CellTags->"Extension Ringoids"],
Cell[88365, 3902, 396, 12, 38, "Index",
  CellTags->
  "{Extensions of standard , StyleBox[Mathematica, FontSlant -> Italic],  \
polynomial functions}"],
Cell[88764, 3916, 243, 9, 23, "Index",
  CellTags->"ExtensionType"],
Cell[89010, 3927, 236, 9, 23, "Index",
  CellTags->"FirstTaker"],
Cell[89249, 3938, 239, 9, 23, "Index",
  CellTags->"FlexibleEntering"],
Cell[89491, 3949, 233, 9, 23, "Index",
  CellTags->"Form"],
Cell[89727, 3960, 216, 9, 23, "Index",
  CellTags->"Form"],
Cell[89946, 3971, 213, 9, 23, "Index",
  CellTags->"Form"],
Cell[90162, 3982, 228, 9, 23, "Index",
  CellTags->"FormatElements"],
Cell[90393, 3993, 225, 9, 23, "Index",
  CellTags->"FormatElements"],
Cell[90621, 4004, 228, 9, 23, "Index",
  CellTags->"FormatOperator"],
Cell[90852, 4015, 225, 9, 23, "Index",
  CellTags->"FormatOperator"],
Cell[91080, 4026, 203, 9, 23, "Index",
  CellTags->"FormGroupoid"],
Cell[91286, 4037, 236, 9, 23, "Index",
  CellTags->"Function arithmetic"],
Cell[91525, 4048, 210, 9, 23, "Index",
  CellTags->"Galois Fields"],
Cell[91738, 4059, 275, 9, 23, "Index",
  CellTags->"GaussianIntegers"],
Cell[92016, 4070, 293, 9, 37, "Index",
  CellTags->"GaussianIntegersAdditive"],
Cell[92312, 4081, 304, 9, 37, "Index",
  CellTags->"GaussianIntegersMultiplicative"],
Cell[92619, 4092, 233, 9, 23, "Index",
  CellTags->"GaussianUnits"],
Cell[92855, 4103, 220, 9, 23, "Index",
  CellTags->"Generators"],
Cell[93078, 4114, 201, 9, 23, "Index",
  CellTags->"GL"],
Cell[93282, 4125, 210, 9, 23, "Index",
  CellTags->"GL"],
Cell[93495, 4136, 226, 9, 23, "Index",
  CellTags->"GL"],
Cell[93724, 4147, 253, 9, 23, "Index",
  CellTags->"Greatest Common Factor"],
Cell[93980, 4158, 217, 9, 23, "Index",
  CellTags->"Groupoid"],
Cell[94200, 4169, 238, 9, 23, "Index",
  CellTags->"GroupoidDescription"],
Cell[94441, 4180, 234, 9, 23, "Index",
  CellTags->"Groupoids"],
Cell[94678, 4191, 220, 9, 23, "Index",
  CellTags->"Groupoids"],
Cell[94901, 4202, 252, 9, 23, "Index",
  CellTags->"Group Properties"],
Cell[95156, 4213, 256, 9, 23, "Index",
  CellTags->"HasIdentityQ"],
Cell[95415, 4224, 217, 9, 23, "Index",
  CellTags->"HasIdentityQ"],
Cell[95635, 4235, 247, 9, 70, "Index",
  CellTags->"HasInversesQ"],
Cell[95885, 4246, 217, 9, 70, "Index",
  CellTags->"HasInversesQ"],
Cell[96105, 4257, 233, 9, 70, "Index",
  CellTags->"HasNegativeQ"],
Cell[96341, 4268, 241, 9, 70, "Index",
  CellTags->"HasZeroQ"],
Cell[96585, 4279, 230, 9, 70, "Index",
  CellTags->"HasZeroQ"],
Cell[96818, 4290, 242, 9, 70, "Index",
  CellTags->"HasZeroQ"],
Cell[97063, 4301, 232, 9, 70, "Index",
  CellTags->"HeadingsColored"],
Cell[97298, 4312, 209, 9, 70, "Index",
  CellTags->"Identity"],
Cell[97510, 4323, 247, 9, 70, "Index",
  CellTags->"IdentityMatrix"],
Cell[97760, 4334, 240, 9, 70, "Index",
  CellTags->"Image"],
Cell[98003, 4345, 233, 9, 70, "Index",
  CellTags->"Indeterminate"],
Cell[98239, 4356, 253, 9, 70, "Index",
  CellTags->"Indeterminate"],
Cell[98495, 4367, 202, 9, 70, "Index",
  CellTags->"Index"],
Cell[98700, 4378, 238, 9, 70, "Index",
  CellTags->"IndexLimit"],
Cell[98941, 4389, 212, 9, 70, "Index",
  CellTags->"InjectiveQ"],
Cell[99156, 4400, 231, 9, 70, "Index",
  CellTags->"IntegerUnits"],
Cell[99390, 4411, 228, 9, 70, "Index",
  CellTags->"Internal Form"],
Cell[99621, 4422, 277, 9, 70, "Index",
  CellTags->"InterpolatingPolynomial"],
Cell[99901, 4433, 219, 9, 70, "Index",
  CellTags->"Inverse"],
Cell[100123, 4444, 207, 9, 70, "Index",
  CellTags->"Inverse"],
Cell[100333, 4455, 226, 9, 70, "Index",
  CellTags->"Inverses"],
Cell[100562, 4466, 221, 9, 70, "Index",
  CellTags->"Inverses"],
Cell[100786, 4477, 256, 9, 70, "Index",
  CellTags->"Inverses"],
Cell[101045, 4488, 217, 9, 70, "Index",
  CellTags->"Inverses"],
Cell[101265, 4499, 244, 9, 70, "Index",
  CellTags->"InvertibleQ"],
Cell[101512, 4510, 262, 9, 70, "Index",
  CellTags->"InvertibleQ"],
Cell[101777, 4521, 216, 9, 70, "Index",
  CellTags->"IsAGroup"],
Cell[101996, 4532, 211, 9, 70, "Index",
  CellTags->"IsARing"],
Cell[102210, 4543, 242, 9, 70, "Index",
  CellTags->"JoinDivisors"],
Cell[102455, 4554, 216, 9, 70, "Index",
  CellTags->"KeyForm"],
Cell[102674, 4565, 214, 9, 70, "Index",
  CellTags->"KeyForm"],
Cell[102891, 4576, 211, 9, 70, "Index",
  CellTags->"KeyForm"],
Cell[103105, 4587, 203, 9, 70, "Index",
  CellTags->"Klein4"],
Cell[103311, 4598, 219, 9, 15, "Index",
  CellTags->"LatticeRing"],
Cell[103533, 4609, 251, 9, 15, "Index",
  CellTags->"Least Common Multiple"],
Cell[103787, 4620, 217, 9, 15, "Index",
  CellTags->"LeftCoset"],
Cell[104007, 4631, 210, 9, 15, "Index",
  CellTags->"LeftCoset"],
Cell[104220, 4642, 219, 9, 15, "Index",
  CellTags->"LeftCosets"],
Cell[104442, 4653, 212, 9, 15, "Index",
  CellTags->"LeftCosets"],
Cell[104657, 4664, 247, 9, 15, "Index",
  CellTags->"LeftDistributiveQ"],
Cell[104907, 4675, 250, 9, 15, "Index",
  CellTags->"ListDensityPlot"],
Cell[105160, 4686, 221, 9, 15, "Index",
  CellTags->"Lists"],
Cell[105384, 4697, 247, 9, 15, "Index",
  CellTags->"LowerDegreeOK"],
Cell[105634, 4708, 210, 9, 15, "Index",
  CellTags->"LT"],
Cell[105847, 4719, 226, 9, 15, "Index",
  CellTags->"LT"],
Cell[106076, 4730, 212, 9, 15, "Index",
  CellTags->"LTD"],
Cell[106291, 4741, 228, 9, 15, "Index",
  CellTags->"LTD"],
Cell[106522, 4752, 213, 9, 15, "Index",
  CellTags->"Matrices"],
Cell[106738, 4763, 241, 9, 15, "Index",
  CellTags->"Matrix Extensions"],
Cell[106982, 4774, 235, 9, 15, "Index",
  CellTags->"MatrixType"],
Cell[107220, 4785, 218, 9, 15, "Index",
  CellTags->"Matrix Types"],
Cell[107441, 4796, 234, 9, 15, "Index",
  CellTags->"MaxElementsToList"],
Cell[107678, 4807, 231, 9, 15, "Index",
  CellTags->"MaxElementsToList"],
Cell[107912, 4818, 232, 9, 15, "Index",
  CellTags->"MaxTaker"],
Cell[108147, 4829, 242, 9, 15, "Index",
  CellTags->"MeetDivisors"],
Cell[108392, 4840, 232, 9, 15, "Index",
  CellTags->"MinTaker"],
Cell[108627, 4851, 244, 9, 15, "Index",
  CellTags->"MixedDivisors"],
Cell[108874, 4862, 234, 9, 15, "Index",
  CellTags->"Mode"],
Cell[109111, 4873, 236, 9, 15, "Index",
  CellTags->"Mode"],
Cell[109350, 4884, 201, 9, 15, "Index",
  CellTags->"Mode"],
Cell[109554, 4895, 262, 9, 15, "Index",
  CellTags->"ModulusPolynomial"],
Cell[109819, 4906, 231, 9, 15, "Index",
  CellTags->"Monic"],
Cell[110053, 4917, 218, 9, 15, "Index",
  CellTags->"Morphoid"],
Cell[110274, 4928, 197, 9, 15, "Index",
  CellTags->"Morphoids"],
Cell[110474, 4939, 209, 9, 15, "Index",
  CellTags->"Morphoids"],
Cell[110686, 4950, 197, 9, 15, "Index",
  CellTags->"Morphoids"],
Cell[110886, 4961, 227, 9, 15, "Index",
  CellTags->"Morphoids"],
Cell[111116, 4972, 222, 9, 15, "Index",
  CellTags->"Morphoids"],
Cell[111341, 4983, 249, 9, 15, "Index",
  CellTags->"Multiplication"],
Cell[111593, 4994, 253, 9, 15, "Index",
  CellTags->"Multiplication"],
Cell[111849, 5005, 233, 9, 15, "Index",
  CellTags->"Multiplication"],
Cell[112085, 5016, 245, 9, 15, "Index",
  CellTags->"Multiplication"],
Cell[112333, 5027, 218, 9, 15, "Index",
  CellTags->"Multiplication"],
Cell[112554, 5038, 238, 9, 15, "Index",
  CellTags->"MultiplicationTable"],
Cell[112795, 5049, 267, 9, 15, "Index",
  CellTags->"MultiplicativeInverse"],
Cell[113065, 5060, 259, 9, 15, "Index",
  CellTags->"MultiplicativeInverse"],
Cell[113327, 5071, 245, 9, 15, "Index",
  CellTags->"NegationOf"],
Cell[113575, 5082, 234, 9, 15, "Index",
  CellTags->"NegationOf"],
Cell[113812, 5093, 246, 9, 15, "Index",
  CellTags->"NegationOf"],
Cell[114061, 5104, 229, 9, 15, "Index",
  CellTags->"NegationOf"],
Cell[114293, 5115, 239, 9, 15, "Index",
  CellTags->"NonCommutingPairs"],
Cell[114535, 5126, 237, 9, 15, "Index",
  CellTags->"NonTrivialOnly"],
Cell[114775, 5137, 209, 9, 15, "Index",
  CellTags->"Normality"],
Cell[114987, 5148, 203, 9, 15, "Index",
  CellTags->"Normalize"],
Cell[115193, 5159, 219, 9, 15, "Index",
  CellTags->"Normalizer"],
Cell[115415, 5170, 250, 9, 15, "Index",
  CellTags->"Norm-related functions"],
Cell[115668, 5181, 210, 9, 15, "Index",
  CellTags->"OneToOneQ"],
Cell[115881, 5192, 202, 9, 15, "Index",
  CellTags->"OntoQ"],
Cell[116086, 5203, 231, 9, 15, "Index",
  CellTags->"Operation"],
Cell[116320, 5214, 246, 9, 15, "Index",
  CellTags->"Operation"],
Cell[116569, 5225, 215, 9, 15, "Index",
  CellTags->"Order"],
Cell[116787, 5236, 241, 9, 15, "Index",
  CellTags->"OrderOfAllElements"],
Cell[117031, 5247, 233, 9, 15, "Index",
  CellTags->"OrderOfElement"],
Cell[117267, 5258, 217, 9, 15, "Index",
  CellTags->"Orders"],
Cell[117487, 5269, 222, 9, 15, "Index",
  CellTags->"Packages"],
Cell[117712, 5280, 207, 9, 15, "Index",
  CellTags->"Parity"],
Cell[117922, 5291, 248, 9, 15, "Index",
  CellTags->"PermutationGroup"],
Cell[118173, 5302, 226, 9, 15, "Index",
  CellTags->"Permutations"],
Cell[118402, 5313, 237, 9, 15, "Index",
  CellTags->"Permutations"],
Cell[118642, 5324, 262, 9, 15, "Index",
  CellTags->"Permutations and Cycles"],
Cell[118907, 5335, 220, 9, 15, "Index",
  CellTags->"Poly"],
Cell[119130, 5346, 275, 9, 15, "Index",
  CellTags->"Polynomial Conversion"],
Cell[119408, 5357, 270, 9, 15, "Index",
  CellTags->"Polynomial Evaluation"],
Cell[119681, 5368, 218, 9, 15, "Index",
  CellTags->"Polynomials"],
Cell[119902, 5379, 249, 9, 15, "Index",
  CellTags->"Polynomials"],
Cell[120154, 5390, 213, 9, 15, "Index",
  CellTags->"Polynomials"],
Cell[120370, 5401, 235, 9, 15, "Index",
  CellTags->"PowersIncrease"],
Cell[120608, 5412, 226, 9, 15, "Index",
  CellTags->"PrintMessage"],
Cell[120837, 5423, 292, 9, 29, "Index",
  CellTags->"ProductOrder"],
Cell[121132, 5434, 258, 9, 15, "Index",
  CellTags->"QuotientRing"],
Cell[121393, 5445, 258, 9, 15, "Index",
  CellTags->"RandomAssociativeQ"],
Cell[121654, 5456, 276, 9, 15, "Index",
  CellTags->"RandomAssociativeQ"],
Cell[121933, 5467, 251, 9, 15, "Index",
  CellTags->"RandomDistributiveQ"],
Cell[122187, 5478, 251, 9, 15, "Index",
  CellTags->"RandomElement"],
Cell[122441, 5489, 235, 9, 15, "Index",
  CellTags->"RandomElement"],
Cell[122679, 5500, 236, 9, 15, "Index",
  CellTags->"RandomElement"],
Cell[122918, 5511, 231, 9, 15, "Index",
  CellTags->"RandomElement"],
Cell[123152, 5522, 229, 9, 15, "Index",
  CellTags->"RandomElement"],
Cell[123384, 5533, 233, 9, 15, "Index",
  CellTags->"RandomElement"],
Cell[123620, 5544, 245, 9, 15, "Index",
  CellTags->"Random Elements"],
Cell[123868, 5555, 223, 9, 15, "Index",
  CellTags->"Random Elements"],
Cell[124094, 5566, 253, 9, 15, "Index",
  CellTags->"RandomElements"],
Cell[124350, 5577, 237, 9, 15, "Index",
  CellTags->"RandomElements"],
Cell[124590, 5588, 238, 9, 15, "Index",
  CellTags->"RandomElements"],
Cell[124831, 5599, 233, 9, 15, "Index",
  CellTags->"RandomElements"],
Cell[125067, 5610, 231, 9, 15, "Index",
  CellTags->"RandomElements"],
Cell[125301, 5621, 235, 9, 15, "Index",
  CellTags->"RandomElements"],
Cell[125539, 5632, 237, 9, 15, "Index",
  CellTags->"RefSym"],
Cell[125779, 5643, 259, 9, 15, "Index",
  CellTags->"Replacement"],
Cell[126041, 5654, 247, 9, 15, "Index",
  CellTags->"Replacement"],
Cell[126291, 5665, 222, 9, 15, "Index",
  CellTags->"ReportIterations"],
Cell[126516, 5676, 238, 9, 15, "Index",
  CellTags->"Representatives"],
Cell[126757, 5687, 219, 9, 15, "Index",
  CellTags->"RightCoset"],
Cell[126979, 5698, 212, 9, 15, "Index",
  CellTags->"RightCoset"],
Cell[127194, 5709, 221, 9, 15, "Index",
  CellTags->"RightCosets"],
Cell[127418, 5720, 214, 9, 15, "Index",
  CellTags->"RightCosets"],
Cell[127635, 5731, 249, 9, 15, "Index",
  CellTags->"RightDistributiveQ"],
Cell[127887, 5742, 215, 9, 15, "Index",
  CellTags->"Ringoid"],
Cell[128105, 5753, 233, 9, 15, "Index",
  CellTags->"RingoidDescription"],
Cell[128341, 5764, 219, 9, 15, "Index",
  CellTags->"RingoidName"],
Cell[128563, 5775, 240, 9, 15, "Index",
  CellTags->"Ringoids"],
Cell[128806, 5786, 225, 9, 15, "Index",
  CellTags->"Ring Properties"],
Cell[129034, 5797, 242, 9, 15, "Index",
  CellTags->"RootsOfUnity"],
Cell[129279, 5808, 237, 9, 15, "Index",
  CellTags->"RotSym"],
Cell[129519, 5819, 224, 9, 15, "Index",
  CellTags->"SamplePairs"],
Cell[129746, 5830, 222, 9, 15, "Index",
  CellTags->"SampleSize"],
Cell[129971, 5841, 263, 9, 15, "Index",
  CellTags->"SelectBaseElementsFrom"],
Cell[130237, 5852, 239, 9, 15, "Index",
  CellTags->"SelectFrom"],
Cell[130479, 5863, 257, 9, 15, "Index",
  CellTags->"SelectFrom"],
Cell[130739, 5874, 241, 9, 15, "Index",
  CellTags->"SelectFrom"],
Cell[130983, 5885, 244, 9, 15, "Index",
  CellTags->"SelectFrom"],
Cell[131230, 5896, 226, 9, 15, "Index",
  CellTags->"ShowBodyText"],
Cell[131459, 5907, 218, 9, 15, "Index",
  CellTags->"ShowName"],
Cell[131680, 5918, 226, 9, 15, "Index",
  CellTags->"ShowOperator"],
Cell[131909, 5929, 228, 9, 15, "Index",
  CellTags->"ShowSidesText"],
Cell[132140, 5940, 213, 9, 15, "Index",
  CellTags->"Size"],
Cell[132356, 5951, 230, 9, 15, "Index",
  CellTags->"SizeLimit"],
Cell[132589, 5962, 245, 9, 15, "Index",
  CellTags->"SizeLimit"],
Cell[132837, 5973, 234, 9, 15, "Index",
  CellTags->"SizeLimit"],
Cell[133074, 5984, 201, 9, 15, "Index",
  CellTags->"SL"],
Cell[133278, 5995, 210, 9, 15, "Index",
  CellTags->"SL"],
Cell[133491, 6006, 226, 9, 15, "Index",
  CellTags->"SL"],
Cell[133720, 6017, 243, 9, 15, "Index",
  CellTags->"Solve"],
Cell[133966, 6028, 198, 9, 15, "Index",
  CellTags->"Sort"],
Cell[134167, 6039, 202, 9, 15, "Index",
  CellTags->"Staged"],
Cell[134372, 6050, 214, 9, 15, "Index",
  CellTags->"Staged Closure"],
Cell[134589, 6061, 244, 9, 15, "Index",
  CellTags->"Structure"],
Cell[134836, 6072, 238, 9, 15, "Index",
  CellTags->"Structure"],
Cell[135077, 6083, 213, 9, 15, "Index",
  CellTags->"SubgroupGenerated"],
Cell[135293, 6094, 202, 9, 15, "Index",
  CellTags->"SubgroupQ"],
Cell[135498, 6105, 196, 9, 15, "Index",
  CellTags->"SubgroupQ"],
Cell[135697, 6116, 194, 9, 15, "Index",
  CellTags->"Subgroups"],
Cell[135894, 6127, 214, 9, 15, "Index",
  CellTags->"SurjectiveQ"],
Cell[136111, 6138, 234, 9, 15, "Index",
  CellTags->"Symmetric"],
Cell[136348, 6149, 244, 9, 15, "Index",
  CellTags->"SymmetricGroup"],
Cell[136595, 6160, 214, 9, 15, "Index",
  CellTags->"TheSet"],
Cell[136812, 6171, 240, 9, 15, "Index",
  CellTags->"ToFunction"],
Cell[137055, 6182, 232, 9, 15, "Index",
  CellTags->"ToGroupoid"],
Cell[137290, 6193, 228, 9, 15, "Index",
  CellTags->"ToRingoid"],
Cell[137521, 6204, 238, 9, 15, "Index",
  CellTags->"ToRules"],
Cell[137762, 6215, 246, 9, 15, "Index",
  CellTags->"ToRules"],
Cell[138011, 6226, 205, 9, 15, "Index",
  CellTags->"Trivial"],
Cell[138219, 6237, 215, 9, 15, "Index",
  CellTags->"TrivialZR"],
Cell[138437, 6248, 261, 9, 15, "Index",
  CellTags->"TwistedZ"],
Cell[138701, 6259, 228, 9, 15, "Index",
  CellTags->"Types of Structures"],
Cell[138932, 6270, 247, 9, 15, "Index",
  CellTags->"U"],
Cell[139182, 6281, 232, 9, 15, "Index",
  CellTags->"UnitQ"],
Cell[139417, 6292, 235, 9, 15, "Index",
  CellTags->"UnitQ"],
Cell[139655, 6303, 224, 9, 15, "Index",
  CellTags->"UnitQ"],
Cell[139882, 6314, 235, 9, 15, "Index",
  CellTags->"Unity"],
Cell[140120, 6325, 236, 9, 15, "Index",
  CellTags->"Unity"],
Cell[140359, 6336, 221, 9, 15, "Index",
  CellTags->"Unity"],
Cell[140583, 6347, 226, 9, 15, "Index",
  CellTags->"UnityQ"],
Cell[140812, 6358, 210, 9, 15, "Index",
  CellTags->"UT"],
Cell[141025, 6369, 226, 9, 15, "Index",
  CellTags->"UT"],
Cell[141254, 6380, 212, 9, 15, "Index",
  CellTags->"UTD"],
Cell[141469, 6391, 228, 9, 15, "Index",
  CellTags->"UTD"],
Cell[141700, 6402, 255, 9, 15, "Index",
  CellTags->"Variables"],
Cell[141958, 6413, 218, 9, 15, "Index",
  CellTags->"VarToUse"],
Cell[142179, 6424, 249, 9, 15, "Index",
  CellTags->"Well-defined Operation"],
Cell[142431, 6435, 224, 9, 15, "Index",
  CellTags->"WideElements"],
Cell[142658, 6446, 221, 9, 15, "Index",
  CellTags->"WideElements"],
Cell[142882, 6457, 245, 9, 15, "Index",
  CellTags->"WithUnityQ"],
Cell[143130, 6468, 234, 9, 15, "Index",
  CellTags->"WithUnityQ"],
Cell[143367, 6479, 246, 9, 15, "Index",
  CellTags->"WithUnityQ"],
Cell[143616, 6490, 241, 9, 15, "Index",
  CellTags->"WithUnityQ"],
Cell[143860, 6501, 244, 9, 15, "Index",
  CellTags->"Z"],
Cell[144107, 6512, 247, 9, 15, "Index",
  CellTags->"Z"],
Cell[144357, 6523, 199, 9, 15, "Index",
  CellTags->"Z"],
Cell[144559, 6534, 234, 9, 15, "Index",
  CellTags->"Z"],
Cell[144796, 6545, 233, 9, 15, "Index",
  CellTags->"Zero"],
Cell[145032, 6556, 222, 9, 15, "Index",
  CellTags->"Zero"],
Cell[145257, 6567, 234, 9, 15, "Index",
  CellTags->"Zero"],
Cell[145494, 6578, 207, 9, 15, "Index",
  CellTags->"Zero"],
Cell[145704, 6589, 249, 9, 15, "Index",
  CellTags->"ZeroDivisorQ"],
Cell[145956, 6600, 238, 9, 15, "Index",
  CellTags->"ZeroDivisorQ"],
Cell[146197, 6611, 232, 9, 15, "Index",
  CellTags->"Zeros"],
Cell[146432, 6622, 249, 9, 15, "Index",
  CellTags->"ZG"],
Cell[146684, 6633, 216, 9, 15, "Index",
  CellTags->"ZMap"],
Cell[146903, 6644, 201, 9, 15, "Index",
  CellTags->"ZR"],
Cell[147107, 6655, 249, 9, 15, "Index",
  CellTags->"Zx"],
Cell[147359, 6666, 233, 9, 15, "Index",
  CellTags->"StyleBox[Indeterminate, MR]"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

