(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28143,        832]*)
(*NotebookOutlinePosition[     32263,        938]*)
(*  CellTagsIndexPosition[     31936,        925]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Table of Contents", "Title",
  CellTags->"Contents"],

Cell[CellGroupData[{

Cell["Introduction to AbstractAlgebra", "Section",
  CellTags->{"Contents", "IntroContents"}],

Cell[TextData[{
  ButtonBox["1.0 Read me first",
    ButtonData:>{"READ ME FIRST", "READ ME FIRST"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["Introduction",
    ButtonData:>{"Introduction to AbstractAlgebra", 
      "Introduction to AbstractAlgebra"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["1.1 Packages in AbstractAlgebra",
    ButtonData:>{"Packages in AbstractAlgebra", 
      "Packages in AbstractAlgebra"},
    ButtonStyle->"AddOnsLink"],
  "\n1.2 Basic structures used in AbstractAlgebra\n\t",
  ButtonBox["1.2.1 Overview",
    ButtonData:>{"Overview of Structures", "Overview of Structures"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["1.2.2 How to form Groupoids, Ringoids and Morphoids",
    ButtonData:>{"How to form Structures", "How to form Structures"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["1.3 How to use a Mode",
    ButtonData:>{"How to use a Mode", "How to use a Mode"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["1.4 Using Visual mode with \"large\" elements",
    ButtonData:>{"Visual mode with large elements", 
      "Visual mode with large elements"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["1.5 How to change the Structure",
    ButtonData:>{"Changing the DefaultStructure", 
      "Changing the DefaultStructure"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"Contents", "IntroContents"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Groupoids", "Section",
  CellTags->{"Contents", "GroupoidsContents"}],

Cell[TextData[{
  ButtonBox["2.0 READ ME FIRST",
    ButtonData:>{"Groupoids-READ ME FIRST", "Groupoids-READ ME FIRST"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.1 Forming Groupoids",
    ButtonData:>{"FormGroupoid", "FormGroupoid"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.1.1 FormGroupoid",
    ButtonData:>{"FormGroupoid", "FormGroupoid"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.1.2 GenerateGroupoid",
    ButtonData:>{"GenerateGroupoid", "GenerateGroupoid"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.1.3 FormGroupoidByTable",
    ButtonData:>{"FormGroupoidByTable", "FormGroupoidByTable"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.1.4 FormGroupoidFromCycles and RandomGroupoid",
    ButtonData:>{"FormGroupoidFromCycles and RandomGroupoid", 
      "FormGroupoidFromCycles and RandomGroupoid"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.2 The Structure of Groupoids",
    ButtonData:>{"Structure of Groupoids", "Structure of Groupoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.3 Testing the Defining Properties of a Group",
    ButtonData:>{"The four standard functions", 
      "The four standard functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.3.1 The four standard functions",
    ButtonData:>{"The four standard functions", 
      "The four standard functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.3.2 Related functions",
    ButtonData:>{"Related functions", "Related functions"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.4 Built-in Groupoids",
    ButtonData:>{"Groupoids based on the integers mod n", 
      "Groupoids based on the integers mod n"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.4.1 Groupoids based on the integers mod n",
    ButtonData:>{"Groupoids based on the integers mod n", 
      "Groupoids based on the integers mod n"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.4.2 Other numeric groupoids",
    ButtonData:>{"Other numeric groupoids", "Other numeric groupoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.4.3 Groups of permutations",
    ButtonData:>{"Groups of permutations", "Groups of permutations"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.4.4 Dihedral and Cyclic groups",
    ButtonData:>{"Dihedral and Cyclic groups", "Dihedral and Cyclic groups"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.4.5 Other groupoids",
    ButtonData:>{"Other groupoids", "Other groupoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.5 Uses of the Cayley table",
    ButtonData:>{"Cayley tables", "Cayley tables"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.6 Building other structures",
    ButtonData:>{"Direct products", "Direct products"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["\t2.6.1 Direct products",
    ButtonData:>{"Direct products", "Direct products"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.6.2 Subgroups",
    ButtonData:>{"Subgroups", "Subgroups"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["2.6.3 Quotient groups",
    ButtonData:>{"Quotient groups", "Quotient groups"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["2.7 Other group properties",
    ButtonData:>{"Other group properties", "Other group properties"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"GroupoidsContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ringoids", "Section",
  CellTags->{"Contents", "RingoidContents"}],

Cell[TextData[{
  ButtonBox["3.0 READ ME FIRST",
    ButtonData:>{"Ringoids-READ ME FIRST", "READ ME FIRST"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.1 Forming Ringoids",
    ButtonData:>{"FormRingoid", "FormRingoid"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.2 The Structure of Ringoids",
    ButtonData:>{"Basic functions", "Basic functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.2.1 Basic functions",
    ButtonData:>{"Basic functions", "Basic functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.2.2 Related functions",
    ButtonData:>{"Related functions", "Related functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.2.3 Groupoids from ringoids",
    ButtonData:>{"Groupoids from ringoids", "Groupoids from ringoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.3 Testing Properties of Ringoids",
    ButtonData:>{"Additive properties", "Additive properties"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.1 Additive properties",
    ButtonData:>{"Additive properties", "Additive properties"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.2 Multiplicative properties",
    ButtonData:>{"Multiplicative properties", "Multiplicative properties"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.3 Distributive property",
    ButtonData:>{"Distributive property", "Distributive property"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.4 RingQ test",
    ButtonData:>{"RingQ test", "RingQ test"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.5 Specialized rings",
    ButtonData:>{"Specialized rings", "Specialized rings"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.6 Closure of subsets",
    ButtonData:>{"Closure of subsets", "Closure of subsets"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.3.7 Testing other properties",
    ButtonData:>{"Testing other properties", "Testing other properties"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.4 Built-in Ringoids",
    ButtonData:>{"Numeric Rings", "Numeric Rings"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.4.1 Numeric Rings",
    ButtonData:>{"Numeric Rings", "Numeric Rings"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.4.2 Other Rings",
    ButtonData:>{"Other Rings", "Other Rings"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.5 Using Cayley tables ",
    ButtonData:>{"Using Cayley tables ", "Using Cayley tables "},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.6 Building Other Structures",
    ButtonData:>{"Direct Products", "Direct Products"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.6.1 Direct Products",
    ButtonData:>{"Direct Products", "Direct Products"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.6.2 Subrings and ideals",
    ButtonData:>{"Subrings and ideals", "Subrings and ideals"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.6.3 Quotient Rings",
    ButtonData:>{"Quotient Rings", "Quotient Rings"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.7 Extension ringoids",
    ButtonData:>{"Extension ringoids", "Extension ringoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.8 Polynomials over a Ringoid",
    ButtonData:>{"Forming polynomials", "Forming polynomials"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.1 Forming polynomials",
    ButtonData:>{"Forming polynomials", "Forming polynomials"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.2 Random polynomials",
    ButtonData:>{"Random polynomials", "Random polynomials"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.3 Polynomial arithmetic",
    ButtonData:>{"Polynomial arithmetic", "Polynomial arithmetic"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.4 Polynomial Quotient Rings",
    ButtonData:>{"Polynomial Quotient Rings", "Polynomial Quotient Rings"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.5 Irreducibility of Polynomials",
    ButtonData:>{"Irreducibility of Polynomials", 
      "Irreducibility of Polynomials"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.6 Solving Equations, Evaluation",
    ButtonData:>{"Solving Equations, Evaluation", 
      "Solving Equations, Evaluation"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.7 Extensions of Standard Mathematica",
    ButtonData:>{"Extensions of Stnrd Mathematica", 
      "Extensions of Stnrd Mathematica"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.8.8 Miscellaneous functions",
    ButtonData:>{"Miscellaneous functions", "Miscellaneous functions"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.9 Matrices over a Ringoid",
    ButtonData:>{"MatricesOver", "MatricesOver"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.9.1 Individual matrices",
    ButtonData:>{"Individual matrices", "Individual matrices"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.9.2 Matrix arithmetic",
    ButtonData:>{"Matrix arithmetic", "Matrix arithmetic"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.9.3 Determinants & inverses",
    ButtonData:>{"Determinants & inverses", "Determinants & inverses"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.9.4 Matrix ringoids",
    ButtonData:>{"Matrix ringoids", "Matrix ringoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.9.5 Matrix groupoids",
    ButtonData:>{"Matrix groupoids", "Matrix groupoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.9.6 Miscellaneous matrix functions",
    ButtonData:>{"Miscellaneous matrix functions", 
      "Miscellaneous matrix functions"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.10 Function Extensions",
    ButtonData:>{"Function Extensions", "Function Extensions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.10.1 Function Arithmetic",
    ButtonData:>{"Function Arithmetic", "Function Arithmetic"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["3.10.2 Polynomial Conversion, Interpolation",
    ButtonData:>{"Polynomial Conversion, Interpolation", 
      "Polynomial Conversion, Interpolation"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["3.11 Finite fields",
    ButtonData:>{"Finite fields", "Finite fields"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"RingoidContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Morphoids", "Section",
  CellTags->{"Contents", "MorphoidContents"}],

Cell[TextData[{
  ButtonBox["4.0 READ ME FIRST",
    ButtonData:>{"Morphoids-READ ME FIRST", "Morphoids-READ ME FIRST"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.1 Forming Morphoids",
    ButtonData:>{"Forming Morphoids", "Forming Morphoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.2 The structure of Morphoids",
    ButtonData:>{"The structure of Morphoids", "The structure of Morphoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.3 Built-in Morphoids",
    ButtonData:>{"Built-in Morphoids", "Built-in Morphoids"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.4 Properties",
    ButtonData:>{"Properties", "Properties"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.5 Kernel, Image, and InverseImage(s)",
    ButtonData:>{"Kernel, Image, and InverseImage(s)", 
      "Kernel, Image, and InverseImage(s)"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.6 Automorphisms",
    ButtonData:>{"Automorphisms", "Automorphisms"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["4.7 Visualizing Morphoids",
    ButtonData:>{"Visualizing Morphoids", "Visualizing Morphoids"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"MorphoidContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Additional Functionality", "Section",
  CellTags->{"Contents", "AdditionalContents"}],

Cell[TextData[{
  ButtonBox["5.0 READ ME FIRST",
    ButtonData:>{"Additional-READ ME FIRST", "Additional-READ ME FIRST"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["5.1 Global variables and options",
    ButtonData:>{"Global variables and options", 
      "Global variables and options"},
    ButtonStyle->"AddOnsLink"],
  "\n5.2 Permutations\n\t",
  ButtonBox["5.2.1 Introduction",
    ButtonData:>{"Introduction to Permutations", 
      "Introduction to Permutations"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.2.2 Permutation operations",
    ButtonData:>{"Permutation operations", "Permutation operations"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.2.3 Representing permutations",
    ButtonData:>{"Representing permutations", "Representing permutations"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.2.4 Cycles",
    ButtonData:>{"Cycles", "Cycles"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.2.5 Cycle operations",
    ButtonData:>{"Cycle operations", "Cycle operations"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.2.6 Other cycle-related functions",
    ButtonData:>{"Other cycle-related functions", 
      "Other cycle-related functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.2.7 Stabilizers and orbits",
    ButtonData:>{"Stabilizers and orbits", "Stabilizers and orbits"},
    ButtonStyle->"AddOnsLink"],
  "\n5.3   Working with ",
  Cell[BoxData[
      \(TraditionalForm\`Z[\@d]\)]],
  "\n\t",
  ButtonBox["5.3.1 Basic functions",
    ButtonData:>{"Basic functions", "Basic functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.3.2 Divisibility",
    ButtonData:>{"Divisibility", "Divisibility"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.3.3 Norm-related functions",
    ButtonData:>{"Norm-related functions", "Norm-related functions"},
    ButtonStyle->"AddOnsLink"],
  "\n5.4 Miscellaneous Functions\n\t",
  ButtonBox["5.4.1 Working with lists",
    ButtonData:>{"Working with lists", "Working with lists"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.4.2 Working with graphics",
    ButtonData:>{"Working with graphics", "Working with graphics"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.4.3 Adjoin",
    ButtonData:>{"Adjoin", "Adjoin"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.4.4 Disguising groups and rings",
    ButtonData:>{"Disguising groups and rings", 
      "Disguising groups and rings"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.4.5 A look at some functions in LabCode",
    ButtonData:>{"A look at some functions in LabCode", 
      "A look at some functions in LabCode"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["5.4.6 Potpourri",
    ButtonData:>{"Potpourri", "Potpourri"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"AdditionalContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Appendices", "Section",
  CellTags->{"AppendicesContents", "Contents"}],

Cell[TextData[{
  "Installation Instructions\n\t",
  ButtonBox["6.1.1 Version 3.0 or higher",
    ButtonData:>{"Install-Version 3.0 or higher", 
      "Install-Version 3.0 or higher"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["6.1.2 Version 2.x under Windows",
    ButtonData:>{"Install-Version 2.x under Windows", 
      "Install-Version 2.x under Windows"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["6.1.3 Version 2.x under other platforms",
    ButtonData:>{"Install-Version 2.x under other platforms", 
      "Install-Version 2.x under other platforms"},
    ButtonStyle->"AddOnsLink"],
  "\nVersion-Specific Notes\n\t",
  ButtonBox["6.2.1 Version 3.0 or higher",
    ButtonData:>{"Version 3.0 or higher", "Version 3.0 or higher"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["6.2.2 Version 2.x under Windows",
    ButtonData:>{"Version 2.x under Windows", "Version 2.x under Windows"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["6.2.3 Version 2.x under other platforms",
    ButtonData:>{"Version 2.x under other platforms", 
      "Version 2.x under other platforms"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["6.3 Relevant References",
    ButtonData:>{"Refs", "Refs"},
    ButtonStyle->"AddOnsLink"],
  "\nObjects In AbstractAlgebra\n\t",
  ButtonBox["6.4.1 Alphabetically",
    ButtonData:>{"Alphabetically", "Alphabetically"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["6.4.2 By Packages",
    ButtonData:>{"By Packages", "By Packages"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.1 Core",
    ButtonData:>{"By Packages", "Core"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.2 FiniteFields",
    ButtonData:>{"By Packages", "FiniteFields"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.3 Groupoids",
    ButtonData:>{"By Packages", "Groupoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.4 GroupProperties",
    ButtonData:>{"By Packages", "GroupProperties"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.5 Joint",
    ButtonData:>{"By Packages", "Joint"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.6 LabCode",
    ButtonData:>{"By Packages", "LabCode"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.7 Matrices",
    ButtonData:>{"By Packages", "Matrices"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.8 Morphisms",
    ButtonData:>{"By Packages", "Morphisms"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.9 Permutations",
    ButtonData:>{"By Packages", "Permutations"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.10 RingExtensions",
    ButtonData:>{"By Packages", "RingExtensions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.11 Ringoids",
    ButtonData:>{"By Packages", "Ringoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.12 RingProperties",
    ButtonData:>{"By Packages", "RingProperties"},
    ButtonStyle->"AddOnsLink"],
  "\n\t\t",
  ButtonBox["6.4.2.13 Zd",
    ButtonData:>{"By Packages", "Zd"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["6.4.3 Extended from standard",
    ButtonData:>{"Extended from standard", "Extended from standard"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"AppendicesContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["EAAM Information", "Section",
  CellTags->{"Contents", "EAAMInfoContents"}],

Cell[TextData[{
  ButtonBox["7.1 Overview of EAAM",
    ButtonData:>{"Overview of EAAM", "Overview of EAAM"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["7.2 Summaries of group labs",
    ButtonData:>{"Summaries of group labs", "Summaries of group labs"},
    ButtonStyle->"AddOnsLink"],
  "\n7.3 Contents of group labs\n\t",
  ButtonBox["7.3.0 READ FIRST - Grp Lab Contents",
    ButtonData:>{"READ FIRST - Grp Lab Contents", 
      "READ FIRST - Grp Lab Contents"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.1 Group Lab 1",
    ButtonData:>{"Group Lab 1", "Group Lab 1"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.2 Group Lab 2",
    ButtonData:>{"Group Lab 2", "Group Lab 2"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.3 Group Lab 3",
    ButtonData:>{"Group Lab 3", "Group Lab 3"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.4 Group Lab 4",
    ButtonData:>{"Group Lab 4", "Group Lab 4"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.5 Group Lab 5",
    ButtonData:>{"Group Lab 5", "Group Lab 5"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.6 Group Lab 6",
    ButtonData:>{"Group Lab 6", "Group Lab 6"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.7 Group Lab 7",
    ButtonData:>{"Group Lab 7", "Group Lab 7"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.8 Group Lab 8",
    ButtonData:>{"Group Lab 8", "Group Lab 8"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.9 Group Lab 9",
    ButtonData:>{"Group Lab 9", "Group Lab 9"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.10 Group Lab 10",
    ButtonData:>{"Group Lab 10", "Group Lab 10"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.11 Group Lab 11",
    ButtonData:>{"Group Lab 11", "Group Lab 11"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.12 Group Lab 12",
    ButtonData:>{"Group Lab 12", "Group Lab 12"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.13 Group Lab 13",
    ButtonData:>{"Group Lab 13", "Group Lab 13"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.3.14 Group Lab 14",
    ButtonData:>{"Group Lab 14", "Group Lab 14"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  ButtonBox["7.4 Summaries of ring labs",
    ButtonData:>{"Summaries of ring labs", "Summaries of ring labs"},
    ButtonStyle->"AddOnsLink"],
  "\n7.5 Contents of ring labs\n\t",
  ButtonBox["7.5.0 READ FIRST - Rng Lab Contents",
    ButtonData:>{"READ FIRST - Rng Lab Contents", 
      "READ FIRST - Rng Lab Contents"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.1 Ring Lab 1",
    ButtonData:>{"Ring Lab 1", "Ring Lab 1"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.2 Ring Lab 2",
    ButtonData:>{"Ring Lab 2", "Ring Lab 2"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.3 Ring Lab 3",
    ButtonData:>{"Ring Lab 3", "Ring Lab 3"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.4 Ring Lab 4",
    ButtonData:>{"Ring Lab 4", "Ring Lab 4"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.5 Ring Lab 5",
    ButtonData:>{"Ring Lab 5", "Ring Lab 5"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.6 Ring Lab 6",
    ButtonData:>{"Ring Lab 6", "Ring Lab 6"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.7 Ring Lab 7",
    ButtonData:>{"Ring Lab 7", "Ring Lab 7"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.8 Ring Lab 8",
    ButtonData:>{"Ring Lab 8", "Ring Lab 8"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.9 Ring Lab 9",
    ButtonData:>{"Ring Lab 9", "Ring Lab 9"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.10 Ring Lab 10",
    ButtonData:>{"Ring Lab 10", "Ring Lab 10"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.11 Ring Lab 11",
    ButtonData:>{"Ring Lab 11", "Ring Lab 11"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.12 Ring Lab 12",
    ButtonData:>{"Ring Lab 12", "Ring Lab 12"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.5.13 Ring Lab 13",
    ButtonData:>{"Ring Lab 13", "Ring Lab 13"},
    ButtonStyle->"AddOnsLink"],
  "\n",
  "7.6 Palettes for EAAM",
  "\n\t",
  ButtonBox["7.6.1 Palette introduction",
    ButtonData:>{"Palette introduction", "Palette introduction"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.2 AbstractAlgebra",
    ButtonData:>{"AbstractAlgebra", "AbstractAlgebra"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.3 Groupoids",
    ButtonData:>{"Groupoids", "Groupoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.4 Ringoids and Morphoids",
    ButtonData:>{"Ringoids and Morphoids", "Ringoids and Morphoids"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.5 General AbstractAlgebra functions",
    ButtonData:>{"General AbstractAlgebra functions", 
      "General AbstractAlgebra functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.6 Group functions",
    ButtonData:>{"Group functions", "Group functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.7 Permutation functions",
    ButtonData:>{"Permutation functions", "Permutation functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.8 Morphism functions",
    ButtonData:>{"Morphism functions", "Morphism functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.9 Ring functions",
    ButtonData:>{"Ring functions", "Ring functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.10 Polynomial functions",
    ButtonData:>{"Polynomial functions", "Polynomial functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.11 Matrix functions",
    ButtonData:>{"Matrix functions", "Matrix functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.12 Galois field functions",
    ButtonData:>{"Galois field functions", "Galois field functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.13 Z[Sqrt[d]] functions",
    ButtonData:>{"Z[Sqrt[d]] functions", "Z[Sqrt[d]] functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.14 Group (ring) properties",
    ButtonData:>{"Group (ring) properties", "Group (ring) properties"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.15 All AbstractAlgebra functions",
    ButtonData:>{"All AbstractAlgebra functions", 
      "All AbstractAlgebra functions"},
    ButtonStyle->"AddOnsLink"],
  "\n\t",
  ButtonBox["7.6.16 Group Lab Two",
    ButtonData:>{"Group Lab Two", "Group Lab Two"},
    ButtonStyle->"AddOnsLink"]
}], "Text",
  CellTags->{"Contents", "EAAMInfoContents"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"AllBrackets",
WindowSize->{436, 373},
WindowMargins->{{7, Automatic}, {17, Automatic}},
ShowCellTags->True,
StyleDefinitions -> "Manual.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Contents"->{
    Cell[1731, 51, 58, 1, 110, "Title",
      CellTags->"Contents"],
    Cell[1814, 56, 93, 1, 80, "Section",
      CellTags->{"Contents", "IntroContents"}],
    Cell[1910, 59, 1401, 37, 253, "Text",
      CellTags->{"Contents", "IntroContents"}],
    Cell[3348, 101, 75, 1, 80, "Section",
      CellTags->{"Contents", "GroupoidsContents"}],
    Cell[3426, 104, 3459, 94, 554, "Text",
      CellTags->{"GroupoidsContents", "Contents"}],
    Cell[6922, 203, 72, 1, 80, "Section",
      CellTags->{"Contents", "RingoidContents"}],
    Cell[6997, 206, 6448, 178, 1066, "Text",
      CellTags->{"RingoidContents", "Contents"}],
    Cell[13482, 389, 74, 1, 80, "Section",
      CellTags->{"Contents", "MorphoidContents"}],
    Cell[13559, 392, 1235, 34, 213, "Text",
      CellTags->{"MorphoidContents", "Contents"}],
    Cell[14831, 431, 91, 1, 80, "Section",
      CellTags->{"Contents", "AdditionalContents"}],
    Cell[14925, 434, 2908, 81, 530, "Text",
      CellTags->{"AdditionalContents", "Contents"}],
    Cell[17870, 520, 77, 1, 80, "Section",
      CellTags->{"AppendicesContents", "Contents"}],
    Cell[17950, 523, 3372, 98, 652, "Text",
      CellTags->{"AppendicesContents", "Contents"}],
    Cell[21359, 626, 81, 1, 80, "Section",
      CellTags->{"Contents", "EAAMInfoContents"}],
    Cell[21443, 629, 6672, 199, 1261, "Text",
      CellTags->{"Contents", "EAAMInfoContents"}]},
  "IntroContents"->{
    Cell[1814, 56, 93, 1, 80, "Section",
      CellTags->{"Contents", "IntroContents"}],
    Cell[1910, 59, 1401, 37, 253, "Text",
      CellTags->{"Contents", "IntroContents"}]},
  "GroupoidsContents"->{
    Cell[3348, 101, 75, 1, 80, "Section",
      CellTags->{"Contents", "GroupoidsContents"}],
    Cell[3426, 104, 3459, 94, 554, "Text",
      CellTags->{"GroupoidsContents", "Contents"}]},
  "RingoidContents"->{
    Cell[6922, 203, 72, 1, 80, "Section",
      CellTags->{"Contents", "RingoidContents"}],
    Cell[6997, 206, 6448, 178, 1066, "Text",
      CellTags->{"RingoidContents", "Contents"}]},
  "MorphoidContents"->{
    Cell[13482, 389, 74, 1, 80, "Section",
      CellTags->{"Contents", "MorphoidContents"}],
    Cell[13559, 392, 1235, 34, 213, "Text",
      CellTags->{"MorphoidContents", "Contents"}]},
  "AdditionalContents"->{
    Cell[14831, 431, 91, 1, 80, "Section",
      CellTags->{"Contents", "AdditionalContents"}],
    Cell[14925, 434, 2908, 81, 530, "Text",
      CellTags->{"AdditionalContents", "Contents"}]},
  "AppendicesContents"->{
    Cell[17870, 520, 77, 1, 80, "Section",
      CellTags->{"AppendicesContents", "Contents"}],
    Cell[17950, 523, 3372, 98, 652, "Text",
      CellTags->{"AppendicesContents", "Contents"}]},
  "EAAMInfoContents"->{
    Cell[21359, 626, 81, 1, 80, "Section",
      CellTags->{"Contents", "EAAMInfoContents"}],
    Cell[21443, 629, 6672, 199, 1261, "Text",
      CellTags->{"Contents", "EAAMInfoContents"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Contents", 29023, 855},
  {"IntroContents", 30435, 886},
  {"GroupoidsContents", 30640, 891},
  {"RingoidContents", 30853, 896},
  {"MorphoidContents", 31065, 901},
  {"AdditionalContents", 31281, 906},
  {"AppendicesContents", 31501, 911},
  {"EAAMInfoContents", 31719, 916}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 58, 1, 110, "Title",
  CellTags->"Contents"],

Cell[CellGroupData[{
Cell[1814, 56, 93, 1, 80, "Section",
  CellTags->{"Contents", "IntroContents"}],
Cell[1910, 59, 1401, 37, 253, "Text",
  CellTags->{"Contents", "IntroContents"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3348, 101, 75, 1, 80, "Section",
  CellTags->{"Contents", "GroupoidsContents"}],
Cell[3426, 104, 3459, 94, 554, "Text",
  CellTags->{"GroupoidsContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6922, 203, 72, 1, 80, "Section",
  CellTags->{"Contents", "RingoidContents"}],
Cell[6997, 206, 6448, 178, 1066, "Text",
  CellTags->{"RingoidContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13482, 389, 74, 1, 80, "Section",
  CellTags->{"Contents", "MorphoidContents"}],
Cell[13559, 392, 1235, 34, 213, "Text",
  CellTags->{"MorphoidContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14831, 431, 91, 1, 80, "Section",
  CellTags->{"Contents", "AdditionalContents"}],
Cell[14925, 434, 2908, 81, 530, "Text",
  CellTags->{"AdditionalContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17870, 520, 77, 1, 80, "Section",
  CellTags->{"AppendicesContents", "Contents"}],
Cell[17950, 523, 3372, 98, 652, "Text",
  CellTags->{"AppendicesContents", "Contents"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21359, 626, 81, 1, 80, "Section",
  CellTags->{"Contents", "EAAMInfoContents"}],
Cell[21443, 629, 6672, 199, 1261, "Text",
  CellTags->{"Contents", "EAAMInfoContents"}]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

