(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    817400,      19574]*)
(*NotebookOutlinePosition[    842497,      20245]*)
(*  CellTagsIndexPosition[    841456,      20204]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  "Chapter 2\n",
  StyleBox["Groupoids",
    FontFamily->"Courier"]
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell["2.4 Built-in groupoids", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->{"i:1", "Integers"}],

Cell["\<\
Although you are encouraged to try to build your own groupoids, \
there is a wide variety that are predefined and can be created with a few \
keystrokes.\
\>", "Text",
  CellTags->"Integers"],

Cell[TextData[{
  "2.4.1 Groupoids based on the integers mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]]
}], "Subsubsection",
  CellTags->{"i:2", "Integers"}],

Cell[TextData[{
  "One of the simplest groups is ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", the group of integers under addition mod ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "Text",
  CellTags->"Integers"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((or\ ring)\),
                  SingleLetterItalics->False], " ", 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["integers",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\({0, \ 1, \ 2, \ \[Ellipsis], \ \),
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"], 
                StyleBox[\(\ \(-\ 1\)}\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["under",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["addition",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["mod",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"], 
                  RowBox[{"(", 
                    RowBox[{"and", " ", "multiplication", " ", "mod", 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["n",
                        FontSlant->"Italic"]}], ")"}]}], ",", 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["when",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["DefaultStructure",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["set",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Group",
                  "MR"], " ", 
                RowBox[{"(", 
                  StyleBox["Ring",
                    "MR"], ")"}]}]}]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Structure\  \[Rule] \ Group\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                
                StyleBox[
                  \(group\ of\ integers\ 
                    \({0, \ 1, \ 2, \ \[Ellipsis], \ \)\),
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"], 
                StyleBox[\(\ \(-\ 1\)}\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["under",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["addition",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["mod",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Structure\  \[Rule] \ Ring\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                
                StyleBox[
                  \(ring\ of\ integers\ 
                    \({0, \ 1, \ 2, \ \[Ellipsis], \ \)\),
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"], 
                StyleBox[\(\ \(-\ 1\)}\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["under",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["addition",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["mod",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["ZG",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Z",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["n",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox[
                        FormBox[
                          StyleBox[\(Structure\  \[Rule] \ Group\),
                            "MR",
                            SingleLetterItalics->False],
                          "TraditionalForm"],
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZR",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Z",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["n",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox[
                        FormBox[
                          StyleBox[\(Structure\  \[Rule] \ Ring\),
                            "MR",
                            SingleLetterItalics->False],
                          "TraditionalForm"],
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{\(n\_1\), 
                      StyleBox[",",
                        "MR"], " ", \(n\_2\), 
                      StyleBox[",",
                        "MR"], " ", "\[Ellipsis]", 
                      StyleBox[",",
                        "MR"], " ", \(n\_k\)}], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ {Z[\),
                  SingleLetterItalics->False], 
                FormBox[\(n\_1\),
                  "TraditionalForm"], 
                StyleBox[\(], \ \(Z[\)\),
                  SingleLetterItalics->False], 
                FormBox[\(n\_2\),
                  "TraditionalForm"], 
                StyleBox[\(], \ \[Ellipsis], \ \(Z[\)\),
                  SingleLetterItalics->False], 
                FormBox[\(n\_k\),
                  "TraditionalForm"], 
                StyleBox[\(]}\),
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"i:3", "Integers"}],

Cell[TextData[{
  "The ",
  StyleBox["Z",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"Integers"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " can be viewed either as a group or as a ring, the current value of the \
global variable ",
  StyleBox["DefaultStructure", "MR"],
  " specifies the interpretation."
}], "Text",
  CellTags->"Integers"],

Cell[TextData[{
  "Since the current value of ",
  StyleBox["DefaultStructure", "MR"],
  " is ",
  StyleBox["Group", "MR"],
  ", ",
  StyleBox["Z[5]", "MR"],
  " returns the group rather than the ring."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({DefaultStructure, \ Z[5]}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({Group, Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&]}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "The current structure can be overridden by explicitly specifying the \
intended ",
  StyleBox["Structure", "MR"],
  "."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[5, \ Structure\  \[Rule] \ Ring]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \(Ringoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&, Mod[#1\ #2, 5]&]\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "As shortcuts, ",
  StyleBox["ZG", "MR"],
  " and ",
  StyleBox["ZR", "MR"],
  " return ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " as a group and a ring respectively, independent of the current value of ",
  
  StyleBox["DefaultStructure", "MR"],
  "."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ZG[5], \ ZR[5]}\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({Groupoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&], 
      Ringoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&, Mod[#1\ #2, 5]&]}\)], 
  "Output",
  CellLabel->"Out[3]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "There are two variations on the ",
  StyleBox["Z", "MR"],
  " function, ",
  StyleBox["Z[n, k]", "MR"],
  " and ",
  StyleBox["Z[n, I]", "MR"],
  ". In both cases, the result depends on the value of ",
  StyleBox["DefaultStructure", "MR"],
  " but can be overridden by the ",
  StyleBox["Structure", "MR"],
  " option."
}], "Text",
  CellTags->{"i:4", "Integers"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox[\(if\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["k",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ is\ a\ divisor\ of\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["n",
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["group",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[\((ring)\),
                      SingleLetterItalics->False], " ", 
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["integers",
                      SingleLetterItalics->False]}]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], "\n", 
                RowBox[{
                  StyleBox[
                    FormBox[
                      RowBox[{
                        RowBox[{
                          RowBox[{"{", 
                            RowBox[{
                              StyleBox["0",
                                SingleLetterItalics->False], ",", " ", 
                              StyleBox["k",
                                SingleLetterItalics->False,
                                FontSlant->"Italic"], ",", " ", 
                              RowBox[{
                                StyleBox["2",
                                  SingleLetterItalics->False], 
                                StyleBox["k",
                                  SingleLetterItalics->False,
                                  FontSlant->"Italic"]}], ",", " ", 
                              StyleBox["\[Ellipsis]",
                                SingleLetterItalics->False], ",", " ", 
                              RowBox[{
                                FormBox[
                                  RowBox[{
                                    StyleBox["(",
                                      SingleLetterItalics->False], 
                                    \(n\/k\)}],
                                  "TraditionalForm"], " ", 
                                StyleBox["-",
                                  SingleLetterItalics->False], " ", 
                                StyleBox["1",
                                  SingleLetterItalics->False]}]}], 
                            StyleBox[")",
                              SingleLetterItalics->False]}], 
                          StyleBox["k",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"]}], "}"}],
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["under",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["addition",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["mod",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["n",
                      "TraditionalForm"],
                    "Text"], " ", 
                  RowBox[{"(", 
                    RowBox[{"and", " ", "multiplication", " ", "mod", 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["n",
                        FontSlant->"Italic"]}], ")"}]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["I",
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["Gaussian",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  FormBox[
                    StyleBox[
                      FormBox[
                        RowBox[{
                          StyleBox["{",
                            "MR"], 
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                StyleBox["a",
                                  SingleLetterItalics->False], " ", 
                                StyleBox["+",
                                  "MR",
                                  SingleLetterItalics->False], " ", 
                                StyleBox[\(b\ i\),
                                  SingleLetterItalics->False]}], 
                              StyleBox["|",
                                "MR",
                                SingleLetterItalics->False], " ", 
                              StyleBox["a",
                                SingleLetterItalics->False]}], 
                            StyleBox[",",
                              "MR"], " ", 
                            RowBox[{
                              StyleBox["b",
                                SingleLetterItalics->False], " ", 
                              StyleBox["\[Element]",
                                SingleLetterItalics->False,
                                FontSlant->"Plain"], 
                              StyleBox[" ",
                                FontSlant->"Plain"], 
                              StyleBox[
                                FormBox[
                                  SubscriptBox["\[DoubleStruckCapitalZ]", 
                                    StyleBox["n",
                                      FontSlant->"Italic"]],
                                  "TraditionalForm"],
                                FontSlant->"Plain"]}]}], 
                          StyleBox["}",
                            "MR"]}],
                        "TraditionalForm"],
                      "Text"],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["group",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["or",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], "\n", 
                  StyleBox["ring",
                    "Text"]}], 
                StyleBox[")",
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["under",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["addition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["mod",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                "Text"], 
              RowBox[{"(", 
                RowBox[{"and", " ", "multiplication", " ", "mod", 
                  StyleBox[" ",
                    FontSlant->"Italic"], 
                  StyleBox["n",
                    FontSlant->"Italic"]}], ")"}]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["GaussianIntegers",
                      "MR"], 
                    StyleBox["[",
                      "MR"], "n", 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            StyleBox[
              RowBox[{
                StyleBox["identical",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Z",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["n",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["I",
                        "MR"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox[
                        FormBox[
                          StyleBox[
                            RowBox[{
                              StyleBox["Structure",
                                SingleLetterItalics->False], " ", 
                              StyleBox["\[Rule]",
                                SingleLetterItalics->False], " ", 
                              StyleBox["Ring",
                                SingleLetterItalics->False]}],
                            "MR"],
                          "TraditionalForm"],
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["GaussianIntegersAdditive",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Z",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["n",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["I",
                        "MR"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox[
                        FormBox[
                          StyleBox[
                            RowBox[{
                              StyleBox["Structure",
                                SingleLetterItalics->False], " ", 
                              StyleBox["\[Rule]",
                                SingleLetterItalics->False], " ", 
                              StyleBox["Group",
                                SingleLetterItalics->False]}],
                            "MR"],
                          "TraditionalForm"],
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"i:5", "Integers"}],

Cell[TextData[{
  "Variations of the ",
  StyleBox["Z",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"Integers"],

Cell[TextData[{
  "We can view the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " visually as the elements on an ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-hour clock."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[8, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \("Think of the elements as the numbers on a (modified) clock, where we \
view the last element,  8, as being equivalent to zero. Addition of two \
numbers is just like adding hours on the clock."\)], "Print",
  CellTags->"Integers"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.75901 .75901 Mdot
.8663 .5 Mdot
.75901 .24099 Mdot
.5 .1337 Mdot
.24099 .24099 Mdot
.1337 .5 Mdot
.24099 .75901 Mdot
0 g
gsave
.5 .77473 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.69426 .69426 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.77473 .5 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.69426 .30574 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.5 .22527 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.30574 .30574 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.22527 .5 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.30574 .69426 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(7) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008d01Db>0000R`09C8`0
002:00]<R`0008T03Db:0000R@0=C8X0002800m<R@0008P03db90000Q00014j>CXh?C005STj>CXh0
Q00007`000PnCSi>?ThnCP@03d`50008?ThnCSi>?Til0000N@000hi>SP0<00m<3@000dj>001i0000
M0001Ci>?Thn01003D`@0005?ThnCSh0M@00078000=>SP00500=C1D000>>CXh0LP0006d000E>?Thn
CP0H00]<6@001Ci>?Thn06d0001Z0003CXi>01h02D`O0003STh006X0001X0003?Th002801D`S0003
CSi>06P0001U0003STj>050000=>SP00I@0006<000=>?P00E0000ci>?P1S0000H0000dj>CP1J0003
STh00600001O0003CP0005d000=>0000GP0005h000=>0000G`000dh0001M0000G0000ci>001R0003
CSi>05`0001I0003STj>06P000=>SP00F@0005P000<n0000J`000ch0001G0000E`000hh0001]0003
SP0005H0001E0003CSh0070000<nCP00E@0005@000=>0000L`000dh0001C0000D`000dh0001e0003
CP000580001A0003STh007P000=>SP00D@0004l000=>?P00O0000ci>001?0000CP000dh0001o0003
CP0004d0001<0003?Th0044000?o0000?P000dhn001<0000@P05C0@000>>0000@P000ol000100004
SP0000E<A00004002D`00`0n001000Oo@@000ci<C007C480000o00]<@P001Ol0003o04<02da10000
?P0=C48000Co003o@P0=C400000n00e<@`000ol0o`1200e<@00003d03da20003o`3o04403d`o0000
?@0?C4<00_m100m<?`0003d03da300;o@@0?C3l0000m00m<A0000ol0000o00m<?`0003d03db600m<
?`0003h03Db800e<@00003h03Db800e<@00003l02db:00]<00>>0000?P0003h000<n04`024b<00U<
0P000ch0000m0000?P0014h00005C9001D`40003CP0003d0000m0003CP000:4000=>0000?00003d0
00>>0000X@000hh0000l0000?0000ch0002S0003?P0003/0000k0003SP000:D000>>0000>P0003/0
00=>0000Y@000dh0000j0000>P000dh0002W0003CP0003T0000i0003CP000:T000=>0000>00003P0
00=>00006@05ofX01?lO0003CP0003L0000h0003?P0001h000?o0000J`000ol0000L0003?P0003L0
000g0003SP0001l000?o0000K0000ol0000L0003SP0003H0000f0003?P00020000?o0000K0000ol0
000M0003?P0003D0000e0003SP00024000?o0000K0000ol0000N0003SP0003@0000e0003CP000240
00?o0000J@03ob4000=>0000=00003@000=>00007@05ofd000?o00008@000dh0000c0000=0000ch0
000N0003o`0006/000Go0000o`0R0003?P0003<0000c0003SP0001l000?o0000J`001Ol0003o02<0
00>>0000<P0003<000=>00007`05ofX00olT0003CP000380000b0003CP000;L000=>0000<@000340
00=>0000^@000dh0000`0000<@000hh0002i0003SP000300000`0003?P000;/000<n0000;`000300
00=>0000^`000dh0000_0000;`000dh0002m0003CP0002h0000_0003SP000;d000>>0000;P0002l0
00=>0000_@000dh0000^0000;P000dh0002o0003CP0002d0000^0003?P000;l000<n0000;@0002d0
00>>0000`@000hh0000/0000;@000dh000310003CP0002`0000]0003SP000<4000>>0000;00002`0
00<n0000``000ch0000[0000;0000dh000330003CP0002/0000[0003CP000<D000=>0000:P0002/0
00>>0000a@000hh0000Z0000:`000dh000350003CP0002X0000[0003SP000<D000>>0000:P0002/0
00=>0000a@000dh0000Z0000:P000dh000370003CP0002T0000Z0003?P000<L000<n0000:@0002X0
00=>0000a`000dh0000Y0000:@000dh000390003CP0002P0000Y0003SP000<T000>>0000:00002T0
00=>0000b@000dh0000X0000:@000hh000390003SP0002P0000Y0003CP000<T000=>0000:00002P0
00=>0000b`000dh0000W0000:0000ch0003;0003?P0002L0000W0003SP000<d000>>00009P0002L0
00=>0000c@000dh0000V00009`000hh0003=0003SP0002H0000W0003CP000<d000=>00009P0002L0
00>>0000c@000hh0000V00009`000dh0003=0003CP0002H0000W0003SP000<d000>>00009P0002L0
00=>0000c@000dh0000V00009P000dh0003?0003CP0002D0000V0003?P000<l000<n00009@0002H0
00=>0000c`000dh0000U00009P000ch0003?0003?P0002D0000S00E<cP05C2D0000Q00U<bP09C2<0
000P00]<b00;C280000O00e<aP0=C240000O00e<4P04oiP01OlC00e<8@0001h03d`@0003o`000080
00?o0000U@000ol000020003o`0000l03d`P00007P0?C10000?o00000P000ol0002F0003o`0001<0
3d`P00007P0?C10000?o00000P000ol0002G0003o`0001803d`P00007P0?C1000_l30003o`0009P0
00?o00004@0?C200000N00m<40000ol0o`02oi/000?o00004@0?C200000O00e<4@000ol0002N0003
o`0001403D`Q00007`0=C18000?o0000V@001Ol0003o01<03D`Q0000800;C1@000?o0000V0001Ol0
003o01@02d`R00008@09C1H00onH00?o5P09C2<0000S00E<cP05C2D0000V0003?P000<l000<n0000
9@0002H000=>0000c`000dh0000U00009P000ch0003?0003?P0002D0000V0003CP000<l000=>0000
9@0002L000=>0000c@000dh0000V00009`000hh0003=0003SP0002H0000W0003CP000<d000=>0000
9P0002L000>>0000c@000hh0000V00009`000dh0003=0003CP0002H0000W0003SP000<d000>>0000
9P0002L000=>0000c@000dh0000V00009`000hh0003=0003SP0002H0000X0003?P000</000<n0000
9`0002P000=>0000b`000dh0000W0000:0000ch0003;0003?P0002L0000Y0003SP000<T000>>0000
:00002T000=>0000b@000dh0000X0000:@000hh000390003SP0002P0000Y0003CP000<T000=>0000
:00002T000>>0000b@000hh0000X0000:P000ch000370003?P0002T0000Z0003CP000<L000=>0000
:@0002/000=>0000a@000dh0000Z0000:`000hh000350003SP0002X0000[0003CP000<D000=>0000
:P0002/000>>0000a@000hh0000Z0000:`000dh000350003CP0002X0000/0003CP000<<000=>0000
:`0002`000<n0000``000ch0000[0000;0000dh000330003CP0002/0000]0003CP000<4000=>0000
;00002d000>>0000`@000hh0000/0000;P000ch0002o0003?P0002d0000^0003CP000;l000=>0000
;@0002h000<n0000_`000ch0000]0000;`000hh0002m0003SP0002h0000_0003CP000;d000=>0000
;P00030000=>0000^`000dh0000_0000<0000ch0002k0003?P0002l0000`0003CP000;/000=>0000
;`00034000=>0000^@000dh0000`0000<P000dh0002g0003CP000340000c0003CP000;D000=>0000
<P0003<000>>0000]@000hh0000b0000=0000ch0002c0003?P0003<0000d0003CP0001l000?o0000
K003ob8000=>0000<`0003@000<n00007`000ol0001]0003o`00024000<n0000<`0003D000>>0000
7`000ol0001/0003o`00020000>>0000=00003H000<n00007P000ol0001/0003o`0001l000<n0000
=@0003L000>>00007@000ol0001/0003o`0001h000>>0000=P0003L000=>00007P000ol0001[0003
o`0001h000=>0000=P0003P000=>00007@000ol0001[0003o`0001d000=>0000=`0003T000=>0000
70000ol0001[0003o`0001`000=>0000>00003X000=>00005`000ol000020003o`0006X000?o0000
6`000dh0000i0000>P000ch0000H00GoJ`02oad000<n0000>@0003/000>>0000Y@000hh0000j0000
>`000dh0002U0003CP0003X0000l0003CP000:<000=>0000>`0003d000=>0000X@000dh0000l0000
?@000hh0002Q0003SP0003`0000n0004?P0000E<T005C0@000<n0000?@0003l000>>C4`01db<00U<
00<0SP00?`0003l02db:00]<@@0003h03Db800e<@00003h03Db800e<@00003d03db600m<?`0003d0
3db600m<?`0003d03db600m<?`0003d03da100Co@@0?C3l0000m00m<@0000ol000020003o`0003h0
3d`o0000?P0=C44000?o00000P000ol0000o00e<@00003h03Da10003o`00008000?o0000?`0=C400
000o00]<00<n0000?`000ol000020003o`0004002da10000@009C08000>>CP00?P000ol000020003
o`0003h000=>SP002Da20000@P05C0H000=>?P00?0000ol000020003o`0003`000<nCP001005C4@0
001?0003SP0003X000?o00000P000ol0000k0003SP0004h0001@0003?Th003T000?o00000P000ol0
000i0003CSh00500001B0003CP0003P01?lk0003CP000540001C0003CP0007D000=>0000DP0005@0
00=>SP00LP000hi>001D0000EP000ch0001_0003?P0005D0001G0003SP0006d000>>0000EP0005P0
00<nCP00JP000dhn001H0000FP000dj>CP1V0003STh005X0001M0003CP00064000=>?P00G00005h0
00=>0000G`000dh0001M0000G`000dhn001L0003?Th005l0001Q0003STj>05P000=>SP00H@0006@0
00<nCP00DP000dhnCP1T0000IP000dj>CP1>0003STh006H0001Y0003CSh004P000<nCSh0J@0006/0
00>>CXh07`05C20000=>SP00J`0006h000DnCSi>?P0H00U<6@001DhnCSi>06h0001c0003STh001@0
2d`E0003CXi>07<0001e0005CSi>?Th03`0=C0l000E>?ThnCP1f0000NP000dj>CP0<00e<3@000hi>
001j0000O@0024hnCSi>?Thn0`0?C0@000Q>?ThnCSi>?Wd000250003STj>00m<00B>CXi>Q@0008P0
3db90000R00?C8T0002800m<R@0008T03Db:0000R@0=C8X0002:00]<R`0008/02Db<0000S@05C8h0
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.36502, -1.36502, 0.0095123, 
  0.0095123}},
  CellTags->"Integers"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4, 5, 6, 7}, Mod[#1 + #2, 8]&]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "A variation is to count by multiples of some divisor of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". Here we have the multiples of two."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[8, \ 2]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \(Groupoid[{0, 2, 4, 6}, Mod[#1 + #2, 8]&]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Integers"]
}, Open  ]],

Cell["\<\
Another variation is to consider the Gaussian integers, reduced by \
some modulus. In this example, they are reduced modulo six.\
\>", 
  "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Z[6, I]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \(Groupoid[{0, I, 2\ I, 3\ I, 4\ I, 5\ I, 1, 1 + I, 1 + 2\ I, 1 + 3\ I, 
        1 + 4\ I, 1 + 5\ I, 2, 2 + I, 2 + 2\ I, 2 + 3\ I, 2 + 4\ I, 2 + 5\ I, 
        3, 3 + I, 3 + 2\ I, 3 + 3\ I, 3 + 4\ I, 3 + 5\ I, 4, 4 + I, 4 + 2\ I, 
        4 + 3\ I, 4 + 4\ I, 4 + 5\ I, 5, 5 + I, 5 + 2\ I, 5 + 3\ I, 5 + 4\ I, 
        5 + 5\ I}, "-Operation-"]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Integers"]
}, Open  ]],

Cell["\<\
Note that the elements of these (additive) Gaussian integers reside \
in a square portion of the integer lattice in the complex plane.\
\>", 
  "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Map[{Re[#], \ Im[#]}&, \ Elements[Z[6, \ I]]], \ 
      PlotStyle\  \[Rule] \ {PointSize[0.025], \ RGBColor[0, 0, 1]}, \ 
      AxesLabel\  \[Rule] \ {"\<real\>", \ "\<imaginary\>"}, \ 
      AspectRatio\  \[Rule] \ 1]; \)\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Integers"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.190476 0.0238095 0.190476 [
[.21429 .01131 -3 -9 ]
[.21429 .01131 3 0 ]
[.40476 .01131 -3 -9 ]
[.40476 .01131 3 0 ]
[.59524 .01131 -3 -9 ]
[.59524 .01131 3 0 ]
[.78571 .01131 -3 -9 ]
[.78571 .01131 3 0 ]
[.97619 .01131 -3 -9 ]
[.97619 .01131 3 0 ]
[1.025 .02381 0 -4.5 ]
[1.025 .02381 24 4.5 ]
[.01131 .21429 -6 -4.5 ]
[.01131 .21429 0 4.5 ]
[.01131 .40476 -6 -4.5 ]
[.01131 .40476 0 4.5 ]
[.01131 .59524 -6 -4.5 ]
[.01131 .59524 0 4.5 ]
[.01131 .78571 -6 -4.5 ]
[.01131 .78571 0 4.5 ]
[.01131 .97619 -6 -4.5 ]
[.01131 .97619 0 4.5 ]
[.02381 1.025 -27 0 ]
[.02381 1.025 27 9 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .02381 m
.21429 .03006 L
s
[(1)] .21429 .01131 0 1 Mshowa
.40476 .02381 m
.40476 .03006 L
s
[(2)] .40476 .01131 0 1 Mshowa
.59524 .02381 m
.59524 .03006 L
s
[(3)] .59524 .01131 0 1 Mshowa
.78571 .02381 m
.78571 .03006 L
s
[(4)] .78571 .01131 0 1 Mshowa
.97619 .02381 m
.97619 .03006 L
s
[(5)] .97619 .01131 0 1 Mshowa
.125 Mabswid
.0619 .02381 m
.0619 .02756 L
s
.1 .02381 m
.1 .02756 L
s
.1381 .02381 m
.1381 .02756 L
s
.17619 .02381 m
.17619 .02756 L
s
.25238 .02381 m
.25238 .02756 L
s
.29048 .02381 m
.29048 .02756 L
s
.32857 .02381 m
.32857 .02756 L
s
.36667 .02381 m
.36667 .02756 L
s
.44286 .02381 m
.44286 .02756 L
s
.48095 .02381 m
.48095 .02756 L
s
.51905 .02381 m
.51905 .02756 L
s
.55714 .02381 m
.55714 .02756 L
s
.63333 .02381 m
.63333 .02756 L
s
.67143 .02381 m
.67143 .02756 L
s
.70952 .02381 m
.70952 .02756 L
s
.74762 .02381 m
.74762 .02756 L
s
.82381 .02381 m
.82381 .02756 L
s
.8619 .02381 m
.8619 .02756 L
s
.9 .02381 m
.9 .02756 L
s
.9381 .02381 m
.9381 .02756 L
s
.25 Mabswid
0 .02381 m
1 .02381 L
s
[(real)] 1.025 .02381 -1 0 Mshowa
.02381 .21429 m
.03006 .21429 L
s
[(1)] .01131 .21429 1 0 Mshowa
.02381 .40476 m
.03006 .40476 L
s
[(2)] .01131 .40476 1 0 Mshowa
.02381 .59524 m
.03006 .59524 L
s
[(3)] .01131 .59524 1 0 Mshowa
.02381 .78571 m
.03006 .78571 L
s
[(4)] .01131 .78571 1 0 Mshowa
.02381 .97619 m
.03006 .97619 L
s
[(5)] .01131 .97619 1 0 Mshowa
.125 Mabswid
.02381 .0619 m
.02756 .0619 L
s
.02381 .1 m
.02756 .1 L
s
.02381 .1381 m
.02756 .1381 L
s
.02381 .17619 m
.02756 .17619 L
s
.02381 .25238 m
.02756 .25238 L
s
.02381 .29048 m
.02756 .29048 L
s
.02381 .32857 m
.02756 .32857 L
s
.02381 .36667 m
.02756 .36667 L
s
.02381 .44286 m
.02756 .44286 L
s
.02381 .48095 m
.02756 .48095 L
s
.02381 .51905 m
.02756 .51905 L
s
.02381 .55714 m
.02756 .55714 L
s
.02381 .63333 m
.02756 .63333 L
s
.02381 .67143 m
.02756 .67143 L
s
.02381 .70952 m
.02756 .70952 L
s
.02381 .74762 m
.02756 .74762 L
s
.02381 .82381 m
.02756 .82381 L
s
.02381 .8619 m
.02756 .8619 L
s
.02381 .9 m
.02756 .9 L
s
.02381 .9381 m
.02756 .9381 L
s
.25 Mabswid
.02381 0 m
.02381 1 L
s
[(imaginary)] .02381 1.025 0 -1 Mshowa
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 1 r
.025 w
.02381 .02381 Mdot
.02381 .21429 Mdot
.02381 .40476 Mdot
.02381 .59524 Mdot
.02381 .78571 Mdot
.02381 .97619 Mdot
.21429 .02381 Mdot
.21429 .21429 Mdot
.21429 .40476 Mdot
.21429 .59524 Mdot
.21429 .78571 Mdot
.21429 .97619 Mdot
.40476 .02381 Mdot
.40476 .21429 Mdot
.40476 .40476 Mdot
.40476 .59524 Mdot
.40476 .78571 Mdot
.40476 .97619 Mdot
.59524 .02381 Mdot
.59524 .21429 Mdot
.59524 .40476 Mdot
.59524 .59524 Mdot
.59524 .78571 Mdot
.59524 .97619 Mdot
.78571 .02381 Mdot
.78571 .21429 Mdot
.78571 .40476 Mdot
.78571 .59524 Mdot
.78571 .78571 Mdot
.78571 .97619 Mdot
.97619 .02381 Mdot
.97619 .21429 Mdot
.97619 .40476 Mdot
.97619 .59524 Mdot
.97619 .78571 Mdot
.97619 .97619 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@0004D00olZ00Co:@03ob/00olY00?o900004H000?o0000:P000ol0
000/0003o`0002T000?o0000:`000ol0000Q0000AP000ol0000[0003o`0002/000?o00009`04ob`0
00?o00008@0004H000?o0000;0000ol0000X00;o:P000ol0o`0Z00?o900001/000?o0000:0000ol0
000Y0004o`00ob`000?o00009`000ol0o`0Z0003o`0002@0000K0003o`0002L00_l/00;o:P03ob/0
0_lZ00Co8`0001/000?o0000o`0300006`000ol0003Z00Co0`04o`030?oo00?o00<0ool00ol10000
6@03C2X00d`Z00=<:P03C2X00d`Z00=<30000ol000020003o`0000<000Co003o10000ol000010000
5@03o`E<:?l5C2So1D`Xo`E<:?l5C2So1D`4o`L000?o00000P05o`030?oo00;o10000ol000010000
6005C0H000?o00001P000ol000060003o`0000H000?o00001005C0H000?o00001P000ol000060003
o`0000H000?o00001005C0H000?o00001P000ol000060003o`0000H000?o00001005C0H000?o0000
1P000ol000060003o`0000H000?o00001005C0H000?o00001P000ol000060003o`0000H000?o0000
1005C0/00_l30005o`000?l010000ol000020003o`000040000H00E<:005C2P01D`X00E<:005C2P0
1D`:00;o00<0ool00P03o`<00ol40003o`000040000I00=<:P03C2X00d`Z00=<:P03C2X00d`O0003
o`000040000K0003o`000?`00ol300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001<00ol50003o`000?l00`0001@000?o00000P03C2X00d`Z00=<:P03C2X0
0d`Z00=<8`0001@000Co00001D`X00E<:005C2P01D`X00E<:005C280000D0004o`0000E<:005C2P0
1D`X00E<:005C2P01D`R000050001?l00005C2P01D`X00E<:005C2P01D`X00E<8P0001<00_l400=<
:P03C2X00d`Z00=<:P03C2X00d`S00006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001/000?o0000o`0300004`04o`@000?o0000o`03000050000ol0000200=<
:P03C2X00d`Z00=<:P03C2X00d`S00005@000ol00005C2P01D`X00E<:005C2P01D`X00E<8P0001H0
00?o04`014`X00E<:005C2P01D`X00E<:005C280000C0005o`00o`001D`X00E<:005C2P01D`X00E<
:005C280000D00;o0`03C2X00d`Z00=<:P03C2X00d`Z00=<8`0001/000?o0000o`0300006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001<00ol50003o`000?l0
0`0001H000?o00000d`Z00=<:P03C2X00d`Z00=<:P03C2<0000F0003o`1<00A<:005C2P01D`X00E<
:005C2P01D`R00005002o`801D`X00E<:005C2P01D`X00E<:005C280000F0003o`1<00A<:005C2P0
1D`X00E<:005C2P01D`R00004`03o`<00d`Z00=<:P03C2X00d`Z00=<:P03C2<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000D00?o
10000ol0003o00<0000E0004o`0000=<:P03C2X00d`Z00=<:P03C2X00d`S00004`04o`0304a<00=<
:005C2P01D`X00E<:005C2P01D`R00004`000ol0o`0200E<:005C2P01D`X00E<:005C2P01D`R0000
4`000ol0o`0200E<:005C2P01D`X00E<:005C2P01D`R00005002o`<00d`Z00=<:P03C2X00d`Z00=<
:P03C2<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000
o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`030000
6`000ol0003o00<0000C00?o0`03C2X00d`Z00=<:P03C2X00d`Z00=<8`0001H000?o04`014`X00E<
:005C2P01D`X00E<:005C280000F0003o`1<00A<:005C2P01D`X00E<:005C2P01D`R00004`03o`80
1D`X00E<:005C2P01D`X00E<:005C280000C0003o`0000<00d`Z00=<:P03C2X00d`Z00=<:P03C2<0
000C00Co10000ol0003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0
003o0240003o0240003o0240003o0240003o0240000D00?o6@03ond0000G0003o`0001L000?o0000
k00000030?oo00?o00L0o`3o0?l000Go0P04o`030?oo00?o00@0ool00_l00`3oo`03o`030?oo00;o
0`000ol0003[00000`002ol0003o0?l0o`3o008000Co003o0`001Ol0003o00<000Co003o0P001?l0
0?l30003o`0000<000?o0000j`0000<000[o0000o`3o0?l01?l20005o`000?l00`001Ol0003o0080
00?o00001?l30003o`00008000?o0?l0k00000<000Wo0000o`3o0?l010001?l00?l30005o`000?l0
0`001?l00?l50004o`0000;o0`000ol0o`3/00000P02o`801_l200?o0`05o`030?oo00801Ol300?o
0P02o`030?oo00;o00<0ool0j`000?l08@0000<000?o00005@000ol0003o00<0003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-0.601381, -0.600784, 0.0222725, 
  0.0222725}},
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "By adding the option ",
  StyleBox["Structure \[Rule] Ring", "MR"],
  ", we consider each of these as ",
  StyleBox["Ringoids", "MR"],
  "."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Z[8, \ Structure\  \[Rule] \ Ring], \ 
      Z[8, \ 2, \ Structure\  \[Rule] \ Ring], \ 
      Z[6, \ I, \ Structure\  \[Rule] \ Ring]}\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({Ringoid[{0, 1, 2, 3, 4, 5, 6, 7}, Mod[#1 + #2, 8]&, Mod[#1\ #2, 8]&], 
      Ringoid[{0, 2, 4, 6}, Mod[#1 + #2, 8]&, Mod[#1\ #2, 8]&], 
      Ringoid[{0, I, 2\ I, 3\ I, 4\ I, 5\ I, 1, 1 + I, 1 + 2\ I, 1 + 3\ I, 
          1 + 4\ I, 1 + 5\ I, 2, 2 + I, 2 + 2\ I, 2 + 3\ I, 2 + 4\ I, 
          2 + 5\ I, 3, 3 + I, 3 + 2\ I, 3 + 3\ I, 3 + 4\ I, 3 + 5\ I, 4, 
          4 + I, 4 + 2\ I, 4 + 3\ I, 4 + 4\ I, 4 + 5\ I, 5, 5 + I, 5 + 2\ I, 
          5 + 3\ I, 5 + 4\ I, 5 + 5\ I}, "-Addition-", "-Multiplication-"]}
      \)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "There are several other groupoids related to the ",
  StyleBox["Z", "MR"],
  " function."
}], "Text",
  CellTags->{"i:7", "Integers"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Zx",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox[\(0, \ 1, \ 2, \ \[Ellipsis], \),
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ \(-\ 1\)}\),
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["under",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["multiplication",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["mod",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"]}]}]}]},
          {
            RowBox[{
              StyleBox["Zx",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              FormBox[
                RowBox[{
                  RowBox[{
                    StyleBox[\(if\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["k",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ is\ a\ divisor\ of\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["n",
                        "TraditionalForm"],
                      "Text"]}], ",", " ", 
                  RowBox[{
                    StyleBox["the",
                      SingleLetterItalics->False], " ", 
                    StyleBox["groupoid",
                      SingleLetterItalics->False], " ", 
                    StyleBox["of",
                      SingleLetterItalics->False], " ", 
                    StyleBox["integers",
                      SingleLetterItalics->False], " ", 
                    StyleBox[
                      FormBox[
                        RowBox[{
                          RowBox[{
                            RowBox[{"{", 
                              RowBox[{
                                StyleBox["0",
                                  SingleLetterItalics->False], ",", " ", 
                                StyleBox["k",
                                  SingleLetterItalics->False,
                                  FontSlant->"Italic"], ",", " ", 
                                RowBox[{
                                  StyleBox["2",
                                    SingleLetterItalics->False], 
                                  StyleBox["k",
                                    SingleLetterItalics->False,
                                    FontSlant->"Italic"]}], ",", " ", 
                                StyleBox["\[Ellipsis]",
                                  SingleLetterItalics->False], ",", " ", 
                                RowBox[{
                                  FormBox[
                                    RowBox[{
                                      StyleBox["(",
                                        SingleLetterItalics->False], 
                                      \(n\/k\)}],
                                    "TraditionalForm"], " ", 
                                  StyleBox["-",
                                    SingleLetterItalics->False], " ", 
                                  StyleBox["1",
                                    SingleLetterItalics->False]}]}], 
                              StyleBox[")",
                                SingleLetterItalics->False]}], 
                            StyleBox["k",
                              SingleLetterItalics->False,
                              FontSlant->"Italic"]}], "}"}],
                        "TraditionalForm"],
                      "Text"], " ", 
                    StyleBox["under",
                      SingleLetterItalics->False], " ", 
                    StyleBox["multiplication",
                      SingleLetterItalics->False], " ", 
                    StyleBox["mod",
                      SingleLetterItalics->False], " ", 
                    StyleBox[
                      FormBox["n",
                        "TraditionalForm"],
                      "Text"]}]}],
                "TextForm"],
              "Text"]},
          {
            RowBox[{
              StyleBox["Zx",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["I",
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["Gaussian",
                    SingleLetterItalics->False], " ", 
                  StyleBox["integers",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      FormBox[
                        RowBox[{
                          RowBox[{
                            StyleBox["{",
                              "MR"], 
                            RowBox[{
                              RowBox[{
                                RowBox[{
                                  StyleBox["a",
                                    SingleLetterItalics->False], " ", 
                                  StyleBox["+",
                                    "MR",
                                    SingleLetterItalics->False], " ", 
                                  StyleBox[\(b\ i\),
                                    SingleLetterItalics->False]}], 
                                StyleBox["|",
                                  "MR",
                                  SingleLetterItalics->False], " ", 
                                StyleBox["a",
                                  SingleLetterItalics->False]}], 
                              StyleBox[",",
                                "MR"], " ", 
                              RowBox[{
                                StyleBox["b",
                                  SingleLetterItalics->False], " ", 
                                StyleBox["\[Element]",
                                  SingleLetterItalics->False,
                                  FontSlant->"Plain"], 
                                StyleBox[" ",
                                  FontSlant->"Plain"], 
                                StyleBox[
                                  FormBox[
                                    SubscriptBox["\[DoubleStruckCapitalZ]", 
                                      StyleBox["n",
                                        FontSlant->"Italic"]],
                                    "TraditionalForm"],
                                  FontSlant->"Plain"]}]}], 
                            StyleBox["}",
                              "MR"]}], 
                          FormBox["",
                            "TraditionalForm"]}],
                        "TextForm"],
                      "TraditionalForm"],
                    "TI"], " ", 
                  StyleBox["under",
                    SingleLetterItalics->False], " ", 
                  StyleBox["multiplication",
                    SingleLetterItalics->False], " ", 
                  StyleBox["mod",
                    SingleLetterItalics->False], " ", 
                  StyleBox[
                    FormBox["n",
                      "TraditionalForm"],
                    "Text"]}],
                "TextForm"],
              "Text"]},
          {
            RowBox[{
              StyleBox["GaussianIntegersMultiplicative",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["Zx",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["n",
                    "TI"], 
                  StyleBox[",",
                    "MR"], " ", 
                  StyleBox["I",
                    "MR"]}], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["U",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["integers",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["from",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[\({0, \ 1, \ 2, \ \[Ellipsis], \ \),
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[\(-\ 1\),
                      SingleLetterItalics->False]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], " ", 
                StyleBox["that",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["relatively",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["prime",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["n\[LongDash]",
                    FontSlant->"Italic"], 
                  StyleBox["the",
                    SingleLetterItalics->False]}]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Zx",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["invertible",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["TwistedZ",
                      "MR"], 
                    StyleBox["[",
                      "MR"], "n", 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  RowBox[{
                    StyleBox[\(0, \ 1, \ 2, \ \[Ellipsis], \),
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["-",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["2",
                    SingleLetterItalics->False]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Mod",
                        "MR"], 
                      StyleBox["[",
                        "MR"], "x", " ", 
                      StyleBox["+",
                        "MR"], " ", "y", " ", 
                      StyleBox["+",
                        "MR"], " ", "x", " ", "y", 
                      StyleBox[",",
                        "MR"], " ", "n", 
                      StyleBox["]",
                        "MR",
                        SingleLetterItalics->False]}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["x",
                FontSlant->"Italic"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox["y",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"i:6", "Integers"}],

Cell[TextData[{
  "Functions related to the ",
  StyleBox["Z",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"Integers"],

Cell[TextData[{
  "The ",
  StyleBox["Groupoid", "MR"],
  " ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Zx",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " is rarely a group since some elements are not invertible. (Is it ",
  StyleBox["ever",
    FontSlant->"Italic"],
  " a group?)"
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Zx[10], \ Inverses[Zx[10]]}\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, 
        Mod[#1\ #2, 10]&], {{0, "no inverse"}, {1, 1}, {2, "no inverse"}, {3, 
          7}, {4, "no inverse"}, {5, "no inverse"}, {6, "no inverse"}, {8, 
          "no inverse"}, {9, 9}}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "The elements in ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Zx",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " that have inverses are exactly the elements in ",
  Cell[BoxData[
      RowBox[{
        StyleBox["U",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  "."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(U[10]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \(Groupoid[{1, 3, 7, 9}, Mod[#1\ #2, 10]&]\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "To obtain the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  ", we can simply form the list of elements {0, 1, ..., ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  "} and then select those whose gcd with ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " has the value 1. The following code accomplishes this (and is used in the \
definition of ",
  StyleBox["U", "MR"],
  ")."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(n\  = \ 10; \n
    Range[0, \ n - 1] // Select[#, \((GCD[#, n] == 1)\)&]&\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({1, 3, 7, 9}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "The functions ",
  StyleBox["Z", "MR"],
  ", ",
  StyleBox["U", "MR"],
  ", and many others can take a ",
  StyleBox["list",
    FontSlant->"Italic"],
  " of indices to produce a list of groupoids."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Z[Table[k, \ {k, \ 3, \ 4}]], \ U[{6, 7}]}\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({{Groupoid[{0, 1, 2}, Mod[#1 + #2, 3]&], 
        Groupoid[{0, 1, 2, 3}, Mod[#1 + #2, 4]&]}, U[{6, 7}]}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  Cell[BoxData[
      RowBox[{
        StyleBox["Z",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["n",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox["k",
            "TI"]}], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " and ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Z",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["n",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox["I",
            "MR"]}], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " have their parallels in the ",
  StyleBox["Zx", "MR"],
  " function."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Zx[10, \ 2], \ Zx[4, \ I]}\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({Groupoid[{0, 2, 4, 6, 8}, Mod[#1\ #2, 10]&], 
      Groupoid[{0, I, 2\ I, 3\ I, 1, 1 + I, 1 + 2\ I, 1 + 3\ I, 2, 2 + I, 
          2 + 2\ I, 2 + 3\ I, 3, 3 + I, 3 + 2\ I, 3 + 3\ I}, "-Operation-"]}
      \)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["TwistedZ", "MR"],
  " groupoid has an operation that is quite different from the others."
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \({G\  = \ TwistedZ[13], \ Operation[G]} // ColumnForm\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Integers"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            \(Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, "-Operation-"]
              \)},
          {\(Mod[#1 + #2 + #1\ #2, 13]&\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        AbstractAlgebra`Core`Private`groupoid[ {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10, 11}, Mod[ 
            Plus[ #, #2, 
              Times[ #, #2]], 13]&, {{}, {}, {}, {}, {}, {GroupoidName -> 
          "TwistedZ[13]"}}], Mod[ 
          Plus[ #, #2, 
            Times[ #, #2]], 13]&}],
      Editable->False]], "Output",
  CellLabel->"Out[14]=",
  CellTags->"Integers"]
}, Open  ]],

Cell[TextData[{
  "This groupoid is sometimes a group, and sometimes not. ",
  "For what values of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is ",
  Cell[BoxData[
      RowBox[{
        StyleBox["TwistedZ",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " a group?"
}], "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[{n, \ GroupQ[TwistedZ[n]]}, \ {n, 11, \ 15}]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"Integers"],

Cell[BoxData[
    \({{11, True}, {12, False}, {13, True}, {14, False}, {15, False}}\)], 
  "Output",
  CellLabel->"Out[15]=",
  CellTags->"Integers"]
}, Open  ]],

Cell["2.4.2 Other numeric-based groupoids", "Subsubsection",
  CellTags->"OtherNum"],

Cell[TextData[{
  "There is a number of groupoids whose elements are ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Range",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " or ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Range",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox["m",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox["n",
            "TI"]}], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  "."
}], "Text",
  CellTags->{"OtherNum", "i:8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MaxTaker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["1",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["2",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["maximum",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MaxTaker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["m",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["m",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["m",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["+",
                      SingleLetterItalics->False], 
                    StyleBox["1",
                      SingleLetterItalics->False]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["m",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["+",
                      SingleLetterItalics->False], 
                    StyleBox["2",
                      SingleLetterItalics->False]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["maximum",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MinTaker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["1",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["2",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["minimum",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MinTaker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["m",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["m",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["m",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["+",
                      SingleLetterItalics->False], 
                    StyleBox["1",
                      SingleLetterItalics->False]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["m",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["+",
                      SingleLetterItalics->False], 
                    StyleBox["2",
                      SingleLetterItalics->False]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["minimum",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["FirstTaker",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["integers",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["1",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["2",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Ellipsis]",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["first",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherNum", "i:9"}],

Cell["The Taker family of functions.", "Caption",
  CellTags->"OtherNum"],

Cell["\<\
Viewing a Cayley table of these groupoids is an easy way of seeing \
their operations at work.\
\>", "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[{MaxTaker[5], \ MinTaker[5], \ FirstTaker[5]}, \ 
      Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"OtherNum"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .33854 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00806052 0.31746 [
[ 0 0 0 0 ]
[ 1 .33854 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .33854 L
0 .33854 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00806052 0.321429 0.330481 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 0 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
1 .5 0 r
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
.56 .37 .6 r
.5 .66071 m
.5 .81944 L
.65873 .81944 L
.65873 .66071 L
F
.5 .50198 m
.5 .66071 L
.65873 .66071 L
.65873 .50198 L
F
.18254 .34325 m
.18254 .50198 L
.34127 .50198 L
.34127 .34325 L
F
.34127 .34325 m
.34127 .50198 L
.5 .50198 L
.5 .34325 L
F
.5 .34325 m
.5 .50198 L
.65873 .50198 L
.65873 .34325 L
F
0 0 1 r
.65873 .66071 m
.65873 .81944 L
.81746 .81944 L
.81746 .66071 L
F
.65873 .50198 m
.65873 .66071 L
.81746 .66071 L
.81746 .50198 L
F
.65873 .34325 m
.65873 .50198 L
.81746 .50198 L
.81746 .34325 L
F
.18254 .18452 m
.18254 .34325 L
.34127 .34325 L
.34127 .18452 L
F
.34127 .18452 m
.34127 .34325 L
.5 .34325 L
.5 .18452 L
F
.5 .18452 m
.5 .34325 L
.65873 .34325 L
.65873 .18452 L
F
.65873 .18452 m
.65873 .34325 L
.81746 .34325 L
.81746 .18452 L
F
.74 .99 .79 r
.81746 .66071 m
.81746 .81944 L
.97619 .81944 L
.97619 .66071 L
F
.81746 .50198 m
.81746 .66071 L
.97619 .66071 L
.97619 .50198 L
F
.81746 .34325 m
.81746 .50198 L
.97619 .50198 L
.97619 .34325 L
F
.81746 .18452 m
.81746 .34325 L
.97619 .34325 L
.97619 .18452 L
F
.18254 .02579 m
.18254 .18452 L
.34127 .18452 L
.34127 .02579 L
F
.34127 .02579 m
.34127 .18452 L
.5 .18452 L
.5 .02579 L
F
.5 .02579 m
.5 .18452 L
.65873 .18452 L
.65873 .02579 L
F
.65873 .02579 m
.65873 .18452 L
.81746 .18452 L
.81746 .02579 L
F
.81746 .02579 m
.81746 .18452 L
.97619 .18452 L
.97619 .02579 L
F
1 1 0 r
.18254 .81944 m
.18254 .97817 L
.34127 .97817 L
.34127 .81944 L
F
1 .5 0 r
.34127 .81944 m
.34127 .97817 L
.5 .97817 L
.5 .81944 L
F
.56 .37 .6 r
.5 .81944 m
.5 .97817 L
.65873 .97817 L
.65873 .81944 L
F
0 0 1 r
.65873 .81944 m
.65873 .97817 L
.81746 .97817 L
.81746 .81944 L
F
.74 .99 .79 r
.81746 .81944 m
.81746 .97817 L
.97619 .97817 L
.97619 .81944 L
F
1 1 0 r
.02381 .66071 m
.02381 .81944 L
.18254 .81944 L
.18254 .66071 L
F
1 .5 0 r
.02381 .50198 m
.02381 .66071 L
.18254 .66071 L
.18254 .50198 L
F
.56 .37 .6 r
.02381 .34325 m
.02381 .50198 L
.18254 .50198 L
.18254 .34325 L
F
0 0 1 r
.02381 .18452 m
.02381 .34325 L
.18254 .34325 L
.18254 .18452 L
F
.74 .99 .79 r
.02381 .02579 m
.02381 .18452 L
.18254 .18452 L
.18254 .02579 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
[(1)] .2619 .74008 0 0 Mshowa
[(2)] .42063 .74008 0 0 Mshowa
[(3)] .57937 .74008 0 0 Mshowa
[(4)] .7381 .74008 0 0 Mshowa
[(5)] .89683 .74008 0 0 Mshowa
[(2)] .2619 .58135 0 0 Mshowa
[(2)] .42063 .58135 0 0 Mshowa
[(3)] .57937 .58135 0 0 Mshowa
[(4)] .7381 .58135 0 0 Mshowa
[(5)] .89683 .58135 0 0 Mshowa
[(3)] .2619 .42262 0 0 Mshowa
[(3)] .42063 .42262 0 0 Mshowa
[(3)] .57937 .42262 0 0 Mshowa
[(4)] .7381 .42262 0 0 Mshowa
[(5)] .89683 .42262 0 0 Mshowa
[(4)] .2619 .26389 0 0 Mshowa
[(4)] .42063 .26389 0 0 Mshowa
[(4)] .57937 .26389 0 0 Mshowa
[(4)] .7381 .26389 0 0 Mshowa
[(5)] .89683 .26389 0 0 Mshowa
[(5)] .2619 .10516 0 0 Mshowa
[(5)] .42063 .10516 0 0 Mshowa
[(5)] .57937 .10516 0 0 Mshowa
[(5)] .7381 .10516 0 0 Mshowa
[(5)] .89683 .10516 0 0 Mshowa
[(1)] .10317 .74008 0 0 Mshowa
[(2)] .10317 .58135 0 0 Mshowa
[(3)] .10317 .42262 0 0 Mshowa
[(4)] .10317 .26389 0 0 Mshowa
[(5)] .10317 .10516 0 0 Mshowa
[(1)] .2619 .89881 0 0 Mshowa
[(2)] .42063 .89881 0 0 Mshowa
[(3)] .57937 .89881 0 0 Mshowa
[(4)] .7381 .89881 0 0 Mshowa
[(5)] .89683 .89881 0 0 Mshowa
[(MaxTaker[5])] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00806052 0.64881 0.330481 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 0 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.5 .66071 m
.5 .81944 L
.65873 .81944 L
.65873 .66071 L
F
.65873 .66071 m
.65873 .81944 L
.81746 .81944 L
.81746 .66071 L
F
.81746 .66071 m
.81746 .81944 L
.97619 .81944 L
.97619 .66071 L
F
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.18254 .34325 m
.18254 .50198 L
.34127 .50198 L
.34127 .34325 L
F
.18254 .18452 m
.18254 .34325 L
.34127 .34325 L
.34127 .18452 L
F
.18254 .02579 m
.18254 .18452 L
.34127 .18452 L
.34127 .02579 L
F
1 .5 0 r
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
.5 .50198 m
.5 .66071 L
.65873 .66071 L
.65873 .50198 L
F
.65873 .50198 m
.65873 .66071 L
.81746 .66071 L
.81746 .50198 L
F
.81746 .50198 m
.81746 .66071 L
.97619 .66071 L
.97619 .50198 L
F
.34127 .34325 m
.34127 .50198 L
.5 .50198 L
.5 .34325 L
F
.34127 .18452 m
.34127 .34325 L
.5 .34325 L
.5 .18452 L
F
.34127 .02579 m
.34127 .18452 L
.5 .18452 L
.5 .02579 L
F
.56 .37 .6 r
.5 .34325 m
.5 .50198 L
.65873 .50198 L
.65873 .34325 L
F
.65873 .34325 m
.65873 .50198 L
.81746 .50198 L
.81746 .34325 L
F
.81746 .34325 m
.81746 .50198 L
.97619 .50198 L
.97619 .34325 L
F
.5 .18452 m
.5 .34325 L
.65873 .34325 L
.65873 .18452 L
F
.5 .02579 m
.5 .18452 L
.65873 .18452 L
.65873 .02579 L
F
0 0 1 r
.65873 .18452 m
.65873 .34325 L
.81746 .34325 L
.81746 .18452 L
F
.81746 .18452 m
.81746 .34325 L
.97619 .34325 L
.97619 .18452 L
F
.65873 .02579 m
.65873 .18452 L
.81746 .18452 L
.81746 .02579 L
F
.74 .99 .79 r
.81746 .02579 m
.81746 .18452 L
.97619 .18452 L
.97619 .02579 L
F
1 1 0 r
.18254 .81944 m
.18254 .97817 L
.34127 .97817 L
.34127 .81944 L
F
1 .5 0 r
.34127 .81944 m
.34127 .97817 L
.5 .97817 L
.5 .81944 L
F
.56 .37 .6 r
.5 .81944 m
.5 .97817 L
.65873 .97817 L
.65873 .81944 L
F
0 0 1 r
.65873 .81944 m
.65873 .97817 L
.81746 .97817 L
.81746 .81944 L
F
.74 .99 .79 r
.81746 .81944 m
.81746 .97817 L
.97619 .97817 L
.97619 .81944 L
F
1 1 0 r
.02381 .66071 m
.02381 .81944 L
.18254 .81944 L
.18254 .66071 L
F
1 .5 0 r
.02381 .50198 m
.02381 .66071 L
.18254 .66071 L
.18254 .50198 L
F
.56 .37 .6 r
.02381 .34325 m
.02381 .50198 L
.18254 .50198 L
.18254 .34325 L
F
0 0 1 r
.02381 .18452 m
.02381 .34325 L
.18254 .34325 L
.18254 .18452 L
F
.74 .99 .79 r
.02381 .02579 m
.02381 .18452 L
.18254 .18452 L
.18254 .02579 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
[(1)] .2619 .74008 0 0 Mshowa
[(1)] .42063 .74008 0 0 Mshowa
[(1)] .57937 .74008 0 0 Mshowa
[(1)] .7381 .74008 0 0 Mshowa
[(1)] .89683 .74008 0 0 Mshowa
[(1)] .2619 .58135 0 0 Mshowa
[(2)] .42063 .58135 0 0 Mshowa
[(2)] .57937 .58135 0 0 Mshowa
[(2)] .7381 .58135 0 0 Mshowa
[(2)] .89683 .58135 0 0 Mshowa
[(1)] .2619 .42262 0 0 Mshowa
[(2)] .42063 .42262 0 0 Mshowa
[(3)] .57937 .42262 0 0 Mshowa
[(3)] .7381 .42262 0 0 Mshowa
[(3)] .89683 .42262 0 0 Mshowa
[(1)] .2619 .26389 0 0 Mshowa
[(2)] .42063 .26389 0 0 Mshowa
[(3)] .57937 .26389 0 0 Mshowa
[(4)] .7381 .26389 0 0 Mshowa
[(4)] .89683 .26389 0 0 Mshowa
[(1)] .2619 .10516 0 0 Mshowa
[(2)] .42063 .10516 0 0 Mshowa
[(3)] .57937 .10516 0 0 Mshowa
[(4)] .7381 .10516 0 0 Mshowa
[(5)] .89683 .10516 0 0 Mshowa
[(1)] .10317 .74008 0 0 Mshowa
[(2)] .10317 .58135 0 0 Mshowa
[(3)] .10317 .42262 0 0 Mshowa
[(4)] .10317 .26389 0 0 Mshowa
[(5)] .10317 .10516 0 0 Mshowa
[(1)] .2619 .89881 0 0 Mshowa
[(2)] .42063 .89881 0 0 Mshowa
[(3)] .57937 .89881 0 0 Mshowa
[(4)] .7381 .89881 0 0 Mshowa
[(5)] .89683 .89881 0 0 Mshowa
[(MinTaker[5])] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00806052 0.97619 0.330481 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 0 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.5 .66071 m
.5 .81944 L
.65873 .81944 L
.65873 .66071 L
F
.65873 .66071 m
.65873 .81944 L
.81746 .81944 L
.81746 .66071 L
F
.81746 .66071 m
.81746 .81944 L
.97619 .81944 L
.97619 .66071 L
F
1 .5 0 r
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
.5 .50198 m
.5 .66071 L
.65873 .66071 L
.65873 .50198 L
F
.65873 .50198 m
.65873 .66071 L
.81746 .66071 L
.81746 .50198 L
F
.81746 .50198 m
.81746 .66071 L
.97619 .66071 L
.97619 .50198 L
F
.56 .37 .6 r
.18254 .34325 m
.18254 .50198 L
.34127 .50198 L
.34127 .34325 L
F
.34127 .34325 m
.34127 .50198 L
.5 .50198 L
.5 .34325 L
F
.5 .34325 m
.5 .50198 L
.65873 .50198 L
.65873 .34325 L
F
.65873 .34325 m
.65873 .50198 L
.81746 .50198 L
.81746 .34325 L
F
.81746 .34325 m
.81746 .50198 L
.97619 .50198 L
.97619 .34325 L
F
0 0 1 r
.18254 .18452 m
.18254 .34325 L
.34127 .34325 L
.34127 .18452 L
F
.34127 .18452 m
.34127 .34325 L
.5 .34325 L
.5 .18452 L
F
.5 .18452 m
.5 .34325 L
.65873 .34325 L
.65873 .18452 L
F
.65873 .18452 m
.65873 .34325 L
.81746 .34325 L
.81746 .18452 L
F
.81746 .18452 m
.81746 .34325 L
.97619 .34325 L
.97619 .18452 L
F
.74 .99 .79 r
.18254 .02579 m
.18254 .18452 L
.34127 .18452 L
.34127 .02579 L
F
.34127 .02579 m
.34127 .18452 L
.5 .18452 L
.5 .02579 L
F
.5 .02579 m
.5 .18452 L
.65873 .18452 L
.65873 .02579 L
F
.65873 .02579 m
.65873 .18452 L
.81746 .18452 L
.81746 .02579 L
F
.81746 .02579 m
.81746 .18452 L
.97619 .18452 L
.97619 .02579 L
F
1 1 0 r
.18254 .81944 m
.18254 .97817 L
.34127 .97817 L
.34127 .81944 L
F
1 .5 0 r
.34127 .81944 m
.34127 .97817 L
.5 .97817 L
.5 .81944 L
F
.56 .37 .6 r
.5 .81944 m
.5 .97817 L
.65873 .97817 L
.65873 .81944 L
F
0 0 1 r
.65873 .81944 m
.65873 .97817 L
.81746 .97817 L
.81746 .81944 L
F
.74 .99 .79 r
.81746 .81944 m
.81746 .97817 L
.97619 .97817 L
.97619 .81944 L
F
1 1 0 r
.02381 .66071 m
.02381 .81944 L
.18254 .81944 L
.18254 .66071 L
F
1 .5 0 r
.02381 .50198 m
.02381 .66071 L
.18254 .66071 L
.18254 .50198 L
F
.56 .37 .6 r
.02381 .34325 m
.02381 .50198 L
.18254 .50198 L
.18254 .34325 L
F
0 0 1 r
.02381 .18452 m
.02381 .34325 L
.18254 .34325 L
.18254 .18452 L
F
.74 .99 .79 r
.02381 .02579 m
.02381 .18452 L
.18254 .18452 L
.18254 .02579 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
[(1)] .2619 .74008 0 0 Mshowa
[(1)] .42063 .74008 0 0 Mshowa
[(1)] .57937 .74008 0 0 Mshowa
[(1)] .7381 .74008 0 0 Mshowa
[(1)] .89683 .74008 0 0 Mshowa
[(2)] .2619 .58135 0 0 Mshowa
[(2)] .42063 .58135 0 0 Mshowa
[(2)] .57937 .58135 0 0 Mshowa
[(2)] .7381 .58135 0 0 Mshowa
[(2)] .89683 .58135 0 0 Mshowa
[(3)] .2619 .42262 0 0 Mshowa
[(3)] .42063 .42262 0 0 Mshowa
[(3)] .57937 .42262 0 0 Mshowa
[(3)] .7381 .42262 0 0 Mshowa
[(3)] .89683 .42262 0 0 Mshowa
[(4)] .2619 .26389 0 0 Mshowa
[(4)] .42063 .26389 0 0 Mshowa
[(4)] .57937 .26389 0 0 Mshowa
[(4)] .7381 .26389 0 0 Mshowa
[(4)] .89683 .26389 0 0 Mshowa
[(5)] .2619 .10516 0 0 Mshowa
[(5)] .42063 .10516 0 0 Mshowa
[(5)] .57937 .10516 0 0 Mshowa
[(5)] .7381 .10516 0 0 Mshowa
[(5)] .89683 .10516 0 0 Mshowa
[(1)] .10317 .74008 0 0 Mshowa
[(2)] .10317 .58135 0 0 Mshowa
[(3)] .10317 .42262 0 0 Mshowa
[(4)] .10317 .26389 0 0 Mshowa
[(5)] .10317 .10516 0 0 Mshowa
[(1)] .2619 .89881 0 0 Mshowa
[(2)] .42063 .89881 0 0 Mshowa
[(3)] .57937 .89881 0 0 Mshowa
[(4)] .7381 .89881 0 0 Mshowa
[(5)] .89683 .89881 0 0 Mshowa
[(FirstTaker[5])] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[16]:=",
  ImageSize->{288, 97.4375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@0000T0D_l<057o301Bo`X00009000=o`?F0mH3eP?F0mH3eP02o`130mH3eP?F0mH3eP?FomH3eP?F
0mH3eP?F0mKoeP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?Fo`0<000<o`?F0mH3
eP?F0mH30_l=g`0KoimOWenOGimOWenOGomnm7kdO_Anm7kdO_Co00e<00koeP?F0mH3eP?F0mH3o``0
00coeP?F0mH3eP?F0mH2o`140mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3e_oF
0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0ol:00002@003Ol?0`l33`<?0`l33`<00_l0@`l33`<?0`l3
3`<?0ol33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0ol0
30003?l?0`l33`<?0`l33`;o3Ml06onOGimOWenOGimOWeooLGiaOW5nLGiaOW5no`0=C00>o`<?0`l3
3`<?0`l33ol<000<o`<?0`l33`<?0`l30_l0A0l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l3o`<?0`l3
3`<?0`l33`?o0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`oo2P0000T000go0mH3eP?F0mH3eP?F00;o
04<3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0ol3eP?F
0mH3eP?F0mKo00`000co0mH3eP?F0mH3eP<2o`gO01_oWenOGimOWenOGimOogkdO_Anm7kdO_Anm?l0
3D`03_oF0mH3eP?F0mH3eP?o30003?oF0mH3eP?F0mH3eP;o04@3eP?F0mH3eP?F0mH3o`?F0mH3eP?F
0mH3e_oF0mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3o`X000090005o`l33`<0
0ol01@<?0`l300;o00@?0`l30ol02P<?0`l3o`<?0`l3o`0:3`<?0`l3o`<?0`?o00/33`<?0`oo3`<?
0`03o`0:0`l33`<?o`l33`?o00L?0`l33`?o00`000Co3`<?0ol01@l33`<?00;o1=l3o`KO00CoWenO
1?l02UnOGimOog5nLGh3o`06OW5nLGko1D`3o`E<00Go0`l33`03o`063`<?0`oo30001Ol33`<?00?o
00@?0`l30_l010l33`<3o`0:0`l33`<?o`l33`?o00/?0`l33`?o0`l33`03o`0:3`<?0`l3o`<?0`?o
00/33`<?0`oo3`<?0`03o`070`l33`<?o`0:00002@003Ol3eP?F0mH3o`?F0mH00_l0@`?F0mH3eP?o
0mH3e_oF0mH3eP?FomH3eP?FomH3eP?F0ol3eP?F0ol3eP?F0mH3o`?F0mH3o`?F0mH3e_oF0mH3e_l0
30003?l3eP?F0mKoeP?F0`;o1Ml00ooOg`05g`0KoimOWeooGimOWenOGomnm7kdO_AnogkdO_Co00I<
00?oC4`014`03_oF0mH3eP?FomH3eP?o30003?oF0mH3eP?FomH3eP;o04@3eP?F0mH3o`?F0mH3o`?F
0mH3e_oF0mH3e_oF0mH3eP?FomH3eP?FomH3eP?F0ol3eP?F0ol3eP?F0mH3o`?F0mH3o`X00009000=
o`l33`<?0`oo3`<?0`02o`133`<?0`l33ol?0`l3o`<?0`l33`?o0`l33`?o0`l33`<?o`l33`<?o`l3
3`<?0`oo3`<?0`oo3`<?0`l3o`<?0`l3o`0<000<o`l33`<?0ol33`<?0_l5g`03omoO00GO01_oWenO
GiooWenOGimOog5nLGiaOW7oLGiaO_l014`4o`E<00ko0`l33`<?0ol33`<?o``000co0`l33`<?0ol3
3`<2o`143`<?0`l33ol?0`l33ol?0`l33`?o0`l33`?o0`l33`<?0ol33`<?0ol33`<?0`oo3`<?0`oo
3`<?0`l33ol?0`l33ol:00002@001Ol3eP?F00?o00GF0mH3eP02o`040mH3eP?o00[F0mH3e_oF0mH3
0ol02P?F0mH3e_oF0mH3o`0;eP?F0mH3o`?F0mH00ol02]H3eP?F0ol3eP<3o`070mH3eP?Fo`0<0004
o`?F0`?o00D3eP?F0`02o`GO00?ogml01Ml04onOGimOWeooGimOWeooO_Anm7h00_l01_Anm7kdo`A<
00?oC?l01T`01OoF0mH300?o00H3eP?F0ol<0005omH3eP<00ol010?F0mH2o`040mH3eP?o00[F0mH3
eP?o0mH30ol02`?F0mH3e_oF0mH300?o00X3eP?F0mKoeP?F0ol02mH3eP?F0ol3eP?F00?o00OF0mH3
eP?o00X00009000=o`l33`?o0`l33`<?0`02o`133`<?0ol33`<?0`l3o`<?0`oo3`<?0`l33`?o0`l3
o`<?0`l33`<?o`l33`?o0`l33`<?0`oo3`<?o`l33`<?0`l3o`0<000<o`l33ol?0`l33`<?0_l5g`03
omoO00GO01_oWenOoimOoenOGimOog5nLGiaOW7oLGiaO_l014`00om<o`06C00>o`<?0`oo3`<?0`l3
3ol<000<o`<?0`oo3`<?0`l30_l0A0l33`?o0`l33`<?0`oo3`<?o`l33`<?0`l3o`<?0`oo3`<?0`l3
3`?o0`l3o`<?0`l33`<?o`l33`?o0`l33`<?0`oo2P0000T000Go0mH3eP04o`040mH3eP;o00@3eP?F
1?l02@?F0mKoeP?F0`04o`09eP?F0mKoeP?F00Co00X3eP?F0ol3eP?F1?l02@?F0mH3o`?F0`04o`06
eP?F0mKo30001?l3eP<4o`04eP?F0`;o1=l2o`OO00GoWenOG`02o`0;WenOGimOogkdO_@00ol01_An
m7kdo`E<0_l6C005omH3eP<01?l01MH3eP?o00`000GoeP?F0`04o`03eP?F00;o00@3eP?F1?l02@?F
0mH3o`?F0`04o`0:eP?F0mKoeP?F0`Co00WF0mH3e_oF0mH01?l02P?F0mH3o`?F0mH4o`060mH3eP?o
2P0000T000go3`<?0`l33`<?0`l300;o04<?0`l33`<?0`l33`?o0`l33`<?0`l33`<?0ol33`<?0`l3
3`<?0`oo3`<?0`l33`<?0`l33ol?0`l33`<?0`l33`?o00`000co3`<?0`l33`<?0`l2o`gO01_oWenO
GimOWenOGimOog5nLGiaOW5nLGiaO_l03D`03_l33`<?0`l33`<?0`oo30003?l33`<?0`l33`<?0`;o
04@?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33ol?0`l3
3`<?0`l33`<?o`X00009000=o`?F0mH3eP?F0mH3eP02o`130mH3eP?F0mH3eP?FomH3eP?F0mH3eP?F
0mKoeP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?Fo`0<000<o`?F0mH3eP?F0mH3
0_l=g`0KoimOWenOGimOWenOGomnm7kdO_Anm7kdO_Co00e<00koeP?F0mH3eP?F0mH3o``000coeP?F
0mH3eP?F0mH2o`140mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3e_oF0mH3eP?F
0mH3eP?o0mH3eP?F0mH3eP?F0ol:00002@003Ol?0`l33`<?0`l33`<00_l0@`l33`<?0`l33`<?0ol3
3`<?0`l33`<?0`l3o`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0ol030003?l?
0`l33`<?0`l33`;o3Ml06onOGimOWenOGimOWeooLGiaOW5nLGiaOW5no`0=C00>o`<?0`l33`<?0`l3
3ol<000<o`<?0`l33`<?0`l30_l0A0l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l3o`<?0`l33`<?0`l3
3`?o0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`oo2P0000T0D_l<057o301Bo`X000090003oda<00Y<
0_l<C003oda<00]<00?oC4`02T`00om<C00;C00>o`l33`<?0`l33`<?0ol<0003oda<00U<0_l=g`0K
oimOWenOGimOWenOGomaOW5nLGiaOW5nLGko00e<00?oC4`02T`00ol0000:0003oda<00U<0_l=C003
oda<00Y<00?oC4`02d`00om<C00:C003oda<00]<00?o0000200000T000?oC4`02T`2o`a<00?oC4`0
2d`00om<C00:C003oda<00]<00ko0mH3eP?F0mH3eP?Fo``000?oC4`02D`2o`gO01_oWenOGimOWenO
GimOogkdO_Anm7kdO_Anm?l03D`00om<C00:C003o`0000X000?oC4`02D`2o`e<00?oC4`02T`00om<
C00;C003oda<00Y<00?oC4`02d`00ol0000800002@000om<C00:C0;o34`00om<C00;C003oda<00Y<
00?oC4`02d`03_l?0`l33`<?0`l33`?o30000om<C009C0;o3Ml06onOGimOWenOGimOWeooLGiaOW5n
LGiaOW5no`0=C003oda<00Y<00?o00002P000om<C009C0;o3D`00om<C00:C003oda<00]<00?oC4`0
2T`00om<C00;C003o`0000P000090003oda<00Y<0_l<C003oda<00]<00?oC4`02T`00om<C00;C00>
o`?F0mH3eP?F0mH3e_l<0003oda<00U<0_l=g`0KoimOWenOGimOWenOGomnm7kdO_Anm7kdO_Co00e<
00?oC4`02T`00ol0000:0003oda<00U<0_l=C003oda<00Y<00?oC4`02d`00om<C00:C003oda<00]<
00?o0000200000T000?oC4`00d`3o`A<0_l5C0?o14`00om<C003C0?o1D`00om<C002C0?o1D`00om<
C003C0?o1D`01?l?0`l3o`073`<?0`l3o`0<0003oda<009<0ol4C0;o1=l3o`KO00CoWenO1?l02UnO
GimOog5nLGh3o`06OW5nLGko1D`3o`E<00?oC4`00d`3o`A<00?o00002P000om<C003C0?o0d`2o`E<
0ol5C003oda<009<0ol5C003oda<00=<0ol5C003oda<009<0ol5C003oda<00=<0ol5C003o`0000P0
00090003oda<00A<00?oC4`00d`2o`I<00?oC4`00d`00om<C004C003oda<00A<00?oC4`00d`00om<
C004C003oda<00A<00?oC4`014`03_l3eP?F0mKoeP?F0mKo30000om<C003C003oda<00=<0_l5g`03
omoO00GO01_oWenOGomOWenOGimOogkdO_Anm7koO_Anm?l01T`00om<C004C003oda<00A<00?oC4`0
0d`00ol0000:0003oda<00A<00?oC4`00T`2o`I<00?oC4`014`00om<C003C003oda<00A<00?oC4`0
14`00om<C004C003oda<00=<00?oC4`014`00om<C004C003oda<00A<00?o0000200000T000?oC4`0
0T`4o`A<0_l4C0Co14`00om<C002C0Co1D`01?m<C4`4o`E<00?oC4`00T`4o`E<00ko3`<?0`l3o`<?
0`l3o``000CoC4a<1?l4C0;o1Ml00ooOg`05g`0KoimOWenOoimOWenOGomaOW5nLGiaog5nLGko00A<
1?l5C003oda<009<1?l4C003o`0000X000?oC4`00T`4o`=<0_l4C0Co1D`01?m<C4`4o`E<00?oC4`0
0T`4o`E<00CoC4a<1?l5C003oda<009<1?l5C003o`0000P000090003oda<009<00?oC?l01D`2o`A<
00?oC?l01D`00om<C002C003odco00I<00OoC4a<odco00I<00?oC4`00T`00om<o`06C004o`?F0`?o
00L3eP?F0mKo00`000OoC4a<odco00E<0_l5g`03omoO00GO01?oWenOGimOoenOGimOogkdO_An00;o
00KdO_Anm?l4C003odco00I<00?oC4`00T`00om<o`05C003o`0000X000?oC4`00T`00om<o`04C0;o
14`00om<o`06C007oda<C?m<o`06C003oda<009<00?oC?l01T`01om<C4coC?l01T`00om<C002C003
odco00I<00?o0000200000T000?oC4`00T`00om<o`05C0;o14`00om<o`05C003oda<009<00?oC?l0
1T`01om<C4coC?l01T`00om<C002C003odco00I<00ko3`<?o`l33`<?0`l3o``000OoC4a<odco00E<
0_l5g`03omoO00GO01_oWenOoimOoenOGimOog5nLGiaOW7oLGiaO_l014`00om<o`06C003oda<009<
00?oC?l01D`00ol0000:0003oda<009<00?oC?l014`2o`A<00?oC?l01T`01om<C4coC?l01T`00om<
C002C003odco00I<00OoC4a<odco00I<00?oC4`00T`00om<o`06C003o`0000P000090003oda<00=<
0_l5C0;o1D`2o`E<00?oC4`00d`2o`I<00?oC4`00T`2o`I<00?oC4`00d`2o`I<00Co0mH31?l01]H3
eP?Fo``000?oC4`00T`2o`E<0_l4g`;o1ml01OnOGimO00;o00^OGimOWeooO_Anm003o`06m7kdO_Co
1D`2o`I<00?oC4`00d`2o`E<00?o00002P000om<C003C0;o14`2o`E<0_l6C003oda<009<0_l6C003
oda<00=<0_l6C003oda<009<0_l6C003oda<00=<0_l6C003o`0000P000090003oda<00Y<0_l<C003
oda<00]<00?oC4`02T`00om<C00;C00>o`l33`<?0`l33`<?0ol<0003oda<00U<0_l=g`0KoimOWenO
GimOWenOGomaOW5nLGiaOW5nLGko00e<00?oC4`02T`00ol0000:0003oda<00U<0_l=C003oda<00Y<
00?oC4`02d`00om<C00:C003oda<00]<00?o0000200000T000?oC4`02T`2o`a<00?oC4`02d`00om<
C00:C003oda<00]<00ko0mH3eP?F0mH3eP?Fo``000?oC4`02D`2o`gO01_oWenOGimOWenOGimOogkd
O_Anm7kdO_Anm?l03D`00om<C00:C003o`0000X000?oC4`02D`2o`e<00?oC4`02T`00om<C00;C003
oda<00Y<00?oC4`02d`00ol0000800002@1Bo``0DOl<05;o2P0000T000goO_Anm7kdO_Anm7kd00;o
02Qnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7ko3D`03_l3eP?F0mH3eP?F0mKo
30003?mnm7kdO_Anm7kdOP;o3Ml0=_nOGimOWenOGimOWeooO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kd
O_Com7kdO_Anm7kdO_Ano``000com7kdO_Anm7kdO_@2o`14O_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kd
O_Com7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_l:00002@003OmaOW5nLGia
OW5nLGh00_l0:75nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLOl=C00>o`l33`<?
0`l33`<?0ol<000<og5nLGiaOW5nLGia0_l=g`0foimOWenOGimOWenOGomaOW5nLGiaOW5nLGkoOW5n
LGiaOW5nLGiaO_mnLGiaOW5nLGiaOW7o30003?mnLGiaOW5nLGiaOP;o04AaOW5nLGiaOW5nLGiaog5n
LGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiao`X00009000=
ogkdO_Anm7kdO_Anm002o`0XO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Ano`e<
00ko0mH3eP?F0mH3eP?Fo``000coO_Anm7kdO_Anm7h2o`gO03KoWenOGimOWenOGimOogkdO_Anm7kd
O_Anm?odO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_l<000<ooAnm7kdO_Anm7kd0_l0A7kdO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko
2P0000T000goLGiaOW5nLGiaOW5n00;o02QaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_mnLGiaOW5n
LGiaOW7o3D`03_l?0`l33`<?0`l33`?o30003?maOW5nLGiaOW5nL@;o3Ml0=_nOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiao``000coOW5nLGiaOW5nLGh2o`14
LGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW7oLGiaOW5n
LGiaOW5nLOl:00002@001Omnm7kd00?o00GdO_Anm002o`04O_Anm0?o00[dO_Anm?odO_An0ol02Wkd
O_Anm?odO_@3o`07m7kdO_Ano`05C0?o1D`01?l3eP<3o`070mH3eP?Fo`0<0004ogkdOP?o00Enm7kd
OP02o`CO0ol6g`04oimOW`Co00YOWenOGomnm7kd0ol02_Anm7kdooAnm7h3o`0;O_Anm7kdooAnm7h0
0ol01WkdO_Ano``000Gom7kdOP03o`04O_Anm0;o00Anm7kd0ol02_Anm7kdO_mnm7h3o`0;O_Anm7kd
ooAnm7h00ol02WkdO_Anm?odO_@3o`0;m7kdO_AnogkdO_@00ol01oAnm7kdO_l02P0000T000goLGia
OW5nLOmaOW5n00;o02QaOW5nLGiaog5nLGkoOW5nLGiaO_mnLGiaO_mnLGiaOW7oLGiaOW7o1T`00om<
C004C00>o`l33`<?0ol33`<?0ol<000<og5nLGiaO_mnLGia0_l5g`03omoO00GO03KoWenOGomOWenO
GimOog5nLGiaOW7oLGiaO_mnLGiaOW5nogiaOW5nogiaOW5nLGkoOW5nLOl<000<ogiaOW5nLGkoOW5n
0_l0A75nLGiaOW7oLGiaOW7oLGiaOW5nogiaOW5nogiaOW5nLGkoOW5nLGkoOW5nLGiaog5nLGiaog5n
LGiaOW7oLGiaOW7o2P0000T000goO_Anm7kdO_mnm7kd00;o02Qnm7kdO_AnogkdO_Com7kdO_Anm?od
O_Anm?odO_Anm7koO_Anm7ko14`4o`E<00ko0mH3eP?FomH3eP?Fo``000coO_Anm7kdooAnm7h2o`GO
00?ogml01Ml0=_nOGimOWonOGimOWeooO_Anm7kdO_mnm7kdooAnm7kdO_Com7kdO_Com7kdO_Anm?od
O_Ano``000com7kdO_Anm?odO_@2o`14O_Anm7kdO_mnm7kdO_mnm7kdO_Com7kdO_Com7kdO_Anm?od
O_Anm?odO_Anm7koO_Anm7koO_Anm7kdO_mnm7kdO_l:00002@001_maOW5nL@;o00EnLGiaOP02o`05
LGiaOW400_l02giaOW5nogiaOW5n00;o00]aOW5nLGkoOW5nL@02o`07OW5nLGiao`04C003odco00I<
00Co3`<?0ol01`l33`<?0ol030001OmaOW5n00;o00EaOW5nL@02o`GO00?ogml01Ml04onOGimOWeoo
GimOWeooLGiaOW400_l02giaOW5nogiaOW5n00;o00aaOW5nLGkoOW5nLGh2o`06LGiaOW7o30001_mn
LGiaOP;o00AaOW5n0_l01G5nLGia00;o00]nLGiaOW7oLGiaOP02o`0<LGiaOW5nogiaOW5n0_l02g5n
LGiaO_mnLGia00;o00anLGiaOW7oLGiaOW42o`07OW5nLGiao`0:00002@003Omnm7kdO_AnogkdO_@0
0_l0:7kdO_Anm7koO_Anm?odO_Anm7kdooAnm7kdooAnm7kdO_mnm7kdO_l4C003odco00I<00ko0mH3
o`?F0mH3eP?Fo``000coO_Anm7kdooAnm7h2o`GO00?ogml01Ml0=_nOGiooWeooGimOWeooO_Anm7kd
O_mnm7kdooAnm7kdO_Com7kdO_Com7kdO_Anm?odO_Ano``000com7kdO_Anm?odO_@2o`14O_Anm7kd
O_mnm7kdO_mnm7kdO_Com7kdO_Com7kdO_Anm?odO_Anm?odO_Anm7koO_Anm7koO_Anm7kdO_mnm7kd
O_l:00002@001OmaOW5n00?o00EnLGiaOP02o`04LGiaOP?o00YnLGiaO_mnLGia0ol02W5nLGiaO_mn
LGh3o`07OW5nLGiao`05C0;o1T`01?l?0`l4o`060`l33`?o30001?maOW43o`05LGiaOW400_l4g`;o
1ml01OnOGimO00;o00^OGimOWeooLGiaOP03o`0:OW5nLGkoOW5nL@?o00]aOW5nLGkoOW5nL@03o`06
LGiaOW7o30001OmnLGia00?o00AaOW5n0_l0175nLGh3o`0:OW5nLGiaog5nL@?o00]aOW5nLGkoOW5n
L@03o`0:LGiaOW5nogiaOP?o00]nLGiaOW7oLGiaOP03o`07OW5nLGiao`0:00002@003Omnm7kdO_An
m7kdO_@00_l0:7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_l=C00>o`?F0mH3
eP?F0mH3e_l<000<ogkdO_Anm7kdO_An0_l=g`0foimOWenOGimOWenOGomnm7kdO_Anm7kdO_Com7kd
O_Anm7kdO_Anm?odO_Anm7kdO_Anm7ko30003?odO_Anm7kdO_Anm0;o04Anm7kdO_Anm7kdO_Anogkd
O_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Ano`X00009000=
og5nLGiaOW5nLGiaOP02o`0XLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiao`e<
00ko3`<?0`l33`<?0`l3o``000coLGiaOW5nLGiaOW42o`gO03KoWenOGimOWenOGimOog5nLGiaOW5n
LGiaO_mnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLOl<000<ogiaOW5nLGiaOW5n0_l0A75nLGiaOW5n
LGiaOW7oLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o
2P0000T000goO_Anm7kdO_Anm7kd00;o02Qnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm?odO_Anm7kd
O_Anm7ko3D`03_l3eP?F0mH3eP?F0mKo30003?mnm7kdO_Anm7kdOP;o3Ml0=_nOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Ano``000com7kdO_Anm7kdO_@2o`14
O_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_l:00002@1Bo``0DOl<05;o2P0000T000goGimOWenOGimOWenO00;o02QOWenOGimOWenO
GiooWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`03_l3eP?F0mH3eP?F0mKo30003?mOWenOGimO
WenOG`;o3Ml0=_nOGimOWenOGimOWeooGimOWenOGimOWenOoimOWenOGimOWenOGiooWenOGimOWenO
GimOo``000coWenOGimOWenOGil2o`14GimOWenOGimOWenOGomOWenOGimOWenOGiooWenOGimOWenO
GimOWonOGimOWenOGimOWeooGimOWenOGimOWenOGol:00002@003OmOWenOGimOWenOGil00_l0:5nO
GimOWenOGimOWonOGimOWenOGimOWenOogiaOW5nLGiaOW5nLOl=C00>o`l33`<?0`l33`<?0ol<000<
oenOGimOWenOGimO0_l=g`0foimOWenOGimOWenOGomOWenOGimOWenOGiooWenOGimOWenOGimOWonO
GimOWenOGimOWeoo30003?nOGimOWenOGimOW`;o04AOWenOGimOWenOGimOoenOGimOWenOGimOWonO
GimOWenOGimOWenOoimOWenOGimOWenOGomOWenOGimOWenOGimOo`X00009000=oenOGimOWenOGimO
W`02o`0XGimOWenOGimOWenOoimOWenOGimOWenOGioom7kdO_Anm7kdO_Ano`e<00ko0mH3eP?F0mH3
eP?Fo``000coGimOWenOGimOWel2o`gO03KoWenOGimOWenOGimOoenOGimOWenOGimOWonOGimOWenO
GimOWenOoimOWenOGimOWenOGol<000<oimOWenOGimOWenO0_l0A5nOGimOWenOGimOWeooGimOWenO
GimOWenOoimOWenOGimOWenOGiooWenOGimOWenOGimOoenOGimOWenOGimOWeoo2P0000T000goGimO
WenOGimOWenO00;o02QOWenOGimOWenOGiooWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7o3D`03_l?
0`l33`<?0`l33`?o30003?mOWenOGimOWenOG`;o3Ml0=_nOGimOWenOGimOWeooGimOWenOGimOWenO
oimOWenOGimOWenOGiooWenOGimOWenOGimOo``000coWenOGimOWenOGil2o`14GimOWenOGimOWenO
GomOWenOGimOWenOGiooWenOGimOWenOGimOWonOGimOWenOGimOWeooGimOWenOGimOWenOGol:0000
2@001OmOWenO00Co00AOWenO0_l015nOGil4o`09GimOWonOGimO00Co00VOGimOWoodO_@00ol01oAn
m7kdO_l01D`3o`E<00Co0mH30ol01`?F0mH3e_l030001?mOWel4o`04WenOG`;o1=l3o`KO00CoWenO
1?l02UnOGimOoenOGil4o`09GimOWonOGimO00Co00ZOGimOWonOGimO1?l01ImOWeoo00`000GoWenO
G`04o`03WenO00;o00AOWenO1?l02EnOGimOoenOG`04o`0:WenOGiooWenOG`Co00VOGimOWonOGil0
1?l02UnOGimOoenOGil4o`06GimOWeoo2P0000T000goGimOWeooGimOWenO00;o02QOWenOGomOWenO
GiooWenOGiooWenOGimOWomnLGiaOW7oLGiaOW7o1T`00om<C004C00>o`l33`<?0ol33`<?0ol<000<
oenOGiooWenOGimO0_l5g`03omoO00GO03KoWenOGomOWenOGimOoenOGimOoenOGimOWonOGimOWonO
GimOWenOoimOWenOoimOWenOGol<000<oimOWenOoimOWenO0_l0A5nOGimOoenOGimOWeooGimOWonO
GimOWenOoimOWenOoimOWenOGiooWenOGomOWenOGimOoenOGimOoenOGimOWeoo2P0000T000goGimO
WenOoimOWenO00;o02QOWenOGiooWenOGiooWenOGimOoenOGimOWoodO_Anm7koO_Anm7ko14`4o`E<
00ko0mH3eP?FomH3eP?Fo``000coGimOWeooGimOWel2o`GO00?ogml01Ml0=_nOGimOWonOGimOWeoo
GimOWenOoimOWenOoimOWenOGomOWenOGiooWenOGimOoenOGimOo``000coWenOGimOoenOGil2o`14
GimOWenOoimOWenOGomOWenOGomOWenOGiooWenOGimOoenOGimOWonOGimOWonOGimOWeooGimOWenO
oimOWenOGol:00002@003OmOWenOGimOoenOGil00_l07enOGimOWeooGimOWonOGimOWenOoimOWenO
ogiaOW400_l01giaOW5nLOl014`00om<o`06C004o`l33`?o00L?0`l33`?o00`000coGimOWenOoimO
Wel2o`GO00?ogml01Ml0=_nOGimOWeooGimOWeooGimOWenOGomOWenOoimOWenOGiooWenOGiooWenO
GimOWonOGimOo``000coWenOGimOWonOGil2o`14GimOWenOGomOWenOGomOWenOGiooWenOGiooWenO
GimOWonOGimOWonOGimOWeooGimOWeooGimOWenOGomOWenOGol:00002@003OmOWenOoimOoenOGil0
0_l0:5nOGiooWeooGimOWonOGimOoenOoimOWenOooAnm7kdO_mnm7kdO_l4C003odco00I<00ko0mH3
o`?F0mH3eP?Fo``000coGimOoenOoimOWel2o`GO00?ogml01Ml0=_nOGiooWeooGimOWeooGimOWonO
GomOWenOoimOWeooGiooWenOGiooWenOGomOWonOGimOo``000coWenOGomOWonOGil2o`14GimOWonO
GomOWenOGomOWeooGiooWenOGiooWenOGomOWonOGimOWonOGiooWeooGimOWeooGimOWonOGomOWenO
Gol:00002@001_mOWenOG`;o00FOGimOW`02o`05GimOWel00_l02imOWenOoimOWenO00;o00YOWenO
GiooOW5n0ol01giaOW5nLOl01D`2o`I<00Co3`<?1?l01P<?0`l3o``000GoGimOW`02o`05GimOWel0
0_l4g`;o1ml01OnOGimO00;o00bOGimOWeooGimOWel2o`0;WenOGiooWenOGil00_l035nOGimOWonO
GimOW`;o00IOWenOGol<0006oimOWenO0_l015nOGil2o`05GimOWel00_l02imOWenOGomOWenO00;o
00aOWenOGiooWenOGil2o`0;GimOWenOoimOWel00_l039mOWenOGomOWenOG`;o00NOGimOWeoo00X0
0009000=oenOGimOWenOGimOW`02o`0XGimOWenOGimOWenOoimOWenOGimOWenOGioom7kdO_Anm7kd
O_Ano`e<00ko0mH3eP?F0mH3eP?Fo``000coGimOWenOGimOWel2o`gO03KoWenOGimOWenOGimOoenO
GimOWenOGimOWonOGimOWenOGimOWenOoimOWenOGimOWenOGol<000<oimOWenOGimOWenO0_l0A5nO
GimOWenOGimOWeooGimOWenOGimOWenOoimOWenOGimOWenOGiooWenOGimOWenOGimOoenOGimOWenO
GimOWeoo2P0000T000goGimOWenOGimOWenO00;o02QOWenOGimOWenOGiooWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW7o3D`03_l?0`l33`<?0`l33`?o30003?mOWenOGimOWenOG`;o3Ml0=_nOGimOWenO
GimOWeooGimOWenOGimOWenOoimOWenOGimOWenOGiooWenOGimOWenOGimOo``000coWenOGimOWenO
Gil2o`14GimOWenOGimOWenOGomOWenOGimOWenOGiooWenOGimOWenOGimOWonOGimOWenOGimOWeoo
GimOWenOGimOWenOGol:00002@1Bo``0DOl<05;o2P0000T000?ogml02]l2o`cO01coWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW7o3D`03_l?0`l33`<?0`l33`?o30000ooOg`09g`;o3Ml00ooOg`0:g`03
omoO00[O00?ogml02ml00ooOg`0:g`03o`0000X000?ogml02Ml2o`gO00?ogml02]l00ooOg`0;g`03
omoO00[O00?ogml02ml00ol0000800002@000ooOg`0:g`;o3=l07?nOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_l=C00>o`?F0mH3eP?F0mH3e_l<0003omoO00WO0_l=g`03omoO00[O00?ogml02]l00ooO
g`0;g`03omoO00[O00?o00002P000ooOg`09g`;o3Ml00ooOg`0:g`03omoO00_O00?ogml02]l00ooO
g`0;g`03o`0000P000090003omoO00[O0_l<g`0LoimOWenOGimOWenOGiooOW5nLGiaOW5nLGiao`e<
00ko3`<?0`l33`<?0`l3o``000?ogml02Ml2o`gO00?ogml02]l00ooOg`0:g`03omoO00_O00?ogml0
2]l00ol0000:0003omoO00WO0_l=g`03omoO00[O00?ogml02ml00ooOg`0:g`03omoO00_O00?o0000
200000T000?ogml02]l2o`cO01coWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`03_l3eP?F0mH3
eP?F0mKo30000ooOg`09g`;o3Ml00ooOg`0:g`03omoO00[O00?ogml02ml00ooOg`0:g`03o`0000X0
00?ogml02Ml2o`gO00?ogml02]l00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000800002@000ooO
g`02g`?o1Ml2o`CO0ol5g`05oimOWel01?l02ImOWenOogiaOP03o`07OW5nLGiao`05C0?o1D`01?l?
0`l3o`073`<?0`l3o`0<0004omoOg`?o1Ml2o`CO0ol6g`04omoOg`?o1]l00ooOg`02g`?o1Ml00ooO
g`02g`?o1]l00ooOg`02g`?o1Ml00ol0000:0003omoO00;O0ol4g`;o1=l3o`KO00CogmoO0ol6g`03
omoO00;O0ol6g`04omoOg`?o1]l00ooOg`02g`?o1]l00ol0000800002@000ooOg`03g`03omoO00CO
0_l5g`03omoO00CO01coWenOGiooWenOGimOWoodO_Anm7koO_Anm7ko1T`00om<C004C00>o`?F0mH3
e_oF0mH3e_l<0003omoO00;O00?ogml01=l2o`GO00?ogml01Ml00ooOg`02g`03omoO00GO00?ogml0
0ml00ooOg`04g`03omoO00?O00?ogml01Ml00ooOg`03g`03omoO00CO00?o00002P000ooOg`03g`03
omoO00?O0_l5g`03omoO00GO00?ogml00]l00ooOg`05g`03omoO00?O00?ogml01Ml00ooOg`02g`03
omoO00GO00?ogml00ml00ooOg`05g`03o`0000P000090003omoO00?O00?ogml01=l2o`GO00?ogml0
1=l07?nOGimOWeooGimOWenOogiaOW5nLOmaOW5nLOl4C0Co1D`03_l?0`l33`?o0`l33`?o30000ooO
g`02g`03omoO00CO0_l5g`03omoO00GO00?ogml00]l00ooOg`05g`03omoO00?O00?ogml01=l00ooO
g`03g`03omoO00GO00?ogml00ml00ooOg`04g`03o`0000X000?ogml00ml00ooOg`03g`;o1Ml00ooO
g`05g`03omoO00;O00?ogml01Ml00ooOg`03g`03omoO00GO00?ogml00]l00ooOg`05g`03omoO00?O
00?ogml01Ml00ol0000800002@000ooOg`03g`03omoO00CO0_l5g`03omoO00CO01?oWenOGimOWonO
GimOWoodO_An00;o00OdO_Anm7ko00A<00?oC?l01T`01?l3eP<3o`070mH3eP?Fo`0<0003omoO00;O
00?ogml01=l2o`GO00?ogml01Ml00ooOg`02g`03omoO00GO00?ogml00ml00ooOg`04g`03omoO00?O
00?ogml01Ml00ooOg`03g`03omoO00CO00?o00002P000ooOg`03g`03omoO00?O0_l5g`03omoO00GO
00?ogml00]l00ooOg`05g`03omoO00?O00?ogml01Ml00ooOg`02g`03omoO00GO00?ogml00ml00ooO
g`05g`03o`0000P000090003omoO00?O00?ogml01=l2o`GO00?ogml01=l07?nOGimOoenOoimOWenO
ogiaOW5nLOmaOW5nLOl4C003odco00I<00ko3`<?o`l33`<?0`l3o``000?ogml00]l00ooOg`04g`;o
1Ml00ooOg`05g`03omoO00;O00?ogml01Ml00ooOg`03g`03omoO00CO00?ogml00ml00ooOg`05g`03
omoO00?O00?ogml01=l00ol0000:0003omoO00?O00?ogml00ml2o`GO00?ogml01Ml00ooOg`02g`03
omoO00GO00?ogml00ml00ooOg`05g`03omoO00;O00?ogml01Ml00ooOg`03g`03omoO00GO00?o0000
200000T000?ogml00]l2o`KO0_l4g`;o1]l01_nOGimOW`;o00YOWenOGioom7kd0ol01oAnm7kdO_l0
1D`2o`I<00Co0mH31?l01]H3eP?Fo``000CogmoO0_l6g`;o1=l2o`OO00CogmoO0_l7g`03omoO00;O
0_l6g`03omoO00;O0_l7g`03omoO00;O0_l6g`03o`0000X000?ogml00]l2o`GO0_l4g`;o1ml01?oO
gml2o`OO00?ogml00]l2o`OO00CogmoO0_l7g`03omoO00;O0_l7g`03o`0000P000090003omoO00[O
0_l<g`0LoimOWenOGimOWenOGiooOW5nLGiaOW5nLGiao`e<00ko3`<?0`l33`<?0`l3o``000?ogml0
2Ml2o`gO00?ogml02]l00ooOg`0:g`03omoO00_O00?ogml02]l00ol0000:0003omoO00WO0_l=g`03
omoO00[O00?ogml02ml00ooOg`0:g`03omoO00_O00?o0000200000T000?ogml02]l2o`cO01coWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`03_l3eP?F0mH3eP?F0mKo30000ooOg`09g`;o3Ml00ooO
g`0:g`03omoO00[O00?ogml02ml00ooOg`0:g`03o`0000X000?ogml02Ml2o`gO00?ogml02]l00ooO
g`0;g`03omoO00[O00?ogml02ml00ol0000800002@000ooOg`0:g`;o3=l07?nOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLOl=C00>o`l33`<?0`l33`<?0ol<0003omoO00WO0_l=g`03omoO00[O00?ogml0
2]l00ooOg`0;g`03omoO00[O00?o00002P000ooOg`09g`;o3Ml00ooOg`0:g`03omoO00_O00?ogml0
2]l00ooOg`0;g`03o`0000P0000805?o2`1Bo`/0Dol:0000201Co`/0D_l;05?o2P0000T000Go0?oo
0002o`@000Co0?oo3=l07?nOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_l=C00>o`?F0mH3eP?F0mH3
e_l<00?o00<0ool01@03o`gO01_oWenOGimOWenOGimOogkdO_Anm7kdO_Anm?l03D`03_oF0mH3eP?F
0mH3eP?o3003o`030?oo00D00ol=g`0LoenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdo`a<00oo0mH3
eP?F0mH3eP?F0ol02P0000T000Ko003o0?l40003o`0000;o3=l07?nOGimOWenOGimOWenOogiaOW5n
LGiaOW5nLOl=C00>o`l33`<?0`l33`<?0ol<0005o`3o0?l01@001?l0ool=g`0KoimOWenOGimOWenO
GomaOW5nLGiaOW5nLGko00e<00ko0`l33`<?0`l33`<?o``000Go0?l0o`050004o`3oo`gO01coGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGko34`03ol?0`l33`<?0`l33`<?o`0:00002@001Ol0003o00@0
00Co00000_l<g`0LoimOWenOGimOWenOGioom7kdO_Anm7kdO_Ano`e<00ko0mH3eP?F0mH3eP?Fo``0
00Co003o1@000ol00002o`gO01_oWenOGimOWenOGimOogkdO_Anm7kdO_Anm?l03D`03_oF0mH3eP?F
0mH3eP?o30001?l00?l50003o`0000;o3Ml07?mOWenOGimOWenOGioom7kdO_Anm7kdO_Anm?l<C00?
o`?F0mH3eP?F0mH3eP?o00X000090007o`00o`3o0003o`<00_l4g`?o1Ml01OnOGimO00Co00VOGimO
WomnLGh00ol01giaOW5nLOl01D`3o`E<00Co3`<?0ol01`l33`<?0ol030001Ol0o`3o00800ol200;o
1=l3o`KO00CoWenO1?l02UnOGimOog5nLGh3o`06OW5nLGko1D`3o`E<00Go0`l33`03o`063`<?0`oo
30001Ol0o`3o00800ol200;o1=l3o`KO00CoGimO1?l02YmOWenOogiaOW43o`07LGiaOW5no`04C0?o
1D`01Ol?0`l300?o00L33`<?0`oo00X000090005o`3oo`001?l400;o1Ml00ooOg`04g`0LoimOWenO
oimOWenOGioom7kdO_AnogkdO_Ano`I<00?oC4`014`03_l3eP?F0mKoeP?F0mKo3003o`040?oo00;o
0`02o`GO00?ogml01Ml06onOGimOoenOGimOWeooO_Anm7kdO_mnm7kdo`06C003oda<00A<00koeP?F
0mH3e_oF0mH3o``00ol0103oo`02o`<00_l5g`03omoO00GO01coGimOWonOGimOWenOooAnm7kdO_Co
m7kdO_Co1D`00om<C004C00?o`?F0mH3eP?o0mH3eP?o00X000090003o`0000<000Co003o0`02o`GO
00?ogml01=l07?nOGimOWeooGimOWenOogiaOW5nLOmaOW5nLOl4C0Co1D`03_l?0`l33`?o0`l33`?o
30000ol000030004o`00o`800_l5g`03omoO00GO01_oWenOGiooWenOGimOog5nLGiaOW7oLGiaO_l0
14`4o`E<00ko0`l33`<?0ol33`<?o``000?o00000`001?l00?l200;o1Ml00ooOg`05g`0LoenOGimO
oenOGimOWomnLGiaOW5nogiaOW5no`=<1?l5C00?o`l33`<?0`oo3`<?0`oo00X000090003o`000080
00Go0000o`0300;o1Ml00ooOg`04g`0CoimOWenOGiooWenOGioom7kdOP02o`07m7kdO_Ano`04C003
odco00I<00Co0mH30ol01`?F0mH3e_l030000ol000020005o`000?l00P02o`GO00?ogml01Ml04onO
GimOWeooGimOWeooO_Anm7h00_l01_Anm7kdo`A<00?oC?l01T`01OoF0mH300?o00H3eP?F0ol<0003
o`00008000Go0000o`0200;o1Ml00ooOg`05g`0CoenOGimOWonOGimOWoodO_Anm002o`07O_Anm7kd
o`03C003odco00I<00Go0mH3eP03o`07eP?F0mH3o`0:00002@001Ol0003o00<000?o0?l00P02o`GO
00?ogml01=l07?nOGimOoenOoimOWenOogiaOW5nLOmaOW5nLOl4C003odco00I<00ko3`<?o`l33`<?
0`l3o``000Go0000o`030004o`3o00;o1Ml00ooOg`05g`0KoimOWonOGomOWenOGomaOW5nLGiaog5n
LGko00A<00?oC?l01T`03_l33`<?o`l33`<?0`oo30001Ol0003o00<000Co0?l00_l5g`03omoO00GO
01coGimOoenOoimOWenOogiaOW5nLGkoOW5nLGko0d`00om<o`06C00?o`l33`?o0`l33`<?0`oo00X0
00090004o`00o`@000?o0?l00P02o`CO0_l6g`06oimOWenO0_l02UnOGimOWoodO_@3o`07m7kdO_An
o`05C0;o1T`01?l3eP<4o`06eP?F0mKo30001?l00?l40004o`3o00;o1=l2o`OO00GoWenOG`02o`0;
WenOGimOogkdO_@00ol01_Anm7kdo`E<0_l6C005omH3eP<01?l01MH3eP?o00`000Co003o10001?l0
o`02o`CO0_l7g`05oenOGil00_l02enOGimOWoodO_An00?o00Mnm7kdO_Co00A<0_l6C005o`?F0mH0
1?l01P?F0mH3o`X000090003o`3o00@00_l0103oo`02o`cO01coWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW7o3D`03_l?0`l33`<?0`l33`?o30000ol0o`0400;o00<0ool00_l=g`0KoimOWenOGimOWenO
GomaOW5nLGiaOW5nLGko00e<00ko0`l33`<?0`l33`<?o``000?o0?l01002o`030?oo00;o3Ml07?mO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaO_l<C00?o`l33`<?0`l33`<?0`oo00X0000900;o2`02o`cO
01coWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`03_l3eP?F0mH3eP?F0mKo3002o`X00_l=g`0K
oimOWenOGimOWenOGomnm7kdO_Anm7kdO_Co00e<00koeP?F0mH3eP?F0mH3o``00_l:00;o3Ml07?mO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm?l<C00?o`?F0mH3eP?F0mH3eP?o00X0000905;o301Ao``0
D_l:00005P02oe/00_mK00;oCP000?l08@0003/00_l:00;o2@03od@00_l:00;o2003oe000_l900?o
400003/000?o00002P000ol000080003o`0004<000?o00002P000ol000070003o`0004l000?o0000
2@02oa00000:0006o`000?l01ol00`3oo`0300?o0P05o`030?l000;o0`04o`030?oo00;o0P02o`04
0?oo00?o1@000ol0o`090003o`00014000Ko0000o`05o`040?oo00;o0P03o`801Ol00`3o0002o`<0
1?l00`3oo`02o`030?oo00?o0P03o`@00ol90003o`0001000ol400Go00<0ool00_l200Co0`03o`<0
0ol200Go00<0o`000_l200Go00<0ool00_l300;o00<0o`000ol50003o`0000h0000:0007o`000?l0
o`020006o`00o`3o1@001Ol0003o008000Ko003o0?l30003o`0000@000?o00000`000ol0o`050003
o`0000800_l:0003o`00014000Go0000o`030005o`000?l00P000ol000020005o`000?l00P001_l0
0?l0o`<000?o000010000ol0000200?o1P000ol000020003o`0000P000?o00004@000ol000050003
o`00008000?o00001@001Ol0003o008000Go0000o`030004o`00o`8000?o0?l00`02o`030?l00080
00?o00000`000ol0o`050003o`00008000?o00003P0000X000Ko0?l0o`04o`<000?o000010001?l0
0004o`800ol300Go0P000ol0000300;o1P001?l00005o`L000?o0?l04P001Ol0o`3o00<000Go0000
o`020003o`00008000Co00001?l200?o0`05o`8000?o00000`000ol000050003o`0000Go1`000ol0
o`0B0003o`0000D000?o00000P000ol0000200Co0`000ol000040004o`0000Co0P03o`<01Ol20003
o`0000<01Ol30004o`0000?o3`0000X000Go0?l0o`040006o`00o`3o0`001Ol0o`3o00@000Ko003o
0?l30005o`000?l00P02o`@000?o0?l00P03o`D00_l90003o`3o018000Go0?l0o`030005o`000?l0
0P002?l00?l0o`3o10001_l00?l0o`<000Go0000o`0200;o0`03o`<00ol50003o`0000L000?o0?l0
4P03o`D000?o00000P02o`<000?o000010000ol000020005o`3o0?l010001_l00?l0o`<00_l00`3o
o`0200;o10000ol0o`0200?o1003o`l0000:00;o00<0ool00P03o`040?oo00;o0P001Ol0o`3o0080
0ol20004o`3oo`<00ol200;o00@0ool00_l01@3oo`3o00L000?o00001`02o`030?oo01400_l00`3o
o`0200;o0P05o`8000Go0?l0o`0200?o0P001?l0ool300?o0P02o`030?oo00Go0P000ol000050003
o`0000H00_l00`3oo`0A0003o`0000@00_l300;o00@0ool01?l200Co0P001Ol0o`3o00800ol20004
o`3oo`801Ol0103oo`02o`8000?o00000P000ol0000300Go3P0000T00_l300;o3005o`L000?o0000
4002o`<01?l300;o7P02o`<00_l<00Go1`000ol0000@00;o0`04o`<00_lM00Go5@000ol0000200Go
1`000ol0000@00;o0`04o`<00_l@00009`02odL000?o00004P02odH000?o00003P000ol0000=00;o
<0000001\
\>"],
  ImageRangeCache->{{{0, 287}, {96.4375, 0}} -> {-0.0868316, -0.025396, 
  0.0110581, 0.0110581}, {{7.8125, 92.625}, {94.125, 
  2.25}} -> {-1.73057, -0.334322, 0.0742863, 0.0742863}, {{101.062, 
  185.875}, {94.125, 2.25}} -> {-8.65776, -0.334322, 0.0742863, 0.0742863}, {{
  194.312, 279.125}, {94.125, 2.25}} -> {-15.585, -0.334322, 0.0742863, 
  0.0742863}},
  CellTags->"OtherNum"]
}, Open  ]],

Cell[TextData[{
  "There are also several groupoids based on the divisors of the integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "."
}], "Text",
  CellTags->{"OtherNum", "i:10"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MeetDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["divisors",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["GCD",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["JoinDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["divisors",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["LCM",
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MixedDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["divisors",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["returns",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(LCM/GCD\),
                "MR",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["two",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inputs",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherNum", "i:11"}],

Cell["The Divisors family of functions.", "Caption",
  CellTags->"OtherNum"],

Cell["\<\
Viewing a Cayley table of these divisors groupoids is again a good \
way of seeing their operations at work.\
\>", "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[{MeetDivisors[15], \ JoinDivisors[15], \ 
        MixedDivisors[15]}, \ Mode\  \[Rule] \ Visual]; \)\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"OtherNum"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .34375 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00818452 0.31746 [
[ 0 0 0 0 ]
[ 1 .34375 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .34375 L
0 .34375 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00818452 0.321429 0.335565 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 .5 0 r
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.56 .37 .6 r
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
0 0 1 r
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(1)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(1)] .69048 .69286 0 0 Mshowa
[(1)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(3)] .5 .50238 0 0 Mshowa
[(1)] .69048 .50238 0 0 Mshowa
[(3)] .88095 .50238 0 0 Mshowa
[(1)] .30952 .3119 0 0 Mshowa
[(1)] .5 .3119 0 0 Mshowa
[(5)] .69048 .3119 0 0 Mshowa
[(5)] .88095 .3119 0 0 Mshowa
[(1)] .30952 .12143 0 0 Mshowa
[(3)] .5 .12143 0 0 Mshowa
[(5)] .69048 .12143 0 0 Mshowa
[(15)] .88095 .12143 0 0 Mshowa
[(1)] .11905 .69286 0 0 Mshowa
[(3)] .11905 .50238 0 0 Mshowa
[(5)] .11905 .3119 0 0 Mshowa
[(15)] .11905 .12143 0 0 Mshowa
[(1)] .30952 .88333 0 0 Mshowa
[(3)] .5 .88333 0 0 Mshowa
[(5)] .69048 .88333 0 0 Mshowa
[(15)] .88095 .88333 0 0 Mshowa
[(MeetDiv[15])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
(GCD) show
117.000000 13.000000 moveto
(y) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00818452 0.64881 0.335565 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(1)] .30952 .69286 0 0 Mshowa
[(3)] .5 .69286 0 0 Mshowa
[(5)] .69048 .69286 0 0 Mshowa
[(15)] .88095 .69286 0 0 Mshowa
[(3)] .30952 .50238 0 0 Mshowa
[(3)] .5 .50238 0 0 Mshowa
[(15)] .69048 .50238 0 0 Mshowa
[(15)] .88095 .50238 0 0 Mshowa
[(5)] .30952 .3119 0 0 Mshowa
[(15)] .5 .3119 0 0 Mshowa
[(5)] .69048 .3119 0 0 Mshowa
[(15)] .88095 .3119 0 0 Mshowa
[(15)] .30952 .12143 0 0 Mshowa
[(15)] .5 .12143 0 0 Mshowa
[(15)] .69048 .12143 0 0 Mshowa
[(15)] .88095 .12143 0 0 Mshowa
[(1)] .11905 .69286 0 0 Mshowa
[(3)] .11905 .50238 0 0 Mshowa
[(5)] .11905 .3119 0 0 Mshowa
[(15)] .11905 .12143 0 0 Mshowa
[(1)] .30952 .88333 0 0 Mshowa
[(3)] .5 .88333 0 0 Mshowa
[(5)] .69048 .88333 0 0 Mshowa
[(15)] .88095 .88333 0 0 Mshowa
[(JoinDiv[15])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
(LCM) show
117.000000 13.000000 moveto
(y) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00818452 0.97619 0.335565 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(1)] .30952 .69286 0 0 Mshowa
[(3)] .5 .69286 0 0 Mshowa
[(5)] .69048 .69286 0 0 Mshowa
[(15)] .88095 .69286 0 0 Mshowa
[(3)] .30952 .50238 0 0 Mshowa
[(1)] .5 .50238 0 0 Mshowa
[(15)] .69048 .50238 0 0 Mshowa
[(5)] .88095 .50238 0 0 Mshowa
[(5)] .30952 .3119 0 0 Mshowa
[(15)] .5 .3119 0 0 Mshowa
[(1)] .69048 .3119 0 0 Mshowa
[(3)] .88095 .3119 0 0 Mshowa
[(15)] .30952 .12143 0 0 Mshowa
[(5)] .5 .12143 0 0 Mshowa
[(3)] .69048 .12143 0 0 Mshowa
[(1)] .88095 .12143 0 0 Mshowa
[(1)] .11905 .69286 0 0 Mshowa
[(3)] .11905 .50238 0 0 Mshowa
[(5)] .11905 .3119 0 0 Mshowa
[(15)] .11905 .12143 0 0 Mshowa
[(1)] .30952 .88333 0 0 Mshowa
[(3)] .5 .88333 0 0 Mshowa
[(5)] .69048 .88333 0 0 Mshowa
[(15)] .88095 .88333 0 0 Mshowa
[(MixedDiv[15])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -137 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
(mixed) show
129.000000 13.000000 moveto
(y) show
135.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  ImageSize->{288, 99},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000H`P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@0000T0D_l<057o301Bo`X000090003oda<00a<0_l@g`0QoimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Co00m<00?o00002P000om<C00<C0;o3d`00om<C00=C003oda<00e<00?oC4`03D`00ol0
000:0003oda<00a<0_l?C00RooAnm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOo`oO00?o0000
200000T000?oC4`034`2oa3O027oWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaO_l03d`00ol0
000:0003oda<00a<0_l?C003oda<00e<00?oC4`03D`00om<C00=C003o`0000X000?oC4`034`2o`m<
02;oOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWeoo3ml00ol0000800002@000om<C00<C0;o
4=l08OnOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdo`0?C003o`0000X000?oC4`034`2o`m<
00?oC4`03D`00om<C00=C003oda<00e<00?o00002P000om<C00<C0;o3d`08_odO_Anm7kdO_Anm7kd
O_CoWenOGimOWenOGimOWenOGol?g`03o`0000P000090003oda<00a<0_l@g`0QoimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGko00m<00?o00002P000om<C00<C0;o3d`00om<C00=C003oda<00e<
00?oC4`03D`00ol0000:0003oda<00a<0_l?C00RogiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenO
GimOo`oO00?o0000200000T000?oC4`034`2oa3O027oWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm?l03d`00ol0000:0003oda<00a<0_l?C003oda<00e<00?oC4`03D`00om<C00=C003o`0000X0
00?oC4`034`2o`m<02;om7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWeoo3ml00ol000080000
2@000om<C003o`=<0ol3C0;o1Ml3o`SO00KoWenOGil3o`0=WenOGimOWomnLGiaOP03o`08OW5nLGia
O_l2C0?o0d`3o`A<00?o00002P000om<C003o`=<0ol3C0;o0T`3o`=<0ol4C003oda<00?o0d`3o`A<
00?oC4`00ol3C0?o14`00om<C003o`=<0ol4C003o`0000X000?oC4`00ol3C0?o0d`2o`9<0ol3C0?o
14`01_mnLGiaOP?o00enLGiaOW5noimOWenO00?o00VOGimOWenOGol01Ml3o`OO00?o0000200000T0
00GoC4a<o`07C003oda<00;o1]l00ooOg`07g`0QoimOWenOGimOoenOGimOWoodO_Anm7kdO_mnm7kd
O_Co00=<00?oC4`01D`01Om<C4co00`000GoC4a<o`07C003oda<00;o0d`00om<C005C005oda<C?l0
0d`00om<C005C005oda<C?l00d`00om<C005C005oda<C?l00d`00om<C005C005oda<C?l030001Om<
C4co00M<00?oC4`00_l3C003oda<00E<02KoC4a<ooAnm7kdO_AnogkdO_Anm?nOGimOWenOGomOWenO
GimOo`KO00?ogml01]l00ol0000800002@001Om<C4co00M<00?oC4`00_l6g`03omoO00OO027oWenO
GimOWeooGimOWenOogiaOW5nLGiaog5nLGiaO_l00d`00om<C005C005oda<C?l030001Om<C4co00M<
00?oC4`00_l3C003oda<00E<00GoC4a<o`03C003oda<00E<00GoC4a<o`03C003oda<00E<00GoC4a<
o`03C003oda<00E<00GoC4a<o`0<0005oda<C?l01d`00om<C002o`=<00?oC4`01D`09_m<C4coOW5n
LGiaOW7oLGiaOW5noimOWenOGimOoenOGimOWeoo1]l00ooOg`06g`03o`0000P000090005oda<C?l0
14`3o`=<0_l6g`03omoO00OO00OoWenOGimO00;o00fOGimOWenOooAnm7kd00?o00SdO_Anm7kdo`=<
00?oC4`00T`3o`A<00?o00002P001Om<C4co00A<0ol3C0;o0d`00om<C002C0?o14`01Om<C4co00A<
0ol4C005oda<C?l014`3o`A<00GoC4a<o`04C0?o14`00ol0000:0005oda<C?l014`3o`=<0_l3C003
oda<009<0ol4C006ooAnm7kd0ol03_Anm7kdO_CoWenOGimO0_l02ImOWenOGimOo`06g`03omoO00KO
00?o0000200000T000GoC4a<o`04C003oda<00=<0_l6g`03omoO00OO027oWenOGimOWeooGimOWenO
ogiaOW5nogiaOW5nLGiaO_l00d`00om<C002C003oda<00A<00?o00002P001Om<C4co00A<00?oC4`0
0d`2o`=<00?oC4`00T`00om<C004C005oda<C?l014`00om<C004C005oda<C?l014`00om<C004C005
oda<C?l014`00om<C004C003o`0000X000GoC4a<o`04C003oda<00=<0_l3C003oda<009<00?oC4`0
14`08_mnLGiaO_mnLGiaOW5nLGkoWenOGimOWeooGimOWenOGol6g`03omoO00KO00?o0000200000T0
00?oC4`00_l4C0Co0T`2o`GO0_l9g`06oimOWenO0ol03ImOWenOGioom7kdO_@01?l01gkdO_Anm?l0
0T`2o`A<1?l3C003o`0000X000?oC4`00_l4C0Co0T`2o`9<0_l4C0Co0d`00om<C002o`A<1?l3C003
oda<00;o14`4o`=<00?oC4`00_l4C0Co0d`00ol0000:0003oda<00;o14`4o`9<0_l2C0;o14`4o`=<
00Kom7kdO_@4o`0<O_Anm7kdoimOWenO0ol02ImOWenOGimOo`05g`;o2=l00ol0000800002@000om<
C00<C0;o4=l08OnOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5no`0?C003o`0000X000?oC4`0
34`2o`m<00?oC4`03D`00om<C00=C003oda<00e<00?o00002P000om<C00<C0;o3d`08_mnLGiaOW5n
LGiaOW5nLGkoWenOGimOWenOGimOWenOGol?g`03o`0000P000090003oda<00a<0_l@g`0QoimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Co00m<00?o00002P000om<C00<C0;o3d`00om<C00=C003
oda<00e<00?oC4`03D`00ol0000:0003oda<00a<0_l?C00RooAnm7kdO_Anm7kdO_Anm?nOGimOWenO
GimOWenOGimOo`oO00?o0000200000T000?oC4`034`2oa3O027oWenOGimOWenOGimOWenOogiaOW5n
LGiaOW5nLGiaO_l03d`00ol0000:0003oda<00a<0_l?C003oda<00e<00?oC4`03D`00om<C00=C003
o`0000X000?oC4`034`2o`m<02;oOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWeoo3ml00ol0
000800002@000om<C00<C0;o4=l08OnOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdo`0?C003
o`0000X000?oC4`034`2o`m<00?oC4`03D`00om<C00=C003oda<00e<00?o00002P000om<C00<C0;o
3d`08_odO_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGol?g`03o`0000P0000905;o301Ao``0
D_l:00002@003omnm7kdO_Anm7kdO_Anm002oa3O00?ogml03Ml08OodO_Anm7kdO_Anm7kdO_Com7kd
O_Anm7kdO_Anm7kdo`0<000?ogkdO_Anm7kdO_Anm7kd00;o011nm7kdO_Anm7kdO_Anm7ko3d`04Omn
m7kdO_Anm7kdO_Anm7ko00m<00?o00002P003oodO_Anm7kdO_Anm7kdOP02o`0@m7kdO_Anm7kdO_An
m7kdo`m<00?ogml03]l04OmOWenOGimOWenOGimOWeoo00X00009000?og5nLGiaOW5nLGiaOW5n00;o
4=l00ooOg`0=g`0QogiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGko00`000ooLGiaOW5nLGia
OW5nLGh00_l0475nLGiaOW5nLGiaOW5nLOl?C00Aog5nLGiaOW5nLGiaOW5nLOl03d`00ol0000:000?
ogiaOW5nLGiaOW5nLGia00;o011nLGiaOW5nLGiaOW5nLGko3d`00ooOg`0>g`0AoenOGimOWenOGimO
WenOGol02P0000T000ooO_Anm7kdO_Anm7kdO_@00_l@g`03omoO00gO027om7kdO_Anm7kdO_Anm7kd
ooAnm7kdO_Anm7kdO_Anm?l030003omnm7kdO_Anm7kdO_Anm002o`0@O_Anm7kdO_Anm7kdO_Ano`m<
017oO_Anm7kdO_Anm7kdO_Ano`0?C003o`0000X000oom7kdO_Anm7kdO_Anm7h00_l04?Anm7kdO_An
m7kdO_Anm?l?C003omoO00kO017oGimOWenOGimOWenOGimOo`0:00002@003omaOW5nLGiaOW5nLGia
OP02oa3O00?ogml03Ml08OmnLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5no`0<000?og5nLGia
OW5nLGiaOW5n00;o011aOW5nLGiaOW5nLGiaOW7o3d`04OmaOW5nLGiaOW5nLGiaOW7o00m<00?o0000
2P003omnLGiaOW5nLGiaOW5nL@02o`0@OW5nLGiaOW5nLGiaOW5no`m<00?ogml03]l04OmOWenOGimO
WenOGimOWeoo00X00009000?ogkdO_Anm7kdO_Anm7kd00;o4=l00ooOg`0=g`0QooAnm7kdO_Anm7kd
O_Anm?odO_Anm7kdO_Anm7kdO_Co00`000ooO_Anm7kdO_Anm7kdO_@00_l047kdO_Anm7kdO_Anm7kd
O_l?C00AogkdO_Anm7kdO_Anm7kdO_l03d`00ol0000:000?ooAnm7kdO_Anm7kdO_An00;o013dO_An
m7kdO_Anm7kdO_Co3d`00ooOg`0>g`0AoenOGimOWenOGimOWenOGol02P0000T000KoLGiaOW43o`06
LGiaOW5n0_l5g`?o2=l00ooOg`03g`?o1ml01_mnLGiaOP?o00enLGiaOW5nogiaOW5n00?o00QnLGia
OW5no``000KoLGiaOW43o`06LGiaOW5n0_l01G5nLGia00?o00QaOW5nLGiao`9<0ol3C0?o14`01_ma
OW5nL@?o00QaOW5nLGiao`9<0ol3C0?o14`00ol0000:0006ogiaOW5n0ol01WiaOW5nL@;o00EnLGia
OP03o`08OW5nLGiaO_l2C0?o0d`3o`A<00?ogml00ml3o`SO00KoGimOWel3o`08GimOWenOGol:0000
2@003omnm7kdO_Anm?odO_Anm002o`KO00?ogml01ml00ooOg`04g`03omoO00KO027om7kdO_Anm7ko
O_Anm7kdooAnm7kdO_AnogkdO_Anm?l030003omnm7kdO_Anm?odO_Anm002o`0@O_Anm7kdO_Com7kd
O_Ano`=<00?oC4`01D`05Om<C4coO_Anm7kdO_Com7kdO_Ano`03C003oda<00E<00GoC4a<o`0<000?
ooAnm7kdO_AnogkdO_An00;o013dO_Anm7kdO_mnm7kdO_Co0d`00om<C005C005oda<C?l01]l00ooO
g`07g`0AoenOGimOWenOoimOWenOGol02P0000T000ooLGiaOW5nLGkoOW5nLGh00_l6g`03omoO00OO
00?ogml01=l00ooOg`06g`0QogiaOW5nLGiaog5nLGiaO_mnLGiaOW5nLOmaOW5nLGko00`000ooLGia
OW5nLGkoOW5nLGh00_l0475nLGiaOW5nogiaOW5nLOl3C003oda<00E<01GoC4a<og5nLGiaOW5nogia
OW5nLOl00d`00om<C005C005oda<C?l030003omnLGiaOW5nLOmaOW5nL@02o`0@OW5nLGiaOW7oLGia
OW5no`=<00?oC4`01D`01Om<C4co00KO00?ogml01ml04OmOWenOGimOWonOGimOWeoo00X000090006
ogkdO_An0ol01WkdO_Anm0;o1]l00ooOg`07g`03omoO00CO00?ogml01]l01_odO_Anm0?o00gdO_An
m7kdooAnm7kd00?o00SdO_Anm7kdo``000KoO_Anm7h3o`06O_Anm7kd0_l01GkdO_An00?o00Qnm7kd
O_Ano`=<00?oC4`00T`3o`A<00KoO_Anm7h3o`08O_Anm7kdO_l3C003oda<009<0ol4C003o`0000X0
00Kom7kdO_@3o`06m7kdO_An0_l01OAnm7kd00?o00SdO_Anm7kdo`=<00?oC4`00T`3o`A<00?ogml0
1=l00ooOg`07g`07oenOGimOW`02o`08GimOWenOGol:00002@003omaOW5nLOmaOW5nLGiaOP02o`KO
00?ogml01ml00ooOg`04g`03omoO00KO027oOW5nLGkoOW5nLGiaOW5nogiaOW5nogiaOW5nLGiaO_l0
30003omaOW5nLOmaOW5nLGiaOP02o`0@LGiaOW7oLGiaOW5nLGiao`=<00?oC4`00T`00om<C004C00A
og5nLGiaog5nLGiaOW5nLOl00d`00om<C002C003oda<00A<00?o00002P003omnLGiaO_mnLGiaOW5n
L@02o`0@OW5nLGkoOW5nLGiaOW5no`=<00?oC4`00T`00om<C004C003omoO00CO00?ogml01ml04OmO
WenOGimOWonOGimOWeoo00X000090006ogkdO_An1?l01OAnm7kd00;o1Ml2o`WO00?ogml00ml2o`SO
00Kom7kdO_@4o`0<O_Anm7kdooAnm7kd1?l01gkdO_Anm?l030001_mnm7kdOPCo00GdO_Anm002o`05
O_Anm7h01?l01oAnm7kdO_l00T`2o`A<1?l3C006ogkdO_An1?l01oAnm7kdO_l00T`2o`A<1?l3C003
o`0000X000Kom7kdO_@4o`05O_Anm7h00_l01OAnm7kd00Co00Mnm7kdO_Co009<0_l4C0Co0d`00ooO
g`03g`;o2Ml01_mOWenOG`?o00QOWenOGimOo`X00009000?og5nLGiaOW5nLGiaOW5n00;o4=l00ooO
g`0=g`0QogiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGko00`000ooLGiaOW5nLGiaOW5nLGh0
0_l0475nLGiaOW5nLGiaOW5nLOl?C00Aog5nLGiaOW5nLGiaOW5nLOl03d`00ol0000:000?ogiaOW5n
LGiaOW5nLGia00;o011nLGiaOW5nLGiaOW5nLGko3d`00ooOg`0>g`0AoenOGimOWenOGimOWenOGol0
2P0000T000ooO_Anm7kdO_Anm7kdO_@00_l@g`03omoO00gO027om7kdO_Anm7kdO_Anm7kdooAnm7kd
O_Anm7kdO_Anm?l030003omnm7kdO_Anm7kdO_Anm002o`0@O_Anm7kdO_Anm7kdO_Ano`m<017oO_An
m7kdO_Anm7kdO_Ano`0?C003o`0000X000oom7kdO_Anm7kdO_Anm7h00_l04?Anm7kdO_Anm7kdO_An
m?l?C003omoO00kO017oGimOWenOGimOWenOGimOo`0:00002@003omaOW5nLGiaOW5nLGiaOP02oa3O
00?ogml03Ml08OmnLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5no`0<000?og5nLGiaOW5nLGia
OW5n00;o011aOW5nLGiaOW5nLGiaOW7o3d`04OmaOW5nLGiaOW5nLGiaOW7o00m<00?o00002P003omn
LGiaOW5nLGiaOW5nL@02o`0@OW5nLGiaOW5nLGiaOW5no`m<00?ogml03]l04OmOWenOGimOWenOGimO
Weoo00X00009000?ogkdO_Anm7kdO_Anm7kd00;o4=l00ooOg`0=g`0QooAnm7kdO_Anm7kdO_Anm?od
O_Anm7kdO_Anm7kdO_Co00`000ooO_Anm7kdO_Anm7kdO_@00_l047kdO_Anm7kdO_Anm7kdO_l?C00A
ogkdO_Anm7kdO_Anm7kdO_l03d`00ol0000:000?ooAnm7kdO_Anm7kdO_An00;o013dO_Anm7kdO_An
m7kdO_Co3d`00ooOg`0>g`0AoenOGimOWenOGimOWenOGol02P0000T0D_l<057o301Bo`X00009000?
oenOGimOWenOGimOWenO00;o4=l04OnOGimOWenOGimOWenOGioo00oO017oWenOGimOWenOGimOWenO
o`0<000?oenOGimOWenOGimOWenO00;o021OWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOo`m<
00?oC4`03D`00ol0000:000?oimOWenOGimOWenOGimO00;o012OGimOWenOGimOWenOGioo3ml00om<
C00>C00AogkdO_Anm7kdO_Anm7kdO_l02P0000T000ooGimOWenOGimOWenOGil00_l@g`0AoimOWenO
GimOWenOGimOWol03ml04OnOGimOWenOGimOWenOGioo00`000ooGimOWenOGimOWenOGil00_l085nO
GimOWenOGimOWenOGomOWenOGimOWenOGimOWeoo3d`00om<C00=C003o`0000X000ooWenOGimOWenO
GimOWel00_l049mOWenOGimOWenOGimOWol?g`03oda<00i<017oLGiaOW5nLGiaOW5nLGiao`0:0000
2@003omOWenOGimOWenOGimOW`02oa3O017oWenOGimOWenOGimOWenOo`0?g`0AoimOWenOGimOWenO
GimOWol030003omOWenOGimOWenOGimOW`02o`0PGimOWenOGimOWenOGimOoenOGimOWenOGimOWenO
Gol?C003oda<00e<00?o00002P003onOGimOWenOGimOWenOG`02o`0@WenOGimOWenOGimOWenOo`oO
00?oC4`03T`04Omnm7kdO_Anm7kdO_Anm7ko00X00009000?oenOGimOWenOGimOWenO00;o4=l04OnO
GimOWenOGimOWenOGioo00oO017oWenOGimOWenOGimOWenOo`0<000?oenOGimOWenOGimOWenO00;o
021OWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOo`m<00?oC4`03D`00ol0000:000?oimOWenO
GimOWenOGimO00;o012OGimOWenOGimOWenOGioo3ml00om<C00>C00Aog5nLGiaOW5nLGiaOW5nLOl0
2P0000T000ooGimOWenOGimOWenOGil00_l@g`0AoimOWenOGimOWenOGimOWol03ml04OnOGimOWenO
GimOWenOGioo00`000ooGimOWenOGimOWenOGil00_l085nOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWeoo3d`00om<C00=C003o`0000X000ooWenOGimOWenOGimOWel00_l049mOWenOGimOWenOGimO
Wol?g`03oda<00i<017oO_Anm7kdO_Anm7kdO_Ano`0:00002@001_mOWenOG`?o00IOWenOGil2o`GO
0ol8g`06oimOWenO0ol029mOWenOGioo1Ml3o`OO00KoWenOGil3o`08WenOGimOWol<0006oenOGimO
0ol01UnOGimOW`;o00EOWenOG`03o`0=GimOWenOGomOWenOG`03o`08GimOWenOGol2C0?o0d`3o`A<
00?oC4`00ol3C0?o14`00ol0000:0006oimOWenO0ol01YmOWenOG`;o00FOGimOW`03o`08WenOGimO
Wol5g`?o1ml00om<C003o`=<0ol5C006og5nLGia0ol0275nLGiaOW7o2P0000T000ooGimOWenOGioo
WenOGil00_l6g`03omoO00OO017oWenOGimOWeooGimOWenOo`06g`03omoO00KO017oWenOGimOWeoo
GimOWenOo`0<000?oenOGimOWenOoimOWenO00;o021OWenOGimOWonOGimOWeooGimOWenOGiooWenO
GimOo`=<00?oC4`01D`01Om<C4co00=<00?oC4`01D`01Om<C4co00`000ooWenOGimOWeooGimOWel0
0_l049mOWenOGimOoenOGimOWol6g`03omoO00KO00GoC4a<o`07C003oda<009<017oO_Anm7kdO_Co
m7kdO_Ano`0:00002@003omOWenOGimOWonOGimOW`02o`KO00?ogml01ml04OnOGimOWenOGomOWenO
Gioo00KO00?ogml01]l04OnOGimOWenOGomOWenOGioo00`000ooGimOWenOGiooWenOGil00_l085nO
GimOWenOoimOWenOGomOWenOGimOWonOGimOWeoo0d`00om<C005C005oda<C?l00d`00om<C005C005
oda<C?l030003onOGimOWenOGomOWenOG`02o`0@WenOGimOWeooGimOWenOo`KO00?ogml01]l01Om<
C4co00M<00?oC4`00T`04OmaOW5nLGiaO_mnLGiaOW7o00X000090007oenOGimOW`02o`06GimOWenO
0_l6g`03omoO00OO00OoWenOGimO00;o00ROGimOWenOo`KO00?ogml01]l01onOGimOWel00_l029mO
WenOGioo30001omOWenOGil00_l01UnOGimOW`;o00IOWenOGil2o`0>GimOWenOGomOWenOGil2o`08
GimOWenOGol3C003oda<009<0ol4C005oda<C?l014`3o`A<00?o00002P001onOGimOWel00_l01YmO
WenOG`;o00JOGimOWel2o`08WenOGimOWol6g`03omoO00KO00GoC4a<o`04C0?o1D`01_mnm7kdOP?o
00Qnm7kdO_Ano`X00009000?oenOGimOWenOoimOWenO00;o1]l00ooOg`07g`0AoimOWenOGimOoenO
GimOWol01]l00ooOg`06g`0AoimOWenOGimOoenOGimOWol030003omOWenOGimOWonOGimOW`02o`0P
GimOWenOGiooWenOGimOoenOGimOWenOoimOWenOGol3C003oda<009<00?oC4`014`01Om<C4co00A<
00?oC4`014`00ol0000:000?oimOWenOGimOoenOGimO00;o012OGimOWenOGomOWenOGioo1]l00ooO
g`06g`05oda<C?l014`00om<C005C00Aog5nLGiaog5nLGiaOW5nLOl02P0000T000KoGimOWel3o`06
GimOWenO0_l5g`;o2Ml01_nOGimOW`?o00ROGimOWenOo`GO0_l8g`06oimOWenO0ol029mOWenOGioo
30001_mOWenOG`?o00IOWenOGil2o`05GimOWel00ol03EnOGimOWeooGimOWel00ol025nOGimOWeoo
0T`2o`A<1?l3C003oda<00;o14`4o`=<00?o00002P001_nOGimOW`?o00JOGimOWel2o`05WenOGil0
0ol029mOWenOGioo1Ml2o`SO00?oC4`00_l4C0Co14`01_mnm7kdOPCo00OdO_Anm7ko00X00009000?
oenOGimOWenOGimOWenO00;o4=l04OnOGimOWenOGimOWenOGioo00oO017oWenOGimOWenOGimOWenO
o`0<000?oenOGimOWenOGimOWenO00;o021OWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOo`m<
00?oC4`03D`00ol0000:000?oimOWenOGimOWenOGimO00;o012OGimOWenOGimOWenOGioo3ml00om<
C00>C00Aog5nLGiaOW5nLGiaOW5nLOl02P0000T000ooGimOWenOGimOWenOGil00_l@g`0AoimOWenO
GimOWenOGimOWol03ml04OnOGimOWenOGimOWenOGioo00`000ooGimOWenOGimOWenOGil00_l085nO
GimOWenOGimOWenOGomOWenOGimOWenOGimOWeoo3d`00om<C00=C003o`0000X000ooWenOGimOWenO
GimOWel00_l049mOWenOGimOWenOGimOWol?g`03oda<00i<017oO_Anm7kdO_Anm7kdO_Ano`0:0000
2@003omOWenOGimOWenOGimOW`02oa3O017oWenOGimOWenOGimOWenOo`0?g`0AoimOWenOGimOWenO
GimOWol030003omOWenOGimOWenOGimOW`02o`0PGimOWenOGimOWenOGimOoenOGimOWenOGimOWenO
Gol?C003oda<00e<00?o00002P003onOGimOWenOGimOWenOG`02o`0@WenOGimOWenOGimOWenOo`oO
00?oC4`03T`04OmaOW5nLGiaOW5nLGiaOW7o00X00009000?oenOGimOWenOGimOWenO00;o4=l04OnO
GimOWenOGimOWenOGioo00oO017oWenOGimOWenOGimOWenOo`0<000?oenOGimOWenOGimOWenO00;o
021OWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOo`m<00?oC4`03D`00ol0000:000?oimOWenO
GimOWenOGimO00;o012OGimOWenOGimOWenOGioo3ml00om<C00>C00AogkdO_Anm7kdO_Anm7kdO_l0
2P0000T000ooGimOWenOGimOWenOGil00_l@g`0AoimOWenOGimOWenOGimOWol03ml04OnOGimOWenO
GimOWenOGioo00`000ooGimOWenOGimOWenOGil00_l085nOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWeoo3d`00om<C00=C003o`0000X000ooWenOGimOWenOGimOWel00_l049mOWenOGimOWenOGimO
Wol?g`03oda<00i<017oLGiaOW5nLGiaOW5nLGiao`0:00002@1Bo``0DOl<05;o2P0000T000?ogml0
3=l2oa3O00?ogml03Ml00ooOg`0=g`03omoO00gO00?o00002P000ooOg`0<g`;o3ml08OmOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiao`0?C003o`0000X000?ogml03=l2o`oO02;oWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW7o3d`00ol0000800002@000ooOg`0<g`;o4=l00ooOg`0=g`03
omoO00gO00?ogml03Ml00ol0000:0003omoO00cO0_l?g`0QoenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7ko00m<00?o00002P000ooOg`0<g`;o3ml08_nOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_l?C003o`0000P000090003omoO00cO0_l@g`03omoO00gO00?ogml03Ml00ooOg`0=g`03
o`0000X000?ogml03=l2o`oO027oGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLOl03d`00ol0
000:0003omoO00cO0_l?g`0RoimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiao`m<00?o0000
200000T000?ogml03=l2oa3O00?ogml03Ml00ooOg`0=g`03omoO00gO00?o00002P000ooOg`0<g`;o
3ml08OmOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Ano`0?C003o`0000X000?ogml03=l2o`oO
02;oWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7ko3d`00ol0000800002@000ooOg`0<g`;o
4=l00ooOg`0=g`03omoO00gO00?ogml03Ml00ol0000:0003omoO00cO0_l?g`0QoenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW7o00m<00?o00002P000ooOg`0<g`;o3ml08_nOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLOl?C003o`0000P000090003omoO00?O0ol6g`;o1Ml3o`SO00?ogml0
0ml3o`OO00?ogml00ml3o`OO00?ogml00ml3o`OO00?o00002P000ooOg`03g`?o1]l2o`GO0ol7g`06
oenOGimO0ol03EnOGimOWeooO_Anm7h00ol027kdO_Anm7ko0T`3o`=<0ol4C003o`0000X000?ogml0
0ml3o`KO0_l5g`?o1ml01_nOGimOW`?o00fOGimOWenOooAnm7kd00?o00WdO_Anm7kdO_l00T`3o`=<
0ol4C003o`0000P000090003omoO00CO00?ogml01Ml2o`KO00?ogml01ml00ooOg`04g`03omoO00KO
00?ogml01=l00ooOg`06g`03omoO00CO00?ogml01]l00ol0000:0003omoO00CO00?ogml01Ml2o`KO
00?ogml01]l08OmOWenOGimOWonOGimOWeooLGiaOW5nLGkoOW5nLGiao`03C003oda<00E<00GoC4a<
o`0<0003omoO00CO00?ogml01Ml2o`KO00?ogml01]l08_nOGimOWenOGomOWenOGiooOW5nLGiaOW7o
LGiaOW5nLOl3C003oda<00E<00GoC4a<o`0:00002@000ooOg`04g`03omoO00GO0_l6g`03omoO00OO
00?ogml01=l00ooOg`06g`03omoO00CO00?ogml01]l00ooOg`04g`03omoO00KO00?o00002P000ooO
g`04g`03omoO00GO0_l6g`03omoO00KO027oGimOWenOGiooWenOGimOogkdO_Anm7kdooAnm7kdO_l0
0d`00om<C005C005oda<C?l030000ooOg`04g`03omoO00GO0_l6g`03omoO00KO02;oWenOGimOWeoo
GimOWenOooAnm7kdO_AnogkdO_Anm7ko0d`00om<C005C005oda<C?l02P0000T000?ogml01=l00ooO
g`05g`;o1]l00ooOg`07g`03omoO00CO00?ogml01]l00ooOg`04g`03omoO00KO00?ogml01=l00ooO
g`06g`03o`0000X000?ogml01=l00ooOg`05g`;o1]l00ooOg`06g`07oenOGimOW`02o`0=GimOWenO
GomaOW5nL@03o`08LGiaOW5nLOl3C003oda<009<0ol4C003o`0000X000?ogml01=l00ooOg`05g`;o
1]l00ooOg`06g`07oimOWenOG`02o`0=WenOGimOWomnLGiaOP03o`09OW5nLGiaOW7o00=<00?oC4`0
0T`3o`A<00?o0000200000T000?ogml01=l00ooOg`05g`;o1]l00ooOg`07g`03omoO00CO00?ogml0
1]l00ooOg`04g`03omoO00KO00?ogml01=l00ooOg`06g`03o`0000X000?ogml01=l00ooOg`05g`;o
1]l00ooOg`06g`0QoenOGimOWenOoimOWenOGomnm7kdO_mnm7kdO_Anm7ko00=<00?oC4`00T`00om<
C004C003o`0000X000?ogml01=l00ooOg`05g`;o1]l00ooOg`06g`0RoimOWenOGimOoenOGimOWood
O_Anm?odO_Anm7kdO_Ano`=<00?oC4`00T`00om<C004C003o`0000P000090003omoO00?O0_l7g`;o
1Ml2o`WO00?ogml00ml2o`SO00?ogml00ml2o`SO00?ogml00ml2o`SO00?o00002P000ooOg`03g`;o
1ml2o`GO0_l8g`06oenOGimO0ol03EnOGimOWeooLGiaOW401?l01giaOW5nLOl00T`2o`A<1?l3C003
o`0000X000?ogml00ml2o`OO0_l5g`;o2=l01_nOGimOW`?o00fOGimOWenOogiaOW5n00Co00QaOW5n
LGiao`9<0_l4C0Co0d`00ol0000800002@000ooOg`0<g`;o4=l00ooOg`0=g`03omoO00gO00?ogml0
3Ml00ol0000:0003omoO00cO0_l?g`0QoenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7ko00m<
00?o00002P000ooOg`0<g`;o3ml08_nOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_l?C003
o`0000P000090003omoO00cO0_l@g`03omoO00gO00?ogml03Ml00ooOg`0=g`03o`0000X000?ogml0
3=l2o`oO027oGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLOl03d`00ol0000:0003omoO00cO
0_l?g`0RoimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiao`m<00?o0000200000T000?ogml0
3=l2oa3O00?ogml03Ml00ooOg`0=g`03omoO00gO00?o00002P000ooOg`0<g`;o3ml08OmOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Ano`0?C003o`0000X000?ogml03=l2o`oO02;oWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7ko3d`00ol0000800002@000ooOg`0<g`;o4=l00ooOg`0=g`03
omoO00gO00?ogml03Ml00ol0000:0003omoO00cO0_l?g`0QoenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW7o00m<00?o00002P000ooOg`0<g`;o3ml08_nOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLOl?C003o`0000P0000805?o2`1Bo`/0Dol:0000201Co`/0D_l;05?o2P0000T000?o0000
2`03oa3O027oWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm?l03d`00ol0000:0003o`0000/0
0ol?g`0QoenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7ko00m<00?o00002P000ol0000;00?o
3ml08_nOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_l?C003o`0000P000090003o`0000;o
00<0ool01@001?l0ool@g`0QoimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGko00m<00?o0000
2P001Ol0ool000;o1P001?l0ool?g`0QoenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW7o00m<
00?o00002P001Ol0ool000;o1P001?l0ool?g`0RoimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiao`m<00?o0000200000T000Oo0000o`3o00D000?o00000_l@g`0QoimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Co00m<00?o00002P001_l00?l0o`H000?o00000_l?g`0QoenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7ko00m<00?o00002P001_l00?l0o`H000?o00000_l?g`0RoimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Ano`m<00?o0000200000T000?o00000P000ol000030004
o`0000;o4=l08OnOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5no`0?C003o`0000X000Go0000
o`060004o`0000;o3ml08OmOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiao`0?C003o`0000X0
00Go0000o`060004o`0000;o3ml08_nOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLOl?C003
o`0000P000090007o`000?l0o`030003o`0000800_l5g`?o2=l01_nOGimOW`?o00fOGimOWenOooAn
m7kd00?o00SdO_Anm7kdo`9<0ol3C0?o14`00ol0000:0006o`00o`3o10000ol0000200;o1Ml3o`OO
00KoGimOWel3o`0=GimOWenOGomnm7kdOP03o`08O_Anm7kdO_l2C0?o0d`3o`A<00?o00002P001_l0
0?l0o`@000?o00000P02o`GO0ol7g`06oimOWenO0ol03ImOWenOGioom7kdO_@00ol02OAnm7kdO_An
o`02C0?o0d`3o`A<00?o0000200000T000?o00000_l0103oo`03o`<00_l6g`03omoO00OO027oWenO
GimOWeooGimOWenOogiaOW5nLGiaog5nLGiaO_l00d`00om<C005C005oda<C?l030001Ol0ool000;o
0P03o`<00_l6g`03omoO00KO027oGimOWenOGiooWenOGimOog5nLGiaOW5nogiaOW5nLOl00d`00om<
C005C005oda<C?l030001Ol0ool000;o0P03o`<00_l6g`03omoO00KO02;oWenOGimOWeooGimOWenO
ogiaOW5nLGiaog5nLGiaOW7o0d`00om<C005C005oda<C?l02P0000T000?o00001@000ol0o`0400;o
1]l00ooOg`07g`0QoimOWenOGimOoenOGimOWoodO_Anm7kdO_mnm7kdO_Co00=<00?oC4`01D`01Om<
C4co00`000?o00001@000ol0o`0400;o1]l00ooOg`06g`0QoenOGimOWenOoimOWenOGomnm7kdO_An
m?odO_Anm7ko00=<00?oC4`01D`01Om<C4co00`000?o00001@000ol0o`0400;o1]l00ooOg`06g`0R
oimOWenOGimOoenOGimOWoodO_Anm7kdO_mnm7kdO_Ano`=<00?oC4`01D`01Om<C4co00X000090003
o`0000@000Go0000o`0300;o1]l00ooOg`07g`07oimOWenOG`02o`0=WenOGimOWomnLGiaOP03o`08
OW5nLGiaO_l3C003oda<009<0ol4C003o`0000X000?o000010001Ol0003o00<00_l6g`03omoO00KO
00OoGimOWenO00;o00eOWenOGimOog5nLGia00?o00QaOW5nLGiao`=<00?oC4`00T`3o`A<00?o0000
2P000ol000040005o`000?l00`02o`KO00?ogml01]l01onOGimOWel00_l03ImOWenOGiooOW5nLGh0
0ol02GiaOW5nLGiao`03C003oda<009<0ol4C003o`0000P000090003o`0000<000?o00000P001?l0
0002o`KO00?ogml01ml08OnOGimOWenOGomOWenOGioom7kdO_Com7kdO_Anm7kdo`03C003oda<009<
00?oC4`014`00ol0000:0003o`0000<000?o00000P001?l00002o`KO00?ogml01]l08OmOWenOGimO
WonOGimOWeooO_Anm7koO_Anm7kdO_Ano`03C003oda<009<00?oC4`014`00ol0000:0003o`0000<0
00?o00000P001?l00002o`KO00?ogml01]l08_nOGimOWenOGomOWenOGioom7kdO_Com7kdO_Anm7kd
O_l3C003oda<009<00?oC4`014`00ol0000800002@000ol000020003o`00008000?o0?l00P02o`GO
0_l9g`06oimOWenO0ol03ImOWenOGiooOW5nLGh01?l01g5nLGiaO_l00T`2o`A<1?l3C003o`0000X0
00?o00000P000ol000020003o`3o00800_l5g`;o2=l01_mOWenOG`?o00eOWenOGimOog5nLGia00Co
00MnLGiaOW7o009<0_l4C0Co0d`00ol0000:0003o`00008000?o00000P000ol0o`0200;o1Ml2o`SO
00KoWenOGil3o`0=WenOGimOWomnLGiaOP04o`08LGiaOW5nLOl2C0;o14`4o`=<00?o0000200000T0
00Go0000o`050003o`3o00800_l@g`0QoimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Co00m<
00?o00002P001Ol0003o00D000?o0?l00P02o`oO027oGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_l03d`00ol0000:0005o`000?l01@000ol0o`0200;o3ml08_nOGimOWenOGimOWenOGioom7kd
O_Anm7kdO_Anm7kdO_l?C003o`0000P000090004o`00o`D00_l0103oo`02oa3O027oWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaO_l03d`00ol0000:0004o`00o`D00_l0103oo`02o`oO027oGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLOl03d`00ol0000:0004o`00o`D00_l0103oo`02o`oO
02;oWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW7o3d`00ol0000800002@000ol0o`0<00;o
4=l08OnOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdo`0?C003o`0000X000?o0?l03002o`oO
027oGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_l03d`00ol0000:0003o`3o00`00_l?g`0R
oimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Ano`m<00?o0000200000T00_l=00;o4=l08OnO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5no`0?C003o`0000X00_l=00;o3ml08OmOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiao`0?C003o`0000X00_l=00;o3ml08_nOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLOl?C003o`0000P0000905;o301Ao``0D_l:00006002oe`00_mK00;o
B`000?l08@000?l08@0003D00_l@00;o2@03och00_l@00;o2003od@00_l@00;o0`03oa00000e0003
o`00010000?o000020000ol0000m0003o`00010000?o00001`000ol000130003o`00010000?o0000
0P000ol0000?00002P001Ol0003o00801?l200Co0P03o`030?oo00?o0P05o`030?oo00?o0P000ol0
000200Go00<0ool00ol00`3oo`03o`T000?o00004@03o`@00ol200Go00@0ool01ol200[o0`001?l0
0005o`801?l20005o`3o0?l020000ol0000A0006o`000?l01ol00`3oo`0300Co00<0ool02?l200Ko
00<0ool01Ol0103oo`0=o`030?l000@000?o00003P0000X000Oo0000o`3o00D000?o000010001_l0
0?l0o`<000Go0000o`0400?o0`000ol0000200;o0P000ol0o`020004o`0000;o0P000ol000060003
o`00014000Co003o0P001Ol0003o00<000Go0000o`020004o`00o`<000Go0000o`0300?o10000ol0
000200;o00@0o`3o0`002?l00?l0o`3o20000ol0000A0005o`000?l00`001ol0003o0?l00`000ol0
000300;o00D0ool0o`030003o`0000?o00<0o`000ol30003o`3o00<000?o00000`001Ol0o`3o0080
00?o00000`000ol0000>00002P001_l0o`3o00Go00<0ool00ol20003o`00008000Go0000o`030006
o`000?l00_l30003o`0000801Ol01@3o003o00<00_l20003o`0000D000?o0?l04P001?l00?l20005
o`000?l00`001Ol0003o008000Co003o0`001Ol0003o00<01?l30003o`0000800_l0103o0?l30008
o`00o`3o0?l70003o`3o018000Go0?l0o`030003o`00008000?o00000P05o`080?l0o`3o0?l30003
o`0000?o00@0ool00_l300;o1005o`060?l0o`3o0P000ol000020003o`3o00l0000:0007o`3o0?l0
o`030003o`3o00<000Co003o10001Ol0003o00<000Co00000_l00`3o00020003o`0000800_l400?o
1002o`8000?o00001@000ol0o`0E0004o`00o`<000Go0000o`030004o`00o`8000Go0000o`030006
o`000?l00_l30003o`0000800_l300Co0`001Ol0o`3o00L000?o0?l04P001Ol0o`3o00<000Oo0000
o`3o00<000Ko0000o`02o`050?oo0?l00`000ol00003o`030?oo008000Oo0000o`3o00<000Co0000
1?l20004o`00o`@000?o0?l03`0000X00_l00`3oo`0200?o0`03o`801?l20005o`000?l00P02o`80
0ol00`3oo`020003o`0000800_l20003o`3o00<000?o00000_l20003o`0000@00_l00`3oo`0D0004
o`0000?o0`02o`801Ol20005o`000?l00P02o`800_l0103oool20003o`0000800_l300;o0P000ol0
0005o`H00_l00`3oo`0A00;o00<0ool00P02o`800_l00`3oo`0300?o0P05o`030?l0008000?o0?l0
1_l01@3oool000;o00<0ool00P04o`030?l000Co0P001?l00002o`030?oo00h0000900;o0`02o`d0
00Co00001Ol?00;o0`05o`030?oo00?o00<0ool00olN00Co4P05o`l00_l200?o1004o`030?oo00;o
00<0ool06P02o`<00_lF00Ko3`02o`<00_l400Co00<0o`000_lF00007@000ol0000:0003o`0004T0
00?o00003`000ol000120003o`0001000_l90003o`0000@000?o00004002oaT00000\
\>"],
  ImageRangeCache->{{{0, 287}, {98, 0}} -> {-0.0855627, -0.0257867, 
  0.0110492, 0.0110492}, {{7.6875, 92.5625}, {95.625, 
  2.3125}} -> {-1.60221, -0.284517, 0.0618895, 0.0618895}, {{101.062, 
  185.875}, {95.625, 2.3125}} -> {-7.38099, -0.285127, 0.0619019, 
  0.0619019}, {{194.375, 279.25}, {95.625, 2.3125}} -> {-13.1562, -0.284517, 
  0.0618895, 0.0618895}},
  CellTags->"OtherNum"]
}, Open  ]],

Cell[TextData[{
  "While ",
  StyleBox["MeetDivisors", "MR"],
  " and ",
  StyleBox["JoinDivisors", "MR"],
  " do not appear to be groups (with ",
  Cell[BoxData[
      \(TraditionalForm\`n = 15\)]],
  "), ",
  StyleBox["MixedDivisors", "MR"],
  " does. What about other values of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " for ",
  StyleBox["MixedDivisors", "MR"],
  "?"
}], "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[{n, \ GroupQ[MixedDivisors[n]]}, {n, \ 10, \ 18}]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"OtherNum"],

Cell[BoxData[
    \({{10, True}, {11, True}, {12, False}, {13, True}, {14, True}, {15, 
        True}, {16, False}, {17, True}, {18, False}}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"OtherNum"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RootsOfUnity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"solutions", " ", "of", 
                StyleBox[
                  FormBox[
                    FormBox[
                      RowBox[{" ", 
                        RowBox[{\(x\^n\), " ", 
                          StyleBox["=",
                            "MR"], 
                          StyleBox[" ",
                            "MR"], 
                          StyleBox["1",
                            "MR"]}]}],
                      "NotebookDefault"],
                    "TraditionalForm"],
                  "TI"]}], ",", " ", \(under\ multiplication\)}]},
          {
            StyleBox["IntegerUnits",
              "MR"], 
            RowBox[{
              RowBox[{"solutions", " ", "of", " ", 
                StyleBox[
                  FormBox[
                    FormBox[
                      RowBox[{" ", 
                        RowBox[{\(x\^2\), " ", 
                          StyleBox["=",
                            "MR"], " ", 
                          StyleBox["1",
                            FontSlant->"Plain"]}]}],
                      "NotebookDefault"],
                    "TraditionalForm"],
                  "TI"]}], ",", " ", \(under\ multiplication\)}]},
          {
            StyleBox["GaussianUnits",
              "MR"], 
            RowBox[{
              RowBox[{"solutions", " ", "of", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      FormBox[
                        RowBox[{" ", 
                          RowBox[{\(x\^4\), " ", 
                            StyleBox["=",
                              "MR"]}], " "}],
                        "NotebookDefault"], 
                      StyleBox["1",
                        FontSlant->"Plain"]}],
                    "TraditionalForm"],
                  "TI"]}], ",", " ", \(under\ multiplication\)}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherNum", "i:12"}],

Cell[TextData[{
  StyleBox["RootsOfUnity",
    FontFamily->"Courier"],
  " functions."
}], "Caption",
  CellTags->"OtherNum"],

Cell[TextData[{
  "Observe that the elements of ",
  StyleBox["RootsOfUnity[5]", "MR"],
  " are evenly distributed on the unit circle."
}], "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RootsOfUnity[5, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"OtherNum"],

Cell[BoxData[
    \("These are the (complex) numbers that are solutions to the equation x^5 \
- 1 = 0. The operation is ordinary (complex) multiplication, which in this \
case simplifies to adding the arguments (angles relative to the positive \
x-axis).\n"\)], "Print",
  CellTags->"OtherNum"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.333333 0.5 0.333333 [
[.16667 .4875 -6 -9 ]
[.16667 .4875 6 0 ]
[.33333 .4875 -12 -9 ]
[.33333 .4875 12 0 ]
[.66667 .4875 -9 -9 ]
[.66667 .4875 9 0 ]
[.83333 .4875 -3 -9 ]
[.83333 .4875 3 0 ]
[.4875 .16667 -12 -4.5 ]
[.4875 .16667 0 4.5 ]
[.4875 .33333 -24 -4.5 ]
[.4875 .33333 0 4.5 ]
[.4875 .66667 -18 -4.5 ]
[.4875 .66667 0 4.5 ]
[.4875 .83333 -6 -4.5 ]
[.4875 .83333 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16667 .5 m
.16667 .50625 L
s
[(-1)] .16667 .4875 0 1 Mshowa
.33333 .5 m
.33333 .50625 L
s
[(-0.5)] .33333 .4875 0 1 Mshowa
.66667 .5 m
.66667 .50625 L
s
[(0.5)] .66667 .4875 0 1 Mshowa
.83333 .5 m
.83333 .50625 L
s
[(1)] .83333 .4875 0 1 Mshowa
0 .5 m
1 .5 L
s
.5 .16667 m
.50625 .16667 L
s
[(-1)] .4875 .16667 1 0 Mshowa
.5 .33333 m
.50625 .33333 L
s
[(-0.5)] .4875 .33333 1 0 Mshowa
.5 .66667 m
.50625 .66667 L
s
[(0.5)] .4875 .66667 1 0 Mshowa
.5 .83333 m
.50625 .83333 L
s
[(1)] .4875 .83333 1 0 Mshowa
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
newpath
.5 .5 .33333 0 365.73 arc
s
0 0 1 r
.055 w
.83333 .5 Mdot
.60301 .81702 Mdot
.23033 .69593 Mdot
.23033 .30407 Mdot
.60301 .18298 Mdot
0 0 0 r
[(1)] .93333 .5 0 0 Mshowa
[( \\(2 I\\)/5 Pi)(E)] .63391 .91212 0 0 Mshowa
[( \\(4 I\\)/5 Pi)(E)] .14943 .75471 0 0 Mshowa
[( \\(-4 I\\)/5 Pi)(E)] .14943 .24529 0 0 Mshowa
[( \\(-2 I\\)/5 Pi)(E)] .63391 .08788 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0?l01?n:0000S`001?l00?n=0000S`001?l00?n=0000S`000ol00003oh/0
002?0004o`00ohd0002?0003o`3o00CoRP0008l000?o0000SP0008l000?o0000SP0008l000?o0000
SP0008l000?o0000SP0008l000?o000020000ol0000J0003o`0006H0002?0003o`0000L000?o0000
70001Ol0003o06<0002?0003o`0000L000?o00002004o`P01Ol30005o`000?l01@03o`P00ol400Go
A`0008l000?o00001`000ol000090003o`0000X000?o00000`000ol000020003o`0000D000?o0000
1P000ol000050003o`0004L0002?0003o`0000L000?o00000P05o`<000?o00002@000ol000030003
o`00008000?o00001@000ol0000600?o1@000ol000170000S`000ol000070003o`0000/000?o0000
20000ol000030003o`0000<000Co00000ol90004o`00o`@000?o0000A`0008l000?o00001`000ol0
00080004o`00o`X000?o00000`000ol000030005o`000?l02`001?l00?l300;oB@0008l000?o0000
20000ol0000800;o2@05o`8000?o00001@000ol00004o`L01?m?0000S`000ol0000]0003o`0001@0
00?o0000A`0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008H0
0ol60003o`0001P01Daa0000Q`000ol000050003o`0001H02Da_0000P005o`8000?o0?l03?lA00]<
KP0008002Ol60003o`0000@02_l600e<K@0007/01Ol70003o`0000D000?o00003P04o`803Da]0000
MP05o`/00_l70003o`00018000?oC4`03Da/0000M002oaT000?o00004`0?C6`0001`00Co6`000ol0
000C00m<K00006d00olO0003o`0001<03da/0000J`02ob8000?o00004`0?C6`0001Y00;o90000ol0
000D00e<00<0ool0JP0006L00_lV0003o`0001@03D`300?oI`0006D00_lX0003o`0001D02d`700;o
I@0006800olZ0003o`0001H02D`:00;oH`0006000_l]0003o`0001P01D`>00;oH@0005h00_l_0003
o`0002d00_mO0000G@000ol0000_0003o`0002l000?o0000G00000H01OmA0003o`00030000?o0000
<0000ol0001K00001`000ol0001@00;o<`000ol0000a00;oF`0000L000?o0000CP02ocD000?o0000
<`02oeT0000700?oC@000ol0000e0003o`0003D000?o0000EP0000L000?o0000C0000ol0000f0003
o`0003H000?o0000E@0000H01Om900;o>@000ol0000g00;oE@0005<000?o0000>@000ol0000i0003
o`000580001C0003o`0003T000?o0000>P000ol0001A0000D@02oc`000?o0000>`000ol0001@0000
D0000ol0000l0003o`0003`000?o0000C`0000l000?o00006P000ol0000P0003o`0003d000?o0000
?@000ol0001>00003P000ol0000L0005o`000?l070000ol0000n0003o`0003h000?o0000C@0000h0
00?o00002@03o`P01Ol30005o`000?l01@03o`P00ol400Go@@000ol0000o0003o`0004`0000>0003
o`0000X000?o00002@000ol000030003o`00008000?o00001@000ol000060003o`0000D00_m20003
o`0004000_m<00003P000ol0000200Go00<0ool00_l:0003o`0000<000?o00000P000ol000050003
o`0000H00ol50003o`00044000?o0000@P000ol0001900003P000ol000080003o`3o00/000?o0000
0`000ol000030004o`0000?o2@001?l00?l300;o@`000ol000120003o`0004T0000>0003o`0000P0
00?o0?l02`000ol000030003o`0000<000Go0000o`0;0004o`00o`800om30003o`0004<000?o0000
B00000l000?o00002002o`T01Ol20003o`0000D000?o00001?l700Co0P000ol000140003o`0004@0
00?o0000A`0003@000?o00002005C0<000Go0000o`130003o`0004D000?o0000AP0003d02D`00ol0
00160003o`0004D000?o0000AP0003`02da80003o`0004H00_m60000>`0=C4L000?o0000B0000ol0
00130000>`0=C4L000?o0000B0000ol000130000>P0?C4H000?o0000B@000ol000120000>P0?C4H0
00?o0000BP000ol000110000>P0?C4H000?o0000B`000ol000100000>P0?C4H000?o0000B`000ol0
00100000>P0?C4H000?o0000C0000ol0000o0000>`0=C4L000?o0000C0000ol0000o0000>`0=C4L0
00?o0000C@000ol0000n0000?00;C4P000?o0000CP000ol0000m0000?@09C3D00_l400;o0`03o`H0
00?o0000C`000ol0000l0000?@000ol0C004C3H000Co003o0`02o`H000?o00000`000ol0001?0003
o`0003`0000l0003o`0003D01Ol01@3o003o00/000?o00000`03oe0000?o0000>`0003`000?o0000
>`001?l00?l800?o1P000ol0001@0003o`0003/0000k0003o`0003`000Co003o20000ol000060003
o`00054000?o0000>P0003/000?o0000?@02o`T01?l50003o`00054000?o0000>P0003X000?o0000
DP000ol0001B0003o`0003T0000j0003o`00058000?o0000DP000ol0000i0000>@000ol0001C0003
o`0005<000?o0000>00003T000?o0000D`000ol0001C0003o`0003P0000h0003o`0005@000?o0000
D`000ol0000h0000>0000ol0001D0003o`0005@000?o0000=`0003P000?o0000E0000ol0001D0003
o`0003L0000g0003o`0005D000?o0000E@000ol0000f0000=`000ol0001E0003o`0005D000?o0000
=P0003H000?o0000EP000ol0001F0003o`0003D0000f0003o`0005H000?o0000EP000ol0000e0000
=@000ol0001G0003o`0005L000?o0000=00003D000?o0000E`000ol0001G0003o`0003@0000d0003
o`0005P000?o0000F0000ol0000c0000=0000ol0001H0003o`0005P000?o0000<`0003@000?o0000
F0000ol0001H0003o`0003<0000d0003o`0005P000?o0000F0000ol0000c0000=0000ol0001H0003
o`0005P000?o0000<`0003<000?o0000F@000ol0001I0003o`000380000c0003o`0005T000?o0000
F@000ol0000b0000<P000ol0001J0003o`0005X000?o0000<@00038000?o0000FP000ol0001J0003
o`000340000b0003o`0005X000?o0000FP000ol0000a0000<P000ol0001J0003o`0005X000?o0000
<@00038000?o0000FP000ol0001J0003o`000340000a0003o`0005/000?o0000F`000ol0000`0000
<@000ol0001K0003o`0005/000?o0000<000034000?o0000F`000ol0001K0003o`000300000a0003
o`0005/000?o0000F`000ol0000`0000<0000ol0001L0003o`0005`000?o0000;`00030000?o0000
G0000ol0001L0003o`0002l0000`0003o`0005`000?o0000G0000ol0000_0000<0000ol0001L0003
o`0005`000?o0000;`0003000olX00;o1002o`<00olV0003o`0002H00_l400;o0`03obL00ol`0000
<002obP000Co003o0`02o`H000?o00008`000ol0000U0004o`00o`<00_l60003o`0002D000?o0000
;`0002X01Ol00`3oo`0R00Go00D0o`00o`0;0003o`0002<000?o00009@001?l00?l;0003o`0002D0
00?o0000;`0003000_lX0004o`00o`P00olV0003o`0002D000Co003o2003obP000?o0000;`000300
0_lX0004o`00o`P000?o00009P000ol0000U0004o`00o`P000?o00009P05C2l0000`00;o:@02o`T0
1?lU0003o`0002H00_l900Co8`09C2d0000_0003o`0005d000?o0000E`0;C2`0000_0003o`0005d0
00?o0000EP0=C2/0000_0003o`0005d000?o0000EP0=C2/0000_0003o`0005d000?o0000E@0?C1<0
0olD0000;`000ol0001M0003o`0005D03d`D0003o`0001<0003Wo`m<:_l002l000?o0000;@000ol0
000]0003o`0002d000?o00009@0?C1@000?o00004`0002l000?o0000;@000ol0000]0003o`0002d0
00?o00009@0?C1@000?o00004`0002l000?o0000G@000ol0001F00e<5002oaD0000_0003o`0005d0
00?o0000EP0=C2/0000_0003o`0005d000?o0000E`0;C2`0000_0003o`0005d000?o0000F009C2d0
000`0003o`0005`000?o0000FP05C2l0000`0003o`0005`000?o0000G0000ol0000_0000<0000ol0
001L0003o`0005`000?o0000;`00030000?o0000G0000ol0001L0003o`0002l0000`0003o`0005`0
00?o0000G0000ol0000_0000<0000ol0001L0003o`0005`000?o0000;`00030000?o0000G0000ol0
001L0003o`0002l0000`0003o`0005`000?o0000G0000ol0000_0000<0000ol0001L0003o`0005`0
00?o0000;`00034000?o0000F`000ol0001K0003o`000300000a0003o`0005/000?o0000F`000ol0
000`0000<@000ol0001K0003o`0005/000?o0000<000034000?o0000F`000ol0001K0003o`000300
000a0003o`0005/000?o0000F`000ol0000`0000<P000ol0001J0003o`0005X000?o0000<@000380
00?o0000FP000ol0001J0003o`000340000b0003o`0005X000?o0000FP000ol0000a0000<P000ol0
001J0003o`0005X000?o0000<@00038000?o0000FP000ol0001J0003o`000340000c0003o`0005T0
00?o0000F@000ol0000b0000<`000ol0001I0003o`0005T000?o0000<P0003@000?o0000F0000ol0
001H0003o`0003<0000d0003o`0005P000?o0000F0000ol0000c0000=0000ol0001H0003o`0005P0
00?o0000<`0003@000?o0000F0000ol0001H0003o`0003<0000e0003o`0005L000?o0000E`000ol0
000d0000=@000ol0001G0003o`0005L000?o0000=00003D000?o0000E`000ol0001G0003o`0003@0
000f0003o`0005H000?o0000EP000ol0000e0000=P000ol0001F0003o`0005H000?o0000=@0003L0
00?o0000E@000ol0001E0003o`0003H0000g0003o`0005D000?o0000E@000ol0000f0000>0000ol0
001D0003o`0005@000?o0000=`0003P000?o0000E0000ol0001D0003o`0003L0000i0003o`0005<0
00?o0000D`000ol0000h0000>@000ol0001C0003o`0005<000?o0000>00003X000?o0000DP000ol0
001C0003o`0003P0000j0003o`00058000?o0000DP000ol0000i0000>P000ol0001B0003o`000580
00?o0000>@0003/000?o0000?@02o`@00_l300?o1P000ol0001A0003o`0003X0000k0003o`0003`0
00Co003o0`02o`H000?o00000`000ol0001A0003o`0003X0000l0003o`0003/000Co003o2`000ol0
000300?oD0000ol0000k0000?0000ol0000k0004o`00o`P00ol60003o`00050000?o0000>`0003d0
00?o04`014`f0004o`00o`P000?o00001P000ol0001?0003o`0003`0000m00U<=@02o`T01?l50003
o`0004h000?o0000?@0003`02da80003o`0004d000?o0000?P0003/03Da70003o`0004d000?o0000
?P0003/03Da70003o`0004`000?o0000?`0003X03da60003o`0004`000?o0000?`0003X03da60003
o`0004/000?o0000@00003X03da60003o`0004X000?o0000@@0003X03da60003o`0004T000?o0000
@P0003X03da60003o`0004T000?o0000@P0003/03Da70003o`0004L00_m50000>`0=C4L000?o0000
AP000ol000150000?00;C4P000?o0000AP000ol000150000?@09C0030?l004H000?o0000A@000ol0
00160000?`05C0@000?o0000A0000ol000140003o`0004L0000900Go>`000ol000130003o`0004<0
00?o0000B00000X000?o0000?@000ol000120003o`00048000?o0000B@0000X000?o0000?P000ol0
00110003o`00044000?o0000BP0000X00olo0003o`00040000?o0000@0000ol0001;00002P000ol0
00100003o`0003l000?o0000?`000ol0001<00002@05od0000?o0000?P000ol0000n0003o`0004d0
001?0003o`0003d000?o0000?@000ol0001>0000D002ocd000?o0000>`02oe40001B0003o`0003X0
00?o0000>P000ol0001A0000DP000ol0000j0003o`0003X000?o0000D@00018000?o000050000ol0
000W00;o>P000ol0000h00;oE000014000?o00005P001Ol0003o02H000?o0000=`000ol0000g0003
o`0005@0000A0003o`0000<00ol800Go0`001Ol0003o00D00ol800?o1005o`/000?o0000=P000ol0
000f0003o`0005D0000A0003o`0000@000?o00002@000ol000030003o`00008000?o00001@000ol0
00060003o`0000D000?o00003002ocH000?o0000=002oeP0000A0003o`0000801?l:0003o`0000<0
00?o00000P000ol000050003o`0000H00ol50003o`0000h00_ld0003o`0003800_mJ00004@000ol0
00020003o`3o00/000?o00000`000ol000030004o`0000?o2@001?l00?l40003o`00010000?o0000
<@000ol0000a0003o`0005X0000A0003o`00008000?o0?l02`000ol000030003o`0000<000Go0000
o`0;0004o`00o`<00_lC0003o`00030000?o0000<0000ol0001K00004P000ol0000200;o2@05o`80
00?o00001@000ol00004o`L01?lJ00;o<0000ol0000^00;oGP00034000?o000050000ol0000D00;o
;P000ol0000/00;oH00006400_l/0003o`0001P01D`=00;oHP0006<00_lZ0003o`0001H02D`900;o
I00006D00olW0003o`0001D02d`600;oIP0006P00_lU0003o`0001@03D`200?oJ00006X00_lS0003
o`0001@03D`2of/0001/00;o8@000ol0000C00m<K00006h00olN0003o`0001<03da/0000L@04oaX0
00?o00004`0?C6`0001e00;o60000ol0000C00m<K00007L01OlC0003o`0001400_l?C6`0001l00Go
1@03o`H000?o00003@04o`<03Da]0000P@09o`D000?o00000`0:o`L03Da]0000Q`000ol0000;oa80
2da^0000Q`000ol000050003o`0001H02Da_0000Q`000ol000050003o`0001P01Daa0000QP02o`L0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l0
00?o0000SP0008l000?o00000P05ohL0002?0003o`0000<000?o0000R00008l000?o00000`000ol0
00280000S`000ol0000300?oR00008l000?o00000`000ol000280000S`000ol0000200GoQ`0008l0
00?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o0000SP0008l000?o00002`000ol0
000D0003o`0006T0002?0003o`0000X000?o00005P001Ol0003o06H0002?0003o`0000X000?o0000
0P04o`P01Ol30005o`000?l01@03o`P00ol400GoBP0008l000?o00002P000ol000030003o`0000X0
00?o00000`000ol000020003o`0000D000?o00001P000ol000050003o`0004X0002?0003o`0000X0
00?o000010000ol000090003o`0000<000?o00000P000ol000050003o`0000H00ol50003o`0004X0
002?0003o`0000X000?o00001@000ol000080003o`0000<000?o00000`001?l00003o`T000Co003o
10000ol0001:0000S`000ol0000:0003o`00008000Co003o2P000ol000030003o`0000<000Go0000
o`0;0004o`00o`<00_m<0000S`000ol0000;0003o`0000800_l900Go0P000ol000050003o`0000Co
1`04oe80002?0003o`0002X000?o000050000ol0001:0000S`000ol0002>0000S`000ol0002>0000
S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000
S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000
S`000ol0002>0000S`000ol0002>0000S`000ol0002>0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.50002, -1.50002, 0.0104531, 
  0.0104531}},
  CellTags->"OtherNum"],

Cell[BoxData[
    \(Groupoid[{1, E\^\(\(2\ I\ \[Pi]\)\/5\), E\^\(\(4\ I\ \[Pi]\)\/5\), 
        E\^\(-\(\(4\ I\ \[Pi]\)\/5\)\), E\^\(-\(\(2\ I\ \[Pi]\)\/5\)\)}, 
      Exp[I\ \((Arg[#1] + Arg[#2])\)]&]\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"OtherNum"]
}, Open  ]],

Cell[TextData[{
  "Here we compare the elements in ",
  StyleBox["IntegerUnits", "MR"],
  " with ",
  StyleBox["RootsOfUnity[2]", "MR"],
  " and those in ",
  StyleBox["GaussianUnits", "MR"],
  " with ",
  StyleBox["RootsOfUnity[4]", "MR"],
  ". Then we ask if these are the same sets in both cases."
}], "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{

Cell[BoxData[
    \({els\  = \ 
        Map[Elements, {{IntegerUnits, \ RootsOfUnity[2]}, {GaussianUnits, 
              RootsOfUnity[4]}}, 1], \ Apply[SameSetQ, \ els, \ {1}]}\)], 
  "Input",
  CellLabel->"In[20]:=",
  CellTags->"OtherNum"],

Cell[BoxData[
    \({{{{1, \(-1\)}, {1, \(-1\)}}, {{1, \(-1\), I, \(-I\)}, {1, I, \(-1\), 
            \(-I\)}}}, {True, True}}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"OtherNum"]
}, Open  ]],

Cell["2.4.3 Groups of permutations", "Subsubsection",
  CellTags->{"Permutations", "i:13"}],

Cell[TextData[{
  "Given a list of integers ",
  Cell[BoxData[
      \(TraditionalForm\`T\  = \ {1, \ 2, \ 3, \ \[Ellipsis], \ n}\)]],
  ", a permutation on ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " is a bijective function \[Pi] : ",
  Cell[BoxData[
      FormBox[
        RowBox[{"T", " ", 
          StyleBox["\[RightArrow]",
            "MR"], " ", "T"}], TraditionalForm]]],
  ". The collection of all permutations on ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " is called the ",
  StyleBox["symmetric",
    FontSlant->"Italic"],
  " ",
  StyleBox["group",
    FontSlant->"Italic"],
  " on ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  ". Each permutation can be more easily viewed by considering the ordered \
set of images of the set ",
  Cell[BoxData[
      \(TraditionalForm\`T\)]],
  " under ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\)]],
  "."
}], "Text",
  CellTags->"Permutations"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Symmetric",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["{",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["1",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["2",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["3",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["\[Ellipsis]",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], "the", " ", 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["MultiplyPermutations",
                  "MR"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["which",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["assumes",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(ProductOrder\  \[Rule] \ RightToLeft\),
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["Symmetric",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["{",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["1",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["2",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["3",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["\[Ellipsis]",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              RowBox[{
                RowBox[{
                  StyleBox["operation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["MultiplyPermutations",
                    "MR"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["with",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["options",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["given",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["by",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["opts",
                    FontSlant->"Italic"]}]}]}]},
          {
            RowBox[{
              StyleBox["S",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Symmetric",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["SymmetricGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Symmetric",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{
                      StyleBox["n",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["opts",
                        "TI"]}], 
                    StyleBox["]",
                      "TI"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["PermutationGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Symmetric",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["SymmetricGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], "the", " ", 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplies",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["these",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutations",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(with\ the\ options\ given\ by\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["PermutationGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["SymmetricGroup",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Permutations", "i:14"}],

Cell[TextData[{
  StyleBox["Symmetric",
    FontFamily->"Courier"],
  " and related functions."
}], "Caption",
  CellTags->"Permutations"],

Cell["\<\
There are several options specific to the permutation \
functions.\
\>", "Text",
  CellTags->"Permutations"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["ProductOrder",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["RightToLeft",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["permutations",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplied",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["right",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["left",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((default)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["left",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["right",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                StyleBox["LeftToRight",
                  "MR"], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox["IndexLimit",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["6",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["maximum",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["value",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["index",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["permutation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["functions",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.22, 0.22, 0.56},
  RowLines->{True, False}},
  CellTags->{"Permutations", "i:16"}],

Cell[TextData[{
  "Options for ",
  StyleBox["Symmetric",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Permutations"],

Cell[TextData[{
  "The group ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " is obtained as the set of permutations of the elements {1, 2, 3} under \
permutation multiplication."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G1\  = \ Symmetric[3]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(Groupoid[{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 
          1}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "The operation of this group is the function ",
  StyleBox["MultiplyPermutations", "MR"],
  " using the option ",
  StyleBox["ProductOrder", "MR"],
  " with the default value of ",
  StyleBox["RightToLeft", "MR"],
  " (as opposed to ",
  StyleBox["LeftToRight", "MR"],
  ")."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(op\  = \ Operation[G1]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(MultiplyPermutations[#1, #2, ProductOrder \[Rule] DefaultOrder]&\)], 
  "Output",
  CellLabel->"Out[22]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "The value for the global constant ",
  StyleBox["DefaultOrder", "MR"],
  " is set directly or by the ",
  StyleBox["ProductOrder", "MR"],
  " option."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefaultOrder\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(RightToLeft\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "Given permutations ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\_2\)]],
  ", the product ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Pi]\_1\) \[EmptySmallCircle]\ \ \[Pi]\_2\)]],
  " is obtained by doing ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\_2\)]],
  " first, followed by ",
  Cell[BoxData[
      \(TraditionalForm\`\[Pi]\_1\)]],
  " (when the value for ",
  StyleBox["ProductOrder", "MR"],
  " is ",
  StyleBox["RightToLeft", "MR"],
  ")."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(op[{1, 3, 2}, {2, 3, 1}]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \({3, 2, 1}\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "By changing the value of ",
  StyleBox["ProductOrder", "MR"],
  " to ",
  StyleBox["LeftToRight", "MR"],
  ", we can change how the group operation works. (Some mathematicians prefer \
this interpretation, so it is available.) Here we perform the operation from \
left to right."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Operation[Symmetric[3, \ ProductOrder\  \[Rule] \ LeftToRight]]\)[{1, 
        3, 2}, {2, 3, 1}]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \({2, 1, 3}\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`S\_n\)]],
  " becomes quite large with even small values of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", the user is warned when trying to create a group with an index greater \
than the value of ",
  StyleBox["IndexLimit", "MR"],
  "."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Symmetric[7]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(Group::"size" \( : \ \) 
      "Are you sure you want \!\(\"S[7]\"\)? This group has \!\(\"5040\"\) \
elements in it. By default, the index must be less than or equal to \!\(6\). \
If you wish to increase it, add the option 'IndexLimit -> k' to this \
function, where k is the desired maximum for the index."\)], "Message",
  CellTags->"Permutations"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "Adding a higher value for the option ",
  StyleBox["IndexLimit", "MR"],
  " allows creation of such groups."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Symmetric[7, \ IndexLimit\  \[Rule] \ 7]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(Groupoid[{"-Elements-"}, "-Operation-"]\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell["\<\
We can also specify that the new value become the default value for \
the option.\
\>", "MathCaption",
  CellTags->{"Permutations", "i:17"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[Symmetric, \ IndexLimit\  \[Rule] \ 7\ ]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \({Mode \[Rule] Computational, ProductOrder \[Rule] RightToLeft, 
      IndexLimit \[Rule] 7}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[
"We can obtain the permutation group on the set {\[Alpha], \[Beta], \[Gamma]} \
as follows."], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G2\  = \ PermutationGroup[{\[Alpha], \ \[Beta], \ \[Gamma]}]\)], "Input",\

  CellLabel->"In[29]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(Groupoid[{{\[Alpha], \[Beta], \[Gamma]}, {\[Alpha], \[Gamma], 
          \[Beta]}, {\[Beta], \[Alpha], \[Gamma]}, {\[Beta], \[Gamma], 
          \[Alpha]}, {\[Gamma], \[Alpha], \[Beta]}, {\[Gamma], \[Beta], 
          \[Alpha]}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell["The default operation is again from right to left.", "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Operation[G2]\)[{\[Alpha], \ \[Gamma], \ \[Beta]}, {\[Beta], \ 
        \[Gamma], \ \[Alpha]}]\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \({\[Gamma], \[Beta], \[Alpha]}\)], "Output",
  CellLabel->"Out[30]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell["The left-to-right option is still available.", "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Operation[
        PermutationGroup[{\[Alpha], \ \[Beta], \ \[Gamma]}, \ 
          ProductOrder\  \[Rule] \ LeftToRight]]\)[{\[Alpha], \ \[Gamma], \ 
        \[Beta]}, {\[Beta], \ \[Gamma], \ \[Alpha]}]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \({\[Beta], \[Alpha], \[Gamma]}\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell[TextData[{
  "Each permutation can be described as being either odd or even. (More \
details, and functions to determine whether a permutation is odd or even, are \
given in chapter 5.) The collection of even permutations is called the ",
  StyleBox["alternating group",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"Permutations", "i:18"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Alternating",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["elements",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["are",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["all",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["even",
                    FontSlant->"Italic"], 
                  
                  StyleBox[\(\ 
                    permutations\ of\ \({1, \ 2, \ 3, \ \[Ellipsis], \ \)\),
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["MultiplyPermutations",
                "MR"], 
              StyleBox[\(\(, \ which\ assumes\)\ \),
                SingleLetterItalics->False], 
              StyleBox[\(ProductOrder\  \[Rule] \ RightToLeft\),
                "MR"]}]},
          {
            RowBox[{
              StyleBox["Alternating",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["even",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["{",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["1",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["2",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["3",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["\[Ellipsis]",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], "the", " ", 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["MultiplyPermutations",
                  "MR"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["using",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["options",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["given",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["A",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Alternating",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["AlternatingGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Alternating",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Permutations", "i:19"}],

Cell[TextData[{
  StyleBox["Alternating",
    FontFamily->"Courier"],
  " and related functions."
}], "Caption",
  CellTags->"Permutations"],

Cell[TextData[{
  "The group ",
  Cell[BoxData[
      \(TraditionalForm\`A\_4\)]],
  " is obtained as the set of even permutations of the elements {1, 2, 3, 4} \
under permutation multiplication."
}], "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = \ Alternating[4]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \(Groupoid[{{1, 2, 3, 4}, {1, 3, 4, 2}, {1, 4, 2, 3}, {2, 1, 4, 3}, {2, 
          3, 1, 4}, {2, 4, 3, 1}, {3, 1, 2, 4}, {3, 2, 4, 1}, {3, 4, 1, 2}, {
          4, 1, 3, 2}, {4, 2, 1, 3}, {4, 3, 2, 1}}, "-Operation-"]\)], 
  "Output",
  CellLabel->"Out[32]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell["Note that these are all even permutations.", "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[EvenPermutationQ, \ Elements[G]]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"Permutations"],

Cell[BoxData[
    \({True, True, True, True, True, True, True, True, True, True, True, True}
      \)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"Permutations"]
}, Open  ]],

Cell["2.4.4 Dihedral and cyclic groups", "Subsubsection",
  CellTags->{"Dihedral", "i:20"}],

Cell["\<\
The dihedral and cyclic groups are frequently used to describe the \
symmetries of various objects.\
\>", "Text",
  CellTags->"Dihedral"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Dihedral",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(dihedral\ group\ of\ order\ \),
                SingleLetterItalics->False], 
              StyleBox[\(2 n\),
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["whose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["represented",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rotations",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[\(\ reflections\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Dihedral",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  StyleBox[\(Form\  \[Rule] \ Permutations\),
                    "MR"],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["dihedral",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["group",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["order",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["2",
                FontSlant->"Italic"], 
              StyleBox["n",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["whose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["represented",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["permutations",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["length",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["n",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["Dihedral",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["RotSym",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["\[Rule]",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], "rot"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["RefSym",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["\[Rule]",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], "ref"}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(dihedral\ group\ of\ order\ \),
                  SingleLetterItalics->False], 
                StyleBox[\(2 n\),
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["whose",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["represented",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["by",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ rotations\ and\ \),
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["reflections",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["using",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["symbol",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["rot",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ for\ the\ lowest\ order\ rotation\ and\ \),
                    SingleLetterItalics->False], 
                  StyleBox["ref",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["reflection",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["generator",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["D",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], ",", " ", 
                StyleBox["opts",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Dihedral",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["DihedralGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], ",", " ", 
                StyleBox["opts",
                  FontSlant->"Italic"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Dihedral",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Dihedral", "i:21"}],

Cell[TextData[{
  "Variations of the ",
  StyleBox["Dihedral",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"Dihedral"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["Form",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["RotRef",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", " ", 
                StyleBox["whether",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["should",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["take",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["on",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["permutations",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    StyleBox["Permutations",
                      "MR"], 
                    StyleBox[")",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["or",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], "be", " ", 
                  StyleBox["represented",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["terms",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["lowest",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["order",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["rotation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["reflection",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    StyleBox["RotRef",
                      "MR"], 
                    StyleBox[")",
                      SingleLetterItalics->False]}]}]}]}]},
          {
            StyleBox[
              FormBox["RotSym",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Rot",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                StyleBox[\(when\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox[\(Form\  \[Rule] \ RotRef\),
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["option",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["used",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(specifies\ the\ symbol\ used\ to\ represent\ the\ rotation
                  \),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["RefSym",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Ref",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                StyleBox[\(when\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox[\(Form\  \[Rule] \ RotRef\),
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["option",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["used",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(specifies\ the\ symbol\ used\ to\ represent\ the\ reflection
                  \),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.16, 0.18, 0.66},
  RowLines->{True, False}},
  CellTags->{"Dihedral", "i:22"}],

Cell[TextData[{
  "Options specific to ",
  StyleBox["Dihedral",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Dihedral"],

Cell[TextData[{
  "One way of thinking of ",
  StyleBox["Dihedral[3]", "MR"],
  " is to consider the symmetries of the equilateral triangle. There are \
three reflections (through a vertex and midpoint of the opposite side) and \
three rotations (of",
  " ",
  Cell[BoxData[
      \(TraditionalForm\`120\)]],
  "\[Degree], ",
  Cell[BoxData[
      \(TraditionalForm\`240\)]],
  "\[Degree], and ",
  Cell[BoxData[
      \(TraditionalForm\`0\)]],
  "\[Degree]). Using the symbol ",
  StyleBox["Rot", "MR"],
  " for the smallest (positive) degree rotation and ",
  StyleBox["Ref", "MR"],
  " to represent one of the reflections, the rest of the elements can be \
represented in terms of these two."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dihedral[3, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \("The dihedral group D[3] consists of all the symmetries of the 3-sided \
regular polygon shown below. Included in the group are the 3 reflections \
through the lines connecting the vertices to the midpoints of opposite sides, \
as well as the 3 rotations through angles consisting of multiples of 120. \
degrees (360 divided by the index)."\)], "Print",
  CellTags->"Dihedral"],

Cell[BoxData[
    \("The elements are considered as follows: The rotation of 120. degrees \
is called Rot and any one of the reflections is called Ref. The elements are \
then seen as powers of Rot and products of these powers and the reflection \
Ref."\)], "Print",
  CellTags->"Dihedral"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .86603 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.439886 0.295548 0.439886 [
[ 0 0 0 0 ]
[ 1 .86603 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .86603 L
0 .86603 L
closepath
clip
newpath
.74 .99 .79 r
.88095 .07561 m
.11905 .07561 L
.5 .73543 L
F
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.88095 .07561 m
.11905 .07561 L
.5 .73543 L
.88095 .07561 L
s
0 g
[(1)] .97619 .02062 0 0 Mshowa
[(2)] .02381 .02062 0 0 Mshowa
[(3)] .5 .84541 0 0 Mshowa
1 0 0 r
.045 w
.88095 .07561 Mdot
0 1 0 r
.11905 .07561 Mdot
0 0 1 r
.5 .73543 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[34]:=",
  ImageSize->{288, 249.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000n@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@0000@0
1?oo00l00ol700001@000ol0003o010000?o00001P0000H000?o0000o`0?0003o`0000H000070003
o`000?l03P000ol00006000010001?l00?oo010000?o00001P0000D00_oo01000_l80000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q00008004d=H011lR00007P08d=8021lP0000
7@0:d=002QlO00007@0:d=002QlO0000700<d<h031lN0000700<d<ko31lN0000700<d03>3`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<<7ah0000L00c@0<h3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP`O
7P0001d02]00d0<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l:7al0000M00[@0=3F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH32QlO00007P08d03B3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
21lP00008004d03F0?l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`@O8P0002H00=?o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02L0000V003ComH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fo`0W00009`00dOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02P0000W003Ao`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0:00002P00<oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0
:@0002T00<go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02X0000Y003=o`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`0Z0000:P00booF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02/0000Z003;o`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0ol0:`0002/00<Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0;00002`00<Oo0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o02d0000/0037omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0]0000;@00aOl?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`oo02h0000]0035o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0;P0002h00<?o0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0;`0002h0
0<?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l0;`0002l00<7o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo0300000`002oomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0
<@0003000;oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3o`0a0000<@00_Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0b0000<@00_Ol?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0b0000
<P00^ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0<`0003800;_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o03<0000c002io`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0=00003@00;Oo0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0=@0003@0
0;OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l0=@0003D00;Go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`oo03H0000e002eo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0f0000=P00/ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o03L0000f002comH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0=`0003L00;7o3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0>00003P00:ooeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo03T0000h002_
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0i0000
>@00[Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o03X0
000i002]o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0
>P0003X00:_oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0
>`0003/00:Wo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo03`0
000k002Yo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0l0000
?000Yol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o03d0000l002W
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0?@0003d00:Go3`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0?P0003d00:Go0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0?P0003h00:?o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o03l0000o002Qo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0ol0@00003l00:7o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`100000@000WooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`110000
@000Wol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`110000@@00WOl3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0@P00044009go3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`oo04800012002KomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0
@`0004<009Wo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0A00004<009Wo0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0A00004@009Oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?o04D00014002GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`150000A@00UOl?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo04H00015002Eo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0
AP0004H009?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0A`0004L0097o0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?o04P00017002Ao`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`180000B000SooF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo04T00018002?o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0B@0004T008go0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0ol0BP0004X008_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o04/0001:002;omH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`1;0000B`00ROl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo04`0001;0029o`?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0ol0C00004`008Oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0C@0004`008OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0C@0004d0
08Go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`oo04h0001>0023omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0C`0004h008?o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`1?0000
C`00POl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3o`1@0000C`00POl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`1@0000D000OooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0D@00050007oo0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?o0540001A001mo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0ol0DP00058007_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0D`00058007_oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0D`0005<007Wo3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo05@0001C001i
o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
o`1D0000E000Mol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o05D0001D001gomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l0E@0005D007Go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol0EP0005H007?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo05L0001F001co`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`1G0000E`00LOl3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o05P0001G001ao`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0F00005P006ooeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0F@0005T006go3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo05X0001I001]o`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1J0000FP00Jol33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o05/0001J001[omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0F`0005/006Wo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0G00005/006Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol0G00005`006Oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?o05d0001M001Uo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0GP0005d0
06Go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`1N0000GP00HooF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`1O0000GP00Hol33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3o`1O0000G`00HOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0ol0H00005l0067o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo0600001P001O
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0H@00064005go3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0HP00064005go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0
HP00068005_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o06<0001R001KomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fo`1S0000H`00FOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo06@0
001S001Io`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0I00006@005Oo0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0ol0I@0006D005Go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o06H0001U001Eo`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`1V0000IP00DooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo06L0001V001C
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0ol0I`0006L0057o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0J00006L0
057o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol0J00006P004ooeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo06T0001Y001=
o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0JP0006T004go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1Z0000JP00Bol33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`1[0000JP00BooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`1[0000J`00BOl?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0K00006`0
04OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`1]0000K000Aol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o06d0001]0015o`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o06h0001]0015
o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`oo06h0001^0013omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`1_0000KP00@ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0K`0006l0047o0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1`0000
L000?ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`1a0000L000?ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fo`1a0000L@00?Ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0LP00074003go0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o0780001b000ko`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0L`00078003_oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`1c0000
L`00>Ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
o`1d0000M000=ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l0M@0007@003Oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o07D0001e000eo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol0MP0007D003Go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`1f0000MP00<ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`1g0000MP00<ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3o`1g0000M`00<Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol0N00007P002oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`1i0000N000;ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo07T0001i000]o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo07X0
001i000]o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o07X0001j000[
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`1k0000N`00:Ol3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o07`0001k000Yo`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol0O00007`002OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0O@0007`002Oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0
O@0007d002Go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o07h0001m000Uo`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`1n0000OP008ooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo07l0001o000Qo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo0800
001o000Qo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o08000020000Oo`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3o`210000P0007ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0
P@00084001go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`220000P@007Ol3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o08800022000Ko`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o08<00023000I
o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`240000P`006Ol?0`l33`<?0`l33`<?0`l33`<?0`l33ol0
Q00008@001OoeP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`250000Q0005ol33`<?0`l33`<?0`l33`<?0`l3
3`?o08D00025000Eo`?F0mH3eP?F0mH3eP?F0mH3eP?o08H00025000Eo`l33`<?0`l33`<?0`l33`<?
0`oo08H00026000ComH3eP?F0mH3eP?F0mH3eP?Fo`270000Q`004Ol?0`l33`<?0`l33`<?0`oo08P0
0027000Ao`?F0mH3eP?F0mH3eP?F0ol0R00008P000oo0`l33`<?0`l33`<?0ol0R@0008P000ooeP?F
0mH3eP?F0mH3e_l0R@0008T000go3`<?0`l33`<?0`oo08X0002:000;omH3eP?F0mH3e_l0R`0008X0
00_o0`l33`<?0`l3o`2;0000R`002Ol3eP?F0mH3o`2<0000R`002Ol?0`l33`<?o`2<0000S0000om<
C002C003e_l008`0002;00Q<S@0008X02Tb<0000RP0:C8`0002900a<R`0008T034b;0000R@0<C8/0
002900a<R`0008X02Tb<0000RP0:C8`0002;00Q<S@0008d014b?0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
S@03oi00002@0003o`0008d0002@0003o`0008d0002>00;oT000090000?o0000S@0008d00on@0000
o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {248.375, 0}} -> {-1.13747, -0.671884, 
  0.00792664, 0.00792664}},
  CellTags->"Dihedral"],

Cell[BoxData[
    \(Groupoid[{1, Rot, Rot\^2, Ref, Rot**Ref, Rot\^2**Ref}, "-Operation-"]
      \)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "This use of ",
  StyleBox["Dihedral", "MR"],
  " exercises the following default options."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[Dihedral]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \({Mode \[Rule] Computational, Form \[Rule] RotRef, RotSym \[Rule] Rot, 
      RefSym \[Rule] Ref}\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "The other acceptable value for ",
  StyleBox["Form", "MR"],
  " is ",
  StyleBox["Permutations", "MR"],
  "."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dihedral[3, \ Form\  \[Rule] \ Permutations]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \(Groupoid[{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 
          1}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "Instead of using ",
  StyleBox["Rot", "MR"],
  " to represent the lowest order rotation and ",
  StyleBox["Ref", "MR"],
  " for a reflection, we can choose other symbols for these groups."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[
      Dihedral[3, RotSym\  \[Rule] \ "\<R\>", \ RefSym\  \[Rule] \ "\<L\>"]]
      \)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \({{1, "R", "R"\^2, "L", "R"**"L", "R"\^2**"L"}, {"R", "R"\^2, 1, 
        "R"**"L", "R"\^2**"L", "L"}, {"R"\^2, 1, "R", "R"\^2**"L", "L", 
        "R"**"L"}, {"L", "R"\^2**"L", "R"**"L", 1, "R"\^2, "R"}, {"R"**"L", 
        "L", "R"\^2**"L", "R", 1, "R"\^2}, {"R"\^2**"L", "R"**"L", "L", 
        "R"\^2, "R", 1}}\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "We can use the traditional name for the dihedral group, ",
  StyleBox["D", "MR"],
  ", even though it is a reserved name in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(D[4]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \(Groupoid[{1, Rot, Rot\^2, Rot\^3, Ref, Rot**Ref, Rot\^2**Ref, 
        Rot\^3**Ref}, "-Operation-"]\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "The standard definition of ",
  StyleBox["D", "MR"],
  ", in terms of differentiation, still works."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \({D[4, \ x], \ D[x\^2, \ x]}\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \({0, 2\ x}\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "Although it is an easy result in group theory to show that there is \
essentially only one finite cyclic group, namely ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", sometimes this group is expressed multiplicatively using a generic \
generator ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  ". ",
  StyleBox["Cyclic", "MR"],
  " is used to create this form."
}], "Text",
  CellTags->{"Dihedral", "i:23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Cyclic",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(cyclic\ group\ of\ order\ \),
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(expressed\ multiplicatively\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[\(with\ generator\ "\<g\>"\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Cyclic",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(cyclic\ group\ of\ order\ \),
                    SingleLetterItalics->False], 
                  StyleBox[\(n/k\),
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(expressed\ multiplicatively\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["generator",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], "\!\(\*
StyleBox[\\(\\*\"\\\"\"\\),\nSingleLetterItalics->False]\)\!\(\*
StyleBox[\\(g\\),\nSingleLetterItalics->False]\^\*
StyleBox[\\(k\\),\nFontSlant->\"Italic\"]\)\!\(\*
StyleBox[\\(\\*\"\\\"\"\\),\nSingleLetterItalics->False]\)"}]}]},
          {
            RowBox[{
              StyleBox["Cyclic",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Generator",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox["\[Rule]",
                        "MR"], " ", "gen"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(cyclic\ group\ of\ order\ \),
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(expressed\ multiplicatively\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["generator",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["gen",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["CyclicGroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Cyclic",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["n",
                      "TI"], 
                    StyleBox[",",
                      "MR"], " ", 
                    StyleBox["opts",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"Dihedral", "i:24"}],

Cell[TextData[{
  "Variations of the ",
  StyleBox["Cyclic",
    FontFamily->"Courier"],
  " ",
  "function."
}], "Caption",
  CellTags->"Dihedral"],

Cell["The default generator is used if no other is specified.", "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cyclic[8]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \(Groupoid[{1, "g", "g"\^2, "g"\^3, "g"\^4, "g"\^5, "g"\^6, "g"\^7}, 
      "-Operation-"]\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell["\<\
If desired, a different symbol for the generator can be given.\
\>",
   "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclicGroup[7, \ Generator\  \[Rule] \ "\<\[Alpha]\>"]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \(Groupoid[{1, "\[Alpha]", "\[Alpha]"\^2, "\[Alpha]"\^3, "\[Alpha]"\^4, 
        "\[Alpha]"\^5, "\[Alpha]"\^6}, "-Operation-"]\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell[TextData[{
  "As with the other means of generating a cyclic group (using ",
  StyleBox["Z", "MR"],
  "), we can also obtain variations by looking at multiples of a divisor of \
the index."
}], "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cyclic[8, 2, \ Generator\  \[Rule] \ "\<\[Beta]\>", \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"Dihedral"],

Cell[BoxData[
    \("Think of the elements as the numbers on a (modified) clock. The \
differences, however, are that we view the element 1 as being equivalent to \
twelve and the other elements as powers of \[Beta]^2. Multiplication of two \
elements is done by adding the exponents on the elements, just like adding \
the hours of a clock.\n"\)], "Print",
  CellTags->"Dihedral"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
1 0 0 r
.035 w
.5 .8663 Mdot
.75901 .75901 Mdot
.8663 .5 Mdot
.75901 .24099 Mdot
.5 .1337 Mdot
.24099 .24099 Mdot
.1337 .5 Mdot
.24099 .75901 Mdot
0 0 1 r
.055 w
.5 .8663 Mdot
.8663 .5 Mdot
.5 .1337 Mdot
.1337 .5 Mdot
0 g
gsave
.5 .77473 -84.5 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
88.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Times-Roman
grestore
gsave
.77473 .5 -92 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
82.375000 16.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
89.437500 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
96.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
103.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Times-Roman
grestore
gsave
.5 .22527 -92 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
82.375000 16.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
89.437500 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
96.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
103.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Times-Roman
grestore
gsave
.22527 .5 -92 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
82.375000 16.000000 moveto
%%IncludeResource: font Math1
%%IncludeFont: Math1
/Math1 findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(b) show
89.437500 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(^) show
96.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
103.000000 16.000000 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 14.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1
%%+ font Times-Roman
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1
%%+ Times-Roman
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1
%%+ font Times-Roman
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[42]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008d01Db>0000R`09C8`0
002:00]<R`0008T03Db:0000R@0=C8X0002800m<R@0008P03db90000Q00014j>CXh?C005STj>CXh0
Q00007`000PnCSi>?ThnCP@03d`50008?ThnCSi>?Til0000N@000hi>SP0<00m<3@000dj>001i0000
M0001Ci>?Thn01003D`@0005?ThnCSh0M@00078000=>SP00500=C1D000>>CXh0LP0006d000E>?Thn
CP0H00]<6@001Ci>?Thn06d0001Z0003CXi>01h02D`O0003STh006X0001X0003?Th002801D`S0003
CSi>06P0001U0003STj>050000=>SP00I@0006<000=>?P00E0000ci>?P1S0000H0000dj>CP1J0003
STh00600001O0003CP0005d000=>0000GP0005h000=>0000G`000dh0001M0000G0000ci>001R0003
CSi>05`0001I0003STj>06P000=>SP00F@0005P000<n0000J`000ch0001G0000E`000hh0001]0003
SP0005H0001E0003CSh0070000<nCP00E@0005@000=>0000L`000dh0001C0000D`000dh0001e0003
CP000580001A0003STh0030000?o0000A@000dj>001A0000C`000dhn000c0003o`0004H000<nCP00
C`0004h000=>0000=0000ol000180003CP0004d0001<0003?Th003H000Co0?oo3P000ol0000g0003
CSh004`0001;0003SP0003L00_l20003o`0000/000?o0000>@000hh0001:0000BP000ch0000i0005
o`000?l02007ocX000<n0000B@0004<011l20003SP0003X000Go0000o`080005o`000?l0?@000hh0
00047d@0001100PO00=>0000>P001Ol0003o008000Go0000o`020004o`00och021m20000@@087cd0
00Co0?oo0`001Ol0003o00<000?o0?l0?P087d80001000XO?@001?l00?l30003o`3o00@000?o0?l0
?@0:7d40001000XO?@001Ol0003o008000?o0?l01@02ocd02Qm10000@00:7ch000Co003o0`000ol0
000400;o?@0:7d40001000XO?`02o`@000?o00001@000ol0000k00XO@@00044021n=00PO@P000440
21n=00PO@P00040000<n000011nA00@O0P000ch0000o0000?`000hh0002M0003SP0003h0000n0003
?P0009l000<n0000?@0003h000=>0000W`000dh0000m0000?@000dh0002Q0003CP0003`0000m0003
SP000:4000>>0000?00003`000<n0000X`000ch0000k0000>`000hh0002U0003SP0003X0000k0003
CP000:D000=>0000>P0003X000=>0000Y`000dh0000i0000>@000dh0002Y0003CP0003P0000h0003
CP000:/000=>0000=`0003P000<n0000Z`000ch0000g0000=`000hh0002]0003SP0003H0000f0003
?P000:l000<n0000=@0003D000>>0000/@000hh0000d0000=@000dh0002a0003CP0003@0000d0003
CP000;<000=>0000<`0003@000<n0000/`000ch0000c0000<`000hh0002e0003SP000380000c0003
CP000;D000=>0000<P00038000=>0000]`000dh0000a0000<@000dh0002i0003CP000300000a0003
SP000;T000>>0000<000030000<n0000^`000ch0000_0000<0000dh0002k0003CP0002l0000_0003
CP000;d000=>0000;P0002l000>>0000_@000hh0000^0000;`000dh0002m0003CP0002h0000^0003
CP000;l000=>0000;@0002h000<n0000_`000ch0000]0000;@000hh000310003SP0002`0000]0003
CP000<4000=>0000;00002d000>>0000`@000hh0000/0000;0000ch000330003?P0002/0000/0003
CP000<<000=>0000:`0002/000=>0000a@000dh0000Z0000:`000hh000350003SP0002X0000[0003
CP000<D000=>0000:P0002/000>>0000a@000hh0000Z0000:`000dh000350003CP0002X0000Z0003
CP000<L000=>0000:@0002X000<n0000a`000ch0000Y0000:P000dh000370003CP0002T0000Y0003
CP000<T000=>0000:00002T000>>0000b@000hh0000X0000:@000dh000390003CP0002P0000Y0003
SP000<T000>>0000:00002T000=>0000b@000dh0000X0000:0000dh0003;0003CP0002L0000X0003
?P000</000<n00009`0002L000>>0000c@000hh0000V00009`000dh0003=0003CP0002H0000W0003
SP000<d000>>00009P0002L000=>0000c@000dh0000V00009`000hh0003=0003SP0002H0000W0003
CP000<d000=>00009P0002L000>>0000c@000hh0000V00009`000dh0003=0003CP0002H0000V0003
CP000<l000=>00009@0002H000<n0000c`000ch0000U00009P000dh0003?0003CP0002D0000V0003
?P000<l000<n00009@0002<01Dc>00E<9@0002402D`<0003o`0009X000?o00007P09C2<0000P00]<
30000ol0002J0003o`0001`02d`R00007`0=C0/000?o0000VP000ol0000K00e<8@0001l03D`;0004
o`3oo`X01?n;0004o`3oo`X01Ol;00e<8@0001h03d`:00;o0P000ol000060003o`00008000?o0000
R002o`8000?o00001`000ol000020003o`0000L03d`P00007P0?C0/000Go0000o`070003o`000080
00?o0000R@001Ol0003o00T000?o00002`0?C200000N00m<2`001Ol0003o00L000?o00000P000ol0
00290005o`000?l02P000ol0000:00m<800001h03d`;0005o`000?l00P001?l00003o`<000?o0000
R@001Ol0003o008000Go0000o`040003o`0000T03d`P00007P0?C0/000Co0?oo0`001?l00002o`04
0?oooh`000Co0?oo0`001Ol0003o00@000?o00002@0?C200000O00e<3@001?l00?l30005o`3o0?l0
T@001?l00?l30003o`3o00H000?o00002@0=C240000O00e<3@001Ol0003o008000?o0?l00P000ol0
002>0005o`000?l00P000ol0o`020005o`000?l02`0=C240000P00]<3`001?l00?l30003o`000080
00?o0000SP001?l00?l30005o`000?l00`000ol0000:00]<8P0002402D`A00;o10000ol0000300?o
SP02o`@000?o00000P03o`h02D`S00008`05C<h01D`U00009P000ch0003?0003?P0002D0000V0003
CP000<l000=>00009@0002H000<n0000c`000ch0000U00009P000dh0003?0003CP0002D0000W0003
CP000<d000=>00009P0002L000>>0000c@000hh0000V00009`000dh0003=0003CP0002H0000W0003
SP000<d000>>00009P0002L000=>0000c@000dh0000V00009`000hh0003=0003SP0002H0000W0003
CP000<d000=>00009P0002L000>>0000c@000hh0000V0000:0000ch0003;0003?P0002L0000X0003
CP000</000=>00009`0002P000<n0000b`000ch0000W0000:@000hh000390003SP0002P0000Y0003
CP000<T000=>0000:00002T000>>0000b@000hh0000X0000:@000dh000390003CP0002P0000Y0003
SP000<T000>>0000:00002X000<n0000a`000ch0000Y0000:P000dh000370003CP0002T0000[0003
CP000<D000=>0000:P0002/000>>0000a@000hh0000Z0000:`000dh000350003CP0002X0000[0003
SP000<D000>>0000:P0002/000=>0000a@000dh0000Z0000;0000dh000330003CP0002/0000/0003
?P000<<000<n0000:`0002`000=>0000``000dh0000[0000;@000dh000310003CP0002`0000]0003
SP000<4000>>0000;00002h000<n0000_`000ch0000]0000;P000dh0002o0003CP0002d0000^0003
?P000;l000<n0000;@0002l000>>0000_@000hh0000^0000;`000dh0002m0003CP0002h0000`0003
CP000;/000=>0000;`00030000<n0000^`000ch0000_0000<0000dh0002k0003CP0002l0000a0003
CP000;T000=>0000<000038000=>0000]`000dh0000a0000<`000dh0002e0003CP000380000c0003
SP000;D000>>0000<P0003@000<n0000/`000ch0000c0000=0000dh0002c0003CP0003<0000d0003
?P000;<000<n0000<`0003D000>>0000/@000hh0000d0000=P000ch0002_0003?P0003D0000g0003
SP000:d000>>0000=P0003L000=>0000[@000dh0000f0000>0000dh0002[0003CP0003L0000i0003
CP000:T000=>0000>00003X000=>0000Y`000dh0000i0000>P000ch0002W0003?P0003T0000k0003
SP000:D000>>0000>P0003/000=>0000Y@000dh0000j0000?0000dh0002S0003CP0003/0000m0003
CP000:4000=>0000?00003d000>>0000X@000hh0000l0000?P000ch0002O0003?P0003d0000o0003
SP0009d000>>0000?P00040000<nCP0011nA00@O0P000ch0000o0000@@087hd021m20000@@087hd0
21m20000@00:7h/02Qm10000@00:7h/02Qm10000@00:7h/02Qm10000@00:7d@00om400XO@@000440
21m60003o`0004@021m20000@@087dH000?o0000A0087d80001300@O0P000hh000130003o`0004<0
00>>000011m40000BP000ch000120003o`00048000<n0000B@0004/000>>CP00@@000ol000100003
CXh004/0001=0003CSh003l000?o0000?P000ci>001=0000C`000hh0000m0003o`0003d000>>0000
CP00050000<nCP00?0000ol0000k0003CSh00500001B0003CP0003T00_ll0003CP000540001C0003
CP0007D000=>0000DP0005@000=>SP00LP000hi>001D0000EP000ch0001_0003?P0005D0001G0003
SP0006d000>>0000EP0005P000<nCP00JP000dhn001H0000FP000dj>CP1V0003STh005X0001M0003
CP00064000=>?P00G00005h000=>0000G`000dh0001M0000G`000dhn001L0003?Th005l0001Q0003
STj>05P000=>SP00H@0006@000<nCP00DP000dhnCP1T0000IP000dj>CP1>0003STh006H0001Y0003
CSh004P000<nCSh0J@0006/000>>CXh07`05C20000=>SP00J`0006h000DnCSi>?P0H00U<6@001Dhn
CSi>06h0001c0003STh001@02d`E0003CXi>07<0001e0005CSi>?Th03`0=C0l000E>?ThnCP1f0000
NP000dj>CP0<00e<3@000hi>001j0000O@0024hnCSi>?Thn0`0?C0@000Q>?ThnCSi>?Wd000250003
STj>00m<00B>CXi>Q@0008P03db90000R00?C8T0002800m<R@0008T03Db:0000R@0=C8X0002:00]<
R`0008/02Db<0000S@05C8h0003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.36502, -1.36502, 0.0095123, 
  0.0095123}},
  CellTags->"Dihedral"],

Cell[BoxData[
    \(Groupoid[{1, "\[Beta]"\^2, "\[Beta]"\^4, "\[Beta]"\^6}, "-Operation-"]
      \)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"Dihedral"]
}, Open  ]],

Cell["2.4.5 Other groupoids", "Subsubsection",
  CellTags->"OtherGroupoids"],

Cell["\<\
In this section, we introduce the remaining built-in \
groupoids.\
\>", "Text",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                StyleBox[\(QuaternionGroup[]\),
                  "MR"],
                "TraditionalForm"],
              "TI"], 
            
            StyleBox[\(quaternion\ group\ of\ order\ 8, \ 
              given\ as\ matrices\ generated\ by
                \ {{0, \ 1}, \ {\(-1\), \ 0}}\ and\ {{0, \ I}, \ {I, \ 0}}\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              RowBox[{"QuaternionGroup", "[", 
                FormBox[\(Form\  \[Rule] \ AsMatrices\),
                  "TraditionalForm"], "]"}],
              "MR"], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(QuaternionGroup[]\),
                "MR",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox[\(Quaternion Group\),
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  StyleBox[\(Form\  \[Rule] \ AsIJK\),
                    "MR"],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[\(quaternion\ group\ of\ order\ 8, \ 
              given\ as\ elements\ 
                \n{\(\[PlusMinus]\ 1\), \ \(\[PlusMinus]\ I\), \ 
                  \(\[PlusMinus]\ JJ\), \ \(\[PlusMinus]\ KK\)}\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              RowBox[{"QuaternionGroup", "[", 
                FormBox[\(Form\  \[Rule] \ AsSymbols\),
                  "TraditionalForm"], "]"}],
              "MR"], 
            RowBox[{
              RowBox[{
                StyleBox[\(quaternion\ group\ of\ order\ 8\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["given",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["as",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["elements",
                    SingleLetterItalics->False]}]}], 
              StyleBox[
                FormBox[
                  RowBox[{"{", 
                    StyleBox["e",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], ",", " ", 
                    StyleBox["a",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], ",", " ", 
                    FormBox[\(a\^2\),
                      "TraditionalForm"], 
                    StyleBox[",",
                      SingleLetterItalics->False], " ", 
                    FormBox[\(a\^3\),
                      "TraditionalForm"], 
                    StyleBox[",",
                      SingleLetterItalics->False], " ", 
                    StyleBox["b",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], ",", " ", 
                    StyleBox["b",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["a",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], ",", " ", 
                    StyleBox["b",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], " ", 
                    FormBox[\(a\^2\),
                      "TraditionalForm"], 
                    StyleBox[",",
                      SingleLetterItalics->False], " ", 
                    StyleBox["b",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], " ", 
                    FormBox[\(a\^3\),
                      "TraditionalForm"], "}"}],
                  "TraditionalForm"],
                "Text"]}]},
          {
            StyleBox[
              FormBox["Trivial",
                "StandardForm"],
              "Text"], 
            StyleBox[\(trivial\ group\ of\ order\ 1\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Klein4",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["whose",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        FontSlant->"Italic"], 
                      StyleBox["e",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox[\(, \ \),
                        FontSlant->"Italic"], 
                      StyleBox["a",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox[\(, \ \),
                        FontSlant->"Italic"], 
                      StyleBox["b",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox[\(, \ \),
                        FontSlant->"Italic"], 
                      StyleBox["c",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox["}",
                        FontSlant->"Italic"]}],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(commonly\ called\ the\ Klein\ 4\ group\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"OtherGroupoids", "i:25"}],

Cell["Various other groupoids.", "Caption",
  CellTags->"OtherGroupoids"],

Cell[TextData[{
  StyleBox["Klein4", "MR"],
  " is just a particular implementation of ",
  Cell[BoxData[
      \(TraditionalForm\`D\_2\)]],
  "."
}], "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[Klein4, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \(Klein4::"warning" \( : \ \) 
      "The elements e, a, b, c are considered strings and thus need to have \
double quotes around them when being used."\)], "Message",
  CellTags->"OtherGroupoids"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(e)] .30952 .69286 0 0 Mshowa
[(a)] .5 .69286 0 0 Mshowa
[(b)] .69048 .69286 0 0 Mshowa
[(c)] .88095 .69286 0 0 Mshowa
[(a)] .30952 .50238 0 0 Mshowa
[(e)] .5 .50238 0 0 Mshowa
[(c)] .69048 .50238 0 0 Mshowa
[(b)] .88095 .50238 0 0 Mshowa
[(b)] .30952 .3119 0 0 Mshowa
[(c)] .5 .3119 0 0 Mshowa
[(e)] .69048 .3119 0 0 Mshowa
[(a)] .88095 .3119 0 0 Mshowa
[(c)] .30952 .12143 0 0 Mshowa
[(b)] .5 .12143 0 0 Mshowa
[(a)] .69048 .12143 0 0 Mshowa
[(e)] .88095 .12143 0 0 Mshowa
[(e)] .11905 .69286 0 0 Mshowa
[(a)] .11905 .50238 0 0 Mshowa
[(b)] .11905 .3119 0 0 Mshowa
[(c)] .11905 .12143 0 0 Mshowa
[(e)] .30952 .88333 0 0 Mshowa
[(a)] .5 .88333 0 0 Mshowa
[(b)] .69048 .88333 0 0 Mshowa
[(c)] .88095 .88333 0 0 Mshowa
[(Klein4)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[43]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P0000H0nOl600001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o
<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003
oda<02e<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000
100000H000?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
<Ml00ol0000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01T
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0
;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol000040000
1P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03
o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01Tog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o
<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003
oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000
100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolag`03o`0000@000060003oda<01E<0olEC0;o5d`3oaM<01OoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP04o`0^LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOW`Go
01JOGimOWenOGimOWenOGimOWenOGioo5ml4oaKO00?o0000100000H000?oC4`054`01Om<C4co01A<
0_lFC005oda<C?l05T`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm?odO_Anm7kdO_Anm7kdO_An
m7kdO_AnoenOGimOWenOGimOWenOGimOWenOGiooWeooGimOWenOGimOWenOGimOWenOGimOWolFg`03
omoO01SO00?o0000100000H000?oC4`054`00om<C00FC0;o5T`00om<C00HC019og5nLGiaOW5nLGia
OW5nLGiaOW5nLGkoOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimO
W`04o`0GGimOWenOGimOWenOGimOWenOGimOWol05]l5oaKO00?o0000100000H000?oC4`054`01Om<
C4co01A<0_lFC005oda<C?l05T`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm?odO_Anm7kdO_An
m7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimO
WolFg`05omoOgol05]l00ol0000400001P000om<C00EC0Co54`2oaM<1?lFC00Gog5nLGiaOW5nLGia
OW5nLGiaOW5nLGh01?l0;g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenO
GimO00?o01MOWenOGimOWenOGimOWenOGimOWenOo`0Gg`?o5ml00ol0000400001P000om<C00]C0;o
<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003
oda<02e<0_laC00Fog5nLGiaOW5nLGiaOW5nLGiaOW5nL@;o04anLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000om<C00]C0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wolag`03o`0000@000060003oda<02e<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<
06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<
C00]C0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@0
00060003oda<02e<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<
0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H0
00?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01Tog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H0nOl600001P00<?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<
00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0
;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`060000
1P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<
00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0
;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`060000
1P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P005omnLGiaOW5nLGiaOW5n
LGiaOW5nLGia00Co01EnLGiaOW5nLGiaOW5nLGiaOW5nLGh00_l05W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh4o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5d`3oaM<00?ogml05Ml4oaGO01OoWenOGimOWenO
GimOWenOGimOWenOG`05o`0GGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_mnm7koO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?odO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lFC005oda<C?l05T`00ooOg`0Dg`03omoO01OO
03?oWenOGimOWenOGimOWenOGimOWenOGomOWonOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_mnLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlFC003oda<01Q<00?ogml0
5=l5oaGO01OoWenOGimOWenOGimOWenOGimOWenOG`04o`0HWenOGimOWenOGimOWenOGimOWenOGioo
1P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7koO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0b
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lFC005oda<C?l0
5T`00ooOg`0Dg`05omoOgol05Ml0<onOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P005omnLGiaOW5nLGiaOW5nLGiaOW5nLGia00Co01EnLGiaOW5nLGia
OW5nLGiaOW5nLGh00_l05W5nLGiaOW5nLGiaOW5nLGiaOW5nLGh4o`0HLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o5d`4oaI<00?ogml05Ml3oaKO01SoWenOGimOWenOGimOWenOGimOWenOGil3o`0HWenOGimO
WenOGimOWenOGimOWenOGioo1P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H001KoOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0675nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o01EaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l06giaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0aC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003
omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0b
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO
03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003
omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0b
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO
03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0nOl600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O
00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0
;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`060000
1P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O
00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0
;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`060000
1P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoc7O00?oC4`0;T`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoc7O00?oC4`0;T`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0600001P005onOGimOWenOGimOWenOGimOWenOGimO00Go01AOWenOGimOWenOGimOWenO
GimOW`;o01IOWenOGimOWenOGimOWenOGimOWenO1Ol05imOWenOGimOWenOGimOWenOGimOWeoo01OO
1?lFg`03oda<01E<0olFC00GogiaOW5nLGiaOW5nLGiaOW5nLGiaOW401?l067iaOW5nLGiaOW5nLGia
OW5nLGiaOW5no`H00006000`oimOWenOGimOWenOGimOWenOGimOWeooGiooWenOGimOWenOGimOWenO
GimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGiooWeooGimOWenOGimOWenOGimOWenOGimOWeoo
5]l00ooOg`0Hg`03oda<01A<00GoC4a<o`0EC00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000GoimOWenOGimOWenOGimOWenOGimOWel01?l05ImO
WenOGimOWenOGimOWenOGimOW`02o`0FGimOWenOGimOWenOGimOWenOGimOW`Co01QOWenOGimOWenO
GimOWenOGimOWenOGolFg`Go5]l00om<C00DC003oda<01M<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOmaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWonOGimOWenOGimOWenOGimOWenOGil2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGomOWenO
GimOWenOGimOWenOGimOWenOGolFg`05omoOgol05]l00om<C00DC005oda<C?l05D`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_AnogkdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P006?nOGimOWenO
GimOWenOGimOWenOGimOW`?o01FOGimOWenOGimOWenOGimOWenOGil00_l05enOGimOWenOGimOWenO
GimOWenOGimO00?o01QOWenOGimOWenOGimOWenOGimOWenOGolGg`?o5ml00om<C00EC0Co5D`05omn
LGiaOW5nLGiaOW5nLGiaOW5nLGia00Co01QnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P00<?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o039OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc7O00?oC4`0;T`05_mnLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0KLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo<Ml00om<C00^C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo<Ml00om<C00^C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
<Ml00om<C00^C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<
C00^C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00c
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo<Ml00om<C00^C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo<Ml00om<C00^C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
<Ml00om<C00^C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<
C00^C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00c
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<Ml00om<C00^C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H000060?Wo1P0000H0
00?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0
000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooO
g`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<
00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H0
00?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0
000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooO
g`0Eg`Co5=l2oaOO1?lFg`0GoenOGimOWenOGimOWenOGimOWenOGil01Ol0;ImOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm004o`0GO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
5d`3oaM<00?o0000100000H000?ogml05=l00ooOg`0Fg`;o5]l00ooOg`0Hg`1ToenOGimOWenOGimO
WenOGimOWenOGiooWeooGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_mnLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5noaI<00GoC4a<o`0FC003o`0000@000060003omoO01CO
1OlDg`;o5]l5oaKO01OoGimOWenOGimOWenOGimOWenOGimOW`04o`19GimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0FC003
oda<01Q<00?o0000100000H000?ogml05=l01OoOgmoo01CO0_lFg`05omoOgol05]l0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGkoOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC005oda<C?l05T`00ol0000400001P000ooO
g`0Eg`?o5Ml2oaOO0olGg`0HoenOGimOWenOGimOWenOGimOWenOGimO0ol0;UnOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@4o`0GO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
5d`4oaI<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0B?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdOP;o01[dO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0
000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooO
g`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<
00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H0
00?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0
000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000050?[o1P0000D0n_l600001P000ol0000]00;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0002`00olag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o0000:`001?l0
oolag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?o0000:P000ol00002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
<D`00ol0000400001P000ol0000Y0004o`0000;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0002P000?o00000P02oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000W0003o`0000<0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?o00009P000ol0000400;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000060003o`0002D000?o00001@02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000T0003o`0000H00_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00008`000ol0
000700;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003o`00028000?o00002002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co<D`00ol0000400001P000ol0000;00;o00<0ool04@000ol0000900;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000`000?o0?l0
4@000ol0000:00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003
o`0000@000060003o`0000d000?o00003`000ol0000;00;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000`000?o0?l03`000ol0000<00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
o`0000/00_l00`3oo`0=0003o`0000d00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc5<00?o0000100000H000?o000070000ol0000>00;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0001/000?o00003`02oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0
000J0003o`0001000_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<
00?o0000100000H000?o00006@000ol0000A00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0001P000?o00004P02oaOO1?lFg`0GoenOGimO
WenOGimOWenOGimOWenOGil01Ol0;ImOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm004o`0GO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l05d`3oaM<00?o0000100000H000?o0000
5`000ol0000C00;o5]l00ooOg`0Hg`1ToenOGimOWenOGimOWenOGimOWenOGiooWeooGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGkoOW5nLGiaOW5nLGiaOW5nLGia
OW5noaI<00GoC4a<o`0FC003o`0000@000060003o`0001H000?o00005002oaKO1OlFg`0GoenOGimO
WenOGimOWenOGimOWenOGil01?l0BEnOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Com7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm?l05T`00om<C00HC003o`0000@000060003
o`0001D000?o00005@02oaKO00GogmoOo`0Fg`1ToenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGkoOW5nLGiaOW5nLGia
OW5nLGiaOW5noaI<00GoC4a<o`0FC003o`0000@000060003o`0001@000?o00005P02oaOO0olGg`0H
oenOGimOWenOGimOWenOGimOWenOGimO0ol0;UnOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_@4o`0GO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l05d`4oaI<00?o0000100000H0
00?o00004`000ol0000G00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_laC003o`0000@000060003o`00018000?o00006002oc7O04SoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7h2o`0Jm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`00014000?o00006@02oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000@0003
o`0000`00ol;00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003
o`0000@000060003o`0000l000?o00003P000ol0000:00;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000h000?o000040000ol0000900;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
o`0000d000?o00004@000ol0000900;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003o`0000`000?o00004@000ol0o`0:00;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000/000?o0000
4P000ol0o`0:00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@000060003o`0000X000?o00004P02o`030?oo00T00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00002@000ol0000Q00;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000P0
00?o00008P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0
000400001P000ol000070003o`0002<00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc5<00?o0000100000H000?o00001P000ol0000T00;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000D000?o00009@02oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0
00040003o`0002H00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<
00?o0000100000H000?o00000`000ol0000W00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`00008000?o0000:002oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P001Ol0003o02/00_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000Co003o
;002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P000ol0o`0]00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@0000600;o;P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
<D`00ol0000400001P3io`H0000f00;oc@000?l01P000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P000?l01P000?H00ol<0000m`000ol0000;00001P02o`8000?o00001Ol200Co
00<0ool00ol0103oo`02o`800one00;o00<0ool02@000ol0o`090003o`0000X000070003o`3o00D0
00Go0000o`070005o`000?l00P000ol000020003o`000;D000?o0?l02`000ol000080003o`0000X0
000700?o1@001?l00005o`<000Go0000o`020003o`0000Co]`000ol0000800Go1`000ol0o`0;0000
1`02o`H000Go0000o`030005o`000?l00`001?l00?l20003o`3o0;L000?o0?l02`000ol000070003
o`3o00/000070003o`3o00D000?o00000P03o`<00_l200Go0P000ol0o`2f00;o00<0ool04`02o`03
0?oo00X0000600;o00<0ool010000ol0000D00;og@0000d00ol;0003o`000>L0003o00H0003o00H0
0000\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \({{"e", "a", "b", "c"}, {"a", "e", "c", "b"}, {"b", "c", "e", "a"}, {
        "c", "b", "a", "e"}}\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"OtherGroupoids"]
}, Open  ]],

Cell[TextData[{
  "From the Cayley table, ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  " appears to be one of the elements of the group."
}], "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupGenerated[Klein4, \ b]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \(Klein4::"warning" \( : \ \) 
      "The elements e, a, b, c are considered strings and thus need to have \
double quotes around them when being used."\)], "Message",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \(MemberQ::"elmnt" \( : \ \) 
      "\!\(b\) is not an element of \!\(\"Klein4\"\)."\)], "Message",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"OtherGroupoids"]
}, Open  ]],

Cell[TextData[{
  "The elements in the ",
  StyleBox["Klein4", "MR"],
  " group are strings, so we need quotes around them when trying to work with \
them."
}], "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupGenerated[Klein4, \ "\<b\>"]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \(Groupoid[{"b", "e"}, "-Operation-"]\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->"OtherGroupoids"]
}, Open  ]],

Cell[TextData[{
  "The default form of the ",
  StyleBox["QuaternionGroup", "MR"],
  " is to use the ",
  StyleBox["AsMatrices", "MR"],
  " approach."
}], "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{

Cell[BoxData[
    \(QuaternionGroup[]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \(Groupoid[{{{\(-1\), 0}, {0, \(-1\)}}, {{0, \(-1\)}, {1, 0}}, {{0, 
            \(-I\)}, {\(-I\), 0}}, {{0, I}, {I, 0}}, {{0, 1}, {\(-1\), 0}}, {{
            \(-I\), 0}, {0, I}}, {{I, 0}, {0, \(-I\)}}, {{1, 0}, {0, 1}}}, 
      "-Operation-"]\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->"OtherGroupoids"]
}, Open  ]],

Cell["\<\
There are two other approaches to this group (all of which are \
isomorphic to each other).\
\>", "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{

Cell[BoxData[
    \({QuaternionGroup[Form\  \[Rule] \ AsSymbols], \ 
      QuaternionGroup[Form\  \[Rule] \ AsIJK]}\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \(QuaternionGroup::"JJKK" \( : \ \) 
      "(Note that KK is used because K is a reserved symbol in version 3 of \
Mathematica and JJ is used because J is reserved as a generic name for an \
ideal.)"\)], "Message",
  CellTags->"OtherGroupoids"],

Cell[BoxData[
    \({Groupoid[{"e", "a", "a^2", "a^3", "b", "ba", "ba^2", "ba^3"}, 
        "-Operation-"], 
      Groupoid[{1, \(-1\), I, \(-I\), JJ, \(-JJ\), KK, \(-KK\)}, 
        "-Operation-"]}\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"OtherGroupoids"]
}, Open  ]],

Cell["2.5 Uses of the Cayley table", "Subsection",
  CellTags->"Cayley"],

Cell["\<\
As has been shown, the Cayley table is a tool that can be valuable \
in working with groupoids. There is a large number of variations in \
implementing this function.\
\>", "Text",
  CellTags->{"Cayley", "i:26"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cayley",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["G",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["lists",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["use",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"], " ", "to", " ", "form", " ", "the", 
              " ", "table"}]},
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{\(G\_1\), 
                        StyleBox[",",
                          "MR"], " ", \(G\_2\), 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]", 
                        StyleBox[",",
                          "MR"], " ", \(G\_n\)}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cayley",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["tables",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoids",
                SingleLetterItalics->False], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox[\(G\_1\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(, \ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(G\_2\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\(, \ \[Ellipsis], \)\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(G\_n\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ applying\ the\ options\ \),
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["each",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{\(G\_1\), 
                        StyleBox[",",
                          "MR"], " ", \(G\_2\), 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]", 
                        StyleBox[",",
                          "MR"], " ", \(G\_n\)}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{
                        RowBox[{
                          StyleBox["{",
                            "MR"], \(opts\_1\), 
                          StyleBox["}",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", 
                        RowBox[{
                          StyleBox["{",
                            "MR"], \(opts\_2\), 
                          StyleBox["}",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]", 
                        StyleBox[",",
                          "MR"], " ", 
                        RowBox[{
                          StyleBox["{",
                            "MR"], \(opts\_n\), 
                          StyleBox["}",
                            "MR"]}]}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Cayley",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["tables",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoids", 
                " ", 
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\(, \ \[Ellipsis], \)\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_n\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ applying\ the\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["opts",
                        FontSlant->"Italic"], "i"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_i\),
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{\(G\_1\), 
                        StyleBox[",",
                          "MR"], " ", \(G\_2\), 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]", 
                        StyleBox[",",
                          "MR"], " ", \(G\_n\)}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{
                        RowBox[{
                          StyleBox["{",
                            "MR"], \(opts\_1\), 
                          StyleBox["}",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", 
                        RowBox[{
                          StyleBox["{",
                            "MR"], \(opts\_2\), 
                          StyleBox["}",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]", 
                        StyleBox[",",
                          "MR"], " ", 
                        RowBox[{
                          StyleBox["{",
                            "MR"], \(opts\_n\), 
                          StyleBox["}",
                            "MR"]}]}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Mode",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", "mode"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Cayley",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["tables",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoids", 
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\(, \ \[Ellipsis], \)\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_n\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ applying\ the\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["opts",
                        FontSlant->"Italic"], "i"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_i\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              RowBox[{
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["well",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["applying",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(Mode\  \[Rule] \),
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["mode",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["each",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{
                      RowBox[{
                        StyleBox["{",
                          "MR"], 
                        RowBox[{\(G\_1\), 
                          StyleBox[",",
                            "MR"], " ", \(opts\_1\)}], 
                        StyleBox["}",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], " ", 
                      RowBox[{
                        StyleBox["{",
                          "MR"], " ", 
                        RowBox[{\(G\_2\), 
                          StyleBox[",",
                            "MR"], " ", \(opts\_2\)}], 
                        StyleBox["}",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], " ", "\[Ellipsis]", 
                      StyleBox[",",
                        "MR"], " ", 
                      RowBox[{
                        StyleBox["{",
                          "MR"], " ", 
                        RowBox[{\(G\_n\), 
                          StyleBox[",",
                            "MR"], " ", \(opts\_n\)}], 
                        StyleBox["}",
                          "MR"]}]}], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Cayley",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["tables",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["groupoid",
                      SingleLetterItalics->False], "s"}]], 
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\(, \ \[Ellipsis], \)\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_n\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ applying\ the\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["opts",
                        FontSlant->"Italic"], "i"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_i\),
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["CayleyTable",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{
                        RowBox[{
                          StyleBox["{",
                            "MR"], 
                          RowBox[{\(G\_1\), 
                            StyleBox[",",
                              "MR"], " ", \(opts\_1\)}], 
                          StyleBox["}",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", 
                        RowBox[{
                          StyleBox["{",
                            "MR"], " ", 
                          RowBox[{\(G\_2\), 
                            StyleBox[",",
                              "MR"], " ", \(opts\_2\)}], 
                          StyleBox["}",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", "\[Ellipsis]", 
                        StyleBox[",",
                          "MR"], " ", 
                        RowBox[{
                          StyleBox["{",
                            "MR"], " ", 
                          RowBox[{\(G\_n\), 
                            StyleBox[",",
                              "MR"], " ", \(opts\_n\)}], 
                          StyleBox["}",
                            "MR"]}]}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Mode",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", "mode"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Cayley",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["tables",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", 
                StyleBox[
                  RowBox[{
                    StyleBox["groupoid",
                      SingleLetterItalics->False], "s"}]], 
                StyleBox[
                  FormBox[\(G\_1\),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[
                  FormBox[\(G\_2\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\(, \ \[Ellipsis], \)\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_n\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ applying\ the\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["opts",
                        FontSlant->"Italic"], "i"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(G\_i\),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(as\ well\ as\ applying\ \),
                  SingleLetterItalics->False], 
                StyleBox[\(Mode\  \[Rule] \),
                  "MR"], 
                StyleBox[" ",
                  "Text"], 
                StyleBox["mode",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["each",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->{"Cayley", "i:27"}],

Cell[TextData[{
  "Variations for ",
  StyleBox["CayleyTable",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Cayley"],

Cell[TextData[{
  "Because the Cayley table is such a rich tool for illustrating algebraic \
ideas, there are also many options available to control the display of these \
tables (all of which apply only when the ",
  StyleBox["Visual", "MR"],
  " mode is being used)."
}], "Text",
  CellTags->"Cayley"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["CayleyForm",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["OutputForm",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["applied",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["body",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["HeadingsColored",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["top",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["side",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["headings",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["colored",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["KeyForm",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["InputForm",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", " ", 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["that",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["should",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["be",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              
              StyleBox[
                \(applied\ to\ the\ \(elements\ in\ the\ key\ of\ the\ table, 
                  \ when\ a\ key\ is\ used\)\),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["ShowBodyText",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["body",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["shown",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["ShowKey",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", " ", 
                StyleBox["whether",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["key",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["should",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["be",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["given",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(when\ a\ key\ is\ called\ for\),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["ShowName",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["name",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["shown",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["above",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["ShowOperator",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["shown",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["corner",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["ShowSidesText",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["top",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["row",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["left",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["column",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["table",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["shown",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["TheSet",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[\({}\),
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ a\ reordering\ of\ the\ elements\ to\ be\ used\ in
                \ the\ table\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["VarToUse",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["\<\"g\"\>",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbol",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["use",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["generic",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["name",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["key",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["needed",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.23, 0.19, 0.58},
  RowLines->{True, False}},
  CellTags->{"Cayley", "i:28"}],

Cell[TextData[{
  "Options specific to ",
  StyleBox["CayleyTable",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Cayley"],

Cell[TextData[{
  "Consider the groupoids ",
  Cell[BoxData[
      \(TraditionalForm\`G\_1\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\_2\)]],
  " defined as shown."
}], "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[G]\), 
    \({G\_1 = FormGroupoid[{2, 3, 1, 0}, Mod[#1 + #2, 4]&, "\<+\>"], \n
      G\_2 = FormGroupoidByTable[{b, a, a**b, 
            a\^b}, {{a, a**b, b, a\^b}, {b, a, a\^b, a**b}, {a**b, a\^b, b, 
              a}, {a\^b, a**b, a, b}}, "\<*\>", WideElements \[Rule] True]}
      \)}], "Input",
  CellLabel->"In[48]:=",
  CellTags->"Cayley"],

Cell[BoxData[
    \({Groupoid[{2, 3, 1, 0}, "-Operation-"], 
      Groupoid[{b, a, a**b, a\^b}, "-Operation-"]}\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["CayleyTable", "MR"],
  " gives each element a unique color and then uses the colors throughout the \
body of the table."
}], "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[G\_1, Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 .5 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
0 0 1 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(0)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(3)] .69048 .69286 0 0 Mshowa
[(2)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(2)] .5 .50238 0 0 Mshowa
[(0)] .69048 .50238 0 0 Mshowa
[(3)] .88095 .50238 0 0 Mshowa
[(3)] .30952 .3119 0 0 Mshowa
[(0)] .5 .3119 0 0 Mshowa
[(2)] .69048 .3119 0 0 Mshowa
[(1)] .88095 .3119 0 0 Mshowa
[(2)] .30952 .12143 0 0 Mshowa
[(3)] .5 .12143 0 0 Mshowa
[(1)] .69048 .12143 0 0 Mshowa
[(0)] .88095 .12143 0 0 Mshowa
[(2)] .11905 .69286 0 0 Mshowa
[(3)] .11905 .50238 0 0 Mshowa
[(1)] .11905 .3119 0 0 Mshowa
[(0)] .11905 .12143 0 0 Mshowa
[(2)] .30952 .88333 0 0 Mshowa
[(3)] .5 .88333 0 0 Mshowa
[(1)] .69048 .88333 0 0 Mshowa
[(0)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[50]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P0000H0nOl600001P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000om<C00]C0;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000
100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003oda<02e<0_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?oC4`0
;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000om<C00]C0;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003
oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000
100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?laC003o`0000@000060003oda<01E<0_lFC0;o5]l4oaOO01OoGimOWenOGimOWenOGimO
WenOGimOW`03o`0_WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0ol067iaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaM<0_lHC003o`0000@000060003oda<01A<00CoC4co
5D`2oaOO00?ogml05ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lFC004
oda<oaM<00?o0000100000H000?oC4`054`01?m<C?lEC0;o6=l00ooOg`0Fg`1ToenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaI<00CoC4co5d`00ol0000400001P000om<C00DC004
oda<oaE<0_lIg`03omoO01GO01SoGimOWenOGimOWenOGimOWenOGimOWel2o`1:WenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lFC004oda<oaM<00?o0000100000H000?oC4`054`01?m<C?lEC0;o5]l01?oOgolGg`1ToenOGimO
WenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaI<00CoC4co5d`00ol0000400001P000om<
C00EC0;o5T`2oaOO0_lHg`0GoenOGimOWenOGimOWenOGimOWenOGil00ol0;imOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co01M<0_lHC003o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003oda<02e<0_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?oC4`0
;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol000040000
1P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003
o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000om<C00]C0;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000
100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003oda<02e<0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?oC4`0;D`2oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000om<C00]C0;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003oda<02e<0_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?oC4`0
;D`2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P000om<C00]C0;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@000060?Wo1P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003
omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
1P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0b
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO
03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0
033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGolaC003omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003
omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
1P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0b
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO
03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0
033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolaC003omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGolaC003omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GolaC003omoO02kO03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolaC003
omoO02kO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
1P0000H001OoOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@03o`0FLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01IOWenOGimOWenOGimOWenOGimOWenO0ol06ImOWenOGimOWenOGimOWenOGimOWenOGol05d`2oaQ<
00?ogml05=l4oaKO01OoOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@03o`0ILGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOoaI<
00CoC4co5d`00ooOg`0Eg`03omoO01KO03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGolFC004oda<oaM<00?ogml05]l00ooOg`0Eg`0cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l05enOGimOWenOGimOWenOGimOWenOGimO00;o01VOGimO
WenOGimOWenOGimOWenOGimOWeoo01I<00CoC4co5d`00ooOg`0Gg`03omoO01CO03?om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGolFC004oda<oaM<00?ogml05=l01?oOgolFg`0c
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000G
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l05oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01IOWenO
GimOWenOGimOWenOGimOWenO0ol06ImOWenOGimOWenOGimOWenOGimOWenOGol05d`2oaQ<00?ogml0
5Ml2oaOO01Oom7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`0Jm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0
;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`060000
1P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039OWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039OWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoc5<00?ogml0;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoc5<00?ogml0;]l0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoc5<00?ogml0;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<
00?ogml0;]l0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0
;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`060000
1P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039OWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039OWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0;]l0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoc5<00?ogml0;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoc5<00?ogml0;]l0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoc5<00?ogml0;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<
00?ogml0;]l0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
039OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoc5<00?ogml0
;]l0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`060000
1P3io`H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<
C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<
C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<
C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000G
oimOWenOGimOWenOGimOWenOGimOWel00ol05UnOGimOWenOGimOWenOGimOWenOGil2o`0FLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP?o01UnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01KO1?lGg`03oda<01E<
0_lGC00GoimOWenOGimOWenOGimOWenOGimOWel00ol06EnOGimOWenOGimOWenOGimOWenOGimOWol0
1P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGil2o`0b
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGg`03omoO01OO
00?oC4`054`01?m<C?lFC00coimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenO
GimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
6=l00ooOg`0Fg`03oda<01A<00CoC4co5T`0<onOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWenOGimOWenOo`0600001P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01IOWenO
GimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko6Ml00ooOg`0Eg`03oda<01A<00CoC4co5T`06?nOGimOWenOGimOWenOGimOWenO
GimOW`;o01UOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5]l01?oOgolGg`03oda<01A<00CoC4co5T`0<onOGimOWenO
GimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOo`0600001P005onOGimOWenO
GimOWenOGimOWenOGimO00?o01IOWenOGimOWenOGimOWenOGimOWenO0_l05WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0JO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGg`;o6=l00om<C00EC0;o5d`05onO
GimOWenOGimOWenOGimOWenOGimO00?o01UOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<
C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<Ml00om<C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<Ml00om<
C00^C00coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<Ml00om<C00^C00c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H000060?Wo
1P0000H000?ogml0;Ml2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolag`03o`0000@000060003omoO02gO0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO0_laC01T
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0
;Ml2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol000040000
1P000ooOg`0]g`;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03
o`0000@000060003omoO02gO0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO0_laC01Tog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o
<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003
omoO02gO0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000
100000H000?ogml0;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolag`03o`0000@000060003omoO02gO0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?maOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO0_laC01T
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0
;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol000040000
1P000ooOg`0Dg`Co5Ml2oaM<0_lHC00GogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00ol0;oAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenO00?o01ROGimOWenOGimOWenOGimO
WenOGimOWolFg`Co5ml00ol0000400001P000ooOg`0Eg`03omoO01GO0_lFC004oda<oaM<06CoLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGioo5ml00ooOg`0Gg`03o`0000@000060003
omoO01KO00?ogml05=l2oaI<00CoC4co5d`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOWolHg`03omoO01KO00?o0000100000H000?ogml05ml00ooOg`0Cg`;o5T`01?m<C?lGC01:
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimO
WenOGimOWenOGimOWel2o`0HWenOGimOWenOGimOWenOGimOWenOGioo6Ml00ooOg`0Eg`03o`0000@0
00060003omoO01CO00Cogmoo5Ml2oaI<00CoC4co5d`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenOGimOWolFg`04omoOoaOO00?o0000100000H000?ogml05Ml2oaKO0_lGC0;o64`05oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o031aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenO
GimOWenOGimOWenOGil3o`0HWenOGimOWenOGimOWenOGimOWenOGioo5ml2oaSO00?o0000100000H0
00?ogml0;Ml2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000ooOg`0]g`;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wolag`03o`0000@000060003omoO02gO0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?mnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO0_laC01Tog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<
06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooO
g`0]g`;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@0
00060003omoO02gO0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?ogml0;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO0_laC01Tog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO
0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H0
00?ogml0;Ml2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000ooOg`0]g`;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wolag`03o`0000@000060003omoO02gO0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?ogml0;Ml2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000ooOg`0]g`;o<D`0I?maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003omoO02gO0_laC01TogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000D0n_l600001@3jo`H0
00060003o`0002d00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<
00?o0000100000H000?o0000;003oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co<D`00ol0000400001P000ol0000[0004o`3ooc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000Z0003o`0000;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0002T000Co0000
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?o0000:0000ol0000200;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000060003o`0002L000?o00000`02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000V0003o`0000@00_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00009@000ol0
000500;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003o`0002@000?o00001P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co<D`00ol0000400001P000ol0000S0003o`0000L00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o00008P000ol0000800;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000/0
0_l00`3oo`0A0003o`0000T00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc5<00?o0000100000H000?o000030000ol0o`0A0003o`0000X00_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00003@000ol0000?0003
o`0000/00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000
100000H000?o000030000ol0o`0?0003o`0000`00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00002`02o`030?oo00d000?o00003@02oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0
000L0003o`0000h00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<
00?o0000100000H000?o00006`000ol0000?00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0001X000?o00004002oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000I0003o`000140
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?o000060000ol0000B00;o5]l4oaOO01OoGimOWenOGimOWenOGimOWenOGimOW`03o`0_WenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00ol06?Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoaM<0_lHC003o`0000@000060003o`0001L000?o00004`02oaOO00?ogml05ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC004oda<oaM<00?o0000100000H0
00?o00005P000ol0000D00;o6=l00ooOg`0Fg`1ToenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoaI<00CoC4co5d`00ol0000400001P000ol0000E0003o`0001D00_lIg`03omoO01GO
01SoGimOWenOGimOWenOGimOWenOGimOWel2o`1:WenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lFC004oda<oaM<00?o0000
100000H000?o000050000ol0000F00;o5]l01?oOgolGg`1ToenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoaI<00CoC4co5d`00ol0000400001P000ol0000C0003o`0001L00_lGg`;o
6=l05omOWenOGimOWenOGimOWenOGimOWenO00?o02nOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0GC0;o64`00ol0
000400001P000ol0000B0003o`0001P00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000?o00004@000ol0000I00;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`00010000?o00003003o`/0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H0
00?o00003`000ol0000>0003o`0000X00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc5<00?o0000100000H000?o00003P000ol0000@0003o`0000T00_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00003@000ol0
000A0003o`0000T00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<
00?o0000100000H000?o000030000ol0000A0003o`3o00X00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00002`000ol0000B0003o`3o00X0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?o00002P000ol0000B00;o00<0ool02@02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co<D`00ol0000400001P000ol000090003o`0002400_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o000020000ol0000R00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
o`0000L000?o00008`02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
<D`00ol0000400001P000ol000060003o`0002@00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00001@000ol0000U00;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000@000?o0000
9P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P000ol000030003o`0002L00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc5<00?o0000100000H000?o00000P000ol0000X00;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060005o`000?l0:`02oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P001?l00?l/00;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`3o02d0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
0_l^00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@0
00060?Wo1P0003H00_o=0000o`060000o`060000o`060000o`060000o`060000o`060000o`060000
o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000
o`060000o`060000<004ol800ol<0000<@000ol000330003o`0000/0000800?o0P02o`030?oo0080
1?l00`3oo`02o`801?l300?o0P05o`030?oo00;oZ@02o`030?oo00X000?o000020000ol0000:0000
2@001Ol0003o008000Co003o10001Ol0003o00<000?o00000P001ol0003o0?l00P001?l00?l30003
o`000:L000?o0?l02`000ol000080003o`0000X000090005o`000?l00P000ol00006o`040?ooo`<0
00?o00000P001ol0003o0?l00P001?l00?l30003o`000:P000?o00002005o`L000?o0?l02`0000L0
00Oo0?l0o`3o008000Co003o0`02o`L00_l30007o`000?l0o`020004o`00o`<000?o0000Y`000ol0
o`0;0003o`0000L000?o0?l02`0000L000Ko0?l0o`04o`<00ol00`3o00020003o`0000;o00<0ool0
0P03o`040?oo00;o00<0ool00onY00;o00<0ool02P000ol0000600;o00<0ool02P0000L01Ol00`3o
000:00Coj00000`00_og0000o`060000o`060000\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{0, 1, 3, 2}, {1, 2, 0, 3}, {3, 0, 2, 1}, {2, 3, 1, 0}}\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "When a groupoid is formed and the option ",
  StyleBox["WideElements \[Rule] True", "MR"],
  " is added, a key is included in the table."
}], "MathCaption",
  CellTags->{"Cayley", "i:29"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[G\_2, Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"Cayley"],

Cell[BoxData[
    \("KEY for TheGroup: label used \[Rule] element: {g1 \[Rule] b, g2 \
\[Rule] a, g3 \[Rule] a**b, g4 \[Rule] a^b}"\)], "Print",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(g2)] .30952 .69286 0 0 Mshowa
[(g3)] .5 .69286 0 0 Mshowa
[(g1)] .69048 .69286 0 0 Mshowa
[(g4)] .88095 .69286 0 0 Mshowa
[(g1)] .30952 .50238 0 0 Mshowa
[(g2)] .5 .50238 0 0 Mshowa
[(g4)] .69048 .50238 0 0 Mshowa
[(g3)] .88095 .50238 0 0 Mshowa
[(g3)] .30952 .3119 0 0 Mshowa
[(g4)] .5 .3119 0 0 Mshowa
[(g1)] .69048 .3119 0 0 Mshowa
[(g2)] .88095 .3119 0 0 Mshowa
[(g4)] .30952 .12143 0 0 Mshowa
[(g3)] .5 .12143 0 0 Mshowa
[(g2)] .69048 .12143 0 0 Mshowa
[(g1)] .88095 .12143 0 0 Mshowa
[(g1)] .11905 .69286 0 0 Mshowa
[(g2)] .11905 .50238 0 0 Mshowa
[(g3)] .11905 .3119 0 0 Mshowa
[(g4)] .11905 .12143 0 0 Mshowa
[(g1)] .30952 .88333 0 0 Mshowa
[(g2)] .5 .88333 0 0 Mshowa
[(g3)] .69048 .88333 0 0 Mshowa
[(g4)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[51]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P0000H0nOl600001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o
<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003
oda<02e<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000
100000H000?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
<Ml00ol0000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01T
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0
;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol000040000
1P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03
o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01Tog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o
<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003
oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000
100000H000?oC4`04T`3oaQ<0_lDC0?o6T`05OmaOW5nLGiaOW5nLGiaOW5nLGiaOP03o`0_OW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGil00ol06YmOWenOGimOWenOGimO
WenOGimOWenOGioo5=l3oa[O00?o0000100000H000?oC4`05D`00om<C00EC0;o5d`00om<C00GC01T
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOoaOO00?ogml05ml00ol000040000
1P000om<C00BC0Co0T`3oa9<0_lDC0Co0T`3oaA<01GoLGiaOW5nLGiaOW5nLGiaOW5nLGh01?l0;W7o
oomaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGil4o`03Gooo00;o01BOGimO
WenOGimOWenOGimOWenOoaCO1?l01=oooolEg`03o`0000@000060003oda<015<00GoC4a<o`03C003
oda<015<0_lCC005oda<C?l00d`00om<C00CC01TogkdO_Anm7kdO_Anm7kdO_Anm7koO_AnogkdO_Co
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGomOWeooGiooWenOGimOWenOGimO
WenOGimOWenOoa?O00GogmoOo`02g`03omoO01CO00?o0000100000H000?oC4`04D`01_m<C4coC0Co
4T`2oa=<00KoC4a<od`4oaA<06CoLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5nLGia
OW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOoenOGomOWeooGimOWenOGimOWenOGimOWenOGioo
4ml01OoOgmoo00;O00?ogml05=l00ol0000400001P000om<C00AC009oda<C?m<odco01=<0_lCC009
oda<C?m<odco01E<01_oO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7koO_@00_l0AgkdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOoenOGomOWenOoimOWenOGimOWenOGimOWenOGioo01?O
00GogmoOo`02g`03omoO01CO00?o0000100000H000?oC4`04T`6o`03C?m<019<0_lDC0Ko00=<od`0
54`05OmaOW5nLGiaOW5nLGiaOW5nLGiaOP05o`0]OW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimO
WenOGimOWenOGimOWenO00Ko01MOWonOGimOWenOGimOWenOGimOWenOo`0Dg`Go00?Ooml05Ml00ol0
000400001P000om<C00HC0;o4d`2oaY<0_lEC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h3o`0`
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenO0_l05EnOGimOWenO
GimOWenOGimOWenOo`0Ig`;o5]l00ol0000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<
06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<
C00]C0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@0
00060003oda<02e<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<
0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H0
00?oC4`0;D`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000om<C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Wolag`03o`0000@000060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00]C0;o<D`0I?mnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02e<0_laC01Tog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0;D`2oc5<
06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<
C00]C0;o<D`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@0
00060003oda<02e<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`0;D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo<Ml00ol0000400001P3io`H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooO
g`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooO
g`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000EogiaOW5nLGiaOW5nLGiaOW5nLGia00?o01QaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0DLGiaOW5nLGiaOW5nLGiaOW5nLGh3o`0KOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01A<0olJC003omoO01;O0olIg`0EoimOWenOGimOWenOGimOWenOGimO00?o
01]OWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lGC003oda<01M<00?ogml05Ml00ooOg`0Fg`0coimOWenOGimOWenO
GimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000EogiaOW5nLGiaOW5n
LGiaOW5nLGia00Co01MnooooOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0DLGiaOW5nLGiaOW5nLGiaOW5n
LGh4o`0JLOooog5nLGiaOW5nLGiaOW5nLGiaOW5nLOlDC0Co0T`3oaA<00?ogml04]l4o`04gooooaCO
01GoWenOGimOWenOGimOWenOGimOWel01?l00iooo`02o`0EGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Com7kdooAnm7koO_Anm7kdO_Anm7kdO_Anm7kd0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7ko4d`01Om<C4co00=<
00?oC4`04d`00ooOg`0Ag`05omoOgol00]l00ooOg`0Cg`0coimOWenOGimOWenOGimOWenOGiooWenO
oimOoenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGkoOW5n
ogiaOW7oLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaog5nLGkoOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4d`01_m<C4coC0Co54`00ooOg`0Ag`05omoOgol00]l00ooOg`0Cg`0c
oimOWenOGimOWenOGimOWenOGiooWenOoimOWonOGimOWenOGimOWenOGimOWenOGioo00H00006000K
ooAnm7kdO_Anm7kdO_Anm7kdO_Com7kdooAn00;o01?dO_Anm7kdO_Anm7kdO_Anm7kd00;o01Ynm7kd
O_Anm7kdO_Anm7kdO_AnogkdO_mnm0;o01Inm7kdO_Anm7kdO_Anm7kdO_Anm7ko4d`02Om<C4coC?m<
o`0EC003omoO017O00GogmoOo`02g`03omoO01?O03?oWenOGimOWenOGimOWenOGimOWonOGiooWenO
GomOWenOGimOWenOGimOWenOGimOWol01P0000H001GoOW5nLGiaOW5nLGiaOW5nLGiaOW401Ol05W5n
LOmaOW5nLGiaOW5nLGiaOW5nLGh2o`0DLGiaOW5nLGiaOW5nLGiaOW5nLGh5o`0IOW5nogiaOW5nLGia
OW5nLGiaOW5nLGiao`0DC0Ko00=<od`054`00ooOg`0Bg`Go00?Ooml05=l05OnOGimOWenOGimOWenO
GimOWenOG`06o`0HWeooGimOWenOGimOWenOGimOWenOGioo1P0000H001[om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm0?o01?dO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_An00?o01Inm7kdO_Anm7kdO_Anm7kdO_Anm7ko6T`2oaE<00?ogml05ml2oaGO01_oWenOGimOWenO
GimOWenOGimOWenOGimOWel00_l05YmOWenOGimOWenOGimOWenOGimOWol600001P00<?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<
00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o
039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0
;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`060000
1P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<
00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o
039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0
;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`060000
1P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o039nm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P3io`H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo031<03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oc7O03?oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`060000
1P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo031<03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oc7O03?oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`060000
1P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo031<03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2oc7O03?oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`060000
1P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P005OnOGimOWenOGimOWenOGimOWenOG`03o`0H
GimOWenOGimOWenOGimOWenOGimOWenO0_lDg`?o6]l05OmOWenOGimOWenOGimOWenOGimOW`03o`0K
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01A<0olIC00EogiaOW5nLGiaOW5nLGiaOW5nLGia00?o
01]aOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenO
GiooWenOGimOWenOGimOWenOGimOWenOGil2oaOO00?ogml05ml0<omOWenOGimOWenOGimOWenOGimO
WenOGomOWenOGimOWenOGimOWenOGimOWenOGimOo`0GC003oda<01I<03?om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H001GoWenOGimOWenOGimOWenO
GimOWel01?l00iooo`02o`0BGimOWenOGimOWenOGimOWenO0_lDg`Co00COoooo5Ml05OmOWenOGimO
WenOGimOWenOGimOW`04o`03Gooo00;o01FOGimOWenOGimOWenOGimOWenOGol054`4o`9<0olCC00E
ogiaOW5nLGiaOW5nLGiaOW5nLGia00Co01YnooooOW5nLGiaOW5nLGiaOW5nLGiaOW5no`H00006000`
oimOWenOGimOWenOGimOWenOGiooWenOoimOoenOGimOWenOGimOWenOGimOWenO0_lCg`05omoOgol0
0]l00ooOg`0Dg`0coenOGimOWenOGimOWenOGimOWeooGimOoenOoimOWenOGimOWenOGimOWenOGimO
Weoo01=<00GoC4a<o`03C003oda<019<03?om7kdO_Anm7kdO_Anm7kdO_Anm?odO_Com7kdO_mnm7kd
O_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oWenOGimOWenOGimOWenOGimOWonOGiooWenOoimOWenO
GimOWenOGimOWenOGil2oa?O00GogmoOo`02g`03omoO01CO03?oGimOWenOGimOWenOGimOWenOGomO
WeooGimOoenOGimOWenOGimOWenOGimOWenOGol04d`01_m<C4coC0Co4d`0<omnLGiaOW5nLGiaOW5n
LGiaOW5nogiaO_mnLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenO
GimOWenOoimOWonOGimOoenOGimOWenOGimOWenOGimOW`;o4ml01OoOgmoo00;O00?ogml05=l0<omO
WenOGimOWenOGimOWenOGimOoenOGomOWenOoimOWenOGimOWenOGimOWenOGimOo`0CC009oda<C?m<
odco01A<01_om7kdO_Anm7kdO_Anm7kdO_Anm?odO_Com7h00_l05_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l600001P005OnOGimOWenOGimOWenOGimOWenOG`06o`0EWeooGimOWenOGimOWenOGimOWenO00;o
5=l5o`03gooO01GO01GoGimOWenOGimOWenOGimOWenOGil01_l065nOoimOWenOGimOWenOGimOWenO
GimOoaA<1_l00dcoC00CC00EogiaOW5nLGiaOW5nLGiaOW5nLGia00Go01UaOW7oLGiaOW5nLGiaOW5n
LGiaOW5nLGko00H00006000KoimOWenOGimOWenOGimOWenOGimOWenOGimO00;o01>OGimOWenOGimO
WenOGimOWenO00;o6Ml2oaKO01_oGimOWenOGimOWenOGimOWenOGimOWenOGil00_l05UnOGimOWenO
GimOWenOGimOWenOGolJC0;o54`06_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0ol05_Anm7kdO_An
m7kdO_Anm7kdO_Anm?l600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<
03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0
033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<
03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0
033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<
03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0
033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O03?oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0<4`0<omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0coenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGil2oc7O03?oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol0<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml0<omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_lag`0coenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<
03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0
nOl600001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOl`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o
06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<=l00om<C00_C003o`0000@0
00060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`g`03
oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`g`03oda<02m<00?o0000100000H0
00?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc3O00?oC4`0
;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_l`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc3O00?oC4`0;d`00ol0000400001P000ooO
g`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<=l00om<C00_C003
o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<=l00om<C00_C003o`0000@000060003omoO02gO
0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`g`03oda<02m<00?o0000
100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc3O
00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`g`03oda<02m<00?o0000100000H000?ogml04]l3oaSO
0_l055nOGimOWenOGimOWenOGimOWenO0ol0;imOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kd00?o01_dO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05=l3oaWO00?oC4`0
4T`3oaY<00?o0000100000H000?ogml05Ml00ooOg`0Eg`;o06AOWenOGimOWenOGimOWenOGimOWenO
GomOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o5ml00ooOg`0Fg`03oda<01E<00?oC4`05d`00ol0000400001P000ooO
g`0Bg`Co00COoooo4ml2o`0DGimOWenOGimOWenOGimOWenOGil4o`03Gooo00;o02VOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm004o`0JO_ooogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_lDg`Co00COoooo5=l00om<C00BC0Co0T`3oaA<00?o0000100000H000?ogml04Ml01OoOgmoo00;O
00?ogml04]l2o`1TGimOWenOGimOWenOGimOWenOGomOWeooGiooWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaog5nLOmaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaoa?O00GogmoO
o`02g`03omoO01?O00?oC4`04D`01Om<C4co00=<00?oC4`04d`00ol0000400001P000ooOg`0Ag`05
omoOgol00]l00ooOg`0Bg`;o06AOWenOGimOWenOGimOWenOGimOoenOGomOWeooGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7koO_AnogkdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7ko
4ml01OoOgmoo00;O00?ogml04ml00om<C00AC006oda<C?m<1?lDC003o`0000@000060003omoO017O
00GogmoOo`02g`03omoO01;O0_l0C5nOGimOWenOGimOWenOGimOWeooGimOoenOGiooWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW7oLGh2o`0FLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa?O00GogmoOo`02g`03omoO01?O00?oC4`04D`02Om<C4coC?m<o`0EC003o`0000@000060003
omoO01;O1Ol00moog`0Cg`;o01AOWenOGimOWenOGimOWenOGimOW`Ko02aOWonOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm0Go01WdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7ko01CO
1Ol00moog`0Dg`03oda<019<1_l00dcoC00DC003o`0000@000060003omoO01OO0_lDg`;o01YOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o02mOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@03o`0FLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaWO0_lEg`03oda<01Q<0_lEC003
o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_l`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<=l00om<C00_C003o`0000@000060003omoO02gO
0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`g`03oda<02m<00?o0000
100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc3O
00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1T
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc3O00?oC4`0;d`00ol000040000
1P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<=l00om<
C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOl`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<=l00om<C00_C003o`0000@000060003
omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`g`03oda<02m<
00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`g`03oda<02m<00?o0000100000H000?ogml0
;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc3O00?oC4`0;d`00ol0
000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
<=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_l`g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc3O00?oC4`0;d`00ol0000400001P000ooOg`0]g`;o
06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<=l00om<C00_C003o`0000@0
00050?[o1P0000D0n_l600001P000ol0000]00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0002`00olag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o0000:`001?l0oolag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o0000:P000ol0
0002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P000ol0000Y0004o`0000;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_laC003o`0000@000060003o`0002P000?o00000P02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000W0003o`0000<00_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o00009P000ol0
000400;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@0
00060003o`0002D000?o00001@02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko<D`00ol0000400001P000ol0000T0003o`0000H00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00008`000ol0000700;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`000280
00?o00002002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0
000400001P000ol0000;00;o00<0ool04@000ol0000900;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000`000?o0?l04@000ol0000:00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
o`0000d000?o00003`000ol0000;00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003o`0000`000?o0?l03`000ol0000<00;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000/00_l00`3o
o`0=0003o`0000d00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<
00?o0000100000H000?o000070000ol0000>00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0001/000?o00003`02oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000J0003o`000100
0_lDg`?o6]l05OmOWenOGimOWenOGimOWenOGimOW`03o`0_WenOGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_@00ol06_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co54`3oaY<
00?o0000100000H000?o00006@000ol0000A00;o5ml00ooOg`0Gg`1ToenOGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noaM<00?oC4`05d`00ol0000400001P000ol0000H0003o`000180
0_lDg`Co00COoooo5Ml05OmOWenOGimOWenOGimOWenOGimOW`04o`03Gooo00;o02VOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm004o`0IO_ooogkdO_Anm7kdO_Anm7kdO_Anm7kd
o`0DC0Co0T`3oaA<00?o0000100000H000?o00005`000ol0000C00;o4ml01OoOgmoo00;O00?ogml0
5=l0I?mOWenOGimOWenOGimOWenOGimOoenOGomOWonOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW7oLGiaog5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaO_lCC005oda<C?l00d`00om<
C00CC003o`0000@000060003o`0001H000?o00005002oa?O00GogmoOo`02g`03omoO01CO06CoGimO
WenOGimOWenOGimOWenOGomOWeooGimOoenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_AnogkdO_mnm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Co4d`01_m<C4coC0Co54`00ol000040000
1P000ol0000E0003o`0001D00_lCg`05omoOgol00]l00ooOg`0Dg`1=oenOGimOWenOGimOWenOGimO
WeooGimOoenOGiooWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW7oLGh0
0_l05G5nLGiaOW5nLGiaOW5nLGiaOW5no`0CC009oda<C?m<odco01E<00?o0000100000H000?o0000
50000ol0000F00;o5=l5o`03gooO01GO01GoGimOWenOGimOWenOGimOWenOGil01_l0;5nOoimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd1Ol06?Anm?odO_Anm7kdO_Anm7kdO_An
m7kdoaA<1_l00dcoC00DC003o`0000@000060003o`0001<000?o00005`02oaWO0_lFg`0KoenOGimO
WenOGimOWenOGimOWenOGimOWenO00;o02mOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@03o`0ELGiaOW5nLGiaOW5nLGiaOW5nLGko01Y<0_lEC003o`0000@000060003
o`00018000?o00006002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
<D`00ol0000400001P000ol0000A0003o`0001T00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o000040000ol0000<00?o2`02oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000?0003
o`0000h000?o00002P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
<D`00ol0000400001P000ol0000>0003o`00010000?o00002@02oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000=0003o`00014000?o0000
2@02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol000040000
1P000ol0000<0003o`00014000?o0?l02P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000;0003o`00018000?o0?l02P02oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000:0003
o`0001800_l00`3oo`0900;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000060003o`0000T000?o00008@02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol000080003o`0002800_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00001`000ol0
000S00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003o`0000H000?o00009002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co<D`00ol0000400001P000ol000050003o`0002D00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o000010000ol0000V00;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000<0
00?o00009`02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0
000400001P000ol000020003o`0002P00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000Go0000o`0[00;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060004o`00ob`00_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o0?l0;@02oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P02obh00_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H0nOl60000
=P02old0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0
003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0003o00H0
000`00Co`P03o``0000a0003o`000<<000?o00002`0000P00ol200;o00<0ool00P04o`030?oo00;o
0P04o`<00ol200Go00<0ool00_nY00;o00<0ool02@000ol0o`090003o`0000X000090005o`000?l0
0P001?l00?l40005o`000?l00`000ol000020007o`000?l0o`020004o`00o`<000?o0000Y`000ol0
o`0;0003o`0000P000?o00002P0000T000Go0000o`020003o`0000Ko00@0oooo0`000ol000020007
o`000?l0o`020004o`00o`<000?o0000Z0000ol0000800Go1`000ol0o`0;00001`001ol0o`3o0?l0
0P001?l00?l300;o1`02o`<000Oo0000o`3o008000Co003o0`000ol0002W0003o`3o00/000?o0000
1`000ol0o`0;00001`001_l0o`3o00Co0`03o`030?l0008000?o00000_l00`3oo`0200?o00@0ool0
0_l00`3oo`03ojT00_l00`3oo`0C00;o00<0ool02P0000L01Ol00`3o000:00Coj00000`00_og0000
o`060000o`060000\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{a, a**b, b, a\^b}, {b, a, a\^b, a**b}, {a**b, a\^b, b, a}, {a\^b, 
        a**b, a, b}}\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "In addition to the options for ",
  StyleBox["CayleyTable", "MR"],
  ", we can also pass graphics options."
}], "MathCaption",
  CellTags->{"Cayley", "i:30"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[G\_1, Mode \[Rule] Visual, TheSet \[Rule] {0, 1, 2, 3}, 
      HeadingsColored \[Rule] False, ShowOperator \[Rule] False, 
      Background \[Rule] Cyan, Frame \[Rule] True, 
      ShowSidesText \[Rule] False]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.102 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Background color
0 1 1 r
MFill
% Scaling calculations
0.214286 0.190476 0.0281429 0.190476 [
[.02381 -0.0125 -6 -9 ]
[.02381 -0.0125 6 0 ]
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .02814 -6 -4.5 ]
[-0.0125 .02814 0 4.5 ]
[-0.0125 .21862 -6 -4.5 ]
[-0.0125 .21862 0 4.5 ]
[-0.0125 .4091 -6 -4.5 ]
[-0.0125 .4091 0 4.5 ]
[-0.0125 .59957 -6 -4.5 ]
[-0.0125 .59957 0 4.5 ]
[-0.0125 .79005 -6 -4.5 ]
[-0.0125 .79005 0 4.5 ]
[-0.0125 .98052 -6 -4.5 ]
[-0.0125 .98052 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1.102 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1.102 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(-1)] .02381 -0.0125 0 1 Mshowa
.21429 0 m
.21429 .00625 L
s
[(0)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(1)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(2)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(3)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(4)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.0619 0 m
.0619 .00375 L
s
.1 0 m
.1 .00375 L
s
.1381 0 m
.1381 .00375 L
s
.17619 0 m
.17619 .00375 L
s
.25238 0 m
.25238 .00375 L
s
.29048 0 m
.29048 .00375 L
s
.32857 0 m
.32857 .00375 L
s
.36667 0 m
.36667 .00375 L
s
.44286 0 m
.44286 .00375 L
s
.48095 0 m
.48095 .00375 L
s
.51905 0 m
.51905 .00375 L
s
.55714 0 m
.55714 .00375 L
s
.63333 0 m
.63333 .00375 L
s
.67143 0 m
.67143 .00375 L
s
.70952 0 m
.70952 .00375 L
s
.74762 0 m
.74762 .00375 L
s
.82381 0 m
.82381 .00375 L
s
.8619 0 m
.8619 .00375 L
s
.9 0 m
.9 .00375 L
s
.9381 0 m
.9381 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .02814 m
.00625 .02814 L
s
[(0)] -0.0125 .02814 1 0 Mshowa
0 .21862 m
.00625 .21862 L
s
[(1)] -0.0125 .21862 1 0 Mshowa
0 .4091 m
.00625 .4091 L
s
[(2)] -0.0125 .4091 1 0 Mshowa
0 .59957 m
.00625 .59957 L
s
[(3)] -0.0125 .59957 1 0 Mshowa
0 .79005 m
.00625 .79005 L
s
[(4)] -0.0125 .79005 1 0 Mshowa
0 .98052 m
.00625 .98052 L
s
[(5)] -0.0125 .98052 1 0 Mshowa
.125 Mabswid
0 .06624 m
.00375 .06624 L
s
0 .10433 m
.00375 .10433 L
s
0 .14243 m
.00375 .14243 L
s
0 .18052 m
.00375 .18052 L
s
0 .25671 m
.00375 .25671 L
s
0 .29481 m
.00375 .29481 L
s
0 .3329 m
.00375 .3329 L
s
0 .371 m
.00375 .371 L
s
0 .44719 m
.00375 .44719 L
s
0 .48529 m
.00375 .48529 L
s
0 .52338 m
.00375 .52338 L
s
0 .56148 m
.00375 .56148 L
s
0 .63767 m
.00375 .63767 L
s
0 .67576 m
.00375 .67576 L
s
0 .71386 m
.00375 .71386 L
s
0 .75195 m
.00375 .75195 L
s
0 .82814 m
.00375 .82814 L
s
0 .86624 m
.00375 .86624 L
s
0 .90433 m
.00375 .90433 L
s
0 .94243 m
.00375 .94243 L
s
0 1.01862 m
.00375 1.01862 L
s
0 1.05671 m
.00375 1.05671 L
s
0 1.09481 m
.00375 1.09481 L
s
.25 Mabswid
0 0 m
0 1.102 L
s
.02381 1.09575 m
.02381 1.102 L
s
.21429 1.09575 m
.21429 1.102 L
s
.40476 1.09575 m
.40476 1.102 L
s
.59524 1.09575 m
.59524 1.102 L
s
.78571 1.09575 m
.78571 1.102 L
s
.97619 1.09575 m
.97619 1.102 L
s
.125 Mabswid
.0619 1.09825 m
.0619 1.102 L
s
.1 1.09825 m
.1 1.102 L
s
.1381 1.09825 m
.1381 1.102 L
s
.17619 1.09825 m
.17619 1.102 L
s
.25238 1.09825 m
.25238 1.102 L
s
.29048 1.09825 m
.29048 1.102 L
s
.32857 1.09825 m
.32857 1.102 L
s
.36667 1.09825 m
.36667 1.102 L
s
.44286 1.09825 m
.44286 1.102 L
s
.48095 1.09825 m
.48095 1.102 L
s
.51905 1.09825 m
.51905 1.102 L
s
.55714 1.09825 m
.55714 1.102 L
s
.63333 1.09825 m
.63333 1.102 L
s
.67143 1.09825 m
.67143 1.102 L
s
.70952 1.09825 m
.70952 1.102 L
s
.74762 1.09825 m
.74762 1.102 L
s
.82381 1.09825 m
.82381 1.102 L
s
.8619 1.09825 m
.8619 1.102 L
s
.9 1.09825 m
.9 1.102 L
s
.9381 1.09825 m
.9381 1.102 L
s
.25 Mabswid
0 1.102 m
1 1.102 L
s
.99375 .02814 m
1 .02814 L
s
.99375 .21862 m
1 .21862 L
s
.99375 .4091 m
1 .4091 L
s
.99375 .59957 m
1 .59957 L
s
.99375 .79005 m
1 .79005 L
s
.99375 .98052 m
1 .98052 L
s
.125 Mabswid
.99625 .06624 m
1 .06624 L
s
.99625 .10433 m
1 .10433 L
s
.99625 .14243 m
1 .14243 L
s
.99625 .18052 m
1 .18052 L
s
.99625 .25671 m
1 .25671 L
s
.99625 .29481 m
1 .29481 L
s
.99625 .3329 m
1 .3329 L
s
.99625 .371 m
1 .371 L
s
.99625 .44719 m
1 .44719 L
s
.99625 .48529 m
1 .48529 L
s
.99625 .52338 m
1 .52338 L
s
.99625 .56148 m
1 .56148 L
s
.99625 .63767 m
1 .63767 L
s
.99625 .67576 m
1 .67576 L
s
.99625 .71386 m
1 .71386 L
s
.99625 .75195 m
1 .75195 L
s
.99625 .82814 m
1 .82814 L
s
.99625 .86624 m
1 .86624 L
s
.99625 .90433 m
1 .90433 L
s
.99625 .94243 m
1 .94243 L
s
.99625 1.01862 m
1 1.01862 L
s
.99625 1.05671 m
1 1.05671 L
s
.99625 1.09481 m
1 1.09481 L
s
.25 Mabswid
1 0 m
1 1.102 L
s
0 0 m
1 0 L
1 1.102 L
0 1.102 L
closepath
clip
newpath
1 1 0 r
.21429 .59957 m
.21429 .79005 L
.40476 .79005 L
.40476 .59957 L
F
.78571 .4091 m
.78571 .59957 L
.97619 .59957 L
.97619 .4091 L
F
.59524 .21862 m
.59524 .4091 L
.78571 .4091 L
.78571 .21862 L
F
.40476 .02814 m
.40476 .21862 L
.59524 .21862 L
.59524 .02814 L
F
1 .5 0 r
.40476 .59957 m
.40476 .79005 L
.59524 .79005 L
.59524 .59957 L
F
.21429 .4091 m
.21429 .59957 L
.40476 .59957 L
.40476 .4091 L
F
.78571 .21862 m
.78571 .4091 L
.97619 .4091 L
.97619 .21862 L
F
.59524 .02814 m
.59524 .21862 L
.78571 .21862 L
.78571 .02814 L
F
.56 .37 .6 r
.59524 .59957 m
.59524 .79005 L
.78571 .79005 L
.78571 .59957 L
F
.40476 .4091 m
.40476 .59957 L
.59524 .59957 L
.59524 .4091 L
F
.21429 .21862 m
.21429 .4091 L
.40476 .4091 L
.40476 .21862 L
F
.78571 .02814 m
.78571 .21862 L
.97619 .21862 L
.97619 .02814 L
F
0 0 1 r
.78571 .59957 m
.78571 .79005 L
.97619 .79005 L
.97619 .59957 L
F
.59524 .4091 m
.59524 .59957 L
.78571 .59957 L
.78571 .4091 L
F
.40476 .21862 m
.40476 .4091 L
.59524 .4091 L
.59524 .21862 L
F
.21429 .02814 m
.21429 .21862 L
.40476 .21862 L
.40476 .02814 L
F
1 1 1 r
.008 w
.21238 .02624 Mdot
1 0 0 r
1 Mabswid
.02381 .02814 m
.02381 .98052 L
s
.02381 .02814 m
.97619 .02814 L
s
.02381 .21862 m
.97619 .21862 L
s
.02381 .4091 m
.97619 .4091 L
s
.02381 .59957 m
.97619 .59957 L
s
.02381 .79005 m
.97619 .79005 L
s
.02381 .98052 m
.97619 .98052 L
s
.21429 .02814 m
.21429 .98052 L
s
.40476 .02814 m
.40476 .98052 L
s
.59524 .02814 m
.59524 .98052 L
s
.78571 .02814 m
.78571 .98052 L
s
.97619 .02814 m
.97619 .98052 L
s
.02381 .98052 m
.21429 .79005 L
s
2.6 Mabswid
.21429 .02814 m
.21429 .98052 L
s
.02381 .79005 m
.97619 .79005 L
s
[(0)] .30952 .69481 0 0 Mshowa
[(1)] .5 .69481 0 0 Mshowa
[(2)] .69048 .69481 0 0 Mshowa
[(3)] .88095 .69481 0 0 Mshowa
[(1)] .30952 .50433 0 0 Mshowa
[(2)] .5 .50433 0 0 Mshowa
[(3)] .69048 .50433 0 0 Mshowa
[(0)] .88095 .50433 0 0 Mshowa
[(2)] .30952 .31386 0 0 Mshowa
[(3)] .5 .31386 0 0 Mshowa
[(0)] .69048 .31386 0 0 Mshowa
[(1)] .88095 .31386 0 0 Mshowa
[(3)] .30952 .12338 0 0 Mshowa
[(0)] .5 .12338 0 0 Mshowa
[(1)] .69048 .12338 0 0 Mshowa
[(2)] .88095 .12338 0 0 Mshowa
[(TheGroup)] .02381 1.07576 -1 0 Mshowa
[(x)] .08857 .8529 0 0 Mshowa
[(y)] .16667 .92338 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[52]:=",
  ImageSize->{261.312, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l11@41000040437b/10Ql/0@<O
;@447b/10al^0@<O1@4100004@400al10@0Y0@047`417b`100<O0@40;@400al10@0^0@037`4102`1
00<O0@40104100002P457`8100<O0@40:@4011l10Al/0@037`4102h100<O0@40;@400al10@0Z0@@O
1@4100004@400al10@0Y0@047`417b`100<O0@40;`400al10@0Z0@8O;@400al17`060@40000A0@03
7`4102T100@O0@4O;0400al10@0/0@047`417bh100<O0@40:P400al17`060@40000@0@8O;0427b`1
0Ql_0@8O;0437bh10Ql60@40003o0@D10@000?l11@410000o`450@40003o0@D10@000?l11@410000
2@7k7`4000090@037`4100<100<O0@401`400al10@060@037`4100L100<O0@401P400al10@070@03
7`4100H100<O0@401`400al10@060@037`4100L100<O0@401P400al10@070@037`4100H100<O0@40
1`400al10@060@037`4100L100<O0@401P400al10@070@037`4100H100<O0@401`400al10@060@03
7`4100L100<O0@401P400al10@070@037`4100H100<O0@401`400al10@030@4O0@0000T100<O0@40
m`417`4000090@037`410?L10Al100002@400al10@3g0@4O0@0000810Ql50@037`410?L10Al10000
00D17`417`040@037`410?L10Al1000000D17`417`040@<O0`7_7`<10al1000000D17`417`040@03
7`4100<100<O0@40;0427bi<00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO7gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_An7`D10Al1000000D17`417`040@037`4100<100<O0@40;0427bi<00<Ogml0;Ml0H1nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7g5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7`D10Al100000P427`D100<O0@400`400al10@0/0@8O
;T`00aoOg`0]g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`4000090@03
7`4100<100<O0@40;0427bi<00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO7g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia7`D10Al100002@400al10@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOQl50@4O0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P
7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O1@417`4000090@037`4100<100<O0@40
;0427bi<00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO7gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7`D10Al10000
2@400al10@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGamaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLAl50@4O0@0000T10Ql40@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOQl40@8O0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P
7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O1@417`4000090@037`4100<100<O0@40
;0427bi<00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO7gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7`D10Al10000
2@400al10@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGamaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLAl50@4O0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`4000090@037`4100<100<O0@40;0427bi<00<Ogml0
;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7g5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7`D10Al100002@400al10@030@03
7`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl50@4O
0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW4O1@417`4000090@037`4100<100<O0@40;0427bi<00<Ogml0;Ml0H1nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7`D10Al100002@400al10@030@037`4102`10Ql^C003
7moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGamaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLAl50@4O0@0000T10Ql40@03
7`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl40@8O
0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW4O1@417`4000090@037`4100<100<O0@40;0427aE<0alFC0037moO01CO0QlGg`0F
7imOWenOGimOWenOGimOWenOGimOW`<O02bOGimOWenOGimOWenOGimOWenOGimO7gkdO_Anm7kdO_An
m7kdO_Anm7kdOP@O01OdO_Anm7kdO_Anm7kdO_Anm7kdO_An7`050@4O0@0000T100<O0@400`400al1
0@0/0@8O64`00am<C00CC0037moO01?O00@OgmlO5]l0H1nOGimOWenOGimOWenOGimOWenOGimO7enO
GimOWenOGimOWenOGimOWenOGimO7g5nLGiaOW5nLGiaOW5nLGiaOW5nLGhOOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGia7`D10Al100002@400al10@030@037`4102`10QlHC0037da<01=<00<Ogml04ml011oO
galFg`1P7imOWenOGimOWenOGimOWenOGimOWelOGimOWenOGimOWenOGimOWenOGimOWelOO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7hOO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`4000090@037`4100<1
00<O0@40;0427aI<0QlFC0037moO01?O00@OgmlO5]l0H1nOGimOWenOGimOWenOGimOWenOGimO7enO
GimOWenOGimOWenOGimOWenOGimO7g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQmnLGiaOW5nLGiaOW5n
LGiaOW5nLGia7`D10Al100002@400al10@030@037`4102`10QlHC0037da<01=<00<Ogml04ml011oO
galFg`1P7imOWenOGimOWenOGimOWenOGimOWelOGimOWenOGimOWenOGimOWenOGimOWelOO_Anm7kd
O_Anm7kdO_Anm7kdO_An7gkd7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`4000090@037`4100<1
00<O0@40;0427aE<0alFC0037moO01CO0QlGg`0F7imOWenOGimOWenOGimOWenOGimOW`8O02iOWenO
GimOWenOGimOWenOGimOWenOGamaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0Ql0675nLGiaOW5nLGiaOW5n
LGiaOW5nLGia7`D10Al100002@400al10@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl50@4O0@0000T10Ql40@037`4102`10Ql^C0037moO02gO
060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGamaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLAl40@8O0@0000T100<O0@400`400al1
0@0/0@8O;T`00aoOg`0]g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWelOO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`40
00090@037`4100<100<O0@40;0427bi<00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO7g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGia7`D10Al100002@400al10@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl50@4O0@0000T100<O0@400`400al10@0/0@8O;T`00aoO
g`0]g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O1@417`4000090@037`4100<1
00<O0@40;0427bi<00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO7gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7`D1
0Al100002@400al10@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGamaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLAl50@4O0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`4000090@037`4100<100<O0@40;0427bi<
00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7g5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7`D10Al100002@400al1
0@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OQl50@4O0@0000T10Ql40@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGamaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLAl40@8O0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO1@417`4000090@037`4100<100<O0@40;0427bi<
00<Ogml0;Ml0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7g5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7`D10Al100002@400al1
0@030@037`4102`10Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGamnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OQl50@4O0@0000T100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW4O1@417`4000090@037`4100<100<O0@40;0427bi<00<Ogml0;Ml0H1nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7gkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7`D10Al100002@400al10@030@037`4102`1
0Ql^C0037moO02gO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GamaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLAl50@4O0@000004
0AlO7`D100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P7imOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWelOO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7hO1@417`4000020@037`4100@100<O0@400`400al10@0/0@8O;T`00aoOg`0]g`1P
7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelOLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O1@417`4000020@037`4100@10al30NlO
0`437`4000020@037`4100@100<O0@400`400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWelO00D10Al100000P400al10@040@037`4100<100<O0@40
;0427`0_O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;d`00aoO
g`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`050@4O
0@0000030AlO00H100<O0@400`400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWelO00D10Al100002@400al10@030@037`4102`10Ql0;gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02m<00<Ogml0;=l0<AmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`4000090@037`4100<1
00<O0@40;0427`0_LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0
;d`00aoOg`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
7`050@4O0@0000T100<O0@400`400al10@0/0@8O02mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kd7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWelO00D10Al100002@400al10@030@037`4102`10Ql0;g5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02m<00<Ogml0;=l0<AmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`4000090@037`4100<1
00<O0@40;0427`0_O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0
;d`00aoOg`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
7`050@4O0@0000T100<O0@400`400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWelO00D10Al100002@427`@100<O0@40;0427`0_O_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;d`00aoOg`0/g`0a7enOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`040@8O0@0000T100<O0@400`400al1
0@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0_C003
7moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO00D1
0Al100002@400al10@030@037`4102`10Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@O02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGal01@417`4000090@037`4100<100<O0@40;0427`0_LGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;d`00aoOg`0/g`0a7enOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T100<O0@400`400al1
0@0/0@8O02mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0_C003
7moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO00D1
0Al100002@400al10@030@037`4102`10Ql0;g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGhO02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGal01@417`4000090@037`4100<100<O0@40;0427`0_O_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;d`00aoOg`0/g`0a7enOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T100<O0@400`400al1
0@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0_C003
7moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO00D1
0Al100002@400al10@030@037`4102`10Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@O02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGal01@417`4000090@8O10400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO00@10Ql100002@400al10@030@037`4102`1
0Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02m<00<Ogml0
;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`40
00090@037`4100<100<O0@40;0427`0_LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOQl0;d`00aoOg`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimO7`050@4O0@0000T100<O0@400`400al10@0/0@8O01Enm7kdO_Anm7kdO_Anm7kd
O_Anm7h011l05_Anm7kdO_Anm7kdO_Anm7kdO_Anm1lEC0<O5d`00aoOg`0Dg`8O5]l05QmOWenOGimO
WenOGimOWenOGimOWel37`0HGimOWenOGimOWenOGimOWenOGimOWelO1@417`4000090@037`4100<1
00<O0@40;0427`0_LGiaOW5nLGiaOW5nLGiaOW5nLGiaOQmnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0
64`00am<C00DC0037moO01?O00@OgmlO5Ml0<AmOWenOGimOWenOGimOWenOGimOWenO7imOWenOGimO
WenOGimOWenOGimOWenOGal01@417`4000090@037`4100<100<O0@40;0427`0_O_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7hOO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l064`00am<C00DC0037moO01?O00@OgmlO
5Ml0<AmOWenOGimOWenOGimOWenOGimOWenO7imOWenOGimOWenOGimOWenOGimOWenOGal01@417`40
00090@037`4100<100<O0@40;0427`0_LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7giaOW5nLGiaOW5n
LGiaOW5nLGiaOQl05T`27aM<00<Ogml04ml011oOgalEg`0a7enOGimOWenOGimOWenOGimOWenOGilO
WenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T100<O0@400`400al10@0/0@8O02mnm7kd
O_Anm7kdO_Anm7kdO_Anm7hOO_@Om7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0HC0037da<01A<00<Ogml0
4ml011oOgalEg`0a7enOGimOWenOGimOWenOGimOWenOGilOWenOGimOWenOGimOWenOGimOWenOGimO
7`050@4O0@0000T100<O0@400`400al10@0/0@8O01IaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0Ql05g5n
LGiaOW5nLGiaOW5nLGiaOW5nLGhO01E<0alGC0037moO01CO0QlFg`0F7enOGimOWenOGimOWenOGimO
WenOG`8O01VOGimOWenOGimOWenOGimOWenOGimOWelO00D10Al100002@400al10@030@037`4102`1
0Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02m<00<Ogml0
;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`40
00090@8O10400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWelO00@10Ql100002@400al10@030@037`4102`10Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`4000090@037`4100<100<O0@40;0427`0_
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;d`00aoOg`0/g`0a
7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T1
00<O0@400`400al10@0/0@8O02mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kd7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWelO00D10Al100002@400al10@030@037`4102`10Ql0;g5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`4000090@037`4100<100<O0@40;0427`0_
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;d`00aoOg`0/g`0a
7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T1
00<O0@400`400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWelO00D10Al100002@400al10@030@037`4102`10Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`4000090@037`4100<100<O0@40;0427`0_
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;d`00aoOg`0/g`0a
7enOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T1
0Ql40@037`4102`10Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@O02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGal010427`4000090@037`4100<100<O0@40;0427`0_LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;d`00aoOg`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T100<O0@400`400al10@0/0@8O02mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0_C0037moO02cO034OGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO00D10Al100002@400al1
0@030@037`4102`10Ql0;g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGhO02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGal01@417`4000090@037`4100<100<O0@40;0427`0_O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;d`00aoOg`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000T100<O0@400`400al10@0/0@8O02maOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0_C0037moO02cO034OGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWelO00D10Al100002@400al1
0@030@037`4102`10Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@O02m<00<Ogml0;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGal01@417`4000090@037`4100<100<O0@40;0427`0_LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;d`00aoOg`0/g`0a7enOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimO7`050@4O0@0000030AlO008O10400al10@030@037`4102`1
0Ql0;gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02m<00<Ogml0
;=l0<AmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGal01@417`40
00020@037`4100@100<O0@400`400al10@0/0@8O02maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n7`0_C0037moO02cO034OGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWelO00D10Al100000`400al10@030@<O0`7_7`<10al1000010400al1
0@020@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0
;T`00aoOg`0]g`037`4100<10Al1000000D17`417`040@037`4100<100<O0@40;0427`1OGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;T`00aoOg`0]g`037`4100<10Al100000P427`D1
00<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0^C003
7moO02gO00<O0@400`417`4000090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm1l0;T`00aoOg`0]g`037`4100<10Al100002@400al10@030@037`4102`1
0Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02i<00<Ogml0;Ml00al10@030@4O
0@0000T100<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
7`0^C0037moO02gO00<O0@400`417`4000090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;T`00aoOg`0]g`037`4100<10Al100002@400al10@030@03
7`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02i<00<Ogml0;Ml00al1
0@030@4O0@0000T10Ql40@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGhO02i<00<Ogml0;Ml00al10@020@8O0@0000T100<O0@400`400al10@0/0@8O05mOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0^C0037moO02gO00<O0@400`417`4000090@037`4100<1
00<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;T`00aoOg`0]g`03
7`4100<10Al100002@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@O02i<00<Ogml0;Ml00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O05mOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0^C0037moO02gO00<O0@400`417`4000090@03
7`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;T`00aoO
g`0]g`037`4100<10Al100002@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGhO02i<00<Ogml0;Ml00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O
05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0^C0037moO02gO00<O0@400`417`40
00090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0
;T`00aoOg`0]g`037`4100<10Al100002@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_@O02i<00<Ogml0;Ml00al10@030@4O0@0000T10Ql40@037`4102`1
0Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02i<00<Ogml0;Ml00al10@020@8O
0@0000T100<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
7`0^C0037moO02gO00<O0@400`417`4000090@037`4100<100<O0@40;0427`0EGimOWenOGimOWenO
GimOWenOGimO00<O02aOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOP@O
01MaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0EC0<O5T`00aoOg`0Dg`8O5ml00al10@030@4O0@0000T1
00<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenO7imOWenOGimOWenOGimOWenO
GimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7hOO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0HC003
7da<01=<00<Ogml04ml011oOgalFg`037`4100<10Al100002@400al10@030@037`4102`10Ql0GenO
GimOWenOGimOWenOGimOWenOGilOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGhOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO01Q<00<OC4`04d`00aoOg`0Cg`047moO7aKO
00<O0@400`417`4000090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWanO
GimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hOO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm1l05T`27aI<00<Ogml04ml011oOgalFg`037`4100<10Al100002@400al10@030@03
7`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGilOWenOGimOWenOGimOWenOGimOWenOGilOOW5n
LGiaOW5nLGiaOW5nLGiaOW5n7gia7g5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO01Q<00<OC4`04d`00aoO
g`0Cg`047moO7aKO00<O0@400`417`4000090@037`4100<100<O0@40;0427`0EGimOWenOGimOWenO
GimOWenOGimO008O02jOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_An
0Ql06?Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7aE<0alFC0037moO01CO0QlGg`037`4100<10Al10000
2@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02i<
00<Ogml0;Ml00al10@030@4O0@0000T10Ql40@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@O02i<00<Ogml0;Ml00al10@020@8O0@0000T100<O0@400`400al10@0/0@8O
05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0^C0037moO02gO00<O0@400`417`40
00090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0
;T`00aoOg`0]g`037`4100<10Al100002@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGhO02i<00<Ogml0;Ml00al10@030@4O0@0000T100<O0@400`400al1
0@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd7`0^C0037moO02gO00<O0@40
0`417`4000090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOQl0;T`00aoOg`0]g`037`4100<10Al100002@400al10@030@037`4102`10Ql0GenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02i<00<Ogml0;Ml00al10@030@4O0@0000T100<O0@40
0`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0^C0037moO02gO
00<O0@400`417`4000090@037`4100<100<O0@40;0427`1OGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm1l0;T`00aoOg`0]g`037`4100<10Al100002@400al10@030@037`4102`10Ql0GenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02i<00<Ogml0;Ml00al10@030@4O0@0000T1
0Ql40@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@O02i<00<Ogml0
;Ml00al10@020@8O0@0000T100<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5n7`0^C0037moO02gO00<O0@400`417`4000090@037`4100<100<O0@40;0427`1O
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm1l0;T`00aoOg`0]g`037`4100<10Al10000
2@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGhO02i<
00<Ogml0;Ml00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kd7`0^C0037moO02gO00<O0@400`417`4000090@037`4100<100<O0@40
;0427`1OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOQl0;T`00aoOg`0]g`037`4100<1
0Al100002@400al10@030@037`4102`10Ql0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@O02i<00<Ogml0;Ml00al10@030@4O0@0000040AlO7`D100<O0@400`400al10@0/0@8O05mOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n7`0^C0037moO02gO00<O0@400`417`4000040@03
7`41008100<O0@400`400al10@0/0@8O05mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
7`0^C0037moO02gO00<O0@400`417`4000040@037`4100810al30NlO0`437`4000020@8O1@400al1
0@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO;d`00al1
0@030@4O0@0000@100<O0@400P400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW4O;d`00al10@030@4O0@0000040AlO7`D100<O0@400`400al10@0/0@8O
;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7bm<00<O0@400`417`4000090@03
7`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLAl_C003
7`4100<10Al100002@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7hO;d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7bm<00<O0@400`417`4000090@037`4100<100<O0@40
;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl_C0037`4100<10Al10000
2@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O
;d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_An7bm<00<O0@400`417`4000090@8O10400al10@0/0@8O;]l0H1nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7bm<00<O0@400P427`4000090@037`4100<100<O0@40
;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl_C0037`4100<10Al10000
2@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O
;d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_An7bm<00<O0@400`417`4000090@037`4100<100<O0@40;0427bkO060OWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLAl_C0037`4100<10Al100002@400al10@030@03
7`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO;d`00al10@030@4O
0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia7bm<00<O0@400`417`4000090@037`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOQl_C0037`4100<10Al100002@400al10@030@037`4102`10Ql^g`1P
7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O;d`00al10@030@4O0@0000T10Ql40@03
7`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO;d`00al10@020@8O
0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia7bm<00<O0@400`417`4000090@037`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOQl_C0037`4100<10Al100002@400al10@030@037`4102`10QlFg`8O
5]l05QnOGimOWenOGimOWenOGimOWenOGil37`0]WenOGimOWenOGimOWenOGimOWenOGilOOW5nLGia
OW5nLGiaOW5nLGiaOW5n00@O01IaOW5nLGiaOW5nLGiaOW5nLGiaOW4O5D`37aM<00<O0@400`417`40
00090@037`4100<100<O0@40;0427aGO00@OgmlO5Ml0H1nOGimOWenOGimOWenOGimOWenOGimO7enO
GimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_An7gkdO_Anm7kdO_Anm7kd
O_Anm7kdO_An7aQ<00<OC4`054`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O5Ml011oO
galEg`1P7imOWenOGimOWenOGimOWenOGimOWelOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n7giaOW5nLGiaOW5nLGiaOW5nLGiaOW4O64`00am<C00DC0037`4100<1
0Al100002@400al10@030@037`4102`10QlEg`047moO7aGO060OWenOGimOWenOGimOWenOGimOWenO
GamOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7gkdO_Anm7kd
O_Anm7kdO_Anm7kdOQlFC08O5d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O5Ml011oO
galEg`1P7imOWenOGimOWenOGimOWenOGimOWelOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5n
LGiaOW5nLGiaOW5nLGiaOQmnLAmaOW5nLGiaOW5nLGiaOW5nLGiaOW4O64`00am<C00DC0037`4100<1
0Al100002@400al10@030@037`4102`10QlFg`8O5]l05QnOGimOWenOGimOWenOGimOWenOGil27`0_
GimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7h00Ql05oAnm7kdO_An
m7kdO_Anm7kdO_Anm7hO01E<0alGC0037`4100<10Al100002@400al10@030@037`4102`10Ql^g`1P
7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O;d`00al10@030@4O0@0000T10Ql40@03
7`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO;d`00al10@020@8O
0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWamnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia7bm<00<O0@400`417`4000090@037`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOQl_C0037`4100<10Al100002@400al10@030@037`4102`10Ql^g`1P
7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW4O;d`00al10@030@4O0@0000T100<O0@40
0`400al10@0/0@8O;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWaodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7bm<00<O0@40
0`417`4000090@037`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLAl_C0037`4100<10Al100002@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO;d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O
;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7bm<00<O0@400`417`4000090@03
7`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl_C003
7`4100<10Al100002@427`@100<O0@40;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLAl_C0037`4100810Ql100002@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO;d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O
;]l0H1nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWamnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia7bm<00<O0@400`417`4000090@03
7`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGilOm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl_C003
7`4100<10Al100002@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO7giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW4O;d`00al10@030@4O0@0000T100<O0@400`400al10@0/0@8O;]l0H1nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWaodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An7bm<00<O0@400`417`4000090@037`4100<100<O0@40
;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLAl_C0037`4100<10Al10000
2@400al10@030@037`4102`10Ql^g`1P7imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO7oAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7hO
;d`00al10@030@4O0@0000810al40@037`4100<100<O0@40;0427bkO060OWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLAl_C0037`4100<10Al100000`400al10@030@037`4100<100<O0@40
;0427bkO060OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGilOm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOQl_C0037`4100<10Al10000
00<17al00Ql40@<O0P7`7`<10al1000000@17`4O1@400al10@020O0O1@417`400000104O0Al50@03
7`4100<100<O0@40:P4011l17al^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al10000
0P427`D100<O0@400`400al10@0Y0@037`41008O;P400al10@0]0@037`4102`100<O0@40;@400al1
0@030@4O0@0000T100<O0@400`400al10@0X0@047`410@8O;P400al10@0]0@037`4102`100<O0@40
;@400al10@030@4O0@0000T100<O0@400`400al10@0W0@037`4100810Ql^0@037`4102d100<O0@40
;0400al10@0]0@037`4100<10Al100002@400al10@030@037`4102H100<O0@400`427bh100<O0@40
;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<100<O0@409@400al10@040@8O
;P400al10@0]0@037`4102`100<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@0T0@03
7`4100D10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al100002@427`@100<O0@40
8`400al10@060@8O;P400al10@0]0@037`4102`100<O0@40;@400al10@020@8O0@0000T100<O0@40
0`400al10@0R0@037`4100L10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al10000
2@400al10@030@037`41024100<O0@4020427bh100<O0@40;@400al10@0/0@037`4102d100<O0@40
0`417`4000090@037`4100<100<O0@4080400al10@090@8O;P400al10@0]0@037`4102`100<O0@40
;@400al10@030@4O0@0000T100<O0@400`400al10@0;0@8O00<17al03`400al10@0:0@8O;P400al1
0@0]0@037`4102`100<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@0<0@037`4O00l1
00<O0@402`427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<1
00<O0@403@400al10@0=0@037`4100`10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<1
0Al100002@400al10@030@037`4100`100<O0Al03@400al10@0=0@8O;P400al10@0]0@037`4102`1
00<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@0;0@8O00<17al02`400al10@0>0@8O
;P400al10@0]0@037`4102`100<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@0J0@03
7`4100l10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al100002@427`@100<O0@40
6@400al10@0@0@8O;P400al10@0]0@037`4102`100<O0@40;@400al10@020@8O0@0000T100<O0@40
0`400al10@0H0@037`4101410Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al10000
2@400al10@030@037`4101L100<O0@404P427bh100<O0@40;@400al10@0/0@037`4102d100<O0@40
0`417`4000090@037`4100<100<O0@405P400al10@0C0@8O;P400al10@0]0@037`4102`100<O0@40
;@400al10@030@4O0@0000T100<O0@400`400al10@0E0@037`4101@10Ql^0@037`4102d100<O0@40
;0400al10@0]0@037`4100<10Al100002@400al10@030@037`4101@100<O0@405@427bh100<O0@40
;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<100<O0@404`400al10@0F0@8O
;P400al10@0]0@037`4102`100<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@0B0@03
7`4101L10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al100002@400al10@030@03
7`41014100<O0@4060427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`4000090@8O
10400al10@0@0@037`4101T10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100810Ql10000
2@400al10@030@037`4100l100<O0@4030437`/10Ql^0@037`4102d100<O0@40;0400al10@0]0@03
7`4100<10Al100002@400al10@030@037`4100h100<O0@403P400al10@0:0@8O;P400al10@0]0@03
7`4102`100<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@0=0@037`41010100<O0@40
2@427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<100<O0@40
30400al10@0A0@037`4100T10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al10000
2@400al10@030@037`4100/100<O0@404@400al17`0:0@8O;P400al10@0]0@037`4102`100<O0@40
;@400al10@030@4O0@0000T100<O0@400`400al10@0:0@037`41018100<O0Al02P427bh100<O0@40
;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<100<O0@402@400al10@0B0@8O
00<17al02@427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<1
00<O0@4020400al10@0Q0@8O;P400al10@0]0@037`4102`100<O0@40;@400al10@030@4O0@0000T1
00<O0@400`400al10@070@037`4102810Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<1
0Al100002@427`@100<O0@401P400al10@0S0@8O;P400al10@0]0@037`4102`100<O0@40;@400al1
0@020@8O0@0000T100<O0@400`400al10@050@037`4102@10Ql^0@037`4102d100<O0@40;0400al1
0@0]0@037`4100<10Al100002@400al10@030@037`4100@100<O0@409@427bh100<O0@40;@400al1
0@0/0@037`4102d100<O0@400`417`4000090@037`4100<100<O0@400`400al10@0V0@8O;P400al1
0@0]0@037`4102`100<O0@40;@400al10@030@4O0@0000T100<O0@400`400al10@020@037`4102L1
0Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al100002@400al10@030@057`410Al0
:P427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`4000090@037`4100<100@O0@4O
:`427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`400000104O7al50@037`4100<1
00<O0Al0;0427bh100<O0@40;@400al10@0/0@037`4102d100<O0@400`417`4000040@037`410081
00<O0@400`427bd10Ql^0@037`4102d100<O0@40;0400al10@0]0@037`4100<10Al1000010400al1
0@020@<O0`7_7`<10al1000000@17alO1@400al10@0b0@8O``417`4000000`4O0@060@037`410?L1
0Al1000000<17al00Ql40@037`410?L10Al100002@400al10@3g0@4O0@0000T100<O0@40m`417`40
00090@037`410?L10Al100002@400al10@3g0@4O0@0000T100<O0@40m`417`4000090@037`410?L1
0Al100002@427oL10Ql100002@400al10@3g0@4O0@0000T100<O0@40m`417`4000090@037`410?L1
0Al100002@400al10@3g0@4O0@0000T100<O0@40m`417`4000090@037`410?L10Al100002@400al1
0@3g0@4O0@0000T100<O0@40m`417`4000090@8Om`427`4000090@037`4102d111o60@4O0@0000T1
00<O0@40;P400al10@360@4O0@0000T100<O0@401@437`810Ql00`4O7`020@@O00<17al00Ql20@@O
0`437`811Al00`4O7`027lD10Al100002@400al10@060@057`410Al00P4011l10Al40@057`410Al0
0`400al10@020@077`410Al17`020@047`417`<100<O0@40`P417`4000090@037`4100H100DO0@41
7`020@037`4100HO00@17alO0`400al10@020@077`410Al17`020@047`417`<100<O0@40`P417`40
00090@037`4100@100LO0Al17`4O008100@O0@4O0`427`L10Ql30@077`410Al17`020@047`417`<1
00<O0@40`P417`4000090@037`4100@100HO0Al17`447`<10al00`4O0@020@037`41008O00<17al0
0P437`040AlO0@8O00<17al00ao50@4O0@0000T100<O0@4010457`030Al100X111oM0@4O0@0000T1
00<O0@402@427n`10Al100002@427`@100<O0@40;@400al10@0/0@037`4102d100<O0@40;0400al1
0@0]0@037`4100810Ql100002@7k7`400000\
\>"],
  ImageRangeCache->{{{0, 260.312}, {287, 0}} -> {-1.3341, -0.402832, 
  0.0210474, 0.0210474}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{0, 1, 2, 3}, {1, 2, 3, 0}, {2, 3, 0, 1}, {3, 0, 1, 2}}\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell["\<\
Each option has its appropriate use, but they can also be used for \
unintended purposes.\
\>", "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[G\_2, Mode \[Rule] Visual, \ ShowName\  \[Rule] \ False, \ 
      VarToUse\  \[Rule] \ "\<hi\>", \ KeyForm\  \[Rule] \ FullForm, \ 
      CayleyForm\  \[Rule] \ Characters, \ 
      Epilog\  \[Rule] {RGBColor[1, 0, 0], Thickness[0.02], 
          Line[{{\(-1\), 0}, {5, 6}}]}]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"Cayley"],

Cell[BoxData[
    \("KEY for TheGroup: label used \[Rule] element: {hi1 \[Rule] b, hi2 \
\[Rule] a, hi3 \[Rule] NonCommutativeMultiply[a, b], hi4 \[Rule] Power[a, \
b]}"\)], "Print",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[({h, i, 2})] .30952 .69286 0 0 Mshowa
[({h, i, 3})] .5 .69286 0 0 Mshowa
[({h, i, 1})] .69048 .69286 0 0 Mshowa
[({h, i, 4})] .88095 .69286 0 0 Mshowa
[({h, i, 1})] .30952 .50238 0 0 Mshowa
[({h, i, 2})] .5 .50238 0 0 Mshowa
[({h, i, 4})] .69048 .50238 0 0 Mshowa
[({h, i, 3})] .88095 .50238 0 0 Mshowa
[({h, i, 3})] .30952 .3119 0 0 Mshowa
[({h, i, 4})] .5 .3119 0 0 Mshowa
[({h, i, 1})] .69048 .3119 0 0 Mshowa
[({h, i, 2})] .88095 .3119 0 0 Mshowa
[({h, i, 4})] .30952 .12143 0 0 Mshowa
[({h, i, 3})] .5 .12143 0 0 Mshowa
[({h, i, 2})] .69048 .12143 0 0 Mshowa
[({h, i, 1})] .88095 .12143 0 0 Mshowa
[({h, i, 1})] .11905 .69286 0 0 Mshowa
[({h, i, 2})] .11905 .50238 0 0 Mshowa
[({h, i, 3})] .11905 .3119 0 0 Mshowa
[({h, i, 4})] .11905 .12143 0 0 Mshowa
[({h, i, 1})] .30952 .88333 0 0 Mshowa
[({h, i, 2})] .5 .88333 0 0 Mshowa
[({h, i, 3})] .69048 .88333 0 0 Mshowa
[({h, i, 4})] .88095 .88333 0 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
1 0 0 r
.02 w
.02381 .02619 m
0 0 rlineto s
.02381 .02619 m
1 1.00238 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[53]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P0000@01Aol000010067o/0000400HOmOl6000010077b]<0_laC01Tog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000@021lZC0;o<D`0I?mnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@0000500PO:D`2oc5<06CoLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001@097bQ<0_laC01TogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H02AlWC0;o<D`0I?ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oalO00LO
9T`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol000040000
1P000om<7`087bE<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`02AlTC0;o<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWolag`03o`0000@000060004oda<C0TO8d`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C002C0TO8T`2oc5<06CoO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C003C0TO8D`2oc5<
06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<
C004C0TO84`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000om<C005C0TO7d`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo<Ml00ol0000400001P000om<C006C0TO7T`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C007C0TO7D`2oc5<06CoLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C008C0TO74`2oc5<
06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<
C009C0TO6d`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0
000400001P000om<C00:C0TO6T`2oc5<06CoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioo<Ml00ol0000400001P000om<C00;C0TO6D`2oc5<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00<C0TO64`2oc5<06CoO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P02o`i<2AlFC0Co;D`2o`0`
C?ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<77ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`Co;Ml2o`03gol000D000060003
oda<00U<00?oC4`00T`97`A<00?oC4`03d`2o`]<00?oC4`03d`00om<C00?C01TodcoO_Anm7kdO_An
m7koO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7koO_mOWenOGimOWenOGomOWenOGimO
WenOGimOWenOGomOWenOGimOWenOGimOWenOG`;o2ml00ooOg`0?g`03omoO00oO00?ogol01P0000H0
00?oC4`00T`2o`03C?oo009<00?oC4`00d`97`04oda<o`]<0ol3C0;o14`2o`03C?oo009<00?oC4`0
24`5o`9<00?oC4`02D`3o`=<00OoC?maOW5n00;o011aoomnLOmaOW5nLGiaOW5n1Ol03Giaog5nLGia
OW5nLGh00ol02giaOW7oLOmOWenO00;o011OoonOGomOWenOGimOWenO1Ol03ImOoenOGimOWenOGil0
1?l00enOG`02o`CO0_l00mooo`02g`03omoO00SO1Ol2g`03omoO00SO0ol4g`03omoo00H000060003
oda<009<00CoC4co14`00om<C003C0TO0d`00om<C009C003oda<009<0_l4C004oda<o`A<00?oC4`0
2D`00om<C003C003oda<00U<00?oC4`00T`0I?m<ogkdO_Com7koO_Anm?odO_Anm7kdO_Anm?odO_An
m?odO_Anm7kdO_Anm7koO_AnogkoGimOWonOGomOWenOoimOWenOGimOWenOoimOWenOoimOWenOGimO
WeooGimOWel2o`CO00Cogmoo1=l00ooOg`09g`03omoO00?O00?ogml02=l00ooOg`03g`03omoo00H0
000500;o14`01?m<C?l;C0TO34`4o`=<0_l4C004oda<oa1<00?oC4`03D`4o`A<0_l0<75nLGkoOW7o
LGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW7oLGiaOP;o02mOWenOoimOoenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGiooWenOG`02o`CO00Cogmoo4=l00ooOg`0>g`03omoO00CO
0_l600001P000om<C002C004oda<o`a<2Al;C003odco00A<0_l4C004oda<oa1<00?oC4`03D`00om<
o`04C00/odcoO_Anm?odO_mnm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7h2o`0fm7kdO_mn
oenOGiooWeooGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWeooGimO0_l4g`04omoOoa3O
00?ogml03]l00ooOg`03g`03omoo00H000060003oda<009<1?l=C0TO2T`00om<o`04C0;o14`4o`m<
0_l?C003odco00A<00OoC?maOW5n00Co00maOW5nLGiaOW5nLGiaOW400_l07GiaOW5nLGiaOW5nLGia
OW5nLOmaOW7oLOmOWenO00Co00mOWenOGimOWenOGimOWel00_l05YmOWenOGimOWenOGimOWonOGomO
Wel2o`CO1?l?g`;o4=l00ooOg`03g`03omoo00H0000600;o0d`00om<C00?C0TO2T`2o`=<1?l3C003
oda<029<0_l3C0;o02Y<ooodO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@3o`03
m7kd00;o02]noonOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o00>OGil0
1?l3g`03omoO027O0_l4g`;o00?Oo`001@0000H000CoC4a<0_lBC0TO3d`2o`=<0_lCC003oda<01I<
00CoLGia0_l0<7iaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOG`;o
02bOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOo`?O0_lCg`03omoO01KO
00?o0000100000H000?oC4`05T`97`i<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?oC4`05d`97`e<0_laC01Tog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`064`97`a<0_laC01TogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`06D`97`]<
0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H0
00?oC4`06T`97`Y<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`06d`97`U<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?oC4`074`97`Q<0_laC01TogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`07D`97`M<0_laC01Tog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`07T`97`I<
0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H0
00?oC4`07d`97`E<0_laC01Tog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`084`97`A<0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoc7O00?o0000100000H000?oC4`08D`97`=<0_laC01Tog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`08T`97`9<0_laC01TogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`08d`97`03
C?oo035<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol000040000
1P000om<C00TC0TO0_laC01TogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O
00?o0000100000H000?oC4`09D`97`03oda<02m<06CoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGioo<Ml00ol0000400001P000om<C00VC0TO<D`0I?mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWolag`03o`0000@000060003oda<02M<2Al`C01Tog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoc7O00?o0000100000H000?oC4`0:4`97bm<06CoO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo<Ml00ol0000400001P000om<C00YC0TO
;T`0I?maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWolag`03o`0000@0000602go
2Ao3o`H00006000^ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOPTO
02enLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000_
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02Al0;7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n2Al0:giaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000aooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`097`0ZO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5n0_l97`0YOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l00ghO7`077`0XO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0
;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`060000
1P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o00=aOQl0
21l09giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0aC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`03O_An00TO02Inm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o00AaOW5n2Al09GiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l01GkdO_An00TO02Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`06LGiaOW5n2Al08giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o035<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o00Mnm7kdO_An00TO029nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooO
g`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0275n
LGiaOW5n2Al08GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0aC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`09O_Anm7kdO_An00TO
021nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o00YaOW5nLGiaOW5n2Al07giaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l02gkdO_Anm7kdO_An00TO01inm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0<LGiaOW5nLGiaOW5n2Al07GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o035<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o00enm7kdO_Anm7kdO_An00TO01anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooO
g`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l03W5n
LGiaOW5nLGiaOW5n2Al06giaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0aC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0?O_Anm7kdO_Anm7kd
O_An00TO01Ynm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc5<00?ogml0;]l0<onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P02o`0]LGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00Co00mnLGiaOW5nLGiaOW5nLGh02Al05Gia
OW5nLGiaOW5nLGiaOW5nLGiaOP02o`03LOoo02e<0_l00dcoo`0]g`Co02eOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l00ioo000500001P00<?odO_Anm7kdO_Anm?od
O_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm0;o015nm7kdO_Anm7kdO_mnm7kdOP097`0H
O_AnogkdO_Anm7kdO_Anm7kdO_Anogko2d`00om<C00?C003oda<00m<00?oC?l02ml00ooOg`0?g`03
omoO00oO0_l0<YmOWenOGimOWenOoimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOoioo
1P0000H000GoOW5nL@02o`0@O_ooLGkoOW5nLGiaOW5nL@Go00eaO_mnLGiaOW5nLGia00?o00AaOW5n
0_l0175nLGh2o`0<LOooOW7oLGiaOW5n2Al03Giaog5nLGiaOW5nLGh00ol01giaOW7oLOl014`2o`03
C?oo009<00?oC4`024`5o`9<00?oC4`02D`3o`=<00?oC?l01=l2o`03gooo00;O00?ogml02=l5o`;O
00?ogml02=l3o`CO0_l019mOWel2o`0@WoooGiooWenOGimOWenOG`Go00eOWonOGimOWenOGimO00Co
00JOGiooWol600001P00<?odO_AnogkdooAnm7koO_Anm7kdO_Anm7koO_Anm7koO_Anm7kdO_Anm7kd
ooAnm0;o01=nm7kdooAnogkdO_Com7kdO_An00TO01Inm?odO_Anm7kdO_Anm7koO_Anogko14`01?m<
C?l4C003oda<00U<00?oC4`00d`00om<C009C003oda<009<00?oC?l01=l01?oOgol4g`03omoO00WO
00?ogml00ml00ooOg`08g`03omoO00?O0_l0<YmOWeooGiooWenOGomOWenOGimOWenOGomOWenOGomO
WenOGimOWenOoimOWenOoioo1P0000D00_l0;giaOW7oLGkoOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGia
OW5nLGiaOW5nLGkoOW5n00;o01AaOW5nogiaog5nLGiaOW5nLGiaOPTO01=nLGiaOW5nLGiaOW5nLOma
OW5n00;o14`01?m<C?l@C003oda<00e<1?l4C0;o1=l01?oOgol@g`03omoO00kO00?ogml00ml2o`0`
WenOGomOWonOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOoenOGimO0_l600001P00:_od
O_AnogkdooAnm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm0;o00Anm7kd0_l05GkdO_Com7ko
O_Anm7kdO_Anm7kdOP097`0;O_Anm7kdO_Anm7h00_l01oAnm7koO_l014`01?m<C?l@C003oda<00e<
00?oC?l014`00om<o`04g`04omoOoa3O00?ogml03]l00ooOg`03g`;o03:OGimOoenOoimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOoimOWonOo`H000060005ogiaOW401?l03giaOW5nLGia
OW5nLGiaOP02o`0FLGiaOW5nLGiaOW5nLGiaOW5nogiaOP;o00AaOW5n1?l03W5nLGiaOW5nLGiaOW5n
2Al04giaOW5nLGiaOW5nLOmaOW7oLOl014`4o`m<0_l?C003odco00A<00?oC?l01=l4o`oO0_l@g`03
omoO00?O0_l019mOWel4o`0?WenOGimOWenOGimOWenO00;o01UOWenOGimOWenOGimOWeooGiooWenO
oioo00H0000600;o02Mnm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00ol00gkd
OP04o`0Fm7kdooAnm7kdO_Anm7kdO_Anm7kdOPTO00Qnm7kdO_Anm0?o00?dO_@00_l00gkoo`03C003
oda<029<0_l3C0;o00=<ool00ml00ooOg`0Qg`;o1=l4o`0XGimOoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o00=OWel00_l00ioo000500001P001?mnLGh2o`0ZLGiaOW5nLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l00g5nL@02o`0COW5nLGiaOW5nLGiaOW5nLGia
OP097`0AOW5nLGiaOW5nLGiaOW5nLOl00d`2oa=<00?oC4`05T`01?oOgml2oa?O00?ogml05Ml01?nO
Gil2o`0]GimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l06GkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h02Al047kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0JLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh97`0?OW5nLGiaOW5nLGiaOW7o035<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01]nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h0
2Al03WkdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l0775nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh97`0=OW5nLGia
OW5nLGiao`0aC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0MO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02Al037kdO_Anm7kdO_Anoc5<
00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01iaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh97`0;OW5nLGiaOW5nLOl0<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02Al02WkdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0PLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh97`09OW5nLGiaOW7o035<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o025nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7h02Al027kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l08W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh97`07
OW5nLGiao`0aC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0SO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02Al01WkdO_Anoc5<
00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
02AaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh97`05OW5nLOl0<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l09GkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02Al017kdO_laC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0VLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh97`03OW7o035<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o02Mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7h02Al00gkoC00`C003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0XLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOPTO00?oC4`0;d`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_l0:GkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00TO
<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l0:W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOPTO<4`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0:gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02Al_C003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0/LGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh97bi<00?ogml0;]l0<onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0600001P1Oo`TOTOl600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o;]l97`0]WenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oboO2Al0;5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<=l97`0[WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`TO
02YOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol`C00cooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`03oalO00LO02VOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0`C00cogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00H00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_lag`03oelO00PO02QOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml00omOW`097`0WWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
1P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O
00CoGimO2Al09UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml01OmOWenO00TO02FOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O00KoGimOWel97`0TGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml01omOWenOGil02Al08imOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
1P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O
00SoGimOWenOG`TO029OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml02OmOWenOGimOW`097`0Q
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O00[oGimOWenOGimO2Al085nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml02omOWenOGimOWenO00TO01nOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
1P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O
00coGimOWenOGimOWel97`0NGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml03OmOWenOGimOWenOGil0
2Al07ImOWenOGimOWenOGimOWenOGimOWenOGimOWeoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O00koGimOWenOGimOWenOG`TO01aOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o<Ml03omOWenOGimOWenOGimOW`097`0KWenOGimOWenOGimOWenOGimOWenOGimO
Weoo031<03?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
1P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O
013oGimOWenOGimOWenOGimO2Al06UnOGimOWenOGimOWenOGimOWenOGimOWeoo<4`0<oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0600001P02o`0]GimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00Co;Ml2o`0BgoooWenOGimOWenO
GimOWenO2Al05ImOWenOGimOWenOGimOWenOGimOW`02o`03Gooo02e<1?l0;G5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`03O_l000D00006000`oimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenO0_l;g`03omoO00oO00?ogml03ml05?oO
oenOGimOWenOGimOoenOGimO2Al065nOGomOWenOGimOWenOGimOWenOGomOo`]<00?oC4`03d`00om<
C00?C0;o03;dO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm?odo`H0
00060005oimOWel00_l049oooenOoimOWenOGimOWel5o`0=GiooWenOGimOWenOG`04o`03WenO00;o
1=l2o`03gooo00;O00?ogml02=l5o`;O00?ogml02=l3o`CO00OogomOWenO00;o00aOoonOGomOWenO
Gil97`0=WeooGimOWenOGimOW`04o`06GimOoeoo14`2o`03C?oo009<00?oC4`024`5o`9<00?oC4`0
2D`3o`=<0_l017iaOW42o`0@O_ooLGkoOW5nLGiaOW5nL@Go00eaO_mnLGiaOW5nLGia00?o00MaOW5n
ogko00H00006000`oimOWeooGiooWenOGomOWenOGimOWenOGomOWenOGomOWenOGimOWenOoimOWenO
0_l4g`04omoOo`CO00?ogml02Ml00ooOg`03g`03omoO00SO00?ogml00ml05_oOoenOGiooWeooGimO
WonOGimOWel97`0FGiooWenOGimOWenOGomOWenOGomOo`A<00CoC4co14`00om<C009C003oda<00=<
00?oC4`02D`00om<C002C0;o03;dO_AnogkdooAnm7koO_Anm7kdO_Anm7koO_Anm7koO_Anm7kdO_An
m7kdooAnm?odo`H0000500;o02nOGimOoenOoimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WeooGimOW`02o`CO00Cogmoo4=l00ooOg`0>g`03omoO00CO0_l055nOGiooWeooGimOWenOGimOWenO
2Al04imOWenOGimOWenOGiooWenOGil00_l4C004oda<oa1<00?oC4`03D`4o`=<0_l0<7iaOW7oLGko
OW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGkoOW5nL@;o1P0000H0033oWenOGomOWonO
GimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWonOGil2o`CO00Cogmoo4=l00ooOg`0>g`03
omoO00?O01SogomOWenOoimOoenOGimOWenOGimOWel97`0DGimOWenOGimOWenOGomOWeooGol4C004
oda<oa1<00?oC4`03D`00om<o`04C0;o02WdO_AnogkdooAnm7kdO_Anm7kdO_Anm7koO_Anm7kdO_An
m7kdO_Anm002o`07O_Anm?odo`0600001P001OnOGimO00Co00nOGimOWenOGimOWenOGil00_l05UnO
GimOWenOGimOWenOGomOWonOGil2o`CO1?l?g`;o4=l00ooOg`03g`07omooGimOW`04o`0>GimOWenO
GimOWenOGil97`0CWenOGimOWenOoimOoenOGomOo`04C0Co3d`2o`m<00?oC?l014`2o`04OW5nL@Co
00mnLGiaOW5nLGiaOW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaO_mnLGkoO_l01P0000H00_l0:5nO
GomOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`03GimO00Co0ml00ooOg`0Qg`;o
1=l2o`0IgoooWenOoimOWenOGimOWenOGimOWenOG`097`09GimOWenOGimO00;o00>OGil00_l00eoo
o`03C003oda<029<0_l3C0Co02Mnm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h0
0ol00gkdOP02o`03m?l000D000060004oimOW`;o02YOWenOGimOWenOGimOWenOGimOoenOGimOWenO
GimOWenOGimOWenOGil2o`?O0_lCg`03omoO01KO00CoGimO0_l04imOWenOGimOWenOGimOWenOGil0
2Al04ImOWenOGimOWenOGimOWeoo00=<0_lCC003oda<01E<00CoOW5n0_l0;G5nLGiaOW5nLGiaOW5n
LGiaOW7oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml06_mOWenOGimOWenOGimOWenOGimOWenOGimO
2Al045nOGimOWenOGimOWenOGol`C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0KoenOGimOWenOGimOWenOGimOWenOGimOWenO00TO00nOGimOWenOGimO
WenOGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
<Ml07?mOWenOGimOWenOGimOWenOGimOWenOGimOWel97`0>GimOWenOGimOWenOGol`C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil02Al03ImOWenOGimOWenOGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml07_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOG`TO00aOWenOGimOWenOGol`C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`097`0;WenOGimO
WenOGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
<Ml08?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO2Al02UnOGimOWenOGol`C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0QoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenO00TO00VOGimOWenOGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml08_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWel97`08GimOWenOGol`C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0SoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil02Al01imO
WenOGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
<Ml09?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`TO00IOWenOGol`C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_lag`0UoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOW`097`05WenOGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0600001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o<Ml09_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimO2Al015nOGol`C00cooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00H00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_lag`0WoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO00TO
00>OGol0<4`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
<Ml0:?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel97`03Gom<02m<03?om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O02WoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`097`03oda<02i<03?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l01P0000H0033oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2oc7O02[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWel97c1<03?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l01P0000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGil2oc7O02_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00TO;d`0<omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0600001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
<Ml0;?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO2Al^C00cooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00H00006093o2AmPo`H0
00060003omoO02gO0_l0GenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00TO;=l00om<
C00_C003o`0000@000060003omoO02gO0_l0H5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOPTO:ml00om<C00_C003o`0000@000060003omoO02gO0_l0HEnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h02AlZg`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1RGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh97bWO00?oC4`0;d`00ol0000400001P000ooO
g`0]g`;o06=OWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h02AlXg`03oda<02m<
00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiao`TO9ml00om<C00_C003o`0000@000060003omoO02gO0_l0IEnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_oO00TO9]l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl2g`TO9Ml00om<C00_C003o`0000@0
00060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l3g`TO
9=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOl4g`TO8ml00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l5g`TO8]l00om<C00_C003o`0000@000060003
omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl6g`TO8Ml00om<
C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_l7g`TO8=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl8g`TO7ml00om<C00_C003o`0000@000060003omoO02gO
0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l9g`TO7]l00om<C00_C003
o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl:g`TO7Ml00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_l;g`TO7=l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl<g`TO6ml00om<C00_C003o`0000@0
00060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l=g`TO
6]l00om<C00_C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOl>g`TO6Ml00om<C00_C003o`0000@0000600;o;Ml4o`0]WenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o031OooodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`03O_oo00kO2AlFg`Co;D`2o`03C?l000D000060003
omoO00WO00?ogml03ml00ooOg`0?g`;o06AOWenOGimOWenOGomOWenOGimOWenOGimOWenOGomOWenO
GimOWenOGimOWenOGomOog5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5n
LGiaog7o2ml00ooOg`02g`TO1=l00ooOg`0?g`;o2d`00om<C00?C003oda<00m<00?oC?l01P0000H0
00?ogml00]l2o`03gooo00;O00?ogml02=l5o`;O00?ogml02=l3o`CO0_l015nOGil2o`0@GoooWeoo
GimOWenOGimOW`Go00fOGomOWenOGimOWenO00Co00YOWeooGomnm7kd0_l047koooAnogkdO_Anm7kd
O_@5o`0=m7koO_Anm7kdO_Anm003o`07m7kdO_mno`04g`;o00?Oool00]l00ooOg`03g`TO00Cogmoo
2]l3o`CO0_l4C0;o00=<ool00T`00om<C008C0Go0T`00om<C009C0?o0d`00om<o`0600001P000ooO
g`02g`04omoOo`CO00?ogml02Ml00ooOg`03g`03omoO00SO00?ogml00ml2o`1TGimOWonOGomOWenO
oimOWenOGimOWenOoimOWenOoimOWenOGimOWeooGimOWeooGomaOW5nogiaog5nLGkoOW5nLGiaOW5n
LGkoOW5nLGkoOW5nLGiaOW5nLGiaog5nLOmao`CO00Cogmoo1=l00ooOg`03g`TO0ml00ooOg`08g`03
omoO00?O0_l4C004oda<o`A<00?oC4`02D`00om<C003C003oda<00U<00?oC4`00T`00om<o`060000
1@02o`CO00Cogmoo4=l00ooOg`0>g`03omoO00?O0_l0<5nOGiooWeooGimOWenOGimOWenOGimOWonO
GimOWenOGimOWenOGimOWonOGimOW`;o031nm7kdooAnogkdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kd
O_Anm7kdO_AnogkdO_@2o`CO00Cogmoo2ml97`gO00?ogml00ml2o`A<00CoC4co44`00om<C00=C0Co
14`2o`H000060003omoO00;O00Cogmoo4=l00ooOg`0>g`03omoO00?O0_l0FenOGiooWeooGimOWenO
GimOWenOGimOWonOGimOWenOGimOWenOGimOWeooGimOoeooLGiaO_mnLOmaOW5nLGiaOW5nLGiaOW5n
ogiaOW5nLGiaOW5nLGiaOW400_l01giaOW7oLOl01=l01?oOgol<g`TO3=l00ooOg`03g`;o14`01?m<
C?l@C003oda<00e<00?oC?l014`00om<o`0600001P000ooOg`02g`Co3ml2oa3O00?ogml00ml2o`04
GimOW`Co00mOWenOGimOWenOGimOWel00_l07ImOWenOGimOWenOGimOWonOGomOWeooGomnm7kd00Co
00mnm7kdO_Anm7kdO_Anm7h00_l06OAnm7kdO_Anm7kdO_Anm7kdO_mnm7koO_l01=l4o`gO2Al;g`03
omoO00?O0_l4C0Co3d`2o`m<00?oC?l014`00om<o`0600001P02o`?O00?ogml08Ml2o`CO1?l0:9mO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel2o`03WenO00;o02YOoomnLGkoOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh3o`03OW5n00;o00=aool00ml00ooOg`0?g`TO
2Ml2o`CO1?l3C003oda<029<0_l3C0;o00=<o`001@0000H000CogmoO0_lCg`03omoO01CO0_l00enO
G`02o`0`WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWeooO_An0_l0;OAn
m7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`03g`;o4]l97a3O00CoC4a<
0_lCC003oda<01I<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaSO2Al?g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaWO2Al>g`03oda<02m<00?o0000100000H0
00?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa[O2Al=g`03
oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa_O2Al<g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoacO2Al;g`03oda<02m<00?o0000100000H000?ogml0
;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO2Al:g`03oda<02m<
00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoakO2Al9g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaoO2Al8g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1T
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaob3O2Al7g`03oda<02m<00?o0000
100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anob7O
2Al6g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaob;O2Al5g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anob?O2Al4g`03oda<02m<00?o0000100000H0
00?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaobCO2Al3g`03
oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnobGO2Al2g`03oda<02m<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaobKO2Al00mooC00`C003o`0000@000060003omoO02gO
0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lWg`TO00?oC4`0;d`00ol0
000400001P000ooOg`0]g`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
:=l97c5<00?o0000100000H000?ogml0;Ml2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnobWO2Al`C003o`0000@000060003omoO02gO0_l0I5nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlZg`TO;d`00ol0000400001P000ooOg`0]g`;o06AOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko:ml97bi<00?o0000100000D0`ol97bko1P0000D0
a?l97bgo1P0000H000?o0000;@02oc7O067oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00TO:d`00ol0000400001P000ol0000/00?o<Ml0H_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_An2AlZC003o`0000@000060003o`0002/000Co0?oo<Ml0HomOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP097bU<00?o0000100000H000?o0000:P000ol00002oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2AlXC003o`0000@000060003
o`0002T000Co00000_lag`1UoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nod`0
2AlWC003o`0000@000060003o`0002P000?o00000P02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co0T`97bI<00?o0000100000H000?o00009`000ol0000300;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l3C0TO9D`00ol0000400001P000ol0
000V0003o`0000@00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`A<
2AlTC003o`0000@000060003o`0002D000?o00001@02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko1D`97b=<00?o0000100000H000?o000090000ol0000600;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l6C0TO8T`00ol0000400001P000ol0
000S0003o`0000L00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`M<
2AlQC003o`0000@000060003o`00028000?o00002002oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co24`97b1<00?o0000100000H000?o00002`02o`030?oo014000?o0000
2@02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2D`97am<00?o0000
100000H000?o000030000ol0o`0A0003o`0000X00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdo`Y<2AlNC003o`0000@000060003o`0000d000?o00003`000ol0000;00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l;C0TO7D`00ol000040000
1P000ol0000<0003o`3o00l000?o00003002oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co34`97aa<00?o0000100000H000?o00002`02o`030?oo00d000?o00003@02oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko3D`97a]<00?o0000100000H0
00?o000070000ol0000>00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l>C0TO6T`00ol0000400001P000ol0000K0003o`0000l00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5no`m<2AlIC003o`0000@000060003o`0001X000?o00004003obgO
0_l0<=oooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o031Ooood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@4o`m<2AlEC0;o00=<o`00
1@0000H000?o00006@000ol0000A00;o2ml00ooOg`0?g`03omoO00oO06CogomOWenOGimOWenOGomO
WenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGomOog5nLGiaOW5nLGiaog5nLGiaOW5nLGia
OW5nLGiaog5nLGiaOW5nLGiaOW5nLGia0_l;C003oda<00=<2Al3C003oda<00m<00?oC?l01P0000H0
00?o000060000ol0000B00;o1=l2o`03gooo00;O00?ogml02=l5o`;O00?ogml02=l3o`CO00OogomO
WenO00;o011OoonOGomOWenOGimOWenO1Ol03ImOoenOGimOWenOGil01?l02UnOGomOogkdO_@2o`0@
O_oom7koO_Anm7kdO_Anm0Go00gdO_mnm7kdO_Anm7kd00?o00CdO_An0_l4C0;o00=<ool00T`00om<
C004C0TO0T`00om<C009C0?o0d`00om<o`0600001P000ol0000G0003o`0001<00_l4g`04omoOo`CO
00?ogml02Ml00ooOg`03g`03omoO00SO00?ogml00ml0I?oOoenOGiooWeooGimOWonOGimOWenOGimO
WonOGimOWonOGimOWenOGimOoenOGimOoeooLGiaO_mnLOmaOW5nogiaOW5nLGiaOW5nogiaOW5nogia
OW5nLGiaOW5nLOmaOW42o`A<00CoC4co14`00om<C004C0TO0T`00om<C009C003oda<009<00?oC?l0
1P0000H000?o00005P000ol0000D00;o1=l01?oOgol@g`03omoO00kO00?ogml01=l2o`0`GimOWonO
GomOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOoimOWenO0_l0;gkdO_Com7koO_Anm7kd
O_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7koO_An00;o14`01?m<C?l<C0TO2d`4o`A<0_l60000
1P000ol0000E0003o`0001D00_l4g`04omoOoa3O00?ogml03]l00ooOg`03g`1NomooGimOWonOGomO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGomOWeooGomaOW5nogiaog5nLGiaOW5nLGia
OW5nLGkoOW5nLGiaOW5nLGiaOW5nL@;o00AnLGia0_l4C004oda<o`e<2Al:C003odco00A<00?oC?l0
1P0000H000?o000050000ol0000F00;o1=l4o`oO0_l@g`03omoO00?O00OogomOWenO00Co00mOWenO
GimOWenOGimOWel00_l07ImOWenOGimOWenOGimOWonOGomOWeooGomnm7kd00Co00mnm7kdO_Anm7kd
O_Anm7h00_l05_Anm7kdO_Anm7kdO_Anm7kdO_mnm7h2o`A<1?l>C0TO2D`00om<o`04C003odco00H0
00060003o`0001<000?o00005`03o`?O00?ogml08Ml2o`CO0_l0:moooimOWonOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l00imOW`02o`0ZGoooOW5nogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0ol00giaOP04o`=<00?oC4`044`97`U<0_l3C0;o00=<o`001@0000H0
00?o00004P000ol0000H00;o0ml2oa?O00?ogml05]l01?mOWel2o`0`WenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWeooO_An0_l0;?Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co0d`2oa=<2Al@C003o`0000@000060003o`00014000?o00006@02oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko6D`97`m<00?o0000100000H0
00?o000040000ol0000<00?o2`02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co6T`97`i<00?o0000100000H000?o00003`000ol0000>0003o`0000X00_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noa]<2Al=C003o`0000@000060003o`0000h0
00?o000040000ol0000900;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lLC0TO34`00ol0000400001P000ol0000=0003o`00014000?o00002@02oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko7D`97`]<00?o0000100000H000?o000030000ol0
000A0003o`3o00X00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoai<
2Al:C003o`0000@000060003o`0000/000?o00004P000ol0o`0:00;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lOC0TO2D`00ol0000400001P000ol0000:0003o`000180
0_l00`3oo`0900;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lPC0TO
24`00ol0000400001P000ol000090003o`0002400_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nob5<2Al7C003o`0000@000060003o`0000P000?o00008P02oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8T`97`I<00?o0000100000H000?o0000
1`000ol0000S00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC0TO
1D`00ol0000400001P000ol000060003o`0002@00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdobA<2Al4C003o`0000@000060003o`0000D000?o00009@02oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko9D`97`=<00?o0000100000H000?o0000
10000ol0000V00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lVC0TO
0T`00ol0000400001P000ol000030003o`0002L00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nobM<2Al00dco000500001P000ol000020003o`0002P00_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdobQ<2Al00ol0000400001P001Ol0003o02/0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nobU<2Al600001P001?l0
0?l/00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lZC0TO1@0000H0
00?o0?l0;@02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko:d`97`@0
000600;o;P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co;4`97`<0
00060?Co2Al20000=P02ol<02Al10000o0097`00o@087`00oP077`00o`067`00o`0100DO003o0080
11l00?l00`037`00o`060000o`060000o`060000o`060000o`060000o`060000o`060000o`060000
o`060000o`060000o`060000o`060000mP03o``0003g0003o`0000/0003N00;o00<0ool02@000ol0
o`090003o`0000X0003O0003o`3o00/000?o000020000ol0000:0000h0000ol0000800Go1`000ol0
o`0;0000g`000ol0o`0;0003o`0000L000?o0?l02`000=h00_l00`3oo`0C00;o00<0ool02P000?l0
1P000?l01P000?l01P000?l01P000001\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{a, a**b, b, a\^b}, {b, a, a\^b, a**b}, {a**b, a\^b, b, a}, {a\^b, 
        a**b, a, b}}\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "As with many of the functions in these packages, multiple inputs are \
permissible. Here, the argument for ",
  StyleBox["Z", "MR"],
  " is the list {3, 4}, which in turn, after evaluation, becomes a list of \
two groupoids for ",
  StyleBox["CayleyTable", "MR"],
  "."
}], "MathCaption",
  CellTags->{"Cayley", "i:31"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[Z[{3, \ 4}], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(1)] .61905 .62202 0 0 Mshowa
[(2)] .85714 .62202 0 0 Mshowa
[(1)] .38095 .38393 0 0 Mshowa
[(2)] .61905 .38393 0 0 Mshowa
[(0)] .85714 .38393 0 0 Mshowa
[(2)] .38095 .14583 0 0 Mshowa
[(0)] .61905 .14583 0 0 Mshowa
[(1)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(1)] .14286 .38393 0 0 Mshowa
[(2)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(1)] .61905 .86012 0 0 Mshowa
[(2)] .85714 .86012 0 0 Mshowa
[(Z[3])] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(0)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(2)] .69048 .69286 0 0 Mshowa
[(3)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(2)] .5 .50238 0 0 Mshowa
[(3)] .69048 .50238 0 0 Mshowa
[(0)] .88095 .50238 0 0 Mshowa
[(2)] .30952 .3119 0 0 Mshowa
[(3)] .5 .3119 0 0 Mshowa
[(0)] .69048 .3119 0 0 Mshowa
[(1)] .88095 .3119 0 0 Mshowa
[(3)] .30952 .12143 0 0 Mshowa
[(0)] .5 .12143 0 0 Mshowa
[(1)] .69048 .12143 0 0 Mshowa
[(2)] .88095 .12143 0 0 Mshowa
[(0)] .11905 .69286 0 0 Mshowa
[(1)] .11905 .50238 0 0 Mshowa
[(2)] .11905 .3119 0 0 Mshowa
[(3)] .11905 .12143 0 0 Mshowa
[(0)] .30952 .88333 0 0 Mshowa
[(1)] .5 .88333 0 0 Mshowa
[(2)] .69048 .88333 0 0 Mshowa
[(3)] .88095 .88333 0 0 Mshowa
[(Z[4])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[54]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?nJ00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo09X0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
4`1lo`/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`000om<
C00DC0;o64`00ooOg`0Fg`0boenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<0
00?oC4`054`2oaQ<00?ogml05]l0<_mOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C0003oda<01A<0_lHC003omoO01KO03;oGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol04`000om<C00DC0;o64`00ooOg`0Fg`0boenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo01<000?oC4`054`2oaQ<00?ogml05]l0<_mOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0C0003oda<01A<0_lHC003omoO01KO03;oGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol04`000om<C00DC0;o64`00ooOg`0Fg`0boenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo01<000?oC4`054`2oaQ<00?ogml05]l0<_mOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2`0000X001koOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0C0003oda<01A<0_lHC003omoO01KO03;oGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000NooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`000om<C007C0?o2T`2o`Y<0ol;C003omoO00SO
0_l<g`0:oenOGimOWenOG`?o01IOWenOGimOWenOGomnm7kdO_Anm7kd1?l02gkdO_Anm7kdO_Co00/0
000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`000om<C00:C003
oda<00M<0_l=C003oda<00Q<00?ogml01ml01?oOgol;g`0boenOGimOWenOGiooWenOGimOWenOGimO
og5nLGiaOW5nLGiaog5nLGiaOW5nLGiaO_l;00002P003OodO_Anm7kdO_Anm7h01?l03OAnm7kdO_An
m7kdO_@00_l037kdO_Anm7kdO_Anm0Co00mnm7kdO_Anm7kdO_Anm?l03Ml2o`oO00goGimOWenOGimO
WenO00?o00nOGimOWenOGimOWenOGol04`000om<C00:C003oda<00M<0_l=C003oda<00Q<00?ogml0
1ml01?oOgol;g`0boenOGimOWenOGiooWenOGimOWenOGimOogkdO_Anm7kdO_Anm?odO_Anm7kdO_An
m?l;00002P007_mnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaog5n
LGiaOW5nLGiaOW5nLGko00cO00Cogmoo3]l07omOWenOGimOWenOGimOoenOGimOWenOGimOWenOGol0
4`000om<C008C0;o2T`2o`]<0_l;C003omoO00OO00Cogmoo2ml0<_mOWenOGimOWenOoimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGko2`0000X001kom7kdO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdo`0<g`04omoOo`kO01ooGimO
WenOGimOWenOGomOWenOGimOWenOGimOWeoo01<000?oC4`02T`00om<C007C0;o3D`00om<C008C003
omoO00OO00Cogmoo2ml0<_mOWenOGimOWenOoimOWenOGimOWenOGomnm7kdO_Anm7kdooAnogkdO_An
m7kdO_Co2`0000X001koOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5n
LGiaog5nLGiaOW5nLGiaOW5no`0<g`04omoOo`kO01ooGimOWenOGimOWenOGomOWenOGimOWenOGimO
Weoo01<000?oC4`01d`3o`Y<0_l:C0?o2d`00ooOg`08g`;o3=l02_mOWenOGimOWel2o`0HWenOGimO
WenOGimOog5nLGiaOW5nLGia0_l037iaOW5nLGiaOW5no`/0000:000NooAnm7kdO_Anm7kdO_mnm?od
O_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kdO_Anm?l03=l01?oOgol>g`0O
oenOGimOWenOGimOWeooGimOWenOGimOWenOGimOo`0C0003oda<01A<0_lHC003omoO01KO03;oGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`/0000:000>ogiaOW5n
LGiaOW5nLGh2o`0>LGiaOW5nLGiaOW5nLGh2o`0=LGiaOW5nLGiaOW5nL@02o`0@OW5nLGiaOW5nLGia
OW5no`gO0_l?g`0=oenOGimOWenOGimOW`02o`0@GimOWenOGimOWenOGimOoa<000?oC4`054`2oaQ<
00?ogml05]l0<_mOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
2`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C0003oda<01A<
0_lHC003omoO01KO03;oGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`000om<
C00DC0;o64`00ooOg`0Fg`0boenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<0
00?oC4`054`2oaQ<00?ogml05]l0<_mOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C0003oda<01A<0_lHC003omoO01KO03;oGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol04`000om<C00DC0;o64`00ooOg`0Fg`0boenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo01<000?oC4`054`2oaQ<00?ogml05]l0<_mOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0C0003oda<01A<0_lHC003omoO01KO03;oGimOWenOGimOWenOGimOWenOGimO
WeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol04`1lo`/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001koOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Gog5nLGiaOW5nLGiaOW5nLGia
OW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimO
WenOGimOWenOGimOWol;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<001OoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:07co4`005omaOW5nLGia
OW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml06_mO
WenOGimOWenOGimOWenOGimOWenOGioo2`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lMg`03o`00014001OoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000Gog5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimO
WenOGimOWenOGimOWenOGimOWol;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoagO00?o00004@005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001OoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003omoO01GO01[oGimOWenOGimO
WenOGimOWenOGimOWenOo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
7Ml00ol0000A000GogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P007_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@002_maOW5nLGiaOW44o`09OW5nLGia
OW5n00;o00YaOW5nLGiaOW5n1?l02g5nLGiaOW5nLGko00U<0ol<C003omoO00SO0_l;g`0;oenOGimO
WenOGil00ol039mOWenOGimOWenOo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko7Ml00ol0000A000GogkdO_Anm7kdO_Com7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anogkd
O_Anm7kdO_Anm?l034`00om<C009C003omoO00OO00Cogmoo2]l06_mOWenOGimOWenOGomOWenOGimO
WenOGioo2`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`000140
01OoLGiaOW5nLGiaOW7oLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nogiaOW5nLGiaOW5no`0<C003
oda<00U<00?ogml01ml01?oOgol:g`0JoenOGimOWenOGimOoenOGimOWenOGimOWol;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@005omnm7kdO_Anm7kdO_Co
m7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Co00Y<0_l<C003omoO00OO00Cogmoo
2]l06_mOWenOGimOWenOGomOWenOGimOWenOGioo2`0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlMg`03o`00014001OoLGiaOW5nLGiaog5nogiaOW5nLGiaOP02o`0ILGiaOW5n
LGiaO_mnLOmaOW5nLGiaOW5no`0<C003oda<00U<00?ogml01ml01?oOgol:g`0JoenOGimOWenOGimO
oenOGimOWenOGimOWol;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO
00?o00004@002omnm7kdO_Anm7kd00;o00Ynm7kdO_Anm7kd0_l02gkdO_Anm7kdO_An00;o00cdO_An
m7kdO_Anm?l9C0?o34`00ooOg`08g`;o2ml02omOWenOGimOWenO00;o00eOWenOGimOWenOGioo00/0
000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000Gog5nLGia
OW5nLGiaOW5nLGiaOW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0J
oenOGimOWenOGimOWenOGimOWenOGimOWol;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoagO00?o00004@005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X0
00goWenOGimOWenOGimO00?o00iOWenOGimOWenOGimOW`;o00aOWenOGimOWenOGil3o`0LWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nL@Co00mnLGiaOW5nLGiaOW5nLOl03Ml2o`kO00?o00004@005oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml0
5Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001koWenOGimOWenOGimOWonOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Com7kd
O_Anm7kdO_Anm7kdO_l<g`04omoOo`gO00?o00004@005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o
01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimO
WenOGioo2`0000X001koWenOGimOWenOGimOWonOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenO
GomOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLOl<g`04omoOo`gO
00?o00004@005omaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001koWenOGimOWenO
GimOWonOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_l<g`04omoOo`gO00?o00004@005omnm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimO
WenOGimOWenOGimOWenOGioo2`0000X001koWenOGimOWenOGimOWonOGimOWenOGimOWenOGil2o`0n
GimOWenOGimOWenOGomOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLOmaO_mnLGiaOW5nLGiaOW5n
LOl<g`04omoOo`gO00?o00004@005omaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X0
00goWenOGimOWenOGimO00;o00nOGimOWenOGimOWenOGil00_l035nOGimOWenOGimOW`;o01iOWenO
GimOWenOGimOWenOooAnm7kdO_Anm7kdO_@2o`0@O_Anm7kdO_Anm7kdO_Ano`gO0_l>g`03o`000140
01OoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003
omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000NoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A07co2`0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lMg`03o`00014001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o0000
2@0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001OoGimO
WenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lMg`03o`00014001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o0000
2@0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001OoGimO
WenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lMg`03o`00014001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o0000
2@0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001OoGimO
WenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lMg`03o`00014001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o0000
2@0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001OoGimO
WenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X001koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lMg`03o`00014001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o0000
2@0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`0nGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlMg`03o`00014001OoGimO
WenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X0O?lC000:oenOGimOWenOG`?o00YOWenO
GimOWenO0_l02UnOGimOWenOGil3o`0EWenOGimOWenOGioom7kdO_Anm7kd00Co00anm7kdO_Anm7kd
O_l9C0?o2d`00ooOg`09g`;o2ml00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`005omOWenOGimO
WenOoimOWenOGimOWenO00;o039OWenOGimOWenOGomOWenOGimOWenOGiooOW5nLGiaOW5nLOmaOW5n
LGiaOW5nLGiao`a<00?oC4`024`00ooOg`08g`04omoOo`[O00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoa<001OoGimOWenOGimOWonOGimOWenOGimOW`02o`0bGimOWenOGimOWeooGimOWenOGimOWenO
ooAnm7kdO_Anm7kdooAnm7kdO_Anm7kdO_l<C003oda<00Q<00?ogml02=l01?oOgol:g`03o`0000T0
000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlC000GoenOGimOWenOGiooWenOGimOWenOGil00_l0<UnOGimOWenO
GimOoenOGimOWenOGimOWomnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW7o2T`2o`]<00?ogml02=l01?oO
gol:g`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC000GoenOGimOWenOGiooWenOGimOWenOGil0
0_l0<UnOGimOWenOGimOoenOGimOWenOGimOWoodO_Anm7kdO_Com7koO_Anm7kdO_Anm7ko34`00om<
C008C003omoO00SO00Cogmoo2]l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`002_mOWenOGimO
Wel2o`0;WenOGimOWenOGil00_l02UnOGimOWenOGil2o`0GGimOWenOGimOWenOogiaOW5nLGiaOW40
0_l03GiaOW5nLGiaOW5nLOl02D`3o`]<00?ogml02Ml2o`_O00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC003omoO01KO00?o00002@0000X000?ogml06ml2oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0bGimOWenOGimOWenOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGC003omoO01KO00?o00002@0000X000?ogml02ml2o`kO
0_l=g`;o3ml03OnOGimOWenOGimOWel00ol075nOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_@4o`0>
O_Anm7kdO_Anm7kdO_lC07co2`0000X000?ogml02]l01?oOgol=g`;o3=l01?oOgol>g`0noimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLOlC0003
omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlHC003o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l0?_nOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7ko4`000ooOg`0Dg`;o
6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0
000900002P000ooOg`0:g`04omoOo`gO0_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaoa<000?ogml05=l2oaSO03;oWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X0
00?ogml02]l01?oOgol=g`;o3=l01?oOgol>g`0noimOWenOGimOWenOGiooWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Com7koO_Anm7kdO_Anm7kdO_lC0003omoO01CO0_lHg`0boimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0000:0003omoO00_O
0_l>g`;o3Ml2o`oO00goWenOGimOWenOGimO00;o01jOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW42o`0?OW5nLGiaOW5nLGiaOW7o01<000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?ogml06ml2oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoaQ<00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml05=l2oaSO03;oWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?ogml0
6ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml05=l2oaSO
03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o0000
2@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml02=l2o`[O0_l;g`;o2ml02_nOGimOWenOGil3o`0F
WenOGimOWenOGimOogkdO_Anm7kdOPCo00_dO_Anm7kdO_Ano`0:C0?o2d`00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ooOg`07g`04omoOo`WO0_l:g`04omoOo`[O03;oWenOGimOWenOGomOWenO
GimOWenOGimOog5nLGiaOW5nLGkoOW5nLGiaOW5nLGiao`e<00?oC4`024`00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko4`000ooOg`07g`04omoOo`WO0_l:g`04omoOo`[O03;oWenOGimOWenOGomOWenO
GimOWenOGimOogkdO_Anm7kdO_AnogkdO_Anm7kdO_Ano`e<00?oC4`024`00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ooOg`07g`04omoOo`WO0_l:g`04omoOo`[O03;oWenOGimOWenOGomOWenO
GimOWenOGimOog5nLGiaOW5nLGiaO_mnLGiaOW5nLGiao`]<0_l;C003o`0000T0000:0003omoO01_O
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lC0003omoO00OO00Cogmoo2Ml2o`[O00Cogmoo2]l0<_nOGimOWenOGimOoenOGimOWenO
GimOWeooO_Anm7kdO_AnogkdooAnm7kdO_Anm7ko3D`00om<C008C003o`0000T0000:0003omoO01_O
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlC0003omoO00SO0_l:g`;o2ml2o`_O00[oWenOGimOWenO0_l065nOGimOWenOGimOWeoo
LGiaOW5nLGiaOP;o00aaOW5nLGiaOW5nLOl:C0?o2d`00ol0000900002P000ooOg`0Kg`;o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
4`000ooOg`0Dg`;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko64`00ol0000900002@1moa<000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000T0OOlC0003omoO01CO0_lHg`0b
oimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0
000:0003o`0001X00olNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:0003o`0001T000Co0?oo7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
4`000ooOg`0Dg`;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko64`00ol0000900002P000ol0000H0003o`0000;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Dg`;o6=l0<_nO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol000090000
2P000ol0000G0004o`0000;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Dg`;o6=l0<_nOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ol0000F0003o`000080
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlC0003omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlHC003o`0000T0000:0003o`0001D000?o00000`02oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml0
5=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?o00002@0000X000?o00001002o`030?oo00/000?o00001002oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa80OOl;00002P000ol0
00050003o`3o00/000?o00001@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa80OOl;00002P000ol000060003o`0000T000?o0000
1P02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoa<000?o00005002oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?o00001@000ol0o`090003o`0000L00_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lC0003o`0001<00olHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lHC003o`0000T0000:0003o`0000@00_l00`3oo`070003o`0000P00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
o`00018000Co0?oo6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o64`00ol0000900002P000ol0000?0003o`0000T00_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`00014000?o0000
0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003
o`0000T0000:0003o`0000h000?o00002P02o`gO0_l?g`0=oimOWenOGimOWenOG`03o`0LGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOPCo00iaOW5nLGiaOW5nLGiaoa<000?o00000P02o`030?oo00T0
00Co00000_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlHC003o`0000T0000:0003o`0000d000?o00002`02o`cO00Cogmoo3]l0?_nOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7ko4`000ol000030003
o`3o00T000?o00000P02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoaQ<00?o00002@0000X000?o000030000ol0000<00;o3=l01?oOgol>g`0noimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLOlC0003
o`0000@000?o00001`000ol0000300;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol0000;0003o`0000d00_l<g`04omoOo`kO
03koWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kd
O_Anoa<000?o00000`000ol0o`070003o`0000@00_lHg`0boimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0000:0003o`0000X000?o00001003o`L0
0_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaO_mn
LOmaOW5nLGiaOW5nLGiaoa<000?o00000P02o`030?oo00D000?o00001@02o`_O0_l;g`0:oimOWenO
GimOW`?o01JOGimOWenOGimOWeooLGiaOW5nLGia1?l02giaOW5nLGiaOW7o00Y<0ol;C003o`0000T0
000:0003o`0000T000?o00001P000ol0000600;o3Ml2o`oO00goWenOGimOWenOGimO00;o01jOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7h2o`0?m7kdO_Anm7kdO_Anm7ko01<000?o00002`000ol0
000600;o2]l01?oOgol:g`0boimOWenOGimOWeooGimOWenOGimOWenOGomnm7kdO_Anm7kdooAnm7kd
O_Anm7kdO_l=C003oda<00Q<00?o00002@0000X000?o000020000ol000080003o`0000D00_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlC0003o`0000X000?o00001`02o`[O00Cogmoo2]l0<_nOGimOWenOGimOoenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW7oLGiaOW5nLGiaOW7o3D`00om<C008C003o`0000T0000:0003o`0000L000?o0000
2@000ol0000500;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko4`000ol000090003o`0000?o1@02o`[O00Cogmoo2]l0<_nOGimOWenO
GimOoenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdooAnm7kdO_Anm7ko2d`2o`]<00?o00002@0000X0
00?o00001P000ol000090003o`3o00H00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000P000?o00000P000ol0000400;o
2]l01?oOgol:g`0boimOWenOGimOWeooGimOWenOGimOWenOGomaOW5nLGiaOW7oLGkoOW5nLGiaOW5n
LOl=C003oda<00Q<00?o00002@0000X000?o00001@000ol0000:0003o`3o00H00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003
o`0000L000?o000010000ol0000300;o2ml2o`_O00[oWenOGimOWenO0_l065nOGimOWenOGimOWeoo
O_Anm7kdO_Anm0;o00anm7kdO_Anm7kdO_l:C0?o2d`00ol0000900002P000ol000040003o`0000X0
0_l00`3oo`0500;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4`000ol000060003o`0000D000?o00000`02oaSO03;oWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?o0000
0`000ol0000E00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko4`000ol000050003o`0000D000?o0?l01002oaSO03;oWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?o0000
0P000ol0000F00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4`000ol000040003o`0000H000?o0?l01002oaSO03;oWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000Go0000
o`0I00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko4`000ol000030003o`0000H00_l00`3oo`0300;o6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P001?l00?lJ00;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o4`000ol000020003o`0000l00_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:0003o`3o01/00_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0005o`000?l0
4P02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?o00002@0000X00_lL00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`001?l00?lC00;o6=l0<_nOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P1loa<000?o0?l05002oaSO
03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o0000
2@0002P00_m_00;o5@02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaQ<00?o00002@0009T0O?l;0000/002ofh0003o0240003o0240003o0240003o0240
003o0240003o0240002Q00;o2P02oed00olA00004P02o`X00_mM00?o8@000ol0000:0003o`0005`0
00?o00004000018000?o00002P000ol0001L0003o`0001T01?l30003o`0000<00ol40003o`0004<0
0_l00`3oo`0:0003o`0000P000?o00003`0000/01?l30003o`0000800ol50003o`0004<00_l00`3o
o`0:0003o`0000P000?o00006@000ol0o`030003o`0000@000?o00000`000ol000140003o`3o00/0
00?o000020000ol0000?000030000ol0o`030003o`0000D000?o00000P000ol000140003o`3o00/0
00?o000020000ol0000I0003o`0000<000?o00000P04o`@000?o0000A@000ol0000800Go1`000ol0
o`0@000030000ol000030003o`0000D000?o00000P000ol000150003o`0000P01Ol70003o`3o01/0
00?o00000P000ol000020003o`3o00D000?o0000A0000ol0o`0;0003o`0000L000?o0?l0400000d0
00?o00000P000ol0000300;o1@000ol000140003o`3o00/000?o00001`000ol0o`0I0003o`3o00@0
00?o00000P000ol0o`050003o`0004<00_l00`3oo`0:0003o`0000H00_l00`3oo`0?00002`000ol0
o`040003o`0000D000?o00000P000ol0001300;o00<0ool02P000ol0000600;o00<0ool06004o`<0
0_l400;o1002og40000;00Co0`02o`<00ol400;oo`010000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-7.19193, -0.351729, 0.0404629, 
  0.0404629}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{{0, 1, 2}, {1, 2, 0}, {2, 0, 1}}, {{0, 1, 2, 3}, {1, 2, 3, 0}, {2, 3, 
          0, 1}, {3, 0, 1, 2}}}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[TextData[{
  "We can specify different options for each ",
  StyleBox["Groupoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[{{G\_1, ShowBodyText \[Rule] False}, {G\_2, 
          ShowKey \[Rule] False}}, Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .52381 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0124717 0.47619 [
[ 0 0 0 0 ]
[ 1 .52381 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .52381 L
0 .52381 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0124717 0.477324 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 .5 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
0 0 1 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(2)] .11905 .69286 0 0 Mshowa
[(3)] .11905 .50238 0 0 Mshowa
[(1)] .11905 .3119 0 0 Mshowa
[(0)] .11905 .12143 0 0 Mshowa
[(2)] .30952 .88333 0 0 Mshowa
[(3)] .5 .88333 0 0 Mshowa
[(1)] .69048 .88333 0 0 Mshowa
[(0)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0124717 0.97619 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(g2)] .30952 .69286 0 0 Mshowa
[(g3)] .5 .69286 0 0 Mshowa
[(g1)] .69048 .69286 0 0 Mshowa
[(g4)] .88095 .69286 0 0 Mshowa
[(g1)] .30952 .50238 0 0 Mshowa
[(g2)] .5 .50238 0 0 Mshowa
[(g4)] .69048 .50238 0 0 Mshowa
[(g3)] .88095 .50238 0 0 Mshowa
[(g3)] .30952 .3119 0 0 Mshowa
[(g4)] .5 .3119 0 0 Mshowa
[(g1)] .69048 .3119 0 0 Mshowa
[(g2)] .88095 .3119 0 0 Mshowa
[(g4)] .30952 .12143 0 0 Mshowa
[(g3)] .5 .12143 0 0 Mshowa
[(g2)] .69048 .12143 0 0 Mshowa
[(g1)] .88095 .12143 0 0 Mshowa
[(g1)] .11905 .69286 0 0 Mshowa
[(g2)] .11905 .50238 0 0 Mshowa
[(g3)] .11905 .3119 0 0 Mshowa
[(g4)] .11905 .12143 0 0 Mshowa
[(g1)] .30952 .88333 0 0 Mshowa
[(g2)] .5 .88333 0 0 Mshowa
[(g3)] .69048 .88333 0 0 Mshowa
[(g4)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[55]:=",
  ImageSize->{288, 150.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000UPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X000?oC4`05D`2oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003oda<01A<0_lHC00b
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0
000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko01M<00?o00004@000om<C00DC0;o64`0<_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?oC4`0
54`2oaQ<03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOoaSO
00?o00002@0000X000?oC4`05D`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003oda<01A<0_lHC00booAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0c
oenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o0000
4@000om<C00DC0;o64`0<_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWeoo6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioo
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?oC4`054`2oaQ<03;om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X000?oC4`0
5D`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
5d`00ol0000A0003oda<01A<0_lHC00bogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@000om<C005C0?o34`2o`Q<
0ol=C008ooAnm7kdO_@3o`0Fm7kdO_Anm7kdO_Anm7koGimOWenOG`?o00iOWenOGimOWenOGimOo`SO
0ol=g`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@000om<C008C003oda<00U<0_l;C003oda<00Y<
03;oOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaoenOGimOWenOGiooWenOGimOWenOGimOo`_O00?ogml0
2]l00ol0000900002P000om<C008C0;o2d`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003oda<00E<1?l2C0?o1T`2o`Q<1?l2C0?o
1d`02?odO_Anm7kd1?l05Gkooomnm7kdO_Anm7koGimOWenOG`04o`03Wooo00;o00QOWenOGimOo`SO
1?l01=ooool8g`03o`0000T0000:0003oda<00M<00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003oda<00A<00GoC4a<
o`03C003oda<00E<0_l7C005oda<C?l00d`00om<C006C00bogiaOW5nLOmaOW7oLGiaO_mnLGiaOW5n
LOmOWenOGiooWenOoimOoenOGimOWenOGol7g`05omoOgol00]l00ooOg`07g`03o`0000T0000:0003
oda<00M<00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l05d`00ol0000A0003oda<00A<00KoC4a<od`4o`I<0_l7C006oda<C?m<1?l7C00b
ooAnm7kdO_mnm7koO_Anm?odO_Anm7kdO_mOWenOGiooWenOoimOWonOGimOWenOGol7g`05omoOgol0
0]l00ooOg`07g`03o`0000T0000:0003oda<00M<00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003oda<00A<00WoC4a<
odcoC?l01d`2o`M<00WoC4a<odcoC?l024`03_mnLGiaOW7oLGiaog5n0_l08W5nLGiaOW5nLOmOWenO
GiooWenOoimOWeooGimOWenOGol7g`05omoOgol00]l00ooOg`07g`03o`0000T0000:0003oda<00M<
00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l05d`00ol0000A0003oda<00E<1_l00dcoC006C0;o24`6o`03C?m<00M<00Som7kdO_Anm0Go
01CdO_Com7kdO_Anm7koGimOWenOG`Ko00^OGomOWenOGimOo`08g`Go00?Ooml02=l00ol000090000
2P000om<C008C0;o2d`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl05d`00ol0000A0003oda<00]<0_l7C0;o3T`2o`Q<00goOW5nLGiaOW5nLGia00?o
01MaOW5nLGiaOW7oGimOWenOGimOWenOG`02o`09WenOGimOWeoo00gO0_l9g`03o`0000T0000:0003
oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01M<00?o00004@000om<C00DC0;o64`0<_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenO
GimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?oC4`054`2oaQ<
03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o0000
2@0000X000?oC4`05D`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l05d`00ol0000A0003oda<01A<0_lHC00booAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimO
WenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@000om<
C00DC0;o64`0<_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWeoo
6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?oC4`054`2oaQ<03;om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X000?oC4`05D`2oaOO
03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0
000A0003oda<01A<0_lHC00bogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenO
GimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@000om<C00DC0;o64`0<_odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<
C00EC0;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?oC4`054`2oaQ<03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenO
GimOWenOGimOWenOGimOoaSO00?o00002@0000X0O?lC07co2`0000X001SoOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0Iog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0C000Gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_l06G5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO
01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002o`0I
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimO
WenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l065nOGimOWenOGimOWenOGimOWenO
GimOoaQ<00?ogml05]l06OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl04`005omaOW5nLGiaOW5nLGia
OW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml06_mOWenOGimO
WenOGimOWenOGimOWenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HGimOWenO
GimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0IogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0C000G
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l064`00ooO
g`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOP;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO01WoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06Omn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo
2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo
64`00ooOg`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C000Gog5nLGiaOW5nLGiaOW5nLGia
OW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimO
WenOGimOWenOGimOWol;00002P006?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01QOWenOGimOWenO
GimOWenOGimOWenOGolHC003omoO01KO01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoO_An
m7kdO_Anm7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO
01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06OmaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl04`002?maOW5nLGia0ol0375nLGiaOW5nLGiaOP;o00QaOW5nLGiaOP?o00inLGiaOW5nLGia
OW5no`M<0ol>C003omoO00GO0ol=g`09oenOGimOWenO00?o00jOGimOWenOGimOWenOo`/0000:000H
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml0
5]l06Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdooAnm7kdO_Anm7kd00;o
01Unm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Co00Y<00?oC4`02d`00ooOg`08g`03omoO00[O01[oGimO
WenOGimOWeooGimOWenOGimOWenOo`/0000:000:ogiaOW5nLGiaOP?o00]nLGiaOW5nLGiaOP02o`0H
GimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0C0008og5nLGiaOW44o`0;O_ooogiaOW5nLGh00_l0275nLGiaOW5n1?l03G7ooomaOW5nLGiaO_l0
1d`4o`9<0ol8C003omoO00GO1?l01=ooool8g`09oenOGimOWenO00Co00=Oool00_l029mOWenOGioo
2`0000X001Som7kdO_Anm7kdO_mnm7kdO_Anm7kdO_@2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo
64`00ooOg`0Fg`0IogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0C000GogkdO_Anm?odO_Com7kdO_mn
m7kdO_@00_l06GkdO_Anm7koO_AnogkdO_Com7kdO_Anm?l01T`01Om<C4co00=<00?oC4`01d`00ooO
g`04g`05omoOgol00]l00ooOg`07g`0JoenOGimOWeooGimOoenOoimOWenOGimOWol;00002P006?mn
LGiaOW5nLGiaog5nLGiaOW5nLGiaOP;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO
01WoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01<001OoLGiaOW5nogiaO_mnLGiaog5nLGiaOP02o`0I
LGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5no`06C006oda<C?m<1?l8C003omoO00CO00GogmoOo`02g`03
omoO00OO01[oGimOWenOGomOWeooGimOoenOGimOWenOo`/0000:000HooAnm7kdO_Anm7koO_Anm7kd
O_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06Omnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l04`003_mnm7kdO_Com7kdooAn0_l01oAnm7kdO_@00_l03WkdO_Anm7koO_Anogkd
0_l02GkdO_Anm7kdo`06C009oda<C?m<odco00U<00?ogml01=l01OoOgmoo00;O00?ogml01ml06_mO
WenOGimOoenOGomOWenOoimOWenOGioo2`0000X001SoOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGh2o`0H
GimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0C0008og5nLGiaOW45o`0:LGiaog5nLGiaOP;o00QaOW5nLGiaOPGo00anLGkoOW5nLGiaO_l7C0Ko
00=<od`024`00ooOg`05g`Go00?Ooml02=l02OmOWenOGimOW`06o`0;GiooWenOGimOWol02`0000X0
00[om7kdO_Anm7kd0_l037kdO_Anm7kdO_Anm0;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003
omoO01KO01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<000goO_Anm7kdO_Anm7kd00?o00OdO_An
m7kd00;o00enm7kdO_Anm7kdO_An00?o00Unm7kdO_Anm?l03D`2o`U<00?ogml02]l2o`WO00ooGimO
WenOGimOWenOGil00_l02EnOGimOWenOo`0;00002P006?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO01WoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06Omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X0
01SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo64`00ooO
g`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C000Gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimO
WenOGimOWol;00002P006?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01QOWenOGimOWenOGimOWenO
GimOWenOGolHC003omoO01KO01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoO_Anm7kdO_An
m7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimO
WenOGimOWenOGimOWenOGimOWenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l065nO
GimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
4`005omaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<
00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0IogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0C000GogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO
01WoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0I
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimO
WenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenO
GimOoaQ<00?ogml05]l06Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimO
WenOGimOWenOGimOWenOGioo2`0000X0O?lC07co2`0000X001SoWenOGimOWenOGimOWenOGimOWenO
Gil2o`0HO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimO
WenOGimOo`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_lHg`0JoimOWenOGimOWenOGimOWenO
GimOWenOGolGC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenO
GimOWenOGimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimOWenOGimO
WenOGimOWenOGimOWeoo01<001OoGimOWenOGimOWenOGimOWenOGimOW`02oaSO01[oWenOGimOWenO
GimOWenOGimOWenOGimOoaM<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000HoimOWenO
GimOWenOGimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmO
WenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOGimOWenOGimOWenO00;o6=l06_nO
GimOWenOGimOWenOGimOWenOGimOWeoo5d`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2`0000X0
01SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6=l00om<
C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimOWenOGimOWenOGimOWenOGil0
0_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenOGolGC00Jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01Qnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lHg`03oda<01I<01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<001OoGimOWenOGimOWenOGimO
WenOGimOW`02oaSO01[oWenOGimOWenOGimOWenOGimOWenOGimOoaM<01[oO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0675nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaSO00?oC4`05T`06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimO
WenOGimOWenOGimOWenO00;o6=l06_nOGimOWenOGimOWenOGimOWenOGimOWeoo5d`06_maOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000G
oenOGimOWenOGimOWenOGimOWenOGil00_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenOGolGC00J
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o
01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimOWenOGimOWenOGimOWenOGimO
Weoo01<000SoGimOWenOG`?o00aOWenOGimOWenOGil2o`SO0ol=g`08oimOWenOGil3o`0?WenOGimO
WenOGimOWeoo00M<0ol=C009og5nLGiaOW5n00?o00inLGiaOW5nLGiaOW5no`/0000:000HoimOWenO
GimOWenOGimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmO
WenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOoimOWenOGimOWenO00;o2ml00ooO
g`0:g`0JoimOWenOGimOWeooGimOWenOGimOWenOGol:C003oda<00Y<01[oO_Anm7kdO_Anm7koO_An
m7kdO_Anm7kdo`/0000:000:oimOWenOGimOW`?o00^OGimOWenOGimOW`02o`0HLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C0008oenOGimO
Wel4o`03Wooo00;o00IOWenOGil2o`SO1?l01=ooool8g`08oimOWenOGil4o`03Gooo00;o00VOGimO
WenOGol01d`4o`9<0ol7C009og5nLGiaOW5n00Co00eaooooLGiaOW5nLGko00/0000:000HoimOWenO
GimOWenOGomOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmO
WenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGiooWenOoimOoenOGimOWenO00;o1ml01OoO
gmoo00;O00?ogml01ml06_nOGimOWeooGimOoenOoimOWenOGimOWeoo1T`01Om<C4co00=<00?oC4`0
1T`06_mnm7kdO_AnogkdO_mnm7kdooAnm7kdO_Co2`0000X001SoWenOGimOWenOGimOoenOGimOWenO
Gil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6=l00om<C00FC00IoenOGimOWenOGimOWenOGimO
WenOGimOo`0C000GoenOGimOWonOGiooWenOoimOWenOGil00_l7g`05omoOgol00]l00ooOg`07g`0J
oimOWenOGomOWeooGimOoenOGimOWenOGol6C006oda<C?m<1?l7C00Jog5nLGiaOW7oLGiaog5nLGko
OW5nLGiaO_l;00002P002onOGimOWenOGimO00;o00^OGimOWenOGimOW`02o`0HO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimO
WonOGiooWenOGomOWenOGil00_l7g`05omoOgol00]l00ooOg`07g`0JoimOWenOGomOWeooGimOWonO
GimOWenOGol6C009oda<C?m<odco00Q<00ooO_Anm7kdO_mnm7koO_@00_l02GkdO_Anm7kdo`0;0000
2P006?nOGimOWenOGimOWeooGimOWenOGimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03
oda<01I<01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<000SoGimOWenOG`Ko00VOGomOWenOGil0
0_l8g`Go00?Ooml02=l02?nOGimOWenO1_l035nOoimOWenOGimOo`M<1_l00dcoC007C009og5nLGia
OW5n00Go00anLGkoOW5nLGiaO_l;00002P002_nOGimOWenOGil3o`0;WenOGimOWenOGil00_l067kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmOWenOGimOWenOGimOWenOGimOWenOGol0
4`003_mOWenOGimOWenOGimO0_l01imOWenOGil00_l=g`;o2Ml03_nOGimOWenOGimOWenO0_l02UnO
GimOWenOGol=C0;o24`03_mnm7kdO_Anm7kdO_An0ol02GkdO_Anm7kdo`0;00002P006?nOGimOWenO
GimOWenOGimOWenOGimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimO
WenOGimOWenOGimOWenOGimOWeoo01<001OoGimOWenOGimOWenOGimOWenOGimOW`02oaSO01[oWenO
GimOWenOGimOWenOGimOWenOGimOoaM<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000H
oimOWenOGimOWenOGimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`0
5T`06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOGimOWenOGimOWenO00;o
6=l06_nOGimOWenOGimOWenOGimOWenOGimOWeoo5d`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimOWenOGimOWenOGimO
WenOGil00_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenOGolGC00Jog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01Qnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lHg`03oda<01I<01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<001OoGimOWenOGimO
WenOGimOWenOGimOW`02oaSO01[oWenOGimOWenOGimOWenOGimOWenOGimOoaM<01[oO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0675nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaSO00?oC4`05T`06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omO
WenOGimOWenOGimOWenOGimOWenO00;o6=l06_nOGimOWenOGimOWenOGimOWenOGimOWeoo5d`06_ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0H
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimO
o`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenO
GolGC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenOGimOWenO
GimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimOWenOGimOWenOGimO
WenOGimOWeoo01<001OoGimOWenOGimOWenOGimOWenOGimOW`02oaSO01[oWenOGimOWenOGimOWenO
GimOWenOGimOoaM<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000HoimOWenOGimOWenO
GimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmOWenOGimO
WenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOGimOWenOGimOWenO00;o6=l06_nOGimOWenO
GimOWenOGimOWenOGimOWeoo5d`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2`0000X001SoWenO
GimOWenOGimOWenOGimOWenOGil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6=l00om<C00FC00I
oenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_lHg`0J
oimOWenOGimOWenOGimOWenOGimOWenOGolGC00Jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l;0000
2P1loa<0O?l;00002P000ooOg`0Eg`;o5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimO
WenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?ogml05=l2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGg`03oda<01I<00?o00002@0000X000?ogml0
5Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003omoO01CO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko5ml00om<C00FC003o`0000T0000:0003omoO01GO0_lGC00cog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o
039OWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaOO00?oC4`0
5T`00ol0000900002P000ooOg`0Eg`;o5d`0<omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimO
WenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?ogml05=l2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGg`03oda<01I<00?o00002@0000X000?ogml0
5Ml2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003omoO01CO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o5ml00om<C00FC003o`0000T0000:0003omoO01GO0_lGC00cogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o
039OWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaOO00?oC4`0
5T`00ol0000900002P000ooOg`0Eg`;o5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimO
WenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?ogml05=l2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGg`03oda<01I<00?o00002@0000X000?ogml0
5Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003omoO00GO0ol<g`;o00QOWenOGimOW`?o01FOGimOWenOGimOWenOooAnm7kdO_@0
0ol03oAnm7kdO_Anm7kdO_Ano`07g`?o3Ml00om<C006C0?o3D`00ol0000900002P000ooOg`0Eg`;o
5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03
o`00014000?ogml02=l00ooOg`09g`;o039OWenOGimOWenOGomOWenOGimOWenOGiooOW5nLGiaOW5n
LOmaOW5nLGiaOW5nLGiao`[O00?ogml02]l00om<C009C003oda<00Y<00?o00002@0000X000?ogml0
1ml4o`[O0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimO
Weoo01OO00?o00004@000ooOg`05g`Co00COoooo1ml2o`08GimOWenOGil4o`03Gooo00;o00nOGimO
WenOooAnm7kdO_@01?l03Wkooomnm7kdO_Anm7ko1ml4o`04goooo`SO00?oC4`01T`4o`9<0ol7C003
o`0000T0000:0003omoO00SO00?ogml02]l2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimO
WenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO00CO00GogmoOo`02g`03omoO00KO
0_l0<UnOGimOWeooGimOoenOoimOWenOGimOWomnLGiaOW7oLGiaog5nLGkoOW5nLGiaOW7o1]l01OoO
gmoo00;O00?ogml01ml00om<C005C005oda<C?l00d`00om<C006C003o`0000T0000:0003omoO00WO
00?ogml02Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimO
WenOGol05ml00ol0000A0003omoO00CO00GogmoOo`02g`03omoO00KO0_l0<UnOGimOWeooGimOoenO
GomOWenOGimOWoodO_Anm7koO_AnogkdO_Com7kdO_Anm7ko1]l01OoOgmoo00;O00?ogml01ml00om<
C005C006oda<C?m<1?l7C003o`0000T0000:0003omoO00[O00?ogml02=l2oaM<03?oLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO00CO
00GogmoOo`02g`03omoO00KO0_l09UnOGimOWeooGimOoenOGiooWenOGimOWomnLGiaOW7oLGiaog5n
0_l02W5nLGiaOW5nLOl6g`05omoOgol00]l00ooOg`07g`03oda<00E<00WoC4a<odcoC?l024`00ol0
000900002P000ooOg`07g`04omoOo`[O0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimO
WenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`05g`Go00?Ooml01ml2o`08GimOWenO
Gil6o`0BGiooWenOGimOWoodO_Anm7kd1Ol03OAnm?odO_Anm7kdO_l01ml5o`03gooO00SO00?oC4`0
1T`6o`03C?m<00M<00?o00002@0000X000?ogml02=l2o`_O0_lGC00cog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`0:g`;o2=l2o`0>
GimOWenOGimOWenOGil2o`0EGimOWenOGiooOW5nLGiaOW5nLGia00?o00YaOW5nLGiaOW7o3=l2o`WO
00?oC4`034`2o`Q<00?o00002@0000X000?ogml05Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO01CO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko5ml00om<C00FC003o`0000T0
000:0003omoO01GO0_lGC00cog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o039OWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaOO00?oC4`05T`00ol0000900002P000ooOg`0Eg`;o5d`0<omn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`000140
00?ogml05=l2o`0bGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lGg`03oda<01I<00?o00002@0000X000?ogml05Ml2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO01CO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5ml00om<C00FC003o`0000T0
000:0003omoO01GO0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o039OWenOGimOWenOGimOWenOGimOWenOGioom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaOO00?oC4`05T`00ol0000900002P000ooOg`0Eg`;o5d`0<oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`000140
00?ogml05=l2o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlGg`03oda<01I<00?o00002@0000X000?ogml05Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO01CO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko5ml00om<C00FC003o`0000T0
000:0003omoO01GO0_lGC00cog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o039OWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaOO00?oC4`05T`00ol0000900002@1moa80OOl;00002@1moa80
OOl;00002P000ol0000D00?o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000?o00005002oaSO03;oWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?o00004`001?l0oolGg`0c
oenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o0000
4@000ol0000C00?o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o64`00ol0000900002P000ol0000B0003o`0000;o5ml0<omOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?o00004P001?l0oolHg`0b
oimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0
000:0003o`00014000Co00000_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01M<00?o00004@000ol0000A0003o`0000;o6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol0000@0003
o`0000800_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01M<00?o00004@000ol0000@0004o`0000;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ol0000200;o00<0ool020000ol0
000300;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?o00000P02o`030?oo00P000?o00000P02oaSO03;oWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?o00000`000ol0
o`080003o`0000@00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko01M<00?o00004@000ol000030003o`3o00P000?o00000`02oaSO03;oWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?o0000
10000ol000060003o`0000D00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01M<00?o00004@000ol000040003o`0000H000?o00001002o`SO0ol=g`08
oimOWenOGil3o`0FWenOGimOWenOGimOWeooLGiaOW5nL@?o00iaOW5nLGiaOW5nLGiao`Q<0ol=C003
o`0000T0000:0003o`0000<000?o0?l01P000ol0000600;o5ml0<omOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?o00000`000ol0o`060003
o`0000D00_l;g`03omoO00[O03;oWenOGimOWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Com7kd
O_Anm7kdO_Ano`]<00?oC4`02T`00ol0000900002P000ol0000200;o00<0ool010000ol0000700;o
2Ml4o`[O00_oGimOWenOGimOW`03o`0EWenOGimOWenOGiooOW5nLGiaOW5n00?o00enLGiaOW5nLGia
OW7o00Y<0_l;C003o`00014000?o00000P02o`030?oo00@000?o00001P02o`SO1?l01=ooool8g`08
oimOWenOGil4o`03Gooo00;o012OGimOWenOGomaOW5nLGia1?l03GkooomnLGiaOW5nLOl024`4o`9<
0ol7C003o`0000T0000:0003o`0000X000?o00002002o`[O00?ogml02]l0<omOWenOGimOWenOGimO
oenOGimOWenOGioom7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Ano`09C004oda<o`Y<00?o00004@000ol0
000:0003o`0000L00_l7g`05omoOgol00]l00ooOg`07g`0boimOWenOGomOWeooGiooWenOGimOWenO
Gomnm7kdO_Com7kdooAnm7koO_Anm7kdO_l7C005oda<C?l00d`00om<C006C003o`0000T0000:0003
o`0000T000?o00002@02o`_O00?ogml02Ml0<omOWenOGimOWenOGimOoenOGimOWenOGiooOW5nLGia
OW5nLOmaOW5nLGiaOW5nLGiao`09C004oda<o`Y<00?o00004@000ol000090003o`0000P00_l7g`05
omoOgol00]l00ooOg`07g`0boimOWenOGomOWeooGimOoenOGimOWenOGomaOW5nLGkoOW5nogiaOW7o
LGiaOW5nLOl7C006oda<C?m<1?l7C003o`0000T0000:0003o`0000P000Co00000ol600;o3=l00ooO
g`08g`0<oenOGimOWenOGimO0_l09ImOWenOGimOWenOooAnm7kdO_Anm7koO_Anm7kdO_Anm7kdO_l0
2D`01?m<C?l:C003o`00014000?o000020001?l00003o`D00_l7g`05omoOgol00]l00ooOg`07g`0W
oimOWenOGomOWeooGimOWonOGimOWenOGomnm7kdO_Com7kdooAn00;o00WdO_Anm7kdO_l01d`02Om<
C4coC?m<o`08C003o`0000T0000:0003o`0000L000?o00000`000ol0000500;o2Ml01?oOgol:g`0c
oenOGimOWenOGimOWeooGimOWenOGimOWomnLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o00U<00CoC4co
2T`00ol0000A0003o`0000L000?o00000`000ol0000400;o2=l5o`03gooO00SO00SoWenOGimOW`Ko
01=OWonOGimOWenOGomaOW5nLGia00Go00aaOW7oLGiaOW5nLOl8C0Ko00=<od`01d`00ol000090000
2P000ol000060003o`0000D000?o00001002o`[O0_l;g`0;oenOGimOWenOGil00ol05ImOWenOGimO
WenOooAnm7kdO_Anm002o`0>O_Anm7kdO_Anm7kdO_l:C0;o2d`00ol0000A0003o`0000H000?o0000
1@000ol0000300;o3Ml2o`WO00koWenOGimOWenOGimOW`;o01IOWenOGimOWeooO_Anm7kdO_Anm7kd
0ol02OAnm7kdO_Ano`0>C0;o24`00ol0000900002P000ol000050003o`0000H000?o00001002oaOO
03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0
000A0003o`0000D000?o00001P000ol0000300;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol000040003o`0000H000?o0?l0
1@02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
5d`00ol0000A0003o`0000@000?o00001P000ol0o`0400;o6=l0<_nOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ol000030003o`0000L0
00?o0?l01@02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl05d`00ol0000A0003o`0000<000?o00001`000ol0o`0400;o6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol000020003
o`0000L00_l00`3oo`0400;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000?o00000P000ol0000700;o00<0ool00`02oaSO03;oWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X0
00Go0000o`0C00;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0GC003o`00014000Go0000o`0B00;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P001?l00?lD00;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000Co003o
4`02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?o00002@0000X000?o0?l05@02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003o`3o01@00_lHg`0boimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:00;o5P02oaOO03?oGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A00;o
5@02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?o00002@0000X0O?lC07co2`0002800_n<00;oKP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0003@01?m500?o@`04odD00olA0000=@000ol000160003o`0004<000?o0000
AP000ol0000@00003003o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`801Ol00`3oo`02ob`0
0_l00`3oo`0:0003o`0000P000?o00006@03o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`80
1Ol00`3oo`02ob`00_l00`3oo`090003o`3o00T000?o00003`0000d000Go0000o`020004o`00o`@0
00Go0000o`030003o`00008000Oo0000o`3o008000Co003o0`000ol0000Z0003o`3o00/000?o0000
20000ol0000J0005o`000?l00P001?l00?l40005o`000?l00`000ol000020007o`000?l0o`020004
o`00o`<000?o0000:P000ol0o`0;0003o`0000P000?o00003`0000d000Go0000o`020003o`0000Ko
00@0oooo0`000ol000020007o`000?l0o`020004o`00o`<000?o0000:`000ol0000800Go1`000ol0
o`0K0005o`000?l00P000ol00006o`040?ooo`<000?o00000P001ol0003o0?l00P001?l00?l30003
o`0002/000?o00002005o`L000?o0?l0400000/000Oo0?l0o`3o008000Co003o0`02o`L00_l30007
o`000?l0o`020004o`00o`<000?o0000:P000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l0
0P001?l00?l300;o1`02o`<000Oo0000o`3o008000Co003o0`000ol0000Z0003o`3o00/000?o0000
1`000ol0o`0@00002`001_l0o`3o00Co0`03o`030?l0008000?o00000_l00`3oo`0200?o00@0ool0
0_l00`3oo`03ob`00_l00`3oo`0:0003o`0000H00_l00`3oo`0H0006o`3o0?l01?l300?o00<0o`00
0P000ol00002o`030?oo00800ol0103oo`02o`030?oo00?o;002o`030?oo01<00_l00`3oo`0?0000
2`05o`030?l000X01?mi00Go00<0o`002P04og00000@00;oS@02ogl0003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {149.812, 0}} -> {-0.0536619, -0.0261961, 
  0.0073426, 0.0073426}, {{7.25, 137}, {146.188, 
  3.5625}} -> {-1.42043, -0.28431, 0.0404912, 0.0404912}, {{149.938, 
  279.688}, {146.188, 3.5625}} -> {-7.19803, -0.28431, 0.0404912, 
  0.0404912}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{{0, 1, 3, 2}, {1, 2, 0, 3}, {3, 0, 2, 1}, {2, 3, 1, 0}}, {{a, a**b, 
          b, a\^b}, {b, a, a\^b, a**b}, {a**b, a\^b, b, a}, {a\^b, a**b, a, 
          b}}}\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell["\<\
Alternatively, we can accomplish the same result in the following \
manner.\
\>", "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[{G\_1, 
        G\_2}, {{ShowBodyText \[Rule] False}, {ShowKey \[Rule] False}}, 
      Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"Cayley"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .52381 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0124717 0.47619 [
[ 0 0 0 0 ]
[ 1 .52381 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .52381 L
0 .52381 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0124717 0.477324 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 .5 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
0 0 1 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(2)] .11905 .69286 0 0 Mshowa
[(3)] .11905 .50238 0 0 Mshowa
[(1)] .11905 .3119 0 0 Mshowa
[(0)] .11905 .12143 0 0 Mshowa
[(2)] .30952 .88333 0 0 Mshowa
[(3)] .5 .88333 0 0 Mshowa
[(1)] .69048 .88333 0 0 Mshowa
[(0)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0124717 0.97619 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(g2)] .30952 .69286 0 0 Mshowa
[(g3)] .5 .69286 0 0 Mshowa
[(g1)] .69048 .69286 0 0 Mshowa
[(g4)] .88095 .69286 0 0 Mshowa
[(g1)] .30952 .50238 0 0 Mshowa
[(g2)] .5 .50238 0 0 Mshowa
[(g4)] .69048 .50238 0 0 Mshowa
[(g3)] .88095 .50238 0 0 Mshowa
[(g3)] .30952 .3119 0 0 Mshowa
[(g4)] .5 .3119 0 0 Mshowa
[(g1)] .69048 .3119 0 0 Mshowa
[(g2)] .88095 .3119 0 0 Mshowa
[(g4)] .30952 .12143 0 0 Mshowa
[(g3)] .5 .12143 0 0 Mshowa
[(g2)] .69048 .12143 0 0 Mshowa
[(g1)] .88095 .12143 0 0 Mshowa
[(g1)] .11905 .69286 0 0 Mshowa
[(g2)] .11905 .50238 0 0 Mshowa
[(g3)] .11905 .3119 0 0 Mshowa
[(g4)] .11905 .12143 0 0 Mshowa
[(g1)] .30952 .88333 0 0 Mshowa
[(g2)] .5 .88333 0 0 Mshowa
[(g3)] .69048 .88333 0 0 Mshowa
[(g4)] .88095 .88333 0 0 Mshowa
[(TheGroup)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[56]:=",
  ImageSize->{288, 150.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000UPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X000?oC4`05D`2oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003oda<01A<0_lHC00b
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0
000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko01M<00?o00004@000om<C00DC0;o64`0<_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?oC4`0
54`2oaQ<03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOoaSO
00?o00002@0000X000?oC4`05D`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003oda<01A<0_lHC00booAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0c
oenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o0000
4@000om<C00DC0;o64`0<_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWeoo6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioo
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?oC4`054`2oaQ<03;om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X000?oC4`0
5D`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
5d`00ol0000A0003oda<01A<0_lHC00bogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@000om<C005C0?o34`2o`Q<
0ol=C008ooAnm7kdO_@3o`0Fm7kdO_Anm7kdO_Anm7koGimOWenOG`?o00iOWenOGimOWenOGimOo`SO
0ol=g`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@000om<C008C003oda<00U<0_l;C003oda<00Y<
03;oOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaoenOGimOWenOGiooWenOGimOWenOGimOo`_O00?ogml0
2]l00ol0000900002P000om<C008C0;o2d`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003oda<00E<1?l2C0?o1T`2o`Q<1?l2C0?o
1d`02?odO_Anm7kd1?l05Gkooomnm7kdO_Anm7koGimOWenOG`04o`03Wooo00;o00QOWenOGimOo`SO
1?l01=ooool8g`03o`0000T0000:0003oda<00M<00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003oda<00A<00GoC4a<
o`03C003oda<00E<0_l7C005oda<C?l00d`00om<C006C00bogiaOW5nLOmaOW7oLGiaO_mnLGiaOW5n
LOmOWenOGiooWenOoimOoenOGimOWenOGol7g`05omoOgol00]l00ooOg`07g`03o`0000T0000:0003
oda<00M<00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l05d`00ol0000A0003oda<00A<00KoC4a<od`4o`I<0_l7C006oda<C?m<1?l7C00b
ooAnm7kdO_mnm7koO_Anm?odO_Anm7kdO_mOWenOGiooWenOoimOWonOGimOWenOGol7g`05omoOgol0
0]l00ooOg`07g`03o`0000T0000:0003oda<00M<00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003oda<00A<00WoC4a<
odcoC?l01d`2o`M<00WoC4a<odcoC?l024`03_mnLGiaOW7oLGiaog5n0_l08W5nLGiaOW5nLOmOWenO
GiooWenOoimOWeooGimOWenOGol7g`05omoOgol00]l00ooOg`07g`03o`0000T0000:0003oda<00M<
00CoC4co2T`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_l05d`00ol0000A0003oda<00E<1_l00dcoC006C0;o24`6o`03C?m<00M<00Som7kdO_Anm0Go
01CdO_Com7kdO_Anm7koGimOWenOG`Ko00^OGomOWenOGimOo`08g`Go00?Ooml02=l00ol000090000
2P000om<C008C0;o2d`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl05d`00ol0000A0003oda<00]<0_l7C0;o3T`2o`Q<00goOW5nLGiaOW5nLGia00?o
01MaOW5nLGiaOW7oGimOWenOGimOWenOG`02o`09WenOGimOWeoo00gO0_l9g`03o`0000T0000:0003
oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01M<00?o00004@000om<C00DC0;o64`0<_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenO
GimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?oC4`054`2oaQ<
03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o0000
2@0000X000?oC4`05D`2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l05d`00ol0000A0003oda<01A<0_lHC00booAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimO
WenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@000om<
C00DC0;o64`0<_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWeoo
6=l00ol0000900002P000om<C00EC0;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?oC4`054`2oaQ<03;om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X000?oC4`05D`2oaOO
03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0
000A0003oda<01A<0_lHC00bogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenO
GimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@000om<C00DC0;o64`0<_odO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<
C00EC0;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?oC4`054`2oaQ<03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenO
GimOWenOGimOWenOGimOoaSO00?o00002@0000X0O?lC07co2`0000X001SoOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0Iog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0C000Gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_l06G5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO
01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002o`0I
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimO
WenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l065nOGimOWenOGimOWenOGimOWenO
GimOoaQ<00?ogml05]l06OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl04`005omaOW5nLGiaOW5nLGia
OW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml06_mOWenOGimO
WenOGimOWenOGimOWenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HGimOWenO
GimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0IogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0C000G
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l064`00ooO
g`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOP;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO01WoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06Omn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo
2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo
64`00ooOg`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C000Gog5nLGiaOW5nLGiaOW5nLGia
OW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimO
WenOGimOWenOGimOWol;00002P006?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01QOWenOGimOWenO
GimOWenOGimOWenOGolHC003omoO01KO01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoO_An
m7kdO_Anm7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO
01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06OmaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl04`002?maOW5nLGia0ol0375nLGiaOW5nLGiaOP;o00QaOW5nLGiaOP?o00inLGiaOW5nLGia
OW5no`M<0ol>C003omoO00GO0ol=g`09oenOGimOWenO00?o00jOGimOWenOGimOWenOo`/0000:000H
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml0
5]l06Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdooAnm7kdO_Anm7kd00;o
01Unm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Co00Y<00?oC4`02d`00ooOg`08g`03omoO00[O01[oGimO
WenOGimOWeooGimOWenOGimOWenOo`/0000:000:ogiaOW5nLGiaOP?o00]nLGiaOW5nLGiaOP02o`0H
GimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0C0008og5nLGiaOW44o`0;O_ooogiaOW5nLGh00_l0275nLGiaOW5n1?l03G7ooomaOW5nLGiaO_l0
1d`4o`9<0ol8C003omoO00GO1?l01=ooool8g`09oenOGimOWenO00Co00=Oool00_l029mOWenOGioo
2`0000X001Som7kdO_Anm7kdO_mnm7kdO_Anm7kdO_@2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo
64`00ooOg`0Fg`0IogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0C000GogkdO_Anm?odO_Com7kdO_mn
m7kdO_@00_l06GkdO_Anm7koO_AnogkdO_Com7kdO_Anm?l01T`01Om<C4co00=<00?oC4`01d`00ooO
g`04g`05omoOgol00]l00ooOg`07g`0JoenOGimOWeooGimOoenOoimOWenOGimOWol;00002P006?mn
LGiaOW5nLGiaog5nLGiaOW5nLGiaOP;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO
01WoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01<001OoLGiaOW5nogiaO_mnLGiaog5nLGiaOP02o`0I
LGiaOW5nLOmaOW7oLGiaO_mnLGiaOW5no`06C006oda<C?m<1?l8C003omoO00CO00GogmoOo`02g`03
omoO00OO01[oGimOWenOGomOWeooGimOoenOGimOWenOo`/0000:000HooAnm7kdO_Anm7koO_Anm7kd
O_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06Omnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l04`003_mnm7kdO_Com7kdooAn0_l01oAnm7kdO_@00_l03WkdO_Anm7koO_Anogkd
0_l02GkdO_Anm7kdo`06C009oda<C?m<odco00U<00?ogml01=l01OoOgmoo00;O00?ogml01ml06_mO
WenOGimOoenOGomOWenOoimOWenOGioo2`0000X001SoOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGh2o`0H
GimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0C0008og5nLGiaOW45o`0:LGiaog5nLGiaOP;o00QaOW5nLGiaOPGo00anLGkoOW5nLGiaO_l7C0Ko
00=<od`024`00ooOg`05g`Go00?Ooml02=l02OmOWenOGimOW`06o`0;GiooWenOGimOWol02`0000X0
00[om7kdO_Anm7kd0_l037kdO_Anm7kdO_Anm0;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003
omoO01KO01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<000goO_Anm7kdO_Anm7kd00?o00OdO_An
m7kd00;o00enm7kdO_Anm7kdO_An00?o00Unm7kdO_Anm?l03D`2o`U<00?ogml02]l2o`WO00ooGimO
WenOGimOWenOGil00_l02EnOGimOWenOo`0;00002P006?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO01WoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06Omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X0
01SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo64`00ooO
g`0Fg`0Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C000Gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimO
WenOGimOWol;00002P006?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01QOWenOGimOWenOGimOWenO
GimOWenOGolHC003omoO01KO01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoO_Anm7kdO_An
m7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimO
WenOGimOWenOGimOWenOGimOWenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l065nO
GimOWenOGimOWenOGimOWenOGimOoaQ<00?ogml05]l06OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl0
4`005omaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<
00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo64`00ooOg`0Fg`0IogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0C000GogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?mn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01QOWenOGimOWenOGimOWenOGimOWenOGolHC003omoO01KO
01WoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0I
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimO
WenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l065nOGimOWenOGimOWenOGimOWenO
GimOoaQ<00?ogml05]l06Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omnm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimO
WenOGimOWenOGimOWenOGioo2`0000X0O?lC07co2`0000X001SoWenOGimOWenOGimOWenOGimOWenO
Gil2o`0HO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimO
WenOGimOo`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_lHg`0JoimOWenOGimOWenOGimOWenO
GimOWenOGolGC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenO
GimOWenOGimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimOWenOGimO
WenOGimOWenOGimOWeoo01<001OoGimOWenOGimOWenOGimOWenOGimOW`02oaSO01[oWenOGimOWenO
GimOWenOGimOWenOGimOoaM<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000HoimOWenO
GimOWenOGimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmO
WenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOGimOWenOGimOWenO00;o6=l06_nO
GimOWenOGimOWenOGimOWenOGimOWeoo5d`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2`0000X0
01SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6=l00om<
C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimOWenOGimOWenOGimOWenOGil0
0_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenOGolGC00Jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01Qnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lHg`03oda<01I<01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<001OoGimOWenOGimOWenOGimO
WenOGimOW`02oaSO01[oWenOGimOWenOGimOWenOGimOWenOGimOoaM<01[oO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0675nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaSO00?oC4`05T`06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimO
WenOGimOWenOGimOWenO00;o6=l06_nOGimOWenOGimOWenOGimOWenOGimOWeoo5d`06_maOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000G
oenOGimOWenOGimOWenOGimOWenOGil00_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenOGolGC00J
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o
01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimOWenOGimOWenOGimOWenOGimO
Weoo01<000SoGimOWenOG`?o00aOWenOGimOWenOGil2o`SO0ol=g`08oimOWenOGil3o`0?WenOGimO
WenOGimOWeoo00M<0ol=C009og5nLGiaOW5n00?o00inLGiaOW5nLGiaOW5no`/0000:000HoimOWenO
GimOWenOGimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmO
WenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOoimOWenOGimOWenO00;o2ml00ooO
g`0:g`0JoimOWenOGimOWeooGimOWenOGimOWenOGol:C003oda<00Y<01[oO_Anm7kdO_Anm7koO_An
m7kdO_Anm7kdo`/0000:000:oimOWenOGimOW`?o00^OGimOWenOGimOW`02o`0HLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C0008oenOGimO
Wel4o`03Wooo00;o00IOWenOGil2o`SO1?l01=ooool8g`08oimOWenOGil4o`03Gooo00;o00VOGimO
WenOGol01d`4o`9<0ol7C009og5nLGiaOW5n00Co00eaooooLGiaOW5nLGko00/0000:000HoimOWenO
GimOWenOGomOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmO
WenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGiooWenOoimOoenOGimOWenO00;o1ml01OoO
gmoo00;O00?ogml01ml06_nOGimOWeooGimOoenOoimOWenOGimOWeoo1T`01Om<C4co00=<00?oC4`0
1T`06_mnm7kdO_AnogkdO_mnm7kdooAnm7kdO_Co2`0000X001SoWenOGimOWenOGimOoenOGimOWenO
Gil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6=l00om<C00FC00IoenOGimOWenOGimOWenOGimO
WenOGimOo`0C000GoenOGimOWonOGiooWenOoimOWenOGil00_l7g`05omoOgol00]l00ooOg`07g`0J
oimOWenOGomOWeooGimOoenOGimOWenOGol6C006oda<C?m<1?l7C00Jog5nLGiaOW7oLGiaog5nLGko
OW5nLGiaO_l;00002P002onOGimOWenOGimO00;o00^OGimOWenOGimOW`02o`0HO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimO
WonOGiooWenOGomOWenOGil00_l7g`05omoOgol00]l00ooOg`07g`0JoimOWenOGomOWeooGimOWonO
GimOWenOGol6C009oda<C?m<odco00Q<00ooO_Anm7kdO_mnm7koO_@00_l02GkdO_Anm7kdo`0;0000
2P006?nOGimOWenOGimOWeooGimOWenOGimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03
oda<01I<01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<000SoGimOWenOG`Ko00VOGomOWenOGil0
0_l8g`Go00?Ooml02=l02?nOGimOWenO1_l035nOoimOWenOGimOo`M<1_l00dcoC007C009og5nLGia
OW5n00Go00anLGkoOW5nLGiaO_l;00002P002_nOGimOWenOGil3o`0;WenOGimOWenOGil00_l067kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmOWenOGimOWenOGimOWenOGimOWenOGol0
4`003_mOWenOGimOWenOGimO0_l01imOWenOGil00_l=g`;o2Ml03_nOGimOWenOGimOWenO0_l02UnO
GimOWenOGol=C0;o24`03_mnm7kdO_Anm7kdO_An0ol02GkdO_Anm7kdo`0;00002P006?nOGimOWenO
GimOWenOGimOWenOGimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimO
WenOGimOWenOGimOWenOGimOWeoo01<001OoGimOWenOGimOWenOGimOWenOGimOW`02oaSO01[oWenO
GimOWenOGimOWenOGimOWenOGimOoaM<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000H
oimOWenOGimOWenOGimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`0
5T`06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOGimOWenOGimOWenO00;o
6=l06_nOGimOWenOGimOWenOGimOWenOGimOWeoo5d`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimOWenOGimOWenOGimO
WenOGil00_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenOGolGC00Jog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01Qnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lHg`03oda<01I<01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<001OoGimOWenOGimO
WenOGimOWenOGimOW`02oaSO01[oWenOGimOWenOGimOWenOGimOWenOGimOoaM<01[oO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0675nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaSO00?oC4`05T`06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omO
WenOGimOWenOGimOWenOGimOWenO00;o6=l06_nOGimOWenOGimOWenOGimOWenOGimOWeoo5d`06_ma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0H
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko6=l00om<C00FC00IoenOGimOWenOGimOWenOGimOWenOGimO
o`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_lHg`0JoimOWenOGimOWenOGimOWenOGimOWenO
GolGC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenOGimOWenO
GimOW`;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHg`03oda<01I<01WoGimOWenOGimOWenOGimO
WenOGimOWeoo01<001OoGimOWenOGimOWenOGimOWenOGimOW`02oaSO01[oWenOGimOWenOGimOWenO
GimOWenOGimOoaM<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000HoimOWenOGimOWenO
GimOWenOGimOWenO0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaSO00?oC4`05T`06OmOWenOGimO
WenOGimOWenOGimOWenOGol04`005omOWenOGimOWenOGimOWenOGimOWenO00;o6=l06_nOGimOWenO
GimOWenOGimOWenOGimOWeoo5d`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2`0000X001SoWenO
GimOWenOGimOWenOGimOWenOGil2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6=l00om<C00FC00I
oenOGimOWenOGimOWenOGimOWenOGimOo`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_lHg`0J
oimOWenOGimOWenOGimOWenOGimOWenOGolGC00Jog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l;0000
2P1loa<0O?l;00002P000ooOg`0Eg`;o5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimO
WenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?ogml05=l2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGg`03oda<01I<00?o00002@0000X000?ogml0
5Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003omoO01CO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko5ml00om<C00FC003o`0000T0000:0003omoO01GO0_lGC00cog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o
039OWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaOO00?oC4`0
5T`00ol0000900002P000ooOg`0Eg`;o5d`0<omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimO
WenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?ogml05=l2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGg`03oda<01I<00?o00002@0000X000?ogml0
5Ml2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003omoO01CO0_l0<UnOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o5ml00om<C00FC003o`0000T0000:0003omoO01GO0_lGC00cogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o
039OWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaOO00?oC4`0
5T`00ol0000900002P000ooOg`0Eg`;o5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimO
WenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?ogml05=l2o`0bGimOWenOGimOWenOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlGg`03oda<01I<00?o00002@0000X000?ogml0
5Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003omoO00GO0ol<g`;o00QOWenOGimOW`?o01FOGimOWenOGimOWenOooAnm7kdO_@0
0ol03oAnm7kdO_Anm7kdO_Ano`07g`?o3Ml00om<C006C0?o3D`00ol0000900002P000ooOg`0Eg`;o
5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03
o`00014000?ogml02=l00ooOg`09g`;o039OWenOGimOWenOGomOWenOGimOWenOGiooOW5nLGiaOW5n
LOmaOW5nLGiaOW5nLGiao`[O00?ogml02]l00om<C009C003oda<00Y<00?o00002@0000X000?ogml0
1ml4o`[O0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimO
Weoo01OO00?o00004@000ooOg`05g`Co00COoooo1ml2o`08GimOWenOGil4o`03Gooo00;o00nOGimO
WenOooAnm7kdO_@01?l03Wkooomnm7kdO_Anm7ko1ml4o`04goooo`SO00?oC4`01T`4o`9<0ol7C003
o`0000T0000:0003omoO00SO00?ogml02]l2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimO
WenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO00CO00GogmoOo`02g`03omoO00KO
0_l0<UnOGimOWeooGimOoenOoimOWenOGimOWomnLGiaOW7oLGiaog5nLGkoOW5nLGiaOW7o1]l01OoO
gmoo00;O00?ogml01ml00om<C005C005oda<C?l00d`00om<C006C003o`0000T0000:0003omoO00WO
00?ogml02Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimO
WenOGol05ml00ol0000A0003omoO00CO00GogmoOo`02g`03omoO00KO0_l0<UnOGimOWeooGimOoenO
GomOWenOGimOWoodO_Anm7koO_AnogkdO_Com7kdO_Anm7ko1]l01OoOgmoo00;O00?ogml01ml00om<
C005C006oda<C?m<1?l7C003o`0000T0000:0003omoO00[O00?ogml02=l2oaM<03?oLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO00CO
00GogmoOo`02g`03omoO00KO0_l09UnOGimOWeooGimOoenOGiooWenOGimOWomnLGiaOW7oLGiaog5n
0_l02W5nLGiaOW5nLOl6g`05omoOgol00]l00ooOg`07g`03oda<00E<00WoC4a<odcoC?l024`00ol0
000900002P000ooOg`07g`04omoOo`[O0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimO
WenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`05g`Go00?Ooml01ml2o`08GimOWenO
Gil6o`0BGiooWenOGimOWoodO_Anm7kd1Ol03OAnm?odO_Anm7kdO_l01ml5o`03gooO00SO00?oC4`0
1T`6o`03C?m<00M<00?o00002@0000X000?ogml02=l2o`_O0_lGC00cog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000ooOg`0:g`;o2=l2o`0>
GimOWenOGimOWenOGil2o`0EGimOWenOGiooOW5nLGiaOW5nLGia00?o00YaOW5nLGiaOW7o3=l2o`WO
00?oC4`034`2o`Q<00?o00002@0000X000?ogml05Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO01CO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko5ml00om<C00FC003o`0000T0
000:0003omoO01GO0_lGC00cog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o039OWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaOO00?oC4`05T`00ol0000900002P000ooOg`0Eg`;o5d`0<omn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`000140
00?ogml05=l2o`0bGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lGg`03oda<01I<00?o00002@0000X000?ogml05Ml2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO01CO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o5ml00om<C00FC003o`0000T0
000:0003omoO01GO0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o039OWenOGimOWenOGimOWenOGimOWenOGioom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaOO00?oC4`05T`00ol0000900002P000ooOg`0Eg`;o5d`0<oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`000140
00?ogml05=l2o`0bGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlGg`03oda<01I<00?o00002@0000X000?ogml05Ml2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdoimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003omoO01CO0_l0<UnOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko5ml00om<C00FC003o`0000T0
000:0003omoO01GO0_lGC00cog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000ooOg`0Dg`;o039OWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaOO00?oC4`05T`00ol0000900002@1moa80OOl;00002@1moa80
OOl;00002P000ol0000D00?o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000?o00005002oaSO03;oWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?o00004`001?l0oolGg`0c
oenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o0000
4@000ol0000C00?o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o64`00ol0000900002P000ol0000B0003o`0000;o5ml0<omOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?o00004P001?l0oolHg`0b
oimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0
000:0003o`00014000Co00000_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01M<00?o00004@000ol0000A0003o`0000;o6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol0000@0003
o`0000800_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01M<00?o00004@000ol0000@0004o`0000;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ol0000200;o00<0ool020000ol0
000300;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?o00000P02o`030?oo00P000?o00000P02oaSO03;oWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?o00000`000ol0
o`080003o`0000@00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko01M<00?o00004@000ol000030003o`3o00P000?o00000`02oaSO03;oWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?o0000
10000ol000060003o`0000D00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01M<00?o00004@000ol000040003o`0000H000?o00001002o`SO0ol=g`08
oimOWenOGil3o`0FWenOGimOWenOGimOWeooLGiaOW5nL@?o00iaOW5nLGiaOW5nLGiao`Q<0ol=C003
o`0000T0000:0003o`0000<000?o0?l01P000ol0000600;o5ml0<omOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?o00000`000ol0o`060003
o`0000D00_l;g`03omoO00[O03;oWenOGimOWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Com7kd
O_Anm7kdO_Ano`]<00?oC4`02T`00ol0000900002P000ol0000200;o00<0ool010000ol0000700;o
2Ml4o`[O00_oGimOWenOGimOW`03o`0EWenOGimOWenOGiooOW5nLGiaOW5n00?o00enLGiaOW5nLGia
OW7o00Y<0_l;C003o`00014000?o00000P02o`030?oo00@000?o00001P02o`SO1?l01=ooool8g`08
oimOWenOGil4o`03Gooo00;o012OGimOWenOGomaOW5nLGia1?l03GkooomnLGiaOW5nLOl024`4o`9<
0ol7C003o`0000T0000:0003o`0000X000?o00002002o`[O00?ogml02]l0<omOWenOGimOWenOGimO
oenOGimOWenOGioom7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Ano`09C004oda<o`Y<00?o00004@000ol0
000:0003o`0000L00_l7g`05omoOgol00]l00ooOg`07g`0boimOWenOGomOWeooGiooWenOGimOWenO
Gomnm7kdO_Com7kdooAnm7koO_Anm7kdO_l7C005oda<C?l00d`00om<C006C003o`0000T0000:0003
o`0000T000?o00002@02o`_O00?ogml02Ml0<omOWenOGimOWenOGimOoenOGimOWenOGiooOW5nLGia
OW5nLOmaOW5nLGiaOW5nLGiao`09C004oda<o`Y<00?o00004@000ol000090003o`0000P00_l7g`05
omoOgol00]l00ooOg`07g`0boimOWenOGomOWeooGimOoenOGimOWenOGomaOW5nLGkoOW5nogiaOW7o
LGiaOW5nLOl7C006oda<C?m<1?l7C003o`0000T0000:0003o`0000P000Co00000ol600;o3=l00ooO
g`08g`0<oenOGimOWenOGimO0_l09ImOWenOGimOWenOooAnm7kdO_Anm7koO_Anm7kdO_Anm7kdO_l0
2D`01?m<C?l:C003o`00014000?o000020001?l00003o`D00_l7g`05omoOgol00]l00ooOg`07g`0W
oimOWenOGomOWeooGimOWonOGimOWenOGomnm7kdO_Com7kdooAn00;o00WdO_Anm7kdO_l01d`02Om<
C4coC?m<o`08C003o`0000T0000:0003o`0000L000?o00000`000ol0000500;o2Ml01?oOgol:g`0c
oenOGimOWenOGimOWeooGimOWenOGimOWomnLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o00U<00CoC4co
2T`00ol0000A0003o`0000L000?o00000`000ol0000400;o2=l5o`03gooO00SO00SoWenOGimOW`Ko
01=OWonOGimOWenOGomaOW5nLGia00Go00aaOW7oLGiaOW5nLOl8C0Ko00=<od`01d`00ol000090000
2P000ol000060003o`0000D000?o00001002o`[O0_l;g`0;oenOGimOWenOGil00ol05ImOWenOGimO
WenOooAnm7kdO_Anm002o`0>O_Anm7kdO_Anm7kdO_l:C0;o2d`00ol0000A0003o`0000H000?o0000
1@000ol0000300;o3Ml2o`WO00koWenOGimOWenOGimOW`;o01IOWenOGimOWeooO_Anm7kdO_Anm7kd
0ol02OAnm7kdO_Ano`0>C0;o24`00ol0000900002P000ol000050003o`0000H000?o00001002oaOO
03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0
000A0003o`0000D000?o00001P000ol0000300;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol000040003o`0000H000?o0?l0
1@02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
5d`00ol0000A0003o`0000@000?o00001P000ol0o`0400;o6=l0<_nOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ol000030003o`0000L0
00?o0?l01@02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl05d`00ol0000A0003o`0000<000?o00001`000ol0o`0400;o6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ol000020003
o`0000L00_l00`3oo`0400;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000?o00000P000ol0000700;o00<0ool00`02oaSO03;oWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X0
00Go0000o`0C00;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0GC003o`00014000Go0000o`0B00;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P001?l00?lD00;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000Co003o
4`02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?o00002@0000X000?o0?l05@02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003o`3o01@00_lHg`0boimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:00;o5P02oaOO03?oGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A00;o
5@02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?o00002@0000X0O?lC07co2`0002800_n<00;oKP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0003@01?m500?o@`04odD00olA0000=@000ol000160003o`0004<000?o0000
AP000ol0000@00003003o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`801Ol00`3oo`02ob`0
0_l00`3oo`0:0003o`0000P000?o00006@03o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`80
1Ol00`3oo`02ob`00_l00`3oo`090003o`3o00T000?o00003`0000d000Go0000o`020004o`00o`@0
00Go0000o`030003o`00008000Oo0000o`3o008000Co003o0`000ol0000Z0003o`3o00/000?o0000
20000ol0000J0005o`000?l00P001?l00?l40005o`000?l00`000ol000020007o`000?l0o`020004
o`00o`<000?o0000:P000ol0o`0;0003o`0000P000?o00003`0000d000Go0000o`020003o`0000Ko
00@0oooo0`000ol000020007o`000?l0o`020004o`00o`<000?o0000:`000ol0000800Go1`000ol0
o`0K0005o`000?l00P000ol00006o`040?ooo`<000?o00000P001ol0003o0?l00P001?l00?l30003
o`0002/000?o00002005o`L000?o0?l0400000/000Oo0?l0o`3o008000Co003o0`02o`L00_l30007
o`000?l0o`020004o`00o`<000?o0000:P000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l0
0P001?l00?l300;o1`02o`<000Oo0000o`3o008000Co003o0`000ol0000Z0003o`3o00/000?o0000
1`000ol0o`0@00002`001_l0o`3o00Co0`03o`030?l0008000?o00000_l00`3oo`0200?o00@0ool0
0_l00`3oo`03ob`00_l00`3oo`0:0003o`0000H00_l00`3oo`0H0006o`3o0?l01?l300?o00<0o`00
0P000ol00002o`030?oo00800ol0103oo`02o`030?oo00?o;002o`030?oo01<00_l00`3oo`0?0000
2`05o`030?l000X01?mi00Go00<0o`002P04og00000@00;oS@02ogl0003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {149.812, 0}} -> {-0.0536619, -0.0261961, 
  0.0073426, 0.0073426}, {{7.25, 137}, {146.188, 
  3.5625}} -> {-1.42043, -0.28431, 0.0404912, 0.0404912}, {{149.938, 
  279.688}, {146.188, 3.5625}} -> {-7.19803, -0.28431, 0.0404912, 
  0.0404912}},
  CellTags->"Cayley"],

Cell[BoxData[
    \({{{0, 1, 3, 2}, {1, 2, 0, 3}, {3, 0, 2, 1}, {2, 3, 1, 0}}, {{a, a**b, 
          b, a\^b}, {b, a, a\^b, a**b}, {a**b, a\^b, b, a}, {a\^b, a**b, a, 
          b}}}\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"Cayley"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["TextCayley",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(give\ a\ text\[Hyphen]only\ version\ of\ a\ 
                two\[Hyphen]dimensional\ Cayley\ table\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->"Cayley"],

Cell["\<\
While the graphical Cayley tables are usually more desirable, there \
is also a version for text-only systems.\
\>", "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TextCayley[G\_2]\)], "Input",
  CellLabel->"In[57]:=",
  CellTags->"Cayley"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\" \"\>", "\<\"|\"\>", "b", "a", \(a**b\), \(a\^b\)},
          {"\<\"-\"\>", "\<\"|\"\>", "\<\"-\"\>", "\<\"-\"\>", "\<\"-\"\>", 
            "\<\"-\"\>"},
          {"b", "\<\"|\"\>", "a", \(a**b\), "b", \(a\^b\)},
          {"a", "\<\"|\"\>", "b", "a", \(a\^b\), \(a**b\)},
          {\(a**b\), "\<\"|\"\>", \(a**b\), \(a\^b\), "b", "a"},
          {\(a\^b\), "\<\"|\"\>", \(a\^b\), \(a**b\), "a", "b"}
          },
        RowSpacings->1,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {1, 1, 0, 1, 0, 1}]&)]], "Output",
  CellLabel->"Out[57]//TableForm=",
  CellTags->"Cayley"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"Working",
WindowSize->{500, 400},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
ShowCellTags->True,
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "i:1"->{
    Cell[2738, 92, 125, 3, 68, "Subsection",
      Evaluatable->False,
      CellTags->{"i:1", "Integers"}]},
  "Integers"->{
    Cell[2738, 92, 125, 3, 68, "Subsection",
      Evaluatable->False,
      CellTags->{"i:1", "Integers"}],
    Cell[2866, 97, 201, 5, 58, "Text",
      CellTags->"Integers"],
    Cell[3070, 104, 164, 5, 60, "Subsubsection",
      CellTags->{"i:2", "Integers"}],
    Cell[3237, 111, 263, 9, 42, "Text",
      CellTags->"Integers"],
    Cell[3503, 122, 10606, 304, 202, "DefinitionBox",
      CellTags->{"i:3", "Integers"}],
    Cell[14112, 428, 123, 6, 26, "Caption",
      CellTags->"Integers"],
    Cell[14238, 436, 305, 9, 59, "Text",
      CellTags->"Integers"],
    Cell[14546, 447, 245, 9, 55, "MathCaption",
      CellTags->"Integers"],
    Cell[14816, 460, 107, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[14926, 465, 134, 3, 38, "Output",
      CellTags->"Integers"],
    Cell[15075, 471, 181, 6, 55, "MathCaption",
      CellTags->"Integers"],
    Cell[15281, 481, 115, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[15399, 486, 143, 4, 38, "Output",
      CellTags->"Integers"],
    Cell[15557, 493, 350, 13, 56, "MathCaption",
      CellTags->"Integers"],
    Cell[15932, 510, 97, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[16032, 515, 198, 5, 53, "Output",
      CellTags->"Integers"],
    Cell[16245, 523, 383, 13, 77, "Text",
      CellTags->{"i:4", "Integers"}],
    Cell[16631, 538, 13257, 341, 169, "DefinitionBox",
      CellTags->{"i:5", "Integers"}],
    Cell[29891, 881, 137, 6, 26, "Caption",
      CellTags->"Integers"],
    Cell[30031, 889, 262, 9, 40, "MathCaption",
      CellTags->"Integers"],
    Cell[30318, 902, 112, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[30433, 907, 251, 4, 94, "Print",
      CellTags->"Integers"],
    Cell[30687, 913, 15530, 434, 308, 7058, 323, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Integers"],
    Cell[46220, 1349, 134, 3, 38, "Output",
      CellTags->"Integers"],
    Cell[46369, 1355, 209, 6, 54, "MathCaption",
      CellTags->"Integers"],
    Cell[46603, 1365, 90, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[46696, 1370, 122, 3, 38, "Output",
      CellTags->"Integers"],
    Cell[46833, 1376, 186, 5, 54, "MathCaption",
      CellTags->"Integers"],
    Cell[47044, 1385, 88, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[47135, 1390, 423, 7, 113, "Output",
      CellTags->"Integers"],
    Cell[47573, 1400, 192, 5, 54, "MathCaption",
      CellTags->"Integers"],
    Cell[47790, 1409, 314, 6, 103, "Input",
      CellTags->"Integers"],
    Cell[48107, 1417, 12163, 380, 308, 3989, 273, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Integers"],
    Cell[60285, 1800, 202, 7, 56, "MathCaption",
      CellTags->"Integers"],
    Cell[60512, 1811, 217, 5, 71, "Input",
      CellTags->"Integers"],
    Cell[60732, 1818, 600, 10, 143, "Output",
      CellTags->"Integers"],
    Cell[61347, 1831, 153, 5, 43, "Text",
      CellTags->{"i:7", "Integers"}],
    Cell[61503, 1838, 16358, 427, 225, "DefinitionBox",
      CellTags->{"i:6", "Integers"}],
    Cell[77864, 2267, 144, 6, 26, "Caption",
      CellTags->"Integers"],
    Cell[78011, 2275, 466, 20, 57, "MathCaption",
      CellTags->"Integers"],
    Cell[78502, 2299, 109, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[78614, 2304, 313, 6, 83, "Output",
      CellTags->"Integers"],
    Cell[78942, 2313, 597, 27, 40, "MathCaption",
      CellTags->"Integers"],
    Cell[79564, 2344, 87, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[79654, 2349, 123, 3, 38, "Output",
      CellTags->"Integers"],
    Cell[79792, 2355, 473, 15, 69, "MathCaption",
      CellTags->"Integers"],
    Cell[80290, 2374, 155, 4, 55, "Input",
      CellTags->"Integers"],
    Cell[80448, 2380, 95, 3, 38, "Output",
      CellTags->"Integers"],
    Cell[80558, 2386, 260, 10, 56, "MathCaption",
      CellTags->"Integers"],
    Cell[80843, 2400, 125, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[80971, 2405, 186, 4, 68, "Output",
      CellTags->"Integers"],
    Cell[81172, 2412, 821, 38, 41, "MathCaption",
      CellTags->"Integers"],
    Cell[82018, 2454, 109, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[82130, 2459, 288, 6, 83, "Output",
      CellTags->"Integers"],
    Cell[82433, 2468, 170, 5, 55, "MathCaption",
      CellTags->"Integers"],
    Cell[82628, 2477, 134, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[82765, 2482, 691, 19, 54, "Output",
      CellTags->"Integers"],
    Cell[83471, 2504, 451, 19, 54, "MathCaption",
      CellTags->"Integers"],
    Cell[83947, 2527, 132, 3, 39, "Input",
      CellTags->"Integers"],
    Cell[84082, 2532, 149, 4, 53, "Output",
      CellTags->"Integers"]},
  "i:2"->{
    Cell[3070, 104, 164, 5, 60, "Subsubsection",
      CellTags->{"i:2", "Integers"}]},
  "i:3"->{
    Cell[3503, 122, 10606, 304, 202, "DefinitionBox",
      CellTags->{"i:3", "Integers"}]},
  "i:4"->{
    Cell[16245, 523, 383, 13, 77, "Text",
      CellTags->{"i:4", "Integers"}]},
  "i:5"->{
    Cell[16631, 538, 13257, 341, 169, "DefinitionBox",
      CellTags->{"i:5", "Integers"}]},
  "i:7"->{
    Cell[61347, 1831, 153, 5, 43, "Text",
      CellTags->{"i:7", "Integers"}]},
  "i:6"->{
    Cell[61503, 1838, 16358, 427, 225, "DefinitionBox",
      CellTags->{"i:6", "Integers"}]},
  "OtherNum"->{
    Cell[84246, 2539, 84, 1, 60, "Subsubsection",
      CellTags->"OtherNum"],
    Cell[84333, 2542, 707, 32, 42, "Text",
      CellTags->{"OtherNum", "i:8"}],
    Cell[85043, 2576, 18541, 499, 200, "DefinitionBox",
      CellTags->{"OtherNum", "i:9"}],
    Cell[103587, 3077, 73, 1, 26, "Caption",
      CellTags->"OtherNum"],
    Cell[103663, 3080, 149, 4, 54, "MathCaption",
      CellTags->"OtherNum"],
    Cell[103837, 3088, 180, 4, 71, "Input",
      CellTags->"OtherNum"],
    Cell[104020, 3094, 46948, 1503, 118, 19323, 1155, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherNum"],
    Cell[150983, 4600, 191, 6, 42, "Text",
      CellTags->{"OtherNum", "i:10"}],
    Cell[151177, 4608, 7622, 213, 132, "DefinitionBox",
      CellTags->{"OtherNum", "i:11"}],
    Cell[158802, 4823, 76, 1, 26, "Caption",
      CellTags->"OtherNum"],
    Cell[158881, 4826, 163, 4, 54, "MathCaption",
      CellTags->"OtherNum"],
    Cell[159069, 4834, 196, 4, 71, "Input",
      CellTags->"OtherNum"],
    Cell[159268, 4840, 40976, 1220, 119, 14832, 891, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherNum"],
    Cell[200259, 6063, 426, 17, 71, "MathCaption",
      CellTags->"OtherNum"],
    Cell[200710, 6084, 137, 3, 39, "Input",
      CellTags->"OtherNum"],
    Cell[200850, 6089, 203, 4, 68, "Output",
      CellTags->"OtherNum"],
    Cell[201068, 6096, 2283, 64, 94, "DefinitionBox",
      CellTags->{"OtherNum", "i:12"}],
    Cell[203354, 6162, 125, 5, 26, "Caption",
      CellTags->"OtherNum"],
    Cell[203482, 6169, 178, 5, 55, "MathCaption",
      CellTags->"OtherNum"],
    Cell[203685, 6178, 124, 3, 39, "Input",
      CellTags->"OtherNum"],
    Cell[203812, 6183, 294, 5, 124, "Print",
      CellTags->"OtherNum"],
    Cell[204109, 6190, 14183, 268, 308, 1859, 110, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherNum"],
    Cell[218295, 6460, 264, 5, 77, "Output",
      CellTags->"OtherNum"],
    Cell[218574, 6468, 343, 11, 85, "MathCaption",
      CellTags->"OtherNum"],
    Cell[218942, 6483, 241, 6, 87, "Input",
      CellTags->"OtherNum"],
    Cell[219186, 6491, 190, 4, 53, "Output",
      CellTags->"OtherNum"]},
  "i:8"->{
    Cell[84333, 2542, 707, 32, 42, "Text",
      CellTags->{"OtherNum", "i:8"}]},
  "i:9"->{
    Cell[85043, 2576, 18541, 499, 200, "DefinitionBox",
      CellTags->{"OtherNum", "i:9"}]},
  "i:10"->{
    Cell[150983, 4600, 191, 6, 42, "Text",
      CellTags->{"OtherNum", "i:10"}]},
  "i:11"->{
    Cell[151177, 4608, 7622, 213, 132, "DefinitionBox",
      CellTags->{"OtherNum", "i:11"}]},
  "i:12"->{
    Cell[201068, 6096, 2283, 64, 94, "DefinitionBox",
      CellTags->{"OtherNum", "i:12"}]},
  "Permutations"->{
    Cell[219391, 6498, 91, 1, 60, "Subsubsection",
      CellTags->{"Permutations", "i:13"}],
    Cell[219485, 6501, 931, 34, 92, "Text",
      CellTags->"Permutations"],
    Cell[220419, 6537, 16244, 455, 293, "DefinitionBox",
      CellTags->{"Permutations", "i:14"}],
    Cell[236666, 6994, 138, 5, 26, "Caption",
      CellTags->"Permutations"],
    Cell[236807, 7001, 118, 4, 42, "Text",
      CellTags->"Permutations"],
    Cell[236928, 7007, 5883, 163, 144, "DefinitionBox3Col",
      CellTags->{"Permutations", "i:16"}],
    Cell[242814, 7172, 134, 6, 26, "Caption",
      CellTags->"Permutations"],
    Cell[242951, 7180, 235, 7, 54, "MathCaption",
      CellTags->"Permutations"],
    Cell[243211, 7191, 107, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[243321, 7196, 189, 4, 68, "Output",
      CellTags->"Permutations"],
    Cell[243525, 7203, 340, 11, 71, "MathCaption",
      CellTags->"Permutations"],
    Cell[243890, 7218, 108, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[244001, 7223, 154, 4, 53, "Output",
      CellTags->"Permutations"],
    Cell[244170, 7230, 216, 7, 56, "MathCaption",
      CellTags->"Permutations"],
    Cell[244411, 7241, 98, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[244512, 7246, 98, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[244625, 7252, 594, 22, 70, "MathCaption",
      CellTags->"Permutations"],
    Cell[245244, 7278, 110, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[245357, 7283, 96, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[245468, 7289, 345, 9, 83, "MathCaption",
      CellTags->"Permutations"],
    Cell[245838, 7302, 184, 4, 71, "Input",
      CellTags->"Permutations"],
    Cell[246025, 7308, 96, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[246136, 7314, 363, 12, 69, "MathCaption",
      CellTags->"Permutations"],
    Cell[246524, 7330, 98, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[246625, 7335, 371, 6, 115, "Message",
      CellTags->"Permutations"],
    Cell[246999, 7343, 94, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[247108, 7349, 174, 5, 55, "MathCaption",
      CellTags->"Permutations"],
    Cell[247307, 7358, 126, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[247436, 7363, 126, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[247577, 7369, 150, 4, 54, "MathCaption",
      CellTags->{"Permutations", "i:17"}],
    Cell[247752, 7377, 137, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[247892, 7382, 178, 4, 53, "Output",
      CellTags->"Permutations"],
    Cell[248085, 7389, 152, 3, 40, "MathCaption",
      CellTags->"Permutations"],
    Cell[248262, 7396, 148, 4, 39, "Input",
      CellTags->"Permutations"],
    Cell[248413, 7402, 331, 6, 68, "Output",
      CellTags->"Permutations"],
    Cell[248759, 7411, 101, 1, 40, "MathCaption",
      CellTags->"Permutations"],
    Cell[248885, 7416, 182, 4, 39, "Input",
      CellTags->"Permutations"],
    Cell[249070, 7422, 116, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[249201, 7428, 95, 1, 40, "MathCaption",
      CellTags->"Permutations"],
    Cell[249321, 7433, 291, 6, 71, "Input",
      CellTags->"Permutations"],
    Cell[249615, 7441, 116, 3, 38, "Output",
      CellTags->"Permutations"],
    Cell[249746, 7447, 357, 8, 76, "Text",
      CellTags->{"Permutations", "i:18"}],
    Cell[250106, 7457, 9020, 253, 178, "DefinitionBox",
      CellTags->{"Permutations", "i:19"}],
    Cell[259129, 7712, 140, 5, 26, "Caption",
      CellTags->"Permutations"],
    Cell[259272, 7719, 243, 7, 54, "MathCaption",
      CellTags->"Permutations"],
    Cell[259540, 7730, 108, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[259651, 7735, 305, 6, 98, "Output",
      CellTags->"Permutations"],
    Cell[259971, 7744, 93, 1, 40, "MathCaption",
      CellTags->"Permutations"],
    Cell[260089, 7749, 122, 3, 39, "Input",
      CellTags->"Permutations"],
    Cell[260214, 7754, 166, 4, 53, "Output",
      CellTags->"Permutations"]},
  "i:13"->{
    Cell[219391, 6498, 91, 1, 60, "Subsubsection",
      CellTags->{"Permutations", "i:13"}]},
  "i:14"->{
    Cell[220419, 6537, 16244, 455, 293, "DefinitionBox",
      CellTags->{"Permutations", "i:14"}]},
  "i:16"->{
    Cell[236928, 7007, 5883, 163, 144, "DefinitionBox3Col",
      CellTags->{"Permutations", "i:16"}]},
  "i:17"->{
    Cell[247577, 7369, 150, 4, 54, "MathCaption",
      CellTags->{"Permutations", "i:17"}]},
  "i:18"->{
    Cell[249746, 7447, 357, 8, 76, "Text",
      CellTags->{"Permutations", "i:18"}]},
  "i:19"->{
    Cell[250106, 7457, 9020, 253, 178, "DefinitionBox",
      CellTags->{"Permutations", "i:19"}]},
  "Dihedral"->{
    Cell[260395, 7761, 91, 1, 60, "Subsubsection",
      CellTags->{"Dihedral", "i:20"}],
    Cell[260489, 7764, 147, 4, 58, "Text",
      CellTags->"Dihedral"],
    Cell[260639, 7770, 11530, 328, 225, "DefinitionBox",
      CellTags->{"Dihedral", "i:21"}],
    Cell[272172, 8100, 144, 6, 26, "Caption",
      CellTags->"Dihedral"],
    Cell[272319, 8108, 7526, 202, 178, "DefinitionBox3Col",
      CellTags->{"Dihedral", "i:22"}],
    Cell[279848, 8312, 137, 6, 26, "Caption",
      CellTags->"Dihedral"],
    Cell[279988, 8320, 738, 22, 112, "MathCaption",
      CellTags->"Dihedral"],
    Cell[280751, 8346, 120, 3, 39, "Input",
      CellTags->"Dihedral"],
    Cell[280874, 8351, 397, 6, 139, "Print",
      CellTags->"Dihedral"],
    Cell[281274, 8359, 290, 5, 94, "Print",
      CellTags->"Dihedral"],
    Cell[281567, 8366, 33314, 466, 270, 923, 60, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Dihedral"],
    Cell[314884, 8834, 159, 4, 55, "Output",
      CellTags->"Dihedral"],
    Cell[315058, 8841, 152, 5, 41, "MathCaption",
      CellTags->"Dihedral"],
    Cell[315235, 8850, 99, 3, 39, "Input",
      CellTags->"Dihedral"],
    Cell[315337, 8855, 179, 4, 53, "Output",
      CellTags->"Dihedral"],
    Cell[315531, 8862, 171, 7, 41, "MathCaption",
      CellTags->"Dihedral"],
    Cell[315727, 8873, 126, 3, 39, "Input",
      CellTags->"Dihedral"],
    Cell[315856, 8878, 185, 4, 68, "Output",
      CellTags->"Dihedral"],
    Cell[316056, 8885, 250, 7, 55, "MathCaption",
      CellTags->"Dihedral"],
    Cell[316331, 8896, 178, 5, 55, "Input",
      CellTags->"Dihedral"],
    Cell[316512, 8903, 395, 7, 74, "Output",
      CellTags->"Dihedral"],
    Cell[316922, 8913, 246, 8, 57, "MathCaption",
      CellTags->"Dihedral"],
    Cell[317193, 8925, 86, 3, 39, "Input",
      CellTags->"Dihedral"],
    Cell[317282, 8930, 182, 4, 72, "Output",
      CellTags->"Dihedral"],
    Cell[317479, 8937, 162, 5, 41, "MathCaption",
      CellTags->"Dihedral"],
    Cell[317666, 8946, 109, 3, 43, "Input",
      CellTags->"Dihedral"],
    Cell[317778, 8951, 92, 3, 38, "Output",
      CellTags->"Dihedral"],
    Cell[317885, 8957, 464, 13, 75, "Text",
      CellTags->{"Dihedral", "i:23"}],
    Cell[318352, 8972, 5910, 172, 154, "DefinitionBox",
      CellTags->{"Dihedral", "i:24"}],
    Cell[324265, 9146, 148, 7, 26, "Caption",
      CellTags->"Dihedral"],
    Cell[324416, 9155, 102, 1, 40, "MathCaption",
      CellTags->"Dihedral"],
    Cell[324543, 9160, 91, 3, 39, "Input",
      CellTags->"Dihedral"],
    Cell[324637, 9165, 171, 4, 40, "Output",
      CellTags->"Dihedral"],
    Cell[324823, 9172, 120, 4, 40, "MathCaption",
      CellTags->"Dihedral"],
    Cell[324968, 9180, 136, 3, 39, "Input",
      CellTags->"Dihedral"],
    Cell[325107, 9185, 207, 4, 40, "Output",
      CellTags->"Dihedral"],
    Cell[325329, 9192, 237, 6, 55, "MathCaption",
      CellTags->"Dihedral"],
    Cell[325591, 9202, 167, 4, 39, "Input",
      CellTags->"Dihedral"],
    Cell[325761, 9208, 381, 6, 139, "Print",
      CellTags->"Dihedral"],
    Cell[326145, 9216, 15861, 417, 308, 7202, 304, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Dihedral"],
    Cell[342009, 9635, 160, 4, 40, "Output",
      CellTags->"Dihedral"]},
  "i:20"->{
    Cell[260395, 7761, 91, 1, 60, "Subsubsection",
      CellTags->{"Dihedral", "i:20"}]},
  "i:21"->{
    Cell[260639, 7770, 11530, 328, 225, "DefinitionBox",
      CellTags->{"Dihedral", "i:21"}]},
  "i:22"->{
    Cell[272319, 8108, 7526, 202, 178, "DefinitionBox3Col",
      CellTags->{"Dihedral", "i:22"}]},
  "i:23"->{
    Cell[317885, 8957, 464, 13, 75, "Text",
      CellTags->{"Dihedral", "i:23"}]},
  "i:24"->{
    Cell[318352, 8972, 5910, 172, 154, "DefinitionBox",
      CellTags->{"Dihedral", "i:24"}]},
  "OtherGroupoids"->{
    Cell[342184, 9642, 76, 1, 60, "Subsubsection",
      CellTags->"OtherGroupoids"],
    Cell[342263, 9645, 119, 4, 42, "Text",
      CellTags->"OtherGroupoids"],
    Cell[342385, 9651, 7128, 185, 221, "DefinitionBox",
      CellTags->{"OtherGroupoids", "i:25"}],
    Cell[349516, 9838, 73, 1, 26, "Caption",
      CellTags->"OtherGroupoids"],
    Cell[349592, 9841, 195, 7, 41, "MathCaption",
      CellTags->"OtherGroupoids"],
    Cell[349812, 9852, 134, 3, 39, "Input",
      CellTags->"OtherGroupoids"],
    Cell[349949, 9857, 215, 4, 67, "Message",
      CellTags->"OtherGroupoids"],
    Cell[350167, 9863, 56698, 949, 308, 5280, 308, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherGroupoids"],
    Cell[406868, 10814, 186, 4, 38, "Output",
      CellTags->"OtherGroupoids"],
    Cell[407069, 10821, 194, 6, 40, "MathCaption",
      CellTags->"OtherGroupoids"],
    Cell[407288, 10831, 118, 3, 39, "Input",
      CellTags->"OtherGroupoids"],
    Cell[407409, 10836, 215, 4, 67, "Message",
      CellTags->"OtherGroupoids"],
    Cell[407627, 10842, 147, 3, 35, "Message",
      CellTags->"OtherGroupoids"],
    Cell[407777, 10847, 96, 3, 38, "Output",
      CellTags->"OtherGroupoids"],
    Cell[407888, 10853, 205, 6, 55, "MathCaption",
      CellTags->"OtherGroupoids"],
    Cell[408118, 10863, 124, 3, 39, "Input",
      CellTags->"OtherGroupoids"],
    Cell[408245, 10868, 124, 3, 38, "Output",
      CellTags->"OtherGroupoids"],
    Cell[408384, 10874, 199, 7, 55, "MathCaption",
      CellTags->"OtherGroupoids"],
    Cell[408608, 10885, 105, 3, 39, "Input",
      CellTags->"OtherGroupoids"],
    Cell[408716, 10890, 331, 6, 83, "Output",
      CellTags->"OtherGroupoids"],
    Cell[409062, 10899, 152, 4, 54, "MathCaption",
      CellTags->"OtherGroupoids"],
    Cell[409239, 10907, 183, 4, 55, "Input",
      CellTags->"OtherGroupoids"],
    Cell[409425, 10913, 262, 5, 83, "Message",
      CellTags->"OtherGroupoids"],
    Cell[409690, 10920, 267, 6, 83, "Output",
      CellTags->"OtherGroupoids"]},
  "i:25"->{
    Cell[342385, 9651, 7128, 185, 221, "DefinitionBox",
      CellTags->{"OtherGroupoids", "i:25"}]},
  "Cayley"->{
    Cell[409972, 10929, 72, 1, 68, "Subsection",
      CellTags->"Cayley"],
    Cell[410047, 10932, 222, 5, 58, "Text",
      CellTags->{"Cayley", "i:26"}],
    Cell[410272, 10939, 27680, 763, 342, "DefinitionBox",
      CellTags->{"Cayley", "i:27"}],
    Cell[437955, 11704, 133, 6, 26, "Caption",
      CellTags->"Cayley"],
    Cell[438091, 11712, 303, 7, 75, "Text",
      CellTags->"Cayley"],
    Cell[438397, 11721, 18795, 523, 403, "DefinitionBox3Col",
      CellTags->{"Cayley", "i:28"}],
    Cell[457195, 12246, 138, 6, 26, "Caption",
      CellTags->"Cayley"],
    Cell[457336, 12254, 221, 9, 40, "MathCaption",
      CellTags->"Cayley"],
    Cell[457582, 12267, 373, 8, 154, "Input",
      CellTags->"Cayley"],
    Cell[457958, 12277, 172, 4, 55, "Output",
      CellTags->"Cayley"],
    Cell[458145, 12284, 242, 8, 55, "MathCaption",
      CellTags->"Cayley"],
    Cell[458412, 12296, 118, 3, 39, "Input",
      CellTags->"Cayley"],
    Cell[458533, 12301, 56971, 952, 308, 5282, 308, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[515507, 13255, 137, 3, 38, "Output",
      CellTags->"Cayley"],
    Cell[515659, 13261, 207, 5, 55, "MathCaption",
      CellTags->{"Cayley", "i:29"}],
    Cell[515891, 13270, 118, 3, 39, "Input",
      CellTags->"Cayley"],
    Cell[516012, 13275, 166, 3, 49, "Print",
      CellTags->"Cayley"],
    Cell[516181, 13280, 57862, 963, 308, 5306, 308, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[574046, 14245, 170, 4, 57, "Output",
      CellTags->"Cayley"],
    Cell[574231, 14252, 177, 5, 55, "MathCaption",
      CellTags->{"Cayley", "i:30"}],
    Cell[574433, 14261, 301, 6, 87, "Input",
      CellTags->"Cayley"],
    Cell[574737, 14269, 50536, 1125, 308, 7357, 586, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[625276, 15396, 137, 3, 38, "Output",
      CellTags->"Cayley"],
    Cell[625428, 15402, 142, 4, 54, "MathCaption",
      CellTags->"Cayley"],
    Cell[625595, 15410, 368, 7, 103, "Input",
      CellTags->"Cayley"],
    Cell[625966, 15419, 204, 4, 64, "Print",
      CellTags->"Cayley"],
    Cell[626173, 15425, 59133, 982, 306, 5508, 314, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[685309, 16409, 170, 4, 51, "Output",
      CellTags->"Cayley"],
    Cell[685494, 16416, 339, 9, 70, "MathCaption",
      CellTags->{"Cayley", "i:31"}],
    Cell[685858, 16429, 131, 3, 38, "Input",
      CellTags->"Cayley"],
    Cell[685992, 16434, 43006, 986, 173, 9808, 569, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[729001, 17422, 185, 4, 47, "Output",
      CellTags->"Cayley"],
    Cell[729201, 17429, 140, 5, 41, "MathCaption",
      CellTags->"Cayley"],
    Cell[729366, 17438, 192, 4, 70, "Input",
      CellTags->"Cayley"],
    Cell[729561, 17444, 42686, 1021, 169, 10384, 616, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[772250, 18467, 243, 5, 66, "Output",
      CellTags->"Cayley"],
    Cell[772508, 18475, 128, 4, 40, "MathCaption",
      CellTags->"Cayley"],
    Cell[772661, 18483, 199, 5, 70, "Input",
      CellTags->"Cayley"],
    Cell[772863, 18490, 42686, 1021, 169, 10384, 616, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Cayley"],
    Cell[815552, 19513, 243, 5, 66, "Output",
      CellTags->"Cayley"],
    Cell[815810, 19521, 556, 18, 51, "DefinitionBox",
      CellTags->"Cayley"],
    Cell[816369, 19541, 163, 4, 54, "MathCaption",
      CellTags->"Cayley"],
    Cell[816557, 19549, 96, 3, 38, "Input",
      CellTags->"Cayley"],
    Cell[816656, 19554, 716, 16, 136, "Output",
      CellTags->"Cayley"]},
  "i:26"->{
    Cell[410047, 10932, 222, 5, 58, "Text",
      CellTags->{"Cayley", "i:26"}]},
  "i:27"->{
    Cell[410272, 10939, 27680, 763, 342, "DefinitionBox",
      CellTags->{"Cayley", "i:27"}]},
  "i:28"->{
    Cell[438397, 11721, 18795, 523, 403, "DefinitionBox3Col",
      CellTags->{"Cayley", "i:28"}]},
  "i:29"->{
    Cell[515659, 13261, 207, 5, 55, "MathCaption",
      CellTags->{"Cayley", "i:29"}]},
  "i:30"->{
    Cell[574231, 14252, 177, 5, 55, "MathCaption",
      CellTags->{"Cayley", "i:30"}]},
  "i:31"->{
    Cell[685494, 16416, 339, 9, 70, "MathCaption",
      CellTags->{"Cayley", "i:31"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"i:1", 818275, 19597},
  {"Integers", 818401, 19601},
  {"i:2", 823065, 19725},
  {"i:3", 823164, 19728},
  {"i:4", 823268, 19731},
  {"i:5", 823360, 19734},
  {"i:7", 823465, 19737},
  {"i:6", 823557, 19740},
  {"OtherNum", 823668, 19743},
  {"i:8", 825871, 19799},
  {"i:9", 825964, 19802},
  {"i:10", 826071, 19805},
  {"i:11", 826166, 19808},
  {"i:12", 826274, 19811},
  {"Permutations", 826388, 19814},
  {"i:13", 830452, 19915},
  {"i:14", 830559, 19918},
  {"i:16", 830672, 19921},
  {"i:17", 830788, 19924},
  {"i:18", 830894, 19927},
  {"i:19", 830993, 19930},
  {"Dihedral", 831109, 19933},
  {"i:20", 834387, 20018},
  {"i:21", 834490, 20021},
  {"i:22", 834599, 20024},
  {"i:23", 834711, 20027},
  {"i:24", 834807, 20030},
  {"OtherGroupoids", 834925, 20033},
  {"i:25", 836975, 20083},
  {"Cayley", 837091, 20086},
  {"i:26", 840826, 20182},
  {"i:27", 840920, 20185},
  {"i:28", 841028, 20188},
  {"i:29", 841140, 20191},
  {"i:30", 841241, 20194},
  {"i:31", 841342, 20197}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 830, 30, 89, "Subsubtitle",
  Evaluatable->False],
Cell[2564, 83, 171, 7, 95, "Section",
  Evaluatable->False],
Cell[2738, 92, 125, 3, 68, "Subsection",
  Evaluatable->False,
  CellTags->{"i:1", "Integers"}],
Cell[2866, 97, 201, 5, 58, "Text",
  CellTags->"Integers"],
Cell[3070, 104, 164, 5, 60, "Subsubsection",
  CellTags->{"i:2", "Integers"}],
Cell[3237, 111, 263, 9, 42, "Text",
  CellTags->"Integers"],
Cell[3503, 122, 10606, 304, 202, "DefinitionBox",
  CellTags->{"i:3", "Integers"}],
Cell[14112, 428, 123, 6, 26, "Caption",
  CellTags->"Integers"],
Cell[14238, 436, 305, 9, 59, "Text",
  CellTags->"Integers"],
Cell[14546, 447, 245, 9, 55, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[14816, 460, 107, 3, 39, "Input",
  CellTags->"Integers"],
Cell[14926, 465, 134, 3, 38, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[15075, 471, 181, 6, 55, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[15281, 481, 115, 3, 39, "Input",
  CellTags->"Integers"],
Cell[15399, 486, 143, 4, 38, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[15557, 493, 350, 13, 56, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[15932, 510, 97, 3, 39, "Input",
  CellTags->"Integers"],
Cell[16032, 515, 198, 5, 53, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[16245, 523, 383, 13, 77, "Text",
  CellTags->{"i:4", "Integers"}],
Cell[16631, 538, 13257, 341, 169, "DefinitionBox",
  CellTags->{"i:5", "Integers"}],
Cell[29891, 881, 137, 6, 26, "Caption",
  CellTags->"Integers"],
Cell[30031, 889, 262, 9, 40, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[30318, 902, 112, 3, 39, "Input",
  CellTags->"Integers"],
Cell[30433, 907, 251, 4, 94, "Print",
  CellTags->"Integers"],
Cell[30687, 913, 15530, 434, 308, 7058, 323, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Integers"],
Cell[46220, 1349, 134, 3, 38, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[46369, 1355, 209, 6, 54, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[46603, 1365, 90, 3, 39, "Input",
  CellTags->"Integers"],
Cell[46696, 1370, 122, 3, 38, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[46833, 1376, 186, 5, 54, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[47044, 1385, 88, 3, 39, "Input",
  CellTags->"Integers"],
Cell[47135, 1390, 423, 7, 113, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[47573, 1400, 192, 5, 54, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[47790, 1409, 314, 6, 103, "Input",
  CellTags->"Integers"],
Cell[48107, 1417, 12163, 380, 308, 3989, 273, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Integers"]
}, Open  ]],
Cell[60285, 1800, 202, 7, 56, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[60512, 1811, 217, 5, 71, "Input",
  CellTags->"Integers"],
Cell[60732, 1818, 600, 10, 143, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[61347, 1831, 153, 5, 43, "Text",
  CellTags->{"i:7", "Integers"}],
Cell[61503, 1838, 16358, 427, 225, "DefinitionBox",
  CellTags->{"i:6", "Integers"}],
Cell[77864, 2267, 144, 6, 26, "Caption",
  CellTags->"Integers"],
Cell[78011, 2275, 466, 20, 57, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[78502, 2299, 109, 3, 39, "Input",
  CellTags->"Integers"],
Cell[78614, 2304, 313, 6, 83, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[78942, 2313, 597, 27, 40, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[79564, 2344, 87, 3, 39, "Input",
  CellTags->"Integers"],
Cell[79654, 2349, 123, 3, 38, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[79792, 2355, 473, 15, 69, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[80290, 2374, 155, 4, 55, "Input",
  CellTags->"Integers"],
Cell[80448, 2380, 95, 3, 38, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[80558, 2386, 260, 10, 56, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[80843, 2400, 125, 3, 39, "Input",
  CellTags->"Integers"],
Cell[80971, 2405, 186, 4, 68, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[81172, 2412, 821, 38, 41, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[82018, 2454, 109, 3, 39, "Input",
  CellTags->"Integers"],
Cell[82130, 2459, 288, 6, 83, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[82433, 2468, 170, 5, 55, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[82628, 2477, 134, 3, 39, "Input",
  CellTags->"Integers"],
Cell[82765, 2482, 691, 19, 54, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[83471, 2504, 451, 19, 54, "MathCaption",
  CellTags->"Integers"],

Cell[CellGroupData[{
Cell[83947, 2527, 132, 3, 39, "Input",
  CellTags->"Integers"],
Cell[84082, 2532, 149, 4, 53, "Output",
  CellTags->"Integers"]
}, Open  ]],
Cell[84246, 2539, 84, 1, 60, "Subsubsection",
  CellTags->"OtherNum"],
Cell[84333, 2542, 707, 32, 42, "Text",
  CellTags->{"OtherNum", "i:8"}],
Cell[85043, 2576, 18541, 499, 200, "DefinitionBox",
  CellTags->{"OtherNum", "i:9"}],
Cell[103587, 3077, 73, 1, 26, "Caption",
  CellTags->"OtherNum"],
Cell[103663, 3080, 149, 4, 54, "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{
Cell[103837, 3088, 180, 4, 71, "Input",
  CellTags->"OtherNum"],
Cell[104020, 3094, 46948, 1503, 118, 19323, 1155, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherNum"]
}, Open  ]],
Cell[150983, 4600, 191, 6, 42, "Text",
  CellTags->{"OtherNum", "i:10"}],
Cell[151177, 4608, 7622, 213, 132, "DefinitionBox",
  CellTags->{"OtherNum", "i:11"}],
Cell[158802, 4823, 76, 1, 26, "Caption",
  CellTags->"OtherNum"],
Cell[158881, 4826, 163, 4, 54, "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{
Cell[159069, 4834, 196, 4, 71, "Input",
  CellTags->"OtherNum"],
Cell[159268, 4840, 40976, 1220, 119, 14832, 891, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherNum"]
}, Open  ]],
Cell[200259, 6063, 426, 17, 71, "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{
Cell[200710, 6084, 137, 3, 39, "Input",
  CellTags->"OtherNum"],
Cell[200850, 6089, 203, 4, 68, "Output",
  CellTags->"OtherNum"]
}, Open  ]],
Cell[201068, 6096, 2283, 64, 94, "DefinitionBox",
  CellTags->{"OtherNum", "i:12"}],
Cell[203354, 6162, 125, 5, 26, "Caption",
  CellTags->"OtherNum"],
Cell[203482, 6169, 178, 5, 55, "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{
Cell[203685, 6178, 124, 3, 39, "Input",
  CellTags->"OtherNum"],
Cell[203812, 6183, 294, 5, 124, "Print",
  CellTags->"OtherNum"],
Cell[204109, 6190, 14183, 268, 308, 1859, 110, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherNum"],
Cell[218295, 6460, 264, 5, 77, "Output",
  CellTags->"OtherNum"]
}, Open  ]],
Cell[218574, 6468, 343, 11, 85, "MathCaption",
  CellTags->"OtherNum"],

Cell[CellGroupData[{
Cell[218942, 6483, 241, 6, 87, "Input",
  CellTags->"OtherNum"],
Cell[219186, 6491, 190, 4, 53, "Output",
  CellTags->"OtherNum"]
}, Open  ]],
Cell[219391, 6498, 91, 1, 60, "Subsubsection",
  CellTags->{"Permutations", "i:13"}],
Cell[219485, 6501, 931, 34, 92, "Text",
  CellTags->"Permutations"],
Cell[220419, 6537, 16244, 455, 293, "DefinitionBox",
  CellTags->{"Permutations", "i:14"}],
Cell[236666, 6994, 138, 5, 26, "Caption",
  CellTags->"Permutations"],
Cell[236807, 7001, 118, 4, 42, "Text",
  CellTags->"Permutations"],
Cell[236928, 7007, 5883, 163, 144, "DefinitionBox3Col",
  CellTags->{"Permutations", "i:16"}],
Cell[242814, 7172, 134, 6, 26, "Caption",
  CellTags->"Permutations"],
Cell[242951, 7180, 235, 7, 54, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[243211, 7191, 107, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[243321, 7196, 189, 4, 68, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[243525, 7203, 340, 11, 71, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[243890, 7218, 108, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[244001, 7223, 154, 4, 53, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[244170, 7230, 216, 7, 56, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[244411, 7241, 98, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[244512, 7246, 98, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[244625, 7252, 594, 22, 70, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[245244, 7278, 110, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[245357, 7283, 96, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[245468, 7289, 345, 9, 83, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[245838, 7302, 184, 4, 71, "Input",
  CellTags->"Permutations"],
Cell[246025, 7308, 96, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[246136, 7314, 363, 12, 69, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[246524, 7330, 98, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[246625, 7335, 371, 6, 115, "Message",
  CellTags->"Permutations"],
Cell[246999, 7343, 94, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[247108, 7349, 174, 5, 55, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[247307, 7358, 126, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[247436, 7363, 126, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[247577, 7369, 150, 4, 54, "MathCaption",
  CellTags->{"Permutations", "i:17"}],

Cell[CellGroupData[{
Cell[247752, 7377, 137, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[247892, 7382, 178, 4, 53, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[248085, 7389, 152, 3, 40, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[248262, 7396, 148, 4, 39, "Input",
  CellTags->"Permutations"],
Cell[248413, 7402, 331, 6, 68, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[248759, 7411, 101, 1, 40, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[248885, 7416, 182, 4, 39, "Input",
  CellTags->"Permutations"],
Cell[249070, 7422, 116, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[249201, 7428, 95, 1, 40, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[249321, 7433, 291, 6, 71, "Input",
  CellTags->"Permutations"],
Cell[249615, 7441, 116, 3, 38, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[249746, 7447, 357, 8, 76, "Text",
  CellTags->{"Permutations", "i:18"}],
Cell[250106, 7457, 9020, 253, 178, "DefinitionBox",
  CellTags->{"Permutations", "i:19"}],
Cell[259129, 7712, 140, 5, 26, "Caption",
  CellTags->"Permutations"],
Cell[259272, 7719, 243, 7, 54, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[259540, 7730, 108, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[259651, 7735, 305, 6, 98, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[259971, 7744, 93, 1, 40, "MathCaption",
  CellTags->"Permutations"],

Cell[CellGroupData[{
Cell[260089, 7749, 122, 3, 39, "Input",
  CellTags->"Permutations"],
Cell[260214, 7754, 166, 4, 53, "Output",
  CellTags->"Permutations"]
}, Open  ]],
Cell[260395, 7761, 91, 1, 60, "Subsubsection",
  CellTags->{"Dihedral", "i:20"}],
Cell[260489, 7764, 147, 4, 58, "Text",
  CellTags->"Dihedral"],
Cell[260639, 7770, 11530, 328, 225, "DefinitionBox",
  CellTags->{"Dihedral", "i:21"}],
Cell[272172, 8100, 144, 6, 26, "Caption",
  CellTags->"Dihedral"],
Cell[272319, 8108, 7526, 202, 178, "DefinitionBox3Col",
  CellTags->{"Dihedral", "i:22"}],
Cell[279848, 8312, 137, 6, 26, "Caption",
  CellTags->"Dihedral"],
Cell[279988, 8320, 738, 22, 112, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[280751, 8346, 120, 3, 39, "Input",
  CellTags->"Dihedral"],
Cell[280874, 8351, 397, 6, 139, "Print",
  CellTags->"Dihedral"],
Cell[281274, 8359, 290, 5, 94, "Print",
  CellTags->"Dihedral"],
Cell[281567, 8366, 33314, 466, 270, 923, 60, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Dihedral"],
Cell[314884, 8834, 159, 4, 55, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[315058, 8841, 152, 5, 41, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[315235, 8850, 99, 3, 39, "Input",
  CellTags->"Dihedral"],
Cell[315337, 8855, 179, 4, 53, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[315531, 8862, 171, 7, 41, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[315727, 8873, 126, 3, 39, "Input",
  CellTags->"Dihedral"],
Cell[315856, 8878, 185, 4, 68, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[316056, 8885, 250, 7, 55, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[316331, 8896, 178, 5, 55, "Input",
  CellTags->"Dihedral"],
Cell[316512, 8903, 395, 7, 74, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[316922, 8913, 246, 8, 57, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[317193, 8925, 86, 3, 39, "Input",
  CellTags->"Dihedral"],
Cell[317282, 8930, 182, 4, 72, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[317479, 8937, 162, 5, 41, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[317666, 8946, 109, 3, 43, "Input",
  CellTags->"Dihedral"],
Cell[317778, 8951, 92, 3, 38, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[317885, 8957, 464, 13, 75, "Text",
  CellTags->{"Dihedral", "i:23"}],
Cell[318352, 8972, 5910, 172, 154, "DefinitionBox",
  CellTags->{"Dihedral", "i:24"}],
Cell[324265, 9146, 148, 7, 26, "Caption",
  CellTags->"Dihedral"],
Cell[324416, 9155, 102, 1, 40, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[324543, 9160, 91, 3, 39, "Input",
  CellTags->"Dihedral"],
Cell[324637, 9165, 171, 4, 40, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[324823, 9172, 120, 4, 40, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[324968, 9180, 136, 3, 39, "Input",
  CellTags->"Dihedral"],
Cell[325107, 9185, 207, 4, 40, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[325329, 9192, 237, 6, 55, "MathCaption",
  CellTags->"Dihedral"],

Cell[CellGroupData[{
Cell[325591, 9202, 167, 4, 39, "Input",
  CellTags->"Dihedral"],
Cell[325761, 9208, 381, 6, 139, "Print",
  CellTags->"Dihedral"],
Cell[326145, 9216, 15861, 417, 308, 7202, 304, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Dihedral"],
Cell[342009, 9635, 160, 4, 40, "Output",
  CellTags->"Dihedral"]
}, Open  ]],
Cell[342184, 9642, 76, 1, 60, "Subsubsection",
  CellTags->"OtherGroupoids"],
Cell[342263, 9645, 119, 4, 42, "Text",
  CellTags->"OtherGroupoids"],
Cell[342385, 9651, 7128, 185, 221, "DefinitionBox",
  CellTags->{"OtherGroupoids", "i:25"}],
Cell[349516, 9838, 73, 1, 26, "Caption",
  CellTags->"OtherGroupoids"],
Cell[349592, 9841, 195, 7, 41, "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{
Cell[349812, 9852, 134, 3, 39, "Input",
  CellTags->"OtherGroupoids"],
Cell[349949, 9857, 215, 4, 67, "Message",
  CellTags->"OtherGroupoids"],
Cell[350167, 9863, 56698, 949, 308, 5280, 308, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherGroupoids"],
Cell[406868, 10814, 186, 4, 38, "Output",
  CellTags->"OtherGroupoids"]
}, Open  ]],
Cell[407069, 10821, 194, 6, 40, "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{
Cell[407288, 10831, 118, 3, 39, "Input",
  CellTags->"OtherGroupoids"],
Cell[407409, 10836, 215, 4, 67, "Message",
  CellTags->"OtherGroupoids"],
Cell[407627, 10842, 147, 3, 35, "Message",
  CellTags->"OtherGroupoids"],
Cell[407777, 10847, 96, 3, 38, "Output",
  CellTags->"OtherGroupoids"]
}, Open  ]],
Cell[407888, 10853, 205, 6, 55, "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{
Cell[408118, 10863, 124, 3, 39, "Input",
  CellTags->"OtherGroupoids"],
Cell[408245, 10868, 124, 3, 38, "Output",
  CellTags->"OtherGroupoids"]
}, Open  ]],
Cell[408384, 10874, 199, 7, 55, "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{
Cell[408608, 10885, 105, 3, 39, "Input",
  CellTags->"OtherGroupoids"],
Cell[408716, 10890, 331, 6, 83, "Output",
  CellTags->"OtherGroupoids"]
}, Open  ]],
Cell[409062, 10899, 152, 4, 54, "MathCaption",
  CellTags->"OtherGroupoids"],

Cell[CellGroupData[{
Cell[409239, 10907, 183, 4, 55, "Input",
  CellTags->"OtherGroupoids"],
Cell[409425, 10913, 262, 5, 83, "Message",
  CellTags->"OtherGroupoids"],
Cell[409690, 10920, 267, 6, 83, "Output",
  CellTags->"OtherGroupoids"]
}, Open  ]],
Cell[409972, 10929, 72, 1, 68, "Subsection",
  CellTags->"Cayley"],
Cell[410047, 10932, 222, 5, 58, "Text",
  CellTags->{"Cayley", "i:26"}],
Cell[410272, 10939, 27680, 763, 342, "DefinitionBox",
  CellTags->{"Cayley", "i:27"}],
Cell[437955, 11704, 133, 6, 26, "Caption",
  CellTags->"Cayley"],
Cell[438091, 11712, 303, 7, 75, "Text",
  CellTags->"Cayley"],
Cell[438397, 11721, 18795, 523, 403, "DefinitionBox3Col",
  CellTags->{"Cayley", "i:28"}],
Cell[457195, 12246, 138, 6, 26, "Caption",
  CellTags->"Cayley"],
Cell[457336, 12254, 221, 9, 40, "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{
Cell[457582, 12267, 373, 8, 154, "Input",
  CellTags->"Cayley"],
Cell[457958, 12277, 172, 4, 55, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[458145, 12284, 242, 8, 55, "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{
Cell[458412, 12296, 118, 3, 39, "Input",
  CellTags->"Cayley"],
Cell[458533, 12301, 56971, 952, 308, 5282, 308, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[515507, 13255, 137, 3, 38, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[515659, 13261, 207, 5, 55, "MathCaption",
  CellTags->{"Cayley", "i:29"}],

Cell[CellGroupData[{
Cell[515891, 13270, 118, 3, 39, "Input",
  CellTags->"Cayley"],
Cell[516012, 13275, 166, 3, 49, "Print",
  CellTags->"Cayley"],
Cell[516181, 13280, 57862, 963, 308, 5306, 308, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[574046, 14245, 170, 4, 57, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[574231, 14252, 177, 5, 55, "MathCaption",
  CellTags->{"Cayley", "i:30"}],

Cell[CellGroupData[{
Cell[574433, 14261, 301, 6, 87, "Input",
  CellTags->"Cayley"],
Cell[574737, 14269, 50536, 1125, 308, 7357, 586, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[625276, 15396, 137, 3, 38, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[625428, 15402, 142, 4, 54, "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{
Cell[625595, 15410, 368, 7, 103, "Input",
  CellTags->"Cayley"],
Cell[625966, 15419, 204, 4, 64, "Print",
  CellTags->"Cayley"],
Cell[626173, 15425, 59133, 982, 306, 5508, 314, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[685309, 16409, 170, 4, 51, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[685494, 16416, 339, 9, 70, "MathCaption",
  CellTags->{"Cayley", "i:31"}],

Cell[CellGroupData[{
Cell[685858, 16429, 131, 3, 38, "Input",
  CellTags->"Cayley"],
Cell[685992, 16434, 43006, 986, 173, 9808, 569, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[729001, 17422, 185, 4, 47, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[729201, 17429, 140, 5, 41, "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{
Cell[729366, 17438, 192, 4, 70, "Input",
  CellTags->"Cayley"],
Cell[729561, 17444, 42686, 1021, 169, 10384, 616, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[772250, 18467, 243, 5, 66, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[772508, 18475, 128, 4, 40, "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{
Cell[772661, 18483, 199, 5, 70, "Input",
  CellTags->"Cayley"],
Cell[772863, 18490, 42686, 1021, 169, 10384, 616, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Cayley"],
Cell[815552, 19513, 243, 5, 66, "Output",
  CellTags->"Cayley"]
}, Open  ]],
Cell[815810, 19521, 556, 18, 51, "DefinitionBox",
  CellTags->"Cayley"],
Cell[816369, 19541, 163, 4, 54, "MathCaption",
  CellTags->"Cayley"],

Cell[CellGroupData[{
Cell[816557, 19549, 96, 3, 38, "Input",
  CellTags->"Cayley"],
Cell[816656, 19554, 716, 16, 136, "Output",
  CellTags->"Cayley"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

