(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    255977,       6519]*)
(*NotebookOutlinePosition[    267185,       6820]*)
(*  CellTagsIndexPosition[    266798,       6802]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  "Chapter 2\n",
  StyleBox["Groupoids",
    FontFamily->"Courier"]
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  CellTags->"OtherProps"],

Cell["2.7 Other group properties", "Subsection",
  CellTags->"OtherProps"],

Cell["\<\
This section collects together a number of functions that \
illustrate some property of a group, a subgroup, or an element in a \
group.\
\>", "Text",
  CellTags->"OtherProps"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RandomElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["random",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["RandomElements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["random",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["from",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], 
                  StyleBox["e",
                    "Text"]}]], 
              StyleBox[" ",
                "Text"], 
              StyleBox["groupoid",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherProps", "i:1"}],

Cell["Generating random elements.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "If a stop sign had a random element from ",
  Cell[BoxData[
      \(TraditionalForm\`D\_8\)]],
  " applied to it as a transformation, the probability that a motorist might \
be confused is 15/16."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[Dihedral[8]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(Rot\^7**Ref\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                StyleBox[\(option\ name\),
                  "SO10"],
                "NotebookDefault"],
              "Text",
              FormatType->StandardForm], 
            StyleBox[
              FormBox[
                StyleBox["value",
                  "SO10"],
                "NotebookDefault"],
              "Text",
              FormatType->StandardForm], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["NonIdentity",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["except",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["identity",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["default",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["RandomElement",
                    "MR",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Any",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], "  ", 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["default",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], "\n", 
                  StyleBox["RandomElements",
                    "MR",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox["Replacement",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["assume",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["replacement",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["choosing",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["default",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["RandomElements",
                    "MR",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.22, 0.58},
  RowLines->{True, False}},
  CellTags->{"OtherProps", "i:2"}],

Cell["Options for generating random elements.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[
"Although you can ask for something that you can\[CloseCurlyQuote]t get, you \
won\[CloseCurlyQuote]t get it."], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElements[U[12], \ 5, \ Replacement\  \[Rule] \ False]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(RandomElements::"toomany" \( : \ \) 
      "You can't ask for \!\(5\) random elements when there are only \!\(4\) \
available."\)], "Message",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["SelectFrom", "MR"],
  " option allows us to avoid the identity element."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElements[U[12], \ 5, \ SelectFrom\  \[Rule] \ NonIdentity]\)], 
  "Input",
  CellLabel->"In[3]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({7, 11, 11, 5, 7}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RandomElement", "MR"],
  " and ",
  StyleBox["RandomElements", "MR"],
  " work on ringoids, polynomials, and other structures. Here we pick we a \
random element in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@5]\)]],
  " of the form",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"a", " ", "+", " ", 
            RowBox[{"b", " ", 
              FormBox[\(\@5\),
                "TraditionalForm"]}]}]}], TraditionalForm]]],
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`| a | \( \[LessEqual] \ 50\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`| b | \( \[LessEqual] \ 50\)\)]],
  "."
}], "MathCaption",
  CellTags->{"OtherProps", "i:3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElement[Z[\@5], \ 50]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(13 - 42\ \@5\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  StyleBox["RandomElement", "MR"],
  " and ",
  StyleBox["RandomElements", "MR"],
  " can operate on any list of elements, not just groupoids or ringoids."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElements[{\[Alpha], \[Beta], \[Gamma], \[Delta], \[Epsilon], 
        \[Zeta], \[Eta], \[Theta], \[Iota], \[Kappa], \[Lambda], \[Mu], 
        \[Nu], \[Xi], \[Omicron], \[Pi], \[Rho], \[Sigma], \[Tau], 
        \[Upsilon], \[Phi], \[Chi], \[Psi], \[Omega]}, \ 4]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({\[Omega], \[Delta], \[Omega], \[Omega]}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Size",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["order",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], " ", "groupoid", " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Order",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["equivalent",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Size",
                        "MR"], 
                      StyleBox["[",
                        "MR"], "G", 
                      StyleBox["]",
                        "MR"]}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"]}]},
          {
            RowBox[{
              StyleBox["OrderOfElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ order\ of\ the\ element\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Order",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["equivalent",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{
                      StyleBox["OrderOfElement",
                        "MR"], 
                      StyleBox["[",
                        "MR"], \(G, \ g\), 
                      StyleBox["]",
                        "MR"]}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"]}]},
          {
            RowBox[{
              StyleBox["OrderOfAllElements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["orders",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "the", " ", 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{"{", 
                    RowBox[{
                      StyleBox["g",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], ",", " ", 
                      RowBox[{
                        StyleBox["|",
                          SingleLetterItalics->False], " ", 
                        StyleBox["g",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"], " ", 
                        StyleBox["|",
                          SingleLetterItalics->False]}]}], "}"}],
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Orders",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"equivalent", " ", "to", " ", 
              RowBox[{
                StyleBox["OrderOfAllElements",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["G",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["Orders",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(G, \ list\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"equivalent", " ", "to", " ", 
              RowBox[{
                StyleBox["OrderOfElement",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["G",
                    "TI"], 
                  StyleBox[",",
                    "MR"], 
                  StyleBox["list",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.37, 0.63}},
  CellTags->{"OtherProps", "i:4"}],

Cell["\<\
Functions related to the order of a groupoid or its elements.\
\>", 
  "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode of ",
  StyleBox["OrderOfAllElements", "MR"],
  " reveals a number of facts, including the order of the groupoid, the order \
of each element and whether the groupoid is cyclic."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfAllElements[U[8], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"OtherProps"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.416667 0.190476 [
[ 0 0 0 0 ]
[ 1 1.5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.5 L
0 1.5 L
closepath
clip
newpath
1 0 0 r
.21429 .9881 m
.21429 1.17857 L
.40476 1.17857 L
.40476 .9881 L
F
.21429 .79762 m
.21429 .9881 L
.40476 .9881 L
.40476 .79762 L
F
.5 1 0 r
.40476 .79762 m
.40476 .9881 L
.59524 .9881 L
.59524 .79762 L
F
1 0 0 r
.21429 .60714 m
.21429 .79762 L
.40476 .79762 L
.40476 .60714 L
F
.5 1 0 r
.59524 .60714 m
.59524 .79762 L
.78571 .79762 L
.78571 .60714 L
F
1 0 0 r
.21429 .41667 m
.21429 .60714 L
.40476 .60714 L
.40476 .41667 L
F
.5 1 0 r
.78571 .41667 m
.78571 .60714 L
.97619 .60714 L
.97619 .41667 L
F
1 0 0 r
.21429 .03571 m
.21429 .22619 L
.40476 .22619 L
.40476 .03571 L
F
.5 1 0 r
.40476 .03571 m
.40476 .22619 L
.59524 .22619 L
.59524 .03571 L
F
0 1 1 r
.59524 .03571 m
.59524 .22619 L
.78571 .22619 L
.78571 .03571 L
F
.5 0 1 r
.78571 .03571 m
.78571 .22619 L
.97619 .22619 L
.97619 .03571 L
F
0 g
[(1)] .30952 .30238 0 0 Mshowa
[(2)] .5 .30238 0 0 Mshowa
[(3)] .69048 .30238 0 0 Mshowa
[(4)] .88095 .30238 0 0 Mshowa
[(n)] .11905 .30238 0 0 Mshowa
[(g^n)] .11905 .13095 0 0 Mshowa
1 Mabswid
[ ] 0 setdash
.02381 .41667 m
.02381 1.36905 L
s
.02381 .41667 m
.97619 .41667 L
s
.02381 .60714 m
.97619 .60714 L
s
.02381 .79762 m
.97619 .79762 L
s
.02381 .9881 m
.97619 .9881 L
s
.02381 1.17857 m
.97619 1.17857 L
s
.02381 1.36905 m
.97619 1.36905 L
s
.21429 .41667 m
.21429 1.36905 L
s
.40476 .41667 m
.40476 1.36905 L
s
.59524 .41667 m
.59524 1.36905 L
s
.78571 .41667 m
.78571 1.36905 L
s
.97619 .41667 m
.97619 1.36905 L
s
.02381 1.36905 m
.21429 1.17857 L
s
2.6 Mabswid
.21429 .41667 m
.21429 1.36905 L
s
.02381 1.17857 m
.97619 1.17857 L
s
[(1)] .30952 1.08333 0 0 Mshowa
[(3)] .5 1.08333 0 0 Mshowa
[(5)] .69048 1.08333 0 0 Mshowa
[(7)] .88095 1.08333 0 0 Mshowa
[(3)] .30952 .89286 0 0 Mshowa
[(1)] .5 .89286 0 0 Mshowa
[(7)] .69048 .89286 0 0 Mshowa
[(5)] .88095 .89286 0 0 Mshowa
[(5)] .30952 .70238 0 0 Mshowa
[(7)] .5 .70238 0 0 Mshowa
[(1)] .69048 .70238 0 0 Mshowa
[(3)] .88095 .70238 0 0 Mshowa
[(7)] .30952 .5119 0 0 Mshowa
[(5)] .5 .5119 0 0 Mshowa
[(3)] .69048 .5119 0 0 Mshowa
[(1)] .88095 .5119 0 0 Mshowa
[(1)] .11905 1.08333 0 0 Mshowa
[(3)] .11905 .89286 0 0 Mshowa
[(5)] .11905 .70238 0 0 Mshowa
[(7)] .11905 .5119 0 0 Mshowa
[(1)] .30952 1.27381 0 0 Mshowa
[(3)] .5 1.27381 0 0 Mshowa
[(5)] .69048 1.27381 0 0 Mshowa
[(7)] .88095 1.27381 0 0 Mshowa
[(U[8])] .02381 1.46429 -1 0 Mshowa
gsave
.97619 1.46429 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 1.24143 0 0 Mshowa
[(y)] .16667 1.3119 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{192, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400030000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000<0000300000`0000<0000300000`0000<00
00300000`00002P09B<09=iagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLBD=02A=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8bAa9@d094e>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000X02DS02CNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW4U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0002P09B<TLBD=
02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8`0TgW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMia9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CPH0000X02DS974U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0002P0
9B<09=iagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLBD=02A=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8bAa9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CPH0000X02DS02CNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW4U3@0T
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0002P09B<TLBD=02A=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8`0TgW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMia9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000X02DS
974U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0002P09B<09=iagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLBD=02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDh600003`03oaH09B<TLBD=02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDh600004P000ol0000C02DS02CNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW4U3@0T
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0000l01?l700;o00<0ool02@0U8bAa
9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000>0005o`000?l01`001?l0
0?l:02DS02CNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW4U3@0TCDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0000h000Go0000o`070004o`00o`X09B<TLBD=02A=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh600003P001Ol0003o00L000Co003o2P0U8`0T
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CPH0000?00Go1@05o`X09B<TLBD=02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDh6000050000ol0o`0A02DS02CNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW4U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0001D000?o0000
400U8bAa9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000X02DS02CNLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW4U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>1P0002P09B<TLBD=02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDh60000:00U8`0TgW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia9@d094e>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000X02DS974U3@0TCDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>1P0002P09B<09=iagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLBD=02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8bAa9@d094e>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000X02DS02CNLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW4U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
1P0002P09B<TLBD=02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8`0T
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia9@d094e>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CPH0000X02DS974U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>
CDi=CTe>1P0002P09B<09=iagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLBD=02A=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000:00U8bAa9@d094e>CDi=CTe>CDi=CTe>
CDi=CTe>CDi=CTe>CDi=CTe>CDi=CPH0000X02DS02CNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW4U3@0TCDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>1P0002P09B<TLBD=
02A=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDh60000`0000<0000300000`0000<00
00300000`0000<0000300000`0000<00003000005002o`030?oo02000olQ00Co8003ob<00olF0000
50001?l00?lR0003o`00024000?o00008`000ol0000Q0003o`0001D0000D0004o`00ob8000?o0000
8P000ol0000R0003o`0001l01?lF000050001?l00?lR0003o`0002<000?o00007`02ob8000?o0?l0
5`0001<01OlR0003o`00020000Co003o8`000ol0000O0003o`3o01L0000i00;o8`02ob400olS00;o
5`000<0000300000`0000<0000300000`0000<0000300000`0000<0000300000`0000<0000300000
`0000<0000300000102go`D000040003o`0002000_lT8`03o`00024000?o00008P009OoNLMiagW7N
LMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiag_l01@0000@000?o00008002ob@S00?o00008@000ol0
000R0003og5a025a00?o00000`0000@000?o00008002ob@S00?o00008@000ol0000R000UomiagW7N
LMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7No`05000010000ol0000P00;o92<00ol0000Q0003
o`00028000?oLG408G400ol00003000010000ol0000P00;o92<00ol0000Q0003o`00028002GogW7N
LMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMko00D000040003o`0002000_lT8`03o`000240
00?o00008P000omaL@0QL@03o`0000<000040003o`0002000_lT8`03o`00024000?o00008P009OoN
LMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiag_l01@0000@000?o00008002ob@S00?o0000
8@000ol0000R0003og5a025a00?o00000`0000@000?o00008002ob@S00?o00008@000ol0000R000U
omiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7No`05000010000ol0000P00;o92<00ol0
000Q0003o`00028000?oLG408G400ol00003000010000ol0000P00;o92<00ol0000Q0003o`000280
02GogW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMko00D000040003o`0002000_lT8`03
o`00024000?o00008P000omaL@0QL@03o`0000<000040003o`0002000_lT8`03o`00024000?o0000
8P009OoNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiag_l01@0000@000?o00008002ob@S
00?o00008@000ol0000R0003og5a025a00?o00000`0000@000?o00008002ob@S00?o00008@000ol0
000R000UomiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7No`05000010000ol0000P00;o
92<00ol0000Q0003o`00028000?oLG408G400ol00003000010000ol0000>0003o`0000l00_lA8`03
ob<S010S00?o00003@03oa4000?o00003@03oa80013ogW7NLMiagW7NLMiagW7N0ol04]iagW7NLMia
gW7NLMiagW7No`D000040003o`0000h000?o00003`02oa4S00?o8b<042<00ol0000@0003o`0000h0
00?o000040000ol0000?0003og5a00ia00?oLG4047400ol00003000010000ol0000?0003o`0000h0
0_lB8`03ob<S00lS00?o000040000ol0000>0003o`00010000?o00003`009OoNLMiagW7NLMiagW7N
LMiaog7NLMiagW7NLMiagW7NLMiag_l01@0000@000?o00003`000ol0000>00;o4R<00olS8`0?8`03
o`0000d00olA0003o`0000h00_lB0003og5a00ia00?oLG4047400ol00003000010000ol0000@0003
o`0000d00_lC8`03ob<S00hS00?o00003@000ol0000A0003o`00010000?o00003`009OoNLMiagW7N
LMiagW7NLMiaog7NLMiagW7NLMiagW7NLMiag_l01@0000@000?o00003@04o`l00_l@8`Co42<00ol0
000=00Co40000ol0000=00?o4P000omaL@0=L@;o4W400ol00003000010000ol0000P00;o92<00ol0
000Q0003o`00028002GogW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMko00D000040003
o`0002000_lT8`03o`00024000?o00008P000omaL@0QL@03o`0000<000040003o`0002000_lT8`03
o`00024000?o00008P009OoNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiag_l01@0000@0
00?o00008002ob@S00?o00008@000ol0000R0003og5a025a00?o00000`0000@000?o00008002ob@S
00?o00008@000ol0000R000UomiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7No`050000
10000ol0000P00;o92<00ol0000Q0003o`00028000?oLG408G400ol00003000010000ol0000P00;o
92<00ol0000Q0003o`00028002GogW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMko00D0
00040003o`0002000_lT8`03o`00024000?o00008P000omaL@0QL@03o`0000<000040003o`000200
0_lT8`03o`00024000?o00008P009OoNLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiag_l0
1@0000@000?o00008002ob@S00?o00008@000ol0000R0003og5a025a00?o00000`0000@000?o0000
8002ob@S00?o00008@000ol0000R000UomiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7N
o`05000010000ol0000P00;o92<00ol0000Q0003o`00028000?oLG408G400ol00003000010000ol0
000P00;o92<00ol0000Q0003o`00028002GogW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7N
LMko00D000040003o`0002000_lT8`03o`00024000?o00008P000omaL@0QL@03o`0000<000040;Oo
1@0000@000?o00008002ob@S00?o00008@000omaL@0RL@03o`00024000?o00000`0000@000?o0000
8002ob@S00?o00008@009_magW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMko8`000ol0
0003000010000ol0000P00;o92<00ol0000Q0003og5a029a00?o00008@000ol00003000010000ol0
000P00;o92<00ol0000Q000Vog7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiag_lS0003
o`0000<000040003o`0002000_lT8`03o`00024000?oLG408W400ol0000Q0003o`0000<000040003
o`0002000_lT8`03o`00024002KoLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7Nob<0
00?o00000`0000@000?o00008002ob@S00?o00008@000omaL@0RL@03o`00024000?o00000`0000@0
00?o00008002ob@S00?o00008@009_magW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMko
8`000ol00003000010000ol0000P00;o92<00ol0000Q0003og5a029a00?o00008@000ol000030000
10000ol0000P00;o92<00ol0000Q000Vog7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
g_lS0003o`0000<000040003o`0002000_lT8`03o`00024000?oLG408W400ol0000Q0003o`0000<0
00040003o`0002000_lT8`03o`00024002KoLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7Nob<000?o00000`0000@000?o00008002ob@S00?o00008@000omaL@0RL@03o`00024000?o0000
0`0000@000?o00008002ob@S00?o00008@009_magW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMko8`000ol00003000010000ol0000P00;o92<00ol0000Q0003og5a029a00?o00008@000ol0
0003000010000ol0000=00?o4002oa0S0olA8`03o`0000h000?o000040004?magW7NLMiagW7NLMia
gW43o`0CLMiagW7NLMiagW7NLMiagW7No`0?00?o4@000ol00003000010000ol0000@0003o`0000d0
0_lC8`03ob<S00hS00?o00003P000ol0000@0003og5a00ia00?oLG404G400ol0000@0003o`0000h0
00?o00000`0000@000?o000040000ol0000=00;o4b<00olS8`0>8`03o`0000l000?o00003`009_ma
gW7NLMiagW7NLMiagW7NomiagW7NLMiagW7NLMiagW7NLMko4P000ol0000>0003o`0000<000040003
o`0000d00ol@00;o42<3oa4S00?o00003`000ol0000?0003og5a00ia00?oLG404G400ol0000>00;o
4@000ol00003000010000ol0000=0003o`0001000_l@8`03ob<S014S00?o000040000ol0000>000V
og7NLMiagW7NLMiagW7NLMkogW7NLMiagW7NLMiagW7NLMiag_lB0003o`0000h000?o00000`0000@0
00?o00003@04o`l00_l@8`Co42<00ol0000=00Co40000omaL@0=L@;o4g400ol0000=00?o4@000ol0
0003000010000ol0000P00;o92<00ol0000Q000Vog7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiag_lS0003o`0000<000040003o`0002000_lT8`03o`00024000?oLG408W400ol0000Q0003
o`0000<000040003o`0002000_lT8`03o`00024002KoLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7Nob<000?o00000`0000@000?o00008002ob@S00?o00008@000omaL@0RL@03o`000240
00?o00000`0000@000?o00008002ob@S00?o00008@009_magW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMko8`000ol00003000010000ol0000P00;o92<00ol0000Q0003og5a029a00?o0000
8@000ol00003000010000ol0000P00;o92<00ol0000Q000Vog7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiag_lS0003o`0000<000040003o`0002000_lT8`03o`00024000?oLG408W400ol0
000Q0003o`0000<000040003o`0002000_lT8`03o`00024002KoLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7Nob<000?o00000`0000@000?o00008002ob@S00?o00008@000omaL@0RL@03
o`00024000?o00000`0000@000?o00008002ob@S00?o00008@009_magW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMko8`000ol00003000010000ol0000P00;o92<00ol0000Q0003og5a029a
00?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q000Vog7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiag_lS0003o`0000<000040003o`0002000_lT8`03o`00024000?oLG40
8W400ol0000Q0003o`0000<000040;Oo1@0000@000?o00008002ob@S00?oLG408G400ol0000R0003
o`00024000?o00000`0000@000?o00008002ob@S02GoLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7o02@000?o00008@000ol00003000010000ol0000P00;o92<00omaL@0QL@03o`000280
00?o00008@000ol00003000010000ol0000P00;o92<09OmagW7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLOl090000ol0000Q0003o`0000<000040003o`0002000_lT8`03og5a025a00?o0000
8P000ol0000Q0003o`0000<000040003o`0002000_lT8`0Uog7NLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiao`0T0003o`00024000?o00000`0000@000?o00008002ob@S00?oLG408G400ol0
000R0003o`00024000?o00000`0000@000?o00008002ob@S02GoLMiagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7o02@000?o00008@000ol00003000010000ol0000P00;o92<00omaL@0QL@03
o`00028000?o00008@000ol00003000010000ol0000P00;o92<09OmagW7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLOl090000ol0000Q0003o`0000<000040003o`0002000_lT8`03og5a025a
00?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`0Uog7NLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiao`0T0003o`00024000?o00000`0000@000?o00008002ob@S00?oLG40
8G400ol0000R0003o`00024000?o00000`0000@000?o00008002ob@S02GoLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7o02@000?o00008@000ol00003000010000ol0000P00;o92<00oma
L@0QL@03o`00028000?o00008@000ol00003000010000ol0000=00?o4002oa0S0olA8`0@og7NLMia
gW7NLMiagW7NL@?o019agW7NLMiagW7NLMiagW7NLOl@0003o`00014000?o00003@03oa4000?o0000
0`0000@000?o000040000ol0000=00;o4b<00olS8`0>8`03og5a00ia00?oLG4047400ol0000>0003
o`00014000?o000040000ol0000>0003o`0000<000040003o`00010000?o00003@02oa<S00?o8b<0
3R<09OmagW7NLMiagW7NLMiagW7NomiagW7NLMiagW7NLMiagW7NLOl04@000ol0000@0003o`000100
00?o00003P000ol00003000010000ol0000>00;o4002oa4S0_lA8`03og5a00ia00?oLG4047400ol0
000?0003o`00010000?o00003@03oa4000?o00000`0000@000?o000040000ol0000=00;o4b<00olS
8`0>8`0Uog7NLMiagW7NLMiagW7NLMkogW7NLMiagW7NLMiagW7NLMiao`0B0003o`0000l000?o0000
3@000ol0000A0003o`0000<000040003o`0000d00ol@00;o42<3oa4S00?oLG403G42oa9a00?o0000
3@04oa4000?o00003@04oa0000?o00000`0000@000?o00008002ob@S02GoLMiagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7o02@000?o00008@000ol00003000010000ol0000P00;o92<00oma
L@0QL@03o`00028000?o00008@000ol00003000010000ol0000P00;o92<09OmagW7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLOl090000ol0000Q0003o`0000<000040003o`0002000_lT8`03
og5a025a00?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`0Uog7NLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiao`0T0003o`00024000?o00000`0000@000?o00008002ob@S
00?oLG408G400ol0000R0003o`00024000?o00000`0000@000?o00008002ob@S02GoLMiagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7o02@000?o00008@000ol00003000010000ol0000P00;o
92<00omaL@0QL@03o`00028000?o00008@000ol00003000010000ol0000P00;o92<09OmagW7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLOl090000ol0000Q0003o`0000<000040003o`000200
0_lT8`03og5a025a00?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`0Uog7NLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiao`0T0003o`00024000?o00000`0000@000?o0000
8002ob@S00?oLG408G400ol0000R0003o`00024000?o00000`0000@000?o00008002ob@S02GoLMia
gW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7NLMiagW7o02@000?o00008@000ol00003000010000ol0
000P00;o92<00omaL@0QL@03o`00028000?o00008@000ol000030000102go`D000040003o`000200
0_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`03o`000240
00?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`03o`00024000?o00008P000ol0
000Q0003o`0000<000040003o`0002000_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<0
00040003o`0002000_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`000200
0_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`03o`000240
00?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`03o`00024000?o00008P000ol0
000Q0003o`0000<000040003o`0002000_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<0
00040003o`0002000_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`000200
0_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`03o`000240
00?o00008P000ol0000Q0003o`0000<000040003o`0002000_lT8`03o`00024000?o00008P000ol0
000Q0003o`0000<000040003o`0002000_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<0
00040003o`0002000_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`000200
0_lT8`03o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0000d00ol@00;o42<3oa4S
00?o00003@03oa4000?o00003@03oa8000?o00003P000ol0000@0003o`0000<000040003o`0000h0
00?o00003`02oa4S00?o8b<042<00ol0000@0003o`0000h000?o000040000ol0000?0003o`0000h0
00?o000040000ol00003000010000ol0000>0003o`0000l00_lA8`03ob<S010S00?o000040000ol0
000>0003o`00010000?o00003`000ol0000?0003o`0000l000?o00000`0000@000?o00003P000ol0
000?00;o4B<00olS8`0@8`03o`0000h00_lA0003o`0000d00olB0003o`0000l000?o00003`000ol0
0003000010000ol0000>0003o`0000l00_lA8`03ob<S010S00?o000040000ol0000>0003o`0000d0
00?o00004P000ol0000@0003o`0000h000?o00000`0000@000?o00003@02oa400_l@8`;o4R<00ol0
000=00?o4@000ol0000=00Co4@000ol0000=00Co40000ol00003000010000ol0000P00;o92<00ol0
000Q0003o`00028000?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q0003o`000280
00?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q0003o`00028000?o00008@000ol0
0003000010000ol0000P00;o92<00ol0000Q0003o`00028000?o00008@000ol00003000010000ol0
000P00;o92<00ol0000Q0003o`00028000?o00008@000ol00003000010000ol0000P00;o92<00ol0
000Q0003o`00028000?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q0003o`000280
00?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q0003o`00028000?o00008@000ol0
0003000010000ol0000P00;o92<00ol0000Q0003o`00028000?o00008@000ol00003000010000ol0
000P00;o92<00ol0000Q0003o`00028000?o00008@000ol00003000010000ol0000P00;o92<00ol0
000Q0003o`00028000?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q0003o`000280
00?o00008@000ol00003000010000ol0000P00;o92<00ol0000Q0003o`00028000?o00008@000ol0
0003000010000ol0000P00;o92<00ol0000Q0003o`00028000?o00008@000ol0000300000`2ho`D0
00030;So1@0000@000?o00007`03ob@000?o00008@000ol0000R0003o`00024000?o00000`0000@0
00?o00007P001?l0oolT0003o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0001d0
00?o00000_lT0003o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0001`000Co0000
0_lT0003o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0001/000?o00000P02ob@0
00?o00008@000ol0000R0003o`00024000?o00000`0000@000?o00006P000ol0000300;o90000ol0
000Q0003o`00028000?o00008@000ol00003000010000ol0000I0003o`0000@00_lT0003o`000240
00?o00008P000ol0000Q0003o`0000<000040003o`0001P000?o00001@02ob@000?o00008@000ol0
000R0003o`00024000?o00000`0000@000?o00001P02o`030?oo00`000?o00001P02ob@000?o0000
8@000ol0000R0003o`00024000?o00000`0000@000?o00001`000ol0o`0<0003o`0000L00_lT0003
o`00024000?o00008P000ol0000Q0003o`0000<000040003o`0000P000?o00002P000ol0000800;o
90000ol0000Q0003o`00028000?o00008@000ol00003000010000ol000070003o`3o00X000?o0000
2@02ob@000?o00008@000ol0000R0003o`00024000?o00000`0000@000?o00001P02o`030?oo00P0
00?o00002P02ob@000?o00008@000ol0000R0003o`00024000?o00000`0000@000?o00004P000ol0
000;00;o90000ol0000Q0003o`00028000?o00008@000ol00003000010000ol0000A0003o`0000`0
0_l@00?o4@000ol0000=00?o4@000ol0000=00?o4P000ol0000>0003o`00010000?o00000`0000@0
00?o000040000ol0000=00;o4@000ol0000@0003o`00010000?o00003P000ol0000@0003o`0000l0
00?o00003P000ol0000@0003o`0000<000040003o`0000l000?o00003P02oa4000?o000040000ol0
000@0003o`0000h000?o000040000ol0000?0003o`0000l000?o00003`000ol00003000010000ol0
000>0003o`0000l00_lA0003o`00010000?o00003P02oa4000?o00003@03oa8000?o00003`000ol0
000?0003o`0000<000040003o`0000d000?o00004002oa4000?o000040000ol0000@0003o`0000h0
00?o00003@000ol0000B0003o`00010000?o00003P000ol00003000010000ol0000<0003o`0000H0
0ol800;o4002oa8000?o00003@03oa4000?o00003@04oa4000?o00003@04oa0000?o00000`0000@0
00?o00002`000ol000080003o`0000L00_lT0003o`00024000?o00008P000ol0000Q0003o`0000<0
00040003o`0000X000?o00002P000ol0000600;o90000ol0000Q0003o`00028000?o00008@000ol0
0003000010000ol000090003o`0000/000?o00001P02ob@000?o00008@000ol0000R0003o`000240
00?o00000`0000@000?o000020000ol0000;0003o`3o00L00_lT0003o`00024000?o00008P000ol0
000Q0003o`0000<000040003o`0000L000?o000030000ol0o`0700;o90000ol0000Q0003o`000280
00?o00008@000ol00003000010000ol000060003o`0000`00_l00`3oo`0600;o90000ol0000Q0003
o`00028000?o00008@000ol00003000010000ol000050003o`0001P00_lT0003o`00024000?o0000
8P000ol0000Q0003o`0000<000040003o`0000@000?o00006@02ob@000?o00008@000ol0000R0003
o`00024000?o00000`0000@000?o00000`000ol0000J00;o90000ol0000Q0003o`00028000?o0000
8@000ol00003000010000ol000020003o`0001/00_lT0003o`00024000?o00008P000ol0000Q0003
o`0000<000040005o`000?l07P02ob@000?o00008@000ol0000R0003o`00024000?o00000`0000@0
00Co003o7`02ob@000?o00008@000ol0000R0003o`00024000?o00000`0000@000?o0?l08002ob@0
00?o00008@000ol0000R0003o`00024000?o00000`0000@00_lQ00;o90000ol0000Q0003o`000280
00?o00008@000ol000030000102go`D0000W00;oU`000<0000300000`0000<0000300000`0000<00
00300000`0000<0000300000`00000`00_l:00;oV003o`/0000<0003o`0000X000?o0000U`000ol0
000:00001P02o`@000?o00000`02o`D000?o0000OP02o`030?oo00T000?o0?l02@000ol000090000
1@001?l00?l30003o`00008000Co003o10000ol0001o0003o`3o00/000?o000020000ol000090000
1@001?l00?l30003o`00008000Co003o10000ol000200003o`0000P01Ol70003o`3o00X000050004
o`00o`<000?o00000`02o`D000?o0000O`000ol0o`0;0003o`0000L000?o0?l02P0000D000Co003o
0`000ol000020004o`00o`@000?o0000OP02o`030?oo01<00_l00`3oo`0900001002o`800_l200;o
1002o`@00_nV0000`0000<0000300000`0000001\
\>"],
  ImageRangeCache->{{{0, 191}, {287, 0}} -> {-1.12503, -2.19442, 0.0274872, 
  0.0274872}},
  CellTags->"OtherProps"],

Cell[BoxData[
    \({{1, 1}, {3, 2}, {5, 2}, {7, 2}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "While ",
  StyleBox["OrderOfAllElements", "MR"],
  " returns the orders for all elements in pairs ",
  Cell[BoxData[
      \(TraditionalForm\`{g, \(| g | \)}\)]],
  ", ",
  StyleBox["OrderOfElement", "MR"],
  " can be given a list of elements and returns just the orders of those \
elements."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OrderOfElement[U[8], \ {3, \ 5}]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({2, 2}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Orders", "MR"],
  " function has output similar to ",
  StyleBox["OrderOfAllElements", "MR"],
  "."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orders[U[8], \ {3, \ 5}]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({{3, 2}, {5, 2}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "The order of the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " does not increase monotonically."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Table[{n, \ Size[U[n]]}, \ {n, \ 2, \ 17}], \ 
      PlotStyle\  \[Rule] \ {PointSize[0.02], \ RGBColor[0, 0, 1]}]; \)\)], 
  "Input",
  CellLabel->"In[9]:=",
  CellTags->"OtherProps"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0560224 0.0147151 0.0367877 [
[.16387 .00222 -9 -9 ]
[.16387 .00222 9 0 ]
[.30392 .00222 -3 -9 ]
[.30392 .00222 3 0 ]
[.44398 .00222 -9 -9 ]
[.44398 .00222 9 0 ]
[.58403 .00222 -6 -9 ]
[.58403 .00222 6 0 ]
[.72409 .00222 -12 -9 ]
[.72409 .00222 12 0 ]
[.86415 .00222 -6 -9 ]
[.86415 .00222 6 0 ]
[.01131 .10668 -18 -4.5 ]
[.01131 .10668 0 4.5 ]
[.01131 .19865 -6 -4.5 ]
[.01131 .19865 0 4.5 ]
[.01131 .29062 -18 -4.5 ]
[.01131 .29062 0 4.5 ]
[.01131 .38259 -12 -4.5 ]
[.01131 .38259 0 4.5 ]
[.01131 .47456 -24 -4.5 ]
[.01131 .47456 0 4.5 ]
[.01131 .56653 -12 -4.5 ]
[.01131 .56653 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.16387 .01472 m
.16387 .02097 L
s
[(2.5)] .16387 .00222 0 1 Mshowa
.30392 .01472 m
.30392 .02097 L
s
[(5)] .30392 .00222 0 1 Mshowa
.44398 .01472 m
.44398 .02097 L
s
[(7.5)] .44398 .00222 0 1 Mshowa
.58403 .01472 m
.58403 .02097 L
s
[(10)] .58403 .00222 0 1 Mshowa
.72409 .01472 m
.72409 .02097 L
s
[(12.5)] .72409 .00222 0 1 Mshowa
.86415 .01472 m
.86415 .02097 L
s
[(15)] .86415 .00222 0 1 Mshowa
.125 Mabswid
.05182 .01472 m
.05182 .01847 L
s
.07983 .01472 m
.07983 .01847 L
s
.10784 .01472 m
.10784 .01847 L
s
.13585 .01472 m
.13585 .01847 L
s
.19188 .01472 m
.19188 .01847 L
s
.21989 .01472 m
.21989 .01847 L
s
.2479 .01472 m
.2479 .01847 L
s
.27591 .01472 m
.27591 .01847 L
s
.33193 .01472 m
.33193 .01847 L
s
.35994 .01472 m
.35994 .01847 L
s
.38796 .01472 m
.38796 .01847 L
s
.41597 .01472 m
.41597 .01847 L
s
.47199 .01472 m
.47199 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.52801 .01472 m
.52801 .01847 L
s
.55602 .01472 m
.55602 .01847 L
s
.61204 .01472 m
.61204 .01847 L
s
.64006 .01472 m
.64006 .01847 L
s
.66807 .01472 m
.66807 .01847 L
s
.69608 .01472 m
.69608 .01847 L
s
.7521 .01472 m
.7521 .01847 L
s
.78011 .01472 m
.78011 .01847 L
s
.80812 .01472 m
.80812 .01847 L
s
.83613 .01472 m
.83613 .01847 L
s
.89216 .01472 m
.89216 .01847 L
s
.92017 .01472 m
.92017 .01847 L
s
.94818 .01472 m
.94818 .01847 L
s
.97619 .01472 m
.97619 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .10668 m
.03006 .10668 L
s
[(2.5)] .01131 .10668 1 0 Mshowa
.02381 .19865 m
.03006 .19865 L
s
[(5)] .01131 .19865 1 0 Mshowa
.02381 .29062 m
.03006 .29062 L
s
[(7.5)] .01131 .29062 1 0 Mshowa
.02381 .38259 m
.03006 .38259 L
s
[(10)] .01131 .38259 1 0 Mshowa
.02381 .47456 m
.03006 .47456 L
s
[(12.5)] .01131 .47456 1 0 Mshowa
.02381 .56653 m
.03006 .56653 L
s
[(15)] .01131 .56653 1 0 Mshowa
.125 Mabswid
.02381 .03311 m
.02756 .03311 L
s
.02381 .0515 m
.02756 .0515 L
s
.02381 .0699 m
.02756 .0699 L
s
.02381 .08829 m
.02756 .08829 L
s
.02381 .12508 m
.02756 .12508 L
s
.02381 .14347 m
.02756 .14347 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .18026 m
.02756 .18026 L
s
.02381 .21705 m
.02756 .21705 L
s
.02381 .23544 m
.02756 .23544 L
s
.02381 .25384 m
.02756 .25384 L
s
.02381 .27223 m
.02756 .27223 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .32741 m
.02756 .32741 L
s
.02381 .3458 m
.02756 .3458 L
s
.02381 .3642 m
.02756 .3642 L
s
.02381 .40099 m
.02756 .40099 L
s
.02381 .41938 m
.02756 .41938 L
s
.02381 .43777 m
.02756 .43777 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .49296 m
.02756 .49296 L
s
.02381 .51135 m
.02756 .51135 L
s
.02381 .52974 m
.02756 .52974 L
s
.02381 .54814 m
.02756 .54814 L
s
.02381 .58493 m
.02756 .58493 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.02 w
.13585 .0515 Mdot
.19188 .08829 Mdot
.2479 .08829 Mdot
.30392 .16187 Mdot
.35994 .08829 Mdot
.41597 .23544 Mdot
.47199 .16187 Mdot
.52801 .23544 Mdot
.58403 .16187 Mdot
.64006 .38259 Mdot
.69608 .16187 Mdot
.7521 .45617 Mdot
.80812 .23544 Mdot
.86415 .30902 Mdot
.92017 .30902 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@0003P0
1?l300;o0`03oa`00olN0003o`0000<00_l300?o6@03o`@00_lF00?o0`04o`<00_l300?o5P03o`<0
0olR0000>@000ol0000300;o1P000ol0000L0003o`0001/000?o00000`02o`H000?o00005`000ol0
00020004o`00oaH000?o00000`000ol0000300;o1P000ol0000D0003o`0000D000?o00007`0003X0
00?o00002P000ol0000L0003o`0001`000?o00002P000ol0000G0003o`00008000Co003o5P000ol0
00040003o`0000X000?o000050000ol000050003o`0001l0000k0003o`0000H00olL00?o7`000ol0
000700?o6P000ol000020004o`00oaH000?o00001@000ol0000600?o5`000ol0000200?o8P0003P0
00Co003o20000ol0000L0003o`00020000?o00001P000ol0000J0003o`00008000Co003o5P000ol0
00020004o`00o`P000?o00005`000ol000020003o`000280000i00;o2@04oa/01?lL00Co2004oaP0
0_l500;o5P02o`D00_l900Co5@02o`@01?lQ00006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000D0?oo3Ol001/000?o000010000ol000050003o`0000@0
00?o00001@000ol000040003o`0000D000?o000010000ol000040003o`0000D000?o000010000ol0
00050003o`0000@000?o00001@000ol000040003o`0000D000?o000010000ol000040003o`0000D0
00?o000010000ol000050003o`0000@000?o00001@000ol000040003o`0000D000?o000010000ol0
00050003o`0000@000?o000010000ol000050003o`0000@000?o00001@000ol000040003o`0000D0
00?o000010000ol0000500006`000ol0000R0003o`00028000?o00008`000ol0000R0003o`000280
00?o00008P000ol0000S00006`000ol0003o00<0000K0003o`000?l00`0001/00_oo00@0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0000J00?Bi@0001/000?o00006@05d^@0000K00;o
6P05d^@0000K0003o`0001T01M;T00006`000ol0000J00?Bi@0001/000?o0000o`0300006`000ol0
003o00<0000K00;oo`0400006`000ol0003o00<0000K0003o`000?l00`0001/000?o0000:003dP`0
0m8K00?BZP0001/000?o00009`05dPX01M8I00GBZ@0001/00_lX00GB2P05dQT01M:Y00006`000ol0
000W00GB2P05dQT01M:Y00001`04o`<00_l300?o1@000ol0000X00?B3003dQ/00m:Z000020000ol0
000300;o1P000ol000020003o`000?l00`0000T000?o00002P000ol0000200;oo`0400002P000ol0
000600?o1@000ol0003o00<000070004o`00o`P000?o00001@000ol0003o00<0000800;o2@04o`@0
00?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000AP03dRX00m8K00?B6`03dU00000K0003o`0004D01M8X00GB6@05dQT0
1M9?00006`02odH01M8X00GB6@05dQT01M9?00006`000ol0001500GB:005dQT01M8I00GBC`0001/0
00?o0000AP03dRX00m8K00?B6`03dU00000K0003o`000?l00`0001/000?o0000o`0300006`02ool0
100001/000?o0000o`0300006`000ol0003o00<0000C00?o1@000ol0003o00<0000F0003o`000080
00?o0000o`0300005P000ol0000200;oo`0400004`03o`D000?o0000o`0300004`000ol000050003
o`000?l00`0001<01?l40003o`000?l00`0001/000?o0000o`0300006`02ool0100001/000?o0000
o`0300006`000ol0003o00<0000K0003o`0006@00m8K00?BA`03dS<0000K0003o`0006<01M8I00GB
A@05dS80000K00;oI005dQT01M9500GB<P0001/000?o0000H`05dQT01M9500GB<P0001/000?o0000
I003dQ/00m9700?B<`0001/000?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`02ool0100001/000?o0000o`030000
6`000ol0003o00<000080003o`0000<00_l300?o1@000ol0003o00<000080003o`0000<00_l60003
o`00008000?o0000o`0300002@000ol0000:0003o`0000800_oo00@000090003o`0000L00ol50003
o`000?l00`0000X000?o00001P000ol000050003o`000?l00`0000L01?l800Co10000ol0003K00?B
3003dQD0000K0003o`000=X01M8:00GB500001/00_oK00GB2P05dQ@0000K0003o`000=X01M8:00GB
500001/000?o0000f`03dP`00m8E00006`000ol0003o00<0000K0003o`000?l00`0001/00_oo00@0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/0
0_oo00@0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l0
0`0001/00_oo00@0000K0003o`000?l00`0001/000?o0000o`0300003@03o`@00_l50003o`000:00
0m9O00003P000ol000020004o`00o`@000?o0000W`05dUh0000>0003o`00008000Co003o1002oj00
1M9N00003P000ol000020004o`00o`@000?o0000W`05dUh0000>0003o`00008000Co003o10000ol0
002P00?BG`0000d00_l500;o1@000ol0003o00<0000K0003o`000?l00`0001/00_oo00@0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?l00`0001/00_oo00@0
000K0003o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0
003o00<0000K0003o`000?l00`0001/000?o0000o`0300006`000ol0002m00?B@P0001/00_nm00GB
@@0001/000?o0000_005dT40000K0003o`000;`01M91000000@0oooo0`04o`<00_l300?o1@000ol0
002m00?B@P00008000?o00000`000ol0000300;o1P000ol000020003o`000?l00`00008000?o0000
10000ol0000:0003o`0000800_oo00@000020003o`0000D000?o00001P03o`D000?o0000o`030000
0P000ol000020004o`00o`P000?o00001@000ol0003o00<000000`3oo`0500;o2@04o`@000?o0000
o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0003o00<0000K0003o`000?l00`0001/0
00?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0003o00<0000K0003o`000?l0
0`0001/000?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0003o00<0000K0003
o`000?l00`0001/000?o0000o`0300006`000ol0003o00<0000K00;oo`0400006`000ol0003o00<0
000K0003o`000?l00`0000d00ol300?o1@000ol0003o00<0000>0003o`0000D000?o00000P000ol0
003o00<0000>0003o`0000D000?o00000P02ool0100000h000?o00000P03o`D000?o0000o`030000
3P000ol000020003o`0000D000?o0000o`0300003@02o`@01?l40003o`000?l00`0001/000?o0000
o`0300006`02ool0100001/000?o0000o`0300006`000ol0003o00<0000K0003o`000?T00m860000
6`000ol0003h00GB1@0001/00_oi00GB1@0001/000?o0000n005dPD0000K0003o`000?T00m860000
6`000ol0003o00<0003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.8337, -1.4703, 0.0671038, 
  0.102189}},
  CellTags->"OtherProps"]
}, Open  ]],

Cell["\<\
Although commutativity is not a required property for a structure \
to be a group, it is an important property.\
\>", "Text",
  CellTags->"OtherProps"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["AbelianQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Abelian",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["CommutativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["equivalent",
                SingleLetterItalics->False], 
              StyleBox["  ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["AbelianQ",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["G",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["NonCommutingPairs",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["pairs",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["do",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["not",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["commute",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Commutator",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["y",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["commutator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["x",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["y",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"]}],
                  "TraditionalForm"],
                "Text"], 
              SuperscriptBox[
                StyleBox["x",
                  FontSlant->"Italic"], 
                StyleBox[\(-1\),
                  SingleLetterItalics->False]], 
              SuperscriptBox[
                StyleBox["y",
                  FontSlant->"Italic"], 
                StyleBox[\(-1\),
                  SingleLetterItalics->False]], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Commutators",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["set",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["commutators",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["CommutatorSubgroup",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["commutator",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroup",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.37, 0.63}},
  CellTags->{"OtherProps", "i:5"}],

Cell["Functions related to commutativity.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "The group ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " is nonabelian, as illustrated by the lack of symmetry across the main \
diagonal."
}], "MathCaption",
  CellTags->{"OtherProps", "AbelianQex"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(AbelianQ[Symmetric[3], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"OtherProps", "AbelianQex"}],

Cell[BoxData[
    \("KEY for S[3]: label used \[Rule] element: {g1 \[Rule] {1, 2, 3}, g2 \
\[Rule] {1, 3, 2}, g3 \[Rule] {2, 1, 3}, g4 \[Rule] {2, 3, 1}, g5 \[Rule] {3, \
1, 2}, g6 \[Rule] {3, 2, 1}}"\)], "Print",
  CellTags->"OtherProps"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 1 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.84014 .70578 m
.84014 .84184 L
.97619 .84184 L
.97619 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.70408 .16156 m
.70408 .29762 L
.84014 .29762 L
.84014 .16156 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.15986 .02551 m
.15986 .16156 L
.29592 .16156 L
.29592 .02551 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
1 1 0 r
3 Mabswid
[ ] 0 setdash
.15986 .84184 m
.97619 .02551 L
s
.15986 .56973 m
.43197 .84184 L
s
.15986 .43367 m
.56803 .84184 L
s
.15986 .29762 m
.70408 .84184 L
s
.15986 .16156 m
.84014 .84184 L
s
.15986 .02551 m
.97619 .84184 L
s
.29592 .02551 m
.97619 .70578 L
s
.43197 .02551 m
.97619 .56973 L
s
.56803 .02551 m
.97619 .43367 L
s
.70408 .02551 m
.97619 .29762 L
s
1 0 0 r
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
0 g
[(g1)] .22789 .77381 0 0 Mshowa
[(g2)] .36395 .77381 0 0 Mshowa
[(g3)] .5 .77381 0 0 Mshowa
[(g4)] .63605 .77381 0 0 Mshowa
[(g5)] .77211 .77381 0 0 Mshowa
[(g6)] .90816 .77381 0 0 Mshowa
[(g2)] .22789 .63776 0 0 Mshowa
[(g1)] .36395 .63776 0 0 Mshowa
[(g5)] .5 .63776 0 0 Mshowa
[(g6)] .63605 .63776 0 0 Mshowa
[(g3)] .77211 .63776 0 0 Mshowa
[(g4)] .90816 .63776 0 0 Mshowa
[(g3)] .22789 .5017 0 0 Mshowa
[(g4)] .36395 .5017 0 0 Mshowa
[(g1)] .5 .5017 0 0 Mshowa
[(g2)] .63605 .5017 0 0 Mshowa
[(g6)] .77211 .5017 0 0 Mshowa
[(g5)] .90816 .5017 0 0 Mshowa
[(g4)] .22789 .36565 0 0 Mshowa
[(g3)] .36395 .36565 0 0 Mshowa
[(g6)] .5 .36565 0 0 Mshowa
[(g5)] .63605 .36565 0 0 Mshowa
[(g1)] .77211 .36565 0 0 Mshowa
[(g2)] .90816 .36565 0 0 Mshowa
[(g5)] .22789 .22959 0 0 Mshowa
[(g6)] .36395 .22959 0 0 Mshowa
[(g2)] .5 .22959 0 0 Mshowa
[(g1)] .63605 .22959 0 0 Mshowa
[(g4)] .77211 .22959 0 0 Mshowa
[(g3)] .90816 .22959 0 0 Mshowa
[(g6)] .22789 .09354 0 0 Mshowa
[(g5)] .36395 .09354 0 0 Mshowa
[(g4)] .5 .09354 0 0 Mshowa
[(g3)] .63605 .09354 0 0 Mshowa
[(g2)] .77211 .09354 0 0 Mshowa
[(g1)] .90816 .09354 0 0 Mshowa
[(g1)] .09184 .77381 0 0 Mshowa
[(g2)] .09184 .63776 0 0 Mshowa
[(g3)] .09184 .5017 0 0 Mshowa
[(g4)] .09184 .36565 0 0 Mshowa
[(g5)] .09184 .22959 0 0 Mshowa
[(g6)] .09184 .09354 0 0 Mshowa
[(g1)] .22789 .90986 0 0 Mshowa
[(g2)] .36395 .90986 0 0 Mshowa
[(g3)] .5 .90986 0 0 Mshowa
[(g4)] .63605 .90986 0 0 Mshowa
[(g5)] .77211 .90986 0 0 Mshowa
[(g6)] .90816 .90986 0 0 Mshowa
[(S[3])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
1 Mabswid
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@0002T00mlR00?O8@03gb800mlQ00?OAP03g`D000060?oo0Ol00ml0000300001P000ol0
000P00;o0mlP0003golS028S00?o8b<08R<00olS8`0Q8`03ob<S024S00?o00007`03g`03oml000@0
00060003o`0002000_l4gal000?Oob<08R<00olS8`0R8`03ob<S024S00?o8b<08B<00ol0000N00CO
00?o0000100000H000?o00008002o`GO7`000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03
o`0001d01Ml00ol0000400001P000ol0000P00;o00<0gml00mlN0003ob<S024S00?o8b<08R<00olS
8`0Q8`03ob<S024S00?o00007005g`030?l000D000060003o`0002000_l200GO7@000olS8`0Q8`03
ob<S028S00?o8b<08B<00olS8`0Q8`03o`0001/01Ml20003o`0000@000060003o`0002000_l300GO
70000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03o`0001X01Ml30003o`0000@000060003
o`0002000_l400GO6`000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03o`0001T01Ml40003
o`0000@000060003o`0002000_l500GO6P000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03
o`0001P01Ml50003o`0000@000060003o`0002000_l600GO6@000olS8`0Q8`03ob<S028S00?o8b<0
8B<00olS8`0Q8`03o`0001L01Ml60003o`0000@000060003o`0002000_l700GO60000olS8`0Q8`03
ob<S028S00?o8b<08B<00olS8`0Q8`03o`0001H01Ml70003o`0000@000060003o`0002000_l800GO
5`000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03o`0001D01Ml80003o`0000@000060003
o`0002000_l900GO5P000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03o`0001@01Ml90003
o`0000@000060003o`0002000_l:00GO5@000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03
o`0001<01Ml:0003o`0000@000060003o`0002000_l;00GO50000olS8`0Q8`03ob<S028S00?o8b<0
8B<00olS8`0Q8`03o`0001801Ml;0003o`0000@000060003o`0000/00olB00;o3002g`?o4`000olS
8`0;8`?o4b<00olS8`0;8`?o52<00olS8`0;8`?o4b<00olS8`0;8`?o4b<00ol0000<00?o0P05g``0
00?o0000100000H000?o00003P000ol0000?00;o3@04g`03o`00010000?o8b<03R<00olS8`0@8`03
ob<S00hS00?o8b<04B<00olS8`0>8`03ob<S010S00?o8b<03R<00olS8`0@8`03o`0000l000?ogml0
0ml=0003o`0000@000060003o`0000/01?l200;o3@02o`h01?l01=l0ool>0003ob<S00/S1?l012?o
ool>8`03ob<S00/S1?l28`?o3R<00olS8`0;8`Co00@Soooo3R<00olS8`0;8`Co00<Sool00_l=8`03
o`0000`01?l01=ooool>0003o`0000@000060003o`0000X000Oo0000o`3o008000?o00002P02o`d0
00Oo0=oOomoo008000?o00002`000olS8`0:8`05ob<S8ol012<00olS8`0;8`03ob<S00XS00Go8b<S
o`038`03ob<S00dS00?o8b<02R<01OlS8b?o00@S00?o8b<02b<00olS8`0:8`05ob<S8ol00R<00olS
8`0=8`03o`0000/000Go003Oo`02g`03o`0000d000?o0000100000H000?o00002P001ol0003o0?l0
0P000ol0000:00;o3@002_l00=oogooO0?l=0003ob<S00XS00Go8b<So`048`03ob<S00/S00?o8b<0
2R<01_lS8b?o8`Co3R<00olS8`0:8`05ob<S8ol012<00olS8`0;8`03ob<S00XS00Go8b<So`038`03
ob<S00`S00?o00002`001Ol0gmoo00;O00?o00003@000ol0000400001P000ol0000:0006o`000?l0
0ol=00;o3@001_l0003og`?o3P000olS8`0:8`06ob<S8olS0ol>8`03ob<S00XS00Wo8b<Sob?o8ol0
3b<00olS8`0:8`05ob<S8ol00R<2o`hS00?o8b<02R<01OlS8b?o00@S00?o8b<02b<00ol0000;0008
omoOgooO0?l?0003o`0000@000060003o`0000/01_l?00;o3P06o`?O3@000olS8`0;8`Ko42<00olS
8`0;8`Ko00<Sob<03R<00olS8`0;8`Go0b<00olS8`0;8`03ob<S00/S1_l28`03ob<S00/S00?o0000
2`000mooo`03o`030?l000h000?o0000100000H000?o00004@03o``00_lC0005gooooml030000olS
8`0@8`Co3B<00olS8`0A8`;o3b<00olS8`0@8`?o3R<00olS8`0A8`;o3R<00ol0000:00GO0P02o`l0
00?o0000100000H000?o00008002oa@01Ml;0003ob<S024S00?o8b<08R<00olS8`0Q8`03ob<S024S
00?o00002@05ga@000?o0000100000H000?o00008002oaD01Ml:0003ob<S024S00?o8b<08R<00olS
8`0Q8`03ob<S024S00?o00002005gaD000?o0000100000H000?o00008002oaH01Ml90003ob<S024S
00?o8b<08R<00olS8`0Q8`03ob<S024S00?o00001`05gaH000?o0000100000H000?o00008002oaL0
1Ml80003ob<S024S00?o8b<08R<00olS8`0Q8`03ob<S024S00?o00001P05gaL000?o0000100000H0
00?o00008002oaP01Ml70003ob<S024S00?o8b<08R<00olS8`0Q8`03ob<S024S00?o00001@05gaP0
00?o0000100000H000?o00008002oaT01Ml60003ob<S024S00?o8b<08R<00olS8`0Q8`03ob<S024S
00?o00001005gaT000?o0000100000H000?o00008002oaX01Ml50003ob<S024S00?o8b<08R<00olS
8`0Q8`03ob<S024S00?o00000`05gaX000?o0000100000H000?o00008002oa/01Ml40003ob<S024S
00?o8b<08R<00olS8`0Q8`03ob<S024S00?o00000P05ga/000?o0000100000H000?o00008002oa`0
1Ml30003ob<S024S00?o8b<08R<00olS8`0Q8`03ob<S024S00Co00001MlL0003o`0000@000060003
o`0002000_lM00GO0P000olS8`0Q8`03ob<S028S00?o8b<08B<00olS8`0Q8`03o`0000GO7@000ol0
000400001P000ol0000P00;o7P05g`030?lS028S00?o8b<08R<00olS8`0Q8`03ob<S024S00?o0=l0
1=lN0003o`0000@000060003o`0002000_lO00GO00?o8b<08B<00olS8`0R8`03ob<S024S00?o8b<0
8B<00ooOg`03gal000?o0000100000H000?o00008002ob001=l00olS8`0Q8`03ob<S028S00?o8b<0
8B<00olS8`0Q8`03omoO00;O80000ol0000400001P000ol0000P00;o00?O00007P03g`03ob<S024S
00?o8b<08R<00olS8`0Q8`03ob<S024S00CogmoO8@000ol0000400001P3oo`7o1P0000H000?o0000
8002o`?O80000moo8`0R8`03ob<S028S00CogmoO7`000moog`02gad00ml00olS8`0R8`03o`0000@0
00060003o`0002000_l4gb0000?o8b<08B<00olS8`0R8`03omoO00;O7`000ooOg`02ga/01=l00olS
8`0R8`03o`0000@000060003o`0002000_l5gal000?o8b<08B<00olS8`0R8`03omoO00?O7P000ooO
g`03gaT01Ml00olS8`0R8`03o`0000@000060003o`0002000_l00`3Og`03gah000?o8b<08B<00olS
8`0R8`03o`3O00CO7@000ol0g`04gaL01Ml00`3o8`0S8`03o`0000@000060003o`0002000_l200GO
7@000olS8`0Q8`03ob<S028S00?o00001MlL0003o`0000GO5@05g`8000?o8b<08R<00ol000040000
1P000ol0000P00;o0`05ga`000?o8b<08B<00olS8`0R8`04o`0000GO6`001?l00005ga<01Ml30003
ob<S028S00?o0000100000H000?o00008002o`@01MlK0003ob<S024S00?o8b<08R<00ol0000200GO
6P000ol0000200GO4@05g`@000?o8b<08R<00ol0000400001P000ol0000P00;o1@05gaX000?o8b<0
8B<00olS8`0R8`03o`0000<01MlI0003o`0000<01Ml?00GO1@000olS8`0R8`03o`0000@000060003
o`0002000_l600GO6@000olS8`0Q8`03ob<S028S00?o00001005gaP000?o00001005g`d01Ml60003
ob<S028S00?o0000100000H000?o00008002o`L01MlH0003ob<S024S00?o8b<08R<00ol0000500GO
5`000ol0000500GO2`05g`L000?o8b<08R<00ol0000400001P000ol0000P00;o2005gaL000?o8b<0
8B<00olS8`0R8`03o`0000H01MlF0003o`0000H01Ml900GO20000olS8`0R8`03o`0000@000060003
o`0002000_l900GO5P000olS8`0Q8`03ob<S028S00?o00001`05gaD000?o00001`05g`L01Ml90003
ob<S028S00?o0000100000H000?o00008002o`X01MlE0003ob<S024S00?o8b<08R<00ol0000800GO
50000ol0000800GO1@05g`X000?o8b<08R<00ol0000400001P000ol0000;00?o4P02o`/00ml3oa<0
00?o8b<02b<3oa<S00?o8b<02b<3oa@S00?o00002@02g`?o4`000ol0000900;O0ol300GO2`000olS
8`0<8`?o4b<00ol0000400001P000ol0000>0003o`0000l00_l<00GO00?o000040000olS8`0>8`03
ob<S010S00?o8b<03R<00olS8`0A8`03o`0000X01=l00ol0000@0003o`0000X01=l00ol0g`04g``0
00?o8b<03b<00olS8`0@8`03o`0000@000060003o`0000/01?l0103oool=00;o3@000mooo`02o`04
0?ooo`h000?o8b<02b<4o`8S0_l>8`03ob<S00/S1?l00b?oo`02o`hS00?o00002`04o`04goooo`h0
00?o00002`04o`;O0ol=0003ob<S00`S1?l012?oool>8`03o`0000@000060003o`0000X000Go0000
o`040003o`0000X00_l=0006omoOgooO0`000ol0000;0003ob<S00XS00Oo8b<Sob?o008S00?o8b<0
2b<00olS8`0:8`05ob<S8ol00R<00olS8`0>8`03o`0000X000Go0=oOo`02g`03o`0000d000?o0000
2P001Ol0gmoo00?O00?o000030000olS8`0;8`05ob<S8ol012<00olS8`0;8`03o`0000@000060003
o`0000X000Go0000o`040003o`0000X00_l=0005o`3Ogol00]l20003o`0000/000?o8b<02R<01olS
8b?o8ol00R<00olS8`0;8`03ob<S00XS00Go8b<So`038`03ob<S00dS00?o00002P001Ol00=oo00;O
00?o00003@000ol0000:0006o`00gooO1?l=0003ob<S00/S00Go8b<So`048`03ob<S00/S00?o0000
100000H000?o00002P001_l0003o00?o3@02o`d000Ko003Ooml3o`h000?o8b<02R<01_lS8b?o8`?o
3R<00olS8`0:8`05ob<S8ol012<00olS8`0<8`03o`0000X000Go0000o`02g`03oml000d000?o0000
2P002Ol0gmoogooOo`0>0003ob<S00/S00Go8b<So`028`;o3R<00ol0000400001P000ol0000;00Ko
3`02o`h01_l2g`h000?o8b<02b<6oa0S00?o8b<02b<6o`8S00?o8b<032<00ol0000;00Go00COomoO
3@000ol0000;00Ko00?Ooml03@000olS8`0<8`Go0b<00olS8`0;8`03o`0000@000060003o`000100
1?l<00;o4P000mooo`02o`d000?o8b<04B<3o`dS00?o8b<04B<2o`lS00?o00004002o`?O30000ol0
000:00GO00@0gooo0]l<0003ob<S014S0ol>8`03o`0000@000060003o`0002000_lC00GO30000olS
8`0Q8`03ob<S028S00?o00004@05g`/000?o00002@05g`<01Ml;0003ob<S028S00?o0000100000H0
00?o00008002oa@01Ml;0003ob<S024S00?o8b<08R<00ol0000B00GO2P000ol0000800GO1@05g`X0
00?o8b<08R<00ol0000400001P000ol0000P00;o5@05g`X000?o8b<08B<00olS8`0R8`03o`0001<0
1Ml90003o`0000L01Ml700GO2@000olS8`0R8`03o`0000@000060003o`0002000_lF00GO2@000olS
8`0Q8`03ob<S028S00?o00005005g`P000?o00001P05g`T01Ml80003ob<S028S00?o0000100000H0
00?o00008002oaL01Ml80003ob<S024S00?o8b<08R<00ol0000E00GO1`000ol0000500GO2`05g`L0
00?o8b<08R<00ol0000400001P000ol0000P00;o6005g`L000?o8b<08B<00olS8`0R8`03o`0001H0
1Ml60003o`0000@01Ml=00GO1P000olS8`0R8`03o`0000@000060003o`0002000_lI00GO1P000olS
8`0Q8`03ob<S028S00?o00005`05g`D000?o00000`05g`l01Ml50003ob<S028S00?o0000100000H0
00?o00008002oaX01Ml50003ob<S024S00?o8b<08R<00ol0000H00GO10000ol0000200GO4@05g`@0
00?o8b<08R<00ol0000400001P000ol0000P00;o6`05g`@000?o8b<08B<00olS8`0R8`03o`0001T0
1Ml30004o`0000GO4`05g`<000?o8b<08R<00ol0000400001P000ol0000P00;o7005g`<000?o8b<0
8B<00olS8`0R8`03o`0001X01Ml20003o`0000GO5@05g`8000?o8b<08R<00ol0000400001P000ol0
000P00;o7@05g`8000?o8b<08B<00olS8`0R8`03o`0001/01Ml00`3o0005gaL01Ml00`3o8`0S8`03
o`0000@000060003o`0002000_lN00GO00<0ob<08R<00olS8`0R8`03o`0001`01Ml00ooOg`03gaT0
1Ml00olS8`0R8`03o`0000@000060003o`0002000_lO00GO00?o8b<08B<00olS8`0R8`03o`0001d0
1=l00ooOg`02ga/01=l00olS8`0R8`03o`0000@000060003o`0002000_l00ml0000M00CO00?o8b<0
8B<00olS8`0R8`03o`0001h00ml01?oOgmlM00?O00?o8b<08R<00ooO000400001P3oo`7o00?O0000
0`0000H000?o00008002o`?O7`02g`03ob<S024S00?o8b<08R<00ooOg`0N00?O00CogmoO7`000moo
8`0S8`03oml000@000060003o`0002000_l4gal000?Oob<08R<00olS8`0R8`04omoOga`01=l00ooO
g`02gal000?o8b<08R<00ol0000400001P000ol0000P00;o1MlO0003ob<S024S00?o8b<08R<00ooO
g`02gaX01Ml00ooOg`03gah000?o8b<08R<00ol0000400001P000ol0000P00;o00<0gml00mlN0003
ob<S024S00?o8b<08R<00ooOg`03gaP01Ml00`3o0005gad000?o8b<08R<00ol0000400001P000ol0
000P00;o0P05gad000?o8b<08B<00olS8`0R8`03o`3O00CO5P05g`8000?o00001MlL0003ob<S028S
00?o0000100000H000?o00008002o`<01MlL0003ob<S024S00?o8b<08R<00ol00005ga@01Ml30004
o`0000GO6`000olS8`0R8`03o`0000@000060003o`0002000_l400GO6`000olS8`0Q8`03ob<S028S
00Co00001MlB00GO10000ol0000200GO6P000olS8`0R8`03o`0000@000060003o`0002000_l500GO
6P000olS8`0Q8`03ob<S028S00?o00000P05ga001Ml50003o`0000<01MlI0003ob<S028S00?o0000
100000H000?o00008002o`H01MlI0003ob<S024S00?o8b<08R<00ol0000300GO3P05g`H000?o0000
1005gaP000?o8b<08R<00ol0000400001P000ol0000P00;o1`05gaP000?o8b<08B<00olS8`0R8`03
o`0000@01Ml<00GO1`000ol0000500GO5`000olS8`0R8`03o`0000@000060003o`0002000_l800GO
5`000olS8`0Q8`03ob<S028S00?o00001@05g`X01Ml80003o`0000H01MlF0003ob<S028S00?o0000
100000H000?o00008002o`T01MlF0003ob<S024S00?o8b<08R<00ol0000600GO2005g`T000?o0000
1`05gaD000?o8b<08R<00ol0000400001P000ol0000P00;o2P05gaD000?o8b<08B<00olS8`0R8`03
o`0000L01Ml600GO2P000ol0000800GO50000olS8`0R8`03o`0000@000060003o`0000/00olB00;o
2`03g`?o4`000olS8`0;8`?o4b<00olS8`0;8`?o52<00ol0000800?O0ol300GO2`000ol0000900;O
0olC0003ob<S00`S0olC8`03o`0000@000060003o`0000h000?o00003`02o``01Ml00ol0000@0003
ob<S00hS00?o8b<042<00olS8`0>8`03ob<S014S00?o00002@05g`03o`3O00CO30000ol0000:00CO
00?o000040000olS8`0?8`03ob<S010S00?o0000100000H000?o00002`04o`800ol<00;o3@000moo
o`02o`800ol=0003ob<S00/S1?l012?oool>8`03ob<S00/S1?l28`;o3b<00ol0000:0003gooo00;o
00GOoooog`0=0003o`0000/01?l01=ooool>0003ob<S00`S1?l00b?oo`02o`dS00?o0000100000H0
00?o00002P001Ol0003o00<000?o00002`02o`d000KogmoOoml20003o`0000`000?o8b<02R<01OlS
8b?o00@S00?o8b<02b<00olS8`0:8`07ob<S8olSo`028`03ob<S00`S00?o00002P001OoOgmoo00CO
00?o00002`000ol0000:0005o`3Ogol00]l00ol0000=0003ob<S00/S00Go8b<So`028`03ob<S00dS
00?o0000100000H000?o00002P001_l0003o00Co3002o`d000Ko0=oOoml4o`d000?o8b<02R<01OlS
8b?o00@S00?o8b<02b<00olS8`0:8`07ob<S8olSo`028`03ob<S00`S00?o00002P001Ol0gmoo00?O
00<0o`0030000ol0000:0005o`00gol00]l00ol0000=0003ob<S00/S00Go8b<So`038`03ob<S00`S
00?o0000100000H000?o00002P002Ol0003o0?l0o`0=00;o3@002Ol00=oogooOo`0>0003ob<S00XS
00Go8b<So`028`;o3R<00olS8`0:8`06ob<S8olS0ol?8`03o`0000X000Ko0=oOoml3o`h000?o0000
2P001Ol0003o00;O00?og`003@000olS8`0;8`05ob<S8ol012<00olS8`0;8`03o`0000@000060003
o`0000/01_l00`3o000<00;o3P06o`03gol000d000?o8b<02b<5o`<S00?o8b<02b<00olS8`0;8`Ko
4B<00ol0000;00Ko0]l>0003o`0000/01Ol01=oogml=0003ob<S00`S1_l28`03ob<S00/S00?o0000
100000H000?o00004@02o`d00_lB00;O0_l00ml0000;0003ob<S010S0ol>8`03ob<S014S0ol>8`03
o`0000X01]l4o`d000?o00004002o`?O30000olS8`0B8`;o3R<00ol0000400001P000ol0000P00;o
4`05g``000?o8b<08B<00olS8`0R8`03o`0000T01Ml200GO30000ol0000A00GO2`000olS8`0R8`03
o`0000@000060003o`0002000_lD00GO2`000olS8`0Q8`03ob<S028S00?o00002005g`@01Ml;0003
o`0001801Ml:0003ob<S028S00?o0000100000H000?o00008002oaD01Ml:0003ob<S024S00?o8b<0
8R<00ol0000700GO1P05g`X000?o00004`05g`T000?o8b<08R<00ol0000400001P000ol0000P00;o
5P05g`T000?o8b<08B<00olS8`0R8`03o`0000H01Ml800GO2@000ol0000D00GO20000olS8`0R8`03
o`0000@000060003o`0002000_lG00GO20000olS8`0Q8`03ob<S028S00?o00001@05g`X01Ml80003
o`0001D01Ml70003ob<S028S00?o0000100000H000?o00008002oaP01Ml70003ob<S024S00?o8b<0
8R<00ol0000400GO3005g`L000?o00005P05g`H000?o8b<08R<00ol0000400001P000ol0000P00;o
6@05g`H000?o8b<08B<00olS8`0R8`03o`0000<01Ml>00GO1P000ol0000G00GO1@000olS8`0R8`03
o`0000@000060003o`0002000_lJ00GO1@000olS8`0Q8`03ob<S028S00?o00000P05ga001Ml50003
o`0001P01Ml40003ob<S028S00?o0000100000H000?o00008002oa/01Ml40003ob<S024S00?o8b<0
8R<01?l00005ga801Ml40003o`0001T01Ml30003ob<S028S00?o0000100000H000?o00008002oa`0
1Ml30003ob<S024S00?o8b<08R<00ol00005ga@01Ml30003o`0001X01Ml20003ob<S028S00?o0000
100000H000?o00008002oad01Ml20003ob<S024S00?o8b<08R<00ol0g`04gaH01Ml20003o`0001/0
1Ml00`3o8`0S8`03o`0000@000060003o`0002000_lN00GO00<0ob<08R<00olS8`0R8`03omoO00?O
6005g`030?l001d01Ml00olS8`0R8`03o`0000@000060003o`0002000_lO00GO00?o8b<08B<00olS
8`0R8`03omoO00;O6P05g`03o`0001d01=l00olS8`0R8`03o`0000@000060003o`0002000_lP00CO
00?o8b<08B<00olS8`0R8`04omoOga`01=l00ol0000N00?O00?o8b<08R<00ol0000400001P000ol0
000P00;o0]lO00?O00?o8b<08B<00olS8`0R8`03omoO01h00ml00ooO000O00;O00?o8b<08R<00ooO
000400001P3oo`7o00?O00000`0000H000?o00008002o`CO7`000moo8`0R8`04omoOgad01=l00olS
8`0Q8`03ob<S024S00?o8b<08R<00ooO000400001P000ol0000P00;o1MlO0003ob<S024S00?ogml0
0]lK00GO00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o00008002o`030=oO00?O
7P000olS8`0Q8`03omoO00?O6@05g`030?lS028S00?o8b<08B<00olS8`0R8`03o`0000@000060003
o`0002000_l200GO7@000olS8`0Q8`03o`3O00CO5`05g`8000?o8b<08B<00olS8`0Q8`03ob<S028S
00?o0000100000H000?o00008002o`<01MlL0003ob<S024S00?o00001MlE00GO0`000olS8`0Q8`03
ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o1005ga/000?o8b<08B<01?l00005ga<0
1Ml40003ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`0002000_l500GO6P000olS
8`0Q8`03o`0000801MlA00GO1@000olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0
000P00;o1P05gaT000?o8b<08B<00ol0000300GO3`05g`H000?o8b<08B<00olS8`0Q8`03ob<S028S
00?o0000100000H000?o00008002o`L01MlH0003ob<S024S00?o00001005g`d01Ml70003ob<S024S
00?o8b<08B<00olS8`0R8`03o`0000@000060003o`0002000_l800GO5`000olS8`0Q8`03o`0000D0
1Ml;00GO20000olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o2@05gaH0
00?o8b<08B<00ol0000600GO2@05g`T000?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H0
00?o00008002o`X01MlE0003ob<S024S00?o00001`05g`L01Ml:0003ob<S024S00?o8b<08B<00olS
8`0R8`03o`0000@000060003o`0002000_l;00GO50000olS8`0Q8`03o`0000P01Ml500GO2`000olS
8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000;00?o4P02o``00]l3oa<000?o8b<0
2b<3oa<S00?o00002@02g`?o0`05g``000?o8b<02b<3oa<S00?o8b<02b<3oa<S00?o8b<032<3oa<S
00?o0000100000H000?o00003P000ol0000?00;o3@04g`03o`00010000?o8b<03R<00olS8`0@8`03
o`0000X01=l00ol0g`04g`d000?o8b<03R<00olS8`0@8`03ob<S00hS00?o8b<042<00olS8`0?8`03
ob<S010S00?o0000100000H000?o00002`04o`040?ooo`d00_l>00Co00COoooo3P000olS8`0;8`Co
0R<3o`dS00?o00002`04o`05gooooml03P000olS8`0;8`Co00<Sool00_l=8`03ob<S00/S1?l28`;o
3R<00olS8`0<8`Co00@Soooo3R<00ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o
3@001Ol0gmoo00;O0P000ol0000;0003ob<S00XS00Go8b<So`038`03ob<S00`S00?o00002P001Ol0
gmoo00;O00?og`003P000olS8`0:8`05ob<S8ol00R<00olS8`0=8`03ob<S00XS00Oo8b<Sob?o008S
00?o8b<02b<00olS8`0;8`05ob<S8ol012<00olS8`0;8`03o`0000@000060003o`0000X000Go0000
o`040003o`0000X00_l=0005o`00gol00ml00`3o000<0003ob<S00XS00Ko8b<Sob<4o`dS00?o0000
2P001Ol00=oo00;O00?o00003P000olS8`0:8`05ob<S8ol00b<00olS8`0<8`03ob<S00XS00Oo8b<S
ob?o008S00?o8b<02b<00olS8`0;8`05ob<S8ol012<00olS8`0;8`03o`0000@000060003o`0000X0
00Go0000o`0200;o3@02o`d000Go0000o`02g`;o3P000olS8`0:8`09ob<S8olSob?o00hS00?o0000
2P001Ol0gmoo00;O00?og`003P000olS8`0:8`05ob<S8ol012<00olS8`0;8`03ob<S00XS00Ko8b<S
ob<3o`hS00?o8b<02b<01_lS8b?o8`?o3R<00ol0000400001P000ol0000;00Go0`000ol0000:00;o
3P05o`?O00?o00002`000olS8`0;8`Ko00<Sob<03B<00ol0000;00Go00COomoO3P000olS8`0;8`Ko
0R<00olS8`0;8`03ob<S00/S1_l@8`03ob<S00`S1_l@8`03o`0000@000060003o`0001000ol=00;o
4`03o`;O30000olS8`0A8`;o3R<00ol0000:00GO00<0ool00ml=0003ob<S014S0_l>8`03ob<S014S
0ol=8`03ob<S014S1?l=8`03o`0000@000060003o`0002000_lD00GO2`000olS8`0Q8`03o`0000T0
1Ml300GO30000olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o5@05g`X0
00?o8b<08B<00ol0000800GO1@05g`/000?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H0
00?o00008002oaH01Ml90003ob<S024S00?o00001`05g`L01Ml:0003ob<S024S00?o8b<08B<00olS
8`0R8`03o`0000@000060003o`0002000_lG00GO20000olS8`0Q8`03o`0000H01Ml900GO2@000olS
8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o6005g`L000?o8b<08B<00ol0
000500GO2`05g`P000?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o00008002oaT0
1Ml60003ob<S024S00?o00001005g`d01Ml70003ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@0
00060003o`0002000_lJ00GO1@000olS8`0Q8`03o`0000<01Ml?00GO1P000olS8`0Q8`03ob<S024S
00?o8b<08R<00ol0000400001P000ol0000P00;o6`05g`@000?o8b<08B<00ol0000200GO4@05g`D0
00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o00008002oa`01Ml30003ob<S024S
00Co00001MlC00GO10000olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o
7@05g`8000?o8b<08B<00ol00005gaD01Ml30003ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@0
00060003o`0002000_lN00GO00<0ob<08R<00ol0g`04gaL01Ml20003ob<S024S00?o8b<08B<00olS
8`0R8`03o`0000@000060003o`0002000_lO00GO00?o8b<08B<00ooOg`03gaT01Ml00`3o8`0R8`03
ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o8004g`03ob<S024S00?ogml00]lK00GO
00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o00008002o`03g`0001h00ml00olS
8`0Q8`04omoOgad01=l00olS8`0Q8`03ob<S024S00?o8b<08R<00ooO000400001P3oo`7o00?O0000
0`0000H000?o00008002o`?O80000moog`02gad00ml00olS8`0R8`03ob<S024S00?o8b<08B<00olS
8`0R8`03oml000@000060003o`0002000_l4gb0000?ogml00]lK00CO00?o8b<08R<00olS8`0Q8`03
ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o1MlO0003omoO00?O6@05g`03ob<S028S
00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o00008002o`030=oO00?O7P000ol0
g`04gaL01Ml00`3o8`0S8`03ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`000200
0_l200GO7@000ol00005gaD01Ml20003ob<S028S00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000
100000H000?o00008002o`<01MlL0004o`0000GO4`05g`<000?o8b<08R<00olS8`0Q8`03ob<S024S
00?o8b<08R<00ol0000400001P000ol0000P00;o1005ga/000?o00000P05ga401Ml40003ob<S028S
00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o00008002o`D01MlJ0003o`0000<0
1Ml?00GO1@000olS8`0R8`03ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`000200
0_l600GO6@000ol0000400GO3@05g`H000?o8b<08R<00olS8`0Q8`03ob<S024S00?o8b<08R<00ol0
000400001P000ol0000P00;o1`05gaP000?o00001@05g`/01Ml70003ob<S028S00?o8b<08B<00olS
8`0Q8`03ob<S028S00?o0000100000H000?o00008002o`P01MlG0003o`0000H01Ml900GO20000olS
8`0R8`03ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`0002000_l900GO5P000ol0
000700GO1`05g`T000?o8b<08R<00olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0
000P00;o2P05gaD000?o00002005g`D01Ml:0003ob<S028S00?o8b<08B<00olS8`0Q8`03ob<S028S
00?o0000100000H000?o00002`03oa800_l;00?O0olC0003o`0000T00]l3o`<01Ml;0003ob<S00/S
0olD8`03ob<S00/S0olC8`03ob<S00/S0olC8`03ob<S00`S0olC8`03o`0000@000060003o`0000h0
00?o00003`02o``01Ml00ol0000@0003o`0000X01=l00ol0g`04g``000?o8b<03R<00olS8`0A8`03
ob<S00hS00?o8b<042<00olS8`0>8`03ob<S010S00?o8b<03b<00olS8`0@8`03o`0000@000060003
o`0000/01?l00`3oo`02o``00_l=0003gooo00;o00<0ool00_l=0003o`0000/01?l01MoooooO00d0
00?o8b<02b<4o`048oooo`lS00?o8b<02b<4o`8S0_l>8`03ob<S00/S1?l012?oool>8`03ob<S00`S
1?l28`?o3B<00ol0000400001P000ol0000:0005o`000?l00P000ol0000<00;o3@002?oOgmoog`3o
3`000ol0000:0005o`3Ogol00]l00ooO000=0003ob<S00XS00Go8b<So`048`03ob<S00`S00?o8b<0
2R<01olS8b?o8ol00R<00olS8`0;8`03ob<S00XS00Go8b<So`048`03ob<S00/S00?o8b<02b<01OlS
8b?o00<S00?o8b<032<00ol0000400001P000ol0000:0005o`000?l00`000ol0000;00;o3@001Ol0
gmoo00;O00<0o`003@000ol0000:0005o`00gol00]l00ol0000=0003ob<S00XS00Go8b<So`048`03
ob<S00`S00?o8b<02R<01olS8b?o8ol00R<00olS8`0;8`03ob<S00XS00Go8b<So`048`03ob<S00/S
00?o8b<02b<01_lS8b?o8`Co3B<00ol0000400001P000ol0000:0005o`000?l010000ol0000:00;o
3@001Ol00=oo00?O00<0o`0030000ol0000:0005o`3Ogol00]l00ooO000=0003ob<S00XS00Ko8b<S
ob<3o`lS00?o8b<02R<01_lS8b?o8`?o3R<00olS8`0:8`05ob<S8ol00R<2o`hS00?o8b<02b<02OlS
8b?o8olSo`0>8`03o`0000@000060003o`0000/01_l20003o`0000X00_l>00Ko0]l00ol0000;0003
o`0000/01Ol01=oogml=0003ob<S00/S1_lA8`03ob<S00/S1_l@8`03ob<S00/S1Ol38`03ob<S00/S
00?o8b<032<6o`038olS00dS00?o0000100000H000?o00004@02o`d00_lB00;O0_l00ml0000;0003
o`0000X01Ml00`3oo`03g``000?o8b<042<4o`hS00?o8b<04B<3o`dS00?o8b<042<3o`hS00?o8b<0
4R<2o`hS00?o0000100000H000?o00008002oa<01Ml<0003o`0000T01Ml300GO2`000olS8`0R8`03
ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`0002000_lD00GO2`000ol0000800GO
1@05g`X000?o8b<08R<00olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o
5@05g`X000?o00001`05g`L01Ml90003ob<S028S00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000
100000H000?o00008002oaH01Ml90003o`0000H01Ml900GO20000olS8`0R8`03ob<S024S00?o8b<0
8B<00olS8`0R8`03o`0000@000060003o`0002000_lG00GO20000ol0000500GO2`05g`L000?o8b<0
8R<00olS8`0Q8`03ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o6005g`L000?o0000
1005g`d01Ml60003ob<S028S00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o0000
8002oaT01Ml60003o`0000<01Ml?00GO1@000olS8`0R8`03ob<S024S00?o8b<08B<00olS8`0R8`03
o`0000@000060003o`0002000_lJ00GO1@000ol0000200GO4@05g`@000?o8b<08R<00olS8`0Q8`03
ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o6`05g`@000Co00001MlC00GO0`000olS
8`0R8`03ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`0002000_lL00GO0`000ol0
0005gaD01Ml20003ob<S028S00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000100000H000?o0000
8002oad01Ml20003o`3O00CO5`05g`030?lS02<S00?o8b<08B<00olS8`0Q8`03ob<S028S00?o0000
100000H000?o00008002oah01Ml00`3og`04gaT01Ml00olS8`0R8`03ob<S024S00?o8b<08B<00olS
8`0R8`03o`0000@000060003o`0002000_lO00GO00?ogml00]lK00CO00?o8b<08R<00olS8`0Q8`03
ob<S024S00?o8b<08R<00ol0000400001P000ol0000P00;o8004g`04omoOgad00ml00olS8`0R8`03
ob<S024S00?o8b<08B<00olS8`0R8`03o`0000@000060003o`0002000_lQ00?O00?ogml07`02g`03
ob<S028S00?o8b<08B<00olS8`0Q8`03ob<S028S00?og`00100000H0ool1o`03g`0000<000060003
o`0002000_lP00CO00CogmoO80000ooOg`02gal000?Ooml00]lO0003gooO00;O80000ooOg`02gal0
00?Ooml01@0000H000?o00008002oal01Ml00ooOg`02gal000?ogml00mlO0003omoO00;O7`000ooO
g`02gal000?ogml00mlO0003o`0000@000060003o`0002000_lN00GO00<0oml01=lN0003o`3O00CO
7P000ooOg`03gah000?ogml00mlN0003o`3O00CO7P000ol0000400001P000ol0000P00;o7@05g`80
00?o0=l01=lM0003o`0000GO7@000ol0g`04gad000?o0=l01=lM0003o`0000GO7@000ol000040000
1P000ol0000P00;o7005g`<000?o00001MlL0004o`0000GO70000ol00005ga`000?o00001MlL0004
o`0000GO70000ol0000400001P000ol0000P00;o6`05g`@000Co00001MlK0003o`0000801MlK0004
o`0000GO6`001?l00005ga/000?o00000P05ga/000?o0000100000H000?o00008002oaX01Ml50003
o`0000801MlJ0003o`0000<01MlJ0003o`0000801MlJ0003o`0000801MlJ0003o`0000<01MlJ0003
o`0000@000060003o`0002000_lI00GO1P000ol0000300GO6@000ol0000400GO6@000ol0000300GO
6@000ol0000300GO6@000ol0000400GO6@000ol0000400001P000ol0000P00;o6005g`L000?o0000
1005gaP000?o00001@05gaP000?o00001005gaP000?o00001005gaP000?o00001@05gaP000?o0000
100000H000?o00008002oaL01Ml80003o`0000D01MlG0003o`0000H01MlG0003o`0000D01MlG0003
o`0000D01MlG0003o`0000H01MlG0003o`0000@000060003o`0002000_lF00GO2@000ol0000600GO
5P000ol0000700GO5P000ol0000600GO5P000ol0000600GO5P000ol0000700GO5P000ol000040000
1P000ol0000P00;o5@05g`X000?o00001`05gaD000?o00002005gaD000?o00001`05gaD000?o0000
1`05gaD000?o00002005gaD000?o0000100000H000?o00008002oa@01Ml;0003o`0000P01MlD0003
o`0000T01MlD0003o`0000P01MlD0003o`0000P01MlD0003o`0000T01MlD0003o`0000@000060003
o`0000/00olB00;o3P03o`801Ml<0003o`0000T00]l3oa<000?o00002P001MoooooO01<000?o0000
2@02g`?o4`000ol0000900;O0olC0003o`0000X00]l3oa<000?o0000100000H000?o00003P000ol0
000?00;o4@000ooOg`03g`d000?o00002P04g`03o`00010000?o00002`03g`03oml0014000?o0000
2P04g`03o`00010000?o00002P04g`03o`00010000?o00002`04g`03o`00010000?o0000100000H0
00?o00002`04o`040?ooo`d00_l>00Co00COoooo3P000ol0000;00Co00?Oool00_l=0003o`0000/0
1?l01=ooool?0003o`0000/01?l00ml0o`02o`d000?o00002`04o`04goooo`h000?o00003004o`04
g`3oo`h000?o0000100000H000?o00002P001Ol0003o008000?o00003002o`d000Go003Oo`02g`03
o`0000d000?o00002P001Ol0gmoo00;O00?o00003@000ol0000:0005o`00gol00ml00`3o000=0003
o`0000X000Go0=oOo`02g`030?l000d000?o00002P001Ol0gmoo00;O0P000ol0000;0003o`0000/0
00Oo0=oOomoo008000?o00002`000ol0000400001P000ol0000:0005o`000?l00P000ol0000<00;o
3@001Ol0gmoo00;O00?o00003@000ol0000:0005o`00gol00ml00ol0000<0003o`0000X000Go0000
o`04g`03o`0000`000?o00002P001_l00=oog`Co3@000ol0000:0005o`00gol00ml00`3o000<0003
o`0000/000[o003Oomoog`3o3@000ol0000400001P000ol0000:0005o`000?l00P000ol0000<00;o
3@002?oOgmoog`3o3`000ol0000:0005o`000?l01=l00ol0000;0003o`0000X000Go0000o`02g`;o
00?O000030000ol0000:0009o`000?oOomoo00h000?o00002P001_l0003og`?o3P000ol0000;0006
o`000?oO0ol>0003o`0000@000060003o`0000/01Ol00`3o000=00;o3@000mooo`03o`030?l000h0
00?o00002`06o`;O00?o00002`000ol0000;00Go0ml00ooO000<0003o`0000/01_l00moog`0=0003
o`0000/01_l3g`d000?o00003006o`?O3@000ol0000400001P000ol0000@00;o3P02o``01Ml200;o
3`000ol0000@0003gooo00;O30000ol0000@00?o0ml<0003o`00010000?Oool00]l<0003o`000100
1?l00ml0000:0003o`00014000GOoooog`0<0003o`0000@000060003o`0002000_l;00GO50000ol0
000A00GO2`000ol0000B00GO2`000ol0000A00GO2`000ol0000A00GO2`000ol0000B00GO2`000ol0
000400001P000ol0000P00;o2P05gaD000?o00004P05g`X000?o00004`05g`X000?o00004P05g`X0
00?o00004P05g`X000?o00004`05g`X000?o0000100000H000?o00008002o`T01MlF0003o`0001<0
1Ml90003o`0001@01Ml90003o`0001<01Ml90003o`0001<01Ml90003o`0001@01Ml90003o`0000@0
00060003o`0002000_l800GO5`000ol0000D00GO20000ol0000E00GO20000ol0000D00GO20000ol0
000D00GO20000ol0000E00GO20000ol0000400001P000ol0000P00;o1`05gaP000?o00005@05g`L0
00?o00005P05g`L000?o00005@05g`L000?o00005@05g`L000?o00005P05g`L000?o0000100000H0
00?o00008002o`H01MlI0003o`0001H01Ml60003o`0001L01Ml60003o`0001H01Ml60003o`0001H0
1Ml60003o`0001L01Ml60003o`0000@000060003o`0002000_l500GO6P000ol0000G00GO1@000ol0
000H00GO1@000ol0000G00GO1@000ol0000G00GO1@000ol0000H00GO1@000ol0000400001P000ol0
000P00;o1005ga/000?o00006005g`@000?o00006@05g`@000?o00006005g`@000?o00006005g`@0
00?o00006@05g`@000?o0000100000H000?o00008002o`<01MlL0003o`0001T01Ml30003o`0001X0
1Ml30003o`0001T01Ml30003o`0001T01Ml30003o`0001X01Ml30003o`0000@000060003o`000200
0_l200GO7@000ol0000J00GO0P000ol0000K00GO0P000ol0000J00GO0P000ol0000J00GO0P000ol0
000K00GO0P000ol0000400001P000ol0000P00;o00<0gml00mlN0003o`0001/01Ml00`3o000M00GO
00<0o`007005g`030?l001`01Ml00`3o000M00GO00<0o`001@0000H000?o00008002o`GO7`000ol0
000L00GO00?o00007@05g`03o`0001`01Ml00ol0000L00GO00?o00007@05g`03o`0000@000060003
o`0002000_l4gb0000?o00007@04g`03o`0001h01=l00ol0000M00CO00?o00007@04g`03o`0001h0
1=l00ol0000400001P000ol0000P00;o0mlQ0003o`0001h00ml00ooO000O00?O00?og`007P03g`03
oml001h00ml00ooO000O00?O00?og`00100000D0ool2o`03g`0000<000050?oo0_l00ml000030000
1P000ol0000O00?o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H000?o00007P001?l0oolT0003o`00024000?o00008P000ol0000Q0003o`00024000?o0000
8P000ol0000400001P000ol0000M0003o`0000;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o000070001?l00002ob@000?o00008@000ol0000R0003
o`00024000?o00008@000ol0000R0003o`0000@000060003o`0001/000?o00000P02ob@000?o0000
8@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`0001X000?o0000
0`02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003
o`0001T000?o00001002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003
o`0000@000060003o`0001P000?o00001@02ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0000H00_l00`3oo`0<0003o`0000H00_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol000070003o`3o00`0
00?o00001`02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0000P000?o00002P000ol0000800;o90000ol0000Q0003o`00028000?o00008@000ol0
000Q0003o`00028000?o0000100000H000?o00001`000ol0o`0:0003o`0000T00_lT0003o`000240
00?o00008P000ol0000Q0003o`00024000?o00008P000ol0000400001P000ol0000600;o00<0ool0
20000ol0000:00;o3P03oa<000?o00002`03oa<000?o00002`03oa@000?o00002`03oa<000?o0000
2`03oa<000?o00003003oa<000?o0000100000H000?o00004P000ol0000;00;o4@000ol0000@0003
o`0000h000?o000040000ol0000>0003o`00014000?o00003P000ol0000@0003o`0000h000?o0000
40000ol0000?0003o`00010000?o0000100000H000?o00004@000ol0000<00;o3P04o`040?ooo`h0
00?o00002`04o`030?oo00;o3@000ol0000;00Co00@0oooo3`000ol0000;00Co0P03o`d000?o0000
2`04o`040?ooo`h000?o00003004o`800_l>0003o`0000@000060003o`00010000?o00003@02o`d0
00Go0000o`020003o`0000d000?o00002P001Ol0003o008000?o00003@000ol0000:0005o`000?l0
10000ol0000<0003o`0000X000Go0000o`030003o`0000`000?o00002P001Ol0003o00@000?o0000
2`000ol0000;0007o`000?l0o`020003o`0000/000?o0000100000H000?o00003`000ol0000>00;o
3@001Ol0003o008000?o00003@000ol0000:0005o`000?l00`000ol0000<0003o`0000X000Go0000
o`040003o`0000`000?o00002P001_l0003o00Co3@000ol0000:0005o`000?l010000ol0000;0003
o`0000/000Oo0000o`3o008000?o00002`000ol0000400001P000ol0000>0003o`0000l00_l=0005
o`000?l00P000ol0000=0003o`0000X000Go0000o`040003o`0000/000?o00002P001Ol0003o0080
0_l?0003o`0000X000Wo0000o`3o0?l03P000ol0000:0006o`000?l00ol>0003o`0000/000Ko0000
o`03o`h000?o0000100000H000?o00003@000ol0000@00;o3P05o`030?l000h000?o00002`06o`80
00?o00002`000ol0000;00Go0`000ol0000<0003o`0000/01_l00`3o000=0003o`0000/01_l@0003
o`0000`01_l@0003o`0000@000060003o`0000`000?o00001P03o`P00_lC00;o3`000ol0000A00;o
3P000ol0000@00?o3`000ol0000A00;o3P000ol0000@00Co3@000ol0000B00?o3@000ol000040000
1P000ol0000;0003o`0000P000?o00001`02ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0000X000?o00002P000ol0000600;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00002@000ol0000;0003
o`0000H00_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol000080003o`0000/000?o0?l01`02ob@000?o00008@000ol0000R0003o`00024000?o0000
8@000ol0000R0003o`0000@000060003o`0000L000?o000030000ol0o`0700;o90000ol0000Q0003
o`00028000?o00008@000ol0000Q0003o`00028000?o0000100000H000?o00001P000ol0000<00;o
00<0ool01P02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@0
00060003o`0000D000?o00006002ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0
000R0003o`0000@000060003o`0000@000?o00006@02ob@000?o00008@000ol0000R0003o`000240
00?o00008@000ol0000R0003o`0000@000060003o`0000<000?o00006P02ob@000?o00008@000ol0
000R0003o`00024000?o00008@000ol0000R0003o`0000@000060003o`00008000?o00006`02ob@0
00?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060005o`000?l0
7P02ob@000?o00008@000ol0000R0003o`00024000?o00008@000ol0000R0003o`0000@000060004
o`00oal00_lT0003o`00024000?o00008P000ol0000Q0003o`00024000?o00008P000ol000040000
1P000ol0o`0P00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H00_lQ00;o90000ol0000Q0003o`00028000?o00008@000ol0000Q0003o`00028000?o0000
100000H0ool1o`H0000Y00;oh@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@0000h00_l:00;oh@03o``0000>0003
o`0000X000?o0000h0000ol0000;00001`03o`@000?o00000P03o`D000?o0000a`02o`030?oo00T0
00?o0?l02@000ol0000:00001`001?l00?l30003o`0000D000?o00000P000ol000380003o`3o00/0
00?o000020000ol0000:00002@02o`<000?o00001@000ol000020003o`000<T000?o00002005o`L0
00?o0?l02`0000L00_l50003o`0000<00_l50003o`000<P000?o0?l02`000ol000070003o`3o00/0
00070004o`00o`<000?o00001@000ol000020003o`000<L00_l00`3oo`0C00;o00<0ool02P0000P0
0ol300;o0`03o`@00_o`0000o`0=0000o`0=0000o`0=0000\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"OtherProps"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell["These are the pairs that do not commute.", "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NonCommutingPairs[Symmetric[3]]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({{{1, 3, 2}, {2, 1, 3}}, {{1, 3, 2}, {2, 3, 1}}, {{1, 3, 2}, {3, 1, 
          2}}, {{1, 3, 2}, {3, 2, 1}}, {{2, 1, 3}, {2, 3, 1}}, {{2, 1, 3}, {
          3, 1, 2}}, {{2, 1, 3}, {3, 2, 1}}, {{2, 3, 1}, {3, 2, 1}}, {{3, 1, 
          2}, {3, 2, 1}}}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "This shows the three commutators for ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  " and how they arise from various pairs of elements."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Commutators[Dihedral[3], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \("KEY for D[3]: label used \[Rule] element: {g1 \[Rule] 1, g2 \[Rule] \
Rot, g3 \[Rule] Rot^2, g4 \[Rule] Ref, g5 \[Rule] Rot**Ref, g6 \[Rule] \
Rot^2**Ref}"\)], "Print",
  CellTags->"OtherProps"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.443878 0.136054 [
[ 0 0 0 0 ]
[ 1 1.5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.5 L
0 1.5 L
closepath
clip
newpath
1 0 0 r
.15986 1.12415 m
.15986 1.2602 L
.29592 1.2602 L
.29592 1.12415 L
F
.29592 1.12415 m
.29592 1.2602 L
.43197 1.2602 L
.43197 1.12415 L
F
.43197 1.12415 m
.43197 1.2602 L
.56803 1.2602 L
.56803 1.12415 L
F
.56803 1.12415 m
.56803 1.2602 L
.70408 1.2602 L
.70408 1.12415 L
F
.70408 1.12415 m
.70408 1.2602 L
.84014 1.2602 L
.84014 1.12415 L
F
.84014 1.12415 m
.84014 1.2602 L
.97619 1.2602 L
.97619 1.12415 L
F
.15986 .9881 m
.15986 1.12415 L
.29592 1.12415 L
.29592 .9881 L
F
.29592 .9881 m
.29592 1.12415 L
.43197 1.12415 L
.43197 .9881 L
F
.43197 .9881 m
.43197 1.12415 L
.56803 1.12415 L
.56803 .9881 L
F
0 0 1 r
.56803 .9881 m
.56803 1.12415 L
.70408 1.12415 L
.70408 .9881 L
F
.70408 .9881 m
.70408 1.12415 L
.84014 1.12415 L
.84014 .9881 L
F
.84014 .9881 m
.84014 1.12415 L
.97619 1.12415 L
.97619 .9881 L
F
1 0 0 r
.15986 .85204 m
.15986 .9881 L
.29592 .9881 L
.29592 .85204 L
F
.29592 .85204 m
.29592 .9881 L
.43197 .9881 L
.43197 .85204 L
F
.43197 .85204 m
.43197 .9881 L
.56803 .9881 L
.56803 .85204 L
F
0 1 0 r
.56803 .85204 m
.56803 .9881 L
.70408 .9881 L
.70408 .85204 L
F
.70408 .85204 m
.70408 .9881 L
.84014 .9881 L
.84014 .85204 L
F
.84014 .85204 m
.84014 .9881 L
.97619 .9881 L
.97619 .85204 L
F
1 0 0 r
.15986 .71599 m
.15986 .85204 L
.29592 .85204 L
.29592 .71599 L
F
0 1 0 r
.29592 .71599 m
.29592 .85204 L
.43197 .85204 L
.43197 .71599 L
F
0 0 1 r
.43197 .71599 m
.43197 .85204 L
.56803 .85204 L
.56803 .71599 L
F
1 0 0 r
.56803 .71599 m
.56803 .85204 L
.70408 .85204 L
.70408 .71599 L
F
0 1 0 r
.70408 .71599 m
.70408 .85204 L
.84014 .85204 L
.84014 .71599 L
F
0 0 1 r
.84014 .71599 m
.84014 .85204 L
.97619 .85204 L
.97619 .71599 L
F
1 0 0 r
.15986 .57993 m
.15986 .71599 L
.29592 .71599 L
.29592 .57993 L
F
0 1 0 r
.29592 .57993 m
.29592 .71599 L
.43197 .71599 L
.43197 .57993 L
F
0 0 1 r
.43197 .57993 m
.43197 .71599 L
.56803 .71599 L
.56803 .57993 L
F
.56803 .57993 m
.56803 .71599 L
.70408 .71599 L
.70408 .57993 L
F
1 0 0 r
.70408 .57993 m
.70408 .71599 L
.84014 .71599 L
.84014 .57993 L
F
0 1 0 r
.84014 .57993 m
.84014 .71599 L
.97619 .71599 L
.97619 .57993 L
F
1 0 0 r
.15986 .44388 m
.15986 .57993 L
.29592 .57993 L
.29592 .44388 L
F
0 1 0 r
.29592 .44388 m
.29592 .57993 L
.43197 .57993 L
.43197 .44388 L
F
0 0 1 r
.43197 .44388 m
.43197 .57993 L
.56803 .57993 L
.56803 .44388 L
F
0 1 0 r
.56803 .44388 m
.56803 .57993 L
.70408 .57993 L
.70408 .44388 L
F
0 0 1 r
.70408 .44388 m
.70408 .57993 L
.84014 .57993 L
.84014 .44388 L
F
1 0 0 r
.84014 .44388 m
.84014 .57993 L
.97619 .57993 L
.97619 .44388 L
F
.15986 .30782 m
.15986 .44388 L
.29592 .44388 L
.29592 .30782 L
F
0 1 0 r
.15986 .17177 m
.15986 .30782 L
.29592 .30782 L
.29592 .17177 L
F
0 0 1 r
.15986 .03571 m
.15986 .17177 L
.29592 .17177 L
.29592 .03571 L
F
1 0 0 r
.15986 1.2602 m
.15986 1.39626 L
.29592 1.39626 L
.29592 1.2602 L
F
0 1 0 r
.29592 1.2602 m
.29592 1.39626 L
.43197 1.39626 L
.43197 1.2602 L
F
0 0 1 r
.43197 1.2602 m
.43197 1.39626 L
.56803 1.39626 L
.56803 1.2602 L
F
0 g
[(1)] .36395 .37585 -1 0 Mshowa
[(Rot)] .36395 .2398 -1 0 Mshowa
[(Rot^2)] .36395 .10374 -1 0 Mshowa
[(g1)] .10544 .37585 0 0 Mshowa
[(g2)] .10544 .2398 0 0 Mshowa
[(g3)] .10544 .10374 0 0 Mshowa
1 Mabswid
[ ] 0 setdash
.02381 .44388 m
.02381 1.39626 L
s
.02381 .44388 m
.97619 .44388 L
s
.02381 .57993 m
.97619 .57993 L
s
.02381 .71599 m
.97619 .71599 L
s
.02381 .85204 m
.97619 .85204 L
s
.02381 .9881 m
.97619 .9881 L
s
.02381 1.12415 m
.97619 1.12415 L
s
.02381 1.2602 m
.97619 1.2602 L
s
.02381 1.39626 m
.97619 1.39626 L
s
.15986 .44388 m
.15986 1.39626 L
s
.29592 .44388 m
.29592 1.39626 L
s
.43197 .44388 m
.43197 1.39626 L
s
.56803 .44388 m
.56803 1.39626 L
s
.70408 .44388 m
.70408 1.39626 L
s
.84014 .44388 m
.84014 1.39626 L
s
.97619 .44388 m
.97619 1.39626 L
s
.02381 1.39626 m
.15986 1.2602 L
s
2.6 Mabswid
.15986 .44388 m
.15986 1.39626 L
s
.02381 1.2602 m
.97619 1.2602 L
s
[(g1)] .09184 1.19218 0 0 Mshowa
[(g2)] .09184 1.05612 0 0 Mshowa
[(g3)] .09184 .92007 0 0 Mshowa
[(g4)] .09184 .78401 0 0 Mshowa
[(g5)] .09184 .64796 0 0 Mshowa
[(g6)] .09184 .5119 0 0 Mshowa
[(g1)] .22789 1.32823 0 0 Mshowa
[(g2)] .36395 1.32823 0 0 Mshowa
[(g3)] .5 1.32823 0 0 Mshowa
[(g4)] .63605 1.32823 0 0 Mshowa
[(g5)] .77211 1.32823 0 0 Mshowa
[(g6)] .90816 1.32823 0 0 Mshowa
[(D[3])] .02381 1.46429 -1 0 Mshowa
gsave
.97619 1.46429 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 1.3051 0 0 Mshowa
[(y)] .12585 1.35544 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{192, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400030000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000<0000300000`0000<0000300000`0000<00
00300000`00001h06]:800007P0JdXP0000N01[BR00001h06]:800007P0JdXP0000N01[BR00001h0
6]:800007P0JdXP0000@00?o2`0JdXP0000C0003o`0000P06]:800004004o`040?ooo`H06]8=00;o
0P02o`800ol300?o2004oeh0000?0005o`000?l010000ol0000301[B3P001?l0ool20005o`000?l0
0P001?l00?l80003o`0005h0000?0005o`000?l010000ol0000301[B3P03o`<000Go0000o`020003
o`0000X000?o0000G@0000l000Go0000o`0200;o1P0JdPh000Co003o0P001Ol0003o008000?o0000
2`000ol0001L00004005o`<000?o00000`0JdPh000Co003o0`03o`801?l80004o`00oeh0000E00?o
1P0JdPd01?l:0003o`00008000?o0?l01002oel0000N01[B6`000ol000030003o`0006@0000N01[B
R00001h06]:800007P0JdXP0000N01[BR00001h06]:800007P0JdXP0000N01[BR00001h06]:80000
7P0JdXP0000N01[LR00001h06]b800007P0Jg8P0000N01[LR00001h06]b800007P0Jg8P0000N01[L
R00001h06]b800004003o`/06]b800004`000ol0000801[LR00001001?l00`3oo`02o`D06]`=00;o
0P02o`800ol300?oJP0000l000Go0000o`020003o`0000D06]`>0004o`3oo`8000Go0000o`020004
o`00ofT0000?0005o`000?l00`000ol0000401[L3P03o`<000Go0000o`020003o`0006X0000?0005
o`000?l010000ol0000301[L3P001?l00?l20005o`000?l00P000ol0001Z00004006o`8000?o0000
0`0Jg0h000Co003o0`03o`801?mZ00005P02o`H06]`=00Co2P000ol0001Z00007P0Jg1/000?o0000
JP0001h06]b800007P0Jg8P0000N01[LR00001h06]b800007P0Jg8P0000N01[LR00001h06]b80000
7P0Jg8P0000N01[LR00001h06R>800007P0J8hP0000N01XSR00001h06R>800007P0J8hP0000N01XS
R00001h06R>800007P0J8hP0000@00?o2`0J8hP0000C0003o`0000P06R>800004004o`040?ooo`H0
6R<>00?oM`0000l000Go0000o`020003o`0000D06R<?0003o`0007H0000?0005o`000?l00P000ol0
000501XS3`000ol0001f00003`001Ol0003o008000?o00001@0J8`l000?o0000MP0001001Ol00`3o
000601XS3`000ol0001f00005@02o`L06R<>00;oN00001h06R>800007P0J8hP0000N01XSR00001h0
6R>800007P0J8hP0000N01XSR00001h06R>800007P0J8hP0000N01XSR00000@0]ol5000010000ol0
000F00;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@0
00?o00005P02oaTS00?og=`05m`00ooBdP0GdP03omcL01OL00?od]805m800olS8`0G8`03o`0000<0
00040003o`0001H00_lI8`03omcL01OL00?od]805m800ooLg00Gg003om;B01OB00?o8b<05b<00ol0
0003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS
00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03omcL01OL00?od]805m800olS
8`0G8`03o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]805m800ooLg00Gg003om;B01OB
00?o8b<05b<00ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooB
dP0GdP03ob<S01LS00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03omcL01OL
00?od]805m800olS8`0G8`03o`0000<000040003o`0000H00ol=00;o6B<00ooLg00Gg003om;B01OB
00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@000?o00002@000ol0000:00;o6B<00ooL
g00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@000?o00001P04o`80
0_l800;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@0
00?o00001@001ol0003o0?l00P000ol0000500;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooB
dP0GdP03ob<S01LS00?o00000`0000@000?o00001@001ol0003o0?l00P000ol0000500;o6B<00ooL
g00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@000?o00001@001_l0
003o00?o2002oaTS00?og=`05m`00ooBdP0GdP03omcL01OL00?od]805m800olS8`0G8`03o`0000<0
00040003o`0000H01_l:00;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS
00?o00000`0000@000?o00003003o`L00_lI8`03omcL01OL00?od]805m800ooLg00Gg003om;B01OB
00?o8b<05b<00ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?og=`05m`00ooB
dP0GdP03ob<S01LS00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03omcL01OL
00?od]805m800olS8`0G8`03o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]805m800ooL
g00Gg003om;B01OB00?o8b<05b<00ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB
00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooB
dP0GdP03omcL01OL00?od]805m800olS8`0G8`03o`0000<000040003o`0001H00_lI8`03omcL01OL
00?od]805m800ooLg00Gg003om;B01OB00?o8b<05b<00ol00003000010000ol0000F00;o6B<00ooL
g00Gg003om;B01OB00?og=`05m`00ooBdP0GdP03ob<S01LS00?o00000`0000@000?o00005P02oaTS
00?og=`05m`00ooBdP0GdP03omcL01OL00?od]805m800olS8`0G8`03o`0000<000040003o`0001H0
0_lI8`03omcL01OL00?od]805m800ooLg00Gg003om;B01OB00?o8b<05b<00ol000030000102go`D0
00040003o`0001H00_lI8`03omcL01OL00?od]805m800ooBdP0GdP03ob<S01LS00?og=`05m`00ol0
0003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?od]805m800olS8`0G8`03omcL01OL
00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03om;B01OB00?o8b<05b<00ooL
g00Gg003o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]805m800ooBdP0GdP03ob<S01LS
00?og=`05m`00ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?od]805m800olS
8`0G8`03omcL01OL00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03om;B01OB
00?o8b<05b<00ooLg00Gg003o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]805m800ooB
dP0GdP03ob<S01LS00?og=`05m`00ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB
00?od]805m800olS8`0G8`03omcL01OL00?o00000`0000@000?o00001P03o`d00_lI8`03omcL01OL
00?od]805m800ooBdP0GdP03ob<S01LS00?og=`05m`00ol00003000010000ol000090003o`0000X0
0_lI8`03omcL01OL00?od]805m800ooBdP0GdP03ob<S01LS00?og=`05m`00ol00003000010000ol0
000600Co00@0oooo2002oaTS00?og=`05m`00ooBdP0GdP03om;B01OB00?o8b<05b<00ooLg00Gg003
o`0000<000040003o`0000D000Go0000o`040003o`0000D00_lI8`03omcL01OL00?od]805m800ooB
dP0GdP03ob<S01LS00?og=`05m`00ol00003000010000ol000050005o`000?l010000ol0000500;o
6B<00ooLg00Gg003om;B01OB00?od]805m800olS8`0G8`03omcL01OL00?o00000`0000@000?o0000
1@001_l0003o00?o2002oaTS00?og=`05m`00ooBdP0GdP03om;B01OB00?o8b<05b<00ooLg00Gg003
o`0000<000040003o`0000H01_l:00;o6B<00ooLg00Gg003om;B01OB00?od]805m800olS8`0G8`03
omcL01OL00?o00000`0000@000?o00002`04o`L00_lI8`03omcL01OL00?od]805m800ooBdP0GdP03
ob<S01LS00?og=`05m`00ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?od]80
5m800olS8`0G8`03omcL01OL00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03
om;B01OB00?o8b<05b<00ooLg00Gg003o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]80
5m800ooBdP0GdP03ob<S01LS00?og=`05m`00ol00003000010000ol0000F00;o6B<00ooLg00Gg003
om;B01OB00?od]805m800olS8`0G8`03omcL01OL00?o00000`0000@000?o00005P02oaTS00?og=`0
5m`00ooBdP0GdP03om;B01OB00?o8b<05b<00ooLg00Gg003o`0000<000040003o`0001H00_lI8`03
omcL01OL00?od]805m800ooBdP0GdP03ob<S01LS00?og=`05m`00ol00003000010000ol0000F00;o
6B<00ooLg00Gg003om;B01OB00?od]805m800olS8`0G8`03omcL01OL00?o00000`0000@000?o0000
5P02oaTS00?og=`05m`00ooBdP0GdP03om;B01OB00?o8b<05b<00ooLg00Gg003o`0000<000040003
o`0001H00_lI8`03omcL01OL00?od]805m800ooBdP0GdP03ob<S01LS00?og=`05m`00ol000030000
102go`D000040003o`0001H00_lI8`03omcL01OL00?od]805m800olS8`0G8`03omcL01OL00?od]80
5m800ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?o8b<05b<00ooLg00Gg003
om;B01OB00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03ob<S01LS00?og=`0
5m`00ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]805m800olS8`0G8`03
omcL01OL00?od]805m800ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB00?o8b<0
5b<00ooLg00Gg003om;B01OB00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooBdP0GdP03
ob<S01LS00?og=`05m`00ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]80
5m800olS8`0G8`03omcL01OL00?od]805m800ol00003000010000ol0000600?o3@02oaTS00?og=`0
5m`00ooBdP0GdP03ob<S01LS00?og=`05m`00ooBdP0GdP03o`0000<000040003o`0000T000?o0000
2P02oaTS00?og=`05m`00ooBdP0GdP03ob<S01LS00?og=`05m`00ooBdP0GdP03o`0000<000040003
o`0000H01?l200?o1`02oaTS00?og=`05m`00ooBdP0GdP03ob<S01LS00?og=`05m`00ooBdP0GdP03
o`0000<000040003o`0000D000Go0000o`030003o`0000H00_lI8`03omcL01OL00?od]805m800olS
8`0G8`03omcL01OL00?od]805m800ol00003000010000ol000050006o`000?l01?l700;o6B<00ooL
g00Gg003om;B01OB00?o8b<05b<00ooLg00Gg003om;B01OB00?o00000`0000@000?o00001@002Ol0
003o0?l0o`0800;o6B<00ooLg00Gg003om;B01OB00?o8b<05b<00ooLg00Gg003om;B01OB00?o0000
0`0000@000?o00001P06o`030?l000L00_lI8`03omcL01OL00?od]805m800olS8`0G8`03omcL01OL
00?od]805m800ol00003000010000ol0000<00;o2002oaTS00?og=`05m`00ooBdP0GdP03ob<S01LS
00?og=`05m`00ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03omcL01OL00?od]805m800olS
8`0G8`03omcL01OL00?od]805m800ol00003000010000ol0000F00;o6B<00ooLg00Gg003om;B01OB
00?o8b<05b<00ooLg00Gg003om;B01OB00?o00000`0000@000?o00005P02oaTS00?og=`05m`00ooB
dP0GdP03ob<S01LS00?og=`05m`00ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03omcL01OL
00?od]805m800olS8`0G8`03omcL01OL00?od]805m800ol00003000010000ol0000F00;o6B<00ooL
g00Gg003om;B01OB00?o8b<05b<00ooLg00Gg003om;B01OB00?o00000`0000@000?o00005P02oaTS
00?og=`05m`00ooBdP0GdP03ob<S01LS00?og=`05m`00ooBdP0GdP03o`0000<000040003o`0001H0
0_lI8`03omcL01OL00?od]805m800olS8`0G8`03omcL01OL00?od]805m800ol00003000010000ol0
000F00;o6B<00ooLg00Gg003om;B01OB00?o8b<05b<00ooLg00Gg003om;B01OB00?o00000`0000@0
00?o00005P02oaTS00?og=`05m`00ooBdP0GdP03ob<S01LS00?og=`05m`00ooBdP0GdP03o`0000<0
00040;Oo1@0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03omcL01OL00?og=`05m`00ooL
g00Gg003o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooLg00Gg003omcL01OL
00?og=`05m`00ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS00?og=`05m`00ooL
g00Gg003omcL01OL00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03omcL01OL
00?og=`05m`00ooLg00Gg003o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooL
g00Gg003omcL01OL00?og=`05m`00ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS
00?og=`05m`00ooLg00Gg003omcL01OL00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS
8`0G8`03omcL01OL00?og=`05m`00ooLg00Gg003o`0000<000040003o`0001H00_lI8`03ob<S01LS
00?o8b<05b<00ooLg00Gg003omcL01OL00?og=`05m`00ol00003000010000ol0000600?o3@02oaTS
00?o8b<05b<00olS8`0G8`03omcL01OL00?og=`05m`00ooLg00Gg003o`0000<000040003o`0000T0
00?o00002P02oaTS00?o8b<05b<00olS8`0G8`03omcL01OL00?og=`05m`00ooLg00Gg003o`0000<0
00040003o`0000H01?l0103oool800;o6B<00olS8`0G8`03ob<S01LS00?og=`05m`00ooLg00Gg003
omcL01OL00?o00000`0000@000?o00001@001Ol0003o00@000?o00001@02oaTS00?o8b<05b<00olS
8`0G8`03omcL01OL00?og=`05m`00ooLg00Gg003o`0000<000040003o`0000D000Go0000o`040003
o`0000D00_lI8`03ob<S01LS00?o8b<05b<00ooLg00Gg003omcL01OL00?og=`05m`00ol000030000
10000ol000050005o`000?l00P02o`P00_lI8`03ob<S01LS00?o8b<05b<00ooLg00Gg003omcL01OL
00?og=`05m`00ol00003000010000ol0000600Go0`000ol0000500;o6B<00olS8`0G8`03ob<S01LS
00?og=`05m`00ooLg00Gg003omcL01OL00?o00000`0000@000?o00002`03o`P00_lI8`03ob<S01LS
00?o8b<05b<00ooLg00Gg003omcL01OL00?og=`05m`00ol00003000010000ol0000F00;o6B<00olS
8`0G8`03ob<S01LS00?og=`05m`00ooLg00Gg003omcL01OL00?o00000`0000@000?o00005P02oaTS
00?o8b<05b<00olS8`0G8`03omcL01OL00?og=`05m`00ooLg00Gg003o`0000<000040003o`0001H0
0_lI8`03ob<S01LS00?o8b<05b<00ooLg00Gg003omcL01OL00?og=`05m`00ol00003000010000ol0
000F00;o6B<00olS8`0G8`03ob<S01LS00?og=`05m`00ooLg00Gg003omcL01OL00?o00000`0000@0
00?o00005P02oaTS00?o8b<05b<00olS8`0G8`03omcL01OL00?og=`05m`00ooLg00Gg003o`0000<0
00040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooLg00Gg003omcL01OL00?og=`05m`00ol0
0003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS00?og=`05m`00ooLg00Gg003omcL01OL
00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03omcL01OL00?og=`05m`00ooL
g00Gg003o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooLg00Gg003omcL01OL
00?og=`05m`00ol000030000102go`D000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooB
dP0GdP03om;B01OB00?od]805m800ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS
00?od]805m800ooBdP0GdP03om;B01OB00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS
8`0G8`03om;B01OB00?od]805m800ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03ob<S01LS
00?o8b<05b<00ooBdP0GdP03om;B01OB00?od]805m800ol00003000010000ol0000F00;o6B<00olS
8`0G8`03ob<S01LS00?od]805m800ooBdP0GdP03om;B01OB00?o00000`0000@000?o00005P02oaTS
00?o8b<05b<00olS8`0G8`03om;B01OB00?od]805m800ooBdP0GdP03o`0000<000040003o`0001H0
0_lI8`03ob<S01LS00?o8b<05b<00ooBdP0GdP03om;B01OB00?od]805m800ol00003000010000ol0
000F00;o6B<00olS8`0G8`03ob<S01LS00?od]805m800ooBdP0GdP03om;B01OB00?o00000`0000@0
00?o00001P03o`d00_lI8`03ob<S01LS00?o8b<05b<00ooBdP0GdP03om;B01OB00?od]805m800ol0
0003000010000ol000090003o`0000X00_lI8`03ob<S01LS00?o8b<05b<00ooBdP0GdP03om;B01OB
00?od]805m800ol00003000010000ol0000600Co00<0ool00_l700;o6B<00olS8`0G8`03ob<S01LS
00?od]805m800ooBdP0GdP03om;B01OB00?o00000`0000@000?o00001@001Ol0003o008000?o0000
1`02oaTS00?o8b<05b<00olS8`0G8`03om;B01OB00?od]805m800ooBdP0GdP03o`0000<000040003
o`0000D000Go0000o`030003o`0000H00_lI8`03ob<S01LS00?o8b<05b<00ooBdP0GdP03om;B01OB
00?od]805m800ol00003000010000ol000050005o`000?l010000ol0000500;o6B<00olS8`0G8`03
ob<S01LS00?od]805m800ooBdP0GdP03om;B01OB00?o00000`0000@000?o00001P06o`8000?o0000
1@02oaTS00?o8b<05b<00olS8`0G8`03om;B01OB00?od]805m800ooBdP0GdP03o`0000<000040003
o`0000`00_l800;o6B<00olS8`0G8`03ob<S01LS00?od]805m800ooBdP0GdP03om;B01OB00?o0000
0`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03om;B01OB00?od]805m800ooBdP0GdP03
o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooBdP0GdP03om;B01OB00?od]80
5m800ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS00?od]805m800ooBdP0GdP03
om;B01OB00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03om;B01OB00?od]80
5m800ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00ooBdP0GdP03
om;B01OB00?od]805m800ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS00?od]80
5m800ooBdP0GdP03om;B01OB00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03
om;B01OB00?od]805m800ooBdP0GdP03o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<0
5b<00ooBdP0GdP03om;B01OB00?od]805m800ol00003000010000ol0000F00;o6B<00olS8`0G8`03
ob<S01LS00?od]805m800ooBdP0GdP03om;B01OB00?o00000`0000@0]ol5000010000ol0000F00;o
6B<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o00000`0000@000?o0000
5P02oaTS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03o`0000<000040003
o`0001H00_lI8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00ol000030000
10000ol0000F00;o6B<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o0000
0`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03
o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<0
5b<00ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03
ob<S01LS00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<0
5b<00olS8`0G8`03o`0000<000040003o`0000H00ol=00;o6B<00olS8`0G8`03ob<S01LS00?o8b<0
5b<00olS8`0G8`03ob<S01LS00?o00000`0000@000?o00002@000ol0000:00;o6B<00olS8`0G8`03
ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o00000`0000@000?o00001P04o`040?ooo`P0
0_lI8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00ol00003000010000ol0
00050005o`000?l00P000ol0000700;o6B<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03
ob<S01LS00?o00000`0000@000?o00001@001Ol0003o008000?o00001`02oaTS00?o8b<05b<00olS
8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03o`0000<000040003o`0000D000Go0000o`020003
o`0000L00_lI8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00ol000030000
10000ol0000600Go00<0o`002002oaTS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS
8`0G8`03o`0000<000040003o`0000/00_l900;o6B<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS
8`0G8`03ob<S01LS00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS8`0G8`03ob<S01LS
00?o8b<05b<00olS8`0G8`03o`0000<000040003o`0001H00_lI8`03ob<S01LS00?o8b<05b<00olS
8`0G8`03ob<S01LS00?o8b<05b<00ol00003000010000ol0000F00;o6B<00olS8`0G8`03ob<S01LS
00?o8b<05b<00olS8`0G8`03ob<S01LS00?o00000`0000@000?o00005P02oaTS00?o8b<05b<00olS
8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03o`0000<000040003o`0001H00_lI8`03ob<S01LS
00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00ol00003000010000ol0000F00;o6B<00olS
8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o00000`0000@000?o00005P02oaTS
00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03o`0000<000040003o`0001H0
0_lI8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o8b<05b<00ol00003000010000ol0
000F00;o6B<00olS8`0G8`03ob<S01LS00?o8b<05b<00olS8`0G8`03ob<S01LS00?o00000`0000<0
^?l500000`2ho`D000040003o`0001D00olI8`03omcL01OL00?od]805m800ol0000G0003o`0001L0
00?o00005`000ol00003000010000ol0000D0004o`3ooaTS00?og=`05m`00ooBdP0GdP03o`0001L0
00?o00005`000ol0000G0003o`0000<000040003o`0001<000?o00000_lI8`03omcL01OL00?od]80
5m800ol0000G0003o`0001L000?o00005`000ol00003000010000ol0000B0004o`0000;o6B<00ooL
g00Gg003om;B01OB00?o00005`000ol0000G0003o`0001L000?o00000`0000@000?o00004@000ol0
000200;o6B<00ooLg00Gg003om;B01OB00?o00005`000ol0000G0003o`0001L000?o00000`0000@0
00?o00000`02o`030?oo00P000?o00000`02oaTS00?og=`05m`00ooBdP0GdP03o`0001L000?o0000
5`000ol0000G0003o`0000<000040003o`0000@000?o0?l020000ol0000400;o6B<00ooLg00Gg003
om;B01OB00?o00005`000ol0000G0003o`0001L000?o00000`0000@000?o00001@000ol000060003
o`0000D00_l88`?o3R<00ooLg006g0?o3]`00ooBdP06dP?o3]800ol0000600?o3P000ol0000600?o
3P000ol0000600?o3P000ol00003000010000ol000040003o`3o00H000?o00001P02o`/S00?o8b<0
2b<00ooLg009g003omcL00_L00?od]802M800ooBdP0;dP03o`0000T000?o00002`000ol000090003
o`0000/000?o00002@000ol0000;0003o`0000<000040003o`0000<00_l00`3oo`040003o`0000L0
0_l88`Co00@Soooo2B<00ooLg006g0Co00?Lool00_l8g003om;B00KB1?l01=;oool9dP03o`0000H0
1?l200?o20000ol0000600Co00@0oooo2@000ol0000600Co0P02o`T000?o00000`0000@000?o0000
2`000ol0000800;o1b<01OlS8b?o008S00?o8b<022<00ooLg005g005omcLg?l00]`00ooLg008g003
om;B00GB00God];Bo`04dP03om;B00KB00?o00001@001Ol0003o00<000?o00001`000ol000050005
o`000?l010000ol000060003o`0000D000Oo0000o`3o008000?o00001P000ol00003000010000ol0
000:0003o`0000T00_l78`05ob<S8ol00R<00olS8`088`03omcL00GL00Gog=cLo`03g003omcL00OL
00?od]801M801OoBd];o00CB00?od]801]800ol000050006o`000?l01?l80003o`0000D000Go0000
o`040003o`0000H000?o00001@001ol0003o0?l00P000ol000060003o`0000<000040003o`0000T0
00?o00002P02o`LS00Go8b<So`028`03ob<S00PS00?og=`01M`01OoLg=co00CL00?og=`01]`00ooB
dP05dP05om;Bd_l00]82o`WB00?o00001@002Ol0003o0?l0o`090003o`0000D000Ko0000o`03o`T0
00?o00001@001_l0003o00?o2@000ol00003000010000ol000080003o`0000<00ol500;o22<5o`03
8olS00TS00?og=`01]`6o`;L00?og=`01]`00ooBdP06dPGo0m800ooBdP06dP03o`0000H01_l00`3o
00080003o`0000H01_l;0003o`0000H01_l;0003o`0000<000040003o`0000L000?o00001@000ol0
000400;o3B<2o`XS00?og=`03=`2o`WL00?od]802m83o`WB00?o00003002o`T000?o00002`04o`P0
00?o00003003o`P000?o00000`0000@000?o00001P000ol000070003o`0000<00_lI8`03omcL01OL
00?od]805m800ol0000G0003o`0001L000?o00005`000ol00003000010000ol000050003o`0000P0
00?o00000`02oaTS00?og=`05m`00ooBdP0GdP03o`0001L000?o00005`000ol0000G0003o`0000<0
00040003o`0000@000?o000020000ol0o`0400;o6B<00ooLg00Gg003om;B01OB00?o00005`000ol0
000G0003o`0001L000?o00000`0000@000?o00000`000ol000090003o`3o00@00_lI8`03omcL01OL
00?od]805m800ol0000G0003o`0001L000?o00005`000ol00003000010000ol000020003o`0000T0
0_l00`3oo`0300;o6B<00ooLg00Gg003om;B01OB00?o00005`000ol0000G0003o`0001L000?o0000
0`0000@000Go0000o`0D00;o6B<00ooLg00Gg003om;B01OB00?o00005`000ol0000G0003o`0001L0
00?o00000`0000@000Co003o5@02oaTS00?og=`05m`00ooBdP0GdP03o`0001L000?o00005`000ol0
000G0003o`0000<000040003o`3o01H00_lI8`03omcL01OL00?od]805m800ol0000G0003o`0001L0
00?o00005`000ol0000300001002oaL00_lI8`03omcL01OL00?od]805m800ol0000G0003o`0001L0
00?o00005`000ol000030000102go`D0000M00;oX@000<0000300000`0000<0000300000`0000<00
000<00;o2P02oiP00ol;000030000ol0000:0003o`0009L000?o00002P0000@01Ol30003o`000080
0ol50003o`0007h00_l00`3oo`090003o`3o00T000?o00002@0000D000Go0000o`020003o`0000D0
00?o00000P000ol0001o0003o`3o00/000?o000020000ol0000900001@001Ol0003o008000?o0000
1@000ol000020003o`00080000?o00002005o`L000?o0?l02P0000D000Go0000o`020003o`0000<0
0_l50003o`0007l000?o0?l02`000ol000070003o`3o00X000050005o`000?l00P000ol000050003
o`00008000?o0000OP02o`030?oo01<00_l00`3oo`0900001005o`<00_l300?o1002ojH000300000
`0000<0000300000\
\>"],
  ImageRangeCache->{{{0, 191}, {287, 0}} -> {-1.17504, -3.27219, 0.0384822, 
  0.0384822}},
  CellTags->"OtherProps"],

Cell[BoxData[
    \({1, Rot, Rot\^2}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "From the foregoing table, we see that the commutator ",
  Cell[BoxData[
      \(TraditionalForm\`x\ y\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(x\^\(-1\)\) y\^\(-1\)\)]],
  " for ",
  Cell[BoxData[
      \(TraditionalForm\`x\  = Rot\^2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`y\  = Ref\)]],
  " is Rot, confirmed as follows."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Commutator[Dihedral[3], \ Rot\^2, \ Ref]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(Rot\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "The notion of the ",
  StyleBox["center",
    FontSlant->"Italic"],
  " of a group is related to commutativity. By definition, the center of a \
group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm
      \`{x \[Element] G | g\ x = x\ g\ \ \(\[ForAll] g\  \[Element] G\)}\)]],
  ". Given an element ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", the ",
  StyleBox["centralizer",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`{x \[Element] G | g\ x = x\ g}\)]],
  ". Related to this is the centralizer of a subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ": ",
  Cell[BoxData[
      \(TraditionalForm
      \`{x \[Element] G | g\ x = 
          x\ g\ \[ThinSpace]\[ThinSpace]\(\[ForAll] 
              \[NegativeThinSpace]g\  \[Element] H\)}\)]],
  "."
}], "Text",
  CellTags->{"OtherProps", "i:6"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GroupCenter",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["center",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Center",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["GroupCenter",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["G",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Centralizer",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["centralizer",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Centralizer",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["centralizer",
                SingleLetterItalics->False], 
              StyleBox["  ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subgroup",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["H",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "groupoid", 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherProps", "i:7"}],

Cell["Functions related to the group center.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "The center of the group ",
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  " consists of two elements."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupCenter[DihedralGroup[4]]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({1, Rot\^2}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "There are four elements in ",
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  " that commute with the element ",
  StyleBox["Ref", "MR"],
  "."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Centralizer[DihedralGroup[4], \ Ref]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(Groupoid[{1, Rot\^2, Ref, Rot\^2**Ref}, "-Operation-"]\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "The only element in ",
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  " that commutes with all the elements in the subgroup ",
  StyleBox["{1, Ref}", "MR"],
  " is the identity element, 1."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Centralizer[DihedralGroup[4], \ {1, Ref}]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(Groupoid[{1}, "-Operation-"]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "Given a group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and elements ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ", we say ",
  Cell[BoxData[
      \(TraditionalForm\`x\ h\ x\^\(-1\)\)]],
  " is the ",
  StyleBox["conjugate",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  ". The ",
  StyleBox["conjugacy class",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is defined to be ",
  Cell[BoxData[
      \(TraditionalForm\`{x\ h\ x\^\(-1\) | x \[Element] G}\)]],
  ". Given a subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", the conjugate of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " by ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`{x\ h\ x\^\(-1\) | h \[Element] H}\)]],
  " and is also a subgroup. Related to this is the ",
  StyleBox["normalizer",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ": ",
  Cell[BoxData[
      \(TraditionalForm\`{x \[Element] G | x\ H\ x\^\(-1\) = H}\)]],
  "; this too is a subgroup."
}], "Text",
  CellTags->{"OtherProps", "i:8"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ElementConjugate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["h",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ element\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["x",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    StyleBox["h",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], " ", 
                    SuperscriptBox["x", 
                      StyleBox[\(-1\),
                        SingleLetterItalics->False]]}],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Conjugate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["h",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["ElementConjugate",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["G",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["h",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["x",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["SubgroupConjugate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "groupoid", " ", "that", " ", 
              "is", " ", "the", " ", "conjugate", " ", "of", " ", "the", " ", 
              "subgroup", " ", 
              StyleBox["H",
                FontSlant->"Italic"], " ", "by", " ", 
              StyleBox["x",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["Conjugate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["SubgroupConjugate",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["G",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["H",
                        "TI"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["x",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ConjugacyClass",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["h",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["conjugacy",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["class",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["h",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ in\ the\ group\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Normalizer",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["H",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ normalizer\ of\ the\ subgroup\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["H",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"OtherProps", "i:9"}],

Cell["Functions related to conjugation.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "Since ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " is Abelian, conjugating 2 by 4 simply returns 2."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ElementConjugate[Z[5], \ 2, \ 4]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "Conjugating the subgroup ",
  StyleBox["{1, Ref}", "MR"],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  " by ",
  StyleBox["Rot", "MR"],
  " returns the subgroup ",
  StyleBox["{1, ", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\(Rot\^2**\ Ref}\)\)], "MR"],
  "."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupConjugate[Dihedral[3], {1, \ Ref}, \ Rot]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(Groupoid[{1, Rot\^2**Ref}, "-Operation-"]\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "Here we find the conjugacy class of the element ",
  StyleBox["Ref", "MR"],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`D\_3\)]],
  "."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CR\  = \ ConjugacyClass[Dihedral[3], \ Ref]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({Ref, Rot**Ref, Rot\^2**Ref}\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell["We see that this conjugacy class is not a subgroup.", "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SubgroupQ[CR, Dihedral[3]]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["CyclicQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  RowBox[{
                    StyleBox["th",
                      SingleLetterItalics->False], "e"}]], " ", "groupoid", 
                " ", 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cyclic",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["CyclicGenerators",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["cyclic",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["generators",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.36, 0.64}},
  CellTags->{"OtherProps", "i:10"}],

Cell["Functions related to cyclicity.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "Since there is no element of order 8, the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_15\)]],
  " is not cyclic."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CyclicQ[U[15], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"OtherProps"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.27778 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.242063 0.10582 [
[ 0 0 0 0 ]
[ 1 1.27778 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.27778 L
0 1.27778 L
closepath
clip
newpath
1 0 0 r
.12963 .9828 m
.12963 1.08862 L
.23545 1.08862 L
.23545 .9828 L
F
.12963 .87698 m
.12963 .9828 L
.23545 .9828 L
.23545 .87698 L
F
1 .75 0 r
.23545 .87698 m
.23545 .9828 L
.34127 .9828 L
.34127 .87698 L
F
.5 1 0 r
.34127 .87698 m
.34127 .9828 L
.44709 .9828 L
.44709 .87698 L
F
0 1 .25 r
.55291 .87698 m
.55291 .9828 L
.65873 .9828 L
.65873 .87698 L
F
1 0 0 r
.12963 .77116 m
.12963 .87698 L
.23545 .87698 L
.23545 .77116 L
F
1 .75 0 r
.34127 .77116 m
.34127 .87698 L
.44709 .87698 L
.44709 .77116 L
F
1 0 0 r
.12963 .66534 m
.12963 .77116 L
.23545 .77116 L
.23545 .66534 L
F
1 .75 0 r
.44709 .66534 m
.44709 .77116 L
.55291 .77116 L
.55291 .66534 L
F
.5 1 0 r
.34127 .66534 m
.34127 .77116 L
.44709 .77116 L
.44709 .66534 L
F
0 1 .25 r
.76455 .66534 m
.76455 .77116 L
.87037 .77116 L
.87037 .66534 L
F
1 0 0 r
.12963 .55952 m
.12963 .66534 L
.23545 .66534 L
.23545 .55952 L
F
1 .75 0 r
.55291 .55952 m
.55291 .66534 L
.65873 .66534 L
.65873 .55952 L
F
.5 1 0 r
.34127 .55952 m
.34127 .66534 L
.44709 .66534 L
.44709 .55952 L
F
0 1 .25 r
.23545 .55952 m
.23545 .66534 L
.34127 .66534 L
.34127 .55952 L
F
1 0 0 r
.12963 .4537 m
.12963 .55952 L
.23545 .55952 L
.23545 .4537 L
F
1 .75 0 r
.65873 .4537 m
.65873 .55952 L
.76455 .55952 L
.76455 .4537 L
F
1 0 0 r
.12963 .34788 m
.12963 .4537 L
.23545 .4537 L
.23545 .34788 L
F
1 .75 0 r
.76455 .34788 m
.76455 .4537 L
.87037 .4537 L
.87037 .34788 L
F
.5 1 0 r
.34127 .34788 m
.34127 .4537 L
.44709 .4537 L
.44709 .34788 L
F
0 1 .25 r
.44709 .34788 m
.44709 .4537 L
.55291 .4537 L
.55291 .34788 L
F
1 0 0 r
.12963 .24206 m
.12963 .34788 L
.23545 .34788 L
.23545 .24206 L
F
1 .75 0 r
.87037 .24206 m
.87037 .34788 L
.97619 .34788 L
.97619 .24206 L
F
1 0 0 r
.12963 .03042 m
.12963 .13624 L
.23545 .13624 L
.23545 .03042 L
F
1 .75 0 r
.23545 .03042 m
.23545 .13624 L
.34127 .13624 L
.34127 .03042 L
F
.5 1 0 r
.34127 .03042 m
.34127 .13624 L
.44709 .13624 L
.44709 .03042 L
F
0 1 .25 r
.44709 .03042 m
.44709 .13624 L
.55291 .13624 L
.55291 .03042 L
F
0 1 1 r
.55291 .03042 m
.55291 .13624 L
.65873 .13624 L
.65873 .03042 L
F
0 .25 1 r
.65873 .03042 m
.65873 .13624 L
.76455 .13624 L
.76455 .03042 L
F
.5 0 1 r
.76455 .03042 m
.76455 .13624 L
.87037 .13624 L
.87037 .03042 L
F
1 0 .75 r
.87037 .03042 m
.87037 .13624 L
.97619 .13624 L
.97619 .03042 L
F
0 g
[(1)] .18254 .17857 0 0 Mshowa
[(2)] .28836 .17857 0 0 Mshowa
[(3)] .39418 .17857 0 0 Mshowa
[(4)] .5 .17857 0 0 Mshowa
[(5)] .60582 .17857 0 0 Mshowa
[(6)] .71164 .17857 0 0 Mshowa
[(7)] .81746 .17857 0 0 Mshowa
[(8)] .92328 .17857 0 0 Mshowa
[(n)] .07672 .17857 0 0 Mshowa
[(g^n)] .07672 .08333 0 0 Mshowa
1 Mabswid
[ ] 0 setdash
.02381 .24206 m
.02381 1.19444 L
s
.02381 .24206 m
.97619 .24206 L
s
.02381 .34788 m
.97619 .34788 L
s
.02381 .4537 m
.97619 .4537 L
s
.02381 .55952 m
.97619 .55952 L
s
.02381 .66534 m
.97619 .66534 L
s
.02381 .77116 m
.97619 .77116 L
s
.02381 .87698 m
.97619 .87698 L
s
.02381 .9828 m
.97619 .9828 L
s
.02381 1.08862 m
.97619 1.08862 L
s
.02381 1.19444 m
.97619 1.19444 L
s
.12963 .24206 m
.12963 1.19444 L
s
.23545 .24206 m
.23545 1.19444 L
s
.34127 .24206 m
.34127 1.19444 L
s
.44709 .24206 m
.44709 1.19444 L
s
.55291 .24206 m
.55291 1.19444 L
s
.65873 .24206 m
.65873 1.19444 L
s
.76455 .24206 m
.76455 1.19444 L
s
.87037 .24206 m
.87037 1.19444 L
s
.97619 .24206 m
.97619 1.19444 L
s
.02381 1.19444 m
.12963 1.08862 L
s
2.6 Mabswid
.12963 .24206 m
.12963 1.19444 L
s
.02381 1.08862 m
.97619 1.08862 L
s
[(1)] .18254 1.03571 0 0 Mshowa
[(2)] .28836 1.03571 0 0 Mshowa
[(4)] .39418 1.03571 0 0 Mshowa
[(7)] .5 1.03571 0 0 Mshowa
[(8)] .60582 1.03571 0 0 Mshowa
[(11)] .71164 1.03571 0 0 Mshowa
[(13)] .81746 1.03571 0 0 Mshowa
[(14)] .92328 1.03571 0 0 Mshowa
[(2)] .18254 .92989 0 0 Mshowa
[(4)] .28836 .92989 0 0 Mshowa
[(8)] .39418 .92989 0 0 Mshowa
[(14)] .5 .92989 0 0 Mshowa
[(1)] .60582 .92989 0 0 Mshowa
[(7)] .71164 .92989 0 0 Mshowa
[(11)] .81746 .92989 0 0 Mshowa
[(13)] .92328 .92989 0 0 Mshowa
[(4)] .18254 .82407 0 0 Mshowa
[(8)] .28836 .82407 0 0 Mshowa
[(1)] .39418 .82407 0 0 Mshowa
[(13)] .5 .82407 0 0 Mshowa
[(2)] .60582 .82407 0 0 Mshowa
[(14)] .71164 .82407 0 0 Mshowa
[(7)] .81746 .82407 0 0 Mshowa
[(11)] .92328 .82407 0 0 Mshowa
[(7)] .18254 .71825 0 0 Mshowa
[(14)] .28836 .71825 0 0 Mshowa
[(13)] .39418 .71825 0 0 Mshowa
[(4)] .5 .71825 0 0 Mshowa
[(11)] .60582 .71825 0 0 Mshowa
[(2)] .71164 .71825 0 0 Mshowa
[(1)] .81746 .71825 0 0 Mshowa
[(8)] .92328 .71825 0 0 Mshowa
[(8)] .18254 .61243 0 0 Mshowa
[(1)] .28836 .61243 0 0 Mshowa
[(2)] .39418 .61243 0 0 Mshowa
[(11)] .5 .61243 0 0 Mshowa
[(4)] .60582 .61243 0 0 Mshowa
[(13)] .71164 .61243 0 0 Mshowa
[(14)] .81746 .61243 0 0 Mshowa
[(7)] .92328 .61243 0 0 Mshowa
[(11)] .18254 .50661 0 0 Mshowa
[(7)] .28836 .50661 0 0 Mshowa
[(14)] .39418 .50661 0 0 Mshowa
[(2)] .5 .50661 0 0 Mshowa
[(13)] .60582 .50661 0 0 Mshowa
[(1)] .71164 .50661 0 0 Mshowa
[(8)] .81746 .50661 0 0 Mshowa
[(4)] .92328 .50661 0 0 Mshowa
[(13)] .18254 .40079 0 0 Mshowa
[(11)] .28836 .40079 0 0 Mshowa
[(7)] .39418 .40079 0 0 Mshowa
[(1)] .5 .40079 0 0 Mshowa
[(14)] .60582 .40079 0 0 Mshowa
[(8)] .71164 .40079 0 0 Mshowa
[(4)] .81746 .40079 0 0 Mshowa
[(2)] .92328 .40079 0 0 Mshowa
[(14)] .18254 .29497 0 0 Mshowa
[(13)] .28836 .29497 0 0 Mshowa
[(11)] .39418 .29497 0 0 Mshowa
[(8)] .5 .29497 0 0 Mshowa
[(7)] .60582 .29497 0 0 Mshowa
[(4)] .71164 .29497 0 0 Mshowa
[(2)] .81746 .29497 0 0 Mshowa
[(1)] .92328 .29497 0 0 Mshowa
[(1)] .07672 1.03571 0 0 Mshowa
[(2)] .07672 .92989 0 0 Mshowa
[(4)] .07672 .82407 0 0 Mshowa
[(7)] .07672 .71825 0 0 Mshowa
[(8)] .07672 .61243 0 0 Mshowa
[(11)] .07672 .50661 0 0 Mshowa
[(13)] .07672 .40079 0 0 Mshowa
[(14)] .07672 .29497 0 0 Mshowa
[(1)] .18254 1.14153 0 0 Mshowa
[(2)] .28836 1.14153 0 0 Mshowa
[(4)] .39418 1.14153 0 0 Mshowa
[(7)] .5 1.14153 0 0 Mshowa
[(8)] .60582 1.14153 0 0 Mshowa
[(11)] .71164 1.14153 0 0 Mshowa
[(13)] .81746 1.14153 0 0 Mshowa
[(14)] .92328 1.14153 0 0 Mshowa
[(U[15])] .02381 1.24735 -1 0 Mshowa
gsave
.97619 1.24735 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 1.12354 0 0 Mshowa
[(y)] .10317 1.1627 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  ImageSize->{225.375, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003Q000180P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000>40003Q0000h@000>40003Q0000h@000>40
003Q00007@0G8`0HWa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlA674Hk1L=68`0<4i=CTe>CDi=CTe>CDi=
CTe>CDi=CTe>CB0o83lP?b0o83lP?b0o83lP?b0o83lP?`H0000M01LS04ROgioOWmnOgioOWmnOgioO
WmnOgioOWmmagW7NLMiagW7NLMiagW7NLMiagW7NLMk/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=`G3@18
dXcBS=:<dXcBS=:<dXcBS=:<dXcBS=:<CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=Ccm??dloCcm??dlo
Ccm??dloCcm??dlo1P0001d05b<069lAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4AQa6>`G3AR<031>CDi=
CTe>CDi=CTe>CDi=CTe>CDi=CTdP?b0o83lP?b0o83lP?b0o83lP?b0o83l600007@0G8`18WmnOgioO
WmnOgioOWmnOgioOWmnOgioOLMiagW7NLMiagW7NLMiagW7NLMiagW7Nk=c/g>cLk=c/g>cLk=c/g>cL
k=c/g>cL5`d0B=:<dXcBS=:<dXcBS=:<dXcBS=:<dXcBS4i=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDlo
Ccm??dloCcm??dloCcm??dloCcm??`H0000M01LS01RO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa4HLAS/
5`dHS00`CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=83lP?b0o83lP?b0o83lP?b0o83lP?b0o1P0001d0
5b<0B9oOWmnOgioOWmnOgioOWmnOgioOWmnOgg7NLMiagW7NLMiagW7NLMiagW7NLMiag^cLk=c/g>cL
k=c/g>cLk=c/g>cLk=c/g1L=04SBS=:<dXcBS=:<dXcBS=:<dXcBS=:<dXa>CDi=CTe>CDi=CTe>CDi=
CTe>CDi=CTe??dloCcm??dloCcm??dloCcm??dloCcl600007@0G8`0HWa6O4IlAWa6O4IlAWa6O4IlA
Wa6O4IlA674Hk1L=68`0<4i=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CB0o83lP?b0o83lP?b0o83lP?b0o
83lP?`H0000:00?o400G8`18WmnOgioOWmnOgioOWmnOgioOWmnOgioOLMiagW7NLMiagW7NLMiagW7N
LMiagW7Nk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cL5`d0B=:<dXcBS=:<dXcBS=:<dXcBS=:<dXcBS4i=
CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDloCcm??dloCcm??dloCcm??dloCcm??`H0000=0003o`0000d0
5b<069lAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4AQa6>`G3AR<031>CDi=CTe>CDi=CTe>CDi=CTe>CDi=
CTdP?b0o83lP?b0o83lP?b0o83lP?b0o83l600002P04o`L00_l00`3oo`0301LS04ROgioOWmnOgioO
WmnOgioOWmnOgioOWmmagW7NLMiagW7NLMiagW7NLMiagW7NLMk/g>cLk=c/g>cLk=c/g>cLk=c/g>cL
k=`G3@18dXcBS=:<dXcBS=:<dXcBS=:<dXcBS=:<CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=Ccm??dlo
Ccm??dloCcm??dloCcm??dlo1P0000T000Go0000o`070004o`00o`@05b<069lAWa6O4IlAWa6O4IlA
Wa6O4IlAWa6O4AQa6>`G3AR<031>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTdP?b0o83lP?b0o83lP?b0o
83lP?b0o83l600002@001Ol0003o00L000Co003o100G8`18WmnOgioOWmnOgioOWmnOgioOWmnOgioO
LMiagW7NLMiagW7NLMiagW7NLMiagW7Nk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cL5`d0B=:<dXcBS=:<
dXcBS=:<dXcBS=:<dXcBS4i=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDloCcm??dloCcm??dloCcm??dlo
Ccm??`H000090005o`000?l01`001?l00?l401LS01RO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa4HLAS/
5`dHS00`CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=83lP?b0o83lP?b0o83lP?b0o83lP?b0o1P0000X0
1Ol500Go100G8`18WmnOgioOWmnOgioOWmnOgioOWmnOgioOLMiagW7NLMiagW7NLMiagW7NLMiagW7N
k=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cL5`d0B=:<dXcBS=:<dXcBS=:<dXcBS=:<dXcBS4i=CTe>CDi=
CTe>CDi=CTe>CDi=CTe>CDloCcm??dloCcm??dloCcm??dloCcm??`H0000?0003o`3o00/05b<069lA
Wa6O4IlAWa6O4IlAWa6O4IlAWa6O4AQa6>`G3AR<031>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTdP?b0o
83lP?b0o83lP?b0o83lP?b0o83l6000040000ol0000:01LS04ROgioOWmnOgioOWmnOgioOWmnOgioO
WmmagW7NLMiagW7NLMiagW7NLMiagW7NLMk/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=`G3@18dXcBS=:<
dXcBS=:<dXcBS=:<dXcBS=:<CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=Ccm??dloCcm??dloCcm??dlo
Ccm??dlo1P0001d05b<069lAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4AQa6>`G3AR<031>CDi=CTe>CDi=
CTe>CDi=CTe>CDi=CTdP?b0o83lP?b0o83lP?b0o83lP?b0o83l600007@0G8`18WmnOgioOWmnOgioO
WmnOgioOWmnOgioOLMiagW7NLMiagW7NLMiagW7NLMiagW7Nk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cL
5`d0B=:<dXcBS=:<dXcBS=:<dXcBS=:<dXcBS4i=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDloCcm??dlo
Ccm??dloCcm??dloCcm??`H0000M01LS01RO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa4HLAS/5`dHS00`
CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDi=83lP?b0o83lP?b0o83lP?b0o83lP?b0o1P0001d05b<0B9oO
WmnOgioOWmnOgioOWmnOgioOWmnOgg7NLMiagW7NLMiagW7NLMiagW7NLMiag^cLk=c/g>cLk=c/g>cL
k=c/g>cLk=c/g1L=04SBS=:<dXcBS=:<dXcBS=:<dXcBS=:<dXa>CDi=CTe>CDi=CTe>CDi=CTe>CDi=
CTe??dloCcm??dloCcm??dloCcm??dloCcl600007@0G8`0HWa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlA
674Hk1L=68`0<4i=CTe>CDi=CTe>CDi=CTe>CDi=CTe>CB0o83lP?b0o83lP?b0o83lP?b0o83lP?`H0
000M01LS04ROgioOWmnOgioOWmnOgioOWmnOgioOWmmagW7NLMiagW7NLMiagW7NLMiagW7NLMk/g>cL
k=c/g>cLk=c/g>cLk=c/g>cLk=`G3@18dXcBS=:<dXcBS=:<dXcBS=:<dXcBS=:<CTe>CDi=CTe>CDi=
CTe>CDi=CTe>CDi=Ccm??dloCcm??dloCcm??dloCcm??dlo1P0001d05b<069lAWa6O4IlAWa6O4IlA
Wa6O4IlAWa6O4AQa6>`G3AR<031>CDi=CTe>CDi=CTe>CDi=CTe>CDi=CTdP?b0o83lP?b0o83lP?b0o
83lP?b0o83l600007@0G8`18WmnOgioOWmnOgioOWmnOgioOWmnOgioOLMiagW7NLMiagW7NLMiagW7N
LMiagW7Nk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cL5`d0B=:<dXcBS=:<dXcBS=:<dXcBS=:<dXcBS4i=
CTe>CDi=CTe>CDi=CTe>CDi=CTe>CDloCcm??dloCcm??dloCcm??dloCcm??`H0003Q0000h@000>40
003Q0000h@000>40003Q00003`02o`030?oo01800olE00Co5003oaH00olC00?o5P02oaH000?o0000
5@02oa40000?0004o`00oa@000?o00005@000ol0000G0003o`0001@000?o00005@000ol0000B0004
o`00oaD000?o000050001?l00?l@00003`001?l00?lD0003o`0001H000?o00005P000ol0000B00Co
5P000ol0000B0004o`00oaH000?o00004`001?l00?l@00003`001?l00?lD0003o`0001L000?o0000
4`02oaD000?o0?l05003oaD00olG0003o`0001@00_lA00003P05oa@000?o000050001?l00?lG0003
o`00018000?o0?l050000ol0000E0003o`0001P000?o00004P001?l00?l@00009P02oaL00_lE00?o
5P02oa@01?lE00?o5004oaD00_lA0000h@000>40003Q0000h@000>40003Q0000h@000>40003Q0000
h@0000D0eol500001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003
o`0001D000?o00005@006OnO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWol01@0000D000?o00005002oaHS
00?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003o`0001D001WoWmnOgioOWmnO
gioOWmnOgioOWmnOgioo00D000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003
o`0001@000?o00005@000ol0000E000IoilAWa6O4IlAWa6O4IlAWa6O4IlAWa6Oo`0500001@000ol0
000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@006OnO
gioOWmnOgioOWmnOgioOWmnOgioOWol01@0000D000?o00005002oaHS00?o00005@000ol0000E0003
o`0001D000?o000050000ol0000E0003o`0001D001WoWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ioo00D0
00050003o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003o`0001@000?o00005@000ol0
000E000IoioOWmnOgioOWmnOgioOWmnOgioOWmnOo`0500001@000ol0000D00;o5R<00ol0000E0003
o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@006OnO4IlAWa6O4IlAWa6O4IlAWa6O
4IlAWol01@0000D000?o00005002oaHS00?o00005@000ol0000E0003o`0001D000?o000050000ol0
000E0003o`0001D001WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo00D000050003o`0001@00_lF8`03
o`0001D000?o00005@000ol0000E0003o`0001@000?o00005@000ol0000E000IoilAWa6O4IlAWa6O
4IlAWa6O4IlAWa6Oo`0500001@000ol0000400?o1003o`H00_l58`?o12<3o`LS00?o00001003o`<0
0ol80003o`0000@00ol300?o20000ol0000800;o2`000ol000070003o`0000X000?o00002003o`X0
00?o00001`04o`X000[oWmnOgioOWmnO0ol039oOWmnOgioOWmnOo`D000050003o`0000D000?o0000
10000ol0000500;o1R<00olS8`048`03ob<S00HS00?o00001@000ol000050003o`0000D000?o0000
1@000ol000030003o`0000L000?o00001`001?l00?l:0003o`0000L000?o00002P000ol000090003
o`0000T000?o000020000ol0000:000IoilAWa6O4IlAWa7o4IlAWa6O4IlAWa6Oo`0500001@000ol0
00050003o`0000801?l600;o1R<00olS8`028`Co1b<00ol000050003o`0000D000?o00001@000ol0
00050003o`0000<000?o00001`000ol000070004o`00o`X000?o000020000ol000090003o`0000L0
1?l:0003o`0000T000?o00002@006OnOgioOWmnOgioOomnOgioOWmnOgioOWol01@0000D000?o0000
1@000ol000020003o`3o00L00_l68`03ob<S008S00?o8ol022<00ol000050003o`0000<00_l80003
o`0000D000?o00000`000ol000070003o`0000P00_l;0003o`0000P000?o00002@000ol000070003
o`3o00/000?o00002P000ol00008000IoilAWa6O4IlAWa7o4IlAWa6O4IlAWa6Oo`0500001@000ol0
00050003o`00008000?o0?l01`02o`HS00?o8b<00R<00olSo`088`03o`0000D000?o00001@000ol0
00050003o`0000D000?o00000`000ol000070003o`0000L000Co003o2P000ol000090003o`0000P0
00?o00001`000ol0o`0;0003o`0000L000Co003o2P006OnOgioOWmnOgioOomnOgioOWmnOgioOWol0
1@0000D000?o00001002o`D00_l700;o1B<2o`DS0_l88`03o`0000@00_l400?o20000ol0000400;o
1002o`T000?o00002002o`/000?o00001P04o`X000?o00002002o`/000?o00002002o`/000[oWa6O
4IlAWa6O0_l03A6O4IlAWa6O4IlAWol01@0000D000?o00005002oaHS00?o00005@000ol0000E0003
o`0001D000?o000050000ol0000E0003o`0001D001WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo00D0
00050003o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003o`0001@000?o00005@000ol0
000E000IoilAWa6O4IlAWa6O4IlAWa6O4IlAWa6Oo`0500001@000ol0000D00;o5R<00ol0000E0003
o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@006OnOgioOWmnOgioOWmnOgioOWmnO
gioOWol01@0000D000?o00005002oaHS00?o00005@000ol0000E0003o`0001D000?o000050000ol0
000E0003o`0001D001WoWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ioo00D000050003o`0001@00_lF8`03
o`0001D000?o00005@000ol0000E0003o`0001@000?o00005@000ol0000E000IoioOWmnOgioOWmnO
gioOWmnOgioOWmnOo`0500001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0
000D0003o`0001D000?o00005@006OnO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWol01@0000D000?o0000
5002oaHS00?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003o`0001D001WoWmnO
gioOWmnOgioOWmnOgioOWmnOgioo00D000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0
000E0003o`0001@000?o00005@000ol0000E000IoilAWa6O4IlAWa6O4IlAWa6O4IlAWa6Oo`050000
1@3Go`D000050003o`0001@00_lF8`03o`0001D000?oLG405G400oo/k00Ek003o`0001@000?o0000
5@006OnO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWol05`000ol0000300001@000ol0000D00;o5R<00ol0
000E000aomiagW7NLMiagW7NLMiagW7NLMiagW7Nomc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLo`0F0003
o`0001D001WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo01L000?o00000`0000D000?o00005002oaHS
00?o00005@000omaL@0EL@03onc/01G/00?o000050000ol0000E000IoilAWa6O4IlAWa6O4IlAWa6O
4IlAWa6Oo`0G0003o`0000<000050003o`0001@00_lF8`03o`0001D0037ogW7NLMiagW7NLMiagW7N
LMiagW7NLMkog>cLk=c/g>cLk=c/g>cLk=c/g>cLk=co01H000?o00005@006OnOgioOWmnOgioOWmnO
gioOWmnOgioOWol05`000ol0000300001@000ol0000D00;o5R<00ol0000E0003og5a01Ea00?ok>`0
5N`00ol0000D0003o`0001D001WoWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ioo01L000?o00000`0000D0
00?o00005002oaHS00?o00005@00<OoNLMiagW7NLMiagW7NLMiagW7NLMiag_oLk=c/g>cLk=c/g>cL
k=c/g>cLk=c/g?l05P000ol0000E000IoioOWmnOgioOWmnOgioOWmnOgioOWmnOo`0G0003o`0000<0
00050003o`0001@00_lF8`03o`0001D000?oLG405G400oo/k00Ek003o`0001@000?o00005@006OnO
4IlAWa6O4IlAWa6O4IlAWa6O4IlAWol05`000ol0000300001@000ol0000D00;o5R<00ol0000E000a
omiagW7NLMiagW7NLMiagW7NLMiagW7Nomc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLo`0F0003o`0001D0
01WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo01L000?o00000`0000D000?o00005002oaHS00?o0000
5@000omaL@0EL@03onc/01G/00?o000050000ol0000E000IoilAWa6O4IlAWa6O4IlAWa6O4IlAWa6O
o`0G0003o`0000<000050003o`0000@00ol300?o1`02o`DS0ol38`?o22<00ol0000400?o0`03o`P0
02;ogW7NLMiagW7NLOmagW7NLMiagW7NLMkog>cLk=c/g>cL0ol03=c/g>cLk=c/g>cLo`D00ol400?o
1`000ol0000800;o2`002onOgioOWmnOgioO00?o00_OWmnOgioOWmnOo`0900Co2P000ol000030000
1@000ol000050003o`0000D000?o00001002o`HS00?o8b<01B<00olS8`058`03o`0000D000?o0000
0`000ol000070003og5a00Qa00?oLG402W400oo/k008k003onc/00[/00?o000010000ol000040003
o`0000H000?o00001`001?l00?l:000IoilAWa6O4IlAWa6OoilAWa6O4IlAWa6Oo`0:0003o`0000X0
00?o00000`0000D000?o00001@000ol000050003o`0000@00_l68`03ob<S00DS00?o8b<01B<00ol0
00050003o`0000<000?o00001`00<OoNLMiagW7NLMiag_oNLMiagW7NLMiag_oLk=c/g>cLk=c/oncL
k=c/g>cLk=c/g?l01P000ol0000200Co1`000ol000070004o`00o`X000[oWmnOgioOWmnO1?l02mnO
gioOWmnOgioo00/000?o00002@000ol0000300001@000ol000050003o`0000<00_l700;o1R<00olS
8`038`;o22<00ol000050003o`0000<000?o00001`000omaL@09L@03og5a00Ua00?ok>`02>`00oo/
k00:k003o`0000@000?o00000P000ol0o`080003o`0000P00_l;000IoilAWa6O4IlAWonOoilAWa6O
4IlAWa6Oo`0<0003o`0000P000?o00000`0000D000?o00001@000ol000050003o`0000@00_l68`03
ob<S00DS00?o8b<01B<00ol000050003o`0000<000?o00001`00<OoNLMiagW7NLMiagW7oLMiagW7N
LMiag_oLk=c/g>cLk=c/oncLk=c/g>cLk=c/g?l01P000ol000020003o`3o00P000?o00001`001?l0
0?l:000IoioOWmnOgioOWonOoioOWmnOgioOWmnOo`090004o`00o`X000?o00000`0000D000?o0000
1002o`@00ol700;o1B<2o`@S0ol88`03o`0000@00_l400;o2@000omaL@07L@Co2W400oo/k007k0;o
3>`00ol0000300;o1@02o`P000?o00002002o`/000_oWa6O4IlAWa6O4@02o`0<Wa6O4IlAWa6O4Ioo
2P02o`/000?o00000`0000D000?o00005002oaHS00?o00005@00<OoNLMiagW7NLMiagW7NLMiagW7N
LMiag_oLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g?l05P000ol0000E000IoioOWmnOgioOWmnOgioOWmnO
gioOWmnOo`0G0003o`0000<000050003o`0001@00_lF8`03o`0001D000?oLG405G400oo/k00Ek003
o`0001@000?o00005@006OnO4IlAWa6O4IlAWa6O4IlAWa6O4IlAWol05`000ol0000300001@000ol0
000D00;o5R<00ol0000E000aomiagW7NLMiagW7NLMiagW7NLMiagW7Nomc/g>cLk=c/g>cLk=c/g>cL
k=c/g>cLo`0F0003o`0001D001WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo01L000?o00000`0000D0
00?o00005002oaHS00?o00005@000omaL@0EL@03onc/01G/00?o000050000ol0000E000IoilAWa6O
4IlAWa6O4IlAWa6O4IlAWa6Oo`0G0003o`0000<000050003o`0001@00_lF8`03o`0001D0037ogW7N
LMiagW7NLMiagW7NLMiagW7NLMkog>cLk=c/g>cLk=c/g>cLk=c/g>cLk=co01H000?o00005@006OnO
gioOWmnOgioOWmnOgioOWmnOgioOWol05`000ol0000300001@000ol0000D00;o5R<00ol0000E0003
og5a01Ea00?ok>`05N`00ol0000D0003o`0001D001WoWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ioo01L0
00?o00000`0000D000?o00005002oaHS00?o00005@00<OoNLMiagW7NLMiagW7NLMiagW7NLMiag_oL
k=c/g>cLk=c/g>cLk=c/g>cLk=c/g?l05P000ol0000E000IoioOWmnOgioOWmnOgioOWmnOgioOWmnO
o`0G0003o`0000<000050=Oo1@0000D000?o00005002oaHS00?o00005@000ol0000E0003o`0001D0
00?o000050006OnOgioOWmnOgioOWmnOgioOWmnOgioOWol05`000ol0000E0003o`0000<000050003
o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003o`0001@001WoWa6O4IlAWa6O4IlAWa6O
4IlAWa6O4Ioo01L000?o00005@000ol0000300001@000ol0000D00;o5R<00ol0000E0003o`0001D0
00?o00005@000ol0000D000IoioOWmnOgioOWmnOgioOWmnOgioOWmnOo`0G0003o`0001D000?o0000
0`0000D000?o00005002oaHS00?o00005@000ol0000E0003o`0001D000?o000050006OnO4IlAWa6O
4IlAWa6O4IlAWa6O4IlAWol05`000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D0
00?o00005@000ol0000E0003o`0001@001WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo01L000?o0000
5@000ol0000300001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D000I
oilAWa6O4IlAWa6O4IlAWa6O4IlAWa6Oo`0G0003o`0001D000?o00000`0000D000?o00005002oaHS
00?o00005@000ol0000E0003o`0001D000?o000050006OnOgioOWmnOgioOWmnOgioOWmnOgioOWol0
5`000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003
o`0001@001WoWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ioo01L000?o00005@000ol0000300001@000ol0
000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D000IoioOWmnOgioOWmnOgioOWmnO
gioOWmnOo`0G0003o`0001D000?o00000`0000D000?o00001003o`<00ol700;o1B<3o`<S0ol88`03
o`0000P000?o00002P000ol0000400?o1003o`L000?o00001`04o`X000?o00000`03o`<00ol8000:
oilAWa6O4IlAW`?o00bO4IlAWa6O4IlAWol:00;o2`000ol0000800?o2P000ol0000300001@000ol0
00050003o`0000<000?o00001P02o`HS00?o8b<00b<00olS8`078`03o`0000P000?o00002P000ol0
00050003o`0000@000?o00001P000ol000080003o`0000X000?o000010000ol000050003o`0000D0
01WoWmnOgioOWmnOgooOWmnOgioOWmnOgioo00T000Co003o2P000ol000090003o`0000T000?o0000
0`0000D000?o00001@000ol000030003o`0000H00_l68`03ob<S00<S00?o8b<01b<00ol000090003
o`0000T000?o00001@000ol0000200Co1`000ol000090003o`0000T000?o000010000ol000050003
o`0000D001WoWa6O4IlAWa6O4OlAWa6O4IlAWa6O4Ioo00T000Co003o2P000ol0000700Co2P000ol0
000300001@000ol000050003o`0000<000?o00001P02o`HS00?o8b<00b<00olS8`078`03o`0000T0
00?o00002@000ol000050003o`00008000?o0?l020000ol0000:0003o`0000P000?o000010000ol0
000300;o20006OnOgioOWmnOgioOomnOgioOWmnOgioOWol02P02o`/000?o00001`000ol0o`0;0003
o`0000<000050003o`0000D000?o00000`000ol0000600;o1R<00olS8`038`03ob<S00LS00?o0000
2P000ol000080003o`0000D000?o00000P000ol0o`080003o`0000L000Co003o2P000ol000040003
o`0000D000?o00001@006OnO4IlAWa6O4IlAoa6O4IlAWa6O4IlAWol02@001?l00?l:0003o`0000L0
00?o0?l02`000ol0000300001@000ol0000400;o1002o`P00_l58`;o12<2o`TS00?o00001`04o`X0
00?o00001002o`D00_l80003o`0000P00_l;0003o`0000<00_l400?o20002_nOgioOWmnOgil2o`0=
gioOWmnOgioOWmnOo`0:00;o2`000ol0000800;o2`000ol0000300001@000ol0000D00;o5R<00ol0
000E0003o`0001D000?o00005@000ol0000D000IoilAWa6O4IlAWa6O4IlAWa6O4IlAWa6Oo`0G0003
o`0001D000?o00000`0000D000?o00005002oaHS00?o00005@000ol0000E0003o`0001D000?o0000
50006OnOgioOWmnOgioOWmnOgioOWmnOgioOWol05`000ol0000E0003o`0000<000050003o`0001@0
0_lF8`03o`0001D000?o00005@000ol0000E0003o`0001@001WoWa6O4IlAWa6O4IlAWa6O4IlAWa6O
4Ioo01L000?o00005@000ol0000300001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o0000
5@000ol0000D000IoioOWmnOgioOWmnOgioOWmnOgioOWmnOo`0G0003o`0001D000?o00000`0000D0
00?o00005002oaHS00?o00005@000ol0000E0003o`0001D000?o000050006OnO4IlAWa6O4IlAWa6O
4IlAWa6O4IlAWol05`000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o0000
5@000ol0000E0003o`0001@001WoWmnOgioOWmnOgioOWmnOgioOWmnOgioo01L000?o00005@000ol0
000300001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D000IoilAWa6O
4IlAWa6O4IlAWa6O4IlAWa6Oo`0G0003o`0001D000?o00000`0000D000?o00005002oaHS00?o0000
5@000ol0000E0003o`0001D000?o000050006OnOgioOWmnOgioOWmnOgioOWmnOgioOWol05`000ol0
000E0003o`0000<000050=Oo1@0000D000?o00005002oaHS037og>cLk=c/g>cLk=c/g>cLk=c/g>cL
k=cogW7NLMiagW7NLMiagW7NLMiagW7NLMko01L001SogioOWmnOgioOWmnOgioOWmnOgioOWolG0003
o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<00oo/k00Ek003og5a01Ea00?o0000
5@006?lAWa6O4IlAWa6O4IlAWa6O4IlAWa6OoaL000?o00005@000ol0000E0003o`0000<000050003
o`0001@00_lF8`0aomc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLomiagW7NLMiagW7NLMiagW7NLMiagW7N
o`0G000HomnOgioOWmnOgioOWmnOgioOWmnOgioo5`000ol0000E0003o`0001D000?o00000`0000D0
00?o00005002oaHS00?ok>`05N`00omaL@0EL@03o`0001D001So4IlAWa6O4IlAWa6O4IlAWa6O4IlA
WolG0003o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<0<OoLk=c/g>cLk=c/g>cL
k=c/g>cLk=c/g?oNLMiagW7NLMiagW7NLMiagW7NLMiag_l05`006?oOWmnOgioOWmnOgioOWmnOgioO
WmnOoaL000?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`03onc/01G/00?oLG40
5G400ol0000E000Hoa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ioo5`000ol0000E0003o`0001D000?o0000
0`0000D000?o00005002oaHS037og>cLk=c/g>cLk=c/g>cLk=c/g>cLk=cogW7NLMiagW7NLMiagW7N
LMiagW7NLMko01L001SogioOWmnOgioOWmnOgioOWmnOgioOWolG0003o`0001D000?o00005@000ol0
000300001@000ol0000D00;o5R<00oo/k00Ek003og5a01Ea00?o00005@006?lAWa6O4IlAWa6O4IlA
Wa6O4IlAWa6OoaL000?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`0aomc/g>cL
k=c/g>cLk=c/g>cLk=c/g>cLomiagW7NLMiagW7NLMiagW7NLMiagW7No`0G000HomnOgioOWmnOgioO
WmnOgioOWmnOgioo5`000ol0000E0003o`0001D000?o00000`0000D000?o00002002o`X00_l98`;o
2b<00oo/k007k0?o2n`00omaL@07L@Co2W400ol0000400?o0`03o`P000[o4IlAWa6O4IlA0ol02a6O
4IlAWa6O4Ioo00H00ol300?o20000ol0000400?o1003o`L000?o000020000ol0000:0003o`0000<0
00050003o`0000L000Co003o2@02o`PS00Co8b?o2R<0<OoLk=c/g>cLk=c/oncLk=c/g>cLk=c/g?oN
LMiagW7NLMiaog7NLMiagW7NLMiag_l01`000ol000030003o`0000L001SogioOWmnOgioOWonOgioO
WmnOgioOWol70003o`0000D000?o00001@000ol000050003o`0000@000?o00001P000ol000080003
o`0000X000?o00000`0000D000?o00001`001?l00?l900;o22<01?lS8ol:8`03onc/00S/00?ok>`0
2^`00omaL@09L@03og5a00Ua00?o00001@000ol000030003o`0000L000Wo4IlAWa6O4Il01?l02a6O
4IlAWa6O4Ioo00L000?o00001@000ol000050003o`0000D000?o00000P04o`L000?o00002@000ol0
00090003o`0000<000050003o`0000P00_l:00;o2B<2o`/S037og>cLk=c/g>cLk?o/g>cLk=c/g>cL
k=cogW7NLMiagW7NLMiaog7NLMiagW7NLMko00L000?o00000`000ol00007000HomnOgioOWmnOoioo
WmnOgioOWmnOgioo1`000ol0000300;o20000ol000050003o`00008000?o0?l020000ol000090003
o`0000T000?o00000`0000D000?o00001`001?l00?l900;o22<01?lS8ol:8`03onc/00S/00?ok>`0
2^`00omaL@07L@04og5ao`Ya00?o00001@000ol000030003o`0000L001So4IlAWa6O4IooWonO4IlA
Wa6O4IlAWol70003o`0000D000?o00001@000ol000050003o`00008000?o0?l020000ol0000:0003
o`0000P000?o00000`0000D000?o00002002o`X00_l98`;o2b<02_oLk=c/g>cLk=`2o`0Gk=c/g>cL
k=c/g>cLomiagW7NLMiagW400_l03=iagW7NLMiagW7No`H00_l400;o2@002_oOWmnOgioOWml2o`0<
WmnOgioOWmnOgioo1P02o`@00ol80003o`0000@00_l500;o20000ol0000700Co2P000ol000030000
1@000ol0000D00;o5R<00oo/k00Ek003og5a01Ea00?o00005@006?lAWa6O4IlAWa6O4IlAWa6O4IlA
Wa6OoaL000?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`0aomc/g>cLk=c/g>cL
k=c/g>cLk=c/g>cLomiagW7NLMiagW7NLMiagW7NLMiagW7No`0G000HomnOgioOWmnOgioOWmnOgioO
WmnOgioo5`000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS00?ok>`05N`00oma
L@0EL@03o`0001D001So4IlAWa6O4IlAWa6O4IlAWa6O4IlAWolG0003o`0001D000?o00005@000ol0
000300001@000ol0000D00;o5R<0<OoLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g?oNLMiagW7NLMiagW7N
LMiagW7NLMiag_l05`006?oOWmnOgioOWmnOgioOWmnOgioOWmnOoaL000?o00005@000ol0000E0003
o`0000<000050003o`0001@00_lF8`03onc/01G/00?oLG405G400ol0000E000Hoa6O4IlAWa6O4IlA
Wa6O4IlAWa6O4Ioo5`000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS037og>cL
k=c/g>cLk=c/g>cLk=c/g>cLk=cogW7NLMiagW7NLMiagW7NLMiagW7NLMko01L001SogioOWmnOgioO
WmnOgioOWmnOgioOWolG0003o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<00oo/
k00Ek003og5a01Ea00?o00005@006?lAWa6O4IlAWa6O4IlAWa6O4IlAWa6OoaL000?o00005@000ol0
000E0003o`0000<000050003o`0001@00_lF8`0aomc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLomiagW7N
LMiagW7NLMiagW7NLMiagW7No`0G000HomnOgioOWmnOgioOWmnOgioOWmnOgioo5`000ol0000E0003
o`0001D000?o00000`0000D0eol500001@000ol0000D00;o5R<00ol0000E000aomiagW7NLMiagW7N
LMiagW7NLMiagW7NomnOgioOWmnOgioOWmnOgioOWmnOgioOo`0F0003o`0001D001Wok=c/g>cLk=c/
g>cLk=c/g>cLk=c/g>co01L000?o00000`0000D000?o00005002oaHS00?o00005@000omaL@0EL@0I
oa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAo`0F0003o`0001D000?ok>`05N`00ol0000E0003o`0000<0
00050003o`0001@00_lF8`03o`0001D0037ogW7NLMiagW7NLMiagW7NLMiagW7NLMkogioOWmnOgioO
WmnOgioOWmnOgioOWmoo01H000?o00005@006Oo/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk?l05`000ol0
000300001@000ol0000D00;o5R<00ol0000E0003og5a01Ea01Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlA
Wa7o01H000?o00005@000oo/k00Ek003o`0001D000?o00000`0000D000?o00005002oaHS00?o0000
5@00<OoNLMiagW7NLMiagW7NLMiagW7NLMiag_oOWmnOgioOWmnOgioOWmnOgioOWmnOgol05P000ol0
000E000IoncLk=c/g>cLk=c/g>cLk=c/g>cLk=c/o`0G0003o`0000<000050003o`0001@00_lF8`03
o`0001D000?oLG405G406OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05P000ol0000E0003onc/01G/
00?o00005@000ol0000300001@000ol0000D00;o5R<00ol0000E000aomiagW7NLMiagW7NLMiagW7N
LMiagW7NomnOgioOWmnOgioOWmnOgioOWmnOgioOo`0F0003o`0001D001Wok=c/g>cLk=c/g>cLk=c/
g>cLk=c/g>co01L000?o00000`0000D000?o00005002oaHS00?o00005@000omaL@0EL@0Ioa6O4IlA
Wa6O4IlAWa6O4IlAWa6O4IlAo`0F0003o`0001D000?ok>`05N`00ol0000E0003o`0000<000050003
o`0001@00_lF8`03o`0001D0037ogW7NLMiagW7NLMiagW7NLMiagW7NLMkogioOWmnOgioOWmnOgioO
WmnOgioOWmoo01H000?o00005@006Oo/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk?l05`000ol000030000
1@000ol000080003o`0000T00_l98`03ob<S00XS00?o00001003o`@00ol70003og5a00Aa0ol3L@?o
27402olAWa6O4IlAWa6O00?o00^O4IlAWa6O4IlAo`0500?o0`03o`P000?o00001`04o`X000?ok>`0
1n`3o`_/00?o00002002o`/000?o00000`0000D000?o000020000ol0000900;o2B<00olS8`0:8`03
o`0000D000?o000010000ol00006000aomiagW7NLMkogW7NLMiag_oNLMiagW7NomnOgioOWmnOgioO
omnOgioOWmnOgioOo`060003o`0000<000?o00001`000ol000080003o`0000X001Wok=c/g>cLk=c/
g?oLk=c/g>cLk=c/g>co00T000Co003o2P000ol0000300001@000ol000090003o`0000P00_l:8`03
ob<S00TS00?o00001@000ol0000200Co1`000omaL@05L@03og5a00Ea00?oLG401G402_lAWa6O4IlA
Wa44o`0;Wa6O4IlAWa6O4Ol01P000ol000030003o`0000L000?o00002@000ol000090003onc/00S/
00?ok>`02^`00ol000070004o`00o`X000?o00000`0000D000?o00002@000ol0000800;o2R<00olS
8`098`03o`0000D000?o00000P000ol0o`08000>omiagW7NLMkogW7NLMh2o`0QLMiagW7NLMkogioO
WmnOgioOomoogioOWmnOgioOWmoo00H000?o00000`000ol000070003o`0000X000?o000020006Oo/
g>cLk=c/g>cLomc/g>cLk=c/g>cLk?l02P02o`/000?o00000`0000D000?o00002P000ol0000700;o
2b<00olS8`088`03o`0000D000?o00000P000ol0o`080003og5a00Ea00?oLG401G400omaL@05L@0I
oa6O4IlAWa6O4OlAoa6O4IlAWa6O4IlAo`060003o`0000<000?o00001`000ol000070004o`00o`X0
00?ok>`02>`00oo/k00:k003o`0000L000Co003o2P000ol0000300001@000ol0000700Co2@02o`PS
1?l:8`03o`0000@00_l500;o20001ooNLMiagW400_l01=iagW43o`0CLMiagW7NLMkogioOWmnOgioO
W`02o`0<gioOWmnOgioOWmoo1@02o`@00_l90003o`0000P00_l;000:oncLk=c/g>cLk0;o00gLk=c/
g>cLk=c/g>co00X00_l;0003o`0000<000050003o`0001@00_lF8`03o`0001D000?oLG405G406OlA
Wa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05P000ol0000E0003onc/01G/00?o00005@000ol000030000
1@000ol0000D00;o5R<00ol0000E000aomiagW7NLMiagW7NLMiagW7NLMiagW7NomnOgioOWmnOgioO
WmnOgioOWmnOgioOo`0F0003o`0001D001Wok=c/g>cLk=c/g>cLk=c/g>cLk=c/g>co01L000?o0000
0`0000D000?o00005002oaHS00?o00005@000omaL@0EL@0Ioa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlA
o`0F0003o`0001D000?ok>`05N`00ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D0
037ogW7NLMiagW7NLMiagW7NLMiagW7NLMkogioOWmnOgioOWmnOgioOWmnOgioOWmoo01H000?o0000
5@006Oo/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk?l05`000ol0000300001@000ol0000D00;o5R<00ol0
000E0003og5a01Ea01Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa7o01H000?o00005@000oo/k00Ek003
o`0001D000?o00000`0000D000?o00005002oaHS00?o00005@00<OoNLMiagW7NLMiagW7NLMiagW7N
LMiag_oOWmnOgioOWmnOgioOWmnOgioOWmnOgol05P000ol0000E000IoncLk=c/g>cLk=c/g>cLk=c/
g>cLk=c/o`0G0003o`0000<000050003o`0001@00_lF8`03o`0001D000?oLG405G406OlAWa6O4IlA
Wa6O4IlAWa6O4IlAWa6O4Ol05P000ol0000E0003onc/01G/00?o00005@000ol0000300001@000ol0
000D00;o5R<00ol0000E000aomiagW7NLMiagW7NLMiagW7NLMiagW7NomnOgioOWmnOgioOWmnOgioO
WmnOgioOo`0F0003o`0001D001Wok=c/g>cLk=c/g>cLk=c/g>cLk=c/g>co01L000?o00000`0000D0
eol500001@000ol0000D00;o5R<00ol0000E000IomnOgioOWmnOgioOWmnOgioOWmnOgioOo`0G0003
o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS00?o0000
5@006OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05`000ol0000D0003o`0001D000?o00005@000ol0
000E0003o`0000<000050003o`0001@00_lF8`03o`0001D001WogioOWmnOgioOWmnOgioOWmnOgioO
Wmoo01L000?o000050000ol0000E0003o`0001D000?o00005@000ol0000300001@000ol0000D00;o
5R<00ol0000E000Ioa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAo`0G0003o`0001@000?o00005@000ol0
000E0003o`0001D000?o00000`0000D000?o00005002oaHS00?o00005@006OoOWmnOgioOWmnOgioO
WmnOgioOWmnOgol05`000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003
o`0001@00_lF8`03o`0001D001Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa7o01L000?o000050000ol0
000E0003o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<00ol0000E000IomnOgioO
WmnOgioOWmnOgioOWmnOgioOo`0G0003o`0001@000?o00005@000ol0000E0003o`0001D000?o0000
0`0000D000?o00005002oaHS00?o00005@006OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05`000ol0
000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D0
01WogioOWmnOgioOWmnOgioOWmnOgioOWmoo01L000?o000050000ol0000E0003o`0001D000?o0000
5@000ol0000300001@000ol0000800?o2@02o`TS0ol:8`03o`0000P00_l;000:oa6O4IlAWa6O4@?o
00`AWa6O4IlAWa6O4Ol600?o0`03o`P000?o00001P04o`X000?o00001003o`@00ol70003o`0000P0
00?o00002P000ol0000400?o0`03o`P000?o00000`0000D000?o00002@000ol0000800;o2R<00olS
8`098`03o`0000L000Co003o2P006OoOWmnOgioOWmnOoioOWmnOgioOWmnOgol01`000ol000050003
o`0000D000?o00001`000ol0000:0003o`0000D000?o000010000ol000060003o`0000P000?o0000
2P000ol000050003o`0000<000?o00001`000ol0000300001@000ol0000700Co2@02o`PS1?l:8`03
o`0000L000Co003o2P006OlAWa6O4IlAWa6OoilAWa6O4IlAWa6O4Ol01`000ol000050003o`0000D0
00?o000020000ol000090003o`0000D000?o00000P04o`L000?o00002@000ol000090003o`0000D0
00?o00000`000ol000070003o`0000<000050003o`0000L000?o0?l02P02o`PS00?o8ol02b<00ol0
000800;o2`006OoOWmnOgioOWmnOoioOWmnOgioOWmnOgol01`000ol0000300;o20000ol000090003
o`0000P000?o00001@000ol000020003o`3o00P000?o00002@000ol000090003o`0000D000?o0000
0`000ol000070003o`0000<000050003o`0000L000?o0?l02P02o`PS00?o8ol02b<00ol000070004
o`00o`X001Wo4IlAWa6O4IlAWonO4IlAWa6O4IlAWa7o00L000?o00001@000ol000050003o`0000H0
00Co003o2P000ol000050003o`00008000?o0?l020000ol0000:0003o`0000P000?o00001@000ol0
00030003o`0000L000?o00000`0000D000?o00002002o`X00_l98`;o2b<00ol0000800;o2`002_oO
WmnOgioOWml2o`0=WmnOgioOWmnOgioOo`0600;o1003o`P000?o00001`02o`/000?o00001002o`D0
0_l80003o`0000L01?l:0003o`0000@00_l400;o2@000ol0000300001@000ol0000D00;o5R<00ol0
000E000Ioa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAo`0G0003o`0001@000?o00005@000ol0000E0003
o`0001D000?o00000`0000D000?o00005002oaHS00?o00005@006OoOWmnOgioOWmnOgioOWmnOgioO
WmnOgol05`000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0001@0
0_lF8`03o`0001D001Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa7o01L000?o000050000ol0000E0003
o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<00ol0000E000IomnOgioOWmnOgioO
WmnOgioOWmnOgioOo`0G0003o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D0
00?o00005002oaHS00?o00005@006OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05`000ol0000D0003
o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D001WogioO
WmnOgioOWmnOgioOWmnOgioOWmoo01L000?o000050000ol0000E0003o`0001D000?o00005@000ol0
000300001@000ol0000D00;o5R<00ol0000E000Ioa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAo`0G0003
o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D0eol500001@000ol0000D00;o
5R<06OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05g400ol0000E0003onc/01C/00?o00005@000ol0
000E0003o`0001D000?o00000`0000D000?o00005002oaHS037ogioOWmnOgioOWmnOgioOWmnOgioO
WmoogW7NLMiagW7NLMiagW7NLMiagW7NLMko01L001Sog>cLk=c/g>cLk=c/g>cLk=c/g>cLk?lG0003
o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<06OlAWa6O4IlAWa6O4IlAWa6O4IlA
Wa6O4Ol05g400ol0000E0003onc/01C/00?o00005@000ol0000E0003o`0001D000?o00000`0000D0
00?o00005002oaHS037ogioOWmnOgioOWmnOgioOWmnOgioOWmoogW7NLMiagW7NLMiagW7NLMiagW7N
LMko01L001Sog>cLk=c/g>cLk=c/g>cLk=c/g>cLk?lG0003o`0001D000?o00005@000ol000030000
1@000ol0000D00;o5R<06OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05g400ol0000E0003onc/01C/
00?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS037ogioOWmnOgioO
WmnOgioOWmnOgioOWmoogW7NLMiagW7NLMiagW7NLMiagW7NLMko01L001Sog>cLk=c/g>cLk=c/g>cL
k=c/g>cLk?lG0003o`0001D000?o00005@000ol0000300001@000ol0000D00;o5R<06OlAWa6O4IlA
Wa6O4IlAWa6O4IlAWa6O4Ol05g400ol0000E0003onc/01C/00?o00005@000ol0000E0003o`0001D0
00?o00000`0000D000?o00005002oaHS037ogioOWmnOgioOWmnOgioOWmnOgioOWmoogW7NLMiagW7N
LMiagW7NLMiagW7NLMko01L001Sog>cLk=c/g>cLk=c/g>cLk=c/g>cLk?lG0003o`0001D000?o0000
5@000ol0000300001@000ol0000D00;o5R<06OlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4Ol05g400ol0
000E0003onc/01C/00?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00001`04o`T0
0_l88`Co2R<02ooOWmnOgioOWmnO00?o01FOgioOWmnOgioOomiagW7NLMiagW400_l03=iagW7NLMia
gW7No`H00ol400?o1`002OoLk=c/g>cLk003o`0<k=c/g>cLk=c/g>co2P000ol0000:0003o`0000@0
0ol300?o20000ol0000400?o0`03o`P000?o00000`0000D000?o000020000ol0000900;o2B<00olS
8`0:8`0Ioa6O4IlAWa6O4IlAoa6O4IlAWa6O4IlAo`09L@04og5ao`Ya00?o00001@000ol000040003
o`0000H000?ok>`01n`00oo/k00:k003o`0000P000?o00002P000ol000050003o`0000<000?o0000
1`000ol000050003o`0000D000?o00001@000ol0000300001@000ol000090003o`0000P00_l:8`03
ob<S00TS00[ogioOWmnOgioO1?l08ioOWmnOgioOWmoogW7NLMiagW7Nomiaog7NLMiagW7NLMko00L0
00?o00000P04o`L001Sog>cLk=c/g>cLomc/g>cLk=c/g>cLk?l;0003o`0000T000?o00001@000ol0
00030003o`0000L000?o00001@000ol000050003o`0000D000?o00000`0000D000?o00002P000ol0
000700;o2b<00olS8`088`0Ioa6O4IlAWa6O4OlAoa6O4IlAWa6O4IlAo`0:L@;o2g400ol000050003
o`00008000?o0?l020000oo/k007k003onc/00[/00?o00002@000ol000090003o`0000D000?o0000
0`000ol000070003o`0000D000?o00000`02o`P000?o00000`0000D000?o00001`001?l00?l900;o
22<01?lS8ol:8`0aomnOgioOWmnOgooOomnOgioOWmnOgioOomiagW7NLMiag_oNLOmagW7NLMiagW7N
o`070003o`00008000?o0?l020006?oLk=c/g>cLk=cog>cLk=c/g>cLk=c/o``000?o000020000ol0
00050003o`0000<000?o00001`000ol000050003o`0000D000?o00001@000ol0000300001@000ol0
000800;o2P02o`TS0_l;8`0;oa6O4IlAWa6O4Il00_l0316O4IlAWa6O4IlAo`Ya0_l;L@03o`0000@0
0_l500;o20000oo/k006k0;o3>`00ol0000700Co2P000ol0000400;o1002o`T000?o00001002o`@0
0ol80003o`0000<000050003o`0001@00_lF8`0aomnOgioOWmnOgioOWmnOgioOWmnOgioOomiagW7N
LMiagW7NLMiagW7NLMiagW7No`0G000Homc/g>cLk=c/g>cLk=c/g>cLk=c/g>co5`000ol0000E0003
o`0001D000?o00000`0000D000?o00005002oaHS01Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa7o01Ma
00?o00005@000oo/k00Dk003o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0001@0
0_lF8`0aomnOgioOWmnOgioOWmnOgioOWmnOgioOomiagW7NLMiagW7NLMiagW7NLMiagW7No`0G000H
omc/g>cLk=c/g>cLk=c/g>cLk=c/g>co5`000ol0000E0003o`0001D000?o00000`0000D000?o0000
5002oaHS01Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa7o01Ma00?o00005@000oo/k00Dk003o`0001D0
00?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`0aomnOgioOWmnOgioOWmnOgioO
WmnOgioOomiagW7NLMiagW7NLMiagW7NLMiagW7No`0G000Homc/g>cLk=c/g>cLk=c/g>cLk=c/g>co
5`000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS01Wo4IlAWa6O4IlAWa6O4IlA
Wa6O4IlAWa7o01Ma00?o00005@000oo/k00Dk003o`0001D000?o00005@000ol0000E0003o`0000<0
00050003o`0001@00_lF8`0aomnOgioOWmnOgioOWmnOgioOWmnOgioOomiagW7NLMiagW7NLMiagW7N
LMiagW7No`0G000Homc/g>cLk=c/g>cLk=c/g>cLk=c/g>co5`000ol0000E0003o`0001D000?o0000
0`0000D000?o00005002oaHS01Wo4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa7o01Ma00?o00005@000oo/
k00Dk003o`0001D000?o00005@000ol0000E0003o`0000<000050=Oo1@0000D000?o00005002oaHS
00?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0
000300001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D0
00?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0
000E0003o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS
00?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0
000300001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D0
00?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0
000E0003o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS
00?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0
000300001@000ol0000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D0
00?o00005@000ol0000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0
000E0003o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00001`03o`X0
0_l88`?o2b<00ol0000700Co2P000ol0000800?o2P000ol000080003o`0000X000?o00001`02o`/0
00?o00001003o`<00ol80003o`0000@00ol300?o20000ol0000400?o1003o`L000?o00000`0000D0
00?o000020000ol0000900;o2B<00olS8`0:8`03o`0000P000?o00002P000ol000090003o`0000T0
00?o000020000ol0000:0003o`0000H000Co003o2P000ol000050003o`0000<000?o00001`000ol0
00050003o`0000D000?o00001@000ol000050003o`0000@000?o00001P000ol0000300001@000ol0
00080003o`0000T00_l98`03ob<S00XS00?o00002@000ol000090003o`0000L01?l:0003o`0000T0
00?o00002@000ol000060004o`00o`X000?o00001@000ol000030003o`0000L000?o00001@000ol0
00050003o`0000D000?o00001@000ol0000200Co1`000ol0000300001@000ol000080003o`0000T0
0_l98`03ob<S00XS00?o00002P000ol000080003o`0000L000?o0?l02`000ol000090003o`0000T0
00?o00001`02o`/000?o00001@000ol000030003o`0000L000?o00001@000ol0000300;o20000ol0
00050003o`00008000?o0?l020000ol0000300001@000ol000080003o`0000T00_l98`03ob<S00XS
00?o00001`001?l00?l:0003o`0000L000?o0?l02`000ol0000:0003o`0000P000?o00001P001?l0
0?l:0003o`0000D000?o00000`000ol000070003o`0000D000?o00001@000ol000050003o`0000D0
00?o00000P000ol0o`080003o`0000<000050003o`0000L00_l;00;o22<2o``S00?o00002002o`/0
00?o00002002o`/000?o00001`04o`X000?o00001`02o`/000?o00001002o`@00_l90003o`0000@0
0_l400?o20000ol0000400;o1@02o`P000?o00000`0000D000?o00005002oaHS00?o00005@000ol0
000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0000300001@000ol0
000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@000ol0
000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003o`0001@0
00?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS00?o00005@000ol0
000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0000300001@000ol0
000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@000ol0
000E0003o`0000<000050003o`0001@00_lF8`03o`0001D000?o00005@000ol0000E0003o`0001@0
00?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o00005002oaHS00?o00005@000ol0
000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0000300001@000ol0
000D00;o5R<00ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@000ol0
000E0003o`0000<000040=So1@0000@0f?l500001@000ol0000C00?o5P000ol0000E0003o`0001D0
00?o00005@000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003o`000180
00Co0?oo5P000ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@000ol0
000E0003o`0000<000050003o`00014000?o00000_lF0003o`0001D000?o00005@000ol0000E0003
o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D000?o000040001?l00002oaH0
00?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003o`0001D000?o00005@000ol0
000300001@000ol0000200;o00<0ool020000ol0000200;o5P000ol0000E0003o`0001D000?o0000
5@000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0000<000?o0?l0
20000ol0000300;o5P000ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o0000
5@000ol0000E0003o`0000<000050003o`0000@000?o00001P000ol0000400;o5P000ol0000E0003
o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003
o`0000<000?o0?l01P000ol0000500;o5P000ol0000E0003o`0001D000?o00005@000ol0000D0003
o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0000800_l00`3oo`040003o`0000H0
0_l800?o2`000ol0000700Co2P000ol0000800?o2P000ol000080003o`0000X000?o00001`02o`/0
00?o00001003o`<00ol80003o`0000@00ol300?o20000ol0000400?o1003o`L000?o00000`0000D0
00?o00002P000ol0000700;o2@000ol0000:0003o`0000P000?o00002P000ol000090003o`0000T0
00?o000020000ol0000:0003o`0000H000Co003o2P000ol000050003o`0000<000?o00001`000ol0
00050003o`0000D000?o00001@000ol000050003o`0000@000?o00001P000ol0000300001@000ol0
00090003o`0000P00_l90003o`0000X000?o00002@000ol000090003o`0000L01?l:0003o`0000T0
00?o00002@000ol000060004o`00o`X000?o00001@000ol000030003o`0000L000?o00001@000ol0
00050003o`0000D000?o00001@000ol0000200Co1`000ol0000300001@000ol000080004o`0000?o
1@02o`T000?o00002P000ol0000:0003o`0000P000?o00001`000ol0o`0;0003o`0000T000?o0000
2@000ol0000700;o2`000ol000050003o`0000<000?o00001`000ol000050003o`0000<00_l80003
o`0000D000?o00000P000ol0o`080003o`0000<000050003o`0000L000?o00000`000ol0000400;o
2@000ol0000:0003o`0000L000Co003o2P000ol000070003o`3o00/000?o00002P000ol000080003
o`0000H000Co003o2P000ol000050003o`0000<000?o00001`000ol000050003o`0000D000?o0000
1@000ol000050003o`00008000?o0?l020000ol0000300001@000ol000060003o`0000D000?o0000
0`02o`P00_l<0003o`0000P00_l;0003o`0000P00_l;0003o`0000L01?l:0003o`0000L00_l;0003
o`0000@00_l400;o2@000ol0000400;o1003o`P000?o00001002o`D00_l80003o`0000<000050003
o`0000D000?o00001P000ol0000300;o5P000ol0000E0003o`0001D000?o00005@000ol0000D0003
o`0001D000?o00005@000ol0000E0003o`0000<000050003o`0000@000?o00001P000ol0o`0400;o
5P000ol0000E0003o`0001D000?o00005@000ol0000D0003o`0001D000?o00005@000ol0000E0003
o`0000<000050003o`0000<000?o00001`000ol0o`0400;o5P000ol0000E0003o`0001D000?o0000
5@000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050003o`00008000?o0000
1`02o`030?oo00<00_lF0003o`0001D000?o00005@000ol0000E0003o`0001@000?o00005@000ol0
000E0003o`0001D000?o00000`0000D000Go0000o`0B00;o5P000ol0000E0003o`0001D000?o0000
5@000ol0000D0003o`0001D000?o00005@000ol0000E0003o`0000<000050004o`00oa<00_lF0003
o`0001D000?o00005@000ol0000E0003o`0001@000?o00005@000ol0000E0003o`0001D000?o0000
0`0000D000?o0?l05002oaH000?o00005@000ol0000E0003o`0001D000?o000050000ol0000E0003
o`0001D000?o00005@000ol0000300001@02oaD00_lF0003o`0001D000?o00005@000ol0000E0003
o`0001@000?o00005@000ol0000E0003o`0001D000?o00000`0000D0eol500007002ol<0003Q0000
h@000>40003Q0000h@000>40000=00;o4002ok800ol;00003@000ol0000@0003o`000;4000?o0000
2P0000L00_l40003o`0000800ol300?o1@000ol0002H00;o00<0ool02@000ol0o`090003o`0000T0
00060004o`00o`<000?o00000`000ol000050003o`00008000?o0000V@000ol0o`0;0003o`0000P0
00?o00002@0000H000Co003o0`000ol000030003o`0000D000?o00000P000ol0002J0003o`0000P0
1Ol70003o`3o00X000060004o`00o`<000?o00000`000ol0000200?o1@000ol0002I0003o`3o00/0
00?o00001`000ol0o`0:00001P001?l00?l30003o`0000<000?o00000P000ol000050003o`0009P0
0_l00`3oo`0C00;o00<0ool02@0000D00_l200;o0P02o`<00_l400Co0`02ol00003Q0000h@000>40
0000\
\>"],
  ImageRangeCache->{{{0, 224.375}, {287, 0}} -> {-1.22505, -2.29384, 
  0.0421175, 0.0421175}},
  CellTags->"OtherProps"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "One third of the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_13\)]],
  " can act as a generator for the group."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \({CyclicGenerators[U[13]], \ Size[U[13]]}\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({{2, 6, 7, 11}, 12}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "The following exponents (including the 1 implicitly given on ",
  StyleBox["g", "MR"],
  ") are intimately related to 12. How?"
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell["CyclicGenerators[Cyclic[12]]", "Input",
  CellLabel->"In[23]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    \({"g", "g"\^5, "g"\^7, "g"\^11}\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ElementToPower",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["g",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ element\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(g\^n\),
                  "TraditionalForm"],
                "Text"], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["GroupExponent",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ smallest\ positive\ integer\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ such\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{\(g\^n\), 
                    StyleBox["=",
                      SingleLetterItalics->False], " ", \(id\_G\)}],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ for\ all\ elements\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["g",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["th",
                    SingleLetterItalics->False], "e"}]], " ", "groupoid", 
              " ", 
              StyleBox[
                FormBox["G",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->{"OtherProps", "i:11"}],

Cell["Miscellaneous functions.", "Caption",
  CellTags->"OtherProps"],

Cell[TextData[{
  "Using the ",
  StyleBox["Table", "MR"],
  " function with ",
  StyleBox["ElementToPower", "MR"],
  ", we can easily see various powers of a given element."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[{n, \ ElementToPower[U[15], \ 2, \ n]}, \ {n, \ \(-2\), 4}] // 
      TableForm[#, 
          TableHeadings\  \[Rule] 
            \ {None, {"\<n\>", \*"\"\<\!\(2\^n\)\\n\>\""}}]&\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"OtherProps"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"n\"\>", \("\!\(2\^n\)\n"\)},
          {\(-2\), "4"},
          {\(-1\), "8"},
          {"0", "1"},
          {"1", "2"},
          {"2", "4"},
          {"3", "8"},
          {"4", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"n", "\!\(2\^n\)\n"}}]&)]], 
  "Output",
  CellLabel->"Out[24]//TableForm=",
  CellTags->"OtherProps"]
}, Open  ]],

Cell[TextData[{
  "We see that the exponent of the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_15\)]],
  " is 4."
}], "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupExponent[U[15], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"OtherProps"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .55556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.10582 0.0132275 0.10582 [
[ 0 0 0 0 ]
[ 1 .55556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .55556 L
0 .55556 L
closepath
clip
newpath
1 1 0 r
.12963 .11905 m
.12963 .22487 L
.23545 .22487 L
.23545 .11905 L
F
0 0 0 r
[(1)] .18254 .17196 0 0 Mshowa
1 1 0 r
.12963 .22487 m
.12963 .33069 L
.23545 .33069 L
.23545 .22487 L
F
0 0 0 r
[(1)] .18254 .27778 0 0 Mshowa
1 1 0 r
.12963 .33069 m
.12963 .43651 L
.23545 .43651 L
.23545 .33069 L
F
0 0 0 r
[(1)] .18254 .3836 0 0 Mshowa
1 1 0 r
.12963 .43651 m
.12963 .54233 L
.23545 .54233 L
.23545 .43651 L
F
0 0 0 r
[(1)] .18254 .48942 0 0 Mshowa
1 .5 0 r
.23545 .11905 m
.23545 .22487 L
.34127 .22487 L
.34127 .11905 L
F
0 0 0 r
[(2)] .28836 .17196 0 0 Mshowa
.56 .37 .6 r
.23545 .22487 m
.23545 .33069 L
.34127 .33069 L
.34127 .22487 L
F
0 0 0 r
[(4)] .28836 .27778 0 0 Mshowa
.74 .99 .79 r
.23545 .33069 m
.23545 .43651 L
.34127 .43651 L
.34127 .33069 L
F
0 0 0 r
[(8)] .28836 .3836 0 0 Mshowa
1 1 0 r
.23545 .43651 m
.23545 .54233 L
.34127 .54233 L
.34127 .43651 L
F
0 0 0 r
[(1)] .28836 .48942 0 0 Mshowa
.56 .37 .6 r
.34127 .11905 m
.34127 .22487 L
.44709 .22487 L
.44709 .11905 L
F
0 0 0 r
[(4)] .39418 .17196 0 0 Mshowa
1 1 0 r
.34127 .22487 m
.34127 .33069 L
.44709 .33069 L
.44709 .22487 L
F
0 0 0 r
[(1)] .39418 .27778 0 0 Mshowa
.56 .37 .6 r
.34127 .33069 m
.34127 .43651 L
.44709 .43651 L
.44709 .33069 L
F
0 0 0 r
[(4)] .39418 .3836 0 0 Mshowa
1 1 0 r
.34127 .43651 m
.34127 .54233 L
.44709 .54233 L
.44709 .43651 L
F
0 0 0 r
[(1)] .39418 .48942 0 0 Mshowa
0 0 1 r
.44709 .11905 m
.44709 .22487 L
.55291 .22487 L
.55291 .11905 L
F
0 0 0 r
[(7)] .5 .17196 0 0 Mshowa
.56 .37 .6 r
.44709 .22487 m
.44709 .33069 L
.55291 .33069 L
.55291 .22487 L
F
0 0 0 r
[(4)] .5 .27778 0 0 Mshowa
0 .79 .34 r
.44709 .33069 m
.44709 .43651 L
.55291 .43651 L
.55291 .33069 L
F
0 0 0 r
[(13)] .5 .3836 0 0 Mshowa
1 1 0 r
.44709 .43651 m
.44709 .54233 L
.55291 .54233 L
.55291 .43651 L
F
0 0 0 r
[(1)] .5 .48942 0 0 Mshowa
.74 .99 .79 r
.55291 .11905 m
.55291 .22487 L
.65873 .22487 L
.65873 .11905 L
F
0 0 0 r
[(8)] .60582 .17196 0 0 Mshowa
.56 .37 .6 r
.55291 .22487 m
.55291 .33069 L
.65873 .33069 L
.65873 .22487 L
F
0 0 0 r
[(4)] .60582 .27778 0 0 Mshowa
1 .5 0 r
.55291 .33069 m
.55291 .43651 L
.65873 .43651 L
.65873 .33069 L
F
0 0 0 r
[(2)] .60582 .3836 0 0 Mshowa
1 1 0 r
.55291 .43651 m
.55291 .54233 L
.65873 .54233 L
.65873 .43651 L
F
0 0 0 r
[(1)] .60582 .48942 0 0 Mshowa
.251 .878 .816 r
.65873 .11905 m
.65873 .22487 L
.76455 .22487 L
.76455 .11905 L
F
0 0 0 r
[(11)] .71164 .17196 0 0 Mshowa
1 1 0 r
.65873 .22487 m
.65873 .33069 L
.76455 .33069 L
.76455 .22487 L
F
0 0 0 r
[(1)] .71164 .27778 0 0 Mshowa
.251 .878 .816 r
.65873 .33069 m
.65873 .43651 L
.76455 .43651 L
.76455 .33069 L
F
0 0 0 r
[(11)] .71164 .3836 0 0 Mshowa
1 1 0 r
.65873 .43651 m
.65873 .54233 L
.76455 .54233 L
.76455 .43651 L
F
0 0 0 r
[(1)] .71164 .48942 0 0 Mshowa
0 .79 .34 r
.76455 .11905 m
.76455 .22487 L
.87037 .22487 L
.87037 .11905 L
F
0 0 0 r
[(13)] .81746 .17196 0 0 Mshowa
.56 .37 .6 r
.76455 .22487 m
.76455 .33069 L
.87037 .33069 L
.87037 .22487 L
F
0 0 0 r
[(4)] .81746 .27778 0 0 Mshowa
0 0 1 r
.76455 .33069 m
.76455 .43651 L
.87037 .43651 L
.87037 .33069 L
F
0 0 0 r
[(7)] .81746 .3836 0 0 Mshowa
1 1 0 r
.76455 .43651 m
.76455 .54233 L
.87037 .54233 L
.87037 .43651 L
F
0 0 0 r
[(1)] .81746 .48942 0 0 Mshowa
0 .392 0 r
.87037 .11905 m
.87037 .22487 L
.97619 .22487 L
.97619 .11905 L
F
0 0 0 r
[(14)] .92328 .17196 0 0 Mshowa
1 1 0 r
.87037 .22487 m
.87037 .33069 L
.97619 .33069 L
.97619 .22487 L
F
0 0 0 r
[(1)] .92328 .27778 0 0 Mshowa
0 .392 0 r
.87037 .33069 m
.87037 .43651 L
.97619 .43651 L
.97619 .33069 L
F
0 0 0 r
[(14)] .92328 .3836 0 0 Mshowa
1 1 0 r
.87037 .43651 m
.87037 .54233 L
.97619 .54233 L
.97619 .43651 L
F
0 0 0 r
[(1)] .92328 .48942 0 0 Mshowa
0 g
.5 Mabswid
[ ] 0 setdash
.12963 .11905 m
.12963 .54233 L
s
.23545 .11905 m
.23545 .54233 L
s
.34127 .11905 m
.34127 .54233 L
s
.44709 .11905 m
.44709 .54233 L
s
.55291 .11905 m
.55291 .54233 L
s
.65873 .11905 m
.65873 .54233 L
s
.76455 .11905 m
.76455 .54233 L
s
.87037 .11905 m
.87037 .54233 L
s
.97619 .11905 m
.97619 .54233 L
s
.12963 .11905 m
.97619 .11905 L
s
.12963 .22487 m
.97619 .22487 L
s
.12963 .33069 m
.97619 .33069 L
s
.12963 .43651 m
.97619 .43651 L
s
.12963 .54233 m
.97619 .54233 L
s
[(1)] .07672 .17196 0 0 Mshowa
[(2)] .07672 .27778 0 0 Mshowa
[(3)] .07672 .3836 0 0 Mshowa
[(4)] .07672 .48942 0 0 Mshowa
[(1)] .18254 .06614 0 0 Mshowa
[(2)] .28836 .06614 0 0 Mshowa
[(4)] .39418 .06614 0 0 Mshowa
[(7)] .5 .06614 0 0 Mshowa
[(8)] .60582 .06614 0 0 Mshowa
[(11)] .71164 .06614 0 0 Mshowa
[(13)] .81746 .06614 0 0 Mshowa
[(14)] .92328 .06614 0 0 Mshowa
[(elements)] .55291 .01323 0 0 Mshowa
[(powers)] .02381 .33069 -1 0 270 Mrotshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[25]:=",
  ImageSize->{288, 160},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000X0P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0008P01?l00`3oo`03o`80
1?l01P3o0?l0o`801?l0103oo`02o`800ol200CoJ`0008L000?o00001@001Ol0003o00D000Oo0?l0
o`3o00D000Co003o0`001?l00?l40003o`0006T0002700Go0`001?l00005o`070?l0o`3o0005o`05
0?l00?l00`000ol0000200CoJ`0008L000Go0000o`030005o`000?l00`002Ol0o`3o0?l0o`030003
o`3o008000Go0000o`040003o`0006`0002800?o10000ol0000200?o00<0ool01?l200?o00<0ool0
0ol200Co0P04of/0002?0003o`0001X000?o0000L@0008d00olL0003o`000740003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240000b00?o6`04oa`00olK0003o`0001/0
0_lI00?o0`03oaD00ol300?o5@03o`@00olC0000<`000ol0000K0003o`0001d000?o00006P000ol0
000J0004o`00oaT000?o00000`000ol0000E0003o`0000D000?o00004`000ol000040003o`000180
000c0003o`0001`000?o00006P04oa`000?o00006@001?l00?lI0003o`0000<000?o00005@000ol0
00050003o`0001<000?o00000P04oa<0000c0003o`0001d000?o00006@000ol0o`0M0003o`0001X0
0_lJ0003o`0000<000?o00005@000ol0000300;o5P000ol000020003o`3o01@0000c0003o`0001X0
00Co003o6`000ol0o`0N0003o`0001P000Co003o6@000ol000030003o`0001D000?o00001@000ol0
000C0003o`00008000?o0?l0500003800_lM00;o7@02oa/01?lK00;o6@02o`@00_lF00;o1003oaD0
0_l500;o50000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@0002D0lol800009@000ooOg`0Kg`03oa4A01`A01ooOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7ko01gB07[ooPon3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oko2788
LPQb2788LPQb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/om6L
dIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAo`P0000U0003omoO01_O03ko4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoagB05coe_kFo]Kne_kF
o]Kne_kFo]Kne_kFo]Kne_kFo]KoLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:Aojc/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/oaeL00?o00001P0002D000?ogml06ml00olA4@0L4@0Oogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0MdP1jooh?oPon3oh?oPon3oh?oPon3oh?oPon3oh?oPon
o`Qb2788LPQb2788LPQb2788LPQb2788LPQb2788L_o/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k?oAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl800009@000ooOg`0Kg`0noa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOlMdP1LomKne_kF
o]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTOn/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[?lMG003o`0000H0000U0003omoO01_O00?o4A4071407omn
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07M80N_on3oh?oPon3oh?oPon3oh?oPon3oh?oPon
3oh?o_l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;ok:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=7o200002D000?ogml06ml0?_lAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo7M80G?oF
o]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY7o
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7E`00ol0000600009@000ooOg`0Kg`03oa4A01`A
01ooOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01gB07[ooPon3oh?oPon3oh?oPon3oh?oPon
3oh?oPon3oko2788LPQb2788LPQb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/om6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAo`P0000U0003omoO01_O03ko4ElA
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoagB
05coe_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]KoLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5b
TG:Aojc/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/oaeL00?o00001P0002D000?ogml06ml00olA
4@0L4@0Oogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0MdP1jooh?oPon3oh?oPon3oh?oPon
3oh?oPon3oh?oPono`Qb2788LPQb2788LPQb2788LPQb2788LPQb2788L_o/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl800009@000ooOg`0Kg`0n
oa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EOlMdP1LomKne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG:ALY5b
TG:ALY5bTOn/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[?lMG003o`0000H0000U0003omoO01_O
00?o4A4071407omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07M80N_on3oh?oPon3oh?oPon
3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;ok:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=7o200002D000?ogml0
6ml0?_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUGo7M80G?oFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5b
TG:ALY5bTG:ALY7o[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7E`00ol0000600005003o`h0
00?ogml02]l3o`kO00?o4A402Q44o`hA00koOX1nP7j0OX1nP7j0OP?o00inP7j0OX1nP7j0OX1no`gB
00?od]803M803_on3oh?oPon3oh?oPon0_l06@on3oh?oPon3oh?oPono`Qb2788LPQb27800ol00g88
LP03o`0ELPQb2788LPQb27;ok:c/[>b/k:c/00?o00?/[>`00ol05Nb/k:c/[>b/k:c/om6LdIcAW=6L
d@03o`04dIcAW0?o00^LdIcAW=6LdIcAo`0800005@000ol0000=0003omoO00_O00?ogml03Ml0?_lA
Ga5O4ElAGa5O4ElAoa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF;oHUEREF9EHUEREF9EHUGo
3M800ooBdP0=dP1LomKne_kFo]Kne_kFo_one_oFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bog:ALY5b
og:ALY5bTG:ALY5bTOn/k:c/[>b/k:c/onb/k:c/[>cok:c/[>b/k:c/[?l:G003oeaL00AL00?oG5`0
2E`00ol0000600005@000ol0000=0003omoO00_O00?ogml03Ml00olA4@0<4@03oa4A00dA00goOX1n
P7j0OX1nP7j000Co00inP7j0OX1nP7j0OX1no`kB00?od]803=80Joon3oh?oPon3oh?oPoo3okooPon
3oh?oPon3oh?o_l8LPQb2788LPQb2?l8LPQb2?l8LPQb2788LPQb27;ok:c/[>b/k:c/[?n/k:c/[>b/
ojc/[>b/k:c/[>codIcAW=6LdIcAW?nLdIcA00Co00^LdIcAW=6LdIcAo`0800005@000ol0000=0003
omoO00_O00?ogml03Ml0?_lAGa5O4ElAGa5O4ElAGa7o4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUER
of;oHUEREF9EHUEREF9EHUGo3]800ooBdP0<dP0>omKne_kFo]Kne_kFo]H2o`0no]Kne_kFo]Kne_kF
o]KoLY5bTG:ALY5bTG;oLY5bTG;oLY5bTG:ALY5bTG:Aojc/[>b/k:c/[>cok:c/[>`2o`0<[>b/k:c/
[>b/k:co2U`00omLG002G003oeco00]L00?o00001P0001D000?o00003@000ooOg`0;g`03omoO00gO
00?o4A402Q401?lA4Ol>4@0Oogj0OX1nP7j0OX1nP?n0oh1nP7j0OX1nP7j0OX1no`0?dP03om;B00_B
07[ooPon3oh?oPon3oh?o`onooh?oPon3oh?oPon3oko2788LPQb2788LPSo2788LPSo2788LPQb2788
LPQbonb/k:c/[>b/k:co[>b/k:c/[?n/k:c/[>b/k:c/om6LdIcAW=6LdIcoW=6LdOoAom6LdIcAW=6L
dIcAo`P0000D00;o3`000ooOg`0:g`;o3ml03_lAGa5O4ElAGa5O4ElA0_l07ElAGa5O4ElAGa5O4ElA
GomEHUEREF9EHUEREF9E00;o00mREF9EHUEREF9EHUEREOl03=84o`gB00koe_kFo]Kne_kFo]KneP;o
01Wne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:A00;o00AbTG:A0_l05W:ALY5bTG:ALY5bTOn/k:c/[>b/
k:`2o`04k:c/[0?o00b/k:c/[>b/k:c/[?l9G0;o1E`2o`]L00?o00001P0002D000?ogml06ml00olA
4@0L4@0Oogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0MdP1jooh?oPon3oh?oPon3oh?oPon
3oh?oPon3oh?oPono`Qb2788LPQb2788LPQb2788LPQb2788LPQb2788L_o/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl800009@000ooOg`0Kg`0n
oa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUER
EOlMdP1LomKne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5bTG:ALY5bTG:ALY5b
TG:ALY5bTOn/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[?lMG003o`0000H0000U0003omoO01_O
00?o4A4071407omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07M80N_on3oh?oPon3oh?oPon
3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;ok:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=7o200002D000?ogml0
6ml0?_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUGo7M80G?oFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5bTG:ALY5bTG:ALY5b
TG:ALY5bTG:ALY7o[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7E`00ol0000600009@000ooO
g`0Kg`03oa4A01`A01ooOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01gB07[ooPon3oh?oPon
3oh?oPon3oh?oPon3oh?oPon3oko2788LPQb2788LPQb2788LPQb2788LPQb2788LPQbonb/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/om6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAo`P0000U0003
omoO01_O03ko4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5OoeEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EoagB05coe_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]KoLY5bTG:ALY5bTG:ALY5b
TG:ALY5bTG:ALY5bTG:Aojc/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/oaeL00?o00001P0002D0
00?ogml06ml00olA4@0L4@0Oogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0MdP1jooh?oPon
3oh?oPon3oh?oPon3oh?oPon3oh?oPono`Qb2788LPQb2788LPQb2788LPQb2788LPQb2788L_o/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k?oAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl80000
9@000ooOg`0Kg`0noa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGomEHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREOlMdP1LomKne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFog:ALY5bTG:ALY5b
TG:ALY5bTG:ALY5bTG:ALY5bTOn/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[?lMG003o`0000H0
000U0003omoO01_O00?o4A4071407omnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07M80N_on
3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oh?o_l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;o
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>codIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=7o
200002D000?ogml06ml0?_lAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooEF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUGo7M80G?oFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_mbTG:ALY5b
TG:ALY5bTG:ALY5bTG:ALY5bTG:ALY7o[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7E`00ol0
000600009@000ooOg`0Kg`03oa4A01`A01ooOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01gB
07[ooPon3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oko2788LPQb2788LPQb2788LPQb2788LPQb2788
LPQbonb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/om6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6L
dIcAo`P0000U0??o200002D000?ogml06ml08?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko
7Ml0?OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0O_l07]l07on0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l07Ml00ol0000600009@000ooO
g`0Kg`0Pof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOlMg`0moeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0Ng`0Oof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUERo`0Mg`03o`0000H0000U0003omoO01_O023oP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1noagO03goOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7ko01kO01ooP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o01gO
00?o00001P0002D000?ogml06ml08?mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo7Ml0?OmE
HUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl0
7]l07omREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EH_l07Ml00ol0000600009@000ooOg`0Kg`0P
oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_lMg`0mogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0Ng`0Ooh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0o`0Mg`03o`0000H0000U0003omoO01_O023oHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EoagO03goEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUGo01kO01ooHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o01gO00?o0000
1P0002D000?ogml06ml08?n0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko7Ml0?OmnP7j0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07]l07on0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP?l07Ml00ol0000600009@000ooOg`0Kg`0Pof9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREOlMg`0moeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
oeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0Ng`0Oof9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUERo`0Mg`03o`0000H0000U0003omoO01_O023oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
OX1noagO03goOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nP7ko01kO01ooP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o01gO00?o00001P0002D0
00?ogml06ml08?mREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGo7Ml0?OmEHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREOmEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOl07]l07omREF9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EH_l07Ml00ol0000600009@000ooOg`0Kg`0Poh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0O_lMg`0mogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0Ng`0Ooh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
o`0Mg`03o`0000H0000U0003omoO01_O023oHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoagO
03goEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9E
HUGo01kO01ooHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o01gO00?o00001P0000P01?l800Co
3@000ooOg`0:g`?o3]l03_n0OX1nP7j0OX1nP7j00ol03h1nP7j0OX1nP7j0OX1no`0<g`?o3]l03_mn
P7j0OX1nP7j0OX1n0ol06gj0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OP03o`0>OX1nP7j0OX1nP7j0
O_l=g`?o3]l03_n0OX1nP7j0OX1nP7j00ol03X1nP7j0OX1nP7j0OX3o3=l3o`kO00?o00001P0000/0
00?o00001`000ol0000=0003omoO00_O00?ogml03Ml08?mREF9EHUEREF9EHUEREOmEHUEREF9EHUER
EF9EHUGo3Ml00ooOg`0=g`0moeEREF9EHUEREF9EHUERof9EHUEREF9EHUEREF9EoeEREF9EHUEREF9E
HUERof9EHUEREF9EHUEREF9Eo`0>g`03omoO00gO01ooHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUER
EF;o00gO00?ogml03Ml00ol0000600002004o`X000?o000030000ooOg`0;g`03omoO00gO00goP7j0
OX1nP7j0OX1n00Co00n0OX1nP7j0OX1nP7j0O_l03Ml00ooOg`0=g`0=ogj0OX1nP7j0OX1nP004o`0J
OX1nP7j0OX1nP7j0O_mnP7j0OX1nP7j0OX04o`0>OX1nP7j0OX1nP7j0O_l>g`03omoO00gO00goP7j0
OX1nP7j0OX1n00Co00j0OX1nP7j0OX1nP7j0o`gO00?ogml03Ml00ol00006000020000ol0000<0003
o`0000/000?ogml02ml00ooOg`0=g`0Pof9EHUEREF9EHUEREOmEoeEREF9EHUEREF9EHUEREOl=g`03
omoO00gO03goEF9EHUEREF9EHUERof;oHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUERof;oHUEREF9E
HUEREF9EHUGo00kO00?ogml03Ml07omREF9EHUEREF9EHUGoEOmEHUEREF9EHUEREF9EH_l03Ml00ooO
g`0=g`03o`0000H0000800Co20001?l00?l=0003omoO00_O00?ogml03Ml08?n0OX1nP7j0OX1nP7ko
O_mnP7j0OX1nP7j0OX1nP7ko3Ml00ooOg`0=g`0mogj0OX1nP7j0OX1nP?n0oh1nP7j0OX1nP7j0OX1n
ogj0OX1nP7j0OX1nP?n0oh1nP7j0OX1nP7j0OX1no`0>g`03omoO00gO01ooP7j0OX1nP7j0OX1nogko
OX1nP7j0OX1nP7j0OX3o00gO00?ogml03Ml00ol0000600005@02o`h000?ogml02]l2o`oO00koHUER
EF9EHUEREF9EHP;o011EHUEREF9EHUEREF9EHUGo3=l2o`oO00koEF9EHUEREF9EHUERE@;o01aREF9E
HUEREF9EHUEREOmEHUEREF9EHUEREF9E0_l03f9EHUEREF9EHUEREF9Eo`0=g`;o3ml03_mREF9EHUER
EF9EHUER0_l03eEREF9EHUEREF9EHUERo`0<g`;o3ml00ol0000600002004oaT000?ogml06ml08?n0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko7Ml0?OmnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0O_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_l07]l07on0OX1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP?l07Ml00ol0000600002@000ol0000I0003omoO01_O023oHUEREF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EoagO03goEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EHUGo01kO01ooHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o01gO
00?o00001P0000T000?o00006@000ooOg`0Kg`0Poh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
O_lMg`0mogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1no`0Ng`0Ooh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0Mg`03o`0000H0000900;o
6P000ooOg`0Kg`0Pof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOlMg`0moeEREF9EHUEREF9E
HUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0Ng`0Oof9EHUER
EF9EHUEREF9EHUEREF9EHUEREF9EHUERo`0Mg`03o`0000H0000800;o00<0ool060000ooOg`0Kg`0P
oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_lMg`0mogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1n
P7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0Ng`0Ooh1nP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0o`0Mg`03o`0000H0000U0003omoO01_O023oHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9EoagO03goEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGoEF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EHUGo01kO01ooHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF;o01gO00?o0000
1P0000T01?lH0003omoO01_O023oP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1noagO03goOX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7koOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko01kO
01ooP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX3o01gO00?o00001P0000P000?o00006P000ooO
g`0Kg`0Pof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOlMg`0moeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9Eo`0Ng`0Oof9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUERo`0Mg`03o`0000H0000800Go60000ooOg`0Kg`0Poh1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0OX1nP7j0O_lMg`0mogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0Ng`0Ooh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0
o`0Mg`03o`0000H000080005o`000?l060000ooOg`0Kg`0Pof9EHUEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREOlMg`0moeEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EoeEREF9EHUEREF9EHUEREF9E
HUEREF9EHUEREF9Eo`0Ng`0Oof9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUERo`0Mg`03o`0000H0
000900?o6@000ooOg`0Kg`0Poh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_lMg`0mogj0OX1n
P7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1no`0Ng`0O
oh1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0o`0Mg`03o`0000H0000U0??o200000P000Co003o
6@000ooOg`0Kg`1Lo`on3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oh?o_mnP7j0OX1nP7j0OX1nP7j0
OX1nP7j0OX1nP7j0O_n/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[?lM4@0Po`Qb2788LPQb2788
LPQb2788LPQb2788LPQb2788L_lMdP0Oom6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAo`080000
2004oaT000?ogml06ml0VOone_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]KoEF9EHUEREF9EHUER
EF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>coGa5O4ElAGa5O4ElA
Ga5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:Ao`0MdP03oeaL01]L
00?o00001P0000P01?lI0003omoO01_O05co3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oh?oPonogj0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nojc/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/oadA
023o2788LPQb2788LPQb2788LPQb2788LPQb2788LPQboagB01oodIcAW=6LdIcAW=6LdIcAW=6LdIcA
W=6LdIcAW=7o00P000080004o`00oaT000?ogml06ml0VOone_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kn
e_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:A
LY5bTG:Ao`0MdP03oeaL01]L00?o00001P0000L00_l200;o60000ooOg`0Kg`1Lo`on3oh?oPon3oh?
oPon3oh?oPon3oh?oPon3oh?o_mnP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_n/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[?lM4@0Po`Qb2788LPQb2788LPQb2788LPQb2788LPQb2788L_lMdP0O
om6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAo`0800009@000ooOg`0Kg`2IookFo]Kne_kFo]Kn
e_kFo]Kne_kFo]Kne_kFo]Kne_mEHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUEREOo/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k?mO4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGombTG:ALY5bTG:A
LY5bTG:ALY5bTG:ALY5bTG:ALY7o01gB00?oG5`06e`00ol0000600002@03oaT000?ogml06ml0G?l?
oPon3oh?oPon3oh?oPon3oh?oPon3oh?oPon3okoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788
LPQb27;o7M807ooAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl0200000P000Go0000o`0H0003
omoO01_O09Woo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFoeEREF9EHUEREF9EHUEREF9EHUER
EF9EHUEREF9Eonb/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/oelAGa5O4ElAGa5O4ElAGa5O4ElA
Ga5O4ElAGa5Oog:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTOl07M800omLG00KG003o`0000H0
00080005o`000?l060000ooOg`0Kg`1Lo`on3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oh?o_mnP7j0
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0O_n/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[?lM4@0P
o`Qb2788LPQb2788LPQb2788LPQb2788LPQb2788L_lMdP0Oom6LdIcAW=6LdIcAW=6LdIcAW=6LdIcA
W=6LdIcAo`08000020001Ol0003o01P000?ogml06ml0VOone_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kn
e_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:A
LY5bTG:Ao`0MdP03oeaL01]L00?o00001P0000L01OlI0003omoO01_O05co3oh?oPon3oh?oPon3oh?
oPon3oh?oPon3oh?oPonogj0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nojc/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/oadA023o2788LPQb2788LPQb2788LPQb2788LPQb2788LPQboagB01oodIcA
W=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=7o00P000080003o`0001X000?ogml06ml0VOone_kFo]Kn
e_kFo]Kne_kFo]Kne_kFo]Kne_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:A
LY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:Ao`0MdP03oeaL01]L00?o00001P0000P01?l800?o3P000ooO
g`0:g`?o3]l03_l?oPon3oh?oPon3oh?0_l07Oh?oPon3oh?oPon3oh?o_mnP7j0OX1nP7j0OX1n00?o
01MnP7j0OX1nP7j0OX1nojc/[>b/k:c/[003o`03[>b/00?o00b/k:c/[>b/k:c/[?l<4@Co3A402ol8
LPQb2788LPQb00?o00=b27800ol03788LPQb2788LPQbo`gB00?od]803M802_oAW=6LdIcAW=43o`04
dIcAW0?o00^LdIcAW=6LdIcAo`08000020001Ol0003o00X000?o00002`000ooOg`0;g`03omoO00gO
09Woo]Kne_kFo]Kne_kFomKnookFo]Kne_kFo]Kne_kFoeEREF9EHUEREF9EHUERof9EHUEREF9EHUER
EF9Eonb/k:c/[>b/k:co[>b/k:c/[?n/k:c/[>b/k:c/oelAGa5O4ElAGa5O4EooGa5O4ElAGa5O4ElA
Ga5Oog:ALY5bTG:ALY5bog:ALY5bog:ALY5bTG:ALY5bTOl03M800ooBdP0=dP03oeaL00QL00?oG5`0
15`00omLG009G003o`0000H000080005o`000?l02P000ol0000;0003omoO00_O00?ogml03Ml0;?l?
oPon3oh?oPon3okooPoo3oh?oPon3oh?oPon3okoOX1nP7j0OX1nP7j01?l0;7j0OX1nP7j0OX1nP7ko
[>b/k:c/[>b/k?o/[>b/k:c/onb/k:c/[>b/k:co3Q400olA4@0<4@0Po`Qb2788LPQb2788o`Qb2788
o`Qb2788LPQb2788L_l>dP03om;B00cB013odIcAW=6LdIcAW?nLdIcA1?l02icAW=6LdIcAW=7o00P0
00080005o`000?l02002o`h000?ogml02ml00ooOg`0=g`0>ookFo]Kne_kFo]Kne_h2o`0ne_kFo]Kn
e_kFo]Kne_kFoeEREF9EHUEREF9EH_mRof9EHUEREF9EHUEREF9Eonb/k:c/[>b/k:co[>b/k:`2o`19
k:c/[>b/k:c/[>coGa5O4ElAGa5O4ElAGa5OoelAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG;oLY5bTG;o
LY5bTG:ALY5bTG:Ao`0>dP03om;B00cB00?oG5`025`00omLG002G003oeco00]L00?o00001P0000L0
1Ol;0003o`0000/000?ogml02ml00ooOg`0=g`1Lo`on3oh?oPon3oh?o_on3ol?oPon3oh?oPon3oh?
o_mnP7j0OX1nP7j0OX3oP?n0OX1nP7j0OX1nP7j0O_n/k:c/[>b/k:c/onb/k:c/[>cok:c/[>b/k:c/
[?l<4@04oa4Ao`dA023o2788LPQb2788LPSo2788LPSo2788LPQb2788LPQbo`oB00?od]802m807ooA
W=6LdIcAW=6LoicAW=7odOoAW=6LdIcAW=6LdOl0200001@00ol>0003omoO00[O0_l?g`0>ookFo]Kn
e_kFo]Kne_h2o`0Me_kFo]Kne_kFo]Kne_kFoeEREF9EHUEREF9EHUD00_l0669EHUEREF9EHUEREF9E
onb/k:c/[>b/k0;o00B/k:c/0ol06Nb/k:c/[>b/k:c/oelAGa5O4ElAGa5O4El00_l06A5O4ElAGa5O
4ElAGa5Oog:ALY5bTG:ALY400_l017:ALY42o`0=LY5bTG:ALY5bTG:Ao`0<dPCo3M800omLG007G0;o
1E`2o`]L00?o00001P0002D000?ogml06ml0G?l?oPon3oh?oPon3oh?oPon3oh?oPon3oh?oPon3oko
OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co
7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;o7M807ooAW=6LdIcAW=6LdIcAW=6LdIcA
W=6LdIcAW=6LdOl0200002D000?ogml06ml0VOone_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Ko
EF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>co
Ga5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:A
o`0MdP03oeaL01]L00?o00001P0002D000?ogml06ml0G?l?oPon3oh?oPon3oh?oPon3oh?oPon3oh?
oPon3okoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:co7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;o7M807ooAW=6LdIcAW=6LdIcA
W=6LdIcAW=6LdIcAW=6LdOl0200002D000?ogml06ml0VOone_kFo]Kne_kFo]Kne_kFo]Kne_kFo]Kn
e_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:A
LY5bTG:Ao`0MdP03oeaL01]L00?o00001P0002D000?ogml06ml0G?l?oPon3oh?oPon3oh?oPon3oh?
oPon3oh?oPon3okoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko[>b/k:c/[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:co7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;o7M807ooAW=6LdIcA
W=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl0200002D000?ogml06ml0VOone_kFo]Kne_kFo]Kne_kFo]Kn
e_kFo]Kne_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:ALY5bTG:A
LY5bTG:ALY5bTG:Ao`0MdP03oeaL01]L00?o00001P0002D000?ogml06ml0G?l?oPon3oh?oPon3oh?
oPon3oh?oPon3oh?oPon3okoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko[>b/k:c/[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:co7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;o7M807ooA
W=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl0200002D000?ogml06ml0VOone_kFo]Kne_kFo]Kn
e_kFo]Kne_kFo]Kne_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/k:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:ALY5bTG:A
LY5bTG:ALY5bTG:ALY5bTG:Ao`0MdP03oeaL01]L00?o00001P0002D000?ogml06ml0G?l?oPon3oh?
oPon3oh?oPon3oh?oPon3oh?oPon3okoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko[>b/k:c/
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788LPQb27;o
7M807ooAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl0200002D000?ogml06ml0VOone_kFo]Kn
e_kFo]Kne_kFo]Kne_kFo]Kne_kFo]KoEF9EHUEREF9EHUEREF9EHUEREF9EHUEREF9EHUGok:c/[>b/
k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>coGa5O4ElAGa5O4ElAGa5O4ElAGa5O4ElAGa5O4EooLY5bTG:A
LY5bTG:ALY5bTG:ALY5bTG:ALY5bTG:Ao`0MdP03oeaL01]L00?o00001P0002D000?ogml06ml0G?l?
oPon3oh?oPon3oh?oPon3oh?oPon3oh?oPon3okoOX1nP7j0OX1nP7j0OX1nP7j0OX1nP7j0OX1nP7ko
[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:co7A408?l8LPQb2788LPQb2788LPQb2788LPQb2788
LPQb27;o7M807ooAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdIcAW=6LdOl0200002D0lol800009@000ooO
g`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O
00?o00001P0002D000?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ooOg`0Kg`03omoO01cO
00?ogml06ml00ooOg`0Kg`03o`0000H0000U0003omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O
00?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ol0000600009@000ooOg`0Kg`03omoO01cO
00?ogml06ml00ooOg`0Kg`03omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?o00001P0002D0
00?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ooOg`0Kg`03omoO01cO00?ogml06ml00ooO
g`0Kg`03o`0000H0000U0003omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?ogml06ml00ooO
g`0Lg`03omoO01_O00?ogml06ml00ol0000600009@000ooOg`0Kg`03omoO01cO00?ogml06ml00ooO
g`0Kg`03omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?o00001P0002D000?ogml06ml00ooO
g`0Lg`03omoO01_O00?ogml06ml00ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03o`0000H0
000U0003omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?ogml06ml00ooOg`0Lg`03omoO01_O
00?ogml06ml00ol0000600009@000ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03omoO01_O
00?ogml07=l00ooOg`0Kg`03omoO01_O00?o00001P0002D000?ogml06ml00ooOg`0Lg`03omoO01_O
00?ogml06ml00ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03o`0000H0000U0003omoO01_O
00?ogml07=l00ooOg`0Kg`03omoO01_O00?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ol0
000600009@000ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03omoO01_O00?ogml07=l00ooO
g`0Kg`03omoO01_O00?o00001P0001D00ol=0003omoO00[O0ol>g`03omoO00[O0ol?g`03omoO00[O
0ol>g`03omoO00[O0ol>g`03omoO00[O0ol>g`03omoO00_O0ol>g`03omoO00[O0ol>g`03omoO00[O
0ol>g`03o`0000H0000F0003o`0000`000?ogml02ml00ooOg`0=g`03omoO00_O00?ogml03]l00ooO
g`0;g`03omoO00gO00?ogml02ml00ooOg`0=g`03omoO00_O00?ogml03Ml00ooOg`0<g`03omoO00gO
00?ogml02ml00ooOg`0=g`03omoO00_O00?ogml03Ml00ol0000600005004o`d000?ogml02ml00ooO
g`0=g`03omoO00_O00?ogml03]l00ooOg`0;g`03omoO00gO00?ogml02ml00ooOg`0=g`03omoO00_O
00?ogml03Ml00ooOg`0<g`03omoO00gO00?ogml02ml00ooOg`0=g`03omoO00_O00?ogml03Ml00ol0
0006000050000ol0o`0>0003omoO00_O00?ogml03Ml00ooOg`0;g`03omoO00kO00?ogml02ml00ooO
g`0=g`03omoO00_O00?ogml03Ml00ooOg`0;g`03omoO00gO00?ogml03=l00ooOg`0=g`03omoO00_O
00?ogml03Ml00ooOg`0;g`03omoO00gO00?o00001P0001@000?o0?l03P000ooOg`0;g`03omoO00gO
00?ogml02ml00ooOg`0>g`03omoO00_O00?ogml03Ml00ooOg`0;g`03omoO00gO00?ogml02ml00ooO
g`0=g`03omoO00cO00?ogml03Ml00ooOg`0;g`03omoO00gO00?ogml02ml00ooOg`0=g`03o`0000H0
000E00;o3P000ooOg`0:g`;o3ml00ooOg`0:g`;o4=l00ooOg`0:g`;o3ml00ooOg`0:g`;o3ml00ooO
g`0:g`;o3ml00ooOg`0;g`;o3ml00ooOg`0:g`;o3ml00ooOg`0:g`;o3ml00ol0000600009@000ooO
g`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O
00?o00001P0002D000?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ooOg`0Kg`03omoO01cO
00?ogml06ml00ooOg`0Kg`03o`0000H0000U0003omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O
00?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ol0000600009@000ooOg`0Kg`03omoO01cO
00?ogml06ml00ooOg`0Kg`03omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?o00001P0002D0
00?ogml06ml00ooOg`0Lg`03omoO01_O00?ogml06ml00ooOg`0Kg`03omoO01cO00?ogml06ml00ooO
g`0Kg`03o`0000H0000U0003omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?ogml06ml00ooO
g`0Lg`03omoO01_O00?ogml06ml00ol0000600009@000ooOg`0Kg`03omoO01cO00?ogml06ml00ooO
g`0Kg`03omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?o00001P0002D000?ogml06ml00ooO
g`0Lg`03omoO01_O00?ogml06ml00ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03o`0000H0
000U0003omoO01_O00?ogml07=l00ooOg`0Kg`03omoO01_O00?ogml06ml00ooOg`0Lg`03omoO01_O
00?ogml06ml00ol0000600009@000ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03omoO01_O
00?ogml07=l00ooOg`0Kg`03omoO01_O00?o00001P0002D000?ogml06ml00ooOg`0Lg`03omoO01_O
00?ogml06ml00ooOg`0Kg`03omoO01cO00?ogml06ml00ooOg`0Kg`03o`0000H0000U0??o20000?l0
8@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {159, 0}} -> {-0.238293, -0.125026, 0.0330195, 
  0.0330195}},
  CellTags->"OtherProps"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"OtherProps"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"Working",
WindowSize->{500, 400},
WindowMargins->{{5, Automatic}, {Automatic, 1}},
ShowCellTags->True,
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "OtherProps"->{
    Cell[2564, 83, 197, 8, 107, "Section",
      Evaluatable->False,
      CellTags->"OtherProps"],
    Cell[2764, 93, 74, 1, 68, "Subsection",
      CellTags->"OtherProps"],
    Cell[2841, 96, 186, 5, 58, "Text",
      CellTags->"OtherProps"],
    Cell[3030, 103, 3087, 95, 83, "DefinitionBox",
      CellTags->{"OtherProps", "i:1"}],
    Cell[6120, 200, 72, 1, 26, "Caption",
      CellTags->"OtherProps"],
    Cell[6195, 203, 260, 7, 54, "MathCaption",
      CellTags->"OtherProps"],
    Cell[6480, 214, 109, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[6592, 219, 95, 3, 28, "Output",
      CellTags->"OtherProps"],
    Cell[6702, 225, 5752, 163, 152, "DefinitionBox3Col",
      CellTags->{"OtherProps", "i:2"}],
    Cell[12457, 390, 84, 1, 26, "Caption",
      CellTags->"OtherProps"],
    Cell[12544, 393, 168, 3, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[12737, 400, 144, 4, 39, "Input",
      CellTags->"OtherProps"],
    Cell[12884, 406, 188, 4, 39, "Message",
      CellTags->"OtherProps"],
    Cell[13075, 412, 86, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[13176, 418, 155, 5, 41, "MathCaption",
      CellTags->"OtherProps"],
    Cell[13356, 427, 150, 4, 55, "Input",
      CellTags->"OtherProps"],
    Cell[13509, 433, 101, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[13625, 439, 737, 24, 77, "MathCaption",
      CellTags->{"OtherProps", "i:3"}],
    Cell[14387, 467, 110, 3, 45, "Input",
      CellTags->"OtherProps"],
    Cell[14500, 472, 96, 3, 29, "Output",
      CellTags->"OtherProps"],
    Cell[14611, 478, 216, 6, 55, "MathCaption",
      CellTags->"OtherProps"],
    Cell[14852, 488, 351, 6, 71, "Input",
      CellTags->"OtherProps"],
    Cell[15206, 496, 124, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[15345, 502, 9051, 275, 180, "DefinitionBox",
      CellTags->{"OtherProps", "i:4"}],
    Cell[24399, 779, 117, 4, 26, "Caption",
      CellTags->"OtherProps"],
    Cell[24519, 785, 286, 8, 69, "MathCaption",
      CellTags->"OtherProps"],
    Cell[24830, 797, 134, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[24967, 802, 25438, 510, 296, 4616, 247, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherProps"],
    Cell[50408, 1314, 116, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[50539, 1320, 356, 11, 70, "MathCaption",
      CellTags->"OtherProps"],
    Cell[50920, 1335, 115, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[51038, 1340, 90, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[51143, 1346, 182, 7, 41, "MathCaption",
      CellTags->"OtherProps"],
    Cell[51350, 1357, 107, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[51460, 1362, 100, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[51575, 1368, 178, 6, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[51778, 1378, 215, 5, 71, "Input",
      CellTags->"OtherProps"],
    Cell[51996, 1385, 10707, 387, 186, 4221, 301, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherProps"],
    Cell[62718, 1775, 161, 4, 58, "Text",
      CellTags->"OtherProps"],
    Cell[62882, 1781, 10648, 314, 178, "DefinitionBox",
      CellTags->{"OtherProps", "i:5"}],
    Cell[73533, 2097, 80, 1, 26, "Caption",
      CellTags->"OtherProps"],
    Cell[73616, 2100, 230, 7, 54, "MathCaption",
      CellTags->{"OtherProps", "AbelianQex"}],
    Cell[73871, 2111, 149, 3, 39, "Input",
      CellTags->{"OtherProps", "AbelianQex"}],
    Cell[74023, 2116, 239, 4, 52, "Print",
      CellTags->"OtherProps"],
    Cell[74265, 2122, 41057, 924, 296, 8475, 516, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherProps"],
    Cell[115325, 3048, 90, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[115430, 3054, 89, 1, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[115544, 3059, 115, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[115662, 3064, 334, 6, 86, "Output",
      CellTags->"OtherProps"],
    Cell[116011, 3073, 210, 6, 54, "MathCaption",
      CellTags->"OtherProps"],
    Cell[116246, 3083, 135, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[116384, 3088, 215, 4, 52, "Print",
      CellTags->"OtherProps"],
    Cell[116602, 3094, 26995, 676, 296, 6601, 418, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherProps"],
    Cell[143600, 3772, 101, 3, 28, "Output",
      CellTags->"OtherProps"],
    Cell[143716, 3778, 412, 14, 58, "MathCaption",
      CellTags->"OtherProps"],
    Cell[144153, 3796, 124, 3, 43, "Input",
      CellTags->"OtherProps"],
    Cell[144280, 3801, 88, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[144383, 3807, 1098, 41, 94, "Text",
      CellTags->{"OtherProps", "i:6"}],
    Cell[145484, 3850, 6131, 186, 122, "DefinitionBox",
      CellTags->{"OtherProps", "i:7"}],
    Cell[151618, 4038, 83, 1, 26, "Caption",
      CellTags->"OtherProps"],
    Cell[151704, 4041, 172, 6, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[151901, 4051, 113, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[152017, 4056, 96, 3, 28, "Output",
      CellTags->"OtherProps"],
    Cell[152128, 4062, 212, 8, 41, "MathCaption",
      CellTags->"OtherProps"],
    Cell[152365, 4074, 120, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[152488, 4079, 139, 3, 28, "Output",
      CellTags->"OtherProps"],
    Cell[152642, 4085, 259, 8, 56, "MathCaption",
      CellTags->"OtherProps"],
    Cell[152926, 4097, 125, 3, 39, "Input",
      CellTags->"OtherProps"],
    Cell[153054, 4102, 113, 3, 26, "Output",
      CellTags->"OtherProps"],
    Cell[153182, 4108, 1442, 60, 98, "Text",
      CellTags->{"OtherProps", "i:8"}],
    Cell[154627, 4170, 8374, 259, 176, "DefinitionBox",
      CellTags->{"OtherProps", "i:9"}],
    Cell[163004, 4431, 78, 1, 27, "Caption",
      CellTags->"OtherProps"],
    Cell[163085, 4434, 199, 6, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[163309, 4444, 116, 3, 38, "Input",
      CellTags->"OtherProps"],
    Cell[163428, 4449, 86, 3, 32, "Output",
      CellTags->"OtherProps"],
    Cell[163529, 4455, 348, 14, 56, "MathCaption",
      CellTags->"OtherProps"],
    Cell[163902, 4473, 133, 3, 38, "Input",
      CellTags->"OtherProps"],
    Cell[164038, 4478, 126, 3, 34, "Output",
      CellTags->"OtherProps"],
    Cell[164179, 4484, 206, 8, 41, "MathCaption",
      CellTags->"OtherProps"],
    Cell[164410, 4496, 127, 3, 38, "Input",
      CellTags->"OtherProps"],
    Cell[164540, 4501, 113, 3, 34, "Output",
      CellTags->"OtherProps"],
    Cell[164668, 4507, 100, 1, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[164793, 4512, 110, 3, 38, "Input",
      CellTags->"OtherProps"],
    Cell[164906, 4517, 90, 3, 32, "Output",
      CellTags->"OtherProps"],
    Cell[165011, 4523, 4384, 126, 98, "DefinitionBox",
      CellTags->{"OtherProps", "i:10"}],
    Cell[169398, 4651, 76, 1, 27, "Caption",
      CellTags->"OtherProps"],
    Cell[169477, 4654, 186, 6, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[169688, 4664, 125, 3, 38, "Input",
      CellTags->"OtherProps"],
    Cell[169816, 4669, 47549, 942, 306, 8286, 451, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherProps"],
    Cell[217368, 5613, 90, 3, 32, "Output",
      CellTags->"OtherProps"],
    Cell[217473, 5619, 190, 6, 40, "MathCaption",
      CellTags->"OtherProps"],
    Cell[217688, 5629, 124, 3, 38, "Input",
      CellTags->"OtherProps"],
    Cell[217815, 5634, 104, 3, 32, "Output",
      CellTags->"OtherProps"],
    Cell[217934, 5640, 191, 5, 55, "MathCaption",
      CellTags->"OtherProps"],
    Cell[218150, 5649, 96, 2, 40, "Input",
      CellTags->"OtherProps"],
    Cell[218249, 5653, 115, 3, 28, "Output",
      CellTags->"OtherProps"],
    Cell[218379, 5659, 2947, 90, 85, "DefinitionBox",
      CellTags->{"OtherProps", "i:11"}],
    Cell[221329, 5751, 69, 1, 26, "Caption",
      CellTags->"OtherProps"],
    Cell[221401, 5754, 219, 7, 55, "MathCaption",
      CellTags->"OtherProps"],
    Cell[221645, 5765, 269, 6, 59, "Input",
      CellTags->"OtherProps"],
    Cell[221917, 5773, 519, 18, 165, "Output",
      CellTags->"OtherProps"],
    Cell[222451, 5794, 167, 6, 28, "MathCaption",
      CellTags->"OtherProps"],
    Cell[222643, 5804, 131, 3, 27, "Input",
      CellTags->"OtherProps"],
    Cell[222777, 5809, 33083, 701, 168, 5227, 351, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherProps"],
    Cell[255863, 6512, 86, 3, 26, "Output",
      CellTags->"OtherProps"]},
  "i:1"->{
    Cell[3030, 103, 3087, 95, 83, "DefinitionBox",
      CellTags->{"OtherProps", "i:1"}]},
  "i:2"->{
    Cell[6702, 225, 5752, 163, 152, "DefinitionBox3Col",
      CellTags->{"OtherProps", "i:2"}]},
  "i:3"->{
    Cell[13625, 439, 737, 24, 77, "MathCaption",
      CellTags->{"OtherProps", "i:3"}]},
  "i:4"->{
    Cell[15345, 502, 9051, 275, 180, "DefinitionBox",
      CellTags->{"OtherProps", "i:4"}]},
  "i:5"->{
    Cell[62882, 1781, 10648, 314, 178, "DefinitionBox",
      CellTags->{"OtherProps", "i:5"}]},
  "AbelianQex"->{
    Cell[73616, 2100, 230, 7, 54, "MathCaption",
      CellTags->{"OtherProps", "AbelianQex"}],
    Cell[73871, 2111, 149, 3, 39, "Input",
      CellTags->{"OtherProps", "AbelianQex"}]},
  "i:6"->{
    Cell[144383, 3807, 1098, 41, 94, "Text",
      CellTags->{"OtherProps", "i:6"}]},
  "i:7"->{
    Cell[145484, 3850, 6131, 186, 122, "DefinitionBox",
      CellTags->{"OtherProps", "i:7"}]},
  "i:8"->{
    Cell[153182, 4108, 1442, 60, 98, "Text",
      CellTags->{"OtherProps", "i:8"}]},
  "i:9"->{
    Cell[154627, 4170, 8374, 259, 176, "DefinitionBox",
      CellTags->{"OtherProps", "i:9"}]},
  "i:10"->{
    Cell[165011, 4523, 4384, 126, 98, "DefinitionBox",
      CellTags->{"OtherProps", "i:10"}]},
  "i:11"->{
    Cell[218379, 5659, 2947, 90, 85, "DefinitionBox",
      CellTags->{"OtherProps", "i:11"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"OtherProps", 256859, 6542},
  {"i:1", 265425, 6760},
  {"i:2", 265528, 6763},
  {"i:3", 265637, 6766},
  {"i:4", 265738, 6769},
  {"i:5", 265844, 6772},
  {"AbelianQex", 265959, 6775},
  {"i:6", 266157, 6780},
  {"i:7", 266254, 6783},
  {"i:8", 266362, 6786},
  {"i:9", 266459, 6789},
  {"i:10", 266568, 6792},
  {"i:11", 266677, 6795}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 830, 30, 89, "Subsubtitle",
  Evaluatable->False],
Cell[2564, 83, 197, 8, 107, "Section",
  Evaluatable->False,
  CellTags->"OtherProps"],
Cell[2764, 93, 74, 1, 68, "Subsection",
  CellTags->"OtherProps"],
Cell[2841, 96, 186, 5, 58, "Text",
  CellTags->"OtherProps"],
Cell[3030, 103, 3087, 95, 83, "DefinitionBox",
  CellTags->{"OtherProps", "i:1"}],
Cell[6120, 200, 72, 1, 26, "Caption",
  CellTags->"OtherProps"],
Cell[6195, 203, 260, 7, 54, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[6480, 214, 109, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[6592, 219, 95, 3, 28, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[6702, 225, 5752, 163, 152, "DefinitionBox3Col",
  CellTags->{"OtherProps", "i:2"}],
Cell[12457, 390, 84, 1, 26, "Caption",
  CellTags->"OtherProps"],
Cell[12544, 393, 168, 3, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[12737, 400, 144, 4, 39, "Input",
  CellTags->"OtherProps"],
Cell[12884, 406, 188, 4, 39, "Message",
  CellTags->"OtherProps"],
Cell[13075, 412, 86, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[13176, 418, 155, 5, 41, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[13356, 427, 150, 4, 55, "Input",
  CellTags->"OtherProps"],
Cell[13509, 433, 101, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[13625, 439, 737, 24, 77, "MathCaption",
  CellTags->{"OtherProps", "i:3"}],

Cell[CellGroupData[{
Cell[14387, 467, 110, 3, 45, "Input",
  CellTags->"OtherProps"],
Cell[14500, 472, 96, 3, 29, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[14611, 478, 216, 6, 55, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[14852, 488, 351, 6, 71, "Input",
  CellTags->"OtherProps"],
Cell[15206, 496, 124, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[15345, 502, 9051, 275, 180, "DefinitionBox",
  CellTags->{"OtherProps", "i:4"}],
Cell[24399, 779, 117, 4, 26, "Caption",
  CellTags->"OtherProps"],
Cell[24519, 785, 286, 8, 69, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[24830, 797, 134, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[24967, 802, 25438, 510, 296, 4616, 247, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherProps"],
Cell[50408, 1314, 116, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[50539, 1320, 356, 11, 70, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[50920, 1335, 115, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[51038, 1340, 90, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[51143, 1346, 182, 7, 41, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[51350, 1357, 107, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[51460, 1362, 100, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[51575, 1368, 178, 6, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[51778, 1378, 215, 5, 71, "Input",
  CellTags->"OtherProps"],
Cell[51996, 1385, 10707, 387, 186, 4221, 301, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[62718, 1775, 161, 4, 58, "Text",
  CellTags->"OtherProps"],
Cell[62882, 1781, 10648, 314, 178, "DefinitionBox",
  CellTags->{"OtherProps", "i:5"}],
Cell[73533, 2097, 80, 1, 26, "Caption",
  CellTags->"OtherProps"],
Cell[73616, 2100, 230, 7, 54, "MathCaption",
  CellTags->{"OtherProps", "AbelianQex"}],

Cell[CellGroupData[{
Cell[73871, 2111, 149, 3, 39, "Input",
  CellTags->{"OtherProps", "AbelianQex"}],
Cell[74023, 2116, 239, 4, 52, "Print",
  CellTags->"OtherProps"],
Cell[74265, 2122, 41057, 924, 296, 8475, 516, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherProps"],
Cell[115325, 3048, 90, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[115430, 3054, 89, 1, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[115544, 3059, 115, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[115662, 3064, 334, 6, 86, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[116011, 3073, 210, 6, 54, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[116246, 3083, 135, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[116384, 3088, 215, 4, 52, "Print",
  CellTags->"OtherProps"],
Cell[116602, 3094, 26995, 676, 296, 6601, 418, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherProps"],
Cell[143600, 3772, 101, 3, 28, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[143716, 3778, 412, 14, 58, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[144153, 3796, 124, 3, 43, "Input",
  CellTags->"OtherProps"],
Cell[144280, 3801, 88, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[144383, 3807, 1098, 41, 94, "Text",
  CellTags->{"OtherProps", "i:6"}],
Cell[145484, 3850, 6131, 186, 122, "DefinitionBox",
  CellTags->{"OtherProps", "i:7"}],
Cell[151618, 4038, 83, 1, 26, "Caption",
  CellTags->"OtherProps"],
Cell[151704, 4041, 172, 6, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[151901, 4051, 113, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[152017, 4056, 96, 3, 28, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[152128, 4062, 212, 8, 41, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[152365, 4074, 120, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[152488, 4079, 139, 3, 28, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[152642, 4085, 259, 8, 56, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[152926, 4097, 125, 3, 39, "Input",
  CellTags->"OtherProps"],
Cell[153054, 4102, 113, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[153182, 4108, 1442, 60, 98, "Text",
  CellTags->{"OtherProps", "i:8"}],
Cell[154627, 4170, 8374, 259, 176, "DefinitionBox",
  CellTags->{"OtherProps", "i:9"}],
Cell[163004, 4431, 78, 1, 27, "Caption",
  CellTags->"OtherProps"],
Cell[163085, 4434, 199, 6, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[163309, 4444, 116, 3, 38, "Input",
  CellTags->"OtherProps"],
Cell[163428, 4449, 86, 3, 32, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[163529, 4455, 348, 14, 56, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[163902, 4473, 133, 3, 38, "Input",
  CellTags->"OtherProps"],
Cell[164038, 4478, 126, 3, 34, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[164179, 4484, 206, 8, 41, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[164410, 4496, 127, 3, 38, "Input",
  CellTags->"OtherProps"],
Cell[164540, 4501, 113, 3, 34, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[164668, 4507, 100, 1, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[164793, 4512, 110, 3, 38, "Input",
  CellTags->"OtherProps"],
Cell[164906, 4517, 90, 3, 32, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[165011, 4523, 4384, 126, 98, "DefinitionBox",
  CellTags->{"OtherProps", "i:10"}],
Cell[169398, 4651, 76, 1, 27, "Caption",
  CellTags->"OtherProps"],
Cell[169477, 4654, 186, 6, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[169688, 4664, 125, 3, 38, "Input",
  CellTags->"OtherProps"],
Cell[169816, 4669, 47549, 942, 306, 8286, 451, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherProps"],
Cell[217368, 5613, 90, 3, 32, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[217473, 5619, 190, 6, 40, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[217688, 5629, 124, 3, 38, "Input",
  CellTags->"OtherProps"],
Cell[217815, 5634, 104, 3, 32, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[217934, 5640, 191, 5, 55, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[218150, 5649, 96, 2, 40, "Input",
  CellTags->"OtherProps"],
Cell[218249, 5653, 115, 3, 28, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[218379, 5659, 2947, 90, 85, "DefinitionBox",
  CellTags->{"OtherProps", "i:11"}],
Cell[221329, 5751, 69, 1, 26, "Caption",
  CellTags->"OtherProps"],
Cell[221401, 5754, 219, 7, 55, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[221645, 5765, 269, 6, 59, "Input",
  CellTags->"OtherProps"],
Cell[221917, 5773, 519, 18, 165, "Output",
  CellTags->"OtherProps"]
}, Open  ]],
Cell[222451, 5794, 167, 6, 28, "MathCaption",
  CellTags->"OtherProps"],

Cell[CellGroupData[{
Cell[222643, 5804, 131, 3, 27, "Input",
  CellTags->"OtherProps"],
Cell[222777, 5809, 33083, 701, 168, 5227, 351, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"OtherProps"],
Cell[255863, 6512, 86, 3, 26, "Output",
  CellTags->"OtherProps"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

