(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    941951,      25847]*)
(*NotebookOutlinePosition[    975626,      26719]*)
(*  CellTagsIndexPosition[    974184,      26666]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Chapter 3",
    FontSize->18],
  "\n",
  StyleBox["Ringoids",
    FontFamily->"Courier"]
}], "Section",
  ShowCellBracket->True,
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  CellTags->"i:1"],

Cell["3.0 Read me first", "Subsection",
  CellTags->"First"],

Cell[TextData[{
  "To evaluate any of the ",
  StyleBox["Input", "MR"],
  " cells in this chapter, the following cell should be evaluated first."
}], "Text",
  CellTags->"First"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Master`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"First"],

Cell[TextData[{
  "Since we wish to focus on rings, we use the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function."
}], "Text",
  CellTags->"First"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Ring]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"First"],

Cell[BoxData[
    \(Ring\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"First"]
}, Open  ]],

Cell[TextData[{
  "3.1 Forming ",
  StyleBox["Ringoids",
    FontFamily->"Courier"]
}], "Subsection",
  ShowCellBracket->True,
  Evaluatable->False,
  CellTags->"i:2"],

Cell[TextData[{
  "The principle means by which ringoids are formed is with ",
  StyleBox["FormRingoid", "MR"],
  ". Additionally, there is ",
  StyleBox["FormRingoidByTable", "MR"],
  ", which parallels the function ",
  StyleBox["FormGroupoidByTable", "MR"],
  ". "
}], "Text",
  CellTags->"FormRingoid"],

Cell[TextData[{
  "3.1.1 ",
  StyleBox["FormRingoid",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->{"FormRingoid", "i:3"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FormRingoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], "els", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["add",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["mult",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox[\(form\ a\ \),
                      SingleLetterItalics->False], 
                    StyleBox["Ringoid",
                      "MR"], 
                    StyleBox[\(\ with\ elements\ {\),
                      SingleLetterItalics->False], 
                    StyleBox["els",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["operations",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["add",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ and\ \),
                    SingleLetterItalics->False], 
                  StyleBox["mult",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["using",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["+",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(and\ *\ as\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(operation\ symbols\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["FormRingoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], "els", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["add",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["mult",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{"asym", 
                      StyleBox[",",
                        "MR"], " ", "msym"}], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox[\(form\ a\ \),
                        SingleLetterItalics->False], 
                      StyleBox["Ringoid",
                        "MR"], 
                      StyleBox[\(\ with\ elements\ {\),
                        SingleLetterItalics->False], 
                      StyleBox["els",
                        FontSlant->"Italic"]}], 
                    StyleBox["}",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operations",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["add",
                  FontSlant->"Italic"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["mult",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["using",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["asym",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["msym",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["symbols",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["FormRingoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], "els", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["add",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["mult",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["form",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["Ringoid",
                    "MR"], 
                  StyleBox[\(\ with\ elements\ {\),
                    SingleLetterItalics->False], 
                  StyleBox["els",
                    FontSlant->"Italic"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["operations",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["add",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ and\ \),
                    SingleLetterItalics->False], 
                  StyleBox["mult",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["using",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["+",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["*",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["as",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["operation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["symbols",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["options",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["opts",
                    FontSlant->"Italic"]}]}]}]},
          {
            RowBox[{
              StyleBox["FormRingoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], "els", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["add",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["mult",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{"asym", 
                      StyleBox[",",
                        "MR"], " ", "msym"}], 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["opts",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["form",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["Ringoid",
                      "MR"], 
                    StyleBox[\(\ with\ elements\ {\),
                      SingleLetterItalics->False], 
                    StyleBox["els",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operations",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["add",
                FontSlant->"Italic"], 
              StyleBox[\(\ and\ \),
                SingleLetterItalics->False], 
              StyleBox["mult",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["using",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["asym",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["msym",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbols",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->"FormRingoid"],

Cell[TextData[{
  "Variations in using ",
  StyleBox["FormRingoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormRingoid"],

Cell[TextData[{
  "The syntax of the ",
  StyleBox["FormRingoid", "MR"],
  " function requires the first parameter to be a list of elements and the \
next two parameters to be binary operations that serve as the addition and \
multiplication of the ringoid that is to be created. These binary operations \
are usually pure functions with two ",
  StyleBox["Slot", "MR"],
  " variables, #1 and #2. An optional fourth parameter can be provided, which \
is a list of two symbols to be used for addition and multiplication. Finally, \
any option of ",
  StyleBox["FormRingoid", "MR"],
  " can be included as a final argument."
}], "Text",
  CellTags->"FormRingoid"],

Cell[TextData[
"The choice of operation symbols does not change the \
ringoid\[CloseCurlyQuote]s properties; it is simply a cosmetic change that \
makes some outputs more appealing."], "Text",
  CellTags->"FormRingoid"],

Cell["The following are essentially the same ringoid.", "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({R1 = FormRingoid[{True, False}, Xor, And], \n
      R2 = FormRingoid[{True, False}, Xor, 
          And, {"\<\[CirclePlus]\>", "\<\[And]\>"}]}\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \({Ringoid[{True, False}, "-Addition-", "-Multiplication-"], 
      Ringoid[{True, False}, "-Addition-", "-Multiplication-"]}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["CayleyForm",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["OutputForm",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ how\ to\ format\ elements\ appearing\ in\ Cayley\ 
                tables\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["FormatElements",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", " ", 
                StyleBox["whether",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["should",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["be",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["displayed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["formatted",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\[Hyphen]Elements\[Hyphen]",
                  "MR"]}]}]},
          {
            StyleBox[
              FormBox["FormatOperator",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["addition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["should",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["be",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["displayed",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["formatted",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\[Hyphen]Addition\[Hyphen]",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\[Hyphen]Multiplication\[Hyphen]",
                "MR"]}]},
          {
            StyleBox[
              FormBox["IsARing",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["whether",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["we",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["can",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["assume",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["KeyForm",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["InputForm",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                
                StyleBox[
                  \(specifies\ how\ to\ format\ elements\ appearing\ in\ a\ 
                    key\ when\ \),
                  SingleLetterItalics->False], 
                StyleBox["CayleyTables",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text"], 
              RowBox[{
                StyleBox["MultiplicationTable",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["called",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["having",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["WideElements",
                  "MR"], 
                StyleBox[\(\ set\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"]}]}]},
          {
            StyleBox[
              FormBox["MaxElementsToList",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["50",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(specifies\ the\ number\ of\ elements\ to\ list\ before\ the\ 
                list\ of\ elements\ is\ automatically\ \(formatted . \)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["RingoidDescription",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[
                StyleBox["\"\<\>\"",
                  "Text"],
                "StandardForm"],
              "Text"], 
            StyleBox[\(brief\ description\ of\ the\ ringoid\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["RingoidName",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["\"\<TheRing\>\"",
                "StandardForm"],
              "Text"], 
            StyleBox[\(name\ of\ the\ ringoid\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["WideElements",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{"specifies", " ", 
                StyleBox["whether",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              StyleBox[\(considered\ too\ wide\ to\ fit\ into\ a\ Cayley\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox[\(table, \ initiating\ a\ key\ to\ be\ set\ up\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.26, 0.2, 0.54},
  RowLines->{True, False}},
  CellTags->{"FormRingoid", "i:4"}],

Cell[TextData[{
  "Options for ",
  StyleBox["FormRingoid",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormRingoid"],

Cell[TextData[{
  "The operations on some larger ringoids can be time-consuming. Some time \
can be saved if you know that a ringoid is indeed a ring by declaring it as \
such with the option ",
  StyleBox["IsARing", "MR"],
  ". Caution: Your declaration is not checked, so you should use this option \
only if you are sure you have a ring."
}], "Text",
  CellTags->"FormRingoid"],

Cell["Here is a big ring.", "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BigRing = 
      FormRingoid[Range[0, 1000], Mod[#1 + #2, 1001]&, Mod[#1\ #2, 1001]&, 
        IsARing \[Rule] True]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \(Ringoid[{"-Elements-"}, "-Addition-", "-Multiplication-"]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "The following timing has been greatly reduced by the use of ",
  StyleBox["IsARing", "MR"],
  "."
}], "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[RingQ[BigRing]]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \({0.0333333333333030168`\ Second, True}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell["\<\
Normally the elements of a small ringoid are listed; they can, \
however, be suppressed.\
\>", "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormRingoid[Range[0, 1], Mod[#1 + #2, 2]&, Times, 
      MaxElementsToList \[Rule] 1]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \(Ringoid[{"-Elements-"}, "-Addition-", "-Multiplication-"]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell["\<\
In most cases, the usual addition and multiplication symbols are \
adequate. Here, as the fourth parameter, alternate symbols are \
specified.\
\>", "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Un = 
      FormRingoid[{"\<a\>", "\<b\>", "\<c\>"}, #1&, #2&, {"\<Fst\>", 
          "\<Lst\>"}, RingoidName \[Rule] "\<UnRing\>", 
        RingoidDescription \[Rule] "\<A nonsense Ringoid\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \(Ringoid[{"a", "b", "c"}, "-Addition-", "-Multiplication-"]\)], "Output",\

  CellLabel->"Out[7]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell["The alternate symbols appear in the Cayley tables.", "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[Un, Mode \[Rule] Visual]; \)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"FormRingoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
1 .5 0 r
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.56 .37 .6 r
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(a)] .38095 .62202 0 0 Mshowa
[(a)] .61905 .62202 0 0 Mshowa
[(a)] .85714 .62202 0 0 Mshowa
[(b)] .38095 .38393 0 0 Mshowa
[(b)] .61905 .38393 0 0 Mshowa
[(b)] .85714 .38393 0 0 Mshowa
[(c)] .38095 .14583 0 0 Mshowa
[(c)] .61905 .14583 0 0 Mshowa
[(c)] .85714 .14583 0 0 Mshowa
[(a)] .14286 .62202 0 0 Mshowa
[(b)] .14286 .38393 0 0 Mshowa
[(c)] .14286 .14583 0 0 Mshowa
[(a)] .38095 .86012 0 0 Mshowa
[(b)] .61905 .86012 0 0 Mshowa
[(c)] .85714 .86012 0 0 Mshowa
[(Addition)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
(Fst) show
117.000000 13.000000 moveto
(y) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(a)] .38095 .62202 0 0 Mshowa
[(b)] .61905 .62202 0 0 Mshowa
[(c)] .85714 .62202 0 0 Mshowa
[(a)] .38095 .38393 0 0 Mshowa
[(b)] .61905 .38393 0 0 Mshowa
[(c)] .85714 .38393 0 0 Mshowa
[(a)] .38095 .14583 0 0 Mshowa
[(b)] .61905 .14583 0 0 Mshowa
[(c)] .85714 .14583 0 0 Mshowa
[(a)] .14286 .62202 0 0 Mshowa
[(b)] .14286 .38393 0 0 Mshowa
[(c)] .14286 .14583 0 0 Mshowa
[(a)] .38095 .86012 0 0 Mshowa
[(b)] .61905 .86012 0 0 Mshowa
[(c)] .85714 .86012 0 0 Mshowa
[(Multiplication)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
(Lst) show
117.000000 13.000000 moveto
(y) show
123.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`1LLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC000Mog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l0G7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`007Omnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
05aaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<001goLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`1L
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_@00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0G75n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o05anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`1LLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0G7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o05aaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`1LO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lC000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0G75nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o05anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoa<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`1LLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlC000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0
000:000>ooAnm7kdO_Anm7kdO_@3o`0=m7kdO_Anm7kdO_Anm002o`0=O_Anm7kdO_Anm7kdOP03o`0L
O_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm0?o01cdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_An
0ol03WkdO_Anm7kdO_Anm7ko4`003_mnm7kdO_Anm7kdO_An0ol037kdO_Anm7kdO_Anm0;o3Ml5o`cO
00koWenOGimOWenOGimOW`Co01aOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd0ol03_Anm7kdO_An
m7kdO_Co2`0000X001koOW5nLGiaOW5nLGiaog5nLOmaOW5nLGiaOW5nLGh2o`1LLGiaOW5nLGiaOW5n
ogiaO_mnLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLOmaOW7oLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5n
LGkoOW5nogiaOW5nLGiaOW5nLOlC000Mog5nLGiaOW5nLGiaO_mnLGkoOW5nLGiaOW5nLGh00_l=g`04
omoOo`gO03ooWenOGimOWenOGimOWonOGiooWenOGimOWenOGimOog5nLGiaOW5nLGiaOW7oLGiaog5n
LGiaOW5nLGiaO_l02`0000X001kom7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_@2o`1LO_Anm7kd
O_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_mnm7kd
O_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_lC000MogkdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_@0
0_l=g`Co3Ml0?onOGimOWenOGimOWenOoimOWonOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7kd
O_Anm7kdO_Anm7kdo`0;00002P007_mnLGiaOW5nLGiaOW7oLGiaog5nLGiaOW5nLGiaOP;o05aaOW5n
LGiaOW5nLGkoOW5nogiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaog5nLOmaOW5nLGiaOW5nLGiaog5n
LGiaOW5nLGiaO_mnLGkoOW5nLGiaOW5nLGiaoa<001goLGiaOW5nLGiaOW5nogiaO_mnLGiaOW5nLGia
OP02oa3O00?ogml02ml0?onOGimOWenOGimOWenOoimOWonOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LOmaOW7oLGiaOW5nLGiaOW5no`0;00002P003_odO_Anm7kdO_Anm7kd1?l037kdO_Anm7kdO_Anm0;o
00enm7kdO_Anm7kdO_An00Co01_dO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_@01?l06gkdO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdOP04o`0=m7kdO_Anm7kdO_Ano`0C000>ogkdO_Anm7kdO_Anm7h4o`0;
m7kdO_Anm7kdO_@00_l>g`?o3Ml03_nOGimOWenOGimOWenO1?l075nOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_@4o`0=O_Anm7kdO_Anm7kdo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOP;o05aaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<001goLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOP02oakO03ooWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`1LO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC000MogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_@00_lNg`0=oimOWenOGimOWenOG`02o`0`WenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`1LLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC000Mog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l0G7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`007Omnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
05aaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<001goLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`1L
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_@00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0G75n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o05anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`1LLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0G7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o05aaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`1LO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lC000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00/0000:07co4`1lo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o05aOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimO
W`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1LGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o05aOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOoa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO
03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1LGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGolC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o05aOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOoa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1LGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGolC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0
000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;0000
2P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o05aOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimOW`02oakO03ooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X0
01koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1LGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGolC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P003OnO
GimOWenOGimOWel01?l03ImOWenOGimOWenOGil00_l035nOGimOWenOGimOW`Co01]OWenOGimOWenO
GimOWonOGimOWenOGimOWel01?l06imOWenOGimOWenOGimOoenOGimOWenOGimOW`04o`0>GimOWenO
GimOWenOGolC000=oenOGimOWenOGimOW`04o`0<GimOWenOGimOWenO0_l=g`Go3=l03_nOGimOWenO
GimOWenO1?l075nOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGh3o`0>OW5nLGiaOW5nLGiaO_l;0000
2P007_nOGimOWenOGimOWeooGimOoenOGimOWenOGimOW`;o05aOWenOGimOWenOGiooWenOoimOWenO
GimOWenOGiooWenOGimOWenOGimOoenOGomOWenOGimOWenOGimOoenOGimOWenOGimOWonOGiooWenO
GimOWenOGimOoa<001goGimOWenOGimOWenOoimOWonOGimOWenOGimOW`02o`gO00Cogmoo3Ml0?onO
GimOWenOGimOWenOoimOWonOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7koO_Anm7kdO_Anm7kd
o`0;00002P007_nOGimOWenOGimOWeooGimOoenOGimOWenOGimOW`;o05aOWenOGimOWenOGiooWenO
oimOWenOGimOWenOGiooWenOGimOWenOGimOoenOGomOWenOGimOWenOGimOoenOGimOWenOGimOWonO
GiooWenOGimOWenOGimOoa<001goGimOWenOGimOWenOoimOWonOGimOWenOGimOW`02o`gO1?l=g`0o
oimOWenOGimOWenOGiooWenOoimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5n
LGko00/0000:000NoimOWenOGimOWenOGomOWeooGimOWenOGimOWenO0_l0G5nOGimOWenOGimOWonO
GiooWenOGimOWenOGimOWonOGimOWenOGimOWeooGimOoenOGimOWenOGimOWeooGimOWenOGimOWenO
oimOWonOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGiooWenOoimOWenOGimOWenO00;o4=l00ooO
g`0;g`0ooimOWenOGimOWenOGiooWenOoimOWenOGimOWenOGomnm7kdO_Anm7kdO_AnogkdO_mnm7kd
O_Anm7kdO_Co00/0000:000=oimOWenOGimOWenOG`04o`0=WenOGimOWenOGimOW`02o`0<GimOWenO
GimOWenO1?l06enOGimOWenOGimOWenOoimOWenOGimOWenOG`04o`0KWenOGimOWenOGimOWeooGimO
WenOGimOWenO00Co00iOWenOGimOWenOGimOoa<000goGimOWenOGimOWenO00Co00aOWenOGimOWenO
Gil2o`kO0ol=g`0>oimOWenOGimOWenOGil4o`0LGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOPCo
00eaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGomOWenOGimOWenOGimOWenO0_l0G5nO
GimOWenOGimOWonOGimOWenOGimOWenOGimOWonOGimOWenOGimOWeooGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOoimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGiooWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOoimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P003?nOGimOWenOGimOW`;o011OWenOGimOWenOGimOWenO0_l02enO
GimOWenOGimO00;o01fOGimOWenOGimOWenOGimOWonOGimOWenOGimOW`02o`0MGimOWenOGimOWenO
GimOWeooGimOWenOGimOWel00_l04ImOWenOGimOWenOGimOWeoo01<000coGimOWenOGimOWel2o`0?
WenOGimOWenOGimOWenO00;o7]l03OnOGimOWenOGimOWel00_l0<9mOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0G5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o05aOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa<001goGimOWenOGimOWenOGimO
WenOGimOWenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2o`1LGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolC000MoenOGimOWenOGimOWenOGimO
WenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0G5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
05aOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoa<001goGimOWenOGimOWenOGimOWenOGimO
WenOGimOW`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1L
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomOWenOGimOWenOGimOWenOGimOWenOGimOWenOGolC000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o05aOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOoa<001goGimOWenOGimOWenOGimOWenOGimOWenOGimO
W`02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l02`0000X001koWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1LGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGolC000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0G5nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo4`007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0;00002P1loa<0O?l;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o0000
4@000ooOg`0Jg`;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ooOg`0:g`Go3=l2o`cO1Ol=g`03omoO00[O1Ol=g`03
omoO00[O1Ol<g`03o`00014000?ogml02]l5o`_O0_l=g`Go3=l03_nOGimOWenOGimOWenO1?l075nO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_@3o`0>m7kdO_Anm7kdO_Anm?l;00002P000ooOg`0:g`04
omoOo`gO0_l<g`04omoOo`kO00?ogml02]l01?oOgol>g`03omoO00[O00Cogmoo3Ml00ol0000A0003
omoO00[O00Cogmoo3=l2o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenOoimOWonOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLOmaOW7oLGiaOW5nLGiaOW5no`0;00002P000ooOg`0:g`Co3Ml2o`cO1?l>g`03
omoO00[O1?l>g`03omoO00[O1?l=g`03o`00014000?ogml02]l4o`cO0_l=g`Co3Ml0?onOGimOWenO
GimOWenOoimOWonOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdo`0;0000
2P000ooOg`0=g`03omoO00_O0_l?g`03omoO00cO00?ogml03Ml00ooOg`0<g`03omoO00gO00?ogml0
2ml00ol0000A0003omoO00gO00?ogml02]l2oa3O00?ogml02ml0?onOGimOWenOGimOWenOoimOWonO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLOmaOW7oLGiaOW5nLGiaOW5no`0;00002P000ooOg`0;g`?o
3Ml2o`gO0ol>g`03omoO00_O0ol>g`03omoO00_O0ol=g`03o`00014000?ogml02ml3o`cO0_l>g`?o
3Ml03_nOGimOWenOGimOWenO1?l075nOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_@4o`0=O_Anm7kd
O_Anm7kdo`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o00004@000ooOg`0Jg`;o
7]l0?onOGimOWenOGimOWenOoimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0;00002P000ooOg`0Kg`;o7]l00ooOg`0Lg`03omoO01_O00?o00004@000ooOg`0Jg`;o
7]l03OnOGimOWenOGimOWel00_l0<9mOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko00/0000:0003omoO01_O0_lNg`03omoO01cO00?ogml06ml00ol0000A0003omoO01[O
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000907go4P1mo`/0000907go4P1mo`/0000:0003o`0001X00olNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
o`0001X00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:0003o`0001T000Co0?oo7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol0000I00?o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P000ol0000H0003o`0000;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol0000H0004o`3ooakO03ooWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X0
00?o00005`001?l00002oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00005`000ol00002oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o0000
5P000ol0000200;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4`000ol0000F0004o`0000;o7]l0?onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000E0003
o`0000<00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003o`0001D000?o00000P02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00001002o`03
0?oo00/000?o00001002oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00001002o`030?oo00/000?o00000`02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o00001@000ol0o`0;0003o`0000D00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000D000?o0?l02`000ol0
000400;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P000ol000060003o`0000T000?o00001P02oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o0000
1P000ol000090003o`0000D00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003o`0000D000?o0?l02@000ol0000700;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ol000050003o`3o00T000?o00001P02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00001002o`03
0?oo00L000?o00002002oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00001002o`030?oo00L000?o00001`02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o00003`000ol0000900;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol0000?0003o`0000P00_lNg`0ooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0
000:0003o`0000h000?o00002P02o`cO1Ol=g`0=oimOWenOGimOWenOG`04o`0LWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nL@?o00iaOW5nLGiaOW5nLGiaoa<000?o00003P000ol0000900;o3Ml5o`cO
00koWenOGimOWenOGimOW`Co01aOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n0ol03WiaOW5nLGia
OW5nLGko2`0000X000?o00003@000ol0000;00;o3=l01?oOgol>g`0noimOWenOGimOWenOGomOWeoo
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Com7kdooAnm7kdO_Anm7kdO_lC0003o`0000d000?o0000
2P02o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenOoimOWonOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_mnm7koO_Anm7kdO_Anm7kdo`0;00002P000ol0000<0003o`0000`00_l<g`Co3]l0?_nOGimOWenO
GimOWeooGimOoenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGiaOW7o4`000ol0
000<0003o`0000/00_l=g`Co3Ml0?onOGimOWenOGimOWenOoimOWonOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000;0003o`0000d00_l?g`03omoO00cO
03koWenOGimOWenOGimOoenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?odO_Com7kdO_Anm7kd
O_Anoa<000?o00002`000ol0000<00;o4=l00ooOg`0;g`0ooimOWenOGimOWenOGiooWenOoimOWenO
GimOWenOGomnm7kdO_Anm7kdO_AnogkdO_mnm7kdO_Anm7kdO_Co00/0000:0003o`0000X000?o0000
1003o`L00_l=g`?o3]l03OnOGimOWenOGimOWel01?l079mOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW44o`0=OW5nLGiaOW5nLGiao`0C0003o`0000X000?o00001003o`H00_l>g`?o3Ml03_nOGimOWenO
GimOWenO1?l075nOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGh4o`0=LGiaOW5nLGiaOW5no`0;0000
2P000ol000090003o`0000H000?o00001P02oakO03koWenOGimOWenOGimOoenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00002@000ol000060003o`0000D0
0_lNg`0ooimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0003o`0000P000?o000020000ol0000500;o7]l03?nOGimOWenOGimOW`;o
031OWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000P0
00?o000020000ol0000400;o7]l03OnOGimOWenOGimOWel00_l0<9mOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:0003o`0000L000?o00002@000ol0000500;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ol000070003o`0000T000?o00001002oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00001P000ol0
00090003o`3o00H00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000H000?o00002@000ol0o`0500;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;0000
2P000ol000050003o`0000X000?o0?l01P02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00001@000ol0000:0003o`3o00D0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0003o`0000@000?o00002P02o`030?oo00D00_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000@0
00?o00002P02o`030?oo00@00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003o`0000<000?o00005@02oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?o00000`000ol0000D00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ol000020003o`0001H00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
o`00008000?o00005@02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000Go0000o`0I00;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`001Ol0003o01P0
0_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co00/0000:0004o`00oaX00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0004o`00oaT00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003
o`3o01/00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003o`3o01X00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:00;o7002oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<00_lK00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0;00002P1loa<0O?l;0000:002oh`00_mX0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000O@03ocL01?mA00?o4@0007h000?o0000=`000ol0
001B0003o`000100000:00;o00<0ool00`05o`030?oo00So0P03o`801Ol200?o0P02o`030?oo01l0
0_l00`3oo`0700?o1004o`<00ol90003o`0001P000Ko0000o`05o`030?oo00?o0P03o`801Ol00`3o
o`02o`801Ol00`3oo`03o`800ol200Go0P03o`801Ol200?o0P02o`030?oo00L01Ol200Co0`03o`T0
00?o00003`0000/000?o0?l00`001ol0003o0?l00`001Ol0003o00@000Co003o0`001Ol0003o00<0
00?o0?l00P000ol0000O0003o`3o00T000?o00001P001Ol0003o008000?o00001P000ol0000H0007
o`000?l0o`020003o`00008000?o00000P001?l00?l30005o`000?l00`001Ol0003o00D000Go0000
o`030003o`3o008000Go0000o`020005o`000?l00`001_l0003o00;o00<0o`0020001?l00?l50005
o`000?l00P000ol000060003o`0000l0000;00?o0`001ol0003o0?l00`001Ol0003o00@000?o0000
10001Ol0003o00<000?o0?l00P000ol0000P0003o`0000P000?o00000`04o`<000?o000020000ol0
o`0I0007o`3o0?l0o`020003o`00008000?o00000P000ol000040005o`000?l00`001Ol0003o00D0
00Go0000o`0500Co0`000ol000040005o`000?l00`001?l0o`02o`T000Co003o0P04o`<000?o0000
20000ol0o`0@00002`000ol0o`030007o`000?l0o`030005o`000?l010000ol000040005o`000?l0
0`000ol0o`020003o`0001l000?o0?l02@03o`<000?o000010000ol000080003o`3o01T000Oo0?l0
o`3o008000?o00000P000ol000020003o`0000@000Go0000o`030005o`000?l01@001Ol0003o00<0
00?o00000P001Ol0003o00H000Go0000o`030006o`3oo`3o2@000ol000030003o`0000@000?o0000
20000ol0o`0@000030000ol0000300Co0P04o`800_l300Co0`02o`@00ol00`3oo`03ob000_l00`3o
o`080003o`0000<01?l200Co1`02o`030?oo01P00_l00`3oo`02o`030?oo00@000Co00001?l300;o
0P05o`@000?o00000P02o`@01?l200?o0P04o`<00_l400?o00<0ool01?l80003o`0000<01?l200Co
1`02o`030?oo00l0000;00;o20000ol000030003o`0000H000?o0000?P05o`T000?o00008`02o`<0
0_l80003o`00008000?o000040000ol0000D0003o`0001X00ol;0003o`0001/0000D00;o1002o`<0
00?o00000P000ol000040003o`0004D000?o0000<003o`@000?o000010000ol0000700?o1@000ol0
000>0003o`0000@000?o00008@000ol0000K0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-5.95503, -0.231915, 0.0323772, 
  0.0323772}},
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "Here is a ring of multiples of \[Pi] mod 3\[Pi] with ",
  StyleBox["CayleyForm", "MR"],
  " set to ",
  StyleBox["TraditionalForm.", "MR"]
}], "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(piRing = 
      FormRingoid[Range[0, 2\ \[Pi], \[Pi]], 
        \[Pi]\ Mod[\(#1 + #2\)\/\[Pi], 3]&, 
        \[Pi]\ Mod[\(#1\ #2\)\/\[Pi]\^2, 3]&, 
        CayleyForm \[Rule] TraditionalForm]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \(Ringoid[{0, \[Pi], 2\ \[Pi]}, "-Addition-", "-Multiplication-"]\)], 
  "Output",
  CellLabel->"Out[9]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "The Cayley tables are displayed with the ",
  StyleBox["TraditionalForm", "MR"],
  " of \[Pi]."
}], "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[piRing, Mode \[Rule] Visual]; \)\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"FormRingoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
gsave
.38095 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .62202 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.61905 .38393 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.85714 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.38095 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.61905 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.85714 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.14286 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .86012 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(Addition)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 .5 0 r
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
gsave
.38095 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.85714 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.38095 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .38393 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.85714 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.14286 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .86012 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(Multiplication)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[10]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0
000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO
03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000M
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;0000
2P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0o
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:0009ooAnm7kd
O_An00Co017dO_AnogkdO_Com7kdO_Anm002o`08O_Anm7kdO_@4o`0CO_Anm?odO_AnogkdO_Anm7kd
o`0=g`;o3ml07omOWenOGimOWenOGomOWenOoimOWenOGimOWenOGol04`002Omnm7kdO_Anm004o`0@
O_AnogkdO_Com7kdO_Anm0;o3]l2o`kO00Wom7kdO_Anm7h01?l0<_Anm7koO_Anm?odO_Anm7kdO_mO
WenOGimOWenOGiooWenOGomOWenOGimOWenOGioo2`0000X001koOW5nLGiaOW5nogiaOW5nLGkoOW7o
LGiaOW5nLGh2o`0OLGiaOW5nLGiaog5nLGiaOW7oLGkoOW5nLGiaOW5no`0<g`04omoOo`kO01ooGimO
WenOGimOWenOoimOoenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaog5nLGiaO_mnLOmaOW5nLGia
OP02o`gO00Cogmoo3Ml0?omnLGiaOW5nLGkoOW5nLGiaO_mnLOmaOW5nLGiaOW7oGimOWenOGimOWenO
GomOWonOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_AnogkdO_Anm7koO_mnm7kdO_Anm0;o
01mnm7kdO_Anm7kdooAnm7kdO_Com?odO_Anm7kdO_Co00cO00Cogmoo3]l07omOWenOGimOWenOGimO
oeooGimOWenOGimOWenOGol04`007Omnm7kdO_Anm7kdooAnm7kdO_mnogkdO_Anm7kd00;o3Ml01?oO
gol=g`0oooAnm7kdO_Anm7koO_Anm7kdO_mnogkdO_Anm7kdO_mOWenOGimOWenOGimOWonOoimOWenO
GimOWenOGioo00/0000:000NogiaOW5nLGiaOW5nogiaOW5nLOmaog5nLGiaOW5n0_l07g5nLGiaOW5n
LGiaog5nLGiaO_mnogiaOW5nLGiaO_l03=l01?oOgol>g`0OoenOGimOWenOGimOWeooGomOWenOGimO
WenOGimOo`0C000Mog5nLGiaOW5nLGiaog5nLGiaog7oLGiaOW5nLGh00_l=g`04omoOo`gO03ooOW5n
LGiaOW5nLGkoOW5nLGiaog7oLGiaOW5nLGiaoenOGimOWenOGimOWenOoiooWenOGimOWenOGimOWol0
2`0000X001;om7kdO_Anm7koO_Com7kdO_@5o`07m7kdO_Anm002o`0AO_Anm7kdO_Com7koO_Anm7h0
1Ol02GkdO_Anm7kdo`0<g`04omoOo`kO00goGimOWenOGimOWenO00Go00fOGimOWenOGimOWeoo01<0
017oO_Anm7kdO_Com7koO_Anm005o`07m7kdO_Anm002o`gO00Cogmoo3Ml04_odO_Anm7kdO_mnm?od
O_Anm0Go01KdO_Anm7kdO_mOWenOGimOWenOGimO1Ol03EnOGimOWenOGimOWol02`0000X000[oOW5n
LGiaOW5n0_l04W5nLGiaOW5nLGiaOW5nLGiaOP;o00UaOW5nLGiaOW400_l057iaOW5nLGiaOW5nLGia
OW5nLGko3Ml2o`oO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000[oLGiaOW5nLGia
0_l04GiaOW5nLGiaOW5nLGiaOW5n00;o3]l2o`kO00[oOW5nLGiaOW5n0_l0<g5nLGiaOW5nLGiaOW5n
LGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
7]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X0
01kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
4`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO
01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0O
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:07co
4`1lo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000N
oimOWenOGimOWenOoimOWeooGimOWenOGimOWenO0_l09enOGimOWenOGimOoenOGiooWenOGimOWenO
GimOWomnLGiaOW5nL@04o`0COW5nogiaOW7oLGiaOW5nLGiao`0=g`;o3]l00ol0000A000MoenOGimO
WenOGimOoenOGiooWenOGimOWenOGil00_l>g`;o3]l0:?nOGimOWenOGimOWeooGimOWonOGimOWenO
GimOWeooLGiaOW5nLGh4o`0CLGiaO_mnLGiaog5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWeoo
GiooWenOGimOWenOGimOW`;o03iOWenOGimOWenOGiooWeooGimOWenOGimOWenOGioom7kdO_Anm7kd
ooAnm7kdO_mnm?odO_Anm7kdO_Ano`cO00Cogmoo3Ml00ol0000A000MoenOGimOWenOGimOWonOGomO
WenOGimOWenOGil00_l=g`04omoOo`gO03ooWenOGimOWenOGimOWonOGomOWenOGimOWenOGimOogkd
O_Anm7kdO_mnm7kdO_AnogkdooAnm7kdO_Anm?l02`0000X001koWenOGimOWenOGimOWonOoimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGomOoenOGimOWenOGimOWenOogiaOW5nLGiaOW7oLGiaOW5n
ogkoOW5nLGiaOW5nLOl<g`04omoOo`gO00?o00004@007OmOWenOGimOWenOGimOoeooGimOWenOGimO
WenO00;o3Ml01?oOgol=g`0ooimOWenOGimOWenOGimOoeooGimOWenOGimOWenOGomaOW5nLGiaOW5n
ogiaOW5nLGkoO_mnLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGiooWonOGimOWenOGimOWenO
0_l0?UnOGimOWenOGimOWeooGomOWenOGimOWenOGimOWoodO_Anm7kdO_Anm?odO_Anm?odooAnm7kd
O_Anm7ko3=l01?oOgol=g`03o`00014001goGimOWenOGimOWenOGomOoenOGimOWenOGimOW`02o`gO
00Cogmoo3Ml0?onOGimOWenOGimOWenOGomOoenOGimOWenOGimOWeooO_Anm7kdO_Anm7koO_Anm7kd
ooCom7kdO_Anm7kdo`0;00002P003OnOGimOWenOGimOWel01Ol035nOGimOWenOGimOW`;o00aOWenO
GimOWenOGil5o`0NWenOGimOWenOGimOWomnLGiaOW5nLOmaO_mnLGia1Ol02W5nLGiaOW5nLOl<g`04
omoOo`gO00?o00004@003OmOWenOGimOWenOGil01Ol02imOWenOGimOWenO00;o3Ml01?oOgol=g`0>
oimOWenOGimOWenOGil5o`0NWenOGimOWenOGimOog5nLGiaOW5nogiaog5nLGia1Ol02G5nLGiaOW5n
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o02QOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kd0_l057kdO_Anm7kdO_Anm7kdO_Anm7ko3Ml2o`kO00?o0000
4@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o3]l2o`kO02WoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdOP02o`0Dm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P1loa<0O?l;00002P000ooOg`0Kg`;o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooO
g`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml0
6]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O
0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o
7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO
00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03
omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooO
g`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml0
7=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO
00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03
omoO01cO00?o00002@0000X000?ogml02ml2o`kO0_l=g`;o3ml0:?nOGimOWenOGimOWonOGimOoenO
GimOWenOGimOWeooO_Anm7kdO_@4o`0BO_AnogkdO_Com7kdO_Anm7ko4`000ooOg`0;g`;o3Ml2o`kO
0_l>g`03omoO00cO0_l>g`03omoO00cO0_l>g`03o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO
00Cogmoo3]l0?_nOGimOWenOGimOWeooGiooWenOGimOWenOGimOWeooLGiaOW5nLGiaog5nLGiaO_mn
LOmaOW5nLGiaOW7o4`000ooOg`0:g`04omoOo`cO0_l=g`04omoOo`gO00?ogml02ml01?oOgol=g`03
omoO00_O00Cogmoo3Ml00ol0000900002P000ooOg`0:g`04omoOo`gO0_l<g`04omoOo`kO03koWenO
GimOWenOGimOWonOoimOWenOGimOWenOGimOogkdO_Anm7kdO_Com7kdO_AnogkoO_Anm7kdO_Anoa<0
00?ogml02]l01?oOgol<g`;o3Ml01?oOgol=g`03omoO00_O00Cogmoo3Ml00ooOg`0;g`04omoOo`gO
00?o00002@0000X000?ogml02]l01?oOgol=g`;o3=l01?oOgol>g`0noimOWenOGimOWenOGiooWonO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLOmaOW5nLOmaog5nLGiaOW5nLOlC0003omoO00[O00Cogmoo
3=l2o`gO00Cogmoo3Ml00ooOg`0;g`04omoOo`gO00?ogml02ml01?oOgol=g`03o`0000T0000:0003
omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l03OnOGimOWenOGimOWel01Ol07UnOGimOWenOGimOWeoo
O_Anm7kdO_Com7koO_Anm0Go00WdO_Anm7kdO_l04`000ooOg`0:g`04omoOo`cO0_l=g`04omoOo`gO
00?ogml02ml01?oOgol=g`03omoO00_O00Cogmoo3Ml00ol0000900002P000ooOg`0;g`;o3]l2o`gO
0_l?g`0YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW400_l04giaOW5nLGia
OW5nLGiaOW5nLOl04`000ooOg`0;g`;o3Ml2o`kO0_l>g`03omoO00cO0_l>g`03omoO00cO0_l>g`03
o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0
000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o0000
2@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0
000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol000090000
2P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X0
00?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003
omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml0
6ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000T0OOlB07go2`0000T0
OOlB07go2`0000X000?o00006P03oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00006P02oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o0000
6@001?l0oolNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003o`0001T00olNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0001P000?o00000_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlC0003o`0001P000Co0?oo7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000G0004o`0000;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol0
000G0003o`0000;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ol0000F0003o`0000800_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0001H0
00Co00000_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:0003o`0001D000?o00000`02oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00005@000ol0
000200;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P000ol0000400;o00<0ool02`000ol0000400;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol0
000400;o00<0ool02`000ol0000300;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000050003o`3o00/000?o0000
1@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?o00001@000ol0o`0;0003o`0000@00_lNg`0ooimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000H0
00?o00002@000ol0000600;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000060003o`0000T000?o00001@02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o00001@000ol0o`090003o`0000L00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000D000?o0?l02@000ol0
000600;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P000ol0000400;o00<0ool01`000ol0000800;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol0
000400;o00<0ool01`000ol0000700;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000?0003o`0000T00_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lC0003o`0000l000?o00002002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00003P000ol0000:00;o3Ml2o`oO
02SoWenOGimOWenOGiooWenOGomOWenOGimOWenOGimOog5nLGiaOW5n1?l04W5nLOmaOW5nogiaOW5n
LGiaoa<000?o00003P000ol0000900;o3]l2o`kO02SoWenOGimOWenOGimOoenOGiooWenOGimOWenO
GimOog5nLGiaOW5n1?l04g5nLGkoOW5nLOmaOW5nLGiaO_l02`0000X000?o00003@000ol0000;00;o
3=l01?oOgol>g`0noimOWenOGimOWenOGomOWonOGimOWenOGimOWenOGomnm7kdO_Anm7koO_Anm7kd
ooAnogkdO_Anm7kdO_lC0003o`0000d000?o00002P02o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenO
oimOoenOGimOWenOGimOWeooO_Anm7kdO_AnogkdO_Anm7koO_Com7kdO_Anm7kdo`0;00002P000ol0
000<0003o`0000`00_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOoimOWenOGimOWenOGimOog5n
LGiaOW5nLGkoOW5nLGiaog7oLGiaOW5nLGiaoa<000?o000030000ol0000;00;o3Ml01?oOgol=g`0o
oimOWenOGimOWenOGimOoeooGimOWenOGimOWenOGomaOW5nLGiaOW5nogiaOW5nLGkoO_mnLGiaOW5n
LGko00/0000:0003o`0000/000?o00003@02o`cO00Cogmoo3]l0?_nOGimOWenOGimOWenOoiooWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7koO_Anm7koO_mnm7kdO_Anm7ko4`000ol0000;0003o`0000`0
0_l=g`04omoOo`gO03ooWenOGimOWenOGimOWeooGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anogkd
O_Anm?odooAnm7kdO_Anm?l02`0000X000?o00002P000ol0000400?o1`02o`cO00Cogmoo3]l03OnO
GimOWenOGimOWel01Ol07UnOGimOWenOGimOWeooLGiaOW5nLGkoOW7oLGiaOPGo00UnLGiaOW5nLOl0
4`000ol0000:0003o`0000@00ol600;o3Ml01?oOgol=g`0>oimOWenOGimOWenOGil5o`0NWenOGimO
WenOGimOog5nLGiaOW5nogiaog5nLGia1Ol02G5nLGiaOW5no`0;00002P000ol000090003o`0000H0
00?o00001P02o`gO0_l?g`0YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7h0
0_l04oAnm7kdO_Anm7kdO_Anm7kdO_l04`000ol000090003o`0000H000?o00001@02o`kO0_l>g`0Y
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7h00_l05?Anm7kdO_Anm7kdO_An
m7kdO_Co2`0000X000?o000020000ol000080003o`0000D00_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000P000?o0000
20000ol0000400;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000070003o`0000T000?o00001@02oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?o00001`000ol000090003o`0000@00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000H000?o00002@000ol0
o`0600;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ol000060003o`0000T000?o0?l01@02oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o0000
1@000ol0000:0003o`3o00H00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000D000?o00002P000ol0o`0500;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P000ol000040003o`0000X00_l00`3oo`0500;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000040003o`0000X0
0_l00`3oo`0400;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000030003o`0001D00_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000<0
00?o00005002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00000P000ol0000F00;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000020003
o`0001D00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:0005o`000?l06@02oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000Go0000o`0H00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P001?l00?lJ00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`001?l00?lI00;o7]l0?onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0o`0K00;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ol0o`0J00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P02oa`00_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC00;o6`02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X0O?lC07co2`0002P00_n<00;oJ0000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@0007d00olg00CoD@03oa40001n0003o`0003L000?o0000DP000ol0
000@00002P02o`030?oo00<01Ol00`3oo`08o`800ol200Go0P03o`800_l00`3oo`0[00;o00<0ool0
2P000ol000080003o`0001P000Ko0000o`05o`030?oo00?o0P03o`801Ol00`3oo`02o`801Ol00`3o
o`03o`800ol200Go0P03o`801Ol200?o0P02o`030?oo00L00_l00`3oo`090003o`3o00T000?o0000
3`0000/000?o0?l00`001ol0003o0?l00`001Ol0003o00@000Co003o0`001Ol0003o00<000?o0?l0
0P000ol0000[0003o`3o00/000?o000020000ol0000H0007o`000?l0o`020003o`00008000?o0000
0P001?l00?l30005o`000?l00`001Ol0003o00D000Go0000o`030003o`3o008000Go0000o`020005
o`000?l00`001ol0003o0?l00P000ol000070003o`3o00/000?o000020000ol0000?00002`03o`<0
00Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000o`030003o`3o008000?o0000;0000ol0
000800Go1`000ol0o`0I0007o`3o0?l0o`020003o`00008000?o00000P000ol000040005o`000?l0
0`001Ol0003o00D000Go0000o`0500Co0`000ol000040005o`000?l00`000ol0o`020003o`0000P0
00?o00002005o`L000?o0?l0400000/000?o0?l00`001ol0003o0?l00`001Ol0003o00@000?o0000
10001Ol0003o00<000?o0?l00P000ol0000[0003o`3o00/000?o00001`000ol0o`0I0007o`3o0?l0
o`020003o`00008000?o00000P000ol000040005o`000?l00`001Ol0003o00D000Go0000o`030003
o`00008000Go0000o`060005o`000?l00`000ol0o`020003o`0000L000?o0?l02`000ol000070003
o`3o0100000<0003o`0000<01?l200Co0P02o`<01?l300;o1003o`030?oo00?o;002o`030?oo00X0
00?o00001P02o`030?oo01P00_l00`3oo`02o`030?oo00@000Co00001?l300;o0P05o`@000?o0000
0P02o`@01?l200?o0P04o`<00_l400?o00<0ool00ol800;o00<0ool04`02o`030?oo00l0000;00;o
20000ol000030003o`0000H000?o0000LP02o`<00_l80003o`00008000?o000040000ol0000D0003
o`0004H0000D00;o1002o`<000?o00000P000ol000040003o`0007P00ol40003o`0000@000?o0000
1`03o`D000?o00003P000ol000040003o`0003l0003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-5.95503, -0.231915, 0.0323772, 
  0.0323772}},
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "Now we form the same ring with ",
  StyleBox["CayleyForm", "MR"],
  " set to ",
  StyleBox["InputForm.", "MR"]
}], "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(piRing2 = 
      FormRingoid[Range[0, 2\ \[Pi], \[Pi]], 
        \[Pi]\ Mod[\(#1 + #2\)\/\[Pi], 3]&, 
        \[Pi]\ Mod[\(#1\ #2\)\/\[Pi]\^2, 3]&, CayleyForm \[Rule] InputForm]
        \)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"FormRingoid"],

Cell[BoxData[
    \(Ringoid[{0, \[Pi], 2\ \[Pi]}, "-Addition-", "-Multiplication-"]\)], 
  "Output",
  CellLabel->"Out[11]=",
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "Now \[Pi] is displayed as ",
  StyleBox["Pi", "MR"],
  " in the Cayley tables."
}], "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[piRing2, Mode \[Rule] Visual]; \)\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"FormRingoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(Pi)] .61905 .62202 0 0 Mshowa
[(2*Pi)] .85714 .62202 0 0 Mshowa
[(Pi)] .38095 .38393 0 0 Mshowa
[(2*Pi)] .61905 .38393 0 0 Mshowa
[(0)] .85714 .38393 0 0 Mshowa
[(2*Pi)] .38095 .14583 0 0 Mshowa
[(0)] .61905 .14583 0 0 Mshowa
[(Pi)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(Pi)] .14286 .38393 0 0 Mshowa
[(2*Pi)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(Pi)] .61905 .86012 0 0 Mshowa
[(2*Pi)] .85714 .86012 0 0 Mshowa
[(Addition)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 .5 0 r
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(0)] .61905 .62202 0 0 Mshowa
[(0)] .85714 .62202 0 0 Mshowa
[(0)] .38095 .38393 0 0 Mshowa
[(Pi)] .61905 .38393 0 0 Mshowa
[(2*Pi)] .85714 .38393 0 0 Mshowa
[(0)] .38095 .14583 0 0 Mshowa
[(2*Pi)] .61905 .14583 0 0 Mshowa
[(Pi)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(Pi)] .14286 .38393 0 0 Mshowa
[(2*Pi)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(Pi)] .61905 .86012 0 0 Mshowa
[(2*Pi)] .85714 .86012 0 0 Mshowa
[(Multiplication)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0
000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO
03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000M
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;0000
2P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0o
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:0004ooAnm0Co
00Mnm7kdO_An00?o00Anm7kd1Ol00oAnm002o`03O_An00Co00OdO_Anm7kd00?o00CdO_An1Ol01Gkd
O_Co00gO0_l?g`09oenOGimOWenO00?o00BOGimO1Ol02UnOGimOWenOGolC0004ogkdOPCo00OdO_An
m7kd00?o00CdO_An1Ol017kdool>g`;o3]l01OodO_An00Co00OdO_Anm7kd00?o00CdO_An1Ol03Gkd
O_mOWenOGimOWel00ol015nOGil5o`0:WenOGimOWenOo`/0000:000NogiaOW7oLGiaOW5nLGiaO_mn
LGiaOW5nogiaOW5n0_l07g5nLGkoOW5nLGiaOW5nLOmaOW5nLGiaog5nLGiaO_l03=l01?oOgol>g`0O
oenOGimOWenOGomOWenOGimOoenOGimOWenOGimOo`0C000Mog5nLGkoOW5nLGiaOW5nLOmaOW5nLGia
og5nLGh00_l=g`04omoOo`gO03ooOW5nLGkoOW5nLGiaOW5nLOmaOW5nLGiaog5nLGiaoenOGimOWenO
GiooWenOGimOWonOGimOWenOGimOWol02`0000X0013om7kdO_Com7kdO_mnogkd0ol02oAnm7kdooAn
m7kd00;o00mnm7kdO_mnm7kdooCom7h00ol03GkdO_AnogkdO_Anm?l03=l01?oOgol>g`0:oenOGimO
WenOG`?o019OWenOGomOWenOGimOWenOGolC000@ogkdO_AnogkdO_Com?odOP?o00Ynm7kdO_mnm7kd
0_l=g`04omoOo`gO017om7kdO_AnogkdO_Com?odOP03o`0FO_Anm7koO_Anm7koGimOWenOGimOW`?o
01:OGimOWonOGimOWenOGimOWol;00002P007_mnLGiaOW7oLGiaO_mnLGkoOW7oLGiaO_mnLGiaOP;o
01maOW5nLGkoOW5nLOmaOW7oLGkoOW5nLOmaOW5nLGko00cO00Cogmoo3]l07omOWenOGimOWeooGioo
WenOGomOWenOGimOWenOGol04`007OmaOW5nLGkoOW5nLOmaOW7oLGkoOW5nLOmaOW5n00;o3Ml01?oO
gol=g`0oogiaOW5nLGkoOW5nLOmaOW7oLGkoOW5nLOmaOW5nLOmOWenOGimOWenOoimOoenOGiooWenO
GimOWenOGioo00/0000:000:ooAnm?odO_mnm0Go00SdooAnogkdOP;o00GdO_Anm002o`09O_Anogkd
ooAn00Go00QnogkdooAnm0;o00Mnm7kdO_Co00cO00Cogmoo3]l04OmOWenOGimOWeooGiooWenO00;o
00aOWenOGimOWenOGolC000:ogkdO_mnm?odOPGo00QnogkdooAnm0;o00Anm7kd0_l=g`04omoOo`gO
00_om7kdO_mnm?odOP05o`08O_mnm?odO_@2o`0GO_Anm7koGimOWenOGimOWonOGomOWel00_l039mO
WenOGimOWenOo`/0000:0005ogiaOW400_l027iaOW5nogia1?l02giaOW5nLGiaOW5n00;o00AaOW5n
0_l0275nLGiaog5n1?l03G5nLGiaOW5nLGiaO_l03Ml2o`oO00WoGimOWenOGil01?l04UnOGimOWenO
GimOWenOGimOoa<000GoLGiaOP02o`08LGiaOW7oLGh4o`0:LGiaOW5nLGiaOP;o3]l2o`kO00KoOW5n
LGh2o`08LGiaOW7oLGh4o`0ELGiaOW5nLGiaOW7oGimOWenOGimO00Co01:OGimOWenOGimOWenOGimO
Wol;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mnm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWeooGimOWenOGimOWeoo01<001goO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anogkd
O_AnoenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
4`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO
01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0O
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000N
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o
7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<0
01goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0O
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00/0000:07co4`1lo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:0009oimOWenOGimO00?o00AOWenO1Ol02ImOWenOGimOW`02o`08
GimOWenOGil3o`04WenOG`Go00iOWenOGimOWenOogiaOPCo00MaOW5nLGia00?o00AaOW5n1Ol01Gia
OW7o00gO0_l>g`03o`00014000WoGimOWenOGil00ol019mOWel5o`08GimOWenOGil2o`kO0_l>g`0:
oimOWenOGimOW`?o00BOGimO1Ol03UnOGimOWenOGomaOW5n1?l01g5nLGiaOW400ol0175nLGh5o`04
OW5no`/0000:000NoimOWenOGimOWonOGimOWenOoimOWenOGimOWenO0_l0?UnOGimOWenOGomOWenO
GimOoenOGimOWenOGimOWoodO_AnogkdO_Anm7kdO_Com7kdO_Anm?odO_Anm7ko3=l01?oOgol=g`03
o`00014001goGimOWenOGimOoenOGimOWeooGimOWenOGimOW`02o`gO00Cogmoo3Ml0?onOGimOWenO
GimOoenOGimOWeooGimOWenOGimOWeooO_Anm7koO_Anm7kdO_Anm?odO_Anm7kdooAnm7kdo`0;0000
2P002_nOGimOWenOGil3o`0AWenOGiooWenOGimOWenOGil00_l02EnOGimOWenOG`03o`0RGimOWeoo
GimOWenOGimOWenOogiaOW5nogiaOW7oLOmaOP?o00enLGiaO_mnLGiaOW7o00cO00Cogmoo3Ml00ol0
000A000:oenOGimOWenOG`?o011OWenOGomOWenOGimOWenO0_l=g`04omoOo`gO00_oWenOGimOWenO
G`03o`0RGimOWeooGimOWenOGimOWeooLGiaOW5nogiaOW7oLOmaOP?o00anLGiaO_mnLGiaO_l;0000
2P007_nOGimOWenOGiooWeooGimOWonOGimOWenOGimOW`;o03iOWenOGimOWeooGiooWenOGomOWenO
GimOWenOGioom7kdO_AnogkdO_Com7kdooAnogkdO_Com7kdO_Ano`cO00Cogmoo3Ml00ol0000A000M
oenOGimOWenOGomOWonOGimOoenOGimOWenOGil00_l=g`04omoOo`gO03ooWenOGimOWenOGomOWonO
GimOoenOGimOWenOGimOogkdO_Anm7koO_Anm?odO_Com7koO_Anm?odO_Anm?l02`0000X0017oWenO
GimOWenOoimOoenOG`02o`0;WenOGimOWenOGil00_l045nOGimOWenOGomOWonOGil2o`0FGimOWenO
GimOWenOogiaO_mnLOmaOPGo00Qnogiaog5nL@;o00MnLGiaOW7o00cO00Cogmoo3Ml00ol0000A000A
oenOGimOWenOGomOWonOGil00_l02UnOGimOWenOGil2o`gO00Cogmoo3Ml04_nOGimOWenOGimOoenO
oimOW`;o01IOWenOGimOWenOGomaOW5nogiaog5n1Ol027koOW7oLGia0_l01WiaOW5no`/0000:0009
oimOWenOGimO00Co016OGimOWenOGimOWenOGimOW`02o`08GimOWenOGil4o`0GGimOWenOGimOWenO
GimOWenOooAnm7h00_l02?Anm7kdooAn1?l03OAnm7kdO_Anm7kdO_l03Ml2o`kO00?o00004@002OmO
WenOGimOW`04o`0@GimOWenOGimOWenOGimOW`;o3]l2o`kO00[oWenOGimOWenO1?l05enOGimOWenO
GimOWenOGimOogkdO_An00;o00SdO_Anm?odOPCo00cdO_Anm7kdO_Anm?l;00002P007_nOGimOWenO
GimOWenOGimOWonOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGomOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGomO
WenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWeooGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nogiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;0000
2P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimO
WenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o0000
4@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;0000
2P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimO
WenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o
7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o0000
4@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimO
WenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P1loa<0O?l;00002P000ooOg`0Kg`;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooO
g`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml0
6]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O
0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o
7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO
00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03
omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooO
g`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml0
7=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO
00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03
omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooO
g`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml0
7=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO
00?o00002@0000X000?ogml02ml2o`kO0_l=g`;o3ml02OnOGimOWenOG`03o`04GimOW`Go00jOGimO
WenOGimOogkdOPCo00OdO_Anm7kd00?o00CdO_An1Ol017kdO_lC0003omoO00_O0_l=g`;o3]l2o`kO
00?ogml03=l2o`kO00?ogml03=l2o`kO00?o00002@0000X000?ogml02]l01?oOgol=g`;o3=l01?oO
gol>g`0noimOWenOGimOWonOGimOWenOoimOWenOGimOWenOGomaOW5nogiaOW5nLGiaOW7oLGiaOW5n
LOmaOW5nLOlC0003omoO00[O00Cogmoo3=l2o`gO00Cogmoo3Ml00ooOg`0;g`04omoOo`gO00?ogml0
2ml01?oOgol=g`03o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l02_nOGimOWenO
Gil3o`0RWenOGiooWenOGimOWenOGimOogkdO_AnogkdO_Com?odOP?o00anm7kdO_mnm7kdO_lC0003
omoO00[O00Cogmoo3=l2o`gO00Cogmoo3Ml00ooOg`0;g`04omoOo`gO00?ogml02ml01?oOgol=g`03
o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l0?_nOGimOWenOGiooWeooGimOWonO
GimOWenOGimOWeooLGiaOW5nogiaOW7oLGiaog5nogiaOW7oLGiaOW7o4`000ooOg`0:g`04omoOo`cO
0_l=g`04omoOo`gO00?ogml02ml01?oOgol=g`03omoO00_O00Cogmoo3Ml00ol0000900002P000ooO
g`0:g`04omoOo`gO0_l<g`04omoOo`kO017oWenOGimOWenOoimOoenOG`02o`0FWenOGimOWenOGimO
ogkdO_mnm?odOPGo00QnogkdooAnm0;o00Inm7kdO_lC0003omoO00[O00Cogmoo3=l2o`gO00Cogmoo
3Ml00ooOg`0;g`04omoOo`gO00?ogml02ml01?oOgol=g`03o`0000T0000:0003omoO00_O0_l>g`;o
3Ml2o`oO00WoWenOGimOWel01?l05imOWenOGimOWenOGimOWenOGomaOW5n00;o00QaOW5nLOmaOPCo
00aaOW5nLGiaOW5nLOlC0003omoO00_O0_l=g`;o3]l2o`kO00?ogml03=l2o`kO00?ogml03=l2o`kO
00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03
o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0
000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o0000
2@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0
000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol000090000
2P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X0
00?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003
omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml0
6ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002@1moa80OOl;0000
2@1moa80OOl;00002P000ol0000J00?o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol0000J00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0
000I0004o`3ooakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoa<000?o00006@03oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o000060000ol00002oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<000?o000060001?l0oolNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003o`0001L000Co00000_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003
o`0001L000?o00000_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0001H000?o00000P02oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o0000
5P001?l00002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o00005@000ol0000300;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol0000E0003
o`0000800_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000@00_l00`3oo`0;0003o`0000@00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
o`0000@00_l00`3oo`0;0003o`0000<00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003o`0000D000?o0?l02`000ol0
000500;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko4`000ol000050003o`3o00/000?o00001002oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o0000
1P000ol000090003o`0000H00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000H000?o00002@000ol0000500;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0;00002P000ol000050003o`3o00T000?o00001`02oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00001@000ol0o`090003
o`0000H00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000@00_l00`3oo`070003o`0000P00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
o`0000@00_l00`3oo`070003o`0000L00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:0003o`0000l000?o00002@02oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anoa<000?o00003`000ol0000800;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ol0000>0003o`0000X00_l=g`;o
3ml02OnOGimOWenOG`03o`04GimOW`Go00jOGimOWenOGimOog5nL@Co00MnLGiaOW5n00?o00AnLGia
1Ol0175nLOlC0003o`0000h000?o00002@02o`kO0_l>g`0:oimOWenOGimOW`?o00BOGimO1Ol03UnO
GimOWenOGomaOW5n1?l01g5nLGiaOW400ol0175nLGh5o`04OW5no`/0000:0003o`0000d000?o0000
2`02o`cO00Cogmoo3]l0?_nOGimOWenOGiooWenOGimOWonOGimOWenOGimOWeooO_Anm?odO_Anm7kd
O_AnogkdO_Anm7koO_Anm7ko4`000ol0000=0003o`0000X00_l=g`04omoOo`gO03ooWenOGimOWenO
GomOWenOGimOoenOGimOWenOGimOogkdO_AnogkdO_Anm7kdO_Com7kdO_Anm?odO_Anm?l02`0000X0
00?o000030000ol0000<00;o3=l01?oOgol>g`0:oimOWenOGimOW`?o02:OGimOWonOGimOWenOGimO
WeooLGiaOW7oLGiaO_mnogia0ol0375nLGiaog5nLGiaoa<000?o000030000ol0000;00;o3Ml01?oO
gol=g`0;oimOWenOGimOWel00ol08UnOGimOoenOGimOWenOGimOog5nLGiaO_mnLGiaog7oLGh3o`0<
OW5nLGkoOW5nLGko2`0000X000?o00002`000ol0000=00;o3=l01?oOgol>g`0noimOWenOGimOWonO
GomOWenOoimOWenOGimOWenOGomnm7kdO_Com7kdO_mnm7koO_Com7kdO_mnm7kdO_lC0003o`0000/0
00?o00003002o`gO00Cogmoo3Ml0?onOGimOWenOGimOoenOoimOWeooGimOWenOGimOWeooO_Anm7kd
O_mnm7kdooAnm?odO_mnm7kdooAnm7kdo`0;00002P000ol0000:0003o`0000@00ol700;o3=l01?oO
gol>g`0AoimOWenOGimOWonOGomOWel00_l05YmOWenOGimOWenOGomaOW7oLGkoOW45o`08LOmaO_mn
LGh2o`06LGiaOW7o4`000ol0000:0003o`0000@00ol600;o3Ml01?oOgol=g`0BoimOWenOGimOWeoo
GiooWenO0_l05UnOGimOWenOGimOog5nLGkoOW7oLGh5o`08O_mnLOmaOW42o`06OW5nLGko2`0000X0
00?o00002@000ol000060003o`0000H00_l=g`;o3ml02OnOGimOWenOG`04o`0GWenOGimOWenOGimO
WenOGimOogkdO_@00_l027kdO_Anogkd1?l037kdO_Anm7kdO_Anoa<000?o00002@000ol000060003
o`0000D00_l>g`;o3]l02_nOGimOWenOGil4o`0GGimOWenOGimOWenOGimOWeooO_Anm7h00_l02?An
m7kdooAn1?l03?Anm7kdO_Anm7kdo`/0000:0003o`0000P000?o000020000ol0000500;o7]l0?_nO
GimOWenOGimOWenOGimOWonOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaOW7o
4`000ol000080003o`0000P000?o00001002oakO03ooWenOGimOWenOGimOWenOGimOoenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaO_l02`0000X000?o00001`000ol000090003
o`0000D00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003o`0000L000?o00002@000ol0000400;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ol0
00060003o`0000T000?o0?l01P02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00001P000ol000090003o`3o00D00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:0003o`0000D000?o00002P000ol0o`0600;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol000050003o`0000X0
00?o0?l01@02oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o000010000ol0000:00;o00<0ool01@02oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<0
00?o000010000ol0000:00;o00<0ool01002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o00000`000ol0000E00;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ol000030003o`0001@00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`00008000?o00005P02oakO
03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoa<000?o00000P000ol0000E00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P001Ol0003o01T00_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0005
o`000?l06002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X000Co003o6P02oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000Co003o6@02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o0?l06`02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o0?l06P02oakO03ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X00_lL00;o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
4`02oa/00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:07co4`1lo`/0000X00;oS002ofP0003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240001m00?o=`04oe400olA0000OP000ol0
000g0003o`00058000?o0000400000X00_l00`3oo`0300Go00<0ool02?l200?o0P05o`800ol200;o
00<0ool0:`02o`030?oo00X000?o000020000ol0000H0006o`000?l01Ol00`3oo`03o`800ol200Go
00<0ool00_l200Go00<0ool00ol200?o0P05o`800ol200Go0P03o`800_l00`3oo`0700;o00<0ool0
2@000ol0o`090003o`0000l0000;0003o`3o00<000Oo0000o`3o00<000Go0000o`040004o`00o`<0
00Go0000o`030003o`3o008000?o0000:`000ol0o`0;0003o`0000P000?o000060001ol0003o0?l0
0P000ol000020003o`00008000Co003o0`001Ol0003o00<000Go0000o`050005o`000?l00`000ol0
o`020005o`000?l00P001Ol0003o00<000Oo0000o`3o008000?o00001`000ol0o`0;0003o`0000P0
00?o00003`0000/00ol30007o`000?l0o`030005o`000?l010000ol000040005o`000?l00`000ol0
o`020003o`0002`000?o00002005o`L000?o0?l06@001ol0o`3o0?l00P000ol000020003o`000080
00?o000010001Ol0003o00<000Go0000o`050005o`000?l01@04o`<000?o000010001Ol0003o00<0
00?o0?l00P000ol000080003o`0000P01Ol70003o`3o0100000;0003o`3o00<000Oo0000o`3o00<0
00Go0000o`040003o`0000@000Go0000o`030003o`3o008000?o0000:`000ol0o`0;0003o`0000L0
00?o0?l06@001ol0o`3o0?l00P000ol000020003o`00008000?o000010001Ol0003o00<000Go0000
o`050005o`000?l00`000ol000020005o`000?l01P001Ol0003o00<000?o0?l00P000ol000070003
o`3o00/000?o00001`000ol0o`0@000030000ol0000300Co0P04o`800_l300Co0`02o`@00ol00`3o
o`03ob`00_l00`3oo`0:0003o`0000H00_l00`3oo`0H00;o00<0ool00_l00`3oo`040004o`0000Co
0`02o`801Ol40003o`0000800_l400Co0P03o`801?l300;o1003o`030?oo00?o2002o`030?oo01<0
0_l00`3oo`0?00002`02o`P000?o00000`000ol000060003o`0007800_l300;o20000ol000020003
o`00010000?o000050000ol0001600005002o`@00_l30003o`00008000?o000010000ol0001h00?o
10000ol000040003o`0000L00ol50003o`0000h000?o000010000ol0000o0000o`0Q0000o`0Q0000
o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-5.95503, -0.231915, 0.0323772, 
  0.0323772}},
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "By using the option ",
  StyleBox["CayleyForm", "MR"],
  " with the ",
  StyleBox["CayleyTables", "MR"],
  " function, we can always override any preset value. Here we override ",
  StyleBox["piRing2", "MR"],
  "\[CloseCurlyQuote]s ",
  StyleBox["CayleyForm", "MR"],
  " value of ",
  StyleBox["InputForm", "MR"],
  "."
}], "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[piRing2, Mode \[Rule] Visual, \ 
      CayleyForm\  \[Rule] \ TraditionalForm]; \)\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"FormRingoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .53571 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0127551 0.47619 [
[ 0 0 0 0 ]
[ 1 .53571 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .53571 L
0 .53571 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0127551 0.477324 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 .5 0 r
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
gsave
.38095 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .62202 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.61905 .38393 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.85714 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.38095 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.61905 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.85714 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.14286 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .86012 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(Addition)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0127551 0.97619 0.522959 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
1 .5 0 r
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.56 .37 .6 r
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
1 1 0 r
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
gsave
.38095 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.85714 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.38095 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .38393 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.85714 .14583 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .62202 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.14286 .38393 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.14286 .14583 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
gsave
.38095 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.61905 .86012 -84 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
grestore
gsave
.85714 .86012 -88.3125 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
89.625000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(p) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(Multiplication)] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 154.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000VPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0
000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO
03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000M
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;0000
2P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0o
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l07g5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:0009ooAnm7kd
O_An00Co017dO_AnogkdO_Com7kdO_Anm002o`08O_Anm7kdO_@4o`0CO_Anm?odO_AnogkdO_Anm7kd
o`0=g`;o3ml07omOWenOGimOWenOGomOWenOoimOWenOGimOWenOGol04`002Omnm7kdO_Anm004o`0@
O_AnogkdO_Com7kdO_Anm0;o3]l2o`kO00Wom7kdO_Anm7h01?l0<_Anm7koO_Anm?odO_Anm7kdO_mO
WenOGimOWenOGiooWenOGomOWenOGimOWenOGioo2`0000X001koOW5nLGiaOW5nogiaOW5nLGkoOW7o
LGiaOW5nLGh2o`0OLGiaOW5nLGiaog5nLGiaOW7oLGkoOW5nLGiaOW5no`0<g`04omoOo`kO01ooGimO
WenOGimOWenOoimOoenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaog5nLGiaO_mnLOmaOW5nLGia
OP02o`gO00Cogmoo3Ml0?omnLGiaOW5nLGkoOW5nLGiaO_mnLOmaOW5nLGiaOW7oGimOWenOGimOWenO
GomOWonOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_AnogkdO_Anm7koO_mnm7kdO_Anm0;o
01mnm7kdO_Anm7kdooAnm7kdO_Com?odO_Anm7kdO_Co00cO00Cogmoo3]l07omOWenOGimOWenOGimO
oeooGimOWenOGimOWenOGol04`007Omnm7kdO_Anm7kdooAnm7kdO_mnogkdO_Anm7kd00;o3Ml01?oO
gol=g`0oooAnm7kdO_Anm7koO_Anm7kdO_mnogkdO_Anm7kdO_mOWenOGimOWenOGimOWonOoimOWenO
GimOWenOGioo00/0000:000NogiaOW5nLGiaOW5nogiaOW5nLOmaog5nLGiaOW5n0_l07g5nLGiaOW5n
LGiaog5nLGiaO_mnogiaOW5nLGiaO_l03=l01?oOgol>g`0OoenOGimOWenOGimOWeooGomOWenOGimO
WenOGimOo`0C000Mog5nLGiaOW5nLGiaog5nLGiaog7oLGiaOW5nLGh00_l=g`04omoOo`gO03ooOW5n
LGiaOW5nLGkoOW5nLGiaog7oLGiaOW5nLGiaoenOGimOWenOGimOWenOoiooWenOGimOWenOGimOWol0
2`0000X001;om7kdO_Anm7koO_Com7kdO_@5o`07m7kdO_Anm002o`0AO_Anm7kdO_Com7koO_Anm7h0
1Ol02GkdO_Anm7kdo`0<g`04omoOo`kO00goGimOWenOGimOWenO00Go00fOGimOWenOGimOWeoo01<0
017oO_Anm7kdO_Com7koO_Anm005o`07m7kdO_Anm002o`gO00Cogmoo3Ml04_odO_Anm7kdO_mnm?od
O_Anm0Go01KdO_Anm7kdO_mOWenOGimOWenOGimO1Ol03EnOGimOWenOGimOWol02`0000X000[oOW5n
LGiaOW5n0_l04W5nLGiaOW5nLGiaOW5nLGiaOP;o00UaOW5nLGiaOW400_l057iaOW5nLGiaOW5nLGia
OW5nLGko3Ml2o`oO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<000[oLGiaOW5nLGia
0_l04GiaOW5nLGiaOW5nLGiaOW5n00;o3]l2o`kO00[oOW5nLGiaOW5n0_l0<g5nLGiaOW5nLGiaOW5n
LGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01kO01ooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_lNg`0oogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l0
7]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol04`007Omnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o
01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO01ooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02oakO03ooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X0
01kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0OO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0C000MogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:000NogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n0_l07g5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l07]l07omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol04`007OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o7]l0?omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
o`0;00002P007_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01mnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co01kO01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002oakO03oom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol02`0000X001koOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGh2o`0OLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0Ng`0OoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0C000Mog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh0
0_lNg`0oogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00/0000:000NooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l07gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l07]l07omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
4`007Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o7]l0?oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOo`0;00002P007_mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01kO
01ooGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo01<001goLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOP02oakO03ooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol02`0000X001kom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0O
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0Ng`0OoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0C000MogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_lNg`0oooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00/0000:07co
4`1lo`/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00/0000:000N
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000MoenOGimOWenOGimO
WenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0o
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko7Ml00ol0000A000M
oenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000NoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0?UnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimO
WenOGil00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0?UnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
7Ml00ol0000A000MoenOGimOWenOGimOWenOGimOWenOGimOWenOGil00_lNg`0ooimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:000N
oimOWenOGimOWenOoimOWeooGimOWenOGimOWenO0_l09enOGimOWenOGimOoenOGiooWenOGimOWenO
GimOWomnLGiaOW5nL@04o`0COW5nogiaOW7oLGiaOW5nLGiao`0=g`;o3]l00ol0000A000MoenOGimO
WenOGimOoenOGiooWenOGimOWenOGil00_l>g`;o3]l0:?nOGimOWenOGimOWeooGimOWonOGimOWenO
GimOWeooLGiaOW5nLGh4o`0CLGiaO_mnLGiaog5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWeoo
GiooWenOGimOWenOGimOW`;o03iOWenOGimOWenOGiooWeooGimOWenOGimOWenOGioom7kdO_Anm7kd
ooAnm7kdO_mnm?odO_Anm7kdO_Ano`cO00Cogmoo3Ml00ol0000A000MoenOGimOWenOGimOWonOGomO
WenOGimOWenOGil00_l=g`04omoOo`gO03ooWenOGimOWenOGimOWonOGomOWenOGimOWenOGimOogkd
O_Anm7kdO_mnm7kdO_AnogkdooAnm7kdO_Anm?l02`0000X001koWenOGimOWenOGimOWonOoimOWenO
GimOWenOGil2o`0nGimOWenOGimOWenOGomOoenOGimOWenOGimOWenOogiaOW5nLGiaOW7oLGiaOW5n
ogkoOW5nLGiaOW5nLOl<g`04omoOo`gO00?o00004@007OmOWenOGimOWenOGimOoeooGimOWenOGimO
WenO00;o3Ml01?oOgol=g`0ooimOWenOGimOWenOGimOoeooGimOWenOGimOWenOGomaOW5nLGiaOW5n
ogiaOW5nLGkoO_mnLGiaOW5nLGko00/0000:000NoimOWenOGimOWenOGiooWonOGimOWenOGimOWenO
0_l0?UnOGimOWenOGimOWeooGomOWenOGimOWenOGimOWoodO_Anm7kdO_Anm?odO_Anm?odooAnm7kd
O_Anm7ko3=l01?oOgol=g`03o`00014001goGimOWenOGimOWenOGomOoenOGimOWenOGimOW`02o`gO
00Cogmoo3Ml0?onOGimOWenOGimOWenOGomOoenOGimOWenOGimOWeooO_Anm7kdO_Anm7koO_Anm7kd
ooCom7kdO_Anm7kdo`0;00002P003OnOGimOWenOGimOWel01Ol035nOGimOWenOGimOW`;o00aOWenO
GimOWenOGil5o`0NWenOGimOWenOGimOWomnLGiaOW5nLOmaO_mnLGia1Ol02W5nLGiaOW5nLOl<g`04
omoOo`gO00?o00004@003OmOWenOGimOWenOGil01Ol02imOWenOGimOWenO00;o3Ml01?oOgol=g`0>
oimOWenOGimOWenOGil5o`0NWenOGimOWenOGimOog5nLGiaOW5nogiaog5nLGia1Ol02G5nLGiaOW5n
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o02QOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kd0_l057kdO_Anm7kdO_Anm7kdO_Anm7ko3Ml2o`kO00?o0000
4@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o3]l2o`kO02WoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdOP02o`0Dm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
o`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO00?o00004@007OmO
WenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimO
WenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5no`0;00002P007_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoagO
00?o00004@007OmOWenOGimOWenOGimOWenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P007_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o03iOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoagO00?o00004@007OmOWenOGimOWenOGimO
WenOGimOWenOGimOWenO00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P1loa<0O?l;00002P000ooOg`0Kg`;o7]l0?_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003
omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooO
g`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml0
6]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O
0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o
7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO
00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03
omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooO
g`0Lg`03omoO01cO00?o00002@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml0
7=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO
00?ogml07=l00ol0000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03
omoO01cO00?o00002@0000X000?ogml02ml2o`kO0_l=g`;o3ml0:?nOGimOWenOGimOWonOGimOoenO
GimOWenOGimOWeooO_Anm7kdO_@4o`0BO_AnogkdO_Com7kdO_Anm7ko4`000ooOg`0;g`;o3Ml2o`kO
0_l>g`03omoO00cO0_l>g`03omoO00cO0_l>g`03o`0000T0000:0003omoO00[O00Cogmoo3Ml2o`cO
00Cogmoo3]l0?_nOGimOWenOGimOWeooGiooWenOGimOWenOGimOWeooLGiaOW5nLGiaog5nLGiaO_mn
LOmaOW5nLGiaOW7o4`000ooOg`0:g`04omoOo`cO0_l=g`04omoOo`gO00?ogml02ml01?oOgol=g`03
omoO00_O00Cogmoo3Ml00ol0000900002P000ooOg`0:g`04omoOo`gO0_l<g`04omoOo`kO03koWenO
GimOWenOGimOWonOoimOWenOGimOWenOGimOogkdO_Anm7kdO_Com7kdO_AnogkoO_Anm7kdO_Anoa<0
00?ogml02]l01?oOgol<g`;o3Ml01?oOgol=g`03omoO00_O00Cogmoo3Ml00ooOg`0;g`04omoOo`gO
00?o00002@0000X000?ogml02]l01?oOgol=g`;o3=l01?oOgol>g`0noimOWenOGimOWenOGiooWonO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLOmaOW5nLOmaog5nLGiaOW5nLOlC0003omoO00[O00Cogmoo
3=l2o`gO00Cogmoo3Ml00ooOg`0;g`04omoOo`gO00?ogml02ml01?oOgol=g`03o`0000T0000:0003
omoO00[O00Cogmoo3Ml2o`cO00Cogmoo3]l03OnOGimOWenOGimOWel01Ol07UnOGimOWenOGimOWeoo
O_Anm7kdO_Com7koO_Anm0Go00WdO_Anm7kdO_l04`000ooOg`0:g`04omoOo`cO0_l=g`04omoOo`gO
00?ogml02ml01?oOgol=g`03omoO00_O00Cogmoo3Ml00ol0000900002P000ooOg`0;g`;o3]l2o`gO
0_l?g`0YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW400_l04giaOW5nLGia
OW5nLGiaOW5nLOl04`000ooOg`0;g`;o3Ml2o`kO0_l>g`03omoO00cO0_l>g`03omoO00cO0_l>g`03
o`0000T0000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0
000900002P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o0000
2@0000X000?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0
000:0003omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol000090000
2P000ooOg`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X0
00?ogml06ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003
omoO01_O0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooO
g`0Kg`;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000X000?ogml0
6ml2oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?ogml06]l2oakO00?ogml07=l00ooOg`0Lg`03o`0000T0000:0003omoO01_O
0_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlC0003omoO01[O0_lNg`03omoO01cO00?ogml07=l00ol0000900002P000ooOg`0Kg`;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ooOg`0Jg`;o7]l00ooOg`0Lg`03omoO01cO00?o00002@0000T0OOlB07go2`0000T0
OOlB07go2`0000X000?o00006P03oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?o00006P02oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o0000
6@001?l0oolNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lC0003o`0001T00olNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0001P000?o00000_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlC0003o`0001P000Co0?oo7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000G0004o`0000;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000ol0
000G0003o`0000;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P000ol0000F0003o`0000800_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0001H0
00Co00000_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:0003o`0001D000?o00000`02oakO03koWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?o00005@000ol0
000200;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P000ol0000400;o00<0ool02`000ol0000400;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol0
000400;o00<0ool02`000ol0000300;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000050003o`3o00/000?o0000
1@02oakO03koWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoa<000?o00001@000ol0o`0;0003o`0000@00_lNg`0ooimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000H0
00?o00002@000ol0000600;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000060003o`0000T000?o00001@02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X000?o00001@000ol0o`090003o`0000L00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000D000?o0?l02@000ol0
000600;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0;00002P000ol0000400;o00<0ool01`000ol0000800;o7]l0?_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol0
000400;o00<0ool01`000ol0000700;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0000?0003o`0000T00_lNg`0n
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lC0003o`0000l000?o00002002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00003P000ol0000:00;o3Ml2o`oO
02SoWenOGimOWenOGiooWenOGomOWenOGimOWenOGimOog5nLGiaOW5n1?l04W5nLOmaOW5nogiaOW5n
LGiaoa<000?o00003P000ol0000900;o3]l2o`kO02SoWenOGimOWenOGimOoenOGiooWenOGimOWenO
GimOog5nLGiaOW5n1?l04g5nLGkoOW5nLOmaOW5nLGiaO_l02`0000X000?o00003@000ol0000;00;o
3=l01?oOgol>g`0noimOWenOGimOWenOGomOWonOGimOWenOGimOWenOGomnm7kdO_Anm7koO_Anm7kd
ooAnogkdO_Anm7kdO_lC0003o`0000d000?o00002P02o`gO00Cogmoo3Ml0?onOGimOWenOGimOWenO
oimOoenOGimOWenOGimOWeooO_Anm7kdO_AnogkdO_Anm7koO_Com7kdO_Anm7kdo`0;00002P000ol0
000<0003o`0000`00_l<g`04omoOo`kO03koWenOGimOWenOGimOWonOoimOWenOGimOWenOGimOog5n
LGiaOW5nLGkoOW5nLGiaog7oLGiaOW5nLGiaoa<000?o000030000ol0000;00;o3Ml01?oOgol=g`0o
oimOWenOGimOWenOGimOoeooGimOWenOGimOWenOGomaOW5nLGiaOW5nogiaOW5nLGkoO_mnLGiaOW5n
LGko00/0000:0003o`0000/000?o00003@02o`cO00Cogmoo3]l0?_nOGimOWenOGimOWenOoiooWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7koO_Anm7koO_mnm7kdO_Anm7ko4`000ol0000;0003o`0000`0
0_l=g`04omoOo`gO03ooWenOGimOWenOGimOWeooGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anogkd
O_Anm?odooAnm7kdO_Anm?l02`0000X000?o00002P000ol0000400?o1`02o`cO00Cogmoo3]l03OnO
GimOWenOGimOWel01Ol07UnOGimOWenOGimOWeooLGiaOW5nLGkoOW7oLGiaOPGo00UnLGiaOW5nLOl0
4`000ol0000:0003o`0000@00ol600;o3Ml01?oOgol=g`0>oimOWenOGimOWenOGil5o`0NWenOGimO
WenOGimOog5nLGiaOW5nogiaog5nLGia1Ol02G5nLGiaOW5no`0;00002P000ol000090003o`0000H0
00?o00001P02o`gO0_l?g`0YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7h0
0_l04oAnm7kdO_Anm7kdO_Anm7kdO_l04`000ol000090003o`0000H000?o00001@02o`kO0_l>g`0Y
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7h00_l05?Anm7kdO_Anm7kdO_An
m7kdO_Co2`0000X000?o000020000ol000080003o`0000D00_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC0003o`0000P000?o0000
20000ol0000400;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000070003o`0000T000?o00001@02oakO03koWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<0
00?o00001`000ol000090003o`0000@00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co00/0000:0003o`0000H000?o00002@000ol0
o`0600;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o4`000ol000060003o`0000T000?o0?l01@02oakO03ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l02`0000X000?o0000
1@000ol0000:0003o`3o00H00_lNg`0noimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000D000?o00002P000ol0o`0500;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P000ol000040003o`0000X00_l00`3oo`0500;o7]l0?_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000040003o`0000X0
0_l00`3oo`0400;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol000030003o`0001D00_lNg`0noimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003o`0000<0
00?o00005002oakO03ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm?l02`0000X000?o00000P000ol0000F00;o7]l0?_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000ol000020003
o`0001D00_lNg`0ooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko00/0000:0005o`000?l06@02oakO03koWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000Go0000o`0H00;o7]l0?onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
o`0;00002P001?l00?lJ00;o7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`001?l00?lI00;o7]l0?onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0;00002P000ol0o`0K00;o
7]l0?_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko4`000ol0o`0J00;o7]l0?onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0;00002P02oa`00_lNg`0noimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlC00;o6`02oakO03ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
2`0000X0O?lC07co2`0002P00_n<00;oJ0000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@0007d00olg00CoD@03oa40001n0003o`0003L000?o0000DP000ol0
000@00002P02o`030?oo00<01Ol00`3oo`08o`800ol200Go0P03o`800_l00`3oo`0[00;o00<0ool0
2P000ol000080003o`0001P000Ko0000o`05o`030?oo00?o0P03o`801Ol00`3oo`02o`801Ol00`3o
o`03o`800ol200Go0P03o`801Ol200?o0P02o`030?oo00L00_l00`3oo`090003o`3o00T000?o0000
3`0000/000?o0?l00`001ol0003o0?l00`001Ol0003o00@000Co003o0`001Ol0003o00<000?o0?l0
0P000ol0000[0003o`3o00/000?o000020000ol0000H0007o`000?l0o`020003o`00008000?o0000
0P001?l00?l30005o`000?l00`001Ol0003o00D000Go0000o`030003o`3o008000Go0000o`020005
o`000?l00`001ol0003o0?l00P000ol000070003o`3o00/000?o000020000ol0000?00002`03o`<0
00Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000o`030003o`3o008000?o0000;0000ol0
000800Go1`000ol0o`0I0007o`3o0?l0o`020003o`00008000?o00000P000ol000040005o`000?l0
0`001Ol0003o00D000Go0000o`0500Co0`000ol000040005o`000?l00`000ol0o`020003o`0000P0
00?o00002005o`L000?o0?l0400000/000?o0?l00`001ol0003o0?l00`001Ol0003o00@000?o0000
10001Ol0003o00<000?o0?l00P000ol0000[0003o`3o00/000?o00001`000ol0o`0I0007o`3o0?l0
o`020003o`00008000?o00000P000ol000040005o`000?l00`001Ol0003o00D000Go0000o`030003
o`00008000Go0000o`060005o`000?l00`000ol0o`020003o`0000L000?o0?l02`000ol000070003
o`3o0100000<0003o`0000<01?l200Co0P02o`<01?l300;o1003o`030?oo00?o;002o`030?oo00X0
00?o00001P02o`030?oo01P00_l00`3oo`02o`030?oo00@000Co00001?l300;o0P05o`@000?o0000
0P02o`@01?l200?o0P04o`<00_l400?o00<0ool00ol800;o00<0ool04`02o`030?oo00l0000;00;o
20000ol000030003o`0000H000?o0000LP02o`<00_l80003o`00008000?o000040000ol0000D0003
o`0004H0000D00;o1002o`<000?o00000P000ol000040003o`0007P00ol40003o`0000@000?o0000
1`03o`D000?o00003P000ol000040003o`0003l0003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {153.25, 0}} -> {-0.0534279, -0.0267914, 
  0.00734097, 0.00734097}, {{7.25, 137}, {149.562, 
  3.625}} -> {-1.33521, -0.231915, 0.0323772, 0.0323772}, {{149.938, 
  279.688}, {149.562, 3.625}} -> {-5.95503, -0.231915, 0.0323772, 
  0.0323772}},
  CellTags->"FormRingoid"]
}, Open  ]],

Cell[TextData[{
  "3.1.2 ",
  StyleBox["FormRingoidByTable",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->"FormRingoidByT"],

Cell[TextData[{
  "A second general means of forming ringoids is with ",
  StyleBox["FormRingoidByTable", "MR"],
  "."
}], "Text",
  CellTags->"FormRingoidByT"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox["FormRingoidByTable",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{
                StyleBox["{",
                  "MR"], "els", 
                StyleBox["}",
                  "MR"]}],
              "TraditionalForm"],
            "TI"], 
          StyleBox[",",
            "MR"], " ", 
          StyleBox["atable",
            "TI"], 
          StyleBox[",",
            "MR"], " ", 
          StyleBox["mtable",
            "TI"]}], 
        StyleBox["]",
          "MR"]}], NotebookDefault]], "TopSpanBox",
  CellTags->{"FormRingoidByT", "i:5"}],

Cell[BoxData[
    FormBox[GridBox[{
          {" ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["form",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["Ringoid",
                      "MR"], 
                    StyleBox[\(\ with\ elements\ {\),
                      SingleLetterItalics->False], 
                    StyleBox["els",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox["and",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["tables",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["atable",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["mtable",
                  FontSlant->"Italic"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(using\  + \ and\ *\ as\ operation\ symbols\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "MiddleBox",
  CellTags->"FormRingoidByT"],

Cell[BoxData[
    FormBox[
      RowBox[{
        StyleBox["FormRingoidByTable",
          "MR"], 
        StyleBox["[",
          "MR"], 
        RowBox[{
          StyleBox[
            FormBox[
              RowBox[{
                StyleBox["{",
                  "MR"], "els", 
                StyleBox["}",
                  "MR"]}],
              "TraditionalForm"],
            "TI"], 
          StyleBox[",",
            "MR"], " ", 
          StyleBox["atable",
            "TI"], 
          StyleBox[",",
            "MR"], " ", 
          StyleBox["mtable",
            "TI"], 
          StyleBox[",",
            "MR"], 
          StyleBox[
            FormBox[
              RowBox[{
                StyleBox["{",
                  "MR"], 
                RowBox[{"asym", 
                  StyleBox[",",
                    "MR"], " ", "msym"}], 
                StyleBox["}",
                  "MR"]}],
              "TraditionalForm"],
            "TI"], 
          StyleBox[",",
            "MR"], " ", 
          StyleBox["opts",
            "TI"]}], 
        StyleBox["]",
          "MR"]}], NotebookDefault]], "MiddleSpanBox",
  CellTags->"FormRingoidByT"],

Cell[BoxData[
    FormBox[GridBox[{
          {" ", 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["form",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["Ringoid",
                      "MR"], 
                    StyleBox[\(\ with\ elements\ {\),
                      SingleLetterItalics->False], 
                    StyleBox["els",
                      FontSlant->"Italic"]}], 
                  StyleBox["}",
                    SingleLetterItalics->False]}], 
                StyleBox["and",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["tables",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["atable",
                  FontSlant->"Italic"], 
                StyleBox[\(\ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["mtable",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["using",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["asym",
                  FontSlant->"Italic"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["msym",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["operation",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["symbols",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["options",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "BottomBox",
  CellTags->"FormRingoidByT"],

Cell[TextData[{
  "Variations in using ",
  StyleBox["FormRingoidByTable",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"FormRingoidByT"],

Cell["Here are two tables of integers between 0 and 3.", "MathCaption",
  CellTags->"FormRingoidByT"],

Cell[CellGroupData[{

Cell[BoxData[
    \({atable = \((RotateLeft[Range[0, 3], #1]&)\)/@Range[0, 3], \n
        mtable = \((RotateLeft[Range[0, 3], #1]&)\)/@Range[1, 7, 2]} // 
      ColumnForm\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"FormRingoidByT"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({{0, 1, 2, 3}, {1, 2, 3, 0}, {2, 3, 0, 1}, {3, 0, 1, 2}}\)},
          {\({{1, 2, 3, 0}, {3, 0, 1, 2}, {1, 2, 3, 0}, {3, 0, 1, 2}}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{{0, 1, 2, 3}, {1, 2, 3, 0}, {2, 3, 0, 1}, {3, 0, 1, 
        2}}, {{1, 2, 3, 0}, {3, 0, 1, 2}, {1, 2, 3, 0}, {3, 0, 1, 2}}}],
      Editable->False]], "Output",
  CellLabel->"Out[14]=",
  CellTags->"FormRingoidByT"]
}, Open  ]],

Cell[TextData[{
  "These tables can be used to define a ringoid. ",
  StyleBox["FormRingoidByTable", "MR"],
  " accepts the same options as ",
  StyleBox["FormRingoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"FormRingoidByT"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormRingoidByTable[Range[0, 3], atable, mtable, 
      RingoidDescription \[Rule] "\<Experimental Ringoid\>", \ 
      FormatElements\  \[Rule] \ True, \ FormatOperator\  \[Rule] \ False]
      \)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"FormRingoidByT"],

Cell[BoxData[
    \(Ringoid[{"-Elements-"}, 
      First[Flatten[{{0, 1, 2, 3}, {1, 2, 3, 0}, {2, 3, 0, 1}, {3, 0, 1, 2}}
                \[LeftDoubleBracket]First[
                \((Position[{0, 1, 2, 3}, #1]&)\)[#1]], 
              First[\((Position[{0, 1, 2, 3}, #1]&)\)[#2]]
                \[RightDoubleBracket]]]&, 
      First[Flatten[{{1, 2, 3, 0}, {3, 0, 1, 2}, {1, 2, 3, 0}, {3, 0, 1, 2}}
                \[LeftDoubleBracket]First[
                \((Position[{0, 1, 2, 3}, #1]&)\)[#1]], 
              First[\((Position[{0, 1, 2, 3}, #1]&)\)[#2]]
                \[RightDoubleBracket]]]&]\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"FormRingoidByT"]
}, Open  ]],

Cell[TextData[{
  "3.2 Structure of ",
  StyleBox["Ringoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->"i:6"],

Cell["3.2.1 Basic functions", "Subsubsection",
  CellTags->"BasicRingoid"],

Cell[TextData[{
  "A ringoid is a structure that has head ",
  StyleBox["Ringoid", "MR",
    FontFamily->"Courier"],
  " and four arguments, the fourth being suppressed and used for internal \
purposes. The first argument is the domain of the ringoid, which can be \
referenced with ",
  StyleBox["Domain",
    FontFamily->"Courier"],
  ". The second argument is the addition operation on the domain, referenced \
with ",
  StyleBox["Addition",
    FontFamily->"Courier"],
  ". The third argument is the multiplication operation on the domain, \
referenced with ",
  StyleBox["Multiplication",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->"BasicRingoid"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Domain",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["domain",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((elements)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Elements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["identical",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Domain",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["R",
                      "TI"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["Addition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ addition\ operation\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ \((as\ a\ pure\ function)\)\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Multiplication",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ multiplication\ operation\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ \((as\ a\ pure\ function)\)\),
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"BasicRingoid", "i:7"}],

Cell["Functions for working with the structure of a ringoid.", "Caption",
  CellTags->"BasicRingoid"],

Cell[TextData[{
  "The expression ",
  StyleBox["ZR", "MR"],
  "[5] constructs the ringoid ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  "."
}], "MathCaption",
  CellTags->"BasicRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZR[5]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"BasicRingoid"],

Cell[BoxData[
    \(Ringoid[{0, 1, 2, 3, 4}, Mod[#1 + #2, 5]&, Mod[#1\ #2, 5]&]\)], "Output",\

  CellLabel->"Out[16]=",
  CellTags->"BasicRingoid"]
}, Open  ]],

Cell["Here are the elements in the ringoid.", "MathCaption",
  CellTags->"BasicRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Domain[ZR[5]]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"BasicRingoid"],

Cell[BoxData[
    \({0, 1, 2, 3, 4}\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->"BasicRingoid"]
}, Open  ]],

Cell["\<\
This is how to obtain the addition and multiplication operations.\
\
\>", "MathCaption",
  CellTags->"BasicRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Addition[ZR[5]], \ Multiplication[ZR[5]]}\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"BasicRingoid"],

Cell[BoxData[
    \({Mod[#1 + #2, 5]&, Mod[#1\ #2, 5]&}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"BasicRingoid"]
}, Open  ]],

Cell[TextData[{
  "Behind the scenes, when ",
  StyleBox["ZR", "MR"],
  "[5] is evaluated, ",
  StyleBox["FormRingoid", "MR"],
  " is called in order to construct it. "
}], "Text",
  CellTags->"BasicRingoid"],

Cell["3.2.2 Related functions", "Subsubsection",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RingoidName",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ name\ of\ the\ ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["PlusSymbol",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(return\ the\ symbol\ used\ for\ the\ addition\ of\ the\ 
                    ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["TimesSymbol",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(return\ the\ symbol\ used\ for\ the\ multiplication\ of\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["ElementQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["x",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["x",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ an\ element\ of\ the\ ringoid\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ElementsQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["els",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ all\ members\ of\ \),
                SingleLetterItalics->False], 
              StyleBox["els",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"RelatedRingoid", "i:8"}],

Cell["Functions related to the structure of a ringoid.", "Caption",
  CellTags->"RelatedRingoid"],

Cell[TextData[{
  "Here is an example of a nonstandard ring with information provided as \
options to ",
  StyleBox["FormRingoid", "MR"],
  "."
}], "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(R = 
      FormRingoid[Range[1, 4], Min[#1, #2]&, 
        Max[#1, #2]&, {"\<Min\>", "\<Max\>"}, 
        RingoidDescription \[Rule] 
          "\<An example of a Ringoid that is not a ring.\>", \ 
        RingoidName\  \[Rule] \ "\<Rex\>"]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \(Ringoid[{1, 2, 3, 4}, "-Addition-", "-Multiplication-"]\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell["\<\
Here is how we can learn the name of this ringoid and also the \
symbols used for its operators.\
\>", "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({RingoidName[R], PlusSymbol[R], \ TimesSymbol[R]}\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \({"Rex", "Min", "Max"}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["ElementQ", "MR"],
  " and ",
  StyleBox["ElementsQ", "MR"],
  " functions work just as they do for groupoids."
}], "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ElementQ[3, R], \ ElementsQ[{3, 5}, R]}\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell[TextData[
"In this ringoid, the \[OpenCurlyDoubleQuote]sum\[CloseCurlyDoubleQuote] of \
two numbers is the minimum of the two. Before doing any testing for ring \
properties, here is what is known about this ringoid."], "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RingInfo[R]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \({"Rex", "An example of a Ringoid that is not a ring."}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell[TextData[{
  "As tests are performed on a ringoid, information is collected and \
retrievable by the ",
  StyleBox["RingInfo", "MR"],
  " function. "
}], "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Zero[R], RingQ[R], \ RingInfo[R]}\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \({4, 
      False, {"Rex", "An example of a Ringoid that is not a ring.", 
        "the Ringoid has as a zero the element 4", 
        "the set is closed under addition", 
        "the set is closed under multiplication", 
        "there are elements that do not have an additive inverse", 
        "this is NOT a ring"}}\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell[TextData[
"Most would agree that a ring where all products are zero is \
\[OpenCurlyDoubleQuote]freaky.\[CloseCurlyDoubleQuote] Why not use a \
\[OpenCurlyDoubleQuote]freaky\[CloseCurlyDoubleQuote] multiplication \
symbol?"], "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FreakyRing = 
      FormRingoid[Range[0, 2], Mod[#1 + #2, 3]&, 
        0&, {"\<+\>", "\<\[FreakedSmiley]\>"}]; \n
    MultiplicationTable[FreakyRing, Mode \[Rule] Visual]; \)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"RelatedRingoid"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.238095 0.0267857 0.238095 [
[ 0 0 0 0 ]
[ 1 1.125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.125 L
0 1.125 L
closepath
clip
newpath
1 1 0 r
.2619 .50298 m
.2619 .74107 L
.5 .74107 L
.5 .50298 L
F
.5 .50298 m
.5 .74107 L
.7381 .74107 L
.7381 .50298 L
F
.7381 .50298 m
.7381 .74107 L
.97619 .74107 L
.97619 .50298 L
F
.2619 .26488 m
.2619 .50298 L
.5 .50298 L
.5 .26488 L
F
.5 .26488 m
.5 .50298 L
.7381 .50298 L
.7381 .26488 L
F
.7381 .26488 m
.7381 .50298 L
.97619 .50298 L
.97619 .26488 L
F
.2619 .02679 m
.2619 .26488 L
.5 .26488 L
.5 .02679 L
F
.5 .02679 m
.5 .26488 L
.7381 .26488 L
.7381 .02679 L
F
.7381 .02679 m
.7381 .26488 L
.97619 .26488 L
.97619 .02679 L
F
.2619 .74107 m
.2619 .97917 L
.5 .97917 L
.5 .74107 L
F
1 .5 0 r
.5 .74107 m
.5 .97917 L
.7381 .97917 L
.7381 .74107 L
F
.56 .37 .6 r
.7381 .74107 m
.7381 .97917 L
.97619 .97917 L
.97619 .74107 L
F
1 1 0 r
.02381 .50298 m
.02381 .74107 L
.2619 .74107 L
.2619 .50298 L
F
1 .5 0 r
.02381 .26488 m
.02381 .50298 L
.2619 .50298 L
.2619 .26488 L
F
.56 .37 .6 r
.02381 .02679 m
.02381 .26488 L
.2619 .26488 L
.2619 .02679 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02679 m
.02381 .97917 L
s
.02381 .02679 m
.97619 .02679 L
s
.02381 .26488 m
.97619 .26488 L
s
.02381 .50298 m
.97619 .50298 L
s
.02381 .74107 m
.97619 .74107 L
s
.02381 .97917 m
.97619 .97917 L
s
.2619 .02679 m
.2619 .97917 L
s
.5 .02679 m
.5 .97917 L
s
.7381 .02679 m
.7381 .97917 L
s
.97619 .02679 m
.97619 .97917 L
s
.02381 .97917 m
.2619 .74107 L
s
2.6 Mabswid
.2619 .02679 m
.2619 .97917 L
s
.02381 .74107 m
.97619 .74107 L
s
[(0)] .38095 .62202 0 0 Mshowa
[(0)] .61905 .62202 0 0 Mshowa
[(0)] .85714 .62202 0 0 Mshowa
[(0)] .38095 .38393 0 0 Mshowa
[(0)] .61905 .38393 0 0 Mshowa
[(0)] .85714 .38393 0 0 Mshowa
[(0)] .38095 .14583 0 0 Mshowa
[(0)] .61905 .14583 0 0 Mshowa
[(0)] .85714 .14583 0 0 Mshowa
[(0)] .14286 .62202 0 0 Mshowa
[(1)] .14286 .38393 0 0 Mshowa
[(2)] .14286 .14583 0 0 Mshowa
[(0)] .38095 .86012 0 0 Mshowa
[(1)] .61905 .86012 0 0 Mshowa
[(2)] .85714 .86012 0 0 Mshowa
[(\\(TheRing, x\\))] .02381 1.09821 -1 0 Mshowa
gsave
.97619 1.09821 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math4Mono
%%IncludeFont: Math4Mono
/Math4Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(\\317) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math4Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math4Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math4Mono
%%+ font Courier
grestore
[(x)] .10476 .81964 0 0 Mshowa
[(y)] .20238 .90774 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[24]:=",
  ImageSize->{256, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400040000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l00@000?l00@000?l00@000?l00@000?l0
0@000?l00@000?l00@0000H0lol700001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H0
03_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_llg`03omoO03[O00?ogml0>Ml00ol0
000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02occO00?ogml0>]l00ooO
g`0ig`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?=l00ooO
g`0jg`03omoO03WO00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000k
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW40
0_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nL@02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_llg`03omoO03[O00?ogml0
>Ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGia00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02occO00?ogml0
>]l00ooOg`0ig`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o
?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02occO00?ogml0>]l00ooOg`0ig`03o`0000D0
0006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?=l00ooOg`0jg`03omoO03WO
00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdOP02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_llg`03omoO03[O
00?ogml0>Ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02occO
00?ogml0>]l00ooOg`0ig`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_llg`03omoO03[O00?ogml0>Ml00ol000050000
1P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02occO00?ogml0>]l00ooOg`0ig`03
o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW400_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>oodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?=l00ooOg`0jg`03
omoO03WO00?o00001@0000H001coOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n1?l06g5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@02oagO0_lMg`03omoO01[O0_lNg`03omoO01[O0_lMg`03o`0000D0
0006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7h00_lLg`04omoOoacO00?ogml06Ml01?oOgolMg`03omoO01WO00Cogmoo7=l00ol000050000
1P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia00;o7=l01?oOgolLg`03omoO01WO00Cogmoo7Ml00ooOg`0Ig`04omoOoacO00?o00001@0000H0
03_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02oacO00Cogmoo7=l00ooOg`0Ig`04omoOoagO00?ogml06Ml01?oOgolLg`03o`0000D00006000k
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW40
0_lLg`04omoOoacO00?ogml06Ml01?oOgolMg`03omoO01WO00Cogmoo7=l00ol0000500001P007Ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o01cdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
0_lMg`;o7Ml00ooOg`0Jg`;o7]l00ooOg`0Jg`;o7Ml00ol0000500001P00>omnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?=l00ooOg`0jg`03
omoO03WO00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdOP02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kogiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H0
03_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
L@02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_llg`03omoO03[O00?ogml0>Ml00ol0
000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGia00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02occO00?ogml0>]l00ooO
g`0ig`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW400_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>oodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?=l00ooO
g`0jg`03omoO03WO00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000k
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h0
0_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdOP02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_llg`03omoO03[O00?ogml0
>Ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_An00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02occO00?ogml0
>]l00ooOg`0ig`03o`0000D00006000kooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>omn
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o
?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02occO00?ogml0>]l00ooOg`0ig`03o`0000D0
0006000kogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW400_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>oodO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o?=l00ooOg`0jg`03omoO03WO
00?o00001@0000H003_oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nL@02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000kooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_llg`03omoO03[O
00?ogml0>Ml00ol0000500001P00>omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGia00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02occO
00?ogml0>]l00ooOg`0ig`03o`0000D000060??o1`0000H003_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03
o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03
omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0
000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooO
g`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooO
g`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0
>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0
>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D0
0006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO
00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O
00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H001coWenO
GimOWenOGimOWenOGimOWenOGimOWenO0ol079mOWenOGimOWenOGimOWenOGimOWenOGimOWel2oagO
0_lMg`03omoO01[O0_lNg`03omoO01[O0_lMg`03o`0000D00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lLg`04omoOoacO00?ogml0
6Ml01?oOgolMg`03omoO01WO00Cogmoo7=l00ol0000500001P00>onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o7=l01?oOgolLg`03omoO01WO
00Cogmoo7Ml00ooOg`0Ig`04omoOoacO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02oacO00Cogmoo7=l00ooOg`0Ig`04
omoOoagO00?ogml06Ml01?oOgolLg`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lLg`04omoOoacO00?ogml06Ml01?oO
golMg`03omoO01WO00Cogmoo7=l00ol0000500001P007?nOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2o`0MGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_lMg`;o7Ml00ooOg`0Jg`;o7]l00ooO
g`0Jg`;o7Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO
00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol000050000
1P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03
o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03
omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H0
03_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0
000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooO
g`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooO
g`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000k
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0
>Ml00ol0000500001P00>onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0
>]l00ooOg`0ig`03o`0000D00006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P00>onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
?=l00ooOg`0jg`03omoO03WO00?o00001@0000H003_oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02occO00?ogml0>]l00ooOg`0ig`03o`0000D0
0006000koimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_llg`03omoO03[O00?ogml0>Ml00ol0000500001P3co`L000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO01[O0_lLg`;o
7Ml2oagO00?ogml06]l2oakO00?ogml06]l2oagO00?o00001@0000H000?ogml06Ml01?oOgolKg`;o
7=l01?oOgolLg`03omoO01WO00Cogmoo7Ml00ooOg`0Ig`04omoOoacO00?o00001@0000H000?ogml0
6Ml01?oOgolKg`;o7=l01?oOgolLg`03omoO01WO00Cogmoo7Ml00ooOg`0Ig`04omoOoacO00?o0000
1@0000H000?ogml06Ml01?oOgolKg`;o7=l01?oOgolLg`03omoO01WO00Cogmoo7Ml00ooOg`0Ig`04
omoOoacO00?o00001@0000H000?ogml06Ml01?oOgolKg`;o7=l01?oOgolLg`03omoO01WO00Cogmoo
7Ml00ooOg`0Ig`04omoOoacO00?o00001@0000H000?ogml06]l2oacO0_lMg`;o7Ml00ooOg`0Jg`;o
7]l00ooOg`0Jg`;o7Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001P000ooOg`0hg`;o?=l00ooOg`0jg`03omoO03WO00?o0000
1@0000H000?ogml0>=l2occO00?ogml0>]l00ooOg`0ig`03o`0000D000060003omoO03SO0_llg`03
omoO03[O00?ogml0>Ml00ol0000500001@3do`L000050?Co1`0000H000?o0000=`03occO07[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0
00060003o`0003H000Co0?oo?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o0000=@000ol00002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003
o`0003@000Co00000_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000c0003o`0000800_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000b0003o`0000<00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000a0003o`0000@00_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000`0003o`0000D00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000_0003o`0000H00_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000^0003o`0000L00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000]0003o`0000P00_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000/0003o`0000T00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000[0003o`0000X00_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000Z0003o`0000/00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000Y0003o`0000`00_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0
000X0003o`0000d00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000>00;o00<0ool050000ol0000>00;o?=l0N_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
1`0000H000?o00003`000ol0o`0D0003o`0000l00_llg`1joenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000@0003o`000180
00?o00004002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`L000060003o`0000l000?o0?l04P000ol0000A00;o?=l0N_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H0
00?o00003P02o`030?oo010000?o00004P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`00028000?o00004`02occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`L000060003o`00024000?o00005002occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`00020000?o00005@02occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`L000060003o`0001l000?o00005P02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`0001h000?o00005`02occO
07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`L000060003o`0001d000?o00006002oagO0_lMg`0LoenOGimOWenOGimOWenOGimOWenOGimO
WenOG`?o03YOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5n1?l07G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko00L000060003o`0001`000?o0000
6@02oacO00Cogmoo7=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00006`000ol0000J00;o7=l01?oOgolLg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l70000
1P000ol0000J0003o`0001/00_lLg`04omoOoacO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0001T000?o00007002oacO
00Cogmoo7=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko1`0000H000?o000060000ol0000M00;o7Ml2oagO01coGimOWenOGimOWenOGimO
WenOGimOWenOGimO0_l0?9mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdOP;o01kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0
000G0003o`0001h00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000F0003o`0001l00_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0
000E0003o`0002000_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_l700001P000ol0000D0003o`0002400_llg`1joenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0
000C0003o`0001400ol>00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1`0000H000?o00004P000ol0000C0003o`0000d00_llg`1j
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l700001P000ol0000A0003o`0001D000?o00003002occO07[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L000060003o`00010000?o0000
5P000ol0000<00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o00003`000ol0000F0003o`3o00d00_llg`1joenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l70000
1P000ol0000>0003o`0001L000?o0?l03@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`L000060003o`0000d000?o00005`02o`03
0?oo00`00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol0000<0003o`0002T00_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol0000;0003
o`0002X00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol0000:0003o`0002/00_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol000090003
o`0002`00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol000080003o`0002d00_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol000070003
o`0002h00_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol000060003o`0002l00_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol000050003
o`0003000_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol000040003o`0003400_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P000ol000030003
o`0003800_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l700001P000ol000020003o`0003<00_llg`1joenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l700001P001Ol0003o03H0
0_llg`1joenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l700001P001?l00?lg00;o?=l0N_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1`0000H000?o0?l0>002occO07[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`L0000600;o
>@02occO07[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`L000060??o1`0004400_nm0000o`010000o`010000o`010000o`010000o`010000
o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000
o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000o`010000
2@000ol0000V00?o5@000ol0002S00?o3@0000P000?o0000:P001?l00?lB0003o`000:<000?o0000
300000P000?o00000`03o`800_l00`3oo`0200Ko0P02o`030?oo00?o00@0ool00_l200Co0P000ol0
000700;o00<0ool010000ol0002:00;o00<0ool02003o`X000?o00002`0000P000?o000010001Ol0
003o008000Co003o1@001?l0ool40005o`000?l00P001?l00?l30005o`000?l02@000ol0o`050003
o`0008/000?o0?l020000ol0o`02o`T000?o00002`0000P000?o000010001Ol0003o008000?o0000
1Ol0103oool50005o`000?l00P001?l00?l30003o`0000`000?o000010000ol0002<0003o`0000L0
00?o0?l00_l80003o`3o00`000080003o`00008000Oo0?l0o`3o008000Co003o0`000ol0o`020003
o`00008000Go0000o`020004o`00o`<000?o00002`000ol0o`050003o`0008/000?o0?l020000ol0
o`02o`P000?o0?l0300000P000?o00000P001_l0o`3o00Co0`03o`8000Co003o0`02o`801Ol300Go
2`02o`030?oo00@000?o0000RP02o`030?oo00L000Go0000o`0700;o00<0ool02`0000T000Co0000
1Ol00`3o000900Co:0000ol0002G00Go5`0001800_lC0003o`000;/000?o0?l060000>H000?o0000
5`000?l00@000001\
\>"],
  ImageRangeCache->{{{0, 255}, {287, 0}} -> {-1.10002, -0.113553, 0.0164708, 
  0.0164708}},
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell["\<\
Sometimes it is useful to choose a random ring element or a list of \
random elements.\
\>", "Text",
  CellTags->{"RelatedRingoid", "i:9"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RandomElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(return\ a\ random\ element\ from\ the\ ringoid\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ according\ to\ the\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RandomElements",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\ random\ elements\ from\ the\ ringoid\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ according\ to\ the\ options\ \),
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.42, 0.58}},
  CellTags->{"RelatedRingoid", "i:10"}],

Cell["Choosing random elements.", "Caption",
  CellTags->"RelatedRingoid"],

Cell[TextData[{
  "To obtain nine random elements (allowing replacement) from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_11\)]],
  ", we can use either of the following methods."
}], "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Table[RandomElement[Z[11]], \ {9}], \ RandomElements[Z[11], 9]}\)], 
  "Input",
  CellLabel->"In[25]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \({{4, 5, 5, 10, 5, 2, 7, 8, 1}, {8, 4, 1, 2, 10, 0, 9, 10, 1}}\)], 
  "Output",
  CellLabel->"Out[25]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell["\<\
If you are interested in nine distinct elements and avoiding either \
of the identities, we can use the following options to accomplish this.\
\>", 
  "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomElements[Z[11], 9, \ Replacement\  \[Rule] \ False, \ 
      SelectFrom\  \[Rule] \ NonIdentity]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"RelatedRingoid"],

Cell[BoxData[
    \({7, 6, 4, 2, 8, 3, 9, 10, 5}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"RelatedRingoid"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                StyleBox[\(option\ name\),
                  "SO10"],
                "NotebookDefault"],
              "Text",
              FormatType->StandardForm], 
            StyleBox[
              FormBox[
                StyleBox["value",
                  "SO10"],
                "NotebookDefault"],
              "Text",
              FormatType->StandardForm], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[
                StyleBox[
                  RowBox[{"Non", 
                    StyleBox["Zero",
                      "Text"]}]],
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["except",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["zero",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["default",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["RandomElement",
                    "MR",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[
                StyleBox[
                  FormBox[
                    StyleBox[
                      RowBox[{"Non", 
                        StyleBox["Unity",
                          "Text"]}]],
                    "StandardForm"],
                  "Text"],
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["e",
                    SingleLetterItalics->False], "xcept"}]], " ", "the", " ", 
              "unity"}]},
          {
            StyleBox[
              FormBox["SelectFrom",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["NonIdentity",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                RowBox[{
                  StyleBox["e",
                    SingleLetterItalics->False], "xcept"}]], " ", "the", " ", 
              "unity", " ", "or", " ", "zero"}]},
          {
            StyleBox["SelectFrom",
              "MR"], 
            StyleBox[
              FormBox["Any",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox["choose",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["any",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["default",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], "\n", 
                  StyleBox["RandomElements",
                    "MR",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox["Replacement",
              "MR"], 
            StyleBox["True",
              "MR"], 
            RowBox[{
              StyleBox["assume",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["replacement",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["when",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["choosing",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["default",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["for",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["RandomElements",
                    "MR",
                    SingleLetterItalics->False]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.21, 0.59},
  RowLines->{True, False}},
  CellTags->{"RelatedRingoid", "i:11"}],

Cell["Options for generating random elements.", "Caption",
  CellTags->"RelatedRingoid"],

Cell["3.2.3 Groupoids from ringoids", "Subsubsection",
  CellTags->{"GroupoidsFromR", "i:12"}],

Cell["\<\
Since a ringoid is a collection of elements with two binary \
operations, it makes sense to consider splitting off either of the operations \
with the elements and forming a groupoid. There are several directions to go \
in here: the additive groupoid, the multiplicative groupoid, and the \
multiplicative groupoid consisting of just the nonzero elements.\
\>", "Text",\

  CellTags->"GroupoidsFromR"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["AdditiveGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["associated",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["consisting",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ its\ addition\ operation\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["AGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["AdditiveGroupoid",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["R",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["MultiplicativeGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["associated",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["consisting",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ and\ its\ multiplication\ operation\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["MGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["MultiplicativeGroupoid",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["R",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["NonZeroMGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["nonzero",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ringoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ with\ the\ multiplication\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"GroupoidsFromR", "i:13"}],

Cell["Groupoids associated with a ringoid.", "Caption",
  CellTags->"GroupoidsFromR"],

Cell[TextData[{
  "The additive groupoid of the ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " is essentially the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  "."
}], "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AdditiveGroupoid[ZR[11]]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"GroupoidsFromR"],

Cell[BoxData[
    \(Groupoid[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, Mod[#1 + #2, 11]&]\)], 
  "Output",
  CellLabel->"Out[27]=",
  CellTags->"GroupoidsFromR"]
}, Open  ]],

Cell["The additive groupoid of a ring is an Abelian group.", "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = \ AdditiveGroupoid[LatticeRing[30]]; 
    \n{GroupQ[G], AbelianQ[G]}\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"GroupoidsFromR"],

Cell[BoxData[
    \({True, True}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"GroupoidsFromR"]
}, Open  ]],

Cell["The multiplicative groupoid of a ring is never a group.", "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GroupQ[MultiplicativeGroupoid[Z[9]]]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"GroupoidsFromR"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"GroupoidsFromR"]
}, Open  ]],

Cell["\<\
In some cases, the multiplicative groupoid of nonzero elements is a \
group.\
\>", "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{

Cell[BoxData[
    \({G = NonZeroMGroupoid[Z[7]], GroupQ[G]}\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->"GroupoidsFromR"],

Cell[BoxData[
    \({Groupoid[{1, 2, 3, 4, 5, 6}, Mod[#1\ #2, 7]&], True}\)], "Output",
  CellLabel->"Out[30]=",
  CellTags->"GroupoidsFromR"]
}, Open  ]],

Cell["3.3 Testing properties of a ring", "Subsection",
  CellTags->"i:14"],

Cell["3.3.1 Additive properties", "Subsubsection",
  CellTags->{"AdditiveP", "i:15"}],

Cell["\<\
The additive properties of a ring require that the domain be closed \
with respect to addition, an identity (the zero) for addition must exist in \
the domain, each domain element must have an additive inverse in the domain, \
and addition must be both commutative and associative.\
\>", "Text",
  CellTags->"AdditiveP"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] \ Addition\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "TI"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ the\ elements\ of\ the\ ringoid\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              
              StyleBox[\(\ are\ closed\ with\ respect\ to\ the\ addition, \ 
                and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["HasZeroQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["give",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[\(\ if\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["has",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["zero",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox["otherwise",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["HasInversesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox[\(Operation\  \[Rule] \ Addition\),
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["every",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["has",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["an",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["additive",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["inverse",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["AssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] \ Addition\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ the\ addition\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ associative, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["otherwise",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["CommutativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] \ Addition\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ the\ addition\ of\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ commutative, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["HasIdentityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox[\(Operation\  \[Rule] \ Addition\),
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["HasZeroQ",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["R",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->{"AdditiveP", "i:16"}],

Cell["Functions for testing the additive properties of a ring.", "Caption",
  CellTags->"AdditiveP"],

Cell[TextData[{
  "Although it is common knowledge that ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " satisfies all the additive ring properties, here the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands confirm it."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ClosedQ[Z[5], \ Operation\  \[Rule] \ Addition], \ HasZeroQ[Z[5]], \ 
      HasInversesQ[Z[5], \ Operation\  \[Rule] \ Addition], \ 
      AssociativeQ[Z[5], \ Operation\  \[Rule] \ Addition], \ 
      CommutativeQ[Z[5], \ Operation\  \[Rule] \ Addition]}\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \({True, True, True, True, True}\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[TextData[{
  "One of the tests performed on a triple in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " by ",
  StyleBox["AssociativeQ", "MR"],
  " is mapped out by this visualization."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AssociativeQ[Z[5], Operation \[Rule] Addition, Mode \[Rule] Visual]\)], 
  "Input",
  CellLabel->"In[32]:=",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a + \\(b +  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a + b\\) + c)] .27778 .44444 0 0 Mshowa
.5 Mabswid
[ ] 0 setdash
.61111 .22222 m
.72222 .33333 L
s
.83333 .22222 m
.72222 .33333 L
s
.77778 .11111 m
.83333 .22222 L
s
.88889 .11111 m
.83333 .22222 L
s
.38889 .22222 m
.27778 .33333 L
s
.16667 .22222 m
.27778 .33333 L
s
.22222 .11111 m
.16667 .22222 L
s
.11111 .11111 m
.16667 .22222 L
s
.747 .885 .977 r
.61111 .22222 m
.61111 .22222 .04444 0 365.73 arc
F
.83333 .22222 m
.83333 .22222 .04444 0 365.73 arc
F
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.77778 .11111 m
.77778 .11111 .04444 0 365.73 arc
F
.88889 .11111 m
.88889 .11111 .04444 0 365.73 arc
F
.38889 .22222 m
.38889 .22222 .04444 0 365.73 arc
F
.16667 .22222 m
.16667 .22222 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
.22222 .11111 m
.22222 .11111 .04444 0 365.73 arc
F
.11111 .11111 m
.11111 .11111 .04444 0 365.73 arc
F
0 0 0 r
[(3)] .61111 .22222 0 0 Mshowa
[(+)] .83333 .22222 0 0 Mshowa
[(+)] .72222 .33333 0 0 Mshowa
[(2)] .77778 .11111 0 0 Mshowa
[(3)] .88889 .11111 0 0 Mshowa
[(3)] .38889 .22222 0 0 Mshowa
[(+)] .16667 .22222 0 0 Mshowa
[(+)] .27778 .33333 0 0 Mshowa
[(2)] .22222 .11111 0 0 Mshowa
[(3)] .11111 .11111 0 0 Mshowa
[(Elements a, b, and c chosen at random.)] .5 .05556 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0005/000?o0000
3`000ol0002`00007@05o`801Ol200Co00H0o`3o0?l200Co00@0ool00_l200?o0P04o`P01Ol20003
o`0000P01?l30003o`0000P01Ol0103oo`02o`801Ol700?o2@03o`800_l00`3oo`0200?o0P04o`<0
1?l0103oo`02o`L01Ol200?o2004o`801Ol0103oo`02o`801Ol0103oool20005o`3o0?l00P02ob40
000N0003o`0000D000Go0000o`050007o`3o0?l0o`050004o`00o`<000Co003o10000ol000060004
o`00o`@000?o00001`001Ol0003o00<000?o00001`001?l00?l20004o`00o`8000Go0000o`070005
o`000?l01`001ol0003o0?l00P001?l00?l30003o`00008000Co003o1@001?l00?l80004o`00o`<0
00Co003o20000ol000020004o`00o`8000Co003o0P001ol0003o0?l00`001ol0o`3o0?l00P02ob40
000N0003o`0000D000Co00001Ol01`3o0?l0o`001Ol01@3o003o00<000?o00000P04o`P01?l>0005
o`000?l03@04o`8000Co003o0P001Ol0003o00L000?o00002@000ol000030004o`00o`8000Ko0000
o`04o`801Ol01@3o003o00P01?l30003o`0000T000?o00000P04o`8000Co003o0P001ol0003o0?l0
0`001ol0o`3o0?l09@0001h00ol50005o`000?l00`002Ol0o`3o0?l0o`030003o`3o008000Go0000
o`040003o`0000`000?o000030001Ol0003o010000Co003o0P001?l00?l30003o`0000D000Go0000
o`070007o`000?l0o`020004o`00o`<000?o0?l01@001ol0003o0?l00P000ol000090005o`000?l0
2`02o`H000Co003o0P001?l00?l30003o`3o00<000Oo0?l0o`3o02D0000N0003o`0000D000?o0000
0P03o`030?oo00Co0P03o`030?oo00?o0P04o`801?l900?o3P04o`l00ol00`3oo`03o`<01?l800Co
2004o`030?oo00;o0`03o`801?l300?o00<0ool00ol900?o0P04o`P00_l00`3oo`0200?o00<0ool0
0ol300Co0P03o`030?oo00Co9@0001d01Ol40003o`0001X000?o000080000ol0000O0003o`0001L0
00?o0000:0000ol0000N0003o`0002l0000T00?o70000ol0000O00;o8002oaP00_lZ0003o`0001d0
0_la00006`002hH?QPn63hH?QPn601D000Z63hH?QPn63hH?U0002hH?QPn63hH?QPn601D000^63hH?
QPn63hH?QP0L00006@003`o?3ll?c`o?3ll?c`o?3`0A000>3ll?c`o?3ll?c`o?3lnA000>c`o?3ll?
c`o?3ll?c`lB000>c`o?3ll?c`o?3ll?c`lJ000060004@n63hH?QPn63hH?QPn63hH?00l0010?QPn6
3hH?QPn63hH?QPn6S`0048H?QPn63hH?QPn63hH?QPl@000@QPn63hH?QPn63hH?QPn63aT0000G000C
3ll?c`o?3ll?c`o?3ll?c`o?3`0=000B3ll?c`o?3ll?c`o?3ll?c`o?S@004/l?c`o?3ll?c`o?3ll?
c`o?3`h001;?3ll?c`o?3ll?c`o?3ll?c`lH00005`004hH?QPn63hH?QPn63hH?QPn63hH0300050n6
3hH?QPn63hH?QPn63hH?QPn6R`0058H?QPn63hH?QPn63hH?QPn63hH?30004hH?QPn63hH?QPn63hH?
QPn63hH0600001H001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll02P005Po?3ll?c`o?3ll?c`o?3ll?c`o?
3ln9000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3`X001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll05`0001D0
01J63hH?QPn63hH?QPn63hH?QPn63hH?2P005XH?QPn63hH?QPn63hH?QPn63hH?QPn9000F3hH?QPn6
3hH?QPn63hH?QPn63hH?QPX001D?QPn63hH?QPn63hH?QPn63hH?QPl05`0001@001S?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?c`l8000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?Q`0060o?3ll?c`o?3ll?c`o?
3ll?c`o?3ll?c`P001L?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3`0F0000500060n63hH?QPn63hH?QPn6
3hH?QPn63hH?QPP001P?QPn63hH?QPn63hH?QPn63hH?QPn63hJ7000HQPn63hH?QPn63hH?QPn63hH?
QPn63hH?20005hH?QPn63hH?QPn63hH?QPn63hH?QPn601H0000C000;3ll?c`o?3ll?c`l00ol02`o?
3ll?c`o?3ll?00L000/?c`o?3ll?c`o?3`04o`0:c`o?3ll?c`o?3hH000[?3ll?c`o?3ll?1?l02ll?
c`o?3ll?c`o?00L000[?3ll?c`o?3ll?0ol02`o?3ll?c`o?3ll?01H0000C000IQPn63hH?QPn63hH?
QPoo3hH?QPn63hH?QP07000IQPn63hH?QPn63hH?o`n63hH?QPn63hH?QP26000I3hH?QPn63hH?QPoo
3hH?QPn63hH?QPn63`07000I3hH?QPn63hH?QPn63ol?QPn63hH?QPn63`0E00004`006@o?3ll?c`o?
3ll?c`o?oll?c`o?3ll?c`l01`006@o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`l0QP006Ll?c`o?3ll?
c`o?3ol?c`o?3ll?c`o?3ll01`006Ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll05@0001<000b63hH?
QPn63hH?QPl2o`0;QPn63hH?QPn63hH01`006HH?QPn63hH?QPn63hH?o`n63hH?QPn63hH0QP006@n6
3hH?QPn63hH?QPoo3hH?QPn63hH?QPl01`002`n63hH?QPn63hH?00;o00b63hH?QPn63hH?QPlE0000
4`006@o?3ll?c`o?3ll?c`o?oll?c`o?3ll?c`l01`006@o?3ll?c`o?3ll?o`o?oll?c`o?3ll?c`l0
QP006Ll?c`o?3ll?c`oo3looc`o?3ll?c`o?3ll01`006Ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll0
5@0001<000^63hH?QPn63hH?QP03o`0;QPn63hH?QPn63hH01`0038H?QPn63hH?QPn63`;o00^63hH?
QPn63hH?QP26000;3hH?QPn63hH?QPl00_l038H?QPn63hH?QPn63`L000X?QPn63hH?QPn60ol038H?
QPn63hH?QPn63aD0000D000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?20006<l?c`o?3ll?c`o?3ll?
c`o?3ll?c`o?3hL001P?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll7000Ic`o?3ll?c`o?3ll?c`o?3ll?
c`o?3ll?c`0E0000500060n63hH?QPn63hH?QPn63hH?QPn63hH?QPP001P?QPn63hH?QPn63hH?QPn6
3hH?QPn63hJ7000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?1`006@n63hH?QPn63hH?QPn63hH?QPn6
3hH?QPl05@0001@001O?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`09000Gc`o?3ll?c`o?3ll?c`o?3ll?
c`o?3ll0R0005`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?00P001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?
c`lF00005@005XH?QPn63hH?QPn63hH?QPn63hH?QPl:000FQPn63hH?QPn63hH?QPn63hH?QPn63hT0
01H?QPn63hH?QPn63hH?QPn63hH?QPn62@005hH?QPn63hH?QPn63hH?QPn63hH?QPn601H0000E000E
3ll?c`o?3ll?c`o?3ll?c`o?3ll?00/001D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0RP005Ll?c`o?3ll?
c`o?3ll?c`o?3ll?c`0;000Ec`o?3ll?c`o?3ll?c`o?3ll?c`o?01L0000F000D3hH?QPn63hH?QPn6
3hH?QPn63hH<000C3hH?QPn63hH?QPn63hH?QPn63`2<000CQPn63hH?QPn63hH?QPn63hH?QP0=000C
QPn63hH?QPn63hH?QPn63hH?QP0H00005`004Po?3ll?c`o?3ll?c`o?3ll?c`h0014?c`o?3ll?c`o?
3ll?c`o?3`2>000Ac`o?3ll?c`o?3ll?c`o?3ll03`004Ll?c`o?3ll?c`o?3ll?c`o?01T0000H000@
3hH?QPn63hH?QPn63hH?QQ0000l?QPn63hH?QPn63hH?QPl0T0003hH?QPn63hH?QPn63hH?QP0A000?
QPn63hH?QPn63hH?QPn601X0000K000<3ll?c`o?3ll?c`oo4`002ll?c`o?3ll?c`o?09@000`?c`o?
3ll?c`o?3olC000<o`o?3ll?c`o?3ll?700001d000J63hH?QPl30003o`00014000Wo00263hH?QPl0
V@001Pn63hH?QP8000?o00004@002_l008H?QPn63hHN00009`000ol0000?0003o`000:T000?o0000
3`000ol0000V00009`000ol0000?0003o`000:T000?o00003`000ol0000V0000:0000ol0000=0003
o`000:/000?o00003@000ol0000W0000:0000ol0000=0003o`000:/000?o00003@000ol0000W0000
:@000ol0000;0003o`000:d000?o00002`000ol0000X0000:@000ol0000;0003o`000:d000?o0000
2`000ol0000X0000:P002Ol000o?3ll?c`030003o`0003@000H?c`o?3lli0006c`o?3ll?=P002_l0
003?3ll?c`l20003o`0002T0000Z000=ohH?QPn63hH?QPl0o`0c000;3hH?QPn63hH?QPl0=@002`n6
3hH?QPn63hH?03<000goQPn63hH?QPn63hKo02/0000Y000?3ll?c`o?3ll?c`o?3ll?034000h?c`o?
3ll?c`o?3ll?cc4000o?3ll?c`o?3ll?c`o?3ll0<@003/l?c`o?3ll?c`o?3ll?:P0002P0010?QPn6
3hH?QPn63hH?QPn6<00040n63hH?QPn63hH?QPn63hH_000AQPn63hH?QPn63hH?QPn63hH0;`0048H?
QPn63hH?QPn63hH?QPlY00009`004Po?3ll?c`o?3ll?c`o?3ll?cbd001??3ll?c`o?3ll?c`o?3ll?
c`o?02d001??3ll?c`o?3ll?c`o?3ll?c`o?02`001<?c`o?3ll?c`o?3ll?c`o?3ll?02P0000V000D
3hH?QPn63hH?QPn63hH?QPn63hH[000DQPn63hH?QPn63hH?QPn63hH?QPl/000DQPn63hH?QPn63hH?
QPn63hH?QPl[000D3hH?QPn63hH?QPn63hH?QPn63hHX00009P005Ll?c`o?3ll?c`o?3ll?c`o?3ll?
c`0Z000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02/001D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0:P005Ll?
c`o?3ll?c`o?3ll?c`o?3ll?c`0W00009@005XH?QPn63hH?QPn63hH?QPn63hH?QPlY000F3hH?QPn6
3hH?QPn63hH?QPn63hH?QRX001H?QPn63hH?QPn63hH?QPn63hH?QPn6:@005XH?QPn63hH?QPn63hH?
QPn63hH?QPlW000090006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3bP001O?3ll?c`o?3ll?c`o?3ll?
c`o?3ll?c`0X000H3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?:0005`o?3ll?c`o?3ll?c`o?3ll?c`o?
3ll?02H0000T000H3hH?QPn63hH?QPn63hH?QPn63hH?QPn6:0005`n63hH?QPn63hH?QPn63hH?QPn6
3hH?02P001R63hH?QPn63hH?QPn63hH?QPn63hH?QPlX000GQPn63hH?QPn63hH?QPn63hH?QPn63hH0
9P0002<001T?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?02L000X?c`o?3ll?c`o?0ol03<l?c`o?3ll?
c`o?3bH000_?3ll?c`o?3ll?c`03o`0;c`o?3ll?c`o?3ll09`006Ll?c`o?3ll?c`o?3ol?c`o?3ll?
c`o?3ll09@0002<001V63hH?QPn63hH?QPn6ohH?QPn63hH?QPn602L001V63hH?QPn63hH?QPn6ohH?
QPn63hH?QPn602H001T?QPn63hH?QPn63hH?Q_n63hH?QPn63hH?02L001T?QPn63hH?QPn63hKoQPn6
3hH?QPn63hH?02D0000S000;3ll?c`o?3ll?c`l01Ol02@o?3ll?c`o?3`0W000I3ll?c`o?3ll?c`o?
3ol?c`o?3ll?c`o?3`0V000Ic`o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`0W000:c`o?3ll?c`o?3`Go
00X?c`o?3ll?c`o?9@0002<001V63hH?QPn63hH?QPn6ohH?QPn63hH?QPn602L000^63hH?QPn63hH?
QP02o`0<3hH?QPn63hH?QPn69P0030n63hH?QPn63hH?QP;o00/?QPn63hH?QPn63`0W000I3hH?QPn6
3hH?QPn6ohH?QPn63hH?QPn63`0U00008`006@o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`l09`006@o?
3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`l09P006Ll?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll09`006Ll?
c`o?3ll?c`o?3ol?c`o?3ll?c`o?3ll09@0002<001V63hH?QPn63hH?QPn63hH?QPn63hH?QPn602L0
00Z63hH?QPn63hH?0ol030n63hH?QPn63hH?QRH000/?QPn63hH?QPn63`03o`0;3hH?QPn63hH?QPl0
9`006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl09@0002@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?
c`lW000I3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3`0W000H3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?
9`006Ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll09@0002@001P?QPn63hH?QPn63hH?QPn63hH?QPn6
3hHW000IQPn63hH?QPn63hH?QPn63hH?QPn63hH?QP0W000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?
9`006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl09@0002D001H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?
:@005ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?02T001K?3ll?c`o?3ll?c`o?3ll?c`o?3ll?:@005`o?
3ll?c`o?3ll?c`o?3ll?c`o?3ll?02H0000U000FQPn63hH?QPn63hH?QPn63hH?QPn63bT001L?QPn6
3hH?QPn63hH?QPn63hH?QPn63`0Y000F3hH?QPn63hH?QPn63hH?QPn63hH?QRT001N63hH?QPn63hH?
QPn63hH?QPn63hH?QP0V00009@005@o?3ll?c`o?3ll?c`o?3ll?c`o?3`0[000E3ll?c`o?3ll?c`o?
3ll?c`o?3ll?02X001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll0:`005Ll?c`o?3ll?c`o?3ll?c`o?3ll?
c`0W00009P0050n63hH?QPn63hH?QPn63hH?QPn6;0004`n63hH?QPn63hH?QPn63hH?QPl0;00058H?
QPn63hH?QPn63hH?QPn63hH?;0004hH?QPn63hH?QPn63hH?QPn63hH0:00002P001;?3ll?c`o?3ll?
c`o?3ll?col[000Co`00c`o?3ll?c`o?3ll?c`o?3`0_000C3ll?c`o?3ll?c`o?3ll?c`l0o`0[000B
o`0?c`o?3ll?c`o?3ll?c`o?:@0002T000n63hH?QPn63hH?QPn63hH00P000ol0000W0003o`000080
00j63hH?QPn63hH?QPn63c8000j63hH?QPn63hH?QPn63`<000?o00009`004_l0000?QPn63hH?QPn6
3hH?QRX0000Z000<c`o?3ll?c`o?3ll?1@000ol0000U0003o`0000@000_?3ll?c`o?3ll?c`0e000;
c`o?3ll?c`o?3ll01P000ol0000U0003o`0000<000/?c`o?3ll?c`o?3`0/0000;`0018H?QPl90003
o`0002<000?o00002P0018H?QPlk00043hH?QPX000?o00008`000ol0000900043hH?QRh0000m0003
o`00024000?o0000F@000ol0000Q0003o`0003`0000n0003o`0001l000?o0000F`000ol0000O0003
o`0003d0000o0003o`0001d000?o0000G@000ol0000M0003o`0003h000100003o`0001/000?o0000
G`000ol0000K0003o`0003l000110003o`0001T000?o0000H@000ol0000I0003o`00040000120003
o`0001L000?o0000H`000ol0000G0003o`00044000130003o`0000L000H?c`o?3ll80003o`0006D0
00?o00001P001/l?c`o?3`T000?o0000@P0004@000?o00000`002`n63hH?QPn63hH?00D000?o0000
I`000ol00003000:3hH?QPn63hH?QPH000?o0000@`0004D001;o003?3ll?c`o?3ll?c`o?3ll20003
o`0006T0017o00o?3ll?c`o?3ll?c`o?3`030003o`0004@00016000CohH?QPn63hH?QPn63hH?QPn6
o`1]000C3hH?QPn63hH?QPn63hH?QPl0o`170000AP004ll?c`o?3ll?c`o?3ll?c`o?3ll0K0004`o?
3ll?c`o?3ll?c`o?3ll?c`l0B00004D001F63hH?QPn63hH?QPn63hH?QPn63hH0JP005@n63hH?QPn6
3hH?QPn63hH?QPn63`170000A@005Po?3ll?c`o?3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3dH00014000G3hH?QPn63hH?QPn63hH?QPn63hH?QPl0J0005hH?QPn63hH?QPn63hH?
QPn63hH?QPn604H00014000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?I`0060o?3ll?c`o?3ll?c`o?
3ll?c`o?3ll?cdD00013000IQPn63hH?QPn63hH?QPn63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn6
3hH?QPn63hH?QPn63`150000@`006@o?3ll?c`o?3ll?coo?3ll?c`o?3ll?c`l0IP006Ll?c`o?3ll?
c`o?3looc`o?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?QPoo3hH?QPn63hH?QPn606H001T?QPn6
3hH?QPn63hH?o`n63hH?QPn63hH?04D00013000:3ll?c`o?3ll?c`Go00[?3ll?c`o?3ll?IP002ll?
c`o?3ll?c`o?00Go00W?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?QPoo3hH?QPn63hH?QPn606H0
01T?QPn63hH?QPn63hH?o`n63hH?QPn63hH?04D00013000I3ll?c`o?3ll?c`o?oll?c`o?3ll?c`o?
3`1V000Ic`o?3ll?c`o?3ll?coo?3ll?c`o?3ll?c`150000@`006HH?QPn63hH?QPn63hH?QPn63hH?
QPn63hH0IP006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl0A@0004@001S?3ll?c`o?3ll?c`o?3ll?
c`o?3ll?c`mW000H3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?A@0004@001L?QPn63hH?QPn63hH?QPn6
3hH?QPn63`1X000GQPn63hH?QPn63hH?QPn63hH?QPn63hH0AP0004D001H?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?J@005/l?c`o?3ll?c`o?3ll?c`o?3ll?c`m60000A@005XH?QPn63hH?QPn63hH?QPn63hH?
QPmY000F3hH?QPn63hH?QPn63hH?QPn63hH?QTH00016000Dc`o?3ll?c`o?3ll?c`o?3ll?c`m[000D
3ll?c`o?3ll?c`o?3ll?c`o?3lm70000A`004XH?QPn63hH?QPn63hH?QPn63fd0018?QPn63hH?QPn6
3hH?QPn63hI80000B0004<l?c`o?3ll?c`o?3ll?c`m_000@3ll?c`o?3ll?c`o?3ll?cdT0001:000=
3hH?QPn63hH?QPn63`1b000=QPn63hH?QPn63hH?QP1:0000C@0020o?3ll?c`o?M`002<l?c`o?3ll?
C00004l000>63`00O0000`n6001?0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000<@000ol0000P0003
o`0006l000?o00009P000ol0000^0000<0000ol0000R0003o`0006d000?o0000:0000ol0000]0000
<0000ol0000200Go2@000ol0000700Co10000ol000090003o`0000P00olm00Go2@000ol000080003
o`0000801?l:0003o`0000h00ol40003o`0002d0000`0003o`00008000Co003o2P000ol000070005
o`000?l00`000ol000090003o`0000L000Go0000o`0l0004o`00o`X000?o000020000ol000020005
o`000?l02@000ol0000=0005o`000?l00`000ol0000]0000<0000ol0000200Co2005o`L000Go0000
o`030003o`0000L01Ol70003o`0003h01?l800Go20000ol000020005o`000?l01`05o`d000?o0000
1@000ol0000]0000<0000ol000050003o`0000P000?o00001`001Ol0003o00<000?o00002@000ol0
00070005o`000?l0?`000ol000080003o`0000P000?o00000P001Ol0003o00T000?o00003@001Ol0
003o00<000?o0000;@00030000?o00000`03o`X000?o00001`04o`@000?o00002@000ol0000800Co
?@03o`X000?o000020000ol0000200Co2P000ol0000>00Co0`000ol0000]0000<@000ol0000I0003
o`0000@000?o0000K`001Ol0003o02@000?o0000;P0004`00_mk00;oE@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"AdditiveP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a + \\(b +  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a + b\\) + c)] .27778 .44444 0 0 Mshowa
.5 Mabswid
[ ] 0 setdash
.61111 .22222 m
.72222 .33333 L
s
.83333 .22222 m
.72222 .33333 L
s
.38889 .22222 m
.27778 .33333 L
s
.16667 .22222 m
.27778 .33333 L
s
.747 .885 .977 r
.61111 .22222 m
.61111 .22222 .04444 0 365.73 arc
F
.83333 .22222 m
.83333 .22222 .04444 0 365.73 arc
F
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.38889 .22222 m
.38889 .22222 .04444 0 365.73 arc
F
.16667 .22222 m
.16667 .22222 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(3)] .61111 .22222 0 0 Mshowa
[(2+3)] .83333 .22222 0 0 Mshowa
[(+)] .72222 .33333 0 0 Mshowa
[(3)] .38889 .22222 0 0 Mshowa
[(3+2)] .16667 .22222 0 0 Mshowa
[(+)] .27778 .33333 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0002d000H?c`o?3llj0006
3ll?c`o?>@001/l?c`o?3cX000K?3ll?c`l^0000:`002XH?QPn63hH?QPle000;3hH?QPn63hH?QPl0
=@002`n63hH?QPn63hH?03@000^63hH?QPn63hH?QP0/0000:@003`o?3ll?c`o?3ll?c`o?3`0a000>
3ll?c`o?3ll?c`o?3lla000?c`o?3ll?c`o?3ll?c`o?034000k?3ll?c`o?3ll?c`o?3bX0000X000@
3hH?QPn63hH?QPn63hH?QS00010?QPn63hH?QPn63hH?QPn6;`004HH?QPn63hH?QPn63hH?QPn602l0
01263hH?QPn63hH?QPn63hH?:@0002L0018?c`o?3ll?c`o?3ll?c`o?3ll]000Cc`o?3ll?c`o?3ll?
c`o?3ll?c`0]000Cc`o?3ll?c`o?3ll?c`o?3ll?c`0/000C3ll?c`o?3ll?c`o?3ll?c`o?3`0X0000
9P0050n63hH?QPn63hH?QPn63hH?QPn6:`0058H?QPn63hH?QPn63hH?QPn63hH?;00058H?QPn63hH?
QPn63hH?QPn63hH?:`0050n63hH?QPn63hH?QPn63hH?QPn6:00002H001G?3ll?c`o?3ll?c`o?3ll?
c`o?3ll0:P005@o?3ll?c`o?3ll?c`o?3ll?c`o?3`0[000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02X0
01G?3ll?c`o?3ll?c`o?3ll?c`o?3ll09`0002D001J63hH?QPn63hH?QPn63hH?QPn63hH?:@005Pn6
3hH?QPn63hH?QPn63hH?QPn63hHZ000F3hH?QPn63hH?QPn63hH?QPn63hH?QRT001J63hH?QPn63hH?
QPn63hH?QPn63hH?9`0002@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`lX000Gc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll0:00060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cbP001L?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3`0V0000900060n63hH?QPn63hH?QPn63hH?QPn63hH?QRP001L?QPn63hH?QPn63hH?QPn6
3hH?QPn63`0X000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?:0005hH?QPn63hH?QPn63hH?QPn63hH?
QPn602H0000S00053ll?c`l00ol02@o?3ll?o`o?3`04o`04c`o?3bL000X?c`o?3ll?c`o?0ol03<l?
c`o?3ll?c`o?3bH000_?3ll?c`o?3ll?c`03o`0;c`o?3ll?c`o?3ll09`001<l?c`l4o`08c`o?3ol?
c`l3o`063ll?c`o?9@0002<001V63hH?QPn63ol?QPn6ohH?QPoo3hH?QPn602L001V63hH?QPn63hH?
QPn6ohH?QPn63hH?QPn602H001T?QPn63hH?QPn63hH?Q_n63hH?QPn63hH?02L001T?QPn63ol?QPn6
3hKoQPn63hH?o`n63hH?02D0000S000;3ll?c`o?3looc`l01Ol02@o?3ol?c`o?3`0W000I3ll?c`o?
3ll?c`o?3ol?c`o?3ll?c`o?3`0V000Ic`o?3ll?c`o?3ll?c`oo3ll?c`o?3ll?c`0W000:c`o?3ll?
o`o?3`Go00X?c`o?oll?c`o?9@0002<000J63hH?QPl2o`0AQPn63hKoQPn63hH?o`n63hH09`002hH?
QPn63hH?QPn600;o00`?QPn63hH?QPn63hHV000<3hH?QPn63hH?QPn60_l02`n63hH?QPn63hH?02L0
014?QPn63hH?o`n63hKoQPn63`02o`06QPn63hH?9@0002<001T?c`o?3ll?coo?3ll?o`o?3ol?coo?
3ll?02L001T?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?02H001W?3ll?c`o?3ll?c`o?3ol?c`o?3ll?
c`o?02L001W?3ll?o`o?oll?c`oo3ll?c`o?oll?c`o?02D0000S0005QPn63hH00ol02XH?QPn63hH?
QPl2o`05QPn63hH09`002XH?QPn63hH?QPl3o`0<3hH?QPn63hH?QPn69P002`n63hH?QPn63hH?00?o
00/?QPn63hH?QPn63`0W00053hH?QPl00_l02HH?QPn63hH?QP03o`06QPn63hH?9@0002@001S?3ll?
c`o?3ll?c`o?3ll?c`o?3ll?c`lW000I3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3`0W000H3ll?c`o?
3ll?c`o?3ll?c`o?3ll?c`o?9`006Ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll09@0002@001P?QPn6
3hH?QPn63hH?QPn63hH?QPn63hHW000IQPn63hH?QPn63hH?QPn63hH?QPn63hH?QP0W000HQPn63hH?
QPn63hH?QPn63hH?QPn63hH?9`006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl09@0002D001H?c`o?
3ll?c`o?3ll?c`o?3ll?c`o?:@005ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?02T001K?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?:@005`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?02H0000U000FQPn63hH?QPn63hH?
QPn63hH?QPn63bT001L?QPn63hH?QPn63hH?QPn63hH?QPn63`0Y000F3hH?QPn63hH?QPn63hH?QPn6
3hH?QRT001N63hH?QPn63hH?QPn63hH?QPn63hH?QP0V00009@005@o?3ll?c`o?3ll?c`o?3ll?c`o?
3`0[000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02X001G?3ll?c`o?3ll?c`o?3ll?c`o?3ll0:`005Ll?
c`o?3ll?c`o?3ll?c`o?3ll?c`0W00009P0050n63hH?QPn63hH?QPn63hH?QPn6;0004`n63hH?QPn6
3hH?QPn63hH?QPl0;00058H?QPn63hH?QPn63hH?QPn63hH?;0004hH?QPn63hH?QPn63hH?QPn63hH0
:00002P001;?3ll?c`o?3ll?c`o?3ll?col[000Co`00c`o?3ll?c`o?3ll?c`o?3`0_000C3ll?c`o?
3ll?c`o?3ll?c`l0o`0[000Bo`0?c`o?3ll?c`o?3ll?c`o?:@0002T000n63hH?QPn63hH?QPn63hH0
0P000ol0000W0003o`00008000j63hH?QPn63hH?QPn63c8000j63hH?QPn63hH?QPn63`<000?o0000
9`004_l0000?QPn63hH?QPn63hH?QRX0000Z000<c`o?3ll?c`o?3ll?1@000ol0000U0003o`0000@0
00_?3ll?c`o?3ll?c`0e000;c`o?3ll?c`o?3ll01P000ol0000U0003o`0000<000/?c`o?3ll?c`o?
3`0/0000;`0018H?QPl90003o`0002<000?o00002P0018H?QPlk00043hH?QPX000?o00008`000ol0
000900043hH?QRh0000m0003o`00024000?o0000F@000ol0000Q0003o`0003`0000n0003o`0001l0
00?o0000F`000ol0000O0003o`0003d0000o0003o`0001d000?o0000G@000ol0000M0003o`0003h0
00100003o`0001/000?o0000G`000ol0000K0003o`0003l000110003o`0001T000?o0000H@000ol0
000I0003o`00040000120003o`0001L000?o0000H`000ol0000G0003o`00044000130003o`0000L0
00H?c`o?3ll80003o`0006D000?o00001P001/l?c`o?3`T000?o0000@P0004@000?o00000`002`n6
3hH?QPn63hH?00D000?o0000I`000ol00003000:3hH?QPn63hH?QPH000?o0000@`0004D001;o003?
3ll?c`o?3ll?c`o?3ll20003o`0006T0017o00o?3ll?c`o?3ll?c`o?3`030003o`0004@00016000C
ohH?QPn63hH?QPn63hH?QPn6o`1]000C3hH?QPn63hH?QPn63hH?QPl0o`170000AP004ll?c`o?3ll?
c`o?3ll?c`o?3ll0K0004`o?3ll?c`o?3ll?c`o?3ll?c`l0B00004D001F63hH?QPn63hH?QPn63hH?
QPn63hH0JP005@n63hH?QPn63hH?QPn63hH?QPn63`170000A@005Po?3ll?c`o?3ll?c`o?3ll?c`o?
3lmY000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3dH00014000G3hH?QPn63hH?QPn63hH?QPn63hH?QPl0
J0005hH?QPn63hH?QPn63hH?QPn63hH?QPn604H00014000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?
I`0060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cdD00013000IQPn63hH?QPn63hH?QPn63hH?QPn63hH?
QP1V000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`150000@`006@o?3ll?c`o?3ll?coo?3ll?c`o?
3ll?c`l0IP006Ll?c`o?3ll?c`o?3looc`o?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?QPoo3hH?
QPn63hH?QPn606H001T?QPn63hH?QPn63hH?o`n63hH?QPn63hH?04D00013000:3ll?c`o?3ll?c`Go
00[?3ll?c`o?3ll?IP002ll?c`o?3ll?c`o?00Go00W?3ll?c`o?3ll0A@0004<001V63hH?QPn63hH?
QPoo3hH?QPn63hH?QPn606H001T?QPn63hH?QPn63hH?o`n63hH?QPn63hH?04D00013000I3ll?c`o?
3ll?c`o?oll?c`o?3ll?c`o?3`1V000Ic`o?3ll?c`o?3ll?coo?3ll?c`o?3ll?c`150000@`006HH?
QPn63hH?QPn63hH?QPn63hH?QPn63hH0IP006@n63hH?QPn63hH?QPn63hH?QPn63hH?QPl0A@0004@0
01S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`mW000H3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?A@0004@0
01L?QPn63hH?QPn63hH?QPn63hH?QPn63`1X000GQPn63hH?QPn63hH?QPn63hH?QPn63hH0AP0004D0
01H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?J@005/l?c`o?3ll?c`o?3ll?c`o?3ll?c`m60000A@005XH?
QPn63hH?QPn63hH?QPn63hH?QPmY000F3hH?QPn63hH?QPn63hH?QPn63hH?QTH00016000Dc`o?3ll?
c`o?3ll?c`o?3ll?c`m[000D3ll?c`o?3ll?c`o?3ll?c`o?3lm70000A`004XH?QPn63hH?QPn63hH?
QPn63fd0018?QPn63hH?QPn63hH?QPn63hI80000B0004<l?c`o?3ll?c`o?3ll?c`m_000@3ll?c`o?
3ll?c`o?3ll?cdT0001:000=3hH?QPn63hH?QPn63`1b000=QPn63hH?QPn63hH?QP1:0000C@0020o?
3ll?c`o?M`002<l?c`o?3ll?C00004l000>63`00O0000`n6001?0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000<@000ol0000P0003o`0006l000?o00009P000ol0000^0000<0000ol0000R0003o`0006d0
00?o0000:0000ol0000]0000<0000ol0000200Go2@000ol0000700Co10000ol000090003o`0000P0
0olm00Go2@000ol000080003o`0000801?l:0003o`0000h00ol40003o`0002d0000`0003o`000080
00Co003o2P000ol000070005o`000?l00`000ol000090003o`0000L000Go0000o`0l0004o`00o`X0
00?o000020000ol000020005o`000?l02@000ol0000=0005o`000?l00`000ol0000]0000<0000ol0
000200Co2005o`L000Go0000o`030003o`0000L01Ol70003o`0003h01?l800Go20000ol000020005
o`000?l01`05o`d000?o00001@000ol0000]0000<0000ol000050003o`0000P000?o00001`001Ol0
003o00<000?o00002@000ol000070005o`000?l0?`000ol000080003o`0000P000?o00000P001Ol0
003o00T000?o00003@001Ol0003o00<000?o0000;@00030000?o00000`03o`X000?o00001`04o`@0
00?o00002@000ol0000800Co?@03o`X000?o000020000ol0000200Co2P000ol0000>00Co0`000ol0
000]0000<@000ol0000I0003o`0000@000?o0000K`001Ol0003o02@000?o0000;P0004`00_mk00;o
E@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"AdditiveP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a + \\(b +  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a + b\\) + c)] .27778 .44444 0 0 Mshowa
.5 Mabswid
[ ] 0 setdash
.61111 .22222 m
.72222 .33333 L
s
.83333 .22222 m
.72222 .33333 L
s
.38889 .22222 m
.27778 .33333 L
s
.16667 .22222 m
.27778 .33333 L
s
.747 .885 .977 r
.61111 .22222 m
.61111 .22222 .04444 0 365.73 arc
F
.83333 .22222 m
.83333 .22222 .04444 0 365.73 arc
F
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.38889 .22222 m
.38889 .22222 .04444 0 365.73 arc
F
.16667 .22222 m
.16667 .22222 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(3)] .61111 .22222 0 0 Mshowa
[(0)] .83333 .22222 0 0 Mshowa
[(+)] .72222 .33333 0 0 Mshowa
[(3)] .38889 .22222 0 0 Mshowa
[(0)] .16667 .22222 0 0 Mshowa
[(+)] .27778 .33333 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0002d000H?c`o?3llj0006
3ll?c`o?>@001/l?c`o?3cX000K?3ll?c`l^0000:`002XH?QPn63hH?QPle000;3hH?QPn63hH?QPl0
=@002`n63hH?QPn63hH?03@000^63hH?QPn63hH?QP0/0000:@003`o?3ll?c`o?3ll?c`o?3`0a000>
3ll?c`o?3ll?c`o?3lla000?c`o?3ll?c`o?3ll?c`o?034000k?3ll?c`o?3ll?c`o?3bX0000X000@
3hH?QPn63hH?QPn63hH?QS00010?QPn63hH?QPn63hH?QPn6;`004HH?QPn63hH?QPn63hH?QPn602l0
01263hH?QPn63hH?QPn63hH?:@0002L0018?c`o?3ll?c`o?3ll?c`o?3ll]000Cc`o?3ll?c`o?3ll?
c`o?3ll?c`0]000Cc`o?3ll?c`o?3ll?c`o?3ll?c`0/000C3ll?c`o?3ll?c`o?3ll?c`o?3`0X0000
9P0050n63hH?QPn63hH?QPn63hH?QPn6:`0058H?QPn63hH?QPn63hH?QPn63hH?;00058H?QPn63hH?
QPn63hH?QPn63hH?:`0050n63hH?QPn63hH?QPn63hH?QPn6:00002H001G?3ll?c`o?3ll?c`o?3ll?
c`o?3ll0:P005@o?3ll?c`o?3ll?c`o?3ll?c`o?3`0[000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02X0
01G?3ll?c`o?3ll?c`o?3ll?c`o?3ll09`0002D001J63hH?QPn63hH?QPn63hH?QPn63hH?:@005Pn6
3hH?QPn63hH?QPn63hH?QPn63hHZ000F3hH?QPn63hH?QPn63hH?QPn63hH?QRT001J63hH?QPn63hH?
QPn63hH?QPn63hH?9`0002@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`lX000Gc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll0:00060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cbP001L?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3`0V0000900060n63hH?QPn63hH?QPn63hH?QPn63hH?QRP001L?QPn63hH?QPn63hH?QPn6
3hH?QPn63`0X000HQPn63hH?QPn63hH?QPn63hH?QPn63hH?:0005hH?QPn63hH?QPn63hH?QPn63hH?
QPn602H0000S000<3ll?c`o?3ll?c`o?0_l02`o?3ll?c`o?3ll?02L000X?c`o?3ll?c`o?0ol03<l?
c`o?3ll?c`o?3bH000_?3ll?c`o?3ll?c`03o`0;c`o?3ll?c`o?3ll09`002ll?c`o?3ll?c`o?00;o
00`?c`o?3ll?c`o?3llU00008`006HH?QPn63hH?QPn6ohH?o`n63hH?QPn63hH09`006HH?QPn63hH?
QPn63hKoQPn63hH?QPn63hH09P006@n63hH?QPn63hH?QPn6ohH?QPn63hH?QPl09`006@n63hH?QPn6
3hKoQPoo3hH?QPn63hH?QPl09@0002<001T?c`o?3ll?c`o?3ol?coo?3ll?c`o?3ll?02L001T?c`o?
3ll?c`o?3ll?o`o?3ll?c`o?3ll?02H001W?3ll?c`o?3ll?c`o?3ol?c`o?3ll?c`o?02L001W?3ll?
c`o?3ll?o`o?oll?c`o?3ll?c`o?02D0000S000IQPn63hH?QPn63hKoQPoo3hH?QPn63hH?QP0W000;
QPn63hH?QPn63hH00_l030n63hH?QPn63hH?QRH000`?QPn63hH?QPn63hH2o`0;3hH?QPn63hH?QPl0
9`006@n63hH?QPn63hKoQPoo3hH?QPn63hH?QPl09@0002<001T?c`o?3ll?c`o?3ol?coo?3ll?c`o?
3ll?02L001T?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?02H001W?3ll?c`o?3ll?c`o?3ol?c`o?3ll?
c`o?02L001W?3ll?c`o?3ll?o`o?oll?c`o?3ll?c`o?02D0000S000<QPn63hH?QPn63hH?0_l02hH?
QPn63hH?QPn602L000Z63hH?QPn63hH?0ol030n63hH?QPn63hH?QRH000/?QPn63hH?QPn63`03o`0;
3hH?QPn63hH?QPl09`002`n63hH?QPn63hH?00;o00b63hH?QPn63hH?QPlU000090006<l?c`o?3ll?
c`o?3ll?c`o?3ll?c`o?3bL001T?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?02L001P?c`o?3ll?c`o?
3ll?c`o?3ll?c`o?3llW000Ic`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`0U0000900060n63hH?QPn6
3hH?QPn63hH?QPn63hH?QRL001V63hH?QPn63hH?QPn63hH?QPn63hH?QPn602L001R63hH?QPn63hH?
QPn63hH?QPn63hH?QPlW000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`0U00009@005Po?3ll?c`o?
3ll?c`o?3ll?c`o?3llY000Gc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll0:@005/l?c`o?3ll?c`o?3ll?
c`o?3ll?c`lY000G3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`l09P0002D001J63hH?QPn63hH?QPn63hH?
QPn63hH?:@005`n63hH?QPn63hH?QPn63hH?QPn63hH?02T001H?QPn63hH?QPn63hH?QPn63hH?QPn6
:@005hH?QPn63hH?QPn63hH?QPn63hH?QPn602H0000U000E3ll?c`o?3ll?c`o?3ll?c`o?3ll?02/0
01D?c`o?3ll?c`o?3ll?c`o?3ll?c`l0:P005Ll?c`o?3ll?c`o?3ll?c`o?3ll?c`0[000Ec`o?3ll?
c`o?3ll?c`o?3ll?c`o?02L0000V000D3hH?QPn63hH?QPn63hH?QPn63hH/000C3hH?QPn63hH?QPn6
3hH?QPn63`0/000DQPn63hH?QPn63hH?QPn63hH?QPl/000CQPn63hH?QPn63hH?QPn63hH?QP0X0000
:0004/l?c`o?3ll?c`o?3ll?c`o?ob/001?o003?3ll?c`o?3ll?c`o?3ll?02l001<?c`o?3ll?c`o?
3ll?c`o?3`3o02/001;o00o?3ll?c`o?3ll?c`o?3llY0000:@003hH?QPn63hH?QPn63hH?QP020003
o`0002L000?o00000P003XH?QPn63hH?QPn63hH?<P003XH?QPn63hH?QPn63hH?0`000ol0000W000B
o`0000n63hH?QPn63hH?QPn6:P0002X000c?3ll?c`o?3ll?c`l50003o`0002D000?o000010002ll?
c`o?3ll?c`o?03D000_?3ll?c`o?3ll?c`060003o`0002D000?o00000`002`o?3ll?c`o?3ll?02`0
000_0004QPn63`T000?o00008`000ol0000:0004QPn63c/000@?QPn62P000ol0000S0003o`0000T0
00@?QPn6;P0003d000?o00008@000ol0001I0003o`00024000?o0000?00003h000?o00007`000ol0
001K0003o`0001l000?o0000?@0003l000?o00007@000ol0001M0003o`0001d000?o0000?P000400
00?o00006`000ol0001O0003o`0001/000?o0000?`00044000?o00006@000ol0001Q0003o`0001T0
00?o0000@000048000?o00005`000ol0001S0003o`0001L000?o0000@@0004<000?o00001`001Po?
3ll?c`P000?o0000I@000ol000060006c`o?3ll?2@000ol000120000A0000ol00003000;3hH?QPn6
3hH?QPl01@000ol0001W0003o`0000<000X?QPn63hH?QPn61P000ol000130000A@004_l00<l?c`o?
3ll?c`o?3ll?c`8000?o0000J@004Ol03ll?c`o?3ll?c`o?3ll?00<000?o0000A00004H001?oQPn6
3hH?QPn63hH?QPn63hKo06d001<?QPn63hH?QPn63hH?QPn63`3o04L00016000Cc`o?3ll?c`o?3ll?
c`o?3ll?c`1/000C3ll?c`o?3ll?c`o?3ll?c`o?3`180000A@005HH?QPn63hH?QPn63hH?QPn63hH?
QP1Z000E3hH?QPn63hH?QPn63hH?QPn63hH?04L00015000F3ll?c`o?3ll?c`o?3ll?c`o?3ll?cfT0
01K?3ll?c`o?3ll?c`o?3ll?c`o?3ll?AP0004@001L?QPn63hH?QPn63hH?QPn63hH?QPn63`1X000G
QPn63hH?QPn63hH?QPn63hH?QPn63hH0AP0004@001S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`mW000H
3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?A@0004<001V63hH?QPn63hH?QPn63hH?QPn63hH?QPn606H0
01T?QPn63hH?QPn63hH?QPn63hH?QPn63hH?04D00013000I3ll?c`o?3ll?c`o?oll?c`o?3ll?c`o?
3`1V000Ic`o?3ll?c`o?3ll?coo?3ll?c`o?3ll?c`150000@`006HH?QPn63hH?QPn63ol?QPn63hH?
QPn63hH0IP006@n63hH?QPn63hH?QPoo3hH?QPn63hH?QPl0A@0004<000X?c`o?3ll?c`o?1Ol02/l?
c`o?3ll?c`mV000;c`o?3ll?c`o?3ll01Ol02Ll?c`o?3ll?c`150000@`006HH?QPn63hH?QPn63ol?
QPn63hH?QPn63hH0IP006@n63hH?QPn63hH?QPoo3hH?QPn63hH?QPl0A@0004<001T?c`o?3ll?c`o?
3looc`o?3ll?c`o?3ll?06H001W?3ll?c`o?3ll?c`o?oll?c`o?3ll?c`o?04D00013000IQPn63hH?
QPn63hH?QPn63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`150000A0006<l?
c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3lm50000A0005`n6
3hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?QPn63hH?QPn63hH?QP160000A@005Po?
3ll?c`o?3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3dH00015000FQPn63hH?
QPn63hH?QPn63hH?QPn63fT001H?QPn63hH?QPn63hH?QPn63hH?QPn6AP0004H001C?3ll?c`o?3ll?
c`o?3ll?c`o?3f/001@?c`o?3ll?c`o?3ll?c`o?3ll?cdL00017000BQPn63hH?QPn63hH?QPn63hH?
K@004Pn63hH?QPn63hH?QPn63hH?QTP00018000@c`o?3ll?c`o?3ll?c`o?3fl0010?c`o?3ll?c`o?
3ll?c`o?B@0004X000d?QPn63hH?QPn63hH?078000f63hH?QPn63hH?QPn604X0001=00083ll?c`o?
3lmg0008c`o?3ll?c`m<0000C`000hH?001l00033hH004l0003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
000a0003o`00020000?o0000K`000ol0000V0003o`0002h0000`0003o`00028000?o0000K@000ol0
000X0003o`0002d0000`0003o`0000801Ol90003o`0000L01?l40003o`0000T000?o00002003ocd0
1Ol90003o`0000P000?o00000P04o`X000?o00003P03o`@000?o0000;@00030000?o00000P001?l0
0?l:0003o`0000L000Go0000o`030003o`0000T000?o00001`001Ol0003o03`000Co003o2P000ol0
00080003o`00008000Go0000o`090003o`0000d000Go0000o`030003o`0002d0000`0003o`000080
1?l800Go1`001Ol0003o00<000?o00001`05o`L000?o0000?P04o`P01Ol80003o`00008000Go0000
o`0700Go3@000ol000050003o`0002d0000`0003o`0000D000?o000020000ol000070005o`000?l0
0`000ol000090003o`0000L000Go0000o`0o0003o`0000P000?o000020000ol000020005o`000?l0
2@000ol0000=0005o`000?l00`000ol0000]0000<0000ol0000300?o2P000ol0000700Co10000ol0
00090003o`0000P01?lm00?o2P000ol000080003o`0000801?l:0003o`0000h01?l30003o`0002d0
000a0003o`0001T000?o000010000ol0001_0005o`000?l090000ol0000^0000C002og/00_mE0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"AdditiveP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a + \\(b +  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a + b\\) + c)] .27778 .44444 0 0 Mshowa
.747 .885 .977 r
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(3+0)] .72222 .33333 0 0 Mshowa
[(0+3)] .27778 .33333 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0004d0
00H?c`o?3lmi0006c`o?3ll?CP0004X000/?QPn63hH?QPn63`1e000:3hH?QPn63hH?QT`00018000?
c`o?3ll?c`o?3ll?c`o?070000l?c`o?3ll?c`o?3ll?c`l0BP0004L001663hH?QPn63hH?QPn63hH?
QP1^000A3hH?QPn63hH?QPn63hH?QPl0B@0004H001??3ll?c`o?3ll?c`o?3ll?c`o?06`001<?c`o?
3ll?c`o?3ll?c`o?3ll?04P00015000EQPn63hH?QPn63hH?QPn63hH?QPn606X001D?QPn63hH?QPn6
3hH?QPn63hH?QPl0A`0004D001H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?J@005/l?c`o?3ll?c`o?3ll?
c`o?3ll?c`m60000A0005`n63hH?QPn63hH?QPn63hH?QPn63hH?06P001N63hH?QPn63hH?QPn63hH?
QPn63hH?QP160000A0006<l?c`o?3ll?c`o?3ll?c`o?3ll?c`o?3fL001P?c`o?3ll?c`o?3ll?c`o?
3ll?c`o?3lm50000@`006HH?QPn63hH?QPn63hH?QPn63hH?QPn63hH0IP006@n63hH?QPn63hH?QPn6
3hH?QPn63hH?QPl0A@0004<000D?c`o?3`02o`09c`o?3looc`o?00?o00K?3ll?c`mV0005c`o?3ll0
0ol02/l?c`o?oll?c`l2o`05c`o?3ll0A@0004<001V63hH?o`n6ohH?QPoo3hH?QPn6ohH?QPn606H0
01T?QPn63hH?Q_n63hH?o`n63ol?Q_n63hH?04D00013000:3ll?coo?3ol?c`Go00[?3ll?o`o?3ll?
IP002ll?c`o?3ll?o`o?00Go00W?oll?o`o?3ll0A@0004<001663hH?o`n6ohH?QPoo3hH?QP02o`06
3hH?QPn6IP001Pn63hH?QP;o014?QPn63ol?QPoo3hKoQPn63`150000@`006@o?3looc`oo3ll?coo?
3ll?c`oo3ll?c`l0IP006Ll?c`o?3ll?o`o?3looc`o?oll?o`o?3ll0A@0004<000F63hH?QP02o`09
3hH?QPn63hH?00?o00H?QPn63hIV00053hH?QPl00ol02Pn63hH?QPn63hH2o`053hH?QPl0A@0004@0
01S?3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`mW000H3ll?c`o?3ll?c`o?3ll?c`o?3ll?c`o?A@0004@0
01L?QPn63hH?QPn63hH?QPn63hH?QPn63`1X000GQPn63hH?QPn63hH?QPn63hH?QPn63hH0AP0004D0
01H?c`o?3ll?c`o?3ll?c`o?3ll?c`o?J@005/l?c`o?3ll?c`o?3ll?c`o?3ll?c`m60000A@005XH?
QPn63hH?QPn63hH?QPn63hH?QPmY000F3hH?QPn63hH?QPn63hH?QPn63hH?QTH00016000Dc`o?3ll?
c`o?3ll?c`o?3ll?c`m[000D3ll?c`o?3ll?c`o?3ll?c`o?3lm70000A`004XH?QPn63hH?QPn63hH?
QPn63fd0018?QPn63hH?QPn63hH?QPn63hI80000B0004<l?c`o?3ll?c`o?3ll?c`m_000@3ll?c`o?
3ll?c`o?3ll?cdT0001:000=3hH?QPn63hH?QPn63`1b000=QPn63hH?QPn63hH?QP1:0000C@0020o?
3ll?c`o?M`002<l?c`o?3ll?C00004l000>63`00O0000`n6001?0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000<@000ol0000P0003o`0006l000?o00009P000ol0000^0000<0000ol0000R0003o`0006d0
00?o0000:0000ol0000]0000<0000ol0000200Go2@000ol0000700Co10000ol000090003o`0000P0
0olm00Go2@000ol000080003o`0000801?l:0003o`0000h00ol40003o`0002d0000`0003o`000080
00Co003o2P000ol000070005o`000?l00`000ol000090003o`0000L000Go0000o`0l0004o`00o`X0
00?o000020000ol000020005o`000?l02@000ol0000=0005o`000?l00`000ol0000]0000<0000ol0
000200Co2005o`L000Go0000o`030003o`0000L01Ol70003o`0003h01?l800Go20000ol000020005
o`000?l01`05o`d000?o00001@000ol0000]0000<0000ol000050003o`0000P000?o00001`001Ol0
003o00<000?o00002@000ol000070005o`000?l0?`000ol000080003o`0000P000?o00000P001Ol0
003o00T000?o00003@001Ol0003o00<000?o0000;@00030000?o00000`03o`X000?o00001`04o`@0
00?o00002@000ol0000800Co?@03o`X000?o000020000ol0000200Co2P000ol0000>00Co0`000ol0
000]0000<@000ol0000I0003o`0000@000?o0000K`001Ol0003o02@000?o0000;P0004`00_mk00;o
E@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"AdditiveP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.111111 0.222222 0.111111 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
0 g
[(a + \\(b +  c\\))] .72222 .44444 0 0 Mshowa
[(\\(a + b\\) + c)] .27778 .44444 0 0 Mshowa
.747 .885 .977 r
.72222 .33333 m
.72222 .33333 .04444 0 365.73 arc
F
.27778 .33333 m
.27778 .33333 .04444 0 365.73 arc
F
0 0 0 r
[(3)] .72222 .33333 0 0 Mshowa
[(3)] .27778 .33333 0 0 Mshowa
[(The two results are equal.)] .5 .25556 0 0 Mshowa
[( Associativity is possible.)] .5 .2 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[32]:=",
  ImageSize->{288, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0008`0
0olK00CoLP0008d000?o00006`000ol0001b0000A002o`030?oo00801?l200Co0`03o`<00ol200Go
00<0ool00ol200?o0P05o`800_l300Go0P03o`<000?o00002005o`030?oo00;o2004o`<00ol200Co
0P04o`801Ol00`3oo`02o`801Ol200Co0P02od8000150003o`3o00H000?o00000`001?l00?l30003
o`3o00<000Go0000o`030004o`00o`<000Co003o0`000ol0000200;o1@000ol000020004o`00o`80
00?o00002P000ol000040003o`0000H000Oo0000o`3o00<000?o00000P000ol000030003o`000080
00Go0000o`030005o`000?l00`000ol0000400;o@P0004D00ol300Co0P04o`8000Oo0000o`3o00L0
00Co00001?l30003o`0000@000Ko0000o`02o`@000?o00000P000ol000020003o`3o00/000Co0000
1?l80007o`000?l0o`030003o`3o00?o0P04o`@000Go0000o`030005o`000?l00`05odH000150003
o`3o00<000?o00000`000ol000030007o`000?l0o`030005o`000?l01P001Ol0003o00H000Go0000
o`020003o`00008000?o00000P000ol000020003o`3o00/000Go0000o`0;0007o`000?l0o`030003
o`3o00D000?o00001@001Ol0003o00<000Go0000o`030005o`000?l0AP0004H000?o00000P04o`80
1?l300?o0`04o`800_l400?o0P04o`<00_l200;o0P02o`800_l300Co00@0ool00_l900;o0`04o`L0
1Ol300?o0P04o`801?l300;o0`04o`@000?o00000P03odL0001500;o:@000ol0000E0003o`0003h0
00?o00001@000ol0001<0000I@000ol000080003o`0000@000?o00002@000ol000020003o`000100
00?o00009`000ol00002o`D00om>0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000`P04oeX000340003o`0005T0001300?o0P02o`030?oo00801?l800?o0P001?l00?l300?o
2004o`<01?l00`3oo`02o`801Ol00`3oo`03o`800ol200Co2005o`030?oo00;o0`04o`P01?l200Co
00<0ool00ol00`3oo`03o`030?oo00?o0P02odD000140005o`000?l00P001?l00?l<0005o`00o`00
1?l20005o`000?l020000ol000020003o`0000H000Co003o0P000ol000020003o`00008000Co003o
10000ol000060004o`00o`<000?o00000P000ol000090003o`0000<000Oo0000o`3o008000Co003o
0P000ol000020003o`0000800_m50000A0001Ol0003o008000?o00001Ol80003o`0000801?l20005
o`000?l020000ol0000200Go00<0ool00_l20004o`00o`@000?o00000P000ol0000200Co2004o`<0
00?o00000P05o`L01Ol00`3o00020003o`3o008000?o00001?l40003o`0004T000120007o`3o0?l0
o`020004o`00o`<000?o00001P000ol000020004o`00o`8000Go0000o`0800;o0`001ol0003o0?l0
1@001?l00?l40003o`00008000?o00000P000ol0000<0004o`0000;o0`001Ol0003o00L000Oo0000
o`3o00<000?o0?l00P000ol000030003o`00008000?o0000B@00048000Ko0?l0o`04o`<00ol800Co
00<0ool00P02o`800ol800;o00<0ool00P03o`801?l0103oo`02o`@000Co00001?l200Co2@03o`80
0_l00`3oo`0200?o2@03o`<01_l00`3oo`0300?o10000ol000190000@P05o`030?l0014000?o0000
;P000ol000020003o`00040000?o0000B@0004L00_lB0003o`0002`00ol40003o`0003h00om;0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000C@001Po?3ll?cgT000K?3ll?c`m>0000BP002`n6
3hH?QPn63hH?07D000X?QPn63hH?QPn6C00004P000o?3ll?c`o?3ll?c`o?3ll0L0003`o?3ll?c`o?
3ll?c`o?3`1:0000A`004HH?QPn63hH?QPn63hH?QPn606h0014?QPn63hH?QPn63hH?QPn63`190000
AP004ll?c`o?3ll?c`o?3ll?c`o?3ll0K0004`o?3ll?c`o?3ll?c`o?3ll?c`l0B00004D001F63hH?
QPn63hH?QPn63hH?QPn63hH0JP005@n63hH?QPn63hH?QPn63hH?QPn63`170000A@005Po?3ll?c`o?
3ll?c`o?3ll?c`o?3lmY000Fc`o?3ll?c`o?3ll?c`o?3ll?c`o?3dH00014000G3hH?QPn63hH?QPn6
3hH?QPn63hH?QPl0J0005hH?QPn63hH?QPn63hH?QPn63hH?QPn604H00014000Hc`o?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?I`0060o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?cdD00013000IQPn63hH?QPn63hH?
QPn63hH?QPn63hH?QP1V000I3hH?QPn63hH?QPn63hH?QPn63hH?QPn63`150000@`002Po?3ll?c`o?
3ll3o`0<c`o?3ll?c`o?3ll?IP002ll?c`o?3ll?c`o?00?o00_?3ll?c`o?3ll?c`150000@`006HH?
QPn63hH?QPn63hKoQPn63hH?QPn63hH0IP006@n63hH?QPn63hH?QPn6ohH?QPn63hH?QPl0A@0004<0
01T?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?06H001W?3ll?c`o?3ll?c`o?3ol?c`o?3ll?c`o?04D0
0013000;QPn63hH?QPn63hH00_l030n63hH?QPn63hH?QVH000`?QPn63hH?QPn63hH2o`0;3hH?QPn6
3hH?QPl0A@0004<001T?c`o?3ll?c`o?3ll?o`o?3ll?c`o?3ll?06H001W?3ll?c`o?3ll?c`o?3ol?
c`o?3ll?c`o?04D00013000:QPn63hH?QPn63`?o00`?QPn63hH?QPn63hIV000;3hH?QPn63hH?QPl0
0ol02`n63hH?QPn63hH?04D00014000Hc`o?3ll?c`o?3ll?c`o?3ll?c`o?3ll?I`0060o?3ll?c`o?
3ll?c`o?3ll?c`o?3ll?cdD00014000G3hH?QPn63hH?QPn63hH?QPn63hH?QPl0J0005hH?QPn63hH?
QPn63hH?QPn63hH?QPn604H00015000F3ll?c`o?3ll?c`o?3ll?c`o?3ll?cfT001K?3ll?c`o?3ll?
c`o?3ll?c`o?3ll?AP0004D001J63hH?QPn63hH?QPn63hH?QPn63hH?J@005Pn63hH?QPn63hH?QPn6
3hH?QPn63hI60000AP005<l?c`o?3ll?c`o?3ll?c`o?3ll?J`0050o?3ll?c`o?3ll?c`o?3ll?c`o?
A`0004L001:63hH?QPn63hH?QPn63hH?QPm]000B3hH?QPn63hH?QPn63hH?QPn6B00004P0013?3ll?
c`o?3ll?c`o?3ll?K`0040o?3ll?c`o?3ll?c`o?3lm90000BP003@n63hH?QPn63hH?QPl0LP003HH?
QPn63hH?QPn63hH0BP0004d000P?c`o?3ll?cgL000S?3ll?c`o?3d`0001?0003QPl007`000<?QP00
C`000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@00034000?o000080000ol0001_0003o`0002H000?o0000
;P00030000?o00008P000ol0001]0003o`0002P000?o0000;@00030000?o00000P05o`T000?o0000
1`04o`@000?o00002@000ol0000800?o?@05o`T000?o000020000ol0000200Co2P000ol0000>00?o
10000ol0000]0000<0000ol000020004o`00o`X000?o00001`001Ol0003o00<000?o00002@000ol0
00070005o`000?l0?0001?l00?l:0003o`0000P000?o00000P001Ol0003o00T000?o00003@001Ol0
003o00<000?o0000;@00030000?o00000P04o`P01Ol70005o`000?l00`000ol0000700Go1`000ol0
000n00Co2005o`P000?o00000P001Ol0003o00L01Ol=0003o`0000D000?o0000;@00030000?o0000
1@000ol000080003o`0000L000Go0000o`030003o`0000T000?o00001`001Ol0003o03l000?o0000
20000ol000080003o`00008000Go0000o`090003o`0000d000Go0000o`030003o`0002d0000`0003
o`0000<00ol:0003o`0000L01?l40003o`0000T000?o00002004ocd00ol:0003o`0000P000?o0000
0P04o`X000?o00003P04o`<000?o0000;@00034000?o00006@000ol000040003o`0006l000Go0000
o`0T0003o`0002h0001<00;oN`02oeD0003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-4.51578, -2.00002, 0.0314689, 
  0.0314689}},
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[32]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode illustrates the symmetry involved in the commutative property."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CommutativeQ[Z[5], Operation \[Rule] Addition, Mode \[Rule] Visual]\)], 
  "Input",
  CellLabel->"In[33]:=",
  CellTags->"AdditiveP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 1 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.5 .66071 m
.5 .81944 L
.65873 .81944 L
.65873 .66071 L
F
.65873 .66071 m
.65873 .81944 L
.81746 .81944 L
.81746 .66071 L
F
.81746 .66071 m
.81746 .81944 L
.97619 .81944 L
.97619 .66071 L
F
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
.5 .50198 m
.5 .66071 L
.65873 .66071 L
.65873 .50198 L
F
.65873 .50198 m
.65873 .66071 L
.81746 .66071 L
.81746 .50198 L
F
.81746 .50198 m
.81746 .66071 L
.97619 .66071 L
.97619 .50198 L
F
.18254 .34325 m
.18254 .50198 L
.34127 .50198 L
.34127 .34325 L
F
.34127 .34325 m
.34127 .50198 L
.5 .50198 L
.5 .34325 L
F
.5 .34325 m
.5 .50198 L
.65873 .50198 L
.65873 .34325 L
F
.65873 .34325 m
.65873 .50198 L
.81746 .50198 L
.81746 .34325 L
F
.81746 .34325 m
.81746 .50198 L
.97619 .50198 L
.97619 .34325 L
F
.18254 .18452 m
.18254 .34325 L
.34127 .34325 L
.34127 .18452 L
F
.34127 .18452 m
.34127 .34325 L
.5 .34325 L
.5 .18452 L
F
.5 .18452 m
.5 .34325 L
.65873 .34325 L
.65873 .18452 L
F
.65873 .18452 m
.65873 .34325 L
.81746 .34325 L
.81746 .18452 L
F
.81746 .18452 m
.81746 .34325 L
.97619 .34325 L
.97619 .18452 L
F
.18254 .02579 m
.18254 .18452 L
.34127 .18452 L
.34127 .02579 L
F
.34127 .02579 m
.34127 .18452 L
.5 .18452 L
.5 .02579 L
F
.5 .02579 m
.5 .18452 L
.65873 .18452 L
.65873 .02579 L
F
.65873 .02579 m
.65873 .18452 L
.81746 .18452 L
.81746 .02579 L
F
.81746 .02579 m
.81746 .18452 L
.97619 .18452 L
.97619 .02579 L
F
1 1 0 r
3 Mabswid
[ ] 0 setdash
.18254 .81944 m
.97619 .02579 L
s
.18254 .50198 m
.5 .81944 L
s
.18254 .34325 m
.65873 .81944 L
s
.18254 .18452 m
.81746 .81944 L
s
.18254 .02579 m
.97619 .81944 L
s
.34127 .02579 m
.97619 .66071 L
s
.5 .02579 m
.97619 .50198 L
s
.65873 .02579 m
.97619 .34325 L
s
0 g
.008 w
.18254 .02579 Mdot
[(0)] .2619 .74008 0 0 Mshowa
[(1)] .42063 .74008 0 0 Mshowa
[(2)] .57937 .74008 0 0 Mshowa
[(3)] .7381 .74008 0 0 Mshowa
[(4)] .89683 .74008 0 0 Mshowa
[(1)] .2619 .58135 0 0 Mshowa
[(2)] .42063 .58135 0 0 Mshowa
[(3)] .57937 .58135 0 0 Mshowa
[(4)] .7381 .58135 0 0 Mshowa
[(0)] .89683 .58135 0 0 Mshowa
[(2)] .2619 .42262 0 0 Mshowa
[(3)] .42063 .42262 0 0 Mshowa
[(4)] .57937 .42262 0 0 Mshowa
[(0)] .7381 .42262 0 0 Mshowa
[(1)] .89683 .42262 0 0 Mshowa
[(3)] .2619 .26389 0 0 Mshowa
[(4)] .42063 .26389 0 0 Mshowa
[(0)] .57937 .26389 0 0 Mshowa
[(1)] .7381 .26389 0 0 Mshowa
[(2)] .89683 .26389 0 0 Mshowa
[(4)] .2619 .10516 0 0 Mshowa
[(0)] .42063 .10516 0 0 Mshowa
[(1)] .57937 .10516 0 0 Mshowa
[(2)] .7381 .10516 0 0 Mshowa
[(3)] .89683 .10516 0 0 Mshowa
[(0)] .10317 .74008 0 0 Mshowa
[(1)] .10317 .58135 0 0 Mshowa
[(2)] .10317 .42262 0 0 Mshowa
[(3)] .10317 .26389 0 0 Mshowa
[(4)] .10317 .10516 0 0 Mshowa
[(0)] .2619 .89881 0 0 Mshowa
[(1)] .42063 .89881 0 0 Mshowa
[(2)] .57937 .89881 0 0 Mshowa
[(3)] .7381 .89881 0 0 Mshowa
[(4)] .89683 .89881 0 0 Mshowa
[(Add\\(Z[5]\\))] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
1 Mabswid
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[33]:=",
  ImageSize->{265.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P0002l00mlW00?O9`03gbL00mmA00?O1@0000H0oOl00ml0000300001P000ol0000V00;o
0]lV0004gooOgbH000?Ooml00]lU0003gooO00;O9P000ol0000U00;O00?og`00100000H000?o0000
9P02o`?O9@000moog`02gbH000?ogml00]lU0003omoO00;O9@000ol0000T00?O00?og`00100000H0
00?o00009P02o`CO9@000ooOg`02gbD000?ogml00mlT0003omoO00?O90000ol0000S00CO00?o0000
100000H000?o00009P02o`GO90000ooOg`03gb@000?o0=l01=lS0003o`3O00CO8`000ol0000R00GO
00?o0000100000H000?o00009P02o`030=oO00?O8`000ol0g`04gb<000?o00001MlR0003o`0000GO
8P000ol0000Q00GO00<0o`001@0000H000?o00009P02o`801MlR0003o`0000GO8P001?l00005gb40
00Co00001MlQ0003o`0002001Ml20003o`0000@000060003o`0002H00_l300GO8@001?l00005gb40
00?o00000P05gb0000?o00000P05gb0000?o00007`05g`<000?o0000100000H000?o00009P02o`@0
1MlP0003o`0000801MlP0003o`0000<01MlO0003o`0000<01MlO0003o`0001h01Ml40003o`0000@0
00060003o`0002H00_l500GO7`000ol0000300GO7`000ol0000400GO7P000ol0000400GO7P000ol0
000M00GO1@000ol0000400001P000ol0000V00;o1P05gah000?o00001005gah000?o00001@05gad0
00?o00001@05gad000?o00007005g`H000?o0000100000H000?o00009P02o`L01MlM0003o`0000D0
1MlM0003o`0000H01MlL0003o`0000H01MlL0003o`0001/01Ml70003o`0000@000060003o`0002H0
0_l800GO70000ol0000600GO70000ol0000700GO6`000ol0000700GO6`000ol0000J00GO20000ol0
000400001P000ol0000V00;o2@05ga/000?o00001`05ga/000?o00002005gaX000?o00002005gaX0
00?o00006@05g`T000?o0000100000H000?o00009P02o`X01MlJ0003o`0000P01MlJ0003o`0000T0
1MlI0003o`0000T01MlI0003o`0001P01Ml:0003o`0000@000060003o`0002H00_l;00GO6@000ol0
000900GO6@000ol0000:00GO60000ol0000:00GO60000ol0000G00GO2`000ol0000400001P000ol0
000V00;o3005gaP000?o00002P05gaP000?o00002`05gaL000?o00002`05gaL000?o00005P05g``0
00?o0000100000H000?o00009P02o`d01MlG0003o`0000/01MlG0003o`0000`01MlF0003o`0000`0
1MlF0003o`0001D01Ml=0003o`0000@000060003o`0002H00_l>00GO5P000ol0000<00GO5P000ol0
000=00GO5@000ol0000=00GO5@000ol0000D00GO3P000ol0000400001P000ol0000A00?o4P02o`l0
1=l3oa<000?o00003@04g`;o50000ol0000>00;O0olD0003o`0000h00]l4oa<000?o00004003o`GO
3`000ol0000400001P000ol0000B0003o`0001400_l@00CO00?o00004P000ol0000>00;O00Cogmoo
4`000ol0000?00;O00?ogml04`000ol0000?00;O00?ogml04`000ol0000B0003gooO00;O40000ol0
000400001P000ol0000@00Co4P02oa4000?Oool00_lC0003o`0000l000GOomoOo`0C0003o`000100
00?Ooml00]lB0003o`0001000]l00ooOg`0B0003o`0001400]l00ooOg`0A0003o`0000@000060003
o`00010000?o0?l04`02oa8000?ogol00]lB0003o`00010000Gogmoog`0B0003o`00014000?ogml0
0]lA0003o`0001400]l00ooOg`0A0003o`00010000?Oool00]lB0003o`0000@000060003o`000100
00?o0?l04`02oa8000?ogol00mlA0003o`00010000Cogmoo0]lA0003o`00014000?ogml00ml@0003
o`00010000Co0=oo0ml@0003o`0000l01=l00ol0000A0003o`0000@000060003o`0001400_lC00;o
4`02o`CO40000ol0000A00;o1=l@0003o`0001000_l00`3Og`03g`l000?o00004@02o`GO3`000ol0
000>00;O0olD0003o`0000@000060003o`0002H00_lE00GO3`000ol0000C00GO3`000ol0000D00GO
3P000ol0000D00GO3P000ol0000=00GO5@000ol0000400001P000ol0000V00;o5P05g`h000?o0000
5005g`h000?o00005@05g`d000?o00005@05g`d000?o00003005gaH000?o0000100000H000?o0000
9P02oaL01Ml=0003o`0001D01Ml=0003o`0001H01Ml<0003o`0001H01Ml<0003o`0000/01MlG0003
o`0000@000060003o`0002H00_lH00GO30000ol0000F00GO30000ol0000G00GO2`000ol0000G00GO
2`000ol0000:00GO60000ol0000400001P000ol0000V00;o6@05g`/000?o00005`05g`/000?o0000
6005g`X000?o00006005g`X000?o00002@05gaT000?o0000100000H000?o00009P02oaX01Ml:0003
o`0001P01Ml:0003o`0001T01Ml90003o`0001T01Ml90003o`0000P01MlJ0003o`0000@000060003
o`0002H00_lK00GO2@000ol0000I00GO2@000ol0000J00GO20000ol0000J00GO20000ol0000700GO
6`000ol0000400001P000ol0000V00;o7005g`P000?o00006P05g`P000?o00006`05g`L000?o0000
6`05g`L000?o00001P05ga`000?o0000100000H000?o00009P02oad01Ml70003o`0001/01Ml70003
o`0001`01Ml60003o`0001`01Ml60003o`0000D01MlM0003o`0000@000060003o`0002H00_lN00GO
1P000ol0000L00GO1P000ol0000M00GO1@000ol0000M00GO1@000ol0000400GO7P000ol000040000
1P000ol0000V00;o7`05g`D000?o00007@05g`D000?o00007P05g`@000?o00007P05g`@000?o0000
0`05gal000?o0000100000H000?o00009P02ob001Ml40003o`0001h01Ml40003o`0001l01Ml30003
o`0001l01Ml30003o`0000801MlP0003o`0000@000060003o`0002H00_lQ00GO0`000ol0000O00GO
0`000ol0000P00GO0P000ol0000P00GO0P001?l00005gb4000?o0000100000H000?o00009P02ob80
1Ml20003o`0002001Ml20003o`0002401Ml00`3o000R00GO00@0o`001MlR0003o`0000@000060003
o`0002H00_lS00GO00<0o`008P05g`030?l002<01Ml00ol0000R00GO00?o0=l01=lS0003o`0000@0
00060003o`0002H00_lT00GO00?o00008P05g`03o`0002<01=l00ol0000S00CO00?ogml00mlT0003
o`0000@000060003o`0002H00_l00ml0000R00CO00?o00008`04g`03o`0002@00ml00ooO000T00?O
00?ogml00]lU0003o`0000@000060?go1P0000H000?o00009P02o`;O9@02g`03omoO02D00]l00ooO
g`0V0003gooO00;O9002g`04omoOgbH000?o0000100000H000?o00009P02o`?O9@000moog`02gbD0
00?Ooml00]lV0003omoO00;O8P03g`03omoO00;O9@000ol0000400001P000ol0000V00;o1=lU0003
omoO00;O9@000ooOg`02gbD000?ogml00mlP00CO00?ogml00mlT0003o`0000@000060003o`0002H0
0_l5gb@000?ogml00mlT0003omoO00?O90000ol0g`04gah01Ml00ol0g`04gb<000?o0000100000H0
00?o00009P02o`030=oO00?O8`000ol0g`04gb<000?o0=l01=lS0003o`0000GO7005g`040?l000GO
8P000ol0000400001P000ol0000V00;o0P05gb8000?o00001MlR0003o`0000GO8P001?l00005gaX0
1Ml20004o`0000GO8@000ol0000400001P000ol0000V00;o0`05gb4000Co00001MlQ0004o`0000GO
8@000ol0000200GO6005g`<000?o00000P05gb0000?o0000100000H000?o00009P02o`@01MlP0003
o`0000801MlP0003o`0000801MlP0003o`0000<01MlF00GO10000ol0000300GO7`000ol000040000
1P000ol0000V00;o1@05gal000?o00000`05gal000?o00000`05gal000?o00001005ga@01Ml50003
o`0000@01MlN0003o`0000@000060003o`0002H00_l600GO7P000ol0000400GO7P000ol0000400GO
7P000ol0000500GO4P05g`H000?o00001@05gad000?o0000100000H000?o00009P02o`L01MlM0003
o`0000D01MlM0003o`0000D01MlM0003o`0000H01Ml@00GO1`000ol0000600GO70000ol000040000
1P000ol0000V00;o2005ga`000?o00001P05ga`000?o00001P05ga`000?o00001`05g`h01Ml80003
o`0000L01MlK0003o`0000@000060003o`0002H00_l900GO6`000ol0000700GO6`000ol0000700GO
6`000ol0000800GO3005g`T000?o00002005gaX000?o0000100000H000?o00009P02o`X01MlJ0003
o`0000P01MlJ0003o`0000P01MlJ0003o`0000T01Ml:00GO2P000ol0000900GO6@000ol000040000
1P000ol0000V00;o2`05gaT000?o00002@05gaT000?o00002@05gaT000?o00002P05g`P01Ml;0003
o`0000X01MlH0003o`0000@000060003o`0002H00_l<00GO60000ol0000:00GO60000ol0000:00GO
60000ol0000;00GO1P05g``000?o00002`05gaL000?o0000100000H000?o00009P02o`d01MlG0003
o`0000/01MlG0003o`0000/01MlG0003o`0000`01Ml400GO3@000ol0000<00GO5P000ol000040000
1P000ol0000V00;o3P05gaH000?o00003005gaH000?o00003005gaH000?o00003@05g`801Ml>0003
o`0000d01MlE0003o`0000@000060003o`0001000olC00;o3`03g`?o50000ol0000=00CO0olC0003
o`0000d01=l2oa@000?o00003P02g`?o1Ml?0003o`0000h00]l4oa<000?o0000100000H000?o0000
4`000ol0000@00;o4005g`03o`00014000?o00003P04g`03o`00018000?o00003P02g`04omoOoa<0
00?o00003`02g`03omoO00?O40000ol0000?00;O00?ogml04`000ol0000400001P000ol0000C0003
o`0001000_lA00CO00?o00004@000ol0000?0003gooo00;o4`000ol0000?0005gooOgol04`000ol0
000@0003gooO00?O4@000ol0000@00;O00?ogml04P000ol0000400001P000ol0000A00;o4`02oa80
00?Oool00]lB0003o`00010000?ogol00]lB0003o`00010000Gogmoog`0B0003o`00010000?Ooml0
0mlA0003o`0001400]l00ooOg`0A0003o`0000@000060003o`0001<000?o00004002oa<00]l00ooO
g`0A0003o`00010000?ogol00mlA0003o`00010000Cogmoo0]lA0003o`0000l00]l00ooOg`03ga00
00?o000040001?l0gol3ga0000?o0000100000H000?o00004003oa<00_lB00?o1=l@0003o`000140
0_l4ga0000?o00004@02o`CO40000ol0000>00;O0_l6g`l000?o00004@02o`GO3`000ol000040000
1P000ol0000V00;o5@05g`l000?o00004`05g`l000?o00004`05g`l000?o00003@05g`801Ml>0003
o`0001@01Ml>0003o`0000@000060003o`0002H00_lF00GO3P000ol0000D00GO3P000ol0000D00GO
3P000ol0000<00GO1005g`d000?o00005@05g`d000?o0000100000H000?o00009P02oaL01Ml=0003
o`0001D01Ml=0003o`0001D01Ml=0003o`0000/01Ml600GO30000ol0000F00GO30000ol000040000
1P000ol0000V00;o6005g``000?o00005P05g``000?o00005P05g``000?o00002P05g`P01Ml;0003
o`0001L01Ml;0003o`0000@000060003o`0002H00_lI00GO2`000ol0000G00GO2`000ol0000G00GO
2`000ol0000900GO2P05g`X000?o00006005g`X000?o0000100000H000?o00009P02oaX01Ml:0003
o`0001P01Ml:0003o`0001P01Ml:0003o`0000P01Ml<00GO2@000ol0000I00GO2@000ol000040000
1P000ol0000V00;o6`05g`T000?o00006@05g`T000?o00006@05g`T000?o00001`05g`h01Ml80003
o`0001X01Ml80003o`0000@000060003o`0002H00_lL00GO20000ol0000J00GO20000ol0000J00GO
20000ol0000600GO4005g`L000?o00006`05g`L000?o0000100000H000?o00009P02oad01Ml70003
o`0001/01Ml70003o`0001/01Ml70003o`0000D01MlB00GO1P000ol0000L00GO1P000ol000040000
1P000ol0000V00;o7P05g`H000?o00007005g`H000?o00007005g`H000?o00001005ga@01Ml50003
o`0001d01Ml50003o`0000@000060003o`0002H00_lO00GO1@000ol0000M00GO1@000ol0000M00GO
1@000ol0000300GO5P05g`@000?o00007P05g`@000?o0000100000H000?o00009P02ob001Ml40003
o`0001h01Ml40003o`0001h01Ml40003o`0000801MlH00GO0`000ol0000O00GO0`000ol000040000
1P000ol0000V00;o8@05g`<000?o00007`05g`<000?o00007`05g`<000Co00001MlJ00GO0P000ol0
000P00GO0P000ol0000400001P000ol0000V00;o8P05g`8000?o00008005g`8000?o00008005g`80
00?o00001MlL00GO00<0o`008P05g`030?l000D000060003o`0002H00_lS00GO00<0o`008P05g`03
0?l002801Ml00`3o0005gah01Ml00ol0000R00GO00?o0000100000H000?o00009P02ob@01Ml00ol0
000R00GO00?o00008P05g`03omoO00?O8004g`03o`0002<01=l00ol0000400001P000ol0000V00;o
00?O00008P04g`03o`0002<01=l00ol0000S00CO00?ogml00]lR00?O00?og`009003g`03oml000@0
00060?go00?O00000`0000H000?o00009P02o`;O9@02g`03omoO02D00]l00ooOg`0U00;O00?ogml0
9P000moog`02gbD000?Ooml01@0000H000?o00009P02o`?O9@000moog`02gbD000?Ooml00]lS00?O
00CogmoO9P000ooOg`02gbD000?o0000100000H000?o00009P02o`CO9@000ooOg`02gbD000?ogml0
0]lQ00CO00?ogml00]lU0003omoO00?O90000ol0000400001P000ol0000V00;o1MlT0003omoO00?O
90000ooOg`03gal01Ml00ooOg`03gb@000?o0=l01=lS0003o`0000@000060003o`0002H00_l00`3O
g`03gb<000?o0=l01=lS0003o`3O00CO7@05g`030?l000GO8`000ol00005gb8000?o0000100000H0
00?o00009P02o`801MlR0003o`0000GO8P000ol00005ga/01Ml20003o`0000GO8P001?l00005gb40
00?o0000100000H000?o00009P02o`<01MlQ0004o`0000GO8@001?l00005gaT01Ml30004o`0000GO
8@000ol0000200GO80000ol0000400001P000ol0000V00;o1005gb0000?o00000P05gb0000?o0000
0P05gaL01Ml40003o`0000801MlP0003o`0000<01MlO0003o`0000@000060003o`0002H00_l500GO
7`000ol0000300GO7`000ol0000300GO5@05g`D000?o00000`05gal000?o00001005gah000?o0000
100000H000?o00009P02o`H01MlN0003o`0000@01MlN0003o`0000@01MlC00GO1P000ol0000400GO
7P000ol0000500GO7@000ol0000400001P000ol0000V00;o1`05gad000?o00001@05gad000?o0000
1@05ga401Ml70003o`0000D01MlM0003o`0000H01MlL0003o`0000@000060003o`0002H00_l800GO
70000ol0000600GO70000ol0000600GO3`05g`P000?o00001P05ga`000?o00001`05ga/000?o0000
100000H000?o00009P02o`T01MlK0003o`0000L01MlK0003o`0000L01Ml=00GO2@000ol0000700GO
6`000ol0000800GO6P000ol0000400001P000ol0000V00;o2P05gaX000?o00002005gaX000?o0000
2005g`/01Ml:0003o`0000P01MlJ0003o`0000T01MlI0003o`0000@000060003o`0002H00_l;00GO
6@000ol0000900GO6@000ol0000900GO2@05g`/000?o00002@05gaT000?o00002P05gaP000?o0000
100000H000?o00009P02o``01MlH0003o`0000X01MlH0003o`0000X01Ml700GO30000ol0000:00GO
60000ol0000;00GO5`000ol0000400001P000ol0000V00;o3@05gaL000?o00002`05gaL000?o0000
2`05g`D01Ml=0003o`0000/01MlG0003o`0000`01MlF0003o`0000@000060003o`0002H00_l>00GO
5P000ol0000<00GO5P000ol0000<00GO0`05g`h000?o00003005gaH000?o00003@05gaD000?o0000
100000H000?o00004004oa800_l?00?O1?lC0003o`0000d00ml3oa@000?o00003@04g`?o1=l?0003
o`0000d01=l2oa@000?o00003P02g`?o50000ol0000400001P000ol0000A0003o`0001800_l@00?O
00?og`004`000ol0000>00GO00?o00004@000ol0000>00CO00?ogml00]l@0003o`0000h00]l01?oO
golC0003o`0000l00]l00ooOg`0C0003o`0000@000060003o`00018000?o00004@02oa400ml00ooO
000B0003o`0000l01=l00ol0000A0003o`0000l000?Oool00_l2ga4000?o00003`001Moogmoo01<0
00?o000040000moog`02ga8000?o0000100000H000?o00004`000ol0000@00;o4P03g`03oml00140
00?o000040000mooo`02ga8000?o000040000ooOo`02ga8000?o000040001OoOgooO018000?o0000
4@000ooOg`02ga4000?o0000100000H000?o000040001?l00?lB00;o4P001?oOgol2ga4000?o0000
4@02g`03omoO014000?o00003`001=oogol3ga4000?o000040001?oOgol2ga4000?o00004@000ooO
g`03ga0000?o0000100000H000?o00004@02oa<00_lC00;o1=l@0003o`0001000ol4ga0000?o0000
3P03g`;o1=l@0003o`0001400_l4ga0000?o00004002o`030=oO00?O3`000ol0000400001P000ol0
000V00;o5@05g`l000?o00004`05g`l000?o00003@05g`030=oO00?O3`000ol0000C00GO3`000ol0
000D00GO3P000ol0000400001P000ol0000V00;o5P05g`h000?o00005005g`h000?o00003005g`<0
1Ml>0003o`0001@01Ml>0003o`0001D01Ml=0003o`0000@000060003o`0002H00_lG00GO3@000ol0
000E00GO3@000ol0000;00GO1@05g`d000?o00005@05g`d000?o00005P05g``000?o0000100000H0
00?o00009P02oaP01Ml<0003o`0001H01Ml<0003o`0000X01Ml700GO30000ol0000F00GO30000ol0
000G00GO2`000ol0000400001P000ol0000V00;o6@05g`/000?o00005`05g`/000?o00002@05g`T0
1Ml;0003o`0001L01Ml;0003o`0001P01Ml:0003o`0000@000060003o`0002H00_lJ00GO2P000ol0
000H00GO2P000ol0000800GO2`05g`X000?o00006005g`X000?o00006@05g`T000?o0000100000H0
00?o00009P02oa/01Ml90003o`0001T01Ml90003o`0000L01Ml=00GO2@000ol0000I00GO2@000ol0
000J00GO20000ol0000400001P000ol0000V00;o7005g`P000?o00006P05g`P000?o00001P05g`l0
1Ml80003o`0001X01Ml80003o`0001/01Ml70003o`0000@000060003o`0002H00_lM00GO1`000ol0
000K00GO1`000ol0000500GO4@05g`L000?o00006`05g`L000?o00007005g`H000?o0000100000H0
00?o00009P02oah01Ml60003o`0001`01Ml60003o`0000@01MlC00GO1P000ol0000L00GO1P000ol0
000M00GO1@000ol0000400001P000ol0000V00;o7`05g`D000?o00007@05g`D000?o00000`05gaD0
1Ml50003o`0001d01Ml50003o`0001h01Ml40003o`0000@000060003o`0002H00_lP00GO10000ol0
000N00GO10000ol0000200GO5`05g`@000?o00007P05g`@000?o00007`05g`<000?o0000100000H0
00?o00009P02ob401Ml30003o`0001l01Ml30004o`0000GO6@05g`<000?o00007`05g`<000?o0000
8005g`8000?o0000100000H000?o00009P02ob801Ml20003o`0002001Ml20003o`0000GO6`05g`80
00?o00008005g`8000?o00008@05g`030?l000D000060003o`0002H00_lS00GO00<0o`008P05g`03
0?l000GO7@05g`030?l002801Ml00`3o000S00GO00?o0000100000H000?o00009P02ob@01Ml00ol0
000R00GO00?ogml00mlO00GO00?o00008P05g`03o`0002<01=l00ol0000400001P000ol0000V00;o
00?O00008P04g`03o`0002<01=l00ooOg`02gb401=l00ol0000S00CO00?o00009003g`03oml000@0
00060?go00?O00000`0000H000?o00009P02o`;O9@02g`03omoO02D00]l00ooOg`0U00;O00?ogml0
9@02g`03omoO02H000?Ooml01@0000H000?o00009P02o`?O9@000moog`02gb<00ml01?oOgmlU0003
gooO00;O9@000moog`02gbH000?o0000100000H000?o00009P02o`CO9@000ooOg`02gb401=l00ooO
g`02gbD000?ogml00]lU0003omoO00;O9@000ol0000400001P000ol0000V00;o1MlT0003omoO00?O
7`05g`03omoO00?O90000ooOg`03gb@000?ogml00mlT0003o`0000@000060003o`0002H00_l00`3O
g`03gb<000?o0=l01=lM00GO00<0o`001MlS0003o`3O00CO8`000ol0g`04gb<000?o0000100000H0
00?o00009P02o`801MlR0003o`0000GO6`05g`8000?o00001MlR0003o`0000GO8P000ol00005gb80
00?o0000100000H000?o00009P02o`<01MlQ0004o`0000GO6@05g`<000Co00001MlQ0004o`0000GO
8@001?l00005gb4000?o0000100000H000?o00009P02o`@01MlP0003o`0000801MlG00GO10000ol0
000200GO80000ol0000200GO80000ol0000200GO80000ol0000400001P000ol0000V00;o1@05gal0
00?o00000`05gaD01Ml50003o`0000<01MlO0003o`0000<01MlO0003o`0000<01MlO0003o`0000@0
00060003o`0002H00_l600GO7P000ol0000400GO4`05g`H000?o00001005gah000?o00001005gah0
00?o00001005gah000?o0000100000H000?o00009P02o`L01MlM0003o`0000D01MlA00GO1`000ol0
000500GO7@000ol0000500GO7@000ol0000500GO7@000ol0000400001P000ol0000V00;o2005ga`0
00?o00001P05g`l01Ml80003o`0000H01MlL0003o`0000H01MlL0003o`0000H01MlL0003o`0000@0
00060003o`0002H00_l900GO6`000ol0000700GO3@05g`T000?o00001`05ga/000?o00001`05ga/0
00?o00001`05ga/000?o0000100000H000?o00009P02o`X01MlJ0003o`0000P01Ml;00GO2P000ol0
000800GO6P000ol0000800GO6P000ol0000800GO6P000ol0000400001P000ol0000V00;o2`05gaT0
00?o00002@05g`T01Ml;0003o`0000T01MlI0003o`0000T01MlI0003o`0000T01MlI0003o`0000@0
00060003o`0002H00_l<00GO60000ol0000:00GO1`05g``000?o00002P05gaP000?o00002P05gaP0
00?o00002P05gaP000?o0000100000H000?o00009P02o`d01MlG0003o`0000/01Ml500GO3@000ol0
000;00GO5`000ol0000;00GO5`000ol0000;00GO5`000ol0000400001P000ol0000V00;o3P05gaH0
00?o00003005g`<01Ml>0003o`0000`01MlF0003o`0000`01MlF0003o`0000`01MlF0003o`0000@0
00060003o`0002H00_l?00GO5@000ol0000=00GO00<0gml00ml?0003o`0000d01MlE0003o`0000d0
1MlE0003o`0000d01MlE0003o`0000@000060003o`0001000olC00;o4002g`?o50000ol0000>00;O
1?l3ga0000?o00003P02g`?o50000ol0000>00?O0olC0003o`0000h00ml2oa@000?o0000100000H0
00?o00004@000ol0000B00;o4@02g`03omoO01<000?o00003`02g`03omoO00;O4@000ol0000?00CO
00?o00004@000ol0000?00?O00?og`004P000ol0000?0005gooOgol04`000ol0000400001P000ol0
000A0003o`0001800_lB0003gooO00;O4P000ol0000@00;O00?ogml04P000ol0000@00?O00?og`00
4@000ol0000@00Co00?O000040000ol0000@0005omoOoml04P000ol0000400001P000ol0000A0003
o`0001800_lC0003omoO00;O4@000ol0000?00CO00?ogml04@000ol0000A00;o0mlA0003o`000100
00?ogol00mlA0003o`00010000Cogmoo0]lA0003o`0000@000060003o`00014000?o00004P02oa<0
00?ogml00ml@0003o`0000h00]l01?oOgol3ga0000?o00004P000moog`02ga0000?o000040000ol0
o`04ga0000?o000040001?l0gol3ga0000?o0000100000H000?o00004002oa@00_lB00;o00<0gml0
0ml?0003o`0000d01=l2o`GO3`000ol0000@00?o1Ml?0003o`0001400_l5g`l000?o00004@02o`GO
3`000ol0000400001P000ol0000V00;o5P05g`h000?o00003005g`<01Ml>0003o`0001@01Ml>0003
o`0001@01Ml>0003o`0001@01Ml>0003o`0000@000060003o`0002H00_lG00GO3@000ol0000;00GO
1@05g`d000?o00005@05g`d000?o00005@05g`d000?o00005@05g`d000?o0000100000H000?o0000
9P02oaP01Ml<0003o`0000X01Ml700GO30000ol0000F00GO30000ol0000F00GO30000ol0000F00GO
30000ol0000400001P000ol0000V00;o6@05g`/000?o00002@05g`T01Ml;0003o`0001L01Ml;0003
o`0001L01Ml;0003o`0001L01Ml;0003o`0000@000060003o`0002H00_lJ00GO2P000ol0000800GO
2`05g`X000?o00006005g`X000?o00006005g`X000?o00006005g`X000?o0000100000H000?o0000
9P02oa/01Ml90003o`0000L01Ml=00GO2@000ol0000I00GO2@000ol0000I00GO2@000ol0000I00GO
2@000ol0000400001P000ol0000V00;o7005g`P000?o00001P05g`l01Ml80003o`0001X01Ml80003
o`0001X01Ml80003o`0001X01Ml80003o`0000@000060003o`0002H00_lM00GO1`000ol0000500GO
4@05g`L000?o00006`05g`L000?o00006`05g`L000?o00006`05g`L000?o0000100000H000?o0000
9P02oah01Ml60003o`0000@01MlC00GO1P000ol0000L00GO1P000ol0000L00GO1P000ol0000L00GO
1P000ol0000400001P000ol0000V00;o7`05g`D000?o00000`05gaD01Ml50003o`0001d01Ml50003
o`0001d01Ml50003o`0001d01Ml50003o`0000@000060003o`0002H00_lP00GO10000ol0000200GO
5`05g`@000?o00007P05g`@000?o00007P05g`@000?o00007P05g`@000?o0000100000H000?o0000
9P02ob401Ml30004o`0000GO6@05g`<000?o00007`05g`<000?o00007`05g`<000?o00007`05g`<0
00?o0000100000H000?o00009P02ob801Ml20003o`0000GO6`05g`8000?o00008005g`8000?o0000
8005g`8000?o00008005g`8000?o0000100000H000?o00009P02ob<01Ml00`3o0005gad01Ml00`3o
000R00GO00<0o`008P05g`030?l002801Ml00`3o000500001P000ol0000V00;o9005g`03omoO00?O
7`05g`03o`0002801Ml00ol0000R00GO00?o00008P05g`03o`0000@000060003o`0002H00_lU00CO
00?ogml00]lQ00CO00?o00008`04g`03o`0002<01=l00ol0000S00CO00?o0000100000H000?o0000
9P02obH00ml01?oOgmlS00?O00?og`009003g`03oml002@00ml00ooO000T00?O00?og`00100000H0
oOl00ml0000300001P000ol0000V00;o9P03g`04omoOgbD000?Ooml00]lU0003gooO00;O9@000moo
g`02gbD000?Ooml01@0000H000?o00009P02obD01=l00ooOg`02gbD000?ogml00]lU0003omoO00;O
9@000ooOg`02gbD000?o0000100000H000?o00009P02ob@01Ml00ooOg`03gb@000?ogml00mlT0003
omoO00?O90000ooOg`03gb@000?o0000100000H000?o00009P02ob<01Ml00`3o0005gb<000?o0=l0
1=lS0003o`3O00CO8`000ol0g`04gb<000?o0000100000H000?o00009P02ob801Ml20003o`0000GO
8P000ol00005gb8000?o00001MlR0003o`0000GO8P000ol0000400001P000ol0000V00;o8@05g`<0
00Co00001MlQ0004o`0000GO8@001?l00005gb4000Co00001MlQ0003o`0000@000060003o`0002H0
0_lP00GO10000ol0000200GO80000ol0000200GO80000ol0000200GO80000ol0000200GO80000ol0
000400001P000ol0000V00;o7`05g`D000?o00000`05gal000?o00000`05gal000?o00000`05gal0
00?o00000`05gal000?o0000100000H000?o00009P02oah01Ml60003o`0000@01MlN0003o`0000@0
1MlN0003o`0000@01MlN0003o`0000@01MlN0003o`0000@000060003o`0002H00_lM00GO1`000ol0
000500GO7@000ol0000500GO7@000ol0000500GO7@000ol0000500GO7@000ol0000400001P000ol0
000V00;o7005g`P000?o00001P05ga`000?o00001P05ga`000?o00001P05ga`000?o00001P05ga`0
00?o0000100000H000?o00009P02oa/01Ml90003o`0000L01MlK0003o`0000L01MlK0003o`0000L0
1MlK0003o`0000L01MlK0003o`0000@000060003o`0002H00_lJ00GO2P000ol0000800GO6P000ol0
000800GO6P000ol0000800GO6P000ol0000800GO6P000ol0000400001P000ol0000V00;o6@05g`/0
00?o00002@05gaT000?o00002@05gaT000?o00002@05gaT000?o00002@05gaT000?o0000100000H0
00?o00009P02oaP01Ml<0003o`0000X01MlH0003o`0000X01MlH0003o`0000X01MlH0003o`0000X0
1MlH0003o`0000@000060003o`0002H00_lG00GO3@000ol0000;00GO5`000ol0000;00GO5`000ol0
000;00GO5`000ol0000;00GO5`000ol0000400001P000ol0000V00;o5P05g`h000?o00003005gaH0
00?o00003005gaH000?o00003005gaH000?o00003005gaH000?o0000100000H000?o00009P02oaD0
1Ml?0003o`0000d01MlE0003o`0000d01MlE0003o`0000d01MlE0003o`0000d01MlE0003o`0000@0
00060003o`0001400_lC00;o4`02o`CO40000ol0000>00;O0olD0003o`0000h00]l4oa<000?o0000
3P02g`?o50000ol0000>00?O0olC0003o`0000@000060003o`00010000Co003o4P02oa8000Cogmoo
0]lA0003o`0000l00]l00ooOg`0C0003o`0000l00]l00ooOg`0C0003o`0000l01=l00ol0000A0003
o`0000l00ml00ooO000B0003o`0000@000060003o`00010000Co003o4P02oa8000Gogmoog`0B0003
o`00010000?Ooml00]lB0003o`0001000]l00ooOg`0B0003o`0001000ml00ooO000A0003o`000100
1?l00ml0000@0003o`0000@000060003o`00010000Co003o4P02oa4000GOomoOo`0C0003o`000140
00?ogml00]lA0003o`0001400]l00ooOg`0A0003o`0001400_l3ga4000?o000040000ooOo`03ga40
00?o0000100000H000?o000040001?l00?lB00;o4002g`04omoOoa<000?o00004@000ooOg`03ga00
00?o000040001?l0gol3ga0000?o00004P000moog`02ga0000?o000040000ol0o`04ga0000?o0000
100000H000?o00004@02oa<00_l?00CO0_lD0003o`0001000_l00`3Og`03g`l000?o00004@02o`GO
3`000ol0000@00?o1Ml?0003o`0001400_l5g`l000?o0000100000H000?o00009P02o`h01MlF0003
o`0001@01Ml>0003o`0001@01Ml>0003o`0001@01Ml>0003o`0001@01Ml>0003o`0000@000060003
o`0002H00_l=00GO5`000ol0000E00GO3@000ol0000E00GO3@000ol0000E00GO3@000ol0000E00GO
3@000ol0000400001P000ol0000V00;o3005gaP000?o00005P05g``000?o00005P05g``000?o0000
5P05g``000?o00005P05g``000?o0000100000H000?o00009P02o`/01MlI0003o`0001L01Ml;0003
o`0001L01Ml;0003o`0001L01Ml;0003o`0001L01Ml;0003o`0000@000060003o`0002H00_l:00GO
6P000ol0000H00GO2P000ol0000H00GO2P000ol0000H00GO2P000ol0000H00GO2P000ol000040000
1P000ol0000V00;o2@05ga/000?o00006@05g`T000?o00006@05g`T000?o00006@05g`T000?o0000
6@05g`T000?o0000100000H000?o00009P02o`P01MlL0003o`0001X01Ml80003o`0001X01Ml80003
o`0001X01Ml80003o`0001X01Ml80003o`0000@000060003o`0002H00_l700GO7@000ol0000K00GO
1`000ol0000K00GO1`000ol0000K00GO1`000ol0000K00GO1`000ol0000400001P000ol0000V00;o
1P05gah000?o00007005g`H000?o00007005g`H000?o00007005g`H000?o00007005g`H000?o0000
100000H000?o00009P02o`D01MlO0003o`0001d01Ml50003o`0001d01Ml50003o`0001d01Ml50003
o`0001d01Ml50003o`0000@000060003o`0002H00_l400GO80000ol0000N00GO10000ol0000N00GO
10000ol0000N00GO10000ol0000N00GO10000ol0000400001P000ol0000V00;o0`05gb4000?o0000
7`05g`<000?o00007`05g`<000?o00007`05g`<000?o00007`05g`<000?o0000100000H000?o0000
9P02o`801MlR0003o`0002001Ml20003o`0002001Ml20003o`0002001Ml20003o`0002001Ml20003
o`0000@000060003o`0002H00_l00`3Og`03gb<000?o00008@05g`030?l002801Ml00`3o000R00GO
00<0o`008P05g`030?l000D000060003o`0002H00_l5gb@000?o00008P05g`03o`0002801Ml00ol0
000R00GO00?o00008P05g`03o`0000@000060003o`0002H00_l4gbD000?o00008`04g`03o`0002<0
1=l00ol0000S00CO00?o00008`04g`03o`0000@000060003o`0002H00_l3gbH000?o00009003g`03
oml002@00ml00ooO000T00?O00?og`009003g`03oml000@000050?ko00?O00000`0000D0o_l00ml0
000300001P000ol0000U00?o:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@0
00060003o`0002@000Co0?oo:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@0
00060003o`0002<000?o00000_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000
100000H000?o00008P001?l00002obT000?o00009`000ol0000W0003o`0002L000?o00009`000ol0
000400001P000ol0000Q0003o`0000800_lY0003o`0002L000?o00009`000ol0000W0003o`0002L0
00?o0000100000H000?o000080000ol0000300;o:@000ol0000W0003o`0002L000?o00009`000ol0
000W0003o`0000@000060003o`0001l000?o00001002obT000?o00009`000ol0000W0003o`0002L0
00?o00009`000ol0000400001P000ol0000N0003o`0000D00_lY0003o`0002L000?o00009`000ol0
000W0003o`0002L000?o0000100000H000?o00007@000ol0000600;o:@000ol0000W0003o`0002L0
00?o00009`000ol0000W0003o`0000@000060003o`0000P00_l00`3oo`0?0003o`0000L00_lY0003
o`0002L000?o00009`000ol0000W0003o`0002L000?o0000100000H000?o00002@000ol0o`0?0003
o`0000P00_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000100000H000?o0000
2P000ol0000=0003o`0000T00_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000
100000H000?o00002@000ol0o`0=0003o`0000X00_lY0003o`0002L000?o00009`000ol0000W0003
o`0002L000?o0000100000H000?o00002002o`030?oo00/000?o00002`02obT000?o00009`000ol0
000W0003o`0002L000?o00009`000ol0000400001P000ol0000G0003o`0000`00_lY0003o`0002L0
00?o00009`000ol0000W0003o`0002L000?o0000100000H000?o00005P000ol0000=00;o:@000ol0
000W0003o`0002L000?o00009`000ol0000W0003o`0000@000060003o`0001D000?o00003P02obT0
00?o00009`000ol0000W0003o`0002L000?o00009`000ol0000400001P000ol0000D0003o`0000l0
0_lC00;o50000ol0000@00?o50000ol0000@00Co4`000ol0000@00?o50000ol0000A00?o4`000ol0
000400001P000ol0000C0003o`0001000_lB0004o`00oa<000?o00004@000ol0000C0003o`000140
00?o00004`000ol0000C0003o`00014000?o00004P000ol0000B0003o`0000@000060003o`000180
00?o00004@02oa8000Co003o4`000ol0000A0003o`0001<000?o00004P000ol0000B0003o`0001<0
00?o00004@000ol0000@00Co4`000ol0000400001P000ol0000A0003o`0001800_lB0004o`00oa<0
00?o00004@000ol0000C0003o`0001<000?o00004@000ol0000A00;o50000ol0000@0003o`3o01@0
00?o0000100000H000?o000040000ol0000C00;o4P001?l00?lC0003o`00014000?o00004`000ol0
000@0004o`00oa<000?o00004`000ol0000A0003o`00010000?o0?l050000ol0000400001P000ol0
000?0003o`0001@00_lC00;o50000ol0000@00;o5@000ol0000A00;o50000ol0000@00?o50000ol0
000A00;o50000ol0000400001P000ol0000>0003o`0000P00ol:00;o:@000ol0000W0003o`0002L0
00?o00009`000ol0000W0003o`0000@000060003o`0000d000?o00002P000ol0000900;o:@000ol0
000W0003o`0002L000?o00009`000ol0000W0003o`0000@000060003o`0000`000?o000030000ol0
000800;o:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@000060003o`0000/0
00?o00003@000ol0000800;o:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@0
00060003o`0000X000?o00003@000ol0o`0900;o:@000ol0000W0003o`0002L000?o00009`000ol0
000W0003o`0000@000060003o`0000T000?o00003P000ol0o`0900;o:@000ol0000W0003o`0002L0
00?o00009`000ol0000W0003o`0000@000060003o`0000P000?o00003P02o`030?oo00P00_lY0003
o`0002L000?o00009`000ol0000W0003o`0002L000?o0000100000H000?o00001`000ol0000L00;o
:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@000060003o`0000H000?o0000
7@02obT000?o00009`000ol0000W0003o`0002L000?o00009`000ol0000400001P000ol000050003
o`0001h00_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000100000H000?o0000
10000ol0000O00;o:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@000060003
o`0000<000?o00008002obT000?o00009`000ol0000W0003o`0002L000?o00009`000ol000040000
1P000ol000020003o`0002400_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000
100000H000Go0000o`0T00;o:@000ol0000W0003o`0002L000?o00009`000ol0000W0003o`0000@0
00060004o`00obD00_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000100000H0
00?o0?l09P02obT000?o00009`000ol0000W0003o`0002L000?o00009`000ol0000400001P02obL0
0_lY0003o`0002L000?o00009`000ol0000W0003o`0002L000?o0000100000H0oOl60000;`02omP0
003o00X0003o00X0003o00X0003o00X0003o00X0003o00X0003o00X0003o00X0003o00X0003o00X0
003o00X0003o00X0003o00X0003o00X0003o00X0000K0003o`0000P00_l:00;o10000ol0002o00?o
300001X000?o00002@000ol0000:0003o`0000<000?o0000_`000ol0000;00001P02o`030?oo00<0
1Ol00`3oo`03o`030?l000<01?l30003o`0000800ol50003o`0000<000?o0000YP02o`030?oo00X0
00?o000020000ol0000:00001`000ol0o`030007o`000?l0o`030004o`00o`D000?o0?l00`000ol0
00050003o`00008000?o00000`000ol0002W0003o`3o00/000?o000020000ol0000:00001`03o`<0
00Oo0000o`3o00<000Co003o1@000ol000030003o`0000D000?o00000P000ol000030003o`000:P0
00?o00002005o`L000?o0?l02`0000L000?o0?l00`001ol0003o0?l00`001?l00?l60003o`000080
00?o00000P03o`D000?o00000`000ol0002W0003o`3o00/000?o00001`000ol0o`0;000020000ol0
000300Co0P04o`8000?o00000P000ol0o`040003o`00008000?o00001@000ol000030003o`000:H0
0_l00`3oo`0:0003o`0000H00_l00`3oo`0:00001`02o`P000?o00000`001Ol0003o00<01?l300;o
0`04o`<00_l40003o`000<h0000@00;o1002oo40003o00X0003o00X00000\
\>"],
  ImageRangeCache->{{{0, 264.812}, {287, 0}} -> {-1.15003, -0.16397, 
  0.0237907, 0.0237907}},
  CellTags->"AdditiveP"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Zero",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  "Text",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["zero",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["one",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["exists",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["HasNegativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["r",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["has",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["negative",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["NegationOf",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["additive",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["inverse",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["r",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["it",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["exists",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["otherwise",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["RandomAssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] \ Addition\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  "Text",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ addition\ on\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["appears",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["be",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["associative",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["based",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["on",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["testing",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["25",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["random",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["triples",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], "\n", 
                      StyleBox["from",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox["R",
                          "TraditionalForm"],
                        "Text"]}], 
                    StyleBox[")",
                      SingleLetterItalics->False]}]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["InvertibleQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["r",
                  FontSlant->"Italic"], ",", " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Operation",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", 
                      StyleBox["Addition",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["HasNegativeQ",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["R",
                    "TI"], 
                  StyleBox[",",
                    "TI"], " ", 
                  StyleBox["r",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["Inverses",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Operation",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", 
                      StyleBox["Addition",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
              "return", " ", "a", " ", "list", " ", "of", " ", "pairs", " ", 
                "of", " ", "the", " ", "form", " ", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["x",
                      FontSlant->"Italic"], ",", " ", 
                    StyleBox[\(-x\),
                      FontSlant->"Italic"]}], "}"}]}], ",", " ", 
              RowBox[{"or", " ", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["x",
                      FontSlant->"Italic"], ",", " ", \(no\ inverse\)}], 
                  "}"}], " ", "if", " ", 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "has", " ", "no", " ", 
                "negation"}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->{"AdditiveP", "i:17"}],

Cell["\<\
Related functions for testing the additive properties of a \
ring.\
\>", "Caption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverses[FormRingoid[{2, 3, \(-2\), 0}, Plus, Times], \ 
      Operation\  \[Rule] \ Addition]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \({{2, \(-2\)}, {0, 0}, {3, "no inverse"}}\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[TextData[{
  "Here is why 0 is the zero of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  "."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Zero[Z[5], Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"AdditiveP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .55556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0132275 0.47619 [
[ 0 0 0 0 ]
[ 1 .55556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .55556 L
0 .55556 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0132275 0.477324 0.542328 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.107143 0.15873 [
[ 0 0 0 0 ]
[ 1 1.16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.16667 L
0 1.16667 L
closepath
clip
newpath
1 1 0 r
.18254 .74206 m
.18254 .90079 L
.34127 .90079 L
.34127 .74206 L
F
.34127 .74206 m
.34127 .90079 L
.5 .90079 L
.5 .74206 L
F
.5 .74206 m
.5 .90079 L
.65873 .90079 L
.65873 .74206 L
F
.65873 .74206 m
.65873 .90079 L
.81746 .90079 L
.81746 .74206 L
F
.81746 .74206 m
.81746 .90079 L
.97619 .90079 L
.97619 .74206 L
F
.18254 .90079 m
.18254 1.05952 L
.97619 1.05952 L
.97619 .90079 L
F
0 g
[(red->left identity)] .03968 .02778 -1 0 Mshowa
1 0 0 r
.02381 .74206 m
.02381 .90079 L
.18254 .90079 L
.18254 .74206 L
F
1 1 0 r
.18254 .74206 m
.18254 .90079 L
.34127 .90079 L
.34127 .74206 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .10714 m
.02381 1.05952 L
s
.02381 .10714 m
.97619 .10714 L
s
.02381 .26587 m
.97619 .26587 L
s
.02381 .4246 m
.97619 .4246 L
s
.02381 .58333 m
.97619 .58333 L
s
.02381 .74206 m
.97619 .74206 L
s
.02381 .90079 m
.97619 .90079 L
s
.02381 1.05952 m
.97619 1.05952 L
s
.18254 .10714 m
.18254 1.05952 L
s
.34127 .10714 m
.34127 1.05952 L
s
.5 .10714 m
.5 1.05952 L
s
.65873 .10714 m
.65873 1.05952 L
s
.81746 .10714 m
.81746 1.05952 L
s
.97619 .10714 m
.97619 1.05952 L
s
.02381 1.05952 m
.18254 .90079 L
s
2.6 Mabswid
.18254 .10714 m
.18254 1.05952 L
s
.02381 .90079 m
.97619 .90079 L
s
[(0)] .2619 .82143 0 0 Mshowa
[(1)] .42063 .82143 0 0 Mshowa
[(2)] .57937 .82143 0 0 Mshowa
[(3)] .7381 .82143 0 0 Mshowa
[(4)] .89683 .82143 0 0 Mshowa
[(1)] .2619 .6627 0 0 Mshowa
[(2)] .42063 .6627 0 0 Mshowa
[(3)] .57937 .6627 0 0 Mshowa
[(4)] .7381 .6627 0 0 Mshowa
[(0)] .89683 .6627 0 0 Mshowa
[(2)] .2619 .50397 0 0 Mshowa
[(3)] .42063 .50397 0 0 Mshowa
[(4)] .57937 .50397 0 0 Mshowa
[(0)] .7381 .50397 0 0 Mshowa
[(1)] .89683 .50397 0 0 Mshowa
[(3)] .2619 .34524 0 0 Mshowa
[(4)] .42063 .34524 0 0 Mshowa
[(0)] .57937 .34524 0 0 Mshowa
[(1)] .7381 .34524 0 0 Mshowa
[(2)] .89683 .34524 0 0 Mshowa
[(4)] .2619 .18651 0 0 Mshowa
[(0)] .42063 .18651 0 0 Mshowa
[(1)] .57937 .18651 0 0 Mshowa
[(2)] .7381 .18651 0 0 Mshowa
[(3)] .89683 .18651 0 0 Mshowa
[(0)] .10317 .82143 0 0 Mshowa
[(1)] .10317 .6627 0 0 Mshowa
[(2)] .10317 .50397 0 0 Mshowa
[(3)] .10317 .34524 0 0 Mshowa
[(4)] .10317 .18651 0 0 Mshowa
[(0)] .2619 .98016 0 0 Mshowa
[(1)] .42063 .98016 0 0 Mshowa
[(2)] .57937 .98016 0 0 Mshowa
[(3)] .7381 .98016 0 0 Mshowa
[(4)] .89683 .98016 0 0 Mshowa
[(Add\\(Z[5]\\))] .02381 1.13889 -1 0 Mshowa
gsave
.97619 1.13889 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .95317 0 0 Mshowa
[(y)] .14286 1.0119 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0132275 0.97619 0.542328 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.107143 0.15873 [
[ 0 0 0 0 ]
[ 1 1.16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.16667 L
0 1.16667 L
closepath
clip
newpath
0 1 1 r
.18254 .74206 m
.18254 .90079 L
.34127 .90079 L
.34127 .74206 L
F
.18254 .58333 m
.18254 .74206 L
.34127 .74206 L
.34127 .58333 L
F
.18254 .4246 m
.18254 .58333 L
.34127 .58333 L
.34127 .4246 L
F
.18254 .26587 m
.18254 .4246 L
.34127 .4246 L
.34127 .26587 L
F
.18254 .10714 m
.18254 .26587 L
.34127 .26587 L
.34127 .10714 L
F
0 g
[(red->right identity)] .03968 .02778 -1 0 Mshowa
0 1 1 r
.02381 .10714 m
.02381 .90079 L
.18254 .90079 L
.18254 .10714 L
F
1 0 0 r
.18254 .90079 m
.18254 1.05952 L
.34127 1.05952 L
.34127 .90079 L
F
0 1 1 r
.18254 .74206 m
.18254 .90079 L
.34127 .90079 L
.34127 .74206 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .10714 m
.02381 1.05952 L
s
.02381 .10714 m
.97619 .10714 L
s
.02381 .26587 m
.97619 .26587 L
s
.02381 .4246 m
.97619 .4246 L
s
.02381 .58333 m
.97619 .58333 L
s
.02381 .74206 m
.97619 .74206 L
s
.02381 .90079 m
.97619 .90079 L
s
.02381 1.05952 m
.97619 1.05952 L
s
.18254 .10714 m
.18254 1.05952 L
s
.34127 .10714 m
.34127 1.05952 L
s
.5 .10714 m
.5 1.05952 L
s
.65873 .10714 m
.65873 1.05952 L
s
.81746 .10714 m
.81746 1.05952 L
s
.97619 .10714 m
.97619 1.05952 L
s
.02381 1.05952 m
.18254 .90079 L
s
2.6 Mabswid
.18254 .10714 m
.18254 1.05952 L
s
.02381 .90079 m
.97619 .90079 L
s
[(0)] .2619 .82143 0 0 Mshowa
[(1)] .42063 .82143 0 0 Mshowa
[(2)] .57937 .82143 0 0 Mshowa
[(3)] .7381 .82143 0 0 Mshowa
[(4)] .89683 .82143 0 0 Mshowa
[(1)] .2619 .6627 0 0 Mshowa
[(2)] .42063 .6627 0 0 Mshowa
[(3)] .57937 .6627 0 0 Mshowa
[(4)] .7381 .6627 0 0 Mshowa
[(0)] .89683 .6627 0 0 Mshowa
[(2)] .2619 .50397 0 0 Mshowa
[(3)] .42063 .50397 0 0 Mshowa
[(4)] .57937 .50397 0 0 Mshowa
[(0)] .7381 .50397 0 0 Mshowa
[(1)] .89683 .50397 0 0 Mshowa
[(3)] .2619 .34524 0 0 Mshowa
[(4)] .42063 .34524 0 0 Mshowa
[(0)] .57937 .34524 0 0 Mshowa
[(1)] .7381 .34524 0 0 Mshowa
[(2)] .89683 .34524 0 0 Mshowa
[(4)] .2619 .18651 0 0 Mshowa
[(0)] .42063 .18651 0 0 Mshowa
[(1)] .57937 .18651 0 0 Mshowa
[(2)] .7381 .18651 0 0 Mshowa
[(3)] .89683 .18651 0 0 Mshowa
[(0)] .10317 .82143 0 0 Mshowa
[(1)] .10317 .6627 0 0 Mshowa
[(2)] .10317 .50397 0 0 Mshowa
[(3)] .10317 .34524 0 0 Mshowa
[(4)] .10317 .18651 0 0 Mshowa
[(0)] .2619 .98016 0 0 Mshowa
[(1)] .42063 .98016 0 0 Mshowa
[(2)] .57937 .98016 0 0 Mshowa
[(3)] .7381 .98016 0 0 Mshowa
[(4)] .89683 .98016 0 0 Mshowa
[(Add\\(Z[5]\\))] .02381 1.13889 -1 0 Mshowa
gsave
.97619 1.13889 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .95317 0 0 Mshowa
[(y)] .14286 1.0119 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[35]:=",
  ImageSize->{288, 160},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000X0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000780
0omB00?o?@03oaH0001c0003o`0005@000?o0000>`000ol0000E00003@04o`<01?l200Go3005o`80
1?l00`3oo`02o`<00ol800Go0P05o`030?oo00;o00@0ool00_l200?o0P05o`800ol30003o`0002D0
1?l300Co0P05o``01?l200Go0P04o`040?oo00;o0P03o`P01Ol200Go00<0ool00_l0103oo`02o`80
0ol200Go0P03o`<000?o0000500000h000?o00000P000ol000030005o`000?l01P02o`L000Go0000
o`060003o`0000<000Co003o2@001Ol0003o00<000?o0?l01@001?l00?l30004o`00o`<000?o0000
0P001?l00?l20003o`0002H000?o00000P000ol000030005o`000?l01P02o`H000?o000010001Ol0
003o00<000?o0?l00P001Ol0003o008000?o00001`001Ol0003o00<000?o0?l01@001?l00?l30004
o`00o`<000?o00000P001?l00?l20003o`0001@0000>0003o`0000801Ol00`3o00020003o`3o00Co
0P02o`D000Co00001Ol20003o`0000<000?o00002P001Ol0003o00<000?o0?l01?l01@3o003o00<0
00?o000010000ol000020003o`00008000?o0?l09`000ol0000200Go00<0o`000P000ol0o`04o`80
0_l40003o`0000@000Go0000o`030003o`3o008000Go0000o`0<0005o`000?l00`000ol0o`04o`05
0?l00?l00`000ol000040003o`00008000?o00000P000ol0o`0E00003P02o`<000Oo0000o`3o00<0
00?o000020000ol000020005o`000?l00`001?l00?l50003o`0000X000Go0000o`030003o`3o00<0
00?o0?l00P001Ol0003o00H000?o00000P000ol000020003o`3o02L00_l30007o`000?l0o`030003
o`0000P000Co00000_l50005o`000?l00`000ol0o`020005o`000?l030001Ol0003o00<000?o0?l0
0`000ol0o`020005o`000?l01P000ol000020003o`00008000?o0?l05@0000d00_l00`3oo`0200?o
0`04o`P00_l50003o`0000800ol200Co0P04o`T00_l400Co0P03o`030?oo00?o0P04o`<00_l300Co
00@0ool00_lU00;o00<0ool00P03o`<01?l800;o0`02o`030?oo00800_l400Wo0P04o`T00_l400Co
0P03o`030?oo00?o0P04o`<00_l300Co00@0ool00_lD00007@000ol0000400;o1`000ol000080003
o`0000<000?o00004P000ol0000<0003o`0000T000?o0000>`000ol0000400;o5`000ol000040003
o`00018000?o000030000ol000090003o`0001X0000L00;o3@03o`X00ol30003o`0000X000?o0000
1002o`h000?o000010000ol000020003o`0003X00_lE0003o`0000H00_l60003o`0000X000?o0000
1002o`h000?o000010000ol000020003o`0001X0003o0240003o0240003o0240003o0240003o0240
000:07co4`1lo`/0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0000H00ol700;o2@03o`P0
00?o00001P02o`X000?o00001@03o`T000?o00001P04o`P000?o00001@03o`T000?o00004@000ol1
0@060@?o1`42o`P10ol90@03o`0000H00_l90003o`0000H00ol90003o`0000D01?l90003o`0000D0
0ol90003o`0000T0000:0003o`0000L000?o00001P02o`X000?o00001`000ol000050004o`00o`T0
00?o00001P000ol000080003o`0000L000?o000020000ol000080003o`0000H000?o00004@000ol1
0@070@03o`4100H10_l90@03o`4100P100?o00001@001?l00?l80003o`0000L000?o000020000ol0
00060003o`0000T000?o000020000ol000060003o`0000T0000:0003o`0000D01?l700;o2004o`P0
00?o00001@001?l00?l90003o`0000H000?o000020000ol000080003o`0000L000?o000020000ol0
00060003o`00014000?o0@401@44o`L10_l70@Co2@400ol000050004o`00o`P000?o00001`000ol0
00080003o`0000L000?o000020000ol000080003o`0000H000?o00002@0000X000?o00001@000ol0
o`0800;o20000ol0o`090003o`0000D000Co003o2@000ol000060003o`0000P000?o00002@000ol0
00060003o`0000H00_l90003o`00014000?o0@401@400ol1o`080@;o1`400ol1o`0:0@03o`0000D0
00Co003o20000ol000070003o`0000P000?o000020000ol000070003o`0000H00_l90003o`0000T0
000:0003o`0000D000?o0?l02002o`P000?o0?l02@000ol000050004o`00o`T000?o00001P000ol0
00080003o`0000H000Co003o20000ol000080003o`0000H000?o00004@000ol10@050@03o`7o00P1
0_l70@03o`7o00X100?o00001@001?l00?l80003o`0000L000?o000020000ol000050004o`00o`T0
00?o000020000ol000060003o`0000T0000:0003o`0000H00_l800;o2@02o`T000?o00001P02o`X0
00?o00001@02o`X000?o00001`02o`T000?o00001@03o`T000?o00004@000ol10@060@;o2042o`P1
0_l:0@03o`0000H00_l90003o`0000H00_l:0003o`0000H00_l:0003o`0000D00ol90003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:07co4`1lo`/0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0000D00ol800;o2003o`T0
00?o00001P03o`T000?o00001P02o`T000?o00001P03o`T000?o00001@04o`P000?o00004@000ol1
0@050@?o2042o`L10ol:0@03o`0000H00ol80003o`0000L00_l90003o`0000D00ol:0003o`0000D0
1?l80003o`0000T0000:0003o`0000P000?o00001@02o`/000?o00001P000ol000070003o`0000P0
00?o00001@001?l00?l80003o`0000L000?o000020000ol000060003o`0000P000?o00004@000ol1
0@080@03o`4100D10_l:0@03o`4100L100?o00001`000ol000070003o`0000H000Co003o20000ol0
00060003o`0000T000?o00001P000ol000080003o`0000T0000:0003o`0000P000?o00001@02o`/0
00?o00001P000ol0000500Co2@000ol000050004o`00o`P000?o00001`000ol000080003o`0000L0
00?o00001`000ol0000A0003o`4100P100?o0@401@42o`X100?o0@401`400ol0000500Co20000ol0
00060004o`00o`P000?o00001P000ol000090003o`0000L000?o00001`000ol0000900002P000ol0
000600;o2002o`T00_l90003o`0000D000?o0?l02P000ol000050004o`00o`P000?o00001`000ol0
00080003o`0000P000?o00001P000ol0000A0003o`4100H10_l80@;o2042o`X100?o00001@000ol0
o`090003o`0000H000Co003o20000ol000060003o`0000T000?o000020000ol000060003o`0000T0
000:0003o`0000P000?o00001@02o`/000?o00001P000ol000050003o`3o00X000?o00001@001?l0
0?l80003o`0000L000?o000020000ol000050004o`00o`P000?o00004@000ol10@080@03o`4100D1
0_l:0@03o`4100L100?o00001@000ol0o`090003o`0000H000Co003o20000ol000060003o`0000T0
00?o00001@001?l00?l80003o`0000T0000:0003o`0000D00ol800;o2003o`T000?o00001P02o`X0
00?o00001P02o`T000?o00001P02o`X000?o00001P02o`T000?o00004@000ol10@050@?o2042o`L1
0ol:0@03o`0000H00_l90003o`0000L00_l90003o`0000D00_l;0003o`0000H00_l90003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:07co4`1lo`/0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003o`0000D01?l700;o2004o`P000?o00001@03o`X0
00?o00001P03o`P000?o00001`02o`T000?o00001@03o`T000?o00004@000ol10@050@Co1`42o`L1
1?l90@03o`0000D00ol90003o`0000L00ol80003o`0000H00_l:0003o`0000D00ol90003o`0000T0
000:0003o`0000H000?o00001`02o`T000?o000020000ol000080003o`0000L000?o00001`000ol0
00070003o`0000H000Co003o20000ol000060003o`0000P000?o00004@000ol10@060@03o`4100L1
0_l80@03o`4100T100?o000020000ol000060003o`0000P000?o00001`000ol000050004o`00o`T0
00?o00001P000ol000080003o`0000T0000:0003o`0000L000?o00001P02o`X000?o00001`000ol0
00080003o`0000L000?o00001@04o`P000?o00001P001?l00?l80003o`0000H000?o000020000ol0
000A0003o`4100L100?o0@401P42o`T100?o0@4020400ol000080003o`0000H000?o00001P04o`P0
00?o00001@001?l00?l90003o`0000H000?o000020000ol0000900002P000ol000080003o`0000D0
0_l;0003o`0000H000?o00001P02o`X000?o00001@000ol0o`090003o`0000H000Co003o20000ol0
00060003o`0000P000?o00004@000ol10@080@03o`4100D10_l:0@03o`4100L100?o00001P02o`T0
00?o00001P000ol0o`090003o`0000D000Co003o2@000ol000060003o`0000P000?o00002@0000X0
00?o00001@001?l00?l700;o20001?l00?l80003o`0000P000?o00001`000ol000050003o`3o00T0
00?o00001P001?l00?l80003o`0000H000?o000020000ol0000A0003o`4100D100Co0@7o1`42o`L1
00Co0@7o2@400ol000080003o`0000H000?o00001P000ol0o`090003o`0000D000Co003o2@000ol0
00060003o`0000P000?o00002@0000X000?o00001P02o`P00_l900;o2@000ol0000500?o2P000ol0
000600;o2@000ol0000700;o2@000ol0000500;o2P000ol0000A0003o`4100H10_l80@;o2042o`X1
00?o00001@03o`T000?o00001`02o`T000?o00001P02o`X000?o00001@02o`X000?o00002@0000X0
00?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`410101
0_lD0@03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X000?o00004002oa@0
00?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0@03o`000140
00?o00004P000ol0000B0003o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0
000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0@03o`00014000?o00004P000ol0
000B0003o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`000180
00?o00004@000ol0000A0003o`4101010_lD0@03o`00014000?o00004P000ol0000B0003o`000140
00?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0
000A0003o`4101010_lD0@03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X0
00?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`410101
0_lD0@03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X0O?lC07co2`0000X0
00?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`410101
0_lD0@03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X000?o00004002oa@0
00?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0@03o`000140
00?o00004P000ol0000B0003o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0
000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0@03o`00014000?o00004P000ol0
000B0003o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`000180
00?o00004@000ol0000A0003o`4101010_lD0@03o`00014000?o00004P000ol0000B0003o`000140
00?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0
000A0003o`4101010_lD0@03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X0
00?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`410101
0_lD0@03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X000?o00004002oa@0
00?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0@03o`000140
00?o00004P000ol0000B0003o`00014000?o00002@0000X000?o00001@03o`P00_l800?o2@000ol0
000500Co2@000ol0000500?o2@000ol0000700?o20000ol0000600;o2@000ol0000A0003o`4100D1
0ol80@;o1`43o`X100?o00001@04o`P000?o00001P03o`T000?o00001P03o`T000?o00001P02o`T0
00?o00002@0000X000?o00001P000ol0000700;o2@000ol000080003o`0000H000?o00002@000ol0
00080003o`0000H000?o000020000ol000070003o`0000D000Co003o20000ol0000A0003o`4100H1
00?o0@401`42o`P100?o0@402@400ol000060003o`0000P000?o00002@000ol000060003o`0000L0
00?o000020000ol000050004o`00o`P000?o00002@0000X000?o00001P000ol0000700;o2@000ol0
00080003o`0000L000?o000020000ol000080003o`0000H000?o00001P04o`P000?o00001@001?l0
0?l80003o`00014000?o0@401P400ol10@070@;o20400ol10@090@03o`0000L000?o00001`000ol0
00090003o`0000H000?o00001@04o`T000?o00001@001?l00?l80003o`0000T0000:0003o`0000H0
00?o00001`02o`T000?o000020000ol000080003o`0000L000?o00001P02o`T000?o00001P000ol0
o`090003o`0000D000Co003o20000ol0000A0003o`4100H100?o0@401`42o`P100?o0@402@400ol0
00080003o`0000H000?o00001`02o`T000?o00001@000ol0o`0:0003o`0000D000Co003o20000ol0
000900002P000ol000060003o`0000L00_l90003o`0000P000?o00001@001?l00?l90003o`0000P0
00?o00001P000ol000060003o`3o00T000?o00001@001?l00?l80003o`00014000?o0@401P400ol1
0@070@;o20400ol10@090@03o`0000D000Co003o20000ol000090003o`0000H000?o00001@000ol0
o`0:0003o`0000D000Co003o20000ol0000900002P000ol0000500;o2@02o`P00_l:0003o`0000H0
0_l:0003o`0000D00ol90003o`0000L00_l90003o`0000H00_l90003o`00014000?o0@401@42o`T1
0_l70@;o2`400ol0000600;o2@000ol0000600?o2@000ol0000600;o2P000ol0000600;o2@000ol0
000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`000140
00?o0@404042oa@100?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P000ol0
000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0@404042oa@1
00?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P000ol0000@00;o50000ol0
000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0@404042oa@100?o00004@000ol0
000B0003o`00018000?o00004@000ol0000900002P000ol0000@00;o50000ol0000B0003o`000140
00?o00004P000ol0000A0003o`00014000?o0@404042oa@100?o00004@000ol0000B0003o`000180
00?o00004@000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0
000A0003o`00014000?o0@404042oa@100?o00004@000ol0000B0003o`00018000?o00004@000ol0
000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`000140
00?o0@404042oa@100?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P000ol0
000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0@404042oa@1
00?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P1loa<0O?l;00002P000olO
7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@1
00?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooO
g`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@100?o00004@000ol0
000B0003o`00018000?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooOg`0Bg`03omoO017O
00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@100?o00004@000ol0000B0003o`000180
00?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooO
g`0Ag`03o`00014000?o0@404042oa@100?o00004@000ol0000B0003o`00018000?o00004@000ol0
000900002P000olO7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`000140
00?o0@404042oa@100?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P000olO
7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@1
00?o00004@000ol0000B0003o`00018000?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooO
g`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@100?o00004@000ol0
000B0003o`00018000?o00004@000ol0000900002P000olO7`067`;o21l2o`WO0_l9g`03omoO00GO
0ol:g`03omoO00GO1?l8g`03omoO00KO0ol9g`03omoO00KO0ol8g`03o`00014000?o0@401P42o`P1
0_l80@;o2P400ol0000500?o2@000ol0000600Co20000ol0000500?o2P000ol0000600?o20000ol0
000900002P000olO7`057`04oalOo`LO0_l8g`04omoOo`SO00?ogml01]l00ooOg`09g`03omoO00KO
00?ogml02=l00ooOg`09g`03omoO00KO00?ogml01ml00ooOg`07g`03o`00014000?o0@401@401?l1
0Ol70@;o1`401?l10Ol90@03o`0000H000?o000020000ol000070003o`0000P000?o000020000ol0
00070003o`0000L000?o00001`000ol0000900002P000olO7`057`04oalOo`LO0_l8g`04omoOo`SO
00?ogml01]l00ooOg`09g`03omoO00OO00?ogml01ml00ooOg`09g`03omoO00KO00?ogml01Ml4o`SO
00?o00004@000ol10@050@04o`41o`L10_l70@04o`41o`T100?o00001P000ol000080003o`0000P0
00?o00001`000ol000080003o`0000L000?o00001@04o`P000?o00002@0000X000?o7al01Al01?lO
7ol77`;o2=l01?oOgol8g`03omoO00KO00?ogml02Ml00ooOg`08g`03omoO00KO00?ogml01ml2o`WO
00?ogml01Ml00ooOo`09g`03o`00014000?o0@401@401?l10Ol70@;o1`401?l10Ol90@03o`0000H0
00?o000020000ol000090003o`0000H000?o00001P02o`X000?o00001@000ol0o`090003o`0000T0
000:0003oalO00DO00Co7aoo1al2o`SO00Cogmoo2=l00ooOg`06g`03omoO00WO00?ogml01Ml01?oO
gol8g`03omoO00WO00?ogml01]l00ooOg`05g`03omoo00WO00?o00004@000ol10@050@04o`41o`L1
0_l70@04o`41o`T100?o00001P000ol000080003o`0000H000Co003o20000ol000080003o`0000L0
00?o00001@000ol0o`090003o`0000T0000:0003oalO00HO0_l87`;o2Ml2o`WO00?ogml01Ml2o`_O
00?ogml01]l2o`WO00?ogml01]l3o`WO00?ogml01]l2o`WO00?o00004@000ol10@060@;o2042o`P1
0_l:0@03o`0000D00_l:0003o`0000L00_l90003o`0000D00ol:0003o`0000H00_l90003o`0000T0
000:0003oalO010O0_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003oalO010O
0_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol10@0@0@;o50400ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003oalO010O0_lDg`03omoO01;O
00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol10@0@0@;o50400ol0000A0003o`000180
00?o00004P000ol0000A0003o`0000T0000:0003oalO010O0_lDg`03omoO01;O00?ogml04Ml00ooO
g`0Bg`03omoO017O00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0
000A0003o`0000T0000:0003oalO010O0_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O
00?o00004@000ol10@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003oalO010O0_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol1
0@0@0@;o50400ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000907go4P1mo`/0
000907go4P1mo`/0000:0003o`0001000_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O
00?o00004@000ol0000@00;o51l00ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`0000l00olDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol0
000?00?o51l00ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`0000h0
00Co0?oo5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o00003P001?l0
oolD7`03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X000Co00000_l00`3o
o`070003o`0000;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000Co0000
0_l00`3oo`070003o`0000;o51l00ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`00008000?o0?l01`001?l00002oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml0
4Ml00ol0000A0003o`00008000?o0?l01`001?l00002oa@O00?o00004@000ol0000B0003o`000180
00?o00004@000ol0000900002P000ol000030003o`0000D000?o00000P02oaCO00?ogml04]l00ooO
g`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`0000<000?o00001@000ol0000200;o51l00ol0
000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:0003o`00008000?o0?l01@000ol0
000300;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o00000P000ol0
o`050003o`0000<00_lD7`03o`00014000?o00004P000ol0000B0003o`00014000?o00002@0000X0
00Co00000_l00`3oo`030003o`0000@00_l9g`;o2Ml00ooOg`05g`?o2]l00ooOg`05g`Co2=l00ooO
g`06g`?o2Ml00ooOg`06g`?o2=l00ol0000A0004o`0000;o00<0ool00`000ol0000400;o21l2o`XO
00?o00001@03o`T000?o00001P04o`P000?o00001@03o`X000?o00001P03o`P000?o00002@0000X0
00?o000020000ol0000500;o2=l01?oOgol8g`03omoO00KO00?ogml02Ml00ooOg`06g`03omoO00SO
00?ogml02Ml00ooOg`06g`03omoO00OO00?ogml01ml00ol0000A0003o`0000P000?o00001@02o`LO
00Co7aoo2Al00ol000060003o`0000P000?o00001`000ol000080003o`0000P000?o00001`000ol0
00070003o`0000L000?o00002@0000X000?o00001`000ol0o`02o`@00_l8g`04omoOo`SO00?ogml0
1]l00ooOg`09g`03omoO00OO00?ogml01ml00ooOg`09g`03omoO00KO00?ogml01Ml4o`SO00?o0000
4@000ol000070003o`3o00;o1002o`LO00Co7aoo2Al00ol000060003o`0000P000?o000020000ol0
00070003o`0000P000?o00001`000ol0000500Co20000ol0000900002P000ol000060005o`000?l0
1@02o`SO00Cogmoo2=l00ooOg`06g`03omoO00WO00?ogml02=l00ooOg`06g`03omoO00OO0_l9g`03
omoO00GO00?ogol02Ml00ol0000A0003o`0000H000Go0000o`0500;o1al01?lO7ol97`03o`0000H0
00?o000020000ol000090003o`0000H000?o00001P02o`X000?o00001@000ol0o`090003o`0000T0
000:0003o`0000D000?o00000`000ol0000200;o2=l01?oOgol8g`03omoO00KO00?ogml02Ml00ooO
g`05g`04omoOo`SO00?ogml02Ml00ooOg`06g`03omoO00GO00?ogol02Ml00ol0000A0003o`0000D0
00?o00000`000ol0000200;o1al01?lO7ol97`03o`0000H000?o000020000ol000060004o`00o`P0
00?o000020000ol000070003o`0000D000?o0?l02@000ol0000900002P000ol000040003o`0000@0
00?o00000P02o`WO0_l9g`03omoO00GO0_l;g`03omoO00KO0_l9g`03omoO00KO0ol9g`03omoO00KO
0_l9g`03o`00014000?o000010000ol000040003o`0000800_l87`;o2Ql00ol0000500;o2P000ol0
000700;o2@000ol0000500?o2P000ol0000600;o2@000ol0000900002P000ol000030003o`0000@0
00?o0?l00`02oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`0000<0
00?o000010000ol0o`0300;o51l00ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0
000:0003o`00008000?o00001@000ol0o`0300;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooO
g`0Ag`03o`00014000?o00000P000ol000050003o`3o00<00_lD7`03o`00014000?o00004P000ol0
000B0003o`00014000?o00002@0000X000Go0000o`0700;o00<0ool00P02oaCO00?ogml04]l00ooO
g`0Ag`03omoO01;O00?ogml04Ml00ol0000A0005o`000?l01`02o`030?oo00800_lD7`03o`000140
00?o00004P000ol0000B0003o`00014000?o00002@0000X000Co003o3`02oaCO00?ogml04]l00ooO
g`0Ag`03omoO01;O00?ogml04Ml00ol0000A0004o`00o`l00_lD7`03o`00014000?o00004P000ol0
000B0003o`00014000?o00002@0000X000?o0?l04002oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O
00?ogml04Ml00ol0000A0003o`3o01000_lD7`03o`00014000?o00004P000ol0000B0003o`000140
00?o00002@0000X00_lA00;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`000140
0_lA00;o51l00ol0000A0003o`00018000?o00004P000ol0000A0003o`0000T0000:07co4`1lo`/0
000M00;oS@02og80003o0240003o0240003o0240003o0240000O0003o`0000P00_l:00;o10000ol0
000n00?o;P000ol0000800;o2P02o`@000?o0000?P03oa40000N0003o`0000T000?o00002P000ol0
00030003o`0003h000?o0000;0000ol000090003o`0000X000?o00000`000ol0000n0003o`000100
000:00;o00<0ool00`05o`030?oo00?o00<0o`000`04o`<000?o00000P03o`D000?o00000`000ol0
000U00;o00<0ool02P000ol000080003o`0001L00_l00`3oo`0300Go00<0ool00ol00`3o000300Co
0`000ol0000200?o1@000ol000030003o`0002D00_l00`3oo`0:0003o`0000P000?o00003`0000/0
00?o0?l00`001ol0003o0?l00`001?l00?l50003o`3o00<000?o00001@000ol000020003o`0000<0
00?o00009P000ol0o`0;0003o`0000P000?o000060000ol0o`030007o`000?l0o`030004o`00o`D0
00?o0?l00`000ol000050003o`00008000?o00000`000ol0000V0003o`3o00/000?o000020000ol0
000?00002`03o`<000Oo0000o`3o00<000Co003o1@000ol000030003o`0000D000?o00000P000ol0
00030003o`0002L000?o00002005o`L000?o0?l06@03o`<000Oo0000o`3o00<000Co003o1@000ol0
00030003o`0000D000?o00000P000ol000030003o`0002L000?o00002005o`L000?o0?l0400000/0
00?o0?l00`001ol0003o0?l00`001?l00?l60003o`00008000?o00000P03o`D000?o00000`000ol0
000V0003o`3o00/000?o00001`000ol0o`0I0003o`3o00<000Oo0000o`3o00<000Co003o1P000ol0
00020003o`0000800ol50003o`0000<000?o00009P000ol0o`0;0003o`0000L000?o0?l0400000`0
00?o00000`04o`801?l20003o`00008000?o0?l010000ol000020003o`0000D000?o00000`000ol0
000U00;o00<0ool02P000ol0000600;o00<0ool06@000ol0000300Co0P04o`8000?o00000P000ol0
o`040003o`00008000?o00001@000ol000030003o`0002D00_l00`3oo`0:0003o`0000H00_l00`3o
o`0?00002`02o`P000?o00000`001Ol0003o00<01?l300;o0`04o`<00_l40003o`0005/00_l80003
o`0000<000Go0000o`0300Co0`02o`<01?l300;o10000ol0001B00005002o`@00_n700;o1002ogD0
003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {159, 0}} -> {-0.052954, -0.0277836, 
  0.00733767, 0.00733767}, {{7.1875, 137}, {155.188, 
  3.75}} -> {-1.49911, -0.86008, 0.0485355, 0.0485355}, {{149.938, 279.75}, {
  155.188, 3.75}} -> {-8.42756, -0.86008, 0.0485355, 0.0485355}},
  CellTags->"AdditiveP"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[TextData[{
  "By the following, we know that 1 has a negative in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  "."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasNegativeQ[Z[5], \ 1]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[TextData[{
  "This explains why the negation of 1 in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_5\)]],
  " is 4."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NegationOf[Z[5], 1, Mode \[Rule] Textual]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \("Given a Ringoid R, we say an element r in R has an additive inverse s \
if R has an additive identity 0 and r + s = s + r = 0 (where + indicates the \
operation)."\)], "Print",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \("In this case, 1 has 4 as the inverse.\n"\)], "Print",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[TextData[{
  "Associativity in a ringoid with ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " elements involves ",
  Cell[BoxData[
      \(TraditionalForm\`n\^3\)]],
  " tests, so ",
  StyleBox["RandomAssociativeQ", "MR"],
  " is suggested for larger ringoids."
}], "Text",
  CellTags->"AdditiveP"],

Cell[TextData[{
  "If we used ",
  StyleBox["AssociativeQ", "MR"],
  " here, we would wait for 64,000 tests."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomAssociativeQ[Z[40], Operation \[Rule] Addition]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox[\(default\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["Mode",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Computational",
                "StandardForm"],
              "Text"], 
            
            StyleBox[\(specifies\ what\ type\ of\ information, \ if\ any, \ 
              should\ be\ given\ in\ addition\ to\ the\ result\ of\ the\ 
                computation\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Operation",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Both",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[
                \(for\ functions\ that\ apply\ to\ both\ addition\ and\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              
              StyleBox[\(multiplication, \ 
                specifies\ which\ of\ the\ operations\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[\(should\ be\ considered\),
                  SingleLetterItalics->False], 
                StyleBox[";",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  RowBox[{
                    StyleBox["Both",
                      "MR"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["Addition",
                      "MR"], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["or",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["Multiplication",
                      "MR"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["are",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["values",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["for",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["this",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["option",
                      SingleLetterItalics->False]}]}]}]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.17, 0.24, 0.59},
  RowLines->{True, False}},
  CellTags->{"AdditiveP", "i:18"}],

Cell["Options for functions that test ring properties.", "Caption",
  CellTags->"AdditiveP"],

Cell[TextData[{
  "Most of the functions that test the various properties of a ring allow the \
",
  StyleBox["Operation", "MR"],
  " option. Here we illustrate the four possibilities; note that (in this \
case\[LongDash]not true for all functions) not specifying the option assumes \
that both operations are to be checked."
}], "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(R\  = \ FormRingoid[{\(-1\), 0, 1}, \ Plus, Times]; 
    \n{ClosedQ[R, \ Operation\  \[Rule] \ Addition], 
      ClosedQ[R, \ Operation\  \[Rule] \ Multiplication], 
      ClosedQ[R, \ Operation\  \[Rule] \ Both], \ ClosedQ[R]}\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"AdditiveP"],

Cell[BoxData[
    \({False, True, False, False}\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"AdditiveP"]
}, Open  ]],

Cell["3.3.2 Multiplicative properties", "Subsubsection",
  CellTags->{"MultiplicativeP", "i:19"}],

Cell["\<\
The only purely multiplicative properties a ring must satisfy are \
closure and associativity, but there are several other additional properties \
that are of interest and can be tested.\
\>", "Text",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] \ Multiplication\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ the\ elements\ of\ the\ ringoid\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              
              StyleBox[\(\ 
                are\ closed\ with\ respect\ to\ the\ multiplication, \ and\ 
                \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["AssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Operation",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", 
                      StyleBox["Multiplication",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["on",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ associative, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.46, 0.54}},
  CellTags->{"MultiplicativeP", "i:20"}],

Cell["Functions for the required multiplicative ring properties.", "Caption",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["WithUnityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplicative",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["identity",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\((unity)\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["exists",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(\(R, \)\ \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["otherwise",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["Unity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ unity\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[\(\(\ if\ one\ exists\), \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["$Failed",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["UnitQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  "Text",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["r",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["has",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplicative",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["inverse",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["MultiplicativeInverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ multiplicative\ inverse\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["r",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R, \),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[\(if\ it\ exists\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["$Failed",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["CommutativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] Multiplication\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  "Text",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["commutative",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R, \),
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["RandomAssociativeQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Operation",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", 
                      StyleBox["Multiplication",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  "Text",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["appears",
                  SingleLetterItalics->False]}], "\n", 
              RowBox[{
                
                StyleBox[
                  \(to\ be\ associative\ 
                    \((based\ on\ testing\ 25\ \nrandom\ triples)\)\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["HasUnityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["WithUnityQ",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["R",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["HasIdentityQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(Operation\  \[Rule] Multiplication\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["WithUnityQ",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["R",
                  "TI"], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["InvertibleQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["r",
                  FontSlant->"Italic"], ",", 
                StyleBox[
                  FormBox[
                    RowBox[{" ", 
                      RowBox[{
                        StyleBox["Operation",
                          "MR"], " ", 
                        StyleBox["\[Rule]",
                          "MR"], " ", 
                        StyleBox["Multiplication",
                          "MR"]}]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{"identical", " ", "to", " ", 
              RowBox[{
                StyleBox["UnitQ",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox["R",
                    "TI"], 
                  StyleBox[",",
                    "TI"], " ", 
                  StyleBox["r",
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}]}]},
          {
            RowBox[{
              StyleBox["Inverses",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Operation",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", 
                      StyleBox["Multiplication",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
              "return", " ", "a", " ", "list", " ", "of", " ", "pairs", " ", 
                "of", " ", "the", " ", "form", " ", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["x",
                      FontSlant->"Italic"], ",", " ", 
                    SuperscriptBox[
                      StyleBox["x",
                        FontSlant->"Italic"], \(-1\)]}], "}"}]}], ",", " ", 
              RowBox[{"or", " ", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["x",
                      FontSlant->"Italic"], ",", " ", \(no\ inverse\)}], 
                  "}"}], " ", "if", " ", 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "is", " ", "not", " ", "a", " ", 
                "unit"}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.46, 0.54}},
  CellTags->{"MultiplicativeP", "i:21"}],

Cell["Related multiplicative functions of ring properties.", "Caption",
  CellTags->"MultiplicativeP"],

Cell[TextData[{
  "As with the additive properties, there are not many surprises when you \
consider standard rings such as the ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_\(n\ \)\)]],
  "family."
}], "Text",
  CellTags->"MultiplicativeP"],

Cell["The unity is 1.", "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \({WithUnityQ[Z[15]], Unity[Z[15]]}\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \({True, 1}\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell[TextData[{
  "For the units of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  ", here is how elements are paired with their multiplicative inverses."
}], "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{#, MultiplicativeInverse[Z[15], #]}&, Units[Z[15]]]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \({{1, 1}, {2, 8}, {4, 4}, {7, 13}, {8, 2}, {11, 11}, {13, 7}, {14, 14}}
      \)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell["\<\
Here is an alternate method that considers all the elements in the \
ring, providing appropriate information for those lacking multiplicative \
inverses.\
\>", "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverses[Z[15], \ Operation\  \[Rule] \ Multiplication, \ 
      Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"MultiplicativeP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Times
%%IncludeFont: Times
/Times findfont 14  scalefont  setfont
% Scaling calculations
0.5 0.3663 0.5 0.3663 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 1 1 r
.008 w
.5 .5 Mdot
.02381 .02381 m
.02381 .97619 L
.97619 .97619 L
.97619 .02381 L
F
.628 .126 .941 r
.5 Mabswid
[ ] 0 setdash
newpath
.5 .5 .3663 0 365.73 arc
s
0 0 1 r
.055 w
.5 .8663 Mdot
.64899 .83463 Mdot
.77221 .7451 Mdot
.84837 .61319 Mdot
.86429 .46171 Mdot
.81723 .31685 Mdot
.71531 .20366 Mdot
.57616 .1417 Mdot
.42384 .1417 Mdot
.28469 .20366 Mdot
.18277 .31685 Mdot
.13571 .46171 Mdot
.15163 .61319 Mdot
.22779 .7451 Mdot
.35101 .83463 Mdot
0 g
gsave
.5 .95788 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.68623 .91829 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.84027 .80638 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.93547 .64149 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(3) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.95537 .45214 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(4) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.89653 .27106 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.76913 .12957 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(6) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.5952 .05213 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(7) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.4048 .05213 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(8) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.23087 .12957 -84 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(9) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.10347 .27106 -87 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.04463 .45214 -87 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(11) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.06453 .64149 -87 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(12) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.15973 .80638 -87 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(13) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
gsave
.31377 .91829 -87 -12 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 24 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 20.000000 moveto
 540.000000 20.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 20.000000 lineto
closepath
clip newpath
81.000000 16.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(14) show
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
.5 .165 .165 r
2 Mabswid
newpath
.66091 .8614 .02564 0 365.73 arc
s
.77221 .7451 m
.42384 .1417 L
s
newpath
.89344 .45865 .02564 0 365.73 arc
s
.57616 .1417 m
.22779 .7451 L
s
newpath
.10656 .45865 .02564 0 365.73 arc
s
newpath
.33909 .8614 .02564 0 365.73 arc
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[42]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0007<00_ld0003o`0007@0
001b0004o`00oc<000?o0000M000078000Co003o=0000ol0001c0000L`02ocD000?o0000L`000780
00Co003o=@000ol0001b0000L`02oc<01?md0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000@003oc@01D`V00E<=002od<000130003o`0002l02D`R00U<<@001?l00?m20000
@@03oc002d`P00]<<0001?l00?m20000@0001?l00?l_00e<7P0=C2l00om30000@0001?l00?l_00e<
100064j>CXi>STj>CXi>STj>CXi>STj>CXi>SP803D`_0003o`0004<0001100;o;`0?C003CSi>01P0
00<nC4`03D`_00?o@P0007801T`00a4^C006C1`01d`00a4^C005C7@0001b00I<00<^DD`01T`L00M<
00<^DD`01Dad0000LP06C0034BhA00I<7006C003;Q4^00I<00=>SP00L@0006d000E>?ThnCP07C003
DBi<00E<7006C003DBi<00I<0P001Ci>?Thn06d0001Z0003CXi>00H01T`00bhA;P04C1h014`00a4^
4@06C0P000>>CP00JP0006P000<nCP002007C003;U4^00=<7P03C003DBiA00M<2P000dhnCP1X0000
I@000hi>SP0<00M<00@^4Da<8002C003;Q5<00I<3P000dj>001U0000H`000dhn000?00I<00=A;U40
8P000biA;P06C14000<nCSh0H`00060000=>STh05005C0034Bh0024000<A;T`014`F0003STh00600
001O0003CP0001X000<^DBh080000e4^D@0M0003CP0005h0001N0003CP0001`000<^4@007`000bhA
000N0003CP0005d0001?00E<20000ci>000N0003DBiA01h000<^DBh080000dhnCP0600E<D@0004d0
2D`30003STj>028000<A;Q4070000bhA;P0T0004CXh000U<C`0004`02d`00`0n000U0003DBh001/0
00=A;P009P000ci<C009C4h0001;00e<9`000bhA;P0J00034BhA02L03Da=0000B`0=C2P000<^D@00
6@000biA000W00e<C@0004X03d`W00034BhA01P000<^4Bh09`0?C4`0001:00m<:0000e4^D@0F0003
;U4^02P03da<0000BP0?C2T000<A;P005@000a4^000X00m<C00004X03d`Y0003;U4^01@000=A;U40
:@0?C4`0001:00m<:P000bhA000C0003;Q4002T03da<0000B`0=C2/000=A;U404P000biA;P0[00e<
C@0004/03D`/00034Bh0014000<A;P00:`0=C003SP0004X0001:0003?P1<00Y<;@000biA;P0@0003
DBiA02d02d`20003?P0004T000190004SP0000U<;`000bhA;P0>00034BhA02l02D`40003SP0004P0
00190003CP0000<01D`b0003;U4000d000<^D@00<@05C0L000<n0000A`0004P000=>0000>`000a4^
4@0<0003;Q4^03l000>>0000AP0004L000=>0000?@000e4^000;0003DBh003l000=>0000AP0004H0
00=>0000?P000bhA;P0:00034BhA044000=>0000A@0004D000=>0000@0000biA00090003;U400480
00=>0000A00004<000>>CP00@P000a4^4@080003;Q4^04@000=>0000@`00048000<n0000A0000e4^
D@060003;U4^04H000=>0000@P00044000>>0000AP000a4^000500034Bh004L000=>SP00@@000400
00<n0000A`000biA;P040003DBiA04X000<n0000?`0001P00ol400;o7P000hh000190003;Q4000<0
00<^4@00B`000hh0000M00?o7P0001T000?o00000P001?l00?lL0003?P0004X000=A;U400P000biA
;P1=0003?P0001l000?o00006`0001T000?o00000P001?l00?lL0003CP0004/000HA;Q4^4Bi>0003
CP0001l000?o00006`0001T000?o00000P001?l00?lK0003CP0004d000AA;U4^D0000dh0000K00?o
7P0001T000?o00000P001?l00?lK0003SP0004d000@^4BhAD0000hh0000K0003o`0001h0000H00;o
1@02oa/000<n0000C`000biA001A0003?P0001X01?lM0000>`000hh0001?0004;Q4^4E8000>>0000
>P0003/000=>0000C`00154^DBiB0003CP0003X0000j0003CP0004l000HA;Q4^4BiB0003CP0003T0
000i0003CP0004l000=A;U400P000biA;P1B0003CP0003P0000b00E<00<0CP00D@000bhA00030003
;Q40058000=>04`014`c0000<009C54000<^DBh010000e4^D@1B00U<<@0002l02da@00034Bh000D0
00<A;P00D00;C300000^00e<CP000e4^D@060003;U4^04l03D`_0000;P0=C4h000<^4@001`000bhA
001>00e<;`0002d03da<0003;U4^00P000=A;U40C@0?C2h0000]00m<B`000bhA;P0:00034BhA04`0
3d`^0000;@0?C4/000=A;P002`000e4^001;00m<;P0002d03da:00034BhA00`000<^4Bh0B`0?C2h0
000]00m<BP000biA000=0003;U4004X03d`^0000;P0=C4X000<^4Bh03P000a4^4@1;00e<;`0002h0
3Da90003;U4^010000=A;U40BP0=C2l0000_00]<BP000a4^000A00034Bh004X02d``0000<009C4X0
00=A;U404P000biA;P1;00U<<@00030000=>04`014a<0003;Q4001<000<^4@00C005C00304h00300
000_0003CP00050000<^DBh050000e4^D@1C0003CP0002h0000_0003SP00050000<A;P005@000a4^
001B0003SP0002h0000_0003CP0004l000=A;U405P000biA;P1B0003CP0002h0000^0003CP0004l0
00<A;Q4060000bhA;P1B0003CP0002d0000^0003?P0004l000<^D@006@000biA001A0003?P0002d0
000]0003SP0004l000<^4Bh06P000a4^4@1B0003SP0002`0000]0003CP0004l000=A;P006`000e4^
001A0003CP0002`0000]0003SP0004h000<A;Q4070000bhA;P1A0003SP0002`0000/0003?P0004l0
00<^D@007@000biA001A0003?P0002/0000/0003CP0004h000<^4Bh07P000a4^4@1A0003CP0002/0
000[0003CP0004h000<^DBh080000e4^D@1A0003CP0002X0000[0003SP0004h000<A;P008@000a4^
001@0003SP0002X0000[0003CP0004d000=A;U408P000biA;P1@0003CP0002X0000[0003SP0004d0
00<^4@008`000bhA001?0003SP0002X0000[0003CP0004`000<^DBh090000e4^D@1?0003CP0002X0
000Z0003CP0004d000<A;P009@000a4^001?0003CP0002T0000Z0003?P0004`000=A;U409P000biA
;P1?0003?P0002T0000Z0003CP0004/000<A;Q40:0000bhA;P1>0003CP0002T0000Y0003CP0004`0
00<^D@00:@000biA001>0003CP0002P0000Y0003SP0004/000<^4Bh0:P000a4^4@1>0003SP0002P0
000Y0003CP0004/000=A;P00:`000e4^001=0003CP0002P0000Y0003SP0004X000<A;Q40;0000bhA
;P1=0003SP0002P0000Y0003CP0004T000=A;U40;P000biA;P1<0003CP0002P0000X0003CP0004X0
00<^4@00;`000bhA001<0003CP0002L0000X0003?P0004T000<^DBh0<0000e4^D@1<0003?P0002L0
000J00074BhA;Q4^4@060003SP0004X000<A;P00<@000a4^001<0003SP00008000LA;Q4^4BhA01d0
000I000;DBiA;U4^DBiA;U401Da:0003DBiA038000<^DBh0BP05C00<054^DBiA;U4^DBiA6P0000L0
0ol300?o20000a4^4@0500054BhA;Q401Ta80003;Q4003<000<^4@00A`07C0034BhA00D000DA;Q4^
4@0:00?o300000P000?o00000`000ol000060003DBiA00L00T`00e4^C006C4H000<^DBh0=0000e4^
D@1600M<00AA;U5<20000e4^000:0003o`0000/000080003o`0000<000?o00001@000a4^4@0700=<
00<^4Bh01da40003;Q4^03H000<A;Q40A007C0034BhA00=<1`000bhA;P0800Co300000P000?o0000
0`000ol000050003;U4000L014`00biAC006C4@000=A;P00=`000e4^001300M<00<^DD`00d`80003
;U4000L000?o0?l03@0000P000?o00000`000ol0000500034Bh000H01D`00a4^C007C48000<A;Q40
>0000bhA;P1200Q<00<A;T`014`700034Bh000L000?o0?l03@0000L00_l400;o1`000biA000600E<
00<^DD`01da20003;U4003T000<^D@00@@08C003;U5<00A<1`000biA000800;o3@0001H000<A;P00
1P05C0034Bi<00M<@@000bhA;P0j00034BhA044024`00a4^C004C0L000<A;P005`0001H000<^D@00
1P05C003;U5<00M<@@000e4^000k0003DBh0040024`00biAC004C0L000<^D@005`0001H000<A;P00
1P05C0034Bi<00M<@0000a4^4@0l0003;Q4^040024`00a4^C004C0L000<A;P005`0001H000<^DBh0
1`03C003DBiA00M<@0000e4^D@0n0003;U4^04001d`00biA;P03C0L000=A;U40600001L000<^4Bh0
1P02C0034BhA00Q<@0000bhA000o0003;Q4003l024`00bhA;P02C0H000<A;Q406@0001P000<^DBh0
1P000e4^D@08C40000<^DBh0@0000e4^D@1000Q<00<^DBh01P000e4^D@0J00006@002RhA;Q4^4BhA
;Q48C44000<A;P00@@000a4^001000Q<00X^4BhA;Q4^4BhA6`0001X000P^DBiA;U4^D@801Da20003
DBiA048000<^DBh0@P05C08000P^DBiA;U4^DA`0000V0003CP00044000<A;Q40A0000bhA;P140003
CP0002D0000V0003?P00044000<^D@00A@000biA00130003?P0002D0000V0003CP00040000<^4Bh0
AP000a4^4@130003CP0002D0000V0003?P00040000=A;P00A`000e4^00120003?P0002D0000V0003
CP0003l000<A;Q40B0000bhA;P120003CP0002D0000V0003?P0003l000<^D@00B@000biA00110003
?P0002D0000V0003CP0003h000<^4Bh0BP000a4^4@110003CP0002D0000V0003?P0003d000<^DBh0
C0000e4^D@100003?P0002D0000V0003CP0003d000<A;P00C@000a4^000o0003CP0002D0000V0003
?P0003`000=A;U40CP000biA;P0o0003?P0002D0000V0003CP0003`000<^4@00C`000bhA000n0003
CP0002D0000V0003?P0003/000<^DBh0D0000e4^D@0n0003?P0002D0000V0003CP0003/000<A;P00
D@000a4^000m0003CP0002D0000V0003?P0003X000=A;U40DP000biA;P0m0003?P0002D0000V0003
CP0003T000<A;Q40E0000bhA;P0l0003CP0002D0000W0003CP0003P000<^D@00E@000biA000j0003
CP0002H0000W0003SP0003L000<^4Bh0EP000a4^4@0j0003SP0002H0000W0003CP0003L000=A;P00
E`000e4^000i0003CP0002H0000W0003SP0003H000<A;Q40F0000bhA;P0i0003SP0002H0000W0003
CP0003H000<^D@00F@000biA000h0003CP0002H0000W0003SP0003D000<^4Bh0FP000a4^4@0h0003
SP0002H0000W0003CP0003@000<^DBh0G0000e4^D@0g0003CP0002H0000W0003SP0003@000<A;P00
G@000a4^000f0003SP0002H0000X0003?P00038000=A;U40GP000biA;P0e0003?P0002L0000X0003
CP00038000<^4@00G`000bhA000d0003CP0002L0000X0003?P00034000<^DBh0H0000e4^D@0d0003
?P0002L0000Y0003SP0002l000<^4Bh0HP000a4^4@0b0003SP0002P0000Y0003CP0002l000=A;P00
H`000e4^000a0003CP0002P0000Y0003SP0002h000<A;Q40I0000bhA;P0a0003SP0002P0000Y00E<
;0000biA001U0003;U4002`01D`Z00009`09C2T000<^4Bh0IP000a4^4@0Z00U<:00002H02d`X0003
DBh006L000=A;P00:00;C2L0000U00e<9P000a4^4@1X0003;Q4^02L03D`V00009@0=C2D000=A;U40
JP000biA;P0V00e<9P0002@03d`T0003;Q4006/000<^4@00900?C2D0000T00m<8`000biA;P1/0003
DBiA02@03d`U0000900?C2<000<A;P00K@000a4^000S00m<9@0002@03d`R0003DBiA06h000<^DBh0
8`0?C2D0000T00m<8P000bhA001_0003;Q4002803d`U00009@0=C28000<^DBh0L0000e4^D@0S00e<
9P0002D03D`Q0003;Q4^078000<A;Q408P0=C2H0000=00?o0`04o`l02d`R0003DBh007<000=A;P00
8P0;C1400olC00003P000ol000030003o`0001002D`R00034BhA07@000<^4Bh08`09C1D000?o0000
400000h000?o000010000ol0000A00E<00<n00008@000biA001e0003;U4002<000<nC4`00d`G0003
o`000100000>0003o`0000D000?o00005@000dh0000P0003;Q4^07H000<A;Q408`000dh0000H00;o
4`0000h000?o00000P001?l00?lG0003?P0001l000<^DBh0N0000e4^D@0R0003?P0001X000?o0000
400000d00_l500;o6@000hh0000N00034Bh007T000<A;P0080000hh0000H00?o4`0002l000=>0000
7@000e4^D@1j0003;U4^020000=>0000;P00030000=>000070000bhA001k0003;Q4001h000=>0000
;`00030000<n00006`000biA;P1l0003DBiA01h000<n0000;`00030000=>00006`000a4^001m0003
4Bh001d000=>0000;`00034000=>00006@000e4^D@1n0003;U4^01`000=>0000<000038000=>0000
5`000a4^4@200003;Q4^01X000=>0000<@0003<000=>00005P000biA00210003;U4001P000=>0000
<P0003<000>>00005@000bhA;P2200034BhA01P000>>0000<P0003@000<n000050000e4^00230003
DBh001H000<n0000<`0003@000=>00004`000a4^4@240003;Q4^01H000=>0000<`0003@000<n0000
4`000biA00250003;U4001D000<n0000<`0003D000>>00004@000bhA;P2600034BhA01@000>>0000
=00003H000<n00003`000biA;P280003DBiA018000<n0000=@0003L000>>00003P000a4^00290003
4Bh0010000>>0000=P0003L000=>00003@000e4^D@2:0003;U4^010000=>0000=P0003P000=>0000
30000bhA002;0003;Q4000h000=>0000=`0003T000=>00002P000biA;P2<0003DBiA00d000=>0000
>00003X000=>000020000bhA;P2>00034BhA00/000=>0000>@0003X000<n000020000e4^002?0003
DBh000X000<n0000>@0003/000>>00001P000a4^4@2@0003;Q4^00T000>>0000>P0003/000A>0000
1D`00biA002A0003;U4000E<0`000dh0000j0000?0000di<C004C003;Q4^098000<A;Q401d`00dh0
000k0000?007C004DBi<C94000=<DBh024`m0000>`07C0034BhA00=<S`02C003;Q4^00Q<?00003/0
1T`00e4^D@04C8l00d`00biA;P07C3`0000j00M<00<^4D`01Db=00E<00<^4D`01d`k0000>P06C003
;U4^00I<S@05C003DBiA00M<>`0003X01T`00a4^C006C8d01T`00a4^C006C3/0000j00m<S@0?C3/0
000j00m<S@0?C3/0000k00e<S`0=C3`0000k00e<S`0=C3`0000l00]<T@0;C3d0000m00U<00<0SP00
SP000hh0C008C3h0000o00E<10000ch0002;0003?P0000801Da00000B@000hh000290003SP0004P0
001:0003?P0008L000<n0000B@0004/000>>CP00Q0000dj>001;0000C@000dhn00200003?Th004d0
001?0003SP0007d000>>0000CP00050000<nCP00NP000dhn001@0000:003o`<00olQ0003CP0007L0
00=>00008004obd0000Y0003o`0000D000?o00007`000dh0001e0003CP00028000?o0000;@0002T0
00?o00001@000ol0000P0003CXh0078000>>CP009@000ol0000/0000:@000ol0000300;o9@000ch0
001_0003?P0002L000?o0000:`0002T000?o00001@000ol0000S0003SP0000P01Da@00E<2`000hh0
000U0004o`00obd0000X00;o1003obL000<nCP001@09C4`02D`70003CSh002P00_l^0000FP000dj>
CP0200]<BP0;C0@000>>CP00FP0005d000=>C4`02da800e<00<0CSh0G@0005h03Da800e<00=>0000
G@0005d03da600m<G`0005d03da600m<G`0005d00T`01E4^DBiA00Q<AP0:C005;U4^DBh0G`0005`0
00TA;Q4^4BhA;Q401da600M<00T^4BhA;Q4^4Bh0GP0005/000EA;U4^D@03C003DBiA00I<AP05C006
DBiA;U4^0d`00biA;P1M0000F`000bhA0006C0034BhA00A<00>>CXh07`05C20000=>C4`00T`00bhA
;P06C00402hA;U`0001J0004;U4^00M<00=A;T`00d`30005?ThnCSh06009C1T000I>?ThnCP03C003
;U4^00M<0P000biA001K0000F@000bhA;P0300I<00<^4Bh00T`90003STh001@02d`E0003CXi>00L0
0T`00a4^C006C0<000<A;Q40F`0005T000=A;P001006C003;U4^00`000E>?ThnCP0?00e<3`001Dhn
CSi>00/000=<;U401T`50003DBh005X0001H00034BhA00L01D`00bhA000@0003CXi>00`03D`=0003
STh000l000<^4Bh014`70003;Q4005X0001H0003;U4000`000=A;P004`0024hnCSi>?Thn0`0?C0@0
00Q>?ThnCSi>?Q8000=A;P002`000e4^D@1J0000F0000a4^4@0<0003;Q4001/000>>CXh03d`018i>
SThJ0003;Q4000`000<A;P00F@0005T000=A;P002`000e4^000N00m<7P000e4^000;0003DBiA05X0
001I0003;Q4000/000<^4@007P0?C1h000<^4@002`000bhA001J0000F@000e4^D@0:0003;U4^01l0
3d`N0003DBiA00X000<^DBh0F`0005X000@A;Q4^1`000bhA;P0Q00e<8000114^4Bh70003;Q4^05`0
001J0007;U4^DBiA;P030003;U4^02803D`Q0006DBiA;U4^0`000biA;P1M0000G@002BhA;Q4^4BhA
;P0T00]<90002BhA;Q4^4BhA;P1N0000H0001BiA;U4^02H02D`X0005;U4^DBh0G`0008d01Db>0000
o`0Q0000o`0Q0000o`0Q0000E@03o`@00omS00?oF`0005H000?o000010000ol0001S0003o`0005X0
001F0003o`0000801?mT0003o`0005X0001F0003o`00008000?o0?l0I@000ol0001J0000EP000ol0
00020003o`3o06D000?o0000FP0005D00_l500;oI002oe`0003o0240003o0240003o0240003o0240
003o0240002>00;oT00008d000Co003oS`0008d000Co003oS`0008d000Co003oS`0008d000Co003o
S`0008h00_n@0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-1.36502, -1.36502, 0.0095123, 
  0.0095123}},
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \({{0, "no inverse"}, {1, 1}, {2, 8}, {3, "no inverse"}, {4, 4}, {5, 
        "no inverse"}, {6, "no inverse"}, {7, 13}, {9, "no inverse"}, {10, 
        "no inverse"}, {11, 11}, {12, "no inverse"}, {14, 14}}\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell[TextData[{
  "Multiplication in a ring does not need to be commutative. The ring of \
two-by-two matrices over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " is not commutative."
}], "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CommutativeQ[ToRingoid[Mat[Z[2], 2]], Operation \[Rule] Multiplication, 
      \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \("KEY for Mult(-Mat   (Z[2])-)\n         (2): label used \[Rule] \
element: {g1 \[Rule] {{0, 0}, {0, 0}}, g2 \[Rule] {{0, 0}, {0, 1}}, g3 \
\[Rule] {{0, 0}, {1, 0}}, g4 \[Rule] {{0, 0}, {1, 1}}, g5 \[Rule] {{0, 1}, \
{0, 0}}, g6 \[Rule] {{0, 1}, {0, 1}}, g7 \[Rule] {{0, 1}, {1, 0}}, g8 \[Rule] \
{{0, 1}, {1, 1}}, g9 \[Rule] {{1, 0}, {0, 0}}, g10 \[Rule] {{1, 0}, {0, 1}}, \
g11 \[Rule] {{1, 0}, {1, 0}}, g12 \[Rule] {{1, 0}, {1, 1}}, g13 \[Rule] {{1, \
1}, {0, 0}}, g14 \[Rule] {{1, 1}, {0, 1}}, g15 \[Rule] {{1, 1}, {1, 0}}, g16 \
\[Rule] {{1, 1}, {1, 1}}}"\)], "Print",
  CellTags->"MultiplicativeP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.02941 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0798319 0.0560224 0.0245098 0.0560224 [
[ 0 0 0 0 ]
[ 1 1.02941 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.02941 L
0 1.02941 L
closepath
clip
newpath
1 1 1 r
.07983 .86485 m
.07983 .92087 L
.13585 .92087 L
.13585 .86485 L
F
.13585 .86485 m
.13585 .92087 L
.19188 .92087 L
.19188 .86485 L
F
.19188 .86485 m
.19188 .92087 L
.2479 .92087 L
.2479 .86485 L
F
.2479 .86485 m
.2479 .92087 L
.30392 .92087 L
.30392 .86485 L
F
.30392 .86485 m
.30392 .92087 L
.35994 .92087 L
.35994 .86485 L
F
.35994 .86485 m
.35994 .92087 L
.41597 .92087 L
.41597 .86485 L
F
.41597 .86485 m
.41597 .92087 L
.47199 .92087 L
.47199 .86485 L
F
.47199 .86485 m
.47199 .92087 L
.52801 .92087 L
.52801 .86485 L
F
.52801 .86485 m
.52801 .92087 L
.58403 .92087 L
.58403 .86485 L
F
.58403 .86485 m
.58403 .92087 L
.64006 .92087 L
.64006 .86485 L
F
.64006 .86485 m
.64006 .92087 L
.69608 .92087 L
.69608 .86485 L
F
.69608 .86485 m
.69608 .92087 L
.7521 .92087 L
.7521 .86485 L
F
.7521 .86485 m
.7521 .92087 L
.80812 .92087 L
.80812 .86485 L
F
.80812 .86485 m
.80812 .92087 L
.86415 .92087 L
.86415 .86485 L
F
.86415 .86485 m
.86415 .92087 L
.92017 .92087 L
.92017 .86485 L
F
.92017 .86485 m
.92017 .92087 L
.97619 .92087 L
.97619 .86485 L
F
.07983 .80882 m
.07983 .86485 L
.13585 .86485 L
.13585 .80882 L
F
.13585 .80882 m
.13585 .86485 L
.19188 .86485 L
.19188 .80882 L
F
.19188 .80882 m
.19188 .86485 L
.2479 .86485 L
.2479 .80882 L
F
.2479 .80882 m
.2479 .86485 L
.30392 .86485 L
.30392 .80882 L
F
.30392 .80882 m
.30392 .86485 L
.35994 .86485 L
.35994 .80882 L
F
.35994 .80882 m
.35994 .86485 L
.41597 .86485 L
.41597 .80882 L
F
.41597 .80882 m
.41597 .86485 L
.47199 .86485 L
.47199 .80882 L
F
.47199 .80882 m
.47199 .86485 L
.52801 .86485 L
.52801 .80882 L
F
.52801 .80882 m
.52801 .86485 L
.58403 .86485 L
.58403 .80882 L
F
.58403 .80882 m
.58403 .86485 L
.64006 .86485 L
.64006 .80882 L
F
.64006 .80882 m
.64006 .86485 L
.69608 .86485 L
.69608 .80882 L
F
.69608 .80882 m
.69608 .86485 L
.7521 .86485 L
.7521 .80882 L
F
.7521 .80882 m
.7521 .86485 L
.80812 .86485 L
.80812 .80882 L
F
.80812 .80882 m
.80812 .86485 L
.86415 .86485 L
.86415 .80882 L
F
.86415 .80882 m
.86415 .86485 L
.92017 .86485 L
.92017 .80882 L
F
.92017 .80882 m
.92017 .86485 L
.97619 .86485 L
.97619 .80882 L
F
.07983 .7528 m
.07983 .80882 L
.13585 .80882 L
.13585 .7528 L
F
.13585 .7528 m
.13585 .80882 L
.19188 .80882 L
.19188 .7528 L
F
.19188 .7528 m
.19188 .80882 L
.2479 .80882 L
.2479 .7528 L
F
.2479 .7528 m
.2479 .80882 L
.30392 .80882 L
.30392 .7528 L
F
.30392 .7528 m
.30392 .80882 L
.35994 .80882 L
.35994 .7528 L
F
.35994 .7528 m
.35994 .80882 L
.41597 .80882 L
.41597 .7528 L
F
.41597 .7528 m
.41597 .80882 L
.47199 .80882 L
.47199 .7528 L
F
.47199 .7528 m
.47199 .80882 L
.52801 .80882 L
.52801 .7528 L
F
.52801 .7528 m
.52801 .80882 L
.58403 .80882 L
.58403 .7528 L
F
.58403 .7528 m
.58403 .80882 L
.64006 .80882 L
.64006 .7528 L
F
.64006 .7528 m
.64006 .80882 L
.69608 .80882 L
.69608 .7528 L
F
.69608 .7528 m
.69608 .80882 L
.7521 .80882 L
.7521 .7528 L
F
.7521 .7528 m
.7521 .80882 L
.80812 .80882 L
.80812 .7528 L
F
.80812 .7528 m
.80812 .80882 L
.86415 .80882 L
.86415 .7528 L
F
.86415 .7528 m
.86415 .80882 L
.92017 .80882 L
.92017 .7528 L
F
.92017 .7528 m
.92017 .80882 L
.97619 .80882 L
.97619 .7528 L
F
.07983 .69678 m
.07983 .7528 L
.13585 .7528 L
.13585 .69678 L
F
.13585 .69678 m
.13585 .7528 L
.19188 .7528 L
.19188 .69678 L
F
.19188 .69678 m
.19188 .7528 L
.2479 .7528 L
.2479 .69678 L
F
.2479 .69678 m
.2479 .7528 L
.30392 .7528 L
.30392 .69678 L
F
.30392 .69678 m
.30392 .7528 L
.35994 .7528 L
.35994 .69678 L
F
.35994 .69678 m
.35994 .7528 L
.41597 .7528 L
.41597 .69678 L
F
.41597 .69678 m
.41597 .7528 L
.47199 .7528 L
.47199 .69678 L
F
.47199 .69678 m
.47199 .7528 L
.52801 .7528 L
.52801 .69678 L
F
.52801 .69678 m
.52801 .7528 L
.58403 .7528 L
.58403 .69678 L
F
.58403 .69678 m
.58403 .7528 L
.64006 .7528 L
.64006 .69678 L
F
.64006 .69678 m
.64006 .7528 L
.69608 .7528 L
.69608 .69678 L
F
.69608 .69678 m
.69608 .7528 L
.7521 .7528 L
.7521 .69678 L
F
.7521 .69678 m
.7521 .7528 L
.80812 .7528 L
.80812 .69678 L
F
.80812 .69678 m
.80812 .7528 L
.86415 .7528 L
.86415 .69678 L
F
.86415 .69678 m
.86415 .7528 L
.92017 .7528 L
.92017 .69678 L
F
.92017 .69678 m
.92017 .7528 L
.97619 .7528 L
.97619 .69678 L
F
.07983 .64076 m
.07983 .69678 L
.13585 .69678 L
.13585 .64076 L
F
.13585 .64076 m
.13585 .69678 L
.19188 .69678 L
.19188 .64076 L
F
.19188 .64076 m
.19188 .69678 L
.2479 .69678 L
.2479 .64076 L
F
.2479 .64076 m
.2479 .69678 L
.30392 .69678 L
.30392 .64076 L
F
.30392 .64076 m
.30392 .69678 L
.35994 .69678 L
.35994 .64076 L
F
.35994 .64076 m
.35994 .69678 L
.41597 .69678 L
.41597 .64076 L
F
.41597 .64076 m
.41597 .69678 L
.47199 .69678 L
.47199 .64076 L
F
.47199 .64076 m
.47199 .69678 L
.52801 .69678 L
.52801 .64076 L
F
.52801 .64076 m
.52801 .69678 L
.58403 .69678 L
.58403 .64076 L
F
.58403 .64076 m
.58403 .69678 L
.64006 .69678 L
.64006 .64076 L
F
.64006 .64076 m
.64006 .69678 L
.69608 .69678 L
.69608 .64076 L
F
.69608 .64076 m
.69608 .69678 L
.7521 .69678 L
.7521 .64076 L
F
.7521 .64076 m
.7521 .69678 L
.80812 .69678 L
.80812 .64076 L
F
.80812 .64076 m
.80812 .69678 L
.86415 .69678 L
.86415 .64076 L
F
.86415 .64076 m
.86415 .69678 L
.92017 .69678 L
.92017 .64076 L
F
.92017 .64076 m
.92017 .69678 L
.97619 .69678 L
.97619 .64076 L
F
.07983 .58473 m
.07983 .64076 L
.13585 .64076 L
.13585 .58473 L
F
.13585 .58473 m
.13585 .64076 L
.19188 .64076 L
.19188 .58473 L
F
.19188 .58473 m
.19188 .64076 L
.2479 .64076 L
.2479 .58473 L
F
.2479 .58473 m
.2479 .64076 L
.30392 .64076 L
.30392 .58473 L
F
.30392 .58473 m
.30392 .64076 L
.35994 .64076 L
.35994 .58473 L
F
.35994 .58473 m
.35994 .64076 L
.41597 .64076 L
.41597 .58473 L
F
.41597 .58473 m
.41597 .64076 L
.47199 .64076 L
.47199 .58473 L
F
.47199 .58473 m
.47199 .64076 L
.52801 .64076 L
.52801 .58473 L
F
.52801 .58473 m
.52801 .64076 L
.58403 .64076 L
.58403 .58473 L
F
.58403 .58473 m
.58403 .64076 L
.64006 .64076 L
.64006 .58473 L
F
.64006 .58473 m
.64006 .64076 L
.69608 .64076 L
.69608 .58473 L
F
.69608 .58473 m
.69608 .64076 L
.7521 .64076 L
.7521 .58473 L
F
.7521 .58473 m
.7521 .64076 L
.80812 .64076 L
.80812 .58473 L
F
.80812 .58473 m
.80812 .64076 L
.86415 .64076 L
.86415 .58473 L
F
.86415 .58473 m
.86415 .64076 L
.92017 .64076 L
.92017 .58473 L
F
.92017 .58473 m
.92017 .64076 L
.97619 .64076 L
.97619 .58473 L
F
.07983 .52871 m
.07983 .58473 L
.13585 .58473 L
.13585 .52871 L
F
.13585 .52871 m
.13585 .58473 L
.19188 .58473 L
.19188 .52871 L
F
.19188 .52871 m
.19188 .58473 L
.2479 .58473 L
.2479 .52871 L
F
.2479 .52871 m
.2479 .58473 L
.30392 .58473 L
.30392 .52871 L
F
.30392 .52871 m
.30392 .58473 L
.35994 .58473 L
.35994 .52871 L
F
.35994 .52871 m
.35994 .58473 L
.41597 .58473 L
.41597 .52871 L
F
.41597 .52871 m
.41597 .58473 L
.47199 .58473 L
.47199 .52871 L
F
.47199 .52871 m
.47199 .58473 L
.52801 .58473 L
.52801 .52871 L
F
.52801 .52871 m
.52801 .58473 L
.58403 .58473 L
.58403 .52871 L
F
.58403 .52871 m
.58403 .58473 L
.64006 .58473 L
.64006 .52871 L
F
.64006 .52871 m
.64006 .58473 L
.69608 .58473 L
.69608 .52871 L
F
.69608 .52871 m
.69608 .58473 L
.7521 .58473 L
.7521 .52871 L
F
.7521 .52871 m
.7521 .58473 L
.80812 .58473 L
.80812 .52871 L
F
.80812 .52871 m
.80812 .58473 L
.86415 .58473 L
.86415 .52871 L
F
.86415 .52871 m
.86415 .58473 L
.92017 .58473 L
.92017 .52871 L
F
.92017 .52871 m
.92017 .58473 L
.97619 .58473 L
.97619 .52871 L
F
.07983 .47269 m
.07983 .52871 L
.13585 .52871 L
.13585 .47269 L
F
.13585 .47269 m
.13585 .52871 L
.19188 .52871 L
.19188 .47269 L
F
.19188 .47269 m
.19188 .52871 L
.2479 .52871 L
.2479 .47269 L
F
.2479 .47269 m
.2479 .52871 L
.30392 .52871 L
.30392 .47269 L
F
.30392 .47269 m
.30392 .52871 L
.35994 .52871 L
.35994 .47269 L
F
.35994 .47269 m
.35994 .52871 L
.41597 .52871 L
.41597 .47269 L
F
.41597 .47269 m
.41597 .52871 L
.47199 .52871 L
.47199 .47269 L
F
.47199 .47269 m
.47199 .52871 L
.52801 .52871 L
.52801 .47269 L
F
.52801 .47269 m
.52801 .52871 L
.58403 .52871 L
.58403 .47269 L
F
.58403 .47269 m
.58403 .52871 L
.64006 .52871 L
.64006 .47269 L
F
.64006 .47269 m
.64006 .52871 L
.69608 .52871 L
.69608 .47269 L
F
.69608 .47269 m
.69608 .52871 L
.7521 .52871 L
.7521 .47269 L
F
.7521 .47269 m
.7521 .52871 L
.80812 .52871 L
.80812 .47269 L
F
.80812 .47269 m
.80812 .52871 L
.86415 .52871 L
.86415 .47269 L
F
.86415 .47269 m
.86415 .52871 L
.92017 .52871 L
.92017 .47269 L
F
.92017 .47269 m
.92017 .52871 L
.97619 .52871 L
.97619 .47269 L
F
.07983 .41667 m
.07983 .47269 L
.13585 .47269 L
.13585 .41667 L
F
.13585 .41667 m
.13585 .47269 L
.19188 .47269 L
.19188 .41667 L
F
.19188 .41667 m
.19188 .47269 L
.2479 .47269 L
.2479 .41667 L
F
.2479 .41667 m
.2479 .47269 L
.30392 .47269 L
.30392 .41667 L
F
.30392 .41667 m
.30392 .47269 L
.35994 .47269 L
.35994 .41667 L
F
.35994 .41667 m
.35994 .47269 L
.41597 .47269 L
.41597 .41667 L
F
.41597 .41667 m
.41597 .47269 L
.47199 .47269 L
.47199 .41667 L
F
.47199 .41667 m
.47199 .47269 L
.52801 .47269 L
.52801 .41667 L
F
.52801 .41667 m
.52801 .47269 L
.58403 .47269 L
.58403 .41667 L
F
.58403 .41667 m
.58403 .47269 L
.64006 .47269 L
.64006 .41667 L
F
.64006 .41667 m
.64006 .47269 L
.69608 .47269 L
.69608 .41667 L
F
.69608 .41667 m
.69608 .47269 L
.7521 .47269 L
.7521 .41667 L
F
.7521 .41667 m
.7521 .47269 L
.80812 .47269 L
.80812 .41667 L
F
.80812 .41667 m
.80812 .47269 L
.86415 .47269 L
.86415 .41667 L
F
.86415 .41667 m
.86415 .47269 L
.92017 .47269 L
.92017 .41667 L
F
.92017 .41667 m
.92017 .47269 L
.97619 .47269 L
.97619 .41667 L
F
.07983 .36064 m
.07983 .41667 L
.13585 .41667 L
.13585 .36064 L
F
.13585 .36064 m
.13585 .41667 L
.19188 .41667 L
.19188 .36064 L
F
.19188 .36064 m
.19188 .41667 L
.2479 .41667 L
.2479 .36064 L
F
.2479 .36064 m
.2479 .41667 L
.30392 .41667 L
.30392 .36064 L
F
.30392 .36064 m
.30392 .41667 L
.35994 .41667 L
.35994 .36064 L
F
.35994 .36064 m
.35994 .41667 L
.41597 .41667 L
.41597 .36064 L
F
.41597 .36064 m
.41597 .41667 L
.47199 .41667 L
.47199 .36064 L
F
.47199 .36064 m
.47199 .41667 L
.52801 .41667 L
.52801 .36064 L
F
.52801 .36064 m
.52801 .41667 L
.58403 .41667 L
.58403 .36064 L
F
.58403 .36064 m
.58403 .41667 L
.64006 .41667 L
.64006 .36064 L
F
.64006 .36064 m
.64006 .41667 L
.69608 .41667 L
.69608 .36064 L
F
.69608 .36064 m
.69608 .41667 L
.7521 .41667 L
.7521 .36064 L
F
.7521 .36064 m
.7521 .41667 L
.80812 .41667 L
.80812 .36064 L
F
.80812 .36064 m
.80812 .41667 L
.86415 .41667 L
.86415 .36064 L
F
.86415 .36064 m
.86415 .41667 L
.92017 .41667 L
.92017 .36064 L
F
.92017 .36064 m
.92017 .41667 L
.97619 .41667 L
.97619 .36064 L
F
.07983 .30462 m
.07983 .36064 L
.13585 .36064 L
.13585 .30462 L
F
.13585 .30462 m
.13585 .36064 L
.19188 .36064 L
.19188 .30462 L
F
.19188 .30462 m
.19188 .36064 L
.2479 .36064 L
.2479 .30462 L
F
.2479 .30462 m
.2479 .36064 L
.30392 .36064 L
.30392 .30462 L
F
.30392 .30462 m
.30392 .36064 L
.35994 .36064 L
.35994 .30462 L
F
.35994 .30462 m
.35994 .36064 L
.41597 .36064 L
.41597 .30462 L
F
.41597 .30462 m
.41597 .36064 L
.47199 .36064 L
.47199 .30462 L
F
.47199 .30462 m
.47199 .36064 L
.52801 .36064 L
.52801 .30462 L
F
.52801 .30462 m
.52801 .36064 L
.58403 .36064 L
.58403 .30462 L
F
.58403 .30462 m
.58403 .36064 L
.64006 .36064 L
.64006 .30462 L
F
.64006 .30462 m
.64006 .36064 L
.69608 .36064 L
.69608 .30462 L
F
.69608 .30462 m
.69608 .36064 L
.7521 .36064 L
.7521 .30462 L
F
.7521 .30462 m
.7521 .36064 L
.80812 .36064 L
.80812 .30462 L
F
.80812 .30462 m
.80812 .36064 L
.86415 .36064 L
.86415 .30462 L
F
.86415 .30462 m
.86415 .36064 L
.92017 .36064 L
.92017 .30462 L
F
.92017 .30462 m
.92017 .36064 L
.97619 .36064 L
.97619 .30462 L
F
.07983 .2486 m
.07983 .30462 L
.13585 .30462 L
.13585 .2486 L
F
.13585 .2486 m
.13585 .30462 L
.19188 .30462 L
.19188 .2486 L
F
.19188 .2486 m
.19188 .30462 L
.2479 .30462 L
.2479 .2486 L
F
.2479 .2486 m
.2479 .30462 L
.30392 .30462 L
.30392 .2486 L
F
.30392 .2486 m
.30392 .30462 L
.35994 .30462 L
.35994 .2486 L
F
.35994 .2486 m
.35994 .30462 L
.41597 .30462 L
.41597 .2486 L
F
.41597 .2486 m
.41597 .30462 L
.47199 .30462 L
.47199 .2486 L
F
.47199 .2486 m
.47199 .30462 L
.52801 .30462 L
.52801 .2486 L
F
.52801 .2486 m
.52801 .30462 L
.58403 .30462 L
.58403 .2486 L
F
.58403 .2486 m
.58403 .30462 L
.64006 .30462 L
.64006 .2486 L
F
.64006 .2486 m
.64006 .30462 L
.69608 .30462 L
.69608 .2486 L
F
.69608 .2486 m
.69608 .30462 L
.7521 .30462 L
.7521 .2486 L
F
.7521 .2486 m
.7521 .30462 L
.80812 .30462 L
.80812 .2486 L
F
.80812 .2486 m
.80812 .30462 L
.86415 .30462 L
.86415 .2486 L
F
.86415 .2486 m
.86415 .30462 L
.92017 .30462 L
.92017 .2486 L
F
.92017 .2486 m
.92017 .30462 L
.97619 .30462 L
.97619 .2486 L
F
.07983 .19258 m
.07983 .2486 L
.13585 .2486 L
.13585 .19258 L
F
.13585 .19258 m
.13585 .2486 L
.19188 .2486 L
.19188 .19258 L
F
.19188 .19258 m
.19188 .2486 L
.2479 .2486 L
.2479 .19258 L
F
.2479 .19258 m
.2479 .2486 L
.30392 .2486 L
.30392 .19258 L
F
.30392 .19258 m
.30392 .2486 L
.35994 .2486 L
.35994 .19258 L
F
.35994 .19258 m
.35994 .2486 L
.41597 .2486 L
.41597 .19258 L
F
.41597 .19258 m
.41597 .2486 L
.47199 .2486 L
.47199 .19258 L
F
.47199 .19258 m
.47199 .2486 L
.52801 .2486 L
.52801 .19258 L
F
.52801 .19258 m
.52801 .2486 L
.58403 .2486 L
.58403 .19258 L
F
.58403 .19258 m
.58403 .2486 L
.64006 .2486 L
.64006 .19258 L
F
.64006 .19258 m
.64006 .2486 L
.69608 .2486 L
.69608 .19258 L
F
.69608 .19258 m
.69608 .2486 L
.7521 .2486 L
.7521 .19258 L
F
.7521 .19258 m
.7521 .2486 L
.80812 .2486 L
.80812 .19258 L
F
.80812 .19258 m
.80812 .2486 L
.86415 .2486 L
.86415 .19258 L
F
.86415 .19258 m
.86415 .2486 L
.92017 .2486 L
.92017 .19258 L
F
.92017 .19258 m
.92017 .2486 L
.97619 .2486 L
.97619 .19258 L
F
.07983 .13655 m
.07983 .19258 L
.13585 .19258 L
.13585 .13655 L
F
.13585 .13655 m
.13585 .19258 L
.19188 .19258 L
.19188 .13655 L
F
.19188 .13655 m
.19188 .19258 L
.2479 .19258 L
.2479 .13655 L
F
.2479 .13655 m
.2479 .19258 L
.30392 .19258 L
.30392 .13655 L
F
.30392 .13655 m
.30392 .19258 L
.35994 .19258 L
.35994 .13655 L
F
.35994 .13655 m
.35994 .19258 L
.41597 .19258 L
.41597 .13655 L
F
.41597 .13655 m
.41597 .19258 L
.47199 .19258 L
.47199 .13655 L
F
.47199 .13655 m
.47199 .19258 L
.52801 .19258 L
.52801 .13655 L
F
.52801 .13655 m
.52801 .19258 L
.58403 .19258 L
.58403 .13655 L
F
.58403 .13655 m
.58403 .19258 L
.64006 .19258 L
.64006 .13655 L
F
.64006 .13655 m
.64006 .19258 L
.69608 .19258 L
.69608 .13655 L
F
.69608 .13655 m
.69608 .19258 L
.7521 .19258 L
.7521 .13655 L
F
.7521 .13655 m
.7521 .19258 L
.80812 .19258 L
.80812 .13655 L
F
.80812 .13655 m
.80812 .19258 L
.86415 .19258 L
.86415 .13655 L
F
.86415 .13655 m
.86415 .19258 L
.92017 .19258 L
.92017 .13655 L
F
.92017 .13655 m
.92017 .19258 L
.97619 .19258 L
.97619 .13655 L
F
.07983 .08053 m
.07983 .13655 L
.13585 .13655 L
.13585 .08053 L
F
.13585 .08053 m
.13585 .13655 L
.19188 .13655 L
.19188 .08053 L
F
.19188 .08053 m
.19188 .13655 L
.2479 .13655 L
.2479 .08053 L
F
.2479 .08053 m
.2479 .13655 L
.30392 .13655 L
.30392 .08053 L
F
.30392 .08053 m
.30392 .13655 L
.35994 .13655 L
.35994 .08053 L
F
.35994 .08053 m
.35994 .13655 L
.41597 .13655 L
.41597 .08053 L
F
.41597 .08053 m
.41597 .13655 L
.47199 .13655 L
.47199 .08053 L
F
.47199 .08053 m
.47199 .13655 L
.52801 .13655 L
.52801 .08053 L
F
.52801 .08053 m
.52801 .13655 L
.58403 .13655 L
.58403 .08053 L
F
.58403 .08053 m
.58403 .13655 L
.64006 .13655 L
.64006 .08053 L
F
.64006 .08053 m
.64006 .13655 L
.69608 .13655 L
.69608 .08053 L
F
.69608 .08053 m
.69608 .13655 L
.7521 .13655 L
.7521 .08053 L
F
.7521 .08053 m
.7521 .13655 L
.80812 .13655 L
.80812 .08053 L
F
.80812 .08053 m
.80812 .13655 L
.86415 .13655 L
.86415 .08053 L
F
.86415 .08053 m
.86415 .13655 L
.92017 .13655 L
.92017 .08053 L
F
.92017 .08053 m
.92017 .13655 L
.97619 .13655 L
.97619 .08053 L
F
.07983 .02451 m
.07983 .08053 L
.13585 .08053 L
.13585 .02451 L
F
.13585 .02451 m
.13585 .08053 L
.19188 .08053 L
.19188 .02451 L
F
.19188 .02451 m
.19188 .08053 L
.2479 .08053 L
.2479 .02451 L
F
.2479 .02451 m
.2479 .08053 L
.30392 .08053 L
.30392 .02451 L
F
.30392 .02451 m
.30392 .08053 L
.35994 .08053 L
.35994 .02451 L
F
.35994 .02451 m
.35994 .08053 L
.41597 .08053 L
.41597 .02451 L
F
.41597 .02451 m
.41597 .08053 L
.47199 .08053 L
.47199 .02451 L
F
.47199 .02451 m
.47199 .08053 L
.52801 .08053 L
.52801 .02451 L
F
.52801 .02451 m
.52801 .08053 L
.58403 .08053 L
.58403 .02451 L
F
.58403 .02451 m
.58403 .08053 L
.64006 .08053 L
.64006 .02451 L
F
.64006 .02451 m
.64006 .08053 L
.69608 .08053 L
.69608 .02451 L
F
.69608 .02451 m
.69608 .08053 L
.7521 .08053 L
.7521 .02451 L
F
.7521 .02451 m
.7521 .08053 L
.80812 .08053 L
.80812 .02451 L
F
.80812 .02451 m
.80812 .08053 L
.86415 .08053 L
.86415 .02451 L
F
.86415 .02451 m
.86415 .08053 L
.92017 .08053 L
.92017 .02451 L
F
.92017 .02451 m
.92017 .08053 L
.97619 .08053 L
.97619 .02451 L
F
1 1 0 r
3 Mabswid
[ ] 0 setdash
.07983 .92087 m
.97619 .02451 L
s
.07983 .80882 m
.19188 .92087 L
s
.07983 .7528 m
.2479 .92087 L
s
.07983 .69678 m
.30392 .92087 L
s
.07983 .64076 m
.35994 .92087 L
s
.07983 .58473 m
.41597 .92087 L
s
.07983 .52871 m
.47199 .92087 L
s
.07983 .47269 m
.52801 .92087 L
s
.07983 .41667 m
.58403 .92087 L
s
.07983 .36064 m
.64006 .92087 L
s
.07983 .30462 m
.69608 .92087 L
s
.07983 .2486 m
.7521 .92087 L
s
.07983 .19258 m
.80812 .92087 L
s
.07983 .13655 m
.86415 .92087 L
s
.07983 .08053 m
.92017 .92087 L
s
.07983 .02451 m
.97619 .92087 L
s
.13585 .02451 m
.97619 .86485 L
s
.19188 .02451 m
.97619 .80882 L
s
.2479 .02451 m
.97619 .7528 L
s
.30392 .02451 m
.97619 .69678 L
s
.35994 .02451 m
.97619 .64076 L
s
.41597 .02451 m
.97619 .58473 L
s
.47199 .02451 m
.97619 .52871 L
s
.52801 .02451 m
.97619 .47269 L
s
.58403 .02451 m
.97619 .41667 L
s
.64006 .02451 m
.97619 .36064 L
s
.69608 .02451 m
.97619 .30462 L
s
.7521 .02451 m
.97619 .2486 L
s
.80812 .02451 m
.97619 .19258 L
s
.86415 .02451 m
.97619 .13655 L
s
1 0 0 r
.19188 .80882 m
.19188 .86485 L
.2479 .86485 L
.2479 .80882 L
F
.2479 .80882 m
.2479 .86485 L
.30392 .86485 L
.30392 .80882 L
F
.30392 .80882 m
.30392 .86485 L
.35994 .86485 L
.35994 .80882 L
F
.35994 .80882 m
.35994 .86485 L
.41597 .86485 L
.41597 .80882 L
F
.41597 .80882 m
.41597 .86485 L
.47199 .86485 L
.47199 .80882 L
F
.47199 .80882 m
.47199 .86485 L
.52801 .86485 L
.52801 .80882 L
F
.64006 .80882 m
.64006 .86485 L
.69608 .86485 L
.69608 .80882 L
F
.69608 .80882 m
.69608 .86485 L
.7521 .86485 L
.7521 .80882 L
F
.7521 .80882 m
.7521 .86485 L
.80812 .86485 L
.80812 .80882 L
F
.80812 .80882 m
.80812 .86485 L
.86415 .86485 L
.86415 .80882 L
F
.86415 .80882 m
.86415 .86485 L
.92017 .86485 L
.92017 .80882 L
F
.92017 .80882 m
.92017 .86485 L
.97619 .86485 L
.97619 .80882 L
F
.13585 .7528 m
.13585 .80882 L
.19188 .80882 L
.19188 .7528 L
F
.2479 .7528 m
.2479 .80882 L
.30392 .80882 L
.30392 .7528 L
F
.30392 .7528 m
.30392 .80882 L
.35994 .80882 L
.35994 .7528 L
F
.35994 .7528 m
.35994 .80882 L
.41597 .80882 L
.41597 .7528 L
F
.41597 .7528 m
.41597 .80882 L
.47199 .80882 L
.47199 .7528 L
F
.47199 .7528 m
.47199 .80882 L
.52801 .80882 L
.52801 .7528 L
F
.52801 .7528 m
.52801 .80882 L
.58403 .80882 L
.58403 .7528 L
F
.64006 .7528 m
.64006 .80882 L
.69608 .80882 L
.69608 .7528 L
F
.7521 .7528 m
.7521 .80882 L
.80812 .80882 L
.80812 .7528 L
F
.80812 .7528 m
.80812 .80882 L
.86415 .80882 L
.86415 .7528 L
F
.86415 .7528 m
.86415 .80882 L
.92017 .80882 L
.92017 .7528 L
F
.92017 .7528 m
.92017 .80882 L
.97619 .80882 L
.97619 .7528 L
F
.13585 .69678 m
.13585 .7528 L
.19188 .7528 L
.19188 .69678 L
F
.19188 .69678 m
.19188 .7528 L
.2479 .7528 L
.2479 .69678 L
F
.30392 .69678 m
.30392 .7528 L
.35994 .7528 L
.35994 .69678 L
F
.35994 .69678 m
.35994 .7528 L
.41597 .7528 L
.41597 .69678 L
F
.41597 .69678 m
.41597 .7528 L
.47199 .7528 L
.47199 .69678 L
F
.47199 .69678 m
.47199 .7528 L
.52801 .7528 L
.52801 .69678 L
F
.52801 .69678 m
.52801 .7528 L
.58403 .7528 L
.58403 .69678 L
F
.69608 .69678 m
.69608 .7528 L
.7521 .7528 L
.7521 .69678 L
F
.7521 .69678 m
.7521 .7528 L
.80812 .7528 L
.80812 .69678 L
F
.80812 .69678 m
.80812 .7528 L
.86415 .7528 L
.86415 .69678 L
F
.86415 .69678 m
.86415 .7528 L
.92017 .7528 L
.92017 .69678 L
F
.92017 .69678 m
.92017 .7528 L
.97619 .7528 L
.97619 .69678 L
F
.13585 .64076 m
.13585 .69678 L
.19188 .69678 L
.19188 .64076 L
F
.19188 .64076 m
.19188 .69678 L
.2479 .69678 L
.2479 .64076 L
F
.2479 .64076 m
.2479 .69678 L
.30392 .69678 L
.30392 .64076 L
F
.35994 .64076 m
.35994 .69678 L
.41597 .69678 L
.41597 .64076 L
F
.41597 .64076 m
.41597 .69678 L
.47199 .69678 L
.47199 .64076 L
F
.47199 .64076 m
.47199 .69678 L
.52801 .69678 L
.52801 .64076 L
F
.52801 .64076 m
.52801 .69678 L
.58403 .69678 L
.58403 .64076 L
F
.64006 .64076 m
.64006 .69678 L
.69608 .69678 L
.69608 .64076 L
F
.69608 .64076 m
.69608 .69678 L
.7521 .69678 L
.7521 .64076 L
F
.7521 .64076 m
.7521 .69678 L
.80812 .69678 L
.80812 .64076 L
F
.86415 .64076 m
.86415 .69678 L
.92017 .69678 L
.92017 .64076 L
F
.92017 .64076 m
.92017 .69678 L
.97619 .69678 L
.97619 .64076 L
F
.13585 .58473 m
.13585 .64076 L
.19188 .64076 L
.19188 .58473 L
F
.19188 .58473 m
.19188 .64076 L
.2479 .64076 L
.2479 .58473 L
F
.2479 .58473 m
.2479 .64076 L
.30392 .64076 L
.30392 .58473 L
F
.30392 .58473 m
.30392 .64076 L
.35994 .64076 L
.35994 .58473 L
F
.41597 .58473 m
.41597 .64076 L
.47199 .64076 L
.47199 .58473 L
F
.47199 .58473 m
.47199 .64076 L
.52801 .64076 L
.52801 .58473 L
F
.52801 .58473 m
.52801 .64076 L
.58403 .64076 L
.58403 .58473 L
F
.64006 .58473 m
.64006 .64076 L
.69608 .64076 L
.69608 .58473 L
F
.69608 .58473 m
.69608 .64076 L
.7521 .64076 L
.7521 .58473 L
F
.80812 .58473 m
.80812 .64076 L
.86415 .64076 L
.86415 .58473 L
F
.86415 .58473 m
.86415 .64076 L
.92017 .64076 L
.92017 .58473 L
F
.92017 .58473 m
.92017 .64076 L
.97619 .64076 L
.97619 .58473 L
F
.13585 .52871 m
.13585 .58473 L
.19188 .58473 L
.19188 .52871 L
F
.19188 .52871 m
.19188 .58473 L
.2479 .58473 L
.2479 .52871 L
F
.2479 .52871 m
.2479 .58473 L
.30392 .58473 L
.30392 .52871 L
F
.30392 .52871 m
.30392 .58473 L
.35994 .58473 L
.35994 .52871 L
F
.35994 .52871 m
.35994 .58473 L
.41597 .58473 L
.41597 .52871 L
F
.47199 .52871 m
.47199 .58473 L
.52801 .58473 L
.52801 .52871 L
F
.52801 .52871 m
.52801 .58473 L
.58403 .58473 L
.58403 .52871 L
F
.64006 .52871 m
.64006 .58473 L
.69608 .58473 L
.69608 .52871 L
F
.69608 .52871 m
.69608 .58473 L
.7521 .58473 L
.7521 .52871 L
F
.7521 .52871 m
.7521 .58473 L
.80812 .58473 L
.80812 .52871 L
F
.80812 .52871 m
.80812 .58473 L
.86415 .58473 L
.86415 .52871 L
F
.86415 .52871 m
.86415 .58473 L
.92017 .58473 L
.92017 .52871 L
F
.13585 .47269 m
.13585 .52871 L
.19188 .52871 L
.19188 .47269 L
F
.19188 .47269 m
.19188 .52871 L
.2479 .52871 L
.2479 .47269 L
F
.2479 .47269 m
.2479 .52871 L
.30392 .52871 L
.30392 .47269 L
F
.30392 .47269 m
.30392 .52871 L
.35994 .52871 L
.35994 .47269 L
F
.35994 .47269 m
.35994 .52871 L
.41597 .52871 L
.41597 .47269 L
F
.41597 .47269 m
.41597 .52871 L
.47199 .52871 L
.47199 .47269 L
F
.52801 .47269 m
.52801 .52871 L
.58403 .52871 L
.58403 .47269 L
F
.64006 .47269 m
.64006 .52871 L
.69608 .52871 L
.69608 .47269 L
F
.69608 .47269 m
.69608 .52871 L
.7521 .52871 L
.7521 .47269 L
F
.7521 .47269 m
.7521 .52871 L
.80812 .52871 L
.80812 .47269 L
F
.80812 .47269 m
.80812 .52871 L
.86415 .52871 L
.86415 .47269 L
F
.92017 .47269 m
.92017 .52871 L
.97619 .52871 L
.97619 .47269 L
F
.19188 .41667 m
.19188 .47269 L
.2479 .47269 L
.2479 .41667 L
F
.2479 .41667 m
.2479 .47269 L
.30392 .47269 L
.30392 .41667 L
F
.30392 .41667 m
.30392 .47269 L
.35994 .47269 L
.35994 .41667 L
F
.35994 .41667 m
.35994 .47269 L
.41597 .47269 L
.41597 .41667 L
F
.41597 .41667 m
.41597 .47269 L
.47199 .47269 L
.47199 .41667 L
F
.47199 .41667 m
.47199 .47269 L
.52801 .47269 L
.52801 .41667 L
F
.64006 .41667 m
.64006 .47269 L
.69608 .47269 L
.69608 .41667 L
F
.69608 .41667 m
.69608 .47269 L
.7521 .47269 L
.7521 .41667 L
F
.7521 .41667 m
.7521 .47269 L
.80812 .47269 L
.80812 .41667 L
F
.80812 .41667 m
.80812 .47269 L
.86415 .47269 L
.86415 .41667 L
F
.86415 .41667 m
.86415 .47269 L
.92017 .47269 L
.92017 .41667 L
F
.92017 .41667 m
.92017 .47269 L
.97619 .47269 L
.97619 .41667 L
F
.13585 .30462 m
.13585 .36064 L
.19188 .36064 L
.19188 .30462 L
F
.19188 .30462 m
.19188 .36064 L
.2479 .36064 L
.2479 .30462 L
F
.30392 .30462 m
.30392 .36064 L
.35994 .36064 L
.35994 .30462 L
F
.35994 .30462 m
.35994 .36064 L
.41597 .36064 L
.41597 .30462 L
F
.41597 .30462 m
.41597 .36064 L
.47199 .36064 L
.47199 .30462 L
F
.47199 .30462 m
.47199 .36064 L
.52801 .36064 L
.52801 .30462 L
F
.52801 .30462 m
.52801 .36064 L
.58403 .36064 L
.58403 .30462 L
F
.69608 .30462 m
.69608 .36064 L
.7521 .36064 L
.7521 .30462 L
F
.7521 .30462 m
.7521 .36064 L
.80812 .36064 L
.80812 .30462 L
F
.80812 .30462 m
.80812 .36064 L
.86415 .36064 L
.86415 .30462 L
F
.86415 .30462 m
.86415 .36064 L
.92017 .36064 L
.92017 .30462 L
F
.92017 .30462 m
.92017 .36064 L
.97619 .36064 L
.97619 .30462 L
F
.13585 .2486 m
.13585 .30462 L
.19188 .30462 L
.19188 .2486 L
F
.2479 .2486 m
.2479 .30462 L
.30392 .30462 L
.30392 .2486 L
F
.30392 .2486 m
.30392 .30462 L
.35994 .30462 L
.35994 .2486 L
F
.35994 .2486 m
.35994 .30462 L
.41597 .30462 L
.41597 .2486 L
F
.41597 .2486 m
.41597 .30462 L
.47199 .30462 L
.47199 .2486 L
F
.47199 .2486 m
.47199 .30462 L
.52801 .30462 L
.52801 .2486 L
F
.52801 .2486 m
.52801 .30462 L
.58403 .30462 L
.58403 .2486 L
F
.64006 .2486 m
.64006 .30462 L
.69608 .30462 L
.69608 .2486 L
F
.7521 .2486 m
.7521 .30462 L
.80812 .30462 L
.80812 .2486 L
F
.80812 .2486 m
.80812 .30462 L
.86415 .30462 L
.86415 .2486 L
F
.86415 .2486 m
.86415 .30462 L
.92017 .30462 L
.92017 .2486 L
F
.92017 .2486 m
.92017 .30462 L
.97619 .30462 L
.97619 .2486 L
F
.13585 .19258 m
.13585 .2486 L
.19188 .2486 L
.19188 .19258 L
F
.19188 .19258 m
.19188 .2486 L
.2479 .2486 L
.2479 .19258 L
F
.2479 .19258 m
.2479 .2486 L
.30392 .2486 L
.30392 .19258 L
F
.30392 .19258 m
.30392 .2486 L
.35994 .2486 L
.35994 .19258 L
F
.41597 .19258 m
.41597 .2486 L
.47199 .2486 L
.47199 .19258 L
F
.47199 .19258 m
.47199 .2486 L
.52801 .2486 L
.52801 .19258 L
F
.52801 .19258 m
.52801 .2486 L
.58403 .2486 L
.58403 .19258 L
F
.64006 .19258 m
.64006 .2486 L
.69608 .2486 L
.69608 .19258 L
F
.69608 .19258 m
.69608 .2486 L
.7521 .2486 L
.7521 .19258 L
F
.80812 .19258 m
.80812 .2486 L
.86415 .2486 L
.86415 .19258 L
F
.86415 .19258 m
.86415 .2486 L
.92017 .2486 L
.92017 .19258 L
F
.92017 .19258 m
.92017 .2486 L
.97619 .2486 L
.97619 .19258 L
F
.13585 .13655 m
.13585 .19258 L
.19188 .19258 L
.19188 .13655 L
F
.19188 .13655 m
.19188 .19258 L
.2479 .19258 L
.2479 .13655 L
F
.2479 .13655 m
.2479 .19258 L
.30392 .19258 L
.30392 .13655 L
F
.35994 .13655 m
.35994 .19258 L
.41597 .19258 L
.41597 .13655 L
F
.41597 .13655 m
.41597 .19258 L
.47199 .19258 L
.47199 .13655 L
F
.47199 .13655 m
.47199 .19258 L
.52801 .19258 L
.52801 .13655 L
F
.52801 .13655 m
.52801 .19258 L
.58403 .19258 L
.58403 .13655 L
F
.64006 .13655 m
.64006 .19258 L
.69608 .19258 L
.69608 .13655 L
F
.69608 .13655 m
.69608 .19258 L
.7521 .19258 L
.7521 .13655 L
F
.7521 .13655 m
.7521 .19258 L
.80812 .19258 L
.80812 .13655 L
F
.86415 .13655 m
.86415 .19258 L
.92017 .19258 L
.92017 .13655 L
F
.92017 .13655 m
.92017 .19258 L
.97619 .19258 L
.97619 .13655 L
F
.13585 .08053 m
.13585 .13655 L
.19188 .13655 L
.19188 .08053 L
F
.19188 .08053 m
.19188 .13655 L
.2479 .13655 L
.2479 .08053 L
F
.2479 .08053 m
.2479 .13655 L
.30392 .13655 L
.30392 .08053 L
F
.30392 .08053 m
.30392 .13655 L
.35994 .13655 L
.35994 .08053 L
F
.35994 .08053 m
.35994 .13655 L
.41597 .13655 L
.41597 .08053 L
F
.41597 .08053 m
.41597 .13655 L
.47199 .13655 L
.47199 .08053 L
F
.52801 .08053 m
.52801 .13655 L
.58403 .13655 L
.58403 .08053 L
F
.64006 .08053 m
.64006 .13655 L
.69608 .13655 L
.69608 .08053 L
F
.69608 .08053 m
.69608 .13655 L
.7521 .13655 L
.7521 .08053 L
F
.7521 .08053 m
.7521 .13655 L
.80812 .13655 L
.80812 .08053 L
F
.80812 .08053 m
.80812 .13655 L
.86415 .13655 L
.86415 .08053 L
F
.92017 .08053 m
.92017 .13655 L
.97619 .13655 L
.97619 .08053 L
F
.13585 .02451 m
.13585 .08053 L
.19188 .08053 L
.19188 .02451 L
F
.19188 .02451 m
.19188 .08053 L
.2479 .08053 L
.2479 .02451 L
F
.2479 .02451 m
.2479 .08053 L
.30392 .08053 L
.30392 .02451 L
F
.30392 .02451 m
.30392 .08053 L
.35994 .08053 L
.35994 .02451 L
F
.35994 .02451 m
.35994 .08053 L
.41597 .08053 L
.41597 .02451 L
F
.47199 .02451 m
.47199 .08053 L
.52801 .08053 L
.52801 .02451 L
F
.52801 .02451 m
.52801 .08053 L
.58403 .08053 L
.58403 .02451 L
F
.64006 .02451 m
.64006 .08053 L
.69608 .08053 L
.69608 .02451 L
F
.69608 .02451 m
.69608 .08053 L
.7521 .08053 L
.7521 .02451 L
F
.7521 .02451 m
.7521 .08053 L
.80812 .08053 L
.80812 .02451 L
F
.80812 .02451 m
.80812 .08053 L
.86415 .08053 L
.86415 .02451 L
F
.86415 .02451 m
.86415 .08053 L
.92017 .08053 L
.92017 .02451 L
F
0 g
[(g1)] .10784 .89286 0 0 Mshowa
[(g1)] .16387 .89286 0 0 Mshowa
[(g1)] .21989 .89286 0 0 Mshowa
[(g1)] .27591 .89286 0 0 Mshowa
[(g1)] .33193 .89286 0 0 Mshowa
[(g1)] .38796 .89286 0 0 Mshowa
[(g1)] .44398 .89286 0 0 Mshowa
[(g1)] .5 .89286 0 0 Mshowa
[(g1)] .55602 .89286 0 0 Mshowa
[(g1)] .61204 .89286 0 0 Mshowa
[(g1)] .66807 .89286 0 0 Mshowa
[(g1)] .72409 .89286 0 0 Mshowa
[(g1)] .78011 .89286 0 0 Mshowa
[(g1)] .83613 .89286 0 0 Mshowa
[(g1)] .89216 .89286 0 0 Mshowa
[(g1)] .94818 .89286 0 0 Mshowa
[(g1)] .10784 .83683 0 0 Mshowa
[(g2)] .16387 .83683 0 0 Mshowa
[(g3)] .21989 .83683 0 0 Mshowa
[(g4)] .27591 .83683 0 0 Mshowa
[(g1)] .33193 .83683 0 0 Mshowa
[(g2)] .38796 .83683 0 0 Mshowa
[(g3)] .44398 .83683 0 0 Mshowa
[(g4)] .5 .83683 0 0 Mshowa
[(g1)] .55602 .83683 0 0 Mshowa
[(g2)] .61204 .83683 0 0 Mshowa
[(g3)] .66807 .83683 0 0 Mshowa
[(g4)] .72409 .83683 0 0 Mshowa
[(g1)] .78011 .83683 0 0 Mshowa
[(g2)] .83613 .83683 0 0 Mshowa
[(g3)] .89216 .83683 0 0 Mshowa
[(g4)] .94818 .83683 0 0 Mshowa
[(g1)] .10784 .78081 0 0 Mshowa
[(g1)] .16387 .78081 0 0 Mshowa
[(g1)] .21989 .78081 0 0 Mshowa
[(g1)] .27591 .78081 0 0 Mshowa
[(g2)] .33193 .78081 0 0 Mshowa
[(g2)] .38796 .78081 0 0 Mshowa
[(g2)] .44398 .78081 0 0 Mshowa
[(g2)] .5 .78081 0 0 Mshowa
[(g3)] .55602 .78081 0 0 Mshowa
[(g3)] .61204 .78081 0 0 Mshowa
[(g3)] .66807 .78081 0 0 Mshowa
[(g3)] .72409 .78081 0 0 Mshowa
[(g4)] .78011 .78081 0 0 Mshowa
[(g4)] .83613 .78081 0 0 Mshowa
[(g4)] .89216 .78081 0 0 Mshowa
[(g4)] .94818 .78081 0 0 Mshowa
[(g1)] .10784 .72479 0 0 Mshowa
[(g2)] .16387 .72479 0 0 Mshowa
[(g3)] .21989 .72479 0 0 Mshowa
[(g4)] .27591 .72479 0 0 Mshowa
[(g2)] .33193 .72479 0 0 Mshowa
[(g1)] .38796 .72479 0 0 Mshowa
[(g4)] .44398 .72479 0 0 Mshowa
[(g3)] .5 .72479 0 0 Mshowa
[(g3)] .55602 .72479 0 0 Mshowa
[(g4)] .61204 .72479 0 0 Mshowa
[(g1)] .66807 .72479 0 0 Mshowa
[(g2)] .72409 .72479 0 0 Mshowa
[(g4)] .78011 .72479 0 0 Mshowa
[(g3)] .83613 .72479 0 0 Mshowa
[(g2)] .89216 .72479 0 0 Mshowa
[(g1)] .94818 .72479 0 0 Mshowa
[(g1)] .10784 .66877 0 0 Mshowa
[(g5)] .16387 .66877 0 0 Mshowa
[(g9)] .21989 .66877 0 0 Mshowa
[(g13)] .27591 .66877 0 0 Mshowa
[(g1)] .33193 .66877 0 0 Mshowa
[(g5)] .38796 .66877 0 0 Mshowa
[(g9)] .44398 .66877 0 0 Mshowa
[(g13)] .5 .66877 0 0 Mshowa
[(g1)] .55602 .66877 0 0 Mshowa
[(g5)] .61204 .66877 0 0 Mshowa
[(g9)] .66807 .66877 0 0 Mshowa
[(g13)] .72409 .66877 0 0 Mshowa
[(g1)] .78011 .66877 0 0 Mshowa
[(g5)] .83613 .66877 0 0 Mshowa
[(g9)] .89216 .66877 0 0 Mshowa
[(g13)] .94818 .66877 0 0 Mshowa
[(g1)] .10784 .61275 0 0 Mshowa
[(g6)] .16387 .61275 0 0 Mshowa
[(g11)] .21989 .61275 0 0 Mshowa
[(g16)] .27591 .61275 0 0 Mshowa
[(g1)] .33193 .61275 0 0 Mshowa
[(g6)] .38796 .61275 0 0 Mshowa
[(g11)] .44398 .61275 0 0 Mshowa
[(g16)] .5 .61275 0 0 Mshowa
[(g1)] .55602 .61275 0 0 Mshowa
[(g6)] .61204 .61275 0 0 Mshowa
[(g11)] .66807 .61275 0 0 Mshowa
[(g16)] .72409 .61275 0 0 Mshowa
[(g1)] .78011 .61275 0 0 Mshowa
[(g6)] .83613 .61275 0 0 Mshowa
[(g11)] .89216 .61275 0 0 Mshowa
[(g16)] .94818 .61275 0 0 Mshowa
[(g1)] .10784 .55672 0 0 Mshowa
[(g5)] .16387 .55672 0 0 Mshowa
[(g9)] .21989 .55672 0 0 Mshowa
[(g13)] .27591 .55672 0 0 Mshowa
[(g2)] .33193 .55672 0 0 Mshowa
[(g6)] .38796 .55672 0 0 Mshowa
[(g10)] .44398 .55672 0 0 Mshowa
[(g14)] .5 .55672 0 0 Mshowa
[(g3)] .55602 .55672 0 0 Mshowa
[(g7)] .61204 .55672 0 0 Mshowa
[(g11)] .66807 .55672 0 0 Mshowa
[(g15)] .72409 .55672 0 0 Mshowa
[(g4)] .78011 .55672 0 0 Mshowa
[(g8)] .83613 .55672 0 0 Mshowa
[(g12)] .89216 .55672 0 0 Mshowa
[(g16)] .94818 .55672 0 0 Mshowa
[(g1)] .10784 .5007 0 0 Mshowa
[(g6)] .16387 .5007 0 0 Mshowa
[(g11)] .21989 .5007 0 0 Mshowa
[(g16)] .27591 .5007 0 0 Mshowa
[(g2)] .33193 .5007 0 0 Mshowa
[(g5)] .38796 .5007 0 0 Mshowa
[(g12)] .44398 .5007 0 0 Mshowa
[(g15)] .5 .5007 0 0 Mshowa
[(g3)] .55602 .5007 0 0 Mshowa
[(g8)] .61204 .5007 0 0 Mshowa
[(g9)] .66807 .5007 0 0 Mshowa
[(g14)] .72409 .5007 0 0 Mshowa
[(g4)] .78011 .5007 0 0 Mshowa
[(g7)] .83613 .5007 0 0 Mshowa
[(g10)] .89216 .5007 0 0 Mshowa
[(g13)] .94818 .5007 0 0 Mshowa
[(g1)] .10784 .44468 0 0 Mshowa
[(g1)] .16387 .44468 0 0 Mshowa
[(g1)] .21989 .44468 0 0 Mshowa
[(g1)] .27591 .44468 0 0 Mshowa
[(g5)] .33193 .44468 0 0 Mshowa
[(g5)] .38796 .44468 0 0 Mshowa
[(g5)] .44398 .44468 0 0 Mshowa
[(g5)] .5 .44468 0 0 Mshowa
[(g9)] .55602 .44468 0 0 Mshowa
[(g9)] .61204 .44468 0 0 Mshowa
[(g9)] .66807 .44468 0 0 Mshowa
[(g9)] .72409 .44468 0 0 Mshowa
[(g13)] .78011 .44468 0 0 Mshowa
[(g13)] .83613 .44468 0 0 Mshowa
[(g13)] .89216 .44468 0 0 Mshowa
[(g13)] .94818 .44468 0 0 Mshowa
[(g1)] .10784 .38866 0 0 Mshowa
[(g2)] .16387 .38866 0 0 Mshowa
[(g3)] .21989 .38866 0 0 Mshowa
[(g4)] .27591 .38866 0 0 Mshowa
[(g5)] .33193 .38866 0 0 Mshowa
[(g6)] .38796 .38866 0 0 Mshowa
[(g7)] .44398 .38866 0 0 Mshowa
[(g8)] .5 .38866 0 0 Mshowa
[(g9)] .55602 .38866 0 0 Mshowa
[(g10)] .61204 .38866 0 0 Mshowa
[(g11)] .66807 .38866 0 0 Mshowa
[(g12)] .72409 .38866 0 0 Mshowa
[(g13)] .78011 .38866 0 0 Mshowa
[(g14)] .83613 .38866 0 0 Mshowa
[(g15)] .89216 .38866 0 0 Mshowa
[(g16)] .94818 .38866 0 0 Mshowa
[(g1)] .10784 .33263 0 0 Mshowa
[(g1)] .16387 .33263 0 0 Mshowa
[(g1)] .21989 .33263 0 0 Mshowa
[(g1)] .27591 .33263 0 0 Mshowa
[(g6)] .33193 .33263 0 0 Mshowa
[(g6)] .38796 .33263 0 0 Mshowa
[(g6)] .44398 .33263 0 0 Mshowa
[(g6)] .5 .33263 0 0 Mshowa
[(g11)] .55602 .33263 0 0 Mshowa
[(g11)] .61204 .33263 0 0 Mshowa
[(g11)] .66807 .33263 0 0 Mshowa
[(g11)] .72409 .33263 0 0 Mshowa
[(g16)] .78011 .33263 0 0 Mshowa
[(g16)] .83613 .33263 0 0 Mshowa
[(g16)] .89216 .33263 0 0 Mshowa
[(g16)] .94818 .33263 0 0 Mshowa
[(g1)] .10784 .27661 0 0 Mshowa
[(g2)] .16387 .27661 0 0 Mshowa
[(g3)] .21989 .27661 0 0 Mshowa
[(g4)] .27591 .27661 0 0 Mshowa
[(g6)] .33193 .27661 0 0 Mshowa
[(g5)] .38796 .27661 0 0 Mshowa
[(g8)] .44398 .27661 0 0 Mshowa
[(g7)] .5 .27661 0 0 Mshowa
[(g11)] .55602 .27661 0 0 Mshowa
[(g12)] .61204 .27661 0 0 Mshowa
[(g9)] .66807 .27661 0 0 Mshowa
[(g10)] .72409 .27661 0 0 Mshowa
[(g16)] .78011 .27661 0 0 Mshowa
[(g15)] .83613 .27661 0 0 Mshowa
[(g14)] .89216 .27661 0 0 Mshowa
[(g13)] .94818 .27661 0 0 Mshowa
[(g1)] .10784 .22059 0 0 Mshowa
[(g5)] .16387 .22059 0 0 Mshowa
[(g9)] .21989 .22059 0 0 Mshowa
[(g13)] .27591 .22059 0 0 Mshowa
[(g5)] .33193 .22059 0 0 Mshowa
[(g1)] .38796 .22059 0 0 Mshowa
[(g13)] .44398 .22059 0 0 Mshowa
[(g9)] .5 .22059 0 0 Mshowa
[(g9)] .55602 .22059 0 0 Mshowa
[(g13)] .61204 .22059 0 0 Mshowa
[(g1)] .66807 .22059 0 0 Mshowa
[(g5)] .72409 .22059 0 0 Mshowa
[(g13)] .78011 .22059 0 0 Mshowa
[(g9)] .83613 .22059 0 0 Mshowa
[(g5)] .89216 .22059 0 0 Mshowa
[(g1)] .94818 .22059 0 0 Mshowa
[(g1)] .10784 .16457 0 0 Mshowa
[(g6)] .16387 .16457 0 0 Mshowa
[(g11)] .21989 .16457 0 0 Mshowa
[(g16)] .27591 .16457 0 0 Mshowa
[(g5)] .33193 .16457 0 0 Mshowa
[(g2)] .38796 .16457 0 0 Mshowa
[(g15)] .44398 .16457 0 0 Mshowa
[(g12)] .5 .16457 0 0 Mshowa
[(g9)] .55602 .16457 0 0 Mshowa
[(g14)] .61204 .16457 0 0 Mshowa
[(g3)] .66807 .16457 0 0 Mshowa
[(g8)] .72409 .16457 0 0 Mshowa
[(g13)] .78011 .16457 0 0 Mshowa
[(g10)] .83613 .16457 0 0 Mshowa
[(g7)] .89216 .16457 0 0 Mshowa
[(g4)] .94818 .16457 0 0 Mshowa
[(g1)] .10784 .10854 0 0 Mshowa
[(g5)] .16387 .10854 0 0 Mshowa
[(g9)] .21989 .10854 0 0 Mshowa
[(g13)] .27591 .10854 0 0 Mshowa
[(g6)] .33193 .10854 0 0 Mshowa
[(g2)] .38796 .10854 0 0 Mshowa
[(g14)] .44398 .10854 0 0 Mshowa
[(g10)] .5 .10854 0 0 Mshowa
[(g11)] .55602 .10854 0 0 Mshowa
[(g15)] .61204 .10854 0 0 Mshowa
[(g3)] .66807 .10854 0 0 Mshowa
[(g7)] .72409 .10854 0 0 Mshowa
[(g16)] .78011 .10854 0 0 Mshowa
[(g12)] .83613 .10854 0 0 Mshowa
[(g8)] .89216 .10854 0 0 Mshowa
[(g4)] .94818 .10854 0 0 Mshowa
[(g1)] .10784 .05252 0 0 Mshowa
[(g6)] .16387 .05252 0 0 Mshowa
[(g11)] .21989 .05252 0 0 Mshowa
[(g16)] .27591 .05252 0 0 Mshowa
[(g6)] .33193 .05252 0 0 Mshowa
[(g1)] .38796 .05252 0 0 Mshowa
[(g16)] .44398 .05252 0 0 Mshowa
[(g11)] .5 .05252 0 0 Mshowa
[(g11)] .55602 .05252 0 0 Mshowa
[(g16)] .61204 .05252 0 0 Mshowa
[(g1)] .66807 .05252 0 0 Mshowa
[(g6)] .72409 .05252 0 0 Mshowa
[(g16)] .78011 .05252 0 0 Mshowa
[(g11)] .83613 .05252 0 0 Mshowa
[(g6)] .89216 .05252 0 0 Mshowa
[(g1)] .94818 .05252 0 0 Mshowa
[(g1)] .05182 .89286 0 0 Mshowa
[(g2)] .05182 .83683 0 0 Mshowa
[(g3)] .05182 .78081 0 0 Mshowa
[(g4)] .05182 .72479 0 0 Mshowa
[(g5)] .05182 .66877 0 0 Mshowa
[(g6)] .05182 .61275 0 0 Mshowa
[(g7)] .05182 .55672 0 0 Mshowa
[(g8)] .05182 .5007 0 0 Mshowa
[(g9)] .05182 .44468 0 0 Mshowa
[(g10)] .05182 .38866 0 0 Mshowa
[(g11)] .05182 .33263 0 0 Mshowa
[(g12)] .05182 .27661 0 0 Mshowa
[(g13)] .05182 .22059 0 0 Mshowa
[(g14)] .05182 .16457 0 0 Mshowa
[(g15)] .05182 .10854 0 0 Mshowa
[(g16)] .05182 .05252 0 0 Mshowa
[(g1)] .10784 .94888 0 0 Mshowa
[(g2)] .16387 .94888 0 0 Mshowa
[(g3)] .21989 .94888 0 0 Mshowa
[(g4)] .27591 .94888 0 0 Mshowa
[(g5)] .33193 .94888 0 0 Mshowa
[(g6)] .38796 .94888 0 0 Mshowa
[(g7)] .44398 .94888 0 0 Mshowa
[(g8)] .5 .94888 0 0 Mshowa
[(g9)] .55602 .94888 0 0 Mshowa
[(g10)] .61204 .94888 0 0 Mshowa
[(g11)] .66807 .94888 0 0 Mshowa
[(g12)] .72409 .94888 0 0 Mshowa
[(g13)] .78011 .94888 0 0 Mshowa
[(g14)] .83613 .94888 0 0 Mshowa
[(g15)] .89216 .94888 0 0 Mshowa
[(g16)] .94818 .94888 0 0 Mshowa
[(Mult\\(-Mat   \\(Z[2]\\)-\\))(         \\(2\\))] .02381 1.0049 -1 0 Mshowa
gsave
.97619 1.0049 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .04286 .93936 0 0 Mshowa
[(y)] .06583 .96008 0 0 Mshowa
1 Mabswid
.02381 .02451 m
.02381 .97689 L
s
.02381 .02451 m
.97619 .02451 L
s
.02381 .08053 m
.97619 .08053 L
s
.02381 .13655 m
.97619 .13655 L
s
.02381 .19258 m
.97619 .19258 L
s
.02381 .2486 m
.97619 .2486 L
s
.02381 .30462 m
.97619 .30462 L
s
.02381 .36064 m
.97619 .36064 L
s
.02381 .41667 m
.97619 .41667 L
s
.02381 .47269 m
.97619 .47269 L
s
.02381 .52871 m
.97619 .52871 L
s
.02381 .58473 m
.97619 .58473 L
s
.02381 .64076 m
.97619 .64076 L
s
.02381 .69678 m
.97619 .69678 L
s
.02381 .7528 m
.97619 .7528 L
s
.02381 .80882 m
.97619 .80882 L
s
.02381 .86485 m
.97619 .86485 L
s
.02381 .92087 m
.97619 .92087 L
s
.02381 .97689 m
.97619 .97689 L
s
.07983 .02451 m
.07983 .97689 L
s
.13585 .02451 m
.13585 .97689 L
s
.19188 .02451 m
.19188 .97689 L
s
.2479 .02451 m
.2479 .97689 L
s
.30392 .02451 m
.30392 .97689 L
s
.35994 .02451 m
.35994 .97689 L
s
.41597 .02451 m
.41597 .97689 L
s
.47199 .02451 m
.47199 .97689 L
s
.52801 .02451 m
.52801 .97689 L
s
.58403 .02451 m
.58403 .97689 L
s
.64006 .02451 m
.64006 .97689 L
s
.69608 .02451 m
.69608 .97689 L
s
.7521 .02451 m
.7521 .97689 L
s
.80812 .02451 m
.80812 .97689 L
s
.86415 .02451 m
.86415 .97689 L
s
.92017 .02451 m
.92017 .97689 L
s
.97619 .02451 m
.97619 .97689 L
s
.02381 .97689 m
.07983 .92087 L
s
2.6 Mabswid
.07983 .02451 m
.07983 .97689 L
s
.02381 .92087 m
.97619 .92087 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[43]:=",
  ImageSize->{279.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004G000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l060000?l060000?l060000?l060000?l0
60000?l0600001D00ml<00?O3@03g`d00ml<00?O3@03g``00ml=00?O3@03g``00ml=00?O3@03g``0
0ml=00?O3003gad00ml500001P3oo`co00?O00000`0000H000?o00003002o`?O2P000moo7`0>7`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00CogmoO2`000moo7`0>7`03oalO00`O00CogmoO
2`000moo7`0>7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o00002P03g`03oml000@0
00060003o`0000`00_l4g`X000?o7al03Al00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03
omoO00;O2`000olO7`0=7`03oalO00`O00?ogml00]l;0003oalO00dO00?o7al031l00olO7`0=7`03
oalO00`O00?o7al03Al00ol0000900CO00?o0000100000H000?o00003002o`GO2@000olO7`0=7`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?ogml00ml:0003oalO00dO00?o7al031l00ooO
g`03g`X000?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03o`0000P01Ml00ol0
000400001P04o`/00_l00`3Og`03o`P000Co7alO0ol97`Co31l3o``O00Co7alO0ol97`04oalO7`?o
21l4o`?O2@04o``O0ol<7`Co0ml90004oalO7`?o2Al00olO7`03o`TO1?l<7`Co2al01?lO7al3o`TO
00Co00000ol300GO00<0o`001@0000H000Go0000o`0:00;o0P04g`03o`0000D000?o7al011l00olO
7`067`05oalO7ol02al01?lO7ol;7`03oalO00@O00?o7al01Ql00olO7`047`03oalO00DO00Go003O
o`03g`P000Go7alOo`0;7`04oalOo`/O00Go003Oo`03g`P000?o7al011l00olO7`067`03oalO00<O
00?o7al01Ql01OlO7aoo00/O00Go7alOo`0:7`03oalO00@O00?o7al01Ql00ol000040003o`3O00CO
0P000ol0000400001P05o`040?ooo`@01?l300Co00COoooo0`001?lO7al4o`8O0_l47`Go00@Ooooo
0al3o`037ooo00;o00@Ooooo11l2o`037olO008O1?l27`;o11l01?lO7al4o`047oooo`<O1Ol01=oo
ool400;o00<0ool00ol011ooool37`?o00<Oool00_l011ooool37`?o00<Oool00ol01=ooool400;o
00<0oal00Ql4o`047oooo`@O00?o7al01?l27`;o11l5o`047oooo`@O0_l00aooo`03o`047oooo`<O
1?l37`Co0Ql2o`@O00Co00001?l01MoooooO00<000?o0000100000H000Go0000o`020003o`000080
00?o00000_l20005o`3Ogol00]l00ol000020004oalOo`<O00?o7ol00Ql01OlO7aoo00<O00Co7aoo
1Al01?lOool27`04oalOo`@O00?o7al00_l27`07oalO7olOo`027`05oalO7ol00Ql01OlO7aoo008O
00?o7al00Ql01Ol0003o00;O00?ogml00P000ol00002o`<O00Co7aoo1Al01?lOool27`04oalOo`DO
00Co7aoo0`001?oOgol2g`8000?o00000_l27`05oalO7ol00Ql00olO7`037`03oaoo00<O00?o7ol0
0Ql01OlO7aoo00<O00Co7aoo11l00olO7`02o`<O00Co7aoo1Al00olOo`027`07oalO7olOo`027`05
oalO7ol00P001Ol0003o00;O00?og`000`000ol0000400001P001Ol0003o008000?o00000P000ol0
0002o`8000Go003Oo`02g`03o`00008000Co7aoo0al00olOo`027`05oalO7ol00al01?lO7ol57`04
oaooo`8O00Co7aoo11l00olO7`02o`8O00Oo7alOoaoo008O00Go7alOo`027`05oalO7ol00Ql00olO
7`027`08o`000?l0gol3g`040?l000;o0al01?lO7ol57`04oaooo`8O00Co7aoo1Al01?lO7ol30004
o`3Oo`?O00@0o`000_l27`05oalO7ol00Ql00olO7`037`03oaoo00<O00?o7ol00Ql01OlO7aoo00<O
00Co7aoo11l00olO7`02o`<O00Co7aoo1Al00olOo`027`07oalO7olOo`027`05oalO7ol00P001Ol0
0=oo00;O00?o00000`000ol0000400001P001Ol0003o008000?o00000P05o`8000Go0000o`02g`03
oml0008000Co7aoo0al00olOo`02o`@O00Go7alOo`027`03oalO00<O00Co7ooo0Ql01?lO7ol47`?o
00DOoalOo`037`03oaoo00;o11l01?lO7ol37`04oalOo`@O00Go0000o`020003omoO00;O0ol00`3o
7`027`04oalOo`DO00Co7ooo0Ql01?lO7ol57`04oalOo`<000Co003o1=l3o`050?lO7ol00al01?lO
7ol57`03oaoo00<O00?o7ol00_l47`05oalO7ol00Ql00olO7`027`?o00<Ooal00Ql01?lO7ol57`03
oaoo008O00Ko7alOoal3o`@O00Go003o0002g`04omoOo`D000?o0000100000H01_l00`3o00030003
o`0000;o0`05o`04gooOg`8000Co7alO1_l67`Ko00<Ooal011l00olO7`05o`037olO00<O00Go7alO
o`037`Ko1Ql01?lO7al5o`037olO00<O1_l00`3og`03g`04o`0000Ko00<Ooal011l00olO7`05o`03
7olO00@O00?o7al01_l00`3og`03g`05o`000?l00al5o`037olO00@O00?o7al01_l67`Ko00<Ooal0
0al01?lO7al6o`037olO00@O00?o7ol00al6o`HO00Co00001Ol00`3o00040003o`0000@000060003
o`0000<00_l500Co2002o`?O00<0oal021l3o`<O00?o7al00al2o`@O0_l27`03oalO008O0_l57`Co
2Al3o`<O00?o7al01Ql2o`@O00?o00000`02o`030=oO00;O1?l57`;o11l2o`8O00?o7al00Ql2o`@O
0_l27`03o`0000<00_l00`3Og`02g`Co21l2o`DO00?o7al01Ql3o`<O00?o7al00al2o`DO1?l57`;o
11l2o`037olO00PO0ol37`03o`0000GO00<0ool01@000ol0000400001P000ol0000<00;o2@05g`03
oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00ol0000700GO00<0oal03Ql00olO
7`0<7`03o`0000L01Ml00`3o7`0>7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o0=l0
1=l90003o`0000@000060003o`0000`00_l:00CO00?o7al03Al00olO7`0=7`03oalO00`O00?o7al0
3Al00olO7`0<7`03o`0000P01Ml00olO7`0=7`03oalO00`O00?o00002005g`03oalO00dO00?o7al0
31l00olO7`0=7`03oalO00`O00?o7al03Al00ooOg`03g`X000?o0000100000H000?o00003002o`/0
0ml00olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?og`002@04g`03oalO00dO
00?o7al031l00ooO000900CO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03
omoO00;O2`000ol0000400001P000ol0000<00;o00?O00002@02g`03oalO00dO00?o7al03Al00olO
7`0<7`03oalO00dO00?o7al031l00ooOg`0:00?O00?o7al03Al00olO7`0<7`03omoO00X00ml00olO
7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00CogmoO30000ol0000400001P3oo`co
1P0000H000?o00003002o`?O2`000olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O
00?o7al03Al01?oOgml;0003golO00dO00?ogml00]l:0003golO00hO00?o7al031l00olO7`0=7`03
oalO00`O00?ogml00]l800?O00?o7al03Al00ol0000400001P000ol0000<00;o1=l:0003oalO00dO
00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03omoO00;O2`000olO7`0<7`03
omoO00?O2P000olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03omoO00?O1P04g`03oalO00dO
00?o0000100000H000?o00003002o`GO2@000olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03
oalO00`O00?o7al03Al00ooOg`03g`X000?o7al031l00ol0g`04g`T000?o7al03Al00olO7`0<7`03
oalO00dO00?o7al031l00ol0g`04g`@01Ml00olO7`0=7`03o`0000@0000600Co2`02o`030=oO00?o
20001?lO7al3o`TO00Co7alO0ol97`?o31l01?lO7al3o`TO00Co7alO0ol87`Co31l4o`?O2@03o``O
1?l4g`P000Co7alO0ol97`03oalO00?o2Al4o``O1?l;7`04o`00g`?o00?O00001Ml00`3o7`027`?o
2Al00ol0000400001P001Ol0003o00X00_l200CO00?o00001@000olO7`047`03oalO00HO00?o7al0
11l00olO7`067`04oalOo`/O00?o7al011l00olO7`067`03oalO00@O00?o7al01Al01OlO7aoo00/O
00Go003Oo`03g`P000Co7aoo2al01Ol0003o00CO1`000olO7`047`03oalO00HO00?o7al00al00olO
7`067`05oalO7ol02al01OlO7aoo00XO00Co00000ml00ooOg`04g`8000?o7al011l00olO7`067`03
o`0000@0000600Go00@0oooo0`05o`<01?l01=ooool30004oalO7`Co00@Ooooo11l01?lO7al4o`04
7oooo`@O1?l011ooool37`?o00<Ooal00Ql4o`8O0_l47`04oalO7`Co00<Oool00_l27`Go00@Ooooo
11l8o`04goooo`@00_l00`3oo`02o`047oooo`<O0ol00aooo`03o`05gooooml00P03o`030?lO008O
1?l011ooool47`03oalO00Co0Ql00olO7`037`Go00@Ooooo11l2o`037ooo00?o00@Ooooo0al4o`<0
1?l2g`;o00GO0000o`037`Co0Ql3o`<O00?o0000100000H000Go0000o`020003o`0000D00_l20005
o`3Ogol00]l00ol000020004oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alOo`047`03oalO00;o
0Ql01?lO7ol77`;o0Ql01olO7aoo7ol00Ql01OlO7aoo008O00Go7alOo`027`03oalO008O00Go7alO
o`027`03oalO00@O00?o7ol00`001?oOgol2g`8000?o00000_l27`04oalOo`DO00Co7aoo0`001?l0
gol3g`@00_l27`05oalO7ol011l01olO7aoo7ol00al01?lO7ol57`05oalO7ol00Ql00olO7`027`03
oalO00;o0al01?lO7ol57`03oaoo008000Oo003Oomoo00;O00Go0000o`027`05oalO7ol00al00olO
7`027`03o`0000@000060005o`000?l00P000ol0000500;o0P001Ol00=oo00;O00?o00000P001?lO
7ol37`03oalO008O00Go7alOo`027`05oalO7ol00Ql3o`8O0_l27`04oalOo`LO0_l27`07oalO7olO
o`027`05oalO7ol00Ql01OlO7aoo00<O00Go7alOo`037`04oalOo`@O1Ol30004o`3Oo`?O00@0o`00
0_l27`04oalOo`DO00Co7aoo0`001?l00?l4g`<00_l27`05oalO7ol011l01olO7aoo7ol00al01OlO
7aoo00@O00Go7alOo`027`03oalO008O00?o7al00_l37`04oalOo`HO0_l20007o`00gooOo`02g`05
o`000?l00Ql01_lO7aoo7`Co0al00ol0000400001P001Ol0003o008000?o00000P05o`8000Go0000
o`02g`03oml0008000Co7aoo0al00olOo`02o`@O00Co7aoo0al00olOo`027`03oalO00;o0Ql01?lO
7ol57`;o00DOoalOo`037`03oaoo00;o11l01?lO7ol37`03oalO008O00Co7aoo0al01?lO7ol47`05
oaoo7ol00`001?l00?l4g`03o`0000;o0Ql01?lO7ol57`04oalOo`<000Co003o1=l3o`050?lO7ol0
0al00olO7`02o`@O00?o7ol00al01OlO7aoo00@O00Go7alOo`027`03oalO008O0ol00aoo7`027`04
oalOo`LO00Go003o0002g`03omoO00;o00GO0000o`027`09oalO7olOoaoo00@O00?o0000100000H0
1_l00`3o00030003o`0000;o0`05o`04gooOg`8000Co7alO1_l67`04oalO7`Ko0Ql01?lO7al5o`03
7olO00HO0_l37`Ko1Ql01?lO7al6o`8O00?o7al01_l00aoo7`037`04oaoo7`Ko00<0oml00ml00ol0
0006o`037olO00@O00?o7al01_l00`3o0003g`05oml00?l00al5o`<O00Go7alOo`027`Go0al01?lO
7al6o`037olO00<O00Co7alO1_l00aoo7`037`04oalOo`<01_l2g`05oml00?l00al6o`037olO00<O
00?o0000100000H000?o00000`02o`@01Ol800;o0ml00`3o7`077`Co0al00olO7`077`;o11l00olO
7`027`;o11l3o`037olO00PO0ol37`03oalO00LO0_l37`03oalO00<O0_l57`;o00<Oo`001002o`03
0=oO00;O0_l00`3o7`037`;o11l2o`8O00?o00000`02o`800]l5o`PO0ol47`03oalO00DO1?l37`03
oalO00<O0_l57`Co1Al2o`DO0ol200GO0P02o`?O00<0oal021l2o`@O00?o0000100000H000?o0000
3002o`T01Ml00olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00ol0
000700GO00<0oal03Al00ol0000800GO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00ol0
g`04g`@01Ml00olO7`0=7`03o`0000@000060003o`0000`00_l:00CO00?o7al03Al00olO7`0=7`03
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o00002005g`03oalO00`O00?o00002@04g`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?ogml00ml600CO00?o7al03Al00ol000040000
1P000ol0000<00;o2`03g`03oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO
7`0=7`03oml000T01=l00olO7`0<7`03oml000X00ml00olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0<7`03omoO00;O2003g`03oalO00dO00?o0000100000H000?o00003002o`03g`0000T00]l00olO
7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00ooOg`0:00?O00?o7al0
31l00ooOg`0;00;O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l01?oOgml:00;O00?o7al0
3Al00ooO000400001P3oo`co00?O00000`0000H000?o00003002o`?O2`000olO7`0=7`03oalO00dO
00?o7al031l00ooOg`02g`/000?o7al031l00olO7`0=7`03oalO00dO00?o7al031l00ooOg`02g`/0
00?o7al03Al00olO7`0<7`03oalO00dO00?ogml00]l700?O00?o7al03Al00olO7`0=7`03oml000@0
00060003o`0000`00_l4g`X000?o7al03Al00olO7`0=7`03oalO00`O00?ogml00ml:0003oalO00`O
00?o7al03Al00olO7`0=7`03oalO00`O00?ogml00ml:0003oalO00dO00?o7al031l00olO7`0=7`03
omoO00?O1@04g`03oalO00dO00?o7al03Al00ol0000400001P04o`/00_l3g`?o20001?lO7al3o`TO
1?l<7`?o31l01?l0gml3o`T000Co7alO0ol87`Co31l4o``O00?o7al00ol97`Co0ml90004oalO7`?o
2Al00olO7`03o`TO1?l<7`Co0ml300GO00Co7alO0ol97`04oalO7`?o2Al00ol0000400001P001Ol0
003o00X00_l00`3Og`03g`03o`0000D000?o7al011l00olO7`067`05oalO7ol02al01?lO7ol;7`03
o`0000CO00?o00001P000olO7`047`03oalO00DO00Go7alOo`0;7`05oalO7ol02al00olO7`037`03
oalO00HO00Go003Oo`03g`P000?o7al011l00olO7`067`03oalO00<O00?o7al01Ql01OlO7aoo00/O
00Go003Oo`03g`030=oO00?O00<0oal01Al00olO7`067`03oalO00@O00?o7al01Ql00ol000040000
1P05o`040?ooo`@01?l20003gooo00;o00@0oooo0`001?lO7al4o`8O0_l47`Go00@Ooooo0al3o`03
7ooo00;o00@Ooooo11l2o`037ol000801?l01=ooool40004oalO7`Co00<Oool00_l27`Go00@Ooooo
0al3o`037ooo00?o00@Ooooo0al5o`8O1?l011ooool47`Go00COoooo1004o`<O1?l011ooool47`03
oalO00Co0Ql2o`@O1Ol011ooool37`?o00<Oool00ol01=ooool4g`?o0al4o`8O00?o7al00al01?lO
7al4o`8O0ol37`03o`0000@000060005o`000?l00P000ol0000400?o0P002?oOgmoog`3o10001?lO
7ol37`03oaoo008O00Go7alOo`037`04oalOo`DO00Co7ooo0Ql01?lO7ol47`03oalO00;o0P001Ol0
gmoo00;O0P001Ol0003o008O00Go7alOo`027`03oalO008O00Go7alOo`027`03oalO00DO0_l37`04
oalOo`DO00Ko7aoo7ol37`03oalO008O00Go7alOo`030004omoOo`;O10000ol0o`027`05oalO7ol0
11l01olO7aoo7ol00al00olOo`027`05oalO7ol00al01?lO7ol77`;o0`001?oOgol4g`04o`00o`8O
00Go7alOo`027`03oalO00<O00Co7aoo0al01OlO7aoo00@O00?o0000100000H000Go0000o`020003
o`0000801Ol20005o`3Ogol00]l00ol000020004oalOo`<O00?o7ol00Ql01OlO7aoo00<O00Co7aoo
1Al01?lOool27`04oalOo`@O00?o7al00_l20005o`00gol00ml00`3o00020004oalOo`<O00Go7alO
o`037`05oalO7ol00Ql00olO7`057`;o0al01?lO7ol67`05oaoo7ol00al00olO7`03o`<O00So0000
o`3Oo`?O00<0ool00ol27`05oalO7ol011l01olO7aoo7ol00al00olOo`027`05oalO7ol00al01?lO
7ol77`;o0`001?l0gol3g`050?l00?l00Ql01OlO7aoo00<O00?o7al00Ql01?lO7ol37`03oaoo00?o
0al00ol0000400001P001Ol0003o008000?o00000P000ol0o`02o`8000Go003Oo`02g`03o`000080
00Co7aoo0al00olOo`02o`@O00Go7alOo`027`03oalO00<O00Co7ooo0Ql01?lO7ol47`?o00DOo`00
o`030003omoo00;o10001?lO7ol37`03oalO008O00Co7aoo0al01?lO7ol47`?o00<Ooal00Ql01?lO
7ol77`;o00<Ooal00Ql00olOo`027`05oalO7ol00`001?l00?l4g`05o`3o0?l00Ql01OlO7aoo008O
0_l47`03oaoo00<O00?o7al00_l47`05oalO7ol00Ql00olO7`037`;o00<Oo`000P001?oOgol4g`04
o`00o`8O00Go7alOo`037`03oalO008O00Co7aoo0al01OlOoaoo00@O00?o0000100000H01_l00`3o
00030003o`3o00;o0`05o`03gooO00<000Co7alO1_l67`Ko00<Ooal011l00olO7`05o`037olO00<O
00Go7alOo`0300Ko0ml30004oalO7`Ko0Ql00olO7`06o`037olO00<O00Co7alO1_l00aoo7`037`03
oalO00;o0Ql6o`8O00Co7alO1_l00`3og`03g`05o`3o0?l00al5o`<O00Go7alOo`027`Ko0Ql01?lO
7al6o`037olO00HO1ol00moog`03g`04o`00o`<O1Ol37`05oalO7ol00al6o`037olO00<O00?o0000
100000H000?o00000`02o`D01?l70003gooo00;O0P000olO7`077`?o0al00olO7`037`;o11l2o`8O
00?o7al00Ql2o`DO1?l800Co00CO003o2Al2o`<O00?o7al00al2o`@O1Ol57`;o1Al2o`037olO00LO
0_l47`03o`0000<00_l00`3Og`02g`;o00<0oal01al3o`@O00?o7al01Ql2o`@O00?o7al00al2o`@O
0ol011oo0003g`;o00<0gml00]l3o`PO1?l37`03oalO00LO0_l47`03o`0000@000060003o`0000`0
0_l800GO00<0oal03Ql00olO7`0=7`03oalO00`O00?o00001`05g`030?lO00dO00?o7al03Al00olO
7`0=7`03oalO00`O00?o00001`05g`030?lO00hO00?o7al031l00olO7`0=7`03o`3O00CO0`05g`03
oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o2@05g`03oalO00dO00?o7al03Al00olO
7`0<7`03o`0000P01Ml00olO7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`03o`0000P01Ml00olO
7`0=7`03oalO00`O00?o7al03Al00ooOg`03g`D01=l00olO7`0=7`03oalO00dO00?o0000100000H0
00?o00003002o`X01=l00olO7`0=7`03oalO00dO00?o7al031l00ol0000900CO00?o7al031l00olO
7`0=7`03oalO00dO00?o7al031l00ol0000900CO00?o7al03Al00olO7`0<7`03oalO00dO00?ogml0
0]l700?O00?o7al03Al00olO7`0=7`03o`0000@000060003o`0000`00_l00ml0000800?O00?o7al0
3Al00olO7`0=7`03oalO00`O00?og`002P03g`03oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O
00?og`002P03g`03oalO00dO00?o7al031l00olO7`0=7`04omoOg`T00]l00olO7`0=7`03oalO00dO
00?og`00100000H0ool<o`03g`0000<000060003o`0000`00_l3g`X000?Ooal03Ql00olO7`0=7`03
oalO00`O00?o7al03Al01?oOgml;0003oalO00dO00?o7al03Al00olO7`0<7`04omoOg`/000?Ooal0
3Ql00olO7`0<7`04omoOg`T00ml00olO7`0<7`03oalO00dO00?o7al03Al00ooO000400001P000ol0
000<00;o1=l:0003oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?ogml00]l:0003oalO00dO
00?o7al03Al00olO7`0<7`03omoO00;O2`000olO7`0=7`03oalO00`O00?ogml00]l700CO00?o7al0
31l00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`GO2@000olO7`0=7`03oalO00dO
00?o7al031l00olO7`0=7`03omoO00?O2@000olO7`0=7`03oalO00dO00?o7al031l00ooOg`03g`X0
00?o7al03Al00olO7`0<7`03omoO00?O1@05g`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@0
000600Co2`02o`030=oO00?o20001?lO7al3o`TO00Co7alO0ol97`?o31l01?lO7al3o`TO00Co0=oO
0ol800Co31l01?lO7al3o`TO00?o7al00ol97`Co0ml90004oalO7`?o2Al00olO7`03o`TO1?l3g`<0
1Ml00`3o7`027`?o21l01?lO7al3o`TO00Co7alO0ol97`03o`0000@000060005o`000?l02P02o`80
1=l00ol000050003oalO00@O00?o7al01Ql00olO7`047`03oalO00HO00Co7aoo2al00olO7`047`03
oalO00HO00?o00001=l00ol000050005oalO7ol02al00olO7`047`03oalO00HO00?o7al00al00olO
7`067`05o`00gol00ml80003oalO00@O00?o7al01Ql00olO7`037`03oalO00HO00Go003Oo`03g`03
0=oO00?O0P000olO7`047`03oalO00DO00?o7al011l00olO7`067`03oalO00@O00?o7al01Ql00ol0
000400001P05o`040?ooo`<01Ol300Co00COoooo0`001?lO7al4o`047oooo`@O00Co7alO1?l011oo
ool47`Co00@Ooooo0al3o`037olO008O1?l011ooool47`04o`0000Co00COoooo0`05o`047oooo`<O
0ol00aoo7`027`Co00@Ooooo11l00olO7`04o`047oooo`@O1Ol01=ooool300?o00<0oal00Ql4o`04
7oooo`@O00?o7al01?l011ooool47`Go00COoooo0ml3o`030?lO008O1?l011ooool37`04oalO7`Co
00@Ooooo11l01?lO7al4o`047oooo`@O00?o0000100000H000Go0000o`020003o`0000D00_l20005
o`3Ogol00]l00ol000020004oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alOo`047`03oalO00;o
0Ql01?lO7ol77`;o0Ql01OlO7aoo00@O00Go7alOo`020005o`3Ogol00]l00ol000020005oalO7ol0
0Ql00olO7`057`;o0Ql01OlO7aoo00@O00Oo7alOoaoo00<O00?o7al00Ql01OlO7aoo00<000Cogmoo
0]l500;o0Ql01OlO7aoo008O00?o7al00al00olOo`037`03oalO008O00Go7alOo`030004omoOo`CO
0`02o`8O00Go7alOo`047`04oalOo`8O00Go7alOo`047`05oalO7ol00Ql01OlO7aoo008O00?o7al0
0al00ol0000400001P001Ol0003o008000?o00001@02o`8000Go003Oo`02g`03o`00008000Co7aoo
0al00olO7`027`05oalO7ol00Ql01OlO7aoo008O0ol27`;o0Ql01?lO7ol77`;o0Ql01OlO7aoo00@O
00Go7alOo`020005o`00gol00]l00ol000020005oalO7ol00Ql00olO7`057`;o0Ql01OlO7aoo008O
0ol37`03oaoo00<O00?o7al00ol37`08o`000?l0gol3g`@00_l27`05oalO7ol00Ql00olO7`037`03
oaoo00<O00?o7al00Ql01OlO7aoo00<000Co0=oo0ml400;o0Ql01OlO7aoo008O0ol27`04oalOo`<O
00?o7al00Ql01OlO7aoo008O00Go7alOo`027`03oalO00<O00?o0000100000H000Go0000o`020003
o`0000<01?l20005o`000?l00]l00ooO00020004oalOo`<O00?o7ol00_l47`04oalOo`<O00?o7ol0
0Ql00olO7`02o`8O00Co7aoo1Al2o`057olO7ol00al00olOo`02o`@O00Co003o0`001OoOgooO00<0
00Go7alOo`027`03oalO00<O0_l01Aoo7aoo00<O00?o7ol00Ql01olO7aoo7ol00al00olOo`027`05
oalO7ol00`001?l00?l4g`050?oo0?l00Ql01OlO7aoo008O00?o7al00al00olOo`037`03oaoo00;o
11l01Ol0003o00;O00?ogml00]l01@3oo`3o008O00Oo7alOoaoo008O00Co7aoo0Ql01_lO7aoo7`?o
11l01?lO7ol37`04oalOo`DO00?o0000100000H01_l00`3o000600;o0`05o`04gooOg`8000Co7alO
1_l67`04oalO7`Ko0Ql01?lO7al5o`037olO00HO0_l37`Ko1Ql01?l00005o`04gooOg`801_l00aoo
7`067`;o0al6o`8O00Go7alOo`027`Ko0Ql01?lO7al6o`030?oO00CO0P02o`<O1Ol00aoo7`047`03
oalO00Ko1Ql6o`03gooO00CO0P02o`<O1_l27`04oalOo`<O1_l67`04oalO7`Go00<Ooal011l00ol0
000400001P000ol0000300;o1005o`P00_l3g`030?lO00LO1?l37`03oalO00LO0_l47`03oalO008O
0_l47`?o00<Ooal01al4o`<O00?o00001P02o`?O00<0oal011l2o`@O0ol00aoo7`087`;o11l00olO
7`067`;o11l00ol0000300;o00@0gmoO0ol00`3o7`077`;o1Al00olO7`057`Co0al00ol00003g`;o
00@0gmoO0ol00`3o7`087`;o0al00olO7`067`Co0al00olO7`067`;o1Al00ol0000400001P000ol0
000<00;o2@05g`03oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?o00001`05g`03oalO00dO
00?o7al03Al00olO7`0<7`03o`0000L01Ml00`3o7`0>7`03oalO00`O00?o0=l01=l300GO00<0oal0
3Al00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`X01=l00olO7`0=7`03oalO00dO
00?o7al031l00olO7`0=7`03o`0000P01=l00olO7`0=7`03oalO00dO00?o7al031l00ol0000800GO
00?o7al03Al00olO7`0<7`03omoO00?O1@05g`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@0
00060003o`0000`00_l;00?O00?o7al03Al00olO7`0=7`03oalO00`O00?o7al03Al00ol0000900?O
00?o7al03Al00olO7`0=7`03oalO00`O00?og`002@04g`03oalO00dO00?o7al031l00ooOg`02g`L0
1=l00olO7`0<7`03oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o00?O00002@02g`03
oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?og`002P02g`03oalO00dO00?o7al03Al00olO
7`0<7`03omoO00X00ml00olO7`0=7`03oalO00`O00CogmoO2@03g`03oalO00`O00?o7al03Al00olO
7`0=7`03oml000@000060?oo3?l00ml0000300001P000ol0000<00;o0ml;0003oalO00dO00CogmoO
2`000moo7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o7al031l00ooOg`02g`X0
00?Ooal03Ql01?oOgml800?O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ooO00040000
1P000ol0000<00;o1=l:0003oalO00dO00?ogml00]l;0003oalO00`O00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al03Al00olO7`0<7`03omoO00?O2P000olO7`0=7`03omoO00;O1P04g`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`GO2@000olO7`0=7`03
omoO00?O2P000olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o7al031l00ol0
g`04g`T000?o7al03Al00ooOg`03g`@01Ml00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03
o`0000@0000600Co2`02o`030=oO00?o20001?lO7al3o`TO00Co0=oO0ol90003oalO00?o2Al01?lO
7al3o`TO00Co7alO0ol87`04oalO7`?o2Al01?lO7al3o`TO0ol<7`Co1=l80004oalO7`?o2Al3o`CO
0P05g`030?oo00;o31l4o`/O1?l<7`Co31l00ol0000400001P001Ol0003o00X00_l200CO00?o0000
1@000olO7`047`03oalO00HO00?o00001=l00ol000060003oalO00<O00?o7al01Ql00olO7`047`03
oalO00HO00?o7al011l00olO7`057`03oalO00@O00?o7al01Ql00olO7`047`03oalO00HO00Co7aoo
2al01Ol0003o00CO1`000olO7`047`03oalO00HO00Co003o2Ml20005oalO7ol02al01OlO7aoo00XO
00Go7alOo`0;7`05oalO7ol02al00ol0000400001P05o`040?ooo`<01Ol300Co00COoooo0`001?lO
7al4o`037ooo00;o0al01?l00004o`04goooo`@000?o7al01?l27`?o0al01?lO7al4o`8O0_l47`04
oalO7`Co00@Ooooo0al01?lO7al4o`8O0_l47`04oalO7`Co0Ql00olO7`037`Co00@Ooooo0al3o`03
7ooo00?o00GOoooog`0200Go0al4o`047oooo`@O1?l01=ooool4g`;o00<0ool00ol011ooool47`;o
00<Oool00ol011ooool37`So00@Ooooo11l8o`047oooo`<O0ol00aoo000500001P001Ol0003o0080
00?o00000`001?l0ool20005o`3Ogol00]l00ol000020004oalOo`<O00Co7aoo1Al01Ol00?l000;O
00?ogml00P001ol0003o7ol00al01OlO7aoo00@O00Co7aoo0al00olOo`027`05oalO7ol00Ql01OlO
7aoo00@O00Co7aoo0Ql01olO7aoo7ol00Ql01OlO7aoo008O00Go7alOo`027`03oalO008O0_l27`04
oalOo`DO00Co7aoo0`001?l0gol3g`8000Co003o0Ql01OlO7aoo00@O00?o7al00_l20004o`3Oo`CO
00?o00000_l37`04oalOo`@O00?o7al00_l37`04oalOo`LO00Go7alOo`027`03oalO00@O00?o7ol0
0al01?lO7ol77`;o1P0000H000Go0000o`020003o`0000@00ol20005o`00gol00]l00ol000020004
oalOo`<O00Go7alOo`047`04o`00o`8000?Ooml00]l00`3o00020003oaoo00<O00?o7ol00ol37`04
oalOo`<O00?o7ol00Ql01OlO7aoo008O00Go7alOo`047`04oalOo`8O00Oo7alOoaoo008O00Go7alO
o`027`05oalO7ol00al01?lO7al2o`8O00Co7aoo1Al01?lO7ol30004o`00o`CO0P000ol0o`027`05
oalO7ol00Ql3o`8O0_l20004o`3Oo`CO00?o00000_l37`04oalOo`@O00?o7al00_l37`04oalOo`LO
00Go7alOo`027`03oalO008O1Ol37`04oalOo`LO0_l600001P001Ol0003o008000?o00001@02o`80
00Go0000o`02g`03oml0008000Co7aoo0al00olO7`027`05oalO7ol00P001Ol0003o00;O0_l40003
oaoo00<O00Go7olOo`047`04oalOo`<O00?o7ol00_l47`04oalOo`<O00?o7ol00_l37`04oalOo`<O
00?o7al00_l47`04oalOo`<O00Go7alOo`037`;o0Ql01?lO7ol57`04oalOo`<000Co003o1Ml200;o
0Ql01olO7aoo7ol00Ql00olO7`02o`8000Cogmoo1=l00ol00002o`<O00Co7aoo11l3o`037olO008O
00Co7aoo11l4o`<O00Co7aoo11l01OlOoaoo00<O00Co7aoo1Al2o`037ol000D0000600Ko00<0o`00
0`000ol00002o`<01Ol01=oogml20004oalO7`Ko0Ql01OlO7aoo00<01Ol3g`05o`000?l00Ql6o`03
7olO00<O00Co7alO1_l67`04oalO7`Ko1Al01?lO7al6o`8O00Go7alOo`037`Go0al01?lO7al5o`03
7olO00@O00?o7al01_l00`3o0003g`03oml000;o0al6o`8O00Co7alO1Ol00moog`03g`03oml000Oo
00<Ooal00al01?lO7al6o`037olO00<O00?o7al01_l00aoo7`037`04oaoo7`Ko00<Ooal01Ql2o`H0
00060003o`0000<00_l500Co2002o`?O00<0oal021l2o`@O00?o00001P03o`;O0P000olO7`067`;o
11l00olO7`077`?o0al00olO7`067`Co0Ql00olO7`077`;o11l00olO7`067`Co0al00olO7`027`;o
11l2o`8O00?o00000`02o`800ml2o`030?lO00PO0_l47`03o`3O00;O0_l200?O0_l00`3o7`047`;o
1Al4o`DO0_l47`Co1Al2o`DO0_l00aoo7`047`;o11l3o`037ol000D000060003o`0000`00_l900GO
00?o7al03Al00ol0000700GO00<0oal03Al00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03
oalO00`O00?o00002005g`03oalO00dO00?ogml00ml400GO00?o7al03Al00olO7`0<7`03oalO00dO
00?o7al03Al00ol0000400001P000ol0000<00;o2P04g`03oalO00dO00?o00002005g`03oalO00`O
00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`03o`0000T01=l00olO7`0=7`03
omoO00;O1P04g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o0000100000H000?o0000
3002o`03g`0000P00ml00olO7`0=7`03oml000T01=l00olO7`0<7`03oalO00dO00?o7al031l00olO
7`0=7`03oalO00dO00?o7al031l00ooO000:00?O00?o7al03Al01?oOgml800?O00?o7al03Al00olO
7`0<7`03oalO00dO00?o7al03Al00ooO000400001P3oo`co00?O00000`0000H000?o00003002o`?O
2P000moo7`0>7`03oalO00dO00?ogml02`000moo7`0>7`03oalO00`O00?o7al03Al00olO7`0=7`03
oalO00`O00CogmoO2`000moog`02g`T00ml00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03
oalO00dO00?og`00100000H000?o00003002o`CO2P000olO7`0=7`03oalO00dO00CogmoO2`000olO
7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O00?ogml00]l;0003omoO00;O1`04g`03
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o
1Ml90003oalO00dO00?o7al03Al00ooOg`02g`X000?o7al03Al00olO7`0<7`03oalO00dO00?o7al0
3Al00olO7`0<7`03omoO00?O2P000ooOg`03g`D01Ml00olO7`0<7`03oalO00dO00?o7al031l00olO
7`0=7`03oalO00dO00?o0000100000H01?l;00;o00<0gml00ol80004oalO7`?o2Al01?lO7al3o`TO
00?ogml00ol90004oalO7`?o2Al01?lO7al3o`PO00Co7alO0ol97`04oalO7`?o2Al3o``O1?l3g`T0
1?l3g`<01Ml0103oool<7`Co31l4o`/O1?l<7`Co31l00ol0000400001P001Ol0003o00X00_l200CO
00?o00001@000olO7`047`03oalO00HO00?o7al011l00olO7`067`03o`3O00?O00?o00001P000olO
7`047`03oalO00HO00?o7al011l00olO7`057`03oalO00@O00?o7al01Ql00olO7`047`03oalO00HO
00Co7aoo2al01Ol00=oo00?O20001Ol00=oo00?O00<0gml00ml20004oalOo`/O00Go7alOo`0;7`05
oalO7ol02Ql01OlO7aoo00/O00Go7alOo`0;7`03o`0000@0000600Go00@0oooo0`05o`<01?l01=oo
ool30004oalO7`Co00@Ooooo11l01?lO7al4o`047oooo`@O00?o00001?l01=ooool40004oalO7`Co
0Ql2o`@O00Co7alO1?l27`;o0al01?lO7al4o`8O0_l47`04oalO7`Co0Ql2o`@O1?l011ooool37`?o
00<Oool00ol01=ooool300?o00<0ool00ol01=ooool3g`?o00<0ool00_l011ooool37`?o00<Oool0
0ol011ooool47`;o00<Oool00ol011ooool47`Oo00@Ooooo11l2o`037ooo00?o00@Ooooo11l2o`03
7ol000D000060005o`000?l00P000ol000030004o`3oo`8000Go0=oOo`02g`03o`00008000Co7aoo
0al01?lO7ol57`04oalOo`<O00Co7aoo1Al01?l0o`02g`04omoOo`D000Co7aoo0al00olOo`027`05
oalO7ol00Ql01olO7aoo7ol00Ql01?lO7ol27`07oalO7olOo`027`05oalO7ol00Ql01olO7aoo7ol0
0Ql00olO7`02o`8O00Co7aoo1Al01?lO7ol30004omoOo`;O0`001?l00?l30004omoOo`CO00<0o`00
0_l27`04oalOo`DO00Co7aoo0al01?lO7ol47`03oalO00;o0al01?lO7ol47`04oalOo`<O00Co7aoo
11l00olO7`02o`<O00Co7aoo11l00olO7`02o`H000060005o`000?l00P000ol000030004o`3oo`80
00Go003Oo`02g`03o`00008000Co7aoo0al01?lO7ol57`04oalOo`<O00Co7aoo1Al00ol0o`020005
gooOgol01@001?lO7ol37`03oaoo008O00Go7alOo`027`07oalO7olOo`027`04oalOo`8O00Oo7alO
oaoo008O00Go7alOo`027`07oalO7olOo`027`03oalO00;o0Ql01?lO7ol57`04oalOo`<000Co0=oo
0ml20004o`00o`<000Co0=oo0ml20004o`3oo`8O00Co7aoo1Al01?lO7ol37`04oalOo`@O00?o7al0
0_l37`04oalOo`@O00Co7aoo0al01?lO7ol47`03oalO00;o0al01?lO7ol47`03oalO00;o1P0000H0
00Go0000o`020003o`0000<000Co0?oo0P001Ol0003o00;O00?og`000P001?lO7ol37`04oalOo`DO
00Co7aoo0al01?lO7ol57`03o`3o00<000Gogmoog`040004oalOo`<O00?o7ol00_l47`04oalOo`<O
00?o7ol00_l37`04oalOo`<O00?o7ol00_l47`04oalOo`<O00?o7ol00_l37`;o0Ql01?lO7ol57`04
oalOo`<000Co003o1=l01@3o003o00<000Cogmoo1=l00`3o0002o`8O00Co7aoo1Al01?lO7ol37`04
oalOo`@O0ol00aoo7`027`04oalOo`@O1?l37`04oalOo`@O0ol00aoo7`027`04oalOo`@O0ol00aoo
000500001P06o`030?l000@000Co0?oo0`05o`04gooOg`8000Co7alO1Ol00aoo7`047`04oalO7`Go
00<Ooal011l00ol00005o`04gooOg`<000Co7alO1_l67`04oalO7`Ko1Al01?lO7al6o`HO00Co7alO
1_l67`Go00<Ooal011l00olO7`06o`030?oO00CO00?o00001_l00moog`04g`03o`0000Go00<Ooal0
11l00olO7`06o`037olO00<O00Co7alO1_l00aoo7`037`03oalO00Ko00<Ooal00al01?lO7al6o`03
7olO00<O00Go7alOo`0600001P000ol0000300;o1002o`030?oo00P00_l3g`030?lO00LO0_l57`03
oalO00HO0_l57`03o`0000D00_l3g`8000?o7al01al3o`<O00?o7al01al3o`8O00?o7al01al3o`<O
00?o7al01al3o`<O00?o7al00Ql2o`@O0_l27`03o`0000<00_l0103Ogml2o`8000?o00000ml2o`04
0=oOg`;o0P000olO7`027`;o11l2o`8O00?o7al00al2o`DO1?l57`;o1Al3o`DO0_l57`Co1Al2o`DO
1?l600001P000ol0000<00;o2@05g`03oalO00dO00?o7al03Al00ol0000600GO00<0oal03Ql00olO
7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`03o`0000L01Ml00`3o0005g`<01Ml00`3o7`0=7`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`X01=l00olO
7`0=7`03oalO00dO00?o00001`05g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o7al0
31l00ol0000800GO00?ogml00ml500GO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0=7`03o`0000@000060003o`0000`00_l;00?O00?o7al03Al00olO7`0=7`03o`0000P01=l00olO
7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O00?og`002@04g`03omoO00;O1`04g`03
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o
00?O00002@02g`03oalO00dO00?o7al03Al00ooO000900?O00?o7al03Al00olO7`0<7`03oalO00dO
00?o7al03Al00olO7`0<7`03omoO00X00ml01?oOgml900?O00?o7al031l00olO7`0=7`03oalO00`O
00?o7al03Al00olO7`0=7`03oml000@000060?oo3?l00ml0000300001P000ol0000<00;o0ml;0003
omoO00;O2P000moog`02g`/000?Ooml00]l:0003gooO00;O2`000moog`02g`/000?ogml00]l:0003
gooO00;O2`000moog`02g`/000?ogml00]l800?O00CogmoO2`000moog`02g`X000?Ooml00]l;0003
gooO00;O2`000ooOg`02g`X000?Ooml00]l;0003gooO00D000060003o`0000`00_l4g`X000?ogml0
0ml:0003omoO00;O2`000ooOg`02g`X000?ogml00]l;0003omoO00;O2P000ooOg`03g`X000?ogml0
0]l;0003omoO00;O2P000ooOg`03g`H01=l00ooOg`02g`/000?ogml00]l:0003omoO00;O2`000ooO
g`02g`X000?ogml00ml:0003omoO00;O2`000ol0000400001P000ol0000<00;o1Ml90003o`3O00CO
2@000ooOg`03g`X000?ogml00ml90003omoO00?O2P000ooOg`03g`T000?o0=l01=l90003omoO00?O
2P000ooOg`03g`T000?o0=l01=l400GO00?ogml00ml:0003omoO00?O2@000ooOg`03g`X000?ogml0
0ml90003o`3O00CO2@000ooOg`03g`X000?o0000100000H01?l;00;o00<0gml00ol80004o`00g`?o
00?O00001P001?l0gml3o`T000?o0=l00ol00ml000060004o`3Og`?o2@001?l0gml3o`P000Co003O
0ol00ml000060004o`3Og`?o2@000ol0g`03o`03g`0000H01?l4g`801Ml00`3oo`02o`?O2@03o`CO
2004o`?O2@04o`?O2004o`CO2004o`?O2@000ol0000400001P001Ol0003o00X00_l200CO00?o0000
1@001?l00003g`03oml000H000?o00001=l00ol000060003o`0000?O00?og`001P000ol00004g`03
o`0000H000?o00001=l00ol000050004o`0000?O00?og`001P000ol00004g`03o`0000H000?o0000
0ml00ooO00060005o`000?l02Ml20005o`00gol00ml80004o`00o`CO1`001Ol00=oo00?O20001Ol0
0=oo00?O1`001Ol0003o00CO1`001Ol00=oo00?O20000ol0000400001P05o`040?ooo`@01?l300Co
00COoooo0`001?l00004o`03gooo00;o0`001?l00004o`04goooo`@000?o00001?l2g`?o0`001?l0
0004o`04goooo`@000Co00001?l01=l0ool30004o`0000Co0]l00ol000030004o`0000Co00CO0?oo
10000ol00004o`04goooo`@01Ol01=ooool4g`;o00<0ool00ol01=ooool300?o00<0ool00_l01Moo
oooO00802Ol01=ooool300?o00<0ool00ol01=ooool400Oo00GOoooog`0200?o00<0ool00ol01=oo
ool400;o00<0o`001@0000H000Go0000o`020003o`00008000?o00000_l20005o`3Ogol00]l00ol0
00020004o`00o`8000GOomoOo`050005o`00o`000]l00ooOg`020007o`000?l0o`020003gooO00;O
00?o00000P001Ol00?l000;O00?ogml00P001Ol0003o008000Oo0=oOomoo008000Co003o0P001Ol0
0=oo00;O00?o00000`001Ol00?l000;O00?ogol00P001ol0003o0?l00P000moog`02g`030?l00080
00So0000o`3Oo`CO00?o00000_l30004omoOo`;O0`001?l0ool20004o`3Oo`?O0P001?l00?l30004
omoOo`;O1@02o`<000Cogmoo0]l400;o0`001?l0gol3g`@00_l30004omoOo`;O0P000ol00002o`H0
00060005o`000?l00P000ol000020003o`0000;o0P001Ol00=oo00;O00?o00000P001?l00?l30005
omoOgol010001?l00?l20003gooO00;O00<0o`000P000ol0o`030003omoo00?o0`001?l00?l20003
gooO00;O00<0o`000P001?l00?l20007gooOoml0o`020004o`00o`<000GogmoOo`040004o`00o`80
00OOomoog`3o00<000?o0?l00`000ooOg`03o`<000So0000o`3Oo`CO00?o00000_l30004o`3Oo`?O
0P001?l0ool20004o`00o`CO0P000ol0o`030004o`3Oo`?O1002o`<000Co0=oo0ml00`3oo`02o`<0
00Co003o1=l300;o0`001?l0gol3g`040?l000;o1P0000H000Go0000o`020003o`00008000?o0000
0_l20005o`000?l00]l00ooO00020004o`00o`<000?ogml00]l01Ol0003o008000Go0000o`02g`;o
10000ol0o`030006omoogooO0`001?l00?l30003omoo00;o10001?l00?l30003omoo00;o0`001?l0
0?l30006omoOgooO0`001?l00?l30003omoO00;o10000ol0o`030003omoo00;O00Go0000o`030004
omoOo`CO00?o00000_l30004o`00o`CO00<0o`000_l20004o`00o`GO0P02o`<000Co003o1=l01@3o
o`3o00<000Co003o1=l01?l0ool30004o`00o`CO0ol00`3o00020004o`00o`CO0ol00`3o00050000
1P06o`030?l000<000?o00000_l300Go00COomoO0P001?l00006o`;O00Gog`00o`0300Go0ml01Ol0
003o00801_l01=oogml20004o`0000Ko0ml30004o`0000Ko0ml20004o`0000Go0ml01OoO003o00<0
1_l2g`05o`000?l00P06o`;O00Cog`001_l00moog`03g`03oml000Oo00<0oml01=l00ol00005o`03
0?l000?O00?og`001ol00`3og`04g`801ol00`3og`03g`03o`3o00Ko00<0o`000ml01?oO0006o`03
0?oO00?O00Go0000o`0600001P000ol0000300;o1@04o`P00_l3g`030?l000P00_l3g`030?l000L0
0ol2g`8000?o00001P02o`?O00<0o`001`04o`04g`00o`P000OOoooog`3o00P01?l2g`030?l000L0
00?Oool00]l20003o`0000H00_l3g`040?l000?O0_l200?O0_l00`3o000400;o00@0gmoO0_l20003
o`0000800_l200?O0_l00`3o000400;o00@0gmoO0ol00`3o000400;o00<0gml00]l3o`D00_l200;O
1Ol500;o00<0gml00]l4o`H000060003o`0000`00_l900GO00?o00002005g`03o`0000L01Ml00`3o
000800GO00?o00001`05g`030?l000P01Ml00ol0000800GO00?o00001`05g`030?l000P01Ml00ol0
g`04g`@01Ml00ol0000700GO00<0o`002005g`03o`0000L01Ml00`3o000800GO00?o00002005g`03
o`0000L01Ml00`3o000500001P000ol0000<00;o2P04g`03o`0000T01=l00ol0000800GO00?o0000
2004g`03o`0000P01Ml00ol0000800CO00?o00002@04g`03o`0000P01Ml00ol0000800CO00?ogml0
0ml600CO00?o00002005g`03o`0000P01=l00ol0000800GO00?o00002004g`03o`0000T01=l00ol0
000800GO00?o0000100000H000?o00003002o`/00ml00ooO000:00?O00?og`002@04g`03o`0000T0
0ml00ooO000900CO00?o00002@03g`03oml000X00ml00ooO000900CO00?o00002@03g`03omoO00;O
2003g`03oml000T01=l00ol0000900?O00?og`002@04g`03o`0000T00ml00ooO000:00?O00?og`00
2@04g`03o`0000@000060003o`0000`00_l00ml0000900;O00?ogml02`02g`03omoO00X00ml00ooO
000:00;O00?ogml02P03g`03oml000X00]l00ooOg`0;00;O00?ogml02P03g`03oml000X00]l01?oO
gml:00;O00?ogml02P03g`03oml000X00]l00ooOg`0:00?O00?og`002P02g`03omoO00/00]l00ooO
g`0:00?O00?og`00100000H0ool<o`03g`0000<000060003o`0000`00_l3g`/000?ogml00]l;0003
oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`04omoOg`P00ml00ooO
g`02g`/000?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?og`00
100000H000?o00003002o`CO2P000ooOg`03g`X000?o7al03Al00olO7`0<7`03oalO00dO00?o7al0
31l00olO7`0=7`03oalO00dO00?ogml00]l600CO00?ogml00ml:0003oalO00dO00?o7al031l00olO
7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@000060004o`0000?o2002o`?O0ol80004
o`3Og`?o2@001?lO7al3o`TO00?o7al00ol97`04oalO7`?o2Al01?lO7al3o`PO00Co7alO0ol97`04
oalO7`?o2Al00ooOg`03o`@01Ml01?l0gml3o`T000Co7alO0ol97`03oalO00?o2Al4o``O1?l;7`Co
31l4o``O00?o0000100000H000?o000010000ol0000500;o00<0gml00ml00ol000050003o`0000CO
00?o00001P000olO7`047`03oalO00HO00?o7al00al00olO7`067`03oalO00@O00?o7al01Ql00olO
7`047`03oalO00DO00?o7al011l00olO7`067`03oalO00@O00?o7al01Ql00ol0g`03g`03o`0000GO
00@0o`001=l00ol000060003oalO00@O00?o7al01Ql00olO7`037`03oalO00HO00Go7alOo`0;7`05
oalO7ol02Ql01OlO7aoo00/O00Go7alOo`0;7`03o`0000@000060004o`0000Co00@0oooo0`02o`80
00?Oool00_l0103oool30004o`0000Co00COoooo10001?lO7al4o`047oooo`@O00?o7al01?l011oo
ool47`04oalO7`Co00@Ooooo11l01?lO7al4o`047oooo`<O00Co7alO1?l011ooool47`04oalO7`Co
00@Ooooo11l00ol00004o`04goooo`;O0P001?l00004o`04goooo`@000Co7alO1?l011ooool47`03
oalO00Co00@Ooooo11l5o`047oooo`<O0ol00aooo`03o`047oooo`<O2?l011ooool37`?o00<Oool0
0ol011ooool37`?o00<Oo`001@0000H000Co003o0`000ol000020003o`0000;o0P002?oOgmoog`3o
10001Ol00?l000;O00Cogmoo1@001?lO7ol37`04oalOo`DO00?o7ol00al01?lO7ol57`04oalOo`<O
00?o7al00Ql01OlO7aoo008O00Go7alOo`047`04oalOo`8O00Go7alOo`047`05oalO7ol00Ql01OlO
7aoo00@O00So7alOo`3o00;O00?ogml00]l01Ol0003o008000Go0=oOo`02g`8000Go0000o`027`05
oalO7ol011l01olO7aoo7ol00al00olO7`027`05oalO7ol00al01?lO7ol77`;o0al01?lO7ol77`05
oalO7ol00Ql00olO7`057`;o0al01?lO7ol77`;o1P0000H000Co003o0`000ol00003o`800_l20005
o`3Ogol00]l00ol000020004o`00o`8000GOomoOo`050004oalOo`<O00Co7aoo1Al00olOo`037`04
oalOo`DO00Co7aoo0al00olO7`027`05oalO7ol00Ql01OlO7aoo00@O00Co7aoo0Ql01OlO7aoo00@O
00Go7alOo`027`05oalO7ol011l01olO7aoo0?l00P001=oogml3o`<000Co003o0P001=oogml3o`<0
00Co7aoo0al00olO7`03o`<O00?o7ol00al00olO7`03o`<O00Go7alOo`027`03oalO00DO0_l37`04
oalOo`LO00Go7alOo`027`03oalO00DO0_l37`04oalOo`LO0_l600001P001?l00?l30003o`3o0080
00?o00000_l20005o`00gol00]l00ol000020004o`00o`<000Gogmoog`040004oalOo`<O00Co7aoo
1Al00olOo`037`04oalOo`DO00Co7aoo0al00olOo`02o`@O00Co7aoo0al00olOo`02o`<O00Co7aoo
0al00olOo`02o`@O00Co7aoo0al00olOo`02o`@O00?o0?l00P001=oogol2g`05o`000?l00P001ol0
003ogol00]l01Ol0003o008O00Oo7alOoaoo008O00Oo7alOoaoo00<O00?o7ol00Ql01OlO7aoo00<O
00Co7aoo1Al2o`037olO008O00Co7aoo1Al3o`<O00Co7aoo1Al2o`037olO008O00Co7aoo1Al2o`03
7ol000D000060004o`0000Ko0P000ol00002o`<01Ol00moog`030004o`0000Go00COomoO0`001?lO
7al5o`037olO00@O00?o7al01Ol00aoo7`047`04oalO7`Ko1Ql01?lO7al6o`DO00Co7alO1_l67`04
oalO7`Ko1Ql00ol00006o`;O00Go0000o`0300Ko0]l01Ol0003o00<O1_l27`05oalO7ol00Ql6o`8O
00Co7alO1_l00aoo7`067`Oo00<Ooal01Ql6o`037olO00HO1ol00aoo7`067`;o1P0000H000?o0000
1`02o`<00_l70003gooo00;O0P000ol0000600;o0ml20003oalO00HO0_l57`03oalO00DO0_l57`03
oalO00HO1?l37`03oalO00HO1?l27`03oalO00HO1?l37`03oalO00HO1?l37`03o`0000KO0_l2g`80
00?o00001P000mooo`02g`8000?o7al01al2o`@O00?o7al01Ql2o`@O00?o7al00al2o`@O0ol00aoo
7`047`;o11l4o`DO0_l47`?o00<Ooal011l2o`@O0ol00aoo000500001P000ol0000<00;o2005g`03
0?l000P01Ml00`3o7`0>7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ol0
g`04g`801Ml00`3o000800GO00<0oal03Ql00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03
oalO00dO00?o0000100000H000?o00003002o`T01Ml00ol0000800GO00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?ogml00ml400GO00?o00002005g`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@000060003o`0000`0
0_l:00CO00?o00002@04g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0=7`03omoO00;O1P04g`03o`0000T01=l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o00?O00002003g`03oml000X00ml00olO
7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al01?oOgml800?O00?og`00
2P03g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03oml000@0
00060?oo3?l00ml0000300001P000ol0000<00;o0ml:0003golO00hO00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al031l00olO7`0=7`04omoOg`T00ml00olO7`0<7`04omoOg`/000?Ooal03Ql00olO
7`0<7`03oalO00dO00?o7al031l01?oOgml;0003golO00hO00?og`00100000H000?o00003002o`CO
2P000olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00ooOg`02g`L0
1=l00olO7`0<7`03omoO00;O2`000olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03omoO00;O
2`000olO7`0=7`03o`0000@000060003o`0000`00_l5g`T000?o7al03Al00olO7`0=7`03oalO00`O
00?o7al03Al00olO7`0<7`03oalO00dO00?ogml00ml500GO00?o7al031l00ooOg`03g`X000?o7al0
3Al00olO7`0<7`03oalO00dO00?o7al031l00ooOg`03g`X000?o7al03Al00ol0000400001P001?l0
0003o`P00_l00`3Og`03o`P000Co7alO0ol97`Co31l3o``O00Co7alO0ol97`04oalO7`?o21l4o``O
1?l3g`<01Ml0103o7al3o`TO00Co0=oO0ol90004oalO7`?o2Al3o``O00Co7alO0ol97`04oalO7`?o
21l4o`?O2@04o``O00?o0000100000H000?o000010000ol0000500;o0P04g`03o`0000D000?o7al0
11l00olO7`067`05oalO7ol02al01?lO7ol;7`03oalO00@O00?o7al01Ql00olO7`047`03oalO00DO
00Go7alOo`0;7`05o`00gol00ml00`3Og`03g`8000?o7al00al00olO7`067`03o`0000CO00?o0000
1P000olO7`047`03oalO00HO00Co7aoo2al00olO7`047`03oalO00HO00?o7al011l00olO7`057`05
o`00gol00ml80005oalO7ol02al00ol0000400001P001?l00004o`800_l300;o0`04o`04goooo`<0
00Co7alO1?l27`;o11l5o`047oooo`<O0ol00aooo`02o`047oooo`@O0_l00aoo7`027`Co00<Oool0
0_l37`04oalO7`Co00@Ooooo0al5o`047oooo`<O2Ol01=ooool3g`?o00@0oalO1?l011ooool47`04
o`0000Co00CO0?oo10001?lO7al4o`047oooo`@O1?l011ooool47`Co0al4o`8O0ol37`04oalO7`Co
0Ql00olO7`027`Go00COoooo1002o`030?oo00?o00@Ooooo0al3o`037ol000D000060004o`00o`<0
00?o0?l00P000ol00002o`8000Go0=oOo`02g`03o`00008000Co7aoo0al00olOo`027`05oalO7ol0
0al01?lO7ol57`04oaooo`8O00Co7aoo11l00olO7`02o`8O00Go7alOo`027`03oalO00<O00Co7aoo
0al00olO7`027`04oalOo`<O00Co7aoo1Al01?lO7ol30004omoOo`CO0`02o`037olO008O00?o7al0
0Ql01OlO7aoo008000Oo0=oOomoo008000Go0000o`027`05oalO7ol011l00olO7`02o`8O00Co7aoo
1Ql00olOo`027`05oalO7ol00al00olO7`027`04oalOo`<O00Co7aoo11l01Ol0003o00;O00?ogml0
0P000ol00002o`<O00Co7aoo1al2o`H000060004o`00o`<000?o0?l00P000ol00002o`8000Go003O
o`02g`03o`00008000Co7aoo0al00olOo`027`05oalO7ol00al01?lO7ol57`04oaooo`8O00Co7aoo
11l00olO7`02o`8O00Go7alOo`037`03oalO008O00Co7aoo0al00olO7`027`04oalOo`<O00Co7aoo
1Ql00olOo`030004o`3Oo`?O1002o`037olO008O00?o7al00Ql01OlO7aoo008000[o003Oomoog`3o
0`001?lO7ol37`03oalO00?o0Ql2o`8O00Co7aoo11l5o`8O00Ko7alOoal4o`<O00Co7aoo0al01OlO
7aoo00<O00So0000o`3Oo`?O00@0o`000_l37`04oalOo`LO0_l600001P001?l00?l30003o`0000;o
0`02o`8000Go0000o`02g`03oml0008000Co7aoo0al00olOo`02o`@O00Go7alOo`027`03oalO00<O
00Co7ooo0Ql01?lO7ol47`?o00DOoalOo`037`03oalO008O00Go7alOo`027`06oalO7olO0ol37`05
oalO7ol00Ql00olO7`057`;o0`001?oOgol4g`?o00@0oaoo0al00olO7`02o`@O00Co003o0`000ooO
g`02o`@000Co7aoo0al00olOo`027`03oalO00;o0Ql01?lO7ol47`05oaoo7ol00Ql02OlO7aoo7olO
o`047`04oalOo`<O00Go7alOo`037`05o`000?l00P000ooOg`02g`03o`0000;o0al01?lO7ol57`;o
00<Oo`001@0000H000Co00001_l20003o`0000;o0`05o`04gooOg`8000Co7alO1_l67`Ko00<Ooal0
11l00olO7`05o`037olO00<O00Go7alOo`037`Ko0Ql01OlO7aoo00<O1_l57`Ko00<Ooal00al00olO
7`07o`03gooO00?O00Go0000o`027`Go0al01OlO7aoo00<01_l2g`05o`000?l00al6o`8O00Co7alO
1Ol00aoo7`037`05oaoo7ol00al6o`037olO00<O00Co7alO1Ol37`03oalO00Ko00<0oml00ml00ol0
0007o`037olO00HO0_l600001P000ol0000700;o0`02o`P00_l3g`030?lO00PO0ol37`03oalO00<O
0_l47`;o0Ql00olO7`027`;o1Al4o`TO0_l47`03oalO00HO1?l27`03oalO00<O0_l57`;o00@Oo`00
0ml2o`040=oOg`Go1al3o`@O00?o00001P000mooo`02g`8000?o7al01al2o`@O00?o7al00Ql2o`DO
0_l00aoo7`087`;o11l00olO7`067`Co0Ql00ol0000300;o00<0gml00]l2o`030?lO00@O0_l47`?o
00<Oo`001@0000H000?o00003002o`T01Ml00olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03
oalO00`O00?o7al03Al00ol0g`04g`<01Ml00`3o7`0=7`03o`0000L01Ml00`3o7`0>7`03oalO00`O
00?o7al03Al00olO7`0<7`03o`0000L01Ml00`3o7`0>7`03o`0000@000060003o`0000`00_l:00CO
00?o7al03Al00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?ogml00ml500GO
00?o7al031l00ol0000800GO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00ol0000800GO
00?o7al03Al00ol0000400001P000ol0000<00;o2`03g`03oalO00dO00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al031l00olO7`0=7`03omoO00;O1`04g`03oalO00`O00?og`002@04g`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00`O00?og`002@04g`03oalO00dO00?o0000100000H000?o0000
3002o`03g`0000T00]l00olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al0
3Al01?oOgml900?O00?o7al031l00ooOg`0:00?O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al0
31l00ooOg`0:00?O00?o7al03Al00ooO000400001P3oo`co00?O00000`0000H000?o00003002o`?O
2`000olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?ogml00]l800?O00?o7al0
3Al00olO7`0<7`03omoO00;O2P000moo7`0>7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO
00CogmoO2`000moog`0500001P000ol0000<00;o1=l:0003oalO00dO00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al031l00ooOg`03g`H01=l00olO7`0=7`03oalO00`O00?ogml00ml:0003oalO00dO
00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00ooOg`02g`/000?o0000100000H000?o0000
3002o`GO2@000olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o0=l01=l400GO
00?o7al03Al00olO7`0<7`03o`3O00CO2@000olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03
oalO00dO00?ogml00ml:0003o`0000@000060004o`0000?o2002o`030=oO00?o20001?lO7al3o`TO
00Co7alO0ol97`?o31l01?lO7al3o`TO00Co7alO0ol87`Co1=l200GO00<0ool00_l<7`03oalO00?o
2Al01?l00=l3o`03g`0000H01?l<7`?o31l01?lO7al3o`TO00Co7alO0ol87`Co31l4o`?O2@000ol0
000400001P000ol000040003o`0000D00_l200CO00?o00001@000olO7`047`03oalO00HO00?o7al0
11l00olO7`067`04oalOo`/O00?o7al011l00olO7`067`03oalO00@O00?o7al01Al01Ol0003o00WO
0P001OlO7aoo00/O00?o7al00al00olO7`067`04o`0000?O00?og`001P001OlO7aoo00/O00Co7aoo
2al00olO7`047`03oalO00HO00?o7al011l00olO7`057`05oalO7ol02al01Ol00=oo00?O20000ol0
000400001P001?l00004o`8000?o00000P02o`<01?l01=ooool30004oalO7`Co00@Ooooo11l01?lO
7al4o`047oooo`@O1?l011ooool37`?o00<Ooal00Ql4o`037ooo00;o0al01?lO7al4o`8O0_l37`Go
00COoooo1=l2o`030?oo00?o00@Ooooo11l4o`8O1?l011ooool47`04o`0000Co0]l00ol0000300Go
00@Ooooo0al3o`037ooo00;o00@Ooooo0al3o`037olO008O1?l27`?o0al01?lO7al4o`8O0_l37`Go
00@Ooooo0al9o`04goooo`@00_l00`3o000500001P001?l00?l30004o`00o`@00_l20005o`3Ogol0
0]l00ol000020004oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alOo`047`03oalO00;o0Ql01?lO
7ol77`;o0Ql01OlO7aoo008O00?o7al00al01?lO7ol37`03oaoo008O00Co7aoo0`001?l0gol4g`03
o`0000;o0al01?lO7ol67`05oaoo7ol00al00olO7`027`05oalO7ol00P001Ol00=oo00;O00?o0000
0`001OlO7aoo008O00?o7al00al01?lOool27`04oalOo`LO0_l27`05oalO7ol00al00olO7`027`04
oalOo`<O00?o7ol00Ql01?lO7ol37`04oalOo`DO00Co7aoo0`001?oOgol2g`8000?o00000_l60000
1P001?l00?l30005o`000?l00`02o`8000Go003Oo`02g`03o`00008000Co7aoo0al00olO7`027`05
oalO7ol00Ql01OlO7aoo008O0ol27`;o0Ql01?lO7ol77`;o0Ql01OlO7aoo00<O00?o7al00Ql01?lO
7ol37`03oaoo008O00Co7aoo0`001?l0gol4g`03o`0000;o0al01?lO7ol47`Go00<Ooal00Ql00olO
7`027`05oalO7ol00P001Ol0003o00?O00?o00000P001OlO7aoo008O00?o7al00al01?lOool27`04
oalOo`LO0_l27`06oalO7olO1?l37`04oalOo`<O00?o7ol00Ql01?lO7ol37`04oalOo`HO00?o7ol0
0`001?l0gol3g`040?l000;o1P0000H000Co003o0`001Ol0003o00<00_l20005o`000?l00]l00ooO
00020004oalOo`<O00?o7ol00_l47`04oalOo`<O00?o7ol00Ql00olO7`02o`8O00Co7aoo1Al2o`05
7olO7ol00al00olO7`027`05oalO7ol00Ql01_lO7aoo7`?o0al01Ol0003o00;O00?ogml00]l00ol0
0002o`<O00Co7aoo11l01olOoaoo7ol00al00olO7`02o`@O00Co003o0`001_oOgmoog`<000Go7alO
o`027`03oalO00<O00Co7ooo0Ql01?lO7ol47`?o00DOoalOo`037`05oaoo7ol011l01?lO7ol37`03
oalO00;o0al01OlO7aoo008O00?o7al01Al2o`<000Co003o1=l3o`030?l000D000060004o`0000Go
0`000ol00002o`<01Ol01=oogml20004oalO7`Ko1Ql01?lO7al6o`8O00Co7alO1Ol00aoo7`067`;o
0al6o`8O00Go7alOo`037`Ko1Al6o`03gooO00?O00?og`001ol00aoo7`037`05oaoo7ol00Ql5o`<O
00Go7alOo`0300Go0ml01?oO0006o`037olO00@O00?o7al01Ol00aoo7`037`05oalO7ol00al6o`03
7olO00<O00Co7alO1_l27`03oalO00Ko00<Ooal00al00olO7`07o`030?oO00?O00Go0000o`060000
1P000ol0000600Co0P02o`P00_l3g`030?lO00LO1?l37`03oalO00LO0_l47`03oalO008O0_l47`?o
00<Ooal021l2o`@O00?o7al01al3o`8O00?o00000ml2o`800ml2o`030?lO00@O0_l57`;o00<Ooal0
1Ql3o`@O00?o00001P04o`;O00<0oal011l2o`@O0_l27`03oalO008O0_l47`Go2Al2o`@O00?o7al0
1al2o`<O00?o7al00al2o`DO0_l00aoo000400;o00<0gml00]l4o`H000060003o`0000`00_l900GO
00?o7al03Al00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03o`3O00CO1005g`03oalO00dO
00?o7al031l00ol0000800GO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03
o`0000L01Ml00`3o000500001P000ol0000<00;o2P04g`03oalO00dO00?o7al03Al00olO7`0<7`03
oalO00dO00?o7al031l00ooOg`03g`H01=l00olO7`0=7`03oalO00`O00?o00002@04g`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00ol0000800GO00?o0000100000H000?o0000
3002o`/00ml00olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?ogml00]l800?O
00?o7al03Al00olO7`0<7`03oml000X00ml00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03
oalO00dO00?og`002@04g`03o`0000@000060003o`0000`00_l00ml0000900;O00?o7al03Al00olO
7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`04omoOg`X00]l00olO7`0=7`03oalO00`O00?ogml0
2`02g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00ooOg`0:00?O00?og`00
100000H0ool<o`03g`0000<000060003o`0000`00_l3g`/000?o7al03Al00olO7`0=7`03oalO00`O
00?o7al03Al00ooOg`02g`L00ml00olO7`0=7`03oalO00dO00?o7al031l00ooOg`02g`/000?o7al0
3Al00olO7`0<7`03omoO00;O2`000olO7`0<7`03oalO00dO00?o7al03Al00ooO000400001P000ol0
000<00;o1=l:0003oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?ogml00ml500CO00?o7al0
3Al00olO7`0=7`03oalO00`O00?ogml00ml:0003oalO00dO00?o7al031l00ooOg`03g`X000?o7al0
31l00olO7`0=7`03oalO00dO00?o0000100000H000Co00000ol800;o0ml3o`P000Co7alO0ol97`Co
31l3o``O00Co7alO0ol97`04o`3Og`?o0`05g`Co31l4o``O00?o7al00ol97`04o`3Og`?o2@04o``O
0ol<7`04o`3Og`?o2@001?lO7al3o`PO1?l<7`Co31l00ol0000400001P000ol000040003o`0000D0
0_l00`3Og`03g`03o`0000D000?o7al011l00olO7`067`05oalO7ol02al01?lO7ol;7`03oalO00@O
00?o7al01Ql00ol00004g`03o`3O00CO00<0oal00Ql00olO7`097`05oalO7ol02al00olO7`037`03
oalO00HO00?o00001=l00ol000060005oalO7ol02al01?lO7ol;7`03o`0000CO00?o00001P000olO
7`047`03oalO00DO00Go7alOo`0;7`05oalO7ol02al00ol0000400001P001?l00004o`800_l300;o
0P000mooo`02o`040?ooo`<000Co7alO1?l27`;o11l5o`047oooo`<O0ol00aooo`02o`047oooo`@O
0_l00aoo7`027`Co00@Ooooo11l01?l00004o`;O0_l00ml00005o`047oooo`<O0ol00aooo`03o`04
7oooo`@O0_l011oo7al4o`047oooo`@O00Co00001?l01=l0ool400Go00@Ooooo0al3o`037ooo00;o
00@Ooooo11l2o`037ol000801?l01=ooool40004oalO7`Co0Ql2o`<O1Ol011ooool37`?o00<Oool0
0ol011ooool47`;o00<Oo`001@0000H000Co003o0`000ol0o`020003o`0000;o0P002?oOgmoog`3o
10001?lO7ol37`03oaoo008O00Go7alOo`037`04oalOo`DO00Co7ooo0Ql01?lO7ol47`03oalO00;o
0Ql01OlO7aoo008O00?o7al00al01Ol00?l000;O00?ogol00]l01?l00?l37`04oalOo`DO00Co7aoo
0al01?lO7ol47`03oalO00;o00<Ooal00Ql01?lO7ol57`05o`00o`000]l00ooOo`020005o`000?l0
0al01?lO7ol57`04oaooo`8O00Co7aoo11l00olO7`02o`8000Go0=oOo`02g`03o`0000<000Co7aoo
0al00olOo`027`04oalOo`<O00Co7aoo1Al01?lO7ol37`04oalOo`@O00?o7al00_l600001P001?l0
0?l30003o`3o008000?o00000_l20005o`3Ogol00]l00ol000020004oalOo`<O00?o7ol00Ql01OlO
7aoo00<O00Co7aoo1Al01?lOool27`04oalOo`@O00?o7al00_l27`05oalO7ol00Ql00olO7`037`04
o`00o`8000OOomoog`3o008000Go7alOo`027`03oalO00<O00Co7aoo0al01?lO7ol47`03oalO00;o
00<Ooal00Ql01?lO7ol57`04o`00o`8000OOomoog`3o00<000Go7alOo`027`03oalO00<O00Co7ooo
0Ql01?lO7ol47`03oalO00;o0P001Ol00=oo00;O00?o00000`001?lO7ol37`03oaoo008O00Co7aoo
0al01?lO7ol57`04oalOo`<O00Co7aoo11l00olO7`02o`H000060004o`00o`<000?o0?l00_l300;o
0P001Ol00=oo00;O00?o00000P001?lO7ol37`03oaoo00;o11l01OlO7aoo008O00?o7al00al01?lO
ool27`04oalOo`@O0ol01Aoo7aoo00<O00Co7aoo1Al01Ol00?l000;O00?ogol00_l30005oalO7ol0
0Ql00olO7`037`04oalOo`<O00Co7aoo11l3o`047olOo`<O00Co7aoo1Al01?l00?l30003omoo00;o
10001OlO7aoo008O00?o7al00al01?lOool27`04oalOo`@O0ol01Aoo003o00<000Gogmoog`040004
oalOo`<O00?o7ol00_l37`05oalO7ol00Ql00olO7`037`04oalOo`<O00Co7aoo11l3o`037ol000D0
00060004o`0000Ko1@02o`<01Ol00moog`030004oalO7`Ko1Ql6o`037olO00@O00?o7al01Ol00aoo
7`037`05oalO7ol00al5o`037olO00@O00Co00001_l3g`801_l00aoo7`047`03oalO00Ko00<Ooal0
0al01OlO7aoo008O1Ol00aoo7`047`04o`0000Ko0ml300Ko00<Ooal011l00olO7`05o`037olO00<O
00Go7alOo`0300Go00COomoO0`001?lO7al6o`DO1_l00aoo7`047`03oalO00Ko00<Ooal00al01OlO
7aoo00H000060003o`0000L00ol200;o1`000mooo`02g`8000?o7al01al3o`<O00?o7al00al2o`@O
0_l27`03oalO008O0_l57`Co21l2o`DO00?o00001Ml00`3Oo`02o`03g`3o00DO0_l47`;o0Ql00olO
7`037`;o1Al4o`LO0_l57`03o`0000H000GOoooog`020003oalO00<O0_l47`;o0Ql00olO7`027`;o
1Al4o`P00_l3g`8000?o7al01al3o`8O00?o7al00al2o`@O0_l27`03oalO00<O0_l57`Co1P0000H0
00?o00003002o`P01Ml00`3o7`0>7`03oalO00dO00?o7al031l00olO7`0=7`03o`3O00CO0`05g`03
oalO00dO00?o7al03Al00olO7`0<7`03o`0000L01Ml00`3o7`0>7`03oalO00`O00?o00001`05g`03
0?lO00dO00?o7al03Al00olO7`0=7`03o`0000@000060003o`0000`00_l900GO00?o7al03Al00olO
7`0=7`03oalO00`O00?o7al03Al00ooOg`03g`D01=l00olO7`0=7`03oalO00dO00?o7al031l00ol0
000800GO00?o7al03Al00olO7`0<7`03o`0000P01Ml00olO7`0<7`03oalO00dO00?o7al03Al00ol0
000400001P000ol0000<00;o2P04g`03oalO00dO00?o7al03Al00olO7`0<7`03oalO00dO00?ogml0
0]l700?O00?o7al03Al00olO7`0=7`03oalO00`O00?o00002@04g`03oalO00dO00?o7al031l00ol0
000900CO00?o7al031l00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`03g`0000P0
0ml00olO7`0=7`03oalO00dO00?o7al031l00olO7`0=7`04omoOg`T00]l00olO7`0=7`03oalO00dO
00?o7al031l00ooO000:00?O00?o7al03Al00olO7`0<7`03oml000X00ml00olO7`0<7`03oalO00dO
00?o7al03Al00ooO000400001P3oo`co00?O00000`0000H000?o00003002o`?O2P000moo7`0>7`03
oalO00dO00?o7al031l01?oOgml900?O00?o7al031l00olO7`0=7`03oalO00dO00?o7al031l01?oO
gml;0003golO00hO00?o7al031l00olO7`0=7`04omoOg`/000?o7al03Al00olO7`0=7`03oml000@0
00060003o`0000`00_l4g`X000?o7al03Al00olO7`0=7`03oalO00`O00?ogml00]l700CO00?o7al0
31l00olO7`0=7`03oalO00dO00?o7al031l00ooOg`02g`/000?o7al03Al00olO7`0<7`03oalO00dO
00?ogml00]l:0003oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o1Ml90003oalO00dO
00?o7al03Al00olO7`0<7`03omoO00?O1@05g`03oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O
00?ogml00ml:0003oalO00dO00?o7al031l00olO7`0=7`03omoO00?O2@000olO7`0=7`03oalO00dO
00?o0000100000H000Co00000ol800;o00<0gml00ol80004oalO7`?o2Al01?lO7al3o`TO0ol<7`04
o`3Og`?o0`05g`030?lO008O0ol87`04oalO7`?o2Al4o``O00?o7al00ol97`04o`3Og`?o2@001?lO
7al3o`TO0ol<7`04oalO7`?o2Al01?l0gml3o`P000Co7alO0ol97`Co31l00ol0000400001P000ol0
00040003o`0000D00_l200CO00?o00001@000olO7`047`03oalO00HO00?o7al011l00olO7`067`04
oalOo`/O00?o00001=l00ol0g`04g`8000?o7al011l00olO7`057`03oalO00@O00?o7al01Ql01OlO
7aoo00/O00?o7al00al00olO7`067`03o`0000CO00?o00001P000olO7`047`03oalO00HO00Co7aoo
2al00olO7`047`03oalO00HO00?o00001=l00ol000050003oalO00@O00?o7al01Ql01OlO7aoo00/O
00?o0000100000H000Co00001?l0103oool300;o0`04o`04goooo`<000Co7alO1?l011ooool47`04
oalO7`Co00@Ooooo11l4o`047oooo`<O0ol00aoo000200Co00GOoooog`030004oalO7`Co00@Ooooo
0al01?lO7al4o`047oooo`@O1Ol011ooool37`?o00@OoalO1?l011ooool47`04o`0000Co00COoooo
10001?lO7al4o`047oooo`@O1?l011ooool37`?o00<Ooal00Ql4o`047oooo`@O00Co00001?l01=oo
ool30004oalO7`Co00@Ooooo11l5o`047oooo`<O0ol00aoo000500001P001?l00?l30003o`000080
00?o00000_l20005o`3Ogol00]l00ol000020004oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alO
o`047`03oalO00;o0Ql01?lO7ol77`;o0P001Ol0gmoo00;O00?og`000`001?lO7ol37`03oalO008O
00Co7aoo0Ql01OlO7aoo00@O00Go7alOo`037`04oalOo`LO0_l00aoo7`027`04oalOo`DO00Go003o
0002g`03omoO008000Go0000o`027`05oalO7ol011l00olO7`02o`8O00Co7aoo1al2o`8O00Go7alO
o`027`03oalO00<O00Go003o0002g`03omoO008000Co003o0Ql01OlO7aoo00@O00Go7alOo`037`04
oalOo`LO0_l600001P001?l00?l30003o`00008000?o00000_l20005o`00gol00]l00ol000020004
oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alOo`027`?o0Ql2o`8O00Co7aoo1al2o`8000Go003O
o`02g`03o`0000<000Co7aoo0al00olO7`027`04oalOo`8O00Go7alOo`027`?o0al01OlO7aoo008O
00?o7al01Al2o`037olO008O00Co7aoo1Al01?l00?l20003gooO00;O00<0o`000P001?lO7ol37`03
oalO00?o0Ql2o`8O00Co7aoo1al2o`8O00Go7alOo`027`03oalO00<O00Co003o0P000moog`02g`05
0?l00?l00Ql01OlO7aoo008O0ol37`05oalO7ol00Ql00olO7`057`;o1P0000H000Co003o0`000ol0
o`02o`<00_l20005o`000?l00]l00ooO00020004oalOo`<O00?o7ol00_l47`04oalOo`<O00?o7ol0
0Ql00olO7`02o`8O00Co7aoo1Al2o`067ol00?l00]l01OoOgooO00@000Co7aoo0al00olOo`02o`<O
00Co7aoo0al00olOo`027`05oalO7ol00al01?lO7ol57`;o00@Ooaoo0al01?lO7ol57`04o`00o`<0
00?ogol00_l40004oalOo`<O00?o7ol00Ql00olO7`02o`8O00Co7aoo1Al2o`057olO7ol00al01?lO
7ol57`04o`00o`<000?ogol00_l30004oalOo`<O00?o7ol00Ql01OlO7aoo00<O00Co7aoo1Al2o`03
7ol000D000060004o`0000Ko1@02o`<01Ol01=oogml20004oalO7`Ko1Ql01?lO7al6o`8O00Co7alO
1Ol00aoo7`067`;o0`05o`04gooOg`<000Co7alO1_l57`04oalO7`Ko0Ql01?lO7al6o`037olO00HO
0_l27`Go00<Ooal011l01?l00006o`?O0`001?lO7al6o`8O00Co7alO1Ol00aoo7`067`;o0al5o`03
7olO00@O00Co00001_l3g`8000Co7alO1_l27`04oalO7`Ko00<Ooal01Ql2o`H000060003o`0000H0
1?l200;o2002o`?O00<0oal01al4o`<O00?o7al01al2o`@O00?o7al00Ql2o`@O0ol011oo0005g`03
0?oo00?O0P000olO7`067`Co0Ql00olO7`077`;o11l00olO7`037`;o11l3o`037olO00HO0_l57`03
o`0000H01?l01=l00?l97`;o11l00olO7`027`;o11l3o`037olO00LO0_l57`03o`0000H01?l00ml0
o`097`;o11l00olO7`037`;o11l3o`037ol000D000060003o`0000`00_l900GO00?o7al03Al00olO
7`0=7`03oalO00`O00?o0=l01=l300GO00<0oal03Al00olO7`0=7`03oalO00dO00?o7al031l00ol0
000700GO00<0oal03Ql00olO7`0<7`03oalO00dO00?o00001`05g`03oalO00dO00?o7al03Al00ol0
000400001P000ol0000<00;o2P04g`03oalO00dO00?o7al03Al00olO7`0<7`03omoO00?O1@05g`03
oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O00?o00002005g`03oalO00dO00?o7al031l00olO
7`0=7`03o`0000P01=l00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`/00ml00olO
7`0=7`03oalO00dO00?o7al031l00ooOg`02g`L01=l00olO7`0<7`03oalO00dO00?o7al03Al00olO
7`0<7`03oml000T01=l00olO7`0=7`03oalO00`O00?o7al03Al00ol0000900?O00?o7al03Al00olO
7`0=7`03o`0000@000060003o`0000`00_l00ml0000900;O00?o7al03Al00olO7`0=7`03oalO00`O
00CogmoO2@03g`03oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O00?ogml02P03g`03oalO00dO
00?o7al031l00olO7`0=7`03oml000X00]l00olO7`0=7`03oalO00dO00?og`00100000H0ool<o`03
g`0000<000060003o`0000`00_l3g`/000?o7al03Al00olO7`0=7`04omoOg`P00ml00olO7`0=7`03
oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O00?ogml00]l:0003gooO00;O2`000moo7`0=7`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?og`00100000H000?o00003002o`CO2P000olO
7`0=7`03oalO00dO00?ogml00]l600CO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00olO
7`0<7`03omoO00?O2P000ooOg`02g`/000?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0=7`03o`0000@000060003o`0000`00_l5g`T000?o7al03Al00olO7`0=7`03omoO00?O1005g`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o7al031l00ol0g`04g`T000?ogml00ml:0003
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ol0000400001P001?l00003o`P0
0_l00`3Og`03o`P000Co7alO0ol97`04oalO7`?o2Al00ol0g`03o`03g`0000GO00<0oal00Ql3o`TO
00Co7alO0ol87`04oalO7`?o2Al01?lO7al3o`TO00?o7al00ol97`04o`00g`?o00?O00001P001?l0
gml3o`T000?o7al00ol97`04oalO7`?o2Al01?lO7al3o`PO00Co7alO0ol97`04oalO7`?o2Al00ol0
000400001P000ol000040003o`0000D00_l200CO00?o00001@000olO7`047`03oalO00HO00?o7al0
11l00olO7`067`03o`0000?O00?ogml01=l20003oalO00@O00?o7al01Ql00olO7`047`03oalO00DO
00?o7al011l00olO7`067`03oalO00@O00?o7al01Ql00olO7`037`03oalO00HO00Co00000ml00ooO
00060003o`0000CO00?o00001P000olO7`037`03oalO00HO00?o7al011l00olO7`067`03oalO00@O
00?o7al01Al00olO7`047`03oalO00HO00?o7al011l00olO7`067`03o`0000@000060004o`0000Co
0P03o`800_l300Co00COoooo0`001?lO7al4o`037ooo00;o0al01?lO7al4o`047oooo`@O00?o0000
1?l2g`?o0`001?lO7al4o`037ooo00;o0al01?lO7al4o`047oooo`<O00Co7alO1?l27`?o0al01?lO
7al4o`047oooo`@O00?o7al01?l011ooool47`04o`0000Co0]l3o`<000Co00001?l01=ooool40003
oalO00Co00<Oool00_l37`04oalO7`Co0Ql3o`<O00Co7alO1?l011ooool37`04oalO7`Co00<Oool0
0_l37`04oalO7`Co00@Ooooo11l00ol0000400001P001?l00?l30005o`000?l00`02o`8000Go0=oO
o`02g`03o`00008000Co7aoo0al01?lO7ol57`04oalOo`<O00?o7al00Ql01olO7aoo0?l00P000moo
g`02g`03o`00008000Co7aoo0al01?lO7ol57`04oalOo`<O00Co7aoo11l01?lO7ol37`05oalO7ol0
11l01?lO7ol37`03oalO008O00Oo7alOoaoo00<O00?o7al00Ql01OlO7aoo008000Go003Oo`03g`03
o`00008000Go003o0002g`04omoOo`D000?o7ol00al01?lO7ol57`04oalOo`<O00Go7alOo`047`04
oalOo`<O00?o7al00Ql01?lO7ol27`05oalO7ol00Ql00olO7`037`04oalOo`<O00Co7aoo1Al00ol0
000400001P001?l00?l30003o`3o00?o0P02o`8000Go003Oo`02g`03o`00008000Co7aoo0al01OlO
7aoo00@O00Co7aoo0al00olO7`027`07oalO7ol0o`020003gooO00Co0`001?lO7ol37`05oalO7ol0
11l01?lO7ol37`04oalOo`@O00Co7aoo0al00olOo`03o`<O00Co7aoo0al00olO7`027`07oalO7olO
o`037`03oalO008O00Go7alOo`020006o`000?oO1?l30004o`00o`8000GOomoOo`050003oaoo00<O
00Go7alOo`047`04oalOo`<O00?o7ol00ol37`04oalOo`<O00?o7al00Ql01?lO7ol27`05oalO7ol0
0al00olO7`027`04oalOo`<O00Co7aoo1Al00ol0000400001P001?l00?l30005o`3o0?l00`02o`80
00Go0000o`02g`03oml0008000Co7aoo0al00olO7`027`05oalO7ol00Ql01OlO7aoo008O0_l47`04
o`3o00;O00KogooOoml30004oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alOo`027`03oalO008O
00Co7aoo0al01OlOoaoo00@O00Co7aoo0al00olO7`02o`@O00?o7ol00al00olO7`02o`@O00Co003o
0`001_oOomoog`<000Co003o0`001OoOgooO00@000?o7ol00al00olO7`027`05oalO7ol00Ql02OlO
7aoo7olOo`047`04oalOo`<O00?o7al00_l37`04oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alO
o`027`03oalO00<O00?o0000100000H000Co00001_l00`3o000200;o0`05o`04gooOg`8000Co7alO
1_l27`05oalO7ol00al5o`<O00Go7alOo`0200Ko00COomoO0P001?lO7al6o`8O00Go7alOo`037`Go
00<Ooal00al01?lO7al6o`037olO00<O00Co7alO1Ol37`05oalO7ol00Ql5o`<O00Go7alOo`0300Ko
00COomoO0P001?l00005o`04gooOg`<000?o7al01_l27`05oalO7ol00al6o`037olO00<O00Co7alO
1Ol37`04oalOo`<O1_l27`05oalO7ol00al5o`037olO00@O00?o0000100000H000?o00001`02o`<0
0_l800;o0ml00`3o7`087`;o11l00olO7`067`?o11l00ol0g`04g`800_l3g`030?lO00PO0_l47`03
oalO00HO0_l47`03oalO00LO0_l47`03oalO00HO0ol47`03oalO00DO0ol47`03o`0000L00_l3g`03
0?l000L00_l3g`8000?o7al01Ql2o`@O00?o7al01al2o`@O00?o7al01Ql3o`<O00?o7al01al2o`@O
00?o7al01Ql2o`DO00?o0000100000H000?o00003002o`T01Ml00olO7`0=7`03oalO00dO00?ogml0
0ml400GO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`03o`0000P01Ml00ol0
000700GO00<0oal03Al00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@000060003
o`0000`00_l:00CO00?o7al03Al00olO7`0=7`03omoO00;O1P04g`03oalO00dO00?o7al031l00olO
7`0=7`03oalO00dO00?o7al031l00ol0000900CO00?o00002005g`03oalO00`O00?o7al03Al00olO
7`0<7`03oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o00?O00002003g`03oalO00dO
00?o7al03Al01?oOgml800?O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`03
oml000X00ml00ooO000900CO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03
oml000@000060?oo3?l00ml0000300001P000ol0000<00;o0ml:0003golO00hO00CogmoO2@03g`03
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`04omoOg`/000?Ooal0
3Ql00ooOg`0;0003golO00hO00?o7al031l00olO7`0=7`03oalO00dO00?og`00100000H000?o0000
3002o`CO2P000olO7`0=7`03omoO00;O1`04g`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO
00?o7al03Al00olO7`0<7`03omoO00;O2`000olO7`0=7`04omoOg`/000?o7al03Al00olO7`0<7`03
oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o1Ml90003oalO00dO00?ogml00ml500GO
00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03oalO00`O00?ogml00ml:0003
oalO00dO00?ogml00]l:0003oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o0000100000H0
00Co00000ol800;o00<0gml00ol80004oalO7`?o2Al01?l0gml3o`<01Ml0103o7al3o`TO00Co7alO
0ol97`04oalO7`?o21l01?lO7al3o`TO00Co7alO0ol97`03oalO00?o2Al01?l0gml3o`T000Co7alO
0ol97`03omoO00?o2@001?lO7al3o`TO00Co7alO0ol87`04oalO7`?o2Al01?lO7al3o`TO00?o0000
100000H000?o000010000ol0000500;o0P04g`03o`0000D000?o7al011l00olO7`067`03o`0000CO
00?o0=l01=l20003oalO00<O00?o7al01Ql00olO7`047`03oalO00HO00?o7al011l00olO7`057`03
oalO00@O00?o7al01Ql00olO7`047`03oalO00HO00?o7al00al00olO7`067`03o`0000CO00?o0000
1P000olO7`047`03oalO00HO00?o0=l00ml00ol000060003oalO00@O00?o7al01Ql00olO7`047`03
oalO00DO00?o7al011l00olO7`067`03oalO00@O00?o7al01Ql00ol0000400001P001?l00004o`04
0?ooo`<00_l300Co00COoooo0`001?lO7al4o`047oooo`@O00Co00001?l01MoooooO00<000?o7al0
1?l011ooool47`04oalO7`Co00<Oool00_l37`04oalO7`Co00<Oool00_l27`04oalO7`Co00<Oool0
0_l37`04oalO7`Co00<Oool00_l37`03oalO00Co00@Ooooo11l01?l00004o`04goooo`@000Co7alO
1?l011ooool47`03o`0000Co00COoooo10001?lO7al4o`8O0ol37`04oalO7`Co0Ql3o`8O00Co7alO
1?l27`?o0al01?lO7al4o`8O0ol37`03o`0000@000060004o`00o`<000?o00000P000ol00002o`80
00Go0=oOo`02g`03o`00008000Co7aoo0al01?lO7ol57`05o`00o`000]l01OoOgooO00@000?o7ol0
0al01?lO7ol57`04oalOo`<O00Co7aoo1Al01?lO7ol37`04oalOo`@O00Co7aoo0al01?lO7ol57`04
oalOo`<O00Co7aoo1Al00olOo`037`03oalO008O00Go7alOo`020005o`3Ogol00]l20005o`000?l0
0Ql01OlO7aoo00@O00So7alOo`3o00;O00?ogml00P001Ol0003o008O00Go7alOo`037`03oalO008O
00Co7aoo0al01OlO7aoo00<O00Co7aoo0al01OlO7aoo00@O00Co7aoo0al01OlO7aoo00@O00?o0000
100000H000Co003o0`000ol000020003o`0000;o0P001Ol00=oo00;O00?o00000P001?lO7ol37`04
oalOo`DO00Co003o0P001Moogmoo00D000?o7ol00al01?lO7ol57`04oalOo`<O00Go7alOo`047`04
oalOo`<O00Go7alOo`037`04oalOo`<O00Go7alOo`047`04oalOo`<O00Go7alOo`047`03oaoo00<O
00?o7al00Ql01OlO7aoo008000Go003Oo`03g`030?l0008000Co7aoo0al00olO7`027`07oalO7ol0
o`020003gooO00;O00<0o`000P001?lO7ol37`03oaoo00?o0al01?lO7ol37`03oaoo00?o0Ql01?lO
7ol37`03oaoo00?o0al01?lO7ol37`03oaoo00?o0al00ol0000400001P001?l00?l30003o`0000;o
0`02o`8000Go0000o`02g`03oml0008000Co7aoo0al01?lO7ol57`05o`00o`000]l01OoOgooO00@0
00?o7ol00al01?lO7ol57`04oalOo`<O00?o7al00Ql01OlO7aoo008O00Go7alOo`047`04oalOo`8O
00Go7alOo`047`05oalO7ol00Ql01OlO7aoo00@O00Oo7alOoaoo00<O00?o7al00_l47`04o`00o`<0
00?ogml00_l40004oalOo`<O00?o7al00_l47`03o`3o00<000?ogml00_l40004oalOo`<O00Go7olO
o`047`04oalOo`<O00Go7olOo`037`04oalOo`<O00Go7olOo`047`04oalOo`<O00Go7olOo`047`03
o`0000@000060004o`0000Go0`000ol00002o`<01Ol01=oogml20004oalO7`Go00<Ooal011l01?l0
0005o`04gooOg`<000?o7al01Ol00aoo7`047`04oalO7`Ko0Ql01OlO7aoo00<O1_l27`04oalOo`<O
1_l27`05oalO7ol00al6o`8O00Go7alOo`027`Go0al01OlO7aoo00<01Ol3g`05o`000?l00al5o`<O
00Go7alOo`0200Go0ml01Ol0003o00<O1_l00aoo7`037`04oalO7`Ko00<Ooal00Ql01?lO7al6o`03
7olO00<O00Co7alO1_l00aoo7`037`03o`0000@000060003o`0000H00ol300;o2002o`?O00<0oal0
1al2o`DO00?o00001Ml00`3oo`03g`8000?o7al01Al2o`DO00?o7al01al2o`@O00?o7al01al2o`<O
00?o7al01al2o`@O00?o7al01al2o`@O00?o7al01Al3o`@O00?o00001P03o`;O0P000olO7`067`?o
11l00ol0000500?o0]l20003oalO00LO0_l47`03oalO00LO0_l37`03oalO00LO0_l47`03oalO00LO
0_l47`03o`0000@000060003o`0000`00_l900GO00?o7al03Al00ol0g`04g`<01Ml00`3o7`0=7`03
oalO00dO00?o7al031l00olO7`0=7`03oalO00dO00?o7al031l00ol0000700GO00<0oal03Ql00ol0
000600GO00<0oal03Ql00olO7`0<7`03oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o
2P04g`03oalO00dO00?ogml00ml500GO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0=7`03oalO00`O00?o00002005g`03oalO00dO00?o00001`05g`03oalO00dO00?o7al031l00olO
7`0=7`03oalO00dO00?o0000100000H000?o00003002o`/00ml00olO7`0=7`03omoO00;O1`04g`03
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00olO7`0<7`03oml000T01=l00olO
7`0=7`03o`0000P01=l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@000060003
o`0000`00_l00ml0000900;O00?o7al03Al01?oOgml900?O00?o7al031l00olO7`0=7`03oalO00`O
00?o7al03Al00olO7`0=7`03oalO00`O00?ogml02P03g`03oalO00dO00?og`002@03g`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00dO00?og`00100000H0ool<o`03g`0000<000060003o`0000`0
0_l3g`/000?ogml00]l800?O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO7`0=7`03
oalO00dO00CogmoO2`000ooOg`02g`X000?Ooal03Ql00olO7`0<7`03oalO00dO00?o7al031l00olO
7`0=7`03oalO00dO00?og`00100000H000?o00003002o`CO2P000ooOg`03g`H01=l00olO7`0=7`03
oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ooOg`02g`X000?ogml00ml:0003
oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03o`0000@000060003
o`0000`00_l5g`T000?o0=l01=l400GO00?o7al03Al00olO7`0<7`03oalO00dO00?o7al031l00olO
7`0=7`03oalO00dO00?ogml00ml90003o`3O00CO2@000olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0<7`03oalO00dO00?o7al03Al00ol0000400001P001?l00003o`P00_l00`3Og`03o`P000Co003O
0ol00ml00005g`030?lO008O0ol97`03oalO00?o2Al01?lO7al3o`TO00Co7alO0ol87`04oalO7`?o
2Al01?lO7al3o`TO00?o0=l00ol00ml000060004o`00g`?o00?O00001P001?lO7al3o`TO00?o7al0
0ol97`04oalO7`?o2Al01?lO7al3o`PO00Co7alO0ol97`04oalO7`?o2Al00ol0000400001P000ol0
00040003o`0000D00_l200CO00?o00001@001?l00003g`03omoO00CO0P000olO7`047`03oalO00HO
00?o7al00al00olO7`067`03oalO00@O00?o7al01Ql00olO7`047`03oalO00DO00?o7al011l00olO
7`067`03oalO00@O00?o7al01Ql00ol00003g`03oml000H000Co00000ml00ooO00060003oalO00@O
00?o7al01Ql00olO7`037`03oalO00HO00?o7al011l00olO7`067`03oalO00@O00?o7al01Al00olO
7`047`03oalO00HO00?o7al011l00olO7`067`03o`0000@000060004o`0000Co00<0ool00_l200;o
0`04o`04goooo`<000Co00001?l00mooo`02o`<000Co7alO1?l011ooool47`03oalO00Co0Ql3o`<O
00Co7alO1?l011ooool47`04oalO7`Co00<Oool00_l27`04oalO7`Co00@Ooooo11l01?lO7al4o`8O
0ol37`03o`0000Co00COoooo10001?l00004o`03gooo00;o0`001?lO7al4o`047oooo`@O00?o7al0
1?l27`?o0al01?lO7al4o`047oooo`@O00Co7alO1?l00aooo`02o`8O00Co7alO1?l011ooool47`04
oalO7`Co0Ql3o`<O00?o0000100000H000Co003o0`001?l00?l400;o0P001Ol0gmoo00;O00?o0000
0P001?l00?l20006gooOgooO10001?lO7ol37`03oalO008O00Oo7alOoaoo00<O00Go7alOo`047`04
oalOo`<O00Co7aoo1Al01?lO7ol37`04oalOo`@O00Co7aoo0al00olO7`027`05oalO7ol00Ql01OlO
7aoo00<O00?o7al00Ql00ol0o`020005gooOgol01@001?l00?l20005gooOgol01@001?lO7ol37`03
oalO008O00Oo7alOoaoo00<O00Go7alOo`047`04oalOo`<O00Co7aoo1Al01?lO7ol37`04oalOo`@O
00Co7aoo0al00olO7`027`05oalO7ol00Ql01OlO7aoo00<O00?o7al00Ql00ol0000400001P001?l0
0?l30005o`000?l00`02o`8000Go003Oo`02g`03o`00008000Co003o0P000moog`02g`03o`000080
00Co7aoo0al00olO7`027`07oalO7olOo`037`03oaoo00?o0al01?lO7ol37`04oalOo`DO00Co7aoo
0al01OlO7aoo00<O00Co7aoo0al00olO7`027`05oalO7ol00Ql01_lO7aoo7`Co0al00ol0o`030005
omoOoml010001?l00?l30005omoOgol010001?lO7ol37`03oalO008O00Oo7alOoaoo00<O00?o7ol0
0ol37`04oalOo`<O00Co7aoo1Al01?lO7ol37`05oalO7ol00al01?lO7ol37`03oalO008O00Go7alO
o`027`06oalO7olO1?l37`03o`0000@000060004o`00o`<000?o00000P000ol00002o`8000Go0000
o`02g`03oml0008000Go003o0002g`03omoO00;O00Go0000o`027`05oalO7ol00Ql2o`@O00?o7ol0
0al01OlOoaoo00@O00Co7aoo0al01?lO7ol57`04oalOo`<O00?o7al00Ql01?lO7ol27`05oalO7ol0
0Ql2o`@O00Co7aoo0al01OlOoaoo00@O00?o0?l00`001?oOgol2g`<000Co003o0`000ooOg`02g`05
o`000?l00Ql01OlO7aoo008O0_l47`03oaoo00<O00Go7olOo`047`04oalOo`<O00Co7aoo1Al01?lO
7ol37`03oalO008O00Co7aoo0Ql01OlO7aoo008O0_l47`04oalOo`<O00Go7olOo`047`03o`0000@0
00060004o`0000Ko0P000ol00002o`<01Ol01=oogml20004o`0000Ko0]l01OoO003o00<O1Ol37`05
oalO7ol00Ql6o`037olO00<O00Co7alO1Ol00aoo7`047`04oalO7`Ko0Ql01?lO7ol37`Go0al01OlO
7aoo00<O1_l00aoo7`037`03o`0000Go00?Ooml00]l20004o`0000Ko0]l01OoO003o00<O1Ol37`05
oalO7ol00Ql6o`037olO00<O00Co7alO1Ol00aoo7`047`04oalO7`Ko0Ql01?lO7ol37`Go0al01OlO
7aoo00<O1_l00aoo7`037`03o`0000@000060003o`0000L00_l300;o2002o`?O00@0o`001Ml200;o
0ml00`3o7`077`?o11l00olO7`067`;o11l00olO7`067`;o1Al00olO7`077`;o0al00olO7`067`?o
11l00olO7`077`;o11l00ol0000500;o1=l00`3o000800;o0ml00`3o7`077`?o11l00olO7`067`;o
11l00olO7`067`;o1Al00olO7`077`;o0al00olO7`067`?o11l00olO7`077`;o11l00ol000040000
1P000ol0000<00;o2@05g`03o`3O00CO1005g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O
00?o7al03Al00olO7`0=7`03o`0000L01Ml00ol0000800GO00?o7al03Al00olO7`0<7`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00dO00?o0000100000H000?o00003002o`X01=l00ooOg`03g`H0
1=l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ol0000800CO
00?o00002@04g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0=7`03
o`0000@000060003o`0000`00_l;00?O00?ogml00]l800?O00?o7al03Al00olO7`0<7`03oalO00dO
00?o7al031l00olO7`0=7`03oalO00dO00?o00002@03g`03oml000X00ml00olO7`0=7`03oalO00`O
00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ol0000400001P000ol0000<00;o3002g`04
omoOg`X00]l00olO7`0=7`03oalO00`O00?o7al03Al00olO7`0<7`03oalO00dO00?o7al03Al00ooO
000:00;O00?ogml02`02g`03oalO00dO00?o7al031l00olO7`0=7`03oalO00`O00?o7al03Al00olO
7`0=7`03oml000@000060?oo3?l00ml0000300001P000ol0000<00;o2`03g`03omoO00;O2`000ooO
g`02g`X000?Ooml00]l;0003omoO00;O2P000moog`02g`/000?ogml00]l;0003omoO00;O2P000moo
g`02g`/000?ogml00]l;0003omoO00;O2P000moog`02g`/000?ogml00]l:0003gooO00;O2`000ooO
g`02g`/000?ogml00]l:0003gooO00D000060003o`0000`00_l:00CO00?ogml00ml:0003omoO00?O
2P000ooOg`02g`X000?ogml00ml:0003omoO00;O2P000ooOg`03g`X000?ogml00ml:0003omoO00;O
2P000ooOg`03g`X000?ogml00ml:0003omoO00;O2P000ooOg`03g`X000?ogml00]l:0003omoO00?O
2P000ooOg`03g`X000?o0000100000H000Co00000ol800;o0`03o`<01Ml01?l0gml3o`T000Co0=oO
0ol90003omoO00?o2@001?l0gml3o`T000CogmoO0ol80004o`3Og`?o2@001?l0gml3o`T000?ogml0
0ol90004o`3Og`?o2@001?l0gml3o`T000?ogml00ol90004o`3Og`?o2@001?oOgml3o`P000Co0=oO
0ol90004o`3Og`?o2@000ol0000400001P000ol000040003o`0000D00_l60003o`3O00CO00@0o`00
1=l00ol000060003o`0000CO00?o00001P000ol0g`03g`03o`0000H000?o00001=l00ol000060003
o`3O00CO00?o00001@000ol00004g`03o`0000H000?o00001=l00ol000060003o`3O00?O00?o0000
1P000ol00004g`03o`0000H000?o00001=l00ol000060003o`3O00?O00?o00001P000ol00004g`03
o`0000H000?o0=l01=l00ol000050003o`0000CO00?o00001P000ol00004g`03o`0000H000?o0000
100000H000Co00001?l0103oool300;o0`04o`05gooooml00P001?l00004o`04goooo`@000Co0000
1?l01=ooool40003o`0000Co00COoooo10001?l00004o`04goooo`@000Co003O1?l0103oool30004
o`0000Co00COoooo10001?l00004o`04goooo`@000?o00001?l01=ooool40004o`0000Co00COoooo
10001?l00004o`04goooo`@000?o00001?l01=ooool40004o`0000Co00COoooo10001?l00=l4o`04
0?ooo`<000Co00001?l01=ooool40004o`0000Co00COoooo10000ol0000400001P001?l00?l30004
o`00o`@00_l20005o`000?l00]l00ooO00020005o`00o`000]l01?oOgol50005o`00o`000]l01?oO
gol50004o`3o00;O00Cogmoo1@001Ol00?l000;O00Cogmoo1@001?l00?l3g`04oml0o`@000Go003o
0002g`04omoOo`D000Go003o0002g`04omoOo`D000Co0?l00]l01?oOgol50005o`00o`000]l01?oO
gol50005o`00o`000]l01?oOgol50004o`3o00;O00Cogmoo1@001Ol00?l000;O00Cogmoo1@001?l0
0?l3g`04oml0o`@000Go003o0002g`04omoOo`D000Go003o0002g`04omoOo`D000?o0000100000H0
00Co003o0`001?l00?l400;o0P001Ol00=oo00;O00?o00000P001?l00?l20005gooOgol01@001?l0
0?l20005gooOgol01@000ol0o`020005gooOgol01@001?l00?l20005gooOgol01@001Ol00?l000;O
00Cogmoo10001?l00?l20005gooOgol01@001?l00?l20005gooOgol01@000ol0o`020005gooOgol0
1@001?l00?l20005gooOgol01@001?l00?l20005gooOgol01@000ol0o`020005gooOgol01@001?l0
0?l20005gooOgol01@001Ol00?l000;O00Cogmoo10001?l00?l20005gooOgol01@001?l00?l20005
gooOgol01@000ol0000400001P001?l00?l30004o`00o`@00_l20005o`3Ogol00]l00ol000020004
o`00o`<000Gogmoog`040004o`00o`<000Gogmoog`040003o`3o00<000Gogmoog`040004o`00o`<0
00Gogmoog`040004o`00o`8000GOomoOo`040004o`00o`<000Gogmoog`040004o`00o`<000Gogmoo
g`040003o`3o00<000Gogmoog`040004o`00o`<000Gogmoog`040004o`00o`<000Gogmoog`040003
o`3o00<000Gogmoog`040004o`00o`<000Gogmoog`040004o`00o`8000GOomoOo`040004o`00o`<0
00Gogmoog`040004o`00o`<000Gogmoog`040003o`0000@000060004o`0000Go00<0o`000`02o`<0
1Ol00`3o00030004o`0000Go00COomoO0`001?l00005o`04gooOg`<000?o00001Ol01=oogml30004
o`0000Go00COomoO0`001?l00005o`03gooO00<000Co00001Ol01=oogml30004o`0000Go00COomoO
0`000ol00005o`04gooOg`<000Co00001Ol01=oogml30004o`0000Go00COomoO0`000ol00005o`04
gooOg`<000Co00001Ol01=oogml30004o`0000Go00?Ooml00`001?l00005o`04gooOg`<000Co0000
1Ol01=oogml30003o`0000@000060003o`0000H00_l400;o0P05g`030?oo00@000?o00001P02o`?O
0P000ol0000600;o0ml20003o`0000D00_l3g`8000?o00001P02o`?O0P000ol000050003gooo00;O
0P000ol0000600;o0ml20003o`0000H00_l3g`8000?o00001@02o`?O0P000ol0000600;o0ml20003
o`0000H00_l3g`8000?o00001@02o`?O0P000ol0000600;o0ml20003o`0000D000?Oool00]l20003
o`0000H00_l3g`8000?o00001P02o`?O0P000ol0000400001P000ol0000<00;o00<0gml00ml80003
o`0000L01Ml00`3o000800GO00<0o`001`05g`030?l000P01Ml00`3o000700GO00<0o`002005g`03
0?l000P01Ml00`3o000700GO00<0o`002005g`030?l000P01Ml00`3o000700GO00<0o`002005g`03
0?l000L01Ml00`3o000800GO00<0o`002005g`030?l000D000060003o`0000`00_l5g`T000?o0000
2005g`03o`0000P01Ml00ol0000700GO00?o00002005g`03o`0000L01Ml00ol0000800GO00?o0000
2005g`03o`0000L01Ml00ol0000800GO00?o00002005g`03o`0000L01Ml00ol0000800GO00?o0000
1`05g`03o`0000P01Ml00ol0000800GO00?o0000100000H000?o00003002o`CO2P000ol0000900CO
00?o00002@04g`03o`0000P01=l00ol0000900CO00?o00002004g`03o`0000T01=l00ol0000900CO
00?o00002004g`03o`0000T01=l00ol0000900CO00?o00002004g`03o`0000T01=l00ol0000800CO
00?o00002@04g`03o`0000T01=l00ol0000400001P000ol0000<00;o0ml;0003o`0000X00ml00ooO
000:00?O00?og`002@03g`03oml000X00ml00ooO000900?O00?og`002P03g`03oml000X00ml00ooO
000900?O00?og`002P03g`03oml000X00ml00ooO000900?O00?og`002P03g`03oml000T00ml00ooO
000:00?O00?og`002P03g`03oml000@000050?oo3Ol00ml0000300001@3oo`go00?O00000`0000H0
00?o00002`03o`h000?o00003@000ol0000=0003o`0000`000?o00003@000ol0000<0003o`0000d0
00?o00003@000ol0000<0003o`0000d000?o00003@000ol0000<0003o`0000d000?o000030000ol0
000=0003o`0000d000?o0000100000H000Go0?oo0002o`H000Co0?oo3P000ol0000=0003o`0000d0
00?o000030000ol0000=0003o`0000`000?o00003@000ol0000=0003o`0000`000?o00003@000ol0
000=0003o`0000`000?o00003@000ol0000<0003o`0000d000?o00003@000ol0000400001P001_l0
0?l0o`H000?o00000_l300?o20001?l00003o`T000Co00000ol90003o`0000?o2@001?l00003o`T0
00Co00000ol80004o`0000?o2@001?l00003o`T000?o00000ol900Co3004o``00ol<00Co3004o`/0
1?l<00Co30000ol0000400001P001Ol0003o00H000Co00000_l60003o`0000D000?o000010000ol0
00060003o`0000@000?o00001P000ol000030003o`0000H000?o000010000ol000060003o`0000@0
00?o00001@000ol000040003o`0000H000?o000010000ol000060003o`0000<000?o00001P001Ol0
003o00/000Go0000o`0;0004o`00o`/000Go0000o`0;0005o`000?l02P001Ol0003o00/000Go0000
o`0;0003o`0000@000060006o`00o`3o10000ol0000200;o0`04o`040?ooo`<000Co00001?l00`3o
o`02o`<000Co00001?l0103oool40003o`0000Co0P03o`<000Co00001?l0103oool40004o`0000Co
0P02o`<000Co00001?l20003o`0000<000Co00001?l200;o10000ol00004o`040?ooo`@01Ol0103o
ool400;o00<0ool00ol0103oool300?o00<0ool00_l0103oool300Wo00@0oooo0`03o`030?oo00?o
00@0oooo1007o`040?ooo`<00ol00`3oo`03o`040?ooo`@00_l00`3o000500001P001Ol0ool000;o
0P03o`<00_l20005o`000?l00P000ol000020004o`00o`<000Co003o1@001?l00?l30003o`000080
00Oo0000o`3o00<000Go0000o`040004o`00o`<000?o00000P001Ol0003o008000Oo0000o`3o0080
00Co003o0P001Ol0003o008000?o00000`001?l00?l30003o`3o008000Oo0000o`3o00<000?o0000
0P001Ol0003o00<000Co003o10000ol00002o`<000Co003o1@001?l0ool20004o`00o`D000Co003o
0`001?l00?l700;o0`001?l00?l600;o0`001?l00?l700;o0`001?l00?l40003o`0000;o1P0000H0
00?o00001@000ol0o`0400;o0P001Ol0003o008000?o00000P001?l00?l30005o`000?l010001?l0
0?l30003o`00008000Oo0000o`3o00<000?o0?l00ol30004o`00o`<000?o00000P001Ol0003o0080
00Oo0000o`3o008000Co003o0P001Ol0003o00<000?o00000P001?l00?l30003o`3o008000Oo0000
o`3o00<000?o00000ol30005o`000?l00P000ol000020003o`0000;o0`001?l00?l50004o`3oo`80
00Co003o1P000ol0o`030004o`00o`L00_l30004o`00o`@01?l30004o`00o`L00_l30004o`00o`@0
00?o00000_l600001P000ol000040005o`000?l00`02o`8000Go0000o`020003o`00008000Co003o
0`000ol000020005o`000?l00P001Ol0003o00800_l40003o`3o00<000Go0?l0o`040004o`00o`<0
00?o0?l00_l40004o`00o`<000?o0?l00_l30004o`00o`<000Go0000o`040004o`00o`<000?o0000
0_l40003o`3o00<000?o0?l00P001Ol0003o00<000Co003o10000ol00002o`<000Co003o1@001?l0
ool20004o`00o`L00_l30004o`00o`D00_l00`3o00020004o`00o`@000Co0?oo0`001?l00?l400?o
00<0o`000P001?l00?l400?o00<0o`001@0000H000?o00000`000ol000020004o`0000;o0`05o`03
0?l000<000Co00001_l20005o`000?l00`05o`<000Go0000o`0200Ko00<0o`000`001?l00006o`H0
00Co00001_l50004o`0000Go0`001Ol0003o00<01_l20005o`000?l00P06o`8000Co00001_l00`3o
00030003o`0000Oo00<0o`0010000ol00005o`030?l000<000?o00001ol00`3o000600Oo00<0o`00
0`000ol0o`06o`030?l000<000Co00001_l00`3o00030005o`000?l01P0000H000?o00000P000ol0
00020003o`3o00800_l800;o10000ol0000700;o10000ol0000600?o10000ol0000600;o10000ol0
000600Co0`000ol0000700?o0P000ol0000600Co0`000ol0000700;o10000ol0000600;o10000ol0
000300;o1@02o`030?l000@00_l400;o0P000ol0000200;o1@02o`030?l000@00_l400?o00<0o`00
1002o`D00ol500;o1005o`D00_l500Co1P0000H000Go0000o`050003o`3o00800_l>0003o`0000d0
00?o00003@000ol0000<0003o`0000d000?o000030000ol0000=0003o`0000d000?o000030000ol0
000=0003o`0000d000?o000030000ol0000=0003o`0000`000?o00003@000ol0000=0003o`0000@0
00060004o`00o`D00_l0103oo`02o`h000?o00003@000ol0000=0003o`0000`000?o00003@000ol0
000<0003o`0000d000?o00003@000ol0000<0003o`0000d000?o00003@000ol0000<0003o`0000d0
00?o000030000ol0000=0003o`0000d000?o0000100000H000?o0?l03002o`h000?o00003@000ol0
00070003o`0000<000?o00000P000ol000070003o`0000d000?o000030000ol0000=0003o`0000d0
00?o000030000ol0000=0003o`0000d000?o000030000ol0000=0003o`0000`000?o00003@000ol0
000=0003o`0000@0000600;o3@02o`h000?o00003@000ol000060003o`0000@000?o00000`000ol0
00060003o`0000d000?o000030000ol0000=0003o`0000d000?o000030000ol0000=0003o`0000d0
00?o000030000ol0000=0003o`0000`000?o00003@000ol0000=0003o`0000@000060?oo3?l60000
5@02obL000?o00000`000ol000040003o`000<T0000n0003o`0000@000?o00000`000ol000390000
?P000ol000050003o`00008000?o0000b@0003h000?o00000P001?l00?l40003o`000;X00ol<0000
?`000ol0000200;o10000ol0002l0003o`0000/0003`00;o00<0ool02@000ol0o`090003o`0000X0
003a0003o`3o00/000?o000020000ol0000:0000lP000ol0000800Go1`000ol0o`0;0000l@000ol0
o`0;0003o`0000L000?o0?l02`00024000?o0000;@000ol0000800;o2P02o`@000?o00002@000ol0
001c00;o00<0ool04`02o`030?oo00X0000P0003o`0002d000?o00002@000ol0000:0003o`0000<0
00?o00002@000ol0002I00001`001_l0003o00Go00<0ool00ol200?o0`000ol000080006o`000?l0
1Ol200?o5@000ol0000200Co0`000ol0000200Co10000ol000030003o`0000T000?o0000V@0000L0
00Oo0000o`3o008000?o00000P000ol000020004o`00o`8000?o000020001ol0003o0?l00P001Ol0
003o008000?o00004P000ol000030003o`3o00<000?o00000`000ol000040003o`0000<000?o0000
2@000ol0002I00001`001ol0o`3o0?l00P000ol000020003o`00008000?o00000`000ol0000200Go
00L0o`3o0?l000Co0`000ol0000E0003o`0000<000?o00000`000ol000040003o`0000<000?o0000
0`001?l00005o`<000?o0000V@000001\
\>"],
  ImageRangeCache->{{{0, 278.75}, {287, 0}} -> {-1.42509, -0.439256, 
  0.0640365, 0.0640365}},
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell["\<\
The nonstandard rings can provide some interesting surprises.\
\>", 
  "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Unity[Z[10, 2], Mode \[Rule] Visual]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->"MultiplicativeP"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .55556 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0132275 0.47619 [
[ 0 0 0 0 ]
[ 1 .55556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .55556 L
0 .55556 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0132275 0.477324 0.542328 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.107143 0.15873 [
[ 0 0 0 0 ]
[ 1 1.16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.16667 L
0 1.16667 L
closepath
clip
newpath
1 1 0 r
.18254 .26587 m
.18254 .4246 L
.34127 .4246 L
.34127 .26587 L
F
.34127 .26587 m
.34127 .4246 L
.5 .4246 L
.5 .26587 L
F
.5 .26587 m
.5 .4246 L
.65873 .4246 L
.65873 .26587 L
F
.65873 .26587 m
.65873 .4246 L
.81746 .4246 L
.81746 .26587 L
F
.81746 .26587 m
.81746 .4246 L
.97619 .4246 L
.97619 .26587 L
F
.18254 .90079 m
.18254 1.05952 L
.97619 1.05952 L
.97619 .90079 L
F
0 g
[(red->left identity)] .03968 .02778 -1 0 Mshowa
1 0 0 r
.02381 .26587 m
.02381 .4246 L
.18254 .4246 L
.18254 .26587 L
F
1 1 0 r
.65873 .26587 m
.65873 .4246 L
.81746 .4246 L
.81746 .26587 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .10714 m
.02381 1.05952 L
s
.02381 .10714 m
.97619 .10714 L
s
.02381 .26587 m
.97619 .26587 L
s
.02381 .4246 m
.97619 .4246 L
s
.02381 .58333 m
.97619 .58333 L
s
.02381 .74206 m
.97619 .74206 L
s
.02381 .90079 m
.97619 .90079 L
s
.02381 1.05952 m
.97619 1.05952 L
s
.18254 .10714 m
.18254 1.05952 L
s
.34127 .10714 m
.34127 1.05952 L
s
.5 .10714 m
.5 1.05952 L
s
.65873 .10714 m
.65873 1.05952 L
s
.81746 .10714 m
.81746 1.05952 L
s
.97619 .10714 m
.97619 1.05952 L
s
.02381 1.05952 m
.18254 .90079 L
s
2.6 Mabswid
.18254 .10714 m
.18254 1.05952 L
s
.02381 .90079 m
.97619 .90079 L
s
[(0)] .2619 .82143 0 0 Mshowa
[(0)] .42063 .82143 0 0 Mshowa
[(0)] .57937 .82143 0 0 Mshowa
[(0)] .7381 .82143 0 0 Mshowa
[(0)] .89683 .82143 0 0 Mshowa
[(0)] .2619 .6627 0 0 Mshowa
[(4)] .42063 .6627 0 0 Mshowa
[(8)] .57937 .6627 0 0 Mshowa
[(2)] .7381 .6627 0 0 Mshowa
[(6)] .89683 .6627 0 0 Mshowa
[(0)] .2619 .50397 0 0 Mshowa
[(8)] .42063 .50397 0 0 Mshowa
[(6)] .57937 .50397 0 0 Mshowa
[(4)] .7381 .50397 0 0 Mshowa
[(2)] .89683 .50397 0 0 Mshowa
[(0)] .2619 .34524 0 0 Mshowa
[(2)] .42063 .34524 0 0 Mshowa
[(4)] .57937 .34524 0 0 Mshowa
[(6)] .7381 .34524 0 0 Mshowa
[(8)] .89683 .34524 0 0 Mshowa
[(0)] .2619 .18651 0 0 Mshowa
[(6)] .42063 .18651 0 0 Mshowa
[(2)] .57937 .18651 0 0 Mshowa
[(8)] .7381 .18651 0 0 Mshowa
[(4)] .89683 .18651 0 0 Mshowa
[(0)] .10317 .82143 0 0 Mshowa
[(2)] .10317 .6627 0 0 Mshowa
[(4)] .10317 .50397 0 0 Mshowa
[(6)] .10317 .34524 0 0 Mshowa
[(8)] .10317 .18651 0 0 Mshowa
[(0)] .2619 .98016 0 0 Mshowa
[(2)] .42063 .98016 0 0 Mshowa
[(4)] .57937 .98016 0 0 Mshowa
[(6)] .7381 .98016 0 0 Mshowa
[(8)] .89683 .98016 0 0 Mshowa
[(Mult\\(Z[10,2]\\))] .02381 1.13889 -1 0 Mshowa
gsave
.97619 1.13889 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .95317 0 0 Mshowa
[(y)] .14286 1.0119 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0132275 0.97619 0.542328 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.107143 0.15873 [
[ 0 0 0 0 ]
[ 1 1.16667 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.16667 L
0 1.16667 L
closepath
clip
newpath
0 1 1 r
.65873 .74206 m
.65873 .90079 L
.81746 .90079 L
.81746 .74206 L
F
.65873 .58333 m
.65873 .74206 L
.81746 .74206 L
.81746 .58333 L
F
.65873 .4246 m
.65873 .58333 L
.81746 .58333 L
.81746 .4246 L
F
.65873 .26587 m
.65873 .4246 L
.81746 .4246 L
.81746 .26587 L
F
.65873 .10714 m
.65873 .26587 L
.81746 .26587 L
.81746 .10714 L
F
0 g
[(red->right identity)] .03968 .02778 -1 0 Mshowa
0 1 1 r
.02381 .10714 m
.02381 .90079 L
.18254 .90079 L
.18254 .10714 L
F
1 0 0 r
.65873 .90079 m
.65873 1.05952 L
.81746 1.05952 L
.81746 .90079 L
F
0 1 1 r
.65873 .26587 m
.65873 .4246 L
.81746 .4246 L
.81746 .26587 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .10714 m
.02381 1.05952 L
s
.02381 .10714 m
.97619 .10714 L
s
.02381 .26587 m
.97619 .26587 L
s
.02381 .4246 m
.97619 .4246 L
s
.02381 .58333 m
.97619 .58333 L
s
.02381 .74206 m
.97619 .74206 L
s
.02381 .90079 m
.97619 .90079 L
s
.02381 1.05952 m
.97619 1.05952 L
s
.18254 .10714 m
.18254 1.05952 L
s
.34127 .10714 m
.34127 1.05952 L
s
.5 .10714 m
.5 1.05952 L
s
.65873 .10714 m
.65873 1.05952 L
s
.81746 .10714 m
.81746 1.05952 L
s
.97619 .10714 m
.97619 1.05952 L
s
.02381 1.05952 m
.18254 .90079 L
s
2.6 Mabswid
.18254 .10714 m
.18254 1.05952 L
s
.02381 .90079 m
.97619 .90079 L
s
[(0)] .2619 .82143 0 0 Mshowa
[(0)] .42063 .82143 0 0 Mshowa
[(0)] .57937 .82143 0 0 Mshowa
[(0)] .7381 .82143 0 0 Mshowa
[(0)] .89683 .82143 0 0 Mshowa
[(0)] .2619 .6627 0 0 Mshowa
[(4)] .42063 .6627 0 0 Mshowa
[(8)] .57937 .6627 0 0 Mshowa
[(2)] .7381 .6627 0 0 Mshowa
[(6)] .89683 .6627 0 0 Mshowa
[(0)] .2619 .50397 0 0 Mshowa
[(8)] .42063 .50397 0 0 Mshowa
[(6)] .57937 .50397 0 0 Mshowa
[(4)] .7381 .50397 0 0 Mshowa
[(2)] .89683 .50397 0 0 Mshowa
[(0)] .2619 .34524 0 0 Mshowa
[(2)] .42063 .34524 0 0 Mshowa
[(4)] .57937 .34524 0 0 Mshowa
[(6)] .7381 .34524 0 0 Mshowa
[(8)] .89683 .34524 0 0 Mshowa
[(0)] .2619 .18651 0 0 Mshowa
[(6)] .42063 .18651 0 0 Mshowa
[(2)] .57937 .18651 0 0 Mshowa
[(8)] .7381 .18651 0 0 Mshowa
[(4)] .89683 .18651 0 0 Mshowa
[(0)] .10317 .82143 0 0 Mshowa
[(2)] .10317 .6627 0 0 Mshowa
[(4)] .10317 .50397 0 0 Mshowa
[(6)] .10317 .34524 0 0 Mshowa
[(8)] .10317 .18651 0 0 Mshowa
[(0)] .2619 .98016 0 0 Mshowa
[(2)] .42063 .98016 0 0 Mshowa
[(4)] .57937 .98016 0 0 Mshowa
[(6)] .7381 .98016 0 0 Mshowa
[(8)] .89683 .98016 0 0 Mshowa
[(Mult\\(Z[10,2]\\))] .02381 1.13889 -1 0 Mshowa
gsave
.97619 1.13889 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .95317 0 0 Mshowa
[(y)] .14286 1.0119 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[44]:=",
  ImageSize->{288, 160},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000X0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000780
0omB00?o?@03oaH0001c0003o`0005@000?o0000>`000ol0000E00003@04o`<01?l200Go3005o`80
1?l00`3oo`02o`<00ol800Go0P05o`030?oo00;o00@0ool00_l200?o0P05o`800ol30003o`0002D0
1?l300Co0P05o``01?l200Go0P04o`040?oo00;o0P03o`P01Ol200Go00<0ool00_l0103oo`02o`80
0ol200Go0P03o`<000?o0000500000h000?o00000P000ol000030005o`000?l01P02o`L000Go0000
o`060003o`0000<000Co003o2@001Ol0003o00<000?o0?l01@001?l00?l30004o`00o`<000?o0000
0P001?l00?l20003o`0002H000?o00000P000ol000030005o`000?l01P02o`H000?o000010001Ol0
003o00<000?o0?l00P001Ol0003o008000?o00001`001Ol0003o00<000?o0?l01@001?l00?l30004
o`00o`<000?o00000P001?l00?l20003o`0001@0000>0003o`0000801Ol00`3o00020003o`3o00Co
0P02o`D000Co00001Ol20003o`0000<000?o00002P001Ol0003o00<000?o0?l01?l01@3o003o00<0
00?o000010000ol000020003o`00008000?o0?l09`000ol0000200Go00<0o`000P000ol0o`04o`80
0_l40003o`0000@000Go0000o`030003o`3o008000Go0000o`0<0005o`000?l00`000ol0o`04o`05
0?l00?l00`000ol000040003o`00008000?o00000P000ol0o`0E00003P02o`<000Oo0000o`3o00<0
00?o000020000ol000020005o`000?l00`001?l00?l50003o`0000X000Go0000o`030003o`3o00<0
00?o0?l00P001Ol0003o00H000?o00000P000ol000020003o`3o02L00_l30007o`000?l0o`030003
o`0000P000Co00000_l50005o`000?l00`000ol0o`020005o`000?l030001Ol0003o00<000?o0?l0
0`000ol0o`020005o`000?l01P000ol000020003o`00008000?o0?l05@0000d00_l00`3oo`0200?o
0`04o`P00_l50003o`0000800ol200Co0P04o`T00_l400Co0P03o`030?oo00?o0P04o`<00_l300Co
00@0ool00_lU00;o00<0ool00P03o`<01?l800;o0`02o`030?oo00800_l400Wo0P04o`T00_l400Co
0P03o`030?oo00?o0P04o`<00_l300Co00@0ool00_lD00007@000ol0000400;o1`000ol000080003
o`0000<000?o00004P000ol0000<0003o`0000T000?o0000>`000ol0000400;o5`000ol000040003
o`00018000?o000030000ol000090003o`0001X0000L00;o3@03o`X00ol30003o`0000X000?o0000
1002o`h000?o000010000ol000020003o`0003X00_lE0003o`0000H00_l60003o`0000X000?o0000
1002o`h000?o000010000ol000020003o`0001X0003o0240003o0240003o0240003o0240003o0240
000:07co4`1lo`/0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0000H00_l800;o2@02o`T0
00?o00001P02o`X000?o00001@04o`P000?o00001`02o`T000?o00001P03o`P000?o00004@000ol1
0@060@;o2042o`P00_l:0003o`0000H00_l90003o`0000H01?l80003o`4100H10_l:0@03o`0000H0
0ol80003o`0000T0000:0003o`0000D000Co003o1`02o`P000Co003o20000ol000050004o`00o`T0
00?o00001P000ol000080003o`0000H000Co003o20000ol000070003o`0000L000?o00004@000ol1
0@050@04o`41o`L10_l70004o`00o`T000?o00001@001?l00?l80003o`0000L000?o000020000ol1
0@050@04o`41o`T100?o00001`000ol000070003o`0000T0000:0003o`0000D000Co003o1`02o`P0
00Co003o20000ol000050004o`00o`T000?o00001`000ol000070003o`0000H000Co003o20000ol0
000500Co20000ol0000A0003o`4100D100Co0@7o1`42o`L000Co003o2@000ol000050004o`00o`P0
00?o000020000ol000070003o`4100D100Co0@7o2@400ol0000500Co20000ol0000900002P000ol0
000600;o2002o`P000Co003o20000ol0000500?o2P000ol000080003o`0000H000?o00001`02o`T0
00?o00001@000ol0o`090003o`00014000?o0@401P42o`P10_l70004o`00o`T000?o00001@03o`T0
00?o00002@000ol000060003o`4100H10_l:0@03o`0000D000?o0?l02@000ol0000900002P000ol0
00050004o`00o`L00_l80004o`00o`P000?o00001@000ol0000:0003o`0000D000Co003o20000ol0
00060004o`00o`P000?o00001@000ol0o`090003o`00014000?o0@401@401?l10Ol70@;o1`001?l0
0?l90003o`0000D000?o00002@000ol000060004o`00o`P000?o0@401@401?l10Ol90@03o`0000D0
00?o0?l02@000ol0000900002P000ol0000600;o2002o`T00_l90003o`0000H00ol90003o`0000H0
0_l90003o`0000L00_l90003o`0000H00_l90003o`00014000?o0@401P42o`P10_l800;o2P000ol0
000600?o20000ol0000700;o2@000ol10@060@;o2P400ol0000600;o2@000ol0000900002P000ol0
000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0@404042oa@0
00?o00004@000ol0000B0003o`41018100?o00004@000ol0000900002P000ol0000@00;o50000ol0
000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0@404042oa@000?o00004@000ol0
000B0003o`41018100?o00004@000ol0000900002P000ol0000@00;o50000ol0000B0003o`000140
00?o00004P000ol0000A0003o`00014000?o0@404042oa@000?o00004@000ol0000B0003o`410181
00?o00004@000ol0000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0
000A0003o`00014000?o0@404042oa@000?o00004@000ol0000B0003o`41018100?o00004@000ol0
000900002P000ol0000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`000140
00?o0@404042oa@000?o00004@000ol0000B0003o`41018100?o00004@000ol0000900002P000ol0
000@00;o50000ol0000B0003o`00014000?o00004P000ol0000A0003o`00014000?o0@404042oa@0
00?o00004@000ol0000B0003o`41018100?o00004@000ol0000900002P1loa<0O?l;00002P000olO
7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@0
00?o00004@000ol0000B0003o`41018100?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooO
g`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@000?o00004@000ol0
000B0003o`41018100?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooOg`0Bg`03omoO017O
00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@000?o00004@000ol0000B0003o`410181
00?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooO
g`0Ag`03o`00014000?o0@404042oa@000?o00004@000ol0000B0003o`41018100?o00004@000ol0
000900002P000olO7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`000140
00?o0@404042oa@000?o00004@000ol0000B0003o`41018100?o00004@000ol0000900002P000olO
7`0@7`;o5=l00ooOg`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@0
00?o00004@000ol0000B0003o`41018100?o00004@000ol0000900002P000olO7`0@7`;o5=l00ooO
g`0Bg`03omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000?o0@404042oa@000?o00004@000ol0
000B0003o`41018100?o00004@000ol0000900002P000olO7`067`;o21l2o`WO0_l9g`03omoO00GO
1?l9g`03omoO00KO0ol8g`03omoO00OO0_l9g`03omoO00KO0_l9g`03o`00014000?o0@401P42o`P1
0_l800;o2P000ol0000500Co20000ol0000700?o20000ol10@060@;o2P400ol0000600;o2@000ol0
000900002P000olO7`057`04oalOo`LO0_l8g`04omoOo`SO00?ogml01]l00ooOg`09g`03omoO00OO
00?ogml01ml00ooOg`06g`04omoOo`SO00?ogml01Ml01?oOgol8g`03o`00014000?o0@401@401?l1
0Ol70@;o1`001?l00?l90003o`0000H000?o000020000ol000080003o`0000L000?o0@401@401?l1
0Ol90@03o`0000D000Co003o20000ol0000900002P000olO7`057`04oalOo`LO0_l8g`04omoOo`SO
00?ogml01ml00ooOg`08g`03omoO00GO1?l8g`03omoO00KO00Cogmoo2=l00ooOg`05g`04omoOo`SO
00?o00004@000ol10@050@04o`41o`L10_l70004o`00o`T000?o00001`000ol000070003o`0000H0
1?l80003o`4100D100Co0@7o2@400ol000050004o`00o`P000?o00002@0000X000?o7al01Al3o`PO
0_l8g`04omoOo`SO00?ogml02=l00ooOg`07g`03omoO00GO00?ogol02Ml00ooOg`06g`?o2Ml00ooO
g`06g`;o2Ml00ol0000A0003o`4100D10ol80@;o1`001?l00?l90003o`0000P000?o00001P000ol0
00060003o`3o00T000?o0@401@43o`X100?o00001P02o`T000?o00002@0000X000?o7al01Al00olO
7`087`;o2=l01?oOgol8g`03omoO00GO00Cogmoo2Ml00ooOg`05g`03omoo00WO00?ogml01]l00ooO
g`09g`03omoO00GO00Cogmoo2=l00ol0000A0003o`4100D100?o0@402042o`L000Co003o2@000ol0
00050004o`00o`P000?o00001P000ol0o`090003o`4100D100?o0@402P400ol000050004o`00o`P0
00?o00002@0000X000?o7al01Ql3o`LO0_l9g`;o2Ml00ooOg`06g`;o2]l00ooOg`06g`;o2Ml00ooO
g`07g`?o2=l00ooOg`06g`;o2Ml00ol0000A0003o`4100H10ol70@;o2002o`X000?o00001P02o`T0
00?o00001`02o`T000?o0@401P43o`T100?o00001P02o`T000?o00002@0000X000?o7al041l2oaCO
00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`4101010_lD0003o`000140
00?o00004P000ol10@0B0@03o`00014000?o00002@0000X000?o7al041l2oaCO00?ogml04]l00ooO
g`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`4101010_lD0003o`00014000?o00004P000ol1
0@0B0@03o`00014000?o00002@0000X000?o7al041l2oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O
00?ogml04Ml00ol0000A0003o`4101010_lD0003o`00014000?o00004P000ol10@0B0@03o`000140
00?o00002@0000X000?o7al041l2oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0
000A0003o`4101010_lD0003o`00014000?o00004P000ol10@0B0@03o`00014000?o00002@0000X0
00?o7al041l2oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`410101
0_lD0003o`00014000?o00004P000ol10@0B0@03o`00014000?o00002@0000X000?o7al041l2oaCO
00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`4101010_lD0003o`000140
00?o00004P000ol10@0B0@03o`00014000?o00002@0000X0O?lC07co2`0000X000?o00004002oa@0
00?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0003o`000140
00?o00004P000ol10@0B0@03o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0
000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0003o`00014000?o00004P000ol1
0@0B0@03o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`000180
00?o00004@000ol0000A0003o`4101010_lD0003o`00014000?o00004P000ol10@0B0@03o`000140
00?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0
000A0003o`4101010_lD0003o`00014000?o00004P000ol10@0B0@03o`00014000?o00002@0000X0
00?o00004002oa@000?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`410101
0_lD0003o`00014000?o00004P000ol10@0B0@03o`00014000?o00002@0000X000?o00004002oa@0
00?o00004P000ol0000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0003o`000140
00?o00004P000ol10@0B0@03o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0
000A0003o`00018000?o00004@000ol0000A0003o`4101010_lD0003o`00014000?o00004P000ol1
0@0B0@03o`00014000?o00002@0000X000?o00004002oa@000?o00004P000ol0000A0003o`000180
00?o00004@000ol0000A0003o`4101010_lD0003o`00014000?o00004P000ol10@0B0@03o`000140
00?o00002@0000X000?o00001P03o`L00_l900;o2@000ol0000600;o2P000ol0000600;o2@000ol0
000700?o20000ol0000500Co20000ol0000A0003o`4100H10ol70@;o2002o`X000?o00001P02o`T0
00?o00001`02o`T000?o0@401P43o`T100?o00001@04o`P000?o00002@0000X000?o00001`000ol0
000600;o20001?l00?l80003o`0000D000Co003o2@000ol000050004o`00o`P000?o000020000ol0
00070003o`0000H000?o000020000ol0000A0003o`4100L100?o0@401P42o`L000Co003o2@000ol0
00050004o`00o`P000?o00001P001?l00?l80003o`4100L100?o0@4020400ol000060003o`0000P0
00?o00002@0000X000?o00001@04o`L00_l80004o`00o`P000?o00001@001?l00?l90003o`0000D0
00Co003o20000ol0000600Co20000ol000070003o`0000L000?o00004@000ol10@050@Co1`42o`L0
00Co003o2@000ol000050004o`00o`P000?o00001P001?l00?l80003o`4100D11?l90@03o`0000L0
00?o00001`000ol0000900002P000ol000050003o`3o00P00_l80004o`00o`P000?o00001P02o`X0
00?o00001@03o`T000?o00001P000ol0o`090003o`0000P000?o00001P000ol0000A0003o`4100D1
00?o0Ol02042o`L000Co003o2@000ol0000600;o2@000ol0000600?o2@000ol10@050@03o`7o00X1
00?o000020000ol000060003o`0000T0000:0003o`0000D000?o0?l02002o`P000Co003o20000ol0
00050004o`00o`T000?o00001@000ol000090003o`0000H000?o0?l02@000ol000050004o`00o`P0
00?o00004@000ol10@050@03o`7o00P10_l70004o`00o`T000?o00001@001?l00?l80003o`0000H0
00?o00002@000ol10@050@03o`7o00X100?o00001@001?l00?l80003o`0000T0000:0003o`0000H0
0_l800;o2@02o`T000?o00001P02o`X000?o00001P03o`P000?o00001`02o`T000?o00001P02o`T0
00?o00004@000ol10@060@;o2042o`P00_l:0003o`0000H00_l90003o`0000L00ol80003o`4100H1
0_l:0@03o`0000H00_l90003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:07co4`1lo`/0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0000D01?l700;o2@02o`T000?o00001P03o`T000?o00001P02o`T000?o00001P04o`P0
00?o00001P02o`T000?o00004@000ol10@050@Co1`42o`P00_l:0003o`0000H00ol80003o`0000L0
0_l90003o`4100D11?l90@03o`0000H00_l90003o`0000T0000:0003o`0000H000?o00001`02o`P0
00Co003o20000ol000070003o`0000P000?o00001@001?l00?l80003o`0000L000?o000020000ol0
00050004o`00o`P000?o00004@000ol10@060@03o`4100L10_l70004o`00o`T000?o00001`000ol0
00070003o`0000H000Co003o20000ol10@060@03o`4100T100?o00001@001?l00?l80003o`0000T0
000:0003o`0000L000?o00001P02o`P000Co003o20000ol0000500Co2@000ol000050004o`00o`P0
00?o000020000ol000070003o`0000D000Co003o20000ol0000A0003o`4100L100?o0@401P42o`L0
00Co003o2@000ol0000500Co20000ol000060004o`00o`P000?o0@401`400ol10@080@03o`0000D0
00Co003o20000ol0000900002P000ol000080003o`0000D00_l80004o`00o`P000?o00001@000ol0
o`0:0003o`0000H00_l90003o`0000T000?o00001P000ol0000500?o2@000ol0000A0003o`4100P1
00?o0@401@42o`L000Co003o2@000ol000050003o`3o00T000?o00001`02o`T000?o0@4020400ol1
0@070@03o`0000D00ol90003o`0000T0000:0003o`0000D000Co003o1`02o`P000Co003o20000ol0
00050003o`3o00X000?o00001@001?l00?l80003o`0000H000Co003o20000ol000050003o`0000T0
00?o00004@000ol10@050@04o`41o`L10_l70004o`00o`T000?o00001@000ol0o`090003o`0000H0
00Co003o20000ol10@050@04o`41o`T100?o00001@000ol000090003o`0000T0000:0003o`0000H0
0_l800;o2@02o`T000?o00001P02o`X000?o00001P02o`T000?o00001`02o`T000?o00001P03o`P0
00?o00004@000ol10@060@;o2042o`P00_l:0003o`0000H00_l90003o`0000L00_l90003o`4100H1
0_l:0@03o`0000H00ol80003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:07co4`1lo`/0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0000H0
0_l800;o2@02o`T000?o00001P02o`X000?o00001P02o`T000?o00001`02o`T000?o00001P02o`T0
00?o00004@000ol10@060@;o2042o`P00_l:0003o`0000H00_l90003o`0000L00_l90003o`4100H1
0_l:0@03o`0000H00_l90003o`0000T0000:0003o`0000D000Co003o1`02o`P000Co003o20000ol0
00050004o`00o`T000?o00001@001?l00?l80003o`0000H000Co003o20000ol000050004o`00o`P0
00?o00004@000ol10@050@04o`41o`L10_l70004o`00o`T000?o00001@001?l00?l80003o`0000H0
00Co003o20000ol10@050@04o`41o`T100?o00001@001?l00?l80003o`0000T0000:0003o`0000D0
00Co003o1`02o`P000Co003o20000ol000050004o`00o`T000?o00001@001?l00?l80003o`0000H0
00Co003o20000ol000050004o`00o`P000?o00004@000ol10@050@04o`41o`L10_l70004o`00o`T0
00?o00001@001?l00?l80003o`0000H000Co003o20000ol10@050@04o`41o`T100?o00001@001?l0
0?l80003o`0000T0000:0003o`0000D000Co003o1`02o`P000Co003o20000ol000050004o`00o`T0
00?o00001@001?l00?l80003o`0000H000Co003o20000ol000050004o`00o`P000?o00004@000ol1
0@050@04o`41o`L10_l70004o`00o`T000?o00001@001?l00?l80003o`0000H000Co003o20000ol1
0@050@04o`41o`T100?o00001@001?l00?l80003o`0000T0000:0003o`0000D000Co003o1`02o`P0
00Co003o20000ol000050004o`00o`T000?o00001@001?l00?l80003o`0000H000Co003o20000ol0
00050004o`00o`P000?o00004@000ol10@050@04o`41o`L10_l70004o`00o`T000?o00001@001?l0
0?l80003o`0000H000Co003o20000ol10@050@04o`41o`T100?o00001@001?l00?l80003o`0000T0
000:0003o`0000H00_l800;o2@02o`T000?o00001P02o`X000?o00001P02o`T000?o00001`02o`T0
00?o00001P02o`T000?o00004@000ol10@060@;o2042o`P00_l:0003o`0000H00_l90003o`0000L0
0_l90003o`4100H10_l:0@03o`0000H00_l90003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0
000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0
000A0003o`0000T0000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`000140
00?o00004@000ol10@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0
000:0003o`0001000_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol1
0@0@0@;o50000ol0000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`000100
0_lD0003o`00018000?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0
000A0003o`00018000?o0@404P400ol0000A0003o`0000T0000:0003o`0001000_lD0003o`000180
00?o00004@000ol0000B0003o`00014000?o00004@000ol10@0@0@;o50000ol0000A0003o`000180
00?o0@404P400ol0000A0003o`0000T0000907go4P1mo`/0000907go4P1mo`/0000:0003o`000100
0_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol0000@00;o50000ol0
000A0003o`00018000?o7al04Ql00ol0000A0003o`0000T0000:0003o`0000l00olDg`03omoO01;O
00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol0000?00?o50000ol0000A0003o`000180
00?o7al04Ql00ol0000A0003o`0000T0000:0003o`0000h000Co0?oo5=l00ooOg`0Bg`03omoO017O
00?ogml04]l00ooOg`0Ag`03o`00014000?o00003P001?l0oolD0003o`00014000?o00004P000olO
7`0B7`03o`00014000?o00002@0000X000Co00000_l00`3oo`070003o`0000;o5=l00ooOg`0Bg`03
omoO017O00?ogml04]l00ooOg`0Ag`03o`00014000Co00000_l00`3oo`070003o`0000;o50000ol0
000A0003o`00018000?o7al04Ql00ol0000A0003o`0000T0000:0003o`00008000?o0?l01`001?l0
0002oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`00008000?o0?l0
1`001?l00002oa@000?o00004@000ol0000B0003oalO018O00?o00004@000ol0000900002P000ol0
00030003o`0000D000?o00000P02oaCO00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0
000A0003o`0000<000?o00001@000ol0000200;o50000ol0000A0003o`00018000?o7al04Ql00ol0
000A0003o`0000T0000:0003o`00008000?o0?l01@000ol0000300;o5=l00ooOg`0Bg`03omoO017O
00?ogml04]l00ooOg`0Ag`03o`00014000?o00000P000ol0o`050003o`0000<00_lD0003o`000140
00?o00004P000olO7`0B7`03o`00014000?o00002@0000X000Co00000_l00`3oo`030003o`0000@0
0_l9g`;o2Ml00ooOg`05g`Co2Ml00ooOg`06g`?o2=l00ooOg`07g`;o2Ml00ooOg`06g`;o2Ml00ol0
000A0004o`0000;o00<0ool00`000ol0000400;o2002o`X000?o00001@04o`P000?o00001`03o`P0
00?o7al01Ql2o`XO00?o00001P02o`T000?o00002@0000X000?o000020000ol0000500;o2=l01?oO
gol8g`03omoO00KO00?ogml02Ml00ooOg`07g`03omoO00OO00?ogml01]l01?oOgol8g`03omoO00GO
00Cogmoo2=l00ol0000A0003o`0000P000?o00001@02o`L000Co003o2@000ol000060003o`0000P0
00?o000020000ol000070003oalO00DO00Co7aoo2Al00ol000050004o`00o`P000?o00002@0000X0
00?o00001`000ol0o`02o`@00_l8g`04omoOo`SO00?ogml01ml00ooOg`08g`03omoO00GO1?l8g`03
omoO00KO00Cogmoo2=l00ooOg`05g`04omoOo`SO00?o00004@000ol000070003o`3o00;o1002o`L0
00Co003o2@000ol000070003o`0000L000?o00001P04o`P000?o7al01Al01?lO7ol97`03o`0000D0
00Co003o20000ol0000900002P000ol000060005o`000?l01@02o`SO00Cogmoo2=l00ooOg`08g`03
omoO00OO00?ogml01Ml00ooOo`09g`03omoO00KO0ol9g`03omoO00KO0_l9g`03o`00014000?o0000
1P001Ol0003o00D00_l70004o`00o`T000?o000020000ol000060003o`0000H000?o0?l02@000olO
7`057`?o2Ql00ol0000600;o2@000ol0000900002P000ol000050003o`0000<000?o00000P02o`SO
00Cogmoo2=l00ooOg`05g`04omoOo`WO00?ogml01Ml00ooOo`09g`03omoO00KO00?ogml02Ml00ooO
g`05g`04omoOo`SO00?o00004@000ol000050003o`0000<000?o00000P02o`L000Co003o2@000ol0
00050004o`00o`P000?o00001P000ol0o`090003oalO00DO00?o7al02Ql00ol000050004o`00o`P0
00?o00002@0000X000?o000010000ol000040003o`0000800_l9g`;o2Ml00ooOg`06g`;o2]l00ooO
g`06g`;o2Ml00ooOg`07g`?o2=l00ooOg`06g`;o2Ml00ol0000A0003o`0000@000?o000010000ol0
000200;o2002o`X000?o00001P02o`T000?o00001`02o`T000?o7al01Ql3o`TO00?o00001P02o`T0
00?o00002@0000X000?o00000`000ol000040003o`3o00<00_lDg`03omoO01;O00?ogml04Ml00ooO
g`0Bg`03omoO017O00?o00004@000ol000030003o`0000@000?o0?l00`02oa@000?o00004@000ol0
000B0003oalO018O00?o00004@000ol0000900002P000ol000020003o`0000D000?o0?l00`02oaCO
00?ogml04]l00ooOg`0Ag`03omoO01;O00?ogml04Ml00ol0000A0003o`00008000?o00001@000ol0
o`0300;o50000ol0000A0003o`00018000?o7al04Ql00ol0000A0003o`0000T0000:0005o`000?l0
1`02o`030?oo00800_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@001Ol0
003o00L00_l00`3oo`0200;o50000ol0000A0003o`00018000?o7al04Ql00ol0000A0003o`0000T0
000:0004o`00o`l00_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@001?l0
0?l?00;o50000ol0000A0003o`00018000?o7al04Ql00ol0000A0003o`0000T0000:0003o`3o0100
0_lDg`03omoO01;O00?ogml04Ml00ooOg`0Bg`03omoO017O00?o00004@000ol0o`0@00;o50000ol0
000A0003o`00018000?o7al04Ql00ol0000A0003o`0000T0000:00;o4@02oaCO00?ogml04]l00ooO
g`0Ag`03omoO01;O00?ogml04Ml00ol0000A00;o4@02oa@000?o00004@000ol0000B0003oalO018O
00?o00004@000ol0000900002P1loa<0O?l;00007@02ohd00_mb0000o`0Q0000o`0Q0000o`0Q0000
o`0Q00009@000ol0000800;o7002o`@000?o00009P03oc@000?o00002002oa`00_l40003o`0002H0
0olA000090000ol000090003o`0000l000?o00002P000ol000030003o`0002H000?o0000<P000ol0
00090003o`0000l000?o00002P000ol000030003o`0002H000?o0000400000/000Ko0000o`05o`03
0?oo00?o0P03o`<000?o00000P04o`<000?o00000P03o`@00_l40003o`0000801?l40003o`0000<0
00?o00003@02o`030?oo00T000?o0?l02@000ol0000H0006o`000?l01Ol00`3oo`03o`800ol30003
o`0000801?l30003o`0000800ol400;o10000ol0000200Co10000ol000030003o`0000d00_l00`3o
o`090003o`3o00T000?o00003`0000/000Oo0000o`3o008000?o00000P000ol000020004o`00o`80
00?o00000`000ol0o`030003o`0000<000?o00000P001?l00?l40003o`00008000?o000010000ol0
00030003o`0000h000?o0?l02`000ol000080003o`0001P000Oo0000o`3o008000?o00000P000ol0
00020004o`00o`8000?o00000`000ol0o`030003o`0000<000?o00000P001?l00?l40003o`000080
00?o000010000ol000030003o`0000h000?o0?l02`000ol000080003o`0000l0000;0007o`3o0?l0
o`020003o`00008000?o00000P000ol000030003o`0000<000?o00000`000ol000030003o`000080
00Co003o2P000ol000030003o`0000<000?o00003`000ol0000800Go1`000ol0o`0I0007o`3o0?l0
o`020003o`00008000?o00000P000ol000030003o`0000<000?o00000`000ol000030003o`000080
00Co003o2P000ol000030003o`0000<000?o00003`000ol0000800Go1`000ol0o`0@00002`001ol0
o`3o0?l00P000ol000020003o`00008000?o00000`000ol000040003o`00008000?o00000`000ol0
00020004o`00o`/000?o00000P000ol000030003o`0000h000?o0?l02`000ol000070003o`3o01T0
00Oo0?l0o`3o008000?o00000P000ol000020003o`0000<000?o000010000ol000020003o`0000<0
00?o00000P001?l00?l;0003o`00008000?o00000`000ol0000>0003o`3o00/000?o00001`000ol0
o`0@00002`02o`030?oo00;o00<0ool010001?l00004o`<000?o00000P000ol0o`040003o`0000<0
00?o00000P001?l00?l80004o`00o`@000?o00000`000ol0000=00;o00<0ool04`02o`030?oo01P0
0_l00`3oo`02o`030?oo00@000Co00001?l30003o`00008000?o0?l010000ol000030003o`000080
00Co003o20001?l00?l40003o`0000<000?o00003@02o`030?oo01<00_l00`3oo`0?00002P02o`<0
0_l80003o`00008000?o000010001?l00004o`<00_l300;o1@02o`X00_l400;o10000ol0001200;o
0`02o`P000?o00000P000ol000040004o`0000Co0`02o`<00_l500;o2P02o`@00_l40003o`0003X0
000G00?o10000ol0002500?o10000ol0001`0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {159, 0}} -> {-0.052954, -0.0277836, 
  0.00733767, 0.00733767}, {{7.1875, 137}, {155.188, 
  3.75}} -> {-1.49911, -0.86008, 0.0485355, 0.0485355}, {{149.938, 279.75}, {
  155.188, 3.75}} -> {-8.42756, -0.86008, 0.0485355, 0.0485355}},
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \(6\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Units",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ list\ of\ units\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZeroDivisorQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["r",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ a\ zero\ divisor\ in\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ZeroDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(return\ the\ list\ of\ all\ zero\ divisors\ of\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"MultiplicativeP", "i:22"}],

Cell["\<\
Additional functions related to the multiplication in a \
ringoid.\
\>", "Caption",
  CellTags->"MultiplicativeP"],

Cell[TextData[{
  "Of the elements {1, 2, 3} in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  ", which are zero divisors?"
}], "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ZeroDivisorQ[Z[15], #]&, \ {1, 2, 3}]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \({False, False, True}\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell["\<\
Here are all the zero divisors with an explanation of why they are \
so designated.\
\>", "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zd\  = ZeroDivisors[Z[15], Mode \[Rule] Textual]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\<\"One reason why 3 is a zero divisor is that 3 * 10 = 0.\"\>"},
          {"\<\"One reason why 5 is a zero divisor is that 5 * 9 = 0.\"\>"},
          {"\<\"One reason why 6 is a zero divisor is that 6 * 10 = 0.\"\>"},
          {"\<\"One reason why 9 is a zero divisor is that 9 * 5 = 0.\"\>"},
          {
            "\<\"One reason why 10 is a zero divisor is that 10 * 6 = \
0.\"\>"},
          {"\<\"One reason why 12 is a zero divisor is that 12 * 5 = 0.\"\>"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {"One reason why 3 is a zero divisor is that 3 * 10 = 0.", 
        "One reason why 5 is a zero divisor is that 5 * 9 = 0.", 
        "One reason why 6 is a zero divisor is that 6 * 10 = 0.", 
        "One reason why 9 is a zero divisor is that 9 * 5 = 0.", 
        "One reason why 10 is a zero divisor is that 10 * 6 = 0.", 
        "One reason why 12 is a zero divisor is that 12 * 5 = 0."}]]], "Print",\

  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \({3, 5, 6, 9, 10, 12}\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell["Here are the units of the same ring.", "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(u\  = Units[Z[15]]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \({1, 2, 4, 7, 8, 11, 13, 14}\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell["\<\
Here we see that every element in the ring is either a zero \
divisor, a unit, or the zero. Is it true for any ring that an element is a \
zero divisor, a unit, or the zero?\
\>", "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[zd, \ u, \ {0}]\  == \ Elements[Z[15]]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"MultiplicativeP"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->"MultiplicativeP"]
}, Open  ]],

Cell["3.3.3 Distributive property", "Subsubsection",
  CellTags->{"DistributiveP", "i:23"}],

Cell[TextData[{
  "The distributive property can be tested in four ways: ",
  StyleBox["DistributiveQ", "MR"],
  ", ",
  StyleBox["LeftDistributiveQ", "MR"],
  ", ",
  StyleBox["RightDistributiveQ", "MR"],
  ", and ",
  StyleBox["RandomDistributiveQ", "MR"],
  ". As with associativity, the full test is always correct but can be \
time-consuming. The random test tends to be shorter, but not guaranteed. \
Distributivity must be satisfied both on the left and the right: ",
  Cell[BoxData[
      \(TraditionalForm\`a(b + c) = a\ b + a\ c\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\((b + c)\) a\  = b\ a + c\ a\)]],
  ". Testing can be done from both sides or one of the sides."
}], "Text",
  CellTags->"DistributiveP"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DistributiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["distributive",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\((from\ \nboth\ sides)\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["addition",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[\(R, \),
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[\(checking\ all\ possible\ triples\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["LeftDistributiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["left",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["distributive",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(over\ addition\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["RightDistributiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["right",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["distributive",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(over\ addition\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["RandomDistributiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["multiplication",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["likely",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["be",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["distributive",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["over",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["addition",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(checking\ 25\ triples\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\ \),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["RandomDistributiveQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["give",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["multiplication",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["likely",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["to",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["be",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], "\n", 
                RowBox[{
                  StyleBox[\(distributive\ over\ addition\),
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["checking",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["n",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["triples",
                      SingleLetterItalics->False]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], "\n", 
                RowBox[{
                  StyleBox["False",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.39, 0.61}},
  CellTags->{"DistributiveP", "i:24"}],

Cell["Test for distributivity in a ringoid.", "Caption",
  CellTags->"DistributiveP"],

Cell[TextData[{
  "The ring of integers modulo ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " has the distributive property."
}], "MathCaption",
  CellTags->"DistributiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DistributiveQ[Z[12]]\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->"DistributiveP"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"DistributiveP"]
}, Open  ]],

Cell[TextData[{
  "There are ",
  Cell[BoxData[
      FormBox[
        RowBox[{"2", " ", 
          FormBox[\(n\^3\),
            "TraditionalForm"]}], TraditionalForm]]],
  " tests performed by ",
  StyleBox["DistributiveQ", "MR"],
  " on a ringoid with ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " elements. For large ringoids, ",
  StyleBox["RandomDistributiveQ", "MR"],
  " is recommended"
}], "Text",
  CellTags->"DistributiveP"],

Cell["\<\
To avoid asking for 65,536,000 tests to be performed, we use the \
random version and opt for ten tests here.\
\>", "MathCaption",
  CellTags->"DistributiveP"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RandomDistributiveQ[Z[320], 10]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"DistributiveP"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->"DistributiveP"]
}, Open  ]],

Cell[TextData[{
  "3.3.4 ",
  StyleBox["RingQ",
    FontFamily->"Courier"],
  " test"
}], "Subsubsection",
  CellTags->"RingQ"],

Cell[TextData[{
  "All of the basic ring properties can be tested using one function, ",
  StyleBox["RingQ", "MR"],
  ". ",
  StyleBox["ProbableRingQ", "MR"],
  ", approaching associativity and distributivity randomly, is recommended \
for larger ringoids. The results of ring tests are recorded and can be \
retrieved using ",
  StyleBox["RingInfo.", "MR"]
}], "Text",
  CellTags->"RingQ"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["RingQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                "Text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ a\ ring, \ and\ \),
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ProbableRingQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["probably",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ring",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                
                StyleBox[
                  \((using\ random\ \nassociativity\ and\ distributivity\ 
                      tests)\),
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["otherwise",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["RingInfo",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ a\ list\ of\ facts\ about\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["generated",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["by",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["various",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["tests",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"RingQ", "i:25"}],

Cell["Testing for all ring properties and retrieval of results.", "Caption",
  CellTags->"RingQ"],

Cell[TextData[{
  "Here we check ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_7\)]],
  " to verify that it is a ring."
}], "MathCaption",
  CellTags->"RingQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RingQ[Z[7]]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"RingQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"RingQ"]
}, Open  ]],

Cell[TextData[{
  "Since ",
  StyleBox["BooleanRing", "MR"],
  "[6] has 64 elements, we use ",
  StyleBox["ProbableRingQ.", "MR"]
}], "MathCaption",
  CellTags->"RingQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ProbableRingQ[BooleanRing[6]]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"RingQ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"RingQ"]
}, Open  ]],

Cell[TextData[
"Let\[CloseCurlyQuote]s see what is known about this ringoid now."], 
  "MathCaption",
  CellTags->"RingQ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RingInfo[BooleanRing[6]]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"RingQ"],

Cell[BoxData[
    \({"Bool[6]", "the boolean Ring on {1,...,6}", 
      "the set is closed under addition", 
      "the set is closed under multiplication", 
      "the Ringoid has as a zero the element {}", 
      "every element has an additive inverse", 
      "the addition operation is commutative", 
      "multiplication is probably distributive over addition", 
      "the addition operation is probably associative", 
      "the multiplication operation is probably associative", 
      "this is probably a ring"}\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"RingQ"]
}, Open  ]],

Cell["3.3.5 Specialized rings", "Subsubsection",
  CellTags->"SpecializedRings"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FieldQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ is\ a\ field, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["IntegralDomainQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"], 
                StyleBox[\(\ is\ an\ integral\ domain, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"SpecializedRings", "i:26"}],

Cell["Specialized rings can be tested with these functions.", "Caption",
  CellTags->"SpecializedRings"],

Cell[TextData[{
  "The ring ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " is a field if and only if ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is prime."
}], "MathCaption",
  CellTags->"SpecializedRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{#, FieldQ[Z[#]]}&, Range[3, 9]]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"SpecializedRings"],

Cell[BoxData[
    \({{3, True}, {4, False}, {5, True}, {6, False}, {7, True}, {8, False}, {
        9, False}}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"SpecializedRings"]
}, Open  ]],

Cell[TextData[{
  "A quotient ring of polynomials over a field ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  " is a field if and only if the modulus polynomial is irreducible over ",
  Cell[BoxData[
      \(TraditionalForm\`F\)]],
  "."
}], "MathCaption",
  CellTags->"SpecializedRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FieldQ[QuotientRing[Z[3], Poly[Z[3], x\^2 + x + 2]]]\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"SpecializedRings"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"SpecializedRings"]
}, Open  ]],

Cell["3.3.6 Closure of subsets", "Subsubsection",
  CellTags->{"Closure", "i:27"}],

Cell[TextData[{
  "For a ringoid to be a ring, its domain must be closed with respect to \
addition and multiplication. We can use ",
  StyleBox["ClosedQ", "MR"],
  " to test for closure not only of the whole domain but also of subsets."
}], "Text",
  CellTags->"Closure"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["W",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["W",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["closed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["respect",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["addition",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ClosedQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["W",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Operation",
                        "MR"], " ", 
                      StyleBox["\[Rule]",
                        "MR"], " ", "op"}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["W",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ closed\ with\ respect\ to\ the\ operation\ \),
                SingleLetterItalics->False], 
              StyleBox["op",
                FontSlant->"Italic"], 
              StyleBox[\(\ in\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ClosedPlusQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["W",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["W",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ is\ closed\ with\ respect\ to\ addition\ in\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ClosedDiffQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["W",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["W",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["closed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["respect",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["subtraction",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["not",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(or\ if\ any\ negation\ fails\ to\ exist\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ClosedTimesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["W",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["W",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["closed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["respect",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(R, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"Closure", "i:28"}],

Cell["Other closure functions on ringoids.", "Caption",
  CellTags->"Closure"],

Cell["\<\
Closure properties are most often considered when determining \
whether a subset is a subsystem.\
\>", "Text",
  CellTags->"Closure"],

Cell["\<\
Here is a set that is not closed with respect to both ring \
operations.\
\>", "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[Z[8], {1, 3, 5, 7}]\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"Closure"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"Closure"]
}, Open  ]],

Cell["It is closed with respect to multiplication, however.", "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[Z[8], {1, 3, 5, 7}, Operation \[Rule] Multiplication]\)], 
  "Input",
  CellLabel->"In[57]:=",
  CellTags->"Closure"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[57]=",
  CellTags->"Closure"]
}, Open  ]],

Cell[TextData[{
  "Differences between even elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " are again even."
}], "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedDiffQ[Z[8], {0, 2, 4, 6}]\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->"Closure"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[58]=",
  CellTags->"Closure"]
}, Open  ]],

Cell["The evens are also closed with respect to multiplication.", 
  "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedTimesQ[Z[8], {0, 2, 4, 6}]\)], "Input",
  CellLabel->"In[59]:=",
  CellTags->"Closure"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->"Closure"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["Visual", "MR"],
  " mode gives you a sense of \[OpenCurlyDoubleQuote]how closed\
\[CloseCurlyDoubleQuote] a set is."
}], "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClosedQ[Z[9], {0, 2, 4, 6, 8}, Mode \[Rule] Visual, 
      Operation \[Rule] Addition]\)], "Input",
  CellLabel->"In[60]:=",
  CellTags->"Closure"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08333 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0257937 0.15873 [
[ 0 0 0 0 ]
[ 1 1.08333 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.08333 L
0 1.08333 L
closepath
clip
newpath
1 1 0 r
.18254 .66071 m
.18254 .81944 L
.34127 .81944 L
.34127 .66071 L
F
.34127 .66071 m
.34127 .81944 L
.5 .81944 L
.5 .66071 L
F
.5 .66071 m
.5 .81944 L
.65873 .81944 L
.65873 .66071 L
F
.65873 .66071 m
.65873 .81944 L
.81746 .81944 L
.81746 .66071 L
F
.81746 .66071 m
.81746 .81944 L
.97619 .81944 L
.97619 .66071 L
F
.18254 .50198 m
.18254 .66071 L
.34127 .66071 L
.34127 .50198 L
F
.34127 .50198 m
.34127 .66071 L
.5 .66071 L
.5 .50198 L
F
.5 .50198 m
.5 .66071 L
.65873 .66071 L
.65873 .50198 L
F
.65873 .50198 m
.65873 .66071 L
.81746 .66071 L
.81746 .50198 L
F
.18254 .34325 m
.18254 .50198 L
.34127 .50198 L
.34127 .34325 L
F
.34127 .34325 m
.34127 .50198 L
.5 .50198 L
.5 .34325 L
F
.5 .34325 m
.5 .50198 L
.65873 .50198 L
.65873 .34325 L
F
.18254 .18452 m
.18254 .34325 L
.34127 .34325 L
.34127 .18452 L
F
.34127 .18452 m
.34127 .34325 L
.5 .34325 L
.5 .18452 L
F
.18254 .02579 m
.18254 .18452 L
.34127 .18452 L
.34127 .02579 L
F
.18254 .81944 m
.18254 .97817 L
.34127 .97817 L
.34127 .81944 L
F
.34127 .81944 m
.34127 .97817 L
.5 .97817 L
.5 .81944 L
F
.5 .81944 m
.5 .97817 L
.65873 .97817 L
.65873 .81944 L
F
.65873 .81944 m
.65873 .97817 L
.81746 .97817 L
.81746 .81944 L
F
.81746 .81944 m
.81746 .97817 L
.97619 .97817 L
.97619 .81944 L
F
.02381 .66071 m
.02381 .81944 L
.18254 .81944 L
.18254 .66071 L
F
.02381 .50198 m
.02381 .66071 L
.18254 .66071 L
.18254 .50198 L
F
.02381 .34325 m
.02381 .50198 L
.18254 .50198 L
.18254 .34325 L
F
.02381 .18452 m
.02381 .34325 L
.18254 .34325 L
.18254 .18452 L
F
.02381 .02579 m
.02381 .18452 L
.18254 .18452 L
.18254 .02579 L
F
1 0 0 r
.81746 .50198 m
.81746 .66071 L
.97619 .66071 L
.97619 .50198 L
F
.65873 .34325 m
.65873 .50198 L
.81746 .50198 L
.81746 .34325 L
F
.81746 .34325 m
.81746 .50198 L
.97619 .50198 L
.97619 .34325 L
F
.5 .18452 m
.5 .34325 L
.65873 .34325 L
.65873 .18452 L
F
.65873 .18452 m
.65873 .34325 L
.81746 .34325 L
.81746 .18452 L
F
.81746 .18452 m
.81746 .34325 L
.97619 .34325 L
.97619 .18452 L
F
.34127 .02579 m
.34127 .18452 L
.5 .18452 L
.5 .02579 L
F
.5 .02579 m
.5 .18452 L
.65873 .18452 L
.65873 .02579 L
F
.65873 .02579 m
.65873 .18452 L
.81746 .18452 L
.81746 .02579 L
F
.81746 .02579 m
.81746 .18452 L
.97619 .18452 L
.97619 .02579 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02579 m
.02381 .97817 L
s
.02381 .02579 m
.97619 .02579 L
s
.02381 .18452 m
.97619 .18452 L
s
.02381 .34325 m
.97619 .34325 L
s
.02381 .50198 m
.97619 .50198 L
s
.02381 .66071 m
.97619 .66071 L
s
.02381 .81944 m
.97619 .81944 L
s
.02381 .97817 m
.97619 .97817 L
s
.18254 .02579 m
.18254 .97817 L
s
.34127 .02579 m
.34127 .97817 L
s
.5 .02579 m
.5 .97817 L
s
.65873 .02579 m
.65873 .97817 L
s
.81746 .02579 m
.81746 .97817 L
s
.97619 .02579 m
.97619 .97817 L
s
.02381 .97817 m
.18254 .81944 L
s
2.6 Mabswid
.18254 .02579 m
.18254 .97817 L
s
.02381 .81944 m
.97619 .81944 L
s
[(0)] .2619 .74008 0 0 Mshowa
[(2)] .42063 .74008 0 0 Mshowa
[(4)] .57937 .74008 0 0 Mshowa
[(6)] .7381 .74008 0 0 Mshowa
[(8)] .89683 .74008 0 0 Mshowa
[(2)] .2619 .58135 0 0 Mshowa
[(4)] .42063 .58135 0 0 Mshowa
[(6)] .57937 .58135 0 0 Mshowa
[(8)] .7381 .58135 0 0 Mshowa
[(1)] .89683 .58135 0 0 Mshowa
[(4)] .2619 .42262 0 0 Mshowa
[(6)] .42063 .42262 0 0 Mshowa
[(8)] .57937 .42262 0 0 Mshowa
[(1)] .7381 .42262 0 0 Mshowa
[(3)] .89683 .42262 0 0 Mshowa
[(6)] .2619 .26389 0 0 Mshowa
[(8)] .42063 .26389 0 0 Mshowa
[(1)] .57937 .26389 0 0 Mshowa
[(3)] .7381 .26389 0 0 Mshowa
[(5)] .89683 .26389 0 0 Mshowa
[(8)] .2619 .10516 0 0 Mshowa
[(1)] .42063 .10516 0 0 Mshowa
[(3)] .57937 .10516 0 0 Mshowa
[(5)] .7381 .10516 0 0 Mshowa
[(7)] .89683 .10516 0 0 Mshowa
[(0)] .10317 .74008 0 0 Mshowa
[(2)] .10317 .58135 0 0 Mshowa
[(4)] .10317 .42262 0 0 Mshowa
[(6)] .10317 .26389 0 0 Mshowa
[(8)] .10317 .10516 0 0 Mshowa
[(0)] .2619 .89881 0 0 Mshowa
[(2)] .42063 .89881 0 0 Mshowa
[(4)] .57937 .89881 0 0 Mshowa
[(6)] .7381 .89881 0 0 Mshowa
[(8)] .89683 .89881 0 0 Mshowa
[(TheGroup)] .02381 1.05754 -1 0 Mshowa
gsave
.97619 1.05754 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07778 .87183 0 0 Mshowa
[(y)] .14286 .93056 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[60]:=",
  ImageSize->{265.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P0000H0oOl600001P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al09al00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00olO7`0W7`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
oalO02LO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al0
9al00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al0
9al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Ag`;o4ml2oa?O0_lDg`03oalO010O0olD7`03oalO010O0olD7`03
oalO010O0olD7`03oalO014O00?o7al04al00ol0000400001P000ooOg`0@g`04omoOoa;O0_lBg`04
omoOoa?O00?o7al04Al00olO7`0C7`03oalO01<O00?o7al04Al00olO7`0C7`03oalO014O00?o7al0
4Al00olO7`0C7`03o`0000@000060003omoO013O00Cogmoo4]l2oa;O00Cogmoo4ml00olO7`0A7`03
oalO01<O00?o7al04al00olO7`0A7`03oalO01<O00?o7al04Al00olO7`0B7`03oalO018O00?o0000
100000H000?ogml04Ml2oa?O0_lCg`;o5=l00olO7`0A7`03oalO01<O00?o7al04Al2oa@O00?o7al0
41l3oa@O00?o7al04Ql00olO7`0B7`03o`0000@000060003omoO013O00Cogmoo4]l2oa;O00Cogmoo
4ml00olO7`0A7`03oalO01<O00?o7al04al00olO7`0A7`03oalO010O00?o7al051l00olO7`0C7`03
oalO014O00?o0000100000H000?ogml04Ml2oa?O0_lCg`;o5=l00olO7`0@7`;o5Al00olO7`0@7`?o
51l00olO7`0@7`Co4al00olO7`0@7`Co4al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al0
9al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al09al00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00olO7`0W7`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03oalO02LO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?o7al09al00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00olO7`0W7`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
oalO02LO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?o7al0
9al00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00olO7`0W7`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03oalO02LO00?o7al0
9al00olO7`0W7`03oalO02LO00?o0000100000H0oOl600001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al0
9al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03oalO02LO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al09al00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03oalO02LO00?o7al09al00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al09al00olO7`0W7`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03oalO02LO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al0
9al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Ag`;o4ml2oa?O0_lDg`03omoO017O0_lDg`03
oalO010O0olD7`03oalO010O0olD7`03oalO010O0olD7`03o`0000@000060003omoO013O00Cogmoo
4]l2oa;O00Cogmoo4ml00ooOg`0@g`04omoOoa?O00?o7al04Al00olO7`0C7`03oalO01<O00?o7al0
4Al00olO7`0C7`03oalO014O00?o0000100000H000?ogml04=l01?oOgolBg`;o4]l01?oOgolCg`03
omoO013O00Cogmoo4ml00olO7`0A7`03oalO01<O00?o7al04al00olO7`0A7`03oalO01<O00?o7al0
4Al00ol0000400001P000ooOg`0@g`?o4ml2oa;O0olDg`03omoO017O0_lDg`03oalO014O00?o7al0
4al00olO7`0A7`;o51l00olO7`0@7`?o51l00ol0000400001P000ooOg`0@g`03omoO01?O0_lBg`03
omoO01CO00?ogml04=l01?oOgolCg`03oalO014O00?o7al04al00olO7`0C7`03oalO014O00?o7al0
41l00olO7`0D7`03o`0000@000060003omoO017O0olBg`;o4ml3oa?O00?ogml04Ml2oaCO00?o7al0
41l2oaDO00?o7al041l3oa@O00?o7al041l4oa<O00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al0
9al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03oalO02LO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al09al00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03oalO02LO00?o7al09al00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?o7al09al00olO7`0W7`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00olO7`0W7`03oalO02LO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?o7al09al00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00olO7`0W7`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
oalO02LO00?o7al09al00olO7`0W7`03o`0000@000060?go1P0000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?o7al09al00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml04Ml3oa;O0_lCg`?o4ml00ooOg`0Ag`;o
5=l00ooOg`0Ag`;o5=l00olO7`0@7`?o51l00olO7`0@7`?o51l00ol0000400001P000ooOg`0Bg`03
omoO017O0_lDg`03omoO01;O00?ogml04=l01?oOgolCg`03omoO013O00Cogmoo4ml00olO7`0A7`03
oalO01<O00?o7al04al00olO7`0A7`03o`0000@000060003omoO013O1?lBg`;o4]l4oa?O00?ogml0
4=l01?oOgolCg`03omoO013O00Cogmoo4ml00olO7`0A7`03oalO01<O00?o7al04al00olO7`0A7`03
o`0000@000060003omoO013O00?ogol04ml2oa;O00?ogol05=l00ooOg`0@g`?o5=l00ooOg`0Ag`;o
5=l00olO7`0A7`03oalO01<O00?o7al04Al2oa@O00?o0000100000H000?ogml04=l00ooOo`0Cg`;o
4]l00ooOo`0Dg`03omoO013O00?ogml05=l00ooOg`0@g`04omoOoa?O00?o7al04Al00olO7`0C7`03
oalO01<O00?o7al04Al00ol0000400001P000ooOg`0Ag`;o4ml2oa?O0_lDg`03omoO017O0olCg`03
omoO017O0_lDg`03oalO010O0_lE7`03oalO010O0olD7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03
oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?o7al0
9al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00olO7`0W7`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?o7al09al00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?o7al09al00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00olO7`0W7`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o7al09al00ol0000400001P3mo`H000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml04=l4oa;O0_lBg`Co4ml00ooOg`0Ag`?o
4ml00ooOg`0Ag`;o5=l00ooOg`0Ag`;o5=l00olO7`0@7`?o51l00ol0000400001P000ooOg`0Ag`03
omoO01;O0_lCg`03omoO01?O00?ogml04]l00ooOg`0Bg`03omoO013O00Cogmoo4ml00ooOg`0@g`04
omoOoa?O00?o7al04Al00olO7`0C7`03o`0000@000060003omoO01;O00?ogml04Ml2oaCO00?ogml0
4]l00ooOg`0@g`Co4ml00ooOg`0@g`04omoOoa?O00?ogml04=l01?oOgolCg`03oalO014O00?o7al0
4al00ol0000400001P000ooOg`0Cg`03omoO013O0_lEg`03omoO017O00?ogml04=l00ooOo`0Dg`03
omoO013O0olDg`03omoO017O0_lDg`03oalO014O00?o7al04al00ol0000400001P000ooOg`0@g`04
omoOoa;O0_lBg`04omoOoa?O00?ogml04=l00ooOo`0Dg`03omoO013O00?ogml05=l00ooOg`0@g`04
omoOoa?O00?o7al04Al00olO7`0C7`03o`0000@000060003omoO017O0_lCg`;o4ml2oaCO00?ogml0
4Ml2oaCO00?ogml04Ml3oa?O00?ogml04Ml2oaCO00?o7al041l2oaDO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00olO7`0W7`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
oalO02LO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al0
9al00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03oalO02LO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o7al09al00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00olO7`0W7`03o`0000@000060?go1P0000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml04Ml2oa?O0_lCg`;o
5=l00ooOg`0@g`Co4ml00ooOg`0Ag`?o4ml00ooOg`0Ag`;o5=l00ooOg`0Ag`;o5=l00ol000040000
1P000ooOg`0@g`04omoOoa;O0_lBg`04omoOoa?O00?ogml04Ml00ooOg`0Cg`03omoO01;O00?ogml0
4]l00ooOg`0@g`04omoOoa?O00?ogml04=l01?oOgolCg`03o`0000@000060003omoO013O00Cogmoo
4]l2oa;O00Cogmoo4ml00ooOg`0Bg`03omoO01;O00?ogml04=l4oa?O00?ogml04=l01?oOgolCg`03
omoO013O00Cogmoo4ml00ol0000400001P000ooOg`0@g`04omoOoa;O0_lBg`04omoOoa?O00?ogml0
4ml00ooOg`0Ag`03omoO013O00?ogol05=l00ooOg`0@g`?o5=l00ooOg`0Ag`;o5=l00ol000040000
1P000ooOg`0@g`04omoOoa;O0_lBg`04omoOoa?O00?ogml04=l01?oOgolCg`03omoO013O00?ogol0
5=l00ooOg`0@g`03omoO01CO00?ogml04=l01?oOgolCg`03o`0000@000060003omoO017O0_lCg`;o
4ml2oaCO00?ogml04Ml2oaCO00?ogml04Ml2oaCO00?ogml04Ml3oa?O00?ogml04Ml2oaCO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003
omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml0
9]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml09]l2obWO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?o0000100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00ol0000400001P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
o`0000@000060003omoO02KO0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000
100000H000?ogml09]l2obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol000040000
1P000ooOg`0Vg`;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000050?ko
1P0000D0o_l600001P000ol0000U00?o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
o`0000@000060003o`0002@000Co0?oo:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
o`0000@000060003o`0002<000?o00000_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO
00?o0000100000H000?o00008P001?l00002obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00ol0000400001P000ol0000Q0003o`0000800_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?o0000100000H000?o000080000ol0000300;o:Ml00ooOg`0Wg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03o`0000@000060003o`0001l000?o00001002obWO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00ol0000400001P000ol0000N0003o`0000D00_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o00007@000ol0000600;o:Ml00ooOg`0Wg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003o`0000P00_l00`3oo`0?0003o`0000L0
0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o00002@000ol0
o`0?0003o`0000P00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H0
00?o00002P000ol0000=0003o`0000T00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO
00?o0000100000H000?o00002@000ol0o`0=0003o`0000X00_lYg`03omoO02OO00?ogml09ml00ooO
g`0Wg`03omoO02OO00?o0000100000H000?o00002002o`030?oo00/000?o00002`02obWO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ol0000G0003o`0000`00_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o00005P000ol0000=00;o
:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003o`0001D000?o0000
3P02obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ol0000D0003
o`0000l00_lCg`;o5=l00ooOg`0@g`Co4ml00ooOg`0Ag`?o4ml00ooOg`0Ag`;o5=l00ooOg`0Ag`;o
5=l00ol0000400001P000ol0000C0003o`0001000_lBg`04omoOoa?O00?ogml04Ml00ooOg`0Cg`03
omoO01;O00?ogml04]l00ooOg`0@g`04omoOoa?O00?ogml04=l01?oOgolCg`03o`0000@000060003
o`00018000?o00004@02oa;O00Cogmoo4ml00ooOg`0Bg`03omoO01;O00?ogml04=l4oa?O00?ogml0
4=l01?oOgolCg`03omoO013O00Cogmoo4ml00ol0000400001P000ol0000A0003o`0001800_lBg`04
omoOoa?O00?ogml04ml00ooOg`0Ag`03omoO013O00?ogol05=l00ooOg`0@g`?o5=l00ooOg`0Ag`;o
5=l00ol0000400001P000ol0000@0003o`0001<00_lBg`04omoOoa?O00?ogml04=l01?oOgolCg`03
omoO013O00?ogol05=l00ooOg`0@g`03omoO01CO00?ogml04=l01?oOgolCg`03o`0000@000060003
o`0000l000?o00005002oa?O0_lDg`03omoO017O0_lDg`03omoO017O0_lDg`03omoO017O0olCg`03
omoO017O0_lDg`03o`0000@000060003o`0000h000?o00002003o`X00_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o00003@000ol0000:0003o`0000T00_lYg`03
omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o000030000ol0000<0003
o`0000P00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o0000
2`000ol0000=0003o`0000P00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000
100000H000?o00002P000ol0000=0003o`3o00T00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03
omoO02OO00?o0000100000H000?o00002@000ol0000>0003o`3o00T00_lYg`03omoO02OO00?ogml0
9ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o000020000ol0000>00;o00<0ool02002obWO
00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ol000070003o`0001`0
0_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H000?o00001P000ol0
000M00;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@000060003o`0000D0
00?o00007P02obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P000ol0
00040003o`0001l00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000100000H0
00?o00000`000ol0000P00;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@0
00060003o`00008000?o00008@02obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0
000400001P001Ol0003o02@00_lYg`03omoO02OO00?ogml09ml00ooOg`0Wg`03omoO02OO00?o0000
100000H000Co003o9@02obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol000040000
1P000ol0o`0V00;o:Ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ooOg`0Wg`03o`0000@0000600;o
9`02obWO00?ogml09ml00ooOg`0Wg`03omoO02OO00?ogml09ml00ol0000400001P3mo`H0000_00;o
f0000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P000?l02P000?l02P000?l02P0003001?o600?o3000034000?o0000a`000ol0
000;00002003o`800_l00`3oo`0200Co00<0ool00_l200Co0`03o`801Ol00`3oo`02ojd00_l00`3o
o`090003o`3o00T000?o00002P0000T000Go0000o`020004o`00o`@000Go0000o`030003o`000080
00Oo0000o`3o008000Co003o0`000ol0002[0003o`3o00/000?o000020000ol0000:00002@001Ol0
003o008000?o00001_l0103oool30003o`00008000Oo0000o`3o008000Co003o0`000ol0002/0003
o`0000P01Ol70003o`3o00/000070007o`3o0?l0o`020004o`00o`<00_l700;o0`001ol0003o0?l0
0P001?l00?l30003o`000:/000?o0?l02`000ol000070003o`3o00/000070006o`3o0?l01?l300?o
00<0o`000P000ol00002o`030?oo00800ol0103oo`02o`030?oo00?o[@02o`030?oo01<00_l00`3o
o`0:00001`05o`030?l000X01?o/00003002oo/0003o00X0003o00X00000\
\>"],
  ImageRangeCache->{{{0, 264.812}, {287, 0}} -> {-1.15003, -0.16397, 
  0.0237907, 0.0237907}},
  CellTags->"Closure"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[60]=",
  CellTags->"Closure"]
}, Open  ]],

Cell[TextData[{
  "The second argument of ",
  StyleBox["ClosedQ", "MR"],
  " can be a set, or a structure."
}], "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ClosedQ[LatticeRing[30], Elements[LatticeRing[15]]], 
      ClosedQ[LatticeRing[30], LatticeRing[15]]}\)], "Input",
  CellLabel->"In[61]:=",
  CellTags->"Closure"],

Cell[BoxData[
    \({True, True}\)], "Output",
  CellLabel->"Out[61]=",
  CellTags->"Closure"]
}, Open  ]],

Cell["3.3.7 Testing other properties", "Subsubsection",
  CellTags->"TestingOther"],

Cell[TextData[{
  "Given any finite ring ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ", the characteristic of the ring is the least positive integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`n\ x = 0\)]],
  " for all ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`R\)]],
  ". We can use the ",
  StyleBox["MultipleOfElement", "MR"],
  " function to determine values of ",
  Cell[BoxData[
      \(TraditionalForm\`n\ x\)]],
  ". An analogous function, ",
  StyleBox["ElementToPower", "MR"],
  ", returns the multiplicative equivalent, ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  "."
}], "Text",
  CellTags->"TestingOther"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ElementToPower",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ power\ \),
                  SingleLetterItalics->False], 
                FormBox[\(a\^n\),
                  "TraditionalForm"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["MultipleOfElement",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["a",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["n",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ multiple\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  StyleBox["na",
                    SingleLetterItalics->False,
                    FontSlant->"Italic"],
                  "TraditionalForm"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Characteristic",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["characteristic",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["R",
                  "TraditionalForm"],
                "Text"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.43, 0.57}},
  CellTags->{"TestingOther", "i:29"}],

Cell["Functions related to powers and multiples of elements.", "Caption",
  CellTags->"TestingOther"],

Cell[TextData[{
  "Here is a series of multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`\((3, 6)\)\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_6\[Times]\[DoubleStruckCapitalZ]\_9\)]],
  "."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[
      Map[{#, MultipleOfElement[DirectProduct[Z[6], Z[9]], {3, 6}, #]}&, 
        Range[\(-2\), 4]], \ 
      TableHeadings\  \[Rule] \ {None, \ {"\<n\>", "\<n (3,6)\n\>"}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"n\"\>", \("n (3,6)\n"\)},
          {\(-2\), \({0, 6}\)},
          {\(-1\), \({3, 3}\)},
          {"0", \({0, 0}\)},
          {"1", \({3, 6}\)},
          {"2", \({0, 3}\)},
          {"3", \({3, 0}\)},
          {"4", \({0, 6}\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"n", "n (3,6)\n"}}, 
        TableDepth -> 2]&)]], "Output",
  CellLabel->"Out[62]//TableForm=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[TextData[{
  "Changing ",
  StyleBox["MultipleOfElement", "MR"],
  " to ",
  StyleBox["ElementToPower", "MR"],
  ", we have a series of powers of ",
  Cell[BoxData[
      \(TraditionalForm\`\((3, 6)\)\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_6\[Times]\[DoubleStruckCapitalZ]\_9\)]],
  "."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[
      Map[{#, ElementToPower[DirectProduct[Z[6], Z[9]], {3, 6}, #]}&, 
        Range[\(-1\), 4]], \ 
      TableHeadings\  \[Rule] 
        \ {None, \ {"\<n\>", \*"\"\<(3,6\!\(\()\^n\)\)\\n\>\""}}, \ 
      TableDepth\  \[Rule] \ 2]\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \(Inverse::"fail" \( : \ \) 
      "\!\({3, 6}\) does not have an inverse in \!\(\"Mult(Z[6] x Z[9])\"\)."\
\)], "Message",
  CellTags->"TestingOther"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"n\"\>", \("(3,6\!\(\()\^n\)\)\n"\)},
          {\(-1\), "$Failed"},
          {"0", \({1, 1}\)},
          {"1", \({3, 6}\)},
          {"2", \({3, 0}\)},
          {"3", \({3, 0}\)},
          {"4", \({3, 0}\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"n", "(3,6\!\(\()\^n\)\)\n"}}, 
        TableDepth -> 2]&)]], "Output",
  CellLabel->"Out[63]//TableForm=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[TextData[{
  "The characteristic of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", the characteristic of any Boolean ring is 2, and the characteristic of a \
direct product is related to the characteristics of the factors."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Characteristic, 
      \ {\ BooleanRing[3], Z[6], Z[9], DirectProduct[Z[6], Z[9]]}]\)], "Input",\

  CellLabel->"In[64]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \({2, 6, 9, 18}\)], "Output",
  CellLabel->"Out[64]=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["IdempotentQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["r",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ an\ idempotent\ element\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["R",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox[\(i . e . \),
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[
                        RowBox[{\(r\^2\), " ", 
                          StyleBox["=",
                            SingleLetterItalics->False], 
                          StyleBox[" ",
                            FontSlant->"Italic"], 
                          StyleBox["r",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"]}],
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["Idempotents",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(return\ the\ list\ of\ idempotent\ elements\ of\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["NilpotentQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox[\(give\ \),
                      SingleLetterItalics->False], 
                    StyleBox["True",
                      "MR"], 
                    StyleBox[\(\ if\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["r",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ is\ a\ nilpotent\ element\ of\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["R",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ \((\(i . e . , \)\ \)\),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[
                        RowBox[{\(r\^k\), 
                          StyleBox["=",
                            SingleLetterItalics->False], " ", 
                          StyleBox["0",
                            SingleLetterItalics->False]}],
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\n",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["for",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["some",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["positive",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["k",
                        "TraditionalForm"],
                      "Text"]}]}], 
                StyleBox[")",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  "Text",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["Nilpotents",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[\(return\ the\ list\ of\ nilpotent\ elements\ of\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["R",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["NilpotentDegree",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["R",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["least",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["positive",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["integer",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["k",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ for\ which\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{\(r\^k\), 
                      StyleBox["=",
                        SingleLetterItalics->False], " ", 
                      StyleBox["0",
                        SingleLetterItalics->False]}],
                    "TraditionalForm"],
                  "Text"]}], 
              RowBox[{
                RowBox[{
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ if\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["r",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[\(is\ nilpotent\),
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["0",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["r",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ is\ not\ nilpotent\ in\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["R",
                      "TraditionalForm"],
                    "Text"]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"TestingOther", "i:30"}],

Cell["Other functions related to powers of an element.", "Caption",
  CellTags->"TestingOther"],

Cell[TextData[{
  "Here we test the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  " to see which are idempotent."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{#, IdempotentQ[Z[8], #]}&, \ Elements[Z[8]]]\)], "Input",
  CellLabel->"In[65]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \({{0, True}, {1, True}, {2, False}, {3, False}, {4, False}, {5, False}, {
        6, False}, {7, False}}\)], "Output",
  CellLabel->"Out[65]=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell["All elements of a Boolean ring are idempotent. ", "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Idempotents[BooleanRing[3]]\)], "Input",
  CellLabel->"In[66]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \({{}, {3}, {2}, {2, 3}, {1}, {1, 3}, {1, 2}, {1, 2, 3}}\)], "Output",
  CellLabel->"Out[66]=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[TextData[{
  "The element 6 is nilpotent in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_24\)]],
  " because ",
  Cell[BoxData[
      \(TraditionalForm\`6\^3 \[Congruent] \ 0\ \((mod\ 24)\)\)]],
  "."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NilpotentQ[Z[24], 6]\)], "Input",
  CellLabel->"In[67]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[67]=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[TextData[{
  "Here are the nilpotents of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_16\)]],
  "."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nilpotents[Z[16]]\)], "Input",
  CellLabel->"In[68]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \({0, 2, 4, 6, 8, 10, 12, 14}\)], "Output",
  CellLabel->"Out[68]=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[TextData[{
  "Here are the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_16\)]],
  " with their nilpotent degrees listed below."
}], "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Elements[Z[16]], \(NilpotentDegree[Z[16], #]&\)/@Elements[Z[16]]} // 
      TableForm[#, TableSpacing \[Rule] {1, 2}]&\)], "Input",
  CellLabel->"In[69]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", 
            "12", "13", "14", "15"},
          {"1", "0", "4", "0", "2", "0", "4", "0", "2", "0", "4", "0", "2", 
            "0", "4", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->2,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {1, 2}]&)]], "Output",
  CellLabel->"Out[69]//TableForm=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell["In a commutative ring, the nilpotents form an ideal.", "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IdealQ[Nilpotents[Z[24]], Z[24]]\)], "Input",
  CellLabel->"In[70]:=",
  CellTags->"TestingOther"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[70]=",
  CellTags->"TestingOther"]
}, Open  ]],

Cell[TextData[{
  "3.4 Built-in ",
  StyleBox["Ringoids",
    FontFamily->"Courier"]
}], "Subsection",
  CellTags->"i:31"],

Cell[TextData[{
  "There are several ringoids that are easily constructed by functions in the \
packages. By far the most important of the rings in elementary abstract \
algebra is the ring of integers mod ",
  Cell[BoxData[
      FormBox["n", TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[DoubleStruckCapitalZ]", "n"], TraditionalForm]]],
  "."
}], "Text",
  CellTags->"NumericRings"],

Cell["3.4.1 Numeric rings", "Subsubsection",
  CellTags->"NumericRings"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ZR",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(ring\ of\ integers\ mod\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ with\ mod\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["addition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ZR",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(ring\ of\ multiples\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["k",
                  "TraditionalForm"], 
                StyleBox[\(\ mod\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\(, \ if\)\ \),
                  SingleLetterItalics->False], 
                FormBox["k",
                  "TraditionalForm"], 
                StyleBox[\(\ is\ a\ divisor\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["ZR",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["n",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox["DefaultStructure",
                  "MR"], 
                StyleBox[\(\ is\ \),
                  SingleLetterItalics->False], 
                StyleBox["Ring",
                  "MR"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[" ",
                  "MR"], 
                StyleBox[
                  FormBox[\(Structure\  \[Rule] \ Ring\),
                    "TraditionalForm"],
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["ZR",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["n",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["ZR",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox[
                        RowBox[{
                          StyleBox["n",
                            SingleLetterItalics->False], \(, \ \), 
                          StyleBox["k",
                            SingleLetterItalics->False]}],
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox["DefaultStructure",
                  "MR"], 
                StyleBox[\(\ is\ \),
                  SingleLetterItalics->False], 
                StyleBox["Ring",
                  "MR"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Z",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["I",
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["ring",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["Gaussian",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["integers",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["mod",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], " ", "addition", " ", "and"}], " ", 
              RowBox[{"multiplication", 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["DefaultStructure",
                    "MR"], 
                  StyleBox[\(\ is\ \),
                    SingleLetterItalics->False], 
                  StyleBox["Ring",
                    "MR"]}]}]}]},
          {
            RowBox[{
              StyleBox["TrivialZR",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(ring\ of\ integers\ mod\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ with\ mod\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["addition",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["but",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["multiplication",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["zero",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["all",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["products",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["LatticeRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(divisors\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(LCM/GCD\),
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["for",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["addition",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(and\ GCD\ for\ multiplication\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"NumericRings", "i:32"}],

Cell["Some built-in numeric ringoids.", "Caption",
  CellTags->"NumericRings"],

Cell["Here we illustrate several ringoids with eight elements.", "Text",
  CellTags->"NumericRings"],

Cell[TextData[{
  "We\[CloseCurlyQuote]ve seen the ",
  StyleBox["Z", "MR"],
  " family many times already. We have mostly used the symbol ",
  StyleBox["Z", "MR"],
  ", but when using ",
  StyleBox["ZR", "MR"],
  " you know that you will get a ringoid in all cases."
}], "MathCaption",
  CellTags->"NumericRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZR[8]\)], "Input",
  CellLabel->"In[71]:=",
  CellTags->"NumericRings"],

Cell[BoxData[
    \(Ringoid[{0, 1, 2, 3, 4, 5, 6, 7}, Mod[#1 + #2, 8]&, Mod[#1\ #2, 8]&]
      \)], "Output",
  CellLabel->"Out[71]=",
  CellTags->"NumericRings"]
}, Open  ]],

Cell[TextData[{
  "The following ring happens to be an ideal of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_16\)]],
  "."
}], "MathCaption",
  CellTags->"NumericRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({R\  = \ Z[16, 2], \ IdealQ[R, Z[16]]}\)], "Input",
  CellLabel->"In[72]:=",
  CellTags->"NumericRings"],

Cell[BoxData[
    \({Ringoid[{0, 2, 4, 6, 8, 10, 12, 14}, Mod[#1 + #2, 16]&, 
        Mod[#1\ #2, 16]&], True}\)], "Output",
  CellLabel->"Out[72]=",
  CellTags->"NumericRings"]
}, Open  ]],

Cell["\<\
This is a standard counterexample in elementary algebra courses; \
any product is equal to zero.\
\>", "MathCaption",
  CellTags->"NumericRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[TrivialZR[8], \ Mode\  \[Rule] \ Visual]; \)\)], "Input",\

  CellLabel->"In[73]:=",
  CellTags->"NumericRings"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50265 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119678 0.47619 [
[ 0 0 0 0 ]
[ 1 .50265 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .50265 L
0 .50265 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119678 0.477324 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
1 .5 0 r
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.56 .37 .6 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
0 0 1 r
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.74 .99 .79 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.251 .878 .816 r
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
0 .79 .34 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 .392 0 r
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(0)] .18254 .81878 0 0 Mshowa
[(1)] .28836 .81878 0 0 Mshowa
[(2)] .39418 .81878 0 0 Mshowa
[(3)] .5 .81878 0 0 Mshowa
[(4)] .60582 .81878 0 0 Mshowa
[(5)] .71164 .81878 0 0 Mshowa
[(6)] .81746 .81878 0 0 Mshowa
[(7)] .92328 .81878 0 0 Mshowa
[(1)] .18254 .71296 0 0 Mshowa
[(2)] .28836 .71296 0 0 Mshowa
[(3)] .39418 .71296 0 0 Mshowa
[(4)] .5 .71296 0 0 Mshowa
[(5)] .60582 .71296 0 0 Mshowa
[(6)] .71164 .71296 0 0 Mshowa
[(7)] .81746 .71296 0 0 Mshowa
[(0)] .92328 .71296 0 0 Mshowa
[(2)] .18254 .60714 0 0 Mshowa
[(3)] .28836 .60714 0 0 Mshowa
[(4)] .39418 .60714 0 0 Mshowa
[(5)] .5 .60714 0 0 Mshowa
[(6)] .60582 .60714 0 0 Mshowa
[(7)] .71164 .60714 0 0 Mshowa
[(0)] .81746 .60714 0 0 Mshowa
[(1)] .92328 .60714 0 0 Mshowa
[(3)] .18254 .50132 0 0 Mshowa
[(4)] .28836 .50132 0 0 Mshowa
[(5)] .39418 .50132 0 0 Mshowa
[(6)] .5 .50132 0 0 Mshowa
[(7)] .60582 .50132 0 0 Mshowa
[(0)] .71164 .50132 0 0 Mshowa
[(1)] .81746 .50132 0 0 Mshowa
[(2)] .92328 .50132 0 0 Mshowa
[(4)] .18254 .3955 0 0 Mshowa
[(5)] .28836 .3955 0 0 Mshowa
[(6)] .39418 .3955 0 0 Mshowa
[(7)] .5 .3955 0 0 Mshowa
[(0)] .60582 .3955 0 0 Mshowa
[(1)] .71164 .3955 0 0 Mshowa
[(2)] .81746 .3955 0 0 Mshowa
[(3)] .92328 .3955 0 0 Mshowa
[(5)] .18254 .28968 0 0 Mshowa
[(6)] .28836 .28968 0 0 Mshowa
[(7)] .39418 .28968 0 0 Mshowa
[(0)] .5 .28968 0 0 Mshowa
[(1)] .60582 .28968 0 0 Mshowa
[(2)] .71164 .28968 0 0 Mshowa
[(3)] .81746 .28968 0 0 Mshowa
[(4)] .92328 .28968 0 0 Mshowa
[(6)] .18254 .18386 0 0 Mshowa
[(7)] .28836 .18386 0 0 Mshowa
[(0)] .39418 .18386 0 0 Mshowa
[(1)] .5 .18386 0 0 Mshowa
[(2)] .60582 .18386 0 0 Mshowa
[(3)] .71164 .18386 0 0 Mshowa
[(4)] .81746 .18386 0 0 Mshowa
[(5)] .92328 .18386 0 0 Mshowa
[(7)] .18254 .07804 0 0 Mshowa
[(0)] .28836 .07804 0 0 Mshowa
[(1)] .39418 .07804 0 0 Mshowa
[(2)] .5 .07804 0 0 Mshowa
[(3)] .60582 .07804 0 0 Mshowa
[(4)] .71164 .07804 0 0 Mshowa
[(5)] .81746 .07804 0 0 Mshowa
[(6)] .92328 .07804 0 0 Mshowa
[(0)] .07672 .81878 0 0 Mshowa
[(1)] .07672 .71296 0 0 Mshowa
[(2)] .07672 .60714 0 0 Mshowa
[(3)] .07672 .50132 0 0 Mshowa
[(4)] .07672 .3955 0 0 Mshowa
[(5)] .07672 .28968 0 0 Mshowa
[(6)] .07672 .18386 0 0 Mshowa
[(7)] .07672 .07804 0 0 Mshowa
[(0)] .18254 .9246 0 0 Mshowa
[(1)] .28836 .9246 0 0 Mshowa
[(2)] .39418 .9246 0 0 Mshowa
[(3)] .5 .9246 0 0 Mshowa
[(4)] .60582 .9246 0 0 Mshowa
[(5)] .71164 .9246 0 0 Mshowa
[(6)] .81746 .9246 0 0 Mshowa
[(7)] .92328 .9246 0 0 Mshowa
[(Addition)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119678 0.97619 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(0)] .18254 .81878 0 0 Mshowa
[(0)] .28836 .81878 0 0 Mshowa
[(0)] .39418 .81878 0 0 Mshowa
[(0)] .5 .81878 0 0 Mshowa
[(0)] .60582 .81878 0 0 Mshowa
[(0)] .71164 .81878 0 0 Mshowa
[(0)] .81746 .81878 0 0 Mshowa
[(0)] .92328 .81878 0 0 Mshowa
[(0)] .18254 .71296 0 0 Mshowa
[(0)] .28836 .71296 0 0 Mshowa
[(0)] .39418 .71296 0 0 Mshowa
[(0)] .5 .71296 0 0 Mshowa
[(0)] .60582 .71296 0 0 Mshowa
[(0)] .71164 .71296 0 0 Mshowa
[(0)] .81746 .71296 0 0 Mshowa
[(0)] .92328 .71296 0 0 Mshowa
[(0)] .18254 .60714 0 0 Mshowa
[(0)] .28836 .60714 0 0 Mshowa
[(0)] .39418 .60714 0 0 Mshowa
[(0)] .5 .60714 0 0 Mshowa
[(0)] .60582 .60714 0 0 Mshowa
[(0)] .71164 .60714 0 0 Mshowa
[(0)] .81746 .60714 0 0 Mshowa
[(0)] .92328 .60714 0 0 Mshowa
[(0)] .18254 .50132 0 0 Mshowa
[(0)] .28836 .50132 0 0 Mshowa
[(0)] .39418 .50132 0 0 Mshowa
[(0)] .5 .50132 0 0 Mshowa
[(0)] .60582 .50132 0 0 Mshowa
[(0)] .71164 .50132 0 0 Mshowa
[(0)] .81746 .50132 0 0 Mshowa
[(0)] .92328 .50132 0 0 Mshowa
[(0)] .18254 .3955 0 0 Mshowa
[(0)] .28836 .3955 0 0 Mshowa
[(0)] .39418 .3955 0 0 Mshowa
[(0)] .5 .3955 0 0 Mshowa
[(0)] .60582 .3955 0 0 Mshowa
[(0)] .71164 .3955 0 0 Mshowa
[(0)] .81746 .3955 0 0 Mshowa
[(0)] .92328 .3955 0 0 Mshowa
[(0)] .18254 .28968 0 0 Mshowa
[(0)] .28836 .28968 0 0 Mshowa
[(0)] .39418 .28968 0 0 Mshowa
[(0)] .5 .28968 0 0 Mshowa
[(0)] .60582 .28968 0 0 Mshowa
[(0)] .71164 .28968 0 0 Mshowa
[(0)] .81746 .28968 0 0 Mshowa
[(0)] .92328 .28968 0 0 Mshowa
[(0)] .18254 .18386 0 0 Mshowa
[(0)] .28836 .18386 0 0 Mshowa
[(0)] .39418 .18386 0 0 Mshowa
[(0)] .5 .18386 0 0 Mshowa
[(0)] .60582 .18386 0 0 Mshowa
[(0)] .71164 .18386 0 0 Mshowa
[(0)] .81746 .18386 0 0 Mshowa
[(0)] .92328 .18386 0 0 Mshowa
[(0)] .18254 .07804 0 0 Mshowa
[(0)] .28836 .07804 0 0 Mshowa
[(0)] .39418 .07804 0 0 Mshowa
[(0)] .5 .07804 0 0 Mshowa
[(0)] .60582 .07804 0 0 Mshowa
[(0)] .71164 .07804 0 0 Mshowa
[(0)] .81746 .07804 0 0 Mshowa
[(0)] .92328 .07804 0 0 Mshowa
[(0)] .07672 .81878 0 0 Mshowa
[(1)] .07672 .71296 0 0 Mshowa
[(2)] .07672 .60714 0 0 Mshowa
[(3)] .07672 .50132 0 0 Mshowa
[(4)] .07672 .3955 0 0 Mshowa
[(5)] .07672 .28968 0 0 Mshowa
[(6)] .07672 .18386 0 0 Mshowa
[(7)] .07672 .07804 0 0 Mshowa
[(0)] .18254 .9246 0 0 Mshowa
[(1)] .28836 .9246 0 0 Mshowa
[(2)] .39418 .9246 0 0 Mshowa
[(3)] .5 .9246 0 0 Mshowa
[(4)] .60582 .9246 0 0 Mshowa
[(5)] .71164 .9246 0 0 Mshowa
[(6)] .81746 .9246 0 0 Mshowa
[(7)] .92328 .9246 0 0 Mshowa
[(Multiplication)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
(0) show
105.000000 13.000000 moveto
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[73]:=",
  ImageSize->{288, 144.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0000X0O?lC07co2`0000X000?oD5002U02o`a@00?ogml02ml07OmOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm7ko00a<02[oeP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3P
X?lC0003oe1@00U@0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooO
g`0:g`03omoO00_O00?o00002@0000X000goT52@D91@T52@D91@00;o00f@D91@T52@D91@T53o00gO
01goGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiao`0<C00Zo`<?0`l33`<?0`l33`?ol@ka3_4>l@ka
3_4>lOnPh:3PX>2Ph:3PX>3o4`003?m@T52@D91@T52@D0;o3Ml00ooOg`0;g`03omoO00[O00?ogml0
2ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003oe1@00Y@0_l<D003
omoO00_O01goGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Ano`0<C00ZomH3eP?F0mH3eP?F0mKo/0j`
3[0>/0j`3[0>/?oPX>2Ph:3PX>2Ph:3o4`000om@D009D0;o3Ml00ooOg`0;g`03omoO00[O00?ogml0
2ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:000=oi1@T52@D91@T52@
D002o`0=T52@D91@T52@D91@o`0=g`0MoenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLOl034`0:_l3
3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3Poa<000coD91@T52@D91@T502o`gO
00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0
000900002P000om@D003D003oe1@00A@0_l4D003oe1@00E@00?ogml00ml2o`KO00GoGimOW`03o`0;
WenOGimOogkdO_@01?l01WkdO_Ano`=<0ol6C006omH3eP?F0ol02]H3eP?Fok0>/0h3o`0<3[0>/0j`
on2Ph:3P0_l01Z3PX>2Poa<000?oD5000U000om@D004D0;o1Ml2o`KO00?ogml00ml2o`KO00?ogml0
0ml2o`GO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00]l2o`KO00?ogml0
0ml2o`KO00?o00002@0000X000goT52@D93oT52@D91@00;o00f@D91@oe2@D91@T53o00CO00Cogmoo
1Ml07OmOWenOGomOWenOGimOog5nLGiaog5nLGiaOW7o00I<00?oC4`00d`0:_l33`<?0`oo3`<?0`l3
oo4>l@ka3_7ol@ka3_7oX>2Ph?oPX?nPh:3Poa<000coD91@T?n@D91@T502o`CO00Cogmoo1Ml00ooO
g`02g`04omoOo`GO00?ogml00]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol5g`05omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol000090000
2P000om@D004D003oe1@00=@0_l5D003oe1@00A@00?ogml00]l01?oOgol5g`0MoenOGimOoenOGimO
WeooO_Anm7kdooAnm7kdO_l01T`00om<C003C005omH3eP<01?l08MH3eP?Fok0>/0j`3[3o/0j`3[3o
h:3PX?nPh?oPX>2Po`0C0003oe1@00=@00?oD5000e02o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oO
gol5g`05omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol0000900002P003On@D91@T53o
D91@T5000_l03I1@T52@oi1@T52@D?l01=l01?oOgol5g`0MoenOGimOoenOGimOWeooLGiaOW5nLOma
OW5nLOl014`2o`I<01?o0`l33ol?o`l33`<?0ooa3_4>00?o00/>l@ka3_7oX>2Ph003o`06h:3PX>3o
4`003?m@T52@D?m@T52@D0;o1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO
00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03
omoO00?O00?ogml00]l01?oOgol5g`03o`0000T0000:0003oe1@00E@00?oD5000U02o`I@00?oD500
0e000ooOg`02g`04omoOo`GO01goGimOWeooGimOWenOGomnm7kdooAnogkdO_Ano`06C003oda<00=<
02[oeP?F0ol3o`?F0mH3e_n`3[0>o`j`3[0>/0j`on2Ph:3oX>2Ph:3PX?lC0003oe1@00A@00?oD500
0U02o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol4g`03omoO00;O00Cogmoo
1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`05omoOgol00]l00ooOg`03g`03omoO00;O
00Cogmoo1Ml00ol0000900002P001On@D91@00Co00B@D91@0_l00i1@T004o`06D91@T53o1Ml2o`KO
00GoGimOW`02o`0=GimOWenOGomaOW5nL@02o`07OW5nLGiao`03C0?o1T`01_l33`<?0`;o00/?0`l3
3`?ol@ka3P04o`0;l@ka3_7oX>2Ph:000ol01J3PX>3o01<000CoD91@1?l0191@T502o`GO0_l6g`03
omoO00?O0_l6g`03omoO00?O0_l5g`03omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00?O0_l6g`03
omoO00;O0_l6g`03omoO00?O0_l6g`03o`0000T0000:0003oe1@00Y@0_l<D003omoO00_O01goGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Ano`0<C00ZomH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/?oP
X>2Ph:3PX>2Ph:3o4`000om@D009D0;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03
omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:000=oi1@T52@D91@T52@D002o`0=T52@D91@
T52@D91@o`0=g`0MoenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLOl034`0:_l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3Poa<000coD91@T52@D91@T502o`gO00?ogml02ml00ooO
g`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P000om@
D00:D0;o35000ooOg`0;g`0MoenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_l034`0:_oF0mH3eP?F
0mH3eP?Fok0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Poa<000?oD5002E02o`gO00?ogml02ml00ooO
g`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P1loa<0
O?l;00002P003OoPX>2Ph:3PX>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E000ooOg`0;g`0LoenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdo`e<01coeP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0ko4`003?nP
h:3PX>2Ph:3PX0;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml0
2]l00ooOg`0;g`03o`0000T0000:000=oj3PX>2Ph:3PX>2Ph002o`0KX>2Ph:3PX>2Ph:3Poe2@D91@
T52@D91@T53o00gO01coGimOWenOGimOWenOGomaOW5nLGiaOW5nLGko3D`07?l33`<?0`l33`<?0`l3
oo4>l@ka3_4>l@ka3_lC000<on2Ph:3PX>2Ph:3P0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03
omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000goh:3PX>2Ph:3PX>2P00;o
00gPX>2Ph:3PX>2Ph:3o00e@00?ogml02ml07?mOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?l=C00L
omH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>oa<000coX>2Ph:3PX>2Ph:02o`gO00?ogml02ml00ooO
g`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003OnP
h:3PX>2Ph:3PX>000_l06j3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D91@o`0=g`0LoenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5no`e<01co0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ko4`003?oPX>2Ph:3P
X>2Ph0;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooO
g`0;g`03o`0000T0000:0006on2Ph:3P0_l01J3PX>2P00;o00CPX>2P0_l01n2Ph:3PX?l01E000om@
D005D003omoO00?O0_l6g`05oenOGil00ol02YmOWenOGomnm7h4o`06m7kdO_Co14`3o`I<00KoeP?F
0mH3o`0:eP?F0mKo/0j`3P?o00H>/0j`3_lC0005oj3PX>000_l01J3PX>2P00;o1Ml2o`KO00?ogml0
0ml2o`KO00?ogml00ml2o`GO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml0
0]l2o`KO00?ogml00ml2o`KO00?o00002@0000X000goX>2Ph?oPX?nPh:3P00;o01^Ph:3oX>3oh:3P
X>3oD91@T53oD91@T52@D?l01=l01?oOgol5g`0LoenOGimOoenOGimOWeooLGiaO_mnLGiaOW5no`M<
00?oC4`00d`07?l33`<?0`oo3`<?0`l3oo4>l@ka3_7ol@ka3_lC000<on2Ph?oPX?nPh:3P0_l4g`04
omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO00?ogml0
0]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04omoOo`GO
00?o00002@0000X000goh:3PX?nPh?oPX>2P00;o00gPX>3oh:3oX>2Ph:3o00I@00?oD50015000ooO
g`02g`04omoOo`GO01coGimOWeooGimOWenOGomnm7kdO_mnm7kdO_Co1d`00om<C003C005omH3eP<0
1?l04mH3eP?Fok0>/0j`3[3o/0j`3_l04`003?nPh:3oX>3oh:3PX0;o1=l01?oOgol5g`03omoO00;O
00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooO
g`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O00?ogml00]l01?oOgol5g`03o`0000T0000:0005
oj3PX>000ol01N2Ph:3P00;o00>Ph:000ol05J3PX>2Ph?m@T52@D93oT52@D91@o`04g`04omoOo`GO
01coGimOWeooGimOWenOGomaOW5nLGkoOW5nLGko1D`2o`I<01?o0`l33ol?o`l33`<?0ooa3_4>00?o
00H>l@ka3_lC0004on2Ph0?o00GPX>2Ph002o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml0
0]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`05
omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol0000900002P003OoPX>2Poj3PX>2Ph:00
0_l03N2Ph?oPX>2Ph:3PX?l01e000om@D003D003omoO00;O00Cogmoo1Ml07?mOWenOGomOWenOGimO
ogkdO_mnm?odO_Anm?l7C003oda<00=<01coeP?F0ol3o`?F0mH3e_n`3[0>o`j`3[0>/0ko4`003?nP
h:3oX>2Ph:3PX0;o1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml0
0]l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O
00?ogml00]l01?oOgol5g`03o`0000T0000:0006oj3PX>2P0ol01:3PX>02o`04X>2Ph0?o00[PX>2P
h?m@T52@1?l01U2@D91@o`GO0_l6g`05oenOGil00_l035nOGimOWeooLGiaOP;o00MaOW5nLGko00A<
0ol6C006o`<?0`l30_l02`l33`<?0ooa3_4>00Co00Ga3_4>o`0C0005on2Ph:000ol01:3PX>02o`GO
0_l6g`03omoO00?O0_l6g`03omoO00?O0_l5g`03omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00?O
0_l6g`03omoO00;O0_l6g`03omoO00?O0_l6g`03o`0000T0000:000=on2Ph:3PX>2Ph:3PX002o`0=
h:3PX>2Ph:3PX>2Po`0=D003omoO00_O01coGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Co3D`07?oF
0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3_lC000<oj3PX>2Ph:3PX>2P0_l=g`03omoO00_O00?ogml0
2]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000goX>2P
h:3PX>2Ph:3P00;o01^Ph:3PX>2Ph:3PX>3oD91@T52@D91@T52@D?l03Ml07?mOWenOGimOWenOGimO
og5nLGiaOW5nLGiaO_l=C00Lo`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>oa<000coh:3PX>2Ph:3P
X>02o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml0
2ml00ol0000900002P003OoPX>2Ph:3PX>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E000ooOg`0;g`0L
oenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdo`e<01coeP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0ko
4`003?nPh:3PX>2Ph:3PX0;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O
00?ogml02]l00ooOg`0;g`03o`0000T0000:07co4`1lo`/0000:000=ok0>/0j`3[0>/0j`3P02o`0K
/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3o00e@00?ogml02ml07?mOWenOGimOWenOGioom7kdO_An
m7kdO_Anm?l=C00>omH3eP?F0mH3eP?F0olC000<o`j`3[0>/0j`3[0>0_l=g`03omoO00_O00?ogml0
2]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000gol@ka
3_4>l@ka3_4>00;o02Wa3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D91@o`0=g`0L
oenOGimOWenOGimOWomnLGiaOW5nLGiaOW5no`e<00ko0`l33`<?0`l33`<?oa<000co3_4>l@ka3_4>
l@h2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml0
2ml00ol0000900002P003On`3[0>/0j`3[0>/0h00_l06k0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2P
o`0=D003omoO00_O01coGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Co3D`03_oF0mH3eP?F0mH3eP?o
4`003?l>/0j`3[0>/0j`3P;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O
00?ogml02]l00ooOg`0;g`03o`0000T0000:000=oo4>l@ka3_4>l@ka3P02o`0Yl@ka3_4>l@ka3_4>
on2Ph:3PX>2Ph:3PX>3oD91@T52@D91@T52@D?l03Ml07?mOWenOGimOWenOGiooOW5nLGiaOW5nLGia
O_l=C00>o`<?0`l33`<?0`l33olC000<o`ka3_4>l@ka3_4>0_l=g`03omoO00_O00?ogml02]l00ooO
g`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000Go/0j`3P03o`05
3[0>/0h00_l00k0>/003o`0</0j`3[0>oj3PX>2P0_l01n2Ph:3PX?l01E000om@D005D003omoO00?O
0_l6g`04oenOG`?o00]OWenOGioom7kdOP04o`06m7kdO_Co14`3o`I<00KoeP?F0mH3o`05eP?F0ol0
4`001?l>/0h3o`053[0>/0h00_l5g`;o1]l00ooOg`03g`;o1]l00ooOg`03g`;o1Ml00ooOg`03g`;o
1]l00ooOg`03g`;o1]l00ooOg`03g`;o1]l00ooOg`02g`;o1]l00ooOg`03g`;o1]l00ol000090000
2P003Ooa3_4>l@kaoo4>l@h00_l0:O4>l@ka3_l>l@ka3_oPX>2Poj3Pon2Ph:3Poe2@D91@oe2@D91@
T53o00CO00Cogmoo1Ml07?mOWenOoimOWenOGiooOW5nLGkoOW5nLGiaO_l7C003oda<00=<00ko0`l3
3`<?o`l33`<?oa<000co3_4>l@kaoo4>l@h2o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml0
0]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`05
omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol0000900002P003On`3[0>/0j`ok0>/0h0
0_l06k0>/0j`3_l>/0j`3_nPh:3Pon2Poj3PX>2Po`06D003oe1@00A@00?ogml00]l01?oOgol5g`0L
oenOGiooWenOGimOWoodO_Anm7koO_Anm7kdo`M<00?oC4`00d`01OoF0mH300Co00GF0mH3o`0C000<
o`j`3[0>/?n`3[0>0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooO
g`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml0
0ml00ooOg`02g`04omoOo`GO00?o00002@0000X000Gol@ka3P03o`053_4>l@h00_l00o4>l@03o`0;
l@ka3_4>on2Ph:000ol05J3PX>2Ph?m@T52@D93oT52@D91@o`04g`04omoOo`GO01coGimOWonOGimO
WenOogiaOW5nLGkoOW5nLGko1D`2o`I<00ko0`l33ol?o`l33`<?oa<000Co3_4>0ol01@ka3_4>00;o
1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml00]l01?oOgol5g`03
omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O00?ogml00]l01?oO
gol5g`03o`0000T0000:000=ok0>/0ko3[0>/0j`3P02o`0K/0j`ok0>/0j`3[0>oj3PX>3oh:3PX>2P
h:3o00M@00?oD5000e000ooOg`02g`04omoOo`GO01coGimOWonOGimOWenOooAnm7koO_Com7kdO_Co
1d`00om<C003C00>omH3eP?o0ol3eP?F0olC000<o`j`3_l>/0j`3[0>0_l4g`04omoOo`GO00?ogml0
0]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03
omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04omoOo`GO00?o00002@0000X0
00Gol@ka3P04o`04l@ka3P;o00?a3_401?l02`ka3_4>on2Ph:3P00?o00[PX>2Ph?m@T52@1?l01U2@
D91@o`GO0_l6g`04oenOG`;o00fOGimOWenOogiaOW5n00;o00MaOW5nLGko00A<0ol6C006o`<?0`l3
0_l01Pl33`<?oa<000Co3_4>1?l01?4>l@h2o`GO0_l6g`03omoO00?O0_l6g`03omoO00?O0_l5g`03
omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00;O0_l6g`03omoO00?O0_l6g`03
o`0000T0000:000=ok0>/0j`3[0>/0j`3P02o`0K/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3o00e@
00?ogml02ml07?mOWenOGimOWenOGioom7kdO_Anm7kdO_Anm?l=C00>omH3eP?F0mH3eP?F0olC000<
o`j`3[0>/0j`3[0>0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooO
g`0:g`03omoO00_O00?o00002@0000X000gol@ka3_4>l@ka3_4>00;o02Wa3_4>l@ka3_4>l@koh:3P
X>2Ph:3PX>2Ph?m@T52@D91@T52@D91@o`0=g`0LoenOGimOWenOGimOWomnLGiaOW5nLGiaOW5no`e<
00ko0`l33`<?0`l33`<?oa<000co3_4>l@ka3_4>l@h2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O
00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003On`3[0>/0j`3[0>/0h0
0_l06k0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Po`0=D003omoO00_O01coGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Co3D`03_oF0mH3eP?F0mH3eP?o4`003?l>/0j`3[0>/0j`3P;o3Ml00ooOg`0;g`03
omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:07co
4`1lo`/0000:000=omH3eP?F0mH3eP?F0`02o`0YeP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0koX>2P
h:3PX>2Ph:3PX?l03E000ooOg`0:g`0MoimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm?l034`00ol0
000A000<o`?F0mH3eP?F0mH30_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml0
2ml00ooOg`0:g`03omoO00_O00?o00002@0000X000go0`l33`<?0`l33`<?00;o03L33`<?0`l33`<?
0`oo3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T53o00cO01goWenOGimOWenO
GimOWomnLGiaOW5nLGiaOW5no`0<C003o`00014000co3`<?0`l33`<?0`l2o`gO00?ogml02ml00ooO
g`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003OoF
0mH3eP?F0mH3eP<00_l0:MH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3o00e@
00?ogml02]l07OnOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Co00a<00?o00004@003?l3eP?F0mH3
eP?F0`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooO
g`0;g`03o`0000T0000:0006o`<?0`l30ol010<?0`l2o`040`l33`?o00X?0`l33ol>l@ka0ol03?4>
l@ka3_oPX>2Ph0;o01FPh:3PX>3oD91@T53oD91@T52@D?l01=l2o`KO00GoWenOG`03o`0;GimOWenO
ogiaOW401?l01WiaOW5no`A<0ol5C003o`00014000Go3`<?0`03o`040`l33`;o1Ml2o`KO00?ogml0
0ml2o`KO00?ogml00ml2o`GO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml0
0]l2o`KO00?ogml00ml2o`KO00?o00002@0000X000goeP?F0mH3o`?F0mH300;o02WF0mH3e_oF0mH3
eP?o3[0>/0j`3_l>/0j`3_nPh:3Pon2Poj3PX>2Po`05D003oe1@00E@00GogmoOo`02g`03omoO00?O
01goWenOGiooWenOGimOWoodO_Anm?odO_Anm7kdo`07C003oda<009<00?o00004@003?l3eP?F0ol3
eP?F0`;o1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml00]l01?oO
gol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O00?ogml0
0]l01?oOgol5g`03o`0000T0000:0005o`<?0`l01?l010<?0`l2o`030`l300Co030?0`l33ol>l@ka
3_4>o`ka3_4>on2Ph:3oX>3oh:3PX>3oD91@T52@oi1@T52@D?l3g`04omoOo`GO01goWenOGiooWenO
GimOWomnLGiaOW7oLGiaOW5no`07C003oda<009<00?o00004@001?l?0`l4o`040`l33`;o1=l01?oO
gol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml00]l01?oOgol5g`03omoO00;O
00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O00?ogml00]l01?oOgol5g`03
o`0000T0000:000=omH3eP?o0ol3eP?F0`02o`0AeP?FomKoeP?F0mH3o`j`3[000ol02k0>/0j`3_nP
h:3P00?o00OPX>2Ph:3o00I@00?oD50015001OoOgmoo00;O00?ogml00ml07OnOGimOWonOGimOWenO
ooAnm7kdO_Com7kdO_Co00E<0_l5C003o`00014000co0mH3o`?o0mH3eP<2o`CO00Cogmoo1Ml00ooO
g`02g`04omoOo`GO00?ogml00]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol5g`05omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol000090000
2P003Ol33`<?o`oo3`<?0`l00_l0=`<?0ol3o`<?0`l33ol>l@kaoo4>l@ka3_4>on2Ph:3oX>2Ph:3P
X>3oD91@T52@D?m@T52@D?l00ml01?oOgol5g`0MoimOWenOoimOWenOGiooOW5nLOmaO_mnLGiaO_l0
1d`00om<C002C003o`00014000co3`<?o`oo3`<?0`l2o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oO
gol5g`05omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol0000900002P001_oF0mH3eP;o
00D3eP?F0`02o`04eP?F0`;o00_F0mH3eP?o3[0>/004o`0;3[0>/0koX>2Ph:000ol01Z3PX>2Po`A@
1?l5D003omoO00;O0_l6g`05oimOWel00_l03ImOWenOGioom7kdO_@00_l01gkdO_Anm?l014`3o`E<
00?o00004@001Ol3eP?F00;o00D3eP?F0`02o`GO0_l6g`03omoO00?O0_l6g`03omoO00?O0_l5g`03
omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00;O0_l6g`03omoO00?O0_l6g`03
o`0000T0000:000=o`<?0`l33`<?0`l33`02o`0g0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@koh:3P
X>2Ph:3PX>2Ph?m@T52@D91@T52@D91@o`0<g`0MoimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaO_l0
34`00ol0000A000<o`l33`<?0`l33`<?0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O
00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000goeP?F0mH3eP?F0mH300;o02WF0mH3
eP?F0mH3eP?o3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Po`0=D003omoO00[O01goWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdo`0<C003o`00014000co0mH3eP?F0mH3eP<2o`gO00?ogml02ml00ooO
g`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003Ol3
3`<?0`l33`<?0`l00_l0=`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>3oD91@
T52@D91@T52@D?l03=l07OnOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGko00a<00?o00004@003?l?
0`l33`<?0`l33`;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml0
2]l00ooOg`0;g`03o`0000T0000:07co4`1lo`/0000:0003oda<00Y<0_l<C00ho`l33`<?0`l33`<?
0`oo3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T?l=g`0LoimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaoa<000?oC4`02D`2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml0
2ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P000om<C00:C0;o34`0:ol3eP?F0mH3
eP?F0mH3o`j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX?l035000ooOg`0;g`0LoimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anoa<000?oC4`02D`2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml0
2ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P000om<C00:C0;o34`0>?l?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D93o3Ml07?nOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLOlC0003oda<00U<0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03
omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000?oC4`02T`2o`a<02_o0mH3
eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph:3o00a@00?ogml02ml07?nOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_lC0003oda<00U<0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03
omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000?oC4`00T`3o`E<0_l3C0?o
1T`01_l?0`l33`?o00X?0`l33ol>l@ka0ol03?4>l@ka3_oPX>2Ph0;o01BPh:3PX>3oD91@T?n@D91@
T52@o`GO0_l6g`05oimOWel00ol02enOGimOWomnLGia00Co00EnLGiao`0C0004oda<C0?o1D`2o`GO
0_l6g`03omoO00?O0_l6g`03omoO00?O0_l5g`03omoO00?O0_l6g`03omoO00?O0_l6g`03omoO00?O
0_l6g`03omoO00;O0_l6g`03omoO00?O0_l6g`03o`0000T0000:0003oda<00E<00?oC4`00T`2o`I<
00?oC4`00d`0:ol3eP?F0mKoeP?F0mH3o`j`3[0>/0ko3[0>/0koX>2Ph?oPX?nPh:3PX?l015000om@
D005D003omoO00;O00Cogmoo1Ml07?nOGimOWonOGimOWenOooAnm7kdooAnm7kdO_lC0003oda<00A<
00?oC4`00T`2o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol4g`03omoO00;O
00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`05omoOgol00]l00ooOg`03g`03
omoO00;O00Cogmoo1Ml00ol0000900002P000om<C005C003oda<009<0_l6C003oda<00=<00Go3`<?
0`04o`0_3`<?0`oo3_4>l@ka3_l>l@ka3_oPX>2Poj3Pon2Ph:3Poe2@D91@oe2@D91@T?l01=l01?oO
gol5g`0LoimOWenOoimOWenOGiooOW5nLGiaog5nLGiaoa<000?oC4`014`00om<C002C0;o1=l01?oO
gol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml00]l01?oOgol5g`03omoO00;O
00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O00?ogml00]l01?oOgol5g`03
o`0000T0000:0003oda<00=<0_l5C0;o14`2o`I<01?o0mH3e_oFomH3eP?F0ol>/0j`00?o00^`3[0>
/0koX>2Ph003o`07h:3PX>2Po`05D003oe1@00A@00?ogml00]l01?oOgol5g`0LoimOWenOoimOWenO
Gioom7kdO_Anm?odO_Anoa<000?oC4`00T`2o`E<0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03
omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo
1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04omoOo`GO00?o00002@0000X000?oC4`01D`00om<
C002C0;o1T`00om<C003C00ho`l33`?o0ol33`<?0`oo3_4>lOoa3_4>l@ka3_oPX>2Poj3PX>2Ph:3P
oe2@D91@T?n@D91@T?l4g`04omoOo`GO01coWenOGiooWenOGimOWomnLGiaog5nogiaOW7o4`000om<
C004C003oda<009<0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooO
g`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml0
0ml00ooOg`02g`04omoOo`GO00?o00002@0000X000?oC4`00T`3o`E<0_l3C0?o1T`01_l3eP?F0`;o
00_F0mH3eP?o3[0>/004o`0;3[0>/0koX>2Ph:000ol01Z3PX>2Po`=@1?l5D003omoO00?O0_l6g`05
oimOWel00_l03ImOWenOGioom7kdO_@00_l01WkdO_Anoa<000CoC4a<0ol5C0;o1Ml2o`KO00?ogml0
0ml2o`KO00?ogml00ml2o`GO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml0
0]l2o`KO00?ogml00ml2o`KO00?o00002@0000X000?oC4`02T`2o`a<03So3`<?0`l33`<?0`l33ol>
l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>3oD91@T52@D91@T52@o`gO01coWenOGimOWenOGimOWomn
LGiaOW5nLGiaOW7o4`000om<C009C0;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03
omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003oda<00Y<0_l<C00[o`?F0mH3eP?F0mH3
eP?o3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>2Po`0<D003omoO00_O01coWenOGimOWenOGimOWood
O_Anm7kdO_Anm7ko4`000om<C009C0;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03
omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0003oda<00Y<0_l<C00ho`l33`<?0`l33`<?
0`oo3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3Poe2@D91@T52@D91@T?l=g`0LoimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiaoa<000?oC4`02D`2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml0
2ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P1loa<0O?l;00002P003OmnLGiaOW5n
LGiaOW400_l03GiaOW5nLGiaOW5nLOl03D`0>?l?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@koh:3P
X>2Ph:3PX>2Poi1@T52@D91@T52@D93o3Ml03_nOGimOWenOGimOWeoo4`003?maOW5nLGiaOW5nL@;o
3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03
o`0000T0000:000=ooAnm7kdO_Anm7kdOP02o`0=m7kdO_Anm7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3
eP?o3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>3o3E000ooOg`0;g`0>oimOWenOGimOWenOGolC000<
ogkdO_Anm7kdO_An0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooO
g`0:g`03omoO00_O00?o00002@0000X000goOW5nLGiaOW5nLGia00;o00enLGiaOW5nLGiaOW7o00e<
03So3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@o`gO
00koWenOGimOWenOGimOoa<000coLGiaOW5nLGiaOW42o`gO00?ogml02ml00ooOg`0:g`03omoO00_O
00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003OodO_Anm7kdO_Anm7h0
0_l03OAnm7kdO_Anm7kdO_l03D`0:_l3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0koX>2Ph:3PX>2P
h:3Po`e@00?ogml02ml03_nOGimOWenOGimOWeoo4`003?mnm7kdO_Anm7kdOP;o3Ml00ooOg`0;g`03
omoO00[O00?ogml02ml00ooOg`0;g`03omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:0005
ogiaOW401?l017iaOW42o`03OW5n00Co00IaOW5nLOl4C0?o1T`01_l?0`l33`?o00X?0`l33ol>l@ka
0ol02o4>l@ka3_oPX>2P00;o01GPX>2Ph:3oT52@D93oT52@D91@T?l01Ml2o`KO00GoWenOG`03o`06
GimOWeoo4`001?maOW44o`04OW5nL@;o1Ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`GO00?ogml0
0ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00]l2o`KO00?ogml00ml2o`KO00?o0000
2@0000X000gom7kdO_Com7kdO_An00;o00gdO_AnogkdO_Anm7ko00M<00?oC4`00d`0:_l3eP?F0mKo
eP?F0mH3o`j`3[0>/0ko3[0>/0koX>2Poj3Pon2Ph:3Po`E@00?oD5001E000ooOg`02g`04omoOo`GO
00koWenOGiooWenOGimOoa<000coO_Anm?odO_Anm7h2o`CO00Cogmoo1Ml00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol4g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00?ogml00]l01?oO
gol5g`05omoOgol00]l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol0000900002P003OmnLGiaOW7o
LGiaOW400_l03GiaOW5nogiaOW5nLOl01d`00om<C003C005o`l33`<01?l0;`l33`<?o`ka3_4>l@ko
3_4>l@koh:3Pon2Poj3PX>2Poi1@T52@D?m@T52@D93o00CO00Cogmoo1Ml03_nOGimOWonOGimOWeoo
4`003?maOW5nLOmaOW5nL@;o1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO
00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03
omoO00?O00?ogml00]l01?oOgol5g`03o`0000T0000:000=ooAnm7kdO_Com7kdOP02o`0=m7kdO_An
ogkdO_Ano`05C0;o1T`04ol3eP?FomKoeP?F0mH3o`j`3[000ol02[0>/0j`3_nPh:03o`07X>2Ph:3P
o`06D003oe1@00A@00?ogml00]l01?oOgol5g`0>oimOWenOoimOWenOGolC000<ogkdO_Anm?odO_An
0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04
omoOo`GO00?o00002@0000X000goOW5nLOmaO_mnLGia00;o00enLGkoOW7oLGiaOW7o00M<00?oC4`0
0d`0>?l?0`l3o`?o0`l33`<?o`ka3_7ol@ka3_4>l@koh:3Pon2Ph:3PX>2Poi1@T52@D93oT52@D93o
1=l01?oOgol5g`0>oimOWenOoimOWenOGolC000<og5nLOmaO_mnLGia0_l4g`04omoOo`GO00?ogml0
0]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03
omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04omoOo`GO00?o00002@0000X0
00Kom7kdO_@2o`05O_Anm7h00_l01?Anm7h2o`07m7kdO_Ano`04C0?o1T`01_l3eP?F0`;o00_F0mH3
eP?o3[0>/004o`0:3[0>/0koX>2Ph0?o00KPX>2Ph?l4D0Co1E000ooOg`03g`;o1]l01OnOGimO00;o
00NOGimOWeoo01<000GoO_Anm002o`05O_Anm7h00_l5g`;o1]l00ooOg`03g`;o1]l00ooOg`03g`;o
1Ml00ooOg`03g`;o1]l00ooOg`03g`;o1]l00ooOg`03g`;o1]l00ooOg`02g`;o1]l00ooOg`03g`;o
1]l00ol0000900002P003OmnLGiaOW5nLGiaOW400_l03GiaOW5nLGiaOW5nLOl03D`0>?l?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@koh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o3Ml03_nOGimOWenO
GimOWeoo4`003?maOW5nLGiaOW5nL@;o3Ml00ooOg`0;g`03omoO00[O00?ogml02ml00ooOg`0;g`03
omoO00_O00?ogml02]l00ooOg`0;g`03o`0000T0000:000=ooAnm7kdO_Anm7kdOP02o`0=m7kdO_An
m7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3_nPh:3PX>2Ph:3PX>3o3E000ooO
g`0;g`0>oimOWenOGimOWenOGolC000<ogkdO_Anm7kdO_An0_l=g`03omoO00_O00?ogml02]l00ooO
g`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000goOW5nLGiaOW5n
LGia00;o00enLGiaOW5nLGiaOW7o00e<03So3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>on2Ph:3P
X>2Ph:3PX?n@D91@T52@D91@T52@o`gO00koWenOGimOWenOGimOoa<000coLGiaOW5nLGiaOW42o`gO
00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0
000900002P1loa<0O?l;00002P003OnOGimOWenOGimOWel00_l06imOWenOGimOWenOGomaOW5nLGia
OW5nLGiao`0=C00ho`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3oT52@D91@
T52@D91@T?l<g`03o`00014000coGimOWenOGimOWel2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O
00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003OnOGimOWenOGimOWel0
0_l06imOWenOGimOWenOGomnm7kdO_Anm7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>
/0j`on2Ph:3PX>2Ph:3PX>3o3E000ooOg`0:g`03o`00014000coGimOWenOGimOWel2o`gO00?ogml0
2ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol000090000
2P003OnOGimOWenOGimOWel00_l06imOWenOGimOWenOGomaOW5nLGiaOW5nLGiao`0=C00ho`l33`<?
0`l33`<?0`oo3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l<g`03o`000140
00coGimOWenOGimOWel2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03
omoO00[O00?ogml02ml00ol0000900002P003OnOGimOWenOGimOWel00_l06imOWenOGimOWenOGomn
m7kdO_Anm7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o
3E000ooOg`0:g`03o`00014000coGimOWenOGimOWel2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O
00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P001OnOGimO00?o00EOWenO
G`02o`03WenO00?o00^OGimOWeooLGiaOP04o`06LGiaOW7o14`3o`I<00Ko3`<?0`l3o`093`<?0`oo
3_4>00?o00`>l@ka3_7oX>2Ph:02o`0Eh:3PX>2Poi1@T52@oi1@T52@D93o00GO0_l5g`03o`000140
00CoGimO0ol01EnOGimO00;o1Ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`GO00?ogml00ml2o`KO
00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00]l2o`KO00?ogml00ml2o`KO00?o00002@0000X0
00goWenOGiooWenOGimO00;o01^OGimOoenOGimOWeooO_Anm7koO_Anm7kdO_l01d`00om<C003C00Z
o`?F0mH3e_oF0mH3eP?o3[0>/0j`ok0>/0j`on2Ph:3oX>3oh:3PX>3o1E000om@D005D003omoO00;O
00Cogmoo1=l00ol0000A000<oenOGiooWenOGimO0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03
omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo
1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04omoOo`GO00?o00002@0000X000goWenOGiooWenO
GimO00;o01^OGimOoenOGimOWeooLGiaOW5nogiaOW5nLOl01d`00om<C003C005o`l33`<01?l0;`l3
3`<?o`ka3_4>lOoa3_4>lOnPh:3Pon2Poj3PX>2Poi1@T52@D?m@T52@D93o00CO00Cogmoo1=l00ol0
000A000<oenOGiooWenOGimO0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo
1=l00ooOg`02g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O
00?ogml00ml00ooOg`02g`04omoOo`GO00?o00002@0000X000goWenOGiooWenOGimO00;o01^OGimO
oenOGimOWeooO_Anm7kdO_mnm7kdO_l01D`2o`I<01;o0mH3e_oFomH3eP?F0ol>/0h3o`0;3[0>/0j`
on2Ph:000ol01j3PX>2Ph?l01U000om@D004D003omoO00;O00Cogmoo1=l00ol0000A000<oenOGioo
WenOGimO0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04
omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooO
g`02g`04omoOo`GO00?o00002@0000X000goWenOGiooWenOGimO00;o01^OGimOoenOGimOWeooLGia
O_mnLOmaOW5nLOl01d`00om<C003C00ho`l33`?o0ol33`<?0`oo3_4>o`ka3_4>l@kaoj3PX>3oh:3P
X>2Ph:3oT52@D91@T?n@D91@T?l4g`04omoOo`CO00?o00004@003?mOWenOoimOWenOG`;o1=l01?oO
gol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO00?ogml00]l01?oOgol5g`03omoO00;O
00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03omoO00?O00?ogml00]l01?oOgol5g`03
o`0000T0000:0005oimOWel00_l01YmOWenOG`;o00>OGil00_l03EnOGimOWeooO_Anm7h00_l01oAn
m7kdO_l014`3o`I<00Ko0mH3eP<2o`0:eP?F0mH3o`j`3PCo00^`3[0>/?oPX>2Ph003o`06h:3PX>3o
1504o`E@00?ogml00ml2o`GO00?o00004@001?mOWel2o`06WenOGimO0_l5g`;o1]l00ooOg`03g`;o
1]l00ooOg`03g`;o1Ml00ooOg`03g`;o1]l00ooOg`03g`;o1]l00ooOg`03g`;o1]l00ooOg`02g`;o
1]l00ooOg`03g`;o1]l00ol0000900002P003OnOGimOWenOGimOWel00_l06imOWenOGimOWenOGoma
OW5nLGiaOW5nLGiao`0=C00ho`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3o
T52@D91@T52@D91@T?l<g`03o`00014000coGimOWenOGimOWel2o`gO00?ogml02ml00ooOg`0:g`03
omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P003OnOGimOWenO
GimOWel00_l06imOWenOGimOWenOGomnm7kdO_Anm7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3eP?o3[0>
/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o3E000ooOg`0:g`03o`00014000coGimOWenOGimOWel2o`gO
00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0
000900002P003OnOGimOWenOGimOWel00_l06imOWenOGimOWenOGomaOW5nLGiaOW5nLGiao`0=C00h
o`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@T?l<g`03
o`00014000coGimOWenOGimOWel2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O00?ogml02ml00ooO
g`0;g`03omoO00[O00?ogml02ml00ol0000900002P1loa<0O?l;00002P000ooOg`0:g`;o3=l07OmO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW7o00e<03Oo3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_7o
X>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53o01<000?ogml02Ml2o`gO00?ogml02ml00ooOg`0:g`03
omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P000ooOg`0:g`;o
3=l07OmOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7ko00e<02[o0mH3eP?F0mH3eP?Fok0>/0j`3[0>
/0j`3[3oh:3PX>2Ph:3PX>2Ph?l<D003o`00014000?ogml02Ml2o`gO00?ogml02ml00ooOg`0:g`03
omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P000ooOg`0:g`;o
3=l07OmOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW7o00e<03Oo3`<?0`l33`<?0`l3oo4>l@ka3_4>
l@ka3_7oX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53o01<000?ogml02Ml2o`gO00?ogml02ml00ooO
g`0:g`03omoO00_O00?ogml02ml00ooOg`0;g`03omoO00[O00?ogml02ml00ol0000900002P000ooO
g`03g`;o1Ml2o`CO0_l6g`05oenOGil00ol02imOWenOGomnm7kd00Co00Inm7kdO_l4C0?o1T`01Ol3
eP?F00?o00[F0mH3e_n`3[0>0ol030j`3[0>/?oPX>2Ph0;o00NPh:3PX>3o00E@00?oD50015000ol0
000A0003omoO00;O0_l5g`;o1Ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`GO00?ogml00ml2o`KO
00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00]l2o`KO00?ogml00ml2o`KO00?o00002@0000X0
00?ogml00]l01?oOgol4g`;o0ml01?oOgol5g`0MoenOGimOoenOGimOWeooLGiaOW7oLGiaOW5nLOl0
1d`00om<C003C00go`l33`<?o`l33`<?0ooa3_4>l@kaoo4>l@kaoj3PX>3oh:3oX>2Ph:3oT52@D93o
T52@D91@o`0C0005omoOgol00]l00ooOg`02g`;o1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooO
g`02g`04omoOo`CO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO
00GogmoOo`02g`03omoO00?O00?ogml00]l01?oOgol5g`03o`0000T0000:0003omoO00;O00Cogmoo
1=l2o`?O00Cogmoo1Ml07OmOWenOGomOWenOGimOogkdO_Anm?odO_Anm7ko00M<00?oC4`00d`01?l3
eP<4o`0ReP?F0mKo/0j`3[0>/?n`3[0>/?oPX>2Poj3Pon2Ph:3Po`I@00?oD5000e000ol0000A0005
omoOgol00]l00ooOg`02g`;o1=l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`CO
00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml00ooOg`02g`04omoOo`GO00GogmoOo`02g`03
omoO00?O00?ogml00]l01?oOgol5g`03o`0000T0000:0003omoO00;O00Cogmoo1=l2o`?O00Cogmoo
1Ml07OmOWenOGomOWenOGimOog5nLGiaOW7oLGiaOW7o00E<0_l6C00Bo`l33ol?o`l33`<?0ooa3_4>
0ol02`ka3_4>lOnPh:3P00?o01CPX>2Ph:3oT52@D91@oe2@D91@oa<000GogmoOo`02g`03omoO00;O
0_l4g`04omoOo`GO00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO
00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04
omoOo`GO00?o00002@0000X000?ogml00]l01?oOgol4g`;o0ml01?oOgol5g`0MoenOGimOoenOGimO
WeooO_Anm?odO_mnm7kdO_l01d`00om<C003C00Zo`?F0ol3o`?F0mH3e_n`3[0>o`j`3[0>/0j`on2P
h:3oX>2Ph:3PX>3o1e000om@D002D003o`00014000GogmoOo`02g`03omoO00;O0_l4g`04omoOo`GO
00?ogml00]l01?oOgol5g`03omoO00;O00Cogmoo1=l00ooOg`02g`04omoOo`GO00?ogml00]l01?oO
gol5g`03omoO00;O00Cogmoo1Ml01OoOgmoo00;O00?ogml00ml00ooOg`02g`04omoOo`GO00?o0000
2@0000X000?ogml00ml2o`GO0_l4g`;o1]l01OmOWenO00;o00eOWenOGimOog5nLGia00;o00MnLGia
OW7o00A<0ol6C005o`l33`<00_l02`l33`<?0ooa3_4>00Co00_a3_4>lOnPh:3PX003o`0:X>2Ph:3o
T52@D0Co00F@D91@o`0C0003omoO00;O0_l5g`;o1Ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`GO
00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00ml2o`KO00?ogml00]l2o`KO00?ogml00ml2o`KO
00?o00002@0000X000?ogml02]l2o`cO01goGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Ano`0=C00Z
o`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o35000ol0000A0003omoO00WO
0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O
00?o00002@0000X000?ogml02]l2o`cO01goGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiao`0=C00g
o`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@o`0C0003
omoO00WO0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03
omoO00_O00?o00002@0000X000?ogml02]l2o`cO01goGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
o`0=C00Zo`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o35000ol0000A0003
omoO00WO0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooOg`0:g`03
omoO00_O00?o00002@0000T0OOlB07go2`0000T0OOlB07go2`0000X000?o00002@03o`cO01goGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiao`0=C00go`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kaoj3P
X>2Ph:3PX>2Ph:3oT52@D91@T52@D91@o`0C0003o`0000T00_l=g`0LoimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiao`e<03So3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX?n@D91@
T52@D91@T52@o`/0000:0005o`3oo`000_l40004o`3oo`cO01goGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o35000ol0
000A00?o00<0ool01@03o`gO01coWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`0:_l3eP?F0mH3
eP?F0mH3o`j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000Ko003o0?l40003
o`0000;o3=l07OmOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW7o00e<03Oo3`<?0`l33`<?0`l3oo4>
l@ka3_4>l@ka3_7oX>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53o01<000Go0?l0o`050004o`3oo`gO
01coWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7o3D`0>?l?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>
l@koh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o2`0000X000Go0000o`040004o`0000;o1=l2o`KO
00GoGimOW`03o`0;WenOGimOogkdO_@01?l01WkdO_Ano`A<0ol6C005o`?F0mH00ol02]H3eP?Fok0>
/0h3o`0<3[0>/0j`on2Ph:3P0_l01j3PX>2Ph?l01E000om@D004D003o`00014000Co003o1@000ol0
0002o`GO0_l6g`05oimOWel00ol02enOGimOWoodO_An00Co00GdO_Ano`04C0?o1T`01_l3eP?F0`?o
00X3eP?F0ol>/0j`0ol02k0>/0j`3_nPh:3P00;o00NPh:3PX>3o00E@00?oD5001E000ol000090000
2P001ol00?l0o`000ol300;o0ml01?oOgol5g`0MoenOGimOoenOGimOWeooLGiaOW7oLGiaOW5nLOl0
1d`00om<C003C00go`l33`<?o`l33`<?0ooa3_4>l@kaoo4>l@kaoj3PX>3oh:3oX>2Ph:3oT52@D93o
T52@D91@o`0C0005o`3o0?l00P03o`800_l4g`04omoOo`GO01coWenOGiooWenOGimOWomnLGiaO_mn
LGiaOW7o1d`00om<C003C00ho`l33`<?0ol33`<?0`oo3_4>l@ka3_l>l@ka3_oPX>3oh:3oX>2Ph:3o
T52@D93oT52@D91@T?l;00002P001Ol0ool000Co1002o`?O00Cogmoo1Ml07OmOWenOGomOWenOGimO
ogkdO_Anm?odO_Anm7ko00M<00?oC4`00d`01?l3eP<4o`0ReP?F0mKo/0j`3[0>/?n`3[0>/?oPX>2P
oj3Pon2Ph:3Po`I@00?oD5000e000ol0000A00?o00@0ool00_l300;o1=l01?oOgol5g`0LoimOWenO
oimOWenOGioom7kdO_AnogkdO_Ano`M<00?oC4`00d`01Ol3eP?F00Co0243eP?F0ol>/0j`3[0>o`j`
3[0>oj3PX?nPh?oPX>2Ph?l01U000om@D004D003o`0000T0000:0003o`0000<000Co003o0`02o`?O
00Cogmoo1Ml07OmOWenOGomOWenOGimOog5nLGiaOW7oLGiaOW7o00E<0_l6C00Bo`l33ol?o`l33`<?
0ooa3_4>0ol02`ka3_4>lOnPh:3P00?o01CPX>2Ph:3oT52@D91@oe2@D91@oa<000?o00000`001?l0
0?l200;o1=l01?oOgol5g`0LoimOWenOoimOWenOGiooOW5nLGiaO_mnLGiao`E<0_l6C00Co`l33`?o
0ol33`<?0`oo3_4>l@03o`0:l@ka3_4>on2Ph0?o01GPX>2Ph:3oT52@D91@oe2@D91@T?l02`0000X0
00?o00000P001Ol0003o00<00_l3g`04omoOo`GO01goGimOWeooGimOWenOGomnm7kdooAnogkdO_An
o`07C003oda<00=<02[o0mH3o`?o0mH3eP?Fok0>/0ko3[0>/0j`3[3oh:3PX?nPh:3PX>2Ph?l7D003
oe1@009@00?o00004@000ol000020005o`000?l00P02o`CO00Cogmoo1Ml07?nOGimOWonOGimOWenO
ooAnm7koO_Com7kdO_l7C003oda<00=<02[o0mH3e_oFomH3eP?F0ol>/0j`ok0>/0j`3[0>oj3PX?nP
h:3PX>2Ph?l7D003oe1@00=@00?o00002@0000X000Go0000o`030003o`3o00800_l4g`;o1]l01OmO
WenO00;o00eOWenOGimOog5nLGia00;o00MnLGiaOW7o00A<0ol6C005o`l33`<00_l02`l33`<?0ooa
3_4>00Co00_a3_4>lOnPh:3PX003o`0:X>2Ph:3oT52@D0Co00F@D91@o`0C0005o`000?l00`001?l0
o`02o`GO0_l6g`05oimOWel00_l03ImOWenOGiooOW5nLGh00_l01W5nLGiao`A<0ol6C006o`l33`<?
0_l02`<?0`l33ol>l@ka00Co00X>l@ka3_oPX>2P0ol02Z3PX>2Poi1@T504o`06T52@D93o2`0000X0
00Co003o10000ol0o`0200;o3=l07OmOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7ko00e<02[o0mH3
eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[3oh:3PX>2Ph:3PX>2Ph?l<D003o`00014000Co003o10001?l0
o`02o`gO01coWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`0:_l3eP?F0mH3eP?F0mH3o`j`3[0>
/0j`3[0>/0koX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000?o0?l01002o`040?oo00;o3=l07OmO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW7o00e<03Oo3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_7o
X>2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T53o01<000?o0?l01002o`030?oo00;o3Ml07?nOGimOWenO
GimOWenOogiaOW5nLGiaOW5nLOl=C00ho`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_oPX>2Ph:3P
X>2Ph:3oT52@D91@T52@D91@T?l;00002P02o`/00_l<g`0MoenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_l03D`0:_l3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/?oPX>2Ph:3PX>2Ph:3Po`a@00?o0000
4@02o`X00_l=g`0LoimOWenOGimOWenOGioom7kdO_Anm7kdO_Ano`e<02[o0mH3eP?F0mH3eP?F0ol>
/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph?l=D003o`0000T0000:07co4`1lo`/0000G00;oS002ogT0
003o0240001m00?o=`04oe400olA0000OP000ol0000g0003o`00058000?o0000400000X00_l00`3o
o`0300Go00<0ool02?l200?o0P05o`800ol200;o00<0ool0:`02o`030?oo00X000?o000020000ol0
000H0006o`000?l01Ol00`3oo`03o`800ol200Go00<0ool00_l200Go00<0ool00ol200?o0P05o`80
0ol200Go0P03o`800_l00`3oo`0700;o00<0ool02@02o`X000?o00003`0000/000?o0?l00`001ol0
003o0?l00`001Ol0003o00@000Co003o0`001Ol0003o00<000?o0?l00P000ol0000[0003o`3o00/0
00?o000020000ol0000H0007o`000?l0o`020003o`00008000?o00000P001?l00?l30005o`000?l0
0`001Ol0003o00D000Go0000o`030003o`3o008000Go0000o`020005o`000?l00`001ol0003o0?l0
0P000ol000070003o`3o00T000Co003o2@000ol0000?00002`03o`<000Oo0000o`3o00<000Go0000
o`040003o`0000@000Go0000o`030003o`3o008000?o0000;0000ol0000800Go1`000ol0o`0I0007
o`3o0?l0o`020003o`00008000?o00000P000ol000040005o`000?l00`001Ol0003o00D000Go0000
o`0500Co0`000ol000040005o`000?l00`000ol0o`020003o`0000P000?o000020001?l00?l80003
o`3o0100000;0003o`3o00<000Oo0000o`3o00<000Go0000o`040003o`0000@000Go0000o`030003
o`3o008000?o0000:`000ol0o`0;0003o`0000L000?o0?l06@001ol0o`3o0?l00P000ol000020003
o`00008000?o000010001Ol0003o00<000Go0000o`050005o`000?l00`000ol000020005o`000?l0
1P001Ol0003o00<000?o0?l00P000ol000070003o`3o00T000Co003o20000ol0o`0@000030000ol0
000300Co0P04o`800_l300Co0`02o`@00ol00`3oo`03ob`00_l00`3oo`0:0003o`0000H00_l00`3o
o`0H00;o00<0ool00_l00`3oo`040004o`0000Co0`02o`801Ol40003o`0000800_l400Co0P03o`80
1?l300;o1003o`030?oo00?o2002o`030?oo00P000Co003o1`02o`030?oo00l0000;00;o20000ol0
00030003o`0000H000?o0000LP02o`<00_l80003o`00008000?o000040000ol0000D0003o`0002P0
0_lL00005002o`@00_l30003o`00008000?o000010000ol0001h00?o10000ol000040003o`0000L0
0ol50003o`0000h000?o000010000ol0000o0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143.75, 0}} -> {-0.0537398, -0.0251377, 
  0.00734314, 0.00734314}, {{7.3125, 137}, {140.312, 
  3.375}} -> {-1.7579, -0.489659, 0.0728683, 0.0728683}, {{149.938, 
  279.625}, {140.312, 3.375}} -> {-12.1507, -0.489659, 0.0728683, 
  0.0728683}},
  CellTags->"NumericRings"]
}, Open  ]],

Cell["\<\
There is no need for a calculator to do multiplication in this ring\
\
\>", "MathCaption",
  CellTags->"NumericRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Multiplication[TrivialZR[8]]\)], "Input",
  CellLabel->"In[74]:=",
  CellTags->"NumericRings"],

Cell[BoxData[
    \(0&\)], "Output",
  CellLabel->"Out[74]=",
  CellTags->"NumericRings"]
}, Open  ]],

Cell["Here is another interesting ring with eight elements.", "MathCaption",
  CellTags->"NumericRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(L = LatticeRing[30]\)], "Input",
  CellLabel->"In[75]:=",
  CellTags->"NumericRings"],

Cell[BoxData[
    \(Ringoid[{1, 2, 3, 5, 6, 10, 15, 30}, "-Addition-", "-Multiplication-"]
      \)], "Output",
  CellLabel->"Out[75]=",
  CellTags->"NumericRings"]
}, Open  ]],

Cell[TextData[{
  "The operations in ",
  Cell[BoxData[
      \(TraditionalForm\`L\)]],
  " are not displayed, so here they are."
}], "MathCaption",
  CellTags->"NumericRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Addition[L], Multiplication[L]}\)], "Input",
  CellLabel->"In[76]:=",
  CellTags->"NumericRings"],

Cell[BoxData[
    \({LCM[#1, #2]\/GCD[#1, #2]&, GCD[#1, #2]&}\)], "Output",
  CellLabel->"Out[76]=",
  CellTags->"NumericRings"]
}, Open  ]],

Cell["3.4.2 Other rings", "Subsubsection",
  CellTags->"OtherRings"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["BooleanRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["Boolean",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["consisting",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["set",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subsets",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\({1, \ 2, \ \[Ellipsis], \ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"], 
              
              StyleBox[
                \(\(}\ with\ symmetric\ difference\ for\ addition\ and\ 
                  intersection\ for\ multiplication\)\ \),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["BooleanRing",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["Boolean",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["ring",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["with",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subsets",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                FontSlant->"Italic"]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherRings", "i:33"}],

Cell["Nonnumeric ringoids.", "Caption",
  CellTags->"OtherRings"],

Cell["Here is another ring with eight elements.", "MathCaption",
  CellTags->"OtherRings"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTables[BooleanRing[{\[Alpha], \[Beta], \[Gamma]}], \ 
      Mode\  \[Rule] \ Visual, \ KeyForm\  \[Rule] \ StandardForm]; \)\)], 
  "Input",
  CellLabel->"In[77]:=",
  CellTags->"OtherRings"],

Cell[BoxData[
    \("KEY for Add(Bool[{\[Alpha], \[Beta], \[Gamma]}]): label used \[Rule] \
element: {g1 \[Rule] \!\({}\), g2 \[Rule] \!\({\\[Gamma]}\), g3 \[Rule] \!\({\
\\[Beta]}\), g4 \[Rule] \!\({\\[Beta], \\[Gamma]}\), g5 \[Rule] \
\!\({\\[Alpha]}\), g6 \[Rule] \!\({\\[Alpha], \\[Gamma]}\), g7 \[Rule] \
\!\({\\[Alpha], \\[Beta]}\), g8 \[Rule] \!\({\\[Alpha], \\[Beta], \
\\[Gamma]}\)}"\)], "Print",
  CellTags->"OtherRings"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .50265 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0119678 0.47619 [
[ 0 0 0 0 ]
[ 1 .50265 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .50265 L
0 .50265 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0119678 0.477324 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 .5 0 r
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.56 .37 .6 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
0 0 1 r
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.74 .99 .79 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.251 .878 .816 r
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 .79 .34 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
0 .392 0 r
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g2)] .28836 .81878 0 0 Mshowa
[(g3)] .39418 .81878 0 0 Mshowa
[(g4)] .5 .81878 0 0 Mshowa
[(g5)] .60582 .81878 0 0 Mshowa
[(g6)] .71164 .81878 0 0 Mshowa
[(g7)] .81746 .81878 0 0 Mshowa
[(g8)] .92328 .81878 0 0 Mshowa
[(g2)] .18254 .71296 0 0 Mshowa
[(g1)] .28836 .71296 0 0 Mshowa
[(g4)] .39418 .71296 0 0 Mshowa
[(g3)] .5 .71296 0 0 Mshowa
[(g6)] .60582 .71296 0 0 Mshowa
[(g5)] .71164 .71296 0 0 Mshowa
[(g8)] .81746 .71296 0 0 Mshowa
[(g7)] .92328 .71296 0 0 Mshowa
[(g3)] .18254 .60714 0 0 Mshowa
[(g4)] .28836 .60714 0 0 Mshowa
[(g1)] .39418 .60714 0 0 Mshowa
[(g2)] .5 .60714 0 0 Mshowa
[(g7)] .60582 .60714 0 0 Mshowa
[(g8)] .71164 .60714 0 0 Mshowa
[(g5)] .81746 .60714 0 0 Mshowa
[(g6)] .92328 .60714 0 0 Mshowa
[(g4)] .18254 .50132 0 0 Mshowa
[(g3)] .28836 .50132 0 0 Mshowa
[(g2)] .39418 .50132 0 0 Mshowa
[(g1)] .5 .50132 0 0 Mshowa
[(g8)] .60582 .50132 0 0 Mshowa
[(g7)] .71164 .50132 0 0 Mshowa
[(g6)] .81746 .50132 0 0 Mshowa
[(g5)] .92328 .50132 0 0 Mshowa
[(g5)] .18254 .3955 0 0 Mshowa
[(g6)] .28836 .3955 0 0 Mshowa
[(g7)] .39418 .3955 0 0 Mshowa
[(g8)] .5 .3955 0 0 Mshowa
[(g1)] .60582 .3955 0 0 Mshowa
[(g2)] .71164 .3955 0 0 Mshowa
[(g3)] .81746 .3955 0 0 Mshowa
[(g4)] .92328 .3955 0 0 Mshowa
[(g6)] .18254 .28968 0 0 Mshowa
[(g5)] .28836 .28968 0 0 Mshowa
[(g8)] .39418 .28968 0 0 Mshowa
[(g7)] .5 .28968 0 0 Mshowa
[(g2)] .60582 .28968 0 0 Mshowa
[(g1)] .71164 .28968 0 0 Mshowa
[(g4)] .81746 .28968 0 0 Mshowa
[(g3)] .92328 .28968 0 0 Mshowa
[(g7)] .18254 .18386 0 0 Mshowa
[(g8)] .28836 .18386 0 0 Mshowa
[(g5)] .39418 .18386 0 0 Mshowa
[(g6)] .5 .18386 0 0 Mshowa
[(g3)] .60582 .18386 0 0 Mshowa
[(g4)] .71164 .18386 0 0 Mshowa
[(g1)] .81746 .18386 0 0 Mshowa
[(g2)] .92328 .18386 0 0 Mshowa
[(g8)] .18254 .07804 0 0 Mshowa
[(g7)] .28836 .07804 0 0 Mshowa
[(g6)] .39418 .07804 0 0 Mshowa
[(g5)] .5 .07804 0 0 Mshowa
[(g4)] .60582 .07804 0 0 Mshowa
[(g3)] .71164 .07804 0 0 Mshowa
[(g2)] .81746 .07804 0 0 Mshowa
[(g1)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Addition)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0119678 0.97619 0.490678 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 .5 0 r
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.56 .37 .6 r
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
0 0 1 r
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
.74 .99 .79 r
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.251 .878 .816 r
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
0 .79 .34 r
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
0 .392 0 r
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
1 .5 0 r
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
.56 .37 .6 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
0 0 1 r
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.74 .99 .79 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.251 .878 .816 r
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 .79 .34 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
0 .392 0 r
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
1 .5 0 r
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
.56 .37 .6 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
0 0 1 r
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.74 .99 .79 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.251 .878 .816 r
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 .79 .34 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
0 .392 0 r
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(g1)] .18254 .81878 0 0 Mshowa
[(g1)] .28836 .81878 0 0 Mshowa
[(g1)] .39418 .81878 0 0 Mshowa
[(g1)] .5 .81878 0 0 Mshowa
[(g1)] .60582 .81878 0 0 Mshowa
[(g1)] .71164 .81878 0 0 Mshowa
[(g1)] .81746 .81878 0 0 Mshowa
[(g1)] .92328 .81878 0 0 Mshowa
[(g1)] .18254 .71296 0 0 Mshowa
[(g2)] .28836 .71296 0 0 Mshowa
[(g1)] .39418 .71296 0 0 Mshowa
[(g2)] .5 .71296 0 0 Mshowa
[(g1)] .60582 .71296 0 0 Mshowa
[(g2)] .71164 .71296 0 0 Mshowa
[(g1)] .81746 .71296 0 0 Mshowa
[(g2)] .92328 .71296 0 0 Mshowa
[(g1)] .18254 .60714 0 0 Mshowa
[(g1)] .28836 .60714 0 0 Mshowa
[(g3)] .39418 .60714 0 0 Mshowa
[(g3)] .5 .60714 0 0 Mshowa
[(g1)] .60582 .60714 0 0 Mshowa
[(g1)] .71164 .60714 0 0 Mshowa
[(g3)] .81746 .60714 0 0 Mshowa
[(g3)] .92328 .60714 0 0 Mshowa
[(g1)] .18254 .50132 0 0 Mshowa
[(g2)] .28836 .50132 0 0 Mshowa
[(g3)] .39418 .50132 0 0 Mshowa
[(g4)] .5 .50132 0 0 Mshowa
[(g1)] .60582 .50132 0 0 Mshowa
[(g2)] .71164 .50132 0 0 Mshowa
[(g3)] .81746 .50132 0 0 Mshowa
[(g4)] .92328 .50132 0 0 Mshowa
[(g1)] .18254 .3955 0 0 Mshowa
[(g1)] .28836 .3955 0 0 Mshowa
[(g1)] .39418 .3955 0 0 Mshowa
[(g1)] .5 .3955 0 0 Mshowa
[(g5)] .60582 .3955 0 0 Mshowa
[(g5)] .71164 .3955 0 0 Mshowa
[(g5)] .81746 .3955 0 0 Mshowa
[(g5)] .92328 .3955 0 0 Mshowa
[(g1)] .18254 .28968 0 0 Mshowa
[(g2)] .28836 .28968 0 0 Mshowa
[(g1)] .39418 .28968 0 0 Mshowa
[(g2)] .5 .28968 0 0 Mshowa
[(g5)] .60582 .28968 0 0 Mshowa
[(g6)] .71164 .28968 0 0 Mshowa
[(g5)] .81746 .28968 0 0 Mshowa
[(g6)] .92328 .28968 0 0 Mshowa
[(g1)] .18254 .18386 0 0 Mshowa
[(g1)] .28836 .18386 0 0 Mshowa
[(g3)] .39418 .18386 0 0 Mshowa
[(g3)] .5 .18386 0 0 Mshowa
[(g5)] .60582 .18386 0 0 Mshowa
[(g5)] .71164 .18386 0 0 Mshowa
[(g7)] .81746 .18386 0 0 Mshowa
[(g7)] .92328 .18386 0 0 Mshowa
[(g1)] .18254 .07804 0 0 Mshowa
[(g2)] .28836 .07804 0 0 Mshowa
[(g3)] .39418 .07804 0 0 Mshowa
[(g4)] .5 .07804 0 0 Mshowa
[(g5)] .60582 .07804 0 0 Mshowa
[(g6)] .71164 .07804 0 0 Mshowa
[(g7)] .81746 .07804 0 0 Mshowa
[(g8)] .92328 .07804 0 0 Mshowa
[(g1)] .07672 .81878 0 0 Mshowa
[(g2)] .07672 .71296 0 0 Mshowa
[(g3)] .07672 .60714 0 0 Mshowa
[(g4)] .07672 .50132 0 0 Mshowa
[(g5)] .07672 .3955 0 0 Mshowa
[(g6)] .07672 .28968 0 0 Mshowa
[(g7)] .07672 .18386 0 0 Mshowa
[(g8)] .07672 .07804 0 0 Mshowa
[(g1)] .18254 .9246 0 0 Mshowa
[(g2)] .28836 .9246 0 0 Mshowa
[(g3)] .39418 .9246 0 0 Mshowa
[(g4)] .5 .9246 0 0 Mshowa
[(g5)] .60582 .9246 0 0 Mshowa
[(g6)] .71164 .9246 0 0 Mshowa
[(g7)] .81746 .9246 0 0 Mshowa
[(g8)] .92328 .9246 0 0 Mshowa
[(Multiplication)] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[77]:=",
  ImageSize->{288, 144.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0000X0O?lC07co2`0000X000?oD5002U02o`a@02_oX>2Ph:3PX>2Ph:3PX?l>/0j`3[0>
/0j`3[0>o`?F0mH3eP?F0mH3eP?o00a<01gom7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOo`0<g`03
o`00014000?oD5002E02o`gO01coWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`0:_l3eP?F0mH3
eP?F0mH3o`j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X000goT52@D91@T52@
D91@00;o03N@D91@T52@D91@T53oh:3PX>2Ph:3PX>2Ph?l>l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?
0`oo00a<01goOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOo`0<g`03o`00014000coD91@T52@D91@
T502o`gO01coWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7o3D`0>?l?0`l33`<?0`l33`<?o`ka3_4>
l@ka3_4>l@koh:3PX>2Ph:3PX>2Poi1@T52@D91@T52@D93o2`0000X000?oD5000ol7D0;o00A@oooo
25000onPh003o`0;h:3PX>2Ph:3o3[000ol02k0>/0j`3[0>o`?F00?o00[F0mH3eP?F0om<0ol8C003
ooAn00?o00]nm7kdO_Anm?nOG`03o`09GimOWenOGioo00;O0ol7g`03o`00014000?oD?l00_l7D0;o
0]l3o`SO00?oWel00ol02enOGimOWenOooAn00?o00Qnm7kdO_Ano`9<0ol8C003o`?F00?o00_F0mH3
eP?F0ol>/003o`0:/0j`3[0>/0koX0?o00VPh:3PX>2Ph?l00U03o`Q@00?o00002@0000X000goT52@
D93oT52@D91@00;o03N@D91@oe2@D91@T53oh:3PX>3oh:3PX>2Ph?l>l@ka3_l>l@ka3_4>o`l33`<?
o`l33`<?0`oo00A<00?oC4`01D`07OmnLGiaO_mnLGiaOW5noimOWenOoimOWenOGioo00GO00?ogml0
1=l00ol0000A000<oe2@D93oT52@D91@0_l5g`03omoO00GO01coWenOGiooWenOGimOWomnLGiaO_mn
LGiaOW7o1D`00om<C005C00ho`l33`<?o`l33`<?0`oo3_4>l@ko3_4>l@ka3_oPX>2Poj3PX>2Ph:3o
T52@D93oT52@D91@T?l;00002P000om@D004o`9@0_l2D0;o00=@ool00_l2D0;o0e000onPh004o`0:
X>3oh:3PX?l>/0Co00X>/?oo3[0>o`?F1?l02@?oool3eP?oC004o`9<0ol2C003ooAn00Co00[doooo
m7kdoimO1?l00iooo`02o`03Gioo00;O1?l01=ooool2g`03o`00014000?oD?l00ol2D0;o0U02o`;O
1?l01=ooool3g`03oimO00Co00>Oool00_l01EnOooAn00Co00Odoooom7ko009<1?l2C0?o0T`00ol3
eP04o`0:0oooo`?F0ol>/0Co00T>/?oo3[0>oj001?l02>2Poj3PX>3o0U04o`9@0_l3D003o`0000T0
000:000=oi3oT52@oi3oT53oD003o`0eD91@oe3oD93oT53oh?oPX>3oh:3oX>2Ph?l>o`ka3_l>o`ka
oo4>o`oo3`<?o`l33`?o0`l00_l3C005oda<C?l00d`07omnogiaO_mnLGiaog5noiooWenOoimOoenO
Gioogol00ml01?oOgol3g`03o`0001400_l02Y1@T?n@oi1@oe02o`03gooO00;O00Cogmoo1=l07_nO
oimOWonOGomOWenOogkoOW5nogiaOW7oLOm<o`=<00GoC4a<o`03C00Lo`oo3`<?o`l33`?o0`oo3_l>
l@ko3_l>lOoa3P;o01ZPh:3oX>3oh:3PX?n@oi1@T?n@oi1@oe2@o`/0000:0003oe3o00=@00?oD?l0
0U000om@o`02o`=@00?oD?l00U00;Om@D?nPoj3PX?nPh:3oX>2Po`ko3[0>o`ko3[3o/0ko0ol3eP?o
0mH3e_oF0`02o`=<00?oC?l00ol2C00OooCom7kdooAnm7koO_CoWonOGiooWenOoimOWooOo`03g`04
omoOo`?O00?o00004@02o`=@00?oD?l00U001_m@oooOo`?O00Cogmoo1=l07_nOoimOWonOGiooWenO
ooCom7kdooAnm7koO_m<o`=<00?oC?l00ol2C00Lo`?o0mH3o`?F0mKoeP?o3_l>/0ko3_l>/?n`3P;o
00kPX>3oh:3Pon2Ph?m@o`=@00?oD?l00U001?m@D?l;00002P002On@oi1@T?n@D002o`03T53o00;o
00I@T53oD902o`0ID91@on3oh:3Pon2Ph?oPX>3o3_l>l@ko3P03o`0;3_4>o`oo3`<?o`l00ol00`l3
3`02o`=<00GoC?m<o`03C009ogkoOW5nogia00;o01AnLGkoWonOGiooWenOGomOWooOo`?O00Cogmoo
0ml00ol0000A00;o00J@D93oT502o`06T53oomoo0ml01?oOgol4g`0GoiooWenOoimOWeooGiooO_mn
LGkoOW400_l01Giaodco00=<00GoC?m<o`03C008o`oo3`<?o`l3o`0;3`<?o`ko3_4>o`h00ol00`ka
3P02o`0DX>2Poj3PX?nPh:3oT?n@D93oT502o`04T52@o`/0000:0003oe1@00Ko0U001Om@oom@00Ko
0U001_m@D?nPh0Go00WPX>3oh:3o3[001_l020j`3[0>o`?F1_l01`?F0mH3od`01_l00dcoC002C003
ooAn00Go00Unm7koO_CoWel01_l01YmOoenOo`;O1Ol00moog`02g`03o`00014000?oD?l01Ol2D004
oe3oo`;O1Ol00moog`03g`03oimO00Ko00ROGomOWoodOPGo00Inm7koO_l2C0Ko00=<od`00T`00ol3
eP06o`080mH3eP?o3[06o`073[0>/0koX005o`07X>2Poj3Po`02D0Ko0U001?m@D?l;00002P002On@
D91@T52@D002o`0;T53ooi1@T52@D9000_l02e2@D?oPX>2Ph:3P00Co00^Ph?l>l@ka3_4>l@03o`0:
l@ko3`<?0`l33`Co00<33ol01d`2o`=<00SoOW5nLGiaOP?o00anLGkoWenOGimOWel2o`04WenOo`OO
0_l3g`03o`00014000SoD91@T52@D0;o00B@D?oo1ml2o`CO00WoWenOGimOWel00_l02imOWomnLGia
OW5n00?o00=nLOl024`2o`=<00So3`<?0`l33`Co00/33ol>l@ka3_4>l@03o`09l@koh:3PX>2P00Co
00_PX?n@D91@T52@D002o`04T52@o`/0000:0003oe1@00Y@0_l<D00[oj3PX>2Ph:3PX>2Ph:3o3[0>
/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3o`0<C00MooAnm7kdO_Anm7kdO_CoWenOGimOWenOGimOWol0
3=l00ol0000A0003oe1@00U@0_l=g`0LoimOWenOGimOWenOGioom7kdO_Anm7kdO_Ano`e<02[o0mH3
eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph?l=D003o`0000T0000:000=oi1@T52@
D91@T52@D002o`0gT52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>3o3_4>l@ka3_4>l@ka3_l?0`l33`<?
0`l33`<?o`0<C00MogiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWol03=l00ol0000A000<oe2@D91@
T52@D91@0_l=g`0LoimOWenOGimOWenOGiooOW5nLGiaOW5nLGiao`e<03So3`<?0`l33`<?0`l33ol>
l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX?n@D91@T52@D91@T52@o`/0000:0003oe1@00Y@0_l<D00[
oj3PX>2Ph:3PX>2Ph:3o3[0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3o`0<C00MooAnm7kdO_Anm7kd
O_CoWenOGimOWenOGimOWol03=l00ol0000A0003oe1@00U@0_l=g`0LoimOWenOGimOWenOGioom7kd
O_Anm7kdO_Ano`e<02[o0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>oj3PX>2Ph:3PX>2Ph?l=D003
o`0000T0000:07co4`1lo`/0000:000=on2Ph:3PX>2Ph:3PX002o`0=h:3PX>2Ph:3PX>2Po`0=D00Z
o`?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3_mnm7kdO_Anm7kdO_Co3D`00ooOg`0;g`0>oimOWenO
GimOWenOGolC000<oj3PX>2Ph:3PX>2P0_l=g`03omoO00_O05?om7kdO_Anm7kdO_AnogkdO_Anm7kd
O_Anm7ko0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3oj3PX>2Ph:3PX>2Ph?oPX>2Ph:3PX>2Ph:3P
o`0;00002P003OnPh:3PX>2Ph:3PX>000_l0A:3PX>2Ph:3PX>2Ph?m@T52@D91@T52@D91@o`l33`<?
0`l33`<?0`oo3_4>l@ka3_4>l@ka3_maOW5nLGiaOW5nLGko3D`00ooOg`0;g`0>oimOWenOGimOWenO
GolC000<on2Ph:3PX>2Ph:3P0_l=g`03omoO00_O05?oOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o
3`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?on2Ph:3PX>2Ph:3PX?nPh:3PX>2Ph:3PX>2Po`0;0000
2P000ooPX003o`07X>2Ph:3PX002o`0=h?ooon2Ph:3PX>2Po`02D0?o25000ol3eP03o`0;eP?F0mH3
eP?o3[000ol02[0>/0j`3[0>ogh3o`09O_Anm7kdO_Co009<0ol8C003omoO00?o2=l00onOG`03o`08
GimOWenOGolC0003oj3o00;o00NPh:3PX>2P00;o0]l3o`SO00?ogml00ol8g`03ooAn00?o00Ynm7kd
O_Anogkd0ol02oAnm7kdO_Ano`?F00?o00_F0mH3eP?F0ol3eP03o`0:eP?F0mH3eP?oX0?o00^Ph:3P
X>2Ph?oPX003o`09X>2Ph:3PX>3o00/0000:000=oj3PX>2Poj3PX>2Ph002o`14X>2Ph?oPX>2Ph:3P
oe2@D91@oe2@D91@T53o3`<?0`oo3`<?0`l33ol>l@ka3_l>l@ka3_4>og5nLGkoOW5nLGiaO_l5C003
oda<00E<00?ogml00ml00ooOg`05g`0>oimOWenOoimOWenOGolC000<on2Ph:3oX>2Ph:3P0_l5g`03
omoO00GO00?ogml00ml00ooOg`05g`1CogiaOW5nogiaOW5nLOmaOW5nLOmaOW5nLGiao`l33`<?o`l3
3`<?0`oo3`<?0`oo3`<?0`l33ooPX>2Poj3PX>2Ph:3oX>2Ph:3oX>2Ph:3PX?l02`0000X000?oh:00
1?l01^2Poj3PX0;o00?Pool00_l02:3Pon2Ph:3o0U04o`9@0_l3D003o`?F00Co00X3oooo0mH3o`j`
1?l02@j`ool>/0koOP04o`08m?ooooAnm?l2C0Co0T`3o`9<00?ogml01?l01=ooool3g`03oimO00Co
00>Oool00_l00eoo000B0003oj3o00?o00KPX?nPh:02o`;O1?l01=ooool3g`03omoO00Co00COoooo
0ml00oodOP04o`09m?ooooAnogkd00Co00YnooooO_Ano`?F1?l02P?oool3eP?o0mH4o`090oooo`?F
0onP00Co00[PX?nPh:3Pon2P1?l02>2Poj3PX>3o2`0000X000goX?nPh:3oX>3oh:3P00?o03GPX>3o
h:3oX>2Ph?m@oe2@D?m@oe2@oi1@o`oo3`<?o`l33`?o0`oo3_l>l@ko3_l>lOoa3P02o`0>OW5nogia
OW7oLGkoC?l3C005oda<C?l00d`00ooOo`03g`04omoOo`CO00koWonOGiooWeooGimOoa<00_l02Z3P
X?nPh?oPX>02o`03gooO00;O00Cogmoo1=l00ooOo`03g`04omoOo`CO03OoO_mnLGkoOW5nLOmaog7o
LGiaog5nLGkoOW7o3ol?0`oo3`<?0ol33ol?o`l33ol?0`l3o`<?00;o01ZPh:3oX>3oh:3PX?nPoj3P
X?nPh?oPX>2Po`/0000:000=on3oh:3Pon2Ph?oPX003o`0>X>2Poj3PX?nPh:3oD?l3D003oe3o009@
01ooD53o0ol3eP?o0mH3e_oF0ol>o`j`3_l>o`j`ok0>00;o00kdO_Com7kdO_mnm?m<o`=<00?oC?l0
0ol2C003omoo00?O00Cogmoo1=l03_nOoimOWonOGiooWeoo4`02o`0:h:3Pon2Ph?oPX0;o00?Ooml0
0]l01?oOgol4g`03omoo00?O00Cogmoo1=l0=oodooAnm?odO_AnogkoO_mnm7koO_Anm?odO_l3o`?F
0ol3eP?FomH3o`?o0mH3o`?F0mKoeP<00_l06^2Ph?oPX>3oh:3Pon3oh:3Pon2Ph?oPX>3o2`0000X0
00goX?nPh:3oX>2Poj3P00?o01CPX>3oh:3Pon2Ph?m@oe2@D?m@T0;o00]@T53o3ol?0`oo3`03o`0;
3`<?o`ko3_4>o`h00ol00`ka3P02o`06OW5nogia0_l01WiaO_m<o`=<00GoC?m<o`03C003omoo00?O
00Cogmoo1=l03_nOoimOWonOGimOoeoo4`02o`0:X>2Poj3PX?nPh0;o00?Ooml00]l01?oOgol4g`03
omoo00?O00Cogmoo1=l02OmnogiaO_mnL@02o`0;OW7oLOmaOW7oLGh00_l02g5nLOl?o`l33ol?00?o
00/?0`oo3ol?0`oo3`03o`033`<?00;o01ZPh:3oX>2Poj3PX?nPoj3PX?nPh:3oX>2Po`/0000:0003
on2P00Go00FPh:3oX002o`03h?oo00?o00OPX>3oh:3o009@1_l2D006oe1@o`?F1_l020?F0mH3o`j`
1_l01`j`3[0>ogh01Ol01gkdO_mnm?l00T`6o`03C?m<009<00?ogml01Ol00moog`03g`03oimO00Ko
00FOGomOo`0C0003oj3o00Co00FPh:3oX002o`;O1Ol00moog`03g`03omoO00Go00?Ooml00ml00ood
OP05o`08O_AnogkoO_@5o`09m7kdooAno`?F00Ko00P3eP?F0ol3ePKo00L3eP?F0onP00Go00VPh:3o
X>3oh:001Ol01j3PX?nPh?l02`0000X000SoX>2Ph:3PX0Co00WPoonPh:3PX>001?l02j3Poe2@D91@
T52@00;o00]@T53o3`<?0`l33`04o`0;0`oo3_4>l@ka3_400ol02O4>og5nLGiaOP03o`04OW5no`Q<
0_l3C003omoO00GO0_l4g`09oimOWenOGimO00;o00>OGol04`001ooPX>2Ph:001?l00n3oo`07g`;o
1=l00ooOg`05g`;o1=l02?mnLGiaOW5n0ol02Wiaog5nLGiaOW43o`0;LGiao`l33`<?0`l01?l02P<?
o`l33`<?0`l4o`090`ooh:3PX>2P00Co00[PX?nPh:3PX>2P1?l00n2Po`0;00002P003OoPX>2Ph:3P
X>2Ph:000_l03N2Ph:3PX>2Ph:3PX?l03E00:_l3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0koO_An
m7kdO_Anm7kdo`e<00?ogml02ml03_nOGimOWenOGimOWeoo4`003?nPh:3PX>2Ph:3PX0;o3Ml00ooO
g`0;g`1CooAnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Ano`?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F
0onPh:3PX>2Ph:3PX>3oh:3PX>2Ph:3PX>2Ph?l02`0000X000goX>2Ph:3PX>2Ph:3P00;o04BPh:3P
X>2Ph:3PX>3oD91@T52@D91@T52@D?l?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@koLGiaOW5nLGia
OW5no`e<00?ogml02ml03_nOGimOWenOGimOWeoo4`003?oPX>2Ph:3PX>2Ph0;o3Ml00ooOg`0;g`1C
ogiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiao`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33ooPX>2P
h:3PX>2Ph:3oX>2Ph:3PX>2Ph:3PX?l02`0000X000goh:3PX>2Ph:3PX>2P00;o00gPX>2Ph:3PX>2P
h:3o00e@02[o0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>ogkdO_Anm7kdO_Anm?l=C003omoO00_O
00koWenOGimOWenOGimOoa<000coX>2Ph:3PX>2Ph:02o`gO00?ogml02ml0DoodO_Anm7kdO_Anm7ko
O_Anm7kdO_Anm7kdO_l3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?oX>2Ph:3PX>2Ph:3Pon2Ph:3P
X>2Ph:3PX>3o00/0000:07co4`1lo`/0000:000=ok0>/0j`3[0>/0j`3P02o`0K/0j`3[0>/0j`3[0>
o`?F0mH3eP?F0mH3eP?o00e@01coX>2Ph:3PX>2Ph:3PX?mOWenOGimOWenOGioo3Ml00om<C00;C00>
ooAnm7kdO_Anm7kdO_lC000<o`j`3[0>/0j`3[0>0_l=g`0?oimOWenOGimOWenOGioo00cO04KoGimO
WenOGimOWenOGol3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0ko0mH3eP?F0mH3eP?Fok0>/0j`3[0>
/0j`3[3o2`0000X000gol@ka3_4>l@ka3_4>00;o04Ca3_4>l@ka3_4>l@ko3`<?0`l33`<?0`l33om@
T52@D91@T52@D91@on2Ph:3PX>2Ph:3PX>3oGimOWenOGimOWenOo`gO00?oC4`02d`03_mnLGiaOW5n
LGiaOW7o4`003?l>l@ka3_4>l@ka3P;o3Ml03onOGimOWenOGimOWenOo`0<g`16oenOGimOWenOGimO
Weoo3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>o`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kao`/0
000:0003ok0>00?o00L>/0j`3[0>00;o00n`oooo/0j`3[0>/0ko0mH00ol02MH3eP?F0mH3o`02D0?o
25000onPh003o`0:h:3PX>2Ph:3oG`?o00UOWenOGimOWol00]l3o`SO00?oC4`00ol8C003ooAn00?o
00Qnm7kdO_Anoa<000?o3_l00_l01`j`3[0>/0h00_l2g`?o2=l00onOG`03o`09GimOWenOGioo00;O
0ol7g`03oenO00?o00^OGimOWenOGol3eP03o`0;eP?F0mH3eP?o3[000ol02[0>/0j`3[0>o`<3o`0;
0mH3eP?F0mKo/0h00ol02@j`3[0>/0j`o`0;00002P003Ooa3_4>lOoa3_4>l@h00_l0A?4>l@ko3_4>
l@ka3_l?0`l33ol?0`l33`<?oe2@D91@oe2@D91@T53oh:3PX>3oh:3PX>2Ph?mOWenOoimOWenOGioo
1Ml00ooOg`05g`03oda<00=<00?oC4`01D`03_mnLGiaO_mnLGiaOW7o4`003?l>l@kaoo4>l@ka3P;o
1Ml00ooOg`05g`0?oimOWenOoimOWenOGioo00GO00?ogml01=l0A_mOWenOGomOWenOGimOo`l33`<?
o`l33`<?0`oo3_4>l@ko3_4>l@ka3_l?0`l3o`<?0`l33`?ol@ka3_7ol@ka3_4>lOl;00002P000on`
3P04o`06/0kook0>0_l00k3oo`02o`0:3[3oo`j`3_l3ePCo00P3oooo0mH3o`9@1?l2D0;o0e000onP
h004o`09X>3oh:3PX?mO00Co00>Oool00_l00enOo`02g`Co00COoooo0ml00om<C004o`9<0ol2C003
ooAn00Co00Odoooom7ko01<000?o3_l00ol01[0>oon`3P;o0]l4o`04goooo`?O00?oWel01?l00ioo
o`02o`03Gioo00;O1?l01=ooool2g`03oenO00Co00=Oool00_l01ImOo`?F00Co00X3oooo0mH3o`j`
1?l02@j`ool>/0ko0`04o`0:e_ooomH3e_n`3PCo00R`3_oo/0j`o`/0000:000=oo7ol@kaoo7ol@ko
3P03o`0e3_4>o`ko3_7ol@ko3ol?0`oo3`<?0ol33om@oe2@D?m@oe2@oi1@on3oh:3Pon2Poj3PX>00
0_l03YmOWonOGomOWenOomoo0ml01?oOgol4g`03odco00=<00GoC4a<o`03C00>ogkoOW5nogiaOW7o
LOlC00;o00[a3_7olOoa3_l>0_l00moog`02g`04omoOo`CO017oWonOGiooWeooGimOWooOo`03g`04
omoOo`?O02[oGomOWeooGiooWenOGol?o`l33ol?0`l3o`<?o`ko3_4>o`ko3_7ol@h2o`0J0`l3o`<?
0`oo3`?olOoa3_7olOoa3_l>lOl;00002P003On`ok0>/?n`ok0>o`h00ol070j`3_l>o`j`ok0>o`?o
0mH3o`?F0mKoeP?oD?l3D003oe3o009@017oD53oX?nPh:3oX>2Poj3PX002o`0>WenOoimOWonOGioo
gol3g`04omoOo`CO00?oC?l00d`00om<o`03o`9<00kom?odO_Com7kdO_mnoa<00_l02[0>/?n`ok0>
o`h2o`03gooO00;O00Cogmoo1=l04OnOoimOWonOGiooWenOomoo00?O00Cogmoo0ml0:_mOoenOGomO
WeooGimOo`?o0mH3o`?F0mKoeP?o3_l>/0ko3_l>/?n`3P;o01[F0mKoeP?F0ol3e_n`ok0>/?n`ok0>
o`j`o`/0000:0008oo7ol@kaoo43o`03l@ko00;o00D>l@ko3P03o`0;3_4>o`oo3`<?o`l00ol030l3
3om@oe2@D?m@T0;o015@T53oh?oPX>3oh:3Pon2Ph002o`0>WenOoimOWeooGioogol3g`04omoOo`CO
00?oC?l00d`01Om<odco00=<00WoO_mnLGkoOW400_l00giao`0C00;o00Ga3_7ol@03o`06l@koomoo
0ml01?oOgol4g`0AoiooWenOoimOWeooGioogol00ml01?oOgol3g`0FoeooGimOoenOGiooWeoo3ol?
0`oo3`?o00/?0`oo3_l>l@ko3P03o`033_4>00;o00D33`?o0`03o`0;0`l3oo7ol@kaoo400ol01?4>
lOl;00002P000on`3P06o`04/0j`3P;o00>`ool01?l020j`3[0>o`?F1_l01P?F0mH3o`9@1_l2D006
oe1@oj3P1Ol02>2Ph?oPX?mO1_l01YmOoenOo`;O1Ol00moog`03g`03oda<00Ko00=<od`00T`00ood
OP05o`06O_Anogko4`000ol>o`05o`04/0j`3P;o0]l5o`03gooO00?O00?oWel01_l01YmOoenOo`;O
1Ol00moog`02g`03oenO00Ko00QOWonOGol3ePKo00P3eP?F0ol>/0Ko00L>/0j`3_l300Ko00SF0mH3
e_n`3PKo00J`3[0>/?l;00002P002Ooa3_4>l@ka3P03o`0:3_ool@ka3_4>l@?o00[a3_l?0`l33`<?
1?l02`<?oe2@D91@T52@00;o00]@T53oh:3PX>2Ph004o`0:X>3oGimOWenOG`;o00BOGioo1ml2o`CO
00?oC4`01T`2o`=<00SoOW5nLGiaOP?o00=nLOl04`002?l>l@ka3_4>0ol00`koo`07g`;o1=l02OnO
GimOWenOG`02o`04WenOo`OO0_l3g`09oenOGimOWenO00;o00]OWeoo3`<?0`l33`04o`0;0`oo3_4>
l@ka3_400ol02O4>o`l33`<?0`04o`0;3`?ol@ka3_4>l@h00ol00`kao`0;00002P003On`3[0>/0j`
3[0>/0h00_l06k0>/0j`3[0>/0j`3_l3eP?F0mH3eP?F0mH3o`0=D00Loj3PX>2Ph:3PX>2Ph:3oGimO
WenOGimOWenOo`gO00?oC4`02d`03_odO_Anm7kdO_Anm7ko4`003?l>/0j`3[0>/0j`3P;o3Ml03onO
GimOWenOGimOWenOo`0<g`16oenOGimOWenOGimOWeoo0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>
o`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`o`/0000:000=oo4>l@ka3_4>l@ka3P02o`14l@ka3_4>
l@ka3_4>o`l33`<?0`l33`<?0`ooD91@T52@D91@T52@D?oPX>2Ph:3PX>2Ph:3PoenOGimOWenOGimO
Wol=g`03oda<00]<00koOW5nLGiaOW5nLGiaoa<000co3_4>l@ka3_4>l@h2o`gO00ooWenOGimOWenO
GimOWol03=l0A_mOWenOGimOWenOGimOo`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_l?0`l33`<?
0`l33`?ol@ka3_4>l@ka3_4>lOl;00002P003On`3[0>/0j`3[0>/0h00_l06k0>/0j`3[0>/0j`3_l3
eP?F0mH3eP?F0mH3o`0=D00Loj3PX>2Ph:3PX>2Ph:3oGimOWenOGimOWenOo`gO00?oC4`02d`03_od
O_Anm7kdO_Anm7ko4`003?l>/0j`3[0>/0j`3P;o3Ml03onOGimOWenOGimOWenOo`0<g`16oenOGimO
WenOGimOWeoo0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>o`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>
/0j`o`/0000:07co4`1lo`/0000:000=omH3eP?F0mH3eP?F0`02o`0YeP?F0mH3eP?F0mH3o`j`3[0>
/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX?l03E000ooOg`0:g`0MoimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm?l034`00ol0000A000<o`?F0mH3eP?F0mH30_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`0h
o`?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3e_l;0000
2P000ol33`03o`073`<?0`l33`02o`0?0oooo`<?0`l33`<?o`ka00?o00_a3_4>l@ka3_oPX003o`0;
X>2Ph:3PX>3oD9000ol02Y1@T52@D91@oml3o`SO00?oWel00ol02enOGimOWenOogia00?o00UaOW5n
LGiaO_l00T`3o`M<00?o00004@000ol?o`02o`073`<?0`l33`02o`;O0ol8g`03omoO00?o2=l00ooO
g`03o`OO00?ogml00ol8g`03o`l300?o00/33`<?0`l33ol?0`03o`0:0`l33`<?0`oo3`?o00/?0`l3
3`<?0ol33`03o`093`<?0`l33`?o00/0000:000=omH3eP?FomH3eP?F0`02o`0YeP?F0ol3eP?F0mH3
o`j`3[0>o`j`3[0>/0koX>2Ph:3oX>2Ph:3PX?l01E000om@D005D003omoO00;O00?ogml01Ml07OnO
GimOWonOGimOWenOooAnm7kdooAnm7kdO_Co00E<00?oC4`014`00ol0000A000<o`?F0mKoeP?F0mH3
0_l5g`03omoO00GO00?ogml00ml00ooOg`05g`03omoO00?O00?ogml01=l00ooOg`03g`03omoO00GO
03So0mH3eP?o0mH3eP?F0ol3eP?F0ol3eP?F0mH3o`?F0mKoeP?F0mH3e_oF0mH3e_oF0mH3eP?Fo`/0
000:0003o`<?00Co00H3oooo0`l2o`030ooo00;o00X?oooo3`<?o`ka1?l02Pkaool>l@koh:04o`0:
h:3oX>2Ph?m@T0Co00U@T?ooD91@oml01?l01=ooool3g`03oimO00Co00>Oool00_l01EnOogia00Co
00QnooooOW5no`9<1?l2C0?o00=<o`004P000ol?o`03o`060oooo`<?0_l2g`Co00COoooo0ml00ooO
g`04o`04goooo`?O00?ogml01?l01=ooool2g`03omoO00Co00COoooo0ml00ol?0`04o`0:3oooo`l3
3ol?0`Co00T?oooo3`<?o`l01?l02P?oool33`?o0`l4o`080oooo`<?0ol;00002P003OoFomH3e_oF
0mH3o`<00ol0:P?F0ol3eP?FomH3o`ko3[0>o`ko3[3o/0koX?nPh:3oX>3oh:3PX?m@o`=@00?oD?l0
0U000om@D002o`?O00Cogmoo1=l07onOoimOWonOGomOWenOooCom7kdooAnm7koO_CoC?l00d`01Om<
C4co009<00?o00004@02o`0:eP?FomH3eP?o0`;o00?Ooml00]l01?oOgol4g`03omoo00?O00Cogmoo
1=l00ooOo`03g`04omoOo`?O00?ogol00ml01?oOgol4g`0Lo`?o0mH3o`?F0mKoeP?o0ol3eP?o0mH3
e_oF0`;o01[F0mKoeP?F0ol3e_oFomH3e_oF0mH3o`?Fo`/0000:000=o`?o0`l3o`<?0`oo3`03o`0e
3`<?o`l33`?o0`oo3_l>l@ko3_l>lOoa3_oPon2Ph?oPX>3oh:3Poe3oD91@oe3oD93oT5000_l3g`04
omoOo`CO01ooWonOGiooWenOoimOWomnogiaO_mnLGiaog5nodco00=<00?oC?l00ol00dco000B00;o
00X33`?o0`l33ol?0_l00moog`02g`04omoOo`CO00?ogol00ml01?oOgol4g`03omoo00?O00Cogmoo
0ml00ooOo`03g`04omoOo`CO01co3ol?0`oo3`<?0ol33ol?o`l33ol?0`l3o`<?0_l06P<?0ol33`<?
o`l3o`?o0`l3o`<?0`oo3`?o2`0000X000Soe_oF0mKoeP?o00?F0ol00_l01@?F0ol300?o00/3eP?o
3_l>/0ko3P03o`0D3[0>oj3oX>2Poj3PX?nPh:3oD?l3D003oe1@00;o0e02o`?O00Cogmoo1=l05onO
oimOWonOGimOoenOooCom7kdooAn00;o00KdO_CoC?l3C005odcoC?l00T`00ol0000A00;o00GF0mKo
eP03o`06eP?oomoo0ml01?oOgol4g`03omoo00?O00Cogmoo1=l00ooOo`03g`04omoOo`?O00?ogol0
0ml01?oOgol4g`08o`?o0mH3o`<3o`0;0mH3o`?o0mH3o`<00ol00`?F0`02o`05eP?FomH00ol02mH3
e_oFomH3e_oF00?o00CF0mKo2`0000X000?o0`l01_l010<?0`l2o`030ooo00Co00P?0`l33ol>l@Ko
00P>l@ka3_oPX0Go00VPh:3oX>3oD9001_l01e2@oi1@oml01Ol00moog`03g`03oimO00Ko00ROGomO
WomnL@Go00MaOW7oLGko009<1_l01DcoC4co01<000?o3ol01Ol010<?0`l2o`;O1Ol00moog`03g`03
omoO00Go00?Ooml00ml00ooOg`05o`03gooO00;O00?ogml01Ol00moog`03g`03o`l300Ko00P?0`l3
3ol?0`Ko00L?0`l33ol?00Ko00P33`<?0ol33`Ko00H33`<?0ol;00002P002?oF0mH3eP?F1?l02@?o
omH3eP?F0`04o`0;eP?o3[0>/0j`3[000ol02[0>oj3PX>2Ph:04o`03h:3o00Q@0_l3D003omoO00CO
0_l4g`09oimOWenOGimO00;o00^OGioom7kdO_Anm003o`04m7kdo`Q<0_l2C003o`00014000Oo0mH3
eP?F00Co00<3ool01ml2o`CO00?ogml01Ml2o`CO00?ogml01Ml2o`?O00?ogml01Ml2o`CO00So0mH3
eP?F0`Co00[F0ol3eP?F0mH31?l02MH3o`?F0mH3eP04o`0:0mKoeP?F0mH3ePCo00<3e_l02`0000X0
00go0`l33`<?0`l33`<?00;o03L33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_oPX>2Ph:3PX>2Ph:3P
oe2@D91@T52@D91@T53o00cO01goWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5no`0<C003o`000140
00co3`<?0`l33`<?0`l2o`gO00?ogml02ml00ooOg`0:g`03omoO00_O03So3`<?0`l33`<?0`l33ol?
0`l33`<?0`l33`<?o`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l3o`/0000:000=omH3eP?F0mH3eP?F
0`02o`0YeP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0koX>2Ph:3PX>2Ph:3PX?l03E000ooOg`0:g`0M
oimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm?l034`00ol0000A000<o`?F0mH3eP?F0mH30_l=g`03
omoO00_O00?ogml02]l00ooOg`0;g`0ho`?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0ol3eP?F0mH3
eP?F0mKoeP?F0mH3eP?F0mH3e_l;00002P003Ol33`<?0`l33`<?0`l00_l0=`<?0`l33`<?0`l33ol>
l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3PX>3oD91@T52@D91@T52@D?l03=l07OnOGimOWenOGimOWenO
ogiaOW5nLGiaOW5nLGko00a<00?o00004@003?l?0`l33`<?0`l33`;o3Ml00ooOg`0;g`03omoO00[O
00?ogml02ml0>?l?0`l33`<?0`l33`<?o`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l3o`<?0`l33`<?
0`l33`?o2`0000X0O?lC07co2`0000X000?oC4`02T`2o`a<01goLGiaOW5nLGiaOW5nLOmOWenOGimO
WenOGimOo`0=g`0goe2@D91@T52@D91@T?nPh:3PX>2Ph:3PX>2Poo4>l@ka3_4>l@ka3_7o0`l33`<?
0`l33`<?o`0C0003oda<00U<0_l=g`0LoimOWenOGimOWenOGiooOW5nLGiaOW5nLGiao`e<00?ogml0
2ml07?mOWenOGimOWenOGimOog5nLGiaOW5nLGiaO_l=C003o`0000T0000:0003oda<00Y<0_l<C00M
ogkdO_Anm7kdO_Anm7koGimOWenOGimOWenOGol03Ml00om@D00:D00Zon2Ph:3PX>2Ph:3PX>3o/0j`
3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?o4`000om<C009C0;o3Ml07?nOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_l=C003omoO00_O01coGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Co3D`00ol000090000
2P000om<C003o`M<0_l014coool8C003og5n00?o00]nLGiaOW5nLOmOW`03o`09WenOGimOWeoo00;O
0ol8g`03oe3o00;o00]@T52@D91@T?nPh003o`0;h:3PX>2Ph:3ol@h00ol02`ka3_4>l@kao`<?00?o
00P?0`l33`<?oa<000?oC?l00_l7C0;o0]l3o`SO00?oWel00ol02enOGimOWenOogia00?o00QaOW5n
LGiao`9<0ol8C003omoO00?o2=l00omOW`03o`0:WenOGimOWeooL@?o00UaOW5nLGiaO_l00T`3o`Q<
00?o00002@0000X000?oC4`00d`00om<C004C0;o14`00om<C005C00MogkdO_AnogkdO_Anm7koGimO
WeooGimOWenOGol01Ml00ooOg`05g`03oe1@009@00?oD5001E00:_oPX>2Ph?oPX>2Ph:3Pok0>/0j`
ok0>/0j`3[3oeP?F0mKoeP?F0mH3oa<000?oC4`00T`00om<C004C0;o1Ml00ooOg`05g`0LoimOWenO
oimOWenOGioom7kdO_Com7kdO_Ano`E<00?oC4`01D`00ooOg`03g`03omoO00GO01coGimOWeooGimO
WenOGomnm7kdooAnm7kdO_Co1D`00om<C005C003o`0000T0000:0003oda<00Co0T`3o`04C?ooC0Co
0T`3o`9<00?oLGh01?l02W7ooomaOW7oGil4o`03Gooo00;o00>OGol00]l4o`04goooo`?O00?oD?l0
0ol02Y1@oon@D93oX>04o`0:X>3oh:3PX?oa3PCo00[a3_ool@kao`<?1?l01`?oool33ol04`000om<
o`03o`9<0ol00dcoo`02g`Co00COoooo0ml00onOG`04o`03Wooo00;o00EOWomnL@04o`07O_ooogia
o`02C0Co0T`3o`9<00?ogml01?l01=ooool3g`03oenO00Co00=Oool00_l019mOog44o`08O_ooogia
O_l2C0Co0T`3o`9<00?o00002@0000X000?oC?l00d`01Om<C4co009<0ol3C005oda<C?l00d`07omn
ogkdO_mnm7kdooAnoeooGimOoenOoimOWeoogol00ml01?oOgol4g`;o0e000om@o`02D00]oe1@on3o
h:3Pon2Poj3PX>3o/?n`3[3o/?n`3_l>/?oFomH3e_oF0mH3o`?o01<00_l3C005oda<C?l00T`2o`03
gooO00;O00Cogmoo1=l07_nOoimOWonOGomOWenOooCom7kdooAnm7koO_m<o`=<00GoC4a<o`03C003
omoo00?O00Cogmoo1=l03_mOoenOGomOWonOGimO0_l03_Anm?odO_Anogkdodco0d`01Om<C4co00=<
00?o00002@0000X000?oC?l00d`00om<o`03o`04C?ooo`=<00?oC?l00ol2C00Oog7oLGiaog5nLGko
OW7oGomOWeooGimOoenOGooOo`03g`04omoOo`CO0_l0=I1@T?n@oi1@oe2@oj3oX>2Poj3PX?nPh:3o
lOoa3_7olOoa3_l>lOl3o`<?0ol33`<?o`oo01<00_l3C003odco00?o00E<oooOo`03g`04omoOo`CO
01koWonOGiooWenOoimOWomnogiaO_mnLGiaog7oC?l3C003odco00?o0T`00ooOo`03g`04omoOo`CO
00koGomOWeooGimOoenOG`;o00inLGkoOW5nLOmaO_m<o`=<00?oC?l00ol2C003o`0000T0000:0003
odco00=<00GoC?m<o`02C0?o0d`01Om<odco00=<00WoO_mnm7koO_@00_l057kdO_mOoenOGomOWenO
oimOomoo0ml01?oOgol4g`;o0e000om@D002o`=@01Koh?oPX>3oh:3Pon2Ph?n`ok0>/?n`0ol02k0>
/?oFomH3e_oF00?o00?F0ol04`02o`=<00GoC?m<o`02C0;o00?Ooml00]l01?oOgol4g`0GoiooWenO
oimOWeooGioom?odO_Com7h00_l01OAnodco00=<00GoC?m<o`03C003omoo00?O00Cogmoo1=l03_mO
oenOGomOWenOoimO0_l01_Anm?odOP;o00KdO_CoC?l3C005odcoC?l00d`00ol0000900002P000om<
C006o`04C?m<C0;o00=<ool01?l00dcoC002C003og5n00Go00UnLGkoOW7oGil01_l01UnOoimOo`;O
1Ol00moog`03g`03oe3o00Go00R@D?m@T?nPh0Go00WPX>3oh:3ol@h01_l02?4>l@kao`<?1_l01@<?
0`oo01<000?oC?l01Ol014coC4`2o`;O1Ol00moog`03g`03oimO00Ko00ROGomOWomnL@Go00IaOW7o
LOl2C0Ko00=<od`00T`00ooOg`05o`03gooO00?O00?oGil01_l01enOoimOog401Ol01g5nLOmaO_l0
0T`6o`03C?m<009<00?o00002@0000X000?oC4`01T`2o`9<0_l7C0;o0d`02?mnm7kdO_An0ol037kd
O_mOWenOGimOW`;o00AOWeoo1ml2o`CO00?oD5001E02o`=@00Soh:3PX>2Ph0Co00^Ph?n`3[0>/0j`
3P03o`0:3[3oeP?F0mH3ePCo00<3o`004P000om<C005C0;o0T`2o`OO0_l4g`09oimOWenOGimO00;o
00^OGioom7kdO_Anm003o`03m7ko00Q<0_l3C003omoO00GO0_l4g`09oenOGimOWenO00;o00YOWeoo
O_Anm7kd0ol01?Anm?l8C0;o0d`00ol0000900002P000om<C00:C0;o34`07OmaOW5nLGiaOW5nLGia
oenOGimOWenOGimOWeoo00gO03OoD91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph:3ol@ka3_4>l@ka3_4>
lOl33`<?0`l33`<?0`oo01<000?oC4`02D`2o`gO01coWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7o
3D`00ooOg`0;g`0LoenOGimOWenOGimOWeooLGiaOW5nLGiaOW5no`e<00?o00002@0000X000?oC4`0
2T`2o`a<01goO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOo`0=g`03oe1@00Y@02[oh:3PX>2Ph:3P
X>2Ph?n`3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0olC0003oda<00U<0_l=g`0LoimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Ano`e<00?ogml02ml07?mOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?l=C003
o`0000T0000:0003oda<00Y<0_l<C00Mog5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGol03Ml0=om@
T52@D91@T52@D93oX>2Ph:3PX>2Ph:3PX?oa3_4>l@ka3_4>l@kao`<?0`l33`<?0`l33ol04`000om<
C009C0;o3Ml07?nOGimOWenOGimOWenOogiaOW5nLGiaOW5nLOl=C003omoO00_O01coGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGko3D`00ol0000900002P1loa<0O?l;00002P003OmnLGiaOW5nLGiaOW40
0_l03GiaOW5nLGiaOW5nLOl03D`00ooOg`0;g`15oenOGimOWenOGimOWeooh:3PX>2Ph:3PX>2Poi1@
T52@D91@T52@D93o0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ko01<000coLGiaOW5nLGiaOW42o`gO
00?ogml02ml07?mnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl=g`03omoO00_O01coLGiaOW5nLGia
OW5nogiaOW5nLGiaOW5nLGko2`0000X000gom7kdO_Anm7kdO_An00;o00gdO_Anm7kdO_Anm7ko00e<
00?ogml02ml07?mOWenOGimOWenOGimOoj3PX>2Ph:3PX>2Ph?l=D00LomH3eP?F0mH3eP?F0mKo/0j`
3[0>/0j`3[0>oa<000coO_Anm7kdO_Anm7h2o`gO00?ogml02ml07?odO_Anm7kdO_Anm7koO_Anm7kd
O_Anm7kdO_l=g`03omoO00_O01coO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co2`0000X000?oOW40
0ol01g5nLGiaOW400_l03GkooomnLGiaOW5nLOl00T`3o`Q<00?ogml00ol8g`03oenO00?o00ZOGimO
WenOGooP0ol02n2Ph:3PX>2Poi1@00?o00]@T52@D91@T?l33`03o`0;3`<?0`l33`?ol@h00ol020ka
3_4>l@ko4`000omao`02o`07LGiaOW5nL@02o`;O0ol8g`03omoO00?o2=l00omnL@03o`0:LGiaOW5n
LOmaOP?o00UnLGiaOW5nLOl00]l3o`SO00?ogml00ol8g`03og7o00;o00]aOW5nLGiaO_mnL@03o`09
LGiaOW5nLGko00/0000:000=ooAnm7kdooAnm7kdOP02o`0=m7kdO_mnm7kdO_Ano`05C003oda<00E<
00?ogml00ml00ooOg`05g`0LoenOGimOoenOGimOWeooX>2Ph?oPX>2Ph:3Po`E@00?oD5001E007?oF
0mH3e_oF0mH3eP?Fok0>/0j`ok0>/0j`3_lC000<ogkdO_Com7kdO_An0_l5g`03omoO00GO00?ogml0
0ml00ooOg`05g`0LooAnm7kdooAnm7kdO_mnm7kdO_mnm7kdO_Ano`GO00?ogml01Ml00ooOg`03g`03
omoO00GO01coO_Anm?odO_Anm7kdooAnm7kdooAnm7kdO_Co2`0000X000?oOW401?l01WkooomnL@;o
00=nool00_l0277ooomaOW7o0T`4o`9<0ol2C003omoO00Co00COoooo0ml00omOW`04o`03Gooo00;o
00BOGooP1?l02Z3Pon2Ph:3oT504o`0:T53ooi1@T?l33`Co00X3oooo0`l3oo4>1?l01o4>oooa3_l0
4`000omao`03o`06O_ooogia0_l2g`Co00COoooo0ml00ooOg`04o`04goooo`?O00?oOW401?l02Gko
oomnLOmaOP04o`08LOooog5nLOl2g`Co00COoooo0ml00ooOg`04o`04goooo`?O00?oLOl00ol02Wko
oomnLGkoOW44o`08O_ooogiaO_l;00002P003OodooAnm?odO_Anogh00ol03WkdO_mnm7kdooAnodco
0d`01Om<C4co00=<00?ogol00ml01?oOgol4g`0>oeooGimOoenOoimOWel2o`0>h:3Pon2Poj3PX>3o
D?l3D003oe3o009@01ooD53oe_oF0mKoeP?F0ol3e_n`ok0>/?n`ok0>o`ko01<00_l02_Anm?odO_An
ogh2o`03gooO00;O00Cogmoo1=l00ooOo`03g`04omoOo`CO01kom?odO_Com7kdO_mnogkoO_Anogkd
O_Com7kogol3g`04omoOo`CO00?ogol00ml01?oOgol4g`;o01[dO_Com7kdO_mnm?odooAnm?odO_An
ogkdo`/0000:000=ogkoOW5nogiaOW7oL@03o`0>LGiaog5nLGkoOW7oC?l3C003odco00?o0T`00ooO
o`03g`04omoOo`CO00koGomOWeooGimOoenOG`;o03FPh:3oX>2Poj3PX?n@oi1@T?n@oi1@oe2@o`?o
0`l3o`<?0`oo3`?olOoa3_7olOoa3_l>o`0C00;o00YnLGkoOW5nLOma0_l00moog`02g`04omoOo`CO
00?ogol00ml01?oOgol4g`0NogkoOW5nogiaOW7oLOmaog5nLOmaOW5nogiaomoo0ml01?oOgol4g`03
omoo00?O00Cogmoo1=l2o`0JOW5nogiaOW7oLGkoO_mnLGkoOW5nLOmaO_l;00002P002OodooAnm?od
OP02o`03m7ko00;o00Inm7koO_@2o`06O_Anodco0d`01Om<odco00=<00?ogol00ml01?oOgol4g`0>
oeooGimOoenOGiooWel2o`0>h:3Pon2Ph?oPX>3oD?l3D003oe1@00;o0e002?oFomH3e_oF0ol02mH3
e_n`ok0>/?n`00?o00>`3_l04`02o`06m7kdooAn0_l01_AnoooOo`?O00Cogmoo1=l00ooOo`03g`04
omoOo`CO00Wom?odO_Com7h00_l02oAnogkoO_Anogkd00;o00Inm7kogol3g`04omoOo`CO00?ogol0
0ml01?oOgol4g`;o00KdO_Com7h2o`0<m7kdooCom7kdooAn0_l01?Anm?l;00002P000omnL@05o`05
LGiaog400_l00gkoo`03o`07OW5nogiao`02C0Ko00=<od`00T`00ooOg`05o`03gooO00?O00?oGil0
1_l01enOoimOon001Ol02N2Ph?oPX?n@D006o`08T53oD93o0`l6o`080`l33`?ol@h6o`05l@ka3_l0
4`000omao`04o`05LGiaog400_l2g`Go00?Ooml00ml00ooOg`05o`03gooO00?O00?oOW401Ol0275n
LOmaog5n1Ol01giaO_mnLOl00]l5o`03gooO00?O00?ogml01Ol00moog`03g`03og7o00Co00UaOW7o
LGkoOW401Ol01g5nLOmaO_l02`0000X000Som7kdO_Anm0?o00[dO_oom7kdO_An0ol017kdO_l8C0;o
0d`00ooOg`05g`;o1=l02OmOWenOGimOW`02o`0:GimOoj3PX>2Ph0Co00>Ph?l02502o`=@00SoeP?F
0mH3ePCo00/3e_n`3[0>/0j`3P03o`033_l0018000OoO_Anm7kd00?o00CdO_oo1ml2o`CO00?ogml0
1Ml2o`CO00Som7kdO_Anm0?o00[dO_mnm7kdO_An0ol017kdO_l7g`;o1=l00ooOg`05g`;o1=l01omn
m7kdO_@00ol02oAnm?odO_Anm7kd00?o00CdO_Co2`0000X000goOW5nLGiaOW5nLGia00;o00enLGia
OW5nLGiaOW7o00e<00?ogml02ml0AOmOWenOGimOWenOGimOon2Ph:3PX>2Ph:3PX?n@D91@T52@D91@
T52@o`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>o`0C000<og5nLGiaOW5nLGia0_l=g`03omoO00_O
01coOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o3Ml00ooOg`0;g`0Log5nLGiaOW5nLGiaO_mnLGia
OW5nLGiaOW5no`/0000:000=ooAnm7kdO_Anm7kdOP02o`0=m7kdO_Anm7kdO_Ano`0=C003omoO00_O
01coGimOWenOGimOWenOGonPh:3PX>2Ph:3PX>3o3E007?oF0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3_lC000<ogkdO_Anm7kdO_An0_l=g`03omoO00_O01com7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko
3Ml00ooOg`0;g`0LogkdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdo`/0000:000=ogiaOW5nLGiaOW5n
L@02o`0=OW5nLGiaOW5nLGiao`0=C003omoO00_O04GoGimOWenOGimOWenOGooPX>2Ph:3PX>2Ph:3o
T52@D91@T52@D91@T?l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_l04`003?maOW5nLGiaOW5nL@;o
3Ml00ooOg`0;g`0LogiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiao`gO00?ogml02ml07?maOW5nLGia
OW5nLGkoOW5nLGiaOW5nLGiaO_l;00002P1loa<0O?l;00002P003OnOGimOWenOGimOWel00_l03ImO
WenOGimOWenOGol03Ml00om<C00;C015og5nLGiaOW5nLGiaOW7o3_4>l@ka3_4>l@kao`<?0`l33`<?
0`l33`?oT52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>3o01<000coGimOWenOGimOWel2o`gO00ooWenO
GimOWenOGimOWol03=l03omOWenOGimOWenOGimOo`0=g`0?oenOGimOWenOGimOWeoo00cO00ooWenO
GimOWenOGimOWol02`0000X000goWenOGimOWenOGimO00;o00fOGimOWenOGimOWeoo00gO00?oC4`0
2d`0:_mnm7kdO_Anm7kdO_Ano`j`3[0>/0j`3[0>/?oF0mH3eP?F0mH3eP?Fo`e@00koh:3PX>2Ph:3P
X>2Poa<000coGimOWenOGimOWel2o`gO00ooWenOGimOWenOGimOWol03=l03omOWenOGimOWenOGimO
o`0=g`0?oenOGimOWenOGimOWeoo00cO00ooWenOGimOWenOGimOWol02`0000X000?oWel00ol01enO
GimOWel00_l03IoooonOGimOWenOGol00]l3o`SO00?oC4`00ol8C003og5n00?o00YnLGiaOW5nLOl>
0ol02`ka3_4>l@kao`<?00?o00/?0`l33`<?0on@D003o`0;D91@T52@D93oX>000ol02>2Ph:3PX>3o
4`000omOo`02o`07GimOWenOG`02o`;O0ol8g`03oimO00?o00UOWenOGimOWol00]l3o`OO00?oGil0
0ol02ImOWenOGimOo`02g`?o2=l00omOW`03o`0:WenOGimOWeoog`?o2=l00onOG`03o`09GimOWenO
Gioo00/0000:000=oimOWenOoimOWenOG`02o`0=WenOGomOWenOGimOo`05g`03omoO00GO00?oC4`0
0d`00om<C005C00ZogkdO_AnogkdO_Anm7ko3[0>/?n`3[0>/0j`omH3eP?FomH3eP?F0mKo1E000om@
D005D00>on2Ph:3Pon2Ph:3PX?lC000<oenOGiooWenOGimO0_l5g`03omoO00GO00ooWenOGiooWenO
GimOWol01Ml00ooOg`04g`0?oenOGimOoenOGimOWeoo00GO00?ogml01Ml03omOWenOGomOWenOGimO
o`04g`03omoO00GO00ooWenOGiooWenOGimOWol02`0000X000?oWel01?l00iooo`02o`04GoooW`Co
00=Oool00_l00imOo`02g`Co00COoooo0ml00om<C004o`9<0ol2C003og5n00Co00UaooooLGiao`h0
1?l02_4>oooa3_7o0`l4o`0:0oooo`<?0on@D0Co00Z@D?ooT52@oj3P1?l01j3Pon2Ph?l04`000omO
o`03o`03Wooo00;o00=Oool00]l4o`04goooo`?O00?oWel01?l00iooo`02o`03Gioo00;O1?l01=oo
ool2g`03oenO00Co00=Oool00_l00imOo`02g`Co00COoooo0ml00omOW`04o`03Gooo00;o00BOGooO
1?l01=ooool3g`03oimO00Co00>Oool00_l00enOo`0;00002P003OnOoimOWonOGomOWel00ol03UnO
GomOWonOGimOomoo0ml01?oOgol4g`03odco00=<00GoC4a<o`03C00>ogkoO_AnogkdO_Com7h2o`0L
/0j`ok3o/0ko3[3oe_oF0mKoeP?F0ol3e_m@o`=@00?oD?l00U004Om@D?oPon2Ph?oPX?nPh:3o01<0
0_l02YmOWonOGomOWel2o`03gooO00;O00Cogmoo1=l04OnOoimOWonOGomOWenOomoo00?O00Cogmoo
0ml04OmOoenOGomOWonOGimOomoo00?O00Cogmoo1=l03_mOoenOGomOWonOGimO0_l3g`04omoOo`CO
00ooWonOGiooWeooGimOWol02`0000X000goWonOGiooWenOoimO00?o00iOWeooGimOoenOGooOo`?O
00Cogmoo1=l00om<o`03C003odco00?o0T`03_maog5nLOmaOW5nogia0_l0=O4>lOoaoo4>o`kao`?o
0`l3o`<?0`oo3`?oT?n@D93oT?n@D?m@T?nPoj3PX?nPh:3oX>3o01<00_l02YmOWonOGiooWel2o`03
gooO00;O00Cogmoo1=l04OnOoimOWonOGiooWenOomoo00?O00Cogmoo0ml04OmOoenOGomOWeooGimO
omoo00?O00Cogmoo1=l03_mOoenOGomOWeooGimO0_l3g`04omoOo`CO00ooWonOGiooWenOoimOWol0
2`0000X000goWonOGiooWenOGomO00?o00iOWeooGimOWonOGooOo`?O00Cogmoo1=l00om<o`03C005
odcoC?l00d`02OmnogkdO_mnm002o`03O_An00;o00F`3[3o/003o`0;/0j`omKoeP?FomH00ol01]H3
e_m@o`=@00?oD5000_l3D00>on3oh:3Pon2Ph?oPX?lC00;o00ZOGiooWenOGomO0_l00moog`02g`04
omoOo`CO017oWonOGiooWenOGomOWooOo`03g`04omoOo`?O017oGomOWeooGimOWonOGooOo`03g`04
omoOo`CO00koGomOWeooGimOWonOG`;o0ml01?oOgol4g`0?oiooWenOoimOWeooGioo00/0000:0003
oimO00Ko00BOGomO0_l00iooo`04o`06GiooWeoo0]l5o`03gooO00?O00?oC4`01_l00dcoC002C003
og5n00Go00QnLGkoOW7o3PKo00Sa3_4>lOl33`Ko00P33`<?0on@D0Ko00R@D?m@T?nPh0Go00KPX>3o
h?lC0003oeoo00Go00BOGomO0_l2g`Go00?Ooml00ml00onOG`06o`06WeooGioo0]l5o`03gooO00;O
00?oGil01_l01UnOoimOo`;O1Ol00moog`03g`03oenO00Ko00MOWonOGooO00Go00?Ooml00ml00onO
G`06o`06WeooGioo2`0000X000WoWenOGimOWel00_l02imOoonOGimOWenO00;o00AOWeoo1ml2o`CO
00?oC4`01T`2o`=<00SoO_Anm7kdOP?o00]nm7ko3[0>/0j`3P03o`0:3[3oeP?F0mH3ePCo00<3e_l0
2502o`=@00Soh:3PX>2Ph0Co00>Po`004P002?mOWenOGimO0_l019mOool7g`;o1=l02OnOGimOWenO
G`02o`04WenOo`OO0_l3g`09oenOGimOWenO00;o00AOWeoo1ml2o`CO00WoGimOWenOGil00_l015nO
Gol6g`;o1=l02OnOGimOWenOG`02o`04WenOo`/0000:000=oimOWenOGimOWenOG`02o`0=WenOGimO
WenOGimOo`0=g`03oda<00]<04GoLGiaOW5nLGiaOW5nLOl>l@ka3_4>l@ka3_7o0`l33`<?0`l33`<?
0on@D91@T52@D91@T52@oj3PX>2Ph:3PX>2Ph?l04`003?mOWenOGimOWenOG`;o3Ml03onOGimOWenO
GimOWenOo`0<g`0?oenOGimOWenOGimOWeoo00gO00ooGimOWenOGimOWenOGol03=l03onOGimOWenO
GimOWenOo`0;00002P003OnOGimOWenOGimOWel00_l03ImOWenOGimOWenOGol03Ml00om<C00;C00Z
ogkdO_Anm7kdO_Anm7ko3[0>/0j`3[0>/0j`omH3eP?F0mH3eP?F0mKo3E003_oPX>2Ph:3PX>2Ph:3o
4`003?mOWenOGimOWenOG`;o3Ml03onOGimOWenOGimOWenOo`0<g`0?oenOGimOWenOGimOWeoo00gO
00ooGimOWenOGimOWenOGol03=l03onOGimOWenOGimOWenOo`0;00002P003OnOGimOWenOGimOWel0
0_l03ImOWenOGimOWenOGol03Ml00om<C00;C015og5nLGiaOW5nLGiaOW7o3_4>l@ka3_4>l@kao`<?
0`l33`<?0`l33`?oT52@D91@T52@D91@T?nPh:3PX>2Ph:3PX>3o01<000coGimOWenOGimOWel2o`gO
00ooWenOGimOWenOGimOWol03=l03omOWenOGimOWenOGimOo`0=g`0?oenOGimOWenOGimOWeoo00cO
00ooWenOGimOWenOGimOWol02`0000X0O?lC07co2`0000X000?ogml02]l2o`cO01goGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiao`0=C00go`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kaoj3PX>2Ph:3P
X>2Ph:3oT52@D91@T52@D91@o`0C0003omoO00WO0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03
omoO00_O00?ogml02ml00ooOg`0:g`03omoO00_O00?o00002@0000X000?ogml00ol7g`;o00COoooo
2=l00omOW`03o`0;WenOGimOWeooO_@00ol02OAnm7kdO_Ano`02C0?o24`00ol3o`02o`0;0mH3eP?F
0mKo/0h00ol02`j`3[0>/0j`on2P00?o00VPh:3PX>2Ph?l00U03o`M@00?o00004@000ooOo`02o`OO
0_l2g`?o2=l00ooOg`03o`SO00?ogml00ol7g`03omoO00?o2=l00ooOg`03o`SO00?ogml00ol8g`03
omoo00;o2=l00ooOg`03o`SO00?o00002@0000X000?ogml00ml00ooOg`04g`;o1=l00ooOg`05g`0M
oenOGimOoenOGimOWeooLGiaOW7oLGiaOW5nLOl01D`00om<C005C00go`l33`?o0`l33`<?0ooa3_4>
lOoa3_4>l@kaoj3PX>2Poj3PX>2Ph:3oT52@D93oT52@D91@o`0C0003omoO00;O00?ogml01=l2o`GO
00?ogml01Ml00ooOg`03g`03omoO00GO00?ogml00ml00ooOg`04g`03omoO00?O00?ogml01Ml00ooO
g`03g`03omoO00GO00?ogml00ml00ooOg`05g`03omoO00;O00?ogml01Ml00ooOg`03g`03omoO00GO
00?o00002@0000X000?ogml01?l01=ooool2g`;o00?Oool00_l01=ooool3g`03oenO00Co00=Oool0
0_l01ImOogkd00Co00QnooooO_Ano`9<1?l2C0?o0T`00ol3o`03o`0:e_ooomH3e_n`3PCo00Z`3_oo
/0j`on2P1?l02>2Poj3PX>3o0U04o`9@0_l2D003o`00014000?ogol00ol01=ooool2g`;o0]l4o`04
goooo`?O00?ogml01?l01=ooool3g`03omoO00Co00COoooo0]l00ooOg`04o`04goooo`?O00?ogml0
1?l01=ooool3g`03omoO00Co00COoooo0ml00ooOo`03o`04goooo`?O00?ogml01?l01=ooool3g`03
o`0000T0000:0003omoo00?O00Cogmoo0ml3o`?O00Cogmoo1=l07omOoenOGomOWonOGimOog7oLGia
og5nLGkoOW7oC?l00d`01Om<C4co00=<0_l0=@<?0ol33`<?o`l3oo7ol@kaoo7ol@ko3_7oX?nPh:3o
X>3oh:3PX?n@oi1@T?n@oi1@oe3o01<00_l3g`04omoOo`?O0_l00moog`02g`04omoOo`CO00?ogol0
0ml01?oOgol4g`03omoo00?O00Cogmoo0ml00ooOo`03g`04omoOo`CO00?ogol00ml01?oOgol4g`03
omoo00?O00Cogmoo1=l2o`?O00Cogmoo1=l00ooOo`03g`04omoOo`CO00?o00002@0000X000?ogol0
0ml01?oOgol3g`?o0ml01?oOgol4g`0OoeooGimOoenOGomOWeooO_mnm7koO_Anm?odO_m<o`03C003
odco00?o0T`2o`0ZeP?FomH3eP?o0mKo/?n`3[3o/?n`3_l>/?oPon2Ph?oPX>3oh:3Poe3o0e000om@
o`02D003oe3o01<00_l3g`04omoOo`?O0_l00moog`02g`04omoOo`CO00?ogol00ml01?oOgol4g`03
omoo00?O00Cogmoo0ml00ooOo`03g`04omoOo`CO00?ogol00ml01?oOgol4g`03omoo00?O00Cogmoo
1=l2o`?O00Cogmoo1=l00ooOo`03g`04omoOo`CO00?o00002@0000X000?ogol00ml01?oOgol3g`?o
0ml01?oOgol4g`0GoeooGimOoenOGiooWeooLOmaOW7oLGh00_l01W5nLOm<o`=<00GoC?m<o`03C0;o
00D33`?o0`03o`0;0`l3oo7ol@kaoo400ol06_4>lOnPoj3PX?nPh:3oX>2Poi3oT52@oi1@0_l00i1@
o`0C00;o0ml01?oOgol3g`;o00?Ooml00]l01?oOgol4g`03omoo00?O00Cogmoo1=l00ooOo`03g`04
omoOo`?O00?ogol00ml01?oOgol4g`03omoo00?O00Cogmoo1=l00ooOo`03g`04omoOo`CO0_l3g`04
omoOo`CO00?ogol00ml01?oOgol4g`03o`0000T0000:0003omoO00Go00?Ooml00]l2o`03gooo00?o
00?Ooml00ml00omOW`06o`08GiooWeooO_@5o`07m7kdooAno`02C0Ko00=<od`00T`00ol3o`05o`08
eP?F0mKo/0h6o`08/0j`3[3oh:05o`07X>2Poj3Po`02D0Ko0U000om@o`0C0003omoo00Co00?Ooml0
0]l2o`;O1Ol00moog`03g`03omoO00Go00?Ooml00ml00ooOg`05o`03gooO00;O00?ogml01Ol00moo
g`03g`03omoO00Go00?Ooml00ml00ooOg`05o`03gooO00?O00?ogol01?l00moog`03g`03omoO00Go
00?Ooml00ml00ol0000900002P000ooOg`05g`;o0ml2o`KO0_l4g`09oenOGimOWenO00;o00]OWeoo
LGiaOW5nL@03o`04LGiao`Q<0_l3C007o`l33`<?0`04o`0;3`?ol@ka3_4>l@h00ol02Pkaoj3PX>2P
h:04o`0;h:3oT52@D91@T5000_l00i1@o`0C0003omoO00CO0_l3g`;o1ml2o`CO00?ogml01Ml2o`CO
00?ogml01Ml2o`?O00?ogml01Ml2o`CO00?ogml01Ml2o`CO00?ogml01Ml2o`CO00?ogml01=l2o`CO
00?ogml01Ml2o`CO00?o00002@0000X000?ogml02]l2o`cO01goGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o35000ol0
000A0003omoO00WO0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml02ml00ooO
g`0:g`03omoO00_O00?o00002@0000X000?ogml02]l2o`cO01goGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiao`0=C00go`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3oT52@D91@
T52@D91@o`0C0003omoO00WO0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml0
2ml00ooOg`0:g`03omoO00_O00?o00002@0000X000?ogml02]l2o`cO01goGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Ano`0=C00Zo`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o
35000ol0000A0003omoO00WO0_l=g`03omoO00_O00?ogml02]l00ooOg`0;g`03omoO00_O00?ogml0
2ml00ooOg`0:g`03omoO00_O00?o00002@0000T0OOlB07go2`0000T0OOlB07go2`0000X000?o0000
2@03o`cO01goGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiao`0=C00go`l33`<?0`l33`<?0ooa3_4>
l@ka3_4>l@kaoj3PX>2Ph:3PX>2Ph:3oT52@D91@T52@D91@o`0C0003o`0000T00_l=g`0LoimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiao`e<03So3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>on2Ph:3P
X>2Ph:3PX?n@D91@T52@D91@T52@o`/0000:0005o`3oo`000_l40005o`3ooml00ol8g`03oenO00?o
00^OGimOWenOGomnm003o`09m7kdO_Anm7ko009<0ol8C003o`?o00;o00/3eP?F0mH3e_n`3P03o`0;
3[0>/0j`3[3oh:000ol02J3PX>2Ph:3Po`02D0?o1e000ol0000A00?o00<0ool01@03o`;O0ol8g`03
oimO00?o00]OWenOGimOWoodOP03o`08O_Anm7kdO_l2C0?o24`00ol3eP03o`0;eP?F0mH3eP?o3[00
0ol02[0>/0j`3[0>oj03o`09X>2Ph:3PX>3o009@0ol8D003o`0000T0000:0006o`00o`3o10000ol0
0002o`CO00?ogml01Ml07OmOWenOGomOWenOGimOog5nLGiaog5nLGiaOW7o00E<00?oC4`01D`0=ol?
0`l3o`<?0`l33`?ol@ka3_7ol@ka3_4>lOnPh:3PX?nPh:3PX>2Poi1@T52@oi1@T52@D?l04`001Ol0
o`3o00D000Co0?oo1Ml00ooOg`05g`0LoimOWenOoimOWenOGiooOW5nLGkoOW5nLGiao`E<00?oC4`0
1D`0>?l?0`l33ol?0`l33`<?o`ka3_4>o`ka3_4>l@koh:3PX?nPh:3PX>2Poi1@T52@oi1@T52@D93o
2`0000X000Go0000o`040004o`0000;o00?Oool00_l01=ooool3g`03oenO00Co00=Oool00_l01ImO
ogkd00Co00QnooooO_Ano`9<1?l2C0?o0T`00ol3o`03o`0:e_ooomH3e_n`3PCo00Z`3_oo/0j`on2P
1?l02>2Poj3PX>3o0U04o`9@0_l2D003o`00014000Co003o1@000ol00002o`;O1?l01=ooool3g`03
oimO00Co00>Oool00_l01EnOooAn00Co00Odoooom7ko009<1?l2C0?o0T`00ol3eP04o`0:0oooo`?F
0ol>/0Co00T>/?oo3[0>oj001?l02>2Poj3PX>3o0U04o`9@0_l3D003o`0000T0000:0007o`00o`3o
0003o`<00ol3g`04omoOo`CO01ooGomOWeooGiooWenOGomaog5nLOmaOW5nogiaodco00=<00GoC4a<
o`03C0;o03D33`?o0`l33ol?0ooaoo4>lOoaoo4>o`kaoj3oX>2Poj3Pon2Ph:3oT?n@D93oT?n@D?m@
o`0C0005o`3o0?l00P03o`800_l00moog`02g`04omoOo`CO01koWonOGiooWeooGimOWomnogiaO_mn
LGiaog7oC?l3C005oda<C?l00d`07?l?o`l33ol?0`l3o`<?o`ko3_4>o`ko3_7ol@h2o`0JX>2Poj3P
on2Ph:3oT?n@D93oT?n@D?m@T?l;00002P001Ol0ool000Co1003o`?O00Cogmoo1=l07omOoenOGomO
WeooGimOogkoO_AnogkdO_Com7koC?l00d`00om<o`03o`9<0_l0:]H3e_oF0mH3o`?Fok3o/0j`ok3o
/0ko3[3oh?oPX>3oh:3Pon2Ph?m@o`=@00?oD?l00U000om@o`0C00?o00@0ool00_l300;o00?Ooml0
0]l01?oOgol4g`0NoiooWenOoimOWonOGioom?odO_Com7kdO_mnodco0d`00om<o`03o`9<01co0ol3
eP?o0mH3e_oF0ol>o`j`3_l>o`j`ok0>0_l03^2Ph?oPX>3oh:3Poe3o0e000om@o`02D004oe1@o`/0
000:0003o`0000<000Co003o0`03o`?O00Cogmoo1=l05omOoenOGomOWenOoimOog7oLGiaog5n00;o
00IaOW7oC?l3C005odcoC?l00d`2o`050`l3o`<00ol02`<?0ooaoo4>lOoa00?o01[a3_7oX?nPh:3o
X>2Poj3PX?n@oi1@T?n@D0;o00>@D?l04`000ol000030004o`00o`800_l00moog`02g`04omoOo`CO
01OoWonOGiooWenOGomOWomnogiaO_mnL@02o`05OW7oC?l00d`01Om<odco00=<00So3ol?0`oo3`?o
00/?0`oo3_l>l@ko3P03o`033_4>00;o01BPh:3oX>2Poj3PX?n@oi1@T?n@D0;o00B@D93o2`0000X0
00?o00000P001Ol0003o00<00_l00mooo`03o`03gooO00?O00?oGil01_l025nOoimOogkd1Ol01oAn
m?odO_l00T`6o`03C?m<009<00?o0ol01Ol02=H3eP?Fok0>1_l02;0>/0j`on2P1Ol01j3PX?nPh?l0
0U06o`9@00?oD?l04`000ol000020005o`000?l00P02o`;O1Ol00moog`03g`03oimO00Ko00ROGomO
WoodOPGo00Inm7koO_l2C0Ko00=<od`00T`00ol3eP06o`080mH3eP?o3[06o`073[0>/0koX005o`07
X>2Poj3Po`02D0Ko0U001?m@D?l;00002P001Ol0003o00<000?o0?l00P02o`KO0_l4g`09oenOGimO
WenO00;o00]OWeooLGiaOW5nL@03o`04LGiao`Q<0_l3C007o`l33`<?0`04o`0;3`?ol@ka3_4>l@h0
0ol02Pkaoj3PX>2Ph:04o`0;h:3oT52@D91@T5000_l00i1@o`0C0005o`000?l00`001?l0o`02o`OO
0_l4g`09oimOWenOGimO00;o00^OGiooOW5nLGiaOP03o`03OW7o00Q<0_l3C008o`l33`<?0`l4o`0;
0`oo3_4>l@ka3_400ol02O4>on2Ph:3PX004o`0;h:3oT52@D91@T5000_l0191@T?l;00002P001?l0
0?l40003o`3o00800_l<g`0MoenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_l03D`0:_l3eP?F0mH3
eP?F0mKo/0j`3[0>/0j`3[0>/?oPX>2Ph:3PX>2Ph:3Po`a@00?o00004@001?l00?l40004o`3o00;o
3Ml07?nOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_l=C00Zo`?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>
/0j`3_nPh:3PX>2Ph:3PX>3o3E000ol0000900002P000ol0o`0400;o00@0ool00_l<g`0MoenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLOl03D`0=ol?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>lOnPh:3P
X>2Ph:3PX>2Poi1@T52@D91@T52@D?l04`000ol0o`0400;o00<0ool00_l=g`0LoimOWenOGimOWenO
GiooOW5nLGiaOW5nLGiao`e<03So3`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>on2Ph:3PX>2Ph:3P
X?n@D91@T52@D91@T52@o`/0000:00;o2`02o`cO01goGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
o`0=C00Zo`?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`on2Ph:3PX>2Ph:3PX>3o35000ol0000A00;o
2P02o`gO01coWenOGimOWenOGimOWoodO_Anm7kdO_Anm7ko3D`0:_l3eP?F0mH3eP?F0mH3o`j`3[0>
/0j`3[0>/0koX>2Ph:3PX>2Ph:3Po`e@00?o00002@0000X0O?lC07co2`0001L00_n<00;oN@000?l0
8@0007d00olg00CoD@03oa40001n0003o`0003L000?o0000DP000ol0000@00002P02o`030?oo00<0
1Ol00`3oo`08o`800ol200Go0P03o`800_l00`3oo`0[00;o00<0ool02P000ol000080003o`0001P0
00Ko0000o`05o`030?oo00?o0P03o`801Ol00`3oo`02o`801Ol00`3oo`03o`800ol200Go0P03o`80
1Ol200?o0P02o`030?oo00L00_l00`3oo`090003o`3o00T000?o00003`0000/000?o0?l00`001ol0
003o0?l00`001Ol0003o00@000Co003o0`001Ol0003o00<000?o0?l00P000ol0000[0003o`3o00/0
00?o000020000ol0000H0007o`000?l0o`020003o`00008000?o00000P001?l00?l30005o`000?l0
0`001Ol0003o00D000Go0000o`030003o`3o008000Go0000o`020005o`000?l00`001ol0003o0?l0
0P000ol000070003o`3o00/000?o000020000ol0000?00002`03o`<000Oo0000o`3o00<000Go0000
o`040003o`0000@000Go0000o`030003o`3o008000?o0000;0000ol0000800Go1`000ol0o`0I0007
o`3o0?l0o`020003o`00008000?o00000P000ol000040005o`000?l00`001Ol0003o00D000Go0000
o`0500Co0`000ol000040005o`000?l00`000ol0o`020003o`0000P000?o00002005o`L000?o0?l0
400000/000?o0?l00`001ol0003o0?l00`001Ol0003o00@000?o000010001Ol0003o00<000?o0?l0
0P000ol0000[0003o`3o00/000?o00001`000ol0o`0I0007o`3o0?l0o`020003o`00008000?o0000
0P000ol000040005o`000?l00`001Ol0003o00D000Go0000o`030003o`00008000Go0000o`060005
o`000?l00`000ol0o`020003o`0000L000?o0?l02`000ol000070003o`3o0100000<0003o`0000<0
1?l200Co0P02o`<01?l300;o1003o`030?oo00?o;002o`030?oo00X000?o00001P02o`030?oo01P0
0_l00`3oo`02o`030?oo00@000Co00001?l300;o0P05o`@000?o00000P02o`@01?l200?o0P04o`<0
0_l400?o00<0ool00ol800;o00<0ool04`02o`030?oo00l0000;00;o20000ol000030003o`0000H0
00?o0000LP02o`<00_l80003o`00008000?o000040000ol0000D0003o`0004H0000D00;o1002o`<0
00?o00000P000ol000040003o`0007P00ol40003o`0000@000?o00001`03o`D000?o00003P000ol0
00040003o`0003l0003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {143.75, 0}} -> {-0.0537398, -0.0251377, 
  0.00734314, 0.00734314}, {{7.3125, 137}, {140.312, 
  3.375}} -> {-1.7579, -0.489659, 0.0728683, 0.0728683}, {{149.938, 
  279.625}, {140.312, 3.375}} -> {-12.1507, -0.489659, 0.0728683, 
  0.0728683}},
  CellTags->"OtherRings"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"Working",
WindowSize->{500, 400},
WindowMargins->{{8, Automatic}, {Automatic, 3}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0002@090000001NP4P?nhom`5j0BT0B<5:0?l007m002@090000001NP4P02@
0204P1J0033n0@41000002L?00410@00000000000000000000000@0000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "i:1"->{
    Cell[2564, 83, 248, 11, 100, "Section",
      Evaluatable->False,
      CellTags->"i:1"]},
  "First"->{
    Cell[2815, 96, 60, 1, 68, "Subsection",
      CellTags->"First"],
    Cell[2878, 99, 178, 5, 59, "Text",
      CellTags->"First"],
    Cell[3059, 106, 146, 4, 39, "Input",
      CellTags->"First"],
    Cell[3208, 112, 152, 5, 43, "Text",
      CellTags->"First"],
    Cell[3385, 121, 101, 3, 39, "Input",
      CellTags->"First"],
    Cell[3489, 126, 83, 3, 38, "Output",
      CellTags->"First"]},
  "i:2"->{
    Cell[3587, 132, 167, 7, 68, "Subsection",
      Evaluatable->False,
      CellTags->"i:2"]},
  "FormRingoid"->{
    Cell[3757, 141, 306, 9, 77, "Text",
      CellTags->"FormRingoid"],
    Cell[4066, 152, 137, 5, 60, "Subsubsection",
      CellTags->{"FormRingoid", "i:3"}],
    Cell[4206, 159, 14336, 402, 218, "DefinitionBox",
      CellTags->"FormRingoid"],
    Cell[18545, 563, 143, 6, 26, "Caption",
      CellTags->"FormRingoid"],
    Cell[18691, 571, 661, 14, 125, "Text",
      CellTags->"FormRingoid"],
    Cell[19355, 587, 219, 4, 58, "Text",
      CellTags->"FormRingoid"],
    Cell[19577, 593, 97, 1, 40, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[19699, 598, 227, 5, 71, "Input",
      CellTags->"FormRingoid"],
    Cell[19929, 605, 208, 4, 53, "Output",
      CellTags->"FormRingoid"],
    Cell[20152, 612, 11290, 318, 432, "DefinitionBox3Col",
      CellTags->{"FormRingoid", "i:4"}],
    Cell[31445, 932, 135, 6, 26, "Caption",
      CellTags->"FormRingoid"],
    Cell[31583, 940, 380, 8, 92, "Text",
      CellTags->"FormRingoid"],
    Cell[31966, 950, 69, 1, 40, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[32060, 955, 200, 5, 71, "Input",
      CellTags->"FormRingoid"],
    Cell[32263, 962, 142, 3, 38, "Output",
      CellTags->"FormRingoid"],
    Cell[32420, 968, 162, 5, 41, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[32607, 977, 106, 3, 39, "Input",
      CellTags->"FormRingoid"],
    Cell[32716, 982, 123, 3, 38, "Output",
      CellTags->"FormRingoid"],
    Cell[32854, 988, 146, 4, 54, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[33025, 996, 169, 4, 55, "Input",
      CellTags->"FormRingoid"],
    Cell[33197, 1002, 142, 3, 38, "Output",
      CellTags->"FormRingoid"],
    Cell[33354, 1008, 200, 5, 54, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[33579, 1017, 277, 6, 71, "Input",
      CellTags->"FormRingoid"],
    Cell[33859, 1025, 145, 4, 38, "Output",
      CellTags->"FormRingoid"],
    Cell[34019, 1032, 100, 1, 40, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[34144, 1037, 127, 3, 39, "Input",
      CellTags->"FormRingoid"],
    Cell[34274, 1042, 43321, 922, 175, 8030, 480, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormRingoid"],
    Cell[77610, 1967, 203, 6, 55, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[77838, 1977, 275, 7, 106, "Input",
      CellTags->"FormRingoid"],
    Cell[78116, 1986, 151, 4, 38, "Output",
      CellTags->"FormRingoid"],
    Cell[78282, 1993, 160, 5, 41, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[78467, 2002, 132, 3, 39, "Input",
      CellTags->"FormRingoid"],
    Cell[78602, 2007, 66319, 1975, 175, 32886, 1556, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormRingoid"],
    Cell[144936, 3985, 175, 6, 41, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[145136, 3995, 271, 7, 106, "Input",
      CellTags->"FormRingoid"],
    Cell[145410, 4004, 152, 4, 38, "Output",
      CellTags->"FormRingoid"],
    Cell[145577, 4011, 144, 5, 41, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[145746, 4020, 133, 3, 39, "Input",
      CellTags->"FormRingoid"],
    Cell[145882, 4025, 42373, 927, 175, 8838, 506, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormRingoid"],
    Cell[188270, 4955, 384, 13, 71, "MathCaption",
      CellTags->"FormRingoid"],
    Cell[188679, 4972, 182, 4, 55, "Input",
      CellTags->"FormRingoid"],
    Cell[188864, 4978, 66319, 1975, 175, 32886, 1556, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"FormRingoid"]},
  "i:3"->{
    Cell[4066, 152, 137, 5, 60, "Subsubsection",
      CellTags->{"FormRingoid", "i:3"}]},
  "i:4"->{
    Cell[20152, 612, 11290, 318, 432, "DefinitionBox3Col",
      CellTags->{"FormRingoid", "i:4"}]},
  "FormRingoidByT"->{
    Cell[255198, 6956, 138, 5, 60, "Subsubsection",
      CellTags->"FormRingoidByT"],
    Cell[255339, 6963, 160, 5, 43, "Text",
      CellTags->"FormRingoidByT"],
    Cell[255502, 6970, 704, 27, 48, "TopSpanBox",
      CellTags->{"FormRingoidByT", "i:5"}],
    Cell[256209, 6999, 1993, 51, 61, "MiddleBox",
      CellTags->"FormRingoidByT"],
    Cell[258205, 7052, 1177, 45, 31, "MiddleSpanBox",
      CellTags->"FormRingoidByT"],
    Cell[259385, 7099, 3172, 83, 62, "BottomBox",
      CellTags->"FormRingoidByT"],
    Cell[262560, 7184, 153, 6, 26, "Caption",
      CellTags->"FormRingoidByT"],
    Cell[262716, 7192, 101, 1, 40, "MathCaption",
      CellTags->"FormRingoidByT"],
    Cell[262842, 7197, 239, 5, 103, "Input",
      CellTags->"FormRingoidByT"],
    Cell[263084, 7204, 518, 11, 54, "Output",
      CellTags->"FormRingoidByT"],
    Cell[263617, 7218, 230, 7, 56, "MathCaption",
      CellTags->"FormRingoidByT"],
    Cell[263872, 7229, 282, 6, 71, "Input",
      CellTags->"FormRingoidByT"],
    Cell[264157, 7237, 670, 13, 143, "Output",
      CellTags->"FormRingoidByT"]},
  "i:5"->{
    Cell[255502, 6970, 704, 27, 48, "TopSpanBox",
      CellTags->{"FormRingoidByT", "i:5"}]},
  "i:6"->{
    Cell[264842, 7253, 125, 5, 68, "Subsection",
      CellTags->"i:6"]},
  "BasicRingoid"->{
    Cell[264970, 7260, 74, 1, 60, "Subsubsection",
      CellTags->"BasicRingoid"],
    Cell[265047, 7263, 667, 19, 110, "Text",
      CellTags->"BasicRingoid"],
    Cell[265717, 7284, 3536, 109, 121, "DefinitionBox",
      CellTags->{"BasicRingoid", "i:7"}],
    Cell[269256, 7395, 101, 1, 26, "Caption",
      CellTags->"BasicRingoid"],
    Cell[269360, 7398, 219, 8, 41, "MathCaption",
      CellTags->"BasicRingoid"],
    Cell[269604, 7410, 91, 3, 39, "Input",
      CellTags->"BasicRingoid"],
    Cell[269698, 7415, 148, 4, 38, "Output",
      CellTags->"BasicRingoid"],
    Cell[269861, 7422, 88, 1, 40, "MathCaption",
      CellTags->"BasicRingoid"],
    Cell[269974, 7427, 99, 3, 39, "Input",
      CellTags->"BasicRingoid"],
    Cell[270076, 7432, 102, 3, 38, "Output",
      CellTags->"BasicRingoid"],
    Cell[270193, 7438, 126, 4, 40, "MathCaption",
      CellTags->"BasicRingoid"],
    Cell[270344, 7446, 128, 3, 39, "Input",
      CellTags->"BasicRingoid"],
    Cell[270475, 7451, 122, 3, 38, "Output",
      CellTags->"BasicRingoid"],
    Cell[270612, 7457, 208, 7, 59, "Text",
      CellTags->"BasicRingoid"]},
  "i:7"->{
    Cell[265717, 7284, 3536, 109, 121, "DefinitionBox",
      CellTags->{"BasicRingoid", "i:7"}]},
  "RelatedRingoid"->{
    Cell[270823, 7466, 78, 1, 60, "Subsubsection",
      CellTags->"RelatedRingoid"],
    Cell[270904, 7469, 5625, 173, 170, "DefinitionBox",
      CellTags->{"RelatedRingoid", "i:8"}],
    Cell[276532, 7644, 97, 1, 26, "Caption",
      CellTags->"RelatedRingoid"],
    Cell[276632, 7647, 192, 6, 55, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[276849, 7657, 328, 8, 103, "Input",
      CellTags->"RelatedRingoid"],
    Cell[277180, 7667, 144, 3, 38, "Output",
      CellTags->"RelatedRingoid"],
    Cell[277339, 7673, 157, 4, 54, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[277521, 7681, 137, 3, 39, "Input",
      CellTags->"RelatedRingoid"],
    Cell[277661, 7686, 110, 3, 38, "Output",
      CellTags->"RelatedRingoid"],
    Cell[277786, 7692, 197, 7, 55, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[278008, 7703, 128, 3, 39, "Input",
      CellTags->"RelatedRingoid"],
    Cell[278139, 7708, 102, 3, 38, "Output",
      CellTags->"RelatedRingoid"],
    Cell[278256, 7714, 269, 4, 68, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[278550, 7722, 99, 3, 39, "Input",
      CellTags->"RelatedRingoid"],
    Cell[278652, 7727, 143, 3, 38, "Output",
      CellTags->"RelatedRingoid"],
    Cell[278810, 7733, 203, 6, 55, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[279038, 7743, 122, 3, 39, "Input",
      CellTags->"RelatedRingoid"],
    Cell[279163, 7748, 409, 9, 128, "Output",
      CellTags->"RelatedRingoid"],
    Cell[279587, 7760, 275, 5, 54, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[279887, 7769, 261, 6, 71, "Input",
      CellTags->"RelatedRingoid"],
    Cell[280151, 7777, 37767, 662, 308, 4246, 242, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"RelatedRingoid"],
    Cell[317933, 8442, 149, 4, 42, "Text",
      CellTags->{"RelatedRingoid", "i:9"}],
    Cell[318085, 8448, 2179, 66, 98, "DefinitionBox",
      CellTags->{"RelatedRingoid", "i:10"}],
    Cell[320267, 8516, 74, 1, 26, "Caption",
      CellTags->"RelatedRingoid"],
    Cell[320344, 8519, 253, 6, 54, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[320622, 8529, 155, 4, 55, "Input",
      CellTags->"RelatedRingoid"],
    Cell[320780, 8535, 153, 4, 53, "Output",
      CellTags->"RelatedRingoid"],
    Cell[320948, 8542, 205, 5, 54, "MathCaption",
      CellTags->"RelatedRingoid"],
    Cell[321178, 8551, 190, 4, 55, "Input",
      CellTags->"RelatedRingoid"],
    Cell[321371, 8557, 117, 3, 38, "Output",
      CellTags->"RelatedRingoid"],
    Cell[321503, 8563, 7853, 225, 190, "DefinitionBox3Col",
      CellTags->{"RelatedRingoid", "i:11"}],
    Cell[329359, 8790, 88, 1, 26, "Caption",
      CellTags->"RelatedRingoid"]},
  "i:8"->{
    Cell[270904, 7469, 5625, 173, 170, "DefinitionBox",
      CellTags->{"RelatedRingoid", "i:8"}]},
  "i:9"->{
    Cell[317933, 8442, 149, 4, 42, "Text",
      CellTags->{"RelatedRingoid", "i:9"}]},
  "i:10"->{
    Cell[318085, 8448, 2179, 66, 98, "DefinitionBox",
      CellTags->{"RelatedRingoid", "i:10"}]},
  "i:11"->{
    Cell[321503, 8563, 7853, 225, 190, "DefinitionBox3Col",
      CellTags->{"RelatedRingoid", "i:11"}]},
  "GroupoidsFromR"->{
    Cell[329450, 8793, 94, 1, 60, "Subsubsection",
      CellTags->{"GroupoidsFromR", "i:12"}],
    Cell[329547, 8796, 412, 8, 90, "Text",
      CellTags->"GroupoidsFromR"],
    Cell[329962, 8806, 7857, 227, 170, "DefinitionBox",
      CellTags->{"GroupoidsFromR", "i:13"}],
    Cell[337822, 9035, 85, 1, 26, "Caption",
      CellTags->"GroupoidsFromR"],
    Cell[337910, 9038, 288, 9, 40, "MathCaption",
      CellTags->"GroupoidsFromR"],
    Cell[338223, 9051, 112, 3, 39, "Input",
      CellTags->"GroupoidsFromR"],
    Cell[338338, 9056, 155, 4, 53, "Output",
      CellTags->"GroupoidsFromR"],
    Cell[338508, 9063, 105, 1, 40, "MathCaption",
      CellTags->"GroupoidsFromR"],
    Cell[338638, 9068, 162, 4, 55, "Input",
      CellTags->"GroupoidsFromR"],
    Cell[338803, 9074, 101, 3, 38, "Output",
      CellTags->"GroupoidsFromR"],
    Cell[338919, 9080, 108, 1, 40, "MathCaption",
      CellTags->"GroupoidsFromR"],
    Cell[339052, 9085, 124, 3, 39, "Input",
      CellTags->"GroupoidsFromR"],
    Cell[339179, 9090, 94, 3, 38, "Output",
      CellTags->"GroupoidsFromR"],
    Cell[339288, 9096, 137, 4, 40, "MathCaption",
      CellTags->"GroupoidsFromR"],
    Cell[339450, 9104, 127, 3, 39, "Input",
      CellTags->"GroupoidsFromR"],
    Cell[339580, 9109, 142, 3, 38, "Output",
      CellTags->"GroupoidsFromR"]},
  "i:12"->{
    Cell[329450, 8793, 94, 1, 60, "Subsubsection",
      CellTags->{"GroupoidsFromR", "i:12"}]},
  "i:13"->{
    Cell[329962, 8806, 7857, 227, 170, "DefinitionBox",
      CellTags->{"GroupoidsFromR", "i:13"}]},
  "i:14"->{
    Cell[339737, 9115, 74, 1, 68, "Subsection",
      CellTags->"i:14"]},
  "AdditiveP"->{
    Cell[339814, 9118, 85, 1, 60, "Subsubsection",
      CellTags->{"AdditiveP", "i:15"}],
    Cell[339902, 9121, 330, 6, 90, "Text",
      CellTags->"AdditiveP"],
    Cell[340235, 9129, 9702, 290, 247, "DefinitionBox",
      CellTags->{"AdditiveP", "i:16"}],
    Cell[349940, 9421, 100, 1, 26, "Caption",
      CellTags->"AdditiveP"],
    Cell[350043, 9424, 313, 9, 56, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[350381, 9437, 339, 6, 103, "Input",
      CellTags->"AdditiveP"],
    Cell[350723, 9445, 114, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[350852, 9451, 266, 8, 55, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[351143, 9463, 153, 4, 55, "Input",
      CellTags->"AdditiveP"],
    Cell[351321, 9471, 15693, 284, 164, 1886, 108, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[367017, 9757, 10168, 194, 164, 1358, 79, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[377188, 9953, 10156, 194, 164, 1354, 79, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[387347, 10149, 5868, 117, 164, 865, 49, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[393218, 10268, 8099, 145, 164, 962, 51, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[401332, 10416, 88, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[401435, 10422, 170, 5, 55, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[401630, 10431, 153, 4, 55, "Input",
      CellTags->"AdditiveP"],
    Cell[401786, 10437, 34551, 706, 308, 5925, 347, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[436340, 11145, 88, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[436443, 11151, 14008, 394, 247, "DefinitionBox",
      CellTags->{"AdditiveP", "i:17"}],
    Cell[450454, 11547, 118, 4, 26, "Caption",
      CellTags->"AdditiveP"],
    Cell[450597, 11555, 177, 4, 55, "Input",
      CellTags->"AdditiveP"],
    Cell[450777, 11561, 124, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[450916, 11567, 173, 6, 40, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[451114, 11577, 114, 3, 39, "Input",
      CellTags->"AdditiveP"],
    Cell[451231, 11582, 35961, 825, 180, 9549, 493, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"AdditiveP"],
    Cell[487195, 12409, 85, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[487295, 12415, 195, 6, 40, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[487515, 12425, 106, 3, 39, "Input",
      CellTags->"AdditiveP"],
    Cell[487624, 12430, 88, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[487727, 12436, 188, 6, 40, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[487940, 12446, 124, 3, 39, "Input",
      CellTags->"AdditiveP"],
    Cell[488067, 12451, 222, 4, 79, "Print",
      CellTags->"AdditiveP"],
    Cell[488292, 12457, 99, 2, 49, "Print",
      CellTags->"AdditiveP"],
    Cell[488394, 12461, 85, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[488494, 12467, 310, 11, 60, "Text",
      CellTags->"AdditiveP"],
    Cell[488807, 12480, 153, 5, 41, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[488985, 12489, 136, 3, 39, "Input",
      CellTags->"AdditiveP"],
    Cell[489124, 12494, 88, 3, 38, "Output",
      CellTags->"AdditiveP"],
    Cell[489227, 12500, 3639, 98, 157, "DefinitionBox3Col",
      CellTags->{"AdditiveP", "i:18"}],
    Cell[492869, 12600, 92, 1, 26, "Caption",
      CellTags->"AdditiveP"],
    Cell[492964, 12603, 369, 8, 84, "MathCaption",
      CellTags->"AdditiveP"],
    Cell[493358, 12615, 310, 6, 87, "Input",
      CellTags->"AdditiveP"],
    Cell[493671, 12623, 111, 3, 38, "Output",
      CellTags->"AdditiveP"]},
  "i:15"->{
    Cell[339814, 9118, 85, 1, 60, "Subsubsection",
      CellTags->{"AdditiveP", "i:15"}]},
  "i:16"->{
    Cell[340235, 9129, 9702, 290, 247, "DefinitionBox",
      CellTags->{"AdditiveP", "i:16"}]},
  "i:17"->{
    Cell[436443, 11151, 14008, 394, 247, "DefinitionBox",
      CellTags->{"AdditiveP", "i:17"}]},
  "i:18"->{
    Cell[489227, 12500, 3639, 98, 157, "DefinitionBox3Col",
      CellTags->{"AdditiveP", "i:18"}]},
  "MultiplicativeP"->{
    Cell[493797, 12629, 97, 1, 60, "Subsubsection",
      CellTags->{"MultiplicativeP", "i:19"}],
    Cell[493897, 12632, 241, 5, 58, "Text",
      CellTags->"MultiplicativeP"],
    Cell[494141, 12639, 3573, 106, 111, "DefinitionBox",
      CellTags->{"MultiplicativeP", "i:20"}],
    Cell[497717, 12747, 108, 1, 26, "Caption",
      CellTags->"MultiplicativeP"],
    Cell[497828, 12750, 16768, 491, 370, "DefinitionBox",
      CellTags->{"MultiplicativeP", "i:21"}],
    Cell[514599, 13243, 102, 1, 26, "Caption",
      CellTags->"MultiplicativeP"],
    Cell[514704, 13246, 264, 7, 58, "Text",
      CellTags->"MultiplicativeP"],
    Cell[514971, 13255, 69, 1, 40, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[515065, 13260, 122, 3, 39, "Input",
      CellTags->"MultiplicativeP"],
    Cell[515190, 13265, 99, 3, 38, "Output",
      CellTags->"MultiplicativeP"],
    Cell[515304, 13271, 236, 6, 54, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[515565, 13281, 145, 3, 55, "Input",
      CellTags->"MultiplicativeP"],
    Cell[515713, 13286, 167, 4, 53, "Output",
      CellTags->"MultiplicativeP"],
    Cell[515895, 13293, 215, 5, 54, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[516135, 13302, 178, 4, 55, "Input",
      CellTags->"MultiplicativeP"],
    Cell[516316, 13308, 25899, 754, 308, 12547, 583, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"MultiplicativeP"],
    Cell[542218, 14064, 296, 5, 83, "Output",
      CellTags->"MultiplicativeP"],
    Cell[542529, 14072, 266, 7, 54, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[542820, 14083, 194, 4, 55, "Input",
      CellTags->"MultiplicativeP"],
    Cell[543017, 14089, 623, 9, 184, "Print",
      CellTags->"MultiplicativeP"],
    Cell[543643, 14100, 117463, 3669, 308, 41556, 2726, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"MultiplicativeP"],
    Cell[661109, 17771, 95, 3, 38, "Output",
      CellTags->"MultiplicativeP"],
    Cell[661219, 17777, 126, 4, 40, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[661370, 17785, 125, 3, 39, "Input",
      CellTags->"MultiplicativeP"],
    Cell[661498, 17790, 36400, 830, 180, 9541, 493, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"MultiplicativeP"],
    Cell[697901, 18622, 91, 3, 38, "Output",
      CellTags->"MultiplicativeP"],
    Cell[698007, 18628, 2619, 84, 102, "DefinitionBox",
      CellTags->{"MultiplicativeP", "i:22"}],
    Cell[700629, 18714, 124, 4, 26, "Caption",
      CellTags->"MultiplicativeP"],
    Cell[700756, 18720, 205, 6, 40, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[700986, 18730, 130, 3, 39, "Input",
      CellTags->"MultiplicativeP"],
    Cell[701119, 18735, 110, 3, 38, "Output",
      CellTags->"MultiplicativeP"],
    Cell[701244, 18741, 145, 4, 54, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[701414, 18749, 137, 3, 39, "Input",
      CellTags->"MultiplicativeP"],
    Cell[701554, 18754, 1116, 22, 112, "Print",
      CellTags->"MultiplicativeP"],
    Cell[702673, 18778, 110, 3, 38, "Output",
      CellTags->"MultiplicativeP"],
    Cell[702798, 18784, 90, 1, 40, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[702913, 18789, 107, 3, 39, "Input",
      CellTags->"MultiplicativeP"],
    Cell[703023, 18794, 117, 3, 38, "Output",
      CellTags->"MultiplicativeP"],
    Cell[703155, 18800, 235, 5, 68, "MathCaption",
      CellTags->"MultiplicativeP"],
    Cell[703415, 18809, 133, 3, 39, "Input",
      CellTags->"MultiplicativeP"],
    Cell[703551, 18814, 94, 3, 38, "Output",
      CellTags->"MultiplicativeP"]},
  "i:19"->{
    Cell[493797, 12629, 97, 1, 60, "Subsubsection",
      CellTags->{"MultiplicativeP", "i:19"}]},
  "i:20"->{
    Cell[494141, 12639, 3573, 106, 111, "DefinitionBox",
      CellTags->{"MultiplicativeP", "i:20"}]},
  "i:21"->{
    Cell[497828, 12750, 16768, 491, 370, "DefinitionBox",
      CellTags->{"MultiplicativeP", "i:21"}]},
  "i:22"->{
    Cell[698007, 18628, 2619, 84, 102, "DefinitionBox",
      CellTags->{"MultiplicativeP", "i:22"}]},
  "DistributiveP"->{
    Cell[703660, 18820, 91, 1, 60, "Subsubsection",
      CellTags->{"DistributiveP", "i:23"}],
    Cell[703754, 18823, 734, 19, 124, "Text",
      CellTags->"DistributiveP"],
    Cell[704491, 18844, 13096, 352, 252, "DefinitionBox",
      CellTags->{"DistributiveP", "i:24"}],
    Cell[717590, 19198, 85, 1, 26, "Caption",
      CellTags->"DistributiveP"],
    Cell[717678, 19201, 181, 6, 40, "MathCaption",
      CellTags->"DistributiveP"],
    Cell[717884, 19211, 107, 3, 39, "Input",
      CellTags->"DistributiveP"],
    Cell[717994, 19216, 92, 3, 38, "Output",
      CellTags->"DistributiveP"],
    Cell[718101, 19222, 444, 16, 60, "Text",
      CellTags->"DistributiveP"],
    Cell[718548, 19240, 169, 4, 54, "MathCaption",
      CellTags->"DistributiveP"],
    Cell[718742, 19248, 118, 3, 39, "Input",
      CellTags->"DistributiveP"],
    Cell[718863, 19253, 92, 3, 38, "Output",
      CellTags->"DistributiveP"]},
  "i:23"->{
    Cell[703660, 18820, 91, 1, 60, "Subsubsection",
      CellTags->{"DistributiveP", "i:23"}]},
  "i:24"->{
    Cell[704491, 18844, 13096, 352, 252, "DefinitionBox",
      CellTags->{"DistributiveP", "i:24"}]},
  "RingQ"->{
    Cell[718970, 19259, 127, 6, 60, "Subsubsection",
      CellTags->"RingQ"],
    Cell[719100, 19267, 390, 10, 93, "Text",
      CellTags->"RingQ"],
    Cell[719493, 19279, 5001, 146, 130, "DefinitionBox",
      CellTags->{"RingQ", "i:25"}],
    Cell[724497, 19427, 97, 1, 26, "Caption",
      CellTags->"RingQ"],
    Cell[724597, 19430, 182, 6, 40, "MathCaption",
      CellTags->"RingQ"],
    Cell[724804, 19440, 90, 3, 39, "Input",
      CellTags->"RingQ"],
    Cell[724897, 19445, 84, 3, 38, "Output",
      CellTags->"RingQ"],
    Cell[724996, 19451, 169, 6, 41, "MathCaption",
      CellTags->"RingQ"],
    Cell[725190, 19461, 108, 3, 39, "Input",
      CellTags->"RingQ"],
    Cell[725301, 19466, 84, 3, 38, "Output",
      CellTags->"RingQ"],
    Cell[725400, 19472, 122, 3, 40, "MathCaption",
      CellTags->"RingQ"],
    Cell[725547, 19479, 103, 3, 39, "Input",
      CellTags->"RingQ"],
    Cell[725653, 19484, 581, 12, 188, "Output",
      CellTags->"RingQ"]},
  "i:25"->{
    Cell[719493, 19279, 5001, 146, 130, "DefinitionBox",
      CellTags->{"RingQ", "i:25"}]},
  "SpecializedRings"->{
    Cell[726249, 19499, 80, 1, 60, "Subsubsection",
      CellTags->"SpecializedRings"],
    Cell[726332, 19502, 1929, 58, 83, "DefinitionBox",
      CellTags->{"SpecializedRings", "i:26"}],
    Cell[728264, 19562, 104, 1, 26, "Caption",
      CellTags->"SpecializedRings"],
    Cell[728371, 19565, 250, 9, 40, "MathCaption",
      CellTags->"SpecializedRings"],
    Cell[728646, 19578, 126, 3, 39, "Input",
      CellTags->"SpecializedRings"],
    Cell[728775, 19583, 181, 4, 53, "Output",
      CellTags->"SpecializedRings"],
    Cell[728971, 19590, 294, 9, 54, "MathCaption",
      CellTags->"SpecializedRings"],
    Cell[729290, 19603, 142, 3, 43, "Input",
      CellTags->"SpecializedRings"],
    Cell[729435, 19608, 95, 3, 38, "Output",
      CellTags->"SpecializedRings"]},
  "i:26"->{
    Cell[726332, 19502, 1929, 58, 83, "DefinitionBox",
      CellTags->{"SpecializedRings", "i:26"}]},
  "Closure"->{
    Cell[729545, 19614, 82, 1, 60, "Subsubsection",
      CellTags->{"Closure", "i:27"}],
    Cell[729630, 19617, 272, 6, 75, "Text",
      CellTags->"Closure"],
    Cell[729905, 19625, 12149, 349, 200, "DefinitionBox",
      CellTags->{"Closure", "i:28"}],
    Cell[742057, 19976, 78, 1, 26, "Caption",
      CellTags->"Closure"],
    Cell[742138, 19979, 143, 4, 58, "Text",
      CellTags->"Closure"],
    Cell[742284, 19985, 126, 4, 40, "MathCaption",
      CellTags->"Closure"],
    Cell[742435, 19993, 108, 3, 39, "Input",
      CellTags->"Closure"],
    Cell[742546, 19998, 87, 3, 38, "Output",
      CellTags->"Closure"],
    Cell[742648, 20004, 99, 1, 40, "MathCaption",
      CellTags->"Closure"],
    Cell[742772, 20009, 145, 4, 55, "Input",
      CellTags->"Closure"],
    Cell[742920, 20015, 86, 3, 38, "Output",
      CellTags->"Closure"],
    Cell[743021, 20021, 194, 6, 40, "MathCaption",
      CellTags->"Closure"],
    Cell[743240, 20031, 112, 3, 39, "Input",
      CellTags->"Closure"],
    Cell[743355, 20036, 86, 3, 38, "Output",
      CellTags->"Closure"],
    Cell[743456, 20042, 106, 2, 40, "MathCaption",
      CellTags->"Closure"],
    Cell[743587, 20048, 113, 3, 39, "Input",
      CellTags->"Closure"],
    Cell[743703, 20053, 86, 3, 38, "Output",
      CellTags->"Closure"],
    Cell[743804, 20059, 196, 6, 41, "MathCaption",
      CellTags->"Closure"],
    Cell[744025, 20069, 167, 4, 55, "Input",
      CellTags->"Closure"],
    Cell[744195, 20075, 29461, 662, 308, 6264, 370, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Closure"],
    Cell[773659, 20739, 87, 3, 38, "Output",
      CellTags->"Closure"],
    Cell[773761, 20745, 150, 5, 41, "MathCaption",
      CellTags->"Closure"],
    Cell[773936, 20754, 184, 4, 71, "Input",
      CellTags->"Closure"],
    Cell[774123, 20760, 94, 3, 38, "Output",
      CellTags->"Closure"]},
  "i:27"->{
    Cell[729545, 19614, 82, 1, 60, "Subsubsection",
      CellTags->{"Closure", "i:27"}]},
  "i:28"->{
    Cell[729905, 19625, 12149, 349, 200, "DefinitionBox",
      CellTags->{"Closure", "i:28"}]},
  "TestingOther"->{
    Cell[774232, 20766, 83, 1, 60, "Subsubsection",
      CellTags->"TestingOther"],
    Cell[774318, 20769, 764, 28, 92, "Text",
      CellTags->"TestingOther"],
    Cell[775085, 20799, 3127, 98, 88, "DefinitionBox",
      CellTags->{"TestingOther", "i:29"}],
    Cell[778215, 20899, 101, 1, 26, "Caption",
      CellTags->"TestingOther"],
    Cell[778319, 20902, 288, 10, 40, "MathCaption",
      CellTags->"TestingOther"],
    Cell[778632, 20916, 305, 7, 103, "Input",
      CellTags->"TestingOther"],
    Cell[778940, 20925, 587, 18, 176, "Output",
      CellTags->"TestingOther"],
    Cell[779542, 20946, 387, 14, 55, "MathCaption",
      CellTags->"TestingOther"],
    Cell[779954, 20964, 329, 8, 103, "Input",
      CellTags->"TestingOther"],
    Cell[780286, 20974, 169, 4, 51, "Message",
      CellTags->"TestingOther"],
    Cell[780458, 20980, 576, 17, 161, "Output",
      CellTags->"TestingOther"],
    Cell[781049, 21000, 367, 10, 68, "MathCaption",
      CellTags->"TestingOther"],
    Cell[781441, 21014, 175, 5, 55, "Input",
      CellTags->"TestingOther"],
    Cell[781619, 21021, 100, 3, 38, "Output",
      CellTags->"TestingOther"],
    Cell[781734, 21027, 10707, 299, 176, "DefinitionBox",
      CellTags->{"TestingOther", "i:30"}],
    Cell[792444, 21328, 95, 1, 26, "Caption",
      CellTags->"TestingOther"],
    Cell[792542, 21331, 204, 6, 40, "MathCaption",
      CellTags->"TestingOther"],
    Cell[792771, 21341, 135, 3, 39, "Input",
      CellTags->"TestingOther"],
    Cell[792909, 21346, 190, 4, 53, "Output",
      CellTags->"TestingOther"],
    Cell[793114, 21353, 98, 1, 40, "MathCaption",
      CellTags->"TestingOther"],
    Cell[793237, 21358, 113, 3, 39, "Input",
      CellTags->"TestingOther"],
    Cell[793353, 21363, 141, 3, 38, "Output",
      CellTags->"TestingOther"],
    Cell[793509, 21369, 276, 9, 42, "MathCaption",
      CellTags->"TestingOther"],
    Cell[793810, 21382, 106, 3, 39, "Input",
      CellTags->"TestingOther"],
    Cell[793919, 21387, 91, 3, 38, "Output",
      CellTags->"TestingOther"],
    Cell[794025, 21393, 175, 6, 40, "MathCaption",
      CellTags->"TestingOther"],
    Cell[794225, 21403, 103, 3, 39, "Input",
      CellTags->"TestingOther"],
    Cell[794331, 21408, 114, 3, 38, "Output",
      CellTags->"TestingOther"],
    Cell[794460, 21414, 215, 6, 40, "MathCaption",
      CellTags->"TestingOther"],
    Cell[794700, 21424, 205, 4, 71, "Input",
      CellTags->"TestingOther"],
    Cell[794908, 21430, 505, 13, 63, "Output",
      CellTags->"TestingOther"],
    Cell[795428, 21446, 103, 1, 40, "MathCaption",
      CellTags->"TestingOther"],
    Cell[795556, 21451, 118, 3, 39, "Input",
      CellTags->"TestingOther"],
    Cell[795677, 21456, 91, 3, 38, "Output",
      CellTags->"TestingOther"]},
  "i:29"->{
    Cell[775085, 20799, 3127, 98, 88, "DefinitionBox",
      CellTags->{"TestingOther", "i:29"}]},
  "i:30"->{
    Cell[781734, 21027, 10707, 299, 176, "DefinitionBox",
      CellTags->{"TestingOther", "i:30"}]},
  "i:31"->{
    Cell[795783, 21462, 122, 5, 68, "Subsection",
      CellTags->"i:31"]},
  "NumericRings"->{
    Cell[795908, 21469, 422, 12, 74, "Text",
      CellTags->"NumericRings"],
    Cell[796333, 21483, 72, 1, 60, "Subsubsection",
      CellTags->"NumericRings"],
    Cell[796408, 21486, 11875, 353, 272, "DefinitionBox",
      CellTags->{"NumericRings", "i:32"}],
    Cell[808286, 21841, 78, 1, 26, "Caption",
      CellTags->"NumericRings"],
    Cell[808367, 21844, 100, 1, 42, "Text",
      CellTags->"NumericRings"],
    Cell[808470, 21847, 314, 9, 70, "MathCaption",
      CellTags->"NumericRings"],
    Cell[808809, 21860, 91, 3, 39, "Input",
      CellTags->"NumericRings"],
    Cell[808903, 21865, 162, 4, 53, "Output",
      CellTags->"NumericRings"],
    Cell[809080, 21872, 193, 6, 40, "MathCaption",
      CellTags->"NumericRings"],
    Cell[809298, 21882, 124, 3, 39, "Input",
      CellTags->"NumericRings"],
    Cell[809425, 21887, 177, 4, 68, "Output",
      CellTags->"NumericRings"],
    Cell[809617, 21894, 155, 4, 54, "MathCaption",
      CellTags->"NumericRings"],
    Cell[809797, 21902, 147, 4, 39, "Input",
      CellTags->"NumericRings"],
    Cell[809947, 21908, 61357, 1846, 165, 22102, 1355, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"NumericRings"],
    Cell[871319, 23757, 128, 4, 40, "MathCaption",
      CellTags->"NumericRings"],
    Cell[871472, 23765, 114, 3, 39, "Input",
      CellTags->"NumericRings"],
    Cell[871589, 23770, 89, 3, 38, "Output",
      CellTags->"NumericRings"],
    Cell[871693, 23776, 104, 1, 40, "MathCaption",
      CellTags->"NumericRings"],
    Cell[871822, 23781, 105, 3, 39, "Input",
      CellTags->"NumericRings"],
    Cell[871930, 23786, 164, 4, 53, "Output",
      CellTags->"NumericRings"],
    Cell[872109, 23793, 176, 6, 40, "MathCaption",
      CellTags->"NumericRings"],
    Cell[872310, 23803, 118, 3, 39, "Input",
      CellTags->"NumericRings"],
    Cell[872431, 23808, 128, 3, 56, "Output",
      CellTags->"NumericRings"]},
  "i:32"->{
    Cell[796408, 21486, 11875, 353, 272, "DefinitionBox",
      CellTags->{"NumericRings", "i:32"}]},
  "OtherRings"->{
    Cell[872574, 23814, 68, 1, 60, "Subsubsection",
      CellTags->"OtherRings"],
    Cell[872645, 23817, 3302, 94, 96, "DefinitionBox",
      CellTags->{"OtherRings", "i:33"}],
    Cell[875950, 23913, 65, 1, 26, "Caption",
      CellTags->"OtherRings"],
    Cell[876018, 23916, 90, 1, 28, "MathCaption",
      CellTags->"OtherRings"],
    Cell[876133, 23921, 219, 5, 42, "Input",
      CellTags->"OtherRings"],
    Cell[876355, 23928, 431, 7, 50, "Print",
      CellTags->"OtherRings"],
    Cell[876789, 23937, 65134, 1906, 151, 22742, 1376, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"OtherRings"]},
  "i:33"->{
    Cell[872645, 23817, 3302, 94, 96, "DefinitionBox",
      CellTags->{"OtherRings", "i:33"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"i:1", 942824, 25870},
  {"First", 942932, 25874},
  {"i:2", 943346, 25887},
  {"FormRingoid", 943462, 25891},
  {"i:3", 946964, 25980},
  {"i:4", 947066, 25983},
  {"FormRingoidByT", 947189, 25986},
  {"i:5", 948292, 26013},
  {"i:6", 948398, 26016},
  {"BasicRingoid", 948492, 26019},
  {"i:7", 949630, 26048},
  {"RelatedRingoid", 949751, 26051},
  {"i:8", 952486, 26117},
  {"i:9", 952598, 26120},
  {"i:10", 952698, 26123},
  {"i:11", 952810, 26126},
  {"GroupoidsFromR", 952938, 26129},
  {"i:12", 954281, 26162},
  {"i:13", 954390, 26165},
  {"i:14", 954504, 26168},
  {"AdditiveP", 954595, 26171},
  {"i:15", 958408, 26267},
  {"i:16", 958512, 26270},
  {"i:17", 958621, 26273},
  {"i:18", 958732, 26276},
  {"MultiplicativeP", 958856, 26279},
  {"i:19", 962505, 26365},
  {"i:20", 962616, 26368},
  {"i:21", 962732, 26371},
  {"i:22", 962849, 26374},
  {"DistributiveP", 962973, 26377},
  {"i:23", 963909, 26400},
  {"i:24", 964018, 26403},
  {"RingQ", 964134, 26406},
  {"i:25", 965121, 26433},
  {"SpecializedRings", 965239, 26436},
  {"i:26", 966032, 26455},
  {"Closure", 966150, 26458},
  {"i:27", 968043, 26508},
  {"i:28", 968146, 26511},
  {"TestingOther", 968263, 26514},
  {"i:29", 971053, 26583},
  {"i:30", 971164, 26586},
  {"i:31", 971278, 26589},
  {"NumericRings", 971374, 26592},
  {"i:32", 973307, 26640},
  {"OtherRings", 973427, 26643},
  {"i:33", 974062, 26659}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 830, 30, 89, "Subsubtitle",
  Evaluatable->False],
Cell[2564, 83, 248, 11, 100, "Section",
  Evaluatable->False,
  CellTags->"i:1"],
Cell[2815, 96, 60, 1, 68, "Subsection",
  CellTags->"First"],
Cell[2878, 99, 178, 5, 59, "Text",
  CellTags->"First"],
Cell[3059, 106, 146, 4, 39, "Input",
  CellTags->"First"],
Cell[3208, 112, 152, 5, 43, "Text",
  CellTags->"First"],

Cell[CellGroupData[{
Cell[3385, 121, 101, 3, 39, "Input",
  CellTags->"First"],
Cell[3489, 126, 83, 3, 38, "Output",
  CellTags->"First"]
}, Open  ]],
Cell[3587, 132, 167, 7, 68, "Subsection",
  Evaluatable->False,
  CellTags->"i:2"],
Cell[3757, 141, 306, 9, 77, "Text",
  CellTags->"FormRingoid"],
Cell[4066, 152, 137, 5, 60, "Subsubsection",
  CellTags->{"FormRingoid", "i:3"}],
Cell[4206, 159, 14336, 402, 218, "DefinitionBox",
  CellTags->"FormRingoid"],
Cell[18545, 563, 143, 6, 26, "Caption",
  CellTags->"FormRingoid"],
Cell[18691, 571, 661, 14, 125, "Text",
  CellTags->"FormRingoid"],
Cell[19355, 587, 219, 4, 58, "Text",
  CellTags->"FormRingoid"],
Cell[19577, 593, 97, 1, 40, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[19699, 598, 227, 5, 71, "Input",
  CellTags->"FormRingoid"],
Cell[19929, 605, 208, 4, 53, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[20152, 612, 11290, 318, 432, "DefinitionBox3Col",
  CellTags->{"FormRingoid", "i:4"}],
Cell[31445, 932, 135, 6, 26, "Caption",
  CellTags->"FormRingoid"],
Cell[31583, 940, 380, 8, 92, "Text",
  CellTags->"FormRingoid"],
Cell[31966, 950, 69, 1, 40, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[32060, 955, 200, 5, 71, "Input",
  CellTags->"FormRingoid"],
Cell[32263, 962, 142, 3, 38, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[32420, 968, 162, 5, 41, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[32607, 977, 106, 3, 39, "Input",
  CellTags->"FormRingoid"],
Cell[32716, 982, 123, 3, 38, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[32854, 988, 146, 4, 54, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[33025, 996, 169, 4, 55, "Input",
  CellTags->"FormRingoid"],
Cell[33197, 1002, 142, 3, 38, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[33354, 1008, 200, 5, 54, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[33579, 1017, 277, 6, 71, "Input",
  CellTags->"FormRingoid"],
Cell[33859, 1025, 145, 4, 38, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[34019, 1032, 100, 1, 40, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[34144, 1037, 127, 3, 39, "Input",
  CellTags->"FormRingoid"],
Cell[34274, 1042, 43321, 922, 175, 8030, 480, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[77610, 1967, 203, 6, 55, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[77838, 1977, 275, 7, 106, "Input",
  CellTags->"FormRingoid"],
Cell[78116, 1986, 151, 4, 38, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[78282, 1993, 160, 5, 41, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[78467, 2002, 132, 3, 39, "Input",
  CellTags->"FormRingoid"],
Cell[78602, 2007, 66319, 1975, 175, 32886, 1556, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[144936, 3985, 175, 6, 41, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[145136, 3995, 271, 7, 106, "Input",
  CellTags->"FormRingoid"],
Cell[145410, 4004, 152, 4, 38, "Output",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[145577, 4011, 144, 5, 41, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[145746, 4020, 133, 3, 39, "Input",
  CellTags->"FormRingoid"],
Cell[145882, 4025, 42373, 927, 175, 8838, 506, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[188270, 4955, 384, 13, 71, "MathCaption",
  CellTags->"FormRingoid"],

Cell[CellGroupData[{
Cell[188679, 4972, 182, 4, 55, "Input",
  CellTags->"FormRingoid"],
Cell[188864, 4978, 66319, 1975, 175, 32886, 1556, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"FormRingoid"]
}, Open  ]],
Cell[255198, 6956, 138, 5, 60, "Subsubsection",
  CellTags->"FormRingoidByT"],
Cell[255339, 6963, 160, 5, 43, "Text",
  CellTags->"FormRingoidByT"],
Cell[255502, 6970, 704, 27, 48, "TopSpanBox",
  CellTags->{"FormRingoidByT", "i:5"}],
Cell[256209, 6999, 1993, 51, 61, "MiddleBox",
  CellTags->"FormRingoidByT"],
Cell[258205, 7052, 1177, 45, 31, "MiddleSpanBox",
  CellTags->"FormRingoidByT"],
Cell[259385, 7099, 3172, 83, 62, "BottomBox",
  CellTags->"FormRingoidByT"],
Cell[262560, 7184, 153, 6, 26, "Caption",
  CellTags->"FormRingoidByT"],
Cell[262716, 7192, 101, 1, 40, "MathCaption",
  CellTags->"FormRingoidByT"],

Cell[CellGroupData[{
Cell[262842, 7197, 239, 5, 103, "Input",
  CellTags->"FormRingoidByT"],
Cell[263084, 7204, 518, 11, 54, "Output",
  CellTags->"FormRingoidByT"]
}, Open  ]],
Cell[263617, 7218, 230, 7, 56, "MathCaption",
  CellTags->"FormRingoidByT"],

Cell[CellGroupData[{
Cell[263872, 7229, 282, 6, 71, "Input",
  CellTags->"FormRingoidByT"],
Cell[264157, 7237, 670, 13, 143, "Output",
  CellTags->"FormRingoidByT"]
}, Open  ]],
Cell[264842, 7253, 125, 5, 68, "Subsection",
  CellTags->"i:6"],
Cell[264970, 7260, 74, 1, 60, "Subsubsection",
  CellTags->"BasicRingoid"],
Cell[265047, 7263, 667, 19, 110, "Text",
  CellTags->"BasicRingoid"],
Cell[265717, 7284, 3536, 109, 121, "DefinitionBox",
  CellTags->{"BasicRingoid", "i:7"}],
Cell[269256, 7395, 101, 1, 26, "Caption",
  CellTags->"BasicRingoid"],
Cell[269360, 7398, 219, 8, 41, "MathCaption",
  CellTags->"BasicRingoid"],

Cell[CellGroupData[{
Cell[269604, 7410, 91, 3, 39, "Input",
  CellTags->"BasicRingoid"],
Cell[269698, 7415, 148, 4, 38, "Output",
  CellTags->"BasicRingoid"]
}, Open  ]],
Cell[269861, 7422, 88, 1, 40, "MathCaption",
  CellTags->"BasicRingoid"],

Cell[CellGroupData[{
Cell[269974, 7427, 99, 3, 39, "Input",
  CellTags->"BasicRingoid"],
Cell[270076, 7432, 102, 3, 38, "Output",
  CellTags->"BasicRingoid"]
}, Open  ]],
Cell[270193, 7438, 126, 4, 40, "MathCaption",
  CellTags->"BasicRingoid"],

Cell[CellGroupData[{
Cell[270344, 7446, 128, 3, 39, "Input",
  CellTags->"BasicRingoid"],
Cell[270475, 7451, 122, 3, 38, "Output",
  CellTags->"BasicRingoid"]
}, Open  ]],
Cell[270612, 7457, 208, 7, 59, "Text",
  CellTags->"BasicRingoid"],
Cell[270823, 7466, 78, 1, 60, "Subsubsection",
  CellTags->"RelatedRingoid"],
Cell[270904, 7469, 5625, 173, 170, "DefinitionBox",
  CellTags->{"RelatedRingoid", "i:8"}],
Cell[276532, 7644, 97, 1, 26, "Caption",
  CellTags->"RelatedRingoid"],
Cell[276632, 7647, 192, 6, 55, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[276849, 7657, 328, 8, 103, "Input",
  CellTags->"RelatedRingoid"],
Cell[277180, 7667, 144, 3, 38, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[277339, 7673, 157, 4, 54, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[277521, 7681, 137, 3, 39, "Input",
  CellTags->"RelatedRingoid"],
Cell[277661, 7686, 110, 3, 38, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[277786, 7692, 197, 7, 55, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[278008, 7703, 128, 3, 39, "Input",
  CellTags->"RelatedRingoid"],
Cell[278139, 7708, 102, 3, 38, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[278256, 7714, 269, 4, 68, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[278550, 7722, 99, 3, 39, "Input",
  CellTags->"RelatedRingoid"],
Cell[278652, 7727, 143, 3, 38, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[278810, 7733, 203, 6, 55, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[279038, 7743, 122, 3, 39, "Input",
  CellTags->"RelatedRingoid"],
Cell[279163, 7748, 409, 9, 128, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[279587, 7760, 275, 5, 54, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[279887, 7769, 261, 6, 71, "Input",
  CellTags->"RelatedRingoid"],
Cell[280151, 7777, 37767, 662, 308, 4246, 242, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[317933, 8442, 149, 4, 42, "Text",
  CellTags->{"RelatedRingoid", "i:9"}],
Cell[318085, 8448, 2179, 66, 98, "DefinitionBox",
  CellTags->{"RelatedRingoid", "i:10"}],
Cell[320267, 8516, 74, 1, 26, "Caption",
  CellTags->"RelatedRingoid"],
Cell[320344, 8519, 253, 6, 54, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[320622, 8529, 155, 4, 55, "Input",
  CellTags->"RelatedRingoid"],
Cell[320780, 8535, 153, 4, 53, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[320948, 8542, 205, 5, 54, "MathCaption",
  CellTags->"RelatedRingoid"],

Cell[CellGroupData[{
Cell[321178, 8551, 190, 4, 55, "Input",
  CellTags->"RelatedRingoid"],
Cell[321371, 8557, 117, 3, 38, "Output",
  CellTags->"RelatedRingoid"]
}, Open  ]],
Cell[321503, 8563, 7853, 225, 190, "DefinitionBox3Col",
  CellTags->{"RelatedRingoid", "i:11"}],
Cell[329359, 8790, 88, 1, 26, "Caption",
  CellTags->"RelatedRingoid"],
Cell[329450, 8793, 94, 1, 60, "Subsubsection",
  CellTags->{"GroupoidsFromR", "i:12"}],
Cell[329547, 8796, 412, 8, 90, "Text",
  CellTags->"GroupoidsFromR"],
Cell[329962, 8806, 7857, 227, 170, "DefinitionBox",
  CellTags->{"GroupoidsFromR", "i:13"}],
Cell[337822, 9035, 85, 1, 26, "Caption",
  CellTags->"GroupoidsFromR"],
Cell[337910, 9038, 288, 9, 40, "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{
Cell[338223, 9051, 112, 3, 39, "Input",
  CellTags->"GroupoidsFromR"],
Cell[338338, 9056, 155, 4, 53, "Output",
  CellTags->"GroupoidsFromR"]
}, Open  ]],
Cell[338508, 9063, 105, 1, 40, "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{
Cell[338638, 9068, 162, 4, 55, "Input",
  CellTags->"GroupoidsFromR"],
Cell[338803, 9074, 101, 3, 38, "Output",
  CellTags->"GroupoidsFromR"]
}, Open  ]],
Cell[338919, 9080, 108, 1, 40, "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{
Cell[339052, 9085, 124, 3, 39, "Input",
  CellTags->"GroupoidsFromR"],
Cell[339179, 9090, 94, 3, 38, "Output",
  CellTags->"GroupoidsFromR"]
}, Open  ]],
Cell[339288, 9096, 137, 4, 40, "MathCaption",
  CellTags->"GroupoidsFromR"],

Cell[CellGroupData[{
Cell[339450, 9104, 127, 3, 39, "Input",
  CellTags->"GroupoidsFromR"],
Cell[339580, 9109, 142, 3, 38, "Output",
  CellTags->"GroupoidsFromR"]
}, Open  ]],
Cell[339737, 9115, 74, 1, 68, "Subsection",
  CellTags->"i:14"],
Cell[339814, 9118, 85, 1, 60, "Subsubsection",
  CellTags->{"AdditiveP", "i:15"}],
Cell[339902, 9121, 330, 6, 90, "Text",
  CellTags->"AdditiveP"],
Cell[340235, 9129, 9702, 290, 247, "DefinitionBox",
  CellTags->{"AdditiveP", "i:16"}],
Cell[349940, 9421, 100, 1, 26, "Caption",
  CellTags->"AdditiveP"],
Cell[350043, 9424, 313, 9, 56, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[350381, 9437, 339, 6, 103, "Input",
  CellTags->"AdditiveP"],
Cell[350723, 9445, 114, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[350852, 9451, 266, 8, 55, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[351143, 9463, 153, 4, 55, "Input",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[351321, 9471, 15693, 284, 164, 1886, 108, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"],
Cell[367017, 9757, 10168, 194, 164, 1358, 79, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"],
Cell[377188, 9953, 10156, 194, 164, 1354, 79, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"],
Cell[387347, 10149, 5868, 117, 164, 865, 49, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"],
Cell[393218, 10268, 8099, 145, 164, 962, 51, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[401332, 10416, 88, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[401435, 10422, 170, 5, 55, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[401630, 10431, 153, 4, 55, "Input",
  CellTags->"AdditiveP"],
Cell[401786, 10437, 34551, 706, 308, 5925, 347, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"],
Cell[436340, 11145, 88, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[436443, 11151, 14008, 394, 247, "DefinitionBox",
  CellTags->{"AdditiveP", "i:17"}],
Cell[450454, 11547, 118, 4, 26, "Caption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[450597, 11555, 177, 4, 55, "Input",
  CellTags->"AdditiveP"],
Cell[450777, 11561, 124, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[450916, 11567, 173, 6, 40, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[451114, 11577, 114, 3, 39, "Input",
  CellTags->"AdditiveP"],
Cell[451231, 11582, 35961, 825, 180, 9549, 493, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"AdditiveP"],
Cell[487195, 12409, 85, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[487295, 12415, 195, 6, 40, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[487515, 12425, 106, 3, 39, "Input",
  CellTags->"AdditiveP"],
Cell[487624, 12430, 88, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[487727, 12436, 188, 6, 40, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[487940, 12446, 124, 3, 39, "Input",
  CellTags->"AdditiveP"],
Cell[488067, 12451, 222, 4, 79, "Print",
  CellTags->"AdditiveP"],
Cell[488292, 12457, 99, 2, 49, "Print",
  CellTags->"AdditiveP"],
Cell[488394, 12461, 85, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[488494, 12467, 310, 11, 60, "Text",
  CellTags->"AdditiveP"],
Cell[488807, 12480, 153, 5, 41, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[488985, 12489, 136, 3, 39, "Input",
  CellTags->"AdditiveP"],
Cell[489124, 12494, 88, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[489227, 12500, 3639, 98, 157, "DefinitionBox3Col",
  CellTags->{"AdditiveP", "i:18"}],
Cell[492869, 12600, 92, 1, 26, "Caption",
  CellTags->"AdditiveP"],
Cell[492964, 12603, 369, 8, 84, "MathCaption",
  CellTags->"AdditiveP"],

Cell[CellGroupData[{
Cell[493358, 12615, 310, 6, 87, "Input",
  CellTags->"AdditiveP"],
Cell[493671, 12623, 111, 3, 38, "Output",
  CellTags->"AdditiveP"]
}, Open  ]],
Cell[493797, 12629, 97, 1, 60, "Subsubsection",
  CellTags->{"MultiplicativeP", "i:19"}],
Cell[493897, 12632, 241, 5, 58, "Text",
  CellTags->"MultiplicativeP"],
Cell[494141, 12639, 3573, 106, 111, "DefinitionBox",
  CellTags->{"MultiplicativeP", "i:20"}],
Cell[497717, 12747, 108, 1, 26, "Caption",
  CellTags->"MultiplicativeP"],
Cell[497828, 12750, 16768, 491, 370, "DefinitionBox",
  CellTags->{"MultiplicativeP", "i:21"}],
Cell[514599, 13243, 102, 1, 26, "Caption",
  CellTags->"MultiplicativeP"],
Cell[514704, 13246, 264, 7, 58, "Text",
  CellTags->"MultiplicativeP"],
Cell[514971, 13255, 69, 1, 40, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[515065, 13260, 122, 3, 39, "Input",
  CellTags->"MultiplicativeP"],
Cell[515190, 13265, 99, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[515304, 13271, 236, 6, 54, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[515565, 13281, 145, 3, 55, "Input",
  CellTags->"MultiplicativeP"],
Cell[515713, 13286, 167, 4, 53, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[515895, 13293, 215, 5, 54, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[516135, 13302, 178, 4, 55, "Input",
  CellTags->"MultiplicativeP"],
Cell[516316, 13308, 25899, 754, 308, 12547, 583, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"MultiplicativeP"],
Cell[542218, 14064, 296, 5, 83, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[542529, 14072, 266, 7, 54, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[542820, 14083, 194, 4, 55, "Input",
  CellTags->"MultiplicativeP"],
Cell[543017, 14089, 623, 9, 184, "Print",
  CellTags->"MultiplicativeP"],
Cell[543643, 14100, 117463, 3669, 308, 41556, 2726, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"MultiplicativeP"],
Cell[661109, 17771, 95, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[661219, 17777, 126, 4, 40, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[661370, 17785, 125, 3, 39, "Input",
  CellTags->"MultiplicativeP"],
Cell[661498, 17790, 36400, 830, 180, 9541, 493, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"MultiplicativeP"],
Cell[697901, 18622, 91, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[698007, 18628, 2619, 84, 102, "DefinitionBox",
  CellTags->{"MultiplicativeP", "i:22"}],
Cell[700629, 18714, 124, 4, 26, "Caption",
  CellTags->"MultiplicativeP"],
Cell[700756, 18720, 205, 6, 40, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[700986, 18730, 130, 3, 39, "Input",
  CellTags->"MultiplicativeP"],
Cell[701119, 18735, 110, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[701244, 18741, 145, 4, 54, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[701414, 18749, 137, 3, 39, "Input",
  CellTags->"MultiplicativeP"],
Cell[701554, 18754, 1116, 22, 112, "Print",
  CellTags->"MultiplicativeP"],
Cell[702673, 18778, 110, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[702798, 18784, 90, 1, 40, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[702913, 18789, 107, 3, 39, "Input",
  CellTags->"MultiplicativeP"],
Cell[703023, 18794, 117, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[703155, 18800, 235, 5, 68, "MathCaption",
  CellTags->"MultiplicativeP"],

Cell[CellGroupData[{
Cell[703415, 18809, 133, 3, 39, "Input",
  CellTags->"MultiplicativeP"],
Cell[703551, 18814, 94, 3, 38, "Output",
  CellTags->"MultiplicativeP"]
}, Open  ]],
Cell[703660, 18820, 91, 1, 60, "Subsubsection",
  CellTags->{"DistributiveP", "i:23"}],
Cell[703754, 18823, 734, 19, 124, "Text",
  CellTags->"DistributiveP"],
Cell[704491, 18844, 13096, 352, 252, "DefinitionBox",
  CellTags->{"DistributiveP", "i:24"}],
Cell[717590, 19198, 85, 1, 26, "Caption",
  CellTags->"DistributiveP"],
Cell[717678, 19201, 181, 6, 40, "MathCaption",
  CellTags->"DistributiveP"],

Cell[CellGroupData[{
Cell[717884, 19211, 107, 3, 39, "Input",
  CellTags->"DistributiveP"],
Cell[717994, 19216, 92, 3, 38, "Output",
  CellTags->"DistributiveP"]
}, Open  ]],
Cell[718101, 19222, 444, 16, 60, "Text",
  CellTags->"DistributiveP"],
Cell[718548, 19240, 169, 4, 54, "MathCaption",
  CellTags->"DistributiveP"],

Cell[CellGroupData[{
Cell[718742, 19248, 118, 3, 39, "Input",
  CellTags->"DistributiveP"],
Cell[718863, 19253, 92, 3, 38, "Output",
  CellTags->"DistributiveP"]
}, Open  ]],
Cell[718970, 19259, 127, 6, 60, "Subsubsection",
  CellTags->"RingQ"],
Cell[719100, 19267, 390, 10, 93, "Text",
  CellTags->"RingQ"],
Cell[719493, 19279, 5001, 146, 130, "DefinitionBox",
  CellTags->{"RingQ", "i:25"}],
Cell[724497, 19427, 97, 1, 26, "Caption",
  CellTags->"RingQ"],
Cell[724597, 19430, 182, 6, 40, "MathCaption",
  CellTags->"RingQ"],

Cell[CellGroupData[{
Cell[724804, 19440, 90, 3, 39, "Input",
  CellTags->"RingQ"],
Cell[724897, 19445, 84, 3, 38, "Output",
  CellTags->"RingQ"]
}, Open  ]],
Cell[724996, 19451, 169, 6, 41, "MathCaption",
  CellTags->"RingQ"],

Cell[CellGroupData[{
Cell[725190, 19461, 108, 3, 39, "Input",
  CellTags->"RingQ"],
Cell[725301, 19466, 84, 3, 38, "Output",
  CellTags->"RingQ"]
}, Open  ]],
Cell[725400, 19472, 122, 3, 40, "MathCaption",
  CellTags->"RingQ"],

Cell[CellGroupData[{
Cell[725547, 19479, 103, 3, 39, "Input",
  CellTags->"RingQ"],
Cell[725653, 19484, 581, 12, 188, "Output",
  CellTags->"RingQ"]
}, Open  ]],
Cell[726249, 19499, 80, 1, 60, "Subsubsection",
  CellTags->"SpecializedRings"],
Cell[726332, 19502, 1929, 58, 83, "DefinitionBox",
  CellTags->{"SpecializedRings", "i:26"}],
Cell[728264, 19562, 104, 1, 26, "Caption",
  CellTags->"SpecializedRings"],
Cell[728371, 19565, 250, 9, 40, "MathCaption",
  CellTags->"SpecializedRings"],

Cell[CellGroupData[{
Cell[728646, 19578, 126, 3, 39, "Input",
  CellTags->"SpecializedRings"],
Cell[728775, 19583, 181, 4, 53, "Output",
  CellTags->"SpecializedRings"]
}, Open  ]],
Cell[728971, 19590, 294, 9, 54, "MathCaption",
  CellTags->"SpecializedRings"],

Cell[CellGroupData[{
Cell[729290, 19603, 142, 3, 43, "Input",
  CellTags->"SpecializedRings"],
Cell[729435, 19608, 95, 3, 38, "Output",
  CellTags->"SpecializedRings"]
}, Open  ]],
Cell[729545, 19614, 82, 1, 60, "Subsubsection",
  CellTags->{"Closure", "i:27"}],
Cell[729630, 19617, 272, 6, 75, "Text",
  CellTags->"Closure"],
Cell[729905, 19625, 12149, 349, 200, "DefinitionBox",
  CellTags->{"Closure", "i:28"}],
Cell[742057, 19976, 78, 1, 26, "Caption",
  CellTags->"Closure"],
Cell[742138, 19979, 143, 4, 58, "Text",
  CellTags->"Closure"],
Cell[742284, 19985, 126, 4, 40, "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{
Cell[742435, 19993, 108, 3, 39, "Input",
  CellTags->"Closure"],
Cell[742546, 19998, 87, 3, 38, "Output",
  CellTags->"Closure"]
}, Open  ]],
Cell[742648, 20004, 99, 1, 40, "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{
Cell[742772, 20009, 145, 4, 55, "Input",
  CellTags->"Closure"],
Cell[742920, 20015, 86, 3, 38, "Output",
  CellTags->"Closure"]
}, Open  ]],
Cell[743021, 20021, 194, 6, 40, "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{
Cell[743240, 20031, 112, 3, 39, "Input",
  CellTags->"Closure"],
Cell[743355, 20036, 86, 3, 38, "Output",
  CellTags->"Closure"]
}, Open  ]],
Cell[743456, 20042, 106, 2, 40, "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{
Cell[743587, 20048, 113, 3, 39, "Input",
  CellTags->"Closure"],
Cell[743703, 20053, 86, 3, 38, "Output",
  CellTags->"Closure"]
}, Open  ]],
Cell[743804, 20059, 196, 6, 41, "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{
Cell[744025, 20069, 167, 4, 55, "Input",
  CellTags->"Closure"],
Cell[744195, 20075, 29461, 662, 308, 6264, 370, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Closure"],
Cell[773659, 20739, 87, 3, 38, "Output",
  CellTags->"Closure"]
}, Open  ]],
Cell[773761, 20745, 150, 5, 41, "MathCaption",
  CellTags->"Closure"],

Cell[CellGroupData[{
Cell[773936, 20754, 184, 4, 71, "Input",
  CellTags->"Closure"],
Cell[774123, 20760, 94, 3, 38, "Output",
  CellTags->"Closure"]
}, Open  ]],
Cell[774232, 20766, 83, 1, 60, "Subsubsection",
  CellTags->"TestingOther"],
Cell[774318, 20769, 764, 28, 92, "Text",
  CellTags->"TestingOther"],
Cell[775085, 20799, 3127, 98, 88, "DefinitionBox",
  CellTags->{"TestingOther", "i:29"}],
Cell[778215, 20899, 101, 1, 26, "Caption",
  CellTags->"TestingOther"],
Cell[778319, 20902, 288, 10, 40, "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{
Cell[778632, 20916, 305, 7, 103, "Input",
  CellTags->"TestingOther"],
Cell[778940, 20925, 587, 18, 176, "Output",
  CellTags->"TestingOther"]
}, Open  ]],
Cell[779542, 20946, 387, 14, 55, "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{
Cell[779954, 20964, 329, 8, 103, "Input",
  CellTags->"TestingOther"],
Cell[780286, 20974, 169, 4, 51, "Message",
  CellTags->"TestingOther"],
Cell[780458, 20980, 576, 17, 161, "Output",
  CellTags->"TestingOther"]
}, Open  ]],
Cell[781049, 21000, 367, 10, 68, "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{
Cell[781441, 21014, 175, 5, 55, "Input",
  CellTags->"TestingOther"],
Cell[781619, 21021, 100, 3, 38, "Output",
  CellTags->"TestingOther"]
}, Open  ]],
Cell[781734, 21027, 10707, 299, 176, "DefinitionBox",
  CellTags->{"TestingOther", "i:30"}],
Cell[792444, 21328, 95, 1, 26, "Caption",
  CellTags->"TestingOther"],
Cell[792542, 21331, 204, 6, 40, "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{
Cell[792771, 21341, 135, 3, 39, "Input",
  CellTags->"TestingOther"],
Cell[792909, 21346, 190, 4, 53, "Output",
  CellTags->"TestingOther"]
}, Open  ]],
Cell[793114, 21353, 98, 1, 40, "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{
Cell[793237, 21358, 113, 3, 39, "Input",
  CellTags->"TestingOther"],
Cell[793353, 21363, 141, 3, 38, "Output",
  CellTags->"TestingOther"]
}, Open  ]],
Cell[793509, 21369, 276, 9, 42, "MathCaption",
  CellTags->"TestingOther"],

Cell[CellGroupData[{
Cell[793810, 21382, 106, 3, 