(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    652851,      16762]*)
(*NotebookOutlinePosition[    692798,      17815]*)
(*  CellTagsIndexPosition[    691121,      17753]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->24],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times"],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times",
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  TextAlignment->Center,
  TextJustification->0,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Chapter 5",
    FontSize->18],
  "\nAdditional Functionality"
}], "Section",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True,
  CellTags->"Global"],

Cell["\<\
In the final chapter, we look at some additional functionality that \
does not neatly fit into the chapters on groupoids, ringoids, or morphisms. \
\
\>", "Text",
  CellTags->"Global"],

Cell["5.0 Read me first", "Subsection",
  CellTags->"First"],

Cell[TextData[{
  "To evaluate any of the ",
  StyleBox["Input", "MR"],
  " cells in this chapter, the following cell should be evaluated first."
}], "Text",
  CellTags->"First"],

Cell[BoxData[
    \(Needs["\<AbstractAlgebra`Master`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  ShowGroupOpenCloseIcon->True,
  CellTags->"First"],

Cell[TextData[{
  "Since we wish to primarily focus on groups, we use the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function."
}], "Text",
  CellTags->"First"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Group]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"First"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"First"]
}, Open  ]],

Cell["5.1 Global variables and options", "Subsection",
  CellTags->{"Global", "i:1"}],

Cell["\<\
There are several global variables and options that are worth \
noting. \
\>", "Text",
  CellTags->"Global"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["name",
              "SO10"], 
            StyleBox[\(initial\ value\),
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["DefaultStructure",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Group",
                "StandardForm"],
              "Text"], 
            
            StyleBox[
              \(context\ \((groups\ versus\ rings)\)\ that\ is\ assumed\ for\ 
                the\ functions\ in\ use\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["VisualTextShown",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["2",
                "StandardForm"],
              "Text"], 
            RowBox[{"specifies", " ", 
              StyleBox["how",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["often",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["accompanying",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["text",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["visualizations",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["shown",
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["BackgroundColors",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox[
                StyleBox[\((see\ below)\),
                  "Text"],
                "StandardForm"],
              "Text"], 
            RowBox[{"(", "ordered", ")", " ", 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["colors",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["that",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["used",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cayley",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["tables",
                SingleLetterItalics->False]}]},
          {
            StyleBox["Output",
              "MR"], 
            StyleBox["Computational",
              "MR"], 
            RowBox[{
            \(available\ for\ some\ functions\ when\ the\), " ", "\n", 
              RowBox[{
                StyleBox["Visual",
                  "MR"], " ", "mode", " ", "is", " ", "being", " ", "used", 
                " ", "in", " ", "order", " ", "to"}], " ", "\n", 
              \(change\ the\ output\ from\ the\ computation\ to\), " ", 
              "\n", 
              RowBox[{"the", " ", "visual", " ", "graphic", " ", 
                RowBox[{"(", 
                  RowBox[{"using", " ", "the", " ", "value", " ", "\n", 
                    StyleBox["Graphics",
                      "MR"]}], ")"}]}]}]},
          {
            StyleBox["DefaultOrder",
              "MR"], 
            StyleBox["RightToLeft",
              "MR"], \(default\ direction\ for\ multiplying\ permutations\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.22, 0.26, 0.52},
  RowLines->{True, False}},
  CellTags->{"Global", "i:2"}],

Cell["Some global variables.", "Caption",
  CellTags->"Global"],

Cell[BoxData[
    FormBox[
      RowBox[{"{", 
        StyleBox[\(Yellow, \ Orange, \ Violet, \ Blue, \ Mint, \ Turquoise, \ 
          EmeraldGreen, \ GreenDark, \ Pink, \ BlueLight, \ Banana, \ Green, 
          \ Brown, \ Gray, \ Red, \ Purple, \ CadmiumYellow, \ Maroon, \ 
          Navy, \ Salmon, \ Aquamarine, \ Indigo, \ Lavender, \ Antique, \ 
          Bisque, \ Burlywood, \ Eggshell, \ Khaki, \ BlueViolet, \ 
          CadmiumOrange, \ CadmiumRedDeep, \ Cerulean, \ Chartreuse, \ Cyan, 
          \ DeepPink, \ Magenta, \ OrangeRed, \ Peacock, \ SkyBlueDeep, \ 
          TurquoiseDark, \ Ultramarine\),
          "MR",
          FormatType->StandardForm], 
        StyleBox["}",
          "MR",
          FormatType->StandardForm]}], NotebookDefault]], "DefinitionBox",
  CellTags->"Global"],

Cell[TextData[{
  StyleBox["BackgroundColors",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Global"],

Cell["\<\
One can always see the default structure that is being \
assumed.\
\>", "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefaultStructure\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Global"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Global"]
}, Open  ]],

Cell[TextData[{
  "If you wish to change the value of this variable, it is best to use the ",
  StyleBox["SwitchStructureTo", "MR"],
  " function because it redefines some options for various functions."
}], "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SwitchStructureTo[Group]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Global"],

Cell[BoxData[
    \(Group\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Global"]
}, Open  ]],

Cell[TextData[{
  "Typically, the output of all functions, even in the ",
  StyleBox["Visual", "MR"],
  " mode, results in a computation."
}], "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CayleyTable[Z[6], \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Global"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.07143 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.159864 0.136054 0.0255102 0.136054 [
[ 0 0 0 0 ]
[ 1 1.07143 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.07143 L
0 1.07143 L
closepath
clip
newpath
1 1 0 r
.15986 .70578 m
.15986 .84184 L
.29592 .84184 L
.29592 .70578 L
F
.84014 .56973 m
.84014 .70578 L
.97619 .70578 L
.97619 .56973 L
F
.70408 .43367 m
.70408 .56973 L
.84014 .56973 L
.84014 .43367 L
F
.56803 .29762 m
.56803 .43367 L
.70408 .43367 L
.70408 .29762 L
F
.43197 .16156 m
.43197 .29762 L
.56803 .29762 L
.56803 .16156 L
F
.29592 .02551 m
.29592 .16156 L
.43197 .16156 L
.43197 .02551 L
F
1 .5 0 r
.29592 .70578 m
.29592 .84184 L
.43197 .84184 L
.43197 .70578 L
F
.15986 .56973 m
.15986 .70578 L
.29592 .70578 L
.29592 .56973 L
F
.84014 .43367 m
.84014 .56973 L
.97619 .56973 L
.97619 .43367 L
F
.70408 .29762 m
.70408 .43367 L
.84014 .43367 L
.84014 .29762 L
F
.56803 .16156 m
.56803 .29762 L
.70408 .29762 L
.70408 .16156 L
F
.43197 .02551 m
.43197 .16156 L
.56803 .16156 L
.56803 .02551 L
F
.56 .37 .6 r
.43197 .70578 m
.43197 .84184 L
.56803 .84184 L
.56803 .70578 L
F
.29592 .56973 m
.29592 .70578 L
.43197 .70578 L
.43197 .56973 L
F
.15986 .43367 m
.15986 .56973 L
.29592 .56973 L
.29592 .43367 L
F
.84014 .29762 m
.84014 .43367 L
.97619 .43367 L
.97619 .29762 L
F
.70408 .16156 m
.70408 .29762 L
.84014 .29762 L
.84014 .16156 L
F
.56803 .02551 m
.56803 .16156 L
.70408 .16156 L
.70408 .02551 L
F
0 0 1 r
.56803 .70578 m
.56803 .84184 L
.70408 .84184 L
.70408 .70578 L
F
.43197 .56973 m
.43197 .70578 L
.56803 .70578 L
.56803 .56973 L
F
.29592 .43367 m
.29592 .56973 L
.43197 .56973 L
.43197 .43367 L
F
.15986 .29762 m
.15986 .43367 L
.29592 .43367 L
.29592 .29762 L
F
.84014 .16156 m
.84014 .29762 L
.97619 .29762 L
.97619 .16156 L
F
.70408 .02551 m
.70408 .16156 L
.84014 .16156 L
.84014 .02551 L
F
.74 .99 .79 r
.70408 .70578 m
.70408 .84184 L
.84014 .84184 L
.84014 .70578 L
F
.56803 .56973 m
.56803 .70578 L
.70408 .70578 L
.70408 .56973 L
F
.43197 .43367 m
.43197 .56973 L
.56803 .56973 L
.56803 .43367 L
F
.29592 .29762 m
.29592 .43367 L
.43197 .43367 L
.43197 .29762 L
F
.15986 .16156 m
.15986 .29762 L
.29592 .29762 L
.29592 .16156 L
F
.84014 .02551 m
.84014 .16156 L
.97619 .16156 L
.97619 .02551 L
F
.251 .878 .816 r
.84014 .70578 m
.84014 .84184 L
.97619 .84184 L
.97619 .70578 L
F
.70408 .56973 m
.70408 .70578 L
.84014 .70578 L
.84014 .56973 L
F
.56803 .43367 m
.56803 .56973 L
.70408 .56973 L
.70408 .43367 L
F
.43197 .29762 m
.43197 .43367 L
.56803 .43367 L
.56803 .29762 L
F
.29592 .16156 m
.29592 .29762 L
.43197 .29762 L
.43197 .16156 L
F
.15986 .02551 m
.15986 .16156 L
.29592 .16156 L
.29592 .02551 L
F
1 1 0 r
.15986 .84184 m
.15986 .97789 L
.29592 .97789 L
.29592 .84184 L
F
1 .5 0 r
.29592 .84184 m
.29592 .97789 L
.43197 .97789 L
.43197 .84184 L
F
.56 .37 .6 r
.43197 .84184 m
.43197 .97789 L
.56803 .97789 L
.56803 .84184 L
F
0 0 1 r
.56803 .84184 m
.56803 .97789 L
.70408 .97789 L
.70408 .84184 L
F
.74 .99 .79 r
.70408 .84184 m
.70408 .97789 L
.84014 .97789 L
.84014 .84184 L
F
.251 .878 .816 r
.84014 .84184 m
.84014 .97789 L
.97619 .97789 L
.97619 .84184 L
F
1 1 0 r
.02381 .70578 m
.02381 .84184 L
.15986 .84184 L
.15986 .70578 L
F
1 .5 0 r
.02381 .56973 m
.02381 .70578 L
.15986 .70578 L
.15986 .56973 L
F
.56 .37 .6 r
.02381 .43367 m
.02381 .56973 L
.15986 .56973 L
.15986 .43367 L
F
0 0 1 r
.02381 .29762 m
.02381 .43367 L
.15986 .43367 L
.15986 .29762 L
F
.74 .99 .79 r
.02381 .16156 m
.02381 .29762 L
.15986 .29762 L
.15986 .16156 L
F
.251 .878 .816 r
.02381 .02551 m
.02381 .16156 L
.15986 .16156 L
.15986 .02551 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02551 m
.02381 .97789 L
s
.02381 .02551 m
.97619 .02551 L
s
.02381 .16156 m
.97619 .16156 L
s
.02381 .29762 m
.97619 .29762 L
s
.02381 .43367 m
.97619 .43367 L
s
.02381 .56973 m
.97619 .56973 L
s
.02381 .70578 m
.97619 .70578 L
s
.02381 .84184 m
.97619 .84184 L
s
.02381 .97789 m
.97619 .97789 L
s
.15986 .02551 m
.15986 .97789 L
s
.29592 .02551 m
.29592 .97789 L
s
.43197 .02551 m
.43197 .97789 L
s
.56803 .02551 m
.56803 .97789 L
s
.70408 .02551 m
.70408 .97789 L
s
.84014 .02551 m
.84014 .97789 L
s
.97619 .02551 m
.97619 .97789 L
s
.02381 .97789 m
.15986 .84184 L
s
2.6 Mabswid
.15986 .02551 m
.15986 .97789 L
s
.02381 .84184 m
.97619 .84184 L
s
[(0)] .22789 .77381 0 0 Mshowa
[(1)] .36395 .77381 0 0 Mshowa
[(2)] .5 .77381 0 0 Mshowa
[(3)] .63605 .77381 0 0 Mshowa
[(4)] .77211 .77381 0 0 Mshowa
[(5)] .90816 .77381 0 0 Mshowa
[(1)] .22789 .63776 0 0 Mshowa
[(2)] .36395 .63776 0 0 Mshowa
[(3)] .5 .63776 0 0 Mshowa
[(4)] .63605 .63776 0 0 Mshowa
[(5)] .77211 .63776 0 0 Mshowa
[(0)] .90816 .63776 0 0 Mshowa
[(2)] .22789 .5017 0 0 Mshowa
[(3)] .36395 .5017 0 0 Mshowa
[(4)] .5 .5017 0 0 Mshowa
[(5)] .63605 .5017 0 0 Mshowa
[(0)] .77211 .5017 0 0 Mshowa
[(1)] .90816 .5017 0 0 Mshowa
[(3)] .22789 .36565 0 0 Mshowa
[(4)] .36395 .36565 0 0 Mshowa
[(5)] .5 .36565 0 0 Mshowa
[(0)] .63605 .36565 0 0 Mshowa
[(1)] .77211 .36565 0 0 Mshowa
[(2)] .90816 .36565 0 0 Mshowa
[(4)] .22789 .22959 0 0 Mshowa
[(5)] .36395 .22959 0 0 Mshowa
[(0)] .5 .22959 0 0 Mshowa
[(1)] .63605 .22959 0 0 Mshowa
[(2)] .77211 .22959 0 0 Mshowa
[(3)] .90816 .22959 0 0 Mshowa
[(5)] .22789 .09354 0 0 Mshowa
[(0)] .36395 .09354 0 0 Mshowa
[(1)] .5 .09354 0 0 Mshowa
[(2)] .63605 .09354 0 0 Mshowa
[(3)] .77211 .09354 0 0 Mshowa
[(4)] .90816 .09354 0 0 Mshowa
[(0)] .09184 .77381 0 0 Mshowa
[(1)] .09184 .63776 0 0 Mshowa
[(2)] .09184 .5017 0 0 Mshowa
[(3)] .09184 .36565 0 0 Mshowa
[(4)] .09184 .22959 0 0 Mshowa
[(5)] .09184 .09354 0 0 Mshowa
[(0)] .22789 .90986 0 0 Mshowa
[(1)] .36395 .90986 0 0 Mshowa
[(2)] .5 .90986 0 0 Mshowa
[(3)] .63605 .90986 0 0 Mshowa
[(4)] .77211 .90986 0 0 Mshowa
[(5)] .90816 .90986 0 0 Mshowa
[(Z[6])] .02381 1.04592 -1 0 Mshowa
gsave
.97619 1.04592 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .07007 .88673 0 0 Mshowa
[(y)] .12585 .93707 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  ImageSize->{268.75, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004<000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@0000H0ool1o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@h00_l09O4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l08ml0B_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko8d`09_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H002?o/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02o`0U/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC00VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0ol600001P008ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o
02Ga3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02?O04[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<
02Ko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000Sok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_l09K0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3_l08ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`09_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?o1P0000H002?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02o`0Ul@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC00Vo`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P008on`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>00;o02F`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko02?O
04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdob=<02KoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H0
0006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@h00_l09O4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l08ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`09_l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3P02o`0U/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Sg`1:oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lSC00VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P008ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o02Ga3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ko02?O04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<02Ko0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?o`H00006000Sok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h0
0_l09K0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l08ml0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
8d`09_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H002?ol@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02o`0Ul@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC00Vo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol600001P008on`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>00;o02F`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko02?O04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<02KoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@h00_l09O4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l0
8ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko8d`09_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo
1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02o`0U/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC00VomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P008ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>00;o02Ga3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02?O04[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nob=<02Ko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000S
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_l09K0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3_l08ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`09_oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?o1P0000H0013ol@ka3_4>l@ka3_4>l@ka0ol04?4>l@ka3_4>l@ka3_4>
l@h2o`0@l@ka3_4>l@ka3_4>l@ka3P?o018>l@ka3_4>l@ka3_4>l@ka3_l@g`;o4Ml04?mOWenOGimO
WenOGimOWel3o`0RGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOPCo015aOW5nLGiaOW5n
LGiaOW5no`0?C0?o4D`04_l33`<?0`l33`<?0`l33`<?0`?o01433`<?0`l33`<?0`l33`<?o`060000
1P008on`3[0>/0j`3[0>/0j`3[0>/0ko3[0>/0j`3[0>/0j`3[0>00;o02F`3[0>/0j`3[0>/0j`3[0>
/0j`ok0>/0j`3[0>/0j`3[0>/0ko00oO00Cogmoo4=l0B_mOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Co4T`00om<C00>C00V
omH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0ol600001P008ooa3_4>l@ka3_4>l@ka
3_4>l@ko3_4>l@ka3_4>l@ka3_4>00;o02Ga3_4>l@ka3_4>l@ka3_4>l@kaoo4>l@ka3_4>l@ka3_4>
l@ko00oO00Cogmoo4=l0B_mOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGiooOW5nLGia
OW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGko4T`00om<C00>C00Ao`<?0`l33`<?0`l33`<?0`l0
1?l04@<?0`l33`<?0`l33`<?0`oo00H00006000@ok0>/0j`3[0>/0j`3[0>/0?o012`3[0>/0j`3[0>
/0j`3[0>0_l04;0>/0j`3[0>/0j`3[0>/0h3o`0B3[0>/0j`3[0>/0j`3[0>/0ko3ml01?oOgol@g`1:
oenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7koO_An
m7kdO_Anm7kdO_Anm?l@C0;o4D`09_oF0mH3eP?F0mH3eP?F0mH3o`?o0mH3eP?F0mH3eP?F0mH3eP?o
1P0000H002?ol@ka3_4>l@ka3_4>l@kaoo4>l@ka3_4>l@ka3_4>l@ka3P02o`0Ul@ka3_4>l@ka3_4>
l@ka3_l>l@ka3_4>l@ka3_4>l@ka3_4>o`0?g`04omoOoa3O04[oGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaO_mnLOmaOW5nLGiaOW5nLGiaOW5noa9<00?oC4`0
3T`09_l33`<?0`l33`<?0`l33`<?o`oo3`<?0`l33`<?0`l33`<?0`oo1P0000H0013o/0j`3[0>/0j`
3[0>/0j`1?l03`j`3[0>/0j`3[0>/0j`3P02o`0@/0j`3[0>/0j`3[0>/0j`3PCo016`3[0>/0j`3[0>
/0j`3[0>o`0@g`;o4Ml04?mOWenOGimOWenOGimOWel2o`0TWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_An0_l04_Anm7kdO_Anm7kdO_Anm7kdo`m<0olAC00BomH3eP?F0mH3eP?F0mH3eP?F
0_l04P?F0mH3eP?F0mH3eP?F0mH3o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@h00_l09O4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l08ml0B_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko8d`09_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H002?o/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02o`0U/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC00VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0ol600001P008ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o
02Ga3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02?O04[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<
02Ko0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`H00006000Sok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h00_l09K0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3_l08ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`09_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?o1P0000H002?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02o`0Ul@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC00Vo`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol600001P008on`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>00;o02F`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko02?O
04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdob=<02KoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H0
0006000Soo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@h00_l09O4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l08ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`09_l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3P02o`0U/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Sg`1:oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lSC00VomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P008ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>00;o02Ga3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ko02?O04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<02Ko0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?o`H00006000Sok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0h0
0_l09K0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l08ml0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
8d`09_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o1P0000H002?ol@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3P02o`0Ul@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC00Vo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33ol600001P008on`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>00;o02F`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko02?O04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<02KoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`H00006000Soo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@h00_l09O4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l0
8ml0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko8d`09_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo
1P0000H002?o/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3P02o`0U/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Sg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC00VomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol600001P3oo`7o1P0000H002?oeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0`02o`19eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Tg`19oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0TC003
o`0000@00006000So`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l0B@<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_l09=l0BOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l094`00ol0000400001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH300;o04WF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko02CO04WoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co02A<00?o0000
100000H002?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02o`190`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
o`0Tg`19oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0TC003o`0000@00006000SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP<00_l0BMH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l09=l0BOnOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l094`00ol000040000
1P008ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o04T33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02CO
04WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko02A<00?o0000100000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0`02o`19eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Tg`19oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0TC003o`0000@00006000S
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l0B@<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l09=l0BOnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l094`00ol0000400001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH300;o04WF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0ko02CO04WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co02A<00?o0000100000H002?o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02o`190`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0Tg`19oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0TC003o`0000@00006000SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<0
0_l0BMH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3_l09=l0BOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l094`00ol0000400001P008ol33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o04T33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02CO04WoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko02A<00?o0000100000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`19
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>o`0Tg`19oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0TC003o`0000@00006000So`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l0B@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l09=l0BOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
94`00ol0000400001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o04WF0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0ko02CO04WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co02A<00?o0000100000H0017o0`l33`<?0`l33`<?0`l3
3`03o`0?3`<?0`l33`<?0`l33`<?00;o01433`<?0`l33`<?0`l33`<?0`03o`0P0`l33`<?0`l33`<?
0`l33ol>l@ka3_4>l@ka3_4>l@h3o`0B3_4>l@ka3_4>l@ka3_4>l@ko4=l2oa;O013oWenOGimOWenO
GimOWenO0ol08ImOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOP04o`0ALGiaOW5nLGiaOW5n
LGiaO_l044`3oa5<00?o0000100000H002?oeP?F0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F
0`02o`19eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/?n`3[0>/0j`3[0>/0j`3[0>o`0?g`04omoOoa7O04WoWenOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWenOGioom7kdO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_Co01=<00?oC4`03T`00ol0
000400001P004?l33`<?0`l33`<?0`l33`<4o`0?3`<?0`l33`<?0`l33`<?00;o01033`<?0`l33`<?
0`l33`<?1?l0=@<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@kaoo4>l@ka3_4>l@ka3_4>
l@ko00oO00Cogmoo4Ml0BOnOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaO_l04d`00om<C00>C003o`0000@00006000SomH3eP?F
0mH3eP?F0mH3e_oFomH3eP?F0mH3eP?F0mH3eP<00_l0==H3eP?F0mH3eP?F0mH3eP?o0ol3eP?F0mH3
eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0h3o`0B3[0>/0j`3[0>/0j`3[0>/0ko3ml01?oOgolAg`19
oimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_mnm7kd
O_Anm7kdO_Anm7kdo`0AC0;o4D`00ol0000400001P008ol33`<?0`l33`<?0`l33`?o0ol33`<?0`l3
3`<?0`l33`<?00;o04T33`<?0`l33`<?0`l33`<?o`oo3`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>
l@ka3_4>o`ka3_4>l@ka3_4>l@ka3_4>l@ko00oO00Cogmoo4Ml0BOnOGimOWenOGimOWenOGimOoenO
GimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGkoOW7oLGiaOW5nLGiaOW5nLGiaO_l04d`00om<
C00>C003o`0000@00006000AomH3eP?F0mH3eP?F0mH3eP<00_l04=H3eP?F0mH3eP?F0mH3eP<2o`0A
eP?F0mH3eP?F0mH3eP?F0mH00_l08@?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3P04o`0A
/0j`3[0>/0j`3[0>/0j`3_l04=l2oa;O013oWenOGimOWenOGimOWenO0_l08enOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_An00;o01;dO_Anm7kdO_Anm7kdO_Anm?l@C0?o4D`00ol000040000
1P008ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o04T33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02CO
04WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGko02A<00?o0000100000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0`02o`19eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`0Tg`19oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0TC003o`0000@00006000S
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l0B@<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l09=l0BOnO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaO_l094`00ol0000400001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH300;o04WF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0ko02CO04WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co02A<00?o0000100000H002?o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02o`190`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0Tg`19oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5no`0TC003o`0000@00006000SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<0
0_l0BMH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3_l09=l0BOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l094`00ol0000400001P008ol33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o04T33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02CO04WoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGko02A<00?o0000100000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`19
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>o`0Tg`19oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0TC003o`0000@00006000So`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l0B@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l09=l0BOnOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
94`00ol0000400001P008ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o04WF0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0ko02CO04WoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co02A<00?o0000100000H002?o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`02o`190`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`0Tg`19oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0TC003
o`0000@00006000SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_l0BMH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3_l09=l0BOnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l094`00ol0000400001P008ol33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?00;o04T33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko02CO04WoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko02A<00?o0000
100000H002?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02o`19eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
o`0Tg`19oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdo`0TC003o`0000@000060?oo0Ol600001P000om<C00PC0;o94`0B_l3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[3o8ml0B_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H000?oC4`084`2obA<04[o3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@kaob?O04[oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiao`H000060003oda<021<0_lTC01:o`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?lSg`1:
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_l600001P000om<C00PC0;o94`0B_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o8ml0B_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o1P0000H000?oC4`084`2obA<04[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ob?O04[oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`H0
00060003oda<021<0_lTC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`1:oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl600001P000om<
C00PC0;o94`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml0B_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H000?oC4`084`2obA<
04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@kaob?O04[oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H000060003oda<021<0_lTC01:o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/?lSg`1:oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l600001P000om<C00PC0;o94`0B_l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o
8ml0B_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o1P0000H000?oC4`084`2obA<04[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ob?O04[oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Ano`H000060003oda<021<0_lTC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`1:oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl600001P000om<C00PC0;o94`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml0B_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H0
00?oC4`084`2obA<04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O04[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H000060003oda<021<
0_lTC01:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/?lSg`1:oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l600001P000om<C00=C0?o44`2oa1<
0olAC00Ao`l33`<?0`l33`<?0`l33`<00ol080<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>
0ol04`ka3_4>l@ka3_4>l@ka3_4>lOl04=l2oa7O013oWenOGimOWenOGimOWenO0ol08YmOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW44o`0AOW5nLGiaOW5nLGiaOW5nLOl01P0000H000?oC4`0
44`00om<C00=C0;o4d`00om<C00>C01:o`?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3eP?F0mH3
o`j`3[0>/0j`3[0>/0j`3[0>/?n`3[0>/0j`3[0>/0j`3[0>/?l?g`04omoOoa3O04[oWenOGimOWenO
GimOWenOGomOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kd
O_Ano`H000060003oda<011<00?oC4`03D`2oa=<00?oC4`03T`04?l?0`l33`<?0`l33`<?0`l4o`0f
0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_7ol@ka3_4>l@ka3_4>l@ka3_7o3ml01?oO
gol@g`1:oimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5n
LOmaOW5nLGiaOW5nLGiaOW5nLOl600001P000om<C00>C0;o44`2oa5<0_lAC00do`?F0mH3eP?F0mH3
eP?F0ol3o`?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3P?o01<>/0j`3[0>/0j`3[0>/0j`
3[3o00oO00Cogmoo4=l0B_nOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWoodO_Anm7kd
O_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Anm7ko1P0000H000?oC4`044`00om<C00=C0;o4d`00om<
C00>C01:o`l33`<?0`l33`<?0`l33ol?o`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_l>
l@ka3_4>l@ka3_4>l@ka3_4>lOl?g`04omoOoa3O04[oWenOGimOWenOGimOWenOGomOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLOmaO_mnLGiaOW5nLGiaOW5nLGiao`H000060003oda<00e<
0ol@C0;o44`3oa5<017o0mH3eP?F0mH3eP?F0mH3eP02o`0Q0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`
3[0>/0j`3[0>00Co01:`3[0>/0j`3[0>/0j`3[0>/?l@g`;o4Ml04?nOGimOWenOGimOWenOGil2o`0T
GimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kd0_l04WkdO_Anm7kdO_Anm7kdO_Ano`H0
00060003oda<021<0_lTC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`1:oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl600001P000om<
C00PC0;o94`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml0B_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H000?oC4`084`2obA<
04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@kaob?O04[oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H000060003oda<021<0_lTC01:o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/?lSg`1:oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l600001P000om<C00PC0;o94`0B_l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o
8ml0B_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o1P0000H000?oC4`084`2obA<04[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ob?O04[oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Ano`H000060003oda<021<0_lTC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`1:oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl600001P000om<C00PC0;o94`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml0B_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko1P0000H0
00?oC4`084`2obA<04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O04[oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H000060003oda<021<
0_lTC01:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/?lSg`1:oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l600001P000om<C00PC0;o94`0B_l?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_7o8ml0B_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o1P0000H000?oC4`084`2obA<04[o0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`ob?O04[oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Ano`H000060003oda<021<0_lTC01:o`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`1:
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOl600001P000om<C00PC0;o94`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml0B_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko1P0000H000?oC4`084`2obA<04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`oo3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O04[oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`H0
00060?oo0Ol600001P008omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o02EnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02=<04[o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O02KoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000SooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_l09OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
8d`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[3o8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
1P0000H002?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`0UOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0SC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`0VoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol600001P008oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o02GdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko02=<04[o0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`ob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000S
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l09GiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOl08d`0B_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o8ml09_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo1P0000H002?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02o`0Um7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0SC01:o`?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/?lSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P008omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o02EnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o02=<04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOo`H00006000SooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l09OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l08d`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml09_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H002?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@02o`0UOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0SC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gol600001P008oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o02GdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko02=<04[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ob?O02KoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000SogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW400_l09GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl08d`0B_l?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_7o8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H0
02?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`0Um7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0SC01:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?lSg`0VoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGol600001P008omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGia00;o02EnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02=<04[o3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@kaob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000SooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l09OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l08d`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo1P0000H002?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`0U
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0SC01:o`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`0V
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P004?odO_Anm7kdO_Anm7kd
O_@4o`0?O_Anm7kdO_Anm7kdO_An00;o013dO_Anm7kdO_Anm7kdO_An1?l04OAnm7kdO_Anm7kdO_An
m7ko00m<0olAC00Ao`?F0mH3eP?F0mH3eP?F0mH00ol08MH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>
/0j`3[0>/003o`0B/0j`3[0>/0j`3[0>/0j`3[3o4=l2oa7O017oWenOGimOWenOGimOWenOG`03o`0B
GimOWenOGimOWenOGimOWeoo1P0000H002?oOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5n
L@02o`0UOW5nLGiaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaOW5nLGiao`0BC003oda<00i<04[o3`<?
0`l33`<?0`l33`<?0`oo3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_l>l@ka3_4>
l@ka3_4>l@kao`oO00Cogmoo4=l09_nOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWeoo
1P0000H002?om7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdOP02o`0Um7kdO_Anm7kdO_An
m7kdO_AnogkdO_Anm7kdO_Anm7kdO_Ano`0BC003oda<00i<013o0mH3eP?F0mH3eP?F0mH31?l0=]H3
eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3_l>/0j`3[0>/0j`3[0>/0j`o`oO00Cogmoo
4=l09_nOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWeoo1P0000H002?oOW5nLGiaOW5n
LGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nL@02o`0UOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGia
OW5nLGiao`0@C0;o4D`0=Ol?0`l33`<?0`l33`<?0`oo3ol?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>
l@ka3_4>l@ka00?o01;a3_4>l@ka3_4>l@ka3_4>lOl?g`04omoOoa3O02KoWenOGimOWenOGimOWenO
GiooWenOGimOWenOGimOWenOGimOo`H00006000SooAnm7kdO_Anm7kdO_Anm?odO_mnm7kdO_Anm7kd
O_Anm7h00_l09OAnm7kdO_Anm7kdO_Anm7koO_Com7kdO_Anm7kdO_Anm7kdO_l04T`00om<C00>C01:
o`?F0mH3eP?F0mH3eP?F0ol3o`?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[3o/0j`3[0>
/0j`3[0>/0j`3[0>/?l?g`04omoOoa3O02KoWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenO
GimOo`H00006000AogiaOW5nLGiaOW5nLGiaOW400_l047iaOW5nLGiaOW5nLGiaOW42o`0AOW5nLGia
OW5nLGiaOW5nLGh00_l04W5nLGiaOW5nLGiaOW5nLGiao`m<0olAC00Ao`l33`<?0`l33`<?0`l33`<0
0_l08Pl33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_44o`0A3_4>l@ka3_4>l@ka3_4>lOl0
4=l2oa7O017oWenOGimOWenOGimOWenOG`02o`0CWenOGimOWenOGimOWenOGimOo`0600001P008ood
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o02GdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko02=<04[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ob?O02KoWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOo`H00006000SogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW40
0_l09GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl08d`0B_l?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o
8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H002?om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`0Um7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Ano`0SC01:o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?lSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGol600001P008omnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o02EnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02=<04[o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O02KoWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000SooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7h00_l09OAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
8d`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`3[0>/0j`3[3o8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
1P0000H002?oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nL@02o`0UOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0SC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`0VoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol600001P008oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_An00;o02GdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko02=<04[o0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/0j`3[0>/0j`ob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000S
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW400_l09GiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOl08d`0B_l?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o8ml09_nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo1P0000H002?om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
OP02o`0Um7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0SC01:o`?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>
/?lSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol600001P008omnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia00;o02EnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o02=<04[o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kaob?O02KoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOo`H00006000SooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7h00_l09OAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l08d`0B_l3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o8ml09_nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H002?oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@02o`0UOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0SC01:o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_4>l@ka3_4>lOlSg`0VoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gol600001P008oodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An00;o02GdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko02=<04[o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`ob?O02KoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOo`H00006000SogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW400_l09GiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl08d`0B_l?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>
l@ka3_4>l@ka3_7o8ml09_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo1P0000H0
ool1o`H00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0BImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl094`0BOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl09=l00ol0000400001P008onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimO00;o04VOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko02A<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o02CO00?o0000
100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`19WenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0TC019o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@kao`0Tg`03o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l094`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l09=l00ol000040000
1P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o04VOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02A<
04Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_7o02CO00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOG`02o`19WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0TC019omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`o`0Tg`03o`0000@00006000S
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl094`0BOl3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>lOl09=l00ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimO00;o04VOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7ko02A<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o02CO00?o0000100000H002?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`19WenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0TC019o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@kao`0Tg`03o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0BImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l094`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l09=l00ol0000400001P008onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimO00;o04VOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02A<04Wo0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_7o02CO00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`19
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0TC019omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`o`0Tg`03o`0000@00006000SoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl094`0BOl33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl0
9=l00ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o04VOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7ko02A<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o02CO00?o0000100000H002?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOG`02o`19WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0TC019o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`0Tg`03
o`0000@00006000@oimOWenOGimOWenOGimOW`?o012OGimOWenOGimOWenOGimO0_l049mOWenOGimO
WenOGimOWel3o`0QGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An00Co017dO_Anm7kdO_An
m7kdO_Ano`0?C0?o4T`04OoF0mH3eP?F0mH3eP?F0mH300?o0203eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0?o01:`3[0>/0j`3[0>/0j`3[0>/?lAg`;o4Ml00ol0000400001P008onOGimOWenO
GimOWenOGimOoenOGimOWenOGimOWenOGimO00;o04VOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW7o019<00?oC4`03d`0BOl3
3`<?0`l33`<?0`l33`<?0ol33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ko3_4>l@ka
3_4>l@ka3_4>lOl04=l01?oOgol@g`03o`0000@00006000SoimOWenOGimOWenOGimOWeooGimOWenO
GimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Anm7kdO_l04T`00om<C00?C00@omH3eP?F0mH3eP?F0mH3ePCo
03D3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3_l>/0j`3[0>/0j`3[0>/0j`o`0@g`04
omoOoa3O00?o0000100000H002?oWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOG`02o`19
WenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaO_mnLGia
OW5nLGiaOW5nLGiao`0@C0;o4T`0=?l33`<?0`l33`<?0`l33`?o0ol33`<?0`l33`<?0`l33`<?0ooa
3_4>l@ka3_4>l@ka3_43o`0Bl@ka3_4>l@ka3_4>l@ka3_7o4=l01?oOgol@g`03o`0000@00006000S
oimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7koO_Com7kdO_Anm7kdO_Anm7kdO_l04T`00om<
C00?C019omH3eP?F0mH3eP?F0mH3e_oFomH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/?n`
3[0>/0j`3[0>/0j`3[0>/0j`o`0@g`04omoOoa3O00?o0000100000H0013oWenOGimOWenOGimOWenO
0_l04EnOGimOWenOGimOWenOGimO00;o012OGimOWenOGimOWenOGimO0_l08imOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5n00;o019aOW5nLGiaOW5nLGiaOW5nLOl?C0?o4T`04Ol33`<?0`l3
3`<?0`l33`<?00;o02433`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_401?l04@ka3_4>l@ka
3_4>l@ka3_7o017O0_lAg`03o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWel00_l0BImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l094`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l09=l00ol0000400001P008onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o04VOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02A<04Wo0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_7o02CO00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
G`02o`19WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0TC019omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`o`0Tg`03o`0000@00006000SoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl094`0BOl33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>lOl09=l00ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
04VOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko02A<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[3o02CO00?o0000100000H002?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOG`02o`19WenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0TC019o`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
o`0Tg`03o`0000@00006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0BImO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l094`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/?l09=l00ol0000400001P008onOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o04VOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02A<04Wo0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o02CO
00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`19WenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Ano`0TC019omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`o`0Tg`03o`0000@00006000SoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWel00_l0BImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl094`0BOl33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>lOl09=l00ol0
000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o04VOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko02A<04WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[3o02CO00?o0000100000H002?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOG`02o`19WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0TC019o`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@kao`0Tg`03o`0000@0
0006000SoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0BImOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
94`0BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/?l09=l00ol0000400001P008onOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o04VOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o02A<04Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_7o02CO00?o0000100000H0
02?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOG`02o`19WenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0TC019
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`o`0Tg`03o`0000@000060?oo0Ol600001P000ooOg`0Pg`;o9=l0B_mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<
04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>o`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko
1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003
omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ooOg`0Pg`;o
9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?ogml08=l2obCO04[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003omoO023O0_lTg`1:oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ko1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>o`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l60000
1P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?ogml0
8=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003omoO023O0_lTg`1:
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ooOg`0>g`;o4=l2oa7O0_lAg`0@
oenOGimOWenOGimOWenOG`?o025OWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW401?l04Wia
OW5nLGiaOW5nLGiaOW5no`m<0olAC00Ao`<?0`l33`<?0`l33`<?0`l00ol08@l33`<?0`l33`<?0`l3
3`?ol@ka3_4>l@ka3_4>l@ka3P03o`0B3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?ogml03Ml01?oO
gol?g`;o4=l01?oOgol@g`1:oenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm?lBC003oda<00i<04[oeP?F0mH3eP?F0mH3eP?F
0mKoeP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/?n`3[0>/0j`3[0>/0j`3[0>o`H0
00060003omoO00gO00Cogmoo3ml2oa3O00Cogmoo4=l0B_mOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGko4T`00om<C00>C00@
o`<?0`l33`<?0`l33`<?0`Co03H?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_7ol@ka
3_4>l@ka3_4>l@ka3_l600001P000ooOg`0=g`04omoOo`oO0_l@g`04omoOoa3O04[oGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_An
m7kdoa1<0_lAC00eomH3eP?F0mH3eP?F0mH3e_oFomH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0h00ol04Pj`3[0>/0j`3[0>/0j`3[0>o`H000060003omoO00gO00Cogmoo3ml2oa3O00Cogmoo
4=l0B_mOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW7oLGko
OW5nLGiaOW5nLGiaOW5nLGko4T`00om<C00>C01:o`<?0`l33`<?0`l33`<?0ol3o`<?0`l33`<?0`l3
3`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ko3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ooOg`0>g`;o
4=l2oa7O0_lAg`0@oenOGimOWenOGimOWenOG`;o02>OGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm002o`0CO_Anm7kdO_Anm7kdO_Anm7kdo`0?C0?o4D`04OoF0mH3eP?F0mH3eP?F0mH300;o
02;F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>1?l04K0>/0j`3[0>/0j`3[0>/0ko00H0
00060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ooO
g`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?ogml08=l2obCO
04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003omoO023O0_lTg`1:oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>o`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0
00?ogml08=l2obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003omoO023O
0_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
ok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ooOg`0Pg`;o9=l0B_mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?ogml08=l2obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003omoO023O0_lTg`1:oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_l600001P000ooOg`0Pg`;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0ko1P0000D0ool2o`H000050?oo0_l600001P000ol0000O00?o9=l0B_mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?o00007P001?l0oolTg`1:oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3_l600001P000ol0000M0003o`0000;o9=l0B_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ko1P0000H000?o000070001?l00002obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>o`H000060003o`0001/000?o00000P02obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>o`H000060003o`0001X000?o00000`02obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>o`H000060003o`0001T000?o00001002obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>o`H000060003o`0001P000?o00001@02obCO04[oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>o`H000060003o`0000H00_l00`3oo`0<0003o`0000H00_lTg`1:oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_lSC01:o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_l600001P000ol000070003o`3o00`000?o00001`02obCO04[oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003o`0000P000?o00002P000ol0000800;o
9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa
3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H000?o00001`000ol0o`0:0003
o`0000T00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3_l600001P000ol0000600;o
00<0ool020000ol0000:00;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko1P0000H0
00?o00004P000ol0000;00;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0
00?o00004@000ol0000<00;o4Ml2oa7O013oGimOWenOGimOWenOGimO0ol08EnOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nL@04o`0BOW5nLGiaOW5nLGiaOW5nLGko3d`3oa5<017o0`l33`<?0`l3
3`<?0`l33`03o`0Q3`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>00?o018>l@ka3_4>l@ka
3_4>l@ka3_l600001P000ol0000@0003o`0000d00_l@g`04omoOoa3O04[oGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_Anm7kdoa9<
00?oC4`03T`0B_oF0mH3eP?F0mH3eP?F0mH3e_oF0mH3eP?F0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`
3[0>/0j`ok0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o00003`000ol0000>00;o4=l01?oOgol@g`1:
oenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaog5nLGia
OW5nLGiaOW5nLGiaO_lBC003oda<00i<013o0`l33`<?0`l33`<?0`l31?l0=Pl33`<?0`l33`<?0`l3
3`?ol@ka3_4>l@ka3_4>l@ka3_4>lOoa3_4>l@ka3_4>l@ka3_4>o`H000060003o`0000h000?o0000
3`02oa3O00Cogmoo4=l0B_mOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Co44`2oa5<03GoeP?F0mH3eP?F0mH3eP?FomKoeP?F
0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3P03o`0B3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0
00?o00003@000ol0000@00;o4=l01?oOgol@g`1:oenOGimOWenOGimOWenOGiooWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLOmaO_mnLGiaOW5nLGiaOW5nLGiaO_lBC003oda<00i<04[o0`l3
3`<?0`l33`<?0`l3o`?o0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_l>l@ka3_4>l@ka
3_4>l@ka3_4>o`H000060003o`0000`000?o00001P03o`P00_lAg`;o4Ml04?mOWenOGimOWenOGimO
Wel2o`0SWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_@00_l04gkdO_Anm7kdO_Anm7kd
O_Anm?l03d`3oa5<017oeP?F0mH3eP?F0mH3eP?F0`02o`0ReP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>
/0j`3[0>/0j`3PCo016`3[0>/0j`3[0>/0j`3[0>o`0600001P000ol0000;0003o`0000P000?o0000
1`02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003o`0000X000?o0000
2P000ol0000600;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H000?o0000
2@000ol0000;0003o`0000H00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lSC01:o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3oo4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_l60000
1P000ol000080003o`0000/000?o0?l01`02obCO04[oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdob=<04[oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>o`H000060003o`0000L000?o000030000ol0o`0700;o9=l0B_mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ko1P0000H000?o00001P000ol0000<00;o00<0ool01P02obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003o`0000D000?o00006002obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003o`0000@000?o00006@02obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060003o`0000<000?o00006P02obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nob=<04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>l@ka3_4>o`H000060003o`00008000?o00006`02obCO04[oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdob=<04[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3[0>/0j`3[0>/0j`3[0>o`H000060005o`000?l07P02obCO04[oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nob=<
04[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?ol@ka3_4>l@ka3_4>l@ka3_4>l@ka
3_4>l@ka3_4>l@ka3_4>o`H000060004o`00oal00_lTg`1:oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?lSC01:omH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fok0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`
3[0>/0j`3_l600001P000ol0o`0P00;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko8d`0B_l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0ooa3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ka3_4>l@ko
1P0000H00_lQ00;o9=l0B_mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co8d`0B_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_n`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0j`3[0>/0ko1P0000H0ool1o`H0
000Y00;oh@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l03@000?l0
3@000?l03@000?l03@000?l03@000?l03@0000h00_l:00;oh@03o``0000>0003o`0000X000?o0000
h0000ol0000;00001`04o`<000?o00000`02o`D000?o0000a`02o`030?oo00X000?o000020000ol0
000:000020000ol0o`030003o`00008000Co003o10000ol000380003o`3o00/000?o000020000ol0
000:000020000ol000030003o`00008000Co003o10000ol000390003o`0000P01Ol70003o`3o00/0
00090003o`00008000?o00000P03o`D000?o0000b0000ol0o`0;0003o`0000L000?o0?l02`0000L0
00?o0?l010000ol000020003o`0000D000?o0000a`02o`030?oo00X000?o00001P02o`030?oo00X0
000700Co0`02o`@00ol300;ol0000?l03@000?l03@000?l03@000001\
\>"],
  ImageRangeCache->{{{0, 267.75}, {287, 0}} -> {-1.17504, -0.18925, 
  0.0274513, 0.0274513}},
  CellTags->"Global"],

Cell[BoxData[
    \({{0, 1, 2, 3, 4, 5}, {1, 2, 3, 4, 5, 0}, {2, 3, 4, 5, 0, 1}, {3, 4, 5, 
        0, 1, 2}, {4, 5, 0, 1, 2, 3}, {5, 0, 1, 2, 3, 4}}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Global"]
}, Open  ]],

Cell[TextData[{
  "By adding ",
  StyleBox["Output \[Rule] Graphics", "MR"],
  " to a function when using the ",
  StyleBox["Visual", "MR"],
  " mode, the computational output is suppressed and the graphic becomes the \
output."
}], "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gr1\  = \ 
      CayleyTable[Z[4], \ Mode\  \[Rule] \ Visual, \ 
        Output\  \[Rule] \ Graphics]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Global"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(0)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(2)] .69048 .69286 0 0 Mshowa
[(3)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(2)] .5 .50238 0 0 Mshowa
[(3)] .69048 .50238 0 0 Mshowa
[(0)] .88095 .50238 0 0 Mshowa
[(2)] .30952 .3119 0 0 Mshowa
[(3)] .5 .3119 0 0 Mshowa
[(0)] .69048 .3119 0 0 Mshowa
[(1)] .88095 .3119 0 0 Mshowa
[(3)] .30952 .12143 0 0 Mshowa
[(0)] .5 .12143 0 0 Mshowa
[(1)] .69048 .12143 0 0 Mshowa
[(2)] .88095 .12143 0 0 Mshowa
[(0)] .11905 .69286 0 0 Mshowa
[(1)] .11905 .50238 0 0 Mshowa
[(2)] .11905 .3119 0 0 Mshowa
[(3)] .11905 .12143 0 0 Mshowa
[(0)] .30952 .88333 0 0 Mshowa
[(1)] .5 .88333 0 0 Mshowa
[(2)] .69048 .88333 0 0 Mshowa
[(3)] .88095 .88333 0 0 Mshowa
[(Z[4])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  ImageSize->{261.812, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400045000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P0000H0nOl600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`H000060003oda<02e<0_laC003omoO02oO06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1P0000H000?oC4`0;D`2oc5<00?ogml0
;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00]C0;o
<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`H000060003
oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`H000060003oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00]C0;o<D`00ooOg`0_g`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`H000060003oda<02e<0_laC003
omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1P0000H000?oC4`0
;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l60000
1P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5no`H000060003oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`H000060003oda<02e<0_laC003omoO02oO06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1P0000H000?oC4`0;D`2oc5<00?ogml0
;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l600001P000om<C00]C0;o
<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`H000060003
oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_l600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdo`H000060003oda<01A<0olFC0;o5T`3oaQ<00?ogml05Ml2oaSO01OoGimO
WenOGimOWenOGimOWenOGimOW`03o`0^WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaOW5nL@Co01QnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00GC003oda<01=<
0_lIC003oda<01E<00?ogml05=l01?oOgolGg`1ToenOGimOWenOGimOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdo`H000060003oda<01M<00?oC4`04d`2oaU<00?oC4`05D`00ooOg`0Dg`04omoOoaOO
06CoGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1P0000H000?oC4`05D`2oaI<
0_lGC0;o64`00ooOg`0Dg`04omoOoaOO06CoGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co1P0000H000?oC4`05d`00om<C00CC0;o6D`00om<C00EC003omoO01CO00Cogmoo5ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOmaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00DC0?o5T`2oaI<
0olHC003omoO01GO0_lHg`0GoenOGimOWenOGimOWenOGimOWenOGil00_l0<5nOGimOWenOGimOWenO
GimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Co00H000060003oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGko1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?l600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`H000060003oda<02e<0_laC003omoO02oO06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1P0000H000?oC4`0;D`2oc5<00?ogml0
;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00]C0;o
<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`H000060003
oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko
1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?l600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5no`H000060003oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00]C0;o<D`00ooOg`0_g`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`H000060003oda<02e<0_laC003
omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1P0000H000?oC4`0
;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l60000
1P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5no`H000060003oda<02e<0_laC003omoO02oO06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co1P0000H000?oC4`0;D`2oc5<00?ogml0;ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_l600001P000om<C00]C0;o<D`00ooOg`0_g`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`H000060003oda<02e<0_laC003omoO02oO06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko1P0000H000?oC4`0;D`2oc5<00?ogml0
;ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l600001P000om<C00]C0;o
<D`00ooOg`0_g`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`H000060?Wo
1P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0b
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO
03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003
omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0b
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO
03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_laC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWol01P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0bLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlaC003omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWol01P0000H0033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0bO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003
omoO02kO03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol0
1P0000H0033oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0b
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlaC003omoO02kO
03?oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_laC003omoO02kO03?oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H001OoOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@04o`0EOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01IaOW5nLGiaOW5n
LGiaOW5nLGiaOW5n1?l0675nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaI<0olHC003omoO01GO0_lGg`0G
oimOWenOGimOWenOGimOWenOGimOWel00ol06EnOGimOWenOGimOWenOGimOWenOGimOWol01P0000H0
033om7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0bO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lIC003oda<01E<00?ogml0
5=l01?oOgolFg`0coimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o6D`00om<
C00EC003omoO01CO00Cogmoo5]l0<onOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenO
GimOWenOGimOWenOo`0600001P00<?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kd
O_Anm7kdO_Anm0;o039nm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_AnoaM<0_lHC003omoO01CO00Cogmoo5]l0<onOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenO
GimOWenOGimOWenOGimOWenOo`0600001P00<?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nogiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o039aOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoaU<00?oC4`05D`00ooOg`0Dg`04omoOoaKO03?oWenOGimOWenOGimOWenOGimOWenO
GiooWenOGimOWenOGimOWenOGimOWenOGimOWol01P0000H001Som7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0FO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01Mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`0I
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0FC0?o64`00ooOg`0Eg`;o5ml05onOGimOWenOGimOWenO
GimOWenOGimO00;o01ZOGimOWenOGimOWenOGimOWenOGimOWenOo`H00006000`ogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooO
g`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGioo00H00006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gioo00H00006000`ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooO
g`0^g`0coimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H0
0006000`ooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<Wkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0c
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ooAnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l0<WkdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<D`00ooOg`0^g`0coimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H00006000`ogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0<W5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<D`00ooOg`0^g`0coimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGioo00H000060?Wo1P0000H0033oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOl`C003omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_l`C003omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc1<
00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<4`00ooO
g`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`C003omoO02oO
00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc1<00?ogml0;ml00ol0
000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o
06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<4`00ooOg`0_g`03o`0000@0
0006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`C003omoO02oO00?o0000100000H0
033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc1<00?ogml0;ml00ol0000400001P00<?nO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<4`00ooOg`0_g`03o`0000@00006000`oimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`C003omoO02oO00?o0000100000H0033oWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_l`C003omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOl`C003omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc1<
00?ogml0;ml00ol0000400001P005onOGimOWenOGimOWenOGimOWenOGimO00?o01IOWenOGimOWenO
GimOWenOGimOWenO0_l05UnOGimOWenOGimOWenOGimOWenOGil3o`0_WenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh01?l0675nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaI<
0olGC003omoO01GO0_lHg`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOoimOWenO
GimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lIC003oda<01A<00?ogml05=l01?oOgolGg`03o`0000@00006000`oimOWenOGimOWenOGimOWenO
GimOWenOoimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOoenO
GimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLOlIC003oda<01A<00?ogml05=l01?oOgolGg`03o`0000@00006000`oimOWenO
GimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenO
GimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lGC0;o5d`00ooOg`0Dg`04omoOoaOO00?o0000100000H0
033oWenOGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenO
GimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nogiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaU<00?oC4`054`00ooOg`0Dg`04omoOoaOO
00?o0000100000H001OoWenOGimOWenOGimOWenOGimOWenOG`02o`0GWenOGimOWenOGimOWenOGimO
WenOGil00_l05UnOGimOWenOGimOWenOGimOWenOGil2o`0aGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdOP02o`0Im7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0FC0?o
5d`00ooOg`0Eg`;o6=l00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`C003
omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc1<00?ogml0
;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<4`00ooOg`0_g`03
o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`C003omoO02oO00?o0000
100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1T
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc1<00?ogml0;ml00ol000040000
1P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o06AOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<4`00ooOg`0_g`03o`0000@00006000`
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`C003omoO02oO00?o0000100000H0033oWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOl`C003omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_Anoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_l`C003omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoc1<00?ogml0;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
<4`00ooOg`0_g`03o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenO0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl`C003
omoO02oO00?o0000100000H0033oWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGil2o`1TGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoc1<00?ogml0
;ml00ol0000400001P00<?nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOW`;o06AOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o<4`00ooOg`0_g`03
o`0000@00006000`oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
0_l0I5nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l`C003omoO02oO00?o0000
100000H0nOl600001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO0_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0
;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol000040000
1P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003
o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000
100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1T
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0
;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@000060003omoO01GO0_lFg`;o5ml2oaSO01OoGimOWenOGimOWenOGimOWenOGimOW`03o`0_
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@01?l05gkdO_Anm7kd
O_Anm7kdO_Anm7kdO_Co01I<0olHC003o`0000@000060003omoO01CO00Cogmoo5Ml2oaKO00Cogmoo
5ml0I?mOWenOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_lIC003oda<01E<00?o0000
100000H000?ogml05=l01?oOgolEg`;o5]l01?oOgolGg`1ToenOGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdoaU<00?oC4`05D`00ol0000400001P000ooOg`0Dg`04omoOoaGO0_lFg`04
omoOoaOO06CoGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGoma
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW5nLGiaOW5nLGko5d`2oaQ<00?o0000
100000H000?ogml05=l01?oOgolEg`;o5]l01?oOgolGg`1ToenOGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_mnm7kdO_An
m7kdO_Anm7kdO_Anm7kdoaU<00?oC4`05D`00ol0000400001P000ooOg`0Eg`;o5]l2oaOO0_lHg`0G
oenOGimOWenOGimOWenOGimOWenOGil00_l0<EnOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW400_l067iaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaI<0olHC003o`0000@0
00060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<
00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H0
00?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0
000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooO
g`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@0
00060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<
00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_laC003o`0000@000060003omoO02gO0_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?ogml0;Ml2oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ooOg`0]g`;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000050?[o1P0000D0
n_l600001P000ol0000]00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_laC003o`0000@000060003o`0002`00olag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000?o0000:`001?l0oolag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o0000:P000ol00002oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0000Y0004
o`0000;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003o`0002P000?o00000P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co<D`00ol0000400001P000ol0000W0003o`0000<00_lag`1ToenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000?o00009P000ol0000400;o<Ml0I?mO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0002D0
00?o00001@02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0
000400001P000ol0000T0003o`0000H00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000?o00008`000ol0000700;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`00028000?o00002002oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0
000;00;o00<0ool04@000ol0000900;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003o`0000`000?o0?l04@000ol0000:00;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000d000?o0000
3`000ol0000;00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@000060003o`0000`000?o0?l03`000ol0000<00;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000/00_l00`3oo`0=0003o`0000d0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H0
00?o000070000ol0000>00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?laC003o`0000@000060003o`0001/000?o00003`02oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000J0003o`0001000_lag`1ToenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H000?o00006@000ol0
000A00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0
00060003o`0001P000?o00004P02oaOO0_lHg`0GoenOGimOWenOGimOWenOGimOWenOGil00ol0;imO
WenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00Co01Mnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0FC0?o64`00ol0000400001P000ol0000G0003o`0001<00_lFg`04omoOoaOO
06CoGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko6D`00om<C00EC003o`0000@0
00060003o`0001H000?o00005002oaKO00Cogmoo5ml0I?mOWenOGimOWenOGimOWenOGimOWenOGomO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lIC003oda<01E<00?o0000100000H000?o00005@000ol0000E00;o5]l01?oO
golGg`1ToenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWeooLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLGiaOW5nLGiaOW5noaM<0_lHC003o`0000@0
00060003o`0001@000?o00005P02oaKO00Cogmoo5ml0I?mOWenOGimOWenOGimOWenOGimOWenOGomO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Com7koO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?lIC003oda<01E<00?o0000100000H000?o00004`000ol0000G00;o5ml2oaSO
01OoGimOWenOGimOWenOGimOWenOGimOW`02o`0aGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nL@02o`0HOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko5T`3oaQ<00?o0000
100000H000?o00004P000ol0000H00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?laC003o`0000@000060003o`00014000?o00006@02oc7O06CoGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol0000@0003o`0000`00ol;00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003
o`0000l000?o00003P000ol0000:00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaO_laC003o`0000@000060003o`0000h000?o000040000ol0000900;o<Ml0I?mOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000d000?o0000
4@000ol0000900;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003
o`0000@000060003o`0000`000?o00004@000ol0o`0:00;o<Ml0I?mOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000/000?o00004P000ol0o`0:00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003
o`0000X000?o00004P02o`030?oo00T00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdoc5<00?o0000100000H000?o00002@000ol0000Q00;o<Ml0I?mOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@000060003o`0000P000?o00008P02oc7O
06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0
00070003o`0002<00_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<
00?o0000100000H000?o00001P000ol0000T00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?laC003o`0000@000060003o`0000D000?o00009@02oc7O06CoGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko<D`00ol0000400001P000ol000040003o`0002H0
0_lag`1ToenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoc5<00?o0000100000H0
00?o00000`000ol0000W00;o<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
O_laC003o`0000@000060003o`00008000?o0000:002oc7O06CoGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P001Ol0003o02/00_lag`1ToenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noc5<00?o0000100000H000Co003o;002oc7O06CoGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol0000400001P000ol0o`0]00;o
<Ml0I?mOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_laC003o`0000@0000600;o
;P02oc7O06CoGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGomn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co<D`00ol000040000
1P3io`H0000f00;oc@000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l01P000?l0
1P000?l01P0000h00_l:00;ofP03o``0000>0003o`0000X000?o0000f@000ol0000;00001`04o`<0
00?o00000`03o`@000?o0000`002o`030?oo00X000?o000020000ol0000:000020000ol0o`030003
o`0000@000?o00000`000ol000310003o`3o00/000?o000020000ol0000:000020000ol000030003
o`0000801?l40003o`000<8000?o00002005o`L000?o0?l02`0000T000?o00000P000ol000020003
o`3o00D000?o0000`@000ol0o`0;0003o`0000L000?o0?l02`0000L000?o0?l010000ol000020003
o`3o00D000?o0000`002o`030?oo00X000?o00001P02o`030?oo00X0000700Co0`02o`@00_l400;o
j@000?l01P000?l01P000?l01P000001\
\>"],
  ImageRangeCache->{{{0, 260.812}, {287, 0}} -> {-1.12503, -0.138599, 
  0.0201296, 0.0201296}},
  CellTags->"Global"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Global"]
}, Open  ]],

Cell[TextData[{
  "Now this graphic image can be used along side another graphic using ",
  StyleBox["GraphicsArray", "MR"],
  "."
}], "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{

Cell[BoxData[
    \(gr2\  = \ 
      LeftCosets[Z[8], {0, 4}, \ Mode\  \[Rule] \ Visual, \ 
        Output\  \[Rule] \ Graphics, \ DisplayFunction\  \[Rule] \ Identity]; 
    \nShow[GraphicsArray[{gr1, \ gr2}], \ 
      DisplayFunction\  \[Rule] \ $DisplayFunction]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Global"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .52381 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0124717 0.47619 [
[ 0 0 0 0 ]
[ 1 .52381 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .52381 L
0 .52381 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0124717 0.477324 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(0)] .30952 .69286 0 0 Mshowa
[(1)] .5 .69286 0 0 Mshowa
[(2)] .69048 .69286 0 0 Mshowa
[(3)] .88095 .69286 0 0 Mshowa
[(1)] .30952 .50238 0 0 Mshowa
[(2)] .5 .50238 0 0 Mshowa
[(3)] .69048 .50238 0 0 Mshowa
[(0)] .88095 .50238 0 0 Mshowa
[(2)] .30952 .3119 0 0 Mshowa
[(3)] .5 .3119 0 0 Mshowa
[(0)] .69048 .3119 0 0 Mshowa
[(1)] .88095 .3119 0 0 Mshowa
[(3)] .30952 .12143 0 0 Mshowa
[(0)] .5 .12143 0 0 Mshowa
[(1)] .69048 .12143 0 0 Mshowa
[(2)] .88095 .12143 0 0 Mshowa
[(0)] .11905 .69286 0 0 Mshowa
[(1)] .11905 .50238 0 0 Mshowa
[(2)] .11905 .3119 0 0 Mshowa
[(3)] .11905 .12143 0 0 Mshowa
[(0)] .30952 .88333 0 0 Mshowa
[(1)] .5 .88333 0 0 Mshowa
[(2)] .69048 .88333 0 0 Mshowa
[(3)] .88095 .88333 0 0 Mshowa
[(Z[4])] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0124717 0.97619 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.12963 0.10582 0.0251323 0.10582 [
[ 0 0 0 0 ]
[ 1 1.05556 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.05556 L
0 1.05556 L
closepath
clip
newpath
1 1 0 r
.12963 .76587 m
.12963 .87169 L
.23545 .87169 L
.23545 .76587 L
F
.23545 .66005 m
.23545 .76587 L
.34127 .76587 L
.34127 .66005 L
F
.87037 .55423 m
.87037 .66005 L
.97619 .66005 L
.97619 .55423 L
F
.76455 .44841 m
.76455 .55423 L
.87037 .55423 L
.87037 .44841 L
F
.65873 .34259 m
.65873 .44841 L
.76455 .44841 L
.76455 .34259 L
F
.55291 .23677 m
.55291 .34259 L
.65873 .34259 L
.65873 .23677 L
F
.44709 .13095 m
.44709 .23677 L
.55291 .23677 L
.55291 .13095 L
F
.34127 .02513 m
.34127 .13095 L
.44709 .13095 L
.44709 .02513 L
F
.23545 .76587 m
.23545 .87169 L
.34127 .87169 L
.34127 .76587 L
F
.12963 .66005 m
.12963 .76587 L
.23545 .76587 L
.23545 .66005 L
F
.76455 .55423 m
.76455 .66005 L
.87037 .66005 L
.87037 .55423 L
F
.87037 .44841 m
.87037 .55423 L
.97619 .55423 L
.97619 .44841 L
F
.55291 .34259 m
.55291 .44841 L
.65873 .44841 L
.65873 .34259 L
F
.65873 .23677 m
.65873 .34259 L
.76455 .34259 L
.76455 .23677 L
F
.34127 .13095 m
.34127 .23677 L
.44709 .23677 L
.44709 .13095 L
F
.44709 .02513 m
.44709 .13095 L
.55291 .13095 L
.55291 .02513 L
F
1 .5 0 r
.34127 .76587 m
.34127 .87169 L
.44709 .87169 L
.44709 .76587 L
F
.44709 .66005 m
.44709 .76587 L
.55291 .76587 L
.55291 .66005 L
F
.12963 .55423 m
.12963 .66005 L
.23545 .66005 L
.23545 .55423 L
F
.23545 .44841 m
.23545 .55423 L
.34127 .55423 L
.34127 .44841 L
F
.87037 .34259 m
.87037 .44841 L
.97619 .44841 L
.97619 .34259 L
F
.76455 .23677 m
.76455 .34259 L
.87037 .34259 L
.87037 .23677 L
F
.65873 .13095 m
.65873 .23677 L
.76455 .23677 L
.76455 .13095 L
F
.55291 .02513 m
.55291 .13095 L
.65873 .13095 L
.65873 .02513 L
F
.44709 .76587 m
.44709 .87169 L
.55291 .87169 L
.55291 .76587 L
F
.34127 .66005 m
.34127 .76587 L
.44709 .76587 L
.44709 .66005 L
F
.23545 .55423 m
.23545 .66005 L
.34127 .66005 L
.34127 .55423 L
F
.12963 .44841 m
.12963 .55423 L
.23545 .55423 L
.23545 .44841 L
F
.76455 .34259 m
.76455 .44841 L
.87037 .44841 L
.87037 .34259 L
F
.87037 .23677 m
.87037 .34259 L
.97619 .34259 L
.97619 .23677 L
F
.55291 .13095 m
.55291 .23677 L
.65873 .23677 L
.65873 .13095 L
F
.65873 .02513 m
.65873 .13095 L
.76455 .13095 L
.76455 .02513 L
F
.56 .37 .6 r
.55291 .76587 m
.55291 .87169 L
.65873 .87169 L
.65873 .76587 L
F
.65873 .66005 m
.65873 .76587 L
.76455 .76587 L
.76455 .66005 L
F
.34127 .55423 m
.34127 .66005 L
.44709 .66005 L
.44709 .55423 L
F
.44709 .44841 m
.44709 .55423 L
.55291 .55423 L
.55291 .44841 L
F
.12963 .34259 m
.12963 .44841 L
.23545 .44841 L
.23545 .34259 L
F
.23545 .23677 m
.23545 .34259 L
.34127 .34259 L
.34127 .23677 L
F
.87037 .13095 m
.87037 .23677 L
.97619 .23677 L
.97619 .13095 L
F
.76455 .02513 m
.76455 .13095 L
.87037 .13095 L
.87037 .02513 L
F
.65873 .76587 m
.65873 .87169 L
.76455 .87169 L
.76455 .76587 L
F
.55291 .66005 m
.55291 .76587 L
.65873 .76587 L
.65873 .66005 L
F
.44709 .55423 m
.44709 .66005 L
.55291 .66005 L
.55291 .55423 L
F
.34127 .44841 m
.34127 .55423 L
.44709 .55423 L
.44709 .44841 L
F
.23545 .34259 m
.23545 .44841 L
.34127 .44841 L
.34127 .34259 L
F
.12963 .23677 m
.12963 .34259 L
.23545 .34259 L
.23545 .23677 L
F
.76455 .13095 m
.76455 .23677 L
.87037 .23677 L
.87037 .13095 L
F
.87037 .02513 m
.87037 .13095 L
.97619 .13095 L
.97619 .02513 L
F
0 0 1 r
.76455 .76587 m
.76455 .87169 L
.87037 .87169 L
.87037 .76587 L
F
.87037 .66005 m
.87037 .76587 L
.97619 .76587 L
.97619 .66005 L
F
.55291 .55423 m
.55291 .66005 L
.65873 .66005 L
.65873 .55423 L
F
.65873 .44841 m
.65873 .55423 L
.76455 .55423 L
.76455 .44841 L
F
.34127 .34259 m
.34127 .44841 L
.44709 .44841 L
.44709 .34259 L
F
.44709 .23677 m
.44709 .34259 L
.55291 .34259 L
.55291 .23677 L
F
.12963 .13095 m
.12963 .23677 L
.23545 .23677 L
.23545 .13095 L
F
.23545 .02513 m
.23545 .13095 L
.34127 .13095 L
.34127 .02513 L
F
.87037 .76587 m
.87037 .87169 L
.97619 .87169 L
.97619 .76587 L
F
.76455 .66005 m
.76455 .76587 L
.87037 .76587 L
.87037 .66005 L
F
.65873 .55423 m
.65873 .66005 L
.76455 .66005 L
.76455 .55423 L
F
.55291 .44841 m
.55291 .55423 L
.65873 .55423 L
.65873 .44841 L
F
.44709 .34259 m
.44709 .44841 L
.55291 .44841 L
.55291 .34259 L
F
.34127 .23677 m
.34127 .34259 L
.44709 .34259 L
.44709 .23677 L
F
.23545 .13095 m
.23545 .23677 L
.34127 .23677 L
.34127 .13095 L
F
.12963 .02513 m
.12963 .13095 L
.23545 .13095 L
.23545 .02513 L
F
1 1 0 r
.12963 .87169 m
.12963 .97751 L
.23545 .97751 L
.23545 .87169 L
F
.23545 .87169 m
.23545 .97751 L
.34127 .97751 L
.34127 .87169 L
F
1 .5 0 r
.34127 .87169 m
.34127 .97751 L
.44709 .97751 L
.44709 .87169 L
F
.44709 .87169 m
.44709 .97751 L
.55291 .97751 L
.55291 .87169 L
F
.56 .37 .6 r
.55291 .87169 m
.55291 .97751 L
.65873 .97751 L
.65873 .87169 L
F
.65873 .87169 m
.65873 .97751 L
.76455 .97751 L
.76455 .87169 L
F
0 0 1 r
.76455 .87169 m
.76455 .97751 L
.87037 .97751 L
.87037 .87169 L
F
.87037 .87169 m
.87037 .97751 L
.97619 .97751 L
.97619 .87169 L
F
1 1 0 r
.02381 .76587 m
.02381 .87169 L
.12963 .87169 L
.12963 .76587 L
F
.02381 .66005 m
.02381 .76587 L
.12963 .76587 L
.12963 .66005 L
F
1 .5 0 r
.02381 .55423 m
.02381 .66005 L
.12963 .66005 L
.12963 .55423 L
F
.02381 .44841 m
.02381 .55423 L
.12963 .55423 L
.12963 .44841 L
F
.56 .37 .6 r
.02381 .34259 m
.02381 .44841 L
.12963 .44841 L
.12963 .34259 L
F
.02381 .23677 m
.02381 .34259 L
.12963 .34259 L
.12963 .23677 L
F
0 0 1 r
.02381 .13095 m
.02381 .23677 L
.12963 .23677 L
.12963 .13095 L
F
.02381 .02513 m
.02381 .13095 L
.12963 .13095 L
.12963 .02513 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02513 m
.02381 .97751 L
s
.02381 .02513 m
.97619 .02513 L
s
.02381 .13095 m
.97619 .13095 L
s
.02381 .23677 m
.97619 .23677 L
s
.02381 .34259 m
.97619 .34259 L
s
.02381 .44841 m
.97619 .44841 L
s
.02381 .55423 m
.97619 .55423 L
s
.02381 .66005 m
.97619 .66005 L
s
.02381 .76587 m
.97619 .76587 L
s
.02381 .87169 m
.97619 .87169 L
s
.02381 .97751 m
.97619 .97751 L
s
.12963 .02513 m
.12963 .97751 L
s
.23545 .02513 m
.23545 .97751 L
s
.34127 .02513 m
.34127 .97751 L
s
.44709 .02513 m
.44709 .97751 L
s
.55291 .02513 m
.55291 .97751 L
s
.65873 .02513 m
.65873 .97751 L
s
.76455 .02513 m
.76455 .97751 L
s
.87037 .02513 m
.87037 .97751 L
s
.97619 .02513 m
.97619 .97751 L
s
.02381 .97751 m
.12963 .87169 L
s
2.6 Mabswid
.12963 .02513 m
.12963 .97751 L
s
.02381 .87169 m
.97619 .87169 L
s
[(0)] .18254 .81878 0 0 Mshowa
[(4)] .28836 .81878 0 0 Mshowa
[(1)] .39418 .81878 0 0 Mshowa
[(5)] .5 .81878 0 0 Mshowa
[(2)] .60582 .81878 0 0 Mshowa
[(6)] .71164 .81878 0 0 Mshowa
[(3)] .81746 .81878 0 0 Mshowa
[(7)] .92328 .81878 0 0 Mshowa
[(4)] .18254 .71296 0 0 Mshowa
[(0)] .28836 .71296 0 0 Mshowa
[(5)] .39418 .71296 0 0 Mshowa
[(1)] .5 .71296 0 0 Mshowa
[(6)] .60582 .71296 0 0 Mshowa
[(2)] .71164 .71296 0 0 Mshowa
[(7)] .81746 .71296 0 0 Mshowa
[(3)] .92328 .71296 0 0 Mshowa
[(1)] .18254 .60714 0 0 Mshowa
[(5)] .28836 .60714 0 0 Mshowa
[(2)] .39418 .60714 0 0 Mshowa
[(6)] .5 .60714 0 0 Mshowa
[(3)] .60582 .60714 0 0 Mshowa
[(7)] .71164 .60714 0 0 Mshowa
[(4)] .81746 .60714 0 0 Mshowa
[(0)] .92328 .60714 0 0 Mshowa
[(5)] .18254 .50132 0 0 Mshowa
[(1)] .28836 .50132 0 0 Mshowa
[(6)] .39418 .50132 0 0 Mshowa
[(2)] .5 .50132 0 0 Mshowa
[(7)] .60582 .50132 0 0 Mshowa
[(3)] .71164 .50132 0 0 Mshowa
[(0)] .81746 .50132 0 0 Mshowa
[(4)] .92328 .50132 0 0 Mshowa
[(2)] .18254 .3955 0 0 Mshowa
[(6)] .28836 .3955 0 0 Mshowa
[(3)] .39418 .3955 0 0 Mshowa
[(7)] .5 .3955 0 0 Mshowa
[(4)] .60582 .3955 0 0 Mshowa
[(0)] .71164 .3955 0 0 Mshowa
[(5)] .81746 .3955 0 0 Mshowa
[(1)] .92328 .3955 0 0 Mshowa
[(6)] .18254 .28968 0 0 Mshowa
[(2)] .28836 .28968 0 0 Mshowa
[(7)] .39418 .28968 0 0 Mshowa
[(3)] .5 .28968 0 0 Mshowa
[(0)] .60582 .28968 0 0 Mshowa
[(4)] .71164 .28968 0 0 Mshowa
[(1)] .81746 .28968 0 0 Mshowa
[(5)] .92328 .28968 0 0 Mshowa
[(3)] .18254 .18386 0 0 Mshowa
[(7)] .28836 .18386 0 0 Mshowa
[(4)] .39418 .18386 0 0 Mshowa
[(0)] .5 .18386 0 0 Mshowa
[(5)] .60582 .18386 0 0 Mshowa
[(1)] .71164 .18386 0 0 Mshowa
[(6)] .81746 .18386 0 0 Mshowa
[(2)] .92328 .18386 0 0 Mshowa
[(7)] .18254 .07804 0 0 Mshowa
[(3)] .28836 .07804 0 0 Mshowa
[(0)] .39418 .07804 0 0 Mshowa
[(4)] .5 .07804 0 0 Mshowa
[(1)] .60582 .07804 0 0 Mshowa
[(5)] .71164 .07804 0 0 Mshowa
[(2)] .81746 .07804 0 0 Mshowa
[(6)] .92328 .07804 0 0 Mshowa
[(0)] .07672 .81878 0 0 Mshowa
[(4)] .07672 .71296 0 0 Mshowa
[(1)] .07672 .60714 0 0 Mshowa
[(5)] .07672 .50132 0 0 Mshowa
[(2)] .07672 .3955 0 0 Mshowa
[(6)] .07672 .28968 0 0 Mshowa
[(3)] .07672 .18386 0 0 Mshowa
[(7)] .07672 .07804 0 0 Mshowa
[(0)] .18254 .9246 0 0 Mshowa
[(4)] .28836 .9246 0 0 Mshowa
[(1)] .39418 .9246 0 0 Mshowa
[(5)] .5 .9246 0 0 Mshowa
[(2)] .60582 .9246 0 0 Mshowa
[(6)] .71164 .9246 0 0 Mshowa
[(3)] .81746 .9246 0 0 Mshowa
[(7)] .92328 .9246 0 0 Mshowa
[(Z[8])] .02381 1.03042 -1 0 Mshowa
gsave
.97619 1.03042 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(+) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .05979 .90661 0 0 Mshowa
[(y)] .10317 .94577 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  ImageSize->{288, 150.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000UPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?nJ00002P000om<C00EC0;o5d`00ooOg`0Fg`0boimOWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOnJ00002P000om<C00EC0;o5d`00ooO
g`0Fg`0boimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC07co
2`0000X000?oC4`05D`2oaM<00?ogml05]l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW7o4`000om<C009C0;o3D`00om<C00;C003omoO00[O00?ogml02ml0>?mO
WenOGimOWenOGimOoenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGko2`0000X0
00?oC4`05D`2oaM<00?ogml05]l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7ko4`000om<C009C0;o3D`00om<C00;C003omoO00[O00?ogml02ml0>?mOWenOGimO
WenOGimOoenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co2`0000X000?oC4`0
5D`2oaM<00?ogml05]l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5n
LGiaOW7o4`000om<C009C0;o3D`00om<C00;C003omoO00[O00?ogml02ml0>?mOWenOGimOWenOGimO
oenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGko2`0000X000?oC4`05D`2oaM<
00?ogml05]l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
4`000om<C009C0;o3D`00om<C00;C003omoO00[O00?ogml02ml0>?mOWenOGimOWenOGimOoenOGimO
WenOGimOWeooO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co2`0000X000?oC4`05D`2oaM<00?ogml0
5]l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000om<
C002C003oda<00A<0_l5C003oda<00E<00?oC4`00T`3o`I<00?ogml00ml2o`GO00?ogml00ml3o`GO
00GoGimOW`03o`0;WenOGimOoenOGil00ol02imOWenOGomaOW5n00Co00YaOW5nogiaOW5n0_l01g5n
LGiaO_l02`0000X000?oC4`05D`2oaM<00?ogml05]l0<_nOGimOWenOGimOWenOGimOWenOGimOWeoo
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`000om<C002C003oda<00A<0_l5C003oda<00E<00?oC4`0
1D`00om<C003C003omoO00;O00Cogmoo1=l00ooOg`04g`03omoO00CO03SoGimOWeooGimOWenOGomO
WenOGimOoenOGimOogkdO_AnogkdO_Anm?odO_AnogkdooAnm7kdo`/0000:0003oda<01E<0_lGC003
omoO01KO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<0
00?oC4`00d`00om<C003C0;o1T`00om<C004C003oda<00E<00?oC4`00d`00ooOg`02g`04omoOo`CO
00?ogml00]l4o`GO03SoGimOWeooGimOWenOGomOWenOGimOoenOGimOog5nLGiaO_mnLGiaO_mnLGia
og5nogiaOW5no`/0000:0003oda<00M<0ol;C0;o2D`3o`]<00?ogml02Ml2o`_O00[oWenOGimOWenO
0ol05YmOWenOGimOWenOGomnm7kdO_Anm7h4o`0;m7kdO_Anm7kdO_l04`000om<C003C003oda<00=<
0_l6C003oda<00A<00?oC4`00d`2o`I<00?ogml00]l01?oOgol4g`03omoO00;O00?ogol01]l04omO
WenOGomOWenOGimOoenOGil00ol069mOWenOGomnm7kdO_AnogkdO_Com7kdOP?o00Mnm7kdO_Co00/0
000:0003oda<00Y<00?oC4`024`2o`a<00?oC4`024`00ooOg`08g`04omoOo`[O03;oWenOGimOWenO
GomOWenOGimOWenOGimOog5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaoa<000?oC4`014`00om<C002C0;o
1d`00om<C003C003oda<00E<00?oC4`00d`00ooOg`02g`04omoOo`CO00?ogml00]l00ooOo`06g`0h
oenOGimOoenOGimOWeooGimOWonOGimOWenOGomaOW5nogiaog5nLGkoOW5nLOmaOW5nLGiaO_l;0000
2P000om<C00:C003oda<00Q<0_l<C003oda<00Q<00?ogml02=l01?oOgol:g`0boimOWenOGimOWeoo
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_lC0004oda<C0Co14`2o`A<1?l5C003
oda<009<0ol6C003omoO00?O0_l5g`03omoO00?O0_l6g`05oenOGil00_l035nOGimOWeooGimOW`Co
00]OWenOGomnm7kdOP02o`0;m7kdO_Com7kdO_@00ol01_Anm7kdo`/0000:0003oda<00Q<0_l;C0;o
2T`2o`]<00?ogml02=l01?oOgol:g`0boimOWenOGimOWeooGimOWenOGimOWenOGomaOW5nLGiaOW5n
LGkoOW5nLGiaOW5nLOlC0003oda<00U<0_l=C003oda<00]<00?ogml02]l00ooOg`0;g`0hoenOGimO
WenOGimOWeooGimOWenOGimOWenOGomaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_l;00002P000om<
C00:C003oda<00Q<0_l<C003oda<00Q<00?ogml02=l01?oOgol:g`0boimOWenOGimOWeooGimOWenO
GimOWenOGomnm7kdO_Anm7koO_Com7kdO_Anm7kdO_lC0003oda<00U<0_l=C003oda<00]<00?ogml0
2]l00ooOg`0;g`0hoenOGimOWenOGimOWeooGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Com7kdO_An
m7kdO_Anm?l;00002P000om<C007C0?o2d`2o`U<0ol;C003omoO00WO0_l;g`0:oimOWenOGimOW`;o
01QOWenOGimOWenOGimOog5nLGiaOW5nLGh2o`0<LGiaOW5nLGiaOW7o4`000om<C009C0;o3D`00om<
C00;C003omoO00[O00?ogml02ml0>?mOWenOGimOWenOGimOoenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nogiaOW5nLGiaOW5nLGko2`0000X000?oC4`05D`2oaM<00?ogml05]l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko4`1lo`/0000:0003oda<01E<0_lGC003
omoO01KO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<0
00?oC4`02D`2o`e<00?oC4`02d`00ooOg`0:g`03omoO00_O03SoGimOWenOGimOWenOGomOWenOGimO
WenOGimOog5nLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW5no`/0000:0003oda<01E<0_lGC003omoO01KO
03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?oC4`0
2D`2o`e<00?oC4`02d`00ooOg`0:g`03omoO00_O03SoGimOWenOGimOWenOGomOWenOGimOWenOGimO
ogkdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdo`/0000:0003oda<01E<0_lGC003omoO01KO03;oWenO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000?oC4`02D`2o`e<
00?oC4`02d`00ooOg`0:g`03omoO00_O03SoGimOWenOGimOWenOGomOWenOGimOWenOGimOog5nLGia
OW5nLGiaO_mnLGiaOW5nLGiaOW5no`/0000:0003oda<01E<0_lGC003omoO01KO03;oWenOGimOWenO
GimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anoa<000?oC4`02D`2o`e<00?oC4`0
2d`00ooOg`0:g`03omoO00_O03SoGimOWenOGimOWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_An
m?odO_Anm7kdO_Anm7kdo`/0000:0003oda<01E<0_lGC003omoO01KO03;oWenOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoa<000CoC4a<0ol5C0;o14`3o`I<00?oC4`0
0d`00om<C005C003omoO00?O0ol4g`03omoO00?O0_l6g`05oenOGil00ol02imOWenOGomOWenO00?o
00bOGimOWeooLGiaOW42o`0:OW5nLGkoOW5nL@Co00InLGiaO_l;00002P000om<C00EC0;o5d`00ooO
g`0Fg`0boimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lC0003
oda<00A<00?oC4`00T`2o`M<00?oC4`00d`00om<C003C003oda<00E<00?ogml01=l00ooOg`03g`03
omoO00;O00Cogmoo1Ml0>?mOWenOGimOoenOGimOoenOGimOoenOGimOWeooO_Anm?odO_mnm7kdooAn
m7kdooAnm7kdO_Co2`0000X000?oC4`05D`2oaM<00?ogml05]l0<_nOGimOWenOGimOWenOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o4`000om<C004C003oda<009<0_l7C003oda<00=<
00?oC4`014`00om<C004C003omoO00;O1?l4g`03omoO00;O00Cogmoo1Ml0>?mOWenOGimOoenOGimO
oenOGimOoenOGimOWeooLGiaO_mnLOmaOW5nogiaOW5nLOmaOW5nLGko2`0000X0O?lC0003oda<009<
0_l5C0;o1D`2o`I<00?oC4`014`00om<C004C003omoO00;O00?ogol01Ml00ooOg`02g`04omoOo`GO
00GoGimOW`03o`0IWenOGimOoenOGimOoenOGimOWeooO_Anm003o`0Dm7kdO_Com7kdO_Anm?odO_An
m?l;00002P006?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LOlHC003omoO01KO01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<000?oC4`014`00om<C002C0;o
1d`00om<C003C003oda<00E<00?oC4`00d`00ooOg`02g`03omoo00GO00?ogml00]l01?oOgol5g`0h
oenOGiooWenOGimOWeooGimOWeooGimOWenOGomaOW5nogiaOW5nLGkoOW5nLOmaO_mnLGiaO_l;0000
2P006?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01Qnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003
omoO01KO01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<000CoC4a<0ol5C0;o14`3o`I<00?oC4`0
0T`4o`E<00?ogml00ml2o`GO00?ogml00ml2o`KO00GoGimOW`04o`0:GimOWeooGimOW`;o00eOWenO
GimOogkdO_An00?o00Ynm7kdooAnm7kd0_l01gkdO_Anm?l02`0000X001SoOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ooOg`0Fg`0IoenOGimOWenOGimO
WenOGimOWenOGimOo`0C0003oda<00U<0_l=C003oda<00]<00?ogml02]l00ooOg`0;g`0hoenOGimO
WenOGimOWeooGimOWenOGimOWenOGomaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_l;00002P006?od
O_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01Qnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003omoO01KO
01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<000?oC4`02D`2o`e<00?oC4`02d`00ooOg`0:g`03
omoO00_O03SoGimOWenOGimOWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anm?odO_Anm7kdO_An
m7kdo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0675nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoaQ<00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol04`000om<C009C0;o3D`00om<
C00;C003omoO00[O00?ogml02ml0>?mOWenOGimOWenOGimOoenOGimOWenOGimOWeooLGiaOW5nLGia
OW5nogiaOW5nLGiaOW5nLGko2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C07co
2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000<og5nLGiaOW5nLGia0_l077ia
OW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_l<C003oda<00]<00?ogml02ml00ooOg`0;g`0LoenOGimO
WenOGimOWonOGimOWenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l067kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol0
4`003?mnm7kdO_Anm7kdOP;o01cdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co34`00om<C00;C003
omoO00_O00?ogml02ml07?mOWenOGimOWenOGiooWenOGimOWenOGimOWol;00002P006?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003omoO01KO01WoGimO
WenOGimOWenOGimOWenOGimOWeoo01<000coLGiaOW5nLGiaOW42o`0LOW5nLGiaOW5nLGiaO_mnLGia
OW5nLGiaOW5no`a<00?oC4`02d`00ooOg`0;g`03omoO00_O01coGimOWenOGimOWenOoimOWenOGimO
WenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000<ogkdO_Anm7kdO_An
0_l07?Anm7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm?l<C003oda<00]<00?ogml02ml00ooOg`0;g`0L
oenOGimOWenOGimOWonOGimOWenOGimOWenOo`/0000:000:ogiaOW5nLGiaOPCo00YaOW5nLGiaOW5n
0_l02G5nLGiaOW5nL@04o`0;OW5nLGiaOW5nLOl02T`3o`]<00?ogml02=l2o`cO00[oGimOWenOGimO
0ol035nOGimOWenOGimOoa<000GoLGiaOP02o`05LGiaOW400_l01GiaOW5n00;o00]aOW5nLGkoOW5n
L@04o`06OW5nLGko1D`00om<C004C003oda<009<0ol6C003omoO00?O0_l6g`03omoO00?O0ol5g`05
oenOGil00ol02YmOWenOoimOWel3o`07GimOWenOo`0;00002P006?odO_Anm7kdO_AnogkdO_Anm7kd
O_Anm0;o01Qnm7kdO_Anm7kdooAnm7kdO_Anm7kdO_l=C003oda<00Q<00?ogml01ml01?oOgol;g`0I
oenOGimOWenOGiooWenOGimOWenOGimOo`0C000<ogkdO_mnm?odO_An0_l07?Anm7koO_Com7kdO_Co
m7kdO_Com7kdO_Anm?l5C003oda<00A<00?oC4`01D`00om<C003C003omoO00;O00Cogmoo1Ml00ooO
g`04g`03omoO00CO01coGimOWeooGimOWenOoimOWenOGiooWenOGioo2`0000X001SoOW5nLGiaOW5n
LGkoOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW7o3D`00om<C008C003omoO00OO
00Cogmoo2ml06OmOWenOGimOWenOoimOWenOGimOWenOGol04`003?maOW7oLGkoOW5nL@;o01anLGia
og5nogiaOW5nogiaOW5nLOmaOW5nLGko1T`00om<C003C003oda<00E<00?oC4`00d`00ooOg`02g`04
omoOo`GO00?ogml00]l4o`GO01coGimOWeooGimOWenOoimOWenOGiooWenOGioo2`0000X001Som7kd
O_Anm7kdO_AnogkdO_Anm7kdO_@2o`0HO_Anm7kdO_Anm7kdooAnm7kdO_Anm7ko2d`2o`]<00?ogml0
1ml01?oOgol;g`0IoenOGimOWenOGiooWenOGimOWenOGimOo`0C0004ogkdOP?o00Enm7kdOP02o`04
m7kdOP?o01Enm7kdO_Com7kdO_Anm?odO_Anm?l01T`00om<C003C003oda<00=<0_l6C003omoO00;O
00Cogmoo1Ml00ooOg`02g`03omoo00KO01;oGimOWeooGimOWenOoimOWel3o`07GimOWenOo`0;0000
2P006?mnLGiaOW5nLGkoOW7oLGiaOW5nLGiaOP;o01QaOW5nLGiaOW7oLGkoOW5nLGiaOW5nLOl=C003
oda<00Q<00?ogml01ml01?oOgol;g`0IoenOGimOWenOGiooWenOGimOWenOGimOo`0C000<og5nLOma
OW5nLGia0_l077iaOW7oLGiaOW5nLGkoOW5nLOmaO_mnLGiaO_l7C003oda<009<00?oC4`01D`00om<
C003C003omoO00;O00Cogmoo1Ml00ooOg`02g`03omoo00KO01coGimOWeooGimOWenOoimOWeooGimO
WenOGioo2`0000X000_om7kdO_Anm7kdOP02o`0;m7kdO_Anm7kdO_@00_l02WkdO_Anm7kdO_@2o`0<
O_Anm7kdO_Anm7ko2T`3o`]<00?ogml02=l2o`cO00[oGimOWenOGimO0_l03ImOWenOGimOWenOGol0
4`001Omnm7kd00?o00CdO_An0_l01OAnm7kd00?o00_dO_Anm?odO_Anm002o`07O_Anm7kdo`04C0Co
14`00om<C002C0?o1T`00ooOg`03g`;o1]l00ooOg`03g`;o1]l01OmOWenO00;o00]OWenOGiooWenO
G`04o`06WenOGioo2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000<og5nLGia
OW5nLGia0_l077iaOW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_l<C003oda<00]<00?ogml02ml00ooO
g`0;g`0LoenOGimOWenOGimOWonOGimOWenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimO
WenOGimOWenOGol04`003?mnm7kdO_Anm7kdOP;o01cdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co
34`00om<C00;C003omoO00_O00?ogml02ml07?mOWenOGimOWenOGiooWenOGimOWenOGimOWol;0000
2P006?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003
omoO01KO01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<000coLGiaOW5nLGiaOW42o`0LOW5nLGia
OW5nLGiaO_mnLGiaOW5nLGiaOW5no`a<00?oC4`02d`00ooOg`0;g`03omoO00_O01coGimOWenOGimO
WenOoimOWenOGimOWenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HO_Anm7kd
O_Anm7kdO_Anm7kdO_Anm7ko64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C07co
2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000<og5nLGiaOW5nLGia0_l077ia
OW5nLGiaOW5nLGkoOW5nLGiaOW5nLGiaO_l<C003oda<00]<00?ogml02ml00ooOg`0;g`0LoenOGimO
WenOGimOWonOGimOWenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l067kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol0
4`003?mnm7kdO_Anm7kdOP;o01cdO_Anm7kdO_Anm7kdooAnm7kdO_Anm7kdO_Co34`00om<C00;C003
omoO00_O00?ogml02ml07?mOWenOGimOWenOGiooWenOGimOWenOGimOWol;00002P006?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003omoO01KO01WoGimO
WenOGimOWenOGimOWenOGimOWeoo01<000coLGiaOW5nLGiaOW42o`0LOW5nLGiaOW5nLGiaO_mnLGia
OW5nLGiaOW5no`a<00?oC4`02d`00ooOg`0;g`03omoO00_O01coGimOWenOGimOWenOoimOWenOGimO
WenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C0004ogkdOPCo00CdO_An
0_l01?Anm7h4o`0;m7kdO_Com7kdO_@00_l01gkdO_Anm?l014`3o`E<00?oC4`00d`00om<C005C003
omoO00?O0ol5g`03omoO00?O0_l6g`05oenOGil00ol02YmOWenOoimOWel3o`07GimOWenOo`0;0000
2P1loa<000coLGiaO_mnLGiaOW42o`0LOW5nLGkoOW5nLGiaO_mnLGiaog5nogiaOW5no`M<00?oC4`0
0T`00om<C003C003oda<00E<00?ogml01=l00ooOg`04g`03omoO00;O00Cogmoo1Ml07?mOWenOGimO
oenOGiooWenOGiooWenOGimOWol;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o035OWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml00ol0
000A000<ogkdO_AnogkdO_An0_l07?Anm7kdO_mnm7kdO_Com7kdO_mnm?odO_Anm?l7C003oda<009<
00?oC4`014`00om<C004C003omoO00;O1?l5g`03omoO00;O00Cogmoo1Ml07?mOWenOGimOoenOGioo
WenOGiooWenOGimOWol;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o035OWenOGimOWenO
GimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml00ol0000A000<
og5nLGiaO_mnLGia0_l04WiaOW5nLGkoOW5nLGkoOW5nL@?o00MaOW5nLGko00E<0_l5C003oda<00A<
00?oC4`014`00ooOg`02g`03omoo00KO00?ogml00]l01?oOgol5g`05oenOGil00ol059mOWenOoimO
WenOoimOWenOGioo2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0aGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO00?o00004@003?mn
m7koO_Com7kdOP;o01cdO_AnogkdooAnm7kdooAnm7koO_Anm7kdO_Co1d`00om<C002C003oda<00E<
00?oC4`00d`00ooOg`02g`03omoo00KO00?ogml00]l01?oOgol5g`0LoenOGiooWenOGimOWonOGimO
WonOGimOWenOo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0<EnOGimOWenOGimOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`03o`00014000GoLGia
OP02o`05LGiaOW400_l01GiaOW5n00;o00aaOW5nLGkoOW5nLGh3o`06OW5nLGko14`3o`E<00?oC4`0
0T`4o`E<00?ogml00ml2o`KO00?ogml00ml2o`KO00GoGimOW`04o`09GimOWonOGimO00;o00ROGimO
WenOo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0<EnOGimOWenOGimOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l064`00ooOg`0Eg`03o`00014000coO_Anm7kdO_An
m7h2o`0Lm7kdO_Anm7kdO_Anm?odO_Anm7kdO_Anm7kdo`a<00?oC4`02d`00ooOg`0;g`03omoO00_O
01coGimOWenOGimOWenOoimOWenOGimOWenOGioo2`0000X001SoWenOGimOWenOGimOWenOGimOWenO
Gil2o`0aGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003
omoO01GO00?o00004@003?maOW5nLGiaOW5nL@;o01anLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5nLGko
34`00om<C00;C003omoO00_O00?ogml02ml07?mOWenOGimOWenOGiooWenOGimOWenOGimOWol;0000
2P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o035OWenOGimOWenOGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml00ol0000A000<ogkdO_Anm7kdO_An0_l07?An
m7kdO_Anm7kdO_Com7kdO_Anm7kdO_Anm?l<C003oda<00]<00?ogml02ml00ooOg`0;g`0LoenOGimO
WenOGimOWonOGimOWenOGimOWenOo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l0<EnO
GimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`03
o`000140O?l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o035OWenOGimOWenOGimOWenO
GimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml00ol0000A000<oenOGimO
WenOGimO0_l0=imOWenOGimOWenOGiooWenOGimOWenOGimOWoodO_Anm7kdO_Anm7koO_Anm7kdO_An
m7kdO_l03D`00om<C00;C003omoO00[O00?ogml02ml00ol0000900002P002_nOGimOWenOGil3o`0;
WenOGimOWenOGil00_l02EnOGimOWenOG`03o`0FGimOWenOGimOWeooLGiaOW5nLGiaOPCo00]aOW5n
LGiaOW5no`09C0?o34`00ooOg`08g`;o2ml00ol0000A000<oenOGimOWenOGimO0_l0=imOWenOGimO
WenOGiooWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl03D`00om<C00;C003
omoO00[O00?ogml02ml00ol0000900002P006?nOGimOWenOGimOoenOGimOWenOGimOW`;o035OWenO
GimOWenOoimOWenOGimOWenOGomnm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Co00a<00?oC4`02D`00ooO
g`07g`04omoOo`[O00?o00004@003?mOWenOGimOWenOG`;o03NOGimOWenOGimOWenOoimOWenOGimO
WenOGioom7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko00e<00?oC4`02d`00ooOg`0:g`03omoO00_O
00?o00002@0000X001SoWenOGimOWenOGomOWenOGimOWenOGil2o`0aGimOWenOGimOWonOGimOWenO
GimOWeooLGiaOW5nLGiaOW5nogiaOW5nLGiaOW5no`0<C003oda<00U<00?ogml01ml01?oOgol:g`03
o`00014000coGimOWenOGimOWel2o`0gWenOGimOWenOGimOWonOGimOWenOGimOWenOogiaOW5nLGia
OW5nLOmaOW5nLGiaOW5nLGiao`0=C003oda<00]<00?ogml02]l00ooOg`0;g`03o`0000T0000:000H
oimOWenOGimOWeooGimOWenOGimOWenO0_l0<EnOGimOWenOGiooWenOGimOWenOGimOogkdO_Anm7kd
O_Anm7koO_Anm7kdO_Anm?l02T`2o`a<00?ogml01ml01?oOgol:g`03o`00014000CoGimO0ol01EnO
GimO00;o00BOGimO0ol02enOGimOWonOGimO00?o00aOWenOGioom7kdO_@2o`0:O_Anm7koO_Anm0Co
00Inm7kdO_l5C003oda<00E<00?oC4`00T`3o`I<00?ogml00ml2o`GO00?ogml00ml3o`GO00?o0000
2@0000X001SoWenOGimOWenOGomOWenOGimOWenOGil2o`0aGimOWenOGimOWonOGimOWenOGimOWeoo
LGiaOW5nLGiaO_mnLOmaOW5nLGiaOW5no`0<C003oda<00U<00?ogml01ml01?oOgol:g`03o`000140
00coGimOWenOoimOWel2o`0gWenOGimOWonOGimOWonOGimOWonOGimOWenOogiaOW7oLGkoOW5nLOma
OW5nLOmaOW5nLGiao`05C003oda<00E<00?oC4`01D`00om<C003C003omoO00;O00Cogmoo1=l00ooO
g`04g`03omoO00CO00?o00002@0000X000[oWenOGimOWenO0_l035nOGimOWenOGimOW`;o00UOWenO
GimOWel00_l069mOWenOGimOWenOGomnm7kdO_Anm7kdOP;o00cdO_Anm7kdO_Anm?l9C0?o34`00ooO
g`08g`;o2ml00ol0000A000<oenOGimOWonOGimO0_l0=imOWenOGiooWenOGiooWenOGiooWenOGimO
WoodO_AnogkdooAnm7koO_Anm7kdooAnm7kdO_l01T`00om<C004C003oda<00E<00?oC4`00d`00ooO
g`02g`04omoOo`CO00?ogml00]l4o`GO00?o00002@0000X001SoWenOGimOWenOGimOWenOGimOWenO
Gil2o`0aGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003
omoO01GO00?o00004@001?mOWel3o`05GimOWel00_l019mOWel3o`0IGimOWenOoimOWenOoimOWenO
GiooOW5nL@03o`0DLGiaOW7oLGiaOW5nLOmaOW5nLOl6C003oda<00A<00?oC4`00d`2o`I<00?ogml0
0]l01?oOgol4g`03omoO00;O00?ogol01]l00ol0000900002P006?nOGimOWenOGimOWenOGimOWenO
GimOW`;o035OWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<
00?ogml05Ml00ol0000A000<oenOGomOWenOGimO0_l0=imOWeooGimOWenOGiooWenOGiooWenOGimO
WoodO_AnogkdO_Anm7koO_Anm?odO_mnm7kdO_l01d`00om<C003C003oda<00E<00?oC4`00d`00ooO
g`02g`04omoOo`CO00?ogml00]l00ooOo`06g`03o`0000T0000:000HoimOWenOGimOWenOGimOWenO
GimOWenO0_l0<EnOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
64`00ooOg`0Eg`03o`00014000CoGimO1?l019mOWel2o`04WenOG`Co00ZOGimOWonOGimO0_l03ImO
WenOGiooOW5nLGh00ol02WiaOW7oLGiaOW42o`07OW5nLGiao`04C0Co1D`00om<C002C0?o1T`00ooO
g`03g`;o1Ml00ooOg`03g`;o1]l00ol0000900002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o
035OWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml0
5Ml00ol0000A000<oenOGimOWenOGimO0_l0=imOWenOGimOWenOGiooWenOGimOWenOGimOWoodO_An
m7kdO_Anm7koO_Anm7kdO_Anm7kdO_l03D`00om<C00;C003omoO00[O00?ogml02ml00ol000090000
2P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o035OWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml00ol0000A000<oenOGimOWenOGimO0_l0=imO
WenOGimOWenOGiooWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl03D`00om<
C00;C003omoO00[O00?ogml02ml00ol0000900002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o
035OWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml0
5Ml00ol0000A000<oenOGimOWenOGimO0_l0=imOWenOGimOWenOGiooWenOGimOWenOGimOWoodO_An
m7kdO_Anm7koO_Anm7kdO_Anm7kdO_l03D`00om<C00;C003omoO00[O00?ogml02ml00ol000090000
2P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o035OWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml00ol0000A07co2`0000X001SoWenOGimOWenO
GimOWenOGimOWenOGil2o`0aGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7kdo`0HC003omoO01GO00?o00004@003?mOWenOGimOWenOG`;o03NOGimOWenOGimOWenOoimO
WenOGimOWenOGioom7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko00e<00?oC4`02d`00ooOg`0:g`03
omoO00_O00?o00002@0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0aGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003omoO01GO00?o00004@003?mO
WenOGimOWenOG`;o03NOGimOWenOGimOWenOoimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaog5nLGia
OW5nLGiaOW7o00e<00?oC4`02d`00ooOg`0:g`03omoO00_O00?o00002@0000X0O?lC000<oenOGimO
WenOGimO0_l0=imOWenOGimOWenOGiooWenOGimOWenOGimOWoodO_Anm7kdO_Anm7koO_Anm7kdO_An
m7kdO_l03D`00om<C00;C003omoO00[O00?ogml02ml00ol0000900002P000ooOg`0Eg`;o5ml0<omO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`000140
00coGimOWenOGimOWel2o`0gWenOGimOWenOGimOWonOGimOWenOGimOWenOogiaOW5nLGiaOW5nLOma
OW5nLGiaOW5nLGiao`0=C003oda<00]<00?ogml02]l00ooOg`0;g`03o`0000T0000:0003omoO01GO
0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<
00?o00004@001?mOWel3o`05GimOWel00_l019mOWel3o`0;GimOWenOoimOWel00ol02enOGimOWood
O_An00Co00[dO_AnogkdO_An0_l01oAnm7kdO_l014`3o`I<00?oC4`00d`00om<C005C003omoO00?O
0ol4g`03omoO00?O0_l6g`03o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimO
WenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@003?mOWenOoimOWenOG`;o
03NOGimOWonOGimOWenOoimOWenOGiooWenOGiooOW5nLGkoOW5nLGiaog5nLGkoOW7oLGiaOW7o00M<
00?oC4`00d`00om<C003C003oda<00E<00?ogml01=l00ooOg`03g`03omoO00;O00Cogmoo1Ml00ol0
000900002P000ooOg`0Eg`;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000coGimOWonOGimOWel2o`0gWenOGiooWenOGimOWonOGimO
WenOoimOWenOooAnm7kdO_mnm7kdO_mnm7kdooAnogkdO_Ano`07C003oda<00=<00?oC4`014`00om<
C004C003omoO00;O1?l4g`03omoO00;O00Cogmoo1Ml00ol0000900002P000ooOg`0Eg`;o5ml0<omO
WenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`000140
00coGimOWonOGimOWel2o`0BWenOGiooWenOGimOWonOGimO0ol065nOGimOWomnLGiaOW5nogiaOW7o
LGiaOP?o00MnLGiaOW7o00E<0_l6C003oda<00A<00?oC4`014`00ooOg`02g`03omoo00GO00?ogml0
0]l01?oOgol5g`03o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@003?mOWenOoimOWenOG`;o03NOGimO
WonOGimOWenOoimOWeooGimOWenOGioom7kdO_mnm?odO_AnogkdO_Com7kdO_Anm7ko00M<00?oC4`0
0d`00om<C005C003oda<00=<00?ogml00]l00ooOo`05g`03omoO00;O00Cogmoo1Ml00ol000090000
2P000ooOg`0Eg`;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0GC003o`00014000CoGimO0_l01YmOWenOG`;o00BOGimO0_l039mOWenOGiooWenOG`Co
00^OGimOWomnLGiaOP02o`0;LGiaOW7oLGiaOW400ol01W5nLGiao`A<0ol6C003oda<009<1?l5C003
omoO00?O0_l5g`03omoO00?O0_l6g`03o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimO
WenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@003?mOWenOGimO
WenOG`;o03NOGimOWenOGimOWenOoimOWenOGimOWenOGioom7kdO_Anm7kdO_AnogkdO_Anm7kdO_An
m7ko00e<00?oC4`02d`00ooOg`0:g`03omoO00_O00?o00002@0000X000?ogml05Ml2oaOO03?oGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A000<
oenOGimOWenOGimO0_l0=imOWenOGimOWenOGiooWenOGimOWenOGimOWomnLGiaOW5nLGiaOW7oLGia
OW5nLGiaOW5nLOl03D`00om<C00;C003omoO00[O00?ogml02ml00ol0000900002P000ooOg`08g`;o
2ml2o`[O0_l;g`0;oenOGimOWenOGil00ol05ImOWenOGimOWenOooAnm7kdO_Anm004o`0<O_Anm7kd
O_Anm7ko2D`3o`]<00?o00004@003?mOWenOGimOWenOG`;o03NOGimOWenOGimOWenOoimOWenOGimO
WenOGioom7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko00e<00?oC4`02d`00ooOg`0:g`03omoO00_O
00?o00002@0000X000?ogml01ml01?oOgol:g`;o2Ml01?oOgol:g`0coenOGimOWenOGimOoenOGimO
WenOGimOWomnLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o00a<00?oC4`024`00ol0000A07co2`0000X0
00?ogml01ml01?oOgol:g`;o2Ml01?oOgol:g`0coenOGimOWenOGimOoenOGimOWenOGimOWoodO_An
m7kdO_Anm?odO_Anm7kdO_Anm7ko00a<00?oC4`024`00ol0000A0003omoO00WO0_l=g`03omoO00_O
03SoWenOGimOWenOGimOoenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Ano`a<
00?oC4`02d`00ol0000900002P000ooOg`07g`04omoOo`[O0_l9g`04omoOo`[O03?oGimOWenOGimO
WeooGimOWenOGimOWenOogiaOW5nLGiaOW5nLOmaOW5nLGiaOW5nLOl02T`2o`]<00?o00004@000ooO
g`09g`;o3Ml00ooOg`0;g`0hoimOWenOGimOWenOGomOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW7o
LGiaOW5nLGiaOW5nLOl<C003oda<00]<00?o00002@0000X000?ogml01ml01?oOgol:g`;o2Ml01?oO
gol:g`0coenOGimOWenOGimOoenOGimOWenOGimOWoodO_Anm7kdO_Com7koO_Anm7kdO_Anm7ko00a<
00?oC4`024`00ol0000A0003omoO00WO0_l=g`03omoO00_O03SoWenOGimOWenOGimOoenOGimOWenO
GimOWeooO_Anm7kdO_Anm7kdO_mnm7kdO_Anm7kdO_Ano`a<00?oC4`02d`00ol0000900002P000ooO
g`08g`;o2ml2o`[O0_l;g`0;oenOGimOWenOGil00_l05enOGimOWenOGimOWomnLGiaOW5nLGia00;o
00enLGiaOW5nLGiaOW7o00U<0ol;C003o`00014000?ogml02Ml2o`gO00?ogml02ml0>?nOGimOWenO
GimOWeooGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o34`00om<C00;C003
o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko01M<00?o00004@000ooOg`02g`?o1=l2o`GO0ol5g`03omoO00?O0_l6g`05
oimOWel00ol02UnOGimOoenOGil3o`0<WenOGimOogkdO_An0_l02oAnm7kdO_mnm7kd00Co00Inm7kd
O_l5C003oda<00A<00?oC4`00T`3o`I<00?o00002@0000X000?ogml05Ml2oaOO03?oGimOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003omoO00?O
00?ogml00ml2o`KO00?ogml01=l00ooOg`02g`04omoOo`GO03SoWenOGimOWonOGimOoenOGimOoenO
GimOWeooLGiaO_mnLOmaOW5nLOmaOW5nLOmaOW5nLGiao`E<00?oC4`014`00om<C005C003oda<00=<
00?o00002@0000X000?ogml05Ml2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0004omoOg`Co1=l2o`CO1?l5g`03omoO00;O00Cogmoo
1Ml0>?nOGimOWenOoimOWeooGimOWeooGimOWenOGomnm7kdooAnogkdO_AnogkdO_Anm?odO_Anm7ko
1T`00om<C003C003oda<00E<00?oC4`00d`00ol0000900002P000ooOg`0Eg`;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000OogmoO
omoo00GO0_l4g`03omoo00KO00?ogml00]l01?oOgol5g`05oimOWel00ol065nOGimOoenOGimOoenO
GimOWeooLGiaOP?o01EnLGiaOW7oLGiaOW5nLOmaOW5nLOl01T`00om<C003C003oda<00=<0_l6C003
o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko01M<00?o00004@001ooOgmoogol01Ml2o`CO00?ogol01]l00ooOg`02g`04
omoOo`GO03SoWenOGomOWenOGimOoenOGimOoenOGimOWeooO_Anm?odO_Anm7kdO_mnm7kdooAnogkd
O_Ano`M<00?oC4`00T`00om<C005C003oda<00=<00?o00002@0000X000?ogml05Ml2oaOO03?oGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003
omoO00;O0_l5g`;o1Ml2o`KO00?ogml00ml2o`KO00GoWenOG`04o`09WenOGomOWenO00;o00eOWenO
GimOog5nLGia00?o00]aOW5nLOmaOW5nL@02o`07OW5nLGiao`04C0Co14`00om<C002C0?o1T`00ol0
000900002P000ooOg`0Eg`;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000?ogml02Ml2o`gO00?ogml02ml0>?nOGimOWenOGimOWeoo
GimOWenOGimOWenOGomnm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko34`00om<C00;C003o`0000T0
000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o01M<00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`0hoimOWenOGimOWenOGomOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl<C003oda<00]<00?o00002@0000T0
OOlC0003omoO00WO0_l=g`03omoO00_O03SoWenOGimOWenOGimOoenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_mnm7kdO_Anm7kdO_Ano`a<00?oC4`02d`00ol0000900002@1moa<0O?l;00002P000ol0
000D00?o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0GC003o`00014000?ogml02Ml2o`gO00?ogml02ml0>?nOGimOWenOGimOWeooGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko34`00om<C00;C003o`0000T0000:0003o`0001<0
00Co0?oo5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?ogml02Ml2o`gO00?ogml02ml0>?nOGimOWenOGimOWeooGimOWenOGimOWenO
GomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o34`00om<C00;C003o`0000T0000:0003o`000180
00?o00000_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01M<00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`0hoimOWenOGimOWenOGomOWenOGimOWenO
GimOogkdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_l<C003oda<00]<00?o00002@0000X000?o0000
4@001?l00002oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl05d`00ol0000A0003omoO00;O0_l5g`;o1Ml2o`KO00?ogml00ml3o`GO00GoWenOG`03o`0:
GimOWeooGimOW`?o00^OGimOWeooLGiaOP04o`0;LGiaOW7oLGiaOW400_l01giaOW5nLOl014`3o`E<
00?oC4`00d`00om<C005C003o`0000T0000:0003o`00010000?o00000P02oaOO03?oGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0005omoOgol0
0]l00ooOg`02g`;o1=l01?oOgol5g`03omoO00CO00?ogml01=l0>?nOGimOWonOGimOWeooGimOWenO
GomOWenOGomnm7kdO_mnm7kdO_AnogkdO_Com7koO_Anm7ko1d`00om<C002C003oda<00=<00?oC4`0
1D`00ol0000900002P000ol0000200;o00<0ool020000ol0000300;o5ml0<omOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000GogmoOo`02g`03
omoO00;O0_l4g`04omoOo`GO00?ogml00]l4o`GO03SoWenOGiooWenOGimOoenOGimOWeooGimOWeoo
LGiaOW5nogiaOW5nLOmaOW5nogiaog5nLGiao`M<00?oC4`00T`00om<C004C003oda<00A<00?o0000
2@0000X000?o00000`000ol0o`080003o`0000@00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@001OoOgmoo00;O00?ogml00]l2o`CO
00Cogmoo1Ml00ooOg`02g`03omoo00KO01;oWenOGiooWenOGimOoenOGil3o`0IWenOGimOogkdO_An
m7koO_Anm7koO_Anm003o`07m7kdO_Ano`05C0;o1D`00om<C004C003oda<00A<00?o00002@0000X0
00?o000010000ol000060003o`0000D00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@001OoOgmoo00;O00?ogml00]l2o`CO00Cogmoo
1Ml00ooOg`02g`03omoo00KO03SoWenOGiooWenOGimOoenOGiooWenOGimOWeooLGiaO_mnLOmaOW5n
LOmaOW5nogiaOW5nLGiao`M<00?oC4`00T`00om<C005C003oda<00=<00?o00002@0000X000?o0000
0`000ol0o`060003o`0000H00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko01M<00?o00004@000ooOg`02g`;o1Ml2o`GO0_l6g`03omoO00?O0_l6g`05
oimOWel00_l02imOWenOGomOWenO00Co00]OWenOGomnm7kdOP02o`0<m7kdO_AnogkdO_An0ol01Wkd
O_Ano`A<0ol5C003oda<009<1?l5C003o`0000T0000:0003o`0000800_l00`3oo`040003o`0000L0
0_l:g`;o2ml02omOWenOGimOWenO00?o01FOGimOWenOGimOWomnLGiaOW5nLGh01?l0375nLGiaOW5n
LGiao`U<0ol;C003o`00014000?ogml02Ml2o`gO00?ogml02ml0>?nOGimOWenOGimOWeooGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o34`00om<C00;C003o`0000T0000:0003
o`0000X000?o00002002o`WO00Cogmoo2]l0<omOWenOGimOWenOGomOWenOGimOWenOGioom7kdO_An
m7kdO_mnm7kdO_Anm7kdO_Ano`0<C003oda<00Q<00?o00004@000ooOg`09g`;o3Ml00ooOg`0;g`0h
oimOWenOGimOWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_l<C003
oda<00]<00?o00002@0000X000?o00002@000ol0000900;o2Ml01?oOgol:g`0coenOGimOWenOGimO
oenOGimOWenOGimOWomnLGiaOW5nLGiaO_mnLGiaOW5nLGiaOW7o00a<00?oC4`024`00ol0000A0003
omoO00WO0_l=g`03omoO00_O03SoWenOGimOWenOGimOoenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LOmaOW5nLGiaOW5nLGiao`a<00?oC4`02d`00ol0000900002P000ol000080004o`0000?o1P02o`WO
00Cogmoo2]l0<omOWenOGimOWenOGomOWenOGimOWenOGioom7kdO_Anm7kdO_AnogkdO_Anm7kdO_An
o`0:C0;o2d`00ol0000@07go2`0000X000?o00001`000ol000030003o`0000D00_l9g`04omoOo`[O
03?oGimOWenOGimOWeooGimOWenOGimOWenOogiaOW5nLGiaO_mnLOmaOW5nLGiaOW5nLOl034`00om<
C008C003o`000100OOl;00002P000ol000060003o`0000D000?o00001002o`[O0_l;g`0;oenOGimO
WenOGil00_l05enOGimOWenOGimOWoodO_Anm7kdO_An00;o00gdO_Anm7kdO_Anm7ko00U<0ol;C003
o`00014000?o00002@02o`gO00?ogml02ml0>?nOGimOWenOGimOWeooGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko34`00om<C00;C003o`0000T0000:0003o`0000D000?o0000
1P000ol0000400;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0GC003o`0001400ol00`3oo`0500?o3Ml00ooOg`0;g`0hoimOWenOGimOWenOGomOWenO
GimOWenOGimOog5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl<C003oda<00]<00?o00002@0000X0
00?o000010000ol000060003o`3o00D00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@001Ol0o`3o00D000Co0?oo3Ml00ooOg`0;g`0h
oimOWenOGimOWenOGomOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7koO_Anm7kdO_Anm7kdO_l<C003
oda<00]<00?o00002@0000X000?o00000`000ol000070003o`3o00D00_lGg`0coenOGimOWenOGimO
WenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@001?l00?l50003
o`0000;o1Ml2o`KO00?ogml00ml3o`GO00GoWenOG`03o`0:GimOWeooGimOW`?o00^OGimOWeooLGia
OP04o`0;LGiaOW7oLGiaOW400_l01giaOW5nLOl014`3o`E<00?oC4`00d`00om<C005C003o`0000T0
000:0003o`00008000?o00001`02o`030?oo00@00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@001Ol0o`3o00800ol200;o1=l01?oO
gol5g`03omoO00CO00?ogml01=l0>?nOGimOWonOGimOWeooGimOWenOGomOWenOGomnm7kdO_mnm7kd
O_AnogkdO_Com7koO_Anm7ko1d`00om<C002C003oda<00=<00?oC4`01D`00ol0000900002P001Ol0
003o01<00_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGia
OW7o01M<00?o00004@03o`040?oo00;o0`02o`CO00Cogmoo1Ml00ooOg`02g`Co1Ml0>?nOGimOWonO
GimOWeooGimOWenOGomOWenOGomaOW5nLGkoOW5nLGiaog5nLGkoOW7oLGiaOW7o1d`00om<C002C003
oda<00A<00?oC4`014`00ol0000900002P001?l00?lD00;o5ml0<omOWenOGimOWenOGimOWenOGimO
WenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?o00000`001?l00?l200;o
1=l01?oOgol5g`03omoO00;O00?ogol01]l04_nOGimOWonOGimOWeooGimOW`?o01VOGimOWeooO_An
m7kdO_mnm7kdO_mnm7kd00?o00OdO_Anm7ko00E<0_l5C003oda<00A<00?oC4`014`00ol000090000
2P000ol0o`0E00;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGia
OW5nLGiao`0GC003o`00014000?o00000P001Ol0003o00800_l4g`04omoOo`GO00?ogml00]l00ooO
o`06g`0hoimOWenOoimOWenOGomOWenOoimOWenOGimOog5nLGkoOW7oLGiaOW7oLGiaO_mnLGiaOW5n
LOl7C003oda<009<00?oC4`01D`00om<C003C003o`0000T0000:00;o5P02oaOO03?oGimOWenOGimO
WenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0005o`000?l0
0`001?l0o`02o`GO0_l6g`03omoO00?O0_l6g`05oimOWel00_l02imOWenOGomOWenO00Co00]OWenO
Gomnm7kdOP02o`0<m7kdO_AnogkdO_An0ol01WkdO_Ano`A<0ol5C003oda<009<1?l5C003o`0000T0
000:07co4`001?l00?l40004o`3o00;o3Ml00ooOg`0;g`0hoimOWenOGimOWenOGomOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl<C003oda<00]<00?o00002@0002800_me0003
o`3o00@00_l00`3oo`02o`gO00?ogml02ml0>?nOGimOWenOGimOWeooGimOWenOGimOWenOGomnm7kd
O_Anm7kdO_AnogkdO_Anm7kdO_Anm7ko34`00om<C00;C003o`0000T0002I00;o2P02o`gO00?ogml0
2ml0>?nOGimOWenOGimOWeooGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaog5nLGiaOW5nLGiaOW7o
34`00om<C00;C003o`0000T0002I07co2`000:D00_mi0000o`0Q0000X@02o`X00_mM00?o4@000:40
00?o00002P000ol0001L0003o`000100002J00Co0`000ol0000300;o1@000ol0001300;o00<0ool0
2P000ol000080003o`0000l0000B00;o2P02oed00olK0003o`3o00<000?o00000P001?l00?l40003
o`0004@000?o0?l02`000ol000080003o`0000l0000B0003o`0000X000?o0000G0000ol0000J0003
o`0000<000?o00000P001?l00?l40003o`0004D000?o00002005o`L000?o0?l0400000/01?l30003
o`0000<00ol40003o`0004<00_l00`3oo`0:0003o`0000P000?o00006P000ol000020003o`0000<0
0_l50003o`0004@000?o0?l02`000ol000070003o`3o0100000<0003o`3o00<000?o000010000ol0
00030003o`0004@000?o0?l02`000ol000080003o`0001P000?o0?l010000ol000020004o`00o`@0
00?o0000@`02o`030?oo00X000?o00001P02o`030?oo00l0000<0003o`0000<000?o00000P04o`@0
00?o0000A@000ol0000800Go1`000ol0o`0I00Co0`02o`@00_l400;oL@0000d000?o00000P000ol0
00020003o`3o00D000?o0000A0000ol0o`0;0003o`0000L000?o0?l0W`0000/000?o0?l010000ol0
00020003o`3o00D000?o0000@`02o`030?oo00X000?o00001P02o`030?oo09h0000;00Co0`02o`@0
0_l400;oo`010000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {149.812, 0}} -> {-0.0536619, -0.0261961, 
  0.0073426, 0.0073426}, {{7.25, 137}, {146.188, 
  3.5625}} -> {-1.42043, -0.28431, 0.0404912, 0.0404912}, {{149.938, 
  279.688}, {146.188, 3.5625}} -> {-12.1455, -0.70791, 0.0728332, 
  0.0728332}},
  CellTags->"Global"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  GraphicsArray  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"Global"]
}, Open  ]],

Cell["5.2 Working with permutations and cycles", "Subsection",
  CellTags->{"PermIntroduction", "i:3"}],

Cell["5.2.1 Introduction", "Subsubsection",
  CellTags->"PermIntroduction"],

Cell[TextData[{
  "A permutation of a set ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " is a bijection (one-to-one and onto function) from ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " to ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ". Frequently, either the set ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " is the first ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " positive integers or it can be viewed as such. For the most part, in \
these packages we view a permutation \[Sigma] as a function on ",
  StyleBox["Range", "MR"],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "]. Therefore, we describe it by the ordered list of the functional ",
  StyleBox["images",
    FontSlant->"Italic"],
  " of the domain ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \ 2, \  ... , \ n}\)]],
  ". In other words, the permutation \[Sigma] is given as a rearrangement of \
this set. For example, let \[Sigma] be the permutation that takes 1 to 4, 2 \
to 2, 3 to 1, and 4 to 3. "
}], "Text",
  CellTags->"PermIntroduction"],

Cell[TextData[{
  "We define a permutation by using the ordered set of images of the domain ",
  
  Cell[BoxData[
      \(TraditionalForm\`{1, \ 2, \  ... , \ n}\)]],
  ". Here, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma](1)\  = \ 4\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma](2)\  = \ 2\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma](3)\  = \ 1\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma](4)\  = \ 3\)]],
  "."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Sigma]\  = \ {4, \ 2, \ 1, \ 3}\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \({4, 2, 1, 3}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell[TextData[{
  "The function ",
  StyleBox["PermutationMatrix", "MR"],
  " allows us to view both the domain (first row) and image (second row) of a \
permutation, as it is sometimes presented."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermutationMatrix[\[Sigma]]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "2", "3", "4"},
            {"4", "2", "1", "3"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  CellLabel->"Out[9]//MatrixForm=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell[TextData[{
  "Note that a permutation must be a bijection. Therefore, a list of length ",
  
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is considered a permutation only if it is the list ",
  Cell[BoxData[
      \(TraditionalForm\`{1, \ 2, \  ... , \ n}\)]],
  " after the elements are sorted."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermutationQ[{5, \ 2, \ 1, \ 3}]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell[TextData[{
  "A number of functions deal with permutations (and cycles). Note that while \
the functions listed here are compatible with those found in the standard \
package ",
  StyleBox["DiscreteMath`Permutations`", "MR"],
  ", the functionality is greatly expanded here."
}], "Text",
  CellTags->"PermIntroduction"],

Cell[TextData[{
  "Below is a list of functions that have either the word ",
  StyleBox["Permutation", "MR"],
  " or ",
  StyleBox["Cycle", "MR"],
  " in their name (some of which are not related to these packages)."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[Names["\<*Permutation*\>"], Names["\<*Cycle*\>"]]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \({"Cycle", "CycleAs", "DisjointCyclesQ", "EvenPermutationQ", 
      "ExtendPermutation", "FormGroupoidFromCycles", "FromCycles", 
      "MultiplyCycles", "MultiplyPermutations", "OddPermutationQ", 
      "PermutationComposition", "PermutationGroup", "PermutationImage", 
      "PermutationInverse", "PermutationMatrix", "PermutationQ", 
      "Permutations", "PermutationToPower", "RandomPermutation", 
      "SamePermutationQ", "ShowColoredPermutation", "ShowPermutation", 
      "ShowPossiblePermutations", "TestPermutationQ", "ToCycles", 
      "ToPermutation"}\)], "Output",
  CellLabel->"Out[11]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["PermutationQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox["list",
                  FontSlant->"Italic"], 
                StyleBox[\(\ represents\ a\ permutation, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["RandomPermutation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(give\ a\ random\ permutation\ on\ 
                    \({1, \ 2, \ \[Ellipsis], \ \)\),
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"], "}"}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Ordering",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(give\ the\ permutation\ that\ puts\ the\ elements\ in\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox["list",
                  FontSlant->"Italic"], 
                StyleBox[\(\ in\ order\),
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"PermIntroduction", "i:4"}],

Cell[TextData[{
  "Basic functions for working with permutations; these are almost equivalent \
to those in ",
  StyleBox["DiscreteMath`Permutations`",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"PermIntroduction"],

Cell[TextData[{
  "The ",
  StyleBox["Ordering", "MR"],
  " function does not require the list to be a permutation on the integers 1, \
2, ..., ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ". The following list is considered ordered when the elements appear in the \
order {1, 3, 2}."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Ordering[{"\<aleph\>", \ "\<gimel\>", \ "\<beth\>"}]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \({1, 3, 2}\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell[TextData[{
  "When the list is a permutation, ",
  StyleBox["Ordering", "MR"],
  " effectively finds the inverse of the permutation."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(q\  = \ Ordering[p = {1, 3, 2}]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \({1, 3, 2}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell[TextData[{
  "The following verifies that ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " are inverses."
}], "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermutationComposition[q, \ p]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell["And here is another way of verifying it.", "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{

Cell[BoxData[
    \(q\  == \ PermutationInverse[p]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"PermIntroduction"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->"PermIntroduction"]
}, Open  ]],

Cell["5.2.2 Permutation operations", "Subsubsection",
  CellTags->{"PermOperations", "i:5"}],

Cell[TextData[{
  "Since we are viewing a permutation of length ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " as a ",
  StyleBox["function",
    FontSlant->"Italic"],
  " on ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Range",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  ", we multiply two permutations by composing the two functions. Since there \
are two different traditions as to the order in which one composes two \
functions, the order for multiplying permutations is likewise in dispute. To \
remedy this, the function ",
  StyleBox["MultiplyPermutations", "MR"],
  " has an option called ",
  StyleBox["ProductOrder", "MR"],
  " that permits the values ",
  StyleBox["RightToLeft", "MR"],
  " and ",
  StyleBox["LeftToRight", "MR"],
  "."
}], "Text",
  CellTags->"PermOperations"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MultiplyPermutations",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["perm2",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["perm1",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ product\ of\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm1",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["followed",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["by",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["permutation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["perm2",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(working\ from\ right\ to\ left\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["MultiplyPermutations",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["perm2",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["perm1",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    StyleBox[\(ProductOrder\  \[Rule] \ LeftToRight\),
                      "MR"],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ product\ of\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm2",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["followed",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["by",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["permutation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["perm1",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(working\ from\ left\ to\ right\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["PermutationComposition",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["perm2",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["perm1",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(identical\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["MultiplyPermutations",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["perm2",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["perm1",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox[
                          FormBox[
                            
                            StyleBox[
                              \(ProductOrder\  \[Rule] \ RightToLeft\),
                              "MR",
                              SingleLetterItalics->False],
                            "TraditionalForm"],
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.35, 0.65}},
  CellTags->{"PermOperations", "i:6"}],

Cell["Different ways of multiplying permutations.", "Caption",
  CellTags->"PermOperations"],

Cell["\<\
Here are two randomly chosen permutations of length eight and four \
respectively.\
\>", "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \({p\  = \ RandomPermutation[8], \nq\  = \ RandomPermutation[4]}\)], 
  "Input",
  CellLabel->"In[16]:=",
  CellTags->"PermOperations"],

Cell[BoxData[
    \({{4, 6, 1, 3, 2, 5, 7, 8}, {2, 1, 4, 3}}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->"PermOperations"]
}, Open  ]],

Cell[TextData[{
  "A permutation in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_m\)]],
  " can be extended to one in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`n > m\)]],
  ", with ",
  StyleBox["ExtendPermutation.", "Input",
    FontWeight->"Plain"],
  "For example, we can extend ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " to a permutation in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_8\)]],
  ", extending the function as the identity on the last four entries."
}], "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \({q, ExtendPermutation[q, \ 8]} // ColumnForm\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"PermOperations"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({2, 1, 4, 3}\)},
          {\({2, 1, 4, 3, 5, 6, 7, 8}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{2, 1, 4, 3}, {2, 1, 4, 3, 5, 6, 7, 8}}],
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"PermOperations"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ExtendPermutation", "Input",
    FontWeight->"Plain"],
  " is used automatically when we multiply ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  ". This is the result when performing the product from right to left, the \
default approach."
}], "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultiplyPermutations[p, \ q]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"PermOperations"],

Cell[BoxData[
    \({6, 4, 3, 1, 2, 5, 7, 8}\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->"PermOperations"]
}, Open  ]],

Cell["\<\
Using the same permutations, we (generally) get a different result \
when we perform the product working from left to right.\
\>", "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultiplyPermutations[p, \ q, \ ProductOrder\  \[Rule] \ LeftToRight]
      \)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"PermOperations"],

Cell[BoxData[
    \({3, 6, 2, 4, 1, 5, 7, 8}\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->"PermOperations"]
}, Open  ]],

Cell[TextData[{
  "Note that permutations can be entered into ",
  StyleBox["MultiplyPermutations", "MR"],
  " either as a list of rules or in the standard permutation form. Note also \
that the ",
  StyleBox["Textual", "MR"],
  " mode indicates the rule form of the product but returns the standard \
form."
}], "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultiplyPermutations[{1\  \[Rule] \ 4, \ 2\  \[Rule] \ 5, \ 
        3\  \[Rule] \ 3, \ 4\  \[Rule] \ 2, \ 5\  \[Rule] \ 1}, 
      \ {3, 1, 4, 2}, \ Mode\  \[Rule] \ Textual]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"PermOperations"],

Cell[BoxData[
    \("The permutation resulting from the product of "\)], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    InterpretationBox[\("\t"\[InvisibleSpace]{3, 1, 4, 2}\),
      SequenceForm[ "\t", {3, 1, 4, 2}],
      Editable->False]], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    \("followed by"\)], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    InterpretationBox[
      \("\t"\[InvisibleSpace]{1 \[Rule] 4, 2 \[Rule] 5, 3 \[Rule] 3, 
          4 \[Rule] 2, 5 \[Rule] 1}\),
      SequenceForm[ "\t", {1 -> 4, 2 -> 5, 3 -> 3, 4 -> 2, 5 -> 1}],
      Editable->False]], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    \("can be given as "\)], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    InterpretationBox[
      \("\t"\[InvisibleSpace]{1 \[Rule] 3, 2 \[Rule] 4, 3 \[Rule] 2, 
          4 \[Rule] 5, 5 \[Rule] 1}\),
      SequenceForm[ "\t", {1 -> 3, 2 -> 4, 3 -> 2, 4 -> 5, 5 -> 1}],
      Editable->False]], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    \("or as"\)], "Print",
  CellTags->"PermOperations"],

Cell[BoxData[
    \({3, 4, 2, 5, 1}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"PermOperations"]
}, Open  ]],

Cell["\<\
Here is a summary of some miscellaneous functions dealing with \
permutations, several of which we have already seen in use.\
\>", "Text",
  CellTags->"PermOperations"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ExtendPermutation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox[\(for\ a\ permutation\ \),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox["p",
                          "TraditionalForm"],
                        "Text"], 
                      StyleBox[\(\ of\ length\ \),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox["m",
                          "TraditionalForm"],
                        "Text"]}], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[\(return\ the\),
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["equivalent",
                      SingleLetterItalics->False], 
                    StyleBox[",",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["extended",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["permutation",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["of",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["length",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox["n",
                          "TraditionalForm"],
                        "Text"]}]}]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox[
                        RowBox[{
                          StyleBox["n",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"], " ", 
                          StyleBox[">",
                            SingleLetterItalics->False], " ", 
                          StyleBox["m",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"]}],
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[")",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["that",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["identity",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["on",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["positions",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["m",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox["+",
                        SingleLetterItalics->False], 
                      StyleBox["1",
                        SingleLetterItalics->False]}],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\[Ellipsis]",
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["n",
                  "TraditionalForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["PermutationInverse",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(\(give\ the\ permutation\ that\ is\ the\)\ inverse\ of\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["permutation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["PermutationMatrix",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(show\ a\ permutation\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["matrix",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["where",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["bottom",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["row",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["top",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["row",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox[\(consists\ of\ 1\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["2",
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\[Ellipsis]",
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Length",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["p",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["PermutationToPower",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ the\ \),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(th\ power\ of\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"], 
                StyleBox[\(\ \((where\ is\ \)\),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\ is\ any\ integer)\),
                  SingleLetterItalics->False]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.42, 0.58}},
  CellTags->{"PermOperations", "i:7"}],

Cell["Miscellaneous functions.", "Caption",
  CellTags->"PermOperations"],

Cell[TextData[{
  StyleBox["PermutationToPower", "MR"],
  " is analogous to ",
  StyleBox["ElementToPower", "MR"],
  "; both can be used to raise an element to any positive or negative power."
}], "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Table[{k, PermutationToPower[p, \ k]}, \ {k, \ \(-1\), \ 4}], 
      \ TableDepth\  \[Rule] 2, \ 
      TableHeadings\  \[Rule] {None, {"\<k\>", \*"\"\<\!\(p\^k\)\>\""}}]\)], 
  "Input",
  CellLabel->"In[21]:=",
  CellTags->"PermOperations"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"k\"\>", "\<\"\\!\\(p\\^k\\)\"\>"},
          {\(-1\), \({3, 5, 4, 1, 6, 2, 7, 8}\)},
          {"0", \({1, 2, 3, 4, 5, 6, 7, 8}\)},
          {"1", \({4, 6, 1, 3, 2, 5, 7, 8}\)},
          {"2", \({3, 5, 4, 1, 6, 2, 7, 8}\)},
          {"3", \({1, 2, 3, 4, 5, 6, 7, 8}\)},
          {"4", \({4, 6, 1, 3, 2, 5, 7, 8}\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableDepth -> 2, TableHeadings -> {None, {"k", 
        "\!\(p\^k\)"}}]&)]], "Output",
  CellLabel->"Out[21]//TableForm=",
  CellTags->"PermOperations"]
}, Open  ]],

Cell["5.2.3 Representing permutations", "Subsubsection",
  CellTags->{"PermRepresent", "i:8"}],

Cell[TextData[{
  "Since permutations are functions from ",
  Cell[BoxData[
      RowBox[{
        StyleBox["Range",
          "MR"], 
        StyleBox["[",
          "MR"], 
        StyleBox["n",
          "TI"], 
        StyleBox["]",
          "MR"]}]], "Input",
    GeneratedCell->True],
  " to itself, it is natural to represent a permutation by a list of rules."
}], "Text",
  CellTags->"PermRepresent"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ToRules",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(for\ a\ permutation\ \),
                    SingleLetterItalics->False], 
                  StyleBox["perm",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["length",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["n",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(give\ a\ list\ of\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["rules",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["form",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["x",
                    FontSlant->"Italic"]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["\[Rule]",
                  SingleLetterItalics->False,
                  FontFamily->"Courier"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["y",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ where\ \),
                    SingleLetterItalics->False], 
                  StyleBox["x",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ is\ in\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["Range",
                          "MR"], 
                        StyleBox["[",
                          "MR"], 
                        StyleBox["n",
                          "TI"], 
                        StyleBox["]",
                          "MR"]}],
                      "StandardForm"],
                    "Text"]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["y",
                    FontSlant->"Italic"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["perm",
                    FontSlant->"Italic"], "\[NoBreak]", \((x)\)}], ",", " ", 
                \(the\ image\ of\ x\ under\ the\ permutation\)}]}]},
          {
            RowBox[{
              StyleBox["ToPermutation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["when",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["list",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["is",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["list",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["rules",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["in",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["form",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["x",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\[Rule]",
                    SingleLetterItalics->False,
                    FontFamily->"Courier"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["y",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["or",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["{",
                        SingleLetterItalics->False], 
                      RowBox[{
                        StyleBox["x",
                          FontSlant->"Italic"], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["\[Rule]",
                          SingleLetterItalics->False,
                          FontFamily->"Courier"], 
                        StyleBox[" ",
                          SingleLetterItalics->False], 
                        StyleBox["y",
                          FontSlant->"Italic"]}], 
                      StyleBox["}",
                        SingleLetterItalics->False]}]}]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(give\ the\ permutation\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(if\ possible\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(corresponding\ to\ the\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox["rules",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"PermRepresent", "i:9"}],

Cell["Rules and permutations can be interchanged.", "Caption",
  CellTags->"PermRepresent"],

Cell["\<\
The following converts a permutation into a list of rules \
corresponding to the permutation.\
\>", "MathCaption",
  CellTags->"PermRepresent"],

Cell[CellGroupData[{

Cell[BoxData[
    \({q\  = \ RandomPermutation[4], qrules\  = \ ToRules[q]}\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"PermRepresent"],

Cell[BoxData[
    \({{4, 1, 3, 2}, {1 \[Rule] 4, 2 \[Rule] 1, 3 \[Rule] 3, 4 \[Rule] 2}}
      \)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"PermRepresent"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToPermutation", "MR"],
  " converts a list of rules into a permutation. Here we see that this \
function is the inverse to ",
  StyleBox["ToRules", "MR"],
  "."
}], "MathCaption",
  CellTags->"PermRepresent"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToPermutation[qrules]\  == \ q\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"PermRepresent"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->"PermRepresent"]
}, Open  ]],

Cell["5.2.4 Cycles", "Subsubsection",
  CellTags->{"Cycles", "i:10"}],

Cell[TextData[{
  "Consider the permutation \[Sigma] = {3, 1, 4, 2}. This represents the \
function that takes 1 to 3, 2 to 1, 3 to 4 and 4 to 2. Note that \[Sigma] is \
a ",
  StyleBox["cyclic permutation",
    FontSlant->"Italic"],
  " in the sense that \[Sigma](1) = 3, \[Sigma](3) = \[Sigma](\[Sigma](1)) = \
4, \[Sigma](4) = \[Sigma](\[Sigma](\[Sigma](1))) = 2, and then \[Sigma](2) \
takes us back to 1, cycling through all of the elements. Often such a cycle \
is represented in the mathematical literature as (1 3 4 2). Since \
juxtaposition implies multiplication in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", and since parentheses cannot be used as delimiters, we need another \
structure to represent a ",
  StyleBox["cycle",
    FontSlant->"Italic"],
  ". In these packages, this cycle is represented by ",
  StyleBox["Cycle", "MR"],
  "[1, 3, 4, 2], with the head ",
  StyleBox["Cycle", "MR"],
  " and the elements separated by commas, as in a list. Cycles are important \
in abstract algebra",
  " ",
  "(for example, any permutation can be written as a product of cycles) and \
consequently receive some attention in these packages."
}], "Text",
  CellTags->"Cycles"],

Cell[TextData[{
  "The ",
  StyleBox["DiscreteMath`Permutations`", "MR"],
  " package contains two functions for converting between permutations and \
cycles: ",
  StyleBox["ToCycles", "MR"],
  " and ",
  StyleBox["FromCycles", "MR"],
  ". For compatibility reasons, we can still operate using the approach \
presented there, but because the approach here is clearer and more robust, \
you are encouraged to adopt the defaults used here."
}], "Text",
  CellTags->"Cycles"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ToCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ the\ decomposition\ of\ \),
                SingleLetterItalics->False], 
              StyleBox["perm",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["into",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["list",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["cycles",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["form",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Cycle",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    StyleBox["a",
                      "TI"], 
                    StyleBox[",",
                      "TI"], " ", 
                    StyleBox["b",
                      "TI"], 
                    StyleBox[",",
                      "TI"], " ", 
                    StyleBox["\[Ellipsis]",
                      "MR"], 
                    StyleBox["]",
                      "MR"]}],
                  "StandardForm"],
                "Text"]}]},
          {
            RowBox[{
              StyleBox["ToCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["CycleAs",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["\[Rule]",
                      "MR"], " ", 
                    StyleBox["List",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ decomposition\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["into",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["cycles",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["found",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["DiscreteMath",
                  "MR"], 
                StyleBox[\(\ package\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["FromCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], \(cyc\_1\), 
                    StyleBox[",",
                      "MR"], " ", \(cyc\_2\), 
                    StyleBox[",",
                      "MR"], " ", "\[Ellipsis]", 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(give\ the\ permutation\ corresponding\ to\ the\ given\ cyclic
                \ decomposition\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Cycles", "i:11"}],

Cell["Converting between cycles and permutations.", "Caption",
  CellTags->"Cycles"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[\(default\ value\),
              "SO10",
              FontSlant->"Italic"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["CycleAs",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Cycle",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[
                \(specifies\ whether\ a\ cycle\ should\ be\ represented\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["using",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Cycle",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox[\(a, \ b, \ \[Ellipsis]\),
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["structure",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["lists",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["(",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["using",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["List",
                      "MR",
                      SingleLetterItalics->False]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}]}]}]},
          {
            StyleBox[
              FormBox["Normalize",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["True",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["when",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["set",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["to",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["specifies",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["that",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["all",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["cycles",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["of",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["length",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["one",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["are",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["dropped",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  
                  StyleBox[
                    \((unless\ needed\ to\ show\ the\ length\ of\ the\ 
                        original\ permutation)\),
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["normalization",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["is",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["applied",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["to",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["all",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["remaining",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["cycles",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["(",
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["only",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["valid",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["if",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["we",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["have",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[\(CycleAs\  \[Rule] \ Cycle\),
                        "MR"]}], 
                    StyleBox[")",
                      SingleLetterItalics->False]}]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.17, 0.15, 0.68},
  RowLines->{True, False}},
  CellTags->{"Cycles", "i:12"}],

Cell[TextData[{
  "Options for ",
  StyleBox["ToCycles",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"Cycles"],

Cell["Consider the following permutation as an example.", "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(r\  = \ {8, \ 2, \ 5, 6, \ 4, \ 3, \ 1, \ 9, \ 7, \ 10, \ 11}\)], 
  "Input",
  CellLabel->"In[24]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({8, 2, 5, 6, 4, 3, 1, 9, 7, 10, 11}\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  "Here is how ",
  StyleBox["ToCycles", "MR"],
  " works in ",
  StyleBox["DiscreteMath`Permutations`", "MR"],
  "."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToCycles[r, \ CycleAs\  \[Rule] \ List]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({{8, 9, 7, 1}, {2}, {5, 4, 6, 3}, {10}, {11}}\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  "Here is how the new version of ",
  StyleBox["ToCycles", "MR"],
  " works. Note the omission of the two singleton cycles {2} and {10} but \
retention of {11}. Note also that the other cycles are \
\[OpenCurlyDoubleQuote]rotated\[CloseCurlyDoubleQuote] until the smallest \
element in the cycle appears first."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rcycles\  = \ ToCycles[r]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({Cycle[1, 8, 9, 7], Cycle[3, 5, 4, 6], Cycle[11]}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  "Setting ",
  StyleBox["Normalize", "MR"],
  " to ",
  StyleBox["False", "MR"],
  " retains the structure of the ",
  StyleBox["DiscreteMath", "MR"],
  " approach but changes the lists to having the head ",
  StyleBox["Cycle", "MR"],
  "."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToCycles[r, \ Normalize\  \[Rule] \ False]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({Cycle[8, 9, 7, 1], Cycle[2], Cycle[5, 4, 6, 3], Cycle[10], Cycle[11]}
      \)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  StyleBox["FromCycles", "MR"],
  " takes any output of ",
  StyleBox["ToCycles", "MR"],
  " and acts as an inverse."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \({FromCycles[ToCycles[r, \ CycleAs\  \[Rule] \ List]]\  == \ r, \n
      FromCycles[ToCycles[r]]\  == \ r, \n
      FromCycles[ToCycles[r, \ \ Normalize\  \[Rule] \ False]]\  == \ r}\)], 
  "Input",
  CellLabel->"In[28]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({True, True, True}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  "The list of cycles needs to be disjoint before one can hope for a \
permutation to represent the cycle list. (This is a failure in the ",
  StyleBox["DiscreteMath", "MR"],
  " package; this is not checked.)"
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromCycles[{Cycle[2, 3], \ Cycle[1, 2]}]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \(Cycle::"disjoint" \( : \ \) 
      "The cycles in the list \!\({\(Cycle[\(2, 3\)]\), \(Cycle[\(1, \
2\)]\)}\) need to be disjoint to use this function."\)], "Message",
  CellTags->"Cycles"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToCycles", "MR"],
  " can also work on a ",
  StyleBox["list",
    FontSlant->"Italic"],
  " of permutations, returning a list of cycle decompositions."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToCycles[{RandomPermutation[8], RandomPermutation[8]}] // ColumnForm
      \)], "Input",
  CellLabel->"In[30]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({Cycle[1, 6, 2, 5, 7, 4], Cycle[8]}\)},
          {\({Cycle[1, 3, 6, 4, 7, 8], Cycle[2, 5]}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{
        Cycle[ 1, 6, 2, 5, 7, 4], 
        Cycle[ 8]}, {
        Cycle[ 1, 3, 6, 4, 7, 8], 
        Cycle[ 2, 5]}}],
      Editable->False]], "Output",
  CellLabel->"Out[30]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  "The permutation given to ",
  StyleBox["ToCycles", "MR"],
  " can be given as a list of rules (in various forms)."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ToCycles[{1 \[Rule] 4, 2 \[Rule] 3, 3 \[Rule] 1, 4 \[Rule] 2}], 
      ToCycles[1 \[Rule] 4, 2 \[Rule] 3, 3 \[Rule] 1, 4 \[Rule] 2], 
      ToCycles[{{1 \[Rule] 4}, {2 \[Rule] 3}, {3 \[Rule] 1}, {4 \[Rule] 2}}]}
      \)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({{Cycle[1, 4, 2, 3]}, {Cycle[1, 4, 2, 3]}, {Cycle[1, 4, 2, 3]}}\)], 
  "Output",
  CellLabel->"Out[31]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ToPermutation", "MR"],
  " can act on a cycle (as well as a list of rules representing a \
permutation, as we saw earlier)."
}], "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToPermutation[Cycle[2, \ 3, \ 5]]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"Cycles"],

Cell[BoxData[
    \({1, 3, 5, 4, 2}\)], "Output",
  CellLabel->"Out[32]=",
  CellTags->"Cycles"]
}, Open  ]],

Cell["5.2.5 Cycle operations", "Subsubsection",
  CellTags->{"CycleOperations", "i:13"}],

Cell[TextData[{
  "Cycles can be multiplied just as permutations can. In the following \
functions, the cycles can be either in list form or ",
  StyleBox["Cycle", "MR"],
  " form. These cycles are multiplied in the same order used by ",
  StyleBox["MultiplyPermutations", "MR"],
  ", which is ",
  StyleBox["RightToLeft", "MR"],
  " by default."
}], "Text",
  CellTags->"CycleOperations"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["MultiplyCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(cyc\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(cyc\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["give",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["the",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["product",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["of",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["cycle",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[
                          SubscriptBox[
                            StyleBox["cyc",
                              FontSlant->"Italic"], "1"],
                          "TraditionalForm"],
                        "Text"], 
                      StyleBox[\(followed\ by\ \),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[
                          SubscriptBox[
                            StyleBox["cyc",
                              FontSlant->"Italic"], "2"],
                          "TraditionalForm"],
                        "Text"]}], "\n", 
                    RowBox[{
                      StyleBox["as",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["a",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["permutation",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["of",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["length",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        SingleLetterItalics->False], 
                      StyleBox["n",
                        FontSlant->"Italic"], 
                      StyleBox[\(\ \((in\ \)\),
                        SingleLetterItalics->False], 
                      StyleBox[
                        FormBox[\(S\_n\),
                          "TraditionalForm"],
                        "Text"]}]}], 
                  StyleBox[")",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(multiplying\ from\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox[\(right\ to\ left\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MultiplyCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(cyc\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(cyc\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["product",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cycle",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], "1"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox["followed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], "2"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox["as",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["a",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["permutation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["length",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"], 
                    StyleBox[\(, \ where\ \),
                      SingleLetterItalics->False], 
                    StyleBox["n",
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["is",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["the",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["maximum",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[\(value\ appearing\ in\ either\ cycle\),
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(multiplying\ from\ right\ to\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              StyleBox["left",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["MultiplyCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  SubscriptBox["cyc", 
                    StyleBox["k",
                      "TI"]],
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", "\[Ellipsis]", 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(cyc\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(cyc\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ product\ of\ the\ cycles\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], "1"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(followed\ by\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], "2"],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(followed\ by\ \[Ellipsis]\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], 
                      StyleBox["k",
                        "Text"]],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["length",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"]}], 
              StyleBox[",",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["where",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["n",
                  FontSlant->"Italic"], 
                
                StyleBox[\(\ 
                  is\ the\ maximum\ value\ appearing\ in\ any\ cycle\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["MultiplyCycles",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["{",
                      "MR"], \(cyc\_k\), 
                    StyleBox[",",
                      "MR"], " ", "\[Ellipsis]", 
                    StyleBox[",",
                      "MR"], " ", \(cyc\_2\), 
                    StyleBox[",",
                      "MR"], " ", \(cyc\_1\), 
                    StyleBox["}",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["equivalent",
                    SingleLetterItalics->False], " ", 
                  StyleBox["to",
                    SingleLetterItalics->False], " ", 
                  StyleBox[
                    FormBox[
                      FormBox[
                        RowBox[{
                          StyleBox["MultiplyCycles",
                            "MR"], 
                          StyleBox["[",
                            "MR"], 
                          RowBox[{
                            SubscriptBox["cyc", 
                              StyleBox["k",
                                "TI"]], ",", " ", 
                            StyleBox["\[Ellipsis]",
                              SingleLetterItalics->False], 
                            StyleBox[",",
                              SingleLetterItalics->False], " ", \(cyc\_2\), 
                            ",", " ", \(cyc\_1\)}], 
                          StyleBox["]",
                            "MR"]}],
                        "TextForm"],
                      "TraditionalForm"],
                    "TI"]}],
                "TextForm"],
              "Text"]},
          {
            
            StyleBox[
              \(MultiplyCycles[ ... , \ ProductOrder\  \[Rule] \ LeftToRight]
                \),
              "MR"], 
            \(multiply\ the\ cycles\ by\ multiplying\ from\ left\ to\ right
              \)},
          {
            RowBox[{
              StyleBox[
                FormBox[\(cyc\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[" ",
                "TI"], 
              StyleBox["@",
                "MR"], " ", 
              StyleBox[
                FormBox[\(cyc\_1\),
                  "TraditionalForm"],
                "TI"]}], 
            RowBox[{"equivalent", " ", "to", " ", 
              RowBox[{
                StyleBox["MultiplyCycles",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                RowBox[{
                  StyleBox[
                    FormBox[\(cyc\_2\),
                      "TraditionalForm"],
                    "TI"], 
                  StyleBox[",",
                    "TI"], " ", 
                  StyleBox[
                    FormBox[\(cyc\_1\),
                      "TraditionalForm"],
                    "TI"]}], 
                StyleBox["]",
                  "MR"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"CycleOperations", "i:14"}],

Cell[TextData[{
  "Variations in the ",
  StyleBox["MultiplyCycles",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"CycleOperations"],

Cell["\<\
Here we obtain two different cycles by choosing the first cycle in \
the decomposition of two random permutations.\
\>", "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \({c1\  = \ First[ToCycles[RandomPermutation[12]]], \n
      c2\  = \ First[ToCycles[RandomPermutation[12]]]}\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \({Cycle[3, 8], Cycle[1, 8, 2, 6]}\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell[TextData[{
  "The product of the two cycles is performed by multiplying the cycles from \
right to left (by default). One can use the function name (",
  StyleBox["MultiplyCycles", "MR"],
  ") or the shortcut."
}], "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \({MultiplyCycles[c2, \ c1], \ c2\ @\ c1}\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \({{8, 6, 2, 4, 5, 1, 7, 3}, {8, 6, 2, 4, 5, 1, 7, 3}}\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell["\<\
The same result can be obtained by converting the cycles to \
permutations and then multiplying them.\
\>", "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p1\  = \ FromCycles[{c1}]; \np2\  = \ FromCycles[{c2}]; \n
    MultiplyPermutations[p2, \ p1]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \({8, 6, 2, 4, 5, 1, 7, 3}\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell[TextData[{
  "Actually, ",
  StyleBox["MultiplyPermutations", "MR"],
  " multiplies the cycles without first doing the conversion."
}], "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultiplyPermutations[c2, c1]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \({8, 6, 2, 4, 5, 1, 7, 3}\)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell[TextData[{
  "To convey that",
  " ",
  "these cycles are to be multiplied as elements in ",
  Cell[BoxData[
      \(TraditionalForm\`S\_9\)]],
  ", add 9 as the final argument."
}], "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultiplyCycles[Cycle[2, 3], \ Cycle[4, 6], \ 9]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \({1, 3, 2, 6, 5, 4, 7, 8, 9}\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell["\<\
When the cycles are not disjoint, the order in which these are \
multiplied matters.\
\>", "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \({MultiplyCycles[{Cycle[2, 6, 4], \ Cycle[4, 3, 1], \ 
          Cycle[2, 5, \ 1]}], \n
      MultiplyCycles[{Cycle[2, 5, \ 1], \ Cycle[2, 6, 4], \ Cycle[4, 3, 1]}]}
      \)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \({{6, 5, 1, 3, 2, 4}, {5, 6, 2, 3, 1, 4}}\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell["\<\
However, when the cycles are disjoint, the order of the factors is \
immaterial.\
\>", "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MultiplyCycles[{Cycle[2, 6, 4], \ Cycle[3, 5, \ 1]}]\  == \n
      MultiplyCycles[{Cycle[3, 5, \ 1], \ Cycle[2, 6, 4]}]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"CycleOperations"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"CycleOperations"]
}, Open  ]],

Cell["5.2.6 Other cycle-related functions", "Subsubsection",
  CellTags->"OtherCycle"],

Cell[TextData[{
  "The ",
  StyleBox["DisjointCyclesQ", "MR"],
  " function can ascertain whether the cycles in a list (or sequence) are \
disjoint."
}], "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DisjointCyclesQ[{Cycle[2, 6, 4], \ Cycle[3, 5, \ 1]}]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->"OtherCycle"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->"OtherCycle"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["DisjointCyclesQ",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  RowBox[{\(cyc\_1\), 
                    StyleBox[",",
                      "MR"], " ", \(cyc\_2\), 
                    StyleBox[",",
                      "MR"], " ", "\[Ellipsis]"}], 
                  StyleBox["]",
                    "MR"]}],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cycles",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], "1"],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  SubscriptBox[
                    StyleBox["cyc",
                      FontSlant->"Italic"], "2"],
                  "TraditionalForm"],
                "Text"], ",", 
              StyleBox[\(\[Ellipsis]\ are\ disjoint\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["DisjointCyclesQ",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  RowBox[{
                    StyleBox["{",
                      "MR"], 
                    RowBox[{\(cyc\_1\), 
                      StyleBox[",",
                        "MR"], " ", \(cyc\_2\), 
                      StyleBox[",",
                        "MR"], " ", "\[Ellipsis]"}], 
                    StyleBox["}",
                      "MR"]}], 
                  StyleBox["]",
                    "MR"]}],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cycles",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyc",
                        FontSlant->"Italic"], "1"],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  SubscriptBox[
                    StyleBox["cyc",
                      FontSlant->"Italic"], "2"],
                  "TraditionalForm"],
                "Text"], ",", 
              StyleBox[\(\[Ellipsis]\ are\ disjoint\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["SamePermutationQ",
                    "MR"], 
                  StyleBox["[",
                    "MR"], 
                  RowBox[{\(cyclist\_1\), 
                    StyleBox[",",
                      "MR"], " ", \(cyclist\_2\)}], 
                  StyleBox["]",
                    "MR"]}],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["cycles",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    SubscriptBox[
                      StyleBox["cyclist",
                        FontSlant->"Italic"], "1"],
                    "TraditionalForm"],
                  "Text"], " ", "represent", " ", "the", " ", "same"}], " ", 
              "\n", 
              RowBox[{
                RowBox[{"permutation", "  ", "as", " ", 
                  StyleBox[
                    FormBox[
                      RowBox[{"the", " ", "cycles", " ", "in", " ", 
                        SubscriptBox[
                          StyleBox["cyclist",
                            FontSlant->"Italic"], "2"]}],
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"OtherCycle", "i:15"}],

Cell["Other functions related to cycles.", "Caption",
  CellTags->"OtherCycle"],

Cell[TextData[{
  "Representing a permutation with cycles is not unique. The function ",
  StyleBox["SamePermutationQ", "MR"],
  " determines whether two lists of cycles represent the same permutation."
}], "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{

Cell[BoxData[
    \({SamePermutationQ[{{1, 8}, {3, 2, 5}}, {{5, 3, 2}, {8, 1}}], \ 
      SamePermutationQ[{Cycle[1, 8], Cycle[3, 2, 5]}, {Cycle[5, 3, 2], 
          Cycle[8, 1]}]}\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->"OtherCycle"],

Cell[BoxData[
    \({True, True}\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->"OtherCycle"]
}, Open  ]],

Cell["\<\
Cycles of length two are called transpositions. Any cycle can be \
written as a product of transpositions, and consequently so can any \
permutation. While the number of transpositions in a given permutation is not \
unique, whether this number is odd or even is fixed.\
\>", "Text",
  CellTags->{"OtherCycle", "i:16"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ToTranspositions",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["cyc",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ the\ cycle\ \),
                  SingleLetterItalics->False], 
                StyleBox["cyc",
                  FontSlant->"Italic"], 
                StyleBox[\(\ as\ a\ product\ of\ transpositions\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ToTranspositions",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["as",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["product",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              StyleBox["transpositions",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.38, 0.62}},
  CellTags->{"OtherCycle", "i:17"}],

Cell["Converting to transpositions.", "Caption",
  CellTags->"OtherCycle"],

Cell["\<\
Here we convert a random permutation of length six into \
transpositions.\
\>", "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToTranspositions[p\  = \ RandomPermutation[6]]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->"OtherCycle"],

Cell[BoxData[
    \({Cycle[1, 2], Cycle[1, 5], Cycle[1, 3], Cycle[1, 6], Cycle[1, 4]}\)], 
  "Output",
  CellLabel->"Out[42]=",
  CellTags->"OtherCycle"]
}, Open  ]],

Cell["\<\
In this case, first we convert the same permutation to cycles and \
then convert each cycle into transpositions.\
\>", "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ToTranspositions, ToCycles[p]]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"OtherCycle"],

Cell[BoxData[
    \({{Cycle[1, 2], Cycle[1, 5], Cycle[1, 3], Cycle[1, 6], Cycle[1, 4]}}\)], 
  "Output",
  CellLabel->"Out[43]=",
  CellTags->"OtherCycle"]
}, Open  ]],

Cell["\<\
The number of transpositions in a permutation gives some \
information about the permutation. Actually, whether the number of \
transpositions is even or odd is what is important. The following functions \
can be used in ascertaining this.\
\>", "Text",
  CellTags->"OtherCycle"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["EvenPermutationQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm",
                  FontSlant->"Italic"], 
                StyleBox[\(\ is\ an\ even\ permutation, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["OddPermutationQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm",
                  FontSlant->"Italic"], 
                StyleBox[\(\ is\ an\ odd\ permutation, \ and\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["Parity",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ 1\ if\ \),
                  SingleLetterItalics->False], 
                StyleBox["perm",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["even",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutation",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(and\ \(\(-1\)\ if\ an\ odd\ permutation\)\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.39, 0.61}},
  CellTags->{"OtherCycle", "i:18"}],

Cell["Functions dealing with the parity of a permutation.", "Caption",
  CellTags->"OtherCycle"],

Cell[TextData[
"First, let\[CloseCurlyQuote]s create five random permutations of length \
six."], "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[p]\), 
    \(Table[p[k]\  = \ \ RandomPermutation[6], \ {k, \ 5}]\)}], "Input",
  CellLabel->"In[44]:=",
  CellTags->"OtherCycle"],

Cell[BoxData[
    \({{5, 6, 3, 1, 4, 2}, {3, 5, 4, 6, 2, 1}, {3, 2, 1, 4, 5, 6}, {2, 4, 5, 
        6, 3, 1}, {5, 4, 3, 1, 6, 2}}\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->"OtherCycle"]
}, Open  ]],

Cell["\<\
Now consider the following table that shows how the \
oddness/evenness of a permutation is related to the number of transpositions.\
\
\>", "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[
      Table[{p[k], \ Parity[p[k]], \ OddPermutationQ[p[k]], \ 
          Length[ToTranspositions[p[k]]]}, \ {k, \ 5}], 
      TableDepth\  \[Rule] \ 2, 
      TableHeadings\  \[Rule] 
        \ {None, 
          \ {"\<p\>", \ "\<parity\>", "\<odd?\>", "\<# of transp.\n\>"}}, \ 
      TableSpacing\  \[Rule] \ {0.5, \ 2}]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->"OtherCycle"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"p\"\>", "\<\"parity\"\>", "\<\"odd?\"\>", 
            \("# of transp.\n"\)},
          {\({5, 6, 3, 1, 4, 2}\), \(-1\), "True", "3"},
          {\({3, 5, 4, 6, 2, 1}\), "1", "False", "4"},
          {\({3, 2, 1, 4, 5, 6}\), \(-1\), "True", "3"},
          {\({2, 4, 5, 6, 3, 1}\), "1", "False", "4"},
          {\({5, 4, 3, 1, 6, 2}\), "1", "False", "4"}
          },
        RowSpacings->0.5,
        ColumnSpacings->2,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableDepth -> 2, TableHeadings -> {None, {"p", "parity", 
        "odd?", "# of transp.\n"}}, TableSpacing -> {0.5, 2}]&)]], "Output",
  CellLabel->"Out[46]//TableForm=",
  CellTags->"OtherCycle"]
}, Open  ]],

Cell["5.2.7 Stabilizers and orbits", "Subsubsection",
  CellTags->{"Stabilizers", "i:19"}],

Cell[TextData[{
  "Since a permutation can be regarded as a function, we can ask whether the \
permutation sends a value ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  " to itself. If so, we say the permutation ",
  StyleBox["fixes",
    FontSlant->"Italic"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ". More generally, we can ask about the image of any element."
}], "Text",
  CellTags->"Stabilizers"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["FixQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"], 
                StyleBox[\(\ \((of\ \({1, \ 2, \ \[Ellipsis], \ \)\)\),
                  SingleLetterItalics->False], 
                FormBox["n",
                  "TraditionalForm"], 
                StyleBox[\(\(})\)\ fixes\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox["k",
                  FontSlant->"Italic"], 
                StyleBox[\(\(, \ and\)\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["FixQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["el",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["p",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["elements",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["set",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ fixes\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox["el",
                  FontSlant->"Italic"], 
                StyleBox[\(\ \((from\ \)\),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\(), \ and\)\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["PermutationImage",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["k",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ the\ image\ of\ \),
                  SingleLetterItalics->False], 
                FormBox["k",
                  "TraditionalForm"], 
                StyleBox[\(\ under\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["PermutationImage",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["p",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["el",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ the\ image\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox["el",
                  FontSlant->"Italic"], 
                StyleBox[\(\ under\ the\ permutation\ \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"], 
                StyleBox[\(\ of\ the\ elements\ in\ the\ set\ \),
                  SingleLetterItalics->False], 
                FormBox["S",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.42, 0.58}},
  CellTags->"Stabilizers"],

Cell[TextData[{
  StyleBox["FixQ",
    FontFamily->"Courier"],
  " and ",
  StyleBox["PermutationImage",
    FontFamily->"Courier"],
  " variations."
}], "Caption",
  CellTags->"Stabilizers"],

Cell[TextData[{
  "The permutation ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " fixes 5 because it sends 5 to itself."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(FixQ[p\  = \ {2, 3, 4, 1, 5}, \ 5]\),
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input",
  CellLabel->"In[47]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["PermutationImage", "MR"],
  " function confirms this."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PermutationImage[p, \ 5]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell["\<\
Here we see that the element \"c\" is not fixed, since it is sent \
to \"e\".\
\>", "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
    \(Sset\  = \ {"\<a\>", "\<b\>", "\<c\>", "\<d\>", "\<e\>"}\), ";", "\n", 
      \(p\  = \ {"\<c\>", "\<b\>", "\<e\>", "\<d\>", "\<a\>"}\), ";", "\n", 
      RowBox[{"{", 
        StyleBox[\(FixQ[Sset, p, "\<c\>"], \ 
          PermutationImage[Sset, p, "\<c\>"]\),
          FontFamily->"Courier",
          FontWeight->"Bold"], 
        StyleBox["}",
          FontFamily->"Courier",
          FontWeight->"Bold"]}]}]], "Input",
  CellLabel->"In[49]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \({False, "e"}\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "Given a group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " of permutations on a set ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  ", and given an element ",
  Cell[BoxData[
      \(TraditionalForm\`x\  \[Element] \ S\)]],
  ", we are often interested in the ",
  StyleBox["stabilizer",
    FontSlant->"Italic"],
  " and ",
  StyleBox["orbit",
    FontSlant->"Italic"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "."
}], "Text",
  CellTags->"Stabilizers"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Stabilizer",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ stabilizer\ of\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["x",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["from",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["set",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["where",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ a\ group\ of\ permutations\ on\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Stabilizer",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ stabilizer\ of\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["x",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["from",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["set",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["where",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["understood",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ the\ full\ group\ of\ permutations\ on\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Orbit",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ orbit\ of\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["x",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["from",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["set",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["where",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ a\ group\ of\ permutations\ on\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Orbit",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ orbit\ of\ the\ element\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["x",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["from",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["set",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["where",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["understood",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["group",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["G",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ is\ the\ full\ group\ of\ permutations\ on\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.31, 0.69}},
  CellTags->{"Stabilizers", "i:20"}],

Cell["How to work with orbits and stabilizers.", "Caption",
  CellTags->"Stabilizers"],

Cell[TextData[{
  "Let ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " be a group formed from cycles as follows. Note that ",
  Cell[BoxData[
      \(TraditionalForm\`\( | G | \) = 6\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`S\_8\)]],
  "."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(G\  = \ 
      FormGroupoidFromCycles[{Cycle[1], \ 
          Cycle[1, 3, 2]\ @\ \(Cycle[4, 6, 5]\ @\ Cycle[7, 8]\), \n
          Cycle[1, 3, 2]\ @\ Cycle[4, 6, 5]\ , \n
          Cycle[1, 2, 3]\ @\ Cycle[4, 5, 6]\ , \n
          Cycle[1, 2, 3]\ @\ \(Cycle[4, 5, 6]\ @\ Cycle[7, 8]\), \n
          Cycle[7, 8]}]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \(Groupoid[{{1, 2, 3, 4, 5, 6, 7, 8}, {3, 1, 2, 6, 4, 5, 8, 7}, {3, 1, 2, 
          6, 4, 5, 7, 8}, {2, 3, 1, 5, 6, 4, 7, 8}, {2, 3, 1, 5, 6, 4, 8, 
          7}, {1, 2, 3, 4, 5, 6, 8, 7}}, "-Operation-"]\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "The orbit of 4 under the group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is the set {4, 6, 5}."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Orbit[G, \ Range[8], \ 4]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \({4, 6, 5}\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "The orbit can also be obtained by directly applying the definition of the \
orbit, ",
  Cell[BoxData[
      \(TraditionalForm\`{\[Phi](s)\  | \ \[Phi]\  \[Element] \ G}\)]],
  "."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[PermutationImage[Range[8], #, 4]&, \ Elements[G]]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \({4, 6, 6, 5, 5, 4}\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell["\<\
The stabilizer of the same element with the same group is the set \
of the following two permutations.\
\>", "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Stabilizer[G, \ Range[8], \ 4]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5, 6, 7, 8}, {1, 2, 3, 4, 5, 6, 8, 7}}\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "This set can also be obtained by directly applying the definition of \
stabilizer, ",
  Cell[BoxData[
      \(TraditionalForm
      \`{\[Phi]\  \[Element] \ G\  | \ \[Phi](x)\  = \ x}\)]],
  "."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Elements[G], \ PermutationImage[Range[8], #, 4]\  == \ 4&]\)], 
  "Input",
  CellLabel->"In[54]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5, 6, 7, 8}, {1, 2, 3, 4, 5, 6, 8, 7}}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "Using the ",
  StyleBox["FixQ", "MR"],
  " function, the following may be more natural."
}], "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Elements[G], \ FixQ[#, 4]\ &]\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"Stabilizers"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5, 6, 7, 8}, {1, 2, 3, 4, 5, 6, 8, 7}}\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"Stabilizers"]
}, Open  ]],

Cell[TextData[{
  "5.3 Working in ",
  Cell[BoxData[
      FormBox[
        RowBox[{"\[DoubleStruckCapitalZ]", "[", 
          SqrtBox["d"], "]"}], TraditionalForm]]]
}], "Subsection",
  CellTags->{"BasicZ", "i:21"}],

Cell["5.3.1 Basic functions", "Subsubsection",
  CellTags->"BasicZ"],

Cell[TextData[{
  "It may be worthwhile to first preview the ",
  StyleBox["Adjoin", "MR"],
  " function discussed in the next section, since it is related. Here we \
would like to focus on working with elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  ", which is the set obtained by adjoining the square root of some integer ",
  
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " to the integers. (We want ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " to be square-free.) This set is of interest when considering unique \
factorization domains (UFD). First we look at some basic functions, then we \
look at some functions for divisibility."
}], "Text",
  CellTags->"BasicZ"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ZdQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["x",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(give\ \),
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[\(\ if\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["x",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["can",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["be",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["viewed",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["as",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["an",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["element",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{"\n", 
                      RowBox[{
                        StyleBox["\[DoubleStruckCapitalZ]",
                          SingleLetterItalics->False], "[", \(\@d\), "]"}]}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["for",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["some",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["integer",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ZdConjugate",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{"a", " ", 
                    StyleBox["+",
                      "MR"], " ", \(b \@d\)}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                FormBox[
                  RowBox[{
                    StyleBox[" ",
                      FontSlant->"Italic"], 
                    RowBox[{
                      StyleBox["a",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["-",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      RowBox[{
                        StyleBox["b",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"], " ", 
                        FormBox[\(\@d\),
                          "TraditionalForm"]}]}]}],
                  "TraditionalForm"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZdUnitQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ \),
                  SingleLetterItalics->False], 
                FormBox["x",
                  "TraditionalForm"], 
                StyleBox[\(\ is\ a\ unit\ in\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  RowBox[{
                    StyleBox["\[DoubleStruckCapitalZ]",
                      SingleLetterItalics->False], "[", \(\@d\), "]"}],
                  "TraditionalForm"], 
                StyleBox[\(\(, \ and\)\ \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZdDivide",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["x",
                  "TI"], 
                StyleBox[",",
                  "MR"], 
                StyleBox["y",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{"return", " ", "the", " ", "quotient", " ", 
                  StyleBox[\(x/y\),
                    FontSlant->"Italic"], " ", "in", " ", "the", " ", "form", 
                  " ", 
                  StyleBox["r",
                    FontSlant->"Italic"]}], " ", "+", " ", 
                RowBox[{
                  StyleBox["s",
                    FontSlant->"Italic"], " ", 
                  StyleBox[\(\@d\),
                    FontSlant->"Italic"]}]}], " ", "\n", 
              RowBox[{"when", " ", 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "and", " ", 
                StyleBox["y",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], "are", " ", "both", " ", "in", " ", 
                RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                  SqrtBox[
                    StyleBox["d",
                      FontSlant->"Italic"]], "]"}]}]}]},
          {
            RowBox[{
              StyleBox["ZdAssociatesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["y",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{"give", " ", 
                StyleBox["True",
                  "MR"], " ", "if", " ", 
                StyleBox["x",
                  FontSlant->"Italic"], " ", "and", " ", 
                StyleBox["y",
                  FontSlant->"Italic"], " ", "are", " ", "associates", " ", 
                "in", " ", 
                RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                  SqrtBox[
                    StyleBox["d",
                      FontSlant->"Italic"]], "]"}]}], ",", " ", 
              RowBox[{"and", " ", 
                StyleBox["False",
                  "MR"], " ", "otherwise"}]}]},
          {
            RowBox[{
              StyleBox["ZdIrreducibleQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{"for", " ", "negative", " ", 
                  StyleBox["d",
                    FontSlant->"Italic"]}], ",", " ", 
                RowBox[{"give", " ", 
                  StyleBox["True",
                    "MR"], " ", "if", " ", 
                  StyleBox["x",
                    FontSlant->"Italic"], " ", "is", " ", "irreducible"}]}], 
              " ", 
              RowBox[{
                RowBox[{"in", " ", 
                  RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                    SqrtBox[
                      StyleBox["d",
                        FontSlant->"Italic"]], "]"}]}], ",", " ", 
                RowBox[{"and", " ", 
                  StyleBox["False",
                    "MR"], " ", "otherwise"}]}]}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["RandomElement",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{"d", 
                      StyleBox[",",
                        "MR"], " ", "max"}], 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{"return", " ", 
                    StyleBox["a",
                      FontSlant->"Italic"]}], 
                  StyleBox[" ",
                    FontSlant->"Italic"], "+", " ", 
                  RowBox[{
                    StyleBox["b",
                      FontSlant->"Italic"], " ", 
                    SqrtBox[
                      StyleBox["d",
                        FontSlant->"Italic"]], " ", "where", " ", 
                    StyleBox["a",
                      FontSlant->"Italic"]}]}], ",", " ", 
                RowBox[{
                  StyleBox["b",
                    FontSlant->"Italic"], " ", "\[Element]", " ", 
                  RowBox[{"[", 
                    RowBox[{
                      RowBox[{"-", 
                        StyleBox["max",
                          FontSlant->"Italic"]}], ",", " ", 
                      StyleBox["max",
                        FontSlant->"Italic"]}], "]"}]}]}], " ", "\n", 
              \(and\ are\ integers\)}]},
          {
            StyleBox[
              FormBox[
                FormBox[
                  RowBox[{
                    StyleBox["RandomElements",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{"d", 
                      StyleBox[",",
                        "MR"], " ", "max", ",", " ", "n"}], 
                    StyleBox["]",
                      "MR"]}],
                  "NotebookDefault"],
                "TraditionalForm"],
              "TI"], 
            RowBox[{"return", " ", 
              StyleBox["n",
                FontSlant->"Italic"], " ", "random", " ", "elements", " ", 
              "in", " ", 
              RowBox[{"\[DoubleStruckCapitalZ]", "[", 
                SqrtBox[
                  StyleBox["d",
                    FontSlant->"Italic"]], "]"}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.36, 0.64}},
  CellTags->{"BasicZ", "i:22"}],

Cell["Basic functions.", "Caption",
  CellTags->"BasicZ"],

Cell[TextData[{
  "Some numbers do not belong to any set ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  " ."
}], "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[
      ZdQ, {3\  - \ \@5, \@5\%3, \ 18, \[Pi], 2\  + \ 17 \@\(\(-3\)\ \), \ 
        RandomElement[\(-3\), \ 25]}]\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"BasicZ"],

Cell[BoxData[
    \({True, False, True, False, True, True}\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"BasicZ"]
}, Open  ]],

Cell[TextData[{
  "The conjugate of ",
  Cell[BoxData[
      \(TraditionalForm\`a\  + \ b\ \@d\)]],
  " is ",
  Cell[BoxData[
      \(TraditionalForm\`a\  - \ b\ \@d\)]],
  "."
}], "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ZdConjugate, {3\  - \ \@5, 2\  + \ \@\(-8\), \ 18}]\)], "Input",
  CellLabel->"In[57]:=",
  CellTags->"BasicZ"],

Cell[BoxData[
    \({3 + \@5, 2 - 2\ I\ \@2, 18}\)], "Output",
  CellLabel->"Out[57]=",
  CellTags->"BasicZ"]
}, Open  ]],

Cell[TextData[{
  "We can ask whether an element is a unit in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  "."
}], "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ZdUnitQ[2, #]&, \ {1 + \@2, \(-1\), \ 2 + \@2, 1\  - \ \@2}]\)], 
  "Input",
  CellLabel->"In[58]:=",
  CellTags->"BasicZ"],

Cell[BoxData[
    \({True, True, False, True}\)], "Output",
  CellLabel->"Out[58]=",
  CellTags->"BasicZ"]
}, Open  ]],

Cell[TextData[{
  "Here we calculate a quotient between two elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  "."
}], "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(q\  = \ ZdDivide[2\  - \ 3\ \@2, \ 1\  + \ \@2]\)], "Input",
  CellLabel->"In[59]:=",
  CellTags->"BasicZ"],

Cell[BoxData[
    \(\(-8\) + 5\ \@2\)], "Output",
  CellLabel->"Out[59]=",
  CellTags->"BasicZ"]
}, Open  ]],

Cell[TextData[{
  "Since we just saw that 1 + ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  " is a unit in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  ", 2 - 3",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  " and the previous quotient should be associates."
}], "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdAssociatesQ[2, \ 2\  - \ 3\ \@2, \ q]\)], "Input",
  CellLabel->"In[60]:=",
  CellTags->"BasicZ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[60]=",
  CellTags->"BasicZ"]
}, Open  ]],

Cell["Irreducibility can be tested as follows.", "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ZdIrreducibleQ[\(-3\), \ #]&, \ {2\  - \ 5 \@\(-3\), \ 5, \ 7}]\)], 
  "Input",
  CellLabel->"In[61]:=",
  CellTags->"BasicZ"],

Cell[BoxData[
    \({True, True, False}\)], "Output",
  CellLabel->"Out[61]=",
  CellTags->"BasicZ"]
}, Open  ]],

Cell["5.3.2 Divisibility", "Subsubsection",
  CellTags->{"DivisibilityZ", "i:23"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DividesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["r",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["s",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["integer",
                  SingleLetterItalics->False], " ", 
                StyleBox[
                  FormBox["s",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["divided",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False]}], 
              RowBox[{
                RowBox[{
                  StyleBox["integer",
                    SingleLetterItalics->False], " ", 
                  StyleBox[
                    FormBox["r",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["yields",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["an",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["integer",
                    SingleLetterItalics->False]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["otherwise",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["IntegerDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["equivalent",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["to",
                "Text"], 
              StyleBox[
                FormBox[
                  FormBox[
                    RowBox[{" ", 
                      StyleBox["Divisors",
                        "MR"], 
                      StyleBox["[",
                        "MR"], "n", 
                      StyleBox["]",
                        "MR"]}],
                    "NotebookDefault"],
                  "TraditionalForm"],
                "TI"]}]},
          {
            RowBox[{
              StyleBox["IntegerDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(n, \ opts\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["equivalent",
                "Text"], 
              StyleBox[" ",
                "Text"], 
              StyleBox["to",
                "Text"], 
              StyleBox[
                FormBox[
                  RowBox[{
                    RowBox[{
                      FormBox[
                        RowBox[{" ", 
                          StyleBox["Divisors",
                            "MR"], 
                          StyleBox["[",
                            "MR"], "n", 
                          StyleBox["]",
                            "MR"]}],
                        "NotebookDefault"], 
                      StyleBox["with",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], 
                      StyleBox["additional",
                        FontSlant->"Plain"]}], 
                    StyleBox[" ",
                      FontSlant->"Plain"], 
                    RowBox[{
                      StyleBox["options",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], 
                      StyleBox["specified",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], 
                      StyleBox["below",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], 
                      StyleBox["with",
                        FontSlant->"Plain"], 
                      StyleBox[" ",
                        FontSlant->"Plain"], 
                      StyleBox["ZdDivisors",
                        "MR",
                        FontSlant->"Plain"]}]}],
                  "TraditionalForm"],
                "TI"]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.32, 0.68}},
  CellTags->{"DivisibilityZ", "i:24"}],

Cell["Functions for working with the ordinary integers.", "Caption",
  CellTags->"DivisibilityZ"],

Cell[TextData[{
  "It is the case that ",
  Cell[BoxData[
      \(TraditionalForm\`4\  | \ 8\)]],
  ", but it is not true that ",
  Cell[BoxData[
      \(TraditionalForm\`8\  | \ 4\)]],
  "."
}], "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \({DividesQ[4, \ 8], \ DividesQ[8, 4]}\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({True, False}\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell["Here we have the divisors of 28 paired up in a natural way.", 
  "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDivisors[28, \ Combine\  \[Rule] \ Products]\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{1, 28}, {2, 14}, {4, 7}}\)], "Output",
  CellLabel->"Out[63]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell["\<\
Here we contrast the divisors of 28 with the nontrivial divisors of \
28.\
\>", "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Divisors[28], \ IntegerDivisors[28, \ NonTrivialOnly\  \[Rule] \ True]}
      \)], "Input",
  CellLabel->"In[64]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{1, 2, 4, 7, 14, 28}, {2, 4, 7, 14}}\)], "Output",
  CellLabel->"Out[64]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[
              FormBox[
                RowBox[{
                  StyleBox["DividesQ",
                    "MR"], 
                  StyleBox["[",
                    "MR"], " ", 
                  RowBox[{
                    RowBox[{"a", " ", 
                      StyleBox["+",
                        "MR"], " ", \(b\ \@d\)}], 
                    StyleBox[",",
                      "MR"], " ", 
                    RowBox[{"c", " ", 
                      StyleBox["+",
                        "MR"], " ", \(e\ \@d\)}], 
                    StyleBox[",",
                      "MR"], " ", 
                    RowBox[{
                      StyleBox["Radical",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox["\[Rule]",
                        "MR"], " ", "d"}]}], 
                  StyleBox["]",
                    "MR"]}],
                "TraditionalForm"],
              "TI"], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["if",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      RowBox[{
                        StyleBox["a",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"], " ", 
                        StyleBox["+",
                          SingleLetterItalics->False], " ", 
                        RowBox[{
                          StyleBox["b",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"], " ", \(\@d\)}]}], " ", 
                      StyleBox["|",
                        SingleLetterItalics->False], " ", 
                      RowBox[{
                        StyleBox["c",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"], " ", 
                        StyleBox["+",
                          SingleLetterItalics->False], " ", 
                        RowBox[{
                          StyleBox["e",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"], " ", \(\@d\)}]}]}],
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["otherwise",
                  SingleLetterItalics->False]}]}]},
          {
            RowBox[{
              StyleBox["ZdDividesQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["r",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["s",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(equivalent\ to\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["DividesQ",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["r",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["s",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox[
                          FormBox[
                            RowBox[{
                              StyleBox["Radical",
                                "MR"], " ", 
                              StyleBox["\[Rule]",
                                "MR"], 
                              StyleBox[" ",
                                "MR"], 
                              StyleBox["d",
                                SingleLetterItalics->False]}],
                            "TraditionalForm"],
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZdDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(return\ the\ divisors\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["x",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["\[DoubleStruckCapitalZ]",
                        SingleLetterItalics->False], "[", \(\@d\), "]"}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[\(\ for\ negative\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["d",
                    "TraditionalForm"],
                  "Text"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(giving\ only\ one\ divisor\ per\ class\ of\ associates\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["using",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["options",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["specified",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["ZdDivisors",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["x",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["max",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[\(return\ the\ divisors\ of\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["x",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ in\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["\[DoubleStruckCapitalZ]",
                          SingleLetterItalics->False], "[", \(\@d\), "]"}],
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ for\ positive\ \),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["d",
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                
                StyleBox[
                  \(whose\ norm\ is\ less\ than\ or\ equal\ to\ the\ norm\),
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["max",
                  FontSlant->"Italic"], 
                StyleBox[\(\(, \ using\ the\ options\ specified\ in\)\ \),
                  SingleLetterItalics->False], 
                StyleBox["opts",
                  FontSlant->"Italic"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"DivisibilityZ", "i:25"}],

Cell[TextData[{
  "Divisor-related functions for elements in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  "."
}], "Caption",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox[\(option\ name\),
              "SO10"], 
            StyleBox["value",
              "SO10"], 
            StyleBox[
              FormBox[" ",
                "StandardForm"],
              "Text"]},
          {
            StyleBox[
              FormBox["DivisorsComplete",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["include",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["all",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["divisors",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["if",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["set",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["to",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["but",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(only\ include\ one\ from\ each\ class\ of\ associates\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                
                StyleBox[
                  \((typically\ one\ in\ the\ first\ quadrant\ or\ right\ \n
                      half\[Hyphen]plane)\),
                  SingleLetterItalics->False], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox[\(if\ set\ to\),
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\(\ \)(default)\),
                    SingleLetterItalics->False]}]}]}]},
          {
            StyleBox[
              FormBox["NonTrivialOnly",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            RowBox[{
              StyleBox[\(if\ set\ to\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(exclude\ all\ associates\ of\ 1\ and\ the\ number\ whose\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(divisors\ we\ are\ seeking\),
                SingleLetterItalics->False], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(while\ include\ them\ if\ set\ to\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\(\ \)(default)\),
                SingleLetterItalics->False]}]},
          {
            StyleBox[
              FormBox["Combine",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["False",
                "StandardForm"],
              "Text"], 
            StyleBox[\(do\ not\ combine\ the\ divisors\ in\ any\ manner\ \n
              \((default\ value)\)\),
              SingleLetterItalics->False]},
          {
            StyleBox[
              FormBox["Combine",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Products",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[\(combine\ divisors, \ if\ possible, \ 
                in\ pairs\ of\ the\ form\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{"{", 
                      StyleBox["a",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], ",", 
                      StyleBox[" ",
                        FontSlant->"Italic"], 
                      StyleBox["b",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], "}"}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["where",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["a",
                        SingleLetterItalics->False], 
                      StyleBox[" ",
                        FontSlant->"Plain"], 
                      StyleBox["*",
                        SingleLetterItalics->False,
                        FontSlant->"Plain"], " ", 
                      StyleBox["b",
                        SingleLetterItalics->False]}],
                    "TraditionalForm"],
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["is",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["number",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["whose",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["divisors",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["we",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["seeking",
                  SingleLetterItalics->False]}]}]},
          {
            StyleBox[
              FormBox["Combine",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Negations",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[\(combine\ divisors, \ if\ possible, \ 
                in\ pairs\ of\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{"{", 
                      StyleBox["a",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], ",", " ", 
                      StyleBox["-",
                        SingleLetterItalics->False], 
                      StyleBox["a",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], "}"}],
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            StyleBox[
              FormBox["Combine",
                "StandardForm"],
              "Text"], 
            StyleBox[
              FormBox["Associates",
                "StandardForm"],
              "Text"], 
            RowBox[{
              
              StyleBox[
                \(combine\ divisors, \ if\ possible, \ in\ lists\ where\ each
                  \ element\ in\ a\ list\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[\(is\ an\ associate\ of\ the\ others\),
                SingleLetterItalics->False], 
              StyleBox[";",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["d",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], " ", 
                    StyleBox["<",
                      SingleLetterItalics->False], " ", "-", "1", ","}],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["this",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["same",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Negations",
                "MR"]}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  GridBoxOptions->{ColumnWidths->{0.2, 0.19, 0.61},
  RowLines->{True, False}},
  CellTags->{"DivisibilityZ", "i:26"}],

Cell[TextData[{
  "Options for ",
  StyleBox["IntegerDivisors",
    FontFamily->"Courier"],
  " and ",
  StyleBox["ZdDivisors",
    FontFamily->"Courier"],
  "."
}], "Caption",
  CellTags->"DivisibilityZ"],

Cell[TextData[{
  "We use the following to determine if ",
  Cell[BoxData[
      \(TraditionalForm\`1\  - \ 3\ \@\(-5\)\)]],
  " divides 46 over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  "."
}], "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DividesQ[\ 1\  - \ 3 \@\(-5\), 46, \ Radical\  \[Rule] \(-5\)]\)], 
  "Input",
  CellLabel->"In[65]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[65]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell["This is an alternate way of accomplishing the same thing.", 
  "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdDividesQ[\(-5\), \ 1\  - \ 3 \@\(-5\), 46]\)], "Input",
  CellLabel->"In[66]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[66]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell[TextData[{
  "Since we know that ",
  Cell[BoxData[
      \(TraditionalForm\`1\  - \ 3\ \@\(-5\)\  | \ 46\)]],
  ", we may be interested in knowing the other divisor (yielding a product of \
46)."
}], "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdDivide[46, \ 1\  - \ 3 \@\(-5\)]\)], "Input",
  CellLabel->"In[67]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \(1 + 3\ I\ \@5\)], "Output",
  CellLabel->"Out[67]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell["\<\
In this case, we are asking for all the divisors of 24 to be paired \
so that the product is 24.\
\>", "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDivisors[24, \ DivisorsComplete\  \[Rule] \ True, \ 
      Combine\  \[Rule] \ Products]\)], "Input",
  CellLabel->"In[68]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{\(-24\), \(-1\)}, {\(-12\), \(-2\)}, {\(-8\), \(-3\)}, {\(-6\), 
        \(-4\)}, {1, 24}, {2, 12}, {3, 8}, {4, 6}}\)], "Output",
  CellLabel->"Out[68]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell[TextData[{
  "Now we are looking for the divisors of 28 in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  " in order to pair them by associates. Since we are not looking for the \
complete list of divisors, all the negations (of the ones listed) are \
excluded. Since the negations are the only associates, each class has a \
single element."
}], "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdDivisors[\(-5\), \ 28, \ Combine\  \[Rule] \ Associates]\)], "Input",
  CellLabel->"In[69]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{1}, {2}, {4}, {7}, {14}, {28}, {3 - I\ \@5}, {3 + I\ \@5}, {
        6 - 2\ I\ \@5}, {6 + 2\ I\ \@5}}\)], "Output",
  CellLabel->"Out[69]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell[TextData[{
  "When we set ",
  StyleBox["DivisorsComplete", "MR"],
  " to ",
  StyleBox["True", "MR"],
  ", the natural pairing of associates (negations in this case) is given. \
Note also that ",
  StyleBox["NonTrivialOnly", "MR"],
  " set to ",
  StyleBox["True", "MR"],
  " prevents \[PlusMinus] 1 and \[PlusMinus] 28 from being listed."
}], "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdDivisors[\(-5\), 28, \ Combine\  \[Rule] \ Associates, \ 
      DivisorsComplete\  \[Rule] \ True, \ NonTrivialOnly\  \[Rule] \ True]
      \)], "Input",
  CellLabel->"In[70]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{\(-14\), 14}, {\(-7\), 7}, {\(-4\), 4}, {\(-2\), 2}, {
        \(-3\) - I\ \@5, 3 + I\ \@5}, {3 - I\ \@5, \(-3\) + I\ \@5}, {
        \(-6\) - 2\ I\ \@5, 6 + 2\ I\ \@5}, {6 - 2\ I\ \@5, 
        \(-6\) + 2\ I\ \@5}}\)], "Output",
  CellLabel->"Out[70]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell[TextData[{
  "Since the ring \[DoubleStruckCapitalZ]",
  Cell[BoxData[
      \(TraditionalForm\`\([i]\)\)]],
  " has four units, ",
  Cell[BoxData[
      \(TraditionalForm\`{\(\[PlusMinus]1\), \(\[PlusMinus]i\)}\)]],
  ", combining by associates yields classes of length 4."
}], "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdDivisors[\(-1\), 8, \ Combine\  \[Rule] \ Associates, \ 
      DivisorsComplete\  \[Rule] \ True, \ NonTrivialOnly\  \[Rule] \ True]
      \)], "Input",
  CellLabel->"In[71]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{\(-4\), \(-4\)\ I, 4\ I, 4}, {\(-4\) - 4\ I, \(-4\) + 4\ I, 4 - 4\ I, 
        4 + 4\ I}, {\(-2\), \(-2\)\ I, 2\ I, 2}, {\(-2\) - 2\ I, 
        \(-2\) + 2\ I, 2 - 2\ I, 2 + 2\ I}, {\(-1\) - I, \(-1\) + I, 1 - I, 
        1 + I}}\)], "Output",
  CellLabel->"Out[71]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell["Here are the same divisors combined by negations.", "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdDivisors[\(-1\), 8, \ Combine\  \[Rule] \ Negations, \ 
      DivisorsComplete\  \[Rule] \ True, \ NonTrivialOnly\  \[Rule] \ True]
      \)], "Input",
  CellLabel->"In[72]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{\(-4\), 4}, {\(-4\) - 4\ I, 4 + 4\ I}, {\(-4\) + 4\ I, 4 - 4\ I}, {
        \(-2\), 2}, {\(-2\) - 2\ I, 2 + 2\ I}, {\(-2\) + 2\ I, 2 - 2\ I}, {
        \(-1\) - I, 1 + I}, {\(-1\) + I, 1 - I}, {\(-2\)\ I, 2\ I}, {
        \(-4\)\ I, 4\ I}}\)], "Output",
  CellLabel->"Out[72]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ZdCombineAssociates",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["lst",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["lst",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["combining",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["associates",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["\[DoubleStruckCapitalZ]",
                        SingleLetterItalics->False], "[", \(\@d\), "]"}],
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["together",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["sublists",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  GeneratedCell->True,
  GridBoxOptions->{ColumnWidths->{0.42, 0.58}},
  CellTags->{"DivisibilityZ", "i:27"}],

Cell["Means of combining associates if given a list of elements.", "Caption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdCombineAssociates[\(-1\), 
      \ {3, 4, \ 3  I, \ \(-4\), \ 5, \ \(-5\) I, 6, \ 7  I, \(-5\)}]\)], 
  "Input",
  CellLabel->"In[73]:=",
  CellTags->"DivisibilityZ"],

Cell[BoxData[
    \({{3\ I, 3}, {\(-5\), \(-5\)\ I, 5}, {\(-4\), 4}, {7\ I}, {6}}\)], 
  "Output",
  CellLabel->"Out[73]=",
  CellTags->"DivisibilityZ"]
}, Open  ]],

Cell["5.3.3 Norm-related functions", "Subsubsection",
  CellTags->{"NormZ", "i:28"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ZdNorm",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[
                  RowBox[{"a", " ", 
                    StyleBox["+",
                      "MR"], " ", \(b\ \@d\)}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(return\ the\ norm\ of\ an\ element\ in\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  RowBox[{
                    StyleBox["\[DoubleStruckCapitalZ]",
                      SingleLetterItalics->False], "[", \(\@d\), "]"}],
                  "TraditionalForm"], 
                StyleBox[\(\(, \ defined\ to\ be\)\ \),
                  SingleLetterItalics->False], 
                FormBox[
                  RowBox[{" ", 
                    RowBox[{
                      StyleBox["|",
                        SingleLetterItalics->False], " ", 
                      RowBox[{\(a\^2\), " ", 
                        StyleBox["-",
                          SingleLetterItalics->False], " ", 
                        RowBox[{
                          StyleBox["d",
                            SingleLetterItalics->False,
                            FontSlant->"Italic"], " ", \(b\^2\)}]}], 
                      StyleBox["|",
                        SingleLetterItalics->False]}]}],
                  "TraditionalForm"], " "}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ZdPossibleNormQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["nrm",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{"f", 
                      StyleBox["or",
                        "Text"]}]], " ", "negative", " ", 
                  StyleBox["d",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["give",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["True",
                    "MR"], 
                  StyleBox[\(\ if\ the\ value\ \),
                    SingleLetterItalics->False], 
                  StyleBox["nrm",
                    FontSlant->"Italic"]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["can",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["occur",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["\[DoubleStruckCapitalZ]",
                          SingleLetterItalics->False], "[", \(\@d\), "]"}],
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[" ",
                  "Text"], 
                StyleBox[",",
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["and",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"], 
                  StyleBox[\(\ otherwise\),
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["ZdPossibleNorms",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["max",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["for",
                  "Text"], " ", "negative", " ", 
                StyleBox["d",
                  FontSlant->"Italic"]}], ",", " ", 
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["list",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["all",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["norms",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["less",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["than",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["equal",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["max",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["that",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["are",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["possible",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["in",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["\[DoubleStruckCapitalZ]",
                        SingleLetterItalics->False], "[", \(\@d\), "]"}],
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["ValuesHavingGivenNorm",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["nrm",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["for",
                    "Text"], " ", "negative", " ", 
                  StyleBox["d",
                    FontSlant->"Italic"]}], ",", " ", 
                RowBox[{
                  StyleBox["return",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["all",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["values",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["in",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["\[DoubleStruckCapitalZ]",
                          SingleLetterItalics->False], "[", \(\@d\), "]"}],
                      "TraditionalForm"],
                    "Text"]}]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["having",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["norm",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["nrm",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["ValuesHavingGivenNorm",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["d",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["nrm",
                  "TI"], 
                StyleBox[",",
                  "TI"], 
                StyleBox[" ",
                  "TI"], 
                StyleBox["max",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                "return", " ", "a", " ", "partial", " ", "list", " ", "of", 
                  " ", "values", " ", "in", " ", 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["\[DoubleStruckCapitalZ]",
                          SingleLetterItalics->False], "[", \(\@d\), "]"}],
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["having",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["norm",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                StyleBox["nrm",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  "Text"], 
                StyleBox[" ",
                  "Text"], 
                RowBox[{
                  StyleBox["for",
                    "Text"], " ", "positive", " ", 
                  StyleBox["d",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                RowBox[{"using", " ", "up", " ", "to", " ", 
                  StyleBox["max",
                    FontSlant->"Italic"], " ", "iterations", " ", "of", " ", 
                  "an", " ", "algorithm", " ", "in", " ", "this", " ", 
                  "pursuit", " ", 
                  \((defaulting\ to\ 50\ if\ omitted)\)}]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.33, 0.67}},
  CellTags->{"NormZ", "i:29"}],

Cell["Working with norms.", "Caption",
  CellTags->"NormZ"],

Cell[TextData[{
  "After choosing five random elements from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-3\)]\)]],
  ", we determine the norm of each."
}], "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Map[{#, ZdNorm[#]}&, \ RandomElements[\(-3\), \ 25, 5]], \ 
      TableHeadings\  \[Rule] \ {None, \ {"\<x\>", "\<N(x)\n\>"}}]\)], "Input",\

  CellLabel->"In[74]:=",
  CellTags->"NormZ"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"x\"\>", \("N(x)\n"\)},
          {\(5 + 13\ I\ \@3\), "532"},
          {\(\(-12\) + 3\ I\ \@3\), "171"},
          {\(\(-8\) + I\ \@3\), "67"},
          {\(\(-18\) - 17\ I\ \@3\), "1191"},
          {\(\(-10\) + 17\ I\ \@3\), "967"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"x", "N(x)\n"}}]&)]], "Output",
  CellLabel->"Out[74]//TableForm=",
  CellTags->"NormZ"]
}, Open  ]],

Cell["\<\
If we have a norm value in mind, we can check to see if this is a \
viable value in the specified ring.\
\>", "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{#, ZdPossibleNormQ[\(-5\), \ #]}&, \ Range[0, \ 10]]\)], "Input",
  CellLabel->"In[75]:=",
  CellTags->"NormZ"],

Cell[BoxData[
    \({{0, True}, {1, True}, {2, False}, {3, False}, {4, True}, {5, True}, {
        6, True}, {7, False}, {8, False}, {9, True}, {10, False}}\)], "Output",\

  CellLabel->"Out[75]=",
  CellTags->"NormZ"]
}, Open  ]],

Cell["\<\
The previous result can also be achieved in the following manner.\
\
\>", "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdPossibleNorms[\(-5\), \ 10]\)], "Input",
  CellLabel->"In[76]:=",
  CellTags->"NormZ"],

Cell[BoxData[
    \({0, 1, 4, 5, 6, 9}\)], "Output",
  CellLabel->"Out[76]=",
  CellTags->"NormZ"]
}, Open  ]],

Cell[TextData[{
  "For the value of a norm ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " to be possible in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@d]\)]],
  ", there must be integer coordinates ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, \ b)\)\)]],
  " on the ellipse ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2\  - \ d\ b\^2\  = \ n\)]],
  ", when ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " is negative, and on one of two hyperbolas for positive ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  ". In the following figure, points of the same color have the same norm and \
are on a common ellipse concentric with the ellipse shown (corresponding to \
norm 56)."
}], "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ZdPossibleNorms[\(-5\), 56, \ Mode\  \[Rule] \ Visual]\)], "Input",
  CellLabel->"In[77]:=",
  CellTags->"NormZ"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .44721 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0636336 0.223607 0.0636336 [
[.1182 -0.0125 -6 -9 ]
[.1182 -0.0125 6 0 ]
[.24547 -0.0125 -6 -9 ]
[.24547 -0.0125 6 0 ]
[.37273 -0.0125 -6 -9 ]
[.37273 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.62727 -0.0125 -3 -9 ]
[.62727 -0.0125 3 0 ]
[.75453 -0.0125 -3 -9 ]
[.75453 -0.0125 3 0 ]
[.8818 -0.0125 -3 -9 ]
[.8818 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .03271 -12 -4.5 ]
[-0.0125 .03271 0 4.5 ]
[-0.0125 .09634 -12 -4.5 ]
[-0.0125 .09634 0 4.5 ]
[-0.0125 .15997 -12 -4.5 ]
[-0.0125 .15997 0 4.5 ]
[-0.0125 .22361 -6 -4.5 ]
[-0.0125 .22361 0 4.5 ]
[-0.0125 .28724 -6 -4.5 ]
[-0.0125 .28724 0 4.5 ]
[-0.0125 .35087 -6 -4.5 ]
[-0.0125 .35087 0 4.5 ]
[-0.0125 .41451 -6 -4.5 ]
[-0.0125 .41451 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .44721 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .44721 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1182 0 m
.1182 .00625 L
s
[(-6)] .1182 -0.0125 0 1 Mshowa
.24547 0 m
.24547 .00625 L
s
[(-4)] .24547 -0.0125 0 1 Mshowa
.37273 0 m
.37273 .00625 L
s
[(-2)] .37273 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.62727 0 m
.62727 .00625 L
s
[(2)] .62727 -0.0125 0 1 Mshowa
.75453 0 m
.75453 .00625 L
s
[(4)] .75453 -0.0125 0 1 Mshowa
.8818 0 m
.8818 .00625 L
s
[(6)] .8818 -0.0125 0 1 Mshowa
.125 Mabswid
.15002 0 m
.15002 .00375 L
s
.18183 0 m
.18183 .00375 L
s
.21365 0 m
.21365 .00375 L
s
.27728 0 m
.27728 .00375 L
s
.3091 0 m
.3091 .00375 L
s
.34092 0 m
.34092 .00375 L
s
.40455 0 m
.40455 .00375 L
s
.43637 0 m
.43637 .00375 L
s
.46818 0 m
.46818 .00375 L
s
.53182 0 m
.53182 .00375 L
s
.56363 0 m
.56363 .00375 L
s
.59545 0 m
.59545 .00375 L
s
.65908 0 m
.65908 .00375 L
s
.6909 0 m
.6909 .00375 L
s
.72272 0 m
.72272 .00375 L
s
.78635 0 m
.78635 .00375 L
s
.81817 0 m
.81817 .00375 L
s
.84998 0 m
.84998 .00375 L
s
.08638 0 m
.08638 .00375 L
s
.05456 0 m
.05456 .00375 L
s
.02275 0 m
.02275 .00375 L
s
.91362 0 m
.91362 .00375 L
s
.94544 0 m
.94544 .00375 L
s
.97725 0 m
.97725 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .03271 m
.00625 .03271 L
s
[(-3)] -0.0125 .03271 1 0 Mshowa
0 .09634 m
.00625 .09634 L
s
[(-2)] -0.0125 .09634 1 0 Mshowa
0 .15997 m
.00625 .15997 L
s
[(-1)] -0.0125 .15997 1 0 Mshowa
0 .22361 m
.00625 .22361 L
s
[(0)] -0.0125 .22361 1 0 Mshowa
0 .28724 m
.00625 .28724 L
s
[(1)] -0.0125 .28724 1 0 Mshowa
0 .35087 m
.00625 .35087 L
s
[(2)] -0.0125 .35087 1 0 Mshowa
0 .41451 m
.00625 .41451 L
s
[(3)] -0.0125 .41451 1 0 Mshowa
.125 Mabswid
0 .04543 m
.00375 .04543 L
s
0 .05816 m
.00375 .05816 L
s
0 .07089 m
.00375 .07089 L
s
0 .08361 m
.00375 .08361 L
s
0 .10907 m
.00375 .10907 L
s
0 .12179 m
.00375 .12179 L
s
0 .13452 m
.00375 .13452 L
s
0 .14725 m
.00375 .14725 L
s
0 .1727 m
.00375 .1727 L
s
0 .18543 m
.00375 .18543 L
s
0 .19815 m
.00375 .19815 L
s
0 .21088 m
.00375 .21088 L
s
0 .23633 m
.00375 .23633 L
s
0 .24906 m
.00375 .24906 L
s
0 .26179 m
.00375 .26179 L
s
0 .27451 m
.00375 .27451 L
s
0 .29997 m
.00375 .29997 L
s
0 .31269 m
.00375 .31269 L
s
0 .32542 m
.00375 .32542 L
s
0 .33815 m
.00375 .33815 L
s
0 .3636 m
.00375 .3636 L
s
0 .37633 m
.00375 .37633 L
s
0 .38905 m
.00375 .38905 L
s
0 .40178 m
.00375 .40178 L
s
0 .01998 m
.00375 .01998 L
s
0 .00725 m
.00375 .00725 L
s
0 .42723 m
.00375 .42723 L
s
0 .43996 m
.00375 .43996 L
s
.25 Mabswid
0 0 m
0 .44721 L
s
.1182 .44096 m
.1182 .44721 L
s
.24547 .44096 m
.24547 .44721 L
s
.37273 .44096 m
.37273 .44721 L
s
.5 .44096 m
.5 .44721 L
s
.62727 .44096 m
.62727 .44721 L
s
.75453 .44096 m
.75453 .44721 L
s
.8818 .44096 m
.8818 .44721 L
s
.125 Mabswid
.15002 .44346 m
.15002 .44721 L
s
.18183 .44346 m
.18183 .44721 L
s
.21365 .44346 m
.21365 .44721 L
s
.27728 .44346 m
.27728 .44721 L
s
.3091 .44346 m
.3091 .44721 L
s
.34092 .44346 m
.34092 .44721 L
s
.40455 .44346 m
.40455 .44721 L
s
.43637 .44346 m
.43637 .44721 L
s
.46818 .44346 m
.46818 .44721 L
s
.53182 .44346 m
.53182 .44721 L
s
.56363 .44346 m
.56363 .44721 L
s
.59545 .44346 m
.59545 .44721 L
s
.65908 .44346 m
.65908 .44721 L
s
.6909 .44346 m
.6909 .44721 L
s
.72272 .44346 m
.72272 .44721 L
s
.78635 .44346 m
.78635 .44721 L
s
.81817 .44346 m
.81817 .44721 L
s
.84998 .44346 m
.84998 .44721 L
s
.08638 .44346 m
.08638 .44721 L
s
.05456 .44346 m
.05456 .44721 L
s
.02275 .44346 m
.02275 .44721 L
s
.91362 .44346 m
.91362 .44721 L
s
.94544 .44346 m
.94544 .44721 L
s
.97725 .44346 m
.97725 .44721 L
s
.25 Mabswid
0 .44721 m
1 .44721 L
s
.99375 .03271 m
1 .03271 L
s
.99375 .09634 m
1 .09634 L
s
.99375 .15997 m
1 .15997 L
s
.99375 .22361 m
1 .22361 L
s
.99375 .28724 m
1 .28724 L
s
.99375 .35087 m
1 .35087 L
s
.99375 .41451 m
1 .41451 L
s
.125 Mabswid
.99625 .04543 m
1 .04543 L
s
.99625 .05816 m
1 .05816 L
s
.99625 .07089 m
1 .07089 L
s
.99625 .08361 m
1 .08361 L
s
.99625 .10907 m
1 .10907 L
s
.99625 .12179 m
1 .12179 L
s
.99625 .13452 m
1 .13452 L
s
.99625 .14725 m
1 .14725 L
s
.99625 .1727 m
1 .1727 L
s
.99625 .18543 m
1 .18543 L
s
.99625 .19815 m
1 .19815 L
s
.99625 .21088 m
1 .21088 L
s
.99625 .23633 m
1 .23633 L
s
.99625 .24906 m
1 .24906 L
s
.99625 .26179 m
1 .26179 L
s
.99625 .27451 m
1 .27451 L
s
.99625 .29997 m
1 .29997 L
s
.99625 .31269 m
1 .31269 L
s
.99625 .32542 m
1 .32542 L
s
.99625 .33815 m
1 .33815 L
s
.99625 .3636 m
1 .3636 L
s
.99625 .37633 m
1 .37633 L
s
.99625 .38905 m
1 .38905 L
s
.99625 .40178 m
1 .40178 L
s
.99625 .01998 m
1 .01998 L
s
.99625 .00725 m
1 .00725 L
s
.99625 .42723 m
1 .42723 L
s
.99625 .43996 m
1 .43996 L
s
.25 Mabswid
1 0 m
1 .44721 L
s
0 .22361 m
1 .22361 L
s
.5 0 m
.5 .44721 L
s
0 0 m
1 0 L
1 .44721 L
0 .44721 L
closepath
clip
newpath
1 0 .286 r
.015 w
.05456 .15997 Mdot
1 0 .571 r
.05456 .22361 Mdot
1 0 .286 r
.05456 .28724 Mdot
1 0 0 r
.1182 .09634 Mdot
.571 0 1 r
.1182 .15997 Mdot
.286 0 1 r
.1182 .22361 Mdot
.571 0 1 r
.1182 .28724 Mdot
1 0 0 r
.1182 .35087 Mdot
.857 0 1 r
.18183 .09634 Mdot
0 0 1 r
.18183 .15997 Mdot
0 .571 1 r
.18183 .22361 Mdot
0 0 1 r
.18183 .28724 Mdot
.857 0 1 r
.18183 .35087 Mdot
.286 0 1 r
.24547 .09634 Mdot
0 1 .857 r
.24547 .15997 Mdot
0 1 .286 r
.24547 .22361 Mdot
0 1 .857 r
.24547 .28724 Mdot
.286 0 1 r
.24547 .35087 Mdot
1 0 .286 r
.3091 .03271 Mdot
0 .286 1 r
.3091 .09634 Mdot
0 1 0 r
.3091 .15997 Mdot
.286 1 0 r
.3091 .22361 Mdot
0 1 0 r
.3091 .28724 Mdot
0 .286 1 r
.3091 .35087 Mdot
1 0 .286 r
.3091 .41451 Mdot
1 0 .571 r
.37273 .03271 Mdot
0 .857 1 r
.37273 .09634 Mdot
.286 1 0 r
.37273 .15997 Mdot
1 .857 0 r
.37273 .22361 Mdot
.286 1 0 r
.37273 .28724 Mdot
0 .857 1 r
.37273 .35087 Mdot
1 0 .571 r
.37273 .41451 Mdot
1 0 .857 r
.43637 .03271 Mdot
0 1 .857 r
.43637 .09634 Mdot
.571 1 0 r
.43637 .15997 Mdot
1 .571 0 r
.43637 .22361 Mdot
.571 1 0 r
.43637 .28724 Mdot
0 1 .857 r
.43637 .35087 Mdot
1 0 .857 r
.43637 .41451 Mdot
.857 0 1 r
.5 .03271 Mdot
0 1 .571 r
.5 .09634 Mdot
.857 1 0 r
.5 .15997 Mdot
1 .286 0 r
.5 .22361 Mdot
.857 1 0 r
.5 .28724 Mdot
0 1 .571 r
.5 .35087 Mdot
.857 0 1 r
.5 .41451 Mdot
1 0 .857 r
.56363 .03271 Mdot
0 1 .857 r
.56363 .09634 Mdot
.571 1 0 r
.56363 .15997 Mdot
1 .571 0 r
.56363 .22361 Mdot
.571 1 0 r
.56363 .28724 Mdot
0 1 .857 r
.56363 .35087 Mdot
1 0 .857 r
.56363 .41451 Mdot
1 0 .571 r
.62727 .03271 Mdot
0 .857 1 r
.62727 .09634 Mdot
.286 1 0 r
.62727 .15997 Mdot
1 .857 0 r
.62727 .22361 Mdot
.286 1 0 r
.62727 .28724 Mdot
0 .857 1 r
.62727 .35087 Mdot
1 0 .571 r
.62727 .41451 Mdot
1 0 .286 r
.6909 .03271 Mdot
0 .286 1 r
.6909 .09634 Mdot
0 1 0 r
.6909 .15997 Mdot
.286 1 0 r
.6909 .22361 Mdot
0 1 0 r
.6909 .28724 Mdot
0 .286 1 r
.6909 .35087 Mdot
1 0 .286 r
.6909 .41451 Mdot
.286 0 1 r
.75453 .09634 Mdot
0 1 .857 r
.75453 .15997 Mdot
0 1 .286 r
.75453 .22361 Mdot
0 1 .857 r
.75453 .28724 Mdot
.286 0 1 r
.75453 .35087 Mdot
.857 0 1 r
.81817 .09634 Mdot
0 0 1 r
.81817 .15997 Mdot
0 .571 1 r
.81817 .22361 Mdot
0 0 1 r
.81817 .28724 Mdot
.857 0 1 r
.81817 .35087 Mdot
1 0 0 r
.8818 .09634 Mdot
.571 0 1 r
.8818 .15997 Mdot
.286 0 1 r
.8818 .22361 Mdot
.571 0 1 r
.8818 .28724 Mdot
1 0 0 r
.8818 .35087 Mdot
1 0 .286 r
.94544 .15997 Mdot
1 0 .571 r
.94544 .22361 Mdot
1 0 .286 r
.94544 .28724 Mdot
0 g
.5 Mabswid
.02381 .22356 m
.02788 .19581 L
.04004 .16849 L
.06006 .14211 L
.08761 .11713 L
.12221 .09397 L
.16328 .07302 L
.21011 .05466 L
.2619 .03918 L
.31777 .02686 L
.37675 .0179 L
.43784 .01247 L
.5 .01065 L
.56216 .01247 L
.62325 .0179 L
.68223 .02686 L
.7381 .03918 L
.78989 .05466 L
.83672 .07302 L
.87779 .09397 L
.91239 .11713 L
.93994 .14211 L
.95996 .16849 L
.97212 .19581 L
.97619 .22356 L
s
.02381 .22365 m
.02788 .2514 L
.04004 .27872 L
.06006 .3051 L
.08761 .33009 L
.12221 .35325 L
.16328 .37419 L
.21011 .39256 L
.2619 .40803 L
.31777 .42036 L
.37675 .42931 L
.43784 .43474 L
.5 .43657 L
.56216 .43474 L
.62325 .42931 L
.68223 .42036 L
.7381 .40803 L
.78989 .39256 L
.83672 .37419 L
.87779 .35325 L
.91239 .33009 L
.93994 .3051 L
.95996 .27872 L
.97212 .2514 L
.97619 .22365 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[77]:=",
  ImageSize->{288, 128.75},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000P0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0003H00_lO00?o7@04oa/0
0_lM00Co7P03oah00_lV0000=@001?l00?lO0003o`0001d000?o00006P001?l00?lM0003o`0001l0
00?o000070001?l00?lU0000;`05o`050?l00?l05`05o`030?oo00;o5`05o`<000?o00006@001?l0
0?lN0003o`0001`01?lM0004o`00obD0000e00?o7P000ol0o`0Q0003o`0001P000Co003o7`000ol0
000K0003o`3o01h00olV0000=@000ol0000N0003o`3o01h000Co003o6P001?l00?lL0004o`00oad0
00?o0?l07P000ol0000V0000=P03oah00_lO00;o7002oah00_lO00;o7`03obD0003o0240003o0240
003o0240003o0240000E0?oo1Ol700005@000ol000030003o`0000D000?o00001P000ol000050003
o`0000D000?o00001@000ol000060003o`0000D000?o00001@000ol000050003o`0000D000?o0000
1P000ol000050003o`0000D000?o00001@000ol000060003o`0000D000?o00001@000ol000050003
o`0000D000?o00001P000ol000050003o`0000D000?o00001@000ol000060003o`0000D000?o0000
1@000ol000050003o`0000D000?o00001P000ol000050003o`0000<000?o00001@0001D00_lM0003
o`0001h000?o00007P000ol0000N0003o`0001d000?o00007P000ol0000N0003o`0001/00_l70000
5@000ol0001Z02[oK0000ol0000500005@000ol0001S00Oo5@000ol0000B00OoI@000ol000050000
5@02oe`02?lL0003o`0001T02?mL00;o1`0000d00ol50003o`0005<02?lT0003o`0002402?mE0003
o`0000D0000@0003o`00008000?o0000C@06ob`000?o0000:@06odl000?o00001@0000L01Ol40003
o`0000800om800Go00<_7`003003?`h000=??dl03@000dm>C`0>0003?dlo00d00cl=00037blO00Go
B003o`L0000>00;o1@000ol0001300Go1003;`d000<o;cl03P000cm??`0=0003CTm>00h000=??dl0
3@000cl_?`0=00<_1@05odD000?o00001@00010000?o00000P000ol0000o00Co2@000al_7`0=00<o
3P000dloC`0=0003Cdi?00h000<oCcl03@03?`d000<O;al02P04od4000?o00001@0000d00ol50003
o`0003`00om00003o`0003d00oln0003o`0000D0000E00;o>P03od<000?o0000@003ocX00_l70000
5@000ol0000f00?oAP000ol0001300?o>0000ol0000500005@000ol0000c00?oB@000ol0001600?o
=@000ol0000500005@02oc400om<0003o`0004T00ola00;o1`0001D000?o0000;P02odl000?o0000
C003obl000?o00001@0001D000?o0000;002oe4000?o0000C`02obd000?o00001@0001D00_lZ00?o
D`000ol0001A00?o:@02o`L0000E0003o`0002L00_mF0003o`0005@00_lX0003o`0000D0000E0003
o`0002D00_mH0003o`0005H00_lV0003o`0000D0000E0003o`0002800omJ0003o`0005P00_lT0003
o`0000D0000E00;o8@02oed000?o0000FP02ob400_l700003@04o`@000?o00007P02oel000?o0000
G002ob0000?o00001@0000h000?o000010000ol0000J008O0_l=0003Cdi?00d000=1C4403P000db0
C00=0003`07000h000<120403@0320h000<80@P03@000l01`00=0003C81<00h000=1C4403@000dm>
C`0>00;o00<O00006`000ol0000500001`05o`<000?o00000`03oaX000<Ooal03P000di?CP0=00=1
3P03P0d000<1`0403P000`P1200=0003h0SP00h000<120403@000`700@0=00>03P03@@d000=>Cdh0
3P027`03o`0001T00ol7000040000ol000020003o`0001T00_l27`h000=?CTl03@000d5<@@0>0003
C81<00d000?00L003P000`480@0=00<83P000`P1200=0003`07000d000=<P4`03P000d5<@@0=0003
Cdi?00h00al2oa/000?o00001@0000d000Co003o10000ol0000H0003o`0006@000?o0000H`000ol0
000H0003o`0000D0000>00;o1@02oaL00_mW0003o`0006@00_lG00;o1`0001D000?o00005@000ol0
001W0003o`0006H000?o00005@000ol0000500005@000ol0000D0003o`0006P000?o0000I`000ol0
000D0003o`0000D0000E00;o50000ol0001Y0003o`0006P000?o00004P02o`L0000E0003o`000180
00?o0000JP000ol0001Y0003o`00018000?o00001@0001D000?o00004@000ol0001[0003o`0006X0
00?o00004@000ol0000500005@000ol0000@0003o`0006`000?o0000J`000ol0000@0003o`0000D0
000E00;o40000ol0001]0003o`0006`000?o00003P02o`L0000E0003o`0000h000?o0000KP000ol0
001]0003o`0000h000?o00001@0001D000?o00003@000ol0001_0003o`0006h000?o00003@000ol0
000500005@02o`h000?o0000K`000ol0001^0003o`0000`00_l700003@03o`D000?o000030000ol0
001`0003o`0006l000?o000030000ol0000500003P000ol000040003o`0000/000?o0000L@000ol0
001`0003o`0000/000?o00001@0000L01Ol20003o`0000@00ol:0003obl_00d000=>@Dh03P03C0d0
00<80@P03P03d0d00m4>0003dMkA00d000?Ngmh03P000mkAgP0=00?A3@03d0h000<80@P03@03C0h0
00=>@Dh03@03;`03o`0000P00ol700003P000ol000040003o`0000X000?o;al03@03CPh00d`=0003
0@P100h00m0=0003d=7@00h00mh=0003gmkO00h00mh=0003d=7@00d00m0>00030@P100d00d`>00=>
3@0011l_7ol<0003o`0000D0000>0003o`0000@000?o00002@001?l_;bl=0003CT5>00h00d`=0003
204800h00m0=00?A3P000m7Nd@0=0003g]oN00h000?NdMh03@03d@d00m0>0003204800d00d`>0003
CT5>00d00bl00`3o000:0003o`0000D0000=00;o1P000ol000080003o`0007@000?o0000L`000ol0
00080003o`0000D0000E00;o2@000ol0001d0003o`0007<000?o00001`02o`L0000E0003o`0000L0
00?o0000M@000ol0001d0003o`0000L000?o00001@0001D000?o00001`000ol0001e0003o`0007@0
00?o00001`000ol0000500005@02o`L000?o0000MP000ol0001e0003o`0000D00_l700005@000ol0
00060003o`0007H000?o0000MP000ol000050003o`0000D0000E0003o`0000H000?o0000MP000ol0
001f0003o`0000D000?o00001@0001D00_l60003o`0007L000?o0000M`000ol0000300;o1`0001D0
00?o00001@000ol0001g0003o`0007L000?o000010000ol0000500005@000ol000050003o`0007L0
00?o0000M`000ol000040003o`0000D0000E00;o1P000ol0001g0003o`0007L000?o00000`02o`L0
000E0003o`0000@000?o0000N0000ol0001h0003o`0000<000?o00001@0000h00_l50003o`0000@0
00?o0000N0000ol0001h0003o`0000<000?o00001@0000d000Co003o10000ol000040003o`0000<0
00<o;cl03@03@@h000>0`8003@03h0h00m4=0003gioO00h000=OWel03@03G`h000>OGil03@000mnO
g`0=00?A3P03h0d000>0`8003P03@@d000<o;cl01`000ol000030003o`0000D0000=0004o`00o`@0
3Ol3?`go00=<@D`03_l3`0go00?Pd>003_l00m3Ad00=o`03WmnO00ko0il=o`03GamO00ko0il=o`03
WmnO00go00?@dM003_l00n3@h00=o`?03_l00da1C00=o`<o3_l700003@001?l00?l40003o`0000@0
00?o00000`000cl_?`0=00=13P000h30P00=00?P3P03d@d000?OWml03P000enOG`0=00=O3P000imO
W`0=0003gioO00d00m4>00?P3@000h30P00>00=13@000cl_?`070003o`0000<000?o00001@0000d0
00Co003o10000ol000040003o`0007P000?o0000N0000ol000030003o`0000D0000>00;o1@02o`D0
00?o0000N0000ol0001h0003o`0000800_l700005@000ol000050003o`0007L000?o0000M`000ol0
00040003o`0000D0000E0003o`0000D000?o0000M`000ol0001g0003o`0000@000?o00001@0001D0
0_l60003o`0007L000?o0000M`000ol0000300;o1`0001D000?o00001@000ol0001g0003o`0007L0
00?o000010000ol0000500005@000ol000050003o`0007L000?o0000M`000ol000040003o`0000D0
000E0003o`0000H000?o0000MP000ol0001f0003o`0000D000?o00001@0001D00_l70003o`0007H0
00?o0000MP000ol0000400;o1`0001D000?o00001`000ol0001e0003o`0007D000?o00001P000ol0
000500005@000ol000070003o`0007D000?o0000M0000ol000070003o`0000D0000E00;o20000ol0
001e0003o`0007@000?o00001P02o`L0000=00?o1@000ol000080003o`0007@000?o0000L`000ol0
00080003o`0000D0000>0003o`0000@000?o000020000ol0001d0003o`0007<000?o000020000ol0
000500003P000ol0000400?o2@001?lO;al=00=>3P03C0d000<120403P03d0d000?@dM003P03gPd0
00?Og]l03P03gPd000?@dM003@03d0h000<120403@03C0h00dh=00057blO0?l02@03o`L0000>0003
o`0000@000?o00002P000ol_;`0=0003CT5>00h00d`=0003204800h00m0=00?A3P000m7Nd@0=0003
g]oN00h000?NdMh03@03d@d00m0>0003204800d00d`>0003CT5>00d00bl00ol0000:0003o`0000D0
000>0003o`0000@000?o00002P000aoo7`0=00=>3P03C0d000<120403P03d0d000?@dM003P03gPd0
00?Og]l03P03gPd000?@dM003@03d0h000<120403@03C0h00dh=00037boo00d000?o00001@0000d0
0_l600;o30000ol0001a0003o`00070000?o00002P02o`L0000E0003o`0000`000?o0000L0000ol0
001_0003o`0000`000?o00001@0001D000?o00003@02og0000?o0000K@02o`l000?o00001@0001D0
00?o00003`000ol0001]0003o`0006`000?o00003`000ol0000500005@02oa4000?o0000K0000ol0
001[0003o`0000l00_l700005@000ol0000A0003o`0006/000?o0000JP000ol0000A0003o`0000D0
000E0003o`00018000?o0000JP000ol0001Y0003o`00018000?o00001@0001D00_lD0003o`0006T0
00?o0000J0000ol0000B00;o1`0001D000?o00005002ofT000?o0000IP02oaH000?o00001@0001D0
00?o00005P000ol0001V0003o`0006D000?o00005P000ol0000500005@02oaP00_mV0003o`0006<0
0_lH00;o1`0001D000?o00006@000ol0001S0003o`00068000?o00006@000ol0000500003@04o`@0
00?o00006P02of<000?o0000H002oa`000?o00001@0000h000?o000010000ol0000J008O00?o0000
30000dm>C`0=0003@Da100h000=<P4`03@000l01`00>00030@P100d00`P>0003204800d000?00L00
3@000db0C00>0003@Da100d000=?CTl03P000aoo7`0M0003o`0000D0000?0003o`0000<00olJ00<O
0_l<0003CTm>00d00d4>00>03@000`700@0>0003204800d000?P2>003P000`480@0=00030L0100d0
0h0>00=13@000di?CP0=00;o0QlK00?o1`00010000?o00000P000ol0000J00<O0P02o`X000=?CTl0
3@000d5<@@0>0003C81<00d000?00L003P000`480@0=00<83P000`P1200=0003`07000d000=<P4`0
3P000d5<@@0=0003Cdi?00/00_l0100O7alM0003o`0000D0000=0004o`00o`@000?o00008@02oe`0
00?o0000FP000ol0000Q0003o`0000D0000>00;o1@02ob@000?o0000F@000ol0001H00;o8`02o`L0
000E0003o`0002@00_mI0003o`0005H00_lV0003o`0000D0000E0003o`0002H00_mG0003o`0005D0
00?o00009P000ol0000500005@02obT00omD0003o`0005800olX00;o1`0001D000?o0000:`03oe40
00?o0000C`03ob`000?o00001@0001D000?o0000;P03odh000?o0000C003obl000?o00001@0001D0
0_lb00?oB`000ol0001900?o<@02o`L0000E0003o`0003@00om80003o`0004D01?le0003o`0000D0
000E0003o`0003L00om50003o`0004800oli0003o`0000D0000E0003o`0003X00om20003o`0003l0
0oll0003o`0000D0000E00;o?P03ocl000?o0000?003och00_l700003@03o`D000?o0000@004oc/0
00?o0000>004od8000?o00001@00010000?o00000P000ol0001400?o1@000al_7`0=00<o3P000dlo
C`0=0003Cdi?00h000<oCcl03@03?`d000<O;al01P03odH000?o00001@00010000?o00000P03odL0
1?l0100_;bl=0003?blo00h000<oCcl03@000di?CP0>0003Ccm?00d000<o;cl03@03;`801?m700?o
1`0000h00_l50003o`0004/00ol00al0000;00<o3P000dloC`0=0003Cdi?00h000<oCcl03@03?`d0
00<O;ol00_m=0003o`0000D0000@0003o`00008000?o0000CP06ob/000?o0000:006oe0000?o0000
1@0000d00ol500;oE@08ob<000?o00008008oeD00_l700005@000ol0001L00co5`000ol0000E00_o
GP000ol0000500005@000ol0001X013o1`000ol00005013oJ@000ol0000500005@000ol0001h00oo
N@000ol0000500005@02oad000?o00007P000ol0000N0003o`0001h000?o00007@000ol0000N0003
o`0001h000?o00006`02o`L0000E0?oo1Ol70000\
\>"],
  ImageRangeCache->{{{0, 287}, {127.75, 0}} -> {-9.18956, -4.25798, 
  0.0608371, 0.0608371}},
  CellTags->"NormZ"],

Cell[BoxData[
    \({0, 1, 4, 5, 6, 9, 14, 16, 20, 21, 24, 25, 29, 30, 36, 41, 45, 46, 49, 
      54, 56}\)], "Output",
  CellLabel->"Out[77]=",
  CellTags->"NormZ"]
}, Open  ]],

Cell[TextData[{
  "If you look carefully, you should be able to see four points on the \
ellipse shown in the figure. They have coordinates ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((\(\[PlusMinus]\ 6\), \ \(\[PlusMinus]\ 2\))\)\)]],
  ", which correspond to the following values in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@\(-5\)]\)]],
  "."
}], "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ValuesHavingGivenNorm[\(-5\), \ 56]\)], "Input",
  CellLabel->"In[78]:=",
  CellTags->"NormZ"],

Cell[BoxData[
    \({\(-6\) - 2\ I\ \@5, \(-6\) + 2\ I\ \@5, 6 - 2\ I\ \@5, 6 + 2\ I\ \@5}
      \)], "Output",
  CellLabel->"Out[78]=",
  CellTags->"NormZ"]
}, Open  ]],

Cell[TextData[{
  "Here are some of the units (having norm 1) in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ][\@2]\)]],
  "."
}], "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ValuesHavingGivenNorm[2, 1, \ 35]\)], "Input",
  CellLabel->"In[79]:=",
  CellTags->"NormZ"],

Cell[BoxData[
    \({\(-41\) - 29\ \@2, \(-41\) + 29\ \@2, \(-17\) - 12\ \@2, 
      \(-17\) + 12\ \@2, \(-7\) - 5\ \@2, \(-7\) + 5\ \@2, \(-3\) - 2\ \@2, 
      \(-3\) + 2\ \@2, \(-1\) - \@2, \(-1\), \(-1\) + \@2, 1 - \@2, 1, 
      1 + \@2, 3 - 2\ \@2, 3 + 2\ \@2, 7 - 5\ \@2, 7 + 5\ \@2, 17 - 12\ \@2, 
      17 + 12\ \@2, 41 - 29\ \@2, 41 + 29\ \@2}\)], "Output",
  CellLabel->"Out[79]=",
  CellTags->"NormZ"]
}, Open  ]],

Cell["5.4 Miscellaneous functions", "Subsection",
  CellTags->"WorkLists"],

Cell["5.4.1 Working with lists", "Subsubsection",
  CellTags->{"WorkLists", "i:30"}],

Cell[TextData[{
  "Although ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many functions for working with lists, it is still wanting in a few \
areas. Sometimes we wish to take the union or complement of two sets but ",
  StyleBox["not",
    FontSlant->"Italic"],
  " have the elements returned already sorted. The Cartesian product of two \
sets is a natural construct in algebra, as is the notion of applying some \
operation to a Cartesian product. Finally, we frequently wish to consider \
relations between two sets, viewing two lists as mathematical sets."
}], "Text",
  CellTags->"WorkLists"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["UnionNoSort",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(list\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(list\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", "\[Ellipsis]", 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(equivalent\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["Union",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox[
                          FormBox[\(list\_1\),
                            "TraditionalForm"],
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox[
                          FormBox[\(list\_2\),
                            "TraditionalForm"],
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", "\[Ellipsis]", "]"}],
                      "StandardForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["except",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\n",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox["elements",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["are",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["not",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["sorted",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["ComplementNoSort",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(list\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(list\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", "\[Ellipsis]", 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(equivalent\ to\ \),
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["Complement",
                  "MR"], 
                StyleBox["[",
                  "Text"], 
                RowBox[{
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox[
                          FormBox[\(list\_1\),
                            "TraditionalForm"],
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox[
                          FormBox[\(list\_2\),
                            "TraditionalForm"],
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", "\[Ellipsis]", "]"}],
                      "StandardForm"],
                    "Text"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["except",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["the",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["\n",
                    "Text",
                    SingleLetterItalics->False], 
                  StyleBox["elements",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["are",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["not",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["sorted",
                    SingleLetterItalics->False]}]}]}]},
          {
            RowBox[{
              StyleBox["CartesianProduct",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(list\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(list\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", "\[Ellipsis]", 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["give",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Cartesian",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["product",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["lists",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(list\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "TI"], " ", 
              StyleBox[
                FormBox[\(list\_2\),
                  "TraditionalForm"],
                "TI"], ",", " ", 
              StyleBox["\[Ellipsis]",
                "MR"]}]},
          {
            RowBox[{
              StyleBox["CartesianProduct",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(list\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(list\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", "\[Ellipsis]", 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["Partition",
                      "MR"], 
                    StyleBox[" ",
                      "MR"], 
                    StyleBox["\[Rule]",
                      "MR"], " ", 
                    StyleBox["True",
                      "MR"]}],
                  "TraditionalForm"],
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            
            StyleBox[
              \(give\ the\ Cartesian\ product\ of\ the\ lists, \ partitioned\ 
                according\ to\ the\ length\ of\ the\ last\ list\),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["CloseSets",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[
                FormBox[\(list\_1\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox[
                FormBox[\(list\_2\),
                  "TraditionalForm"],
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["op",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(give\ the\ list\ of\ all\ distinct\ elements\ obtained\ by\ 
                  applying\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                "Text",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["operation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["op",
                  FontSlant->"Italic"], 
                StyleBox[\(\ on\ \),
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["CartesianProduct",
                    "MR"], 
                  StyleBox["[",
                    "Text"], 
                  RowBox[{
                    StyleBox[
                      FormBox[
                        RowBox[{
                          StyleBox[
                            FormBox[\(list\_1\),
                              "TraditionalForm"],
                            "TI"], 
                          StyleBox[",",
                            "TI"], " ", 
                          StyleBox[
                            FormBox[\(list\_2\),
                              "TraditionalForm"],
                            "TI"]}],
                        "StandardForm"],
                      "Text"], 
                    StyleBox[\(]\ \),
                      SingleLetterItalics->False]}]}]}]}]},
          {
            RowBox[{
              StyleBox["Randomize",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["list",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(randomly\ reorder\ the\ elements\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox["list",
                  FontSlant->"Italic"]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["SubsetQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(child, \ parent\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["child",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subset",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["parent",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ProperSubsetQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox[\(child, \ parent\),
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["if",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["child",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["proper",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["subset",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["parent",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["SameSetQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["A",
                "TI"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["B",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(give\ \),
                SingleLetterItalics->False], 
              StyleBox["True",
                "MR"], 
              StyleBox[\(\ if\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox["A",
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["mathematically",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["same",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["set",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(B, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["False",
                "MR"], 
              StyleBox[\(\ otherwise\),
                SingleLetterItalics->False]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"WorkLists", "i:31"}],

Cell["Functions to work with lists.", "Caption",
  CellTags->"WorkLists"],

Cell[TextData[{
  StyleBox["UnionNoSort", "MR"],
  " does the work of ",
  StyleBox["Union", "MR"],
  " by combining all the elements under one roof and removing duplicates, but \
it does not apply ",
  StyleBox["Sort", "MR"],
  " to the final list."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell["\<\
{UnionNoSort[{2,4,3,5,3}, {1,6,4,3,5}], \
UnionNoSort[{2,4,3,5,3,1,6,4,3,5}], UnionNoSort[anyHead[2,4,3,5,3], \
anyHead[1,6,4,3,5]]}\
\>", "Input",
  CellLabel->"In[80]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({{2, 4, 3, 5, 1, 6}, {2, 4, 3, 5, 1, 6}, anyHead[2, 4, 3, 5, 1, 6]}\)], 
  "Output",
  CellLabel->"Out[80]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell[TextData[{
  StyleBox["ComplementNoSort", "MR"],
  " works in a similar fashion."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell["\<\
{ComplementNoSort[{2,4,3,5,3,7}, {1,6,4,3,5}], \
ComplementNoSort[{2,4,3,5,3,7}, {1,6,4,3,5}, {3,7}], \
ComplementNoSort[anyHead[2,4,3,5,3], anyHead[1,6,4,3,5]]}\
\>", "Input",
  CellLabel->"In[81]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({{2, 7}, {2}, anyHead[2]}\)], "Output",
  CellLabel->"Out[81]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["CartesianProduct", "MR"],
  " function returns a list of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "-tuples obtained by taking the Cartesian product of the lists given as \
arguments."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CartesianProduct[{"\<a\>", "\<b\>", "\<c\>", "\<d\>"}, {1, 2, 3}]\)], 
  "Input",
  CellLabel->"In[82]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({{"a", 1}, {"a", 2}, {"a", 3}, {"b", 1}, {"b", 2}, {"b", 3}, {"c", 1}, {
        "c", 2}, {"c", 3}, {"d", 1}, {"d", 2}, {"d", 3}}\)], "Output",
  CellLabel->"Out[82]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell["\<\
To have a Cartesian product partitioned according to the length of \
the last list, add the corresponding option.\
\>", "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[
      CartesianProduct[{"\<a\>", "\<b\>", "\<c\>", "\<d\>"}, {1, 2, 3}, \ 
        Partition\  \[Rule] \ True], \ TableDepth\  \[Rule] \ 1]\)], "Input",
  CellLabel->"In[83]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({{"a", 1}, {"a", 2}, {"a", 3}}\)},
          {\({{"b", 1}, {"b", 2}, {"b", 3}}\)},
          {\({{"c", 1}, {"c", 2}, {"c", 3}}\)},
          {\({{"d", 1}, {"d", 2}, {"d", 3}}\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{{"a", 1}, {"a", 2}, {"a", 3}}, {{"b", 1}, {"b", 2}, {"b", 
        3}}, {{"c", 1}, {"c", 2}, {"c", 3}}, {{"d", 1}, {"d", 2}, {"d", 3}}}, 
        TableDepth -> 1]]], "Output",
  CellLabel->"Out[83]//TableForm=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell[TextData[{
  "We can use more than two lists for arguments in the ",
  StyleBox["CartesianProduct", "MR"],
  " function."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CartesianProduct[{0, 1}, {1, 2, 3}, \ {0, 1, 2}]\)], "Input",
  CellLabel->"In[84]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({{0, 1, 0}, {0, 1, 1}, {0, 1, 2}, {0, 2, 0}, {0, 2, 1}, {0, 2, 2}, {0, 
        3, 0}, {0, 3, 1}, {0, 3, 2}, {1, 1, 0}, {1, 1, 1}, {1, 1, 2}, {1, 2, 
        0}, {1, 2, 1}, {1, 2, 2}, {1, 3, 0}, {1, 3, 1}, {1, 3, 2}}\)], 
  "Output",
  CellLabel->"Out[84]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell[TextData[{
  "If we want to apply an operation to a Cartesian product, the ",
  StyleBox["CloseSets", "MR"],
  " function may be useful."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \({CartesianProduct[{2, \ 3, \ 5}, \ {0, 1}], 
        CloseSets[{2, \ 3, \ 5}, \ {0, 1}, \ Plus]} // ColumnForm\)], "Input",\

  CellLabel->"In[85]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\({{2, 0}, {2, 1}, {3, 0}, {3, 1}, {5, 0}, {5, 1}}\)},
          {\({2, 3, 4, 5, 6}\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {{{2, 0}, {2, 1}, {3, 0}, {3, 1}, {5, 0}, {5, 1}}, {2, 3, 
        4, 5, 6}}],
      Editable->False]], "Output",
  CellLabel->"Out[85]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell["\<\
This function can also be used to help form a Boggle \
dictionary.\
\>", "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \(words\  = \ 
      CloseSets[
        CloseSets[{"\<a\>", \ "\<c\>"}, \ {"\<a\>", "\<c\>", "\<p\>"}, 
          StringJoin], {"\<t\>", "\<e\>"}, \ StringJoin]\)], "Input",
  CellLabel->"In[86]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({"aat", "aae", "act", "ace", "apt", "ape", "cat", "cae", "cct", "cce", 
      "cpt", "cpe"}\)], "Output",
  CellLabel->"Out[86]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Randomize", "MR"],
  " does exactly what its name implies."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Randomize[words]\)], "Input",
  CellLabel->"In[87]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({"ace", "apt", "cce", "aat", "aae", "cat", "cpt", "cae", "cpe", "act", 
      "ape", "cct"}\)], "Output",
  CellLabel->"Out[87]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell[TextData[{
  "Note the differences between ",
  StyleBox["SubsetQ,", "MR"],
  " ",
  StyleBox["ProperSubsetQ", "MR"],
  ", and ",
  StyleBox["SameSetQ", "MR"],
  "."
}], "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{

Cell[BoxData[
    \({SubsetQ[{3, \ 4, \ 5}, \ {4, \ 3, \ 5}], \ 
      ProperSubsetQ[{3, \ 4, \ 5}, \ {4, \ 3, \ 5}], \ 
      SameSetQ[{3, \ 4, \ 5}, \ {4, \ 3, \ 5}]}\)], "Input",
  CellLabel->"In[88]:=",
  CellTags->"WorkLists"],

Cell[BoxData[
    \({True, False, True}\)], "Output",
  CellLabel->"Out[88]=",
  CellTags->"WorkLists"]
}, Open  ]],

Cell["5.4.2 Working with graphics", "Subsubsection",
  CellTags->{"WorkGraphics", "i:32"}],

Cell["\<\
To illustrate some elementary group concepts, sometimes visual aids \
are useful. The following have been constructed with this in mind.\
\>", 
  "Text",
  CellTags->"WorkGraphics"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["ShowCircle",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["graph",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["unit",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["circle",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["points",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["\n",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["uniformly",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["placed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["labeled",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["0",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["through",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["n",
                        SingleLetterItalics->False,
                        FontSlant->"Italic"], " ", 
                      StyleBox["-",
                        SingleLetterItalics->False], " ", 
                      StyleBox["1",
                        SingleLetterItalics->False]}],
                    "TraditionalForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["ShowCircle",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["labels",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["graph",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["unit",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["circle",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["points",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["uniformly",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["placed",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["labeled",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["according",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["labels",
                  FontSlant->"Italic"]}]}]},
          {
            RowBox[{
              StyleBox["DrawNgon",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["n",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox["give",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["graph",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["of",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["a",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["regular",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["n",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox["\[Hyphen]gon",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["with",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["the",
                      SingleLetterItalics->False]}], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["vertices",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], "\n", 
                RowBox[{
                  StyleBox["labeled",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["1",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["through",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox["n",
                      "TraditionalForm"],
                    "Text"], 
                  StyleBox[\(\ (\),
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{
                        StyleBox["n",
                          SingleLetterItalics->False,
                          FontSlant->"Italic"], " ", 
                        StyleBox[">",
                          SingleLetterItalics->False], " ", 
                        StyleBox["2",
                          SingleLetterItalics->False]}],
                      "TraditionalForm"],
                    "Text"]}]}], 
              StyleBox[")",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ShowFigure",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["perm",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["sym",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["give",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["graph",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["an",
                  SingleLetterItalics->False], " ", 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox["\[NoBreak]",
                  "Text"], 
                StyleBox["\[Hyphen]gon",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["possessing",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["symmetry",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], "\n", 
              RowBox[{
                RowBox[{
                  StyleBox["type",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["sym",
                    FontSlant->"Italic"]}], 
                StyleBox[",",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["with",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["permutation",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["perm",
                    FontSlant->"Italic"], 
                  StyleBox[\(\ applied\ to\ the\ vertices\),
                    SingleLetterItalics->False]}]}]}]},
          {
            StyleBox[
              FormBox[
                StyleBox[\(ShowFigure[]\),
                  "MR"],
                "TraditionalForm"],
              "TI"], 
            StyleBox[\(redraw\ the\ most\ recently\ drawn\ figure\ \),
              SingleLetterItalics->False]},
          {
            RowBox[{
              StyleBox["ShowPermutation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["n",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["perm",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["sym",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ graphic\ of\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["ShowFigure",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["n",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["perm",
                          "TI"], 
                        StyleBox[",",
                          "TI"], " ", 
                        StyleBox["sym",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["with",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["also",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["same",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox["\[Hyphen]gon",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(in\ "standard position"\ so\ that\ the\ images\ before\ and
                  \ after\ the\ permutation\ are\ shown\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ShowPermutation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["perm",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(once\ a\ figure\ has\ been\ drawn\ via\ \),
                  SingleLetterItalics->False], 
                StyleBox["ShowFigure",
                  "MR"], 
                StyleBox[\(\ or\ \),
                  SingleLetterItalics->False], 
                StyleBox["ShowPermutation",
                  "MR"]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["show",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["before",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["and",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["after",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["effects",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["permutation",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["perm",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["on",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["n",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox["\[Hyphen]gon",
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"WorkGraphics", "i:33"}],

Cell["Functions for drawing some graphics.", "Caption",
  CellTags->"WorkGraphics"],

Cell[TextData[{
  StyleBox["DrawNgon", "MR"],
  "[5] would accomplish almost the same thing as the figure shown."
}], "MathCaption",
  CellTags->"WorkGraphics"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ShowFigure[5, {1, 2, 3, 4, 5}, "\<D\>"]; \)\)], "Input",
  CellLabel->"In[89]:=",
  CellTags->"WorkGraphics"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .95106 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.400557 0.427716 0.400557 [
[ 0 0 0 0 ]
[ 1 .95106 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .95106 L
0 .95106 L
closepath
clip
newpath
.74 .99 .79 r
.88095 .55149 m
.73544 .10366 L
.26456 .10366 L
.11905 .55149 L
.5 .82827 L
F
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.88095 .55149 m
.73544 .10366 L
.26456 .10366 L
.11905 .55149 L
.5 .82827 L
.88095 .55149 L
s
0 g
[(1)] .97619 .58244 0 0 Mshowa
[(2)] .7943 .02264 0 0 Mshowa
[(3)] .2057 .02264 0 0 Mshowa
[(4)] .02381 .58244 0 0 Mshowa
[(5)] .5 .92841 0 0 Mshowa
1 0 0 r
.045 w
.88095 .55149 Mdot
0 1 0 r
.73544 .10366 Mdot
0 0 1 r
.26456 .10366 Mdot
1 1 0 r
.11905 .55149 Mdot
.628 .126 .941 r
.5 .82827 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[89]:=",
  ImageSize->{288, 273.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00014@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@0003T0
0onU00Co>`0003`000?o0000X`000ol0000k0000?0000ol0002T0003o`0003X0000j00;oZ0000ol0
000i0000?0000ol0002R0004o`00oc/0000i00?oYP02oc`0003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
001:00A<P`04d4/0001800Q<O`08d4T0001700Y<O@0:d4P0001700Y<O@0:d4P0001600a<N`0<d4L0
001600a<Nol<d4L0001600a<07/3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<03=170000AP0<C01k3`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00c@A`0004L02T`0OMH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F00[@
B00004L02T`0O@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l300[@B00004P024`0O`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<02=190000B@000om<C002C0233`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l01=000ol000180000B@00SOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1:0000B@00SOl?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`1:0000B000SooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo04T00018002?o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ol0B@0004P008ooeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`190000A`00TOl?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol0B00004L0097o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o04P0
0017002Ao`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`180000AP00TooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fo`170000AP00Tol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`170000AP00TooF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fo`170000A@00UOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo04H0
0015002Eo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0AP0004D009Go3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`160000A000UooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0A@0004@0
09Oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o04D00014002GomH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`150000A000Uol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0A@0004<0
09Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0A00004<009Wo3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0A00004<009Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0
A000048009_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`130000@P00VooF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo04<00012002Ko`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0ol0@`00044009go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o0480
0011002Mo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`120000@@00WOl3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0@P00040009oo0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ol0@@00040009ooeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l0@@00040009oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0@@0003l0
0:7o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`100000?`00XOl?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo0400000o002Qo`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0@00003h00:?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`?o03l0000n002SomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fo`0o0000?P00Xol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0
?`0003d00:Go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0?P0003d0
0:Go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0?P0003d00:Go0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0?P0003d00:Go3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0?P0003`00:OoeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0m0000?000Yol33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o03d0000l002WomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0?@0003/00:Wo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo03`0000k002Yo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`0l0000>`00ZOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0?00003X00:_oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l0>`0003X00:_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ol0>`0003X00:_oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l0>`0003T00:go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?o`0j0000>@00[Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?o03X0000i002]o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33ol0>P0003P00:ooeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo03T0000h002_o`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0i0000>000[ooF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0>@0003L00;7o3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0>00003L00;7o0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0>00003L00;7o3`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0>00003H0
0;?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
o`0g0000=P00/ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o03L0000f002comH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l0=`0003H00;?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0g0000=@00]Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0=P0003D00;Go3`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo03H0000e002eo`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0f0000
=000]ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`0e0000=000]ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fo`0e0000=000]ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0e0000<`00^Ol3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o03@0000c002io`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0
=00003<00;Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3o`0d0000<P00^ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0<`0003800;_oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo03<0000b002ko`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
o`0c0000<@00_Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`0b0000<@00_Ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0b0000<@00_Ol3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0b0000
<000_ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`?o0340000`002oomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0<@0003000;oo0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0a0000
<000_ooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo0340000_0031o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0`0000;`00`Ol3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0
<00002l00<7o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo0300000^0033omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02l0000^0033o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o02l0000^0033omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02l0000]0035o`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0
;P0002d00<Go0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0^0000;@00aOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02h0000/0037
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?Fo`0]0000;000aol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0;@0002`00<OoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo02d0000[0039o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02`0000[0039o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o02`0000[0039o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02`0000Z003;omH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l0:`0002X00<_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0[0000:P00booF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mKo02/0000Y003=o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0Z0000
:@00cOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0:P0002T00<go3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`oo02X0000Y003=o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0Z0000:000col33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3o`0Y0000:000cooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0Y0000:000col3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0Y00009`00dOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?o02P0000W003Ao`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0:00002L00=7o0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`0X00009P00dol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0
9`0002H00=?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02L0000V003Co`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3o`0W00009@00eOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
o`0V00009@00eOl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0V00009@00eOl3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0V00009000eol33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o02D0000T003GomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l09@000200
1=l0e_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<47b80000N00SO0=83eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH87b00000M00[O0=033`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
2QlO00007@0:g`3@eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`XO7`0001`03=l0cPl33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l331lN0000700<g`3>0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH<7ah0
000L00cO0<h?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0``O7P0001`03=l0cP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F31lN00007@0:g`3@o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`XO7`0001d0
2]l0d03oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l:7al0000N00SO0`02o`390`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l300;o0P087b00000P00CO1`00bOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0600@O8P0000D0
0olT0037o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0S00?o1`0000H000?o00009002o`31eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP02obD000?o00001P0000@01?lW0031o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0W0003o`0000H000040003o`3o02T0
0;ooeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?Fo`0X0003o`0000H000040003o`3o02X00_l0^@<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l300;o:@000ol000060000
1@02ob`00;Wo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3o`0Z00;o200003@00_l0/`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o=@0003H00;?oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0g0000=`00/Ol?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0h0000>002o`2[0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o>@0003X00:_o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0>`0003/00_l0YMH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP02oc`0000m002Uo`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo03h0000n002SomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0o0000?`02o`2M0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`02od000011002Mo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`120000@P00Vol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o04<0001300;o
09GF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP02od@00015002Eo`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33ol0AP0004H00_l0S`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;oA`0004P008oo0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l3o`190000B@00SOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1:0000BP02o`27
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?00;oB`0004`008OoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0C@0004d008Go3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`oo04h0001>00;o07l3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH300;oC`00050007oo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o0540001A00;o07WF0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F00;oDP0005<0
07Wo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`oo05@0001D001gomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0E@0005D00_l0L@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l300;oEP0005L0077o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`1H0000F002o`1[3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l00_mI0000FP00JooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mKo05/0001K001Yo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`oo05`0001L00;o06<3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<0
0_mM0000GP00Hol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`1O0000G`00HOl3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0H00006000_l0F`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l00_mQ0000HP00FooF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0
H`0006<00_l0E@<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<00_mT0000I@00EOl3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0ol0IP0006H005?o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`1W0000I`02o`1=eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH00_mX0000J@00COl?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo06X0001Z001;omH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo06/0001[00;o04D33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<00_m/0000K@00AOl3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1^0000KP02o`0o3`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o
K`00070003ooeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0L@00074003go3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo0780001b00;o03L3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;oL`0007@003Oo0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o07D0001e000eo`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0MP0007H00_l0;`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;oM`0007P002ooeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`1i0000N@02o`0Y0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<00_mj0000N`00:Ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?o07`0001l000Wo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`?o07d0001m00;o027F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH00_mn0000O`008Ol?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`200000P002o`0K0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH300;oP@00088001_o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0P`0008<001Wo0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?o08@0002400;o01<?0`l33`<?0`l33`<?0`l33`<?00;oQ@0008H0
01?oeP?F0mH3eP?F0mH3eP?F0mKo08L00027000Ao`l33`<?0`l33`<?0`l33ol0R00008P00_l02`?F
0hi>STkF0mH300;oR@0008X000_oCSi>?ThnCSh3o`2;0000RP002Tj>CXi>STj>CXj<0000RP002Si>
?ThnCSi>?Tj<0000R@0038i>STj>CXi>STj>CX/00029000<CSi>?ThnCSi>?ThnR`0008T000b>CXi>
STj>CXi>STj;0000R@0034hnCSi>?ThnCSi>?X/0002:000:CXi>STj>CXi>SX`0002:000:?ThnCSi>
?ThnCX`0002;0008STj>CXi>STj=0000S@0014hnCSj?0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000S@03oi00002@0003o`0008d0002@0003
o`0008d0002=00?oT00008d000?o0000T00008d01?n?0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {272.875, 0}} -> {-1.24864, -1.06781, 
  0.0087013, 0.0087013}},
  CellTags->"WorkGraphics"]
}, Open  ]],

Cell[TextData[{
  "After ",
  StyleBox["ShowFigure", "MR"],
  " has been used, ",
  StyleBox["ShowPermutation", "MR"],
  " can be used by simply giving a permutation to be applied to the last \
figure."
}], "MathCaption",
  CellTags->"WorkGraphics"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ShowPermutation[{4, 3, 2, 1, \ 5}]\)], "Input",
  CellLabel->"In[90]:=",
  CellTags->"WorkGraphics"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .45288 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.010783 0.47619 [
[ 0 0 0 0 ]
[ 1 .45288 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .45288 L
0 .45288 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.010783 0.477324 0.442101 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.400557 0.427716 0.400557 [
[.5 .96356 -18 0 ]
[.5 .96356 18 9 ]
[ 0 0 0 0 ]
[ 1 .95106 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
[(Before)] .5 .96356 0 -1 Mshowa
0 0 m
1 0 L
1 .95106 L
0 .95106 L
closepath
clip
newpath
.74 .99 .79 r
.88095 .55149 m
.73544 .10366 L
.26456 .10366 L
.11905 .55149 L
.5 .82827 L
F
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.88095 .55149 m
.73544 .10366 L
.26456 .10366 L
.11905 .55149 L
.5 .82827 L
.88095 .55149 L
s
0 g
[(1)] .97619 .58244 0 0 Mshowa
[(2)] .7943 .02264 0 0 Mshowa
[(3)] .2057 .02264 0 0 Mshowa
[(4)] .02381 .58244 0 0 Mshowa
[(5)] .5 .92841 0 0 Mshowa
1 0 0 r
.045 w
.88095 .55149 Mdot
0 1 0 r
.73544 .10366 Mdot
0 0 1 r
.26456 .10366 Mdot
1 1 0 r
.11905 .55149 Mdot
.628 .126 .941 r
.5 .82827 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.010783 0.97619 0.442101 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.400557 0.427716 0.400557 [
[.5 .96356 -15 0 ]
[.5 .96356 15 9 ]
[ 0 0 0 0 ]
[ 1 .95106 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
[(After)] .5 .96356 0 -1 Mshowa
0 0 m
1 0 L
1 .95106 L
0 .95106 L
closepath
clip
newpath
.74 .99 .79 r
.88095 .55149 m
.73544 .10366 L
.26456 .10366 L
.11905 .55149 L
.5 .82827 L
F
0 0 0 r
.5 Mabswid
[ ] 0 setdash
.88095 .55149 m
.73544 .10366 L
.26456 .10366 L
.11905 .55149 L
.5 .82827 L
.88095 .55149 L
s
0 g
[(4)] .97619 .58244 0 0 Mshowa
[(3)] .7943 .02264 0 0 Mshowa
[(2)] .2057 .02264 0 0 Mshowa
[(1)] .02381 .58244 0 0 Mshowa
[(5)] .5 .92841 0 0 Mshowa
1 1 0 r
.045 w
.88095 .55149 Mdot
0 0 1 r
.73544 .10366 Mdot
0 1 0 r
.26456 .10366 Mdot
1 0 0 r
.11905 .55149 Mdot
.628 .126 .941 r
.5 .82827 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[90]:=",
  ImageSize->{288, 130.375},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000PPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@0002<0
0om300CoA004od800olV00009P000ol000110003o`0004D000?o0000A@000ol0000S00009P000ol0
00120003o`0004D000?o0000A0000ol0000S00009002odH000?o0000A@000ol0001100;o9P0002H0
00?o0000@0001?l00?m40004o`00odD000?o00008`0002<00om400;oAP02od<00olV0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000:`03C3@00m1D00?@=@03C2`0000Z00E<<P05d5801M0c00E<:`0002X0
1D`bo`G@DP05d3?o1D`[0000:P05C00beP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP<5d5801M00<mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP05C2/0000[00=<03@?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l30m1D00?@03D?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`03C2`0000[000ko`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0D`00>ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02`0000[000ko`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0D`00>ol?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo02`0000[000ko`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0D`00>ol3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02`0
000Z000mo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`1A000mo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l3o`0[0000:P00?OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0D@00?OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0:`0002X003go0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o054003go0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02/0000Y000oo`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o04l0
03oo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0ol0:P0002T003oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0C`00?ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0Z0000:@00?ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`1?000oo`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02X0000X0011o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0
C@00@Ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o02T0000X0011omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0C@00@OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo02T0000X0011o`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0C@00@Ol33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02T0
000W0013o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3o`1;0013o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0X00009`00@ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0B`00@ol?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0:00002L0
04?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?o04/004?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?o02P0000V0015o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o04T004Go0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol09`0002H0
04GoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0B@00AOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0W00009P00AOl33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`190015o`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02L0
000U0017o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0ol0A`00Aol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02H0000U0017o`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0A`00Aol?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`oo02H0000U0017o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0A`00Aol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02H0000T0019o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`150019o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0U00009000BOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l0A@00BOoF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l09@0002@004Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o04D004Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02D0000S001;o`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?o04<004_o0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0900002<004_o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0@`00Bol?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?o`0T00008`00Bol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`13001;o`?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o02@0
000S001;o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`oo04<004_o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol09000028004goeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?Fo`11001=omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l08`00028004go0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`11001=
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0ol08`00028004goeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`11001=omH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3e_l08`00024004oo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo03l004oo3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo0280
000Q001?o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0o001?o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0R00008@00Col?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0?`00Col?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol08P000200057oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0?@00DOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0Q00008000DOl33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`0m001Ao`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o0240000P001AomH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo03d0057oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l08@0001l005?o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
o`0k001Co`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0800001l005?o0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
o`0k001Co`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0800001l005?o3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
o`0k001Co`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33ol0800001h005GoeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mKo03T005GoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo01l0000N001Eo`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l3o`0i001Eo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0O00007P00EOoF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0>@00EOoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3e_l07`0001d005Oo3`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33ol0=`00Eol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0N00007@00Eol3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`0g001Go`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o01h0
000M001Go`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo03L005Oo3`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33ol07P0001`005WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?Fo`0e001IomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3e_l07@0001`005Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`0e001I
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol07@0001T00ml0F?oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH37c400al0EmH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP03ga/0000H00GO05H33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`DO;`057`1E3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`05gaX0
000H00GO05KF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`DO;`057`1E0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0`05gaX0000>00?o1`05g`1Fo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l57`H00olK00?o
20057`1E3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`05g`P00ol?00003`000ol0000700?O0P02o`1A
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o00@07alO20000ol0000K0003o`0000P00al0E03oo`?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0`;o00@0gmoO2P000ol0000>00003@04o`l0057o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0ol03P000ol0000K0003o`0000h0057o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol03P04o`l0000=0003
o`3o014004oo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o00l000?o00006`000ol0000?001?o`?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3o`0?0003o`3o0100000=0003o`3o01800_l0B@l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_l@0003o`0001/0
00?o00004002o`193`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02oa0000?o0?l0400000h00_lD0019omH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
o`0A00;o7002oa@004WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mKo01<00_l@00009@02o`130`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`02odL00_l0@`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<00_lV00009`00@ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0B`00@ol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0:00002P0047o0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3o`1=0011o`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0
:@0002T00_l0>mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F00;oC`02o`0keP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH00_lZ0000:`00>ol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo05<003_o3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0/0000;002o`0e0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_mE00;o03D3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02obd0000^000eo`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0ol0F@00=Ol33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o02l0000_000co`?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o05/003?o0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0<00003000_l0;@l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02oed00_l0;@l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02oc40000b000]omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mKo064002goeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3e_l0<`0003<00_l09`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?
0`02of<00_l09`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`02oc@0000e000W
o`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o06L002Oo0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0=P0003H002Go0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`?o06T002Go0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`?o03L0000g00;o
01oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F00;oJ`02o`0OeP?F0mH3eP?F0mH3eP?F0mH3
eP?F0mH3eP?F0mH3eP02ocP0000i000Oo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`1_000O
o`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?o`0j0000>P02o`0I0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0`02og400_l06@?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_lk0000?0006Ol33`<?0`l3
3`<?0`l33`<?0`l33`<?0ol0M@006Ol33`<?0`l33`<?0`l33`<?0`l33`<?0ol0?@0003d001Oo0mH3
eP?F0mH3eP?F0mH3eP?F0mH3o`1g000Go`?F0mH3eP?F0mH3eP?F0mH3eP?F0ol0?P0003h00_l04@l3
3`<?0`l33`<?0`l33`<?00;oN@02o`0A3`<?0`l33`<?0`l33`<?0`l00_lo0000@0004OoF0mH3eP?F
0mH3eP?F0mKo07d0017oeP?F0mH3eP?F0mH3eP?Fo`110000@@02o`0;0`l33`<?0`l33`<00_mo00;o
00/33`<?0`l33`<?0`02od800013000;o`?F0mH3eP?F0ol0P`002ol3eP?F0mH3eP?o04@000140009
o`<?0`l33`?o08D000Wo0`l33`<?0ol0A@0004D00_l00mH3eP02ohL00_l00mH3eP02odH000170003
CSi>08/000=>?Th0B00004H000E>STj>CP290005CXi>STh0A`0004H000DnCSi>?P290005?ThnCSh0
A`0004H000E>STj>CP290005CXi>STh0A`0004L000=>?Th0R`000dhnCP180000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000AP03oh/00om90000B@000ol0002;0003o`0004H000190003
o`0008/000?o0000AP0004H00on;00?oB@0004H000?o0000R`000ol000190000AP04ohX01?m80000
o`0Q0000o`0Q0000o`0Q0000=P04o`@01?l00`3oo`02o`<00ol200Co0`04ofd00_l00`3oo`0200Co
0`03o`<01?l00`3oo`02oc`0000g0004o`00o`8000?o000010000ol000020005o`000?l00P000ol0
00020003o`00070000?o0?l010000ol000030006o`00o`3o1P000ol0000l0000=`001?l00?l200Go
0P000ol000020005o`000?l00P000ol0000200GoKP03o`@000?o00000`000ol0000200Go0P000ol0
000l0000=`03o`<000Go0000o`020003o`00008000Go0000o`0200;o0`001Ol0003o06h000?o0?l0
10000ol000030003o`00008000Go0000o`0200;o?@0003L000Co003o0`03o`801?l300?o0P02o`03
0?oo00800om`0003o`0000801?l200Co0`03o`800_l00`3oo`0k0000=P04o`X000?o0000P@02o`D0
00?o00000`000ol000180000A003ohP00ol30003o`0004P0003o0240003o0240003o02400000\
\>"],
  ImageRangeCache->{{{0, 287}, {129.375, 0}} -> {-0.0548928, -0.0226491, 
  0.00735118, 0.00735118}, {{7.4375, 137}, {126.25, 
  3.0625}} -> {-1.52142, -1.13365, 0.0210669, 0.0210669}, {{149.938, 279.5}, {
  126.25, 3.0625}} -> {-4.52345, -1.13365, 0.0210669, 0.0210669}},
  CellTags->"WorkGraphics"],

Cell[BoxData[
    \("The figure on the left represents the original figure and the one on \
the right exhibits the effect of the transformation determined by the given \
permutation."\)], "Print",
  CellTags->"WorkGraphics"],

Cell[BoxData[
    \({4, 3, 2, 1, 5}\)], "Output",
  CellLabel->"Out[90]=",
  CellTags->"WorkGraphics"]
}, Open  ]],

Cell["5.4.3 Adjoin", "Subsubsection",
  CellTags->{"Adjoin", "i:34"}],

Cell[TextData[{
  "The set of Gaussian integers is the set of all elements of the form ",
  Cell[BoxData[
      \(TraditionalForm
      \`{a\  + \ b\ i\  | \ a, \ b\  \[Element] \ \[DoubleStruckCapitalZ]}
        \)]],
  ". Although the polynomial ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\  - \ 2\)]],
  " does not have zeros in the rationals ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ]\)]],
  ", it does have zeros in the set ",
  Cell[BoxData[
      \(TraditionalForm
      \`\({a\  + \ b\ \@2\  | \ \ a, \ 
        b\  \[Element] \ \[DoubleStruckCapitalQ]}\ \)\)]],
  ". Note the similarity between the two sets. In general, given ",
  Cell[BoxData[
      \(TraditionalForm\`\@d\)]],
  " for some integer ",
  Cell[BoxData[
      \(TraditionalForm\`d\)]],
  " and some set ",
  Cell[BoxData[
      \(TraditionalForm\`S\)]],
  " (usually a group or ring), we can construct the set ",
  Cell[BoxData[
      \(TraditionalForm\`S[\@d]\)]],
  " defined as ",
  Cell[BoxData[
      \(TraditionalForm\`{a\  + \ b\ \@d\  | \ a, \ b\  \[Element] \ S}\)]],
  ". The Gaussian integers are therefore denoted \[DoubleStruckCapitalZ]",
  Cell[BoxData[
      \(TraditionalForm\`\([i]\)\)]],
  " (since ",
  Cell[BoxData[
      \(TraditionalForm\`i\  = \ \@\(-1\)\)]],
  "), while the second set is denoted ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalQ][\@2]\)]],
  ". In each case, we say we are ",
  StyleBox["adjoining",
    FontSlant->"Italic"],
  " an element to the underlying set. The same process can be applied to \
finite sets. Additionally, this process can be generalized to adjoining \
elements other than square roots, as well as generating lists of polynomials \
by adjoining an indeterminate."
}], "Text",
  CellTags->"Adjoin"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["Adjoin",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["list",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["num",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(give\ the\ elements\ in\ \),
                  SingleLetterItalics->False], 
                StyleBox["list",
                  FontSlant->"Italic"], 
                StyleBox[\(\ with\ \),
                  SingleLetterItalics->False], 
                StyleBox["num",
                  FontSlant->"Italic"], 
                StyleBox[\(\ adjoined, \ where\ \),
                  SingleLetterItalics->False], 
                StyleBox["num",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["needs",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["to",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["be",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["of",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["form",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[\(n\^\(p/q\)\),
                  FontSlant->"Italic"]}], ",", " ", 
              RowBox[{"where", " ", 
                StyleBox["n",
                  FontSlant->"Italic"]}], ",", " ", 
              StyleBox["p",
                FontSlant->"Italic"], ",", " ", 
              RowBox[{"and", 
                StyleBox[" ",
                  FontSlant->"Italic"], 
                StyleBox["q",
                  FontSlant->"Italic"], " ", "are", " ", "integers"}]}]},
          {
            RowBox[{
              StyleBox["Adjoin",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["num",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(for\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["either",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Adjoin",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        RowBox[{
                          StyleBox["Elements",
                            "MR"], 
                          StyleBox["[",
                            "MR"], 
                          StyleBox["S",
                            "TI"], 
                          StyleBox["]",
                            "MR"]}], 
                        StyleBox[",",
                          "MR"], " ", 
                        StyleBox["num",
                          "TI"]}], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}]}]},
          {
            RowBox[{
              StyleBox["Adjoin",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["list",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["ind",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["deg",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              
              StyleBox[
                \(give\ the\ set\ of\ polynomials\ in\ the\ indeterminate\ 
                \),
                SingleLetterItalics->False], 
              StyleBox["ind",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["of",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["degree",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["less",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["than",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["or",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["equal",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["deg",
                FontSlant->"Italic"], 
              StyleBox[\(\ with\ coefficients\ from\ \),
                SingleLetterItalics->False], 
              StyleBox["list",
                FontSlant->"Italic"]}]},
          {
            RowBox[{
              StyleBox["Adjoin",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["S",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["ind",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["deg",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(for\ \),
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox["S",
                    "TraditionalForm"],
                  "Text"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["either",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["a",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["or",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["ringoid",
                  SingleLetterItalics->False]}], 
              StyleBox[",",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Adjoin",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["Elements",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      StyleBox["S",
                        "TI"], 
                      StyleBox["]",
                        "MR"], 
                      StyleBox[",",
                        "MR"], " ", 
                      StyleBox["ind",
                        "TI"], 
                      StyleBox[",",
                        "TI"], " ", 
                      StyleBox["deg",
                        "TI"], 
                      StyleBox["]",
                        "MR"]}],
                    "StandardForm"],
                  "Text"]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->"Adjoin"],

Cell[TextData[{
  "Uses of the ",
  StyleBox["Adjoin",
    FontFamily->"Courier"],
  " function."
}], "Caption",
  CellTags->"Adjoin"],

Cell[TextData[{
  "Here we adjoin ",
  Cell[BoxData[
      \(TraditionalForm\`\@2\)]],
  " to the set {5, 6, 8}."
}], "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Adjoin[{5, 6, \ 8}, \@2]\)], "Input",
  CellLabel->"In[91]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    \({5 + 5\ \@2, 5 + 6\ \@2, 5 + 8\ \@2, 6 + 5\ \@2, 6 + 6\ \@2, 
      6 + 8\ \@2, 8 + 5\ \@2, 8 + 6\ \@2, 8 + 8\ \@2}\)], "Output",
  CellLabel->"Out[91]=",
  CellTags->"Adjoin"]
}, Open  ]],

Cell["\<\
When we adjoin 5 to the set {5, 6, 8}, there is no enlargement (for \
obvious reasons).\
\>", "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Adjoin[{5, 6, \ 8}, 5]\)], "Input",
  CellLabel->"In[92]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    \({5, 6, 8}\)], "Output",
  CellLabel->"Out[92]=",
  CellTags->"Adjoin"]
}, Open  ]],

Cell["We can adjoin a cube root to a list of symbols.", "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[a, \ t]\), 
    \(Adjoin[{a, t}, 2\^\(1/3\)]\)}], "Input",
  CellLabel->"In[93]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    \({a + 2\^\(1/3\)\ a + 2\^\(2/3\)\ a, a + 2\^\(1/3\)\ a + 2\^\(2/3\)\ t, 
      a + 2\^\(2/3\)\ a + 2\^\(1/3\)\ t, a + 2\^\(1/3\)\ t + 2\^\(2/3\)\ t, 
      2\^\(1/3\)\ a + 2\^\(2/3\)\ a + t, 2\^\(1/3\)\ a + t + 2\^\(2/3\)\ t, 
      2\^\(2/3\)\ a + t + 2\^\(1/3\)\ t, t + 2\^\(1/3\)\ t + 2\^\(2/3\)\ t}
      \)], "Output",
  CellLabel->"Out[94]=",
  CellTags->"Adjoin"]
}, Open  ]],

Cell[TextData[{
  "Adjoining can be nested. Note that here we use the group (or ring) ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " instead of a list of elements."
}], "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Adjoin[Adjoin[Z[2], \@3], \ \@2]\)], "Input",
  CellLabel->"In[95]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    \({0, \@6, \@2, \@2 + \@6, \@3, \@3 + \@6, \@2 + \@3, \@2 + \@3 + \@6, 1, 
      1 + \@6, 1 + \@2, 1 + \@2 + \@6, 1 + \@3, 1 + \@3 + \@6, 1 + \@2 + \@3, 
      1 + \@2 + \@3 + \@6}\)], "Output",
  CellLabel->"Out[95]=",
  CellTags->"Adjoin"]
}, Open  ]],

Cell["Here we adjoin the cube of a fifth root of 2 to {0, 1}.", "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Adjoin[Z[2], 2\^\(3/5\)] // Short\)], "Input",
  CellLabel->"In[96]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    TagBox[
      \({0, 4\ 2\^\(2/5\), \[LeftSkeleton]29\[RightSkeleton], 
        1 + 2\ 2\^\(1/5\) + 4\ 2\^\(2/5\) + 2\^\(3/5\) + 2\ 2\^\(4/5\)}\),
      Short]], "Output",
  CellLabel->"Out[96]//Short=",
  CellTags->"Adjoin"]
}, Open  ]],

Cell["\<\
We can also form a list of polynomials by providing the set of \
coefficients, the indeterminate, and the bound on the degree.\
\>", 
  "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(Adjoin[Z[2], \ \[Alpha], \ 2]\),
      FontFamily->"Courier",
      FontWeight->"Bold"]], "Input",
  CellLabel->"In[97]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    \({0, \[Alpha]\^2, \[Alpha], \[Alpha] + \[Alpha]\^2, 1, 1 + \[Alpha]\^2, 
      1 + \[Alpha], 1 + \[Alpha] + \[Alpha]\^2}\)], "Output",
  CellLabel->"Out[97]=",
  CellTags->"Adjoin"]
}, Open  ]],

Cell[TextData[{
  "Since we are interested in the elements for coefficients, it doesn\
\[CloseCurlyQuote]t matter if we are working with a group or a ring. Here we \
have all third degree (and lower) polynomials over ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  " in the indeterminate ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  "."
}], "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Adjoin[Z[3, \ Structure\  \[Rule] \ Ring], \ x, \ 3] // 
      Short[#, 2]&\)], "Input",
  CellLabel->"In[98]:=",
  CellTags->"Adjoin"],

Cell[BoxData[
    TagBox[
      \({0, x\^3, 2\ x\^3, x\^2, \[LeftSkeleton]73\[RightSkeleton], 
        2 + 2\ x + x\^2 + 2\ x\^3, 2 + 2\ x + 2\ x\^2, 
        2 + 2\ x + 2\ x\^2 + x\^3, 2 + 2\ x + 2\ x\^2 + 2\ x\^3}\),
      (Short[ #, 2]&)]], "Output",
  CellLabel->"Out[98]//Short="]
}, Open  ]],

Cell["5.4.4 Disguising groups and rings", "Subsubsection",
  CellTags->{"Disguising", "i:35"}],

Cell[TextData[{
  "There are five groups of order 8. If they are presented as Cayley tables \
using only generic letters (",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " through ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  "), is it easy to determine which table belongs to which group? The ",
  StyleBox["DisguiseGroupoid", "MR"],
  " function can facilitate the task of presenting generic-looking groups."
}], "Text",
  CellTags->"Disguising"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["DisguiseGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{"return", " ", "the", " ", "groupoid", " ", 
                  FormBox["G",
                    "TraditionalForm"], " ", "with", " ", "the", " ", 
                  "elements", " ", "of"}], " ", 
                RowBox[{
                  FormBox["G",
                    "TraditionalForm"], " ", "replaced", " ", "with", " ", 
                  "strings", " ", 
                  FormBox["a",
                    "TraditionalForm"]}]}], ",", " ", 
              FormBox["b",
                "TraditionalForm"], ",", " ", \(etc . \), ",", " ", 
              \(in\ order\ to\ provide\ a\ context\[Hyphen]free\ environment\ 
                to\ \(explore\ group\ properties\)\)}]},
          {
            RowBox[{
              StyleBox["DisguiseGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["rules",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["groupoid",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["G",
                SingleLetterItalics->False,
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["disguised",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["according",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["to",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["rules",
                FontSlant->"Italic"], 
              StyleBox[\(\ given\),
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["DisguiseGroupoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["G",
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["Randomize",
                        "MR"], 
                      StyleBox[" ",
                        "MR"], 
                      StyleBox["\[Rule]",
                        "MR"], " ", 
                      StyleBox["True",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox["return",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["the",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["groupoid",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["G",
                  SingleLetterItalics->False,
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["disguised",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["by",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["first",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              
              StyleBox[
                \(randomizing\ the\ elements\ before\ using\ the\ rule\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["assignments",
                  SingleLetterItalics->False], 
                StyleBox[";",
                  SingleLetterItalics->False], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["Randomize",
                    "MR"], 
                  StyleBox[\(\ defaults\ to\ \),
                    SingleLetterItalics->False], 
                  StyleBox["False",
                    "MR"]}]}]}]},
          {
            RowBox[{
              StyleBox["DisguiseRingoid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["R",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ a\ disguised\ ringoid\ in\ the\ same\),
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                RowBox[{
                  StyleBox["fashion",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["as",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["DisguiseGroupoid",
                    "MR"], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  StyleBox["does",
                    SingleLetterItalics->False]}], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox[\(for\ groupoids\),
                  SingleLetterItalics->False]}]}]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"Disguising", "i:36"}],

Cell["Disguising a groupoid or ringoid.", "Caption",
  CellTags->"Disguising"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CayleyTable[{DisguiseGroupoid[G\  = \ DirectProduct[Z[2], \ Z[2]]], \ 
        DisguiseGroupoid[
          G, {{0, 0}\  \[Rule] \ "\<cat\>", \ {0, \ 1}\  \[Rule] \ "\<dog\>", 
            \ {1, 1}\  \[Rule] \ "\<hat\>", \ {1, 0}\  \[Rule] \ "\<log\>"}, 
          \ Randomize\  \[Rule] \ True]}, \ Mode\  \[Rule] \ Visual]; \)\)], 
  "Input",
  CellLabel->"In[99]:=",
  CellTags->"Disguising"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .52381 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.0124717 0.47619 [
[ 0 0 0 0 ]
[ 1 .52381 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .52381 L
0 .52381 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.0124717 0.477324 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(a)] .30952 .69286 0 0 Mshowa
[(b)] .5 .69286 0 0 Mshowa
[(c)] .69048 .69286 0 0 Mshowa
[(d)] .88095 .69286 0 0 Mshowa
[(b)] .30952 .50238 0 0 Mshowa
[(a)] .5 .50238 0 0 Mshowa
[(d)] .69048 .50238 0 0 Mshowa
[(c)] .88095 .50238 0 0 Mshowa
[(c)] .30952 .3119 0 0 Mshowa
[(d)] .5 .3119 0 0 Mshowa
[(a)] .69048 .3119 0 0 Mshowa
[(b)] .88095 .3119 0 0 Mshowa
[(d)] .30952 .12143 0 0 Mshowa
[(c)] .5 .12143 0 0 Mshowa
[(b)] .69048 .12143 0 0 Mshowa
[(a)] .88095 .12143 0 0 Mshowa
[(a)] .11905 .69286 0 0 Mshowa
[(b)] .11905 .50238 0 0 Mshowa
[(c)] .11905 .3119 0 0 Mshowa
[(d)] .11905 .12143 0 0 Mshowa
[(a)] .30952 .88333 0 0 Mshowa
[(b)] .5 .88333 0 0 Mshowa
[(c)] .69048 .88333 0 0 Mshowa
[(d)] .88095 .88333 0 0 Mshowa
[(???)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.0124717 0.97619 0.511338 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.214286 0.190476 0.0261905 0.190476 [
[ 0 0 0 0 ]
[ 1 1.1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.1 L
0 1.1 L
closepath
clip
newpath
1 1 0 r
.21429 .59762 m
.21429 .7881 L
.40476 .7881 L
.40476 .59762 L
F
.40476 .40714 m
.40476 .59762 L
.59524 .59762 L
.59524 .40714 L
F
.59524 .21667 m
.59524 .40714 L
.78571 .40714 L
.78571 .21667 L
F
.78571 .02619 m
.78571 .21667 L
.97619 .21667 L
.97619 .02619 L
F
1 .5 0 r
.40476 .59762 m
.40476 .7881 L
.59524 .7881 L
.59524 .59762 L
F
.21429 .40714 m
.21429 .59762 L
.40476 .59762 L
.40476 .40714 L
F
.78571 .21667 m
.78571 .40714 L
.97619 .40714 L
.97619 .21667 L
F
.59524 .02619 m
.59524 .21667 L
.78571 .21667 L
.78571 .02619 L
F
.56 .37 .6 r
.59524 .59762 m
.59524 .7881 L
.78571 .7881 L
.78571 .59762 L
F
.78571 .40714 m
.78571 .59762 L
.97619 .59762 L
.97619 .40714 L
F
.21429 .21667 m
.21429 .40714 L
.40476 .40714 L
.40476 .21667 L
F
.40476 .02619 m
.40476 .21667 L
.59524 .21667 L
.59524 .02619 L
F
0 0 1 r
.78571 .59762 m
.78571 .7881 L
.97619 .7881 L
.97619 .59762 L
F
.59524 .40714 m
.59524 .59762 L
.78571 .59762 L
.78571 .40714 L
F
.40476 .21667 m
.40476 .40714 L
.59524 .40714 L
.59524 .21667 L
F
.21429 .02619 m
.21429 .21667 L
.40476 .21667 L
.40476 .02619 L
F
1 1 0 r
.21429 .7881 m
.21429 .97857 L
.40476 .97857 L
.40476 .7881 L
F
1 .5 0 r
.40476 .7881 m
.40476 .97857 L
.59524 .97857 L
.59524 .7881 L
F
.56 .37 .6 r
.59524 .7881 m
.59524 .97857 L
.78571 .97857 L
.78571 .7881 L
F
0 0 1 r
.78571 .7881 m
.78571 .97857 L
.97619 .97857 L
.97619 .7881 L
F
1 1 0 r
.02381 .59762 m
.02381 .7881 L
.21429 .7881 L
.21429 .59762 L
F
1 .5 0 r
.02381 .40714 m
.02381 .59762 L
.21429 .59762 L
.21429 .40714 L
F
.56 .37 .6 r
.02381 .21667 m
.02381 .40714 L
.21429 .40714 L
.21429 .21667 L
F
0 0 1 r
.02381 .02619 m
.02381 .21667 L
.21429 .21667 L
.21429 .02619 L
F
0 g
1 Mabswid
[ ] 0 setdash
.02381 .02619 m
.02381 .97857 L
s
.02381 .02619 m
.97619 .02619 L
s
.02381 .21667 m
.97619 .21667 L
s
.02381 .40714 m
.97619 .40714 L
s
.02381 .59762 m
.97619 .59762 L
s
.02381 .7881 m
.97619 .7881 L
s
.02381 .97857 m
.97619 .97857 L
s
.21429 .02619 m
.21429 .97857 L
s
.40476 .02619 m
.40476 .97857 L
s
.59524 .02619 m
.59524 .97857 L
s
.78571 .02619 m
.78571 .97857 L
s
.97619 .02619 m
.97619 .97857 L
s
.02381 .97857 m
.21429 .7881 L
s
2.6 Mabswid
.21429 .02619 m
.21429 .97857 L
s
.02381 .7881 m
.97619 .7881 L
s
[(cat)] .30952 .69286 0 0 Mshowa
[(hat)] .5 .69286 0 0 Mshowa
[(log)] .69048 .69286 0 0 Mshowa
[(dog)] .88095 .69286 0 0 Mshowa
[(hat)] .30952 .50238 0 0 Mshowa
[(cat)] .5 .50238 0 0 Mshowa
[(dog)] .69048 .50238 0 0 Mshowa
[(log)] .88095 .50238 0 0 Mshowa
[(log)] .30952 .3119 0 0 Mshowa
[(dog)] .5 .3119 0 0 Mshowa
[(cat)] .69048 .3119 0 0 Mshowa
[(hat)] .88095 .3119 0 0 Mshowa
[(dog)] .30952 .12143 0 0 Mshowa
[(log)] .5 .12143 0 0 Mshowa
[(hat)] .69048 .12143 0 0 Mshowa
[(cat)] .88095 .12143 0 0 Mshowa
[(cat)] .11905 .69286 0 0 Mshowa
[(hat)] .11905 .50238 0 0 Mshowa
[(log)] .11905 .3119 0 0 Mshowa
[(dog)] .11905 .12143 0 0 Mshowa
[(cat)] .30952 .88333 0 0 Mshowa
[(hat)] .5 .88333 0 0 Mshowa
[(log)] .69048 .88333 0 0 Mshowa
[(dog)] .88095 .88333 0 0 Mshowa
[(???)] .02381 1.07381 -1 0 Mshowa
gsave
.97619 1.07381 -113 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
gsave
0.000000 0.000000 0.000000 setrgbcolor
1.000000 setlinewidth
gsave
newpath
 79.000000 16.000000 moveto
 540.000000 16.000000 lineto
 540.000000 4.000000 lineto
 79.000000 4.000000 lineto
 79.000000 16.000000 lineto
closepath
clip newpath
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
81.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 13.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(*) show
105.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
111.000000 13.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
grestore
%%DocumentNeededResources: font Math1Mono
%%+ font Courier
%%DocumentSuppliedResources:
%%DocumentNeededFonts: Math1Mono
%%+ Courier
%%DocumentSuppliedFonts:
%%DocumentFonts: font Math1Mono
%%+ font Courier
grestore
[(x)] .08857 .85095 0 0 Mshowa
[(y)] .16667 .92143 0 0 Mshowa
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[99]:=",
  ImageSize->{288, 150.812},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000UPP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@0000X0O?lC07co2`0000X000?oC4`05D`2oaM<03?oLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003oda<01A<0_lHC00b
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0
000:0003oda<01E<0_lGC00cogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimO
WenOGimOWeoo01OO00?o00004@000om<C00DC0;o64`0<_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko
GimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<C00EC0;o5d`0<omaOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?oC4`0
54`2oaQ<03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoenOGimOWenOGimOWenOGimOWenOGimOoaSO
00?o00002@0000X000?oC4`05D`2oaM<03?oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimO
WenOGimOWenOGimOWenOGol05ml00ol0000A0003oda<01A<0_lHC00booAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGC00c
og5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o0000
4@000om<C00DC0;o64`0<_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenO
GimOWeoo6=l00ol0000900002P000om<C00EC0;o5d`0<omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
WenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?oC4`054`2oaQ<03;om7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X000?oC4`0
5D`2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimOWenOGol0
5ml00ol0000A0003oda<01A<0_lHC00bogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenOGimOWenO
GimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGC00cogkdO_Anm7kdO_Anm7kdO_An
m7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000om<C00>C0?o0d`2oa5<
0ol4C00AooAnm7kdO_Anm7kdO_Anm7h00ol07WkdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO
00?o00002@0000X000?oC4`05D`2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimO
WenOGimOWenOGimOWenOGol05ml00ol0000A0003oda<015<00?oC4`00_lDC00foda<C?mnLGiaOW5n
LGiaOW5nLGiaOW5nogiaOW7oGimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P000om<
C008C0Go24`2o`Y<1Ol8C00<ogkdO_Anm7kdO_An0ol057kdO_Anm7kdO_CoWenOGimOWenO1?l035nO
GimOWenOGimOo`WO1Ol9g`03o`00014000?oC4`00T`5o`04C?ooo`=<1?l2C0;o1D`5o`04C?ooo`=<
1?l3C004ooAnm0Go00?dO_l00_l00gkdOP04o`08m7kdO_mOWel2o`04WoooG`Go00=OWol00_l01ImO
Weoo00GO0ol2g`Go0]l3o`CO00?o00002@0000X000?oC4`01d`01Om<C4co00U<0_l9C005oda<C?l0
2D`0<omaOW5nLGiaOW5nogiaO_mnLGiaOW5nLGkoWenOGimOWenOoimOWonOGimOWenOGimOo`09g`04
omoOo`[O00?o00004@001Om<C4co00=<00?oC?l00d`00om<o`03C003oda<00;o14`01om<C4coC?l0
0d`00om<o`03C00foda<C?mnLGiaO_mnLGkoOW5nogkoOW5nogiaOW7oGimOoenOoimOoenOoimOWonO
GomOWeoo1=l01ooOgmoogol00]l01OoOgmoo00;O00GogmoOo`0;00002P000om<C007C005oda<C?l0
2D`2o`U<00GoC4a<o`09C00cogkdO_Anm7kdO_Com7kdO_Anm7kdO_Anm?nOGimOWenOGiooWenOoimO
WenOGimOWeoo00WO1?l:g`03o`00014000GoC4a<o`03C003odco00=<00?oC?l00d`00om<C002o`A<
00OoC4a<odco00=<00?oC?l00d`09om<C4com7kdO_Com7kdooAnm?odooAnm?odO_AnoenOGomOWonO
G`04o`0;WenOoimOWenOGol01=l00ooOg`03g`Co0ml00ooOg`04g`03o`0000T0000:0003oda<00M<
00GoC4a<o`09C0;o2D`01Om<C4co00U<03?oLGiaOW5nLGiaO_mnLGkoOW5nLGiaOW5noimOWenOGimO
WonOGiooWenOGimOWenOGol03=l00ooOg`08g`03o`00014000GoC4a<o`03C003odco00=<00?oC?l0
0d`00om<C002o`A<00OoC4a<odco00=<00?oC?l00d`0=_m<C4coOW5nLGkoOW5nogiaO_mnogiaO_mn
LGiaoenOGomOWonOGimOWonOGiooWenOGimOo`CO00GogmoOo`04g`05omoOgol01]l00ol000090000
2P000om<C008C0Co2D`2o`Y<1?l9C00<ogkdO_Anm7kdO_An1?l04oAnm7kdO_Anm?nOGimOWenOGil0
1?l035nOGimOWenOGimOo`[O0ol:g`03o`00014000?oC4`00T`4o`9<0ol3C0Go00=<ool01D`4o`9<
0ol3C0Go0T`02oodO_Anm?odO_An00?o00=nm7h01Ol01gkdO_mOWel01?l00imOW`03o`03Weoo00?o
00FOGimOo`05g`Co0]l3o`;O1?l4g`03o`0000T0000:0003oda<00]<00?oC4`01d`2o`e<00?oC4`0
1d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOoimOWenOGimOWenOGimOo`0Gg`03
o`00014000?oC4`01D`00om<C00<C0;o24`00om<C00=C00bogiaOW5nogiaOW5nLGiaOW5nLGiaOW5n
LOmOWeooGimOWenOGimOWenOoimOWenOGolAg`03omoO00CO00?o00002@0000X000?oC4`02T`2o`U<
0_l<C0;o2D`08_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_CoWenOGimOWel2o`0?WenOGimOWenOGimO
Weoo01OO00?o00004@000om<C004C0;o3T`2o`M<0_l?C004ooAnm0?o01GdO_Anm7kdO_Anm7kdO_An
m7koGil00_l055nOGimOWenOGimOWonOGimOWeoo4Ml00ooOg`04g`03o`0000T0000:0003oda<01E<
0_lGC00cog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO
00?o00004@000om<C00DC0;o64`0<_mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7oGimOWenOGimOWenO
GimOWenOGimOWeoo6=l00ol0000900002P000om<C00EC0;o5d`0<omnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_CoWenOGimOWenOGimOWenOGimOWenOGimOo`0Gg`03o`00014000?oC4`054`2oaQ<03;om7kd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X0
00?oC4`05D`2oaM<03?oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5noimOWenOGimOWenOGimOWenOGimO
WenOGol05ml00ol0000A0003oda<01A<0_lHC00bogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOmOWenO
GimOWenOGimOWenOGimOWenOGolHg`03o`0000T0000:0003oda<01E<0_lGC00cogkdO_Anm7kdO_An
m7kdO_Anm7kdO_Anm?nOGimOWenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000om<C00DC0;o
64`0<_odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7koGimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0
000900002P000om<C00EC0;o5d`0<omaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGkoWenOGimOWenOGimO
WenOGimOWenOGimOo`0Gg`03o`00014000?oC4`054`2oaQ<03;oOW5nLGiaOW5nLGiaOW5nLGiaOW5n
LGiaoenOGimOWenOGimOWenOGimOWenOGimOoaSO00?o00002@0000X000?oC4`05D`2oaM<03?oO_An
m7kdO_Anm7kdO_Anm7kdO_Anm7kdoimOWenOGimOWenOGimOWenOGimOWenOGol05ml00ol0000A0003
oda<01A<0_lHC00booAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_mOWenOGimOWenOGimOWenOGimOWenO
GolHg`03o`0000T0000:0003oda<01E<0_lGC00cog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_nOGimO
WenOGimOWenOGimOWenOGimOWeoo01OO00?o00004@000om<C00DC0;o64`0<_mnLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7oGimOWenOGimOWenOGimOWenOGimOWeoo6=l00ol0000900002P1loa<0O?l;0000
2P006?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003
omoO01KO01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGia
OP02o`0ILGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003omoO01GO01[oGimOWenOGimOWenOGimO
WenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l067kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omnm7kdO_An
m7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mO
WenOGimOWenOGimOWenOGimOWenOGioo2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0H
LGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimO
o`0C000Gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_l06G5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l0
64`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?odO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm0;o01Qnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003omoO01KO01WoGimOWenOGimO
WenOGimOWenOGimOWeoo01<001OoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm002o`0IO_Anm7kdO_Anm7kd
O_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000H
ogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0675nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?ogml0
5]l06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omaOW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o
01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimO
WenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kdO_@2o`0HO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimOWenOGimOo`0C000GogkdO_Anm7kdO_An
m7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l064`00ooOg`0Eg`0JoenOGimO
WenOGimOWenOGimOWenOGimOWol;00002P006?mnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP;o01QaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlHC003omoO01KO01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<0
01OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`0HC003
omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimO
WenOGimOWenOGol04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001SoOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ooOg`0Fg`0I
oenOGimOWenOGimOWenOGimOWenOGimOo`0C000Aog5nLGiaOW5nLGiaOW5nLGh00ol00giaOP02o`0A
LGiaOW5nLGiaOW5nLGiaOW400ol01G5nLGko011<0ol5C003omoO01GO01[oGimOWenOGimOWenOGimO
WenOGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l067kdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omnm7kdO_An
m7kdO_Anm7kdO_Anogkd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm?odO_Co01=<00?oC4`00T`00ooO
g`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P002omnLGiaOW5nLGia00?o00YaOW5n
LGiaOW5n0_l02W5nLGiaOW5nLGh3o`0;OW5nLGiaOW5nLOl02d`5o`Q<00?ogml01ml5o`[O00[oGimO
WenOGimO1?l02imOWenOGimOWeoo01<000CoLGia1Ol00g5no`02o`03OW5n00Co00QaO_ooLGiaOPGo
00=nLOl00_l00g5nL@04o`04OW5no`A<1Ol014coool3C0Co14`00ooOg`02g`?o0]l5o`;O0ol4g`05
oenOGil00_l015oooil5o`03Weoo00;o00EOWenOo`0;00002P006?odO_Anm7kdO_Com7kdooAnm7kd
O_Anm0;o01Qnm7kdO_Anm7koO_AnogkdO_Anm7kdO_l:C005oda<C?l02D`00ooOg`07g`04omoOo`_O
01WoGimOWenOGimOoenOGomOWenOGimOWeoo01<001OoO_Anm7koO_AnogkdO_mnogkdO_mnm002o`0I
O_Anm7kdooAnm?odO_Com?odO_Com7kdo`03C007oda<C?m<o`03C003odco00=<00?oC4`00T`01OoO
gmoo00?O00?ogol00]l01OoOgmoo00;O01kogmoOoenOGiooWeooGiooWeooGimOoenOoimOWol;0000
2P006?mnLGiaOW5nLGkoOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl:C005
oda<C?l02D`00ooOg`07g`Co2ml06OmOWenOGimOWeooGimOoenOGimOWenOGol04`005omaOW5nLOma
OW7oLGiaog7oLGiaog5n00;o01UaOW5nLGkoOW5nogiaO_mnogiaO_mnLGko00=<00OoC4a<odco00=<
00?oC?l00d`00om<C002C005omoOgol01Ml4o`?O00?ogml01=l02omOWenOoimOoenO00Co00]OWeoo
GimOWenOo`0;00002P006?odO_Anm7kdO_Com7kdooAnm7kdO_Anm0;o01Qnm7kdO_Anm7koO_Anogkd
O_Anm7kdO_l:C005oda<C?l02D`00ooOg`0:g`03omoO00WO01WoGimOWenOGimOoenOGomOWenOGimO
Weoo01<001OoO_Anm7koO_AnogkdO_mnogkdO_mnm002o`0IO_Anm7kdooAnm?odO_Com?odO_Com7kd
o`03C007oda<C?m<o`03C003odco00=<00?oC4`00T`01OoOgmoo00?O00?ogml00]l01OoOgmoo00KO
01[oGimOWonOGomOWenOGomOWeooGimOWenOo`/0000:000;ogiaOW5nLGiaOW401?l02GiaOW5nLGia
OP02o`0:LGiaOW5nLGiaOPCo00YaOW5nLGiaOW7o2d`4o`U<00?ogml02=l3o`_O00[oGimOWenOGimO
1?l02imOWenOGimOWeoo01<000_oLGiaOW7oLGiaOP03o`03OW5n00Go00inoomaOW5nLGkoOW5nL@?o
00=aOW401Ol00g5no`04C0Co0T`3o`=<1Ol3C003omoO00;O1?l2g`?o0]l4o`CO00GoGimOW`04o`03
GimO00?o00=OWol00ol01EnOGioo00/0000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l067kd
O_Anm7kdO_Anm7kdO_Anm7kdO_Ano`i<00?oC4`01d`00ooOg`0Fg`0IoenOGimOWenOGomOWenOGimO
WenOGimOo`0C000GogkdO_AnogkdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm?odO_Anm7kdO_Anm7kd
O_Anm?l01d`00om<C00>C003omoO00kO00?ogml01=l06_mOWenOoimOWenOGimOWenOGomOWenOGioo
2`0000X001SoOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
3D`2o`U<00?ogml05]l02OmOWenOGimOW`02o`0>GimOWenOGimOWenOGolC0004og5nL@?o011aOW5n
LGiaOW5nLGiaOW5n0_l0175nLGh3o`0BOW5nLGiaOW5nLGiaOW5nLGko1T`2oa1<00?ogml03]l00ooO
g`04g`04oenOG`;o01BOGimOWenOGimOWeooGimOWenOo`/0000:000HooAnm7kdO_Anm7kdO_Anm7kd
O_Anm7kd0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?ogml05]l06OmOWenOGimOWenOGimO
WenOGimOWenOGol04`005omnm7kdO_Anm7kdO_Anm7kdO_Anm7kd00;o01Unm7kdO_Anm7kdO_Anm7kd
O_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001SoOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLGh2o`0HLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ooOg`0Fg`0I
oenOGimOWenOGimOWenOGimOWenOGimOo`0C000Gog5nLGiaOW5nLGiaOW5nLGiaOW5nLGh00_l06G5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaO_l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimO
Wol;00002P006?odO_Anm7kdO_Anm7kdO_Anm7kdO_Anm0;o01Qnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lHC003omoO01KO01WoGimOWenOGimOWenOGimOWenOGimOWeoo01<001OoO_Anm7kdO_Anm7kdO_An
m7kdO_Anm002o`0IO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`0HC003omoO01GO01[oGimOWenOGimO
WenOGimOWenOGimOWenOo`/0000:000HogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5n0_l0675nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaQ<00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005oma
OW5nLGiaOW5nLGiaOW5nLGiaOW5n00;o01UaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko01Q<00?ogml0
5Ml06_mOWenOGimOWenOGimOWenOGimOWenOGioo2`0000X001Som7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_@2o`0HO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ooOg`0Fg`0IoenOGimOWenOGimOWenOGimO
WenOGimOo`0C000GogkdO_Anm7kdO_Anm7kdO_Anm7kdO_@00_l06GkdO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm?l064`00ooOg`0Eg`0JoenOGimOWenOGimOWenOGimOWenOGimOWol;00002P006?mnLGiaOW5n
LGiaOW5nLGiaOW5nLGiaOP;o01QaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003omoO01KO01WoGimO
WenOGimOWenOGimOWenOGimOWeoo01<001OoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOP02o`0ILGiaOW5n
LGiaOW5nLGiaOW5nLGiaOW5no`0HC003omoO01GO01[oGimOWenOGimOWenOGimOWenOGimOWenOo`/0
000:000HooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kd0_l067kdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<
00?ogml05]l06OmOWenOGimOWenOGimOWenOGimOWenOGol04`005omnm7kdO_Anm7kdO_Anm7kdO_An
m7kd00;o01Unm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co01Q<00?ogml05Ml06_mOWenOGimOWenOGimO
WenOGimOWenOGioo2`0000X0O?lC07co2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0H
GimOWenOGimOWenOGimOWenOGimOWeoo6=l00om<C00FC00IogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
o`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_l06EnOGimOWenOGimOWenOGimOWenOGimOWol0
6=l00om<C00EC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenO
GimOWenOGimOW`;o01QOWenOGimOWenOGimOWenOGimOWenOGolHg`03oda<01I<01WoLGiaOW5nLGia
OW5nLGiaOW5nLGiaOW7o01<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0IGimOWenOGimOWenO
GimOWenOGimOWenOo`0Hg`03oda<01E<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000H
oimOWenOGimOWenOGimOWenOGimOWenO0_l065nOGimOWenOGimOWenOGimOWenOGimOoaSO00?oC4`0
5T`06Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omOWenOGimOWenOGimOWenOGimOWenO00;o
01UOWenOGimOWenOGimOWenOGimOWenOGioo01SO00?oC4`05D`06_mnm7kdO_Anm7kdO_Anm7kdO_An
m7kdO_Co2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HGimOWenOGimOWenOGimOWenO
GimOWeoo6=l00om<C00FC00Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C000GoenOGimOWenOGimO
WenOGimOWenOGil00_l06EnOGimOWenOGimOWenOGimOWenOGimOWol06=l00om<C00EC00Jog5nLGia
OW5nLGiaOW5nLGiaOW5nLGiaO_l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01QOWenO
GimOWenOGimOWenOGimOWenOGolHg`03oda<01I<01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<0
01OoGimOWenOGimOWenOGimOWenOGimOW`02o`0IGimOWenOGimOWenOGimOWenOGimOWenOo`0Hg`03
oda<01E<01[oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`/0000:000HoimOWenOGimOWenOGimOWenO
GimOWenO0_l065nOGimOWenOGimOWenOGimOWenOGimOoaSO00?oC4`05T`06OmaOW5nLGiaOW5nLGia
OW5nLGiaOW5nLOl04`005omOWenOGimOWenOGimOWenOGimOWenO00;o01UOWenOGimOWenOGimOWenO
GimOWenOGioo01SO00?oC4`05D`06_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2`0000X001SoWenO
GimOWenOGimOWenOGimOWenOGil2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo6=l00om<C00FC00I
ogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0C000GoenOGimOWenOGimOWenOGimOWenOGil00_l06EnO
GimOWenOGimOWenOGimOWenOGimOWol06=l00om<C00EC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_An
m?l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01QOWenOGimOWenOGimOWenOGimOWenO
GolHg`03oda<01I<01WoLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01<001OoGimOWenOGimOWenOGimO
WenOGimOW`02o`0IGimOWenOGimOWenOGimOWenOGimOWenOo`0Hg`03oda<00i<0ol4C00Bog5nLGia
OW5nLGiaOW5nLGia0ol01G5nLGko00/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l065nO
GimOWenOGimOWenOGimOWenOGimOoaSO00?oC4`05T`06Omnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
4`005omOWenOGimOWenOGimOWenOGimOWenO00;o01UOWenOGimOWenOGimOWenOGimOWenOGioo01SO
00?oC4`04D`07_m<C4coO_Anm7kdO_Anm7kdO_Anm7kdO_Com7kdo`/0000:000:oimOWenOGimOW`Co
00YOWenOGimOWenO0_l02EnOGimOWenOG`04o`0;WenOGimOWenOGol02]l5o`WO00?oC4`024`5o`U<
00_oLGiaOW5nLGiaOP03o`0;OW5nLGiaOW5nLOl04`001?mOWel2o`04WoooG`Go00=OWol00_l00imO
W`02o`04GimOW`;o00AOoonO1Ol00imOo`02o`05GimOWol01=l3o`;O1Ol2g`?o1Ml00om<C002C0Go
00A<oooo0d`4o`=<00GoLGiaOP05o`03OW7o00;o00=aOW401?l017iaO_l;00002P006?nOGimOWenO
GiooWenOoimOWenOGimOW`;o01QOWenOGimOWeooGimOoenOGimOWenOGol:g`04omoOo`[O00?oC4`0
1d`01Om<C4co00Y<01WoO_Anm7kdO_AnogkdO_mnm7kdO_Anm7ko01<001OoGimOoenOoimOoenOoimO
WonOGomOW`02o`0IGimOWonOGomOWonOGomOWeooGiooWenOo`03g`07omoOgooOo`02g`05omoOgol0
0]l00ooOg`02g`05oda<C?l00d`00om<o`03C003odco00=<01koC4a<ogkdO_Anm?odO_Com7kdooCo
m7kdooAnm?l;00002P006?nOGimOWenOGiooWenOoimOWenOGimOW`;o01QOWenOGimOWeooGimOoenO
GimOWenOGol:g`Co2]l00om<C007C005oda<C?l02T`06OmaOW5nLGiaOW7oLGiaOW5nLGiaOW5nLOl0
4`002_mOWeooGiooWel4o`09WenOoimOWenO00;o00YOWenOoimOoenO1?l02enOGomOWenOGioo00?O
00?ogml00ml4o`?O00?ogml01Ml01Om<C4co00=<00?oC?l00d`00om<o`03C00Noda<C?maOW5nLGko
OW5nogiaO_mnogiaO_mnLGko2`0000X001SoWenOGimOWenOoimOWonOGimOWenOGil2o`0HGimOWenO
GimOoenOGomOWenOGimOWeoo3Ml00ooOg`08g`03oda<00M<00GoC4a<o`0:C00IogkdO_Anm7kdO_mn
m7koO_Anm7kdO_Ano`0C000GoenOGomOWonOGimOWonOGiooWenOGil00_l06EnOGiooWeooGimOWeoo
GimOoenOGimOWol00ml01OoOgmoo00CO00GogmoOo`07g`05oda<C?l00d`00om<o`03C003odco00=<
01koC4a<ogkdO_Anm?odO_Com7kdooCom7kdooAnm?l;00002P002_nOGimOWenOGil4o`0:GimOWenO
GimOW`;o00UOWenOGimOWel01?l02imOWenOGimOWeoo00_O0ol:g`03oda<00Q<1?l:C00;og5nLGia
OW5nLGh01?l02W5nLGiaOW5nLOlC0004oenOG`Co00>OGil00ol00imOo`03o`03WenO00;o00AOWenO
1?l00enOG`03o`03Gioo00?o00EOWenOo`04g`Co0]l3o`;O1?l5g`03oda<009<1?l2C0?o0d`5o`9<
00coLGiaOW5nogiaOW43o`03LGia00Go00=aO_l02`0000X001SoWenOGimOWenOoimOWenOGimOWenO
Gil2o`0HGimOWenOGimOoenOGimOWenOGimOWeoo6=l00om<C00;C003oda<00Q<01WoO_Anm7kdO_An
m7kdO_Anm7kdO_Anm7ko01<001OoGimOoenOGimOWenOGimOWonOGimOW`02o`0IGimOWonOGimOWenO
GimOWeooGimOWenOo`0@g`03omoO00GO00?oC4`01D`00om<C00=C00JogkdO_Anm?odO_Anm7kdO_An
m7kdO_Anm?l;00002P002OnOGimOWenOG`02o`0=WenOGimOWenOGimOW`02o`08GimOWenOGil2o`0>
GimOWenOGimOWenOGolHg`03oda<00Y<0_l:C00Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C0003
oenO00;o019OWenOGimOWenOGiooWenOGil2o`03GimO00;o01BOGimOWenOGimOWeooGimOWenOoa3O
00?ogml01Ml00om<C004C0;o3d`01OmaOW5n00?o019nLGiaOW5nLGiaOW5nLGiaO_l;00002P006?nO
GimOWenOGimOWenOGimOWenOGimOW`;o01QOWenOGimOWenOGimOWenOGimOWenOGolHg`03oda<01I<
01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0I
GimOWenOGimOWenOGimOWenOGimOWenOo`0Hg`03oda<01E<01[oO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7kdo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO0_l065nOGimOWenOGimOWenOGimOWenO
GimOoaSO00?oC4`05T`06OmaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl04`005omOWenOGimOWenOGimO
WenOGimOWenO00;o01UOWenOGimOWenOGimOWenOGimOWenOGioo01SO00?oC4`05D`06_maOW5nLGia
OW5nLGiaOW5nLGiaOW5nLGko2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HGimOWenO
GimOWenOGimOWenOGimOWeoo6=l00om<C00FC00IogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0C000G
oenOGimOWenOGimOWenOGimOWenOGil00_l06EnOGimOWenOGimOWenOGimOWenOGimOWol06=l00om<
C00EC00JogkdO_Anm7kdO_Anm7kdO_Anm7kdO_Anm?l;00002P006?nOGimOWenOGimOWenOGimOWenO
GimOW`;o01QOWenOGimOWenOGimOWenOGimOWenOGolHg`03oda<01I<01WoLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o01<001OoGimOWenOGimOWenOGimOWenOGimOW`02o`0IGimOWenOGimOWenOGimOWenO
GimOWenOo`0Hg`03oda<01E<01[oLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW5no`/0000:000HoimOWenO
GimOWenOGimOWenOGimOWenO0_l065nOGimOWenOGimOWenOGimOWenOGimOoaSO00?oC4`05T`06Omn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l04`005omOWenOGimOWenOGimOWenOGimOWenO00;o01UOWenO
GimOWenOGimOWenOGimOWenOGioo01SO00?oC4`05D`06_mnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Co
2`0000X001SoWenOGimOWenOGimOWenOGimOWenOGil2o`0HGimOWenOGimOWenOGimOWenOGimOWeoo
6=l00om<C00FC00Iog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0C000GoenOGimOWenOGimOWenOGimO
WenOGil00_l06EnOGimOWenOGimOWenOGimOWenOGimOWol06=l00om<C00EC00Jog5nLGiaOW5nLGia
OW5nLGiaOW5nLGiaO_l;00002P006?nOGimOWenOGimOWenOGimOWenOGimOW`;o01QOWenOGimOWenO
GimOWenOGimOWenOGolHg`03oda<01I<01WoO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01<001OoGimO
WenOGimOWenOGimOWenOGimOW`02o`0IGimOWenOGimOWenOGimOWenOGimOWenOo`0Hg`03oda<01E<
01[oO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7kdo`/0000:000HoimOWenOGimOWenOGimOWenOGimOWenO
0_l065nOGimOWenOGimOWenOGimOWenOGimOoaSO00?oC4`05T`06OmaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl04`005omOWenOGimOWenOGimOWenOGimOWenO00;o01UOWenOGimOWenOGimOWenOGimOWenO
Gioo01SO00?oC4`05D`06_maOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGko2`0000X0O?lC07co2`0000X0
00?ogml05Ml2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGia
OW5nLOl05d`00ol0000A0003omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimO
WenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@000ooOg`0Dg`;o
6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0
000900002P000ooOg`0Eg`;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGia
OW5nLGiaOW5nLGiao`0GC003o`00014000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenO
GimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?ogml05Ml2oaOO03?oGimO
WenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003
omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_Anm7kd
O_lHC003o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWomnLGia
OW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@000ooOg`0Dg`;o6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o64`00ol0000900002P000ooOg`0Eg`;o
5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003
o`00014000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoaQ<00?o00002@0000X000?ogml05Ml2oaOO03?oGimOWenOGimOWenOGimOWenOGimO
WenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003omoO01CO0_lHg`0boimOWenO
GimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:0003
omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimOWoodO_Anm7kdO_Anm7kdO_Anm7kdO_An
m7ko01M<00?o00004@000ooOg`0Dg`;o6=l0:_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kd
O_Anm7kdO_Anm0?o00GdO_Ano`0AC0?o14`00ol0000900002P000ooOg`0Eg`;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?ogml0
5=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW7oLGiaoaA<
00GoC4a<o`0;00002P000ooOg`07g`Go2Ml2o`WO1Ol9g`0;oenOGimOWenOGil01?l05EnOGimOWenO
Gioom7kdO_Anm7kdOP03o`0<O_Anm7kdO_Anm7ko2T`5o`Q<00?o00004@000ooOg`02g`?o0]l5o`;O
0ol3g`;o1Ml3o`;O1Ol2g`?o1=l01?nOGil2o`04GoooW`Go00>OGol00_l02EnOGimOogkdOP05o`03
O_Co00;o00?dO_@01?l017kdO_l5C0Go00A<oooo0d`4o`=<00?o00002@0000X000?ogml01ml01?oO
gol:g`;o2Ml01?oOgol:g`0coenOGimOWenOGiooWenOoimOWenOGimOWomnLGiaOW5nLGkoOW5nogia
OW5nLGiaOW7o00U<00GoC4a<o`09C003o`00014000GogmoOo`03g`03omoo00;O00GogmoOo`02g`03
omoO00;o1=l01ooOgmoogol00]l01OoOgmoo00;O03KogmoOoimOWonOGomOWonOGomOWeooGiooWenO
GomaOW5nLOmaOW7oLGiaog7oLGiaog5nLOl4C007oda<C?m<o`03C003odco00=<00GoC4a<o`0;0000
2P000ooOg`07g`Co2]l2o`WO1?l:g`0coenOGimOWenOGiooWenOoimOWenOGimOWoodO_Anm7kdO_Co
m7kdO_Anm7kdO_Anm7ko00U<00GoC4a<o`09C003o`00014000GogmoOo`05g`Co0ml00ooOg`03g`;o
1=l00ooOg`03g`Co0ml00ooOg`04g`0:oimOWonOGomOW`Co02AOWeooGimOWenOGomnm7kdO_mnm7ko
O_AnogkoO_AnogkdO_l4C007oda<C?m<o`03C003odco00=<00GoC4a<o`0;00002P000ooOg`0:g`03
omoO00SO0_l<g`03omoO00SO03?oGimOWenOGimOWonOGiooWenOGimOWenOogiaOW5nLGiaO_mnLGko
OW5nLGiaOW5nLOl02D`01Om<C4co00U<00?o00004@001OoOgmoo00?O00?ogml00]l01OoOgmoo00GO
0_l4g`05omoOgol01=l01OoOgmoo00KO03;oWenOoimOoenOGimOoenOGomOWenOGimOog5nLGiaog5n
LOmaOW7oLOmaOW7oLGiao`A<00OoC4a<odco00=<00?oC?l00d`01Om<C4co00/0000:0003omoO00SO
0ol:g`;o2]l3o`[O00_oGimOWenOGimOW`04o`0EGimOWenOGimOWoodO_Anm7kdO_An00Co00_dO_An
m7kdO_Ano`0:C0Co2D`00ol0000A0003omoO00;O1?l2g`?o0]l4o`?O0_l5g`Co0]l3o`;O1?l4g`04
oimOW`Co00=OWel00ol00enOo`03o`0@GimOWeooO_Anm7koO_Anm0?o00?dO_@01Ol00oAno`05C0Co
0T`3o`=<1Ol2C003o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGiooWenOGimOWenOGimO
WomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o00e<00?oC4`01d`00ol0000A0003omoO00kO00?ogml0
0ml2oa7O00?ogml01=l0<_nOGiooWenOGimOWenOGimOoenOGimOWeooLGiaOW7oLGiaOW5nLGiaOW5n
LGiaOW7o24`00om<C00=C003o`0000T0000:0003omoO01GO0_lGg`0:oenOGimOWenOG`;o02NOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l034`2o`U<00?o00004@000ooOg`0>g`03
omoO00?O0_lAg`03omoO00CO00?oWel00_l069mOWenOGimOWenOGomOWenOGimOogkdOP?o019nm7kd
O_Anm7kdO_Anm7kdO_l7C0;o3d`00ol0000900002P000ooOg`0Eg`;o5ml0<omOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?ogml05=l2oaSO
03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o0000
2@0000X000?ogml05Ml2oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_An
m7kdO_Anm7kdO_l05d`00ol0000A0003omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0000:0003omoO01GO0_lGg`0coenOGimO
WenOGimOWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o01M<00?o00004@000ooO
g`0Dg`;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
64`00ol0000900002P000ooOg`0Eg`;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?ogml05Ml2oaOO
03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0
000A0003omoO01CO0_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlHC003o`0000T0000:0003omoO01GO0_lGg`0coenOGimOWenOGimOWenOGimOWenOGimO
WoodO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko01M<00?o00004@000ooOg`0Dg`;o6=l0<_nOGimOWenO
GimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ooO
g`0Eg`;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?ogml05=l2oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5n
LGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000T0OOlB07go2`0000T0OOlB07go2`0000X000?o0000
5003oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l0
5d`00ol0000A0003o`0001@00_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kd
O_Anm7kdO_Anm7kdO_lHC003o`0000T0000:0003o`0001<000Co0?oo5ml0<omOWenOGimOWenOGimO
WenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000?o00004`03oaSO
03;oWenOGimOWenOGimOWenOGimOWenOGimOog5nLGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o0000
2@0000X000?o00004P000ol00002oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAnm7kdO_An
m7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003o`00018000Co0?oo6=l0<_nOGimOWenOGimOWenO
GimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kdO_Anm7ko64`00ol0000900002P000ol0000A0004
o`0000;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?o00004@000ol00002oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOog5n
LGiaOW5nLGiaOW5nLGiaOW5nLGiaoaQ<00?o00002@0000X000?o000040000ol0000200;o5ml0<omO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`000140
00?o000040001?l00002oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkdO_Anm7kdO_Anm7kd
O_Anm7kdO_AnoaQ<00?o00002@0000X000?o00000P02o`030?oo00P000?o00000`02oaOO03?oGimO
WenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003
o`0000800_l00`3oo`080003o`0000800_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5n
LGiaOW5nLGiaOW5nLGiaOW5nLOlHC003o`0000T0000:0003o`0000<000?o0?l020000ol0000400;o
5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003
o`00014000?o00000`000ol0o`080003o`0000<00_lHg`0boimOWenOGimOWenOGimOWenOGimOWenO
Gomnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_lHC003o`0000T0000:0003o`0000@000?o00001P000ol0
000500;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGia
o`0GC003o`00014000?o000010000ol000060003o`0000@00_lHg`0ZoimOWenOGimOWenOGimOWenO
GimOWenOGomaOW5nLGiaOW5nLGiaOW5n0ol01GiaOW7o015<0ol4C003o`0000T0000:0003o`0000<0
00?o0?l01P000ol0000600;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_An
m7kdO_Anm7kdO_Ano`0GC003o`00014000?o00000`000ol0o`060003o`0000D00_lHg`0boimOWenO
GimOWenOGimOWenOGimOWenOGomnm7kdO_Anm7kdO_Anm7kdO_AnogkdO_lDC005oda<C?l02`0000X0
00?o00000P02o`030?oo00@000?o00001`02o`WO1Ol9g`0;oenOGimOWenOGil01?l05EnOGimOWenO
GiooOW5nLGiaOW5nL@03o`0<LGiaOW5nLGiaOW7o2T`5o`Q<00?o00004@000ol0000200;o00<0ool0
10000ol0000600;o1Ml3o`;O1Ol2g`?o1=l01?nOGil2o`04GoooW`Go00>OGol00_l02EnOGimOog5n
L@05o`03LGko00;o00=nLGh01?l0175nLOl5C0Go00A<oooo0d`4o`=<00?o00002@0000X000?o0000
2P000ol0000800;o2Ml01?oOgol:g`0coenOGimOWenOGiooWenOoimOWenOGimOWoodO_Anm7kdO_Co
m7kdooAnm7kdO_Anm7ko00U<00GoC4a<o`09C003o`00014000?o00002P000ol0000700;o1=l01ooO
gmoogol00]l01OoOgmoo00;O03KogmoOoimOWonOGomOWonOGomOWeooGiooWenOGomnm7kdO_mnm7ko
O_AnogkoO_AnogkdO_l4C007oda<C?m<o`03C003odco00=<00GoC4a<o`0;00002P000ol000090003
o`0000T00_l9g`Co2]l0<omOWenOGimOWenOoimOWonOGimOWenOGiooOW5nLGiaOW5nogiaOW5nLGia
OW5nLGiao`09C005oda<C?l02D`00ol0000A0003o`0000T000?o00002002o`CO00?ogml00ml4o`?O
00?ogml01=l02_nOGiooWeooGil4o`0TGimOoenOGimOWeooLGiaOW7oLGiaog5nLOmaog5nLOmaOW7o
14`01om<C4coC?l00d`00om<o`03C005oda<C?l02`0000X000?o000020001?l00003o`H00_l<g`03
omoO00SO03?oGimOWenOGimOWonOGiooWenOGimOWenOooAnm7kdO_Anm?odO_Com7kdO_Anm7kdO_l0
2D`01Om<C4co00U<00?o00004@000ol000080004o`0000?o1@02o`CO00GogmoOo`04g`05omoOgol0
1]l0<_nOGiooWeooGimOWeooGimOoenOGimOWeooO_Anm7koO_AnogkdO_mnogkdO_mnm7ko14`01om<
C4coC?l00d`00om<o`03C005oda<C?l02`0000X000?o00001`000ol000030003o`0000D00_l:g`?o
2]l02omOWenOGimOWenO00Co01EOWenOGimOWenOogiaOW5nLGiaOW401?l02giaOW5nLGiaOW7o00Y<
1?l9C003o`00014000?o00001`000ol000030003o`0000@00_l5g`Co0]l3o`;O1?l4g`04oimOW`Co
00=OWel00ol00enOo`03o`0@GimOWeooLGiaOW7oLGiaOP?o00=nLGh01Ol00giao`05C0Co0T`3o`=<
1Ol2C003o`0000T0000:0003o`0000H000?o00001@000ol0000400;o5ml0<omOWenOGimOWenOoimO
WenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0=C003oda<00M<00?o00004@000ol0
00060003o`0000D000?o00000`02oa7O00?ogml01=l0<_nOGiooWenOGimOWenOGimOoenOGimOWeoo
O_Anm7koO_Anm7kdO_Anm7kdO_Anm7ko24`00om<C00=C003o`0000T0000:0003o`0000D000?o0000
1P000ol0000400;o5ml02_mOWenOGimOWel2o`0WWenOGimOWenOGimOWomnLGiaOW5nLGiaOW5nLGia
OW5nLGiaOW7o00a<0_l9C003o`00014000?o00001@000ol000060003o`0000<00_lAg`03omoO00CO
00?oWel00_l069mOWenOGimOWenOGomOWenOGimOog5nL@?o019aOW5nLGiaOW5nLGiaOW5nLOl7C0;o
3d`00ol0000900002P000ol000040003o`0000H000?o0?l01@02oaOO03?oGimOWenOGimOWenOGimO
WenOGimOWenOooAnm7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A0003o`0000@000?o0000
1P000ol0o`0400;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooO_Anm7kdO_Anm7kdO_Anm7kd
O_Anm7ko64`00ol0000900002P000ol000030003o`0000L000?o0?l01@02oaOO03?oGimOWenOGimO
WenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0000A0003o`0000<0
00?o00001`000ol0o`0400;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5n
LGiaOW5nLGiaOW7o64`00ol0000900002P000ol000020003o`0000L00_l00`3oo`0400;o5ml0<omO
WenOGimOWenOGimOWenOGimOWenOGioom7kdO_Anm7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`000140
00?o00000P000ol0000700;o00<0ool00`02oaSO03;oWenOGimOWenOGimOWenOGimOWenOGimOogkd
O_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000Go0000o`0C00;o5ml0<omOWenOGimO
WenOGimOWenOGimOWenOGiooOW5nLGiaOW5nLGiaOW5nLGiaOW5nLGiao`0GC003o`00014000Go0000
o`0B00;o6=l0<_nOGimOWenOGimOWenOGimOWenOGimOWeooLGiaOW5nLGiaOW5nLGiaOW5nLGiaOW7o
64`00ol0000900002P001?l00?lD00;o5ml0<omOWenOGimOWenOGimOWenOGimOWenOGioom7kdO_An
m7kdO_Anm7kdO_Anm7kdO_Ano`0GC003o`00014000Co003o4`02oaSO03;oWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X000?o0?l05@02oaOO
03?oGimOWenOGimOWenOGimOWenOGimOWenOogiaOW5nLGiaOW5nLGiaOW5nLGiaOW5nLOl05d`00ol0
000A0003o`3o01@00_lHg`0boimOWenOGimOWenOGimOWenOGimOWenOGomaOW5nLGiaOW5nLGiaOW5n
LGiaOW5nLOlHC003o`0000T0000:00;o5P02oaOO03?oGimOWenOGimOWenOGimOWenOGimOWenOooAn
m7kdO_Anm7kdO_Anm7kdO_Anm7kdO_l05d`00ol0000A00;o5@02oaSO03;oWenOGimOWenOGimOWenO
GimOWenOGimOogkdO_Anm7kdO_Anm7kdO_Anm7kdO_AnoaQ<00?o00002@0000X0O?lC07co2`000280
0_n<00;oKP000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@0007d00on<00?o
4@0007h000?o0000S0000ol0000@00003002o`@00_l400;oB`02o`030?oo00T000?o0?l02@000ol0
000I00;o1002o`@00_m;00;o00<0ool02@000ol0o`090003o`0000l0000<00;o1002o`@00_m<0003
o`3o00/000?o000020000ol0000I00;o1002o`@00_m<0003o`3o00/000?o000020000ol0000?0000
I`000ol0000800Go1`000ol0o`1e0003o`0000P01Ol70003o`3o0100000=0003o`0000<000?o0000
0`000ol0001:0003o`3o00/000?o00001`000ol0o`0K0003o`0000<000?o00000`000ol0001:0003
o`3o00/000?o00001`000ol0o`0@00002`001?l00?l20004o`00o`8000Co003oBP02o`030?oo01<0
0_l00`3oo`0H0004o`00o`8000Co003o0P001?l00?m:00;o00<0ool04`02o`030?oo00l0000;00Co
0P04o`801?mo00Co0P04o`801?mf0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {149.812, 0}} -> {-0.0536619, -0.0261961, 
  0.0073426, 0.0073426}, {{7.25, 137}, {146.188, 
  3.5625}} -> {-1.42043, -0.28431, 0.0404912, 0.0404912}, {{149.938, 
  279.688}, {146.188, 3.5625}} -> {-7.19803, -0.28431, 0.0404912, 
  0.0404912}},
  CellTags->"Disguising"]
}, Open  ]],

Cell[TextData[{
  "5.4.5 A look at some functions in ",
  StyleBox["LabCode",
    FontFamily->"Courier"]
}], "Subsubsection",
  CellTags->{"LabCode", "i:37"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["CollectOrders",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox["Orders",
                  "MR"], 
                StyleBox["[",
                  "MR"], 
                StyleBox["G",
                  "TI"], 
                StyleBox["]",
                  "MR"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                StyleBox[\(given\ the\ output\ of\ the\ \),
                  SingleLetterItalics->False], 
                StyleBox["Orders",
                  "MR"], 
                StyleBox[" ",
                  SingleLetterItalics->False], 
                StyleBox["function",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["(",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["equivalently",
                    SingleLetterItalics->False], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[" ",
                    SingleLetterItalics->False], 
                  RowBox[{
                    StyleBox["OrderOfAllElements",
                      "MR"], 
                    
                    StyleBox[
                      \(), \ this\ function\ organizes\ the\ data\ in\ the\ 
                          form\ {\),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["p",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(, \ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["A",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\(}\ where\)\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["p",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ is\ one\ of\ the\ possible\ orders\ and\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["A",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ is\ the\ set\ of\ elements\ in\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["G",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\ with\ order\ \),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["p",
                        "TraditionalForm"],
                      "Text"]}]}]}]}]},
          {
            RowBox[{
              StyleBox["ShowGroupOrders",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["G",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              RowBox[{
                RowBox[{
                  RowBox[{
                    StyleBox[\(return\ a\ \),
                      SingleLetterItalics->False], 
                    StyleBox["ListPlot",
                      "MR"], 
                    StyleBox[\(\ showing\ pairs\ {\),
                      SingleLetterItalics->False], 
                    StyleBox[
                      FormBox["g",
                        "TraditionalForm"],
                      "Text"]}], 
                  StyleBox[",",
                    SingleLetterItalics->False], 
                  StyleBox[
                    FormBox[
                      RowBox[{" ", 
                        StyleBox["|",
                          SingleLetterItalics->False], " ", 
                        StyleBox["g",
                          SingleLetterItalics->False], 
                        StyleBox["|",
                          SingleLetterItalics->False]}],
                      "TraditionalForm"],
                    "Text"]}], 
                StyleBox["}",
                  SingleLetterItalics->False]}], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["a",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["bar",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["chart",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["indicating",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["how",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["many",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["elements",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["there",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["each",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["order",
                SingleLetterItalics->False]}]},
          {
            RowBox[{
              StyleBox["ShowColoredPermutation",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["p",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                
                StyleBox[
                  \(give\ a\ graphical\ illustration\ of\ the\ permutation\ 
                  \),
                  SingleLetterItalics->False], 
                FormBox["p",
                  "TraditionalForm"]}],
              "Text"]}
          }], NotebookDefault]], "DefinitionBox",
  CellTags->{"LabCode", "i:38"}],

Cell[TextData[{
  "Miscellaneous functions from ",
  StyleBox["LabCode",
    FontFamily->"Courier"],
  " that may be of interest."
}], "Caption",
  CellTags->"LabCode"],

Cell[TextData[{
  "This function organizes the data regarding the orders of the elements in ",
  
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[DoubleStruckCapitalZ]", "15"], TraditionalForm]]],
  "."
}], "MathCaption",
  CellTags->"LabCode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CollectOrders[Orders[Z[15]]]\)], "Input",
  CellLabel->"In[100]:=",
  CellTags->"LabCode"],

Cell[BoxData[
    \({{1, {0}}, {3, {5, 10}}, {5, {3, 6, 9, 12}}, {
        15, {1, 2, 4, 7, 8, 11, 13, 14}}}\)], "Output",
  CellLabel->"Out[100]="]
}, Open  ]],

Cell["\<\
Here are two graphical ways of considering the same question.\
\>", 
  "MathCaption",
  CellTags->"LabCode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ShowGroupOrders[Z[15]]; \)\)], "Input",
  CellLabel->"In[101]:=",
  CellTags->"LabCode"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.0666667 0 0.0412023 [
[.06667 -0.0125 -3 -9 ]
[.06667 -0.0125 3 0 ]
[.13333 -0.0125 -3 -9 ]
[.13333 -0.0125 3 0 ]
[.2 -0.0125 -3 -9 ]
[.2 -0.0125 3 0 ]
[.26667 -0.0125 -3 -9 ]
[.26667 -0.0125 3 0 ]
[.33333 -0.0125 -3 -9 ]
[.33333 -0.0125 3 0 ]
[.4 -0.0125 -3 -9 ]
[.4 -0.0125 3 0 ]
[.46667 -0.0125 -3 -9 ]
[.46667 -0.0125 3 0 ]
[.53333 -0.0125 -3 -9 ]
[.53333 -0.0125 3 0 ]
[.6 -0.0125 -3 -9 ]
[.6 -0.0125 3 0 ]
[.66667 -0.0125 -3 -9 ]
[.66667 -0.0125 3 0 ]
[.73333 -0.0125 -6 -9 ]
[.73333 -0.0125 6 0 ]
[.8 -0.0125 -6 -9 ]
[.8 -0.0125 6 0 ]
[.86667 -0.0125 -6 -9 ]
[.86667 -0.0125 6 0 ]
[.93333 -0.0125 -6 -9 ]
[.93333 -0.0125 6 0 ]
[1 -0.0125 -6 -9 ]
[1 -0.0125 6 0 ]
[-0.0125 .0412 -6 -4.5 ]
[-0.0125 .0412 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .12361 -6 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .12361 -6 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .20601 -6 -4.5 ]
[-0.0125 .20601 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[-0.0125 .61803 -12 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[.5 .63053 -15 0 ]
[.5 .63053 15 9 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.06667 0 m
.06667 .00625 L
s
[(0)] .06667 -0.0125 0 1 Mshowa
.13333 0 m
.13333 .00625 L
s
[(1)] .13333 -0.0125 0 1 Mshowa
.2 0 m
.2 .00625 L
s
[(2)] .2 -0.0125 0 1 Mshowa
.26667 0 m
.26667 .00625 L
s
[(3)] .26667 -0.0125 0 1 Mshowa
.33333 0 m
.33333 .00625 L
s
[(4)] .33333 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(5)] .4 -0.0125 0 1 Mshowa
.46667 0 m
.46667 .00625 L
s
[(6)] .46667 -0.0125 0 1 Mshowa
.53333 0 m
.53333 .00625 L
s
[(7)] .53333 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(8)] .6 -0.0125 0 1 Mshowa
.66667 0 m
.66667 .00625 L
s
[(9)] .66667 -0.0125 0 1 Mshowa
.73333 0 m
.73333 .00625 L
s
[(10)] .73333 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(11)] .8 -0.0125 0 1 Mshowa
.86667 0 m
.86667 .00625 L
s
[(12)] .86667 -0.0125 0 1 Mshowa
.93333 0 m
.93333 .00625 L
s
[(13)] .93333 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(14)] 1 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
0 .0412 m
.00625 .0412 L
s
[(1)] -0.0125 .0412 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(5)] -0.0125 .20601 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .12361 m
.00625 .12361 L
s
[(3)] -0.0125 .12361 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(5)] -0.0125 .20601 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(5)] -0.0125 .20601 1 0 Mshowa
0 .12361 m
.00625 .12361 L
s
[(3)] -0.0125 .12361 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .20601 m
.00625 .20601 L
s
[(5)] -0.0125 .20601 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(15)] -0.0125 .61803 1 0 Mshowa
0 0 m
0 .61803 L
s
[(Z[15])] .5 .63053 0 -1 Mshowa
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 0 1 r
.025 w
.06667 .0412 Mdot
.13333 .61803 Mdot
.2 .61803 Mdot
.26667 .20601 Mdot
.33333 .61803 Mdot
.4 .12361 Mdot
.46667 .20601 Mdot
.53333 .61803 Mdot
.6 .61803 Mdot
.66667 .20601 Mdot
.73333 .12361 Mdot
.8 .61803 Mdot
.86667 .20601 Mdot
.93333 .61803 Mdot
1 .61803 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[101]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0002L00_l>00?o3@04o`d0
0ol>00?o3@03o`h00_l?0003o`0000d00_l>00?o2P03o`@00_l800?o0`03o`L00ol300Co1`03o`<0
0ol700?o1003o``0000V0004o`00o`h000?o00003@000ol0000@0003o`0000`000?o00003`000ol0
000:0004o`00o`h000?o000030001?l00?l@0003o`0000P000?o00000P001?l00?l80003o`0000<0
00?o00001`000ol000030003o`0000P000?o00001@000ol000050003o`0000@000?o00002`0002H0
00Co003o3P000ol0000>0003o`0000l000?o00002P04oa0000?o00002P001?l00?l?0003o`0000/0
00Co003o3P03o`X000?o00000P001?l00?l80003o`0000<000?o00001`000ol000040003o`0000L0
00?o00001@000ol000050003o`0000801?l<00009P001?l00?l>0003o`0000l000?o00003002o`d0
00?o0?l03P03o`d00ol@0003o`0000`00_l>0004o`00o`X000?o00000P001?l00?l80003o`0000<0
00?o00001`000ol000050003o`0000H000?o00000`02o`P000?o00000P000ol0o`0=00009P001?l0
0?l>0003o`0000`000Co003o40000ol0000:0003o`3o00h000?o00003@000ol0000A0003o`0000X0
00Co003o3@001?l00?l:0003o`00008000Co003o20000ol000030003o`0000L000?o00000P001?l0
0?l80003o`0000D000?o00001@000ol000020003o`3o00d0000W00;o3P02o`l00_l>00?o3P02o`h0
1?l=00?o3@04o`d00_l?00;o2P02o`D00_l800;o1002o`P00_l500;o2002o`@00ol700;o1@02o`d0
003o0240003o0240003o0240003o0240000H0?So400001P000?o00003@000ol0000>0003o`0000d0
00?o00003P000ol0000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P000ol0
000=0003o`0000h000?o00003@000ol0000>0003o`0000d000?o00003P0001P000?o0000o`060000
60000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003
o`0000`014ce00004003o`D000?o00002`06C?@0000A0003o`0000@000?o00002`06C?@0000A0003
o`0000@00ol;00I<m000014000?o000010000ol0000;00I<m000014000?o000010000ol0000<00A<
m@0001000_l60003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l0
1P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`060000
60000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003
o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000@00?o1@000ol0001N00A<C`04C500
000C0003o`00008000?o0000G@06C4d01Ta?00004`000ol0000200?oG@06C4d01Ta?00004@02o`D0
00?o0000G@06C4d01Ta?00004`000ol000020003o`0005d01Ta=00I<C`0001000ol50003o`0005h0
14a?00A<D00001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000
o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0
000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P0
00?o0000o`06000060000ol0003o00H0000H0003o`0003d014`^00A<;@04C2h014`_00004003o`D0
00?o0000?006C2`01T`[00I<;006C2h0000C0003o`00008000?o0000?006C2`01T`[00I<;006C2h0
000C0003o`0000800oll00I<;006C2/01T`/00I<;P0001000ol50003o`0003`01T`/00I<:`06C2`0
1T`^000040000ol000050003o`0003d014`^00A<;@04C2h014`_00004004o`@000?o0000o`060000
60000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003
o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000
o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0
000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P0
00?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0
003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l0
1P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`060000
60000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003
o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000
o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0
000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P0
00?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0
003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l0
1P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`060000
60000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003
o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000
o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0
000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P0
00?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0
003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l0
1P0001P000?o0000o`06000060000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`060000
60000ol0003o00H0000H0003o`000?l01P0001P000?o0000o`06000060000ol0003o00H0000H0003
o`000?l01P0000X00ol300?o1@000ol0000L00A<3@04C1d014`]00A<3@04C2d014`M00A<3@04C0h0
000;0003o`0000D000?o00000P000ol0000K00I<2`06C1/01T`[00I<2`06C2/01T`K00I<2`06C0d0
000;0003o`0000D000?o00000P03oa/01T`;00I<6`06C2/01T`;00I<:`06C1/01T`;00I<3@0000/0
00?o00000P03ob<01T`;00I<6`06C2/01T`;00I<:`06C1/01T`;00I<3@0000/000?o00000P000ol0
000S00I<2`06C1/01T`[00I<2`06C2/01T`K00I<2`06C0d0000:00;o1004ob<014`=00A<7@04C2d0
14`=00A<;@04C1d014`=00A<3P0008d00_l@00;oO`0008d000?o000040000ol0001m0000QP04o`<0
00?o00000P03o`<00ol50003o`0007d000270003o`3o00<000?o00000`000ol000050003o`000080
00?o0000O@0008L000?o00000`000ol000030003o`0000D000?o00000P000ol0001m0000R0000ol0
00020003o`0000<000?o00000P03o`D000?o0000O@0008H000?o0?l010000ol000030003o`000080
00?o00001@000ol0001m0000QP04o`<00_l300;o1004o`<00_mo0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.48449, -1.18721, 
  0.0606876, 0.0981946}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.83983 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.21645 0 0.21645 [
[.24026 -0.0125 -3 -9 ]
[.24026 -0.0125 3 0 ]
[.45671 -0.0125 -3 -9 ]
[.45671 -0.0125 3 0 ]
[.67316 -0.0125 -3 -9 ]
[.67316 -0.0125 3 0 ]
[.88961 -0.0125 -6 -9 ]
[.88961 -0.0125 6 0 ]
[1.025 0 0 -4.5 ]
[1.025 0 36 4.5 ]
[.09789 .21645 -6 -4.5 ]
[.09789 .21645 0 4.5 ]
[.09789 .4329 -6 -4.5 ]
[.09789 .4329 0 4.5 ]
[.09789 .8658 -6 -4.5 ]
[.09789 .8658 0 4.5 ]
[.09789 1.7316 -6 -4.5 ]
[.09789 1.7316 0 4.5 ]
[.11039 1.86483 -27 0 ]
[.11039 1.86483 27 9 ]
[ 0 0 0 0 ]
[ 1 1.83983 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.24026 0 m
.24026 .00625 L
s
[(1)] .24026 -0.0125 0 1 Mshowa
.45671 0 m
.45671 .00625 L
s
[(3)] .45671 -0.0125 0 1 Mshowa
.67316 0 m
.67316 .00625 L
s
[(5)] .67316 -0.0125 0 1 Mshowa
.88961 0 m
.88961 .00625 L
s
[(15)] .88961 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
[(orders)] 1.025 0 -1 0 Mshowa
.11039 .21645 m
.11664 .21645 L
s
[(1)] .09789 .21645 1 0 Mshowa
.11039 .4329 m
.11664 .4329 L
s
[(2)] .09789 .4329 1 0 Mshowa
.11039 .8658 m
.11664 .8658 L
s
[(4)] .09789 .8658 1 0 Mshowa
.11039 1.7316 m
.11664 1.7316 L
s
[(8)] .09789 1.7316 1 0 Mshowa
.11039 0 m
.11039 1.83983 L
s
[(frequency)] .11039 1.86483 0 -1 Mshowa
0 0 m
1 0 L
1 1.83983 L
0 1.83983 L
closepath
clip
newpath
1 .75 0 r
.15368 0 m
.15368 .21645 L
.32684 .21645 L
.32684 0 L
F
0 g
.5 Mabswid
.15368 0 m
.15368 .21645 L
.32684 .21645 L
.32684 0 L
.15368 0 L
s
.5 1 0 r
.37013 0 m
.37013 .4329 L
.54329 .4329 L
.54329 0 L
F
0 g
.37013 0 m
.37013 .4329 L
.54329 .4329 L
.54329 0 L
.37013 0 L
s
0 1 1 r
.58658 0 m
.58658 .8658 L
.75974 .8658 L
.75974 0 L
F
0 g
.58658 0 m
.58658 .8658 L
.75974 .8658 L
.75974 0 L
.58658 0 L
s
1 0 0 r
.80303 0 m
.80303 1.7316 L
.97619 1.7316 L
.97619 0 L
F
0 g
.80303 0 m
.80303 1.7316 L
.97619 1.7316 L
.97619 0 L
.80303 0 L
s
[(1)] .24026 .30844 0 0 Mshowa
[(2)] .45671 .52489 0 0 Mshowa
[(4)] .67316 .95779 0 0 Mshowa
[(8)] .88961 1.82359 0 0 Mshowa
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[101]:=",
  ImageSize->{156.5, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002L000180P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0009`0002L0000W00009`0002L0000W00009`0
002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0
002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0
002L0000W00009`0002L0000W00002H00olC00?o4P03oa000ol300?o;`0002L000?o00005@000ol0
000B0003o`0000h000?o00001@000ol0000/00009`000ol0000E0003o`00018000?o00003P000ol0
00050003o`0002`0000W0003o`0001<00_lB00?o4@000ol0000200?o;`0002L000?o00005@000ol0
000?0003o`00014000?o00000P000ol0000_00009P02oa@00olB00Co3`02o`@01?l^0000N@03o`80
1?l300Go00<0ool00_l00`3oo`02o`801?l20000N0001Ol0003o008000?o00000P001ol0003o0?l0
1P000ol00005007o0@0100003`1Vo`<000Go0000o`020003o`00008000Ko0000o`05o`8000?o0000
0P04o`80000K000Fo`000?nOgioOWmnOgioOWmnOgioOo`@001;odMkAg]7NdMkAg]7NdMkAg_l40003
o`4100h100?o00000P000olO7`0>7`03o`0000<000Go0000o`0200;o0`001ol0003o0?l00`000ol0
0002o`<000?o00000`0001/000Go0000o`0@W`03o`00008001;odMkAg]7NdMkAg]7NdMkAg_l40003
o`4100h100?o00000P000olO7`0>7`03o`0000@00ol200;o00<0ool00P04o`800ol200;o00@0ool0
1?l200006`005_l0003oWmnOgioOWmnOgioOWmnOgol4000Bom7NdMkAg]7NdMkAg]7NdMko10000ol1
0@0>0@03o`00008000?o7al03Ql00ol0000C0003o`000140000K0005o`000?l049l00ol00002000B
om7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000B00;o4`0001/0
01Ko0000oioOWmnOgioOWmnOgioOWmoo10004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol0
00020003oalO00hO00?o00009`0001/000Go0000o`0@W`03o`00008001;odMkAg]7NdMkAg]7NdMkA
g_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K000Fo`000?nOgioOWmnOgioOWmnO
gioOo`@001;odMkAg]7NdMkAg]7NdMkAg_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000K0005o`000?l049l00ol00002000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`005_l0003oWmnOgioOWmnOgioOWmnOgol4000Bom7NdMkAg]7NdMkA
g]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`001Ol0003o012O00?o0000
0P004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o00009`0001/0
01Ko0000oioOWmnOgioOWmnOgioOWmoo10004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol0
00020003oalO00hO00?o00009`0001/000Go0000o`0@W`03o`00008001;odMkAg]7NdMkAg]7NdMkA
g_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K000Fo`000?nOgioOWmnOgioOWmnO
gioOo`@001;odMkAg]7NdMkAg]7NdMkAg_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000K0005o`000?l049l00ol00002000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`005_l0003oWmnOgioOWmnOgioOWmnOgol4000Bom7NdMkAg]7NdMkA
g]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`001Ol0003o012O00?o0000
0P004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o00009`0001/0
01Ko0000oioOWmnOgioOWmnOgioOWmoo10004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol0
00020003oalO00hO00?o00009`0001/000Go0000o`0@W`03o`00008001;odMkAg]7NdMkAg]7NdMkA
g_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K000Fo`000?nOgioOWmnOgioOWmnO
gioOo`@001;odMkAg]7NdMkAg]7NdMkAg_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000D00?o10001Ol0003o012O00?o00000P004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol0
00020003oalO00hO00?o00009`0001D000?o00000`005_l0003oWmnOgioOWmnOgioOWmnOgol4000B
om7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00005@000ol0
00030004o`0001;o10004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO
00?o00009`0001D000?o00000`000ol0000G000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03
o`00008000?o7al03Ql00ol0000W00005@000ol000030003o`0001L001;odMkAg]7NdMkAg]7NdMkA
g_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0000D00;o1@000ol0000G000Bom7NdMkA
g]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0000G000B
om7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0
000G000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W0000
6`000ol0000G000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al03Ql00ol0
000W00006`000ol0000G000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`00008000?o7al0
3Ql00ol0000W00006`000ol0000800?o30004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol0
00020003oalO00hO00?o00009`0001/000?o00002@000ol0000;000Bom7NdMkAg]7NdMkAg]7NdMko
10000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol000090003o`0000/001;odMkA
g]7NdMkAg]7NdMkAg_l40003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0000T0
00?o00002`004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o0000
9`0001/000?o00002@000ol0000;000Bom7NdMkAg]7NdMkAg]7NdMko10000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`000ol0000800;o3@004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@40
3P400ol000020003oalO00hO00?o00009`0001/000?o00005`004_oAg]7NdMkAg]7NdMkAg]7No`@0
00?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o00005`004_oAg]7NdMkAg]7NdMkA
g]7No`@000?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o00005`004_oAg]7NdMkA
g]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o00005`004_oA
g]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o0000
5`004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o00009`0001/0
00?o00005`004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@403P400ol000020003oalO00hO00?o0000
9`0001@01?l30003o`0001L001;odMkAg]7NdMkAg]7NdMkAg_l40003o`4100h100?o00000P000olO
7`0>7`03o`0002L0000E0003o`0000<000?o00005`004_oAg]7NdMkAg]7NdMkAg]7No`@000?o0@40
3P400ol000020003oalO00hO00?o00009`0001H000?o00000P000ol0000G01;o10000ol10@0>0@03
o`00008000?o7al03Ql00ol0000W00005`001Ol0003o02l000?o0@403P400ol000020003oalO00hO
00?o00009`0001@000Co003o0`000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000E00;o10000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d0
00?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o0000;@000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000K0003o`0001h01?l;0003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0001l0
00?o00002`000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0000P0003o`0000X0
00?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o00008@000ol000090003o`4100h1
00?o00000P000olO7`0>7`03o`0002L0000K0003o`0001h000Co003o2`000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`000ol0000O00;o30000ol10@0>0@03o`00008000?o7al03Ql00ol0
000W00006`000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d0
00?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o0000;@000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000K0003o`0002d000?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o0000;@000ol1
0@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h100?o00000P000olO
7`0>7`03o`0002L0000K0003o`0002d000?o0@403P400ol000020003oalO00hO00?o00009`0001/0
00?o0000;@000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h1
00?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d000?o0@403P400ol000020003oalO00hO
00?o00009`0001/000?o0000;@000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0
000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d000?o0@403P400ol0
00020003oalO00hO00?o00009`0001/000?o0000;@000ol10@0>0@03o`00008000?o7al03Ql00ol0
000W00006`000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d0
00?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o0000;@000ol10@0>0@03o`000080
00?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000K0003o`0002d000?o0@403P400ol000020003oalO00hO00?o00009`0001/000?o0000;@000ol1
0@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h100?o00000P000olO
7`0>7`03o`0002L0000K0003o`0002d000?o0@403P400ol000020003oalO00hO00?o00009`0001/0
00?o0000;@000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0000]0003o`4100h1
00?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d000?o0@403P400ol000020003oalO00hO
00?o00009`0001/000?o0000;@000ol10@0>0@03o`00008000?o7al03Ql00ol0000W00006`000ol0
000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0000K0003o`0002d000?o0@403P400ol0
00020003oalO00hO00?o00009`0001D00ol30003o`0002d000?o0@403P400ol000020003oalO00hO
00?o00009`0001H000?o00000P000ol0000]0003o`4100h100?o00000P000olO7`0>7`03o`0002L0
000D00Co0`000ol0000]01;o10000olO7`0>7`03o`0002L0000D0003o`3o00@000?o0000@`000olO
7`0>7`03o`0002L0000D0003o`3o00@000?o0000@`000olO7`0>7`03o`0002L0000E00;o10000ol0
00130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<0
00?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000=003o``0
00?o7al03Ql00ol0000W00006`000ol0000e0003o`0000/000?o7al03Ql00ol0000W00006`000ol0
000c00Co30000olO7`0>7`03o`0002L0000K0003o`0003<000?o0?l03@000olO7`0>7`03o`0002L0
000K0003o`0003<000?o0?l03@000olO7`0>7`03o`0002L0000K0003o`0003@00_l=0003oalO00hO
00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0
000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0
000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/0
00?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol0
00130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<0
00?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO
7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO
00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0
000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0
000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/0
00?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol0
00130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<0
00?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO
7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO
00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0
000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0
000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/0
00?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol0
00130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<0
00?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO
7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO
00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0
000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0
000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/0
00?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol0
00130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<0
00?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO
7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO
00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0
000W00006`000ol000130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0
000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001/0
00?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<000?o7al03Ql00ol0000W00006`000ol0
00130003oalO00hO00?o00009`0001/000?o0000@`000olO7`0>7`03o`0002L0000K0003o`0004<0
00?o7al03Ql00ol0000W00006`000ol000130003oalO00hO00?o00009`0001D00_l40003o`0004<0
00?o7al03Ql00ol0000W000050001?l00?l30003o`0004<000?o7al03Ql00ol0000W000050001?l0
0?l30003o`0004<04_lY00005@02o`@000?o0000OP0001@000Co003o0`000ol0001n00005@02o`@0
00?o0000OP0001/000?o0000OP0001/000?o0000OP0001/000?o0000OP0001/000?o0000OP0001/0
00?o0000BP02oc80000K0003o`0004T000Co003o<@0001/000?o0000B@001?l00?la00006`000ol0
001:00;o<P0006L000Co003o<@0006P00_lb0000W00001D01?lG00?oJ@0001L000?o00005`000ol0
001X000000<0ool00_l200Co0`04o`801?l00`3oo`03o`801?l0103oo`02o`800ol30003o`0006L0
00020003o`0000<000?o00000P000ol000030007o`000?l0o`020004o`00o`D000Co003o0P001Ol0
003o008000?o0000I`00008000?o00000`000ol0000200Go00<0o`000P000ol0o`020003o`0000Go
00D0o`00o`020003o`0000<000?o0?l0J000008000?o00000`02o`<000Oo0000o`3o00<000?o0?l0
0P001?l00?l30003o`3o008000Co003o0`001Ol0o`3o06P000000`3oo`02o`800_l00`3oo`0200?o
0`06o`030?oo00<00ol00`3oo`03o`<01_l00`3oo`1W00000P000ol0002G00000P03oiL0002L0000
W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000
W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000W00009`0002L0000
W00009`0002L0000W00009`0002L0000W00009`00000\
\>"],
  ImageRangeCache->{{{0, 155.5}, {287, 0}} -> {-0.833421, -2.27642, 
  0.0456816, 0.0456816}}]
}, Open  ]]
}, Open  ]],

Cell["5.4.6 Potpourri", "Subsubsection",
  CellTags->"Potpourri"],

Cell[BoxData[
    FormBox[GridBox[{
          {
            RowBox[{
              StyleBox["GaussianIntegerQ",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["z",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            StyleBox[
              RowBox[{
                StyleBox[\(give\ \),
                  SingleLetterItalics->False], 
                StyleBox["True",
                  "MR"], 
                StyleBox[\(\ if\ the\ complex\ number\ \),
                  SingleLetterItalics->False], 
                FormBox["z",
                  "TraditionalForm"], 
                
                StyleBox[\(\ 
                  is\ a\ Gaussian\ integer\ 
                    \((real\ and\ imaginary\ parts\ are\ integers)\), \ and\ 
                  \),
                  SingleLetterItalics->False], 
                StyleBox["False",
                  "MR"], 
                StyleBox[\(\ otherwise\),
                  SingleLetterItalics->False]}],
              "Text"]},
          {
            RowBox[{
              StyleBox["ComplexToPoint",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["z",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(given\ a\ complex\ number\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[\(z, \),
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["return",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              RowBox[{
                StyleBox["{",
                  SingleLetterItalics->False], 
                RowBox[{
                  StyleBox["Re",
                    "MR"], 
                  StyleBox["[",
                    "Text"], 
                  RowBox[{
                    StyleBox[
                      FormBox["z",
                        "TraditionalForm"],
                      "Text"], 
                    StyleBox[\(\(], \)\ \),
                      SingleLetterItalics->False], 
                    RowBox[{
                      StyleBox["Im",
                        "MR"], 
                      StyleBox["[",
                        "Text"], 
                      RowBox[{
                        StyleBox[
                          FormBox["z",
                            "TraditionalForm"],
                          "Text"], 
                        StyleBox[\(]}\),
                          SingleLetterItalics->False]}]}]}]}]}]}]},
          {
            RowBox[{
              StyleBox["IntegerLatticeGrid",
                "MR"], 
              StyleBox["[",
                "MR"], 
              RowBox[{
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"a", 
                        StyleBox[",",
                          "MR"], " ", "b"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox[
                  FormBox[
                    RowBox[{
                      StyleBox["{",
                        "MR"], 
                      RowBox[{"c", 
                        StyleBox[",",
                          "MR"], " ", "d"}], 
                      StyleBox["}",
                        "MR"]}],
                    "TraditionalForm"],
                  "TI"], 
                StyleBox[",",
                  "MR"], " ", 
                StyleBox["opts",
                  "TI"]}], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ a\ \),
                SingleLetterItalics->False], 
              StyleBox["ListPlot",
                "MR"], 
              StyleBox[\(\ of\ an\ integer\ lattice\ with\ domain\ \),
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["a",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["\[LessEqual]",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["x",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["\[LessEqual]",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["b",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"]}],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[" ",
                "Text",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox[
                FormBox[
                  RowBox[{
                    StyleBox["c",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["\[LessEqual]",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["y",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox[" ",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"], 
                    StyleBox["\[LessEqual]",
                      SingleLetterItalics->False], 
                    StyleBox[" ",
                      SingleLetterItalics->False], 
                    StyleBox["d",
                      SingleLetterItalics->False,
                      FontSlant->"Italic"]}],
                  "TraditionalForm"],
                "Text"], 
              StyleBox[\(\ with\ options\ \),
                SingleLetterItalics->False], 
              StyleBox["opts",
                FontSlant->"Italic"], 
              StyleBox[\(\ to\ be\ used\ by\ \),
                SingleLetterItalics->False], 
              StyleBox["ListPlot",
                "MR"]}]},
          {
            RowBox[{
              StyleBox["ESG",
                "MR"], 
              StyleBox["[",
                "MR"], 
              StyleBox["code",
                "TI"], 
              StyleBox["]",
                "MR"]}], 
            RowBox[{
              StyleBox[\(return\ the\ group\ corresponding\ to\ \),
                SingleLetterItalics->False], 
              StyleBox["code",
                FontSlant->"Italic"], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["as",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["found",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["in",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["the",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["Exploring",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["Small",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], 
              StyleBox["Groups",
                FontSlant->"Italic"], 
              StyleBox[" ",
                FontSlant->"Italic"], "software", " ", "package"}]}
          }], NotebookDefault]], "DefinitionBox",
  GridBoxOptions->{ColumnWidths->{0.34, 0.66}},
  CellTags->{"Potpourri", "i:39"}],

Cell["Miscellaneous functions.", "Caption",
  CellTags->"Potpourri"],

Cell["\<\
A complex number is a Gaussian integer if its real and imaginary \
parts are integers.\
\>", "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[GaussianIntegerQ, \ 
      nums\  = {3, \ 3 - 2  I, \ 3.5\  + \ 4.3  I, \ \(-8\) I}]\)], "Input",
  CellLabel->"In[102]:=",
  CellTags->"Potpourri"],

Cell[BoxData[
    \({True, True, False, True}\)], "Output",
  CellLabel->"Out[102]=",
  CellTags->"Potpourri"]
}, Open  ]],

Cell["\<\
Here are the real and imaginary parts of each of these \
numbers.\
\>", "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[ComplexToPoint, \ nums]\)], "Input",
  CellLabel->"In[103]:=",
  CellTags->"Potpourri"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\({3, 0}\), ",", \({3, \(-2\)}\), ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["3.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], ",", 
            StyleBox["4.29999999999999982`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2]}], "}"}], ",", \({0, \(-8\)}\)}], "}"}]], 
  "Output",
  CellLabel->"Out[103]=",
  CellTags->"Potpourri"]
}, Open  ]],

Cell[TextData[{
  "Here is a call to ",
  StyleBox["IntegerLatticeGrid", "MR"],
  " with some options added."
}], "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(IntegerLatticeGrid[{0, 8}, {0, 3}, Axes \[Rule] None, 
      AspectRatio \[Rule] Automatic, 
      Prolog \[Rule] {PointSize[0.02], RGBColor[1, 0, 0]}]; \)\)], "Input",
  CellLabel->"In[104]:=",
  CellTags->"Potpourri"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .375 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.119048 0.00892857 0.119048 [
[ 0 0 0 0 ]
[ 1 .375 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .375 L
0 .375 L
closepath
clip
newpath
1 0 0 r
.02 w
.02381 .00893 Mdot
.02381 .12798 Mdot
.02381 .24702 Mdot
.02381 .36607 Mdot
.14286 .00893 Mdot
.14286 .12798 Mdot
.14286 .24702 Mdot
.14286 .36607 Mdot
.2619 .00893 Mdot
.2619 .12798 Mdot
.2619 .24702 Mdot
.2619 .36607 Mdot
.38095 .00893 Mdot
.38095 .12798 Mdot
.38095 .24702 Mdot
.38095 .36607 Mdot
.5 .00893 Mdot
.5 .12798 Mdot
.5 .24702 Mdot
.5 .36607 Mdot
.61905 .00893 Mdot
.61905 .12798 Mdot
.61905 .24702 Mdot
.61905 .36607 Mdot
.7381 .00893 Mdot
.7381 .12798 Mdot
.7381 .24702 Mdot
.7381 .36607 Mdot
.85714 .00893 Mdot
.85714 .12798 Mdot
.85714 .24702 Mdot
.85714 .36607 Mdot
.97619 .00893 Mdot
.97619 .12798 Mdot
.97619 .24702 Mdot
.97619 .36607 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[104]:=",
  ImageSize->{288, 108},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000K0P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@0000H00alO00<O7`037al00alO00<O
7`037al00alO00<O7`037`L0000500DO7@057ad01AlM00DO7@057ad01AlM00DO7@057ad01Al60000
1@057ad01AlM00DO7@057ad01AlM00DO7@057ad01AlM00DO1P0000D01AlM00DO7@057ad01AlM00DO
7@057ad01AlM00DO7@057`H0000600<O7`037al00alO00<O7`037al00alO00<O7`037al00al70000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q00001P037al0
0alO00<O7`037al00alO00<O7`037al00alO00<O1`0000D01AlM00DO7@057ad01AlM00DO7@057ad0
1AlM00DO7@057`H0000500DO7@057ad01AlM00DO7@057ad01AlM00DO7@057ad01Al600001@057ad0
1AlM00DO7@057ad01AlM00DO7@057ad01AlM00DO1P0000H00alO00<O7`037al00alO00<O7`037al0
0alO00<O7`037`L0003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240000600<O7`037al00alO00<O7`037al00alO00<O7`037al00al700001@057ad01AlM00DO
7@057ad01AlM00DO7@057ad01AlM00DO1P0000D01AlM00DO7@057ad01AlM00DO7@057ad01AlM00DO
7@057`H0000500DO7@057ad01AlM00DO7@057ad01AlM00DO7@057ad01Al600001P037al00alO00<O
7`037al00alO00<O7`037al00alO00<O1`000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@000?l08@000?l08@000?l08@0000H00alO00<O7`037al00alO00<O7`037al00alO00<O
7`037`L0000500DO7@057ad01AlM00DO7@057ad01AlM00DO7@057ad01Al600001@057ad01AlM00DO
7@057ad01AlM00DO7@057ad01AlM00DO1P0000D01AlM00DO7@057ad01AlM00DO7@057ad01AlM00DO
7@057`H00000\
\>"],
  ImageRangeCache->{{{0, 287}, {107, 0}} -> {-0.224574, -0.0750155, 
  0.0294395, 0.0294395}},
  CellTags->"Potpourri"]
}, Open  ]],

Cell[TextData[{
  "Here are the two groups of order 4 given by the codes 0401 and 0402 used \
in the program ",
  StyleBox["Exploring Small Groups",
    FontSlant->"Italic"],
  ", written by Ladnor Geissinger."
}], "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{

Cell[BoxData[
    \({ESG[0401], ESG[0402]}\)], "Input",
  CellLabel->"In[105]:=",
  CellTags->"Potpourri"],

Cell[BoxData[
    \({Groupoid[{0, 1, 2, 3}, Mod[#1 + #2, 4]&], 
      Groupoid[{1, Rot, Ref, Rot**Ref}, "-Operation-"]}\)], "Output",
  CellLabel->"Out[105]=",
  CellTags->"Potpourri"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"Working",
WindowSize->{500, 400},
WindowMargins->{{14, Automatic}, {Automatic, 2}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Global"->{
    Cell[2564, 83, 199, 8, 91, "Section",
      Evaluatable->False,
      CellTags->"Global"],
    Cell[2766, 93, 194, 5, 46, "Text",
      CellTags->"Global"],
    Cell[3748, 136, 85, 1, 56, "Subsection",
      CellTags->{"Global", "i:1"}],
    Cell[3836, 139, 118, 4, 30, "Text",
      CellTags->"Global"],
    Cell[3957, 145, 4901, 137, 247, "DefinitionBox3Col",
      CellTags->{"Global", "i:2"}],
    Cell[8861, 284, 63, 1, 14, "Caption",
      CellTags->"Global"],
    Cell[8927, 287, 806, 16, 130, "DefinitionBox",
      CellTags->"Global"],
    Cell[9736, 305, 117, 5, 14, "Caption",
      CellTags->"Global"],
    Cell[9856, 312, 118, 4, 28, "MathCaption",
      CellTags->"Global"],
    Cell[9999, 320, 95, 3, 27, "Input",
      CellTags->"Global"],
    Cell[10097, 325, 85, 3, 26, "Output",
      CellTags->"Global"],
    Cell[10197, 331, 244, 5, 58, "MathCaption",
      CellTags->"Global"],
    Cell[10466, 340, 103, 3, 27, "Input",
      CellTags->"Global"],
    Cell[10572, 345, 85, 3, 26, "Output",
      CellTags->"Global"],
    Cell[10672, 351, 179, 5, 43, "MathCaption",
      CellTags->"Global"],
    Cell[10876, 360, 123, 3, 27, "Input",
      CellTags->"Global"],
    Cell[11002, 365, 75522, 1311, 296, 7864, 470, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Global"],
    Cell[86527, 1678, 209, 4, 41, "Output",
      CellTags->"Global"],
    Cell[86751, 1685, 269, 8, 57, "MathCaption",
      CellTags->"Global"],
    Cell[87045, 1697, 180, 5, 43, "Input",
      CellTags->"Global"],
    Cell[87228, 1704, 56877, 951, 296, 5278, 308, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Global"],
    Cell[144108, 2657, 176, 5, 26, "Output",
      CellTags->"Global"],
    Cell[144299, 2665, 171, 5, 44, "MathCaption",
      CellTags->"Global"],
    Cell[144495, 2674, 324, 7, 91, "Input",
      CellTags->"Global"],
    Cell[144822, 2683, 52041, 1437, 159, 16536, 992, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Global"],
    Cell[196866, 4122, 181, 5, 26, "Output",
      CellTags->"Global"]},
  "First"->{
    Cell[2963, 100, 60, 1, 56, "Subsection",
      CellTags->"First"],
    Cell[3026, 103, 178, 5, 47, "Text",
      CellTags->"First"],
    Cell[3207, 110, 146, 4, 27, "Input",
      CellTags->"First"],
    Cell[3356, 116, 163, 5, 47, "Text",
      CellTags->"First"],
    Cell[3544, 125, 102, 3, 27, "Input",
      CellTags->"First"],
    Cell[3649, 130, 84, 3, 26, "Output",
      CellTags->"First"]},
  "i:1"->{
    Cell[3748, 136, 85, 1, 56, "Subsection",
      CellTags->{"Global", "i:1"}]},
  "i:2"->{
    Cell[3957, 145, 4901, 137, 247, "DefinitionBox3Col",
      CellTags->{"Global", "i:2"}]},
  "PermIntroduction"->{
    Cell[197062, 4130, 103, 1, 56, "Subsection",
      CellTags->{"PermIntroduction", "i:3"}],
    Cell[197168, 4133, 75, 1, 48, "Subsubsection",
      CellTags->"PermIntroduction"],
    Cell[197246, 4136, 1069, 32, 113, "Text",
      CellTags->"PermIntroduction"],
    Cell[198318, 4170, 529, 19, 42, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[198872, 4193, 122, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[198997, 4198, 102, 3, 26, "Output",
      CellTags->"PermIntroduction"],
    Cell[199114, 4204, 248, 6, 57, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[199387, 4214, 116, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[199506, 4219, 249, 8, 52, "Output",
      CellTags->"PermIntroduction"],
    Cell[199770, 4230, 359, 10, 56, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[200154, 4244, 122, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[200279, 4249, 96, 3, 26, "Output",
      CellTags->"PermIntroduction"],
    Cell[200390, 4255, 324, 7, 64, "Text",
      CellTags->"PermIntroduction"],
    Cell[200717, 4264, 267, 7, 44, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[201009, 4275, 145, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[201157, 4280, 654, 11, 161, "Output",
      CellTags->"PermIntroduction"],
    Cell[201826, 4294, 2350, 73, 105, "DefinitionBox",
      CellTags->{"PermIntroduction", "i:4"}],
    Cell[204179, 4369, 232, 7, 26, "Caption",
      CellTags->"PermIntroduction"],
    Cell[204414, 4378, 343, 10, 57, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[204782, 4392, 142, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[204927, 4397, 100, 3, 26, "Output",
      CellTags->"PermIntroduction"],
    Cell[205042, 4403, 189, 5, 43, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[205256, 4412, 121, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[205380, 4417, 100, 3, 26, "Output",
      CellTags->"PermIntroduction"],
    Cell[205495, 4423, 226, 9, 28, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[205746, 4436, 120, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[205869, 4441, 100, 3, 26, "Output",
      CellTags->"PermIntroduction"],
    Cell[205984, 4447, 95, 1, 28, "MathCaption",
      CellTags->"PermIntroduction"],
    Cell[206104, 4452, 120, 3, 27, "Input",
      CellTags->"PermIntroduction"],
    Cell[206227, 4457, 95, 3, 26, "Output",
      CellTags->"PermIntroduction"]},
  "i:3"->{
    Cell[197062, 4130, 103, 1, 56, "Subsection",
      CellTags->{"PermIntroduction", "i:3"}]},
  "i:4"->{
    Cell[201826, 4294, 2350, 73, 105, "DefinitionBox",
      CellTags->{"PermIntroduction", "i:4"}]},
  "PermOperations"->{
    Cell[206337, 4463, 92, 1, 48, "Subsubsection",
      CellTags->{"PermOperations", "i:5"}],
    Cell[206432, 4466, 938, 32, 115, "Text",
      CellTags->"PermOperations"],
    Cell[207373, 4500, 5722, 159, 146, "DefinitionBox",
      CellTags->{"PermOperations", "i:6"}],
    Cell[213098, 4661, 92, 1, 14, "Caption",
      CellTags->"PermOperations"],
    Cell[213193, 4664, 143, 4, 42, "MathCaption",
      CellTags->"PermOperations"],
    Cell[213361, 4672, 153, 4, 43, "Input",
      CellTags->"PermOperations"],
    Cell[213517, 4678, 129, 3, 26, "Output",
      CellTags->"PermOperations"],
    Cell[213661, 4684, 593, 21, 58, "MathCaption",
      CellTags->"PermOperations"],
    Cell[214279, 4709, 132, 3, 27, "Input",
      CellTags->"PermOperations"],
    Cell[214414, 4714, 357, 10, 42, "Output",
      CellTags->"PermOperations"],
    Cell[214786, 4727, 381, 12, 57, "MathCaption",
      CellTags->"PermOperations"],
    Cell[215192, 4743, 116, 3, 27, "Input",
      CellTags->"PermOperations"],
    Cell[215311, 4748, 113, 3, 26, "Output",
      CellTags->"PermOperations"],
    Cell[215439, 4754, 185, 4, 42, "MathCaption",
      CellTags->"PermOperations"],
    Cell[215649, 4762, 163, 4, 43, "Input",
      CellTags->"PermOperations"],
    Cell[215815, 4768, 113, 3, 26, "Output",
      CellTags->"PermOperations"],
    Cell[215943, 4774, 357, 9, 72, "MathCaption",
      CellTags->"PermOperations"],
    Cell[216325, 4787, 263, 5, 59, "Input",
      CellTags->"PermOperations"],
    Cell[216591, 4794, 111, 2, 22, "Print",
      CellTags->"PermOperations"],
    Cell[216705, 4798, 179, 4, 22, "Print",
      CellTags->"PermOperations"],
    Cell[216887, 4804, 76, 2, 22, "Print",
      CellTags->"PermOperations"],
    Cell[216966, 4808, 278, 6, 22, "Print",
      CellTags->"PermOperations"],
    Cell[217247, 4816, 81, 2, 22, "Print",
      CellTags->"PermOperations"],
    Cell[217331, 4820, 278, 6, 22, "Print",
      CellTags->"PermOperations"],
    Cell[217612, 4828, 70, 2, 22, "Print",
      CellTags->"PermOperations"],
    Cell[217685, 4832, 104, 3, 26, "Output",
      CellTags->"PermOperations"],
    Cell[217804, 4838, 178, 4, 46, "Text",
      CellTags->"PermOperations"],
    Cell[217985, 4844, 11462, 308, 193, "DefinitionBox",
      CellTags->{"PermOperations", "i:7"}],
    Cell[229450, 5154, 73, 1, 14, "Caption",
      CellTags->"PermOperations"],
    Cell[229526, 5157, 241, 6, 43, "MathCaption",
      CellTags->"PermOperations"],
    Cell[229792, 5167, 271, 6, 66, "Input",
      CellTags->"PermOperations"],
    Cell[230066, 5175, 675, 17, 135, "Output",
      CellTags->"PermOperations"]},
  "i:5"->{
    Cell[206337, 4463, 92, 1, 48, "Subsubsection",
      CellTags->{"PermOperations", "i:5"}]},
  "i:6"->{
    Cell[207373, 4500, 5722, 159, 146, "DefinitionBox",
      CellTags->{"PermOperations", "i:6"}]},
  "i:7"->{
    Cell[217985, 4844, 11462, 308, 193, "DefinitionBox",
      CellTags->{"PermOperations", "i:7"}]},
  "PermRepresent"->{
    Cell[230756, 5195, 94, 1, 48, "Subsubsection",
      CellTags->{"PermRepresent", "i:8"}],
    Cell[230853, 5198, 409, 15, 46, "Text",
      CellTags->"PermRepresent"],
    Cell[231265, 5215, 8778, 223, 112, "DefinitionBox",
      CellTags->{"PermRepresent", "i:9"}],
    Cell[240046, 5440, 91, 1, 14, "Caption",
      CellTags->"PermRepresent"],
    Cell[240140, 5443, 153, 4, 42, "MathCaption",
      CellTags->"PermRepresent"],
    Cell[240318, 5451, 142, 3, 27, "Input",
      CellTags->"PermRepresent"],
    Cell[240463, 5456, 163, 4, 26, "Output",
      CellTags->"PermRepresent"],
    Cell[240641, 5463, 236, 7, 44, "MathCaption",
      CellTags->"PermRepresent"],
    Cell[240902, 5474, 117, 3, 27, "Input",
      CellTags->"PermRepresent"],
    Cell[241022, 5479, 92, 3, 26, "Output",
      CellTags->"PermRepresent"]},
  "i:8"->{
    Cell[230756, 5195, 94, 1, 48, "Subsubsection",
      CellTags->{"PermRepresent", "i:8"}]},
  "i:9"->{
    Cell[231265, 5215, 8778, 223, 112, "DefinitionBox",
      CellTags->{"PermRepresent", "i:9"}]},
  "Cycles"->{
    Cell[241129, 5485, 69, 1, 48, "Subsubsection",
      CellTags->{"Cycles", "i:10"}],
    Cell[241201, 5488, 1199, 27, 183, "Text",
      CellTags->"Cycles"],
    Cell[242403, 5517, 472, 12, 96, "Text",
      CellTags->"Cycles"],
    Cell[242878, 5531, 6379, 183, 122, "DefinitionBox",
      CellTags->{"Cycles", "i:11"}],
    Cell[249260, 5716, 84, 1, 14, "Caption",
      CellTags->"Cycles"],
    Cell[249347, 5719, 9127, 236, 158, "DefinitionBox3Col",
      CellTags->{"Cycles", "i:12"}],
    Cell[258477, 5957, 127, 6, 14, "Caption",
      CellTags->"Cycles"],
    Cell[258607, 5965, 94, 1, 28, "MathCaption",
      CellTags->"Cycles"],
    Cell[258726, 5970, 144, 4, 27, "Input",
      CellTags->"Cycles"],
    Cell[258873, 5976, 116, 3, 26, "Output",
      CellTags->"Cycles"],
    Cell[259004, 5982, 174, 7, 29, "MathCaption",
      CellTags->"Cycles"],
    Cell[259203, 5993, 119, 3, 27, "Input",
      CellTags->"Cycles"],
    Cell[259325, 5998, 126, 3, 26, "Output",
      CellTags->"Cycles"],
    Cell[259466, 6004, 369, 8, 71, "MathCaption",
      CellTags->"Cycles"],
    Cell[259860, 6016, 105, 3, 27, "Input",
      CellTags->"Cycles"],
    Cell[259968, 6021, 130, 3, 26, "Output",
      CellTags->"Cycles"],
    Cell[260113, 6027, 298, 11, 59, "MathCaption",
      CellTags->"Cycles"],
    Cell[260436, 6042, 122, 3, 27, "Input",
      CellTags->"Cycles"],
    Cell[260561, 6047, 158, 4, 41, "Output",
      CellTags->"Cycles"],
    Cell[260734, 6054, 174, 6, 29, "MathCaption",
      CellTags->"Cycles"],
    Cell[260933, 6064, 264, 6, 59, "Input",
      CellTags->"Cycles"],
    Cell[261200, 6072, 99, 3, 26, "Output",
      CellTags->"Cycles"],
    Cell[261314, 6078, 267, 6, 58, "MathCaption",
      CellTags->"Cycles"],
    Cell[261606, 6088, 120, 3, 27, "Input",
      CellTags->"Cycles"],
    Cell[261729, 6093, 209, 4, 55, "Message",
      CellTags->"Cycles"],
    Cell[261941, 6099, 88, 3, 26, "Output",
      CellTags->"Cycles"],
    Cell[262044, 6105, 221, 7, 44, "MathCaption",
      CellTags->"Cycles"],
    Cell[262290, 6116, 155, 4, 59, "Input",
      CellTags->"Cycles"],
    Cell[262448, 6122, 463, 14, 42, "Output",
      CellTags->"Cycles"],
    Cell[262926, 6139, 174, 5, 43, "MathCaption",
      CellTags->"Cycles"],
    Cell[263125, 6148, 299, 6, 59, "Input",
      CellTags->"Cycles"],
    Cell[263427, 6156, 147, 4, 41, "Output",
      CellTags->"Cycles"],
    Cell[263589, 6163, 193, 5, 43, "MathCaption",
      CellTags->"Cycles"],
    Cell[263807, 6172, 113, 3, 27, "Input",
      CellTags->"Cycles"],
    Cell[263923, 6177, 96, 3, 26, "Output",
      CellTags->"Cycles"]},
  "i:10"->{
    Cell[241129, 5485, 69, 1, 48, "Subsubsection",
      CellTags->{"Cycles", "i:10"}]},
  "i:11"->{
    Cell[242878, 5531, 6379, 183, 122, "DefinitionBox",
      CellTags->{"Cycles", "i:11"}]},
  "i:12"->{
    Cell[249347, 5719, 9127, 236, 158, "DefinitionBox3Col",
      CellTags->{"Cycles", "i:12"}]},
  "CycleOperations"->{
    Cell[264034, 6183, 88, 1, 48, "Subsubsection",
      CellTags->{"CycleOperations", "i:13"}],
    Cell[264125, 6186, 389, 10, 64, "Text",
      CellTags->"CycleOperations"],
    Cell[264517, 6198, 15783, 426, 281, "DefinitionBox",
      CellTags->{"CycleOperations", "i:14"}],
    Cell[280303, 6626, 157, 6, 14, "Caption",
      CellTags->"CycleOperations"],
    Cell[280463, 6634, 176, 4, 42, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[280664, 6642, 196, 4, 43, "Input",
      CellTags->"CycleOperations"],
    Cell[280863, 6648, 122, 3, 26, "Output",
      CellTags->"CycleOperations"],
    Cell[281000, 6654, 265, 6, 57, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[281290, 6664, 128, 3, 27, "Input",
      CellTags->"CycleOperations"],
    Cell[281421, 6669, 142, 3, 26, "Output",
      CellTags->"CycleOperations"],
    Cell[281578, 6675, 163, 4, 42, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[281766, 6683, 182, 4, 59, "Input",
      CellTags->"CycleOperations"],
    Cell[281951, 6689, 114, 3, 26, "Output",
      CellTags->"CycleOperations"],
    Cell[282080, 6695, 186, 5, 43, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[282291, 6704, 117, 3, 27, "Input",
      CellTags->"CycleOperations"],
    Cell[282411, 6709, 114, 3, 26, "Output",
      CellTags->"CycleOperations"],
    Cell[282540, 6715, 233, 8, 42, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[282798, 6727, 136, 3, 27, "Input",
      CellTags->"CycleOperations"],
    Cell[282937, 6732, 117, 3, 26, "Output",
      CellTags->"CycleOperations"],
    Cell[283069, 6738, 146, 4, 42, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[283240, 6746, 260, 6, 75, "Input",
      CellTags->"CycleOperations"],
    Cell[283503, 6754, 130, 3, 26, "Output",
      CellTags->"CycleOperations"],
    Cell[283648, 6760, 142, 4, 42, "MathCaption",
      CellTags->"CycleOperations"],
    Cell[283815, 6768, 208, 4, 59, "Input",
      CellTags->"CycleOperations"],
    Cell[284026, 6774, 94, 3, 26, "Output",
      CellTags->"CycleOperations"]},
  "i:13"->{
    Cell[264034, 6183, 88, 1, 48, "Subsubsection",
      CellTags->{"CycleOperations", "i:13"}]},
  "i:14"->{
    Cell[264517, 6198, 15783, 426, 281, "DefinitionBox",
      CellTags->{"CycleOperations", "i:14"}]},
  "OtherCycle"->{
    Cell[284135, 6780, 86, 1, 48, "Subsubsection",
      CellTags->"OtherCycle"],
    Cell[284224, 6783, 194, 6, 43, "MathCaption",
      CellTags->"OtherCycle"],
    Cell[284443, 6793, 137, 3, 27, "Input",
      CellTags->"OtherCycle"],
    Cell[284583, 6798, 89, 3, 26, "Output",
      CellTags->"OtherCycle"],
    Cell[284687, 6804, 8013, 222, 139, "DefinitionBox",
      CellTags->{"OtherCycle", "i:15"}],
    Cell[292703, 7028, 79, 1, 14, "Caption",
      CellTags->"OtherCycle"],
    Cell[292785, 7031, 247, 5, 58, "MathCaption",
      CellTags->"OtherCycle"],
    Cell[293057, 7040, 244, 5, 75, "Input",
      CellTags->"OtherCycle"],
    Cell[293304, 7047, 97, 3, 26, "Output",
      CellTags->"OtherCycle"],
    Cell[293416, 7053, 329, 6, 78, "Text",
      CellTags->{"OtherCycle", "i:16"}],
    Cell[293748, 7061, 2161, 62, 72, "DefinitionBox",
      CellTags->{"OtherCycle", "i:17"}],
    Cell[295912, 7125, 74, 1, 14, "Caption",
      CellTags->"OtherCycle"],
    Cell[295989, 7128, 130, 4, 28, "MathCaption",
      CellTags->"OtherCycle"],
    Cell[296144, 7136, 130, 3, 27, "Input",
      CellTags->"OtherCycle"],
    Cell[296277, 7141, 153, 4, 41, "Output",
      CellTags->"OtherCycle"],
    Cell[296445, 7148, 169, 4, 42, "MathCaption",
      CellTags->"OtherCycle"],
    Cell[296639, 7156, 118, 3, 27, "Input",
      CellTags->"OtherCycle"],
    Cell[296760, 7161, 155, 4, 41, "Output",
      CellTags->"OtherCycle"],
    Cell[296930, 7168, 289, 6, 62, "Text",
      CellTags->"OtherCycle"],
    Cell[297222, 7176, 3332, 96, 120, "DefinitionBox",
      CellTags->{"OtherCycle", "i:18"}],
    Cell[300557, 7274, 96, 1, 14, "Caption",
      CellTags->"OtherCycle"],
    Cell[300656, 7277, 138, 3, 28, "MathCaption",
      CellTags->"OtherCycle"],
    Cell[300819, 7284, 157, 4, 43, "Input",
      CellTags->"OtherCycle"],
    Cell[300979, 7290, 194, 4, 41, "Output",
      CellTags->"OtherCycle"],
    Cell[301188, 7297, 190, 5, 42, "MathCaption",
      CellTags->"OtherCycle"],
    Cell[301403, 7306, 416, 10, 107, "Input",
      CellTags->"OtherCycle"],
    Cell[301822, 7318, 758, 17, 118, "Output",
      CellTags->"OtherCycle"]},
  "i:15"->{
    Cell[284687, 6804, 8013, 222, 139, "DefinitionBox",
      CellTags->{"OtherCycle", "i:15"}]},
  "i:16"->{
    Cell[293416, 7053, 329, 6, 78, "Text",
      CellTags->{"OtherCycle", "i:16"}]},
  "i:17"->{
    Cell[293748, 7061, 2161, 62, 72, "DefinitionBox",
      CellTags->{"OtherCycle", "i:17"}]},
  "i:18"->{
    Cell[297222, 7176, 3332, 96, 120, "DefinitionBox",
      CellTags->{"OtherCycle", "i:18"}]},
  "Stabilizers"->{
    Cell[302595, 7338, 90, 1, 48, "Subsubsection",
      CellTags->{"Stabilizers", "i:19"}],
    Cell[302688, 7341, 424, 13, 64, "Text",
      CellTags->"Stabilizers"],
    Cell[303115, 7356, 6321, 185, 153, "DefinitionBox",
      CellTags->"Stabilizers"],
    Cell[309439, 7543, 191, 8, 14, "Caption",
      CellTags->"Stabilizers"],
    Cell[309633, 7553, 174, 6, 28, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[309832, 7563, 184, 5, 27, "Input",
      CellTags->"Stabilizers"],
    Cell[310019, 7570, 90, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[310124, 7576, 138, 5, 29, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[310287, 7585, 109, 3, 27, "Input",
      CellTags->"Stabilizers"],
    Cell[310399, 7590, 87, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[310501, 7596, 135, 4, 28, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[310661, 7604, 512, 13, 75, "Input",
      CellTags->"Stabilizers"],
    Cell[311176, 7619, 98, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[311289, 7625, 507, 21, 48, "Text",
      CellTags->"Stabilizers"],
    Cell[311799, 7648, 9561, 276, 180, "DefinitionBox",
      CellTags->{"Stabilizers", "i:20"}],
    Cell[321363, 7926, 86, 1, 14, "Caption",
      CellTags->"Stabilizers"],
    Cell[321452, 7929, 380, 15, 42, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[321857, 7948, 396, 9, 107, "Input",
      CellTags->"Stabilizers"],
    Cell[322256, 7959, 289, 5, 86, "Output",
      CellTags->"Stabilizers"],
    Cell[322560, 7967, 173, 6, 28, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[322758, 7977, 110, 3, 27, "Input",
      CellTags->"Stabilizers"],
    Cell[322871, 7982, 95, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[322981, 7988, 244, 7, 42, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[323250, 7999, 138, 3, 43, "Input",
      CellTags->"Stabilizers"],
    Cell[323391, 8004, 104, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[323510, 8010, 160, 4, 42, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[323695, 8018, 115, 3, 27, "Input",
      CellTags->"Stabilizers"],
    Cell[323813, 8023, 138, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[323966, 8029, 259, 8, 42, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[324250, 8041, 153, 4, 43, "Input",
      CellTags->"Stabilizers"],
    Cell[324406, 8047, 138, 3, 26, "Output",
      CellTags->"Stabilizers"],
    Cell[324559, 8053, 153, 5, 29, "MathCaption",
      CellTags->"Stabilizers"],
    Cell[324737, 8062, 121, 3, 27, "Input",
      CellTags->"Stabilizers"],
    Cell[324861, 8067, 138, 3, 26, "Output",
      CellTags->"Stabilizers"]},
  "i:19"->{
    Cell[302595, 7338, 90, 1, 48, "Subsubsection",
      CellTags->{"Stabilizers", "i:19"}]},
  "i:20"->{
    Cell[311799, 7648, 9561, 276, 180, "DefinitionBox",
      CellTags->{"Stabilizers", "i:20"}]},
  "BasicZ"->{
    Cell[325014, 8073, 216, 7, 58, "Subsection",
      CellTags->{"BasicZ", "i:21"}],
    Cell[325233, 8082, 68, 1, 48, "Subsubsection",
      CellTags->"BasicZ"],
    Cell[325304, 8085, 731, 18, 114, "Text",
      CellTags->"BasicZ"],
    Cell[326038, 8105, 12639, 355, 325, "DefinitionBox",
      CellTags->{"BasicZ", "i:22"}],
    Cell[338680, 8462, 57, 1, 14, "Caption",
      CellTags->"BasicZ"],
    Cell[338740, 8465, 182, 6, 32, "MathCaption",
      CellTags->"BasicZ"],
    Cell[338947, 8475, 198, 5, 54, "Input",
      CellTags->"BasicZ"],
    Cell[339148, 8482, 119, 3, 26, "Output",
      CellTags->"BasicZ"],
    Cell[339282, 8488, 217, 9, 32, "MathCaption",
      CellTags->"BasicZ"],
    Cell[339524, 8501, 135, 3, 33, "Input",
      CellTags->"BasicZ"],
    Cell[339662, 8506, 109, 3, 32, "Output",
      CellTags->"BasicZ"],
    Cell[339786, 8512, 186, 6, 32, "MathCaption",
      CellTags->"BasicZ"],
    Cell[339997, 8522, 147, 4, 33, "Input",
      CellTags->"BasicZ"],
    Cell[340147, 8528, 106, 3, 26, "Output",
      CellTags->"BasicZ"],
    Cell[340268, 8534, 196, 6, 32, "MathCaption",
      CellTags->"BasicZ"],
    Cell[340489, 8544, 127, 3, 33, "Input",
      CellTags->"BasicZ"],
    Cell[340619, 8549, 96, 3, 29, "Output",
      CellTags->"BasicZ"],
    Cell[340730, 8555, 350, 12, 46, "MathCaption",
      CellTags->"BasicZ"],
    Cell[341105, 8571, 119, 3, 33, "Input",
      CellTags->"BasicZ"],
    Cell[341227, 8576, 85, 3, 26, "Output",
      CellTags->"BasicZ"],
    Cell[341327, 8582, 85, 1, 28, "MathCaption",
      CellTags->"BasicZ"],
    Cell[341437, 8587, 150, 4, 33, "Input",
      CellTags->"BasicZ"],
    Cell[341590, 8593, 100, 3, 26, "Output",
      CellTags->"BasicZ"]},
  "i:21"->{
    Cell[325014, 8073, 216, 7, 58, "Subsection",
      CellTags->{"BasicZ", "i:21"}]},
  "i:22"->{
    Cell[326038, 8105, 12639, 355, 325, "DefinitionBox",
      CellTags->{"BasicZ", "i:22"}]},
  "DivisibilityZ"->{
    Cell[341705, 8599, 82, 1, 48, "Subsubsection",
      CellTags->{"DivisibilityZ", "i:23"}],
    Cell[341790, 8602, 6206, 177, 105, "DefinitionBox",
      CellTags->{"DivisibilityZ", "i:24"}],
    Cell[347999, 8781, 97, 1, 14, "Caption",
      CellTags->"DivisibilityZ"],
    Cell[348099, 8784, 239, 9, 28, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[348363, 8797, 123, 3, 27, "Input",
      CellTags->"DivisibilityZ"],
    Cell[348489, 8802, 101, 3, 26, "Output",
      CellTags->"DivisibilityZ"],
    Cell[348605, 8808, 114, 2, 28, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[348744, 8814, 138, 3, 27, "Input",
      CellTags->"DivisibilityZ"],
    Cell[348885, 8819, 114, 3, 26, "Output",
      CellTags->"DivisibilityZ"],
    Cell[349014, 8825, 133, 4, 28, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[349172, 8833, 166, 4, 43, "Input",
      CellTags->"DivisibilityZ"],
    Cell[349341, 8839, 125, 3, 26, "Output",
      CellTags->"DivisibilityZ"],
    Cell[349481, 8845, 10504, 291, 205, "DefinitionBox",
      CellTags->{"DivisibilityZ", "i:25"}],
    Cell[359988, 9138, 188, 6, 18, "Caption",
      CellTags->"DivisibilityZ"],
    Cell[360179, 9146, 12016, 327, 307, "DefinitionBox3Col",
      CellTags->{"DivisibilityZ", "i:26"}],
    Cell[372198, 9475, 205, 9, 14, "Caption",
      CellTags->"DivisibilityZ"],
    Cell[372406, 9486, 281, 9, 50, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[372712, 9499, 152, 4, 33, "Input",
      CellTags->"DivisibilityZ"],
    Cell[372867, 9505, 92, 3, 26, "Output",
      CellTags->"DivisibilityZ"],
    Cell[372974, 9511, 112, 2, 28, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[373111, 9517, 131, 3, 33, "Input",
      CellTags->"DivisibilityZ"],
    Cell[373245, 9522, 92, 3, 26, "Output",
      CellTags->"DivisibilityZ"],
    Cell[373352, 9528, 249, 7, 46, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[373626, 9539, 121, 3, 33, "Input",
      CellTags->"DivisibilityZ"],
    Cell[373750, 9544, 101, 3, 29, "Output",
      CellTags->"DivisibilityZ"],
    Cell[373866, 9550, 156, 4, 42, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[374047, 9558, 182, 4, 43, "Input",
      CellTags->"DivisibilityZ"],
    Cell[374232, 9564, 205, 4, 41, "Output",
      CellTags->"DivisibilityZ"],
    Cell[374452, 9571, 433, 9, 74, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[374910, 9584, 145, 3, 27, "Input",
      CellTags->"DivisibilityZ"],
    Cell[375058, 9589, 191, 4, 54, "Output",
      CellTags->"DivisibilityZ"],
    Cell[375264, 9596, 393, 12, 59, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[375682, 9612, 229, 5, 59, "Input",
      CellTags->"DivisibilityZ"],
    Cell[375914, 9619, 305, 6, 74, "Output",
      CellTags->"DivisibilityZ"],
    Cell[376234, 9628, 327, 9, 42, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[376586, 9641, 228, 5, 59, "Input",
      CellTags->"DivisibilityZ"],
    Cell[376817, 9648, 319, 6, 56, "Output",
      CellTags->"DivisibilityZ"],
    Cell[377151, 9657, 101, 1, 28, "MathCaption",
      CellTags->"DivisibilityZ"],
    Cell[377277, 9662, 227, 5, 59, "Input",
      CellTags->"DivisibilityZ"],
    Cell[377507, 9669, 329, 6, 56, "Output",
      CellTags->"DivisibilityZ"],
    Cell[377851, 9678, 3124, 84, 57, "DefinitionBox",
      CellTags->{"DivisibilityZ", "i:27"}],
    Cell[380978, 9764, 106, 1, 14, "Caption",
      CellTags->"DivisibilityZ"],
    Cell[381109, 9769, 188, 5, 43, "Input",
      CellTags->"DivisibilityZ"],
    Cell[381300, 9776, 152, 4, 26, "Output",
      CellTags->"DivisibilityZ"]},
  "i:23"->{
    Cell[341705, 8599, 82, 1, 48, "Subsubsection",
      CellTags->{"DivisibilityZ", "i:23"}]},
  "i:24"->{
    Cell[341790, 8602, 6206, 177, 105, "DefinitionBox",
      CellTags->{"DivisibilityZ", "i:24"}]},
  "i:25"->{
    Cell[349481, 8845, 10504, 291, 205, "DefinitionBox",
      CellTags->{"DivisibilityZ", "i:25"}]},
  "i:26"->{
    Cell[360179, 9146, 12016, 327, 307, "DefinitionBox3Col",
      CellTags->{"DivisibilityZ", "i:26"}]},
  "i:27"->{
    Cell[377851, 9678, 3124, 84, 57, "DefinitionBox",
      CellTags->{"DivisibilityZ", "i:27"}]},
  "NormZ"->{
    Cell[381467, 9783, 84, 1, 48, "Subsubsection",
      CellTags->{"NormZ", "i:28"}],
    Cell[381554, 9786, 12564, 342, 231, "DefinitionBox",
      CellTags->{"NormZ", "i:29"}],
    Cell[394121, 10130, 59, 1, 14, "Caption",
      CellTags->"NormZ"],
    Cell[394183, 10133, 219, 6, 46, "MathCaption",
      CellTags->"NormZ"],
    Cell[394427, 10143, 217, 5, 59, "Input",
      CellTags->"NormZ"],
    Cell[394647, 10150, 552, 15, 158, "Output",
      CellTags->"NormZ"],
    Cell[395214, 10168, 155, 4, 42, "MathCaption",
      CellTags->"NormZ"],
    Cell[395394, 10176, 136, 3, 27, "Input",
      CellTags->"NormZ"],
    Cell[395533, 10181, 218, 5, 56, "Output",
      CellTags->"NormZ"],
    Cell[395766, 10189, 119, 4, 28, "MathCaption",
      CellTags->"NormZ"],
    Cell[395910, 10197, 108, 3, 27, "Input",
      CellTags->"NormZ"],
    Cell[396021, 10202, 98, 3, 26, "Output",
      CellTags->"NormZ"],
    Cell[396134, 10208, 769, 23, 90, "MathCaption",
      CellTags->"NormZ"],
    Cell[396928, 10235, 133, 3, 27, "Input",
      CellTags->"NormZ"],
    Cell[397064, 10240, 19531, 865, 137, 9237, 732, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"NormZ"],
    Cell[416598, 11107, 165, 4, 41, "Output",
      CellTags->"NormZ"],
    Cell[416778, 11114, 422, 11, 60, "MathCaption",
      CellTags->"NormZ"],
    Cell[417225, 11129, 114, 3, 27, "Input",
      CellTags->"NormZ"],
    Cell[417342, 11134, 157, 4, 32, "Output",
      CellTags->"NormZ"],
    Cell[417514, 11141, 188, 6, 32, "MathCaption",
      CellTags->"NormZ"],
    Cell[417727, 11151, 112, 3, 27, "Input",
      CellTags->"NormZ"],
    Cell[417842, 11156, 413, 7, 91, "Output",
      CellTags->"NormZ"]},
  "i:28"->{
    Cell[381467, 9783, 84, 1, 48, "Subsubsection",
      CellTags->{"NormZ", "i:28"}]},
  "i:29"->{
    Cell[381554, 9786, 12564, 342, 231, "DefinitionBox",
      CellTags->{"NormZ", "i:29"}]},
  "WorkLists"->{
    Cell[418270, 11166, 74, 1, 56, "Subsection",
      CellTags->"WorkLists"],
    Cell[418347, 11169, 84, 1, 48, "Subsubsection",
      CellTags->{"WorkLists", "i:30"}],
    Cell[418434, 11172, 616, 13, 114, "Text",
      CellTags->"WorkLists"],
    Cell[419053, 11187, 17945, 519, 322, "DefinitionBox",
      CellTags->{"WorkLists", "i:31"}],
    Cell[437001, 11708, 73, 1, 14, "Caption",
      CellTags->"WorkLists"],
    Cell[437077, 11711, 294, 9, 58, "MathCaption",
      CellTags->"WorkLists"],
    Cell[437396, 11724, 207, 6, 72, "Input",
      CellTags->"WorkLists"],
    Cell[437606, 11732, 154, 4, 41, "Output",
      CellTags->"WorkLists"],
    Cell[437775, 11739, 130, 4, 29, "MathCaption",
      CellTags->"WorkLists"],
    Cell[437930, 11747, 236, 6, 72, "Input",
      CellTags->"WorkLists"],
    Cell[438169, 11755, 109, 3, 26, "Output",
      CellTags->"WorkLists"],
    Cell[438293, 11761, 277, 9, 43, "MathCaption",
      CellTags->"WorkLists"],
    Cell[438595, 11774, 151, 4, 27, "Input",
      CellTags->"WorkLists"],
    Cell[438749, 11780, 213, 4, 41, "Output",
      CellTags->"WorkLists"],
    Cell[438977, 11787, 169, 4, 42, "MathCaption",
      CellTags->"WorkLists"],
    Cell[439171, 11795, 233, 5, 59, "Input",
      CellTags->"WorkLists"],
    Cell[439407, 11802, 624, 15, 84, "Output",
      CellTags->"WorkLists"],
    Cell[440046, 11820, 170, 5, 44, "MathCaption",
      CellTags->"WorkLists"],
    Cell[440241, 11829, 131, 3, 27, "Input",
      CellTags->"WorkLists"],
    Cell[440375, 11834, 303, 6, 71, "Output",
      CellTags->"WorkLists"],
    Cell[440693, 11843, 186, 5, 43, "MathCaption",
      CellTags->"WorkLists"],
    Cell[440904, 11852, 195, 5, 59, "Input",
      CellTags->"WorkLists"],
    Cell[441102, 11859, 415, 11, 42, "Output",
      CellTags->"WorkLists"],
    Cell[441532, 11873, 122, 4, 28, "MathCaption",
      CellTags->"WorkLists"],
    Cell[441679, 11881, 241, 6, 59, "Input",
      CellTags->"WorkLists"],
    Cell[441923, 11889, 175, 4, 41, "Output",
      CellTags->"WorkLists"],
    Cell[442113, 11896, 131, 4, 29, "MathCaption",
      CellTags->"WorkLists"],
    Cell[442269, 11904, 99, 3, 27, "Input",
      CellTags->"WorkLists"],
    Cell[442371, 11909, 175, 4, 41, "Output",
      CellTags->"WorkLists"],
    Cell[442561, 11916, 214, 9, 44, "MathCaption",
      CellTags->"WorkLists"],
    Cell[442800, 11929, 231, 5, 59, "Input",
      CellTags->"WorkLists"],
    Cell[443034, 11936, 103, 3, 26, "Output",
      CellTags->"WorkLists"]},
  "i:30"->{
    Cell[418347, 11169, 84, 1, 48, "Subsubsection",
      CellTags->{"WorkLists", "i:30"}]},
  "i:31"->{
    Cell[419053, 11187, 17945, 519, 322, "DefinitionBox",
      CellTags->{"WorkLists", "i:31"}]},
  "WorkGraphics"->{
    Cell[443152, 11942, 90, 1, 48, "Subsubsection",
      CellTags->{"WorkGraphics", "i:32"}],
    Cell[443245, 11945, 191, 5, 46, "Text",
      CellTags->"WorkGraphics"],
    Cell[443439, 11952, 19387, 524, 267, "DefinitionBox",
      CellTags->{"WorkGraphics", "i:33"}],
    Cell[462829, 12478, 83, 1, 14, "Caption",
      CellTags->"WorkGraphics"],
    Cell[462915, 12481, 160, 4, 43, "MathCaption",
      CellTags->"WorkGraphics"],
    Cell[463100, 12489, 131, 3, 27, "Input",
      CellTags->"WorkGraphics"],
    Cell[463234, 12494, 48381, 659, 282, 1110, 70, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"WorkGraphics"],
    Cell[511630, 13156, 249, 8, 43, "MathCaption",
      CellTags->"WorkGraphics"],
    Cell[511904, 13168, 120, 3, 27, "Input",
      CellTags->"WorkGraphics"],
    Cell[512027, 13173, 21732, 405, 139, 2630, 164, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"WorkGraphics"],
    Cell[533762, 13580, 224, 4, 67, "Print",
      CellTags->"WorkGraphics"],
    Cell[533989, 13586, 102, 3, 26, "Output",
      CellTags->"WorkGraphics"]},
  "i:32"->{
    Cell[443152, 11942, 90, 1, 48, "Subsubsection",
      CellTags->{"WorkGraphics", "i:32"}]},
  "i:33"->{
    Cell[443439, 11952, 19387, 524, 267, "DefinitionBox",
      CellTags->{"WorkGraphics", "i:33"}]},
  "Adjoin"->{
    Cell[534106, 13592, 69, 1, 48, "Subsubsection",
      CellTags->{"Adjoin", "i:34"}],
    Cell[534178, 13595, 1783, 49, 187, "Text",
      CellTags->"Adjoin"],
    Cell[535964, 13646, 10282, 294, 182, "DefinitionBox",
      CellTags->"Adjoin"],
    Cell[546249, 13942, 134, 6, 14, "Caption",
      CellTags->"Adjoin"],
    Cell[546386, 13950, 154, 6, 32, "MathCaption",
      CellTags->"Adjoin"],
    Cell[546565, 13960, 104, 3, 33, "Input",
      CellTags->"Adjoin"],
    Cell[546672, 13965, 196, 4, 54, "Output",
      CellTags->"Adjoin"],
    Cell[546883, 13972, 140, 4, 42, "MathCaption",
      CellTags->"Adjoin"],
    Cell[547048, 13980, 102, 3, 27, "Input",
      CellTags->"Adjoin"],
    Cell[547153, 13985, 90, 3, 26, "Output",
      CellTags->"Adjoin"],
    Cell[547258, 13991, 92, 1, 28, "MathCaption",
      CellTags->"Adjoin"],
    Cell[547375, 13996, 132, 4, 47, "Input",
      CellTags->"Adjoin"],
    Cell[547510, 14002, 389, 7, 62, "Output",
      CellTags->"Adjoin"],
    Cell[547914, 14012, 238, 6, 42, "MathCaption",
      CellTags->"Adjoin"],
    Cell[548177, 14022, 112, 3, 33, "Input",
      CellTags->"Adjoin"],
    Cell[548292, 14027, 259, 5, 73, "Output",
      CellTags->"Adjoin"],
    Cell[548566, 14035, 100, 1, 28, "MathCaption",
      CellTags->"Adjoin"],
    Cell[548691, 14040, 113, 3, 31, "Input",
      CellTags->"Adjoin"],
    Cell[548807, 14045, 242, 6, 40, "Output",
      CellTags->"Adjoin"],
    Cell[549064, 14054, 182, 5, 42, "MathCaption",
      CellTags->"Adjoin"],
    Cell[549271, 14063, 174, 5, 27, "Input",
      CellTags->"Adjoin"],
    Cell[549448, 14070, 200, 4, 28, "Output",
      CellTags->"Adjoin"],
    Cell[549663, 14077, 415, 11, 56, "MathCaption",
      CellTags->"Adjoin"],
    Cell[550103, 14092, 155, 4, 43, "Input",
      CellTags->"Adjoin"]},
  "i:34"->{
    Cell[534106, 13592, 69, 1, 48, "Subsubsection",
      CellTags->{"Adjoin", "i:34"}]},
  "Disguising"->{
    Cell[550561, 14107, 94, 1, 48, "Subsubsection",
      CellTags->{"Disguising", "i:35"}],
    Cell[550658, 14110, 460, 12, 79, "Text",
      CellTags->"Disguising"],
    Cell[551121, 14124, 6991, 194, 180, "DefinitionBox",
      CellTags->{"Disguising", "i:36"}],
    Cell[558115, 14320, 78, 1, 14, "Caption",
      CellTags->"Disguising"],
    Cell[558218, 14325, 415, 8, 123, "Input",
      CellTags->"Disguising"],
    Cell[558636, 14335, 43484, 1041, 159, 10874, 632, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Disguising"]},
  "i:35"->{
    Cell[550561, 14107, 94, 1, 48, "Subsubsection",
      CellTags->{"Disguising", "i:35"}]},
  "i:36"->{
    Cell[551121, 14124, 6991, 194, 180, "DefinitionBox",
      CellTags->{"Disguising", "i:36"}]},
  "LabCode"->{
    Cell[602135, 15379, 158, 5, 48, "Subsubsection",
      CellTags->{"LabCode", "i:37"}],
    Cell[602296, 15386, 7083, 195, 172, "DefinitionBox",
      CellTags->{"LabCode", "i:38"}],
    Cell[609382, 15583, 168, 6, 14, "Caption",
      CellTags->"LabCode"],
    Cell[609553, 15591, 251, 8, 42, "MathCaption",
      CellTags->"LabCode"],
    Cell[609829, 15603, 110, 3, 27, "Input",
      CellTags->"LabCode"],
    Cell[610105, 15614, 118, 4, 28, "MathCaption",
      CellTags->"LabCode"],
    Cell[610248, 15622, 110, 3, 27, "Input",
      CellTags->"LabCode"]},
  "i:37"->{
    Cell[602135, 15379, 158, 5, 48, "Subsubsection",
      CellTags->{"LabCode", "i:37"}]},
  "i:38"->{
    Cell[602296, 15386, 7083, 195, 172, "DefinitionBox",
      CellTags->{"LabCode", "i:38"}]},
  "Potpourri"->{
    Cell[637204, 16296, 65, 1, 48, "Subsubsection",
      CellTags->"Potpourri"],
    Cell[637272, 16299, 8862, 247, 165, "DefinitionBox",
      CellTags->{"Potpourri", "i:39"}],
    Cell[646137, 16548, 68, 1, 14, "Caption",
      CellTags->"Potpourri"],
    Cell[646208, 16551, 142, 4, 42, "MathCaption",
      CellTags->"Potpourri"],
    Cell[646375, 16559, 172, 4, 43, "Input",
      CellTags->"Potpourri"],
    Cell[646550, 16565, 110, 3, 26, "Output",
      CellTags->"Potpourri"],
    Cell[646675, 16571, 121, 4, 28, "MathCaption",
      CellTags->"Potpourri"],
    Cell[646821, 16579, 111, 3, 27, "Input",
      CellTags->"Potpourri"],
    Cell[646935, 16584, 459, 13, 26, "Output",
      CellTags->"Potpourri"],
    Cell[647409, 16600, 153, 5, 29, "MathCaption",
      CellTags->"Potpourri"],
    Cell[647587, 16609, 241, 5, 59, "Input",
      CellTags->"Potpourri"],
    Cell[647831, 16616, 4405, 119, 116, 1265, 74, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->"Potpourri"],
    Cell[652251, 16738, 254, 7, 44, "MathCaption",
      CellTags->"Potpourri"],
    Cell[652530, 16749, 106, 3, 26, "Input",
      CellTags->"Potpourri"],
    Cell[652639, 16754, 184, 4, 35, "Output",
      CellTags->"Potpourri"]},
  "i:39"->{
    Cell[637272, 16299, 8862, 247, 165, "DefinitionBox",
      CellTags->{"Potpourri", "i:39"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Global", 653728, 16785},
  {"First", 655812, 16842},
  {"i:1", 656228, 16855},
  {"i:2", 656321, 16858},
  {"PermIntroduction", 656439, 16861},
  {"i:3", 658983, 16922},
  {"i:4", 659090, 16925},
  {"PermOperations", 659214, 16928},
  {"i:5", 661859, 16993},
  {"i:6", 661966, 16996},
  {"i:7", 662078, 16999},
  {"PermRepresent", 662201, 17002},
  {"i:8", 663044, 17023},
  {"i:9", 663150, 17026},
  {"Cycles", 663264, 17029},
  {"i:10", 665895, 17100},
  {"i:11", 665996, 17103},
  {"i:12", 666102, 17106},
  {"CycleOperations", 666223, 17109},
  {"i:13", 668326, 17160},
  {"i:14", 668436, 17163},
  {"OtherCycle", 668558, 17166},
  {"i:15", 670721, 17221},
  {"i:16", 670831, 17224},
  {"i:17", 670928, 17227},
  {"i:18", 671036, 17230},
  {"Stabilizers", 671152, 17233},
  {"i:19", 673865, 17302},
  {"i:20", 673971, 17305},
  {"BasicZ", 674084, 17308},
  {"i:21", 675817, 17355},
  {"i:22", 675916, 17358},
  {"DivisibilityZ", 676032, 17361},
  {"i:23", 679670, 17450},
  {"i:24", 679778, 17453},
  {"i:25", 679891, 17456},
  {"i:26", 680005, 17459},
  {"i:27", 680123, 17462},
  {"NormZ", 680235, 17465},
  {"i:28", 681948, 17511},
  {"i:29", 682048, 17514},
  {"WorkLists", 682159, 17517},
  {"i:30", 684682, 17582},
  {"i:31", 684787, 17585},
  {"WorkGraphics", 684906, 17588},
  {"i:32", 686015, 17615},
  {"i:33", 686123, 17618},
  {"Adjoin", 686239, 17621},
  {"i:34", 688061, 17670},
  {"Disguising", 688169, 17673},
  {"i:35", 688735, 17687},
  {"i:36", 688841, 17690},
  {"LabCode", 688955, 17693},
  {"i:37", 689533, 17708},
  {"i:38", 689637, 17711},
  {"Potpourri", 689750, 17714},
  {"i:39", 690998, 17746}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 830, 30, 89, "Subsubtitle",
  Evaluatable->False],
Cell[2564, 83, 199, 8, 91, "Section",
  Evaluatable->False,
  CellTags->"Global"],
Cell[2766, 93, 194, 5, 46, "Text",
  CellTags->"Global"],
Cell[2963, 100, 60, 1, 56, "Subsection",
  CellTags->"First"],
Cell[3026, 103, 178, 5, 47, "Text",
  CellTags->"First"],
Cell[3207, 110, 146, 4, 27, "Input",
  CellTags->"First"],
Cell[3356, 116, 163, 5, 47, "Text",
  CellTags->"First"],

Cell[CellGroupData[{
Cell[3544, 125, 102, 3, 27, "Input",
  CellTags->"First"],
Cell[3649, 130, 84, 3, 26, "Output",
  CellTags->"First"]
}, Open  ]],
Cell[3748, 136, 85, 1, 56, "Subsection",
  CellTags->{"Global", "i:1"}],
Cell[3836, 139, 118, 4, 30, "Text",
  CellTags->"Global"],
Cell[3957, 145, 4901, 137, 247, "DefinitionBox3Col",
  CellTags->{"Global", "i:2"}],
Cell[8861, 284, 63, 1, 14, "Caption",
  CellTags->"Global"],
Cell[8927, 287, 806, 16, 130, "DefinitionBox",
  CellTags->"Global"],
Cell[9736, 305, 117, 5, 14, "Caption",
  CellTags->"Global"],
Cell[9856, 312, 118, 4, 28, "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{
Cell[9999, 320, 95, 3, 27, "Input",
  CellTags->"Global"],
Cell[10097, 325, 85, 3, 26, "Output",
  CellTags->"Global"]
}, Open  ]],
Cell[10197, 331, 244, 5, 58, "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{
Cell[10466, 340, 103, 3, 27, "Input",
  CellTags->"Global"],
Cell[10572, 345, 85, 3, 26, "Output",
  CellTags->"Global"]
}, Open  ]],
Cell[10672, 351, 179, 5, 43, "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{
Cell[10876, 360, 123, 3, 27, "Input",
  CellTags->"Global"],
Cell[11002, 365, 75522, 1311, 296, 7864, 470, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Global"],
Cell[86527, 1678, 209, 4, 41, "Output",
  CellTags->"Global"]
}, Open  ]],
Cell[86751, 1685, 269, 8, 57, "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{
Cell[87045, 1697, 180, 5, 43, "Input",
  CellTags->"Global"],
Cell[87228, 1704, 56877, 951, 296, 5278, 308, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Global"],
Cell[144108, 2657, 176, 5, 26, "Output",
  CellTags->"Global"]
}, Open  ]],
Cell[144299, 2665, 171, 5, 44, "MathCaption",
  CellTags->"Global"],

Cell[CellGroupData[{
Cell[144495, 2674, 324, 7, 91, "Input",
  CellTags->"Global"],
Cell[144822, 2683, 52041, 1437, 159, 16536, 992, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Global"],
Cell[196866, 4122, 181, 5, 26, "Output",
  CellTags->"Global"]
}, Open  ]],
Cell[197062, 4130, 103, 1, 56, "Subsection",
  CellTags->{"PermIntroduction", "i:3"}],
Cell[197168, 4133, 75, 1, 48, "Subsubsection",
  CellTags->"PermIntroduction"],
Cell[197246, 4136, 1069, 32, 113, "Text",
  CellTags->"PermIntroduction"],
Cell[198318, 4170, 529, 19, 42, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[198872, 4193, 122, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[198997, 4198, 102, 3, 26, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[199114, 4204, 248, 6, 57, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[199387, 4214, 116, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[199506, 4219, 249, 8, 52, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[199770, 4230, 359, 10, 56, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[200154, 4244, 122, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[200279, 4249, 96, 3, 26, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[200390, 4255, 324, 7, 64, "Text",
  CellTags->"PermIntroduction"],
Cell[200717, 4264, 267, 7, 44, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[201009, 4275, 145, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[201157, 4280, 654, 11, 161, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[201826, 4294, 2350, 73, 105, "DefinitionBox",
  CellTags->{"PermIntroduction", "i:4"}],
Cell[204179, 4369, 232, 7, 26, "Caption",
  CellTags->"PermIntroduction"],
Cell[204414, 4378, 343, 10, 57, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[204782, 4392, 142, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[204927, 4397, 100, 3, 26, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[205042, 4403, 189, 5, 43, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[205256, 4412, 121, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[205380, 4417, 100, 3, 26, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[205495, 4423, 226, 9, 28, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[205746, 4436, 120, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[205869, 4441, 100, 3, 26, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[205984, 4447, 95, 1, 28, "MathCaption",
  CellTags->"PermIntroduction"],

Cell[CellGroupData[{
Cell[206104, 4452, 120, 3, 27, "Input",
  CellTags->"PermIntroduction"],
Cell[206227, 4457, 95, 3, 26, "Output",
  CellTags->"PermIntroduction"]
}, Open  ]],
Cell[206337, 4463, 92, 1, 48, "Subsubsection",
  CellTags->{"PermOperations", "i:5"}],
Cell[206432, 4466, 938, 32, 115, "Text",
  CellTags->"PermOperations"],
Cell[207373, 4500, 5722, 159, 146, "DefinitionBox",
  CellTags->{"PermOperations", "i:6"}],
Cell[213098, 4661, 92, 1, 14, "Caption",
  CellTags->"PermOperations"],
Cell[213193, 4664, 143, 4, 42, "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{
Cell[213361, 4672, 153, 4, 43, "Input",
  CellTags->"PermOperations"],
Cell[213517, 4678, 129, 3, 26, "Output",
  CellTags->"PermOperations"]
}, Open  ]],
Cell[213661, 4684, 593, 21, 58, "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{
Cell[214279, 4709, 132, 3, 27, "Input",
  CellTags->"PermOperations"],
Cell[214414, 4714, 357, 10, 42, "Output",
  CellTags->"PermOperations"]
}, Open  ]],
Cell[214786, 4727, 381, 12, 57, "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{
Cell[215192, 4743, 116, 3, 27, "Input",
  CellTags->"PermOperations"],
Cell[215311, 4748, 113, 3, 26, "Output",
  CellTags->"PermOperations"]
}, Open  ]],
Cell[215439, 4754, 185, 4, 42, "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{
Cell[215649, 4762, 163, 4, 43, "Input",
  CellTags->"PermOperations"],
Cell[215815, 4768, 113, 3, 26, "Output",
  CellTags->"PermOperations"]
}, Open  ]],
Cell[215943, 4774, 357, 9, 72, "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{
Cell[216325, 4787, 263, 5, 59, "Input",
  CellTags->"PermOperations"],
Cell[216591, 4794, 111, 2, 22, "Print",
  CellTags->"PermOperations"],
Cell[216705, 4798, 179, 4, 22, "Print",
  CellTags->"PermOperations"],
Cell[216887, 4804, 76, 2, 22, "Print",
  CellTags->"PermOperations"],
Cell[216966, 4808, 278, 6, 22, "Print",
  CellTags->"PermOperations"],
Cell[217247, 4816, 81, 2, 22, "Print",
  CellTags->"PermOperations"],
Cell[217331, 4820, 278, 6, 22, "Print",
  CellTags->"PermOperations"],
Cell[217612, 4828, 70, 2, 22, "Print",
  CellTags->"PermOperations"],
Cell[217685, 4832, 104, 3, 26, "Output",
  CellTags->"PermOperations"]
}, Open  ]],
Cell[217804, 4838, 178, 4, 46, "Text",
  CellTags->"PermOperations"],
Cell[217985, 4844, 11462, 308, 193, "DefinitionBox",
  CellTags->{"PermOperations", "i:7"}],
Cell[229450, 5154, 73, 1, 14, "Caption",
  CellTags->"PermOperations"],
Cell[229526, 5157, 241, 6, 43, "MathCaption",
  CellTags->"PermOperations"],

Cell[CellGroupData[{
Cell[229792, 5167, 271, 6, 66, "Input",
  CellTags->"PermOperations"],
Cell[230066, 5175, 675, 17, 135, "Output",
  CellTags->"PermOperations"]
}, Open  ]],
Cell[230756, 5195, 94, 1, 48, "Subsubsection",
  CellTags->{"PermRepresent", "i:8"}],
Cell[230853, 5198, 409, 15, 46, "Text",
  CellTags->"PermRepresent"],
Cell[231265, 5215, 8778, 223, 112, "DefinitionBox",
  CellTags->{"PermRepresent", "i:9"}],
Cell[240046, 5440, 91, 1, 14, "Caption",
  CellTags->"PermRepresent"],
Cell[240140, 5443, 153, 4, 42, "MathCaption",
  CellTags->"PermRepresent"],

Cell[CellGroupData[{
Cell[240318, 5451, 142, 3, 27, "Input",
  CellTags->"PermRepresent"],
Cell[240463, 5456, 163, 4, 26, "Output",
  CellTags->"PermRepresent"]
}, Open  ]],
Cell[240641, 5463, 236, 7, 44, "MathCaption",
  CellTags->"PermRepresent"],

Cell[CellGroupData[{
Cell[240902, 5474, 117, 3, 27, "Input",
  CellTags->"PermRepresent"],
Cell[241022, 5479, 92, 3, 26, "Output",
  CellTags->"PermRepresent"]
}, Open  ]],
Cell[241129, 5485, 69, 1, 48, "Subsubsection",
  CellTags->{"Cycles", "i:10"}],
Cell[241201, 5488, 1199, 27, 183, "Text",
  CellTags->"Cycles"],
Cell[242403, 5517, 472, 12, 96, "Text",
  CellTags->"Cycles"],
Cell[242878, 5531, 6379, 183, 122, "DefinitionBox",
  CellTags->{"Cycles", "i:11"}],
Cell[249260, 5716, 84, 1, 14, "Caption",
  CellTags->"Cycles"],
Cell[249347, 5719, 9127, 236, 158, "DefinitionBox3Col",
  CellTags->{"Cycles", "i:12"}],
Cell[258477, 5957, 127, 6, 14, "Caption",
  CellTags->"Cycles"],
Cell[258607, 5965, 94, 1, 28, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[258726, 5970, 144, 4, 27, "Input",
  CellTags->"Cycles"],
Cell[258873, 5976, 116, 3, 26, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[259004, 5982, 174, 7, 29, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[259203, 5993, 119, 3, 27, "Input",
  CellTags->"Cycles"],
Cell[259325, 5998, 126, 3, 26, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[259466, 6004, 369, 8, 71, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[259860, 6016, 105, 3, 27, "Input",
  CellTags->"Cycles"],
Cell[259968, 6021, 130, 3, 26, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[260113, 6027, 298, 11, 59, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[260436, 6042, 122, 3, 27, "Input",
  CellTags->"Cycles"],
Cell[260561, 6047, 158, 4, 41, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[260734, 6054, 174, 6, 29, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[260933, 6064, 264, 6, 59, "Input",
  CellTags->"Cycles"],
Cell[261200, 6072, 99, 3, 26, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[261314, 6078, 267, 6, 58, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[261606, 6088, 120, 3, 27, "Input",
  CellTags->"Cycles"],
Cell[261729, 6093, 209, 4, 55, "Message",
  CellTags->"Cycles"],
Cell[261941, 6099, 88, 3, 26, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[262044, 6105, 221, 7, 44, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[262290, 6116, 155, 4, 59, "Input",
  CellTags->"Cycles"],
Cell[262448, 6122, 463, 14, 42, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[262926, 6139, 174, 5, 43, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[263125, 6148, 299, 6, 59, "Input",
  CellTags->"Cycles"],
Cell[263427, 6156, 147, 4, 41, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[263589, 6163, 193, 5, 43, "MathCaption",
  CellTags->"Cycles"],

Cell[CellGroupData[{
Cell[263807, 6172, 113, 3, 27, "Input",
  CellTags->"Cycles"],
Cell[263923, 6177, 96, 3, 26, "Output",
  CellTags->"Cycles"]
}, Open  ]],
Cell[264034, 6183, 88, 1, 48, "Subsubsection",
  CellTags->{"CycleOperations", "i:13"}],
Cell[264125, 6186, 389, 10, 64, "Text",
  CellTags->"CycleOperations"],
Cell[264517, 6198, 15783, 426, 281, "DefinitionBox",
  CellTags->{"CycleOperations", "i:14"}],
Cell[280303, 6626, 157, 6, 14, "Caption",
  CellTags->"CycleOperations"],
Cell[280463, 6634, 176, 4, 42, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[280664, 6642, 196, 4, 43, "Input",
  CellTags->"CycleOperations"],
Cell[280863, 6648, 122, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[281000, 6654, 265, 6, 57, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[281290, 6664, 128, 3, 27, "Input",
  CellTags->"CycleOperations"],
Cell[281421, 6669, 142, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[281578, 6675, 163, 4, 42, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[281766, 6683, 182, 4, 59, "Input",
  CellTags->"CycleOperations"],
Cell[281951, 6689, 114, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[282080, 6695, 186, 5, 43, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[282291, 6704, 117, 3, 27, "Input",
  CellTags->"CycleOperations"],
Cell[282411, 6709, 114, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[282540, 6715, 233, 8, 42, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[282798, 6727, 136, 3, 27, "Input",
  CellTags->"CycleOperations"],
Cell[282937, 6732, 117, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[283069, 6738, 146, 4, 42, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[283240, 6746, 260, 6, 75, "Input",
  CellTags->"CycleOperations"],
Cell[283503, 6754, 130, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[283648, 6760, 142, 4, 42, "MathCaption",
  CellTags->"CycleOperations"],

Cell[CellGroupData[{
Cell[283815, 6768, 208, 4, 59, "Input",
  CellTags->"CycleOperations"],
Cell[284026, 6774, 94, 3, 26, "Output",
  CellTags->"CycleOperations"]
}, Open  ]],
Cell[284135, 6780, 86, 1, 48, "Subsubsection",
  CellTags->"OtherCycle"],
Cell[284224, 6783, 194, 6, 43, "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{
Cell[284443, 6793, 137, 3, 27, "Input",
  CellTags->"OtherCycle"],
Cell[284583, 6798, 89, 3, 26, "Output",
  CellTags->"OtherCycle"]
}, Open  ]],
Cell[284687, 6804, 8013, 222, 139, "DefinitionBox",
  CellTags->{"OtherCycle", "i:15"}],
Cell[292703, 7028, 79, 1, 14, "Caption",
  CellTags->"OtherCycle"],
Cell[292785, 7031, 247, 5, 58, "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{
Cell[293057, 7040, 244, 5, 75, "Input",
  CellTags->"OtherCycle"],
Cell[293304, 7047, 97, 3, 26, "Output",
  CellTags->"OtherCycle"]
}, Open  ]],
Cell[293416, 7053, 329, 6, 78, "Text",
  CellTags->{"OtherCycle", "i:16"}],
Cell[293748, 7061, 2161, 62, 72, "DefinitionBox",
  CellTags->{"OtherCycle", "i:17"}],
Cell[295912, 7125, 74, 1, 14, "Caption",
  CellTags->"OtherCycle"],
Cell[295989, 7128, 130, 4, 28, "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{
Cell[296144, 7136, 130, 3, 27, "Input",
  CellTags->"OtherCycle"],
Cell[296277, 7141, 153, 4, 41, "Output",
  CellTags->"OtherCycle"]
}, Open  ]],
Cell[296445, 7148, 169, 4, 42, "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{
Cell[296639, 7156, 118, 3, 27, "Input",
  CellTags->"OtherCycle"],
Cell[296760, 7161, 155, 4, 41, "Output",
  CellTags->"OtherCycle"]
}, Open  ]],
Cell[296930, 7168, 289, 6, 62, "Text",
  CellTags->"OtherCycle"],
Cell[297222, 7176, 3332, 96, 120, "DefinitionBox",
  CellTags->{"OtherCycle", "i:18"}],
Cell[300557, 7274, 96, 1, 14, "Caption",
  CellTags->"OtherCycle"],
Cell[300656, 7277, 138, 3, 28, "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{
Cell[300819, 7284, 157, 4, 43, "Input",
  CellTags->"OtherCycle"],
Cell[300979, 7290, 194, 4, 41, "Output",
  CellTags->"OtherCycle"]
}, Open  ]],
Cell[301188, 7297, 190, 5, 42, "MathCaption",
  CellTags->"OtherCycle"],

Cell[CellGroupData[{
Cell[301403, 7306, 416, 10, 107, "Input",
  CellTags->"OtherCycle"],
Cell[301822, 7318, 758, 17, 118, "Output",
  CellTags->"OtherCycle"]
}, Open  ]],
Cell[302595, 7338, 90, 1, 48, "Subsubsection",
  CellTags->{"Stabilizers", "i:19"}],
Cell[302688, 7341, 424, 13, 64, "Text",
  CellTags->"Stabilizers"],
Cell[303115, 7356, 6321, 185, 153, "DefinitionBox",
  CellTags->"Stabilizers"],
Cell[309439, 7543, 191, 8, 14, "Caption",
  CellTags->"Stabilizers"],
Cell[309633, 7553, 174, 6, 28, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[309832, 7563, 184, 5, 27, "Input",
  CellTags->"Stabilizers"],
Cell[310019, 7570, 90, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[310124, 7576, 138, 5, 29, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[310287, 7585, 109, 3, 27, "Input",
  CellTags->"Stabilizers"],
Cell[310399, 7590, 87, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[310501, 7596, 135, 4, 28, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[310661, 7604, 512, 13, 75, "Input",
  CellTags->"Stabilizers"],
Cell[311176, 7619, 98, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[311289, 7625, 507, 21, 48, "Text",
  CellTags->"Stabilizers"],
Cell[311799, 7648, 9561, 276, 180, "DefinitionBox",
  CellTags->{"Stabilizers", "i:20"}],
Cell[321363, 7926, 86, 1, 14, "Caption",
  CellTags->"Stabilizers"],
Cell[321452, 7929, 380, 15, 42, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[321857, 7948, 396, 9, 107, "Input",
  CellTags->"Stabilizers"],
Cell[322256, 7959, 289, 5, 86, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[322560, 7967, 173, 6, 28, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[322758, 7977, 110, 3, 27, "Input",
  CellTags->"Stabilizers"],
Cell[322871, 7982, 95, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[322981, 7988, 244, 7, 42, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[323250, 7999, 138, 3, 43, "Input",
  CellTags->"Stabilizers"],
Cell[323391, 8004, 104, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[323510, 8010, 160, 4, 42, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[323695, 8018, 115, 3, 27, "Input",
  CellTags->"Stabilizers"],
Cell[323813, 8023, 138, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[323966, 8029, 259, 8, 42, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[324250, 8041, 153, 4, 43, "Input",
  CellTags->"Stabilizers"],
Cell[324406, 8047, 138, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[324559, 8053, 153, 5, 29, "MathCaption",
  CellTags->"Stabilizers"],

Cell[CellGroupData[{
Cell[324737, 8062, 121, 3, 27, "Input",
  CellTags->"Stabilizers"],
Cell[324861, 8067, 138, 3, 26, "Output",
  CellTags->"Stabilizers"]
}, Open  ]],
Cell[325014, 8073, 216, 7, 58, "Subsection",
  CellTags->{"BasicZ", "i:21"}],
Cell[325233, 8082, 68, 1, 48, "Subsubsection",
  CellTags->"BasicZ"],
Cell[325304, 8085, 731, 18, 114, "Text",
  CellTags->"BasicZ"],
Cell[326038, 8105, 12639, 355, 325, "DefinitionBox",
  CellTags->{"BasicZ", "i:22"}],
Cell[338680, 8462, 57, 1, 14, "Caption",
  CellTags->"BasicZ"],
Cell[338740, 8465, 182, 6, 32, "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{
Cell[338947, 8475, 198, 5, 54, "Input",
  CellTags->"BasicZ"],
Cell[339148, 8482, 119, 3, 26, "Output",
  CellTags->"BasicZ"]
}, Open  ]],
Cell[339282, 8488, 217, 9, 32, "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{
Cell[339524, 8501, 135, 3, 33, "Input",
  CellTags->"BasicZ"],
Cell[339662, 8506, 109, 3, 32, "Output",
  CellTags->"BasicZ"]
}, Open  ]],
Cell[339786, 8512, 186, 6, 32, "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{
Cell[339997, 8522, 147, 4, 33, "Input",
  CellTags->"BasicZ"],
Cell[340147, 8528, 106, 3, 26, "Output",
  CellTags->"BasicZ"]
}, Open  ]],
Cell[340268, 8534, 196, 6, 32, "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{
Cell[340489, 8544, 127, 3, 33, "Input",
  CellTags->"BasicZ"],
Cell[340619, 8549, 96, 3, 29, "Output",
  CellTags->"BasicZ"]
}, Open  ]],
Cell[340730, 8555, 350, 12, 46, "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{
Cell[341105, 8571, 119, 3, 33, "Input",
  CellTags->"BasicZ"],
Cell[341227, 8576, 85, 3, 26, "Output",
  CellTags->"BasicZ"]
}, Open  ]],
Cell[341327, 8582, 85, 1, 28, "MathCaption",
  CellTags->"BasicZ"],

Cell[CellGroupData[{
Cell[341437, 8587, 150, 4, 33, "Input",
  CellTags->"BasicZ"],
Cell[341590, 8593, 100, 3, 26, "Output",
  CellTags->"BasicZ"]
}, Open  ]],
Cell[341705, 8599, 82, 1, 48, "Subsubsection",
  CellTags->{"DivisibilityZ", "i:23"}],
Cell[341790, 8602, 6206, 177, 105, "DefinitionBox",
  CellTags->{"DivisibilityZ", "i:24"}],
Cell[347999, 8781, 97, 1, 14, "Caption",
  CellTags->"DivisibilityZ"],
Cell[348099, 8784, 239, 9, 28, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[348363, 8797, 123, 3, 27, "Input",
  CellTags->"DivisibilityZ"],
Cell[348489, 8802, 101, 3, 26, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[348605, 8808, 114, 2, 28, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[348744, 8814, 138, 3, 27, "Input",
  CellTags->"DivisibilityZ"],
Cell[348885, 8819, 114, 3, 26, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[349014, 8825, 133, 4, 28, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[349172, 8833, 166, 4, 43, "Input",
  CellTags->"DivisibilityZ"],
Cell[349341, 8839, 125, 3, 26, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[349481, 8845, 10504, 291, 205, "DefinitionBox",
  CellTags->{"DivisibilityZ", "i:25"}],
Cell[359988, 9138, 188, 6, 18, "Caption",
  CellTags->"DivisibilityZ"],
Cell[360179, 9146, 12016, 327, 307, "DefinitionBox3Col",
  CellTags->{"DivisibilityZ", "i:26"}],
Cell[372198, 9475, 205, 9, 14, "Caption",
  CellTags->"DivisibilityZ"],
Cell[372406, 9486, 281, 9, 50, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[372712, 9499, 152, 4, 33, "Input",
  CellTags->"DivisibilityZ"],
Cell[372867, 9505, 92, 3, 26, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[372974, 9511, 112, 2, 28, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[373111, 9517, 131, 3, 33, "Input",
  CellTags->"DivisibilityZ"],
Cell[373245, 9522, 92, 3, 26, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[373352, 9528, 249, 7, 46, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[373626, 9539, 121, 3, 33, "Input",
  CellTags->"DivisibilityZ"],
Cell[373750, 9544, 101, 3, 29, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[373866, 9550, 156, 4, 42, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[374047, 9558, 182, 4, 43, "Input",
  CellTags->"DivisibilityZ"],
Cell[374232, 9564, 205, 4, 41, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[374452, 9571, 433, 9, 74, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[374910, 9584, 145, 3, 27, "Input",
  CellTags->"DivisibilityZ"],
Cell[375058, 9589, 191, 4, 54, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[375264, 9596, 393, 12, 59, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[375682, 9612, 229, 5, 59, "Input",
  CellTags->"DivisibilityZ"],
Cell[375914, 9619, 305, 6, 74, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[376234, 9628, 327, 9, 42, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[376586, 9641, 228, 5, 59, "Input",
  CellTags->"DivisibilityZ"],
Cell[376817, 9648, 319, 6, 56, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[377151, 9657, 101, 1, 28, "MathCaption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[377277, 9662, 227, 5, 59, "Input",
  CellTags->"DivisibilityZ"],
Cell[377507, 9669, 329, 6, 56, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[377851, 9678, 3124, 84, 57, "DefinitionBox",
  CellTags->{"DivisibilityZ", "i:27"}],
Cell[380978, 9764, 106, 1, 14, "Caption",
  CellTags->"DivisibilityZ"],

Cell[CellGroupData[{
Cell[381109, 9769, 188, 5, 43, "Input",
  CellTags->"DivisibilityZ"],
Cell[381300, 9776, 152, 4, 26, "Output",
  CellTags->"DivisibilityZ"]
}, Open  ]],
Cell[381467, 9783, 84, 1, 48, "Subsubsection",
  CellTags->{"NormZ", "i:28"}],
Cell[381554, 9786, 12564, 342, 231, "DefinitionBox",
  CellTags->{"NormZ", "i:29"}],
Cell[394121, 10130, 59, 1, 14, "Caption",
  CellTags->"NormZ"],
Cell[394183, 10133, 219, 6, 46, "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{
Cell[394427, 10143, 217, 5, 59, "Input",
  CellTags->"NormZ"],
Cell[394647, 10150, 552, 15, 158, "Output",
  CellTags->"NormZ"]
}, Open  ]],
Cell[395214, 10168, 155, 4, 42, "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{
Cell[395394, 10176, 136, 3, 27, "Input",
  CellTags->"NormZ"],
Cell[395533, 10181, 218, 5, 56, "Output",
  CellTags->"NormZ"]
}, Open  ]],
Cell[395766, 10189, 119, 4, 28, "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{
Cell[395910, 10197, 108, 3, 27, "Input",
  CellTags->"NormZ"],
Cell[396021, 10202, 98, 3, 26, "Output",
  CellTags->"NormZ"]
}, Open  ]],
Cell[396134, 10208, 769, 23, 90, "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{
Cell[396928, 10235, 133, 3, 27, "Input",
  CellTags->"NormZ"],
Cell[397064, 10240, 19531, 865, 137, 9237, 732, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"NormZ"],
Cell[416598, 11107, 165, 4, 41, "Output",
  CellTags->"NormZ"]
}, Open  ]],
Cell[416778, 11114, 422, 11, 60, "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{
Cell[417225, 11129, 114, 3, 27, "Input",
  CellTags->"NormZ"],
Cell[417342, 11134, 157, 4, 32, "Output",
  CellTags->"NormZ"]
}, Open  ]],
Cell[417514, 11141, 188, 6, 32, "MathCaption",
  CellTags->"NormZ"],

Cell[CellGroupData[{
Cell[417727, 11151, 112, 3, 27, "Input",
  CellTags->"NormZ"],
Cell[417842, 11156, 413, 7, 91, "Output",
  CellTags->"NormZ"]
}, Open  ]],
Cell[418270, 11166, 74, 1, 56, "Subsection",
  CellTags->"WorkLists"],
Cell[418347, 11169, 84, 1, 48, "Subsubsection",
  CellTags->{"WorkLists", "i:30"}],
Cell[418434, 11172, 616, 13, 114, "Text",
  CellTags->"WorkLists"],
Cell[419053, 11187, 17945, 519, 322, "DefinitionBox",
  CellTags->{"WorkLists", "i:31"}],
Cell[437001, 11708, 73, 1, 14, "Caption",
  CellTags->"WorkLists"],
Cell[437077, 11711, 294, 9, 58, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[437396, 11724, 207, 6, 72, "Input",
  CellTags->"WorkLists"],
Cell[437606, 11732, 154, 4, 41, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[437775, 11739, 130, 4, 29, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[437930, 11747, 236, 6, 72, "Input",
  CellTags->"WorkLists"],
Cell[438169, 11755, 109, 3, 26, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[438293, 11761, 277, 9, 43, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[438595, 11774, 151, 4, 27, "Input",
  CellTags->"WorkLists"],
Cell[438749, 11780, 213, 4, 41, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[438977, 11787, 169, 4, 42, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[439171, 11795, 233, 5, 59, "Input",
  CellTags->"WorkLists"],
Cell[439407, 11802, 624, 15, 84, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[440046, 11820, 170, 5, 44, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[440241, 11829, 131, 3, 27, "Input",
  CellTags->"WorkLists"],
Cell[440375, 11834, 303, 6, 71, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[440693, 11843, 186, 5, 43, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[440904, 11852, 195, 5, 59, "Input",
  CellTags->"WorkLists"],
Cell[441102, 11859, 415, 11, 42, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[441532, 11873, 122, 4, 28, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[441679, 11881, 241, 6, 59, "Input",
  CellTags->"WorkLists"],
Cell[441923, 11889, 175, 4, 41, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[442113, 11896, 131, 4, 29, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[442269, 11904, 99, 3, 27, "Input",
  CellTags->"WorkLists"],
Cell[442371, 11909, 175, 4, 41, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[442561, 11916, 214, 9, 44, "MathCaption",
  CellTags->"WorkLists"],

Cell[CellGroupData[{
Cell[442800, 11929, 231, 5, 59, "Input",
  CellTags->"WorkLists"],
Cell[443034, 11936, 103, 3, 26, "Output",
  CellTags->"WorkLists"]
}, Open  ]],
Cell[443152, 11942, 90, 1, 48, "Subsubsection",
  CellTags->{"WorkGraphics", "i:32"}],
Cell[443245, 11945, 191, 5, 46, "Text",
  CellTags->"WorkGraphics"],
Cell[443439, 11952, 19387, 524, 267, "DefinitionBox",
  CellTags->{"WorkGraphics", "i:33"}],
Cell[462829, 12478, 83, 1, 14, "Caption",
  CellTags->"WorkGraphics"],
Cell[462915, 12481, 160, 4, 43, "MathCaption",
  CellTags->"WorkGraphics"],

Cell[CellGroupData[{
Cell[463100, 12489, 131, 3, 27, "Input",
  CellTags->"WorkGraphics"],
Cell[463234, 12494, 48381, 659, 282, 1110, 70, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"WorkGraphics"]
}, Open  ]],
Cell[511630, 13156, 249, 8, 43, "MathCaption",
  CellTags->"WorkGraphics"],

Cell[CellGroupData[{
Cell[511904, 13168, 120, 3, 27, "Input",
  CellTags->"WorkGraphics"],
Cell[512027, 13173, 21732, 405, 139, 2630, 164, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"WorkGraphics"],
Cell[533762, 13580, 224, 4, 67, "Print",
  CellTags->"WorkGraphics"],
Cell[533989, 13586, 102, 3, 26, "Output",
  CellTags->"WorkGraphics"]
}, Open  ]],
Cell[534106, 13592, 69, 1, 48, "Subsubsection",
  CellTags->{"Adjoin", "i:34"}],
Cell[534178, 13595, 1783, 49, 187, "Text",
  CellTags->"Adjoin"],
Cell[535964, 13646, 10282, 294, 182, "DefinitionBox",
  CellTags->"Adjoin"],
Cell[546249, 13942, 134, 6, 14, "Caption",
  CellTags->"Adjoin"],
Cell[546386, 13950, 154, 6, 32, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[546565, 13960, 104, 3, 33, "Input",
  CellTags->"Adjoin"],
Cell[546672, 13965, 196, 4, 54, "Output",
  CellTags->"Adjoin"]
}, Open  ]],
Cell[546883, 13972, 140, 4, 42, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[547048, 13980, 102, 3, 27, "Input",
  CellTags->"Adjoin"],
Cell[547153, 13985, 90, 3, 26, "Output",
  CellTags->"Adjoin"]
}, Open  ]],
Cell[547258, 13991, 92, 1, 28, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[547375, 13996, 132, 4, 47, "Input",
  CellTags->"Adjoin"],
Cell[547510, 14002, 389, 7, 62, "Output",
  CellTags->"Adjoin"]
}, Open  ]],
Cell[547914, 14012, 238, 6, 42, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[548177, 14022, 112, 3, 33, "Input",
  CellTags->"Adjoin"],
Cell[548292, 14027, 259, 5, 73, "Output",
  CellTags->"Adjoin"]
}, Open  ]],
Cell[548566, 14035, 100, 1, 28, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[548691, 14040, 113, 3, 31, "Input",
  CellTags->"Adjoin"],
Cell[548807, 14045, 242, 6, 40, "Output",
  CellTags->"Adjoin"]
}, Open  ]],
Cell[549064, 14054, 182, 5, 42, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[549271, 14063, 174, 5, 27, "Input",
  CellTags->"Adjoin"],
Cell[549448, 14070, 200, 4, 28, "Output",
  CellTags->"Adjoin"]
}, Open  ]],
Cell[549663, 14077, 415, 11, 56, "MathCaption",
  CellTags->"Adjoin"],

Cell[CellGroupData[{
Cell[550103, 14092, 155, 4, 43, "Input",
  CellTags->"Adjoin"],
Cell[550261, 14098, 285, 6, 57, "Output"]
}, Open  ]],
Cell[550561, 14107, 94, 1, 48, "Subsubsection",
  CellTags->{"Disguising", "i:35"}],
Cell[550658, 14110, 460, 12, 79, "Text",
  CellTags->"Disguising"],
Cell[551121, 14124, 6991, 194, 180, "DefinitionBox",
  CellTags->{"Disguising", "i:36"}],
Cell[558115, 14320, 78, 1, 14, "Caption",
  CellTags->"Disguising"],

Cell[CellGroupData[{
Cell[558218, 14325, 415, 8, 123, "Input",
  CellTags->"Disguising"],
Cell[558636, 14335, 43484, 1041, 159, 10874, 632, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Disguising"]
}, Open  ]],
Cell[602135, 15379, 158, 5, 48, "Subsubsection",
  CellTags->{"LabCode", "i:37"}],
Cell[602296, 15386, 7083, 195, 172, "DefinitionBox",
  CellTags->{"LabCode", "i:38"}],
Cell[609382, 15583, 168, 6, 14, "Caption",
  CellTags->"LabCode"],
Cell[609553, 15591, 251, 8, 42, "MathCaption",
  CellTags->"LabCode"],

Cell[CellGroupData[{
Cell[609829, 15603, 110, 3, 27, "Input",
  CellTags->"LabCode"],
Cell[609942, 15608, 148, 3, 41, "Output"]
}, Open  ]],
Cell[610105, 15614, 118, 4, 28, "MathCaption",
  CellTags->"LabCode"],

Cell[CellGroupData[{
Cell[610248, 15622, 110, 3, 27, "Input",
  CellTags->"LabCode"],

Cell[CellGroupData[{
Cell[610383, 15629, 10749, 331, 186, 4175, 245, "GraphicsData", 
"PostScript", "Graphics"],
Cell[621135, 15962, 16042, 330, 296, 2363, 156, "GraphicsData", 
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]],
Cell[637204, 16296, 65, 1, 48, "Subsubsection",
  CellTags->"Potpourri"],
Cell[637272, 16299, 8862, 247, 165, "DefinitionBox",
  CellTags->{"Potpourri", "i:39"}],
Cell[646137, 16548, 68, 1, 14, "Caption",
  CellTags->"Potpourri"],
Cell[646208, 16551, 142, 4, 42, "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{
Cell[646375, 16559, 172, 4, 43, "Input",
  CellTags->"Potpourri"],
Cell[646550, 16565, 110, 3, 26, "Output",
  CellTags->"Potpourri"]
}, Open  ]],
Cell[646675, 16571, 121, 4, 28, "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{
Cell[646821, 16579, 111, 3, 27, "Input",
  CellTags->"Potpourri"],
Cell[646935, 16584, 459, 13, 26, "Output",
  CellTags->"Potpourri"]
}, Open  ]],
Cell[647409, 16600, 153, 5, 29, "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{
Cell[647587, 16609, 241, 5, 59, "Input",
  CellTags->"Potpourri"],
Cell[647831, 16616, 4405, 119, 116, 1265, 74, "GraphicsData", 
"PostScript", "Graphics",
  CellTags->"Potpourri"]
}, Open  ]],
Cell[652251, 16738, 254, 7, 44, "MathCaption",
  CellTags->"Potpourri"],

Cell[CellGroupData[{
Cell[652530, 16749, 106, 3, 26, "Input",
  CellTags->"Potpourri"],
Cell[652639, 16754, 184, 4, 35, "Output",
  CellTags->"Potpourri"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

