(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     25439,        993]*)
(*NotebookOutlinePosition[     26331,       1022]*)
(*  CellTagsIndexPosition[     26287,       1018]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  PageWidth->WindowWidth,
  ScriptMinSize->9],

Cell[StyleData[All, "Presentation"],
  PageWidth->WindowWidth,
  ScriptMinSize->12,
  FontSize->14],

Cell[StyleData[All, "Condensed"],
  PageWidth->WindowWidth,
  CellBracketOptions->{"Margins"->{1, 1},
  "Widths"->{0, 5}},
  ScriptMinSize->8,
  FontSize->11],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  ScriptMinSize->5,
  FontSize->10,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  CellFrameLabelMargins->6,
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellFrame->True,
  CellMargins->{{12, Inherited}, {20, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[1]],

Cell[StyleData["Title", "Presentation"],
  CellFrame->True,
  CellMargins->{{24, 10}, {20, 40}},
  LineSpacing->{1, 0},
  Background->GrayLevel[1]],

Cell[StyleData["Title", "Condensed"],
  CellFrame->True,
  CellMargins->{{8, 10}, {4, 8}},
  FontSize->20,
  Background->GrayLevel[1]],

Cell[StyleData["Title", "Printout"],
  CellFrame->True,
  CellMargins->{{2, 10}, {15, 30}},
  FontSize->24,
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{12, Inherited}, {10, 15}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Presentation"],
  CellMargins->{{24, 10}, {15, 20}},
  TextAlignment->Center,
  LineSpacing->{1, 0},
  FontFamily->"Times",
  FontSize->36,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Condensed"],
  CellMargins->{{8, 10}, {4, 4}},
  TextAlignment->Center,
  FontFamily->"Times",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subtitle", "Printout"],
  CellMargins->{{2, 10}, {10, 15}},
  TextAlignment->Center,
  FontFamily->"Times",
  FontSize->18,
  FontSlant->"Italic"]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{12, Inherited}, {10, 20}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  TextAlignment->Center,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Times",
  FontSize->24,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Presentation"],
  CellMargins->{{24, 10}, {10, 20}},
  LineSpacing->{1, 0},
  FontSize->36],

Cell[StyleData["Subsubtitle", "Condensed"],
  CellMargins->{{8, 10}, {8, 12}},
  FontSize->20],

Cell[StyleData["Subsubtitle", "Printout"],
  CellMargins->{{2, 10}, {8, 10}},
  FontSize->24]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{25, Inherited}, {8, 24}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontFamily->"Times",
  FontSize->18,
  FontWeight->"Bold"],

Cell[StyleData["Section", "Presentation"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{40, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontFamily->"Times",
  FontSize->24],

Cell[StyleData["Section", "Condensed"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{18, Inherited}, {6, 12}},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["Section", "Printout"],
  CellDingbat->"\[GraySquare]",
  CellMargins->{{13, 0}, {7, 22}},
  FontFamily->"Times",
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{22, Inherited}, {8, 20}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Presentation"],
  CellMargins->{{36, 10}, {11, 32}},
  LineSpacing->{1, 0},
  FontSize->22],

Cell[StyleData["Subsection", "Condensed"],
  CellMargins->{{16, Inherited}, {6, 12}},
  FontSize->12],

Cell[StyleData["Subsection", "Printout"],
  CellMargins->{{9, 0}, {7, 22}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{22, Inherited}, {8, 18}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CounterIncrements->"Subsubsection",
  FontWeight->"Bold"],

Cell[StyleData["Subsubsection", "Presentation"],
  CellMargins->{{34, 10}, {11, 26}},
  LineSpacing->{1, 0},
  FontSize->18],

Cell[StyleData["Subsubsection", "Condensed"],
  CellMargins->{{17, Inherited}, {6, 12}},
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"],
  CellMargins->{{9, 0}, {7, 14}},
  FontSize->11]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellMargins->{{12, 10}, {7, 7}},
  LineSpacing->{1, 3},
  CounterIncrements->"Text",
  FontSize->14],

Cell[StyleData["Text", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["Text", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["Text", "Printout"],
  CellMargins->{{2, 2}, {6, 6}},
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{12, 10}, {6, 6}},
  LineSpacing->{1, 3},
  CounterIncrements->"SmallText",
  FontFamily->"Times",
  FontSize->10],

Cell[StyleData["SmallText", "Presentation"],
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontFamily->"Times",
  FontSize->12],

Cell[StyleData["SmallText", "Condensed"],
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontFamily->"Times",
  FontSize->9],

Cell[StyleData["SmallText", "Printout"],
  CellMargins->{{2, 2}, {5, 5}},
  FontFamily->"Times",
  FontSize->10]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["unique styles", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Question"],
  Deletable->False,
  CellFrame->True,
  CellMargins->{{12, 10}, {6, 6}},
  Evaluatable->False,
  LineSpacing->{1, 3},
  FontFamily->"Times",
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[StyleData["Question", "Presentation"],
  CellFrame->True,
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->16],

Cell[StyleData["Question", "Condensed"],
  CellFrame->True,
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->12],

Cell[StyleData["Question", "Printout"],
  CellFrame->True,
  CellMargins->{{2, 2}, {5, 5}},
  FontSize->12]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Answer"],
  Deletable->False,
  CellFrame->True,
  CellMargins->{{12, 10}, {6, 6}},
  Evaluatable->False,
  LineSpacing->{1, 3},
  FontFamily->"Times",
  FontSize->14,
  FontColor->RGBColor[0, 0, 1],
  Background->GrayLevel[0.8]],

Cell[StyleData["Answer", "Presentation"],
  CellFrame->True,
  CellMargins->{{24, 10}, {8, 8}},
  LineSpacing->{1, 5},
  FontSize->16,
  Background->GrayLevel[0.800015]],

Cell[StyleData["Answer", "Condensed"],
  CellFrame->True,
  CellMargins->{{8, 10}, {5, 5}},
  LineSpacing->{1, 2},
  FontSize->12,
  Background->GrayLevel[0.800015]],

Cell[StyleData["Answer", "Printout"],
  CellFrame->True,
  CellMargins->{{2, 2}, {5, 5}},
  FontFamily->"Times",
  FontSize->12,
  Background->GrayLevel[0.800015]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{45, 10}, {5, 7}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold"],

Cell[StyleData["Input", "Presentation"],
  CellMargins->{{72, Inherited}, {8, 10}},
  LineSpacing->{1, 0}],

Cell[StyleData["Input", "Condensed"],
  CellMargins->{{40, 10}, {2, 3}}],

Cell[StyleData["Input", "Printout"],
  CellMargins->{{39, 0}, {4, 6}},
  FontSize->9]
}, Open  ]],

Cell[StyleData["InputOnly"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  DefaultFormatType->DefaultInputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  StyleMenuListing->None,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{47, 10}, {7, 5}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Output"],

Cell[StyleData["Output", "Presentation"],
  CellMargins->{{72, Inherited}, {10, 8}},
  LineSpacing->{1, 0}],

Cell[StyleData["Output", "Condensed"],
  CellMargins->{{41, Inherited}, {3, 2}}],

Cell[StyleData["Output", "Printout"],
  CellMargins->{{39, 0}, {6, 4}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["Message", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0}],

Cell[StyleData["Message", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Message", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8,
  FontColor->GrayLevel[0]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{11, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  AutoItalicWords->{},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  FontSize->14],

Cell[StyleData["Print", "Presentation"],
  CellMargins->{{72, Inherited}, {Inherited, Inherited}},
  LineSpacing->{1, 0},
  FontSize->16],

Cell[StyleData["Print", "Condensed"],
  CellMargins->{{41, Inherited}, {Inherited, Inherited}}],

Cell[StyleData["Print", "Printout"],
  CellMargins->{{39, Inherited}, {Inherited, Inherited}},
  FontSize->8]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{4, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{43, Inherited}, {Inherited, 0}},
  StyleMenuListing->None],

Cell[StyleData["Graphics", "Presentation"],
  ImageMargins->{{62, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Condensed"],
  ImageSize->{175, 175},
  ImageMargins->{{38, Inherited}, {Inherited, 0}}],

Cell[StyleData["Graphics", "Printout"],
  ImageSize->{250, 250},
  ImageMargins->{{30, Inherited}, {Inherited, 0}},
  FontSize->9]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0, 0, 1]],

Cell[StyleData["CellLabel", "Presentation"],
  FontSize->12],

Cell[StyleData["CellLabel", "Condensed"],
  FontSize->9],

Cell[StyleData["CellLabel", "Printout"],
  FontFamily->"Courier",
  FontSize->8,
  FontSlant->"Italic",
  FontColor->GrayLevel[0]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Formulas and Programming", "Section"],

Cell[CellGroupData[{

Cell[StyleData["InlineFormula"],
  CellMargins->{{10, 4}, {0, 8}},
  CellHorizontalScrolling->True,
  ScriptLevel->1,
  SingleLetterItalics->True,
  FontSize->14],

Cell[StyleData["InlineFormula", "Presentation"],
  CellMargins->{{24, 10}, {10, 10}},
  LineSpacing->{1, 5}],

Cell[StyleData["InlineFormula", "Condensed"],
  CellMargins->{{8, 10}, {6, 6}},
  LineSpacing->{1, 1}],

Cell[StyleData["InlineFormula", "Printout"],
  CellMargins->{{2, 0}, {6, 6}}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["DisplayFormula"],
  CellMargins->{{42, Inherited}, {Inherited, Inherited}},
  CellHorizontalScrolling->True,
  ScriptLevel->0,
  SingleLetterItalics->True,
  StyleMenuListing->None,
  UnderoverscriptBoxOptions->{LimitsPositioning->True}],

Cell[StyleData["DisplayFormula", "Presentation"],
  LineSpacing->{1, 5}],

Cell[StyleData["DisplayFormula", "Condensed"],
  LineSpacing->{1, 1}],

Cell[StyleData["DisplayFormula", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles for Headers and Footers", "Section"],

Cell[StyleData["Header"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontSize->10,
  FontSlant->"Italic"],

Cell[StyleData["Footer"],
  CellMargins->{{0, 0}, {0, 4}},
  StyleMenuListing->None,
  FontSize->9,
  FontSlant->"Italic"],

Cell[StyleData["PageNumber"],
  CellMargins->{{0, 0}, {4, 1}},
  StyleMenuListing->None,
  FontFamily->"Times",
  FontSize->10]
}, Closed]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Closed]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Presentation"]],

Cell[StyleData["Hyperlink", "Condensed"]],

Cell[StyleData["Hyperlink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Presentation"]],

Cell[StyleData["MainBookLink", "Condensed"]],

Cell[StyleData["MainBookLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Presentation"]],

Cell[StyleData["AddOnsLink", "Condensed"]],

Cell[StyleData["AddOnLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuideLink", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Presentation"]],

Cell[StyleData["RefGuideLink", "Condensed"]],

Cell[StyleData["RefGuideLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Presentation"]],

Cell[StyleData["GettingStartedLink", "Condensed"]],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Presentation"]],

Cell[StyleData["OtherInformationLink", "Condensed"]],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Placeholder Styles", "Section"],

Cell["\<\
The cells below define styles useful for making placeholder objects \
in palette templates.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Placeholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->True,
  StyleMenuListing->None],

Cell[StyleData["Placeholder", "Presentation"]],

Cell[StyleData["Placeholder", "Condensed"]],

Cell[StyleData["Placeholder", "Printout"]]
}, Closed]],

Cell[CellGroupData[{

Cell[StyleData["SelectionPlaceholder"],
  Editable->False,
  Selectable->False,
  StyleBoxAutoDelete->True,
  Placeholder->Primary,
  StyleMenuListing->None,
  DrawHighlighted->True],

Cell[StyleData["SelectionPlaceholder", "Presentation"]],

Cell[StyleData["SelectionPlaceholder", "Condensed"]],

Cell[StyleData["SelectionPlaceholder", "Printout"]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FormatType Styles", "Section"],

Cell["\<\
The cells below define styles that are mixed in with the styles of \
most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options.\
\>", "Text"],

Cell[StyleData["CellExpression"],
  PageWidth->Infinity,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  ShowSpecialCharacters->False,
  AllowInlineCells->False,
  AutoItalicWords->{},
  StyleMenuListing->None,
  FontFamily->"Courier",
  Background->GrayLevel[1]],

Cell[StyleData["InputForm"],
  AllowInlineCells->False,
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["OutputForm"],
  PageWidth->Infinity,
  TextAlignment->Left,
  LineSpacing->{1, -5},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["StandardForm"],
  LineSpacing->{1.25, 0},
  StyleMenuListing->None,
  FontFamily->"Courier"],

Cell[StyleData["TraditionalForm"],
  LineSpacing->{1.25, 0},
  SingleLetterItalics->True,
  TraditionalFunctionNotation->True,
  DelimiterMatching->None,
  StyleMenuListing->None],

Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],

Cell[StyleData["InlineCell"],
  TextAlignment->Left,
  ScriptLevel->1,
  StyleMenuListing->None],

Cell[StyleData["InlineCellEditing"],
  StyleMenuListing->None,
  Background->RGBColor[1, 0.749996, 0.8]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
CellGrouping->Manual,
WindowSize->{561, 406},
WindowMargins->{{17, Automatic}, {Automatic, 24}},
ShowGroupOpenCloseIcon->True,
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 37, 0, 62, "Subtitle"],
Cell[1771, 53, 193, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[1989, 61, 42, 0, 50, "Section"],
Cell[2034, 63, 77, 2, 36, 31, 0, "StyleData", "All", "Working"],
Cell[2114, 67, 99, 3, 39, 36, 0, "StyleData", "All", "Presentation"],
Cell[2216, 72, 158, 5, 35, 33, 0, "StyleData", "All", "Condensed"],
Cell[2377, 79, 140, 4, 34, 32, 0, "StyleData", "All", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[2554, 88, 35, 0, 30, "Section"],
Cell[2592, 90, 101, 3, 30, "Text"],
Cell[2696, 95, 426, 11, 36, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[3159, 111, 38, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[3222, 115, 422, 12, 90, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[3647, 129, 147, 4, 120, 40, 0, "StyleData", "Title", "Presentation"],
Cell[3797, 135, 134, 4, 64, 37, 0, "StyleData", "Title", "Condensed"],
Cell[3934, 141, 135, 4, 105, 36, 0, "StyleData", "Title", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4106, 150, 359, 10, 68, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[4468, 162, 190, 6, 87, 43, 0, "StyleData", "Subtitle", "Presentation"],
Cell[4661, 170, 161, 5, 39, 40, 0, "StyleData", "Subtitle", "Condensed"],
Cell[4825, 177, 162, 5, 61, 39, 0, "StyleData", "Subtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5024, 187, 338, 9, 57, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[5365, 198, 122, 3, 82, 46, 0, "StyleData", "Subsubtitle", 
"Presentation"],
Cell[5490, 203, 94, 2, 56, 43, 0, "StyleData", "Subsubtitle", "Condensed"],
Cell[5587, 207, 93, 2, 61, 42, 0, "StyleData", "Subsubtitle", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[5717, 214, 330, 9, 49, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[6050, 225, 173, 5, 87, 42, 0, "StyleData", "Section", "Presentation"],
Cell[6226, 232, 153, 4, 48, 39, 0, "StyleData", "Section", "Condensed"],
Cell[6382, 238, 144, 4, 61, 38, 0, "StyleData", "Section", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[6563, 247, 301, 8, 44, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[6867, 257, 121, 3, 81, 45, 0, "StyleData", "Subsection", 
"Presentation"],
Cell[6991, 262, 101, 2, 48, 42, 0, "StyleData", "Subsection", "Condensed"],
Cell[7095, 266, 91, 2, 59, 41, 0, "StyleData", "Subsection", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[7223, 273, 245, 6, 42, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[7471, 281, 124, 3, 71, 48, 0, "StyleData", "Subsubsection", 
"Presentation"],
Cell[7598, 286, 104, 2, 44, 45, 0, "StyleData", "Subsubsection", 
"Condensed"],
Cell[7705, 290, 94, 2, 48, 44, 0, "StyleData", "Subsubsection", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7848, 298, 39, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[7912, 302, 126, 4, 45, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[8041, 308, 115, 3, 52, 39, 0, "StyleData", "Text", "Presentation"],
Cell[8159, 313, 93, 2, 43, 36, 0, "StyleData", "Text", "Condensed"],
Cell[8255, 317, 84, 2, 40, 35, 0, "StyleData", "Text", "Printout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8376, 324, 159, 5, 39, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[8538, 331, 141, 4, 44, 44, 0, "StyleData", "SmallText", "Presentation"],
Cell[8682, 337, 136, 4, 36, 41, 0, "StyleData", "SmallText", "Condensed"],
Cell[8821, 343, 112, 3, 37, 40, 0, "StyleData", "SmallText", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8982, 352, 32, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[9039, 356, 220, 8, 59, 27, 0, "StyleData", "Question", "All"],
Cell[9262, 366, 136, 4, 64, 43, 0, "StyleData", "Question", "Presentation"],
Cell[9401, 372, 132, 4, 54, 40, 0, "StyleData", "Question", "Condensed"],
Cell[9536, 378, 107, 3, 54, 39, 0, "StyleData", "Question", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[9680, 386, 245, 9, 57, 25, 0, "StyleData", "Answer", "All"],
Cell[9928, 397, 169, 5, 64, 41, 0, "StyleData", "Answer", "Presentation"],
Cell[10100, 404, 165, 5, 54, 38, 0, "StyleData", "Answer", "Condensed"],
Cell[10268, 411, 163, 5, 54, 37, 0, "StyleData", "Answer", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10480, 422, 42, 0, 30, "Section"],
Cell[10525, 424, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[10798, 433, 467, 14, 41, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[11268, 449, 106, 2, 47, 40, 0, "StyleData", "Input", "Presentation"],
Cell[11377, 453, 72, 1, 34, 37, 0, "StyleData", "Input", "Condensed"],
Cell[11452, 456, 85, 2, 35, 36, 0, "StyleData", "Input", "Printout"]
}, Open  ]],
Cell[11552, 461, 342, 11, 37, 28, 0, "StyleData", "InputOnly", "All",
  CounterIncrements->"Input",
  StyleMenuListing->None],

Cell[CellGroupData[{
Cell[11919, 476, 454, 13, 40, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[12376, 491, 107, 2, 46, 41, 0, "StyleData", "Output", "Presentation"],
Cell[12486, 495, 80, 1, 33, 38, 0, "StyleData", "Output", "Condensed"],
Cell[12569, 498, 86, 2, 36, 37, 0, "StyleData", "Output", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[12692, 505, 501, 14, 36, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[13196, 521, 123, 2, 36, 42, 0, "StyleData", "Message", "Presentation"],
Cell[13322, 525, 97, 1, 36, 39, 0, "StyleData", "Message", "Condensed"],
Cell[13422, 528, 138, 3, 32, 38, 0, "StyleData", "Message", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[13597, 536, 514, 15, 39, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[14114, 553, 137, 3, 40, 40, 0, "StyleData", "Print", "Presentation"],
Cell[14254, 558, 95, 1, 39, 37, 0, "StyleData", "Print", "Condensed"],
Cell[14352, 561, 109, 2, 32, 36, 0, "StyleData", "Print", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[14498, 568, 439, 12, 36, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics",
  StyleMenuListing->None],
Cell[14940, 582, 94, 1, 36, 43, 0, "StyleData", "Graphics", "Presentation"],
Cell[15037, 585, 116, 2, 36, 40, 0, "StyleData", "Graphics", "Condensed"],
Cell[15156, 589, 130, 3, 34, 39, 0, "StyleData", "Graphics", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[15323, 597, 128, 4, 34, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[15454, 603, 60, 1, 70, 44, 0, "StyleData", "CellLabel", "Presentation"],
Cell[15517, 606, 56, 1, 70, 41, 0, "StyleData", "CellLabel", "Condensed"],
Cell[15576, 609, 130, 4, 70, 40, 0, "StyleData", "CellLabel", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15755, 619, 43, 0, 30, "Section"],

Cell[CellGroupData[{
Cell[15823, 623, 162, 5, 39, 32, 0, "StyleData", "InlineFormula", "All"],
Cell[15988, 630, 108, 2, 51, 48, 0, "StyleData", "InlineFormula", 
"Presentation"],
Cell[16099, 634, 102, 2, 43, 45, 0, "StyleData", "InlineFormula", 
"Condensed"],
Cell[16204, 638, 77, 1, 43, 44, 0, "StyleData", "InlineFormula", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[16318, 644, 253, 6, 36, 33, 0, "StyleData", "DisplayFormula", "All",
  StyleMenuListing->None],
Cell[16574, 652, 72, 1, 36, 49, 0, "StyleData", "DisplayFormula", 
"Presentation"],
Cell[16649, 655, 69, 1, 36, 46, 0, "StyleData", "DisplayFormula", 
"Condensed"],
Cell[16721, 658, 45, 0, 36, 45, 0, "StyleData", "DisplayFormula", "Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16815, 664, 49, 0, 30, "Section"],
Cell[16867, 666, 123, 4, 31, 25, 0, "StyleData", "Header", "All",
  StyleMenuListing->None],
Cell[16993, 672, 122, 4, 29, 25, 0, "StyleData", "Footer", "All",
  StyleMenuListing->None],
Cell[17118, 678, 127, 4, 32, 29, 0, "StyleData", "PageNumber", "All",
  StyleMenuListing->None]
}, Closed]],

Cell[CellGroupData[{
Cell[17282, 687, 33, 0, 30, "Section"],
Cell[17318, 689, 121, 3, 30, "Text"],
Cell[17442, 694, 226, 5, 36, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17671, 701, 295, 7, 36, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17969, 710, 400, 9, 36, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18372, 721, 387, 9, 36, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18762, 732, 401, 9, 36, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Closed]],

Cell[CellGroupData[{
Cell[19200, 746, 35, 0, 30, "Section"],
Cell[19238, 748, 184, 4, 46, "Text"],

Cell[CellGroupData[{
Cell[19447, 756, 302, 8, 36, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19752, 766, 44, 0, 70, 44, 0, "StyleData", "Hyperlink", "Presentation"],
Cell[19799, 768, 41, 0, 70, 41, 0, "StyleData", "Hyperlink", "Condensed"],
Cell[19843, 770, 107, 2, 70, 40, 0, "StyleData", "Hyperlink", "Printout"]
}, Closed]],
Cell[19965, 775, 104, 3, 27, "Text"],

Cell[CellGroupData[{
Cell[20094, 782, 316, 8, 36, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20413, 792, 47, 0, 70, 47, 0, "StyleData", "MainBookLink", 
"Presentation"],
Cell[20463, 794, 44, 0, 70, 44, 0, "StyleData", "MainBookLink", "Condensed"],
Cell[20510, 796, 110, 2, 70, 43, 0, "StyleData", "MainBookLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[20657, 803, 337, 9, 36, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20997, 814, 45, 0, 36, 45, 0, "StyleData", "AddOnsLink", 
"Presentation"],
Cell[21045, 816, 42, 0, 36, 42, 0, "StyleData", "AddOnsLink", "Condensed"],
Cell[21090, 818, 107, 2, 36, 40, 0, "StyleData", "AddOnLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21234, 825, 345, 9, 36, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21582, 836, 47, 0, 70, 47, 0, "StyleData", "RefGuideLink", 
"Presentation"],
Cell[21632, 838, 44, 0, 70, 44, 0, "StyleData", "RefGuideLink", "Condensed"],
Cell[21679, 840, 110, 2, 70, 43, 0, "StyleData", "RefGuideLink", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[21826, 847, 328, 8, 36, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22157, 857, 53, 0, 70, 53, 0, "StyleData", "GettingStartedLink", 
"Presentation"],
Cell[22213, 859, 50, 0, 70, 50, 0, "StyleData", "GettingStartedLink", 
"Condensed"],
Cell[22266, 861, 116, 2, 70, 49, 0, "StyleData", "GettingStartedLink", 
"Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[22419, 868, 332, 8, 36, 39, 0, "StyleData", "OtherInformationLink", 
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22754, 878, 55, 0, 70, 55, 0, "StyleData", "OtherInformationLink", 
"Presentation"],
Cell[22812, 880, 52, 0, 70, 52, 0, "StyleData", "OtherInformationLink", 
"Condensed"],
Cell[22867, 882, 118, 2, 70, 51, 0, "StyleData", "OtherInformationLink", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23034, 890, 37, 0, 30, "Section"],
Cell[23074, 892, 115, 3, 30, "Text"],

Cell[CellGroupData[{
Cell[23214, 899, 145, 5, 36, 30, 0, "StyleData", "Placeholder", "All",
  StyleMenuListing->None],
Cell[23362, 906, 46, 0, 36, 46, 0, "StyleData", "Placeholder", 
"Presentation"],
Cell[23411, 908, 43, 0, 36, 43, 0, "StyleData", "Placeholder", "Condensed"],
Cell[23457, 910, 42, 0, 36, 42, 0, "StyleData", "Placeholder", "Printout"]
}, Closed]],

Cell[CellGroupData[{
Cell[23536, 915, 182, 6, 36, 39, 0, "StyleData", "SelectionPlaceholder", 
"All",
  StyleMenuListing->None],
Cell[23721, 923, 55, 0, 70, 55, 0, "StyleData", "SelectionPlaceholder", 
"Presentation"],
Cell[23779, 925, 52, 0, 70, 52, 0, "StyleData", "SelectionPlaceholder", 
"Condensed"],
Cell[23834, 927, 51, 0, 70, 51, 0, "StyleData", "SelectionPlaceholder", 
"Printout"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23934, 933, 36, 0, 30, "Section"],
Cell[23973, 935, 258, 5, 62, "Text"],
Cell[24234, 942, 298, 9, 36, 33, 0, "StyleData", "CellExpression", "All",
  StyleMenuListing->None],
Cell[24535, 953, 106, 3, 36, 28, 0, "StyleData", "InputForm", "All",
  StyleMenuListing->None],
Cell[24644, 958, 150, 5, 41, 29, 0, "StyleData", "OutputForm", "All",
  StyleMenuListing->None],
Cell[24797, 965, 108, 3, 36, 31, 0, "StyleData", "StandardForm", "All",
  StyleMenuListing->None],
Cell[24908, 970, 179, 5, 36, 34, 0, "StyleData", "TraditionalForm", "All",
  StyleMenuListing->None],
Cell[25090, 977, 115, 3, 30, "Text"],
Cell[25208, 982, 96, 3, 36, 29, 0, "StyleData", "InlineCell", "All",
  StyleMenuListing->None],
Cell[25307, 987, 104, 2, 52, 36, 0, "StyleData", "InlineCellEditing", "All",
  StyleMenuListing->None]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

