(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

(* :Title:  AbstractAlgebra`FiniteFields *)

(* :Context: AbstractAlgebra`FiniteFields` *)

(* :Authors: 	
	Allen C. Hibbard
	hibbarda@central.edu
	http://www.central.edu/homepages/hibbarda/hibbard.html
							 
	Kenneth M. Levasseur
	Levasseuk@woods.uml.edu
	http://www.uml.edu/Dept/Math/LevasseuK.html
			 				*)
			 				
(* :Package Version: 1.0.1 *)

(* :History:
July 6, 1998:
	added error testing for IrreduciblePolynomial;
	added textual mode to GF;
	added error checking in MultiplicativeToAdditive;
*)

(* :Mathematica Version: 2.2 and 3.x *)

(* :Copyright: Copyright 1998, Allen C. Hibbard and 
			 Kenneth M. Levasseur*)


incomingStructure = DefaultStructure;

BeginPackage["AbstractAlgebra`FiniteFields`",
{"AbstractAlgebra`Core`", "AbstractAlgebra`RingProperties`", 
"AbstractAlgebra`RingExtensions`", "AbstractAlgebra`Joint`",
"Graphics`Graphics`",
	"Utilities`FilterOptions`", "Graphics`Colors`"}];

AdditiveToMultiplicative::usage = "AdditiveToMultiplicative[R, add]
returns the multiplicative form of the additive form add in the 
ringoid (typically a Galois field) R.";

ExtensionDegree::usage = "ExtensionDegree[GF[n]] gives the degree of
the extension of GF[n]. In other words, when n is written as n = p^d
for some prime p, d is the ExtensionDegree of GF[n].";

FieldIrreducible::usage = "FieldIrreducible[GF[n]] returns the 
irreducible polynomial used in  establishing the Galois field GF[n].";

GaloisFieldQ::usage = "GaloisFieldQ[R] returns True or False 
depending on whether the ring R is a Galois field and was created
using the GF function.";

GF::usage = "GF[n] returns the Galois field of order n (if n = p^d
for some prime p), while GF[p, d] returns the field of order p^d
(where p is the prime modulus and d is the degree of a irreducible
polynomial to create the field). The field takes the form as a
quotient ring of polynomials over Z[p] mod the ideal generated by
the irreducible polynomial, consequently, consisting of polynomials
of degree less than d. GF[n, poly] or GF[p, d, poly] returns the
finite field using the specified irreducible polynomial. The option
Indeterminate can be used to specify the symbol to be used for the
indeterminate.";

IrreduciblePolynomial::usage = "IrreduciblePolynomial[ind, p, d]
finds an irreducible polynomial in the
indeterminate ind of degree d over the integers mod (prime) p.";

IrreduciblePolyOverZpQ::usage = "IrreduciblePolyOverZpQ[poly, p]
returns True or False depending on whether the polynomial poly is
irreducible over the ring Z[p]. Note that poly can be a standard
Mathematica polynomial in some indeterminate or it can be
constructed from the Poly function in the RingExtensions package.";

MultiplicativeToAdditive::usage = "MultiplicativeToAdditive[R, mult]
returns the additive form of the multiplicative form mult in the
ringoid (typically a Galois field) R.";

PowerList::usage = "PowerList[GF[n]] is equivalent to TableOfPowers,
added for combatibility with the Algebra`FiniteFields` package.";

PrimitivePolynomials::usage = "PrimitivePolynomials[GF[n]] returns
the set of primitive polynomials in GF[n]. (Actually, GF[n] can be
replaced by any ring R and this will return the set of elements that
generate the multiplicative Groupoid of non-zero elements in R.)";

TableOfPowers::usage = "TableOfPowers[GF[n]] returns a table
consisting of first the element {0, 0} followed by pairs of the
form {poly^j, r} where r is an element in GF[n], poly is the 'simplest'
primitive polynomial for this ring, and j is the power to which poly
needs to be raised to be equal to r."; 


GF::notdef = "First define a field by using the GF function.";

GF::badindex = "The index for GF needs to be a power of a prime,
which `1` is not.";

GF::deg = "To form a Galois field GF[`1`^`2`], the polynomial
`3` must of this degree `2`, but this has degree `4`.";

GF::irr = "The polynomial `1` needs to be irreducible over Z[`2`].";

GF::poly = "The expression `1` needs to be a polynomial in the
indeterminate `2`.";

GF::bases = "The polynomial `1` was given over the base ring `2`,
while it should be over the base ring Z[`3`].";

GF::var = "The polynomial `1` and indeterminate `2` do not match.";

IrreduciblePolynomial::badindex = "Bad input: the second parameter,
`1`, for IrreduciblePolynomial needs to be a prime and the third, `2`,
needs to be a positive integer.";

IrreduciblePolyOverZpQ::prime = "The polynomial needs to be over a
prime index, not `1`.";

Begin["`Private`"];

(* ***************** Find Irreducible Polynomial ***************** *)

(* Find an irreducible polynomial modulo p to generate the finite 
   field of p^n elements.  Ideally we will have an irreducible 
   polynomial so that {0,1} is a primitive element.

   'x' is the symbol in which the polynomial is expressed
   'p' is the characteristic of the field
   'degree' is the degree of the polynomial and so the extension *)
   
IrreduciblePolynomial[x_Symbol, p_Integer?PrimeQ, 1] := x;

IrreduciblePolynomial[
    x_Symbol, 
    p_Integer?PrimeQ, 
    degree_Integer?Positive] :=
Module[{irred},
    irred = OneIrreducible[x,p,degree];
    TransformIrreducible[ irred, findprim[irred,p], p]
]

(* added by Al Hibbard July 6, 1998 *)
IrreduciblePolynomial[x_Symbol, p_, degree_] :=
(Message[IrreduciblePolynomial::badindex, p, degree]; $Failed)

(*  OneIrreducible looks for a polynomial which is irreducible mod p
    by a brute force search.  Since the density of such polynomials 
    is reasonably high, the method is not too bad.  The old method,
    factoring a large cyclotomic polynomial, was ok for small fields.
    But when the number of elements in the field grew larger than 
    about 1000, it took too much time and space to factor the 
    polynomial.*)

OneIrreducible[
    x_Symbol, 
    p_Integer?PrimeQ,
    degree_Integer?Positive] :=
Module[{dottbl,i},
    dottbl = x^Range[0,degree-1];
    i = (p^(degree-1));
    While[
        Head[
            Factor[x^degree + dottbl . IntegerDigits[i,p],Modulus->p]
        ] =!= Plus,
        i++
    ];
    x^degree + dottbl . IntegerDigits[i,p]
]

(*  Here we assume we have a monic irreducible polynomial 'irred' 
    and a polynomial 'prim' which is a primitive field element with 
    respect to irred.  To simplify the discussion, let us assume that
    the polynomials are both in x.We are looking for an irreducible 
    polynomial which has x as a primitive element.  So, we want an 
    automorphism of the field which maps the prim to x.  An 
    automorphism of the field is a multiplication-preserving linear 
    transformation of the vector space.  First, we find the linear 
    transformation, then we use it to find the new irreducible.  
    Since prim is primitive, {1,prim,...,prim^(degree-1)} is a basis 
    for the vector space.  The transformation mapping {1,prim,...} to 
    {1,x,...} is given by the inverse of the matrix which maps 
    {1,x,...} to {1,prim,...}.  It is somewhat more natural in 
    Mathematica to work with the transposes of the conventional 
    transformation matrices.Once we have the transformation, we use
    it to find the image of prim^degree.  The irreducible 
    polynomial we want is then just x^degree - image[prim^degree].*)

TransformIrreducible[ irred_, prim_, char_ ] :=
Module[{sym,deg,mat},
    sym = First[Variables[irred]];
    deg = Exponent[irred,sym];
    mat =
        Map[
            Drop[CoefficientList[sym^(deg) + #,sym],-1]&,
            NestList[PolynomialMod[prim #, {irred,char}]&, 1, deg]
        ];
    sym^deg +
        (Mod[-(Last[mat] . Inverse[Drop[mat,-1],Modulus->char]),char] .
        Map[(sym^#)&,Range[0,deg-1]])
]

findprim[ gen_ /; FreeQ[gen,Power], chr_Integer ] := PrimitiveRoot[chr]

findprim[ gen_, chr_Integer ] :=
Module[{deg, mp2, pws, sym, vecs, target, poly},
    sym = Variables[gen][[1]];
    deg = Exponent[gen,sym];
    target = (chr^deg-1)/(chr-1);
    mp2 = Floor[N[Log[2,target]]];
    vecs = Map[
	(Reverse[Drop[IntegerDigits[# + 2^mp2,2],1]])&,
	Map[(target/#[[1]])&,FactorInteger[target]]
    ];
    poly = sym;
    While[
	(
	pws = NestList[PolynomialMod[(# #),{gen,chr}]&,poly,mp2-1];
	Or @@ Map[
	    (Head[
		PolynomialMod[Inner[Power,pws,#,Times], {gen, chr}]
	    ] === Integer)&,
	    vecs
	]),
	poly = Reverse[IntegerDigits[1+(poly/.sym->chr),chr]];
	poly = poly . Map[(sym^#)&,Range[0,Length[poly]-1]];
    ];
    poly
]

(* A primitive element of a field is one whose powers include all 
   elements of the field except 0. PowerList finds a 
   primitive element, then returns a list with the identity first, 
   the primitive element next, and successive powers of the primitive
   element following. The elements of the list are only the data part 
   of the field elements, without all the field information in the 
   head. *)

RingoidQ[R_] := (Head[R]===Ringoid || 
	Head[R]===AbstractAlgebra`Core`Private`ringoid) && 
	Head[First[R]]===List

RingoidQ[many:{_AbstractAlgebra`Core`Private`ringoid..}] := 
	Map[RingoidQ,many]

RingoidQ[many:{_?RingoidQ..}] := Map[RingoidQ,many]

GroupoidQ[G_] := (Head[G]===Groupoid || 
	Head[G]===AbstractAlgebra`Core`Private`groupoid) && 
	Head[First[G]]===List

Options[GF] = {Indeterminate -> Global`x, Mode -> Computational};

GF[n_Integer?Positive, opts___?OptionQ] := Module[{nok, fi, p, d,
	ind = Indeterminate/.Flatten[{opts, Options[GF]}],
	mode = Mode/.Flatten[{opts, Options[GF]}]},
	nok = Length[fi = FactorInteger[n]]==1 && PrimeQ[fi[[1,1]]];
	If[nok,
		{{p,d}} = fi;
		If[mode === Textual, GFTextual[p, d, ind]];
		GF[p, d, opts],
		Message[GF::badindex, n]; $Failed]]

GF[p_?PrimeQ, d_Integer?Positive, opts___?OptionQ] := Module[{
		ind = Indeterminate/.Flatten[{opts, Options[GF]}],
		mode = Mode/.Flatten[{opts, Options[GF]}]},
	If[mode === Textual, GFTextual[p, d, ind]];
	GFWork[p, d, IrreduciblePolynomial[ind, p, d]]]
	
GFWork[p_?PrimeQ, d_Integer?Positive, ipoly_] := GFWork[p, d, ipoly] = 
		Module[{pok, els, var},
	{var} = Variables[ipoly]; 
	els = Adjoin[Z[p, Structure -> Ring], var, d-1];
	FormRingoid[els, PolynomialMod[ #1 + #2, p]&, 
		PolynomialMod[PolynomialRemainder[#1 * #2,ipoly,
		var], p]&, {"+","*"},  WideElements -> True, 
		RingoidName -> "GF["<>ToString[p^d]<>"]", IsARing -> True,
		AbstractAlgebra`Core`Private`ExtraInformation ->
			{{True},{0, 1},{},{},
			{primeUsed -> p, degreeOfExtension -> d, irredPoly -> ipoly}}]]

GFTextual[p_,d_, ind_] := Print["Up to isomorphism, there is one
and only one finite field for each prime power p^d. In this case,
with the prime being "<>ToString[p]<>" and the power being "<>
ToString[d]<>", we have "<>ToString[p^d]<>" elements. For some
irreducible polynomial f("<>ToString[ind]<>") of degree "<>
ToString[d]<>", the elements
in this field are represented as coset representatives in the
quotient ring Z["<>ToString[p]<>"]["<>ToString[ind]<>"]/<f("<>
ToString[ind]<>")>, all of whose elements
are of degree "<>ToString[d-1]<>" or lower. The operations are
ordinary addition and multiplication of these elements, modulo the
given polynomial. Alternative methods of arithmetic may be found
by using the MultiplicativeToAdditive or AdditiveToMultiplicative
functions (or TableOfPowers function)."]

PolyQ[p_] := Head[p] === AbstractAlgebra`RingExtensions`Private`poly

GF[n_Integer?Positive, ipoly_?PolyQ, opts___?OptionQ] := 
Module[{nok, fi, p, d},
	nok = Length[fi = FactorInteger[n]]==1 && PrimeQ[fi[[1,1]]];
	If[nok,
		{{p,d}} = fi;
		GF[p, d, ipoly, opts],
		Message[GF::badindex, n]; $Failed]]
		
GF[p_?PrimeQ, d_Integer?Positive, ipoly_?PolyQ, opts___?OptionQ] := 
	If[BaseRing[ipoly]===Z[p, Structure -> Ring],
		GF[p, d, ToOrdinaryPolynomial[ipoly], opts],
		Message[GF::bases, ipoly, RingoidName[BaseRing[ipoly]], p];
		$Failed]

GF[n_Integer?Positive, ipoly_, opts___?OptionQ] := 
Module[{nok, fi, p, d},
	nok = Length[fi = FactorInteger[n]]==1 && PrimeQ[fi[[1,1]]];
	If[nok,
		{{p,d}} = fi;
		GF[p, d, ipoly, opts],
		Message[GF::badindex, n]; $Failed]]
		
testPoly[p_, d_, var_, ipoly_] :=
	If[PolynomialQ[If[Head[ipoly]===
		AbstractAlgebra`RingExtensions`Private`poly,
			ToOrdinaryPolynomial[ipoly],ipoly], var],
		If[IrreduciblePolyOverZpQ[ipoly,p],
			If[Exponent[ipoly, var] == d, True,
				Message[GF::deg, p, d, ipoly, Exponent[ipoly, var]]; 
				False],
			Message[GF::irr, ipoly, p]; False],
		Message[GF::var, ipoly, var]; False]

GF[p_?PrimeQ, d_Integer?Positive, ipoly_, opts___?OptionQ] := 
		Module[{pok, els, var,
			ind = Indeterminate/.Flatten[{opts, Options[GF]}],
			mode = Mode/.Flatten[{opts, Options[GF]}]},
	{var} = Variables[ipoly];
	pok = testPoly[p, d, var, ipoly];
	If[pok, 
		If[mode === Textual, GFTextual[p, d, ind]];
		GFWork[p, d, ipoly/.var :> ind], $Failed]]

GF[n_, ___] := (Message[GF::badindex, n]; $Failed)

IrreduciblePolyOverZpQ[ipoly_?PolyQ, p_?PrimeQ] := 
	If[BaseRing[ipoly]===Z[p, Structure -> Ring],
		IrreduciblePolyOverZpQ[ToOrdinaryPolynomial[ipoly], p],
		Message[GF::bases, ipoly, RingoidName[BaseRing[ipoly]], p]; 
		$Failed]

IrreduciblePolyOverZpQ[polynom_, p_?PrimeQ] := 
	ModpIrreducibilityQ[p,polynom]

IrreduciblePolyOverZpQ[polynom_, p_] := 
	(Message[IrreduciblePolyOverZpQ::prime, p]; $Failed)
					
PrimitivePolynomials[R_?RingoidQ] := 
Module[{n = Length[Elements[R]] -1, G, ords},
	G = NonZeroMGroupoid[R];
	ords = Map[{#, orderOfElement[G,#]}&, Elements[G]];
	Select[ords, #[[2]]==n&]/.{p_, n} :> p]

TableOfPowers[$Failed] := $Failed

TableOfPowers[R_?RingoidQ] := TableOfPowers[R] = 
Module[{n, prim, p, MG},
		n = Length[Elements[R]];
		MG = NonZeroMGroupoid[R];
		prim = First[PrimitivePolynomials[R]];
		Join[{{0,0}}, Table[{prim^k, ElementToPower[MG, prim, k]},
			{k,1,n-2}], {{1,1}}]]
		
GFInd[R_] := Module[{fourth, var},
	fourth = R[[4]];
	{var} = (AbstractAlgebra`FiniteFields`Private`irredPoly /. 
		fourth[[5]])//Variables;
	var]
	
MultiplicativeToAdditive[R_?RingoidQ, form_] := Module[{top = 
	TableOfPowers[R], pos, ind, pow, ok = True, nform = form},
If[Head[form] === Power, 
	{ind, pow} = List @@ form;
	If[ind =!= GFInd[R], 
		ok = False,
		nform = Power[ind, Mod[pow,Size[R]]]]];
If[ok,
	pos = Position[top//Transpose//First,nform,1];
	If[Length[pos] > 1, $Failed,
		top[[pos[[1,1]]]]//Last],
	Message[GF::var,form,GFInd[R]];$Failed]]
	
AdditiveToMultiplicative[R_?RingoidQ, form_] := Module[{top = 
	TableOfPowers[R], pos},
pos = Position[top//Transpose//Last,form,1];
If[Length[pos] > 1, $Failed,
	top[[pos[[1,1]]]]//First]]

orderOfElement[G_?GroupoidQ, g_] := orderOfElement[G, g] = 
Module[{id, ord},
	If[Not[ElementQ[g,G]],
		Message[MemberQ::elmnt, g, GroupoidName[G]];$Failed,
		If[AbstractAlgebra`Joint`Private`ClosedQAndIdentityQ[G],
			id = GroupIdentity[G];
			ord=Length[Elements[G]];
			If[g===id, 1,
				Length[FixedPointList[Operation[G][g,#]&,g,ord,
 					SameTest ->((#2===id)&)]]//If[#==ord+1,$Failed,#]&], 
 					$Failed]]]

FieldIrreducible[R_?RingoidQ] := 
	irredPoly /. R[[4,5]]

PowerList[args__] := TableOfPowers[args]

ExtensionDegree[R_?RingoidQ] := 
	degreeOfExtension /. R[[4,5]]
	
SetAttributes[FieldIrreducible, HoldFirst];

GaloisFieldQ[R_?RingoidQ] := PrimeQ[primeUsed /. R[[4,5]]]

SetAttributes[BaseRing, HoldFirst];

BaseRing[R_?RingoidQ] := 
	Z[primeUsed /. R[[4,5]], Structure -> Ring]

End[];

Protect[GF];

EndPackage[];

DefaultStructure = incomingStructure;

SwitchStructureTo[DefaultStructure];