(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     38855,       1084]*)
(*NotebookOutlinePosition[     39831,       1115]*)
(*  CellTagsIndexPosition[     39787,       1111]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Table of Contents for GroupLabs", "ContentsTitle"],

Cell[TextData[ButtonBox["Group Lab 1. Using symmetry to uncover a group",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.1"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"1.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.2.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.3.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.4.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.3 Getting started? - begin here",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.5.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.4 A symmetry of an equilateral triangle",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.6.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.5 Are there other symmetries?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.7.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.6 Multiplying our transformations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.8.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.7 Are there any commuters?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.9.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.8 Is it always bad to be closed-minded?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.10.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.9 We should try to find our identity",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.11.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.10 Is it perverse to not have an inverse?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.12.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.11 Should we associate together?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.13.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["test every possibility",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.13.2.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["test a random number of times",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.13.3.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["now the question:",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.13.4.1"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["1.12 What else?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.14.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.13 Let's group it all together",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.15.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["1.14 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab01.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:1.16.1"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox[
"Group Lab 2. Determining the symmetry group of a given figure",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.2"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"2.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.3.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.4.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.5.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.3 Symmetries and how to find them",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.3.1 Getting started",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.3.2"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["2.3.2 Functions/variables to use in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.6.4.2"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["2.4 Now your turn",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.7.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["2.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab02.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:2.8.2"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 3. Is this a group?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.3"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"3.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.4.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.5.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.6.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.3 When do we have a group?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.7.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.4 Now your turn",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.8.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["3.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab03.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:3.9.3"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 4. Let's get these orders straight",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.4"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"4.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.5.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.6.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["4.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.7.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(4.3\ Order\ of\ \), 
            FormBox["g",
              "TraditionalForm"], \(\ and\ its\ inverse\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:4.8.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
          \(4.4\ Distribution\ of\ the\ orders\ of\ elements\ in\ \), 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:4.9.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["4.5 Another look at orders",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.10.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(4.6\ What\ is\ \), 
            FormBox[\(P(\(\( | g\) | \) = n)\),
              "TraditionalForm"], \(\ for\ \), 
            FormBox["g",
              "TraditionalForm"], \(\  \[Element] \ \), 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"], "?"}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:4.11.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(4.7\ More\ questions\ about\ \), 
            FormBox[\(U\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:4.12.4"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["4.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab04.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:4.13.4"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 5. Subversively grouping our elements",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.5"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"5.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.6.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.7.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.8.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["5.3 When do we have a subgroup?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.9.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(5.4\ Subgroups\ of\ \), 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:5.10.5"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(5.5\ \), 
            FormBox[\(P(H < G)\),
              "TraditionalForm"], \(\ for\ a\ random\ subset\ \), 
            FormBox["H",
              "TraditionalForm"], \(\ of\ \), 
            FormBox[\(G = \[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:5.11.5"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["5.6 Necessary elements for full closure",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.12.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(5.7\ Subgroups\ of\ \), 
            FormBox[\(U\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:5.13.5"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["5.8 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab05.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:5.14.5"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 6. Cycling through the groups",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.6"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"6.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.7.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.8.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.9.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.3 What, when, how and why about cyclic groups",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.10.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(6.4\ Cyclicity\ of\ \), 
            
            FormBox[\(\[DoubleStruckCapitalZ]\_m
                  \[CirclePlus]\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:6.11.6"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["6.5 Structure of intersections of subgroups of ",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.12.6"},
  ButtonStyle->"Hyperlink"],
ButtonBox["\[DoubleStruckCapitalZ]",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.12.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["6.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab06.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:6.13.6"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 7. Permutations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.7"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"7.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.8.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.9.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.10.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.3 What is a permutation?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.11.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.4 Computations with permutations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.12.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.5 Applications of permutations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.13.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.6 Questions about permutations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.14.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["7.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab07.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:7.15.7"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 8. Isomorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.8"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"8.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.9.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.10.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.11.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.3 What is an isomorphism?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.12.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.4 Creating Morphoids",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.13.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.5 Seeing isomorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.14.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["8.5.1 example 1",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.14.9.8"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["8.5.2 example 2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.14.10.8"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["8.5.3 example 3",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.14.11.8"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["8.5.4 example 4",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.14.12.8"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["8.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab08.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:8.15.8"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 9. Automorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.9"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"9.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.10.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["9.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.11.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["9.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.12.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{
            StyleBox[\(9.3\ Automorphisms\ on\ \),
              AspectRatioFixed->True], 
            FormBox[\(\[DoubleStruckCapitalZ]\_n\),
              "TraditionalForm"]}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:9.13.9"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["9.4 Inner automorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.14.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["9.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab09.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:9.15.9"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 10. Direct products",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.10"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"10.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.11.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.12.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.13.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.3 What is a direct product?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.14.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["10.4 Order of an element in a direct product",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.15.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox[
"10.5 When is a direct product of cyclic groups cyclic?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.16.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox[
"What are the generators of a cyclic direct product?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.16.11.10"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[Cell[BoxData[
    FormBox[
      ButtonBox[
        StyleBox[
          RowBox[{\(10.6\ Isomorphisms\ among\ \), 
            FormBox[\(U\_n\),
              "TraditionalForm"], \(\ groups\)}],
          SingleLetterItalics->False],
        ButtonFunction:>(FrontEndExecute[ {
            FrontEnd`NotebookLocate[ #2]}]&),
        ButtonData:>{
          
          FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
            "MacintoshRoman"], "a:10.17.10"},
        Active->True,
        ButtonStyle->"Hyperlink",
        ButtonFrame->"None",
        Background->GrayLevel[1],
        ButtonNote->ButtonData], TraditionalForm]]]], "Contents"],

Cell[TextData[ButtonBox["10.7 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab10.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:10.18.10"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 11. Cosets",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.11"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"11.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.12.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.13.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.14.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.3 Cosets, left and right",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.15.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.4 Properties of cosets",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.16.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["11.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab11.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:11.17.11"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 12. Normality and factor groups",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.12"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"12.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.13.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.14.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.15.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.3 Normal subgroups",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.16.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.4 Making a new group",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.17.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.5 Factor groups",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.18.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["12.6 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab12.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:12.19.12"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["Group Lab 13. Group homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.13"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"13.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.14.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.15.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.16.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.3 What is a group homomorphism?",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.17.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.4 The kernel and image",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.18.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.4.1 The kernel",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.18.14.13"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["13.4.2 The image",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.18.15.13"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox[
"13.5 Properties that are preserved by homomorphisms",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.19.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.6 The kernel is normal",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.20.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[StyleBox[ButtonBox["13.7 The First Homomorphism Theorem",
  AspectRatioFixed->True,
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.21.13"},
  ButtonStyle->"Hyperlink"],
  AspectRatioFixed->True]], "Contents"],

Cell[TextData[ButtonBox["13.7.1 Example 2",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.21.14.13"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["13.7.2 Example 3",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.21.15.13"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["13.8 The alternating group -- parity as a morphism",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.22.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["13.9 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab13.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:13.23.13"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox[
"Group Lab 14: Rotational groups of regular polyhedra",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.14"},
  ButtonStyle->"Hyperlink"]], "ContentsSection"],

Cell[TextData[ButtonBox[
"14.0 Note regarding Exploring Abstract Algebra with Mathematica",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.15.14"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["14.1 Prerequisites",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.16.14"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["14.2 Goals for this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.17.14"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["14.3 Example - the Tetrahedron",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.18.14"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["14.3.1 Statement of the problem, first rotation",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.18.15.14"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["14.3.2 Generation of more rotations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.18.16.14"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox[
"14.3.3 Procedure for finding more complicated rotations",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.18.17.14"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox[
"14.3.4 Verification that we have the complete rotational group",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.18.18.14"},
  ButtonStyle->"Hyperlink"]], "Index"],

Cell[TextData[ButtonBox["14.4 Further exercises",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.19.14"},
  ButtonStyle->"Hyperlink"]], "Contents"],

Cell[TextData[ButtonBox["14.5 Mathematica commands used in this lab",
  ButtonData:>{
    FrontEnd`FileName[ {}, "GrpLab14.nb", CharacterEncoding -> 
      "MacintoshRoman"], "a:14.20.14"},
  ButtonStyle->"Hyperlink"]], "Contents"]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
ScreenStyleEnvironment->"AllBrackets",
WindowSize->{520, 509},
WindowMargins->{{90, Automatic}, {-16, Automatic}},
WindowTitle->Automatic,
TaggingRules:>{"TOCNotebook" -> True},
StyleDefinitions -> "Manual.nb",
MacintoshSystemPageSetup->"\<\
00<00018050000000_02P?oLon`2m0:D0@85:0?l00400018050000000_02P01@
0202P0b001P00@4100000BL?00410@00000000000000000000000@0000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 56, 0, 46, "ContentsTitle"],
Cell[1768, 51, 237, 4, 37, "ContentsSection"],
Cell[2008, 57, 249, 5, 22, "Contents"],
Cell[2260, 64, 203, 4, 22, "Contents"],
Cell[2466, 70, 208, 4, 22, "Contents"],
Cell[2677, 76, 219, 4, 22, "Contents"],
Cell[2899, 82, 227, 4, 22, "Contents"],
Cell[3129, 88, 217, 4, 22, "Contents"],
Cell[3349, 94, 221, 4, 22, "Contents"],
Cell[3573, 100, 214, 4, 22, "Contents"],
Cell[3790, 106, 228, 4, 22, "Contents"],
Cell[4021, 112, 225, 4, 22, "Contents"],
Cell[4249, 118, 230, 4, 22, "Contents"],
Cell[4482, 124, 221, 4, 22, "Contents"],
Cell[4706, 130, 208, 4, 14, "Index"],
Cell[4917, 136, 215, 4, 14, "Index"],
Cell[5135, 142, 203, 4, 14, "Index"],
Cell[5341, 148, 202, 4, 22, "Contents"],
Cell[5546, 154, 219, 4, 22, "Contents"],
Cell[5768, 160, 229, 4, 22, "Contents"],
Cell[6000, 166, 253, 5, 37, "ContentsSection"],
Cell[6256, 173, 249, 5, 22, "Contents"],
Cell[6508, 180, 203, 4, 22, "Contents"],
Cell[6714, 186, 208, 4, 22, "Contents"],
Cell[6925, 192, 221, 4, 22, "Contents"],
Cell[7149, 198, 206, 4, 14, "Index"],
Cell[7358, 204, 229, 4, 14, "Index"],
Cell[7590, 210, 203, 4, 22, "Contents"],
Cell[7796, 216, 227, 4, 22, "Contents"],
Cell[8026, 222, 220, 4, 37, "ContentsSection"],
Cell[8249, 228, 249, 5, 22, "Contents"],
Cell[8501, 235, 203, 4, 22, "Contents"],
Cell[8707, 241, 208, 4, 22, "Contents"],
Cell[8918, 247, 214, 4, 22, "Contents"],
Cell[9135, 253, 203, 4, 22, "Contents"],
Cell[9341, 259, 227, 4, 22, "Contents"],
Cell[9571, 265, 235, 4, 37, "ContentsSection"],
Cell[9809, 271, 249, 5, 22, "Contents"],
Cell[10061, 278, 203, 4, 22, "Contents"],
Cell[10267, 284, 208, 4, 22, "Contents"],
Cell[10478, 290, 662, 18, 20, "Contents"],
Cell[11143, 310, 713, 19, 21, "Contents"],
Cell[11859, 331, 213, 4, 22, "Contents"],
Cell[12075, 337, 847, 22, 21, "Contents"],
Cell[12925, 361, 656, 18, 21, "Contents"],
Cell[13584, 381, 228, 4, 22, "Contents"],
Cell[13815, 387, 238, 4, 37, "ContentsSection"],
Cell[14056, 393, 249, 5, 22, "Contents"],
Cell[14308, 400, 203, 4, 22, "Contents"],
Cell[14514, 406, 208, 4, 22, "Contents"],
Cell[14725, 412, 217, 4, 22, "Contents"],
Cell[14945, 418, 669, 18, 21, "Contents"],
Cell[15617, 438, 831, 22, 21, "Contents"],
Cell[16451, 462, 226, 4, 22, "Contents"],
Cell[16680, 468, 647, 18, 21, "Contents"],
Cell[17330, 488, 228, 4, 22, "Contents"],
Cell[17561, 494, 230, 4, 37, "ContentsSection"],
Cell[17794, 500, 249, 5, 22, "Contents"],
Cell[18046, 507, 203, 4, 22, "Contents"],
Cell[18252, 513, 208, 4, 22, "Contents"],
Cell[18463, 519, 234, 4, 22, "Contents"],
Cell[18700, 525, 740, 20, 21, "Contents"],
Cell[19443, 547, 418, 9, 22, "Contents"],
Cell[19864, 558, 228, 4, 22, "Contents"],
Cell[20095, 564, 216, 4, 37, "ContentsSection"],
Cell[20314, 570, 249, 5, 22, "Contents"],
Cell[20566, 577, 203, 4, 22, "Contents"],
Cell[20772, 583, 209, 4, 22, "Contents"],
Cell[20984, 589, 213, 4, 22, "Contents"],
Cell[21200, 595, 221, 4, 22, "Contents"],
Cell[21424, 601, 219, 4, 22, "Contents"],
Cell[21646, 607, 219, 4, 22, "Contents"],
Cell[21868, 613, 228, 4, 22, "Contents"],
Cell[22099, 619, 216, 4, 37, "ContentsSection"],
Cell[22318, 625, 249, 5, 22, "Contents"],
Cell[22570, 632, 204, 4, 22, "Contents"],
Cell[22777, 638, 209, 4, 22, "Contents"],
Cell[22989, 644, 214, 4, 22, "Contents"],
Cell[23206, 650, 209, 4, 22, "Contents"],
Cell[23418, 656, 210, 4, 22, "Contents"],
Cell[23631, 662, 201, 4, 14, "Index"],
Cell[23835, 668, 202, 4, 14, "Index"],
Cell[24040, 674, 202, 4, 14, "Index"],
Cell[24245, 680, 202, 4, 14, "Index"],
Cell[24450, 686, 228, 4, 22, "Contents"],
Cell[24681, 692, 217, 4, 37, "ContentsSection"],
Cell[24901, 698, 250, 5, 22, "Contents"],
Cell[25154, 705, 204, 4, 22, "Contents"],
Cell[25361, 711, 209, 4, 22, "Contents"],
Cell[25573, 717, 734, 20, 21, "Contents"],
Cell[26310, 739, 210, 4, 22, "Contents"],
Cell[26523, 745, 228, 4, 22, "Contents"],
Cell[26754, 751, 222, 4, 37, "ContentsSection"],
Cell[26979, 757, 253, 5, 22, "Contents"],
Cell[27235, 764, 207, 4, 22, "Contents"],
Cell[27445, 770, 212, 4, 22, "Contents"],
Cell[27660, 776, 219, 4, 22, "Contents"],
Cell[27882, 782, 233, 4, 70, "Contents"],
Cell[28118, 788, 244, 5, 70, "Contents"],
Cell[28365, 795, 241, 5, 70, "Index"],
Cell[28609, 802, 670, 18, 70, "Contents"],
Cell[29282, 822, 231, 4, 70, "Contents"],
Cell[29516, 828, 213, 4, 70, "ContentsSection"],
Cell[29732, 834, 253, 5, 70, "Contents"],
Cell[29988, 841, 207, 4, 70, "Contents"],
Cell[30198, 847, 212, 4, 70, "Contents"],
Cell[30413, 853, 216, 4, 70, "Contents"],
Cell[30632, 859, 214, 4, 70, "Contents"],
Cell[30849, 865, 231, 4, 70, "Contents"],
Cell[31083, 871, 234, 4, 70, "ContentsSection"],
Cell[31320, 877, 253, 5, 70, "Contents"],
Cell[31576, 884, 207, 4, 70, "Contents"],
Cell[31786, 890, 212, 4, 70, "Contents"],
Cell[32001, 896, 210, 4, 70, "Contents"],
Cell[32214, 902, 212, 4, 70, "Contents"],
Cell[32429, 908, 207, 4, 70, "Contents"],
Cell[32639, 914, 231, 4, 70, "Contents"],
Cell[32873, 920, 226, 4, 70, "ContentsSection"],
Cell[33102, 926, 253, 5, 70, "Contents"],
Cell[33358, 933, 207, 4, 70, "Contents"],
Cell[33568, 939, 212, 4, 70, "Contents"],
Cell[33783, 945, 223, 4, 70, "Contents"],
Cell[34009, 951, 214, 4, 70, "Contents"],
Cell[34226, 957, 206, 4, 70, "Index"],
Cell[34435, 963, 205, 4, 70, "Index"],
Cell[34643, 969, 241, 5, 70, "Contents"],
Cell[34887, 976, 214, 4, 70, "Contents"],
Cell[35104, 982, 286, 6, 70, "Contents"],
Cell[35393, 990, 205, 4, 70, "Index"],
Cell[35601, 996, 205, 4, 70, "Index"],
Cell[35809, 1002, 239, 4, 70, "Contents"],
Cell[36051, 1008, 231, 4, 70, "Contents"],
Cell[36285, 1014, 246, 5, 70, "ContentsSection"],
Cell[36534, 1021, 253, 5, 70, "Contents"],
Cell[36790, 1028, 207, 4, 70, "Contents"],
Cell[37000, 1034, 212, 4, 70, "Contents"],
Cell[37215, 1040, 219, 4, 70, "Contents"],
Cell[37437, 1046, 236, 4, 70, "Index"],
Cell[37676, 1052, 224, 4, 70, "Index"],
Cell[37903, 1058, 245, 5, 70, "Index"],
Cell[38151, 1065, 252, 5, 70, "Index"],
Cell[38406, 1072, 211, 4, 70, "Contents"],
Cell[38620, 1078, 231, 4, 70, "Contents"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

