(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53604,       1967]*)
(*NotebookOutlinePosition[     58313,       2123]*)
(*  CellTagsIndexPosition[     57721,       2099]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 1",
    FontSize->18],
  "\nUsing Symmetry to Uncover a Group"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.1"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.2.1"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user\[CloseCurlyQuote]s guide with printed and \
electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.3.1"],

Cell["None.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.4.1"],

Cell["\<\
In this lab, we try to discover some of the basic properties of a \
group by considering the symmetries of a regular triangle.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.3 Getting started? Begin here", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.5.1"],

Cell[TextData[{
  StyleBox["In most of the labs in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", one needs to first read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " packages necessary to provide the functionality within the lab. This is \
done using a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Needs",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" statement. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "(By opening the ",
  StyleBox["AbstractAlgebra`Master`",
    FontFamily->"Courier"],
  " package, all the functions in the ",
  StyleBox["AbstractAlgebra",
    FontFamily->"Courier"],
  " packages are made available.)",
  StyleBox[
  " On opening this notebook, you were probably asked, \
\[OpenCurlyDoubleQuote]Do you want to automatically evaluate all the \
initialization cells in the Notebook?\[CloseCurlyDoubleQuote] If you answered \
affirmatively, then you do not need to evaluate the following cell (but it \
doesn\[CloseCurlyQuote]t hurt to do so). If you answered negatively, then you \
need to evaluate this cell.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.4 A symmetry of an equilateral triangle", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.6.1"],

Cell[TextData[{
  "Suppose we consider an equilateral triangle with its vertices labeled with \
the numbers 1, 2, and 3. (Evaluate the cell, but do not worry about the \
parameters 3, ",
  Cell[BoxData[
      \(TraditionalForm\`{1, 2, 3}\)]],
  ", and \[OpenCurlyDoubleQuote]D.\[CloseCurlyDoubleQuote])"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(triangle = ShowFigure[3, {1, 2, 3}, "\<D\>"]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"We might think about how we can \[OpenCurlyDoubleQuote]move\
\[CloseCurlyDoubleQuote] this triangle so that after the \
\[OpenCurlyDoubleQuote]movement,\[CloseCurlyDoubleQuote] it appears as if it \
was not moved at all, except for a new ordering of the labels on the \
vertices. For example, suppose we draw an imaginary line from the vertex \
labeled 3 perpendicularly to the side opposite and then reflect the triangle \
in (across) this line. (Evaluate the following cell.) "], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Show[triangle, 
      Epilog \[Rule] {Blue, Line[{{0, \(-1.5\)}, {0, 2.0}}]}]; \)\)], "Input",\

  AspectRatioFixed->True],

Cell["\<\
After reflecting the triangle across the blue line, we have the \
following result (evaluate).\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowPermutation[{1 \[Rule] 2, 2 \[Rule] 1, 3 \[Rule] 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This reflection is an example of a (geometric) transformation called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["symmetry",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". Note that there are changes in the location of the vertices: vertex 1 \
went to the previous location of vertex 2, vertex 2 went to vertex 1, and \
vertex 3 went back to itself. This is called a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["permutation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of the vertices. One way to represent this permutation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" is by ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        StyleBox[\({1 "\[Rule]" 2, 2 "\[Rule]" 1, 3 "\[Rule]" 3}\),
          FontFamily->"Courier"], TraditionalForm]]],
  ". "
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Note that even though vertex 3 went to itself, it needs to be included in \
the permutation list. Observe that braces are used to contain the whole list. \
Let\[CloseCurlyQuote]s denote this first permutation by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". (Yes, evaluate it.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Clear[p]\), 
    \(p[1] = {1 \[Rule] 2, 2 \[Rule] 1, 3 \[Rule] 3}\)}], "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.5 Are there other symmetries?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.7.1"],

Cell[TextData[{
  StyleBox[
  "What other symmetries (permutations) are there? Let\[CloseCurlyQuote]s \
label each of the others ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[3]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", and so on and create the rules to form them. (Note that the rule symbol \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["->",
    FontFamily->"Courier"],
  StyleBox[
  " is a hyphen followed by a greater-than sign; if you hit the escape key \
before and after typing ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["->",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the result is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".) As you discover each permutation, type ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[k] = {1 \[Rule] x, 2 \[Rule] y, 3 \[Rule] z}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", where you supply appropriate values for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  StyleBox[". We give you one more.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p[2] = {1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["To test if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[k]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " is really a valid permutation of this triangle and to see the result \
geometrically, type ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowPermutation[p[k]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowPermutation[p[2]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note that the permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " can also be determined by considering only the second \
\[OpenCurlyDoubleQuote]coordinates\[CloseCurlyDoubleQuote] of each rule (",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[
  "), since the first coordinates are always the same for each permutation. \
Here is a matrix view of this permutation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note how each column represents a rule of the form ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  StyleBox[". Therefore, the list ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{2, 3, 1}\)]],
  StyleBox[" can also be used to represent ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2] = {1 ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 2, 2 ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 3, 3 ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 1}",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". So one could type",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p[2] = {2, 3, 1}\)], "Input",
  AspectRatioFixed->True],

Cell["and then ", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowPermutation[p[2]]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
would give the same result. (You have been evaluating each input \
cell as you read along, right?)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowPermutation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" is set up to accept either notation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Describe geometrically what the permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" does to the triangle.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". How many other symmetries of the triangle (in permutation form) can you \
find? Label them ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[3]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and so on as indicated above, and test each one (with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowPermutation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ") to see if the symmetry does what you thought. As you define each ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[k]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", place in (* comments *) (or in a text-type cell) a geometric description \
of what the symmetry does to the triangle.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". How many (distinct and unique) symmetries have you found altogether \
(including ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[")?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.6 Multiplying the transformations", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.8.1"],

Cell[TextData[{
  StyleBox[
  "Now we would like to know the interrelationships, if any, between these \
various symmetries. For instance, suppose we first applied the symmetry given \
by permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and then followed this with the symmetry given by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". What would the figure look like? Is there a permutation in your list \
that would give this \[OpenCurlyDoubleQuote]product?\[CloseCurlyDoubleQuote] \
",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  " Take a moment and see if you can figure out what the product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" would be. If you have an answer, how did you come up with it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "In Group Lab 7 we will learn more of the details of how we \
\[OpenCurlyDoubleQuote]multiply\[CloseCurlyDoubleQuote] permutations, but for \
now just assume that it can be done and allow ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" to do it for you. We use the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to do this. (If you do know how to do this, we assume the product works \
from right to left.) For question 4, evaluate the following to obtain the \
result. (First we review the definitions of the permutations ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p[1]\), 
    \(p[2]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(prod = MultiplyPermutations[p[2], p[1], Mode \[Rule] Textual]\)], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This yields the permutation that is the product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". (Note the order of the arguments in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".) Now evaluate the following cell.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowPermutation[prod]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "This draws the original triangle and the triangle resulting from the \
product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ". How does the second triangle compare to the first and how does the \
answer given for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["prod",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (which should have been ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{3, 2, 1}\)]],
  StyleBox[
  ") relate to the transformation that changes the first triangle into the \
second? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Does the permutation given by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\({3, 2, 1}\ \)\)]],
  StyleBox[
  "represent a symmetry of the triangle? If so, describe the symmetry \
geometrically. Is it among the list of permutations you found in question 2?",
    
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.7 Are there any commuters?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.9.1"],

Cell["Evaluate the following:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MultiplyPermutations[p[1], p[2], Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Did you get the same result as when you did ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations[p[2], p[1]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "? Why or why not? What does this say about the operation of multiplying \
permutations? Can you think of a mathematical term used to describe this?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.8 Is it always bad to be closed-minded?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.10.1"],

Cell[TextData[
"Now we want to set up a complete \[OpenCurlyDoubleQuote]multiplication\
\[CloseCurlyDoubleQuote] table of all possible products, as we did with \
addition and multiplication when a student in elementary school. Set up your \
table as follows."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
         p[1]          p[2]         p[3]      .  .  .
p[1]

p[2]

p[3]
  .
  .
  .\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The top row and left column simply act as labels for the table. The \
body of the table is filled in by multiplying the row entries by the column \
entries. For example, the entry in row 3 and column 2 can be obtained by \
evaluating \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(MultiplyPermutations[p[3], \ p[2]]\n (*\ 
      note\ that\ this\ product\ only\ makes\ sense\ if\ you\ have\ already\ 
        defined\ p[3]\ as\ a\ permutation\ *) \)\)], "Input"],

Cell[TextData[{
  StyleBox["Note the order: the entry in position ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((i, j)\)\)]],
  StyleBox[" (row ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox[", column ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  StyleBox[
  ") results from first performing the permutation corresponding to the one \
in column ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  StyleBox[" followed by the one in row ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox[", but when one enters this into the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", the order is reversed. (You might wonder why this is the case. It will \
become clearer when you study permutations in more detail, but for now \
consider as a hint that a permutation is really a function and multiplying \
permutations is actually composing functions, usually done from right to \
left.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Complete the table (using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" notation for each product, where possible).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "If you find that you obtain a product that is not in your original list, \
perhaps you need to look over your list and possibly make changes to it. \
Eventually, your list should terminate and the result of the product of any \
two should be one that is already in your list. In this case, the members in \
the body of the table should consist of only the elements listed in the \
column or row headings. We then say that the set of elements (symmetries of \
the triangle, as represented by the permutations, in this case) is said to be \
",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["closed",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" under this product.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.9 We should try to find our identity", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.11.1"],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". When we consider addition of real numbers, we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r + 0 = \(0 + r = r\)\)]],
  StyleBox[" for all real numbers ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  StyleBox[". Similarly, with multiplication of real numbers, we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`r*1 = \(1*r = r\)\)]],
  StyleBox[
  ". Does an analogous situation occur with the symmetries of the triangle? \
Is there any symmetry (say, permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[j]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[") which, when followed by another symmetry (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    FontFamily->"Courier"],
  StyleBox[
  "), yields the product consisting of simply the second symmetry (",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    FontFamily->"Courier"],
  StyleBox[") (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations[p[i], p[j]] = p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[")? If so, what is this ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[j]",
    FontFamily->"Courier"],
  StyleBox[
  " and what is special about it? Do we have a name for such objects as 0, 1, \
and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[j]",
    FontFamily->"Courier"],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.10 Is it perverse to not have an inverse?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.12.1"],

Cell[TextData[{
  "In section 1.9 we found an identity (or should have found one) that takes \
every vertex of the triangle back to itself (i.e., leaves the triangle \
unchanged). Recall that with addition of real numbers, since 0 is the \
additive identity, for any real number ",
  Cell[BoxData[
      \(TraditionalForm\`r\)]],
  ", there is another real number called ",
  Cell[BoxData[
      \(TraditionalForm\`\(-r\)\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`r + \((\(-r\))\) = \(\((\(-r\))\) + r = 0\)\)]],
  ". Similarly, with multiplication of real numbers, for any ",
  Cell[BoxData[
      \(TraditionalForm\`r \[NotEqual] 0\)]],
  ", there exists ",
  Cell[BoxData[
      \(TraditionalForm\`1\/r\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`r*1\/r = \(1\/r*r = 1\)\)]],
  " (and recall that 1 is the multiplicative identity)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Given a symmetry (permutation) ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    FontFamily->"Courier"],
  StyleBox[", is there another symmetry ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[j]",
    FontFamily->"Courier"],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations[p[i], p[j]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" yields this identity found above? If so, then we say that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[j]",
    FontFamily->"Courier"],
  StyleBox[" is the inverse of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    FontFamily->"Courier"],
  StyleBox[" (and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[i]",
    FontFamily->"Courier"],
  StyleBox[" is the inverse of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[j]",
    FontFamily->"Courier"],
  StyleBox[
  "). Does every symmetry found (when answering question 7) have an inverse? \
For each of the symmetries, determine the inverse (where possible). Below, \
list the elements and their corresponding inverses? Any observations?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["1.11 Should we associate together?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.13.1"],

Cell["\<\
Again, appealing to addition and multiplication of real numbers, \
recall that \
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\((a + b)\) + c = a + \((b + c)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\((a\ b)\)\ c = a\ \((b\ c)\)\)]]
}], "Text",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "for all real numbers ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". These equations say that both addition and multiplication of real \
numbers satisfy the associative property. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Another question one might ask is whether we have associativity of \
permutations. In other words, is it true that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["MultiplyPermutations[p[i]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[",",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[
  " MultiplyPermutations[p[j], p[k]]] = \
MultiplyPermutations[MultiplyPermutations[p[i], p[j]], p[k]]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`i\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`j\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  StyleBox["? This is comparable to asking if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a + \((b + c)\) = \((a + b)\) + c\)]],
  ".",
  StyleBox[" (Convince yourself of this.) Following is the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code to determine this. ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "You have a choice of checking every possibility or you can choose to do a \
certain number of random checks. Do one test or the other. (If you check \
every possibility, there are ",
  Cell[BoxData[
      \(TraditionalForm\`6\^3\)]],
  " = 216 tests in this case. Do you know why?)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[" Test every possibility", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.13.2.1"],

Cell[TextData[{
  StyleBox[
  "To do the following test, it is assumed that you found exactly six \
permutations (which is how many there are) and that you have defined them in \
the variables",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", \[Ellipsis] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[5]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[",",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["p[6]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(assoc\  = \ True; \n
    Do[temp\  = \ 
        MultiplyPermutations[p[i], \ MultiplyPermutations[p[j], \ p[k]\ ]\ ]
            \  === \ MultiplyPermutations[\ 
            MultiplyPermutations[p[i], p[j]\ ], \ p[k]\ ]; 
      assoc\  = \ And[assoc, \ temp], \ {i, \ 6}, \ {j, \ 6}, \ {k, \ 6}]; \n
    assoc\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[" Test a random number of times", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.13.3.1"],

Cell[TextData[{
  StyleBox[
  "To do the following test, it is assumed that you found exactly six \
permutations (which is how many there are) and that you have defined them in \
the variables ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[1]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", \[Ellipsis] ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[5]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["p[6]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(checkThisMany\  = \ 32; \ \n
    randfn[_]\  := \ Random[Integer, \ {1, \ 6}]\), 
    \(assoc\  = \ True; \n
    Do[index1\  = \ randfn[1]; \ index2\  = \ randfn[2]; \ 
      index3\  = \ randfn[3]; 
      temp\  = \ 
        MultiplyPermutations[p[index1], 
            MultiplyPermutations[p[index2], \ p[index3]\ ]\ ]\  === 
          MultiplyPermutations[\ 
            MultiplyPermutations[p[index1], \ p[index2]\ ], \ p[index3]\ ]; 
      assoc\  = \ And[assoc, \ temp], \t\n{checkThisMany}]; \nassoc\)}], 
  "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[" Now the question", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.13.4.1"],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Do you think that multiplication of these symmetries (permutations) is \
associative? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["1.12 What else?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.14.1"],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What other observations, if any, can you make from these explorations?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["1.13 Let\[CloseCurlyQuote]s group it all together"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.15.1"],

Cell[TextData[
"The collection of the six symmetries of the triangle\[LongDash]you found all \
six, right?\[LongDash]with the product of one transformation followed by \
another (but here viewed as six permutations with multiplication of the \
permutations) is an example of a set with a binary operation. Below is a \
formal definition of what we have been investigating."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Given a set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and an operation *, we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " a group ",
  StyleBox["if it meets the following conditions.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["1. The set is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["closed",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" under this operation (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e., ",
  Cell[BoxData[
      \(TraditionalForm\`g*h\)]],
  StyleBox[" is in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[").\n\n2. Among the elements there exists an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["identity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", there exists an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`e\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`e*g = \(g*e = g\)\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[").\n\n3. Each element has an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["inverse",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" among the set of elements (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", there exists ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g*h = \(h*g = e\)\)]],
  StyleBox[").\n\n4. The operation is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["associative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f*\((g*h)\) = \((f*g)\)*h\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  CellMargins->{{48, 46}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Furthermore, if we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g*h = h*g\)]],
  StyleBox[" for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[", we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["commutative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" (or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Abelian",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ") group. We will be studying the properties of groups in this course.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Is the set of six symmetries (permutations) with the operation of \
following one transformation by another (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[
  ", multiplying the permutations) an example of a group? Why or why not? Is \
it Abelian? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Determine another example of a set with an operation that is a group?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["1.14 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:1.16.1"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Needs\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?SwitchStructureTo\)\)], "Input"],

Cell[BoxData[
    \(\(?ShowPermutation\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Clear\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?PermutationMatrix\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?MultiplyPermutations\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Mode\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Textual\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Random\)\)], "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{628, 433},
WindowMargins->{{4, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 1 Using symmetry to uncover a group", FontSlant -> "Italic"], 
          "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"PrintingMargins"->{{54, 54}, {72, 72}},
"PrintCellBrackets"->False,
"PrintRegistrationMarks"->False,
"PrintMultipleHorizontalPages"->False,
"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@BbcP000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:1.1"->{
    Cell[2382, 76, 182, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:1.1"]},
  "a:1.2.1"->{
    Cell[2589, 87, 484, 18, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.2.1"]},
  "a:1.3.1"->{
    Cell[7201, 244, 107, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.3.1"]},
  "a:1.4.1"->{
    Cell[7417, 256, 99, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.4.1"]},
  "a:1.5.1"->{
    Cell[7754, 271, 121, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.5.1"]},
  "a:1.6.1"->{
    Cell[9618, 332, 131, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.6.1"]},
  "a:1.7.1"->{
    Cell[13192, 450, 121, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.7.1"]},
  "a:1.8.1"->{
    Cell[21994, 790, 125, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.8.1"]},
  "a:1.9.1"->{
    Cell[27891, 1006, 118, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.9.1"]},
  "a:1.10.1"->{
    Cell[28963, 1047, 132, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.10.1"]},
  "a:1.11.1"->{
    Cell[32997, 1184, 129, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.11.1"]},
  "a:1.12.1"->{
    Cell[35249, 1266, 134, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.12.1"]},
  "a:1.13.1"->{
    Cell[37963, 1357, 125, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.13.1"]},
  "a:1.13.2.1"->{
    Cell[40724, 1458, 122, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.13.2.1"]},
  "a:1.13.3.1"->{
    Cell[42231, 1515, 129, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.13.3.1"]},
  "a:1.13.4.1"->{
    Cell[43941, 1576, 116, 3, 42, "Subsubsection",
      Evaluatable->False,
      CellTags->"a:1.13.4.1"]},
  "a:1.14.1"->{
    Cell[44533, 1603, 106, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.14.1"]},
  "a:1.15.1"->{
    Cell[45072, 1628, 150, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.15.1"]},
  "a:1.16.1"->{
    Cell[52186, 1903, 372, 14, 55, "Section",
      Evaluatable->False,
      CellTags->"a:1.16.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:1.1", 55495, 2019},
  {"a:1.2.1", 55603, 2023},
  {"a:1.3.1", 55716, 2027},
  {"a:1.4.1", 55829, 2031},
  {"a:1.5.1", 55941, 2035},
  {"a:1.6.1", 56054, 2039},
  {"a:1.7.1", 56167, 2043},
  {"a:1.8.1", 56281, 2047},
  {"a:1.9.1", 56395, 2051},
  {"a:1.10.1", 56511, 2055},
  {"a:1.11.1", 56628, 2059},
  {"a:1.12.1", 56745, 2063},
  {"a:1.13.1", 56862, 2067},
  {"a:1.13.2.1", 56981, 2071},
  {"a:1.13.3.1", 57108, 2075},
  {"a:1.13.4.1", 57235, 2079},
  {"a:1.14.1", 57360, 2083},
  {"a:1.15.1", 57477, 2087},
  {"a:1.16.1", 57594, 2091}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 182, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:1.1"],

Cell[CellGroupData[{
Cell[2589, 87, 484, 18, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.2.1"],
Cell[3076, 107, 802, 20, 109, "Text",
  Evaluatable->False],
Cell[3881, 129, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5277, 172, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5455, 178, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6103, 201, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6821, 228, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7201, 244, 107, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.3.1"],
Cell[7311, 249, 69, 2, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7417, 256, 99, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.4.1"],
Cell[7519, 261, 198, 5, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7754, 271, 121, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.5.1"],
Cell[7878, 276, 1528, 45, 147, "Text",
  Evaluatable->False],
Cell[9409, 323, 172, 4, 43, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[9618, 332, 131, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.6.1"],
Cell[9752, 337, 363, 9, 52, "Text",
  Evaluatable->False],
Cell[10118, 348, 109, 2, 27, "Input"],
Cell[10230, 352, 553, 9, 90, "Text",
  Evaluatable->False],
Cell[10786, 363, 144, 4, 27, "Input"],
Cell[10933, 369, 166, 5, 33, "Text",
  Evaluatable->False],
Cell[11102, 376, 115, 2, 27, "Input"],
Cell[11220, 380, 995, 31, 90, "Text",
  Evaluatable->False],
Cell[12218, 413, 260, 9, 33, "Text",
  Evaluatable->False],
Cell[12481, 424, 545, 16, 71, "Text",
  Evaluatable->False],
Cell[13029, 442, 126, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[13192, 450, 121, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.7.1"],
Cell[13316, 455, 2013, 72, 109, "Text",
  Evaluatable->False],
Cell[15332, 529, 105, 2, 27, "Input"],
Cell[15440, 533, 601, 22, 52, "Text",
  Evaluatable->False],
Cell[16044, 557, 80, 2, 27, "Input"],
Cell[16127, 561, 1029, 34, 71, "Text",
  Evaluatable->False],
Cell[17159, 597, 117, 2, 27, "Input"],
Cell[17279, 601, 1418, 53, 52, "Text",
  Evaluatable->False],
Cell[18700, 656, 75, 2, 27, "Input"],
Cell[18778, 660, 73, 2, 33, "Text",
  Evaluatable->False],
Cell[18854, 664, 80, 2, 27, "Input"],
Cell[18937, 668, 170, 5, 33, "Text",
  Evaluatable->False],
Cell[19110, 675, 370, 13, 33, "Text",
  Evaluatable->False],
Cell[19483, 690, 475, 17, 48, "Question",
  Evaluatable->False],
Cell[19961, 709, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20038, 713, 1095, 36, 105, "Question",
  Evaluatable->False],
Cell[21136, 751, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21213, 755, 667, 26, 67, "Question",
  Evaluatable->False],
Cell[21883, 783, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[21994, 790, 125, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.8.1"],
Cell[22122, 795, 854, 26, 90, "Text",
  Evaluatable->False],
Cell[22979, 823, 718, 25, 67, "Question",
  Evaluatable->False],
Cell[23700, 850, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23777, 854, 1282, 40, 109, "Text",
  Evaluatable->False],
Cell[25062, 896, 80, 3, 43, "Input"],
Cell[25145, 901, 123, 3, 27, "Input"],
Cell[25271, 906, 796, 27, 52, "Text",
  Evaluatable->False],
Cell[26070, 935, 80, 2, 27, "Input"],
Cell[26153, 939, 1066, 38, 90, "Text",
  Evaluatable->False],
Cell[27222, 979, 555, 18, 86, "Question",
  Evaluatable->False],
Cell[27780, 999, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[27891, 1006, 118, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.9.1"],
Cell[28012, 1011, 87, 2, 33, "Text",
  Evaluatable->False],
Cell[28102, 1015, 113, 2, 27, "Input"],
Cell[28218, 1019, 631, 19, 86, "Question",
  Evaluatable->False],
Cell[28852, 1040, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[28963, 1047, 132, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.10.1"],
Cell[29098, 1052, 317, 6, 52, "Text",
  Evaluatable->False],
Cell[29418, 1060, 154, 12, 185, "Text",
  Evaluatable->False],
Cell[29575, 1074, 306, 7, 71, "Text",
  Evaluatable->False],
Cell[29884, 1083, 203, 3, 59, "Input"],
Cell[30090, 1088, 1437, 45, 128, "Text",
  Evaluatable->False],
Cell[31530, 1135, 479, 17, 48, "Question",
  Evaluatable->False],
Cell[32012, 1154, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32089, 1158, 871, 21, 128, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[32997, 1184, 129, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.11.1"],
Cell[33129, 1189, 2006, 68, 162, "Question",
  Evaluatable->False],
Cell[35138, 1259, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[35249, 1266, 134, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.12.1"],
Cell[35386, 1271, 935, 25, 112, "Text",
  Evaluatable->False],
Cell[36324, 1298, 1525, 50, 143, "Question",
  Evaluatable->False],
Cell[37852, 1350, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[37963, 1357, 125, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.13.1"],
Cell[38091, 1362, 151, 5, 33, "Text",
  Evaluatable->False],
Cell[38245, 1369, 266, 9, 33, "Text",
  Evaluatable->False],
Cell[38514, 1380, 383, 14, 52, "Text",
  Evaluatable->False],
Cell[38900, 1396, 1799, 58, 147, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[40724, 1458, 122, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.13.2.1"],
Cell[40849, 1463, 1000, 38, 52, "Text",
  Evaluatable->False],
Cell[41852, 1503, 342, 7, 107, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[42231, 1515, 129, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.13.3.1"],
Cell[42363, 1520, 994, 37, 52, "Text",
  Evaluatable->False],
Cell[43360, 1559, 544, 12, 187, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[43941, 1576, 116, 3, 42, "Subsubsection",
  Evaluatable->False,
  CellTags->"a:1.13.4.1"],
Cell[44060, 1581, 347, 12, 67, "Question",
  Evaluatable->False],
Cell[44410, 1595, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[44533, 1603, 106, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.14.1"],
Cell[44642, 1608, 316, 11, 48, "Question",
  Evaluatable->False],
Cell[44961, 1621, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[45072, 1628, 150, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.15.1"],
Cell[45225, 1633, 431, 7, 90, "Text",
  Evaluatable->False],
Cell[45659, 1642, 467, 17, 33, "Text",
  Evaluatable->False],
Cell[46129, 1661, 3801, 148, 185, "Text",
  Evaluatable->False],
Cell[49933, 1811, 1202, 46, 52, "Text",
  Evaluatable->False],
Cell[51138, 1859, 539, 18, 86, "Question",
  Evaluatable->False],
Cell[51680, 1879, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[51757, 1883, 315, 11, 48, "Question",
  Evaluatable->False],
Cell[52075, 1896, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[52186, 1903, 372, 14, 55, "Section",
  Evaluatable->False,
  CellTags->"a:1.16.1"],
Cell[52561, 1919, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[52906, 1930, 69, 2, 27, "Input"],
Cell[52978, 1934, 55, 1, 27, "Input"],
Cell[53036, 1937, 79, 2, 27, "Input"],
Cell[53118, 1941, 69, 2, 27, "Input"],
Cell[53190, 1945, 81, 2, 27, "Input"],
Cell[53274, 1949, 84, 2, 27, "Input"],
Cell[53361, 1953, 68, 2, 27, "Input"],
Cell[53432, 1957, 71, 2, 27, "Input"],
Cell[53506, 1961, 70, 2, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

