(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     86230,       1751]*)
(*NotebookOutlinePosition[     88981,       1841]*)
(*  CellTagsIndexPosition[     88741,       1829]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 3",
    FontSize->18],
  "\nIs This a Group?"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.3"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.4.3"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["3.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.5.3"],

Cell["\<\
To complete this lab, you should have already seen the definition \
of a group and become familiar with the basic group properties: being closed, \
having an identity, inverses, and associativity (and commutativity).\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["3.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.6.3"],

Cell["\<\
Does a set of elements and some operation on the elements form a \
group? This lab explores a number of pairs consisting of a set and an \
operation. A Cayley table for the set and operation is presented and the user \
is asked which of the defining properties of a group hold for this pair.\
\>",
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["3.3 When do we have a group?", "Section",
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.7.3"],

Cell[TextData[{
  StyleBox["We know that before we can call a set with an operation a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["group",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", it must satisfy certain properties. Namely, the set must be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["closed",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" under the operation, there must be an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["identity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" element, each element must have an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["inverse",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[", and the operation needs to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["associative",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  ". Our goal is to determine which, if any, of the above properties hold \
when presented a set with an operation. Before we begin, we need to read in \
the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code used in this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["When you evaluate ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowOne[Lab3]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to obtain the first problem, you will be shown something like this.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ShowOne[Lab3]\ \)\)], "Input",
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
The alleged group consists of the set of elements
{4, 0, 1, 3, 2}
 and the operator is myPower. This is case 15. Below is the
 Cayley table for this alleged group.\
\>", "Print",
  Editable->False,
  Deletable->False,
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.085 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.18254 0.15873 0.0274206 0.15873 [
[ 0 0 0 0 ]
[ 1 1.085 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 1.085 L
0 1.085 L
closepath
clip
newpath
p
p
p
p
1 1 0 r
p
.5 .66234 m
.5 .82107 L
.65873 .82107 L
.65873 .66234 L
F
P
P
p
1 .753 .796 r
p
.18254 .66234 m
.18254 .82107 L
.34127 .82107 L
.34127 .66234 L
F
.5 .50361 m
.5 .66234 L
.65873 .66234 L
.65873 .50361 L
F
P
P
p
1 .5 0 r
p
.81746 .66234 m
.81746 .82107 L
.97619 .82107 L
.97619 .66234 L
F
.81746 .50361 m
.81746 .66234 L
.97619 .66234 L
.97619 .50361 L
F
.18254 .34488 m
.18254 .50361 L
.34127 .50361 L
.34127 .34488 L
F
.34127 .34488 m
.34127 .50361 L
.5 .50361 L
.5 .34488 L
F
.5 .34488 m
.5 .50361 L
.65873 .50361 L
.65873 .34488 L
F
.65873 .34488 m
.65873 .50361 L
.81746 .50361 L
.81746 .34488 L
F
.81746 .34488 m
.81746 .50361 L
.97619 .50361 L
.97619 .34488 L
F
.81746 .18615 m
.81746 .34488 L
.97619 .34488 L
.97619 .18615 L
F
P
P
p
.74 .99 .79 r
p
.5 .18615 m
.5 .34488 L
.65873 .34488 L
.65873 .18615 L
F
P
P
p
.678 .847 .902 r
p
.18254 .02742 m
.18254 .18615 L
.34127 .18615 L
.34127 .02742 L
F
.34127 .02742 m
.34127 .18615 L
.5 .18615 L
.5 .02742 L
F
.5 .02742 m
.5 .18615 L
.65873 .18615 L
.65873 .02742 L
F
.65873 .02742 m
.65873 .18615 L
.81746 .18615 L
.81746 .02742 L
F
P
P
P
p
p
1 1 0 r
.18254 .82107 m
.18254 .9798 L
.34127 .9798 L
.34127 .82107 L
F
P
p
1 .753 .796 r
.34127 .82107 m
.34127 .9798 L
.5 .9798 L
.5 .82107 L
F
P
p
1 .5 0 r
.5 .82107 m
.5 .9798 L
.65873 .9798 L
.65873 .82107 L
F
P
p
.74 .99 .79 r
.65873 .82107 m
.65873 .9798 L
.81746 .9798 L
.81746 .82107 L
F
P
p
.678 .847 .902 r
.81746 .82107 m
.81746 .9798 L
.97619 .9798 L
.97619 .82107 L
F
P
p
1 1 0 r
.02381 .66234 m
.02381 .82107 L
.18254 .82107 L
.18254 .66234 L
F
P
p
1 .753 .796 r
.02381 .50361 m
.02381 .66234 L
.18254 .66234 L
.18254 .50361 L
F
P
p
1 .5 0 r
.02381 .34488 m
.02381 .50361 L
.18254 .50361 L
.18254 .34488 L
F
P
p
.74 .99 .79 r
.02381 .18615 m
.02381 .34488 L
.18254 .34488 L
.18254 .18615 L
F
P
p
.678 .847 .902 r
.02381 .02742 m
.02381 .18615 L
.18254 .18615 L
.18254 .02742 L
F
P
P
P
p
p
1 1 1 r
.008 w
.18095 .02583 Mdot
P
p
p
1 Mabswid
.02381 .02742 m
.02381 .9798 L
s
.02381 .02742 m
.97619 .02742 L
s
.02381 .18615 m
.97619 .18615 L
s
.02381 .34488 m
.97619 .34488 L
s
.02381 .50361 m
.97619 .50361 L
s
.02381 .66234 m
.97619 .66234 L
s
.02381 .82107 m
.97619 .82107 L
s
.02381 .9798 m
.97619 .9798 L
s
.18254 .02742 m
.18254 .9798 L
s
.34127 .02742 m
.34127 .9798 L
s
.5 .02742 m
.5 .9798 L
s
.65873 .02742 m
.65873 .9798 L
s
.81746 .02742 m
.81746 .9798 L
s
.97619 .02742 m
.97619 .9798 L
s
P
P
p
2.6 Mabswid
.18254 .02742 m
.18254 .9798 L
s
.02381 .82107 m
.97619 .82107 L
s
P
P
p
p
[(4)] .2619 .74171 0 0 Mshowa
[(16)] .42063 .74171 0 0 Mshowa
[(2)] .57937 .74171 0 0 Mshowa
[(8)] .7381 .74171 0 0 Mshowa
[(1)] .89683 .74171 0 0 Mshowa
[(16)] .2619 .58298 0 0 Mshowa
[(256)] .42063 .58298 0 0 Mshowa
[(4)] .57937 .58298 0 0 Mshowa
[(64)] .7381 .58298 0 0 Mshowa
[(1)] .89683 .58298 0 0 Mshowa
[(1)] .2619 .42425 0 0 Mshowa
[(1)] .42063 .42425 0 0 Mshowa
[(1)] .57937 .42425 0 0 Mshowa
[(1)] .7381 .42425 0 0 Mshowa
[(1)] .89683 .42425 0 0 Mshowa
[(9)] .2619 .26552 0 0 Mshowa
[(81)] .42063 .26552 0 0 Mshowa
[(3)] .57937 .26552 0 0 Mshowa
[(27)] .7381 .26552 0 0 Mshowa
[(1)] .89683 .26552 0 0 Mshowa
[(0)] .2619 .10679 0 0 Mshowa
[(0)] .42063 .10679 0 0 Mshowa
[(0)] .57937 .10679 0 0 Mshowa
[(0)] .7381 .10679 0 0 Mshowa
[(Ind)] .89683 .10679 0 0 Mshowa
P
p
[(2)] .10317 .74171 0 0 Mshowa
[(4)] .10317 .58298 0 0 Mshowa
[(1)] .10317 .42425 0 0 Mshowa
[(3)] .10317 .26552 0 0 Mshowa
[(0)] .10317 .10679 0 0 Mshowa
P
p
[(2)] .2619 .90044 0 0 Mshowa
[(4)] .42063 .90044 0 0 Mshowa
[(1)] .57937 .90044 0 0 Mshowa
[(3)] .7381 .90044 0 0 Mshowa
[(0)] .89683 .90044 0 0 Mshowa
P
p
P
[(^)] .10317 .90044 0 0 Mshowa
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Editable->False,
  Deletable->False,
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{265, 287},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004900017`P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_88Q000
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P000?l02P0000H0o?l700001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>o`0Y0003o`0000D00006000YooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@l00_l0YoD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo02T0
00?o00001@0000H002Wo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cP02o`2W
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?c_o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l0:@000ol000050000
1P00:Ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Y0003o`0000D00006000Yo`o>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0Y`o>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lkocPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko02T000?o00001@0000H002Wom@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3`02o`2Wm@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oGom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGom@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3ol0:@000ol0000500001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>o`0Y0003o`0000D00006000YooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@l00_l0YoD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo02T0
00?o00001@0000H002Wo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cP02o`2W
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?c_o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l0:@000ol000050000
1P00:Ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Y0003o`0000D00006000Yo`o>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0Y`o>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lkocPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko02T000?o00001@0000H002Wom@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3`02o`2Wm@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oGom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGom@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3ol0:@000ol0000500001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>o`0Y0003o`0000D00006000YooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@l00_l0YoD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo02T0
00?o00001@0000H002Wo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cP02o`2W
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?c_o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l0:@000ol000050000
1P00:Ooe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Y0003o`0000D00006000Yo`o>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0Y`o>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lkocPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko02T000?o00001@0000H002Wom@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3`02o`2Wm@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oGom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGom@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3ol0:@000ol0000500001P005?l?cPo>3lh?cPo>3lh?cPo>3lh?0_l04lh?
cPo>3lh?cPo>3lh?cPo>3lh00_l04`o>3lh?cPo>3lh?cPo>3lh?cPl00_l0:<h?cPo>3lh?cPo>3lh?
cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPl2o`0WcPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?
cPo>3lh?cPo>00;o02P?cPo>3lh?cPo>3lh?cPo>3lh?c_o>3lh?cPo>3lh?cPo>3lh?cPo>0_l05@o>
3lh?cPo>3lh?cPo>3lh?cPo>o`0<00Go00@0ool00_l200Go2`000ol0000500001P00:Ooe3oD?m@oe
3oD?m@oe3oD?m@oo3oGom@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?m@oe3oD?m@oo3oGo
m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oo3oGom@oe3oD?m@oe3oD?m@oe3oD?
mOoe3oD?m@oe3oD?m@oe3oD?mOoe3ol?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?m@oe3oD?m@oe3oD?
mOoe3ol?m@oe3oD?m@oe3oD?m@oe3oD?o`0>0005o`000?l00P001?l00?l30003o`0000X000?o0000
1@0000H002Wo3lh?cPo>3lh?cPo>3lh?cPo>olh?o`o>3lh?cPo>3lh?cPo>3lh?cP02o`2W3lh?cPo>
3lh?cPo>3lh?cPo>olh?o`o>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>olh?o`o>
3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPoo3lkocPo>3lh?cPo>3lh?cPo>3lh?c_o>
3lh?cPo>3lh?cPo>3lh?cPoo3lkocPo>3lh?cPo>3lh?cPo>3lh?c_l03P001Ol0003o008000Co003o
0`000ol0000:0003o`0000D00006000YooD?m@oe3oD?m@oe3oD?m@oe3ol?mOoe3oD?m@oe3oD?m@oe
3oD?m@l00_l0YoD?m@oe3oD?m@oe3oD?m@oe3ol?mOoe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?
m@oe3oD?m@oe3ol?mOoe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oeooD?o`oe3oD?
m@oe3oD?m@oe3oD?m@oo3oD?m@oe3oD?m@oe3oD?m@oeooD?o`oe3oD?m@oe3oD?m@oe3oD?m@oo00h0
00Go0000o`020004o`00o`<000?o00002P000ol0000500001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lko
cPoo3lh?cPo>3lh?cPo>3lh?cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lkocPoo3lh?cPo>3lh?cPo>
3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>3lkocPoo3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>
3lh?cPo>3ol?c_o>3lh?cPo>3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3ol?c_o>3lh?cPo>
3lh?cPo>3lh?cPo>o`0>0003o`0000Go0`04o``000?o00001@0000H001Com@oe3oD?m@oe3oD?m@oe
3oD?m@;o01<?m@oe3oD?m@oe3oD?m@oe3oD?00;o01?e3oD?m@oe3oD?m@oe3oD?m@oe00;o02P?m@oe
3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe0_l09`oe3oD?m@oe3oD?m@oe3oD?m@oe
ooD?m@oe3oD?m@oe3oD?m@oe3`02o`0Xm@oe3oD?m@oe3oD?m@oe3oD?m@oo3oD?m@oe3oD?m@oe3oD?
m@oe3`;o01Ge3oD?m@oe3oD?m@oe3oD?m@oe3ol03005o`/000?o00002P000ol0000500001P00:Ol?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0K00;o30000ol0000500001P00:Ooe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Y0003o`0000D00006000Yo`o>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0Y`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?o`o>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lkocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lko02T000?o00001@0000H002Wom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3`02o`2Wm@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGom@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3ol0:@000ol0000500001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Y0003
o`0000D00006000YooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@l00_l0YoD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo02T000?o00001@0000H0
02Wo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cP02o`2W3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_o>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l0:@000ol0000500001P00:Ooe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Y0003o`0000D00006000Yo`o>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0Y`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?o`o>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lkocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lko02T000?o00001@0000H002Wom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3`02o`2Wm@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGom@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3ol0:@000ol0000500001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Y0003
o`0000D00006000YooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@l00_l0YoD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oeooD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oo3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo02T000?o00001@0000H0
02Wo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cP02o`2W3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPoo3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_o>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l0:@000ol0000500001P00:Ooe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?00;o0:Oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
mOoe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`0Y0003o`0000D00006000Yo`o>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh00_l0Y`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?o`o>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?o`o>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lkocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lko02T000?o00001@0000H002Wom@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3`02o`2Wm@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGo
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oGom@oe3oD?m@oe3oD?m@oe3oD?
m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?
m@oe3ol0:@000ol0000500001P00:Ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>00;o0:L?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3ol?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>
3lh?cPo>3lh?cPo>olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`0Y0003
o`0000D000060?co1`0000H002Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`02obT000?o00009`00:_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?obT0
02_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YomH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_lY0003o`0002L002[oeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0olY000[oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P00:Ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?00;o:@000ol0000W000Zo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`oo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H0
02WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02obT000?o00009`00:_oF
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3obT002_oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000Yo`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l00_lY0003o`0002L002[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0700001P00:OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o:@000ol0
000W000ZomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o:@00:omOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Wo0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02obT000?o00009`00:_l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?obT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L00006000YomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<0
0_lY0003o`0002L002[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0olY000[
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:Ol33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o:@000ol0000W000Zo`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol01`0000H002WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0`02obT000?o00009`00:_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3obT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000Y
o`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_lY0003o`0002L002[o0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33olY000[oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH300;o:@000ol0000W000ZomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?o:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
1`0000H002Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02obT000?o0000
9`00:_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?obT002_oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YomH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_lY0003o`0002L002[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:Ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o
:@000ol0000W000Zo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo:@00:omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002WoeP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02obT000?o00009`00:_oF0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3obT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo00L00006000Yo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l00_lY0003o`0002L002[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P004ooF
0mH3eP?F0mH3eP?F0mH3eP<00ol04`?F0mH3eP?F0mH3eP?F0mH3eP<00_lB00?o50000ol0000>00;o
0`03oa4001;oeP?F0mH3eP?F0mH3eP?F0mH3o`0EeP?F0mH3eP?F0mH3eP?F0mH3eP?o00l01?l30003
o`00010001?oGimOWenOGimOWenOGimOWenO00?o01FOGimOWenOGimOWenOGimOWenOGol01`0000H0
02Wo0`l33`<?0`l33`<?0`l33`<?0`l3o`<?0`l33`<?0`l33`<?0`l33`02oaD000?o00004@000ol0
000=0004o`00o`<000?o00004000:_l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l3
3`<?oa0000?o00000`000ol0000@000[oenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OoF0mH3eP?F0mH3eP?F0mH3eP?F0mKoeP?F0mH3eP?F0mH3eP?F0mH300;o
4`03oa<000?o00003@001?l00?l30003o`00010002[oeP?F0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F
0mH3eP?F0mH3eP?F0olA0003o`0000<000?o00003`00:omOWenOGimOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGimOWenOGol01`0000H001Co0`l33`<?0`l33`<?0`l33`<?0`;o01<?0`l33`<?0`l3
3`<?0`l33`<?00;o4P001?l00?lC0003o`0000h00_l40003o`00010001?o0`l33`<?0`l33`<?0`l3
3`<?00;o01D33`<?0`l33`<?0`l33`<?0`l33ol04P000ol000020003o`0000l002_oGimOWenOGimO
WenOGimOWenOGomOWenOGimOWenOGimOWenOGimOWeoo00L00006000YomH3eP?F0mH3eP?F0mH3eP?F
0mH3e_oF0mH3eP?F0mH3eP?F0mH3eP<00_lB0004o`00oa<000?o00003@001?l00?l30003o`000100
02[oeP?F0mH3eP?F0mH3eP?F0mH3eP?o0mH3eP?F0mH3eP?F0mH3eP?F0ol?0004o`00o`D000?o0000
3P00:omOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGol01`0000H001?o0`l3
3`<?0`l33`<?0`l33`<?00?o01<?0`l33`<?0`l33`<?0`l33`<?00;o4`02oa@000?o00003P02o`<0
0_lB000Bo`<?0`l33`<?0`l33`<?0`l30ol05@<?0`l33`<?0`l33`<?0`l33`<?o`0@00;o0`04oa00
01?oGimOWenOGimOWenOGimOWenO00;o01IOWenOGimOWenOGimOWenOGimOWeoo1`0000H002WoeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02obT000?o00009`00:_oF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3obT002_oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L00006000Yo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l00_lY0003o`0002L002[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P00:OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o:@000ol0000W000Z
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o:@00:omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Wo0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`02obT000?o00009`00:_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?obT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo00L00006000YomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_lY0003
o`0002L002[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0olY000[oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:Ol33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o:@000ol0000W000Zo`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol01`0000H002WoeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0`02obT000?o00009`00:_oF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3obT0
02_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000Yo`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l00_lY0003o`0002L002[o0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33olY000[oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P00:OoF0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH300;o:@000ol0000W000ZomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?o:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H0
02Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`02obT000?o00009`00:_l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?obT002_oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YomH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP<00_lY0003o`0002L002[oeP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0700001P00:Ol33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?00;o:@000ol0
000W000Zo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo:@00:omOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002WoeP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0`02obT000?o00009`00:_oF0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3obT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L00006000Yo`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l0
0_lY0003o`0002L002[o0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33olY000[
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OoF0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH300;o:@000ol0000W000ZomH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o:@00:omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol01`0000H002Wo0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`02obT000?o00009`00:_l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?obT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000Y
omH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP<00_lY0003o`0002L002[oeP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0olY000[oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0700001P3lo`L00006000YoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
0006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
0006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
0006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel0
0_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
0006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWel00_l0dImOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L00006000YoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWel00_l0dImOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000CoimOWenO
GimOWenOGimOWenOG`03o`0CGimOWenOGimOWenOGimOWenOG`02o`0BWenOGimOWenOGimOWenOGimO
0ol09enOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOG`03o`0VGimOWenOGimOWenO
GimOWenOGiooWenOGimOWenOGimOWenOGil3o`0WWenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenO00?o02NOGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGil00ol05ImO
WenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenO
GimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWeooGimO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenO
GimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOoimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimO
WeooGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimO00;o
0=6OGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOoimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenO
oimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOoimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWeooGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWeooGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOo`070000
1P004onOGimOWenOGimOWenOGimOWel00_l059mOWenOGimOWenOGimOWenOGimO0_l04YmOWenOGimO
WenOGimOWenOG`;o02ROGimOWenOGimOWenOGimOWenOGiooWenOGimOWenOGimOWenOGimO0_l09imO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOW`02o`0XGimOWenOGimOWenOGimOWenO
GimOoenOGimOWenOGimOWenOGimOW`;o02QOWenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenO
GimOWenO0_l05UnOGimOWenOGimOWenOGimOWenOGol700001P00:OnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o
0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P00:OnOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO00;o0=6OGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWonOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P3lo`L00006000YokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fH00_lY0003o`0002L002[o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI_lY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0700001P00:OoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o:@000ol0
000W000ZonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oo:@00:omOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Wo_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoIP02obT000?o00009`00:_noI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mVobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L00006000YonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[l0
0_lY0003o`0002L002[oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_olY000[
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV00;o:@000ol0000W000ZokmV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol01`0000H002Woi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_`02obT000?o00009`00:_oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000Y
okmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fH00_lY0003o`0002L002[o_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_lY000[oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJo00;o:@000ol0000W000ZonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
1`0000H002Wo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoIP02obT000?o0000
9`00:_noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVobT002_oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YonJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[l00_lY0003o`0002L002[oi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OnoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV00;o
:@000ol0000W000ZokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo:@00:omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Woi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_`02obT000?o00009`00:_oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo00L00006000YokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fH00_lY0003o`0002L002[o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I_lY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OoV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o:@000ol0000W000ZonJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oo:@00:omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGol01`0000H002Wo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoIP02obT000?o00009`00:_noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mVobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
0006000YonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[l00_lY0003o`0002L0
02[oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_olY000[oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV00;o:@000ol0000W000ZokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fKo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol01`0000H002Woi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_`02obT0
00?o00009`00:_oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoobT002_oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000DokmV_fJoI[mV_fJo
I[mV_fJoI[l3o`0B_fJoI[mV_fJoI[mV_fJoI[mV0_l?00?o1002oa4000?o00002P04o`800ol400;o
3P004onoI[mV_fJoI[mV_fJoI[mV_fH00ol056JoI[mV_fJoI[mV_fJoI[mV_fKo4002o`@00ol@000C
oenOGimOWenOGimOWenOGimOW`03o`0EWenOGimOWenOGimOWenOGimOWeoo00L00006000YonJoi[oV
_nJoi[oV_nJoi[oV_nJookoV_nJoi[oV_nJoi[oV_nJoi[l00_l@0003o`00008000Co003o40000ol0
000;0003o`0000D000Co003o0P000ol0000;000ZonJoi[oV_nJoi[oV_nJoi[oV_nKoi[oV_nJoi[oV
_nJoi[oV_nJoi[oo3`001?l00?l40003o`0000l002_oGimOWenOGimOWenOGimOWenOGomOWenOGimO
WenOGimOWenOGimOWeoo00L00006000CokmV_fJoI[mV_fJoI[mV_fJoIP04o`0B_fJoI[mV_fJoI[mV
_fJoI[mV0_l@0003o`00008000Co003o40000ol0000<0003o`0000@000Co003o0P000ol0000;000B
okmV_fJoI[mV_fJoI[mV_fJo1?l056JoI[mV_fJoI[mV_fJoI[mV_fKo3`001?l00?l200Co4000:omO
WenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGol01`0000H002Woi[oV_nJoi[oV
_nJoi[oV_nJookoo_nJoi[oV_nJoi[oV_nJoi[oV_`02oa0000?o00000P03oa4000?o00003@000ol0
0003o`<00ol>000ZonJoi[oV_nJoi[oV_nJoi[oVonKoi[oV_nJoi[oV_nJoi[oV_nJoi[oo3`03o`<0
00?o0?l04@00:omOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGol01`0000H0
02Wo_fJoI[mV_fJoI[mV_fJoI[mVofKoI[mV_fJoI[mV_fJoI[mV_fJoIP02oa0000?o00000P000ol0
000A0003o`0000X000Co003o0P000ol000030003o`0000h002[o_fJoI[mV_fJoI[mV_fJoI[oo_ono
I[mV_fJoI[mV_fJoI[mV_fJoI_l?0003o`0000<000?o0?l04@00:omOWenOGimOWenOGimOWenOGimO
oenOGimOWenOGimOWenOGimOWenOGol01`0000H001Coi[oV_nJoi[oV_nJoi[oV_nJoiP;o01>oi[oV
_nJoi[oV_nJoi[oV_nJo00;o3`02o`D00ol@0003o`0000/00_l300Co0`03o`d001?oi[oV_nJoi[oV
_nJoi[oV_nJo00;o01GV_nJoi[oV_nJoi[oV_nJoi[oV_ol04003o`<00_lA000CoenOGimOWenOGimO
WenOGimOW`02o`0FGimOWenOGimOWenOGimOWenOGimOo`L00006000YokmV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fH00_lY0003o`0002L002[o_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI_lY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P00:OoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o
:@000ol0000W000ZonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oo:@00:omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Wo_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoIP02obT000?o00009`00:_noI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo00L00006000YonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[l00_lY0003o`0002L002[oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:Ono
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV00;o:@000ol0000W000ZokmV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo:@00:omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGol01`0000H002Woi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_`02obT000?o00009`00:_oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
0006000YokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fH00_lY0003o`0002L0
02[o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI_lY000[oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OoV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o:@000ol0000W000ZonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol01`0000H002Wo_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoIP02obT0
00?o00009`00:_noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mVobT002_oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L00006000YonJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[l00_lY0003o`0002L002[oi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_olY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0700001P00:OnoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV00;o:@000ol0000W000ZokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo
:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Woi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_`02obT000?o00009`00:_oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoobT002_oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L00006000YokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fH00_lY0003o`0002L002[o_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI_lY000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P00:OoV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo00;o:@000ol0000W000Z
onJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oo:@00:omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H002Wo_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoIP02obT000?o00009`00:_noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mVobT002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo00L00006000YonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[l00_lY0003
o`0002L002[oi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_olY000[oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P00:OnoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV00;o:@000ol0000W000ZokmV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fKo:@00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol01`0000H0o?l700001P000ooOg`0Vg`;o02ZoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_olY0003omoO02KO00?o00009`00:omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml09]l2o`0Zi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoobT000?ogml09]l00ol0000W000[oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0Vg`;o02[V_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_lY0003omoO02KO00?o00009`00:omOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml09]l2o`0Z_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oo:@000ooOg`0Vg`03o`0002L002_oGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:^Jo
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVobT000?ogml09]l00ol0000W000[
oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0Vg`;o
02ZoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_olY0003omoO02KO00?o0000
9`00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml0
9]l2o`0Zi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo:@000ooOg`0Vg`03
o`0002L002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L000060003
omoO02KO0_l0:[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoobT000?ogml0
9]l00ol0000W000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`070000
1P000ooOg`0Vg`;o02[V_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_lY0003
omoO02KO00?o00009`00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol0
1`0000H000?ogml09]l2o`0Z_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oo
:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
Weoo00L000060003omoO02KO0_l0:^Joi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo
i[oVobT000?ogml09]l00ol0000W000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOo`0700001P000ooOg`0Vg`;o02ZoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_olY0003omoO02KO00?o00009`00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGol01`0000H000?ogml09]l2o`0Zi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nKo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoobT000?ogml09]l00ol0000W000[oenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0Vg`;o02[V_nJoi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi_lY0003omoO02KO00?o00009`00:omOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml09]l2o`0Z_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:^Joi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVobT000?ogml09]l00ol0000W000[oenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0@g`Co4]l2o`0C_fJoI[mV
_fJoI[mV_fJoI[mV_`03o`0D_fJoI[mV_fJoI[mV_fJoI[mV_ol?00?o1002oa4000?ogml03ml4oa?O
00?o00004@02oa@001?oGimOWenOGimOWenOGimOWenO00?o01FOGimOWenOGimOWenOGimOWenOGol0
1`0000H000?ogml04Ml00ooOg`0Bg`;o02[V_nJoi[oV_nJoi[oV_nJoi[oV_onoi[oV_nJoi[oV_nJo
i[oV_nJoi_l@0003o`00008000Co003o40000ooOg`0@g`03omoO01?O00?o000040001?l00?lC000[
oenOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0Bg`03
omoO017O0_l04[mV_fJoI[mV_fJoI[mV_fJoIPCo01BoI[mV_fJoI[mV_fJoI[mV_fJooa0000?o0000
0P001?l00?l@0003omoO017O00?ogml04]l00ol0000@0004o`00oa<002_oGimOWenOGimOWenOGimO
WenOGomOWenOGimOWenOGimOWenOGimOWeoo00L000060003omoO01?O00?ogml04=l2o`0Zi[oV_nJo
i[oV_nJoi[oV_nJookoo_nJoi[oV_nJoi[oV_nJoi[oV_nKo40000ol0000200?o4@000ooOg`0Bg`03
omoO017O00?o00004@02oa@002_oGimOWenOGimOWenOGimOWenOGomOWenOGimOWenOGimOWenOGimO
Weoo00L000060003omoO013O00Cogmoo4]l2o`0Z_fJoI[mV_fJoI[mV_fJoI[mVofKoI[mV_fJoI[mV
_fJoI[mV_fJoI[oo40000ol000020003o`00014000?ogml03ml01?oOgolCg`03o`00010000Co003o
4`00:omOWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml0
4Ml2oa?O0_l04nJoi[oV_nJoi[oV_nJoi[oV_nH00_l05KoV_nJoi[oV_nJoi[oV_nJoi[oVo`0?00;o
1@03oa0000?ogml04=l2oaCO00?o00004@02oa@001?oGimOWenOGimOWenOGimOWenO00;o01IOWenO
GimOWenOGimOWenOGimOWeoo1`0000H000?ogml09]l2o`0Z_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[oo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:^Joi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oVobT000?ogml09]l00ol0000W000[oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0Vg`;o02ZoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_olY0003omoO02KO00?o00009`00:omOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml09]l2o`0Zi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoobT000?ogml09]l00ol0000W000[oenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooOg`0Vg`;o02[V_nJo
i[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_lY0003omoO02KO00?o00009`00:omO
WenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H000?ogml09]l2o`0Z
_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[oo:@000ooOg`0Vg`03o`0002L0
02_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO
0_l0:^Joi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVobT000?ogml09]l00ol0
000W000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`0700001P000ooO
g`0Vg`;o02ZoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_olY0003omoO02KO
00?o00009`00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol01`0000H0
00?ogml09]l2o`0Zi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKo:@000ooO
g`0Vg`03o`0002L002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo00L0
00060003omoO02KO0_l0:[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoobT0
00?ogml09]l00ol0000W000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
o`0700001P000ooOg`0Vg`;o02[V_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo
i_lY0003omoO02KO00?o00009`00:omOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGol01`0000H000?ogml09]l2o`0Z_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[oo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWeoo00L000060003omoO02KO0_l0:^Joi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oVobT000?ogml09]l00ol0000W000[oenOGimOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOo`0700001P000ooOg`0Vg`;o02ZoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_olY0003omoO02KO00?o00009`00:omOWenOGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGol01`0000H000?ogml09]l2o`0Zi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJo
i[oV_nJoi[oV_nJoi[oV_nKo:@000ooOg`0Vg`03o`0002L002_oGimOWenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWeoo00L000060003omoO02KO0_l0:[mV_fJoI[mV_fJoI[mV_fJoI[mV
_fJoI[mV_fJoI[mV_fJoI[mV_fJoobT000?ogml09]l00ol0000W000[oenOGimOWenOGimOWenOGimO
WenOGimOWenOGimOWenOGimOWenOGimOo`0700001@3mo`L000050?go1`0000H000?o00009P02obWO
0:Soi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l700001P000ol0
000V00;o:Ml0Z?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_onOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3o`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L0
00060003o`0002H00_lYg`2XonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
oimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo3`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`oocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lko1`0000H000?o00009P02obWO0:So_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3ol700001P000ol0000V00;o:Ml0Z?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?olh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`L000060003o`0002H00_lYg`2XokmV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWeoo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo1`0000H000?o00009P02obWO0:Soi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33oo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l700001P000ol0000V00;o:Ml0Z?no
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_onOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3o`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`0002H0
0_lYg`2XonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`oocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko1`0000H0
00?o00009P02obWO0:So_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[ooWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3ol700001P000ol0000V00;o:Ml0Z?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi_nOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>o`L000060003o`0002H00_lYg`2XokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oo1`0000H000?o00009P02obWO0:Soi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
Gol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l700001P000ol0000V00;o:Ml0Z?noI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`0002H00_lYg`2XonJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWeoo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oo
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko1`0000H000?o00009P02obWO
0:So_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[ooWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol700001P000ol0
000V00;o:Ml0Z?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_nOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`L0
00060003o`0002H00_lBg`Co4ml05?noI[mV_fJoI[mV_fJoI[mV_fJo0ol09KmV_fJoI[mV_fJoI[mV
_fJoI[ooWenOGimOWenOGimOWenOGil00ol09imOWenOGimOWenOGimOWenOGimOo`?F0mH3eP?F0mH3
eP?F0mH3eP03o`0XeP?F0mH3eP?F0mH3eP?F0mH3eP?o3oD?m@oe3oD?m@oe3oD?m@oe3`;o01Ge3oD?
m@oe3oD?m@oe3oD?m@oe3ol01`0000H000?o00009P02oa?O00?ogml04ml0Z?oV_nJoi[oV_nJoi[oV
_nJoi[oV_onoi[oV_nJoi[oV_nJoi[oV_nJoi_nOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenO
GimOWenOGimOo`l33`<?0`l33`<?0`l33`<?0`l33ol?0`l33`<?0`l33`<?0`l33`<?olh?cPo>3lh?
cPo>3lh?cPo>3ol?c_o>3lh?cPo>3lh?cPo>3lh?cPo>o`L000060003o`0002H00_lDg`03omoO01;O
01?o_fJoI[mV_fJoI[mV_fJoI[mV00Co096oI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimO
WenOGomOWenOGimOWenOGimOWenOGimOWeoo0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`?F0mH3eP?F0mH3
eP?F0mH3eP?o3oD?m@oe3oD?m@oe3oD?m@oeooD?o`oe3oD?m@oe3oD?m@oe3oD?m@oo00L000060003
o`0002H00_lEg`03omoO017O06Ooi[oV_nJoi[oV_nJoi[oV_nJookoo_nJoi[oV_nJoi[oV_nJoi[oV
_nKoWenOGimOWenOGimOWenOGimOoenOGimOWenOGimOWenOGimOWenOGol?0`l33`<?0`l33`<?0`l3
3`<?00;o03l33`<?0`l33`<?0`l33`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?cPoo3lkocPo>3lh?cPo>
3lh?cPo>3lh?c_l01`0000H000?o00009P02oa;O00Cogmoo4ml0Z?noI[mV_fJoI[mV_fJoI[mV_fKo
I_mV_fJoI[mV_fJoI[mV_fJoI[mV_onOGimOWenOGimOWenOGimOWeooGimOWenOGimOWenOGimOWenO
GimOo`?F0mH3eP?F0mH3eP?F0mH3eP?F0ol3eP?F0mH3eP?F0mH3eP?F0mH3o`oe3oD?m@oe3oD?m@oe
3oD?mOoe3ol?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`00010000?o0?l04`02oa?O0_lDg`0D
onJoi[oV_nJoi[oV_nJoi[oV_nH2o`0V_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenO
Gil2o`0XGimOWenOGimOWenOGimOWenOGimOo`l33`<?0`l33`<?0`l33`<?0`?o02P33`<?0`l33`<?
0`l33`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?cPo>0_l05@o>3lh?cPo>3lh?cPo>3lh?cPo>o`070000
1P000ol0000A0003o`0001800_lYg`2XokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJooimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oo1`0000H000?o00009P02obWO0:Soi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nKoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?c_l700001P000ol0000V00;o:Ml0Z?noI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOo`?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?o`L000060003o`0002H00_lYg`2XonJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWeoo3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oocPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko1`0000H000?o00009P02obWO0:So_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[ooWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol700001P000ol0000V00;o
:Ml0Z?oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_nOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?olh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`L000060003
o`0002H00_lYg`2XokmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo
1`0000H000?o00009P02obWO0:Soi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nKoWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?c_l700001P000ol0000V00;o:Ml0Z?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_onOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?o`L000060003o`0002H00_lYg`2XonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oocPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lko1`0000H000?o00009P02obWO0:So_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGol3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3ol700001P000ol0000V00;o:Ml0Z?oV_nJoi[oV
_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi_nOGimOWenOGimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOo`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?olh?
cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>o`L000060003o`0002H00_lYg`2X
okmV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJooimOWenOGimOWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWeoo0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?o3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oo1`0000H000?o0000
9P02obWO0:Soi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nKoWenOGimOWenO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33oo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?c_l70000
1P000ol0000V00;o:Ml0Z?noI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_onO
GimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOo`?F0mH3eP?F0mH3eP?F0mH3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3o`oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?o`L000060003o`0002H00_lYg`2XonJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV_nJoi[oV
_nJoi[oVoimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWeoo3`<?0`l33`<?0`l3
3`<?0`l33`<?0`l33`<?0`l33`<?0`l33`<?0`oocPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?cPo>3lh?
cPo>3lh?cPo>3lko1`0000H000?o00009P02obWO0:So_fJoI[mV_fJoI[mV_fJoI[mV_fJoI[mV_fJo
I[mV_fJoI[mV_fJoI[ooWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGimOWenOGol3eP?F
0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0mH3eP?F0ol?m@oe3oD?m@oe3oD?m@oe3oD?m@oe
3oD?m@oe3oD?m@oe3oD?m@oe3ol700001P3lo`L0000_00;of0000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l02P000?l0
2P000?l02P000?l02P000001\
\>"],
  ImageRangeCache->{{{0, 264}, {286, 0}} -> {-1.15488, -0.172784, 0.0239006, 
  0.0239006}}]
}, Closed]],

Cell[TextData[{
  StyleBox[
  "Note that the Cayley table may have the elements (in the headings) in a \
different order than that in the written description. (Before making the \
table, they are randomized\[LongDash]for this lab only.) The properties of \
closure, identity, and inverses should be readily observable from this Cayley \
table. Associativity is a little more difficult. We will use a function that \
randomly tests for associativity, testing 25 triples by default. Since what \
is shown is identified as ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[OpenCurlyDoubleQuote]",
  StyleBox["case 15,",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyDoubleQuote]",
  StyleBox[" the argument to our function is ",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LG[15]",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (for Lab Groupoid 15.). Evaluate the following cell.",
    CellMargins->{{Inherited, 55}, {Inherited, Inherited}},
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  CellMargins->{{Inherited, 12}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RandomAssociativeQ[LG[15]]\)], "Input",
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  AspectRatioFixed->True],

Cell["\<\
If you wish to change the number of tests, add this number as the \
second argument:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(RandomAssociativeQ[LG[15], 30]\)], "Input",
  CellMargins->{{Inherited, 36}, {Inherited, Inherited}},
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["3.4 Your turn", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.8.3"],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ShowOne[Lab3]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to bring up an alleged group. With careful examination of the Cayley \
table, you should be able to answer the following. (Also indicate the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[OpenCurlyDoubleQuote]",
  StyleBox["case number",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyDoubleQuote]",
  StyleBox[
  " of the alleged group.)\n\n\t(a) Determine if the set is closed under the \
given operation. If so, why is it, and if not, why not?\n\n\t(b) Determine if \
there is an identity element. If so, state it, and if not, why not? \n\n\t(c) \
Determine the inverse of each element, where one exists. \n\n\t(d) Use the \
associativity test to make a conjecture whether the operation is associative \
or not. (Remember to specify the particular case number in the argument of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["LG[]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ".)\n\n\t(e) Although not a required property to be a group, determine if \
this operation is commutative.\n\n\t(f) Finally, determine whether the set \
with the operation is indeed a group. (Guess, if you are not fully convinced \
about the associativity.) ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowOne[Lab3]\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Repeat the instructions in question 1. (Again, indicate the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[OpenCurlyDoubleQuote]",
  StyleBox["case number",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyDoubleQuote]",
  StyleBox[" of the alleged group for this question.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowOne[Lab3]\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[" Repeat the instructions in question 1. (Again, indicate the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[OpenCurlyDoubleQuote]",
  StyleBox["case number",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyDoubleQuote]",
  StyleBox[" of the alleged group for this question.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowOne[Lab3]\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Repeat the instructions in question 1. (Again, indicate the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[OpenCurlyDoubleQuote]",
  StyleBox["case number",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyDoubleQuote]",
  StyleBox[" of the alleged group for this question.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowOne[Lab3]\)], "Input",
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["3.5 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:3.9.3"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?ShowOne", "Input",
  AspectRatioFixed->True],

Cell["?RandomAssociativeQ", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{630, 437},
WindowMargins->{{3, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 3 Is this a group?", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AkXY0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:3.3"->{
    Cell[2382, 76, 165, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:3.3"]},
  "a:3.4.3"->{
    Cell[2572, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:3.4.3"]},
  "a:3.5.3"->{
    Cell[7095, 240, 107, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.5.3"]},
  "a:3.6.3"->{
    Cell[7533, 257, 99, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.6.3"]},
  "a:3.7.3"->{
    Cell[8038, 275, 176, 4, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.7.3"]},
  "a:3.8.3"->{
    Cell[81291, 1570, 103, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.8.3"]},
  "a:3.9.3"->{
    Cell[85368, 1716, 370, 14, 35, "Section",
      Evaluatable->False,
      CellTags->"a:3.9.3"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:3.3", 87941, 1797},
  {"a:3.4.3", 88049, 1801},
  {"a:3.5.3", 88162, 1805},
  {"a:3.6.3", 88275, 1809},
  {"a:3.7.3", 88387, 1813},
  {"a:3.8.3", 88500, 1817},
  {"a:3.9.3", 88615, 1821}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 165, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:3.3"],

Cell[CellGroupData[{
Cell[2572, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:3.4.3"],
Cell[2898, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3775, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5171, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5349, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[5997, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6715, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7095, 240, 107, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.5.3"],
Cell[7205, 245, 291, 7, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7533, 257, 99, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.6.3"],
Cell[7635, 262, 366, 8, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8038, 275, 176, 4, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.7.3"],
Cell[8217, 281, 1564, 51, 109, "Text",
  Evaluatable->False],
Cell[9784, 334, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[9959, 340, 407, 14, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10391, 358, 158, 4, 27, "Input",
  Evaluatable->False],
Cell[10552, 364, 385, 12, 72, "Print",
  Evaluatable->False],
Cell[10940, 378, 68394, 1133, 295, 4089, 332, "GraphicsData", 
"PostScript", "Graphics",
  Evaluatable->False]
}, Closed]],
Cell[79349, 1514, 1450, 34, 128, "Text",
  Evaluatable->False],
Cell[80802, 1550, 143, 3, 27, "Input"],
Cell[80948, 1555, 156, 5, 33, "Text",
  Evaluatable->False],
Cell[81107, 1562, 147, 3, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[81291, 1570, 103, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.8.3"],
Cell[81397, 1575, 1670, 44, 390, "Question",
  Evaluatable->False],
Cell[83070, 1621, 72, 2, 27, "Input"],
Cell[83145, 1625, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[83222, 1629, 549, 18, 67, "Question",
  Evaluatable->False],
Cell[83774, 1649, 72, 2, 27, "Input"],
Cell[83849, 1653, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[83926, 1657, 549, 18, 67, "Question",
  Evaluatable->False],
Cell[84478, 1677, 72, 2, 27, "Input"],
Cell[84553, 1681, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[84630, 1685, 549, 18, 67, "Question",
  Evaluatable->False],
Cell[85182, 1705, 72, 2, 27, "Input"],
Cell[85257, 1709, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[85368, 1716, 370, 14, 35, "Section",
  Evaluatable->False,
  CellTags->"a:3.9.3"],
Cell[85741, 1732, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[86086, 1743, 51, 1, 27, "Input"],
Cell[86140, 1746, 62, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

