(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     67700,       2490]*)
(*NotebookOutlinePosition[     71002,       2599]*)
(*  CellTagsIndexPosition[     70673,       2584]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 5",
    FontSize->18],
  "\nSubversively Grouping Our Elements"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.5"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["5.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.6.5"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.7.5"],

Cell["\<\
To complete this lab, you should be familiar with the definition of \
a subgroup of a group.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.8.5"],

Cell[TextData[{
  StyleBox[
  "What constitutes a subgroup? What elements are necessary before a set can \
be considered a subgroup? What do the subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" look like? What about the subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[
  "? What is the probability that a randomly chosen subset of elements from ",
    
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" will actually be a subgroup? What elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" guarantee ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["closure",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " to the full group? These are some of the questions that are explored in \
this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.3 When do we have a subgroup?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.9.5"],

Cell[TextData[StyleBox[
"In Group Lab 3, we considered when a set with an operation on the set forms \
a group. In this lab, we consider when a subset of a group is a group in its \
own right (when using the operation from the parent set). ",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["First let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider a random group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " in [6, 20]. To define this group, we need to first read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" package that defines ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" and the other functions that we will be using.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {6, 20}]\), 
    \(G = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we pick a random integer ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", less than ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  ", and then choose this many elements from ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and put them in a set that we call ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(m = Random[Integer, {1, Floor[N[\@n]]}]\), 
    \(H = RandomElements[G, m, Replacement \[Rule] False]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The question we would like to pursue first is whether this set ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " forms a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", and if not, how we can make one with it."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". In this case, is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["? Justify your answer. (Indicate the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and subset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" that were chosen.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Now use the following command to confirm your answer to question 1.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SubgroupQ[H, G]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Simply knowing whether it is true or false if ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is of limited value. We would also like to know how to make ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " become a subgroup (by adding certain elements, if necessary). Let\
\[CloseCurlyQuote]s look at a Cayley table where we focus on the elements of \
",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SubgroupQ[H, G, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that the elements colored red are in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " but not in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". The presence of red elements (if any) indicates that the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" does not satisfy which property relative to the operation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["What would happen if we modified ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " to include some (or all) of the elements that were sums of elements in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ",",
  StyleBox[" but not already in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " ",
  StyleBox["(namely, the red elements)? In the variable labeled ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ElementsToAdd",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", add the elements (between {}) you would like to join to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" to see if you can make ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" a subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ElementsToAdd = {}; \ \nH = Union[Join[H, ElementsToAdd]]\), 
    \(\(SubgroupQ[H, G, Mode \[Rule] Visual]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". By deleting the previous elements in the list ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ElementsToAdd",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " and replacing them with new ones, keep modifying the code until you have \
enlarged ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " to become a subgroup. You will know that you are done if there are no \
longer any red elements. (You may have enlarged ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" to become ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" itself.) What is your subgroup ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox["? (Also, what was your group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try this again."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(n = Random[Integer, {6, 20}]; \)\), 
    \(G = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(m = Random[Integer, {1, Floor[N[\@n]]}]\), 
    \(H = RandomElements[G, m, Replacement \[Rule] False]\), 
    \(\(SubgroupQ[H, G, Mode \[Rule] Visual]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". As before, keep modifying the following code until you have enlarged ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" to become a subgroup. What is your subgroup ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox["? (Also, what was your group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " and the original ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox["?)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ElementsToAdd = {}; \nH = Union[Join[H, ElementsToAdd]]\), 
    \(\(SubgroupQ[H, G, Mode \[Rule] Visual]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Once you feel comfortable knowing how to enlarge ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" to make it a subgroup, you can ask ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " to do that part and you can focus on related issues. We call the new \
subgroup of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" formed from the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["closure of ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and we can use the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Closure",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" command.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try this with a new group.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(n = Random[Integer, {6, 20}]; \)\), 
    \(G = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(m = Random[Integer, {1, Floor[N[\@n]]}]\), 
    \(H = RandomElements[G, m, Replacement \[Rule] False]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "If all we want is to determine the closure of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", we use the following."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Closure[G, H]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["(Apply ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SortGroupoid",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to this result if you want to see the elements ordered.) If we ever want \
to know what else we can do with a function, it is often useful to ask for \
information about the function:",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Closure\)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try a few of these variations."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Closure[G, H, ReportIterations \[Rule] True]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that this returns the closure of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " first, followed by the number of iterations and the results of each \
iteration. Let\[CloseCurlyQuote]s consider another option."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Closure[G, H, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
This simply shows the same information visually. These graphics can \
now be animated, if desired. (To do so, double-click on one of the graphics \
and adjust the motion with the arrow keys.) If we do not want to see all the \
graphics at once, we can try the following.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Closure[G, H, Mode \[Rule] Visual, Staged \[Rule] True]; \)\)], 
  "Input",
  AspectRatioFixed->True],

Cell["To see the next stage, evaluate the following.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(NextStage[Closure]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["Or to see a previous stage, try", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(PreviousStage[Closure]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Either of these last two commands can be repeatedly cycled. Test \
yourself one more time; evaluate the following.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {6, 20}]\), 
    \(G = Z[n]\), 
    \(m = Random[Integer, {1, Floor[N[\@n]]}]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(H = RandomElements[G, m, Replacement \[Rule] False]\), 
    \(\(Closure[G, H, Mode \[Rule] Visual, Staged \[Rule] True]; \)\)}], 
  "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "You should know which elements need to be added. Now predict which \
elements will be colored red, if any, in the next iteration. When you think \
you know, evaluate the following. Keep doing this until you have found the \
closure of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(NextStage[Closure]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". You may have noticed that sometimes the closure becomes the whole group. \
There are many questions related to this to think about, some of which we \
consider in this lab. Here is one with which to start. If we let ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H(n)\)]],
  StyleBox[" be the size of the closure of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" at the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["th iteration (so ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H(1) = \(\(| H\) | \)\)]],
  StyleBox["), how big does",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`H(n)\)]],
  StyleBox[" have to become before we can be certain that the closure of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" will be all of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  "? You may wish to evaluate the following cell a number of times to gain \
some insights.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(n = Random[Integer, {6, 30}]; \)\), 
    \(G = Z[n]\), 
    \(\(m = Random[Integer, {1, Floor[N[\@n]]}]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(H\  = \ RandomElements[G, \ m, \ Replacement\  \[Rule] \ False]\), 
    \(\(\(Closure[G, \ H, \ ReportIterations\  \[Rule] \ True] // Last\) // 
        Last\) // ColumnForm\)}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "5.4 Subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.10.5"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s pick a random group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is in [6, 30]."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {6, 30}]\), 
    \(G = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "What are the subgroups of this group ",
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_n\)]],
  "? One naive way of exploring this would be to pick a random set of \
elements and look at the closure, which we have seen always results in a \
subgroup. If we repeat this enough times, we might find all the subgroups of \
the group. Let\[CloseCurlyQuote]s try it. Evaluate the following three to \
five times."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(m = Random[Integer, {1, Floor[N[\@n]]}]; \)\), 
    \(H = RandomElements[G, m, Replacement \[Rule] False]\), 
    \(Closure[G, H, Sort \[Rule] True]\n\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "You may notice that the full group is often returned. Suppose we try \
restricting the number of elements in ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " to one or two. Try evaluating the following a number of times."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(m = Random[Integer, {1, 2}]; \)\), 
    \(H = RandomElements[G, m, Replacement \[Rule] False]\), 
    \(Closure[G, H, Sort \[Rule] True]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What do you think are the subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" for the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" with which you have been working? (Also indicate what ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" you were given.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s get a new group and try this again."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {6, 30}]\), 
    \(G = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(m = Random[Integer, {1, 2}]; \)\), 
    \(H = RandomElements[G, m, Replacement \[Rule] False]\), 
    \(Closure[G, H, Sort \[Rule] True]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What group did you get this time? What do you think are the subgroups \
for this group?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "5.5 ",
  Cell[BoxData[
      \(TraditionalForm\`P(H < G)\)]],
  " for a random subset ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_n\)]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.11.5"],

Cell[TextData[{
  "Suppose we consider the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  ". Recall that if ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", we sometimes denote this by ",
  Cell[BoxData[
      \(TraditionalForm\`H < G\)]],
  ". If we choose a random set of elements, ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ", from the elements of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ", what is the probability that ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " is indeed a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " (denoted ",
  Cell[BoxData[
      \(TraditionalForm\`P(H < G)\)]],
  ")? In this section, we pursue this question (and modifications of it, \
using other indices ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " in ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ")."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[12]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "First we start with ",
  Cell[BoxData[
      \(TraditionalForm\`\(\( | H\) | \) = 1\)]],
  ". Evaluate the following to determine the results of randomly choosing one \
element 30 different times to see if it forms a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sizeOfH = 1; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {30}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Out of the 30 attempts, how many yielded a subgroup? What did you expect \
to happen? What would you expect to happen if 100 people did this experiment \
and each ran the loop for 1000 times instead of 30? Justify your answer. You \
should have an answer for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P(H < \[DoubleStruckCapitalZ]\_12)\)]],
  StyleBox[" for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = {g}\)]],
  StyleBox[" for some ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we consider the case when ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(| H\) | \) = 2\)]],
  ". Evaluate the following to determine the results of choosing two elements \
(40 times) to see if the subset forms a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sizeOfH = 2; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If you didn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t get a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", try evaluating this cell again (which will not guarantee a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" but may be worth trying, in some cases).",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". How many successes did you have? (That is, how many times did you get ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  "?) Which pair of elements yielded a subgroup, if any? Is there any (other) \
subset of size two that will (also) be a subgroup? Why or why not? Given a \
random set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" of two elements from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[", what do you think is the probability that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" will be a subgroup (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P(H < \[DoubleStruckCapitalZ]\_12)\)]],
  StyleBox[")?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we consider the case when ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(| H\) | \) = 3\)]],
  ". Evaluate the following to determine the results of choosing three \
elements (40 times) to see if the subset forms a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sizeOfH = 3; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If you didn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t get a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", try evaluating this cell again. (Again, no guarantee.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". How many successes did you have? Which triple of elements yielded a \
subgroup, if any? Is there any (other) subset of size three that will (also) \
be a subgroup? Why or why not? Given a random set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" consisting of three elements of",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[", what is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`P(H < \[DoubleStruckCapitalZ]\_12)\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we consider the case when ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(| H\) | \) = 4\)]],
  ". Evaluate the following to determine the results of choosing four \
elements (40 times) to see if the subset forms a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sizeOfH = 4; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["If you didn",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["t get a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  ", evaluate again until you do, keeping track of how many attempts were \
made. If you get tired of doing this and think you know what you should \
expect, you can quit.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Next we consider the case when ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(| H\) | \) = 5\)]],
  ". Evaluate the following to determine the results of choosing five \
elements (40 times) to see if the subset forms a subgroup of ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(sizeOfH = 5; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Keep trying to get ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["True",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" or stop when you think you know what is likely to happen.",
    Evaluatable->False,
    AspectRatioFixed->True],
  " Keep increasing the order of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " and evaluating the cell until you can answer the following question."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Given ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[", what are the different possible orders of the subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["? Also, how many subgroups are there of each order?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Now suppose we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_10\)]],
  StyleBox[". What are the orders of the subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  " and how many subgroups are there of each order? Use the following cell if \
you want to do some experimenting.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[10]; \nsizeOfH = 1; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Now suppose we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_11\)]],
  StyleBox[". What are the orders of the subgroups of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  " and how many are there of each order? Use the following cell if you want \
to do some experimenting.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[11]; \nsizeOfH = 1; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Summarize your findings by writing a conjecture about the subgroup \
structure of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[". How might you prove your answer?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Given ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" and a subset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\(| H\) | \) = m\)]],
  StyleBox[", what is",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`P(H < G)\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Look back at the subgroups you found for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[
  ". Starting with the subgroup(s) of order 2 and working up, what can you \
say about the relationship(s), if any, between the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["order",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of the subgroup, the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[", and the actual elements in the subgroup?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Do you think the results summarized in question 14 pertain only to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" or are they valid for other groups (either some or all)",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox[
  "as well? Try the following to help you think about this question.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = U[20]\), 
    \(sizeOfH = 2; \n
    TableForm[
      Table[{H = RandomElements[G, sizeOfH, Replacement \[Rule] False], 
          SubgroupQ[H, G]}, {40}], TableDepth \[Rule] 2, 
      TableHeadings \[Rule] {None, {"\<H\>", "\<(H < G)?\n\>"}}]\)}], "Input",\

  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["5.6 Necessary elements for full closure", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.12.5"],

Cell[TextData[{
  "Suppose we focus on the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_10\)]],
  " as an example in thinking about the question of what elements must be in \
a set ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " to guarantee that we have the closure of ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " be the entire group."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "First we define ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[10]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Then we look at a table of random sets ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  " with one or two elements, with their closure."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[
      Table[m = Random[Integer, {1, 2}]; {
          H = RandomElements[G, m, Replacement \[Rule] False], 
          Elements[Closure[G, H, Sort \[Rule] True]]}, {25}], 
      TableHeadings \[Rule] {None, {"\<H\>", "\<closure of H\n\>"}}, 
      TableSpacing \[Rule] {0.5, 3}, TableDepth \[Rule] 2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Partition the elements of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_10\)]],
  StyleBox[" into three classes: (1) those whose presence in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" cause the closure of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" to be the full group, (2) those whose presence in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" do NOT cause the closure of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[
  " to be the full group, and (3) the elements you are not sure about.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider another example, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G = Z[8]\), 
    \(TableForm[
      Table[m = Random[Integer, {1, 2}]; {
          H = RandomElements[G, m, Replacement \[Rule] False], 
          Elements[Closure[G, H, Sort \[Rule] True]]}, {25}], 
      TableHeadings \[Rule] {None, {"\<H\>", "\<closure of H\n\>"}}, 
      TableSpacing \[Rule] {0.5, 3}, TableDepth \[Rule] 2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Repeat question 18 with the results of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_8\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Finally, consider another example,",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(G\  = \ Z[12]\ \), 
    \(ColumnForm[
      Table[m\  = \ Random[Integer, \ {1, \ 2}]; \n
        \t{H\  = \ RandomElements[G, \ m, \ Replacement\  \[Rule] \ False], \n
          \t\tElements[Closure[G, \ H, \ Sort\  \[Rule] \ True]]}, \ {25}]]
      \)}], "Input"],

Cell[TextData[{
  StyleBox["Q20",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Consider the results of the last three examples. If",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  Cell[BoxData[
      \(TraditionalForm\`H = {g, h}\)]],
  StyleBox[" is a subset of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[" and the closure of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  StyleBox[" is all of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[
  ", what can you conclude about the relationship between at least one of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" or ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  StyleBox[" and the number ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "5.7 Subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.13.5"],

Cell[TextData[{
  "For a quick review of the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  ", let\[CloseCurlyQuote]s view the first 20 groups where ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " runs from 1 to 20."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ColumnForm[Table[{n, \ Elements[U[n]]}, \ {n, \ 1, \ 20}]]\)], "Input"],

Cell[TextData[{
  "From this it should be clear how many elements are in each group listed \
here (and if you answered all the questions from Group Lab 4, you perhaps \
know the order of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " as a function of ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " for any ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  "). What about the subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  "? Since we know that the trivial subgroup consisting of the identity is \
always a subgroup, as is the full group, we can ignore them. Therefore, the \
first group to consider for nontrivial subgroups is ",
  Cell[BoxData[
      \(TraditionalForm\`U\_5\)]],
  ". (Why?) Furthermore, we know that any subgroup must have the identity, so \
we can be sure that 1 will be in any subgroup."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s look at the possible subgroups of ",
  Cell[BoxData[
      \(TraditionalForm\`U\_5\)]],
  " by first considering all the nonidentity elements. (Recall what the \
complement of a set is and that 1 is the identity.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(els = Complement[Elements[U[5]], {1}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "These are the elements from which we need to consider all possible \
subsets. The function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["KSubsets",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" (from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["DiscreteMath`Combinatorica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[") does this job.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?KSubsets\)\)], "Input"],

Cell[TextData[{
  "We will make a table of all possible subsets of length 1, 2, ... up to one \
less than the length of ",
  StyleBox["els",
    FontFamily->"Courier"],
  ", which is 2 (= 3 - 1) in this case. (We have deleted the identity 1 from \
",
  StyleBox["els",
    FontFamily->"Courier"],
  ", and we know that the full group is a subgroup, so we search for sets of \
length up to two less than the size of the group.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Table[KSubsets[els, i], {i, Length[els] - 1}]\)], "Input",
  AspectRatioFixed->True],

Cell["There are too many levels of braces, so we remove one level.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Flatten[%, 1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Now we want to join the identity back into each one. These are now ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["candidates",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" for being (proper) subgroups.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Hsets\  = \ Map[Join[{1}, \ #]&, \ %]\)], "Input"],

Cell[TextData[{
  StyleBox["The next step is to test them by mapping the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SubgroupQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function on each one.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(subgroups\  = \ Map[SubgroupQ[#, \ U[5]]&, \ Hsets]\)], "Input"],

Cell["\<\
It is easier to see which are subgroups if we match up the sets \
with these results.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Transpose[{Hsets, \ subgroups}] // MatrixForm\)], "Input"],

Cell[TextData[{
  StyleBox["Q21",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What can you say about the order of the element 2? What about 3? What \
about 4? Do you think ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_5\)]],
  StyleBox[" is cyclic or not? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Now let\[CloseCurlyQuote]s put all the steps above into one compact function \
that gives the final output."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(FindNontrivialSubgroupsOfUn[n_Integer?Positive]\  := \ \n\t\t
      Module[{els, \ Hsets, \ subgroups}, \n\t
        els\  = \ Complement[Elements[U[n]], \ {1}]; \n\t
        Hsets\  = \ 
          Flatten[Table[KSubsets[els, \ i], \ {i, \ Length[els] - 1}], \ 1]; 
        \n\tHsets\  = \ Map[Join[#, \ {1}]&, \ Hsets]; \n\t
        subgroups\  = \ Map[SubgroupQ[#, \ U[n]]&, \ Hsets]; \n\t
        Transpose[{Hsets, \ subgroups}] // MatrixForm\n]\ \)\)], "Input"],

Cell[TextData[{
  "It is time to test it on the next index, ",
  Cell[BoxData[
      \(TraditionalForm\`n = 6\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[6]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q22",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What happened? Was there a mistake made in the coding? Think about this. \
Why was there no output?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "What about ",
  Cell[BoxData[
      \(TraditionalForm\`n = 7\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[7]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "We see many ",
  StyleBox["False",
    FontFamily->"Courier"],
  " conclusions. Why? Can we be more efficient in our search for subgroups? \
How many elements are there in ",
  Cell[BoxData[
      \(TraditionalForm\`U\_7\)]],
  "?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Elements[U[7]] // Length\)], "Input"],

Cell[TextData[{
  StyleBox[
  "Perhaps through some previous experiences, in this lab, a previous lab, or \
classwork, you have become aware that if we have a subgroup, its order must \
be a divisor of the order of the group. This is an important result, called \
Lagrange",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s Theorem, which will be proven later.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "What are the divisors of 6? It is easy in this case, but here is how ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" can be asked.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(divs = Divisors[6]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Now let\[CloseCurlyQuote]s gather all the actual \
\[OpenCurlyDoubleQuote]HSets\[CloseCurlyDoubleQuote] our function \
generates."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(temp\  = \ 
      \(\(FindNontrivialSubgroupsOfUn[7]\)[\([1]\)] // Transpose\) // First
        \)], "Input"],

Cell[TextData[
"Since we really have questions about only those of orders 2 and 3 (why?), \
let\[CloseCurlyQuote]s select just them."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Select[temp, MemberQ[{2, 3}, Length[#1]]&]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Now we can test them as subgroups. The last several steps are \
implemented in a new version of our function.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Clear[FindNontrivialSubgroupsOfUn]; \n\n
    FindNontrivialSubgroupsOfUn[n_Integer?Positive]\  := \ \n\t\t
      Module[{els, \ Hsets, \ subgroups, \ divs}, \n\t
        els\  = \ Complement[Elements[U[n]], \ {1}]; \n\t
        Hsets\  = \ 
          Flatten[Table[KSubsets[els, \ i], \ {i, \ Length[els] - 1}], \ 1]; 
        \n\tHsets\  = \ Map[Join[#, \ {1}]&, \ Hsets]; \n\t
        Hsets\  = \ 
          Select[Hsets, \ 
            MemberQ[Complement[Divisors[Order[U[n]]], \n\t\t{1, \ n}], \ 
                Length[#]]&]; \n\t
        subgroups\  = \ Map[SubgroupQ[#, \ U[n]]&, \ Hsets]; \n\t
        Transpose[{Hsets, \ subgroups}] // MatrixForm\n]\ \)\)], "Input"],

Cell["Now we try it again.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[7]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q23",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do you think ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_7\)]],
  StyleBox[" is cyclic? Why or why not? ",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[8]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q24",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do you think ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_8\)]],
  StyleBox[" is cyclic? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[9]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q25",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do you think ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_9\)]],
  StyleBox[" is cyclic? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[10]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q26",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do you think ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_10\)]],
  StyleBox[" is cyclic? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
If you are willing to wait a little while, try the following.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FindNontrivialSubgroupsOfUn[11]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q27",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why does this take so long?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "We can also use a more general function that determines the actual \
subgroups for any (finite) group (given enough time, memory, and disk space). \
Here we try it on ",
  Cell[BoxData[
      \(TraditionalForm\`U\_20\)]],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Subgroups[U[20]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q28",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do you think ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_20\)]],
  StyleBox[" is cyclic? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "5.8 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:5.14.5"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Z\)\)], "Input"],

Cell["?RandomElements", "Input",
  AspectRatioFixed->True],

Cell["?Replacement", "Input",
  AspectRatioFixed->True],

Cell["?SubgroupQ", "Input",
  AspectRatioFixed->True],

Cell["?Mode", "Input",
  AspectRatioFixed->True],

Cell["?Visual", "Input",
  AspectRatioFixed->True],

Cell["?Closure", "Input",
  AspectRatioFixed->True],

Cell["?SortGroupoid", "Input",
  AspectRatioFixed->True],

Cell["?ReportIterations", "Input",
  AspectRatioFixed->True],

Cell["?Staged", "Input",
  AspectRatioFixed->True],

Cell["?NextStage", "Input",
  AspectRatioFixed->True],

Cell["?PreviousStage", "Input",
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?U\)\)], "Input"],

Cell["?Subgroups", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{621, 426},
WindowMargins->{{5, Automatic}, {Automatic, 4}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {Cell[ 
        TextData[ {
          ValueBox[ "FileName"]}], "Header"], Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 5 Subversively grouping our elements", FontSlant -> "Italic"], 
          "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AkXY0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:5.5"->{
    Cell[2382, 76, 183, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:5.5"]},
  "a:5.6.5"->{
    Cell[2590, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.6.5"]},
  "a:5.7.5"->{
    Cell[7113, 240, 107, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.7.5"]},
  "a:5.8.5"->{
    Cell[7424, 255, 99, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.8.5"]},
  "a:5.9.5"->{
    Cell[8811, 304, 121, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.9.5"]},
  "a:5.10.5"->{
    Cell[25951, 937, 197, 7, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.10.5"]},
  "a:5.11.5"->{
    Cell[29494, 1066, 328, 13, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.11.5"]},
  "a:5.12.5"->{
    Cell[46773, 1686, 130, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.12.5"]},
  "a:5.13.5"->{
    Cell[52655, 1904, 175, 7, 35, "Section",
      Evaluatable->False,
      CellTags->"a:5.13.5"]},
  "a:5.14.5"->{
    Cell[66199, 2418, 309, 12, 55, "Section",
      Evaluatable->False,
      CellTags->"a:5.14.5"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:5.5", 69518, 2540},
  {"a:5.6.5", 69626, 2544},
  {"a:5.7.5", 69739, 2548},
  {"a:5.8.5", 69852, 2552},
  {"a:5.9.5", 69964, 2556},
  {"a:5.10.5", 70078, 2560},
  {"a:5.11.5", 70194, 2564},
  {"a:5.12.5", 70312, 2568},
  {"a:5.13.5", 70429, 2572},
  {"a:5.14.5", 70546, 2576}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 183, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:5.5"],

Cell[CellGroupData[{
Cell[2590, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.6.5"],
Cell[2916, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3793, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5189, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5367, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6015, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6733, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7113, 240, 107, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.7.5"],
Cell[7223, 245, 164, 5, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7424, 255, 99, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.8.5"],
Cell[7526, 260, 1248, 39, 109, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8811, 304, 121, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.9.5"],
Cell[8935, 309, 348, 7, 71, "Text",
  Evaluatable->False],
Cell[9286, 318, 980, 33, 52, "Text",
  Evaluatable->False],
Cell[10269, 353, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[10444, 359, 108, 3, 43, "Input"],
Cell[10555, 364, 417, 16, 52, "Text",
  Evaluatable->False],
Cell[10975, 382, 162, 3, 50, "Input"],
Cell[11140, 387, 314, 10, 52, "Text",
  Evaluatable->False],
Cell[11457, 399, 812, 30, 67, "Question",
  Evaluatable->False],
Cell[12272, 431, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[12349, 435, 141, 5, 33, "Text",
  Evaluatable->False],
Cell[12493, 442, 74, 2, 27, "Input"],
Cell[12570, 446, 569, 18, 71, "Text",
  Evaluatable->False],
Cell[13142, 466, 95, 2, 27, "Input"],
Cell[13240, 470, 243, 10, 33, "Text",
  Evaluatable->False],
Cell[13486, 482, 598, 20, 67, "Question",
  Evaluatable->False],
Cell[14087, 504, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[14164, 508, 1306, 46, 90, "Text",
  Evaluatable->False],
Cell[15473, 556, 171, 3, 59, "Input"],
Cell[15647, 561, 1330, 46, 105, "Question",
  Evaluatable->False],
Cell[16980, 609, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[17057, 613, 112, 2, 33, "Text",
  Evaluatable->False],
Cell[17172, 617, 114, 3, 43, "Input"],
Cell[17289, 622, 215, 4, 66, "Input"],
Cell[17507, 628, 810, 29, 67, "Question",
  Evaluatable->False],
Cell[18320, 659, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[18397, 663, 169, 3, 59, "Input"],
Cell[18569, 668, 1424, 52, 71, "Text",
  Evaluatable->False],
Cell[19996, 722, 265, 10, 33, "Text",
  Evaluatable->False],
Cell[20264, 734, 114, 3, 43, "Input"],
Cell[20381, 739, 162, 3, 50, "Input"],
Cell[20546, 744, 203, 7, 33, "Text",
  Evaluatable->False],
Cell[20752, 753, 72, 2, 27, "Input"],
Cell[20827, 757, 511, 16, 71, "Text",
  Evaluatable->False],
Cell[21341, 775, 71, 2, 27, "Input"],
Cell[21415, 779, 127, 2, 33, "Text",
  Evaluatable->False],
Cell[21545, 783, 103, 2, 27, "Input"],
Cell[21651, 787, 301, 8, 52, "Text",
  Evaluatable->False],
Cell[21955, 797, 93, 2, 27, "Input"],
Cell[22051, 801, 342, 7, 71, "Text",
  Evaluatable->False],
Cell[22396, 810, 123, 3, 27, "Input"],
Cell[22522, 815, 110, 2, 33, "Text",
  Evaluatable->False],
Cell[22635, 819, 83, 2, 27, "Input"],
Cell[22721, 823, 95, 2, 33, "Text",
  Evaluatable->False],
Cell[22819, 827, 87, 2, 27, "Input"],
Cell[22909, 831, 186, 5, 52, "Text",
  Evaluatable->False],
Cell[23098, 838, 158, 4, 65, "Input"],
Cell[23259, 844, 187, 4, 43, "Input"],
Cell[23449, 850, 370, 10, 71, "Text",
  Evaluatable->False],
Cell[23822, 862, 83, 2, 27, "Input"],
Cell[23908, 866, 1545, 51, 143, "Question",
  Evaluatable->False],
Cell[25456, 919, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25533, 923, 170, 4, 65, "Input"],
Cell[25706, 929, 208, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[25951, 937, 197, 7, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.10.5"],
Cell[26151, 946, 279, 10, 33, "Text",
  Evaluatable->False],
Cell[26433, 958, 108, 3, 43, "Input"],
Cell[26544, 963, 510, 11, 90, "Text",
  Evaluatable->False],
Cell[27057, 976, 213, 4, 82, "Input"],
Cell[27273, 982, 306, 8, 52, "Text",
  Evaluatable->False],
Cell[27582, 992, 199, 4, 59, "Input"],
Cell[27784, 998, 735, 25, 67, "Question",
  Evaluatable->False],
Cell[28522, 1025, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[28599, 1029, 133, 3, 33, "Text",
  Evaluatable->False],
Cell[28735, 1034, 108, 3, 43, "Input"],
Cell[28846, 1039, 199, 4, 59, "Input"],
Cell[29048, 1045, 332, 12, 48, "Question",
  Evaluatable->False],
Cell[29383, 1059, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[29494, 1066, 328, 13, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.11.5"],
Cell[29825, 1081, 1059, 38, 90, "Text",
  Evaluatable->False],
Cell[30887, 1121, 68, 2, 27, "Input"],
Cell[30958, 1125, 364, 11, 52, "Text",
  Evaluatable->False],
Cell[31325, 1138, 285, 6, 91, "Input"],
Cell[31613, 1146, 1053, 34, 105, "Question",
  Evaluatable->False],
Cell[32669, 1182, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[32746, 1186, 366, 11, 52, "Text",
  Evaluatable->False],
Cell[33115, 1199, 285, 6, 91, "Input"],
Cell[33403, 1207, 689, 24, 52, "Text",
  Evaluatable->False],
Cell[34095, 1233, 1342, 45, 105, "Question",
  Evaluatable->False],
Cell[35440, 1280, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[35517, 1284, 368, 11, 52, "Text",
  Evaluatable->False],
Cell[35888, 1297, 285, 6, 91, "Input"],
Cell[36176, 1305, 476, 17, 33, "Text",
  Evaluatable->False],
Cell[36655, 1324, 991, 32, 86, "Question",
  Evaluatable->False],
Cell[37649, 1358, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[37726, 1362, 367, 11, 52, "Text",
  Evaluatable->False],
Cell[38096, 1375, 285, 6, 91, "Input"],
Cell[38384, 1383, 591, 20, 52, "Text",
  Evaluatable->False],
Cell[38978, 1405, 367, 11, 52, "Text",
  Evaluatable->False],
Cell[39348, 1418, 285, 6, 91, "Input"],
Cell[39636, 1426, 545, 17, 52, "Text",
  Evaluatable->False],
Cell[40184, 1445, 623, 20, 67, "Question",
  Evaluatable->False],
Cell[40810, 1467, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40887, 1471, 681, 22, 86, "Question",
  Evaluatable->False],
Cell[41571, 1495, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41648, 1499, 298, 6, 107, "Input"],
Cell[41949, 1507, 671, 22, 67, "Question",
  Evaluatable->False],
Cell[42623, 1531, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[42700, 1535, 298, 6, 107, "Input"],
Cell[43001, 1543, 503, 17, 67, "Question",
  Evaluatable->False],
Cell[43507, 1562, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[43584, 1566, 1012, 39, 48, "Question",
  Evaluatable->False],
Cell[44599, 1607, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[44676, 1611, 938, 29, 86, "Question",
  Evaluatable->False],
Cell[45617, 1642, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[45694, 1646, 653, 21, 86, "Question",
  Evaluatable->False],
Cell[46350, 1669, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[46427, 1673, 309, 8, 107, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[46773, 1686, 130, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.12.5"],
Cell[46906, 1691, 443, 14, 52, "Text",
  Evaluatable->False],
Cell[47352, 1707, 151, 7, 33, "Text",
  Evaluatable->False],
Cell[47506, 1716, 68, 2, 27, "Input"],
Cell[47577, 1720, 219, 7, 33, "Text",
  Evaluatable->False],
Cell[47799, 1729, 368, 7, 91, "Input"],
Cell[48170, 1738, 1096, 36, 86, "Question",
  Evaluatable->False],
Cell[49269, 1776, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[49346, 1780, 186, 7, 33, "Text",
  Evaluatable->False],
Cell[49535, 1789, 389, 8, 107, "Input"],
Cell[49927, 1799, 424, 15, 48, "Question",
  Evaluatable->False],
Cell[50354, 1816, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[50431, 1820, 415, 15, 33, "Text",
  Evaluatable->False],
Cell[50849, 1837, 286, 6, 75, "Input"],
Cell[51138, 1845, 1403, 50, 86, "Question",
  Evaluatable->False],
Cell[52544, 1897, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[52655, 1904, 175, 7, 35, "Section",
  Evaluatable->False,
  CellTags->"a:5.13.5"],
Cell[52833, 1913, 298, 10, 33, "Text",
  Evaluatable->False],
Cell[53134, 1925, 91, 1, 27, "Input"],
Cell[53228, 1928, 912, 24, 128, "Text",
  Evaluatable->False],
Cell[54143, 1954, 316, 8, 52, "Text",
  Evaluatable->False],
Cell[54462, 1964, 96, 2, 27, "Input"],
Cell[54561, 1968, 619, 22, 52, "Text",
  Evaluatable->False],
Cell[55183, 1992, 46, 1, 27, "Input"],
Cell[55232, 1995, 487, 13, 90, "Text",
  Evaluatable->False],
Cell[55722, 2010, 104, 2, 27, "Input"],
Cell[55829, 2014, 124, 2, 33, "Text",
  Evaluatable->False],
Cell[55956, 2018, 72, 2, 27, "Input"],
Cell[56031, 2022, 413, 14, 52, "Text",
  Evaluatable->False],
Cell[56447, 2038, 70, 1, 27, "Input"],
Cell[56520, 2041, 381, 13, 33, "Text",
  Evaluatable->False],
Cell[56904, 2056, 84, 1, 27, "Input"],
Cell[56991, 2059, 157, 5, 33, "Text",
  Evaluatable->False],
Cell[57151, 2066, 78, 1, 27, "Input"],
Cell[57232, 2069, 498, 17, 67, "Question",
  Evaluatable->False],
Cell[57733, 2088, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[57810, 2092, 182, 4, 33, "Text",
  Evaluatable->False],
Cell[57995, 2098, 487, 8, 139, "Input"],
Cell[58485, 2108, 180, 7, 33, "Text",
  Evaluatable->False],
Cell[58668, 2117, 89, 2, 27, "Input"],
Cell[58760, 2121, 345, 12, 67, "Question",
  Evaluatable->False],
Cell[59108, 2135, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[59185, 2139, 150, 7, 33, "Text",
  Evaluatable->False],
Cell[59338, 2148, 89, 2, 27, "Input"],
Cell[59430, 2152, 310, 11, 52, "Text",
  Evaluatable->False],
Cell[59743, 2165, 57, 1, 27, "Input"],
Cell[59803, 2168, 516, 14, 71, "Text",
  Evaluatable->False],
Cell[60322, 2184, 400, 14, 33, "Text",
  Evaluatable->False],
Cell[60725, 2200, 77, 2, 27, "Input"],
Cell[60805, 2204, 204, 5, 33, "Text",
  Evaluatable->False],
Cell[61012, 2211, 129, 3, 27, "Input"],
Cell[61144, 2216, 191, 4, 33, "Text",
  Evaluatable->False],
Cell[61338, 2222, 101, 2, 27, "Input"],
Cell[61442, 2226, 181, 5, 52, "Text",
  Evaluatable->False],
Cell[61626, 2233, 697, 13, 203, "Input"],
Cell[62326, 2248, 84, 2, 33, "Text",
  Evaluatable->False],
Cell[62413, 2252, 89, 2, 27, "Input"],
Cell[62505, 2256, 403, 15, 48, "Question",
  Evaluatable->False],
Cell[62911, 2273, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[62988, 2277, 89, 2, 27, "Input"],
Cell[63080, 2281, 402, 15, 48, "Question",
  Evaluatable->False],
Cell[63485, 2298, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[63562, 2302, 89, 2, 27, "Input"],
Cell[63654, 2306, 402, 15, 48, "Question",
  Evaluatable->False],
Cell[64059, 2323, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[64136, 2327, 90, 2, 27, "Input"],
Cell[64229, 2331, 403, 15, 48, "Question",
  Evaluatable->False],
Cell[64635, 2348, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[64712, 2352, 136, 5, 33, "Text",
  Evaluatable->False],
Cell[64851, 2359, 90, 2, 27, "Input"],
Cell[64944, 2363, 270, 10, 48, "Question",
  Evaluatable->False],
Cell[65217, 2375, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[65294, 2379, 307, 9, 52, "Text",
  Evaluatable->False],
Cell[65604, 2390, 75, 2, 27, "Input"],
Cell[65682, 2394, 403, 15, 48, "Question",
  Evaluatable->False],
Cell[66088, 2411, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[66199, 2418, 309, 12, 55, "Section",
  Evaluatable->False,
  CellTags->"a:5.14.5"],
Cell[66511, 2432, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[66856, 2443, 39, 1, 27, "Input"],
Cell[66898, 2446, 58, 1, 27, "Input"],
Cell[66959, 2449, 55, 1, 27, "Input"],
Cell[67017, 2452, 53, 1, 27, "Input"],
Cell[67073, 2455, 48, 1, 27, "Input"],
Cell[67124, 2458, 50, 1, 27, "Input"],
Cell[67177, 2461, 51, 1, 27, "Input"],
Cell[67231, 2464, 56, 1, 27, "Input"],
Cell[67290, 2467, 60, 1, 27, "Input"],
Cell[67353, 2470, 50, 1, 27, "Input"],
Cell[67406, 2473, 53, 1, 27, "Input"],
Cell[67462, 2476, 57, 1, 27, "Input"],
Cell[67522, 2479, 52, 1, 27, "Input"],
Cell[67577, 2482, 39, 1, 27, "Input"],
Cell[67619, 2485, 53, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

