(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     46816,       1668]*)
(*NotebookOutlinePosition[     49808,       1766]*)
(*  CellTagsIndexPosition[     49536,       1753]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 6",
    FontSize->18],
  "\nCycling Through the Groups"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.6"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["6.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.7.6"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["6.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.8.6"],

Cell["\<\
Other than familiarity with the basic definitions related to a \
group, there are no prerequisites.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["6.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.9.6"],

Cell[TextData[{
  "We first look at what it means for a group to be cyclic and try to \
determine the generators when it is. We try to classify the cyclicity of the \
groups ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`D\_n\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  " and determine the set of generators when they are cyclic. Next we \
consider the case when the direct product of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " yields a cyclic group. Finally, we look at some of the cyclic subgroups \
of the infinite additive group of integers, \[DoubleStruckCapitalZ]."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["6.3 What, when, how, and why about cyclic groups", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.10.6"],

Cell[TextData[{
  StyleBox["We need to read in the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Master",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" package inside the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" directory to conduct this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Recall that we say a group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["cyclic",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" if there exists an element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" such that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`G\  = \ {g\^k | k \[Element] \[DoubleStruckCapitalZ]}\)]],
  StyleBox[". In this case, we call ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["generator",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" and denote this relationship by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]g\[RightAngleBracket] = G\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["Which groups, if any, are cyclic? First let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s consider a random group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[", for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" in [6, 14].",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(n = Random[Integer, {6, 14}]\), 
    \(G = Z[n]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Is this group cyclic? How can we find out? Recalling the definition of \
being cyclic (which was written for multiplicative groups), we need to see if \
there is an element ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" such that the set of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["multiples",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" constitutes the whole group. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s generate multiples of each element and find out if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" is cyclic. Note that since our group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" is finite with order ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", we need to consider only a finite number of multiples.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Why is it true that we need to consider only a finite number of \
multiples? Explain your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "So let\[CloseCurlyQuote]s take a look at some multiples of each of the \
elements in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(els = Elements[G]\), 
    \(TableForm[
      multiples = 
        Table[j\ els\[LeftDoubleBracket]i\[RightDoubleBracket], {i, n}, {j, 
            n}], TableHeadings 
        \[Rule] {
          Table["\<multiples of \>"<>ToString[i]<>"\<:\>", {i, 0, n - 1}], 
          None}, TableSpacing \[Rule] {0.5, 1}]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Whoops! These don\[CloseCurlyQuote]t all look like elements in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  ". What did we forget?"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Map[Mod[#1, n]&, multiples], 
      TableHeadings 
        \[Rule] {
          Table["\<multiples of \>"<>ToString[i]<>"\<:\>", {i, 0, n - 1}], 
          None}, TableSpacing \[Rule] {0.5, 1}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The first list of numbers represents multiples of 0, the second list \
represents multiples of 1, the third list has the multiples of 2, and so on; \
the last row represents multiples of ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Do any of these lists represent ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox["? Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" cyclic? What had you expected? If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[
  " is cyclic, what are the generators? Does this list of generators surprise \
you? (Record the group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  StyleBox[" that was given to you.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["We can get similar results by using a function called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["SubgroupGenerated",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Table[Elements[SubgroupGenerated[G, \ g]], \ \n
        \t{g, \ 0, \ n\  - \ 1}] // ColumnForm\)], "Input"],

Cell[BoxData[
    \(\(?SubgroupGenerated\)\)], "Input"],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s focus on ",
  Cell[BoxData[
      \(TraditionalForm\`G = \[DoubleStruckCapitalZ]\_12\)]],
  " for the moment. (If this is the group that was randomly generated for \
you, pardon the redundancy.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[12]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Does the element 5 generate the whole group? Let\[CloseCurlyQuote]s find \
out."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SubgroupGenerated[G, 5]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
The list, as given, is the order in which the elements are \
generated. To see this with a little more explanation, try the \
following:\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SubgroupGenerated[G, 5, Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
A visual perspective might also be useful. Evaluate the following \
cell and then double-click on any graphic cell (perhaps closing the enclosing \
cell bracket first) and then adjust the speed by typing a number from 1 \
(slow) to 9 (fast). Or you can step through the animation with the (up/down) \
arrow keys.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(SubgroupGenerated[G, 5, Mode \[Rule] Visual]; \)\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
What follows is another visual way of seeing the subgroup generated \
by 5. In this case, the colors indicate the order in which the multiples \
(powers) occur, following the rainbow; the key at the bottom helps by listing \
the element in the colored box and the multiple (power) above it.\
\>", "Text",\

  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SubgroupGenerated[G, 5, Mode \[Rule] Visual2]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "These illustrations show that indeed ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  " is cyclic. If there is a Thomas in the crowd, he/she can also try"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CyclicQ[Z[12]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["It is interesting to know not only ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["whether",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a group is cyclic but what elements generate the whole group. Try the \
following.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[G, Mode \[Rule] Textual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What are the generators of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_12\)]],
  StyleBox["? How do you know? Justify your answer.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["We can also approach the question visually:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[G, Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Look at this table. What observations can you make? Can you explain any \
of these observations?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s consider the group ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Z[15]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine if ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_15\)]],
  " ",
  StyleBox[
  "is cyclic. If so, specify the generators; if not, explain why not.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_17\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s check out the cyclicity of some other ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[{n, CyclicQ[Z[n]]}, {n, 2, 25}], 
      TableSpacing \[Rule] {0.5, 2}, 
      TableHeadings \[Rule] {None, {"\<n\>", "\<cyclic?\n\>"}}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What conclusion can you infer about the cyclicity of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox["? Prove your statement, if you can.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For an arbitrary ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", what elements are the generators of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox[
  "? You should be able to be very specific with a description here. Can you \
also specify (as a function of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["), the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["number",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of generators for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let\[CloseCurlyQuote]s think about some other groups. What about the \
dihedral family?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(CyclicQ[Dihedral[1]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(CyclicQ[Dihedral[2]]\)], "Input",
  AspectRatioFixed->True],

Cell["Or if you wish to see this visually, try", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[Dihedral[2], Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[Dihedral[3], Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[Dihedral[4], Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Table",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" allows us to quickly look at a few more examples",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(TableForm[Table[{n, CyclicQ[Dihedral[n]]}, {n, 5, 8}]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". What do you suppose is true about ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_n\)]],
  " ",
  StyleBox["being cyclic? Justify your answer. Can you prove it?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "What about the group ",
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  "? Let\[CloseCurlyQuote]s consider a few examples."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[U[15], Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[U[14], Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfAllElements[U[13], Mode \[Rule] Visual]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[" cyclic for all ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox["? Why or why not?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Considering only whether ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[" is cyclic or not, we can use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Table",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["CyclicQ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[". The following is already generated",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  StyleBox["do not evaluate the cell again.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(TableForm[
      Partition[Table[{n, \ CyclicQ[U[n]]}, \ {n, \ 3, \ 52}], 10] // 
        Transpose, \n\tTableSpacing\  \[Rule] \ {0.5, \ 1.5}, \ 
      TableDepth\  \[Rule] 2]\n (*\ 
      already\ evaluated\  - \ simply\ open\ up\ *) \)\)], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    TagBox[GridBox[{
          {\({3, True}\), \({13, True}\), \({23, True}\), \({33, False}\), 
            \({43, True}\)},
          {\({4, True}\), \({14, True}\), \({24, False}\), \({34, True}\), 
            \({44, False}\)},
          {\({5, True}\), \({15, False}\), \({25, True}\), \({35, False}\), 
            \({45, False}\)},
          {\({6, True}\), \({16, False}\), \({26, True}\), \({36, False}\), 
            \({46, True}\)},
          {\({7, True}\), \({17, True}\), \({27, True}\), \({37, True}\), 
            \({47, True}\)},
          {\({8, False}\), \({18, True}\), \({28, False}\), \({38, True}\), 
            \({48, False}\)},
          {\({9, True}\), \({19, True}\), \({29, True}\), \({39, False}\), 
            \({49, True}\)},
          {\({10, True}\), \({20, False}\), \({30, False}\), \({40, False}\), 
            \({50, True}\)},
          {\({11, True}\), \({21, False}\), \({31, True}\), \({41, True}\), 
            \({51, False}\)},
          {\({12, False}\), \({22, True}\), \({32, False}\), \({42, False}\), 
            \({52, False}\)}
          },
        RowSpacings->0.5,
        ColumnSpacings->1.5,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0.5, 1.5}, TableDepth -> 2]&)]], 
  "Output",
  Editable->False,
  Deletable->False]
}, Closed]],

Cell[TextData[
"Here is another list that is also already generated\[LongDash]do not \
evaluate the cell again."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(TableForm[
      Partition[Table[{n, \ CyclicQ[U[n]]}, \ {n, \ 53, \ 104}], 10] // 
        Transpose, \n\tTableSpacing\  \[Rule] \ {0.5, \ 1.5}, \ 
      TableDepth\  \[Rule] 2]\n (*\ 
      already\ evaluated\  - \ simply\ open\ up\ *) \)\)], "Input",
  CellDingbat->"\[WatchIcon]"],

Cell[BoxData[
    TagBox[GridBox[{
          {\({53, True}\), \({63, False}\), \({73, True}\), \({83, True}\), 
            \({93, False}\)},
          {\({54, True}\), \({64, False}\), \({74, True}\), \({84, False}\), 
            \({94, True}\)},
          {\({55, False}\), \({65, False}\), \({75, False}\), 
            \({85, False}\), \({95, False}\)},
          {\({56, False}\), \({66, False}\), \({76, False}\), \({86, True}\), 
            \({96, False}\)},
          {\({57, False}\), \({67, True}\), \({77, False}\), \({87, False}\), 
            \({97, True}\)},
          {\({58, True}\), \({68, False}\), \({78, False}\), \({88, False}\), 
            \({98, True}\)},
          {\({59, True}\), \({69, False}\), \({79, True}\), \({89, True}\), 
            \({99, False}\)},
          {\({60, False}\), \({70, False}\), \({80, False}\), 
            \({90, False}\), \({100, False}\)},
          {\({61, True}\), \({71, True}\), \({81, True}\), \({91, False}\), 
            \({101, True}\)},
          {\({62, True}\), \({72, False}\), \({82, True}\), \({92, False}\), 
            \({102, False}\)}
          },
        RowSpacings->0.5,
        ColumnSpacings->1.5,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0.5, 1.5}, TableDepth -> 2]&)]], 
  "Output",
  Editable->False,
  Deletable->False]
}, Closed]],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For what values of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" is ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`U\_n\)]],
  StyleBox[" cyclic? ",
    Evaluatable->False,
    AspectRatioFixed->True],
  "(Think about the answer\[LongDash]you do not need to list the values.) ",
  StyleBox["Can you see any patterns? What conclusions can you draw?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.4 Cyclicity of ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[CirclePlus]\[DoubleStruckCapitalZ]\_n\)]]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.11.6"],

Cell[TextData[{
  "We are familiar with the ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " groups. Suppose we consider pairing up two (possibly the same) ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_n\)]],
  " groups and making a new group from the pairs. For example, consider ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  " and form all pairs ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " where the ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " comes from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " and the ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " comes from ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  ": ",
  Cell[BoxData[
      \(TraditionalForm
      \`G = {\((x, y)\) | 
            x \[Element] \[DoubleStruckCapitalZ]\_2 \[And] 
              y \[Element] \[DoubleStruckCapitalZ]\_3}\)]],
  ". What are the elements in ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  "? This is called the direct sum (also called direct product) of ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_2\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalZ]\_3\)]],
  ", denoted here simply by ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_2\[CirclePlus]\[DoubleStruckCapitalZ]\_3
          \)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Elements[DirectSum[Z[2], Z[3]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Note that all the first elements in the pairs are either 0 or 1 and the \
second elements are 0, 1, or 2, exactly as specified. So what operation do we \
use? There is a \[OpenCurlyDoubleQuote]natural\[CloseCurlyDoubleQuote] one to \
consider. Suppose ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " are generic elements. Then we say ",
  Cell[BoxData[
      \(TraditionalForm
      \`\((x, y)\) + \((a, b)\) = 
        \((\((x + a)\)\ mod\ 2, \((y + b)\)\ mod\ 3)\)\)]],
  ". In other words, we treat each dimension (component or coordinate) as we \
did before joining them, using the operation of the contributing group for \
that part."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Do some calculations in this setting.\n\ta. (0, 1) + (1, 0) = ?\n\tb. \
(1, 1) + (1, 1) = ?\n\tc. (1, 0) + (1, 2) = ?\n\td. (0, 1) + (0, 2) = ?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Consider the Cayley table of the group.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(CayleyTable[DirectSum[Z[2], Z[3]], Mode \[Rule] Visual]; \)\)], 
  "Input",
  AspectRatioFixed->True],

Cell["\<\
Since the elements do not fit very well in the limited space in the \
table, we use the Key to guide us.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Check your answers to the previous question. Were they right? Is this \
group Abelian? Why? What is the identity? Is the group cyclic? How do you \
know?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "So when is ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[CirclePlus]\[DoubleStruckCapitalZ]\_n
          \)]],
  " cyclic? The following produces a table for various ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " (and is already evaluated\[LongDash]simply open it up)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(Flatten[
            Table[G\  = \ DirectSum[Z[m], \ Z[n]]; \ {m, \ n, \ CyclicQ[G]}, 
              \ {m, \ 2, \ 7}, \ {n, \ 2, \ 7}], \ 1] // 
          Partition[#, 9]&\) // Transpose\) // 
      TableForm[#, \ 
          TableHeadings\  \[Rule] \ {None, \ {"\<{m,n, cyclic?}\n\>"}}, \ 
          TableSpacing\  \[Rule] \ {0.5, \ 2}, \ TableDepth\  \[Rule] 2]&\n (*
      \ already\ evaluated\  - \ simply\ open\ it\ up\ *) \)\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("{m,n, cyclic?}\n"\), "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
          {\({2, 2, False}\), \({3, 5, True}\), \({5, 2, True}\), 
            \({6, 5, True}\)},
          {\({2, 3, True}\), \({3, 6, False}\), \({5, 3, True}\), 
            \({6, 6, False}\)},
          {\({2, 4, False}\), \({3, 7, True}\), \({5, 4, True}\), 
            \({6, 7, True}\)},
          {\({2, 5, True}\), \({4, 2, False}\), \({5, 5, False}\), 
            \({7, 2, True}\)},
          {\({2, 6, False}\), \({4, 3, True}\), \({5, 6, True}\), 
            \({7, 3, True}\)},
          {\({2, 7, True}\), \({4, 4, False}\), \({5, 7, True}\), 
            \({7, 4, True}\)},
          {\({3, 2, True}\), \({4, 5, True}\), \({6, 2, False}\), 
            \({7, 5, True}\)},
          {\({3, 3, False}\), \({4, 6, False}\), \({6, 3, False}\), 
            \({7, 6, True}\)},
          {\({3, 4, True}\), \({4, 7, True}\), \({6, 4, False}\), 
            \({7, 7, False}\)}
          },
        RowSpacings->0.5,
        ColumnSpacings->2,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableHeadings -> {None, {"{m,n, cyclic?}\n"}}, 
        TableSpacing -> {0.5, 2}, TableDepth -> 2]&)]], "Output",
  Editable->False,
  Deletable->False]
}, Closed]],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Give a conjecture about the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["necessary",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" conditions for ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleStruckCapitalZ]\_m\[CirclePlus]\[DoubleStruckCapitalZ]\_n
          \)]],
  " ",
  StyleBox["to be cyclic. How might a proof go?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"6.5 Structure of intersections of subgroups of \[DoubleStruckCapitalZ]"], 
  "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.12.6"],

Cell[TextData[{
  "For any integer ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  ", the subgroup ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]m\[RightAngleBracket]\)]],
  " is a cyclic subgroup of the integers \[DoubleStruckCapitalZ]. Given two \
such subgroups, ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]m\[RightAngleBracket]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]n\[RightAngleBracket]\)]],
  ", we know that the intersection of these two subgroups is another subgroup \
(as is the intersection of any two subgroups from the same group). \
Furthermore, we know that it is another subgroup of the form ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]p\[RightAngleBracket]\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why must this intersection look like ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]p\[RightAngleBracket]\)]],
  StyleBox[" for some integer ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Let\[CloseCurlyQuote]s look at some examples. Since these subgroups are \
all infinite, all we can do is look at a finite swath, but this should be \
sufficient to build our intuition. Consider ",
  Cell[BoxData[
      \(TraditionalForm\`H = \[LeftAngleBracket]4\[RightAngleBracket]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K = \[LeftAngleBracket]10\[RightAngleBracket]\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(leftAndRight = 15; \)\), 
    \(H = Table[4\ i, {i, \(-leftAndRight\), leftAndRight}]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Table[10\ i, {i, \(-leftAndRight\), leftAndRight}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(H \[Intersection] K\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q16",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What does the intersection appear to be? What connection, if any, is \
there between your answer and the fact that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = \[LeftAngleBracket]4\[RightAngleBracket]\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K = \[LeftAngleBracket]10\[RightAngleBracket]\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider ",
  Cell[BoxData[
      \(TraditionalForm\`H = \[LeftAngleBracket]4\[RightAngleBracket]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K = \[LeftAngleBracket]11\[RightAngleBracket]\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(leftAndRight = 22; \)\), 
    \(H = Table[4\ i, {i, \(-leftAndRight\), leftAndRight}]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Table[11\ i, {i, \(-leftAndRight\), leftAndRight}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(H \[Intersection] K\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q17",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What does the intersection appear to be? What connection, if any, is \
there between your answer and the fact that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = \[LeftAngleBracket]4\[RightAngleBracket]\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K = \[LeftAngleBracket]11\[RightAngleBracket]\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Consider ",
  Cell[BoxData[
      \(TraditionalForm\`H = \[LeftAngleBracket]4\[RightAngleBracket]\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`K = \[LeftAngleBracket]12\[RightAngleBracket]\)]],
  ":"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(leftAndRight = 15; \)\), 
    \(H = Table[4\ i, {i, \(-leftAndRight\), leftAndRight}]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(K = Table[12\ i, {i, \(-leftAndRight\), leftAndRight}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(H \[Intersection] K\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q18",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". What does the intersection appear to be? What connection, if any, is \
there between your answer and the fact that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`H = \[LeftAngleBracket]4\[RightAngleBracket]\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`K = \[LeftAngleBracket]12\[RightAngleBracket]\)]],
  StyleBox["?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q19",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Can you give a conjecture? Test it with a few more examples. Try to \
prove it.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "6.6 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:6.13.6"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?Elements", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?Map\)\)], "Input"],

Cell[BoxData[
    \(\(?Mod\)\)], "Input"],

Cell["?SubgroupGenerated", "Input",
  AspectRatioFixed->True],

Cell["?CyclicQ", "Input",
  AspectRatioFixed->True],

Cell["?OrderOfAllElements", "Input",
  AspectRatioFixed->True],

Cell["?Dihedral", "Input",
  AspectRatioFixed->True],

Cell["?U", "Input",
  AspectRatioFixed->True],

Cell["?DirectSum", "Input",
  AspectRatioFixed->True],

Cell["?DirectProduct", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Working",
PrintingStyleEnvironment->"Printout",
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{632, 435},
WindowMargins->{{3, Automatic}, {Automatic, 1}},
PrintingCopies->1,
PrintingPageRange->{5, 6},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ 
          "Lab 6 Cycling through the groups", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:6.6"->{
    Cell[2382, 76, 175, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:6.6"]},
  "a:6.7.6"->{
    Cell[2582, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:6.7.6"]},
  "a:6.8.6"->{
    Cell[7105, 240, 107, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.8.6"]},
  "a:6.9.6"->{
    Cell[7423, 255, 99, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.9.6"]},
  "a:6.10.6"->{
    Cell[8418, 288, 139, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.10.6"]},
  "a:6.11.6"->{
    Cell[31879, 1135, 243, 8, 55, "Section",
      Evaluatable->False,
      CellTags->"a:6.11.6"]},
  "a:6.12.6"->{
    Cell[39072, 1372, 175, 5, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.12.6"]},
  "a:6.13.6"->{
    Cell[45589, 1611, 309, 12, 35, "Section",
      Evaluatable->False,
      CellTags->"a:6.13.6"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:6.6", 48613, 1717},
  {"a:6.7.6", 48721, 1721},
  {"a:6.8.6", 48834, 1725},
  {"a:6.9.6", 48947, 1729},
  {"a:6.10.6", 49060, 1733},
  {"a:6.11.6", 49175, 1737},
  {"a:6.12.6", 49292, 1741},
  {"a:6.13.6", 49409, 1745}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 175, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:6.6"],

Cell[CellGroupData[{
Cell[2582, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:6.7.6"],
Cell[2908, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3785, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5181, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5359, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[6007, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6725, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7105, 240, 107, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.8.6"],
Cell[7215, 245, 171, 5, 33, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7423, 255, 99, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.9.6"],
Cell[7525, 260, 856, 23, 109, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8418, 288, 139, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.10.6"],
Cell[8560, 293, 563, 20, 52, "Text",
  Evaluatable->False],
Cell[9126, 315, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[9301, 321, 2043, 74, 71, "Text",
  Evaluatable->False],
Cell[11347, 397, 108, 3, 43, "Input"],
Cell[11458, 402, 1508, 50, 109, "Text",
  Evaluatable->False],
Cell[12969, 454, 342, 12, 67, "Question",
  Evaluatable->False],
Cell[13314, 468, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[13391, 472, 220, 8, 33, "Text",
  Evaluatable->False],
Cell[13614, 482, 369, 9, 75, "Input"],
Cell[13986, 493, 218, 7, 33, "Text",
  Evaluatable->False],
Cell[14207, 502, 261, 6, 59, "Input"],
Cell[14471, 510, 326, 9, 52, "Text",
  Evaluatable->False],
Cell[14800, 521, 905, 32, 86, "Question",
  Evaluatable->False],
Cell[15708, 555, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[15785, 559, 377, 13, 33, "Text",
  Evaluatable->False],
Cell[16165, 574, 127, 2, 43, "Input"],
Cell[16295, 578, 55, 1, 27, "Input"],
Cell[16353, 581, 297, 8, 52, "Text",
  Evaluatable->False],
Cell[16653, 591, 68, 2, 27, "Input"],
Cell[16724, 595, 154, 4, 33, "Text",
  Evaluatable->False],
Cell[16881, 601, 82, 2, 27, "Input"],
Cell[16966, 605, 208, 6, 52, "Text",
  Evaluatable->False],
Cell[17177, 613, 104, 2, 27, "Input"],
Cell[17284, 617, 384, 8, 90, "Text",
  Evaluatable->False],
Cell[17671, 627, 109, 2, 27, "Input"],
Cell[17783, 631, 364, 8, 71, "Text",
  Evaluatable->False],
Cell[18150, 641, 104, 2, 27, "Input"],
Cell[18257, 645, 263, 7, 52, "Text",
  Evaluatable->False],
Cell[18523, 654, 73, 2, 27, "Input"],
Cell[18599, 658, 431, 15, 52, "Text",
  Evaluatable->False],
Cell[19033, 675, 102, 2, 27, "Input"],
Cell[19138, 679, 450, 15, 48, "Question",
  Evaluatable->False],
Cell[19591, 696, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[19668, 700, 107, 2, 33, "Text",
  Evaluatable->False],
Cell[19778, 704, 101, 2, 27, "Input"],
Cell[19882, 708, 341, 12, 67, "Question",
  Evaluatable->False],
Cell[20226, 722, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[20303, 726, 207, 7, 33, "Text",
  Evaluatable->False],
Cell[20513, 735, 68, 2, 27, "Input"],
Cell[20584, 739, 473, 17, 48, "Question",
  Evaluatable->False],
Cell[21060, 758, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21137, 762, 396, 15, 48, "Question",
  Evaluatable->False],
Cell[21536, 779, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21613, 783, 221, 7, 33, "Text",
  Evaluatable->False],
Cell[21837, 792, 210, 4, 43, "Input"],
Cell[22050, 798, 471, 15, 48, "Question",
  Evaluatable->False],
Cell[22524, 815, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[22601, 819, 1115, 39, 86, "Question",
  Evaluatable->False],
Cell[23719, 860, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23796, 864, 162, 4, 33, "Text",
  Evaluatable->False],
Cell[23961, 870, 79, 2, 27, "Input"],
Cell[24043, 874, 79, 2, 27, "Input"],
Cell[24125, 878, 104, 2, 33, "Text",
  Evaluatable->False],
Cell[24232, 882, 111, 2, 27, "Input"],
Cell[24346, 886, 111, 2, 27, "Input"],
Cell[24460, 890, 111, 2, 27, "Input"],
Cell[24574, 894, 291, 10, 33, "Text",
  Evaluatable->False],
Cell[24868, 906, 113, 2, 27, "Input"],
Cell[24984, 910, 454, 16, 48, "Question",
  Evaluatable->False],
Cell[25441, 928, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[25518, 932, 207, 7, 33, "Text",
  Evaluatable->False],
Cell[25728, 941, 105, 2, 27, "Input"],
Cell[25836, 945, 105, 2, 27, "Input"],
Cell[25944, 949, 105, 2, 27, "Input"],
Cell[26052, 953, 514, 20, 48, "Question",
  Evaluatable->False],
Cell[26569, 975, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[26646, 979, 811, 29, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[27482, 1012, 304, 6, 75, "Input"],
Cell[27789, 1020, 1356, 30, 153, "Output"]
}, Closed]],
Cell[29160, 1053, 170, 4, 30, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29355, 1061, 306, 6, 75, "Input"],
Cell[29664, 1069, 1375, 30, 153, "Output"]
}, Closed]],
Cell[31054, 1102, 711, 24, 65, "Question",
  Evaluatable->False],
Cell[31768, 1128, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[31879, 1135, 243, 8, 55, "Section",
  Evaluatable->False,
  CellTags->"a:6.11.6"],
Cell[32125, 1145, 1617, 51, 109, "Text",
  Evaluatable->False],
Cell[33745, 1198, 90, 2, 27, "Input"],
Cell[33838, 1202, 802, 20, 109, "Text",
  Evaluatable->False],
Cell[34643, 1224, 389, 12, 124, "Question",
  Evaluatable->False],
Cell[35035, 1238, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[35112, 1242, 103, 2, 33, "Text",
  Evaluatable->False],
Cell[35218, 1246, 123, 3, 27, "Input"],
Cell[35344, 1251, 176, 5, 33, "Text",
  Evaluatable->False],
Cell[35523, 1258, 399, 13, 67, "Question",
  Evaluatable->False],
Cell[35925, 1273, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[36002, 1277, 448, 15, 52, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[36475, 1296, 468, 8, 107, "Input"],
Cell[36946, 1306, 1300, 29, 158, "Output"]
}, Closed]],
Cell[38261, 1338, 697, 25, 65, "Question",
  Evaluatable->False],
Cell[38961, 1365, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[39072, 1372, 175, 5, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.12.6"],
Cell[39250, 1379, 841, 22, 90, "Text",
  Evaluatable->False],
Cell[40094, 1403, 570, 20, 48, "Question",
  Evaluatable->False],
Cell[40667, 1425, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[40744, 1429, 475, 12, 52, "Text",
  Evaluatable->False],
Cell[41222, 1443, 148, 3, 43, "Input"],
Cell[41373, 1448, 113, 2, 27, "Input"],
Cell[41489, 1452, 78, 2, 27, "Input"],
Cell[41570, 1456, 686, 22, 67, "Question",
  Evaluatable->False],
Cell[42259, 1480, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[42336, 1484, 290, 10, 33, "Text",
  Evaluatable->False],
Cell[42629, 1496, 148, 3, 43, "Input"],
Cell[42780, 1501, 113, 2, 27, "Input"],
Cell[42896, 1505, 78, 2, 27, "Input"],
Cell[42977, 1509, 686, 22, 67, "Question",
  Evaluatable->False],
Cell[43666, 1533, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[43743, 1537, 290, 10, 33, "Text",
  Evaluatable->False],
Cell[44036, 1549, 148, 3, 43, "Input"],
Cell[44187, 1554, 113, 2, 27, "Input"],
Cell[44303, 1558, 78, 2, 27, "Input"],
Cell[44384, 1562, 686, 22, 67, "Question",
  Evaluatable->False],
Cell[45073, 1586, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[45150, 1590, 325, 12, 48, "Question",
  Evaluatable->False],
Cell[45478, 1604, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[45589, 1611, 309, 12, 35, "Section",
  Evaluatable->False,
  CellTags->"a:6.13.6"],
Cell[45901, 1625, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[46246, 1636, 52, 1, 27, "Input"],
Cell[46301, 1639, 41, 1, 27, "Input"],
Cell[46345, 1642, 41, 1, 27, "Input"],
Cell[46389, 1645, 61, 1, 27, "Input"],
Cell[46453, 1648, 51, 1, 27, "Input"],
Cell[46507, 1651, 62, 1, 27, "Input"],
Cell[46572, 1654, 52, 1, 27, "Input"],
Cell[46627, 1657, 45, 1, 27, "Input"],
Cell[46675, 1660, 53, 1, 27, "Input"],
Cell[46731, 1663, 57, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

