(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     61297,       2232]*)
(*NotebookOutlinePosition[     64340,       2332]*)
(*  CellTagsIndexPosition[     64038,       2318]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Name(s): ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Exploring Abstract Algebra with Mathematica\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Al Hibbard and Ken Levasseur",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->14,
    FontSlant->"Plain"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Subsubtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Group Lab 7",
    FontSize->18],
  "\nPermutations"
}], "Title",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.7"],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["7.0 Note regarding ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.8.7"],

Cell[TextData[{
  StyleBox[
  "This lab is intended to supplement an abstract algebra course. It is part \
of a series of labs and packages under the name ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica,",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " a joint project by Al Hibbard (Central College) and Ken Levasseur \
(UMass-Lowell). This is also the title of a book published by TELOS/Springer \
Verlag that contains this lab. This book includes labs for group theory, labs \
for ring theory, and a user",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s guide with printed and electronic documentation.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["For more information on the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Exploring Abstract Algebra with Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" project, go to our web site at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.central.edu/eaam.html",
    ButtonData:>{
      URL[ "http://www.central.edu/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". This site is also mirrored at ",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["http://www.uml.edu/Dept/Math/eaam/eaam.html",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/eaam/eaam.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox[". There you will find the latest versions of the packages in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", the latest palettes available to supplement ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["AbstractAlgebra",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[", and other related resources.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["You may also contact either of the authors:",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Al Hibbard",
    ButtonData:>{
      URL[ "http://www.central.edu/homepages/hibbarda/hibbard.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Central College",
    ButtonData:>{
      URL[ "http://www.central.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nPella, IA 50219\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["hibbarda@central.edu",
    ButtonData:>{
      URL[ "mailto://hibbarda@central.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  ButtonBox["Ken Levasseur",
    ButtonData:>{
      URL[ "http://www.uml.edu/Dept/Math/LevasseuK.html"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["UMass Lowell",
    ButtonData:>{
      URL[ "http://www.uml.edu"], None},
    ButtonStyle->"Hyperlink"],
  StyleBox["\nLowell, MA",
    Evaluatable->False,
    AspectRatioFixed->True],
  " ",
  StyleBox["01854\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  ButtonBox["Kenneth_Levasseur@uml.edu",
    ButtonData:>{
      URL[ "mailto://Kenneth_Levasseur@uml.edu"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Last revision: April 25, 1998\n\n",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Copyright] Copyright 1998 Springer-Verlag New York, Inc.",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSize->10,
    FontSlant->"Plain"]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["7.1 Prerequisites", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.9.7"],

Cell[TextData[
"To complete this lab, you should have a good understanding of functions, \
including \[OpenCurlyDoubleQuote]right to left\[CloseCurlyDoubleQuote] \
composition. You do not need to complete any previous labs to attempt this \
one."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["7.2 Goals", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.10.7"],

Cell["\<\
We look at the notion of a permutation and how a group can be \
formed with permutations. Additionally, we look at properties of permutations \
and consider different ways of rewriting a permutation to gain insights \
regarding products and orders.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["7.3 What is a permutation?", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.11.7"],

Cell[TextData[{
  StyleBox["We need to read in the following ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" code to work through this lab.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(Needs["\<AbstractAlgebra`Master`\>"]; \)\), 
    \(\(SwitchStructureTo[Group]; \)\)}], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
What is a permutation? Suppose we had five colored squares labeled \
1 through 5.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(RandomColoredSquares[5]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Suppose further that we decide we wish to change the order in which these \
squares appear. Let\[CloseCurlyQuote]s say we want square 1 to go to the \
second location, square 2 to the third location, square 3 to the first, \
square 4 to the fifth, and square 5 to the fourth."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(PermuteColoredSquares[{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1, 
        4 \[Rule] 5, 5 \[Rule] 4}]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Note how the first square went to the second location (1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 2), the second square went to the third position (2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 3), the third square went to the first position (3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[
  " 1), and so on. Here we say that the second row of squares is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["permutation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " of the squares in the first row. Technically, a permutation of a set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[" is a function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  StyleBox[" from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[" to ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[
  " that is both one-to-one and onto. In the case above, we could define ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{\(g : X\), 
          StyleBox["\[Rule]",
            FontFamily->"Courier"], "X"}], TraditionalForm]]],
  StyleBox[" by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(1) = 2\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(2) = 3\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(3) = 1\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(4) = 5\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`g(5) = 4\)]],
  ", where ",
  Cell[BoxData[
      \(TraditionalForm\`X = {1, 2, 3, 4, 5}\)]],
  StyleBox[". This is often represented by a matrix.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[{1 \[Rule] 2, 2 \[Rule] 3, 3 \[Rule] 1, 4 \[Rule] 5, 
        5 \[Rule] 4}]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Note that the domain occurs in the first row and the corresponding \
range elements in the second row. (Note also that the range, or second row in \
the matrix, is NOT the same as the numbers in the second row of labeled \
squares. There is a connection, however; can you see it?)\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Since permutations are functions, we can combine two permutations by using \
function composition; this is shown in section 7.4. Using this binary \
operation, the set of all permutations of a set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[" is called the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["permutation group of the set ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" If ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[" is the set of integers ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 2, \[Ellipsis]  n}\)]],
  StyleBox[", then we call this group the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["symmetric group of degree ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["(denoted ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_n\)]],
  StyleBox[")",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox[". ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["If the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`X\)]],
  StyleBox[" is some other collection of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[" elements, we can simply (re)label the elements 1 through ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[
  " and still consider the group of permutations as the symmetry group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_n\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["7.4 Computations with permutations", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.12.7"],

Cell["Suppose we have two permutations.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = {1 \[Rule] 2, 2 \[Rule] 4, 3 \[Rule] 3, 4 \[Rule] 5, 5 \[Rule] 1}
        \), 
    \(q = {1 \[Rule] 5, 2 \[Rule] 4, 3 \[Rule] 1, 4 \[Rule] 2, 5 \[Rule] 3}
        \)}], "Input",
  AspectRatioFixed->True],

Cell["We can view each permutation as a matrix.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(PermutationMatrix[p]\), 
    \(PermutationMatrix[q]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "To perform the product of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " followed by ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " (note the order here and below), it may help to think of ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  " as side-by-side matrices."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(SideBySideMatrices[q, p]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Observe that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" is on the left and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[
  " is on the right. We start by first considering the right-hand side. \
Observe that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" maps 1 to 2. Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" follows ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[", we note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" takes 2 to 4. Therefore, the composition of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" takes 1 to 2 to 4, or simply 1 to 4. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s try another. Note that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" takes 5 to the element 1 and that ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[
  " takes the element 1 to the element 5. Therefore the composition of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" takes 5 to 1 to 5 (and thus 5 is said to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["fixed",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" under this composition). The complete product is shown by",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[MultiplyPermutations[q, p]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose we have two permutations ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" given by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"s", "=", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"1", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "2"}], ",", 
              RowBox[{"2", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "3"}], ",", 
              RowBox[{"3", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "1"}], ",", 
              RowBox[{"4", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "4"}]}], "}"}]}], 
        TraditionalForm]]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      FormBox[
        RowBox[{"t", "=", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"1", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "2"}], ",", 
              RowBox[{"2", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "3"}], ",", 
              RowBox[{"3", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "4"}], ",", 
              RowBox[{"4", 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], "1"}]}], "}"}]}], 
        TraditionalForm]]],
  StyleBox[". Determine the two compositions, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`s\)]],
  StyleBox[
  " (indicating which is which). First do your work on paper and then verify \
it using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" functions. What property does ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_4\)]],
  StyleBox[" ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["not",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" have?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "When we viewed the permutation ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " in matrix form, it looked like"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[p]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "You may have noticed that this form always has the top row as the first \
consecutive ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " integers, and the bottom row captures the images of the top row under the \
function defined by the permutation. Therefore, it is really the bottom row \
that holds the important information. Consequently, we frequently refer to a \
permutation by simply using the bottom row."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MultiplyPermutations[{2, 3, 1, 4}, {4, 2, 3, 1}, Mode \[Rule] Textual]
      \)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q2",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Determine the product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{2, 3, 4, 1}\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 3, 2, 4}\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Consider the following permutation and its illustration using \
colored squares.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = {3, 1, 2, 5, 4, 6}\), 
    \(\(ShowColoredPermutation[p]; \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Study the permutation (and/or its colored representation). Note that \
elements in the set ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 2, 3}\)]],
  StyleBox[" permute among themselves, as do the elements in the sets ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{4, 5}\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{6}\)]],
  StyleBox[". In particular, note that we have ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(1) = 3\)]],
  ",",
  Cell[BoxData[
      \(TraditionalForm\`\(\ p(p(1))\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\( = p(3) = 2\)\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p(p(p(1))) = \(p(p(3)) = \(p(2) = 1\)\)\)]],
  StyleBox[". Therefore, these elements cycle through as 1 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 3 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 2 ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" 1. We say that the (ordered) subset ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{1, 3, 2}\)]],
  StyleBox[" is a ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["cycle",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of the permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[". Furthermore, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{4, 5}\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`{6}\)]],
  StyleBox[
  " are also cycles. The standard way to denote these cycles is by the \
notation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((1, 3, 2)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((4, 5)\)\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((6)\)\)]],
  StyleBox[
  " respectively. (Often the commas are dropped, if only single digits are \
used.) Since ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " allows parentheses to be used only as grouping symbols (and not \
delimeters), we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Cycle[1, 3, 2]",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" to denote the cycle ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((1, 3, 2)\)\)]],
  StyleBox["; the leading word ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Cycle",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " should make it clear that a cycle is under discussion, not a permutation. \
Frequently it is convenient to rewrite permutations into disjoint cycles. \
(The three cycles ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((1, 3, 2)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((4, 5)\)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((6)\)\)]],
  StyleBox[" are said to be ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["disjoint",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[
  " since the intersection of any pair is empty.) The following command does \
this.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ToCycles[p]\)], "Input",
  AspectRatioFixed->True],

Cell["The following takes us back.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FromCycles[%]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The cycle ",
  Cell[BoxData[
      \(TraditionalForm\`\((3, 2, 5, 4, 1)\)\)]],
  " is different from the permutation ",
  Cell[BoxData[
      \(TraditionalForm\`{3, 2, 5, 4, 1}\)]],
  ". Study the following until you see how these differ."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(PermutationMatrix[{3, \ 2, \ 5, \ 4, \ 1}]\n (*\ 
      viewing\ the\ permutation\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(PermutationMatrix[FromCycles[{Cycle[3, \ 2, \ 5, \ 4, \ 1]}]]\n (*\ 
      viewing\ the\ cycle; \ 
      the\ output\ is\ the\ cycle\ converted\ to\ a\ permutation\ *) \)\)], 
  "Input"],

Cell["\<\
Read your text for further details about working with cycles; in \
particular, determine how to multiply permutations represented in cycle \
notation.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q3",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Suppose the permutation ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" is given as a product of disjoint cycles as \n",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p = \((1, 2, 5)\)\ \((3, 6)\)\ \((4)\)\)]],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[" is given by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q = \((2, 5, 6)\)\ \((3, 1, 4)\)\)]],
  StyleBox[". Determine the product of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  StyleBox[" followed by ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`q\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["7.5 Applications of permutations", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.13.7"],

Cell["\<\
You may recall working with permutations in Group Labs 1 and 2. \
There, we had figures such as the following.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(ShowFigure[4, {1, 2, 3, 4}, "\<D\>"]; \)\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "In those labs, you were supposed to find all the symmetries of a figure \
and determine the group of symmetries. You may realize now that this figure",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s group of symmetries consists of four rotations and four reflections, the \
dihedral group ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  StyleBox[". Using ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[
  " to represent the lowest-order rotation (90\[Degree] in this case) and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" for any reflection, the group is given by",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Dihedral[4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["This representation of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  StyleBox[
  " is useful in some contexts. However, viewing it in terms of the \
permutations of the four vertices to accomplish these symmetries might be \
more useful at the moment, as well as a reminder of what we did in earlier \
labs.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(G = Dihedral[4, Form \[Rule] Permutations]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s look at just the elements."], "Text"],

Cell[BoxData[
    \(els\  = \ Elements[G]\)], "Input"],

Cell[TextData[{
  StyleBox["Q4",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". As we already know, ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`D\_4\)]],
  StyleBox[
  " consists of four rotations and four reflections. Match up the elements \
when using the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Rot",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Ref",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" form with the elements corresponding to permutations.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Now let\[CloseCurlyQuote]s randomly choose one of these permutations and \
show the result of applying it to our figure."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowPermutation[
      els\[LeftDoubleBracket]Random[Integer, {1, 8}]\[RightDoubleBracket]]
      \)], "Input",
  AspectRatioFixed->True],

Cell["Consider the permutation", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p = {1, 2, 4, 3}\)], "Input",
  AspectRatioFixed->True],

Cell["and its effect on our square:", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ShowPermutation[p]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[StyleBox[
"What symmetry is this? Note that vertices 1 and 2 both stayed fixed. A \
rotation fixes only one point (which one?), so this cannot be a rotation. A \
reflection moves all points except those on the line of reflection. But using \
a line of reflection through vertices 1 and 2 would not land this square back \
onto itself again. Furthermore, it would not transpose vertices 3 and 4. \
Therefore, this is not a symmetry of the square. So what is it? It is just a \
permutation of the vertices that can not be obtained by a symmetry. ",
  Evaluatable->False,
  AspectRatioFixed->True]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Recall that we use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_4\)]],
  StyleBox[
  " to denote the group of all permutations of four objects. This group is \
given below.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Symmetric[4]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["How many elements are there in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_4\)]],
  StyleBox["? The ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["order",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" of a group is precisely that number.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Order[Symmetric[4]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q5",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". For any given ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  StyleBox[", what is the order of ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_n\)]],
  StyleBox["? Why?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["7.6 Questions about permutations", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.14.7"],

Cell["Consider the following permutation.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p1 = {3, 1, 2, 5, 4, 6}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "We might want to know how to write this as a product of disjoint cycles. \
This is something you want to learn how to do ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["without",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" the computer, but for now, let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s use ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ToCycles[p1]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Since there are three cycles, let\[CloseCurlyQuote]s call them ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", and ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \({a, b, c} = ToCycles[p1]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
Recall that cycle notation is not to be read in the same way as a \
permutation. We can determine the permutation for any one of these.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ToPermutation[a, 6]\), 
    \(ToPermutation[b, 6]\), 
    \(ToPermutation[c, 6]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "The second parameter (6) is used to indicate that we want to think of \
these cycles as permutations living inside ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_6\)]],
  StyleBox[" (",
    Evaluatable->False,
    AspectRatioFixed->True],
  "i.e.",
  StyleBox[
  ", permutations of length 6). Without this we get slightly different \
results.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ToPermutation[a]\), 
    \(ToPermutation[b]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
As usual, when a new function is encountered, it is good to learn \
more about it.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(?ToPermutation\)\)], "Input"],

Cell[TextData[{
  StyleBox["Since the cycles ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[", and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  StyleBox[" are really permutations in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_6\)]],
  StyleBox[", it makes sense to multiply them",
    Evaluatable->False,
    AspectRatioFixed->True],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(MultiplyCycles[a, b]\), 
    \(MultiplyCycles[b, a]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"Here\[CloseCurlyQuote]s a shortcut for multiplying cycles."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a\ @\ b\), 
    \(b\ @\ a\)}], "Input"],

Cell["\<\
What happens if we multiply two cycles from another permutation? \
Evaluate the following lines of code until you get a cycle representation \
consisting of at least two cycles, each of which has length at least 2.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p2 = RandomPermutation[9]\), 
    \(ToCycles[p2]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q6",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Multiply the two cycles by hand. Confirm your work with ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[". Record the cycles you multiplied.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Consider the following permutation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_8\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(q = {1, 2, 3, 4, 5, 7, 6, 8}\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s view this in matrix form."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(PermutationMatrix[q]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"It is clear that the only \[OpenCurlyDoubleQuote]action\
\[CloseCurlyDoubleQuote] in the permutation is that 6 goes to 7 and 7 goes to \
6; everything else goes to itself. What happens when we view this using \
cycles?"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ToCycles[q]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q7",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Give a reasonable explanation why the cycles ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((1)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((2)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((3)\)\)]],
  StyleBox[", ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((4)\)\)]],
  ",",
  StyleBox[" and ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((5)\)\)]],
  StyleBox[" are omitted in this list of cycles. Additionally, explain why ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\((8)\)\)]],
  StyleBox[" is included.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["When do two cycles commute? Try the following.", "Text"],

Cell[BoxData[{
    \(Cycle[2, 3, 4]\ @\ Cycle[5, 6]\), 
    \(Cycle[5, 6]\ @\ Cycle[2, 3, 4]\)}], "Input"],

Cell[BoxData[{
    \(Cycle[2, 3, 4]\ @\ \ Cycle[3, 6]\), 
    \(Cycle[3, 6]\ @\ Cycle[2, 3, 4]\)}], "Input"],

Cell[TextData[{
  StyleBox["The following picks a random permutation from ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_6\)]],
  StyleBox[
  ", converts it to cycles, and then grabs the first cycle and calls it ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`\(\ a\)\)]],
  StyleBox[". This is repeated to obtain ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  StyleBox[". These are then multiplied, in both orders (",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`a*b\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b*a\)]],
  StyleBox[").",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = First[ToCycles[RandomPermutation[6]]]\), 
    \(b = First[ToCycles[RandomPermutation[6]]]\), 
    \(MultiplyCycles[a, b]\), 
    \(MultiplyCycles[b, a]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q8",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Keep evaluating this code until you can make a conjecture regarding when \
two cycles will commute. (Evaluate it five times at a minimum.)",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s pick a cycle from some permutation in ",
    Evaluatable->False,
    AspectRatioFixed->True],
  Cell[BoxData[
      \(TraditionalForm\`S\_6\)]],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(a = First[ToCycles[RandomPermutation[6]]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "What is the order of this element? (Recall that the order of an element ",
  Cell[BoxData[
      \(TraditionalForm\`g\)]],
  " in a finite group ",
  Cell[BoxData[
      \(TraditionalForm\`G\)]],
  " is the least positive integer ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " such that ",
  Cell[BoxData[
      \(TraditionalForm\`g\^n\)]],
  " is the identity of the group. In ",
  Cell[BoxData[
      \(TraditionalForm\`S\_6\)]],
  ", the identity is {1, 2, 3, 4, 5, 6}.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(OrderOfElement[S[6], ToPermutation[a, 6]]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData["Let\[CloseCurlyQuote]s try it again."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = First[ToCycles[RandomPermutation[6]]]\), 
    \(OrderOfElement[S[6], ToPermutation[a, 6]]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q9",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Keep evaluating this code until you can make a conjecture regarding the \
order of a cycle. How might a proof go?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Now that we know how to find the order of any cycle, and we know that all \
permutations can be written as a product of disjoint cycles, let\
\[CloseCurlyQuote]s see if we can determine the order of an arbitrary \
permutation."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p\  = \ RandomPermutation[7]\), 
    \(ToCycles[p]\), 
    \(OrderOfElement[S[7], \ p]\n (*\ read\ the\ following\ question\ *) 
      \)}], "Input"],

Cell[TextData[{
  StyleBox["Q10",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[". Why do you think this first warning message is given?",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["We try again, following the instructions.", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = RandomPermutation[7]\), 
    \(ToCycles[p]\), 
    \(OrderOfElement[S[7, IndexLimit \[Rule] 7], p]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q11",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Keep evaluating this code until you can make a conjecture regarding the \
order of a permutation. Make sure you get some permutations with two or more \
cycles before forming a conjecture.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Now we want to think about permutations in terms of 2-cycles (not to be \
confused with bicycles",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[LongDash]",
  StyleBox["here we mean cycles of length two), which are also called ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["transpositions",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[".",
    Evaluatable->False,
    AspectRatioFixed->True],
  " Before continuing on that thread, an observation needs to be made, if not \
already observed. Note that when a permutation is given in cycle notation, \
sometimes singleton cycles (cycles of length 1) show up."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ToCycles[{2, 1, 3}]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "In this case, the permutation can really be thought of just as the \
transposition ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, \ 2)\)\)]],
  " since the 1-cycle ",
  Cell[BoxData[
      \(TraditionalForm\`\((3)\)\)]],
  " really acts like the identity permutation\[LongDash]the three goes to \
itself and everything is fixed! Keep this in mind as we continue."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
First we pick a random permutation, convert it to cycles, and pick \
one of the cycles at random. The code in the next cell might look a little \
confusing, but it is set up to give a cycle with length at least three.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(long = False; \)\), 
    \(While[\(\[InvisibleSpace]! long\), 
      a = First[Randomize[ToCycles[p = RandomPermutation[7]]]]; 
      long = Length[a] \[GreaterEqual] 3]\), 
    \(a\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "Now we convert this cycle to a product of transpositions. It is important \
to note that these transpositions are ",
  StyleBox["not",
    FontSlant->"Italic"],
  " disjoint."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(transp = ToTranspositions[a]\)], "Input",
  AspectRatioFixed->True],

Cell["If we multiply these cycles together,", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MultiplyCycles[transp]\)], "Input",
  AspectRatioFixed->True],

Cell["\<\
we get a permutation as the output, so we can convert it back to \
cycle notation.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(ToCycles[%]\)], "Input",
  AspectRatioFixed->True],

Cell[TextData[
"This should be where we started out. Therefore, converting to transpositions \
is a safe operation and one that can be undone by multiplying them out. What \
can be obtained by writing a cycle as a product of transpositions? Let\
\[CloseCurlyQuote]s pick two random cycles from two random permutations, \
convert them to a product of transpositions, and look at the number of \
transpositions obtained from each cycle."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(a = First[Randomize[ToCycles[RandomPermutation[7]]]]\), 
    \(b = First[Randomize[ToCycles[RandomPermutation[7]]]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(transpa = ToTranspositions[a]\), 
    \(transpb = ToTranspositions[b]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Length[transpa]\), 
    \(Length[transpb]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox[
  "Next, we form the product of the two cycles we found and convert it back \
to cycle notation. We want to convert this list of cycles to transpositions, \
so we apply the function ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["ToTranspositions",
    FontFamily->"Courier"],
  StyleBox[
  " to each cycle in the list (this is what the second line does). Since this \
result has extra levels of {}",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox[
  "s, we \[OpenCurlyDoubleQuote]flatten\[CloseCurlyDoubleQuote] out the \
unnecessary levels and then count how many are in the list.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(ToCycles[MultiplyCycles[a, \ b]]\), 
    \(Map[ToTranspositions, \ %]\)}], "Input"],

Cell[BoxData[{
    \(Flatten[%, 1]\), 
    \(Length[%]\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\
Compare this length with the two lengths above it. We look at this \
process again, this time suppressing all output except the counts.\
\>", 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(a = First[Randomize[ToCycles[RandomPermutation[7]]]]; \)\), 
    \(\(b = First[Randomize[ToCycles[RandomPermutation[7]]]]; \)\), 
    \(\(transpa = ToTranspositions[a]; \)\), 
    \(\(transpb = ToTranspositions[b]; \)\), 
    \(Length[transpa]\), 
    \(Length[transpb]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(prodCyc\  = \ ToCycles[MultiplyCycles[a, \ b]]; \n
    trans\  = \ Map[ToTranspositions, \ prodCyc]; \n
    Flatten[trans, \ 1] // Length\)], "Input"],

Cell["\<\
The first value is the number of transpositions in the first cycle, \
the second value is the number of transpositions in the second cycle, and the \
third value is the number of transpositions in the product of the two cycles.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q12",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Keep evaluating this code until you can make a conjecture regarding a \
relationship between the number of transpositions in the product (the last \
number) and the number of transpositions in the two factors. Hint: Do not try \
to be too specific.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["There is another function we can apply to permutations, the ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["Parity",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[" function. Let",
    Evaluatable->False,
    AspectRatioFixed->True],
  "\[CloseCurlyQuote]",
  StyleBox["s see how this works.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(p = RandomPermutation[7]\), 
    \(ToTranspositions[p]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(Length[%]\), 
    \(Parity[p]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q13",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Keep evaluating this code until you can make a conjecture regarding a \
relationship between the number of transpositions in a permutation and its \
parity.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Now let\[CloseCurlyQuote]s resume our pursuit that preceded question 12. \
Here we pick random cycles ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", form the product, and call it ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ". We convert each of these to transpositions and count them; the first \
triple is the number of transpositions of each in the list ",
  Cell[BoxData[
      \(TraditionalForm\`{a, b, p}\)]],
  ". Then we also calculate the parity of each, reflected in the second \
triple."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\(a = First[Randomize[ToCycles[RandomPermutation[7]]]]; \)\), 
    \(\(b = First[Randomize[ToCycles[RandomPermutation[7]]]]; \)\), 
    \(\(transpa = ToTranspositions[a]; \)\), 
    \(\(transpb = ToTranspositions[b]; \)\), 
    \(\(p = MultiplyCycles[a, b]; \)\), 
    \(\(ToTranspositions[p]; \)\), 
    \({Length[transpa], Length[transpb], Length[%]}\), 
    \({Parity[ToPermutation[a, 7]], Parity[ToPermutation[b, 7]], Parity[p]}
      \)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "The output is {# transpositions in ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", # transpositions in ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", # transpositions in ",
  Cell[BoxData[
      \(TraditionalForm\`a*b\)]],
  "} followed by {parity of ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", parity of ",
  Cell[BoxData[
      \(TraditionalForm\`b\)]],
  ", parity of ",
  Cell[BoxData[
      \(TraditionalForm\`a*b\)]],
  "}."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q14",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Keep evaluating this code until you can make a conjecture regarding a \
relationship between the parity of a product and the parity of its factors. \
Now go back to questions 12 and 13 and see if you have any changes to make; \
if so, state them here.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["A permutation with parity 1 is called an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["even permutation",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" and if the parity is -1, we call it an ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["odd permutation. ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox["Two functions test evenness and oddness of permutations.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(p = RandomPermutation[6]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[{
    \(OddPermutationQ[p]\), 
    \(EvenPermutationQ[p]\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Q15",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontWeight->"Bold"],
  StyleBox[
  ". Using your knowledge about sums of odd and even integers and how \
products result from various combinations of -1 and 1, do you see any \
connection between parity and the number of transpositions? If you do, state \
it.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Question",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Answer: ", "Answer",
  Evaluatable->False,
  CellLabelMargins->{{5, Inherited}, {Inherited, Inherited}},
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "7.7 ",
  StyleBox["Mathematica",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontSlant->"Italic"],
  StyleBox[" commands used in this lab",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"a:7.15.7"],

Cell[TextData[{
  "If you wish to learn more about how to use the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands or functions used in this lab, type ? followed by the command. \
Following are some functions used in this lab that may be useful for later \
work."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["?PermutationMatrix", "Input",
  AspectRatioFixed->True],

Cell["?MultiplyPermutations", "Input",
  AspectRatioFixed->True],

Cell["?ToCycles", "Input",
  AspectRatioFixed->True],

Cell["?FromCycles", "Input",
  AspectRatioFixed->True],

Cell["?ToPermutation", "Input",
  AspectRatioFixed->True],

Cell["?MultiplyCycles", "Input",
  AspectRatioFixed->True],

Cell["?RandomPermutation", "Input",
  AspectRatioFixed->True],

Cell["?OrderOfElement", "Input",
  AspectRatioFixed->True],

Cell["?S", "Input",
  AspectRatioFixed->True],

Cell["?Length", "Input",
  AspectRatioFixed->True],

Cell["?ToTranspositions", "Input",
  AspectRatioFixed->True],

Cell["?Parity", "Input",
  AspectRatioFixed->True],

Cell["?ToTranspositions", "Input",
  AspectRatioFixed->True],

Cell["?OddPermutationQ", "Input",
  AspectRatioFixed->True],

Cell["?EvenPermutationQ", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 800}, {0, 580}},
AutoGeneratedPackage->None,
WindowToolbars->"EditBar",
InitializationCellLoading->True,
WindowSize->{624, 424},
WindowMargins->{{4, Automatic}, {Automatic, 3}},
PrintingCopies->1,
PrintingPageRange->{3, 8},
PageHeaders->{{Cell[ 
        TextData[ {
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"], "  ", 
          StyleBox[ "Groups", FontSlant -> "Italic"]}], "Text"], Inherited, 
      None}, {None, Inherited, Cell[ 
        TextData[ {
          StyleBox[ "Lab 7 Permutations", FontSlant -> "Italic"], "  ", 
          StyleBox[ 
            CounterBox[ "Page"], FontWeight -> "Bold"]}], "Text"]}},
PageHeaderLines->{False, False},
PrintingOptions->{"FirstPageHeader"->False,
"FirstPageFooter"->False,
"FacingPages"->True},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowGroupOpenCloseIcon->True,
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
StyleDefinitions -> "EAAM.nb",
MacintoshSystemPageSetup->"\<\
00<0004/0B`000002mT8o?mooh<<HPUi0fL5:0?l0080004/0B`000000]P2:001
0000I00000400`<300000BL?00400@AjEX0000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "a:7.7"->{
    Cell[2382, 76, 161, 7, 99, "Title",
      Evaluatable->False,
      CellTags->"a:7.7"]},
  "a:7.8.7"->{
    Cell[2568, 87, 323, 11, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.8.7"]},
  "a:7.9.7"->{
    Cell[7091, 240, 107, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.9.7"]},
  "a:7.10.7"->{
    Cell[7542, 256, 100, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.10.7"]},
  "a:7.11.7"->{
    Cell[8002, 273, 117, 3, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.11.7"]},
  "a:7.12.7"->{
    Cell[14870, 514, 125, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.12.7"]},
  "a:7.13.7"->{
    Cell[30156, 1072, 123, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.13.7"]},
  "a:7.14.7"->{
    Cell[36438, 1304, 123, 3, 55, "Section",
      Evaluatable->False,
      CellTags->"a:7.14.7"]},
  "a:7.15.7"->{
    Cell[59721, 2160, 309, 12, 35, "Section",
      Evaluatable->False,
      CellTags->"a:7.15.7"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"a:7.7", 62996, 2278},
  {"a:7.8.7", 63104, 2282},
  {"a:7.9.7", 63217, 2286},
  {"a:7.10.7", 63331, 2290},
  {"a:7.11.7", 63446, 2294},
  {"a:7.12.7", 63561, 2298},
  {"a:7.13.7", 63677, 2302},
  {"a:7.14.7", 63794, 2306},
  {"a:7.15.7", 63911, 2310}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 75, 2, 47, "Answer",
  Evaluatable->False],
Cell[1787, 53, 570, 19, 89, "Subsubtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2382, 76, 161, 7, 99, "Title",
  Evaluatable->False,
  CellTags->"a:7.7"],

Cell[CellGroupData[{
Cell[2568, 87, 323, 11, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.8.7"],
Cell[2894, 100, 874, 23, 109, "Text",
  Evaluatable->False],
Cell[3771, 125, 1393, 41, 109, "Text",
  Evaluatable->False],
Cell[5167, 168, 175, 4, 33, "Text",
  Evaluatable->False],
Cell[5345, 174, 645, 21, 90, "Text",
  Evaluatable->False],
Cell[5993, 197, 715, 25, 90, "Text",
  Evaluatable->False],
Cell[6711, 224, 343, 11, 67, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7091, 240, 107, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.9.7"],
Cell[7201, 245, 304, 6, 52, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[7542, 256, 100, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.10.7"],
Cell[7645, 261, 320, 7, 71, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[8002, 273, 117, 3, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.11.7"],
Cell[8122, 278, 378, 13, 33, "Text",
  Evaluatable->False],
Cell[8503, 293, 172, 4, 43, "Input",
  InitializationCell->True],
Cell[8678, 299, 153, 5, 33, "Text",
  Evaluatable->False],
Cell[8834, 306, 88, 2, 27, "Input"],
Cell[8925, 310, 350, 6, 71, "Text",
  Evaluatable->False],
Cell[9278, 318, 162, 3, 27, "Input"],
Cell[9443, 323, 2503, 87, 128, "Text",
  Evaluatable->False],
Cell[11949, 412, 152, 3, 27, "Input"],
Cell[12104, 417, 352, 7, 71, "Text",
  Evaluatable->False],
Cell[12459, 426, 2374, 83, 128, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[14870, 514, 125, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.12.7"],
Cell[14998, 519, 97, 2, 33, "Text",
  Evaluatable->False],
Cell[15098, 523, 228, 5, 43, "Input"],
Cell[15329, 530, 105, 2, 33, "Text",
  Evaluatable->False],
Cell[15437, 534, 112, 3, 43, "Input"],
Cell[15552, 539, 424, 16, 52, "Text",
  Evaluatable->False],
Cell[15979, 557, 83, 2, 27, "Input"],
Cell[16065, 561, 2302, 80, 128, "Text",
  Evaluatable->False],
Cell[18370, 643, 104, 2, 27, "Input"],
Cell[18477, 647, 3003, 103, 105, "Question",
  Evaluatable->False],
Cell[21483, 752, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[21560, 756, 196, 7, 33, "Text",
  Evaluatable->False],
Cell[21759, 765, 79, 2, 27, "Input"],
Cell[21841, 769, 497, 11, 90, "Text",
  Evaluatable->False],
Cell[22341, 782, 136, 3, 27, "Input"],
Cell[22480, 787, 535, 20, 48, "Question",
  Evaluatable->False],
Cell[23018, 809, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[23095, 813, 152, 5, 33, "Text",
  Evaluatable->False],
Cell[23250, 820, 125, 3, 43, "Input"],
Cell[23378, 825, 4399, 154, 242, "Text",
  Evaluatable->False],
Cell[27780, 981, 70, 2, 27, "Input"],
Cell[27853, 985, 92, 2, 33, "Text",
  Evaluatable->False],
Cell[27948, 989, 72, 2, 27, "Input"],
Cell[28023, 993, 318, 10, 52, "Text",
  Evaluatable->False],
Cell[28344, 1005, 123, 2, 43, "Input"],
Cell[28470, 1009, 208, 4, 59, "Input"],
Cell[28681, 1015, 222, 6, 52, "Text",
  Evaluatable->False],
Cell[28906, 1023, 1136, 40, 86, "Question",
  Evaluatable->False],
Cell[30045, 1065, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[30156, 1072, 123, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.13.7"],
Cell[30282, 1077, 182, 5, 52, "Text",
  Evaluatable->False],
Cell[30467, 1084, 101, 2, 27, "Input"],
Cell[30571, 1088, 1056, 34, 90, "Text",
  Evaluatable->False],
Cell[31630, 1124, 70, 2, 27, "Input"],
Cell[31703, 1128, 512, 15, 71, "Text",
  Evaluatable->False],
Cell[32218, 1145, 101, 2, 27, "Input"],
Cell[32322, 1149, 75, 0, 33, "Text"],
Cell[32400, 1151, 54, 1, 27, "Input"],
Cell[32457, 1154, 864, 31, 67, "Question",
  Evaluatable->False],
Cell[33324, 1187, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[33401, 1191, 195, 4, 52, "Text",
  Evaluatable->False],
Cell[33599, 1197, 157, 4, 27, "Input"],
Cell[33759, 1203, 88, 2, 33, "Text",
  Evaluatable->False],
Cell[33850, 1207, 75, 2, 27, "Input"],
Cell[33928, 1211, 93, 2, 33, "Text",
  Evaluatable->False],
Cell[34024, 1215, 77, 2, 27, "Input"],
Cell[34104, 1219, 666, 11, 128, "Text",
  Evaluatable->False],
Cell[34773, 1232, 369, 13, 52, "Text",
  Evaluatable->False],
Cell[35145, 1247, 71, 2, 27, "Input"],
Cell[35219, 1251, 501, 18, 33, "Text",
  Evaluatable->False],
Cell[35723, 1271, 78, 2, 27, "Input"],
Cell[35804, 1275, 520, 20, 48, "Question",
  Evaluatable->False],
Cell[36327, 1297, 74, 2, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[36438, 1304, 123, 3, 55, "Section",
  Evaluatable->False,
  CellTags->"a:7.14.7"],
Cell[36564, 1309, 99, 2, 33, "Text",
  Evaluatable->False],
Cell[36666, 1313, 82, 2, 27, "Input"],
Cell[36751, 1317, 736, 26, 52, "Text",
  Evaluatable->False],
Cell[37490, 1345, 71, 2, 27, "Input"],
Cell[37564, 1349, 314, 13, 33, "Text",
  Evaluatable->False],
Cell[37881, 1364, 83, 2, 27, "Input"],
Cell[37967, 1368, 210, 6, 52, "Text",
  Evaluatable->False],
Cell[38180, 1376, 140, 4, 59, "Input"],
Cell[38323, 1382, 540, 19, 52, "Text",
  Evaluatable->False],
Cell[38866, 1403, 104, 3, 43, "Input"],
Cell[38973, 1408, 154, 5, 33, "Text",
  Evaluatable->False],
Cell[39130, 1415, 51, 1, 27, "Input"],
Cell[39184, 1418, 702, 27, 33, "Text",
  Evaluatable->False],
Cell[39889, 1447, 112, 3, 43, "Input"],
Cell[40004, 1452, 133, 3, 33, "Text",
  Evaluatable->False],
Cell[40140, 1457, 60, 2, 43, "Input"],
Cell[40203, 1461, 289, 7, 71, "Text",
  Evaluatable->False],
Cell[40495, 1470, 109, 3, 43, "Input"],
Cell[40607, 1475, 505, 17, 67, "Question",
  Evaluatable->False],
Cell[41115, 1494, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[41192, 1498, 238, 9, 33, "Text",
  Evaluatable->False],
Cell[41433, 1509, 87, 2, 27, "Input"],
Cell[41523, 1513, 122, 2, 33, "Text",
  Evaluatable->False],
Cell[41648, 1517, 79, 2, 27, "Input"],
Cell[41730, 1521, 293, 6, 52, "Text",
  Evaluatable->False],
Cell[42026, 1529, 70, 2, 27, "Input"],
Cell[42099, 1533, 1113, 41, 67, "Question",
  Evaluatable->False],
Cell[43215, 1576, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[43292, 1580, 62, 0, 33, "Text"],
Cell[43357, 1582, 106, 2, 43, "Input"],
Cell[43466, 1586, 108, 2, 43, "Input"],
Cell[43577, 1590, 872, 30, 71, "Text",
  Evaluatable->False],
Cell[44452, 1622, 216, 5, 75, "Input"],
Cell[44671, 1629, 383, 12, 67, "Question",
  Evaluatable->False],
Cell[45057, 1643, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[45134, 1647, 397, 15, 33, "Text",
  Evaluatable->False],
Cell[45534, 1664, 100, 2, 27, "Input"],
Cell[45637, 1668, 561, 19, 71, "Text",
  Evaluatable->False],
Cell[46201, 1689, 100, 2, 27, "Input"],
Cell[46304, 1693, 110, 2, 33, "Text",
  Evaluatable->False],
Cell[46417, 1697, 154, 3, 43, "Input"],
Cell[46574, 1702, 358, 12, 67, "Question",
  Evaluatable->False],
Cell[46935, 1716, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[47012, 1720, 301, 6, 71, "Text",
  Evaluatable->False],
Cell[47316, 1728, 170, 4, 75, "Input"],
Cell[47489, 1734, 296, 10, 48, "Question",
  Evaluatable->False],
Cell[47788, 1746, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[47865, 1750, 105, 2, 33, "Text",
  Evaluatable->False],
Cell[47973, 1754, 163, 4, 59, "Input"],
Cell[48139, 1760, 434, 13, 86, "Question",
  Evaluatable->False],
Cell[48576, 1775, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[48653, 1779, 776, 22, 109, "Text",
  Evaluatable->False],
Cell[49432, 1803, 78, 2, 27, "Input"],
Cell[49513, 1807, 445, 12, 71, "Text",
  Evaluatable->False],
Cell[49961, 1821, 292, 7, 71, "Text",
  Evaluatable->False],
Cell[50256, 1830, 244, 6, 91, "Input"],
Cell[50503, 1838, 254, 8, 52, "Text",
  Evaluatable->False],
Cell[50760, 1848, 87, 2, 27, "Input"],
Cell[50850, 1852, 101, 2, 33, "Text",
  Evaluatable->False],
Cell[50954, 1856, 81, 2, 27, "Input"],
Cell[51038, 1860, 154, 5, 33, "Text",
  Evaluatable->False],
Cell[51195, 1867, 70, 2, 27, "Input"],
Cell[51268, 1871, 493, 8, 109, "Text",
  Evaluatable->False],
Cell[51764, 1881, 176, 3, 43, "Input"],
Cell[51943, 1886, 130, 3, 43, "Input"],
Cell[52076, 1891, 102, 3, 43, "Input"],
Cell[52181, 1896, 785, 22, 109, "Text",
  Evaluatable->False],
Cell[52969, 1920, 104, 2, 43, "Input"],
Cell[53076, 1924, 94, 3, 43, "Input"],
Cell[53173, 1929, 210, 6, 52, "Text",
  Evaluatable->False],
Cell[53386, 1937, 332, 7, 107, "Input"],
Cell[53721, 1946, 170, 3, 59, "Input"],
Cell[53894, 1951, 301, 7, 71, "Text",
  Evaluatable->False],
Cell[54198, 1960, 494, 14, 86, "Question",
  Evaluatable->False],
Cell[54695, 1976, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[54772, 1980, 498, 17, 52, "Text",
  Evaluatable->False],
Cell[55273, 1999, 115, 3, 43, "Input"],
Cell[55391, 2004, 90, 3, 43, "Input"],
Cell[55484, 2009, 402, 13, 67, "Question",
  Evaluatable->False],
Cell[55889, 2024, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[55966, 2028, 653, 19, 90, "Text",
  Evaluatable->False],
Cell[56622, 2049, 500, 10, 155, "Input"],
Cell[57125, 2061, 538, 22, 52, "Text",
  Evaluatable->False],
Cell[57666, 2085, 497, 14, 86, "Question",
  Evaluatable->False],
Cell[58166, 2101, 74, 2, 47, "Answer",
  Evaluatable->False],
Cell[58243, 2105, 634, 20, 52, "Text",
  Evaluatable->False],
Cell[58880, 2127, 83, 2, 27, "Input"],
Cell[58966, 2131, 109, 3, 43, "Input"],
Cell[59078, 2136, 467, 14, 86, "Question",
  Evaluatable->False],
Cell[59548, 2152, 136, 3, 47, "Answer",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[59721, 2160, 309, 12, 35, "Section",
  Evaluatable->False,
  CellTags->"a:7.15.7"],
Cell[60033, 2174, 342, 9, 71, "Text",
  Evaluatable->False],
Cell[60378, 2185, 61, 1, 27, "Input"],
Cell[60442, 2188, 64, 1, 27, "Input"],
Cell[60509, 2191, 52, 1, 27, "Input"],
Cell[60564, 2194, 54, 1, 27, "Input"],
Cell[60621, 2197, 57, 1, 27, "Input"],
Cell[60681, 2200, 58, 1, 27, "Input"],
Cell[60742, 2203, 61, 1, 27, "Input"],
Cell[60806, 2206, 58, 1, 27, "Input"],
Cell[60867, 2209, 45, 1, 27, "Input"],
Cell[60915, 2212, 50, 1, 27, "Input"],
Cell[60968, 2215, 60, 1, 27, "Input"],
Cell[61031, 2218, 50, 1, 27, "Input"],
Cell[61084, 2221, 60, 1, 27, "Input"],
Cell[61147, 2224, 59, 1, 27, "Input"],
Cell[61209, 2227, 60, 1, 27, "Input"]
}, Closed]]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

